// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`ActivateAnomalyDetectorInput`](crate::input::ActivateAnomalyDetectorInput)
pub mod activate_anomaly_detector_input {
    /// A builder for [`ActivateAnomalyDetectorInput`](crate::input::ActivateAnomalyDetectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the anomaly detector.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the anomaly detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ActivateAnomalyDetectorInput`](crate::input::ActivateAnomalyDetectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ActivateAnomalyDetectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ActivateAnomalyDetectorInput {
                anomaly_detector_arn: self.anomaly_detector_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ActivateAnomalyDetectorInputOperationOutputAlias =
    crate::operation::ActivateAnomalyDetector;
#[doc(hidden)]
pub type ActivateAnomalyDetectorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ActivateAnomalyDetectorInput {
    /// Consumes the builder and constructs an Operation<[`ActivateAnomalyDetector`](crate::operation::ActivateAnomalyDetector)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ActivateAnomalyDetector,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ActivateAnomalyDetectorInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/ActivateAnomalyDetector").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ActivateAnomalyDetectorInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_activate_anomaly_detector(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ActivateAnomalyDetector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ActivateAnomalyDetector",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ActivateAnomalyDetectorInput`](crate::input::ActivateAnomalyDetectorInput)
    pub fn builder() -> crate::input::activate_anomaly_detector_input::Builder {
        crate::input::activate_anomaly_detector_input::Builder::default()
    }
}

/// See [`BackTestAnomalyDetectorInput`](crate::input::BackTestAnomalyDetectorInput)
pub mod back_test_anomaly_detector_input {
    /// A builder for [`BackTestAnomalyDetectorInput`](crate::input::BackTestAnomalyDetectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`BackTestAnomalyDetectorInput`](crate::input::BackTestAnomalyDetectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BackTestAnomalyDetectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BackTestAnomalyDetectorInput {
                anomaly_detector_arn: self.anomaly_detector_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type BackTestAnomalyDetectorInputOperationOutputAlias =
    crate::operation::BackTestAnomalyDetector;
#[doc(hidden)]
pub type BackTestAnomalyDetectorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BackTestAnomalyDetectorInput {
    /// Consumes the builder and constructs an Operation<[`BackTestAnomalyDetector`](crate::operation::BackTestAnomalyDetector)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BackTestAnomalyDetector,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::BackTestAnomalyDetectorInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/BackTestAnomalyDetector").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::BackTestAnomalyDetectorInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_back_test_anomaly_detector(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BackTestAnomalyDetector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BackTestAnomalyDetector",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`BackTestAnomalyDetectorInput`](crate::input::BackTestAnomalyDetectorInput)
    pub fn builder() -> crate::input::back_test_anomaly_detector_input::Builder {
        crate::input::back_test_anomaly_detector_input::Builder::default()
    }
}

/// See [`CreateAlertInput`](crate::input::CreateAlertInput)
pub mod create_alert_input {
    /// A builder for [`CreateAlertInput`](crate::input::CreateAlertInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alert_name: std::option::Option<std::string::String>,
        pub(crate) alert_sensitivity_threshold: std::option::Option<i32>,
        pub(crate) alert_description: std::option::Option<std::string::String>,
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
        pub(crate) action: std::option::Option<crate::model::Action>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the alert.</p>
        pub fn alert_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alert_name = Some(input.into());
            self
        }
        /// <p>The name of the alert.</p>
        pub fn set_alert_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alert_name = input;
            self
        }
        /// <p>An integer from 0 to 100 specifying the alert sensitivity threshold.</p>
        pub fn alert_sensitivity_threshold(mut self, input: i32) -> Self {
            self.alert_sensitivity_threshold = Some(input);
            self
        }
        /// <p>An integer from 0 to 100 specifying the alert sensitivity threshold.</p>
        pub fn set_alert_sensitivity_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.alert_sensitivity_threshold = input;
            self
        }
        /// <p>A description of the alert.</p>
        pub fn alert_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.alert_description = Some(input.into());
            self
        }
        /// <p>A description of the alert.</p>
        pub fn set_alert_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alert_description = input;
            self
        }
        /// <p>The ARN of the detector to which the alert is attached.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the detector to which the alert is attached.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// <p>Action that will be triggered when there is an alert.</p>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Action that will be triggered when there is an alert.</p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.action = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply to the alert.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply to the alert.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAlertInput`](crate::input::CreateAlertInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAlertInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAlertInput {
                alert_name: self.alert_name,
                alert_sensitivity_threshold: self.alert_sensitivity_threshold.unwrap_or_default(),
                alert_description: self.alert_description,
                anomaly_detector_arn: self.anomaly_detector_arn,
                action: self.action,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAlertInputOperationOutputAlias = crate::operation::CreateAlert;
#[doc(hidden)]
pub type CreateAlertInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAlertInput {
    /// Consumes the builder and constructs an Operation<[`CreateAlert`](crate::operation::CreateAlert)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAlert,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateAlertInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/CreateAlert").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateAlertInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_alert(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAlert::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAlert",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateAlertInput`](crate::input::CreateAlertInput)
    pub fn builder() -> crate::input::create_alert_input::Builder {
        crate::input::create_alert_input::Builder::default()
    }
}

/// See [`CreateAnomalyDetectorInput`](crate::input::CreateAnomalyDetectorInput)
pub mod create_anomaly_detector_input {
    /// A builder for [`CreateAnomalyDetectorInput`](crate::input::CreateAnomalyDetectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_detector_name: std::option::Option<std::string::String>,
        pub(crate) anomaly_detector_description: std::option::Option<std::string::String>,
        pub(crate) anomaly_detector_config:
            std::option::Option<crate::model::AnomalyDetectorConfig>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the detector.</p>
        pub fn anomaly_detector_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_name = Some(input.into());
            self
        }
        /// <p>The name of the detector.</p>
        pub fn set_anomaly_detector_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_name = input;
            self
        }
        /// <p>A description of the detector.</p>
        pub fn anomaly_detector_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.anomaly_detector_description = Some(input.into());
            self
        }
        /// <p>A description of the detector.</p>
        pub fn set_anomaly_detector_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_description = input;
            self
        }
        /// <p>Contains information about the configuration of the anomaly detector.</p>
        pub fn anomaly_detector_config(
            mut self,
            input: crate::model::AnomalyDetectorConfig,
        ) -> Self {
            self.anomaly_detector_config = Some(input);
            self
        }
        /// <p>Contains information about the configuration of the anomaly detector.</p>
        pub fn set_anomaly_detector_config(
            mut self,
            input: std::option::Option<crate::model::AnomalyDetectorConfig>,
        ) -> Self {
            self.anomaly_detector_config = input;
            self
        }
        /// <p>The ARN of the KMS key to use to encrypt your data.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the KMS key to use to encrypt your data.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply to the anomaly detector.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply to the anomaly detector.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAnomalyDetectorInput`](crate::input::CreateAnomalyDetectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAnomalyDetectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAnomalyDetectorInput {
                anomaly_detector_name: self.anomaly_detector_name,
                anomaly_detector_description: self.anomaly_detector_description,
                anomaly_detector_config: self.anomaly_detector_config,
                kms_key_arn: self.kms_key_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAnomalyDetectorInputOperationOutputAlias = crate::operation::CreateAnomalyDetector;
#[doc(hidden)]
pub type CreateAnomalyDetectorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAnomalyDetectorInput {
    /// Consumes the builder and constructs an Operation<[`CreateAnomalyDetector`](crate::operation::CreateAnomalyDetector)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAnomalyDetector,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateAnomalyDetectorInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/CreateAnomalyDetector").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateAnomalyDetectorInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_anomaly_detector(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAnomalyDetector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAnomalyDetector",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateAnomalyDetectorInput`](crate::input::CreateAnomalyDetectorInput)
    pub fn builder() -> crate::input::create_anomaly_detector_input::Builder {
        crate::input::create_anomaly_detector_input::Builder::default()
    }
}

/// See [`CreateMetricSetInput`](crate::input::CreateMetricSetInput)
pub mod create_metric_set_input {
    /// A builder for [`CreateMetricSetInput`](crate::input::CreateMetricSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
        pub(crate) metric_set_name: std::option::Option<std::string::String>,
        pub(crate) metric_set_description: std::option::Option<std::string::String>,
        pub(crate) metric_list: std::option::Option<std::vec::Vec<crate::model::Metric>>,
        pub(crate) offset: std::option::Option<i32>,
        pub(crate) timestamp_column: std::option::Option<crate::model::TimestampColumn>,
        pub(crate) dimension_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) metric_set_frequency: std::option::Option<crate::model::Frequency>,
        pub(crate) metric_source: std::option::Option<crate::model::MetricSource>,
        pub(crate) timezone: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the anomaly detector that will use the dataset.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the anomaly detector that will use the dataset.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// <p>The name of the dataset.</p>
        pub fn metric_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_set_name = Some(input.into());
            self
        }
        /// <p>The name of the dataset.</p>
        pub fn set_metric_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_set_name = input;
            self
        }
        /// <p>A description of the dataset you are creating.</p>
        pub fn metric_set_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_set_description = Some(input.into());
            self
        }
        /// <p>A description of the dataset you are creating.</p>
        pub fn set_metric_set_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_set_description = input;
            self
        }
        /// Appends an item to `metric_list`.
        ///
        /// To override the contents of this collection use [`set_metric_list`](Self::set_metric_list).
        ///
        /// <p>A list of metrics that the dataset will contain.</p>
        pub fn metric_list(mut self, input: crate::model::Metric) -> Self {
            let mut v = self.metric_list.unwrap_or_default();
            v.push(input);
            self.metric_list = Some(v);
            self
        }
        /// <p>A list of metrics that the dataset will contain.</p>
        pub fn set_metric_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Metric>>,
        ) -> Self {
            self.metric_list = input;
            self
        }
        /// <p>After an interval ends, the amount of seconds that the detector waits before importing data. Offset is only supported for S3 and Redshift datasources.</p>
        pub fn offset(mut self, input: i32) -> Self {
            self.offset = Some(input);
            self
        }
        /// <p>After an interval ends, the amount of seconds that the detector waits before importing data. Offset is only supported for S3 and Redshift datasources.</p>
        pub fn set_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.offset = input;
            self
        }
        /// <p>Contains information about the column used for tracking time in your source data.</p>
        pub fn timestamp_column(mut self, input: crate::model::TimestampColumn) -> Self {
            self.timestamp_column = Some(input);
            self
        }
        /// <p>Contains information about the column used for tracking time in your source data.</p>
        pub fn set_timestamp_column(
            mut self,
            input: std::option::Option<crate::model::TimestampColumn>,
        ) -> Self {
            self.timestamp_column = input;
            self
        }
        /// Appends an item to `dimension_list`.
        ///
        /// To override the contents of this collection use [`set_dimension_list`](Self::set_dimension_list).
        ///
        /// <p>A list of the fields you want to treat as dimensions.</p>
        pub fn dimension_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dimension_list.unwrap_or_default();
            v.push(input.into());
            self.dimension_list = Some(v);
            self
        }
        /// <p>A list of the fields you want to treat as dimensions.</p>
        pub fn set_dimension_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dimension_list = input;
            self
        }
        /// <p>The frequency with which the source data will be analyzed for anomalies.</p>
        pub fn metric_set_frequency(mut self, input: crate::model::Frequency) -> Self {
            self.metric_set_frequency = Some(input);
            self
        }
        /// <p>The frequency with which the source data will be analyzed for anomalies.</p>
        pub fn set_metric_set_frequency(
            mut self,
            input: std::option::Option<crate::model::Frequency>,
        ) -> Self {
            self.metric_set_frequency = input;
            self
        }
        /// <p>Contains information about how the source data should be interpreted.</p>
        pub fn metric_source(mut self, input: crate::model::MetricSource) -> Self {
            self.metric_source = Some(input);
            self
        }
        /// <p>Contains information about how the source data should be interpreted.</p>
        pub fn set_metric_source(
            mut self,
            input: std::option::Option<crate::model::MetricSource>,
        ) -> Self {
            self.metric_source = input;
            self
        }
        /// <p>The time zone in which your source data was recorded.</p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone = Some(input.into());
            self
        }
        /// <p>The time zone in which your source data was recorded.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timezone = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply to the dataset.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply to the dataset.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMetricSetInput`](crate::input::CreateMetricSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMetricSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMetricSetInput {
                anomaly_detector_arn: self.anomaly_detector_arn,
                metric_set_name: self.metric_set_name,
                metric_set_description: self.metric_set_description,
                metric_list: self.metric_list,
                offset: self.offset,
                timestamp_column: self.timestamp_column,
                dimension_list: self.dimension_list,
                metric_set_frequency: self.metric_set_frequency,
                metric_source: self.metric_source,
                timezone: self.timezone,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMetricSetInputOperationOutputAlias = crate::operation::CreateMetricSet;
#[doc(hidden)]
pub type CreateMetricSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateMetricSetInput {
    /// Consumes the builder and constructs an Operation<[`CreateMetricSet`](crate::operation::CreateMetricSet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMetricSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateMetricSetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/CreateMetricSet").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateMetricSetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_metric_set(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMetricSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMetricSet",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateMetricSetInput`](crate::input::CreateMetricSetInput)
    pub fn builder() -> crate::input::create_metric_set_input::Builder {
        crate::input::create_metric_set_input::Builder::default()
    }
}

/// See [`DeactivateAnomalyDetectorInput`](crate::input::DeactivateAnomalyDetectorInput)
pub mod deactivate_anomaly_detector_input {
    /// A builder for [`DeactivateAnomalyDetectorInput`](crate::input::DeactivateAnomalyDetectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeactivateAnomalyDetectorInput`](crate::input::DeactivateAnomalyDetectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeactivateAnomalyDetectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeactivateAnomalyDetectorInput {
                anomaly_detector_arn: self.anomaly_detector_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeactivateAnomalyDetectorInputOperationOutputAlias =
    crate::operation::DeactivateAnomalyDetector;
#[doc(hidden)]
pub type DeactivateAnomalyDetectorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeactivateAnomalyDetectorInput {
    /// Consumes the builder and constructs an Operation<[`DeactivateAnomalyDetector`](crate::operation::DeactivateAnomalyDetector)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeactivateAnomalyDetector,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeactivateAnomalyDetectorInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/DeactivateAnomalyDetector").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeactivateAnomalyDetectorInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_deactivate_anomaly_detector(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeactivateAnomalyDetector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeactivateAnomalyDetector",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeactivateAnomalyDetectorInput`](crate::input::DeactivateAnomalyDetectorInput)
    pub fn builder() -> crate::input::deactivate_anomaly_detector_input::Builder {
        crate::input::deactivate_anomaly_detector_input::Builder::default()
    }
}

/// See [`DeleteAlertInput`](crate::input::DeleteAlertInput)
pub mod delete_alert_input {
    /// A builder for [`DeleteAlertInput`](crate::input::DeleteAlertInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alert_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the alert to delete.</p>
        pub fn alert_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alert_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the alert to delete.</p>
        pub fn set_alert_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alert_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAlertInput`](crate::input::DeleteAlertInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAlertInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAlertInput {
                alert_arn: self.alert_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAlertInputOperationOutputAlias = crate::operation::DeleteAlert;
#[doc(hidden)]
pub type DeleteAlertInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAlertInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAlert`](crate::operation::DeleteAlert)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAlert,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteAlertInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/DeleteAlert").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteAlertInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_alert(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAlert::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAlert",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteAlertInput`](crate::input::DeleteAlertInput)
    pub fn builder() -> crate::input::delete_alert_input::Builder {
        crate::input::delete_alert_input::Builder::default()
    }
}

/// See [`DeleteAnomalyDetectorInput`](crate::input::DeleteAnomalyDetectorInput)
pub mod delete_anomaly_detector_input {
    /// A builder for [`DeleteAnomalyDetectorInput`](crate::input::DeleteAnomalyDetectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the detector to delete.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the detector to delete.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAnomalyDetectorInput`](crate::input::DeleteAnomalyDetectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAnomalyDetectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAnomalyDetectorInput {
                anomaly_detector_arn: self.anomaly_detector_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAnomalyDetectorInputOperationOutputAlias = crate::operation::DeleteAnomalyDetector;
#[doc(hidden)]
pub type DeleteAnomalyDetectorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAnomalyDetectorInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAnomalyDetector`](crate::operation::DeleteAnomalyDetector)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAnomalyDetector,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteAnomalyDetectorInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/DeleteAnomalyDetector").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteAnomalyDetectorInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_anomaly_detector(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAnomalyDetector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAnomalyDetector",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteAnomalyDetectorInput`](crate::input::DeleteAnomalyDetectorInput)
    pub fn builder() -> crate::input::delete_anomaly_detector_input::Builder {
        crate::input::delete_anomaly_detector_input::Builder::default()
    }
}

/// See [`DescribeAlertInput`](crate::input::DescribeAlertInput)
pub mod describe_alert_input {
    /// A builder for [`DescribeAlertInput`](crate::input::DescribeAlertInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alert_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the alert to describe.</p>
        pub fn alert_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alert_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the alert to describe.</p>
        pub fn set_alert_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alert_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAlertInput`](crate::input::DescribeAlertInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAlertInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAlertInput {
                alert_arn: self.alert_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAlertInputOperationOutputAlias = crate::operation::DescribeAlert;
#[doc(hidden)]
pub type DescribeAlertInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAlertInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAlert`](crate::operation::DescribeAlert)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAlert,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAlertInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/DescribeAlert").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAlertInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_alert(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAlert::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAlert",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAlertInput`](crate::input::DescribeAlertInput)
    pub fn builder() -> crate::input::describe_alert_input::Builder {
        crate::input::describe_alert_input::Builder::default()
    }
}

/// See [`DescribeAnomalyDetectionExecutionsInput`](crate::input::DescribeAnomalyDetectionExecutionsInput)
pub mod describe_anomaly_detection_executions_input {
    /// A builder for [`DescribeAnomalyDetectionExecutionsInput`](crate::input::DescribeAnomalyDetectionExecutionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
        pub(crate) timestamp: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// <p>The timestamp of the anomaly detection job.</p>
        pub fn timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.timestamp = Some(input.into());
            self
        }
        /// <p>The timestamp of the anomaly detection job.</p>
        pub fn set_timestamp(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The number of items to return in the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of items to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAnomalyDetectionExecutionsInput`](crate::input::DescribeAnomalyDetectionExecutionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAnomalyDetectionExecutionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAnomalyDetectionExecutionsInput {
                anomaly_detector_arn: self.anomaly_detector_arn,
                timestamp: self.timestamp,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAnomalyDetectionExecutionsInputOperationOutputAlias =
    crate::operation::DescribeAnomalyDetectionExecutions;
#[doc(hidden)]
pub type DescribeAnomalyDetectionExecutionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAnomalyDetectionExecutionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAnomalyDetectionExecutions`](crate::operation::DescribeAnomalyDetectionExecutions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAnomalyDetectionExecutions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAnomalyDetectionExecutionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/DescribeAnomalyDetectionExecutions")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAnomalyDetectionExecutionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_anomaly_detection_executions(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAnomalyDetectionExecutions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAnomalyDetectionExecutions",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAnomalyDetectionExecutionsInput`](crate::input::DescribeAnomalyDetectionExecutionsInput)
    pub fn builder() -> crate::input::describe_anomaly_detection_executions_input::Builder {
        crate::input::describe_anomaly_detection_executions_input::Builder::default()
    }
}

/// See [`DescribeAnomalyDetectorInput`](crate::input::DescribeAnomalyDetectorInput)
pub mod describe_anomaly_detector_input {
    /// A builder for [`DescribeAnomalyDetectorInput`](crate::input::DescribeAnomalyDetectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the detector to describe.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the detector to describe.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAnomalyDetectorInput`](crate::input::DescribeAnomalyDetectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAnomalyDetectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAnomalyDetectorInput {
                anomaly_detector_arn: self.anomaly_detector_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAnomalyDetectorInputOperationOutputAlias =
    crate::operation::DescribeAnomalyDetector;
#[doc(hidden)]
pub type DescribeAnomalyDetectorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAnomalyDetectorInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAnomalyDetector`](crate::operation::DescribeAnomalyDetector)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAnomalyDetector,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAnomalyDetectorInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/DescribeAnomalyDetector").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAnomalyDetectorInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_anomaly_detector(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAnomalyDetector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAnomalyDetector",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAnomalyDetectorInput`](crate::input::DescribeAnomalyDetectorInput)
    pub fn builder() -> crate::input::describe_anomaly_detector_input::Builder {
        crate::input::describe_anomaly_detector_input::Builder::default()
    }
}

/// See [`DescribeMetricSetInput`](crate::input::DescribeMetricSetInput)
pub mod describe_metric_set_input {
    /// A builder for [`DescribeMetricSetInput`](crate::input::DescribeMetricSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_set_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the dataset.</p>
        pub fn metric_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the dataset.</p>
        pub fn set_metric_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_set_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMetricSetInput`](crate::input::DescribeMetricSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMetricSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMetricSetInput {
                metric_set_arn: self.metric_set_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMetricSetInputOperationOutputAlias = crate::operation::DescribeMetricSet;
#[doc(hidden)]
pub type DescribeMetricSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeMetricSetInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMetricSet`](crate::operation::DescribeMetricSet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMetricSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeMetricSetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/DescribeMetricSet").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeMetricSetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_metric_set(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMetricSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMetricSet",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeMetricSetInput`](crate::input::DescribeMetricSetInput)
    pub fn builder() -> crate::input::describe_metric_set_input::Builder {
        crate::input::describe_metric_set_input::Builder::default()
    }
}

/// See [`GetAnomalyGroupInput`](crate::input::GetAnomalyGroupInput)
pub mod get_anomaly_group_input {
    /// A builder for [`GetAnomalyGroupInput`](crate::input::GetAnomalyGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_group_id: std::option::Option<std::string::String>,
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the anomaly group.</p>
        pub fn anomaly_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the anomaly group.</p>
        pub fn set_anomaly_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_group_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAnomalyGroupInput`](crate::input::GetAnomalyGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAnomalyGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAnomalyGroupInput {
                anomaly_group_id: self.anomaly_group_id,
                anomaly_detector_arn: self.anomaly_detector_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAnomalyGroupInputOperationOutputAlias = crate::operation::GetAnomalyGroup;
#[doc(hidden)]
pub type GetAnomalyGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAnomalyGroupInput {
    /// Consumes the builder and constructs an Operation<[`GetAnomalyGroup`](crate::operation::GetAnomalyGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAnomalyGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetAnomalyGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/GetAnomalyGroup").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetAnomalyGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_anomaly_group(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAnomalyGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAnomalyGroup",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetAnomalyGroupInput`](crate::input::GetAnomalyGroupInput)
    pub fn builder() -> crate::input::get_anomaly_group_input::Builder {
        crate::input::get_anomaly_group_input::Builder::default()
    }
}

/// See [`GetFeedbackInput`](crate::input::GetFeedbackInput)
pub mod get_feedback_input {
    /// A builder for [`GetFeedbackInput`](crate::input::GetFeedbackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
        pub(crate) anomaly_group_time_series_feedback:
            std::option::Option<crate::model::AnomalyGroupTimeSeries>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// <p>The anomalous metric and group ID.</p>
        pub fn anomaly_group_time_series_feedback(
            mut self,
            input: crate::model::AnomalyGroupTimeSeries,
        ) -> Self {
            self.anomaly_group_time_series_feedback = Some(input);
            self
        }
        /// <p>The anomalous metric and group ID.</p>
        pub fn set_anomaly_group_time_series_feedback(
            mut self,
            input: std::option::Option<crate::model::AnomalyGroupTimeSeries>,
        ) -> Self {
            self.anomaly_group_time_series_feedback = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFeedbackInput`](crate::input::GetFeedbackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFeedbackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFeedbackInput {
                anomaly_detector_arn: self.anomaly_detector_arn,
                anomaly_group_time_series_feedback: self.anomaly_group_time_series_feedback,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFeedbackInputOperationOutputAlias = crate::operation::GetFeedback;
#[doc(hidden)]
pub type GetFeedbackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetFeedbackInput {
    /// Consumes the builder and constructs an Operation<[`GetFeedback`](crate::operation::GetFeedback)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFeedback,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetFeedbackInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/GetFeedback").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetFeedbackInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_feedback(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFeedback::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFeedback",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetFeedbackInput`](crate::input::GetFeedbackInput)
    pub fn builder() -> crate::input::get_feedback_input::Builder {
        crate::input::get_feedback_input::Builder::default()
    }
}

/// See [`GetSampleDataInput`](crate::input::GetSampleDataInput)
pub mod get_sample_data_input {
    /// A builder for [`GetSampleDataInput`](crate::input::GetSampleDataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_source_config: std::option::Option<crate::model::SampleDataS3SourceConfig>,
    }
    impl Builder {
        /// <p>A datasource bucket in Amazon S3.</p>
        pub fn s3_source_config(mut self, input: crate::model::SampleDataS3SourceConfig) -> Self {
            self.s3_source_config = Some(input);
            self
        }
        /// <p>A datasource bucket in Amazon S3.</p>
        pub fn set_s3_source_config(
            mut self,
            input: std::option::Option<crate::model::SampleDataS3SourceConfig>,
        ) -> Self {
            self.s3_source_config = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSampleDataInput`](crate::input::GetSampleDataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSampleDataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSampleDataInput {
                s3_source_config: self.s3_source_config,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSampleDataInputOperationOutputAlias = crate::operation::GetSampleData;
#[doc(hidden)]
pub type GetSampleDataInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSampleDataInput {
    /// Consumes the builder and constructs an Operation<[`GetSampleData`](crate::operation::GetSampleData)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSampleData,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetSampleDataInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/GetSampleData").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetSampleDataInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_sample_data(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSampleData::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSampleData",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetSampleDataInput`](crate::input::GetSampleDataInput)
    pub fn builder() -> crate::input::get_sample_data_input::Builder {
        crate::input::get_sample_data_input::Builder::default()
    }
}

/// See [`ListAlertsInput`](crate::input::ListAlertsInput)
pub mod list_alerts_input {
    /// A builder for [`ListAlertsInput`](crate::input::ListAlertsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The ARN of the alert's detector.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the alert's detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// <p>If the result of the previous request is truncated, the response includes a <code>NextToken</code>. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the result of the previous request is truncated, the response includes a <code>NextToken</code>. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results that will be displayed by the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results that will be displayed by the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAlertsInput`](crate::input::ListAlertsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAlertsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAlertsInput {
                anomaly_detector_arn: self.anomaly_detector_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAlertsInputOperationOutputAlias = crate::operation::ListAlerts;
#[doc(hidden)]
pub type ListAlertsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAlertsInput {
    /// Consumes the builder and constructs an Operation<[`ListAlerts`](crate::operation::ListAlerts)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAlerts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAlertsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/ListAlerts").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAlertsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_alerts(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAlerts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAlerts",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAlertsInput`](crate::input::ListAlertsInput)
    pub fn builder() -> crate::input::list_alerts_input::Builder {
        crate::input::list_alerts_input::Builder::default()
    }
}

/// See [`ListAnomalyDetectorsInput`](crate::input::ListAnomalyDetectorsInput)
pub mod list_anomaly_detectors_input {
    /// A builder for [`ListAnomalyDetectorsInput`](crate::input::ListAnomalyDetectorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAnomalyDetectorsInput`](crate::input::ListAnomalyDetectorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAnomalyDetectorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAnomalyDetectorsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAnomalyDetectorsInputOperationOutputAlias = crate::operation::ListAnomalyDetectors;
#[doc(hidden)]
pub type ListAnomalyDetectorsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAnomalyDetectorsInput {
    /// Consumes the builder and constructs an Operation<[`ListAnomalyDetectors`](crate::operation::ListAnomalyDetectors)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAnomalyDetectors,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAnomalyDetectorsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/ListAnomalyDetectors").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAnomalyDetectorsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_anomaly_detectors(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAnomalyDetectors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAnomalyDetectors",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAnomalyDetectorsInput`](crate::input::ListAnomalyDetectorsInput)
    pub fn builder() -> crate::input::list_anomaly_detectors_input::Builder {
        crate::input::list_anomaly_detectors_input::Builder::default()
    }
}

/// See [`ListAnomalyGroupRelatedMetricsInput`](crate::input::ListAnomalyGroupRelatedMetricsInput)
pub mod list_anomaly_group_related_metrics_input {
    /// A builder for [`ListAnomalyGroupRelatedMetricsInput`](crate::input::ListAnomalyGroupRelatedMetricsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
        pub(crate) anomaly_group_id: std::option::Option<std::string::String>,
        pub(crate) relationship_type_filter: std::option::Option<crate::model::RelationshipType>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// <p>The ID of the anomaly group.</p>
        pub fn anomaly_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the anomaly group.</p>
        pub fn set_anomaly_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_group_id = input;
            self
        }
        /// <p>Filter for potential causes (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>) or downstream effects (<code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>) of the anomaly group.</p>
        pub fn relationship_type_filter(mut self, input: crate::model::RelationshipType) -> Self {
            self.relationship_type_filter = Some(input);
            self
        }
        /// <p>Filter for potential causes (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>) or downstream effects (<code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>) of the anomaly group.</p>
        pub fn set_relationship_type_filter(
            mut self,
            input: std::option::Option<crate::model::RelationshipType>,
        ) -> Self {
            self.relationship_type_filter = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAnomalyGroupRelatedMetricsInput`](crate::input::ListAnomalyGroupRelatedMetricsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAnomalyGroupRelatedMetricsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAnomalyGroupRelatedMetricsInput {
                anomaly_detector_arn: self.anomaly_detector_arn,
                anomaly_group_id: self.anomaly_group_id,
                relationship_type_filter: self.relationship_type_filter,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAnomalyGroupRelatedMetricsInputOperationOutputAlias =
    crate::operation::ListAnomalyGroupRelatedMetrics;
#[doc(hidden)]
pub type ListAnomalyGroupRelatedMetricsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListAnomalyGroupRelatedMetricsInput {
    /// Consumes the builder and constructs an Operation<[`ListAnomalyGroupRelatedMetrics`](crate::operation::ListAnomalyGroupRelatedMetrics)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAnomalyGroupRelatedMetrics,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAnomalyGroupRelatedMetricsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/ListAnomalyGroupRelatedMetrics")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAnomalyGroupRelatedMetricsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_anomaly_group_related_metrics(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAnomalyGroupRelatedMetrics::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAnomalyGroupRelatedMetrics",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAnomalyGroupRelatedMetricsInput`](crate::input::ListAnomalyGroupRelatedMetricsInput)
    pub fn builder() -> crate::input::list_anomaly_group_related_metrics_input::Builder {
        crate::input::list_anomaly_group_related_metrics_input::Builder::default()
    }
}

/// See [`ListAnomalyGroupSummariesInput`](crate::input::ListAnomalyGroupSummariesInput)
pub mod list_anomaly_group_summaries_input {
    /// A builder for [`ListAnomalyGroupSummariesInput`](crate::input::ListAnomalyGroupSummariesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
        pub(crate) sensitivity_threshold: std::option::Option<i32>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// <p>The minimum severity score for inclusion in the output.</p>
        pub fn sensitivity_threshold(mut self, input: i32) -> Self {
            self.sensitivity_threshold = Some(input);
            self
        }
        /// <p>The minimum severity score for inclusion in the output.</p>
        pub fn set_sensitivity_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.sensitivity_threshold = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAnomalyGroupSummariesInput`](crate::input::ListAnomalyGroupSummariesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAnomalyGroupSummariesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAnomalyGroupSummariesInput {
                anomaly_detector_arn: self.anomaly_detector_arn,
                sensitivity_threshold: self.sensitivity_threshold.unwrap_or_default(),
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAnomalyGroupSummariesInputOperationOutputAlias =
    crate::operation::ListAnomalyGroupSummaries;
#[doc(hidden)]
pub type ListAnomalyGroupSummariesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAnomalyGroupSummariesInput {
    /// Consumes the builder and constructs an Operation<[`ListAnomalyGroupSummaries`](crate::operation::ListAnomalyGroupSummaries)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAnomalyGroupSummaries,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAnomalyGroupSummariesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/ListAnomalyGroupSummaries").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAnomalyGroupSummariesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_anomaly_group_summaries(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAnomalyGroupSummaries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAnomalyGroupSummaries",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAnomalyGroupSummariesInput`](crate::input::ListAnomalyGroupSummariesInput)
    pub fn builder() -> crate::input::list_anomaly_group_summaries_input::Builder {
        crate::input::list_anomaly_group_summaries_input::Builder::default()
    }
}

/// See [`ListAnomalyGroupTimeSeriesInput`](crate::input::ListAnomalyGroupTimeSeriesInput)
pub mod list_anomaly_group_time_series_input {
    /// A builder for [`ListAnomalyGroupTimeSeriesInput`](crate::input::ListAnomalyGroupTimeSeriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
        pub(crate) anomaly_group_id: std::option::Option<std::string::String>,
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// <p>The ID of the anomaly group.</p>
        pub fn anomaly_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the anomaly group.</p>
        pub fn set_anomaly_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_group_id = input;
            self
        }
        /// <p>The name of the measure field.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the measure field.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAnomalyGroupTimeSeriesInput`](crate::input::ListAnomalyGroupTimeSeriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAnomalyGroupTimeSeriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAnomalyGroupTimeSeriesInput {
                anomaly_detector_arn: self.anomaly_detector_arn,
                anomaly_group_id: self.anomaly_group_id,
                metric_name: self.metric_name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAnomalyGroupTimeSeriesInputOperationOutputAlias =
    crate::operation::ListAnomalyGroupTimeSeries;
#[doc(hidden)]
pub type ListAnomalyGroupTimeSeriesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAnomalyGroupTimeSeriesInput {
    /// Consumes the builder and constructs an Operation<[`ListAnomalyGroupTimeSeries`](crate::operation::ListAnomalyGroupTimeSeries)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAnomalyGroupTimeSeries,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAnomalyGroupTimeSeriesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/ListAnomalyGroupTimeSeries").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAnomalyGroupTimeSeriesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_anomaly_group_time_series(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAnomalyGroupTimeSeries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAnomalyGroupTimeSeries",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAnomalyGroupTimeSeriesInput`](crate::input::ListAnomalyGroupTimeSeriesInput)
    pub fn builder() -> crate::input::list_anomaly_group_time_series_input::Builder {
        crate::input::list_anomaly_group_time_series_input::Builder::default()
    }
}

/// See [`ListMetricSetsInput`](crate::input::ListMetricSetsInput)
pub mod list_metric_sets_input {
    /// A builder for [`ListMetricSetsInput`](crate::input::ListMetricSetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the anomaly detector containing the metrics sets to list.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the anomaly detector containing the metrics sets to list.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMetricSetsInput`](crate::input::ListMetricSetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMetricSetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMetricSetsInput {
                anomaly_detector_arn: self.anomaly_detector_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListMetricSetsInputOperationOutputAlias = crate::operation::ListMetricSets;
#[doc(hidden)]
pub type ListMetricSetsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListMetricSetsInput {
    /// Consumes the builder and constructs an Operation<[`ListMetricSets`](crate::operation::ListMetricSets)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMetricSets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListMetricSetsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/ListMetricSets").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListMetricSetsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_metric_sets(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMetricSets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMetricSets",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListMetricSetsInput`](crate::input::ListMetricSetsInput)
    pub fn builder() -> crate::input::list_metric_sets_input::Builder {
        crate::input::list_metric_sets_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource's Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource's Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.resource_arn;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_1, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutFeedbackInput`](crate::input::PutFeedbackInput)
pub mod put_feedback_input {
    /// A builder for [`PutFeedbackInput`](crate::input::PutFeedbackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
        pub(crate) anomaly_group_time_series_feedback:
            std::option::Option<crate::model::AnomalyGroupTimeSeriesFeedback>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// <p>Feedback for an anomalous metric.</p>
        pub fn anomaly_group_time_series_feedback(
            mut self,
            input: crate::model::AnomalyGroupTimeSeriesFeedback,
        ) -> Self {
            self.anomaly_group_time_series_feedback = Some(input);
            self
        }
        /// <p>Feedback for an anomalous metric.</p>
        pub fn set_anomaly_group_time_series_feedback(
            mut self,
            input: std::option::Option<crate::model::AnomalyGroupTimeSeriesFeedback>,
        ) -> Self {
            self.anomaly_group_time_series_feedback = input;
            self
        }
        /// Consumes the builder and constructs a [`PutFeedbackInput`](crate::input::PutFeedbackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutFeedbackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutFeedbackInput {
                anomaly_detector_arn: self.anomaly_detector_arn,
                anomaly_group_time_series_feedback: self.anomaly_group_time_series_feedback,
            })
        }
    }
}
#[doc(hidden)]
pub type PutFeedbackInputOperationOutputAlias = crate::operation::PutFeedback;
#[doc(hidden)]
pub type PutFeedbackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutFeedbackInput {
    /// Consumes the builder and constructs an Operation<[`PutFeedback`](crate::operation::PutFeedback)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutFeedback,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutFeedbackInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/PutFeedback").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutFeedbackInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_feedback(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutFeedback::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutFeedback",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutFeedbackInput`](crate::input::PutFeedbackInput)
    pub fn builder() -> crate::input::put_feedback_input::Builder {
        crate::input::put_feedback_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The resource's Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource's Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to apply to the resource. Tag keys and values can contain letters, numbers, spaces, and the following symbols: <code>_.:/=+@-</code> </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags to apply to the resource. Tag keys and values can contain letters, numbers, spaces, and the following symbols: <code>_.:/=+@-</code> </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.resource_arn;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_2, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The resource's Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The resource's Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Keys to remove from the resource's tags.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>Keys to remove from the resource's tags.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.resource_arn;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_3, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UntagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_4) = &_input.tag_keys {
                    for inner_5 in inner_4 {
                        query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_5));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateAnomalyDetectorInput`](crate::input::UpdateAnomalyDetectorInput)
pub mod update_anomaly_detector_input {
    /// A builder for [`UpdateAnomalyDetectorInput`](crate::input::UpdateAnomalyDetectorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) anomaly_detector_description: std::option::Option<std::string::String>,
        pub(crate) anomaly_detector_config:
            std::option::Option<crate::model::AnomalyDetectorConfig>,
    }
    impl Builder {
        /// <p>The ARN of the detector to update.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the detector to update.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an AWS KMS encryption key.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an AWS KMS encryption key.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>The updated detector description.</p>
        pub fn anomaly_detector_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.anomaly_detector_description = Some(input.into());
            self
        }
        /// <p>The updated detector description.</p>
        pub fn set_anomaly_detector_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_description = input;
            self
        }
        /// <p>Contains information about the configuration to which the detector will be updated.</p>
        pub fn anomaly_detector_config(
            mut self,
            input: crate::model::AnomalyDetectorConfig,
        ) -> Self {
            self.anomaly_detector_config = Some(input);
            self
        }
        /// <p>Contains information about the configuration to which the detector will be updated.</p>
        pub fn set_anomaly_detector_config(
            mut self,
            input: std::option::Option<crate::model::AnomalyDetectorConfig>,
        ) -> Self {
            self.anomaly_detector_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAnomalyDetectorInput`](crate::input::UpdateAnomalyDetectorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAnomalyDetectorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAnomalyDetectorInput {
                anomaly_detector_arn: self.anomaly_detector_arn,
                kms_key_arn: self.kms_key_arn,
                anomaly_detector_description: self.anomaly_detector_description,
                anomaly_detector_config: self.anomaly_detector_config,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAnomalyDetectorInputOperationOutputAlias = crate::operation::UpdateAnomalyDetector;
#[doc(hidden)]
pub type UpdateAnomalyDetectorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateAnomalyDetectorInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAnomalyDetector`](crate::operation::UpdateAnomalyDetector)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAnomalyDetector,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateAnomalyDetectorInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/UpdateAnomalyDetector").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateAnomalyDetectorInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_anomaly_detector(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAnomalyDetector::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAnomalyDetector",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateAnomalyDetectorInput`](crate::input::UpdateAnomalyDetectorInput)
    pub fn builder() -> crate::input::update_anomaly_detector_input::Builder {
        crate::input::update_anomaly_detector_input::Builder::default()
    }
}

/// See [`UpdateMetricSetInput`](crate::input::UpdateMetricSetInput)
pub mod update_metric_set_input {
    /// A builder for [`UpdateMetricSetInput`](crate::input::UpdateMetricSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_set_arn: std::option::Option<std::string::String>,
        pub(crate) metric_set_description: std::option::Option<std::string::String>,
        pub(crate) metric_list: std::option::Option<std::vec::Vec<crate::model::Metric>>,
        pub(crate) offset: std::option::Option<i32>,
        pub(crate) timestamp_column: std::option::Option<crate::model::TimestampColumn>,
        pub(crate) dimension_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) metric_set_frequency: std::option::Option<crate::model::Frequency>,
        pub(crate) metric_source: std::option::Option<crate::model::MetricSource>,
    }
    impl Builder {
        /// <p>The ARN of the dataset to update.</p>
        pub fn metric_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the dataset to update.</p>
        pub fn set_metric_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_set_arn = input;
            self
        }
        /// <p>The dataset's description.</p>
        pub fn metric_set_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_set_description = Some(input.into());
            self
        }
        /// <p>The dataset's description.</p>
        pub fn set_metric_set_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_set_description = input;
            self
        }
        /// Appends an item to `metric_list`.
        ///
        /// To override the contents of this collection use [`set_metric_list`](Self::set_metric_list).
        ///
        /// <p>The metric list.</p>
        pub fn metric_list(mut self, input: crate::model::Metric) -> Self {
            let mut v = self.metric_list.unwrap_or_default();
            v.push(input);
            self.metric_list = Some(v);
            self
        }
        /// <p>The metric list.</p>
        pub fn set_metric_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Metric>>,
        ) -> Self {
            self.metric_list = input;
            self
        }
        /// <p>After an interval ends, the amount of seconds that the detector waits before importing data. Offset is only supported for S3 and Redshift datasources.</p>
        pub fn offset(mut self, input: i32) -> Self {
            self.offset = Some(input);
            self
        }
        /// <p>After an interval ends, the amount of seconds that the detector waits before importing data. Offset is only supported for S3 and Redshift datasources.</p>
        pub fn set_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.offset = input;
            self
        }
        /// <p>The timestamp column.</p>
        pub fn timestamp_column(mut self, input: crate::model::TimestampColumn) -> Self {
            self.timestamp_column = Some(input);
            self
        }
        /// <p>The timestamp column.</p>
        pub fn set_timestamp_column(
            mut self,
            input: std::option::Option<crate::model::TimestampColumn>,
        ) -> Self {
            self.timestamp_column = input;
            self
        }
        /// Appends an item to `dimension_list`.
        ///
        /// To override the contents of this collection use [`set_dimension_list`](Self::set_dimension_list).
        ///
        /// <p>The dimension list.</p>
        pub fn dimension_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dimension_list.unwrap_or_default();
            v.push(input.into());
            self.dimension_list = Some(v);
            self
        }
        /// <p>The dimension list.</p>
        pub fn set_dimension_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dimension_list = input;
            self
        }
        /// <p>The dataset's interval.</p>
        pub fn metric_set_frequency(mut self, input: crate::model::Frequency) -> Self {
            self.metric_set_frequency = Some(input);
            self
        }
        /// <p>The dataset's interval.</p>
        pub fn set_metric_set_frequency(
            mut self,
            input: std::option::Option<crate::model::Frequency>,
        ) -> Self {
            self.metric_set_frequency = input;
            self
        }
        /// <p>Contains information about source data used to generate a metric.</p>
        pub fn metric_source(mut self, input: crate::model::MetricSource) -> Self {
            self.metric_source = Some(input);
            self
        }
        /// <p>Contains information about source data used to generate a metric.</p>
        pub fn set_metric_source(
            mut self,
            input: std::option::Option<crate::model::MetricSource>,
        ) -> Self {
            self.metric_source = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMetricSetInput`](crate::input::UpdateMetricSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateMetricSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateMetricSetInput {
                metric_set_arn: self.metric_set_arn,
                metric_set_description: self.metric_set_description,
                metric_list: self.metric_list,
                offset: self.offset,
                timestamp_column: self.timestamp_column,
                dimension_list: self.dimension_list,
                metric_set_frequency: self.metric_set_frequency,
                metric_source: self.metric_source,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateMetricSetInputOperationOutputAlias = crate::operation::UpdateMetricSet;
#[doc(hidden)]
pub type UpdateMetricSetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateMetricSetInput {
    /// Consumes the builder and constructs an Operation<[`UpdateMetricSet`](crate::operation::UpdateMetricSet)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateMetricSet,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateMetricSetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/UpdateMetricSet").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateMetricSetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_metric_set(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateMetricSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateMetricSet",
            "lookoutmetrics",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateMetricSetInput`](crate::input::UpdateMetricSetInput)
    pub fn builder() -> crate::input::update_metric_set_input::Builder {
        crate::input::update_metric_set_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMetricSetInput {
    /// <p>The ARN of the dataset to update.</p>
    pub metric_set_arn: std::option::Option<std::string::String>,
    /// <p>The dataset's description.</p>
    pub metric_set_description: std::option::Option<std::string::String>,
    /// <p>The metric list.</p>
    pub metric_list: std::option::Option<std::vec::Vec<crate::model::Metric>>,
    /// <p>After an interval ends, the amount of seconds that the detector waits before importing data. Offset is only supported for S3 and Redshift datasources.</p>
    pub offset: std::option::Option<i32>,
    /// <p>The timestamp column.</p>
    pub timestamp_column: std::option::Option<crate::model::TimestampColumn>,
    /// <p>The dimension list.</p>
    pub dimension_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The dataset's interval.</p>
    pub metric_set_frequency: std::option::Option<crate::model::Frequency>,
    /// <p>Contains information about source data used to generate a metric.</p>
    pub metric_source: std::option::Option<crate::model::MetricSource>,
}
impl UpdateMetricSetInput {
    /// <p>The ARN of the dataset to update.</p>
    pub fn metric_set_arn(&self) -> std::option::Option<&str> {
        self.metric_set_arn.as_deref()
    }
    /// <p>The dataset's description.</p>
    pub fn metric_set_description(&self) -> std::option::Option<&str> {
        self.metric_set_description.as_deref()
    }
    /// <p>The metric list.</p>
    pub fn metric_list(&self) -> std::option::Option<&[crate::model::Metric]> {
        self.metric_list.as_deref()
    }
    /// <p>After an interval ends, the amount of seconds that the detector waits before importing data. Offset is only supported for S3 and Redshift datasources.</p>
    pub fn offset(&self) -> std::option::Option<i32> {
        self.offset
    }
    /// <p>The timestamp column.</p>
    pub fn timestamp_column(&self) -> std::option::Option<&crate::model::TimestampColumn> {
        self.timestamp_column.as_ref()
    }
    /// <p>The dimension list.</p>
    pub fn dimension_list(&self) -> std::option::Option<&[std::string::String]> {
        self.dimension_list.as_deref()
    }
    /// <p>The dataset's interval.</p>
    pub fn metric_set_frequency(&self) -> std::option::Option<&crate::model::Frequency> {
        self.metric_set_frequency.as_ref()
    }
    /// <p>Contains information about source data used to generate a metric.</p>
    pub fn metric_source(&self) -> std::option::Option<&crate::model::MetricSource> {
        self.metric_source.as_ref()
    }
}
impl std::fmt::Debug for UpdateMetricSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMetricSetInput");
        formatter.field("metric_set_arn", &self.metric_set_arn);
        formatter.field("metric_set_description", &self.metric_set_description);
        formatter.field("metric_list", &self.metric_list);
        formatter.field("offset", &self.offset);
        formatter.field("timestamp_column", &self.timestamp_column);
        formatter.field("dimension_list", &self.dimension_list);
        formatter.field("metric_set_frequency", &self.metric_set_frequency);
        formatter.field("metric_source", &self.metric_source);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAnomalyDetectorInput {
    /// <p>The ARN of the detector to update.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of an AWS KMS encryption key.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The updated detector description.</p>
    pub anomaly_detector_description: std::option::Option<std::string::String>,
    /// <p>Contains information about the configuration to which the detector will be updated.</p>
    pub anomaly_detector_config: std::option::Option<crate::model::AnomalyDetectorConfig>,
}
impl UpdateAnomalyDetectorInput {
    /// <p>The ARN of the detector to update.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of an AWS KMS encryption key.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>The updated detector description.</p>
    pub fn anomaly_detector_description(&self) -> std::option::Option<&str> {
        self.anomaly_detector_description.as_deref()
    }
    /// <p>Contains information about the configuration to which the detector will be updated.</p>
    pub fn anomaly_detector_config(
        &self,
    ) -> std::option::Option<&crate::model::AnomalyDetectorConfig> {
        self.anomaly_detector_config.as_ref()
    }
}
impl std::fmt::Debug for UpdateAnomalyDetectorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAnomalyDetectorInput");
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field(
            "anomaly_detector_description",
            &self.anomaly_detector_description,
        );
        formatter.field("anomaly_detector_config", &self.anomaly_detector_config);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The resource's Amazon Resource Name (ARN).</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Keys to remove from the resource's tags.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The resource's Amazon Resource Name (ARN).</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Keys to remove from the resource's tags.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The resource's Amazon Resource Name (ARN).</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Tags to apply to the resource. Tag keys and values can contain letters, numbers, spaces, and the following symbols: <code>_.:/=+@-</code> </p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The resource's Amazon Resource Name (ARN).</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Tags to apply to the resource. Tag keys and values can contain letters, numbers, spaces, and the following symbols: <code>_.:/=+@-</code> </p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutFeedbackInput {
    /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
    /// <p>Feedback for an anomalous metric.</p>
    pub anomaly_group_time_series_feedback:
        std::option::Option<crate::model::AnomalyGroupTimeSeriesFeedback>,
}
impl PutFeedbackInput {
    /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
    /// <p>Feedback for an anomalous metric.</p>
    pub fn anomaly_group_time_series_feedback(
        &self,
    ) -> std::option::Option<&crate::model::AnomalyGroupTimeSeriesFeedback> {
        self.anomaly_group_time_series_feedback.as_ref()
    }
}
impl std::fmt::Debug for PutFeedbackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutFeedbackInput");
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.field(
            "anomaly_group_time_series_feedback",
            &self.anomaly_group_time_series_feedback,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The resource's Amazon Resource Name (ARN).</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The resource's Amazon Resource Name (ARN).</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMetricSetsInput {
    /// <p>The ARN of the anomaly detector containing the metrics sets to list.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListMetricSetsInput {
    /// <p>The ARN of the anomaly detector containing the metrics sets to list.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
    /// <p>The maximum number of results to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListMetricSetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMetricSetsInput");
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAnomalyGroupTimeSeriesInput {
    /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the anomaly group.</p>
    pub anomaly_group_id: std::option::Option<std::string::String>,
    /// <p>The name of the measure field.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAnomalyGroupTimeSeriesInput {
    /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
    /// <p>The ID of the anomaly group.</p>
    pub fn anomaly_group_id(&self) -> std::option::Option<&str> {
        self.anomaly_group_id.as_deref()
    }
    /// <p>The name of the measure field.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The maximum number of results to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAnomalyGroupTimeSeriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAnomalyGroupTimeSeriesInput");
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.field("anomaly_group_id", &self.anomaly_group_id);
        formatter.field("metric_name", &self.metric_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAnomalyGroupSummariesInput {
    /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
    /// <p>The minimum severity score for inclusion in the output.</p>
    pub sensitivity_threshold: i32,
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAnomalyGroupSummariesInput {
    /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
    /// <p>The minimum severity score for inclusion in the output.</p>
    pub fn sensitivity_threshold(&self) -> i32 {
        self.sensitivity_threshold
    }
    /// <p>The maximum number of results to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAnomalyGroupSummariesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAnomalyGroupSummariesInput");
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.field("sensitivity_threshold", &self.sensitivity_threshold);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAnomalyGroupRelatedMetricsInput {
    /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
    /// <p>The ID of the anomaly group.</p>
    pub anomaly_group_id: std::option::Option<std::string::String>,
    /// <p>Filter for potential causes (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>) or downstream effects (<code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>) of the anomaly group.</p>
    pub relationship_type_filter: std::option::Option<crate::model::RelationshipType>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAnomalyGroupRelatedMetricsInput {
    /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
    /// <p>The ID of the anomaly group.</p>
    pub fn anomaly_group_id(&self) -> std::option::Option<&str> {
        self.anomaly_group_id.as_deref()
    }
    /// <p>Filter for potential causes (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>) or downstream effects (<code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>) of the anomaly group.</p>
    pub fn relationship_type_filter(&self) -> std::option::Option<&crate::model::RelationshipType> {
        self.relationship_type_filter.as_ref()
    }
    /// <p>The maximum number of results to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAnomalyGroupRelatedMetricsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAnomalyGroupRelatedMetricsInput");
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.field("anomaly_group_id", &self.anomaly_group_id);
        formatter.field("relationship_type_filter", &self.relationship_type_filter);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAnomalyDetectorsInput {
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAnomalyDetectorsInput {
    /// <p>The maximum number of results to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAnomalyDetectorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAnomalyDetectorsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAlertsInput {
    /// <p>The ARN of the alert's detector.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
    /// <p>If the result of the previous request is truncated, the response includes a <code>NextToken</code>. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results that will be displayed by the request.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListAlertsInput {
    /// <p>The ARN of the alert's detector.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
    /// <p>If the result of the previous request is truncated, the response includes a <code>NextToken</code>. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results that will be displayed by the request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListAlertsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAlertsInput");
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSampleDataInput {
    /// <p>A datasource bucket in Amazon S3.</p>
    pub s3_source_config: std::option::Option<crate::model::SampleDataS3SourceConfig>,
}
impl GetSampleDataInput {
    /// <p>A datasource bucket in Amazon S3.</p>
    pub fn s3_source_config(&self) -> std::option::Option<&crate::model::SampleDataS3SourceConfig> {
        self.s3_source_config.as_ref()
    }
}
impl std::fmt::Debug for GetSampleDataInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSampleDataInput");
        formatter.field("s3_source_config", &self.s3_source_config);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFeedbackInput {
    /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
    /// <p>The anomalous metric and group ID.</p>
    pub anomaly_group_time_series_feedback:
        std::option::Option<crate::model::AnomalyGroupTimeSeries>,
    /// <p>The maximum number of results to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetFeedbackInput {
    /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
    /// <p>The anomalous metric and group ID.</p>
    pub fn anomaly_group_time_series_feedback(
        &self,
    ) -> std::option::Option<&crate::model::AnomalyGroupTimeSeries> {
        self.anomaly_group_time_series_feedback.as_ref()
    }
    /// <p>The maximum number of results to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetFeedbackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFeedbackInput");
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.field(
            "anomaly_group_time_series_feedback",
            &self.anomaly_group_time_series_feedback,
        );
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAnomalyGroupInput {
    /// <p>The ID of the anomaly group.</p>
    pub anomaly_group_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
}
impl GetAnomalyGroupInput {
    /// <p>The ID of the anomaly group.</p>
    pub fn anomaly_group_id(&self) -> std::option::Option<&str> {
        self.anomaly_group_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
}
impl std::fmt::Debug for GetAnomalyGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAnomalyGroupInput");
        formatter.field("anomaly_group_id", &self.anomaly_group_id);
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMetricSetInput {
    /// <p>The ARN of the dataset.</p>
    pub metric_set_arn: std::option::Option<std::string::String>,
}
impl DescribeMetricSetInput {
    /// <p>The ARN of the dataset.</p>
    pub fn metric_set_arn(&self) -> std::option::Option<&str> {
        self.metric_set_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeMetricSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMetricSetInput");
        formatter.field("metric_set_arn", &self.metric_set_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAnomalyDetectorInput {
    /// <p>The ARN of the detector to describe.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
}
impl DescribeAnomalyDetectorInput {
    /// <p>The ARN of the detector to describe.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeAnomalyDetectorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAnomalyDetectorInput");
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAnomalyDetectionExecutionsInput {
    /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
    /// <p>The timestamp of the anomaly detection job.</p>
    pub timestamp: std::option::Option<std::string::String>,
    /// <p>The number of items to return in the response.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeAnomalyDetectionExecutionsInput {
    /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
    /// <p>The timestamp of the anomaly detection job.</p>
    pub fn timestamp(&self) -> std::option::Option<&str> {
        self.timestamp.as_deref()
    }
    /// <p>The number of items to return in the response.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeAnomalyDetectionExecutionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAnomalyDetectionExecutionsInput");
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAlertInput {
    /// <p>The ARN of the alert to describe.</p>
    pub alert_arn: std::option::Option<std::string::String>,
}
impl DescribeAlertInput {
    /// <p>The ARN of the alert to describe.</p>
    pub fn alert_arn(&self) -> std::option::Option<&str> {
        self.alert_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeAlertInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAlertInput");
        formatter.field("alert_arn", &self.alert_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAnomalyDetectorInput {
    /// <p>The ARN of the detector to delete.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
}
impl DeleteAnomalyDetectorInput {
    /// <p>The ARN of the detector to delete.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteAnomalyDetectorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAnomalyDetectorInput");
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAlertInput {
    /// <p>The ARN of the alert to delete.</p>
    pub alert_arn: std::option::Option<std::string::String>,
}
impl DeleteAlertInput {
    /// <p>The ARN of the alert to delete.</p>
    pub fn alert_arn(&self) -> std::option::Option<&str> {
        self.alert_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteAlertInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAlertInput");
        formatter.field("alert_arn", &self.alert_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeactivateAnomalyDetectorInput {
    /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
}
impl DeactivateAnomalyDetectorInput {
    /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
}
impl std::fmt::Debug for DeactivateAnomalyDetectorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeactivateAnomalyDetectorInput");
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMetricSetInput {
    /// <p>The ARN of the anomaly detector that will use the dataset.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
    /// <p>The name of the dataset.</p>
    pub metric_set_name: std::option::Option<std::string::String>,
    /// <p>A description of the dataset you are creating.</p>
    pub metric_set_description: std::option::Option<std::string::String>,
    /// <p>A list of metrics that the dataset will contain.</p>
    pub metric_list: std::option::Option<std::vec::Vec<crate::model::Metric>>,
    /// <p>After an interval ends, the amount of seconds that the detector waits before importing data. Offset is only supported for S3 and Redshift datasources.</p>
    pub offset: std::option::Option<i32>,
    /// <p>Contains information about the column used for tracking time in your source data.</p>
    pub timestamp_column: std::option::Option<crate::model::TimestampColumn>,
    /// <p>A list of the fields you want to treat as dimensions.</p>
    pub dimension_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The frequency with which the source data will be analyzed for anomalies.</p>
    pub metric_set_frequency: std::option::Option<crate::model::Frequency>,
    /// <p>Contains information about how the source data should be interpreted.</p>
    pub metric_source: std::option::Option<crate::model::MetricSource>,
    /// <p>The time zone in which your source data was recorded.</p>
    pub timezone: std::option::Option<std::string::String>,
    /// <p>A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply to the dataset.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateMetricSetInput {
    /// <p>The ARN of the anomaly detector that will use the dataset.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
    /// <p>The name of the dataset.</p>
    pub fn metric_set_name(&self) -> std::option::Option<&str> {
        self.metric_set_name.as_deref()
    }
    /// <p>A description of the dataset you are creating.</p>
    pub fn metric_set_description(&self) -> std::option::Option<&str> {
        self.metric_set_description.as_deref()
    }
    /// <p>A list of metrics that the dataset will contain.</p>
    pub fn metric_list(&self) -> std::option::Option<&[crate::model::Metric]> {
        self.metric_list.as_deref()
    }
    /// <p>After an interval ends, the amount of seconds that the detector waits before importing data. Offset is only supported for S3 and Redshift datasources.</p>
    pub fn offset(&self) -> std::option::Option<i32> {
        self.offset
    }
    /// <p>Contains information about the column used for tracking time in your source data.</p>
    pub fn timestamp_column(&self) -> std::option::Option<&crate::model::TimestampColumn> {
        self.timestamp_column.as_ref()
    }
    /// <p>A list of the fields you want to treat as dimensions.</p>
    pub fn dimension_list(&self) -> std::option::Option<&[std::string::String]> {
        self.dimension_list.as_deref()
    }
    /// <p>The frequency with which the source data will be analyzed for anomalies.</p>
    pub fn metric_set_frequency(&self) -> std::option::Option<&crate::model::Frequency> {
        self.metric_set_frequency.as_ref()
    }
    /// <p>Contains information about how the source data should be interpreted.</p>
    pub fn metric_source(&self) -> std::option::Option<&crate::model::MetricSource> {
        self.metric_source.as_ref()
    }
    /// <p>The time zone in which your source data was recorded.</p>
    pub fn timezone(&self) -> std::option::Option<&str> {
        self.timezone.as_deref()
    }
    /// <p>A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply to the dataset.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateMetricSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMetricSetInput");
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.field("metric_set_name", &self.metric_set_name);
        formatter.field("metric_set_description", &self.metric_set_description);
        formatter.field("metric_list", &self.metric_list);
        formatter.field("offset", &self.offset);
        formatter.field("timestamp_column", &self.timestamp_column);
        formatter.field("dimension_list", &self.dimension_list);
        formatter.field("metric_set_frequency", &self.metric_set_frequency);
        formatter.field("metric_source", &self.metric_source);
        formatter.field("timezone", &self.timezone);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAnomalyDetectorInput {
    /// <p>The name of the detector.</p>
    pub anomaly_detector_name: std::option::Option<std::string::String>,
    /// <p>A description of the detector.</p>
    pub anomaly_detector_description: std::option::Option<std::string::String>,
    /// <p>Contains information about the configuration of the anomaly detector.</p>
    pub anomaly_detector_config: std::option::Option<crate::model::AnomalyDetectorConfig>,
    /// <p>The ARN of the KMS key to use to encrypt your data.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply to the anomaly detector.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateAnomalyDetectorInput {
    /// <p>The name of the detector.</p>
    pub fn anomaly_detector_name(&self) -> std::option::Option<&str> {
        self.anomaly_detector_name.as_deref()
    }
    /// <p>A description of the detector.</p>
    pub fn anomaly_detector_description(&self) -> std::option::Option<&str> {
        self.anomaly_detector_description.as_deref()
    }
    /// <p>Contains information about the configuration of the anomaly detector.</p>
    pub fn anomaly_detector_config(
        &self,
    ) -> std::option::Option<&crate::model::AnomalyDetectorConfig> {
        self.anomaly_detector_config.as_ref()
    }
    /// <p>The ARN of the KMS key to use to encrypt your data.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply to the anomaly detector.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateAnomalyDetectorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAnomalyDetectorInput");
        formatter.field("anomaly_detector_name", &self.anomaly_detector_name);
        formatter.field(
            "anomaly_detector_description",
            &self.anomaly_detector_description,
        );
        formatter.field("anomaly_detector_config", &self.anomaly_detector_config);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAlertInput {
    /// <p>The name of the alert.</p>
    pub alert_name: std::option::Option<std::string::String>,
    /// <p>An integer from 0 to 100 specifying the alert sensitivity threshold.</p>
    pub alert_sensitivity_threshold: i32,
    /// <p>A description of the alert.</p>
    pub alert_description: std::option::Option<std::string::String>,
    /// <p>The ARN of the detector to which the alert is attached.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
    /// <p>Action that will be triggered when there is an alert.</p>
    pub action: std::option::Option<crate::model::Action>,
    /// <p>A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply to the alert.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateAlertInput {
    /// <p>The name of the alert.</p>
    pub fn alert_name(&self) -> std::option::Option<&str> {
        self.alert_name.as_deref()
    }
    /// <p>An integer from 0 to 100 specifying the alert sensitivity threshold.</p>
    pub fn alert_sensitivity_threshold(&self) -> i32 {
        self.alert_sensitivity_threshold
    }
    /// <p>A description of the alert.</p>
    pub fn alert_description(&self) -> std::option::Option<&str> {
        self.alert_description.as_deref()
    }
    /// <p>The ARN of the detector to which the alert is attached.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
    /// <p>Action that will be triggered when there is an alert.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::Action> {
        self.action.as_ref()
    }
    /// <p>A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply to the alert.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateAlertInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAlertInput");
        formatter.field("alert_name", &self.alert_name);
        formatter.field(
            "alert_sensitivity_threshold",
            &self.alert_sensitivity_threshold,
        );
        formatter.field("alert_description", &self.alert_description);
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.field("action", &self.action);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackTestAnomalyDetectorInput {
    /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
}
impl BackTestAnomalyDetectorInput {
    /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
}
impl std::fmt::Debug for BackTestAnomalyDetectorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackTestAnomalyDetectorInput");
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivateAnomalyDetectorInput {
    /// <p>The ARN of the anomaly detector.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
}
impl ActivateAnomalyDetectorInput {
    /// <p>The ARN of the anomaly detector.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
}
impl std::fmt::Debug for ActivateAnomalyDetectorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivateAnomalyDetectorInput");
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.finish()
    }
}
