// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `ActivateAnomalyDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ActivateAnomalyDetectorError {
    /// Kind of error that occurred.
    pub kind: ActivateAnomalyDetectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ActivateAnomalyDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ActivateAnomalyDetectorErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Try your request again.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ActivateAnomalyDetectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ActivateAnomalyDetectorErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ActivateAnomalyDetectorErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ActivateAnomalyDetectorErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ActivateAnomalyDetectorErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ActivateAnomalyDetectorErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ActivateAnomalyDetectorErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ActivateAnomalyDetectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ActivateAnomalyDetectorError {
    fn code(&self) -> Option<&str> {
        ActivateAnomalyDetectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ActivateAnomalyDetectorError {
    /// Creates a new `ActivateAnomalyDetectorError`.
    pub fn new(kind: ActivateAnomalyDetectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ActivateAnomalyDetectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ActivateAnomalyDetectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ActivateAnomalyDetectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ActivateAnomalyDetectorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ActivateAnomalyDetectorErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ActivateAnomalyDetectorErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ActivateAnomalyDetectorErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ActivateAnomalyDetectorErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `ActivateAnomalyDetectorErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ActivateAnomalyDetectorErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ActivateAnomalyDetectorErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ActivateAnomalyDetectorErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ActivateAnomalyDetectorErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ActivateAnomalyDetectorErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ActivateAnomalyDetectorErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ActivateAnomalyDetectorErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ActivateAnomalyDetectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ActivateAnomalyDetectorErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ActivateAnomalyDetectorErrorKind::ConflictException(_inner) => Some(_inner),
            ActivateAnomalyDetectorErrorKind::InternalServerException(_inner) => Some(_inner),
            ActivateAnomalyDetectorErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ActivateAnomalyDetectorErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ActivateAnomalyDetectorErrorKind::ValidationException(_inner) => Some(_inner),
            ActivateAnomalyDetectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BackTestAnomalyDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BackTestAnomalyDetectorError {
    /// Kind of error that occurred.
    pub kind: BackTestAnomalyDetectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BackTestAnomalyDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BackTestAnomalyDetectorErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BackTestAnomalyDetectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BackTestAnomalyDetectorErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            BackTestAnomalyDetectorErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            BackTestAnomalyDetectorErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            BackTestAnomalyDetectorErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            BackTestAnomalyDetectorErrorKind::ValidationException(_inner) => _inner.fmt(f),
            BackTestAnomalyDetectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BackTestAnomalyDetectorError {
    fn code(&self) -> Option<&str> {
        BackTestAnomalyDetectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BackTestAnomalyDetectorError {
    /// Creates a new `BackTestAnomalyDetectorError`.
    pub fn new(kind: BackTestAnomalyDetectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BackTestAnomalyDetectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BackTestAnomalyDetectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BackTestAnomalyDetectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BackTestAnomalyDetectorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BackTestAnomalyDetectorErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            BackTestAnomalyDetectorErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `BackTestAnomalyDetectorErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BackTestAnomalyDetectorErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BackTestAnomalyDetectorErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BackTestAnomalyDetectorErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BackTestAnomalyDetectorErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            BackTestAnomalyDetectorErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `BackTestAnomalyDetectorErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BackTestAnomalyDetectorErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BackTestAnomalyDetectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BackTestAnomalyDetectorErrorKind::AccessDeniedException(_inner) => Some(_inner),
            BackTestAnomalyDetectorErrorKind::InternalServerException(_inner) => Some(_inner),
            BackTestAnomalyDetectorErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            BackTestAnomalyDetectorErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            BackTestAnomalyDetectorErrorKind::ValidationException(_inner) => Some(_inner),
            BackTestAnomalyDetectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAlert` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAlertError {
    /// Kind of error that occurred.
    pub kind: CreateAlertErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAlert` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAlertErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Try your request again.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request exceeded the service's quotas. Check the service quotas and try again.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAlertError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAlertErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateAlertErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateAlertErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateAlertErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateAlertErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateAlertErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateAlertErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateAlertErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAlertError {
    fn code(&self) -> Option<&str> {
        CreateAlertError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAlertError {
    /// Creates a new `CreateAlertError`.
    pub fn new(kind: CreateAlertErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAlertError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAlertErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAlertError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAlertErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAlertErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateAlertErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateAlertErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateAlertErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateAlertErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, CreateAlertErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `CreateAlertErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAlertErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAlertErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAlertErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAlertErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAlertErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAlertErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateAlertErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateAlertError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAlertErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateAlertErrorKind::ConflictException(_inner) => Some(_inner),
            CreateAlertErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateAlertErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateAlertErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateAlertErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateAlertErrorKind::ValidationException(_inner) => Some(_inner),
            CreateAlertErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAnomalyDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAnomalyDetectorError {
    /// Kind of error that occurred.
    pub kind: CreateAnomalyDetectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAnomalyDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAnomalyDetectorErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Try your request again.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The request exceeded the service's quotas. Check the service quotas and try again.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAnomalyDetectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAnomalyDetectorErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateAnomalyDetectorErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateAnomalyDetectorErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateAnomalyDetectorErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateAnomalyDetectorErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateAnomalyDetectorErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateAnomalyDetectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAnomalyDetectorError {
    fn code(&self) -> Option<&str> {
        CreateAnomalyDetectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAnomalyDetectorError {
    /// Creates a new `CreateAnomalyDetectorError`.
    pub fn new(kind: CreateAnomalyDetectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAnomalyDetectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAnomalyDetectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAnomalyDetectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAnomalyDetectorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAnomalyDetectorErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAnomalyDetectorErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAnomalyDetectorErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAnomalyDetectorErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAnomalyDetectorErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAnomalyDetectorErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAnomalyDetectorErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAnomalyDetectorErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAnomalyDetectorErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAnomalyDetectorErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAnomalyDetectorErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAnomalyDetectorErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateAnomalyDetectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAnomalyDetectorErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateAnomalyDetectorErrorKind::ConflictException(_inner) => Some(_inner),
            CreateAnomalyDetectorErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateAnomalyDetectorErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateAnomalyDetectorErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateAnomalyDetectorErrorKind::ValidationException(_inner) => Some(_inner),
            CreateAnomalyDetectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMetricSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMetricSetError {
    /// Kind of error that occurred.
    pub kind: CreateMetricSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMetricSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMetricSetErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Try your request again.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request exceeded the service's quotas. Check the service quotas and try again.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMetricSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMetricSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateMetricSetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateMetricSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateMetricSetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateMetricSetErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateMetricSetErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateMetricSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateMetricSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMetricSetError {
    fn code(&self) -> Option<&str> {
        CreateMetricSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMetricSetError {
    /// Creates a new `CreateMetricSetError`.
    pub fn new(kind: CreateMetricSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMetricSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMetricSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMetricSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMetricSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMetricSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMetricSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMetricSetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateMetricSetErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateMetricSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMetricSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMetricSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMetricSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMetricSetErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMetricSetErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMetricSetErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMetricSetErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMetricSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateMetricSetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateMetricSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMetricSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateMetricSetErrorKind::ConflictException(_inner) => Some(_inner),
            CreateMetricSetErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateMetricSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateMetricSetErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateMetricSetErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateMetricSetErrorKind::ValidationException(_inner) => Some(_inner),
            CreateMetricSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeactivateAnomalyDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeactivateAnomalyDetectorError {
    /// Kind of error that occurred.
    pub kind: DeactivateAnomalyDetectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeactivateAnomalyDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeactivateAnomalyDetectorErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Try your request again.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeactivateAnomalyDetectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeactivateAnomalyDetectorErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeactivateAnomalyDetectorErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeactivateAnomalyDetectorErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeactivateAnomalyDetectorErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeactivateAnomalyDetectorErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeactivateAnomalyDetectorErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeactivateAnomalyDetectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeactivateAnomalyDetectorError {
    fn code(&self) -> Option<&str> {
        DeactivateAnomalyDetectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeactivateAnomalyDetectorError {
    /// Creates a new `DeactivateAnomalyDetectorError`.
    pub fn new(kind: DeactivateAnomalyDetectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeactivateAnomalyDetectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeactivateAnomalyDetectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeactivateAnomalyDetectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeactivateAnomalyDetectorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeactivateAnomalyDetectorErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateAnomalyDetectorErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeactivateAnomalyDetectorErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateAnomalyDetectorErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeactivateAnomalyDetectorErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateAnomalyDetectorErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeactivateAnomalyDetectorErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateAnomalyDetectorErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeactivateAnomalyDetectorErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateAnomalyDetectorErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DeactivateAnomalyDetectorErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeactivateAnomalyDetectorErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeactivateAnomalyDetectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeactivateAnomalyDetectorErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeactivateAnomalyDetectorErrorKind::ConflictException(_inner) => Some(_inner),
            DeactivateAnomalyDetectorErrorKind::InternalServerException(_inner) => Some(_inner),
            DeactivateAnomalyDetectorErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeactivateAnomalyDetectorErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeactivateAnomalyDetectorErrorKind::ValidationException(_inner) => Some(_inner),
            DeactivateAnomalyDetectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAlert` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAlertError {
    /// Kind of error that occurred.
    pub kind: DeleteAlertErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAlert` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAlertErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAlertError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAlertErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteAlertErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteAlertErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteAlertErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteAlertErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteAlertErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAlertError {
    fn code(&self) -> Option<&str> {
        DeleteAlertError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAlertError {
    /// Creates a new `DeleteAlertError`.
    pub fn new(kind: DeleteAlertErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAlertError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAlertErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAlertError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAlertErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAlertErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteAlertErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteAlertErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteAlertErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `DeleteAlertErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAlertErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAlertErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAlertErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAlertErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteAlertErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteAlertError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAlertErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteAlertErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteAlertErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteAlertErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteAlertErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteAlertErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAnomalyDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAnomalyDetectorError {
    /// Kind of error that occurred.
    pub kind: DeleteAnomalyDetectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAnomalyDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAnomalyDetectorErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>There was a conflict processing the request. Try your request again.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAnomalyDetectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAnomalyDetectorErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteAnomalyDetectorErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteAnomalyDetectorErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteAnomalyDetectorErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteAnomalyDetectorErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteAnomalyDetectorErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteAnomalyDetectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAnomalyDetectorError {
    fn code(&self) -> Option<&str> {
        DeleteAnomalyDetectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAnomalyDetectorError {
    /// Creates a new `DeleteAnomalyDetectorError`.
    pub fn new(kind: DeleteAnomalyDetectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAnomalyDetectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAnomalyDetectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAnomalyDetectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAnomalyDetectorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAnomalyDetectorErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAnomalyDetectorErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAnomalyDetectorErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAnomalyDetectorErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAnomalyDetectorErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAnomalyDetectorErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAnomalyDetectorErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAnomalyDetectorErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAnomalyDetectorErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAnomalyDetectorErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAnomalyDetectorErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAnomalyDetectorErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteAnomalyDetectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAnomalyDetectorErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteAnomalyDetectorErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteAnomalyDetectorErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteAnomalyDetectorErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteAnomalyDetectorErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteAnomalyDetectorErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteAnomalyDetectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAlert` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAlertError {
    /// Kind of error that occurred.
    pub kind: DescribeAlertErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAlert` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAlertErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAlertError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAlertErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeAlertErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeAlertErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeAlertErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeAlertErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeAlertErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAlertError {
    fn code(&self) -> Option<&str> {
        DescribeAlertError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAlertError {
    /// Creates a new `DescribeAlertError`.
    pub fn new(kind: DescribeAlertErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAlertError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAlertErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAlertError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAlertErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAlertErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DescribeAlertErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DescribeAlertErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAlertErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAlertErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAlertErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAlertErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAlertErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAlertErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeAlertErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeAlertError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAlertErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeAlertErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeAlertErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAlertErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeAlertErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeAlertErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAnomalyDetectionExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAnomalyDetectionExecutionsError {
    /// Kind of error that occurred.
    pub kind: DescribeAnomalyDetectionExecutionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAnomalyDetectionExecutions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAnomalyDetectionExecutionsErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAnomalyDetectionExecutionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAnomalyDetectionExecutionsErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAnomalyDetectionExecutionsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAnomalyDetectionExecutionsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAnomalyDetectionExecutionsErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAnomalyDetectionExecutionsErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeAnomalyDetectionExecutionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAnomalyDetectionExecutionsError {
    fn code(&self) -> Option<&str> {
        DescribeAnomalyDetectionExecutionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAnomalyDetectionExecutionsError {
    /// Creates a new `DescribeAnomalyDetectionExecutionsError`.
    pub fn new(
        kind: DescribeAnomalyDetectionExecutionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAnomalyDetectionExecutionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAnomalyDetectionExecutionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAnomalyDetectionExecutionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAnomalyDetectionExecutionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAnomalyDetectionExecutionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnomalyDetectionExecutionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAnomalyDetectionExecutionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnomalyDetectionExecutionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAnomalyDetectionExecutionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnomalyDetectionExecutionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAnomalyDetectionExecutionsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnomalyDetectionExecutionsErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAnomalyDetectionExecutionsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnomalyDetectionExecutionsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeAnomalyDetectionExecutionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAnomalyDetectionExecutionsErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DescribeAnomalyDetectionExecutionsErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DescribeAnomalyDetectionExecutionsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeAnomalyDetectionExecutionsErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            DescribeAnomalyDetectionExecutionsErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DescribeAnomalyDetectionExecutionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAnomalyDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAnomalyDetectorError {
    /// Kind of error that occurred.
    pub kind: DescribeAnomalyDetectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAnomalyDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAnomalyDetectorErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAnomalyDetectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAnomalyDetectorErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeAnomalyDetectorErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeAnomalyDetectorErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeAnomalyDetectorErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeAnomalyDetectorErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeAnomalyDetectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAnomalyDetectorError {
    fn code(&self) -> Option<&str> {
        DescribeAnomalyDetectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAnomalyDetectorError {
    /// Creates a new `DescribeAnomalyDetectorError`.
    pub fn new(kind: DescribeAnomalyDetectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAnomalyDetectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAnomalyDetectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAnomalyDetectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAnomalyDetectorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAnomalyDetectorErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnomalyDetectorErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAnomalyDetectorErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnomalyDetectorErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAnomalyDetectorErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnomalyDetectorErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAnomalyDetectorErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnomalyDetectorErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAnomalyDetectorErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAnomalyDetectorErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeAnomalyDetectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAnomalyDetectorErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeAnomalyDetectorErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeAnomalyDetectorErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAnomalyDetectorErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeAnomalyDetectorErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeAnomalyDetectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeMetricSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMetricSetError {
    /// Kind of error that occurred.
    pub kind: DescribeMetricSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMetricSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMetricSetErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMetricSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMetricSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeMetricSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeMetricSetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeMetricSetErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeMetricSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeMetricSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMetricSetError {
    fn code(&self) -> Option<&str> {
        DescribeMetricSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMetricSetError {
    /// Creates a new `DescribeMetricSetError`.
    pub fn new(kind: DescribeMetricSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMetricSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMetricSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMetricSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMetricSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMetricSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMetricSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMetricSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMetricSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMetricSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMetricSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMetricSetErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMetricSetErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMetricSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMetricSetErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeMetricSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMetricSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeMetricSetErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeMetricSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeMetricSetErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeMetricSetErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeMetricSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAnomalyGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAnomalyGroupError {
    /// Kind of error that occurred.
    pub kind: GetAnomalyGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAnomalyGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAnomalyGroupErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAnomalyGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAnomalyGroupErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetAnomalyGroupErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetAnomalyGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetAnomalyGroupErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetAnomalyGroupErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetAnomalyGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAnomalyGroupError {
    fn code(&self) -> Option<&str> {
        GetAnomalyGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAnomalyGroupError {
    /// Creates a new `GetAnomalyGroupError`.
    pub fn new(kind: GetAnomalyGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAnomalyGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAnomalyGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAnomalyGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAnomalyGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAnomalyGroupErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAnomalyGroupErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAnomalyGroupErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAnomalyGroupErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAnomalyGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAnomalyGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAnomalyGroupErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAnomalyGroupErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAnomalyGroupErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetAnomalyGroupErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetAnomalyGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAnomalyGroupErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetAnomalyGroupErrorKind::InternalServerException(_inner) => Some(_inner),
            GetAnomalyGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetAnomalyGroupErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetAnomalyGroupErrorKind::ValidationException(_inner) => Some(_inner),
            GetAnomalyGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFeedback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFeedbackError {
    /// Kind of error that occurred.
    pub kind: GetFeedbackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFeedback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFeedbackErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFeedbackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFeedbackErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetFeedbackErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetFeedbackErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetFeedbackErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetFeedbackErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetFeedbackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFeedbackError {
    fn code(&self) -> Option<&str> {
        GetFeedbackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFeedbackError {
    /// Creates a new `GetFeedbackError`.
    pub fn new(kind: GetFeedbackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFeedbackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFeedbackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFeedbackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFeedbackErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFeedbackErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetFeedbackErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetFeedbackErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetFeedbackErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetFeedbackErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFeedbackErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFeedbackErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFeedbackErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFeedbackErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetFeedbackErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetFeedbackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFeedbackErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetFeedbackErrorKind::InternalServerException(_inner) => Some(_inner),
            GetFeedbackErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetFeedbackErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetFeedbackErrorKind::ValidationException(_inner) => Some(_inner),
            GetFeedbackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSampleData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSampleDataError {
    /// Kind of error that occurred.
    pub kind: GetSampleDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSampleData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSampleDataErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSampleDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSampleDataErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetSampleDataErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetSampleDataErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetSampleDataErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetSampleDataErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetSampleDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSampleDataError {
    fn code(&self) -> Option<&str> {
        GetSampleDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSampleDataError {
    /// Creates a new `GetSampleDataError`.
    pub fn new(kind: GetSampleDataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSampleDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSampleDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSampleDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSampleDataErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSampleDataErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetSampleDataErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetSampleDataErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSampleDataErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSampleDataErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSampleDataErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSampleDataErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSampleDataErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSampleDataErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetSampleDataErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetSampleDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSampleDataErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetSampleDataErrorKind::InternalServerException(_inner) => Some(_inner),
            GetSampleDataErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetSampleDataErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetSampleDataErrorKind::ValidationException(_inner) => Some(_inner),
            GetSampleDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAlerts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAlertsError {
    /// Kind of error that occurred.
    pub kind: ListAlertsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAlerts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAlertsErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAlertsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAlertsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAlertsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListAlertsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListAlertsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListAlertsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListAlertsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAlertsError {
    fn code(&self) -> Option<&str> {
        ListAlertsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAlertsError {
    /// Creates a new `ListAlertsError`.
    pub fn new(kind: ListAlertsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAlertsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAlertsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAlertsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAlertsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAlertsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListAlertsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListAlertsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListAlertsErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListAlertsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAlertsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAlertsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, ListAlertsErrorKind::TooManyRequestsException(_))
    }
    /// Returns `true` if the error kind is `ListAlertsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListAlertsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListAlertsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAlertsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAlertsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListAlertsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListAlertsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListAlertsErrorKind::ValidationException(_inner) => Some(_inner),
            ListAlertsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAnomalyDetectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAnomalyDetectorsError {
    /// Kind of error that occurred.
    pub kind: ListAnomalyDetectorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAnomalyDetectors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAnomalyDetectorsErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAnomalyDetectorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAnomalyDetectorsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAnomalyDetectorsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListAnomalyDetectorsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListAnomalyDetectorsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListAnomalyDetectorsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListAnomalyDetectorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAnomalyDetectorsError {
    fn code(&self) -> Option<&str> {
        ListAnomalyDetectorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAnomalyDetectorsError {
    /// Creates a new `ListAnomalyDetectorsError`.
    pub fn new(kind: ListAnomalyDetectorsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAnomalyDetectorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAnomalyDetectorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAnomalyDetectorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAnomalyDetectorsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAnomalyDetectorsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomalyDetectorsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAnomalyDetectorsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomalyDetectorsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAnomalyDetectorsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomalyDetectorsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAnomalyDetectorsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomalyDetectorsErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAnomalyDetectorsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomalyDetectorsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListAnomalyDetectorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAnomalyDetectorsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAnomalyDetectorsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListAnomalyDetectorsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListAnomalyDetectorsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListAnomalyDetectorsErrorKind::ValidationException(_inner) => Some(_inner),
            ListAnomalyDetectorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAnomalyGroupRelatedMetrics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAnomalyGroupRelatedMetricsError {
    /// Kind of error that occurred.
    pub kind: ListAnomalyGroupRelatedMetricsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAnomalyGroupRelatedMetrics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAnomalyGroupRelatedMetricsErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAnomalyGroupRelatedMetricsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAnomalyGroupRelatedMetricsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAnomalyGroupRelatedMetricsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListAnomalyGroupRelatedMetricsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListAnomalyGroupRelatedMetricsErrorKind::TooManyRequestsException(_inner) => {
                _inner.fmt(f)
            }
            ListAnomalyGroupRelatedMetricsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListAnomalyGroupRelatedMetricsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAnomalyGroupRelatedMetricsError {
    fn code(&self) -> Option<&str> {
        ListAnomalyGroupRelatedMetricsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAnomalyGroupRelatedMetricsError {
    /// Creates a new `ListAnomalyGroupRelatedMetricsError`.
    pub fn new(
        kind: ListAnomalyGroupRelatedMetricsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAnomalyGroupRelatedMetricsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAnomalyGroupRelatedMetricsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAnomalyGroupRelatedMetricsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAnomalyGroupRelatedMetricsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAnomalyGroupRelatedMetricsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomalyGroupRelatedMetricsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAnomalyGroupRelatedMetricsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomalyGroupRelatedMetricsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAnomalyGroupRelatedMetricsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomalyGroupRelatedMetricsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAnomalyGroupRelatedMetricsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomalyGroupRelatedMetricsErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAnomalyGroupRelatedMetricsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomalyGroupRelatedMetricsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListAnomalyGroupRelatedMetricsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAnomalyGroupRelatedMetricsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAnomalyGroupRelatedMetricsErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListAnomalyGroupRelatedMetricsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListAnomalyGroupRelatedMetricsErrorKind::TooManyRequestsException(_inner) => {
                Some(_inner)
            }
            ListAnomalyGroupRelatedMetricsErrorKind::ValidationException(_inner) => Some(_inner),
            ListAnomalyGroupRelatedMetricsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAnomalyGroupSummaries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAnomalyGroupSummariesError {
    /// Kind of error that occurred.
    pub kind: ListAnomalyGroupSummariesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAnomalyGroupSummaries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAnomalyGroupSummariesErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAnomalyGroupSummariesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAnomalyGroupSummariesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAnomalyGroupSummariesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListAnomalyGroupSummariesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListAnomalyGroupSummariesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListAnomalyGroupSummariesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListAnomalyGroupSummariesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAnomalyGroupSummariesError {
    fn code(&self) -> Option<&str> {
        ListAnomalyGroupSummariesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAnomalyGroupSummariesError {
    /// Creates a new `ListAnomalyGroupSummariesError`.
    pub fn new(kind: ListAnomalyGroupSummariesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAnomalyGroupSummariesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAnomalyGroupSummariesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAnomalyGroupSummariesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAnomalyGroupSummariesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAnomalyGroupSummariesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomalyGroupSummariesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAnomalyGroupSummariesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomalyGroupSummariesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAnomalyGroupSummariesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomalyGroupSummariesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAnomalyGroupSummariesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomalyGroupSummariesErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAnomalyGroupSummariesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomalyGroupSummariesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListAnomalyGroupSummariesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAnomalyGroupSummariesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAnomalyGroupSummariesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListAnomalyGroupSummariesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListAnomalyGroupSummariesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListAnomalyGroupSummariesErrorKind::ValidationException(_inner) => Some(_inner),
            ListAnomalyGroupSummariesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAnomalyGroupTimeSeries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAnomalyGroupTimeSeriesError {
    /// Kind of error that occurred.
    pub kind: ListAnomalyGroupTimeSeriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAnomalyGroupTimeSeries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAnomalyGroupTimeSeriesErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAnomalyGroupTimeSeriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAnomalyGroupTimeSeriesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAnomalyGroupTimeSeriesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListAnomalyGroupTimeSeriesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListAnomalyGroupTimeSeriesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListAnomalyGroupTimeSeriesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListAnomalyGroupTimeSeriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAnomalyGroupTimeSeriesError {
    fn code(&self) -> Option<&str> {
        ListAnomalyGroupTimeSeriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAnomalyGroupTimeSeriesError {
    /// Creates a new `ListAnomalyGroupTimeSeriesError`.
    pub fn new(kind: ListAnomalyGroupTimeSeriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAnomalyGroupTimeSeriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAnomalyGroupTimeSeriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAnomalyGroupTimeSeriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAnomalyGroupTimeSeriesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAnomalyGroupTimeSeriesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomalyGroupTimeSeriesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAnomalyGroupTimeSeriesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomalyGroupTimeSeriesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAnomalyGroupTimeSeriesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomalyGroupTimeSeriesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAnomalyGroupTimeSeriesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomalyGroupTimeSeriesErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAnomalyGroupTimeSeriesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAnomalyGroupTimeSeriesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListAnomalyGroupTimeSeriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAnomalyGroupTimeSeriesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAnomalyGroupTimeSeriesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListAnomalyGroupTimeSeriesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListAnomalyGroupTimeSeriesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListAnomalyGroupTimeSeriesErrorKind::ValidationException(_inner) => Some(_inner),
            ListAnomalyGroupTimeSeriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMetricSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMetricSetsError {
    /// Kind of error that occurred.
    pub kind: ListMetricSetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMetricSets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMetricSetsErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMetricSetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMetricSetsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListMetricSetsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListMetricSetsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListMetricSetsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListMetricSetsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListMetricSetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMetricSetsError {
    fn code(&self) -> Option<&str> {
        ListMetricSetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMetricSetsError {
    /// Creates a new `ListMetricSetsError`.
    pub fn new(kind: ListMetricSetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMetricSetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMetricSetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMetricSetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMetricSetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMetricSetsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMetricSetsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMetricSetsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMetricSetsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMetricSetsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMetricSetsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMetricSetsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMetricSetsErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMetricSetsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListMetricSetsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListMetricSetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMetricSetsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListMetricSetsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListMetricSetsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListMetricSetsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListMetricSetsErrorKind::ValidationException(_inner) => Some(_inner),
            ListMetricSetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutFeedback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutFeedbackError {
    /// Kind of error that occurred.
    pub kind: PutFeedbackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutFeedback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutFeedbackErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutFeedbackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutFeedbackErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutFeedbackErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutFeedbackErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutFeedbackErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            PutFeedbackErrorKind::ValidationException(_inner) => _inner.fmt(f),
            PutFeedbackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutFeedbackError {
    fn code(&self) -> Option<&str> {
        PutFeedbackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutFeedbackError {
    /// Creates a new `PutFeedbackError`.
    pub fn new(kind: PutFeedbackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutFeedbackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutFeedbackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutFeedbackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutFeedbackErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutFeedbackErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, PutFeedbackErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `PutFeedbackErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, PutFeedbackErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `PutFeedbackErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFeedbackErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFeedbackErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFeedbackErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFeedbackErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, PutFeedbackErrorKind::ValidationException(_))
    }
}
impl std::error::Error for PutFeedbackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutFeedbackErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutFeedbackErrorKind::InternalServerException(_inner) => Some(_inner),
            PutFeedbackErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutFeedbackErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            PutFeedbackErrorKind::ValidationException(_inner) => Some(_inner),
            PutFeedbackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAnomalyDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAnomalyDetectorError {
    /// Kind of error that occurred.
    pub kind: UpdateAnomalyDetectorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAnomalyDetector` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAnomalyDetectorErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAnomalyDetectorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAnomalyDetectorErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateAnomalyDetectorErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateAnomalyDetectorErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateAnomalyDetectorErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateAnomalyDetectorErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateAnomalyDetectorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAnomalyDetectorError {
    fn code(&self) -> Option<&str> {
        UpdateAnomalyDetectorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAnomalyDetectorError {
    /// Creates a new `UpdateAnomalyDetectorError`.
    pub fn new(kind: UpdateAnomalyDetectorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAnomalyDetectorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAnomalyDetectorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAnomalyDetectorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAnomalyDetectorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAnomalyDetectorErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAnomalyDetectorErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAnomalyDetectorErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAnomalyDetectorErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAnomalyDetectorErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAnomalyDetectorErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAnomalyDetectorErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAnomalyDetectorErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAnomalyDetectorErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAnomalyDetectorErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateAnomalyDetectorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAnomalyDetectorErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateAnomalyDetectorErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateAnomalyDetectorErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateAnomalyDetectorErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateAnomalyDetectorErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateAnomalyDetectorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateMetricSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateMetricSetError {
    /// Kind of error that occurred.
    pub kind: UpdateMetricSetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateMetricSet` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateMetricSetErrorKind {
    /// <p>You do not have sufficient permissions to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request exceeded the service's quotas. Check the service quotas and try again.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The request was denied due to too many requests being submitted at the same time.</p>
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateMetricSetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateMetricSetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateMetricSetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateMetricSetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateMetricSetErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateMetricSetErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateMetricSetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateMetricSetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateMetricSetError {
    fn code(&self) -> Option<&str> {
        UpdateMetricSetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateMetricSetError {
    /// Creates a new `UpdateMetricSetError`.
    pub fn new(kind: UpdateMetricSetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateMetricSetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateMetricSetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateMetricSetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateMetricSetErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateMetricSetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMetricSetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMetricSetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMetricSetErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMetricSetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMetricSetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMetricSetErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMetricSetErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMetricSetErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMetricSetErrorKind::TooManyRequestsException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMetricSetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UpdateMetricSetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UpdateMetricSetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateMetricSetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateMetricSetErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateMetricSetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateMetricSetErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateMetricSetErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateMetricSetErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateMetricSetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The reason that validation failed.</p>
    pub reason: std::option::Option<crate::model::ValidationExceptionReason>,
    /// <p>Fields that failed validation.</p>
    pub fields: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
}
impl ValidationException {
    /// <p>The reason that validation failed.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::ValidationExceptionReason> {
        self.reason.as_ref()
    }
    /// <p>Fields that failed validation.</p>
    pub fn fields(&self) -> std::option::Option<&[crate::model::ValidationExceptionField]> {
        self.fields.as_deref()
    }
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.field("reason", &self.reason);
        formatter.field("fields", &self.fields);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<crate::model::ValidationExceptionReason>,
        pub(crate) fields:
            std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The reason that validation failed.</p>
        pub fn reason(mut self, input: crate::model::ValidationExceptionReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason that validation failed.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::ValidationExceptionReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// Appends an item to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>Fields that failed validation.</p>
        pub fn fields(mut self, input: crate::model::ValidationExceptionField) -> Self {
            let mut v = self.fields.unwrap_or_default();
            v.push(input);
            self.fields = Some(v);
            self
        }
        /// <p>Fields that failed validation.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidationExceptionField>>,
        ) -> Self {
            self.fields = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
                reason: self.reason,
                fields: self.fields,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The request was denied due to too many requests being submitted at the same time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                message: self.message,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// <p>The request exceeded the service's quotas. Check the service quotas and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the resource.</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>The quota code.</p>
    pub quota_code: std::option::Option<std::string::String>,
    /// <p>The service code.</p>
    pub service_code: std::option::Option<std::string::String>,
}
impl ServiceQuotaExceededException {
    /// <p>The ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
    /// <p>The quota code.</p>
    pub fn quota_code(&self) -> std::option::Option<&str> {
        self.quota_code.as_deref()
    }
    /// <p>The service code.</p>
    pub fn service_code(&self) -> std::option::Option<&str> {
        self.service_code.as_deref()
    }
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("quota_code", &self.quota_code);
        formatter.field("service_code", &self.service_code);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the resource.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The quota code.</p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>The quota code.</p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// <p>The service code.</p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>The service code.</p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                quota_code: self.quota_code,
                service_code: self.service_code,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}

/// <p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the resource.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    /// <p>The ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the resource.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The request processing has failed because of an unknown error, exception, or failure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>You do not have sufficient permissions to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>There was a conflict processing the request. Try your request again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the resource.</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl ConflictException {
    /// <p>The ID of the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the resource.</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of the resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}
