// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `ActivateAnomalyDetector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`activate_anomaly_detector`](crate::client::Client::activate_anomaly_detector).
///
/// See [`crate::client::fluent_builders::ActivateAnomalyDetector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ActivateAnomalyDetector {
    _private: (),
}
impl ActivateAnomalyDetector {
    /// Creates a new builder-style object to manufacture [`ActivateAnomalyDetectorInput`](crate::input::ActivateAnomalyDetectorInput)
    pub fn builder() -> crate::input::activate_anomaly_detector_input::Builder {
        crate::input::activate_anomaly_detector_input::Builder::default()
    }
    /// Creates a new `ActivateAnomalyDetector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ActivateAnomalyDetector {
    type Output = std::result::Result<
        crate::output::ActivateAnomalyDetectorOutput,
        crate::error::ActivateAnomalyDetectorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_activate_anomaly_detector_error(response)
        } else {
            crate::operation_deser::parse_activate_anomaly_detector_response(response)
        }
    }
}

/// Operation shape for `BackTestAnomalyDetector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`back_test_anomaly_detector`](crate::client::Client::back_test_anomaly_detector).
///
/// See [`crate::client::fluent_builders::BackTestAnomalyDetector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BackTestAnomalyDetector {
    _private: (),
}
impl BackTestAnomalyDetector {
    /// Creates a new builder-style object to manufacture [`BackTestAnomalyDetectorInput`](crate::input::BackTestAnomalyDetectorInput)
    pub fn builder() -> crate::input::back_test_anomaly_detector_input::Builder {
        crate::input::back_test_anomaly_detector_input::Builder::default()
    }
    /// Creates a new `BackTestAnomalyDetector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BackTestAnomalyDetector {
    type Output = std::result::Result<
        crate::output::BackTestAnomalyDetectorOutput,
        crate::error::BackTestAnomalyDetectorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_back_test_anomaly_detector_error(response)
        } else {
            crate::operation_deser::parse_back_test_anomaly_detector_response(response)
        }
    }
}

/// Operation shape for `CreateAlert`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_alert`](crate::client::Client::create_alert).
///
/// See [`crate::client::fluent_builders::CreateAlert`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAlert {
    _private: (),
}
impl CreateAlert {
    /// Creates a new builder-style object to manufacture [`CreateAlertInput`](crate::input::CreateAlertInput)
    pub fn builder() -> crate::input::create_alert_input::Builder {
        crate::input::create_alert_input::Builder::default()
    }
    /// Creates a new `CreateAlert` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAlert {
    type Output =
        std::result::Result<crate::output::CreateAlertOutput, crate::error::CreateAlertError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_alert_error(response)
        } else {
            crate::operation_deser::parse_create_alert_response(response)
        }
    }
}

/// Operation shape for `CreateAnomalyDetector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_anomaly_detector`](crate::client::Client::create_anomaly_detector).
///
/// See [`crate::client::fluent_builders::CreateAnomalyDetector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAnomalyDetector {
    _private: (),
}
impl CreateAnomalyDetector {
    /// Creates a new builder-style object to manufacture [`CreateAnomalyDetectorInput`](crate::input::CreateAnomalyDetectorInput)
    pub fn builder() -> crate::input::create_anomaly_detector_input::Builder {
        crate::input::create_anomaly_detector_input::Builder::default()
    }
    /// Creates a new `CreateAnomalyDetector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAnomalyDetector {
    type Output = std::result::Result<
        crate::output::CreateAnomalyDetectorOutput,
        crate::error::CreateAnomalyDetectorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_anomaly_detector_error(response)
        } else {
            crate::operation_deser::parse_create_anomaly_detector_response(response)
        }
    }
}

/// Operation shape for `CreateMetricSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_metric_set`](crate::client::Client::create_metric_set).
///
/// See [`crate::client::fluent_builders::CreateMetricSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMetricSet {
    _private: (),
}
impl CreateMetricSet {
    /// Creates a new builder-style object to manufacture [`CreateMetricSetInput`](crate::input::CreateMetricSetInput)
    pub fn builder() -> crate::input::create_metric_set_input::Builder {
        crate::input::create_metric_set_input::Builder::default()
    }
    /// Creates a new `CreateMetricSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMetricSet {
    type Output = std::result::Result<
        crate::output::CreateMetricSetOutput,
        crate::error::CreateMetricSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_metric_set_error(response)
        } else {
            crate::operation_deser::parse_create_metric_set_response(response)
        }
    }
}

/// Operation shape for `DeleteAlert`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_alert`](crate::client::Client::delete_alert).
///
/// See [`crate::client::fluent_builders::DeleteAlert`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAlert {
    _private: (),
}
impl DeleteAlert {
    /// Creates a new builder-style object to manufacture [`DeleteAlertInput`](crate::input::DeleteAlertInput)
    pub fn builder() -> crate::input::delete_alert_input::Builder {
        crate::input::delete_alert_input::Builder::default()
    }
    /// Creates a new `DeleteAlert` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAlert {
    type Output =
        std::result::Result<crate::output::DeleteAlertOutput, crate::error::DeleteAlertError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_alert_error(response)
        } else {
            crate::operation_deser::parse_delete_alert_response(response)
        }
    }
}

/// Operation shape for `DeleteAnomalyDetector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_anomaly_detector`](crate::client::Client::delete_anomaly_detector).
///
/// See [`crate::client::fluent_builders::DeleteAnomalyDetector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAnomalyDetector {
    _private: (),
}
impl DeleteAnomalyDetector {
    /// Creates a new builder-style object to manufacture [`DeleteAnomalyDetectorInput`](crate::input::DeleteAnomalyDetectorInput)
    pub fn builder() -> crate::input::delete_anomaly_detector_input::Builder {
        crate::input::delete_anomaly_detector_input::Builder::default()
    }
    /// Creates a new `DeleteAnomalyDetector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAnomalyDetector {
    type Output = std::result::Result<
        crate::output::DeleteAnomalyDetectorOutput,
        crate::error::DeleteAnomalyDetectorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_anomaly_detector_error(response)
        } else {
            crate::operation_deser::parse_delete_anomaly_detector_response(response)
        }
    }
}

/// Operation shape for `DescribeAlert`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_alert`](crate::client::Client::describe_alert).
///
/// See [`crate::client::fluent_builders::DescribeAlert`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAlert {
    _private: (),
}
impl DescribeAlert {
    /// Creates a new builder-style object to manufacture [`DescribeAlertInput`](crate::input::DescribeAlertInput)
    pub fn builder() -> crate::input::describe_alert_input::Builder {
        crate::input::describe_alert_input::Builder::default()
    }
    /// Creates a new `DescribeAlert` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAlert {
    type Output =
        std::result::Result<crate::output::DescribeAlertOutput, crate::error::DescribeAlertError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_alert_error(response)
        } else {
            crate::operation_deser::parse_describe_alert_response(response)
        }
    }
}

/// Operation shape for `DescribeAnomalyDetectionExecutions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_anomaly_detection_executions`](crate::client::Client::describe_anomaly_detection_executions).
///
/// See [`crate::client::fluent_builders::DescribeAnomalyDetectionExecutions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAnomalyDetectionExecutions {
    _private: (),
}
impl DescribeAnomalyDetectionExecutions {
    /// Creates a new builder-style object to manufacture [`DescribeAnomalyDetectionExecutionsInput`](crate::input::DescribeAnomalyDetectionExecutionsInput)
    pub fn builder() -> crate::input::describe_anomaly_detection_executions_input::Builder {
        crate::input::describe_anomaly_detection_executions_input::Builder::default()
    }
    /// Creates a new `DescribeAnomalyDetectionExecutions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAnomalyDetectionExecutions {
    type Output = std::result::Result<
        crate::output::DescribeAnomalyDetectionExecutionsOutput,
        crate::error::DescribeAnomalyDetectionExecutionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_anomaly_detection_executions_error(response)
        } else {
            crate::operation_deser::parse_describe_anomaly_detection_executions_response(response)
        }
    }
}

/// Operation shape for `DescribeAnomalyDetector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_anomaly_detector`](crate::client::Client::describe_anomaly_detector).
///
/// See [`crate::client::fluent_builders::DescribeAnomalyDetector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeAnomalyDetector {
    _private: (),
}
impl DescribeAnomalyDetector {
    /// Creates a new builder-style object to manufacture [`DescribeAnomalyDetectorInput`](crate::input::DescribeAnomalyDetectorInput)
    pub fn builder() -> crate::input::describe_anomaly_detector_input::Builder {
        crate::input::describe_anomaly_detector_input::Builder::default()
    }
    /// Creates a new `DescribeAnomalyDetector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeAnomalyDetector {
    type Output = std::result::Result<
        crate::output::DescribeAnomalyDetectorOutput,
        crate::error::DescribeAnomalyDetectorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_anomaly_detector_error(response)
        } else {
            crate::operation_deser::parse_describe_anomaly_detector_response(response)
        }
    }
}

/// Operation shape for `DescribeMetricSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_metric_set`](crate::client::Client::describe_metric_set).
///
/// See [`crate::client::fluent_builders::DescribeMetricSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMetricSet {
    _private: (),
}
impl DescribeMetricSet {
    /// Creates a new builder-style object to manufacture [`DescribeMetricSetInput`](crate::input::DescribeMetricSetInput)
    pub fn builder() -> crate::input::describe_metric_set_input::Builder {
        crate::input::describe_metric_set_input::Builder::default()
    }
    /// Creates a new `DescribeMetricSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMetricSet {
    type Output = std::result::Result<
        crate::output::DescribeMetricSetOutput,
        crate::error::DescribeMetricSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_metric_set_error(response)
        } else {
            crate::operation_deser::parse_describe_metric_set_response(response)
        }
    }
}

/// Operation shape for `GetAnomalyGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_anomaly_group`](crate::client::Client::get_anomaly_group).
///
/// See [`crate::client::fluent_builders::GetAnomalyGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAnomalyGroup {
    _private: (),
}
impl GetAnomalyGroup {
    /// Creates a new builder-style object to manufacture [`GetAnomalyGroupInput`](crate::input::GetAnomalyGroupInput)
    pub fn builder() -> crate::input::get_anomaly_group_input::Builder {
        crate::input::get_anomaly_group_input::Builder::default()
    }
    /// Creates a new `GetAnomalyGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAnomalyGroup {
    type Output = std::result::Result<
        crate::output::GetAnomalyGroupOutput,
        crate::error::GetAnomalyGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_anomaly_group_error(response)
        } else {
            crate::operation_deser::parse_get_anomaly_group_response(response)
        }
    }
}

/// Operation shape for `GetFeedback`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_feedback`](crate::client::Client::get_feedback).
///
/// See [`crate::client::fluent_builders::GetFeedback`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFeedback {
    _private: (),
}
impl GetFeedback {
    /// Creates a new builder-style object to manufacture [`GetFeedbackInput`](crate::input::GetFeedbackInput)
    pub fn builder() -> crate::input::get_feedback_input::Builder {
        crate::input::get_feedback_input::Builder::default()
    }
    /// Creates a new `GetFeedback` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFeedback {
    type Output =
        std::result::Result<crate::output::GetFeedbackOutput, crate::error::GetFeedbackError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_feedback_error(response)
        } else {
            crate::operation_deser::parse_get_feedback_response(response)
        }
    }
}

/// Operation shape for `GetSampleData`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_sample_data`](crate::client::Client::get_sample_data).
///
/// See [`crate::client::fluent_builders::GetSampleData`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSampleData {
    _private: (),
}
impl GetSampleData {
    /// Creates a new builder-style object to manufacture [`GetSampleDataInput`](crate::input::GetSampleDataInput)
    pub fn builder() -> crate::input::get_sample_data_input::Builder {
        crate::input::get_sample_data_input::Builder::default()
    }
    /// Creates a new `GetSampleData` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSampleData {
    type Output =
        std::result::Result<crate::output::GetSampleDataOutput, crate::error::GetSampleDataError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_sample_data_error(response)
        } else {
            crate::operation_deser::parse_get_sample_data_response(response)
        }
    }
}

/// Operation shape for `ListAlerts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_alerts`](crate::client::Client::list_alerts).
///
/// See [`crate::client::fluent_builders::ListAlerts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAlerts {
    _private: (),
}
impl ListAlerts {
    /// Creates a new builder-style object to manufacture [`ListAlertsInput`](crate::input::ListAlertsInput)
    pub fn builder() -> crate::input::list_alerts_input::Builder {
        crate::input::list_alerts_input::Builder::default()
    }
    /// Creates a new `ListAlerts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAlerts {
    type Output =
        std::result::Result<crate::output::ListAlertsOutput, crate::error::ListAlertsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_alerts_error(response)
        } else {
            crate::operation_deser::parse_list_alerts_response(response)
        }
    }
}

/// Operation shape for `ListAnomalyDetectors`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_anomaly_detectors`](crate::client::Client::list_anomaly_detectors).
///
/// See [`crate::client::fluent_builders::ListAnomalyDetectors`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAnomalyDetectors {
    _private: (),
}
impl ListAnomalyDetectors {
    /// Creates a new builder-style object to manufacture [`ListAnomalyDetectorsInput`](crate::input::ListAnomalyDetectorsInput)
    pub fn builder() -> crate::input::list_anomaly_detectors_input::Builder {
        crate::input::list_anomaly_detectors_input::Builder::default()
    }
    /// Creates a new `ListAnomalyDetectors` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAnomalyDetectors {
    type Output = std::result::Result<
        crate::output::ListAnomalyDetectorsOutput,
        crate::error::ListAnomalyDetectorsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_anomaly_detectors_error(response)
        } else {
            crate::operation_deser::parse_list_anomaly_detectors_response(response)
        }
    }
}

/// Operation shape for `ListAnomalyGroupRelatedMetrics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_anomaly_group_related_metrics`](crate::client::Client::list_anomaly_group_related_metrics).
///
/// See [`crate::client::fluent_builders::ListAnomalyGroupRelatedMetrics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAnomalyGroupRelatedMetrics {
    _private: (),
}
impl ListAnomalyGroupRelatedMetrics {
    /// Creates a new builder-style object to manufacture [`ListAnomalyGroupRelatedMetricsInput`](crate::input::ListAnomalyGroupRelatedMetricsInput)
    pub fn builder() -> crate::input::list_anomaly_group_related_metrics_input::Builder {
        crate::input::list_anomaly_group_related_metrics_input::Builder::default()
    }
    /// Creates a new `ListAnomalyGroupRelatedMetrics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAnomalyGroupRelatedMetrics {
    type Output = std::result::Result<
        crate::output::ListAnomalyGroupRelatedMetricsOutput,
        crate::error::ListAnomalyGroupRelatedMetricsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_anomaly_group_related_metrics_error(response)
        } else {
            crate::operation_deser::parse_list_anomaly_group_related_metrics_response(response)
        }
    }
}

/// Operation shape for `ListAnomalyGroupSummaries`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_anomaly_group_summaries`](crate::client::Client::list_anomaly_group_summaries).
///
/// See [`crate::client::fluent_builders::ListAnomalyGroupSummaries`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAnomalyGroupSummaries {
    _private: (),
}
impl ListAnomalyGroupSummaries {
    /// Creates a new builder-style object to manufacture [`ListAnomalyGroupSummariesInput`](crate::input::ListAnomalyGroupSummariesInput)
    pub fn builder() -> crate::input::list_anomaly_group_summaries_input::Builder {
        crate::input::list_anomaly_group_summaries_input::Builder::default()
    }
    /// Creates a new `ListAnomalyGroupSummaries` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAnomalyGroupSummaries {
    type Output = std::result::Result<
        crate::output::ListAnomalyGroupSummariesOutput,
        crate::error::ListAnomalyGroupSummariesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_anomaly_group_summaries_error(response)
        } else {
            crate::operation_deser::parse_list_anomaly_group_summaries_response(response)
        }
    }
}

/// Operation shape for `ListAnomalyGroupTimeSeries`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_anomaly_group_time_series`](crate::client::Client::list_anomaly_group_time_series).
///
/// See [`crate::client::fluent_builders::ListAnomalyGroupTimeSeries`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAnomalyGroupTimeSeries {
    _private: (),
}
impl ListAnomalyGroupTimeSeries {
    /// Creates a new builder-style object to manufacture [`ListAnomalyGroupTimeSeriesInput`](crate::input::ListAnomalyGroupTimeSeriesInput)
    pub fn builder() -> crate::input::list_anomaly_group_time_series_input::Builder {
        crate::input::list_anomaly_group_time_series_input::Builder::default()
    }
    /// Creates a new `ListAnomalyGroupTimeSeries` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAnomalyGroupTimeSeries {
    type Output = std::result::Result<
        crate::output::ListAnomalyGroupTimeSeriesOutput,
        crate::error::ListAnomalyGroupTimeSeriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_anomaly_group_time_series_error(response)
        } else {
            crate::operation_deser::parse_list_anomaly_group_time_series_response(response)
        }
    }
}

/// Operation shape for `ListMetricSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_metric_sets`](crate::client::Client::list_metric_sets).
///
/// See [`crate::client::fluent_builders::ListMetricSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMetricSets {
    _private: (),
}
impl ListMetricSets {
    /// Creates a new builder-style object to manufacture [`ListMetricSetsInput`](crate::input::ListMetricSetsInput)
    pub fn builder() -> crate::input::list_metric_sets_input::Builder {
        crate::input::list_metric_sets_input::Builder::default()
    }
    /// Creates a new `ListMetricSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMetricSets {
    type Output =
        std::result::Result<crate::output::ListMetricSetsOutput, crate::error::ListMetricSetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_metric_sets_error(response)
        } else {
            crate::operation_deser::parse_list_metric_sets_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutFeedback`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_feedback`](crate::client::Client::put_feedback).
///
/// See [`crate::client::fluent_builders::PutFeedback`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutFeedback {
    _private: (),
}
impl PutFeedback {
    /// Creates a new builder-style object to manufacture [`PutFeedbackInput`](crate::input::PutFeedbackInput)
    pub fn builder() -> crate::input::put_feedback_input::Builder {
        crate::input::put_feedback_input::Builder::default()
    }
    /// Creates a new `PutFeedback` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutFeedback {
    type Output =
        std::result::Result<crate::output::PutFeedbackOutput, crate::error::PutFeedbackError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_feedback_error(response)
        } else {
            crate::operation_deser::parse_put_feedback_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateAnomalyDetector`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_anomaly_detector`](crate::client::Client::update_anomaly_detector).
///
/// See [`crate::client::fluent_builders::UpdateAnomalyDetector`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAnomalyDetector {
    _private: (),
}
impl UpdateAnomalyDetector {
    /// Creates a new builder-style object to manufacture [`UpdateAnomalyDetectorInput`](crate::input::UpdateAnomalyDetectorInput)
    pub fn builder() -> crate::input::update_anomaly_detector_input::Builder {
        crate::input::update_anomaly_detector_input::Builder::default()
    }
    /// Creates a new `UpdateAnomalyDetector` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAnomalyDetector {
    type Output = std::result::Result<
        crate::output::UpdateAnomalyDetectorOutput,
        crate::error::UpdateAnomalyDetectorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_anomaly_detector_error(response)
        } else {
            crate::operation_deser::parse_update_anomaly_detector_response(response)
        }
    }
}

/// Operation shape for `UpdateMetricSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_metric_set`](crate::client::Client::update_metric_set).
///
/// See [`crate::client::fluent_builders::UpdateMetricSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateMetricSet {
    _private: (),
}
impl UpdateMetricSet {
    /// Creates a new builder-style object to manufacture [`UpdateMetricSetInput`](crate::input::UpdateMetricSetInput)
    pub fn builder() -> crate::input::update_metric_set_input::Builder {
        crate::input::update_metric_set_input::Builder::default()
    }
    /// Creates a new `UpdateMetricSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateMetricSet {
    type Output = std::result::Result<
        crate::output::UpdateMetricSetOutput,
        crate::error::UpdateMetricSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_metric_set_error(response)
        } else {
            crate::operation_deser::parse_update_metric_set_response(response)
        }
    }
}
