// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Contains information about a a field in a validation exception.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionField {
    /// <p>The name of the field.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The message with more information about the validation exception.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ValidationExceptionField {
    /// <p>The name of the field.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The message with more information about the validation exception.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ValidationExceptionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionField");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ValidationExceptionField`](crate::model::ValidationExceptionField)
pub mod validation_exception_field {
    /// A builder for [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the field.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the field.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The message with more information about the validation exception.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message with more information about the validation exception.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionField`](crate::model::ValidationExceptionField)
        pub fn build(self) -> crate::model::ValidationExceptionField {
            crate::model::ValidationExceptionField {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl ValidationExceptionField {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    pub fn builder() -> crate::model::validation_exception_field::Builder {
        crate::model::validation_exception_field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ValidationExceptionReason {
    #[allow(missing_docs)] // documentation missing in model
    CannotParse,
    #[allow(missing_docs)] // documentation missing in model
    FieldValidationFailed,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    #[allow(missing_docs)] // documentation missing in model
    UnknownOperation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ValidationExceptionReason {
    fn from(s: &str) -> Self {
        match s {
            "CANNOT_PARSE" => ValidationExceptionReason::CannotParse,
            "FIELD_VALIDATION_FAILED" => ValidationExceptionReason::FieldValidationFailed,
            "OTHER" => ValidationExceptionReason::Other,
            "UNKNOWN_OPERATION" => ValidationExceptionReason::UnknownOperation,
            other => ValidationExceptionReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ValidationExceptionReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ValidationExceptionReason::from(s))
    }
}
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ValidationExceptionReason::CannotParse => "CANNOT_PARSE",
            ValidationExceptionReason::FieldValidationFailed => "FIELD_VALIDATION_FAILED",
            ValidationExceptionReason::Other => "OTHER",
            ValidationExceptionReason::UnknownOperation => "UNKNOWN_OPERATION",
            ValidationExceptionReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANNOT_PARSE",
            "FIELD_VALIDATION_FAILED",
            "OTHER",
            "UNKNOWN_OPERATION",
        ]
    }
}
impl AsRef<str> for ValidationExceptionReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about source data used to generate a metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricSource {
    /// <p>Contains information about the configuration of the S3 bucket that contains source files.</p>
    pub s3_source_config: std::option::Option<crate::model::S3SourceConfig>,
    /// <p>An object containing information about the AppFlow configuration.</p>
    pub app_flow_config: std::option::Option<crate::model::AppFlowConfig>,
    /// <p>An object containing information about the Amazon CloudWatch monitoring configuration.</p>
    pub cloud_watch_config: std::option::Option<crate::model::CloudWatchConfig>,
    /// <p>An object containing information about the Amazon Relational Database Service (RDS) configuration.</p>
    pub rds_source_config: std::option::Option<crate::model::RdsSourceConfig>,
    /// <p>An object containing information about the Amazon Redshift database configuration.</p>
    pub redshift_source_config: std::option::Option<crate::model::RedshiftSourceConfig>,
}
impl MetricSource {
    /// <p>Contains information about the configuration of the S3 bucket that contains source files.</p>
    pub fn s3_source_config(&self) -> std::option::Option<&crate::model::S3SourceConfig> {
        self.s3_source_config.as_ref()
    }
    /// <p>An object containing information about the AppFlow configuration.</p>
    pub fn app_flow_config(&self) -> std::option::Option<&crate::model::AppFlowConfig> {
        self.app_flow_config.as_ref()
    }
    /// <p>An object containing information about the Amazon CloudWatch monitoring configuration.</p>
    pub fn cloud_watch_config(&self) -> std::option::Option<&crate::model::CloudWatchConfig> {
        self.cloud_watch_config.as_ref()
    }
    /// <p>An object containing information about the Amazon Relational Database Service (RDS) configuration.</p>
    pub fn rds_source_config(&self) -> std::option::Option<&crate::model::RdsSourceConfig> {
        self.rds_source_config.as_ref()
    }
    /// <p>An object containing information about the Amazon Redshift database configuration.</p>
    pub fn redshift_source_config(
        &self,
    ) -> std::option::Option<&crate::model::RedshiftSourceConfig> {
        self.redshift_source_config.as_ref()
    }
}
impl std::fmt::Debug for MetricSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricSource");
        formatter.field("s3_source_config", &self.s3_source_config);
        formatter.field("app_flow_config", &self.app_flow_config);
        formatter.field("cloud_watch_config", &self.cloud_watch_config);
        formatter.field("rds_source_config", &self.rds_source_config);
        formatter.field("redshift_source_config", &self.redshift_source_config);
        formatter.finish()
    }
}
/// See [`MetricSource`](crate::model::MetricSource)
pub mod metric_source {
    /// A builder for [`MetricSource`](crate::model::MetricSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_source_config: std::option::Option<crate::model::S3SourceConfig>,
        pub(crate) app_flow_config: std::option::Option<crate::model::AppFlowConfig>,
        pub(crate) cloud_watch_config: std::option::Option<crate::model::CloudWatchConfig>,
        pub(crate) rds_source_config: std::option::Option<crate::model::RdsSourceConfig>,
        pub(crate) redshift_source_config: std::option::Option<crate::model::RedshiftSourceConfig>,
    }
    impl Builder {
        /// <p>Contains information about the configuration of the S3 bucket that contains source files.</p>
        pub fn s3_source_config(mut self, input: crate::model::S3SourceConfig) -> Self {
            self.s3_source_config = Some(input);
            self
        }
        /// <p>Contains information about the configuration of the S3 bucket that contains source files.</p>
        pub fn set_s3_source_config(
            mut self,
            input: std::option::Option<crate::model::S3SourceConfig>,
        ) -> Self {
            self.s3_source_config = input;
            self
        }
        /// <p>An object containing information about the AppFlow configuration.</p>
        pub fn app_flow_config(mut self, input: crate::model::AppFlowConfig) -> Self {
            self.app_flow_config = Some(input);
            self
        }
        /// <p>An object containing information about the AppFlow configuration.</p>
        pub fn set_app_flow_config(
            mut self,
            input: std::option::Option<crate::model::AppFlowConfig>,
        ) -> Self {
            self.app_flow_config = input;
            self
        }
        /// <p>An object containing information about the Amazon CloudWatch monitoring configuration.</p>
        pub fn cloud_watch_config(mut self, input: crate::model::CloudWatchConfig) -> Self {
            self.cloud_watch_config = Some(input);
            self
        }
        /// <p>An object containing information about the Amazon CloudWatch monitoring configuration.</p>
        pub fn set_cloud_watch_config(
            mut self,
            input: std::option::Option<crate::model::CloudWatchConfig>,
        ) -> Self {
            self.cloud_watch_config = input;
            self
        }
        /// <p>An object containing information about the Amazon Relational Database Service (RDS) configuration.</p>
        pub fn rds_source_config(mut self, input: crate::model::RdsSourceConfig) -> Self {
            self.rds_source_config = Some(input);
            self
        }
        /// <p>An object containing information about the Amazon Relational Database Service (RDS) configuration.</p>
        pub fn set_rds_source_config(
            mut self,
            input: std::option::Option<crate::model::RdsSourceConfig>,
        ) -> Self {
            self.rds_source_config = input;
            self
        }
        /// <p>An object containing information about the Amazon Redshift database configuration.</p>
        pub fn redshift_source_config(mut self, input: crate::model::RedshiftSourceConfig) -> Self {
            self.redshift_source_config = Some(input);
            self
        }
        /// <p>An object containing information about the Amazon Redshift database configuration.</p>
        pub fn set_redshift_source_config(
            mut self,
            input: std::option::Option<crate::model::RedshiftSourceConfig>,
        ) -> Self {
            self.redshift_source_config = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricSource`](crate::model::MetricSource)
        pub fn build(self) -> crate::model::MetricSource {
            crate::model::MetricSource {
                s3_source_config: self.s3_source_config,
                app_flow_config: self.app_flow_config,
                cloud_watch_config: self.cloud_watch_config,
                rds_source_config: self.rds_source_config,
                redshift_source_config: self.redshift_source_config,
            }
        }
    }
}
impl MetricSource {
    /// Creates a new builder-style object to manufacture [`MetricSource`](crate::model::MetricSource)
    pub fn builder() -> crate::model::metric_source::Builder {
        crate::model::metric_source::Builder::default()
    }
}

/// <p>Provides information about the Amazon Redshift database configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RedshiftSourceConfig {
    /// <p>A string identifying the Redshift cluster.</p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The name of the database host.</p>
    pub database_host: std::option::Option<std::string::String>,
    /// <p>The port number where the database can be accessed.</p>
    pub database_port: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Secrets Manager role.</p>
    pub secret_manager_arn: std::option::Option<std::string::String>,
    /// <p>The Redshift database name.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The table name of the Redshift database.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the role providing access to the database.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Contains information about the Amazon Virtual Private Cloud (VPC) configuration.</p>
    pub vpc_configuration: std::option::Option<crate::model::VpcConfiguration>,
}
impl RedshiftSourceConfig {
    /// <p>A string identifying the Redshift cluster.</p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p>The name of the database host.</p>
    pub fn database_host(&self) -> std::option::Option<&str> {
        self.database_host.as_deref()
    }
    /// <p>The port number where the database can be accessed.</p>
    pub fn database_port(&self) -> std::option::Option<i32> {
        self.database_port
    }
    /// <p>The Amazon Resource Name (ARN) of the AWS Secrets Manager role.</p>
    pub fn secret_manager_arn(&self) -> std::option::Option<&str> {
        self.secret_manager_arn.as_deref()
    }
    /// <p>The Redshift database name.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>The table name of the Redshift database.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the role providing access to the database.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Contains information about the Amazon Virtual Private Cloud (VPC) configuration.</p>
    pub fn vpc_configuration(&self) -> std::option::Option<&crate::model::VpcConfiguration> {
        self.vpc_configuration.as_ref()
    }
}
impl std::fmt::Debug for RedshiftSourceConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RedshiftSourceConfig");
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("database_host", &self.database_host);
        formatter.field("database_port", &self.database_port);
        formatter.field("secret_manager_arn", &self.secret_manager_arn);
        formatter.field("database_name", &self.database_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("vpc_configuration", &self.vpc_configuration);
        formatter.finish()
    }
}
/// See [`RedshiftSourceConfig`](crate::model::RedshiftSourceConfig)
pub mod redshift_source_config {
    /// A builder for [`RedshiftSourceConfig`](crate::model::RedshiftSourceConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) database_host: std::option::Option<std::string::String>,
        pub(crate) database_port: std::option::Option<i32>,
        pub(crate) secret_manager_arn: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) vpc_configuration: std::option::Option<crate::model::VpcConfiguration>,
    }
    impl Builder {
        /// <p>A string identifying the Redshift cluster.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>A string identifying the Redshift cluster.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The name of the database host.</p>
        pub fn database_host(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_host = Some(input.into());
            self
        }
        /// <p>The name of the database host.</p>
        pub fn set_database_host(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_host = input;
            self
        }
        /// <p>The port number where the database can be accessed.</p>
        pub fn database_port(mut self, input: i32) -> Self {
            self.database_port = Some(input);
            self
        }
        /// <p>The port number where the database can be accessed.</p>
        pub fn set_database_port(mut self, input: std::option::Option<i32>) -> Self {
            self.database_port = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Secrets Manager role.</p>
        pub fn secret_manager_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_manager_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Secrets Manager role.</p>
        pub fn set_secret_manager_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secret_manager_arn = input;
            self
        }
        /// <p>The Redshift database name.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The Redshift database name.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The table name of the Redshift database.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The table name of the Redshift database.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role providing access to the database.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role providing access to the database.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Contains information about the Amazon Virtual Private Cloud (VPC) configuration.</p>
        pub fn vpc_configuration(mut self, input: crate::model::VpcConfiguration) -> Self {
            self.vpc_configuration = Some(input);
            self
        }
        /// <p>Contains information about the Amazon Virtual Private Cloud (VPC) configuration.</p>
        pub fn set_vpc_configuration(
            mut self,
            input: std::option::Option<crate::model::VpcConfiguration>,
        ) -> Self {
            self.vpc_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`RedshiftSourceConfig`](crate::model::RedshiftSourceConfig)
        pub fn build(self) -> crate::model::RedshiftSourceConfig {
            crate::model::RedshiftSourceConfig {
                cluster_identifier: self.cluster_identifier,
                database_host: self.database_host,
                database_port: self.database_port,
                secret_manager_arn: self.secret_manager_arn,
                database_name: self.database_name,
                table_name: self.table_name,
                role_arn: self.role_arn,
                vpc_configuration: self.vpc_configuration,
            }
        }
    }
}
impl RedshiftSourceConfig {
    /// Creates a new builder-style object to manufacture [`RedshiftSourceConfig`](crate::model::RedshiftSourceConfig)
    pub fn builder() -> crate::model::redshift_source_config::Builder {
        crate::model::redshift_source_config::Builder::default()
    }
}

/// <p>Contains configuration information about the Amazon Virtual Private Cloud (VPC).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcConfiguration {
    /// <p>An array of strings containing the Amazon VPC subnet IDs (e.g., <code>subnet-0bb1c79de3EXAMPLE</code>.</p>
    pub subnet_id_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of strings containing the list of security groups.</p>
    pub security_group_id_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl VpcConfiguration {
    /// <p>An array of strings containing the Amazon VPC subnet IDs (e.g., <code>subnet-0bb1c79de3EXAMPLE</code>.</p>
    pub fn subnet_id_list(&self) -> std::option::Option<&[std::string::String]> {
        self.subnet_id_list.as_deref()
    }
    /// <p>An array of strings containing the list of security groups.</p>
    pub fn security_group_id_list(&self) -> std::option::Option<&[std::string::String]> {
        self.security_group_id_list.as_deref()
    }
}
impl std::fmt::Debug for VpcConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcConfiguration");
        formatter.field("subnet_id_list", &self.subnet_id_list);
        formatter.field("security_group_id_list", &self.security_group_id_list);
        formatter.finish()
    }
}
/// See [`VpcConfiguration`](crate::model::VpcConfiguration)
pub mod vpc_configuration {
    /// A builder for [`VpcConfiguration`](crate::model::VpcConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_id_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_id_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `subnet_id_list`.
        ///
        /// To override the contents of this collection use [`set_subnet_id_list`](Self::set_subnet_id_list).
        ///
        /// <p>An array of strings containing the Amazon VPC subnet IDs (e.g., <code>subnet-0bb1c79de3EXAMPLE</code>.</p>
        pub fn subnet_id_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_id_list.unwrap_or_default();
            v.push(input.into());
            self.subnet_id_list = Some(v);
            self
        }
        /// <p>An array of strings containing the Amazon VPC subnet IDs (e.g., <code>subnet-0bb1c79de3EXAMPLE</code>.</p>
        pub fn set_subnet_id_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_id_list = input;
            self
        }
        /// Appends an item to `security_group_id_list`.
        ///
        /// To override the contents of this collection use [`set_security_group_id_list`](Self::set_security_group_id_list).
        ///
        /// <p>An array of strings containing the list of security groups.</p>
        pub fn security_group_id_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_id_list.unwrap_or_default();
            v.push(input.into());
            self.security_group_id_list = Some(v);
            self
        }
        /// <p>An array of strings containing the list of security groups.</p>
        pub fn set_security_group_id_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_id_list = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcConfiguration`](crate::model::VpcConfiguration)
        pub fn build(self) -> crate::model::VpcConfiguration {
            crate::model::VpcConfiguration {
                subnet_id_list: self.subnet_id_list,
                security_group_id_list: self.security_group_id_list,
            }
        }
    }
}
impl VpcConfiguration {
    /// Creates a new builder-style object to manufacture [`VpcConfiguration`](crate::model::VpcConfiguration)
    pub fn builder() -> crate::model::vpc_configuration::Builder {
        crate::model::vpc_configuration::Builder::default()
    }
}

/// <p>Contains information about the Amazon Relational Database Service (RDS) configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RdsSourceConfig {
    /// <p>A string identifying the database instance.</p>
    pub db_instance_identifier: std::option::Option<std::string::String>,
    /// <p>The host name of the database.</p>
    pub database_host: std::option::Option<std::string::String>,
    /// <p>The port number where the database can be accessed.</p>
    pub database_port: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the AWS Secrets Manager role.</p>
    pub secret_manager_arn: std::option::Option<std::string::String>,
    /// <p>The name of the RDS database.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The name of the table in the database.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the role.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>An object containing information about the Amazon Virtual Private Cloud (VPC) configuration.</p>
    pub vpc_configuration: std::option::Option<crate::model::VpcConfiguration>,
}
impl RdsSourceConfig {
    /// <p>A string identifying the database instance.</p>
    pub fn db_instance_identifier(&self) -> std::option::Option<&str> {
        self.db_instance_identifier.as_deref()
    }
    /// <p>The host name of the database.</p>
    pub fn database_host(&self) -> std::option::Option<&str> {
        self.database_host.as_deref()
    }
    /// <p>The port number where the database can be accessed.</p>
    pub fn database_port(&self) -> std::option::Option<i32> {
        self.database_port
    }
    /// <p>The Amazon Resource Name (ARN) of the AWS Secrets Manager role.</p>
    pub fn secret_manager_arn(&self) -> std::option::Option<&str> {
        self.secret_manager_arn.as_deref()
    }
    /// <p>The name of the RDS database.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>The name of the table in the database.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the role.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>An object containing information about the Amazon Virtual Private Cloud (VPC) configuration.</p>
    pub fn vpc_configuration(&self) -> std::option::Option<&crate::model::VpcConfiguration> {
        self.vpc_configuration.as_ref()
    }
}
impl std::fmt::Debug for RdsSourceConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RdsSourceConfig");
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.field("database_host", &self.database_host);
        formatter.field("database_port", &self.database_port);
        formatter.field("secret_manager_arn", &self.secret_manager_arn);
        formatter.field("database_name", &self.database_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("vpc_configuration", &self.vpc_configuration);
        formatter.finish()
    }
}
/// See [`RdsSourceConfig`](crate::model::RdsSourceConfig)
pub mod rds_source_config {
    /// A builder for [`RdsSourceConfig`](crate::model::RdsSourceConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) database_host: std::option::Option<std::string::String>,
        pub(crate) database_port: std::option::Option<i32>,
        pub(crate) secret_manager_arn: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) vpc_configuration: std::option::Option<crate::model::VpcConfiguration>,
    }
    impl Builder {
        /// <p>A string identifying the database instance.</p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>A string identifying the database instance.</p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p>The host name of the database.</p>
        pub fn database_host(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_host = Some(input.into());
            self
        }
        /// <p>The host name of the database.</p>
        pub fn set_database_host(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_host = input;
            self
        }
        /// <p>The port number where the database can be accessed.</p>
        pub fn database_port(mut self, input: i32) -> Self {
            self.database_port = Some(input);
            self
        }
        /// <p>The port number where the database can be accessed.</p>
        pub fn set_database_port(mut self, input: std::option::Option<i32>) -> Self {
            self.database_port = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Secrets Manager role.</p>
        pub fn secret_manager_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_manager_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the AWS Secrets Manager role.</p>
        pub fn set_secret_manager_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secret_manager_arn = input;
            self
        }
        /// <p>The name of the RDS database.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the RDS database.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The name of the table in the database.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table in the database.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>An object containing information about the Amazon Virtual Private Cloud (VPC) configuration.</p>
        pub fn vpc_configuration(mut self, input: crate::model::VpcConfiguration) -> Self {
            self.vpc_configuration = Some(input);
            self
        }
        /// <p>An object containing information about the Amazon Virtual Private Cloud (VPC) configuration.</p>
        pub fn set_vpc_configuration(
            mut self,
            input: std::option::Option<crate::model::VpcConfiguration>,
        ) -> Self {
            self.vpc_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`RdsSourceConfig`](crate::model::RdsSourceConfig)
        pub fn build(self) -> crate::model::RdsSourceConfig {
            crate::model::RdsSourceConfig {
                db_instance_identifier: self.db_instance_identifier,
                database_host: self.database_host,
                database_port: self.database_port,
                secret_manager_arn: self.secret_manager_arn,
                database_name: self.database_name,
                table_name: self.table_name,
                role_arn: self.role_arn,
                vpc_configuration: self.vpc_configuration,
            }
        }
    }
}
impl RdsSourceConfig {
    /// Creates a new builder-style object to manufacture [`RdsSourceConfig`](crate::model::RdsSourceConfig)
    pub fn builder() -> crate::model::rds_source_config::Builder {
        crate::model::rds_source_config::Builder::default()
    }
}

/// <p>Details about an Amazon CloudWatch datasource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudWatchConfig {
    /// <p>An IAM role that gives Amazon Lookout for Metrics permission to access data in Amazon CloudWatch.</p>
    pub role_arn: std::option::Option<std::string::String>,
}
impl CloudWatchConfig {
    /// <p>An IAM role that gives Amazon Lookout for Metrics permission to access data in Amazon CloudWatch.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
}
impl std::fmt::Debug for CloudWatchConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudWatchConfig");
        formatter.field("role_arn", &self.role_arn);
        formatter.finish()
    }
}
/// See [`CloudWatchConfig`](crate::model::CloudWatchConfig)
pub mod cloud_watch_config {
    /// A builder for [`CloudWatchConfig`](crate::model::CloudWatchConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An IAM role that gives Amazon Lookout for Metrics permission to access data in Amazon CloudWatch.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>An IAM role that gives Amazon Lookout for Metrics permission to access data in Amazon CloudWatch.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudWatchConfig`](crate::model::CloudWatchConfig)
        pub fn build(self) -> crate::model::CloudWatchConfig {
            crate::model::CloudWatchConfig {
                role_arn: self.role_arn,
            }
        }
    }
}
impl CloudWatchConfig {
    /// Creates a new builder-style object to manufacture [`CloudWatchConfig`](crate::model::CloudWatchConfig)
    pub fn builder() -> crate::model::cloud_watch_config::Builder {
        crate::model::cloud_watch_config::Builder::default()
    }
}

/// <p>Details about an Amazon AppFlow flow datasource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AppFlowConfig {
    /// <p>An IAM role that gives Amazon Lookout for Metrics permission to access the flow.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p> name of the flow.</p>
    pub flow_name: std::option::Option<std::string::String>,
}
impl AppFlowConfig {
    /// <p>An IAM role that gives Amazon Lookout for Metrics permission to access the flow.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p> name of the flow.</p>
    pub fn flow_name(&self) -> std::option::Option<&str> {
        self.flow_name.as_deref()
    }
}
impl std::fmt::Debug for AppFlowConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AppFlowConfig");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("flow_name", &self.flow_name);
        formatter.finish()
    }
}
/// See [`AppFlowConfig`](crate::model::AppFlowConfig)
pub mod app_flow_config {
    /// A builder for [`AppFlowConfig`](crate::model::AppFlowConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) flow_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An IAM role that gives Amazon Lookout for Metrics permission to access the flow.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>An IAM role that gives Amazon Lookout for Metrics permission to access the flow.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p> name of the flow.</p>
        pub fn flow_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_name = Some(input.into());
            self
        }
        /// <p> name of the flow.</p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AppFlowConfig`](crate::model::AppFlowConfig)
        pub fn build(self) -> crate::model::AppFlowConfig {
            crate::model::AppFlowConfig {
                role_arn: self.role_arn,
                flow_name: self.flow_name,
            }
        }
    }
}
impl AppFlowConfig {
    /// Creates a new builder-style object to manufacture [`AppFlowConfig`](crate::model::AppFlowConfig)
    pub fn builder() -> crate::model::app_flow_config::Builder {
        crate::model::app_flow_config::Builder::default()
    }
}

/// <p>Contains information about the configuration of the S3 bucket that contains source files.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3SourceConfig {
    /// <p>The ARN of an IAM role that has read and write access permissions to the source S3 bucket.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>A list of templated paths to the source files.</p>
    pub templated_path_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of paths to the historical data files.</p>
    pub historical_data_path_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Contains information about a source file's formatting.</p>
    pub file_format_descriptor: std::option::Option<crate::model::FileFormatDescriptor>,
}
impl S3SourceConfig {
    /// <p>The ARN of an IAM role that has read and write access permissions to the source S3 bucket.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>A list of templated paths to the source files.</p>
    pub fn templated_path_list(&self) -> std::option::Option<&[std::string::String]> {
        self.templated_path_list.as_deref()
    }
    /// <p>A list of paths to the historical data files.</p>
    pub fn historical_data_path_list(&self) -> std::option::Option<&[std::string::String]> {
        self.historical_data_path_list.as_deref()
    }
    /// <p>Contains information about a source file's formatting.</p>
    pub fn file_format_descriptor(
        &self,
    ) -> std::option::Option<&crate::model::FileFormatDescriptor> {
        self.file_format_descriptor.as_ref()
    }
}
impl std::fmt::Debug for S3SourceConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3SourceConfig");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("templated_path_list", &self.templated_path_list);
        formatter.field("historical_data_path_list", &self.historical_data_path_list);
        formatter.field("file_format_descriptor", &self.file_format_descriptor);
        formatter.finish()
    }
}
/// See [`S3SourceConfig`](crate::model::S3SourceConfig)
pub mod s3_source_config {
    /// A builder for [`S3SourceConfig`](crate::model::S3SourceConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) templated_path_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) historical_data_path_list:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) file_format_descriptor: std::option::Option<crate::model::FileFormatDescriptor>,
    }
    impl Builder {
        /// <p>The ARN of an IAM role that has read and write access permissions to the source S3 bucket.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of an IAM role that has read and write access permissions to the source S3 bucket.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `templated_path_list`.
        ///
        /// To override the contents of this collection use [`set_templated_path_list`](Self::set_templated_path_list).
        ///
        /// <p>A list of templated paths to the source files.</p>
        pub fn templated_path_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.templated_path_list.unwrap_or_default();
            v.push(input.into());
            self.templated_path_list = Some(v);
            self
        }
        /// <p>A list of templated paths to the source files.</p>
        pub fn set_templated_path_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.templated_path_list = input;
            self
        }
        /// Appends an item to `historical_data_path_list`.
        ///
        /// To override the contents of this collection use [`set_historical_data_path_list`](Self::set_historical_data_path_list).
        ///
        /// <p>A list of paths to the historical data files.</p>
        pub fn historical_data_path_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.historical_data_path_list.unwrap_or_default();
            v.push(input.into());
            self.historical_data_path_list = Some(v);
            self
        }
        /// <p>A list of paths to the historical data files.</p>
        pub fn set_historical_data_path_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.historical_data_path_list = input;
            self
        }
        /// <p>Contains information about a source file's formatting.</p>
        pub fn file_format_descriptor(mut self, input: crate::model::FileFormatDescriptor) -> Self {
            self.file_format_descriptor = Some(input);
            self
        }
        /// <p>Contains information about a source file's formatting.</p>
        pub fn set_file_format_descriptor(
            mut self,
            input: std::option::Option<crate::model::FileFormatDescriptor>,
        ) -> Self {
            self.file_format_descriptor = input;
            self
        }
        /// Consumes the builder and constructs a [`S3SourceConfig`](crate::model::S3SourceConfig)
        pub fn build(self) -> crate::model::S3SourceConfig {
            crate::model::S3SourceConfig {
                role_arn: self.role_arn,
                templated_path_list: self.templated_path_list,
                historical_data_path_list: self.historical_data_path_list,
                file_format_descriptor: self.file_format_descriptor,
            }
        }
    }
}
impl S3SourceConfig {
    /// Creates a new builder-style object to manufacture [`S3SourceConfig`](crate::model::S3SourceConfig)
    pub fn builder() -> crate::model::s3_source_config::Builder {
        crate::model::s3_source_config::Builder::default()
    }
}

/// <p>Contains information about a source file's formatting.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FileFormatDescriptor {
    /// <p>Contains information about how a source CSV data file should be analyzed.</p>
    pub csv_format_descriptor: std::option::Option<crate::model::CsvFormatDescriptor>,
    /// <p>Contains information about how a source JSON data file should be analyzed.</p>
    pub json_format_descriptor: std::option::Option<crate::model::JsonFormatDescriptor>,
}
impl FileFormatDescriptor {
    /// <p>Contains information about how a source CSV data file should be analyzed.</p>
    pub fn csv_format_descriptor(&self) -> std::option::Option<&crate::model::CsvFormatDescriptor> {
        self.csv_format_descriptor.as_ref()
    }
    /// <p>Contains information about how a source JSON data file should be analyzed.</p>
    pub fn json_format_descriptor(
        &self,
    ) -> std::option::Option<&crate::model::JsonFormatDescriptor> {
        self.json_format_descriptor.as_ref()
    }
}
impl std::fmt::Debug for FileFormatDescriptor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FileFormatDescriptor");
        formatter.field("csv_format_descriptor", &self.csv_format_descriptor);
        formatter.field("json_format_descriptor", &self.json_format_descriptor);
        formatter.finish()
    }
}
/// See [`FileFormatDescriptor`](crate::model::FileFormatDescriptor)
pub mod file_format_descriptor {
    /// A builder for [`FileFormatDescriptor`](crate::model::FileFormatDescriptor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) csv_format_descriptor: std::option::Option<crate::model::CsvFormatDescriptor>,
        pub(crate) json_format_descriptor: std::option::Option<crate::model::JsonFormatDescriptor>,
    }
    impl Builder {
        /// <p>Contains information about how a source CSV data file should be analyzed.</p>
        pub fn csv_format_descriptor(mut self, input: crate::model::CsvFormatDescriptor) -> Self {
            self.csv_format_descriptor = Some(input);
            self
        }
        /// <p>Contains information about how a source CSV data file should be analyzed.</p>
        pub fn set_csv_format_descriptor(
            mut self,
            input: std::option::Option<crate::model::CsvFormatDescriptor>,
        ) -> Self {
            self.csv_format_descriptor = input;
            self
        }
        /// <p>Contains information about how a source JSON data file should be analyzed.</p>
        pub fn json_format_descriptor(mut self, input: crate::model::JsonFormatDescriptor) -> Self {
            self.json_format_descriptor = Some(input);
            self
        }
        /// <p>Contains information about how a source JSON data file should be analyzed.</p>
        pub fn set_json_format_descriptor(
            mut self,
            input: std::option::Option<crate::model::JsonFormatDescriptor>,
        ) -> Self {
            self.json_format_descriptor = input;
            self
        }
        /// Consumes the builder and constructs a [`FileFormatDescriptor`](crate::model::FileFormatDescriptor)
        pub fn build(self) -> crate::model::FileFormatDescriptor {
            crate::model::FileFormatDescriptor {
                csv_format_descriptor: self.csv_format_descriptor,
                json_format_descriptor: self.json_format_descriptor,
            }
        }
    }
}
impl FileFormatDescriptor {
    /// Creates a new builder-style object to manufacture [`FileFormatDescriptor`](crate::model::FileFormatDescriptor)
    pub fn builder() -> crate::model::file_format_descriptor::Builder {
        crate::model::file_format_descriptor::Builder::default()
    }
}

/// <p>Contains information about how a source JSON data file should be analyzed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JsonFormatDescriptor {
    /// <p>The level of compression of the source CSV file.</p>
    pub file_compression: std::option::Option<crate::model::JsonFileCompression>,
    /// <p>The character set in which the source JSON file is written.</p>
    pub charset: std::option::Option<std::string::String>,
}
impl JsonFormatDescriptor {
    /// <p>The level of compression of the source CSV file.</p>
    pub fn file_compression(&self) -> std::option::Option<&crate::model::JsonFileCompression> {
        self.file_compression.as_ref()
    }
    /// <p>The character set in which the source JSON file is written.</p>
    pub fn charset(&self) -> std::option::Option<&str> {
        self.charset.as_deref()
    }
}
impl std::fmt::Debug for JsonFormatDescriptor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JsonFormatDescriptor");
        formatter.field("file_compression", &self.file_compression);
        formatter.field("charset", &self.charset);
        formatter.finish()
    }
}
/// See [`JsonFormatDescriptor`](crate::model::JsonFormatDescriptor)
pub mod json_format_descriptor {
    /// A builder for [`JsonFormatDescriptor`](crate::model::JsonFormatDescriptor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_compression: std::option::Option<crate::model::JsonFileCompression>,
        pub(crate) charset: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The level of compression of the source CSV file.</p>
        pub fn file_compression(mut self, input: crate::model::JsonFileCompression) -> Self {
            self.file_compression = Some(input);
            self
        }
        /// <p>The level of compression of the source CSV file.</p>
        pub fn set_file_compression(
            mut self,
            input: std::option::Option<crate::model::JsonFileCompression>,
        ) -> Self {
            self.file_compression = input;
            self
        }
        /// <p>The character set in which the source JSON file is written.</p>
        pub fn charset(mut self, input: impl Into<std::string::String>) -> Self {
            self.charset = Some(input.into());
            self
        }
        /// <p>The character set in which the source JSON file is written.</p>
        pub fn set_charset(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.charset = input;
            self
        }
        /// Consumes the builder and constructs a [`JsonFormatDescriptor`](crate::model::JsonFormatDescriptor)
        pub fn build(self) -> crate::model::JsonFormatDescriptor {
            crate::model::JsonFormatDescriptor {
                file_compression: self.file_compression,
                charset: self.charset,
            }
        }
    }
}
impl JsonFormatDescriptor {
    /// Creates a new builder-style object to manufacture [`JsonFormatDescriptor`](crate::model::JsonFormatDescriptor)
    pub fn builder() -> crate::model::json_format_descriptor::Builder {
        crate::model::json_format_descriptor::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JsonFileCompression {
    #[allow(missing_docs)] // documentation missing in model
    Gzip,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JsonFileCompression {
    fn from(s: &str) -> Self {
        match s {
            "GZIP" => JsonFileCompression::Gzip,
            "NONE" => JsonFileCompression::None,
            other => JsonFileCompression::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JsonFileCompression {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JsonFileCompression::from(s))
    }
}
impl JsonFileCompression {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JsonFileCompression::Gzip => "GZIP",
            JsonFileCompression::None => "NONE",
            JsonFileCompression::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GZIP", "NONE"]
    }
}
impl AsRef<str> for JsonFileCompression {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about how a source CSV data file should be analyzed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CsvFormatDescriptor {
    /// <p>The level of compression of the source CSV file.</p>
    pub file_compression: std::option::Option<crate::model::CsvFileCompression>,
    /// <p>The character set in which the source CSV file is written.</p>
    pub charset: std::option::Option<std::string::String>,
    /// <p>Whether or not the source CSV file contains a header.</p>
    pub contains_header: std::option::Option<bool>,
    /// <p>The character used to delimit the source CSV file.</p>
    pub delimiter: std::option::Option<std::string::String>,
    /// <p>A list of the source CSV file's headers, if any.</p>
    pub header_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The character used as a quote character.</p>
    pub quote_symbol: std::option::Option<std::string::String>,
}
impl CsvFormatDescriptor {
    /// <p>The level of compression of the source CSV file.</p>
    pub fn file_compression(&self) -> std::option::Option<&crate::model::CsvFileCompression> {
        self.file_compression.as_ref()
    }
    /// <p>The character set in which the source CSV file is written.</p>
    pub fn charset(&self) -> std::option::Option<&str> {
        self.charset.as_deref()
    }
    /// <p>Whether or not the source CSV file contains a header.</p>
    pub fn contains_header(&self) -> std::option::Option<bool> {
        self.contains_header
    }
    /// <p>The character used to delimit the source CSV file.</p>
    pub fn delimiter(&self) -> std::option::Option<&str> {
        self.delimiter.as_deref()
    }
    /// <p>A list of the source CSV file's headers, if any.</p>
    pub fn header_list(&self) -> std::option::Option<&[std::string::String]> {
        self.header_list.as_deref()
    }
    /// <p>The character used as a quote character.</p>
    pub fn quote_symbol(&self) -> std::option::Option<&str> {
        self.quote_symbol.as_deref()
    }
}
impl std::fmt::Debug for CsvFormatDescriptor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CsvFormatDescriptor");
        formatter.field("file_compression", &self.file_compression);
        formatter.field("charset", &self.charset);
        formatter.field("contains_header", &self.contains_header);
        formatter.field("delimiter", &self.delimiter);
        formatter.field("header_list", &self.header_list);
        formatter.field("quote_symbol", &self.quote_symbol);
        formatter.finish()
    }
}
/// See [`CsvFormatDescriptor`](crate::model::CsvFormatDescriptor)
pub mod csv_format_descriptor {
    /// A builder for [`CsvFormatDescriptor`](crate::model::CsvFormatDescriptor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_compression: std::option::Option<crate::model::CsvFileCompression>,
        pub(crate) charset: std::option::Option<std::string::String>,
        pub(crate) contains_header: std::option::Option<bool>,
        pub(crate) delimiter: std::option::Option<std::string::String>,
        pub(crate) header_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) quote_symbol: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The level of compression of the source CSV file.</p>
        pub fn file_compression(mut self, input: crate::model::CsvFileCompression) -> Self {
            self.file_compression = Some(input);
            self
        }
        /// <p>The level of compression of the source CSV file.</p>
        pub fn set_file_compression(
            mut self,
            input: std::option::Option<crate::model::CsvFileCompression>,
        ) -> Self {
            self.file_compression = input;
            self
        }
        /// <p>The character set in which the source CSV file is written.</p>
        pub fn charset(mut self, input: impl Into<std::string::String>) -> Self {
            self.charset = Some(input.into());
            self
        }
        /// <p>The character set in which the source CSV file is written.</p>
        pub fn set_charset(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.charset = input;
            self
        }
        /// <p>Whether or not the source CSV file contains a header.</p>
        pub fn contains_header(mut self, input: bool) -> Self {
            self.contains_header = Some(input);
            self
        }
        /// <p>Whether or not the source CSV file contains a header.</p>
        pub fn set_contains_header(mut self, input: std::option::Option<bool>) -> Self {
            self.contains_header = input;
            self
        }
        /// <p>The character used to delimit the source CSV file.</p>
        pub fn delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.delimiter = Some(input.into());
            self
        }
        /// <p>The character used to delimit the source CSV file.</p>
        pub fn set_delimiter(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.delimiter = input;
            self
        }
        /// Appends an item to `header_list`.
        ///
        /// To override the contents of this collection use [`set_header_list`](Self::set_header_list).
        ///
        /// <p>A list of the source CSV file's headers, if any.</p>
        pub fn header_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.header_list.unwrap_or_default();
            v.push(input.into());
            self.header_list = Some(v);
            self
        }
        /// <p>A list of the source CSV file's headers, if any.</p>
        pub fn set_header_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.header_list = input;
            self
        }
        /// <p>The character used as a quote character.</p>
        pub fn quote_symbol(mut self, input: impl Into<std::string::String>) -> Self {
            self.quote_symbol = Some(input.into());
            self
        }
        /// <p>The character used as a quote character.</p>
        pub fn set_quote_symbol(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quote_symbol = input;
            self
        }
        /// Consumes the builder and constructs a [`CsvFormatDescriptor`](crate::model::CsvFormatDescriptor)
        pub fn build(self) -> crate::model::CsvFormatDescriptor {
            crate::model::CsvFormatDescriptor {
                file_compression: self.file_compression,
                charset: self.charset,
                contains_header: self.contains_header,
                delimiter: self.delimiter,
                header_list: self.header_list,
                quote_symbol: self.quote_symbol,
            }
        }
    }
}
impl CsvFormatDescriptor {
    /// Creates a new builder-style object to manufacture [`CsvFormatDescriptor`](crate::model::CsvFormatDescriptor)
    pub fn builder() -> crate::model::csv_format_descriptor::Builder {
        crate::model::csv_format_descriptor::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CsvFileCompression {
    #[allow(missing_docs)] // documentation missing in model
    Gzip,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CsvFileCompression {
    fn from(s: &str) -> Self {
        match s {
            "GZIP" => CsvFileCompression::Gzip,
            "NONE" => CsvFileCompression::None,
            other => CsvFileCompression::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CsvFileCompression {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CsvFileCompression::from(s))
    }
}
impl CsvFileCompression {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CsvFileCompression::Gzip => "GZIP",
            CsvFileCompression::None => "NONE",
            CsvFileCompression::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GZIP", "NONE"]
    }
}
impl AsRef<str> for CsvFileCompression {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Frequency {
    #[allow(missing_docs)] // documentation missing in model
    P1D,
    #[allow(missing_docs)] // documentation missing in model
    Pt10M,
    #[allow(missing_docs)] // documentation missing in model
    Pt1H,
    #[allow(missing_docs)] // documentation missing in model
    Pt5M,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Frequency {
    fn from(s: &str) -> Self {
        match s {
            "P1D" => Frequency::P1D,
            "PT10M" => Frequency::Pt10M,
            "PT1H" => Frequency::Pt1H,
            "PT5M" => Frequency::Pt5M,
            other => Frequency::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Frequency {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Frequency::from(s))
    }
}
impl Frequency {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Frequency::P1D => "P1D",
            Frequency::Pt10M => "PT10M",
            Frequency::Pt1H => "PT1H",
            Frequency::Pt5M => "PT5M",
            Frequency::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["P1D", "PT10M", "PT1H", "PT5M"]
    }
}
impl AsRef<str> for Frequency {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the column used to track time in a source data file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimestampColumn {
    /// <p>The name of the timestamp column.</p>
    pub column_name: std::option::Option<std::string::String>,
    /// <p>The format of the timestamp column.</p>
    pub column_format: std::option::Option<std::string::String>,
}
impl TimestampColumn {
    /// <p>The name of the timestamp column.</p>
    pub fn column_name(&self) -> std::option::Option<&str> {
        self.column_name.as_deref()
    }
    /// <p>The format of the timestamp column.</p>
    pub fn column_format(&self) -> std::option::Option<&str> {
        self.column_format.as_deref()
    }
}
impl std::fmt::Debug for TimestampColumn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimestampColumn");
        formatter.field("column_name", &self.column_name);
        formatter.field("column_format", &self.column_format);
        formatter.finish()
    }
}
/// See [`TimestampColumn`](crate::model::TimestampColumn)
pub mod timestamp_column {
    /// A builder for [`TimestampColumn`](crate::model::TimestampColumn)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column_name: std::option::Option<std::string::String>,
        pub(crate) column_format: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the timestamp column.</p>
        pub fn column_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.column_name = Some(input.into());
            self
        }
        /// <p>The name of the timestamp column.</p>
        pub fn set_column_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.column_name = input;
            self
        }
        /// <p>The format of the timestamp column.</p>
        pub fn column_format(mut self, input: impl Into<std::string::String>) -> Self {
            self.column_format = Some(input.into());
            self
        }
        /// <p>The format of the timestamp column.</p>
        pub fn set_column_format(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.column_format = input;
            self
        }
        /// Consumes the builder and constructs a [`TimestampColumn`](crate::model::TimestampColumn)
        pub fn build(self) -> crate::model::TimestampColumn {
            crate::model::TimestampColumn {
                column_name: self.column_name,
                column_format: self.column_format,
            }
        }
    }
}
impl TimestampColumn {
    /// Creates a new builder-style object to manufacture [`TimestampColumn`](crate::model::TimestampColumn)
    pub fn builder() -> crate::model::timestamp_column::Builder {
        crate::model::timestamp_column::Builder::default()
    }
}

/// <p>A calculation made by contrasting a measure and a dimension from your source data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Metric {
    /// <p>The name of the metric.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The function with which the metric is calculated.</p>
    pub aggregation_function: std::option::Option<crate::model::AggregationFunction>,
    /// <p>The namespace for the metric.</p>
    pub namespace: std::option::Option<std::string::String>,
}
impl Metric {
    /// <p>The name of the metric.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The function with which the metric is calculated.</p>
    pub fn aggregation_function(&self) -> std::option::Option<&crate::model::AggregationFunction> {
        self.aggregation_function.as_ref()
    }
    /// <p>The namespace for the metric.</p>
    pub fn namespace(&self) -> std::option::Option<&str> {
        self.namespace.as_deref()
    }
}
impl std::fmt::Debug for Metric {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Metric");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("aggregation_function", &self.aggregation_function);
        formatter.field("namespace", &self.namespace);
        formatter.finish()
    }
}
/// See [`Metric`](crate::model::Metric)
pub mod metric {
    /// A builder for [`Metric`](crate::model::Metric)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) aggregation_function: std::option::Option<crate::model::AggregationFunction>,
        pub(crate) namespace: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the metric.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the metric.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The function with which the metric is calculated.</p>
        pub fn aggregation_function(mut self, input: crate::model::AggregationFunction) -> Self {
            self.aggregation_function = Some(input);
            self
        }
        /// <p>The function with which the metric is calculated.</p>
        pub fn set_aggregation_function(
            mut self,
            input: std::option::Option<crate::model::AggregationFunction>,
        ) -> Self {
            self.aggregation_function = input;
            self
        }
        /// <p>The namespace for the metric.</p>
        pub fn namespace(mut self, input: impl Into<std::string::String>) -> Self {
            self.namespace = Some(input.into());
            self
        }
        /// <p>The namespace for the metric.</p>
        pub fn set_namespace(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.namespace = input;
            self
        }
        /// Consumes the builder and constructs a [`Metric`](crate::model::Metric)
        pub fn build(self) -> crate::model::Metric {
            crate::model::Metric {
                metric_name: self.metric_name,
                aggregation_function: self.aggregation_function,
                namespace: self.namespace,
            }
        }
    }
}
impl Metric {
    /// Creates a new builder-style object to manufacture [`Metric`](crate::model::Metric)
    pub fn builder() -> crate::model::metric::Builder {
        crate::model::metric::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AggregationFunction {
    #[allow(missing_docs)] // documentation missing in model
    Avg,
    #[allow(missing_docs)] // documentation missing in model
    Sum,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AggregationFunction {
    fn from(s: &str) -> Self {
        match s {
            "AVG" => AggregationFunction::Avg,
            "SUM" => AggregationFunction::Sum,
            other => AggregationFunction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AggregationFunction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AggregationFunction::from(s))
    }
}
impl AggregationFunction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AggregationFunction::Avg => "AVG",
            AggregationFunction::Sum => "SUM",
            AggregationFunction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVG", "SUM"]
    }
}
impl AsRef<str> for AggregationFunction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about a detector's configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalyDetectorConfig {
    /// <p>The frequency at which the detector analyzes its source data.</p>
    pub anomaly_detector_frequency: std::option::Option<crate::model::Frequency>,
}
impl AnomalyDetectorConfig {
    /// <p>The frequency at which the detector analyzes its source data.</p>
    pub fn anomaly_detector_frequency(&self) -> std::option::Option<&crate::model::Frequency> {
        self.anomaly_detector_frequency.as_ref()
    }
}
impl std::fmt::Debug for AnomalyDetectorConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalyDetectorConfig");
        formatter.field(
            "anomaly_detector_frequency",
            &self.anomaly_detector_frequency,
        );
        formatter.finish()
    }
}
/// See [`AnomalyDetectorConfig`](crate::model::AnomalyDetectorConfig)
pub mod anomaly_detector_config {
    /// A builder for [`AnomalyDetectorConfig`](crate::model::AnomalyDetectorConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_detector_frequency: std::option::Option<crate::model::Frequency>,
    }
    impl Builder {
        /// <p>The frequency at which the detector analyzes its source data.</p>
        pub fn anomaly_detector_frequency(mut self, input: crate::model::Frequency) -> Self {
            self.anomaly_detector_frequency = Some(input);
            self
        }
        /// <p>The frequency at which the detector analyzes its source data.</p>
        pub fn set_anomaly_detector_frequency(
            mut self,
            input: std::option::Option<crate::model::Frequency>,
        ) -> Self {
            self.anomaly_detector_frequency = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalyDetectorConfig`](crate::model::AnomalyDetectorConfig)
        pub fn build(self) -> crate::model::AnomalyDetectorConfig {
            crate::model::AnomalyDetectorConfig {
                anomaly_detector_frequency: self.anomaly_detector_frequency,
            }
        }
    }
}
impl AnomalyDetectorConfig {
    /// Creates a new builder-style object to manufacture [`AnomalyDetectorConfig`](crate::model::AnomalyDetectorConfig)
    pub fn builder() -> crate::model::anomaly_detector_config::Builder {
        crate::model::anomaly_detector_config::Builder::default()
    }
}

/// <p>Feedback for an anomalous metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalyGroupTimeSeriesFeedback {
    /// <p>The ID of the anomaly group.</p>
    pub anomaly_group_id: std::option::Option<std::string::String>,
    /// <p>The ID of the metric.</p>
    pub time_series_id: std::option::Option<std::string::String>,
    /// <p>Feedback on whether the metric is a legitimate anomaly.</p>
    pub is_anomaly: std::option::Option<bool>,
}
impl AnomalyGroupTimeSeriesFeedback {
    /// <p>The ID of the anomaly group.</p>
    pub fn anomaly_group_id(&self) -> std::option::Option<&str> {
        self.anomaly_group_id.as_deref()
    }
    /// <p>The ID of the metric.</p>
    pub fn time_series_id(&self) -> std::option::Option<&str> {
        self.time_series_id.as_deref()
    }
    /// <p>Feedback on whether the metric is a legitimate anomaly.</p>
    pub fn is_anomaly(&self) -> std::option::Option<bool> {
        self.is_anomaly
    }
}
impl std::fmt::Debug for AnomalyGroupTimeSeriesFeedback {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalyGroupTimeSeriesFeedback");
        formatter.field("anomaly_group_id", &self.anomaly_group_id);
        formatter.field("time_series_id", &self.time_series_id);
        formatter.field("is_anomaly", &self.is_anomaly);
        formatter.finish()
    }
}
/// See [`AnomalyGroupTimeSeriesFeedback`](crate::model::AnomalyGroupTimeSeriesFeedback)
pub mod anomaly_group_time_series_feedback {
    /// A builder for [`AnomalyGroupTimeSeriesFeedback`](crate::model::AnomalyGroupTimeSeriesFeedback)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_group_id: std::option::Option<std::string::String>,
        pub(crate) time_series_id: std::option::Option<std::string::String>,
        pub(crate) is_anomaly: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the anomaly group.</p>
        pub fn anomaly_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the anomaly group.</p>
        pub fn set_anomaly_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_group_id = input;
            self
        }
        /// <p>The ID of the metric.</p>
        pub fn time_series_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_series_id = Some(input.into());
            self
        }
        /// <p>The ID of the metric.</p>
        pub fn set_time_series_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.time_series_id = input;
            self
        }
        /// <p>Feedback on whether the metric is a legitimate anomaly.</p>
        pub fn is_anomaly(mut self, input: bool) -> Self {
            self.is_anomaly = Some(input);
            self
        }
        /// <p>Feedback on whether the metric is a legitimate anomaly.</p>
        pub fn set_is_anomaly(mut self, input: std::option::Option<bool>) -> Self {
            self.is_anomaly = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalyGroupTimeSeriesFeedback`](crate::model::AnomalyGroupTimeSeriesFeedback)
        pub fn build(self) -> crate::model::AnomalyGroupTimeSeriesFeedback {
            crate::model::AnomalyGroupTimeSeriesFeedback {
                anomaly_group_id: self.anomaly_group_id,
                time_series_id: self.time_series_id,
                is_anomaly: self.is_anomaly,
            }
        }
    }
}
impl AnomalyGroupTimeSeriesFeedback {
    /// Creates a new builder-style object to manufacture [`AnomalyGroupTimeSeriesFeedback`](crate::model::AnomalyGroupTimeSeriesFeedback)
    pub fn builder() -> crate::model::anomaly_group_time_series_feedback::Builder {
        crate::model::anomaly_group_time_series_feedback::Builder::default()
    }
}

/// <p>Contains information about a dataset.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricSetSummary {
    /// <p>The ARN of the dataset.</p>
    pub metric_set_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the detector to which the dataset belongs.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
    /// <p>The description of the dataset.</p>
    pub metric_set_description: std::option::Option<std::string::String>,
    /// <p>The name of the dataset.</p>
    pub metric_set_name: std::option::Option<std::string::String>,
    /// <p>The time at which the dataset was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the dataset was last modified.</p>
    pub last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The dataset's <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl MetricSetSummary {
    /// <p>The ARN of the dataset.</p>
    pub fn metric_set_arn(&self) -> std::option::Option<&str> {
        self.metric_set_arn.as_deref()
    }
    /// <p>The ARN of the detector to which the dataset belongs.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
    /// <p>The description of the dataset.</p>
    pub fn metric_set_description(&self) -> std::option::Option<&str> {
        self.metric_set_description.as_deref()
    }
    /// <p>The name of the dataset.</p>
    pub fn metric_set_name(&self) -> std::option::Option<&str> {
        self.metric_set_name.as_deref()
    }
    /// <p>The time at which the dataset was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The time at which the dataset was last modified.</p>
    pub fn last_modification_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modification_time.as_ref()
    }
    /// <p>The dataset's <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for MetricSetSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricSetSummary");
        formatter.field("metric_set_arn", &self.metric_set_arn);
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.field("metric_set_description", &self.metric_set_description);
        formatter.field("metric_set_name", &self.metric_set_name);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modification_time", &self.last_modification_time);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`MetricSetSummary`](crate::model::MetricSetSummary)
pub mod metric_set_summary {
    /// A builder for [`MetricSetSummary`](crate::model::MetricSetSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_set_arn: std::option::Option<std::string::String>,
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
        pub(crate) metric_set_description: std::option::Option<std::string::String>,
        pub(crate) metric_set_name: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the dataset.</p>
        pub fn metric_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the dataset.</p>
        pub fn set_metric_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_set_arn = input;
            self
        }
        /// <p>The ARN of the detector to which the dataset belongs.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the detector to which the dataset belongs.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// <p>The description of the dataset.</p>
        pub fn metric_set_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_set_description = Some(input.into());
            self
        }
        /// <p>The description of the dataset.</p>
        pub fn set_metric_set_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_set_description = input;
            self
        }
        /// <p>The name of the dataset.</p>
        pub fn metric_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_set_name = Some(input.into());
            self
        }
        /// <p>The name of the dataset.</p>
        pub fn set_metric_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_set_name = input;
            self
        }
        /// <p>The time at which the dataset was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time at which the dataset was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time at which the dataset was last modified.</p>
        pub fn last_modification_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modification_time = Some(input);
            self
        }
        /// <p>The time at which the dataset was last modified.</p>
        pub fn set_last_modification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modification_time = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The dataset's <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The dataset's <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricSetSummary`](crate::model::MetricSetSummary)
        pub fn build(self) -> crate::model::MetricSetSummary {
            crate::model::MetricSetSummary {
                metric_set_arn: self.metric_set_arn,
                anomaly_detector_arn: self.anomaly_detector_arn,
                metric_set_description: self.metric_set_description,
                metric_set_name: self.metric_set_name,
                creation_time: self.creation_time,
                last_modification_time: self.last_modification_time,
                tags: self.tags,
            }
        }
    }
}
impl MetricSetSummary {
    /// Creates a new builder-style object to manufacture [`MetricSetSummary`](crate::model::MetricSetSummary)
    pub fn builder() -> crate::model::metric_set_summary::Builder {
        crate::model::metric_set_summary::Builder::default()
    }
}

/// <p>Details about a metric. A metric is an aggregation of the values of a measure for a dimension value, such as <i>availability</i> in the <i>us-east-1</i> Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimeSeries {
    /// <p>The ID of the metric.</p>
    pub time_series_id: std::option::Option<std::string::String>,
    /// <p>The dimensions of the metric.</p>
    pub dimension_list: std::option::Option<std::vec::Vec<crate::model::DimensionNameValue>>,
    /// <p>The values for the metric.</p>
    pub metric_value_list: std::option::Option<std::vec::Vec<f64>>,
}
impl TimeSeries {
    /// <p>The ID of the metric.</p>
    pub fn time_series_id(&self) -> std::option::Option<&str> {
        self.time_series_id.as_deref()
    }
    /// <p>The dimensions of the metric.</p>
    pub fn dimension_list(&self) -> std::option::Option<&[crate::model::DimensionNameValue]> {
        self.dimension_list.as_deref()
    }
    /// <p>The values for the metric.</p>
    pub fn metric_value_list(&self) -> std::option::Option<&[f64]> {
        self.metric_value_list.as_deref()
    }
}
impl std::fmt::Debug for TimeSeries {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimeSeries");
        formatter.field("time_series_id", &self.time_series_id);
        formatter.field("dimension_list", &self.dimension_list);
        formatter.field("metric_value_list", &self.metric_value_list);
        formatter.finish()
    }
}
/// See [`TimeSeries`](crate::model::TimeSeries)
pub mod time_series {
    /// A builder for [`TimeSeries`](crate::model::TimeSeries)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_series_id: std::option::Option<std::string::String>,
        pub(crate) dimension_list:
            std::option::Option<std::vec::Vec<crate::model::DimensionNameValue>>,
        pub(crate) metric_value_list: std::option::Option<std::vec::Vec<f64>>,
    }
    impl Builder {
        /// <p>The ID of the metric.</p>
        pub fn time_series_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_series_id = Some(input.into());
            self
        }
        /// <p>The ID of the metric.</p>
        pub fn set_time_series_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.time_series_id = input;
            self
        }
        /// Appends an item to `dimension_list`.
        ///
        /// To override the contents of this collection use [`set_dimension_list`](Self::set_dimension_list).
        ///
        /// <p>The dimensions of the metric.</p>
        pub fn dimension_list(mut self, input: crate::model::DimensionNameValue) -> Self {
            let mut v = self.dimension_list.unwrap_or_default();
            v.push(input);
            self.dimension_list = Some(v);
            self
        }
        /// <p>The dimensions of the metric.</p>
        pub fn set_dimension_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DimensionNameValue>>,
        ) -> Self {
            self.dimension_list = input;
            self
        }
        /// Appends an item to `metric_value_list`.
        ///
        /// To override the contents of this collection use [`set_metric_value_list`](Self::set_metric_value_list).
        ///
        /// <p>The values for the metric.</p>
        pub fn metric_value_list(mut self, input: f64) -> Self {
            let mut v = self.metric_value_list.unwrap_or_default();
            v.push(input);
            self.metric_value_list = Some(v);
            self
        }
        /// <p>The values for the metric.</p>
        pub fn set_metric_value_list(
            mut self,
            input: std::option::Option<std::vec::Vec<f64>>,
        ) -> Self {
            self.metric_value_list = input;
            self
        }
        /// Consumes the builder and constructs a [`TimeSeries`](crate::model::TimeSeries)
        pub fn build(self) -> crate::model::TimeSeries {
            crate::model::TimeSeries {
                time_series_id: self.time_series_id,
                dimension_list: self.dimension_list,
                metric_value_list: self.metric_value_list,
            }
        }
    }
}
impl TimeSeries {
    /// Creates a new builder-style object to manufacture [`TimeSeries`](crate::model::TimeSeries)
    pub fn builder() -> crate::model::time_series::Builder {
        crate::model::time_series::Builder::default()
    }
}

/// <p>A dimension name and value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DimensionNameValue {
    /// <p>The name of the dimension.</p>
    pub dimension_name: std::option::Option<std::string::String>,
    /// <p>The value of the dimension.</p>
    pub dimension_value: std::option::Option<std::string::String>,
}
impl DimensionNameValue {
    /// <p>The name of the dimension.</p>
    pub fn dimension_name(&self) -> std::option::Option<&str> {
        self.dimension_name.as_deref()
    }
    /// <p>The value of the dimension.</p>
    pub fn dimension_value(&self) -> std::option::Option<&str> {
        self.dimension_value.as_deref()
    }
}
impl std::fmt::Debug for DimensionNameValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DimensionNameValue");
        formatter.field("dimension_name", &self.dimension_name);
        formatter.field("dimension_value", &self.dimension_value);
        formatter.finish()
    }
}
/// See [`DimensionNameValue`](crate::model::DimensionNameValue)
pub mod dimension_name_value {
    /// A builder for [`DimensionNameValue`](crate::model::DimensionNameValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimension_name: std::option::Option<std::string::String>,
        pub(crate) dimension_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the dimension.</p>
        pub fn dimension_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dimension_name = Some(input.into());
            self
        }
        /// <p>The name of the dimension.</p>
        pub fn set_dimension_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dimension_name = input;
            self
        }
        /// <p>The value of the dimension.</p>
        pub fn dimension_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.dimension_value = Some(input.into());
            self
        }
        /// <p>The value of the dimension.</p>
        pub fn set_dimension_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dimension_value = input;
            self
        }
        /// Consumes the builder and constructs a [`DimensionNameValue`](crate::model::DimensionNameValue)
        pub fn build(self) -> crate::model::DimensionNameValue {
            crate::model::DimensionNameValue {
                dimension_name: self.dimension_name,
                dimension_value: self.dimension_value,
            }
        }
    }
}
impl DimensionNameValue {
    /// Creates a new builder-style object to manufacture [`DimensionNameValue`](crate::model::DimensionNameValue)
    pub fn builder() -> crate::model::dimension_name_value::Builder {
        crate::model::dimension_name_value::Builder::default()
    }
}

/// <p>Aggregated statistics for a group of anomalous metrics.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalyGroupStatistics {
    /// <p>The start of the time range that was searched.</p>
    pub evaluation_start_date: std::option::Option<std::string::String>,
    /// <p>The number of groups found.</p>
    pub total_count: i32,
    /// <p>Statistics for individual metrics within the group.</p>
    pub itemized_metric_stats_list:
        std::option::Option<std::vec::Vec<crate::model::ItemizedMetricStats>>,
}
impl AnomalyGroupStatistics {
    /// <p>The start of the time range that was searched.</p>
    pub fn evaluation_start_date(&self) -> std::option::Option<&str> {
        self.evaluation_start_date.as_deref()
    }
    /// <p>The number of groups found.</p>
    pub fn total_count(&self) -> i32 {
        self.total_count
    }
    /// <p>Statistics for individual metrics within the group.</p>
    pub fn itemized_metric_stats_list(
        &self,
    ) -> std::option::Option<&[crate::model::ItemizedMetricStats]> {
        self.itemized_metric_stats_list.as_deref()
    }
}
impl std::fmt::Debug for AnomalyGroupStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalyGroupStatistics");
        formatter.field("evaluation_start_date", &self.evaluation_start_date);
        formatter.field("total_count", &self.total_count);
        formatter.field(
            "itemized_metric_stats_list",
            &self.itemized_metric_stats_list,
        );
        formatter.finish()
    }
}
/// See [`AnomalyGroupStatistics`](crate::model::AnomalyGroupStatistics)
pub mod anomaly_group_statistics {
    /// A builder for [`AnomalyGroupStatistics`](crate::model::AnomalyGroupStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evaluation_start_date: std::option::Option<std::string::String>,
        pub(crate) total_count: std::option::Option<i32>,
        pub(crate) itemized_metric_stats_list:
            std::option::Option<std::vec::Vec<crate::model::ItemizedMetricStats>>,
    }
    impl Builder {
        /// <p>The start of the time range that was searched.</p>
        pub fn evaluation_start_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.evaluation_start_date = Some(input.into());
            self
        }
        /// <p>The start of the time range that was searched.</p>
        pub fn set_evaluation_start_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evaluation_start_date = input;
            self
        }
        /// <p>The number of groups found.</p>
        pub fn total_count(mut self, input: i32) -> Self {
            self.total_count = Some(input);
            self
        }
        /// <p>The number of groups found.</p>
        pub fn set_total_count(mut self, input: std::option::Option<i32>) -> Self {
            self.total_count = input;
            self
        }
        /// Appends an item to `itemized_metric_stats_list`.
        ///
        /// To override the contents of this collection use [`set_itemized_metric_stats_list`](Self::set_itemized_metric_stats_list).
        ///
        /// <p>Statistics for individual metrics within the group.</p>
        pub fn itemized_metric_stats_list(
            mut self,
            input: crate::model::ItemizedMetricStats,
        ) -> Self {
            let mut v = self.itemized_metric_stats_list.unwrap_or_default();
            v.push(input);
            self.itemized_metric_stats_list = Some(v);
            self
        }
        /// <p>Statistics for individual metrics within the group.</p>
        pub fn set_itemized_metric_stats_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ItemizedMetricStats>>,
        ) -> Self {
            self.itemized_metric_stats_list = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalyGroupStatistics`](crate::model::AnomalyGroupStatistics)
        pub fn build(self) -> crate::model::AnomalyGroupStatistics {
            crate::model::AnomalyGroupStatistics {
                evaluation_start_date: self.evaluation_start_date,
                total_count: self.total_count.unwrap_or_default(),
                itemized_metric_stats_list: self.itemized_metric_stats_list,
            }
        }
    }
}
impl AnomalyGroupStatistics {
    /// Creates a new builder-style object to manufacture [`AnomalyGroupStatistics`](crate::model::AnomalyGroupStatistics)
    pub fn builder() -> crate::model::anomaly_group_statistics::Builder {
        crate::model::anomaly_group_statistics::Builder::default()
    }
}

/// <p>Aggregated statistics about a measure affected by an anomaly.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ItemizedMetricStats {
    /// <p>The name of the measure.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The number of times that the measure appears.</p>
    pub occurrence_count: i32,
}
impl ItemizedMetricStats {
    /// <p>The name of the measure.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The number of times that the measure appears.</p>
    pub fn occurrence_count(&self) -> i32 {
        self.occurrence_count
    }
}
impl std::fmt::Debug for ItemizedMetricStats {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ItemizedMetricStats");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("occurrence_count", &self.occurrence_count);
        formatter.finish()
    }
}
/// See [`ItemizedMetricStats`](crate::model::ItemizedMetricStats)
pub mod itemized_metric_stats {
    /// A builder for [`ItemizedMetricStats`](crate::model::ItemizedMetricStats)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) occurrence_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the measure.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the measure.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The number of times that the measure appears.</p>
        pub fn occurrence_count(mut self, input: i32) -> Self {
            self.occurrence_count = Some(input);
            self
        }
        /// <p>The number of times that the measure appears.</p>
        pub fn set_occurrence_count(mut self, input: std::option::Option<i32>) -> Self {
            self.occurrence_count = input;
            self
        }
        /// Consumes the builder and constructs a [`ItemizedMetricStats`](crate::model::ItemizedMetricStats)
        pub fn build(self) -> crate::model::ItemizedMetricStats {
            crate::model::ItemizedMetricStats {
                metric_name: self.metric_name,
                occurrence_count: self.occurrence_count.unwrap_or_default(),
            }
        }
    }
}
impl ItemizedMetricStats {
    /// Creates a new builder-style object to manufacture [`ItemizedMetricStats`](crate::model::ItemizedMetricStats)
    pub fn builder() -> crate::model::itemized_metric_stats::Builder {
        crate::model::itemized_metric_stats::Builder::default()
    }
}

/// <p>Details about a group of anomalous metrics.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalyGroupSummary {
    /// <p>The start time for the group.</p>
    pub start_time: std::option::Option<std::string::String>,
    /// <p>The end time for the group.</p>
    pub end_time: std::option::Option<std::string::String>,
    /// <p>The ID of the anomaly group.</p>
    pub anomaly_group_id: std::option::Option<std::string::String>,
    /// <p>The severity score of the group.</p>
    pub anomaly_group_score: std::option::Option<f64>,
    /// <p>The name of the primary affected measure for the group.</p>
    pub primary_metric_name: std::option::Option<std::string::String>,
}
impl AnomalyGroupSummary {
    /// <p>The start time for the group.</p>
    pub fn start_time(&self) -> std::option::Option<&str> {
        self.start_time.as_deref()
    }
    /// <p>The end time for the group.</p>
    pub fn end_time(&self) -> std::option::Option<&str> {
        self.end_time.as_deref()
    }
    /// <p>The ID of the anomaly group.</p>
    pub fn anomaly_group_id(&self) -> std::option::Option<&str> {
        self.anomaly_group_id.as_deref()
    }
    /// <p>The severity score of the group.</p>
    pub fn anomaly_group_score(&self) -> std::option::Option<f64> {
        self.anomaly_group_score
    }
    /// <p>The name of the primary affected measure for the group.</p>
    pub fn primary_metric_name(&self) -> std::option::Option<&str> {
        self.primary_metric_name.as_deref()
    }
}
impl std::fmt::Debug for AnomalyGroupSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalyGroupSummary");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("anomaly_group_id", &self.anomaly_group_id);
        formatter.field("anomaly_group_score", &self.anomaly_group_score);
        formatter.field("primary_metric_name", &self.primary_metric_name);
        formatter.finish()
    }
}
/// See [`AnomalyGroupSummary`](crate::model::AnomalyGroupSummary)
pub mod anomaly_group_summary {
    /// A builder for [`AnomalyGroupSummary`](crate::model::AnomalyGroupSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<std::string::String>,
        pub(crate) end_time: std::option::Option<std::string::String>,
        pub(crate) anomaly_group_id: std::option::Option<std::string::String>,
        pub(crate) anomaly_group_score: std::option::Option<f64>,
        pub(crate) primary_metric_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The start time for the group.</p>
        pub fn start_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_time = Some(input.into());
            self
        }
        /// <p>The start time for the group.</p>
        pub fn set_start_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time for the group.</p>
        pub fn end_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_time = Some(input.into());
            self
        }
        /// <p>The end time for the group.</p>
        pub fn set_end_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The ID of the anomaly group.</p>
        pub fn anomaly_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the anomaly group.</p>
        pub fn set_anomaly_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_group_id = input;
            self
        }
        /// <p>The severity score of the group.</p>
        pub fn anomaly_group_score(mut self, input: f64) -> Self {
            self.anomaly_group_score = Some(input);
            self
        }
        /// <p>The severity score of the group.</p>
        pub fn set_anomaly_group_score(mut self, input: std::option::Option<f64>) -> Self {
            self.anomaly_group_score = input;
            self
        }
        /// <p>The name of the primary affected measure for the group.</p>
        pub fn primary_metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.primary_metric_name = Some(input.into());
            self
        }
        /// <p>The name of the primary affected measure for the group.</p>
        pub fn set_primary_metric_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.primary_metric_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalyGroupSummary`](crate::model::AnomalyGroupSummary)
        pub fn build(self) -> crate::model::AnomalyGroupSummary {
            crate::model::AnomalyGroupSummary {
                start_time: self.start_time,
                end_time: self.end_time,
                anomaly_group_id: self.anomaly_group_id,
                anomaly_group_score: self.anomaly_group_score,
                primary_metric_name: self.primary_metric_name,
            }
        }
    }
}
impl AnomalyGroupSummary {
    /// Creates a new builder-style object to manufacture [`AnomalyGroupSummary`](crate::model::AnomalyGroupSummary)
    pub fn builder() -> crate::model::anomaly_group_summary::Builder {
        crate::model::anomaly_group_summary::Builder::default()
    }
}

/// <p>Aggregated details about the measures contributing to the anomaly group, and the measures potentially impacted by the anomaly group.</p>
/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InterMetricImpactDetails {
    /// <p>The name of the measure.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The ID of the anomaly group.</p>
    pub anomaly_group_id: std::option::Option<std::string::String>,
    /// <p>Whether a measure is a potential cause of the anomaly group (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>), or whether the measure is impacted by the anomaly group (<code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>).</p>
    pub relationship_type: std::option::Option<crate::model::RelationshipType>,
    /// <p>For potential causes (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>), the percentage contribution the measure has in causing the anomalies.</p>
    pub contribution_percentage: std::option::Option<f64>,
}
impl InterMetricImpactDetails {
    /// <p>The name of the measure.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The ID of the anomaly group.</p>
    pub fn anomaly_group_id(&self) -> std::option::Option<&str> {
        self.anomaly_group_id.as_deref()
    }
    /// <p>Whether a measure is a potential cause of the anomaly group (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>), or whether the measure is impacted by the anomaly group (<code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>).</p>
    pub fn relationship_type(&self) -> std::option::Option<&crate::model::RelationshipType> {
        self.relationship_type.as_ref()
    }
    /// <p>For potential causes (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>), the percentage contribution the measure has in causing the anomalies.</p>
    pub fn contribution_percentage(&self) -> std::option::Option<f64> {
        self.contribution_percentage
    }
}
impl std::fmt::Debug for InterMetricImpactDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InterMetricImpactDetails");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("anomaly_group_id", &self.anomaly_group_id);
        formatter.field("relationship_type", &self.relationship_type);
        formatter.field("contribution_percentage", &self.contribution_percentage);
        formatter.finish()
    }
}
/// See [`InterMetricImpactDetails`](crate::model::InterMetricImpactDetails)
pub mod inter_metric_impact_details {
    /// A builder for [`InterMetricImpactDetails`](crate::model::InterMetricImpactDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) anomaly_group_id: std::option::Option<std::string::String>,
        pub(crate) relationship_type: std::option::Option<crate::model::RelationshipType>,
        pub(crate) contribution_percentage: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The name of the measure.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the measure.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The ID of the anomaly group.</p>
        pub fn anomaly_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the anomaly group.</p>
        pub fn set_anomaly_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_group_id = input;
            self
        }
        /// <p>Whether a measure is a potential cause of the anomaly group (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>), or whether the measure is impacted by the anomaly group (<code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>).</p>
        pub fn relationship_type(mut self, input: crate::model::RelationshipType) -> Self {
            self.relationship_type = Some(input);
            self
        }
        /// <p>Whether a measure is a potential cause of the anomaly group (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>), or whether the measure is impacted by the anomaly group (<code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>).</p>
        pub fn set_relationship_type(
            mut self,
            input: std::option::Option<crate::model::RelationshipType>,
        ) -> Self {
            self.relationship_type = input;
            self
        }
        /// <p>For potential causes (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>), the percentage contribution the measure has in causing the anomalies.</p>
        pub fn contribution_percentage(mut self, input: f64) -> Self {
            self.contribution_percentage = Some(input);
            self
        }
        /// <p>For potential causes (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>), the percentage contribution the measure has in causing the anomalies.</p>
        pub fn set_contribution_percentage(mut self, input: std::option::Option<f64>) -> Self {
            self.contribution_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`InterMetricImpactDetails`](crate::model::InterMetricImpactDetails)
        pub fn build(self) -> crate::model::InterMetricImpactDetails {
            crate::model::InterMetricImpactDetails {
                metric_name: self.metric_name,
                anomaly_group_id: self.anomaly_group_id,
                relationship_type: self.relationship_type,
                contribution_percentage: self.contribution_percentage,
            }
        }
    }
}
impl InterMetricImpactDetails {
    /// Creates a new builder-style object to manufacture [`InterMetricImpactDetails`](crate::model::InterMetricImpactDetails)
    pub fn builder() -> crate::model::inter_metric_impact_details::Builder {
        crate::model::inter_metric_impact_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RelationshipType {
    #[allow(missing_docs)] // documentation missing in model
    CauseOfInputAnomalyGroup,
    #[allow(missing_docs)] // documentation missing in model
    EffectOfInputAnomalyGroup,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RelationshipType {
    fn from(s: &str) -> Self {
        match s {
            "CAUSE_OF_INPUT_ANOMALY_GROUP" => RelationshipType::CauseOfInputAnomalyGroup,
            "EFFECT_OF_INPUT_ANOMALY_GROUP" => RelationshipType::EffectOfInputAnomalyGroup,
            other => RelationshipType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RelationshipType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RelationshipType::from(s))
    }
}
impl RelationshipType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RelationshipType::CauseOfInputAnomalyGroup => "CAUSE_OF_INPUT_ANOMALY_GROUP",
            RelationshipType::EffectOfInputAnomalyGroup => "EFFECT_OF_INPUT_ANOMALY_GROUP",
            RelationshipType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CAUSE_OF_INPUT_ANOMALY_GROUP",
            "EFFECT_OF_INPUT_ANOMALY_GROUP",
        ]
    }
}
impl AsRef<str> for RelationshipType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about an an anomaly detector.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalyDetectorSummary {
    /// <p>The ARN of the detector.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
    /// <p>The name of the detector.</p>
    pub anomaly_detector_name: std::option::Option<std::string::String>,
    /// <p>A description of the detector.</p>
    pub anomaly_detector_description: std::option::Option<std::string::String>,
    /// <p>The time at which the detector was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the detector was last modified.</p>
    pub last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of detector.</p>
    pub status: std::option::Option<crate::model::AnomalyDetectorStatus>,
    /// <p>The detector's <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl AnomalyDetectorSummary {
    /// <p>The ARN of the detector.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
    /// <p>The name of the detector.</p>
    pub fn anomaly_detector_name(&self) -> std::option::Option<&str> {
        self.anomaly_detector_name.as_deref()
    }
    /// <p>A description of the detector.</p>
    pub fn anomaly_detector_description(&self) -> std::option::Option<&str> {
        self.anomaly_detector_description.as_deref()
    }
    /// <p>The time at which the detector was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The time at which the detector was last modified.</p>
    pub fn last_modification_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modification_time.as_ref()
    }
    /// <p>The status of detector.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AnomalyDetectorStatus> {
        self.status.as_ref()
    }
    /// <p>The detector's <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for AnomalyDetectorSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalyDetectorSummary");
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.field("anomaly_detector_name", &self.anomaly_detector_name);
        formatter.field(
            "anomaly_detector_description",
            &self.anomaly_detector_description,
        );
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modification_time", &self.last_modification_time);
        formatter.field("status", &self.status);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`AnomalyDetectorSummary`](crate::model::AnomalyDetectorSummary)
pub mod anomaly_detector_summary {
    /// A builder for [`AnomalyDetectorSummary`](crate::model::AnomalyDetectorSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
        pub(crate) anomaly_detector_name: std::option::Option<std::string::String>,
        pub(crate) anomaly_detector_description: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::AnomalyDetectorStatus>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the detector.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// <p>The name of the detector.</p>
        pub fn anomaly_detector_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_name = Some(input.into());
            self
        }
        /// <p>The name of the detector.</p>
        pub fn set_anomaly_detector_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_name = input;
            self
        }
        /// <p>A description of the detector.</p>
        pub fn anomaly_detector_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.anomaly_detector_description = Some(input.into());
            self
        }
        /// <p>A description of the detector.</p>
        pub fn set_anomaly_detector_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_description = input;
            self
        }
        /// <p>The time at which the detector was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time at which the detector was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time at which the detector was last modified.</p>
        pub fn last_modification_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modification_time = Some(input);
            self
        }
        /// <p>The time at which the detector was last modified.</p>
        pub fn set_last_modification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modification_time = input;
            self
        }
        /// <p>The status of detector.</p>
        pub fn status(mut self, input: crate::model::AnomalyDetectorStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of detector.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AnomalyDetectorStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The detector's <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The detector's <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalyDetectorSummary`](crate::model::AnomalyDetectorSummary)
        pub fn build(self) -> crate::model::AnomalyDetectorSummary {
            crate::model::AnomalyDetectorSummary {
                anomaly_detector_arn: self.anomaly_detector_arn,
                anomaly_detector_name: self.anomaly_detector_name,
                anomaly_detector_description: self.anomaly_detector_description,
                creation_time: self.creation_time,
                last_modification_time: self.last_modification_time,
                status: self.status,
                tags: self.tags,
            }
        }
    }
}
impl AnomalyDetectorSummary {
    /// Creates a new builder-style object to manufacture [`AnomalyDetectorSummary`](crate::model::AnomalyDetectorSummary)
    pub fn builder() -> crate::model::anomaly_detector_summary::Builder {
        crate::model::anomaly_detector_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AnomalyDetectorStatus {
    #[allow(missing_docs)] // documentation missing in model
    Activating,
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    BackTestActivating,
    #[allow(missing_docs)] // documentation missing in model
    BackTestActive,
    #[allow(missing_docs)] // documentation missing in model
    BackTestComplete,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    #[allow(missing_docs)] // documentation missing in model
    Learning,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AnomalyDetectorStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVATING" => AnomalyDetectorStatus::Activating,
            "ACTIVE" => AnomalyDetectorStatus::Active,
            "BACK_TEST_ACTIVATING" => AnomalyDetectorStatus::BackTestActivating,
            "BACK_TEST_ACTIVE" => AnomalyDetectorStatus::BackTestActive,
            "BACK_TEST_COMPLETE" => AnomalyDetectorStatus::BackTestComplete,
            "DELETING" => AnomalyDetectorStatus::Deleting,
            "FAILED" => AnomalyDetectorStatus::Failed,
            "INACTIVE" => AnomalyDetectorStatus::Inactive,
            "LEARNING" => AnomalyDetectorStatus::Learning,
            other => AnomalyDetectorStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AnomalyDetectorStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AnomalyDetectorStatus::from(s))
    }
}
impl AnomalyDetectorStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AnomalyDetectorStatus::Activating => "ACTIVATING",
            AnomalyDetectorStatus::Active => "ACTIVE",
            AnomalyDetectorStatus::BackTestActivating => "BACK_TEST_ACTIVATING",
            AnomalyDetectorStatus::BackTestActive => "BACK_TEST_ACTIVE",
            AnomalyDetectorStatus::BackTestComplete => "BACK_TEST_COMPLETE",
            AnomalyDetectorStatus::Deleting => "DELETING",
            AnomalyDetectorStatus::Failed => "FAILED",
            AnomalyDetectorStatus::Inactive => "INACTIVE",
            AnomalyDetectorStatus::Learning => "LEARNING",
            AnomalyDetectorStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVATING",
            "ACTIVE",
            "BACK_TEST_ACTIVATING",
            "BACK_TEST_ACTIVE",
            "BACK_TEST_COMPLETE",
            "DELETING",
            "FAILED",
            "INACTIVE",
            "LEARNING",
        ]
    }
}
impl AsRef<str> for AnomalyDetectorStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides a summary of an alert's configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AlertSummary {
    /// <p>The ARN of the alert.</p>
    pub alert_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the detector to which the alert is attached.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
    /// <p>The name of the alert.</p>
    pub alert_name: std::option::Option<std::string::String>,
    /// <p>The minimum severity for an anomaly to trigger the alert.</p>
    pub alert_sensitivity_threshold: i32,
    /// <p>The type of the alert.</p>
    pub alert_type: std::option::Option<crate::model::AlertType>,
    /// <p>The status of the alert.</p>
    pub alert_status: std::option::Option<crate::model::AlertStatus>,
    /// <p>The time at which the alert was last modified.</p>
    pub last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the alert was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The alert's <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl AlertSummary {
    /// <p>The ARN of the alert.</p>
    pub fn alert_arn(&self) -> std::option::Option<&str> {
        self.alert_arn.as_deref()
    }
    /// <p>The ARN of the detector to which the alert is attached.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
    /// <p>The name of the alert.</p>
    pub fn alert_name(&self) -> std::option::Option<&str> {
        self.alert_name.as_deref()
    }
    /// <p>The minimum severity for an anomaly to trigger the alert.</p>
    pub fn alert_sensitivity_threshold(&self) -> i32 {
        self.alert_sensitivity_threshold
    }
    /// <p>The type of the alert.</p>
    pub fn alert_type(&self) -> std::option::Option<&crate::model::AlertType> {
        self.alert_type.as_ref()
    }
    /// <p>The status of the alert.</p>
    pub fn alert_status(&self) -> std::option::Option<&crate::model::AlertStatus> {
        self.alert_status.as_ref()
    }
    /// <p>The time at which the alert was last modified.</p>
    pub fn last_modification_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modification_time.as_ref()
    }
    /// <p>The time at which the alert was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The alert's <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for AlertSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AlertSummary");
        formatter.field("alert_arn", &self.alert_arn);
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.field("alert_name", &self.alert_name);
        formatter.field(
            "alert_sensitivity_threshold",
            &self.alert_sensitivity_threshold,
        );
        formatter.field("alert_type", &self.alert_type);
        formatter.field("alert_status", &self.alert_status);
        formatter.field("last_modification_time", &self.last_modification_time);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`AlertSummary`](crate::model::AlertSummary)
pub mod alert_summary {
    /// A builder for [`AlertSummary`](crate::model::AlertSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alert_arn: std::option::Option<std::string::String>,
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
        pub(crate) alert_name: std::option::Option<std::string::String>,
        pub(crate) alert_sensitivity_threshold: std::option::Option<i32>,
        pub(crate) alert_type: std::option::Option<crate::model::AlertType>,
        pub(crate) alert_status: std::option::Option<crate::model::AlertStatus>,
        pub(crate) last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the alert.</p>
        pub fn alert_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alert_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the alert.</p>
        pub fn set_alert_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alert_arn = input;
            self
        }
        /// <p>The ARN of the detector to which the alert is attached.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the detector to which the alert is attached.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// <p>The name of the alert.</p>
        pub fn alert_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alert_name = Some(input.into());
            self
        }
        /// <p>The name of the alert.</p>
        pub fn set_alert_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alert_name = input;
            self
        }
        /// <p>The minimum severity for an anomaly to trigger the alert.</p>
        pub fn alert_sensitivity_threshold(mut self, input: i32) -> Self {
            self.alert_sensitivity_threshold = Some(input);
            self
        }
        /// <p>The minimum severity for an anomaly to trigger the alert.</p>
        pub fn set_alert_sensitivity_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.alert_sensitivity_threshold = input;
            self
        }
        /// <p>The type of the alert.</p>
        pub fn alert_type(mut self, input: crate::model::AlertType) -> Self {
            self.alert_type = Some(input);
            self
        }
        /// <p>The type of the alert.</p>
        pub fn set_alert_type(
            mut self,
            input: std::option::Option<crate::model::AlertType>,
        ) -> Self {
            self.alert_type = input;
            self
        }
        /// <p>The status of the alert.</p>
        pub fn alert_status(mut self, input: crate::model::AlertStatus) -> Self {
            self.alert_status = Some(input);
            self
        }
        /// <p>The status of the alert.</p>
        pub fn set_alert_status(
            mut self,
            input: std::option::Option<crate::model::AlertStatus>,
        ) -> Self {
            self.alert_status = input;
            self
        }
        /// <p>The time at which the alert was last modified.</p>
        pub fn last_modification_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modification_time = Some(input);
            self
        }
        /// <p>The time at which the alert was last modified.</p>
        pub fn set_last_modification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modification_time = input;
            self
        }
        /// <p>The time at which the alert was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time at which the alert was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The alert's <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The alert's <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AlertSummary`](crate::model::AlertSummary)
        pub fn build(self) -> crate::model::AlertSummary {
            crate::model::AlertSummary {
                alert_arn: self.alert_arn,
                anomaly_detector_arn: self.anomaly_detector_arn,
                alert_name: self.alert_name,
                alert_sensitivity_threshold: self.alert_sensitivity_threshold.unwrap_or_default(),
                alert_type: self.alert_type,
                alert_status: self.alert_status,
                last_modification_time: self.last_modification_time,
                creation_time: self.creation_time,
                tags: self.tags,
            }
        }
    }
}
impl AlertSummary {
    /// Creates a new builder-style object to manufacture [`AlertSummary`](crate::model::AlertSummary)
    pub fn builder() -> crate::model::alert_summary::Builder {
        crate::model::alert_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AlertStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AlertStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => AlertStatus::Active,
            "INACTIVE" => AlertStatus::Inactive,
            other => AlertStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AlertStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AlertStatus::from(s))
    }
}
impl AlertStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AlertStatus::Active => "ACTIVE",
            AlertStatus::Inactive => "INACTIVE",
            AlertStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "INACTIVE"]
    }
}
impl AsRef<str> for AlertStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AlertType {
    #[allow(missing_docs)] // documentation missing in model
    Lambda,
    #[allow(missing_docs)] // documentation missing in model
    Sns,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AlertType {
    fn from(s: &str) -> Self {
        match s {
            "LAMBDA" => AlertType::Lambda,
            "SNS" => AlertType::Sns,
            other => AlertType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AlertType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AlertType::from(s))
    }
}
impl AlertType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AlertType::Lambda => "LAMBDA",
            AlertType::Sns => "SNS",
            AlertType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LAMBDA", "SNS"]
    }
}
impl AsRef<str> for AlertType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the source configuration in Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SampleDataS3SourceConfig {
    /// <p>The Amazon Resource Name (ARN) of the role.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>An array of strings containing the list of templated paths.</p>
    pub templated_path_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of strings containing the historical set of data paths.</p>
    pub historical_data_path_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Contains information about a source file's formatting.</p>
    pub file_format_descriptor: std::option::Option<crate::model::FileFormatDescriptor>,
}
impl SampleDataS3SourceConfig {
    /// <p>The Amazon Resource Name (ARN) of the role.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>An array of strings containing the list of templated paths.</p>
    pub fn templated_path_list(&self) -> std::option::Option<&[std::string::String]> {
        self.templated_path_list.as_deref()
    }
    /// <p>An array of strings containing the historical set of data paths.</p>
    pub fn historical_data_path_list(&self) -> std::option::Option<&[std::string::String]> {
        self.historical_data_path_list.as_deref()
    }
    /// <p>Contains information about a source file's formatting.</p>
    pub fn file_format_descriptor(
        &self,
    ) -> std::option::Option<&crate::model::FileFormatDescriptor> {
        self.file_format_descriptor.as_ref()
    }
}
impl std::fmt::Debug for SampleDataS3SourceConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SampleDataS3SourceConfig");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("templated_path_list", &self.templated_path_list);
        formatter.field("historical_data_path_list", &self.historical_data_path_list);
        formatter.field("file_format_descriptor", &self.file_format_descriptor);
        formatter.finish()
    }
}
/// See [`SampleDataS3SourceConfig`](crate::model::SampleDataS3SourceConfig)
pub mod sample_data_s3_source_config {
    /// A builder for [`SampleDataS3SourceConfig`](crate::model::SampleDataS3SourceConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) templated_path_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) historical_data_path_list:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) file_format_descriptor: std::option::Option<crate::model::FileFormatDescriptor>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the role.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the role.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `templated_path_list`.
        ///
        /// To override the contents of this collection use [`set_templated_path_list`](Self::set_templated_path_list).
        ///
        /// <p>An array of strings containing the list of templated paths.</p>
        pub fn templated_path_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.templated_path_list.unwrap_or_default();
            v.push(input.into());
            self.templated_path_list = Some(v);
            self
        }
        /// <p>An array of strings containing the list of templated paths.</p>
        pub fn set_templated_path_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.templated_path_list = input;
            self
        }
        /// Appends an item to `historical_data_path_list`.
        ///
        /// To override the contents of this collection use [`set_historical_data_path_list`](Self::set_historical_data_path_list).
        ///
        /// <p>An array of strings containing the historical set of data paths.</p>
        pub fn historical_data_path_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.historical_data_path_list.unwrap_or_default();
            v.push(input.into());
            self.historical_data_path_list = Some(v);
            self
        }
        /// <p>An array of strings containing the historical set of data paths.</p>
        pub fn set_historical_data_path_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.historical_data_path_list = input;
            self
        }
        /// <p>Contains information about a source file's formatting.</p>
        pub fn file_format_descriptor(mut self, input: crate::model::FileFormatDescriptor) -> Self {
            self.file_format_descriptor = Some(input);
            self
        }
        /// <p>Contains information about a source file's formatting.</p>
        pub fn set_file_format_descriptor(
            mut self,
            input: std::option::Option<crate::model::FileFormatDescriptor>,
        ) -> Self {
            self.file_format_descriptor = input;
            self
        }
        /// Consumes the builder and constructs a [`SampleDataS3SourceConfig`](crate::model::SampleDataS3SourceConfig)
        pub fn build(self) -> crate::model::SampleDataS3SourceConfig {
            crate::model::SampleDataS3SourceConfig {
                role_arn: self.role_arn,
                templated_path_list: self.templated_path_list,
                historical_data_path_list: self.historical_data_path_list,
                file_format_descriptor: self.file_format_descriptor,
            }
        }
    }
}
impl SampleDataS3SourceConfig {
    /// Creates a new builder-style object to manufacture [`SampleDataS3SourceConfig`](crate::model::SampleDataS3SourceConfig)
    pub fn builder() -> crate::model::sample_data_s3_source_config::Builder {
        crate::model::sample_data_s3_source_config::Builder::default()
    }
}

/// <p>Details about feedback submitted for an anomalous metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimeSeriesFeedback {
    /// <p>The ID of the metric.</p>
    pub time_series_id: std::option::Option<std::string::String>,
    /// <p>Feedback on whether the metric is a legitimate anomaly.</p>
    pub is_anomaly: std::option::Option<bool>,
}
impl TimeSeriesFeedback {
    /// <p>The ID of the metric.</p>
    pub fn time_series_id(&self) -> std::option::Option<&str> {
        self.time_series_id.as_deref()
    }
    /// <p>Feedback on whether the metric is a legitimate anomaly.</p>
    pub fn is_anomaly(&self) -> std::option::Option<bool> {
        self.is_anomaly
    }
}
impl std::fmt::Debug for TimeSeriesFeedback {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimeSeriesFeedback");
        formatter.field("time_series_id", &self.time_series_id);
        formatter.field("is_anomaly", &self.is_anomaly);
        formatter.finish()
    }
}
/// See [`TimeSeriesFeedback`](crate::model::TimeSeriesFeedback)
pub mod time_series_feedback {
    /// A builder for [`TimeSeriesFeedback`](crate::model::TimeSeriesFeedback)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_series_id: std::option::Option<std::string::String>,
        pub(crate) is_anomaly: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the metric.</p>
        pub fn time_series_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_series_id = Some(input.into());
            self
        }
        /// <p>The ID of the metric.</p>
        pub fn set_time_series_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.time_series_id = input;
            self
        }
        /// <p>Feedback on whether the metric is a legitimate anomaly.</p>
        pub fn is_anomaly(mut self, input: bool) -> Self {
            self.is_anomaly = Some(input);
            self
        }
        /// <p>Feedback on whether the metric is a legitimate anomaly.</p>
        pub fn set_is_anomaly(mut self, input: std::option::Option<bool>) -> Self {
            self.is_anomaly = input;
            self
        }
        /// Consumes the builder and constructs a [`TimeSeriesFeedback`](crate::model::TimeSeriesFeedback)
        pub fn build(self) -> crate::model::TimeSeriesFeedback {
            crate::model::TimeSeriesFeedback {
                time_series_id: self.time_series_id,
                is_anomaly: self.is_anomaly,
            }
        }
    }
}
impl TimeSeriesFeedback {
    /// Creates a new builder-style object to manufacture [`TimeSeriesFeedback`](crate::model::TimeSeriesFeedback)
    pub fn builder() -> crate::model::time_series_feedback::Builder {
        crate::model::time_series_feedback::Builder::default()
    }
}

/// <p>An anomalous metric in an anomaly group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalyGroupTimeSeries {
    /// <p>The ID of the anomaly group.</p>
    pub anomaly_group_id: std::option::Option<std::string::String>,
    /// <p>The ID of the metric.</p>
    pub time_series_id: std::option::Option<std::string::String>,
}
impl AnomalyGroupTimeSeries {
    /// <p>The ID of the anomaly group.</p>
    pub fn anomaly_group_id(&self) -> std::option::Option<&str> {
        self.anomaly_group_id.as_deref()
    }
    /// <p>The ID of the metric.</p>
    pub fn time_series_id(&self) -> std::option::Option<&str> {
        self.time_series_id.as_deref()
    }
}
impl std::fmt::Debug for AnomalyGroupTimeSeries {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalyGroupTimeSeries");
        formatter.field("anomaly_group_id", &self.anomaly_group_id);
        formatter.field("time_series_id", &self.time_series_id);
        formatter.finish()
    }
}
/// See [`AnomalyGroupTimeSeries`](crate::model::AnomalyGroupTimeSeries)
pub mod anomaly_group_time_series {
    /// A builder for [`AnomalyGroupTimeSeries`](crate::model::AnomalyGroupTimeSeries)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_group_id: std::option::Option<std::string::String>,
        pub(crate) time_series_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the anomaly group.</p>
        pub fn anomaly_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the anomaly group.</p>
        pub fn set_anomaly_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_group_id = input;
            self
        }
        /// <p>The ID of the metric.</p>
        pub fn time_series_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_series_id = Some(input.into());
            self
        }
        /// <p>The ID of the metric.</p>
        pub fn set_time_series_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.time_series_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalyGroupTimeSeries`](crate::model::AnomalyGroupTimeSeries)
        pub fn build(self) -> crate::model::AnomalyGroupTimeSeries {
            crate::model::AnomalyGroupTimeSeries {
                anomaly_group_id: self.anomaly_group_id,
                time_series_id: self.time_series_id,
            }
        }
    }
}
impl AnomalyGroupTimeSeries {
    /// Creates a new builder-style object to manufacture [`AnomalyGroupTimeSeries`](crate::model::AnomalyGroupTimeSeries)
    pub fn builder() -> crate::model::anomaly_group_time_series::Builder {
        crate::model::anomaly_group_time_series::Builder::default()
    }
}

/// <p>A group of anomalous metrics</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalyGroup {
    /// <p>The start time for the group.</p>
    pub start_time: std::option::Option<std::string::String>,
    /// <p>The end time for the group.</p>
    pub end_time: std::option::Option<std::string::String>,
    /// <p>The ID of the anomaly group.</p>
    pub anomaly_group_id: std::option::Option<std::string::String>,
    /// <p>The severity score of the group.</p>
    pub anomaly_group_score: std::option::Option<f64>,
    /// <p>The name of the primary affected measure for the group.</p>
    pub primary_metric_name: std::option::Option<std::string::String>,
    /// <p>A list of measures affected by the anomaly.</p>
    pub metric_level_impact_list:
        std::option::Option<std::vec::Vec<crate::model::MetricLevelImpact>>,
}
impl AnomalyGroup {
    /// <p>The start time for the group.</p>
    pub fn start_time(&self) -> std::option::Option<&str> {
        self.start_time.as_deref()
    }
    /// <p>The end time for the group.</p>
    pub fn end_time(&self) -> std::option::Option<&str> {
        self.end_time.as_deref()
    }
    /// <p>The ID of the anomaly group.</p>
    pub fn anomaly_group_id(&self) -> std::option::Option<&str> {
        self.anomaly_group_id.as_deref()
    }
    /// <p>The severity score of the group.</p>
    pub fn anomaly_group_score(&self) -> std::option::Option<f64> {
        self.anomaly_group_score
    }
    /// <p>The name of the primary affected measure for the group.</p>
    pub fn primary_metric_name(&self) -> std::option::Option<&str> {
        self.primary_metric_name.as_deref()
    }
    /// <p>A list of measures affected by the anomaly.</p>
    pub fn metric_level_impact_list(
        &self,
    ) -> std::option::Option<&[crate::model::MetricLevelImpact]> {
        self.metric_level_impact_list.as_deref()
    }
}
impl std::fmt::Debug for AnomalyGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalyGroup");
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("anomaly_group_id", &self.anomaly_group_id);
        formatter.field("anomaly_group_score", &self.anomaly_group_score);
        formatter.field("primary_metric_name", &self.primary_metric_name);
        formatter.field("metric_level_impact_list", &self.metric_level_impact_list);
        formatter.finish()
    }
}
/// See [`AnomalyGroup`](crate::model::AnomalyGroup)
pub mod anomaly_group {
    /// A builder for [`AnomalyGroup`](crate::model::AnomalyGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_time: std::option::Option<std::string::String>,
        pub(crate) end_time: std::option::Option<std::string::String>,
        pub(crate) anomaly_group_id: std::option::Option<std::string::String>,
        pub(crate) anomaly_group_score: std::option::Option<f64>,
        pub(crate) primary_metric_name: std::option::Option<std::string::String>,
        pub(crate) metric_level_impact_list:
            std::option::Option<std::vec::Vec<crate::model::MetricLevelImpact>>,
    }
    impl Builder {
        /// <p>The start time for the group.</p>
        pub fn start_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_time = Some(input.into());
            self
        }
        /// <p>The start time for the group.</p>
        pub fn set_start_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time for the group.</p>
        pub fn end_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_time = Some(input.into());
            self
        }
        /// <p>The end time for the group.</p>
        pub fn set_end_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The ID of the anomaly group.</p>
        pub fn anomaly_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the anomaly group.</p>
        pub fn set_anomaly_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_group_id = input;
            self
        }
        /// <p>The severity score of the group.</p>
        pub fn anomaly_group_score(mut self, input: f64) -> Self {
            self.anomaly_group_score = Some(input);
            self
        }
        /// <p>The severity score of the group.</p>
        pub fn set_anomaly_group_score(mut self, input: std::option::Option<f64>) -> Self {
            self.anomaly_group_score = input;
            self
        }
        /// <p>The name of the primary affected measure for the group.</p>
        pub fn primary_metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.primary_metric_name = Some(input.into());
            self
        }
        /// <p>The name of the primary affected measure for the group.</p>
        pub fn set_primary_metric_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.primary_metric_name = input;
            self
        }
        /// Appends an item to `metric_level_impact_list`.
        ///
        /// To override the contents of this collection use [`set_metric_level_impact_list`](Self::set_metric_level_impact_list).
        ///
        /// <p>A list of measures affected by the anomaly.</p>
        pub fn metric_level_impact_list(mut self, input: crate::model::MetricLevelImpact) -> Self {
            let mut v = self.metric_level_impact_list.unwrap_or_default();
            v.push(input);
            self.metric_level_impact_list = Some(v);
            self
        }
        /// <p>A list of measures affected by the anomaly.</p>
        pub fn set_metric_level_impact_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricLevelImpact>>,
        ) -> Self {
            self.metric_level_impact_list = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalyGroup`](crate::model::AnomalyGroup)
        pub fn build(self) -> crate::model::AnomalyGroup {
            crate::model::AnomalyGroup {
                start_time: self.start_time,
                end_time: self.end_time,
                anomaly_group_id: self.anomaly_group_id,
                anomaly_group_score: self.anomaly_group_score,
                primary_metric_name: self.primary_metric_name,
                metric_level_impact_list: self.metric_level_impact_list,
            }
        }
    }
}
impl AnomalyGroup {
    /// Creates a new builder-style object to manufacture [`AnomalyGroup`](crate::model::AnomalyGroup)
    pub fn builder() -> crate::model::anomaly_group::Builder {
        crate::model::anomaly_group::Builder::default()
    }
}

/// <p>Details about a measure affected by an anomaly.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricLevelImpact {
    /// <p>The name of the measure.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>The number of anomalous metrics for the measure.</p>
    pub num_time_series: i32,
    /// <p>Details about the dimensions that contributed to the anomaly.</p>
    pub contribution_matrix: std::option::Option<crate::model::ContributionMatrix>,
}
impl MetricLevelImpact {
    /// <p>The name of the measure.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>The number of anomalous metrics for the measure.</p>
    pub fn num_time_series(&self) -> i32 {
        self.num_time_series
    }
    /// <p>Details about the dimensions that contributed to the anomaly.</p>
    pub fn contribution_matrix(&self) -> std::option::Option<&crate::model::ContributionMatrix> {
        self.contribution_matrix.as_ref()
    }
}
impl std::fmt::Debug for MetricLevelImpact {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricLevelImpact");
        formatter.field("metric_name", &self.metric_name);
        formatter.field("num_time_series", &self.num_time_series);
        formatter.field("contribution_matrix", &self.contribution_matrix);
        formatter.finish()
    }
}
/// See [`MetricLevelImpact`](crate::model::MetricLevelImpact)
pub mod metric_level_impact {
    /// A builder for [`MetricLevelImpact`](crate::model::MetricLevelImpact)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) num_time_series: std::option::Option<i32>,
        pub(crate) contribution_matrix: std::option::Option<crate::model::ContributionMatrix>,
    }
    impl Builder {
        /// <p>The name of the measure.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the measure.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The number of anomalous metrics for the measure.</p>
        pub fn num_time_series(mut self, input: i32) -> Self {
            self.num_time_series = Some(input);
            self
        }
        /// <p>The number of anomalous metrics for the measure.</p>
        pub fn set_num_time_series(mut self, input: std::option::Option<i32>) -> Self {
            self.num_time_series = input;
            self
        }
        /// <p>Details about the dimensions that contributed to the anomaly.</p>
        pub fn contribution_matrix(mut self, input: crate::model::ContributionMatrix) -> Self {
            self.contribution_matrix = Some(input);
            self
        }
        /// <p>Details about the dimensions that contributed to the anomaly.</p>
        pub fn set_contribution_matrix(
            mut self,
            input: std::option::Option<crate::model::ContributionMatrix>,
        ) -> Self {
            self.contribution_matrix = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricLevelImpact`](crate::model::MetricLevelImpact)
        pub fn build(self) -> crate::model::MetricLevelImpact {
            crate::model::MetricLevelImpact {
                metric_name: self.metric_name,
                num_time_series: self.num_time_series.unwrap_or_default(),
                contribution_matrix: self.contribution_matrix,
            }
        }
    }
}
impl MetricLevelImpact {
    /// Creates a new builder-style object to manufacture [`MetricLevelImpact`](crate::model::MetricLevelImpact)
    pub fn builder() -> crate::model::metric_level_impact::Builder {
        crate::model::metric_level_impact::Builder::default()
    }
}

/// <p>Details about dimensions that contributed to an anomaly.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContributionMatrix {
    /// <p>A list of contributing dimensions.</p>
    pub dimension_contribution_list:
        std::option::Option<std::vec::Vec<crate::model::DimensionContribution>>,
}
impl ContributionMatrix {
    /// <p>A list of contributing dimensions.</p>
    pub fn dimension_contribution_list(
        &self,
    ) -> std::option::Option<&[crate::model::DimensionContribution]> {
        self.dimension_contribution_list.as_deref()
    }
}
impl std::fmt::Debug for ContributionMatrix {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContributionMatrix");
        formatter.field(
            "dimension_contribution_list",
            &self.dimension_contribution_list,
        );
        formatter.finish()
    }
}
/// See [`ContributionMatrix`](crate::model::ContributionMatrix)
pub mod contribution_matrix {
    /// A builder for [`ContributionMatrix`](crate::model::ContributionMatrix)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimension_contribution_list:
            std::option::Option<std::vec::Vec<crate::model::DimensionContribution>>,
    }
    impl Builder {
        /// Appends an item to `dimension_contribution_list`.
        ///
        /// To override the contents of this collection use [`set_dimension_contribution_list`](Self::set_dimension_contribution_list).
        ///
        /// <p>A list of contributing dimensions.</p>
        pub fn dimension_contribution_list(
            mut self,
            input: crate::model::DimensionContribution,
        ) -> Self {
            let mut v = self.dimension_contribution_list.unwrap_or_default();
            v.push(input);
            self.dimension_contribution_list = Some(v);
            self
        }
        /// <p>A list of contributing dimensions.</p>
        pub fn set_dimension_contribution_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DimensionContribution>>,
        ) -> Self {
            self.dimension_contribution_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ContributionMatrix`](crate::model::ContributionMatrix)
        pub fn build(self) -> crate::model::ContributionMatrix {
            crate::model::ContributionMatrix {
                dimension_contribution_list: self.dimension_contribution_list,
            }
        }
    }
}
impl ContributionMatrix {
    /// Creates a new builder-style object to manufacture [`ContributionMatrix`](crate::model::ContributionMatrix)
    pub fn builder() -> crate::model::contribution_matrix::Builder {
        crate::model::contribution_matrix::Builder::default()
    }
}

/// <p>Details about a dimension that contributed to an anomaly.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DimensionContribution {
    /// <p>The name of the dimension.</p>
    pub dimension_name: std::option::Option<std::string::String>,
    /// <p>A list of dimension values that contributed to the anomaly.</p>
    pub dimension_value_contribution_list:
        std::option::Option<std::vec::Vec<crate::model::DimensionValueContribution>>,
}
impl DimensionContribution {
    /// <p>The name of the dimension.</p>
    pub fn dimension_name(&self) -> std::option::Option<&str> {
        self.dimension_name.as_deref()
    }
    /// <p>A list of dimension values that contributed to the anomaly.</p>
    pub fn dimension_value_contribution_list(
        &self,
    ) -> std::option::Option<&[crate::model::DimensionValueContribution]> {
        self.dimension_value_contribution_list.as_deref()
    }
}
impl std::fmt::Debug for DimensionContribution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DimensionContribution");
        formatter.field("dimension_name", &self.dimension_name);
        formatter.field(
            "dimension_value_contribution_list",
            &self.dimension_value_contribution_list,
        );
        formatter.finish()
    }
}
/// See [`DimensionContribution`](crate::model::DimensionContribution)
pub mod dimension_contribution {
    /// A builder for [`DimensionContribution`](crate::model::DimensionContribution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimension_name: std::option::Option<std::string::String>,
        pub(crate) dimension_value_contribution_list:
            std::option::Option<std::vec::Vec<crate::model::DimensionValueContribution>>,
    }
    impl Builder {
        /// <p>The name of the dimension.</p>
        pub fn dimension_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dimension_name = Some(input.into());
            self
        }
        /// <p>The name of the dimension.</p>
        pub fn set_dimension_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dimension_name = input;
            self
        }
        /// Appends an item to `dimension_value_contribution_list`.
        ///
        /// To override the contents of this collection use [`set_dimension_value_contribution_list`](Self::set_dimension_value_contribution_list).
        ///
        /// <p>A list of dimension values that contributed to the anomaly.</p>
        pub fn dimension_value_contribution_list(
            mut self,
            input: crate::model::DimensionValueContribution,
        ) -> Self {
            let mut v = self.dimension_value_contribution_list.unwrap_or_default();
            v.push(input);
            self.dimension_value_contribution_list = Some(v);
            self
        }
        /// <p>A list of dimension values that contributed to the anomaly.</p>
        pub fn set_dimension_value_contribution_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DimensionValueContribution>>,
        ) -> Self {
            self.dimension_value_contribution_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DimensionContribution`](crate::model::DimensionContribution)
        pub fn build(self) -> crate::model::DimensionContribution {
            crate::model::DimensionContribution {
                dimension_name: self.dimension_name,
                dimension_value_contribution_list: self.dimension_value_contribution_list,
            }
        }
    }
}
impl DimensionContribution {
    /// Creates a new builder-style object to manufacture [`DimensionContribution`](crate::model::DimensionContribution)
    pub fn builder() -> crate::model::dimension_contribution::Builder {
        crate::model::dimension_contribution::Builder::default()
    }
}

/// <p>The severity of a value of a dimension that contributed to an anomaly.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DimensionValueContribution {
    /// <p>The value of the dimension.</p>
    pub dimension_value: std::option::Option<std::string::String>,
    /// <p>The severity score of the value.</p>
    pub contribution_score: std::option::Option<f64>,
}
impl DimensionValueContribution {
    /// <p>The value of the dimension.</p>
    pub fn dimension_value(&self) -> std::option::Option<&str> {
        self.dimension_value.as_deref()
    }
    /// <p>The severity score of the value.</p>
    pub fn contribution_score(&self) -> std::option::Option<f64> {
        self.contribution_score
    }
}
impl std::fmt::Debug for DimensionValueContribution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DimensionValueContribution");
        formatter.field("dimension_value", &self.dimension_value);
        formatter.field("contribution_score", &self.contribution_score);
        formatter.finish()
    }
}
/// See [`DimensionValueContribution`](crate::model::DimensionValueContribution)
pub mod dimension_value_contribution {
    /// A builder for [`DimensionValueContribution`](crate::model::DimensionValueContribution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimension_value: std::option::Option<std::string::String>,
        pub(crate) contribution_score: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The value of the dimension.</p>
        pub fn dimension_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.dimension_value = Some(input.into());
            self
        }
        /// <p>The value of the dimension.</p>
        pub fn set_dimension_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dimension_value = input;
            self
        }
        /// <p>The severity score of the value.</p>
        pub fn contribution_score(mut self, input: f64) -> Self {
            self.contribution_score = Some(input);
            self
        }
        /// <p>The severity score of the value.</p>
        pub fn set_contribution_score(mut self, input: std::option::Option<f64>) -> Self {
            self.contribution_score = input;
            self
        }
        /// Consumes the builder and constructs a [`DimensionValueContribution`](crate::model::DimensionValueContribution)
        pub fn build(self) -> crate::model::DimensionValueContribution {
            crate::model::DimensionValueContribution {
                dimension_value: self.dimension_value,
                contribution_score: self.contribution_score,
            }
        }
    }
}
impl DimensionValueContribution {
    /// Creates a new builder-style object to manufacture [`DimensionValueContribution`](crate::model::DimensionValueContribution)
    pub fn builder() -> crate::model::dimension_value_contribution::Builder {
        crate::model::dimension_value_contribution::Builder::default()
    }
}

/// <p>Contains information about a detector's configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalyDetectorConfigSummary {
    /// <p>The interval at which the detector analyzes its source data.</p>
    pub anomaly_detector_frequency: std::option::Option<crate::model::Frequency>,
}
impl AnomalyDetectorConfigSummary {
    /// <p>The interval at which the detector analyzes its source data.</p>
    pub fn anomaly_detector_frequency(&self) -> std::option::Option<&crate::model::Frequency> {
        self.anomaly_detector_frequency.as_ref()
    }
}
impl std::fmt::Debug for AnomalyDetectorConfigSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalyDetectorConfigSummary");
        formatter.field(
            "anomaly_detector_frequency",
            &self.anomaly_detector_frequency,
        );
        formatter.finish()
    }
}
/// See [`AnomalyDetectorConfigSummary`](crate::model::AnomalyDetectorConfigSummary)
pub mod anomaly_detector_config_summary {
    /// A builder for [`AnomalyDetectorConfigSummary`](crate::model::AnomalyDetectorConfigSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_detector_frequency: std::option::Option<crate::model::Frequency>,
    }
    impl Builder {
        /// <p>The interval at which the detector analyzes its source data.</p>
        pub fn anomaly_detector_frequency(mut self, input: crate::model::Frequency) -> Self {
            self.anomaly_detector_frequency = Some(input);
            self
        }
        /// <p>The interval at which the detector analyzes its source data.</p>
        pub fn set_anomaly_detector_frequency(
            mut self,
            input: std::option::Option<crate::model::Frequency>,
        ) -> Self {
            self.anomaly_detector_frequency = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalyDetectorConfigSummary`](crate::model::AnomalyDetectorConfigSummary)
        pub fn build(self) -> crate::model::AnomalyDetectorConfigSummary {
            crate::model::AnomalyDetectorConfigSummary {
                anomaly_detector_frequency: self.anomaly_detector_frequency,
            }
        }
    }
}
impl AnomalyDetectorConfigSummary {
    /// Creates a new builder-style object to manufacture [`AnomalyDetectorConfigSummary`](crate::model::AnomalyDetectorConfigSummary)
    pub fn builder() -> crate::model::anomaly_detector_config_summary::Builder {
        crate::model::anomaly_detector_config_summary::Builder::default()
    }
}

/// <p>The status of an anomaly detector run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecutionStatus {
    /// <p>The run's timestamp.</p>
    pub timestamp: std::option::Option<std::string::String>,
    /// <p>The run's status.</p>
    pub status: std::option::Option<crate::model::AnomalyDetectionTaskStatus>,
    /// <p>The reason that the run failed, if applicable.</p>
    pub failure_reason: std::option::Option<std::string::String>,
}
impl ExecutionStatus {
    /// <p>The run's timestamp.</p>
    pub fn timestamp(&self) -> std::option::Option<&str> {
        self.timestamp.as_deref()
    }
    /// <p>The run's status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AnomalyDetectionTaskStatus> {
        self.status.as_ref()
    }
    /// <p>The reason that the run failed, if applicable.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
}
impl std::fmt::Debug for ExecutionStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecutionStatus");
        formatter.field("timestamp", &self.timestamp);
        formatter.field("status", &self.status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.finish()
    }
}
/// See [`ExecutionStatus`](crate::model::ExecutionStatus)
pub mod execution_status {
    /// A builder for [`ExecutionStatus`](crate::model::ExecutionStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timestamp: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AnomalyDetectionTaskStatus>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The run's timestamp.</p>
        pub fn timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.timestamp = Some(input.into());
            self
        }
        /// <p>The run's timestamp.</p>
        pub fn set_timestamp(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The run's status.</p>
        pub fn status(mut self, input: crate::model::AnomalyDetectionTaskStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The run's status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AnomalyDetectionTaskStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason that the run failed, if applicable.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The reason that the run failed, if applicable.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecutionStatus`](crate::model::ExecutionStatus)
        pub fn build(self) -> crate::model::ExecutionStatus {
            crate::model::ExecutionStatus {
                timestamp: self.timestamp,
                status: self.status,
                failure_reason: self.failure_reason,
            }
        }
    }
}
impl ExecutionStatus {
    /// Creates a new builder-style object to manufacture [`ExecutionStatus`](crate::model::ExecutionStatus)
    pub fn builder() -> crate::model::execution_status::Builder {
        crate::model::execution_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AnomalyDetectionTaskStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    FailedToSchedule,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AnomalyDetectionTaskStatus {
    fn from(s: &str) -> Self {
        match s {
            "COMPLETED" => AnomalyDetectionTaskStatus::Completed,
            "FAILED" => AnomalyDetectionTaskStatus::Failed,
            "FAILED_TO_SCHEDULE" => AnomalyDetectionTaskStatus::FailedToSchedule,
            "IN_PROGRESS" => AnomalyDetectionTaskStatus::InProgress,
            "PENDING" => AnomalyDetectionTaskStatus::Pending,
            other => AnomalyDetectionTaskStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AnomalyDetectionTaskStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AnomalyDetectionTaskStatus::from(s))
    }
}
impl AnomalyDetectionTaskStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AnomalyDetectionTaskStatus::Completed => "COMPLETED",
            AnomalyDetectionTaskStatus::Failed => "FAILED",
            AnomalyDetectionTaskStatus::FailedToSchedule => "FAILED_TO_SCHEDULE",
            AnomalyDetectionTaskStatus::InProgress => "IN_PROGRESS",
            AnomalyDetectionTaskStatus::Pending => "PENDING",
            AnomalyDetectionTaskStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "COMPLETED",
            "FAILED",
            "FAILED_TO_SCHEDULE",
            "IN_PROGRESS",
            "PENDING",
        ]
    }
}
impl AsRef<str> for AnomalyDetectionTaskStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A configuration for Amazon SNS-integrated notifications.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Alert {
    /// <p>Action that will be triggered when there is an alert.</p>
    pub action: std::option::Option<crate::model::Action>,
    /// <p>A description of the alert.</p>
    pub alert_description: std::option::Option<std::string::String>,
    /// <p>The ARN of the alert.</p>
    pub alert_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the detector to which the alert is attached.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
    /// <p>The name of the alert.</p>
    pub alert_name: std::option::Option<std::string::String>,
    /// <p>The minimum severity for an anomaly to trigger the alert.</p>
    pub alert_sensitivity_threshold: i32,
    /// <p>The type of the alert.</p>
    pub alert_type: std::option::Option<crate::model::AlertType>,
    /// <p>The status of the alert.</p>
    pub alert_status: std::option::Option<crate::model::AlertStatus>,
    /// <p>The time at which the alert was last modified.</p>
    pub last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the alert was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl Alert {
    /// <p>Action that will be triggered when there is an alert.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::Action> {
        self.action.as_ref()
    }
    /// <p>A description of the alert.</p>
    pub fn alert_description(&self) -> std::option::Option<&str> {
        self.alert_description.as_deref()
    }
    /// <p>The ARN of the alert.</p>
    pub fn alert_arn(&self) -> std::option::Option<&str> {
        self.alert_arn.as_deref()
    }
    /// <p>The ARN of the detector to which the alert is attached.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
    /// <p>The name of the alert.</p>
    pub fn alert_name(&self) -> std::option::Option<&str> {
        self.alert_name.as_deref()
    }
    /// <p>The minimum severity for an anomaly to trigger the alert.</p>
    pub fn alert_sensitivity_threshold(&self) -> i32 {
        self.alert_sensitivity_threshold
    }
    /// <p>The type of the alert.</p>
    pub fn alert_type(&self) -> std::option::Option<&crate::model::AlertType> {
        self.alert_type.as_ref()
    }
    /// <p>The status of the alert.</p>
    pub fn alert_status(&self) -> std::option::Option<&crate::model::AlertStatus> {
        self.alert_status.as_ref()
    }
    /// <p>The time at which the alert was last modified.</p>
    pub fn last_modification_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modification_time.as_ref()
    }
    /// <p>The time at which the alert was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
}
impl std::fmt::Debug for Alert {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Alert");
        formatter.field("action", &self.action);
        formatter.field("alert_description", &self.alert_description);
        formatter.field("alert_arn", &self.alert_arn);
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.field("alert_name", &self.alert_name);
        formatter.field(
            "alert_sensitivity_threshold",
            &self.alert_sensitivity_threshold,
        );
        formatter.field("alert_type", &self.alert_type);
        formatter.field("alert_status", &self.alert_status);
        formatter.field("last_modification_time", &self.last_modification_time);
        formatter.field("creation_time", &self.creation_time);
        formatter.finish()
    }
}
/// See [`Alert`](crate::model::Alert)
pub mod alert {
    /// A builder for [`Alert`](crate::model::Alert)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::Action>,
        pub(crate) alert_description: std::option::Option<std::string::String>,
        pub(crate) alert_arn: std::option::Option<std::string::String>,
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
        pub(crate) alert_name: std::option::Option<std::string::String>,
        pub(crate) alert_sensitivity_threshold: std::option::Option<i32>,
        pub(crate) alert_type: std::option::Option<crate::model::AlertType>,
        pub(crate) alert_status: std::option::Option<crate::model::AlertStatus>,
        pub(crate) last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Action that will be triggered when there is an alert.</p>
        pub fn action(mut self, input: crate::model::Action) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>Action that will be triggered when there is an alert.</p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.action = input;
            self
        }
        /// <p>A description of the alert.</p>
        pub fn alert_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.alert_description = Some(input.into());
            self
        }
        /// <p>A description of the alert.</p>
        pub fn set_alert_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.alert_description = input;
            self
        }
        /// <p>The ARN of the alert.</p>
        pub fn alert_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alert_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the alert.</p>
        pub fn set_alert_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alert_arn = input;
            self
        }
        /// <p>The ARN of the detector to which the alert is attached.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the detector to which the alert is attached.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// <p>The name of the alert.</p>
        pub fn alert_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alert_name = Some(input.into());
            self
        }
        /// <p>The name of the alert.</p>
        pub fn set_alert_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alert_name = input;
            self
        }
        /// <p>The minimum severity for an anomaly to trigger the alert.</p>
        pub fn alert_sensitivity_threshold(mut self, input: i32) -> Self {
            self.alert_sensitivity_threshold = Some(input);
            self
        }
        /// <p>The minimum severity for an anomaly to trigger the alert.</p>
        pub fn set_alert_sensitivity_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.alert_sensitivity_threshold = input;
            self
        }
        /// <p>The type of the alert.</p>
        pub fn alert_type(mut self, input: crate::model::AlertType) -> Self {
            self.alert_type = Some(input);
            self
        }
        /// <p>The type of the alert.</p>
        pub fn set_alert_type(
            mut self,
            input: std::option::Option<crate::model::AlertType>,
        ) -> Self {
            self.alert_type = input;
            self
        }
        /// <p>The status of the alert.</p>
        pub fn alert_status(mut self, input: crate::model::AlertStatus) -> Self {
            self.alert_status = Some(input);
            self
        }
        /// <p>The status of the alert.</p>
        pub fn set_alert_status(
            mut self,
            input: std::option::Option<crate::model::AlertStatus>,
        ) -> Self {
            self.alert_status = input;
            self
        }
        /// <p>The time at which the alert was last modified.</p>
        pub fn last_modification_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modification_time = Some(input);
            self
        }
        /// <p>The time at which the alert was last modified.</p>
        pub fn set_last_modification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modification_time = input;
            self
        }
        /// <p>The time at which the alert was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time at which the alert was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Alert`](crate::model::Alert)
        pub fn build(self) -> crate::model::Alert {
            crate::model::Alert {
                action: self.action,
                alert_description: self.alert_description,
                alert_arn: self.alert_arn,
                anomaly_detector_arn: self.anomaly_detector_arn,
                alert_name: self.alert_name,
                alert_sensitivity_threshold: self.alert_sensitivity_threshold.unwrap_or_default(),
                alert_type: self.alert_type,
                alert_status: self.alert_status,
                last_modification_time: self.last_modification_time,
                creation_time: self.creation_time,
            }
        }
    }
}
impl Alert {
    /// Creates a new builder-style object to manufacture [`Alert`](crate::model::Alert)
    pub fn builder() -> crate::model::alert::Builder {
        crate::model::alert::Builder::default()
    }
}

/// <p>A configuration that specifies the action to perform when anomalies are detected.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Action {
    /// <p>A configuration for an Amazon SNS channel.</p>
    pub sns_configuration: std::option::Option<crate::model::SnsConfiguration>,
    /// <p>A configuration for an AWS Lambda channel.</p>
    pub lambda_configuration: std::option::Option<crate::model::LambdaConfiguration>,
}
impl Action {
    /// <p>A configuration for an Amazon SNS channel.</p>
    pub fn sns_configuration(&self) -> std::option::Option<&crate::model::SnsConfiguration> {
        self.sns_configuration.as_ref()
    }
    /// <p>A configuration for an AWS Lambda channel.</p>
    pub fn lambda_configuration(&self) -> std::option::Option<&crate::model::LambdaConfiguration> {
        self.lambda_configuration.as_ref()
    }
}
impl std::fmt::Debug for Action {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Action");
        formatter.field("sns_configuration", &self.sns_configuration);
        formatter.field("lambda_configuration", &self.lambda_configuration);
        formatter.finish()
    }
}
/// See [`Action`](crate::model::Action)
pub mod action {
    /// A builder for [`Action`](crate::model::Action)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sns_configuration: std::option::Option<crate::model::SnsConfiguration>,
        pub(crate) lambda_configuration: std::option::Option<crate::model::LambdaConfiguration>,
    }
    impl Builder {
        /// <p>A configuration for an Amazon SNS channel.</p>
        pub fn sns_configuration(mut self, input: crate::model::SnsConfiguration) -> Self {
            self.sns_configuration = Some(input);
            self
        }
        /// <p>A configuration for an Amazon SNS channel.</p>
        pub fn set_sns_configuration(
            mut self,
            input: std::option::Option<crate::model::SnsConfiguration>,
        ) -> Self {
            self.sns_configuration = input;
            self
        }
        /// <p>A configuration for an AWS Lambda channel.</p>
        pub fn lambda_configuration(mut self, input: crate::model::LambdaConfiguration) -> Self {
            self.lambda_configuration = Some(input);
            self
        }
        /// <p>A configuration for an AWS Lambda channel.</p>
        pub fn set_lambda_configuration(
            mut self,
            input: std::option::Option<crate::model::LambdaConfiguration>,
        ) -> Self {
            self.lambda_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`Action`](crate::model::Action)
        pub fn build(self) -> crate::model::Action {
            crate::model::Action {
                sns_configuration: self.sns_configuration,
                lambda_configuration: self.lambda_configuration,
            }
        }
    }
}
impl Action {
    /// Creates a new builder-style object to manufacture [`Action`](crate::model::Action)
    pub fn builder() -> crate::model::action::Builder {
        crate::model::action::Builder::default()
    }
}

/// <p>Contains information about a Lambda configuration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LambdaConfiguration {
    /// <p>The ARN of an IAM role that has permission to invoke the Lambda function.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the Lambda function.</p>
    pub lambda_arn: std::option::Option<std::string::String>,
}
impl LambdaConfiguration {
    /// <p>The ARN of an IAM role that has permission to invoke the Lambda function.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The ARN of the Lambda function.</p>
    pub fn lambda_arn(&self) -> std::option::Option<&str> {
        self.lambda_arn.as_deref()
    }
}
impl std::fmt::Debug for LambdaConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LambdaConfiguration");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("lambda_arn", &self.lambda_arn);
        formatter.finish()
    }
}
/// See [`LambdaConfiguration`](crate::model::LambdaConfiguration)
pub mod lambda_configuration {
    /// A builder for [`LambdaConfiguration`](crate::model::LambdaConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) lambda_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of an IAM role that has permission to invoke the Lambda function.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of an IAM role that has permission to invoke the Lambda function.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The ARN of the Lambda function.</p>
        pub fn lambda_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.lambda_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Lambda function.</p>
        pub fn set_lambda_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lambda_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`LambdaConfiguration`](crate::model::LambdaConfiguration)
        pub fn build(self) -> crate::model::LambdaConfiguration {
            crate::model::LambdaConfiguration {
                role_arn: self.role_arn,
                lambda_arn: self.lambda_arn,
            }
        }
    }
}
impl LambdaConfiguration {
    /// Creates a new builder-style object to manufacture [`LambdaConfiguration`](crate::model::LambdaConfiguration)
    pub fn builder() -> crate::model::lambda_configuration::Builder {
        crate::model::lambda_configuration::Builder::default()
    }
}

/// <p>Contains information about the SNS topic to which you want to send your alerts and the IAM role that has access to that topic.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnsConfiguration {
    /// <p>The ARN of the IAM role that has access to the target SNS topic.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the target SNS topic.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
}
impl SnsConfiguration {
    /// <p>The ARN of the IAM role that has access to the target SNS topic.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The ARN of the target SNS topic.</p>
    pub fn sns_topic_arn(&self) -> std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
}
impl std::fmt::Debug for SnsConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnsConfiguration");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.finish()
    }
}
/// See [`SnsConfiguration`](crate::model::SnsConfiguration)
pub mod sns_configuration {
    /// A builder for [`SnsConfiguration`](crate::model::SnsConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the IAM role that has access to the target SNS topic.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the IAM role that has access to the target SNS topic.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The ARN of the target SNS topic.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the target SNS topic.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`SnsConfiguration`](crate::model::SnsConfiguration)
        pub fn build(self) -> crate::model::SnsConfiguration {
            crate::model::SnsConfiguration {
                role_arn: self.role_arn,
                sns_topic_arn: self.sns_topic_arn,
            }
        }
    }
}
impl SnsConfiguration {
    /// Creates a new builder-style object to manufacture [`SnsConfiguration`](crate::model::SnsConfiguration)
    pub fn builder() -> crate::model::sns_configuration::Builder {
        crate::model::sns_configuration::Builder::default()
    }
}
