// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMetricSetOutput {
    /// <p>The ARN of the dataset.</p>
    pub metric_set_arn: std::option::Option<std::string::String>,
}
impl UpdateMetricSetOutput {
    /// <p>The ARN of the dataset.</p>
    pub fn metric_set_arn(&self) -> std::option::Option<&str> {
        self.metric_set_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateMetricSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMetricSetOutput");
        formatter.field("metric_set_arn", &self.metric_set_arn);
        formatter.finish()
    }
}
/// See [`UpdateMetricSetOutput`](crate::output::UpdateMetricSetOutput)
pub mod update_metric_set_output {
    /// A builder for [`UpdateMetricSetOutput`](crate::output::UpdateMetricSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_set_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the dataset.</p>
        pub fn metric_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the dataset.</p>
        pub fn set_metric_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_set_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMetricSetOutput`](crate::output::UpdateMetricSetOutput)
        pub fn build(self) -> crate::output::UpdateMetricSetOutput {
            crate::output::UpdateMetricSetOutput {
                metric_set_arn: self.metric_set_arn,
            }
        }
    }
}
impl UpdateMetricSetOutput {
    /// Creates a new builder-style object to manufacture [`UpdateMetricSetOutput`](crate::output::UpdateMetricSetOutput)
    pub fn builder() -> crate::output::update_metric_set_output::Builder {
        crate::output::update_metric_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAnomalyDetectorOutput {
    /// <p>The ARN of the updated detector.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
}
impl UpdateAnomalyDetectorOutput {
    /// <p>The ARN of the updated detector.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateAnomalyDetectorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAnomalyDetectorOutput");
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.finish()
    }
}
/// See [`UpdateAnomalyDetectorOutput`](crate::output::UpdateAnomalyDetectorOutput)
pub mod update_anomaly_detector_output {
    /// A builder for [`UpdateAnomalyDetectorOutput`](crate::output::UpdateAnomalyDetectorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the updated detector.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the updated detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAnomalyDetectorOutput`](crate::output::UpdateAnomalyDetectorOutput)
        pub fn build(self) -> crate::output::UpdateAnomalyDetectorOutput {
            crate::output::UpdateAnomalyDetectorOutput {
                anomaly_detector_arn: self.anomaly_detector_arn,
            }
        }
    }
}
impl UpdateAnomalyDetectorOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAnomalyDetectorOutput`](crate::output::UpdateAnomalyDetectorOutput)
    pub fn builder() -> crate::output::update_anomaly_detector_output::Builder {
        crate::output::update_anomaly_detector_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutFeedbackOutput {}
impl std::fmt::Debug for PutFeedbackOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutFeedbackOutput");
        formatter.finish()
    }
}
/// See [`PutFeedbackOutput`](crate::output::PutFeedbackOutput)
pub mod put_feedback_output {
    /// A builder for [`PutFeedbackOutput`](crate::output::PutFeedbackOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`PutFeedbackOutput`](crate::output::PutFeedbackOutput)
        pub fn build(self) -> crate::output::PutFeedbackOutput {
            crate::output::PutFeedbackOutput {}
        }
    }
}
impl PutFeedbackOutput {
    /// Creates a new builder-style object to manufacture [`PutFeedbackOutput`](crate::output::PutFeedbackOutput)
    pub fn builder() -> crate::output::put_feedback_output::Builder {
        crate::output::put_feedback_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The resource's tags.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>The resource's tags.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The resource's tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The resource's tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMetricSetsOutput {
    /// <p>A list of the datasets in the AWS Region, with configuration details for each.</p>
    pub metric_set_summary_list: std::option::Option<std::vec::Vec<crate::model::MetricSetSummary>>,
    /// <p>If the response is truncated, the list call returns this token. To retrieve the next set of results, use the token in the next list request. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListMetricSetsOutput {
    /// <p>A list of the datasets in the AWS Region, with configuration details for each.</p>
    pub fn metric_set_summary_list(
        &self,
    ) -> std::option::Option<&[crate::model::MetricSetSummary]> {
        self.metric_set_summary_list.as_deref()
    }
    /// <p>If the response is truncated, the list call returns this token. To retrieve the next set of results, use the token in the next list request. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListMetricSetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMetricSetsOutput");
        formatter.field("metric_set_summary_list", &self.metric_set_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListMetricSetsOutput`](crate::output::ListMetricSetsOutput)
pub mod list_metric_sets_output {
    /// A builder for [`ListMetricSetsOutput`](crate::output::ListMetricSetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_set_summary_list:
            std::option::Option<std::vec::Vec<crate::model::MetricSetSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `metric_set_summary_list`.
        ///
        /// To override the contents of this collection use [`set_metric_set_summary_list`](Self::set_metric_set_summary_list).
        ///
        /// <p>A list of the datasets in the AWS Region, with configuration details for each.</p>
        pub fn metric_set_summary_list(mut self, input: crate::model::MetricSetSummary) -> Self {
            let mut v = self.metric_set_summary_list.unwrap_or_default();
            v.push(input);
            self.metric_set_summary_list = Some(v);
            self
        }
        /// <p>A list of the datasets in the AWS Region, with configuration details for each.</p>
        pub fn set_metric_set_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricSetSummary>>,
        ) -> Self {
            self.metric_set_summary_list = input;
            self
        }
        /// <p>If the response is truncated, the list call returns this token. To retrieve the next set of results, use the token in the next list request. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, the list call returns this token. To retrieve the next set of results, use the token in the next list request. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMetricSetsOutput`](crate::output::ListMetricSetsOutput)
        pub fn build(self) -> crate::output::ListMetricSetsOutput {
            crate::output::ListMetricSetsOutput {
                metric_set_summary_list: self.metric_set_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListMetricSetsOutput {
    /// Creates a new builder-style object to manufacture [`ListMetricSetsOutput`](crate::output::ListMetricSetsOutput)
    pub fn builder() -> crate::output::list_metric_sets_output::Builder {
        crate::output::list_metric_sets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAnomalyGroupTimeSeriesOutput {
    /// <p>The ID of the anomaly group.</p>
    pub anomaly_group_id: std::option::Option<std::string::String>,
    /// <p>The name of the measure field.</p>
    pub metric_name: std::option::Option<std::string::String>,
    /// <p>Timestamps for the anomalous metrics.</p>
    pub timestamp_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The pagination token that's included if more results are available.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>A list of anomalous metrics.</p>
    pub time_series_list: std::option::Option<std::vec::Vec<crate::model::TimeSeries>>,
}
impl ListAnomalyGroupTimeSeriesOutput {
    /// <p>The ID of the anomaly group.</p>
    pub fn anomaly_group_id(&self) -> std::option::Option<&str> {
        self.anomaly_group_id.as_deref()
    }
    /// <p>The name of the measure field.</p>
    pub fn metric_name(&self) -> std::option::Option<&str> {
        self.metric_name.as_deref()
    }
    /// <p>Timestamps for the anomalous metrics.</p>
    pub fn timestamp_list(&self) -> std::option::Option<&[std::string::String]> {
        self.timestamp_list.as_deref()
    }
    /// <p>The pagination token that's included if more results are available.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>A list of anomalous metrics.</p>
    pub fn time_series_list(&self) -> std::option::Option<&[crate::model::TimeSeries]> {
        self.time_series_list.as_deref()
    }
}
impl std::fmt::Debug for ListAnomalyGroupTimeSeriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAnomalyGroupTimeSeriesOutput");
        formatter.field("anomaly_group_id", &self.anomaly_group_id);
        formatter.field("metric_name", &self.metric_name);
        formatter.field("timestamp_list", &self.timestamp_list);
        formatter.field("next_token", &self.next_token);
        formatter.field("time_series_list", &self.time_series_list);
        formatter.finish()
    }
}
/// See [`ListAnomalyGroupTimeSeriesOutput`](crate::output::ListAnomalyGroupTimeSeriesOutput)
pub mod list_anomaly_group_time_series_output {
    /// A builder for [`ListAnomalyGroupTimeSeriesOutput`](crate::output::ListAnomalyGroupTimeSeriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_group_id: std::option::Option<std::string::String>,
        pub(crate) metric_name: std::option::Option<std::string::String>,
        pub(crate) timestamp_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) time_series_list: std::option::Option<std::vec::Vec<crate::model::TimeSeries>>,
    }
    impl Builder {
        /// <p>The ID of the anomaly group.</p>
        pub fn anomaly_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_group_id = Some(input.into());
            self
        }
        /// <p>The ID of the anomaly group.</p>
        pub fn set_anomaly_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_group_id = input;
            self
        }
        /// <p>The name of the measure field.</p>
        pub fn metric_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_name = Some(input.into());
            self
        }
        /// <p>The name of the measure field.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.metric_name = input;
            self
        }
        /// Appends an item to `timestamp_list`.
        ///
        /// To override the contents of this collection use [`set_timestamp_list`](Self::set_timestamp_list).
        ///
        /// <p>Timestamps for the anomalous metrics.</p>
        pub fn timestamp_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.timestamp_list.unwrap_or_default();
            v.push(input.into());
            self.timestamp_list = Some(v);
            self
        }
        /// <p>Timestamps for the anomalous metrics.</p>
        pub fn set_timestamp_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.timestamp_list = input;
            self
        }
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `time_series_list`.
        ///
        /// To override the contents of this collection use [`set_time_series_list`](Self::set_time_series_list).
        ///
        /// <p>A list of anomalous metrics.</p>
        pub fn time_series_list(mut self, input: crate::model::TimeSeries) -> Self {
            let mut v = self.time_series_list.unwrap_or_default();
            v.push(input);
            self.time_series_list = Some(v);
            self
        }
        /// <p>A list of anomalous metrics.</p>
        pub fn set_time_series_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TimeSeries>>,
        ) -> Self {
            self.time_series_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAnomalyGroupTimeSeriesOutput`](crate::output::ListAnomalyGroupTimeSeriesOutput)
        pub fn build(self) -> crate::output::ListAnomalyGroupTimeSeriesOutput {
            crate::output::ListAnomalyGroupTimeSeriesOutput {
                anomaly_group_id: self.anomaly_group_id,
                metric_name: self.metric_name,
                timestamp_list: self.timestamp_list,
                next_token: self.next_token,
                time_series_list: self.time_series_list,
            }
        }
    }
}
impl ListAnomalyGroupTimeSeriesOutput {
    /// Creates a new builder-style object to manufacture [`ListAnomalyGroupTimeSeriesOutput`](crate::output::ListAnomalyGroupTimeSeriesOutput)
    pub fn builder() -> crate::output::list_anomaly_group_time_series_output::Builder {
        crate::output::list_anomaly_group_time_series_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAnomalyGroupSummariesOutput {
    /// <p>A list of anomaly group summaries.</p>
    pub anomaly_group_summary_list:
        std::option::Option<std::vec::Vec<crate::model::AnomalyGroupSummary>>,
    /// <p>Aggregated details about the anomaly groups.</p>
    pub anomaly_group_statistics: std::option::Option<crate::model::AnomalyGroupStatistics>,
    /// <p>The pagination token that's included if more results are available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAnomalyGroupSummariesOutput {
    /// <p>A list of anomaly group summaries.</p>
    pub fn anomaly_group_summary_list(
        &self,
    ) -> std::option::Option<&[crate::model::AnomalyGroupSummary]> {
        self.anomaly_group_summary_list.as_deref()
    }
    /// <p>Aggregated details about the anomaly groups.</p>
    pub fn anomaly_group_statistics(
        &self,
    ) -> std::option::Option<&crate::model::AnomalyGroupStatistics> {
        self.anomaly_group_statistics.as_ref()
    }
    /// <p>The pagination token that's included if more results are available.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAnomalyGroupSummariesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAnomalyGroupSummariesOutput");
        formatter.field(
            "anomaly_group_summary_list",
            &self.anomaly_group_summary_list,
        );
        formatter.field("anomaly_group_statistics", &self.anomaly_group_statistics);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAnomalyGroupSummariesOutput`](crate::output::ListAnomalyGroupSummariesOutput)
pub mod list_anomaly_group_summaries_output {
    /// A builder for [`ListAnomalyGroupSummariesOutput`](crate::output::ListAnomalyGroupSummariesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_group_summary_list:
            std::option::Option<std::vec::Vec<crate::model::AnomalyGroupSummary>>,
        pub(crate) anomaly_group_statistics:
            std::option::Option<crate::model::AnomalyGroupStatistics>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `anomaly_group_summary_list`.
        ///
        /// To override the contents of this collection use [`set_anomaly_group_summary_list`](Self::set_anomaly_group_summary_list).
        ///
        /// <p>A list of anomaly group summaries.</p>
        pub fn anomaly_group_summary_list(
            mut self,
            input: crate::model::AnomalyGroupSummary,
        ) -> Self {
            let mut v = self.anomaly_group_summary_list.unwrap_or_default();
            v.push(input);
            self.anomaly_group_summary_list = Some(v);
            self
        }
        /// <p>A list of anomaly group summaries.</p>
        pub fn set_anomaly_group_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnomalyGroupSummary>>,
        ) -> Self {
            self.anomaly_group_summary_list = input;
            self
        }
        /// <p>Aggregated details about the anomaly groups.</p>
        pub fn anomaly_group_statistics(
            mut self,
            input: crate::model::AnomalyGroupStatistics,
        ) -> Self {
            self.anomaly_group_statistics = Some(input);
            self
        }
        /// <p>Aggregated details about the anomaly groups.</p>
        pub fn set_anomaly_group_statistics(
            mut self,
            input: std::option::Option<crate::model::AnomalyGroupStatistics>,
        ) -> Self {
            self.anomaly_group_statistics = input;
            self
        }
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAnomalyGroupSummariesOutput`](crate::output::ListAnomalyGroupSummariesOutput)
        pub fn build(self) -> crate::output::ListAnomalyGroupSummariesOutput {
            crate::output::ListAnomalyGroupSummariesOutput {
                anomaly_group_summary_list: self.anomaly_group_summary_list,
                anomaly_group_statistics: self.anomaly_group_statistics,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAnomalyGroupSummariesOutput {
    /// Creates a new builder-style object to manufacture [`ListAnomalyGroupSummariesOutput`](crate::output::ListAnomalyGroupSummariesOutput)
    pub fn builder() -> crate::output::list_anomaly_group_summaries_output::Builder {
        crate::output::list_anomaly_group_summaries_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAnomalyGroupRelatedMetricsOutput {
    /// <p>Aggregated details about the measures contributing to the anomaly group, and the measures potentially impacted by the anomaly group.</p>
    pub inter_metric_impact_list:
        std::option::Option<std::vec::Vec<crate::model::InterMetricImpactDetails>>,
    /// <p>The pagination token that's included if more results are available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAnomalyGroupRelatedMetricsOutput {
    /// <p>Aggregated details about the measures contributing to the anomaly group, and the measures potentially impacted by the anomaly group.</p>
    pub fn inter_metric_impact_list(
        &self,
    ) -> std::option::Option<&[crate::model::InterMetricImpactDetails]> {
        self.inter_metric_impact_list.as_deref()
    }
    /// <p>The pagination token that's included if more results are available.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAnomalyGroupRelatedMetricsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAnomalyGroupRelatedMetricsOutput");
        formatter.field("inter_metric_impact_list", &self.inter_metric_impact_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAnomalyGroupRelatedMetricsOutput`](crate::output::ListAnomalyGroupRelatedMetricsOutput)
pub mod list_anomaly_group_related_metrics_output {
    /// A builder for [`ListAnomalyGroupRelatedMetricsOutput`](crate::output::ListAnomalyGroupRelatedMetricsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) inter_metric_impact_list:
            std::option::Option<std::vec::Vec<crate::model::InterMetricImpactDetails>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `inter_metric_impact_list`.
        ///
        /// To override the contents of this collection use [`set_inter_metric_impact_list`](Self::set_inter_metric_impact_list).
        ///
        /// <p>Aggregated details about the measures contributing to the anomaly group, and the measures potentially impacted by the anomaly group.</p>
        pub fn inter_metric_impact_list(
            mut self,
            input: crate::model::InterMetricImpactDetails,
        ) -> Self {
            let mut v = self.inter_metric_impact_list.unwrap_or_default();
            v.push(input);
            self.inter_metric_impact_list = Some(v);
            self
        }
        /// <p>Aggregated details about the measures contributing to the anomaly group, and the measures potentially impacted by the anomaly group.</p>
        pub fn set_inter_metric_impact_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InterMetricImpactDetails>>,
        ) -> Self {
            self.inter_metric_impact_list = input;
            self
        }
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAnomalyGroupRelatedMetricsOutput`](crate::output::ListAnomalyGroupRelatedMetricsOutput)
        pub fn build(self) -> crate::output::ListAnomalyGroupRelatedMetricsOutput {
            crate::output::ListAnomalyGroupRelatedMetricsOutput {
                inter_metric_impact_list: self.inter_metric_impact_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAnomalyGroupRelatedMetricsOutput {
    /// Creates a new builder-style object to manufacture [`ListAnomalyGroupRelatedMetricsOutput`](crate::output::ListAnomalyGroupRelatedMetricsOutput)
    pub fn builder() -> crate::output::list_anomaly_group_related_metrics_output::Builder {
        crate::output::list_anomaly_group_related_metrics_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAnomalyDetectorsOutput {
    /// <p>A list of anomaly detectors in the account in the current region.</p>
    pub anomaly_detector_summary_list:
        std::option::Option<std::vec::Vec<crate::model::AnomalyDetectorSummary>>,
    /// <p>If the response is truncated, the service returns this token. To retrieve the next set of results, use the token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAnomalyDetectorsOutput {
    /// <p>A list of anomaly detectors in the account in the current region.</p>
    pub fn anomaly_detector_summary_list(
        &self,
    ) -> std::option::Option<&[crate::model::AnomalyDetectorSummary]> {
        self.anomaly_detector_summary_list.as_deref()
    }
    /// <p>If the response is truncated, the service returns this token. To retrieve the next set of results, use the token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAnomalyDetectorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAnomalyDetectorsOutput");
        formatter.field(
            "anomaly_detector_summary_list",
            &self.anomaly_detector_summary_list,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAnomalyDetectorsOutput`](crate::output::ListAnomalyDetectorsOutput)
pub mod list_anomaly_detectors_output {
    /// A builder for [`ListAnomalyDetectorsOutput`](crate::output::ListAnomalyDetectorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_detector_summary_list:
            std::option::Option<std::vec::Vec<crate::model::AnomalyDetectorSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `anomaly_detector_summary_list`.
        ///
        /// To override the contents of this collection use [`set_anomaly_detector_summary_list`](Self::set_anomaly_detector_summary_list).
        ///
        /// <p>A list of anomaly detectors in the account in the current region.</p>
        pub fn anomaly_detector_summary_list(
            mut self,
            input: crate::model::AnomalyDetectorSummary,
        ) -> Self {
            let mut v = self.anomaly_detector_summary_list.unwrap_or_default();
            v.push(input);
            self.anomaly_detector_summary_list = Some(v);
            self
        }
        /// <p>A list of anomaly detectors in the account in the current region.</p>
        pub fn set_anomaly_detector_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnomalyDetectorSummary>>,
        ) -> Self {
            self.anomaly_detector_summary_list = input;
            self
        }
        /// <p>If the response is truncated, the service returns this token. To retrieve the next set of results, use the token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, the service returns this token. To retrieve the next set of results, use the token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAnomalyDetectorsOutput`](crate::output::ListAnomalyDetectorsOutput)
        pub fn build(self) -> crate::output::ListAnomalyDetectorsOutput {
            crate::output::ListAnomalyDetectorsOutput {
                anomaly_detector_summary_list: self.anomaly_detector_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAnomalyDetectorsOutput {
    /// Creates a new builder-style object to manufacture [`ListAnomalyDetectorsOutput`](crate::output::ListAnomalyDetectorsOutput)
    pub fn builder() -> crate::output::list_anomaly_detectors_output::Builder {
        crate::output::list_anomaly_detectors_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAlertsOutput {
    /// <p>Contains information about an alert.</p>
    pub alert_summary_list: std::option::Option<std::vec::Vec<crate::model::AlertSummary>>,
    /// <p>If the response is truncated, the service returns this token. To retrieve the next set of results, use this token in the next request.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAlertsOutput {
    /// <p>Contains information about an alert.</p>
    pub fn alert_summary_list(&self) -> std::option::Option<&[crate::model::AlertSummary]> {
        self.alert_summary_list.as_deref()
    }
    /// <p>If the response is truncated, the service returns this token. To retrieve the next set of results, use this token in the next request.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAlertsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAlertsOutput");
        formatter.field("alert_summary_list", &self.alert_summary_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAlertsOutput`](crate::output::ListAlertsOutput)
pub mod list_alerts_output {
    /// A builder for [`ListAlertsOutput`](crate::output::ListAlertsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alert_summary_list:
            std::option::Option<std::vec::Vec<crate::model::AlertSummary>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `alert_summary_list`.
        ///
        /// To override the contents of this collection use [`set_alert_summary_list`](Self::set_alert_summary_list).
        ///
        /// <p>Contains information about an alert.</p>
        pub fn alert_summary_list(mut self, input: crate::model::AlertSummary) -> Self {
            let mut v = self.alert_summary_list.unwrap_or_default();
            v.push(input);
            self.alert_summary_list = Some(v);
            self
        }
        /// <p>Contains information about an alert.</p>
        pub fn set_alert_summary_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AlertSummary>>,
        ) -> Self {
            self.alert_summary_list = input;
            self
        }
        /// <p>If the response is truncated, the service returns this token. To retrieve the next set of results, use this token in the next request.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, the service returns this token. To retrieve the next set of results, use this token in the next request.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAlertsOutput`](crate::output::ListAlertsOutput)
        pub fn build(self) -> crate::output::ListAlertsOutput {
            crate::output::ListAlertsOutput {
                alert_summary_list: self.alert_summary_list,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAlertsOutput {
    /// Creates a new builder-style object to manufacture [`ListAlertsOutput`](crate::output::ListAlertsOutput)
    pub fn builder() -> crate::output::list_alerts_output::Builder {
        crate::output::list_alerts_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSampleDataOutput {
    /// <p>A list of header labels for the records.</p>
    pub header_values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of records.</p>
    pub sample_rows: std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
}
impl GetSampleDataOutput {
    /// <p>A list of header labels for the records.</p>
    pub fn header_values(&self) -> std::option::Option<&[std::string::String]> {
        self.header_values.as_deref()
    }
    /// <p>A list of records.</p>
    pub fn sample_rows(&self) -> std::option::Option<&[std::vec::Vec<std::string::String>]> {
        self.sample_rows.as_deref()
    }
}
impl std::fmt::Debug for GetSampleDataOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSampleDataOutput");
        formatter.field("header_values", &self.header_values);
        formatter.field("sample_rows", &self.sample_rows);
        formatter.finish()
    }
}
/// See [`GetSampleDataOutput`](crate::output::GetSampleDataOutput)
pub mod get_sample_data_output {
    /// A builder for [`GetSampleDataOutput`](crate::output::GetSampleDataOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) header_values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) sample_rows:
            std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
    }
    impl Builder {
        /// Appends an item to `header_values`.
        ///
        /// To override the contents of this collection use [`set_header_values`](Self::set_header_values).
        ///
        /// <p>A list of header labels for the records.</p>
        pub fn header_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.header_values.unwrap_or_default();
            v.push(input.into());
            self.header_values = Some(v);
            self
        }
        /// <p>A list of header labels for the records.</p>
        pub fn set_header_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.header_values = input;
            self
        }
        /// Appends an item to `sample_rows`.
        ///
        /// To override the contents of this collection use [`set_sample_rows`](Self::set_sample_rows).
        ///
        /// <p>A list of records.</p>
        pub fn sample_rows(mut self, input: std::vec::Vec<std::string::String>) -> Self {
            let mut v = self.sample_rows.unwrap_or_default();
            v.push(input);
            self.sample_rows = Some(v);
            self
        }
        /// <p>A list of records.</p>
        pub fn set_sample_rows(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<std::string::String>>>,
        ) -> Self {
            self.sample_rows = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSampleDataOutput`](crate::output::GetSampleDataOutput)
        pub fn build(self) -> crate::output::GetSampleDataOutput {
            crate::output::GetSampleDataOutput {
                header_values: self.header_values,
                sample_rows: self.sample_rows,
            }
        }
    }
}
impl GetSampleDataOutput {
    /// Creates a new builder-style object to manufacture [`GetSampleDataOutput`](crate::output::GetSampleDataOutput)
    pub fn builder() -> crate::output::get_sample_data_output::Builder {
        crate::output::get_sample_data_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFeedbackOutput {
    /// <p>Feedback for an anomalous metric.</p>
    pub anomaly_group_time_series_feedback:
        std::option::Option<std::vec::Vec<crate::model::TimeSeriesFeedback>>,
    /// <p>The pagination token that's included if more results are available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetFeedbackOutput {
    /// <p>Feedback for an anomalous metric.</p>
    pub fn anomaly_group_time_series_feedback(
        &self,
    ) -> std::option::Option<&[crate::model::TimeSeriesFeedback]> {
        self.anomaly_group_time_series_feedback.as_deref()
    }
    /// <p>The pagination token that's included if more results are available.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetFeedbackOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFeedbackOutput");
        formatter.field(
            "anomaly_group_time_series_feedback",
            &self.anomaly_group_time_series_feedback,
        );
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetFeedbackOutput`](crate::output::GetFeedbackOutput)
pub mod get_feedback_output {
    /// A builder for [`GetFeedbackOutput`](crate::output::GetFeedbackOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_group_time_series_feedback:
            std::option::Option<std::vec::Vec<crate::model::TimeSeriesFeedback>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `anomaly_group_time_series_feedback`.
        ///
        /// To override the contents of this collection use [`set_anomaly_group_time_series_feedback`](Self::set_anomaly_group_time_series_feedback).
        ///
        /// <p>Feedback for an anomalous metric.</p>
        pub fn anomaly_group_time_series_feedback(
            mut self,
            input: crate::model::TimeSeriesFeedback,
        ) -> Self {
            let mut v = self.anomaly_group_time_series_feedback.unwrap_or_default();
            v.push(input);
            self.anomaly_group_time_series_feedback = Some(v);
            self
        }
        /// <p>Feedback for an anomalous metric.</p>
        pub fn set_anomaly_group_time_series_feedback(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TimeSeriesFeedback>>,
        ) -> Self {
            self.anomaly_group_time_series_feedback = input;
            self
        }
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFeedbackOutput`](crate::output::GetFeedbackOutput)
        pub fn build(self) -> crate::output::GetFeedbackOutput {
            crate::output::GetFeedbackOutput {
                anomaly_group_time_series_feedback: self.anomaly_group_time_series_feedback,
                next_token: self.next_token,
            }
        }
    }
}
impl GetFeedbackOutput {
    /// Creates a new builder-style object to manufacture [`GetFeedbackOutput`](crate::output::GetFeedbackOutput)
    pub fn builder() -> crate::output::get_feedback_output::Builder {
        crate::output::get_feedback_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAnomalyGroupOutput {
    /// <p>Details about the anomaly group.</p>
    pub anomaly_group: std::option::Option<crate::model::AnomalyGroup>,
}
impl GetAnomalyGroupOutput {
    /// <p>Details about the anomaly group.</p>
    pub fn anomaly_group(&self) -> std::option::Option<&crate::model::AnomalyGroup> {
        self.anomaly_group.as_ref()
    }
}
impl std::fmt::Debug for GetAnomalyGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAnomalyGroupOutput");
        formatter.field("anomaly_group", &self.anomaly_group);
        formatter.finish()
    }
}
/// See [`GetAnomalyGroupOutput`](crate::output::GetAnomalyGroupOutput)
pub mod get_anomaly_group_output {
    /// A builder for [`GetAnomalyGroupOutput`](crate::output::GetAnomalyGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_group: std::option::Option<crate::model::AnomalyGroup>,
    }
    impl Builder {
        /// <p>Details about the anomaly group.</p>
        pub fn anomaly_group(mut self, input: crate::model::AnomalyGroup) -> Self {
            self.anomaly_group = Some(input);
            self
        }
        /// <p>Details about the anomaly group.</p>
        pub fn set_anomaly_group(
            mut self,
            input: std::option::Option<crate::model::AnomalyGroup>,
        ) -> Self {
            self.anomaly_group = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAnomalyGroupOutput`](crate::output::GetAnomalyGroupOutput)
        pub fn build(self) -> crate::output::GetAnomalyGroupOutput {
            crate::output::GetAnomalyGroupOutput {
                anomaly_group: self.anomaly_group,
            }
        }
    }
}
impl GetAnomalyGroupOutput {
    /// Creates a new builder-style object to manufacture [`GetAnomalyGroupOutput`](crate::output::GetAnomalyGroupOutput)
    pub fn builder() -> crate::output::get_anomaly_group_output::Builder {
        crate::output::get_anomaly_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectMetricSetConfigOutput {
    /// <p>The inferred dataset configuration for the datasource.</p>
    pub detected_metric_set_config: std::option::Option<crate::model::DetectedMetricSetConfig>,
}
impl DetectMetricSetConfigOutput {
    /// <p>The inferred dataset configuration for the datasource.</p>
    pub fn detected_metric_set_config(
        &self,
    ) -> std::option::Option<&crate::model::DetectedMetricSetConfig> {
        self.detected_metric_set_config.as_ref()
    }
}
impl std::fmt::Debug for DetectMetricSetConfigOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectMetricSetConfigOutput");
        formatter.field(
            "detected_metric_set_config",
            &self.detected_metric_set_config,
        );
        formatter.finish()
    }
}
/// See [`DetectMetricSetConfigOutput`](crate::output::DetectMetricSetConfigOutput)
pub mod detect_metric_set_config_output {
    /// A builder for [`DetectMetricSetConfigOutput`](crate::output::DetectMetricSetConfigOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detected_metric_set_config:
            std::option::Option<crate::model::DetectedMetricSetConfig>,
    }
    impl Builder {
        /// <p>The inferred dataset configuration for the datasource.</p>
        pub fn detected_metric_set_config(
            mut self,
            input: crate::model::DetectedMetricSetConfig,
        ) -> Self {
            self.detected_metric_set_config = Some(input);
            self
        }
        /// <p>The inferred dataset configuration for the datasource.</p>
        pub fn set_detected_metric_set_config(
            mut self,
            input: std::option::Option<crate::model::DetectedMetricSetConfig>,
        ) -> Self {
            self.detected_metric_set_config = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectMetricSetConfigOutput`](crate::output::DetectMetricSetConfigOutput)
        pub fn build(self) -> crate::output::DetectMetricSetConfigOutput {
            crate::output::DetectMetricSetConfigOutput {
                detected_metric_set_config: self.detected_metric_set_config,
            }
        }
    }
}
impl DetectMetricSetConfigOutput {
    /// Creates a new builder-style object to manufacture [`DetectMetricSetConfigOutput`](crate::output::DetectMetricSetConfigOutput)
    pub fn builder() -> crate::output::detect_metric_set_config_output::Builder {
        crate::output::detect_metric_set_config_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMetricSetOutput {
    /// <p>The ARN of the dataset.</p>
    pub metric_set_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the detector that contains the dataset.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
    /// <p>The name of the dataset.</p>
    pub metric_set_name: std::option::Option<std::string::String>,
    /// <p>The dataset's description.</p>
    pub metric_set_description: std::option::Option<std::string::String>,
    /// <p>The time at which the dataset was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the dataset was last modified.</p>
    pub last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The offset in seconds. Only supported for S3 and Redshift datasources.</p>
    pub offset: std::option::Option<i32>,
    /// <p>A list of the metrics defined by the dataset.</p>
    pub metric_list: std::option::Option<std::vec::Vec<crate::model::Metric>>,
    /// <p>Contains information about the column used for tracking time in your source data.</p>
    pub timestamp_column: std::option::Option<crate::model::TimestampColumn>,
    /// <p>A list of the dimensions chosen for analysis.</p>
    pub dimension_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The interval at which the data will be analyzed for anomalies.</p>
    pub metric_set_frequency: std::option::Option<crate::model::Frequency>,
    /// <p>The time zone in which the dataset's data was recorded.</p>
    pub timezone: std::option::Option<std::string::String>,
    /// <p>Contains information about the dataset's source data.</p>
    pub metric_source: std::option::Option<crate::model::MetricSource>,
}
impl DescribeMetricSetOutput {
    /// <p>The ARN of the dataset.</p>
    pub fn metric_set_arn(&self) -> std::option::Option<&str> {
        self.metric_set_arn.as_deref()
    }
    /// <p>The ARN of the detector that contains the dataset.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
    /// <p>The name of the dataset.</p>
    pub fn metric_set_name(&self) -> std::option::Option<&str> {
        self.metric_set_name.as_deref()
    }
    /// <p>The dataset's description.</p>
    pub fn metric_set_description(&self) -> std::option::Option<&str> {
        self.metric_set_description.as_deref()
    }
    /// <p>The time at which the dataset was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The time at which the dataset was last modified.</p>
    pub fn last_modification_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modification_time.as_ref()
    }
    /// <p>The offset in seconds. Only supported for S3 and Redshift datasources.</p>
    pub fn offset(&self) -> std::option::Option<i32> {
        self.offset
    }
    /// <p>A list of the metrics defined by the dataset.</p>
    pub fn metric_list(&self) -> std::option::Option<&[crate::model::Metric]> {
        self.metric_list.as_deref()
    }
    /// <p>Contains information about the column used for tracking time in your source data.</p>
    pub fn timestamp_column(&self) -> std::option::Option<&crate::model::TimestampColumn> {
        self.timestamp_column.as_ref()
    }
    /// <p>A list of the dimensions chosen for analysis.</p>
    pub fn dimension_list(&self) -> std::option::Option<&[std::string::String]> {
        self.dimension_list.as_deref()
    }
    /// <p>The interval at which the data will be analyzed for anomalies.</p>
    pub fn metric_set_frequency(&self) -> std::option::Option<&crate::model::Frequency> {
        self.metric_set_frequency.as_ref()
    }
    /// <p>The time zone in which the dataset's data was recorded.</p>
    pub fn timezone(&self) -> std::option::Option<&str> {
        self.timezone.as_deref()
    }
    /// <p>Contains information about the dataset's source data.</p>
    pub fn metric_source(&self) -> std::option::Option<&crate::model::MetricSource> {
        self.metric_source.as_ref()
    }
}
impl std::fmt::Debug for DescribeMetricSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMetricSetOutput");
        formatter.field("metric_set_arn", &self.metric_set_arn);
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.field("metric_set_name", &self.metric_set_name);
        formatter.field("metric_set_description", &self.metric_set_description);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modification_time", &self.last_modification_time);
        formatter.field("offset", &self.offset);
        formatter.field("metric_list", &self.metric_list);
        formatter.field("timestamp_column", &self.timestamp_column);
        formatter.field("dimension_list", &self.dimension_list);
        formatter.field("metric_set_frequency", &self.metric_set_frequency);
        formatter.field("timezone", &self.timezone);
        formatter.field("metric_source", &self.metric_source);
        formatter.finish()
    }
}
/// See [`DescribeMetricSetOutput`](crate::output::DescribeMetricSetOutput)
pub mod describe_metric_set_output {
    /// A builder for [`DescribeMetricSetOutput`](crate::output::DescribeMetricSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_set_arn: std::option::Option<std::string::String>,
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
        pub(crate) metric_set_name: std::option::Option<std::string::String>,
        pub(crate) metric_set_description: std::option::Option<std::string::String>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) offset: std::option::Option<i32>,
        pub(crate) metric_list: std::option::Option<std::vec::Vec<crate::model::Metric>>,
        pub(crate) timestamp_column: std::option::Option<crate::model::TimestampColumn>,
        pub(crate) dimension_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) metric_set_frequency: std::option::Option<crate::model::Frequency>,
        pub(crate) timezone: std::option::Option<std::string::String>,
        pub(crate) metric_source: std::option::Option<crate::model::MetricSource>,
    }
    impl Builder {
        /// <p>The ARN of the dataset.</p>
        pub fn metric_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the dataset.</p>
        pub fn set_metric_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_set_arn = input;
            self
        }
        /// <p>The ARN of the detector that contains the dataset.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the detector that contains the dataset.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// <p>The name of the dataset.</p>
        pub fn metric_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_set_name = Some(input.into());
            self
        }
        /// <p>The name of the dataset.</p>
        pub fn set_metric_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_set_name = input;
            self
        }
        /// <p>The dataset's description.</p>
        pub fn metric_set_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_set_description = Some(input.into());
            self
        }
        /// <p>The dataset's description.</p>
        pub fn set_metric_set_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_set_description = input;
            self
        }
        /// <p>The time at which the dataset was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time at which the dataset was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time at which the dataset was last modified.</p>
        pub fn last_modification_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modification_time = Some(input);
            self
        }
        /// <p>The time at which the dataset was last modified.</p>
        pub fn set_last_modification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modification_time = input;
            self
        }
        /// <p>The offset in seconds. Only supported for S3 and Redshift datasources.</p>
        pub fn offset(mut self, input: i32) -> Self {
            self.offset = Some(input);
            self
        }
        /// <p>The offset in seconds. Only supported for S3 and Redshift datasources.</p>
        pub fn set_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.offset = input;
            self
        }
        /// Appends an item to `metric_list`.
        ///
        /// To override the contents of this collection use [`set_metric_list`](Self::set_metric_list).
        ///
        /// <p>A list of the metrics defined by the dataset.</p>
        pub fn metric_list(mut self, input: crate::model::Metric) -> Self {
            let mut v = self.metric_list.unwrap_or_default();
            v.push(input);
            self.metric_list = Some(v);
            self
        }
        /// <p>A list of the metrics defined by the dataset.</p>
        pub fn set_metric_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Metric>>,
        ) -> Self {
            self.metric_list = input;
            self
        }
        /// <p>Contains information about the column used for tracking time in your source data.</p>
        pub fn timestamp_column(mut self, input: crate::model::TimestampColumn) -> Self {
            self.timestamp_column = Some(input);
            self
        }
        /// <p>Contains information about the column used for tracking time in your source data.</p>
        pub fn set_timestamp_column(
            mut self,
            input: std::option::Option<crate::model::TimestampColumn>,
        ) -> Self {
            self.timestamp_column = input;
            self
        }
        /// Appends an item to `dimension_list`.
        ///
        /// To override the contents of this collection use [`set_dimension_list`](Self::set_dimension_list).
        ///
        /// <p>A list of the dimensions chosen for analysis.</p>
        pub fn dimension_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dimension_list.unwrap_or_default();
            v.push(input.into());
            self.dimension_list = Some(v);
            self
        }
        /// <p>A list of the dimensions chosen for analysis.</p>
        pub fn set_dimension_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dimension_list = input;
            self
        }
        /// <p>The interval at which the data will be analyzed for anomalies.</p>
        pub fn metric_set_frequency(mut self, input: crate::model::Frequency) -> Self {
            self.metric_set_frequency = Some(input);
            self
        }
        /// <p>The interval at which the data will be analyzed for anomalies.</p>
        pub fn set_metric_set_frequency(
            mut self,
            input: std::option::Option<crate::model::Frequency>,
        ) -> Self {
            self.metric_set_frequency = input;
            self
        }
        /// <p>The time zone in which the dataset's data was recorded.</p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone = Some(input.into());
            self
        }
        /// <p>The time zone in which the dataset's data was recorded.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timezone = input;
            self
        }
        /// <p>Contains information about the dataset's source data.</p>
        pub fn metric_source(mut self, input: crate::model::MetricSource) -> Self {
            self.metric_source = Some(input);
            self
        }
        /// <p>Contains information about the dataset's source data.</p>
        pub fn set_metric_source(
            mut self,
            input: std::option::Option<crate::model::MetricSource>,
        ) -> Self {
            self.metric_source = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMetricSetOutput`](crate::output::DescribeMetricSetOutput)
        pub fn build(self) -> crate::output::DescribeMetricSetOutput {
            crate::output::DescribeMetricSetOutput {
                metric_set_arn: self.metric_set_arn,
                anomaly_detector_arn: self.anomaly_detector_arn,
                metric_set_name: self.metric_set_name,
                metric_set_description: self.metric_set_description,
                creation_time: self.creation_time,
                last_modification_time: self.last_modification_time,
                offset: self.offset,
                metric_list: self.metric_list,
                timestamp_column: self.timestamp_column,
                dimension_list: self.dimension_list,
                metric_set_frequency: self.metric_set_frequency,
                timezone: self.timezone,
                metric_source: self.metric_source,
            }
        }
    }
}
impl DescribeMetricSetOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMetricSetOutput`](crate::output::DescribeMetricSetOutput)
    pub fn builder() -> crate::output::describe_metric_set_output::Builder {
        crate::output::describe_metric_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAnomalyDetectorOutput {
    /// <p>The ARN of the detector.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
    /// <p>The name of the detector.</p>
    pub anomaly_detector_name: std::option::Option<std::string::String>,
    /// <p>A description of the detector.</p>
    pub anomaly_detector_description: std::option::Option<std::string::String>,
    /// <p>Contains information about the detector's configuration.</p>
    pub anomaly_detector_config: std::option::Option<crate::model::AnomalyDetectorConfigSummary>,
    /// <p>The time at which the detector was created.</p>
    pub creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time at which the detector was last modified.</p>
    pub last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the detector.</p>
    pub status: std::option::Option<crate::model::AnomalyDetectorStatus>,
    /// <p>The reason that the detector failed.</p>
    pub failure_reason: std::option::Option<std::string::String>,
    /// <p>The ARN of the KMS key to use to encrypt your data.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
    /// <p>The process that caused the detector to fail.</p>
    pub failure_type: std::option::Option<crate::model::AnomalyDetectorFailureType>,
}
impl DescribeAnomalyDetectorOutput {
    /// <p>The ARN of the detector.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
    /// <p>The name of the detector.</p>
    pub fn anomaly_detector_name(&self) -> std::option::Option<&str> {
        self.anomaly_detector_name.as_deref()
    }
    /// <p>A description of the detector.</p>
    pub fn anomaly_detector_description(&self) -> std::option::Option<&str> {
        self.anomaly_detector_description.as_deref()
    }
    /// <p>Contains information about the detector's configuration.</p>
    pub fn anomaly_detector_config(
        &self,
    ) -> std::option::Option<&crate::model::AnomalyDetectorConfigSummary> {
        self.anomaly_detector_config.as_ref()
    }
    /// <p>The time at which the detector was created.</p>
    pub fn creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_time.as_ref()
    }
    /// <p>The time at which the detector was last modified.</p>
    pub fn last_modification_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modification_time.as_ref()
    }
    /// <p>The status of the detector.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AnomalyDetectorStatus> {
        self.status.as_ref()
    }
    /// <p>The reason that the detector failed.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
    /// <p>The ARN of the KMS key to use to encrypt your data.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
    /// <p>The process that caused the detector to fail.</p>
    pub fn failure_type(&self) -> std::option::Option<&crate::model::AnomalyDetectorFailureType> {
        self.failure_type.as_ref()
    }
}
impl std::fmt::Debug for DescribeAnomalyDetectorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAnomalyDetectorOutput");
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.field("anomaly_detector_name", &self.anomaly_detector_name);
        formatter.field(
            "anomaly_detector_description",
            &self.anomaly_detector_description,
        );
        formatter.field("anomaly_detector_config", &self.anomaly_detector_config);
        formatter.field("creation_time", &self.creation_time);
        formatter.field("last_modification_time", &self.last_modification_time);
        formatter.field("status", &self.status);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.field("failure_type", &self.failure_type);
        formatter.finish()
    }
}
/// See [`DescribeAnomalyDetectorOutput`](crate::output::DescribeAnomalyDetectorOutput)
pub mod describe_anomaly_detector_output {
    /// A builder for [`DescribeAnomalyDetectorOutput`](crate::output::DescribeAnomalyDetectorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
        pub(crate) anomaly_detector_name: std::option::Option<std::string::String>,
        pub(crate) anomaly_detector_description: std::option::Option<std::string::String>,
        pub(crate) anomaly_detector_config:
            std::option::Option<crate::model::AnomalyDetectorConfigSummary>,
        pub(crate) creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_modification_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<crate::model::AnomalyDetectorStatus>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) failure_type: std::option::Option<crate::model::AnomalyDetectorFailureType>,
    }
    impl Builder {
        /// <p>The ARN of the detector.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// <p>The name of the detector.</p>
        pub fn anomaly_detector_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_name = Some(input.into());
            self
        }
        /// <p>The name of the detector.</p>
        pub fn set_anomaly_detector_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_name = input;
            self
        }
        /// <p>A description of the detector.</p>
        pub fn anomaly_detector_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.anomaly_detector_description = Some(input.into());
            self
        }
        /// <p>A description of the detector.</p>
        pub fn set_anomaly_detector_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_description = input;
            self
        }
        /// <p>Contains information about the detector's configuration.</p>
        pub fn anomaly_detector_config(
            mut self,
            input: crate::model::AnomalyDetectorConfigSummary,
        ) -> Self {
            self.anomaly_detector_config = Some(input);
            self
        }
        /// <p>Contains information about the detector's configuration.</p>
        pub fn set_anomaly_detector_config(
            mut self,
            input: std::option::Option<crate::model::AnomalyDetectorConfigSummary>,
        ) -> Self {
            self.anomaly_detector_config = input;
            self
        }
        /// <p>The time at which the detector was created.</p>
        pub fn creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_time = Some(input);
            self
        }
        /// <p>The time at which the detector was created.</p>
        pub fn set_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_time = input;
            self
        }
        /// <p>The time at which the detector was last modified.</p>
        pub fn last_modification_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modification_time = Some(input);
            self
        }
        /// <p>The time at which the detector was last modified.</p>
        pub fn set_last_modification_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modification_time = input;
            self
        }
        /// <p>The status of the detector.</p>
        pub fn status(mut self, input: crate::model::AnomalyDetectorStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the detector.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AnomalyDetectorStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The reason that the detector failed.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The reason that the detector failed.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The ARN of the KMS key to use to encrypt your data.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the KMS key to use to encrypt your data.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// <p>The process that caused the detector to fail.</p>
        pub fn failure_type(mut self, input: crate::model::AnomalyDetectorFailureType) -> Self {
            self.failure_type = Some(input);
            self
        }
        /// <p>The process that caused the detector to fail.</p>
        pub fn set_failure_type(
            mut self,
            input: std::option::Option<crate::model::AnomalyDetectorFailureType>,
        ) -> Self {
            self.failure_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAnomalyDetectorOutput`](crate::output::DescribeAnomalyDetectorOutput)
        pub fn build(self) -> crate::output::DescribeAnomalyDetectorOutput {
            crate::output::DescribeAnomalyDetectorOutput {
                anomaly_detector_arn: self.anomaly_detector_arn,
                anomaly_detector_name: self.anomaly_detector_name,
                anomaly_detector_description: self.anomaly_detector_description,
                anomaly_detector_config: self.anomaly_detector_config,
                creation_time: self.creation_time,
                last_modification_time: self.last_modification_time,
                status: self.status,
                failure_reason: self.failure_reason,
                kms_key_arn: self.kms_key_arn,
                failure_type: self.failure_type,
            }
        }
    }
}
impl DescribeAnomalyDetectorOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAnomalyDetectorOutput`](crate::output::DescribeAnomalyDetectorOutput)
    pub fn builder() -> crate::output::describe_anomaly_detector_output::Builder {
        crate::output::describe_anomaly_detector_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAnomalyDetectionExecutionsOutput {
    /// <p>A list of detection jobs.</p>
    pub execution_list: std::option::Option<std::vec::Vec<crate::model::ExecutionStatus>>,
    /// <p>The pagination token that's included if more results are available.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeAnomalyDetectionExecutionsOutput {
    /// <p>A list of detection jobs.</p>
    pub fn execution_list(&self) -> std::option::Option<&[crate::model::ExecutionStatus]> {
        self.execution_list.as_deref()
    }
    /// <p>The pagination token that's included if more results are available.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeAnomalyDetectionExecutionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAnomalyDetectionExecutionsOutput");
        formatter.field("execution_list", &self.execution_list);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeAnomalyDetectionExecutionsOutput`](crate::output::DescribeAnomalyDetectionExecutionsOutput)
pub mod describe_anomaly_detection_executions_output {
    /// A builder for [`DescribeAnomalyDetectionExecutionsOutput`](crate::output::DescribeAnomalyDetectionExecutionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) execution_list:
            std::option::Option<std::vec::Vec<crate::model::ExecutionStatus>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `execution_list`.
        ///
        /// To override the contents of this collection use [`set_execution_list`](Self::set_execution_list).
        ///
        /// <p>A list of detection jobs.</p>
        pub fn execution_list(mut self, input: crate::model::ExecutionStatus) -> Self {
            let mut v = self.execution_list.unwrap_or_default();
            v.push(input);
            self.execution_list = Some(v);
            self
        }
        /// <p>A list of detection jobs.</p>
        pub fn set_execution_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExecutionStatus>>,
        ) -> Self {
            self.execution_list = input;
            self
        }
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token that's included if more results are available.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAnomalyDetectionExecutionsOutput`](crate::output::DescribeAnomalyDetectionExecutionsOutput)
        pub fn build(self) -> crate::output::DescribeAnomalyDetectionExecutionsOutput {
            crate::output::DescribeAnomalyDetectionExecutionsOutput {
                execution_list: self.execution_list,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeAnomalyDetectionExecutionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAnomalyDetectionExecutionsOutput`](crate::output::DescribeAnomalyDetectionExecutionsOutput)
    pub fn builder() -> crate::output::describe_anomaly_detection_executions_output::Builder {
        crate::output::describe_anomaly_detection_executions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAlertOutput {
    /// <p>Contains information about an alert.</p>
    pub alert: std::option::Option<crate::model::Alert>,
}
impl DescribeAlertOutput {
    /// <p>Contains information about an alert.</p>
    pub fn alert(&self) -> std::option::Option<&crate::model::Alert> {
        self.alert.as_ref()
    }
}
impl std::fmt::Debug for DescribeAlertOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAlertOutput");
        formatter.field("alert", &self.alert);
        formatter.finish()
    }
}
/// See [`DescribeAlertOutput`](crate::output::DescribeAlertOutput)
pub mod describe_alert_output {
    /// A builder for [`DescribeAlertOutput`](crate::output::DescribeAlertOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alert: std::option::Option<crate::model::Alert>,
    }
    impl Builder {
        /// <p>Contains information about an alert.</p>
        pub fn alert(mut self, input: crate::model::Alert) -> Self {
            self.alert = Some(input);
            self
        }
        /// <p>Contains information about an alert.</p>
        pub fn set_alert(mut self, input: std::option::Option<crate::model::Alert>) -> Self {
            self.alert = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAlertOutput`](crate::output::DescribeAlertOutput)
        pub fn build(self) -> crate::output::DescribeAlertOutput {
            crate::output::DescribeAlertOutput { alert: self.alert }
        }
    }
}
impl DescribeAlertOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAlertOutput`](crate::output::DescribeAlertOutput)
    pub fn builder() -> crate::output::describe_alert_output::Builder {
        crate::output::describe_alert_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAnomalyDetectorOutput {}
impl std::fmt::Debug for DeleteAnomalyDetectorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAnomalyDetectorOutput");
        formatter.finish()
    }
}
/// See [`DeleteAnomalyDetectorOutput`](crate::output::DeleteAnomalyDetectorOutput)
pub mod delete_anomaly_detector_output {
    /// A builder for [`DeleteAnomalyDetectorOutput`](crate::output::DeleteAnomalyDetectorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAnomalyDetectorOutput`](crate::output::DeleteAnomalyDetectorOutput)
        pub fn build(self) -> crate::output::DeleteAnomalyDetectorOutput {
            crate::output::DeleteAnomalyDetectorOutput {}
        }
    }
}
impl DeleteAnomalyDetectorOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAnomalyDetectorOutput`](crate::output::DeleteAnomalyDetectorOutput)
    pub fn builder() -> crate::output::delete_anomaly_detector_output::Builder {
        crate::output::delete_anomaly_detector_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAlertOutput {}
impl std::fmt::Debug for DeleteAlertOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAlertOutput");
        formatter.finish()
    }
}
/// See [`DeleteAlertOutput`](crate::output::DeleteAlertOutput)
pub mod delete_alert_output {
    /// A builder for [`DeleteAlertOutput`](crate::output::DeleteAlertOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAlertOutput`](crate::output::DeleteAlertOutput)
        pub fn build(self) -> crate::output::DeleteAlertOutput {
            crate::output::DeleteAlertOutput {}
        }
    }
}
impl DeleteAlertOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAlertOutput`](crate::output::DeleteAlertOutput)
    pub fn builder() -> crate::output::delete_alert_output::Builder {
        crate::output::delete_alert_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeactivateAnomalyDetectorOutput {}
impl std::fmt::Debug for DeactivateAnomalyDetectorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeactivateAnomalyDetectorOutput");
        formatter.finish()
    }
}
/// See [`DeactivateAnomalyDetectorOutput`](crate::output::DeactivateAnomalyDetectorOutput)
pub mod deactivate_anomaly_detector_output {
    /// A builder for [`DeactivateAnomalyDetectorOutput`](crate::output::DeactivateAnomalyDetectorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeactivateAnomalyDetectorOutput`](crate::output::DeactivateAnomalyDetectorOutput)
        pub fn build(self) -> crate::output::DeactivateAnomalyDetectorOutput {
            crate::output::DeactivateAnomalyDetectorOutput {}
        }
    }
}
impl DeactivateAnomalyDetectorOutput {
    /// Creates a new builder-style object to manufacture [`DeactivateAnomalyDetectorOutput`](crate::output::DeactivateAnomalyDetectorOutput)
    pub fn builder() -> crate::output::deactivate_anomaly_detector_output::Builder {
        crate::output::deactivate_anomaly_detector_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMetricSetOutput {
    /// <p>The ARN of the dataset.</p>
    pub metric_set_arn: std::option::Option<std::string::String>,
}
impl CreateMetricSetOutput {
    /// <p>The ARN of the dataset.</p>
    pub fn metric_set_arn(&self) -> std::option::Option<&str> {
        self.metric_set_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateMetricSetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMetricSetOutput");
        formatter.field("metric_set_arn", &self.metric_set_arn);
        formatter.finish()
    }
}
/// See [`CreateMetricSetOutput`](crate::output::CreateMetricSetOutput)
pub mod create_metric_set_output {
    /// A builder for [`CreateMetricSetOutput`](crate::output::CreateMetricSetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metric_set_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the dataset.</p>
        pub fn metric_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.metric_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the dataset.</p>
        pub fn set_metric_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.metric_set_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMetricSetOutput`](crate::output::CreateMetricSetOutput)
        pub fn build(self) -> crate::output::CreateMetricSetOutput {
            crate::output::CreateMetricSetOutput {
                metric_set_arn: self.metric_set_arn,
            }
        }
    }
}
impl CreateMetricSetOutput {
    /// Creates a new builder-style object to manufacture [`CreateMetricSetOutput`](crate::output::CreateMetricSetOutput)
    pub fn builder() -> crate::output::create_metric_set_output::Builder {
        crate::output::create_metric_set_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAnomalyDetectorOutput {
    /// <p>The ARN of the detector.</p>
    pub anomaly_detector_arn: std::option::Option<std::string::String>,
}
impl CreateAnomalyDetectorOutput {
    /// <p>The ARN of the detector.</p>
    pub fn anomaly_detector_arn(&self) -> std::option::Option<&str> {
        self.anomaly_detector_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateAnomalyDetectorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAnomalyDetectorOutput");
        formatter.field("anomaly_detector_arn", &self.anomaly_detector_arn);
        formatter.finish()
    }
}
/// See [`CreateAnomalyDetectorOutput`](crate::output::CreateAnomalyDetectorOutput)
pub mod create_anomaly_detector_output {
    /// A builder for [`CreateAnomalyDetectorOutput`](crate::output::CreateAnomalyDetectorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_detector_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the detector.</p>
        pub fn anomaly_detector_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_detector_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_detector_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAnomalyDetectorOutput`](crate::output::CreateAnomalyDetectorOutput)
        pub fn build(self) -> crate::output::CreateAnomalyDetectorOutput {
            crate::output::CreateAnomalyDetectorOutput {
                anomaly_detector_arn: self.anomaly_detector_arn,
            }
        }
    }
}
impl CreateAnomalyDetectorOutput {
    /// Creates a new builder-style object to manufacture [`CreateAnomalyDetectorOutput`](crate::output::CreateAnomalyDetectorOutput)
    pub fn builder() -> crate::output::create_anomaly_detector_output::Builder {
        crate::output::create_anomaly_detector_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAlertOutput {
    /// <p>The ARN of the alert.</p>
    pub alert_arn: std::option::Option<std::string::String>,
}
impl CreateAlertOutput {
    /// <p>The ARN of the alert.</p>
    pub fn alert_arn(&self) -> std::option::Option<&str> {
        self.alert_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateAlertOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAlertOutput");
        formatter.field("alert_arn", &self.alert_arn);
        formatter.finish()
    }
}
/// See [`CreateAlertOutput`](crate::output::CreateAlertOutput)
pub mod create_alert_output {
    /// A builder for [`CreateAlertOutput`](crate::output::CreateAlertOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alert_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the alert.</p>
        pub fn alert_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.alert_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the alert.</p>
        pub fn set_alert_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alert_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAlertOutput`](crate::output::CreateAlertOutput)
        pub fn build(self) -> crate::output::CreateAlertOutput {
            crate::output::CreateAlertOutput {
                alert_arn: self.alert_arn,
            }
        }
    }
}
impl CreateAlertOutput {
    /// Creates a new builder-style object to manufacture [`CreateAlertOutput`](crate::output::CreateAlertOutput)
    pub fn builder() -> crate::output::create_alert_output::Builder {
        crate::output::create_alert_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackTestAnomalyDetectorOutput {}
impl std::fmt::Debug for BackTestAnomalyDetectorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackTestAnomalyDetectorOutput");
        formatter.finish()
    }
}
/// See [`BackTestAnomalyDetectorOutput`](crate::output::BackTestAnomalyDetectorOutput)
pub mod back_test_anomaly_detector_output {
    /// A builder for [`BackTestAnomalyDetectorOutput`](crate::output::BackTestAnomalyDetectorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`BackTestAnomalyDetectorOutput`](crate::output::BackTestAnomalyDetectorOutput)
        pub fn build(self) -> crate::output::BackTestAnomalyDetectorOutput {
            crate::output::BackTestAnomalyDetectorOutput {}
        }
    }
}
impl BackTestAnomalyDetectorOutput {
    /// Creates a new builder-style object to manufacture [`BackTestAnomalyDetectorOutput`](crate::output::BackTestAnomalyDetectorOutput)
    pub fn builder() -> crate::output::back_test_anomaly_detector_output::Builder {
        crate::output::back_test_anomaly_detector_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ActivateAnomalyDetectorOutput {}
impl std::fmt::Debug for ActivateAnomalyDetectorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ActivateAnomalyDetectorOutput");
        formatter.finish()
    }
}
/// See [`ActivateAnomalyDetectorOutput`](crate::output::ActivateAnomalyDetectorOutput)
pub mod activate_anomaly_detector_output {
    /// A builder for [`ActivateAnomalyDetectorOutput`](crate::output::ActivateAnomalyDetectorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ActivateAnomalyDetectorOutput`](crate::output::ActivateAnomalyDetectorOutput)
        pub fn build(self) -> crate::output::ActivateAnomalyDetectorOutput {
            crate::output::ActivateAnomalyDetectorOutput {}
        }
    }
}
impl ActivateAnomalyDetectorOutput {
    /// Creates a new builder-style object to manufacture [`ActivateAnomalyDetectorOutput`](crate::output::ActivateAnomalyDetectorOutput)
    pub fn builder() -> crate::output::activate_anomaly_detector_output::Builder {
        crate::output::activate_anomaly_detector_output::Builder::default()
    }
}
