// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `LookoutMetrics`.
///
/// This client allows ergonomic access to a `LookoutMetrics`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `ActivateAnomalyDetector` operation.
    ///
    /// See [`ActivateAnomalyDetector`](crate::client::fluent_builders::ActivateAnomalyDetector) for more information about the
    /// operation and its arguments.
    pub fn activate_anomaly_detector(&self) -> fluent_builders::ActivateAnomalyDetector<C, M, R> {
        fluent_builders::ActivateAnomalyDetector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BackTestAnomalyDetector` operation.
    ///
    /// See [`BackTestAnomalyDetector`](crate::client::fluent_builders::BackTestAnomalyDetector) for more information about the
    /// operation and its arguments.
    pub fn back_test_anomaly_detector(&self) -> fluent_builders::BackTestAnomalyDetector<C, M, R> {
        fluent_builders::BackTestAnomalyDetector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAlert` operation.
    ///
    /// See [`CreateAlert`](crate::client::fluent_builders::CreateAlert) for more information about the
    /// operation and its arguments.
    pub fn create_alert(&self) -> fluent_builders::CreateAlert<C, M, R> {
        fluent_builders::CreateAlert::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAnomalyDetector` operation.
    ///
    /// See [`CreateAnomalyDetector`](crate::client::fluent_builders::CreateAnomalyDetector) for more information about the
    /// operation and its arguments.
    pub fn create_anomaly_detector(&self) -> fluent_builders::CreateAnomalyDetector<C, M, R> {
        fluent_builders::CreateAnomalyDetector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMetricSet` operation.
    ///
    /// See [`CreateMetricSet`](crate::client::fluent_builders::CreateMetricSet) for more information about the
    /// operation and its arguments.
    pub fn create_metric_set(&self) -> fluent_builders::CreateMetricSet<C, M, R> {
        fluent_builders::CreateMetricSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAlert` operation.
    ///
    /// See [`DeleteAlert`](crate::client::fluent_builders::DeleteAlert) for more information about the
    /// operation and its arguments.
    pub fn delete_alert(&self) -> fluent_builders::DeleteAlert<C, M, R> {
        fluent_builders::DeleteAlert::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAnomalyDetector` operation.
    ///
    /// See [`DeleteAnomalyDetector`](crate::client::fluent_builders::DeleteAnomalyDetector) for more information about the
    /// operation and its arguments.
    pub fn delete_anomaly_detector(&self) -> fluent_builders::DeleteAnomalyDetector<C, M, R> {
        fluent_builders::DeleteAnomalyDetector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAlert` operation.
    ///
    /// See [`DescribeAlert`](crate::client::fluent_builders::DescribeAlert) for more information about the
    /// operation and its arguments.
    pub fn describe_alert(&self) -> fluent_builders::DescribeAlert<C, M, R> {
        fluent_builders::DescribeAlert::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAnomalyDetectionExecutions` operation.
    ///
    /// See [`DescribeAnomalyDetectionExecutions`](crate::client::fluent_builders::DescribeAnomalyDetectionExecutions) for more information about the
    /// operation and its arguments.
    pub fn describe_anomaly_detection_executions(
        &self,
    ) -> fluent_builders::DescribeAnomalyDetectionExecutions<C, M, R> {
        fluent_builders::DescribeAnomalyDetectionExecutions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAnomalyDetector` operation.
    ///
    /// See [`DescribeAnomalyDetector`](crate::client::fluent_builders::DescribeAnomalyDetector) for more information about the
    /// operation and its arguments.
    pub fn describe_anomaly_detector(&self) -> fluent_builders::DescribeAnomalyDetector<C, M, R> {
        fluent_builders::DescribeAnomalyDetector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMetricSet` operation.
    ///
    /// See [`DescribeMetricSet`](crate::client::fluent_builders::DescribeMetricSet) for more information about the
    /// operation and its arguments.
    pub fn describe_metric_set(&self) -> fluent_builders::DescribeMetricSet<C, M, R> {
        fluent_builders::DescribeMetricSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAnomalyGroup` operation.
    ///
    /// See [`GetAnomalyGroup`](crate::client::fluent_builders::GetAnomalyGroup) for more information about the
    /// operation and its arguments.
    pub fn get_anomaly_group(&self) -> fluent_builders::GetAnomalyGroup<C, M, R> {
        fluent_builders::GetAnomalyGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFeedback` operation.
    ///
    /// See [`GetFeedback`](crate::client::fluent_builders::GetFeedback) for more information about the
    /// operation and its arguments.
    pub fn get_feedback(&self) -> fluent_builders::GetFeedback<C, M, R> {
        fluent_builders::GetFeedback::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetSampleData` operation.
    ///
    /// See [`GetSampleData`](crate::client::fluent_builders::GetSampleData) for more information about the
    /// operation and its arguments.
    pub fn get_sample_data(&self) -> fluent_builders::GetSampleData<C, M, R> {
        fluent_builders::GetSampleData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAlerts` operation.
    ///
    /// See [`ListAlerts`](crate::client::fluent_builders::ListAlerts) for more information about the
    /// operation and its arguments.
    pub fn list_alerts(&self) -> fluent_builders::ListAlerts<C, M, R> {
        fluent_builders::ListAlerts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAnomalyDetectors` operation.
    ///
    /// See [`ListAnomalyDetectors`](crate::client::fluent_builders::ListAnomalyDetectors) for more information about the
    /// operation and its arguments.
    pub fn list_anomaly_detectors(&self) -> fluent_builders::ListAnomalyDetectors<C, M, R> {
        fluent_builders::ListAnomalyDetectors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAnomalyGroupSummaries` operation.
    ///
    /// See [`ListAnomalyGroupSummaries`](crate::client::fluent_builders::ListAnomalyGroupSummaries) for more information about the
    /// operation and its arguments.
    pub fn list_anomaly_group_summaries(
        &self,
    ) -> fluent_builders::ListAnomalyGroupSummaries<C, M, R> {
        fluent_builders::ListAnomalyGroupSummaries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAnomalyGroupTimeSeries` operation.
    ///
    /// See [`ListAnomalyGroupTimeSeries`](crate::client::fluent_builders::ListAnomalyGroupTimeSeries) for more information about the
    /// operation and its arguments.
    pub fn list_anomaly_group_time_series(
        &self,
    ) -> fluent_builders::ListAnomalyGroupTimeSeries<C, M, R> {
        fluent_builders::ListAnomalyGroupTimeSeries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMetricSets` operation.
    ///
    /// See [`ListMetricSets`](crate::client::fluent_builders::ListMetricSets) for more information about the
    /// operation and its arguments.
    pub fn list_metric_sets(&self) -> fluent_builders::ListMetricSets<C, M, R> {
        fluent_builders::ListMetricSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutFeedback` operation.
    ///
    /// See [`PutFeedback`](crate::client::fluent_builders::PutFeedback) for more information about the
    /// operation and its arguments.
    pub fn put_feedback(&self) -> fluent_builders::PutFeedback<C, M, R> {
        fluent_builders::PutFeedback::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAnomalyDetector` operation.
    ///
    /// See [`UpdateAnomalyDetector`](crate::client::fluent_builders::UpdateAnomalyDetector) for more information about the
    /// operation and its arguments.
    pub fn update_anomaly_detector(&self) -> fluent_builders::UpdateAnomalyDetector<C, M, R> {
        fluent_builders::UpdateAnomalyDetector::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateMetricSet` operation.
    ///
    /// See [`UpdateMetricSet`](crate::client::fluent_builders::UpdateMetricSet) for more information about the
    /// operation and its arguments.
    pub fn update_metric_set(&self) -> fluent_builders::UpdateMetricSet<C, M, R> {
        fluent_builders::UpdateMetricSet::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `ActivateAnomalyDetector`.
    ///
    /// <p>Activates an anomaly detector.</p>
    #[derive(std::fmt::Debug)]
    pub struct ActivateAnomalyDetector<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::activate_anomaly_detector_input::Builder,
    }
    impl<C, M, R> ActivateAnomalyDetector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ActivateAnomalyDetector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ActivateAnomalyDetectorOutput,
            aws_smithy_http::result::SdkError<crate::error::ActivateAnomalyDetectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ActivateAnomalyDetectorInputOperationOutputAlias,
                crate::output::ActivateAnomalyDetectorOutput,
                crate::error::ActivateAnomalyDetectorError,
                crate::input::ActivateAnomalyDetectorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the anomaly detector.</p>
        pub fn anomaly_detector_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_detector_arn(inp);
            self
        }
        /// <p>The ARN of the anomaly detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_detector_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BackTestAnomalyDetector`.
    ///
    /// <p>Runs a backtest for anomaly detection for the specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct BackTestAnomalyDetector<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::back_test_anomaly_detector_input::Builder,
    }
    impl<C, M, R> BackTestAnomalyDetector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BackTestAnomalyDetector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BackTestAnomalyDetectorOutput,
            aws_smithy_http::result::SdkError<crate::error::BackTestAnomalyDetectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BackTestAnomalyDetectorInputOperationOutputAlias,
                crate::output::BackTestAnomalyDetectorOutput,
                crate::error::BackTestAnomalyDetectorError,
                crate::input::BackTestAnomalyDetectorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn anomaly_detector_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_detector_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_detector_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAlert`.
    ///
    /// <p>Creates an alert for an anomaly detector.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAlert<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_alert_input::Builder,
    }
    impl<C, M, R> CreateAlert<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAlert`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAlertOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAlertError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAlertInputOperationOutputAlias,
                crate::output::CreateAlertOutput,
                crate::error::CreateAlertError,
                crate::input::CreateAlertInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the alert.</p>
        pub fn alert_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alert_name(inp);
            self
        }
        /// <p>The name of the alert.</p>
        pub fn set_alert_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alert_name(input);
            self
        }
        /// <p>An integer from 0 to 100 specifying the alert sensitivity threshold.</p>
        pub fn alert_sensitivity_threshold(mut self, inp: i32) -> Self {
            self.inner = self.inner.alert_sensitivity_threshold(inp);
            self
        }
        /// <p>An integer from 0 to 100 specifying the alert sensitivity threshold.</p>
        pub fn set_alert_sensitivity_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_alert_sensitivity_threshold(input);
            self
        }
        /// <p>A description of the alert.</p>
        pub fn alert_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alert_description(inp);
            self
        }
        /// <p>A description of the alert.</p>
        pub fn set_alert_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_alert_description(input);
            self
        }
        /// <p>The ARN of the detector to which the alert is attached.</p>
        pub fn anomaly_detector_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_detector_arn(inp);
            self
        }
        /// <p>The ARN of the detector to which the alert is attached.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_detector_arn(input);
            self
        }
        /// <p>Action that will be triggered when there is an alert.</p>
        pub fn action(mut self, inp: crate::model::Action) -> Self {
            self.inner = self.inner.action(inp);
            self
        }
        /// <p>Action that will be triggered when there is an alert.</p>
        pub fn set_action(mut self, input: std::option::Option<crate::model::Action>) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply to the alert.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply to the alert.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAnomalyDetector`.
    ///
    /// <p>Creates an anomaly detector.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAnomalyDetector<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_anomaly_detector_input::Builder,
    }
    impl<C, M, R> CreateAnomalyDetector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAnomalyDetector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAnomalyDetectorOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAnomalyDetectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAnomalyDetectorInputOperationOutputAlias,
                crate::output::CreateAnomalyDetectorOutput,
                crate::error::CreateAnomalyDetectorError,
                crate::input::CreateAnomalyDetectorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the detector.</p>
        pub fn anomaly_detector_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_detector_name(inp);
            self
        }
        /// <p>The name of the detector.</p>
        pub fn set_anomaly_detector_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_detector_name(input);
            self
        }
        /// <p>A description of the detector.</p>
        pub fn anomaly_detector_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_detector_description(inp);
            self
        }
        /// <p>A description of the detector.</p>
        pub fn set_anomaly_detector_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_detector_description(input);
            self
        }
        /// <p>Contains information about the configuration of the anomaly detector.</p>
        pub fn anomaly_detector_config(mut self, inp: crate::model::AnomalyDetectorConfig) -> Self {
            self.inner = self.inner.anomaly_detector_config(inp);
            self
        }
        /// <p>Contains information about the configuration of the anomaly detector.</p>
        pub fn set_anomaly_detector_config(
            mut self,
            input: std::option::Option<crate::model::AnomalyDetectorConfig>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_detector_config(input);
            self
        }
        /// <p>The ARN of the KMS key to use to encrypt your data.</p>
        pub fn kms_key_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_arn(inp);
            self
        }
        /// <p>The ARN of the KMS key to use to encrypt your data.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply to the anomaly detector.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply to the anomaly detector.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMetricSet`.
    ///
    /// <p>Creates a dataset.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateMetricSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_metric_set_input::Builder,
    }
    impl<C, M, R> CreateMetricSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMetricSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMetricSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMetricSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMetricSetInputOperationOutputAlias,
                crate::output::CreateMetricSetOutput,
                crate::error::CreateMetricSetError,
                crate::input::CreateMetricSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the anomaly detector that will use the dataset.</p>
        pub fn anomaly_detector_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_detector_arn(inp);
            self
        }
        /// <p>The ARN of the anomaly detector that will use the dataset.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_detector_arn(input);
            self
        }
        /// <p>The name of the dataset.</p>
        pub fn metric_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_set_name(inp);
            self
        }
        /// <p>The name of the dataset.</p>
        pub fn set_metric_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_metric_set_name(input);
            self
        }
        /// <p>A description of the dataset you are creating.</p>
        pub fn metric_set_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_set_description(inp);
            self
        }
        /// <p>A description of the dataset you are creating.</p>
        pub fn set_metric_set_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_metric_set_description(input);
            self
        }
        /// Appends an item to `MetricList`.
        ///
        /// To override the contents of this collection use [`set_metric_list`](Self::set_metric_list).
        ///
        /// <p>A list of metrics that the dataset will contain.</p>
        pub fn metric_list(mut self, inp: impl Into<crate::model::Metric>) -> Self {
            self.inner = self.inner.metric_list(inp);
            self
        }
        /// <p>A list of metrics that the dataset will contain.</p>
        pub fn set_metric_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Metric>>,
        ) -> Self {
            self.inner = self.inner.set_metric_list(input);
            self
        }
        /// <p>After an interval ends, the amount of seconds that the detector waits before importing data. Offset is only supported for S3 and Redshift datasources.</p>
        pub fn offset(mut self, inp: i32) -> Self {
            self.inner = self.inner.offset(inp);
            self
        }
        /// <p>After an interval ends, the amount of seconds that the detector waits before importing data. Offset is only supported for S3 and Redshift datasources.</p>
        pub fn set_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_offset(input);
            self
        }
        /// <p>Contains information about the column used for tracking time in your source data.</p>
        pub fn timestamp_column(mut self, inp: crate::model::TimestampColumn) -> Self {
            self.inner = self.inner.timestamp_column(inp);
            self
        }
        /// <p>Contains information about the column used for tracking time in your source data.</p>
        pub fn set_timestamp_column(
            mut self,
            input: std::option::Option<crate::model::TimestampColumn>,
        ) -> Self {
            self.inner = self.inner.set_timestamp_column(input);
            self
        }
        /// Appends an item to `DimensionList`.
        ///
        /// To override the contents of this collection use [`set_dimension_list`](Self::set_dimension_list).
        ///
        /// <p>A list of the fields you want to treat as dimensions.</p>
        pub fn dimension_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dimension_list(inp);
            self
        }
        /// <p>A list of the fields you want to treat as dimensions.</p>
        pub fn set_dimension_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_dimension_list(input);
            self
        }
        /// <p>The frequency with which the source data will be analyzed for anomalies.</p>
        pub fn metric_set_frequency(mut self, inp: crate::model::Frequency) -> Self {
            self.inner = self.inner.metric_set_frequency(inp);
            self
        }
        /// <p>The frequency with which the source data will be analyzed for anomalies.</p>
        pub fn set_metric_set_frequency(
            mut self,
            input: std::option::Option<crate::model::Frequency>,
        ) -> Self {
            self.inner = self.inner.set_metric_set_frequency(input);
            self
        }
        /// <p>Contains information about how the source data should be interpreted.</p>
        pub fn metric_source(mut self, inp: crate::model::MetricSource) -> Self {
            self.inner = self.inner.metric_source(inp);
            self
        }
        /// <p>Contains information about how the source data should be interpreted.</p>
        pub fn set_metric_source(
            mut self,
            input: std::option::Option<crate::model::MetricSource>,
        ) -> Self {
            self.inner = self.inner.set_metric_source(input);
            self
        }
        /// <p>The time zone in which your source data was recorded.</p>
        pub fn timezone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.timezone(inp);
            self
        }
        /// <p>The time zone in which your source data was recorded.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_timezone(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply to the dataset.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply to the dataset.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAlert`.
    ///
    /// <p>Deletes an alert.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAlert<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_alert_input::Builder,
    }
    impl<C, M, R> DeleteAlert<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAlert`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAlertOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAlertError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAlertInputOperationOutputAlias,
                crate::output::DeleteAlertOutput,
                crate::error::DeleteAlertError,
                crate::input::DeleteAlertInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the alert to delete.</p>
        pub fn alert_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alert_arn(inp);
            self
        }
        /// <p>The ARN of the alert to delete.</p>
        pub fn set_alert_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alert_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAnomalyDetector`.
    ///
    /// <p>Deletes a detector. Deleting an anomaly detector will delete all of its corresponding resources including any
    /// configured datasets and alerts.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAnomalyDetector<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_anomaly_detector_input::Builder,
    }
    impl<C, M, R> DeleteAnomalyDetector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAnomalyDetector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAnomalyDetectorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAnomalyDetectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAnomalyDetectorInputOperationOutputAlias,
                crate::output::DeleteAnomalyDetectorOutput,
                crate::error::DeleteAnomalyDetectorError,
                crate::input::DeleteAnomalyDetectorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the detector to delete.</p>
        pub fn anomaly_detector_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_detector_arn(inp);
            self
        }
        /// <p>The ARN of the detector to delete.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_detector_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAlert`.
    ///
    /// <p>Describes an alert.</p>
    /// <p>Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
    /// immediately after creating or modifying it, use retries to allow time for the write operation to complete.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAlert<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_alert_input::Builder,
    }
    impl<C, M, R> DescribeAlert<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAlert`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAlertOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAlertError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAlertInputOperationOutputAlias,
                crate::output::DescribeAlertOutput,
                crate::error::DescribeAlertError,
                crate::input::DescribeAlertInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the alert to describe.</p>
        pub fn alert_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alert_arn(inp);
            self
        }
        /// <p>The ARN of the alert to describe.</p>
        pub fn set_alert_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alert_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAnomalyDetectionExecutions`.
    ///
    /// <p>Returns information about the status of the specified anomaly detection jobs.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAnomalyDetectionExecutions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_anomaly_detection_executions_input::Builder,
    }
    impl<C, M, R> DescribeAnomalyDetectionExecutions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAnomalyDetectionExecutions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAnomalyDetectionExecutionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeAnomalyDetectionExecutionsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAnomalyDetectionExecutionsInputOperationOutputAlias,
                crate::output::DescribeAnomalyDetectionExecutionsOutput,
                crate::error::DescribeAnomalyDetectionExecutionsError,
                crate::input::DescribeAnomalyDetectionExecutionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn anomaly_detector_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_detector_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_detector_arn(input);
            self
        }
        /// <p>The timestamp of the anomaly detection job.</p>
        pub fn timestamp(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.timestamp(inp);
            self
        }
        /// <p>The timestamp of the anomaly detection job.</p>
        pub fn set_timestamp(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_timestamp(input);
            self
        }
        /// <p>The number of items to return in the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The number of items to return in the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAnomalyDetector`.
    ///
    /// <p>Describes a detector.</p>
    /// <p>Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
    /// immediately after creating or modifying it, use retries to allow time for the write operation to complete.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAnomalyDetector<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_anomaly_detector_input::Builder,
    }
    impl<C, M, R> DescribeAnomalyDetector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAnomalyDetector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAnomalyDetectorOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAnomalyDetectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAnomalyDetectorInputOperationOutputAlias,
                crate::output::DescribeAnomalyDetectorOutput,
                crate::error::DescribeAnomalyDetectorError,
                crate::input::DescribeAnomalyDetectorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the detector to describe.</p>
        pub fn anomaly_detector_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_detector_arn(inp);
            self
        }
        /// <p>The ARN of the detector to describe.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_detector_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMetricSet`.
    ///
    /// <p>Describes a dataset.</p>
    /// <p>Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
    /// immediately after creating or modifying it, use retries to allow time for the write operation to complete.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeMetricSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_metric_set_input::Builder,
    }
    impl<C, M, R> DescribeMetricSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMetricSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMetricSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMetricSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeMetricSetInputOperationOutputAlias,
                crate::output::DescribeMetricSetOutput,
                crate::error::DescribeMetricSetError,
                crate::input::DescribeMetricSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the dataset.</p>
        pub fn metric_set_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_set_arn(inp);
            self
        }
        /// <p>The ARN of the dataset.</p>
        pub fn set_metric_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_metric_set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAnomalyGroup`.
    ///
    /// <p>Returns details about a group of anomalous metrics.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAnomalyGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_anomaly_group_input::Builder,
    }
    impl<C, M, R> GetAnomalyGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAnomalyGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAnomalyGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAnomalyGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAnomalyGroupInputOperationOutputAlias,
                crate::output::GetAnomalyGroupOutput,
                crate::error::GetAnomalyGroupError,
                crate::input::GetAnomalyGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the anomaly group.</p>
        pub fn anomaly_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_group_id(inp);
            self
        }
        /// <p>The ID of the anomaly group.</p>
        pub fn set_anomaly_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_group_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn anomaly_detector_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_detector_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_detector_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFeedback`.
    ///
    /// <p>Get feedback for an anomaly group.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFeedback<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_feedback_input::Builder,
    }
    impl<C, M, R> GetFeedback<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFeedback`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFeedbackOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFeedbackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFeedbackInputOperationOutputAlias,
                crate::output::GetFeedbackOutput,
                crate::error::GetFeedbackError,
                crate::input::GetFeedbackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn anomaly_detector_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_detector_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_detector_arn(input);
            self
        }
        /// <p>The anomalous metric and group ID.</p>
        pub fn anomaly_group_time_series_feedback(
            mut self,
            inp: crate::model::AnomalyGroupTimeSeries,
        ) -> Self {
            self.inner = self.inner.anomaly_group_time_series_feedback(inp);
            self
        }
        /// <p>The anomalous metric and group ID.</p>
        pub fn set_anomaly_group_time_series_feedback(
            mut self,
            input: std::option::Option<crate::model::AnomalyGroupTimeSeries>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_group_time_series_feedback(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSampleData`.
    ///
    /// <p>Returns a selection of sample records from an Amazon S3 datasource.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetSampleData<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_sample_data_input::Builder,
    }
    impl<C, M, R> GetSampleData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSampleData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSampleDataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSampleDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSampleDataInputOperationOutputAlias,
                crate::output::GetSampleDataOutput,
                crate::error::GetSampleDataError,
                crate::input::GetSampleDataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A datasource bucket in Amazon S3.</p>
        pub fn s3_source_config(mut self, inp: crate::model::SampleDataS3SourceConfig) -> Self {
            self.inner = self.inner.s3_source_config(inp);
            self
        }
        /// <p>A datasource bucket in Amazon S3.</p>
        pub fn set_s3_source_config(
            mut self,
            input: std::option::Option<crate::model::SampleDataS3SourceConfig>,
        ) -> Self {
            self.inner = self.inner.set_s3_source_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAlerts`.
    ///
    /// <p>Lists the alerts attached to a detector.</p>
    /// <p>Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
    /// immediately after creating or modifying it, use retries to allow time for the write operation to complete.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAlerts<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_alerts_input::Builder,
    }
    impl<C, M, R> ListAlerts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAlerts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAlertsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAlertsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAlertsInputOperationOutputAlias,
                crate::output::ListAlertsOutput,
                crate::error::ListAlertsError,
                crate::input::ListAlertsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the alert's detector.</p>
        pub fn anomaly_detector_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_detector_arn(inp);
            self
        }
        /// <p>The ARN of the alert's detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_detector_arn(input);
            self
        }
        /// <p>If the result of the previous request is truncated, the response includes a <code>NextToken</code>. To
        /// retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the result of the previous request is truncated, the response includes a <code>NextToken</code>. To
        /// retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results that will be displayed by the request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results that will be displayed by the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAnomalyDetectors`.
    ///
    /// <p>Lists the detectors in the current AWS Region.</p>
    /// <p>Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
    /// immediately after creating or modifying it, use retries to allow time for the write operation to complete.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAnomalyDetectors<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_anomaly_detectors_input::Builder,
    }
    impl<C, M, R> ListAnomalyDetectors<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAnomalyDetectors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAnomalyDetectorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAnomalyDetectorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAnomalyDetectorsInputOperationOutputAlias,
                crate::output::ListAnomalyDetectorsOutput,
                crate::error::ListAnomalyDetectorsError,
                crate::input::ListAnomalyDetectorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To
        /// retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To
        /// retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAnomalyGroupSummaries`.
    ///
    /// <p>Returns a list of anomaly groups.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAnomalyGroupSummaries<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_anomaly_group_summaries_input::Builder,
    }
    impl<C, M, R> ListAnomalyGroupSummaries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAnomalyGroupSummaries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAnomalyGroupSummariesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAnomalyGroupSummariesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAnomalyGroupSummariesInputOperationOutputAlias,
                crate::output::ListAnomalyGroupSummariesOutput,
                crate::error::ListAnomalyGroupSummariesError,
                crate::input::ListAnomalyGroupSummariesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn anomaly_detector_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_detector_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_detector_arn(input);
            self
        }
        /// <p>The minimum severity score for inclusion in the output.</p>
        pub fn sensitivity_threshold(mut self, inp: i32) -> Self {
            self.inner = self.inner.sensitivity_threshold(inp);
            self
        }
        /// <p>The minimum severity score for inclusion in the output.</p>
        pub fn set_sensitivity_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_sensitivity_threshold(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAnomalyGroupTimeSeries`.
    ///
    /// <p>Gets a list of anomalous metrics for a measure in an anomaly group.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAnomalyGroupTimeSeries<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_anomaly_group_time_series_input::Builder,
    }
    impl<C, M, R> ListAnomalyGroupTimeSeries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAnomalyGroupTimeSeries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAnomalyGroupTimeSeriesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAnomalyGroupTimeSeriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAnomalyGroupTimeSeriesInputOperationOutputAlias,
                crate::output::ListAnomalyGroupTimeSeriesOutput,
                crate::error::ListAnomalyGroupTimeSeriesError,
                crate::input::ListAnomalyGroupTimeSeriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn anomaly_detector_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_detector_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_detector_arn(input);
            self
        }
        /// <p>The ID of the anomaly group.</p>
        pub fn anomaly_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_group_id(inp);
            self
        }
        /// <p>The ID of the anomaly group.</p>
        pub fn set_anomaly_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_group_id(input);
            self
        }
        /// <p>The name of the measure field.</p>
        pub fn metric_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_name(inp);
            self
        }
        /// <p>The name of the measure field.</p>
        pub fn set_metric_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Specify the pagination token that's returned by a previous request to retrieve the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMetricSets`.
    ///
    /// <p>Lists the datasets in the current AWS Region.</p>
    /// <p>Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource
    /// immediately after creating or modifying it, use retries to allow time for the write operation to complete.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListMetricSets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_metric_sets_input::Builder,
    }
    impl<C, M, R> ListMetricSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMetricSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMetricSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMetricSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMetricSetsInputOperationOutputAlias,
                crate::output::ListMetricSetsOutput,
                crate::error::ListMetricSetsError,
                crate::input::ListMetricSetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the anomaly detector containing the metrics sets to list.</p>
        pub fn anomaly_detector_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_detector_arn(inp);
            self
        }
        /// <p>The ARN of the anomaly detector containing the metrics sets to list.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_detector_arn(input);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the result of the previous request was truncated, the response includes a
        /// <code>NextToken</code>. To retrieve the next set of results, use the token in the next
        /// request. Tokens expire after 24 hours.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the result of the previous request was truncated, the response includes a
        /// <code>NextToken</code>. To retrieve the next set of results, use the token in the next
        /// request. Tokens expire after 24 hours.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Gets a list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> for a detector, dataset, or alert.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource's Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The resource's Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutFeedback`.
    ///
    /// <p>Add feedback for an anomalous metric.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutFeedback<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_feedback_input::Builder,
    }
    impl<C, M, R> PutFeedback<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutFeedback`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutFeedbackOutput,
            aws_smithy_http::result::SdkError<crate::error::PutFeedbackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutFeedbackInputOperationOutputAlias,
                crate::output::PutFeedbackOutput,
                crate::error::PutFeedbackError,
                crate::input::PutFeedbackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn anomaly_detector_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_detector_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the anomaly detector.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_detector_arn(input);
            self
        }
        /// <p>Feedback for an anomalous metric.</p>
        pub fn anomaly_group_time_series_feedback(
            mut self,
            inp: crate::model::AnomalyGroupTimeSeriesFeedback,
        ) -> Self {
            self.inner = self.inner.anomaly_group_time_series_feedback(inp);
            self
        }
        /// <p>Feedback for an anomalous metric.</p>
        pub fn set_anomaly_group_time_series_feedback(
            mut self,
            input: std::option::Option<crate::model::AnomalyGroupTimeSeriesFeedback>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_group_time_series_feedback(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to a detector, dataset, or alert.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource's Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The resource's Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to apply to the resource. Tag keys and values can contain letters, numbers, spaces, and the following
        /// symbols: <code>_.:/=+@-</code>
        /// </p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Tags to apply to the resource. Tag keys and values can contain letters, numbers, spaces, and the following
        /// symbols: <code>_.:/=+@-</code>
        /// </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> from a detector, dataset, or alert.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource's Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The resource's Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Keys to remove from the resource's tags.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>Keys to remove from the resource's tags.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAnomalyDetector`.
    ///
    /// <p>Updates a detector. After activation, you can only change a detector's ingestion delay and description.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAnomalyDetector<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_anomaly_detector_input::Builder,
    }
    impl<C, M, R> UpdateAnomalyDetector<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAnomalyDetector`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAnomalyDetectorOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAnomalyDetectorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAnomalyDetectorInputOperationOutputAlias,
                crate::output::UpdateAnomalyDetectorOutput,
                crate::error::UpdateAnomalyDetectorError,
                crate::input::UpdateAnomalyDetectorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the detector to update.</p>
        pub fn anomaly_detector_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_detector_arn(inp);
            self
        }
        /// <p>The ARN of the detector to update.</p>
        pub fn set_anomaly_detector_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_detector_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an AWS KMS encryption key.</p>
        pub fn kms_key_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an AWS KMS encryption key.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_arn(input);
            self
        }
        /// <p>The updated detector description.</p>
        pub fn anomaly_detector_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_detector_description(inp);
            self
        }
        /// <p>The updated detector description.</p>
        pub fn set_anomaly_detector_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_detector_description(input);
            self
        }
        /// <p>Contains information about the configuration to which the detector will be updated.</p>
        pub fn anomaly_detector_config(mut self, inp: crate::model::AnomalyDetectorConfig) -> Self {
            self.inner = self.inner.anomaly_detector_config(inp);
            self
        }
        /// <p>Contains information about the configuration to which the detector will be updated.</p>
        pub fn set_anomaly_detector_config(
            mut self,
            input: std::option::Option<crate::model::AnomalyDetectorConfig>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_detector_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMetricSet`.
    ///
    /// <p>Updates a dataset.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateMetricSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_metric_set_input::Builder,
    }
    impl<C, M, R> UpdateMetricSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMetricSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMetricSetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMetricSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMetricSetInputOperationOutputAlias,
                crate::output::UpdateMetricSetOutput,
                crate::error::UpdateMetricSetError,
                crate::input::UpdateMetricSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the dataset to update.</p>
        pub fn metric_set_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_set_arn(inp);
            self
        }
        /// <p>The ARN of the dataset to update.</p>
        pub fn set_metric_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_metric_set_arn(input);
            self
        }
        /// <p>The dataset's description.</p>
        pub fn metric_set_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metric_set_description(inp);
            self
        }
        /// <p>The dataset's description.</p>
        pub fn set_metric_set_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_metric_set_description(input);
            self
        }
        /// Appends an item to `MetricList`.
        ///
        /// To override the contents of this collection use [`set_metric_list`](Self::set_metric_list).
        ///
        /// <p>The metric list.</p>
        pub fn metric_list(mut self, inp: impl Into<crate::model::Metric>) -> Self {
            self.inner = self.inner.metric_list(inp);
            self
        }
        /// <p>The metric list.</p>
        pub fn set_metric_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Metric>>,
        ) -> Self {
            self.inner = self.inner.set_metric_list(input);
            self
        }
        /// <p>After an interval ends, the amount of seconds that the detector waits before importing data. Offset is only supported for S3 and Redshift datasources.</p>
        pub fn offset(mut self, inp: i32) -> Self {
            self.inner = self.inner.offset(inp);
            self
        }
        /// <p>After an interval ends, the amount of seconds that the detector waits before importing data. Offset is only supported for S3 and Redshift datasources.</p>
        pub fn set_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_offset(input);
            self
        }
        /// <p>The timestamp column.</p>
        pub fn timestamp_column(mut self, inp: crate::model::TimestampColumn) -> Self {
            self.inner = self.inner.timestamp_column(inp);
            self
        }
        /// <p>The timestamp column.</p>
        pub fn set_timestamp_column(
            mut self,
            input: std::option::Option<crate::model::TimestampColumn>,
        ) -> Self {
            self.inner = self.inner.set_timestamp_column(input);
            self
        }
        /// Appends an item to `DimensionList`.
        ///
        /// To override the contents of this collection use [`set_dimension_list`](Self::set_dimension_list).
        ///
        /// <p>The dimension list.</p>
        pub fn dimension_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dimension_list(inp);
            self
        }
        /// <p>The dimension list.</p>
        pub fn set_dimension_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_dimension_list(input);
            self
        }
        /// <p>The dataset's interval.</p>
        pub fn metric_set_frequency(mut self, inp: crate::model::Frequency) -> Self {
            self.inner = self.inner.metric_set_frequency(inp);
            self
        }
        /// <p>The dataset's interval.</p>
        pub fn set_metric_set_frequency(
            mut self,
            input: std::option::Option<crate::model::Frequency>,
        ) -> Self {
            self.inner = self.inner.set_metric_set_frequency(input);
            self
        }
        /// <p>Contains information about source data used to generate a metric.</p>
        pub fn metric_source(mut self, inp: crate::model::MetricSource) -> Self {
            self.inner = self.inner.metric_source(inp);
            self
        }
        /// <p>Contains information about source data used to generate a metric.</p>
        pub fn set_metric_source(
            mut self,
            input: std::option::Option<crate::model::MetricSource>,
        ) -> Self {
            self.inner = self.inner.set_metric_source(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
