// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Location Service
///
/// Client for invoking operations on Amazon Location Service. Each operation on Amazon Location Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_location::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_location::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_location::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateTrackerConsumer`](crate::client::fluent_builders::AssociateTrackerConsumer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tracker_name(impl Into<String>)`](crate::client::fluent_builders::AssociateTrackerConsumer::tracker_name) / [`set_tracker_name(Option<String>)`](crate::client::fluent_builders::AssociateTrackerConsumer::set_tracker_name): <p>The name of the tracker resource to be associated with a geofence collection.</p>
    ///   - [`consumer_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateTrackerConsumer::consumer_arn) / [`set_consumer_arn(Option<String>)`](crate::client::fluent_builders::AssociateTrackerConsumer::set_consumer_arn): <p>The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.</p>  <ul>   <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code> </p> </li>  </ul>
    /// - On success, responds with [`AssociateTrackerConsumerOutput`](crate::output::AssociateTrackerConsumerOutput)

    /// - On failure, responds with [`SdkError<AssociateTrackerConsumerError>`](crate::error::AssociateTrackerConsumerError)
    pub fn associate_tracker_consumer(&self) -> fluent_builders::AssociateTrackerConsumer {
        fluent_builders::AssociateTrackerConsumer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchDeleteDevicePositionHistory`](crate::client::fluent_builders::BatchDeleteDevicePositionHistory) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tracker_name(impl Into<String>)`](crate::client::fluent_builders::BatchDeleteDevicePositionHistory::tracker_name) / [`set_tracker_name(Option<String>)`](crate::client::fluent_builders::BatchDeleteDevicePositionHistory::set_tracker_name): <p>The name of the tracker resource to delete the device position history from.</p>
    ///   - [`device_ids(Vec<String>)`](crate::client::fluent_builders::BatchDeleteDevicePositionHistory::device_ids) / [`set_device_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchDeleteDevicePositionHistory::set_device_ids): <p>Devices whose position history you want to delete.</p>  <ul>   <li> <p>For example, for two devices: <code>“DeviceIds” : [DeviceId1,DeviceId2]</code> </p> </li>  </ul>
    /// - On success, responds with [`BatchDeleteDevicePositionHistoryOutput`](crate::output::BatchDeleteDevicePositionHistoryOutput) with field(s):
    ///   - [`errors(Option<Vec<BatchDeleteDevicePositionHistoryError>>)`](crate::output::BatchDeleteDevicePositionHistoryOutput::errors): <p>Contains error details for each device history that failed to delete.</p>
    /// - On failure, responds with [`SdkError<BatchDeleteDevicePositionHistoryError>`](crate::error::BatchDeleteDevicePositionHistoryError)
    pub fn batch_delete_device_position_history(
        &self,
    ) -> fluent_builders::BatchDeleteDevicePositionHistory {
        fluent_builders::BatchDeleteDevicePositionHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchDeleteGeofence`](crate::client::fluent_builders::BatchDeleteGeofence) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`collection_name(impl Into<String>)`](crate::client::fluent_builders::BatchDeleteGeofence::collection_name) / [`set_collection_name(Option<String>)`](crate::client::fluent_builders::BatchDeleteGeofence::set_collection_name): <p>The geofence collection storing the geofences to be deleted.</p>
    ///   - [`geofence_ids(Vec<String>)`](crate::client::fluent_builders::BatchDeleteGeofence::geofence_ids) / [`set_geofence_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchDeleteGeofence::set_geofence_ids): <p>The batch of geofences to be deleted.</p>
    /// - On success, responds with [`BatchDeleteGeofenceOutput`](crate::output::BatchDeleteGeofenceOutput) with field(s):
    ///   - [`errors(Option<Vec<BatchDeleteGeofenceError>>)`](crate::output::BatchDeleteGeofenceOutput::errors): <p>Contains error details for each geofence that failed to delete.</p>
    /// - On failure, responds with [`SdkError<BatchDeleteGeofenceError>`](crate::error::BatchDeleteGeofenceError)
    pub fn batch_delete_geofence(&self) -> fluent_builders::BatchDeleteGeofence {
        fluent_builders::BatchDeleteGeofence::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchEvaluateGeofences`](crate::client::fluent_builders::BatchEvaluateGeofences) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`collection_name(impl Into<String>)`](crate::client::fluent_builders::BatchEvaluateGeofences::collection_name) / [`set_collection_name(Option<String>)`](crate::client::fluent_builders::BatchEvaluateGeofences::set_collection_name): <p>The geofence collection used in evaluating the position of devices against its geofences.</p>
    ///   - [`device_position_updates(Vec<DevicePositionUpdate>)`](crate::client::fluent_builders::BatchEvaluateGeofences::device_position_updates) / [`set_device_position_updates(Option<Vec<DevicePositionUpdate>>)`](crate::client::fluent_builders::BatchEvaluateGeofences::set_device_position_updates): <p>Contains device details for each device to be evaluated against the given geofence collection.</p>
    /// - On success, responds with [`BatchEvaluateGeofencesOutput`](crate::output::BatchEvaluateGeofencesOutput) with field(s):
    ///   - [`errors(Option<Vec<BatchEvaluateGeofencesError>>)`](crate::output::BatchEvaluateGeofencesOutput::errors): <p>Contains error details for each device that failed to evaluate its position against the given geofence collection.</p>
    /// - On failure, responds with [`SdkError<BatchEvaluateGeofencesError>`](crate::error::BatchEvaluateGeofencesError)
    pub fn batch_evaluate_geofences(&self) -> fluent_builders::BatchEvaluateGeofences {
        fluent_builders::BatchEvaluateGeofences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchGetDevicePosition`](crate::client::fluent_builders::BatchGetDevicePosition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tracker_name(impl Into<String>)`](crate::client::fluent_builders::BatchGetDevicePosition::tracker_name) / [`set_tracker_name(Option<String>)`](crate::client::fluent_builders::BatchGetDevicePosition::set_tracker_name): <p>The tracker resource retrieving the device position.</p>
    ///   - [`device_ids(Vec<String>)`](crate::client::fluent_builders::BatchGetDevicePosition::device_ids) / [`set_device_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchGetDevicePosition::set_device_ids): <p>Devices whose position you want to retrieve.</p>  <ul>   <li> <p>For example, for two devices: <code>device-ids=DeviceId1&amp;device-ids=DeviceId2</code> </p> </li>  </ul>
    /// - On success, responds with [`BatchGetDevicePositionOutput`](crate::output::BatchGetDevicePositionOutput) with field(s):
    ///   - [`errors(Option<Vec<BatchGetDevicePositionError>>)`](crate::output::BatchGetDevicePositionOutput::errors): <p>Contains error details for each device that failed to send its position to the tracker resource.</p>
    ///   - [`device_positions(Option<Vec<DevicePosition>>)`](crate::output::BatchGetDevicePositionOutput::device_positions): <p>Contains device position details such as the device ID, position, and timestamps for when the position was received and sampled.</p>
    /// - On failure, responds with [`SdkError<BatchGetDevicePositionError>`](crate::error::BatchGetDevicePositionError)
    pub fn batch_get_device_position(&self) -> fluent_builders::BatchGetDevicePosition {
        fluent_builders::BatchGetDevicePosition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchPutGeofence`](crate::client::fluent_builders::BatchPutGeofence) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`collection_name(impl Into<String>)`](crate::client::fluent_builders::BatchPutGeofence::collection_name) / [`set_collection_name(Option<String>)`](crate::client::fluent_builders::BatchPutGeofence::set_collection_name): <p>The geofence collection storing the geofences.</p>
    ///   - [`entries(Vec<BatchPutGeofenceRequestEntry>)`](crate::client::fluent_builders::BatchPutGeofence::entries) / [`set_entries(Option<Vec<BatchPutGeofenceRequestEntry>>)`](crate::client::fluent_builders::BatchPutGeofence::set_entries): <p>The batch of geofences to be stored in a geofence collection.</p>
    /// - On success, responds with [`BatchPutGeofenceOutput`](crate::output::BatchPutGeofenceOutput) with field(s):
    ///   - [`successes(Option<Vec<BatchPutGeofenceSuccess>>)`](crate::output::BatchPutGeofenceOutput::successes): <p>Contains each geofence that was successfully stored in a geofence collection.</p>
    ///   - [`errors(Option<Vec<BatchPutGeofenceError>>)`](crate::output::BatchPutGeofenceOutput::errors): <p>Contains additional error details for each geofence that failed to be stored in a geofence collection.</p>
    /// - On failure, responds with [`SdkError<BatchPutGeofenceError>`](crate::error::BatchPutGeofenceError)
    pub fn batch_put_geofence(&self) -> fluent_builders::BatchPutGeofence {
        fluent_builders::BatchPutGeofence::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchUpdateDevicePosition`](crate::client::fluent_builders::BatchUpdateDevicePosition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tracker_name(impl Into<String>)`](crate::client::fluent_builders::BatchUpdateDevicePosition::tracker_name) / [`set_tracker_name(Option<String>)`](crate::client::fluent_builders::BatchUpdateDevicePosition::set_tracker_name): <p>The name of the tracker resource to update.</p>
    ///   - [`updates(Vec<DevicePositionUpdate>)`](crate::client::fluent_builders::BatchUpdateDevicePosition::updates) / [`set_updates(Option<Vec<DevicePositionUpdate>>)`](crate::client::fluent_builders::BatchUpdateDevicePosition::set_updates): <p>Contains the position update details for each device.</p>
    /// - On success, responds with [`BatchUpdateDevicePositionOutput`](crate::output::BatchUpdateDevicePositionOutput) with field(s):
    ///   - [`errors(Option<Vec<BatchUpdateDevicePositionError>>)`](crate::output::BatchUpdateDevicePositionOutput::errors): <p>Contains error details for each device that failed to update its position.</p>
    /// - On failure, responds with [`SdkError<BatchUpdateDevicePositionError>`](crate::error::BatchUpdateDevicePositionError)
    pub fn batch_update_device_position(&self) -> fluent_builders::BatchUpdateDevicePosition {
        fluent_builders::BatchUpdateDevicePosition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CalculateRoute`](crate::client::fluent_builders::CalculateRoute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`calculator_name(impl Into<String>)`](crate::client::fluent_builders::CalculateRoute::calculator_name) / [`set_calculator_name(Option<String>)`](crate::client::fluent_builders::CalculateRoute::set_calculator_name): <p>The name of the route calculator resource that you want to use to calculate the route. </p>
    ///   - [`departure_position(Vec<f64>)`](crate::client::fluent_builders::CalculateRoute::departure_position) / [`set_departure_position(Option<Vec<f64>>)`](crate::client::fluent_builders::CalculateRoute::set_departure_position): <p>The start position for the route. Defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>.</p>  <ul>   <li> <p>For example, <code>[-123.115, 49.285]</code> </p> </li>  </ul> <note>   <p>If you specify a departure that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. If Esri is the provider for your route calculator, specifying a route that is longer than 400 km returns a <code>400 RoutesValidationException</code> error.</p>  </note>  <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
    ///   - [`destination_position(Vec<f64>)`](crate::client::fluent_builders::CalculateRoute::destination_position) / [`set_destination_position(Option<Vec<f64>>)`](crate::client::fluent_builders::CalculateRoute::set_destination_position): <p>The finish position for the route. Defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>.</p>  <ul>   <li> <p> For example, <code>[-122.339, 47.615]</code> </p> </li>  </ul> <note>   <p>If you specify a destination that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. </p>  </note>  <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
    ///   - [`waypoint_positions(Vec<Vec<f64>>)`](crate::client::fluent_builders::CalculateRoute::waypoint_positions) / [`set_waypoint_positions(Option<Vec<Vec<f64>>>)`](crate::client::fluent_builders::CalculateRoute::set_waypoint_positions): <p>Specifies an ordered list of up to 23 intermediate positions to include along a route between the departure position and destination position. </p>  <ul>   <li> <p>For example, from the <code>DeparturePosition</code> <code>[-123.115, 49.285]</code>, the route follows the order that the waypoint positions are given <code>[[-122.757, 49.0021],[-122.349, 47.620]]</code> </p> </li>  </ul> <note>   <p>If you specify a waypoint position that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. </p>   <p>Specifying more than 23 waypoints returns a <code>400 ValidationException</code> error.</p>   <p>If Esri is the provider for your route calculator, specifying a route that is longer than 400 km returns a <code>400 RoutesValidationException</code> error.</p>  </note>  <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
    ///   - [`travel_mode(TravelMode)`](crate::client::fluent_builders::CalculateRoute::travel_mode) / [`set_travel_mode(Option<TravelMode>)`](crate::client::fluent_builders::CalculateRoute::set_travel_mode): <p>Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road compatibility.</p>  <p>The <code>TravelMode</code> you specify also determines how you specify route preferences: </p>  <ul>   <li> <p>If traveling by <code>Car</code> use the <code>CarModeOptions</code> parameter.</p> </li>   <li> <p>If traveling by <code>Truck</code> use the <code>TruckModeOptions</code> parameter.</p> </li>  </ul>  <p>Default Value: <code>Car</code> </p>
    ///   - [`departure_time(DateTime)`](crate::client::fluent_builders::CalculateRoute::departure_time) / [`set_departure_time(Option<DateTime>)`](crate::client::fluent_builders::CalculateRoute::set_departure_time): <p>Specifies the desired time of departure. Uses the given time to calculate the route. Otherwise, the best time of day to travel with the best traffic conditions is used to calculate the route.</p> <note>   <p>Setting a departure time in the past returns a <code>400 ValidationException</code> error.</p>  </note>  <ul>   <li> <p>In <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>  </ul>
    ///   - [`depart_now(bool)`](crate::client::fluent_builders::CalculateRoute::depart_now) / [`set_depart_now(Option<bool>)`](crate::client::fluent_builders::CalculateRoute::set_depart_now): <p>Sets the time of departure as the current time. Uses the current time to calculate a route. Otherwise, the best time of day to travel with the best traffic conditions is used to calculate the route.</p>  <p>Default Value: <code>false</code> </p>  <p>Valid Values: <code>false</code> | <code>true</code> </p>
    ///   - [`distance_unit(DistanceUnit)`](crate::client::fluent_builders::CalculateRoute::distance_unit) / [`set_distance_unit(Option<DistanceUnit>)`](crate::client::fluent_builders::CalculateRoute::set_distance_unit): <p>Set the unit system to specify the distance.</p>  <p>Default Value: <code>Kilometers</code> </p>
    ///   - [`include_leg_geometry(bool)`](crate::client::fluent_builders::CalculateRoute::include_leg_geometry) / [`set_include_leg_geometry(Option<bool>)`](crate::client::fluent_builders::CalculateRoute::set_include_leg_geometry): <p>Set to include the geometry details in the result for each path between a pair of positions.</p>  <p>Default Value: <code>false</code> </p>  <p>Valid Values: <code>false</code> | <code>true</code> </p>
    ///   - [`car_mode_options(CalculateRouteCarModeOptions)`](crate::client::fluent_builders::CalculateRoute::car_mode_options) / [`set_car_mode_options(Option<CalculateRouteCarModeOptions>)`](crate::client::fluent_builders::CalculateRoute::set_car_mode_options): <p>Specifies route preferences when traveling by <code>Car</code>, such as avoiding routes that use ferries or tolls.</p>  <p>Requirements: <code>TravelMode</code> must be specified as <code>Car</code>.</p>
    ///   - [`truck_mode_options(CalculateRouteTruckModeOptions)`](crate::client::fluent_builders::CalculateRoute::truck_mode_options) / [`set_truck_mode_options(Option<CalculateRouteTruckModeOptions>)`](crate::client::fluent_builders::CalculateRoute::set_truck_mode_options): <p>Specifies route preferences when traveling by <code>Truck</code>, such as avoiding routes that use ferries or tolls, and truck specifications to consider when choosing an optimal road.</p>  <p>Requirements: <code>TravelMode</code> must be specified as <code>Truck</code>.</p>
    /// - On success, responds with [`CalculateRouteOutput`](crate::output::CalculateRouteOutput) with field(s):
    ///   - [`legs(Option<Vec<Leg>>)`](crate::output::CalculateRouteOutput::legs): <p>Contains details about each path between a pair of positions included along a route such as: <code>StartPosition</code>, <code>EndPosition</code>, <code>Distance</code>, <code>DurationSeconds</code>, <code>Geometry</code>, and <code>Steps</code>. The number of legs returned corresponds to one fewer than the total number of positions in the request. </p>  <p>For example, a route with a departure position and destination position returns one leg with the positions <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">snapped to a nearby road</a>:</p>  <ul>   <li> <p>The <code>StartPosition</code> is the departure position.</p> </li>   <li> <p>The <code>EndPosition</code> is the destination position.</p> </li>  </ul>  <p>A route with a waypoint between the departure and destination position returns two legs with the positions snapped to a nearby road:</p>  <ul>   <li> <p>Leg 1: The <code>StartPosition</code> is the departure position . The <code>EndPosition</code> is the waypoint positon.</p> </li>   <li> <p>Leg 2: The <code>StartPosition</code> is the waypoint position. The <code>EndPosition</code> is the destination position.</p> </li>  </ul>
    ///   - [`summary(Option<CalculateRouteSummary>)`](crate::output::CalculateRouteOutput::summary): <p>Contains information about the whole route, such as: <code>RouteBBox</code>, <code>DataSource</code>, <code>Distance</code>, <code>DistanceUnit</code>, and <code>DurationSeconds</code>.</p>
    /// - On failure, responds with [`SdkError<CalculateRouteError>`](crate::error::CalculateRouteError)
    pub fn calculate_route(&self) -> fluent_builders::CalculateRoute {
        fluent_builders::CalculateRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CalculateRouteMatrix`](crate::client::fluent_builders::CalculateRouteMatrix) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`calculator_name(impl Into<String>)`](crate::client::fluent_builders::CalculateRouteMatrix::calculator_name) / [`set_calculator_name(Option<String>)`](crate::client::fluent_builders::CalculateRouteMatrix::set_calculator_name): <p>The name of the route calculator resource that you want to use to calculate the route matrix. </p>
    ///   - [`departure_positions(Vec<Vec<f64>>)`](crate::client::fluent_builders::CalculateRouteMatrix::departure_positions) / [`set_departure_positions(Option<Vec<Vec<f64>>>)`](crate::client::fluent_builders::CalculateRouteMatrix::set_departure_positions): <p>The list of departure (origin) positions for the route matrix. An array of points, each of which is itself a 2-value array defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>. For example, <code>[-123.115, 49.285]</code>.</p> <important>   <p>Depending on the data provider selected in the route calculator resource there may be additional restrictions on the inputs you can choose. See <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits"> Position restrictions</a> in the <i>Amazon Location Service Developer Guide</i>.</p>  </important> <note>   <p>For route calculators that use Esri as the data provider, if you specify a departure that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html"> moves the position to the nearest road</a>. The snapped value is available in the result in <code>SnappedDeparturePositions</code>.</p>  </note>  <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
    ///   - [`destination_positions(Vec<Vec<f64>>)`](crate::client::fluent_builders::CalculateRouteMatrix::destination_positions) / [`set_destination_positions(Option<Vec<Vec<f64>>>)`](crate::client::fluent_builders::CalculateRouteMatrix::set_destination_positions): <p>The list of destination positions for the route matrix. An array of points, each of which is itself a 2-value array defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>. For example, <code>[-122.339, 47.615]</code> </p> <important>   <p>Depending on the data provider selected in the route calculator resource there may be additional restrictions on the inputs you can choose. See <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits"> Position restrictions</a> in the <i>Amazon Location Service Developer Guide</i>.</p>  </important> <note>   <p>For route calculators that use Esri as the data provider, if you specify a destination that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html"> moves the position to the nearest road</a>. The snapped value is available in the result in <code>SnappedDestinationPositions</code>.</p>  </note>  <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
    ///   - [`travel_mode(TravelMode)`](crate::client::fluent_builders::CalculateRouteMatrix::travel_mode) / [`set_travel_mode(Option<TravelMode>)`](crate::client::fluent_builders::CalculateRouteMatrix::set_travel_mode): <p>Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road compatibility.</p>  <p>The <code>TravelMode</code> you specify also determines how you specify route preferences: </p>  <ul>   <li> <p>If traveling by <code>Car</code> use the <code>CarModeOptions</code> parameter.</p> </li>   <li> <p>If traveling by <code>Truck</code> use the <code>TruckModeOptions</code> parameter.</p> </li>  </ul>  <p>Default Value: <code>Car</code> </p>
    ///   - [`departure_time(DateTime)`](crate::client::fluent_builders::CalculateRouteMatrix::departure_time) / [`set_departure_time(Option<DateTime>)`](crate::client::fluent_builders::CalculateRouteMatrix::set_departure_time): <p>Specifies the desired time of departure. Uses the given time to calculate the route matrix. You can't set both <code>DepartureTime</code> and <code>DepartNow</code>. If neither is set, the best time of day to travel with the best traffic conditions is used to calculate the route matrix.</p> <note>   <p>Setting a departure time in the past returns a <code>400 ValidationException</code> error.</p>  </note>  <ul>   <li> <p>In <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>  </ul>
    ///   - [`depart_now(bool)`](crate::client::fluent_builders::CalculateRouteMatrix::depart_now) / [`set_depart_now(Option<bool>)`](crate::client::fluent_builders::CalculateRouteMatrix::set_depart_now): <p>Sets the time of departure as the current time. Uses the current time to calculate the route matrix. You can't set both <code>DepartureTime</code> and <code>DepartNow</code>. If neither is set, the best time of day to travel with the best traffic conditions is used to calculate the route matrix.</p>  <p>Default Value: <code>false</code> </p>  <p>Valid Values: <code>false</code> | <code>true</code> </p>
    ///   - [`distance_unit(DistanceUnit)`](crate::client::fluent_builders::CalculateRouteMatrix::distance_unit) / [`set_distance_unit(Option<DistanceUnit>)`](crate::client::fluent_builders::CalculateRouteMatrix::set_distance_unit): <p>Set the unit system to specify the distance.</p>  <p>Default Value: <code>Kilometers</code> </p>
    ///   - [`car_mode_options(CalculateRouteCarModeOptions)`](crate::client::fluent_builders::CalculateRouteMatrix::car_mode_options) / [`set_car_mode_options(Option<CalculateRouteCarModeOptions>)`](crate::client::fluent_builders::CalculateRouteMatrix::set_car_mode_options): <p>Specifies route preferences when traveling by <code>Car</code>, such as avoiding routes that use ferries or tolls.</p>  <p>Requirements: <code>TravelMode</code> must be specified as <code>Car</code>.</p>
    ///   - [`truck_mode_options(CalculateRouteTruckModeOptions)`](crate::client::fluent_builders::CalculateRouteMatrix::truck_mode_options) / [`set_truck_mode_options(Option<CalculateRouteTruckModeOptions>)`](crate::client::fluent_builders::CalculateRouteMatrix::set_truck_mode_options): <p>Specifies route preferences when traveling by <code>Truck</code>, such as avoiding routes that use ferries or tolls, and truck specifications to consider when choosing an optimal road.</p>  <p>Requirements: <code>TravelMode</code> must be specified as <code>Truck</code>.</p>
    /// - On success, responds with [`CalculateRouteMatrixOutput`](crate::output::CalculateRouteMatrixOutput) with field(s):
    ///   - [`route_matrix(Option<Vec<Vec<RouteMatrixEntry>>>)`](crate::output::CalculateRouteMatrixOutput::route_matrix): <p>The calculated route matrix containing the results for all pairs of <code>DeparturePositions</code> to <code>DestinationPositions</code>. Each row corresponds to one entry in <code>DeparturePositions</code>. Each entry in the row corresponds to the route from that entry in <code>DeparturePositions</code> to an entry in <code>DestinationPositions</code>. </p>
    ///   - [`snapped_departure_positions(Option<Vec<Vec<f64>>>)`](crate::output::CalculateRouteMatrixOutput::snapped_departure_positions): <p>For routes calculated using an Esri route calculator resource, departure positions are snapped to the closest road. For Esri route calculator resources, this returns the list of departure/origin positions used for calculation of the <code>RouteMatrix</code>.</p>
    ///   - [`snapped_destination_positions(Option<Vec<Vec<f64>>>)`](crate::output::CalculateRouteMatrixOutput::snapped_destination_positions): <p>The list of destination positions for the route matrix used for calculation of the <code>RouteMatrix</code>.</p>
    ///   - [`summary(Option<CalculateRouteMatrixSummary>)`](crate::output::CalculateRouteMatrixOutput::summary): <p>Contains information about the route matrix, <code>DataSource</code>, <code>DistanceUnit</code>, <code>RouteCount</code> and <code>ErrorCount</code>.</p>
    /// - On failure, responds with [`SdkError<CalculateRouteMatrixError>`](crate::error::CalculateRouteMatrixError)
    pub fn calculate_route_matrix(&self) -> fluent_builders::CalculateRouteMatrix {
        fluent_builders::CalculateRouteMatrix::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateGeofenceCollection`](crate::client::fluent_builders::CreateGeofenceCollection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`collection_name(impl Into<String>)`](crate::client::fluent_builders::CreateGeofenceCollection::collection_name) / [`set_collection_name(Option<String>)`](crate::client::fluent_builders::CreateGeofenceCollection::set_collection_name): <p>A custom name for the geofence collection.</p>  <p>Requirements:</p>  <ul>   <li> <p>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_). </p> </li>   <li> <p>Must be a unique geofence collection name.</p> </li>   <li> <p>No spaces allowed. For example, <code>ExampleGeofenceCollection</code>.</p> </li>  </ul>
    ///   - [`pricing_plan(PricingPlan)`](crate::client::fluent_builders::CreateGeofenceCollection::pricing_plan) / [`set_pricing_plan(Option<PricingPlan>)`](crate::client::fluent_builders::CreateGeofenceCollection::set_pricing_plan): <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    ///   - [`pricing_plan_data_source(impl Into<String>)`](crate::client::fluent_builders::CreateGeofenceCollection::pricing_plan_data_source) / [`set_pricing_plan_data_source(Option<String>)`](crate::client::fluent_builders::CreateGeofenceCollection::set_pricing_plan_data_source): <p>This parameter is no longer used.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateGeofenceCollection::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateGeofenceCollection::set_description): <p>An optional description for the geofence collection.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateGeofenceCollection::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateGeofenceCollection::set_tags): <p>Applies one or more tags to the geofence collection. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>  <p>Format: <code>"key" : "value"</code> </p>  <p>Restrictions:</p>  <ul>   <li> <p>Maximum 50 tags per resource</p> </li>   <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>   <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>   <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>   <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>   <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>  </ul>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateGeofenceCollection::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateGeofenceCollection::set_kms_key_id): <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN. </p>
    /// - On success, responds with [`CreateGeofenceCollectionOutput`](crate::output::CreateGeofenceCollectionOutput) with field(s):
    ///   - [`collection_name(Option<String>)`](crate::output::CreateGeofenceCollectionOutput::collection_name): <p>The name for the geofence collection.</p>
    ///   - [`collection_arn(Option<String>)`](crate::output::CreateGeofenceCollectionOutput::collection_arn): <p>The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a resource across all AWS. </p>  <ul>   <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code> </p> </li>  </ul>
    ///   - [`create_time(Option<DateTime>)`](crate::output::CreateGeofenceCollectionOutput::create_time): <p>The timestamp for when the geofence collection was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    /// - On failure, responds with [`SdkError<CreateGeofenceCollectionError>`](crate::error::CreateGeofenceCollectionError)
    pub fn create_geofence_collection(&self) -> fluent_builders::CreateGeofenceCollection {
        fluent_builders::CreateGeofenceCollection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateMap`](crate::client::fluent_builders::CreateMap) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`map_name(impl Into<String>)`](crate::client::fluent_builders::CreateMap::map_name) / [`set_map_name(Option<String>)`](crate::client::fluent_builders::CreateMap::set_map_name): <p>The name for the map resource.</p>  <p>Requirements:</p>  <ul>   <li> <p>Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_). </p> </li>   <li> <p>Must be a unique map resource name. </p> </li>   <li> <p>No spaces allowed. For example, <code>ExampleMap</code>.</p> </li>  </ul>
    ///   - [`configuration(MapConfiguration)`](crate::client::fluent_builders::CreateMap::configuration) / [`set_configuration(Option<MapConfiguration>)`](crate::client::fluent_builders::CreateMap::set_configuration): <p>Specifies the map style selected from an available data provider.</p>
    ///   - [`pricing_plan(PricingPlan)`](crate::client::fluent_builders::CreateMap::pricing_plan) / [`set_pricing_plan(Option<PricingPlan>)`](crate::client::fluent_builders::CreateMap::set_pricing_plan): <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateMap::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateMap::set_description): <p>An optional description for the map resource.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateMap::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateMap::set_tags): <p>Applies one or more tags to the map resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>  <p>Format: <code>"key" : "value"</code> </p>  <p>Restrictions:</p>  <ul>   <li> <p>Maximum 50 tags per resource</p> </li>   <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>   <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>   <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>   <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>   <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>  </ul>
    /// - On success, responds with [`CreateMapOutput`](crate::output::CreateMapOutput) with field(s):
    ///   - [`map_name(Option<String>)`](crate::output::CreateMapOutput::map_name): <p>The name of the map resource.</p>
    ///   - [`map_arn(Option<String>)`](crate::output::CreateMapOutput::map_arn): <p>The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all AWS.</p>  <ul>   <li> <p>Format example: <code>arn:aws:geo:region:account-id:maps/ExampleMap</code> </p> </li>  </ul>
    ///   - [`create_time(Option<DateTime>)`](crate::output::CreateMapOutput::create_time): <p>The timestamp for when the map resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
    /// - On failure, responds with [`SdkError<CreateMapError>`](crate::error::CreateMapError)
    pub fn create_map(&self) -> fluent_builders::CreateMap {
        fluent_builders::CreateMap::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreatePlaceIndex`](crate::client::fluent_builders::CreatePlaceIndex) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`index_name(impl Into<String>)`](crate::client::fluent_builders::CreatePlaceIndex::index_name) / [`set_index_name(Option<String>)`](crate::client::fluent_builders::CreatePlaceIndex::set_index_name): <p>The name of the place index resource. </p>  <p>Requirements:</p>  <ul>   <li> <p>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).</p> </li>   <li> <p>Must be a unique place index resource name.</p> </li>   <li> <p>No spaces allowed. For example, <code>ExamplePlaceIndex</code>.</p> </li>  </ul>
    ///   - [`data_source(impl Into<String>)`](crate::client::fluent_builders::CreatePlaceIndex::data_source) / [`set_data_source(Option<String>)`](crate::client::fluent_builders::CreatePlaceIndex::set_data_source): <p>Specifies the geospatial data provider for the new place index.</p> <note>   <p>This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> returns an error.</p>  </note>  <p>Valid values include:</p>  <ul>   <li> <p> <code>Esri</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>'s coverage in your region of interest, see <a href="https://developers.arcgis.com/rest/geocode/api-reference/geocode-coverage.htm">Esri details on geocoding coverage</a>.</p> </li>   <li> <p> <code>Here</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a>' coverage in your region of interest, see <a href="https://developer.here.com/documentation/geocoder/dev_guide/topics/coverage-geocoder.html">HERE details on goecoding coverage</a>.</p> <important>     <p>If you specify HERE Technologies (<code>Here</code>) as the data provider, you may not <a href="https://docs.aws.amazon.com/location-places/latest/APIReference/API_DataSourceConfiguration.html">store results</a> for locations in Japan. For more information, see the <a href="https://aws.amazon.com/service-terms/">AWS Service Terms</a> for Amazon Location Service.</p>    </important> </li>  </ul>  <p>For additional information , see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data providers</a> on the <i>Amazon Location Service Developer Guide</i>.</p>
    ///   - [`pricing_plan(PricingPlan)`](crate::client::fluent_builders::CreatePlaceIndex::pricing_plan) / [`set_pricing_plan(Option<PricingPlan>)`](crate::client::fluent_builders::CreatePlaceIndex::set_pricing_plan): <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreatePlaceIndex::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreatePlaceIndex::set_description): <p>The optional description for the place index resource.</p>
    ///   - [`data_source_configuration(DataSourceConfiguration)`](crate::client::fluent_builders::CreatePlaceIndex::data_source_configuration) / [`set_data_source_configuration(Option<DataSourceConfiguration>)`](crate::client::fluent_builders::CreatePlaceIndex::set_data_source_configuration): <p>Specifies the data storage option requesting Places.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreatePlaceIndex::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreatePlaceIndex::set_tags): <p>Applies one or more tags to the place index resource. A tag is a key-value pair that helps you manage, identify, search, and filter your resources.</p>  <p>Format: <code>"key" : "value"</code> </p>  <p>Restrictions:</p>  <ul>   <li> <p>Maximum 50 tags per resource.</p> </li>   <li> <p>Each tag key must be unique and must have exactly one associated value.</p> </li>   <li> <p>Maximum key length: 128 Unicode characters in UTF-8.</p> </li>   <li> <p>Maximum value length: 256 Unicode characters in UTF-8.</p> </li>   <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @</p> </li>   <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>  </ul>
    /// - On success, responds with [`CreatePlaceIndexOutput`](crate::output::CreatePlaceIndexOutput) with field(s):
    ///   - [`index_name(Option<String>)`](crate::output::CreatePlaceIndexOutput::index_name): <p>The name for the place index resource.</p>
    ///   - [`index_arn(Option<String>)`](crate::output::CreatePlaceIndexOutput::index_arn): <p>The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across AWS. </p>  <ul>   <li> <p>Format example: <code>arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex</code> </p> </li>  </ul>
    ///   - [`create_time(Option<DateTime>)`](crate::output::CreatePlaceIndexOutput::create_time): <p>The timestamp for when the place index resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    /// - On failure, responds with [`SdkError<CreatePlaceIndexError>`](crate::error::CreatePlaceIndexError)
    pub fn create_place_index(&self) -> fluent_builders::CreatePlaceIndex {
        fluent_builders::CreatePlaceIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRouteCalculator`](crate::client::fluent_builders::CreateRouteCalculator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`calculator_name(impl Into<String>)`](crate::client::fluent_builders::CreateRouteCalculator::calculator_name) / [`set_calculator_name(Option<String>)`](crate::client::fluent_builders::CreateRouteCalculator::set_calculator_name): <p>The name of the route calculator resource. </p>  <p>Requirements:</p>  <ul>   <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).</p> </li>   <li> <p>Must be a unique Route calculator resource name.</p> </li>   <li> <p>No spaces allowed. For example, <code>ExampleRouteCalculator</code>.</p> </li>  </ul>
    ///   - [`data_source(impl Into<String>)`](crate::client::fluent_builders::CreateRouteCalculator::data_source) / [`set_data_source(Option<String>)`](crate::client::fluent_builders::CreateRouteCalculator::set_data_source): <p>Specifies the data provider of traffic and road network data.</p> <note>   <p>This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> returns an error. Route calculators that use Esri as a data source only calculate routes that are shorter than 400 km.</p>  </note>  <p>Valid values include:</p>  <ul>   <li> <p> <code>Esri</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>'s coverage in your region of interest, see <a href="https://doc.arcgis.com/en/arcgis-online/reference/network-coverage.htm">Esri details on street networks and traffic coverage</a>.</p> </li>   <li> <p> <code>Here</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a>' coverage in your region of interest, see <a href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/car-routing.html">HERE car routing coverage</a> and <a href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/truck-routing.html">HERE truck routing coverage</a>.</p> </li>  </ul>  <p>For additional information , see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data providers</a> on the <i>Amazon Location Service Developer Guide</i>.</p>
    ///   - [`pricing_plan(PricingPlan)`](crate::client::fluent_builders::CreateRouteCalculator::pricing_plan) / [`set_pricing_plan(Option<PricingPlan>)`](crate::client::fluent_builders::CreateRouteCalculator::set_pricing_plan): <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateRouteCalculator::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateRouteCalculator::set_description): <p>The optional description for the route calculator resource.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateRouteCalculator::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateRouteCalculator::set_tags): <p>Applies one or more tags to the route calculator resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>  <ul>   <li> <p>For example: { <code>"tag1" : "value1"</code>, <code>"tag2" : "value2"</code>}</p> </li>  </ul>  <p>Format: <code>"key" : "value"</code> </p>  <p>Restrictions:</p>  <ul>   <li> <p>Maximum 50 tags per resource</p> </li>   <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>   <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>   <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>   <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>   <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>  </ul>
    /// - On success, responds with [`CreateRouteCalculatorOutput`](crate::output::CreateRouteCalculatorOutput) with field(s):
    ///   - [`calculator_name(Option<String>)`](crate::output::CreateRouteCalculatorOutput::calculator_name): <p>The name of the route calculator resource. </p>  <ul>   <li> <p>For example, <code>ExampleRouteCalculator</code>.</p> </li>  </ul>
    ///   - [`calculator_arn(Option<String>)`](crate::output::CreateRouteCalculatorOutput::calculator_arn): <p>The Amazon Resource Name (ARN) for the route calculator resource. Use the ARN when you specify a resource across all AWS.</p>  <ul>   <li> <p>Format example: <code>arn:aws:geo:region:account-id:route-calculator/ExampleCalculator</code> </p> </li>  </ul>
    ///   - [`create_time(Option<DateTime>)`](crate::output::CreateRouteCalculatorOutput::create_time): <p>The timestamp when the route calculator resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>  <ul>   <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>  </ul>
    /// - On failure, responds with [`SdkError<CreateRouteCalculatorError>`](crate::error::CreateRouteCalculatorError)
    pub fn create_route_calculator(&self) -> fluent_builders::CreateRouteCalculator {
        fluent_builders::CreateRouteCalculator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTracker`](crate::client::fluent_builders::CreateTracker) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tracker_name(impl Into<String>)`](crate::client::fluent_builders::CreateTracker::tracker_name) / [`set_tracker_name(Option<String>)`](crate::client::fluent_builders::CreateTracker::set_tracker_name): <p>The name for the tracker resource.</p>  <p>Requirements:</p>  <ul>   <li> <p>Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).</p> </li>   <li> <p>Must be a unique tracker resource name.</p> </li>   <li> <p>No spaces allowed. For example, <code>ExampleTracker</code>.</p> </li>  </ul>
    ///   - [`pricing_plan(PricingPlan)`](crate::client::fluent_builders::CreateTracker::pricing_plan) / [`set_pricing_plan(Option<PricingPlan>)`](crate::client::fluent_builders::CreateTracker::set_pricing_plan): <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateTracker::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateTracker::set_kms_key_id): <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN.</p>
    ///   - [`pricing_plan_data_source(impl Into<String>)`](crate::client::fluent_builders::CreateTracker::pricing_plan_data_source) / [`set_pricing_plan_data_source(Option<String>)`](crate::client::fluent_builders::CreateTracker::set_pricing_plan_data_source): <p>This parameter is no longer used.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateTracker::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateTracker::set_description): <p>An optional description for the tracker resource.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateTracker::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateTracker::set_tags): <p>Applies one or more tags to the tracker resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>  <p>Format: <code>"key" : "value"</code> </p>  <p>Restrictions:</p>  <ul>   <li> <p>Maximum 50 tags per resource</p> </li>   <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>   <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>   <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>   <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>   <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>  </ul>
    ///   - [`position_filtering(PositionFiltering)`](crate::client::fluent_builders::CreateTracker::position_filtering) / [`set_position_filtering(Option<PositionFiltering>)`](crate::client::fluent_builders::CreateTracker::set_position_filtering): <p>Specifies the position filtering for the tracker resource.</p>  <p>Valid values:</p>  <ul>   <li> <p> <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID. </p> </li>   <li> <p> <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this area are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map. </p> </li>   <li> <p> <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This can reduce the effects of GPS noise when displaying device trajectories on a map, and can help control your costs by reducing the number of geofence evaluations. </p> </li>  </ul>  <p>This field is optional. If not specified, the default value is <code>TimeBased</code>.</p>
    /// - On success, responds with [`CreateTrackerOutput`](crate::output::CreateTrackerOutput) with field(s):
    ///   - [`tracker_name(Option<String>)`](crate::output::CreateTrackerOutput::tracker_name): <p>The name of the tracker resource.</p>
    ///   - [`tracker_arn(Option<String>)`](crate::output::CreateTrackerOutput::tracker_arn): <p>The Amazon Resource Name (ARN) for the tracker resource. Used when you need to specify a resource across all AWS.</p>  <ul>   <li> <p>Format example: <code>arn:aws:geo:region:account-id:tracker/ExampleTracker</code> </p> </li>  </ul>
    ///   - [`create_time(Option<DateTime>)`](crate::output::CreateTrackerOutput::create_time): <p>The timestamp for when the tracker resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    /// - On failure, responds with [`SdkError<CreateTrackerError>`](crate::error::CreateTrackerError)
    pub fn create_tracker(&self) -> fluent_builders::CreateTracker {
        fluent_builders::CreateTracker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteGeofenceCollection`](crate::client::fluent_builders::DeleteGeofenceCollection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`collection_name(impl Into<String>)`](crate::client::fluent_builders::DeleteGeofenceCollection::collection_name) / [`set_collection_name(Option<String>)`](crate::client::fluent_builders::DeleteGeofenceCollection::set_collection_name): <p>The name of the geofence collection to be deleted.</p>
    /// - On success, responds with [`DeleteGeofenceCollectionOutput`](crate::output::DeleteGeofenceCollectionOutput)

    /// - On failure, responds with [`SdkError<DeleteGeofenceCollectionError>`](crate::error::DeleteGeofenceCollectionError)
    pub fn delete_geofence_collection(&self) -> fluent_builders::DeleteGeofenceCollection {
        fluent_builders::DeleteGeofenceCollection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMap`](crate::client::fluent_builders::DeleteMap) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`map_name(impl Into<String>)`](crate::client::fluent_builders::DeleteMap::map_name) / [`set_map_name(Option<String>)`](crate::client::fluent_builders::DeleteMap::set_map_name): <p>The name of the map resource to be deleted.</p>
    /// - On success, responds with [`DeleteMapOutput`](crate::output::DeleteMapOutput)

    /// - On failure, responds with [`SdkError<DeleteMapError>`](crate::error::DeleteMapError)
    pub fn delete_map(&self) -> fluent_builders::DeleteMap {
        fluent_builders::DeleteMap::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePlaceIndex`](crate::client::fluent_builders::DeletePlaceIndex) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`index_name(impl Into<String>)`](crate::client::fluent_builders::DeletePlaceIndex::index_name) / [`set_index_name(Option<String>)`](crate::client::fluent_builders::DeletePlaceIndex::set_index_name): <p>The name of the place index resource to be deleted.</p>
    /// - On success, responds with [`DeletePlaceIndexOutput`](crate::output::DeletePlaceIndexOutput)

    /// - On failure, responds with [`SdkError<DeletePlaceIndexError>`](crate::error::DeletePlaceIndexError)
    pub fn delete_place_index(&self) -> fluent_builders::DeletePlaceIndex {
        fluent_builders::DeletePlaceIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRouteCalculator`](crate::client::fluent_builders::DeleteRouteCalculator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`calculator_name(impl Into<String>)`](crate::client::fluent_builders::DeleteRouteCalculator::calculator_name) / [`set_calculator_name(Option<String>)`](crate::client::fluent_builders::DeleteRouteCalculator::set_calculator_name): <p>The name of the route calculator resource to be deleted.</p>
    /// - On success, responds with [`DeleteRouteCalculatorOutput`](crate::output::DeleteRouteCalculatorOutput)

    /// - On failure, responds with [`SdkError<DeleteRouteCalculatorError>`](crate::error::DeleteRouteCalculatorError)
    pub fn delete_route_calculator(&self) -> fluent_builders::DeleteRouteCalculator {
        fluent_builders::DeleteRouteCalculator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTracker`](crate::client::fluent_builders::DeleteTracker) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tracker_name(impl Into<String>)`](crate::client::fluent_builders::DeleteTracker::tracker_name) / [`set_tracker_name(Option<String>)`](crate::client::fluent_builders::DeleteTracker::set_tracker_name): <p>The name of the tracker resource to be deleted.</p>
    /// - On success, responds with [`DeleteTrackerOutput`](crate::output::DeleteTrackerOutput)

    /// - On failure, responds with [`SdkError<DeleteTrackerError>`](crate::error::DeleteTrackerError)
    pub fn delete_tracker(&self) -> fluent_builders::DeleteTracker {
        fluent_builders::DeleteTracker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeGeofenceCollection`](crate::client::fluent_builders::DescribeGeofenceCollection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`collection_name(impl Into<String>)`](crate::client::fluent_builders::DescribeGeofenceCollection::collection_name) / [`set_collection_name(Option<String>)`](crate::client::fluent_builders::DescribeGeofenceCollection::set_collection_name): <p>The name of the geofence collection.</p>
    /// - On success, responds with [`DescribeGeofenceCollectionOutput`](crate::output::DescribeGeofenceCollectionOutput) with field(s):
    ///   - [`collection_name(Option<String>)`](crate::output::DescribeGeofenceCollectionOutput::collection_name): <p>The name of the geofence collection.</p>
    ///   - [`collection_arn(Option<String>)`](crate::output::DescribeGeofenceCollectionOutput::collection_arn): <p>The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a resource across all AWS. </p>  <ul>   <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code> </p> </li>  </ul>
    ///   - [`description(Option<String>)`](crate::output::DescribeGeofenceCollectionOutput::description): <p>The optional description for the geofence collection.</p>
    ///   - [`pricing_plan(Option<PricingPlan>)`](crate::output::DescribeGeofenceCollectionOutput::pricing_plan): <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
    ///   - [`pricing_plan_data_source(Option<String>)`](crate::output::DescribeGeofenceCollectionOutput::pricing_plan_data_source): <p>No longer used. Always returns an empty string.</p>
    ///   - [`kms_key_id(Option<String>)`](crate::output::DescribeGeofenceCollectionOutput::kms_key_id): <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a> assigned to the Amazon Location resource</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribeGeofenceCollectionOutput::tags): <p>Displays the key, value pairs of tags associated with this resource.</p>
    ///   - [`create_time(Option<DateTime>)`](crate::output::DescribeGeofenceCollectionOutput::create_time): <p>The timestamp for when the geofence resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    ///   - [`update_time(Option<DateTime>)`](crate::output::DescribeGeofenceCollectionOutput::update_time): <p>The timestamp for when the geofence collection was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    /// - On failure, responds with [`SdkError<DescribeGeofenceCollectionError>`](crate::error::DescribeGeofenceCollectionError)
    pub fn describe_geofence_collection(&self) -> fluent_builders::DescribeGeofenceCollection {
        fluent_builders::DescribeGeofenceCollection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeMap`](crate::client::fluent_builders::DescribeMap) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`map_name(impl Into<String>)`](crate::client::fluent_builders::DescribeMap::map_name) / [`set_map_name(Option<String>)`](crate::client::fluent_builders::DescribeMap::set_map_name): <p>The name of the map resource.</p>
    /// - On success, responds with [`DescribeMapOutput`](crate::output::DescribeMapOutput) with field(s):
    ///   - [`map_name(Option<String>)`](crate::output::DescribeMapOutput::map_name): <p>The map style selected from an available provider.</p>
    ///   - [`map_arn(Option<String>)`](crate::output::DescribeMapOutput::map_arn): <p>The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all AWS.</p>  <ul>   <li> <p>Format example: <code>arn:aws:geo:region:account-id:maps/ExampleMap</code> </p> </li>  </ul>
    ///   - [`pricing_plan(Option<PricingPlan>)`](crate::output::DescribeMapOutput::pricing_plan): <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
    ///   - [`data_source(Option<String>)`](crate::output::DescribeMapOutput::data_source): <p>Specifies the data provider for the associated map tiles.</p>
    ///   - [`configuration(Option<MapConfiguration>)`](crate::output::DescribeMapOutput::configuration): <p>Specifies the map tile style selected from a partner data provider.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeMapOutput::description): <p>The optional description for the map resource.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribeMapOutput::tags): <p>Tags associated with the map resource.</p>
    ///   - [`create_time(Option<DateTime>)`](crate::output::DescribeMapOutput::create_time): <p>The timestamp for when the map resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
    ///   - [`update_time(Option<DateTime>)`](crate::output::DescribeMapOutput::update_time): <p>The timestamp for when the map resource was last update in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeMapError>`](crate::error::DescribeMapError)
    pub fn describe_map(&self) -> fluent_builders::DescribeMap {
        fluent_builders::DescribeMap::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePlaceIndex`](crate::client::fluent_builders::DescribePlaceIndex) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`index_name(impl Into<String>)`](crate::client::fluent_builders::DescribePlaceIndex::index_name) / [`set_index_name(Option<String>)`](crate::client::fluent_builders::DescribePlaceIndex::set_index_name): <p>The name of the place index resource.</p>
    /// - On success, responds with [`DescribePlaceIndexOutput`](crate::output::DescribePlaceIndexOutput) with field(s):
    ///   - [`index_name(Option<String>)`](crate::output::DescribePlaceIndexOutput::index_name): <p>The name of the place index resource being described.</p>
    ///   - [`index_arn(Option<String>)`](crate::output::DescribePlaceIndexOutput::index_arn): <p>The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across AWS. </p>  <ul>   <li> <p>Format example: <code>arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex</code> </p> </li>  </ul>
    ///   - [`pricing_plan(Option<PricingPlan>)`](crate::output::DescribePlaceIndexOutput::pricing_plan): <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribePlaceIndexOutput::description): <p>The optional description for the place index resource.</p>
    ///   - [`create_time(Option<DateTime>)`](crate::output::DescribePlaceIndexOutput::create_time): <p>The timestamp for when the place index resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    ///   - [`update_time(Option<DateTime>)`](crate::output::DescribePlaceIndexOutput::update_time): <p>The timestamp for when the place index resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    ///   - [`data_source(Option<String>)`](crate::output::DescribePlaceIndexOutput::data_source): <p>The data provider of geospatial data. Values can be one of the following:</p>  <ul>   <li> <p> <code>Esri</code> </p> </li>   <li> <p> <code>Here</code> </p> </li>  </ul>  <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
    ///   - [`data_source_configuration(Option<DataSourceConfiguration>)`](crate::output::DescribePlaceIndexOutput::data_source_configuration): <p>The specified data storage option for requesting Places.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribePlaceIndexOutput::tags): <p>Tags associated with place index resource.</p>
    /// - On failure, responds with [`SdkError<DescribePlaceIndexError>`](crate::error::DescribePlaceIndexError)
    pub fn describe_place_index(&self) -> fluent_builders::DescribePlaceIndex {
        fluent_builders::DescribePlaceIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRouteCalculator`](crate::client::fluent_builders::DescribeRouteCalculator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`calculator_name(impl Into<String>)`](crate::client::fluent_builders::DescribeRouteCalculator::calculator_name) / [`set_calculator_name(Option<String>)`](crate::client::fluent_builders::DescribeRouteCalculator::set_calculator_name): <p>The name of the route calculator resource.</p>
    /// - On success, responds with [`DescribeRouteCalculatorOutput`](crate::output::DescribeRouteCalculatorOutput) with field(s):
    ///   - [`calculator_name(Option<String>)`](crate::output::DescribeRouteCalculatorOutput::calculator_name): <p>The name of the route calculator resource being described.</p>
    ///   - [`calculator_arn(Option<String>)`](crate::output::DescribeRouteCalculatorOutput::calculator_arn): <p>The Amazon Resource Name (ARN) for the Route calculator resource. Use the ARN when you specify a resource across AWS.</p>  <ul>   <li> <p>Format example: <code>arn:aws:geo:region:account-id:route-calculator/ExampleCalculator</code> </p> </li>  </ul>
    ///   - [`pricing_plan(Option<PricingPlan>)`](crate::output::DescribeRouteCalculatorOutput::pricing_plan): <p>Always returns <code>RequestBasedUsage</code>.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeRouteCalculatorOutput::description): <p>The optional description of the route calculator resource.</p>
    ///   - [`create_time(Option<DateTime>)`](crate::output::DescribeRouteCalculatorOutput::create_time): <p>The timestamp when the route calculator resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>  <ul>   <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>  </ul>
    ///   - [`update_time(Option<DateTime>)`](crate::output::DescribeRouteCalculatorOutput::update_time): <p>The timestamp when the route calculator resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>  <ul>   <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>  </ul>
    ///   - [`data_source(Option<String>)`](crate::output::DescribeRouteCalculatorOutput::data_source): <p>The data provider of traffic and road network data. Indicates one of the available providers:</p>  <ul>   <li> <p> <code>Esri</code> </p> </li>   <li> <p> <code>Here</code> </p> </li>  </ul>  <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribeRouteCalculatorOutput::tags): <p>Tags associated with route calculator resource.</p>
    /// - On failure, responds with [`SdkError<DescribeRouteCalculatorError>`](crate::error::DescribeRouteCalculatorError)
    pub fn describe_route_calculator(&self) -> fluent_builders::DescribeRouteCalculator {
        fluent_builders::DescribeRouteCalculator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTracker`](crate::client::fluent_builders::DescribeTracker) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tracker_name(impl Into<String>)`](crate::client::fluent_builders::DescribeTracker::tracker_name) / [`set_tracker_name(Option<String>)`](crate::client::fluent_builders::DescribeTracker::set_tracker_name): <p>The name of the tracker resource.</p>
    /// - On success, responds with [`DescribeTrackerOutput`](crate::output::DescribeTrackerOutput) with field(s):
    ///   - [`tracker_name(Option<String>)`](crate::output::DescribeTrackerOutput::tracker_name): <p>The name of the tracker resource.</p>
    ///   - [`tracker_arn(Option<String>)`](crate::output::DescribeTrackerOutput::tracker_arn): <p>The Amazon Resource Name (ARN) for the tracker resource. Used when you need to specify a resource across all AWS.</p>  <ul>   <li> <p>Format example: <code>arn:aws:geo:region:account-id:tracker/ExampleTracker</code> </p> </li>  </ul>
    ///   - [`description(Option<String>)`](crate::output::DescribeTrackerOutput::description): <p>The optional description for the tracker resource.</p>
    ///   - [`pricing_plan(Option<PricingPlan>)`](crate::output::DescribeTrackerOutput::pricing_plan): <p>Always returns <code>RequestBasedUsage</code>.</p>
    ///   - [`pricing_plan_data_source(Option<String>)`](crate::output::DescribeTrackerOutput::pricing_plan_data_source): <p>No longer used. Always returns an empty string.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribeTrackerOutput::tags): <p>The tags associated with the tracker resource.</p>
    ///   - [`create_time(Option<DateTime>)`](crate::output::DescribeTrackerOutput::create_time): <p>The timestamp for when the tracker resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    ///   - [`update_time(Option<DateTime>)`](crate::output::DescribeTrackerOutput::update_time): <p>The timestamp for when the tracker resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    ///   - [`kms_key_id(Option<String>)`](crate::output::DescribeTrackerOutput::kms_key_id): <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a> assigned to the Amazon Location resource.</p>
    ///   - [`position_filtering(Option<PositionFiltering>)`](crate::output::DescribeTrackerOutput::position_filtering): <p>The position filtering method of the tracker resource.</p>
    /// - On failure, responds with [`SdkError<DescribeTrackerError>`](crate::error::DescribeTrackerError)
    pub fn describe_tracker(&self) -> fluent_builders::DescribeTracker {
        fluent_builders::DescribeTracker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateTrackerConsumer`](crate::client::fluent_builders::DisassociateTrackerConsumer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tracker_name(impl Into<String>)`](crate::client::fluent_builders::DisassociateTrackerConsumer::tracker_name) / [`set_tracker_name(Option<String>)`](crate::client::fluent_builders::DisassociateTrackerConsumer::set_tracker_name): <p>The name of the tracker resource to be dissociated from the consumer.</p>
    ///   - [`consumer_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateTrackerConsumer::consumer_arn) / [`set_consumer_arn(Option<String>)`](crate::client::fluent_builders::DisassociateTrackerConsumer::set_consumer_arn): <p>The Amazon Resource Name (ARN) for the geofence collection to be disassociated from the tracker resource. Used when you need to specify a resource across all AWS. </p>  <ul>   <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code> </p> </li>  </ul>
    /// - On success, responds with [`DisassociateTrackerConsumerOutput`](crate::output::DisassociateTrackerConsumerOutput)

    /// - On failure, responds with [`SdkError<DisassociateTrackerConsumerError>`](crate::error::DisassociateTrackerConsumerError)
    pub fn disassociate_tracker_consumer(&self) -> fluent_builders::DisassociateTrackerConsumer {
        fluent_builders::DisassociateTrackerConsumer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDevicePosition`](crate::client::fluent_builders::GetDevicePosition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tracker_name(impl Into<String>)`](crate::client::fluent_builders::GetDevicePosition::tracker_name) / [`set_tracker_name(Option<String>)`](crate::client::fluent_builders::GetDevicePosition::set_tracker_name): <p>The tracker resource receiving the position update.</p>
    ///   - [`device_id(impl Into<String>)`](crate::client::fluent_builders::GetDevicePosition::device_id) / [`set_device_id(Option<String>)`](crate::client::fluent_builders::GetDevicePosition::set_device_id): <p>The device whose position you want to retrieve.</p>
    /// - On success, responds with [`GetDevicePositionOutput`](crate::output::GetDevicePositionOutput) with field(s):
    ///   - [`device_id(Option<String>)`](crate::output::GetDevicePositionOutput::device_id): <p>The device whose position you retrieved.</p>
    ///   - [`sample_time(Option<DateTime>)`](crate::output::GetDevicePositionOutput::sample_time): <p>The timestamp at which the device's position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601 </a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    ///   - [`received_time(Option<DateTime>)`](crate::output::GetDevicePositionOutput::received_time): <p>The timestamp for when the tracker resource received the device position in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601 </a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    ///   - [`position(Option<Vec<f64>>)`](crate::output::GetDevicePositionOutput::position): <p>The last known device position.</p>
    ///   - [`accuracy(Option<PositionalAccuracy>)`](crate::output::GetDevicePositionOutput::accuracy): <p>The accuracy of the device position.</p>
    ///   - [`position_properties(Option<HashMap<String, String>>)`](crate::output::GetDevicePositionOutput::position_properties): <p>The properties associated with the position.</p>
    /// - On failure, responds with [`SdkError<GetDevicePositionError>`](crate::error::GetDevicePositionError)
    pub fn get_device_position(&self) -> fluent_builders::GetDevicePosition {
        fluent_builders::GetDevicePosition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDevicePositionHistory`](crate::client::fluent_builders::GetDevicePositionHistory) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetDevicePositionHistory::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`tracker_name(impl Into<String>)`](crate::client::fluent_builders::GetDevicePositionHistory::tracker_name) / [`set_tracker_name(Option<String>)`](crate::client::fluent_builders::GetDevicePositionHistory::set_tracker_name): <p>The tracker resource receiving the request for the device position history.</p>
    ///   - [`device_id(impl Into<String>)`](crate::client::fluent_builders::GetDevicePositionHistory::device_id) / [`set_device_id(Option<String>)`](crate::client::fluent_builders::GetDevicePositionHistory::set_device_id): <p>The device whose position history you want to retrieve.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetDevicePositionHistory::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetDevicePositionHistory::set_next_token): <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>  <p>Default value: <code>null</code> </p>
    ///   - [`start_time_inclusive(DateTime)`](crate::client::fluent_builders::GetDevicePositionHistory::start_time_inclusive) / [`set_start_time_inclusive(Option<DateTime>)`](crate::client::fluent_builders::GetDevicePositionHistory::set_start_time_inclusive): <p>Specify the start time for the position history in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be 24 hours prior to the time that the request is made.</p>  <p>Requirement:</p>  <ul>   <li> <p>The time specified for <code>StartTimeInclusive</code> must be before <code>EndTimeExclusive</code>.</p> </li>  </ul>
    ///   - [`end_time_exclusive(DateTime)`](crate::client::fluent_builders::GetDevicePositionHistory::end_time_exclusive) / [`set_end_time_exclusive(Option<DateTime>)`](crate::client::fluent_builders::GetDevicePositionHistory::set_end_time_exclusive): <p>Specify the end time for the position history in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be the time that the request is made.</p>  <p>Requirement:</p>  <ul>   <li> <p>The time specified for <code>EndTimeExclusive</code> must be after the time for <code>StartTimeInclusive</code>.</p> </li>  </ul>
    /// - On success, responds with [`GetDevicePositionHistoryOutput`](crate::output::GetDevicePositionHistoryOutput) with field(s):
    ///   - [`device_positions(Option<Vec<DevicePosition>>)`](crate::output::GetDevicePositionHistoryOutput::device_positions): <p>Contains the position history details for the requested device.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetDevicePositionHistoryOutput::next_token): <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results.</p>
    /// - On failure, responds with [`SdkError<GetDevicePositionHistoryError>`](crate::error::GetDevicePositionHistoryError)
    pub fn get_device_position_history(&self) -> fluent_builders::GetDevicePositionHistory {
        fluent_builders::GetDevicePositionHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetGeofence`](crate::client::fluent_builders::GetGeofence) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`collection_name(impl Into<String>)`](crate::client::fluent_builders::GetGeofence::collection_name) / [`set_collection_name(Option<String>)`](crate::client::fluent_builders::GetGeofence::set_collection_name): <p>The geofence collection storing the target geofence.</p>
    ///   - [`geofence_id(impl Into<String>)`](crate::client::fluent_builders::GetGeofence::geofence_id) / [`set_geofence_id(Option<String>)`](crate::client::fluent_builders::GetGeofence::set_geofence_id): <p>The geofence you're retrieving details for.</p>
    /// - On success, responds with [`GetGeofenceOutput`](crate::output::GetGeofenceOutput) with field(s):
    ///   - [`geofence_id(Option<String>)`](crate::output::GetGeofenceOutput::geofence_id): <p>The geofence identifier.</p>
    ///   - [`geometry(Option<GeofenceGeometry>)`](crate::output::GetGeofenceOutput::geometry): <p>Contains the geofence geometry details describing a polygon.</p>
    ///   - [`status(Option<String>)`](crate::output::GetGeofenceOutput::status): <p>Identifies the state of the geofence. A geofence will hold one of the following states:</p>  <ul>   <li> <p> <code>ACTIVE</code> — The geofence has been indexed by the system. </p> </li>   <li> <p> <code>PENDING</code> — The geofence is being processed by the system.</p> </li>   <li> <p> <code>FAILED</code> — The geofence failed to be indexed by the system.</p> </li>   <li> <p> <code>DELETED</code> — The geofence has been deleted from the system index.</p> </li>   <li> <p> <code>DELETING</code> — The geofence is being deleted from the system index.</p> </li>  </ul>
    ///   - [`create_time(Option<DateTime>)`](crate::output::GetGeofenceOutput::create_time): <p>The timestamp for when the geofence collection was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    ///   - [`update_time(Option<DateTime>)`](crate::output::GetGeofenceOutput::update_time): <p>The timestamp for when the geofence collection was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    /// - On failure, responds with [`SdkError<GetGeofenceError>`](crate::error::GetGeofenceError)
    pub fn get_geofence(&self) -> fluent_builders::GetGeofence {
        fluent_builders::GetGeofence::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMapGlyphs`](crate::client::fluent_builders::GetMapGlyphs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`map_name(impl Into<String>)`](crate::client::fluent_builders::GetMapGlyphs::map_name) / [`set_map_name(Option<String>)`](crate::client::fluent_builders::GetMapGlyphs::set_map_name): <p>The map resource associated with the glyph ﬁle.</p>
    ///   - [`font_stack(impl Into<String>)`](crate::client::fluent_builders::GetMapGlyphs::font_stack) / [`set_font_stack(Option<String>)`](crate::client::fluent_builders::GetMapGlyphs::set_font_stack): <p>A comma-separated list of fonts to load glyphs from in order of preference. For example, <code>Noto Sans Regular, Arial Unicode</code>.</p>  <p>Valid fonts stacks for <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a> styles: </p>  <ul>   <li> <p>VectorEsriDarkGrayCanvas – <code>Ubuntu Medium Italic</code> | <code>Ubuntu Medium</code> | <code>Ubuntu Italic</code> | <code>Ubuntu Regular</code> | <code>Ubuntu Bold</code> </p> </li>   <li> <p>VectorEsriLightGrayCanvas – <code>Ubuntu Italic</code> | <code>Ubuntu Regular</code> | <code>Ubuntu Light</code> | <code>Ubuntu Bold</code> </p> </li>   <li> <p>VectorEsriTopographic – <code>Noto Sans Italic</code> | <code>Noto Sans Regular</code> | <code>Noto Sans Bold</code> | <code>Noto Serif Regular</code> | <code>Roboto Condensed Light Italic</code> </p> </li>   <li> <p>VectorEsriStreets – <code>Arial Regular</code> | <code>Arial Italic</code> | <code>Arial Bold</code> </p> </li>   <li> <p>VectorEsriNavigation – <code>Arial Regular</code> | <code>Arial Italic</code> | <code>Arial Bold</code> </p> </li>  </ul>  <p>Valid font stacks for <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a> styles: </p>  <ul>   <li> <p>VectorHereBerlin – <code>Fira GO Regular</code> | <code>Fira GO Bold</code> </p> </li>   <li> <p>VectorHereExplore, VectorHereExploreTruck – <code>Firo GO Italic</code> | <code>Fira GO Map</code> | <code>Fira GO Map Bold</code> | <code>Noto Sans CJK JP Bold</code> | <code>Noto Sans CJK JP Light</code> | <code>Noto Sans CJK JP Regular</code> </p> </li>  </ul>
    ///   - [`font_unicode_range(impl Into<String>)`](crate::client::fluent_builders::GetMapGlyphs::font_unicode_range) / [`set_font_unicode_range(Option<String>)`](crate::client::fluent_builders::GetMapGlyphs::set_font_unicode_range): <p>A Unicode range of characters to download glyphs for. Each response will contain 256 characters. For example, 0–255 includes all characters from range <code>U+0000</code> to <code>00FF</code>. Must be aligned to multiples of 256.</p>
    /// - On success, responds with [`GetMapGlyphsOutput`](crate::output::GetMapGlyphsOutput) with field(s):
    ///   - [`blob(Option<Blob>)`](crate::output::GetMapGlyphsOutput::blob): <p>The blob's content type.</p>
    ///   - [`content_type(Option<String>)`](crate::output::GetMapGlyphsOutput::content_type): <p>The map glyph content type. For example, <code>application/octet-stream</code>.</p>
    /// - On failure, responds with [`SdkError<GetMapGlyphsError>`](crate::error::GetMapGlyphsError)
    pub fn get_map_glyphs(&self) -> fluent_builders::GetMapGlyphs {
        fluent_builders::GetMapGlyphs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMapSprites`](crate::client::fluent_builders::GetMapSprites) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`map_name(impl Into<String>)`](crate::client::fluent_builders::GetMapSprites::map_name) / [`set_map_name(Option<String>)`](crate::client::fluent_builders::GetMapSprites::set_map_name): <p>The map resource associated with the sprite ﬁle.</p>
    ///   - [`file_name(impl Into<String>)`](crate::client::fluent_builders::GetMapSprites::file_name) / [`set_file_name(Option<String>)`](crate::client::fluent_builders::GetMapSprites::set_file_name): <p>The name of the sprite ﬁle. Use the following ﬁle names for the sprite sheet:</p>  <ul>   <li> <p> <code>sprites.png</code> </p> </li>   <li> <p> <code>sprites@2x.png</code> for high pixel density displays</p> </li>  </ul>  <p>For the JSON document contain image offsets. Use the following ﬁle names:</p>  <ul>   <li> <p> <code>sprites.json</code> </p> </li>   <li> <p> <code>sprites@2x.json</code> for high pixel density displays</p> </li>  </ul>
    /// - On success, responds with [`GetMapSpritesOutput`](crate::output::GetMapSpritesOutput) with field(s):
    ///   - [`blob(Option<Blob>)`](crate::output::GetMapSpritesOutput::blob): <p>Contains the body of the sprite sheet or JSON offset ﬁle.</p>
    ///   - [`content_type(Option<String>)`](crate::output::GetMapSpritesOutput::content_type): <p>The content type of the sprite sheet and offsets. For example, the sprite sheet content type is <code>image/png</code>, and the sprite offset JSON document is <code>application/json</code>. </p>
    /// - On failure, responds with [`SdkError<GetMapSpritesError>`](crate::error::GetMapSpritesError)
    pub fn get_map_sprites(&self) -> fluent_builders::GetMapSprites {
        fluent_builders::GetMapSprites::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMapStyleDescriptor`](crate::client::fluent_builders::GetMapStyleDescriptor) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`map_name(impl Into<String>)`](crate::client::fluent_builders::GetMapStyleDescriptor::map_name) / [`set_map_name(Option<String>)`](crate::client::fluent_builders::GetMapStyleDescriptor::set_map_name): <p>The map resource to retrieve the style descriptor from.</p>
    /// - On success, responds with [`GetMapStyleDescriptorOutput`](crate::output::GetMapStyleDescriptorOutput) with field(s):
    ///   - [`blob(Option<Blob>)`](crate::output::GetMapStyleDescriptorOutput::blob): <p>Contains the body of the style descriptor.</p>
    ///   - [`content_type(Option<String>)`](crate::output::GetMapStyleDescriptorOutput::content_type): <p>The style descriptor's content type. For example, <code>application/json</code>.</p>
    /// - On failure, responds with [`SdkError<GetMapStyleDescriptorError>`](crate::error::GetMapStyleDescriptorError)
    pub fn get_map_style_descriptor(&self) -> fluent_builders::GetMapStyleDescriptor {
        fluent_builders::GetMapStyleDescriptor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMapTile`](crate::client::fluent_builders::GetMapTile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`map_name(impl Into<String>)`](crate::client::fluent_builders::GetMapTile::map_name) / [`set_map_name(Option<String>)`](crate::client::fluent_builders::GetMapTile::set_map_name): <p>The map resource to retrieve the map tiles from.</p>
    ///   - [`z(impl Into<String>)`](crate::client::fluent_builders::GetMapTile::z) / [`set_z(Option<String>)`](crate::client::fluent_builders::GetMapTile::set_z): <p>The zoom value for the map tile.</p>
    ///   - [`x(impl Into<String>)`](crate::client::fluent_builders::GetMapTile::x) / [`set_x(Option<String>)`](crate::client::fluent_builders::GetMapTile::set_x): <p>The X axis value for the map tile.</p>
    ///   - [`y(impl Into<String>)`](crate::client::fluent_builders::GetMapTile::y) / [`set_y(Option<String>)`](crate::client::fluent_builders::GetMapTile::set_y): <p>The Y axis value for the map tile. </p>
    /// - On success, responds with [`GetMapTileOutput`](crate::output::GetMapTileOutput) with field(s):
    ///   - [`blob(Option<Blob>)`](crate::output::GetMapTileOutput::blob): <p>Contains Mapbox Vector Tile (MVT) data.</p>
    ///   - [`content_type(Option<String>)`](crate::output::GetMapTileOutput::content_type): <p>The map tile's content type. For example, <code>application/vnd.mapbox-vector-tile</code>.</p>
    /// - On failure, responds with [`SdkError<GetMapTileError>`](crate::error::GetMapTileError)
    pub fn get_map_tile(&self) -> fluent_builders::GetMapTile {
        fluent_builders::GetMapTile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDevicePositions`](crate::client::fluent_builders::ListDevicePositions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDevicePositions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`tracker_name(impl Into<String>)`](crate::client::fluent_builders::ListDevicePositions::tracker_name) / [`set_tracker_name(Option<String>)`](crate::client::fluent_builders::ListDevicePositions::set_tracker_name): <p>The tracker resource containing the requested devices.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDevicePositions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDevicePositions::set_max_results): <p>An optional limit for the number of entries returned in a single call.</p>  <p>Default value: <code>100</code> </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDevicePositions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDevicePositions::set_next_token): <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>  <p>Default value: <code>null</code> </p>
    /// - On success, responds with [`ListDevicePositionsOutput`](crate::output::ListDevicePositionsOutput) with field(s):
    ///   - [`entries(Option<Vec<ListDevicePositionsResponseEntry>>)`](crate::output::ListDevicePositionsOutput::entries): <p>Contains details about each device's last known position. These details includes the device ID, the time when the position was sampled on the device, the time that the service received the update, and the most recent coordinates.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDevicePositionsOutput::next_token): <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListDevicePositionsError>`](crate::error::ListDevicePositionsError)
    pub fn list_device_positions(&self) -> fluent_builders::ListDevicePositions {
        fluent_builders::ListDevicePositions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListGeofenceCollections`](crate::client::fluent_builders::ListGeofenceCollections) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListGeofenceCollections::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListGeofenceCollections::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListGeofenceCollections::set_max_results): <p>An optional limit for the number of resources returned in a single call. </p>  <p>Default value: <code>100</code> </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListGeofenceCollections::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListGeofenceCollections::set_next_token): <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>  <p>Default value: <code>null</code> </p>
    /// - On success, responds with [`ListGeofenceCollectionsOutput`](crate::output::ListGeofenceCollectionsOutput) with field(s):
    ///   - [`entries(Option<Vec<ListGeofenceCollectionsResponseEntry>>)`](crate::output::ListGeofenceCollectionsOutput::entries): <p>Lists the geofence collections that exist in your AWS account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListGeofenceCollectionsOutput::next_token): <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListGeofenceCollectionsError>`](crate::error::ListGeofenceCollectionsError)
    pub fn list_geofence_collections(&self) -> fluent_builders::ListGeofenceCollections {
        fluent_builders::ListGeofenceCollections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListGeofences`](crate::client::fluent_builders::ListGeofences) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListGeofences::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`collection_name(impl Into<String>)`](crate::client::fluent_builders::ListGeofences::collection_name) / [`set_collection_name(Option<String>)`](crate::client::fluent_builders::ListGeofences::set_collection_name): <p>The name of the geofence collection storing the list of geofences.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListGeofences::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListGeofences::set_next_token): <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>  <p>Default value: <code>null</code> </p>
    /// - On success, responds with [`ListGeofencesOutput`](crate::output::ListGeofencesOutput) with field(s):
    ///   - [`entries(Option<Vec<ListGeofenceResponseEntry>>)`](crate::output::ListGeofencesOutput::entries): <p>Contains a list of geofences stored in the geofence collection.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListGeofencesOutput::next_token): <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListGeofencesError>`](crate::error::ListGeofencesError)
    pub fn list_geofences(&self) -> fluent_builders::ListGeofences {
        fluent_builders::ListGeofences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMaps`](crate::client::fluent_builders::ListMaps) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListMaps::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListMaps::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListMaps::set_max_results): <p>An optional limit for the number of resources returned in a single call. </p>  <p>Default value: <code>100</code> </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListMaps::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListMaps::set_next_token): <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>  <p>Default value: <code>null</code> </p>
    /// - On success, responds with [`ListMapsOutput`](crate::output::ListMapsOutput) with field(s):
    ///   - [`entries(Option<Vec<ListMapsResponseEntry>>)`](crate::output::ListMapsOutput::entries): <p>Contains a list of maps in your AWS account</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListMapsOutput::next_token): <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListMapsError>`](crate::error::ListMapsError)
    pub fn list_maps(&self) -> fluent_builders::ListMaps {
        fluent_builders::ListMaps::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPlaceIndexes`](crate::client::fluent_builders::ListPlaceIndexes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPlaceIndexes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPlaceIndexes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPlaceIndexes::set_max_results): <p>An optional limit for the maximum number of results returned in a single call.</p>  <p>Default value: <code>100</code> </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPlaceIndexes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPlaceIndexes::set_next_token): <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>  <p>Default value: <code>null</code> </p>
    /// - On success, responds with [`ListPlaceIndexesOutput`](crate::output::ListPlaceIndexesOutput) with field(s):
    ///   - [`entries(Option<Vec<ListPlaceIndexesResponseEntry>>)`](crate::output::ListPlaceIndexesOutput::entries): <p>Lists the place index resources that exist in your AWS account</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPlaceIndexesOutput::next_token): <p>A pagination token indicating that there are additional pages available. You can use the token in a new request to fetch the next page of results.</p>
    /// - On failure, responds with [`SdkError<ListPlaceIndexesError>`](crate::error::ListPlaceIndexesError)
    pub fn list_place_indexes(&self) -> fluent_builders::ListPlaceIndexes {
        fluent_builders::ListPlaceIndexes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRouteCalculators`](crate::client::fluent_builders::ListRouteCalculators) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRouteCalculators::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRouteCalculators::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListRouteCalculators::set_max_results): <p>An optional maximum number of results returned in a single call.</p>  <p>Default Value: <code>100</code> </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRouteCalculators::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRouteCalculators::set_next_token): <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>  <p>Default Value: <code>null</code> </p>
    /// - On success, responds with [`ListRouteCalculatorsOutput`](crate::output::ListRouteCalculatorsOutput) with field(s):
    ///   - [`entries(Option<Vec<ListRouteCalculatorsResponseEntry>>)`](crate::output::ListRouteCalculatorsOutput::entries): <p>Lists the route calculator resources that exist in your AWS account</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListRouteCalculatorsOutput::next_token): <p>A pagination token indicating there are additional pages available. You can use the token in a subsequent request to fetch the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListRouteCalculatorsError>`](crate::error::ListRouteCalculatorsError)
    pub fn list_route_calculators(&self) -> fluent_builders::ListRouteCalculators {
        fluent_builders::ListRouteCalculators::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p>  <ul>   <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li>  </ul>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>Tags that have been applied to the specified resource. Tags are mapped from the tag key to the tag value: <code>"TagKey" : "TagValue"</code>.</p>  <ul>   <li> <p>Format example: <code>{"tag1" : "value1", "tag2" : "value2"} </code> </p> </li>  </ul>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTrackerConsumers`](crate::client::fluent_builders::ListTrackerConsumers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTrackerConsumers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`tracker_name(impl Into<String>)`](crate::client::fluent_builders::ListTrackerConsumers::tracker_name) / [`set_tracker_name(Option<String>)`](crate::client::fluent_builders::ListTrackerConsumers::set_tracker_name): <p>The tracker resource whose associated geofence collections you want to list.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTrackerConsumers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTrackerConsumers::set_max_results): <p>An optional limit for the number of resources returned in a single call. </p>  <p>Default value: <code>100</code> </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTrackerConsumers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTrackerConsumers::set_next_token): <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>  <p>Default value: <code>null</code> </p>
    /// - On success, responds with [`ListTrackerConsumersOutput`](crate::output::ListTrackerConsumersOutput) with field(s):
    ///   - [`consumer_arns(Option<Vec<String>>)`](crate::output::ListTrackerConsumersOutput::consumer_arns): <p>Contains the list of geofence collection ARNs associated to the tracker resource.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTrackerConsumersOutput::next_token): <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListTrackerConsumersError>`](crate::error::ListTrackerConsumersError)
    pub fn list_tracker_consumers(&self) -> fluent_builders::ListTrackerConsumers {
        fluent_builders::ListTrackerConsumers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTrackers`](crate::client::fluent_builders::ListTrackers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListTrackers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTrackers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTrackers::set_max_results): <p>An optional limit for the number of resources returned in a single call. </p>  <p>Default value: <code>100</code> </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTrackers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTrackers::set_next_token): <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>  <p>Default value: <code>null</code> </p>
    /// - On success, responds with [`ListTrackersOutput`](crate::output::ListTrackersOutput) with field(s):
    ///   - [`entries(Option<Vec<ListTrackersResponseEntry>>)`](crate::output::ListTrackersOutput::entries): <p>Contains tracker resources in your AWS account. Details include tracker name, description and timestamps for when the tracker was created and last updated.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTrackersOutput::next_token): <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListTrackersError>`](crate::error::ListTrackersError)
    pub fn list_trackers(&self) -> fluent_builders::ListTrackers {
        fluent_builders::ListTrackers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutGeofence`](crate::client::fluent_builders::PutGeofence) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`collection_name(impl Into<String>)`](crate::client::fluent_builders::PutGeofence::collection_name) / [`set_collection_name(Option<String>)`](crate::client::fluent_builders::PutGeofence::set_collection_name): <p>The geofence collection to store the geofence in.</p>
    ///   - [`geofence_id(impl Into<String>)`](crate::client::fluent_builders::PutGeofence::geofence_id) / [`set_geofence_id(Option<String>)`](crate::client::fluent_builders::PutGeofence::set_geofence_id): <p>An identifier for the geofence. For example, <code>ExampleGeofence-1</code>.</p>
    ///   - [`geometry(GeofenceGeometry)`](crate::client::fluent_builders::PutGeofence::geometry) / [`set_geometry(Option<GeofenceGeometry>)`](crate::client::fluent_builders::PutGeofence::set_geometry): <p>Contains the polygon details to specify the position of the geofence.</p> <note>   <p>Each <a href="https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html">geofence polygon</a> can have a maximum of 1,000 vertices.</p>  </note>
    /// - On success, responds with [`PutGeofenceOutput`](crate::output::PutGeofenceOutput) with field(s):
    ///   - [`geofence_id(Option<String>)`](crate::output::PutGeofenceOutput::geofence_id): <p>The geofence identifier entered in the request.</p>
    ///   - [`create_time(Option<DateTime>)`](crate::output::PutGeofenceOutput::create_time): <p>The timestamp for when the geofence was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    ///   - [`update_time(Option<DateTime>)`](crate::output::PutGeofenceOutput::update_time): <p>The timestamp for when the geofence was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    /// - On failure, responds with [`SdkError<PutGeofenceError>`](crate::error::PutGeofenceError)
    pub fn put_geofence(&self) -> fluent_builders::PutGeofence {
        fluent_builders::PutGeofence::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchPlaceIndexForPosition`](crate::client::fluent_builders::SearchPlaceIndexForPosition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`index_name(impl Into<String>)`](crate::client::fluent_builders::SearchPlaceIndexForPosition::index_name) / [`set_index_name(Option<String>)`](crate::client::fluent_builders::SearchPlaceIndexForPosition::set_index_name): <p>The name of the place index resource you want to use for the search.</p>
    ///   - [`position(Vec<f64>)`](crate::client::fluent_builders::SearchPlaceIndexForPosition::position) / [`set_position(Option<Vec<f64>>)`](crate::client::fluent_builders::SearchPlaceIndexForPosition::set_position): <p>Specifies the longitude and latitude of the position to query.</p>  <p> This parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>  <p>For example, <code>[-123.1174, 49.2847]</code> represents a position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchPlaceIndexForPosition::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::SearchPlaceIndexForPosition::set_max_results): <p>An optional parameter. The maximum number of results returned per request.</p>  <p>Default value: <code>50</code> </p>
    ///   - [`language(impl Into<String>)`](crate::client::fluent_builders::SearchPlaceIndexForPosition::language) / [`set_language(Option<String>)`](crate::client::fluent_builders::SearchPlaceIndexForPosition::set_language): <p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>  <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p>
    /// - On success, responds with [`SearchPlaceIndexForPositionOutput`](crate::output::SearchPlaceIndexForPositionOutput) with field(s):
    ///   - [`summary(Option<SearchPlaceIndexForPositionSummary>)`](crate::output::SearchPlaceIndexForPositionOutput::summary): <p>Contains a summary of the request. Echoes the input values for <code>Position</code>, <code>Language</code>, <code>MaxResults</code>, and the <code>DataSource</code> of the place index. </p>
    ///   - [`results(Option<Vec<SearchForPositionResult>>)`](crate::output::SearchPlaceIndexForPositionOutput::results): <p>Returns a list of Places closest to the specified position. Each result contains additional information about the Places returned.</p>
    /// - On failure, responds with [`SdkError<SearchPlaceIndexForPositionError>`](crate::error::SearchPlaceIndexForPositionError)
    pub fn search_place_index_for_position(&self) -> fluent_builders::SearchPlaceIndexForPosition {
        fluent_builders::SearchPlaceIndexForPosition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchPlaceIndexForSuggestions`](crate::client::fluent_builders::SearchPlaceIndexForSuggestions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`index_name(impl Into<String>)`](crate::client::fluent_builders::SearchPlaceIndexForSuggestions::index_name) / [`set_index_name(Option<String>)`](crate::client::fluent_builders::SearchPlaceIndexForSuggestions::set_index_name): <p>The name of the place index resource you want to use for the search.</p>
    ///   - [`text(impl Into<String>)`](crate::client::fluent_builders::SearchPlaceIndexForSuggestions::text) / [`set_text(Option<String>)`](crate::client::fluent_builders::SearchPlaceIndexForSuggestions::set_text): <p>The free-form partial text to use to generate place suggestions. For example, <code>eiffel tow</code>.</p>
    ///   - [`bias_position(Vec<f64>)`](crate::client::fluent_builders::SearchPlaceIndexForSuggestions::bias_position) / [`set_bias_position(Option<Vec<f64>>)`](crate::client::fluent_builders::SearchPlaceIndexForSuggestions::set_bias_position): <p>An optional parameter that indicates a preference for place suggestions that are closer to a specified position.</p>  <p> If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>  <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p> <note>   <p> <code>BiasPosition</code> and <code>FilterBBox</code> are mutually exclusive. Specifying both options results in an error. </p>  </note>
    ///   - [`filter_b_box(Vec<f64>)`](crate::client::fluent_builders::SearchPlaceIndexForSuggestions::filter_b_box) / [`set_filter_b_box(Option<Vec<f64>>)`](crate::client::fluent_builders::SearchPlaceIndexForSuggestions::set_filter_b_box): <p>An optional parameter that limits the search results by returning only suggestions within a specified bounding box.</p>  <p> If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest corner of the bounding box; the second pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the northeast corner of the bounding box.</p>  <p>For example, <code>[-12.7935, -37.4835, -12.0684, -36.9542]</code> represents a bounding box where the southwest corner has longitude <code>-12.7935</code> and latitude <code>-37.4835</code>, and the northeast corner has longitude <code>-12.0684</code> and latitude <code>-36.9542</code>.</p> <note>   <p> <code>FilterBBox</code> and <code>BiasPosition</code> are mutually exclusive. Specifying both options results in an error. </p>  </note>
    ///   - [`filter_countries(Vec<String>)`](crate::client::fluent_builders::SearchPlaceIndexForSuggestions::filter_countries) / [`set_filter_countries(Option<Vec<String>>)`](crate::client::fluent_builders::SearchPlaceIndexForSuggestions::set_filter_countries): <p>An optional parameter that limits the search results by returning only suggestions within the provided list of countries.</p>  <ul>   <li> <p>Use the <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country code. For example, Australia uses three upper-case characters: <code>AUS</code>.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchPlaceIndexForSuggestions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchPlaceIndexForSuggestions::set_max_results): <p>An optional parameter. The maximum number of results returned per request. </p>  <p>The default: <code>5</code> </p>
    ///   - [`language(impl Into<String>)`](crate::client::fluent_builders::SearchPlaceIndexForSuggestions::language) / [`set_language(Option<String>)`](crate::client::fluent_builders::SearchPlaceIndexForSuggestions::set_language): <p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>  <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p>  <p>Used only when the partner selected is Here.</p>
    /// - On success, responds with [`SearchPlaceIndexForSuggestionsOutput`](crate::output::SearchPlaceIndexForSuggestionsOutput) with field(s):
    ///   - [`summary(Option<SearchPlaceIndexForSuggestionsSummary>)`](crate::output::SearchPlaceIndexForSuggestionsOutput::summary): <p>Contains a summary of the request. Echoes the input values for <code>BiasPosition</code>, <code>FilterBBox</code>, <code>FilterCountries</code>, <code>Language</code>, <code>MaxResults</code>, and <code>Text</code>. Also includes the <code>DataSource</code> of the place index. </p>
    ///   - [`results(Option<Vec<SearchForSuggestionsResult>>)`](crate::output::SearchPlaceIndexForSuggestionsOutput::results): <p>A list of place suggestions that best match the search text.</p>
    /// - On failure, responds with [`SdkError<SearchPlaceIndexForSuggestionsError>`](crate::error::SearchPlaceIndexForSuggestionsError)
    pub fn search_place_index_for_suggestions(
        &self,
    ) -> fluent_builders::SearchPlaceIndexForSuggestions {
        fluent_builders::SearchPlaceIndexForSuggestions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchPlaceIndexForText`](crate::client::fluent_builders::SearchPlaceIndexForText) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`index_name(impl Into<String>)`](crate::client::fluent_builders::SearchPlaceIndexForText::index_name) / [`set_index_name(Option<String>)`](crate::client::fluent_builders::SearchPlaceIndexForText::set_index_name): <p>The name of the place index resource you want to use for the search.</p>
    ///   - [`text(impl Into<String>)`](crate::client::fluent_builders::SearchPlaceIndexForText::text) / [`set_text(Option<String>)`](crate::client::fluent_builders::SearchPlaceIndexForText::set_text): <p>The address, name, city, or region to be used in the search in free-form text format. For example, <code>123 Any Street</code>.</p>
    ///   - [`bias_position(Vec<f64>)`](crate::client::fluent_builders::SearchPlaceIndexForText::bias_position) / [`set_bias_position(Option<Vec<f64>>)`](crate::client::fluent_builders::SearchPlaceIndexForText::set_bias_position): <p>An optional parameter that indicates a preference for places that are closer to a specified position.</p>  <p> If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>  <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p> <note>   <p> <code>BiasPosition</code> and <code>FilterBBox</code> are mutually exclusive. Specifying both options results in an error. </p>  </note>
    ///   - [`filter_b_box(Vec<f64>)`](crate::client::fluent_builders::SearchPlaceIndexForText::filter_b_box) / [`set_filter_b_box(Option<Vec<f64>>)`](crate::client::fluent_builders::SearchPlaceIndexForText::set_filter_b_box): <p>An optional parameter that limits the search results by returning only places that are within the provided bounding box.</p>  <p> If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest corner of the bounding box; the second pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the northeast corner of the bounding box.</p>  <p>For example, <code>[-12.7935, -37.4835, -12.0684, -36.9542]</code> represents a bounding box where the southwest corner has longitude <code>-12.7935</code> and latitude <code>-37.4835</code>, and the northeast corner has longitude <code>-12.0684</code> and latitude <code>-36.9542</code>.</p> <note>   <p> <code>FilterBBox</code> and <code>BiasPosition</code> are mutually exclusive. Specifying both options results in an error. </p>  </note>
    ///   - [`filter_countries(Vec<String>)`](crate::client::fluent_builders::SearchPlaceIndexForText::filter_countries) / [`set_filter_countries(Option<Vec<String>>)`](crate::client::fluent_builders::SearchPlaceIndexForText::set_filter_countries): <p>An optional parameter that limits the search results by returning only places that are in a specified list of countries.</p>  <ul>   <li> <p>Valid values include <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country codes. For example, Australia uses three upper-case characters: <code>AUS</code>.</p> </li>  </ul>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchPlaceIndexForText::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::SearchPlaceIndexForText::set_max_results): <p>An optional parameter. The maximum number of results returned per request. </p>  <p>The default: <code>50</code> </p>
    ///   - [`language(impl Into<String>)`](crate::client::fluent_builders::SearchPlaceIndexForText::language) / [`set_language(Option<String>)`](crate::client::fluent_builders::SearchPlaceIndexForText::set_language): <p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>  <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p>
    /// - On success, responds with [`SearchPlaceIndexForTextOutput`](crate::output::SearchPlaceIndexForTextOutput) with field(s):
    ///   - [`summary(Option<SearchPlaceIndexForTextSummary>)`](crate::output::SearchPlaceIndexForTextOutput::summary): <p>Contains a summary of the request. Echoes the input values for <code>BiasPosition</code>, <code>FilterBBox</code>, <code>FilterCountries</code>, <code>Language</code>, <code>MaxResults</code>, and <code>Text</code>. Also includes the <code>DataSource</code> of the place index and the bounding box, <code>ResultBBox</code>, which surrounds the search results. </p>
    ///   - [`results(Option<Vec<SearchForTextResult>>)`](crate::output::SearchPlaceIndexForTextOutput::results): <p>A list of Places matching the input text. Each result contains additional information about the specific point of interest. </p>
    /// - On failure, responds with [`SdkError<SearchPlaceIndexForTextError>`](crate::error::SearchPlaceIndexForTextError)
    pub fn search_place_index_for_text(&self) -> fluent_builders::SearchPlaceIndexForText {
        fluent_builders::SearchPlaceIndexForText::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource whose tags you want to update.</p>  <ul>   <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li>  </ul>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>Applies one or more tags to specific resource. A tag is a key-value pair that helps you manage, identify, search, and filter your resources.</p>  <p>Format: <code>"key" : "value"</code> </p>  <p>Restrictions:</p>  <ul>   <li> <p>Maximum 50 tags per resource.</p> </li>   <li> <p>Each tag key must be unique and must have exactly one associated value.</p> </li>   <li> <p>Maximum key length: 128 Unicode characters in UTF-8.</p> </li>   <li> <p>Maximum value length: 256 Unicode characters in UTF-8.</p> </li>   <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @</p> </li>   <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>  </ul>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource from which you want to remove tags.</p>  <ul>   <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li>  </ul>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The list of tag keys to remove from the specified resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateGeofenceCollection`](crate::client::fluent_builders::UpdateGeofenceCollection) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`collection_name(impl Into<String>)`](crate::client::fluent_builders::UpdateGeofenceCollection::collection_name) / [`set_collection_name(Option<String>)`](crate::client::fluent_builders::UpdateGeofenceCollection::set_collection_name): <p>The name of the geofence collection to update.</p>
    ///   - [`pricing_plan(PricingPlan)`](crate::client::fluent_builders::UpdateGeofenceCollection::pricing_plan) / [`set_pricing_plan(Option<PricingPlan>)`](crate::client::fluent_builders::UpdateGeofenceCollection::set_pricing_plan): <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    ///   - [`pricing_plan_data_source(impl Into<String>)`](crate::client::fluent_builders::UpdateGeofenceCollection::pricing_plan_data_source) / [`set_pricing_plan_data_source(Option<String>)`](crate::client::fluent_builders::UpdateGeofenceCollection::set_pricing_plan_data_source): <p>This parameter is no longer used.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateGeofenceCollection::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateGeofenceCollection::set_description): <p>Updates the description for the geofence collection.</p>
    /// - On success, responds with [`UpdateGeofenceCollectionOutput`](crate::output::UpdateGeofenceCollectionOutput) with field(s):
    ///   - [`collection_name(Option<String>)`](crate::output::UpdateGeofenceCollectionOutput::collection_name): <p>The name of the updated geofence collection.</p>
    ///   - [`collection_arn(Option<String>)`](crate::output::UpdateGeofenceCollectionOutput::collection_arn): <p>The Amazon Resource Name (ARN) of the updated geofence collection. Used to specify a resource across AWS.</p>  <ul>   <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code> </p> </li>  </ul>
    ///   - [`update_time(Option<DateTime>)`](crate::output::UpdateGeofenceCollectionOutput::update_time): <p>The time when the geofence collection was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    /// - On failure, responds with [`SdkError<UpdateGeofenceCollectionError>`](crate::error::UpdateGeofenceCollectionError)
    pub fn update_geofence_collection(&self) -> fluent_builders::UpdateGeofenceCollection {
        fluent_builders::UpdateGeofenceCollection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateMap`](crate::client::fluent_builders::UpdateMap) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`map_name(impl Into<String>)`](crate::client::fluent_builders::UpdateMap::map_name) / [`set_map_name(Option<String>)`](crate::client::fluent_builders::UpdateMap::set_map_name): <p>The name of the map resource to update.</p>
    ///   - [`pricing_plan(PricingPlan)`](crate::client::fluent_builders::UpdateMap::pricing_plan) / [`set_pricing_plan(Option<PricingPlan>)`](crate::client::fluent_builders::UpdateMap::set_pricing_plan): <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateMap::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateMap::set_description): <p>Updates the description for the map resource.</p>
    /// - On success, responds with [`UpdateMapOutput`](crate::output::UpdateMapOutput) with field(s):
    ///   - [`map_name(Option<String>)`](crate::output::UpdateMapOutput::map_name): <p>The name of the updated map resource.</p>
    ///   - [`map_arn(Option<String>)`](crate::output::UpdateMapOutput::map_arn): <p>The Amazon Resource Name (ARN) of the updated map resource. Used to specify a resource across AWS.</p>  <ul>   <li> <p>Format example: <code>arn:aws:geo:region:account-id:maps/ExampleMap</code> </p> </li>  </ul>
    ///   - [`update_time(Option<DateTime>)`](crate::output::UpdateMapOutput::update_time): <p>The timestamp for when the map resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    /// - On failure, responds with [`SdkError<UpdateMapError>`](crate::error::UpdateMapError)
    pub fn update_map(&self) -> fluent_builders::UpdateMap {
        fluent_builders::UpdateMap::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePlaceIndex`](crate::client::fluent_builders::UpdatePlaceIndex) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`index_name(impl Into<String>)`](crate::client::fluent_builders::UpdatePlaceIndex::index_name) / [`set_index_name(Option<String>)`](crate::client::fluent_builders::UpdatePlaceIndex::set_index_name): <p>The name of the place index resource to update.</p>
    ///   - [`pricing_plan(PricingPlan)`](crate::client::fluent_builders::UpdatePlaceIndex::pricing_plan) / [`set_pricing_plan(Option<PricingPlan>)`](crate::client::fluent_builders::UpdatePlaceIndex::set_pricing_plan): <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdatePlaceIndex::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdatePlaceIndex::set_description): <p>Updates the description for the place index resource.</p>
    ///   - [`data_source_configuration(DataSourceConfiguration)`](crate::client::fluent_builders::UpdatePlaceIndex::data_source_configuration) / [`set_data_source_configuration(Option<DataSourceConfiguration>)`](crate::client::fluent_builders::UpdatePlaceIndex::set_data_source_configuration): <p>Updates the data storage option for the place index resource.</p>
    /// - On success, responds with [`UpdatePlaceIndexOutput`](crate::output::UpdatePlaceIndexOutput) with field(s):
    ///   - [`index_name(Option<String>)`](crate::output::UpdatePlaceIndexOutput::index_name): <p>The name of the updated place index resource.</p>
    ///   - [`index_arn(Option<String>)`](crate::output::UpdatePlaceIndexOutput::index_arn): <p>The Amazon Resource Name (ARN) of the upated place index resource. Used to specify a resource across AWS.</p>  <ul>   <li> <p>Format example: <code>arn:aws:geo:region:account-id:place- index/ExamplePlaceIndex</code> </p> </li>  </ul>
    ///   - [`update_time(Option<DateTime>)`](crate::output::UpdatePlaceIndexOutput::update_time): <p>The timestamp for when the place index resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    /// - On failure, responds with [`SdkError<UpdatePlaceIndexError>`](crate::error::UpdatePlaceIndexError)
    pub fn update_place_index(&self) -> fluent_builders::UpdatePlaceIndex {
        fluent_builders::UpdatePlaceIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRouteCalculator`](crate::client::fluent_builders::UpdateRouteCalculator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`calculator_name(impl Into<String>)`](crate::client::fluent_builders::UpdateRouteCalculator::calculator_name) / [`set_calculator_name(Option<String>)`](crate::client::fluent_builders::UpdateRouteCalculator::set_calculator_name): <p>The name of the route calculator resource to update.</p>
    ///   - [`pricing_plan(PricingPlan)`](crate::client::fluent_builders::UpdateRouteCalculator::pricing_plan) / [`set_pricing_plan(Option<PricingPlan>)`](crate::client::fluent_builders::UpdateRouteCalculator::set_pricing_plan): <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateRouteCalculator::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateRouteCalculator::set_description): <p>Updates the description for the route calculator resource.</p>
    /// - On success, responds with [`UpdateRouteCalculatorOutput`](crate::output::UpdateRouteCalculatorOutput) with field(s):
    ///   - [`calculator_name(Option<String>)`](crate::output::UpdateRouteCalculatorOutput::calculator_name): <p>The name of the updated route calculator resource.</p>
    ///   - [`calculator_arn(Option<String>)`](crate::output::UpdateRouteCalculatorOutput::calculator_arn): <p>The Amazon Resource Name (ARN) of the updated route calculator resource. Used to specify a resource across AWS.</p>  <ul>   <li> <p>Format example: <code>arn:aws:geo:region:account-id:route- calculator/ExampleCalculator</code> </p> </li>  </ul>
    ///   - [`update_time(Option<DateTime>)`](crate::output::UpdateRouteCalculatorOutput::update_time): <p>The timestamp for when the route calculator was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    /// - On failure, responds with [`SdkError<UpdateRouteCalculatorError>`](crate::error::UpdateRouteCalculatorError)
    pub fn update_route_calculator(&self) -> fluent_builders::UpdateRouteCalculator {
        fluent_builders::UpdateRouteCalculator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateTracker`](crate::client::fluent_builders::UpdateTracker) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tracker_name(impl Into<String>)`](crate::client::fluent_builders::UpdateTracker::tracker_name) / [`set_tracker_name(Option<String>)`](crate::client::fluent_builders::UpdateTracker::set_tracker_name): <p>The name of the tracker resource to update.</p>
    ///   - [`pricing_plan(PricingPlan)`](crate::client::fluent_builders::UpdateTracker::pricing_plan) / [`set_pricing_plan(Option<PricingPlan>)`](crate::client::fluent_builders::UpdateTracker::set_pricing_plan): <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    ///   - [`pricing_plan_data_source(impl Into<String>)`](crate::client::fluent_builders::UpdateTracker::pricing_plan_data_source) / [`set_pricing_plan_data_source(Option<String>)`](crate::client::fluent_builders::UpdateTracker::set_pricing_plan_data_source): <p>This parameter is no longer used.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateTracker::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateTracker::set_description): <p>Updates the description for the tracker resource.</p>
    ///   - [`position_filtering(PositionFiltering)`](crate::client::fluent_builders::UpdateTracker::position_filtering) / [`set_position_filtering(Option<PositionFiltering>)`](crate::client::fluent_builders::UpdateTracker::set_position_filtering): <p>Updates the position filtering for the tracker resource.</p>  <p>Valid values:</p>  <ul>   <li> <p> <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID. </p> </li>   <li> <p> <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this distance are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map. </p> </li>   <li> <p> <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This helps educe the effects of GPS noise when displaying device trajectories on a map, and can help control costs by reducing the number of geofence evaluations. </p> </li>  </ul>
    /// - On success, responds with [`UpdateTrackerOutput`](crate::output::UpdateTrackerOutput) with field(s):
    ///   - [`tracker_name(Option<String>)`](crate::output::UpdateTrackerOutput::tracker_name): <p>The name of the updated tracker resource.</p>
    ///   - [`tracker_arn(Option<String>)`](crate::output::UpdateTrackerOutput::tracker_arn): <p>The Amazon Resource Name (ARN) of the updated tracker resource. Used to specify a resource across AWS.</p>  <ul>   <li> <p>Format example: <code>arn:aws:geo:region:account-id:tracker/ExampleTracker</code> </p> </li>  </ul>
    ///   - [`update_time(Option<DateTime>)`](crate::output::UpdateTrackerOutput::update_time): <p>The timestamp for when the tracker resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    /// - On failure, responds with [`SdkError<UpdateTrackerError>`](crate::error::UpdateTrackerError)
    pub fn update_tracker(&self) -> fluent_builders::UpdateTracker {
        fluent_builders::UpdateTracker::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateTrackerConsumer`.
    ///
    /// <p>Creates an association between a geofence collection and a tracker resource. This allows the tracker resource to communicate location data to the linked geofence collection. </p>
    /// <p>You can associate up to five geofence collections to each tracker resource.</p> <note>
    /// <p>Currently not supported — Cross-account configurations, such as creating associations between a tracker resource in one account and a geofence collection in another account.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateTrackerConsumer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_tracker_consumer_input::Builder,
    }
    impl AssociateTrackerConsumer {
        /// Creates a new `AssociateTrackerConsumer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateTrackerConsumerOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateTrackerConsumerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the tracker resource to be associated with a geofence collection.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(input.into());
            self
        }
        /// <p>The name of the tracker resource to be associated with a geofence collection.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code> </p> </li>
        /// </ul>
        pub fn consumer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.consumer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code> </p> </li>
        /// </ul>
        pub fn set_consumer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_consumer_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDeleteDevicePositionHistory`.
    ///
    /// <p>Deletes the position history of one or more devices from a tracker resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDeleteDevicePositionHistory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_delete_device_position_history_input::Builder,
    }
    impl BatchDeleteDevicePositionHistory {
        /// Creates a new `BatchDeleteDevicePositionHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteDevicePositionHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteDevicePositionHistoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the tracker resource to delete the device position history from.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(input.into());
            self
        }
        /// <p>The name of the tracker resource to delete the device position history from.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
        /// Appends an item to `DeviceIds`.
        ///
        /// To override the contents of this collection use [`set_device_ids`](Self::set_device_ids).
        ///
        /// <p>Devices whose position history you want to delete.</p>
        /// <ul>
        /// <li> <p>For example, for two devices: <code>“DeviceIds” : [DeviceId1,DeviceId2]</code> </p> </li>
        /// </ul>
        pub fn device_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_ids(input.into());
            self
        }
        /// <p>Devices whose position history you want to delete.</p>
        /// <ul>
        /// <li> <p>For example, for two devices: <code>“DeviceIds” : [DeviceId1,DeviceId2]</code> </p> </li>
        /// </ul>
        pub fn set_device_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDeleteGeofence`.
    ///
    /// <p>Deletes a batch of geofences from a geofence collection.</p> <note>
    /// <p>This operation deletes the resource permanently.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDeleteGeofence {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_delete_geofence_input::Builder,
    }
    impl BatchDeleteGeofence {
        /// Creates a new `BatchDeleteGeofence`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteGeofenceOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteGeofenceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The geofence collection storing the geofences to be deleted.</p>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_name(input.into());
            self
        }
        /// <p>The geofence collection storing the geofences to be deleted.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_name(input);
            self
        }
        /// Appends an item to `GeofenceIds`.
        ///
        /// To override the contents of this collection use [`set_geofence_ids`](Self::set_geofence_ids).
        ///
        /// <p>The batch of geofences to be deleted.</p>
        pub fn geofence_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.geofence_ids(input.into());
            self
        }
        /// <p>The batch of geofences to be deleted.</p>
        pub fn set_geofence_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_geofence_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchEvaluateGeofences`.
    ///
    /// <p>Evaluates device positions against the geofence geometries from a given geofence collection.</p>
    /// <p>This operation always returns an empty response because geofences are asynchronously evaluated. The evaluation determines if the device has entered or exited a geofenced area, and then publishes one of the following events to Amazon EventBridge:</p>
    /// <ul>
    /// <li> <p> <code>ENTER</code> if Amazon Location determines that the tracked device has entered a geofenced area.</p> </li>
    /// <li> <p> <code>EXIT</code> if Amazon Location determines that the tracked device has exited a geofenced area.</p> </li>
    /// </ul> <note>
    /// <p>The last geofence that a device was observed within is tracked for 30 days after the most recent device position update.</p>
    /// </note> <note>
    /// <p>Geofence evaluation uses the given device position. It does not account for the optional <code>Accuracy</code> of a <code>DevicePositionUpdate</code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchEvaluateGeofences {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_evaluate_geofences_input::Builder,
    }
    impl BatchEvaluateGeofences {
        /// Creates a new `BatchEvaluateGeofences`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchEvaluateGeofencesOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchEvaluateGeofencesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The geofence collection used in evaluating the position of devices against its geofences.</p>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_name(input.into());
            self
        }
        /// <p>The geofence collection used in evaluating the position of devices against its geofences.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_name(input);
            self
        }
        /// Appends an item to `DevicePositionUpdates`.
        ///
        /// To override the contents of this collection use [`set_device_position_updates`](Self::set_device_position_updates).
        ///
        /// <p>Contains device details for each device to be evaluated against the given geofence collection.</p>
        pub fn device_position_updates(
            mut self,
            input: crate::model::DevicePositionUpdate,
        ) -> Self {
            self.inner = self.inner.device_position_updates(input);
            self
        }
        /// <p>Contains device details for each device to be evaluated against the given geofence collection.</p>
        pub fn set_device_position_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DevicePositionUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_device_position_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetDevicePosition`.
    ///
    /// <p>Lists the latest device positions for requested devices.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetDevicePosition {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_get_device_position_input::Builder,
    }
    impl BatchGetDevicePosition {
        /// Creates a new `BatchGetDevicePosition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetDevicePositionOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetDevicePositionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The tracker resource retrieving the device position.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(input.into());
            self
        }
        /// <p>The tracker resource retrieving the device position.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
        /// Appends an item to `DeviceIds`.
        ///
        /// To override the contents of this collection use [`set_device_ids`](Self::set_device_ids).
        ///
        /// <p>Devices whose position you want to retrieve.</p>
        /// <ul>
        /// <li> <p>For example, for two devices: <code>device-ids=DeviceId1&amp;device-ids=DeviceId2</code> </p> </li>
        /// </ul>
        pub fn device_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_ids(input.into());
            self
        }
        /// <p>Devices whose position you want to retrieve.</p>
        /// <ul>
        /// <li> <p>For example, for two devices: <code>device-ids=DeviceId1&amp;device-ids=DeviceId2</code> </p> </li>
        /// </ul>
        pub fn set_device_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchPutGeofence`.
    ///
    /// <p>A batch request for storing geofence geometries into a given geofence collection, or updates the geometry of an existing geofence if a geofence ID is included in the request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchPutGeofence {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_put_geofence_input::Builder,
    }
    impl BatchPutGeofence {
        /// Creates a new `BatchPutGeofence`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchPutGeofenceOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchPutGeofenceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The geofence collection storing the geofences.</p>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_name(input.into());
            self
        }
        /// <p>The geofence collection storing the geofences.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_name(input);
            self
        }
        /// Appends an item to `Entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>The batch of geofences to be stored in a geofence collection.</p>
        pub fn entries(mut self, input: crate::model::BatchPutGeofenceRequestEntry) -> Self {
            self.inner = self.inner.entries(input);
            self
        }
        /// <p>The batch of geofences to be stored in a geofence collection.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchPutGeofenceRequestEntry>>,
        ) -> Self {
            self.inner = self.inner.set_entries(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchUpdateDevicePosition`.
    ///
    /// <p>Uploads position update data for one or more devices to a tracker resource. Amazon Location uses the data when it reports the last known device position and position history. Amazon Location retains location data for 30 days.</p> <note>
    /// <p>Position updates are handled based on the <code>PositionFiltering</code> property of the tracker. When <code>PositionFiltering</code> is set to <code>TimeBased</code>, updates are evaluated against linked geofence collections, and location data is stored at a maximum of one position per 30 second interval. If your update frequency is more often than every 30 seconds, only one update per 30 seconds is stored for each unique device ID.</p>
    /// <p>When <code>PositionFiltering</code> is set to <code>DistanceBased</code> filtering, location data is stored and evaluated against linked geofence collections only if the device has moved more than 30 m (98.4 ft).</p>
    /// <p>When <code>PositionFiltering</code> is set to <code>AccuracyBased</code> filtering, location data is stored and evaluated against linked geofence collections only if the device has moved more than the measured accuracy. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is neither stored or evaluated if the device has moved less than 15 m. If <code>PositionFiltering</code> is set to <code>AccuracyBased</code> filtering, Amazon Location uses the default value <code>{ "Horizontal": 0}</code> when accuracy is not provided on a <code>DevicePositionUpdate</code>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchUpdateDevicePosition {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_update_device_position_input::Builder,
    }
    impl BatchUpdateDevicePosition {
        /// Creates a new `BatchUpdateDevicePosition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchUpdateDevicePositionOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchUpdateDevicePositionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the tracker resource to update.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(input.into());
            self
        }
        /// <p>The name of the tracker resource to update.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>Contains the position update details for each device.</p>
        pub fn updates(mut self, input: crate::model::DevicePositionUpdate) -> Self {
            self.inner = self.inner.updates(input);
            self
        }
        /// <p>Contains the position update details for each device.</p>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DevicePositionUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CalculateRoute`.
    ///
    /// <p> <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html">Calculates a route</a> given the following required parameters: <code>DeparturePosition</code> and <code>DestinationPosition</code>. Requires that you first <a href="https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html">create a route calculator resource</a>.</p>
    /// <p>By default, a request that doesn't specify a departure time uses the best time of day to travel with the best traffic conditions when calculating the route.</p>
    /// <p>Additional options include:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/location/latest/developerguide/departure-time.html">Specifying a departure time</a> using either <code>DepartureTime</code> or <code>DepartNow</code>. This calculates a route based on predictive traffic data at the given time. </p> <note>
    /// <p>You can't specify both <code>DepartureTime</code> and <code>DepartNow</code> in a single request. Specifying both parameters returns a validation error.</p>
    /// </note> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/location/latest/developerguide/travel-mode.html">Specifying a travel mode</a> using TravelMode sets the transportation mode used to calculate the routes. This also lets you specify additional route preferences in <code>CarModeOptions</code> if traveling by <code>Car</code>, or <code>TruckModeOptions</code> if traveling by <code>Truck</code>.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CalculateRoute {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::calculate_route_input::Builder,
    }
    impl CalculateRoute {
        /// Creates a new `CalculateRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CalculateRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::CalculateRouteError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the route calculator resource that you want to use to calculate the route. </p>
        pub fn calculator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.calculator_name(input.into());
            self
        }
        /// <p>The name of the route calculator resource that you want to use to calculate the route. </p>
        pub fn set_calculator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_calculator_name(input);
            self
        }
        /// Appends an item to `DeparturePosition`.
        ///
        /// To override the contents of this collection use [`set_departure_position`](Self::set_departure_position).
        ///
        /// <p>The start position for the route. Defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>.</p>
        /// <ul>
        /// <li> <p>For example, <code>[-123.115, 49.285]</code> </p> </li>
        /// </ul> <note>
        /// <p>If you specify a departure that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. If Esri is the provider for your route calculator, specifying a route that is longer than 400 km returns a <code>400 RoutesValidationException</code> error.</p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
        pub fn departure_position(mut self, input: f64) -> Self {
            self.inner = self.inner.departure_position(input);
            self
        }
        /// <p>The start position for the route. Defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>.</p>
        /// <ul>
        /// <li> <p>For example, <code>[-123.115, 49.285]</code> </p> </li>
        /// </ul> <note>
        /// <p>If you specify a departure that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. If Esri is the provider for your route calculator, specifying a route that is longer than 400 km returns a <code>400 RoutesValidationException</code> error.</p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
        pub fn set_departure_position(
            mut self,
            input: std::option::Option<std::vec::Vec<f64>>,
        ) -> Self {
            self.inner = self.inner.set_departure_position(input);
            self
        }
        /// Appends an item to `DestinationPosition`.
        ///
        /// To override the contents of this collection use [`set_destination_position`](Self::set_destination_position).
        ///
        /// <p>The finish position for the route. Defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>.</p>
        /// <ul>
        /// <li> <p> For example, <code>[-122.339, 47.615]</code> </p> </li>
        /// </ul> <note>
        /// <p>If you specify a destination that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. </p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
        pub fn destination_position(mut self, input: f64) -> Self {
            self.inner = self.inner.destination_position(input);
            self
        }
        /// <p>The finish position for the route. Defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>.</p>
        /// <ul>
        /// <li> <p> For example, <code>[-122.339, 47.615]</code> </p> </li>
        /// </ul> <note>
        /// <p>If you specify a destination that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. </p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
        pub fn set_destination_position(
            mut self,
            input: std::option::Option<std::vec::Vec<f64>>,
        ) -> Self {
            self.inner = self.inner.set_destination_position(input);
            self
        }
        /// Appends an item to `WaypointPositions`.
        ///
        /// To override the contents of this collection use [`set_waypoint_positions`](Self::set_waypoint_positions).
        ///
        /// <p>Specifies an ordered list of up to 23 intermediate positions to include along a route between the departure position and destination position. </p>
        /// <ul>
        /// <li> <p>For example, from the <code>DeparturePosition</code> <code>[-123.115, 49.285]</code>, the route follows the order that the waypoint positions are given <code>[[-122.757, 49.0021],[-122.349, 47.620]]</code> </p> </li>
        /// </ul> <note>
        /// <p>If you specify a waypoint position that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. </p>
        /// <p>Specifying more than 23 waypoints returns a <code>400 ValidationException</code> error.</p>
        /// <p>If Esri is the provider for your route calculator, specifying a route that is longer than 400 km returns a <code>400 RoutesValidationException</code> error.</p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
        pub fn waypoint_positions(mut self, input: std::vec::Vec<f64>) -> Self {
            self.inner = self.inner.waypoint_positions(input);
            self
        }
        /// <p>Specifies an ordered list of up to 23 intermediate positions to include along a route between the departure position and destination position. </p>
        /// <ul>
        /// <li> <p>For example, from the <code>DeparturePosition</code> <code>[-123.115, 49.285]</code>, the route follows the order that the waypoint positions are given <code>[[-122.757, 49.0021],[-122.349, 47.620]]</code> </p> </li>
        /// </ul> <note>
        /// <p>If you specify a waypoint position that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. </p>
        /// <p>Specifying more than 23 waypoints returns a <code>400 ValidationException</code> error.</p>
        /// <p>If Esri is the provider for your route calculator, specifying a route that is longer than 400 km returns a <code>400 RoutesValidationException</code> error.</p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
        pub fn set_waypoint_positions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<f64>>>,
        ) -> Self {
            self.inner = self.inner.set_waypoint_positions(input);
            self
        }
        /// <p>Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road compatibility.</p>
        /// <p>The <code>TravelMode</code> you specify also determines how you specify route preferences: </p>
        /// <ul>
        /// <li> <p>If traveling by <code>Car</code> use the <code>CarModeOptions</code> parameter.</p> </li>
        /// <li> <p>If traveling by <code>Truck</code> use the <code>TruckModeOptions</code> parameter.</p> </li>
        /// </ul>
        /// <p>Default Value: <code>Car</code> </p>
        pub fn travel_mode(mut self, input: crate::model::TravelMode) -> Self {
            self.inner = self.inner.travel_mode(input);
            self
        }
        /// <p>Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road compatibility.</p>
        /// <p>The <code>TravelMode</code> you specify also determines how you specify route preferences: </p>
        /// <ul>
        /// <li> <p>If traveling by <code>Car</code> use the <code>CarModeOptions</code> parameter.</p> </li>
        /// <li> <p>If traveling by <code>Truck</code> use the <code>TruckModeOptions</code> parameter.</p> </li>
        /// </ul>
        /// <p>Default Value: <code>Car</code> </p>
        pub fn set_travel_mode(
            mut self,
            input: std::option::Option<crate::model::TravelMode>,
        ) -> Self {
            self.inner = self.inner.set_travel_mode(input);
            self
        }
        /// <p>Specifies the desired time of departure. Uses the given time to calculate the route. Otherwise, the best time of day to travel with the best traffic conditions is used to calculate the route.</p> <note>
        /// <p>Setting a departure time in the past returns a <code>400 ValidationException</code> error.</p>
        /// </note>
        /// <ul>
        /// <li> <p>In <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
        /// </ul>
        pub fn departure_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.departure_time(input);
            self
        }
        /// <p>Specifies the desired time of departure. Uses the given time to calculate the route. Otherwise, the best time of day to travel with the best traffic conditions is used to calculate the route.</p> <note>
        /// <p>Setting a departure time in the past returns a <code>400 ValidationException</code> error.</p>
        /// </note>
        /// <ul>
        /// <li> <p>In <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
        /// </ul>
        pub fn set_departure_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_departure_time(input);
            self
        }
        /// <p>Sets the time of departure as the current time. Uses the current time to calculate a route. Otherwise, the best time of day to travel with the best traffic conditions is used to calculate the route.</p>
        /// <p>Default Value: <code>false</code> </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
        pub fn depart_now(mut self, input: bool) -> Self {
            self.inner = self.inner.depart_now(input);
            self
        }
        /// <p>Sets the time of departure as the current time. Uses the current time to calculate a route. Otherwise, the best time of day to travel with the best traffic conditions is used to calculate the route.</p>
        /// <p>Default Value: <code>false</code> </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
        pub fn set_depart_now(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_depart_now(input);
            self
        }
        /// <p>Set the unit system to specify the distance.</p>
        /// <p>Default Value: <code>Kilometers</code> </p>
        pub fn distance_unit(mut self, input: crate::model::DistanceUnit) -> Self {
            self.inner = self.inner.distance_unit(input);
            self
        }
        /// <p>Set the unit system to specify the distance.</p>
        /// <p>Default Value: <code>Kilometers</code> </p>
        pub fn set_distance_unit(
            mut self,
            input: std::option::Option<crate::model::DistanceUnit>,
        ) -> Self {
            self.inner = self.inner.set_distance_unit(input);
            self
        }
        /// <p>Set to include the geometry details in the result for each path between a pair of positions.</p>
        /// <p>Default Value: <code>false</code> </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
        pub fn include_leg_geometry(mut self, input: bool) -> Self {
            self.inner = self.inner.include_leg_geometry(input);
            self
        }
        /// <p>Set to include the geometry details in the result for each path between a pair of positions.</p>
        /// <p>Default Value: <code>false</code> </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
        pub fn set_include_leg_geometry(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_leg_geometry(input);
            self
        }
        /// <p>Specifies route preferences when traveling by <code>Car</code>, such as avoiding routes that use ferries or tolls.</p>
        /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Car</code>.</p>
        pub fn car_mode_options(
            mut self,
            input: crate::model::CalculateRouteCarModeOptions,
        ) -> Self {
            self.inner = self.inner.car_mode_options(input);
            self
        }
        /// <p>Specifies route preferences when traveling by <code>Car</code>, such as avoiding routes that use ferries or tolls.</p>
        /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Car</code>.</p>
        pub fn set_car_mode_options(
            mut self,
            input: std::option::Option<crate::model::CalculateRouteCarModeOptions>,
        ) -> Self {
            self.inner = self.inner.set_car_mode_options(input);
            self
        }
        /// <p>Specifies route preferences when traveling by <code>Truck</code>, such as avoiding routes that use ferries or tolls, and truck specifications to consider when choosing an optimal road.</p>
        /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Truck</code>.</p>
        pub fn truck_mode_options(
            mut self,
            input: crate::model::CalculateRouteTruckModeOptions,
        ) -> Self {
            self.inner = self.inner.truck_mode_options(input);
            self
        }
        /// <p>Specifies route preferences when traveling by <code>Truck</code>, such as avoiding routes that use ferries or tolls, and truck specifications to consider when choosing an optimal road.</p>
        /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Truck</code>.</p>
        pub fn set_truck_mode_options(
            mut self,
            input: std::option::Option<crate::model::CalculateRouteTruckModeOptions>,
        ) -> Self {
            self.inner = self.inner.set_truck_mode_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CalculateRouteMatrix`.
    ///
    /// <p> <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html"> Calculates a route matrix</a> given the following required parameters: <code>DeparturePositions</code> and <code>DestinationPositions</code>. <code>CalculateRouteMatrix</code> calculates routes and returns the travel time and travel distance from each departure position to each destination position in the request. For example, given departure positions A and B, and destination positions X and Y, <code>CalculateRouteMatrix</code> will return time and distance for routes from A to X, A to Y, B to X, and B to Y (in that order). The number of results returned (and routes calculated) will be the number of <code>DeparturePositions</code> times the number of <code>DestinationPositions</code>.</p> <note>
    /// <p>Your account is charged for each route calculated, not the number of requests.</p>
    /// </note>
    /// <p>Requires that you first <a href="https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html">create a route calculator resource</a>.</p>
    /// <p>By default, a request that doesn't specify a departure time uses the best time of day to travel with the best traffic conditions when calculating routes.</p>
    /// <p>Additional options include:</p>
    /// <ul>
    /// <li> <p> <a href="https://docs.aws.amazon.com/location/latest/developerguide/departure-time.html"> Specifying a departure time</a> using either <code>DepartureTime</code> or <code>DepartNow</code>. This calculates routes based on predictive traffic data at the given time. </p> <note>
    /// <p>You can't specify both <code>DepartureTime</code> and <code>DepartNow</code> in a single request. Specifying both parameters returns a validation error.</p>
    /// </note> </li>
    /// <li> <p> <a href="https://docs.aws.amazon.com/location/latest/developerguide/travel-mode.html">Specifying a travel mode</a> using TravelMode sets the transportation mode used to calculate the routes. This also lets you specify additional route preferences in <code>CarModeOptions</code> if traveling by <code>Car</code>, or <code>TruckModeOptions</code> if traveling by <code>Truck</code>.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CalculateRouteMatrix {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::calculate_route_matrix_input::Builder,
    }
    impl CalculateRouteMatrix {
        /// Creates a new `CalculateRouteMatrix`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CalculateRouteMatrixOutput,
            aws_smithy_http::result::SdkError<crate::error::CalculateRouteMatrixError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the route calculator resource that you want to use to calculate the route matrix. </p>
        pub fn calculator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.calculator_name(input.into());
            self
        }
        /// <p>The name of the route calculator resource that you want to use to calculate the route matrix. </p>
        pub fn set_calculator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_calculator_name(input);
            self
        }
        /// Appends an item to `DeparturePositions`.
        ///
        /// To override the contents of this collection use [`set_departure_positions`](Self::set_departure_positions).
        ///
        /// <p>The list of departure (origin) positions for the route matrix. An array of points, each of which is itself a 2-value array defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>. For example, <code>[-123.115, 49.285]</code>.</p> <important>
        /// <p>Depending on the data provider selected in the route calculator resource there may be additional restrictions on the inputs you can choose. See <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits"> Position restrictions</a> in the <i>Amazon Location Service Developer Guide</i>.</p>
        /// </important> <note>
        /// <p>For route calculators that use Esri as the data provider, if you specify a departure that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html"> moves the position to the nearest road</a>. The snapped value is available in the result in <code>SnappedDeparturePositions</code>.</p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
        pub fn departure_positions(mut self, input: std::vec::Vec<f64>) -> Self {
            self.inner = self.inner.departure_positions(input);
            self
        }
        /// <p>The list of departure (origin) positions for the route matrix. An array of points, each of which is itself a 2-value array defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>. For example, <code>[-123.115, 49.285]</code>.</p> <important>
        /// <p>Depending on the data provider selected in the route calculator resource there may be additional restrictions on the inputs you can choose. See <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits"> Position restrictions</a> in the <i>Amazon Location Service Developer Guide</i>.</p>
        /// </important> <note>
        /// <p>For route calculators that use Esri as the data provider, if you specify a departure that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html"> moves the position to the nearest road</a>. The snapped value is available in the result in <code>SnappedDeparturePositions</code>.</p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
        pub fn set_departure_positions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<f64>>>,
        ) -> Self {
            self.inner = self.inner.set_departure_positions(input);
            self
        }
        /// Appends an item to `DestinationPositions`.
        ///
        /// To override the contents of this collection use [`set_destination_positions`](Self::set_destination_positions).
        ///
        /// <p>The list of destination positions for the route matrix. An array of points, each of which is itself a 2-value array defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>. For example, <code>[-122.339, 47.615]</code> </p> <important>
        /// <p>Depending on the data provider selected in the route calculator resource there may be additional restrictions on the inputs you can choose. See <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits"> Position restrictions</a> in the <i>Amazon Location Service Developer Guide</i>.</p>
        /// </important> <note>
        /// <p>For route calculators that use Esri as the data provider, if you specify a destination that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html"> moves the position to the nearest road</a>. The snapped value is available in the result in <code>SnappedDestinationPositions</code>.</p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
        pub fn destination_positions(mut self, input: std::vec::Vec<f64>) -> Self {
            self.inner = self.inner.destination_positions(input);
            self
        }
        /// <p>The list of destination positions for the route matrix. An array of points, each of which is itself a 2-value array defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>. For example, <code>[-122.339, 47.615]</code> </p> <important>
        /// <p>Depending on the data provider selected in the route calculator resource there may be additional restrictions on the inputs you can choose. See <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits"> Position restrictions</a> in the <i>Amazon Location Service Developer Guide</i>.</p>
        /// </important> <note>
        /// <p>For route calculators that use Esri as the data provider, if you specify a destination that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html"> moves the position to the nearest road</a>. The snapped value is available in the result in <code>SnappedDestinationPositions</code>.</p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
        pub fn set_destination_positions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<f64>>>,
        ) -> Self {
            self.inner = self.inner.set_destination_positions(input);
            self
        }
        /// <p>Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road compatibility.</p>
        /// <p>The <code>TravelMode</code> you specify also determines how you specify route preferences: </p>
        /// <ul>
        /// <li> <p>If traveling by <code>Car</code> use the <code>CarModeOptions</code> parameter.</p> </li>
        /// <li> <p>If traveling by <code>Truck</code> use the <code>TruckModeOptions</code> parameter.</p> </li>
        /// </ul>
        /// <p>Default Value: <code>Car</code> </p>
        pub fn travel_mode(mut self, input: crate::model::TravelMode) -> Self {
            self.inner = self.inner.travel_mode(input);
            self
        }
        /// <p>Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road compatibility.</p>
        /// <p>The <code>TravelMode</code> you specify also determines how you specify route preferences: </p>
        /// <ul>
        /// <li> <p>If traveling by <code>Car</code> use the <code>CarModeOptions</code> parameter.</p> </li>
        /// <li> <p>If traveling by <code>Truck</code> use the <code>TruckModeOptions</code> parameter.</p> </li>
        /// </ul>
        /// <p>Default Value: <code>Car</code> </p>
        pub fn set_travel_mode(
            mut self,
            input: std::option::Option<crate::model::TravelMode>,
        ) -> Self {
            self.inner = self.inner.set_travel_mode(input);
            self
        }
        /// <p>Specifies the desired time of departure. Uses the given time to calculate the route matrix. You can't set both <code>DepartureTime</code> and <code>DepartNow</code>. If neither is set, the best time of day to travel with the best traffic conditions is used to calculate the route matrix.</p> <note>
        /// <p>Setting a departure time in the past returns a <code>400 ValidationException</code> error.</p>
        /// </note>
        /// <ul>
        /// <li> <p>In <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
        /// </ul>
        pub fn departure_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.departure_time(input);
            self
        }
        /// <p>Specifies the desired time of departure. Uses the given time to calculate the route matrix. You can't set both <code>DepartureTime</code> and <code>DepartNow</code>. If neither is set, the best time of day to travel with the best traffic conditions is used to calculate the route matrix.</p> <note>
        /// <p>Setting a departure time in the past returns a <code>400 ValidationException</code> error.</p>
        /// </note>
        /// <ul>
        /// <li> <p>In <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
        /// </ul>
        pub fn set_departure_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_departure_time(input);
            self
        }
        /// <p>Sets the time of departure as the current time. Uses the current time to calculate the route matrix. You can't set both <code>DepartureTime</code> and <code>DepartNow</code>. If neither is set, the best time of day to travel with the best traffic conditions is used to calculate the route matrix.</p>
        /// <p>Default Value: <code>false</code> </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
        pub fn depart_now(mut self, input: bool) -> Self {
            self.inner = self.inner.depart_now(input);
            self
        }
        /// <p>Sets the time of departure as the current time. Uses the current time to calculate the route matrix. You can't set both <code>DepartureTime</code> and <code>DepartNow</code>. If neither is set, the best time of day to travel with the best traffic conditions is used to calculate the route matrix.</p>
        /// <p>Default Value: <code>false</code> </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
        pub fn set_depart_now(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_depart_now(input);
            self
        }
        /// <p>Set the unit system to specify the distance.</p>
        /// <p>Default Value: <code>Kilometers</code> </p>
        pub fn distance_unit(mut self, input: crate::model::DistanceUnit) -> Self {
            self.inner = self.inner.distance_unit(input);
            self
        }
        /// <p>Set the unit system to specify the distance.</p>
        /// <p>Default Value: <code>Kilometers</code> </p>
        pub fn set_distance_unit(
            mut self,
            input: std::option::Option<crate::model::DistanceUnit>,
        ) -> Self {
            self.inner = self.inner.set_distance_unit(input);
            self
        }
        /// <p>Specifies route preferences when traveling by <code>Car</code>, such as avoiding routes that use ferries or tolls.</p>
        /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Car</code>.</p>
        pub fn car_mode_options(
            mut self,
            input: crate::model::CalculateRouteCarModeOptions,
        ) -> Self {
            self.inner = self.inner.car_mode_options(input);
            self
        }
        /// <p>Specifies route preferences when traveling by <code>Car</code>, such as avoiding routes that use ferries or tolls.</p>
        /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Car</code>.</p>
        pub fn set_car_mode_options(
            mut self,
            input: std::option::Option<crate::model::CalculateRouteCarModeOptions>,
        ) -> Self {
            self.inner = self.inner.set_car_mode_options(input);
            self
        }
        /// <p>Specifies route preferences when traveling by <code>Truck</code>, such as avoiding routes that use ferries or tolls, and truck specifications to consider when choosing an optimal road.</p>
        /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Truck</code>.</p>
        pub fn truck_mode_options(
            mut self,
            input: crate::model::CalculateRouteTruckModeOptions,
        ) -> Self {
            self.inner = self.inner.truck_mode_options(input);
            self
        }
        /// <p>Specifies route preferences when traveling by <code>Truck</code>, such as avoiding routes that use ferries or tolls, and truck specifications to consider when choosing an optimal road.</p>
        /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Truck</code>.</p>
        pub fn set_truck_mode_options(
            mut self,
            input: std::option::Option<crate::model::CalculateRouteTruckModeOptions>,
        ) -> Self {
            self.inner = self.inner.set_truck_mode_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGeofenceCollection`.
    ///
    /// <p>Creates a geofence collection, which manages and stores geofences.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateGeofenceCollection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_geofence_collection_input::Builder,
    }
    impl CreateGeofenceCollection {
        /// Creates a new `CreateGeofenceCollection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGeofenceCollectionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGeofenceCollectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A custom name for the geofence collection.</p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li> <p>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_). </p> </li>
        /// <li> <p>Must be a unique geofence collection name.</p> </li>
        /// <li> <p>No spaces allowed. For example, <code>ExampleGeofenceCollection</code>.</p> </li>
        /// </ul>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_name(input.into());
            self
        }
        /// <p>A custom name for the geofence collection.</p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li> <p>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_). </p> </li>
        /// <li> <p>Must be a unique geofence collection name.</p> </li>
        /// <li> <p>No spaces allowed. For example, <code>ExampleGeofenceCollection</code>.</p> </li>
        /// </ul>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_name(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.inner = self.inner.pricing_plan(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan(input);
            self
        }
        /// <p>This parameter is no longer used.</p>
        pub fn pricing_plan_data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pricing_plan_data_source(input.into());
            self
        }
        /// <p>This parameter is no longer used.</p>
        pub fn set_pricing_plan_data_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan_data_source(input);
            self
        }
        /// <p>An optional description for the geofence collection.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description for the geofence collection.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Applies one or more tags to the geofence collection. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource</p> </li>
        /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Applies one or more tags to the geofence collection. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource</p> </li>
        /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN. </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN. </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMap`.
    ///
    /// <p>Creates a map resource in your AWS account, which provides map tiles of different styles sourced from global location data providers.</p> <note>
    /// <p>If your application is tracking or routing assets you use in your business, such as delivery vehicles or employees, you may only use HERE as your geolocation provider. See section 82 of the <a href="http://aws.amazon.com/service-terms">AWS service terms</a> for more details.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMap {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_map_input::Builder,
    }
    impl CreateMap {
        /// Creates a new `CreateMap`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMapOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMapError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the map resource.</p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li> <p>Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_). </p> </li>
        /// <li> <p>Must be a unique map resource name. </p> </li>
        /// <li> <p>No spaces allowed. For example, <code>ExampleMap</code>.</p> </li>
        /// </ul>
        pub fn map_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.map_name(input.into());
            self
        }
        /// <p>The name for the map resource.</p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li> <p>Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_). </p> </li>
        /// <li> <p>Must be a unique map resource name. </p> </li>
        /// <li> <p>No spaces allowed. For example, <code>ExampleMap</code>.</p> </li>
        /// </ul>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_map_name(input);
            self
        }
        /// <p>Specifies the map style selected from an available data provider.</p>
        pub fn configuration(mut self, input: crate::model::MapConfiguration) -> Self {
            self.inner = self.inner.configuration(input);
            self
        }
        /// <p>Specifies the map style selected from an available data provider.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::MapConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.inner = self.inner.pricing_plan(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan(input);
            self
        }
        /// <p>An optional description for the map resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description for the map resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Applies one or more tags to the map resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource</p> </li>
        /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Applies one or more tags to the map resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource</p> </li>
        /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePlaceIndex`.
    ///
    /// <p>Creates a place index resource in your AWS account. Use a place index resource to geocode addresses and other text queries by using the <code>SearchPlaceIndexForText</code> operation, and reverse geocode coordinates by using the <code>SearchPlaceIndexForPosition</code> operation, and enable autosuggestions by using the <code>SearchPlaceIndexForSuggestions</code> operation.</p> <note>
    /// <p>If your application is tracking or routing assets you use in your business, such as delivery vehicles or employees, you may only use HERE as your geolocation provider. See section 82 of the <a href="http://aws.amazon.com/service-terms">AWS service terms</a> for more details.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreatePlaceIndex {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_place_index_input::Builder,
    }
    impl CreatePlaceIndex {
        /// Creates a new `CreatePlaceIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePlaceIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePlaceIndexError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the place index resource. </p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li> <p>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).</p> </li>
        /// <li> <p>Must be a unique place index resource name.</p> </li>
        /// <li> <p>No spaces allowed. For example, <code>ExamplePlaceIndex</code>.</p> </li>
        /// </ul>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(input.into());
            self
        }
        /// <p>The name of the place index resource. </p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li> <p>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).</p> </li>
        /// <li> <p>Must be a unique place index resource name.</p> </li>
        /// <li> <p>No spaces allowed. For example, <code>ExamplePlaceIndex</code>.</p> </li>
        /// </ul>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// <p>Specifies the geospatial data provider for the new place index.</p> <note>
        /// <p>This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> returns an error.</p>
        /// </note>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>Esri</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>'s coverage in your region of interest, see <a href="https://developers.arcgis.com/rest/geocode/api-reference/geocode-coverage.htm">Esri details on geocoding coverage</a>.</p> </li>
        /// <li> <p> <code>Here</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a>' coverage in your region of interest, see <a href="https://developer.here.com/documentation/geocoder/dev_guide/topics/coverage-geocoder.html">HERE details on goecoding coverage</a>.</p> <important>
        /// <p>If you specify HERE Technologies (<code>Here</code>) as the data provider, you may not <a href="https://docs.aws.amazon.com/location-places/latest/APIReference/API_DataSourceConfiguration.html">store results</a> for locations in Japan. For more information, see the <a href="https://aws.amazon.com/service-terms/">AWS Service Terms</a> for Amazon Location Service.</p>
        /// </important> </li>
        /// </ul>
        /// <p>For additional information , see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data providers</a> on the <i>Amazon Location Service Developer Guide</i>.</p>
        pub fn data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source(input.into());
            self
        }
        /// <p>Specifies the geospatial data provider for the new place index.</p> <note>
        /// <p>This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> returns an error.</p>
        /// </note>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>Esri</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>'s coverage in your region of interest, see <a href="https://developers.arcgis.com/rest/geocode/api-reference/geocode-coverage.htm">Esri details on geocoding coverage</a>.</p> </li>
        /// <li> <p> <code>Here</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a>' coverage in your region of interest, see <a href="https://developer.here.com/documentation/geocoder/dev_guide/topics/coverage-geocoder.html">HERE details on goecoding coverage</a>.</p> <important>
        /// <p>If you specify HERE Technologies (<code>Here</code>) as the data provider, you may not <a href="https://docs.aws.amazon.com/location-places/latest/APIReference/API_DataSourceConfiguration.html">store results</a> for locations in Japan. For more information, see the <a href="https://aws.amazon.com/service-terms/">AWS Service Terms</a> for Amazon Location Service.</p>
        /// </important> </li>
        /// </ul>
        /// <p>For additional information , see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data providers</a> on the <i>Amazon Location Service Developer Guide</i>.</p>
        pub fn set_data_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_source(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.inner = self.inner.pricing_plan(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan(input);
            self
        }
        /// <p>The optional description for the place index resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The optional description for the place index resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Specifies the data storage option requesting Places.</p>
        pub fn data_source_configuration(
            mut self,
            input: crate::model::DataSourceConfiguration,
        ) -> Self {
            self.inner = self.inner.data_source_configuration(input);
            self
        }
        /// <p>Specifies the data storage option requesting Places.</p>
        pub fn set_data_source_configuration(
            mut self,
            input: std::option::Option<crate::model::DataSourceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_data_source_configuration(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Applies one or more tags to the place index resource. A tag is a key-value pair that helps you manage, identify, search, and filter your resources.</p>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource.</p> </li>
        /// <li> <p>Each tag key must be unique and must have exactly one associated value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8.</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8.</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @</p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Applies one or more tags to the place index resource. A tag is a key-value pair that helps you manage, identify, search, and filter your resources.</p>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource.</p> </li>
        /// <li> <p>Each tag key must be unique and must have exactly one associated value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8.</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8.</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @</p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRouteCalculator`.
    ///
    /// <p>Creates a route calculator resource in your AWS account.</p>
    /// <p>You can send requests to a route calculator resource to estimate travel time, distance, and get directions. A route calculator sources traffic and road network data from your chosen data provider.</p> <note>
    /// <p>If your application is tracking or routing assets you use in your business, such as delivery vehicles or employees, you may only use HERE as your geolocation provider. See section 82 of the <a href="http://aws.amazon.com/service-terms">AWS service terms</a> for more details.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRouteCalculator {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_route_calculator_input::Builder,
    }
    impl CreateRouteCalculator {
        /// Creates a new `CreateRouteCalculator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRouteCalculatorOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRouteCalculatorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the route calculator resource. </p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).</p> </li>
        /// <li> <p>Must be a unique Route calculator resource name.</p> </li>
        /// <li> <p>No spaces allowed. For example, <code>ExampleRouteCalculator</code>.</p> </li>
        /// </ul>
        pub fn calculator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.calculator_name(input.into());
            self
        }
        /// <p>The name of the route calculator resource. </p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).</p> </li>
        /// <li> <p>Must be a unique Route calculator resource name.</p> </li>
        /// <li> <p>No spaces allowed. For example, <code>ExampleRouteCalculator</code>.</p> </li>
        /// </ul>
        pub fn set_calculator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_calculator_name(input);
            self
        }
        /// <p>Specifies the data provider of traffic and road network data.</p> <note>
        /// <p>This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> returns an error. Route calculators that use Esri as a data source only calculate routes that are shorter than 400 km.</p>
        /// </note>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>Esri</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>'s coverage in your region of interest, see <a href="https://doc.arcgis.com/en/arcgis-online/reference/network-coverage.htm">Esri details on street networks and traffic coverage</a>.</p> </li>
        /// <li> <p> <code>Here</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a>' coverage in your region of interest, see <a href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/car-routing.html">HERE car routing coverage</a> and <a href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/truck-routing.html">HERE truck routing coverage</a>.</p> </li>
        /// </ul>
        /// <p>For additional information , see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data providers</a> on the <i>Amazon Location Service Developer Guide</i>.</p>
        pub fn data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source(input.into());
            self
        }
        /// <p>Specifies the data provider of traffic and road network data.</p> <note>
        /// <p>This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> returns an error. Route calculators that use Esri as a data source only calculate routes that are shorter than 400 km.</p>
        /// </note>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>Esri</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>'s coverage in your region of interest, see <a href="https://doc.arcgis.com/en/arcgis-online/reference/network-coverage.htm">Esri details on street networks and traffic coverage</a>.</p> </li>
        /// <li> <p> <code>Here</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a>' coverage in your region of interest, see <a href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/car-routing.html">HERE car routing coverage</a> and <a href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/truck-routing.html">HERE truck routing coverage</a>.</p> </li>
        /// </ul>
        /// <p>For additional information , see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data providers</a> on the <i>Amazon Location Service Developer Guide</i>.</p>
        pub fn set_data_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_source(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.inner = self.inner.pricing_plan(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan(input);
            self
        }
        /// <p>The optional description for the route calculator resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The optional description for the route calculator resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Applies one or more tags to the route calculator resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
        /// <ul>
        /// <li> <p>For example: { <code>"tag1" : "value1"</code>, <code>"tag2" : "value2"</code>}</p> </li>
        /// </ul>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource</p> </li>
        /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Applies one or more tags to the route calculator resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
        /// <ul>
        /// <li> <p>For example: { <code>"tag1" : "value1"</code>, <code>"tag2" : "value2"</code>}</p> </li>
        /// </ul>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource</p> </li>
        /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTracker`.
    ///
    /// <p>Creates a tracker resource in your AWS account, which lets you retrieve current and historical location of devices.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTracker {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_tracker_input::Builder,
    }
    impl CreateTracker {
        /// Creates a new `CreateTracker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTrackerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTrackerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the tracker resource.</p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li> <p>Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).</p> </li>
        /// <li> <p>Must be a unique tracker resource name.</p> </li>
        /// <li> <p>No spaces allowed. For example, <code>ExampleTracker</code>.</p> </li>
        /// </ul>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(input.into());
            self
        }
        /// <p>The name for the tracker resource.</p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li> <p>Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).</p> </li>
        /// <li> <p>Must be a unique tracker resource name.</p> </li>
        /// <li> <p>No spaces allowed. For example, <code>ExampleTracker</code>.</p> </li>
        /// </ul>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.inner = self.inner.pricing_plan(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan(input);
            self
        }
        /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>This parameter is no longer used.</p>
        pub fn pricing_plan_data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pricing_plan_data_source(input.into());
            self
        }
        /// <p>This parameter is no longer used.</p>
        pub fn set_pricing_plan_data_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan_data_source(input);
            self
        }
        /// <p>An optional description for the tracker resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description for the tracker resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Applies one or more tags to the tracker resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource</p> </li>
        /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Applies one or more tags to the tracker resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource</p> </li>
        /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Specifies the position filtering for the tracker resource.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li> <p> <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID. </p> </li>
        /// <li> <p> <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this area are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map. </p> </li>
        /// <li> <p> <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This can reduce the effects of GPS noise when displaying device trajectories on a map, and can help control your costs by reducing the number of geofence evaluations. </p> </li>
        /// </ul>
        /// <p>This field is optional. If not specified, the default value is <code>TimeBased</code>.</p>
        pub fn position_filtering(mut self, input: crate::model::PositionFiltering) -> Self {
            self.inner = self.inner.position_filtering(input);
            self
        }
        /// <p>Specifies the position filtering for the tracker resource.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li> <p> <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID. </p> </li>
        /// <li> <p> <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this area are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map. </p> </li>
        /// <li> <p> <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This can reduce the effects of GPS noise when displaying device trajectories on a map, and can help control your costs by reducing the number of geofence evaluations. </p> </li>
        /// </ul>
        /// <p>This field is optional. If not specified, the default value is <code>TimeBased</code>.</p>
        pub fn set_position_filtering(
            mut self,
            input: std::option::Option<crate::model::PositionFiltering>,
        ) -> Self {
            self.inner = self.inner.set_position_filtering(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGeofenceCollection`.
    ///
    /// <p>Deletes a geofence collection from your AWS account.</p> <note>
    /// <p>This operation deletes the resource permanently. If the geofence collection is the target of a tracker resource, the devices will no longer be monitored.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteGeofenceCollection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_geofence_collection_input::Builder,
    }
    impl DeleteGeofenceCollection {
        /// Creates a new `DeleteGeofenceCollection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGeofenceCollectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGeofenceCollectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the geofence collection to be deleted.</p>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_name(input.into());
            self
        }
        /// <p>The name of the geofence collection to be deleted.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMap`.
    ///
    /// <p>Deletes a map resource from your AWS account.</p> <note>
    /// <p>This operation deletes the resource permanently. If the map is being used in an application, the map may not render.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMap {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_map_input::Builder,
    }
    impl DeleteMap {
        /// Creates a new `DeleteMap`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMapOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMapError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the map resource to be deleted.</p>
        pub fn map_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.map_name(input.into());
            self
        }
        /// <p>The name of the map resource to be deleted.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_map_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePlaceIndex`.
    ///
    /// <p>Deletes a place index resource from your AWS account.</p> <note>
    /// <p>This operation deletes the resource permanently.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePlaceIndex {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_place_index_input::Builder,
    }
    impl DeletePlaceIndex {
        /// Creates a new `DeletePlaceIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePlaceIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePlaceIndexError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the place index resource to be deleted.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(input.into());
            self
        }
        /// <p>The name of the place index resource to be deleted.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRouteCalculator`.
    ///
    /// <p>Deletes a route calculator resource from your AWS account.</p> <note>
    /// <p>This operation deletes the resource permanently.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRouteCalculator {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_route_calculator_input::Builder,
    }
    impl DeleteRouteCalculator {
        /// Creates a new `DeleteRouteCalculator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRouteCalculatorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRouteCalculatorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the route calculator resource to be deleted.</p>
        pub fn calculator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.calculator_name(input.into());
            self
        }
        /// <p>The name of the route calculator resource to be deleted.</p>
        pub fn set_calculator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_calculator_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTracker`.
    ///
    /// <p>Deletes a tracker resource from your AWS account.</p> <note>
    /// <p>This operation deletes the resource permanently. If the tracker resource is in use, you may encounter an error. Make sure that the target resource isn't a dependency for your applications.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTracker {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_tracker_input::Builder,
    }
    impl DeleteTracker {
        /// Creates a new `DeleteTracker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTrackerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTrackerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the tracker resource to be deleted.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(input.into());
            self
        }
        /// <p>The name of the tracker resource to be deleted.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeGeofenceCollection`.
    ///
    /// <p>Retrieves the geofence collection details.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeGeofenceCollection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_geofence_collection_input::Builder,
    }
    impl DescribeGeofenceCollection {
        /// Creates a new `DescribeGeofenceCollection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGeofenceCollectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeGeofenceCollectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the geofence collection.</p>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_name(input.into());
            self
        }
        /// <p>The name of the geofence collection.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMap`.
    ///
    /// <p>Retrieves the map resource details.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeMap {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_map_input::Builder,
    }
    impl DescribeMap {
        /// Creates a new `DescribeMap`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMapOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMapError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the map resource.</p>
        pub fn map_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.map_name(input.into());
            self
        }
        /// <p>The name of the map resource.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_map_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePlaceIndex`.
    ///
    /// <p>Retrieves the place index resource details.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePlaceIndex {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_place_index_input::Builder,
    }
    impl DescribePlaceIndex {
        /// Creates a new `DescribePlaceIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePlaceIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePlaceIndexError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the place index resource.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(input.into());
            self
        }
        /// <p>The name of the place index resource.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRouteCalculator`.
    ///
    /// <p>Retrieves the route calculator resource details.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRouteCalculator {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_route_calculator_input::Builder,
    }
    impl DescribeRouteCalculator {
        /// Creates a new `DescribeRouteCalculator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRouteCalculatorOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRouteCalculatorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the route calculator resource.</p>
        pub fn calculator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.calculator_name(input.into());
            self
        }
        /// <p>The name of the route calculator resource.</p>
        pub fn set_calculator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_calculator_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTracker`.
    ///
    /// <p>Retrieves the tracker resource details.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTracker {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_tracker_input::Builder,
    }
    impl DescribeTracker {
        /// Creates a new `DescribeTracker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTrackerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTrackerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the tracker resource.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(input.into());
            self
        }
        /// <p>The name of the tracker resource.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateTrackerConsumer`.
    ///
    /// <p>Removes the association between a tracker resource and a geofence collection.</p> <note>
    /// <p>Once you unlink a tracker resource from a geofence collection, the tracker positions will no longer be automatically evaluated against geofences.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateTrackerConsumer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_tracker_consumer_input::Builder,
    }
    impl DisassociateTrackerConsumer {
        /// Creates a new `DisassociateTrackerConsumer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateTrackerConsumerOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateTrackerConsumerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the tracker resource to be dissociated from the consumer.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(input.into());
            self
        }
        /// <p>The name of the tracker resource to be dissociated from the consumer.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the geofence collection to be disassociated from the tracker resource. Used when you need to specify a resource across all AWS. </p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code> </p> </li>
        /// </ul>
        pub fn consumer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.consumer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the geofence collection to be disassociated from the tracker resource. Used when you need to specify a resource across all AWS. </p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code> </p> </li>
        /// </ul>
        pub fn set_consumer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_consumer_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDevicePosition`.
    ///
    /// <p>Retrieves a device's most recent position according to its sample time.</p> <note>
    /// <p>Device positions are deleted after 30 days.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDevicePosition {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_device_position_input::Builder,
    }
    impl GetDevicePosition {
        /// Creates a new `GetDevicePosition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDevicePositionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDevicePositionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The tracker resource receiving the position update.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(input.into());
            self
        }
        /// <p>The tracker resource receiving the position update.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
        /// <p>The device whose position you want to retrieve.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The device whose position you want to retrieve.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDevicePositionHistory`.
    ///
    /// <p>Retrieves the device position history from a tracker resource within a specified range of time.</p> <note>
    /// <p>Device positions are deleted after 30 days.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDevicePositionHistory {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_device_position_history_input::Builder,
    }
    impl GetDevicePositionHistory {
        /// Creates a new `GetDevicePositionHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDevicePositionHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDevicePositionHistoryError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetDevicePositionHistoryPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetDevicePositionHistoryPaginator {
            crate::paginator::GetDevicePositionHistoryPaginator::new(self.handle, self.inner)
        }
        /// <p>The tracker resource receiving the request for the device position history.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(input.into());
            self
        }
        /// <p>The tracker resource receiving the request for the device position history.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
        /// <p>The device whose position history you want to retrieve.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(input.into());
            self
        }
        /// <p>The device whose position history you want to retrieve.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code> </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code> </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specify the start time for the position history in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be 24 hours prior to the time that the request is made.</p>
        /// <p>Requirement:</p>
        /// <ul>
        /// <li> <p>The time specified for <code>StartTimeInclusive</code> must be before <code>EndTimeExclusive</code>.</p> </li>
        /// </ul>
        pub fn start_time_inclusive(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time_inclusive(input);
            self
        }
        /// <p>Specify the start time for the position history in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be 24 hours prior to the time that the request is made.</p>
        /// <p>Requirement:</p>
        /// <ul>
        /// <li> <p>The time specified for <code>StartTimeInclusive</code> must be before <code>EndTimeExclusive</code>.</p> </li>
        /// </ul>
        pub fn set_start_time_inclusive(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time_inclusive(input);
            self
        }
        /// <p>Specify the end time for the position history in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be the time that the request is made.</p>
        /// <p>Requirement:</p>
        /// <ul>
        /// <li> <p>The time specified for <code>EndTimeExclusive</code> must be after the time for <code>StartTimeInclusive</code>.</p> </li>
        /// </ul>
        pub fn end_time_exclusive(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time_exclusive(input);
            self
        }
        /// <p>Specify the end time for the position history in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be the time that the request is made.</p>
        /// <p>Requirement:</p>
        /// <ul>
        /// <li> <p>The time specified for <code>EndTimeExclusive</code> must be after the time for <code>StartTimeInclusive</code>.</p> </li>
        /// </ul>
        pub fn set_end_time_exclusive(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time_exclusive(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGeofence`.
    ///
    /// <p>Retrieves the geofence details from a geofence collection.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetGeofence {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_geofence_input::Builder,
    }
    impl GetGeofence {
        /// Creates a new `GetGeofence`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGeofenceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGeofenceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The geofence collection storing the target geofence.</p>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_name(input.into());
            self
        }
        /// <p>The geofence collection storing the target geofence.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_name(input);
            self
        }
        /// <p>The geofence you're retrieving details for.</p>
        pub fn geofence_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.geofence_id(input.into());
            self
        }
        /// <p>The geofence you're retrieving details for.</p>
        pub fn set_geofence_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_geofence_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMapGlyphs`.
    ///
    /// <p>Retrieves glyphs used to display labels on a map.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMapGlyphs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_map_glyphs_input::Builder,
    }
    impl GetMapGlyphs {
        /// Creates a new `GetMapGlyphs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMapGlyphsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMapGlyphsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The map resource associated with the glyph ﬁle.</p>
        pub fn map_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.map_name(input.into());
            self
        }
        /// <p>The map resource associated with the glyph ﬁle.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_map_name(input);
            self
        }
        /// <p>A comma-separated list of fonts to load glyphs from in order of preference. For example, <code>Noto Sans Regular, Arial Unicode</code>.</p>
        /// <p>Valid fonts stacks for <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a> styles: </p>
        /// <ul>
        /// <li> <p>VectorEsriDarkGrayCanvas – <code>Ubuntu Medium Italic</code> | <code>Ubuntu Medium</code> | <code>Ubuntu Italic</code> | <code>Ubuntu Regular</code> | <code>Ubuntu Bold</code> </p> </li>
        /// <li> <p>VectorEsriLightGrayCanvas – <code>Ubuntu Italic</code> | <code>Ubuntu Regular</code> | <code>Ubuntu Light</code> | <code>Ubuntu Bold</code> </p> </li>
        /// <li> <p>VectorEsriTopographic – <code>Noto Sans Italic</code> | <code>Noto Sans Regular</code> | <code>Noto Sans Bold</code> | <code>Noto Serif Regular</code> | <code>Roboto Condensed Light Italic</code> </p> </li>
        /// <li> <p>VectorEsriStreets – <code>Arial Regular</code> | <code>Arial Italic</code> | <code>Arial Bold</code> </p> </li>
        /// <li> <p>VectorEsriNavigation – <code>Arial Regular</code> | <code>Arial Italic</code> | <code>Arial Bold</code> </p> </li>
        /// </ul>
        /// <p>Valid font stacks for <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a> styles: </p>
        /// <ul>
        /// <li> <p>VectorHereBerlin – <code>Fira GO Regular</code> | <code>Fira GO Bold</code> </p> </li>
        /// <li> <p>VectorHereExplore, VectorHereExploreTruck – <code>Firo GO Italic</code> | <code>Fira GO Map</code> | <code>Fira GO Map Bold</code> | <code>Noto Sans CJK JP Bold</code> | <code>Noto Sans CJK JP Light</code> | <code>Noto Sans CJK JP Regular</code> </p> </li>
        /// </ul>
        pub fn font_stack(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.font_stack(input.into());
            self
        }
        /// <p>A comma-separated list of fonts to load glyphs from in order of preference. For example, <code>Noto Sans Regular, Arial Unicode</code>.</p>
        /// <p>Valid fonts stacks for <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a> styles: </p>
        /// <ul>
        /// <li> <p>VectorEsriDarkGrayCanvas – <code>Ubuntu Medium Italic</code> | <code>Ubuntu Medium</code> | <code>Ubuntu Italic</code> | <code>Ubuntu Regular</code> | <code>Ubuntu Bold</code> </p> </li>
        /// <li> <p>VectorEsriLightGrayCanvas – <code>Ubuntu Italic</code> | <code>Ubuntu Regular</code> | <code>Ubuntu Light</code> | <code>Ubuntu Bold</code> </p> </li>
        /// <li> <p>VectorEsriTopographic – <code>Noto Sans Italic</code> | <code>Noto Sans Regular</code> | <code>Noto Sans Bold</code> | <code>Noto Serif Regular</code> | <code>Roboto Condensed Light Italic</code> </p> </li>
        /// <li> <p>VectorEsriStreets – <code>Arial Regular</code> | <code>Arial Italic</code> | <code>Arial Bold</code> </p> </li>
        /// <li> <p>VectorEsriNavigation – <code>Arial Regular</code> | <code>Arial Italic</code> | <code>Arial Bold</code> </p> </li>
        /// </ul>
        /// <p>Valid font stacks for <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a> styles: </p>
        /// <ul>
        /// <li> <p>VectorHereBerlin – <code>Fira GO Regular</code> | <code>Fira GO Bold</code> </p> </li>
        /// <li> <p>VectorHereExplore, VectorHereExploreTruck – <code>Firo GO Italic</code> | <code>Fira GO Map</code> | <code>Fira GO Map Bold</code> | <code>Noto Sans CJK JP Bold</code> | <code>Noto Sans CJK JP Light</code> | <code>Noto Sans CJK JP Regular</code> </p> </li>
        /// </ul>
        pub fn set_font_stack(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_font_stack(input);
            self
        }
        /// <p>A Unicode range of characters to download glyphs for. Each response will contain 256 characters. For example, 0–255 includes all characters from range <code>U+0000</code> to <code>00FF</code>. Must be aligned to multiples of 256.</p>
        pub fn font_unicode_range(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.font_unicode_range(input.into());
            self
        }
        /// <p>A Unicode range of characters to download glyphs for. Each response will contain 256 characters. For example, 0–255 includes all characters from range <code>U+0000</code> to <code>00FF</code>. Must be aligned to multiples of 256.</p>
        pub fn set_font_unicode_range(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_font_unicode_range(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMapSprites`.
    ///
    /// <p>Retrieves the sprite sheet corresponding to a map resource. The sprite sheet is a PNG image paired with a JSON document describing the offsets of individual icons that will be displayed on a rendered map.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMapSprites {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_map_sprites_input::Builder,
    }
    impl GetMapSprites {
        /// Creates a new `GetMapSprites`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMapSpritesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMapSpritesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The map resource associated with the sprite ﬁle.</p>
        pub fn map_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.map_name(input.into());
            self
        }
        /// <p>The map resource associated with the sprite ﬁle.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_map_name(input);
            self
        }
        /// <p>The name of the sprite ﬁle. Use the following ﬁle names for the sprite sheet:</p>
        /// <ul>
        /// <li> <p> <code>sprites.png</code> </p> </li>
        /// <li> <p> <code>sprites@2x.png</code> for high pixel density displays</p> </li>
        /// </ul>
        /// <p>For the JSON document contain image offsets. Use the following ﬁle names:</p>
        /// <ul>
        /// <li> <p> <code>sprites.json</code> </p> </li>
        /// <li> <p> <code>sprites@2x.json</code> for high pixel density displays</p> </li>
        /// </ul>
        pub fn file_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_name(input.into());
            self
        }
        /// <p>The name of the sprite ﬁle. Use the following ﬁle names for the sprite sheet:</p>
        /// <ul>
        /// <li> <p> <code>sprites.png</code> </p> </li>
        /// <li> <p> <code>sprites@2x.png</code> for high pixel density displays</p> </li>
        /// </ul>
        /// <p>For the JSON document contain image offsets. Use the following ﬁle names:</p>
        /// <ul>
        /// <li> <p> <code>sprites.json</code> </p> </li>
        /// <li> <p> <code>sprites@2x.json</code> for high pixel density displays</p> </li>
        /// </ul>
        pub fn set_file_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_file_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMapStyleDescriptor`.
    ///
    /// <p>Retrieves the map style descriptor from a map resource. </p>
    /// <p>The style descriptor contains speciﬁcations on how features render on a map. For example, what data to display, what order to display the data in, and the style for the data. Style descriptors follow the Mapbox Style Specification.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMapStyleDescriptor {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_map_style_descriptor_input::Builder,
    }
    impl GetMapStyleDescriptor {
        /// Creates a new `GetMapStyleDescriptor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMapStyleDescriptorOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMapStyleDescriptorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The map resource to retrieve the style descriptor from.</p>
        pub fn map_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.map_name(input.into());
            self
        }
        /// <p>The map resource to retrieve the style descriptor from.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_map_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMapTile`.
    ///
    /// <p>Retrieves a vector data tile from the map resource. Map tiles are used by clients to render a map. they're addressed using a grid arrangement with an X coordinate, Y coordinate, and Z (zoom) level. </p>
    /// <p>The origin (0, 0) is the top left of the map. Increasing the zoom level by 1 doubles both the X and Y dimensions, so a tile containing data for the entire world at (0/0/0) will be split into 4 tiles at zoom 1 (1/0/0, 1/0/1, 1/1/0, 1/1/1).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMapTile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_map_tile_input::Builder,
    }
    impl GetMapTile {
        /// Creates a new `GetMapTile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMapTileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMapTileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The map resource to retrieve the map tiles from.</p>
        pub fn map_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.map_name(input.into());
            self
        }
        /// <p>The map resource to retrieve the map tiles from.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_map_name(input);
            self
        }
        /// <p>The zoom value for the map tile.</p>
        pub fn z(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.z(input.into());
            self
        }
        /// <p>The zoom value for the map tile.</p>
        pub fn set_z(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_z(input);
            self
        }
        /// <p>The X axis value for the map tile.</p>
        pub fn x(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.x(input.into());
            self
        }
        /// <p>The X axis value for the map tile.</p>
        pub fn set_x(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_x(input);
            self
        }
        /// <p>The Y axis value for the map tile. </p>
        pub fn y(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.y(input.into());
            self
        }
        /// <p>The Y axis value for the map tile. </p>
        pub fn set_y(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_y(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDevicePositions`.
    ///
    /// <p>A batch request to retrieve all device positions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDevicePositions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_device_positions_input::Builder,
    }
    impl ListDevicePositions {
        /// Creates a new `ListDevicePositions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDevicePositionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDevicePositionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDevicePositionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDevicePositionsPaginator {
            crate::paginator::ListDevicePositionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The tracker resource containing the requested devices.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(input.into());
            self
        }
        /// <p>The tracker resource containing the requested devices.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
        /// <p>An optional limit for the number of entries returned in a single call.</p>
        /// <p>Default value: <code>100</code> </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>An optional limit for the number of entries returned in a single call.</p>
        /// <p>Default value: <code>100</code> </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
        /// <p>Default value: <code>null</code> </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
        /// <p>Default value: <code>null</code> </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGeofenceCollections`.
    ///
    /// <p>Lists geofence collections in your AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGeofenceCollections {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_geofence_collections_input::Builder,
    }
    impl ListGeofenceCollections {
        /// Creates a new `ListGeofenceCollections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGeofenceCollectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGeofenceCollectionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListGeofenceCollectionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListGeofenceCollectionsPaginator {
            crate::paginator::ListGeofenceCollectionsPaginator::new(self.handle, self.inner)
        }
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code> </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code> </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code> </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code> </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGeofences`.
    ///
    /// <p>Lists geofences stored in a given geofence collection.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListGeofences {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_geofences_input::Builder,
    }
    impl ListGeofences {
        /// Creates a new `ListGeofences`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGeofencesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGeofencesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListGeofencesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListGeofencesPaginator {
            crate::paginator::ListGeofencesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the geofence collection storing the list of geofences.</p>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_name(input.into());
            self
        }
        /// <p>The name of the geofence collection storing the list of geofences.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_name(input);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code> </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code> </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMaps`.
    ///
    /// <p>Lists map resources in your AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMaps {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_maps_input::Builder,
    }
    impl ListMaps {
        /// Creates a new `ListMaps`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMapsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMapsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMapsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListMapsPaginator {
            crate::paginator::ListMapsPaginator::new(self.handle, self.inner)
        }
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code> </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code> </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
        /// <p>Default value: <code>null</code> </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
        /// <p>Default value: <code>null</code> </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPlaceIndexes`.
    ///
    /// <p>Lists place index resources in your AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPlaceIndexes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_place_indexes_input::Builder,
    }
    impl ListPlaceIndexes {
        /// Creates a new `ListPlaceIndexes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPlaceIndexesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPlaceIndexesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPlaceIndexesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPlaceIndexesPaginator {
            crate::paginator::ListPlaceIndexesPaginator::new(self.handle, self.inner)
        }
        /// <p>An optional limit for the maximum number of results returned in a single call.</p>
        /// <p>Default value: <code>100</code> </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>An optional limit for the maximum number of results returned in a single call.</p>
        /// <p>Default value: <code>100</code> </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
        /// <p>Default value: <code>null</code> </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
        /// <p>Default value: <code>null</code> </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRouteCalculators`.
    ///
    /// <p>Lists route calculator resources in your AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRouteCalculators {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_route_calculators_input::Builder,
    }
    impl ListRouteCalculators {
        /// Creates a new `ListRouteCalculators`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRouteCalculatorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRouteCalculatorsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRouteCalculatorsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRouteCalculatorsPaginator {
            crate::paginator::ListRouteCalculatorsPaginator::new(self.handle, self.inner)
        }
        /// <p>An optional maximum number of results returned in a single call.</p>
        /// <p>Default Value: <code>100</code> </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>An optional maximum number of results returned in a single call.</p>
        /// <p>Default Value: <code>100</code> </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
        /// <p>Default Value: <code>null</code> </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
        /// <p>Default Value: <code>null</code> </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of tags that are applied to the specified Amazon Location resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li>
        /// </ul>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li>
        /// </ul>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTrackerConsumers`.
    ///
    /// <p>Lists geofence collections currently associated to the given tracker resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTrackerConsumers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tracker_consumers_input::Builder,
    }
    impl ListTrackerConsumers {
        /// Creates a new `ListTrackerConsumers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTrackerConsumersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTrackerConsumersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTrackerConsumersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTrackerConsumersPaginator {
            crate::paginator::ListTrackerConsumersPaginator::new(self.handle, self.inner)
        }
        /// <p>The tracker resource whose associated geofence collections you want to list.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(input.into());
            self
        }
        /// <p>The tracker resource whose associated geofence collections you want to list.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code> </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code> </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code> </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code> </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTrackers`.
    ///
    /// <p>Lists tracker resources in your AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTrackers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_trackers_input::Builder,
    }
    impl ListTrackers {
        /// Creates a new `ListTrackers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTrackersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTrackersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListTrackersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListTrackersPaginator {
            crate::paginator::ListTrackersPaginator::new(self.handle, self.inner)
        }
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code> </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code> </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code> </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code> </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutGeofence`.
    ///
    /// <p>Stores a geofence geometry in a given geofence collection, or updates the geometry of an existing geofence if a geofence ID is included in the request. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutGeofence {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_geofence_input::Builder,
    }
    impl PutGeofence {
        /// Creates a new `PutGeofence`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutGeofenceOutput,
            aws_smithy_http::result::SdkError<crate::error::PutGeofenceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The geofence collection to store the geofence in.</p>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_name(input.into());
            self
        }
        /// <p>The geofence collection to store the geofence in.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_name(input);
            self
        }
        /// <p>An identifier for the geofence. For example, <code>ExampleGeofence-1</code>.</p>
        pub fn geofence_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.geofence_id(input.into());
            self
        }
        /// <p>An identifier for the geofence. For example, <code>ExampleGeofence-1</code>.</p>
        pub fn set_geofence_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_geofence_id(input);
            self
        }
        /// <p>Contains the polygon details to specify the position of the geofence.</p> <note>
        /// <p>Each <a href="https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html">geofence polygon</a> can have a maximum of 1,000 vertices.</p>
        /// </note>
        pub fn geometry(mut self, input: crate::model::GeofenceGeometry) -> Self {
            self.inner = self.inner.geometry(input);
            self
        }
        /// <p>Contains the polygon details to specify the position of the geofence.</p> <note>
        /// <p>Each <a href="https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html">geofence polygon</a> can have a maximum of 1,000 vertices.</p>
        /// </note>
        pub fn set_geometry(
            mut self,
            input: std::option::Option<crate::model::GeofenceGeometry>,
        ) -> Self {
            self.inner = self.inner.set_geometry(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchPlaceIndexForPosition`.
    ///
    /// <p>Reverse geocodes a given coordinate and returns a legible address. Allows you to search for Places or points of interest near a given position.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchPlaceIndexForPosition {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::search_place_index_for_position_input::Builder,
    }
    impl SearchPlaceIndexForPosition {
        /// Creates a new `SearchPlaceIndexForPosition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchPlaceIndexForPositionOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchPlaceIndexForPositionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the place index resource you want to use for the search.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(input.into());
            self
        }
        /// <p>The name of the place index resource you want to use for the search.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// Appends an item to `Position`.
        ///
        /// To override the contents of this collection use [`set_position`](Self::set_position).
        ///
        /// <p>Specifies the longitude and latitude of the position to query.</p>
        /// <p> This parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
        /// <p>For example, <code>[-123.1174, 49.2847]</code> represents a position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p>
        pub fn position(mut self, input: f64) -> Self {
            self.inner = self.inner.position(input);
            self
        }
        /// <p>Specifies the longitude and latitude of the position to query.</p>
        /// <p> This parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
        /// <p>For example, <code>[-123.1174, 49.2847]</code> represents a position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p>
        pub fn set_position(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>An optional parameter. The maximum number of results returned per request.</p>
        /// <p>Default value: <code>50</code> </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>An optional parameter. The maximum number of results returned per request.</p>
        /// <p>Default value: <code>50</code> </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
        /// <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.language(input.into());
            self
        }
        /// <p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
        /// <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchPlaceIndexForSuggestions`.
    ///
    /// <p>Generates suggestions for addresses and points of interest based on partial or misspelled free-form text. This operation is also known as autocomplete, autosuggest, or fuzzy matching.</p>
    /// <p>Optional parameters let you narrow your search results by bounding box or country, or bias your search toward a specific position on the globe.</p> <note>
    /// <p>You can search for suggested place names near a specified position by using <code>BiasPosition</code>, or filter results within a bounding box by using <code>FilterBBox</code>. These parameters are mutually exclusive; using both <code>BiasPosition</code> and <code>FilterBBox</code> in the same command returns an error.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchPlaceIndexForSuggestions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::search_place_index_for_suggestions_input::Builder,
    }
    impl SearchPlaceIndexForSuggestions {
        /// Creates a new `SearchPlaceIndexForSuggestions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchPlaceIndexForSuggestionsOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchPlaceIndexForSuggestionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the place index resource you want to use for the search.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(input.into());
            self
        }
        /// <p>The name of the place index resource you want to use for the search.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// <p>The free-form partial text to use to generate place suggestions. For example, <code>eiffel tow</code>.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(input.into());
            self
        }
        /// <p>The free-form partial text to use to generate place suggestions. For example, <code>eiffel tow</code>.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// Appends an item to `BiasPosition`.
        ///
        /// To override the contents of this collection use [`set_bias_position`](Self::set_bias_position).
        ///
        /// <p>An optional parameter that indicates a preference for place suggestions that are closer to a specified position.</p>
        /// <p> If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
        /// <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p> <note>
        /// <p> <code>BiasPosition</code> and <code>FilterBBox</code> are mutually exclusive. Specifying both options results in an error. </p>
        /// </note>
        pub fn bias_position(mut self, input: f64) -> Self {
            self.inner = self.inner.bias_position(input);
            self
        }
        /// <p>An optional parameter that indicates a preference for place suggestions that are closer to a specified position.</p>
        /// <p> If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
        /// <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p> <note>
        /// <p> <code>BiasPosition</code> and <code>FilterBBox</code> are mutually exclusive. Specifying both options results in an error. </p>
        /// </note>
        pub fn set_bias_position(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.inner = self.inner.set_bias_position(input);
            self
        }
        /// Appends an item to `FilterBBox`.
        ///
        /// To override the contents of this collection use [`set_filter_b_box`](Self::set_filter_b_box).
        ///
        /// <p>An optional parameter that limits the search results by returning only suggestions within a specified bounding box.</p>
        /// <p> If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest corner of the bounding box; the second pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the northeast corner of the bounding box.</p>
        /// <p>For example, <code>[-12.7935, -37.4835, -12.0684, -36.9542]</code> represents a bounding box where the southwest corner has longitude <code>-12.7935</code> and latitude <code>-37.4835</code>, and the northeast corner has longitude <code>-12.0684</code> and latitude <code>-36.9542</code>.</p> <note>
        /// <p> <code>FilterBBox</code> and <code>BiasPosition</code> are mutually exclusive. Specifying both options results in an error. </p>
        /// </note>
        pub fn filter_b_box(mut self, input: f64) -> Self {
            self.inner = self.inner.filter_b_box(input);
            self
        }
        /// <p>An optional parameter that limits the search results by returning only suggestions within a specified bounding box.</p>
        /// <p> If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest corner of the bounding box; the second pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the northeast corner of the bounding box.</p>
        /// <p>For example, <code>[-12.7935, -37.4835, -12.0684, -36.9542]</code> represents a bounding box where the southwest corner has longitude <code>-12.7935</code> and latitude <code>-37.4835</code>, and the northeast corner has longitude <code>-12.0684</code> and latitude <code>-36.9542</code>.</p> <note>
        /// <p> <code>FilterBBox</code> and <code>BiasPosition</code> are mutually exclusive. Specifying both options results in an error. </p>
        /// </note>
        pub fn set_filter_b_box(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.inner = self.inner.set_filter_b_box(input);
            self
        }
        /// Appends an item to `FilterCountries`.
        ///
        /// To override the contents of this collection use [`set_filter_countries`](Self::set_filter_countries).
        ///
        /// <p>An optional parameter that limits the search results by returning only suggestions within the provided list of countries.</p>
        /// <ul>
        /// <li> <p>Use the <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country code. For example, Australia uses three upper-case characters: <code>AUS</code>.</p> </li>
        /// </ul>
        pub fn filter_countries(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_countries(input.into());
            self
        }
        /// <p>An optional parameter that limits the search results by returning only suggestions within the provided list of countries.</p>
        /// <ul>
        /// <li> <p>Use the <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country code. For example, Australia uses three upper-case characters: <code>AUS</code>.</p> </li>
        /// </ul>
        pub fn set_filter_countries(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_filter_countries(input);
            self
        }
        /// <p>An optional parameter. The maximum number of results returned per request. </p>
        /// <p>The default: <code>5</code> </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>An optional parameter. The maximum number of results returned per request. </p>
        /// <p>The default: <code>5</code> </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
        /// <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p>
        /// <p>Used only when the partner selected is Here.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.language(input.into());
            self
        }
        /// <p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
        /// <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p>
        /// <p>Used only when the partner selected is Here.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchPlaceIndexForText`.
    ///
    /// <p>Geocodes free-form text, such as an address, name, city, or region to allow you to search for Places or points of interest. </p>
    /// <p>Optional parameters let you narrow your search results by bounding box or country, or bias your search toward a specific position on the globe.</p> <note>
    /// <p>You can search for places near a given position using <code>BiasPosition</code>, or filter results within a bounding box using <code>FilterBBox</code>. Providing both parameters simultaneously returns an error.</p>
    /// </note>
    /// <p>Search results are returned in order of highest to lowest relevance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchPlaceIndexForText {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::search_place_index_for_text_input::Builder,
    }
    impl SearchPlaceIndexForText {
        /// Creates a new `SearchPlaceIndexForText`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchPlaceIndexForTextOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchPlaceIndexForTextError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the place index resource you want to use for the search.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(input.into());
            self
        }
        /// <p>The name of the place index resource you want to use for the search.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// <p>The address, name, city, or region to be used in the search in free-form text format. For example, <code>123 Any Street</code>.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(input.into());
            self
        }
        /// <p>The address, name, city, or region to be used in the search in free-form text format. For example, <code>123 Any Street</code>.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// Appends an item to `BiasPosition`.
        ///
        /// To override the contents of this collection use [`set_bias_position`](Self::set_bias_position).
        ///
        /// <p>An optional parameter that indicates a preference for places that are closer to a specified position.</p>
        /// <p> If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
        /// <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p> <note>
        /// <p> <code>BiasPosition</code> and <code>FilterBBox</code> are mutually exclusive. Specifying both options results in an error. </p>
        /// </note>
        pub fn bias_position(mut self, input: f64) -> Self {
            self.inner = self.inner.bias_position(input);
            self
        }
        /// <p>An optional parameter that indicates a preference for places that are closer to a specified position.</p>
        /// <p> If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
        /// <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p> <note>
        /// <p> <code>BiasPosition</code> and <code>FilterBBox</code> are mutually exclusive. Specifying both options results in an error. </p>
        /// </note>
        pub fn set_bias_position(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.inner = self.inner.set_bias_position(input);
            self
        }
        /// Appends an item to `FilterBBox`.
        ///
        /// To override the contents of this collection use [`set_filter_b_box`](Self::set_filter_b_box).
        ///
        /// <p>An optional parameter that limits the search results by returning only places that are within the provided bounding box.</p>
        /// <p> If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest corner of the bounding box; the second pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the northeast corner of the bounding box.</p>
        /// <p>For example, <code>[-12.7935, -37.4835, -12.0684, -36.9542]</code> represents a bounding box where the southwest corner has longitude <code>-12.7935</code> and latitude <code>-37.4835</code>, and the northeast corner has longitude <code>-12.0684</code> and latitude <code>-36.9542</code>.</p> <note>
        /// <p> <code>FilterBBox</code> and <code>BiasPosition</code> are mutually exclusive. Specifying both options results in an error. </p>
        /// </note>
        pub fn filter_b_box(mut self, input: f64) -> Self {
            self.inner = self.inner.filter_b_box(input);
            self
        }
        /// <p>An optional parameter that limits the search results by returning only places that are within the provided bounding box.</p>
        /// <p> If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest corner of the bounding box; the second pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the northeast corner of the bounding box.</p>
        /// <p>For example, <code>[-12.7935, -37.4835, -12.0684, -36.9542]</code> represents a bounding box where the southwest corner has longitude <code>-12.7935</code> and latitude <code>-37.4835</code>, and the northeast corner has longitude <code>-12.0684</code> and latitude <code>-36.9542</code>.</p> <note>
        /// <p> <code>FilterBBox</code> and <code>BiasPosition</code> are mutually exclusive. Specifying both options results in an error. </p>
        /// </note>
        pub fn set_filter_b_box(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.inner = self.inner.set_filter_b_box(input);
            self
        }
        /// Appends an item to `FilterCountries`.
        ///
        /// To override the contents of this collection use [`set_filter_countries`](Self::set_filter_countries).
        ///
        /// <p>An optional parameter that limits the search results by returning only places that are in a specified list of countries.</p>
        /// <ul>
        /// <li> <p>Valid values include <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country codes. For example, Australia uses three upper-case characters: <code>AUS</code>.</p> </li>
        /// </ul>
        pub fn filter_countries(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_countries(input.into());
            self
        }
        /// <p>An optional parameter that limits the search results by returning only places that are in a specified list of countries.</p>
        /// <ul>
        /// <li> <p>Valid values include <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country codes. For example, Australia uses three upper-case characters: <code>AUS</code>.</p> </li>
        /// </ul>
        pub fn set_filter_countries(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_filter_countries(input);
            self
        }
        /// <p>An optional parameter. The maximum number of results returned per request. </p>
        /// <p>The default: <code>50</code> </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>An optional parameter. The maximum number of results returned per request. </p>
        /// <p>The default: <code>50</code> </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
        /// <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.language(input.into());
            self
        }
        /// <p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
        /// <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_language(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Assigns one or more tags (key-value pairs) to the specified Amazon Location Service resource.</p>
    /// <p>Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values.</p>
    /// <p>You can use the <code>TagResource</code> operation with an Amazon Location Service resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the tags already associated with the resource. If you specify a tag key that's already associated with the resource, the new tag value that you specify replaces the previous value for that tag. </p>
    /// <p>You can associate up to 50 tags with a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to update.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li>
        /// </ul>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to update.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li>
        /// </ul>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Applies one or more tags to specific resource. A tag is a key-value pair that helps you manage, identify, search, and filter your resources.</p>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource.</p> </li>
        /// <li> <p>Each tag key must be unique and must have exactly one associated value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8.</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8.</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @</p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Applies one or more tags to specific resource. A tag is a key-value pair that helps you manage, identify, search, and filter your resources.</p>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource.</p> </li>
        /// <li> <p>Each tag key must be unique and must have exactly one associated value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8.</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8.</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @</p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from the specified Amazon Location resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which you want to remove tags.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li>
        /// </ul>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which you want to remove tags.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li>
        /// </ul>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove from the specified resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The list of tag keys to remove from the specified resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGeofenceCollection`.
    ///
    /// <p>Updates the specified properties of a given geofence collection.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateGeofenceCollection {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_geofence_collection_input::Builder,
    }
    impl UpdateGeofenceCollection {
        /// Creates a new `UpdateGeofenceCollection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGeofenceCollectionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGeofenceCollectionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the geofence collection to update.</p>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_name(input.into());
            self
        }
        /// <p>The name of the geofence collection to update.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_name(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.inner = self.inner.pricing_plan(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan(input);
            self
        }
        /// <p>This parameter is no longer used.</p>
        pub fn pricing_plan_data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pricing_plan_data_source(input.into());
            self
        }
        /// <p>This parameter is no longer used.</p>
        pub fn set_pricing_plan_data_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan_data_source(input);
            self
        }
        /// <p>Updates the description for the geofence collection.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>Updates the description for the geofence collection.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMap`.
    ///
    /// <p>Updates the specified properties of a given map resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateMap {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_map_input::Builder,
    }
    impl UpdateMap {
        /// Creates a new `UpdateMap`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMapOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMapError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the map resource to update.</p>
        pub fn map_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.map_name(input.into());
            self
        }
        /// <p>The name of the map resource to update.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_map_name(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.inner = self.inner.pricing_plan(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan(input);
            self
        }
        /// <p>Updates the description for the map resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>Updates the description for the map resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePlaceIndex`.
    ///
    /// <p>Updates the specified properties of a given place index resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdatePlaceIndex {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_place_index_input::Builder,
    }
    impl UpdatePlaceIndex {
        /// Creates a new `UpdatePlaceIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePlaceIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePlaceIndexError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the place index resource to update.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(input.into());
            self
        }
        /// <p>The name of the place index resource to update.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.inner = self.inner.pricing_plan(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan(input);
            self
        }
        /// <p>Updates the description for the place index resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>Updates the description for the place index resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Updates the data storage option for the place index resource.</p>
        pub fn data_source_configuration(
            mut self,
            input: crate::model::DataSourceConfiguration,
        ) -> Self {
            self.inner = self.inner.data_source_configuration(input);
            self
        }
        /// <p>Updates the data storage option for the place index resource.</p>
        pub fn set_data_source_configuration(
            mut self,
            input: std::option::Option<crate::model::DataSourceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_data_source_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRouteCalculator`.
    ///
    /// <p>Updates the specified properties for a given route calculator resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRouteCalculator {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_route_calculator_input::Builder,
    }
    impl UpdateRouteCalculator {
        /// Creates a new `UpdateRouteCalculator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRouteCalculatorOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRouteCalculatorError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the route calculator resource to update.</p>
        pub fn calculator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.calculator_name(input.into());
            self
        }
        /// <p>The name of the route calculator resource to update.</p>
        pub fn set_calculator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_calculator_name(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.inner = self.inner.pricing_plan(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan(input);
            self
        }
        /// <p>Updates the description for the route calculator resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>Updates the description for the route calculator resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTracker`.
    ///
    /// <p>Updates the specified properties of a given tracker resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateTracker {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_tracker_input::Builder,
    }
    impl UpdateTracker {
        /// Creates a new `UpdateTracker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTrackerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTrackerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the tracker resource to update.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(input.into());
            self
        }
        /// <p>The name of the tracker resource to update.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.inner = self.inner.pricing_plan(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan(input);
            self
        }
        /// <p>This parameter is no longer used.</p>
        pub fn pricing_plan_data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pricing_plan_data_source(input.into());
            self
        }
        /// <p>This parameter is no longer used.</p>
        pub fn set_pricing_plan_data_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan_data_source(input);
            self
        }
        /// <p>Updates the description for the tracker resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>Updates the description for the tracker resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Updates the position filtering for the tracker resource.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li> <p> <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID. </p> </li>
        /// <li> <p> <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this distance are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map. </p> </li>
        /// <li> <p> <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This helps educe the effects of GPS noise when displaying device trajectories on a map, and can help control costs by reducing the number of geofence evaluations. </p> </li>
        /// </ul>
        pub fn position_filtering(mut self, input: crate::model::PositionFiltering) -> Self {
            self.inner = self.inner.position_filtering(input);
            self
        }
        /// <p>Updates the position filtering for the tracker resource.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li> <p> <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID. </p> </li>
        /// <li> <p> <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this distance are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map. </p> </li>
        /// <li> <p> <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This helps educe the effects of GPS noise when displaying device trajectories on a map, and can help control costs by reducing the number of geofence evaluations. </p> </li>
        /// </ul>
        pub fn set_position_filtering(
            mut self,
            input: std::option::Option<crate::model::PositionFiltering>,
        ) -> Self {
            self.inner = self.inner.set_position_filtering(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
