// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateTrackerConsumerInput`](crate::input::AssociateTrackerConsumerInput)
pub mod associate_tracker_consumer_input {
    /// A builder for [`AssociateTrackerConsumerInput`](crate::input::AssociateTrackerConsumerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tracker_name: std::option::Option<std::string::String>,
        pub(crate) consumer_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the tracker resource to be associated with a geofence collection.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracker_name = Some(input.into());
            self
        }
        /// <p>The name of the tracker resource to be associated with a geofence collection.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tracker_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code> </p> </li>
        /// </ul>
        pub fn consumer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.consumer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code> </p> </li>
        /// </ul>
        pub fn set_consumer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.consumer_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateTrackerConsumerInput`](crate::input::AssociateTrackerConsumerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateTrackerConsumerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateTrackerConsumerInput {
                tracker_name: self.tracker_name,
                consumer_arn: self.consumer_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateTrackerConsumerInputOperationOutputAlias =
    crate::operation::AssociateTrackerConsumer;
#[doc(hidden)]
pub type AssociateTrackerConsumerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateTrackerConsumerInput {
    /// Consumes the builder and constructs an Operation<[`AssociateTrackerConsumer`](crate::operation::AssociateTrackerConsumer)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateTrackerConsumer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AssociateTrackerConsumerInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.tracker_name;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let tracker_name = aws_smithy_http::label::fmt_string(input_1, false);
                if tracker_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/tracking/v0/trackers/{TrackerName}/consumers",
                    TrackerName = tracker_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AssociateTrackerConsumerInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_associate_tracker_consumer(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("tracking.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateTrackerConsumer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateTrackerConsumer",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AssociateTrackerConsumerInput`](crate::input::AssociateTrackerConsumerInput)
    pub fn builder() -> crate::input::associate_tracker_consumer_input::Builder {
        crate::input::associate_tracker_consumer_input::Builder::default()
    }
}

/// See [`BatchDeleteDevicePositionHistoryInput`](crate::input::BatchDeleteDevicePositionHistoryInput)
pub mod batch_delete_device_position_history_input {
    /// A builder for [`BatchDeleteDevicePositionHistoryInput`](crate::input::BatchDeleteDevicePositionHistoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tracker_name: std::option::Option<std::string::String>,
        pub(crate) device_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the tracker resource to delete the device position history from.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracker_name = Some(input.into());
            self
        }
        /// <p>The name of the tracker resource to delete the device position history from.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tracker_name = input;
            self
        }
        /// Appends an item to `device_ids`.
        ///
        /// To override the contents of this collection use [`set_device_ids`](Self::set_device_ids).
        ///
        /// <p>Devices whose position history you want to delete.</p>
        /// <ul>
        /// <li> <p>For example, for two devices: <code>“DeviceIds” : [DeviceId1,DeviceId2]</code> </p> </li>
        /// </ul>
        pub fn device_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.device_ids.unwrap_or_default();
            v.push(input.into());
            self.device_ids = Some(v);
            self
        }
        /// <p>Devices whose position history you want to delete.</p>
        /// <ul>
        /// <li> <p>For example, for two devices: <code>“DeviceIds” : [DeviceId1,DeviceId2]</code> </p> </li>
        /// </ul>
        pub fn set_device_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.device_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteDevicePositionHistoryInput`](crate::input::BatchDeleteDevicePositionHistoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDeleteDevicePositionHistoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDeleteDevicePositionHistoryInput {
                tracker_name: self.tracker_name,
                device_ids: self.device_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDeleteDevicePositionHistoryInputOperationOutputAlias =
    crate::operation::BatchDeleteDevicePositionHistory;
#[doc(hidden)]
pub type BatchDeleteDevicePositionHistoryInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl BatchDeleteDevicePositionHistoryInput {
    /// Consumes the builder and constructs an Operation<[`BatchDeleteDevicePositionHistory`](crate::operation::BatchDeleteDevicePositionHistory)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDeleteDevicePositionHistory,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::BatchDeleteDevicePositionHistoryInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.tracker_name;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let tracker_name = aws_smithy_http::label::fmt_string(input_2, false);
                if tracker_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/tracking/v0/trackers/{TrackerName}/delete-positions",
                    TrackerName = tracker_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::BatchDeleteDevicePositionHistoryInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_delete_device_position_history(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("tracking.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDeleteDevicePositionHistory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDeleteDevicePositionHistory",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`BatchDeleteDevicePositionHistoryInput`](crate::input::BatchDeleteDevicePositionHistoryInput)
    pub fn builder() -> crate::input::batch_delete_device_position_history_input::Builder {
        crate::input::batch_delete_device_position_history_input::Builder::default()
    }
}

/// See [`BatchDeleteGeofenceInput`](crate::input::BatchDeleteGeofenceInput)
pub mod batch_delete_geofence_input {
    /// A builder for [`BatchDeleteGeofenceInput`](crate::input::BatchDeleteGeofenceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) collection_name: std::option::Option<std::string::String>,
        pub(crate) geofence_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The geofence collection storing the geofences to be deleted.</p>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.collection_name = Some(input.into());
            self
        }
        /// <p>The geofence collection storing the geofences to be deleted.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.collection_name = input;
            self
        }
        /// Appends an item to `geofence_ids`.
        ///
        /// To override the contents of this collection use [`set_geofence_ids`](Self::set_geofence_ids).
        ///
        /// <p>The batch of geofences to be deleted.</p>
        pub fn geofence_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.geofence_ids.unwrap_or_default();
            v.push(input.into());
            self.geofence_ids = Some(v);
            self
        }
        /// <p>The batch of geofences to be deleted.</p>
        pub fn set_geofence_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.geofence_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteGeofenceInput`](crate::input::BatchDeleteGeofenceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchDeleteGeofenceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchDeleteGeofenceInput {
                collection_name: self.collection_name,
                geofence_ids: self.geofence_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchDeleteGeofenceInputOperationOutputAlias = crate::operation::BatchDeleteGeofence;
#[doc(hidden)]
pub type BatchDeleteGeofenceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchDeleteGeofenceInput {
    /// Consumes the builder and constructs an Operation<[`BatchDeleteGeofence`](crate::operation::BatchDeleteGeofence)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchDeleteGeofence,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::BatchDeleteGeofenceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.collection_name;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "collection_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let collection_name = aws_smithy_http::label::fmt_string(input_3, false);
                if collection_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "collection_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/geofencing/v0/collections/{CollectionName}/delete-geofences",
                    CollectionName = collection_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::BatchDeleteGeofenceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_delete_geofence(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("geofencing.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchDeleteGeofence::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchDeleteGeofence",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`BatchDeleteGeofenceInput`](crate::input::BatchDeleteGeofenceInput)
    pub fn builder() -> crate::input::batch_delete_geofence_input::Builder {
        crate::input::batch_delete_geofence_input::Builder::default()
    }
}

/// See [`BatchEvaluateGeofencesInput`](crate::input::BatchEvaluateGeofencesInput)
pub mod batch_evaluate_geofences_input {
    /// A builder for [`BatchEvaluateGeofencesInput`](crate::input::BatchEvaluateGeofencesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) collection_name: std::option::Option<std::string::String>,
        pub(crate) device_position_updates:
            std::option::Option<std::vec::Vec<crate::model::DevicePositionUpdate>>,
    }
    impl Builder {
        /// <p>The geofence collection used in evaluating the position of devices against its geofences.</p>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.collection_name = Some(input.into());
            self
        }
        /// <p>The geofence collection used in evaluating the position of devices against its geofences.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.collection_name = input;
            self
        }
        /// Appends an item to `device_position_updates`.
        ///
        /// To override the contents of this collection use [`set_device_position_updates`](Self::set_device_position_updates).
        ///
        /// <p>Contains device details for each device to be evaluated against the given geofence collection.</p>
        pub fn device_position_updates(
            mut self,
            input: crate::model::DevicePositionUpdate,
        ) -> Self {
            let mut v = self.device_position_updates.unwrap_or_default();
            v.push(input);
            self.device_position_updates = Some(v);
            self
        }
        /// <p>Contains device details for each device to be evaluated against the given geofence collection.</p>
        pub fn set_device_position_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DevicePositionUpdate>>,
        ) -> Self {
            self.device_position_updates = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchEvaluateGeofencesInput`](crate::input::BatchEvaluateGeofencesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchEvaluateGeofencesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchEvaluateGeofencesInput {
                collection_name: self.collection_name,
                device_position_updates: self.device_position_updates,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchEvaluateGeofencesInputOperationOutputAlias = crate::operation::BatchEvaluateGeofences;
#[doc(hidden)]
pub type BatchEvaluateGeofencesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchEvaluateGeofencesInput {
    /// Consumes the builder and constructs an Operation<[`BatchEvaluateGeofences`](crate::operation::BatchEvaluateGeofences)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchEvaluateGeofences,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::BatchEvaluateGeofencesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_4 = &_input.collection_name;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "collection_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let collection_name = aws_smithy_http::label::fmt_string(input_4, false);
                if collection_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "collection_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/geofencing/v0/collections/{CollectionName}/positions",
                    CollectionName = collection_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::BatchEvaluateGeofencesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_evaluate_geofences(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("geofencing.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchEvaluateGeofences::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchEvaluateGeofences",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`BatchEvaluateGeofencesInput`](crate::input::BatchEvaluateGeofencesInput)
    pub fn builder() -> crate::input::batch_evaluate_geofences_input::Builder {
        crate::input::batch_evaluate_geofences_input::Builder::default()
    }
}

/// See [`BatchGetDevicePositionInput`](crate::input::BatchGetDevicePositionInput)
pub mod batch_get_device_position_input {
    /// A builder for [`BatchGetDevicePositionInput`](crate::input::BatchGetDevicePositionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tracker_name: std::option::Option<std::string::String>,
        pub(crate) device_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The tracker resource retrieving the device position.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracker_name = Some(input.into());
            self
        }
        /// <p>The tracker resource retrieving the device position.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tracker_name = input;
            self
        }
        /// Appends an item to `device_ids`.
        ///
        /// To override the contents of this collection use [`set_device_ids`](Self::set_device_ids).
        ///
        /// <p>Devices whose position you want to retrieve.</p>
        /// <ul>
        /// <li> <p>For example, for two devices: <code>device-ids=DeviceId1&amp;device-ids=DeviceId2</code> </p> </li>
        /// </ul>
        pub fn device_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.device_ids.unwrap_or_default();
            v.push(input.into());
            self.device_ids = Some(v);
            self
        }
        /// <p>Devices whose position you want to retrieve.</p>
        /// <ul>
        /// <li> <p>For example, for two devices: <code>device-ids=DeviceId1&amp;device-ids=DeviceId2</code> </p> </li>
        /// </ul>
        pub fn set_device_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.device_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetDevicePositionInput`](crate::input::BatchGetDevicePositionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchGetDevicePositionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchGetDevicePositionInput {
                tracker_name: self.tracker_name,
                device_ids: self.device_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchGetDevicePositionInputOperationOutputAlias = crate::operation::BatchGetDevicePosition;
#[doc(hidden)]
pub type BatchGetDevicePositionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchGetDevicePositionInput {
    /// Consumes the builder and constructs an Operation<[`BatchGetDevicePosition`](crate::operation::BatchGetDevicePosition)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchGetDevicePosition,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::BatchGetDevicePositionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_5 = &_input.tracker_name;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let tracker_name = aws_smithy_http::label::fmt_string(input_5, false);
                if tracker_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/tracking/v0/trackers/{TrackerName}/get-positions",
                    TrackerName = tracker_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::BatchGetDevicePositionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_get_device_position(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("tracking.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchGetDevicePosition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchGetDevicePosition",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`BatchGetDevicePositionInput`](crate::input::BatchGetDevicePositionInput)
    pub fn builder() -> crate::input::batch_get_device_position_input::Builder {
        crate::input::batch_get_device_position_input::Builder::default()
    }
}

/// See [`BatchPutGeofenceInput`](crate::input::BatchPutGeofenceInput)
pub mod batch_put_geofence_input {
    /// A builder for [`BatchPutGeofenceInput`](crate::input::BatchPutGeofenceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) collection_name: std::option::Option<std::string::String>,
        pub(crate) entries:
            std::option::Option<std::vec::Vec<crate::model::BatchPutGeofenceRequestEntry>>,
    }
    impl Builder {
        /// <p>The geofence collection storing the geofences.</p>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.collection_name = Some(input.into());
            self
        }
        /// <p>The geofence collection storing the geofences.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.collection_name = input;
            self
        }
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>The batch of geofences to be stored in a geofence collection.</p>
        pub fn entries(mut self, input: crate::model::BatchPutGeofenceRequestEntry) -> Self {
            let mut v = self.entries.unwrap_or_default();
            v.push(input);
            self.entries = Some(v);
            self
        }
        /// <p>The batch of geofences to be stored in a geofence collection.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchPutGeofenceRequestEntry>>,
        ) -> Self {
            self.entries = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchPutGeofenceInput`](crate::input::BatchPutGeofenceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchPutGeofenceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchPutGeofenceInput {
                collection_name: self.collection_name,
                entries: self.entries,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchPutGeofenceInputOperationOutputAlias = crate::operation::BatchPutGeofence;
#[doc(hidden)]
pub type BatchPutGeofenceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchPutGeofenceInput {
    /// Consumes the builder and constructs an Operation<[`BatchPutGeofence`](crate::operation::BatchPutGeofence)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchPutGeofence,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::BatchPutGeofenceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_6 = &_input.collection_name;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "collection_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let collection_name = aws_smithy_http::label::fmt_string(input_6, false);
                if collection_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "collection_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/geofencing/v0/collections/{CollectionName}/put-geofences",
                    CollectionName = collection_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::BatchPutGeofenceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_put_geofence(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("geofencing.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchPutGeofence::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchPutGeofence",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`BatchPutGeofenceInput`](crate::input::BatchPutGeofenceInput)
    pub fn builder() -> crate::input::batch_put_geofence_input::Builder {
        crate::input::batch_put_geofence_input::Builder::default()
    }
}

/// See [`BatchUpdateDevicePositionInput`](crate::input::BatchUpdateDevicePositionInput)
pub mod batch_update_device_position_input {
    /// A builder for [`BatchUpdateDevicePositionInput`](crate::input::BatchUpdateDevicePositionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tracker_name: std::option::Option<std::string::String>,
        pub(crate) updates: std::option::Option<std::vec::Vec<crate::model::DevicePositionUpdate>>,
    }
    impl Builder {
        /// <p>The name of the tracker resource to update.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracker_name = Some(input.into());
            self
        }
        /// <p>The name of the tracker resource to update.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tracker_name = input;
            self
        }
        /// Appends an item to `updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>Contains the position update details for each device.</p>
        pub fn updates(mut self, input: crate::model::DevicePositionUpdate) -> Self {
            let mut v = self.updates.unwrap_or_default();
            v.push(input);
            self.updates = Some(v);
            self
        }
        /// <p>Contains the position update details for each device.</p>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DevicePositionUpdate>>,
        ) -> Self {
            self.updates = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchUpdateDevicePositionInput`](crate::input::BatchUpdateDevicePositionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchUpdateDevicePositionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchUpdateDevicePositionInput {
                tracker_name: self.tracker_name,
                updates: self.updates,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchUpdateDevicePositionInputOperationOutputAlias =
    crate::operation::BatchUpdateDevicePosition;
#[doc(hidden)]
pub type BatchUpdateDevicePositionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BatchUpdateDevicePositionInput {
    /// Consumes the builder and constructs an Operation<[`BatchUpdateDevicePosition`](crate::operation::BatchUpdateDevicePosition)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchUpdateDevicePosition,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::BatchUpdateDevicePositionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_7 = &_input.tracker_name;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let tracker_name = aws_smithy_http::label::fmt_string(input_7, false);
                if tracker_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/tracking/v0/trackers/{TrackerName}/positions",
                    TrackerName = tracker_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::BatchUpdateDevicePositionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_batch_update_device_position(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("tracking.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchUpdateDevicePosition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchUpdateDevicePosition",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`BatchUpdateDevicePositionInput`](crate::input::BatchUpdateDevicePositionInput)
    pub fn builder() -> crate::input::batch_update_device_position_input::Builder {
        crate::input::batch_update_device_position_input::Builder::default()
    }
}

/// See [`CalculateRouteInput`](crate::input::CalculateRouteInput)
pub mod calculate_route_input {
    /// A builder for [`CalculateRouteInput`](crate::input::CalculateRouteInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) calculator_name: std::option::Option<std::string::String>,
        pub(crate) departure_position: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) destination_position: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) waypoint_positions: std::option::Option<std::vec::Vec<std::vec::Vec<f64>>>,
        pub(crate) travel_mode: std::option::Option<crate::model::TravelMode>,
        pub(crate) departure_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) depart_now: std::option::Option<bool>,
        pub(crate) distance_unit: std::option::Option<crate::model::DistanceUnit>,
        pub(crate) include_leg_geometry: std::option::Option<bool>,
        pub(crate) car_mode_options:
            std::option::Option<crate::model::CalculateRouteCarModeOptions>,
        pub(crate) truck_mode_options:
            std::option::Option<crate::model::CalculateRouteTruckModeOptions>,
    }
    impl Builder {
        /// <p>The name of the route calculator resource that you want to use to calculate the route. </p>
        pub fn calculator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.calculator_name = Some(input.into());
            self
        }
        /// <p>The name of the route calculator resource that you want to use to calculate the route. </p>
        pub fn set_calculator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.calculator_name = input;
            self
        }
        /// Appends an item to `departure_position`.
        ///
        /// To override the contents of this collection use [`set_departure_position`](Self::set_departure_position).
        ///
        /// <p>The start position for the route. Defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>.</p>
        /// <ul>
        /// <li> <p>For example, <code>[-123.115, 49.285]</code> </p> </li>
        /// </ul> <note>
        /// <p>If you specify a departure that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. If Esri is the provider for your route calculator, specifying a route that is longer than 400 km returns a <code>400 RoutesValidationException</code> error.</p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
        pub fn departure_position(mut self, input: f64) -> Self {
            let mut v = self.departure_position.unwrap_or_default();
            v.push(input);
            self.departure_position = Some(v);
            self
        }
        /// <p>The start position for the route. Defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>.</p>
        /// <ul>
        /// <li> <p>For example, <code>[-123.115, 49.285]</code> </p> </li>
        /// </ul> <note>
        /// <p>If you specify a departure that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. If Esri is the provider for your route calculator, specifying a route that is longer than 400 km returns a <code>400 RoutesValidationException</code> error.</p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
        pub fn set_departure_position(
            mut self,
            input: std::option::Option<std::vec::Vec<f64>>,
        ) -> Self {
            self.departure_position = input;
            self
        }
        /// Appends an item to `destination_position`.
        ///
        /// To override the contents of this collection use [`set_destination_position`](Self::set_destination_position).
        ///
        /// <p>The finish position for the route. Defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>.</p>
        /// <ul>
        /// <li> <p> For example, <code>[-122.339, 47.615]</code> </p> </li>
        /// </ul> <note>
        /// <p>If you specify a destination that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. </p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
        pub fn destination_position(mut self, input: f64) -> Self {
            let mut v = self.destination_position.unwrap_or_default();
            v.push(input);
            self.destination_position = Some(v);
            self
        }
        /// <p>The finish position for the route. Defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>.</p>
        /// <ul>
        /// <li> <p> For example, <code>[-122.339, 47.615]</code> </p> </li>
        /// </ul> <note>
        /// <p>If you specify a destination that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. </p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
        pub fn set_destination_position(
            mut self,
            input: std::option::Option<std::vec::Vec<f64>>,
        ) -> Self {
            self.destination_position = input;
            self
        }
        /// Appends an item to `waypoint_positions`.
        ///
        /// To override the contents of this collection use [`set_waypoint_positions`](Self::set_waypoint_positions).
        ///
        /// <p>Specifies an ordered list of up to 23 intermediate positions to include along a route between the departure position and destination position. </p>
        /// <ul>
        /// <li> <p>For example, from the <code>DeparturePosition</code> <code>[-123.115, 49.285]</code>, the route follows the order that the waypoint positions are given <code>[[-122.757, 49.0021],[-122.349, 47.620]]</code> </p> </li>
        /// </ul> <note>
        /// <p>If you specify a waypoint position that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. </p>
        /// <p>Specifying more than 23 waypoints returns a <code>400 ValidationException</code> error.</p>
        /// <p>If Esri is the provider for your route calculator, specifying a route that is longer than 400 km returns a <code>400 RoutesValidationException</code> error.</p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
        pub fn waypoint_positions(mut self, input: std::vec::Vec<f64>) -> Self {
            let mut v = self.waypoint_positions.unwrap_or_default();
            v.push(input);
            self.waypoint_positions = Some(v);
            self
        }
        /// <p>Specifies an ordered list of up to 23 intermediate positions to include along a route between the departure position and destination position. </p>
        /// <ul>
        /// <li> <p>For example, from the <code>DeparturePosition</code> <code>[-123.115, 49.285]</code>, the route follows the order that the waypoint positions are given <code>[[-122.757, 49.0021],[-122.349, 47.620]]</code> </p> </li>
        /// </ul> <note>
        /// <p>If you specify a waypoint position that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. </p>
        /// <p>Specifying more than 23 waypoints returns a <code>400 ValidationException</code> error.</p>
        /// <p>If Esri is the provider for your route calculator, specifying a route that is longer than 400 km returns a <code>400 RoutesValidationException</code> error.</p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
        pub fn set_waypoint_positions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<f64>>>,
        ) -> Self {
            self.waypoint_positions = input;
            self
        }
        /// <p>Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road compatibility.</p>
        /// <p>The <code>TravelMode</code> you specify also determines how you specify route preferences: </p>
        /// <ul>
        /// <li> <p>If traveling by <code>Car</code> use the <code>CarModeOptions</code> parameter.</p> </li>
        /// <li> <p>If traveling by <code>Truck</code> use the <code>TruckModeOptions</code> parameter.</p> </li>
        /// </ul>
        /// <p>Default Value: <code>Car</code> </p>
        pub fn travel_mode(mut self, input: crate::model::TravelMode) -> Self {
            self.travel_mode = Some(input);
            self
        }
        /// <p>Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road compatibility.</p>
        /// <p>The <code>TravelMode</code> you specify also determines how you specify route preferences: </p>
        /// <ul>
        /// <li> <p>If traveling by <code>Car</code> use the <code>CarModeOptions</code> parameter.</p> </li>
        /// <li> <p>If traveling by <code>Truck</code> use the <code>TruckModeOptions</code> parameter.</p> </li>
        /// </ul>
        /// <p>Default Value: <code>Car</code> </p>
        pub fn set_travel_mode(
            mut self,
            input: std::option::Option<crate::model::TravelMode>,
        ) -> Self {
            self.travel_mode = input;
            self
        }
        /// <p>Specifies the desired time of departure. Uses the given time to calculate the route. Otherwise, the best time of day to travel with the best traffic conditions is used to calculate the route.</p> <note>
        /// <p>Setting a departure time in the past returns a <code>400 ValidationException</code> error.</p>
        /// </note>
        /// <ul>
        /// <li> <p>In <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
        /// </ul>
        pub fn departure_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.departure_time = Some(input);
            self
        }
        /// <p>Specifies the desired time of departure. Uses the given time to calculate the route. Otherwise, the best time of day to travel with the best traffic conditions is used to calculate the route.</p> <note>
        /// <p>Setting a departure time in the past returns a <code>400 ValidationException</code> error.</p>
        /// </note>
        /// <ul>
        /// <li> <p>In <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
        /// </ul>
        pub fn set_departure_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.departure_time = input;
            self
        }
        /// <p>Sets the time of departure as the current time. Uses the current time to calculate a route. Otherwise, the best time of day to travel with the best traffic conditions is used to calculate the route.</p>
        /// <p>Default Value: <code>false</code> </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
        pub fn depart_now(mut self, input: bool) -> Self {
            self.depart_now = Some(input);
            self
        }
        /// <p>Sets the time of departure as the current time. Uses the current time to calculate a route. Otherwise, the best time of day to travel with the best traffic conditions is used to calculate the route.</p>
        /// <p>Default Value: <code>false</code> </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
        pub fn set_depart_now(mut self, input: std::option::Option<bool>) -> Self {
            self.depart_now = input;
            self
        }
        /// <p>Set the unit system to specify the distance.</p>
        /// <p>Default Value: <code>Kilometers</code> </p>
        pub fn distance_unit(mut self, input: crate::model::DistanceUnit) -> Self {
            self.distance_unit = Some(input);
            self
        }
        /// <p>Set the unit system to specify the distance.</p>
        /// <p>Default Value: <code>Kilometers</code> </p>
        pub fn set_distance_unit(
            mut self,
            input: std::option::Option<crate::model::DistanceUnit>,
        ) -> Self {
            self.distance_unit = input;
            self
        }
        /// <p>Set to include the geometry details in the result for each path between a pair of positions.</p>
        /// <p>Default Value: <code>false</code> </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
        pub fn include_leg_geometry(mut self, input: bool) -> Self {
            self.include_leg_geometry = Some(input);
            self
        }
        /// <p>Set to include the geometry details in the result for each path between a pair of positions.</p>
        /// <p>Default Value: <code>false</code> </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
        pub fn set_include_leg_geometry(mut self, input: std::option::Option<bool>) -> Self {
            self.include_leg_geometry = input;
            self
        }
        /// <p>Specifies route preferences when traveling by <code>Car</code>, such as avoiding routes that use ferries or tolls.</p>
        /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Car</code>.</p>
        pub fn car_mode_options(
            mut self,
            input: crate::model::CalculateRouteCarModeOptions,
        ) -> Self {
            self.car_mode_options = Some(input);
            self
        }
        /// <p>Specifies route preferences when traveling by <code>Car</code>, such as avoiding routes that use ferries or tolls.</p>
        /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Car</code>.</p>
        pub fn set_car_mode_options(
            mut self,
            input: std::option::Option<crate::model::CalculateRouteCarModeOptions>,
        ) -> Self {
            self.car_mode_options = input;
            self
        }
        /// <p>Specifies route preferences when traveling by <code>Truck</code>, such as avoiding routes that use ferries or tolls, and truck specifications to consider when choosing an optimal road.</p>
        /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Truck</code>.</p>
        pub fn truck_mode_options(
            mut self,
            input: crate::model::CalculateRouteTruckModeOptions,
        ) -> Self {
            self.truck_mode_options = Some(input);
            self
        }
        /// <p>Specifies route preferences when traveling by <code>Truck</code>, such as avoiding routes that use ferries or tolls, and truck specifications to consider when choosing an optimal road.</p>
        /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Truck</code>.</p>
        pub fn set_truck_mode_options(
            mut self,
            input: std::option::Option<crate::model::CalculateRouteTruckModeOptions>,
        ) -> Self {
            self.truck_mode_options = input;
            self
        }
        /// Consumes the builder and constructs a [`CalculateRouteInput`](crate::input::CalculateRouteInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CalculateRouteInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CalculateRouteInput {
                calculator_name: self.calculator_name,
                departure_position: self.departure_position,
                destination_position: self.destination_position,
                waypoint_positions: self.waypoint_positions,
                travel_mode: self.travel_mode,
                departure_time: self.departure_time,
                depart_now: self.depart_now,
                distance_unit: self.distance_unit,
                include_leg_geometry: self.include_leg_geometry,
                car_mode_options: self.car_mode_options,
                truck_mode_options: self.truck_mode_options,
            })
        }
    }
}
#[doc(hidden)]
pub type CalculateRouteInputOperationOutputAlias = crate::operation::CalculateRoute;
#[doc(hidden)]
pub type CalculateRouteInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CalculateRouteInput {
    /// Consumes the builder and constructs an Operation<[`CalculateRoute`](crate::operation::CalculateRoute)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CalculateRoute,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CalculateRouteInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_8 = &_input.calculator_name;
                let input_8 = input_8.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "calculator_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let calculator_name = aws_smithy_http::label::fmt_string(input_8, false);
                if calculator_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "calculator_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/routes/v0/calculators/{CalculatorName}/calculate/route",
                    CalculatorName = calculator_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CalculateRouteInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_calculate_route(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("routes.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CalculateRoute::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CalculateRoute",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CalculateRouteInput`](crate::input::CalculateRouteInput)
    pub fn builder() -> crate::input::calculate_route_input::Builder {
        crate::input::calculate_route_input::Builder::default()
    }
}

/// See [`CalculateRouteMatrixInput`](crate::input::CalculateRouteMatrixInput)
pub mod calculate_route_matrix_input {
    /// A builder for [`CalculateRouteMatrixInput`](crate::input::CalculateRouteMatrixInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) calculator_name: std::option::Option<std::string::String>,
        pub(crate) departure_positions: std::option::Option<std::vec::Vec<std::vec::Vec<f64>>>,
        pub(crate) destination_positions: std::option::Option<std::vec::Vec<std::vec::Vec<f64>>>,
        pub(crate) travel_mode: std::option::Option<crate::model::TravelMode>,
        pub(crate) departure_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) depart_now: std::option::Option<bool>,
        pub(crate) distance_unit: std::option::Option<crate::model::DistanceUnit>,
        pub(crate) car_mode_options:
            std::option::Option<crate::model::CalculateRouteCarModeOptions>,
        pub(crate) truck_mode_options:
            std::option::Option<crate::model::CalculateRouteTruckModeOptions>,
    }
    impl Builder {
        /// <p>The name of the route calculator resource that you want to use to calculate the route matrix. </p>
        pub fn calculator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.calculator_name = Some(input.into());
            self
        }
        /// <p>The name of the route calculator resource that you want to use to calculate the route matrix. </p>
        pub fn set_calculator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.calculator_name = input;
            self
        }
        /// Appends an item to `departure_positions`.
        ///
        /// To override the contents of this collection use [`set_departure_positions`](Self::set_departure_positions).
        ///
        /// <p>The list of departure (origin) positions for the route matrix. An array of points, each of which is itself a 2-value array defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>. For example, <code>[-123.115, 49.285]</code>.</p> <important>
        /// <p>Depending on the data provider selected in the route calculator resource there may be additional restrictions on the inputs you can choose. See <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits"> Position restrictions</a> in the <i>Amazon Location Service Developer Guide</i>.</p>
        /// </important> <note>
        /// <p>For route calculators that use Esri as the data provider, if you specify a departure that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html"> moves the position to the nearest road</a>. The snapped value is available in the result in <code>SnappedDeparturePositions</code>.</p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
        pub fn departure_positions(mut self, input: std::vec::Vec<f64>) -> Self {
            let mut v = self.departure_positions.unwrap_or_default();
            v.push(input);
            self.departure_positions = Some(v);
            self
        }
        /// <p>The list of departure (origin) positions for the route matrix. An array of points, each of which is itself a 2-value array defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>. For example, <code>[-123.115, 49.285]</code>.</p> <important>
        /// <p>Depending on the data provider selected in the route calculator resource there may be additional restrictions on the inputs you can choose. See <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits"> Position restrictions</a> in the <i>Amazon Location Service Developer Guide</i>.</p>
        /// </important> <note>
        /// <p>For route calculators that use Esri as the data provider, if you specify a departure that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html"> moves the position to the nearest road</a>. The snapped value is available in the result in <code>SnappedDeparturePositions</code>.</p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
        pub fn set_departure_positions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<f64>>>,
        ) -> Self {
            self.departure_positions = input;
            self
        }
        /// Appends an item to `destination_positions`.
        ///
        /// To override the contents of this collection use [`set_destination_positions`](Self::set_destination_positions).
        ///
        /// <p>The list of destination positions for the route matrix. An array of points, each of which is itself a 2-value array defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>. For example, <code>[-122.339, 47.615]</code> </p> <important>
        /// <p>Depending on the data provider selected in the route calculator resource there may be additional restrictions on the inputs you can choose. See <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits"> Position restrictions</a> in the <i>Amazon Location Service Developer Guide</i>.</p>
        /// </important> <note>
        /// <p>For route calculators that use Esri as the data provider, if you specify a destination that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html"> moves the position to the nearest road</a>. The snapped value is available in the result in <code>SnappedDestinationPositions</code>.</p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
        pub fn destination_positions(mut self, input: std::vec::Vec<f64>) -> Self {
            let mut v = self.destination_positions.unwrap_or_default();
            v.push(input);
            self.destination_positions = Some(v);
            self
        }
        /// <p>The list of destination positions for the route matrix. An array of points, each of which is itself a 2-value array defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>. For example, <code>[-122.339, 47.615]</code> </p> <important>
        /// <p>Depending on the data provider selected in the route calculator resource there may be additional restrictions on the inputs you can choose. See <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits"> Position restrictions</a> in the <i>Amazon Location Service Developer Guide</i>.</p>
        /// </important> <note>
        /// <p>For route calculators that use Esri as the data provider, if you specify a destination that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html"> moves the position to the nearest road</a>. The snapped value is available in the result in <code>SnappedDestinationPositions</code>.</p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
        pub fn set_destination_positions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<f64>>>,
        ) -> Self {
            self.destination_positions = input;
            self
        }
        /// <p>Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road compatibility.</p>
        /// <p>The <code>TravelMode</code> you specify also determines how you specify route preferences: </p>
        /// <ul>
        /// <li> <p>If traveling by <code>Car</code> use the <code>CarModeOptions</code> parameter.</p> </li>
        /// <li> <p>If traveling by <code>Truck</code> use the <code>TruckModeOptions</code> parameter.</p> </li>
        /// </ul>
        /// <p>Default Value: <code>Car</code> </p>
        pub fn travel_mode(mut self, input: crate::model::TravelMode) -> Self {
            self.travel_mode = Some(input);
            self
        }
        /// <p>Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road compatibility.</p>
        /// <p>The <code>TravelMode</code> you specify also determines how you specify route preferences: </p>
        /// <ul>
        /// <li> <p>If traveling by <code>Car</code> use the <code>CarModeOptions</code> parameter.</p> </li>
        /// <li> <p>If traveling by <code>Truck</code> use the <code>TruckModeOptions</code> parameter.</p> </li>
        /// </ul>
        /// <p>Default Value: <code>Car</code> </p>
        pub fn set_travel_mode(
            mut self,
            input: std::option::Option<crate::model::TravelMode>,
        ) -> Self {
            self.travel_mode = input;
            self
        }
        /// <p>Specifies the desired time of departure. Uses the given time to calculate the route matrix. You can't set both <code>DepartureTime</code> and <code>DepartNow</code>. If neither is set, the best time of day to travel with the best traffic conditions is used to calculate the route matrix.</p> <note>
        /// <p>Setting a departure time in the past returns a <code>400 ValidationException</code> error.</p>
        /// </note>
        /// <ul>
        /// <li> <p>In <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
        /// </ul>
        pub fn departure_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.departure_time = Some(input);
            self
        }
        /// <p>Specifies the desired time of departure. Uses the given time to calculate the route matrix. You can't set both <code>DepartureTime</code> and <code>DepartNow</code>. If neither is set, the best time of day to travel with the best traffic conditions is used to calculate the route matrix.</p> <note>
        /// <p>Setting a departure time in the past returns a <code>400 ValidationException</code> error.</p>
        /// </note>
        /// <ul>
        /// <li> <p>In <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
        /// </ul>
        pub fn set_departure_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.departure_time = input;
            self
        }
        /// <p>Sets the time of departure as the current time. Uses the current time to calculate the route matrix. You can't set both <code>DepartureTime</code> and <code>DepartNow</code>. If neither is set, the best time of day to travel with the best traffic conditions is used to calculate the route matrix.</p>
        /// <p>Default Value: <code>false</code> </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
        pub fn depart_now(mut self, input: bool) -> Self {
            self.depart_now = Some(input);
            self
        }
        /// <p>Sets the time of departure as the current time. Uses the current time to calculate the route matrix. You can't set both <code>DepartureTime</code> and <code>DepartNow</code>. If neither is set, the best time of day to travel with the best traffic conditions is used to calculate the route matrix.</p>
        /// <p>Default Value: <code>false</code> </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
        pub fn set_depart_now(mut self, input: std::option::Option<bool>) -> Self {
            self.depart_now = input;
            self
        }
        /// <p>Set the unit system to specify the distance.</p>
        /// <p>Default Value: <code>Kilometers</code> </p>
        pub fn distance_unit(mut self, input: crate::model::DistanceUnit) -> Self {
            self.distance_unit = Some(input);
            self
        }
        /// <p>Set the unit system to specify the distance.</p>
        /// <p>Default Value: <code>Kilometers</code> </p>
        pub fn set_distance_unit(
            mut self,
            input: std::option::Option<crate::model::DistanceUnit>,
        ) -> Self {
            self.distance_unit = input;
            self
        }
        /// <p>Specifies route preferences when traveling by <code>Car</code>, such as avoiding routes that use ferries or tolls.</p>
        /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Car</code>.</p>
        pub fn car_mode_options(
            mut self,
            input: crate::model::CalculateRouteCarModeOptions,
        ) -> Self {
            self.car_mode_options = Some(input);
            self
        }
        /// <p>Specifies route preferences when traveling by <code>Car</code>, such as avoiding routes that use ferries or tolls.</p>
        /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Car</code>.</p>
        pub fn set_car_mode_options(
            mut self,
            input: std::option::Option<crate::model::CalculateRouteCarModeOptions>,
        ) -> Self {
            self.car_mode_options = input;
            self
        }
        /// <p>Specifies route preferences when traveling by <code>Truck</code>, such as avoiding routes that use ferries or tolls, and truck specifications to consider when choosing an optimal road.</p>
        /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Truck</code>.</p>
        pub fn truck_mode_options(
            mut self,
            input: crate::model::CalculateRouteTruckModeOptions,
        ) -> Self {
            self.truck_mode_options = Some(input);
            self
        }
        /// <p>Specifies route preferences when traveling by <code>Truck</code>, such as avoiding routes that use ferries or tolls, and truck specifications to consider when choosing an optimal road.</p>
        /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Truck</code>.</p>
        pub fn set_truck_mode_options(
            mut self,
            input: std::option::Option<crate::model::CalculateRouteTruckModeOptions>,
        ) -> Self {
            self.truck_mode_options = input;
            self
        }
        /// Consumes the builder and constructs a [`CalculateRouteMatrixInput`](crate::input::CalculateRouteMatrixInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CalculateRouteMatrixInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CalculateRouteMatrixInput {
                calculator_name: self.calculator_name,
                departure_positions: self.departure_positions,
                destination_positions: self.destination_positions,
                travel_mode: self.travel_mode,
                departure_time: self.departure_time,
                depart_now: self.depart_now,
                distance_unit: self.distance_unit,
                car_mode_options: self.car_mode_options,
                truck_mode_options: self.truck_mode_options,
            })
        }
    }
}
#[doc(hidden)]
pub type CalculateRouteMatrixInputOperationOutputAlias = crate::operation::CalculateRouteMatrix;
#[doc(hidden)]
pub type CalculateRouteMatrixInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CalculateRouteMatrixInput {
    /// Consumes the builder and constructs an Operation<[`CalculateRouteMatrix`](crate::operation::CalculateRouteMatrix)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CalculateRouteMatrix,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CalculateRouteMatrixInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_9 = &_input.calculator_name;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "calculator_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let calculator_name = aws_smithy_http::label::fmt_string(input_9, false);
                if calculator_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "calculator_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/routes/v0/calculators/{CalculatorName}/calculate/route-matrix",
                    CalculatorName = calculator_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CalculateRouteMatrixInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_calculate_route_matrix(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("routes.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CalculateRouteMatrix::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CalculateRouteMatrix",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CalculateRouteMatrixInput`](crate::input::CalculateRouteMatrixInput)
    pub fn builder() -> crate::input::calculate_route_matrix_input::Builder {
        crate::input::calculate_route_matrix_input::Builder::default()
    }
}

/// See [`CreateGeofenceCollectionInput`](crate::input::CreateGeofenceCollectionInput)
pub mod create_geofence_collection_input {
    /// A builder for [`CreateGeofenceCollectionInput`](crate::input::CreateGeofenceCollectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) collection_name: std::option::Option<std::string::String>,
        pub(crate) pricing_plan: std::option::Option<crate::model::PricingPlan>,
        pub(crate) pricing_plan_data_source: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A custom name for the geofence collection.</p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li> <p>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_). </p> </li>
        /// <li> <p>Must be a unique geofence collection name.</p> </li>
        /// <li> <p>No spaces allowed. For example, <code>ExampleGeofenceCollection</code>.</p> </li>
        /// </ul>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.collection_name = Some(input.into());
            self
        }
        /// <p>A custom name for the geofence collection.</p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li> <p>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_). </p> </li>
        /// <li> <p>Must be a unique geofence collection name.</p> </li>
        /// <li> <p>No spaces allowed. For example, <code>ExampleGeofenceCollection</code>.</p> </li>
        /// </ul>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.collection_name = input;
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.pricing_plan = Some(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.pricing_plan = input;
            self
        }
        /// <p>This parameter is no longer used.</p>
        pub fn pricing_plan_data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.pricing_plan_data_source = Some(input.into());
            self
        }
        /// <p>This parameter is no longer used.</p>
        pub fn set_pricing_plan_data_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pricing_plan_data_source = input;
            self
        }
        /// <p>An optional description for the geofence collection.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description for the geofence collection.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Applies one or more tags to the geofence collection. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource</p> </li>
        /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Applies one or more tags to the geofence collection. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource</p> </li>
        /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN. </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN. </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGeofenceCollectionInput`](crate::input::CreateGeofenceCollectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGeofenceCollectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGeofenceCollectionInput {
                collection_name: self.collection_name,
                pricing_plan: self.pricing_plan,
                pricing_plan_data_source: self.pricing_plan_data_source,
                description: self.description,
                tags: self.tags,
                kms_key_id: self.kms_key_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGeofenceCollectionInputOperationOutputAlias =
    crate::operation::CreateGeofenceCollection;
#[doc(hidden)]
pub type CreateGeofenceCollectionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateGeofenceCollectionInput {
    /// Consumes the builder and constructs an Operation<[`CreateGeofenceCollection`](crate::operation::CreateGeofenceCollection)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGeofenceCollection,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateGeofenceCollectionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/geofencing/v0/collections").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateGeofenceCollectionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_geofence_collection(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("geofencing.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGeofenceCollection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGeofenceCollection",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateGeofenceCollectionInput`](crate::input::CreateGeofenceCollectionInput)
    pub fn builder() -> crate::input::create_geofence_collection_input::Builder {
        crate::input::create_geofence_collection_input::Builder::default()
    }
}

/// See [`CreateMapInput`](crate::input::CreateMapInput)
pub mod create_map_input {
    /// A builder for [`CreateMapInput`](crate::input::CreateMapInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) map_name: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<crate::model::MapConfiguration>,
        pub(crate) pricing_plan: std::option::Option<crate::model::PricingPlan>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name for the map resource.</p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li> <p>Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_). </p> </li>
        /// <li> <p>Must be a unique map resource name. </p> </li>
        /// <li> <p>No spaces allowed. For example, <code>ExampleMap</code>.</p> </li>
        /// </ul>
        pub fn map_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.map_name = Some(input.into());
            self
        }
        /// <p>The name for the map resource.</p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li> <p>Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_). </p> </li>
        /// <li> <p>Must be a unique map resource name. </p> </li>
        /// <li> <p>No spaces allowed. For example, <code>ExampleMap</code>.</p> </li>
        /// </ul>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.map_name = input;
            self
        }
        /// <p>Specifies the map style selected from an available data provider.</p>
        pub fn configuration(mut self, input: crate::model::MapConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>Specifies the map style selected from an available data provider.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::MapConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.pricing_plan = Some(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.pricing_plan = input;
            self
        }
        /// <p>An optional description for the map resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description for the map resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Applies one or more tags to the map resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource</p> </li>
        /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Applies one or more tags to the map resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource</p> </li>
        /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMapInput`](crate::input::CreateMapInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::CreateMapInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::CreateMapInput {
                map_name: self.map_name,
                configuration: self.configuration,
                pricing_plan: self.pricing_plan,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMapInputOperationOutputAlias = crate::operation::CreateMap;
#[doc(hidden)]
pub type CreateMapInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateMapInput {
    /// Consumes the builder and constructs an Operation<[`CreateMap`](crate::operation::CreateMap)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMap,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateMapInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/maps/v0/maps").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateMapInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_map(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("maps.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::CreateMap::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "CreateMap",
                    "location",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateMapInput`](crate::input::CreateMapInput)
    pub fn builder() -> crate::input::create_map_input::Builder {
        crate::input::create_map_input::Builder::default()
    }
}

/// See [`CreatePlaceIndexInput`](crate::input::CreatePlaceIndexInput)
pub mod create_place_index_input {
    /// A builder for [`CreatePlaceIndexInput`](crate::input::CreatePlaceIndexInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) data_source: std::option::Option<std::string::String>,
        pub(crate) pricing_plan: std::option::Option<crate::model::PricingPlan>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) data_source_configuration:
            std::option::Option<crate::model::DataSourceConfiguration>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the place index resource. </p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li> <p>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).</p> </li>
        /// <li> <p>Must be a unique place index resource name.</p> </li>
        /// <li> <p>No spaces allowed. For example, <code>ExamplePlaceIndex</code>.</p> </li>
        /// </ul>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the place index resource. </p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li> <p>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).</p> </li>
        /// <li> <p>Must be a unique place index resource name.</p> </li>
        /// <li> <p>No spaces allowed. For example, <code>ExamplePlaceIndex</code>.</p> </li>
        /// </ul>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>Specifies the geospatial data provider for the new place index.</p> <note>
        /// <p>This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> returns an error.</p>
        /// </note>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>Esri</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>'s coverage in your region of interest, see <a href="https://developers.arcgis.com/rest/geocode/api-reference/geocode-coverage.htm">Esri details on geocoding coverage</a>.</p> </li>
        /// <li> <p> <code>Here</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a>' coverage in your region of interest, see <a href="https://developer.here.com/documentation/geocoder/dev_guide/topics/coverage-geocoder.html">HERE details on goecoding coverage</a>.</p> <important>
        /// <p>If you specify HERE Technologies (<code>Here</code>) as the data provider, you may not <a href="https://docs.aws.amazon.com/location-places/latest/APIReference/API_DataSourceConfiguration.html">store results</a> for locations in Japan. For more information, see the <a href="https://aws.amazon.com/service-terms/">AWS Service Terms</a> for Amazon Location Service.</p>
        /// </important> </li>
        /// </ul>
        /// <p>For additional information , see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data providers</a> on the <i>Amazon Location Service Developer Guide</i>.</p>
        pub fn data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source = Some(input.into());
            self
        }
        /// <p>Specifies the geospatial data provider for the new place index.</p> <note>
        /// <p>This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> returns an error.</p>
        /// </note>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>Esri</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>'s coverage in your region of interest, see <a href="https://developers.arcgis.com/rest/geocode/api-reference/geocode-coverage.htm">Esri details on geocoding coverage</a>.</p> </li>
        /// <li> <p> <code>Here</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a>' coverage in your region of interest, see <a href="https://developer.here.com/documentation/geocoder/dev_guide/topics/coverage-geocoder.html">HERE details on goecoding coverage</a>.</p> <important>
        /// <p>If you specify HERE Technologies (<code>Here</code>) as the data provider, you may not <a href="https://docs.aws.amazon.com/location-places/latest/APIReference/API_DataSourceConfiguration.html">store results</a> for locations in Japan. For more information, see the <a href="https://aws.amazon.com/service-terms/">AWS Service Terms</a> for Amazon Location Service.</p>
        /// </important> </li>
        /// </ul>
        /// <p>For additional information , see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data providers</a> on the <i>Amazon Location Service Developer Guide</i>.</p>
        pub fn set_data_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_source = input;
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.pricing_plan = Some(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.pricing_plan = input;
            self
        }
        /// <p>The optional description for the place index resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The optional description for the place index resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specifies the data storage option requesting Places.</p>
        pub fn data_source_configuration(
            mut self,
            input: crate::model::DataSourceConfiguration,
        ) -> Self {
            self.data_source_configuration = Some(input);
            self
        }
        /// <p>Specifies the data storage option requesting Places.</p>
        pub fn set_data_source_configuration(
            mut self,
            input: std::option::Option<crate::model::DataSourceConfiguration>,
        ) -> Self {
            self.data_source_configuration = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Applies one or more tags to the place index resource. A tag is a key-value pair that helps you manage, identify, search, and filter your resources.</p>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource.</p> </li>
        /// <li> <p>Each tag key must be unique and must have exactly one associated value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8.</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8.</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @</p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Applies one or more tags to the place index resource. A tag is a key-value pair that helps you manage, identify, search, and filter your resources.</p>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource.</p> </li>
        /// <li> <p>Each tag key must be unique and must have exactly one associated value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8.</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8.</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @</p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePlaceIndexInput`](crate::input::CreatePlaceIndexInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreatePlaceIndexInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreatePlaceIndexInput {
                index_name: self.index_name,
                data_source: self.data_source,
                pricing_plan: self.pricing_plan,
                description: self.description,
                data_source_configuration: self.data_source_configuration,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreatePlaceIndexInputOperationOutputAlias = crate::operation::CreatePlaceIndex;
#[doc(hidden)]
pub type CreatePlaceIndexInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreatePlaceIndexInput {
    /// Consumes the builder and constructs an Operation<[`CreatePlaceIndex`](crate::operation::CreatePlaceIndex)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreatePlaceIndex,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreatePlaceIndexInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/places/v0/indexes").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreatePlaceIndexInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_place_index(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("places.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreatePlaceIndex::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreatePlaceIndex",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreatePlaceIndexInput`](crate::input::CreatePlaceIndexInput)
    pub fn builder() -> crate::input::create_place_index_input::Builder {
        crate::input::create_place_index_input::Builder::default()
    }
}

/// See [`CreateRouteCalculatorInput`](crate::input::CreateRouteCalculatorInput)
pub mod create_route_calculator_input {
    /// A builder for [`CreateRouteCalculatorInput`](crate::input::CreateRouteCalculatorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) calculator_name: std::option::Option<std::string::String>,
        pub(crate) data_source: std::option::Option<std::string::String>,
        pub(crate) pricing_plan: std::option::Option<crate::model::PricingPlan>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the route calculator resource. </p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).</p> </li>
        /// <li> <p>Must be a unique Route calculator resource name.</p> </li>
        /// <li> <p>No spaces allowed. For example, <code>ExampleRouteCalculator</code>.</p> </li>
        /// </ul>
        pub fn calculator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.calculator_name = Some(input.into());
            self
        }
        /// <p>The name of the route calculator resource. </p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).</p> </li>
        /// <li> <p>Must be a unique Route calculator resource name.</p> </li>
        /// <li> <p>No spaces allowed. For example, <code>ExampleRouteCalculator</code>.</p> </li>
        /// </ul>
        pub fn set_calculator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.calculator_name = input;
            self
        }
        /// <p>Specifies the data provider of traffic and road network data.</p> <note>
        /// <p>This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> returns an error. Route calculators that use Esri as a data source only calculate routes that are shorter than 400 km.</p>
        /// </note>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>Esri</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>'s coverage in your region of interest, see <a href="https://doc.arcgis.com/en/arcgis-online/reference/network-coverage.htm">Esri details on street networks and traffic coverage</a>.</p> </li>
        /// <li> <p> <code>Here</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a>' coverage in your region of interest, see <a href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/car-routing.html">HERE car routing coverage</a> and <a href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/truck-routing.html">HERE truck routing coverage</a>.</p> </li>
        /// </ul>
        /// <p>For additional information , see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data providers</a> on the <i>Amazon Location Service Developer Guide</i>.</p>
        pub fn data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source = Some(input.into());
            self
        }
        /// <p>Specifies the data provider of traffic and road network data.</p> <note>
        /// <p>This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> returns an error. Route calculators that use Esri as a data source only calculate routes that are shorter than 400 km.</p>
        /// </note>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>Esri</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>'s coverage in your region of interest, see <a href="https://doc.arcgis.com/en/arcgis-online/reference/network-coverage.htm">Esri details on street networks and traffic coverage</a>.</p> </li>
        /// <li> <p> <code>Here</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a>' coverage in your region of interest, see <a href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/car-routing.html">HERE car routing coverage</a> and <a href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/truck-routing.html">HERE truck routing coverage</a>.</p> </li>
        /// </ul>
        /// <p>For additional information , see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data providers</a> on the <i>Amazon Location Service Developer Guide</i>.</p>
        pub fn set_data_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_source = input;
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.pricing_plan = Some(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.pricing_plan = input;
            self
        }
        /// <p>The optional description for the route calculator resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The optional description for the route calculator resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Applies one or more tags to the route calculator resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
        /// <ul>
        /// <li> <p>For example: { <code>"tag1" : "value1"</code>, <code>"tag2" : "value2"</code>}</p> </li>
        /// </ul>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource</p> </li>
        /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Applies one or more tags to the route calculator resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
        /// <ul>
        /// <li> <p>For example: { <code>"tag1" : "value1"</code>, <code>"tag2" : "value2"</code>}</p> </li>
        /// </ul>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource</p> </li>
        /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRouteCalculatorInput`](crate::input::CreateRouteCalculatorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRouteCalculatorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRouteCalculatorInput {
                calculator_name: self.calculator_name,
                data_source: self.data_source,
                pricing_plan: self.pricing_plan,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRouteCalculatorInputOperationOutputAlias = crate::operation::CreateRouteCalculator;
#[doc(hidden)]
pub type CreateRouteCalculatorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateRouteCalculatorInput {
    /// Consumes the builder and constructs an Operation<[`CreateRouteCalculator`](crate::operation::CreateRouteCalculator)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRouteCalculator,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateRouteCalculatorInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/routes/v0/calculators").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateRouteCalculatorInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_route_calculator(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("routes.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRouteCalculator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRouteCalculator",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateRouteCalculatorInput`](crate::input::CreateRouteCalculatorInput)
    pub fn builder() -> crate::input::create_route_calculator_input::Builder {
        crate::input::create_route_calculator_input::Builder::default()
    }
}

/// See [`CreateTrackerInput`](crate::input::CreateTrackerInput)
pub mod create_tracker_input {
    /// A builder for [`CreateTrackerInput`](crate::input::CreateTrackerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tracker_name: std::option::Option<std::string::String>,
        pub(crate) pricing_plan: std::option::Option<crate::model::PricingPlan>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) pricing_plan_data_source: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) position_filtering: std::option::Option<crate::model::PositionFiltering>,
    }
    impl Builder {
        /// <p>The name for the tracker resource.</p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li> <p>Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).</p> </li>
        /// <li> <p>Must be a unique tracker resource name.</p> </li>
        /// <li> <p>No spaces allowed. For example, <code>ExampleTracker</code>.</p> </li>
        /// </ul>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracker_name = Some(input.into());
            self
        }
        /// <p>The name for the tracker resource.</p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li> <p>Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).</p> </li>
        /// <li> <p>Must be a unique tracker resource name.</p> </li>
        /// <li> <p>No spaces allowed. For example, <code>ExampleTracker</code>.</p> </li>
        /// </ul>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tracker_name = input;
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.pricing_plan = Some(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.pricing_plan = input;
            self
        }
        /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>This parameter is no longer used.</p>
        pub fn pricing_plan_data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.pricing_plan_data_source = Some(input.into());
            self
        }
        /// <p>This parameter is no longer used.</p>
        pub fn set_pricing_plan_data_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pricing_plan_data_source = input;
            self
        }
        /// <p>An optional description for the tracker resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description for the tracker resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Applies one or more tags to the tracker resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource</p> </li>
        /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Applies one or more tags to the tracker resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource</p> </li>
        /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Specifies the position filtering for the tracker resource.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li> <p> <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID. </p> </li>
        /// <li> <p> <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this area are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map. </p> </li>
        /// <li> <p> <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This can reduce the effects of GPS noise when displaying device trajectories on a map, and can help control your costs by reducing the number of geofence evaluations. </p> </li>
        /// </ul>
        /// <p>This field is optional. If not specified, the default value is <code>TimeBased</code>.</p>
        pub fn position_filtering(mut self, input: crate::model::PositionFiltering) -> Self {
            self.position_filtering = Some(input);
            self
        }
        /// <p>Specifies the position filtering for the tracker resource.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li> <p> <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID. </p> </li>
        /// <li> <p> <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this area are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map. </p> </li>
        /// <li> <p> <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This can reduce the effects of GPS noise when displaying device trajectories on a map, and can help control your costs by reducing the number of geofence evaluations. </p> </li>
        /// </ul>
        /// <p>This field is optional. If not specified, the default value is <code>TimeBased</code>.</p>
        pub fn set_position_filtering(
            mut self,
            input: std::option::Option<crate::model::PositionFiltering>,
        ) -> Self {
            self.position_filtering = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTrackerInput`](crate::input::CreateTrackerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTrackerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTrackerInput {
                tracker_name: self.tracker_name,
                pricing_plan: self.pricing_plan,
                kms_key_id: self.kms_key_id,
                pricing_plan_data_source: self.pricing_plan_data_source,
                description: self.description,
                tags: self.tags,
                position_filtering: self.position_filtering,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTrackerInputOperationOutputAlias = crate::operation::CreateTracker;
#[doc(hidden)]
pub type CreateTrackerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateTrackerInput {
    /// Consumes the builder and constructs an Operation<[`CreateTracker`](crate::operation::CreateTracker)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateTracker,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateTrackerInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/tracking/v0/trackers").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateTrackerInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_tracker(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("tracking.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateTracker::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateTracker",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateTrackerInput`](crate::input::CreateTrackerInput)
    pub fn builder() -> crate::input::create_tracker_input::Builder {
        crate::input::create_tracker_input::Builder::default()
    }
}

/// See [`DeleteGeofenceCollectionInput`](crate::input::DeleteGeofenceCollectionInput)
pub mod delete_geofence_collection_input {
    /// A builder for [`DeleteGeofenceCollectionInput`](crate::input::DeleteGeofenceCollectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) collection_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the geofence collection to be deleted.</p>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.collection_name = Some(input.into());
            self
        }
        /// <p>The name of the geofence collection to be deleted.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.collection_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGeofenceCollectionInput`](crate::input::DeleteGeofenceCollectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGeofenceCollectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGeofenceCollectionInput {
                collection_name: self.collection_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGeofenceCollectionInputOperationOutputAlias =
    crate::operation::DeleteGeofenceCollection;
#[doc(hidden)]
pub type DeleteGeofenceCollectionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteGeofenceCollectionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGeofenceCollection`](crate::operation::DeleteGeofenceCollection)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGeofenceCollection,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteGeofenceCollectionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_10 = &_input.collection_name;
                let input_10 = input_10.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "collection_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let collection_name = aws_smithy_http::label::fmt_string(input_10, false);
                if collection_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "collection_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/geofencing/v0/collections/{CollectionName}",
                    CollectionName = collection_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteGeofenceCollectionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("geofencing.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGeofenceCollection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGeofenceCollection",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteGeofenceCollectionInput`](crate::input::DeleteGeofenceCollectionInput)
    pub fn builder() -> crate::input::delete_geofence_collection_input::Builder {
        crate::input::delete_geofence_collection_input::Builder::default()
    }
}

/// See [`DeleteMapInput`](crate::input::DeleteMapInput)
pub mod delete_map_input {
    /// A builder for [`DeleteMapInput`](crate::input::DeleteMapInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) map_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the map resource to be deleted.</p>
        pub fn map_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.map_name = Some(input.into());
            self
        }
        /// <p>The name of the map resource to be deleted.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.map_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMapInput`](crate::input::DeleteMapInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::DeleteMapInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::DeleteMapInput {
                map_name: self.map_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMapInputOperationOutputAlias = crate::operation::DeleteMap;
#[doc(hidden)]
pub type DeleteMapInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteMapInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMap`](crate::operation::DeleteMap)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMap,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteMapInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_11 = &_input.map_name;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "map_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let map_name = aws_smithy_http::label::fmt_string(input_11, false);
                if map_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "map_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/maps/v0/maps/{MapName}", MapName = map_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteMapInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("maps.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::DeleteMap::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "DeleteMap",
                    "location",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteMapInput`](crate::input::DeleteMapInput)
    pub fn builder() -> crate::input::delete_map_input::Builder {
        crate::input::delete_map_input::Builder::default()
    }
}

/// See [`DeletePlaceIndexInput`](crate::input::DeletePlaceIndexInput)
pub mod delete_place_index_input {
    /// A builder for [`DeletePlaceIndexInput`](crate::input::DeletePlaceIndexInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the place index resource to be deleted.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the place index resource to be deleted.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePlaceIndexInput`](crate::input::DeletePlaceIndexInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeletePlaceIndexInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeletePlaceIndexInput {
                index_name: self.index_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeletePlaceIndexInputOperationOutputAlias = crate::operation::DeletePlaceIndex;
#[doc(hidden)]
pub type DeletePlaceIndexInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeletePlaceIndexInput {
    /// Consumes the builder and constructs an Operation<[`DeletePlaceIndex`](crate::operation::DeletePlaceIndex)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeletePlaceIndex,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeletePlaceIndexInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_12 = &_input.index_name;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "index_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let index_name = aws_smithy_http::label::fmt_string(input_12, false);
                if index_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "index_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/places/v0/indexes/{IndexName}",
                    IndexName = index_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeletePlaceIndexInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("places.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeletePlaceIndex::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeletePlaceIndex",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeletePlaceIndexInput`](crate::input::DeletePlaceIndexInput)
    pub fn builder() -> crate::input::delete_place_index_input::Builder {
        crate::input::delete_place_index_input::Builder::default()
    }
}

/// See [`DeleteRouteCalculatorInput`](crate::input::DeleteRouteCalculatorInput)
pub mod delete_route_calculator_input {
    /// A builder for [`DeleteRouteCalculatorInput`](crate::input::DeleteRouteCalculatorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) calculator_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the route calculator resource to be deleted.</p>
        pub fn calculator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.calculator_name = Some(input.into());
            self
        }
        /// <p>The name of the route calculator resource to be deleted.</p>
        pub fn set_calculator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.calculator_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRouteCalculatorInput`](crate::input::DeleteRouteCalculatorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRouteCalculatorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRouteCalculatorInput {
                calculator_name: self.calculator_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRouteCalculatorInputOperationOutputAlias = crate::operation::DeleteRouteCalculator;
#[doc(hidden)]
pub type DeleteRouteCalculatorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRouteCalculatorInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRouteCalculator`](crate::operation::DeleteRouteCalculator)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRouteCalculator,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteRouteCalculatorInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_13 = &_input.calculator_name;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "calculator_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let calculator_name = aws_smithy_http::label::fmt_string(input_13, false);
                if calculator_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "calculator_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/routes/v0/calculators/{CalculatorName}",
                    CalculatorName = calculator_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteRouteCalculatorInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("routes.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRouteCalculator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRouteCalculator",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteRouteCalculatorInput`](crate::input::DeleteRouteCalculatorInput)
    pub fn builder() -> crate::input::delete_route_calculator_input::Builder {
        crate::input::delete_route_calculator_input::Builder::default()
    }
}

/// See [`DeleteTrackerInput`](crate::input::DeleteTrackerInput)
pub mod delete_tracker_input {
    /// A builder for [`DeleteTrackerInput`](crate::input::DeleteTrackerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tracker_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the tracker resource to be deleted.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracker_name = Some(input.into());
            self
        }
        /// <p>The name of the tracker resource to be deleted.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tracker_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTrackerInput`](crate::input::DeleteTrackerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTrackerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTrackerInput {
                tracker_name: self.tracker_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTrackerInputOperationOutputAlias = crate::operation::DeleteTracker;
#[doc(hidden)]
pub type DeleteTrackerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteTrackerInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTracker`](crate::operation::DeleteTracker)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTracker,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteTrackerInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_14 = &_input.tracker_name;
                let input_14 = input_14.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let tracker_name = aws_smithy_http::label::fmt_string(input_14, false);
                if tracker_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/tracking/v0/trackers/{TrackerName}",
                    TrackerName = tracker_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteTrackerInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("tracking.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTracker::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTracker",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteTrackerInput`](crate::input::DeleteTrackerInput)
    pub fn builder() -> crate::input::delete_tracker_input::Builder {
        crate::input::delete_tracker_input::Builder::default()
    }
}

/// See [`DescribeGeofenceCollectionInput`](crate::input::DescribeGeofenceCollectionInput)
pub mod describe_geofence_collection_input {
    /// A builder for [`DescribeGeofenceCollectionInput`](crate::input::DescribeGeofenceCollectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) collection_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the geofence collection.</p>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.collection_name = Some(input.into());
            self
        }
        /// <p>The name of the geofence collection.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.collection_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGeofenceCollectionInput`](crate::input::DescribeGeofenceCollectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeGeofenceCollectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeGeofenceCollectionInput {
                collection_name: self.collection_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeGeofenceCollectionInputOperationOutputAlias =
    crate::operation::DescribeGeofenceCollection;
#[doc(hidden)]
pub type DescribeGeofenceCollectionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeGeofenceCollectionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeGeofenceCollection`](crate::operation::DescribeGeofenceCollection)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeGeofenceCollection,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeGeofenceCollectionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_15 = &_input.collection_name;
                let input_15 = input_15.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "collection_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let collection_name = aws_smithy_http::label::fmt_string(input_15, false);
                if collection_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "collection_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/geofencing/v0/collections/{CollectionName}",
                    CollectionName = collection_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeGeofenceCollectionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("geofencing.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeGeofenceCollection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeGeofenceCollection",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeGeofenceCollectionInput`](crate::input::DescribeGeofenceCollectionInput)
    pub fn builder() -> crate::input::describe_geofence_collection_input::Builder {
        crate::input::describe_geofence_collection_input::Builder::default()
    }
}

/// See [`DescribeMapInput`](crate::input::DescribeMapInput)
pub mod describe_map_input {
    /// A builder for [`DescribeMapInput`](crate::input::DescribeMapInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) map_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the map resource.</p>
        pub fn map_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.map_name = Some(input.into());
            self
        }
        /// <p>The name of the map resource.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.map_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMapInput`](crate::input::DescribeMapInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMapInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMapInput {
                map_name: self.map_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMapInputOperationOutputAlias = crate::operation::DescribeMap;
#[doc(hidden)]
pub type DescribeMapInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeMapInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMap`](crate::operation::DescribeMap)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMap,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeMapInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_16 = &_input.map_name;
                let input_16 = input_16.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "map_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let map_name = aws_smithy_http::label::fmt_string(input_16, false);
                if map_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "map_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/maps/v0/maps/{MapName}", MapName = map_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeMapInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("maps.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMap::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMap",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeMapInput`](crate::input::DescribeMapInput)
    pub fn builder() -> crate::input::describe_map_input::Builder {
        crate::input::describe_map_input::Builder::default()
    }
}

/// See [`DescribePlaceIndexInput`](crate::input::DescribePlaceIndexInput)
pub mod describe_place_index_input {
    /// A builder for [`DescribePlaceIndexInput`](crate::input::DescribePlaceIndexInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the place index resource.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the place index resource.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePlaceIndexInput`](crate::input::DescribePlaceIndexInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePlaceIndexInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePlaceIndexInput {
                index_name: self.index_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePlaceIndexInputOperationOutputAlias = crate::operation::DescribePlaceIndex;
#[doc(hidden)]
pub type DescribePlaceIndexInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribePlaceIndexInput {
    /// Consumes the builder and constructs an Operation<[`DescribePlaceIndex`](crate::operation::DescribePlaceIndex)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePlaceIndex,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribePlaceIndexInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_17 = &_input.index_name;
                let input_17 = input_17.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "index_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let index_name = aws_smithy_http::label::fmt_string(input_17, false);
                if index_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "index_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/places/v0/indexes/{IndexName}",
                    IndexName = index_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribePlaceIndexInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("places.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePlaceIndex::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePlaceIndex",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribePlaceIndexInput`](crate::input::DescribePlaceIndexInput)
    pub fn builder() -> crate::input::describe_place_index_input::Builder {
        crate::input::describe_place_index_input::Builder::default()
    }
}

/// See [`DescribeRouteCalculatorInput`](crate::input::DescribeRouteCalculatorInput)
pub mod describe_route_calculator_input {
    /// A builder for [`DescribeRouteCalculatorInput`](crate::input::DescribeRouteCalculatorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) calculator_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the route calculator resource.</p>
        pub fn calculator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.calculator_name = Some(input.into());
            self
        }
        /// <p>The name of the route calculator resource.</p>
        pub fn set_calculator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.calculator_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRouteCalculatorInput`](crate::input::DescribeRouteCalculatorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRouteCalculatorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRouteCalculatorInput {
                calculator_name: self.calculator_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRouteCalculatorInputOperationOutputAlias =
    crate::operation::DescribeRouteCalculator;
#[doc(hidden)]
pub type DescribeRouteCalculatorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeRouteCalculatorInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRouteCalculator`](crate::operation::DescribeRouteCalculator)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRouteCalculator,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeRouteCalculatorInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_18 = &_input.calculator_name;
                let input_18 = input_18.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "calculator_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let calculator_name = aws_smithy_http::label::fmt_string(input_18, false);
                if calculator_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "calculator_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/routes/v0/calculators/{CalculatorName}",
                    CalculatorName = calculator_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeRouteCalculatorInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("routes.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRouteCalculator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRouteCalculator",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeRouteCalculatorInput`](crate::input::DescribeRouteCalculatorInput)
    pub fn builder() -> crate::input::describe_route_calculator_input::Builder {
        crate::input::describe_route_calculator_input::Builder::default()
    }
}

/// See [`DescribeTrackerInput`](crate::input::DescribeTrackerInput)
pub mod describe_tracker_input {
    /// A builder for [`DescribeTrackerInput`](crate::input::DescribeTrackerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tracker_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the tracker resource.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracker_name = Some(input.into());
            self
        }
        /// <p>The name of the tracker resource.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tracker_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTrackerInput`](crate::input::DescribeTrackerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTrackerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTrackerInput {
                tracker_name: self.tracker_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTrackerInputOperationOutputAlias = crate::operation::DescribeTracker;
#[doc(hidden)]
pub type DescribeTrackerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeTrackerInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTracker`](crate::operation::DescribeTracker)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTracker,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeTrackerInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_19 = &_input.tracker_name;
                let input_19 = input_19.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let tracker_name = aws_smithy_http::label::fmt_string(input_19, false);
                if tracker_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/tracking/v0/trackers/{TrackerName}",
                    TrackerName = tracker_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeTrackerInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("tracking.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTracker::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTracker",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeTrackerInput`](crate::input::DescribeTrackerInput)
    pub fn builder() -> crate::input::describe_tracker_input::Builder {
        crate::input::describe_tracker_input::Builder::default()
    }
}

/// See [`DisassociateTrackerConsumerInput`](crate::input::DisassociateTrackerConsumerInput)
pub mod disassociate_tracker_consumer_input {
    /// A builder for [`DisassociateTrackerConsumerInput`](crate::input::DisassociateTrackerConsumerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tracker_name: std::option::Option<std::string::String>,
        pub(crate) consumer_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the tracker resource to be dissociated from the consumer.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracker_name = Some(input.into());
            self
        }
        /// <p>The name of the tracker resource to be dissociated from the consumer.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tracker_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the geofence collection to be disassociated from the tracker resource. Used when you need to specify a resource across all AWS. </p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code> </p> </li>
        /// </ul>
        pub fn consumer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.consumer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the geofence collection to be disassociated from the tracker resource. Used when you need to specify a resource across all AWS. </p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code> </p> </li>
        /// </ul>
        pub fn set_consumer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.consumer_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateTrackerConsumerInput`](crate::input::DisassociateTrackerConsumerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateTrackerConsumerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateTrackerConsumerInput {
                tracker_name: self.tracker_name,
                consumer_arn: self.consumer_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateTrackerConsumerInputOperationOutputAlias =
    crate::operation::DisassociateTrackerConsumer;
#[doc(hidden)]
pub type DisassociateTrackerConsumerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateTrackerConsumerInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateTrackerConsumer`](crate::operation::DisassociateTrackerConsumer)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateTrackerConsumer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DisassociateTrackerConsumerInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_20 = &_input.tracker_name;
                let input_20 = input_20.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let tracker_name = aws_smithy_http::label::fmt_string(input_20, false);
                if tracker_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_21 = &_input.consumer_arn;
                let input_21 = input_21.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "consumer_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let consumer_arn = aws_smithy_http::label::fmt_string(input_21, false);
                if consumer_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "consumer_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/tracking/v0/trackers/{TrackerName}/consumers/{ConsumerArn}",
                    TrackerName = tracker_name,
                    ConsumerArn = consumer_arn
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DisassociateTrackerConsumerInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("tracking.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateTrackerConsumer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateTrackerConsumer",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DisassociateTrackerConsumerInput`](crate::input::DisassociateTrackerConsumerInput)
    pub fn builder() -> crate::input::disassociate_tracker_consumer_input::Builder {
        crate::input::disassociate_tracker_consumer_input::Builder::default()
    }
}

/// See [`GetDevicePositionInput`](crate::input::GetDevicePositionInput)
pub mod get_device_position_input {
    /// A builder for [`GetDevicePositionInput`](crate::input::GetDevicePositionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tracker_name: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The tracker resource receiving the position update.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracker_name = Some(input.into());
            self
        }
        /// <p>The tracker resource receiving the position update.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tracker_name = input;
            self
        }
        /// <p>The device whose position you want to retrieve.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The device whose position you want to retrieve.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDevicePositionInput`](crate::input::GetDevicePositionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDevicePositionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDevicePositionInput {
                tracker_name: self.tracker_name,
                device_id: self.device_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDevicePositionInputOperationOutputAlias = crate::operation::GetDevicePosition;
#[doc(hidden)]
pub type GetDevicePositionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDevicePositionInput {
    /// Consumes the builder and constructs an Operation<[`GetDevicePosition`](crate::operation::GetDevicePosition)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDevicePosition,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDevicePositionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_22 = &_input.tracker_name;
                let input_22 = input_22.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let tracker_name = aws_smithy_http::label::fmt_string(input_22, false);
                if tracker_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_23 = &_input.device_id;
                let input_23 = input_23.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let device_id = aws_smithy_http::label::fmt_string(input_23, false);
                if device_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/tracking/v0/trackers/{TrackerName}/devices/{DeviceId}/positions/latest",
                    TrackerName = tracker_name,
                    DeviceId = device_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDevicePositionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("tracking.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDevicePosition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDevicePosition",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDevicePositionInput`](crate::input::GetDevicePositionInput)
    pub fn builder() -> crate::input::get_device_position_input::Builder {
        crate::input::get_device_position_input::Builder::default()
    }
}

/// See [`GetDevicePositionHistoryInput`](crate::input::GetDevicePositionHistoryInput)
pub mod get_device_position_history_input {
    /// A builder for [`GetDevicePositionHistoryInput`](crate::input::GetDevicePositionHistoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tracker_name: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) start_time_inclusive: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time_exclusive: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The tracker resource receiving the request for the device position history.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracker_name = Some(input.into());
            self
        }
        /// <p>The tracker resource receiving the request for the device position history.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tracker_name = input;
            self
        }
        /// <p>The device whose position history you want to retrieve.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The device whose position history you want to retrieve.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code> </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code> </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Specify the start time for the position history in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be 24 hours prior to the time that the request is made.</p>
        /// <p>Requirement:</p>
        /// <ul>
        /// <li> <p>The time specified for <code>StartTimeInclusive</code> must be before <code>EndTimeExclusive</code>.</p> </li>
        /// </ul>
        pub fn start_time_inclusive(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time_inclusive = Some(input);
            self
        }
        /// <p>Specify the start time for the position history in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be 24 hours prior to the time that the request is made.</p>
        /// <p>Requirement:</p>
        /// <ul>
        /// <li> <p>The time specified for <code>StartTimeInclusive</code> must be before <code>EndTimeExclusive</code>.</p> </li>
        /// </ul>
        pub fn set_start_time_inclusive(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time_inclusive = input;
            self
        }
        /// <p>Specify the end time for the position history in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be the time that the request is made.</p>
        /// <p>Requirement:</p>
        /// <ul>
        /// <li> <p>The time specified for <code>EndTimeExclusive</code> must be after the time for <code>StartTimeInclusive</code>.</p> </li>
        /// </ul>
        pub fn end_time_exclusive(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time_exclusive = Some(input);
            self
        }
        /// <p>Specify the end time for the position history in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be the time that the request is made.</p>
        /// <p>Requirement:</p>
        /// <ul>
        /// <li> <p>The time specified for <code>EndTimeExclusive</code> must be after the time for <code>StartTimeInclusive</code>.</p> </li>
        /// </ul>
        pub fn set_end_time_exclusive(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time_exclusive = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDevicePositionHistoryInput`](crate::input::GetDevicePositionHistoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDevicePositionHistoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDevicePositionHistoryInput {
                tracker_name: self.tracker_name,
                device_id: self.device_id,
                next_token: self.next_token,
                start_time_inclusive: self.start_time_inclusive,
                end_time_exclusive: self.end_time_exclusive,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDevicePositionHistoryInputOperationOutputAlias =
    crate::operation::GetDevicePositionHistory;
#[doc(hidden)]
pub type GetDevicePositionHistoryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDevicePositionHistoryInput {
    /// Consumes the builder and constructs an Operation<[`GetDevicePositionHistory`](crate::operation::GetDevicePositionHistory)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDevicePositionHistory,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDevicePositionHistoryInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_24 = &_input.tracker_name;
                let input_24 = input_24.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let tracker_name = aws_smithy_http::label::fmt_string(input_24, false);
                if tracker_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_25 = &_input.device_id;
                let input_25 = input_25.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let device_id = aws_smithy_http::label::fmt_string(input_25, false);
                if device_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "device_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/tracking/v0/trackers/{TrackerName}/devices/{DeviceId}/list-positions",
                    TrackerName = tracker_name,
                    DeviceId = device_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDevicePositionHistoryInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_device_position_history(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("tracking.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDevicePositionHistory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDevicePositionHistory",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDevicePositionHistoryInput`](crate::input::GetDevicePositionHistoryInput)
    pub fn builder() -> crate::input::get_device_position_history_input::Builder {
        crate::input::get_device_position_history_input::Builder::default()
    }
}

/// See [`GetGeofenceInput`](crate::input::GetGeofenceInput)
pub mod get_geofence_input {
    /// A builder for [`GetGeofenceInput`](crate::input::GetGeofenceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) collection_name: std::option::Option<std::string::String>,
        pub(crate) geofence_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The geofence collection storing the target geofence.</p>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.collection_name = Some(input.into());
            self
        }
        /// <p>The geofence collection storing the target geofence.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.collection_name = input;
            self
        }
        /// <p>The geofence you're retrieving details for.</p>
        pub fn geofence_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.geofence_id = Some(input.into());
            self
        }
        /// <p>The geofence you're retrieving details for.</p>
        pub fn set_geofence_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.geofence_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGeofenceInput`](crate::input::GetGeofenceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetGeofenceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetGeofenceInput {
                collection_name: self.collection_name,
                geofence_id: self.geofence_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGeofenceInputOperationOutputAlias = crate::operation::GetGeofence;
#[doc(hidden)]
pub type GetGeofenceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetGeofenceInput {
    /// Consumes the builder and constructs an Operation<[`GetGeofence`](crate::operation::GetGeofence)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGeofence,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetGeofenceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_26 = &_input.collection_name;
                let input_26 = input_26.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "collection_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let collection_name = aws_smithy_http::label::fmt_string(input_26, false);
                if collection_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "collection_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_27 = &_input.geofence_id;
                let input_27 = input_27.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "geofence_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let geofence_id = aws_smithy_http::label::fmt_string(input_27, false);
                if geofence_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "geofence_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/geofencing/v0/collections/{CollectionName}/geofences/{GeofenceId}",
                    CollectionName = collection_name,
                    GeofenceId = geofence_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetGeofenceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("geofencing.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetGeofence::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetGeofence",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetGeofenceInput`](crate::input::GetGeofenceInput)
    pub fn builder() -> crate::input::get_geofence_input::Builder {
        crate::input::get_geofence_input::Builder::default()
    }
}

/// See [`GetMapGlyphsInput`](crate::input::GetMapGlyphsInput)
pub mod get_map_glyphs_input {
    /// A builder for [`GetMapGlyphsInput`](crate::input::GetMapGlyphsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) map_name: std::option::Option<std::string::String>,
        pub(crate) font_stack: std::option::Option<std::string::String>,
        pub(crate) font_unicode_range: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The map resource associated with the glyph ﬁle.</p>
        pub fn map_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.map_name = Some(input.into());
            self
        }
        /// <p>The map resource associated with the glyph ﬁle.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.map_name = input;
            self
        }
        /// <p>A comma-separated list of fonts to load glyphs from in order of preference. For example, <code>Noto Sans Regular, Arial Unicode</code>.</p>
        /// <p>Valid fonts stacks for <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a> styles: </p>
        /// <ul>
        /// <li> <p>VectorEsriDarkGrayCanvas – <code>Ubuntu Medium Italic</code> | <code>Ubuntu Medium</code> | <code>Ubuntu Italic</code> | <code>Ubuntu Regular</code> | <code>Ubuntu Bold</code> </p> </li>
        /// <li> <p>VectorEsriLightGrayCanvas – <code>Ubuntu Italic</code> | <code>Ubuntu Regular</code> | <code>Ubuntu Light</code> | <code>Ubuntu Bold</code> </p> </li>
        /// <li> <p>VectorEsriTopographic – <code>Noto Sans Italic</code> | <code>Noto Sans Regular</code> | <code>Noto Sans Bold</code> | <code>Noto Serif Regular</code> | <code>Roboto Condensed Light Italic</code> </p> </li>
        /// <li> <p>VectorEsriStreets – <code>Arial Regular</code> | <code>Arial Italic</code> | <code>Arial Bold</code> </p> </li>
        /// <li> <p>VectorEsriNavigation – <code>Arial Regular</code> | <code>Arial Italic</code> | <code>Arial Bold</code> </p> </li>
        /// </ul>
        /// <p>Valid font stacks for <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a> styles: </p>
        /// <ul>
        /// <li> <p>VectorHereBerlin – <code>Fira GO Regular</code> | <code>Fira GO Bold</code> </p> </li>
        /// </ul>
        pub fn font_stack(mut self, input: impl Into<std::string::String>) -> Self {
            self.font_stack = Some(input.into());
            self
        }
        /// <p>A comma-separated list of fonts to load glyphs from in order of preference. For example, <code>Noto Sans Regular, Arial Unicode</code>.</p>
        /// <p>Valid fonts stacks for <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a> styles: </p>
        /// <ul>
        /// <li> <p>VectorEsriDarkGrayCanvas – <code>Ubuntu Medium Italic</code> | <code>Ubuntu Medium</code> | <code>Ubuntu Italic</code> | <code>Ubuntu Regular</code> | <code>Ubuntu Bold</code> </p> </li>
        /// <li> <p>VectorEsriLightGrayCanvas – <code>Ubuntu Italic</code> | <code>Ubuntu Regular</code> | <code>Ubuntu Light</code> | <code>Ubuntu Bold</code> </p> </li>
        /// <li> <p>VectorEsriTopographic – <code>Noto Sans Italic</code> | <code>Noto Sans Regular</code> | <code>Noto Sans Bold</code> | <code>Noto Serif Regular</code> | <code>Roboto Condensed Light Italic</code> </p> </li>
        /// <li> <p>VectorEsriStreets – <code>Arial Regular</code> | <code>Arial Italic</code> | <code>Arial Bold</code> </p> </li>
        /// <li> <p>VectorEsriNavigation – <code>Arial Regular</code> | <code>Arial Italic</code> | <code>Arial Bold</code> </p> </li>
        /// </ul>
        /// <p>Valid font stacks for <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a> styles: </p>
        /// <ul>
        /// <li> <p>VectorHereBerlin – <code>Fira GO Regular</code> | <code>Fira GO Bold</code> </p> </li>
        /// </ul>
        pub fn set_font_stack(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.font_stack = input;
            self
        }
        /// <p>A Unicode range of characters to download glyphs for. Each response will contain 256 characters. For example, 0–255 includes all characters from range <code>U+0000</code> to <code>00FF</code>. Must be aligned to multiples of 256.</p>
        pub fn font_unicode_range(mut self, input: impl Into<std::string::String>) -> Self {
            self.font_unicode_range = Some(input.into());
            self
        }
        /// <p>A Unicode range of characters to download glyphs for. Each response will contain 256 characters. For example, 0–255 includes all characters from range <code>U+0000</code> to <code>00FF</code>. Must be aligned to multiples of 256.</p>
        pub fn set_font_unicode_range(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.font_unicode_range = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMapGlyphsInput`](crate::input::GetMapGlyphsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMapGlyphsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMapGlyphsInput {
                map_name: self.map_name,
                font_stack: self.font_stack,
                font_unicode_range: self.font_unicode_range,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMapGlyphsInputOperationOutputAlias = crate::operation::GetMapGlyphs;
#[doc(hidden)]
pub type GetMapGlyphsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMapGlyphsInput {
    /// Consumes the builder and constructs an Operation<[`GetMapGlyphs`](crate::operation::GetMapGlyphs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMapGlyphs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetMapGlyphsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_28 = &_input.map_name;
                let input_28 = input_28.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "map_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let map_name = aws_smithy_http::label::fmt_string(input_28, false);
                if map_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "map_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_29 = &_input.font_stack;
                let input_29 = input_29.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "font_stack",
                        details: "cannot be empty or unset",
                    },
                )?;
                let font_stack = aws_smithy_http::label::fmt_string(input_29, false);
                if font_stack.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "font_stack",
                        details: "cannot be empty or unset",
                    });
                }
                let input_30 = &_input.font_unicode_range;
                let input_30 = input_30.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "font_unicode_range",
                        details: "cannot be empty or unset",
                    },
                )?;
                let font_unicode_range = aws_smithy_http::label::fmt_string(input_30, false);
                if font_unicode_range.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "font_unicode_range",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/maps/v0/maps/{MapName}/glyphs/{FontStack}/{FontUnicodeRange}",
                    MapName = map_name,
                    FontStack = font_stack,
                    FontUnicodeRange = font_unicode_range
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetMapGlyphsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("maps.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMapGlyphs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMapGlyphs",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetMapGlyphsInput`](crate::input::GetMapGlyphsInput)
    pub fn builder() -> crate::input::get_map_glyphs_input::Builder {
        crate::input::get_map_glyphs_input::Builder::default()
    }
}

/// See [`GetMapSpritesInput`](crate::input::GetMapSpritesInput)
pub mod get_map_sprites_input {
    /// A builder for [`GetMapSpritesInput`](crate::input::GetMapSpritesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) map_name: std::option::Option<std::string::String>,
        pub(crate) file_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The map resource associated with the sprite ﬁle.</p>
        pub fn map_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.map_name = Some(input.into());
            self
        }
        /// <p>The map resource associated with the sprite ﬁle.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.map_name = input;
            self
        }
        /// <p>The name of the sprite ﬁle. Use the following ﬁle names for the sprite sheet:</p>
        /// <ul>
        /// <li> <p> <code>sprites.png</code> </p> </li>
        /// <li> <p> <code>sprites@2x.png</code> for high pixel density displays</p> </li>
        /// </ul>
        /// <p>For the JSON document contain image offsets. Use the following ﬁle names:</p>
        /// <ul>
        /// <li> <p> <code>sprites.json</code> </p> </li>
        /// <li> <p> <code>sprites@2x.json</code> for high pixel density displays</p> </li>
        /// </ul>
        pub fn file_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.file_name = Some(input.into());
            self
        }
        /// <p>The name of the sprite ﬁle. Use the following ﬁle names for the sprite sheet:</p>
        /// <ul>
        /// <li> <p> <code>sprites.png</code> </p> </li>
        /// <li> <p> <code>sprites@2x.png</code> for high pixel density displays</p> </li>
        /// </ul>
        /// <p>For the JSON document contain image offsets. Use the following ﬁle names:</p>
        /// <ul>
        /// <li> <p> <code>sprites.json</code> </p> </li>
        /// <li> <p> <code>sprites@2x.json</code> for high pixel density displays</p> </li>
        /// </ul>
        pub fn set_file_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.file_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMapSpritesInput`](crate::input::GetMapSpritesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMapSpritesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMapSpritesInput {
                map_name: self.map_name,
                file_name: self.file_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMapSpritesInputOperationOutputAlias = crate::operation::GetMapSprites;
#[doc(hidden)]
pub type GetMapSpritesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMapSpritesInput {
    /// Consumes the builder and constructs an Operation<[`GetMapSprites`](crate::operation::GetMapSprites)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMapSprites,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetMapSpritesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_31 = &_input.map_name;
                let input_31 = input_31.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "map_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let map_name = aws_smithy_http::label::fmt_string(input_31, false);
                if map_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "map_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_32 = &_input.file_name;
                let input_32 = input_32.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "file_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let file_name = aws_smithy_http::label::fmt_string(input_32, false);
                if file_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "file_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/maps/v0/maps/{MapName}/sprites/{FileName}",
                    MapName = map_name,
                    FileName = file_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetMapSpritesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("maps.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMapSprites::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMapSprites",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetMapSpritesInput`](crate::input::GetMapSpritesInput)
    pub fn builder() -> crate::input::get_map_sprites_input::Builder {
        crate::input::get_map_sprites_input::Builder::default()
    }
}

/// See [`GetMapStyleDescriptorInput`](crate::input::GetMapStyleDescriptorInput)
pub mod get_map_style_descriptor_input {
    /// A builder for [`GetMapStyleDescriptorInput`](crate::input::GetMapStyleDescriptorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) map_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The map resource to retrieve the style descriptor from.</p>
        pub fn map_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.map_name = Some(input.into());
            self
        }
        /// <p>The map resource to retrieve the style descriptor from.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.map_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMapStyleDescriptorInput`](crate::input::GetMapStyleDescriptorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMapStyleDescriptorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMapStyleDescriptorInput {
                map_name: self.map_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMapStyleDescriptorInputOperationOutputAlias = crate::operation::GetMapStyleDescriptor;
#[doc(hidden)]
pub type GetMapStyleDescriptorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMapStyleDescriptorInput {
    /// Consumes the builder and constructs an Operation<[`GetMapStyleDescriptor`](crate::operation::GetMapStyleDescriptor)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMapStyleDescriptor,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetMapStyleDescriptorInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_33 = &_input.map_name;
                let input_33 = input_33.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "map_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let map_name = aws_smithy_http::label::fmt_string(input_33, false);
                if map_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "map_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/maps/v0/maps/{MapName}/style-descriptor",
                    MapName = map_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetMapStyleDescriptorInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("maps.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMapStyleDescriptor::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMapStyleDescriptor",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetMapStyleDescriptorInput`](crate::input::GetMapStyleDescriptorInput)
    pub fn builder() -> crate::input::get_map_style_descriptor_input::Builder {
        crate::input::get_map_style_descriptor_input::Builder::default()
    }
}

/// See [`GetMapTileInput`](crate::input::GetMapTileInput)
pub mod get_map_tile_input {
    /// A builder for [`GetMapTileInput`](crate::input::GetMapTileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) map_name: std::option::Option<std::string::String>,
        pub(crate) z: std::option::Option<std::string::String>,
        pub(crate) x: std::option::Option<std::string::String>,
        pub(crate) y: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The map resource to retrieve the map tiles from.</p>
        pub fn map_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.map_name = Some(input.into());
            self
        }
        /// <p>The map resource to retrieve the map tiles from.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.map_name = input;
            self
        }
        /// <p>The zoom value for the map tile.</p>
        pub fn z(mut self, input: impl Into<std::string::String>) -> Self {
            self.z = Some(input.into());
            self
        }
        /// <p>The zoom value for the map tile.</p>
        pub fn set_z(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.z = input;
            self
        }
        /// <p>The X axis value for the map tile.</p>
        pub fn x(mut self, input: impl Into<std::string::String>) -> Self {
            self.x = Some(input.into());
            self
        }
        /// <p>The X axis value for the map tile.</p>
        pub fn set_x(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.x = input;
            self
        }
        /// <p>The Y axis value for the map tile. </p>
        pub fn y(mut self, input: impl Into<std::string::String>) -> Self {
            self.y = Some(input.into());
            self
        }
        /// <p>The Y axis value for the map tile. </p>
        pub fn set_y(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.y = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMapTileInput`](crate::input::GetMapTileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMapTileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMapTileInput {
                map_name: self.map_name,
                z: self.z,
                x: self.x,
                y: self.y,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMapTileInputOperationOutputAlias = crate::operation::GetMapTile;
#[doc(hidden)]
pub type GetMapTileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMapTileInput {
    /// Consumes the builder and constructs an Operation<[`GetMapTile`](crate::operation::GetMapTile)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMapTile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetMapTileInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_34 = &_input.map_name;
                let input_34 = input_34.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "map_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let map_name = aws_smithy_http::label::fmt_string(input_34, false);
                if map_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "map_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_35 = &_input.z;
                let input_35 = input_35.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "z",
                        details: "cannot be empty or unset",
                    },
                )?;
                let z = aws_smithy_http::label::fmt_string(input_35, false);
                if z.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "z",
                        details: "cannot be empty or unset",
                    });
                }
                let input_36 = &_input.x;
                let input_36 = input_36.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "x",
                        details: "cannot be empty or unset",
                    },
                )?;
                let x = aws_smithy_http::label::fmt_string(input_36, false);
                if x.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "x",
                        details: "cannot be empty or unset",
                    });
                }
                let input_37 = &_input.y;
                let input_37 = input_37.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "y",
                        details: "cannot be empty or unset",
                    },
                )?;
                let y = aws_smithy_http::label::fmt_string(input_37, false);
                if y.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "y",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/maps/v0/maps/{MapName}/tiles/{Z}/{X}/{Y}",
                    MapName = map_name,
                    Z = z,
                    X = x,
                    Y = y
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetMapTileInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("maps.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMapTile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMapTile",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetMapTileInput`](crate::input::GetMapTileInput)
    pub fn builder() -> crate::input::get_map_tile_input::Builder {
        crate::input::get_map_tile_input::Builder::default()
    }
}

/// See [`ListDevicePositionsInput`](crate::input::ListDevicePositionsInput)
pub mod list_device_positions_input {
    /// A builder for [`ListDevicePositionsInput`](crate::input::ListDevicePositionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tracker_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The tracker resource containing the requested devices.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracker_name = Some(input.into());
            self
        }
        /// <p>The tracker resource containing the requested devices.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tracker_name = input;
            self
        }
        /// <p>An optional limit for the number of entries returned in a single call.</p>
        /// <p>Default value: <code>100</code> </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>An optional limit for the number of entries returned in a single call.</p>
        /// <p>Default value: <code>100</code> </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
        /// <p>Default value: <code>null</code> </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
        /// <p>Default value: <code>null</code> </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDevicePositionsInput`](crate::input::ListDevicePositionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDevicePositionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDevicePositionsInput {
                tracker_name: self.tracker_name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDevicePositionsInputOperationOutputAlias = crate::operation::ListDevicePositions;
#[doc(hidden)]
pub type ListDevicePositionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDevicePositionsInput {
    /// Consumes the builder and constructs an Operation<[`ListDevicePositions`](crate::operation::ListDevicePositions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDevicePositions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDevicePositionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_38 = &_input.tracker_name;
                let input_38 = input_38.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let tracker_name = aws_smithy_http::label::fmt_string(input_38, false);
                if tracker_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/tracking/v0/trackers/{TrackerName}/list-positions",
                    TrackerName = tracker_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDevicePositionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_device_positions(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("tracking.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDevicePositions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDevicePositions",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDevicePositionsInput`](crate::input::ListDevicePositionsInput)
    pub fn builder() -> crate::input::list_device_positions_input::Builder {
        crate::input::list_device_positions_input::Builder::default()
    }
}

/// See [`ListGeofenceCollectionsInput`](crate::input::ListGeofenceCollectionsInput)
pub mod list_geofence_collections_input {
    /// A builder for [`ListGeofenceCollectionsInput`](crate::input::ListGeofenceCollectionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code> </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code> </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code> </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code> </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGeofenceCollectionsInput`](crate::input::ListGeofenceCollectionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGeofenceCollectionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGeofenceCollectionsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGeofenceCollectionsInputOperationOutputAlias =
    crate::operation::ListGeofenceCollections;
#[doc(hidden)]
pub type ListGeofenceCollectionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListGeofenceCollectionsInput {
    /// Consumes the builder and constructs an Operation<[`ListGeofenceCollections`](crate::operation::ListGeofenceCollections)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGeofenceCollections,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListGeofenceCollectionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/geofencing/v0/list-collections")
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListGeofenceCollectionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_geofence_collections(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("geofencing.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGeofenceCollections::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGeofenceCollections",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListGeofenceCollectionsInput`](crate::input::ListGeofenceCollectionsInput)
    pub fn builder() -> crate::input::list_geofence_collections_input::Builder {
        crate::input::list_geofence_collections_input::Builder::default()
    }
}

/// See [`ListGeofencesInput`](crate::input::ListGeofencesInput)
pub mod list_geofences_input {
    /// A builder for [`ListGeofencesInput`](crate::input::ListGeofencesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) collection_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the geofence collection storing the list of geofences.</p>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.collection_name = Some(input.into());
            self
        }
        /// <p>The name of the geofence collection storing the list of geofences.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.collection_name = input;
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code> </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code> </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGeofencesInput`](crate::input::ListGeofencesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListGeofencesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListGeofencesInput {
                collection_name: self.collection_name,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListGeofencesInputOperationOutputAlias = crate::operation::ListGeofences;
#[doc(hidden)]
pub type ListGeofencesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListGeofencesInput {
    /// Consumes the builder and constructs an Operation<[`ListGeofences`](crate::operation::ListGeofences)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListGeofences,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListGeofencesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_39 = &_input.collection_name;
                let input_39 = input_39.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "collection_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let collection_name = aws_smithy_http::label::fmt_string(input_39, false);
                if collection_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "collection_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/geofencing/v0/collections/{CollectionName}/list-geofences",
                    CollectionName = collection_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListGeofencesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_geofences(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("geofencing.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListGeofences::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListGeofences",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListGeofencesInput`](crate::input::ListGeofencesInput)
    pub fn builder() -> crate::input::list_geofences_input::Builder {
        crate::input::list_geofences_input::Builder::default()
    }
}

/// See [`ListMapsInput`](crate::input::ListMapsInput)
pub mod list_maps_input {
    /// A builder for [`ListMapsInput`](crate::input::ListMapsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code> </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code> </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
        /// <p>Default value: <code>null</code> </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
        /// <p>Default value: <code>null</code> </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMapsInput`](crate::input::ListMapsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListMapsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListMapsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListMapsInputOperationOutputAlias = crate::operation::ListMaps;
#[doc(hidden)]
pub type ListMapsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListMapsInput {
    /// Consumes the builder and constructs an Operation<[`ListMaps`](crate::operation::ListMaps)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMaps,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListMapsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/maps/v0/list-maps").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListMapsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_maps(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("maps.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListMaps::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListMaps", "location",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListMapsInput`](crate::input::ListMapsInput)
    pub fn builder() -> crate::input::list_maps_input::Builder {
        crate::input::list_maps_input::Builder::default()
    }
}

/// See [`ListPlaceIndexesInput`](crate::input::ListPlaceIndexesInput)
pub mod list_place_indexes_input {
    /// A builder for [`ListPlaceIndexesInput`](crate::input::ListPlaceIndexesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An optional limit for the maximum number of results returned in a single call.</p>
        /// <p>Default value: <code>100</code> </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>An optional limit for the maximum number of results returned in a single call.</p>
        /// <p>Default value: <code>100</code> </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
        /// <p>Default value: <code>null</code> </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
        /// <p>Default value: <code>null</code> </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPlaceIndexesInput`](crate::input::ListPlaceIndexesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPlaceIndexesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPlaceIndexesInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPlaceIndexesInputOperationOutputAlias = crate::operation::ListPlaceIndexes;
#[doc(hidden)]
pub type ListPlaceIndexesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPlaceIndexesInput {
    /// Consumes the builder and constructs an Operation<[`ListPlaceIndexes`](crate::operation::ListPlaceIndexes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPlaceIndexes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListPlaceIndexesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/places/v0/list-indexes").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListPlaceIndexesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_place_indexes(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("places.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPlaceIndexes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPlaceIndexes",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListPlaceIndexesInput`](crate::input::ListPlaceIndexesInput)
    pub fn builder() -> crate::input::list_place_indexes_input::Builder {
        crate::input::list_place_indexes_input::Builder::default()
    }
}

/// See [`ListRouteCalculatorsInput`](crate::input::ListRouteCalculatorsInput)
pub mod list_route_calculators_input {
    /// A builder for [`ListRouteCalculatorsInput`](crate::input::ListRouteCalculatorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An optional maximum number of results returned in a single call.</p>
        /// <p>Default Value: <code>100</code> </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>An optional maximum number of results returned in a single call.</p>
        /// <p>Default Value: <code>100</code> </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
        /// <p>Default Value: <code>null</code> </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
        /// <p>Default Value: <code>null</code> </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRouteCalculatorsInput`](crate::input::ListRouteCalculatorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRouteCalculatorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRouteCalculatorsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRouteCalculatorsInputOperationOutputAlias = crate::operation::ListRouteCalculators;
#[doc(hidden)]
pub type ListRouteCalculatorsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListRouteCalculatorsInput {
    /// Consumes the builder and constructs an Operation<[`ListRouteCalculators`](crate::operation::ListRouteCalculators)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRouteCalculators,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListRouteCalculatorsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/routes/v0/list-calculators").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListRouteCalculatorsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_route_calculators(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("routes.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRouteCalculators::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRouteCalculators",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListRouteCalculatorsInput`](crate::input::ListRouteCalculatorsInput)
    pub fn builder() -> crate::input::list_route_calculators_input::Builder {
        crate::input::list_route_calculators_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li>
        /// </ul>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li>
        /// </ul>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_40 = &_input.resource_arn;
                let input_40 = input_40.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_40, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("metadata.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListTrackerConsumersInput`](crate::input::ListTrackerConsumersInput)
pub mod list_tracker_consumers_input {
    /// A builder for [`ListTrackerConsumersInput`](crate::input::ListTrackerConsumersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tracker_name: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The tracker resource whose associated geofence collections you want to list.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracker_name = Some(input.into());
            self
        }
        /// <p>The tracker resource whose associated geofence collections you want to list.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tracker_name = input;
            self
        }
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code> </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code> </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code> </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code> </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrackerConsumersInput`](crate::input::ListTrackerConsumersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTrackerConsumersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTrackerConsumersInput {
                tracker_name: self.tracker_name,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTrackerConsumersInputOperationOutputAlias = crate::operation::ListTrackerConsumers;
#[doc(hidden)]
pub type ListTrackerConsumersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTrackerConsumersInput {
    /// Consumes the builder and constructs an Operation<[`ListTrackerConsumers`](crate::operation::ListTrackerConsumers)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTrackerConsumers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTrackerConsumersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_41 = &_input.tracker_name;
                let input_41 = input_41.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let tracker_name = aws_smithy_http::label::fmt_string(input_41, false);
                if tracker_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/tracking/v0/trackers/{TrackerName}/list-consumers",
                    TrackerName = tracker_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTrackerConsumersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_tracker_consumers(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("tracking.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTrackerConsumers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTrackerConsumers",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTrackerConsumersInput`](crate::input::ListTrackerConsumersInput)
    pub fn builder() -> crate::input::list_tracker_consumers_input::Builder {
        crate::input::list_tracker_consumers_input::Builder::default()
    }
}

/// See [`ListTrackersInput`](crate::input::ListTrackersInput)
pub mod list_trackers_input {
    /// A builder for [`ListTrackersInput`](crate::input::ListTrackersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code> </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code> </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code> </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code> </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrackersInput`](crate::input::ListTrackersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTrackersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTrackersInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTrackersInputOperationOutputAlias = crate::operation::ListTrackers;
#[doc(hidden)]
pub type ListTrackersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTrackersInput {
    /// Consumes the builder and constructs an Operation<[`ListTrackers`](crate::operation::ListTrackers)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTrackers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTrackersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/tracking/v0/list-trackers").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTrackersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_trackers(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("tracking.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTrackers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTrackers",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTrackersInput`](crate::input::ListTrackersInput)
    pub fn builder() -> crate::input::list_trackers_input::Builder {
        crate::input::list_trackers_input::Builder::default()
    }
}

/// See [`PutGeofenceInput`](crate::input::PutGeofenceInput)
pub mod put_geofence_input {
    /// A builder for [`PutGeofenceInput`](crate::input::PutGeofenceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) collection_name: std::option::Option<std::string::String>,
        pub(crate) geofence_id: std::option::Option<std::string::String>,
        pub(crate) geometry: std::option::Option<crate::model::GeofenceGeometry>,
    }
    impl Builder {
        /// <p>The geofence collection to store the geofence in.</p>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.collection_name = Some(input.into());
            self
        }
        /// <p>The geofence collection to store the geofence in.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.collection_name = input;
            self
        }
        /// <p>An identifier for the geofence. For example, <code>ExampleGeofence-1</code>.</p>
        pub fn geofence_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.geofence_id = Some(input.into());
            self
        }
        /// <p>An identifier for the geofence. For example, <code>ExampleGeofence-1</code>.</p>
        pub fn set_geofence_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.geofence_id = input;
            self
        }
        /// <p>Contains the polygon details to specify the position of the geofence.</p> <note>
        /// <p>Each <a href="https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html">geofence polygon</a> can have a maximum of 1,000 vertices.</p>
        /// </note>
        pub fn geometry(mut self, input: crate::model::GeofenceGeometry) -> Self {
            self.geometry = Some(input);
            self
        }
        /// <p>Contains the polygon details to specify the position of the geofence.</p> <note>
        /// <p>Each <a href="https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html">geofence polygon</a> can have a maximum of 1,000 vertices.</p>
        /// </note>
        pub fn set_geometry(
            mut self,
            input: std::option::Option<crate::model::GeofenceGeometry>,
        ) -> Self {
            self.geometry = input;
            self
        }
        /// Consumes the builder and constructs a [`PutGeofenceInput`](crate::input::PutGeofenceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutGeofenceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutGeofenceInput {
                collection_name: self.collection_name,
                geofence_id: self.geofence_id,
                geometry: self.geometry,
            })
        }
    }
}
#[doc(hidden)]
pub type PutGeofenceInputOperationOutputAlias = crate::operation::PutGeofence;
#[doc(hidden)]
pub type PutGeofenceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutGeofenceInput {
    /// Consumes the builder and constructs an Operation<[`PutGeofence`](crate::operation::PutGeofence)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutGeofence,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutGeofenceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_42 = &_input.collection_name;
                let input_42 = input_42.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "collection_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let collection_name = aws_smithy_http::label::fmt_string(input_42, false);
                if collection_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "collection_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_43 = &_input.geofence_id;
                let input_43 = input_43.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "geofence_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let geofence_id = aws_smithy_http::label::fmt_string(input_43, false);
                if geofence_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "geofence_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/geofencing/v0/collections/{CollectionName}/geofences/{GeofenceId}",
                    CollectionName = collection_name,
                    GeofenceId = geofence_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutGeofenceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_geofence(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("geofencing.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutGeofence::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutGeofence",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutGeofenceInput`](crate::input::PutGeofenceInput)
    pub fn builder() -> crate::input::put_geofence_input::Builder {
        crate::input::put_geofence_input::Builder::default()
    }
}

/// See [`SearchPlaceIndexForPositionInput`](crate::input::SearchPlaceIndexForPositionInput)
pub mod search_place_index_for_position_input {
    /// A builder for [`SearchPlaceIndexForPositionInput`](crate::input::SearchPlaceIndexForPositionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) position: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) language: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the place index resource you want to use for the search.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the place index resource you want to use for the search.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// Appends an item to `position`.
        ///
        /// To override the contents of this collection use [`set_position`](Self::set_position).
        ///
        /// <p>Specifies the longitude and latitude of the position to query.</p>
        /// <p> This parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
        /// <p>For example, <code>[-123.1174, 49.2847]</code> represents a position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p>
        pub fn position(mut self, input: f64) -> Self {
            let mut v = self.position.unwrap_or_default();
            v.push(input);
            self.position = Some(v);
            self
        }
        /// <p>Specifies the longitude and latitude of the position to query.</p>
        /// <p> This parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
        /// <p>For example, <code>[-123.1174, 49.2847]</code> represents a position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p>
        pub fn set_position(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.position = input;
            self
        }
        /// <p>An optional parameter. The maximum number of results returned per request.</p>
        /// <p>Default value: <code>50</code> </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>An optional parameter. The maximum number of results returned per request.</p>
        /// <p>Default value: <code>50</code> </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
        /// <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.language = Some(input.into());
            self
        }
        /// <p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
        /// <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.language = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchPlaceIndexForPositionInput`](crate::input::SearchPlaceIndexForPositionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchPlaceIndexForPositionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchPlaceIndexForPositionInput {
                index_name: self.index_name,
                position: self.position,
                max_results: self.max_results.unwrap_or_default(),
                language: self.language,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchPlaceIndexForPositionInputOperationOutputAlias =
    crate::operation::SearchPlaceIndexForPosition;
#[doc(hidden)]
pub type SearchPlaceIndexForPositionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SearchPlaceIndexForPositionInput {
    /// Consumes the builder and constructs an Operation<[`SearchPlaceIndexForPosition`](crate::operation::SearchPlaceIndexForPosition)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchPlaceIndexForPosition,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SearchPlaceIndexForPositionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_44 = &_input.index_name;
                let input_44 = input_44.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "index_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let index_name = aws_smithy_http::label::fmt_string(input_44, false);
                if index_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "index_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/places/v0/indexes/{IndexName}/search/position",
                    IndexName = index_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SearchPlaceIndexForPositionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_search_place_index_for_position(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("places.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchPlaceIndexForPosition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchPlaceIndexForPosition",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SearchPlaceIndexForPositionInput`](crate::input::SearchPlaceIndexForPositionInput)
    pub fn builder() -> crate::input::search_place_index_for_position_input::Builder {
        crate::input::search_place_index_for_position_input::Builder::default()
    }
}

/// See [`SearchPlaceIndexForSuggestionsInput`](crate::input::SearchPlaceIndexForSuggestionsInput)
pub mod search_place_index_for_suggestions_input {
    /// A builder for [`SearchPlaceIndexForSuggestionsInput`](crate::input::SearchPlaceIndexForSuggestionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) bias_position: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) filter_b_box: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) filter_countries: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) language: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the place index resource you want to use for the search.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the place index resource you want to use for the search.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>The free-form partial text to use to generate place suggestions. For example, <code>eiffel tow</code>.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The free-form partial text to use to generate place suggestions. For example, <code>eiffel tow</code>.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// Appends an item to `bias_position`.
        ///
        /// To override the contents of this collection use [`set_bias_position`](Self::set_bias_position).
        ///
        /// <p>An optional parameter that indicates a preference for place suggestions that are closer to a specified position.</p>
        /// <p> If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
        /// <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p> <note>
        /// <p> <code>BiasPosition</code> and <code>FilterBBox</code> are mutually exclusive. Specifying both options results in an error. </p>
        /// </note>
        pub fn bias_position(mut self, input: f64) -> Self {
            let mut v = self.bias_position.unwrap_or_default();
            v.push(input);
            self.bias_position = Some(v);
            self
        }
        /// <p>An optional parameter that indicates a preference for place suggestions that are closer to a specified position.</p>
        /// <p> If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
        /// <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p> <note>
        /// <p> <code>BiasPosition</code> and <code>FilterBBox</code> are mutually exclusive. Specifying both options results in an error. </p>
        /// </note>
        pub fn set_bias_position(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.bias_position = input;
            self
        }
        /// Appends an item to `filter_b_box`.
        ///
        /// To override the contents of this collection use [`set_filter_b_box`](Self::set_filter_b_box).
        ///
        /// <p>An optional parameter that limits the search results by returning only suggestions within a specified bounding box.</p>
        /// <p> If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest corner of the bounding box; the second pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the northeast corner of the bounding box.</p>
        /// <p>For example, <code>[-12.7935, -37.4835, -12.0684, -36.9542]</code> represents a bounding box where the southwest corner has longitude <code>-12.7935</code> and latitude <code>-37.4835</code>, and the northeast corner has longitude <code>-12.0684</code> and latitude <code>-36.9542</code>.</p> <note>
        /// <p> <code>FilterBBox</code> and <code>BiasPosition</code> are mutually exclusive. Specifying both options results in an error. </p>
        /// </note>
        pub fn filter_b_box(mut self, input: f64) -> Self {
            let mut v = self.filter_b_box.unwrap_or_default();
            v.push(input);
            self.filter_b_box = Some(v);
            self
        }
        /// <p>An optional parameter that limits the search results by returning only suggestions within a specified bounding box.</p>
        /// <p> If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest corner of the bounding box; the second pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the northeast corner of the bounding box.</p>
        /// <p>For example, <code>[-12.7935, -37.4835, -12.0684, -36.9542]</code> represents a bounding box where the southwest corner has longitude <code>-12.7935</code> and latitude <code>-37.4835</code>, and the northeast corner has longitude <code>-12.0684</code> and latitude <code>-36.9542</code>.</p> <note>
        /// <p> <code>FilterBBox</code> and <code>BiasPosition</code> are mutually exclusive. Specifying both options results in an error. </p>
        /// </note>
        pub fn set_filter_b_box(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.filter_b_box = input;
            self
        }
        /// Appends an item to `filter_countries`.
        ///
        /// To override the contents of this collection use [`set_filter_countries`](Self::set_filter_countries).
        ///
        /// <p>An optional parameter that limits the search results by returning only suggestions within the provided list of countries.</p>
        /// <ul>
        /// <li> <p>Use the <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country code. For example, Australia uses three upper-case characters: <code>AUS</code>.</p> </li>
        /// </ul>
        pub fn filter_countries(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.filter_countries.unwrap_or_default();
            v.push(input.into());
            self.filter_countries = Some(v);
            self
        }
        /// <p>An optional parameter that limits the search results by returning only suggestions within the provided list of countries.</p>
        /// <ul>
        /// <li> <p>Use the <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country code. For example, Australia uses three upper-case characters: <code>AUS</code>.</p> </li>
        /// </ul>
        pub fn set_filter_countries(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.filter_countries = input;
            self
        }
        /// <p>An optional parameter. The maximum number of results returned per request. </p>
        /// <p>The default: <code>5</code> </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>An optional parameter. The maximum number of results returned per request. </p>
        /// <p>The default: <code>5</code> </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
        /// <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p>
        /// <p>Used only when the partner selected is Here.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.language = Some(input.into());
            self
        }
        /// <p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
        /// <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p>
        /// <p>Used only when the partner selected is Here.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.language = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchPlaceIndexForSuggestionsInput`](crate::input::SearchPlaceIndexForSuggestionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchPlaceIndexForSuggestionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchPlaceIndexForSuggestionsInput {
                index_name: self.index_name,
                text: self.text,
                bias_position: self.bias_position,
                filter_b_box: self.filter_b_box,
                filter_countries: self.filter_countries,
                max_results: self.max_results,
                language: self.language,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchPlaceIndexForSuggestionsInputOperationOutputAlias =
    crate::operation::SearchPlaceIndexForSuggestions;
#[doc(hidden)]
pub type SearchPlaceIndexForSuggestionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl SearchPlaceIndexForSuggestionsInput {
    /// Consumes the builder and constructs an Operation<[`SearchPlaceIndexForSuggestions`](crate::operation::SearchPlaceIndexForSuggestions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchPlaceIndexForSuggestions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SearchPlaceIndexForSuggestionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_45 = &_input.index_name;
                let input_45 = input_45.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "index_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let index_name = aws_smithy_http::label::fmt_string(input_45, false);
                if index_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "index_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/places/v0/indexes/{IndexName}/search/suggestions",
                    IndexName = index_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SearchPlaceIndexForSuggestionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_search_place_index_for_suggestions(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("places.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchPlaceIndexForSuggestions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchPlaceIndexForSuggestions",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SearchPlaceIndexForSuggestionsInput`](crate::input::SearchPlaceIndexForSuggestionsInput)
    pub fn builder() -> crate::input::search_place_index_for_suggestions_input::Builder {
        crate::input::search_place_index_for_suggestions_input::Builder::default()
    }
}

/// See [`SearchPlaceIndexForTextInput`](crate::input::SearchPlaceIndexForTextInput)
pub mod search_place_index_for_text_input {
    /// A builder for [`SearchPlaceIndexForTextInput`](crate::input::SearchPlaceIndexForTextInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) bias_position: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) filter_b_box: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) filter_countries: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) language: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the place index resource you want to use for the search.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the place index resource you want to use for the search.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>The address, name, city, or region to be used in the search in free-form text format. For example, <code>123 Any Street</code>.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The address, name, city, or region to be used in the search in free-form text format. For example, <code>123 Any Street</code>.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// Appends an item to `bias_position`.
        ///
        /// To override the contents of this collection use [`set_bias_position`](Self::set_bias_position).
        ///
        /// <p>An optional parameter that indicates a preference for places that are closer to a specified position.</p>
        /// <p> If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
        /// <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p> <note>
        /// <p> <code>BiasPosition</code> and <code>FilterBBox</code> are mutually exclusive. Specifying both options results in an error. </p>
        /// </note>
        pub fn bias_position(mut self, input: f64) -> Self {
            let mut v = self.bias_position.unwrap_or_default();
            v.push(input);
            self.bias_position = Some(v);
            self
        }
        /// <p>An optional parameter that indicates a preference for places that are closer to a specified position.</p>
        /// <p> If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
        /// <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p> <note>
        /// <p> <code>BiasPosition</code> and <code>FilterBBox</code> are mutually exclusive. Specifying both options results in an error. </p>
        /// </note>
        pub fn set_bias_position(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.bias_position = input;
            self
        }
        /// Appends an item to `filter_b_box`.
        ///
        /// To override the contents of this collection use [`set_filter_b_box`](Self::set_filter_b_box).
        ///
        /// <p>An optional parameter that limits the search results by returning only places that are within the provided bounding box.</p>
        /// <p> If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest corner of the bounding box; the second pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the northeast corner of the bounding box.</p>
        /// <p>For example, <code>[-12.7935, -37.4835, -12.0684, -36.9542]</code> represents a bounding box where the southwest corner has longitude <code>-12.7935</code> and latitude <code>-37.4835</code>, and the northeast corner has longitude <code>-12.0684</code> and latitude <code>-36.9542</code>.</p> <note>
        /// <p> <code>FilterBBox</code> and <code>BiasPosition</code> are mutually exclusive. Specifying both options results in an error. </p>
        /// </note>
        pub fn filter_b_box(mut self, input: f64) -> Self {
            let mut v = self.filter_b_box.unwrap_or_default();
            v.push(input);
            self.filter_b_box = Some(v);
            self
        }
        /// <p>An optional parameter that limits the search results by returning only places that are within the provided bounding box.</p>
        /// <p> If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest corner of the bounding box; the second pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the northeast corner of the bounding box.</p>
        /// <p>For example, <code>[-12.7935, -37.4835, -12.0684, -36.9542]</code> represents a bounding box where the southwest corner has longitude <code>-12.7935</code> and latitude <code>-37.4835</code>, and the northeast corner has longitude <code>-12.0684</code> and latitude <code>-36.9542</code>.</p> <note>
        /// <p> <code>FilterBBox</code> and <code>BiasPosition</code> are mutually exclusive. Specifying both options results in an error. </p>
        /// </note>
        pub fn set_filter_b_box(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.filter_b_box = input;
            self
        }
        /// Appends an item to `filter_countries`.
        ///
        /// To override the contents of this collection use [`set_filter_countries`](Self::set_filter_countries).
        ///
        /// <p>An optional parameter that limits the search results by returning only places that are in a specified list of countries.</p>
        /// <ul>
        /// <li> <p>Valid values include <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country codes. For example, Australia uses three upper-case characters: <code>AUS</code>.</p> </li>
        /// </ul>
        pub fn filter_countries(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.filter_countries.unwrap_or_default();
            v.push(input.into());
            self.filter_countries = Some(v);
            self
        }
        /// <p>An optional parameter that limits the search results by returning only places that are in a specified list of countries.</p>
        /// <ul>
        /// <li> <p>Valid values include <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country codes. For example, Australia uses three upper-case characters: <code>AUS</code>.</p> </li>
        /// </ul>
        pub fn set_filter_countries(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.filter_countries = input;
            self
        }
        /// <p>An optional parameter. The maximum number of results returned per request. </p>
        /// <p>The default: <code>50</code> </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>An optional parameter. The maximum number of results returned per request. </p>
        /// <p>The default: <code>50</code> </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
        /// <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.language = Some(input.into());
            self
        }
        /// <p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
        /// <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.language = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchPlaceIndexForTextInput`](crate::input::SearchPlaceIndexForTextInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchPlaceIndexForTextInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchPlaceIndexForTextInput {
                index_name: self.index_name,
                text: self.text,
                bias_position: self.bias_position,
                filter_b_box: self.filter_b_box,
                filter_countries: self.filter_countries,
                max_results: self.max_results.unwrap_or_default(),
                language: self.language,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchPlaceIndexForTextInputOperationOutputAlias =
    crate::operation::SearchPlaceIndexForText;
#[doc(hidden)]
pub type SearchPlaceIndexForTextInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SearchPlaceIndexForTextInput {
    /// Consumes the builder and constructs an Operation<[`SearchPlaceIndexForText`](crate::operation::SearchPlaceIndexForText)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchPlaceIndexForText,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SearchPlaceIndexForTextInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_46 = &_input.index_name;
                let input_46 = input_46.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "index_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let index_name = aws_smithy_http::label::fmt_string(input_46, false);
                if index_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "index_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/places/v0/indexes/{IndexName}/search/text",
                    IndexName = index_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SearchPlaceIndexForTextInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_search_place_index_for_text(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("places.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchPlaceIndexForText::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchPlaceIndexForText",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SearchPlaceIndexForTextInput`](crate::input::SearchPlaceIndexForTextInput)
    pub fn builder() -> crate::input::search_place_index_for_text_input::Builder {
        crate::input::search_place_index_for_text_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to update.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li>
        /// </ul>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to update.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li>
        /// </ul>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Applies one or more tags to specific resource. A tag is a key-value pair that helps you manage, identify, search, and filter your resources.</p>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource.</p> </li>
        /// <li> <p>Each tag key must be unique and must have exactly one associated value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8.</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8.</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @</p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Applies one or more tags to specific resource. A tag is a key-value pair that helps you manage, identify, search, and filter your resources.</p>
        /// <p>Format: <code>"key" : "value"</code> </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li> <p>Maximum 50 tags per resource.</p> </li>
        /// <li> <p>Each tag key must be unique and must have exactly one associated value.</p> </li>
        /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8.</p> </li>
        /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8.</p> </li>
        /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @</p> </li>
        /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_47 = &_input.resource_arn;
                let input_47 = input_47.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_47, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("metadata.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource from which you want to remove tags.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li>
        /// </ul>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which you want to remove tags.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li>
        /// </ul>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove from the specified resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The list of tag keys to remove from the specified resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_48 = &_input.resource_arn;
                let input_48 = input_48.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_48, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UntagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_49) = &_input.tag_keys {
                    for inner_50 in inner_49 {
                        query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_50));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("metadata.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateGeofenceCollectionInput`](crate::input::UpdateGeofenceCollectionInput)
pub mod update_geofence_collection_input {
    /// A builder for [`UpdateGeofenceCollectionInput`](crate::input::UpdateGeofenceCollectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) collection_name: std::option::Option<std::string::String>,
        pub(crate) pricing_plan: std::option::Option<crate::model::PricingPlan>,
        pub(crate) pricing_plan_data_source: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the geofence collection to update.</p>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.collection_name = Some(input.into());
            self
        }
        /// <p>The name of the geofence collection to update.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.collection_name = input;
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.pricing_plan = Some(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.pricing_plan = input;
            self
        }
        /// <p>This parameter is no longer used.</p>
        pub fn pricing_plan_data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.pricing_plan_data_source = Some(input.into());
            self
        }
        /// <p>This parameter is no longer used.</p>
        pub fn set_pricing_plan_data_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pricing_plan_data_source = input;
            self
        }
        /// <p>Updates the description for the geofence collection.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Updates the description for the geofence collection.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGeofenceCollectionInput`](crate::input::UpdateGeofenceCollectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateGeofenceCollectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateGeofenceCollectionInput {
                collection_name: self.collection_name,
                pricing_plan: self.pricing_plan,
                pricing_plan_data_source: self.pricing_plan_data_source,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateGeofenceCollectionInputOperationOutputAlias =
    crate::operation::UpdateGeofenceCollection;
#[doc(hidden)]
pub type UpdateGeofenceCollectionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateGeofenceCollectionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateGeofenceCollection`](crate::operation::UpdateGeofenceCollection)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateGeofenceCollection,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateGeofenceCollectionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_51 = &_input.collection_name;
                let input_51 = input_51.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "collection_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let collection_name = aws_smithy_http::label::fmt_string(input_51, false);
                if collection_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "collection_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/geofencing/v0/collections/{CollectionName}",
                    CollectionName = collection_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateGeofenceCollectionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_geofence_collection(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("geofencing.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateGeofenceCollection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateGeofenceCollection",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateGeofenceCollectionInput`](crate::input::UpdateGeofenceCollectionInput)
    pub fn builder() -> crate::input::update_geofence_collection_input::Builder {
        crate::input::update_geofence_collection_input::Builder::default()
    }
}

/// See [`UpdateMapInput`](crate::input::UpdateMapInput)
pub mod update_map_input {
    /// A builder for [`UpdateMapInput`](crate::input::UpdateMapInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) map_name: std::option::Option<std::string::String>,
        pub(crate) pricing_plan: std::option::Option<crate::model::PricingPlan>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the map resource to update.</p>
        pub fn map_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.map_name = Some(input.into());
            self
        }
        /// <p>The name of the map resource to update.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.map_name = input;
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.pricing_plan = Some(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.pricing_plan = input;
            self
        }
        /// <p>Updates the description for the map resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Updates the description for the map resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMapInput`](crate::input::UpdateMapInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::UpdateMapInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::UpdateMapInput {
                map_name: self.map_name,
                pricing_plan: self.pricing_plan,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateMapInputOperationOutputAlias = crate::operation::UpdateMap;
#[doc(hidden)]
pub type UpdateMapInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateMapInput {
    /// Consumes the builder and constructs an Operation<[`UpdateMap`](crate::operation::UpdateMap)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateMap,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateMapInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_52 = &_input.map_name;
                let input_52 = input_52.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "map_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let map_name = aws_smithy_http::label::fmt_string(input_52, false);
                if map_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "map_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/maps/v0/maps/{MapName}", MapName = map_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateMapInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_map(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("maps.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::UpdateMap::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "UpdateMap",
                    "location",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateMapInput`](crate::input::UpdateMapInput)
    pub fn builder() -> crate::input::update_map_input::Builder {
        crate::input::update_map_input::Builder::default()
    }
}

/// See [`UpdatePlaceIndexInput`](crate::input::UpdatePlaceIndexInput)
pub mod update_place_index_input {
    /// A builder for [`UpdatePlaceIndexInput`](crate::input::UpdatePlaceIndexInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) pricing_plan: std::option::Option<crate::model::PricingPlan>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) data_source_configuration:
            std::option::Option<crate::model::DataSourceConfiguration>,
    }
    impl Builder {
        /// <p>The name of the place index resource to update.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the place index resource to update.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.pricing_plan = Some(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.pricing_plan = input;
            self
        }
        /// <p>Updates the description for the place index resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Updates the description for the place index resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Updates the data storage option for the place index resource.</p>
        pub fn data_source_configuration(
            mut self,
            input: crate::model::DataSourceConfiguration,
        ) -> Self {
            self.data_source_configuration = Some(input);
            self
        }
        /// <p>Updates the data storage option for the place index resource.</p>
        pub fn set_data_source_configuration(
            mut self,
            input: std::option::Option<crate::model::DataSourceConfiguration>,
        ) -> Self {
            self.data_source_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePlaceIndexInput`](crate::input::UpdatePlaceIndexInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdatePlaceIndexInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdatePlaceIndexInput {
                index_name: self.index_name,
                pricing_plan: self.pricing_plan,
                description: self.description,
                data_source_configuration: self.data_source_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdatePlaceIndexInputOperationOutputAlias = crate::operation::UpdatePlaceIndex;
#[doc(hidden)]
pub type UpdatePlaceIndexInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdatePlaceIndexInput {
    /// Consumes the builder and constructs an Operation<[`UpdatePlaceIndex`](crate::operation::UpdatePlaceIndex)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdatePlaceIndex,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdatePlaceIndexInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_53 = &_input.index_name;
                let input_53 = input_53.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "index_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let index_name = aws_smithy_http::label::fmt_string(input_53, false);
                if index_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "index_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/places/v0/indexes/{IndexName}",
                    IndexName = index_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdatePlaceIndexInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_place_index(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("places.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdatePlaceIndex::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdatePlaceIndex",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdatePlaceIndexInput`](crate::input::UpdatePlaceIndexInput)
    pub fn builder() -> crate::input::update_place_index_input::Builder {
        crate::input::update_place_index_input::Builder::default()
    }
}

/// See [`UpdateRouteCalculatorInput`](crate::input::UpdateRouteCalculatorInput)
pub mod update_route_calculator_input {
    /// A builder for [`UpdateRouteCalculatorInput`](crate::input::UpdateRouteCalculatorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) calculator_name: std::option::Option<std::string::String>,
        pub(crate) pricing_plan: std::option::Option<crate::model::PricingPlan>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the route calculator resource to update.</p>
        pub fn calculator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.calculator_name = Some(input.into());
            self
        }
        /// <p>The name of the route calculator resource to update.</p>
        pub fn set_calculator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.calculator_name = input;
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.pricing_plan = Some(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.pricing_plan = input;
            self
        }
        /// <p>Updates the description for the route calculator resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Updates the description for the route calculator resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRouteCalculatorInput`](crate::input::UpdateRouteCalculatorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateRouteCalculatorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateRouteCalculatorInput {
                calculator_name: self.calculator_name,
                pricing_plan: self.pricing_plan,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateRouteCalculatorInputOperationOutputAlias = crate::operation::UpdateRouteCalculator;
#[doc(hidden)]
pub type UpdateRouteCalculatorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateRouteCalculatorInput {
    /// Consumes the builder and constructs an Operation<[`UpdateRouteCalculator`](crate::operation::UpdateRouteCalculator)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateRouteCalculator,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateRouteCalculatorInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_54 = &_input.calculator_name;
                let input_54 = input_54.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "calculator_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let calculator_name = aws_smithy_http::label::fmt_string(input_54, false);
                if calculator_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "calculator_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/routes/v0/calculators/{CalculatorName}",
                    CalculatorName = calculator_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateRouteCalculatorInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_route_calculator(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("routes.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateRouteCalculator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateRouteCalculator",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateRouteCalculatorInput`](crate::input::UpdateRouteCalculatorInput)
    pub fn builder() -> crate::input::update_route_calculator_input::Builder {
        crate::input::update_route_calculator_input::Builder::default()
    }
}

/// See [`UpdateTrackerInput`](crate::input::UpdateTrackerInput)
pub mod update_tracker_input {
    /// A builder for [`UpdateTrackerInput`](crate::input::UpdateTrackerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tracker_name: std::option::Option<std::string::String>,
        pub(crate) pricing_plan: std::option::Option<crate::model::PricingPlan>,
        pub(crate) pricing_plan_data_source: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) position_filtering: std::option::Option<crate::model::PositionFiltering>,
    }
    impl Builder {
        /// <p>The name of the tracker resource to update.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracker_name = Some(input.into());
            self
        }
        /// <p>The name of the tracker resource to update.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tracker_name = input;
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.pricing_plan = Some(input);
            self
        }
        /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.pricing_plan = input;
            self
        }
        /// <p>This parameter is no longer used.</p>
        pub fn pricing_plan_data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.pricing_plan_data_source = Some(input.into());
            self
        }
        /// <p>This parameter is no longer used.</p>
        pub fn set_pricing_plan_data_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pricing_plan_data_source = input;
            self
        }
        /// <p>Updates the description for the tracker resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Updates the description for the tracker resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Updates the position filtering for the tracker resource.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li> <p> <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID. </p> </li>
        /// <li> <p> <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this distance are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map. </p> </li>
        /// <li> <p> <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This helps educe the effects of GPS noise when displaying device trajectories on a map, and can help control costs by reducing the number of geofence evaluations. </p> </li>
        /// </ul>
        pub fn position_filtering(mut self, input: crate::model::PositionFiltering) -> Self {
            self.position_filtering = Some(input);
            self
        }
        /// <p>Updates the position filtering for the tracker resource.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li> <p> <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID. </p> </li>
        /// <li> <p> <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this distance are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map. </p> </li>
        /// <li> <p> <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This helps educe the effects of GPS noise when displaying device trajectories on a map, and can help control costs by reducing the number of geofence evaluations. </p> </li>
        /// </ul>
        pub fn set_position_filtering(
            mut self,
            input: std::option::Option<crate::model::PositionFiltering>,
        ) -> Self {
            self.position_filtering = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTrackerInput`](crate::input::UpdateTrackerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateTrackerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateTrackerInput {
                tracker_name: self.tracker_name,
                pricing_plan: self.pricing_plan,
                pricing_plan_data_source: self.pricing_plan_data_source,
                description: self.description,
                position_filtering: self.position_filtering,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateTrackerInputOperationOutputAlias = crate::operation::UpdateTracker;
#[doc(hidden)]
pub type UpdateTrackerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateTrackerInput {
    /// Consumes the builder and constructs an Operation<[`UpdateTracker`](crate::operation::UpdateTracker)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateTracker,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateTrackerInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_55 = &_input.tracker_name;
                let input_55 = input_55.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let tracker_name = aws_smithy_http::label::fmt_string(input_55, false);
                if tracker_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "tracker_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/tracking/v0/trackers/{TrackerName}",
                    TrackerName = tracker_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateTrackerInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_tracker(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let endpoint_prefix = aws_smithy_http::endpoint::EndpointPrefix::new("tracking.")?;
        request.properties_mut().insert(endpoint_prefix);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateTracker::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateTracker",
            "location",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateTrackerInput`](crate::input::UpdateTrackerInput)
    pub fn builder() -> crate::input::update_tracker_input::Builder {
        crate::input::update_tracker_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrackerConsumersInput {
    /// <p>The tracker resource whose associated geofence collections you want to list.</p>
    pub tracker_name: std::option::Option<std::string::String>,
    /// <p>An optional limit for the number of resources returned in a single call. </p>
    /// <p>Default value: <code>100</code> </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
    /// <p>Default value: <code>null</code> </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTrackerConsumersInput {
    /// <p>The tracker resource whose associated geofence collections you want to list.</p>
    pub fn tracker_name(&self) -> std::option::Option<&str> {
        self.tracker_name.as_deref()
    }
    /// <p>An optional limit for the number of resources returned in a single call. </p>
    /// <p>Default value: <code>100</code> </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
    /// <p>Default value: <code>null</code> </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTrackerConsumersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrackerConsumersInput");
        formatter.field("tracker_name", &self.tracker_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDevicePositionsInput {
    /// <p>The tracker resource containing the requested devices.</p>
    pub tracker_name: std::option::Option<std::string::String>,
    /// <p>An optional limit for the number of entries returned in a single call.</p>
    /// <p>Default value: <code>100</code> </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
    /// <p>Default value: <code>null</code> </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDevicePositionsInput {
    /// <p>The tracker resource containing the requested devices.</p>
    pub fn tracker_name(&self) -> std::option::Option<&str> {
        self.tracker_name.as_deref()
    }
    /// <p>An optional limit for the number of entries returned in a single call.</p>
    /// <p>Default value: <code>100</code> </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
    /// <p>Default value: <code>null</code> </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDevicePositionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDevicePositionsInput");
        formatter.field("tracker_name", &self.tracker_name);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDevicePositionHistoryInput {
    /// <p>The tracker resource receiving the request for the device position history.</p>
    pub tracker_name: std::option::Option<std::string::String>,
    /// <p>The device whose position history you want to retrieve.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
    /// <p>Default value: <code>null</code> </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Specify the start time for the position history in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be 24 hours prior to the time that the request is made.</p>
    /// <p>Requirement:</p>
    /// <ul>
    /// <li> <p>The time specified for <code>StartTimeInclusive</code> must be before <code>EndTimeExclusive</code>.</p> </li>
    /// </ul>
    pub start_time_inclusive: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specify the end time for the position history in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be the time that the request is made.</p>
    /// <p>Requirement:</p>
    /// <ul>
    /// <li> <p>The time specified for <code>EndTimeExclusive</code> must be after the time for <code>StartTimeInclusive</code>.</p> </li>
    /// </ul>
    pub end_time_exclusive: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetDevicePositionHistoryInput {
    /// <p>The tracker resource receiving the request for the device position history.</p>
    pub fn tracker_name(&self) -> std::option::Option<&str> {
        self.tracker_name.as_deref()
    }
    /// <p>The device whose position history you want to retrieve.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
    /// <p>Default value: <code>null</code> </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Specify the start time for the position history in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be 24 hours prior to the time that the request is made.</p>
    /// <p>Requirement:</p>
    /// <ul>
    /// <li> <p>The time specified for <code>StartTimeInclusive</code> must be before <code>EndTimeExclusive</code>.</p> </li>
    /// </ul>
    pub fn start_time_inclusive(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time_inclusive.as_ref()
    }
    /// <p>Specify the end time for the position history in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be the time that the request is made.</p>
    /// <p>Requirement:</p>
    /// <ul>
    /// <li> <p>The time specified for <code>EndTimeExclusive</code> must be after the time for <code>StartTimeInclusive</code>.</p> </li>
    /// </ul>
    pub fn end_time_exclusive(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time_exclusive.as_ref()
    }
}
impl std::fmt::Debug for GetDevicePositionHistoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDevicePositionHistoryInput");
        formatter.field("tracker_name", &self.tracker_name);
        formatter.field("device_id", &self.device_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("start_time_inclusive", &self.start_time_inclusive);
        formatter.field("end_time_exclusive", &self.end_time_exclusive);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDevicePositionInput {
    /// <p>The tracker resource receiving the position update.</p>
    pub tracker_name: std::option::Option<std::string::String>,
    /// <p>The device whose position you want to retrieve.</p>
    pub device_id: std::option::Option<std::string::String>,
}
impl GetDevicePositionInput {
    /// <p>The tracker resource receiving the position update.</p>
    pub fn tracker_name(&self) -> std::option::Option<&str> {
        self.tracker_name.as_deref()
    }
    /// <p>The device whose position you want to retrieve.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
}
impl std::fmt::Debug for GetDevicePositionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDevicePositionInput");
        formatter.field("tracker_name", &self.tracker_name);
        formatter.field("device_id", &self.device_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateTrackerConsumerInput {
    /// <p>The name of the tracker resource to be dissociated from the consumer.</p>
    pub tracker_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the geofence collection to be disassociated from the tracker resource. Used when you need to specify a resource across all AWS. </p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code> </p> </li>
    /// </ul>
    pub consumer_arn: std::option::Option<std::string::String>,
}
impl DisassociateTrackerConsumerInput {
    /// <p>The name of the tracker resource to be dissociated from the consumer.</p>
    pub fn tracker_name(&self) -> std::option::Option<&str> {
        self.tracker_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the geofence collection to be disassociated from the tracker resource. Used when you need to specify a resource across all AWS. </p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code> </p> </li>
    /// </ul>
    pub fn consumer_arn(&self) -> std::option::Option<&str> {
        self.consumer_arn.as_deref()
    }
}
impl std::fmt::Debug for DisassociateTrackerConsumerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateTrackerConsumerInput");
        formatter.field("tracker_name", &self.tracker_name);
        formatter.field("consumer_arn", &self.consumer_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchUpdateDevicePositionInput {
    /// <p>The name of the tracker resource to update.</p>
    pub tracker_name: std::option::Option<std::string::String>,
    /// <p>Contains the position update details for each device.</p>
    pub updates: std::option::Option<std::vec::Vec<crate::model::DevicePositionUpdate>>,
}
impl BatchUpdateDevicePositionInput {
    /// <p>The name of the tracker resource to update.</p>
    pub fn tracker_name(&self) -> std::option::Option<&str> {
        self.tracker_name.as_deref()
    }
    /// <p>Contains the position update details for each device.</p>
    pub fn updates(&self) -> std::option::Option<&[crate::model::DevicePositionUpdate]> {
        self.updates.as_deref()
    }
}
impl std::fmt::Debug for BatchUpdateDevicePositionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchUpdateDevicePositionInput");
        formatter.field("tracker_name", &self.tracker_name);
        formatter.field("updates", &self.updates);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetDevicePositionInput {
    /// <p>The tracker resource retrieving the device position.</p>
    pub tracker_name: std::option::Option<std::string::String>,
    /// <p>Devices whose position you want to retrieve.</p>
    /// <ul>
    /// <li> <p>For example, for two devices: <code>device-ids=DeviceId1&amp;device-ids=DeviceId2</code> </p> </li>
    /// </ul>
    pub device_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchGetDevicePositionInput {
    /// <p>The tracker resource retrieving the device position.</p>
    pub fn tracker_name(&self) -> std::option::Option<&str> {
        self.tracker_name.as_deref()
    }
    /// <p>Devices whose position you want to retrieve.</p>
    /// <ul>
    /// <li> <p>For example, for two devices: <code>device-ids=DeviceId1&amp;device-ids=DeviceId2</code> </p> </li>
    /// </ul>
    pub fn device_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.device_ids.as_deref()
    }
}
impl std::fmt::Debug for BatchGetDevicePositionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetDevicePositionInput");
        formatter.field("tracker_name", &self.tracker_name);
        formatter.field("device_ids", &self.device_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteDevicePositionHistoryInput {
    /// <p>The name of the tracker resource to delete the device position history from.</p>
    pub tracker_name: std::option::Option<std::string::String>,
    /// <p>Devices whose position history you want to delete.</p>
    /// <ul>
    /// <li> <p>For example, for two devices: <code>“DeviceIds” : [DeviceId1,DeviceId2]</code> </p> </li>
    /// </ul>
    pub device_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchDeleteDevicePositionHistoryInput {
    /// <p>The name of the tracker resource to delete the device position history from.</p>
    pub fn tracker_name(&self) -> std::option::Option<&str> {
        self.tracker_name.as_deref()
    }
    /// <p>Devices whose position history you want to delete.</p>
    /// <ul>
    /// <li> <p>For example, for two devices: <code>“DeviceIds” : [DeviceId1,DeviceId2]</code> </p> </li>
    /// </ul>
    pub fn device_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.device_ids.as_deref()
    }
}
impl std::fmt::Debug for BatchDeleteDevicePositionHistoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteDevicePositionHistoryInput");
        formatter.field("tracker_name", &self.tracker_name);
        formatter.field("device_ids", &self.device_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateTrackerConsumerInput {
    /// <p>The name of the tracker resource to be associated with a geofence collection.</p>
    pub tracker_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code> </p> </li>
    /// </ul>
    pub consumer_arn: std::option::Option<std::string::String>,
}
impl AssociateTrackerConsumerInput {
    /// <p>The name of the tracker resource to be associated with a geofence collection.</p>
    pub fn tracker_name(&self) -> std::option::Option<&str> {
        self.tracker_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker resource. Used when you need to specify a resource across all AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code> </p> </li>
    /// </ul>
    pub fn consumer_arn(&self) -> std::option::Option<&str> {
        self.consumer_arn.as_deref()
    }
}
impl std::fmt::Debug for AssociateTrackerConsumerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateTrackerConsumerInput");
        formatter.field("tracker_name", &self.tracker_name);
        formatter.field("consumer_arn", &self.consumer_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrackersInput {
    /// <p>An optional limit for the number of resources returned in a single call. </p>
    /// <p>Default value: <code>100</code> </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
    /// <p>Default value: <code>null</code> </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTrackersInput {
    /// <p>An optional limit for the number of resources returned in a single call. </p>
    /// <p>Default value: <code>100</code> </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
    /// <p>Default value: <code>null</code> </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTrackersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrackersInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTrackerInput {
    /// <p>The name for the tracker resource.</p>
    /// <p>Requirements:</p>
    /// <ul>
    /// <li> <p>Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).</p> </li>
    /// <li> <p>Must be a unique tracker resource name.</p> </li>
    /// <li> <p>No spaces allowed. For example, <code>ExampleTracker</code>.</p> </li>
    /// </ul>
    pub tracker_name: std::option::Option<std::string::String>,
    /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    pub pricing_plan: std::option::Option<crate::model::PricingPlan>,
    /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>This parameter is no longer used.</p>
    pub pricing_plan_data_source: std::option::Option<std::string::String>,
    /// <p>An optional description for the tracker resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Applies one or more tags to the tracker resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
    /// <p>Format: <code>"key" : "value"</code> </p>
    /// <p>Restrictions:</p>
    /// <ul>
    /// <li> <p>Maximum 50 tags per resource</p> </li>
    /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
    /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
    /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
    /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
    /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
    /// </ul>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>Specifies the position filtering for the tracker resource.</p>
    /// <p>Valid values:</p>
    /// <ul>
    /// <li> <p> <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID. </p> </li>
    /// <li> <p> <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this area are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map. </p> </li>
    /// <li> <p> <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This can reduce the effects of GPS noise when displaying device trajectories on a map, and can help control your costs by reducing the number of geofence evaluations. </p> </li>
    /// </ul>
    /// <p>This field is optional. If not specified, the default value is <code>TimeBased</code>.</p>
    pub position_filtering: std::option::Option<crate::model::PositionFiltering>,
}
impl CreateTrackerInput {
    /// <p>The name for the tracker resource.</p>
    /// <p>Requirements:</p>
    /// <ul>
    /// <li> <p>Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).</p> </li>
    /// <li> <p>Must be a unique tracker resource name.</p> </li>
    /// <li> <p>No spaces allowed. For example, <code>ExampleTracker</code>.</p> </li>
    /// </ul>
    pub fn tracker_name(&self) -> std::option::Option<&str> {
        self.tracker_name.as_deref()
    }
    /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    pub fn pricing_plan(&self) -> std::option::Option<&crate::model::PricingPlan> {
        self.pricing_plan.as_ref()
    }
    /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>This parameter is no longer used.</p>
    pub fn pricing_plan_data_source(&self) -> std::option::Option<&str> {
        self.pricing_plan_data_source.as_deref()
    }
    /// <p>An optional description for the tracker resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Applies one or more tags to the tracker resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
    /// <p>Format: <code>"key" : "value"</code> </p>
    /// <p>Restrictions:</p>
    /// <ul>
    /// <li> <p>Maximum 50 tags per resource</p> </li>
    /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
    /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
    /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
    /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
    /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
    /// </ul>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>Specifies the position filtering for the tracker resource.</p>
    /// <p>Valid values:</p>
    /// <ul>
    /// <li> <p> <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID. </p> </li>
    /// <li> <p> <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this area are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map. </p> </li>
    /// <li> <p> <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This can reduce the effects of GPS noise when displaying device trajectories on a map, and can help control your costs by reducing the number of geofence evaluations. </p> </li>
    /// </ul>
    /// <p>This field is optional. If not specified, the default value is <code>TimeBased</code>.</p>
    pub fn position_filtering(&self) -> std::option::Option<&crate::model::PositionFiltering> {
        self.position_filtering.as_ref()
    }
}
impl std::fmt::Debug for CreateTrackerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTrackerInput");
        formatter.field("tracker_name", &self.tracker_name);
        formatter.field("pricing_plan", &self.pricing_plan);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("pricing_plan_data_source", &self.pricing_plan_data_source);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.field("position_filtering", &self.position_filtering);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTrackerInput {
    /// <p>The name of the tracker resource to be deleted.</p>
    pub tracker_name: std::option::Option<std::string::String>,
}
impl DeleteTrackerInput {
    /// <p>The name of the tracker resource to be deleted.</p>
    pub fn tracker_name(&self) -> std::option::Option<&str> {
        self.tracker_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteTrackerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTrackerInput");
        formatter.field("tracker_name", &self.tracker_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTrackerInput {
    /// <p>The name of the tracker resource to update.</p>
    pub tracker_name: std::option::Option<std::string::String>,
    /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    pub pricing_plan: std::option::Option<crate::model::PricingPlan>,
    /// <p>This parameter is no longer used.</p>
    pub pricing_plan_data_source: std::option::Option<std::string::String>,
    /// <p>Updates the description for the tracker resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Updates the position filtering for the tracker resource.</p>
    /// <p>Valid values:</p>
    /// <ul>
    /// <li> <p> <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID. </p> </li>
    /// <li> <p> <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this distance are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map. </p> </li>
    /// <li> <p> <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This helps educe the effects of GPS noise when displaying device trajectories on a map, and can help control costs by reducing the number of geofence evaluations. </p> </li>
    /// </ul>
    pub position_filtering: std::option::Option<crate::model::PositionFiltering>,
}
impl UpdateTrackerInput {
    /// <p>The name of the tracker resource to update.</p>
    pub fn tracker_name(&self) -> std::option::Option<&str> {
        self.tracker_name.as_deref()
    }
    /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    pub fn pricing_plan(&self) -> std::option::Option<&crate::model::PricingPlan> {
        self.pricing_plan.as_ref()
    }
    /// <p>This parameter is no longer used.</p>
    pub fn pricing_plan_data_source(&self) -> std::option::Option<&str> {
        self.pricing_plan_data_source.as_deref()
    }
    /// <p>Updates the description for the tracker resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Updates the position filtering for the tracker resource.</p>
    /// <p>Valid values:</p>
    /// <ul>
    /// <li> <p> <code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID. </p> </li>
    /// <li> <p> <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this distance are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map. </p> </li>
    /// <li> <p> <code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This helps educe the effects of GPS noise when displaying device trajectories on a map, and can help control costs by reducing the number of geofence evaluations. </p> </li>
    /// </ul>
    pub fn position_filtering(&self) -> std::option::Option<&crate::model::PositionFiltering> {
        self.position_filtering.as_ref()
    }
}
impl std::fmt::Debug for UpdateTrackerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTrackerInput");
        formatter.field("tracker_name", &self.tracker_name);
        formatter.field("pricing_plan", &self.pricing_plan);
        formatter.field("pricing_plan_data_source", &self.pricing_plan_data_source);
        formatter.field("description", &self.description);
        formatter.field("position_filtering", &self.position_filtering);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTrackerInput {
    /// <p>The name of the tracker resource.</p>
    pub tracker_name: std::option::Option<std::string::String>,
}
impl DescribeTrackerInput {
    /// <p>The name of the tracker resource.</p>
    pub fn tracker_name(&self) -> std::option::Option<&str> {
        self.tracker_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeTrackerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTrackerInput");
        formatter.field("tracker_name", &self.tracker_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CalculateRouteMatrixInput {
    /// <p>The name of the route calculator resource that you want to use to calculate the route matrix. </p>
    pub calculator_name: std::option::Option<std::string::String>,
    /// <p>The list of departure (origin) positions for the route matrix. An array of points, each of which is itself a 2-value array defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>. For example, <code>[-123.115, 49.285]</code>.</p> <important>
    /// <p>Depending on the data provider selected in the route calculator resource there may be additional restrictions on the inputs you can choose. See <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits"> Position restrictions</a> in the <i>Amazon Location Service Developer Guide</i>.</p>
    /// </important> <note>
    /// <p>For route calculators that use Esri as the data provider, if you specify a departure that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html"> moves the position to the nearest road</a>. The snapped value is available in the result in <code>SnappedDeparturePositions</code>.</p>
    /// </note>
    /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
    pub departure_positions: std::option::Option<std::vec::Vec<std::vec::Vec<f64>>>,
    /// <p>The list of destination positions for the route matrix. An array of points, each of which is itself a 2-value array defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>. For example, <code>[-122.339, 47.615]</code> </p> <important>
    /// <p>Depending on the data provider selected in the route calculator resource there may be additional restrictions on the inputs you can choose. See <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits"> Position restrictions</a> in the <i>Amazon Location Service Developer Guide</i>.</p>
    /// </important> <note>
    /// <p>For route calculators that use Esri as the data provider, if you specify a destination that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html"> moves the position to the nearest road</a>. The snapped value is available in the result in <code>SnappedDestinationPositions</code>.</p>
    /// </note>
    /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
    pub destination_positions: std::option::Option<std::vec::Vec<std::vec::Vec<f64>>>,
    /// <p>Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road compatibility.</p>
    /// <p>The <code>TravelMode</code> you specify also determines how you specify route preferences: </p>
    /// <ul>
    /// <li> <p>If traveling by <code>Car</code> use the <code>CarModeOptions</code> parameter.</p> </li>
    /// <li> <p>If traveling by <code>Truck</code> use the <code>TruckModeOptions</code> parameter.</p> </li>
    /// </ul>
    /// <p>Default Value: <code>Car</code> </p>
    pub travel_mode: std::option::Option<crate::model::TravelMode>,
    /// <p>Specifies the desired time of departure. Uses the given time to calculate the route matrix. You can't set both <code>DepartureTime</code> and <code>DepartNow</code>. If neither is set, the best time of day to travel with the best traffic conditions is used to calculate the route matrix.</p> <note>
    /// <p>Setting a departure time in the past returns a <code>400 ValidationException</code> error.</p>
    /// </note>
    /// <ul>
    /// <li> <p>In <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
    /// </ul>
    pub departure_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Sets the time of departure as the current time. Uses the current time to calculate the route matrix. You can't set both <code>DepartureTime</code> and <code>DepartNow</code>. If neither is set, the best time of day to travel with the best traffic conditions is used to calculate the route matrix.</p>
    /// <p>Default Value: <code>false</code> </p>
    /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
    pub depart_now: std::option::Option<bool>,
    /// <p>Set the unit system to specify the distance.</p>
    /// <p>Default Value: <code>Kilometers</code> </p>
    pub distance_unit: std::option::Option<crate::model::DistanceUnit>,
    /// <p>Specifies route preferences when traveling by <code>Car</code>, such as avoiding routes that use ferries or tolls.</p>
    /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Car</code>.</p>
    pub car_mode_options: std::option::Option<crate::model::CalculateRouteCarModeOptions>,
    /// <p>Specifies route preferences when traveling by <code>Truck</code>, such as avoiding routes that use ferries or tolls, and truck specifications to consider when choosing an optimal road.</p>
    /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Truck</code>.</p>
    pub truck_mode_options: std::option::Option<crate::model::CalculateRouteTruckModeOptions>,
}
impl CalculateRouteMatrixInput {
    /// <p>The name of the route calculator resource that you want to use to calculate the route matrix. </p>
    pub fn calculator_name(&self) -> std::option::Option<&str> {
        self.calculator_name.as_deref()
    }
    /// <p>The list of departure (origin) positions for the route matrix. An array of points, each of which is itself a 2-value array defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>. For example, <code>[-123.115, 49.285]</code>.</p> <important>
    /// <p>Depending on the data provider selected in the route calculator resource there may be additional restrictions on the inputs you can choose. See <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits"> Position restrictions</a> in the <i>Amazon Location Service Developer Guide</i>.</p>
    /// </important> <note>
    /// <p>For route calculators that use Esri as the data provider, if you specify a departure that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html"> moves the position to the nearest road</a>. The snapped value is available in the result in <code>SnappedDeparturePositions</code>.</p>
    /// </note>
    /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
    pub fn departure_positions(&self) -> std::option::Option<&[std::vec::Vec<f64>]> {
        self.departure_positions.as_deref()
    }
    /// <p>The list of destination positions for the route matrix. An array of points, each of which is itself a 2-value array defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>. For example, <code>[-122.339, 47.615]</code> </p> <important>
    /// <p>Depending on the data provider selected in the route calculator resource there may be additional restrictions on the inputs you can choose. See <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route-matrix.html#matrix-routing-position-limits"> Position restrictions</a> in the <i>Amazon Location Service Developer Guide</i>.</p>
    /// </important> <note>
    /// <p>For route calculators that use Esri as the data provider, if you specify a destination that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html"> moves the position to the nearest road</a>. The snapped value is available in the result in <code>SnappedDestinationPositions</code>.</p>
    /// </note>
    /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
    pub fn destination_positions(&self) -> std::option::Option<&[std::vec::Vec<f64>]> {
        self.destination_positions.as_deref()
    }
    /// <p>Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road compatibility.</p>
    /// <p>The <code>TravelMode</code> you specify also determines how you specify route preferences: </p>
    /// <ul>
    /// <li> <p>If traveling by <code>Car</code> use the <code>CarModeOptions</code> parameter.</p> </li>
    /// <li> <p>If traveling by <code>Truck</code> use the <code>TruckModeOptions</code> parameter.</p> </li>
    /// </ul>
    /// <p>Default Value: <code>Car</code> </p>
    pub fn travel_mode(&self) -> std::option::Option<&crate::model::TravelMode> {
        self.travel_mode.as_ref()
    }
    /// <p>Specifies the desired time of departure. Uses the given time to calculate the route matrix. You can't set both <code>DepartureTime</code> and <code>DepartNow</code>. If neither is set, the best time of day to travel with the best traffic conditions is used to calculate the route matrix.</p> <note>
    /// <p>Setting a departure time in the past returns a <code>400 ValidationException</code> error.</p>
    /// </note>
    /// <ul>
    /// <li> <p>In <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
    /// </ul>
    pub fn departure_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.departure_time.as_ref()
    }
    /// <p>Sets the time of departure as the current time. Uses the current time to calculate the route matrix. You can't set both <code>DepartureTime</code> and <code>DepartNow</code>. If neither is set, the best time of day to travel with the best traffic conditions is used to calculate the route matrix.</p>
    /// <p>Default Value: <code>false</code> </p>
    /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
    pub fn depart_now(&self) -> std::option::Option<bool> {
        self.depart_now
    }
    /// <p>Set the unit system to specify the distance.</p>
    /// <p>Default Value: <code>Kilometers</code> </p>
    pub fn distance_unit(&self) -> std::option::Option<&crate::model::DistanceUnit> {
        self.distance_unit.as_ref()
    }
    /// <p>Specifies route preferences when traveling by <code>Car</code>, such as avoiding routes that use ferries or tolls.</p>
    /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Car</code>.</p>
    pub fn car_mode_options(
        &self,
    ) -> std::option::Option<&crate::model::CalculateRouteCarModeOptions> {
        self.car_mode_options.as_ref()
    }
    /// <p>Specifies route preferences when traveling by <code>Truck</code>, such as avoiding routes that use ferries or tolls, and truck specifications to consider when choosing an optimal road.</p>
    /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Truck</code>.</p>
    pub fn truck_mode_options(
        &self,
    ) -> std::option::Option<&crate::model::CalculateRouteTruckModeOptions> {
        self.truck_mode_options.as_ref()
    }
}
impl std::fmt::Debug for CalculateRouteMatrixInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CalculateRouteMatrixInput");
        formatter.field("calculator_name", &self.calculator_name);
        formatter.field("departure_positions", &self.departure_positions);
        formatter.field("destination_positions", &self.destination_positions);
        formatter.field("travel_mode", &self.travel_mode);
        formatter.field("departure_time", &self.departure_time);
        formatter.field("depart_now", &self.depart_now);
        formatter.field("distance_unit", &self.distance_unit);
        formatter.field("car_mode_options", &self.car_mode_options);
        formatter.field("truck_mode_options", &self.truck_mode_options);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CalculateRouteInput {
    /// <p>The name of the route calculator resource that you want to use to calculate the route. </p>
    pub calculator_name: std::option::Option<std::string::String>,
    /// <p>The start position for the route. Defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>.</p>
    /// <ul>
    /// <li> <p>For example, <code>[-123.115, 49.285]</code> </p> </li>
    /// </ul> <note>
    /// <p>If you specify a departure that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. If Esri is the provider for your route calculator, specifying a route that is longer than 400 km returns a <code>400 RoutesValidationException</code> error.</p>
    /// </note>
    /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
    pub departure_position: std::option::Option<std::vec::Vec<f64>>,
    /// <p>The finish position for the route. Defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>.</p>
    /// <ul>
    /// <li> <p> For example, <code>[-122.339, 47.615]</code> </p> </li>
    /// </ul> <note>
    /// <p>If you specify a destination that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. </p>
    /// </note>
    /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
    pub destination_position: std::option::Option<std::vec::Vec<f64>>,
    /// <p>Specifies an ordered list of up to 23 intermediate positions to include along a route between the departure position and destination position. </p>
    /// <ul>
    /// <li> <p>For example, from the <code>DeparturePosition</code> <code>[-123.115, 49.285]</code>, the route follows the order that the waypoint positions are given <code>[[-122.757, 49.0021],[-122.349, 47.620]]</code> </p> </li>
    /// </ul> <note>
    /// <p>If you specify a waypoint position that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. </p>
    /// <p>Specifying more than 23 waypoints returns a <code>400 ValidationException</code> error.</p>
    /// <p>If Esri is the provider for your route calculator, specifying a route that is longer than 400 km returns a <code>400 RoutesValidationException</code> error.</p>
    /// </note>
    /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
    pub waypoint_positions: std::option::Option<std::vec::Vec<std::vec::Vec<f64>>>,
    /// <p>Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road compatibility.</p>
    /// <p>The <code>TravelMode</code> you specify also determines how you specify route preferences: </p>
    /// <ul>
    /// <li> <p>If traveling by <code>Car</code> use the <code>CarModeOptions</code> parameter.</p> </li>
    /// <li> <p>If traveling by <code>Truck</code> use the <code>TruckModeOptions</code> parameter.</p> </li>
    /// </ul>
    /// <p>Default Value: <code>Car</code> </p>
    pub travel_mode: std::option::Option<crate::model::TravelMode>,
    /// <p>Specifies the desired time of departure. Uses the given time to calculate the route. Otherwise, the best time of day to travel with the best traffic conditions is used to calculate the route.</p> <note>
    /// <p>Setting a departure time in the past returns a <code>400 ValidationException</code> error.</p>
    /// </note>
    /// <ul>
    /// <li> <p>In <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
    /// </ul>
    pub departure_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Sets the time of departure as the current time. Uses the current time to calculate a route. Otherwise, the best time of day to travel with the best traffic conditions is used to calculate the route.</p>
    /// <p>Default Value: <code>false</code> </p>
    /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
    pub depart_now: std::option::Option<bool>,
    /// <p>Set the unit system to specify the distance.</p>
    /// <p>Default Value: <code>Kilometers</code> </p>
    pub distance_unit: std::option::Option<crate::model::DistanceUnit>,
    /// <p>Set to include the geometry details in the result for each path between a pair of positions.</p>
    /// <p>Default Value: <code>false</code> </p>
    /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
    pub include_leg_geometry: std::option::Option<bool>,
    /// <p>Specifies route preferences when traveling by <code>Car</code>, such as avoiding routes that use ferries or tolls.</p>
    /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Car</code>.</p>
    pub car_mode_options: std::option::Option<crate::model::CalculateRouteCarModeOptions>,
    /// <p>Specifies route preferences when traveling by <code>Truck</code>, such as avoiding routes that use ferries or tolls, and truck specifications to consider when choosing an optimal road.</p>
    /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Truck</code>.</p>
    pub truck_mode_options: std::option::Option<crate::model::CalculateRouteTruckModeOptions>,
}
impl CalculateRouteInput {
    /// <p>The name of the route calculator resource that you want to use to calculate the route. </p>
    pub fn calculator_name(&self) -> std::option::Option<&str> {
        self.calculator_name.as_deref()
    }
    /// <p>The start position for the route. Defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>.</p>
    /// <ul>
    /// <li> <p>For example, <code>[-123.115, 49.285]</code> </p> </li>
    /// </ul> <note>
    /// <p>If you specify a departure that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. If Esri is the provider for your route calculator, specifying a route that is longer than 400 km returns a <code>400 RoutesValidationException</code> error.</p>
    /// </note>
    /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
    pub fn departure_position(&self) -> std::option::Option<&[f64]> {
        self.departure_position.as_deref()
    }
    /// <p>The finish position for the route. Defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[longitude, latitude]</code>.</p>
    /// <ul>
    /// <li> <p> For example, <code>[-122.339, 47.615]</code> </p> </li>
    /// </ul> <note>
    /// <p>If you specify a destination that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. </p>
    /// </note>
    /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
    pub fn destination_position(&self) -> std::option::Option<&[f64]> {
        self.destination_position.as_deref()
    }
    /// <p>Specifies an ordered list of up to 23 intermediate positions to include along a route between the departure position and destination position. </p>
    /// <ul>
    /// <li> <p>For example, from the <code>DeparturePosition</code> <code>[-123.115, 49.285]</code>, the route follows the order that the waypoint positions are given <code>[[-122.757, 49.0021],[-122.349, 47.620]]</code> </p> </li>
    /// </ul> <note>
    /// <p>If you specify a waypoint position that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">moves the position to the nearest road</a>. </p>
    /// <p>Specifying more than 23 waypoints returns a <code>400 ValidationException</code> error.</p>
    /// <p>If Esri is the provider for your route calculator, specifying a route that is longer than 400 km returns a <code>400 RoutesValidationException</code> error.</p>
    /// </note>
    /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code> </p>
    pub fn waypoint_positions(&self) -> std::option::Option<&[std::vec::Vec<f64>]> {
        self.waypoint_positions.as_deref()
    }
    /// <p>Specifies the mode of transport when calculating a route. Used in estimating the speed of travel and road compatibility.</p>
    /// <p>The <code>TravelMode</code> you specify also determines how you specify route preferences: </p>
    /// <ul>
    /// <li> <p>If traveling by <code>Car</code> use the <code>CarModeOptions</code> parameter.</p> </li>
    /// <li> <p>If traveling by <code>Truck</code> use the <code>TruckModeOptions</code> parameter.</p> </li>
    /// </ul>
    /// <p>Default Value: <code>Car</code> </p>
    pub fn travel_mode(&self) -> std::option::Option<&crate::model::TravelMode> {
        self.travel_mode.as_ref()
    }
    /// <p>Specifies the desired time of departure. Uses the given time to calculate the route. Otherwise, the best time of day to travel with the best traffic conditions is used to calculate the route.</p> <note>
    /// <p>Setting a departure time in the past returns a <code>400 ValidationException</code> error.</p>
    /// </note>
    /// <ul>
    /// <li> <p>In <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
    /// </ul>
    pub fn departure_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.departure_time.as_ref()
    }
    /// <p>Sets the time of departure as the current time. Uses the current time to calculate a route. Otherwise, the best time of day to travel with the best traffic conditions is used to calculate the route.</p>
    /// <p>Default Value: <code>false</code> </p>
    /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
    pub fn depart_now(&self) -> std::option::Option<bool> {
        self.depart_now
    }
    /// <p>Set the unit system to specify the distance.</p>
    /// <p>Default Value: <code>Kilometers</code> </p>
    pub fn distance_unit(&self) -> std::option::Option<&crate::model::DistanceUnit> {
        self.distance_unit.as_ref()
    }
    /// <p>Set to include the geometry details in the result for each path between a pair of positions.</p>
    /// <p>Default Value: <code>false</code> </p>
    /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
    pub fn include_leg_geometry(&self) -> std::option::Option<bool> {
        self.include_leg_geometry
    }
    /// <p>Specifies route preferences when traveling by <code>Car</code>, such as avoiding routes that use ferries or tolls.</p>
    /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Car</code>.</p>
    pub fn car_mode_options(
        &self,
    ) -> std::option::Option<&crate::model::CalculateRouteCarModeOptions> {
        self.car_mode_options.as_ref()
    }
    /// <p>Specifies route preferences when traveling by <code>Truck</code>, such as avoiding routes that use ferries or tolls, and truck specifications to consider when choosing an optimal road.</p>
    /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Truck</code>.</p>
    pub fn truck_mode_options(
        &self,
    ) -> std::option::Option<&crate::model::CalculateRouteTruckModeOptions> {
        self.truck_mode_options.as_ref()
    }
}
impl std::fmt::Debug for CalculateRouteInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CalculateRouteInput");
        formatter.field("calculator_name", &self.calculator_name);
        formatter.field("departure_position", &"*** Sensitive Data Redacted ***");
        formatter.field("destination_position", &"*** Sensitive Data Redacted ***");
        formatter.field("waypoint_positions", &self.waypoint_positions);
        formatter.field("travel_mode", &self.travel_mode);
        formatter.field("departure_time", &self.departure_time);
        formatter.field("depart_now", &self.depart_now);
        formatter.field("distance_unit", &self.distance_unit);
        formatter.field("include_leg_geometry", &self.include_leg_geometry);
        formatter.field("car_mode_options", &self.car_mode_options);
        formatter.field("truck_mode_options", &self.truck_mode_options);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRouteCalculatorsInput {
    /// <p>An optional maximum number of results returned in a single call.</p>
    /// <p>Default Value: <code>100</code> </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
    /// <p>Default Value: <code>null</code> </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRouteCalculatorsInput {
    /// <p>An optional maximum number of results returned in a single call.</p>
    /// <p>Default Value: <code>100</code> </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
    /// <p>Default Value: <code>null</code> </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRouteCalculatorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRouteCalculatorsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRouteCalculatorInput {
    /// <p>The name of the route calculator resource. </p>
    /// <p>Requirements:</p>
    /// <ul>
    /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).</p> </li>
    /// <li> <p>Must be a unique Route calculator resource name.</p> </li>
    /// <li> <p>No spaces allowed. For example, <code>ExampleRouteCalculator</code>.</p> </li>
    /// </ul>
    pub calculator_name: std::option::Option<std::string::String>,
    /// <p>Specifies the data provider of traffic and road network data.</p> <note>
    /// <p>This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> returns an error. Route calculators that use Esri as a data source only calculate routes that are shorter than 400 km.</p>
    /// </note>
    /// <p>Valid values include:</p>
    /// <ul>
    /// <li> <p> <code>Esri</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>'s coverage in your region of interest, see <a href="https://doc.arcgis.com/en/arcgis-online/reference/network-coverage.htm">Esri details on street networks and traffic coverage</a>.</p> </li>
    /// <li> <p> <code>Here</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a>' coverage in your region of interest, see <a href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/car-routing.html">HERE car routing coverage</a> and <a href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/truck-routing.html">HERE truck routing coverage</a>.</p> </li>
    /// </ul>
    /// <p>For additional information , see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data providers</a> on the <i>Amazon Location Service Developer Guide</i>.</p>
    pub data_source: std::option::Option<std::string::String>,
    /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    pub pricing_plan: std::option::Option<crate::model::PricingPlan>,
    /// <p>The optional description for the route calculator resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Applies one or more tags to the route calculator resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
    /// <ul>
    /// <li> <p>For example: { <code>"tag1" : "value1"</code>, <code>"tag2" : "value2"</code>}</p> </li>
    /// </ul>
    /// <p>Format: <code>"key" : "value"</code> </p>
    /// <p>Restrictions:</p>
    /// <ul>
    /// <li> <p>Maximum 50 tags per resource</p> </li>
    /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
    /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
    /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
    /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
    /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
    /// </ul>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateRouteCalculatorInput {
    /// <p>The name of the route calculator resource. </p>
    /// <p>Requirements:</p>
    /// <ul>
    /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores (_).</p> </li>
    /// <li> <p>Must be a unique Route calculator resource name.</p> </li>
    /// <li> <p>No spaces allowed. For example, <code>ExampleRouteCalculator</code>.</p> </li>
    /// </ul>
    pub fn calculator_name(&self) -> std::option::Option<&str> {
        self.calculator_name.as_deref()
    }
    /// <p>Specifies the data provider of traffic and road network data.</p> <note>
    /// <p>This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> returns an error. Route calculators that use Esri as a data source only calculate routes that are shorter than 400 km.</p>
    /// </note>
    /// <p>Valid values include:</p>
    /// <ul>
    /// <li> <p> <code>Esri</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>'s coverage in your region of interest, see <a href="https://doc.arcgis.com/en/arcgis-online/reference/network-coverage.htm">Esri details on street networks and traffic coverage</a>.</p> </li>
    /// <li> <p> <code>Here</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a>' coverage in your region of interest, see <a href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/car-routing.html">HERE car routing coverage</a> and <a href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/truck-routing.html">HERE truck routing coverage</a>.</p> </li>
    /// </ul>
    /// <p>For additional information , see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data providers</a> on the <i>Amazon Location Service Developer Guide</i>.</p>
    pub fn data_source(&self) -> std::option::Option<&str> {
        self.data_source.as_deref()
    }
    /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    pub fn pricing_plan(&self) -> std::option::Option<&crate::model::PricingPlan> {
        self.pricing_plan.as_ref()
    }
    /// <p>The optional description for the route calculator resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Applies one or more tags to the route calculator resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
    /// <ul>
    /// <li> <p>For example: { <code>"tag1" : "value1"</code>, <code>"tag2" : "value2"</code>}</p> </li>
    /// </ul>
    /// <p>Format: <code>"key" : "value"</code> </p>
    /// <p>Restrictions:</p>
    /// <ul>
    /// <li> <p>Maximum 50 tags per resource</p> </li>
    /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
    /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
    /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
    /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
    /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
    /// </ul>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateRouteCalculatorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRouteCalculatorInput");
        formatter.field("calculator_name", &self.calculator_name);
        formatter.field("data_source", &self.data_source);
        formatter.field("pricing_plan", &self.pricing_plan);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRouteCalculatorInput {
    /// <p>The name of the route calculator resource to be deleted.</p>
    pub calculator_name: std::option::Option<std::string::String>,
}
impl DeleteRouteCalculatorInput {
    /// <p>The name of the route calculator resource to be deleted.</p>
    pub fn calculator_name(&self) -> std::option::Option<&str> {
        self.calculator_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteRouteCalculatorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRouteCalculatorInput");
        formatter.field("calculator_name", &self.calculator_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRouteCalculatorInput {
    /// <p>The name of the route calculator resource to update.</p>
    pub calculator_name: std::option::Option<std::string::String>,
    /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    pub pricing_plan: std::option::Option<crate::model::PricingPlan>,
    /// <p>Updates the description for the route calculator resource.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateRouteCalculatorInput {
    /// <p>The name of the route calculator resource to update.</p>
    pub fn calculator_name(&self) -> std::option::Option<&str> {
        self.calculator_name.as_deref()
    }
    /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    pub fn pricing_plan(&self) -> std::option::Option<&crate::model::PricingPlan> {
        self.pricing_plan.as_ref()
    }
    /// <p>Updates the description for the route calculator resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateRouteCalculatorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRouteCalculatorInput");
        formatter.field("calculator_name", &self.calculator_name);
        formatter.field("pricing_plan", &self.pricing_plan);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRouteCalculatorInput {
    /// <p>The name of the route calculator resource.</p>
    pub calculator_name: std::option::Option<std::string::String>,
}
impl DescribeRouteCalculatorInput {
    /// <p>The name of the route calculator resource.</p>
    pub fn calculator_name(&self) -> std::option::Option<&str> {
        self.calculator_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeRouteCalculatorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRouteCalculatorInput");
        formatter.field("calculator_name", &self.calculator_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchPlaceIndexForTextInput {
    /// <p>The name of the place index resource you want to use for the search.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The address, name, city, or region to be used in the search in free-form text format. For example, <code>123 Any Street</code>.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>An optional parameter that indicates a preference for places that are closer to a specified position.</p>
    /// <p> If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
    /// <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p> <note>
    /// <p> <code>BiasPosition</code> and <code>FilterBBox</code> are mutually exclusive. Specifying both options results in an error. </p>
    /// </note>
    pub bias_position: std::option::Option<std::vec::Vec<f64>>,
    /// <p>An optional parameter that limits the search results by returning only places that are within the provided bounding box.</p>
    /// <p> If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest corner of the bounding box; the second pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the northeast corner of the bounding box.</p>
    /// <p>For example, <code>[-12.7935, -37.4835, -12.0684, -36.9542]</code> represents a bounding box where the southwest corner has longitude <code>-12.7935</code> and latitude <code>-37.4835</code>, and the northeast corner has longitude <code>-12.0684</code> and latitude <code>-36.9542</code>.</p> <note>
    /// <p> <code>FilterBBox</code> and <code>BiasPosition</code> are mutually exclusive. Specifying both options results in an error. </p>
    /// </note>
    pub filter_b_box: std::option::Option<std::vec::Vec<f64>>,
    /// <p>An optional parameter that limits the search results by returning only places that are in a specified list of countries.</p>
    /// <ul>
    /// <li> <p>Valid values include <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country codes. For example, Australia uses three upper-case characters: <code>AUS</code>.</p> </li>
    /// </ul>
    pub filter_countries: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An optional parameter. The maximum number of results returned per request. </p>
    /// <p>The default: <code>50</code> </p>
    pub max_results: i32,
    /// <p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
    /// <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p>
    pub language: std::option::Option<std::string::String>,
}
impl SearchPlaceIndexForTextInput {
    /// <p>The name of the place index resource you want to use for the search.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The address, name, city, or region to be used in the search in free-form text format. For example, <code>123 Any Street</code>.</p>
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
    /// <p>An optional parameter that indicates a preference for places that are closer to a specified position.</p>
    /// <p> If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
    /// <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p> <note>
    /// <p> <code>BiasPosition</code> and <code>FilterBBox</code> are mutually exclusive. Specifying both options results in an error. </p>
    /// </note>
    pub fn bias_position(&self) -> std::option::Option<&[f64]> {
        self.bias_position.as_deref()
    }
    /// <p>An optional parameter that limits the search results by returning only places that are within the provided bounding box.</p>
    /// <p> If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest corner of the bounding box; the second pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the northeast corner of the bounding box.</p>
    /// <p>For example, <code>[-12.7935, -37.4835, -12.0684, -36.9542]</code> represents a bounding box where the southwest corner has longitude <code>-12.7935</code> and latitude <code>-37.4835</code>, and the northeast corner has longitude <code>-12.0684</code> and latitude <code>-36.9542</code>.</p> <note>
    /// <p> <code>FilterBBox</code> and <code>BiasPosition</code> are mutually exclusive. Specifying both options results in an error. </p>
    /// </note>
    pub fn filter_b_box(&self) -> std::option::Option<&[f64]> {
        self.filter_b_box.as_deref()
    }
    /// <p>An optional parameter that limits the search results by returning only places that are in a specified list of countries.</p>
    /// <ul>
    /// <li> <p>Valid values include <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country codes. For example, Australia uses three upper-case characters: <code>AUS</code>.</p> </li>
    /// </ul>
    pub fn filter_countries(&self) -> std::option::Option<&[std::string::String]> {
        self.filter_countries.as_deref()
    }
    /// <p>An optional parameter. The maximum number of results returned per request. </p>
    /// <p>The default: <code>50</code> </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
    /// <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p>
    pub fn language(&self) -> std::option::Option<&str> {
        self.language.as_deref()
    }
}
impl std::fmt::Debug for SearchPlaceIndexForTextInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchPlaceIndexForTextInput");
        formatter.field("index_name", &self.index_name);
        formatter.field("text", &"*** Sensitive Data Redacted ***");
        formatter.field("bias_position", &"*** Sensitive Data Redacted ***");
        formatter.field("filter_b_box", &"*** Sensitive Data Redacted ***");
        formatter.field("filter_countries", &self.filter_countries);
        formatter.field("max_results", &self.max_results);
        formatter.field("language", &self.language);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchPlaceIndexForSuggestionsInput {
    /// <p>The name of the place index resource you want to use for the search.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The free-form partial text to use to generate place suggestions. For example, <code>eiffel tow</code>.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>An optional parameter that indicates a preference for place suggestions that are closer to a specified position.</p>
    /// <p> If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
    /// <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p> <note>
    /// <p> <code>BiasPosition</code> and <code>FilterBBox</code> are mutually exclusive. Specifying both options results in an error. </p>
    /// </note>
    pub bias_position: std::option::Option<std::vec::Vec<f64>>,
    /// <p>An optional parameter that limits the search results by returning only suggestions within a specified bounding box.</p>
    /// <p> If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest corner of the bounding box; the second pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the northeast corner of the bounding box.</p>
    /// <p>For example, <code>[-12.7935, -37.4835, -12.0684, -36.9542]</code> represents a bounding box where the southwest corner has longitude <code>-12.7935</code> and latitude <code>-37.4835</code>, and the northeast corner has longitude <code>-12.0684</code> and latitude <code>-36.9542</code>.</p> <note>
    /// <p> <code>FilterBBox</code> and <code>BiasPosition</code> are mutually exclusive. Specifying both options results in an error. </p>
    /// </note>
    pub filter_b_box: std::option::Option<std::vec::Vec<f64>>,
    /// <p>An optional parameter that limits the search results by returning only suggestions within the provided list of countries.</p>
    /// <ul>
    /// <li> <p>Use the <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country code. For example, Australia uses three upper-case characters: <code>AUS</code>.</p> </li>
    /// </ul>
    pub filter_countries: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An optional parameter. The maximum number of results returned per request. </p>
    /// <p>The default: <code>5</code> </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
    /// <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p>
    /// <p>Used only when the partner selected is Here.</p>
    pub language: std::option::Option<std::string::String>,
}
impl SearchPlaceIndexForSuggestionsInput {
    /// <p>The name of the place index resource you want to use for the search.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The free-form partial text to use to generate place suggestions. For example, <code>eiffel tow</code>.</p>
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
    /// <p>An optional parameter that indicates a preference for place suggestions that are closer to a specified position.</p>
    /// <p> If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
    /// <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p> <note>
    /// <p> <code>BiasPosition</code> and <code>FilterBBox</code> are mutually exclusive. Specifying both options results in an error. </p>
    /// </note>
    pub fn bias_position(&self) -> std::option::Option<&[f64]> {
        self.bias_position.as_deref()
    }
    /// <p>An optional parameter that limits the search results by returning only suggestions within a specified bounding box.</p>
    /// <p> If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest corner of the bounding box; the second pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the northeast corner of the bounding box.</p>
    /// <p>For example, <code>[-12.7935, -37.4835, -12.0684, -36.9542]</code> represents a bounding box where the southwest corner has longitude <code>-12.7935</code> and latitude <code>-37.4835</code>, and the northeast corner has longitude <code>-12.0684</code> and latitude <code>-36.9542</code>.</p> <note>
    /// <p> <code>FilterBBox</code> and <code>BiasPosition</code> are mutually exclusive. Specifying both options results in an error. </p>
    /// </note>
    pub fn filter_b_box(&self) -> std::option::Option<&[f64]> {
        self.filter_b_box.as_deref()
    }
    /// <p>An optional parameter that limits the search results by returning only suggestions within the provided list of countries.</p>
    /// <ul>
    /// <li> <p>Use the <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country code. For example, Australia uses three upper-case characters: <code>AUS</code>.</p> </li>
    /// </ul>
    pub fn filter_countries(&self) -> std::option::Option<&[std::string::String]> {
        self.filter_countries.as_deref()
    }
    /// <p>An optional parameter. The maximum number of results returned per request. </p>
    /// <p>The default: <code>5</code> </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
    /// <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p>
    /// <p>Used only when the partner selected is Here.</p>
    pub fn language(&self) -> std::option::Option<&str> {
        self.language.as_deref()
    }
}
impl std::fmt::Debug for SearchPlaceIndexForSuggestionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchPlaceIndexForSuggestionsInput");
        formatter.field("index_name", &self.index_name);
        formatter.field("text", &"*** Sensitive Data Redacted ***");
        formatter.field("bias_position", &"*** Sensitive Data Redacted ***");
        formatter.field("filter_b_box", &"*** Sensitive Data Redacted ***");
        formatter.field("filter_countries", &self.filter_countries);
        formatter.field("max_results", &self.max_results);
        formatter.field("language", &self.language);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchPlaceIndexForPositionInput {
    /// <p>The name of the place index resource you want to use for the search.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>Specifies the longitude and latitude of the position to query.</p>
    /// <p> This parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
    /// <p>For example, <code>[-123.1174, 49.2847]</code> represents a position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p>
    pub position: std::option::Option<std::vec::Vec<f64>>,
    /// <p>An optional parameter. The maximum number of results returned per request.</p>
    /// <p>Default value: <code>50</code> </p>
    pub max_results: i32,
    /// <p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
    /// <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p>
    pub language: std::option::Option<std::string::String>,
}
impl SearchPlaceIndexForPositionInput {
    /// <p>The name of the place index resource you want to use for the search.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>Specifies the longitude and latitude of the position to query.</p>
    /// <p> This parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
    /// <p>For example, <code>[-123.1174, 49.2847]</code> represents a position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p>
    pub fn position(&self) -> std::option::Option<&[f64]> {
        self.position.as_deref()
    }
    /// <p>An optional parameter. The maximum number of results returned per request.</p>
    /// <p>Default value: <code>50</code> </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The preferred language used to return results. The value must be a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
    /// <p>This setting affects the languages used in the results. It does not change which results are returned. If the language is not specified, or not supported for a particular result, the partner automatically chooses a language for the result.</p>
    pub fn language(&self) -> std::option::Option<&str> {
        self.language.as_deref()
    }
}
impl std::fmt::Debug for SearchPlaceIndexForPositionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchPlaceIndexForPositionInput");
        formatter.field("index_name", &self.index_name);
        formatter.field("position", &"*** Sensitive Data Redacted ***");
        formatter.field("max_results", &self.max_results);
        formatter.field("language", &self.language);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPlaceIndexesInput {
    /// <p>An optional limit for the maximum number of results returned in a single call.</p>
    /// <p>Default value: <code>100</code> </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
    /// <p>Default value: <code>null</code> </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPlaceIndexesInput {
    /// <p>An optional limit for the maximum number of results returned in a single call.</p>
    /// <p>Default value: <code>100</code> </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
    /// <p>Default value: <code>null</code> </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPlaceIndexesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPlaceIndexesInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePlaceIndexInput {
    /// <p>The name of the place index resource. </p>
    /// <p>Requirements:</p>
    /// <ul>
    /// <li> <p>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).</p> </li>
    /// <li> <p>Must be a unique place index resource name.</p> </li>
    /// <li> <p>No spaces allowed. For example, <code>ExamplePlaceIndex</code>.</p> </li>
    /// </ul>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>Specifies the geospatial data provider for the new place index.</p> <note>
    /// <p>This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> returns an error.</p>
    /// </note>
    /// <p>Valid values include:</p>
    /// <ul>
    /// <li> <p> <code>Esri</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>'s coverage in your region of interest, see <a href="https://developers.arcgis.com/rest/geocode/api-reference/geocode-coverage.htm">Esri details on geocoding coverage</a>.</p> </li>
    /// <li> <p> <code>Here</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a>' coverage in your region of interest, see <a href="https://developer.here.com/documentation/geocoder/dev_guide/topics/coverage-geocoder.html">HERE details on goecoding coverage</a>.</p> <important>
    /// <p>If you specify HERE Technologies (<code>Here</code>) as the data provider, you may not <a href="https://docs.aws.amazon.com/location-places/latest/APIReference/API_DataSourceConfiguration.html">store results</a> for locations in Japan. For more information, see the <a href="https://aws.amazon.com/service-terms/">AWS Service Terms</a> for Amazon Location Service.</p>
    /// </important> </li>
    /// </ul>
    /// <p>For additional information , see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data providers</a> on the <i>Amazon Location Service Developer Guide</i>.</p>
    pub data_source: std::option::Option<std::string::String>,
    /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    pub pricing_plan: std::option::Option<crate::model::PricingPlan>,
    /// <p>The optional description for the place index resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies the data storage option requesting Places.</p>
    pub data_source_configuration: std::option::Option<crate::model::DataSourceConfiguration>,
    /// <p>Applies one or more tags to the place index resource. A tag is a key-value pair that helps you manage, identify, search, and filter your resources.</p>
    /// <p>Format: <code>"key" : "value"</code> </p>
    /// <p>Restrictions:</p>
    /// <ul>
    /// <li> <p>Maximum 50 tags per resource.</p> </li>
    /// <li> <p>Each tag key must be unique and must have exactly one associated value.</p> </li>
    /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8.</p> </li>
    /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8.</p> </li>
    /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @</p> </li>
    /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
    /// </ul>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreatePlaceIndexInput {
    /// <p>The name of the place index resource. </p>
    /// <p>Requirements:</p>
    /// <ul>
    /// <li> <p>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).</p> </li>
    /// <li> <p>Must be a unique place index resource name.</p> </li>
    /// <li> <p>No spaces allowed. For example, <code>ExamplePlaceIndex</code>.</p> </li>
    /// </ul>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>Specifies the geospatial data provider for the new place index.</p> <note>
    /// <p>This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> returns an error.</p>
    /// </note>
    /// <p>Valid values include:</p>
    /// <ul>
    /// <li> <p> <code>Esri</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>'s coverage in your region of interest, see <a href="https://developers.arcgis.com/rest/geocode/api-reference/geocode-coverage.htm">Esri details on geocoding coverage</a>.</p> </li>
    /// <li> <p> <code>Here</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a>' coverage in your region of interest, see <a href="https://developer.here.com/documentation/geocoder/dev_guide/topics/coverage-geocoder.html">HERE details on goecoding coverage</a>.</p> <important>
    /// <p>If you specify HERE Technologies (<code>Here</code>) as the data provider, you may not <a href="https://docs.aws.amazon.com/location-places/latest/APIReference/API_DataSourceConfiguration.html">store results</a> for locations in Japan. For more information, see the <a href="https://aws.amazon.com/service-terms/">AWS Service Terms</a> for Amazon Location Service.</p>
    /// </important> </li>
    /// </ul>
    /// <p>For additional information , see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data providers</a> on the <i>Amazon Location Service Developer Guide</i>.</p>
    pub fn data_source(&self) -> std::option::Option<&str> {
        self.data_source.as_deref()
    }
    /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    pub fn pricing_plan(&self) -> std::option::Option<&crate::model::PricingPlan> {
        self.pricing_plan.as_ref()
    }
    /// <p>The optional description for the place index resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies the data storage option requesting Places.</p>
    pub fn data_source_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DataSourceConfiguration> {
        self.data_source_configuration.as_ref()
    }
    /// <p>Applies one or more tags to the place index resource. A tag is a key-value pair that helps you manage, identify, search, and filter your resources.</p>
    /// <p>Format: <code>"key" : "value"</code> </p>
    /// <p>Restrictions:</p>
    /// <ul>
    /// <li> <p>Maximum 50 tags per resource.</p> </li>
    /// <li> <p>Each tag key must be unique and must have exactly one associated value.</p> </li>
    /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8.</p> </li>
    /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8.</p> </li>
    /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @</p> </li>
    /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
    /// </ul>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreatePlaceIndexInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePlaceIndexInput");
        formatter.field("index_name", &self.index_name);
        formatter.field("data_source", &self.data_source);
        formatter.field("pricing_plan", &self.pricing_plan);
        formatter.field("description", &self.description);
        formatter.field("data_source_configuration", &self.data_source_configuration);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePlaceIndexInput {
    /// <p>The name of the place index resource to be deleted.</p>
    pub index_name: std::option::Option<std::string::String>,
}
impl DeletePlaceIndexInput {
    /// <p>The name of the place index resource to be deleted.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
}
impl std::fmt::Debug for DeletePlaceIndexInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePlaceIndexInput");
        formatter.field("index_name", &self.index_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePlaceIndexInput {
    /// <p>The name of the place index resource to update.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    pub pricing_plan: std::option::Option<crate::model::PricingPlan>,
    /// <p>Updates the description for the place index resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Updates the data storage option for the place index resource.</p>
    pub data_source_configuration: std::option::Option<crate::model::DataSourceConfiguration>,
}
impl UpdatePlaceIndexInput {
    /// <p>The name of the place index resource to update.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    pub fn pricing_plan(&self) -> std::option::Option<&crate::model::PricingPlan> {
        self.pricing_plan.as_ref()
    }
    /// <p>Updates the description for the place index resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Updates the data storage option for the place index resource.</p>
    pub fn data_source_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DataSourceConfiguration> {
        self.data_source_configuration.as_ref()
    }
}
impl std::fmt::Debug for UpdatePlaceIndexInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePlaceIndexInput");
        formatter.field("index_name", &self.index_name);
        formatter.field("pricing_plan", &self.pricing_plan);
        formatter.field("description", &self.description);
        formatter.field("data_source_configuration", &self.data_source_configuration);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePlaceIndexInput {
    /// <p>The name of the place index resource.</p>
    pub index_name: std::option::Option<std::string::String>,
}
impl DescribePlaceIndexInput {
    /// <p>The name of the place index resource.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
}
impl std::fmt::Debug for DescribePlaceIndexInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePlaceIndexInput");
        formatter.field("index_name", &self.index_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMapTileInput {
    /// <p>The map resource to retrieve the map tiles from.</p>
    pub map_name: std::option::Option<std::string::String>,
    /// <p>The zoom value for the map tile.</p>
    pub z: std::option::Option<std::string::String>,
    /// <p>The X axis value for the map tile.</p>
    pub x: std::option::Option<std::string::String>,
    /// <p>The Y axis value for the map tile. </p>
    pub y: std::option::Option<std::string::String>,
}
impl GetMapTileInput {
    /// <p>The map resource to retrieve the map tiles from.</p>
    pub fn map_name(&self) -> std::option::Option<&str> {
        self.map_name.as_deref()
    }
    /// <p>The zoom value for the map tile.</p>
    pub fn z(&self) -> std::option::Option<&str> {
        self.z.as_deref()
    }
    /// <p>The X axis value for the map tile.</p>
    pub fn x(&self) -> std::option::Option<&str> {
        self.x.as_deref()
    }
    /// <p>The Y axis value for the map tile. </p>
    pub fn y(&self) -> std::option::Option<&str> {
        self.y.as_deref()
    }
}
impl std::fmt::Debug for GetMapTileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMapTileInput");
        formatter.field("map_name", &self.map_name);
        formatter.field("z", &self.z);
        formatter.field("x", &self.x);
        formatter.field("y", &self.y);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMapStyleDescriptorInput {
    /// <p>The map resource to retrieve the style descriptor from.</p>
    pub map_name: std::option::Option<std::string::String>,
}
impl GetMapStyleDescriptorInput {
    /// <p>The map resource to retrieve the style descriptor from.</p>
    pub fn map_name(&self) -> std::option::Option<&str> {
        self.map_name.as_deref()
    }
}
impl std::fmt::Debug for GetMapStyleDescriptorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMapStyleDescriptorInput");
        formatter.field("map_name", &self.map_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMapSpritesInput {
    /// <p>The map resource associated with the sprite ﬁle.</p>
    pub map_name: std::option::Option<std::string::String>,
    /// <p>The name of the sprite ﬁle. Use the following ﬁle names for the sprite sheet:</p>
    /// <ul>
    /// <li> <p> <code>sprites.png</code> </p> </li>
    /// <li> <p> <code>sprites@2x.png</code> for high pixel density displays</p> </li>
    /// </ul>
    /// <p>For the JSON document contain image offsets. Use the following ﬁle names:</p>
    /// <ul>
    /// <li> <p> <code>sprites.json</code> </p> </li>
    /// <li> <p> <code>sprites@2x.json</code> for high pixel density displays</p> </li>
    /// </ul>
    pub file_name: std::option::Option<std::string::String>,
}
impl GetMapSpritesInput {
    /// <p>The map resource associated with the sprite ﬁle.</p>
    pub fn map_name(&self) -> std::option::Option<&str> {
        self.map_name.as_deref()
    }
    /// <p>The name of the sprite ﬁle. Use the following ﬁle names for the sprite sheet:</p>
    /// <ul>
    /// <li> <p> <code>sprites.png</code> </p> </li>
    /// <li> <p> <code>sprites@2x.png</code> for high pixel density displays</p> </li>
    /// </ul>
    /// <p>For the JSON document contain image offsets. Use the following ﬁle names:</p>
    /// <ul>
    /// <li> <p> <code>sprites.json</code> </p> </li>
    /// <li> <p> <code>sprites@2x.json</code> for high pixel density displays</p> </li>
    /// </ul>
    pub fn file_name(&self) -> std::option::Option<&str> {
        self.file_name.as_deref()
    }
}
impl std::fmt::Debug for GetMapSpritesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMapSpritesInput");
        formatter.field("map_name", &self.map_name);
        formatter.field("file_name", &self.file_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMapGlyphsInput {
    /// <p>The map resource associated with the glyph ﬁle.</p>
    pub map_name: std::option::Option<std::string::String>,
    /// <p>A comma-separated list of fonts to load glyphs from in order of preference. For example, <code>Noto Sans Regular, Arial Unicode</code>.</p>
    /// <p>Valid fonts stacks for <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a> styles: </p>
    /// <ul>
    /// <li> <p>VectorEsriDarkGrayCanvas – <code>Ubuntu Medium Italic</code> | <code>Ubuntu Medium</code> | <code>Ubuntu Italic</code> | <code>Ubuntu Regular</code> | <code>Ubuntu Bold</code> </p> </li>
    /// <li> <p>VectorEsriLightGrayCanvas – <code>Ubuntu Italic</code> | <code>Ubuntu Regular</code> | <code>Ubuntu Light</code> | <code>Ubuntu Bold</code> </p> </li>
    /// <li> <p>VectorEsriTopographic – <code>Noto Sans Italic</code> | <code>Noto Sans Regular</code> | <code>Noto Sans Bold</code> | <code>Noto Serif Regular</code> | <code>Roboto Condensed Light Italic</code> </p> </li>
    /// <li> <p>VectorEsriStreets – <code>Arial Regular</code> | <code>Arial Italic</code> | <code>Arial Bold</code> </p> </li>
    /// <li> <p>VectorEsriNavigation – <code>Arial Regular</code> | <code>Arial Italic</code> | <code>Arial Bold</code> </p> </li>
    /// </ul>
    /// <p>Valid font stacks for <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a> styles: </p>
    /// <ul>
    /// <li> <p>VectorHereBerlin – <code>Fira GO Regular</code> | <code>Fira GO Bold</code> </p> </li>
    /// </ul>
    pub font_stack: std::option::Option<std::string::String>,
    /// <p>A Unicode range of characters to download glyphs for. Each response will contain 256 characters. For example, 0–255 includes all characters from range <code>U+0000</code> to <code>00FF</code>. Must be aligned to multiples of 256.</p>
    pub font_unicode_range: std::option::Option<std::string::String>,
}
impl GetMapGlyphsInput {
    /// <p>The map resource associated with the glyph ﬁle.</p>
    pub fn map_name(&self) -> std::option::Option<&str> {
        self.map_name.as_deref()
    }
    /// <p>A comma-separated list of fonts to load glyphs from in order of preference. For example, <code>Noto Sans Regular, Arial Unicode</code>.</p>
    /// <p>Valid fonts stacks for <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a> styles: </p>
    /// <ul>
    /// <li> <p>VectorEsriDarkGrayCanvas – <code>Ubuntu Medium Italic</code> | <code>Ubuntu Medium</code> | <code>Ubuntu Italic</code> | <code>Ubuntu Regular</code> | <code>Ubuntu Bold</code> </p> </li>
    /// <li> <p>VectorEsriLightGrayCanvas – <code>Ubuntu Italic</code> | <code>Ubuntu Regular</code> | <code>Ubuntu Light</code> | <code>Ubuntu Bold</code> </p> </li>
    /// <li> <p>VectorEsriTopographic – <code>Noto Sans Italic</code> | <code>Noto Sans Regular</code> | <code>Noto Sans Bold</code> | <code>Noto Serif Regular</code> | <code>Roboto Condensed Light Italic</code> </p> </li>
    /// <li> <p>VectorEsriStreets – <code>Arial Regular</code> | <code>Arial Italic</code> | <code>Arial Bold</code> </p> </li>
    /// <li> <p>VectorEsriNavigation – <code>Arial Regular</code> | <code>Arial Italic</code> | <code>Arial Bold</code> </p> </li>
    /// </ul>
    /// <p>Valid font stacks for <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a> styles: </p>
    /// <ul>
    /// <li> <p>VectorHereBerlin – <code>Fira GO Regular</code> | <code>Fira GO Bold</code> </p> </li>
    /// </ul>
    pub fn font_stack(&self) -> std::option::Option<&str> {
        self.font_stack.as_deref()
    }
    /// <p>A Unicode range of characters to download glyphs for. Each response will contain 256 characters. For example, 0–255 includes all characters from range <code>U+0000</code> to <code>00FF</code>. Must be aligned to multiples of 256.</p>
    pub fn font_unicode_range(&self) -> std::option::Option<&str> {
        self.font_unicode_range.as_deref()
    }
}
impl std::fmt::Debug for GetMapGlyphsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMapGlyphsInput");
        formatter.field("map_name", &self.map_name);
        formatter.field("font_stack", &self.font_stack);
        formatter.field("font_unicode_range", &self.font_unicode_range);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMapsInput {
    /// <p>An optional limit for the number of resources returned in a single call. </p>
    /// <p>Default value: <code>100</code> </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
    /// <p>Default value: <code>null</code> </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListMapsInput {
    /// <p>An optional limit for the number of resources returned in a single call. </p>
    /// <p>Default value: <code>100</code> </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page.</p>
    /// <p>Default value: <code>null</code> </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListMapsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMapsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMapInput {
    /// <p>The name for the map resource.</p>
    /// <p>Requirements:</p>
    /// <ul>
    /// <li> <p>Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_). </p> </li>
    /// <li> <p>Must be a unique map resource name. </p> </li>
    /// <li> <p>No spaces allowed. For example, <code>ExampleMap</code>.</p> </li>
    /// </ul>
    pub map_name: std::option::Option<std::string::String>,
    /// <p>Specifies the map style selected from an available data provider.</p>
    pub configuration: std::option::Option<crate::model::MapConfiguration>,
    /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    pub pricing_plan: std::option::Option<crate::model::PricingPlan>,
    /// <p>An optional description for the map resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Applies one or more tags to the map resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
    /// <p>Format: <code>"key" : "value"</code> </p>
    /// <p>Restrictions:</p>
    /// <ul>
    /// <li> <p>Maximum 50 tags per resource</p> </li>
    /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
    /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
    /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
    /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
    /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
    /// </ul>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateMapInput {
    /// <p>The name for the map resource.</p>
    /// <p>Requirements:</p>
    /// <ul>
    /// <li> <p>Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_). </p> </li>
    /// <li> <p>Must be a unique map resource name. </p> </li>
    /// <li> <p>No spaces allowed. For example, <code>ExampleMap</code>.</p> </li>
    /// </ul>
    pub fn map_name(&self) -> std::option::Option<&str> {
        self.map_name.as_deref()
    }
    /// <p>Specifies the map style selected from an available data provider.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::MapConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    pub fn pricing_plan(&self) -> std::option::Option<&crate::model::PricingPlan> {
        self.pricing_plan.as_ref()
    }
    /// <p>An optional description for the map resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Applies one or more tags to the map resource. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
    /// <p>Format: <code>"key" : "value"</code> </p>
    /// <p>Restrictions:</p>
    /// <ul>
    /// <li> <p>Maximum 50 tags per resource</p> </li>
    /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
    /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
    /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
    /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
    /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
    /// </ul>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateMapInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMapInput");
        formatter.field("map_name", &self.map_name);
        formatter.field("configuration", &self.configuration);
        formatter.field("pricing_plan", &self.pricing_plan);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMapInput {
    /// <p>The name of the map resource to be deleted.</p>
    pub map_name: std::option::Option<std::string::String>,
}
impl DeleteMapInput {
    /// <p>The name of the map resource to be deleted.</p>
    pub fn map_name(&self) -> std::option::Option<&str> {
        self.map_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteMapInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMapInput");
        formatter.field("map_name", &self.map_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMapInput {
    /// <p>The name of the map resource to update.</p>
    pub map_name: std::option::Option<std::string::String>,
    /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    pub pricing_plan: std::option::Option<crate::model::PricingPlan>,
    /// <p>Updates the description for the map resource.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateMapInput {
    /// <p>The name of the map resource to update.</p>
    pub fn map_name(&self) -> std::option::Option<&str> {
        self.map_name.as_deref()
    }
    /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    pub fn pricing_plan(&self) -> std::option::Option<&crate::model::PricingPlan> {
        self.pricing_plan.as_ref()
    }
    /// <p>Updates the description for the map resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateMapInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMapInput");
        formatter.field("map_name", &self.map_name);
        formatter.field("pricing_plan", &self.pricing_plan);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMapInput {
    /// <p>The name of the map resource.</p>
    pub map_name: std::option::Option<std::string::String>,
}
impl DescribeMapInput {
    /// <p>The name of the map resource.</p>
    pub fn map_name(&self) -> std::option::Option<&str> {
        self.map_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeMapInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMapInput");
        formatter.field("map_name", &self.map_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutGeofenceInput {
    /// <p>The geofence collection to store the geofence in.</p>
    pub collection_name: std::option::Option<std::string::String>,
    /// <p>An identifier for the geofence. For example, <code>ExampleGeofence-1</code>.</p>
    pub geofence_id: std::option::Option<std::string::String>,
    /// <p>Contains the polygon details to specify the position of the geofence.</p> <note>
    /// <p>Each <a href="https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html">geofence polygon</a> can have a maximum of 1,000 vertices.</p>
    /// </note>
    pub geometry: std::option::Option<crate::model::GeofenceGeometry>,
}
impl PutGeofenceInput {
    /// <p>The geofence collection to store the geofence in.</p>
    pub fn collection_name(&self) -> std::option::Option<&str> {
        self.collection_name.as_deref()
    }
    /// <p>An identifier for the geofence. For example, <code>ExampleGeofence-1</code>.</p>
    pub fn geofence_id(&self) -> std::option::Option<&str> {
        self.geofence_id.as_deref()
    }
    /// <p>Contains the polygon details to specify the position of the geofence.</p> <note>
    /// <p>Each <a href="https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html">geofence polygon</a> can have a maximum of 1,000 vertices.</p>
    /// </note>
    pub fn geometry(&self) -> std::option::Option<&crate::model::GeofenceGeometry> {
        self.geometry.as_ref()
    }
}
impl std::fmt::Debug for PutGeofenceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutGeofenceInput");
        formatter.field("collection_name", &self.collection_name);
        formatter.field("geofence_id", &self.geofence_id);
        formatter.field("geometry", &self.geometry);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGeofencesInput {
    /// <p>The name of the geofence collection storing the list of geofences.</p>
    pub collection_name: std::option::Option<std::string::String>,
    /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
    /// <p>Default value: <code>null</code> </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListGeofencesInput {
    /// <p>The name of the geofence collection storing the list of geofences.</p>
    pub fn collection_name(&self) -> std::option::Option<&str> {
        self.collection_name.as_deref()
    }
    /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
    /// <p>Default value: <code>null</code> </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListGeofencesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGeofencesInput");
        formatter.field("collection_name", &self.collection_name);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGeofenceInput {
    /// <p>The geofence collection storing the target geofence.</p>
    pub collection_name: std::option::Option<std::string::String>,
    /// <p>The geofence you're retrieving details for.</p>
    pub geofence_id: std::option::Option<std::string::String>,
}
impl GetGeofenceInput {
    /// <p>The geofence collection storing the target geofence.</p>
    pub fn collection_name(&self) -> std::option::Option<&str> {
        self.collection_name.as_deref()
    }
    /// <p>The geofence you're retrieving details for.</p>
    pub fn geofence_id(&self) -> std::option::Option<&str> {
        self.geofence_id.as_deref()
    }
}
impl std::fmt::Debug for GetGeofenceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGeofenceInput");
        formatter.field("collection_name", &self.collection_name);
        formatter.field("geofence_id", &self.geofence_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchPutGeofenceInput {
    /// <p>The geofence collection storing the geofences.</p>
    pub collection_name: std::option::Option<std::string::String>,
    /// <p>The batch of geofences to be stored in a geofence collection.</p>
    pub entries: std::option::Option<std::vec::Vec<crate::model::BatchPutGeofenceRequestEntry>>,
}
impl BatchPutGeofenceInput {
    /// <p>The geofence collection storing the geofences.</p>
    pub fn collection_name(&self) -> std::option::Option<&str> {
        self.collection_name.as_deref()
    }
    /// <p>The batch of geofences to be stored in a geofence collection.</p>
    pub fn entries(&self) -> std::option::Option<&[crate::model::BatchPutGeofenceRequestEntry]> {
        self.entries.as_deref()
    }
}
impl std::fmt::Debug for BatchPutGeofenceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchPutGeofenceInput");
        formatter.field("collection_name", &self.collection_name);
        formatter.field("entries", &self.entries);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchEvaluateGeofencesInput {
    /// <p>The geofence collection used in evaluating the position of devices against its geofences.</p>
    pub collection_name: std::option::Option<std::string::String>,
    /// <p>Contains device details for each device to be evaluated against the given geofence collection.</p>
    pub device_position_updates:
        std::option::Option<std::vec::Vec<crate::model::DevicePositionUpdate>>,
}
impl BatchEvaluateGeofencesInput {
    /// <p>The geofence collection used in evaluating the position of devices against its geofences.</p>
    pub fn collection_name(&self) -> std::option::Option<&str> {
        self.collection_name.as_deref()
    }
    /// <p>Contains device details for each device to be evaluated against the given geofence collection.</p>
    pub fn device_position_updates(
        &self,
    ) -> std::option::Option<&[crate::model::DevicePositionUpdate]> {
        self.device_position_updates.as_deref()
    }
}
impl std::fmt::Debug for BatchEvaluateGeofencesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchEvaluateGeofencesInput");
        formatter.field("collection_name", &self.collection_name);
        formatter.field("device_position_updates", &self.device_position_updates);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteGeofenceInput {
    /// <p>The geofence collection storing the geofences to be deleted.</p>
    pub collection_name: std::option::Option<std::string::String>,
    /// <p>The batch of geofences to be deleted.</p>
    pub geofence_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchDeleteGeofenceInput {
    /// <p>The geofence collection storing the geofences to be deleted.</p>
    pub fn collection_name(&self) -> std::option::Option<&str> {
        self.collection_name.as_deref()
    }
    /// <p>The batch of geofences to be deleted.</p>
    pub fn geofence_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.geofence_ids.as_deref()
    }
}
impl std::fmt::Debug for BatchDeleteGeofenceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteGeofenceInput");
        formatter.field("collection_name", &self.collection_name);
        formatter.field("geofence_ids", &self.geofence_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGeofenceCollectionsInput {
    /// <p>An optional limit for the number of resources returned in a single call. </p>
    /// <p>Default value: <code>100</code> </p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
    /// <p>Default value: <code>null</code> </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListGeofenceCollectionsInput {
    /// <p>An optional limit for the number of resources returned in a single call. </p>
    /// <p>Default value: <code>100</code> </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token specifying which page of results to return in the response. If no token is provided, the default page is the first page. </p>
    /// <p>Default value: <code>null</code> </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListGeofenceCollectionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGeofenceCollectionsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGeofenceCollectionInput {
    /// <p>A custom name for the geofence collection.</p>
    /// <p>Requirements:</p>
    /// <ul>
    /// <li> <p>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_). </p> </li>
    /// <li> <p>Must be a unique geofence collection name.</p> </li>
    /// <li> <p>No spaces allowed. For example, <code>ExampleGeofenceCollection</code>.</p> </li>
    /// </ul>
    pub collection_name: std::option::Option<std::string::String>,
    /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    pub pricing_plan: std::option::Option<crate::model::PricingPlan>,
    /// <p>This parameter is no longer used.</p>
    pub pricing_plan_data_source: std::option::Option<std::string::String>,
    /// <p>An optional description for the geofence collection.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Applies one or more tags to the geofence collection. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
    /// <p>Format: <code>"key" : "value"</code> </p>
    /// <p>Restrictions:</p>
    /// <ul>
    /// <li> <p>Maximum 50 tags per resource</p> </li>
    /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
    /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
    /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
    /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
    /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
    /// </ul>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN. </p>
    pub kms_key_id: std::option::Option<std::string::String>,
}
impl CreateGeofenceCollectionInput {
    /// <p>A custom name for the geofence collection.</p>
    /// <p>Requirements:</p>
    /// <ul>
    /// <li> <p>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_). </p> </li>
    /// <li> <p>Must be a unique geofence collection name.</p> </li>
    /// <li> <p>No spaces allowed. For example, <code>ExampleGeofenceCollection</code>.</p> </li>
    /// </ul>
    pub fn collection_name(&self) -> std::option::Option<&str> {
        self.collection_name.as_deref()
    }
    /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    pub fn pricing_plan(&self) -> std::option::Option<&crate::model::PricingPlan> {
        self.pricing_plan.as_ref()
    }
    /// <p>This parameter is no longer used.</p>
    pub fn pricing_plan_data_source(&self) -> std::option::Option<&str> {
        self.pricing_plan_data_source.as_deref()
    }
    /// <p>An optional description for the geofence collection.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Applies one or more tags to the geofence collection. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.</p>
    /// <p>Format: <code>"key" : "value"</code> </p>
    /// <p>Restrictions:</p>
    /// <ul>
    /// <li> <p>Maximum 50 tags per resource</p> </li>
    /// <li> <p>Each resource tag must be unique with a maximum of one value.</p> </li>
    /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8</p> </li>
    /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8</p> </li>
    /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @. </p> </li>
    /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
    /// </ul>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN. </p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
}
impl std::fmt::Debug for CreateGeofenceCollectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGeofenceCollectionInput");
        formatter.field("collection_name", &self.collection_name);
        formatter.field("pricing_plan", &self.pricing_plan);
        formatter.field("pricing_plan_data_source", &self.pricing_plan_data_source);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGeofenceCollectionInput {
    /// <p>The name of the geofence collection to be deleted.</p>
    pub collection_name: std::option::Option<std::string::String>,
}
impl DeleteGeofenceCollectionInput {
    /// <p>The name of the geofence collection to be deleted.</p>
    pub fn collection_name(&self) -> std::option::Option<&str> {
        self.collection_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteGeofenceCollectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGeofenceCollectionInput");
        formatter.field("collection_name", &self.collection_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGeofenceCollectionInput {
    /// <p>The name of the geofence collection to update.</p>
    pub collection_name: std::option::Option<std::string::String>,
    /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    pub pricing_plan: std::option::Option<crate::model::PricingPlan>,
    /// <p>This parameter is no longer used.</p>
    pub pricing_plan_data_source: std::option::Option<std::string::String>,
    /// <p>Updates the description for the geofence collection.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateGeofenceCollectionInput {
    /// <p>The name of the geofence collection to update.</p>
    pub fn collection_name(&self) -> std::option::Option<&str> {
        self.collection_name.as_deref()
    }
    /// <p>No longer used. If included, the only allowed value is <code>RequestBasedUsage</code>.</p>
    pub fn pricing_plan(&self) -> std::option::Option<&crate::model::PricingPlan> {
        self.pricing_plan.as_ref()
    }
    /// <p>This parameter is no longer used.</p>
    pub fn pricing_plan_data_source(&self) -> std::option::Option<&str> {
        self.pricing_plan_data_source.as_deref()
    }
    /// <p>Updates the description for the geofence collection.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateGeofenceCollectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGeofenceCollectionInput");
        formatter.field("collection_name", &self.collection_name);
        formatter.field("pricing_plan", &self.pricing_plan);
        formatter.field("pricing_plan_data_source", &self.pricing_plan_data_source);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGeofenceCollectionInput {
    /// <p>The name of the geofence collection.</p>
    pub collection_name: std::option::Option<std::string::String>,
}
impl DescribeGeofenceCollectionInput {
    /// <p>The name of the geofence collection.</p>
    pub fn collection_name(&self) -> std::option::Option<&str> {
        self.collection_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeGeofenceCollectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGeofenceCollectionInput");
        formatter.field("collection_name", &self.collection_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource from which you want to remove tags.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li>
    /// </ul>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The list of tag keys to remove from the specified resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource from which you want to remove tags.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li>
    /// </ul>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The list of tag keys to remove from the specified resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to update.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li>
    /// </ul>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Applies one or more tags to specific resource. A tag is a key-value pair that helps you manage, identify, search, and filter your resources.</p>
    /// <p>Format: <code>"key" : "value"</code> </p>
    /// <p>Restrictions:</p>
    /// <ul>
    /// <li> <p>Maximum 50 tags per resource.</p> </li>
    /// <li> <p>Each tag key must be unique and must have exactly one associated value.</p> </li>
    /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8.</p> </li>
    /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8.</p> </li>
    /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @</p> </li>
    /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
    /// </ul>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to update.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li>
    /// </ul>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Applies one or more tags to specific resource. A tag is a key-value pair that helps you manage, identify, search, and filter your resources.</p>
    /// <p>Format: <code>"key" : "value"</code> </p>
    /// <p>Restrictions:</p>
    /// <ul>
    /// <li> <p>Maximum 50 tags per resource.</p> </li>
    /// <li> <p>Each tag key must be unique and must have exactly one associated value.</p> </li>
    /// <li> <p>Maximum key length: 128 Unicode characters in UTF-8.</p> </li>
    /// <li> <p>Maximum value length: 256 Unicode characters in UTF-8.</p> </li>
    /// <li> <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @</p> </li>
    /// <li> <p>Cannot use "aws:" as a prefix for a key.</p> </li>
    /// </ul>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li>
    /// </ul>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code> </p> </li>
    /// </ul>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
