// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The input failed to meet the constraints specified by the AWS service in a specified field. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationExceptionField {
    /// <p>The field name where the invalid entry was detected.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A message with the reason for the validation exception error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl ValidationExceptionField {
    /// <p>The field name where the invalid entry was detected.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A message with the reason for the validation exception error.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for ValidationExceptionField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationExceptionField");
        formatter.field("name", &self.name);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ValidationExceptionField`](crate::model::ValidationExceptionField)
pub mod validation_exception_field {
    /// A builder for [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The field name where the invalid entry was detected.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The field name where the invalid entry was detected.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A message with the reason for the validation exception error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message with the reason for the validation exception error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationExceptionField`](crate::model::ValidationExceptionField)
        pub fn build(self) -> crate::model::ValidationExceptionField {
            crate::model::ValidationExceptionField {
                name: self.name,
                message: self.message,
            }
        }
    }
}
impl ValidationExceptionField {
    /// Creates a new builder-style object to manufacture [`ValidationExceptionField`](crate::model::ValidationExceptionField)
    pub fn builder() -> crate::model::validation_exception_field::Builder {
        crate::model::validation_exception_field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub struct ValidationExceptionReason(String);
impl ValidationExceptionReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        &self.0
    }
    /// Returns all the `&str` representations of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CannotParse",
            "FieldValidationFailed",
            "Missing",
            "Other",
            "UnknownOperation",
        ]
    }
}
impl<T> std::convert::From<T> for ValidationExceptionReason
where
    T: std::convert::AsRef<str>,
{
    fn from(s: T) -> Self {
        ValidationExceptionReason(s.as_ref().to_owned())
    }
}

/// <p>Contains the tracker resource details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDevicePositionsResponseEntry {
    /// <p>The ID of the device for this position.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The timestamp at which the device position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
    pub sample_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last known device position. Empty if no positions currently stored.</p>
    pub position: std::option::Option<std::vec::Vec<f64>>,
    /// <p>The accuracy of the device position.</p>
    pub accuracy: std::option::Option<crate::model::PositionalAccuracy>,
    /// <p>The properties associated with the position.</p>
    pub position_properties:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListDevicePositionsResponseEntry {
    /// <p>The ID of the device for this position.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>The timestamp at which the device position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
    pub fn sample_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.sample_time.as_ref()
    }
    /// <p>The last known device position. Empty if no positions currently stored.</p>
    pub fn position(&self) -> std::option::Option<&[f64]> {
        self.position.as_deref()
    }
    /// <p>The accuracy of the device position.</p>
    pub fn accuracy(&self) -> std::option::Option<&crate::model::PositionalAccuracy> {
        self.accuracy.as_ref()
    }
    /// <p>The properties associated with the position.</p>
    pub fn position_properties(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.position_properties.as_ref()
    }
}
impl std::fmt::Debug for ListDevicePositionsResponseEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDevicePositionsResponseEntry");
        formatter.field("device_id", &self.device_id);
        formatter.field("sample_time", &self.sample_time);
        formatter.field("position", &"*** Sensitive Data Redacted ***");
        formatter.field("accuracy", &self.accuracy);
        formatter.field("position_properties", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`ListDevicePositionsResponseEntry`](crate::model::ListDevicePositionsResponseEntry)
pub mod list_device_positions_response_entry {
    /// A builder for [`ListDevicePositionsResponseEntry`](crate::model::ListDevicePositionsResponseEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) sample_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) position: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) accuracy: std::option::Option<crate::model::PositionalAccuracy>,
        pub(crate) position_properties: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the device for this position.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The ID of the device for this position.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The timestamp at which the device position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
        pub fn sample_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.sample_time = Some(input);
            self
        }
        /// <p>The timestamp at which the device position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
        pub fn set_sample_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.sample_time = input;
            self
        }
        /// Appends an item to `position`.
        ///
        /// To override the contents of this collection use [`set_position`](Self::set_position).
        ///
        /// <p>The last known device position. Empty if no positions currently stored.</p>
        pub fn position(mut self, input: f64) -> Self {
            let mut v = self.position.unwrap_or_default();
            v.push(input);
            self.position = Some(v);
            self
        }
        /// <p>The last known device position. Empty if no positions currently stored.</p>
        pub fn set_position(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.position = input;
            self
        }
        /// <p>The accuracy of the device position.</p>
        pub fn accuracy(mut self, input: crate::model::PositionalAccuracy) -> Self {
            self.accuracy = Some(input);
            self
        }
        /// <p>The accuracy of the device position.</p>
        pub fn set_accuracy(
            mut self,
            input: std::option::Option<crate::model::PositionalAccuracy>,
        ) -> Self {
            self.accuracy = input;
            self
        }
        /// Adds a key-value pair to `position_properties`.
        ///
        /// To override the contents of this collection use [`set_position_properties`](Self::set_position_properties).
        ///
        /// <p>The properties associated with the position.</p>
        pub fn position_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.position_properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.position_properties = Some(hash_map);
            self
        }
        /// <p>The properties associated with the position.</p>
        pub fn set_position_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.position_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDevicePositionsResponseEntry`](crate::model::ListDevicePositionsResponseEntry)
        pub fn build(self) -> crate::model::ListDevicePositionsResponseEntry {
            crate::model::ListDevicePositionsResponseEntry {
                device_id: self.device_id,
                sample_time: self.sample_time,
                position: self.position,
                accuracy: self.accuracy,
                position_properties: self.position_properties,
            }
        }
    }
}
impl ListDevicePositionsResponseEntry {
    /// Creates a new builder-style object to manufacture [`ListDevicePositionsResponseEntry`](crate::model::ListDevicePositionsResponseEntry)
    pub fn builder() -> crate::model::list_device_positions_response_entry::Builder {
        crate::model::list_device_positions_response_entry::Builder::default()
    }
}

/// <p>Defines the level of certainty of the position.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PositionalAccuracy {
    /// <p>Estimated maximum distance, in meters, between the measured position and the true position of a device, along the Earth's surface.</p>
    pub horizontal: std::option::Option<f64>,
}
impl PositionalAccuracy {
    /// <p>Estimated maximum distance, in meters, between the measured position and the true position of a device, along the Earth's surface.</p>
    pub fn horizontal(&self) -> std::option::Option<f64> {
        self.horizontal
    }
}
impl std::fmt::Debug for PositionalAccuracy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PositionalAccuracy");
        formatter.field("horizontal", &self.horizontal);
        formatter.finish()
    }
}
/// See [`PositionalAccuracy`](crate::model::PositionalAccuracy)
pub mod positional_accuracy {
    /// A builder for [`PositionalAccuracy`](crate::model::PositionalAccuracy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) horizontal: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>Estimated maximum distance, in meters, between the measured position and the true position of a device, along the Earth's surface.</p>
        pub fn horizontal(mut self, input: f64) -> Self {
            self.horizontal = Some(input);
            self
        }
        /// <p>Estimated maximum distance, in meters, between the measured position and the true position of a device, along the Earth's surface.</p>
        pub fn set_horizontal(mut self, input: std::option::Option<f64>) -> Self {
            self.horizontal = input;
            self
        }
        /// Consumes the builder and constructs a [`PositionalAccuracy`](crate::model::PositionalAccuracy)
        pub fn build(self) -> crate::model::PositionalAccuracy {
            crate::model::PositionalAccuracy {
                horizontal: self.horizontal,
            }
        }
    }
}
impl PositionalAccuracy {
    /// Creates a new builder-style object to manufacture [`PositionalAccuracy`](crate::model::PositionalAccuracy)
    pub fn builder() -> crate::model::positional_accuracy::Builder {
        crate::model::positional_accuracy::Builder::default()
    }
}

/// <p>Contains the device position details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DevicePosition {
    /// <p>The device whose position you retrieved.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The timestamp at which the device's position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub sample_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp for when the tracker resource received the device position in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub received_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last known device position.</p>
    pub position: std::option::Option<std::vec::Vec<f64>>,
    /// <p>The accuracy of the device position.</p>
    pub accuracy: std::option::Option<crate::model::PositionalAccuracy>,
    /// <p>The properties associated with the position.</p>
    pub position_properties:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DevicePosition {
    /// <p>The device whose position you retrieved.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>The timestamp at which the device's position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub fn sample_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.sample_time.as_ref()
    }
    /// <p>The timestamp for when the tracker resource received the device position in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub fn received_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.received_time.as_ref()
    }
    /// <p>The last known device position.</p>
    pub fn position(&self) -> std::option::Option<&[f64]> {
        self.position.as_deref()
    }
    /// <p>The accuracy of the device position.</p>
    pub fn accuracy(&self) -> std::option::Option<&crate::model::PositionalAccuracy> {
        self.accuracy.as_ref()
    }
    /// <p>The properties associated with the position.</p>
    pub fn position_properties(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.position_properties.as_ref()
    }
}
impl std::fmt::Debug for DevicePosition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DevicePosition");
        formatter.field("device_id", &self.device_id);
        formatter.field("sample_time", &self.sample_time);
        formatter.field("received_time", &self.received_time);
        formatter.field("position", &"*** Sensitive Data Redacted ***");
        formatter.field("accuracy", &self.accuracy);
        formatter.field("position_properties", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`DevicePosition`](crate::model::DevicePosition)
pub mod device_position {
    /// A builder for [`DevicePosition`](crate::model::DevicePosition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) sample_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) received_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) position: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) accuracy: std::option::Option<crate::model::PositionalAccuracy>,
        pub(crate) position_properties: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The device whose position you retrieved.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The device whose position you retrieved.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The timestamp at which the device's position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn sample_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.sample_time = Some(input);
            self
        }
        /// <p>The timestamp at which the device's position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn set_sample_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.sample_time = input;
            self
        }
        /// <p>The timestamp for when the tracker resource received the device position in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn received_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.received_time = Some(input);
            self
        }
        /// <p>The timestamp for when the tracker resource received the device position in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn set_received_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.received_time = input;
            self
        }
        /// Appends an item to `position`.
        ///
        /// To override the contents of this collection use [`set_position`](Self::set_position).
        ///
        /// <p>The last known device position.</p>
        pub fn position(mut self, input: f64) -> Self {
            let mut v = self.position.unwrap_or_default();
            v.push(input);
            self.position = Some(v);
            self
        }
        /// <p>The last known device position.</p>
        pub fn set_position(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.position = input;
            self
        }
        /// <p>The accuracy of the device position.</p>
        pub fn accuracy(mut self, input: crate::model::PositionalAccuracy) -> Self {
            self.accuracy = Some(input);
            self
        }
        /// <p>The accuracy of the device position.</p>
        pub fn set_accuracy(
            mut self,
            input: std::option::Option<crate::model::PositionalAccuracy>,
        ) -> Self {
            self.accuracy = input;
            self
        }
        /// Adds a key-value pair to `position_properties`.
        ///
        /// To override the contents of this collection use [`set_position_properties`](Self::set_position_properties).
        ///
        /// <p>The properties associated with the position.</p>
        pub fn position_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.position_properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.position_properties = Some(hash_map);
            self
        }
        /// <p>The properties associated with the position.</p>
        pub fn set_position_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.position_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`DevicePosition`](crate::model::DevicePosition)
        pub fn build(self) -> crate::model::DevicePosition {
            crate::model::DevicePosition {
                device_id: self.device_id,
                sample_time: self.sample_time,
                received_time: self.received_time,
                position: self.position,
                accuracy: self.accuracy,
                position_properties: self.position_properties,
            }
        }
    }
}
impl DevicePosition {
    /// Creates a new builder-style object to manufacture [`DevicePosition`](crate::model::DevicePosition)
    pub fn builder() -> crate::model::device_position::Builder {
        crate::model::device_position::Builder::default()
    }
}

/// <p>Contains error details for each device that failed to update its position.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchUpdateDevicePositionError {
    /// <p>The device associated with the failed location update.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The timestamp at which the device position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub sample_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Contains details related to the error code such as the error code and error message.</p>
    pub error: std::option::Option<crate::model::BatchItemError>,
}
impl BatchUpdateDevicePositionError {
    /// <p>The device associated with the failed location update.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>The timestamp at which the device position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub fn sample_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.sample_time.as_ref()
    }
    /// <p>Contains details related to the error code such as the error code and error message.</p>
    pub fn error(&self) -> std::option::Option<&crate::model::BatchItemError> {
        self.error.as_ref()
    }
}
impl std::fmt::Debug for BatchUpdateDevicePositionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchUpdateDevicePositionError");
        formatter.field("device_id", &self.device_id);
        formatter.field("sample_time", &self.sample_time);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`BatchUpdateDevicePositionError`](crate::model::BatchUpdateDevicePositionError)
pub mod batch_update_device_position_error {
    /// A builder for [`BatchUpdateDevicePositionError`](crate::model::BatchUpdateDevicePositionError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) sample_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) error: std::option::Option<crate::model::BatchItemError>,
    }
    impl Builder {
        /// <p>The device associated with the failed location update.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The device associated with the failed location update.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The timestamp at which the device position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn sample_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.sample_time = Some(input);
            self
        }
        /// <p>The timestamp at which the device position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn set_sample_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.sample_time = input;
            self
        }
        /// <p>Contains details related to the error code such as the error code and error message.</p>
        pub fn error(mut self, input: crate::model::BatchItemError) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Contains details related to the error code such as the error code and error message.</p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::BatchItemError>,
        ) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchUpdateDevicePositionError`](crate::model::BatchUpdateDevicePositionError)
        pub fn build(self) -> crate::model::BatchUpdateDevicePositionError {
            crate::model::BatchUpdateDevicePositionError {
                device_id: self.device_id,
                sample_time: self.sample_time,
                error: self.error,
            }
        }
    }
}
impl BatchUpdateDevicePositionError {
    /// Creates a new builder-style object to manufacture [`BatchUpdateDevicePositionError`](crate::model::BatchUpdateDevicePositionError)
    pub fn builder() -> crate::model::batch_update_device_position_error::Builder {
        crate::model::batch_update_device_position_error::Builder::default()
    }
}

/// <p>Contains the batch request error details associated with the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchItemError {
    /// <p>The error code associated with the batch request error.</p>
    pub code: std::option::Option<crate::model::BatchItemErrorCode>,
    /// <p>A message with the reason for the batch request error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl BatchItemError {
    /// <p>The error code associated with the batch request error.</p>
    pub fn code(&self) -> std::option::Option<&crate::model::BatchItemErrorCode> {
        self.code.as_ref()
    }
    /// <p>A message with the reason for the batch request error.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for BatchItemError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchItemError");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`BatchItemError`](crate::model::BatchItemError)
pub mod batch_item_error {
    /// A builder for [`BatchItemError`](crate::model::BatchItemError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::BatchItemErrorCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code associated with the batch request error.</p>
        pub fn code(mut self, input: crate::model::BatchItemErrorCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The error code associated with the batch request error.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::BatchItemErrorCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>A message with the reason for the batch request error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message with the reason for the batch request error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchItemError`](crate::model::BatchItemError)
        pub fn build(self) -> crate::model::BatchItemError {
            crate::model::BatchItemError {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl BatchItemError {
    /// Creates a new builder-style object to manufacture [`BatchItemError`](crate::model::BatchItemError)
    pub fn builder() -> crate::model::batch_item_error::Builder {
        crate::model::batch_item_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub struct BatchItemErrorCode(String);
impl BatchItemErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        &self.0
    }
    /// Returns all the `&str` representations of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AccessDeniedError",
            "ConflictError",
            "InternalServerError",
            "ResourceNotFoundError",
            "ThrottlingError",
            "ValidationError",
        ]
    }
}
impl<T> std::convert::From<T> for BatchItemErrorCode
where
    T: std::convert::AsRef<str>,
{
    fn from(s: T) -> Self {
        BatchItemErrorCode(s.as_ref().to_owned())
    }
}

/// <p>Contains the position update details for a device.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DevicePositionUpdate {
    /// <p>The device associated to the position update.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The timestamp at which the device's position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub sample_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The latest device position defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[X or longitude, Y or latitude]</code>.</p>
    pub position: std::option::Option<std::vec::Vec<f64>>,
    /// <p>The accuracy of the device position.</p>
    pub accuracy: std::option::Option<crate::model::PositionalAccuracy>,
    /// <p>Associates one of more properties with the position update. A property is a key-value pair stored with the position update and added to any geofence event the update may trigger.</p>
    /// <p>Format: <code>"key" : "value"</code> </p>
    pub position_properties:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DevicePositionUpdate {
    /// <p>The device associated to the position update.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>The timestamp at which the device's position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub fn sample_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.sample_time.as_ref()
    }
    /// <p>The latest device position defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[X or longitude, Y or latitude]</code>.</p>
    pub fn position(&self) -> std::option::Option<&[f64]> {
        self.position.as_deref()
    }
    /// <p>The accuracy of the device position.</p>
    pub fn accuracy(&self) -> std::option::Option<&crate::model::PositionalAccuracy> {
        self.accuracy.as_ref()
    }
    /// <p>Associates one of more properties with the position update. A property is a key-value pair stored with the position update and added to any geofence event the update may trigger.</p>
    /// <p>Format: <code>"key" : "value"</code> </p>
    pub fn position_properties(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.position_properties.as_ref()
    }
}
impl std::fmt::Debug for DevicePositionUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DevicePositionUpdate");
        formatter.field("device_id", &self.device_id);
        formatter.field("sample_time", &self.sample_time);
        formatter.field("position", &"*** Sensitive Data Redacted ***");
        formatter.field("accuracy", &self.accuracy);
        formatter.field("position_properties", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`DevicePositionUpdate`](crate::model::DevicePositionUpdate)
pub mod device_position_update {
    /// A builder for [`DevicePositionUpdate`](crate::model::DevicePositionUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) sample_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) position: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) accuracy: std::option::Option<crate::model::PositionalAccuracy>,
        pub(crate) position_properties: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The device associated to the position update.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The device associated to the position update.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The timestamp at which the device's position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn sample_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.sample_time = Some(input);
            self
        }
        /// <p>The timestamp at which the device's position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn set_sample_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.sample_time = input;
            self
        }
        /// Appends an item to `position`.
        ///
        /// To override the contents of this collection use [`set_position`](Self::set_position).
        ///
        /// <p>The latest device position defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[X or longitude, Y or latitude]</code>.</p>
        pub fn position(mut self, input: f64) -> Self {
            let mut v = self.position.unwrap_or_default();
            v.push(input);
            self.position = Some(v);
            self
        }
        /// <p>The latest device position defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format: <code>[X or longitude, Y or latitude]</code>.</p>
        pub fn set_position(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.position = input;
            self
        }
        /// <p>The accuracy of the device position.</p>
        pub fn accuracy(mut self, input: crate::model::PositionalAccuracy) -> Self {
            self.accuracy = Some(input);
            self
        }
        /// <p>The accuracy of the device position.</p>
        pub fn set_accuracy(
            mut self,
            input: std::option::Option<crate::model::PositionalAccuracy>,
        ) -> Self {
            self.accuracy = input;
            self
        }
        /// Adds a key-value pair to `position_properties`.
        ///
        /// To override the contents of this collection use [`set_position_properties`](Self::set_position_properties).
        ///
        /// <p>Associates one of more properties with the position update. A property is a key-value pair stored with the position update and added to any geofence event the update may trigger.</p>
        /// <p>Format: <code>"key" : "value"</code> </p>
        pub fn position_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.position_properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.position_properties = Some(hash_map);
            self
        }
        /// <p>Associates one of more properties with the position update. A property is a key-value pair stored with the position update and added to any geofence event the update may trigger.</p>
        /// <p>Format: <code>"key" : "value"</code> </p>
        pub fn set_position_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.position_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`DevicePositionUpdate`](crate::model::DevicePositionUpdate)
        pub fn build(self) -> crate::model::DevicePositionUpdate {
            crate::model::DevicePositionUpdate {
                device_id: self.device_id,
                sample_time: self.sample_time,
                position: self.position,
                accuracy: self.accuracy,
                position_properties: self.position_properties,
            }
        }
    }
}
impl DevicePositionUpdate {
    /// Creates a new builder-style object to manufacture [`DevicePositionUpdate`](crate::model::DevicePositionUpdate)
    pub fn builder() -> crate::model::device_position_update::Builder {
        crate::model::device_position_update::Builder::default()
    }
}

/// <p>Contains error details for each device that didn't return a position.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetDevicePositionError {
    /// <p>The ID of the device that didn't return a position.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>Contains details related to the error code.</p>
    pub error: std::option::Option<crate::model::BatchItemError>,
}
impl BatchGetDevicePositionError {
    /// <p>The ID of the device that didn't return a position.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>Contains details related to the error code.</p>
    pub fn error(&self) -> std::option::Option<&crate::model::BatchItemError> {
        self.error.as_ref()
    }
}
impl std::fmt::Debug for BatchGetDevicePositionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetDevicePositionError");
        formatter.field("device_id", &self.device_id);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`BatchGetDevicePositionError`](crate::model::BatchGetDevicePositionError)
pub mod batch_get_device_position_error {
    /// A builder for [`BatchGetDevicePositionError`](crate::model::BatchGetDevicePositionError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<crate::model::BatchItemError>,
    }
    impl Builder {
        /// <p>The ID of the device that didn't return a position.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The ID of the device that didn't return a position.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>Contains details related to the error code.</p>
        pub fn error(mut self, input: crate::model::BatchItemError) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Contains details related to the error code.</p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::BatchItemError>,
        ) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetDevicePositionError`](crate::model::BatchGetDevicePositionError)
        pub fn build(self) -> crate::model::BatchGetDevicePositionError {
            crate::model::BatchGetDevicePositionError {
                device_id: self.device_id,
                error: self.error,
            }
        }
    }
}
impl BatchGetDevicePositionError {
    /// Creates a new builder-style object to manufacture [`BatchGetDevicePositionError`](crate::model::BatchGetDevicePositionError)
    pub fn builder() -> crate::model::batch_get_device_position_error::Builder {
        crate::model::batch_get_device_position_error::Builder::default()
    }
}

/// <p>Contains the tracker resource details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteDevicePositionHistoryError {
    /// <p>The ID of the device for this position.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>Contains the batch request error details associated with the request.</p>
    pub error: std::option::Option<crate::model::BatchItemError>,
}
impl BatchDeleteDevicePositionHistoryError {
    /// <p>The ID of the device for this position.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>Contains the batch request error details associated with the request.</p>
    pub fn error(&self) -> std::option::Option<&crate::model::BatchItemError> {
        self.error.as_ref()
    }
}
impl std::fmt::Debug for BatchDeleteDevicePositionHistoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteDevicePositionHistoryError");
        formatter.field("device_id", &self.device_id);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`BatchDeleteDevicePositionHistoryError`](crate::model::BatchDeleteDevicePositionHistoryError)
pub mod batch_delete_device_position_history_error {
    /// A builder for [`BatchDeleteDevicePositionHistoryError`](crate::model::BatchDeleteDevicePositionHistoryError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<crate::model::BatchItemError>,
    }
    impl Builder {
        /// <p>The ID of the device for this position.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The ID of the device for this position.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>Contains the batch request error details associated with the request.</p>
        pub fn error(mut self, input: crate::model::BatchItemError) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Contains the batch request error details associated with the request.</p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::BatchItemError>,
        ) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteDevicePositionHistoryError`](crate::model::BatchDeleteDevicePositionHistoryError)
        pub fn build(self) -> crate::model::BatchDeleteDevicePositionHistoryError {
            crate::model::BatchDeleteDevicePositionHistoryError {
                device_id: self.device_id,
                error: self.error,
            }
        }
    }
}
impl BatchDeleteDevicePositionHistoryError {
    /// Creates a new builder-style object to manufacture [`BatchDeleteDevicePositionHistoryError`](crate::model::BatchDeleteDevicePositionHistoryError)
    pub fn builder() -> crate::model::batch_delete_device_position_history_error::Builder {
        crate::model::batch_delete_device_position_history_error::Builder::default()
    }
}

/// <p>Contains the tracker resource details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrackersResponseEntry {
    /// <p>The name of the tracker resource.</p>
    pub tracker_name: std::option::Option<std::string::String>,
    /// <p>The description for the tracker resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Always returns <code>RequestBasedUsage</code>.</p>
    pub pricing_plan: std::option::Option<crate::model::PricingPlan>,
    /// <p>No longer used. Always returns an empty string.</p>
    pub pricing_plan_data_source: std::option::Option<std::string::String>,
    /// <p>The timestamp for when the tracker resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp at which the device's position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ListTrackersResponseEntry {
    /// <p>The name of the tracker resource.</p>
    pub fn tracker_name(&self) -> std::option::Option<&str> {
        self.tracker_name.as_deref()
    }
    /// <p>The description for the tracker resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Always returns <code>RequestBasedUsage</code>.</p>
    pub fn pricing_plan(&self) -> std::option::Option<&crate::model::PricingPlan> {
        self.pricing_plan.as_ref()
    }
    /// <p>No longer used. Always returns an empty string.</p>
    pub fn pricing_plan_data_source(&self) -> std::option::Option<&str> {
        self.pricing_plan_data_source.as_deref()
    }
    /// <p>The timestamp for when the tracker resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
    /// <p>The timestamp at which the device's position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
}
impl std::fmt::Debug for ListTrackersResponseEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrackersResponseEntry");
        formatter.field("tracker_name", &self.tracker_name);
        formatter.field("description", &self.description);
        formatter.field("pricing_plan", &self.pricing_plan);
        formatter.field("pricing_plan_data_source", &self.pricing_plan_data_source);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`ListTrackersResponseEntry`](crate::model::ListTrackersResponseEntry)
pub mod list_trackers_response_entry {
    /// A builder for [`ListTrackersResponseEntry`](crate::model::ListTrackersResponseEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tracker_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) pricing_plan: std::option::Option<crate::model::PricingPlan>,
        pub(crate) pricing_plan_data_source: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the tracker resource.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracker_name = Some(input.into());
            self
        }
        /// <p>The name of the tracker resource.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tracker_name = input;
            self
        }
        /// <p>The description for the tracker resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the tracker resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Always returns <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.pricing_plan = Some(input);
            self
        }
        /// <p>Always returns <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.pricing_plan = input;
            self
        }
        /// <p>No longer used. Always returns an empty string.</p>
        pub fn pricing_plan_data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.pricing_plan_data_source = Some(input.into());
            self
        }
        /// <p>No longer used. Always returns an empty string.</p>
        pub fn set_pricing_plan_data_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pricing_plan_data_source = input;
            self
        }
        /// <p>The timestamp for when the tracker resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp for when the tracker resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The timestamp at which the device's position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>The timestamp at which the device's position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrackersResponseEntry`](crate::model::ListTrackersResponseEntry)
        pub fn build(self) -> crate::model::ListTrackersResponseEntry {
            crate::model::ListTrackersResponseEntry {
                tracker_name: self.tracker_name,
                description: self.description,
                pricing_plan: self.pricing_plan,
                pricing_plan_data_source: self.pricing_plan_data_source,
                create_time: self.create_time,
                update_time: self.update_time,
            }
        }
    }
}
impl ListTrackersResponseEntry {
    /// Creates a new builder-style object to manufacture [`ListTrackersResponseEntry`](crate::model::ListTrackersResponseEntry)
    pub fn builder() -> crate::model::list_trackers_response_entry::Builder {
        crate::model::list_trackers_response_entry::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub struct PricingPlan(String);
impl PricingPlan {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        &self.0
    }
    /// Returns all the `&str` representations of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "MobileAssetManagement",
            "MobileAssetTracking",
            "RequestBasedUsage",
        ]
    }
}
impl<T> std::convert::From<T> for PricingPlan
where
    T: std::convert::AsRef<str>,
{
    fn from(s: T) -> Self {
        PricingPlan(s.as_ref().to_owned())
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub struct PositionFiltering(String);
impl PositionFiltering {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        &self.0
    }
    /// Returns all the `&str` representations of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AccuracyBased", "DistanceBased", "TimeBased"]
    }
}
impl<T> std::convert::From<T> for PositionFiltering
where
    T: std::convert::AsRef<str>,
{
    fn from(s: T) -> Self {
        PositionFiltering(s.as_ref().to_owned())
    }
}

/// <p>A summary of the calculated route matrix.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CalculateRouteMatrixSummary {
    /// <p>The data provider of traffic and road network data used to calculate the routes. Indicates one of the available providers:</p>
    /// <ul>
    /// <li> <p> <code>Esri</code> </p> </li>
    /// <li> <p> <code>Here</code> </p> </li>
    /// </ul>
    /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
    pub data_source: std::option::Option<std::string::String>,
    /// <p>The count of cells in the route matrix. Equal to the number of <code>DeparturePositions</code> multiplied by the number of <code>DestinationPositions</code>.</p>
    pub route_count: std::option::Option<i32>,
    /// <p>The count of error results in the route matrix. If this number is 0, all routes were calculated successfully.</p>
    pub error_count: std::option::Option<i32>,
    /// <p>The unit of measurement for route distances.</p>
    pub distance_unit: std::option::Option<crate::model::DistanceUnit>,
}
impl CalculateRouteMatrixSummary {
    /// <p>The data provider of traffic and road network data used to calculate the routes. Indicates one of the available providers:</p>
    /// <ul>
    /// <li> <p> <code>Esri</code> </p> </li>
    /// <li> <p> <code>Here</code> </p> </li>
    /// </ul>
    /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
    pub fn data_source(&self) -> std::option::Option<&str> {
        self.data_source.as_deref()
    }
    /// <p>The count of cells in the route matrix. Equal to the number of <code>DeparturePositions</code> multiplied by the number of <code>DestinationPositions</code>.</p>
    pub fn route_count(&self) -> std::option::Option<i32> {
        self.route_count
    }
    /// <p>The count of error results in the route matrix. If this number is 0, all routes were calculated successfully.</p>
    pub fn error_count(&self) -> std::option::Option<i32> {
        self.error_count
    }
    /// <p>The unit of measurement for route distances.</p>
    pub fn distance_unit(&self) -> std::option::Option<&crate::model::DistanceUnit> {
        self.distance_unit.as_ref()
    }
}
impl std::fmt::Debug for CalculateRouteMatrixSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CalculateRouteMatrixSummary");
        formatter.field("data_source", &self.data_source);
        formatter.field("route_count", &self.route_count);
        formatter.field("error_count", &self.error_count);
        formatter.field("distance_unit", &self.distance_unit);
        formatter.finish()
    }
}
/// See [`CalculateRouteMatrixSummary`](crate::model::CalculateRouteMatrixSummary)
pub mod calculate_route_matrix_summary {
    /// A builder for [`CalculateRouteMatrixSummary`](crate::model::CalculateRouteMatrixSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source: std::option::Option<std::string::String>,
        pub(crate) route_count: std::option::Option<i32>,
        pub(crate) error_count: std::option::Option<i32>,
        pub(crate) distance_unit: std::option::Option<crate::model::DistanceUnit>,
    }
    impl Builder {
        /// <p>The data provider of traffic and road network data used to calculate the routes. Indicates one of the available providers:</p>
        /// <ul>
        /// <li> <p> <code>Esri</code> </p> </li>
        /// <li> <p> <code>Here</code> </p> </li>
        /// </ul>
        /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
        pub fn data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source = Some(input.into());
            self
        }
        /// <p>The data provider of traffic and road network data used to calculate the routes. Indicates one of the available providers:</p>
        /// <ul>
        /// <li> <p> <code>Esri</code> </p> </li>
        /// <li> <p> <code>Here</code> </p> </li>
        /// </ul>
        /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
        pub fn set_data_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_source = input;
            self
        }
        /// <p>The count of cells in the route matrix. Equal to the number of <code>DeparturePositions</code> multiplied by the number of <code>DestinationPositions</code>.</p>
        pub fn route_count(mut self, input: i32) -> Self {
            self.route_count = Some(input);
            self
        }
        /// <p>The count of cells in the route matrix. Equal to the number of <code>DeparturePositions</code> multiplied by the number of <code>DestinationPositions</code>.</p>
        pub fn set_route_count(mut self, input: std::option::Option<i32>) -> Self {
            self.route_count = input;
            self
        }
        /// <p>The count of error results in the route matrix. If this number is 0, all routes were calculated successfully.</p>
        pub fn error_count(mut self, input: i32) -> Self {
            self.error_count = Some(input);
            self
        }
        /// <p>The count of error results in the route matrix. If this number is 0, all routes were calculated successfully.</p>
        pub fn set_error_count(mut self, input: std::option::Option<i32>) -> Self {
            self.error_count = input;
            self
        }
        /// <p>The unit of measurement for route distances.</p>
        pub fn distance_unit(mut self, input: crate::model::DistanceUnit) -> Self {
            self.distance_unit = Some(input);
            self
        }
        /// <p>The unit of measurement for route distances.</p>
        pub fn set_distance_unit(
            mut self,
            input: std::option::Option<crate::model::DistanceUnit>,
        ) -> Self {
            self.distance_unit = input;
            self
        }
        /// Consumes the builder and constructs a [`CalculateRouteMatrixSummary`](crate::model::CalculateRouteMatrixSummary)
        pub fn build(self) -> crate::model::CalculateRouteMatrixSummary {
            crate::model::CalculateRouteMatrixSummary {
                data_source: self.data_source,
                route_count: self.route_count,
                error_count: self.error_count,
                distance_unit: self.distance_unit,
            }
        }
    }
}
impl CalculateRouteMatrixSummary {
    /// Creates a new builder-style object to manufacture [`CalculateRouteMatrixSummary`](crate::model::CalculateRouteMatrixSummary)
    pub fn builder() -> crate::model::calculate_route_matrix_summary::Builder {
        crate::model::calculate_route_matrix_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub struct DistanceUnit(String);
impl DistanceUnit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        &self.0
    }
    /// Returns all the `&str` representations of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Kilometers", "Miles"]
    }
}
impl<T> std::convert::From<T> for DistanceUnit
where
    T: std::convert::AsRef<str>,
{
    fn from(s: T) -> Self {
        DistanceUnit(s.as_ref().to_owned())
    }
}

/// <p>The result for one <code>SnappedDeparturePosition</code> <code>SnappedDestinationPosition</code> pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RouteMatrixEntry {
    /// <p>The total distance of travel for the route.</p>
    pub distance: std::option::Option<f64>,
    /// <p>The expected duration of travel for the route.</p>
    pub duration_seconds: std::option::Option<f64>,
    /// <p>An error corresponding to the calculation of a route between the <code>DeparturePosition</code> and <code>DestinationPosition</code>.</p>
    pub error: std::option::Option<crate::model::RouteMatrixEntryError>,
}
impl RouteMatrixEntry {
    /// <p>The total distance of travel for the route.</p>
    pub fn distance(&self) -> std::option::Option<f64> {
        self.distance
    }
    /// <p>The expected duration of travel for the route.</p>
    pub fn duration_seconds(&self) -> std::option::Option<f64> {
        self.duration_seconds
    }
    /// <p>An error corresponding to the calculation of a route between the <code>DeparturePosition</code> and <code>DestinationPosition</code>.</p>
    pub fn error(&self) -> std::option::Option<&crate::model::RouteMatrixEntryError> {
        self.error.as_ref()
    }
}
impl std::fmt::Debug for RouteMatrixEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RouteMatrixEntry");
        formatter.field("distance", &self.distance);
        formatter.field("duration_seconds", &self.duration_seconds);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`RouteMatrixEntry`](crate::model::RouteMatrixEntry)
pub mod route_matrix_entry {
    /// A builder for [`RouteMatrixEntry`](crate::model::RouteMatrixEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distance: std::option::Option<f64>,
        pub(crate) duration_seconds: std::option::Option<f64>,
        pub(crate) error: std::option::Option<crate::model::RouteMatrixEntryError>,
    }
    impl Builder {
        /// <p>The total distance of travel for the route.</p>
        pub fn distance(mut self, input: f64) -> Self {
            self.distance = Some(input);
            self
        }
        /// <p>The total distance of travel for the route.</p>
        pub fn set_distance(mut self, input: std::option::Option<f64>) -> Self {
            self.distance = input;
            self
        }
        /// <p>The expected duration of travel for the route.</p>
        pub fn duration_seconds(mut self, input: f64) -> Self {
            self.duration_seconds = Some(input);
            self
        }
        /// <p>The expected duration of travel for the route.</p>
        pub fn set_duration_seconds(mut self, input: std::option::Option<f64>) -> Self {
            self.duration_seconds = input;
            self
        }
        /// <p>An error corresponding to the calculation of a route between the <code>DeparturePosition</code> and <code>DestinationPosition</code>.</p>
        pub fn error(mut self, input: crate::model::RouteMatrixEntryError) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>An error corresponding to the calculation of a route between the <code>DeparturePosition</code> and <code>DestinationPosition</code>.</p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::RouteMatrixEntryError>,
        ) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`RouteMatrixEntry`](crate::model::RouteMatrixEntry)
        pub fn build(self) -> crate::model::RouteMatrixEntry {
            crate::model::RouteMatrixEntry {
                distance: self.distance,
                duration_seconds: self.duration_seconds,
                error: self.error,
            }
        }
    }
}
impl RouteMatrixEntry {
    /// Creates a new builder-style object to manufacture [`RouteMatrixEntry`](crate::model::RouteMatrixEntry)
    pub fn builder() -> crate::model::route_matrix_entry::Builder {
        crate::model::route_matrix_entry::Builder::default()
    }
}

/// <p>An error corresponding to the calculation of a route between the <code>DeparturePosition</code> and <code>DestinationPosition</code>.</p>
/// <p>The error code can be one of the following:</p>
/// <ul>
/// <li> <p> <code>RouteNotFound</code> - Unable to find a valid route with the given parameters.</p> </li>
/// </ul>
/// <ul>
/// <li> <p> <code>RouteTooLong</code> - Route calculation went beyond the maximum size of a route and was terminated before completion.</p> </li>
/// </ul>
/// <ul>
/// <li> <p> <code>PositionsNotFound</code> - One or more of the input positions were not found on the route network.</p> </li>
/// </ul>
/// <ul>
/// <li> <p> <code>DestinationPositionNotFound</code> - The destination position was not found on the route network.</p> </li>
/// </ul>
/// <ul>
/// <li> <p> <code>DeparturePositionNotFound</code> - The departure position was not found on the route network.</p> </li>
/// </ul>
/// <ul>
/// <li> <p> <code>OtherValidationError</code> - The given inputs were not valid or a route was not found. More information is given in the error <code>Message</code> </p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RouteMatrixEntryError {
    /// <p>The type of error which occurred for the route calculation.</p>
    pub code: std::option::Option<crate::model::RouteMatrixErrorCode>,
    /// <p>A message about the error that occurred for the route calculation.</p>
    pub message: std::option::Option<std::string::String>,
}
impl RouteMatrixEntryError {
    /// <p>The type of error which occurred for the route calculation.</p>
    pub fn code(&self) -> std::option::Option<&crate::model::RouteMatrixErrorCode> {
        self.code.as_ref()
    }
    /// <p>A message about the error that occurred for the route calculation.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for RouteMatrixEntryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RouteMatrixEntryError");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`RouteMatrixEntryError`](crate::model::RouteMatrixEntryError)
pub mod route_matrix_entry_error {
    /// A builder for [`RouteMatrixEntryError`](crate::model::RouteMatrixEntryError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::RouteMatrixErrorCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of error which occurred for the route calculation.</p>
        pub fn code(mut self, input: crate::model::RouteMatrixErrorCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The type of error which occurred for the route calculation.</p>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::RouteMatrixErrorCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>A message about the error that occurred for the route calculation.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message about the error that occurred for the route calculation.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RouteMatrixEntryError`](crate::model::RouteMatrixEntryError)
        pub fn build(self) -> crate::model::RouteMatrixEntryError {
            crate::model::RouteMatrixEntryError {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl RouteMatrixEntryError {
    /// Creates a new builder-style object to manufacture [`RouteMatrixEntryError`](crate::model::RouteMatrixEntryError)
    pub fn builder() -> crate::model::route_matrix_entry_error::Builder {
        crate::model::route_matrix_entry_error::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub struct RouteMatrixErrorCode(String);
impl RouteMatrixErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        &self.0
    }
    /// Returns all the `&str` representations of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DeparturePositionNotFound",
            "DestinationPositionNotFound",
            "OtherValidationError",
            "PositionsNotFound",
            "RouteNotFound",
            "RouteTooLong",
        ]
    }
}
impl<T> std::convert::From<T> for RouteMatrixErrorCode
where
    T: std::convert::AsRef<str>,
{
    fn from(s: T) -> Self {
        RouteMatrixErrorCode(s.as_ref().to_owned())
    }
}

/// <p>Contains details about additional route preferences for requests that specify <code>TravelMode</code> as <code>Truck</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CalculateRouteTruckModeOptions {
    /// <p>Avoids ferries when calculating routes.</p>
    /// <p>Default Value: <code>false</code> </p>
    /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
    pub avoid_ferries: std::option::Option<bool>,
    /// <p>Avoids ferries when calculating routes.</p>
    /// <p>Default Value: <code>false</code> </p>
    /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
    pub avoid_tolls: std::option::Option<bool>,
    /// <p>Specifies the truck's dimension specifications including length, height, width, and unit of measurement. Used to avoid roads that can't support the truck's dimensions.</p>
    pub dimensions: std::option::Option<crate::model::TruckDimensions>,
    /// <p>Specifies the truck's weight specifications including total weight and unit of measurement. Used to avoid roads that can't support the truck's weight.</p>
    pub weight: std::option::Option<crate::model::TruckWeight>,
}
impl CalculateRouteTruckModeOptions {
    /// <p>Avoids ferries when calculating routes.</p>
    /// <p>Default Value: <code>false</code> </p>
    /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
    pub fn avoid_ferries(&self) -> std::option::Option<bool> {
        self.avoid_ferries
    }
    /// <p>Avoids ferries when calculating routes.</p>
    /// <p>Default Value: <code>false</code> </p>
    /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
    pub fn avoid_tolls(&self) -> std::option::Option<bool> {
        self.avoid_tolls
    }
    /// <p>Specifies the truck's dimension specifications including length, height, width, and unit of measurement. Used to avoid roads that can't support the truck's dimensions.</p>
    pub fn dimensions(&self) -> std::option::Option<&crate::model::TruckDimensions> {
        self.dimensions.as_ref()
    }
    /// <p>Specifies the truck's weight specifications including total weight and unit of measurement. Used to avoid roads that can't support the truck's weight.</p>
    pub fn weight(&self) -> std::option::Option<&crate::model::TruckWeight> {
        self.weight.as_ref()
    }
}
impl std::fmt::Debug for CalculateRouteTruckModeOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CalculateRouteTruckModeOptions");
        formatter.field("avoid_ferries", &self.avoid_ferries);
        formatter.field("avoid_tolls", &self.avoid_tolls);
        formatter.field("dimensions", &self.dimensions);
        formatter.field("weight", &self.weight);
        formatter.finish()
    }
}
/// See [`CalculateRouteTruckModeOptions`](crate::model::CalculateRouteTruckModeOptions)
pub mod calculate_route_truck_mode_options {
    /// A builder for [`CalculateRouteTruckModeOptions`](crate::model::CalculateRouteTruckModeOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) avoid_ferries: std::option::Option<bool>,
        pub(crate) avoid_tolls: std::option::Option<bool>,
        pub(crate) dimensions: std::option::Option<crate::model::TruckDimensions>,
        pub(crate) weight: std::option::Option<crate::model::TruckWeight>,
    }
    impl Builder {
        /// <p>Avoids ferries when calculating routes.</p>
        /// <p>Default Value: <code>false</code> </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
        pub fn avoid_ferries(mut self, input: bool) -> Self {
            self.avoid_ferries = Some(input);
            self
        }
        /// <p>Avoids ferries when calculating routes.</p>
        /// <p>Default Value: <code>false</code> </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
        pub fn set_avoid_ferries(mut self, input: std::option::Option<bool>) -> Self {
            self.avoid_ferries = input;
            self
        }
        /// <p>Avoids ferries when calculating routes.</p>
        /// <p>Default Value: <code>false</code> </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
        pub fn avoid_tolls(mut self, input: bool) -> Self {
            self.avoid_tolls = Some(input);
            self
        }
        /// <p>Avoids ferries when calculating routes.</p>
        /// <p>Default Value: <code>false</code> </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
        pub fn set_avoid_tolls(mut self, input: std::option::Option<bool>) -> Self {
            self.avoid_tolls = input;
            self
        }
        /// <p>Specifies the truck's dimension specifications including length, height, width, and unit of measurement. Used to avoid roads that can't support the truck's dimensions.</p>
        pub fn dimensions(mut self, input: crate::model::TruckDimensions) -> Self {
            self.dimensions = Some(input);
            self
        }
        /// <p>Specifies the truck's dimension specifications including length, height, width, and unit of measurement. Used to avoid roads that can't support the truck's dimensions.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<crate::model::TruckDimensions>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p>Specifies the truck's weight specifications including total weight and unit of measurement. Used to avoid roads that can't support the truck's weight.</p>
        pub fn weight(mut self, input: crate::model::TruckWeight) -> Self {
            self.weight = Some(input);
            self
        }
        /// <p>Specifies the truck's weight specifications including total weight and unit of measurement. Used to avoid roads that can't support the truck's weight.</p>
        pub fn set_weight(mut self, input: std::option::Option<crate::model::TruckWeight>) -> Self {
            self.weight = input;
            self
        }
        /// Consumes the builder and constructs a [`CalculateRouteTruckModeOptions`](crate::model::CalculateRouteTruckModeOptions)
        pub fn build(self) -> crate::model::CalculateRouteTruckModeOptions {
            crate::model::CalculateRouteTruckModeOptions {
                avoid_ferries: self.avoid_ferries,
                avoid_tolls: self.avoid_tolls,
                dimensions: self.dimensions,
                weight: self.weight,
            }
        }
    }
}
impl CalculateRouteTruckModeOptions {
    /// Creates a new builder-style object to manufacture [`CalculateRouteTruckModeOptions`](crate::model::CalculateRouteTruckModeOptions)
    pub fn builder() -> crate::model::calculate_route_truck_mode_options::Builder {
        crate::model::calculate_route_truck_mode_options::Builder::default()
    }
}

/// <p>Contains details about the truck's weight specifications. Used to avoid roads that can't support or allow the total weight for requests that specify <code>TravelMode</code> as <code>Truck</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TruckWeight {
    /// <p>The total weight of the truck. </p>
    /// <ul>
    /// <li> <p>For example, <code>3500</code>.</p> </li>
    /// </ul>
    pub total: std::option::Option<f64>,
    /// <p>The unit of measurement to use for the truck weight.</p>
    /// <p>Default Value: <code>Kilograms</code> </p>
    pub unit: std::option::Option<crate::model::VehicleWeightUnit>,
}
impl TruckWeight {
    /// <p>The total weight of the truck. </p>
    /// <ul>
    /// <li> <p>For example, <code>3500</code>.</p> </li>
    /// </ul>
    pub fn total(&self) -> std::option::Option<f64> {
        self.total
    }
    /// <p>The unit of measurement to use for the truck weight.</p>
    /// <p>Default Value: <code>Kilograms</code> </p>
    pub fn unit(&self) -> std::option::Option<&crate::model::VehicleWeightUnit> {
        self.unit.as_ref()
    }
}
impl std::fmt::Debug for TruckWeight {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TruckWeight");
        formatter.field("total", &self.total);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`TruckWeight`](crate::model::TruckWeight)
pub mod truck_weight {
    /// A builder for [`TruckWeight`](crate::model::TruckWeight)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) total: std::option::Option<f64>,
        pub(crate) unit: std::option::Option<crate::model::VehicleWeightUnit>,
    }
    impl Builder {
        /// <p>The total weight of the truck. </p>
        /// <ul>
        /// <li> <p>For example, <code>3500</code>.</p> </li>
        /// </ul>
        pub fn total(mut self, input: f64) -> Self {
            self.total = Some(input);
            self
        }
        /// <p>The total weight of the truck. </p>
        /// <ul>
        /// <li> <p>For example, <code>3500</code>.</p> </li>
        /// </ul>
        pub fn set_total(mut self, input: std::option::Option<f64>) -> Self {
            self.total = input;
            self
        }
        /// <p>The unit of measurement to use for the truck weight.</p>
        /// <p>Default Value: <code>Kilograms</code> </p>
        pub fn unit(mut self, input: crate::model::VehicleWeightUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>The unit of measurement to use for the truck weight.</p>
        /// <p>Default Value: <code>Kilograms</code> </p>
        pub fn set_unit(
            mut self,
            input: std::option::Option<crate::model::VehicleWeightUnit>,
        ) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`TruckWeight`](crate::model::TruckWeight)
        pub fn build(self) -> crate::model::TruckWeight {
            crate::model::TruckWeight {
                total: self.total,
                unit: self.unit,
            }
        }
    }
}
impl TruckWeight {
    /// Creates a new builder-style object to manufacture [`TruckWeight`](crate::model::TruckWeight)
    pub fn builder() -> crate::model::truck_weight::Builder {
        crate::model::truck_weight::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub struct VehicleWeightUnit(String);
impl VehicleWeightUnit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        &self.0
    }
    /// Returns all the `&str` representations of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Kilograms", "Pounds"]
    }
}
impl<T> std::convert::From<T> for VehicleWeightUnit
where
    T: std::convert::AsRef<str>,
{
    fn from(s: T) -> Self {
        VehicleWeightUnit(s.as_ref().to_owned())
    }
}

/// <p>Contains details about the truck dimensions in the unit of measurement that you specify. Used to filter out roads that can't support or allow the specified dimensions for requests that specify <code>TravelMode</code> as <code>Truck</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TruckDimensions {
    /// <p>The length of the truck.</p>
    /// <ul>
    /// <li> <p>For example, <code>15.5</code>.</p> </li>
    /// </ul>
    pub length: std::option::Option<f64>,
    /// <p>The height of the truck.</p>
    /// <ul>
    /// <li> <p>For example, <code>4.5</code>.</p> </li>
    /// </ul>
    pub height: std::option::Option<f64>,
    /// <p>The width of the truck.</p>
    /// <ul>
    /// <li> <p>For example, <code>4.5</code>.</p> </li>
    /// </ul>
    pub width: std::option::Option<f64>,
    /// <p> Specifies the unit of measurement for the truck dimensions.</p>
    /// <p>Default Value: <code>Meters</code> </p>
    pub unit: std::option::Option<crate::model::DimensionUnit>,
}
impl TruckDimensions {
    /// <p>The length of the truck.</p>
    /// <ul>
    /// <li> <p>For example, <code>15.5</code>.</p> </li>
    /// </ul>
    pub fn length(&self) -> std::option::Option<f64> {
        self.length
    }
    /// <p>The height of the truck.</p>
    /// <ul>
    /// <li> <p>For example, <code>4.5</code>.</p> </li>
    /// </ul>
    pub fn height(&self) -> std::option::Option<f64> {
        self.height
    }
    /// <p>The width of the truck.</p>
    /// <ul>
    /// <li> <p>For example, <code>4.5</code>.</p> </li>
    /// </ul>
    pub fn width(&self) -> std::option::Option<f64> {
        self.width
    }
    /// <p> Specifies the unit of measurement for the truck dimensions.</p>
    /// <p>Default Value: <code>Meters</code> </p>
    pub fn unit(&self) -> std::option::Option<&crate::model::DimensionUnit> {
        self.unit.as_ref()
    }
}
impl std::fmt::Debug for TruckDimensions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TruckDimensions");
        formatter.field("length", &self.length);
        formatter.field("height", &self.height);
        formatter.field("width", &self.width);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`TruckDimensions`](crate::model::TruckDimensions)
pub mod truck_dimensions {
    /// A builder for [`TruckDimensions`](crate::model::TruckDimensions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) length: std::option::Option<f64>,
        pub(crate) height: std::option::Option<f64>,
        pub(crate) width: std::option::Option<f64>,
        pub(crate) unit: std::option::Option<crate::model::DimensionUnit>,
    }
    impl Builder {
        /// <p>The length of the truck.</p>
        /// <ul>
        /// <li> <p>For example, <code>15.5</code>.</p> </li>
        /// </ul>
        pub fn length(mut self, input: f64) -> Self {
            self.length = Some(input);
            self
        }
        /// <p>The length of the truck.</p>
        /// <ul>
        /// <li> <p>For example, <code>15.5</code>.</p> </li>
        /// </ul>
        pub fn set_length(mut self, input: std::option::Option<f64>) -> Self {
            self.length = input;
            self
        }
        /// <p>The height of the truck.</p>
        /// <ul>
        /// <li> <p>For example, <code>4.5</code>.</p> </li>
        /// </ul>
        pub fn height(mut self, input: f64) -> Self {
            self.height = Some(input);
            self
        }
        /// <p>The height of the truck.</p>
        /// <ul>
        /// <li> <p>For example, <code>4.5</code>.</p> </li>
        /// </ul>
        pub fn set_height(mut self, input: std::option::Option<f64>) -> Self {
            self.height = input;
            self
        }
        /// <p>The width of the truck.</p>
        /// <ul>
        /// <li> <p>For example, <code>4.5</code>.</p> </li>
        /// </ul>
        pub fn width(mut self, input: f64) -> Self {
            self.width = Some(input);
            self
        }
        /// <p>The width of the truck.</p>
        /// <ul>
        /// <li> <p>For example, <code>4.5</code>.</p> </li>
        /// </ul>
        pub fn set_width(mut self, input: std::option::Option<f64>) -> Self {
            self.width = input;
            self
        }
        /// <p> Specifies the unit of measurement for the truck dimensions.</p>
        /// <p>Default Value: <code>Meters</code> </p>
        pub fn unit(mut self, input: crate::model::DimensionUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p> Specifies the unit of measurement for the truck dimensions.</p>
        /// <p>Default Value: <code>Meters</code> </p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::DimensionUnit>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`TruckDimensions`](crate::model::TruckDimensions)
        pub fn build(self) -> crate::model::TruckDimensions {
            crate::model::TruckDimensions {
                length: self.length,
                height: self.height,
                width: self.width,
                unit: self.unit,
            }
        }
    }
}
impl TruckDimensions {
    /// Creates a new builder-style object to manufacture [`TruckDimensions`](crate::model::TruckDimensions)
    pub fn builder() -> crate::model::truck_dimensions::Builder {
        crate::model::truck_dimensions::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub struct DimensionUnit(String);
impl DimensionUnit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        &self.0
    }
    /// Returns all the `&str` representations of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Feet", "Meters"]
    }
}
impl<T> std::convert::From<T> for DimensionUnit
where
    T: std::convert::AsRef<str>,
{
    fn from(s: T) -> Self {
        DimensionUnit(s.as_ref().to_owned())
    }
}

/// <p>Contains details about additional route preferences for requests that specify <code>TravelMode</code> as <code>Car</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CalculateRouteCarModeOptions {
    /// <p>Avoids ferries when calculating routes.</p>
    /// <p>Default Value: <code>false</code> </p>
    /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
    pub avoid_ferries: std::option::Option<bool>,
    /// <p>Avoids tolls when calculating routes.</p>
    /// <p>Default Value: <code>false</code> </p>
    /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
    pub avoid_tolls: std::option::Option<bool>,
}
impl CalculateRouteCarModeOptions {
    /// <p>Avoids ferries when calculating routes.</p>
    /// <p>Default Value: <code>false</code> </p>
    /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
    pub fn avoid_ferries(&self) -> std::option::Option<bool> {
        self.avoid_ferries
    }
    /// <p>Avoids tolls when calculating routes.</p>
    /// <p>Default Value: <code>false</code> </p>
    /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
    pub fn avoid_tolls(&self) -> std::option::Option<bool> {
        self.avoid_tolls
    }
}
impl std::fmt::Debug for CalculateRouteCarModeOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CalculateRouteCarModeOptions");
        formatter.field("avoid_ferries", &self.avoid_ferries);
        formatter.field("avoid_tolls", &self.avoid_tolls);
        formatter.finish()
    }
}
/// See [`CalculateRouteCarModeOptions`](crate::model::CalculateRouteCarModeOptions)
pub mod calculate_route_car_mode_options {
    /// A builder for [`CalculateRouteCarModeOptions`](crate::model::CalculateRouteCarModeOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) avoid_ferries: std::option::Option<bool>,
        pub(crate) avoid_tolls: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Avoids ferries when calculating routes.</p>
        /// <p>Default Value: <code>false</code> </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
        pub fn avoid_ferries(mut self, input: bool) -> Self {
            self.avoid_ferries = Some(input);
            self
        }
        /// <p>Avoids ferries when calculating routes.</p>
        /// <p>Default Value: <code>false</code> </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
        pub fn set_avoid_ferries(mut self, input: std::option::Option<bool>) -> Self {
            self.avoid_ferries = input;
            self
        }
        /// <p>Avoids tolls when calculating routes.</p>
        /// <p>Default Value: <code>false</code> </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
        pub fn avoid_tolls(mut self, input: bool) -> Self {
            self.avoid_tolls = Some(input);
            self
        }
        /// <p>Avoids tolls when calculating routes.</p>
        /// <p>Default Value: <code>false</code> </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code> </p>
        pub fn set_avoid_tolls(mut self, input: std::option::Option<bool>) -> Self {
            self.avoid_tolls = input;
            self
        }
        /// Consumes the builder and constructs a [`CalculateRouteCarModeOptions`](crate::model::CalculateRouteCarModeOptions)
        pub fn build(self) -> crate::model::CalculateRouteCarModeOptions {
            crate::model::CalculateRouteCarModeOptions {
                avoid_ferries: self.avoid_ferries,
                avoid_tolls: self.avoid_tolls,
            }
        }
    }
}
impl CalculateRouteCarModeOptions {
    /// Creates a new builder-style object to manufacture [`CalculateRouteCarModeOptions`](crate::model::CalculateRouteCarModeOptions)
    pub fn builder() -> crate::model::calculate_route_car_mode_options::Builder {
        crate::model::calculate_route_car_mode_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub struct TravelMode(String);
impl TravelMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        &self.0
    }
    /// Returns all the `&str` representations of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Car", "Truck", "Walking"]
    }
}
impl<T> std::convert::From<T> for TravelMode
where
    T: std::convert::AsRef<str>,
{
    fn from(s: T) -> Self {
        TravelMode(s.as_ref().to_owned())
    }
}

/// <p>A summary of the calculated route.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CalculateRouteSummary {
    /// <p>Specifies a geographical box surrounding a route. Used to zoom into a route when displaying it in a map. For example, <code>[min x, min y, max x, max y]</code>.</p>
    /// <p>The first 2 <code>bbox</code> parameters describe the lower southwest corner: </p>
    /// <ul>
    /// <li> <p>The first <code>bbox</code> position is the X coordinate or longitude of the lower southwest corner. </p> </li>
    /// <li> <p>The second <code>bbox</code> position is the Y coordinate or latitude of the lower southwest corner. </p> </li>
    /// </ul>
    /// <p>The next 2 <code>bbox</code> parameters describe the upper northeast corner: </p>
    /// <ul>
    /// <li> <p>The third <code>bbox</code> position is the X coordinate, or longitude of the upper northeast corner. </p> </li>
    /// <li> <p>The fourth <code>bbox</code> position is the Y coordinate, or latitude of the upper northeast corner. </p> </li>
    /// </ul>
    pub route_b_box: std::option::Option<std::vec::Vec<f64>>,
    /// <p>The data provider of traffic and road network data used to calculate the route. Indicates one of the available providers:</p>
    /// <ul>
    /// <li> <p> <code>Esri</code> </p> </li>
    /// <li> <p> <code>Here</code> </p> </li>
    /// </ul>
    /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
    pub data_source: std::option::Option<std::string::String>,
    /// <p>The total distance covered by the route. The sum of the distance travelled between every stop on the route.</p> <note>
    /// <p>If Esri is the data source for the route calculator, the route distance can’t be greater than 400 km. If the route exceeds 400 km, the response is a <code>400 RoutesValidationException</code> error.</p>
    /// </note>
    pub distance: std::option::Option<f64>,
    /// <p>The total travel time for the route measured in seconds. The sum of the travel time between every stop on the route.</p>
    pub duration_seconds: std::option::Option<f64>,
    /// <p>The unit of measurement for route distances.</p>
    pub distance_unit: std::option::Option<crate::model::DistanceUnit>,
}
impl CalculateRouteSummary {
    /// <p>Specifies a geographical box surrounding a route. Used to zoom into a route when displaying it in a map. For example, <code>[min x, min y, max x, max y]</code>.</p>
    /// <p>The first 2 <code>bbox</code> parameters describe the lower southwest corner: </p>
    /// <ul>
    /// <li> <p>The first <code>bbox</code> position is the X coordinate or longitude of the lower southwest corner. </p> </li>
    /// <li> <p>The second <code>bbox</code> position is the Y coordinate or latitude of the lower southwest corner. </p> </li>
    /// </ul>
    /// <p>The next 2 <code>bbox</code> parameters describe the upper northeast corner: </p>
    /// <ul>
    /// <li> <p>The third <code>bbox</code> position is the X coordinate, or longitude of the upper northeast corner. </p> </li>
    /// <li> <p>The fourth <code>bbox</code> position is the Y coordinate, or latitude of the upper northeast corner. </p> </li>
    /// </ul>
    pub fn route_b_box(&self) -> std::option::Option<&[f64]> {
        self.route_b_box.as_deref()
    }
    /// <p>The data provider of traffic and road network data used to calculate the route. Indicates one of the available providers:</p>
    /// <ul>
    /// <li> <p> <code>Esri</code> </p> </li>
    /// <li> <p> <code>Here</code> </p> </li>
    /// </ul>
    /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
    pub fn data_source(&self) -> std::option::Option<&str> {
        self.data_source.as_deref()
    }
    /// <p>The total distance covered by the route. The sum of the distance travelled between every stop on the route.</p> <note>
    /// <p>If Esri is the data source for the route calculator, the route distance can’t be greater than 400 km. If the route exceeds 400 km, the response is a <code>400 RoutesValidationException</code> error.</p>
    /// </note>
    pub fn distance(&self) -> std::option::Option<f64> {
        self.distance
    }
    /// <p>The total travel time for the route measured in seconds. The sum of the travel time between every stop on the route.</p>
    pub fn duration_seconds(&self) -> std::option::Option<f64> {
        self.duration_seconds
    }
    /// <p>The unit of measurement for route distances.</p>
    pub fn distance_unit(&self) -> std::option::Option<&crate::model::DistanceUnit> {
        self.distance_unit.as_ref()
    }
}
impl std::fmt::Debug for CalculateRouteSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CalculateRouteSummary");
        formatter.field("route_b_box", &"*** Sensitive Data Redacted ***");
        formatter.field("data_source", &self.data_source);
        formatter.field("distance", &self.distance);
        formatter.field("duration_seconds", &self.duration_seconds);
        formatter.field("distance_unit", &self.distance_unit);
        formatter.finish()
    }
}
/// See [`CalculateRouteSummary`](crate::model::CalculateRouteSummary)
pub mod calculate_route_summary {
    /// A builder for [`CalculateRouteSummary`](crate::model::CalculateRouteSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) route_b_box: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) data_source: std::option::Option<std::string::String>,
        pub(crate) distance: std::option::Option<f64>,
        pub(crate) duration_seconds: std::option::Option<f64>,
        pub(crate) distance_unit: std::option::Option<crate::model::DistanceUnit>,
    }
    impl Builder {
        /// Appends an item to `route_b_box`.
        ///
        /// To override the contents of this collection use [`set_route_b_box`](Self::set_route_b_box).
        ///
        /// <p>Specifies a geographical box surrounding a route. Used to zoom into a route when displaying it in a map. For example, <code>[min x, min y, max x, max y]</code>.</p>
        /// <p>The first 2 <code>bbox</code> parameters describe the lower southwest corner: </p>
        /// <ul>
        /// <li> <p>The first <code>bbox</code> position is the X coordinate or longitude of the lower southwest corner. </p> </li>
        /// <li> <p>The second <code>bbox</code> position is the Y coordinate or latitude of the lower southwest corner. </p> </li>
        /// </ul>
        /// <p>The next 2 <code>bbox</code> parameters describe the upper northeast corner: </p>
        /// <ul>
        /// <li> <p>The third <code>bbox</code> position is the X coordinate, or longitude of the upper northeast corner. </p> </li>
        /// <li> <p>The fourth <code>bbox</code> position is the Y coordinate, or latitude of the upper northeast corner. </p> </li>
        /// </ul>
        pub fn route_b_box(mut self, input: f64) -> Self {
            let mut v = self.route_b_box.unwrap_or_default();
            v.push(input);
            self.route_b_box = Some(v);
            self
        }
        /// <p>Specifies a geographical box surrounding a route. Used to zoom into a route when displaying it in a map. For example, <code>[min x, min y, max x, max y]</code>.</p>
        /// <p>The first 2 <code>bbox</code> parameters describe the lower southwest corner: </p>
        /// <ul>
        /// <li> <p>The first <code>bbox</code> position is the X coordinate or longitude of the lower southwest corner. </p> </li>
        /// <li> <p>The second <code>bbox</code> position is the Y coordinate or latitude of the lower southwest corner. </p> </li>
        /// </ul>
        /// <p>The next 2 <code>bbox</code> parameters describe the upper northeast corner: </p>
        /// <ul>
        /// <li> <p>The third <code>bbox</code> position is the X coordinate, or longitude of the upper northeast corner. </p> </li>
        /// <li> <p>The fourth <code>bbox</code> position is the Y coordinate, or latitude of the upper northeast corner. </p> </li>
        /// </ul>
        pub fn set_route_b_box(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.route_b_box = input;
            self
        }
        /// <p>The data provider of traffic and road network data used to calculate the route. Indicates one of the available providers:</p>
        /// <ul>
        /// <li> <p> <code>Esri</code> </p> </li>
        /// <li> <p> <code>Here</code> </p> </li>
        /// </ul>
        /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
        pub fn data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source = Some(input.into());
            self
        }
        /// <p>The data provider of traffic and road network data used to calculate the route. Indicates one of the available providers:</p>
        /// <ul>
        /// <li> <p> <code>Esri</code> </p> </li>
        /// <li> <p> <code>Here</code> </p> </li>
        /// </ul>
        /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
        pub fn set_data_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_source = input;
            self
        }
        /// <p>The total distance covered by the route. The sum of the distance travelled between every stop on the route.</p> <note>
        /// <p>If Esri is the data source for the route calculator, the route distance can’t be greater than 400 km. If the route exceeds 400 km, the response is a <code>400 RoutesValidationException</code> error.</p>
        /// </note>
        pub fn distance(mut self, input: f64) -> Self {
            self.distance = Some(input);
            self
        }
        /// <p>The total distance covered by the route. The sum of the distance travelled between every stop on the route.</p> <note>
        /// <p>If Esri is the data source for the route calculator, the route distance can’t be greater than 400 km. If the route exceeds 400 km, the response is a <code>400 RoutesValidationException</code> error.</p>
        /// </note>
        pub fn set_distance(mut self, input: std::option::Option<f64>) -> Self {
            self.distance = input;
            self
        }
        /// <p>The total travel time for the route measured in seconds. The sum of the travel time between every stop on the route.</p>
        pub fn duration_seconds(mut self, input: f64) -> Self {
            self.duration_seconds = Some(input);
            self
        }
        /// <p>The total travel time for the route measured in seconds. The sum of the travel time between every stop on the route.</p>
        pub fn set_duration_seconds(mut self, input: std::option::Option<f64>) -> Self {
            self.duration_seconds = input;
            self
        }
        /// <p>The unit of measurement for route distances.</p>
        pub fn distance_unit(mut self, input: crate::model::DistanceUnit) -> Self {
            self.distance_unit = Some(input);
            self
        }
        /// <p>The unit of measurement for route distances.</p>
        pub fn set_distance_unit(
            mut self,
            input: std::option::Option<crate::model::DistanceUnit>,
        ) -> Self {
            self.distance_unit = input;
            self
        }
        /// Consumes the builder and constructs a [`CalculateRouteSummary`](crate::model::CalculateRouteSummary)
        pub fn build(self) -> crate::model::CalculateRouteSummary {
            crate::model::CalculateRouteSummary {
                route_b_box: self.route_b_box,
                data_source: self.data_source,
                distance: self.distance,
                duration_seconds: self.duration_seconds,
                distance_unit: self.distance_unit,
            }
        }
    }
}
impl CalculateRouteSummary {
    /// Creates a new builder-style object to manufacture [`CalculateRouteSummary`](crate::model::CalculateRouteSummary)
    pub fn builder() -> crate::model::calculate_route_summary::Builder {
        crate::model::calculate_route_summary::Builder::default()
    }
}

/// <p>Contains the calculated route's details for each path between a pair of positions. The number of legs returned corresponds to one fewer than the total number of positions in the request. </p>
/// <p>For example, a route with a departure position and destination position returns one leg with the positions <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">snapped to a nearby road</a>:</p>
/// <ul>
/// <li> <p>The <code>StartPosition</code> is the departure position.</p> </li>
/// <li> <p>The <code>EndPosition</code> is the destination position.</p> </li>
/// </ul>
/// <p>A route with a waypoint between the departure and destination position returns two legs with the positions snapped to a nearby road:</p>
/// <ul>
/// <li> <p>Leg 1: The <code>StartPosition</code> is the departure position . The <code>EndPosition</code> is the waypoint positon.</p> </li>
/// <li> <p>Leg 2: The <code>StartPosition</code> is the waypoint position. The <code>EndPosition</code> is the destination position.</p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Leg {
    /// <p>The starting position of the leg. Follows the format <code>[longitude,latitude]</code>.</p> <note>
    /// <p>If the <code>StartPosition</code> isn't located on a road, it's <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">snapped to a nearby road</a>. </p>
    /// </note>
    pub start_position: std::option::Option<std::vec::Vec<f64>>,
    /// <p>The terminating position of the leg. Follows the format <code>[longitude,latitude]</code>.</p> <note>
    /// <p>If the <code>EndPosition</code> isn't located on a road, it's <a href="https://docs.aws.amazon.com/location/latest/developerguide/nap-to-nearby-road.html">snapped to a nearby road</a>. </p>
    /// </note>
    pub end_position: std::option::Option<std::vec::Vec<f64>>,
    /// <p>The distance between the leg's <code>StartPosition</code> and <code>EndPosition</code> along a calculated route. </p>
    /// <ul>
    /// <li> <p>The default measurement is <code>Kilometers</code> unless the request specifies a <code>DistanceUnit</code> of <code>Miles</code>.</p> </li>
    /// </ul>
    pub distance: std::option::Option<f64>,
    /// <p>The estimated travel time between the leg's <code>StartPosition</code> and <code>EndPosition</code>. The travel mode and departure time that you specify in the request determines the calculated time.</p>
    pub duration_seconds: std::option::Option<f64>,
    /// <p>Contains the calculated route's path as a linestring geometry.</p>
    pub geometry: std::option::Option<crate::model::LegGeometry>,
    /// <p>Contains a list of steps, which represent subsections of a leg. Each step provides instructions for how to move to the next step in the leg such as the step's start position, end position, travel distance, travel duration, and geometry offset.</p>
    pub steps: std::option::Option<std::vec::Vec<crate::model::Step>>,
}
impl Leg {
    /// <p>The starting position of the leg. Follows the format <code>[longitude,latitude]</code>.</p> <note>
    /// <p>If the <code>StartPosition</code> isn't located on a road, it's <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">snapped to a nearby road</a>. </p>
    /// </note>
    pub fn start_position(&self) -> std::option::Option<&[f64]> {
        self.start_position.as_deref()
    }
    /// <p>The terminating position of the leg. Follows the format <code>[longitude,latitude]</code>.</p> <note>
    /// <p>If the <code>EndPosition</code> isn't located on a road, it's <a href="https://docs.aws.amazon.com/location/latest/developerguide/nap-to-nearby-road.html">snapped to a nearby road</a>. </p>
    /// </note>
    pub fn end_position(&self) -> std::option::Option<&[f64]> {
        self.end_position.as_deref()
    }
    /// <p>The distance between the leg's <code>StartPosition</code> and <code>EndPosition</code> along a calculated route. </p>
    /// <ul>
    /// <li> <p>The default measurement is <code>Kilometers</code> unless the request specifies a <code>DistanceUnit</code> of <code>Miles</code>.</p> </li>
    /// </ul>
    pub fn distance(&self) -> std::option::Option<f64> {
        self.distance
    }
    /// <p>The estimated travel time between the leg's <code>StartPosition</code> and <code>EndPosition</code>. The travel mode and departure time that you specify in the request determines the calculated time.</p>
    pub fn duration_seconds(&self) -> std::option::Option<f64> {
        self.duration_seconds
    }
    /// <p>Contains the calculated route's path as a linestring geometry.</p>
    pub fn geometry(&self) -> std::option::Option<&crate::model::LegGeometry> {
        self.geometry.as_ref()
    }
    /// <p>Contains a list of steps, which represent subsections of a leg. Each step provides instructions for how to move to the next step in the leg such as the step's start position, end position, travel distance, travel duration, and geometry offset.</p>
    pub fn steps(&self) -> std::option::Option<&[crate::model::Step]> {
        self.steps.as_deref()
    }
}
impl std::fmt::Debug for Leg {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Leg");
        formatter.field("start_position", &"*** Sensitive Data Redacted ***");
        formatter.field("end_position", &"*** Sensitive Data Redacted ***");
        formatter.field("distance", &self.distance);
        formatter.field("duration_seconds", &self.duration_seconds);
        formatter.field("geometry", &self.geometry);
        formatter.field("steps", &self.steps);
        formatter.finish()
    }
}
/// See [`Leg`](crate::model::Leg)
pub mod leg {
    /// A builder for [`Leg`](crate::model::Leg)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_position: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) end_position: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) distance: std::option::Option<f64>,
        pub(crate) duration_seconds: std::option::Option<f64>,
        pub(crate) geometry: std::option::Option<crate::model::LegGeometry>,
        pub(crate) steps: std::option::Option<std::vec::Vec<crate::model::Step>>,
    }
    impl Builder {
        /// Appends an item to `start_position`.
        ///
        /// To override the contents of this collection use [`set_start_position`](Self::set_start_position).
        ///
        /// <p>The starting position of the leg. Follows the format <code>[longitude,latitude]</code>.</p> <note>
        /// <p>If the <code>StartPosition</code> isn't located on a road, it's <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">snapped to a nearby road</a>. </p>
        /// </note>
        pub fn start_position(mut self, input: f64) -> Self {
            let mut v = self.start_position.unwrap_or_default();
            v.push(input);
            self.start_position = Some(v);
            self
        }
        /// <p>The starting position of the leg. Follows the format <code>[longitude,latitude]</code>.</p> <note>
        /// <p>If the <code>StartPosition</code> isn't located on a road, it's <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">snapped to a nearby road</a>. </p>
        /// </note>
        pub fn set_start_position(
            mut self,
            input: std::option::Option<std::vec::Vec<f64>>,
        ) -> Self {
            self.start_position = input;
            self
        }
        /// Appends an item to `end_position`.
        ///
        /// To override the contents of this collection use [`set_end_position`](Self::set_end_position).
        ///
        /// <p>The terminating position of the leg. Follows the format <code>[longitude,latitude]</code>.</p> <note>
        /// <p>If the <code>EndPosition</code> isn't located on a road, it's <a href="https://docs.aws.amazon.com/location/latest/developerguide/nap-to-nearby-road.html">snapped to a nearby road</a>. </p>
        /// </note>
        pub fn end_position(mut self, input: f64) -> Self {
            let mut v = self.end_position.unwrap_or_default();
            v.push(input);
            self.end_position = Some(v);
            self
        }
        /// <p>The terminating position of the leg. Follows the format <code>[longitude,latitude]</code>.</p> <note>
        /// <p>If the <code>EndPosition</code> isn't located on a road, it's <a href="https://docs.aws.amazon.com/location/latest/developerguide/nap-to-nearby-road.html">snapped to a nearby road</a>. </p>
        /// </note>
        pub fn set_end_position(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.end_position = input;
            self
        }
        /// <p>The distance between the leg's <code>StartPosition</code> and <code>EndPosition</code> along a calculated route. </p>
        /// <ul>
        /// <li> <p>The default measurement is <code>Kilometers</code> unless the request specifies a <code>DistanceUnit</code> of <code>Miles</code>.</p> </li>
        /// </ul>
        pub fn distance(mut self, input: f64) -> Self {
            self.distance = Some(input);
            self
        }
        /// <p>The distance between the leg's <code>StartPosition</code> and <code>EndPosition</code> along a calculated route. </p>
        /// <ul>
        /// <li> <p>The default measurement is <code>Kilometers</code> unless the request specifies a <code>DistanceUnit</code> of <code>Miles</code>.</p> </li>
        /// </ul>
        pub fn set_distance(mut self, input: std::option::Option<f64>) -> Self {
            self.distance = input;
            self
        }
        /// <p>The estimated travel time between the leg's <code>StartPosition</code> and <code>EndPosition</code>. The travel mode and departure time that you specify in the request determines the calculated time.</p>
        pub fn duration_seconds(mut self, input: f64) -> Self {
            self.duration_seconds = Some(input);
            self
        }
        /// <p>The estimated travel time between the leg's <code>StartPosition</code> and <code>EndPosition</code>. The travel mode and departure time that you specify in the request determines the calculated time.</p>
        pub fn set_duration_seconds(mut self, input: std::option::Option<f64>) -> Self {
            self.duration_seconds = input;
            self
        }
        /// <p>Contains the calculated route's path as a linestring geometry.</p>
        pub fn geometry(mut self, input: crate::model::LegGeometry) -> Self {
            self.geometry = Some(input);
            self
        }
        /// <p>Contains the calculated route's path as a linestring geometry.</p>
        pub fn set_geometry(
            mut self,
            input: std::option::Option<crate::model::LegGeometry>,
        ) -> Self {
            self.geometry = input;
            self
        }
        /// Appends an item to `steps`.
        ///
        /// To override the contents of this collection use [`set_steps`](Self::set_steps).
        ///
        /// <p>Contains a list of steps, which represent subsections of a leg. Each step provides instructions for how to move to the next step in the leg such as the step's start position, end position, travel distance, travel duration, and geometry offset.</p>
        pub fn steps(mut self, input: crate::model::Step) -> Self {
            let mut v = self.steps.unwrap_or_default();
            v.push(input);
            self.steps = Some(v);
            self
        }
        /// <p>Contains a list of steps, which represent subsections of a leg. Each step provides instructions for how to move to the next step in the leg such as the step's start position, end position, travel distance, travel duration, and geometry offset.</p>
        pub fn set_steps(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Step>>,
        ) -> Self {
            self.steps = input;
            self
        }
        /// Consumes the builder and constructs a [`Leg`](crate::model::Leg)
        pub fn build(self) -> crate::model::Leg {
            crate::model::Leg {
                start_position: self.start_position,
                end_position: self.end_position,
                distance: self.distance,
                duration_seconds: self.duration_seconds,
                geometry: self.geometry,
                steps: self.steps,
            }
        }
    }
}
impl Leg {
    /// Creates a new builder-style object to manufacture [`Leg`](crate::model::Leg)
    pub fn builder() -> crate::model::leg::Builder {
        crate::model::leg::Builder::default()
    }
}

/// <p> Represents an element of a leg within a route. A step contains instructions for how to move to the next step in the leg. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Step {
    /// <p>The starting position of a step. If the position is the first step in the leg, this position is the same as the start position of the leg.</p>
    pub start_position: std::option::Option<std::vec::Vec<f64>>,
    /// <p>The end position of a step. If the position the last step in the leg, this position is the same as the end position of the leg.</p>
    pub end_position: std::option::Option<std::vec::Vec<f64>>,
    /// <p>The travel distance between the step's <code>StartPosition</code> and <code>EndPosition</code>.</p>
    pub distance: std::option::Option<f64>,
    /// <p>The estimated travel time, in seconds, from the step's <code>StartPosition</code> to the <code>EndPosition</code>. . The travel mode and departure time that you specify in the request determines the calculated time.</p>
    pub duration_seconds: std::option::Option<f64>,
    /// <p>Represents the start position, or index, in a sequence of steps within the leg's line string geometry. For example, the index of the first step in a leg geometry is <code>0</code>. </p>
    /// <p>Included in the response for queries that set <code>IncludeLegGeometry</code> to <code>True</code>. </p>
    pub geometry_offset: std::option::Option<i32>,
}
impl Step {
    /// <p>The starting position of a step. If the position is the first step in the leg, this position is the same as the start position of the leg.</p>
    pub fn start_position(&self) -> std::option::Option<&[f64]> {
        self.start_position.as_deref()
    }
    /// <p>The end position of a step. If the position the last step in the leg, this position is the same as the end position of the leg.</p>
    pub fn end_position(&self) -> std::option::Option<&[f64]> {
        self.end_position.as_deref()
    }
    /// <p>The travel distance between the step's <code>StartPosition</code> and <code>EndPosition</code>.</p>
    pub fn distance(&self) -> std::option::Option<f64> {
        self.distance
    }
    /// <p>The estimated travel time, in seconds, from the step's <code>StartPosition</code> to the <code>EndPosition</code>. . The travel mode and departure time that you specify in the request determines the calculated time.</p>
    pub fn duration_seconds(&self) -> std::option::Option<f64> {
        self.duration_seconds
    }
    /// <p>Represents the start position, or index, in a sequence of steps within the leg's line string geometry. For example, the index of the first step in a leg geometry is <code>0</code>. </p>
    /// <p>Included in the response for queries that set <code>IncludeLegGeometry</code> to <code>True</code>. </p>
    pub fn geometry_offset(&self) -> std::option::Option<i32> {
        self.geometry_offset
    }
}
impl std::fmt::Debug for Step {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Step");
        formatter.field("start_position", &"*** Sensitive Data Redacted ***");
        formatter.field("end_position", &"*** Sensitive Data Redacted ***");
        formatter.field("distance", &self.distance);
        formatter.field("duration_seconds", &self.duration_seconds);
        formatter.field("geometry_offset", &self.geometry_offset);
        formatter.finish()
    }
}
/// See [`Step`](crate::model::Step)
pub mod step {
    /// A builder for [`Step`](crate::model::Step)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_position: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) end_position: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) distance: std::option::Option<f64>,
        pub(crate) duration_seconds: std::option::Option<f64>,
        pub(crate) geometry_offset: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `start_position`.
        ///
        /// To override the contents of this collection use [`set_start_position`](Self::set_start_position).
        ///
        /// <p>The starting position of a step. If the position is the first step in the leg, this position is the same as the start position of the leg.</p>
        pub fn start_position(mut self, input: f64) -> Self {
            let mut v = self.start_position.unwrap_or_default();
            v.push(input);
            self.start_position = Some(v);
            self
        }
        /// <p>The starting position of a step. If the position is the first step in the leg, this position is the same as the start position of the leg.</p>
        pub fn set_start_position(
            mut self,
            input: std::option::Option<std::vec::Vec<f64>>,
        ) -> Self {
            self.start_position = input;
            self
        }
        /// Appends an item to `end_position`.
        ///
        /// To override the contents of this collection use [`set_end_position`](Self::set_end_position).
        ///
        /// <p>The end position of a step. If the position the last step in the leg, this position is the same as the end position of the leg.</p>
        pub fn end_position(mut self, input: f64) -> Self {
            let mut v = self.end_position.unwrap_or_default();
            v.push(input);
            self.end_position = Some(v);
            self
        }
        /// <p>The end position of a step. If the position the last step in the leg, this position is the same as the end position of the leg.</p>
        pub fn set_end_position(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.end_position = input;
            self
        }
        /// <p>The travel distance between the step's <code>StartPosition</code> and <code>EndPosition</code>.</p>
        pub fn distance(mut self, input: f64) -> Self {
            self.distance = Some(input);
            self
        }
        /// <p>The travel distance between the step's <code>StartPosition</code> and <code>EndPosition</code>.</p>
        pub fn set_distance(mut self, input: std::option::Option<f64>) -> Self {
            self.distance = input;
            self
        }
        /// <p>The estimated travel time, in seconds, from the step's <code>StartPosition</code> to the <code>EndPosition</code>. . The travel mode and departure time that you specify in the request determines the calculated time.</p>
        pub fn duration_seconds(mut self, input: f64) -> Self {
            self.duration_seconds = Some(input);
            self
        }
        /// <p>The estimated travel time, in seconds, from the step's <code>StartPosition</code> to the <code>EndPosition</code>. . The travel mode and departure time that you specify in the request determines the calculated time.</p>
        pub fn set_duration_seconds(mut self, input: std::option::Option<f64>) -> Self {
            self.duration_seconds = input;
            self
        }
        /// <p>Represents the start position, or index, in a sequence of steps within the leg's line string geometry. For example, the index of the first step in a leg geometry is <code>0</code>. </p>
        /// <p>Included in the response for queries that set <code>IncludeLegGeometry</code> to <code>True</code>. </p>
        pub fn geometry_offset(mut self, input: i32) -> Self {
            self.geometry_offset = Some(input);
            self
        }
        /// <p>Represents the start position, or index, in a sequence of steps within the leg's line string geometry. For example, the index of the first step in a leg geometry is <code>0</code>. </p>
        /// <p>Included in the response for queries that set <code>IncludeLegGeometry</code> to <code>True</code>. </p>
        pub fn set_geometry_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.geometry_offset = input;
            self
        }
        /// Consumes the builder and constructs a [`Step`](crate::model::Step)
        pub fn build(self) -> crate::model::Step {
            crate::model::Step {
                start_position: self.start_position,
                end_position: self.end_position,
                distance: self.distance,
                duration_seconds: self.duration_seconds,
                geometry_offset: self.geometry_offset,
            }
        }
    }
}
impl Step {
    /// Creates a new builder-style object to manufacture [`Step`](crate::model::Step)
    pub fn builder() -> crate::model::step::Builder {
        crate::model::step::Builder::default()
    }
}

/// <p>Contains the geometry details for each path between a pair of positions. Used in plotting a route leg on a map.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LegGeometry {
    /// <p>An ordered list of positions used to plot a route on a map. </p>
    /// <p>The first position is closest to the start position for the leg, and the last position is the closest to the end position for the leg.</p>
    /// <ul>
    /// <li> <p>For example, <code>[[-123.117, 49.284],[-123.115, 49.285],[-123.115, 49.285]]</code> </p> </li>
    /// </ul>
    pub line_string: std::option::Option<std::vec::Vec<std::vec::Vec<f64>>>,
}
impl LegGeometry {
    /// <p>An ordered list of positions used to plot a route on a map. </p>
    /// <p>The first position is closest to the start position for the leg, and the last position is the closest to the end position for the leg.</p>
    /// <ul>
    /// <li> <p>For example, <code>[[-123.117, 49.284],[-123.115, 49.285],[-123.115, 49.285]]</code> </p> </li>
    /// </ul>
    pub fn line_string(&self) -> std::option::Option<&[std::vec::Vec<f64>]> {
        self.line_string.as_deref()
    }
}
impl std::fmt::Debug for LegGeometry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LegGeometry");
        formatter.field("line_string", &self.line_string);
        formatter.finish()
    }
}
/// See [`LegGeometry`](crate::model::LegGeometry)
pub mod leg_geometry {
    /// A builder for [`LegGeometry`](crate::model::LegGeometry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) line_string: std::option::Option<std::vec::Vec<std::vec::Vec<f64>>>,
    }
    impl Builder {
        /// Appends an item to `line_string`.
        ///
        /// To override the contents of this collection use [`set_line_string`](Self::set_line_string).
        ///
        /// <p>An ordered list of positions used to plot a route on a map. </p>
        /// <p>The first position is closest to the start position for the leg, and the last position is the closest to the end position for the leg.</p>
        /// <ul>
        /// <li> <p>For example, <code>[[-123.117, 49.284],[-123.115, 49.285],[-123.115, 49.285]]</code> </p> </li>
        /// </ul>
        pub fn line_string(mut self, input: std::vec::Vec<f64>) -> Self {
            let mut v = self.line_string.unwrap_or_default();
            v.push(input);
            self.line_string = Some(v);
            self
        }
        /// <p>An ordered list of positions used to plot a route on a map. </p>
        /// <p>The first position is closest to the start position for the leg, and the last position is the closest to the end position for the leg.</p>
        /// <ul>
        /// <li> <p>For example, <code>[[-123.117, 49.284],[-123.115, 49.285],[-123.115, 49.285]]</code> </p> </li>
        /// </ul>
        pub fn set_line_string(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<f64>>>,
        ) -> Self {
            self.line_string = input;
            self
        }
        /// Consumes the builder and constructs a [`LegGeometry`](crate::model::LegGeometry)
        pub fn build(self) -> crate::model::LegGeometry {
            crate::model::LegGeometry {
                line_string: self.line_string,
            }
        }
    }
}
impl LegGeometry {
    /// Creates a new builder-style object to manufacture [`LegGeometry`](crate::model::LegGeometry)
    pub fn builder() -> crate::model::leg_geometry::Builder {
        crate::model::leg_geometry::Builder::default()
    }
}

/// <p>A route calculator resource listed in your AWS account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRouteCalculatorsResponseEntry {
    /// <p>The name of the route calculator resource.</p>
    pub calculator_name: std::option::Option<std::string::String>,
    /// <p>The optional description of the route calculator resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The data provider of traffic and road network data. Indicates one of the available providers:</p>
    /// <ul>
    /// <li> <p> <code>Esri</code> </p> </li>
    /// <li> <p> <code>Here</code> </p> </li>
    /// </ul>
    /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
    pub data_source: std::option::Option<std::string::String>,
    /// <p>Always returns <code>RequestBasedUsage</code>.</p>
    pub pricing_plan: std::option::Option<crate::model::PricingPlan>,
    /// <p>The timestamp when the route calculator resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    /// <ul>
    /// <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
    /// </ul>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp when the route calculator resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    /// <ul>
    /// <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
    /// </ul>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ListRouteCalculatorsResponseEntry {
    /// <p>The name of the route calculator resource.</p>
    pub fn calculator_name(&self) -> std::option::Option<&str> {
        self.calculator_name.as_deref()
    }
    /// <p>The optional description of the route calculator resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The data provider of traffic and road network data. Indicates one of the available providers:</p>
    /// <ul>
    /// <li> <p> <code>Esri</code> </p> </li>
    /// <li> <p> <code>Here</code> </p> </li>
    /// </ul>
    /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
    pub fn data_source(&self) -> std::option::Option<&str> {
        self.data_source.as_deref()
    }
    /// <p>Always returns <code>RequestBasedUsage</code>.</p>
    pub fn pricing_plan(&self) -> std::option::Option<&crate::model::PricingPlan> {
        self.pricing_plan.as_ref()
    }
    /// <p>The timestamp when the route calculator resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    /// <ul>
    /// <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
    /// </ul>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
    /// <p>The timestamp when the route calculator resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    /// <ul>
    /// <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
    /// </ul>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
}
impl std::fmt::Debug for ListRouteCalculatorsResponseEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRouteCalculatorsResponseEntry");
        formatter.field("calculator_name", &self.calculator_name);
        formatter.field("description", &self.description);
        formatter.field("data_source", &self.data_source);
        formatter.field("pricing_plan", &self.pricing_plan);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`ListRouteCalculatorsResponseEntry`](crate::model::ListRouteCalculatorsResponseEntry)
pub mod list_route_calculators_response_entry {
    /// A builder for [`ListRouteCalculatorsResponseEntry`](crate::model::ListRouteCalculatorsResponseEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) calculator_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) data_source: std::option::Option<std::string::String>,
        pub(crate) pricing_plan: std::option::Option<crate::model::PricingPlan>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the route calculator resource.</p>
        pub fn calculator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.calculator_name = Some(input.into());
            self
        }
        /// <p>The name of the route calculator resource.</p>
        pub fn set_calculator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.calculator_name = input;
            self
        }
        /// <p>The optional description of the route calculator resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The optional description of the route calculator resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The data provider of traffic and road network data. Indicates one of the available providers:</p>
        /// <ul>
        /// <li> <p> <code>Esri</code> </p> </li>
        /// <li> <p> <code>Here</code> </p> </li>
        /// </ul>
        /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
        pub fn data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source = Some(input.into());
            self
        }
        /// <p>The data provider of traffic and road network data. Indicates one of the available providers:</p>
        /// <ul>
        /// <li> <p> <code>Esri</code> </p> </li>
        /// <li> <p> <code>Here</code> </p> </li>
        /// </ul>
        /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
        pub fn set_data_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_source = input;
            self
        }
        /// <p>Always returns <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.pricing_plan = Some(input);
            self
        }
        /// <p>Always returns <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.pricing_plan = input;
            self
        }
        /// <p>The timestamp when the route calculator resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        /// <ul>
        /// <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
        /// </ul>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp when the route calculator resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        /// <ul>
        /// <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
        /// </ul>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The timestamp when the route calculator resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        /// <ul>
        /// <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
        /// </ul>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>The timestamp when the route calculator resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        /// <ul>
        /// <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
        /// </ul>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRouteCalculatorsResponseEntry`](crate::model::ListRouteCalculatorsResponseEntry)
        pub fn build(self) -> crate::model::ListRouteCalculatorsResponseEntry {
            crate::model::ListRouteCalculatorsResponseEntry {
                calculator_name: self.calculator_name,
                description: self.description,
                data_source: self.data_source,
                pricing_plan: self.pricing_plan,
                create_time: self.create_time,
                update_time: self.update_time,
            }
        }
    }
}
impl ListRouteCalculatorsResponseEntry {
    /// Creates a new builder-style object to manufacture [`ListRouteCalculatorsResponseEntry`](crate::model::ListRouteCalculatorsResponseEntry)
    pub fn builder() -> crate::model::list_route_calculators_response_entry::Builder {
        crate::model::list_route_calculators_response_entry::Builder::default()
    }
}

/// <p>Contains a search result from a text search query that is run on a place index resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchForTextResult {
    /// <p>Details about the search result, such as its address and position.</p>
    pub place: std::option::Option<crate::model::Place>,
    /// <p>The distance in meters of a great-circle arc between the bias position specified and the result. <code>Distance</code> will be returned only if a bias position was specified in the query.</p> <note>
    /// <p>A great-circle arc is the shortest path on a sphere, in this case the Earth. This returns the shortest distance between two locations.</p>
    /// </note>
    pub distance: std::option::Option<f64>,
    /// <p>The relative confidence in the match for a result among the results returned. For example, if more fields for an address match (including house number, street, city, country/region, and postal code), the relevance score is closer to 1.</p>
    /// <p>Returned only when the partner selected is Esri.</p>
    pub relevance: std::option::Option<f64>,
}
impl SearchForTextResult {
    /// <p>Details about the search result, such as its address and position.</p>
    pub fn place(&self) -> std::option::Option<&crate::model::Place> {
        self.place.as_ref()
    }
    /// <p>The distance in meters of a great-circle arc between the bias position specified and the result. <code>Distance</code> will be returned only if a bias position was specified in the query.</p> <note>
    /// <p>A great-circle arc is the shortest path on a sphere, in this case the Earth. This returns the shortest distance between two locations.</p>
    /// </note>
    pub fn distance(&self) -> std::option::Option<f64> {
        self.distance
    }
    /// <p>The relative confidence in the match for a result among the results returned. For example, if more fields for an address match (including house number, street, city, country/region, and postal code), the relevance score is closer to 1.</p>
    /// <p>Returned only when the partner selected is Esri.</p>
    pub fn relevance(&self) -> std::option::Option<f64> {
        self.relevance
    }
}
impl std::fmt::Debug for SearchForTextResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchForTextResult");
        formatter.field("place", &self.place);
        formatter.field("distance", &self.distance);
        formatter.field("relevance", &self.relevance);
        formatter.finish()
    }
}
/// See [`SearchForTextResult`](crate::model::SearchForTextResult)
pub mod search_for_text_result {
    /// A builder for [`SearchForTextResult`](crate::model::SearchForTextResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) place: std::option::Option<crate::model::Place>,
        pub(crate) distance: std::option::Option<f64>,
        pub(crate) relevance: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>Details about the search result, such as its address and position.</p>
        pub fn place(mut self, input: crate::model::Place) -> Self {
            self.place = Some(input);
            self
        }
        /// <p>Details about the search result, such as its address and position.</p>
        pub fn set_place(mut self, input: std::option::Option<crate::model::Place>) -> Self {
            self.place = input;
            self
        }
        /// <p>The distance in meters of a great-circle arc between the bias position specified and the result. <code>Distance</code> will be returned only if a bias position was specified in the query.</p> <note>
        /// <p>A great-circle arc is the shortest path on a sphere, in this case the Earth. This returns the shortest distance between two locations.</p>
        /// </note>
        pub fn distance(mut self, input: f64) -> Self {
            self.distance = Some(input);
            self
        }
        /// <p>The distance in meters of a great-circle arc between the bias position specified and the result. <code>Distance</code> will be returned only if a bias position was specified in the query.</p> <note>
        /// <p>A great-circle arc is the shortest path on a sphere, in this case the Earth. This returns the shortest distance between two locations.</p>
        /// </note>
        pub fn set_distance(mut self, input: std::option::Option<f64>) -> Self {
            self.distance = input;
            self
        }
        /// <p>The relative confidence in the match for a result among the results returned. For example, if more fields for an address match (including house number, street, city, country/region, and postal code), the relevance score is closer to 1.</p>
        /// <p>Returned only when the partner selected is Esri.</p>
        pub fn relevance(mut self, input: f64) -> Self {
            self.relevance = Some(input);
            self
        }
        /// <p>The relative confidence in the match for a result among the results returned. For example, if more fields for an address match (including house number, street, city, country/region, and postal code), the relevance score is closer to 1.</p>
        /// <p>Returned only when the partner selected is Esri.</p>
        pub fn set_relevance(mut self, input: std::option::Option<f64>) -> Self {
            self.relevance = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchForTextResult`](crate::model::SearchForTextResult)
        pub fn build(self) -> crate::model::SearchForTextResult {
            crate::model::SearchForTextResult {
                place: self.place,
                distance: self.distance,
                relevance: self.relevance,
            }
        }
    }
}
impl SearchForTextResult {
    /// Creates a new builder-style object to manufacture [`SearchForTextResult`](crate::model::SearchForTextResult)
    pub fn builder() -> crate::model::search_for_text_result::Builder {
        crate::model::search_for_text_result::Builder::default()
    }
}

/// <p>Contains details about addresses or points of interest that match the search criteria.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Place {
    /// <p>The full name and address of the point of interest such as a city, region, or country. For example, <code>123 Any Street, Any Town, USA</code>.</p>
    pub label: std::option::Option<std::string::String>,
    /// <p>Places uses a point geometry to specify a location or a Place.</p>
    pub geometry: std::option::Option<crate::model::PlaceGeometry>,
    /// <p>The numerical portion of an address, such as a building number. </p>
    pub address_number: std::option::Option<std::string::String>,
    /// <p>The name for a street or a road to identify a location. For example, <code>Main Street</code>.</p>
    pub street: std::option::Option<std::string::String>,
    /// <p>The name of a community district. For example, <code>Downtown</code>.</p>
    pub neighborhood: std::option::Option<std::string::String>,
    /// <p>A name for a local area, such as a city or town name. For example, <code>Toronto</code>.</p>
    pub municipality: std::option::Option<std::string::String>,
    /// <p>A country, or an area that's part of a larger region. For example, <code>Metro Vancouver</code>.</p>
    pub sub_region: std::option::Option<std::string::String>,
    /// <p>A name for an area or geographical division, such as a province or state name. For example, <code>British Columbia</code>.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>A country/region specified using <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country/region code. For example, <code>CAN</code>.</p>
    pub country: std::option::Option<std::string::String>,
    /// <p>A group of numbers and letters in a country-specific format, which accompanies the address for the purpose of identifying a location. </p>
    pub postal_code: std::option::Option<std::string::String>,
    /// <p> <code>True</code> if the result is interpolated from other known places.</p>
    /// <p> <code>False</code> if the Place is a known place.</p>
    /// <p>Not returned when the partner does not provide the information.</p>
    /// <p>For example, returns <code>False</code> for an address location that is found in the partner data, but returns <code>True</code> if an address does not exist in the partner data and its location is calculated by interpolating between other known addresses. </p>
    pub interpolated: std::option::Option<bool>,
    /// <p>The time zone in which the <code>Place</code> is located. Returned only when using Here as the selected partner.</p>
    pub time_zone: std::option::Option<crate::model::TimeZone>,
}
impl Place {
    /// <p>The full name and address of the point of interest such as a city, region, or country. For example, <code>123 Any Street, Any Town, USA</code>.</p>
    pub fn label(&self) -> std::option::Option<&str> {
        self.label.as_deref()
    }
    /// <p>Places uses a point geometry to specify a location or a Place.</p>
    pub fn geometry(&self) -> std::option::Option<&crate::model::PlaceGeometry> {
        self.geometry.as_ref()
    }
    /// <p>The numerical portion of an address, such as a building number. </p>
    pub fn address_number(&self) -> std::option::Option<&str> {
        self.address_number.as_deref()
    }
    /// <p>The name for a street or a road to identify a location. For example, <code>Main Street</code>.</p>
    pub fn street(&self) -> std::option::Option<&str> {
        self.street.as_deref()
    }
    /// <p>The name of a community district. For example, <code>Downtown</code>.</p>
    pub fn neighborhood(&self) -> std::option::Option<&str> {
        self.neighborhood.as_deref()
    }
    /// <p>A name for a local area, such as a city or town name. For example, <code>Toronto</code>.</p>
    pub fn municipality(&self) -> std::option::Option<&str> {
        self.municipality.as_deref()
    }
    /// <p>A country, or an area that's part of a larger region. For example, <code>Metro Vancouver</code>.</p>
    pub fn sub_region(&self) -> std::option::Option<&str> {
        self.sub_region.as_deref()
    }
    /// <p>A name for an area or geographical division, such as a province or state name. For example, <code>British Columbia</code>.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>A country/region specified using <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country/region code. For example, <code>CAN</code>.</p>
    pub fn country(&self) -> std::option::Option<&str> {
        self.country.as_deref()
    }
    /// <p>A group of numbers and letters in a country-specific format, which accompanies the address for the purpose of identifying a location. </p>
    pub fn postal_code(&self) -> std::option::Option<&str> {
        self.postal_code.as_deref()
    }
    /// <p> <code>True</code> if the result is interpolated from other known places.</p>
    /// <p> <code>False</code> if the Place is a known place.</p>
    /// <p>Not returned when the partner does not provide the information.</p>
    /// <p>For example, returns <code>False</code> for an address location that is found in the partner data, but returns <code>True</code> if an address does not exist in the partner data and its location is calculated by interpolating between other known addresses. </p>
    pub fn interpolated(&self) -> std::option::Option<bool> {
        self.interpolated
    }
    /// <p>The time zone in which the <code>Place</code> is located. Returned only when using Here as the selected partner.</p>
    pub fn time_zone(&self) -> std::option::Option<&crate::model::TimeZone> {
        self.time_zone.as_ref()
    }
}
impl std::fmt::Debug for Place {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Place");
        formatter.field("label", &self.label);
        formatter.field("geometry", &self.geometry);
        formatter.field("address_number", &self.address_number);
        formatter.field("street", &self.street);
        formatter.field("neighborhood", &self.neighborhood);
        formatter.field("municipality", &self.municipality);
        formatter.field("sub_region", &self.sub_region);
        formatter.field("region", &self.region);
        formatter.field("country", &self.country);
        formatter.field("postal_code", &self.postal_code);
        formatter.field("interpolated", &self.interpolated);
        formatter.field("time_zone", &self.time_zone);
        formatter.finish()
    }
}
/// See [`Place`](crate::model::Place)
pub mod place {
    /// A builder for [`Place`](crate::model::Place)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) label: std::option::Option<std::string::String>,
        pub(crate) geometry: std::option::Option<crate::model::PlaceGeometry>,
        pub(crate) address_number: std::option::Option<std::string::String>,
        pub(crate) street: std::option::Option<std::string::String>,
        pub(crate) neighborhood: std::option::Option<std::string::String>,
        pub(crate) municipality: std::option::Option<std::string::String>,
        pub(crate) sub_region: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) country: std::option::Option<std::string::String>,
        pub(crate) postal_code: std::option::Option<std::string::String>,
        pub(crate) interpolated: std::option::Option<bool>,
        pub(crate) time_zone: std::option::Option<crate::model::TimeZone>,
    }
    impl Builder {
        /// <p>The full name and address of the point of interest such as a city, region, or country. For example, <code>123 Any Street, Any Town, USA</code>.</p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.label = Some(input.into());
            self
        }
        /// <p>The full name and address of the point of interest such as a city, region, or country. For example, <code>123 Any Street, Any Town, USA</code>.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.label = input;
            self
        }
        /// <p>Places uses a point geometry to specify a location or a Place.</p>
        pub fn geometry(mut self, input: crate::model::PlaceGeometry) -> Self {
            self.geometry = Some(input);
            self
        }
        /// <p>Places uses a point geometry to specify a location or a Place.</p>
        pub fn set_geometry(
            mut self,
            input: std::option::Option<crate::model::PlaceGeometry>,
        ) -> Self {
            self.geometry = input;
            self
        }
        /// <p>The numerical portion of an address, such as a building number. </p>
        pub fn address_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.address_number = Some(input.into());
            self
        }
        /// <p>The numerical portion of an address, such as a building number. </p>
        pub fn set_address_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.address_number = input;
            self
        }
        /// <p>The name for a street or a road to identify a location. For example, <code>Main Street</code>.</p>
        pub fn street(mut self, input: impl Into<std::string::String>) -> Self {
            self.street = Some(input.into());
            self
        }
        /// <p>The name for a street or a road to identify a location. For example, <code>Main Street</code>.</p>
        pub fn set_street(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.street = input;
            self
        }
        /// <p>The name of a community district. For example, <code>Downtown</code>.</p>
        pub fn neighborhood(mut self, input: impl Into<std::string::String>) -> Self {
            self.neighborhood = Some(input.into());
            self
        }
        /// <p>The name of a community district. For example, <code>Downtown</code>.</p>
        pub fn set_neighborhood(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.neighborhood = input;
            self
        }
        /// <p>A name for a local area, such as a city or town name. For example, <code>Toronto</code>.</p>
        pub fn municipality(mut self, input: impl Into<std::string::String>) -> Self {
            self.municipality = Some(input.into());
            self
        }
        /// <p>A name for a local area, such as a city or town name. For example, <code>Toronto</code>.</p>
        pub fn set_municipality(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.municipality = input;
            self
        }
        /// <p>A country, or an area that's part of a larger region. For example, <code>Metro Vancouver</code>.</p>
        pub fn sub_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.sub_region = Some(input.into());
            self
        }
        /// <p>A country, or an area that's part of a larger region. For example, <code>Metro Vancouver</code>.</p>
        pub fn set_sub_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sub_region = input;
            self
        }
        /// <p>A name for an area or geographical division, such as a province or state name. For example, <code>British Columbia</code>.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>A name for an area or geographical division, such as a province or state name. For example, <code>British Columbia</code>.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>A country/region specified using <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country/region code. For example, <code>CAN</code>.</p>
        pub fn country(mut self, input: impl Into<std::string::String>) -> Self {
            self.country = Some(input.into());
            self
        }
        /// <p>A country/region specified using <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit country/region code. For example, <code>CAN</code>.</p>
        pub fn set_country(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.country = input;
            self
        }
        /// <p>A group of numbers and letters in a country-specific format, which accompanies the address for the purpose of identifying a location. </p>
        pub fn postal_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.postal_code = Some(input.into());
            self
        }
        /// <p>A group of numbers and letters in a country-specific format, which accompanies the address for the purpose of identifying a location. </p>
        pub fn set_postal_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.postal_code = input;
            self
        }
        /// <p> <code>True</code> if the result is interpolated from other known places.</p>
        /// <p> <code>False</code> if the Place is a known place.</p>
        /// <p>Not returned when the partner does not provide the information.</p>
        /// <p>For example, returns <code>False</code> for an address location that is found in the partner data, but returns <code>True</code> if an address does not exist in the partner data and its location is calculated by interpolating between other known addresses. </p>
        pub fn interpolated(mut self, input: bool) -> Self {
            self.interpolated = Some(input);
            self
        }
        /// <p> <code>True</code> if the result is interpolated from other known places.</p>
        /// <p> <code>False</code> if the Place is a known place.</p>
        /// <p>Not returned when the partner does not provide the information.</p>
        /// <p>For example, returns <code>False</code> for an address location that is found in the partner data, but returns <code>True</code> if an address does not exist in the partner data and its location is calculated by interpolating between other known addresses. </p>
        pub fn set_interpolated(mut self, input: std::option::Option<bool>) -> Self {
            self.interpolated = input;
            self
        }
        /// <p>The time zone in which the <code>Place</code> is located. Returned only when using Here as the selected partner.</p>
        pub fn time_zone(mut self, input: crate::model::TimeZone) -> Self {
            self.time_zone = Some(input);
            self
        }
        /// <p>The time zone in which the <code>Place</code> is located. Returned only when using Here as the selected partner.</p>
        pub fn set_time_zone(mut self, input: std::option::Option<crate::model::TimeZone>) -> Self {
            self.time_zone = input;
            self
        }
        /// Consumes the builder and constructs a [`Place`](crate::model::Place)
        pub fn build(self) -> crate::model::Place {
            crate::model::Place {
                label: self.label,
                geometry: self.geometry,
                address_number: self.address_number,
                street: self.street,
                neighborhood: self.neighborhood,
                municipality: self.municipality,
                sub_region: self.sub_region,
                region: self.region,
                country: self.country,
                postal_code: self.postal_code,
                interpolated: self.interpolated,
                time_zone: self.time_zone,
            }
        }
    }
}
impl Place {
    /// Creates a new builder-style object to manufacture [`Place`](crate::model::Place)
    pub fn builder() -> crate::model::place::Builder {
        crate::model::place::Builder::default()
    }
}

/// <p>Information about a time zone. Includes the name of the time zone and the offset from UTC in seconds.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimeZone {
    /// <p>The name of the time zone, following the <a href="https://www.iana.org/time-zones"> IANA time zone standard</a>. For example, <code>America/Los_Angeles</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The time zone's offset, in seconds, from UTC.</p>
    pub offset: std::option::Option<i32>,
}
impl TimeZone {
    /// <p>The name of the time zone, following the <a href="https://www.iana.org/time-zones"> IANA time zone standard</a>. For example, <code>America/Los_Angeles</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The time zone's offset, in seconds, from UTC.</p>
    pub fn offset(&self) -> std::option::Option<i32> {
        self.offset
    }
}
impl std::fmt::Debug for TimeZone {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimeZone");
        formatter.field("name", &self.name);
        formatter.field("offset", &self.offset);
        formatter.finish()
    }
}
/// See [`TimeZone`](crate::model::TimeZone)
pub mod time_zone {
    /// A builder for [`TimeZone`](crate::model::TimeZone)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) offset: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the time zone, following the <a href="https://www.iana.org/time-zones"> IANA time zone standard</a>. For example, <code>America/Los_Angeles</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the time zone, following the <a href="https://www.iana.org/time-zones"> IANA time zone standard</a>. For example, <code>America/Los_Angeles</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The time zone's offset, in seconds, from UTC.</p>
        pub fn offset(mut self, input: i32) -> Self {
            self.offset = Some(input);
            self
        }
        /// <p>The time zone's offset, in seconds, from UTC.</p>
        pub fn set_offset(mut self, input: std::option::Option<i32>) -> Self {
            self.offset = input;
            self
        }
        /// Consumes the builder and constructs a [`TimeZone`](crate::model::TimeZone)
        pub fn build(self) -> crate::model::TimeZone {
            crate::model::TimeZone {
                name: self.name,
                offset: self.offset,
            }
        }
    }
}
impl TimeZone {
    /// Creates a new builder-style object to manufacture [`TimeZone`](crate::model::TimeZone)
    pub fn builder() -> crate::model::time_zone::Builder {
        crate::model::time_zone::Builder::default()
    }
}

/// <p>Places uses a point geometry to specify a location or a Place.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PlaceGeometry {
    /// <p>A single point geometry specifies a location for a Place using <a href="https://gisgeography.com/wgs84-world-geodetic-system/">WGS 84</a> coordinates:</p>
    /// <ul>
    /// <li> <p> <i>x</i> — Specifies the x coordinate or longitude. </p> </li>
    /// <li> <p> <i>y</i> — Specifies the y coordinate or latitude. </p> </li>
    /// </ul>
    pub point: std::option::Option<std::vec::Vec<f64>>,
}
impl PlaceGeometry {
    /// <p>A single point geometry specifies a location for a Place using <a href="https://gisgeography.com/wgs84-world-geodetic-system/">WGS 84</a> coordinates:</p>
    /// <ul>
    /// <li> <p> <i>x</i> — Specifies the x coordinate or longitude. </p> </li>
    /// <li> <p> <i>y</i> — Specifies the y coordinate or latitude. </p> </li>
    /// </ul>
    pub fn point(&self) -> std::option::Option<&[f64]> {
        self.point.as_deref()
    }
}
impl std::fmt::Debug for PlaceGeometry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PlaceGeometry");
        formatter.field("point", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`PlaceGeometry`](crate::model::PlaceGeometry)
pub mod place_geometry {
    /// A builder for [`PlaceGeometry`](crate::model::PlaceGeometry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) point: std::option::Option<std::vec::Vec<f64>>,
    }
    impl Builder {
        /// Appends an item to `point`.
        ///
        /// To override the contents of this collection use [`set_point`](Self::set_point).
        ///
        /// <p>A single point geometry specifies a location for a Place using <a href="https://gisgeography.com/wgs84-world-geodetic-system/">WGS 84</a> coordinates:</p>
        /// <ul>
        /// <li> <p> <i>x</i> — Specifies the x coordinate or longitude. </p> </li>
        /// <li> <p> <i>y</i> — Specifies the y coordinate or latitude. </p> </li>
        /// </ul>
        pub fn point(mut self, input: f64) -> Self {
            let mut v = self.point.unwrap_or_default();
            v.push(input);
            self.point = Some(v);
            self
        }
        /// <p>A single point geometry specifies a location for a Place using <a href="https://gisgeography.com/wgs84-world-geodetic-system/">WGS 84</a> coordinates:</p>
        /// <ul>
        /// <li> <p> <i>x</i> — Specifies the x coordinate or longitude. </p> </li>
        /// <li> <p> <i>y</i> — Specifies the y coordinate or latitude. </p> </li>
        /// </ul>
        pub fn set_point(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.point = input;
            self
        }
        /// Consumes the builder and constructs a [`PlaceGeometry`](crate::model::PlaceGeometry)
        pub fn build(self) -> crate::model::PlaceGeometry {
            crate::model::PlaceGeometry { point: self.point }
        }
    }
}
impl PlaceGeometry {
    /// Creates a new builder-style object to manufacture [`PlaceGeometry`](crate::model::PlaceGeometry)
    pub fn builder() -> crate::model::place_geometry::Builder {
        crate::model::place_geometry::Builder::default()
    }
}

/// <p>A summary of the request sent by using <code>SearchPlaceIndexForText</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchPlaceIndexForTextSummary {
    /// <p>The search text specified in the request.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>Contains the coordinates for the optional bias position specified in the request.</p>
    /// <p>This parameter contains a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
    /// <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p>
    pub bias_position: std::option::Option<std::vec::Vec<f64>>,
    /// <p>Contains the coordinates for the optional bounding box specified in the request.</p>
    pub filter_b_box: std::option::Option<std::vec::Vec<f64>>,
    /// <p>Contains the optional country filter specified in the request.</p>
    pub filter_countries: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Contains the optional result count limit specified in the request.</p>
    pub max_results: i32,
    /// <p>The bounding box that fully contains all search results.</p> <note>
    /// <p>If you specified the optional <code>FilterBBox</code> parameter in the request, <code>ResultBBox</code> is contained within <code>FilterBBox</code>.</p>
    /// </note>
    pub result_b_box: std::option::Option<std::vec::Vec<f64>>,
    /// <p>The geospatial data provider attached to the place index resource specified in the request. Values can be one of the following:</p>
    /// <ul>
    /// <li> <p>Esri</p> </li>
    /// <li> <p>Here</p> </li>
    /// </ul>
    /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
    pub data_source: std::option::Option<std::string::String>,
    /// <p>The preferred language used to return results. Matches the language in the request. The value is a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
    pub language: std::option::Option<std::string::String>,
}
impl SearchPlaceIndexForTextSummary {
    /// <p>The search text specified in the request.</p>
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
    /// <p>Contains the coordinates for the optional bias position specified in the request.</p>
    /// <p>This parameter contains a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
    /// <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p>
    pub fn bias_position(&self) -> std::option::Option<&[f64]> {
        self.bias_position.as_deref()
    }
    /// <p>Contains the coordinates for the optional bounding box specified in the request.</p>
    pub fn filter_b_box(&self) -> std::option::Option<&[f64]> {
        self.filter_b_box.as_deref()
    }
    /// <p>Contains the optional country filter specified in the request.</p>
    pub fn filter_countries(&self) -> std::option::Option<&[std::string::String]> {
        self.filter_countries.as_deref()
    }
    /// <p>Contains the optional result count limit specified in the request.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The bounding box that fully contains all search results.</p> <note>
    /// <p>If you specified the optional <code>FilterBBox</code> parameter in the request, <code>ResultBBox</code> is contained within <code>FilterBBox</code>.</p>
    /// </note>
    pub fn result_b_box(&self) -> std::option::Option<&[f64]> {
        self.result_b_box.as_deref()
    }
    /// <p>The geospatial data provider attached to the place index resource specified in the request. Values can be one of the following:</p>
    /// <ul>
    /// <li> <p>Esri</p> </li>
    /// <li> <p>Here</p> </li>
    /// </ul>
    /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
    pub fn data_source(&self) -> std::option::Option<&str> {
        self.data_source.as_deref()
    }
    /// <p>The preferred language used to return results. Matches the language in the request. The value is a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
    pub fn language(&self) -> std::option::Option<&str> {
        self.language.as_deref()
    }
}
impl std::fmt::Debug for SearchPlaceIndexForTextSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchPlaceIndexForTextSummary");
        formatter.field("text", &"*** Sensitive Data Redacted ***");
        formatter.field("bias_position", &"*** Sensitive Data Redacted ***");
        formatter.field("filter_b_box", &"*** Sensitive Data Redacted ***");
        formatter.field("filter_countries", &self.filter_countries);
        formatter.field("max_results", &self.max_results);
        formatter.field("result_b_box", &"*** Sensitive Data Redacted ***");
        formatter.field("data_source", &self.data_source);
        formatter.field("language", &self.language);
        formatter.finish()
    }
}
/// See [`SearchPlaceIndexForTextSummary`](crate::model::SearchPlaceIndexForTextSummary)
pub mod search_place_index_for_text_summary {
    /// A builder for [`SearchPlaceIndexForTextSummary`](crate::model::SearchPlaceIndexForTextSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) bias_position: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) filter_b_box: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) filter_countries: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) result_b_box: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) data_source: std::option::Option<std::string::String>,
        pub(crate) language: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The search text specified in the request.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The search text specified in the request.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// Appends an item to `bias_position`.
        ///
        /// To override the contents of this collection use [`set_bias_position`](Self::set_bias_position).
        ///
        /// <p>Contains the coordinates for the optional bias position specified in the request.</p>
        /// <p>This parameter contains a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
        /// <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p>
        pub fn bias_position(mut self, input: f64) -> Self {
            let mut v = self.bias_position.unwrap_or_default();
            v.push(input);
            self.bias_position = Some(v);
            self
        }
        /// <p>Contains the coordinates for the optional bias position specified in the request.</p>
        /// <p>This parameter contains a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
        /// <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p>
        pub fn set_bias_position(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.bias_position = input;
            self
        }
        /// Appends an item to `filter_b_box`.
        ///
        /// To override the contents of this collection use [`set_filter_b_box`](Self::set_filter_b_box).
        ///
        /// <p>Contains the coordinates for the optional bounding box specified in the request.</p>
        pub fn filter_b_box(mut self, input: f64) -> Self {
            let mut v = self.filter_b_box.unwrap_or_default();
            v.push(input);
            self.filter_b_box = Some(v);
            self
        }
        /// <p>Contains the coordinates for the optional bounding box specified in the request.</p>
        pub fn set_filter_b_box(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.filter_b_box = input;
            self
        }
        /// Appends an item to `filter_countries`.
        ///
        /// To override the contents of this collection use [`set_filter_countries`](Self::set_filter_countries).
        ///
        /// <p>Contains the optional country filter specified in the request.</p>
        pub fn filter_countries(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.filter_countries.unwrap_or_default();
            v.push(input.into());
            self.filter_countries = Some(v);
            self
        }
        /// <p>Contains the optional country filter specified in the request.</p>
        pub fn set_filter_countries(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.filter_countries = input;
            self
        }
        /// <p>Contains the optional result count limit specified in the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Contains the optional result count limit specified in the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `result_b_box`.
        ///
        /// To override the contents of this collection use [`set_result_b_box`](Self::set_result_b_box).
        ///
        /// <p>The bounding box that fully contains all search results.</p> <note>
        /// <p>If you specified the optional <code>FilterBBox</code> parameter in the request, <code>ResultBBox</code> is contained within <code>FilterBBox</code>.</p>
        /// </note>
        pub fn result_b_box(mut self, input: f64) -> Self {
            let mut v = self.result_b_box.unwrap_or_default();
            v.push(input);
            self.result_b_box = Some(v);
            self
        }
        /// <p>The bounding box that fully contains all search results.</p> <note>
        /// <p>If you specified the optional <code>FilterBBox</code> parameter in the request, <code>ResultBBox</code> is contained within <code>FilterBBox</code>.</p>
        /// </note>
        pub fn set_result_b_box(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.result_b_box = input;
            self
        }
        /// <p>The geospatial data provider attached to the place index resource specified in the request. Values can be one of the following:</p>
        /// <ul>
        /// <li> <p>Esri</p> </li>
        /// <li> <p>Here</p> </li>
        /// </ul>
        /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
        pub fn data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source = Some(input.into());
            self
        }
        /// <p>The geospatial data provider attached to the place index resource specified in the request. Values can be one of the following:</p>
        /// <ul>
        /// <li> <p>Esri</p> </li>
        /// <li> <p>Here</p> </li>
        /// </ul>
        /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
        pub fn set_data_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_source = input;
            self
        }
        /// <p>The preferred language used to return results. Matches the language in the request. The value is a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.language = Some(input.into());
            self
        }
        /// <p>The preferred language used to return results. Matches the language in the request. The value is a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.language = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchPlaceIndexForTextSummary`](crate::model::SearchPlaceIndexForTextSummary)
        pub fn build(self) -> crate::model::SearchPlaceIndexForTextSummary {
            crate::model::SearchPlaceIndexForTextSummary {
                text: self.text,
                bias_position: self.bias_position,
                filter_b_box: self.filter_b_box,
                filter_countries: self.filter_countries,
                max_results: self.max_results.unwrap_or_default(),
                result_b_box: self.result_b_box,
                data_source: self.data_source,
                language: self.language,
            }
        }
    }
}
impl SearchPlaceIndexForTextSummary {
    /// Creates a new builder-style object to manufacture [`SearchPlaceIndexForTextSummary`](crate::model::SearchPlaceIndexForTextSummary)
    pub fn builder() -> crate::model::search_place_index_for_text_summary::Builder {
        crate::model::search_place_index_for_text_summary::Builder::default()
    }
}

/// <p>Contains a place suggestion resulting from a place suggestion query that is run on a place index resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchForSuggestionsResult {
    /// <p>The text of the place suggestion, typically formatted as an address string.</p>
    pub text: std::option::Option<std::string::String>,
}
impl SearchForSuggestionsResult {
    /// <p>The text of the place suggestion, typically formatted as an address string.</p>
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
}
impl std::fmt::Debug for SearchForSuggestionsResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchForSuggestionsResult");
        formatter.field("text", &self.text);
        formatter.finish()
    }
}
/// See [`SearchForSuggestionsResult`](crate::model::SearchForSuggestionsResult)
pub mod search_for_suggestions_result {
    /// A builder for [`SearchForSuggestionsResult`](crate::model::SearchForSuggestionsResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The text of the place suggestion, typically formatted as an address string.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The text of the place suggestion, typically formatted as an address string.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchForSuggestionsResult`](crate::model::SearchForSuggestionsResult)
        pub fn build(self) -> crate::model::SearchForSuggestionsResult {
            crate::model::SearchForSuggestionsResult { text: self.text }
        }
    }
}
impl SearchForSuggestionsResult {
    /// Creates a new builder-style object to manufacture [`SearchForSuggestionsResult`](crate::model::SearchForSuggestionsResult)
    pub fn builder() -> crate::model::search_for_suggestions_result::Builder {
        crate::model::search_for_suggestions_result::Builder::default()
    }
}

/// <p>A summary of the request sent by using <code>SearchPlaceIndexForSuggestions</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchPlaceIndexForSuggestionsSummary {
    /// <p>The free-form partial text input specified in the request.</p>
    pub text: std::option::Option<std::string::String>,
    /// <p>Contains the coordinates for the optional bias position specified in the request.</p>
    /// <p>This parameter contains a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
    /// <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p>
    pub bias_position: std::option::Option<std::vec::Vec<f64>>,
    /// <p>Contains the coordinates for the optional bounding box specified in the request.</p>
    pub filter_b_box: std::option::Option<std::vec::Vec<f64>>,
    /// <p>Contains the optional country filter specified in the request.</p>
    pub filter_countries: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Contains the optional result count limit specified in the request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The geospatial data provider attached to the place index resource specified in the request. Values can be one of the following:</p>
    /// <ul>
    /// <li> <p>Esri</p> </li>
    /// <li> <p>Here</p> </li>
    /// </ul>
    /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
    pub data_source: std::option::Option<std::string::String>,
    /// <p>The preferred language used to return results. Matches the language in the request. The value is a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
    pub language: std::option::Option<std::string::String>,
}
impl SearchPlaceIndexForSuggestionsSummary {
    /// <p>The free-form partial text input specified in the request.</p>
    pub fn text(&self) -> std::option::Option<&str> {
        self.text.as_deref()
    }
    /// <p>Contains the coordinates for the optional bias position specified in the request.</p>
    /// <p>This parameter contains a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
    /// <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p>
    pub fn bias_position(&self) -> std::option::Option<&[f64]> {
        self.bias_position.as_deref()
    }
    /// <p>Contains the coordinates for the optional bounding box specified in the request.</p>
    pub fn filter_b_box(&self) -> std::option::Option<&[f64]> {
        self.filter_b_box.as_deref()
    }
    /// <p>Contains the optional country filter specified in the request.</p>
    pub fn filter_countries(&self) -> std::option::Option<&[std::string::String]> {
        self.filter_countries.as_deref()
    }
    /// <p>Contains the optional result count limit specified in the request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The geospatial data provider attached to the place index resource specified in the request. Values can be one of the following:</p>
    /// <ul>
    /// <li> <p>Esri</p> </li>
    /// <li> <p>Here</p> </li>
    /// </ul>
    /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
    pub fn data_source(&self) -> std::option::Option<&str> {
        self.data_source.as_deref()
    }
    /// <p>The preferred language used to return results. Matches the language in the request. The value is a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
    pub fn language(&self) -> std::option::Option<&str> {
        self.language.as_deref()
    }
}
impl std::fmt::Debug for SearchPlaceIndexForSuggestionsSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchPlaceIndexForSuggestionsSummary");
        formatter.field("text", &"*** Sensitive Data Redacted ***");
        formatter.field("bias_position", &"*** Sensitive Data Redacted ***");
        formatter.field("filter_b_box", &"*** Sensitive Data Redacted ***");
        formatter.field("filter_countries", &self.filter_countries);
        formatter.field("max_results", &self.max_results);
        formatter.field("data_source", &self.data_source);
        formatter.field("language", &self.language);
        formatter.finish()
    }
}
/// See [`SearchPlaceIndexForSuggestionsSummary`](crate::model::SearchPlaceIndexForSuggestionsSummary)
pub mod search_place_index_for_suggestions_summary {
    /// A builder for [`SearchPlaceIndexForSuggestionsSummary`](crate::model::SearchPlaceIndexForSuggestionsSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) text: std::option::Option<std::string::String>,
        pub(crate) bias_position: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) filter_b_box: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) filter_countries: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) data_source: std::option::Option<std::string::String>,
        pub(crate) language: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The free-form partial text input specified in the request.</p>
        pub fn text(mut self, input: impl Into<std::string::String>) -> Self {
            self.text = Some(input.into());
            self
        }
        /// <p>The free-form partial text input specified in the request.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.text = input;
            self
        }
        /// Appends an item to `bias_position`.
        ///
        /// To override the contents of this collection use [`set_bias_position`](Self::set_bias_position).
        ///
        /// <p>Contains the coordinates for the optional bias position specified in the request.</p>
        /// <p>This parameter contains a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
        /// <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p>
        pub fn bias_position(mut self, input: f64) -> Self {
            let mut v = self.bias_position.unwrap_or_default();
            v.push(input);
            self.bias_position = Some(v);
            self
        }
        /// <p>Contains the coordinates for the optional bias position specified in the request.</p>
        /// <p>This parameter contains a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.</p>
        /// <p>For example, <code>[-123.1174, 49.2847]</code> represents the position with longitude <code>-123.1174</code> and latitude <code>49.2847</code>.</p>
        pub fn set_bias_position(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.bias_position = input;
            self
        }
        /// Appends an item to `filter_b_box`.
        ///
        /// To override the contents of this collection use [`set_filter_b_box`](Self::set_filter_b_box).
        ///
        /// <p>Contains the coordinates for the optional bounding box specified in the request.</p>
        pub fn filter_b_box(mut self, input: f64) -> Self {
            let mut v = self.filter_b_box.unwrap_or_default();
            v.push(input);
            self.filter_b_box = Some(v);
            self
        }
        /// <p>Contains the coordinates for the optional bounding box specified in the request.</p>
        pub fn set_filter_b_box(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.filter_b_box = input;
            self
        }
        /// Appends an item to `filter_countries`.
        ///
        /// To override the contents of this collection use [`set_filter_countries`](Self::set_filter_countries).
        ///
        /// <p>Contains the optional country filter specified in the request.</p>
        pub fn filter_countries(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.filter_countries.unwrap_or_default();
            v.push(input.into());
            self.filter_countries = Some(v);
            self
        }
        /// <p>Contains the optional country filter specified in the request.</p>
        pub fn set_filter_countries(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.filter_countries = input;
            self
        }
        /// <p>Contains the optional result count limit specified in the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Contains the optional result count limit specified in the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The geospatial data provider attached to the place index resource specified in the request. Values can be one of the following:</p>
        /// <ul>
        /// <li> <p>Esri</p> </li>
        /// <li> <p>Here</p> </li>
        /// </ul>
        /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
        pub fn data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source = Some(input.into());
            self
        }
        /// <p>The geospatial data provider attached to the place index resource specified in the request. Values can be one of the following:</p>
        /// <ul>
        /// <li> <p>Esri</p> </li>
        /// <li> <p>Here</p> </li>
        /// </ul>
        /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
        pub fn set_data_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_source = input;
            self
        }
        /// <p>The preferred language used to return results. Matches the language in the request. The value is a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.language = Some(input.into());
            self
        }
        /// <p>The preferred language used to return results. Matches the language in the request. The value is a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.language = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchPlaceIndexForSuggestionsSummary`](crate::model::SearchPlaceIndexForSuggestionsSummary)
        pub fn build(self) -> crate::model::SearchPlaceIndexForSuggestionsSummary {
            crate::model::SearchPlaceIndexForSuggestionsSummary {
                text: self.text,
                bias_position: self.bias_position,
                filter_b_box: self.filter_b_box,
                filter_countries: self.filter_countries,
                max_results: self.max_results,
                data_source: self.data_source,
                language: self.language,
            }
        }
    }
}
impl SearchPlaceIndexForSuggestionsSummary {
    /// Creates a new builder-style object to manufacture [`SearchPlaceIndexForSuggestionsSummary`](crate::model::SearchPlaceIndexForSuggestionsSummary)
    pub fn builder() -> crate::model::search_place_index_for_suggestions_summary::Builder {
        crate::model::search_place_index_for_suggestions_summary::Builder::default()
    }
}

/// <p>Contains a search result from a position search query that is run on a place index resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchForPositionResult {
    /// <p>Details about the search result, such as its address and position.</p>
    pub place: std::option::Option<crate::model::Place>,
    /// <p>The distance in meters of a great-circle arc between the query position and the result.</p> <note>
    /// <p>A great-circle arc is the shortest path on a sphere, in this case the Earth. This returns the shortest distance between two locations.</p>
    /// </note>
    pub distance: std::option::Option<f64>,
}
impl SearchForPositionResult {
    /// <p>Details about the search result, such as its address and position.</p>
    pub fn place(&self) -> std::option::Option<&crate::model::Place> {
        self.place.as_ref()
    }
    /// <p>The distance in meters of a great-circle arc between the query position and the result.</p> <note>
    /// <p>A great-circle arc is the shortest path on a sphere, in this case the Earth. This returns the shortest distance between two locations.</p>
    /// </note>
    pub fn distance(&self) -> std::option::Option<f64> {
        self.distance
    }
}
impl std::fmt::Debug for SearchForPositionResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchForPositionResult");
        formatter.field("place", &self.place);
        formatter.field("distance", &self.distance);
        formatter.finish()
    }
}
/// See [`SearchForPositionResult`](crate::model::SearchForPositionResult)
pub mod search_for_position_result {
    /// A builder for [`SearchForPositionResult`](crate::model::SearchForPositionResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) place: std::option::Option<crate::model::Place>,
        pub(crate) distance: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>Details about the search result, such as its address and position.</p>
        pub fn place(mut self, input: crate::model::Place) -> Self {
            self.place = Some(input);
            self
        }
        /// <p>Details about the search result, such as its address and position.</p>
        pub fn set_place(mut self, input: std::option::Option<crate::model::Place>) -> Self {
            self.place = input;
            self
        }
        /// <p>The distance in meters of a great-circle arc between the query position and the result.</p> <note>
        /// <p>A great-circle arc is the shortest path on a sphere, in this case the Earth. This returns the shortest distance between two locations.</p>
        /// </note>
        pub fn distance(mut self, input: f64) -> Self {
            self.distance = Some(input);
            self
        }
        /// <p>The distance in meters of a great-circle arc between the query position and the result.</p> <note>
        /// <p>A great-circle arc is the shortest path on a sphere, in this case the Earth. This returns the shortest distance between two locations.</p>
        /// </note>
        pub fn set_distance(mut self, input: std::option::Option<f64>) -> Self {
            self.distance = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchForPositionResult`](crate::model::SearchForPositionResult)
        pub fn build(self) -> crate::model::SearchForPositionResult {
            crate::model::SearchForPositionResult {
                place: self.place,
                distance: self.distance,
            }
        }
    }
}
impl SearchForPositionResult {
    /// Creates a new builder-style object to manufacture [`SearchForPositionResult`](crate::model::SearchForPositionResult)
    pub fn builder() -> crate::model::search_for_position_result::Builder {
        crate::model::search_for_position_result::Builder::default()
    }
}

/// <p>A summary of the request sent by using <code>SearchPlaceIndexForPosition</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchPlaceIndexForPositionSummary {
    /// <p>The position specified in the request.</p>
    pub position: std::option::Option<std::vec::Vec<f64>>,
    /// <p>Contains the optional result count limit that is specified in the request.</p>
    /// <p>Default value: <code>50</code> </p>
    pub max_results: i32,
    /// <p>The geospatial data provider attached to the place index resource specified in the request. Values can be one of the following:</p>
    /// <ul>
    /// <li> <p>Esri</p> </li>
    /// <li> <p>Here</p> </li>
    /// </ul>
    /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
    pub data_source: std::option::Option<std::string::String>,
    /// <p>The preferred language used to return results. Matches the language in the request. The value is a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
    pub language: std::option::Option<std::string::String>,
}
impl SearchPlaceIndexForPositionSummary {
    /// <p>The position specified in the request.</p>
    pub fn position(&self) -> std::option::Option<&[f64]> {
        self.position.as_deref()
    }
    /// <p>Contains the optional result count limit that is specified in the request.</p>
    /// <p>Default value: <code>50</code> </p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The geospatial data provider attached to the place index resource specified in the request. Values can be one of the following:</p>
    /// <ul>
    /// <li> <p>Esri</p> </li>
    /// <li> <p>Here</p> </li>
    /// </ul>
    /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
    pub fn data_source(&self) -> std::option::Option<&str> {
        self.data_source.as_deref()
    }
    /// <p>The preferred language used to return results. Matches the language in the request. The value is a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
    pub fn language(&self) -> std::option::Option<&str> {
        self.language.as_deref()
    }
}
impl std::fmt::Debug for SearchPlaceIndexForPositionSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchPlaceIndexForPositionSummary");
        formatter.field("position", &"*** Sensitive Data Redacted ***");
        formatter.field("max_results", &self.max_results);
        formatter.field("data_source", &self.data_source);
        formatter.field("language", &self.language);
        formatter.finish()
    }
}
/// See [`SearchPlaceIndexForPositionSummary`](crate::model::SearchPlaceIndexForPositionSummary)
pub mod search_place_index_for_position_summary {
    /// A builder for [`SearchPlaceIndexForPositionSummary`](crate::model::SearchPlaceIndexForPositionSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) position: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) data_source: std::option::Option<std::string::String>,
        pub(crate) language: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `position`.
        ///
        /// To override the contents of this collection use [`set_position`](Self::set_position).
        ///
        /// <p>The position specified in the request.</p>
        pub fn position(mut self, input: f64) -> Self {
            let mut v = self.position.unwrap_or_default();
            v.push(input);
            self.position = Some(v);
            self
        }
        /// <p>The position specified in the request.</p>
        pub fn set_position(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.position = input;
            self
        }
        /// <p>Contains the optional result count limit that is specified in the request.</p>
        /// <p>Default value: <code>50</code> </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Contains the optional result count limit that is specified in the request.</p>
        /// <p>Default value: <code>50</code> </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The geospatial data provider attached to the place index resource specified in the request. Values can be one of the following:</p>
        /// <ul>
        /// <li> <p>Esri</p> </li>
        /// <li> <p>Here</p> </li>
        /// </ul>
        /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
        pub fn data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source = Some(input.into());
            self
        }
        /// <p>The geospatial data provider attached to the place index resource specified in the request. Values can be one of the following:</p>
        /// <ul>
        /// <li> <p>Esri</p> </li>
        /// <li> <p>Here</p> </li>
        /// </ul>
        /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
        pub fn set_data_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_source = input;
            self
        }
        /// <p>The preferred language used to return results. Matches the language in the request. The value is a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
        pub fn language(mut self, input: impl Into<std::string::String>) -> Self {
            self.language = Some(input.into());
            self
        }
        /// <p>The preferred language used to return results. Matches the language in the request. The value is a valid <a href="https://tools.ietf.org/search/bcp47">BCP 47</a> language tag, for example, <code>en</code> for English.</p>
        pub fn set_language(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.language = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchPlaceIndexForPositionSummary`](crate::model::SearchPlaceIndexForPositionSummary)
        pub fn build(self) -> crate::model::SearchPlaceIndexForPositionSummary {
            crate::model::SearchPlaceIndexForPositionSummary {
                position: self.position,
                max_results: self.max_results.unwrap_or_default(),
                data_source: self.data_source,
                language: self.language,
            }
        }
    }
}
impl SearchPlaceIndexForPositionSummary {
    /// Creates a new builder-style object to manufacture [`SearchPlaceIndexForPositionSummary`](crate::model::SearchPlaceIndexForPositionSummary)
    pub fn builder() -> crate::model::search_place_index_for_position_summary::Builder {
        crate::model::search_place_index_for_position_summary::Builder::default()
    }
}

/// <p>A place index resource listed in your AWS account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPlaceIndexesResponseEntry {
    /// <p>The name of the place index resource.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The optional description for the place index resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The data provider of geospatial data. Values can be one of the following:</p>
    /// <ul>
    /// <li> <p> <code>Esri</code> </p> </li>
    /// <li> <p> <code>Here</code> </p> </li>
    /// </ul>
    /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
    pub data_source: std::option::Option<std::string::String>,
    /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
    pub pricing_plan: std::option::Option<crate::model::PricingPlan>,
    /// <p>The timestamp for when the place index resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp for when the place index resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ListPlaceIndexesResponseEntry {
    /// <p>The name of the place index resource.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The optional description for the place index resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The data provider of geospatial data. Values can be one of the following:</p>
    /// <ul>
    /// <li> <p> <code>Esri</code> </p> </li>
    /// <li> <p> <code>Here</code> </p> </li>
    /// </ul>
    /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
    pub fn data_source(&self) -> std::option::Option<&str> {
        self.data_source.as_deref()
    }
    /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
    pub fn pricing_plan(&self) -> std::option::Option<&crate::model::PricingPlan> {
        self.pricing_plan.as_ref()
    }
    /// <p>The timestamp for when the place index resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
    /// <p>The timestamp for when the place index resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
}
impl std::fmt::Debug for ListPlaceIndexesResponseEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPlaceIndexesResponseEntry");
        formatter.field("index_name", &self.index_name);
        formatter.field("description", &self.description);
        formatter.field("data_source", &self.data_source);
        formatter.field("pricing_plan", &self.pricing_plan);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`ListPlaceIndexesResponseEntry`](crate::model::ListPlaceIndexesResponseEntry)
pub mod list_place_indexes_response_entry {
    /// A builder for [`ListPlaceIndexesResponseEntry`](crate::model::ListPlaceIndexesResponseEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) data_source: std::option::Option<std::string::String>,
        pub(crate) pricing_plan: std::option::Option<crate::model::PricingPlan>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the place index resource.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the place index resource.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>The optional description for the place index resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The optional description for the place index resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The data provider of geospatial data. Values can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>Esri</code> </p> </li>
        /// <li> <p> <code>Here</code> </p> </li>
        /// </ul>
        /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
        pub fn data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source = Some(input.into());
            self
        }
        /// <p>The data provider of geospatial data. Values can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>Esri</code> </p> </li>
        /// <li> <p> <code>Here</code> </p> </li>
        /// </ul>
        /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
        pub fn set_data_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_source = input;
            self
        }
        /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.pricing_plan = Some(input);
            self
        }
        /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.pricing_plan = input;
            self
        }
        /// <p>The timestamp for when the place index resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp for when the place index resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The timestamp for when the place index resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>The timestamp for when the place index resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPlaceIndexesResponseEntry`](crate::model::ListPlaceIndexesResponseEntry)
        pub fn build(self) -> crate::model::ListPlaceIndexesResponseEntry {
            crate::model::ListPlaceIndexesResponseEntry {
                index_name: self.index_name,
                description: self.description,
                data_source: self.data_source,
                pricing_plan: self.pricing_plan,
                create_time: self.create_time,
                update_time: self.update_time,
            }
        }
    }
}
impl ListPlaceIndexesResponseEntry {
    /// Creates a new builder-style object to manufacture [`ListPlaceIndexesResponseEntry`](crate::model::ListPlaceIndexesResponseEntry)
    pub fn builder() -> crate::model::list_place_indexes_response_entry::Builder {
        crate::model::list_place_indexes_response_entry::Builder::default()
    }
}

/// <p>Specifies the data storage option chosen for requesting Places.</p> <important>
/// <p>When using Amazon Location Places:</p>
/// <ul>
/// <li> <p>If using HERE Technologies as a data provider, you can't store results for locations in Japan by setting <code>IntendedUse</code> to <code>Storage</code>. parameter.</p> </li>
/// <li> <p>Under the <code>MobileAssetTracking</code> or <code>MobilAssetManagement</code> pricing plan, you can't store results from your place index resources by setting <code>IntendedUse</code> to <code>Storage</code>. This returns a validation exception error.</p> </li>
/// </ul>
/// <p>For more information, see the <a href="https://aws.amazon.com/service-terms/">AWS Service Terms</a> for Amazon Location Service.</p>
/// </important>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataSourceConfiguration {
    /// <p>Specifies how the results of an operation will be stored by the caller. </p>
    /// <p>Valid values include:</p>
    /// <ul>
    /// <li> <p> <code>SingleUse</code> specifies that the results won't be stored. </p> </li>
    /// <li> <p> <code>Storage</code> specifies that the result can be cached or stored in a database.</p> </li>
    /// </ul>
    /// <p>Default value: <code>SingleUse</code> </p>
    pub intended_use: std::option::Option<crate::model::IntendedUse>,
}
impl DataSourceConfiguration {
    /// <p>Specifies how the results of an operation will be stored by the caller. </p>
    /// <p>Valid values include:</p>
    /// <ul>
    /// <li> <p> <code>SingleUse</code> specifies that the results won't be stored. </p> </li>
    /// <li> <p> <code>Storage</code> specifies that the result can be cached or stored in a database.</p> </li>
    /// </ul>
    /// <p>Default value: <code>SingleUse</code> </p>
    pub fn intended_use(&self) -> std::option::Option<&crate::model::IntendedUse> {
        self.intended_use.as_ref()
    }
}
impl std::fmt::Debug for DataSourceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataSourceConfiguration");
        formatter.field("intended_use", &self.intended_use);
        formatter.finish()
    }
}
/// See [`DataSourceConfiguration`](crate::model::DataSourceConfiguration)
pub mod data_source_configuration {
    /// A builder for [`DataSourceConfiguration`](crate::model::DataSourceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) intended_use: std::option::Option<crate::model::IntendedUse>,
    }
    impl Builder {
        /// <p>Specifies how the results of an operation will be stored by the caller. </p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>SingleUse</code> specifies that the results won't be stored. </p> </li>
        /// <li> <p> <code>Storage</code> specifies that the result can be cached or stored in a database.</p> </li>
        /// </ul>
        /// <p>Default value: <code>SingleUse</code> </p>
        pub fn intended_use(mut self, input: crate::model::IntendedUse) -> Self {
            self.intended_use = Some(input);
            self
        }
        /// <p>Specifies how the results of an operation will be stored by the caller. </p>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li> <p> <code>SingleUse</code> specifies that the results won't be stored. </p> </li>
        /// <li> <p> <code>Storage</code> specifies that the result can be cached or stored in a database.</p> </li>
        /// </ul>
        /// <p>Default value: <code>SingleUse</code> </p>
        pub fn set_intended_use(
            mut self,
            input: std::option::Option<crate::model::IntendedUse>,
        ) -> Self {
            self.intended_use = input;
            self
        }
        /// Consumes the builder and constructs a [`DataSourceConfiguration`](crate::model::DataSourceConfiguration)
        pub fn build(self) -> crate::model::DataSourceConfiguration {
            crate::model::DataSourceConfiguration {
                intended_use: self.intended_use,
            }
        }
    }
}
impl DataSourceConfiguration {
    /// Creates a new builder-style object to manufacture [`DataSourceConfiguration`](crate::model::DataSourceConfiguration)
    pub fn builder() -> crate::model::data_source_configuration::Builder {
        crate::model::data_source_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub struct IntendedUse(String);
impl IntendedUse {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        &self.0
    }
    /// Returns all the `&str` representations of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SingleUse", "Storage"]
    }
}
impl<T> std::convert::From<T> for IntendedUse
where
    T: std::convert::AsRef<str>,
{
    fn from(s: T) -> Self {
        IntendedUse(s.as_ref().to_owned())
    }
}

/// <p>Contains details of an existing map resource in your AWS account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMapsResponseEntry {
    /// <p>The name of the associated map resource.</p>
    pub map_name: std::option::Option<std::string::String>,
    /// <p>The description for the map resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Specifies the data provider for the associated map tiles.</p>
    pub data_source: std::option::Option<std::string::String>,
    /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
    pub pricing_plan: std::option::Option<crate::model::PricingPlan>,
    /// <p>The timestamp for when the map resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp for when the map resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ListMapsResponseEntry {
    /// <p>The name of the associated map resource.</p>
    pub fn map_name(&self) -> std::option::Option<&str> {
        self.map_name.as_deref()
    }
    /// <p>The description for the map resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Specifies the data provider for the associated map tiles.</p>
    pub fn data_source(&self) -> std::option::Option<&str> {
        self.data_source.as_deref()
    }
    /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
    pub fn pricing_plan(&self) -> std::option::Option<&crate::model::PricingPlan> {
        self.pricing_plan.as_ref()
    }
    /// <p>The timestamp for when the map resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
    /// <p>The timestamp for when the map resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
}
impl std::fmt::Debug for ListMapsResponseEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMapsResponseEntry");
        formatter.field("map_name", &self.map_name);
        formatter.field("description", &self.description);
        formatter.field("data_source", &self.data_source);
        formatter.field("pricing_plan", &self.pricing_plan);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`ListMapsResponseEntry`](crate::model::ListMapsResponseEntry)
pub mod list_maps_response_entry {
    /// A builder for [`ListMapsResponseEntry`](crate::model::ListMapsResponseEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) map_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) data_source: std::option::Option<std::string::String>,
        pub(crate) pricing_plan: std::option::Option<crate::model::PricingPlan>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the associated map resource.</p>
        pub fn map_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.map_name = Some(input.into());
            self
        }
        /// <p>The name of the associated map resource.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.map_name = input;
            self
        }
        /// <p>The description for the map resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the map resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Specifies the data provider for the associated map tiles.</p>
        pub fn data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source = Some(input.into());
            self
        }
        /// <p>Specifies the data provider for the associated map tiles.</p>
        pub fn set_data_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_source = input;
            self
        }
        /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.pricing_plan = Some(input);
            self
        }
        /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.pricing_plan = input;
            self
        }
        /// <p>The timestamp for when the map resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp for when the map resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The timestamp for when the map resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>The timestamp for when the map resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMapsResponseEntry`](crate::model::ListMapsResponseEntry)
        pub fn build(self) -> crate::model::ListMapsResponseEntry {
            crate::model::ListMapsResponseEntry {
                map_name: self.map_name,
                description: self.description,
                data_source: self.data_source,
                pricing_plan: self.pricing_plan,
                create_time: self.create_time,
                update_time: self.update_time,
            }
        }
    }
}
impl ListMapsResponseEntry {
    /// Creates a new builder-style object to manufacture [`ListMapsResponseEntry`](crate::model::ListMapsResponseEntry)
    pub fn builder() -> crate::model::list_maps_response_entry::Builder {
        crate::model::list_maps_response_entry::Builder::default()
    }
}

/// <p>Specifies the map tile style selected from an available provider.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MapConfiguration {
    /// <p>Specifies the map style selected from an available data provider.</p>
    /// <p>Valid <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri map styles</a>:</p>
    /// <ul>
    /// <li> <p> <code>VectorEsriDarkGrayCanvas</code> – The Esri Dark Gray Canvas map style. A vector basemap with a dark gray, neutral background with minimal colors, labels, and features that's designed to draw attention to your thematic content. </p> </li>
    /// <li> <p> <code>RasterEsriImagery</code> – The Esri Imagery map style. A raster basemap that provides one meter or better satellite and aerial imagery in many parts of the world and lower resolution satellite imagery worldwide. </p> </li>
    /// <li> <p> <code>VectorEsriLightGrayCanvas</code> – The Esri Light Gray Canvas map style, which provides a detailed vector basemap with a light gray, neutral background style with minimal colors, labels, and features that's designed to draw attention to your thematic content. </p> </li>
    /// <li> <p> <code>VectorEsriTopographic</code> – The Esri Light map style, which provides a detailed vector basemap with a classic Esri map style.</p> </li>
    /// <li> <p> <code>VectorEsriStreets</code> – The Esri World Streets map style, which provides a detailed vector basemap for the world symbolized with a classic Esri street map style. The vector tile layer is similar in content and style to the World Street Map raster map.</p> </li>
    /// <li> <p> <code>VectorEsriNavigation</code> – The Esri World Navigation map style, which provides a detailed basemap for the world symbolized with a custom navigation map style that's designed for use during the day in mobile devices.</p> </li>
    /// </ul>
    /// <p>Valid <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies map styles</a>:</p>
    /// <ul>
    /// <li> <p> <code>VectorHereBerlin</code> – The HERE Berlin map style is a high contrast detailed base map of the world that blends 3D and 2D rendering.</p> <note>
    /// <p>When using HERE as your data provider, and selecting the Style <code>VectorHereBerlin</code>, you may not use HERE Technologies maps for Asset Management. See the <a href="https://aws.amazon.com/service-terms/">AWS Service Terms</a> for Amazon Location Service.</p>
    /// </note> </li>
    /// </ul>
    pub style: std::option::Option<std::string::String>,
}
impl MapConfiguration {
    /// <p>Specifies the map style selected from an available data provider.</p>
    /// <p>Valid <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri map styles</a>:</p>
    /// <ul>
    /// <li> <p> <code>VectorEsriDarkGrayCanvas</code> – The Esri Dark Gray Canvas map style. A vector basemap with a dark gray, neutral background with minimal colors, labels, and features that's designed to draw attention to your thematic content. </p> </li>
    /// <li> <p> <code>RasterEsriImagery</code> – The Esri Imagery map style. A raster basemap that provides one meter or better satellite and aerial imagery in many parts of the world and lower resolution satellite imagery worldwide. </p> </li>
    /// <li> <p> <code>VectorEsriLightGrayCanvas</code> – The Esri Light Gray Canvas map style, which provides a detailed vector basemap with a light gray, neutral background style with minimal colors, labels, and features that's designed to draw attention to your thematic content. </p> </li>
    /// <li> <p> <code>VectorEsriTopographic</code> – The Esri Light map style, which provides a detailed vector basemap with a classic Esri map style.</p> </li>
    /// <li> <p> <code>VectorEsriStreets</code> – The Esri World Streets map style, which provides a detailed vector basemap for the world symbolized with a classic Esri street map style. The vector tile layer is similar in content and style to the World Street Map raster map.</p> </li>
    /// <li> <p> <code>VectorEsriNavigation</code> – The Esri World Navigation map style, which provides a detailed basemap for the world symbolized with a custom navigation map style that's designed for use during the day in mobile devices.</p> </li>
    /// </ul>
    /// <p>Valid <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies map styles</a>:</p>
    /// <ul>
    /// <li> <p> <code>VectorHereBerlin</code> – The HERE Berlin map style is a high contrast detailed base map of the world that blends 3D and 2D rendering.</p> <note>
    /// <p>When using HERE as your data provider, and selecting the Style <code>VectorHereBerlin</code>, you may not use HERE Technologies maps for Asset Management. See the <a href="https://aws.amazon.com/service-terms/">AWS Service Terms</a> for Amazon Location Service.</p>
    /// </note> </li>
    /// </ul>
    pub fn style(&self) -> std::option::Option<&str> {
        self.style.as_deref()
    }
}
impl std::fmt::Debug for MapConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MapConfiguration");
        formatter.field("style", &self.style);
        formatter.finish()
    }
}
/// See [`MapConfiguration`](crate::model::MapConfiguration)
pub mod map_configuration {
    /// A builder for [`MapConfiguration`](crate::model::MapConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) style: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the map style selected from an available data provider.</p>
        /// <p>Valid <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri map styles</a>:</p>
        /// <ul>
        /// <li> <p> <code>VectorEsriDarkGrayCanvas</code> – The Esri Dark Gray Canvas map style. A vector basemap with a dark gray, neutral background with minimal colors, labels, and features that's designed to draw attention to your thematic content. </p> </li>
        /// <li> <p> <code>RasterEsriImagery</code> – The Esri Imagery map style. A raster basemap that provides one meter or better satellite and aerial imagery in many parts of the world and lower resolution satellite imagery worldwide. </p> </li>
        /// <li> <p> <code>VectorEsriLightGrayCanvas</code> – The Esri Light Gray Canvas map style, which provides a detailed vector basemap with a light gray, neutral background style with minimal colors, labels, and features that's designed to draw attention to your thematic content. </p> </li>
        /// <li> <p> <code>VectorEsriTopographic</code> – The Esri Light map style, which provides a detailed vector basemap with a classic Esri map style.</p> </li>
        /// <li> <p> <code>VectorEsriStreets</code> – The Esri World Streets map style, which provides a detailed vector basemap for the world symbolized with a classic Esri street map style. The vector tile layer is similar in content and style to the World Street Map raster map.</p> </li>
        /// <li> <p> <code>VectorEsriNavigation</code> – The Esri World Navigation map style, which provides a detailed basemap for the world symbolized with a custom navigation map style that's designed for use during the day in mobile devices.</p> </li>
        /// </ul>
        /// <p>Valid <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies map styles</a>:</p>
        /// <ul>
        /// <li> <p> <code>VectorHereBerlin</code> – The HERE Berlin map style is a high contrast detailed base map of the world that blends 3D and 2D rendering.</p> <note>
        /// <p>When using HERE as your data provider, and selecting the Style <code>VectorHereBerlin</code>, you may not use HERE Technologies maps for Asset Management. See the <a href="https://aws.amazon.com/service-terms/">AWS Service Terms</a> for Amazon Location Service.</p>
        /// </note> </li>
        /// </ul>
        pub fn style(mut self, input: impl Into<std::string::String>) -> Self {
            self.style = Some(input.into());
            self
        }
        /// <p>Specifies the map style selected from an available data provider.</p>
        /// <p>Valid <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri map styles</a>:</p>
        /// <ul>
        /// <li> <p> <code>VectorEsriDarkGrayCanvas</code> – The Esri Dark Gray Canvas map style. A vector basemap with a dark gray, neutral background with minimal colors, labels, and features that's designed to draw attention to your thematic content. </p> </li>
        /// <li> <p> <code>RasterEsriImagery</code> – The Esri Imagery map style. A raster basemap that provides one meter or better satellite and aerial imagery in many parts of the world and lower resolution satellite imagery worldwide. </p> </li>
        /// <li> <p> <code>VectorEsriLightGrayCanvas</code> – The Esri Light Gray Canvas map style, which provides a detailed vector basemap with a light gray, neutral background style with minimal colors, labels, and features that's designed to draw attention to your thematic content. </p> </li>
        /// <li> <p> <code>VectorEsriTopographic</code> – The Esri Light map style, which provides a detailed vector basemap with a classic Esri map style.</p> </li>
        /// <li> <p> <code>VectorEsriStreets</code> – The Esri World Streets map style, which provides a detailed vector basemap for the world symbolized with a classic Esri street map style. The vector tile layer is similar in content and style to the World Street Map raster map.</p> </li>
        /// <li> <p> <code>VectorEsriNavigation</code> – The Esri World Navigation map style, which provides a detailed basemap for the world symbolized with a custom navigation map style that's designed for use during the day in mobile devices.</p> </li>
        /// </ul>
        /// <p>Valid <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies map styles</a>:</p>
        /// <ul>
        /// <li> <p> <code>VectorHereBerlin</code> – The HERE Berlin map style is a high contrast detailed base map of the world that blends 3D and 2D rendering.</p> <note>
        /// <p>When using HERE as your data provider, and selecting the Style <code>VectorHereBerlin</code>, you may not use HERE Technologies maps for Asset Management. See the <a href="https://aws.amazon.com/service-terms/">AWS Service Terms</a> for Amazon Location Service.</p>
        /// </note> </li>
        /// </ul>
        pub fn set_style(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.style = input;
            self
        }
        /// Consumes the builder and constructs a [`MapConfiguration`](crate::model::MapConfiguration)
        pub fn build(self) -> crate::model::MapConfiguration {
            crate::model::MapConfiguration { style: self.style }
        }
    }
}
impl MapConfiguration {
    /// Creates a new builder-style object to manufacture [`MapConfiguration`](crate::model::MapConfiguration)
    pub fn builder() -> crate::model::map_configuration::Builder {
        crate::model::map_configuration::Builder::default()
    }
}

/// <p>Contains the geofence geometry details.</p> <note>
/// <p>Amazon Location doesn't currently support polygons with holes, multipolygons, polygons that are wound clockwise, or that cross the antimeridian. </p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GeofenceGeometry {
    /// <p>An array of 1 or more linear rings. A linear ring is an array of 4 or more vertices, where the first and last vertex are the same to form a closed boundary. Each vertex is a 2-dimensional point of the form: <code>[longitude, latitude]</code>. </p>
    /// <p>The first linear ring is an outer ring, describing the polygon's boundary. Subsequent linear rings may be inner or outer rings to describe holes and islands. Outer rings must list their vertices in counter-clockwise order around the ring's center, where the left side is the polygon's exterior. Inner rings must list their vertices in clockwise order, where the left side is the polygon's interior.</p>
    pub polygon: std::option::Option<std::vec::Vec<std::vec::Vec<std::vec::Vec<f64>>>>,
}
impl GeofenceGeometry {
    /// <p>An array of 1 or more linear rings. A linear ring is an array of 4 or more vertices, where the first and last vertex are the same to form a closed boundary. Each vertex is a 2-dimensional point of the form: <code>[longitude, latitude]</code>. </p>
    /// <p>The first linear ring is an outer ring, describing the polygon's boundary. Subsequent linear rings may be inner or outer rings to describe holes and islands. Outer rings must list their vertices in counter-clockwise order around the ring's center, where the left side is the polygon's exterior. Inner rings must list their vertices in clockwise order, where the left side is the polygon's interior.</p>
    pub fn polygon(&self) -> std::option::Option<&[std::vec::Vec<std::vec::Vec<f64>>]> {
        self.polygon.as_deref()
    }
}
impl std::fmt::Debug for GeofenceGeometry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GeofenceGeometry");
        formatter.field("polygon", &self.polygon);
        formatter.finish()
    }
}
/// See [`GeofenceGeometry`](crate::model::GeofenceGeometry)
pub mod geofence_geometry {
    /// A builder for [`GeofenceGeometry`](crate::model::GeofenceGeometry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) polygon: std::option::Option<std::vec::Vec<std::vec::Vec<std::vec::Vec<f64>>>>,
    }
    impl Builder {
        /// Appends an item to `polygon`.
        ///
        /// To override the contents of this collection use [`set_polygon`](Self::set_polygon).
        ///
        /// <p>An array of 1 or more linear rings. A linear ring is an array of 4 or more vertices, where the first and last vertex are the same to form a closed boundary. Each vertex is a 2-dimensional point of the form: <code>[longitude, latitude]</code>. </p>
        /// <p>The first linear ring is an outer ring, describing the polygon's boundary. Subsequent linear rings may be inner or outer rings to describe holes and islands. Outer rings must list their vertices in counter-clockwise order around the ring's center, where the left side is the polygon's exterior. Inner rings must list their vertices in clockwise order, where the left side is the polygon's interior.</p>
        pub fn polygon(mut self, input: std::vec::Vec<std::vec::Vec<f64>>) -> Self {
            let mut v = self.polygon.unwrap_or_default();
            v.push(input);
            self.polygon = Some(v);
            self
        }
        /// <p>An array of 1 or more linear rings. A linear ring is an array of 4 or more vertices, where the first and last vertex are the same to form a closed boundary. Each vertex is a 2-dimensional point of the form: <code>[longitude, latitude]</code>. </p>
        /// <p>The first linear ring is an outer ring, describing the polygon's boundary. Subsequent linear rings may be inner or outer rings to describe holes and islands. Outer rings must list their vertices in counter-clockwise order around the ring's center, where the left side is the polygon's exterior. Inner rings must list their vertices in clockwise order, where the left side is the polygon's interior.</p>
        pub fn set_polygon(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<std::vec::Vec<f64>>>>,
        ) -> Self {
            self.polygon = input;
            self
        }
        /// Consumes the builder and constructs a [`GeofenceGeometry`](crate::model::GeofenceGeometry)
        pub fn build(self) -> crate::model::GeofenceGeometry {
            crate::model::GeofenceGeometry {
                polygon: self.polygon,
            }
        }
    }
}
impl GeofenceGeometry {
    /// Creates a new builder-style object to manufacture [`GeofenceGeometry`](crate::model::GeofenceGeometry)
    pub fn builder() -> crate::model::geofence_geometry::Builder {
        crate::model::geofence_geometry::Builder::default()
    }
}

/// <p>Contains a list of geofences stored in a given geofence collection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGeofenceResponseEntry {
    /// <p>The geofence identifier.</p>
    pub geofence_id: std::option::Option<std::string::String>,
    /// <p>Contains the geofence geometry details describing a polygon.</p>
    pub geometry: std::option::Option<crate::model::GeofenceGeometry>,
    /// <p>Identifies the state of the geofence. A geofence will hold one of the following states:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> — The geofence has been indexed by the system. </p> </li>
    /// <li> <p> <code>PENDING</code> — The geofence is being processed by the system.</p> </li>
    /// <li> <p> <code>FAILED</code> — The geofence failed to be indexed by the system.</p> </li>
    /// <li> <p> <code>DELETED</code> — The geofence has been deleted from the system index.</p> </li>
    /// <li> <p> <code>DELETING</code> — The geofence is being deleted from the system index.</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The timestamp for when the geofence was stored in a geofence collection in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp for when the geofence was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ListGeofenceResponseEntry {
    /// <p>The geofence identifier.</p>
    pub fn geofence_id(&self) -> std::option::Option<&str> {
        self.geofence_id.as_deref()
    }
    /// <p>Contains the geofence geometry details describing a polygon.</p>
    pub fn geometry(&self) -> std::option::Option<&crate::model::GeofenceGeometry> {
        self.geometry.as_ref()
    }
    /// <p>Identifies the state of the geofence. A geofence will hold one of the following states:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> — The geofence has been indexed by the system. </p> </li>
    /// <li> <p> <code>PENDING</code> — The geofence is being processed by the system.</p> </li>
    /// <li> <p> <code>FAILED</code> — The geofence failed to be indexed by the system.</p> </li>
    /// <li> <p> <code>DELETED</code> — The geofence has been deleted from the system index.</p> </li>
    /// <li> <p> <code>DELETING</code> — The geofence is being deleted from the system index.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The timestamp for when the geofence was stored in a geofence collection in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
    /// <p>The timestamp for when the geofence was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
}
impl std::fmt::Debug for ListGeofenceResponseEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGeofenceResponseEntry");
        formatter.field("geofence_id", &self.geofence_id);
        formatter.field("geometry", &self.geometry);
        formatter.field("status", &self.status);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`ListGeofenceResponseEntry`](crate::model::ListGeofenceResponseEntry)
pub mod list_geofence_response_entry {
    /// A builder for [`ListGeofenceResponseEntry`](crate::model::ListGeofenceResponseEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) geofence_id: std::option::Option<std::string::String>,
        pub(crate) geometry: std::option::Option<crate::model::GeofenceGeometry>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The geofence identifier.</p>
        pub fn geofence_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.geofence_id = Some(input.into());
            self
        }
        /// <p>The geofence identifier.</p>
        pub fn set_geofence_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.geofence_id = input;
            self
        }
        /// <p>Contains the geofence geometry details describing a polygon.</p>
        pub fn geometry(mut self, input: crate::model::GeofenceGeometry) -> Self {
            self.geometry = Some(input);
            self
        }
        /// <p>Contains the geofence geometry details describing a polygon.</p>
        pub fn set_geometry(
            mut self,
            input: std::option::Option<crate::model::GeofenceGeometry>,
        ) -> Self {
            self.geometry = input;
            self
        }
        /// <p>Identifies the state of the geofence. A geofence will hold one of the following states:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> — The geofence has been indexed by the system. </p> </li>
        /// <li> <p> <code>PENDING</code> — The geofence is being processed by the system.</p> </li>
        /// <li> <p> <code>FAILED</code> — The geofence failed to be indexed by the system.</p> </li>
        /// <li> <p> <code>DELETED</code> — The geofence has been deleted from the system index.</p> </li>
        /// <li> <p> <code>DELETING</code> — The geofence is being deleted from the system index.</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Identifies the state of the geofence. A geofence will hold one of the following states:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> — The geofence has been indexed by the system. </p> </li>
        /// <li> <p> <code>PENDING</code> — The geofence is being processed by the system.</p> </li>
        /// <li> <p> <code>FAILED</code> — The geofence failed to be indexed by the system.</p> </li>
        /// <li> <p> <code>DELETED</code> — The geofence has been deleted from the system index.</p> </li>
        /// <li> <p> <code>DELETING</code> — The geofence is being deleted from the system index.</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The timestamp for when the geofence was stored in a geofence collection in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp for when the geofence was stored in a geofence collection in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The timestamp for when the geofence was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>The timestamp for when the geofence was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGeofenceResponseEntry`](crate::model::ListGeofenceResponseEntry)
        pub fn build(self) -> crate::model::ListGeofenceResponseEntry {
            crate::model::ListGeofenceResponseEntry {
                geofence_id: self.geofence_id,
                geometry: self.geometry,
                status: self.status,
                create_time: self.create_time,
                update_time: self.update_time,
            }
        }
    }
}
impl ListGeofenceResponseEntry {
    /// Creates a new builder-style object to manufacture [`ListGeofenceResponseEntry`](crate::model::ListGeofenceResponseEntry)
    pub fn builder() -> crate::model::list_geofence_response_entry::Builder {
        crate::model::list_geofence_response_entry::Builder::default()
    }
}

/// <p>Contains error details for each geofence that failed to be stored in a given geofence collection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchPutGeofenceError {
    /// <p>The geofence associated with the error message.</p>
    pub geofence_id: std::option::Option<std::string::String>,
    /// <p>Contains details associated to the batch error.</p>
    pub error: std::option::Option<crate::model::BatchItemError>,
}
impl BatchPutGeofenceError {
    /// <p>The geofence associated with the error message.</p>
    pub fn geofence_id(&self) -> std::option::Option<&str> {
        self.geofence_id.as_deref()
    }
    /// <p>Contains details associated to the batch error.</p>
    pub fn error(&self) -> std::option::Option<&crate::model::BatchItemError> {
        self.error.as_ref()
    }
}
impl std::fmt::Debug for BatchPutGeofenceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchPutGeofenceError");
        formatter.field("geofence_id", &self.geofence_id);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`BatchPutGeofenceError`](crate::model::BatchPutGeofenceError)
pub mod batch_put_geofence_error {
    /// A builder for [`BatchPutGeofenceError`](crate::model::BatchPutGeofenceError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) geofence_id: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<crate::model::BatchItemError>,
    }
    impl Builder {
        /// <p>The geofence associated with the error message.</p>
        pub fn geofence_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.geofence_id = Some(input.into());
            self
        }
        /// <p>The geofence associated with the error message.</p>
        pub fn set_geofence_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.geofence_id = input;
            self
        }
        /// <p>Contains details associated to the batch error.</p>
        pub fn error(mut self, input: crate::model::BatchItemError) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Contains details associated to the batch error.</p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::BatchItemError>,
        ) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchPutGeofenceError`](crate::model::BatchPutGeofenceError)
        pub fn build(self) -> crate::model::BatchPutGeofenceError {
            crate::model::BatchPutGeofenceError {
                geofence_id: self.geofence_id,
                error: self.error,
            }
        }
    }
}
impl BatchPutGeofenceError {
    /// Creates a new builder-style object to manufacture [`BatchPutGeofenceError`](crate::model::BatchPutGeofenceError)
    pub fn builder() -> crate::model::batch_put_geofence_error::Builder {
        crate::model::batch_put_geofence_error::Builder::default()
    }
}

/// <p>Contains a summary of each geofence that was successfully stored in a given geofence collection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchPutGeofenceSuccess {
    /// <p>The geofence successfully stored in a geofence collection.</p>
    pub geofence_id: std::option::Option<std::string::String>,
    /// <p>The timestamp for when the geofence was stored in a geofence collection in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp for when the geofence was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl BatchPutGeofenceSuccess {
    /// <p>The geofence successfully stored in a geofence collection.</p>
    pub fn geofence_id(&self) -> std::option::Option<&str> {
        self.geofence_id.as_deref()
    }
    /// <p>The timestamp for when the geofence was stored in a geofence collection in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
    /// <p>The timestamp for when the geofence was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
}
impl std::fmt::Debug for BatchPutGeofenceSuccess {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchPutGeofenceSuccess");
        formatter.field("geofence_id", &self.geofence_id);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`BatchPutGeofenceSuccess`](crate::model::BatchPutGeofenceSuccess)
pub mod batch_put_geofence_success {
    /// A builder for [`BatchPutGeofenceSuccess`](crate::model::BatchPutGeofenceSuccess)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) geofence_id: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The geofence successfully stored in a geofence collection.</p>
        pub fn geofence_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.geofence_id = Some(input.into());
            self
        }
        /// <p>The geofence successfully stored in a geofence collection.</p>
        pub fn set_geofence_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.geofence_id = input;
            self
        }
        /// <p>The timestamp for when the geofence was stored in a geofence collection in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp for when the geofence was stored in a geofence collection in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The timestamp for when the geofence was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>The timestamp for when the geofence was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchPutGeofenceSuccess`](crate::model::BatchPutGeofenceSuccess)
        pub fn build(self) -> crate::model::BatchPutGeofenceSuccess {
            crate::model::BatchPutGeofenceSuccess {
                geofence_id: self.geofence_id,
                create_time: self.create_time,
                update_time: self.update_time,
            }
        }
    }
}
impl BatchPutGeofenceSuccess {
    /// Creates a new builder-style object to manufacture [`BatchPutGeofenceSuccess`](crate::model::BatchPutGeofenceSuccess)
    pub fn builder() -> crate::model::batch_put_geofence_success::Builder {
        crate::model::batch_put_geofence_success::Builder::default()
    }
}

/// <p>Contains geofence geometry details. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchPutGeofenceRequestEntry {
    /// <p>The identifier for the geofence to be stored in a given geofence collection.</p>
    pub geofence_id: std::option::Option<std::string::String>,
    /// <p>Contains the polygon details to specify the position of the geofence.</p> <note>
    /// <p>Each <a href="https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html">geofence polygon</a> can have a maximum of 1,000 vertices.</p>
    /// </note>
    pub geometry: std::option::Option<crate::model::GeofenceGeometry>,
}
impl BatchPutGeofenceRequestEntry {
    /// <p>The identifier for the geofence to be stored in a given geofence collection.</p>
    pub fn geofence_id(&self) -> std::option::Option<&str> {
        self.geofence_id.as_deref()
    }
    /// <p>Contains the polygon details to specify the position of the geofence.</p> <note>
    /// <p>Each <a href="https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html">geofence polygon</a> can have a maximum of 1,000 vertices.</p>
    /// </note>
    pub fn geometry(&self) -> std::option::Option<&crate::model::GeofenceGeometry> {
        self.geometry.as_ref()
    }
}
impl std::fmt::Debug for BatchPutGeofenceRequestEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchPutGeofenceRequestEntry");
        formatter.field("geofence_id", &self.geofence_id);
        formatter.field("geometry", &self.geometry);
        formatter.finish()
    }
}
/// See [`BatchPutGeofenceRequestEntry`](crate::model::BatchPutGeofenceRequestEntry)
pub mod batch_put_geofence_request_entry {
    /// A builder for [`BatchPutGeofenceRequestEntry`](crate::model::BatchPutGeofenceRequestEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) geofence_id: std::option::Option<std::string::String>,
        pub(crate) geometry: std::option::Option<crate::model::GeofenceGeometry>,
    }
    impl Builder {
        /// <p>The identifier for the geofence to be stored in a given geofence collection.</p>
        pub fn geofence_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.geofence_id = Some(input.into());
            self
        }
        /// <p>The identifier for the geofence to be stored in a given geofence collection.</p>
        pub fn set_geofence_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.geofence_id = input;
            self
        }
        /// <p>Contains the polygon details to specify the position of the geofence.</p> <note>
        /// <p>Each <a href="https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html">geofence polygon</a> can have a maximum of 1,000 vertices.</p>
        /// </note>
        pub fn geometry(mut self, input: crate::model::GeofenceGeometry) -> Self {
            self.geometry = Some(input);
            self
        }
        /// <p>Contains the polygon details to specify the position of the geofence.</p> <note>
        /// <p>Each <a href="https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html">geofence polygon</a> can have a maximum of 1,000 vertices.</p>
        /// </note>
        pub fn set_geometry(
            mut self,
            input: std::option::Option<crate::model::GeofenceGeometry>,
        ) -> Self {
            self.geometry = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchPutGeofenceRequestEntry`](crate::model::BatchPutGeofenceRequestEntry)
        pub fn build(self) -> crate::model::BatchPutGeofenceRequestEntry {
            crate::model::BatchPutGeofenceRequestEntry {
                geofence_id: self.geofence_id,
                geometry: self.geometry,
            }
        }
    }
}
impl BatchPutGeofenceRequestEntry {
    /// Creates a new builder-style object to manufacture [`BatchPutGeofenceRequestEntry`](crate::model::BatchPutGeofenceRequestEntry)
    pub fn builder() -> crate::model::batch_put_geofence_request_entry::Builder {
        crate::model::batch_put_geofence_request_entry::Builder::default()
    }
}

/// <p>Contains error details for each device that failed to evaluate its position against the geofences in a given geofence collection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchEvaluateGeofencesError {
    /// <p>The device associated with the position evaluation error.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>Specifies a timestamp for when the error occurred in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub sample_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Contains details associated to the batch error.</p>
    pub error: std::option::Option<crate::model::BatchItemError>,
}
impl BatchEvaluateGeofencesError {
    /// <p>The device associated with the position evaluation error.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>Specifies a timestamp for when the error occurred in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub fn sample_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.sample_time.as_ref()
    }
    /// <p>Contains details associated to the batch error.</p>
    pub fn error(&self) -> std::option::Option<&crate::model::BatchItemError> {
        self.error.as_ref()
    }
}
impl std::fmt::Debug for BatchEvaluateGeofencesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchEvaluateGeofencesError");
        formatter.field("device_id", &self.device_id);
        formatter.field("sample_time", &self.sample_time);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`BatchEvaluateGeofencesError`](crate::model::BatchEvaluateGeofencesError)
pub mod batch_evaluate_geofences_error {
    /// A builder for [`BatchEvaluateGeofencesError`](crate::model::BatchEvaluateGeofencesError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) sample_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) error: std::option::Option<crate::model::BatchItemError>,
    }
    impl Builder {
        /// <p>The device associated with the position evaluation error.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The device associated with the position evaluation error.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>Specifies a timestamp for when the error occurred in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn sample_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.sample_time = Some(input);
            self
        }
        /// <p>Specifies a timestamp for when the error occurred in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn set_sample_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.sample_time = input;
            self
        }
        /// <p>Contains details associated to the batch error.</p>
        pub fn error(mut self, input: crate::model::BatchItemError) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Contains details associated to the batch error.</p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::BatchItemError>,
        ) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchEvaluateGeofencesError`](crate::model::BatchEvaluateGeofencesError)
        pub fn build(self) -> crate::model::BatchEvaluateGeofencesError {
            crate::model::BatchEvaluateGeofencesError {
                device_id: self.device_id,
                sample_time: self.sample_time,
                error: self.error,
            }
        }
    }
}
impl BatchEvaluateGeofencesError {
    /// Creates a new builder-style object to manufacture [`BatchEvaluateGeofencesError`](crate::model::BatchEvaluateGeofencesError)
    pub fn builder() -> crate::model::batch_evaluate_geofences_error::Builder {
        crate::model::batch_evaluate_geofences_error::Builder::default()
    }
}

/// <p>Contains error details for each geofence that failed to delete from the geofence collection.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteGeofenceError {
    /// <p>The geofence associated with the error message.</p>
    pub geofence_id: std::option::Option<std::string::String>,
    /// <p>Contains details associated to the batch error.</p>
    pub error: std::option::Option<crate::model::BatchItemError>,
}
impl BatchDeleteGeofenceError {
    /// <p>The geofence associated with the error message.</p>
    pub fn geofence_id(&self) -> std::option::Option<&str> {
        self.geofence_id.as_deref()
    }
    /// <p>Contains details associated to the batch error.</p>
    pub fn error(&self) -> std::option::Option<&crate::model::BatchItemError> {
        self.error.as_ref()
    }
}
impl std::fmt::Debug for BatchDeleteGeofenceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteGeofenceError");
        formatter.field("geofence_id", &self.geofence_id);
        formatter.field("error", &self.error);
        formatter.finish()
    }
}
/// See [`BatchDeleteGeofenceError`](crate::model::BatchDeleteGeofenceError)
pub mod batch_delete_geofence_error {
    /// A builder for [`BatchDeleteGeofenceError`](crate::model::BatchDeleteGeofenceError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) geofence_id: std::option::Option<std::string::String>,
        pub(crate) error: std::option::Option<crate::model::BatchItemError>,
    }
    impl Builder {
        /// <p>The geofence associated with the error message.</p>
        pub fn geofence_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.geofence_id = Some(input.into());
            self
        }
        /// <p>The geofence associated with the error message.</p>
        pub fn set_geofence_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.geofence_id = input;
            self
        }
        /// <p>Contains details associated to the batch error.</p>
        pub fn error(mut self, input: crate::model::BatchItemError) -> Self {
            self.error = Some(input);
            self
        }
        /// <p>Contains details associated to the batch error.</p>
        pub fn set_error(
            mut self,
            input: std::option::Option<crate::model::BatchItemError>,
        ) -> Self {
            self.error = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteGeofenceError`](crate::model::BatchDeleteGeofenceError)
        pub fn build(self) -> crate::model::BatchDeleteGeofenceError {
            crate::model::BatchDeleteGeofenceError {
                geofence_id: self.geofence_id,
                error: self.error,
            }
        }
    }
}
impl BatchDeleteGeofenceError {
    /// Creates a new builder-style object to manufacture [`BatchDeleteGeofenceError`](crate::model::BatchDeleteGeofenceError)
    pub fn builder() -> crate::model::batch_delete_geofence_error::Builder {
        crate::model::batch_delete_geofence_error::Builder::default()
    }
}

/// <p>Contains the geofence collection details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGeofenceCollectionsResponseEntry {
    /// <p>The name of the geofence collection.</p>
    pub collection_name: std::option::Option<std::string::String>,
    /// <p>The description for the geofence collection</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
    pub pricing_plan: std::option::Option<crate::model::PricingPlan>,
    /// <p>No longer used. Always returns an empty string.</p>
    pub pricing_plan_data_source: std::option::Option<std::string::String>,
    /// <p>The timestamp for when the geofence collection was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies a timestamp for when the resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ListGeofenceCollectionsResponseEntry {
    /// <p>The name of the geofence collection.</p>
    pub fn collection_name(&self) -> std::option::Option<&str> {
        self.collection_name.as_deref()
    }
    /// <p>The description for the geofence collection</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
    pub fn pricing_plan(&self) -> std::option::Option<&crate::model::PricingPlan> {
        self.pricing_plan.as_ref()
    }
    /// <p>No longer used. Always returns an empty string.</p>
    pub fn pricing_plan_data_source(&self) -> std::option::Option<&str> {
        self.pricing_plan_data_source.as_deref()
    }
    /// <p>The timestamp for when the geofence collection was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
    /// <p>Specifies a timestamp for when the resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
}
impl std::fmt::Debug for ListGeofenceCollectionsResponseEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGeofenceCollectionsResponseEntry");
        formatter.field("collection_name", &self.collection_name);
        formatter.field("description", &self.description);
        formatter.field("pricing_plan", &self.pricing_plan);
        formatter.field("pricing_plan_data_source", &self.pricing_plan_data_source);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`ListGeofenceCollectionsResponseEntry`](crate::model::ListGeofenceCollectionsResponseEntry)
pub mod list_geofence_collections_response_entry {
    /// A builder for [`ListGeofenceCollectionsResponseEntry`](crate::model::ListGeofenceCollectionsResponseEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) collection_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) pricing_plan: std::option::Option<crate::model::PricingPlan>,
        pub(crate) pricing_plan_data_source: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the geofence collection.</p>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.collection_name = Some(input.into());
            self
        }
        /// <p>The name of the geofence collection.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.collection_name = input;
            self
        }
        /// <p>The description for the geofence collection</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the geofence collection</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.pricing_plan = Some(input);
            self
        }
        /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.pricing_plan = input;
            self
        }
        /// <p>No longer used. Always returns an empty string.</p>
        pub fn pricing_plan_data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.pricing_plan_data_source = Some(input.into());
            self
        }
        /// <p>No longer used. Always returns an empty string.</p>
        pub fn set_pricing_plan_data_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pricing_plan_data_source = input;
            self
        }
        /// <p>The timestamp for when the geofence collection was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp for when the geofence collection was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>Specifies a timestamp for when the resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>Specifies a timestamp for when the resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGeofenceCollectionsResponseEntry`](crate::model::ListGeofenceCollectionsResponseEntry)
        pub fn build(self) -> crate::model::ListGeofenceCollectionsResponseEntry {
            crate::model::ListGeofenceCollectionsResponseEntry {
                collection_name: self.collection_name,
                description: self.description,
                pricing_plan: self.pricing_plan,
                pricing_plan_data_source: self.pricing_plan_data_source,
                create_time: self.create_time,
                update_time: self.update_time,
            }
        }
    }
}
impl ListGeofenceCollectionsResponseEntry {
    /// Creates a new builder-style object to manufacture [`ListGeofenceCollectionsResponseEntry`](crate::model::ListGeofenceCollectionsResponseEntry)
    pub fn builder() -> crate::model::list_geofence_collections_response_entry::Builder {
        crate::model::list_geofence_collections_response_entry::Builder::default()
    }
}
