// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateTrackerConsumer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_tracker_consumer`](crate::client::Client::associate_tracker_consumer).
///
/// See [`crate::client::fluent_builders::AssociateTrackerConsumer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateTrackerConsumer {
    _private: (),
}
impl AssociateTrackerConsumer {
    /// Creates a new builder-style object to manufacture [`AssociateTrackerConsumerInput`](crate::input::AssociateTrackerConsumerInput)
    pub fn builder() -> crate::input::associate_tracker_consumer_input::Builder {
        crate::input::associate_tracker_consumer_input::Builder::default()
    }
    /// Creates a new `AssociateTrackerConsumer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateTrackerConsumer {
    type Output = std::result::Result<
        crate::output::AssociateTrackerConsumerOutput,
        crate::error::AssociateTrackerConsumerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_associate_tracker_consumer_error(response)
        } else {
            crate::operation_deser::parse_associate_tracker_consumer_response(response)
        }
    }
}

/// Operation shape for `BatchDeleteDevicePositionHistory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_delete_device_position_history`](crate::client::Client::batch_delete_device_position_history).
///
/// See [`crate::client::fluent_builders::BatchDeleteDevicePositionHistory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDeleteDevicePositionHistory {
    _private: (),
}
impl BatchDeleteDevicePositionHistory {
    /// Creates a new builder-style object to manufacture [`BatchDeleteDevicePositionHistoryInput`](crate::input::BatchDeleteDevicePositionHistoryInput)
    pub fn builder() -> crate::input::batch_delete_device_position_history_input::Builder {
        crate::input::batch_delete_device_position_history_input::Builder::default()
    }
    /// Creates a new `BatchDeleteDevicePositionHistory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDeleteDevicePositionHistory {
    type Output = std::result::Result<
        crate::output::BatchDeleteDevicePositionHistoryOutput,
        crate::error::BatchDeleteDevicePositionHistoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_delete_device_position_history_error(response)
        } else {
            crate::operation_deser::parse_batch_delete_device_position_history_response(response)
        }
    }
}

/// Operation shape for `BatchDeleteGeofence`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_delete_geofence`](crate::client::Client::batch_delete_geofence).
///
/// See [`crate::client::fluent_builders::BatchDeleteGeofence`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDeleteGeofence {
    _private: (),
}
impl BatchDeleteGeofence {
    /// Creates a new builder-style object to manufacture [`BatchDeleteGeofenceInput`](crate::input::BatchDeleteGeofenceInput)
    pub fn builder() -> crate::input::batch_delete_geofence_input::Builder {
        crate::input::batch_delete_geofence_input::Builder::default()
    }
    /// Creates a new `BatchDeleteGeofence` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDeleteGeofence {
    type Output = std::result::Result<
        crate::output::BatchDeleteGeofenceOutput,
        crate::error::BatchDeleteGeofenceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_delete_geofence_error(response)
        } else {
            crate::operation_deser::parse_batch_delete_geofence_response(response)
        }
    }
}

/// Operation shape for `BatchEvaluateGeofences`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_evaluate_geofences`](crate::client::Client::batch_evaluate_geofences).
///
/// See [`crate::client::fluent_builders::BatchEvaluateGeofences`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchEvaluateGeofences {
    _private: (),
}
impl BatchEvaluateGeofences {
    /// Creates a new builder-style object to manufacture [`BatchEvaluateGeofencesInput`](crate::input::BatchEvaluateGeofencesInput)
    pub fn builder() -> crate::input::batch_evaluate_geofences_input::Builder {
        crate::input::batch_evaluate_geofences_input::Builder::default()
    }
    /// Creates a new `BatchEvaluateGeofences` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchEvaluateGeofences {
    type Output = std::result::Result<
        crate::output::BatchEvaluateGeofencesOutput,
        crate::error::BatchEvaluateGeofencesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_evaluate_geofences_error(response)
        } else {
            crate::operation_deser::parse_batch_evaluate_geofences_response(response)
        }
    }
}

/// Operation shape for `BatchGetDevicePosition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_device_position`](crate::client::Client::batch_get_device_position).
///
/// See [`crate::client::fluent_builders::BatchGetDevicePosition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetDevicePosition {
    _private: (),
}
impl BatchGetDevicePosition {
    /// Creates a new builder-style object to manufacture [`BatchGetDevicePositionInput`](crate::input::BatchGetDevicePositionInput)
    pub fn builder() -> crate::input::batch_get_device_position_input::Builder {
        crate::input::batch_get_device_position_input::Builder::default()
    }
    /// Creates a new `BatchGetDevicePosition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetDevicePosition {
    type Output = std::result::Result<
        crate::output::BatchGetDevicePositionOutput,
        crate::error::BatchGetDevicePositionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_device_position_error(response)
        } else {
            crate::operation_deser::parse_batch_get_device_position_response(response)
        }
    }
}

/// Operation shape for `BatchPutGeofence`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_put_geofence`](crate::client::Client::batch_put_geofence).
///
/// See [`crate::client::fluent_builders::BatchPutGeofence`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchPutGeofence {
    _private: (),
}
impl BatchPutGeofence {
    /// Creates a new builder-style object to manufacture [`BatchPutGeofenceInput`](crate::input::BatchPutGeofenceInput)
    pub fn builder() -> crate::input::batch_put_geofence_input::Builder {
        crate::input::batch_put_geofence_input::Builder::default()
    }
    /// Creates a new `BatchPutGeofence` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchPutGeofence {
    type Output = std::result::Result<
        crate::output::BatchPutGeofenceOutput,
        crate::error::BatchPutGeofenceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_put_geofence_error(response)
        } else {
            crate::operation_deser::parse_batch_put_geofence_response(response)
        }
    }
}

/// Operation shape for `BatchUpdateDevicePosition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_update_device_position`](crate::client::Client::batch_update_device_position).
///
/// See [`crate::client::fluent_builders::BatchUpdateDevicePosition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchUpdateDevicePosition {
    _private: (),
}
impl BatchUpdateDevicePosition {
    /// Creates a new builder-style object to manufacture [`BatchUpdateDevicePositionInput`](crate::input::BatchUpdateDevicePositionInput)
    pub fn builder() -> crate::input::batch_update_device_position_input::Builder {
        crate::input::batch_update_device_position_input::Builder::default()
    }
    /// Creates a new `BatchUpdateDevicePosition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchUpdateDevicePosition {
    type Output = std::result::Result<
        crate::output::BatchUpdateDevicePositionOutput,
        crate::error::BatchUpdateDevicePositionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_update_device_position_error(response)
        } else {
            crate::operation_deser::parse_batch_update_device_position_response(response)
        }
    }
}

/// Operation shape for `CalculateRoute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`calculate_route`](crate::client::Client::calculate_route).
///
/// See [`crate::client::fluent_builders::CalculateRoute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CalculateRoute {
    _private: (),
}
impl CalculateRoute {
    /// Creates a new builder-style object to manufacture [`CalculateRouteInput`](crate::input::CalculateRouteInput)
    pub fn builder() -> crate::input::calculate_route_input::Builder {
        crate::input::calculate_route_input::Builder::default()
    }
    /// Creates a new `CalculateRoute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CalculateRoute {
    type Output =
        std::result::Result<crate::output::CalculateRouteOutput, crate::error::CalculateRouteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_calculate_route_error(response)
        } else {
            crate::operation_deser::parse_calculate_route_response(response)
        }
    }
}

/// Operation shape for `CreateGeofenceCollection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_geofence_collection`](crate::client::Client::create_geofence_collection).
///
/// See [`crate::client::fluent_builders::CreateGeofenceCollection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGeofenceCollection {
    _private: (),
}
impl CreateGeofenceCollection {
    /// Creates a new builder-style object to manufacture [`CreateGeofenceCollectionInput`](crate::input::CreateGeofenceCollectionInput)
    pub fn builder() -> crate::input::create_geofence_collection_input::Builder {
        crate::input::create_geofence_collection_input::Builder::default()
    }
    /// Creates a new `CreateGeofenceCollection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGeofenceCollection {
    type Output = std::result::Result<
        crate::output::CreateGeofenceCollectionOutput,
        crate::error::CreateGeofenceCollectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_geofence_collection_error(response)
        } else {
            crate::operation_deser::parse_create_geofence_collection_response(response)
        }
    }
}

/// Operation shape for `CreateMap`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_map`](crate::client::Client::create_map).
///
/// See [`crate::client::fluent_builders::CreateMap`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMap {
    _private: (),
}
impl CreateMap {
    /// Creates a new builder-style object to manufacture [`CreateMapInput`](crate::input::CreateMapInput)
    pub fn builder() -> crate::input::create_map_input::Builder {
        crate::input::create_map_input::Builder::default()
    }
    /// Creates a new `CreateMap` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMap {
    type Output = std::result::Result<crate::output::CreateMapOutput, crate::error::CreateMapError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_map_error(response)
        } else {
            crate::operation_deser::parse_create_map_response(response)
        }
    }
}

/// Operation shape for `CreatePlaceIndex`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_place_index`](crate::client::Client::create_place_index).
///
/// See [`crate::client::fluent_builders::CreatePlaceIndex`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePlaceIndex {
    _private: (),
}
impl CreatePlaceIndex {
    /// Creates a new builder-style object to manufacture [`CreatePlaceIndexInput`](crate::input::CreatePlaceIndexInput)
    pub fn builder() -> crate::input::create_place_index_input::Builder {
        crate::input::create_place_index_input::Builder::default()
    }
    /// Creates a new `CreatePlaceIndex` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePlaceIndex {
    type Output = std::result::Result<
        crate::output::CreatePlaceIndexOutput,
        crate::error::CreatePlaceIndexError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_place_index_error(response)
        } else {
            crate::operation_deser::parse_create_place_index_response(response)
        }
    }
}

/// Operation shape for `CreateRouteCalculator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_route_calculator`](crate::client::Client::create_route_calculator).
///
/// See [`crate::client::fluent_builders::CreateRouteCalculator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRouteCalculator {
    _private: (),
}
impl CreateRouteCalculator {
    /// Creates a new builder-style object to manufacture [`CreateRouteCalculatorInput`](crate::input::CreateRouteCalculatorInput)
    pub fn builder() -> crate::input::create_route_calculator_input::Builder {
        crate::input::create_route_calculator_input::Builder::default()
    }
    /// Creates a new `CreateRouteCalculator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRouteCalculator {
    type Output = std::result::Result<
        crate::output::CreateRouteCalculatorOutput,
        crate::error::CreateRouteCalculatorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_route_calculator_error(response)
        } else {
            crate::operation_deser::parse_create_route_calculator_response(response)
        }
    }
}

/// Operation shape for `CreateTracker`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_tracker`](crate::client::Client::create_tracker).
///
/// See [`crate::client::fluent_builders::CreateTracker`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTracker {
    _private: (),
}
impl CreateTracker {
    /// Creates a new builder-style object to manufacture [`CreateTrackerInput`](crate::input::CreateTrackerInput)
    pub fn builder() -> crate::input::create_tracker_input::Builder {
        crate::input::create_tracker_input::Builder::default()
    }
    /// Creates a new `CreateTracker` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTracker {
    type Output =
        std::result::Result<crate::output::CreateTrackerOutput, crate::error::CreateTrackerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_tracker_error(response)
        } else {
            crate::operation_deser::parse_create_tracker_response(response)
        }
    }
}

/// Operation shape for `DeleteGeofenceCollection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_geofence_collection`](crate::client::Client::delete_geofence_collection).
///
/// See [`crate::client::fluent_builders::DeleteGeofenceCollection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGeofenceCollection {
    _private: (),
}
impl DeleteGeofenceCollection {
    /// Creates a new builder-style object to manufacture [`DeleteGeofenceCollectionInput`](crate::input::DeleteGeofenceCollectionInput)
    pub fn builder() -> crate::input::delete_geofence_collection_input::Builder {
        crate::input::delete_geofence_collection_input::Builder::default()
    }
    /// Creates a new `DeleteGeofenceCollection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGeofenceCollection {
    type Output = std::result::Result<
        crate::output::DeleteGeofenceCollectionOutput,
        crate::error::DeleteGeofenceCollectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_geofence_collection_error(response)
        } else {
            crate::operation_deser::parse_delete_geofence_collection_response(response)
        }
    }
}

/// Operation shape for `DeleteMap`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_map`](crate::client::Client::delete_map).
///
/// See [`crate::client::fluent_builders::DeleteMap`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMap {
    _private: (),
}
impl DeleteMap {
    /// Creates a new builder-style object to manufacture [`DeleteMapInput`](crate::input::DeleteMapInput)
    pub fn builder() -> crate::input::delete_map_input::Builder {
        crate::input::delete_map_input::Builder::default()
    }
    /// Creates a new `DeleteMap` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMap {
    type Output = std::result::Result<crate::output::DeleteMapOutput, crate::error::DeleteMapError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_map_error(response)
        } else {
            crate::operation_deser::parse_delete_map_response(response)
        }
    }
}

/// Operation shape for `DeletePlaceIndex`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_place_index`](crate::client::Client::delete_place_index).
///
/// See [`crate::client::fluent_builders::DeletePlaceIndex`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePlaceIndex {
    _private: (),
}
impl DeletePlaceIndex {
    /// Creates a new builder-style object to manufacture [`DeletePlaceIndexInput`](crate::input::DeletePlaceIndexInput)
    pub fn builder() -> crate::input::delete_place_index_input::Builder {
        crate::input::delete_place_index_input::Builder::default()
    }
    /// Creates a new `DeletePlaceIndex` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePlaceIndex {
    type Output = std::result::Result<
        crate::output::DeletePlaceIndexOutput,
        crate::error::DeletePlaceIndexError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_place_index_error(response)
        } else {
            crate::operation_deser::parse_delete_place_index_response(response)
        }
    }
}

/// Operation shape for `DeleteRouteCalculator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_route_calculator`](crate::client::Client::delete_route_calculator).
///
/// See [`crate::client::fluent_builders::DeleteRouteCalculator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRouteCalculator {
    _private: (),
}
impl DeleteRouteCalculator {
    /// Creates a new builder-style object to manufacture [`DeleteRouteCalculatorInput`](crate::input::DeleteRouteCalculatorInput)
    pub fn builder() -> crate::input::delete_route_calculator_input::Builder {
        crate::input::delete_route_calculator_input::Builder::default()
    }
    /// Creates a new `DeleteRouteCalculator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRouteCalculator {
    type Output = std::result::Result<
        crate::output::DeleteRouteCalculatorOutput,
        crate::error::DeleteRouteCalculatorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_route_calculator_error(response)
        } else {
            crate::operation_deser::parse_delete_route_calculator_response(response)
        }
    }
}

/// Operation shape for `DeleteTracker`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_tracker`](crate::client::Client::delete_tracker).
///
/// See [`crate::client::fluent_builders::DeleteTracker`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTracker {
    _private: (),
}
impl DeleteTracker {
    /// Creates a new builder-style object to manufacture [`DeleteTrackerInput`](crate::input::DeleteTrackerInput)
    pub fn builder() -> crate::input::delete_tracker_input::Builder {
        crate::input::delete_tracker_input::Builder::default()
    }
    /// Creates a new `DeleteTracker` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTracker {
    type Output =
        std::result::Result<crate::output::DeleteTrackerOutput, crate::error::DeleteTrackerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_tracker_error(response)
        } else {
            crate::operation_deser::parse_delete_tracker_response(response)
        }
    }
}

/// Operation shape for `DescribeGeofenceCollection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_geofence_collection`](crate::client::Client::describe_geofence_collection).
///
/// See [`crate::client::fluent_builders::DescribeGeofenceCollection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeGeofenceCollection {
    _private: (),
}
impl DescribeGeofenceCollection {
    /// Creates a new builder-style object to manufacture [`DescribeGeofenceCollectionInput`](crate::input::DescribeGeofenceCollectionInput)
    pub fn builder() -> crate::input::describe_geofence_collection_input::Builder {
        crate::input::describe_geofence_collection_input::Builder::default()
    }
    /// Creates a new `DescribeGeofenceCollection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeGeofenceCollection {
    type Output = std::result::Result<
        crate::output::DescribeGeofenceCollectionOutput,
        crate::error::DescribeGeofenceCollectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_geofence_collection_error(response)
        } else {
            crate::operation_deser::parse_describe_geofence_collection_response(response)
        }
    }
}

/// Operation shape for `DescribeMap`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_map`](crate::client::Client::describe_map).
///
/// See [`crate::client::fluent_builders::DescribeMap`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMap {
    _private: (),
}
impl DescribeMap {
    /// Creates a new builder-style object to manufacture [`DescribeMapInput`](crate::input::DescribeMapInput)
    pub fn builder() -> crate::input::describe_map_input::Builder {
        crate::input::describe_map_input::Builder::default()
    }
    /// Creates a new `DescribeMap` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMap {
    type Output =
        std::result::Result<crate::output::DescribeMapOutput, crate::error::DescribeMapError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_map_error(response)
        } else {
            crate::operation_deser::parse_describe_map_response(response)
        }
    }
}

/// Operation shape for `DescribePlaceIndex`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_place_index`](crate::client::Client::describe_place_index).
///
/// See [`crate::client::fluent_builders::DescribePlaceIndex`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribePlaceIndex {
    _private: (),
}
impl DescribePlaceIndex {
    /// Creates a new builder-style object to manufacture [`DescribePlaceIndexInput`](crate::input::DescribePlaceIndexInput)
    pub fn builder() -> crate::input::describe_place_index_input::Builder {
        crate::input::describe_place_index_input::Builder::default()
    }
    /// Creates a new `DescribePlaceIndex` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribePlaceIndex {
    type Output = std::result::Result<
        crate::output::DescribePlaceIndexOutput,
        crate::error::DescribePlaceIndexError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_place_index_error(response)
        } else {
            crate::operation_deser::parse_describe_place_index_response(response)
        }
    }
}

/// Operation shape for `DescribeRouteCalculator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_route_calculator`](crate::client::Client::describe_route_calculator).
///
/// See [`crate::client::fluent_builders::DescribeRouteCalculator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeRouteCalculator {
    _private: (),
}
impl DescribeRouteCalculator {
    /// Creates a new builder-style object to manufacture [`DescribeRouteCalculatorInput`](crate::input::DescribeRouteCalculatorInput)
    pub fn builder() -> crate::input::describe_route_calculator_input::Builder {
        crate::input::describe_route_calculator_input::Builder::default()
    }
    /// Creates a new `DescribeRouteCalculator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeRouteCalculator {
    type Output = std::result::Result<
        crate::output::DescribeRouteCalculatorOutput,
        crate::error::DescribeRouteCalculatorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_route_calculator_error(response)
        } else {
            crate::operation_deser::parse_describe_route_calculator_response(response)
        }
    }
}

/// Operation shape for `DescribeTracker`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_tracker`](crate::client::Client::describe_tracker).
///
/// See [`crate::client::fluent_builders::DescribeTracker`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeTracker {
    _private: (),
}
impl DescribeTracker {
    /// Creates a new builder-style object to manufacture [`DescribeTrackerInput`](crate::input::DescribeTrackerInput)
    pub fn builder() -> crate::input::describe_tracker_input::Builder {
        crate::input::describe_tracker_input::Builder::default()
    }
    /// Creates a new `DescribeTracker` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeTracker {
    type Output = std::result::Result<
        crate::output::DescribeTrackerOutput,
        crate::error::DescribeTrackerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_tracker_error(response)
        } else {
            crate::operation_deser::parse_describe_tracker_response(response)
        }
    }
}

/// Operation shape for `DisassociateTrackerConsumer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_tracker_consumer`](crate::client::Client::disassociate_tracker_consumer).
///
/// See [`crate::client::fluent_builders::DisassociateTrackerConsumer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateTrackerConsumer {
    _private: (),
}
impl DisassociateTrackerConsumer {
    /// Creates a new builder-style object to manufacture [`DisassociateTrackerConsumerInput`](crate::input::DisassociateTrackerConsumerInput)
    pub fn builder() -> crate::input::disassociate_tracker_consumer_input::Builder {
        crate::input::disassociate_tracker_consumer_input::Builder::default()
    }
    /// Creates a new `DisassociateTrackerConsumer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateTrackerConsumer {
    type Output = std::result::Result<
        crate::output::DisassociateTrackerConsumerOutput,
        crate::error::DisassociateTrackerConsumerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_tracker_consumer_error(response)
        } else {
            crate::operation_deser::parse_disassociate_tracker_consumer_response(response)
        }
    }
}

/// Operation shape for `GetDevicePosition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_device_position`](crate::client::Client::get_device_position).
///
/// See [`crate::client::fluent_builders::GetDevicePosition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDevicePosition {
    _private: (),
}
impl GetDevicePosition {
    /// Creates a new builder-style object to manufacture [`GetDevicePositionInput`](crate::input::GetDevicePositionInput)
    pub fn builder() -> crate::input::get_device_position_input::Builder {
        crate::input::get_device_position_input::Builder::default()
    }
    /// Creates a new `GetDevicePosition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDevicePosition {
    type Output = std::result::Result<
        crate::output::GetDevicePositionOutput,
        crate::error::GetDevicePositionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_device_position_error(response)
        } else {
            crate::operation_deser::parse_get_device_position_response(response)
        }
    }
}

/// Operation shape for `GetDevicePositionHistory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_device_position_history`](crate::client::Client::get_device_position_history).
///
/// See [`crate::client::fluent_builders::GetDevicePositionHistory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDevicePositionHistory {
    _private: (),
}
impl GetDevicePositionHistory {
    /// Creates a new builder-style object to manufacture [`GetDevicePositionHistoryInput`](crate::input::GetDevicePositionHistoryInput)
    pub fn builder() -> crate::input::get_device_position_history_input::Builder {
        crate::input::get_device_position_history_input::Builder::default()
    }
    /// Creates a new `GetDevicePositionHistory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDevicePositionHistory {
    type Output = std::result::Result<
        crate::output::GetDevicePositionHistoryOutput,
        crate::error::GetDevicePositionHistoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_device_position_history_error(response)
        } else {
            crate::operation_deser::parse_get_device_position_history_response(response)
        }
    }
}

/// Operation shape for `GetGeofence`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_geofence`](crate::client::Client::get_geofence).
///
/// See [`crate::client::fluent_builders::GetGeofence`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetGeofence {
    _private: (),
}
impl GetGeofence {
    /// Creates a new builder-style object to manufacture [`GetGeofenceInput`](crate::input::GetGeofenceInput)
    pub fn builder() -> crate::input::get_geofence_input::Builder {
        crate::input::get_geofence_input::Builder::default()
    }
    /// Creates a new `GetGeofence` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetGeofence {
    type Output =
        std::result::Result<crate::output::GetGeofenceOutput, crate::error::GetGeofenceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_geofence_error(response)
        } else {
            crate::operation_deser::parse_get_geofence_response(response)
        }
    }
}

/// Operation shape for `GetMapGlyphs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_map_glyphs`](crate::client::Client::get_map_glyphs).
///
/// See [`crate::client::fluent_builders::GetMapGlyphs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMapGlyphs {
    _private: (),
}
impl GetMapGlyphs {
    /// Creates a new builder-style object to manufacture [`GetMapGlyphsInput`](crate::input::GetMapGlyphsInput)
    pub fn builder() -> crate::input::get_map_glyphs_input::Builder {
        crate::input::get_map_glyphs_input::Builder::default()
    }
    /// Creates a new `GetMapGlyphs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMapGlyphs {
    type Output =
        std::result::Result<crate::output::GetMapGlyphsOutput, crate::error::GetMapGlyphsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_map_glyphs_error(response)
        } else {
            crate::operation_deser::parse_get_map_glyphs_response(response)
        }
    }
}

/// Operation shape for `GetMapSprites`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_map_sprites`](crate::client::Client::get_map_sprites).
///
/// See [`crate::client::fluent_builders::GetMapSprites`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMapSprites {
    _private: (),
}
impl GetMapSprites {
    /// Creates a new builder-style object to manufacture [`GetMapSpritesInput`](crate::input::GetMapSpritesInput)
    pub fn builder() -> crate::input::get_map_sprites_input::Builder {
        crate::input::get_map_sprites_input::Builder::default()
    }
    /// Creates a new `GetMapSprites` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMapSprites {
    type Output =
        std::result::Result<crate::output::GetMapSpritesOutput, crate::error::GetMapSpritesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_map_sprites_error(response)
        } else {
            crate::operation_deser::parse_get_map_sprites_response(response)
        }
    }
}

/// Operation shape for `GetMapStyleDescriptor`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_map_style_descriptor`](crate::client::Client::get_map_style_descriptor).
///
/// See [`crate::client::fluent_builders::GetMapStyleDescriptor`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMapStyleDescriptor {
    _private: (),
}
impl GetMapStyleDescriptor {
    /// Creates a new builder-style object to manufacture [`GetMapStyleDescriptorInput`](crate::input::GetMapStyleDescriptorInput)
    pub fn builder() -> crate::input::get_map_style_descriptor_input::Builder {
        crate::input::get_map_style_descriptor_input::Builder::default()
    }
    /// Creates a new `GetMapStyleDescriptor` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMapStyleDescriptor {
    type Output = std::result::Result<
        crate::output::GetMapStyleDescriptorOutput,
        crate::error::GetMapStyleDescriptorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_map_style_descriptor_error(response)
        } else {
            crate::operation_deser::parse_get_map_style_descriptor_response(response)
        }
    }
}

/// Operation shape for `GetMapTile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_map_tile`](crate::client::Client::get_map_tile).
///
/// See [`crate::client::fluent_builders::GetMapTile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMapTile {
    _private: (),
}
impl GetMapTile {
    /// Creates a new builder-style object to manufacture [`GetMapTileInput`](crate::input::GetMapTileInput)
    pub fn builder() -> crate::input::get_map_tile_input::Builder {
        crate::input::get_map_tile_input::Builder::default()
    }
    /// Creates a new `GetMapTile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMapTile {
    type Output =
        std::result::Result<crate::output::GetMapTileOutput, crate::error::GetMapTileError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_map_tile_error(response)
        } else {
            crate::operation_deser::parse_get_map_tile_response(response)
        }
    }
}

/// Operation shape for `ListDevicePositions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_device_positions`](crate::client::Client::list_device_positions).
///
/// See [`crate::client::fluent_builders::ListDevicePositions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDevicePositions {
    _private: (),
}
impl ListDevicePositions {
    /// Creates a new builder-style object to manufacture [`ListDevicePositionsInput`](crate::input::ListDevicePositionsInput)
    pub fn builder() -> crate::input::list_device_positions_input::Builder {
        crate::input::list_device_positions_input::Builder::default()
    }
    /// Creates a new `ListDevicePositions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDevicePositions {
    type Output = std::result::Result<
        crate::output::ListDevicePositionsOutput,
        crate::error::ListDevicePositionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_device_positions_error(response)
        } else {
            crate::operation_deser::parse_list_device_positions_response(response)
        }
    }
}

/// Operation shape for `ListGeofenceCollections`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_geofence_collections`](crate::client::Client::list_geofence_collections).
///
/// See [`crate::client::fluent_builders::ListGeofenceCollections`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGeofenceCollections {
    _private: (),
}
impl ListGeofenceCollections {
    /// Creates a new builder-style object to manufacture [`ListGeofenceCollectionsInput`](crate::input::ListGeofenceCollectionsInput)
    pub fn builder() -> crate::input::list_geofence_collections_input::Builder {
        crate::input::list_geofence_collections_input::Builder::default()
    }
    /// Creates a new `ListGeofenceCollections` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGeofenceCollections {
    type Output = std::result::Result<
        crate::output::ListGeofenceCollectionsOutput,
        crate::error::ListGeofenceCollectionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_geofence_collections_error(response)
        } else {
            crate::operation_deser::parse_list_geofence_collections_response(response)
        }
    }
}

/// Operation shape for `ListGeofences`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_geofences`](crate::client::Client::list_geofences).
///
/// See [`crate::client::fluent_builders::ListGeofences`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListGeofences {
    _private: (),
}
impl ListGeofences {
    /// Creates a new builder-style object to manufacture [`ListGeofencesInput`](crate::input::ListGeofencesInput)
    pub fn builder() -> crate::input::list_geofences_input::Builder {
        crate::input::list_geofences_input::Builder::default()
    }
    /// Creates a new `ListGeofences` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListGeofences {
    type Output =
        std::result::Result<crate::output::ListGeofencesOutput, crate::error::ListGeofencesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_geofences_error(response)
        } else {
            crate::operation_deser::parse_list_geofences_response(response)
        }
    }
}

/// Operation shape for `ListMaps`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_maps`](crate::client::Client::list_maps).
///
/// See [`crate::client::fluent_builders::ListMaps`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMaps {
    _private: (),
}
impl ListMaps {
    /// Creates a new builder-style object to manufacture [`ListMapsInput`](crate::input::ListMapsInput)
    pub fn builder() -> crate::input::list_maps_input::Builder {
        crate::input::list_maps_input::Builder::default()
    }
    /// Creates a new `ListMaps` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMaps {
    type Output = std::result::Result<crate::output::ListMapsOutput, crate::error::ListMapsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_maps_error(response)
        } else {
            crate::operation_deser::parse_list_maps_response(response)
        }
    }
}

/// Operation shape for `ListPlaceIndexes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_place_indexes`](crate::client::Client::list_place_indexes).
///
/// See [`crate::client::fluent_builders::ListPlaceIndexes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPlaceIndexes {
    _private: (),
}
impl ListPlaceIndexes {
    /// Creates a new builder-style object to manufacture [`ListPlaceIndexesInput`](crate::input::ListPlaceIndexesInput)
    pub fn builder() -> crate::input::list_place_indexes_input::Builder {
        crate::input::list_place_indexes_input::Builder::default()
    }
    /// Creates a new `ListPlaceIndexes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPlaceIndexes {
    type Output = std::result::Result<
        crate::output::ListPlaceIndexesOutput,
        crate::error::ListPlaceIndexesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_place_indexes_error(response)
        } else {
            crate::operation_deser::parse_list_place_indexes_response(response)
        }
    }
}

/// Operation shape for `ListRouteCalculators`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_route_calculators`](crate::client::Client::list_route_calculators).
///
/// See [`crate::client::fluent_builders::ListRouteCalculators`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListRouteCalculators {
    _private: (),
}
impl ListRouteCalculators {
    /// Creates a new builder-style object to manufacture [`ListRouteCalculatorsInput`](crate::input::ListRouteCalculatorsInput)
    pub fn builder() -> crate::input::list_route_calculators_input::Builder {
        crate::input::list_route_calculators_input::Builder::default()
    }
    /// Creates a new `ListRouteCalculators` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListRouteCalculators {
    type Output = std::result::Result<
        crate::output::ListRouteCalculatorsOutput,
        crate::error::ListRouteCalculatorsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_route_calculators_error(response)
        } else {
            crate::operation_deser::parse_list_route_calculators_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListTrackerConsumers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tracker_consumers`](crate::client::Client::list_tracker_consumers).
///
/// See [`crate::client::fluent_builders::ListTrackerConsumers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTrackerConsumers {
    _private: (),
}
impl ListTrackerConsumers {
    /// Creates a new builder-style object to manufacture [`ListTrackerConsumersInput`](crate::input::ListTrackerConsumersInput)
    pub fn builder() -> crate::input::list_tracker_consumers_input::Builder {
        crate::input::list_tracker_consumers_input::Builder::default()
    }
    /// Creates a new `ListTrackerConsumers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTrackerConsumers {
    type Output = std::result::Result<
        crate::output::ListTrackerConsumersOutput,
        crate::error::ListTrackerConsumersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tracker_consumers_error(response)
        } else {
            crate::operation_deser::parse_list_tracker_consumers_response(response)
        }
    }
}

/// Operation shape for `ListTrackers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_trackers`](crate::client::Client::list_trackers).
///
/// See [`crate::client::fluent_builders::ListTrackers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTrackers {
    _private: (),
}
impl ListTrackers {
    /// Creates a new builder-style object to manufacture [`ListTrackersInput`](crate::input::ListTrackersInput)
    pub fn builder() -> crate::input::list_trackers_input::Builder {
        crate::input::list_trackers_input::Builder::default()
    }
    /// Creates a new `ListTrackers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTrackers {
    type Output =
        std::result::Result<crate::output::ListTrackersOutput, crate::error::ListTrackersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_trackers_error(response)
        } else {
            crate::operation_deser::parse_list_trackers_response(response)
        }
    }
}

/// Operation shape for `PutGeofence`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_geofence`](crate::client::Client::put_geofence).
///
/// See [`crate::client::fluent_builders::PutGeofence`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutGeofence {
    _private: (),
}
impl PutGeofence {
    /// Creates a new builder-style object to manufacture [`PutGeofenceInput`](crate::input::PutGeofenceInput)
    pub fn builder() -> crate::input::put_geofence_input::Builder {
        crate::input::put_geofence_input::Builder::default()
    }
    /// Creates a new `PutGeofence` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutGeofence {
    type Output =
        std::result::Result<crate::output::PutGeofenceOutput, crate::error::PutGeofenceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_geofence_error(response)
        } else {
            crate::operation_deser::parse_put_geofence_response(response)
        }
    }
}

/// Operation shape for `SearchPlaceIndexForPosition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_place_index_for_position`](crate::client::Client::search_place_index_for_position).
///
/// See [`crate::client::fluent_builders::SearchPlaceIndexForPosition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchPlaceIndexForPosition {
    _private: (),
}
impl SearchPlaceIndexForPosition {
    /// Creates a new builder-style object to manufacture [`SearchPlaceIndexForPositionInput`](crate::input::SearchPlaceIndexForPositionInput)
    pub fn builder() -> crate::input::search_place_index_for_position_input::Builder {
        crate::input::search_place_index_for_position_input::Builder::default()
    }
    /// Creates a new `SearchPlaceIndexForPosition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchPlaceIndexForPosition {
    type Output = std::result::Result<
        crate::output::SearchPlaceIndexForPositionOutput,
        crate::error::SearchPlaceIndexForPositionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_place_index_for_position_error(response)
        } else {
            crate::operation_deser::parse_search_place_index_for_position_response(response)
        }
    }
}

/// Operation shape for `SearchPlaceIndexForSuggestions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_place_index_for_suggestions`](crate::client::Client::search_place_index_for_suggestions).
///
/// See [`crate::client::fluent_builders::SearchPlaceIndexForSuggestions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchPlaceIndexForSuggestions {
    _private: (),
}
impl SearchPlaceIndexForSuggestions {
    /// Creates a new builder-style object to manufacture [`SearchPlaceIndexForSuggestionsInput`](crate::input::SearchPlaceIndexForSuggestionsInput)
    pub fn builder() -> crate::input::search_place_index_for_suggestions_input::Builder {
        crate::input::search_place_index_for_suggestions_input::Builder::default()
    }
    /// Creates a new `SearchPlaceIndexForSuggestions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchPlaceIndexForSuggestions {
    type Output = std::result::Result<
        crate::output::SearchPlaceIndexForSuggestionsOutput,
        crate::error::SearchPlaceIndexForSuggestionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_place_index_for_suggestions_error(response)
        } else {
            crate::operation_deser::parse_search_place_index_for_suggestions_response(response)
        }
    }
}

/// Operation shape for `SearchPlaceIndexForText`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_place_index_for_text`](crate::client::Client::search_place_index_for_text).
///
/// See [`crate::client::fluent_builders::SearchPlaceIndexForText`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchPlaceIndexForText {
    _private: (),
}
impl SearchPlaceIndexForText {
    /// Creates a new builder-style object to manufacture [`SearchPlaceIndexForTextInput`](crate::input::SearchPlaceIndexForTextInput)
    pub fn builder() -> crate::input::search_place_index_for_text_input::Builder {
        crate::input::search_place_index_for_text_input::Builder::default()
    }
    /// Creates a new `SearchPlaceIndexForText` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchPlaceIndexForText {
    type Output = std::result::Result<
        crate::output::SearchPlaceIndexForTextOutput,
        crate::error::SearchPlaceIndexForTextError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_place_index_for_text_error(response)
        } else {
            crate::operation_deser::parse_search_place_index_for_text_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateGeofenceCollection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_geofence_collection`](crate::client::Client::update_geofence_collection).
///
/// See [`crate::client::fluent_builders::UpdateGeofenceCollection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateGeofenceCollection {
    _private: (),
}
impl UpdateGeofenceCollection {
    /// Creates a new builder-style object to manufacture [`UpdateGeofenceCollectionInput`](crate::input::UpdateGeofenceCollectionInput)
    pub fn builder() -> crate::input::update_geofence_collection_input::Builder {
        crate::input::update_geofence_collection_input::Builder::default()
    }
    /// Creates a new `UpdateGeofenceCollection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateGeofenceCollection {
    type Output = std::result::Result<
        crate::output::UpdateGeofenceCollectionOutput,
        crate::error::UpdateGeofenceCollectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_geofence_collection_error(response)
        } else {
            crate::operation_deser::parse_update_geofence_collection_response(response)
        }
    }
}

/// Operation shape for `UpdateMap`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_map`](crate::client::Client::update_map).
///
/// See [`crate::client::fluent_builders::UpdateMap`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateMap {
    _private: (),
}
impl UpdateMap {
    /// Creates a new builder-style object to manufacture [`UpdateMapInput`](crate::input::UpdateMapInput)
    pub fn builder() -> crate::input::update_map_input::Builder {
        crate::input::update_map_input::Builder::default()
    }
    /// Creates a new `UpdateMap` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateMap {
    type Output = std::result::Result<crate::output::UpdateMapOutput, crate::error::UpdateMapError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_map_error(response)
        } else {
            crate::operation_deser::parse_update_map_response(response)
        }
    }
}

/// Operation shape for `UpdatePlaceIndex`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_place_index`](crate::client::Client::update_place_index).
///
/// See [`crate::client::fluent_builders::UpdatePlaceIndex`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePlaceIndex {
    _private: (),
}
impl UpdatePlaceIndex {
    /// Creates a new builder-style object to manufacture [`UpdatePlaceIndexInput`](crate::input::UpdatePlaceIndexInput)
    pub fn builder() -> crate::input::update_place_index_input::Builder {
        crate::input::update_place_index_input::Builder::default()
    }
    /// Creates a new `UpdatePlaceIndex` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePlaceIndex {
    type Output = std::result::Result<
        crate::output::UpdatePlaceIndexOutput,
        crate::error::UpdatePlaceIndexError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_place_index_error(response)
        } else {
            crate::operation_deser::parse_update_place_index_response(response)
        }
    }
}

/// Operation shape for `UpdateRouteCalculator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_route_calculator`](crate::client::Client::update_route_calculator).
///
/// See [`crate::client::fluent_builders::UpdateRouteCalculator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRouteCalculator {
    _private: (),
}
impl UpdateRouteCalculator {
    /// Creates a new builder-style object to manufacture [`UpdateRouteCalculatorInput`](crate::input::UpdateRouteCalculatorInput)
    pub fn builder() -> crate::input::update_route_calculator_input::Builder {
        crate::input::update_route_calculator_input::Builder::default()
    }
    /// Creates a new `UpdateRouteCalculator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRouteCalculator {
    type Output = std::result::Result<
        crate::output::UpdateRouteCalculatorOutput,
        crate::error::UpdateRouteCalculatorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_route_calculator_error(response)
        } else {
            crate::operation_deser::parse_update_route_calculator_response(response)
        }
    }
}

/// Operation shape for `UpdateTracker`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_tracker`](crate::client::Client::update_tracker).
///
/// See [`crate::client::fluent_builders::UpdateTracker`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateTracker {
    _private: (),
}
impl UpdateTracker {
    /// Creates a new builder-style object to manufacture [`UpdateTrackerInput`](crate::input::UpdateTrackerInput)
    pub fn builder() -> crate::input::update_tracker_input::Builder {
        crate::input::update_tracker_input::Builder::default()
    }
    /// Creates a new `UpdateTracker` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateTracker {
    type Output =
        std::result::Result<crate::output::UpdateTrackerOutput, crate::error::UpdateTrackerError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_tracker_error(response)
        } else {
            crate::operation_deser::parse_update_tracker_response(response)
        }
    }
}
