// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrackerConsumersOutput {
    /// <p>Contains the list of geofence collection ARNs associated to the tracker resource.</p>
    pub consumer_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTrackerConsumersOutput {
    /// <p>Contains the list of geofence collection ARNs associated to the tracker resource.</p>
    pub fn consumer_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.consumer_arns.as_deref()
    }
    /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTrackerConsumersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrackerConsumersOutput");
        formatter.field("consumer_arns", &self.consumer_arns);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTrackerConsumersOutput`](crate::output::ListTrackerConsumersOutput)
pub mod list_tracker_consumers_output {
    /// A builder for [`ListTrackerConsumersOutput`](crate::output::ListTrackerConsumersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) consumer_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `consumer_arns`.
        ///
        /// To override the contents of this collection use [`set_consumer_arns`](Self::set_consumer_arns).
        ///
        /// <p>Contains the list of geofence collection ARNs associated to the tracker resource.</p>
        pub fn consumer_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.consumer_arns.unwrap_or_default();
            v.push(input.into());
            self.consumer_arns = Some(v);
            self
        }
        /// <p>Contains the list of geofence collection ARNs associated to the tracker resource.</p>
        pub fn set_consumer_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.consumer_arns = input;
            self
        }
        /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrackerConsumersOutput`](crate::output::ListTrackerConsumersOutput)
        pub fn build(self) -> crate::output::ListTrackerConsumersOutput {
            crate::output::ListTrackerConsumersOutput {
                consumer_arns: self.consumer_arns,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTrackerConsumersOutput {
    /// Creates a new builder-style object to manufacture [`ListTrackerConsumersOutput`](crate::output::ListTrackerConsumersOutput)
    pub fn builder() -> crate::output::list_tracker_consumers_output::Builder {
        crate::output::list_tracker_consumers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDevicePositionsOutput {
    /// <p>Contains details about each device's last known position. These details includes the device ID, the time when the position was sampled on the device, the time that the service received the update, and the most recent coordinates.</p>
    pub entries: std::option::Option<std::vec::Vec<crate::model::ListDevicePositionsResponseEntry>>,
    /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDevicePositionsOutput {
    /// <p>Contains details about each device's last known position. These details includes the device ID, the time when the position was sampled on the device, the time that the service received the update, and the most recent coordinates.</p>
    pub fn entries(
        &self,
    ) -> std::option::Option<&[crate::model::ListDevicePositionsResponseEntry]> {
        self.entries.as_deref()
    }
    /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDevicePositionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDevicePositionsOutput");
        formatter.field("entries", &self.entries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDevicePositionsOutput`](crate::output::ListDevicePositionsOutput)
pub mod list_device_positions_output {
    /// A builder for [`ListDevicePositionsOutput`](crate::output::ListDevicePositionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entries:
            std::option::Option<std::vec::Vec<crate::model::ListDevicePositionsResponseEntry>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>Contains details about each device's last known position. These details includes the device ID, the time when the position was sampled on the device, the time that the service received the update, and the most recent coordinates.</p>
        pub fn entries(mut self, input: crate::model::ListDevicePositionsResponseEntry) -> Self {
            let mut v = self.entries.unwrap_or_default();
            v.push(input);
            self.entries = Some(v);
            self
        }
        /// <p>Contains details about each device's last known position. These details includes the device ID, the time when the position was sampled on the device, the time that the service received the update, and the most recent coordinates.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ListDevicePositionsResponseEntry>,
            >,
        ) -> Self {
            self.entries = input;
            self
        }
        /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDevicePositionsOutput`](crate::output::ListDevicePositionsOutput)
        pub fn build(self) -> crate::output::ListDevicePositionsOutput {
            crate::output::ListDevicePositionsOutput {
                entries: self.entries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDevicePositionsOutput {
    /// Creates a new builder-style object to manufacture [`ListDevicePositionsOutput`](crate::output::ListDevicePositionsOutput)
    pub fn builder() -> crate::output::list_device_positions_output::Builder {
        crate::output::list_device_positions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDevicePositionHistoryOutput {
    /// <p>Contains the position history details for the requested device.</p>
    pub device_positions: std::option::Option<std::vec::Vec<crate::model::DevicePosition>>,
    /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetDevicePositionHistoryOutput {
    /// <p>Contains the position history details for the requested device.</p>
    pub fn device_positions(&self) -> std::option::Option<&[crate::model::DevicePosition]> {
        self.device_positions.as_deref()
    }
    /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetDevicePositionHistoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDevicePositionHistoryOutput");
        formatter.field("device_positions", &self.device_positions);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetDevicePositionHistoryOutput`](crate::output::GetDevicePositionHistoryOutput)
pub mod get_device_position_history_output {
    /// A builder for [`GetDevicePositionHistoryOutput`](crate::output::GetDevicePositionHistoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_positions:
            std::option::Option<std::vec::Vec<crate::model::DevicePosition>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `device_positions`.
        ///
        /// To override the contents of this collection use [`set_device_positions`](Self::set_device_positions).
        ///
        /// <p>Contains the position history details for the requested device.</p>
        pub fn device_positions(mut self, input: crate::model::DevicePosition) -> Self {
            let mut v = self.device_positions.unwrap_or_default();
            v.push(input);
            self.device_positions = Some(v);
            self
        }
        /// <p>Contains the position history details for the requested device.</p>
        pub fn set_device_positions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DevicePosition>>,
        ) -> Self {
            self.device_positions = input;
            self
        }
        /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDevicePositionHistoryOutput`](crate::output::GetDevicePositionHistoryOutput)
        pub fn build(self) -> crate::output::GetDevicePositionHistoryOutput {
            crate::output::GetDevicePositionHistoryOutput {
                device_positions: self.device_positions,
                next_token: self.next_token,
            }
        }
    }
}
impl GetDevicePositionHistoryOutput {
    /// Creates a new builder-style object to manufacture [`GetDevicePositionHistoryOutput`](crate::output::GetDevicePositionHistoryOutput)
    pub fn builder() -> crate::output::get_device_position_history_output::Builder {
        crate::output::get_device_position_history_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDevicePositionOutput {
    /// <p>The device whose position you retrieved.</p>
    pub device_id: std::option::Option<std::string::String>,
    /// <p>The timestamp at which the device's position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601 </a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub sample_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp for when the tracker resource received the device position in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601 </a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub received_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last known device position.</p>
    pub position: std::option::Option<std::vec::Vec<f64>>,
    /// <p>The accuracy of the device position.</p>
    pub accuracy: std::option::Option<crate::model::PositionalAccuracy>,
    /// <p>The properties associated with the position.</p>
    pub position_properties:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetDevicePositionOutput {
    /// <p>The device whose position you retrieved.</p>
    pub fn device_id(&self) -> std::option::Option<&str> {
        self.device_id.as_deref()
    }
    /// <p>The timestamp at which the device's position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601 </a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub fn sample_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.sample_time.as_ref()
    }
    /// <p>The timestamp for when the tracker resource received the device position in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601 </a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub fn received_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.received_time.as_ref()
    }
    /// <p>The last known device position.</p>
    pub fn position(&self) -> std::option::Option<&[f64]> {
        self.position.as_deref()
    }
    /// <p>The accuracy of the device position.</p>
    pub fn accuracy(&self) -> std::option::Option<&crate::model::PositionalAccuracy> {
        self.accuracy.as_ref()
    }
    /// <p>The properties associated with the position.</p>
    pub fn position_properties(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.position_properties.as_ref()
    }
}
impl std::fmt::Debug for GetDevicePositionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDevicePositionOutput");
        formatter.field("device_id", &self.device_id);
        formatter.field("sample_time", &self.sample_time);
        formatter.field("received_time", &self.received_time);
        formatter.field("position", &"*** Sensitive Data Redacted ***");
        formatter.field("accuracy", &self.accuracy);
        formatter.field("position_properties", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`GetDevicePositionOutput`](crate::output::GetDevicePositionOutput)
pub mod get_device_position_output {
    /// A builder for [`GetDevicePositionOutput`](crate::output::GetDevicePositionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) sample_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) received_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) position: std::option::Option<std::vec::Vec<f64>>,
        pub(crate) accuracy: std::option::Option<crate::model::PositionalAccuracy>,
        pub(crate) position_properties: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The device whose position you retrieved.</p>
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// <p>The device whose position you retrieved.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// <p>The timestamp at which the device's position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601 </a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn sample_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.sample_time = Some(input);
            self
        }
        /// <p>The timestamp at which the device's position was determined. Uses <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601 </a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn set_sample_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.sample_time = input;
            self
        }
        /// <p>The timestamp for when the tracker resource received the device position in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601 </a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn received_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.received_time = Some(input);
            self
        }
        /// <p>The timestamp for when the tracker resource received the device position in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601 </a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn set_received_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.received_time = input;
            self
        }
        /// Appends an item to `position`.
        ///
        /// To override the contents of this collection use [`set_position`](Self::set_position).
        ///
        /// <p>The last known device position.</p>
        pub fn position(mut self, input: f64) -> Self {
            let mut v = self.position.unwrap_or_default();
            v.push(input);
            self.position = Some(v);
            self
        }
        /// <p>The last known device position.</p>
        pub fn set_position(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.position = input;
            self
        }
        /// <p>The accuracy of the device position.</p>
        pub fn accuracy(mut self, input: crate::model::PositionalAccuracy) -> Self {
            self.accuracy = Some(input);
            self
        }
        /// <p>The accuracy of the device position.</p>
        pub fn set_accuracy(
            mut self,
            input: std::option::Option<crate::model::PositionalAccuracy>,
        ) -> Self {
            self.accuracy = input;
            self
        }
        /// Adds a key-value pair to `position_properties`.
        ///
        /// To override the contents of this collection use [`set_position_properties`](Self::set_position_properties).
        ///
        /// <p>The properties associated with the position.</p>
        pub fn position_properties(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.position_properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.position_properties = Some(hash_map);
            self
        }
        /// <p>The properties associated with the position.</p>
        pub fn set_position_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.position_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDevicePositionOutput`](crate::output::GetDevicePositionOutput)
        pub fn build(self) -> crate::output::GetDevicePositionOutput {
            crate::output::GetDevicePositionOutput {
                device_id: self.device_id,
                sample_time: self.sample_time,
                received_time: self.received_time,
                position: self.position,
                accuracy: self.accuracy,
                position_properties: self.position_properties,
            }
        }
    }
}
impl GetDevicePositionOutput {
    /// Creates a new builder-style object to manufacture [`GetDevicePositionOutput`](crate::output::GetDevicePositionOutput)
    pub fn builder() -> crate::output::get_device_position_output::Builder {
        crate::output::get_device_position_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateTrackerConsumerOutput {}
impl std::fmt::Debug for DisassociateTrackerConsumerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateTrackerConsumerOutput");
        formatter.finish()
    }
}
/// See [`DisassociateTrackerConsumerOutput`](crate::output::DisassociateTrackerConsumerOutput)
pub mod disassociate_tracker_consumer_output {
    /// A builder for [`DisassociateTrackerConsumerOutput`](crate::output::DisassociateTrackerConsumerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateTrackerConsumerOutput`](crate::output::DisassociateTrackerConsumerOutput)
        pub fn build(self) -> crate::output::DisassociateTrackerConsumerOutput {
            crate::output::DisassociateTrackerConsumerOutput {}
        }
    }
}
impl DisassociateTrackerConsumerOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateTrackerConsumerOutput`](crate::output::DisassociateTrackerConsumerOutput)
    pub fn builder() -> crate::output::disassociate_tracker_consumer_output::Builder {
        crate::output::disassociate_tracker_consumer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchUpdateDevicePositionOutput {
    /// <p>Contains error details for each device that failed to update its position.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::BatchUpdateDevicePositionError>>,
}
impl BatchUpdateDevicePositionOutput {
    /// <p>Contains error details for each device that failed to update its position.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::BatchUpdateDevicePositionError]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchUpdateDevicePositionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchUpdateDevicePositionOutput");
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchUpdateDevicePositionOutput`](crate::output::BatchUpdateDevicePositionOutput)
pub mod batch_update_device_position_output {
    /// A builder for [`BatchUpdateDevicePositionOutput`](crate::output::BatchUpdateDevicePositionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) errors:
            std::option::Option<std::vec::Vec<crate::model::BatchUpdateDevicePositionError>>,
    }
    impl Builder {
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>Contains error details for each device that failed to update its position.</p>
        pub fn errors(mut self, input: crate::model::BatchUpdateDevicePositionError) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input);
            self.errors = Some(v);
            self
        }
        /// <p>Contains error details for each device that failed to update its position.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchUpdateDevicePositionError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchUpdateDevicePositionOutput`](crate::output::BatchUpdateDevicePositionOutput)
        pub fn build(self) -> crate::output::BatchUpdateDevicePositionOutput {
            crate::output::BatchUpdateDevicePositionOutput {
                errors: self.errors,
            }
        }
    }
}
impl BatchUpdateDevicePositionOutput {
    /// Creates a new builder-style object to manufacture [`BatchUpdateDevicePositionOutput`](crate::output::BatchUpdateDevicePositionOutput)
    pub fn builder() -> crate::output::batch_update_device_position_output::Builder {
        crate::output::batch_update_device_position_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetDevicePositionOutput {
    /// <p>Contains error details for each device that failed to send its position to the tracker resource.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::BatchGetDevicePositionError>>,
    /// <p>Contains device position details such as the device ID, position, and timestamps for when the position was received and sampled.</p>
    pub device_positions: std::option::Option<std::vec::Vec<crate::model::DevicePosition>>,
}
impl BatchGetDevicePositionOutput {
    /// <p>Contains error details for each device that failed to send its position to the tracker resource.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::BatchGetDevicePositionError]> {
        self.errors.as_deref()
    }
    /// <p>Contains device position details such as the device ID, position, and timestamps for when the position was received and sampled.</p>
    pub fn device_positions(&self) -> std::option::Option<&[crate::model::DevicePosition]> {
        self.device_positions.as_deref()
    }
}
impl std::fmt::Debug for BatchGetDevicePositionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetDevicePositionOutput");
        formatter.field("errors", &self.errors);
        formatter.field("device_positions", &self.device_positions);
        formatter.finish()
    }
}
/// See [`BatchGetDevicePositionOutput`](crate::output::BatchGetDevicePositionOutput)
pub mod batch_get_device_position_output {
    /// A builder for [`BatchGetDevicePositionOutput`](crate::output::BatchGetDevicePositionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) errors:
            std::option::Option<std::vec::Vec<crate::model::BatchGetDevicePositionError>>,
        pub(crate) device_positions:
            std::option::Option<std::vec::Vec<crate::model::DevicePosition>>,
    }
    impl Builder {
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>Contains error details for each device that failed to send its position to the tracker resource.</p>
        pub fn errors(mut self, input: crate::model::BatchGetDevicePositionError) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input);
            self.errors = Some(v);
            self
        }
        /// <p>Contains error details for each device that failed to send its position to the tracker resource.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchGetDevicePositionError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Appends an item to `device_positions`.
        ///
        /// To override the contents of this collection use [`set_device_positions`](Self::set_device_positions).
        ///
        /// <p>Contains device position details such as the device ID, position, and timestamps for when the position was received and sampled.</p>
        pub fn device_positions(mut self, input: crate::model::DevicePosition) -> Self {
            let mut v = self.device_positions.unwrap_or_default();
            v.push(input);
            self.device_positions = Some(v);
            self
        }
        /// <p>Contains device position details such as the device ID, position, and timestamps for when the position was received and sampled.</p>
        pub fn set_device_positions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DevicePosition>>,
        ) -> Self {
            self.device_positions = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetDevicePositionOutput`](crate::output::BatchGetDevicePositionOutput)
        pub fn build(self) -> crate::output::BatchGetDevicePositionOutput {
            crate::output::BatchGetDevicePositionOutput {
                errors: self.errors,
                device_positions: self.device_positions,
            }
        }
    }
}
impl BatchGetDevicePositionOutput {
    /// Creates a new builder-style object to manufacture [`BatchGetDevicePositionOutput`](crate::output::BatchGetDevicePositionOutput)
    pub fn builder() -> crate::output::batch_get_device_position_output::Builder {
        crate::output::batch_get_device_position_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteDevicePositionHistoryOutput {
    /// <p>Contains error details for each device history that failed to delete.</p>
    pub errors:
        std::option::Option<std::vec::Vec<crate::model::BatchDeleteDevicePositionHistoryError>>,
}
impl BatchDeleteDevicePositionHistoryOutput {
    /// <p>Contains error details for each device history that failed to delete.</p>
    pub fn errors(
        &self,
    ) -> std::option::Option<&[crate::model::BatchDeleteDevicePositionHistoryError]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchDeleteDevicePositionHistoryOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteDevicePositionHistoryOutput");
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchDeleteDevicePositionHistoryOutput`](crate::output::BatchDeleteDevicePositionHistoryOutput)
pub mod batch_delete_device_position_history_output {
    /// A builder for [`BatchDeleteDevicePositionHistoryOutput`](crate::output::BatchDeleteDevicePositionHistoryOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) errors:
            std::option::Option<std::vec::Vec<crate::model::BatchDeleteDevicePositionHistoryError>>,
    }
    impl Builder {
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>Contains error details for each device history that failed to delete.</p>
        pub fn errors(
            mut self,
            input: crate::model::BatchDeleteDevicePositionHistoryError,
        ) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input);
            self.errors = Some(v);
            self
        }
        /// <p>Contains error details for each device history that failed to delete.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::BatchDeleteDevicePositionHistoryError>,
            >,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteDevicePositionHistoryOutput`](crate::output::BatchDeleteDevicePositionHistoryOutput)
        pub fn build(self) -> crate::output::BatchDeleteDevicePositionHistoryOutput {
            crate::output::BatchDeleteDevicePositionHistoryOutput {
                errors: self.errors,
            }
        }
    }
}
impl BatchDeleteDevicePositionHistoryOutput {
    /// Creates a new builder-style object to manufacture [`BatchDeleteDevicePositionHistoryOutput`](crate::output::BatchDeleteDevicePositionHistoryOutput)
    pub fn builder() -> crate::output::batch_delete_device_position_history_output::Builder {
        crate::output::batch_delete_device_position_history_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateTrackerConsumerOutput {}
impl std::fmt::Debug for AssociateTrackerConsumerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateTrackerConsumerOutput");
        formatter.finish()
    }
}
/// See [`AssociateTrackerConsumerOutput`](crate::output::AssociateTrackerConsumerOutput)
pub mod associate_tracker_consumer_output {
    /// A builder for [`AssociateTrackerConsumerOutput`](crate::output::AssociateTrackerConsumerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AssociateTrackerConsumerOutput`](crate::output::AssociateTrackerConsumerOutput)
        pub fn build(self) -> crate::output::AssociateTrackerConsumerOutput {
            crate::output::AssociateTrackerConsumerOutput {}
        }
    }
}
impl AssociateTrackerConsumerOutput {
    /// Creates a new builder-style object to manufacture [`AssociateTrackerConsumerOutput`](crate::output::AssociateTrackerConsumerOutput)
    pub fn builder() -> crate::output::associate_tracker_consumer_output::Builder {
        crate::output::associate_tracker_consumer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTrackersOutput {
    /// <p>Contains tracker resources in your AWS account. Details include tracker name, description and timestamps for when the tracker was created and last updated.</p>
    pub entries: std::option::Option<std::vec::Vec<crate::model::ListTrackersResponseEntry>>,
    /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListTrackersOutput {
    /// <p>Contains tracker resources in your AWS account. Details include tracker name, description and timestamps for when the tracker was created and last updated.</p>
    pub fn entries(&self) -> std::option::Option<&[crate::model::ListTrackersResponseEntry]> {
        self.entries.as_deref()
    }
    /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListTrackersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTrackersOutput");
        formatter.field("entries", &self.entries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListTrackersOutput`](crate::output::ListTrackersOutput)
pub mod list_trackers_output {
    /// A builder for [`ListTrackersOutput`](crate::output::ListTrackersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entries:
            std::option::Option<std::vec::Vec<crate::model::ListTrackersResponseEntry>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>Contains tracker resources in your AWS account. Details include tracker name, description and timestamps for when the tracker was created and last updated.</p>
        pub fn entries(mut self, input: crate::model::ListTrackersResponseEntry) -> Self {
            let mut v = self.entries.unwrap_or_default();
            v.push(input);
            self.entries = Some(v);
            self
        }
        /// <p>Contains tracker resources in your AWS account. Details include tracker name, description and timestamps for when the tracker was created and last updated.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListTrackersResponseEntry>>,
        ) -> Self {
            self.entries = input;
            self
        }
        /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTrackersOutput`](crate::output::ListTrackersOutput)
        pub fn build(self) -> crate::output::ListTrackersOutput {
            crate::output::ListTrackersOutput {
                entries: self.entries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListTrackersOutput {
    /// Creates a new builder-style object to manufacture [`ListTrackersOutput`](crate::output::ListTrackersOutput)
    pub fn builder() -> crate::output::list_trackers_output::Builder {
        crate::output::list_trackers_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTrackerOutput {
    /// <p>The name of the tracker resource.</p>
    pub tracker_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the tracker resource. Used when you need to specify a resource across all AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:tracker/ExampleTracker</code> </p> </li>
    /// </ul>
    pub tracker_arn: std::option::Option<std::string::String>,
    /// <p>The timestamp for when the tracker resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateTrackerOutput {
    /// <p>The name of the tracker resource.</p>
    pub fn tracker_name(&self) -> std::option::Option<&str> {
        self.tracker_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the tracker resource. Used when you need to specify a resource across all AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:tracker/ExampleTracker</code> </p> </li>
    /// </ul>
    pub fn tracker_arn(&self) -> std::option::Option<&str> {
        self.tracker_arn.as_deref()
    }
    /// <p>The timestamp for when the tracker resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
}
impl std::fmt::Debug for CreateTrackerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTrackerOutput");
        formatter.field("tracker_name", &self.tracker_name);
        formatter.field("tracker_arn", &self.tracker_arn);
        formatter.field("create_time", &self.create_time);
        formatter.finish()
    }
}
/// See [`CreateTrackerOutput`](crate::output::CreateTrackerOutput)
pub mod create_tracker_output {
    /// A builder for [`CreateTrackerOutput`](crate::output::CreateTrackerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tracker_name: std::option::Option<std::string::String>,
        pub(crate) tracker_arn: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the tracker resource.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracker_name = Some(input.into());
            self
        }
        /// <p>The name of the tracker resource.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tracker_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the tracker resource. Used when you need to specify a resource across all AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:tracker/ExampleTracker</code> </p> </li>
        /// </ul>
        pub fn tracker_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracker_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the tracker resource. Used when you need to specify a resource across all AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:tracker/ExampleTracker</code> </p> </li>
        /// </ul>
        pub fn set_tracker_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tracker_arn = input;
            self
        }
        /// <p>The timestamp for when the tracker resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp for when the tracker resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTrackerOutput`](crate::output::CreateTrackerOutput)
        pub fn build(self) -> crate::output::CreateTrackerOutput {
            crate::output::CreateTrackerOutput {
                tracker_name: self.tracker_name,
                tracker_arn: self.tracker_arn,
                create_time: self.create_time,
            }
        }
    }
}
impl CreateTrackerOutput {
    /// Creates a new builder-style object to manufacture [`CreateTrackerOutput`](crate::output::CreateTrackerOutput)
    pub fn builder() -> crate::output::create_tracker_output::Builder {
        crate::output::create_tracker_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTrackerOutput {}
impl std::fmt::Debug for DeleteTrackerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTrackerOutput");
        formatter.finish()
    }
}
/// See [`DeleteTrackerOutput`](crate::output::DeleteTrackerOutput)
pub mod delete_tracker_output {
    /// A builder for [`DeleteTrackerOutput`](crate::output::DeleteTrackerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTrackerOutput`](crate::output::DeleteTrackerOutput)
        pub fn build(self) -> crate::output::DeleteTrackerOutput {
            crate::output::DeleteTrackerOutput {}
        }
    }
}
impl DeleteTrackerOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTrackerOutput`](crate::output::DeleteTrackerOutput)
    pub fn builder() -> crate::output::delete_tracker_output::Builder {
        crate::output::delete_tracker_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTrackerOutput {
    /// <p>The name of the updated tracker resource.</p>
    pub tracker_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the updated tracker resource. Used to specify a resource across AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:tracker/ExampleTracker</code> </p> </li>
    /// </ul>
    pub tracker_arn: std::option::Option<std::string::String>,
    /// <p>The timestamp for when the tracker resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdateTrackerOutput {
    /// <p>The name of the updated tracker resource.</p>
    pub fn tracker_name(&self) -> std::option::Option<&str> {
        self.tracker_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the updated tracker resource. Used to specify a resource across AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:tracker/ExampleTracker</code> </p> </li>
    /// </ul>
    pub fn tracker_arn(&self) -> std::option::Option<&str> {
        self.tracker_arn.as_deref()
    }
    /// <p>The timestamp for when the tracker resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
}
impl std::fmt::Debug for UpdateTrackerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTrackerOutput");
        formatter.field("tracker_name", &self.tracker_name);
        formatter.field("tracker_arn", &self.tracker_arn);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`UpdateTrackerOutput`](crate::output::UpdateTrackerOutput)
pub mod update_tracker_output {
    /// A builder for [`UpdateTrackerOutput`](crate::output::UpdateTrackerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tracker_name: std::option::Option<std::string::String>,
        pub(crate) tracker_arn: std::option::Option<std::string::String>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the updated tracker resource.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracker_name = Some(input.into());
            self
        }
        /// <p>The name of the updated tracker resource.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tracker_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the updated tracker resource. Used to specify a resource across AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:tracker/ExampleTracker</code> </p> </li>
        /// </ul>
        pub fn tracker_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracker_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the updated tracker resource. Used to specify a resource across AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:tracker/ExampleTracker</code> </p> </li>
        /// </ul>
        pub fn set_tracker_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tracker_arn = input;
            self
        }
        /// <p>The timestamp for when the tracker resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>The timestamp for when the tracker resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTrackerOutput`](crate::output::UpdateTrackerOutput)
        pub fn build(self) -> crate::output::UpdateTrackerOutput {
            crate::output::UpdateTrackerOutput {
                tracker_name: self.tracker_name,
                tracker_arn: self.tracker_arn,
                update_time: self.update_time,
            }
        }
    }
}
impl UpdateTrackerOutput {
    /// Creates a new builder-style object to manufacture [`UpdateTrackerOutput`](crate::output::UpdateTrackerOutput)
    pub fn builder() -> crate::output::update_tracker_output::Builder {
        crate::output::update_tracker_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTrackerOutput {
    /// <p>The name of the tracker resource.</p>
    pub tracker_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the tracker resource. Used when you need to specify a resource across all AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:tracker/ExampleTracker</code> </p> </li>
    /// </ul>
    pub tracker_arn: std::option::Option<std::string::String>,
    /// <p>The optional description for the tracker resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Always returns <code>RequestBasedUsage</code>.</p>
    pub pricing_plan: std::option::Option<crate::model::PricingPlan>,
    /// <p>No longer used. Always returns an empty string.</p>
    pub pricing_plan_data_source: std::option::Option<std::string::String>,
    /// <p>The tags associated with the tracker resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The timestamp for when the tracker resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp for when the tracker resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a> assigned to the Amazon Location resource.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The position filtering method of the tracker resource.</p>
    pub position_filtering: std::option::Option<crate::model::PositionFiltering>,
}
impl DescribeTrackerOutput {
    /// <p>The name of the tracker resource.</p>
    pub fn tracker_name(&self) -> std::option::Option<&str> {
        self.tracker_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the tracker resource. Used when you need to specify a resource across all AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:tracker/ExampleTracker</code> </p> </li>
    /// </ul>
    pub fn tracker_arn(&self) -> std::option::Option<&str> {
        self.tracker_arn.as_deref()
    }
    /// <p>The optional description for the tracker resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Always returns <code>RequestBasedUsage</code>.</p>
    pub fn pricing_plan(&self) -> std::option::Option<&crate::model::PricingPlan> {
        self.pricing_plan.as_ref()
    }
    /// <p>No longer used. Always returns an empty string.</p>
    pub fn pricing_plan_data_source(&self) -> std::option::Option<&str> {
        self.pricing_plan_data_source.as_deref()
    }
    /// <p>The tags associated with the tracker resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The timestamp for when the tracker resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
    /// <p>The timestamp for when the tracker resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
    /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a> assigned to the Amazon Location resource.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The position filtering method of the tracker resource.</p>
    pub fn position_filtering(&self) -> std::option::Option<&crate::model::PositionFiltering> {
        self.position_filtering.as_ref()
    }
}
impl std::fmt::Debug for DescribeTrackerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTrackerOutput");
        formatter.field("tracker_name", &self.tracker_name);
        formatter.field("tracker_arn", &self.tracker_arn);
        formatter.field("description", &self.description);
        formatter.field("pricing_plan", &self.pricing_plan);
        formatter.field("pricing_plan_data_source", &self.pricing_plan_data_source);
        formatter.field("tags", &self.tags);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("position_filtering", &self.position_filtering);
        formatter.finish()
    }
}
/// See [`DescribeTrackerOutput`](crate::output::DescribeTrackerOutput)
pub mod describe_tracker_output {
    /// A builder for [`DescribeTrackerOutput`](crate::output::DescribeTrackerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tracker_name: std::option::Option<std::string::String>,
        pub(crate) tracker_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) pricing_plan: std::option::Option<crate::model::PricingPlan>,
        pub(crate) pricing_plan_data_source: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) position_filtering: std::option::Option<crate::model::PositionFiltering>,
    }
    impl Builder {
        /// <p>The name of the tracker resource.</p>
        pub fn tracker_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracker_name = Some(input.into());
            self
        }
        /// <p>The name of the tracker resource.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tracker_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the tracker resource. Used when you need to specify a resource across all AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:tracker/ExampleTracker</code> </p> </li>
        /// </ul>
        pub fn tracker_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracker_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the tracker resource. Used when you need to specify a resource across all AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:tracker/ExampleTracker</code> </p> </li>
        /// </ul>
        pub fn set_tracker_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tracker_arn = input;
            self
        }
        /// <p>The optional description for the tracker resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The optional description for the tracker resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Always returns <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.pricing_plan = Some(input);
            self
        }
        /// <p>Always returns <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.pricing_plan = input;
            self
        }
        /// <p>No longer used. Always returns an empty string.</p>
        pub fn pricing_plan_data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.pricing_plan_data_source = Some(input.into());
            self
        }
        /// <p>No longer used. Always returns an empty string.</p>
        pub fn set_pricing_plan_data_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pricing_plan_data_source = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the tracker resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags associated with the tracker resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The timestamp for when the tracker resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp for when the tracker resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The timestamp for when the tracker resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>The timestamp for when the tracker resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a> assigned to the Amazon Location resource.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a> assigned to the Amazon Location resource.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The position filtering method of the tracker resource.</p>
        pub fn position_filtering(mut self, input: crate::model::PositionFiltering) -> Self {
            self.position_filtering = Some(input);
            self
        }
        /// <p>The position filtering method of the tracker resource.</p>
        pub fn set_position_filtering(
            mut self,
            input: std::option::Option<crate::model::PositionFiltering>,
        ) -> Self {
            self.position_filtering = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTrackerOutput`](crate::output::DescribeTrackerOutput)
        pub fn build(self) -> crate::output::DescribeTrackerOutput {
            crate::output::DescribeTrackerOutput {
                tracker_name: self.tracker_name,
                tracker_arn: self.tracker_arn,
                description: self.description,
                pricing_plan: self.pricing_plan,
                pricing_plan_data_source: self.pricing_plan_data_source,
                tags: self.tags,
                create_time: self.create_time,
                update_time: self.update_time,
                kms_key_id: self.kms_key_id,
                position_filtering: self.position_filtering,
            }
        }
    }
}
impl DescribeTrackerOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTrackerOutput`](crate::output::DescribeTrackerOutput)
    pub fn builder() -> crate::output::describe_tracker_output::Builder {
        crate::output::describe_tracker_output::Builder::default()
    }
}

/// <p>Returns the result of the route matrix calculation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CalculateRouteMatrixOutput {
    /// <p>The calculated route matrix containing the results for all pairs of <code>DeparturePositions</code> to <code>DestinationPositions</code>. Each row corresponds to one entry in <code>DeparturePositions</code>. Each entry in the row corresponds to the route from that entry in <code>DeparturePositions</code> to an entry in <code>DestinationPositions</code>. </p>
    pub route_matrix:
        std::option::Option<std::vec::Vec<std::vec::Vec<crate::model::RouteMatrixEntry>>>,
    /// <p>For routes calculated using an Esri route calculator resource, departure positions are snapped to the closest road. For Esri route calculator resources, this returns the list of departure/origin positions used for calculation of the <code>RouteMatrix</code>.</p>
    pub snapped_departure_positions: std::option::Option<std::vec::Vec<std::vec::Vec<f64>>>,
    /// <p>The list of destination positions for the route matrix used for calculation of the <code>RouteMatrix</code>.</p>
    pub snapped_destination_positions: std::option::Option<std::vec::Vec<std::vec::Vec<f64>>>,
    /// <p>Contains information about the route matrix, <code>DataSource</code>, <code>DistanceUnit</code>, <code>RouteCount</code> and <code>ErrorCount</code>.</p>
    pub summary: std::option::Option<crate::model::CalculateRouteMatrixSummary>,
}
impl CalculateRouteMatrixOutput {
    /// <p>The calculated route matrix containing the results for all pairs of <code>DeparturePositions</code> to <code>DestinationPositions</code>. Each row corresponds to one entry in <code>DeparturePositions</code>. Each entry in the row corresponds to the route from that entry in <code>DeparturePositions</code> to an entry in <code>DestinationPositions</code>. </p>
    pub fn route_matrix(
        &self,
    ) -> std::option::Option<&[std::vec::Vec<crate::model::RouteMatrixEntry>]> {
        self.route_matrix.as_deref()
    }
    /// <p>For routes calculated using an Esri route calculator resource, departure positions are snapped to the closest road. For Esri route calculator resources, this returns the list of departure/origin positions used for calculation of the <code>RouteMatrix</code>.</p>
    pub fn snapped_departure_positions(&self) -> std::option::Option<&[std::vec::Vec<f64>]> {
        self.snapped_departure_positions.as_deref()
    }
    /// <p>The list of destination positions for the route matrix used for calculation of the <code>RouteMatrix</code>.</p>
    pub fn snapped_destination_positions(&self) -> std::option::Option<&[std::vec::Vec<f64>]> {
        self.snapped_destination_positions.as_deref()
    }
    /// <p>Contains information about the route matrix, <code>DataSource</code>, <code>DistanceUnit</code>, <code>RouteCount</code> and <code>ErrorCount</code>.</p>
    pub fn summary(&self) -> std::option::Option<&crate::model::CalculateRouteMatrixSummary> {
        self.summary.as_ref()
    }
}
impl std::fmt::Debug for CalculateRouteMatrixOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CalculateRouteMatrixOutput");
        formatter.field("route_matrix", &self.route_matrix);
        formatter.field(
            "snapped_departure_positions",
            &self.snapped_departure_positions,
        );
        formatter.field(
            "snapped_destination_positions",
            &self.snapped_destination_positions,
        );
        formatter.field("summary", &self.summary);
        formatter.finish()
    }
}
/// See [`CalculateRouteMatrixOutput`](crate::output::CalculateRouteMatrixOutput)
pub mod calculate_route_matrix_output {
    /// A builder for [`CalculateRouteMatrixOutput`](crate::output::CalculateRouteMatrixOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) route_matrix:
            std::option::Option<std::vec::Vec<std::vec::Vec<crate::model::RouteMatrixEntry>>>,
        pub(crate) snapped_departure_positions:
            std::option::Option<std::vec::Vec<std::vec::Vec<f64>>>,
        pub(crate) snapped_destination_positions:
            std::option::Option<std::vec::Vec<std::vec::Vec<f64>>>,
        pub(crate) summary: std::option::Option<crate::model::CalculateRouteMatrixSummary>,
    }
    impl Builder {
        /// Appends an item to `route_matrix`.
        ///
        /// To override the contents of this collection use [`set_route_matrix`](Self::set_route_matrix).
        ///
        /// <p>The calculated route matrix containing the results for all pairs of <code>DeparturePositions</code> to <code>DestinationPositions</code>. Each row corresponds to one entry in <code>DeparturePositions</code>. Each entry in the row corresponds to the route from that entry in <code>DeparturePositions</code> to an entry in <code>DestinationPositions</code>. </p>
        pub fn route_matrix(
            mut self,
            input: std::vec::Vec<crate::model::RouteMatrixEntry>,
        ) -> Self {
            let mut v = self.route_matrix.unwrap_or_default();
            v.push(input);
            self.route_matrix = Some(v);
            self
        }
        /// <p>The calculated route matrix containing the results for all pairs of <code>DeparturePositions</code> to <code>DestinationPositions</code>. Each row corresponds to one entry in <code>DeparturePositions</code>. Each entry in the row corresponds to the route from that entry in <code>DeparturePositions</code> to an entry in <code>DestinationPositions</code>. </p>
        pub fn set_route_matrix(
            mut self,
            input: std::option::Option<
                std::vec::Vec<std::vec::Vec<crate::model::RouteMatrixEntry>>,
            >,
        ) -> Self {
            self.route_matrix = input;
            self
        }
        /// Appends an item to `snapped_departure_positions`.
        ///
        /// To override the contents of this collection use [`set_snapped_departure_positions`](Self::set_snapped_departure_positions).
        ///
        /// <p>For routes calculated using an Esri route calculator resource, departure positions are snapped to the closest road. For Esri route calculator resources, this returns the list of departure/origin positions used for calculation of the <code>RouteMatrix</code>.</p>
        pub fn snapped_departure_positions(mut self, input: std::vec::Vec<f64>) -> Self {
            let mut v = self.snapped_departure_positions.unwrap_or_default();
            v.push(input);
            self.snapped_departure_positions = Some(v);
            self
        }
        /// <p>For routes calculated using an Esri route calculator resource, departure positions are snapped to the closest road. For Esri route calculator resources, this returns the list of departure/origin positions used for calculation of the <code>RouteMatrix</code>.</p>
        pub fn set_snapped_departure_positions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<f64>>>,
        ) -> Self {
            self.snapped_departure_positions = input;
            self
        }
        /// Appends an item to `snapped_destination_positions`.
        ///
        /// To override the contents of this collection use [`set_snapped_destination_positions`](Self::set_snapped_destination_positions).
        ///
        /// <p>The list of destination positions for the route matrix used for calculation of the <code>RouteMatrix</code>.</p>
        pub fn snapped_destination_positions(mut self, input: std::vec::Vec<f64>) -> Self {
            let mut v = self.snapped_destination_positions.unwrap_or_default();
            v.push(input);
            self.snapped_destination_positions = Some(v);
            self
        }
        /// <p>The list of destination positions for the route matrix used for calculation of the <code>RouteMatrix</code>.</p>
        pub fn set_snapped_destination_positions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<f64>>>,
        ) -> Self {
            self.snapped_destination_positions = input;
            self
        }
        /// <p>Contains information about the route matrix, <code>DataSource</code>, <code>DistanceUnit</code>, <code>RouteCount</code> and <code>ErrorCount</code>.</p>
        pub fn summary(mut self, input: crate::model::CalculateRouteMatrixSummary) -> Self {
            self.summary = Some(input);
            self
        }
        /// <p>Contains information about the route matrix, <code>DataSource</code>, <code>DistanceUnit</code>, <code>RouteCount</code> and <code>ErrorCount</code>.</p>
        pub fn set_summary(
            mut self,
            input: std::option::Option<crate::model::CalculateRouteMatrixSummary>,
        ) -> Self {
            self.summary = input;
            self
        }
        /// Consumes the builder and constructs a [`CalculateRouteMatrixOutput`](crate::output::CalculateRouteMatrixOutput)
        pub fn build(self) -> crate::output::CalculateRouteMatrixOutput {
            crate::output::CalculateRouteMatrixOutput {
                route_matrix: self.route_matrix,
                snapped_departure_positions: self.snapped_departure_positions,
                snapped_destination_positions: self.snapped_destination_positions,
                summary: self.summary,
            }
        }
    }
}
impl CalculateRouteMatrixOutput {
    /// Creates a new builder-style object to manufacture [`CalculateRouteMatrixOutput`](crate::output::CalculateRouteMatrixOutput)
    pub fn builder() -> crate::output::calculate_route_matrix_output::Builder {
        crate::output::calculate_route_matrix_output::Builder::default()
    }
}

/// <p>Returns the result of the route calculation. Metadata includes legs and route summary.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CalculateRouteOutput {
    /// <p>Contains details about each path between a pair of positions included along a route such as: <code>StartPosition</code>, <code>EndPosition</code>, <code>Distance</code>, <code>DurationSeconds</code>, <code>Geometry</code>, and <code>Steps</code>. The number of legs returned corresponds to one fewer than the total number of positions in the request. </p>
    /// <p>For example, a route with a departure position and destination position returns one leg with the positions <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">snapped to a nearby road</a>:</p>
    /// <ul>
    /// <li> <p>The <code>StartPosition</code> is the departure position.</p> </li>
    /// <li> <p>The <code>EndPosition</code> is the destination position.</p> </li>
    /// </ul>
    /// <p>A route with a waypoint between the departure and destination position returns two legs with the positions snapped to a nearby road:</p>
    /// <ul>
    /// <li> <p>Leg 1: The <code>StartPosition</code> is the departure position . The <code>EndPosition</code> is the waypoint positon.</p> </li>
    /// <li> <p>Leg 2: The <code>StartPosition</code> is the waypoint position. The <code>EndPosition</code> is the destination position.</p> </li>
    /// </ul>
    pub legs: std::option::Option<std::vec::Vec<crate::model::Leg>>,
    /// <p>Contains information about the whole route, such as: <code>RouteBBox</code>, <code>DataSource</code>, <code>Distance</code>, <code>DistanceUnit</code>, and <code>DurationSeconds</code>.</p>
    pub summary: std::option::Option<crate::model::CalculateRouteSummary>,
}
impl CalculateRouteOutput {
    /// <p>Contains details about each path between a pair of positions included along a route such as: <code>StartPosition</code>, <code>EndPosition</code>, <code>Distance</code>, <code>DurationSeconds</code>, <code>Geometry</code>, and <code>Steps</code>. The number of legs returned corresponds to one fewer than the total number of positions in the request. </p>
    /// <p>For example, a route with a departure position and destination position returns one leg with the positions <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">snapped to a nearby road</a>:</p>
    /// <ul>
    /// <li> <p>The <code>StartPosition</code> is the departure position.</p> </li>
    /// <li> <p>The <code>EndPosition</code> is the destination position.</p> </li>
    /// </ul>
    /// <p>A route with a waypoint between the departure and destination position returns two legs with the positions snapped to a nearby road:</p>
    /// <ul>
    /// <li> <p>Leg 1: The <code>StartPosition</code> is the departure position . The <code>EndPosition</code> is the waypoint positon.</p> </li>
    /// <li> <p>Leg 2: The <code>StartPosition</code> is the waypoint position. The <code>EndPosition</code> is the destination position.</p> </li>
    /// </ul>
    pub fn legs(&self) -> std::option::Option<&[crate::model::Leg]> {
        self.legs.as_deref()
    }
    /// <p>Contains information about the whole route, such as: <code>RouteBBox</code>, <code>DataSource</code>, <code>Distance</code>, <code>DistanceUnit</code>, and <code>DurationSeconds</code>.</p>
    pub fn summary(&self) -> std::option::Option<&crate::model::CalculateRouteSummary> {
        self.summary.as_ref()
    }
}
impl std::fmt::Debug for CalculateRouteOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CalculateRouteOutput");
        formatter.field("legs", &self.legs);
        formatter.field("summary", &self.summary);
        formatter.finish()
    }
}
/// See [`CalculateRouteOutput`](crate::output::CalculateRouteOutput)
pub mod calculate_route_output {
    /// A builder for [`CalculateRouteOutput`](crate::output::CalculateRouteOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) legs: std::option::Option<std::vec::Vec<crate::model::Leg>>,
        pub(crate) summary: std::option::Option<crate::model::CalculateRouteSummary>,
    }
    impl Builder {
        /// Appends an item to `legs`.
        ///
        /// To override the contents of this collection use [`set_legs`](Self::set_legs).
        ///
        /// <p>Contains details about each path between a pair of positions included along a route such as: <code>StartPosition</code>, <code>EndPosition</code>, <code>Distance</code>, <code>DurationSeconds</code>, <code>Geometry</code>, and <code>Steps</code>. The number of legs returned corresponds to one fewer than the total number of positions in the request. </p>
        /// <p>For example, a route with a departure position and destination position returns one leg with the positions <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">snapped to a nearby road</a>:</p>
        /// <ul>
        /// <li> <p>The <code>StartPosition</code> is the departure position.</p> </li>
        /// <li> <p>The <code>EndPosition</code> is the destination position.</p> </li>
        /// </ul>
        /// <p>A route with a waypoint between the departure and destination position returns two legs with the positions snapped to a nearby road:</p>
        /// <ul>
        /// <li> <p>Leg 1: The <code>StartPosition</code> is the departure position . The <code>EndPosition</code> is the waypoint positon.</p> </li>
        /// <li> <p>Leg 2: The <code>StartPosition</code> is the waypoint position. The <code>EndPosition</code> is the destination position.</p> </li>
        /// </ul>
        pub fn legs(mut self, input: crate::model::Leg) -> Self {
            let mut v = self.legs.unwrap_or_default();
            v.push(input);
            self.legs = Some(v);
            self
        }
        /// <p>Contains details about each path between a pair of positions included along a route such as: <code>StartPosition</code>, <code>EndPosition</code>, <code>Distance</code>, <code>DurationSeconds</code>, <code>Geometry</code>, and <code>Steps</code>. The number of legs returned corresponds to one fewer than the total number of positions in the request. </p>
        /// <p>For example, a route with a departure position and destination position returns one leg with the positions <a href="https://docs.aws.amazon.com/location/latest/developerguide/snap-to-nearby-road.html">snapped to a nearby road</a>:</p>
        /// <ul>
        /// <li> <p>The <code>StartPosition</code> is the departure position.</p> </li>
        /// <li> <p>The <code>EndPosition</code> is the destination position.</p> </li>
        /// </ul>
        /// <p>A route with a waypoint between the departure and destination position returns two legs with the positions snapped to a nearby road:</p>
        /// <ul>
        /// <li> <p>Leg 1: The <code>StartPosition</code> is the departure position . The <code>EndPosition</code> is the waypoint positon.</p> </li>
        /// <li> <p>Leg 2: The <code>StartPosition</code> is the waypoint position. The <code>EndPosition</code> is the destination position.</p> </li>
        /// </ul>
        pub fn set_legs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Leg>>,
        ) -> Self {
            self.legs = input;
            self
        }
        /// <p>Contains information about the whole route, such as: <code>RouteBBox</code>, <code>DataSource</code>, <code>Distance</code>, <code>DistanceUnit</code>, and <code>DurationSeconds</code>.</p>
        pub fn summary(mut self, input: crate::model::CalculateRouteSummary) -> Self {
            self.summary = Some(input);
            self
        }
        /// <p>Contains information about the whole route, such as: <code>RouteBBox</code>, <code>DataSource</code>, <code>Distance</code>, <code>DistanceUnit</code>, and <code>DurationSeconds</code>.</p>
        pub fn set_summary(
            mut self,
            input: std::option::Option<crate::model::CalculateRouteSummary>,
        ) -> Self {
            self.summary = input;
            self
        }
        /// Consumes the builder and constructs a [`CalculateRouteOutput`](crate::output::CalculateRouteOutput)
        pub fn build(self) -> crate::output::CalculateRouteOutput {
            crate::output::CalculateRouteOutput {
                legs: self.legs,
                summary: self.summary,
            }
        }
    }
}
impl CalculateRouteOutput {
    /// Creates a new builder-style object to manufacture [`CalculateRouteOutput`](crate::output::CalculateRouteOutput)
    pub fn builder() -> crate::output::calculate_route_output::Builder {
        crate::output::calculate_route_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListRouteCalculatorsOutput {
    /// <p>Lists the route calculator resources that exist in your AWS account</p>
    pub entries:
        std::option::Option<std::vec::Vec<crate::model::ListRouteCalculatorsResponseEntry>>,
    /// <p>A pagination token indicating there are additional pages available. You can use the token in a subsequent request to fetch the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListRouteCalculatorsOutput {
    /// <p>Lists the route calculator resources that exist in your AWS account</p>
    pub fn entries(
        &self,
    ) -> std::option::Option<&[crate::model::ListRouteCalculatorsResponseEntry]> {
        self.entries.as_deref()
    }
    /// <p>A pagination token indicating there are additional pages available. You can use the token in a subsequent request to fetch the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListRouteCalculatorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListRouteCalculatorsOutput");
        formatter.field("entries", &self.entries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListRouteCalculatorsOutput`](crate::output::ListRouteCalculatorsOutput)
pub mod list_route_calculators_output {
    /// A builder for [`ListRouteCalculatorsOutput`](crate::output::ListRouteCalculatorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entries:
            std::option::Option<std::vec::Vec<crate::model::ListRouteCalculatorsResponseEntry>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>Lists the route calculator resources that exist in your AWS account</p>
        pub fn entries(mut self, input: crate::model::ListRouteCalculatorsResponseEntry) -> Self {
            let mut v = self.entries.unwrap_or_default();
            v.push(input);
            self.entries = Some(v);
            self
        }
        /// <p>Lists the route calculator resources that exist in your AWS account</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ListRouteCalculatorsResponseEntry>,
            >,
        ) -> Self {
            self.entries = input;
            self
        }
        /// <p>A pagination token indicating there are additional pages available. You can use the token in a subsequent request to fetch the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token indicating there are additional pages available. You can use the token in a subsequent request to fetch the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRouteCalculatorsOutput`](crate::output::ListRouteCalculatorsOutput)
        pub fn build(self) -> crate::output::ListRouteCalculatorsOutput {
            crate::output::ListRouteCalculatorsOutput {
                entries: self.entries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListRouteCalculatorsOutput {
    /// Creates a new builder-style object to manufacture [`ListRouteCalculatorsOutput`](crate::output::ListRouteCalculatorsOutput)
    pub fn builder() -> crate::output::list_route_calculators_output::Builder {
        crate::output::list_route_calculators_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRouteCalculatorOutput {
    /// <p>The name of the route calculator resource. </p>
    /// <ul>
    /// <li> <p>For example, <code>ExampleRouteCalculator</code>.</p> </li>
    /// </ul>
    pub calculator_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the route calculator resource. Use the ARN when you specify a resource across all AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:route-calculator/ExampleCalculator</code> </p> </li>
    /// </ul>
    pub calculator_arn: std::option::Option<std::string::String>,
    /// <p>The timestamp when the route calculator resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    /// <ul>
    /// <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
    /// </ul>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateRouteCalculatorOutput {
    /// <p>The name of the route calculator resource. </p>
    /// <ul>
    /// <li> <p>For example, <code>ExampleRouteCalculator</code>.</p> </li>
    /// </ul>
    pub fn calculator_name(&self) -> std::option::Option<&str> {
        self.calculator_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the route calculator resource. Use the ARN when you specify a resource across all AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:route-calculator/ExampleCalculator</code> </p> </li>
    /// </ul>
    pub fn calculator_arn(&self) -> std::option::Option<&str> {
        self.calculator_arn.as_deref()
    }
    /// <p>The timestamp when the route calculator resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    /// <ul>
    /// <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
    /// </ul>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
}
impl std::fmt::Debug for CreateRouteCalculatorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRouteCalculatorOutput");
        formatter.field("calculator_name", &self.calculator_name);
        formatter.field("calculator_arn", &self.calculator_arn);
        formatter.field("create_time", &self.create_time);
        formatter.finish()
    }
}
/// See [`CreateRouteCalculatorOutput`](crate::output::CreateRouteCalculatorOutput)
pub mod create_route_calculator_output {
    /// A builder for [`CreateRouteCalculatorOutput`](crate::output::CreateRouteCalculatorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) calculator_name: std::option::Option<std::string::String>,
        pub(crate) calculator_arn: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the route calculator resource. </p>
        /// <ul>
        /// <li> <p>For example, <code>ExampleRouteCalculator</code>.</p> </li>
        /// </ul>
        pub fn calculator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.calculator_name = Some(input.into());
            self
        }
        /// <p>The name of the route calculator resource. </p>
        /// <ul>
        /// <li> <p>For example, <code>ExampleRouteCalculator</code>.</p> </li>
        /// </ul>
        pub fn set_calculator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.calculator_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the route calculator resource. Use the ARN when you specify a resource across all AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:route-calculator/ExampleCalculator</code> </p> </li>
        /// </ul>
        pub fn calculator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.calculator_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the route calculator resource. Use the ARN when you specify a resource across all AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:route-calculator/ExampleCalculator</code> </p> </li>
        /// </ul>
        pub fn set_calculator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.calculator_arn = input;
            self
        }
        /// <p>The timestamp when the route calculator resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        /// <ul>
        /// <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
        /// </ul>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp when the route calculator resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        /// <ul>
        /// <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
        /// </ul>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRouteCalculatorOutput`](crate::output::CreateRouteCalculatorOutput)
        pub fn build(self) -> crate::output::CreateRouteCalculatorOutput {
            crate::output::CreateRouteCalculatorOutput {
                calculator_name: self.calculator_name,
                calculator_arn: self.calculator_arn,
                create_time: self.create_time,
            }
        }
    }
}
impl CreateRouteCalculatorOutput {
    /// Creates a new builder-style object to manufacture [`CreateRouteCalculatorOutput`](crate::output::CreateRouteCalculatorOutput)
    pub fn builder() -> crate::output::create_route_calculator_output::Builder {
        crate::output::create_route_calculator_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRouteCalculatorOutput {}
impl std::fmt::Debug for DeleteRouteCalculatorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRouteCalculatorOutput");
        formatter.finish()
    }
}
/// See [`DeleteRouteCalculatorOutput`](crate::output::DeleteRouteCalculatorOutput)
pub mod delete_route_calculator_output {
    /// A builder for [`DeleteRouteCalculatorOutput`](crate::output::DeleteRouteCalculatorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteRouteCalculatorOutput`](crate::output::DeleteRouteCalculatorOutput)
        pub fn build(self) -> crate::output::DeleteRouteCalculatorOutput {
            crate::output::DeleteRouteCalculatorOutput {}
        }
    }
}
impl DeleteRouteCalculatorOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRouteCalculatorOutput`](crate::output::DeleteRouteCalculatorOutput)
    pub fn builder() -> crate::output::delete_route_calculator_output::Builder {
        crate::output::delete_route_calculator_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateRouteCalculatorOutput {
    /// <p>The name of the updated route calculator resource.</p>
    pub calculator_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the updated route calculator resource. Used to specify a resource across AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:route- calculator/ExampleCalculator</code> </p> </li>
    /// </ul>
    pub calculator_arn: std::option::Option<std::string::String>,
    /// <p>The timestamp for when the route calculator was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdateRouteCalculatorOutput {
    /// <p>The name of the updated route calculator resource.</p>
    pub fn calculator_name(&self) -> std::option::Option<&str> {
        self.calculator_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the updated route calculator resource. Used to specify a resource across AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:route- calculator/ExampleCalculator</code> </p> </li>
    /// </ul>
    pub fn calculator_arn(&self) -> std::option::Option<&str> {
        self.calculator_arn.as_deref()
    }
    /// <p>The timestamp for when the route calculator was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
}
impl std::fmt::Debug for UpdateRouteCalculatorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateRouteCalculatorOutput");
        formatter.field("calculator_name", &self.calculator_name);
        formatter.field("calculator_arn", &self.calculator_arn);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`UpdateRouteCalculatorOutput`](crate::output::UpdateRouteCalculatorOutput)
pub mod update_route_calculator_output {
    /// A builder for [`UpdateRouteCalculatorOutput`](crate::output::UpdateRouteCalculatorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) calculator_name: std::option::Option<std::string::String>,
        pub(crate) calculator_arn: std::option::Option<std::string::String>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the updated route calculator resource.</p>
        pub fn calculator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.calculator_name = Some(input.into());
            self
        }
        /// <p>The name of the updated route calculator resource.</p>
        pub fn set_calculator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.calculator_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the updated route calculator resource. Used to specify a resource across AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:route- calculator/ExampleCalculator</code> </p> </li>
        /// </ul>
        pub fn calculator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.calculator_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the updated route calculator resource. Used to specify a resource across AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:route- calculator/ExampleCalculator</code> </p> </li>
        /// </ul>
        pub fn set_calculator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.calculator_arn = input;
            self
        }
        /// <p>The timestamp for when the route calculator was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>The timestamp for when the route calculator was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateRouteCalculatorOutput`](crate::output::UpdateRouteCalculatorOutput)
        pub fn build(self) -> crate::output::UpdateRouteCalculatorOutput {
            crate::output::UpdateRouteCalculatorOutput {
                calculator_name: self.calculator_name,
                calculator_arn: self.calculator_arn,
                update_time: self.update_time,
            }
        }
    }
}
impl UpdateRouteCalculatorOutput {
    /// Creates a new builder-style object to manufacture [`UpdateRouteCalculatorOutput`](crate::output::UpdateRouteCalculatorOutput)
    pub fn builder() -> crate::output::update_route_calculator_output::Builder {
        crate::output::update_route_calculator_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRouteCalculatorOutput {
    /// <p>The name of the route calculator resource being described.</p>
    pub calculator_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the Route calculator resource. Use the ARN when you specify a resource across AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:route-calculator/ExampleCalculator</code> </p> </li>
    /// </ul>
    pub calculator_arn: std::option::Option<std::string::String>,
    /// <p>Always returns <code>RequestBasedUsage</code>.</p>
    pub pricing_plan: std::option::Option<crate::model::PricingPlan>,
    /// <p>The optional description of the route calculator resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The timestamp when the route calculator resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    /// <ul>
    /// <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
    /// </ul>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp when the route calculator resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    /// <ul>
    /// <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
    /// </ul>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The data provider of traffic and road network data. Indicates one of the available providers:</p>
    /// <ul>
    /// <li> <p> <code>Esri</code> </p> </li>
    /// <li> <p> <code>Here</code> </p> </li>
    /// </ul>
    /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
    pub data_source: std::option::Option<std::string::String>,
    /// <p>Tags associated with route calculator resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DescribeRouteCalculatorOutput {
    /// <p>The name of the route calculator resource being described.</p>
    pub fn calculator_name(&self) -> std::option::Option<&str> {
        self.calculator_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the Route calculator resource. Use the ARN when you specify a resource across AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:route-calculator/ExampleCalculator</code> </p> </li>
    /// </ul>
    pub fn calculator_arn(&self) -> std::option::Option<&str> {
        self.calculator_arn.as_deref()
    }
    /// <p>Always returns <code>RequestBasedUsage</code>.</p>
    pub fn pricing_plan(&self) -> std::option::Option<&crate::model::PricingPlan> {
        self.pricing_plan.as_ref()
    }
    /// <p>The optional description of the route calculator resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The timestamp when the route calculator resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    /// <ul>
    /// <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
    /// </ul>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
    /// <p>The timestamp when the route calculator resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    /// <ul>
    /// <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
    /// </ul>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
    /// <p>The data provider of traffic and road network data. Indicates one of the available providers:</p>
    /// <ul>
    /// <li> <p> <code>Esri</code> </p> </li>
    /// <li> <p> <code>Here</code> </p> </li>
    /// </ul>
    /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
    pub fn data_source(&self) -> std::option::Option<&str> {
        self.data_source.as_deref()
    }
    /// <p>Tags associated with route calculator resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for DescribeRouteCalculatorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRouteCalculatorOutput");
        formatter.field("calculator_name", &self.calculator_name);
        formatter.field("calculator_arn", &self.calculator_arn);
        formatter.field("pricing_plan", &self.pricing_plan);
        formatter.field("description", &self.description);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.field("data_source", &self.data_source);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribeRouteCalculatorOutput`](crate::output::DescribeRouteCalculatorOutput)
pub mod describe_route_calculator_output {
    /// A builder for [`DescribeRouteCalculatorOutput`](crate::output::DescribeRouteCalculatorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) calculator_name: std::option::Option<std::string::String>,
        pub(crate) calculator_arn: std::option::Option<std::string::String>,
        pub(crate) pricing_plan: std::option::Option<crate::model::PricingPlan>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) data_source: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the route calculator resource being described.</p>
        pub fn calculator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.calculator_name = Some(input.into());
            self
        }
        /// <p>The name of the route calculator resource being described.</p>
        pub fn set_calculator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.calculator_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Route calculator resource. Use the ARN when you specify a resource across AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:route-calculator/ExampleCalculator</code> </p> </li>
        /// </ul>
        pub fn calculator_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.calculator_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Route calculator resource. Use the ARN when you specify a resource across AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:route-calculator/ExampleCalculator</code> </p> </li>
        /// </ul>
        pub fn set_calculator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.calculator_arn = input;
            self
        }
        /// <p>Always returns <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.pricing_plan = Some(input);
            self
        }
        /// <p>Always returns <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.pricing_plan = input;
            self
        }
        /// <p>The optional description of the route calculator resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The optional description of the route calculator resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The timestamp when the route calculator resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        /// <ul>
        /// <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
        /// </ul>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp when the route calculator resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        /// <ul>
        /// <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
        /// </ul>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The timestamp when the route calculator resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        /// <ul>
        /// <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
        /// </ul>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>The timestamp when the route calculator resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        /// <ul>
        /// <li> <p>For example, <code>2020–07-2T12:15:20.000Z+01:00</code> </p> </li>
        /// </ul>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// <p>The data provider of traffic and road network data. Indicates one of the available providers:</p>
        /// <ul>
        /// <li> <p> <code>Esri</code> </p> </li>
        /// <li> <p> <code>Here</code> </p> </li>
        /// </ul>
        /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
        pub fn data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source = Some(input.into());
            self
        }
        /// <p>The data provider of traffic and road network data. Indicates one of the available providers:</p>
        /// <ul>
        /// <li> <p> <code>Esri</code> </p> </li>
        /// <li> <p> <code>Here</code> </p> </li>
        /// </ul>
        /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
        pub fn set_data_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_source = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags associated with route calculator resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags associated with route calculator resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRouteCalculatorOutput`](crate::output::DescribeRouteCalculatorOutput)
        pub fn build(self) -> crate::output::DescribeRouteCalculatorOutput {
            crate::output::DescribeRouteCalculatorOutput {
                calculator_name: self.calculator_name,
                calculator_arn: self.calculator_arn,
                pricing_plan: self.pricing_plan,
                description: self.description,
                create_time: self.create_time,
                update_time: self.update_time,
                data_source: self.data_source,
                tags: self.tags,
            }
        }
    }
}
impl DescribeRouteCalculatorOutput {
    /// Creates a new builder-style object to manufacture [`DescribeRouteCalculatorOutput`](crate::output::DescribeRouteCalculatorOutput)
    pub fn builder() -> crate::output::describe_route_calculator_output::Builder {
        crate::output::describe_route_calculator_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchPlaceIndexForTextOutput {
    /// <p>Contains a summary of the request. Echoes the input values for <code>BiasPosition</code>, <code>FilterBBox</code>, <code>FilterCountries</code>, <code>Language</code>, <code>MaxResults</code>, and <code>Text</code>. Also includes the <code>DataSource</code> of the place index and the bounding box, <code>ResultBBox</code>, which surrounds the search results. </p>
    pub summary: std::option::Option<crate::model::SearchPlaceIndexForTextSummary>,
    /// <p>A list of Places matching the input text. Each result contains additional information about the specific point of interest. </p>
    /// <p>Not all response properties are included with all responses. Some properties may only be returned by specific data partners.</p>
    pub results: std::option::Option<std::vec::Vec<crate::model::SearchForTextResult>>,
}
impl SearchPlaceIndexForTextOutput {
    /// <p>Contains a summary of the request. Echoes the input values for <code>BiasPosition</code>, <code>FilterBBox</code>, <code>FilterCountries</code>, <code>Language</code>, <code>MaxResults</code>, and <code>Text</code>. Also includes the <code>DataSource</code> of the place index and the bounding box, <code>ResultBBox</code>, which surrounds the search results. </p>
    pub fn summary(&self) -> std::option::Option<&crate::model::SearchPlaceIndexForTextSummary> {
        self.summary.as_ref()
    }
    /// <p>A list of Places matching the input text. Each result contains additional information about the specific point of interest. </p>
    /// <p>Not all response properties are included with all responses. Some properties may only be returned by specific data partners.</p>
    pub fn results(&self) -> std::option::Option<&[crate::model::SearchForTextResult]> {
        self.results.as_deref()
    }
}
impl std::fmt::Debug for SearchPlaceIndexForTextOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchPlaceIndexForTextOutput");
        formatter.field("summary", &self.summary);
        formatter.field("results", &self.results);
        formatter.finish()
    }
}
/// See [`SearchPlaceIndexForTextOutput`](crate::output::SearchPlaceIndexForTextOutput)
pub mod search_place_index_for_text_output {
    /// A builder for [`SearchPlaceIndexForTextOutput`](crate::output::SearchPlaceIndexForTextOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summary: std::option::Option<crate::model::SearchPlaceIndexForTextSummary>,
        pub(crate) results: std::option::Option<std::vec::Vec<crate::model::SearchForTextResult>>,
    }
    impl Builder {
        /// <p>Contains a summary of the request. Echoes the input values for <code>BiasPosition</code>, <code>FilterBBox</code>, <code>FilterCountries</code>, <code>Language</code>, <code>MaxResults</code>, and <code>Text</code>. Also includes the <code>DataSource</code> of the place index and the bounding box, <code>ResultBBox</code>, which surrounds the search results. </p>
        pub fn summary(mut self, input: crate::model::SearchPlaceIndexForTextSummary) -> Self {
            self.summary = Some(input);
            self
        }
        /// <p>Contains a summary of the request. Echoes the input values for <code>BiasPosition</code>, <code>FilterBBox</code>, <code>FilterCountries</code>, <code>Language</code>, <code>MaxResults</code>, and <code>Text</code>. Also includes the <code>DataSource</code> of the place index and the bounding box, <code>ResultBBox</code>, which surrounds the search results. </p>
        pub fn set_summary(
            mut self,
            input: std::option::Option<crate::model::SearchPlaceIndexForTextSummary>,
        ) -> Self {
            self.summary = input;
            self
        }
        /// Appends an item to `results`.
        ///
        /// To override the contents of this collection use [`set_results`](Self::set_results).
        ///
        /// <p>A list of Places matching the input text. Each result contains additional information about the specific point of interest. </p>
        /// <p>Not all response properties are included with all responses. Some properties may only be returned by specific data partners.</p>
        pub fn results(mut self, input: crate::model::SearchForTextResult) -> Self {
            let mut v = self.results.unwrap_or_default();
            v.push(input);
            self.results = Some(v);
            self
        }
        /// <p>A list of Places matching the input text. Each result contains additional information about the specific point of interest. </p>
        /// <p>Not all response properties are included with all responses. Some properties may only be returned by specific data partners.</p>
        pub fn set_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SearchForTextResult>>,
        ) -> Self {
            self.results = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchPlaceIndexForTextOutput`](crate::output::SearchPlaceIndexForTextOutput)
        pub fn build(self) -> crate::output::SearchPlaceIndexForTextOutput {
            crate::output::SearchPlaceIndexForTextOutput {
                summary: self.summary,
                results: self.results,
            }
        }
    }
}
impl SearchPlaceIndexForTextOutput {
    /// Creates a new builder-style object to manufacture [`SearchPlaceIndexForTextOutput`](crate::output::SearchPlaceIndexForTextOutput)
    pub fn builder() -> crate::output::search_place_index_for_text_output::Builder {
        crate::output::search_place_index_for_text_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchPlaceIndexForSuggestionsOutput {
    /// <p>Contains a summary of the request. Echoes the input values for <code>BiasPosition</code>, <code>FilterBBox</code>, <code>FilterCountries</code>, <code>Language</code>, <code>MaxResults</code>, and <code>Text</code>. Also includes the <code>DataSource</code> of the place index. </p>
    pub summary: std::option::Option<crate::model::SearchPlaceIndexForSuggestionsSummary>,
    /// <p>A list of place suggestions that best match the search text.</p>
    pub results: std::option::Option<std::vec::Vec<crate::model::SearchForSuggestionsResult>>,
}
impl SearchPlaceIndexForSuggestionsOutput {
    /// <p>Contains a summary of the request. Echoes the input values for <code>BiasPosition</code>, <code>FilterBBox</code>, <code>FilterCountries</code>, <code>Language</code>, <code>MaxResults</code>, and <code>Text</code>. Also includes the <code>DataSource</code> of the place index. </p>
    pub fn summary(
        &self,
    ) -> std::option::Option<&crate::model::SearchPlaceIndexForSuggestionsSummary> {
        self.summary.as_ref()
    }
    /// <p>A list of place suggestions that best match the search text.</p>
    pub fn results(&self) -> std::option::Option<&[crate::model::SearchForSuggestionsResult]> {
        self.results.as_deref()
    }
}
impl std::fmt::Debug for SearchPlaceIndexForSuggestionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchPlaceIndexForSuggestionsOutput");
        formatter.field("summary", &self.summary);
        formatter.field("results", &self.results);
        formatter.finish()
    }
}
/// See [`SearchPlaceIndexForSuggestionsOutput`](crate::output::SearchPlaceIndexForSuggestionsOutput)
pub mod search_place_index_for_suggestions_output {
    /// A builder for [`SearchPlaceIndexForSuggestionsOutput`](crate::output::SearchPlaceIndexForSuggestionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summary:
            std::option::Option<crate::model::SearchPlaceIndexForSuggestionsSummary>,
        pub(crate) results:
            std::option::Option<std::vec::Vec<crate::model::SearchForSuggestionsResult>>,
    }
    impl Builder {
        /// <p>Contains a summary of the request. Echoes the input values for <code>BiasPosition</code>, <code>FilterBBox</code>, <code>FilterCountries</code>, <code>Language</code>, <code>MaxResults</code>, and <code>Text</code>. Also includes the <code>DataSource</code> of the place index. </p>
        pub fn summary(
            mut self,
            input: crate::model::SearchPlaceIndexForSuggestionsSummary,
        ) -> Self {
            self.summary = Some(input);
            self
        }
        /// <p>Contains a summary of the request. Echoes the input values for <code>BiasPosition</code>, <code>FilterBBox</code>, <code>FilterCountries</code>, <code>Language</code>, <code>MaxResults</code>, and <code>Text</code>. Also includes the <code>DataSource</code> of the place index. </p>
        pub fn set_summary(
            mut self,
            input: std::option::Option<crate::model::SearchPlaceIndexForSuggestionsSummary>,
        ) -> Self {
            self.summary = input;
            self
        }
        /// Appends an item to `results`.
        ///
        /// To override the contents of this collection use [`set_results`](Self::set_results).
        ///
        /// <p>A list of place suggestions that best match the search text.</p>
        pub fn results(mut self, input: crate::model::SearchForSuggestionsResult) -> Self {
            let mut v = self.results.unwrap_or_default();
            v.push(input);
            self.results = Some(v);
            self
        }
        /// <p>A list of place suggestions that best match the search text.</p>
        pub fn set_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SearchForSuggestionsResult>>,
        ) -> Self {
            self.results = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchPlaceIndexForSuggestionsOutput`](crate::output::SearchPlaceIndexForSuggestionsOutput)
        pub fn build(self) -> crate::output::SearchPlaceIndexForSuggestionsOutput {
            crate::output::SearchPlaceIndexForSuggestionsOutput {
                summary: self.summary,
                results: self.results,
            }
        }
    }
}
impl SearchPlaceIndexForSuggestionsOutput {
    /// Creates a new builder-style object to manufacture [`SearchPlaceIndexForSuggestionsOutput`](crate::output::SearchPlaceIndexForSuggestionsOutput)
    pub fn builder() -> crate::output::search_place_index_for_suggestions_output::Builder {
        crate::output::search_place_index_for_suggestions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchPlaceIndexForPositionOutput {
    /// <p>Contains a summary of the request. Echoes the input values for <code>Position</code>, <code>Language</code>, <code>MaxResults</code>, and the <code>DataSource</code> of the place index. </p>
    pub summary: std::option::Option<crate::model::SearchPlaceIndexForPositionSummary>,
    /// <p>Returns a list of Places closest to the specified position. Each result contains additional information about the Places returned.</p>
    pub results: std::option::Option<std::vec::Vec<crate::model::SearchForPositionResult>>,
}
impl SearchPlaceIndexForPositionOutput {
    /// <p>Contains a summary of the request. Echoes the input values for <code>Position</code>, <code>Language</code>, <code>MaxResults</code>, and the <code>DataSource</code> of the place index. </p>
    pub fn summary(
        &self,
    ) -> std::option::Option<&crate::model::SearchPlaceIndexForPositionSummary> {
        self.summary.as_ref()
    }
    /// <p>Returns a list of Places closest to the specified position. Each result contains additional information about the Places returned.</p>
    pub fn results(&self) -> std::option::Option<&[crate::model::SearchForPositionResult]> {
        self.results.as_deref()
    }
}
impl std::fmt::Debug for SearchPlaceIndexForPositionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchPlaceIndexForPositionOutput");
        formatter.field("summary", &self.summary);
        formatter.field("results", &self.results);
        formatter.finish()
    }
}
/// See [`SearchPlaceIndexForPositionOutput`](crate::output::SearchPlaceIndexForPositionOutput)
pub mod search_place_index_for_position_output {
    /// A builder for [`SearchPlaceIndexForPositionOutput`](crate::output::SearchPlaceIndexForPositionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) summary: std::option::Option<crate::model::SearchPlaceIndexForPositionSummary>,
        pub(crate) results:
            std::option::Option<std::vec::Vec<crate::model::SearchForPositionResult>>,
    }
    impl Builder {
        /// <p>Contains a summary of the request. Echoes the input values for <code>Position</code>, <code>Language</code>, <code>MaxResults</code>, and the <code>DataSource</code> of the place index. </p>
        pub fn summary(mut self, input: crate::model::SearchPlaceIndexForPositionSummary) -> Self {
            self.summary = Some(input);
            self
        }
        /// <p>Contains a summary of the request. Echoes the input values for <code>Position</code>, <code>Language</code>, <code>MaxResults</code>, and the <code>DataSource</code> of the place index. </p>
        pub fn set_summary(
            mut self,
            input: std::option::Option<crate::model::SearchPlaceIndexForPositionSummary>,
        ) -> Self {
            self.summary = input;
            self
        }
        /// Appends an item to `results`.
        ///
        /// To override the contents of this collection use [`set_results`](Self::set_results).
        ///
        /// <p>Returns a list of Places closest to the specified position. Each result contains additional information about the Places returned.</p>
        pub fn results(mut self, input: crate::model::SearchForPositionResult) -> Self {
            let mut v = self.results.unwrap_or_default();
            v.push(input);
            self.results = Some(v);
            self
        }
        /// <p>Returns a list of Places closest to the specified position. Each result contains additional information about the Places returned.</p>
        pub fn set_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SearchForPositionResult>>,
        ) -> Self {
            self.results = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchPlaceIndexForPositionOutput`](crate::output::SearchPlaceIndexForPositionOutput)
        pub fn build(self) -> crate::output::SearchPlaceIndexForPositionOutput {
            crate::output::SearchPlaceIndexForPositionOutput {
                summary: self.summary,
                results: self.results,
            }
        }
    }
}
impl SearchPlaceIndexForPositionOutput {
    /// Creates a new builder-style object to manufacture [`SearchPlaceIndexForPositionOutput`](crate::output::SearchPlaceIndexForPositionOutput)
    pub fn builder() -> crate::output::search_place_index_for_position_output::Builder {
        crate::output::search_place_index_for_position_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPlaceIndexesOutput {
    /// <p>Lists the place index resources that exist in your AWS account</p>
    pub entries: std::option::Option<std::vec::Vec<crate::model::ListPlaceIndexesResponseEntry>>,
    /// <p>A pagination token indicating that there are additional pages available. You can use the token in a new request to fetch the next page of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListPlaceIndexesOutput {
    /// <p>Lists the place index resources that exist in your AWS account</p>
    pub fn entries(&self) -> std::option::Option<&[crate::model::ListPlaceIndexesResponseEntry]> {
        self.entries.as_deref()
    }
    /// <p>A pagination token indicating that there are additional pages available. You can use the token in a new request to fetch the next page of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListPlaceIndexesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPlaceIndexesOutput");
        formatter.field("entries", &self.entries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListPlaceIndexesOutput`](crate::output::ListPlaceIndexesOutput)
pub mod list_place_indexes_output {
    /// A builder for [`ListPlaceIndexesOutput`](crate::output::ListPlaceIndexesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entries:
            std::option::Option<std::vec::Vec<crate::model::ListPlaceIndexesResponseEntry>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>Lists the place index resources that exist in your AWS account</p>
        pub fn entries(mut self, input: crate::model::ListPlaceIndexesResponseEntry) -> Self {
            let mut v = self.entries.unwrap_or_default();
            v.push(input);
            self.entries = Some(v);
            self
        }
        /// <p>Lists the place index resources that exist in your AWS account</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListPlaceIndexesResponseEntry>>,
        ) -> Self {
            self.entries = input;
            self
        }
        /// <p>A pagination token indicating that there are additional pages available. You can use the token in a new request to fetch the next page of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token indicating that there are additional pages available. You can use the token in a new request to fetch the next page of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPlaceIndexesOutput`](crate::output::ListPlaceIndexesOutput)
        pub fn build(self) -> crate::output::ListPlaceIndexesOutput {
            crate::output::ListPlaceIndexesOutput {
                entries: self.entries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListPlaceIndexesOutput {
    /// Creates a new builder-style object to manufacture [`ListPlaceIndexesOutput`](crate::output::ListPlaceIndexesOutput)
    pub fn builder() -> crate::output::list_place_indexes_output::Builder {
        crate::output::list_place_indexes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePlaceIndexOutput {
    /// <p>The name for the place index resource.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across AWS. </p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex</code> </p> </li>
    /// </ul>
    pub index_arn: std::option::Option<std::string::String>,
    /// <p>The timestamp for when the place index resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreatePlaceIndexOutput {
    /// <p>The name for the place index resource.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across AWS. </p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex</code> </p> </li>
    /// </ul>
    pub fn index_arn(&self) -> std::option::Option<&str> {
        self.index_arn.as_deref()
    }
    /// <p>The timestamp for when the place index resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
}
impl std::fmt::Debug for CreatePlaceIndexOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePlaceIndexOutput");
        formatter.field("index_name", &self.index_name);
        formatter.field("index_arn", &self.index_arn);
        formatter.field("create_time", &self.create_time);
        formatter.finish()
    }
}
/// See [`CreatePlaceIndexOutput`](crate::output::CreatePlaceIndexOutput)
pub mod create_place_index_output {
    /// A builder for [`CreatePlaceIndexOutput`](crate::output::CreatePlaceIndexOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) index_arn: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name for the place index resource.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name for the place index resource.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across AWS. </p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex</code> </p> </li>
        /// </ul>
        pub fn index_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across AWS. </p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex</code> </p> </li>
        /// </ul>
        pub fn set_index_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_arn = input;
            self
        }
        /// <p>The timestamp for when the place index resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp for when the place index resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePlaceIndexOutput`](crate::output::CreatePlaceIndexOutput)
        pub fn build(self) -> crate::output::CreatePlaceIndexOutput {
            crate::output::CreatePlaceIndexOutput {
                index_name: self.index_name,
                index_arn: self.index_arn,
                create_time: self.create_time,
            }
        }
    }
}
impl CreatePlaceIndexOutput {
    /// Creates a new builder-style object to manufacture [`CreatePlaceIndexOutput`](crate::output::CreatePlaceIndexOutput)
    pub fn builder() -> crate::output::create_place_index_output::Builder {
        crate::output::create_place_index_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePlaceIndexOutput {}
impl std::fmt::Debug for DeletePlaceIndexOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePlaceIndexOutput");
        formatter.finish()
    }
}
/// See [`DeletePlaceIndexOutput`](crate::output::DeletePlaceIndexOutput)
pub mod delete_place_index_output {
    /// A builder for [`DeletePlaceIndexOutput`](crate::output::DeletePlaceIndexOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePlaceIndexOutput`](crate::output::DeletePlaceIndexOutput)
        pub fn build(self) -> crate::output::DeletePlaceIndexOutput {
            crate::output::DeletePlaceIndexOutput {}
        }
    }
}
impl DeletePlaceIndexOutput {
    /// Creates a new builder-style object to manufacture [`DeletePlaceIndexOutput`](crate::output::DeletePlaceIndexOutput)
    pub fn builder() -> crate::output::delete_place_index_output::Builder {
        crate::output::delete_place_index_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePlaceIndexOutput {
    /// <p>The name of the updated place index resource.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the upated place index resource. Used to specify a resource across AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:place- index/ExamplePlaceIndex</code> </p> </li>
    /// </ul>
    pub index_arn: std::option::Option<std::string::String>,
    /// <p>The timestamp for when the place index resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdatePlaceIndexOutput {
    /// <p>The name of the updated place index resource.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the upated place index resource. Used to specify a resource across AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:place- index/ExamplePlaceIndex</code> </p> </li>
    /// </ul>
    pub fn index_arn(&self) -> std::option::Option<&str> {
        self.index_arn.as_deref()
    }
    /// <p>The timestamp for when the place index resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
}
impl std::fmt::Debug for UpdatePlaceIndexOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePlaceIndexOutput");
        formatter.field("index_name", &self.index_name);
        formatter.field("index_arn", &self.index_arn);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`UpdatePlaceIndexOutput`](crate::output::UpdatePlaceIndexOutput)
pub mod update_place_index_output {
    /// A builder for [`UpdatePlaceIndexOutput`](crate::output::UpdatePlaceIndexOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) index_arn: std::option::Option<std::string::String>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the updated place index resource.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the updated place index resource.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the upated place index resource. Used to specify a resource across AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:place- index/ExamplePlaceIndex</code> </p> </li>
        /// </ul>
        pub fn index_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the upated place index resource. Used to specify a resource across AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:place- index/ExamplePlaceIndex</code> </p> </li>
        /// </ul>
        pub fn set_index_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_arn = input;
            self
        }
        /// <p>The timestamp for when the place index resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>The timestamp for when the place index resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePlaceIndexOutput`](crate::output::UpdatePlaceIndexOutput)
        pub fn build(self) -> crate::output::UpdatePlaceIndexOutput {
            crate::output::UpdatePlaceIndexOutput {
                index_name: self.index_name,
                index_arn: self.index_arn,
                update_time: self.update_time,
            }
        }
    }
}
impl UpdatePlaceIndexOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePlaceIndexOutput`](crate::output::UpdatePlaceIndexOutput)
    pub fn builder() -> crate::output::update_place_index_output::Builder {
        crate::output::update_place_index_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePlaceIndexOutput {
    /// <p>The name of the place index resource being described.</p>
    pub index_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across AWS. </p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex</code> </p> </li>
    /// </ul>
    pub index_arn: std::option::Option<std::string::String>,
    /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
    pub pricing_plan: std::option::Option<crate::model::PricingPlan>,
    /// <p>The optional description for the place index resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The timestamp for when the place index resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp for when the place index resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The data provider of geospatial data. Values can be one of the following:</p>
    /// <ul>
    /// <li> <p> <code>Esri</code> </p> </li>
    /// <li> <p> <code>Here</code> </p> </li>
    /// </ul>
    /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
    pub data_source: std::option::Option<std::string::String>,
    /// <p>The specified data storage option for requesting Places.</p>
    pub data_source_configuration: std::option::Option<crate::model::DataSourceConfiguration>,
    /// <p>Tags associated with place index resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DescribePlaceIndexOutput {
    /// <p>The name of the place index resource being described.</p>
    pub fn index_name(&self) -> std::option::Option<&str> {
        self.index_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across AWS. </p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex</code> </p> </li>
    /// </ul>
    pub fn index_arn(&self) -> std::option::Option<&str> {
        self.index_arn.as_deref()
    }
    /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
    pub fn pricing_plan(&self) -> std::option::Option<&crate::model::PricingPlan> {
        self.pricing_plan.as_ref()
    }
    /// <p>The optional description for the place index resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The timestamp for when the place index resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
    /// <p>The timestamp for when the place index resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
    /// <p>The data provider of geospatial data. Values can be one of the following:</p>
    /// <ul>
    /// <li> <p> <code>Esri</code> </p> </li>
    /// <li> <p> <code>Here</code> </p> </li>
    /// </ul>
    /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
    pub fn data_source(&self) -> std::option::Option<&str> {
        self.data_source.as_deref()
    }
    /// <p>The specified data storage option for requesting Places.</p>
    pub fn data_source_configuration(
        &self,
    ) -> std::option::Option<&crate::model::DataSourceConfiguration> {
        self.data_source_configuration.as_ref()
    }
    /// <p>Tags associated with place index resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for DescribePlaceIndexOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePlaceIndexOutput");
        formatter.field("index_name", &self.index_name);
        formatter.field("index_arn", &self.index_arn);
        formatter.field("pricing_plan", &self.pricing_plan);
        formatter.field("description", &self.description);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.field("data_source", &self.data_source);
        formatter.field("data_source_configuration", &self.data_source_configuration);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribePlaceIndexOutput`](crate::output::DescribePlaceIndexOutput)
pub mod describe_place_index_output {
    /// A builder for [`DescribePlaceIndexOutput`](crate::output::DescribePlaceIndexOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) index_name: std::option::Option<std::string::String>,
        pub(crate) index_arn: std::option::Option<std::string::String>,
        pub(crate) pricing_plan: std::option::Option<crate::model::PricingPlan>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) data_source: std::option::Option<std::string::String>,
        pub(crate) data_source_configuration:
            std::option::Option<crate::model::DataSourceConfiguration>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the place index resource being described.</p>
        pub fn index_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_name = Some(input.into());
            self
        }
        /// <p>The name of the place index resource being described.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across AWS. </p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex</code> </p> </li>
        /// </ul>
        pub fn index_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.index_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the place index resource. Used to specify a resource across AWS. </p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:place-index/ExamplePlaceIndex</code> </p> </li>
        /// </ul>
        pub fn set_index_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.index_arn = input;
            self
        }
        /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.pricing_plan = Some(input);
            self
        }
        /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.pricing_plan = input;
            self
        }
        /// <p>The optional description for the place index resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The optional description for the place index resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The timestamp for when the place index resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp for when the place index resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The timestamp for when the place index resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>The timestamp for when the place index resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// <p>The data provider of geospatial data. Values can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>Esri</code> </p> </li>
        /// <li> <p> <code>Here</code> </p> </li>
        /// </ul>
        /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
        pub fn data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source = Some(input.into());
            self
        }
        /// <p>The data provider of geospatial data. Values can be one of the following:</p>
        /// <ul>
        /// <li> <p> <code>Esri</code> </p> </li>
        /// <li> <p> <code>Here</code> </p> </li>
        /// </ul>
        /// <p>For more information about data providers, see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers</a>.</p>
        pub fn set_data_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_source = input;
            self
        }
        /// <p>The specified data storage option for requesting Places.</p>
        pub fn data_source_configuration(
            mut self,
            input: crate::model::DataSourceConfiguration,
        ) -> Self {
            self.data_source_configuration = Some(input);
            self
        }
        /// <p>The specified data storage option for requesting Places.</p>
        pub fn set_data_source_configuration(
            mut self,
            input: std::option::Option<crate::model::DataSourceConfiguration>,
        ) -> Self {
            self.data_source_configuration = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags associated with place index resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags associated with place index resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePlaceIndexOutput`](crate::output::DescribePlaceIndexOutput)
        pub fn build(self) -> crate::output::DescribePlaceIndexOutput {
            crate::output::DescribePlaceIndexOutput {
                index_name: self.index_name,
                index_arn: self.index_arn,
                pricing_plan: self.pricing_plan,
                description: self.description,
                create_time: self.create_time,
                update_time: self.update_time,
                data_source: self.data_source,
                data_source_configuration: self.data_source_configuration,
                tags: self.tags,
            }
        }
    }
}
impl DescribePlaceIndexOutput {
    /// Creates a new builder-style object to manufacture [`DescribePlaceIndexOutput`](crate::output::DescribePlaceIndexOutput)
    pub fn builder() -> crate::output::describe_place_index_output::Builder {
        crate::output::describe_place_index_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMapTileOutput {
    /// <p>Contains Mapbox Vector Tile (MVT) data.</p>
    pub blob: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The map tile's content type. For example, <code>application/vnd.mapbox-vector-tile</code>.</p>
    pub content_type: std::option::Option<std::string::String>,
}
impl GetMapTileOutput {
    /// <p>Contains Mapbox Vector Tile (MVT) data.</p>
    pub fn blob(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.blob.as_ref()
    }
    /// <p>The map tile's content type. For example, <code>application/vnd.mapbox-vector-tile</code>.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
}
impl std::fmt::Debug for GetMapTileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMapTileOutput");
        formatter.field("blob", &self.blob);
        formatter.field("content_type", &self.content_type);
        formatter.finish()
    }
}
/// See [`GetMapTileOutput`](crate::output::GetMapTileOutput)
pub mod get_map_tile_output {
    /// A builder for [`GetMapTileOutput`](crate::output::GetMapTileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) blob: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) content_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Contains Mapbox Vector Tile (MVT) data.</p>
        pub fn blob(mut self, input: aws_smithy_types::Blob) -> Self {
            self.blob = Some(input);
            self
        }
        /// <p>Contains Mapbox Vector Tile (MVT) data.</p>
        pub fn set_blob(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.blob = input;
            self
        }
        /// <p>The map tile's content type. For example, <code>application/vnd.mapbox-vector-tile</code>.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The map tile's content type. For example, <code>application/vnd.mapbox-vector-tile</code>.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMapTileOutput`](crate::output::GetMapTileOutput)
        pub fn build(self) -> crate::output::GetMapTileOutput {
            crate::output::GetMapTileOutput {
                blob: self.blob,
                content_type: self.content_type,
            }
        }
    }
}
impl GetMapTileOutput {
    /// Creates a new builder-style object to manufacture [`GetMapTileOutput`](crate::output::GetMapTileOutput)
    pub fn builder() -> crate::output::get_map_tile_output::Builder {
        crate::output::get_map_tile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMapStyleDescriptorOutput {
    /// <p>Contains the body of the style descriptor.</p>
    pub blob: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The style descriptor's content type. For example, <code>application/json</code>.</p>
    pub content_type: std::option::Option<std::string::String>,
}
impl GetMapStyleDescriptorOutput {
    /// <p>Contains the body of the style descriptor.</p>
    pub fn blob(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.blob.as_ref()
    }
    /// <p>The style descriptor's content type. For example, <code>application/json</code>.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
}
impl std::fmt::Debug for GetMapStyleDescriptorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMapStyleDescriptorOutput");
        formatter.field("blob", &self.blob);
        formatter.field("content_type", &self.content_type);
        formatter.finish()
    }
}
/// See [`GetMapStyleDescriptorOutput`](crate::output::GetMapStyleDescriptorOutput)
pub mod get_map_style_descriptor_output {
    /// A builder for [`GetMapStyleDescriptorOutput`](crate::output::GetMapStyleDescriptorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) blob: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) content_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Contains the body of the style descriptor.</p>
        pub fn blob(mut self, input: aws_smithy_types::Blob) -> Self {
            self.blob = Some(input);
            self
        }
        /// <p>Contains the body of the style descriptor.</p>
        pub fn set_blob(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.blob = input;
            self
        }
        /// <p>The style descriptor's content type. For example, <code>application/json</code>.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The style descriptor's content type. For example, <code>application/json</code>.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMapStyleDescriptorOutput`](crate::output::GetMapStyleDescriptorOutput)
        pub fn build(self) -> crate::output::GetMapStyleDescriptorOutput {
            crate::output::GetMapStyleDescriptorOutput {
                blob: self.blob,
                content_type: self.content_type,
            }
        }
    }
}
impl GetMapStyleDescriptorOutput {
    /// Creates a new builder-style object to manufacture [`GetMapStyleDescriptorOutput`](crate::output::GetMapStyleDescriptorOutput)
    pub fn builder() -> crate::output::get_map_style_descriptor_output::Builder {
        crate::output::get_map_style_descriptor_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMapSpritesOutput {
    /// <p>Contains the body of the sprite sheet or JSON offset ﬁle.</p>
    pub blob: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The content type of the sprite sheet and offsets. For example, the sprite sheet content type is <code>image/png</code>, and the sprite offset JSON document is <code>application/json</code>. </p>
    pub content_type: std::option::Option<std::string::String>,
}
impl GetMapSpritesOutput {
    /// <p>Contains the body of the sprite sheet or JSON offset ﬁle.</p>
    pub fn blob(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.blob.as_ref()
    }
    /// <p>The content type of the sprite sheet and offsets. For example, the sprite sheet content type is <code>image/png</code>, and the sprite offset JSON document is <code>application/json</code>. </p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
}
impl std::fmt::Debug for GetMapSpritesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMapSpritesOutput");
        formatter.field("blob", &self.blob);
        formatter.field("content_type", &self.content_type);
        formatter.finish()
    }
}
/// See [`GetMapSpritesOutput`](crate::output::GetMapSpritesOutput)
pub mod get_map_sprites_output {
    /// A builder for [`GetMapSpritesOutput`](crate::output::GetMapSpritesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) blob: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) content_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Contains the body of the sprite sheet or JSON offset ﬁle.</p>
        pub fn blob(mut self, input: aws_smithy_types::Blob) -> Self {
            self.blob = Some(input);
            self
        }
        /// <p>Contains the body of the sprite sheet or JSON offset ﬁle.</p>
        pub fn set_blob(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.blob = input;
            self
        }
        /// <p>The content type of the sprite sheet and offsets. For example, the sprite sheet content type is <code>image/png</code>, and the sprite offset JSON document is <code>application/json</code>. </p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The content type of the sprite sheet and offsets. For example, the sprite sheet content type is <code>image/png</code>, and the sprite offset JSON document is <code>application/json</code>. </p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMapSpritesOutput`](crate::output::GetMapSpritesOutput)
        pub fn build(self) -> crate::output::GetMapSpritesOutput {
            crate::output::GetMapSpritesOutput {
                blob: self.blob,
                content_type: self.content_type,
            }
        }
    }
}
impl GetMapSpritesOutput {
    /// Creates a new builder-style object to manufacture [`GetMapSpritesOutput`](crate::output::GetMapSpritesOutput)
    pub fn builder() -> crate::output::get_map_sprites_output::Builder {
        crate::output::get_map_sprites_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMapGlyphsOutput {
    /// <p>The blob's content type.</p>
    pub blob: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The map glyph content type. For example, <code>application/octet-stream</code>.</p>
    pub content_type: std::option::Option<std::string::String>,
}
impl GetMapGlyphsOutput {
    /// <p>The blob's content type.</p>
    pub fn blob(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.blob.as_ref()
    }
    /// <p>The map glyph content type. For example, <code>application/octet-stream</code>.</p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
}
impl std::fmt::Debug for GetMapGlyphsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMapGlyphsOutput");
        formatter.field("blob", &self.blob);
        formatter.field("content_type", &self.content_type);
        formatter.finish()
    }
}
/// See [`GetMapGlyphsOutput`](crate::output::GetMapGlyphsOutput)
pub mod get_map_glyphs_output {
    /// A builder for [`GetMapGlyphsOutput`](crate::output::GetMapGlyphsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) blob: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) content_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The blob's content type.</p>
        pub fn blob(mut self, input: aws_smithy_types::Blob) -> Self {
            self.blob = Some(input);
            self
        }
        /// <p>The blob's content type.</p>
        pub fn set_blob(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.blob = input;
            self
        }
        /// <p>The map glyph content type. For example, <code>application/octet-stream</code>.</p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The map glyph content type. For example, <code>application/octet-stream</code>.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMapGlyphsOutput`](crate::output::GetMapGlyphsOutput)
        pub fn build(self) -> crate::output::GetMapGlyphsOutput {
            crate::output::GetMapGlyphsOutput {
                blob: self.blob,
                content_type: self.content_type,
            }
        }
    }
}
impl GetMapGlyphsOutput {
    /// Creates a new builder-style object to manufacture [`GetMapGlyphsOutput`](crate::output::GetMapGlyphsOutput)
    pub fn builder() -> crate::output::get_map_glyphs_output::Builder {
        crate::output::get_map_glyphs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMapsOutput {
    /// <p>Contains a list of maps in your AWS account</p>
    pub entries: std::option::Option<std::vec::Vec<crate::model::ListMapsResponseEntry>>,
    /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListMapsOutput {
    /// <p>Contains a list of maps in your AWS account</p>
    pub fn entries(&self) -> std::option::Option<&[crate::model::ListMapsResponseEntry]> {
        self.entries.as_deref()
    }
    /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListMapsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMapsOutput");
        formatter.field("entries", &self.entries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListMapsOutput`](crate::output::ListMapsOutput)
pub mod list_maps_output {
    /// A builder for [`ListMapsOutput`](crate::output::ListMapsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entries: std::option::Option<std::vec::Vec<crate::model::ListMapsResponseEntry>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>Contains a list of maps in your AWS account</p>
        pub fn entries(mut self, input: crate::model::ListMapsResponseEntry) -> Self {
            let mut v = self.entries.unwrap_or_default();
            v.push(input);
            self.entries = Some(v);
            self
        }
        /// <p>Contains a list of maps in your AWS account</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListMapsResponseEntry>>,
        ) -> Self {
            self.entries = input;
            self
        }
        /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMapsOutput`](crate::output::ListMapsOutput)
        pub fn build(self) -> crate::output::ListMapsOutput {
            crate::output::ListMapsOutput {
                entries: self.entries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListMapsOutput {
    /// Creates a new builder-style object to manufacture [`ListMapsOutput`](crate::output::ListMapsOutput)
    pub fn builder() -> crate::output::list_maps_output::Builder {
        crate::output::list_maps_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMapOutput {
    /// <p>The name of the map resource.</p>
    pub map_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:maps/ExampleMap</code> </p> </li>
    /// </ul>
    pub map_arn: std::option::Option<std::string::String>,
    /// <p>The timestamp for when the map resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateMapOutput {
    /// <p>The name of the map resource.</p>
    pub fn map_name(&self) -> std::option::Option<&str> {
        self.map_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:maps/ExampleMap</code> </p> </li>
    /// </ul>
    pub fn map_arn(&self) -> std::option::Option<&str> {
        self.map_arn.as_deref()
    }
    /// <p>The timestamp for when the map resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
}
impl std::fmt::Debug for CreateMapOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMapOutput");
        formatter.field("map_name", &self.map_name);
        formatter.field("map_arn", &self.map_arn);
        formatter.field("create_time", &self.create_time);
        formatter.finish()
    }
}
/// See [`CreateMapOutput`](crate::output::CreateMapOutput)
pub mod create_map_output {
    /// A builder for [`CreateMapOutput`](crate::output::CreateMapOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) map_name: std::option::Option<std::string::String>,
        pub(crate) map_arn: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the map resource.</p>
        pub fn map_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.map_name = Some(input.into());
            self
        }
        /// <p>The name of the map resource.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.map_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:maps/ExampleMap</code> </p> </li>
        /// </ul>
        pub fn map_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.map_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:maps/ExampleMap</code> </p> </li>
        /// </ul>
        pub fn set_map_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.map_arn = input;
            self
        }
        /// <p>The timestamp for when the map resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp for when the map resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMapOutput`](crate::output::CreateMapOutput)
        pub fn build(self) -> crate::output::CreateMapOutput {
            crate::output::CreateMapOutput {
                map_name: self.map_name,
                map_arn: self.map_arn,
                create_time: self.create_time,
            }
        }
    }
}
impl CreateMapOutput {
    /// Creates a new builder-style object to manufacture [`CreateMapOutput`](crate::output::CreateMapOutput)
    pub fn builder() -> crate::output::create_map_output::Builder {
        crate::output::create_map_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMapOutput {}
impl std::fmt::Debug for DeleteMapOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMapOutput");
        formatter.finish()
    }
}
/// See [`DeleteMapOutput`](crate::output::DeleteMapOutput)
pub mod delete_map_output {
    /// A builder for [`DeleteMapOutput`](crate::output::DeleteMapOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteMapOutput`](crate::output::DeleteMapOutput)
        pub fn build(self) -> crate::output::DeleteMapOutput {
            crate::output::DeleteMapOutput {}
        }
    }
}
impl DeleteMapOutput {
    /// Creates a new builder-style object to manufacture [`DeleteMapOutput`](crate::output::DeleteMapOutput)
    pub fn builder() -> crate::output::delete_map_output::Builder {
        crate::output::delete_map_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMapOutput {
    /// <p>The name of the updated map resource.</p>
    pub map_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the updated map resource. Used to specify a resource across AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:maps/ExampleMap</code> </p> </li>
    /// </ul>
    pub map_arn: std::option::Option<std::string::String>,
    /// <p>The timestamp for when the map resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdateMapOutput {
    /// <p>The name of the updated map resource.</p>
    pub fn map_name(&self) -> std::option::Option<&str> {
        self.map_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the updated map resource. Used to specify a resource across AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:maps/ExampleMap</code> </p> </li>
    /// </ul>
    pub fn map_arn(&self) -> std::option::Option<&str> {
        self.map_arn.as_deref()
    }
    /// <p>The timestamp for when the map resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
}
impl std::fmt::Debug for UpdateMapOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMapOutput");
        formatter.field("map_name", &self.map_name);
        formatter.field("map_arn", &self.map_arn);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`UpdateMapOutput`](crate::output::UpdateMapOutput)
pub mod update_map_output {
    /// A builder for [`UpdateMapOutput`](crate::output::UpdateMapOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) map_name: std::option::Option<std::string::String>,
        pub(crate) map_arn: std::option::Option<std::string::String>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the updated map resource.</p>
        pub fn map_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.map_name = Some(input.into());
            self
        }
        /// <p>The name of the updated map resource.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.map_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the updated map resource. Used to specify a resource across AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:maps/ExampleMap</code> </p> </li>
        /// </ul>
        pub fn map_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.map_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the updated map resource. Used to specify a resource across AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:maps/ExampleMap</code> </p> </li>
        /// </ul>
        pub fn set_map_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.map_arn = input;
            self
        }
        /// <p>The timestamp for when the map resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>The timestamp for when the map resource was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. </p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMapOutput`](crate::output::UpdateMapOutput)
        pub fn build(self) -> crate::output::UpdateMapOutput {
            crate::output::UpdateMapOutput {
                map_name: self.map_name,
                map_arn: self.map_arn,
                update_time: self.update_time,
            }
        }
    }
}
impl UpdateMapOutput {
    /// Creates a new builder-style object to manufacture [`UpdateMapOutput`](crate::output::UpdateMapOutput)
    pub fn builder() -> crate::output::update_map_output::Builder {
        crate::output::update_map_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMapOutput {
    /// <p>The map style selected from an available provider.</p>
    pub map_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:maps/ExampleMap</code> </p> </li>
    /// </ul>
    pub map_arn: std::option::Option<std::string::String>,
    /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
    pub pricing_plan: std::option::Option<crate::model::PricingPlan>,
    /// <p>Specifies the data provider for the associated map tiles.</p>
    pub data_source: std::option::Option<std::string::String>,
    /// <p>Specifies the map tile style selected from a partner data provider.</p>
    pub configuration: std::option::Option<crate::model::MapConfiguration>,
    /// <p>The optional description for the map resource.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Tags associated with the map resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The timestamp for when the map resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp for when the map resource was last update in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeMapOutput {
    /// <p>The map style selected from an available provider.</p>
    pub fn map_name(&self) -> std::option::Option<&str> {
        self.map_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:maps/ExampleMap</code> </p> </li>
    /// </ul>
    pub fn map_arn(&self) -> std::option::Option<&str> {
        self.map_arn.as_deref()
    }
    /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
    pub fn pricing_plan(&self) -> std::option::Option<&crate::model::PricingPlan> {
        self.pricing_plan.as_ref()
    }
    /// <p>Specifies the data provider for the associated map tiles.</p>
    pub fn data_source(&self) -> std::option::Option<&str> {
        self.data_source.as_deref()
    }
    /// <p>Specifies the map tile style selected from a partner data provider.</p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::MapConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>The optional description for the map resource.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Tags associated with the map resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The timestamp for when the map resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
    /// <p>The timestamp for when the map resource was last update in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeMapOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMapOutput");
        formatter.field("map_name", &self.map_name);
        formatter.field("map_arn", &self.map_arn);
        formatter.field("pricing_plan", &self.pricing_plan);
        formatter.field("data_source", &self.data_source);
        formatter.field("configuration", &self.configuration);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`DescribeMapOutput`](crate::output::DescribeMapOutput)
pub mod describe_map_output {
    /// A builder for [`DescribeMapOutput`](crate::output::DescribeMapOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) map_name: std::option::Option<std::string::String>,
        pub(crate) map_arn: std::option::Option<std::string::String>,
        pub(crate) pricing_plan: std::option::Option<crate::model::PricingPlan>,
        pub(crate) data_source: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<crate::model::MapConfiguration>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The map style selected from an available provider.</p>
        pub fn map_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.map_name = Some(input.into());
            self
        }
        /// <p>The map style selected from an available provider.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.map_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:maps/ExampleMap</code> </p> </li>
        /// </ul>
        pub fn map_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.map_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:maps/ExampleMap</code> </p> </li>
        /// </ul>
        pub fn set_map_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.map_arn = input;
            self
        }
        /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.pricing_plan = Some(input);
            self
        }
        /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.pricing_plan = input;
            self
        }
        /// <p>Specifies the data provider for the associated map tiles.</p>
        pub fn data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source = Some(input.into());
            self
        }
        /// <p>Specifies the data provider for the associated map tiles.</p>
        pub fn set_data_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_source = input;
            self
        }
        /// <p>Specifies the map tile style selected from a partner data provider.</p>
        pub fn configuration(mut self, input: crate::model::MapConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>Specifies the map tile style selected from a partner data provider.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::MapConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The optional description for the map resource.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The optional description for the map resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags associated with the map resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags associated with the map resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The timestamp for when the map resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp for when the map resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The timestamp for when the map resource was last update in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>The timestamp for when the map resource was last update in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>.</p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMapOutput`](crate::output::DescribeMapOutput)
        pub fn build(self) -> crate::output::DescribeMapOutput {
            crate::output::DescribeMapOutput {
                map_name: self.map_name,
                map_arn: self.map_arn,
                pricing_plan: self.pricing_plan,
                data_source: self.data_source,
                configuration: self.configuration,
                description: self.description,
                tags: self.tags,
                create_time: self.create_time,
                update_time: self.update_time,
            }
        }
    }
}
impl DescribeMapOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMapOutput`](crate::output::DescribeMapOutput)
    pub fn builder() -> crate::output::describe_map_output::Builder {
        crate::output::describe_map_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutGeofenceOutput {
    /// <p>The geofence identifier entered in the request.</p>
    pub geofence_id: std::option::Option<std::string::String>,
    /// <p>The timestamp for when the geofence was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp for when the geofence was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl PutGeofenceOutput {
    /// <p>The geofence identifier entered in the request.</p>
    pub fn geofence_id(&self) -> std::option::Option<&str> {
        self.geofence_id.as_deref()
    }
    /// <p>The timestamp for when the geofence was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
    /// <p>The timestamp for when the geofence was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
}
impl std::fmt::Debug for PutGeofenceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutGeofenceOutput");
        formatter.field("geofence_id", &self.geofence_id);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`PutGeofenceOutput`](crate::output::PutGeofenceOutput)
pub mod put_geofence_output {
    /// A builder for [`PutGeofenceOutput`](crate::output::PutGeofenceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) geofence_id: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The geofence identifier entered in the request.</p>
        pub fn geofence_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.geofence_id = Some(input.into());
            self
        }
        /// <p>The geofence identifier entered in the request.</p>
        pub fn set_geofence_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.geofence_id = input;
            self
        }
        /// <p>The timestamp for when the geofence was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp for when the geofence was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The timestamp for when the geofence was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>The timestamp for when the geofence was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`PutGeofenceOutput`](crate::output::PutGeofenceOutput)
        pub fn build(self) -> crate::output::PutGeofenceOutput {
            crate::output::PutGeofenceOutput {
                geofence_id: self.geofence_id,
                create_time: self.create_time,
                update_time: self.update_time,
            }
        }
    }
}
impl PutGeofenceOutput {
    /// Creates a new builder-style object to manufacture [`PutGeofenceOutput`](crate::output::PutGeofenceOutput)
    pub fn builder() -> crate::output::put_geofence_output::Builder {
        crate::output::put_geofence_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGeofencesOutput {
    /// <p>Contains a list of geofences stored in the geofence collection.</p>
    pub entries: std::option::Option<std::vec::Vec<crate::model::ListGeofenceResponseEntry>>,
    /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListGeofencesOutput {
    /// <p>Contains a list of geofences stored in the geofence collection.</p>
    pub fn entries(&self) -> std::option::Option<&[crate::model::ListGeofenceResponseEntry]> {
        self.entries.as_deref()
    }
    /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListGeofencesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGeofencesOutput");
        formatter.field("entries", &self.entries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListGeofencesOutput`](crate::output::ListGeofencesOutput)
pub mod list_geofences_output {
    /// A builder for [`ListGeofencesOutput`](crate::output::ListGeofencesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entries:
            std::option::Option<std::vec::Vec<crate::model::ListGeofenceResponseEntry>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>Contains a list of geofences stored in the geofence collection.</p>
        pub fn entries(mut self, input: crate::model::ListGeofenceResponseEntry) -> Self {
            let mut v = self.entries.unwrap_or_default();
            v.push(input);
            self.entries = Some(v);
            self
        }
        /// <p>Contains a list of geofences stored in the geofence collection.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListGeofenceResponseEntry>>,
        ) -> Self {
            self.entries = input;
            self
        }
        /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGeofencesOutput`](crate::output::ListGeofencesOutput)
        pub fn build(self) -> crate::output::ListGeofencesOutput {
            crate::output::ListGeofencesOutput {
                entries: self.entries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListGeofencesOutput {
    /// Creates a new builder-style object to manufacture [`ListGeofencesOutput`](crate::output::ListGeofencesOutput)
    pub fn builder() -> crate::output::list_geofences_output::Builder {
        crate::output::list_geofences_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGeofenceOutput {
    /// <p>The geofence identifier.</p>
    pub geofence_id: std::option::Option<std::string::String>,
    /// <p>Contains the geofence geometry details describing a polygon.</p>
    pub geometry: std::option::Option<crate::model::GeofenceGeometry>,
    /// <p>Identifies the state of the geofence. A geofence will hold one of the following states:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> — The geofence has been indexed by the system. </p> </li>
    /// <li> <p> <code>PENDING</code> — The geofence is being processed by the system.</p> </li>
    /// <li> <p> <code>FAILED</code> — The geofence failed to be indexed by the system.</p> </li>
    /// <li> <p> <code>DELETED</code> — The geofence has been deleted from the system index.</p> </li>
    /// <li> <p> <code>DELETING</code> — The geofence is being deleted from the system index.</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The timestamp for when the geofence collection was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp for when the geofence collection was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetGeofenceOutput {
    /// <p>The geofence identifier.</p>
    pub fn geofence_id(&self) -> std::option::Option<&str> {
        self.geofence_id.as_deref()
    }
    /// <p>Contains the geofence geometry details describing a polygon.</p>
    pub fn geometry(&self) -> std::option::Option<&crate::model::GeofenceGeometry> {
        self.geometry.as_ref()
    }
    /// <p>Identifies the state of the geofence. A geofence will hold one of the following states:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> — The geofence has been indexed by the system. </p> </li>
    /// <li> <p> <code>PENDING</code> — The geofence is being processed by the system.</p> </li>
    /// <li> <p> <code>FAILED</code> — The geofence failed to be indexed by the system.</p> </li>
    /// <li> <p> <code>DELETED</code> — The geofence has been deleted from the system index.</p> </li>
    /// <li> <p> <code>DELETING</code> — The geofence is being deleted from the system index.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The timestamp for when the geofence collection was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
    /// <p>The timestamp for when the geofence collection was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
}
impl std::fmt::Debug for GetGeofenceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGeofenceOutput");
        formatter.field("geofence_id", &self.geofence_id);
        formatter.field("geometry", &self.geometry);
        formatter.field("status", &self.status);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`GetGeofenceOutput`](crate::output::GetGeofenceOutput)
pub mod get_geofence_output {
    /// A builder for [`GetGeofenceOutput`](crate::output::GetGeofenceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) geofence_id: std::option::Option<std::string::String>,
        pub(crate) geometry: std::option::Option<crate::model::GeofenceGeometry>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The geofence identifier.</p>
        pub fn geofence_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.geofence_id = Some(input.into());
            self
        }
        /// <p>The geofence identifier.</p>
        pub fn set_geofence_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.geofence_id = input;
            self
        }
        /// <p>Contains the geofence geometry details describing a polygon.</p>
        pub fn geometry(mut self, input: crate::model::GeofenceGeometry) -> Self {
            self.geometry = Some(input);
            self
        }
        /// <p>Contains the geofence geometry details describing a polygon.</p>
        pub fn set_geometry(
            mut self,
            input: std::option::Option<crate::model::GeofenceGeometry>,
        ) -> Self {
            self.geometry = input;
            self
        }
        /// <p>Identifies the state of the geofence. A geofence will hold one of the following states:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> — The geofence has been indexed by the system. </p> </li>
        /// <li> <p> <code>PENDING</code> — The geofence is being processed by the system.</p> </li>
        /// <li> <p> <code>FAILED</code> — The geofence failed to be indexed by the system.</p> </li>
        /// <li> <p> <code>DELETED</code> — The geofence has been deleted from the system index.</p> </li>
        /// <li> <p> <code>DELETING</code> — The geofence is being deleted from the system index.</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Identifies the state of the geofence. A geofence will hold one of the following states:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> — The geofence has been indexed by the system. </p> </li>
        /// <li> <p> <code>PENDING</code> — The geofence is being processed by the system.</p> </li>
        /// <li> <p> <code>FAILED</code> — The geofence failed to be indexed by the system.</p> </li>
        /// <li> <p> <code>DELETED</code> — The geofence has been deleted from the system index.</p> </li>
        /// <li> <p> <code>DELETING</code> — The geofence is being deleted from the system index.</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The timestamp for when the geofence collection was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp for when the geofence collection was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The timestamp for when the geofence collection was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>The timestamp for when the geofence collection was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGeofenceOutput`](crate::output::GetGeofenceOutput)
        pub fn build(self) -> crate::output::GetGeofenceOutput {
            crate::output::GetGeofenceOutput {
                geofence_id: self.geofence_id,
                geometry: self.geometry,
                status: self.status,
                create_time: self.create_time,
                update_time: self.update_time,
            }
        }
    }
}
impl GetGeofenceOutput {
    /// Creates a new builder-style object to manufacture [`GetGeofenceOutput`](crate::output::GetGeofenceOutput)
    pub fn builder() -> crate::output::get_geofence_output::Builder {
        crate::output::get_geofence_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchPutGeofenceOutput {
    /// <p>Contains each geofence that was successfully stored in a geofence collection.</p>
    pub successes: std::option::Option<std::vec::Vec<crate::model::BatchPutGeofenceSuccess>>,
    /// <p>Contains additional error details for each geofence that failed to be stored in a geofence collection.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::BatchPutGeofenceError>>,
}
impl BatchPutGeofenceOutput {
    /// <p>Contains each geofence that was successfully stored in a geofence collection.</p>
    pub fn successes(&self) -> std::option::Option<&[crate::model::BatchPutGeofenceSuccess]> {
        self.successes.as_deref()
    }
    /// <p>Contains additional error details for each geofence that failed to be stored in a geofence collection.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::BatchPutGeofenceError]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchPutGeofenceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchPutGeofenceOutput");
        formatter.field("successes", &self.successes);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchPutGeofenceOutput`](crate::output::BatchPutGeofenceOutput)
pub mod batch_put_geofence_output {
    /// A builder for [`BatchPutGeofenceOutput`](crate::output::BatchPutGeofenceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) successes:
            std::option::Option<std::vec::Vec<crate::model::BatchPutGeofenceSuccess>>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::BatchPutGeofenceError>>,
    }
    impl Builder {
        /// Appends an item to `successes`.
        ///
        /// To override the contents of this collection use [`set_successes`](Self::set_successes).
        ///
        /// <p>Contains each geofence that was successfully stored in a geofence collection.</p>
        pub fn successes(mut self, input: crate::model::BatchPutGeofenceSuccess) -> Self {
            let mut v = self.successes.unwrap_or_default();
            v.push(input);
            self.successes = Some(v);
            self
        }
        /// <p>Contains each geofence that was successfully stored in a geofence collection.</p>
        pub fn set_successes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchPutGeofenceSuccess>>,
        ) -> Self {
            self.successes = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>Contains additional error details for each geofence that failed to be stored in a geofence collection.</p>
        pub fn errors(mut self, input: crate::model::BatchPutGeofenceError) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input);
            self.errors = Some(v);
            self
        }
        /// <p>Contains additional error details for each geofence that failed to be stored in a geofence collection.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchPutGeofenceError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchPutGeofenceOutput`](crate::output::BatchPutGeofenceOutput)
        pub fn build(self) -> crate::output::BatchPutGeofenceOutput {
            crate::output::BatchPutGeofenceOutput {
                successes: self.successes,
                errors: self.errors,
            }
        }
    }
}
impl BatchPutGeofenceOutput {
    /// Creates a new builder-style object to manufacture [`BatchPutGeofenceOutput`](crate::output::BatchPutGeofenceOutput)
    pub fn builder() -> crate::output::batch_put_geofence_output::Builder {
        crate::output::batch_put_geofence_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchEvaluateGeofencesOutput {
    /// <p>Contains error details for each device that failed to evaluate its position against the given geofence collection.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::BatchEvaluateGeofencesError>>,
}
impl BatchEvaluateGeofencesOutput {
    /// <p>Contains error details for each device that failed to evaluate its position against the given geofence collection.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::BatchEvaluateGeofencesError]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchEvaluateGeofencesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchEvaluateGeofencesOutput");
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchEvaluateGeofencesOutput`](crate::output::BatchEvaluateGeofencesOutput)
pub mod batch_evaluate_geofences_output {
    /// A builder for [`BatchEvaluateGeofencesOutput`](crate::output::BatchEvaluateGeofencesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) errors:
            std::option::Option<std::vec::Vec<crate::model::BatchEvaluateGeofencesError>>,
    }
    impl Builder {
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>Contains error details for each device that failed to evaluate its position against the given geofence collection.</p>
        pub fn errors(mut self, input: crate::model::BatchEvaluateGeofencesError) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input);
            self.errors = Some(v);
            self
        }
        /// <p>Contains error details for each device that failed to evaluate its position against the given geofence collection.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchEvaluateGeofencesError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchEvaluateGeofencesOutput`](crate::output::BatchEvaluateGeofencesOutput)
        pub fn build(self) -> crate::output::BatchEvaluateGeofencesOutput {
            crate::output::BatchEvaluateGeofencesOutput {
                errors: self.errors,
            }
        }
    }
}
impl BatchEvaluateGeofencesOutput {
    /// Creates a new builder-style object to manufacture [`BatchEvaluateGeofencesOutput`](crate::output::BatchEvaluateGeofencesOutput)
    pub fn builder() -> crate::output::batch_evaluate_geofences_output::Builder {
        crate::output::batch_evaluate_geofences_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteGeofenceOutput {
    /// <p>Contains error details for each geofence that failed to delete.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::BatchDeleteGeofenceError>>,
}
impl BatchDeleteGeofenceOutput {
    /// <p>Contains error details for each geofence that failed to delete.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::BatchDeleteGeofenceError]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchDeleteGeofenceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteGeofenceOutput");
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchDeleteGeofenceOutput`](crate::output::BatchDeleteGeofenceOutput)
pub mod batch_delete_geofence_output {
    /// A builder for [`BatchDeleteGeofenceOutput`](crate::output::BatchDeleteGeofenceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) errors:
            std::option::Option<std::vec::Vec<crate::model::BatchDeleteGeofenceError>>,
    }
    impl Builder {
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>Contains error details for each geofence that failed to delete.</p>
        pub fn errors(mut self, input: crate::model::BatchDeleteGeofenceError) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input);
            self.errors = Some(v);
            self
        }
        /// <p>Contains error details for each geofence that failed to delete.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchDeleteGeofenceError>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteGeofenceOutput`](crate::output::BatchDeleteGeofenceOutput)
        pub fn build(self) -> crate::output::BatchDeleteGeofenceOutput {
            crate::output::BatchDeleteGeofenceOutput {
                errors: self.errors,
            }
        }
    }
}
impl BatchDeleteGeofenceOutput {
    /// Creates a new builder-style object to manufacture [`BatchDeleteGeofenceOutput`](crate::output::BatchDeleteGeofenceOutput)
    pub fn builder() -> crate::output::batch_delete_geofence_output::Builder {
        crate::output::batch_delete_geofence_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListGeofenceCollectionsOutput {
    /// <p>Lists the geofence collections that exist in your AWS account.</p>
    pub entries:
        std::option::Option<std::vec::Vec<crate::model::ListGeofenceCollectionsResponseEntry>>,
    /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListGeofenceCollectionsOutput {
    /// <p>Lists the geofence collections that exist in your AWS account.</p>
    pub fn entries(
        &self,
    ) -> std::option::Option<&[crate::model::ListGeofenceCollectionsResponseEntry]> {
        self.entries.as_deref()
    }
    /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListGeofenceCollectionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListGeofenceCollectionsOutput");
        formatter.field("entries", &self.entries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListGeofenceCollectionsOutput`](crate::output::ListGeofenceCollectionsOutput)
pub mod list_geofence_collections_output {
    /// A builder for [`ListGeofenceCollectionsOutput`](crate::output::ListGeofenceCollectionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entries:
            std::option::Option<std::vec::Vec<crate::model::ListGeofenceCollectionsResponseEntry>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>Lists the geofence collections that exist in your AWS account.</p>
        pub fn entries(
            mut self,
            input: crate::model::ListGeofenceCollectionsResponseEntry,
        ) -> Self {
            let mut v = self.entries.unwrap_or_default();
            v.push(input);
            self.entries = Some(v);
            self
        }
        /// <p>Lists the geofence collections that exist in your AWS account.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ListGeofenceCollectionsResponseEntry>,
            >,
        ) -> Self {
            self.entries = input;
            self
        }
        /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>A pagination token indicating there are additional pages available. You can use the token in a following request to fetch the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListGeofenceCollectionsOutput`](crate::output::ListGeofenceCollectionsOutput)
        pub fn build(self) -> crate::output::ListGeofenceCollectionsOutput {
            crate::output::ListGeofenceCollectionsOutput {
                entries: self.entries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListGeofenceCollectionsOutput {
    /// Creates a new builder-style object to manufacture [`ListGeofenceCollectionsOutput`](crate::output::ListGeofenceCollectionsOutput)
    pub fn builder() -> crate::output::list_geofence_collections_output::Builder {
        crate::output::list_geofence_collections_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGeofenceCollectionOutput {
    /// <p>The name for the geofence collection.</p>
    pub collection_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a resource across all AWS. </p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code> </p> </li>
    /// </ul>
    pub collection_arn: std::option::Option<std::string::String>,
    /// <p>The timestamp for when the geofence collection was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateGeofenceCollectionOutput {
    /// <p>The name for the geofence collection.</p>
    pub fn collection_name(&self) -> std::option::Option<&str> {
        self.collection_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a resource across all AWS. </p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code> </p> </li>
    /// </ul>
    pub fn collection_arn(&self) -> std::option::Option<&str> {
        self.collection_arn.as_deref()
    }
    /// <p>The timestamp for when the geofence collection was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
}
impl std::fmt::Debug for CreateGeofenceCollectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGeofenceCollectionOutput");
        formatter.field("collection_name", &self.collection_name);
        formatter.field("collection_arn", &self.collection_arn);
        formatter.field("create_time", &self.create_time);
        formatter.finish()
    }
}
/// See [`CreateGeofenceCollectionOutput`](crate::output::CreateGeofenceCollectionOutput)
pub mod create_geofence_collection_output {
    /// A builder for [`CreateGeofenceCollectionOutput`](crate::output::CreateGeofenceCollectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) collection_name: std::option::Option<std::string::String>,
        pub(crate) collection_arn: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name for the geofence collection.</p>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.collection_name = Some(input.into());
            self
        }
        /// <p>The name for the geofence collection.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.collection_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a resource across all AWS. </p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code> </p> </li>
        /// </ul>
        pub fn collection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.collection_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a resource across all AWS. </p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code> </p> </li>
        /// </ul>
        pub fn set_collection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.collection_arn = input;
            self
        }
        /// <p>The timestamp for when the geofence collection was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp for when the geofence collection was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGeofenceCollectionOutput`](crate::output::CreateGeofenceCollectionOutput)
        pub fn build(self) -> crate::output::CreateGeofenceCollectionOutput {
            crate::output::CreateGeofenceCollectionOutput {
                collection_name: self.collection_name,
                collection_arn: self.collection_arn,
                create_time: self.create_time,
            }
        }
    }
}
impl CreateGeofenceCollectionOutput {
    /// Creates a new builder-style object to manufacture [`CreateGeofenceCollectionOutput`](crate::output::CreateGeofenceCollectionOutput)
    pub fn builder() -> crate::output::create_geofence_collection_output::Builder {
        crate::output::create_geofence_collection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGeofenceCollectionOutput {}
impl std::fmt::Debug for DeleteGeofenceCollectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGeofenceCollectionOutput");
        formatter.finish()
    }
}
/// See [`DeleteGeofenceCollectionOutput`](crate::output::DeleteGeofenceCollectionOutput)
pub mod delete_geofence_collection_output {
    /// A builder for [`DeleteGeofenceCollectionOutput`](crate::output::DeleteGeofenceCollectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteGeofenceCollectionOutput`](crate::output::DeleteGeofenceCollectionOutput)
        pub fn build(self) -> crate::output::DeleteGeofenceCollectionOutput {
            crate::output::DeleteGeofenceCollectionOutput {}
        }
    }
}
impl DeleteGeofenceCollectionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteGeofenceCollectionOutput`](crate::output::DeleteGeofenceCollectionOutput)
    pub fn builder() -> crate::output::delete_geofence_collection_output::Builder {
        crate::output::delete_geofence_collection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateGeofenceCollectionOutput {
    /// <p>The name of the updated geofence collection.</p>
    pub collection_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the updated geofence collection. Used to specify a resource across AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code> </p> </li>
    /// </ul>
    pub collection_arn: std::option::Option<std::string::String>,
    /// <p>The time when the geofence collection was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl UpdateGeofenceCollectionOutput {
    /// <p>The name of the updated geofence collection.</p>
    pub fn collection_name(&self) -> std::option::Option<&str> {
        self.collection_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the updated geofence collection. Used to specify a resource across AWS.</p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code> </p> </li>
    /// </ul>
    pub fn collection_arn(&self) -> std::option::Option<&str> {
        self.collection_arn.as_deref()
    }
    /// <p>The time when the geofence collection was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
}
impl std::fmt::Debug for UpdateGeofenceCollectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateGeofenceCollectionOutput");
        formatter.field("collection_name", &self.collection_name);
        formatter.field("collection_arn", &self.collection_arn);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`UpdateGeofenceCollectionOutput`](crate::output::UpdateGeofenceCollectionOutput)
pub mod update_geofence_collection_output {
    /// A builder for [`UpdateGeofenceCollectionOutput`](crate::output::UpdateGeofenceCollectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) collection_name: std::option::Option<std::string::String>,
        pub(crate) collection_arn: std::option::Option<std::string::String>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the updated geofence collection.</p>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.collection_name = Some(input.into());
            self
        }
        /// <p>The name of the updated geofence collection.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.collection_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the updated geofence collection. Used to specify a resource across AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code> </p> </li>
        /// </ul>
        pub fn collection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.collection_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the updated geofence collection. Used to specify a resource across AWS.</p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code> </p> </li>
        /// </ul>
        pub fn set_collection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.collection_arn = input;
            self
        }
        /// <p>The time when the geofence collection was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>The time when the geofence collection was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateGeofenceCollectionOutput`](crate::output::UpdateGeofenceCollectionOutput)
        pub fn build(self) -> crate::output::UpdateGeofenceCollectionOutput {
            crate::output::UpdateGeofenceCollectionOutput {
                collection_name: self.collection_name,
                collection_arn: self.collection_arn,
                update_time: self.update_time,
            }
        }
    }
}
impl UpdateGeofenceCollectionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateGeofenceCollectionOutput`](crate::output::UpdateGeofenceCollectionOutput)
    pub fn builder() -> crate::output::update_geofence_collection_output::Builder {
        crate::output::update_geofence_collection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGeofenceCollectionOutput {
    /// <p>The name of the geofence collection.</p>
    pub collection_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a resource across all AWS. </p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code> </p> </li>
    /// </ul>
    pub collection_arn: std::option::Option<std::string::String>,
    /// <p>The optional description for the geofence collection.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
    pub pricing_plan: std::option::Option<crate::model::PricingPlan>,
    /// <p>No longer used. Always returns an empty string.</p>
    pub pricing_plan_data_source: std::option::Option<std::string::String>,
    /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a> assigned to the Amazon Location resource</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>Displays the key, value pairs of tags associated with this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The timestamp for when the geofence resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The timestamp for when the geofence collection was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub update_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DescribeGeofenceCollectionOutput {
    /// <p>The name of the geofence collection.</p>
    pub fn collection_name(&self) -> std::option::Option<&str> {
        self.collection_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a resource across all AWS. </p>
    /// <ul>
    /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code> </p> </li>
    /// </ul>
    pub fn collection_arn(&self) -> std::option::Option<&str> {
        self.collection_arn.as_deref()
    }
    /// <p>The optional description for the geofence collection.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
    pub fn pricing_plan(&self) -> std::option::Option<&crate::model::PricingPlan> {
        self.pricing_plan.as_ref()
    }
    /// <p>No longer used. Always returns an empty string.</p>
    pub fn pricing_plan_data_source(&self) -> std::option::Option<&str> {
        self.pricing_plan_data_source.as_deref()
    }
    /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a> assigned to the Amazon Location resource</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>Displays the key, value pairs of tags associated with this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The timestamp for when the geofence resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.create_time.as_ref()
    }
    /// <p>The timestamp for when the geofence collection was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
    pub fn update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.update_time.as_ref()
    }
}
impl std::fmt::Debug for DescribeGeofenceCollectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGeofenceCollectionOutput");
        formatter.field("collection_name", &self.collection_name);
        formatter.field("collection_arn", &self.collection_arn);
        formatter.field("description", &self.description);
        formatter.field("pricing_plan", &self.pricing_plan);
        formatter.field("pricing_plan_data_source", &self.pricing_plan_data_source);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("tags", &self.tags);
        formatter.field("create_time", &self.create_time);
        formatter.field("update_time", &self.update_time);
        formatter.finish()
    }
}
/// See [`DescribeGeofenceCollectionOutput`](crate::output::DescribeGeofenceCollectionOutput)
pub mod describe_geofence_collection_output {
    /// A builder for [`DescribeGeofenceCollectionOutput`](crate::output::DescribeGeofenceCollectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) collection_name: std::option::Option<std::string::String>,
        pub(crate) collection_arn: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) pricing_plan: std::option::Option<crate::model::PricingPlan>,
        pub(crate) pricing_plan_data_source: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) update_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the geofence collection.</p>
        pub fn collection_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.collection_name = Some(input.into());
            self
        }
        /// <p>The name of the geofence collection.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.collection_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a resource across all AWS. </p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code> </p> </li>
        /// </ul>
        pub fn collection_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.collection_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the geofence collection resource. Used when you need to specify a resource across all AWS. </p>
        /// <ul>
        /// <li> <p>Format example: <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollection</code> </p> </li>
        /// </ul>
        pub fn set_collection_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.collection_arn = input;
            self
        }
        /// <p>The optional description for the geofence collection.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The optional description for the geofence collection.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.pricing_plan = Some(input);
            self
        }
        /// <p>No longer used. Always returns <code>RequestBasedUsage</code>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.pricing_plan = input;
            self
        }
        /// <p>No longer used. Always returns an empty string.</p>
        pub fn pricing_plan_data_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.pricing_plan_data_source = Some(input.into());
            self
        }
        /// <p>No longer used. Always returns an empty string.</p>
        pub fn set_pricing_plan_data_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pricing_plan_data_source = input;
            self
        }
        /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a> assigned to the Amazon Location resource</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a> assigned to the Amazon Location resource</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Displays the key, value pairs of tags associated with this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Displays the key, value pairs of tags associated with this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The timestamp for when the geofence resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The timestamp for when the geofence resource was created in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// <p>The timestamp for when the geofence collection was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.update_time = Some(input);
            self
        }
        /// <p>The timestamp for when the geofence collection was last updated in <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code> </p>
        pub fn set_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.update_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGeofenceCollectionOutput`](crate::output::DescribeGeofenceCollectionOutput)
        pub fn build(self) -> crate::output::DescribeGeofenceCollectionOutput {
            crate::output::DescribeGeofenceCollectionOutput {
                collection_name: self.collection_name,
                collection_arn: self.collection_arn,
                description: self.description,
                pricing_plan: self.pricing_plan,
                pricing_plan_data_source: self.pricing_plan_data_source,
                kms_key_id: self.kms_key_id,
                tags: self.tags,
                create_time: self.create_time,
                update_time: self.update_time,
            }
        }
    }
}
impl DescribeGeofenceCollectionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeGeofenceCollectionOutput`](crate::output::DescribeGeofenceCollectionOutput)
    pub fn builder() -> crate::output::describe_geofence_collection_output::Builder {
        crate::output::describe_geofence_collection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>Tags that have been applied to the specified resource. Tags are mapped from the tag key to the tag value: <code>"TagKey" : "TagValue"</code>.</p>
    /// <ul>
    /// <li> <p>Format example: <code>{"tag1" : "value1", "tag2" : "value2"} </code> </p> </li>
    /// </ul>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>Tags that have been applied to the specified resource. Tags are mapped from the tag key to the tag value: <code>"TagKey" : "TagValue"</code>.</p>
    /// <ul>
    /// <li> <p>Format example: <code>{"tag1" : "value1", "tag2" : "value2"} </code> </p> </li>
    /// </ul>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags that have been applied to the specified resource. Tags are mapped from the tag key to the tag value: <code>"TagKey" : "TagValue"</code>.</p>
        /// <ul>
        /// <li> <p>Format example: <code>{"tag1" : "value1", "tag2" : "value2"} </code> </p> </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags that have been applied to the specified resource. Tags are mapped from the tag key to the tag value: <code>"TagKey" : "TagValue"</code>.</p>
        /// <ul>
        /// <li> <p>Format example: <code>{"tag1" : "value1", "tag2" : "value2"} </code> </p> </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}
