// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `LocationService`.
///
/// This client allows ergonomic access to a `LocationService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateTrackerConsumer` operation.
    ///
    /// See [`AssociateTrackerConsumer`](crate::client::fluent_builders::AssociateTrackerConsumer) for more information about the
    /// operation and its arguments.
    pub fn associate_tracker_consumer(&self) -> fluent_builders::AssociateTrackerConsumer<C, M, R> {
        fluent_builders::AssociateTrackerConsumer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDeleteDevicePositionHistory` operation.
    ///
    /// See [`BatchDeleteDevicePositionHistory`](crate::client::fluent_builders::BatchDeleteDevicePositionHistory) for more information about the
    /// operation and its arguments.
    pub fn batch_delete_device_position_history(
        &self,
    ) -> fluent_builders::BatchDeleteDevicePositionHistory<C, M, R> {
        fluent_builders::BatchDeleteDevicePositionHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDeleteGeofence` operation.
    ///
    /// See [`BatchDeleteGeofence`](crate::client::fluent_builders::BatchDeleteGeofence) for more information about the
    /// operation and its arguments.
    pub fn batch_delete_geofence(&self) -> fluent_builders::BatchDeleteGeofence<C, M, R> {
        fluent_builders::BatchDeleteGeofence::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchEvaluateGeofences` operation.
    ///
    /// See [`BatchEvaluateGeofences`](crate::client::fluent_builders::BatchEvaluateGeofences) for more information about the
    /// operation and its arguments.
    pub fn batch_evaluate_geofences(&self) -> fluent_builders::BatchEvaluateGeofences<C, M, R> {
        fluent_builders::BatchEvaluateGeofences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetDevicePosition` operation.
    ///
    /// See [`BatchGetDevicePosition`](crate::client::fluent_builders::BatchGetDevicePosition) for more information about the
    /// operation and its arguments.
    pub fn batch_get_device_position(&self) -> fluent_builders::BatchGetDevicePosition<C, M, R> {
        fluent_builders::BatchGetDevicePosition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchPutGeofence` operation.
    ///
    /// See [`BatchPutGeofence`](crate::client::fluent_builders::BatchPutGeofence) for more information about the
    /// operation and its arguments.
    pub fn batch_put_geofence(&self) -> fluent_builders::BatchPutGeofence<C, M, R> {
        fluent_builders::BatchPutGeofence::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchUpdateDevicePosition` operation.
    ///
    /// See [`BatchUpdateDevicePosition`](crate::client::fluent_builders::BatchUpdateDevicePosition) for more information about the
    /// operation and its arguments.
    pub fn batch_update_device_position(
        &self,
    ) -> fluent_builders::BatchUpdateDevicePosition<C, M, R> {
        fluent_builders::BatchUpdateDevicePosition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CalculateRoute` operation.
    ///
    /// See [`CalculateRoute`](crate::client::fluent_builders::CalculateRoute) for more information about the
    /// operation and its arguments.
    pub fn calculate_route(&self) -> fluent_builders::CalculateRoute<C, M, R> {
        fluent_builders::CalculateRoute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateGeofenceCollection` operation.
    ///
    /// See [`CreateGeofenceCollection`](crate::client::fluent_builders::CreateGeofenceCollection) for more information about the
    /// operation and its arguments.
    pub fn create_geofence_collection(&self) -> fluent_builders::CreateGeofenceCollection<C, M, R> {
        fluent_builders::CreateGeofenceCollection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMap` operation.
    ///
    /// See [`CreateMap`](crate::client::fluent_builders::CreateMap) for more information about the
    /// operation and its arguments.
    pub fn create_map(&self) -> fluent_builders::CreateMap<C, M, R> {
        fluent_builders::CreateMap::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePlaceIndex` operation.
    ///
    /// See [`CreatePlaceIndex`](crate::client::fluent_builders::CreatePlaceIndex) for more information about the
    /// operation and its arguments.
    pub fn create_place_index(&self) -> fluent_builders::CreatePlaceIndex<C, M, R> {
        fluent_builders::CreatePlaceIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRouteCalculator` operation.
    ///
    /// See [`CreateRouteCalculator`](crate::client::fluent_builders::CreateRouteCalculator) for more information about the
    /// operation and its arguments.
    pub fn create_route_calculator(&self) -> fluent_builders::CreateRouteCalculator<C, M, R> {
        fluent_builders::CreateRouteCalculator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTracker` operation.
    ///
    /// See [`CreateTracker`](crate::client::fluent_builders::CreateTracker) for more information about the
    /// operation and its arguments.
    pub fn create_tracker(&self) -> fluent_builders::CreateTracker<C, M, R> {
        fluent_builders::CreateTracker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteGeofenceCollection` operation.
    ///
    /// See [`DeleteGeofenceCollection`](crate::client::fluent_builders::DeleteGeofenceCollection) for more information about the
    /// operation and its arguments.
    pub fn delete_geofence_collection(&self) -> fluent_builders::DeleteGeofenceCollection<C, M, R> {
        fluent_builders::DeleteGeofenceCollection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMap` operation.
    ///
    /// See [`DeleteMap`](crate::client::fluent_builders::DeleteMap) for more information about the
    /// operation and its arguments.
    pub fn delete_map(&self) -> fluent_builders::DeleteMap<C, M, R> {
        fluent_builders::DeleteMap::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePlaceIndex` operation.
    ///
    /// See [`DeletePlaceIndex`](crate::client::fluent_builders::DeletePlaceIndex) for more information about the
    /// operation and its arguments.
    pub fn delete_place_index(&self) -> fluent_builders::DeletePlaceIndex<C, M, R> {
        fluent_builders::DeletePlaceIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRouteCalculator` operation.
    ///
    /// See [`DeleteRouteCalculator`](crate::client::fluent_builders::DeleteRouteCalculator) for more information about the
    /// operation and its arguments.
    pub fn delete_route_calculator(&self) -> fluent_builders::DeleteRouteCalculator<C, M, R> {
        fluent_builders::DeleteRouteCalculator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTracker` operation.
    ///
    /// See [`DeleteTracker`](crate::client::fluent_builders::DeleteTracker) for more information about the
    /// operation and its arguments.
    pub fn delete_tracker(&self) -> fluent_builders::DeleteTracker<C, M, R> {
        fluent_builders::DeleteTracker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeGeofenceCollection` operation.
    ///
    /// See [`DescribeGeofenceCollection`](crate::client::fluent_builders::DescribeGeofenceCollection) for more information about the
    /// operation and its arguments.
    pub fn describe_geofence_collection(
        &self,
    ) -> fluent_builders::DescribeGeofenceCollection<C, M, R> {
        fluent_builders::DescribeGeofenceCollection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMap` operation.
    ///
    /// See [`DescribeMap`](crate::client::fluent_builders::DescribeMap) for more information about the
    /// operation and its arguments.
    pub fn describe_map(&self) -> fluent_builders::DescribeMap<C, M, R> {
        fluent_builders::DescribeMap::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePlaceIndex` operation.
    ///
    /// See [`DescribePlaceIndex`](crate::client::fluent_builders::DescribePlaceIndex) for more information about the
    /// operation and its arguments.
    pub fn describe_place_index(&self) -> fluent_builders::DescribePlaceIndex<C, M, R> {
        fluent_builders::DescribePlaceIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRouteCalculator` operation.
    ///
    /// See [`DescribeRouteCalculator`](crate::client::fluent_builders::DescribeRouteCalculator) for more information about the
    /// operation and its arguments.
    pub fn describe_route_calculator(&self) -> fluent_builders::DescribeRouteCalculator<C, M, R> {
        fluent_builders::DescribeRouteCalculator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTracker` operation.
    ///
    /// See [`DescribeTracker`](crate::client::fluent_builders::DescribeTracker) for more information about the
    /// operation and its arguments.
    pub fn describe_tracker(&self) -> fluent_builders::DescribeTracker<C, M, R> {
        fluent_builders::DescribeTracker::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateTrackerConsumer` operation.
    ///
    /// See [`DisassociateTrackerConsumer`](crate::client::fluent_builders::DisassociateTrackerConsumer) for more information about the
    /// operation and its arguments.
    pub fn disassociate_tracker_consumer(
        &self,
    ) -> fluent_builders::DisassociateTrackerConsumer<C, M, R> {
        fluent_builders::DisassociateTrackerConsumer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDevicePosition` operation.
    ///
    /// See [`GetDevicePosition`](crate::client::fluent_builders::GetDevicePosition) for more information about the
    /// operation and its arguments.
    pub fn get_device_position(&self) -> fluent_builders::GetDevicePosition<C, M, R> {
        fluent_builders::GetDevicePosition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDevicePositionHistory` operation.
    ///
    /// See [`GetDevicePositionHistory`](crate::client::fluent_builders::GetDevicePositionHistory) for more information about the
    /// operation and its arguments.
    pub fn get_device_position_history(
        &self,
    ) -> fluent_builders::GetDevicePositionHistory<C, M, R> {
        fluent_builders::GetDevicePositionHistory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGeofence` operation.
    ///
    /// See [`GetGeofence`](crate::client::fluent_builders::GetGeofence) for more information about the
    /// operation and its arguments.
    pub fn get_geofence(&self) -> fluent_builders::GetGeofence<C, M, R> {
        fluent_builders::GetGeofence::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMapGlyphs` operation.
    ///
    /// See [`GetMapGlyphs`](crate::client::fluent_builders::GetMapGlyphs) for more information about the
    /// operation and its arguments.
    pub fn get_map_glyphs(&self) -> fluent_builders::GetMapGlyphs<C, M, R> {
        fluent_builders::GetMapGlyphs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMapSprites` operation.
    ///
    /// See [`GetMapSprites`](crate::client::fluent_builders::GetMapSprites) for more information about the
    /// operation and its arguments.
    pub fn get_map_sprites(&self) -> fluent_builders::GetMapSprites<C, M, R> {
        fluent_builders::GetMapSprites::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMapStyleDescriptor` operation.
    ///
    /// See [`GetMapStyleDescriptor`](crate::client::fluent_builders::GetMapStyleDescriptor) for more information about the
    /// operation and its arguments.
    pub fn get_map_style_descriptor(&self) -> fluent_builders::GetMapStyleDescriptor<C, M, R> {
        fluent_builders::GetMapStyleDescriptor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMapTile` operation.
    ///
    /// See [`GetMapTile`](crate::client::fluent_builders::GetMapTile) for more information about the
    /// operation and its arguments.
    pub fn get_map_tile(&self) -> fluent_builders::GetMapTile<C, M, R> {
        fluent_builders::GetMapTile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDevicePositions` operation.
    ///
    /// See [`ListDevicePositions`](crate::client::fluent_builders::ListDevicePositions) for more information about the
    /// operation and its arguments.
    pub fn list_device_positions(&self) -> fluent_builders::ListDevicePositions<C, M, R> {
        fluent_builders::ListDevicePositions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGeofenceCollections` operation.
    ///
    /// See [`ListGeofenceCollections`](crate::client::fluent_builders::ListGeofenceCollections) for more information about the
    /// operation and its arguments.
    pub fn list_geofence_collections(&self) -> fluent_builders::ListGeofenceCollections<C, M, R> {
        fluent_builders::ListGeofenceCollections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListGeofences` operation.
    ///
    /// See [`ListGeofences`](crate::client::fluent_builders::ListGeofences) for more information about the
    /// operation and its arguments.
    pub fn list_geofences(&self) -> fluent_builders::ListGeofences<C, M, R> {
        fluent_builders::ListGeofences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMaps` operation.
    ///
    /// See [`ListMaps`](crate::client::fluent_builders::ListMaps) for more information about the
    /// operation and its arguments.
    pub fn list_maps(&self) -> fluent_builders::ListMaps<C, M, R> {
        fluent_builders::ListMaps::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPlaceIndexes` operation.
    ///
    /// See [`ListPlaceIndexes`](crate::client::fluent_builders::ListPlaceIndexes) for more information about the
    /// operation and its arguments.
    pub fn list_place_indexes(&self) -> fluent_builders::ListPlaceIndexes<C, M, R> {
        fluent_builders::ListPlaceIndexes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRouteCalculators` operation.
    ///
    /// See [`ListRouteCalculators`](crate::client::fluent_builders::ListRouteCalculators) for more information about the
    /// operation and its arguments.
    pub fn list_route_calculators(&self) -> fluent_builders::ListRouteCalculators<C, M, R> {
        fluent_builders::ListRouteCalculators::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTrackerConsumers` operation.
    ///
    /// See [`ListTrackerConsumers`](crate::client::fluent_builders::ListTrackerConsumers) for more information about the
    /// operation and its arguments.
    pub fn list_tracker_consumers(&self) -> fluent_builders::ListTrackerConsumers<C, M, R> {
        fluent_builders::ListTrackerConsumers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTrackers` operation.
    ///
    /// See [`ListTrackers`](crate::client::fluent_builders::ListTrackers) for more information about the
    /// operation and its arguments.
    pub fn list_trackers(&self) -> fluent_builders::ListTrackers<C, M, R> {
        fluent_builders::ListTrackers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutGeofence` operation.
    ///
    /// See [`PutGeofence`](crate::client::fluent_builders::PutGeofence) for more information about the
    /// operation and its arguments.
    pub fn put_geofence(&self) -> fluent_builders::PutGeofence<C, M, R> {
        fluent_builders::PutGeofence::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchPlaceIndexForPosition` operation.
    ///
    /// See [`SearchPlaceIndexForPosition`](crate::client::fluent_builders::SearchPlaceIndexForPosition) for more information about the
    /// operation and its arguments.
    pub fn search_place_index_for_position(
        &self,
    ) -> fluent_builders::SearchPlaceIndexForPosition<C, M, R> {
        fluent_builders::SearchPlaceIndexForPosition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchPlaceIndexForText` operation.
    ///
    /// See [`SearchPlaceIndexForText`](crate::client::fluent_builders::SearchPlaceIndexForText) for more information about the
    /// operation and its arguments.
    pub fn search_place_index_for_text(&self) -> fluent_builders::SearchPlaceIndexForText<C, M, R> {
        fluent_builders::SearchPlaceIndexForText::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateGeofenceCollection` operation.
    ///
    /// See [`UpdateGeofenceCollection`](crate::client::fluent_builders::UpdateGeofenceCollection) for more information about the
    /// operation and its arguments.
    pub fn update_geofence_collection(&self) -> fluent_builders::UpdateGeofenceCollection<C, M, R> {
        fluent_builders::UpdateGeofenceCollection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateMap` operation.
    ///
    /// See [`UpdateMap`](crate::client::fluent_builders::UpdateMap) for more information about the
    /// operation and its arguments.
    pub fn update_map(&self) -> fluent_builders::UpdateMap<C, M, R> {
        fluent_builders::UpdateMap::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePlaceIndex` operation.
    ///
    /// See [`UpdatePlaceIndex`](crate::client::fluent_builders::UpdatePlaceIndex) for more information about the
    /// operation and its arguments.
    pub fn update_place_index(&self) -> fluent_builders::UpdatePlaceIndex<C, M, R> {
        fluent_builders::UpdatePlaceIndex::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRouteCalculator` operation.
    ///
    /// See [`UpdateRouteCalculator`](crate::client::fluent_builders::UpdateRouteCalculator) for more information about the
    /// operation and its arguments.
    pub fn update_route_calculator(&self) -> fluent_builders::UpdateRouteCalculator<C, M, R> {
        fluent_builders::UpdateRouteCalculator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateTracker` operation.
    ///
    /// See [`UpdateTracker`](crate::client::fluent_builders::UpdateTracker) for more information about the
    /// operation and its arguments.
    pub fn update_tracker(&self) -> fluent_builders::UpdateTracker<C, M, R> {
        fluent_builders::UpdateTracker::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateTrackerConsumer`.
    ///
    /// <p>Creates an association between a geofence collection and a tracker resource. This
    /// allows the tracker resource to communicate location data to the linked geofence
    /// collection. </p>
    /// <p>You can associate up to five geofence collections to each tracker resource.</p>
    /// <note>
    /// <p>Currently not supported — Cross-account configurations, such as creating associations between a tracker resource in one account and a geofence collection in another account.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct AssociateTrackerConsumer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_tracker_consumer_input::Builder,
    }
    impl<C, M, R> AssociateTrackerConsumer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateTrackerConsumer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateTrackerConsumerOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateTrackerConsumerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateTrackerConsumerInputOperationOutputAlias,
                crate::output::AssociateTrackerConsumerOutput,
                crate::error::AssociateTrackerConsumerError,
                crate::input::AssociateTrackerConsumerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the tracker resource to be associated with a geofence collection.</p>
        pub fn tracker_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(inp);
            self
        }
        /// <p>The name of the tracker resource to be associated with a geofence collection.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker
        /// resource. Used when you need to specify a resource across all AWS.</p>
        /// <ul>
        /// <li>
        /// <p>Format example:
        /// <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn consumer_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.consumer_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the geofence collection to be associated to tracker
        /// resource. Used when you need to specify a resource across all AWS.</p>
        /// <ul>
        /// <li>
        /// <p>Format example:
        /// <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_consumer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_consumer_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDeleteDevicePositionHistory`.
    ///
    /// <p>Deletes the position history of one or more devices from a tracker resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDeleteDevicePositionHistory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_delete_device_position_history_input::Builder,
    }
    impl<C, M, R> BatchDeleteDevicePositionHistory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDeleteDevicePositionHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteDevicePositionHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteDevicePositionHistoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDeleteDevicePositionHistoryInputOperationOutputAlias,
                crate::output::BatchDeleteDevicePositionHistoryOutput,
                crate::error::BatchDeleteDevicePositionHistoryError,
                crate::input::BatchDeleteDevicePositionHistoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the tracker resource to delete the device position history from.</p>
        pub fn tracker_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(inp);
            self
        }
        /// <p>The name of the tracker resource to delete the device position history from.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
        /// Appends an item to `DeviceIds`.
        ///
        /// To override the contents of this collection use [`set_device_ids`](Self::set_device_ids).
        ///
        /// <p>Devices whose position history you want to delete.</p>
        /// <ul>
        /// <li>
        /// <p>For example, for two devices:
        /// <code>“DeviceIds” : [DeviceId1,DeviceId2]</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn device_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_ids(inp);
            self
        }
        /// <p>Devices whose position history you want to delete.</p>
        /// <ul>
        /// <li>
        /// <p>For example, for two devices:
        /// <code>“DeviceIds” : [DeviceId1,DeviceId2]</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_device_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDeleteGeofence`.
    ///
    /// <p>Deletes a batch of geofences from a geofence collection.</p>
    /// <note>
    /// <p>This operation deletes the resource permanently.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct BatchDeleteGeofence<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_delete_geofence_input::Builder,
    }
    impl<C, M, R> BatchDeleteGeofence<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDeleteGeofence`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteGeofenceOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteGeofenceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDeleteGeofenceInputOperationOutputAlias,
                crate::output::BatchDeleteGeofenceOutput,
                crate::error::BatchDeleteGeofenceError,
                crate::input::BatchDeleteGeofenceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The geofence collection storing the geofences to be deleted.</p>
        pub fn collection_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_name(inp);
            self
        }
        /// <p>The geofence collection storing the geofences to be deleted.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_name(input);
            self
        }
        /// Appends an item to `GeofenceIds`.
        ///
        /// To override the contents of this collection use [`set_geofence_ids`](Self::set_geofence_ids).
        ///
        /// <p>The batch of geofences to be deleted.</p>
        pub fn geofence_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.geofence_ids(inp);
            self
        }
        /// <p>The batch of geofences to be deleted.</p>
        pub fn set_geofence_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_geofence_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchEvaluateGeofences`.
    ///
    /// <p>Evaluates device positions against the geofence geometries from a given geofence
    /// collection.</p>
    /// <p>This operation always returns an empty response because geofences are asynchronously
    /// evaluated. The evaluation determines if the device has entered or exited a geofenced
    /// area, and then publishes one of the following events to Amazon EventBridge:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ENTER</code> if Amazon Location determines that the tracked device has entered
    /// a geofenced area.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EXIT</code> if Amazon Location determines that the tracked device has exited a
    /// geofenced area.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>The last geofence that a device was observed within is tracked for 30 days after
    /// the most recent device position update.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct BatchEvaluateGeofences<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_evaluate_geofences_input::Builder,
    }
    impl<C, M, R> BatchEvaluateGeofences<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchEvaluateGeofences`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchEvaluateGeofencesOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchEvaluateGeofencesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchEvaluateGeofencesInputOperationOutputAlias,
                crate::output::BatchEvaluateGeofencesOutput,
                crate::error::BatchEvaluateGeofencesError,
                crate::input::BatchEvaluateGeofencesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The geofence collection used in evaluating the position of devices against its
        /// geofences.</p>
        pub fn collection_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_name(inp);
            self
        }
        /// <p>The geofence collection used in evaluating the position of devices against its
        /// geofences.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_name(input);
            self
        }
        /// Appends an item to `DevicePositionUpdates`.
        ///
        /// To override the contents of this collection use [`set_device_position_updates`](Self::set_device_position_updates).
        ///
        /// <p>Contains device details for each device to be evaluated against the given geofence
        /// collection.</p>
        pub fn device_position_updates(
            mut self,
            inp: impl Into<crate::model::DevicePositionUpdate>,
        ) -> Self {
            self.inner = self.inner.device_position_updates(inp);
            self
        }
        /// <p>Contains device details for each device to be evaluated against the given geofence
        /// collection.</p>
        pub fn set_device_position_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DevicePositionUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_device_position_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetDevicePosition`.
    ///
    /// <p>Lists the latest device positions for requested devices.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetDevicePosition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_device_position_input::Builder,
    }
    impl<C, M, R> BatchGetDevicePosition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetDevicePosition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetDevicePositionOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetDevicePositionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetDevicePositionInputOperationOutputAlias,
                crate::output::BatchGetDevicePositionOutput,
                crate::error::BatchGetDevicePositionError,
                crate::input::BatchGetDevicePositionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The tracker resource retrieving the device position.</p>
        pub fn tracker_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(inp);
            self
        }
        /// <p>The tracker resource retrieving the device position.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
        /// Appends an item to `DeviceIds`.
        ///
        /// To override the contents of this collection use [`set_device_ids`](Self::set_device_ids).
        ///
        /// <p>Devices whose position you want to retrieve.</p>
        /// <ul>
        /// <li>
        /// <p>For example, for two devices:
        /// <code>device-ids=DeviceId1&amp;device-ids=DeviceId2</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn device_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_ids(inp);
            self
        }
        /// <p>Devices whose position you want to retrieve.</p>
        /// <ul>
        /// <li>
        /// <p>For example, for two devices:
        /// <code>device-ids=DeviceId1&amp;device-ids=DeviceId2</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_device_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_device_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchPutGeofence`.
    ///
    /// <p>A batch request for storing geofence geometries into a given geofence collection, or
    /// updates the geometry of an existing geofence if a geofence ID is included in the request.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchPutGeofence<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_put_geofence_input::Builder,
    }
    impl<C, M, R> BatchPutGeofence<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchPutGeofence`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchPutGeofenceOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchPutGeofenceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchPutGeofenceInputOperationOutputAlias,
                crate::output::BatchPutGeofenceOutput,
                crate::error::BatchPutGeofenceError,
                crate::input::BatchPutGeofenceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The geofence collection storing the geofences.</p>
        pub fn collection_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_name(inp);
            self
        }
        /// <p>The geofence collection storing the geofences.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_name(input);
            self
        }
        /// Appends an item to `Entries`.
        ///
        /// To override the contents of this collection use [`set_entries`](Self::set_entries).
        ///
        /// <p>The batch of geofences to be stored in a geofence collection.</p>
        pub fn entries(
            mut self,
            inp: impl Into<crate::model::BatchPutGeofenceRequestEntry>,
        ) -> Self {
            self.inner = self.inner.entries(inp);
            self
        }
        /// <p>The batch of geofences to be stored in a geofence collection.</p>
        pub fn set_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchPutGeofenceRequestEntry>>,
        ) -> Self {
            self.inner = self.inner.set_entries(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchUpdateDevicePosition`.
    ///
    /// <p>Uploads position update data for one or more devices to a tracker resource. Amazon Location
    /// uses the data when it reports the last known device position and position history. Amazon Location retains location data for 30
    /// days.</p>
    /// <note>
    /// <p>Position updates are handled based on the <code>PositionFiltering</code> property of the tracker.
    /// When <code>PositionFiltering</code> is set to <code>TimeBased</code>, updates are evaluated against linked geofence collections,
    /// and location data is stored at a maximum of one position per 30 second interval. If your update frequency is more often than
    /// every 30 seconds, only one update per 30 seconds is stored for each unique device ID.
    /// When <code>PositionFiltering</code> is set to <code>DistanceBased</code> filtering, location data is stored and evaluated against linked geofence
    /// collections only if the device has moved more than 30 m (98.4 ft).</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct BatchUpdateDevicePosition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_update_device_position_input::Builder,
    }
    impl<C, M, R> BatchUpdateDevicePosition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchUpdateDevicePosition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchUpdateDevicePositionOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchUpdateDevicePositionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchUpdateDevicePositionInputOperationOutputAlias,
                crate::output::BatchUpdateDevicePositionOutput,
                crate::error::BatchUpdateDevicePositionError,
                crate::input::BatchUpdateDevicePositionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the tracker resource to update.</p>
        pub fn tracker_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(inp);
            self
        }
        /// <p>The name of the tracker resource to update.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
        /// Appends an item to `Updates`.
        ///
        /// To override the contents of this collection use [`set_updates`](Self::set_updates).
        ///
        /// <p>Contains the position update details for each device.</p>
        pub fn updates(mut self, inp: impl Into<crate::model::DevicePositionUpdate>) -> Self {
            self.inner = self.inner.updates(inp);
            self
        }
        /// <p>Contains the position update details for each device.</p>
        pub fn set_updates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DevicePositionUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_updates(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CalculateRoute`.
    ///
    /// <p>
    /// <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html">Calculates a route</a> given the following required parameters:
    /// <code>DeparturePostiton</code> and <code>DestinationPosition</code>. Requires that
    /// you first <a href="https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html">create a
    /// route calculator resource</a>
    /// </p>
    /// <p>By default, a request that doesn't specify a departure time uses the best time of day
    /// to travel with the best traffic conditions when calculating the route.</p>
    /// <p>Additional options include:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html#departure-time">Specifying a departure time</a> using either <code>DepartureTime</code> or
    /// <code>DepartureNow</code>. This calculates a route based on predictive
    /// traffic data at the given time. </p>
    /// <note>
    /// <p>You can't specify both <code>DepartureTime</code> and
    /// <code>DepartureNow</code> in a single request. Specifying both
    /// parameters returns an error message.</p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html#travel-mode">Specifying a travel mode</a> using TravelMode. This lets you specify an
    /// additional route preference such as <code>CarModeOptions</code> if traveling by
    /// <code>Car</code>, or <code>TruckModeOptions</code> if traveling by
    /// <code>Truck</code>.</p>
    /// </li>
    /// </ul>
    /// <p>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CalculateRoute<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::calculate_route_input::Builder,
    }
    impl<C, M, R> CalculateRoute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CalculateRoute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CalculateRouteOutput,
            aws_smithy_http::result::SdkError<crate::error::CalculateRouteError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CalculateRouteInputOperationOutputAlias,
                crate::output::CalculateRouteOutput,
                crate::error::CalculateRouteError,
                crate::input::CalculateRouteInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the route calculator resource that you want to use to calculate a route. </p>
        pub fn calculator_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.calculator_name(inp);
            self
        }
        /// <p>The name of the route calculator resource that you want to use to calculate a route. </p>
        pub fn set_calculator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_calculator_name(input);
            self
        }
        /// Appends an item to `DeparturePosition`.
        ///
        /// To override the contents of this collection use [`set_departure_position`](Self::set_departure_position).
        ///
        /// <p>The start position for the route. Defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format:
        /// <code>[longitude, latitude]</code>.</p>
        /// <ul>
        /// <li>
        /// <p>For example, <code>[-123.115, 49.285]</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>If you specify a departure that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html#snap-to-nearby-road">moves the
        /// position to the nearest road</a>. If Esri is the provider for your route calculator,
        /// specifying a route that is longer than 400 km returns a <code>400 RoutesValidationException</code> error.</p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code>
        /// </p>
        pub fn departure_position(mut self, inp: impl Into<f64>) -> Self {
            self.inner = self.inner.departure_position(inp);
            self
        }
        /// <p>The start position for the route. Defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format:
        /// <code>[longitude, latitude]</code>.</p>
        /// <ul>
        /// <li>
        /// <p>For example, <code>[-123.115, 49.285]</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>If you specify a departure that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html#snap-to-nearby-road">moves the
        /// position to the nearest road</a>. If Esri is the provider for your route calculator,
        /// specifying a route that is longer than 400 km returns a <code>400 RoutesValidationException</code> error.</p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code>
        /// </p>
        pub fn set_departure_position(
            mut self,
            input: std::option::Option<std::vec::Vec<f64>>,
        ) -> Self {
            self.inner = self.inner.set_departure_position(input);
            self
        }
        /// Appends an item to `DestinationPosition`.
        ///
        /// To override the contents of this collection use [`set_destination_position`](Self::set_destination_position).
        ///
        /// <p>The finish position for the route. Defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format:
        /// <code>[longitude, latitude]</code>.</p>
        /// <ul>
        /// <li>
        /// <p> For example, <code>[-122.339, 47.615]</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>If you specify a destination that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html#snap-to-nearby-road">moves the position to the nearest road</a>. </p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code>
        /// </p>
        pub fn destination_position(mut self, inp: impl Into<f64>) -> Self {
            self.inner = self.inner.destination_position(inp);
            self
        }
        /// <p>The finish position for the route. Defined in <a href="https://earth-info.nga.mil/GandG/wgs84/index.html">WGS 84</a> format:
        /// <code>[longitude, latitude]</code>.</p>
        /// <ul>
        /// <li>
        /// <p> For example, <code>[-122.339, 47.615]</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>If you specify a destination that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html#snap-to-nearby-road">moves the position to the nearest road</a>. </p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code>
        /// </p>
        pub fn set_destination_position(
            mut self,
            input: std::option::Option<std::vec::Vec<f64>>,
        ) -> Self {
            self.inner = self.inner.set_destination_position(input);
            self
        }
        /// Appends an item to `WaypointPositions`.
        ///
        /// To override the contents of this collection use [`set_waypoint_positions`](Self::set_waypoint_positions).
        ///
        /// <p>Specifies an ordered list of up to 23 intermediate positions to include along a route
        /// between the departure position and destination position. </p>
        /// <ul>
        /// <li>
        /// <p>For example, from the <code>DeparturePosition</code>
        /// <code>[-123.115, 49.285]</code>, the route follows the order that the waypoint
        /// positions are given <code>[[-122.757, 49.0021],[-122.349, 47.620]]</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>If you specify a waypoint position that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html#snap-to-nearby-road">moves the position to the nearest road</a>. </p>
        /// <p>Specifying more than 23 waypoints returns a <code>400 ValidationException</code>
        /// error.</p>
        /// <p>If Esri is the provider for your route calculator, specifying a
        /// route that is longer than 400 km returns a <code>400 RoutesValidationException</code> error.</p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code>
        /// </p>
        pub fn waypoint_positions(mut self, inp: impl Into<std::vec::Vec<f64>>) -> Self {
            self.inner = self.inner.waypoint_positions(inp);
            self
        }
        /// <p>Specifies an ordered list of up to 23 intermediate positions to include along a route
        /// between the departure position and destination position. </p>
        /// <ul>
        /// <li>
        /// <p>For example, from the <code>DeparturePosition</code>
        /// <code>[-123.115, 49.285]</code>, the route follows the order that the waypoint
        /// positions are given <code>[[-122.757, 49.0021],[-122.349, 47.620]]</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>If you specify a waypoint position that's not located on a road, Amazon Location <a href="https://docs.aws.amazon.com/location/latest/developerguide/calculate-route.html#snap-to-nearby-road">moves the position to the nearest road</a>. </p>
        /// <p>Specifying more than 23 waypoints returns a <code>400 ValidationException</code>
        /// error.</p>
        /// <p>If Esri is the provider for your route calculator, specifying a
        /// route that is longer than 400 km returns a <code>400 RoutesValidationException</code> error.</p>
        /// </note>
        /// <p>Valid Values: <code>[-180 to 180,-90 to 90]</code>
        /// </p>
        pub fn set_waypoint_positions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<f64>>>,
        ) -> Self {
            self.inner = self.inner.set_waypoint_positions(input);
            self
        }
        /// <p>Specifies the mode of transport when calculating a route. Used in estimating the speed
        /// of travel and road compatibility.</p>
        /// <p>The <code>TravelMode</code> you specify determines how you specify route preferences: </p>
        /// <ul>
        /// <li>
        /// <p>If traveling by <code>Car</code> use the <code>CarModeOptions</code>
        /// parameter.</p>
        /// </li>
        /// <li>
        /// <p>If traveling by <code>Truck</code> use the <code>TruckModeOptions</code>
        /// parameter.</p>
        /// </li>
        /// </ul>
        /// <p>Default Value: <code>Car</code>
        /// </p>
        pub fn travel_mode(mut self, inp: crate::model::TravelMode) -> Self {
            self.inner = self.inner.travel_mode(inp);
            self
        }
        /// <p>Specifies the mode of transport when calculating a route. Used in estimating the speed
        /// of travel and road compatibility.</p>
        /// <p>The <code>TravelMode</code> you specify determines how you specify route preferences: </p>
        /// <ul>
        /// <li>
        /// <p>If traveling by <code>Car</code> use the <code>CarModeOptions</code>
        /// parameter.</p>
        /// </li>
        /// <li>
        /// <p>If traveling by <code>Truck</code> use the <code>TruckModeOptions</code>
        /// parameter.</p>
        /// </li>
        /// </ul>
        /// <p>Default Value: <code>Car</code>
        /// </p>
        pub fn set_travel_mode(
            mut self,
            input: std::option::Option<crate::model::TravelMode>,
        ) -> Self {
            self.inner = self.inner.set_travel_mode(input);
            self
        }
        /// <p>Specifies the desired time of departure. Uses the given time to calculate a route.
        /// Otherwise, the best time of day to travel with the best traffic conditions is used to
        /// calculate the route.</p>
        /// <note>
        /// <p>Setting a departure time in the past returns a <code>400
        /// ValidationException</code> error.</p>
        /// </note>
        /// <ul>
        /// <li>
        /// <p>In <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO
        /// 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. For example,
        /// <code>2020–07-2T12:15:20.000Z+01:00</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn departure_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.departure_time(inp);
            self
        }
        /// <p>Specifies the desired time of departure. Uses the given time to calculate a route.
        /// Otherwise, the best time of day to travel with the best traffic conditions is used to
        /// calculate the route.</p>
        /// <note>
        /// <p>Setting a departure time in the past returns a <code>400
        /// ValidationException</code> error.</p>
        /// </note>
        /// <ul>
        /// <li>
        /// <p>In <a href="https://www.iso.org/iso-8601-date-and-time-format.html">ISO
        /// 8601</a> format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. For example,
        /// <code>2020–07-2T12:15:20.000Z+01:00</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_departure_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_departure_time(input);
            self
        }
        /// <p>Sets the time of departure as the current time. Uses the current time to calculate a
        /// route. Otherwise, the best time of day to travel with the best traffic conditions is
        /// used to calculate the route.</p>
        /// <p>Default Value: <code>false</code>
        /// </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code>
        /// </p>
        pub fn depart_now(mut self, inp: bool) -> Self {
            self.inner = self.inner.depart_now(inp);
            self
        }
        /// <p>Sets the time of departure as the current time. Uses the current time to calculate a
        /// route. Otherwise, the best time of day to travel with the best traffic conditions is
        /// used to calculate the route.</p>
        /// <p>Default Value: <code>false</code>
        /// </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code>
        /// </p>
        pub fn set_depart_now(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_depart_now(input);
            self
        }
        /// <p>Set the unit system to specify the distance.</p>
        /// <p>Default Value: <code>Kilometers</code>
        /// </p>
        pub fn distance_unit(mut self, inp: crate::model::DistanceUnit) -> Self {
            self.inner = self.inner.distance_unit(inp);
            self
        }
        /// <p>Set the unit system to specify the distance.</p>
        /// <p>Default Value: <code>Kilometers</code>
        /// </p>
        pub fn set_distance_unit(
            mut self,
            input: std::option::Option<crate::model::DistanceUnit>,
        ) -> Self {
            self.inner = self.inner.set_distance_unit(input);
            self
        }
        /// <p>Set to include the geometry details in the result for each path between a pair of
        /// positions.</p>
        /// <p>Default Value: <code>false</code>
        /// </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code>
        /// </p>
        pub fn include_leg_geometry(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_leg_geometry(inp);
            self
        }
        /// <p>Set to include the geometry details in the result for each path between a pair of
        /// positions.</p>
        /// <p>Default Value: <code>false</code>
        /// </p>
        /// <p>Valid Values: <code>false</code> | <code>true</code>
        /// </p>
        pub fn set_include_leg_geometry(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_leg_geometry(input);
            self
        }
        /// <p>Specifies route preferences when traveling by <code>Car</code>, such as avoiding
        /// routes that use ferries or tolls.</p>
        /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Car</code>.</p>
        pub fn car_mode_options(mut self, inp: crate::model::CalculateRouteCarModeOptions) -> Self {
            self.inner = self.inner.car_mode_options(inp);
            self
        }
        /// <p>Specifies route preferences when traveling by <code>Car</code>, such as avoiding
        /// routes that use ferries or tolls.</p>
        /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Car</code>.</p>
        pub fn set_car_mode_options(
            mut self,
            input: std::option::Option<crate::model::CalculateRouteCarModeOptions>,
        ) -> Self {
            self.inner = self.inner.set_car_mode_options(input);
            self
        }
        /// <p>Specifies route preferences when traveling by <code>Truck</code>, such as avoiding
        /// routes that use ferries or tolls, and truck specifications to consider when choosing an
        /// optimal road.</p>
        /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Truck</code>.</p>
        pub fn truck_mode_options(
            mut self,
            inp: crate::model::CalculateRouteTruckModeOptions,
        ) -> Self {
            self.inner = self.inner.truck_mode_options(inp);
            self
        }
        /// <p>Specifies route preferences when traveling by <code>Truck</code>, such as avoiding
        /// routes that use ferries or tolls, and truck specifications to consider when choosing an
        /// optimal road.</p>
        /// <p>Requirements: <code>TravelMode</code> must be specified as <code>Truck</code>.</p>
        pub fn set_truck_mode_options(
            mut self,
            input: std::option::Option<crate::model::CalculateRouteTruckModeOptions>,
        ) -> Self {
            self.inner = self.inner.set_truck_mode_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGeofenceCollection`.
    ///
    /// <p>Creates a geofence collection, which manages and stores geofences.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateGeofenceCollection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_geofence_collection_input::Builder,
    }
    impl<C, M, R> CreateGeofenceCollection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGeofenceCollection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGeofenceCollectionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGeofenceCollectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGeofenceCollectionInputOperationOutputAlias,
                crate::output::CreateGeofenceCollectionOutput,
                crate::error::CreateGeofenceCollectionError,
                crate::input::CreateGeofenceCollectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A custom name for the geofence collection.</p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods
        /// (.), and underscores (_). </p>
        /// </li>
        /// <li>
        /// <p>Must be a unique geofence collection name.</p>
        /// </li>
        /// <li>
        /// <p>No spaces allowed. For example, <code>ExampleGeofenceCollection</code>.</p>
        /// </li>
        /// </ul>
        pub fn collection_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_name(inp);
            self
        }
        /// <p>A custom name for the geofence collection.</p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods
        /// (.), and underscores (_). </p>
        /// </li>
        /// <li>
        /// <p>Must be a unique geofence collection name.</p>
        /// </li>
        /// <li>
        /// <p>No spaces allowed. For example, <code>ExampleGeofenceCollection</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_name(input);
            self
        }
        /// <p>Specifies the pricing plan for the geofence collection.</p>
        /// <p>For additional details and restrictions on each pricing plan option, see the <a href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing
        /// page</a>.</p>
        pub fn pricing_plan(mut self, inp: crate::model::PricingPlan) -> Self {
            self.inner = self.inner.pricing_plan(inp);
            self
        }
        /// <p>Specifies the pricing plan for the geofence collection.</p>
        /// <p>For additional details and restrictions on each pricing plan option, see the <a href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing
        /// page</a>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan(input);
            self
        }
        /// <p>Specifies the data provider for the geofence collection.</p>
        /// <ul>
        /// <li>
        /// <p>Required value for the following pricing plans: <code>MobileAssetTracking
        /// </code>| <code>MobileAssetManagement</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information about <a href="https://aws.amazon.com/location/data-providers/">Data Providers</a>, and <a href="https://aws.amazon.com/location/pricing/">Pricing plans</a>, see the Amazon Location
        /// Service product page.</p>
        /// <note>
        /// <p>Amazon Location Service only uses <code>PricingPlanDataSource</code> to calculate billing for
        /// your geofence collection. Your data won't be shared with the data provider, and will
        /// remain in your AWS account or Region unless you move it.</p>
        /// </note>
        /// <p>Valid Values: <code>Esri </code>| <code>Here</code>
        /// </p>
        pub fn pricing_plan_data_source(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pricing_plan_data_source(inp);
            self
        }
        /// <p>Specifies the data provider for the geofence collection.</p>
        /// <ul>
        /// <li>
        /// <p>Required value for the following pricing plans: <code>MobileAssetTracking
        /// </code>| <code>MobileAssetManagement</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information about <a href="https://aws.amazon.com/location/data-providers/">Data Providers</a>, and <a href="https://aws.amazon.com/location/pricing/">Pricing plans</a>, see the Amazon Location
        /// Service product page.</p>
        /// <note>
        /// <p>Amazon Location Service only uses <code>PricingPlanDataSource</code> to calculate billing for
        /// your geofence collection. Your data won't be shared with the data provider, and will
        /// remain in your AWS account or Region unless you move it.</p>
        /// </note>
        /// <p>Valid Values: <code>Esri </code>| <code>Here</code>
        /// </p>
        pub fn set_pricing_plan_data_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan_data_source(input);
            self
        }
        /// <p>An optional description for the geofence collection.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>An optional description for the geofence collection.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Applies one or more tags to the geofence collection. A tag is a key-value pair helps
        /// manage, identify, search, and filter your resources by labelling them.</p>
        /// <p>Format: <code>"key" : "value"</code>
        /// </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum 50 tags per resource</p>
        /// </li>
        /// <li>
        /// <p>Each resource tag must be unique with a maximum of one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length: 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length: 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters:
        /// + - = . _ : / @. </p>
        /// </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Applies one or more tags to the geofence collection. A tag is a key-value pair helps
        /// manage, identify, search, and filter your resources by labelling them.</p>
        /// <p>Format: <code>"key" : "value"</code>
        /// </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum 50 tags per resource</p>
        /// </li>
        /// <li>
        /// <p>Each resource tag must be unique with a maximum of one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length: 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length: 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters:
        /// + - = . _ : / @. </p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN.
        /// </p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN.
        /// </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMap`.
    ///
    /// <p>Creates a map resource in your AWS account, which provides map tiles of different
    /// styles sourced from global location data providers.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateMap<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_map_input::Builder,
    }
    impl<C, M, R> CreateMap<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMap`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMapOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMapError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMapInputOperationOutputAlias,
                crate::output::CreateMapOutput,
                crate::error::CreateMapError,
                crate::input::CreateMapInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the map resource.</p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_). </p>
        /// </li>
        /// <li>
        /// <p>Must be a unique map resource name. </p>
        /// </li>
        /// <li>
        /// <p>No spaces allowed. For example, <code>ExampleMap</code>.</p>
        /// </li>
        /// </ul>
        pub fn map_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.map_name(inp);
            self
        }
        /// <p>The name for the map resource.</p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_). </p>
        /// </li>
        /// <li>
        /// <p>Must be a unique map resource name. </p>
        /// </li>
        /// <li>
        /// <p>No spaces allowed. For example, <code>ExampleMap</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_map_name(input);
            self
        }
        /// <p>Specifies the map style selected from an available data provider.</p>
        pub fn configuration(mut self, inp: crate::model::MapConfiguration) -> Self {
            self.inner = self.inner.configuration(inp);
            self
        }
        /// <p>Specifies the map style selected from an available data provider.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::MapConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// <p>Specifies the pricing plan for your map resource.</p>
        /// <p>For additional details and restrictions on each pricing plan option, see <a href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.</p>
        pub fn pricing_plan(mut self, inp: crate::model::PricingPlan) -> Self {
            self.inner = self.inner.pricing_plan(inp);
            self
        }
        /// <p>Specifies the pricing plan for your map resource.</p>
        /// <p>For additional details and restrictions on each pricing plan option, see <a href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan(input);
            self
        }
        /// <p>An optional description for the map resource.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>An optional description for the map resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Applies one or more tags to the map resource. A tag is a key-value pair helps manage,
        /// identify, search, and filter your resources by labelling them.</p>
        /// <p>Format: <code>"key" : "value"</code>
        /// </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum 50 tags per resource</p>
        /// </li>
        /// <li>
        /// <p>Each resource tag must be unique with a maximum of one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length: 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length:  256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : /
        /// @. </p>
        /// </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Applies one or more tags to the map resource. A tag is a key-value pair helps manage,
        /// identify, search, and filter your resources by labelling them.</p>
        /// <p>Format: <code>"key" : "value"</code>
        /// </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum 50 tags per resource</p>
        /// </li>
        /// <li>
        /// <p>Each resource tag must be unique with a maximum of one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length: 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length:  256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : /
        /// @. </p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePlaceIndex`.
    ///
    /// <p>Creates a place index resource in your AWS account, which supports functions with
    /// geospatial data sourced from your chosen data provider.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreatePlaceIndex<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_place_index_input::Builder,
    }
    impl<C, M, R> CreatePlaceIndex<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePlaceIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePlaceIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePlaceIndexError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePlaceIndexInputOperationOutputAlias,
                crate::output::CreatePlaceIndexOutput,
                crate::error::CreatePlaceIndexError,
                crate::input::CreatePlaceIndexInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the place index resource. </p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and
        /// underscores (_).</p>
        /// </li>
        /// <li>
        /// <p>Must be a unique place index resource name.</p>
        /// </li>
        /// <li>
        /// <p>No spaces allowed. For example, <code>ExamplePlaceIndex</code>.</p>
        /// </li>
        /// </ul>
        pub fn index_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(inp);
            self
        }
        /// <p>The name of the place index resource. </p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and
        /// underscores (_).</p>
        /// </li>
        /// <li>
        /// <p>Must be a unique place index resource name.</p>
        /// </li>
        /// <li>
        /// <p>No spaces allowed. For example, <code>ExamplePlaceIndex</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// <p>Specifies the data provider of geospatial data.</p>
        /// <note>
        /// <p>This field is case-sensitive. Enter the valid values as shown. For example, entering
        /// <code>HERE</code> returns an error.</p>
        /// </note>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Esri</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>'s coverage in your
        /// region of interest, see <a href="https://developers.arcgis.com/rest/geocode/api-reference/geocode-coverage.htm">Esri details on geocoding coverage</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Here</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a>'
        /// coverage in your region of interest, see <a href="https://developer.here.com/documentation/geocoder/dev_guide/topics/coverage-geocoder.html">HERE details on goecoding coverage</a>.</p>
        /// <important>
        /// <p>Place index resources using HERE Technologies as a data provider can't <a href="https://docs.aws.amazon.com/location-places/latest/APIReference/API_DataSourceConfiguration.html">store results</a> for locations in Japan. For more information, see the
        /// <a href="https://aws.amazon.com/service-terms/">AWS Service Terms</a>
        /// for Amazon Location Service.</p>
        /// </important>
        /// </li>
        /// </ul>
        /// <p>For additional information , see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data providers</a>
        /// on the <i>Amazon Location Service Developer Guide</i>.</p>
        pub fn data_source(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source(inp);
            self
        }
        /// <p>Specifies the data provider of geospatial data.</p>
        /// <note>
        /// <p>This field is case-sensitive. Enter the valid values as shown. For example, entering
        /// <code>HERE</code> returns an error.</p>
        /// </note>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Esri</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>'s coverage in your
        /// region of interest, see <a href="https://developers.arcgis.com/rest/geocode/api-reference/geocode-coverage.htm">Esri details on geocoding coverage</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Here</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a>'
        /// coverage in your region of interest, see <a href="https://developer.here.com/documentation/geocoder/dev_guide/topics/coverage-geocoder.html">HERE details on goecoding coverage</a>.</p>
        /// <important>
        /// <p>Place index resources using HERE Technologies as a data provider can't <a href="https://docs.aws.amazon.com/location-places/latest/APIReference/API_DataSourceConfiguration.html">store results</a> for locations in Japan. For more information, see the
        /// <a href="https://aws.amazon.com/service-terms/">AWS Service Terms</a>
        /// for Amazon Location Service.</p>
        /// </important>
        /// </li>
        /// </ul>
        /// <p>For additional information , see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data providers</a>
        /// on the <i>Amazon Location Service Developer Guide</i>.</p>
        pub fn set_data_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_source(input);
            self
        }
        /// <p>Specifies the pricing plan for your place index resource.</p>
        /// <p>For additional details and restrictions on each pricing plan option, see <a href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.</p>
        pub fn pricing_plan(mut self, inp: crate::model::PricingPlan) -> Self {
            self.inner = self.inner.pricing_plan(inp);
            self
        }
        /// <p>Specifies the pricing plan for your place index resource.</p>
        /// <p>For additional details and restrictions on each pricing plan option, see <a href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan(input);
            self
        }
        /// <p>The optional description for the place index resource.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The optional description for the place index resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Specifies the data storage option requesting Places.</p>
        pub fn data_source_configuration(
            mut self,
            inp: crate::model::DataSourceConfiguration,
        ) -> Self {
            self.inner = self.inner.data_source_configuration(inp);
            self
        }
        /// <p>Specifies the data storage option requesting Places.</p>
        pub fn set_data_source_configuration(
            mut self,
            input: std::option::Option<crate::model::DataSourceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_data_source_configuration(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Applies one or more tags to the place index resource. A tag is a key-value pair helps
        /// manage, identify, search, and filter your resources by labelling them.</p>
        /// <p>Format: <code>"key" : "value"</code>
        /// </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum 50 tags per resource</p>
        /// </li>
        /// <li>
        /// <p>Each resource tag must be unique with a maximum of one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length: 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length: 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + -
        /// = . _ : / @. </p>
        /// </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Applies one or more tags to the place index resource. A tag is a key-value pair helps
        /// manage, identify, search, and filter your resources by labelling them.</p>
        /// <p>Format: <code>"key" : "value"</code>
        /// </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum 50 tags per resource</p>
        /// </li>
        /// <li>
        /// <p>Each resource tag must be unique with a maximum of one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length: 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length: 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + -
        /// = . _ : / @. </p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRouteCalculator`.
    ///
    /// <p>Creates a route calculator resource in your AWS account.</p>
    /// <p>You can send requests to a route calculator resource to estimate travel time,
    /// distance, and get directions. A route calculator sources traffic and road network data
    /// from your chosen data provider.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRouteCalculator<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_route_calculator_input::Builder,
    }
    impl<C, M, R> CreateRouteCalculator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRouteCalculator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRouteCalculatorOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRouteCalculatorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRouteCalculatorInputOperationOutputAlias,
                crate::output::CreateRouteCalculatorOutput,
                crate::error::CreateRouteCalculatorError,
                crate::input::CreateRouteCalculatorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the route calculator resource. </p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores
        /// (_).</p>
        /// </li>
        /// <li>
        /// <p>Must be a unique Route calculator resource name.</p>
        /// </li>
        /// <li>
        /// <p>No spaces allowed. For example, <code>ExampleRouteCalculator</code>.</p>
        /// </li>
        /// </ul>
        pub fn calculator_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.calculator_name(inp);
            self
        }
        /// <p>The name of the route calculator resource. </p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Can use alphanumeric characters (A–Z, a–z, 0–9) , hyphens (-), periods (.), and underscores
        /// (_).</p>
        /// </li>
        /// <li>
        /// <p>Must be a unique Route calculator resource name.</p>
        /// </li>
        /// <li>
        /// <p>No spaces allowed. For example, <code>ExampleRouteCalculator</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_calculator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_calculator_name(input);
            self
        }
        /// <p>Specifies the data provider of traffic and road network data.</p>
        /// <note>
        /// <p>This field is case-sensitive. Enter the valid values as shown. For example,
        /// entering <code>HERE</code> returns an error. Route calculators that use Esri as a data source
        /// only calculate routes that are shorter than 400 km.</p>
        /// </note>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Esri</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>'s coverage in your region of interest, see <a href="https://doc.arcgis.com/en/arcgis-online/reference/network-coverage.htm">Esri details on street networks and traffic coverage</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Here</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE
        /// Technologies</a>' coverage in your region of interest, see <a href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/car-routing.html">HERE car routing coverage</a> and <a href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/truck-routing.html">HERE truck routing coverage</a>.</p>
        /// </li>
        /// </ul>
        /// <p>For additional information , see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data
        /// providers</a> on the <i>Amazon Location Service Developer Guide</i>.</p>
        pub fn data_source(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source(inp);
            self
        }
        /// <p>Specifies the data provider of traffic and road network data.</p>
        /// <note>
        /// <p>This field is case-sensitive. Enter the valid values as shown. For example,
        /// entering <code>HERE</code> returns an error. Route calculators that use Esri as a data source
        /// only calculate routes that are shorter than 400 km.</p>
        /// </note>
        /// <p>Valid values include:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Esri</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a>'s coverage in your region of interest, see <a href="https://doc.arcgis.com/en/arcgis-online/reference/network-coverage.htm">Esri details on street networks and traffic coverage</a>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Here</code> – For additional information about <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE
        /// Technologies</a>' coverage in your region of interest, see <a href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/car-routing.html">HERE car routing coverage</a> and <a href="https://developer.here.com/documentation/routing-api/dev_guide/topics/coverage/truck-routing.html">HERE truck routing coverage</a>.</p>
        /// </li>
        /// </ul>
        /// <p>For additional information , see <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Data
        /// providers</a> on the <i>Amazon Location Service Developer Guide</i>.</p>
        pub fn set_data_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_data_source(input);
            self
        }
        /// <p>Specifies the pricing plan for your route calculator resource.</p>
        /// <p>For additional details and restrictions on each pricing plan option, see <a href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.</p>
        pub fn pricing_plan(mut self, inp: crate::model::PricingPlan) -> Self {
            self.inner = self.inner.pricing_plan(inp);
            self
        }
        /// <p>Specifies the pricing plan for your route calculator resource.</p>
        /// <p>For additional details and restrictions on each pricing plan option, see <a href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan(input);
            self
        }
        /// <p>The optional description for the route calculator resource.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The optional description for the route calculator resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Applies one or more tags to the route calculator resource. A tag is a key-value pair
        /// helps manage, identify, search, and filter your resources by labelling them.</p>
        /// <ul>
        /// <li>
        /// <p>For example: { <code>"tag1" : "value1"</code>, <code>"tag2" :
        /// "value2"</code>}</p>
        /// </li>
        /// </ul>
        /// <p>Format: <code>"key" : "value"</code>
        /// </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum 50 tags per resource</p>
        /// </li>
        /// <li>
        /// <p>Each resource tag must be unique with a maximum of one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length: 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length: 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters:
        /// + - = . _ : / @. </p>
        /// </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Applies one or more tags to the route calculator resource. A tag is a key-value pair
        /// helps manage, identify, search, and filter your resources by labelling them.</p>
        /// <ul>
        /// <li>
        /// <p>For example: { <code>"tag1" : "value1"</code>, <code>"tag2" :
        /// "value2"</code>}</p>
        /// </li>
        /// </ul>
        /// <p>Format: <code>"key" : "value"</code>
        /// </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum 50 tags per resource</p>
        /// </li>
        /// <li>
        /// <p>Each resource tag must be unique with a maximum of one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length: 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length: 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters:
        /// + - = . _ : / @. </p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTracker`.
    ///
    /// <p>Creates a tracker resource in your AWS account, which lets you retrieve current and
    /// historical location of devices.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateTracker<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_tracker_input::Builder,
    }
    impl<C, M, R> CreateTracker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTracker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTrackerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTrackerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTrackerInputOperationOutputAlias,
                crate::output::CreateTrackerOutput,
                crate::error::CreateTrackerError,
                crate::input::CreateTrackerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the tracker resource.</p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).</p>
        /// </li>
        /// <li>
        /// <p>Must be a unique tracker resource name.</p>
        /// </li>
        /// <li>
        /// <p>No spaces allowed. For example, <code>ExampleTracker</code>.</p>
        /// </li>
        /// </ul>
        pub fn tracker_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(inp);
            self
        }
        /// <p>The name for the tracker resource.</p>
        /// <p>Requirements:</p>
        /// <ul>
        /// <li>
        /// <p>Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).</p>
        /// </li>
        /// <li>
        /// <p>Must be a unique tracker resource name.</p>
        /// </li>
        /// <li>
        /// <p>No spaces allowed. For example, <code>ExampleTracker</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
        /// <p>Specifies the pricing plan for the tracker resource.</p>
        /// <p>For additional details and restrictions on each pricing plan option, see <a href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.</p>
        pub fn pricing_plan(mut self, inp: crate::model::PricingPlan) -> Self {
            self.inner = self.inner.pricing_plan(inp);
            self
        }
        /// <p>Specifies the pricing plan for the tracker resource.</p>
        /// <p>For additional details and restrictions on each pricing plan option, see <a href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan(input);
            self
        }
        /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a>. Enter a key ID, key ARN, alias name, or alias ARN.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>Specifies the data provider for the tracker resource.</p>
        /// <ul>
        /// <li>
        /// <p>Required value for the following pricing plans: <code>MobileAssetTracking
        /// </code>| <code>MobileAssetManagement</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information about <a href="https://aws.amazon.com/location/data-providers/">Data Providers</a>, and <a href="https://aws.amazon.com/location/pricing/">Pricing plans</a>, see the Amazon Location
        /// Service product page.</p>
        /// <note>
        /// <p>Amazon Location Service only uses <code>PricingPlanDataSource</code> to calculate billing for your tracker resource. Your data will not be shared with the data provider, and will remain in your AWS account or Region unless you move it.</p>
        /// </note>
        /// <p>Valid values: <code>Esri</code> | <code>Here</code>
        /// </p>
        pub fn pricing_plan_data_source(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pricing_plan_data_source(inp);
            self
        }
        /// <p>Specifies the data provider for the tracker resource.</p>
        /// <ul>
        /// <li>
        /// <p>Required value for the following pricing plans: <code>MobileAssetTracking
        /// </code>| <code>MobileAssetManagement</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>For more information about <a href="https://aws.amazon.com/location/data-providers/">Data Providers</a>, and <a href="https://aws.amazon.com/location/pricing/">Pricing plans</a>, see the Amazon Location
        /// Service product page.</p>
        /// <note>
        /// <p>Amazon Location Service only uses <code>PricingPlanDataSource</code> to calculate billing for your tracker resource. Your data will not be shared with the data provider, and will remain in your AWS account or Region unless you move it.</p>
        /// </note>
        /// <p>Valid values: <code>Esri</code> | <code>Here</code>
        /// </p>
        pub fn set_pricing_plan_data_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan_data_source(input);
            self
        }
        /// <p>An optional description for the tracker resource.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>An optional description for the tracker resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Applies one or more tags to the tracker resource. A tag is a key-value pair helps
        /// manage, identify, search, and filter your resources by labelling them.</p>
        /// <p>Format: <code>"key" : "value"</code>
        /// </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum 50 tags per resource</p>
        /// </li>
        /// <li>
        /// <p>Each resource tag must be unique with a maximum of one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length: 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length: 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters:
        /// + - = . _ : / @. </p>
        /// </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Applies one or more tags to the tracker resource. A tag is a key-value pair helps
        /// manage, identify, search, and filter your resources by labelling them.</p>
        /// <p>Format: <code>"key" : "value"</code>
        /// </p>
        /// <p>Restrictions:</p>
        /// <ul>
        /// <li>
        /// <p>Maximum 50 tags per resource</p>
        /// </li>
        /// <li>
        /// <p>Each resource tag must be unique with a maximum of one value.</p>
        /// </li>
        /// <li>
        /// <p>Maximum key length: 128 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Maximum value length: 256 Unicode characters in UTF-8</p>
        /// </li>
        /// <li>
        /// <p>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters:
        /// + - = . _ : / @. </p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Specifies the position filtering for the tracker resource.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TimeBased</code> - Location updates are evaluated against linked geofence collections,
        /// but not every location update is stored. If your update frequency is more often than 30 seconds,
        /// only one update per 30 seconds is stored for each unique device ID.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are
        /// ignored. Location updates within this distance are neither evaluated against linked geofence collections, nor stored.
        /// This helps control costs by reducing the number of geofence evaluations and device positions to retrieve.
        /// Distance-based filtering can also reduce the jitter effect when displaying device trajectory on a map.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>This field is optional. If not specified, the default value is <code>TimeBased</code>.</p>
        pub fn position_filtering(mut self, inp: crate::model::PositionFiltering) -> Self {
            self.inner = self.inner.position_filtering(inp);
            self
        }
        /// <p>Specifies the position filtering for the tracker resource.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TimeBased</code> - Location updates are evaluated against linked geofence collections,
        /// but not every location update is stored. If your update frequency is more often than 30 seconds,
        /// only one update per 30 seconds is stored for each unique device ID.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are
        /// ignored. Location updates within this distance are neither evaluated against linked geofence collections, nor stored.
        /// This helps control costs by reducing the number of geofence evaluations and device positions to retrieve.
        /// Distance-based filtering can also reduce the jitter effect when displaying device trajectory on a map.
        /// </p>
        /// </li>
        /// </ul>
        /// <p>This field is optional. If not specified, the default value is <code>TimeBased</code>.</p>
        pub fn set_position_filtering(
            mut self,
            input: std::option::Option<crate::model::PositionFiltering>,
        ) -> Self {
            self.inner = self.inner.set_position_filtering(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGeofenceCollection`.
    ///
    /// <p>Deletes a geofence collection from your AWS account.</p>
    /// <note>
    /// <p>This operation deletes the resource permanently. If the geofence collection is the
    /// target of a tracker resource, the devices will no longer be monitored.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteGeofenceCollection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_geofence_collection_input::Builder,
    }
    impl<C, M, R> DeleteGeofenceCollection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGeofenceCollection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGeofenceCollectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGeofenceCollectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGeofenceCollectionInputOperationOutputAlias,
                crate::output::DeleteGeofenceCollectionOutput,
                crate::error::DeleteGeofenceCollectionError,
                crate::input::DeleteGeofenceCollectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the geofence collection to be deleted.</p>
        pub fn collection_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_name(inp);
            self
        }
        /// <p>The name of the geofence collection to be deleted.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMap`.
    ///
    /// <p>Deletes a map resource from your AWS account.</p>
    /// <note>
    /// <p>This operation deletes the resource permanently. If the map is being used in an application,
    /// the map may not render.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteMap<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_map_input::Builder,
    }
    impl<C, M, R> DeleteMap<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMap`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMapOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMapError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMapInputOperationOutputAlias,
                crate::output::DeleteMapOutput,
                crate::error::DeleteMapError,
                crate::input::DeleteMapInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the map resource to be deleted.</p>
        pub fn map_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.map_name(inp);
            self
        }
        /// <p>The name of the map resource to be deleted.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_map_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePlaceIndex`.
    ///
    /// <p>Deletes a place index resource from your AWS account.</p>
    /// <note>
    /// <p>This operation deletes the resource permanently.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeletePlaceIndex<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_place_index_input::Builder,
    }
    impl<C, M, R> DeletePlaceIndex<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePlaceIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePlaceIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePlaceIndexError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePlaceIndexInputOperationOutputAlias,
                crate::output::DeletePlaceIndexOutput,
                crate::error::DeletePlaceIndexError,
                crate::input::DeletePlaceIndexInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the place index resource to be deleted.</p>
        pub fn index_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(inp);
            self
        }
        /// <p>The name of the place index resource to be deleted.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRouteCalculator`.
    ///
    /// <p>Deletes a route calculator resource from your AWS account.</p>
    /// <note>
    /// <p>This operation deletes the resource permanently.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRouteCalculator<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_route_calculator_input::Builder,
    }
    impl<C, M, R> DeleteRouteCalculator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRouteCalculator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRouteCalculatorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRouteCalculatorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRouteCalculatorInputOperationOutputAlias,
                crate::output::DeleteRouteCalculatorOutput,
                crate::error::DeleteRouteCalculatorError,
                crate::input::DeleteRouteCalculatorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the route calculator resource to be deleted.</p>
        pub fn calculator_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.calculator_name(inp);
            self
        }
        /// <p>The name of the route calculator resource to be deleted.</p>
        pub fn set_calculator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_calculator_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTracker`.
    ///
    /// <p>Deletes a tracker resource from your AWS account.</p>
    /// <note>
    /// <p>This operation deletes the resource permanently. If the tracker resource is in use, you may
    /// encounter an error. Make sure that the target resource isn't a dependency for your
    /// applications.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTracker<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_tracker_input::Builder,
    }
    impl<C, M, R> DeleteTracker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTracker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTrackerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTrackerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTrackerInputOperationOutputAlias,
                crate::output::DeleteTrackerOutput,
                crate::error::DeleteTrackerError,
                crate::input::DeleteTrackerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the tracker resource to be deleted.</p>
        pub fn tracker_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(inp);
            self
        }
        /// <p>The name of the tracker resource to be deleted.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeGeofenceCollection`.
    ///
    /// <p>Retrieves the geofence collection details.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeGeofenceCollection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_geofence_collection_input::Builder,
    }
    impl<C, M, R> DescribeGeofenceCollection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeGeofenceCollection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeGeofenceCollectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeGeofenceCollectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeGeofenceCollectionInputOperationOutputAlias,
                crate::output::DescribeGeofenceCollectionOutput,
                crate::error::DescribeGeofenceCollectionError,
                crate::input::DescribeGeofenceCollectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the geofence collection.</p>
        pub fn collection_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_name(inp);
            self
        }
        /// <p>The name of the geofence collection.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMap`.
    ///
    /// <p>Retrieves the map resource details.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeMap<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_map_input::Builder,
    }
    impl<C, M, R> DescribeMap<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMap`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMapOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMapError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeMapInputOperationOutputAlias,
                crate::output::DescribeMapOutput,
                crate::error::DescribeMapError,
                crate::input::DescribeMapInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the map resource.</p>
        pub fn map_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.map_name(inp);
            self
        }
        /// <p>The name of the map resource.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_map_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePlaceIndex`.
    ///
    /// <p>Retrieves the place index resource details.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePlaceIndex<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_place_index_input::Builder,
    }
    impl<C, M, R> DescribePlaceIndex<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePlaceIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePlaceIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePlaceIndexError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePlaceIndexInputOperationOutputAlias,
                crate::output::DescribePlaceIndexOutput,
                crate::error::DescribePlaceIndexError,
                crate::input::DescribePlaceIndexInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the place index resource.</p>
        pub fn index_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(inp);
            self
        }
        /// <p>The name of the place index resource.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRouteCalculator`.
    ///
    /// <p>Retrieves the route calculator resource details.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRouteCalculator<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_route_calculator_input::Builder,
    }
    impl<C, M, R> DescribeRouteCalculator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRouteCalculator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRouteCalculatorOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRouteCalculatorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRouteCalculatorInputOperationOutputAlias,
                crate::output::DescribeRouteCalculatorOutput,
                crate::error::DescribeRouteCalculatorError,
                crate::input::DescribeRouteCalculatorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the route calculator resource.</p>
        pub fn calculator_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.calculator_name(inp);
            self
        }
        /// <p>The name of the route calculator resource.</p>
        pub fn set_calculator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_calculator_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTracker`.
    ///
    /// <p>Retrieves the tracker resource details.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTracker<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_tracker_input::Builder,
    }
    impl<C, M, R> DescribeTracker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTracker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTrackerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTrackerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTrackerInputOperationOutputAlias,
                crate::output::DescribeTrackerOutput,
                crate::error::DescribeTrackerError,
                crate::input::DescribeTrackerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the tracker resource.</p>
        pub fn tracker_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(inp);
            self
        }
        /// <p>The name of the tracker resource.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateTrackerConsumer`.
    ///
    /// <p>Removes the association between a tracker resource and a geofence collection.</p>
    /// <note>
    /// <p>Once you unlink a tracker resource from a geofence collection, the tracker
    /// positions will no longer be automatically evaluated against geofences.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateTrackerConsumer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_tracker_consumer_input::Builder,
    }
    impl<C, M, R> DisassociateTrackerConsumer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateTrackerConsumer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateTrackerConsumerOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateTrackerConsumerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateTrackerConsumerInputOperationOutputAlias,
                crate::output::DisassociateTrackerConsumerOutput,
                crate::error::DisassociateTrackerConsumerError,
                crate::input::DisassociateTrackerConsumerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the tracker resource to be dissociated from the consumer.</p>
        pub fn tracker_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(inp);
            self
        }
        /// <p>The name of the tracker resource to be dissociated from the consumer.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the geofence collection to be disassociated from
        /// the tracker resource. Used when you need to specify a resource across all AWS. </p>
        /// <ul>
        /// <li>
        /// <p>Format example:
        /// <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn consumer_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.consumer_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the geofence collection to be disassociated from
        /// the tracker resource. Used when you need to specify a resource across all AWS. </p>
        /// <ul>
        /// <li>
        /// <p>Format example:
        /// <code>arn:aws:geo:region:account-id:geofence-collection/ExampleGeofenceCollectionConsumer</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_consumer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_consumer_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDevicePosition`.
    ///
    /// <p>Retrieves a device's most recent position according to its sample time.</p>
    /// <note>
    /// <p>Device positions are deleted after 30 days.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetDevicePosition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_device_position_input::Builder,
    }
    impl<C, M, R> GetDevicePosition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDevicePosition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDevicePositionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDevicePositionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDevicePositionInputOperationOutputAlias,
                crate::output::GetDevicePositionOutput,
                crate::error::GetDevicePositionError,
                crate::input::GetDevicePositionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The tracker resource receiving the position update.</p>
        pub fn tracker_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(inp);
            self
        }
        /// <p>The tracker resource receiving the position update.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
        /// <p>The device whose position you want to retrieve.</p>
        pub fn device_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(inp);
            self
        }
        /// <p>The device whose position you want to retrieve.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDevicePositionHistory`.
    ///
    /// <p>Retrieves the device position history from a tracker resource within a specified range
    /// of time.</p>
    /// <note>
    /// <p>Device positions are deleted after 30 days.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetDevicePositionHistory<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_device_position_history_input::Builder,
    }
    impl<C, M, R> GetDevicePositionHistory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDevicePositionHistory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDevicePositionHistoryOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDevicePositionHistoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDevicePositionHistoryInputOperationOutputAlias,
                crate::output::GetDevicePositionHistoryOutput,
                crate::error::GetDevicePositionHistoryError,
                crate::input::GetDevicePositionHistoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The tracker resource receiving the request for the device position history.</p>
        pub fn tracker_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(inp);
            self
        }
        /// <p>The tracker resource receiving the request for the device position history.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
        /// <p>The device whose position history you want to retrieve.</p>
        pub fn device_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.device_id(inp);
            self
        }
        /// <p>The device whose position history you want to retrieve.</p>
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_device_id(input);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no
        /// token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code>
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no
        /// token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code>
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specify the start time for the position history in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a>
        /// format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be 24 hours
        /// prior to the time that the request is made.</p>
        /// <p>Requirement:</p>
        /// <ul>
        /// <li>
        /// <p>The time specified for <code>StartTimeInclusive</code> must be before
        /// <code>EndTimeExclusive</code>.</p>
        /// </li>
        /// </ul>
        pub fn start_time_inclusive(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.start_time_inclusive(inp);
            self
        }
        /// <p>Specify the start time for the position history in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a>
        /// format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be 24 hours
        /// prior to the time that the request is made.</p>
        /// <p>Requirement:</p>
        /// <ul>
        /// <li>
        /// <p>The time specified for <code>StartTimeInclusive</code> must be before
        /// <code>EndTimeExclusive</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_start_time_inclusive(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_start_time_inclusive(input);
            self
        }
        /// <p>Specify the end time for the position history in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a>
        /// format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be the time
        /// that the request is made.</p>
        /// <p>Requirement:</p>
        /// <ul>
        /// <li>
        /// <p>The time specified for <code>EndTimeExclusive</code> must be after the time for
        /// <code>StartTimeInclusive</code>.</p>
        /// </li>
        /// </ul>
        pub fn end_time_exclusive(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_time_exclusive(inp);
            self
        }
        /// <p>Specify the end time for the position history in <a href="https://www.iso.org/iso-8601-date-and-time-format.html"> ISO 8601</a>
        /// format: <code>YYYY-MM-DDThh:mm:ss.sssZ</code>. By default, the value will be the time
        /// that the request is made.</p>
        /// <p>Requirement:</p>
        /// <ul>
        /// <li>
        /// <p>The time specified for <code>EndTimeExclusive</code> must be after the time for
        /// <code>StartTimeInclusive</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_end_time_exclusive(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_time_exclusive(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGeofence`.
    ///
    /// <p>Retrieves the geofence details from a geofence collection.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetGeofence<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_geofence_input::Builder,
    }
    impl<C, M, R> GetGeofence<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGeofence`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGeofenceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGeofenceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGeofenceInputOperationOutputAlias,
                crate::output::GetGeofenceOutput,
                crate::error::GetGeofenceError,
                crate::input::GetGeofenceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The geofence collection storing the target geofence.</p>
        pub fn collection_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_name(inp);
            self
        }
        /// <p>The geofence collection storing the target geofence.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_name(input);
            self
        }
        /// <p>The geofence you're retrieving details for.</p>
        pub fn geofence_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.geofence_id(inp);
            self
        }
        /// <p>The geofence you're retrieving details for.</p>
        pub fn set_geofence_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_geofence_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMapGlyphs`.
    ///
    /// <p>Retrieves glyphs used to display labels on a map.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMapGlyphs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_map_glyphs_input::Builder,
    }
    impl<C, M, R> GetMapGlyphs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMapGlyphs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMapGlyphsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMapGlyphsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMapGlyphsInputOperationOutputAlias,
                crate::output::GetMapGlyphsOutput,
                crate::error::GetMapGlyphsError,
                crate::input::GetMapGlyphsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The map resource associated with the glyph ﬁle.</p>
        pub fn map_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.map_name(inp);
            self
        }
        /// <p>The map resource associated with the glyph ﬁle.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_map_name(input);
            self
        }
        /// <p>A comma-separated list of fonts to load glyphs from in order of preference. For
        /// example, <code>Noto Sans Regular, Arial Unicode</code>.</p>
        /// <p>Valid fonts stacks for <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a> styles: </p>
        /// <ul>
        /// <li>
        /// <p>VectorEsriDarkGrayCanvas – <code>Ubuntu Medium Italic</code> | <code>Ubuntu
        /// Medium</code> | <code>Ubuntu Italic</code> | <code>Ubuntu Regular</code> |
        /// <code>Ubuntu Bold</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>VectorEsriLightGrayCanvas – <code>Ubuntu Italic</code> | <code>Ubuntu
        /// Regular</code> | <code>Ubuntu Light</code> | <code>Ubuntu Bold</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>VectorEsriTopographic – <code>Noto Sans Italic</code> | <code>Noto Sans
        /// Regular</code> | <code>Noto Sans Bold</code> | <code>Noto Serif
        /// Regular</code> | <code>Roboto Condensed Light Italic</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>VectorEsriStreets – <code>Arial Regular</code> | <code>Arial Italic</code> |
        /// <code>Arial Bold</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>VectorEsriNavigation – <code>Arial Regular</code> | <code>Arial Italic</code>
        /// | <code>Arial Bold</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Valid font stacks for <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a> styles: </p>
        /// <ul>
        /// <li>
        /// <p>VectorHereBerlin – <code>Fira GO Regular</code> | <code>Fira GO
        /// Bold</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn font_stack(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.font_stack(inp);
            self
        }
        /// <p>A comma-separated list of fonts to load glyphs from in order of preference. For
        /// example, <code>Noto Sans Regular, Arial Unicode</code>.</p>
        /// <p>Valid fonts stacks for <a href="https://docs.aws.amazon.com/location/latest/developerguide/esri.html">Esri</a> styles: </p>
        /// <ul>
        /// <li>
        /// <p>VectorEsriDarkGrayCanvas – <code>Ubuntu Medium Italic</code> | <code>Ubuntu
        /// Medium</code> | <code>Ubuntu Italic</code> | <code>Ubuntu Regular</code> |
        /// <code>Ubuntu Bold</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>VectorEsriLightGrayCanvas – <code>Ubuntu Italic</code> | <code>Ubuntu
        /// Regular</code> | <code>Ubuntu Light</code> | <code>Ubuntu Bold</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>VectorEsriTopographic – <code>Noto Sans Italic</code> | <code>Noto Sans
        /// Regular</code> | <code>Noto Sans Bold</code> | <code>Noto Serif
        /// Regular</code> | <code>Roboto Condensed Light Italic</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>VectorEsriStreets – <code>Arial Regular</code> | <code>Arial Italic</code> |
        /// <code>Arial Bold</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>VectorEsriNavigation – <code>Arial Regular</code> | <code>Arial Italic</code>
        /// | <code>Arial Bold</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>Valid font stacks for <a href="https://docs.aws.amazon.com/location/latest/developerguide/HERE.html">HERE Technologies</a> styles: </p>
        /// <ul>
        /// <li>
        /// <p>VectorHereBerlin – <code>Fira GO Regular</code> | <code>Fira GO
        /// Bold</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_font_stack(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_font_stack(input);
            self
        }
        /// <p>A Unicode range of characters to download glyphs for. Each response will contain 256
        /// characters. For example, 0–255 includes all characters from range <code>U+0000</code> to
        /// <code>00FF</code>. Must be aligned to multiples of 256.</p>
        pub fn font_unicode_range(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.font_unicode_range(inp);
            self
        }
        /// <p>A Unicode range of characters to download glyphs for. Each response will contain 256
        /// characters. For example, 0–255 includes all characters from range <code>U+0000</code> to
        /// <code>00FF</code>. Must be aligned to multiples of 256.</p>
        pub fn set_font_unicode_range(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_font_unicode_range(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMapSprites`.
    ///
    /// <p>Retrieves the sprite sheet corresponding to a map resource. The sprite sheet is a PNG
    /// image paired with a JSON document describing the offsets of individual icons that will
    /// be displayed on a rendered map.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMapSprites<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_map_sprites_input::Builder,
    }
    impl<C, M, R> GetMapSprites<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMapSprites`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMapSpritesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMapSpritesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMapSpritesInputOperationOutputAlias,
                crate::output::GetMapSpritesOutput,
                crate::error::GetMapSpritesError,
                crate::input::GetMapSpritesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The map resource associated with the sprite ﬁle.</p>
        pub fn map_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.map_name(inp);
            self
        }
        /// <p>The map resource associated with the sprite ﬁle.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_map_name(input);
            self
        }
        /// <p>The name of the sprite ﬁle. Use the following ﬁle names for the sprite sheet:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sprites.png</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sprites@2x.png</code> for high pixel density displays</p>
        /// </li>
        /// </ul>
        /// <p>For the JSON document contain image offsets. Use the following ﬁle names:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sprites.json</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sprites@2x.json</code> for high pixel density displays</p>
        /// </li>
        /// </ul>
        pub fn file_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.file_name(inp);
            self
        }
        /// <p>The name of the sprite ﬁle. Use the following ﬁle names for the sprite sheet:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sprites.png</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sprites@2x.png</code> for high pixel density displays</p>
        /// </li>
        /// </ul>
        /// <p>For the JSON document contain image offsets. Use the following ﬁle names:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sprites.json</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sprites@2x.json</code> for high pixel density displays</p>
        /// </li>
        /// </ul>
        pub fn set_file_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_file_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMapStyleDescriptor`.
    ///
    /// <p>Retrieves the map style descriptor from a map resource. </p>
    /// <p>The style descriptor contains speciﬁcations on how features render on a map. For
    /// example, what data to display, what order to display the data in, and the style for the
    /// data. Style descriptors follow the Mapbox Style Specification.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMapStyleDescriptor<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_map_style_descriptor_input::Builder,
    }
    impl<C, M, R> GetMapStyleDescriptor<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMapStyleDescriptor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMapStyleDescriptorOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMapStyleDescriptorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMapStyleDescriptorInputOperationOutputAlias,
                crate::output::GetMapStyleDescriptorOutput,
                crate::error::GetMapStyleDescriptorError,
                crate::input::GetMapStyleDescriptorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The map resource to retrieve the style descriptor from.</p>
        pub fn map_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.map_name(inp);
            self
        }
        /// <p>The map resource to retrieve the style descriptor from.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_map_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMapTile`.
    ///
    /// <p>Retrieves a vector data tile from the map resource. Map tiles are used by clients to
    /// render a map. they're addressed using a grid arrangement with an X coordinate, Y
    /// coordinate, and Z (zoom) level. </p>
    /// <p>The origin (0, 0) is the top left of the map. Increasing the zoom level by 1 doubles
    /// both the X and Y dimensions, so a tile containing data for the entire world at (0/0/0)
    /// will be split into 4 tiles at zoom 1 (1/0/0, 1/0/1, 1/1/0, 1/1/1).</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMapTile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_map_tile_input::Builder,
    }
    impl<C, M, R> GetMapTile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMapTile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMapTileOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMapTileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMapTileInputOperationOutputAlias,
                crate::output::GetMapTileOutput,
                crate::error::GetMapTileError,
                crate::input::GetMapTileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The map resource to retrieve the map tiles from.</p>
        pub fn map_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.map_name(inp);
            self
        }
        /// <p>The map resource to retrieve the map tiles from.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_map_name(input);
            self
        }
        /// <p>The zoom value for the map tile.</p>
        pub fn z(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.z(inp);
            self
        }
        /// <p>The zoom value for the map tile.</p>
        pub fn set_z(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_z(input);
            self
        }
        /// <p>The X axis value for the map tile.</p>
        pub fn x(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.x(inp);
            self
        }
        /// <p>The X axis value for the map tile.</p>
        pub fn set_x(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_x(input);
            self
        }
        /// <p>The Y axis value for the map tile. </p>
        pub fn y(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.y(inp);
            self
        }
        /// <p>The Y axis value for the map tile. </p>
        pub fn set_y(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_y(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDevicePositions`.
    ///
    /// <p>A batch request to retrieve all device positions.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDevicePositions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_device_positions_input::Builder,
    }
    impl<C, M, R> ListDevicePositions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDevicePositions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDevicePositionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDevicePositionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDevicePositionsInputOperationOutputAlias,
                crate::output::ListDevicePositionsOutput,
                crate::error::ListDevicePositionsError,
                crate::input::ListDevicePositionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The tracker resource containing the requested devices.</p>
        pub fn tracker_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(inp);
            self
        }
        /// <p>The tracker resource containing the requested devices.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
        /// <p>An optional limit for the number of entries returned in a single call.</p>
        /// <p>Default value: <code>100</code>
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>An optional limit for the number of entries returned in a single call.</p>
        /// <p>Default value: <code>100</code>
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no
        /// token is provided, the default page is the first page.</p>
        /// <p>Default value: <code>null</code>
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no
        /// token is provided, the default page is the first page.</p>
        /// <p>Default value: <code>null</code>
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGeofenceCollections`.
    ///
    /// <p>Lists geofence collections in your AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListGeofenceCollections<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_geofence_collections_input::Builder,
    }
    impl<C, M, R> ListGeofenceCollections<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGeofenceCollections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGeofenceCollectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGeofenceCollectionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGeofenceCollectionsInputOperationOutputAlias,
                crate::output::ListGeofenceCollectionsOutput,
                crate::error::ListGeofenceCollectionsError,
                crate::input::ListGeofenceCollectionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code>
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code>
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no
        /// token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code>
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no
        /// token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code>
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListGeofences`.
    ///
    /// <p>Lists geofences stored in a given geofence collection.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListGeofences<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_geofences_input::Builder,
    }
    impl<C, M, R> ListGeofences<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListGeofences`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListGeofencesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListGeofencesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListGeofencesInputOperationOutputAlias,
                crate::output::ListGeofencesOutput,
                crate::error::ListGeofencesError,
                crate::input::ListGeofencesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the geofence collection storing the list of geofences.</p>
        pub fn collection_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_name(inp);
            self
        }
        /// <p>The name of the geofence collection storing the list of geofences.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_name(input);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no
        /// token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code>
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no
        /// token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code>
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMaps`.
    ///
    /// <p>Lists map resources in your AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListMaps<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_maps_input::Builder,
    }
    impl<C, M, R> ListMaps<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMaps`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMapsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMapsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMapsInputOperationOutputAlias,
                crate::output::ListMapsOutput,
                crate::error::ListMapsError,
                crate::input::ListMapsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code>
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code>
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no
        /// token is provided, the default page is the first page.</p>
        /// <p>Default value: <code>null</code>
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no
        /// token is provided, the default page is the first page.</p>
        /// <p>Default value: <code>null</code>
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPlaceIndexes`.
    ///
    /// <p>Lists place index resources in your AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPlaceIndexes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_place_indexes_input::Builder,
    }
    impl<C, M, R> ListPlaceIndexes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPlaceIndexes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPlaceIndexesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPlaceIndexesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPlaceIndexesInputOperationOutputAlias,
                crate::output::ListPlaceIndexesOutput,
                crate::error::ListPlaceIndexesError,
                crate::input::ListPlaceIndexesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional limit for the maximum number of results returned in a single call.</p>
        /// <p>Default value: <code>100</code>
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>An optional limit for the maximum number of results returned in a single call.</p>
        /// <p>Default value: <code>100</code>
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no
        /// token is provided, the default page is the first page.</p>
        /// <p>Default value: <code>null</code>
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no
        /// token is provided, the default page is the first page.</p>
        /// <p>Default value: <code>null</code>
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRouteCalculators`.
    ///
    /// <p>Lists route calculator resources in your AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRouteCalculators<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_route_calculators_input::Builder,
    }
    impl<C, M, R> ListRouteCalculators<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRouteCalculators`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRouteCalculatorsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRouteCalculatorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRouteCalculatorsInputOperationOutputAlias,
                crate::output::ListRouteCalculatorsOutput,
                crate::error::ListRouteCalculatorsError,
                crate::input::ListRouteCalculatorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional maximum number of results returned in a single call.</p>
        /// <p>Default Value: <code>100</code>
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>An optional maximum number of results returned in a single call.</p>
        /// <p>Default Value: <code>100</code>
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no
        /// token is provided, the default page is the first page.</p>
        /// <p>Default Value: <code>null</code>
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no
        /// token is provided, the default page is the first page.</p>
        /// <p>Default Value: <code>null</code>
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of tags that are applied to the specified Amazon Location resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p>
        /// <ul>
        /// <li>
        /// <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p>
        /// <ul>
        /// <li>
        /// <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTrackerConsumers`.
    ///
    /// <p>Lists geofence collections currently associated to the given tracker resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTrackerConsumers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tracker_consumers_input::Builder,
    }
    impl<C, M, R> ListTrackerConsumers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTrackerConsumers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTrackerConsumersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTrackerConsumersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTrackerConsumersInputOperationOutputAlias,
                crate::output::ListTrackerConsumersOutput,
                crate::error::ListTrackerConsumersError,
                crate::input::ListTrackerConsumersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The tracker resource whose associated geofence collections you want to list.</p>
        pub fn tracker_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(inp);
            self
        }
        /// <p>The tracker resource whose associated geofence collections you want to list.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code>
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code>
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no
        /// token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code>
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no
        /// token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code>
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTrackers`.
    ///
    /// <p>Lists tracker resources in your AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTrackers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_trackers_input::Builder,
    }
    impl<C, M, R> ListTrackers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTrackers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTrackersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTrackersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTrackersInputOperationOutputAlias,
                crate::output::ListTrackersOutput,
                crate::error::ListTrackersError,
                crate::input::ListTrackersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code>
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>An optional limit for the number of resources returned in a single call. </p>
        /// <p>Default value: <code>100</code>
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no
        /// token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code>
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token specifying which page of results to return in the response. If no
        /// token is provided, the default page is the first page. </p>
        /// <p>Default value: <code>null</code>
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutGeofence`.
    ///
    /// <p>Stores a geofence geometry in a given geofence collection, or updates the geometry of
    /// an existing geofence if a geofence ID is included in the request. </p>
    #[derive(std::fmt::Debug)]
    pub struct PutGeofence<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_geofence_input::Builder,
    }
    impl<C, M, R> PutGeofence<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutGeofence`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutGeofenceOutput,
            aws_smithy_http::result::SdkError<crate::error::PutGeofenceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutGeofenceInputOperationOutputAlias,
                crate::output::PutGeofenceOutput,
                crate::error::PutGeofenceError,
                crate::input::PutGeofenceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The geofence collection to store the geofence in.</p>
        pub fn collection_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_name(inp);
            self
        }
        /// <p>The geofence collection to store the geofence in.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_name(input);
            self
        }
        /// <p>An identifier for the geofence. For example, <code>ExampleGeofence-1</code>.</p>
        pub fn geofence_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.geofence_id(inp);
            self
        }
        /// <p>An identifier for the geofence. For example, <code>ExampleGeofence-1</code>.</p>
        pub fn set_geofence_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_geofence_id(input);
            self
        }
        /// <p>Contains the polygon details to specify the position of the geofence.</p>
        /// <note>
        /// <p>Each <a href="https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html">geofence polygon</a> can have a maximum of 1,000 vertices.</p>
        /// </note>
        pub fn geometry(mut self, inp: crate::model::GeofenceGeometry) -> Self {
            self.inner = self.inner.geometry(inp);
            self
        }
        /// <p>Contains the polygon details to specify the position of the geofence.</p>
        /// <note>
        /// <p>Each <a href="https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html">geofence polygon</a> can have a maximum of 1,000 vertices.</p>
        /// </note>
        pub fn set_geometry(
            mut self,
            input: std::option::Option<crate::model::GeofenceGeometry>,
        ) -> Self {
            self.inner = self.inner.set_geometry(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchPlaceIndexForPosition`.
    ///
    /// <p>Reverse geocodes a given coordinate and returns a legible address. Allows you to search
    /// for Places or points of interest near a given position.</p>
    #[derive(std::fmt::Debug)]
    pub struct SearchPlaceIndexForPosition<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_place_index_for_position_input::Builder,
    }
    impl<C, M, R> SearchPlaceIndexForPosition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchPlaceIndexForPosition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchPlaceIndexForPositionOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchPlaceIndexForPositionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchPlaceIndexForPositionInputOperationOutputAlias,
                crate::output::SearchPlaceIndexForPositionOutput,
                crate::error::SearchPlaceIndexForPositionError,
                crate::input::SearchPlaceIndexForPositionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the place index resource you want to use for the search.</p>
        pub fn index_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(inp);
            self
        }
        /// <p>The name of the place index resource you want to use for the search.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// Appends an item to `Position`.
        ///
        /// To override the contents of this collection use [`set_position`](Self::set_position).
        ///
        /// <p>Specifies a coordinate for the query defined by a longitude, and latitude.</p>
        /// <ul>
        /// <li>
        /// <p>The first position is the X coordinate, or longitude.</p>
        /// </li>
        /// <li>
        /// <p>The second position is the Y coordinate, or latitude. </p>
        /// </li>
        /// </ul>
        /// <p>For example, <code>position=xLongitude&amp;position=yLatitude</code> .</p>
        pub fn position(mut self, inp: impl Into<f64>) -> Self {
            self.inner = self.inner.position(inp);
            self
        }
        /// <p>Specifies a coordinate for the query defined by a longitude, and latitude.</p>
        /// <ul>
        /// <li>
        /// <p>The first position is the X coordinate, or longitude.</p>
        /// </li>
        /// <li>
        /// <p>The second position is the Y coordinate, or latitude. </p>
        /// </li>
        /// </ul>
        /// <p>For example, <code>position=xLongitude&amp;position=yLatitude</code> .</p>
        pub fn set_position(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>An optional paramer. The maximum number of results returned per request. </p>
        /// <p>Default value: <code>50</code>
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>An optional paramer. The maximum number of results returned per request. </p>
        /// <p>Default value: <code>50</code>
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchPlaceIndexForText`.
    ///
    /// <p>Geocodes free-form text, such as an address, name, city, or region to allow you to
    /// search for Places or points of interest. </p>
    /// <p>Includes the option to apply additional parameters to narrow your list of
    /// results.</p>
    /// <note>
    /// <p>You can search for places near a given position using <code>BiasPosition</code>, or
    /// filter results within a bounding box using <code>FilterBBox</code>. Providing both
    /// parameters simultaneously returns an error.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct SearchPlaceIndexForText<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_place_index_for_text_input::Builder,
    }
    impl<C, M, R> SearchPlaceIndexForText<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchPlaceIndexForText`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchPlaceIndexForTextOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchPlaceIndexForTextError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchPlaceIndexForTextInputOperationOutputAlias,
                crate::output::SearchPlaceIndexForTextOutput,
                crate::error::SearchPlaceIndexForTextError,
                crate::input::SearchPlaceIndexForTextInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the place index resource you want to use for the search.</p>
        pub fn index_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(inp);
            self
        }
        /// <p>The name of the place index resource you want to use for the search.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// <p>The address, name,
        /// city, or region to be used in the search. In free-form text format. For example, <code>123 Any
        /// Street</code>.</p>
        pub fn text(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.text(inp);
            self
        }
        /// <p>The address, name,
        /// city, or region to be used in the search. In free-form text format. For example, <code>123 Any
        /// Street</code>.</p>
        pub fn set_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_text(input);
            self
        }
        /// Appends an item to `BiasPosition`.
        ///
        /// To override the contents of this collection use [`set_bias_position`](Self::set_bias_position).
        ///
        /// <p>Searches for results closest to the given position. An optional parameter defined by
        /// longitude, and latitude.</p>
        /// <ul>
        /// <li>
        /// <p>The first <code>bias</code> position is the X coordinate, or longitude.</p>
        /// </li>
        /// <li>
        /// <p>The second <code>bias</code> position is the Y coordinate, or latitude. </p>
        /// </li>
        /// </ul>
        /// <p>For example, <code>bias=xLongitude&amp;bias=yLatitude</code>.</p>
        pub fn bias_position(mut self, inp: impl Into<f64>) -> Self {
            self.inner = self.inner.bias_position(inp);
            self
        }
        /// <p>Searches for results closest to the given position. An optional parameter defined by
        /// longitude, and latitude.</p>
        /// <ul>
        /// <li>
        /// <p>The first <code>bias</code> position is the X coordinate, or longitude.</p>
        /// </li>
        /// <li>
        /// <p>The second <code>bias</code> position is the Y coordinate, or latitude. </p>
        /// </li>
        /// </ul>
        /// <p>For example, <code>bias=xLongitude&amp;bias=yLatitude</code>.</p>
        pub fn set_bias_position(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.inner = self.inner.set_bias_position(input);
            self
        }
        /// Appends an item to `FilterBBox`.
        ///
        /// To override the contents of this collection use [`set_filter_b_box`](Self::set_filter_b_box).
        ///
        /// <p>Filters the results by returning only Places within the provided bounding box. An
        /// optional parameter.</p>
        /// <p>The first 2 <code>bbox</code> parameters describe the lower southwest corner:</p>
        /// <ul>
        /// <li>
        /// <p>The first <code>bbox</code> position is the X coordinate or longitude of the lower
        /// southwest corner.</p>
        /// </li>
        /// <li>
        /// <p>The second <code>bbox</code> position is the Y coordinate or latitude of the lower
        /// southwest corner.</p>
        /// </li>
        /// </ul>
        /// <p>For example, <code>bbox=xLongitudeSW&amp;bbox=yLatitudeSW</code>.</p>
        /// <p>The next <code>bbox</code> parameters describe the upper northeast corner:</p>
        /// <ul>
        /// <li>
        /// <p>The third <code>bbox</code> position is the X coordinate, or longitude of the
        /// upper northeast corner.</p>
        /// </li>
        /// <li>
        /// <p>The fourth <code>bbox</code> position is the Y coordinate, or longitude of the
        /// upper northeast corner.</p>
        /// </li>
        /// </ul>
        /// <p>For example, <code>bbox=xLongitudeNE&amp;bbox=yLatitudeNE</code>
        /// </p>
        pub fn filter_b_box(mut self, inp: impl Into<f64>) -> Self {
            self.inner = self.inner.filter_b_box(inp);
            self
        }
        /// <p>Filters the results by returning only Places within the provided bounding box. An
        /// optional parameter.</p>
        /// <p>The first 2 <code>bbox</code> parameters describe the lower southwest corner:</p>
        /// <ul>
        /// <li>
        /// <p>The first <code>bbox</code> position is the X coordinate or longitude of the lower
        /// southwest corner.</p>
        /// </li>
        /// <li>
        /// <p>The second <code>bbox</code> position is the Y coordinate or latitude of the lower
        /// southwest corner.</p>
        /// </li>
        /// </ul>
        /// <p>For example, <code>bbox=xLongitudeSW&amp;bbox=yLatitudeSW</code>.</p>
        /// <p>The next <code>bbox</code> parameters describe the upper northeast corner:</p>
        /// <ul>
        /// <li>
        /// <p>The third <code>bbox</code> position is the X coordinate, or longitude of the
        /// upper northeast corner.</p>
        /// </li>
        /// <li>
        /// <p>The fourth <code>bbox</code> position is the Y coordinate, or longitude of the
        /// upper northeast corner.</p>
        /// </li>
        /// </ul>
        /// <p>For example, <code>bbox=xLongitudeNE&amp;bbox=yLatitudeNE</code>
        /// </p>
        pub fn set_filter_b_box(mut self, input: std::option::Option<std::vec::Vec<f64>>) -> Self {
            self.inner = self.inner.set_filter_b_box(input);
            self
        }
        /// Appends an item to `FilterCountries`.
        ///
        /// To override the contents of this collection use [`set_filter_countries`](Self::set_filter_countries).
        ///
        /// <p>Limits the search to the given a list of countries/regions. An optional
        /// parameter.</p>
        /// <ul>
        /// <li>
        /// <p>Use the <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit
        /// country code. For example, Australia uses three upper-case characters:
        /// <code>AUS</code>.</p>
        /// </li>
        /// </ul>
        pub fn filter_countries(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_countries(inp);
            self
        }
        /// <p>Limits the search to the given a list of countries/regions. An optional
        /// parameter.</p>
        /// <ul>
        /// <li>
        /// <p>Use the <a href="https://www.iso.org/iso-3166-country-codes.html">ISO 3166</a> 3-digit
        /// country code. For example, Australia uses three upper-case characters:
        /// <code>AUS</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_filter_countries(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_filter_countries(input);
            self
        }
        /// <p>An optional parameter. The maximum number of results returned per request. </p>
        /// <p>The default: <code>50</code>
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>An optional parameter. The maximum number of results returned per request. </p>
        /// <p>The default: <code>50</code>
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Assigns one or more tags (key-value pairs) to the specified Amazon
    /// Location Service resource.</p>
    ///
    /// <p>Tags can help you organize and categorize your resources.
    /// You can also use them to scope user permissions, by granting a user
    /// permission to access or change only resources with certain tag values.</p>
    ///
    /// <p>You can use the <code>TagResource</code> operation with an Amazon Location Service
    /// resource that already has tags. If you specify a new tag key for the resource, this tag
    /// is appended to the tags already associated with the resource. If you specify a tag key
    /// that's already associated with the resource, the new tag value that you specify replaces
    /// the previous value for that tag. </p>
    ///
    /// <p>You can associate up to 50 tags with a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to update.</p>
        /// <ul>
        /// <li>
        /// <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource whose tags you want to update.</p>
        /// <ul>
        /// <li>
        /// <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags that have been applied to the specified resource. Tags are mapped from the tag key to the tag value: <code>"TagKey" : "TagValue"</code>.</p>
        /// <ul>
        /// <li>
        /// <p>Format example: <code>{"tag1" : "value1", "tag2" : "value2"} </code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Tags that have been applied to the specified resource. Tags are mapped from the tag key to the tag value: <code>"TagKey" : "TagValue"</code>.</p>
        /// <ul>
        /// <li>
        /// <p>Format example: <code>{"tag1" : "value1", "tag2" : "value2"} </code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from the specified Amazon Location resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which you want to remove tags.</p>
        /// <ul>
        /// <li>
        /// <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which you want to remove tags.</p>
        /// <ul>
        /// <li>
        /// <p>Format example: <code>arn:aws:geo:region:account-id:resourcetype/ExampleResource</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove from the specified resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The list of tag keys to remove from the specified resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateGeofenceCollection`.
    ///
    /// <p>Updates the specified properties of a given geofence collection.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateGeofenceCollection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_geofence_collection_input::Builder,
    }
    impl<C, M, R> UpdateGeofenceCollection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateGeofenceCollection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateGeofenceCollectionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateGeofenceCollectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateGeofenceCollectionInputOperationOutputAlias,
                crate::output::UpdateGeofenceCollectionOutput,
                crate::error::UpdateGeofenceCollectionError,
                crate::input::UpdateGeofenceCollectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the geofence collection to update.</p>
        pub fn collection_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.collection_name(inp);
            self
        }
        /// <p>The name of the geofence collection to update.</p>
        pub fn set_collection_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_collection_name(input);
            self
        }
        /// <p>Updates the pricing plan for the geofence collection.</p>
        /// <p>For more information about each pricing plan option restrictions, see <a href="https://aws.amazon.com/location/pricing/">Amazon Location Service
        /// pricing</a>.</p>
        pub fn pricing_plan(mut self, inp: crate::model::PricingPlan) -> Self {
            self.inner = self.inner.pricing_plan(inp);
            self
        }
        /// <p>Updates the pricing plan for the geofence collection.</p>
        /// <p>For more information about each pricing plan option restrictions, see <a href="https://aws.amazon.com/location/pricing/">Amazon Location Service
        /// pricing</a>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan(input);
            self
        }
        /// <p>Updates the data provider for the geofence collection. </p>
        /// <p>A required value for the following pricing plans: <code>MobileAssetTracking</code>|
        /// <code>MobileAssetManagement</code>
        /// </p>
        /// <p>For more information about <a href="https://aws.amazon.com/location/data-providers/">data providers</a> and
        /// <a href="https://aws.amazon.com/location/pricing/">pricing plans</a>, see the
        /// Amazon Location Service product page.</p>
        /// <note>
        /// <p>This can only be updated when updating the <code>PricingPlan</code> in the same
        /// request.</p>
        /// <p>Amazon Location Service uses <code>PricingPlanDataSource</code> to calculate
        /// billing for your geofence collection. Your data won't be shared with the data
        /// provider, and will remain in your AWS account and Region unless you move it.</p>
        /// </note>
        pub fn pricing_plan_data_source(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pricing_plan_data_source(inp);
            self
        }
        /// <p>Updates the data provider for the geofence collection. </p>
        /// <p>A required value for the following pricing plans: <code>MobileAssetTracking</code>|
        /// <code>MobileAssetManagement</code>
        /// </p>
        /// <p>For more information about <a href="https://aws.amazon.com/location/data-providers/">data providers</a> and
        /// <a href="https://aws.amazon.com/location/pricing/">pricing plans</a>, see the
        /// Amazon Location Service product page.</p>
        /// <note>
        /// <p>This can only be updated when updating the <code>PricingPlan</code> in the same
        /// request.</p>
        /// <p>Amazon Location Service uses <code>PricingPlanDataSource</code> to calculate
        /// billing for your geofence collection. Your data won't be shared with the data
        /// provider, and will remain in your AWS account and Region unless you move it.</p>
        /// </note>
        pub fn set_pricing_plan_data_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan_data_source(input);
            self
        }
        /// <p>Updates the description for the geofence collection.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Updates the description for the geofence collection.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMap`.
    ///
    /// <p>Updates the specified properties of a given map resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateMap<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_map_input::Builder,
    }
    impl<C, M, R> UpdateMap<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMap`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMapOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMapError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMapInputOperationOutputAlias,
                crate::output::UpdateMapOutput,
                crate::error::UpdateMapError,
                crate::input::UpdateMapInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the map resource to update.</p>
        pub fn map_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.map_name(inp);
            self
        }
        /// <p>The name of the map resource to update.</p>
        pub fn set_map_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_map_name(input);
            self
        }
        /// <p>Updates the pricing plan for the map resource.</p>
        /// <p>For more information about each pricing plan option restrictions, see <a href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.</p>
        pub fn pricing_plan(mut self, inp: crate::model::PricingPlan) -> Self {
            self.inner = self.inner.pricing_plan(inp);
            self
        }
        /// <p>Updates the pricing plan for the map resource.</p>
        /// <p>For more information about each pricing plan option restrictions, see <a href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan(input);
            self
        }
        /// <p>Updates the description for the map resource.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Updates the description for the map resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePlaceIndex`.
    ///
    /// <p>Updates the specified properties of a given place index resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePlaceIndex<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_place_index_input::Builder,
    }
    impl<C, M, R> UpdatePlaceIndex<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePlaceIndex`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePlaceIndexOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePlaceIndexError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePlaceIndexInputOperationOutputAlias,
                crate::output::UpdatePlaceIndexOutput,
                crate::error::UpdatePlaceIndexError,
                crate::input::UpdatePlaceIndexInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the place index resource to update.</p>
        pub fn index_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.index_name(inp);
            self
        }
        /// <p>The name of the place index resource to update.</p>
        pub fn set_index_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_index_name(input);
            self
        }
        /// <p>Updates the pricing plan for the place index resource.</p>
        /// <p>For more information about each pricing plan option restrictions, see <a href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.</p>
        pub fn pricing_plan(mut self, inp: crate::model::PricingPlan) -> Self {
            self.inner = self.inner.pricing_plan(inp);
            self
        }
        /// <p>Updates the pricing plan for the place index resource.</p>
        /// <p>For more information about each pricing plan option restrictions, see <a href="https://aws.amazon.com/location/pricing/">Amazon Location Service pricing</a>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan(input);
            self
        }
        /// <p>Updates the description for the place index resource.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Updates the description for the place index resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Updates the data storage option for the place index resource.</p>
        pub fn data_source_configuration(
            mut self,
            inp: crate::model::DataSourceConfiguration,
        ) -> Self {
            self.inner = self.inner.data_source_configuration(inp);
            self
        }
        /// <p>Updates the data storage option for the place index resource.</p>
        pub fn set_data_source_configuration(
            mut self,
            input: std::option::Option<crate::model::DataSourceConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_data_source_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRouteCalculator`.
    ///
    /// <p>Updates the specified properties for a given route calculator resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRouteCalculator<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_route_calculator_input::Builder,
    }
    impl<C, M, R> UpdateRouteCalculator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRouteCalculator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRouteCalculatorOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRouteCalculatorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRouteCalculatorInputOperationOutputAlias,
                crate::output::UpdateRouteCalculatorOutput,
                crate::error::UpdateRouteCalculatorError,
                crate::input::UpdateRouteCalculatorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the route calculator resource to update.</p>
        pub fn calculator_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.calculator_name(inp);
            self
        }
        /// <p>The name of the route calculator resource to update.</p>
        pub fn set_calculator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_calculator_name(input);
            self
        }
        /// <p>Updates the pricing plan for the route calculator resource.</p>
        /// <p>For more information about each pricing plan option restrictions, see <a href="https://aws.amazon.com/location/pricing/">Amazon Location
        /// Service pricing</a>.</p>
        pub fn pricing_plan(mut self, inp: crate::model::PricingPlan) -> Self {
            self.inner = self.inner.pricing_plan(inp);
            self
        }
        /// <p>Updates the pricing plan for the route calculator resource.</p>
        /// <p>For more information about each pricing plan option restrictions, see <a href="https://aws.amazon.com/location/pricing/">Amazon Location
        /// Service pricing</a>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan(input);
            self
        }
        /// <p>Updates the description for the route calculator resource.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Updates the description for the route calculator resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateTracker`.
    ///
    /// <p>Updates the specified properties of a given tracker resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateTracker<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_tracker_input::Builder,
    }
    impl<C, M, R> UpdateTracker<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateTracker`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateTrackerOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateTrackerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateTrackerInputOperationOutputAlias,
                crate::output::UpdateTrackerOutput,
                crate::error::UpdateTrackerError,
                crate::input::UpdateTrackerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the tracker resource to update.</p>
        pub fn tracker_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tracker_name(inp);
            self
        }
        /// <p>The name of the tracker resource to update.</p>
        pub fn set_tracker_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tracker_name(input);
            self
        }
        /// <p>Updates the pricing plan for the tracker resource.</p>
        /// <p>For more information about each pricing plan option restrictions, see <a href="https://aws.amazon.com/location/pricing/">Amazon Location Service
        /// pricing</a>.</p>
        pub fn pricing_plan(mut self, inp: crate::model::PricingPlan) -> Self {
            self.inner = self.inner.pricing_plan(inp);
            self
        }
        /// <p>Updates the pricing plan for the tracker resource.</p>
        /// <p>For more information about each pricing plan option restrictions, see <a href="https://aws.amazon.com/location/pricing/">Amazon Location Service
        /// pricing</a>.</p>
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan(input);
            self
        }
        /// <p>Updates the data provider for the tracker resource. </p>
        /// <p>A required value for the following pricing plans: <code>MobileAssetTracking</code>| <code>MobileAssetManagement</code>
        /// </p>
        /// <p>For more information about <a href="https://aws.amazon.com/location/data-providers/">data providers</a> and <a href="https://aws.amazon.com/location/pricing/">pricing plans</a>, see the Amazon Location Service product
        /// page</p>
        /// <note>
        /// <p>This can only be updated when updating the <code>PricingPlan</code> in the same
        /// request.</p>
        /// <p>Amazon Location Service uses <code>PricingPlanDataSource</code> to calculate
        /// billing for your tracker resource. Your data won't be shared with the data provider,
        /// and will remain in your AWS account and Region unless you move it.</p>
        /// </note>
        pub fn pricing_plan_data_source(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pricing_plan_data_source(inp);
            self
        }
        /// <p>Updates the data provider for the tracker resource. </p>
        /// <p>A required value for the following pricing plans: <code>MobileAssetTracking</code>| <code>MobileAssetManagement</code>
        /// </p>
        /// <p>For more information about <a href="https://aws.amazon.com/location/data-providers/">data providers</a> and <a href="https://aws.amazon.com/location/pricing/">pricing plans</a>, see the Amazon Location Service product
        /// page</p>
        /// <note>
        /// <p>This can only be updated when updating the <code>PricingPlan</code> in the same
        /// request.</p>
        /// <p>Amazon Location Service uses <code>PricingPlanDataSource</code> to calculate
        /// billing for your tracker resource. Your data won't be shared with the data provider,
        /// and will remain in your AWS account and Region unless you move it.</p>
        /// </note>
        pub fn set_pricing_plan_data_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan_data_source(input);
            self
        }
        /// <p>Updates the description for the tracker resource.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Updates the description for the tracker resource.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Updates the position filtering for the tracker resource.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TimeBased</code> - Location updates are evaluated against linked geofence collections,
        /// but not every location update is stored. If your update frequency is more often than 30 seconds,
        /// only one update per 30 seconds is stored for each unique device ID.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are
        /// ignored. Location updates within this distance are neither evaluated against linked geofence collections, nor stored.
        /// This helps control costs by reducing the number of geofence evaluations and device positions to retrieve.
        /// Distance-based filtering can also reduce the jitter effect when displaying device trajectory on a map.
        /// </p>
        /// </li>
        /// </ul>
        pub fn position_filtering(mut self, inp: crate::model::PositionFiltering) -> Self {
            self.inner = self.inner.position_filtering(inp);
            self
        }
        /// <p>Updates the position filtering for the tracker resource.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>TimeBased</code> - Location updates are evaluated against linked geofence collections,
        /// but not every location update is stored. If your update frequency is more often than 30 seconds,
        /// only one update per 30 seconds is stored for each unique device ID.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are
        /// ignored. Location updates within this distance are neither evaluated against linked geofence collections, nor stored.
        /// This helps control costs by reducing the number of geofence evaluations and device positions to retrieve.
        /// Distance-based filtering can also reduce the jitter effect when displaying device trajectory on a map.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_position_filtering(
            mut self,
            input: std::option::Option<crate::model::PositionFiltering>,
        ) -> Self {
            self.inner = self.inner.set_position_filtering(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
