// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Amazon Lightsail
///
/// Client for invoking operations on Amazon Lightsail. Each operation on Amazon Lightsail is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_lightsail::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_lightsail::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_lightsail::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AllocateStaticIp` operation.
    ///
    /// See [`AllocateStaticIp`](crate::client::fluent_builders::AllocateStaticIp) for more information about the
    /// operation and its arguments.
    pub fn allocate_static_ip(&self) -> fluent_builders::AllocateStaticIp<C, M, R> {
        fluent_builders::AllocateStaticIp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachCertificateToDistribution` operation.
    ///
    /// See [`AttachCertificateToDistribution`](crate::client::fluent_builders::AttachCertificateToDistribution) for more information about the
    /// operation and its arguments.
    pub fn attach_certificate_to_distribution(
        &self,
    ) -> fluent_builders::AttachCertificateToDistribution<C, M, R> {
        fluent_builders::AttachCertificateToDistribution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachDisk` operation.
    ///
    /// See [`AttachDisk`](crate::client::fluent_builders::AttachDisk) for more information about the
    /// operation and its arguments.
    pub fn attach_disk(&self) -> fluent_builders::AttachDisk<C, M, R> {
        fluent_builders::AttachDisk::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachInstancesToLoadBalancer` operation.
    ///
    /// See [`AttachInstancesToLoadBalancer`](crate::client::fluent_builders::AttachInstancesToLoadBalancer) for more information about the
    /// operation and its arguments.
    pub fn attach_instances_to_load_balancer(
        &self,
    ) -> fluent_builders::AttachInstancesToLoadBalancer<C, M, R> {
        fluent_builders::AttachInstancesToLoadBalancer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachLoadBalancerTlsCertificate` operation.
    ///
    /// See [`AttachLoadBalancerTlsCertificate`](crate::client::fluent_builders::AttachLoadBalancerTlsCertificate) for more information about the
    /// operation and its arguments.
    pub fn attach_load_balancer_tls_certificate(
        &self,
    ) -> fluent_builders::AttachLoadBalancerTlsCertificate<C, M, R> {
        fluent_builders::AttachLoadBalancerTlsCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AttachStaticIp` operation.
    ///
    /// See [`AttachStaticIp`](crate::client::fluent_builders::AttachStaticIp) for more information about the
    /// operation and its arguments.
    pub fn attach_static_ip(&self) -> fluent_builders::AttachStaticIp<C, M, R> {
        fluent_builders::AttachStaticIp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CloseInstancePublicPorts` operation.
    ///
    /// See [`CloseInstancePublicPorts`](crate::client::fluent_builders::CloseInstancePublicPorts) for more information about the
    /// operation and its arguments.
    pub fn close_instance_public_ports(
        &self,
    ) -> fluent_builders::CloseInstancePublicPorts<C, M, R> {
        fluent_builders::CloseInstancePublicPorts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CopySnapshot` operation.
    ///
    /// See [`CopySnapshot`](crate::client::fluent_builders::CopySnapshot) for more information about the
    /// operation and its arguments.
    pub fn copy_snapshot(&self) -> fluent_builders::CopySnapshot<C, M, R> {
        fluent_builders::CopySnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBucket` operation.
    ///
    /// See [`CreateBucket`](crate::client::fluent_builders::CreateBucket) for more information about the
    /// operation and its arguments.
    pub fn create_bucket(&self) -> fluent_builders::CreateBucket<C, M, R> {
        fluent_builders::CreateBucket::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBucketAccessKey` operation.
    ///
    /// See [`CreateBucketAccessKey`](crate::client::fluent_builders::CreateBucketAccessKey) for more information about the
    /// operation and its arguments.
    pub fn create_bucket_access_key(&self) -> fluent_builders::CreateBucketAccessKey<C, M, R> {
        fluent_builders::CreateBucketAccessKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCertificate` operation.
    ///
    /// See [`CreateCertificate`](crate::client::fluent_builders::CreateCertificate) for more information about the
    /// operation and its arguments.
    pub fn create_certificate(&self) -> fluent_builders::CreateCertificate<C, M, R> {
        fluent_builders::CreateCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCloudFormationStack` operation.
    ///
    /// See [`CreateCloudFormationStack`](crate::client::fluent_builders::CreateCloudFormationStack) for more information about the
    /// operation and its arguments.
    pub fn create_cloud_formation_stack(
        &self,
    ) -> fluent_builders::CreateCloudFormationStack<C, M, R> {
        fluent_builders::CreateCloudFormationStack::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateContactMethod` operation.
    ///
    /// See [`CreateContactMethod`](crate::client::fluent_builders::CreateContactMethod) for more information about the
    /// operation and its arguments.
    pub fn create_contact_method(&self) -> fluent_builders::CreateContactMethod<C, M, R> {
        fluent_builders::CreateContactMethod::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateContainerService` operation.
    ///
    /// See [`CreateContainerService`](crate::client::fluent_builders::CreateContainerService) for more information about the
    /// operation and its arguments.
    pub fn create_container_service(&self) -> fluent_builders::CreateContainerService<C, M, R> {
        fluent_builders::CreateContainerService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateContainerServiceDeployment` operation.
    ///
    /// See [`CreateContainerServiceDeployment`](crate::client::fluent_builders::CreateContainerServiceDeployment) for more information about the
    /// operation and its arguments.
    pub fn create_container_service_deployment(
        &self,
    ) -> fluent_builders::CreateContainerServiceDeployment<C, M, R> {
        fluent_builders::CreateContainerServiceDeployment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateContainerServiceRegistryLogin` operation.
    ///
    /// See [`CreateContainerServiceRegistryLogin`](crate::client::fluent_builders::CreateContainerServiceRegistryLogin) for more information about the
    /// operation and its arguments.
    pub fn create_container_service_registry_login(
        &self,
    ) -> fluent_builders::CreateContainerServiceRegistryLogin<C, M, R> {
        fluent_builders::CreateContainerServiceRegistryLogin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDisk` operation.
    ///
    /// See [`CreateDisk`](crate::client::fluent_builders::CreateDisk) for more information about the
    /// operation and its arguments.
    pub fn create_disk(&self) -> fluent_builders::CreateDisk<C, M, R> {
        fluent_builders::CreateDisk::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDiskFromSnapshot` operation.
    ///
    /// See [`CreateDiskFromSnapshot`](crate::client::fluent_builders::CreateDiskFromSnapshot) for more information about the
    /// operation and its arguments.
    pub fn create_disk_from_snapshot(&self) -> fluent_builders::CreateDiskFromSnapshot<C, M, R> {
        fluent_builders::CreateDiskFromSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDiskSnapshot` operation.
    ///
    /// See [`CreateDiskSnapshot`](crate::client::fluent_builders::CreateDiskSnapshot) for more information about the
    /// operation and its arguments.
    pub fn create_disk_snapshot(&self) -> fluent_builders::CreateDiskSnapshot<C, M, R> {
        fluent_builders::CreateDiskSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDistribution` operation.
    ///
    /// See [`CreateDistribution`](crate::client::fluent_builders::CreateDistribution) for more information about the
    /// operation and its arguments.
    pub fn create_distribution(&self) -> fluent_builders::CreateDistribution<C, M, R> {
        fluent_builders::CreateDistribution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDomain` operation.
    ///
    /// See [`CreateDomain`](crate::client::fluent_builders::CreateDomain) for more information about the
    /// operation and its arguments.
    pub fn create_domain(&self) -> fluent_builders::CreateDomain<C, M, R> {
        fluent_builders::CreateDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDomainEntry` operation.
    ///
    /// See [`CreateDomainEntry`](crate::client::fluent_builders::CreateDomainEntry) for more information about the
    /// operation and its arguments.
    pub fn create_domain_entry(&self) -> fluent_builders::CreateDomainEntry<C, M, R> {
        fluent_builders::CreateDomainEntry::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateInstances` operation.
    ///
    /// See [`CreateInstances`](crate::client::fluent_builders::CreateInstances) for more information about the
    /// operation and its arguments.
    pub fn create_instances(&self) -> fluent_builders::CreateInstances<C, M, R> {
        fluent_builders::CreateInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateInstancesFromSnapshot` operation.
    ///
    /// See [`CreateInstancesFromSnapshot`](crate::client::fluent_builders::CreateInstancesFromSnapshot) for more information about the
    /// operation and its arguments.
    pub fn create_instances_from_snapshot(
        &self,
    ) -> fluent_builders::CreateInstancesFromSnapshot<C, M, R> {
        fluent_builders::CreateInstancesFromSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateInstanceSnapshot` operation.
    ///
    /// See [`CreateInstanceSnapshot`](crate::client::fluent_builders::CreateInstanceSnapshot) for more information about the
    /// operation and its arguments.
    pub fn create_instance_snapshot(&self) -> fluent_builders::CreateInstanceSnapshot<C, M, R> {
        fluent_builders::CreateInstanceSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateKeyPair` operation.
    ///
    /// See [`CreateKeyPair`](crate::client::fluent_builders::CreateKeyPair) for more information about the
    /// operation and its arguments.
    pub fn create_key_pair(&self) -> fluent_builders::CreateKeyPair<C, M, R> {
        fluent_builders::CreateKeyPair::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLoadBalancer` operation.
    ///
    /// See [`CreateLoadBalancer`](crate::client::fluent_builders::CreateLoadBalancer) for more information about the
    /// operation and its arguments.
    pub fn create_load_balancer(&self) -> fluent_builders::CreateLoadBalancer<C, M, R> {
        fluent_builders::CreateLoadBalancer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLoadBalancerTlsCertificate` operation.
    ///
    /// See [`CreateLoadBalancerTlsCertificate`](crate::client::fluent_builders::CreateLoadBalancerTlsCertificate) for more information about the
    /// operation and its arguments.
    pub fn create_load_balancer_tls_certificate(
        &self,
    ) -> fluent_builders::CreateLoadBalancerTlsCertificate<C, M, R> {
        fluent_builders::CreateLoadBalancerTlsCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRelationalDatabase` operation.
    ///
    /// See [`CreateRelationalDatabase`](crate::client::fluent_builders::CreateRelationalDatabase) for more information about the
    /// operation and its arguments.
    pub fn create_relational_database(&self) -> fluent_builders::CreateRelationalDatabase<C, M, R> {
        fluent_builders::CreateRelationalDatabase::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRelationalDatabaseFromSnapshot` operation.
    ///
    /// See [`CreateRelationalDatabaseFromSnapshot`](crate::client::fluent_builders::CreateRelationalDatabaseFromSnapshot) for more information about the
    /// operation and its arguments.
    pub fn create_relational_database_from_snapshot(
        &self,
    ) -> fluent_builders::CreateRelationalDatabaseFromSnapshot<C, M, R> {
        fluent_builders::CreateRelationalDatabaseFromSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRelationalDatabaseSnapshot` operation.
    ///
    /// See [`CreateRelationalDatabaseSnapshot`](crate::client::fluent_builders::CreateRelationalDatabaseSnapshot) for more information about the
    /// operation and its arguments.
    pub fn create_relational_database_snapshot(
        &self,
    ) -> fluent_builders::CreateRelationalDatabaseSnapshot<C, M, R> {
        fluent_builders::CreateRelationalDatabaseSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAlarm` operation.
    ///
    /// See [`DeleteAlarm`](crate::client::fluent_builders::DeleteAlarm) for more information about the
    /// operation and its arguments.
    pub fn delete_alarm(&self) -> fluent_builders::DeleteAlarm<C, M, R> {
        fluent_builders::DeleteAlarm::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAutoSnapshot` operation.
    ///
    /// See [`DeleteAutoSnapshot`](crate::client::fluent_builders::DeleteAutoSnapshot) for more information about the
    /// operation and its arguments.
    pub fn delete_auto_snapshot(&self) -> fluent_builders::DeleteAutoSnapshot<C, M, R> {
        fluent_builders::DeleteAutoSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBucket` operation.
    ///
    /// See [`DeleteBucket`](crate::client::fluent_builders::DeleteBucket) for more information about the
    /// operation and its arguments.
    pub fn delete_bucket(&self) -> fluent_builders::DeleteBucket<C, M, R> {
        fluent_builders::DeleteBucket::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBucketAccessKey` operation.
    ///
    /// See [`DeleteBucketAccessKey`](crate::client::fluent_builders::DeleteBucketAccessKey) for more information about the
    /// operation and its arguments.
    pub fn delete_bucket_access_key(&self) -> fluent_builders::DeleteBucketAccessKey<C, M, R> {
        fluent_builders::DeleteBucketAccessKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCertificate` operation.
    ///
    /// See [`DeleteCertificate`](crate::client::fluent_builders::DeleteCertificate) for more information about the
    /// operation and its arguments.
    pub fn delete_certificate(&self) -> fluent_builders::DeleteCertificate<C, M, R> {
        fluent_builders::DeleteCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteContactMethod` operation.
    ///
    /// See [`DeleteContactMethod`](crate::client::fluent_builders::DeleteContactMethod) for more information about the
    /// operation and its arguments.
    pub fn delete_contact_method(&self) -> fluent_builders::DeleteContactMethod<C, M, R> {
        fluent_builders::DeleteContactMethod::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteContainerImage` operation.
    ///
    /// See [`DeleteContainerImage`](crate::client::fluent_builders::DeleteContainerImage) for more information about the
    /// operation and its arguments.
    pub fn delete_container_image(&self) -> fluent_builders::DeleteContainerImage<C, M, R> {
        fluent_builders::DeleteContainerImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteContainerService` operation.
    ///
    /// See [`DeleteContainerService`](crate::client::fluent_builders::DeleteContainerService) for more information about the
    /// operation and its arguments.
    pub fn delete_container_service(&self) -> fluent_builders::DeleteContainerService<C, M, R> {
        fluent_builders::DeleteContainerService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDisk` operation.
    ///
    /// See [`DeleteDisk`](crate::client::fluent_builders::DeleteDisk) for more information about the
    /// operation and its arguments.
    pub fn delete_disk(&self) -> fluent_builders::DeleteDisk<C, M, R> {
        fluent_builders::DeleteDisk::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDiskSnapshot` operation.
    ///
    /// See [`DeleteDiskSnapshot`](crate::client::fluent_builders::DeleteDiskSnapshot) for more information about the
    /// operation and its arguments.
    pub fn delete_disk_snapshot(&self) -> fluent_builders::DeleteDiskSnapshot<C, M, R> {
        fluent_builders::DeleteDiskSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDistribution` operation.
    ///
    /// See [`DeleteDistribution`](crate::client::fluent_builders::DeleteDistribution) for more information about the
    /// operation and its arguments.
    pub fn delete_distribution(&self) -> fluent_builders::DeleteDistribution<C, M, R> {
        fluent_builders::DeleteDistribution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDomain` operation.
    ///
    /// See [`DeleteDomain`](crate::client::fluent_builders::DeleteDomain) for more information about the
    /// operation and its arguments.
    pub fn delete_domain(&self) -> fluent_builders::DeleteDomain<C, M, R> {
        fluent_builders::DeleteDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDomainEntry` operation.
    ///
    /// See [`DeleteDomainEntry`](crate::client::fluent_builders::DeleteDomainEntry) for more information about the
    /// operation and its arguments.
    pub fn delete_domain_entry(&self) -> fluent_builders::DeleteDomainEntry<C, M, R> {
        fluent_builders::DeleteDomainEntry::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteInstance` operation.
    ///
    /// See [`DeleteInstance`](crate::client::fluent_builders::DeleteInstance) for more information about the
    /// operation and its arguments.
    pub fn delete_instance(&self) -> fluent_builders::DeleteInstance<C, M, R> {
        fluent_builders::DeleteInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteInstanceSnapshot` operation.
    ///
    /// See [`DeleteInstanceSnapshot`](crate::client::fluent_builders::DeleteInstanceSnapshot) for more information about the
    /// operation and its arguments.
    pub fn delete_instance_snapshot(&self) -> fluent_builders::DeleteInstanceSnapshot<C, M, R> {
        fluent_builders::DeleteInstanceSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteKeyPair` operation.
    ///
    /// See [`DeleteKeyPair`](crate::client::fluent_builders::DeleteKeyPair) for more information about the
    /// operation and its arguments.
    pub fn delete_key_pair(&self) -> fluent_builders::DeleteKeyPair<C, M, R> {
        fluent_builders::DeleteKeyPair::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteKnownHostKeys` operation.
    ///
    /// See [`DeleteKnownHostKeys`](crate::client::fluent_builders::DeleteKnownHostKeys) for more information about the
    /// operation and its arguments.
    pub fn delete_known_host_keys(&self) -> fluent_builders::DeleteKnownHostKeys<C, M, R> {
        fluent_builders::DeleteKnownHostKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLoadBalancer` operation.
    ///
    /// See [`DeleteLoadBalancer`](crate::client::fluent_builders::DeleteLoadBalancer) for more information about the
    /// operation and its arguments.
    pub fn delete_load_balancer(&self) -> fluent_builders::DeleteLoadBalancer<C, M, R> {
        fluent_builders::DeleteLoadBalancer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLoadBalancerTlsCertificate` operation.
    ///
    /// See [`DeleteLoadBalancerTlsCertificate`](crate::client::fluent_builders::DeleteLoadBalancerTlsCertificate) for more information about the
    /// operation and its arguments.
    pub fn delete_load_balancer_tls_certificate(
        &self,
    ) -> fluent_builders::DeleteLoadBalancerTlsCertificate<C, M, R> {
        fluent_builders::DeleteLoadBalancerTlsCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRelationalDatabase` operation.
    ///
    /// See [`DeleteRelationalDatabase`](crate::client::fluent_builders::DeleteRelationalDatabase) for more information about the
    /// operation and its arguments.
    pub fn delete_relational_database(&self) -> fluent_builders::DeleteRelationalDatabase<C, M, R> {
        fluent_builders::DeleteRelationalDatabase::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRelationalDatabaseSnapshot` operation.
    ///
    /// See [`DeleteRelationalDatabaseSnapshot`](crate::client::fluent_builders::DeleteRelationalDatabaseSnapshot) for more information about the
    /// operation and its arguments.
    pub fn delete_relational_database_snapshot(
        &self,
    ) -> fluent_builders::DeleteRelationalDatabaseSnapshot<C, M, R> {
        fluent_builders::DeleteRelationalDatabaseSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachCertificateFromDistribution` operation.
    ///
    /// See [`DetachCertificateFromDistribution`](crate::client::fluent_builders::DetachCertificateFromDistribution) for more information about the
    /// operation and its arguments.
    pub fn detach_certificate_from_distribution(
        &self,
    ) -> fluent_builders::DetachCertificateFromDistribution<C, M, R> {
        fluent_builders::DetachCertificateFromDistribution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachDisk` operation.
    ///
    /// See [`DetachDisk`](crate::client::fluent_builders::DetachDisk) for more information about the
    /// operation and its arguments.
    pub fn detach_disk(&self) -> fluent_builders::DetachDisk<C, M, R> {
        fluent_builders::DetachDisk::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachInstancesFromLoadBalancer` operation.
    ///
    /// See [`DetachInstancesFromLoadBalancer`](crate::client::fluent_builders::DetachInstancesFromLoadBalancer) for more information about the
    /// operation and its arguments.
    pub fn detach_instances_from_load_balancer(
        &self,
    ) -> fluent_builders::DetachInstancesFromLoadBalancer<C, M, R> {
        fluent_builders::DetachInstancesFromLoadBalancer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetachStaticIp` operation.
    ///
    /// See [`DetachStaticIp`](crate::client::fluent_builders::DetachStaticIp) for more information about the
    /// operation and its arguments.
    pub fn detach_static_ip(&self) -> fluent_builders::DetachStaticIp<C, M, R> {
        fluent_builders::DetachStaticIp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableAddOn` operation.
    ///
    /// See [`DisableAddOn`](crate::client::fluent_builders::DisableAddOn) for more information about the
    /// operation and its arguments.
    pub fn disable_add_on(&self) -> fluent_builders::DisableAddOn<C, M, R> {
        fluent_builders::DisableAddOn::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DownloadDefaultKeyPair` operation.
    ///
    /// See [`DownloadDefaultKeyPair`](crate::client::fluent_builders::DownloadDefaultKeyPair) for more information about the
    /// operation and its arguments.
    pub fn download_default_key_pair(&self) -> fluent_builders::DownloadDefaultKeyPair<C, M, R> {
        fluent_builders::DownloadDefaultKeyPair::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableAddOn` operation.
    ///
    /// See [`EnableAddOn`](crate::client::fluent_builders::EnableAddOn) for more information about the
    /// operation and its arguments.
    pub fn enable_add_on(&self) -> fluent_builders::EnableAddOn<C, M, R> {
        fluent_builders::EnableAddOn::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExportSnapshot` operation.
    ///
    /// See [`ExportSnapshot`](crate::client::fluent_builders::ExportSnapshot) for more information about the
    /// operation and its arguments.
    pub fn export_snapshot(&self) -> fluent_builders::ExportSnapshot<C, M, R> {
        fluent_builders::ExportSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetActiveNames` operation.
    ///
    /// See [`GetActiveNames`](crate::client::fluent_builders::GetActiveNames) for more information about the
    /// operation and its arguments.
    pub fn get_active_names(&self) -> fluent_builders::GetActiveNames<C, M, R> {
        fluent_builders::GetActiveNames::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAlarms` operation.
    ///
    /// See [`GetAlarms`](crate::client::fluent_builders::GetAlarms) for more information about the
    /// operation and its arguments.
    pub fn get_alarms(&self) -> fluent_builders::GetAlarms<C, M, R> {
        fluent_builders::GetAlarms::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAutoSnapshots` operation.
    ///
    /// See [`GetAutoSnapshots`](crate::client::fluent_builders::GetAutoSnapshots) for more information about the
    /// operation and its arguments.
    pub fn get_auto_snapshots(&self) -> fluent_builders::GetAutoSnapshots<C, M, R> {
        fluent_builders::GetAutoSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBlueprints` operation.
    ///
    /// See [`GetBlueprints`](crate::client::fluent_builders::GetBlueprints) for more information about the
    /// operation and its arguments.
    pub fn get_blueprints(&self) -> fluent_builders::GetBlueprints<C, M, R> {
        fluent_builders::GetBlueprints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBucketAccessKeys` operation.
    ///
    /// See [`GetBucketAccessKeys`](crate::client::fluent_builders::GetBucketAccessKeys) for more information about the
    /// operation and its arguments.
    pub fn get_bucket_access_keys(&self) -> fluent_builders::GetBucketAccessKeys<C, M, R> {
        fluent_builders::GetBucketAccessKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBucketBundles` operation.
    ///
    /// See [`GetBucketBundles`](crate::client::fluent_builders::GetBucketBundles) for more information about the
    /// operation and its arguments.
    pub fn get_bucket_bundles(&self) -> fluent_builders::GetBucketBundles<C, M, R> {
        fluent_builders::GetBucketBundles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBucketMetricData` operation.
    ///
    /// See [`GetBucketMetricData`](crate::client::fluent_builders::GetBucketMetricData) for more information about the
    /// operation and its arguments.
    pub fn get_bucket_metric_data(&self) -> fluent_builders::GetBucketMetricData<C, M, R> {
        fluent_builders::GetBucketMetricData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBuckets` operation.
    ///
    /// See [`GetBuckets`](crate::client::fluent_builders::GetBuckets) for more information about the
    /// operation and its arguments.
    pub fn get_buckets(&self) -> fluent_builders::GetBuckets<C, M, R> {
        fluent_builders::GetBuckets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBundles` operation.
    ///
    /// See [`GetBundles`](crate::client::fluent_builders::GetBundles) for more information about the
    /// operation and its arguments.
    pub fn get_bundles(&self) -> fluent_builders::GetBundles<C, M, R> {
        fluent_builders::GetBundles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCertificates` operation.
    ///
    /// See [`GetCertificates`](crate::client::fluent_builders::GetCertificates) for more information about the
    /// operation and its arguments.
    pub fn get_certificates(&self) -> fluent_builders::GetCertificates<C, M, R> {
        fluent_builders::GetCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCloudFormationStackRecords` operation.
    ///
    /// See [`GetCloudFormationStackRecords`](crate::client::fluent_builders::GetCloudFormationStackRecords) for more information about the
    /// operation and its arguments.
    pub fn get_cloud_formation_stack_records(
        &self,
    ) -> fluent_builders::GetCloudFormationStackRecords<C, M, R> {
        fluent_builders::GetCloudFormationStackRecords::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetContactMethods` operation.
    ///
    /// See [`GetContactMethods`](crate::client::fluent_builders::GetContactMethods) for more information about the
    /// operation and its arguments.
    pub fn get_contact_methods(&self) -> fluent_builders::GetContactMethods<C, M, R> {
        fluent_builders::GetContactMethods::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetContainerAPIMetadata` operation.
    ///
    /// See [`GetContainerAPIMetadata`](crate::client::fluent_builders::GetContainerAPIMetadata) for more information about the
    /// operation and its arguments.
    pub fn get_container_api_metadata(&self) -> fluent_builders::GetContainerAPIMetadata<C, M, R> {
        fluent_builders::GetContainerAPIMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetContainerImages` operation.
    ///
    /// See [`GetContainerImages`](crate::client::fluent_builders::GetContainerImages) for more information about the
    /// operation and its arguments.
    pub fn get_container_images(&self) -> fluent_builders::GetContainerImages<C, M, R> {
        fluent_builders::GetContainerImages::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetContainerLog` operation.
    ///
    /// See [`GetContainerLog`](crate::client::fluent_builders::GetContainerLog) for more information about the
    /// operation and its arguments.
    pub fn get_container_log(&self) -> fluent_builders::GetContainerLog<C, M, R> {
        fluent_builders::GetContainerLog::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetContainerServiceDeployments` operation.
    ///
    /// See [`GetContainerServiceDeployments`](crate::client::fluent_builders::GetContainerServiceDeployments) for more information about the
    /// operation and its arguments.
    pub fn get_container_service_deployments(
        &self,
    ) -> fluent_builders::GetContainerServiceDeployments<C, M, R> {
        fluent_builders::GetContainerServiceDeployments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetContainerServiceMetricData` operation.
    ///
    /// See [`GetContainerServiceMetricData`](crate::client::fluent_builders::GetContainerServiceMetricData) for more information about the
    /// operation and its arguments.
    pub fn get_container_service_metric_data(
        &self,
    ) -> fluent_builders::GetContainerServiceMetricData<C, M, R> {
        fluent_builders::GetContainerServiceMetricData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetContainerServicePowers` operation.
    ///
    /// See [`GetContainerServicePowers`](crate::client::fluent_builders::GetContainerServicePowers) for more information about the
    /// operation and its arguments.
    pub fn get_container_service_powers(
        &self,
    ) -> fluent_builders::GetContainerServicePowers<C, M, R> {
        fluent_builders::GetContainerServicePowers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetContainerServices` operation.
    ///
    /// See [`GetContainerServices`](crate::client::fluent_builders::GetContainerServices) for more information about the
    /// operation and its arguments.
    pub fn get_container_services(&self) -> fluent_builders::GetContainerServices<C, M, R> {
        fluent_builders::GetContainerServices::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDisk` operation.
    ///
    /// See [`GetDisk`](crate::client::fluent_builders::GetDisk) for more information about the
    /// operation and its arguments.
    pub fn get_disk(&self) -> fluent_builders::GetDisk<C, M, R> {
        fluent_builders::GetDisk::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDisks` operation.
    ///
    /// See [`GetDisks`](crate::client::fluent_builders::GetDisks) for more information about the
    /// operation and its arguments.
    pub fn get_disks(&self) -> fluent_builders::GetDisks<C, M, R> {
        fluent_builders::GetDisks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDiskSnapshot` operation.
    ///
    /// See [`GetDiskSnapshot`](crate::client::fluent_builders::GetDiskSnapshot) for more information about the
    /// operation and its arguments.
    pub fn get_disk_snapshot(&self) -> fluent_builders::GetDiskSnapshot<C, M, R> {
        fluent_builders::GetDiskSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDiskSnapshots` operation.
    ///
    /// See [`GetDiskSnapshots`](crate::client::fluent_builders::GetDiskSnapshots) for more information about the
    /// operation and its arguments.
    pub fn get_disk_snapshots(&self) -> fluent_builders::GetDiskSnapshots<C, M, R> {
        fluent_builders::GetDiskSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDistributionBundles` operation.
    ///
    /// See [`GetDistributionBundles`](crate::client::fluent_builders::GetDistributionBundles) for more information about the
    /// operation and its arguments.
    pub fn get_distribution_bundles(&self) -> fluent_builders::GetDistributionBundles<C, M, R> {
        fluent_builders::GetDistributionBundles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDistributionLatestCacheReset` operation.
    ///
    /// See [`GetDistributionLatestCacheReset`](crate::client::fluent_builders::GetDistributionLatestCacheReset) for more information about the
    /// operation and its arguments.
    pub fn get_distribution_latest_cache_reset(
        &self,
    ) -> fluent_builders::GetDistributionLatestCacheReset<C, M, R> {
        fluent_builders::GetDistributionLatestCacheReset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDistributionMetricData` operation.
    ///
    /// See [`GetDistributionMetricData`](crate::client::fluent_builders::GetDistributionMetricData) for more information about the
    /// operation and its arguments.
    pub fn get_distribution_metric_data(
        &self,
    ) -> fluent_builders::GetDistributionMetricData<C, M, R> {
        fluent_builders::GetDistributionMetricData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDistributions` operation.
    ///
    /// See [`GetDistributions`](crate::client::fluent_builders::GetDistributions) for more information about the
    /// operation and its arguments.
    pub fn get_distributions(&self) -> fluent_builders::GetDistributions<C, M, R> {
        fluent_builders::GetDistributions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDomain` operation.
    ///
    /// See [`GetDomain`](crate::client::fluent_builders::GetDomain) for more information about the
    /// operation and its arguments.
    pub fn get_domain(&self) -> fluent_builders::GetDomain<C, M, R> {
        fluent_builders::GetDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDomains` operation.
    ///
    /// See [`GetDomains`](crate::client::fluent_builders::GetDomains) for more information about the
    /// operation and its arguments.
    pub fn get_domains(&self) -> fluent_builders::GetDomains<C, M, R> {
        fluent_builders::GetDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetExportSnapshotRecords` operation.
    ///
    /// See [`GetExportSnapshotRecords`](crate::client::fluent_builders::GetExportSnapshotRecords) for more information about the
    /// operation and its arguments.
    pub fn get_export_snapshot_records(
        &self,
    ) -> fluent_builders::GetExportSnapshotRecords<C, M, R> {
        fluent_builders::GetExportSnapshotRecords::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInstance` operation.
    ///
    /// See [`GetInstance`](crate::client::fluent_builders::GetInstance) for more information about the
    /// operation and its arguments.
    pub fn get_instance(&self) -> fluent_builders::GetInstance<C, M, R> {
        fluent_builders::GetInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInstanceAccessDetails` operation.
    ///
    /// See [`GetInstanceAccessDetails`](crate::client::fluent_builders::GetInstanceAccessDetails) for more information about the
    /// operation and its arguments.
    pub fn get_instance_access_details(
        &self,
    ) -> fluent_builders::GetInstanceAccessDetails<C, M, R> {
        fluent_builders::GetInstanceAccessDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInstanceMetricData` operation.
    ///
    /// See [`GetInstanceMetricData`](crate::client::fluent_builders::GetInstanceMetricData) for more information about the
    /// operation and its arguments.
    pub fn get_instance_metric_data(&self) -> fluent_builders::GetInstanceMetricData<C, M, R> {
        fluent_builders::GetInstanceMetricData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInstancePortStates` operation.
    ///
    /// See [`GetInstancePortStates`](crate::client::fluent_builders::GetInstancePortStates) for more information about the
    /// operation and its arguments.
    pub fn get_instance_port_states(&self) -> fluent_builders::GetInstancePortStates<C, M, R> {
        fluent_builders::GetInstancePortStates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInstances` operation.
    ///
    /// See [`GetInstances`](crate::client::fluent_builders::GetInstances) for more information about the
    /// operation and its arguments.
    pub fn get_instances(&self) -> fluent_builders::GetInstances<C, M, R> {
        fluent_builders::GetInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInstanceSnapshot` operation.
    ///
    /// See [`GetInstanceSnapshot`](crate::client::fluent_builders::GetInstanceSnapshot) for more information about the
    /// operation and its arguments.
    pub fn get_instance_snapshot(&self) -> fluent_builders::GetInstanceSnapshot<C, M, R> {
        fluent_builders::GetInstanceSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInstanceSnapshots` operation.
    ///
    /// See [`GetInstanceSnapshots`](crate::client::fluent_builders::GetInstanceSnapshots) for more information about the
    /// operation and its arguments.
    pub fn get_instance_snapshots(&self) -> fluent_builders::GetInstanceSnapshots<C, M, R> {
        fluent_builders::GetInstanceSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInstanceState` operation.
    ///
    /// See [`GetInstanceState`](crate::client::fluent_builders::GetInstanceState) for more information about the
    /// operation and its arguments.
    pub fn get_instance_state(&self) -> fluent_builders::GetInstanceState<C, M, R> {
        fluent_builders::GetInstanceState::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetKeyPair` operation.
    ///
    /// See [`GetKeyPair`](crate::client::fluent_builders::GetKeyPair) for more information about the
    /// operation and its arguments.
    pub fn get_key_pair(&self) -> fluent_builders::GetKeyPair<C, M, R> {
        fluent_builders::GetKeyPair::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetKeyPairs` operation.
    ///
    /// See [`GetKeyPairs`](crate::client::fluent_builders::GetKeyPairs) for more information about the
    /// operation and its arguments.
    pub fn get_key_pairs(&self) -> fluent_builders::GetKeyPairs<C, M, R> {
        fluent_builders::GetKeyPairs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLoadBalancer` operation.
    ///
    /// See [`GetLoadBalancer`](crate::client::fluent_builders::GetLoadBalancer) for more information about the
    /// operation and its arguments.
    pub fn get_load_balancer(&self) -> fluent_builders::GetLoadBalancer<C, M, R> {
        fluent_builders::GetLoadBalancer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLoadBalancerMetricData` operation.
    ///
    /// See [`GetLoadBalancerMetricData`](crate::client::fluent_builders::GetLoadBalancerMetricData) for more information about the
    /// operation and its arguments.
    pub fn get_load_balancer_metric_data(
        &self,
    ) -> fluent_builders::GetLoadBalancerMetricData<C, M, R> {
        fluent_builders::GetLoadBalancerMetricData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLoadBalancers` operation.
    ///
    /// See [`GetLoadBalancers`](crate::client::fluent_builders::GetLoadBalancers) for more information about the
    /// operation and its arguments.
    pub fn get_load_balancers(&self) -> fluent_builders::GetLoadBalancers<C, M, R> {
        fluent_builders::GetLoadBalancers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLoadBalancerTlsCertificates` operation.
    ///
    /// See [`GetLoadBalancerTlsCertificates`](crate::client::fluent_builders::GetLoadBalancerTlsCertificates) for more information about the
    /// operation and its arguments.
    pub fn get_load_balancer_tls_certificates(
        &self,
    ) -> fluent_builders::GetLoadBalancerTlsCertificates<C, M, R> {
        fluent_builders::GetLoadBalancerTlsCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetOperation` operation.
    ///
    /// See [`GetOperation`](crate::client::fluent_builders::GetOperation) for more information about the
    /// operation and its arguments.
    pub fn get_operation(&self) -> fluent_builders::GetOperation<C, M, R> {
        fluent_builders::GetOperation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetOperations` operation.
    ///
    /// See [`GetOperations`](crate::client::fluent_builders::GetOperations) for more information about the
    /// operation and its arguments.
    pub fn get_operations(&self) -> fluent_builders::GetOperations<C, M, R> {
        fluent_builders::GetOperations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetOperationsForResource` operation.
    ///
    /// See [`GetOperationsForResource`](crate::client::fluent_builders::GetOperationsForResource) for more information about the
    /// operation and its arguments.
    pub fn get_operations_for_resource(
        &self,
    ) -> fluent_builders::GetOperationsForResource<C, M, R> {
        fluent_builders::GetOperationsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRegions` operation.
    ///
    /// See [`GetRegions`](crate::client::fluent_builders::GetRegions) for more information about the
    /// operation and its arguments.
    pub fn get_regions(&self) -> fluent_builders::GetRegions<C, M, R> {
        fluent_builders::GetRegions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRelationalDatabase` operation.
    ///
    /// See [`GetRelationalDatabase`](crate::client::fluent_builders::GetRelationalDatabase) for more information about the
    /// operation and its arguments.
    pub fn get_relational_database(&self) -> fluent_builders::GetRelationalDatabase<C, M, R> {
        fluent_builders::GetRelationalDatabase::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRelationalDatabaseBlueprints` operation.
    ///
    /// See [`GetRelationalDatabaseBlueprints`](crate::client::fluent_builders::GetRelationalDatabaseBlueprints) for more information about the
    /// operation and its arguments.
    pub fn get_relational_database_blueprints(
        &self,
    ) -> fluent_builders::GetRelationalDatabaseBlueprints<C, M, R> {
        fluent_builders::GetRelationalDatabaseBlueprints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRelationalDatabaseBundles` operation.
    ///
    /// See [`GetRelationalDatabaseBundles`](crate::client::fluent_builders::GetRelationalDatabaseBundles) for more information about the
    /// operation and its arguments.
    pub fn get_relational_database_bundles(
        &self,
    ) -> fluent_builders::GetRelationalDatabaseBundles<C, M, R> {
        fluent_builders::GetRelationalDatabaseBundles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRelationalDatabaseEvents` operation.
    ///
    /// See [`GetRelationalDatabaseEvents`](crate::client::fluent_builders::GetRelationalDatabaseEvents) for more information about the
    /// operation and its arguments.
    pub fn get_relational_database_events(
        &self,
    ) -> fluent_builders::GetRelationalDatabaseEvents<C, M, R> {
        fluent_builders::GetRelationalDatabaseEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRelationalDatabaseLogEvents` operation.
    ///
    /// See [`GetRelationalDatabaseLogEvents`](crate::client::fluent_builders::GetRelationalDatabaseLogEvents) for more information about the
    /// operation and its arguments.
    pub fn get_relational_database_log_events(
        &self,
    ) -> fluent_builders::GetRelationalDatabaseLogEvents<C, M, R> {
        fluent_builders::GetRelationalDatabaseLogEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRelationalDatabaseLogStreams` operation.
    ///
    /// See [`GetRelationalDatabaseLogStreams`](crate::client::fluent_builders::GetRelationalDatabaseLogStreams) for more information about the
    /// operation and its arguments.
    pub fn get_relational_database_log_streams(
        &self,
    ) -> fluent_builders::GetRelationalDatabaseLogStreams<C, M, R> {
        fluent_builders::GetRelationalDatabaseLogStreams::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRelationalDatabaseMasterUserPassword` operation.
    ///
    /// See [`GetRelationalDatabaseMasterUserPassword`](crate::client::fluent_builders::GetRelationalDatabaseMasterUserPassword) for more information about the
    /// operation and its arguments.
    pub fn get_relational_database_master_user_password(
        &self,
    ) -> fluent_builders::GetRelationalDatabaseMasterUserPassword<C, M, R> {
        fluent_builders::GetRelationalDatabaseMasterUserPassword::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRelationalDatabaseMetricData` operation.
    ///
    /// See [`GetRelationalDatabaseMetricData`](crate::client::fluent_builders::GetRelationalDatabaseMetricData) for more information about the
    /// operation and its arguments.
    pub fn get_relational_database_metric_data(
        &self,
    ) -> fluent_builders::GetRelationalDatabaseMetricData<C, M, R> {
        fluent_builders::GetRelationalDatabaseMetricData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRelationalDatabaseParameters` operation.
    ///
    /// See [`GetRelationalDatabaseParameters`](crate::client::fluent_builders::GetRelationalDatabaseParameters) for more information about the
    /// operation and its arguments.
    pub fn get_relational_database_parameters(
        &self,
    ) -> fluent_builders::GetRelationalDatabaseParameters<C, M, R> {
        fluent_builders::GetRelationalDatabaseParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRelationalDatabases` operation.
    ///
    /// See [`GetRelationalDatabases`](crate::client::fluent_builders::GetRelationalDatabases) for more information about the
    /// operation and its arguments.
    pub fn get_relational_databases(&self) -> fluent_builders::GetRelationalDatabases<C, M, R> {
        fluent_builders::GetRelationalDatabases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRelationalDatabaseSnapshot` operation.
    ///
    /// See [`GetRelationalDatabaseSnapshot`](crate::client::fluent_builders::GetRelationalDatabaseSnapshot) for more information about the
    /// operation and its arguments.
    pub fn get_relational_database_snapshot(
        &self,
    ) -> fluent_builders::GetRelationalDatabaseSnapshot<C, M, R> {
        fluent_builders::GetRelationalDatabaseSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetRelationalDatabaseSnapshots` operation.
    ///
    /// See [`GetRelationalDatabaseSnapshots`](crate::client::fluent_builders::GetRelationalDatabaseSnapshots) for more information about the
    /// operation and its arguments.
    pub fn get_relational_database_snapshots(
        &self,
    ) -> fluent_builders::GetRelationalDatabaseSnapshots<C, M, R> {
        fluent_builders::GetRelationalDatabaseSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetStaticIp` operation.
    ///
    /// See [`GetStaticIp`](crate::client::fluent_builders::GetStaticIp) for more information about the
    /// operation and its arguments.
    pub fn get_static_ip(&self) -> fluent_builders::GetStaticIp<C, M, R> {
        fluent_builders::GetStaticIp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetStaticIps` operation.
    ///
    /// See [`GetStaticIps`](crate::client::fluent_builders::GetStaticIps) for more information about the
    /// operation and its arguments.
    pub fn get_static_ips(&self) -> fluent_builders::GetStaticIps<C, M, R> {
        fluent_builders::GetStaticIps::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportKeyPair` operation.
    ///
    /// See [`ImportKeyPair`](crate::client::fluent_builders::ImportKeyPair) for more information about the
    /// operation and its arguments.
    pub fn import_key_pair(&self) -> fluent_builders::ImportKeyPair<C, M, R> {
        fluent_builders::ImportKeyPair::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `IsVpcPeered` operation.
    ///
    /// See [`IsVpcPeered`](crate::client::fluent_builders::IsVpcPeered) for more information about the
    /// operation and its arguments.
    pub fn is_vpc_peered(&self) -> fluent_builders::IsVpcPeered<C, M, R> {
        fluent_builders::IsVpcPeered::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `OpenInstancePublicPorts` operation.
    ///
    /// See [`OpenInstancePublicPorts`](crate::client::fluent_builders::OpenInstancePublicPorts) for more information about the
    /// operation and its arguments.
    pub fn open_instance_public_ports(&self) -> fluent_builders::OpenInstancePublicPorts<C, M, R> {
        fluent_builders::OpenInstancePublicPorts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PeerVpc` operation.
    ///
    /// See [`PeerVpc`](crate::client::fluent_builders::PeerVpc) for more information about the
    /// operation and its arguments.
    pub fn peer_vpc(&self) -> fluent_builders::PeerVpc<C, M, R> {
        fluent_builders::PeerVpc::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutAlarm` operation.
    ///
    /// See [`PutAlarm`](crate::client::fluent_builders::PutAlarm) for more information about the
    /// operation and its arguments.
    pub fn put_alarm(&self) -> fluent_builders::PutAlarm<C, M, R> {
        fluent_builders::PutAlarm::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutInstancePublicPorts` operation.
    ///
    /// See [`PutInstancePublicPorts`](crate::client::fluent_builders::PutInstancePublicPorts) for more information about the
    /// operation and its arguments.
    pub fn put_instance_public_ports(&self) -> fluent_builders::PutInstancePublicPorts<C, M, R> {
        fluent_builders::PutInstancePublicPorts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RebootInstance` operation.
    ///
    /// See [`RebootInstance`](crate::client::fluent_builders::RebootInstance) for more information about the
    /// operation and its arguments.
    pub fn reboot_instance(&self) -> fluent_builders::RebootInstance<C, M, R> {
        fluent_builders::RebootInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RebootRelationalDatabase` operation.
    ///
    /// See [`RebootRelationalDatabase`](crate::client::fluent_builders::RebootRelationalDatabase) for more information about the
    /// operation and its arguments.
    pub fn reboot_relational_database(&self) -> fluent_builders::RebootRelationalDatabase<C, M, R> {
        fluent_builders::RebootRelationalDatabase::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RegisterContainerImage` operation.
    ///
    /// See [`RegisterContainerImage`](crate::client::fluent_builders::RegisterContainerImage) for more information about the
    /// operation and its arguments.
    pub fn register_container_image(&self) -> fluent_builders::RegisterContainerImage<C, M, R> {
        fluent_builders::RegisterContainerImage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ReleaseStaticIp` operation.
    ///
    /// See [`ReleaseStaticIp`](crate::client::fluent_builders::ReleaseStaticIp) for more information about the
    /// operation and its arguments.
    pub fn release_static_ip(&self) -> fluent_builders::ReleaseStaticIp<C, M, R> {
        fluent_builders::ReleaseStaticIp::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetDistributionCache` operation.
    ///
    /// See [`ResetDistributionCache`](crate::client::fluent_builders::ResetDistributionCache) for more information about the
    /// operation and its arguments.
    pub fn reset_distribution_cache(&self) -> fluent_builders::ResetDistributionCache<C, M, R> {
        fluent_builders::ResetDistributionCache::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendContactMethodVerification` operation.
    ///
    /// See [`SendContactMethodVerification`](crate::client::fluent_builders::SendContactMethodVerification) for more information about the
    /// operation and its arguments.
    pub fn send_contact_method_verification(
        &self,
    ) -> fluent_builders::SendContactMethodVerification<C, M, R> {
        fluent_builders::SendContactMethodVerification::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetIpAddressType` operation.
    ///
    /// See [`SetIpAddressType`](crate::client::fluent_builders::SetIpAddressType) for more information about the
    /// operation and its arguments.
    pub fn set_ip_address_type(&self) -> fluent_builders::SetIpAddressType<C, M, R> {
        fluent_builders::SetIpAddressType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SetResourceAccessForBucket` operation.
    ///
    /// See [`SetResourceAccessForBucket`](crate::client::fluent_builders::SetResourceAccessForBucket) for more information about the
    /// operation and its arguments.
    pub fn set_resource_access_for_bucket(
        &self,
    ) -> fluent_builders::SetResourceAccessForBucket<C, M, R> {
        fluent_builders::SetResourceAccessForBucket::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartInstance` operation.
    ///
    /// See [`StartInstance`](crate::client::fluent_builders::StartInstance) for more information about the
    /// operation and its arguments.
    pub fn start_instance(&self) -> fluent_builders::StartInstance<C, M, R> {
        fluent_builders::StartInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartRelationalDatabase` operation.
    ///
    /// See [`StartRelationalDatabase`](crate::client::fluent_builders::StartRelationalDatabase) for more information about the
    /// operation and its arguments.
    pub fn start_relational_database(&self) -> fluent_builders::StartRelationalDatabase<C, M, R> {
        fluent_builders::StartRelationalDatabase::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopInstance` operation.
    ///
    /// See [`StopInstance`](crate::client::fluent_builders::StopInstance) for more information about the
    /// operation and its arguments.
    pub fn stop_instance(&self) -> fluent_builders::StopInstance<C, M, R> {
        fluent_builders::StopInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopRelationalDatabase` operation.
    ///
    /// See [`StopRelationalDatabase`](crate::client::fluent_builders::StopRelationalDatabase) for more information about the
    /// operation and its arguments.
    pub fn stop_relational_database(&self) -> fluent_builders::StopRelationalDatabase<C, M, R> {
        fluent_builders::StopRelationalDatabase::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TestAlarm` operation.
    ///
    /// See [`TestAlarm`](crate::client::fluent_builders::TestAlarm) for more information about the
    /// operation and its arguments.
    pub fn test_alarm(&self) -> fluent_builders::TestAlarm<C, M, R> {
        fluent_builders::TestAlarm::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UnpeerVpc` operation.
    ///
    /// See [`UnpeerVpc`](crate::client::fluent_builders::UnpeerVpc) for more information about the
    /// operation and its arguments.
    pub fn unpeer_vpc(&self) -> fluent_builders::UnpeerVpc<C, M, R> {
        fluent_builders::UnpeerVpc::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBucket` operation.
    ///
    /// See [`UpdateBucket`](crate::client::fluent_builders::UpdateBucket) for more information about the
    /// operation and its arguments.
    pub fn update_bucket(&self) -> fluent_builders::UpdateBucket<C, M, R> {
        fluent_builders::UpdateBucket::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBucketBundle` operation.
    ///
    /// See [`UpdateBucketBundle`](crate::client::fluent_builders::UpdateBucketBundle) for more information about the
    /// operation and its arguments.
    pub fn update_bucket_bundle(&self) -> fluent_builders::UpdateBucketBundle<C, M, R> {
        fluent_builders::UpdateBucketBundle::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateContainerService` operation.
    ///
    /// See [`UpdateContainerService`](crate::client::fluent_builders::UpdateContainerService) for more information about the
    /// operation and its arguments.
    pub fn update_container_service(&self) -> fluent_builders::UpdateContainerService<C, M, R> {
        fluent_builders::UpdateContainerService::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDistribution` operation.
    ///
    /// See [`UpdateDistribution`](crate::client::fluent_builders::UpdateDistribution) for more information about the
    /// operation and its arguments.
    pub fn update_distribution(&self) -> fluent_builders::UpdateDistribution<C, M, R> {
        fluent_builders::UpdateDistribution::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDistributionBundle` operation.
    ///
    /// See [`UpdateDistributionBundle`](crate::client::fluent_builders::UpdateDistributionBundle) for more information about the
    /// operation and its arguments.
    pub fn update_distribution_bundle(&self) -> fluent_builders::UpdateDistributionBundle<C, M, R> {
        fluent_builders::UpdateDistributionBundle::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDomainEntry` operation.
    ///
    /// See [`UpdateDomainEntry`](crate::client::fluent_builders::UpdateDomainEntry) for more information about the
    /// operation and its arguments.
    pub fn update_domain_entry(&self) -> fluent_builders::UpdateDomainEntry<C, M, R> {
        fluent_builders::UpdateDomainEntry::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLoadBalancerAttribute` operation.
    ///
    /// See [`UpdateLoadBalancerAttribute`](crate::client::fluent_builders::UpdateLoadBalancerAttribute) for more information about the
    /// operation and its arguments.
    pub fn update_load_balancer_attribute(
        &self,
    ) -> fluent_builders::UpdateLoadBalancerAttribute<C, M, R> {
        fluent_builders::UpdateLoadBalancerAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRelationalDatabase` operation.
    ///
    /// See [`UpdateRelationalDatabase`](crate::client::fluent_builders::UpdateRelationalDatabase) for more information about the
    /// operation and its arguments.
    pub fn update_relational_database(&self) -> fluent_builders::UpdateRelationalDatabase<C, M, R> {
        fluent_builders::UpdateRelationalDatabase::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRelationalDatabaseParameters` operation.
    ///
    /// See [`UpdateRelationalDatabaseParameters`](crate::client::fluent_builders::UpdateRelationalDatabaseParameters) for more information about the
    /// operation and its arguments.
    pub fn update_relational_database_parameters(
        &self,
    ) -> fluent_builders::UpdateRelationalDatabaseParameters<C, M, R> {
        fluent_builders::UpdateRelationalDatabaseParameters::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AllocateStaticIp`.
    ///
    /// <p>Allocates a static IP address.</p>
    #[derive(std::fmt::Debug)]
    pub struct AllocateStaticIp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::allocate_static_ip_input::Builder,
    }
    impl<C, M, R> AllocateStaticIp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AllocateStaticIp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AllocateStaticIpOutput,
            aws_smithy_http::result::SdkError<crate::error::AllocateStaticIpError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AllocateStaticIpInputOperationOutputAlias,
                crate::output::AllocateStaticIpOutput,
                crate::error::AllocateStaticIpError,
                crate::input::AllocateStaticIpInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the static IP address.</p>
        pub fn static_ip_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.static_ip_name(inp);
            self
        }
        /// <p>The name of the static IP address.</p>
        pub fn set_static_ip_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_static_ip_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachCertificateToDistribution`.
    ///
    /// <p>Attaches an SSL/TLS certificate to your Amazon Lightsail content delivery network (CDN)
    /// distribution.</p>
    /// <p>After the certificate is attached, your distribution accepts HTTPS traffic for all of the
    /// domains that are associated with the certificate.</p>
    /// <p>Use the <code>CreateCertificate</code> action to create a certificate that you can attach
    /// to your distribution.</p>
    /// <important>
    /// <p>Only certificates created in the <code>us-east-1</code> AWS Region can be attached to
    /// Lightsail distributions. Lightsail distributions are global resources that can reference
    /// an origin in any AWS Region, and distribute its content globally. However, all
    /// distributions are located in the <code>us-east-1</code> Region.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct AttachCertificateToDistribution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_certificate_to_distribution_input::Builder,
    }
    impl<C, M, R> AttachCertificateToDistribution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachCertificateToDistribution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachCertificateToDistributionOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachCertificateToDistributionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachCertificateToDistributionInputOperationOutputAlias,
                crate::output::AttachCertificateToDistributionOutput,
                crate::error::AttachCertificateToDistributionError,
                crate::input::AttachCertificateToDistributionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the distribution that the certificate will be attached to.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you
        /// can specify.</p>
        pub fn distribution_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_name(inp);
            self
        }
        /// <p>The name of the distribution that the certificate will be attached to.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you
        /// can specify.</p>
        pub fn set_distribution_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_name(input);
            self
        }
        /// <p>The name of the certificate to attach to a distribution.</p>
        /// <p>Only certificates with a status of <code>ISSUED</code> can be attached to a
        /// distribution.</p>
        /// <p>Use the <code>GetCertificates</code> action to get a list of certificate names that you
        /// can specify.</p>
        /// <note>
        /// <p>This is the name of the certificate resource type and is used only to reference the
        /// certificate in other API actions. It can be different than the domain name of the
        /// certificate. For example, your certificate name might be
        /// <code>WordPress-Blog-Certificate</code> and the domain name of the certificate might be
        /// <code>example.com</code>.</p>
        /// </note>
        pub fn certificate_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_name(inp);
            self
        }
        /// <p>The name of the certificate to attach to a distribution.</p>
        /// <p>Only certificates with a status of <code>ISSUED</code> can be attached to a
        /// distribution.</p>
        /// <p>Use the <code>GetCertificates</code> action to get a list of certificate names that you
        /// can specify.</p>
        /// <note>
        /// <p>This is the name of the certificate resource type and is used only to reference the
        /// certificate in other API actions. It can be different than the domain name of the
        /// certificate. For example, your certificate name might be
        /// <code>WordPress-Blog-Certificate</code> and the domain name of the certificate might be
        /// <code>example.com</code>.</p>
        /// </note>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachDisk`.
    ///
    /// <p>Attaches a block storage disk to a running or stopped Lightsail instance and exposes it
    /// to the instance with the specified disk name.</p>
    /// <p>The <code>attach disk</code> operation supports tag-based access control via resource tags
    /// applied to the resource identified by <code>disk name</code>. For more information, see the
    /// <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AttachDisk<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_disk_input::Builder,
    }
    impl<C, M, R> AttachDisk<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachDisk`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachDiskOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachDiskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachDiskInputOperationOutputAlias,
                crate::output::AttachDiskOutput,
                crate::error::AttachDiskError,
                crate::input::AttachDiskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique Lightsail disk name (e.g., <code>my-disk</code>).</p>
        pub fn disk_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disk_name(inp);
            self
        }
        /// <p>The unique Lightsail disk name (e.g., <code>my-disk</code>).</p>
        pub fn set_disk_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_disk_name(input);
            self
        }
        /// <p>The name of the Lightsail instance where you want to utilize the storage disk.</p>
        pub fn instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_name(inp);
            self
        }
        /// <p>The name of the Lightsail instance where you want to utilize the storage disk.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_name(input);
            self
        }
        /// <p>The disk path to expose to the instance (e.g., <code>/dev/xvdf</code>).</p>
        pub fn disk_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disk_path(inp);
            self
        }
        /// <p>The disk path to expose to the instance (e.g., <code>/dev/xvdf</code>).</p>
        pub fn set_disk_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_disk_path(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachInstancesToLoadBalancer`.
    ///
    /// <p>Attaches one or more Lightsail instances to a load balancer.</p>
    /// <p>After some time, the instances are attached to the load balancer and the health check
    /// status is available.</p>
    /// <p>The <code>attach instances to load balancer</code> operation supports tag-based access
    /// control via resource tags applied to the resource identified by <code>load balancer
    /// name</code>. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AttachInstancesToLoadBalancer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_instances_to_load_balancer_input::Builder,
    }
    impl<C, M, R> AttachInstancesToLoadBalancer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachInstancesToLoadBalancer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachInstancesToLoadBalancerOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachInstancesToLoadBalancerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachInstancesToLoadBalancerInputOperationOutputAlias,
                crate::output::AttachInstancesToLoadBalancerOutput,
                crate::error::AttachInstancesToLoadBalancerError,
                crate::input::AttachInstancesToLoadBalancerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(inp);
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// Appends an item to `instanceNames`.
        ///
        /// To override the contents of this collection use [`set_instance_names`](Self::set_instance_names).
        ///
        /// <p>An array of strings representing the instance name(s) you want to attach to your load
        /// balancer.</p>
        /// <p>An instance must be <code>running</code> before you can attach it to your load
        /// balancer.</p>
        /// <p>There are no additional limits on the number of instances you can attach to your load
        /// balancer, aside from the limit of Lightsail instances you can create in your account
        /// (20).</p>
        pub fn instance_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_names(inp);
            self
        }
        /// <p>An array of strings representing the instance name(s) you want to attach to your load
        /// balancer.</p>
        /// <p>An instance must be <code>running</code> before you can attach it to your load
        /// balancer.</p>
        /// <p>There are no additional limits on the number of instances you can attach to your load
        /// balancer, aside from the limit of Lightsail instances you can create in your account
        /// (20).</p>
        pub fn set_instance_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachLoadBalancerTlsCertificate`.
    ///
    /// <p>Attaches a Transport Layer Security (TLS) certificate to your load balancer. TLS is just
    /// an updated, more secure version of Secure Socket Layer (SSL).</p>
    /// <p>Once you create and validate your certificate, you can attach it to your load balancer.
    /// You can also use this API to rotate the certificates on your account. Use the
    /// <code>AttachLoadBalancerTlsCertificate</code> action with the non-attached certificate, and
    /// it will replace the existing one and become the attached certificate.</p>
    /// <p>The <code>AttachLoadBalancerTlsCertificate</code> operation supports tag-based access
    /// control via resource tags applied to the resource identified by <code>load balancer
    /// name</code>. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AttachLoadBalancerTlsCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_load_balancer_tls_certificate_input::Builder,
    }
    impl<C, M, R> AttachLoadBalancerTlsCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachLoadBalancerTlsCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachLoadBalancerTlsCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachLoadBalancerTlsCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachLoadBalancerTlsCertificateInputOperationOutputAlias,
                crate::output::AttachLoadBalancerTlsCertificateOutput,
                crate::error::AttachLoadBalancerTlsCertificateError,
                crate::input::AttachLoadBalancerTlsCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer to which you want to associate the SSL/TLS
        /// certificate.</p>
        pub fn load_balancer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(inp);
            self
        }
        /// <p>The name of the load balancer to which you want to associate the SSL/TLS
        /// certificate.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// <p>The name of your SSL/TLS certificate.</p>
        pub fn certificate_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_name(inp);
            self
        }
        /// <p>The name of your SSL/TLS certificate.</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AttachStaticIp`.
    ///
    /// <p>Attaches a static IP address to a specific Amazon Lightsail instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct AttachStaticIp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::attach_static_ip_input::Builder,
    }
    impl<C, M, R> AttachStaticIp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AttachStaticIp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AttachStaticIpOutput,
            aws_smithy_http::result::SdkError<crate::error::AttachStaticIpError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AttachStaticIpInputOperationOutputAlias,
                crate::output::AttachStaticIpOutput,
                crate::error::AttachStaticIpError,
                crate::input::AttachStaticIpInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the static IP.</p>
        pub fn static_ip_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.static_ip_name(inp);
            self
        }
        /// <p>The name of the static IP.</p>
        pub fn set_static_ip_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_static_ip_name(input);
            self
        }
        /// <p>The instance name to which you want to attach the static IP address.</p>
        pub fn instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_name(inp);
            self
        }
        /// <p>The instance name to which you want to attach the static IP address.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CloseInstancePublicPorts`.
    ///
    /// <p>Closes ports for a specific Amazon Lightsail instance.</p>
    /// <p>The <code>CloseInstancePublicPorts</code> action supports tag-based access control via
    /// resource tags applied to the resource identified by <code>instanceName</code>. For more
    /// information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CloseInstancePublicPorts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::close_instance_public_ports_input::Builder,
    }
    impl<C, M, R> CloseInstancePublicPorts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CloseInstancePublicPorts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CloseInstancePublicPortsOutput,
            aws_smithy_http::result::SdkError<crate::error::CloseInstancePublicPortsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CloseInstancePublicPortsInputOperationOutputAlias,
                crate::output::CloseInstancePublicPortsOutput,
                crate::error::CloseInstancePublicPortsError,
                crate::input::CloseInstancePublicPortsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An object to describe the ports to close for the specified instance.</p>
        pub fn port_info(mut self, inp: crate::model::PortInfo) -> Self {
            self.inner = self.inner.port_info(inp);
            self
        }
        /// <p>An object to describe the ports to close for the specified instance.</p>
        pub fn set_port_info(mut self, input: std::option::Option<crate::model::PortInfo>) -> Self {
            self.inner = self.inner.set_port_info(input);
            self
        }
        /// <p>The name of the instance for which to close ports.</p>
        pub fn instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_name(inp);
            self
        }
        /// <p>The name of the instance for which to close ports.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopySnapshot`.
    ///
    /// <p>Copies a manual snapshot of an instance or disk as another manual snapshot, or copies an
    /// automatic snapshot of an instance or disk as a manual snapshot. This operation can also be
    /// used to copy a manual or automatic snapshot of an instance or a disk from one AWS Region to
    /// another in Amazon Lightsail.</p>
    /// <p>When copying a <i>manual snapshot</i>, be sure to define the <code>source
    /// region</code>, <code>source snapshot name</code>, and <code>target snapshot name</code>
    /// parameters.</p>
    /// <p>When copying an <i>automatic snapshot</i>, be sure to define the
    /// <code>source region</code>, <code>source resource name</code>, <code>target snapshot
    /// name</code>, and either the <code>restore date</code> or the <code>use latest restorable
    /// auto snapshot</code> parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct CopySnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::copy_snapshot_input::Builder,
    }
    impl<C, M, R> CopySnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CopySnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopySnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CopySnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CopySnapshotInputOperationOutputAlias,
                crate::output::CopySnapshotOutput,
                crate::error::CopySnapshotError,
                crate::input::CopySnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the source manual snapshot to copy.</p>
        /// <p>Constraint:</p>
        /// <ul>
        /// <li>
        /// <p>Define this parameter only when copying a manual snapshot as another manual
        /// snapshot.</p>
        /// </li>
        /// </ul>
        pub fn source_snapshot_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_snapshot_name(inp);
            self
        }
        /// <p>The name of the source manual snapshot to copy.</p>
        /// <p>Constraint:</p>
        /// <ul>
        /// <li>
        /// <p>Define this parameter only when copying a manual snapshot as another manual
        /// snapshot.</p>
        /// </li>
        /// </ul>
        pub fn set_source_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_snapshot_name(input);
            self
        }
        /// <p>The name of the source instance or disk from which the source automatic snapshot was
        /// created.</p>
        /// <p>Constraint:</p>
        /// <ul>
        /// <li>
        /// <p>Define this parameter only when copying an automatic snapshot as a manual snapshot.
        /// For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p>
        /// </li>
        /// </ul>
        pub fn source_resource_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_resource_name(inp);
            self
        }
        /// <p>The name of the source instance or disk from which the source automatic snapshot was
        /// created.</p>
        /// <p>Constraint:</p>
        /// <ul>
        /// <li>
        /// <p>Define this parameter only when copying an automatic snapshot as a manual snapshot.
        /// For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_source_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_resource_name(input);
            self
        }
        /// <p>The date of the source automatic snapshot to copy. Use the <code>get auto snapshots</code>
        /// operation to identify the dates of the available automatic snapshots.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be specified in <code>YYYY-MM-DD</code> format.</p>
        /// </li>
        /// <li>
        /// <p>This parameter cannot be defined together with the <code>use latest restorable auto
        /// snapshot</code> parameter. The <code>restore date</code> and <code>use latest restorable
        /// auto snapshot</code> parameters are mutually exclusive.</p>
        /// </li>
        /// <li>
        /// <p>Define this parameter only when copying an automatic snapshot as a manual snapshot.
        /// For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p>
        /// </li>
        /// </ul>
        pub fn restore_date(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.restore_date(inp);
            self
        }
        /// <p>The date of the source automatic snapshot to copy. Use the <code>get auto snapshots</code>
        /// operation to identify the dates of the available automatic snapshots.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be specified in <code>YYYY-MM-DD</code> format.</p>
        /// </li>
        /// <li>
        /// <p>This parameter cannot be defined together with the <code>use latest restorable auto
        /// snapshot</code> parameter. The <code>restore date</code> and <code>use latest restorable
        /// auto snapshot</code> parameters are mutually exclusive.</p>
        /// </li>
        /// <li>
        /// <p>Define this parameter only when copying an automatic snapshot as a manual snapshot.
        /// For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_restore_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_restore_date(input);
            self
        }
        /// <p>A Boolean value to indicate whether to use the latest available automatic snapshot of the
        /// specified source instance or disk.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>This parameter cannot be defined together with the <code>restore date</code>
        /// parameter. The <code>use latest restorable auto snapshot</code> and <code>restore
        /// date</code> parameters are mutually exclusive.</p>
        /// </li>
        /// <li>
        /// <p>Define this parameter only when copying an automatic snapshot as a manual snapshot.
        /// For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p>
        /// </li>
        /// </ul>
        pub fn use_latest_restorable_auto_snapshot(mut self, inp: bool) -> Self {
            self.inner = self.inner.use_latest_restorable_auto_snapshot(inp);
            self
        }
        /// <p>A Boolean value to indicate whether to use the latest available automatic snapshot of the
        /// specified source instance or disk.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>This parameter cannot be defined together with the <code>restore date</code>
        /// parameter. The <code>use latest restorable auto snapshot</code> and <code>restore
        /// date</code> parameters are mutually exclusive.</p>
        /// </li>
        /// <li>
        /// <p>Define this parameter only when copying an automatic snapshot as a manual snapshot.
        /// For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_use_latest_restorable_auto_snapshot(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_use_latest_restorable_auto_snapshot(input);
            self
        }
        /// <p>The name of the new manual snapshot to be created as a copy.</p>
        pub fn target_snapshot_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_snapshot_name(inp);
            self
        }
        /// <p>The name of the new manual snapshot to be created as a copy.</p>
        pub fn set_target_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_snapshot_name(input);
            self
        }
        /// <p>The AWS Region where the source manual or automatic snapshot is located.</p>
        pub fn source_region(mut self, inp: crate::model::RegionName) -> Self {
            self.inner = self.inner.source_region(inp);
            self
        }
        /// <p>The AWS Region where the source manual or automatic snapshot is located.</p>
        pub fn set_source_region(
            mut self,
            input: std::option::Option<crate::model::RegionName>,
        ) -> Self {
            self.inner = self.inner.set_source_region(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBucket`.
    ///
    /// <p>Creates an Amazon Lightsail bucket.</p>
    ///
    /// <p>A bucket is a cloud storage resource available in the Lightsail object storage service.
    /// Use buckets to store objects such as data and its descriptive metadata. For more information
    /// about buckets, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/buckets-in-amazon-lightsail">Buckets in Amazon Lightsail</a> in the <i>Amazon Lightsail Developer
    /// Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateBucket<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_bucket_input::Builder,
    }
    impl<C, M, R> CreateBucket<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBucket`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBucketOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBucketError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBucketInputOperationOutputAlias,
                crate::output::CreateBucketOutput,
                crate::error::CreateBucketError,
                crate::input::CreateBucketInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the bucket.</p>
        ///
        /// <p>For more information about bucket names, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/bucket-naming-rules-in-amazon-lightsail">Bucket naming rules in Amazon Lightsail</a> in the <i>Amazon Lightsail Developer
        /// Guide</i>.</p>
        pub fn bucket_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket_name(inp);
            self
        }
        /// <p>The name for the bucket.</p>
        ///
        /// <p>For more information about bucket names, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/bucket-naming-rules-in-amazon-lightsail">Bucket naming rules in Amazon Lightsail</a> in the <i>Amazon Lightsail Developer
        /// Guide</i>.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket_name(input);
            self
        }
        /// <p>The ID of the bundle to use for the bucket.</p>
        ///
        /// <p>A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a
        /// bucket.</p>
        ///
        /// <p>Use the <a>GetBucketBundles</a> action to get a list of bundle IDs that you can
        /// specify.</p>
        ///
        /// <p>Use the <a>UpdateBucketBundle</a> action to change the bundle after the bucket
        /// is created.</p>
        pub fn bundle_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bundle_id(inp);
            self
        }
        /// <p>The ID of the bundle to use for the bucket.</p>
        ///
        /// <p>A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a
        /// bucket.</p>
        ///
        /// <p>Use the <a>GetBucketBundles</a> action to get a list of bundle IDs that you can
        /// specify.</p>
        ///
        /// <p>Use the <a>UpdateBucketBundle</a> action to change the bundle after the bucket
        /// is created.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bundle_id(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the bucket during creation.</p>
        ///
        /// <p>Use the <a>TagResource</a> action to tag the bucket after it's created.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag keys and optional values to add to the bucket during creation.</p>
        ///
        /// <p>Use the <a>TagResource</a> action to tag the bucket after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A Boolean value that indicates whether to enable versioning of objects in the
        /// bucket.</p>
        ///
        /// <p>For more information about versioning, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-managing-bucket-object-versioning">Enabling and suspending object versioning in a bucket in Amazon Lightsail</a> in the
        /// <i>Amazon Lightsail Developer Guide</i>.</p>
        pub fn enable_object_versioning(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_object_versioning(inp);
            self
        }
        /// <p>A Boolean value that indicates whether to enable versioning of objects in the
        /// bucket.</p>
        ///
        /// <p>For more information about versioning, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-managing-bucket-object-versioning">Enabling and suspending object versioning in a bucket in Amazon Lightsail</a> in the
        /// <i>Amazon Lightsail Developer Guide</i>.</p>
        pub fn set_enable_object_versioning(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_object_versioning(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBucketAccessKey`.
    ///
    /// <p>Creates a new access key for the specified Amazon Lightsail bucket. Access keys consist of
    /// an access key ID and corresponding secret access key.</p>
    ///
    /// <p>Access keys grant full programmatic access to the specified bucket and its objects. You
    /// can have a maximum of two access keys per bucket. Use the <a>GetBucketAccessKeys</a> action to get a list of current access keys for a specific bucket. For more information
    /// about access keys, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-bucket-access-keys">Creating access keys for a bucket in Amazon Lightsail</a> in the
    /// <i>Amazon Lightsail Developer Guide</i>.</p>
    ///
    /// <important>
    /// <p>The <code>secretAccessKey</code> value is returned only in response to the
    /// <code>CreateBucketAccessKey</code> action. You can get a secret access key only when you
    /// first create an access key; you cannot get the secret access key later. If you lose the
    /// secret access key, you must create a new access key.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct CreateBucketAccessKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_bucket_access_key_input::Builder,
    }
    impl<C, M, R> CreateBucketAccessKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBucketAccessKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBucketAccessKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBucketAccessKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBucketAccessKeyInputOperationOutputAlias,
                crate::output::CreateBucketAccessKeyOutput,
                crate::error::CreateBucketAccessKeyError,
                crate::input::CreateBucketAccessKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket that the new access key will belong to, and grant access to.</p>
        pub fn bucket_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket_name(inp);
            self
        }
        /// <p>The name of the bucket that the new access key will belong to, and grant access to.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCertificate`.
    ///
    /// <p>Creates an SSL/TLS certificate for an Amazon Lightsail content delivery network (CDN)
    /// distribution and a container service.</p>
    /// <p>After the certificate is valid, use the <code>AttachCertificateToDistribution</code>
    /// action to use the certificate and its domains with your distribution. Or use the
    /// <code>UpdateContainerService</code> action to use the certificate and its domains with your
    /// container service.</p>
    /// <important>
    /// <p>Only certificates created in the <code>us-east-1</code> AWS Region can be attached to
    /// Lightsail distributions. Lightsail distributions are global resources that can reference
    /// an origin in any AWS Region, and distribute its content globally. However, all
    /// distributions are located in the <code>us-east-1</code> Region.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct CreateCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_certificate_input::Builder,
    }
    impl<C, M, R> CreateCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCertificateInputOperationOutputAlias,
                crate::output::CreateCertificateOutput,
                crate::error::CreateCertificateError,
                crate::input::CreateCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the certificate.</p>
        pub fn certificate_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_name(inp);
            self
        }
        /// <p>The name for the certificate.</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_name(input);
            self
        }
        /// <p>The domain name (e.g., <code>example.com</code>) for the certificate.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The domain name (e.g., <code>example.com</code>) for the certificate.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// Appends an item to `subjectAlternativeNames`.
        ///
        /// To override the contents of this collection use [`set_subject_alternative_names`](Self::set_subject_alternative_names).
        ///
        /// <p>An array of strings that specify the alternate domains (e.g., <code>example2.com</code>)
        /// and subdomains (e.g., <code>blog.example.com</code>) for the certificate.</p>
        /// <p>You can specify a maximum of nine alternate domains (in addition to the primary domain
        /// name).</p>
        /// <p>Wildcard domain entries (e.g., <code>*.example.com</code>) are not supported.</p>
        pub fn subject_alternative_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subject_alternative_names(inp);
            self
        }
        /// <p>An array of strings that specify the alternate domains (e.g., <code>example2.com</code>)
        /// and subdomains (e.g., <code>blog.example.com</code>) for the certificate.</p>
        /// <p>You can specify a maximum of nine alternate domains (in addition to the primary domain
        /// name).</p>
        /// <p>Wildcard domain entries (e.g., <code>*.example.com</code>) are not supported.</p>
        pub fn set_subject_alternative_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subject_alternative_names(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the certificate during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag keys and optional values to add to the certificate during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCloudFormationStack`.
    ///
    /// <p>Creates an AWS CloudFormation stack, which creates a new Amazon EC2 instance from an exported
    /// Amazon Lightsail snapshot. This operation results in a CloudFormation stack record that can be
    /// used to track the AWS CloudFormation stack created. Use the <code>get cloud formation stack
    /// records</code> operation to get a list of the CloudFormation stacks created.</p>
    /// <important>
    /// <p>Wait until after your new Amazon EC2 instance is created before running the <code>create
    /// cloud formation stack</code> operation again with the same export snapshot record.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct CreateCloudFormationStack<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_cloud_formation_stack_input::Builder,
    }
    impl<C, M, R> CreateCloudFormationStack<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCloudFormationStack`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCloudFormationStackOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCloudFormationStackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCloudFormationStackInputOperationOutputAlias,
                crate::output::CreateCloudFormationStackOutput,
                crate::error::CreateCloudFormationStackError,
                crate::input::CreateCloudFormationStackInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `instances`.
        ///
        /// To override the contents of this collection use [`set_instances`](Self::set_instances).
        ///
        /// <p>An array of parameters that will be used to create the new Amazon EC2 instance. You can only
        /// pass one instance entry at a time in this array. You will get an invalid parameter error if
        /// you pass more than one instance entry in this array.</p>
        pub fn instances(mut self, inp: impl Into<crate::model::InstanceEntry>) -> Self {
            self.inner = self.inner.instances(inp);
            self
        }
        /// <p>An array of parameters that will be used to create the new Amazon EC2 instance. You can only
        /// pass one instance entry at a time in this array. You will get an invalid parameter error if
        /// you pass more than one instance entry in this array.</p>
        pub fn set_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceEntry>>,
        ) -> Self {
            self.inner = self.inner.set_instances(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateContactMethod`.
    ///
    /// <p>Creates an email or SMS text message contact method.</p>
    /// <p>A contact method is used to send you notifications about your Amazon Lightsail resources.
    /// You can add one email address and one mobile phone number contact method in each AWS Region.
    /// However, SMS text messaging is not supported in some AWS Regions, and SMS text messages
    /// cannot be sent to some countries/regions. For more information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in Amazon Lightsail</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateContactMethod<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_contact_method_input::Builder,
    }
    impl<C, M, R> CreateContactMethod<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateContactMethod`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateContactMethodOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateContactMethodError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateContactMethodInputOperationOutputAlias,
                crate::output::CreateContactMethodOutput,
                crate::error::CreateContactMethodError,
                crate::input::CreateContactMethodInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The protocol of the contact method, such as <code>Email</code> or <code>SMS</code> (text
        /// messaging).</p>
        /// <p>The <code>SMS</code> protocol is supported only in the following AWS Regions.</p>
        /// <ul>
        /// <li>
        /// <p>US East (N. Virginia) (<code>us-east-1</code>)</p>
        /// </li>
        /// <li>
        /// <p>US West (Oregon) (<code>us-west-2</code>)</p>
        /// </li>
        /// <li>
        /// <p>Europe (Ireland) (<code>eu-west-1</code>)</p>
        /// </li>
        /// <li>
        /// <p>Asia Pacific (Tokyo) (<code>ap-northeast-1</code>)</p>
        /// </li>
        /// <li>
        /// <p>Asia Pacific (Singapore) (<code>ap-southeast-1</code>)</p>
        /// </li>
        /// <li>
        /// <p>Asia Pacific (Sydney) (<code>ap-southeast-2</code>)</p>
        /// </li>
        /// </ul>
        /// <p>For a list of countries/regions where SMS text messages can be sent, and the latest AWS
        /// Regions where SMS text messaging is supported, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-supported-regions-countries.html">Supported Regions and Countries</a> in the <i>Amazon SNS Developer
        /// Guide</i>.</p>
        /// <p>For more information about notifications in Amazon Lightsail, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in Amazon Lightsail</a>.</p>
        pub fn protocol(mut self, inp: crate::model::ContactProtocol) -> Self {
            self.inner = self.inner.protocol(inp);
            self
        }
        /// <p>The protocol of the contact method, such as <code>Email</code> or <code>SMS</code> (text
        /// messaging).</p>
        /// <p>The <code>SMS</code> protocol is supported only in the following AWS Regions.</p>
        /// <ul>
        /// <li>
        /// <p>US East (N. Virginia) (<code>us-east-1</code>)</p>
        /// </li>
        /// <li>
        /// <p>US West (Oregon) (<code>us-west-2</code>)</p>
        /// </li>
        /// <li>
        /// <p>Europe (Ireland) (<code>eu-west-1</code>)</p>
        /// </li>
        /// <li>
        /// <p>Asia Pacific (Tokyo) (<code>ap-northeast-1</code>)</p>
        /// </li>
        /// <li>
        /// <p>Asia Pacific (Singapore) (<code>ap-southeast-1</code>)</p>
        /// </li>
        /// <li>
        /// <p>Asia Pacific (Sydney) (<code>ap-southeast-2</code>)</p>
        /// </li>
        /// </ul>
        /// <p>For a list of countries/regions where SMS text messages can be sent, and the latest AWS
        /// Regions where SMS text messaging is supported, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-supported-regions-countries.html">Supported Regions and Countries</a> in the <i>Amazon SNS Developer
        /// Guide</i>.</p>
        /// <p>For more information about notifications in Amazon Lightsail, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in Amazon Lightsail</a>.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::ContactProtocol>,
        ) -> Self {
            self.inner = self.inner.set_protocol(input);
            self
        }
        /// <p>The destination of the contact method, such as an email address or a mobile phone
        /// number.</p>
        /// <p>Use the E.164 format when specifying a mobile phone number. E.164 is a standard for the
        /// phone number structure used for international telecommunication. Phone numbers that follow
        /// this format can have a maximum of 15 digits, and they are prefixed with the plus character (+)
        /// and the country code. For example, a U.S. phone number in E.164 format would be specified as
        /// +1XXX5550100. For more information, see <a href="https://en.wikipedia.org/wiki/E.164">E.164</a> on <i>Wikipedia</i>.</p>
        pub fn contact_endpoint(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_endpoint(inp);
            self
        }
        /// <p>The destination of the contact method, such as an email address or a mobile phone
        /// number.</p>
        /// <p>Use the E.164 format when specifying a mobile phone number. E.164 is a standard for the
        /// phone number structure used for international telecommunication. Phone numbers that follow
        /// this format can have a maximum of 15 digits, and they are prefixed with the plus character (+)
        /// and the country code. For example, a U.S. phone number in E.164 format would be specified as
        /// +1XXX5550100. For more information, see <a href="https://en.wikipedia.org/wiki/E.164">E.164</a> on <i>Wikipedia</i>.</p>
        pub fn set_contact_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_endpoint(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateContainerService`.
    ///
    /// <p>Creates an Amazon Lightsail container service.</p>
    ///
    /// <p>A Lightsail container service is a compute resource to which you can deploy containers.
    /// For more information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-services">Container services in Amazon Lightsail</a> in the <i>Lightsail Dev
    /// Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateContainerService<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_container_service_input::Builder,
    }
    impl<C, M, R> CreateContainerService<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateContainerService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateContainerServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateContainerServiceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateContainerServiceInputOperationOutputAlias,
                crate::output::CreateContainerServiceOutput,
                crate::error::CreateContainerServiceError,
                crate::input::CreateContainerServiceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the container service.</p>
        ///
        /// <p>The name that you specify for your container service will make up part of its default
        /// domain. The default domain of a container service is typically
        /// <code>https://<ServiceName>.<RandomGUID>.<AWSRegion>.cs.amazonlightsail.com</code>.
        /// If the name of your container service is <code>container-service-1</code>, and it's located in
        /// the US East (Ohio) AWS region (<code>us-east-2</code>), then the domain for your container
        /// service will be like the following example:
        /// <code>https://container-service-1.ur4EXAMPLE2uq.us-east-2.cs.amazonlightsail.com</code>
        /// </p>
        ///
        /// <p>The following are the requirements for container service names:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Must be unique within each AWS Region in your Lightsail account.</p>
        /// </li>
        /// <li>
        /// <p>Must contain 1 to 63 characters.</p>
        /// </li>
        /// <li>
        /// <p>Must contain only alphanumeric characters and hyphens.</p>
        /// </li>
        /// <li>
        /// <p>A hyphen (-) can separate words but cannot be at the start or end of the name.</p>
        /// </li>
        /// </ul>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>The name for the container service.</p>
        ///
        /// <p>The name that you specify for your container service will make up part of its default
        /// domain. The default domain of a container service is typically
        /// <code>https://<ServiceName>.<RandomGUID>.<AWSRegion>.cs.amazonlightsail.com</code>.
        /// If the name of your container service is <code>container-service-1</code>, and it's located in
        /// the US East (Ohio) AWS region (<code>us-east-2</code>), then the domain for your container
        /// service will be like the following example:
        /// <code>https://container-service-1.ur4EXAMPLE2uq.us-east-2.cs.amazonlightsail.com</code>
        /// </p>
        ///
        /// <p>The following are the requirements for container service names:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Must be unique within each AWS Region in your Lightsail account.</p>
        /// </li>
        /// <li>
        /// <p>Must contain 1 to 63 characters.</p>
        /// </li>
        /// <li>
        /// <p>Must contain only alphanumeric characters and hyphens.</p>
        /// </li>
        /// <li>
        /// <p>A hyphen (-) can separate words but cannot be at the start or end of the name.</p>
        /// </li>
        /// </ul>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
        /// <p>The power specification for the container service.</p>
        ///
        /// <p>The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the
        /// container service. The <code>power</code> and <code>scale</code> of a container service makes
        /// up its configured capacity. To determine the monthly price of your container service, multiply
        /// the base price of the <code>power</code> with the <code>scale</code> (the number of nodes) of
        /// the service.</p>
        ///
        /// <p>Use the <code>GetContainerServicePowers</code> action to get a list of power options that
        /// you can specify using this parameter, and their base monthly cost.</p>
        pub fn power(mut self, inp: crate::model::ContainerServicePowerName) -> Self {
            self.inner = self.inner.power(inp);
            self
        }
        /// <p>The power specification for the container service.</p>
        ///
        /// <p>The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the
        /// container service. The <code>power</code> and <code>scale</code> of a container service makes
        /// up its configured capacity. To determine the monthly price of your container service, multiply
        /// the base price of the <code>power</code> with the <code>scale</code> (the number of nodes) of
        /// the service.</p>
        ///
        /// <p>Use the <code>GetContainerServicePowers</code> action to get a list of power options that
        /// you can specify using this parameter, and their base monthly cost.</p>
        pub fn set_power(
            mut self,
            input: std::option::Option<crate::model::ContainerServicePowerName>,
        ) -> Self {
            self.inner = self.inner.set_power(input);
            self
        }
        /// <p>The scale specification for the container service.</p>
        ///
        /// <p>The scale specifies the allocated compute nodes of the container service. The
        /// <code>power</code> and <code>scale</code> of a container service makes up its configured
        /// capacity. To determine the monthly price of your container service, multiply the base price of
        /// the <code>power</code> with the <code>scale</code> (the number of nodes) of the
        /// service.</p>
        pub fn scale(mut self, inp: i32) -> Self {
            self.inner = self.inner.scale(inp);
            self
        }
        /// <p>The scale specification for the container service.</p>
        ///
        /// <p>The scale specifies the allocated compute nodes of the container service. The
        /// <code>power</code> and <code>scale</code> of a container service makes up its configured
        /// capacity. To determine the monthly price of your container service, multiply the base price of
        /// the <code>power</code> with the <code>scale</code> (the number of nodes) of the
        /// service.</p>
        pub fn set_scale(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_scale(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the container service during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        /// <p>For more information about tags in Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag keys and optional values to add to the container service during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        /// <p>For more information about tags in Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Adds a key-value pair to `publicDomainNames`.
        ///
        /// To override the contents of this collection use [`set_public_domain_names`](Self::set_public_domain_names).
        ///
        /// <p>The public domain names to use with the container service, such as
        /// <code>example.com</code> and <code>www.example.com</code>.</p>
        ///
        /// <p>You can specify up to four public domain names for a container service. The domain names
        /// that you specify are used when you create a deployment with a container configured as the
        /// public endpoint of your container service.</p>
        ///
        /// <p>If you don't specify public domain names, then you can use the default domain of the
        /// container service.</p>
        ///
        /// <important>
        /// <p>You must create and validate an SSL/TLS certificate before you can use public domain
        /// names with your container service. Use the <code>CreateCertificate</code> action to create a
        /// certificate for the public domain names you want to use with your container service.</p>
        /// </important>
        ///
        /// <p>You can specify public domain names using a string to array map as shown in the example
        /// later on this page.</p>
        pub fn public_domain_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.public_domain_names(k, v);
            self
        }
        /// <p>The public domain names to use with the container service, such as
        /// <code>example.com</code> and <code>www.example.com</code>.</p>
        ///
        /// <p>You can specify up to four public domain names for a container service. The domain names
        /// that you specify are used when you create a deployment with a container configured as the
        /// public endpoint of your container service.</p>
        ///
        /// <p>If you don't specify public domain names, then you can use the default domain of the
        /// container service.</p>
        ///
        /// <important>
        /// <p>You must create and validate an SSL/TLS certificate before you can use public domain
        /// names with your container service. Use the <code>CreateCertificate</code> action to create a
        /// certificate for the public domain names you want to use with your container service.</p>
        /// </important>
        ///
        /// <p>You can specify public domain names using a string to array map as shown in the example
        /// later on this page.</p>
        pub fn set_public_domain_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_public_domain_names(input);
            self
        }
        /// <p>An object that describes a deployment for the container service.</p>
        ///
        /// <p>A deployment specifies the containers that will be launched on the container service and
        /// their settings, such as the ports to open, the environment variables to apply, and the launch
        /// command to run. It also specifies the container that will serve as the public endpoint of the
        /// deployment and its settings, such as the HTTP or HTTPS port to use, and the health check
        /// configuration.</p>
        pub fn deployment(mut self, inp: crate::model::ContainerServiceDeploymentRequest) -> Self {
            self.inner = self.inner.deployment(inp);
            self
        }
        /// <p>An object that describes a deployment for the container service.</p>
        ///
        /// <p>A deployment specifies the containers that will be launched on the container service and
        /// their settings, such as the ports to open, the environment variables to apply, and the launch
        /// command to run. It also specifies the container that will serve as the public endpoint of the
        /// deployment and its settings, such as the HTTP or HTTPS port to use, and the health check
        /// configuration.</p>
        pub fn set_deployment(
            mut self,
            input: std::option::Option<crate::model::ContainerServiceDeploymentRequest>,
        ) -> Self {
            self.inner = self.inner.set_deployment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateContainerServiceDeployment`.
    ///
    /// <p>Creates a deployment for your Amazon Lightsail container service.</p>
    ///
    /// <p>A deployment specifies the containers that will be launched on the container service and
    /// their settings, such as the ports to open, the environment variables to apply, and the launch
    /// command to run. It also specifies the container that will serve as the public endpoint of the
    /// deployment and its settings, such as the HTTP or HTTPS port to use, and the health check
    /// configuration.</p>
    ///
    /// <p>You can deploy containers to your container service using container images from a public
    /// registry like Docker Hub, or from your local machine. For more information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-container-images">Creating container images for your Amazon Lightsail container services</a> in the
    /// <i>Amazon Lightsail Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateContainerServiceDeployment<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_container_service_deployment_input::Builder,
    }
    impl<C, M, R> CreateContainerServiceDeployment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateContainerServiceDeployment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateContainerServiceDeploymentOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateContainerServiceDeploymentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateContainerServiceDeploymentInputOperationOutputAlias,
                crate::output::CreateContainerServiceDeploymentOutput,
                crate::error::CreateContainerServiceDeploymentError,
                crate::input::CreateContainerServiceDeploymentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container service for which to create the deployment.</p>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>The name of the container service for which to create the deployment.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
        /// Adds a key-value pair to `containers`.
        ///
        /// To override the contents of this collection use [`set_containers`](Self::set_containers).
        ///
        /// <p>An object that describes the settings of the containers that will be launched on the
        /// container service.</p>
        pub fn containers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Container>,
        ) -> Self {
            self.inner = self.inner.containers(k, v);
            self
        }
        /// <p>An object that describes the settings of the containers that will be launched on the
        /// container service.</p>
        pub fn set_containers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Container>,
            >,
        ) -> Self {
            self.inner = self.inner.set_containers(input);
            self
        }
        /// <p>An object that describes the settings of the public endpoint for the container
        /// service.</p>
        pub fn public_endpoint(mut self, inp: crate::model::EndpointRequest) -> Self {
            self.inner = self.inner.public_endpoint(inp);
            self
        }
        /// <p>An object that describes the settings of the public endpoint for the container
        /// service.</p>
        pub fn set_public_endpoint(
            mut self,
            input: std::option::Option<crate::model::EndpointRequest>,
        ) -> Self {
            self.inner = self.inner.set_public_endpoint(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateContainerServiceRegistryLogin`.
    ///
    /// <p>Creates a temporary set of log in credentials that you can use to log in to the Docker
    /// process on your local machine. After you're logged in, you can use the native Docker commands
    /// to push your local container images to the container image registry of your Amazon Lightsail
    /// account so that you can use them with your Lightsail container service. The log in
    /// credentials expire 12 hours after they are created, at which point you will need to create a
    /// new set of log in credentials.</p>
    ///
    /// <note>
    /// <p>You can only push container images to the container service registry of your Lightsail
    /// account. You cannot pull container images or perform any other container image management
    /// actions on the container service registry.</p>
    /// </note>
    ///
    /// <p>After you push your container images to the container image registry of your Lightsail
    /// account, use the <code>RegisterContainerImage</code> action to register the pushed images to a
    /// specific Lightsail container service.</p>
    ///
    /// <note>
    /// <p>This action is not required if you install and use the Lightsail Control
    /// (lightsailctl) plugin to push container images to your Lightsail container service. For
    /// more information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-pushing-container-images">Pushing and managing container images on your Amazon Lightsail container services</a>
    /// in the <i>Amazon Lightsail Developer Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateContainerServiceRegistryLogin<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_container_service_registry_login_input::Builder,
    }
    impl<C, M, R> CreateContainerServiceRegistryLogin<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateContainerServiceRegistryLogin`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateContainerServiceRegistryLoginOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateContainerServiceRegistryLoginError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateContainerServiceRegistryLoginInputOperationOutputAlias,
                crate::output::CreateContainerServiceRegistryLoginOutput,
                crate::error::CreateContainerServiceRegistryLoginError,
                crate::input::CreateContainerServiceRegistryLoginInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `CreateDisk`.
    ///
    /// <p>Creates a block storage disk that can be attached to an Amazon Lightsail instance in the
    /// same Availability Zone (e.g., <code>us-east-2a</code>).</p>
    /// <p>The <code>create disk</code> operation supports tag-based access control via request tags.
    /// For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDisk<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_disk_input::Builder,
    }
    impl<C, M, R> CreateDisk<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDisk`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDiskOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDiskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDiskInputOperationOutputAlias,
                crate::output::CreateDiskOutput,
                crate::error::CreateDiskError,
                crate::input::CreateDiskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique Lightsail disk name (e.g., <code>my-disk</code>).</p>
        pub fn disk_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disk_name(inp);
            self
        }
        /// <p>The unique Lightsail disk name (e.g., <code>my-disk</code>).</p>
        pub fn set_disk_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_disk_name(input);
            self
        }
        /// <p>The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>).
        /// Use the same Availability Zone as the Lightsail instance to which you want to attach the
        /// disk.</p>
        /// <p>Use the <code>get regions</code> operation to list the Availability Zones where
        /// Lightsail is currently available.</p>
        pub fn availability_zone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(inp);
            self
        }
        /// <p>The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>).
        /// Use the same Availability Zone as the Lightsail instance to which you want to attach the
        /// disk.</p>
        /// <p>Use the <code>get regions</code> operation to list the Availability Zones where
        /// Lightsail is currently available.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>The size of the disk in GB (e.g., <code>32</code>).</p>
        pub fn size_in_gb(mut self, inp: i32) -> Self {
            self.inner = self.inner.size_in_gb(inp);
            self
        }
        /// <p>The size of the disk in GB (e.g., <code>32</code>).</p>
        pub fn set_size_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_size_in_gb(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `addOns`.
        ///
        /// To override the contents of this collection use [`set_add_ons`](Self::set_add_ons).
        ///
        /// <p>An array of objects that represent the add-ons to enable for the new disk.</p>
        pub fn add_ons(mut self, inp: impl Into<crate::model::AddOnRequest>) -> Self {
            self.inner = self.inner.add_ons(inp);
            self
        }
        /// <p>An array of objects that represent the add-ons to enable for the new disk.</p>
        pub fn set_add_ons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddOnRequest>>,
        ) -> Self {
            self.inner = self.inner.set_add_ons(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDiskFromSnapshot`.
    ///
    /// <p>Creates a block storage disk from a manual or automatic snapshot of a disk. The resulting
    /// disk can be attached to an Amazon Lightsail instance in the same Availability Zone (e.g.,
    /// <code>us-east-2a</code>).</p>
    /// <p>The <code>create disk from snapshot</code> operation supports tag-based access control via
    /// request tags and resource tags applied to the resource identified by <code>disk snapshot
    /// name</code>. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDiskFromSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_disk_from_snapshot_input::Builder,
    }
    impl<C, M, R> CreateDiskFromSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDiskFromSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDiskFromSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDiskFromSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDiskFromSnapshotInputOperationOutputAlias,
                crate::output::CreateDiskFromSnapshotOutput,
                crate::error::CreateDiskFromSnapshotError,
                crate::input::CreateDiskFromSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique Lightsail disk name (e.g., <code>my-disk</code>).</p>
        pub fn disk_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disk_name(inp);
            self
        }
        /// <p>The unique Lightsail disk name (e.g., <code>my-disk</code>).</p>
        pub fn set_disk_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_disk_name(input);
            self
        }
        /// <p>The name of the disk snapshot (e.g., <code>my-snapshot</code>) from which to create the
        /// new storage disk.</p>
        /// <p>Constraint:</p>
        /// <ul>
        /// <li>
        /// <p>This parameter cannot be defined together with the <code>source disk name</code>
        /// parameter. The <code>disk snapshot name</code> and <code>source disk name</code>
        /// parameters are mutually exclusive.</p>
        /// </li>
        /// </ul>
        pub fn disk_snapshot_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disk_snapshot_name(inp);
            self
        }
        /// <p>The name of the disk snapshot (e.g., <code>my-snapshot</code>) from which to create the
        /// new storage disk.</p>
        /// <p>Constraint:</p>
        /// <ul>
        /// <li>
        /// <p>This parameter cannot be defined together with the <code>source disk name</code>
        /// parameter. The <code>disk snapshot name</code> and <code>source disk name</code>
        /// parameters are mutually exclusive.</p>
        /// </li>
        /// </ul>
        pub fn set_disk_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_disk_snapshot_name(input);
            self
        }
        /// <p>The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>).
        /// Choose the same Availability Zone as the Lightsail instance where you want to create the
        /// disk.</p>
        /// <p>Use the GetRegions operation to list the Availability Zones where Lightsail is currently
        /// available.</p>
        pub fn availability_zone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(inp);
            self
        }
        /// <p>The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>).
        /// Choose the same Availability Zone as the Lightsail instance where you want to create the
        /// disk.</p>
        /// <p>Use the GetRegions operation to list the Availability Zones where Lightsail is currently
        /// available.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>The size of the disk in GB (e.g., <code>32</code>).</p>
        pub fn size_in_gb(mut self, inp: i32) -> Self {
            self.inner = self.inner.size_in_gb(inp);
            self
        }
        /// <p>The size of the disk in GB (e.g., <code>32</code>).</p>
        pub fn set_size_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_size_in_gb(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `addOns`.
        ///
        /// To override the contents of this collection use [`set_add_ons`](Self::set_add_ons).
        ///
        /// <p>An array of objects that represent the add-ons to enable for the new disk.</p>
        pub fn add_ons(mut self, inp: impl Into<crate::model::AddOnRequest>) -> Self {
            self.inner = self.inner.add_ons(inp);
            self
        }
        /// <p>An array of objects that represent the add-ons to enable for the new disk.</p>
        pub fn set_add_ons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddOnRequest>>,
        ) -> Self {
            self.inner = self.inner.set_add_ons(input);
            self
        }
        /// <p>The name of the source disk from which the source automatic snapshot was created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>This parameter cannot be defined together with the <code>disk snapshot name</code>
        /// parameter. The <code>source disk name</code> and <code>disk snapshot name</code>
        /// parameters are mutually exclusive.</p>
        /// </li>
        /// <li>
        /// <p>Define this parameter only when creating a new disk from an automatic snapshot. For
        /// more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p>
        /// </li>
        /// </ul>
        pub fn source_disk_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_disk_name(inp);
            self
        }
        /// <p>The name of the source disk from which the source automatic snapshot was created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>This parameter cannot be defined together with the <code>disk snapshot name</code>
        /// parameter. The <code>source disk name</code> and <code>disk snapshot name</code>
        /// parameters are mutually exclusive.</p>
        /// </li>
        /// <li>
        /// <p>Define this parameter only when creating a new disk from an automatic snapshot. For
        /// more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_source_disk_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_disk_name(input);
            self
        }
        /// <p>The date of the automatic snapshot to use for the new disk. Use the <code>get auto
        /// snapshots</code> operation to identify the dates of the available automatic
        /// snapshots.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be specified in <code>YYYY-MM-DD</code> format.</p>
        /// </li>
        /// <li>
        /// <p>This parameter cannot be defined together with the <code>use latest restorable auto
        /// snapshot</code> parameter. The <code>restore date</code> and <code>use latest restorable
        /// auto snapshot</code> parameters are mutually exclusive.</p>
        /// </li>
        /// <li>
        /// <p>Define this parameter only when creating a new disk from an automatic snapshot. For
        /// more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p>
        /// </li>
        /// </ul>
        pub fn restore_date(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.restore_date(inp);
            self
        }
        /// <p>The date of the automatic snapshot to use for the new disk. Use the <code>get auto
        /// snapshots</code> operation to identify the dates of the available automatic
        /// snapshots.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be specified in <code>YYYY-MM-DD</code> format.</p>
        /// </li>
        /// <li>
        /// <p>This parameter cannot be defined together with the <code>use latest restorable auto
        /// snapshot</code> parameter. The <code>restore date</code> and <code>use latest restorable
        /// auto snapshot</code> parameters are mutually exclusive.</p>
        /// </li>
        /// <li>
        /// <p>Define this parameter only when creating a new disk from an automatic snapshot. For
        /// more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_restore_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_restore_date(input);
            self
        }
        /// <p>A Boolean value to indicate whether to use the latest available automatic snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>This parameter cannot be defined together with the <code>restore date</code>
        /// parameter. The <code>use latest restorable auto snapshot</code> and <code>restore
        /// date</code> parameters are mutually exclusive.</p>
        /// </li>
        /// <li>
        /// <p>Define this parameter only when creating a new disk from an automatic snapshot. For
        /// more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p>
        /// </li>
        /// </ul>
        pub fn use_latest_restorable_auto_snapshot(mut self, inp: bool) -> Self {
            self.inner = self.inner.use_latest_restorable_auto_snapshot(inp);
            self
        }
        /// <p>A Boolean value to indicate whether to use the latest available automatic snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>This parameter cannot be defined together with the <code>restore date</code>
        /// parameter. The <code>use latest restorable auto snapshot</code> and <code>restore
        /// date</code> parameters are mutually exclusive.</p>
        /// </li>
        /// <li>
        /// <p>Define this parameter only when creating a new disk from an automatic snapshot. For
        /// more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_use_latest_restorable_auto_snapshot(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_use_latest_restorable_auto_snapshot(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDiskSnapshot`.
    ///
    /// <p>Creates a snapshot of a block storage disk. You can use snapshots for backups, to make
    /// copies of disks, and to save data before shutting down a Lightsail instance.</p>
    /// <p>You can take a snapshot of an attached disk that is in use; however, snapshots only
    /// capture data that has been written to your disk at the time the snapshot command is issued.
    /// This may exclude any data that has been cached by any applications or the operating system. If
    /// you can pause any file systems on the disk long enough to take a snapshot, your snapshot
    /// should be complete. Nevertheless, if you cannot pause all file writes to the disk, you should
    /// unmount the disk from within the Lightsail instance, issue the create disk snapshot command,
    /// and then remount the disk to ensure a consistent and complete snapshot. You may remount and
    /// use your disk while the snapshot status is pending.</p>
    /// <p>You can also use this operation to create a snapshot of an instance's system volume. You
    /// might want to do this, for example, to recover data from the system volume of a botched
    /// instance or to create a backup of the system volume like you would for a block storage disk.
    /// To create a snapshot of a system volume, just define the <code>instance name</code> parameter
    /// when issuing the snapshot command, and a snapshot of the defined instance's system volume will
    /// be created. After the snapshot is available, you can create a block storage disk from the
    /// snapshot and attach it to a running instance to access the data on the disk.</p>
    ///
    /// <p>The <code>create disk snapshot</code> operation supports tag-based access control via
    /// request tags. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDiskSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_disk_snapshot_input::Builder,
    }
    impl<C, M, R> CreateDiskSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDiskSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDiskSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDiskSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDiskSnapshotInputOperationOutputAlias,
                crate::output::CreateDiskSnapshotOutput,
                crate::error::CreateDiskSnapshotError,
                crate::input::CreateDiskSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the source disk (e.g., <code>Disk-Virginia-1</code>).</p>
        /// <note>
        /// <p>This parameter cannot be defined together with the <code>instance name</code> parameter.
        /// The <code>disk name</code> and <code>instance name</code> parameters are mutually
        /// exclusive.</p>
        /// </note>
        pub fn disk_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disk_name(inp);
            self
        }
        /// <p>The unique name of the source disk (e.g., <code>Disk-Virginia-1</code>).</p>
        /// <note>
        /// <p>This parameter cannot be defined together with the <code>instance name</code> parameter.
        /// The <code>disk name</code> and <code>instance name</code> parameters are mutually
        /// exclusive.</p>
        /// </note>
        pub fn set_disk_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_disk_name(input);
            self
        }
        /// <p>The name of the destination disk snapshot (e.g., <code>my-disk-snapshot</code>) based on
        /// the source disk.</p>
        pub fn disk_snapshot_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disk_snapshot_name(inp);
            self
        }
        /// <p>The name of the destination disk snapshot (e.g., <code>my-disk-snapshot</code>) based on
        /// the source disk.</p>
        pub fn set_disk_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_disk_snapshot_name(input);
            self
        }
        /// <p>The unique name of the source instance (e.g., <code>Amazon_Linux-512MB-Virginia-1</code>).
        /// When this is defined, a snapshot of the instance's system volume is created.</p>
        /// <note>
        /// <p>This parameter cannot be defined together with the <code>disk name</code> parameter. The
        /// <code>instance name</code> and <code>disk name</code> parameters are mutually
        /// exclusive.</p>
        /// </note>
        pub fn instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_name(inp);
            self
        }
        /// <p>The unique name of the source instance (e.g., <code>Amazon_Linux-512MB-Virginia-1</code>).
        /// When this is defined, a snapshot of the instance's system volume is created.</p>
        /// <note>
        /// <p>This parameter cannot be defined together with the <code>disk name</code> parameter. The
        /// <code>instance name</code> and <code>disk name</code> parameters are mutually
        /// exclusive.</p>
        /// </note>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDistribution`.
    ///
    /// <p>Creates an Amazon Lightsail content delivery network (CDN) distribution.</p>
    /// <p>A distribution is a globally distributed network of caching servers that improve the
    /// performance of your website or web application hosted on a Lightsail instance. For more
    /// information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-content-delivery-network-distributions">Content delivery networks in Amazon Lightsail</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDistribution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_distribution_input::Builder,
    }
    impl<C, M, R> CreateDistribution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDistribution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDistributionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDistributionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDistributionInputOperationOutputAlias,
                crate::output::CreateDistributionOutput,
                crate::error::CreateDistributionError,
                crate::input::CreateDistributionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the distribution.</p>
        pub fn distribution_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_name(inp);
            self
        }
        /// <p>The name for the distribution.</p>
        pub fn set_distribution_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_name(input);
            self
        }
        /// <p>An object that describes the origin resource for the distribution, such as a Lightsail
        /// instance or load balancer.</p>
        /// <p>The distribution pulls, caches, and serves content from the origin.</p>
        pub fn origin(mut self, inp: crate::model::InputOrigin) -> Self {
            self.inner = self.inner.origin(inp);
            self
        }
        /// <p>An object that describes the origin resource for the distribution, such as a Lightsail
        /// instance or load balancer.</p>
        /// <p>The distribution pulls, caches, and serves content from the origin.</p>
        pub fn set_origin(mut self, input: std::option::Option<crate::model::InputOrigin>) -> Self {
            self.inner = self.inner.set_origin(input);
            self
        }
        /// <p>An object that describes the default cache behavior for the distribution.</p>
        pub fn default_cache_behavior(mut self, inp: crate::model::CacheBehavior) -> Self {
            self.inner = self.inner.default_cache_behavior(inp);
            self
        }
        /// <p>An object that describes the default cache behavior for the distribution.</p>
        pub fn set_default_cache_behavior(
            mut self,
            input: std::option::Option<crate::model::CacheBehavior>,
        ) -> Self {
            self.inner = self.inner.set_default_cache_behavior(input);
            self
        }
        /// <p>An object that describes the cache behavior settings for the distribution.</p>
        pub fn cache_behavior_settings(mut self, inp: crate::model::CacheSettings) -> Self {
            self.inner = self.inner.cache_behavior_settings(inp);
            self
        }
        /// <p>An object that describes the cache behavior settings for the distribution.</p>
        pub fn set_cache_behavior_settings(
            mut self,
            input: std::option::Option<crate::model::CacheSettings>,
        ) -> Self {
            self.inner = self.inner.set_cache_behavior_settings(input);
            self
        }
        /// Appends an item to `cacheBehaviors`.
        ///
        /// To override the contents of this collection use [`set_cache_behaviors`](Self::set_cache_behaviors).
        ///
        /// <p>An array of objects that describe the per-path cache behavior for the distribution.</p>
        pub fn cache_behaviors(
            mut self,
            inp: impl Into<crate::model::CacheBehaviorPerPath>,
        ) -> Self {
            self.inner = self.inner.cache_behaviors(inp);
            self
        }
        /// <p>An array of objects that describe the per-path cache behavior for the distribution.</p>
        pub fn set_cache_behaviors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CacheBehaviorPerPath>>,
        ) -> Self {
            self.inner = self.inner.set_cache_behaviors(input);
            self
        }
        /// <p>The bundle ID to use for the distribution.</p>
        /// <p>A distribution bundle describes the specifications of your distribution, such as the
        /// monthly cost and monthly network transfer quota.</p>
        /// <p>Use the <code>GetDistributionBundles</code> action to get a list of distribution bundle
        /// IDs that you can specify.</p>
        pub fn bundle_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bundle_id(inp);
            self
        }
        /// <p>The bundle ID to use for the distribution.</p>
        /// <p>A distribution bundle describes the specifications of your distribution, such as the
        /// monthly cost and monthly network transfer quota.</p>
        /// <p>Use the <code>GetDistributionBundles</code> action to get a list of distribution bundle
        /// IDs that you can specify.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bundle_id(input);
            self
        }
        /// <p>The IP address type for the distribution.</p>
        ///
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for
        /// IPv4 and IPv6.</p>
        ///
        /// <p>The default value is <code>dualstack</code>.</p>
        pub fn ip_address_type(mut self, inp: crate::model::IpAddressType) -> Self {
            self.inner = self.inner.ip_address_type(inp);
            self
        }
        /// <p>The IP address type for the distribution.</p>
        ///
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for
        /// IPv4 and IPv6.</p>
        ///
        /// <p>The default value is <code>dualstack</code>.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.inner = self.inner.set_ip_address_type(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the distribution during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag keys and optional values to add to the distribution during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDomain`.
    ///
    /// <p>Creates a domain resource for the specified domain (e.g., example.com).</p>
    /// <p>The <code>create domain</code> operation supports tag-based access control via request
    /// tags. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_domain_input::Builder,
    }
    impl<C, M, R> CreateDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDomainInputOperationOutputAlias,
                crate::output::CreateDomainOutput,
                crate::error::CreateDomainError,
                crate::input::CreateDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name to manage (e.g., <code>example.com</code>).</p>
        /// <note>
        /// <p>You cannot register a new domain name using Lightsail. You must register a domain name
        /// using Amazon Route 53 or another domain name registrar. If you have already registered your
        /// domain, you can enter its name in this parameter to manage the DNS records for that domain
        /// using Lightsail.</p>
        /// </note>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The domain name to manage (e.g., <code>example.com</code>).</p>
        /// <note>
        /// <p>You cannot register a new domain name using Lightsail. You must register a domain name
        /// using Amazon Route 53 or another domain name registrar. If you have already registered your
        /// domain, you can enter its name in this parameter to manage the DNS records for that domain
        /// using Lightsail.</p>
        /// </note>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDomainEntry`.
    ///
    /// <p>Creates one of the following domain name system (DNS) records in a domain DNS zone:
    /// Address (A), canonical name (CNAME), mail exchanger (MX), name server (NS), start of authority
    /// (SOA), service locator (SRV), or text (TXT).</p>
    ///
    ///
    ///
    /// <p>The <code>create domain entry</code> operation supports tag-based access control via
    /// resource tags applied to the resource identified by <code>domain name</code>. For more
    /// information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDomainEntry<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_domain_entry_input::Builder,
    }
    impl<C, M, R> CreateDomainEntry<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDomainEntry`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDomainEntryOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDomainEntryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDomainEntryInputOperationOutputAlias,
                crate::output::CreateDomainEntryOutput,
                crate::error::CreateDomainEntryError,
                crate::input::CreateDomainEntryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name (e.g., <code>example.com</code>) for which you want to create the domain
        /// entry.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The domain name (e.g., <code>example.com</code>) for which you want to create the domain
        /// entry.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>An array of key-value pairs containing information about the domain entry request.</p>
        pub fn domain_entry(mut self, inp: crate::model::DomainEntry) -> Self {
            self.inner = self.inner.domain_entry(inp);
            self
        }
        /// <p>An array of key-value pairs containing information about the domain entry request.</p>
        pub fn set_domain_entry(
            mut self,
            input: std::option::Option<crate::model::DomainEntry>,
        ) -> Self {
            self.inner = self.inner.set_domain_entry(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInstances`.
    ///
    /// <p>Creates one or more Amazon Lightsail instances.</p>
    /// <p>The <code>create instances</code> operation supports tag-based access control via request
    /// tags. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_instances_input::Builder,
    }
    impl<C, M, R> CreateInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateInstancesInputOperationOutputAlias,
                crate::output::CreateInstancesOutput,
                crate::error::CreateInstancesError,
                crate::input::CreateInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `instanceNames`.
        ///
        /// To override the contents of this collection use [`set_instance_names`](Self::set_instance_names).
        ///
        /// <p>The names to use for your new Lightsail instances. Separate multiple values using
        /// quotation marks and commas, for example:
        /// <code>["MyFirstInstance","MySecondInstance"]</code>
        /// </p>
        pub fn instance_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_names(inp);
            self
        }
        /// <p>The names to use for your new Lightsail instances. Separate multiple values using
        /// quotation marks and commas, for example:
        /// <code>["MyFirstInstance","MySecondInstance"]</code>
        /// </p>
        pub fn set_instance_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_names(input);
            self
        }
        /// <p>The Availability Zone in which to create your instance. Use the following format:
        /// <code>us-east-2a</code> (case sensitive). You can get a list of Availability Zones by using
        /// the <a href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get
        /// regions</a> operation. Be sure to add the <code>include Availability Zones</code>
        /// parameter to your request.</p>
        pub fn availability_zone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(inp);
            self
        }
        /// <p>The Availability Zone in which to create your instance. Use the following format:
        /// <code>us-east-2a</code> (case sensitive). You can get a list of Availability Zones by using
        /// the <a href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get
        /// regions</a> operation. Be sure to add the <code>include Availability Zones</code>
        /// parameter to your request.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>(Deprecated) The name for your custom image.</p>
        /// <note>
        /// <p>In releases prior to June 12, 2017, this parameter was ignored by the API. It is now
        /// deprecated.</p>
        /// </note>
        pub fn custom_image_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_image_name(inp);
            self
        }
        /// <p>(Deprecated) The name for your custom image.</p>
        /// <note>
        /// <p>In releases prior to June 12, 2017, this parameter was ignored by the API. It is now
        /// deprecated.</p>
        /// </note>
        pub fn set_custom_image_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_custom_image_name(input);
            self
        }
        /// <p>The ID for a virtual private server image (e.g., <code>app_wordpress_4_4</code> or
        /// <code>app_lamp_7_0</code>). Use the <code>get blueprints</code> operation to return a list
        /// of available images (or <i>blueprints</i>).</p>
        /// <note>
        /// <p>Use active blueprints when creating new instances. Inactive blueprints are listed to
        /// support customers with existing instances and are not necessarily available to create new
        /// instances. Blueprints are marked inactive when they become outdated due to operating system
        /// updates or new application releases.</p>
        /// </note>
        pub fn blueprint_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.blueprint_id(inp);
            self
        }
        /// <p>The ID for a virtual private server image (e.g., <code>app_wordpress_4_4</code> or
        /// <code>app_lamp_7_0</code>). Use the <code>get blueprints</code> operation to return a list
        /// of available images (or <i>blueprints</i>).</p>
        /// <note>
        /// <p>Use active blueprints when creating new instances. Inactive blueprints are listed to
        /// support customers with existing instances and are not necessarily available to create new
        /// instances. Blueprints are marked inactive when they become outdated due to operating system
        /// updates or new application releases.</p>
        /// </note>
        pub fn set_blueprint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_blueprint_id(input);
            self
        }
        /// <p>The bundle of specification information for your virtual private server (or
        /// <i>instance</i>), including the pricing plan (e.g.,
        /// <code>micro_1_0</code>).</p>
        pub fn bundle_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bundle_id(inp);
            self
        }
        /// <p>The bundle of specification information for your virtual private server (or
        /// <i>instance</i>), including the pricing plan (e.g.,
        /// <code>micro_1_0</code>).</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bundle_id(input);
            self
        }
        /// <p>A launch script you can create that configures a server with additional user data. For
        /// example, you might want to run <code>apt-get -y update</code>.</p>
        /// <note>
        /// <p>Depending on the machine image you choose, the command to get software on your instance
        /// varies. Amazon Linux and CentOS use <code>yum</code>, Debian and Ubuntu use
        /// <code>apt-get</code>, and FreeBSD uses <code>pkg</code>. For a complete list, see the
        /// <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/compare-options-choose-lightsail-instance-image">Amazon Lightsail Developer Guide</a>.</p>
        /// </note>
        pub fn user_data(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_data(inp);
            self
        }
        /// <p>A launch script you can create that configures a server with additional user data. For
        /// example, you might want to run <code>apt-get -y update</code>.</p>
        /// <note>
        /// <p>Depending on the machine image you choose, the command to get software on your instance
        /// varies. Amazon Linux and CentOS use <code>yum</code>, Debian and Ubuntu use
        /// <code>apt-get</code>, and FreeBSD uses <code>pkg</code>. For a complete list, see the
        /// <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/compare-options-choose-lightsail-instance-image">Amazon Lightsail Developer Guide</a>.</p>
        /// </note>
        pub fn set_user_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_data(input);
            self
        }
        /// <p>The name of your key pair.</p>
        pub fn key_pair_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_pair_name(inp);
            self
        }
        /// <p>The name of your key pair.</p>
        pub fn set_key_pair_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_key_pair_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `addOns`.
        ///
        /// To override the contents of this collection use [`set_add_ons`](Self::set_add_ons).
        ///
        /// <p>An array of objects representing the add-ons to enable for the new instance.</p>
        pub fn add_ons(mut self, inp: impl Into<crate::model::AddOnRequest>) -> Self {
            self.inner = self.inner.add_ons(inp);
            self
        }
        /// <p>An array of objects representing the add-ons to enable for the new instance.</p>
        pub fn set_add_ons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddOnRequest>>,
        ) -> Self {
            self.inner = self.inner.set_add_ons(input);
            self
        }
        /// <p>The IP address type for the instance.</p>
        ///
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for
        /// IPv4 and IPv6.</p>
        ///
        /// <p>The default value is <code>dualstack</code>.</p>
        pub fn ip_address_type(mut self, inp: crate::model::IpAddressType) -> Self {
            self.inner = self.inner.ip_address_type(inp);
            self
        }
        /// <p>The IP address type for the instance.</p>
        ///
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for
        /// IPv4 and IPv6.</p>
        ///
        /// <p>The default value is <code>dualstack</code>.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.inner = self.inner.set_ip_address_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInstancesFromSnapshot`.
    ///
    /// <p>Creates one or more new instances from a manual or automatic snapshot of an
    /// instance.</p>
    /// <p>The <code>create instances from snapshot</code> operation supports tag-based access
    /// control via request tags and resource tags applied to the resource identified by
    /// <code>instance snapshot name</code>. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateInstancesFromSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_instances_from_snapshot_input::Builder,
    }
    impl<C, M, R> CreateInstancesFromSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateInstancesFromSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInstancesFromSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInstancesFromSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateInstancesFromSnapshotInputOperationOutputAlias,
                crate::output::CreateInstancesFromSnapshotOutput,
                crate::error::CreateInstancesFromSnapshotError,
                crate::input::CreateInstancesFromSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `instanceNames`.
        ///
        /// To override the contents of this collection use [`set_instance_names`](Self::set_instance_names).
        ///
        /// <p>The names for your new instances.</p>
        pub fn instance_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_names(inp);
            self
        }
        /// <p>The names for your new instances.</p>
        pub fn set_instance_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_names(input);
            self
        }
        /// Adds a key-value pair to `attachedDiskMapping`.
        ///
        /// To override the contents of this collection use [`set_attached_disk_mapping`](Self::set_attached_disk_mapping).
        ///
        /// <p>An object containing information about one or more disk mappings.</p>
        pub fn attached_disk_mapping(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<crate::model::DiskMap>>,
        ) -> Self {
            self.inner = self.inner.attached_disk_mapping(k, v);
            self
        }
        /// <p>An object containing information about one or more disk mappings.</p>
        pub fn set_attached_disk_mapping(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::vec::Vec<crate::model::DiskMap>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_attached_disk_mapping(input);
            self
        }
        /// <p>The Availability Zone where you want to create your instances. Use the following
        /// formatting: <code>us-east-2a</code> (case sensitive). You can get a list of Availability Zones
        /// by using the <a href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get
        /// regions</a> operation. Be sure to add the <code>include Availability Zones</code>
        /// parameter to your request.</p>
        pub fn availability_zone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(inp);
            self
        }
        /// <p>The Availability Zone where you want to create your instances. Use the following
        /// formatting: <code>us-east-2a</code> (case sensitive). You can get a list of Availability Zones
        /// by using the <a href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get
        /// regions</a> operation. Be sure to add the <code>include Availability Zones</code>
        /// parameter to your request.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>The name of the instance snapshot on which you are basing your new instances. Use the get
        /// instance snapshots operation to return information about your existing snapshots.</p>
        /// <p>Constraint:</p>
        /// <ul>
        /// <li>
        /// <p>This parameter cannot be defined together with the <code>source instance name</code>
        /// parameter. The <code>instance snapshot name</code> and <code>source instance name</code>
        /// parameters are mutually exclusive.</p>
        /// </li>
        /// </ul>
        pub fn instance_snapshot_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_snapshot_name(inp);
            self
        }
        /// <p>The name of the instance snapshot on which you are basing your new instances. Use the get
        /// instance snapshots operation to return information about your existing snapshots.</p>
        /// <p>Constraint:</p>
        /// <ul>
        /// <li>
        /// <p>This parameter cannot be defined together with the <code>source instance name</code>
        /// parameter. The <code>instance snapshot name</code> and <code>source instance name</code>
        /// parameters are mutually exclusive.</p>
        /// </li>
        /// </ul>
        pub fn set_instance_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_snapshot_name(input);
            self
        }
        /// <p>The bundle of specification information for your virtual private server (or
        /// <i>instance</i>), including the pricing plan (e.g.,
        /// <code>micro_1_0</code>).</p>
        pub fn bundle_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bundle_id(inp);
            self
        }
        /// <p>The bundle of specification information for your virtual private server (or
        /// <i>instance</i>), including the pricing plan (e.g.,
        /// <code>micro_1_0</code>).</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bundle_id(input);
            self
        }
        /// <p>You can create a launch script that configures a server with additional user data. For
        /// example, <code>apt-get -y update</code>.</p>
        /// <note>
        /// <p>Depending on the machine image you choose, the command to get software on your instance
        /// varies. Amazon Linux and CentOS use <code>yum</code>, Debian and Ubuntu use
        /// <code>apt-get</code>, and FreeBSD uses <code>pkg</code>. For a complete list, see the
        /// <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/compare-options-choose-lightsail-instance-image">Amazon Lightsail Developer Guide</a>.</p>
        /// </note>
        pub fn user_data(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_data(inp);
            self
        }
        /// <p>You can create a launch script that configures a server with additional user data. For
        /// example, <code>apt-get -y update</code>.</p>
        /// <note>
        /// <p>Depending on the machine image you choose, the command to get software on your instance
        /// varies. Amazon Linux and CentOS use <code>yum</code>, Debian and Ubuntu use
        /// <code>apt-get</code>, and FreeBSD uses <code>pkg</code>. For a complete list, see the
        /// <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/compare-options-choose-lightsail-instance-image">Amazon Lightsail Developer Guide</a>.</p>
        /// </note>
        pub fn set_user_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_data(input);
            self
        }
        /// <p>The name for your key pair.</p>
        pub fn key_pair_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_pair_name(inp);
            self
        }
        /// <p>The name for your key pair.</p>
        pub fn set_key_pair_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_key_pair_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Appends an item to `addOns`.
        ///
        /// To override the contents of this collection use [`set_add_ons`](Self::set_add_ons).
        ///
        /// <p>An array of objects representing the add-ons to enable for the new instance.</p>
        pub fn add_ons(mut self, inp: impl Into<crate::model::AddOnRequest>) -> Self {
            self.inner = self.inner.add_ons(inp);
            self
        }
        /// <p>An array of objects representing the add-ons to enable for the new instance.</p>
        pub fn set_add_ons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddOnRequest>>,
        ) -> Self {
            self.inner = self.inner.set_add_ons(input);
            self
        }
        /// <p>The IP address type for the instance.</p>
        ///
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for
        /// IPv4 and IPv6.</p>
        ///
        /// <p>The default value is <code>dualstack</code>.</p>
        pub fn ip_address_type(mut self, inp: crate::model::IpAddressType) -> Self {
            self.inner = self.inner.ip_address_type(inp);
            self
        }
        /// <p>The IP address type for the instance.</p>
        ///
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for
        /// IPv4 and IPv6.</p>
        ///
        /// <p>The default value is <code>dualstack</code>.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.inner = self.inner.set_ip_address_type(input);
            self
        }
        /// <p>The name of the source instance from which the source automatic snapshot was
        /// created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>This parameter cannot be defined together with the <code>instance snapshot name</code>
        /// parameter. The <code>source instance name</code> and <code>instance snapshot name</code>
        /// parameters are mutually exclusive.</p>
        /// </li>
        /// <li>
        /// <p>Define this parameter only when creating a new instance from an automatic snapshot.
        /// For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p>
        /// </li>
        /// </ul>
        pub fn source_instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_instance_name(inp);
            self
        }
        /// <p>The name of the source instance from which the source automatic snapshot was
        /// created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>This parameter cannot be defined together with the <code>instance snapshot name</code>
        /// parameter. The <code>source instance name</code> and <code>instance snapshot name</code>
        /// parameters are mutually exclusive.</p>
        /// </li>
        /// <li>
        /// <p>Define this parameter only when creating a new instance from an automatic snapshot.
        /// For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_source_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_instance_name(input);
            self
        }
        /// <p>The date of the automatic snapshot to use for the new instance. Use the <code>get auto
        /// snapshots</code> operation to identify the dates of the available automatic
        /// snapshots.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be specified in <code>YYYY-MM-DD</code> format.</p>
        /// </li>
        /// <li>
        /// <p>This parameter cannot be defined together with the <code>use latest restorable auto
        /// snapshot</code> parameter. The <code>restore date</code> and <code>use latest restorable
        /// auto snapshot</code> parameters are mutually exclusive.</p>
        /// </li>
        /// <li>
        /// <p>Define this parameter only when creating a new instance from an automatic snapshot.
        /// For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p>
        /// </li>
        /// </ul>
        pub fn restore_date(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.restore_date(inp);
            self
        }
        /// <p>The date of the automatic snapshot to use for the new instance. Use the <code>get auto
        /// snapshots</code> operation to identify the dates of the available automatic
        /// snapshots.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be specified in <code>YYYY-MM-DD</code> format.</p>
        /// </li>
        /// <li>
        /// <p>This parameter cannot be defined together with the <code>use latest restorable auto
        /// snapshot</code> parameter. The <code>restore date</code> and <code>use latest restorable
        /// auto snapshot</code> parameters are mutually exclusive.</p>
        /// </li>
        /// <li>
        /// <p>Define this parameter only when creating a new instance from an automatic snapshot.
        /// For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_restore_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_restore_date(input);
            self
        }
        /// <p>A Boolean value to indicate whether to use the latest available automatic snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>This parameter cannot be defined together with the <code>restore date</code>
        /// parameter. The <code>use latest restorable auto snapshot</code> and <code>restore
        /// date</code> parameters are mutually exclusive.</p>
        /// </li>
        /// <li>
        /// <p>Define this parameter only when creating a new instance from an automatic snapshot.
        /// For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p>
        /// </li>
        /// </ul>
        pub fn use_latest_restorable_auto_snapshot(mut self, inp: bool) -> Self {
            self.inner = self.inner.use_latest_restorable_auto_snapshot(inp);
            self
        }
        /// <p>A Boolean value to indicate whether to use the latest available automatic snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>This parameter cannot be defined together with the <code>restore date</code>
        /// parameter. The <code>use latest restorable auto snapshot</code> and <code>restore
        /// date</code> parameters are mutually exclusive.</p>
        /// </li>
        /// <li>
        /// <p>Define this parameter only when creating a new instance from an automatic snapshot.
        /// For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_use_latest_restorable_auto_snapshot(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_use_latest_restorable_auto_snapshot(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInstanceSnapshot`.
    ///
    /// <p>Creates a snapshot of a specific virtual private server, or <i>instance</i>.
    /// You can use a snapshot to create a new instance that is based on that snapshot.</p>
    /// <p>The <code>create instance snapshot</code> operation supports tag-based access control via
    /// request tags. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateInstanceSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_instance_snapshot_input::Builder,
    }
    impl<C, M, R> CreateInstanceSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateInstanceSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInstanceSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInstanceSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateInstanceSnapshotInputOperationOutputAlias,
                crate::output::CreateInstanceSnapshotOutput,
                crate::error::CreateInstanceSnapshotError,
                crate::input::CreateInstanceSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for your new snapshot.</p>
        pub fn instance_snapshot_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_snapshot_name(inp);
            self
        }
        /// <p>The name for your new snapshot.</p>
        pub fn set_instance_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_snapshot_name(input);
            self
        }
        /// <p>The Lightsail instance on which to base your snapshot.</p>
        pub fn instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_name(inp);
            self
        }
        /// <p>The Lightsail instance on which to base your snapshot.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateKeyPair`.
    ///
    /// <p>Creates an SSH key pair.</p>
    /// <p>The <code>create key pair</code> operation supports tag-based access control via request
    /// tags. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateKeyPair<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_key_pair_input::Builder,
    }
    impl<C, M, R> CreateKeyPair<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateKeyPair`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateKeyPairOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateKeyPairError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateKeyPairInputOperationOutputAlias,
                crate::output::CreateKeyPairOutput,
                crate::error::CreateKeyPairError,
                crate::input::CreateKeyPairInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for your new key pair.</p>
        pub fn key_pair_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_pair_name(inp);
            self
        }
        /// <p>The name for your new key pair.</p>
        pub fn set_key_pair_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_key_pair_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLoadBalancer`.
    ///
    /// <p>Creates a Lightsail load balancer. To learn more about deciding whether to load balance
    /// your application, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/configure-lightsail-instances-for-load-balancing">Configure your Lightsail instances for load balancing</a>. You can create up to 5
    /// load balancers per AWS Region in your account.</p>
    /// <p>When you create a load balancer, you can specify a unique name and port settings. To
    /// change additional load balancer settings, use the <code>UpdateLoadBalancerAttribute</code>
    /// operation.</p>
    /// <p>The <code>create load balancer</code> operation supports tag-based access control via
    /// request tags. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateLoadBalancer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_load_balancer_input::Builder,
    }
    impl<C, M, R> CreateLoadBalancer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLoadBalancer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLoadBalancerOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLoadBalancerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLoadBalancerInputOperationOutputAlias,
                crate::output::CreateLoadBalancerOutput,
                crate::error::CreateLoadBalancerError,
                crate::input::CreateLoadBalancerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of your load balancer.</p>
        pub fn load_balancer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(inp);
            self
        }
        /// <p>The name of your load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// <p>The instance port where you're creating your load balancer.</p>
        pub fn instance_port(mut self, inp: i32) -> Self {
            self.inner = self.inner.instance_port(inp);
            self
        }
        /// <p>The instance port where you're creating your load balancer.</p>
        pub fn set_instance_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_instance_port(input);
            self
        }
        /// <p>The path you provided to perform the load balancer health check. If you didn't specify a
        /// health check path, Lightsail uses the root path of your website (e.g.,
        /// <code>"/"</code>).</p>
        /// <p>You may want to specify a custom health check path other than the root of your application
        /// if your home page loads slowly or has a lot of media or scripting on it.</p>
        pub fn health_check_path(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.health_check_path(inp);
            self
        }
        /// <p>The path you provided to perform the load balancer health check. If you didn't specify a
        /// health check path, Lightsail uses the root path of your website (e.g.,
        /// <code>"/"</code>).</p>
        /// <p>You may want to specify a custom health check path other than the root of your application
        /// if your home page loads slowly or has a lot of media or scripting on it.</p>
        pub fn set_health_check_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_health_check_path(input);
            self
        }
        /// <p>The name of the SSL/TLS certificate.</p>
        /// <p>If you specify <code>certificateName</code>, then <code>certificateDomainName</code> is
        /// required (and vice-versa).</p>
        pub fn certificate_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_name(inp);
            self
        }
        /// <p>The name of the SSL/TLS certificate.</p>
        /// <p>If you specify <code>certificateName</code>, then <code>certificateDomainName</code> is
        /// required (and vice-versa).</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_name(input);
            self
        }
        /// <p>The domain name with which your certificate is associated (e.g.,
        /// <code>example.com</code>).</p>
        /// <p>If you specify <code>certificateDomainName</code>, then <code>certificateName</code> is
        /// required (and vice-versa).</p>
        pub fn certificate_domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_domain_name(inp);
            self
        }
        /// <p>The domain name with which your certificate is associated (e.g.,
        /// <code>example.com</code>).</p>
        /// <p>If you specify <code>certificateDomainName</code>, then <code>certificateName</code> is
        /// required (and vice-versa).</p>
        pub fn set_certificate_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_domain_name(input);
            self
        }
        /// Appends an item to `certificateAlternativeNames`.
        ///
        /// To override the contents of this collection use [`set_certificate_alternative_names`](Self::set_certificate_alternative_names).
        ///
        /// <p>The optional alternative domains and subdomains to use with your SSL/TLS certificate
        /// (e.g., <code>www.example.com</code>, <code>example.com</code>, <code>m.example.com</code>,
        /// <code>blog.example.com</code>).</p>
        pub fn certificate_alternative_names(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.certificate_alternative_names(inp);
            self
        }
        /// <p>The optional alternative domains and subdomains to use with your SSL/TLS certificate
        /// (e.g., <code>www.example.com</code>, <code>example.com</code>, <code>m.example.com</code>,
        /// <code>blog.example.com</code>).</p>
        pub fn set_certificate_alternative_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_certificate_alternative_names(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The IP address type for the load balancer.</p>
        ///
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for
        /// IPv4 and IPv6.</p>
        ///
        /// <p>The default value is <code>dualstack</code>.</p>
        pub fn ip_address_type(mut self, inp: crate::model::IpAddressType) -> Self {
            self.inner = self.inner.ip_address_type(inp);
            self
        }
        /// <p>The IP address type for the load balancer.</p>
        ///
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for
        /// IPv4 and IPv6.</p>
        ///
        /// <p>The default value is <code>dualstack</code>.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.inner = self.inner.set_ip_address_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLoadBalancerTlsCertificate`.
    ///
    /// <p>Creates an SSL/TLS certificate for an Amazon Lightsail load balancer.</p>
    /// <p>TLS is just an updated, more secure version of Secure Socket Layer (SSL).</p>
    /// <p>The <code>CreateLoadBalancerTlsCertificate</code> operation supports tag-based access
    /// control via resource tags applied to the resource identified by <code>load balancer
    /// name</code>. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateLoadBalancerTlsCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_load_balancer_tls_certificate_input::Builder,
    }
    impl<C, M, R> CreateLoadBalancerTlsCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLoadBalancerTlsCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLoadBalancerTlsCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLoadBalancerTlsCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLoadBalancerTlsCertificateInputOperationOutputAlias,
                crate::output::CreateLoadBalancerTlsCertificateOutput,
                crate::error::CreateLoadBalancerTlsCertificateError,
                crate::input::CreateLoadBalancerTlsCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The load balancer name where you want to create the SSL/TLS certificate.</p>
        pub fn load_balancer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(inp);
            self
        }
        /// <p>The load balancer name where you want to create the SSL/TLS certificate.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// <p>The SSL/TLS certificate name.</p>
        /// <p>You can have up to 10 certificates in your account at one time. Each Lightsail load
        /// balancer can have up to 2 certificates associated with it at one time. There is also an
        /// overall limit to the number of certificates that can be issue in a 365-day period. For more
        /// information, see <a href="http://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html">Limits</a>.</p>
        pub fn certificate_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_name(inp);
            self
        }
        /// <p>The SSL/TLS certificate name.</p>
        /// <p>You can have up to 10 certificates in your account at one time. Each Lightsail load
        /// balancer can have up to 2 certificates associated with it at one time. There is also an
        /// overall limit to the number of certificates that can be issue in a 365-day period. For more
        /// information, see <a href="http://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html">Limits</a>.</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_name(input);
            self
        }
        /// <p>The domain name (e.g., <code>example.com</code>) for your SSL/TLS certificate.</p>
        pub fn certificate_domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_domain_name(inp);
            self
        }
        /// <p>The domain name (e.g., <code>example.com</code>) for your SSL/TLS certificate.</p>
        pub fn set_certificate_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_domain_name(input);
            self
        }
        /// Appends an item to `certificateAlternativeNames`.
        ///
        /// To override the contents of this collection use [`set_certificate_alternative_names`](Self::set_certificate_alternative_names).
        ///
        /// <p>An array of strings listing alternative domains and subdomains for your SSL/TLS
        /// certificate. Lightsail will de-dupe the names for you. You can have a maximum of 9
        /// alternative names (in addition to the 1 primary domain). We do not support wildcards (e.g.,
        /// <code>*.example.com</code>).</p>
        pub fn certificate_alternative_names(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.certificate_alternative_names(inp);
            self
        }
        /// <p>An array of strings listing alternative domains and subdomains for your SSL/TLS
        /// certificate. Lightsail will de-dupe the names for you. You can have a maximum of 9
        /// alternative names (in addition to the 1 primary domain). We do not support wildcards (e.g.,
        /// <code>*.example.com</code>).</p>
        pub fn set_certificate_alternative_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_certificate_alternative_names(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRelationalDatabase`.
    ///
    /// <p>Creates a new database in Amazon Lightsail.</p>
    /// <p>The <code>create relational database</code> operation supports tag-based access control
    /// via request tags. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRelationalDatabase<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_relational_database_input::Builder,
    }
    impl<C, M, R> CreateRelationalDatabase<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRelationalDatabase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRelationalDatabaseOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRelationalDatabaseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRelationalDatabaseInputOperationOutputAlias,
                crate::output::CreateRelationalDatabaseOutput,
                crate::error::CreateRelationalDatabaseError,
                crate::input::CreateRelationalDatabaseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name to use for your new Lightsail database resource.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 2 to 255 alphanumeric characters, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first and last character must be a letter or number.</p>
        /// </li>
        /// </ul>
        pub fn relational_database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.relational_database_name(inp);
            self
        }
        /// <p>The name to use for your new Lightsail database resource.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 2 to 255 alphanumeric characters, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first and last character must be a letter or number.</p>
        /// </li>
        /// </ul>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_name(input);
            self
        }
        /// <p>The Availability Zone in which to create your new database. Use the
        /// <code>us-east-2a</code> case-sensitive format.</p>
        /// <p>You can get a list of Availability Zones by using the <code>get regions</code> operation.
        /// Be sure to add the <code>include relational database Availability Zones</code> parameter to
        /// your request.</p>
        pub fn availability_zone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(inp);
            self
        }
        /// <p>The Availability Zone in which to create your new database. Use the
        /// <code>us-east-2a</code> case-sensitive format.</p>
        /// <p>You can get a list of Availability Zones by using the <code>get regions</code> operation.
        /// Be sure to add the <code>include relational database Availability Zones</code> parameter to
        /// your request.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>The blueprint ID for your new database. A blueprint describes the major engine version of
        /// a database.</p>
        /// <p>You can get a list of database blueprints IDs by using the <code>get relational database
        /// blueprints</code> operation.</p>
        pub fn relational_database_blueprint_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.relational_database_blueprint_id(inp);
            self
        }
        /// <p>The blueprint ID for your new database. A blueprint describes the major engine version of
        /// a database.</p>
        /// <p>You can get a list of database blueprints IDs by using the <code>get relational database
        /// blueprints</code> operation.</p>
        pub fn set_relational_database_blueprint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_blueprint_id(input);
            self
        }
        /// <p>The bundle ID for your new database. A bundle describes the performance specifications for
        /// your database.</p>
        /// <p>You can get a list of database bundle IDs by using the <code>get relational database
        /// bundles</code> operation.</p>
        pub fn relational_database_bundle_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.relational_database_bundle_id(inp);
            self
        }
        /// <p>The bundle ID for your new database. A bundle describes the performance specifications for
        /// your database.</p>
        /// <p>You can get a list of database bundle IDs by using the <code>get relational database
        /// bundles</code> operation.</p>
        pub fn set_relational_database_bundle_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_bundle_id(input);
            self
        }
        /// <p>The meaning of this parameter differs according to the database engine you use.</p>
        /// <p>
        /// <b>MySQL</b>
        /// </p>
        /// <p>The name of the database to create when the Lightsail database resource is created. If
        /// this parameter isn't specified, no database is created in the database resource.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1 to 64 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits
        /// (0- 9).</p>
        /// </li>
        /// <li>
        /// <p>Can't be a word reserved by the specified database engine.</p>
        /// <p>For more information about reserved words in MySQL, see the Keywords and Reserved
        /// Words articles for <a href="https://dev.mysql.com/doc/refman/5.6/en/keywords.html">MySQL 5.6</a>, <a href="https://dev.mysql.com/doc/refman/5.7/en/keywords.html">MySQL 5.7</a>, and <a href="https://dev.mysql.com/doc/refman/8.0/en/keywords.html">MySQL 8.0</a>.</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <b>PostgreSQL</b>
        /// </p>
        /// <p>The name of the database to create when the Lightsail database resource is created. If
        /// this parameter isn't specified, a database named <code>postgres</code> is created in the
        /// database resource.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1 to 63 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits
        /// (0- 9).</p>
        /// </li>
        /// <li>
        /// <p>Can't be a word reserved by the specified database engine.</p>
        /// <p>For more information about reserved words in PostgreSQL, see the SQL Key Words
        /// articles for <a href="https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html">PostgreSQL 9.6</a>, <a href="https://www.postgresql.org/docs/10/sql-keywords-appendix.html">PostgreSQL
        /// 10</a>, <a href="https://www.postgresql.org/docs/11/sql-keywords-appendix.html">PostgreSQL 11</a>, and <a href="https://www.postgresql.org/docs/12/sql-keywords-appendix.html">PostgreSQL
        /// 12</a>.</p>
        /// </li>
        /// </ul>
        pub fn master_database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_database_name(inp);
            self
        }
        /// <p>The meaning of this parameter differs according to the database engine you use.</p>
        /// <p>
        /// <b>MySQL</b>
        /// </p>
        /// <p>The name of the database to create when the Lightsail database resource is created. If
        /// this parameter isn't specified, no database is created in the database resource.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1 to 64 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits
        /// (0- 9).</p>
        /// </li>
        /// <li>
        /// <p>Can't be a word reserved by the specified database engine.</p>
        /// <p>For more information about reserved words in MySQL, see the Keywords and Reserved
        /// Words articles for <a href="https://dev.mysql.com/doc/refman/5.6/en/keywords.html">MySQL 5.6</a>, <a href="https://dev.mysql.com/doc/refman/5.7/en/keywords.html">MySQL 5.7</a>, and <a href="https://dev.mysql.com/doc/refman/8.0/en/keywords.html">MySQL 8.0</a>.</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <b>PostgreSQL</b>
        /// </p>
        /// <p>The name of the database to create when the Lightsail database resource is created. If
        /// this parameter isn't specified, a database named <code>postgres</code> is created in the
        /// database resource.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1 to 63 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits
        /// (0- 9).</p>
        /// </li>
        /// <li>
        /// <p>Can't be a word reserved by the specified database engine.</p>
        /// <p>For more information about reserved words in PostgreSQL, see the SQL Key Words
        /// articles for <a href="https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html">PostgreSQL 9.6</a>, <a href="https://www.postgresql.org/docs/10/sql-keywords-appendix.html">PostgreSQL
        /// 10</a>, <a href="https://www.postgresql.org/docs/11/sql-keywords-appendix.html">PostgreSQL 11</a>, and <a href="https://www.postgresql.org/docs/12/sql-keywords-appendix.html">PostgreSQL
        /// 12</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_master_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_database_name(input);
            self
        }
        /// <p>The name for the master user.</p>
        /// <p>
        /// <b>MySQL</b>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Required for MySQL.</p>
        /// </li>
        /// <li>
        /// <p>Must be 1 to 16 letters or numbers. Can contain underscores.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't be a reserved word for the chosen database engine.</p>
        /// <p>For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and
        /// Reserved Words articles for <a href="https://dev.mysql.com/doc/refman/5.6/en/keywords.html">MySQL 5.6</a>, <a href="https://dev.mysql.com/doc/refman/5.7/en/keywords.html">MySQL 5.7</a>, or <a href="https://dev.mysql.com/doc/refman/8.0/en/keywords.html">MySQL 8.0</a>.</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <b>PostgreSQL</b>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Required for PostgreSQL.</p>
        /// </li>
        /// <li>
        /// <p>Must be 1 to 63 letters or numbers. Can contain underscores.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't be a reserved word for the chosen database engine.</p>
        /// <p>For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and
        /// Reserved Words articles for <a href="https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html">PostgreSQL
        /// 9.6</a>, <a href="https://www.postgresql.org/docs/10/sql-keywords-appendix.html">PostgreSQL 10</a>, <a href="https://www.postgresql.org/docs/11/sql-keywords-appendix.html">PostgreSQL
        /// 11</a>, and <a href="https://www.postgresql.org/docs/12/sql-keywords-appendix.html">PostgreSQL
        /// 12</a>.</p>
        /// </li>
        /// </ul>
        pub fn master_username(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_username(inp);
            self
        }
        /// <p>The name for the master user.</p>
        /// <p>
        /// <b>MySQL</b>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Required for MySQL.</p>
        /// </li>
        /// <li>
        /// <p>Must be 1 to 16 letters or numbers. Can contain underscores.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't be a reserved word for the chosen database engine.</p>
        /// <p>For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and
        /// Reserved Words articles for <a href="https://dev.mysql.com/doc/refman/5.6/en/keywords.html">MySQL 5.6</a>, <a href="https://dev.mysql.com/doc/refman/5.7/en/keywords.html">MySQL 5.7</a>, or <a href="https://dev.mysql.com/doc/refman/8.0/en/keywords.html">MySQL 8.0</a>.</p>
        /// </li>
        /// </ul>
        /// <p>
        /// <b>PostgreSQL</b>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Required for PostgreSQL.</p>
        /// </li>
        /// <li>
        /// <p>Must be 1 to 63 letters or numbers. Can contain underscores.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't be a reserved word for the chosen database engine.</p>
        /// <p>For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and
        /// Reserved Words articles for <a href="https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html">PostgreSQL
        /// 9.6</a>, <a href="https://www.postgresql.org/docs/10/sql-keywords-appendix.html">PostgreSQL 10</a>, <a href="https://www.postgresql.org/docs/11/sql-keywords-appendix.html">PostgreSQL
        /// 11</a>, and <a href="https://www.postgresql.org/docs/12/sql-keywords-appendix.html">PostgreSQL
        /// 12</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_username(input);
            self
        }
        /// <p>The password for the master user. The password can include any printable ASCII character
        /// except "/", """, or "@". It cannot contain spaces.</p>
        /// <p>
        /// <b>MySQL</b>
        /// </p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        /// <p>
        /// <b>PostgreSQL</b>
        /// </p>
        /// <p>Constraints: Must contain from 8 to 128 characters.</p>
        pub fn master_user_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_user_password(inp);
            self
        }
        /// <p>The password for the master user. The password can include any printable ASCII character
        /// except "/", """, or "@". It cannot contain spaces.</p>
        /// <p>
        /// <b>MySQL</b>
        /// </p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        /// <p>
        /// <b>PostgreSQL</b>
        /// </p>
        /// <p>Constraints: Must contain from 8 to 128 characters.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_user_password(input);
            self
        }
        /// <p>The daily time range during which automated backups are created for your new database if
        /// automated backups are enabled.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// AWS Region. For more information about the preferred backup window time blocks for each
        /// region, see the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Working With Backups</a> guide in the Amazon Relational Database Service (Amazon RDS) documentation.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the <code>hh24:mi-hh24:mi</code> format.</p>
        /// <p>Example: <code>16:00-16:30</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn preferred_backup_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_backup_window(inp);
            self
        }
        /// <p>The daily time range during which automated backups are created for your new database if
        /// automated backups are enabled.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// AWS Region. For more information about the preferred backup window time blocks for each
        /// region, see the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Working With Backups</a> guide in the Amazon Relational Database Service (Amazon RDS) documentation.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the <code>hh24:mi-hh24:mi</code> format.</p>
        /// <p>Example: <code>16:00-16:30</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_backup_window(input);
            self
        }
        /// <p>The weekly time range during which system maintenance can occur on your new
        /// database.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// AWS Region, occurring on a random day of the week.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.</p>
        /// </li>
        /// <li>
        /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Example: <code>Tue:17:00-Tue:17:30</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn preferred_maintenance_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_maintenance_window(inp);
            self
        }
        /// <p>The weekly time range during which system maintenance can occur on your new
        /// database.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// AWS Region, occurring on a random day of the week.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.</p>
        /// </li>
        /// <li>
        /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Example: <code>Tue:17:00-Tue:17:30</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>Specifies the accessibility options for your new database. A value of <code>true</code>
        /// specifies a database that is available to resources outside of your Lightsail account. A
        /// value of <code>false</code> specifies a database that is available only to your Lightsail
        /// resources in the same region as your database.</p>
        pub fn publicly_accessible(mut self, inp: bool) -> Self {
            self.inner = self.inner.publicly_accessible(inp);
            self
        }
        /// <p>Specifies the accessibility options for your new database. A value of <code>true</code>
        /// specifies a database that is available to resources outside of your Lightsail account. A
        /// value of <code>false</code> specifies a database that is available only to your Lightsail
        /// resources in the same region as your database.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publicly_accessible(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRelationalDatabaseFromSnapshot`.
    ///
    /// <p>Creates a new database from an existing database snapshot in Amazon Lightsail.</p>
    /// <p>You can create a new database from a snapshot in if something goes wrong with your
    /// original database, or to change it to a different plan, such as a high availability or
    /// standard plan.</p>
    /// <p>The <code>create relational database from snapshot</code> operation supports tag-based
    /// access control via request tags and resource tags applied to the resource identified by
    /// relationalDatabaseSnapshotName. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRelationalDatabaseFromSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_relational_database_from_snapshot_input::Builder,
    }
    impl<C, M, R> CreateRelationalDatabaseFromSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRelationalDatabaseFromSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRelationalDatabaseFromSnapshotOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateRelationalDatabaseFromSnapshotError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRelationalDatabaseFromSnapshotInputOperationOutputAlias,
                crate::output::CreateRelationalDatabaseFromSnapshotOutput,
                crate::error::CreateRelationalDatabaseFromSnapshotError,
                crate::input::CreateRelationalDatabaseFromSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name to use for your new Lightsail database resource.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 2 to 255 alphanumeric characters, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first and last character must be a letter or number.</p>
        /// </li>
        /// </ul>
        pub fn relational_database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.relational_database_name(inp);
            self
        }
        /// <p>The name to use for your new Lightsail database resource.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 2 to 255 alphanumeric characters, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first and last character must be a letter or number.</p>
        /// </li>
        /// </ul>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_name(input);
            self
        }
        /// <p>The Availability Zone in which to create your new database. Use the
        /// <code>us-east-2a</code> case-sensitive format.</p>
        /// <p>You can get a list of Availability Zones by using the <code>get regions</code> operation.
        /// Be sure to add the <code>include relational database Availability Zones</code> parameter to
        /// your request.</p>
        pub fn availability_zone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(inp);
            self
        }
        /// <p>The Availability Zone in which to create your new database. Use the
        /// <code>us-east-2a</code> case-sensitive format.</p>
        /// <p>You can get a list of Availability Zones by using the <code>get regions</code> operation.
        /// Be sure to add the <code>include relational database Availability Zones</code> parameter to
        /// your request.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>Specifies the accessibility options for your new database. A value of <code>true</code>
        /// specifies a database that is available to resources outside of your Lightsail account. A
        /// value of <code>false</code> specifies a database that is available only to your Lightsail
        /// resources in the same region as your database.</p>
        pub fn publicly_accessible(mut self, inp: bool) -> Self {
            self.inner = self.inner.publicly_accessible(inp);
            self
        }
        /// <p>Specifies the accessibility options for your new database. A value of <code>true</code>
        /// specifies a database that is available to resources outside of your Lightsail account. A
        /// value of <code>false</code> specifies a database that is available only to your Lightsail
        /// resources in the same region as your database.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publicly_accessible(input);
            self
        }
        /// <p>The name of the database snapshot from which to create your new database.</p>
        pub fn relational_database_snapshot_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.relational_database_snapshot_name(inp);
            self
        }
        /// <p>The name of the database snapshot from which to create your new database.</p>
        pub fn set_relational_database_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_snapshot_name(input);
            self
        }
        /// <p>The bundle ID for your new database. A bundle describes the performance specifications for
        /// your database.</p>
        /// <p>You can get a list of database bundle IDs by using the <code>get relational database
        /// bundles</code> operation.</p>
        /// <p>When creating a new database from a snapshot, you cannot choose a bundle that is smaller
        /// than the bundle of the source database.</p>
        pub fn relational_database_bundle_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.relational_database_bundle_id(inp);
            self
        }
        /// <p>The bundle ID for your new database. A bundle describes the performance specifications for
        /// your database.</p>
        /// <p>You can get a list of database bundle IDs by using the <code>get relational database
        /// bundles</code> operation.</p>
        /// <p>When creating a new database from a snapshot, you cannot choose a bundle that is smaller
        /// than the bundle of the source database.</p>
        pub fn set_relational_database_bundle_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_bundle_id(input);
            self
        }
        /// <p>The name of the source database.</p>
        pub fn source_relational_database_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.source_relational_database_name(inp);
            self
        }
        /// <p>The name of the source database.</p>
        pub fn set_source_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_relational_database_name(input);
            self
        }
        /// <p>The date and time to restore your database from.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be before the latest restorable time for the database.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be specified if the <code>use latest restorable time</code> parameter is
        /// <code>true</code>.</p>
        /// </li>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Specified in the Unix time format.</p>
        /// <p>For example, if you wish to use a restore time of October 1, 2018, at 8 PM UTC, then
        /// you input <code>1538424000</code> as the restore time.</p>
        /// </li>
        /// </ul>
        pub fn restore_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.restore_time(inp);
            self
        }
        /// <p>The date and time to restore your database from.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be before the latest restorable time for the database.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be specified if the <code>use latest restorable time</code> parameter is
        /// <code>true</code>.</p>
        /// </li>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Specified in the Unix time format.</p>
        /// <p>For example, if you wish to use a restore time of October 1, 2018, at 8 PM UTC, then
        /// you input <code>1538424000</code> as the restore time.</p>
        /// </li>
        /// </ul>
        pub fn set_restore_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_restore_time(input);
            self
        }
        /// <p>Specifies whether your database is restored from the latest backup time. A value of
        /// <code>true</code> restores from the latest backup time. </p>
        /// <p>Default: <code>false</code>
        /// </p>
        /// <p>Constraints: Cannot be specified if the <code>restore time</code> parameter is
        /// provided.</p>
        pub fn use_latest_restorable_time(mut self, inp: bool) -> Self {
            self.inner = self.inner.use_latest_restorable_time(inp);
            self
        }
        /// <p>Specifies whether your database is restored from the latest backup time. A value of
        /// <code>true</code> restores from the latest backup time. </p>
        /// <p>Default: <code>false</code>
        /// </p>
        /// <p>Constraints: Cannot be specified if the <code>restore time</code> parameter is
        /// provided.</p>
        pub fn set_use_latest_restorable_time(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_use_latest_restorable_time(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRelationalDatabaseSnapshot`.
    ///
    /// <p>Creates a snapshot of your database in Amazon Lightsail. You can use snapshots for backups,
    /// to make copies of a database, and to save data before deleting a database.</p>
    /// <p>The <code>create relational database snapshot</code> operation supports tag-based access
    /// control via request tags. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRelationalDatabaseSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_relational_database_snapshot_input::Builder,
    }
    impl<C, M, R> CreateRelationalDatabaseSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRelationalDatabaseSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRelationalDatabaseSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRelationalDatabaseSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRelationalDatabaseSnapshotInputOperationOutputAlias,
                crate::output::CreateRelationalDatabaseSnapshotOutput,
                crate::error::CreateRelationalDatabaseSnapshotError,
                crate::input::CreateRelationalDatabaseSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the database on which to base your new snapshot.</p>
        pub fn relational_database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.relational_database_name(inp);
            self
        }
        /// <p>The name of the database on which to base your new snapshot.</p>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_name(input);
            self
        }
        /// <p>The name for your new database snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 2 to 255 alphanumeric characters, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first and last character must be a letter or number.</p>
        /// </li>
        /// </ul>
        pub fn relational_database_snapshot_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.relational_database_snapshot_name(inp);
            self
        }
        /// <p>The name for your new database snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 2 to 255 alphanumeric characters, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first and last character must be a letter or number.</p>
        /// </li>
        /// </ul>
        pub fn set_relational_database_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_snapshot_name(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAlarm`.
    ///
    /// <p>Deletes an alarm.</p>
    /// <p>An alarm is used to monitor a single metric for one of your resources. When a metric
    /// condition is met, the alarm can notify you by email, SMS text message, and a banner displayed
    /// on the Amazon Lightsail console. For more information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms">Alarms
    /// in Amazon Lightsail</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAlarm<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_alarm_input::Builder,
    }
    impl<C, M, R> DeleteAlarm<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAlarm`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAlarmOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAlarmError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAlarmInputOperationOutputAlias,
                crate::output::DeleteAlarmOutput,
                crate::error::DeleteAlarmError,
                crate::input::DeleteAlarmInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the alarm to delete.</p>
        pub fn alarm_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alarm_name(inp);
            self
        }
        /// <p>The name of the alarm to delete.</p>
        pub fn set_alarm_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alarm_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAutoSnapshot`.
    ///
    /// <p>Deletes an automatic snapshot of an instance or disk. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAutoSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_auto_snapshot_input::Builder,
    }
    impl<C, M, R> DeleteAutoSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAutoSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAutoSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAutoSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAutoSnapshotInputOperationOutputAlias,
                crate::output::DeleteAutoSnapshotOutput,
                crate::error::DeleteAutoSnapshotError,
                crate::input::DeleteAutoSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the source instance or disk from which to delete the automatic
        /// snapshot.</p>
        pub fn resource_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(inp);
            self
        }
        /// <p>The name of the source instance or disk from which to delete the automatic
        /// snapshot.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// <p>The date of the automatic snapshot to delete in <code>YYYY-MM-DD</code> format. Use the
        /// <code>get auto snapshots</code> operation to get the available automatic snapshots for a
        /// resource.</p>
        pub fn date(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.date(inp);
            self
        }
        /// <p>The date of the automatic snapshot to delete in <code>YYYY-MM-DD</code> format. Use the
        /// <code>get auto snapshots</code> operation to get the available automatic snapshots for a
        /// resource.</p>
        pub fn set_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_date(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBucket`.
    ///
    /// <p>Deletes a Amazon Lightsail bucket.</p>
    ///
    /// <note>
    /// <p>When you delete your bucket, the bucket name is released and can be reused for a new
    /// bucket in your account or another AWS account.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBucket<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_bucket_input::Builder,
    }
    impl<C, M, R> DeleteBucket<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBucket`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBucketOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBucketError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBucketInputOperationOutputAlias,
                crate::output::DeleteBucketOutput,
                crate::error::DeleteBucketError,
                crate::input::DeleteBucketInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket to delete.</p>
        ///
        /// <p>Use the <a>GetBuckets</a> action to get a list of bucket names that you can
        /// specify.</p>
        pub fn bucket_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket_name(inp);
            self
        }
        /// <p>The name of the bucket to delete.</p>
        ///
        /// <p>Use the <a>GetBuckets</a> action to get a list of bucket names that you can
        /// specify.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket_name(input);
            self
        }
        /// <p>A Boolean value that indicates whether to force delete the bucket.</p>
        ///
        /// <p>You must force delete the bucket if it has one of the following conditions:</p>
        /// <ul>
        /// <li>
        /// <p>The bucket is the origin of a distribution.</p>
        /// </li>
        /// <li>
        /// <p>The bucket has instances that were granted access to it using the <a>SetResourceAccessForBucket</a> action.</p>
        /// </li>
        /// <li>
        /// <p>The bucket has objects.</p>
        /// </li>
        /// <li>
        /// <p>The bucket has access keys.</p>
        /// </li>
        /// </ul>
        ///
        /// <important>
        /// <p>Force deleting a bucket might impact other resources that rely on the bucket, such as
        /// instances, distributions, or software that use the issued access keys.</p>
        /// </important>
        pub fn force_delete(mut self, inp: bool) -> Self {
            self.inner = self.inner.force_delete(inp);
            self
        }
        /// <p>A Boolean value that indicates whether to force delete the bucket.</p>
        ///
        /// <p>You must force delete the bucket if it has one of the following conditions:</p>
        /// <ul>
        /// <li>
        /// <p>The bucket is the origin of a distribution.</p>
        /// </li>
        /// <li>
        /// <p>The bucket has instances that were granted access to it using the <a>SetResourceAccessForBucket</a> action.</p>
        /// </li>
        /// <li>
        /// <p>The bucket has objects.</p>
        /// </li>
        /// <li>
        /// <p>The bucket has access keys.</p>
        /// </li>
        /// </ul>
        ///
        /// <important>
        /// <p>Force deleting a bucket might impact other resources that rely on the bucket, such as
        /// instances, distributions, or software that use the issued access keys.</p>
        /// </important>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_delete(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBucketAccessKey`.
    ///
    /// <p>Deletes an access key for the specified Amazon Lightsail bucket.</p>
    ///
    /// <p>We recommend that you delete an access key if the secret access key is compromised.</p>
    ///
    /// <p>For more information about access keys, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-bucket-access-keys">Creating access keys for a bucket in Amazon Lightsail</a> in the
    /// <i>Amazon Lightsail Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBucketAccessKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_bucket_access_key_input::Builder,
    }
    impl<C, M, R> DeleteBucketAccessKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBucketAccessKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBucketAccessKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBucketAccessKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBucketAccessKeyInputOperationOutputAlias,
                crate::output::DeleteBucketAccessKeyOutput,
                crate::error::DeleteBucketAccessKeyError,
                crate::input::DeleteBucketAccessKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket that the access key belongs to.</p>
        pub fn bucket_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket_name(inp);
            self
        }
        /// <p>The name of the bucket that the access key belongs to.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket_name(input);
            self
        }
        /// <p>The ID of the access key to delete.</p>
        ///
        /// <p>Use the <a>GetBucketAccessKeys</a> action to get a list of access key IDs that
        /// you can specify.</p>
        pub fn access_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.access_key_id(inp);
            self
        }
        /// <p>The ID of the access key to delete.</p>
        ///
        /// <p>Use the <a>GetBucketAccessKeys</a> action to get a list of access key IDs that
        /// you can specify.</p>
        pub fn set_access_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_access_key_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCertificate`.
    ///
    /// <p>Deletes an SSL/TLS certificate for your Amazon Lightsail content delivery network (CDN)
    /// distribution.</p>
    /// <p>Certificates that are currently attached to a distribution cannot be deleted. Use the
    /// <code>DetachCertificateFromDistribution</code> action to detach a certificate from a
    /// distribution.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_certificate_input::Builder,
    }
    impl<C, M, R> DeleteCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCertificateInputOperationOutputAlias,
                crate::output::DeleteCertificateOutput,
                crate::error::DeleteCertificateError,
                crate::input::DeleteCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the certificate to delete.</p>
        /// <p>Use the <code>GetCertificates</code> action to get a list of certificate names that you
        /// can specify.</p>
        pub fn certificate_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_name(inp);
            self
        }
        /// <p>The name of the certificate to delete.</p>
        /// <p>Use the <code>GetCertificates</code> action to get a list of certificate names that you
        /// can specify.</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteContactMethod`.
    ///
    /// <p>Deletes a contact method.</p>
    /// <p>A contact method is used to send you notifications about your Amazon Lightsail resources.
    /// You can add one email address and one mobile phone number contact method in each AWS Region.
    /// However, SMS text messaging is not supported in some AWS Regions, and SMS text messages
    /// cannot be sent to some countries/regions. For more information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in Amazon Lightsail</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteContactMethod<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_contact_method_input::Builder,
    }
    impl<C, M, R> DeleteContactMethod<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteContactMethod`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteContactMethodOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteContactMethodError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteContactMethodInputOperationOutputAlias,
                crate::output::DeleteContactMethodOutput,
                crate::error::DeleteContactMethodError,
                crate::input::DeleteContactMethodInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The protocol that will be deleted, such as <code>Email</code> or <code>SMS</code> (text
        /// messaging).</p>
        /// <note>
        /// <p>To delete an <code>Email</code> and an <code>SMS</code> contact method if you added
        /// both, you must run separate <code>DeleteContactMethod</code> actions to delete each
        /// protocol.</p>
        /// </note>
        pub fn protocol(mut self, inp: crate::model::ContactProtocol) -> Self {
            self.inner = self.inner.protocol(inp);
            self
        }
        /// <p>The protocol that will be deleted, such as <code>Email</code> or <code>SMS</code> (text
        /// messaging).</p>
        /// <note>
        /// <p>To delete an <code>Email</code> and an <code>SMS</code> contact method if you added
        /// both, you must run separate <code>DeleteContactMethod</code> actions to delete each
        /// protocol.</p>
        /// </note>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::ContactProtocol>,
        ) -> Self {
            self.inner = self.inner.set_protocol(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteContainerImage`.
    ///
    /// <p>Deletes a container image that is registered to your Amazon Lightsail container
    /// service.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteContainerImage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_container_image_input::Builder,
    }
    impl<C, M, R> DeleteContainerImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteContainerImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteContainerImageOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteContainerImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteContainerImageInputOperationOutputAlias,
                crate::output::DeleteContainerImageOutput,
                crate::error::DeleteContainerImageError,
                crate::input::DeleteContainerImageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container service for which to delete a registered container image.</p>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>The name of the container service for which to delete a registered container image.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
        /// <p>The name of the container image to delete from the container service.</p>
        ///
        /// <p>Use the <code>GetContainerImages</code> action to get the name of the container images
        /// that are registered to a container service.</p>
        ///
        /// <note>
        /// <p>Container images sourced from your Lightsail container service, that are registered
        /// and stored on your service, start with a colon (<code>:</code>). For example,
        /// <code>:container-service-1.mystaticwebsite.1</code>. Container images sourced from a
        /// public registry like Docker Hub don't start with a colon. For example,
        /// <code>nginx:latest</code> or <code>nginx</code>.</p>
        /// </note>
        pub fn image(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.image(inp);
            self
        }
        /// <p>The name of the container image to delete from the container service.</p>
        ///
        /// <p>Use the <code>GetContainerImages</code> action to get the name of the container images
        /// that are registered to a container service.</p>
        ///
        /// <note>
        /// <p>Container images sourced from your Lightsail container service, that are registered
        /// and stored on your service, start with a colon (<code>:</code>). For example,
        /// <code>:container-service-1.mystaticwebsite.1</code>. Container images sourced from a
        /// public registry like Docker Hub don't start with a colon. For example,
        /// <code>nginx:latest</code> or <code>nginx</code>.</p>
        /// </note>
        pub fn set_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_image(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteContainerService`.
    ///
    /// <p>Deletes your Amazon Lightsail container service.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteContainerService<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_container_service_input::Builder,
    }
    impl<C, M, R> DeleteContainerService<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteContainerService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteContainerServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteContainerServiceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteContainerServiceInputOperationOutputAlias,
                crate::output::DeleteContainerServiceOutput,
                crate::error::DeleteContainerServiceError,
                crate::input::DeleteContainerServiceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container service to delete.</p>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>The name of the container service to delete.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDisk`.
    ///
    /// <p>Deletes the specified block storage disk. The disk must be in the <code>available</code>
    /// state (not attached to a Lightsail instance).</p>
    /// <note>
    /// <p>The disk may remain in the <code>deleting</code> state for several minutes.</p>
    /// </note>
    /// <p>The <code>delete disk</code> operation supports tag-based access control via resource tags
    /// applied to the resource identified by <code>disk name</code>. For more information, see the
    /// <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDisk<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_disk_input::Builder,
    }
    impl<C, M, R> DeleteDisk<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDisk`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDiskOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDiskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDiskInputOperationOutputAlias,
                crate::output::DeleteDiskOutput,
                crate::error::DeleteDiskError,
                crate::input::DeleteDiskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the disk you want to delete (e.g., <code>my-disk</code>).</p>
        pub fn disk_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disk_name(inp);
            self
        }
        /// <p>The unique name of the disk you want to delete (e.g., <code>my-disk</code>).</p>
        pub fn set_disk_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_disk_name(input);
            self
        }
        /// <p>A Boolean value to indicate whether to delete the enabled add-ons for the disk.</p>
        pub fn force_delete_add_ons(mut self, inp: bool) -> Self {
            self.inner = self.inner.force_delete_add_ons(inp);
            self
        }
        /// <p>A Boolean value to indicate whether to delete the enabled add-ons for the disk.</p>
        pub fn set_force_delete_add_ons(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_delete_add_ons(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDiskSnapshot`.
    ///
    /// <p>Deletes the specified disk snapshot.</p>
    /// <p>When you make periodic snapshots of a disk, the snapshots are incremental, and only the
    /// blocks on the device that have changed since your last snapshot are saved in the new snapshot.
    /// When you delete a snapshot, only the data not needed for any other snapshot is removed. So
    /// regardless of which prior snapshots have been deleted, all active snapshots will have access
    /// to all the information needed to restore the disk.</p>
    /// <p>The <code>delete disk snapshot</code> operation supports tag-based access control via
    /// resource tags applied to the resource identified by <code>disk snapshot name</code>. For more
    /// information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDiskSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_disk_snapshot_input::Builder,
    }
    impl<C, M, R> DeleteDiskSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDiskSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDiskSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDiskSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDiskSnapshotInputOperationOutputAlias,
                crate::output::DeleteDiskSnapshotOutput,
                crate::error::DeleteDiskSnapshotError,
                crate::input::DeleteDiskSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the disk snapshot you want to delete (e.g.,
        /// <code>my-disk-snapshot</code>).</p>
        pub fn disk_snapshot_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disk_snapshot_name(inp);
            self
        }
        /// <p>The name of the disk snapshot you want to delete (e.g.,
        /// <code>my-disk-snapshot</code>).</p>
        pub fn set_disk_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_disk_snapshot_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDistribution`.
    ///
    /// <p>Deletes your Amazon Lightsail content delivery network (CDN) distribution.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDistribution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_distribution_input::Builder,
    }
    impl<C, M, R> DeleteDistribution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDistribution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDistributionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDistributionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDistributionInputOperationOutputAlias,
                crate::output::DeleteDistributionOutput,
                crate::error::DeleteDistributionError,
                crate::input::DeleteDistributionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the distribution to delete.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you
        /// can specify.</p>
        pub fn distribution_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_name(inp);
            self
        }
        /// <p>The name of the distribution to delete.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you
        /// can specify.</p>
        pub fn set_distribution_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDomain`.
    ///
    /// <p>Deletes the specified domain recordset and all of its domain records.</p>
    /// <p>The <code>delete domain</code> operation supports tag-based access control via resource
    /// tags applied to the resource identified by <code>domain name</code>. For more information, see
    /// the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_domain_input::Builder,
    }
    impl<C, M, R> DeleteDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDomainInputOperationOutputAlias,
                crate::output::DeleteDomainOutput,
                crate::error::DeleteDomainError,
                crate::input::DeleteDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The specific domain name to delete.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The specific domain name to delete.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDomainEntry`.
    ///
    /// <p>Deletes a specific domain entry.</p>
    /// <p>The <code>delete domain entry</code> operation supports tag-based access control via
    /// resource tags applied to the resource identified by <code>domain name</code>. For more
    /// information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDomainEntry<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_domain_entry_input::Builder,
    }
    impl<C, M, R> DeleteDomainEntry<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDomainEntry`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDomainEntryOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDomainEntryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDomainEntryInputOperationOutputAlias,
                crate::output::DeleteDomainEntryOutput,
                crate::error::DeleteDomainEntryError,
                crate::input::DeleteDomainEntryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain entry to delete.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain entry to delete.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>An array of key-value pairs containing information about your domain entries.</p>
        pub fn domain_entry(mut self, inp: crate::model::DomainEntry) -> Self {
            self.inner = self.inner.domain_entry(inp);
            self
        }
        /// <p>An array of key-value pairs containing information about your domain entries.</p>
        pub fn set_domain_entry(
            mut self,
            input: std::option::Option<crate::model::DomainEntry>,
        ) -> Self {
            self.inner = self.inner.set_domain_entry(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInstance`.
    ///
    /// <p>Deletes an Amazon Lightsail instance.</p>
    /// <p>The <code>delete instance</code> operation supports tag-based access control via resource
    /// tags applied to the resource identified by <code>instance name</code>. For more information,
    /// see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_instance_input::Builder,
    }
    impl<C, M, R> DeleteInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteInstanceInputOperationOutputAlias,
                crate::output::DeleteInstanceOutput,
                crate::error::DeleteInstanceError,
                crate::input::DeleteInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the instance to delete.</p>
        pub fn instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_name(inp);
            self
        }
        /// <p>The name of the instance to delete.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_name(input);
            self
        }
        /// <p>A Boolean value to indicate whether to delete the enabled add-ons for the disk.</p>
        pub fn force_delete_add_ons(mut self, inp: bool) -> Self {
            self.inner = self.inner.force_delete_add_ons(inp);
            self
        }
        /// <p>A Boolean value to indicate whether to delete the enabled add-ons for the disk.</p>
        pub fn set_force_delete_add_ons(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_delete_add_ons(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInstanceSnapshot`.
    ///
    /// <p>Deletes a specific snapshot of a virtual private server (or
    /// <i>instance</i>).</p>
    /// <p>The <code>delete instance snapshot</code> operation supports tag-based access control via
    /// resource tags applied to the resource identified by <code>instance snapshot name</code>. For
    /// more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteInstanceSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_instance_snapshot_input::Builder,
    }
    impl<C, M, R> DeleteInstanceSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInstanceSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInstanceSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInstanceSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteInstanceSnapshotInputOperationOutputAlias,
                crate::output::DeleteInstanceSnapshotOutput,
                crate::error::DeleteInstanceSnapshotError,
                crate::input::DeleteInstanceSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the snapshot to delete.</p>
        pub fn instance_snapshot_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_snapshot_name(inp);
            self
        }
        /// <p>The name of the snapshot to delete.</p>
        pub fn set_instance_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_snapshot_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteKeyPair`.
    ///
    /// <p>Deletes a specific SSH key pair.</p>
    ///
    ///
    /// <p>The <code>delete key pair</code> operation supports tag-based access control via resource
    /// tags applied to the resource identified by <code>key pair name</code>. For more information,
    /// see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteKeyPair<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_key_pair_input::Builder,
    }
    impl<C, M, R> DeleteKeyPair<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteKeyPair`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteKeyPairOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteKeyPairError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteKeyPairInputOperationOutputAlias,
                crate::output::DeleteKeyPairOutput,
                crate::error::DeleteKeyPairError,
                crate::input::DeleteKeyPairInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the key pair to delete.</p>
        pub fn key_pair_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_pair_name(inp);
            self
        }
        /// <p>The name of the key pair to delete.</p>
        pub fn set_key_pair_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_key_pair_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteKnownHostKeys`.
    ///
    /// <p>Deletes the known host key or certificate used by the Amazon Lightsail browser-based SSH or
    /// RDP clients to authenticate an instance. This operation enables the Lightsail browser-based
    /// SSH or RDP clients to connect to the instance after a host key mismatch.</p>
    /// <important>
    /// <p>Perform this operation only if you were expecting the host key or certificate mismatch
    /// or if you are familiar with the new host key or certificate on the instance. For more
    /// information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-troubleshooting-browser-based-ssh-rdp-client-connection">Troubleshooting connection issues when using the Amazon Lightsail browser-based SSH or RDP
    /// client</a>.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct DeleteKnownHostKeys<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_known_host_keys_input::Builder,
    }
    impl<C, M, R> DeleteKnownHostKeys<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteKnownHostKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteKnownHostKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteKnownHostKeysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteKnownHostKeysInputOperationOutputAlias,
                crate::output::DeleteKnownHostKeysOutput,
                crate::error::DeleteKnownHostKeysError,
                crate::input::DeleteKnownHostKeysInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the instance for which you want to reset the host key or certificate.</p>
        pub fn instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_name(inp);
            self
        }
        /// <p>The name of the instance for which you want to reset the host key or certificate.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLoadBalancer`.
    ///
    /// <p>Deletes a Lightsail load balancer and all its associated SSL/TLS certificates. Once the
    /// load balancer is deleted, you will need to create a new load balancer, create a new
    /// certificate, and verify domain ownership again.</p>
    /// <p>The <code>delete load balancer</code> operation supports tag-based access control via
    /// resource tags applied to the resource identified by <code>load balancer name</code>. For more
    /// information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteLoadBalancer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_load_balancer_input::Builder,
    }
    impl<C, M, R> DeleteLoadBalancer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLoadBalancer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLoadBalancerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLoadBalancerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLoadBalancerInputOperationOutputAlias,
                crate::output::DeleteLoadBalancerOutput,
                crate::error::DeleteLoadBalancerError,
                crate::input::DeleteLoadBalancerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer you want to delete.</p>
        pub fn load_balancer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(inp);
            self
        }
        /// <p>The name of the load balancer you want to delete.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLoadBalancerTlsCertificate`.
    ///
    /// <p>Deletes an SSL/TLS certificate associated with a Lightsail load balancer.</p>
    /// <p>The <code>DeleteLoadBalancerTlsCertificate</code> operation supports tag-based access
    /// control via resource tags applied to the resource identified by <code>load balancer
    /// name</code>. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteLoadBalancerTlsCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_load_balancer_tls_certificate_input::Builder,
    }
    impl<C, M, R> DeleteLoadBalancerTlsCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLoadBalancerTlsCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLoadBalancerTlsCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLoadBalancerTlsCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLoadBalancerTlsCertificateInputOperationOutputAlias,
                crate::output::DeleteLoadBalancerTlsCertificateOutput,
                crate::error::DeleteLoadBalancerTlsCertificateError,
                crate::input::DeleteLoadBalancerTlsCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The load balancer name.</p>
        pub fn load_balancer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(inp);
            self
        }
        /// <p>The load balancer name.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// <p>The SSL/TLS certificate name.</p>
        pub fn certificate_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_name(inp);
            self
        }
        /// <p>The SSL/TLS certificate name.</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_name(input);
            self
        }
        /// <p>When <code>true</code>, forces the deletion of an SSL/TLS certificate.</p>
        /// <p>There can be two certificates associated with a Lightsail load balancer: the primary and
        /// the backup. The <code>force</code> parameter is required when the primary SSL/TLS certificate
        /// is in use by an instance attached to the load balancer.</p>
        pub fn force(mut self, inp: bool) -> Self {
            self.inner = self.inner.force(inp);
            self
        }
        /// <p>When <code>true</code>, forces the deletion of an SSL/TLS certificate.</p>
        /// <p>There can be two certificates associated with a Lightsail load balancer: the primary and
        /// the backup. The <code>force</code> parameter is required when the primary SSL/TLS certificate
        /// is in use by an instance attached to the load balancer.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRelationalDatabase`.
    ///
    /// <p>Deletes a database in Amazon Lightsail.</p>
    /// <p>The <code>delete relational database</code> operation supports tag-based access control
    /// via resource tags applied to the resource identified by relationalDatabaseName. For more
    /// information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRelationalDatabase<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_relational_database_input::Builder,
    }
    impl<C, M, R> DeleteRelationalDatabase<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRelationalDatabase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRelationalDatabaseOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRelationalDatabaseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRelationalDatabaseInputOperationOutputAlias,
                crate::output::DeleteRelationalDatabaseOutput,
                crate::error::DeleteRelationalDatabaseError,
                crate::input::DeleteRelationalDatabaseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the database that you are deleting.</p>
        pub fn relational_database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.relational_database_name(inp);
            self
        }
        /// <p>The name of the database that you are deleting.</p>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_name(input);
            self
        }
        /// <p>Determines whether a final database snapshot is created before your database is deleted.
        /// If <code>true</code> is specified, no database snapshot is created. If <code>false</code> is
        /// specified, a database snapshot is created before your database is deleted.</p>
        /// <p>You must specify the <code>final relational database snapshot name</code> parameter if the
        /// <code>skip final snapshot</code> parameter is <code>false</code>.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn skip_final_snapshot(mut self, inp: bool) -> Self {
            self.inner = self.inner.skip_final_snapshot(inp);
            self
        }
        /// <p>Determines whether a final database snapshot is created before your database is deleted.
        /// If <code>true</code> is specified, no database snapshot is created. If <code>false</code> is
        /// specified, a database snapshot is created before your database is deleted.</p>
        /// <p>You must specify the <code>final relational database snapshot name</code> parameter if the
        /// <code>skip final snapshot</code> parameter is <code>false</code>.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_skip_final_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_skip_final_snapshot(input);
            self
        }
        /// <p>The name of the database snapshot created if <code>skip final snapshot</code> is
        /// <code>false</code>, which is the default value for that parameter.</p>
        /// <note>
        /// <p>Specifying this parameter and also specifying the <code>skip final snapshot</code>
        /// parameter to <code>true</code> results in an error.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 2 to 255 alphanumeric characters, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first and last character must be a letter or number.</p>
        /// </li>
        /// </ul>
        pub fn final_relational_database_snapshot_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.final_relational_database_snapshot_name(inp);
            self
        }
        /// <p>The name of the database snapshot created if <code>skip final snapshot</code> is
        /// <code>false</code>, which is the default value for that parameter.</p>
        /// <note>
        /// <p>Specifying this parameter and also specifying the <code>skip final snapshot</code>
        /// parameter to <code>true</code> results in an error.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 2 to 255 alphanumeric characters, or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>The first and last character must be a letter or number.</p>
        /// </li>
        /// </ul>
        pub fn set_final_relational_database_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_final_relational_database_snapshot_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRelationalDatabaseSnapshot`.
    ///
    /// <p>Deletes a database snapshot in Amazon Lightsail.</p>
    /// <p>The <code>delete relational database snapshot</code> operation supports tag-based access
    /// control via resource tags applied to the resource identified by relationalDatabaseName. For
    /// more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRelationalDatabaseSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_relational_database_snapshot_input::Builder,
    }
    impl<C, M, R> DeleteRelationalDatabaseSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRelationalDatabaseSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRelationalDatabaseSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRelationalDatabaseSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRelationalDatabaseSnapshotInputOperationOutputAlias,
                crate::output::DeleteRelationalDatabaseSnapshotOutput,
                crate::error::DeleteRelationalDatabaseSnapshotError,
                crate::input::DeleteRelationalDatabaseSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the database snapshot that you are deleting.</p>
        pub fn relational_database_snapshot_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.relational_database_snapshot_name(inp);
            self
        }
        /// <p>The name of the database snapshot that you are deleting.</p>
        pub fn set_relational_database_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_snapshot_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachCertificateFromDistribution`.
    ///
    /// <p>Detaches an SSL/TLS certificate from your Amazon Lightsail content delivery network (CDN)
    /// distribution.</p>
    /// <p>After the certificate is detached, your distribution stops accepting traffic for all of
    /// the domains that are associated with the certificate.</p>
    #[derive(std::fmt::Debug)]
    pub struct DetachCertificateFromDistribution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detach_certificate_from_distribution_input::Builder,
    }
    impl<C, M, R> DetachCertificateFromDistribution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetachCertificateFromDistribution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachCertificateFromDistributionOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachCertificateFromDistributionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetachCertificateFromDistributionInputOperationOutputAlias,
                crate::output::DetachCertificateFromDistributionOutput,
                crate::error::DetachCertificateFromDistributionError,
                crate::input::DetachCertificateFromDistributionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the distribution from which to detach the certificate.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you
        /// can specify.</p>
        pub fn distribution_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_name(inp);
            self
        }
        /// <p>The name of the distribution from which to detach the certificate.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you
        /// can specify.</p>
        pub fn set_distribution_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachDisk`.
    ///
    /// <p>Detaches a stopped block storage disk from a Lightsail instance. Make sure to unmount
    /// any file systems on the device within your operating system before stopping the instance and
    /// detaching the disk.</p>
    /// <p>The <code>detach disk</code> operation supports tag-based access control via resource tags
    /// applied to the resource identified by <code>disk name</code>. For more information, see the
    /// <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DetachDisk<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detach_disk_input::Builder,
    }
    impl<C, M, R> DetachDisk<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetachDisk`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachDiskOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachDiskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetachDiskInputOperationOutputAlias,
                crate::output::DetachDiskOutput,
                crate::error::DetachDiskError,
                crate::input::DetachDiskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the disk you want to detach from your instance (e.g.,
        /// <code>my-disk</code>).</p>
        pub fn disk_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disk_name(inp);
            self
        }
        /// <p>The unique name of the disk you want to detach from your instance (e.g.,
        /// <code>my-disk</code>).</p>
        pub fn set_disk_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_disk_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachInstancesFromLoadBalancer`.
    ///
    /// <p>Detaches the specified instances from a Lightsail load balancer.</p>
    /// <p>This operation waits until the instances are no longer needed before they are detached
    /// from the load balancer.</p>
    /// <p>The <code>detach instances from load balancer</code> operation supports tag-based access
    /// control via resource tags applied to the resource identified by <code>load balancer
    /// name</code>. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DetachInstancesFromLoadBalancer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detach_instances_from_load_balancer_input::Builder,
    }
    impl<C, M, R> DetachInstancesFromLoadBalancer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetachInstancesFromLoadBalancer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachInstancesFromLoadBalancerOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachInstancesFromLoadBalancerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetachInstancesFromLoadBalancerInputOperationOutputAlias,
                crate::output::DetachInstancesFromLoadBalancerOutput,
                crate::error::DetachInstancesFromLoadBalancerError,
                crate::input::DetachInstancesFromLoadBalancerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lightsail load balancer.</p>
        pub fn load_balancer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(inp);
            self
        }
        /// <p>The name of the Lightsail load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// Appends an item to `instanceNames`.
        ///
        /// To override the contents of this collection use [`set_instance_names`](Self::set_instance_names).
        ///
        /// <p>An array of strings containing the names of the instances you want to detach from the load
        /// balancer.</p>
        pub fn instance_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_names(inp);
            self
        }
        /// <p>An array of strings containing the names of the instances you want to detach from the load
        /// balancer.</p>
        pub fn set_instance_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_instance_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetachStaticIp`.
    ///
    /// <p>Detaches a static IP from the Amazon Lightsail instance to which it is attached.</p>
    #[derive(std::fmt::Debug)]
    pub struct DetachStaticIp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detach_static_ip_input::Builder,
    }
    impl<C, M, R> DetachStaticIp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetachStaticIp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetachStaticIpOutput,
            aws_smithy_http::result::SdkError<crate::error::DetachStaticIpError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetachStaticIpInputOperationOutputAlias,
                crate::output::DetachStaticIpOutput,
                crate::error::DetachStaticIpError,
                crate::input::DetachStaticIpInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the static IP to detach from the instance.</p>
        pub fn static_ip_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.static_ip_name(inp);
            self
        }
        /// <p>The name of the static IP to detach from the instance.</p>
        pub fn set_static_ip_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_static_ip_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableAddOn`.
    ///
    /// <p>Disables an add-on for an Amazon Lightsail resource. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisableAddOn<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_add_on_input::Builder,
    }
    impl<C, M, R> DisableAddOn<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableAddOn`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableAddOnOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableAddOnError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableAddOnInputOperationOutputAlias,
                crate::output::DisableAddOnOutput,
                crate::error::DisableAddOnError,
                crate::input::DisableAddOnInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The add-on type to disable.</p>
        pub fn add_on_type(mut self, inp: crate::model::AddOnType) -> Self {
            self.inner = self.inner.add_on_type(inp);
            self
        }
        /// <p>The add-on type to disable.</p>
        pub fn set_add_on_type(
            mut self,
            input: std::option::Option<crate::model::AddOnType>,
        ) -> Self {
            self.inner = self.inner.set_add_on_type(input);
            self
        }
        /// <p>The name of the source resource for which to disable the add-on.</p>
        pub fn resource_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(inp);
            self
        }
        /// <p>The name of the source resource for which to disable the add-on.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DownloadDefaultKeyPair`.
    ///
    /// <p>Downloads the default SSH key pair from the user's account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DownloadDefaultKeyPair<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::download_default_key_pair_input::Builder,
    }
    impl<C, M, R> DownloadDefaultKeyPair<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DownloadDefaultKeyPair`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DownloadDefaultKeyPairOutput,
            aws_smithy_http::result::SdkError<crate::error::DownloadDefaultKeyPairError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DownloadDefaultKeyPairInputOperationOutputAlias,
                crate::output::DownloadDefaultKeyPairOutput,
                crate::error::DownloadDefaultKeyPairError,
                crate::input::DownloadDefaultKeyPairInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `EnableAddOn`.
    ///
    /// <p>Enables or modifies an add-on for an Amazon Lightsail resource. For more information, see
    /// the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct EnableAddOn<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_add_on_input::Builder,
    }
    impl<C, M, R> EnableAddOn<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableAddOn`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableAddOnOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableAddOnError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableAddOnInputOperationOutputAlias,
                crate::output::EnableAddOnOutput,
                crate::error::EnableAddOnError,
                crate::input::EnableAddOnInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the source resource for which to enable or modify the add-on.</p>
        pub fn resource_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(inp);
            self
        }
        /// <p>The name of the source resource for which to enable or modify the add-on.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// <p>An array of strings representing the add-on to enable or modify.</p>
        pub fn add_on_request(mut self, inp: crate::model::AddOnRequest) -> Self {
            self.inner = self.inner.add_on_request(inp);
            self
        }
        /// <p>An array of strings representing the add-on to enable or modify.</p>
        pub fn set_add_on_request(
            mut self,
            input: std::option::Option<crate::model::AddOnRequest>,
        ) -> Self {
            self.inner = self.inner.set_add_on_request(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExportSnapshot`.
    ///
    /// <p>Exports an Amazon Lightsail instance or block storage disk snapshot to Amazon Elastic Compute Cloud (Amazon EC2).
    /// This operation results in an export snapshot record that can be used with the <code>create
    /// cloud formation stack</code> operation to create new Amazon EC2 instances.</p>
    /// <p>Exported instance snapshots appear in Amazon EC2 as Amazon Machine Images (AMIs), and the
    /// instance system disk appears as an Amazon Elastic Block Store (Amazon EBS) volume. Exported disk snapshots appear in
    /// Amazon EC2 as Amazon EBS volumes. Snapshots are exported to the same Amazon Web Services Region in Amazon EC2 as the
    /// source Lightsail snapshot.</p>
    /// <p></p>
    /// <p>The <code>export snapshot</code> operation supports tag-based access control via resource
    /// tags applied to the resource identified by <code>source snapshot name</code>. For more
    /// information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    /// <note>
    /// <p>Use the <code>get instance snapshots</code> or <code>get disk snapshots</code>
    /// operations to get a list of snapshots that you can export to Amazon EC2.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ExportSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::export_snapshot_input::Builder,
    }
    impl<C, M, R> ExportSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExportSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExportSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::ExportSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExportSnapshotInputOperationOutputAlias,
                crate::output::ExportSnapshotOutput,
                crate::error::ExportSnapshotError,
                crate::input::ExportSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the instance or disk snapshot to be exported to Amazon EC2.</p>
        pub fn source_snapshot_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_snapshot_name(inp);
            self
        }
        /// <p>The name of the instance or disk snapshot to be exported to Amazon EC2.</p>
        pub fn set_source_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_snapshot_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetActiveNames`.
    ///
    /// <p>Returns the names of all active (not deleted) resources.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetActiveNames<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_active_names_input::Builder,
    }
    impl<C, M, R> GetActiveNames<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetActiveNames`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetActiveNamesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetActiveNamesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetActiveNamesInputOperationOutputAlias,
                crate::output::GetActiveNamesOutput,
                crate::error::GetActiveNamesError,
                crate::input::GetActiveNamesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetActiveNames</code> request. If your
        /// results are paginated, the response will return a next page token that you can specify as the
        /// page token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetActiveNames</code> request. If your
        /// results are paginated, the response will return a next page token that you can specify as the
        /// page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAlarms`.
    ///
    /// <p>Returns information about the configured alarms. Specify an alarm name in your request to
    /// return information about a specific alarm, or specify a monitored resource name to return
    /// information about all alarms for a specific resource.</p>
    /// <p>An alarm is used to monitor a single metric for one of your resources. When a metric
    /// condition is met, the alarm can notify you by email, SMS text message, and a banner displayed
    /// on the Amazon Lightsail console. For more information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms">Alarms
    /// in Amazon Lightsail</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAlarms<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_alarms_input::Builder,
    }
    impl<C, M, R> GetAlarms<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAlarms`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAlarmsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAlarmsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAlarmsInputOperationOutputAlias,
                crate::output::GetAlarmsOutput,
                crate::error::GetAlarmsError,
                crate::input::GetAlarmsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the alarm.</p>
        /// <p>Specify an alarm name to return information about a specific alarm.</p>
        pub fn alarm_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alarm_name(inp);
            self
        }
        /// <p>The name of the alarm.</p>
        /// <p>Specify an alarm name to return information about a specific alarm.</p>
        pub fn set_alarm_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alarm_name(input);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetAlarms</code> request. If your results
        /// are paginated, the response will return a next page token that you can specify as the page
        /// token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetAlarms</code> request. If your results
        /// are paginated, the response will return a next page token that you can specify as the page
        /// token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>The name of the Lightsail resource being monitored by the alarm.</p>
        /// <p>Specify a monitored resource name to return information about all alarms for a specific
        /// resource.</p>
        pub fn monitored_resource_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.monitored_resource_name(inp);
            self
        }
        /// <p>The name of the Lightsail resource being monitored by the alarm.</p>
        /// <p>Specify a monitored resource name to return information about all alarms for a specific
        /// resource.</p>
        pub fn set_monitored_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_monitored_resource_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAutoSnapshots`.
    ///
    /// <p>Returns the available automatic snapshots for an instance or disk. For more information,
    /// see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAutoSnapshots<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_auto_snapshots_input::Builder,
    }
    impl<C, M, R> GetAutoSnapshots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAutoSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAutoSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAutoSnapshotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAutoSnapshotsInputOperationOutputAlias,
                crate::output::GetAutoSnapshotsOutput,
                crate::error::GetAutoSnapshotsError,
                crate::input::GetAutoSnapshotsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the source instance or disk from which to get automatic snapshot
        /// information.</p>
        pub fn resource_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(inp);
            self
        }
        /// <p>The name of the source instance or disk from which to get automatic snapshot
        /// information.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBlueprints`.
    ///
    /// <p>Returns the list of available instance images, or <i>blueprints</i>. You can
    /// use a blueprint to create a new instance already running a specific operating system, as well
    /// as a preinstalled app or development stack. The software each instance is running depends on
    /// the blueprint image you choose.</p>
    /// <note>
    /// <p>Use active blueprints when creating new instances. Inactive blueprints are listed to
    /// support customers with existing instances and are not necessarily available to create new
    /// instances. Blueprints are marked inactive when they become outdated due to operating system
    /// updates or new application releases.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetBlueprints<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_blueprints_input::Builder,
    }
    impl<C, M, R> GetBlueprints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBlueprints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBlueprintsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBlueprintsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBlueprintsInputOperationOutputAlias,
                crate::output::GetBlueprintsOutput,
                crate::error::GetBlueprintsError,
                crate::input::GetBlueprintsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A Boolean value indicating whether to include inactive results in your request.</p>
        pub fn include_inactive(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_inactive(inp);
            self
        }
        /// <p>A Boolean value indicating whether to include inactive results in your request.</p>
        pub fn set_include_inactive(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_inactive(input);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetBlueprints</code> request. If your
        /// results are paginated, the response will return a next page token that you can specify as the
        /// page token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetBlueprints</code> request. If your
        /// results are paginated, the response will return a next page token that you can specify as the
        /// page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketAccessKeys`.
    ///
    /// <p>Returns the existing access key IDs for the specified Amazon Lightsail bucket.</p>
    ///
    /// <important>
    /// <p>This action does not return the secret access key value of an access key. You can get a
    /// secret access key only when you create it from the response of the <a>CreateBucketAccessKey</a> action. If you lose the secret access key, you must
    /// create a new access key.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct GetBucketAccessKeys<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_bucket_access_keys_input::Builder,
    }
    impl<C, M, R> GetBucketAccessKeys<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBucketAccessKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketAccessKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketAccessKeysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBucketAccessKeysInputOperationOutputAlias,
                crate::output::GetBucketAccessKeysOutput,
                crate::error::GetBucketAccessKeysError,
                crate::input::GetBucketAccessKeysInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket for which to return access keys.</p>
        pub fn bucket_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket_name(inp);
            self
        }
        /// <p>The name of the bucket for which to return access keys.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketBundles`.
    ///
    /// <p>Returns the bundles that you can apply to a Amazon Lightsail bucket.</p>
    ///
    /// <p>The bucket bundle specifies the monthly cost, storage quota, and data transfer quota for a
    /// bucket.</p>
    ///
    /// <p>Use the <a>UpdateBucketBundle</a> action to update the bundle for a
    /// bucket.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBucketBundles<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_bucket_bundles_input::Builder,
    }
    impl<C, M, R> GetBucketBundles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBucketBundles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketBundlesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketBundlesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBucketBundlesInputOperationOutputAlias,
                crate::output::GetBucketBundlesOutput,
                crate::error::GetBucketBundlesError,
                crate::input::GetBucketBundlesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A Boolean value that indicates whether to include inactive (unavailable) bundles in the
        /// response.</p>
        pub fn include_inactive(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_inactive(inp);
            self
        }
        /// <p>A Boolean value that indicates whether to include inactive (unavailable) bundles in the
        /// response.</p>
        pub fn set_include_inactive(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_inactive(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBucketMetricData`.
    ///
    /// <p>Returns the data points of a specific metric for an Amazon Lightsail bucket.</p>
    ///
    /// <p>Metrics report the utilization of a bucket. View and collect metric data regularly to
    /// monitor the number of objects stored in a bucket (including object versions) and the storage
    /// space used by those objects.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBucketMetricData<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_bucket_metric_data_input::Builder,
    }
    impl<C, M, R> GetBucketMetricData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBucketMetricData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketMetricDataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketMetricDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBucketMetricDataInputOperationOutputAlias,
                crate::output::GetBucketMetricDataOutput,
                crate::error::GetBucketMetricDataError,
                crate::input::GetBucketMetricDataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket for which to get metric data.</p>
        pub fn bucket_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket_name(inp);
            self
        }
        /// <p>The name of the bucket for which to get metric data.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket_name(input);
            self
        }
        /// <p>The metric for which you want to return information.</p>
        ///
        /// <p>Valid bucket metric names are listed below, along with the most useful statistics to
        /// include in your request, and the published unit value.</p>
        ///
        /// <note>
        /// <p>These bucket metrics are reported once per day.</p>
        /// </note>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>BucketSizeBytes</code>
        /// </b> - The amount of data in
        /// bytes stored in a bucket. This value is calculated by summing the size of all objects in
        /// the bucket (including object versions), including the size of all parts for all incomplete
        /// multipart uploads to the bucket.</p>
        /// <p>Statistics: The most useful statistic is <code>Maximum</code>.</p>
        /// <p>Unit: The published unit is <code>Bytes</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NumberOfObjects</code>
        /// </b> - The total number of
        /// objects stored in a bucket. This value is calculated by counting all objects in the bucket
        /// (including object versions) and the total number of parts for all incomplete multipart
        /// uploads to the bucket.</p>
        /// <p>Statistics: The most useful statistic is <code>Average</code>.</p>
        /// <p>Unit: The published unit is <code>Count</code>.</p>
        /// </li>
        /// </ul>
        pub fn metric_name(mut self, inp: crate::model::BucketMetricName) -> Self {
            self.inner = self.inner.metric_name(inp);
            self
        }
        /// <p>The metric for which you want to return information.</p>
        ///
        /// <p>Valid bucket metric names are listed below, along with the most useful statistics to
        /// include in your request, and the published unit value.</p>
        ///
        /// <note>
        /// <p>These bucket metrics are reported once per day.</p>
        /// </note>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>BucketSizeBytes</code>
        /// </b> - The amount of data in
        /// bytes stored in a bucket. This value is calculated by summing the size of all objects in
        /// the bucket (including object versions), including the size of all parts for all incomplete
        /// multipart uploads to the bucket.</p>
        /// <p>Statistics: The most useful statistic is <code>Maximum</code>.</p>
        /// <p>Unit: The published unit is <code>Bytes</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NumberOfObjects</code>
        /// </b> - The total number of
        /// objects stored in a bucket. This value is calculated by counting all objects in the bucket
        /// (including object versions) and the total number of parts for all incomplete multipart
        /// uploads to the bucket.</p>
        /// <p>Statistics: The most useful statistic is <code>Average</code>.</p>
        /// <p>Unit: The published unit is <code>Count</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_metric_name(
            mut self,
            input: std::option::Option<crate::model::BucketMetricName>,
        ) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
        /// <p>The timestamp indicating the earliest data to be returned.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The timestamp indicating the earliest data to be returned.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The timestamp indicating the latest data to be returned.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The timestamp indicating the latest data to be returned.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The granularity, in seconds, of the returned data points.</p>
        /// <note>
        /// <p>Bucket storage metrics are reported once per day. Therefore, you should specify a period
        /// of 86400 seconds, which is the number of seconds in a day.</p>
        /// </note>
        pub fn period(mut self, inp: i32) -> Self {
            self.inner = self.inner.period(inp);
            self
        }
        /// <p>The granularity, in seconds, of the returned data points.</p>
        /// <note>
        /// <p>Bucket storage metrics are reported once per day. Therefore, you should specify a period
        /// of 86400 seconds, which is the number of seconds in a day.</p>
        /// </note>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_period(input);
            self
        }
        /// Appends an item to `statistics`.
        ///
        /// To override the contents of this collection use [`set_statistics`](Self::set_statistics).
        ///
        /// <p>The statistic for the metric.</p>
        ///
        /// <p>The following statistics are available:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Minimum</code> - The lowest value observed during the specified period. Use this
        /// value to determine low volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Maximum</code> - The highest value observed during the specified period. Use
        /// this value to determine high volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Sum</code> - The sum of all values submitted for the matching metric. You can
        /// use this statistic to determine the total volume of a metric.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Average</code> - The value of <code>Sum</code> / <code>SampleCount</code> during
        /// the specified period. By comparing this statistic with the <code>Minimum</code> and
        /// <code>Maximum</code> values, you can determine the full scope of a metric and how close
        /// the average use is to the <code>Minimum</code> and <code>Maximum</code> values. This
        /// comparison helps you to know when to increase or decrease your resources.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SampleCount</code> - The count, or number, of data points used for the
        /// statistical calculation.</p>
        /// </li>
        /// </ul>
        pub fn statistics(mut self, inp: impl Into<crate::model::MetricStatistic>) -> Self {
            self.inner = self.inner.statistics(inp);
            self
        }
        /// <p>The statistic for the metric.</p>
        ///
        /// <p>The following statistics are available:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Minimum</code> - The lowest value observed during the specified period. Use this
        /// value to determine low volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Maximum</code> - The highest value observed during the specified period. Use
        /// this value to determine high volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Sum</code> - The sum of all values submitted for the matching metric. You can
        /// use this statistic to determine the total volume of a metric.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Average</code> - The value of <code>Sum</code> / <code>SampleCount</code> during
        /// the specified period. By comparing this statistic with the <code>Minimum</code> and
        /// <code>Maximum</code> values, you can determine the full scope of a metric and how close
        /// the average use is to the <code>Minimum</code> and <code>Maximum</code> values. This
        /// comparison helps you to know when to increase or decrease your resources.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SampleCount</code> - The count, or number, of data points used for the
        /// statistical calculation.</p>
        /// </li>
        /// </ul>
        pub fn set_statistics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricStatistic>>,
        ) -> Self {
            self.inner = self.inner.set_statistics(input);
            self
        }
        /// <p>The unit for the metric data request.</p>
        /// <p>Valid units depend on the metric data being requested. For the valid units with each
        /// available metric, see the <code>metricName</code> parameter.</p>
        pub fn unit(mut self, inp: crate::model::MetricUnit) -> Self {
            self.inner = self.inner.unit(inp);
            self
        }
        /// <p>The unit for the metric data request.</p>
        /// <p>Valid units depend on the metric data being requested. For the valid units with each
        /// available metric, see the <code>metricName</code> parameter.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::MetricUnit>) -> Self {
            self.inner = self.inner.set_unit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBuckets`.
    ///
    /// <p>Returns information about one or more Amazon Lightsail buckets.</p>
    ///
    /// <p>For more information about buckets, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/buckets-in-amazon-lightsail">Buckets in Amazon Lightsail</a> in the <i>Amazon Lightsail Developer
    /// Guide</i>..</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBuckets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_buckets_input::Builder,
    }
    impl<C, M, R> GetBuckets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBuckets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBucketsInputOperationOutputAlias,
                crate::output::GetBucketsOutput,
                crate::error::GetBucketsError,
                crate::input::GetBucketsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket for which to return information.</p>
        ///
        /// <p>When omitted, the response includes all of your buckets in the AWS Region where the
        /// request is made.</p>
        pub fn bucket_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket_name(inp);
            self
        }
        /// <p>The name of the bucket for which to return information.</p>
        ///
        /// <p>When omitted, the response includes all of your buckets in the AWS Region where the
        /// request is made.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket_name(input);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        ///
        /// <p>To get a page token, perform an initial <code>GetBuckets</code> request. If your results
        /// are paginated, the response will return a next page token that you can specify as the page
        /// token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        ///
        /// <p>To get a page token, perform an initial <code>GetBuckets</code> request. If your results
        /// are paginated, the response will return a next page token that you can specify as the page
        /// token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
        /// <p>A Boolean value that indicates whether to include Lightsail instances that were given
        /// access to the bucket using the <a>SetResourceAccessForBucket</a> action.</p>
        pub fn include_connected_resources(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_connected_resources(inp);
            self
        }
        /// <p>A Boolean value that indicates whether to include Lightsail instances that were given
        /// access to the bucket using the <a>SetResourceAccessForBucket</a> action.</p>
        pub fn set_include_connected_resources(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_connected_resources(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBundles`.
    ///
    /// <p>Returns the list of bundles that are available for purchase. A bundle describes the specs
    /// for your virtual private server (or <i>instance</i>).</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBundles<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_bundles_input::Builder,
    }
    impl<C, M, R> GetBundles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBundles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBundlesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBundlesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBundlesInputOperationOutputAlias,
                crate::output::GetBundlesOutput,
                crate::error::GetBundlesError,
                crate::input::GetBundlesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A Boolean value that indicates whether to include inactive bundle results in your
        /// request.</p>
        pub fn include_inactive(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_inactive(inp);
            self
        }
        /// <p>A Boolean value that indicates whether to include inactive bundle results in your
        /// request.</p>
        pub fn set_include_inactive(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_inactive(input);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetBundles</code> request. If your results
        /// are paginated, the response will return a next page token that you can specify as the page
        /// token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetBundles</code> request. If your results
        /// are paginated, the response will return a next page token that you can specify as the page
        /// token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCertificates`.
    ///
    /// <p>Returns information about one or more Amazon Lightsail SSL/TLS certificates.</p>
    /// <note>
    /// <p>To get a summary of a certificate, ommit <code>includeCertificateDetails</code> from
    /// your request. The response will include only the certificate Amazon Resource Name (ARN),
    /// certificate name, domain name, and tags.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetCertificates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_certificates_input::Builder,
    }
    impl<C, M, R> GetCertificates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCertificatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCertificatesInputOperationOutputAlias,
                crate::output::GetCertificatesOutput,
                crate::error::GetCertificatesError,
                crate::input::GetCertificatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `certificateStatuses`.
        ///
        /// To override the contents of this collection use [`set_certificate_statuses`](Self::set_certificate_statuses).
        ///
        /// <p>The status of the certificates for which to return information.</p>
        /// <p>For example, specify <code>ISSUED</code> to return only certificates with an
        /// <code>ISSUED</code> status.</p>
        /// <p>When omitted, the response includes all of your certificates in the AWS Region where the
        /// request is made, regardless of their current status.</p>
        pub fn certificate_statuses(
            mut self,
            inp: impl Into<crate::model::CertificateStatus>,
        ) -> Self {
            self.inner = self.inner.certificate_statuses(inp);
            self
        }
        /// <p>The status of the certificates for which to return information.</p>
        /// <p>For example, specify <code>ISSUED</code> to return only certificates with an
        /// <code>ISSUED</code> status.</p>
        /// <p>When omitted, the response includes all of your certificates in the AWS Region where the
        /// request is made, regardless of their current status.</p>
        pub fn set_certificate_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CertificateStatus>>,
        ) -> Self {
            self.inner = self.inner.set_certificate_statuses(input);
            self
        }
        /// <p>Indicates whether to include detailed information about the certificates in the
        /// response.</p>
        /// <p>When omitted, the response includes only the certificate names, Amazon Resource Names
        /// (ARNs), domain names, and tags.</p>
        pub fn include_certificate_details(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_certificate_details(inp);
            self
        }
        /// <p>Indicates whether to include detailed information about the certificates in the
        /// response.</p>
        /// <p>When omitted, the response includes only the certificate names, Amazon Resource Names
        /// (ARNs), domain names, and tags.</p>
        pub fn set_include_certificate_details(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_certificate_details(input);
            self
        }
        /// <p>The name for the certificate for which to return information.</p>
        /// <p>When omitted, the response includes all of your certificates in the AWS Region where the
        /// request is made.</p>
        pub fn certificate_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_name(inp);
            self
        }
        /// <p>The name for the certificate for which to return information.</p>
        /// <p>When omitted, the response includes all of your certificates in the AWS Region where the
        /// request is made.</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCloudFormationStackRecords`.
    ///
    /// <p>Returns the CloudFormation stack record created as a result of the <code>create cloud
    /// formation stack</code> operation.</p>
    /// <p>An AWS CloudFormation stack is used to create a new Amazon EC2 instance from an exported Lightsail
    /// snapshot.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCloudFormationStackRecords<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_cloud_formation_stack_records_input::Builder,
    }
    impl<C, M, R> GetCloudFormationStackRecords<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCloudFormationStackRecords`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCloudFormationStackRecordsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCloudFormationStackRecordsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCloudFormationStackRecordsInputOperationOutputAlias,
                crate::output::GetCloudFormationStackRecordsOutput,
                crate::error::GetCloudFormationStackRecordsError,
                crate::input::GetCloudFormationStackRecordsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetClouFormationStackRecords</code> request.
        /// If your results are paginated, the response will return a next page token that you can specify
        /// as the page token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetClouFormationStackRecords</code> request.
        /// If your results are paginated, the response will return a next page token that you can specify
        /// as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContactMethods`.
    ///
    /// <p>Returns information about the configured contact methods. Specify a protocol in your
    /// request to return information about a specific contact method.</p>
    /// <p>A contact method is used to send you notifications about your Amazon Lightsail resources.
    /// You can add one email address and one mobile phone number contact method in each AWS Region.
    /// However, SMS text messaging is not supported in some AWS Regions, and SMS text messages
    /// cannot be sent to some countries/regions. For more information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in Amazon Lightsail</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetContactMethods<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_contact_methods_input::Builder,
    }
    impl<C, M, R> GetContactMethods<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContactMethods`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContactMethodsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContactMethodsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContactMethodsInputOperationOutputAlias,
                crate::output::GetContactMethodsOutput,
                crate::error::GetContactMethodsError,
                crate::input::GetContactMethodsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `protocols`.
        ///
        /// To override the contents of this collection use [`set_protocols`](Self::set_protocols).
        ///
        /// <p>The protocols used to send notifications, such as <code>Email</code>, or <code>SMS</code>
        /// (text messaging).</p>
        /// <p>Specify a protocol in your request to return information about a specific contact method
        /// protocol.</p>
        pub fn protocols(mut self, inp: impl Into<crate::model::ContactProtocol>) -> Self {
            self.inner = self.inner.protocols(inp);
            self
        }
        /// <p>The protocols used to send notifications, such as <code>Email</code>, or <code>SMS</code>
        /// (text messaging).</p>
        /// <p>Specify a protocol in your request to return information about a specific contact method
        /// protocol.</p>
        pub fn set_protocols(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContactProtocol>>,
        ) -> Self {
            self.inner = self.inner.set_protocols(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContainerAPIMetadata`.
    ///
    /// <p>Returns information about Amazon Lightsail containers, such as the current version of the
    /// Lightsail Control (lightsailctl) plugin.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetContainerAPIMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_container_api_metadata_input::Builder,
    }
    impl<C, M, R> GetContainerAPIMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContainerAPIMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContainerApiMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContainerAPIMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContainerApiMetadataInputOperationOutputAlias,
                crate::output::GetContainerApiMetadataOutput,
                crate::error::GetContainerAPIMetadataError,
                crate::input::GetContainerApiMetadataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetContainerImages`.
    ///
    /// <p>Returns the container images that are registered to your Amazon Lightsail container
    /// service.</p>
    ///
    /// <note>
    /// <p>If you created a deployment on your Lightsail container service that uses container
    /// images from a public registry like Docker Hub, those images are not returned as part of this
    /// action. Those images are not registered to your Lightsail container service.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetContainerImages<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_container_images_input::Builder,
    }
    impl<C, M, R> GetContainerImages<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContainerImages`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContainerImagesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContainerImagesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContainerImagesInputOperationOutputAlias,
                crate::output::GetContainerImagesOutput,
                crate::error::GetContainerImagesError,
                crate::input::GetContainerImagesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container service for which to return registered container images.</p>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>The name of the container service for which to return registered container images.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContainerLog`.
    ///
    /// <p>Returns the log events of a container of your Amazon Lightsail container service.</p>
    ///
    /// <p>If your container service has more than one node (i.e., a scale greater than 1), then the
    /// log events that are returned for the specified container are merged from all nodes on your
    /// container service.</p>
    ///
    /// <note>
    /// <p>Container logs are retained for a certain amount of time. For more information, see
    /// <a href="https://docs.aws.amazon.com/general/latest/gr/lightsail.html">Amazon Lightsail
    /// endpoints and quotas</a> in the <i>AWS General Reference</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetContainerLog<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_container_log_input::Builder,
    }
    impl<C, M, R> GetContainerLog<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContainerLog`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContainerLogOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContainerLogError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContainerLogInputOperationOutputAlias,
                crate::output::GetContainerLogOutput,
                crate::error::GetContainerLogError,
                crate::input::GetContainerLogInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container service for which to get a container log.</p>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>The name of the container service for which to get a container log.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
        /// <p>The name of the container that is either running or previously ran on the container
        /// service for which to return a log.</p>
        pub fn container_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.container_name(inp);
            self
        }
        /// <p>The name of the container that is either running or previously ran on the container
        /// service for which to return a log.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_container_name(input);
            self
        }
        /// <p>The start of the time interval for which to get log data.</p>
        ///
        /// <p>Constraints:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Specified in the Unix time format.</p>
        ///
        /// <p>For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, specify
        /// <code>1538424000</code> as the start time.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>You can convert a human-friendly time to Unix time format using a converter like <a href="https://www.epochconverter.com/">Epoch converter</a>.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The start of the time interval for which to get log data.</p>
        ///
        /// <p>Constraints:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Specified in the Unix time format.</p>
        ///
        /// <p>For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, specify
        /// <code>1538424000</code> as the start time.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>You can convert a human-friendly time to Unix time format using a converter like <a href="https://www.epochconverter.com/">Epoch converter</a>.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time interval for which to get log data.</p>
        ///
        /// <p>Constraints:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Specified in the Unix time format.</p>
        ///
        /// <p>For example, if you wish to use an end time of October 1, 2018, at 9 PM UTC, specify
        /// <code>1538427600</code> as the end time.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>You can convert a human-friendly time to Unix time format using a converter like <a href="https://www.epochconverter.com/">Epoch converter</a>.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The end of the time interval for which to get log data.</p>
        ///
        /// <p>Constraints:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Specified in the Unix time format.</p>
        ///
        /// <p>For example, if you wish to use an end time of October 1, 2018, at 9 PM UTC, specify
        /// <code>1538427600</code> as the end time.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>You can convert a human-friendly time to Unix time format using a converter like <a href="https://www.epochconverter.com/">Epoch converter</a>.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The pattern to use to filter the returned log events to a specific term.</p>
        ///
        /// <p>The following are a few examples of filter patterns that you can specify:</p>
        /// <ul>
        /// <li>
        /// <p>To return all log events, specify a filter pattern of <code>""</code>.</p>
        /// </li>
        /// <li>
        /// <p>To exclude log events that contain the <code>ERROR</code> term, and return all other
        /// log events, specify a filter pattern of <code>"-ERROR"</code>.</p>
        /// </li>
        /// <li>
        /// <p>To return log events that contain the <code>ERROR</code> term, specify a filter
        /// pattern of <code>"ERROR"</code>.</p>
        /// </li>
        /// <li>
        /// <p>To return log events that contain both the <code>ERROR</code> and
        /// <code>Exception</code> terms, specify a filter pattern of <code>"ERROR
        /// Exception"</code>.</p>
        /// </li>
        /// <li>
        /// <p>To return log events that contain the <code>ERROR</code>
        /// <i>or</i> the <code>Exception</code> term, specify a filter pattern of
        /// <code>"?ERROR ?Exception"</code>.</p>
        /// </li>
        /// </ul>
        pub fn filter_pattern(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.filter_pattern(inp);
            self
        }
        /// <p>The pattern to use to filter the returned log events to a specific term.</p>
        ///
        /// <p>The following are a few examples of filter patterns that you can specify:</p>
        /// <ul>
        /// <li>
        /// <p>To return all log events, specify a filter pattern of <code>""</code>.</p>
        /// </li>
        /// <li>
        /// <p>To exclude log events that contain the <code>ERROR</code> term, and return all other
        /// log events, specify a filter pattern of <code>"-ERROR"</code>.</p>
        /// </li>
        /// <li>
        /// <p>To return log events that contain the <code>ERROR</code> term, specify a filter
        /// pattern of <code>"ERROR"</code>.</p>
        /// </li>
        /// <li>
        /// <p>To return log events that contain both the <code>ERROR</code> and
        /// <code>Exception</code> terms, specify a filter pattern of <code>"ERROR
        /// Exception"</code>.</p>
        /// </li>
        /// <li>
        /// <p>To return log events that contain the <code>ERROR</code>
        /// <i>or</i> the <code>Exception</code> term, specify a filter pattern of
        /// <code>"?ERROR ?Exception"</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_filter_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_filter_pattern(input);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        ///
        /// <p>To get a page token, perform an initial <code>GetContainerLog</code> request. If your
        /// results are paginated, the response will return a next page token that you can specify as the
        /// page token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        ///
        /// <p>To get a page token, perform an initial <code>GetContainerLog</code> request. If your
        /// results are paginated, the response will return a next page token that you can specify as the
        /// page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContainerServiceDeployments`.
    ///
    /// <p>Returns the deployments for your Amazon Lightsail container service</p>
    ///
    /// <p>A deployment specifies the settings, such as the ports and launch command, of containers
    /// that are deployed to your container service.</p>
    ///
    /// <p>The deployments are ordered by version in ascending order. The newest version is listed at
    /// the top of the response.</p>
    ///
    /// <note>
    /// <p>A set number of deployments are kept before the oldest one is replaced with the newest
    /// one. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/lightsail.html">Amazon Lightsail
    /// endpoints and quotas</a> in the <i>AWS General Reference</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetContainerServiceDeployments<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_container_service_deployments_input::Builder,
    }
    impl<C, M, R> GetContainerServiceDeployments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContainerServiceDeployments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContainerServiceDeploymentsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContainerServiceDeploymentsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContainerServiceDeploymentsInputOperationOutputAlias,
                crate::output::GetContainerServiceDeploymentsOutput,
                crate::error::GetContainerServiceDeploymentsError,
                crate::input::GetContainerServiceDeploymentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container service for which to return deployments.</p>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>The name of the container service for which to return deployments.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContainerServiceMetricData`.
    ///
    /// <p>Returns the data points of a specific metric of your Amazon Lightsail container
    /// service.</p>
    ///
    /// <p>Metrics report the utilization of your resources. Monitor and collect metric data
    /// regularly to maintain the reliability, availability, and performance of your resources.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetContainerServiceMetricData<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_container_service_metric_data_input::Builder,
    }
    impl<C, M, R> GetContainerServiceMetricData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContainerServiceMetricData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContainerServiceMetricDataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContainerServiceMetricDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContainerServiceMetricDataInputOperationOutputAlias,
                crate::output::GetContainerServiceMetricDataOutput,
                crate::error::GetContainerServiceMetricDataError,
                crate::input::GetContainerServiceMetricDataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container service for which to get metric data.</p>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>The name of the container service for which to get metric data.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
        /// <p>The metric for which you want to return information.</p>
        ///
        /// <p>Valid container service metric names are listed below, along with the most useful
        /// statistics to include in your request, and the published unit value.</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CPUUtilization</code> - The average percentage of compute units that are
        /// currently in use across all nodes of the container service. This metric identifies the
        /// processing power required to run containers on each node of the container service.</p>
        /// <p>Statistics: The most useful statistics are <code>Maximum</code> and
        /// <code>Average</code>.</p>
        /// <p>Unit: The published unit is <code>Percent</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MemoryUtilization</code> - The average percentage of available memory that is
        /// currently in use across all nodes of the container service. This metric identifies the
        /// memory required to run containers on each node of the container service.</p>
        /// <p>Statistics: The most useful statistics are <code>Maximum</code> and
        /// <code>Average</code>.</p>
        /// <p>Unit: The published unit is <code>Percent</code>.</p>
        /// </li>
        /// </ul>
        pub fn metric_name(mut self, inp: crate::model::ContainerServiceMetricName) -> Self {
            self.inner = self.inner.metric_name(inp);
            self
        }
        /// <p>The metric for which you want to return information.</p>
        ///
        /// <p>Valid container service metric names are listed below, along with the most useful
        /// statistics to include in your request, and the published unit value.</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CPUUtilization</code> - The average percentage of compute units that are
        /// currently in use across all nodes of the container service. This metric identifies the
        /// processing power required to run containers on each node of the container service.</p>
        /// <p>Statistics: The most useful statistics are <code>Maximum</code> and
        /// <code>Average</code>.</p>
        /// <p>Unit: The published unit is <code>Percent</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MemoryUtilization</code> - The average percentage of available memory that is
        /// currently in use across all nodes of the container service. This metric identifies the
        /// memory required to run containers on each node of the container service.</p>
        /// <p>Statistics: The most useful statistics are <code>Maximum</code> and
        /// <code>Average</code>.</p>
        /// <p>Unit: The published unit is <code>Percent</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_metric_name(
            mut self,
            input: std::option::Option<crate::model::ContainerServiceMetricName>,
        ) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
        /// <p>The start time of the time period.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The start time of the time period.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end time of the time period.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The end time of the time period.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The granularity, in seconds, of the returned data points.</p>
        ///
        /// <p>All container service metric data is available in 5-minute (300 seconds)
        /// granularity.</p>
        pub fn period(mut self, inp: i32) -> Self {
            self.inner = self.inner.period(inp);
            self
        }
        /// <p>The granularity, in seconds, of the returned data points.</p>
        ///
        /// <p>All container service metric data is available in 5-minute (300 seconds)
        /// granularity.</p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_period(input);
            self
        }
        /// Appends an item to `statistics`.
        ///
        /// To override the contents of this collection use [`set_statistics`](Self::set_statistics).
        ///
        /// <p>The statistic for the metric.</p>
        ///
        /// <p>The following statistics are available:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Minimum</code> - The lowest value observed during the specified period. Use this
        /// value to determine low volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Maximum</code> - The highest value observed during the specified period. Use
        /// this value to determine high volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Sum</code> - All values submitted for the matching metric added together. You
        /// can use this statistic to determine the total volume of a metric.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Average</code> - The value of <code>Sum</code> / <code>SampleCount</code> during
        /// the specified period. By comparing this statistic with the <code>Minimum</code> and
        /// <code>Maximum</code> values, you can determine the full scope of a metric and how close
        /// the average use is to the <code>Minimum</code> and <code>Maximum</code> values. This
        /// comparison helps you to know when to increase or decrease your resources.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SampleCount</code> - The count, or number, of data points used for the
        /// statistical calculation.</p>
        /// </li>
        /// </ul>
        pub fn statistics(mut self, inp: impl Into<crate::model::MetricStatistic>) -> Self {
            self.inner = self.inner.statistics(inp);
            self
        }
        /// <p>The statistic for the metric.</p>
        ///
        /// <p>The following statistics are available:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Minimum</code> - The lowest value observed during the specified period. Use this
        /// value to determine low volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Maximum</code> - The highest value observed during the specified period. Use
        /// this value to determine high volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Sum</code> - All values submitted for the matching metric added together. You
        /// can use this statistic to determine the total volume of a metric.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Average</code> - The value of <code>Sum</code> / <code>SampleCount</code> during
        /// the specified period. By comparing this statistic with the <code>Minimum</code> and
        /// <code>Maximum</code> values, you can determine the full scope of a metric and how close
        /// the average use is to the <code>Minimum</code> and <code>Maximum</code> values. This
        /// comparison helps you to know when to increase or decrease your resources.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SampleCount</code> - The count, or number, of data points used for the
        /// statistical calculation.</p>
        /// </li>
        /// </ul>
        pub fn set_statistics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricStatistic>>,
        ) -> Self {
            self.inner = self.inner.set_statistics(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContainerServicePowers`.
    ///
    /// <p>Returns the list of powers that can be specified for your Amazon Lightsail container
    /// services.</p>
    ///
    /// <p>The power specifies the amount of memory, the number of vCPUs, and the base price of the
    /// container service.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetContainerServicePowers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_container_service_powers_input::Builder,
    }
    impl<C, M, R> GetContainerServicePowers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContainerServicePowers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContainerServicePowersOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContainerServicePowersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContainerServicePowersInputOperationOutputAlias,
                crate::output::GetContainerServicePowersOutput,
                crate::error::GetContainerServicePowersError,
                crate::input::GetContainerServicePowersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetContainerServices`.
    ///
    /// <p>Returns information about one or more of your Amazon Lightsail container services.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetContainerServices<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_container_services_input::Builder,
    }
    impl<C, M, R> GetContainerServices<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContainerServices`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContainerServicesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContainerServicesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContainerServicesInputOperationOutputAlias,
                crate::output::GetContainerServicesOutput,
                crate::error::GetContainerServicesError,
                crate::input::GetContainerServicesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container service for which to return information.</p>
        ///
        /// <p>When omitted, the response includes all of your container services in the AWS Region
        /// where the request is made.</p>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>The name of the container service for which to return information.</p>
        ///
        /// <p>When omitted, the response includes all of your container services in the AWS Region
        /// where the request is made.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDisk`.
    ///
    /// <p>Returns information about a specific block storage disk.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDisk<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_disk_input::Builder,
    }
    impl<C, M, R> GetDisk<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDisk`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDiskOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDiskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDiskInputOperationOutputAlias,
                crate::output::GetDiskOutput,
                crate::error::GetDiskError,
                crate::input::GetDiskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the disk (e.g., <code>my-disk</code>).</p>
        pub fn disk_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disk_name(inp);
            self
        }
        /// <p>The name of the disk (e.g., <code>my-disk</code>).</p>
        pub fn set_disk_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_disk_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDisks`.
    ///
    /// <p>Returns information about all block storage disks in your AWS account and region.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDisks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_disks_input::Builder,
    }
    impl<C, M, R> GetDisks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDisks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDisksOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDisksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDisksInputOperationOutputAlias,
                crate::output::GetDisksOutput,
                crate::error::GetDisksError,
                crate::input::GetDisksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetDisks</code> request. If your results are
        /// paginated, the response will return a next page token that you can specify as the page token
        /// in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetDisks</code> request. If your results are
        /// paginated, the response will return a next page token that you can specify as the page token
        /// in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDiskSnapshot`.
    ///
    /// <p>Returns information about a specific block storage disk snapshot.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDiskSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_disk_snapshot_input::Builder,
    }
    impl<C, M, R> GetDiskSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDiskSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDiskSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDiskSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDiskSnapshotInputOperationOutputAlias,
                crate::output::GetDiskSnapshotOutput,
                crate::error::GetDiskSnapshotError,
                crate::input::GetDiskSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the disk snapshot (e.g., <code>my-disk-snapshot</code>).</p>
        pub fn disk_snapshot_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.disk_snapshot_name(inp);
            self
        }
        /// <p>The name of the disk snapshot (e.g., <code>my-disk-snapshot</code>).</p>
        pub fn set_disk_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_disk_snapshot_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDiskSnapshots`.
    ///
    /// <p>Returns information about all block storage disk snapshots in your AWS account and
    /// region.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDiskSnapshots<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_disk_snapshots_input::Builder,
    }
    impl<C, M, R> GetDiskSnapshots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDiskSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDiskSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDiskSnapshotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDiskSnapshotsInputOperationOutputAlias,
                crate::output::GetDiskSnapshotsOutput,
                crate::error::GetDiskSnapshotsError,
                crate::input::GetDiskSnapshotsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetDiskSnapshots</code> request. If your
        /// results are paginated, the response will return a next page token that you can specify as the
        /// page token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetDiskSnapshots</code> request. If your
        /// results are paginated, the response will return a next page token that you can specify as the
        /// page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDistributionBundles`.
    ///
    /// <p>Returns the bundles that can be applied to your Amazon Lightsail content delivery network
    /// (CDN) distributions.</p>
    /// <p>A distribution bundle specifies the monthly network transfer quota and monthly cost of
    /// your dsitribution.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDistributionBundles<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_distribution_bundles_input::Builder,
    }
    impl<C, M, R> GetDistributionBundles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDistributionBundles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDistributionBundlesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDistributionBundlesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDistributionBundlesInputOperationOutputAlias,
                crate::output::GetDistributionBundlesOutput,
                crate::error::GetDistributionBundlesError,
                crate::input::GetDistributionBundlesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetDistributionLatestCacheReset`.
    ///
    /// <p>Returns the timestamp and status of the last cache reset of a specific Amazon Lightsail
    /// content delivery network (CDN) distribution.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDistributionLatestCacheReset<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_distribution_latest_cache_reset_input::Builder,
    }
    impl<C, M, R> GetDistributionLatestCacheReset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDistributionLatestCacheReset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDistributionLatestCacheResetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDistributionLatestCacheResetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDistributionLatestCacheResetInputOperationOutputAlias,
                crate::output::GetDistributionLatestCacheResetOutput,
                crate::error::GetDistributionLatestCacheResetError,
                crate::input::GetDistributionLatestCacheResetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the distribution for which to return the timestamp of the last cache
        /// reset.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you
        /// can specify.</p>
        /// <p>When omitted, the response includes the latest cache reset timestamp of all your
        /// distributions.</p>
        pub fn distribution_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_name(inp);
            self
        }
        /// <p>The name of the distribution for which to return the timestamp of the last cache
        /// reset.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you
        /// can specify.</p>
        /// <p>When omitted, the response includes the latest cache reset timestamp of all your
        /// distributions.</p>
        pub fn set_distribution_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDistributionMetricData`.
    ///
    /// <p>Returns the data points of a specific metric for an Amazon Lightsail content delivery
    /// network (CDN) distribution.</p>
    /// <p>Metrics report the utilization of your resources, and the error counts generated by them.
    /// Monitor and collect metric data regularly to maintain the reliability, availability, and
    /// performance of your resources.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDistributionMetricData<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_distribution_metric_data_input::Builder,
    }
    impl<C, M, R> GetDistributionMetricData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDistributionMetricData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDistributionMetricDataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDistributionMetricDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDistributionMetricDataInputOperationOutputAlias,
                crate::output::GetDistributionMetricDataOutput,
                crate::error::GetDistributionMetricDataError,
                crate::input::GetDistributionMetricDataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the distribution for which to get metric data.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you
        /// can specify.</p>
        pub fn distribution_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_name(inp);
            self
        }
        /// <p>The name of the distribution for which to get metric data.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you
        /// can specify.</p>
        pub fn set_distribution_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_name(input);
            self
        }
        /// <p>The metric for which you want to return information.</p>
        /// <p>Valid distribution metric names are listed below, along with the most useful
        /// <code>statistics</code> to include in your request, and the published <code>unit</code>
        /// value.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Requests</code>
        /// </b> - The total number of viewer
        /// requests received by your Lightsail distribution, for all HTTP methods, and for both
        /// HTTP and HTTPS requests.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>None</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>BytesDownloaded</code>
        /// </b> - The number of bytes
        /// downloaded by viewers for GET, HEAD, and OPTIONS requests.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>None</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>BytesUploaded </code>
        /// </b> - The number of bytes
        /// uploaded to your origin by your Lightsail distribution, using POST and PUT
        /// requests.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>None</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>TotalErrorRate</code>
        /// </b> - The percentage of all
        /// viewer requests for which the response's HTTP status code was 4xx or 5xx.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Percent</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>4xxErrorRate</code>
        /// </b> - The percentage of all
        /// viewer requests for which the response's HTTP status cod was 4xx. In these cases, the
        /// client or client viewer may have made an error. For example, a status code of 404 (Not
        /// Found) means that the client requested an object that could not be found.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Percent</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>5xxErrorRate</code>
        /// </b> - The percentage of all
        /// viewer requests for which the response's HTTP status code was 5xx. In these cases, the
        /// origin server did not satisfy the requests. For example, a status code of 503 (Service
        /// Unavailable) means that the origin server is currently unavailable.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Percent</code>.</p>
        /// </li>
        /// </ul>
        pub fn metric_name(mut self, inp: crate::model::DistributionMetricName) -> Self {
            self.inner = self.inner.metric_name(inp);
            self
        }
        /// <p>The metric for which you want to return information.</p>
        /// <p>Valid distribution metric names are listed below, along with the most useful
        /// <code>statistics</code> to include in your request, and the published <code>unit</code>
        /// value.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Requests</code>
        /// </b> - The total number of viewer
        /// requests received by your Lightsail distribution, for all HTTP methods, and for both
        /// HTTP and HTTPS requests.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>None</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>BytesDownloaded</code>
        /// </b> - The number of bytes
        /// downloaded by viewers for GET, HEAD, and OPTIONS requests.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>None</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>BytesUploaded </code>
        /// </b> - The number of bytes
        /// uploaded to your origin by your Lightsail distribution, using POST and PUT
        /// requests.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>None</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>TotalErrorRate</code>
        /// </b> - The percentage of all
        /// viewer requests for which the response's HTTP status code was 4xx or 5xx.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Percent</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>4xxErrorRate</code>
        /// </b> - The percentage of all
        /// viewer requests for which the response's HTTP status cod was 4xx. In these cases, the
        /// client or client viewer may have made an error. For example, a status code of 404 (Not
        /// Found) means that the client requested an object that could not be found.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Percent</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>5xxErrorRate</code>
        /// </b> - The percentage of all
        /// viewer requests for which the response's HTTP status code was 5xx. In these cases, the
        /// origin server did not satisfy the requests. For example, a status code of 503 (Service
        /// Unavailable) means that the origin server is currently unavailable.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Percent</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_metric_name(
            mut self,
            input: std::option::Option<crate::model::DistributionMetricName>,
        ) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
        /// <p>The start of the time interval for which to get metric data.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Specified in the Unix time format.</p>
        /// <p>For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, specify
        /// <code>1538424000</code> as the start time.</p>
        /// </li>
        /// </ul>
        /// <p>You can convert a human-friendly time to Unix time format using a converter like <a href="https://www.epochconverter.com/">Epoch converter</a>.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The start of the time interval for which to get metric data.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Specified in the Unix time format.</p>
        /// <p>For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, specify
        /// <code>1538424000</code> as the start time.</p>
        /// </li>
        /// </ul>
        /// <p>You can convert a human-friendly time to Unix time format using a converter like <a href="https://www.epochconverter.com/">Epoch converter</a>.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time interval for which to get metric data.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Specified in the Unix time format.</p>
        /// <p>For example, if you wish to use an end time of October 1, 2018, at 9 PM UTC, specify
        /// <code>1538427600</code> as the end time.</p>
        /// </li>
        /// </ul>
        /// <p>You can convert a human-friendly time to Unix time format using a converter like <a href="https://www.epochconverter.com/">Epoch converter</a>.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The end of the time interval for which to get metric data.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Specified in the Unix time format.</p>
        /// <p>For example, if you wish to use an end time of October 1, 2018, at 9 PM UTC, specify
        /// <code>1538427600</code> as the end time.</p>
        /// </li>
        /// </ul>
        /// <p>You can convert a human-friendly time to Unix time format using a converter like <a href="https://www.epochconverter.com/">Epoch converter</a>.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The granularity, in seconds, for the metric data points that will be returned.</p>
        pub fn period(mut self, inp: i32) -> Self {
            self.inner = self.inner.period(inp);
            self
        }
        /// <p>The granularity, in seconds, for the metric data points that will be returned.</p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_period(input);
            self
        }
        /// <p>The unit for the metric data request.</p>
        /// <p>Valid units depend on the metric data being requested. For the valid units with each
        /// available metric, see the <code>metricName</code> parameter.</p>
        pub fn unit(mut self, inp: crate::model::MetricUnit) -> Self {
            self.inner = self.inner.unit(inp);
            self
        }
        /// <p>The unit for the metric data request.</p>
        /// <p>Valid units depend on the metric data being requested. For the valid units with each
        /// available metric, see the <code>metricName</code> parameter.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::MetricUnit>) -> Self {
            self.inner = self.inner.set_unit(input);
            self
        }
        /// Appends an item to `statistics`.
        ///
        /// To override the contents of this collection use [`set_statistics`](Self::set_statistics).
        ///
        /// <p>The statistic for the metric.</p>
        /// <p>The following statistics are available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Minimum</code> - The lowest value observed during the specified period. Use this
        /// value to determine low volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Maximum</code> - The highest value observed during the specified period. Use
        /// this value to determine high volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Sum</code> - All values submitted for the matching metric added together. You
        /// can use this statistic to determine the total volume of a metric.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Average</code> - The value of Sum / SampleCount during the specified period. By
        /// comparing this statistic with the Minimum and Maximum values, you can determine the full
        /// scope of a metric and how close the average use is to the Minimum and Maximum values. This
        /// comparison helps you to know when to increase or decrease your resources.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SampleCount</code> - The count, or number, of data points used for the
        /// statistical calculation.</p>
        /// </li>
        /// </ul>
        pub fn statistics(mut self, inp: impl Into<crate::model::MetricStatistic>) -> Self {
            self.inner = self.inner.statistics(inp);
            self
        }
        /// <p>The statistic for the metric.</p>
        /// <p>The following statistics are available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Minimum</code> - The lowest value observed during the specified period. Use this
        /// value to determine low volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Maximum</code> - The highest value observed during the specified period. Use
        /// this value to determine high volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Sum</code> - All values submitted for the matching metric added together. You
        /// can use this statistic to determine the total volume of a metric.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Average</code> - The value of Sum / SampleCount during the specified period. By
        /// comparing this statistic with the Minimum and Maximum values, you can determine the full
        /// scope of a metric and how close the average use is to the Minimum and Maximum values. This
        /// comparison helps you to know when to increase or decrease your resources.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SampleCount</code> - The count, or number, of data points used for the
        /// statistical calculation.</p>
        /// </li>
        /// </ul>
        pub fn set_statistics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricStatistic>>,
        ) -> Self {
            self.inner = self.inner.set_statistics(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDistributions`.
    ///
    /// <p>Returns information about one or more of your Amazon Lightsail content delivery network
    /// (CDN) distributions.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDistributions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_distributions_input::Builder,
    }
    impl<C, M, R> GetDistributions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDistributions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDistributionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDistributionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDistributionsInputOperationOutputAlias,
                crate::output::GetDistributionsOutput,
                crate::error::GetDistributionsError,
                crate::input::GetDistributionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the distribution for which to return information.</p>
        ///
        /// <p>When omitted, the response includes all of your distributions in the AWS Region where
        /// the request is made.</p>
        pub fn distribution_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_name(inp);
            self
        }
        /// <p>The name of the distribution for which to return information.</p>
        ///
        /// <p>When omitted, the response includes all of your distributions in the AWS Region where
        /// the request is made.</p>
        pub fn set_distribution_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_name(input);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetDistributions</code> request. If your
        /// results are paginated, the response will return a next page token that you can specify as the
        /// page token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetDistributions</code> request. If your
        /// results are paginated, the response will return a next page token that you can specify as the
        /// page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomain`.
    ///
    /// <p>Returns information about a specific domain recordset.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_domain_input::Builder,
    }
    impl<C, M, R> GetDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDomainInputOperationOutputAlias,
                crate::output::GetDomainOutput,
                crate::error::GetDomainError,
                crate::input::GetDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The domain name for which your want to return information about.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The domain name for which your want to return information about.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomains`.
    ///
    /// <p>Returns a list of all domains in the user's account.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDomains<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_domains_input::Builder,
    }
    impl<C, M, R> GetDomains<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDomainsInputOperationOutputAlias,
                crate::output::GetDomainsOutput,
                crate::error::GetDomainsError,
                crate::input::GetDomainsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetDomains</code> request. If your results
        /// are paginated, the response will return a next page token that you can specify as the page
        /// token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetDomains</code> request. If your results
        /// are paginated, the response will return a next page token that you can specify as the page
        /// token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetExportSnapshotRecords`.
    ///
    /// <p>Returns all export snapshot records created as a result of the <code>export
    /// snapshot</code> operation.</p>
    /// <p>An export snapshot record can be used to create a new Amazon EC2 instance and its related
    /// resources with the <a>CreateCloudFormationStack</a> action.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetExportSnapshotRecords<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_export_snapshot_records_input::Builder,
    }
    impl<C, M, R> GetExportSnapshotRecords<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetExportSnapshotRecords`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetExportSnapshotRecordsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetExportSnapshotRecordsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetExportSnapshotRecordsInputOperationOutputAlias,
                crate::output::GetExportSnapshotRecordsOutput,
                crate::error::GetExportSnapshotRecordsError,
                crate::input::GetExportSnapshotRecordsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetExportSnapshotRecords</code> request. If
        /// your results are paginated, the response will return a next page token that you can specify as
        /// the page token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetExportSnapshotRecords</code> request. If
        /// your results are paginated, the response will return a next page token that you can specify as
        /// the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInstance`.
    ///
    /// <p>Returns information about a specific Amazon Lightsail instance, which is a virtual private
    /// server.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_instance_input::Builder,
    }
    impl<C, M, R> GetInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInstanceInputOperationOutputAlias,
                crate::output::GetInstanceOutput,
                crate::error::GetInstanceError,
                crate::input::GetInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the instance.</p>
        pub fn instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_name(inp);
            self
        }
        /// <p>The name of the instance.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInstanceAccessDetails`.
    ///
    /// <p>Returns temporary SSH keys you can use to connect to a specific virtual private server, or
    /// <i>instance</i>.</p>
    /// <p>The <code>get instance access details</code> operation supports tag-based access control
    /// via resource tags applied to the resource identified by <code>instance name</code>. For more
    /// information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInstanceAccessDetails<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_instance_access_details_input::Builder,
    }
    impl<C, M, R> GetInstanceAccessDetails<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInstanceAccessDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInstanceAccessDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInstanceAccessDetailsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInstanceAccessDetailsInputOperationOutputAlias,
                crate::output::GetInstanceAccessDetailsOutput,
                crate::error::GetInstanceAccessDetailsError,
                crate::input::GetInstanceAccessDetailsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the instance to access.</p>
        pub fn instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_name(inp);
            self
        }
        /// <p>The name of the instance to access.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_name(input);
            self
        }
        /// <p>The protocol to use to connect to your instance. Defaults to <code>ssh</code>.</p>
        pub fn protocol(mut self, inp: crate::model::InstanceAccessProtocol) -> Self {
            self.inner = self.inner.protocol(inp);
            self
        }
        /// <p>The protocol to use to connect to your instance. Defaults to <code>ssh</code>.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::InstanceAccessProtocol>,
        ) -> Self {
            self.inner = self.inner.set_protocol(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInstanceMetricData`.
    ///
    /// <p>Returns the data points for the specified Amazon Lightsail instance metric, given an
    /// instance name.</p>
    /// <p>Metrics report the utilization of your resources, and the error counts generated by them.
    /// Monitor and collect metric data regularly to maintain the reliability, availability, and
    /// performance of your resources.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInstanceMetricData<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_instance_metric_data_input::Builder,
    }
    impl<C, M, R> GetInstanceMetricData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInstanceMetricData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInstanceMetricDataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInstanceMetricDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInstanceMetricDataInputOperationOutputAlias,
                crate::output::GetInstanceMetricDataOutput,
                crate::error::GetInstanceMetricDataError,
                crate::input::GetInstanceMetricDataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the instance for which you want to get metrics data.</p>
        pub fn instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_name(inp);
            self
        }
        /// <p>The name of the instance for which you want to get metrics data.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_name(input);
            self
        }
        /// <p>The metric for which you want to return information.</p>
        /// <p>Valid instance metric names are listed below, along with the most useful
        /// <code>statistics</code> to include in your request, and the published <code>unit</code>
        /// value.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>BurstCapacityPercentage</code>
        /// </b> - The percentage
        /// of CPU performance available for your instance to burst above its baseline. Your instance
        /// continuously accrues and consumes burst capacity. Burst capacity stops accruing when your
        /// instance's <code>BurstCapacityPercentage</code> reaches 100%. For more information, see
        /// <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-viewing-instance-burst-capacity">Viewing instance burst capacity in Amazon Lightsail</a>.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and
        /// <code>Average</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Percent</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>BurstCapacityTime</code>
        /// </b> - The available amount
        /// of time for your instance to burst at 100% CPU utilization. Your instance continuously
        /// accrues and consumes burst capacity. Burst capacity time stops accruing when your
        /// instance's <code>BurstCapacityPercentage</code> metric reaches 100%.</p>
        /// <p>Burst capacity time is consumed at the full rate only when your instance operates at
        /// 100% CPU utilization. For example, if your instance operates at 50% CPU utilization in the
        /// burstable zone for a 5-minute period, then it consumes CPU burst capacity minutes at a 50%
        /// rate in that period. Your instance consumed 2 minutes and 30 seconds of CPU burst capacity
        /// minutes in the 5-minute period. For more information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-viewing-instance-burst-capacity">Viewing instance burst capacity in Amazon Lightsail</a>.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and
        /// <code>Average</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Seconds</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>CPUUtilization</code>
        /// </b> - The percentage of
        /// allocated compute units that are currently in use on the instance. This metric identifies
        /// the processing power to run the applications on the instance. Tools in your operating
        /// system can show a lower percentage than Lightsail when the instance is not allocated a
        /// full processor core.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and
        /// <code>Average</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Percent</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkIn</code>
        /// </b> - The number of bytes received
        /// on all network interfaces by the instance. This metric identifies the volume of incoming
        /// network traffic to the instance. The number reported is the number of bytes received
        /// during the period. Because this metric is reported in 5-minute intervals, divide the
        /// reported number by 300 to find Bytes/second.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Bytes</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkOut</code>
        /// </b> - The number of bytes sent
        /// out on all network interfaces by the instance. This metric identifies the volume of
        /// outgoing network traffic from the instance. The number reported is the number of bytes
        /// sent during the period. Because this metric is reported in 5-minute intervals, divide the
        /// reported number by 300 to find Bytes/second.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Bytes</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>StatusCheckFailed</code>
        /// </b> - Reports whether the
        /// instance passed or failed both the instance status check and the system status check. This
        /// metric can be either 0 (passed) or 1 (failed). This metric data is available in 1-minute
        /// (60 seconds) granularity.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>StatusCheckFailed_Instance</code>
        /// </b> - Reports
        /// whether the instance passed or failed the instance status check. This metric can be either
        /// 0 (passed) or 1 (failed). This metric data is available in 1-minute (60 seconds)
        /// granularity.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>StatusCheckFailed_System</code>
        /// </b> - Reports
        /// whether the instance passed or failed the system status check. This metric can be either 0
        /// (passed) or 1 (failed). This metric data is available in 1-minute (60 seconds)
        /// granularity.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// </ul>
        pub fn metric_name(mut self, inp: crate::model::InstanceMetricName) -> Self {
            self.inner = self.inner.metric_name(inp);
            self
        }
        /// <p>The metric for which you want to return information.</p>
        /// <p>Valid instance metric names are listed below, along with the most useful
        /// <code>statistics</code> to include in your request, and the published <code>unit</code>
        /// value.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>BurstCapacityPercentage</code>
        /// </b> - The percentage
        /// of CPU performance available for your instance to burst above its baseline. Your instance
        /// continuously accrues and consumes burst capacity. Burst capacity stops accruing when your
        /// instance's <code>BurstCapacityPercentage</code> reaches 100%. For more information, see
        /// <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-viewing-instance-burst-capacity">Viewing instance burst capacity in Amazon Lightsail</a>.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and
        /// <code>Average</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Percent</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>BurstCapacityTime</code>
        /// </b> - The available amount
        /// of time for your instance to burst at 100% CPU utilization. Your instance continuously
        /// accrues and consumes burst capacity. Burst capacity time stops accruing when your
        /// instance's <code>BurstCapacityPercentage</code> metric reaches 100%.</p>
        /// <p>Burst capacity time is consumed at the full rate only when your instance operates at
        /// 100% CPU utilization. For example, if your instance operates at 50% CPU utilization in the
        /// burstable zone for a 5-minute period, then it consumes CPU burst capacity minutes at a 50%
        /// rate in that period. Your instance consumed 2 minutes and 30 seconds of CPU burst capacity
        /// minutes in the 5-minute period. For more information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-viewing-instance-burst-capacity">Viewing instance burst capacity in Amazon Lightsail</a>.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and
        /// <code>Average</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Seconds</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>CPUUtilization</code>
        /// </b> - The percentage of
        /// allocated compute units that are currently in use on the instance. This metric identifies
        /// the processing power to run the applications on the instance. Tools in your operating
        /// system can show a lower percentage than Lightsail when the instance is not allocated a
        /// full processor core.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and
        /// <code>Average</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Percent</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkIn</code>
        /// </b> - The number of bytes received
        /// on all network interfaces by the instance. This metric identifies the volume of incoming
        /// network traffic to the instance. The number reported is the number of bytes received
        /// during the period. Because this metric is reported in 5-minute intervals, divide the
        /// reported number by 300 to find Bytes/second.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Bytes</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkOut</code>
        /// </b> - The number of bytes sent
        /// out on all network interfaces by the instance. This metric identifies the volume of
        /// outgoing network traffic from the instance. The number reported is the number of bytes
        /// sent during the period. Because this metric is reported in 5-minute intervals, divide the
        /// reported number by 300 to find Bytes/second.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Bytes</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>StatusCheckFailed</code>
        /// </b> - Reports whether the
        /// instance passed or failed both the instance status check and the system status check. This
        /// metric can be either 0 (passed) or 1 (failed). This metric data is available in 1-minute
        /// (60 seconds) granularity.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>StatusCheckFailed_Instance</code>
        /// </b> - Reports
        /// whether the instance passed or failed the instance status check. This metric can be either
        /// 0 (passed) or 1 (failed). This metric data is available in 1-minute (60 seconds)
        /// granularity.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>StatusCheckFailed_System</code>
        /// </b> - Reports
        /// whether the instance passed or failed the system status check. This metric can be either 0
        /// (passed) or 1 (failed). This metric data is available in 1-minute (60 seconds)
        /// granularity.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_metric_name(
            mut self,
            input: std::option::Option<crate::model::InstanceMetricName>,
        ) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
        /// <p>The granularity, in seconds, of the returned data points.</p>
        /// <p>The <code>StatusCheckFailed</code>, <code>StatusCheckFailed_Instance</code>, and
        /// <code>StatusCheckFailed_System</code> instance metric data is available in 1-minute (60
        /// seconds) granularity. All other instance metric data is available in 5-minute (300 seconds)
        /// granularity.</p>
        pub fn period(mut self, inp: i32) -> Self {
            self.inner = self.inner.period(inp);
            self
        }
        /// <p>The granularity, in seconds, of the returned data points.</p>
        /// <p>The <code>StatusCheckFailed</code>, <code>StatusCheckFailed_Instance</code>, and
        /// <code>StatusCheckFailed_System</code> instance metric data is available in 1-minute (60
        /// seconds) granularity. All other instance metric data is available in 5-minute (300 seconds)
        /// granularity.</p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_period(input);
            self
        }
        /// <p>The start time of the time period.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The start time of the time period.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end time of the time period.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The end time of the time period.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The unit for the metric data request. Valid units depend on the metric data being
        /// requested. For the valid units to specify with each available metric, see the
        /// <code>metricName</code> parameter.</p>
        pub fn unit(mut self, inp: crate::model::MetricUnit) -> Self {
            self.inner = self.inner.unit(inp);
            self
        }
        /// <p>The unit for the metric data request. Valid units depend on the metric data being
        /// requested. For the valid units to specify with each available metric, see the
        /// <code>metricName</code> parameter.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::MetricUnit>) -> Self {
            self.inner = self.inner.set_unit(input);
            self
        }
        /// Appends an item to `statistics`.
        ///
        /// To override the contents of this collection use [`set_statistics`](Self::set_statistics).
        ///
        /// <p>The statistic for the metric.</p>
        /// <p>The following statistics are available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Minimum</code> - The lowest value observed during the specified period. Use this
        /// value to determine low volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Maximum</code> - The highest value observed during the specified period. Use
        /// this value to determine high volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Sum</code> - All values submitted for the matching metric added together. You
        /// can use this statistic to determine the total volume of a metric.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Average</code> - The value of Sum / SampleCount during the specified period. By
        /// comparing this statistic with the Minimum and Maximum values, you can determine the full
        /// scope of a metric and how close the average use is to the Minimum and Maximum values. This
        /// comparison helps you to know when to increase or decrease your resources.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SampleCount</code> - The count, or number, of data points used for the
        /// statistical calculation.</p>
        /// </li>
        /// </ul>
        pub fn statistics(mut self, inp: impl Into<crate::model::MetricStatistic>) -> Self {
            self.inner = self.inner.statistics(inp);
            self
        }
        /// <p>The statistic for the metric.</p>
        /// <p>The following statistics are available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Minimum</code> - The lowest value observed during the specified period. Use this
        /// value to determine low volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Maximum</code> - The highest value observed during the specified period. Use
        /// this value to determine high volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Sum</code> - All values submitted for the matching metric added together. You
        /// can use this statistic to determine the total volume of a metric.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Average</code> - The value of Sum / SampleCount during the specified period. By
        /// comparing this statistic with the Minimum and Maximum values, you can determine the full
        /// scope of a metric and how close the average use is to the Minimum and Maximum values. This
        /// comparison helps you to know when to increase or decrease your resources.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SampleCount</code> - The count, or number, of data points used for the
        /// statistical calculation.</p>
        /// </li>
        /// </ul>
        pub fn set_statistics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricStatistic>>,
        ) -> Self {
            self.inner = self.inner.set_statistics(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInstancePortStates`.
    ///
    /// <p>Returns the firewall port states for a specific Amazon Lightsail instance, the IP addresses
    /// allowed to connect to the instance through the ports, and the protocol.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInstancePortStates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_instance_port_states_input::Builder,
    }
    impl<C, M, R> GetInstancePortStates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInstancePortStates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInstancePortStatesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInstancePortStatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInstancePortStatesInputOperationOutputAlias,
                crate::output::GetInstancePortStatesOutput,
                crate::error::GetInstancePortStatesError,
                crate::input::GetInstancePortStatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the instance for which to return firewall port states.</p>
        pub fn instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_name(inp);
            self
        }
        /// <p>The name of the instance for which to return firewall port states.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInstances`.
    ///
    /// <p>Returns information about all Amazon Lightsail virtual private servers, or
    /// <i>instances</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_instances_input::Builder,
    }
    impl<C, M, R> GetInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInstancesInputOperationOutputAlias,
                crate::output::GetInstancesOutput,
                crate::error::GetInstancesError,
                crate::input::GetInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetInstances</code> request. If your results
        /// are paginated, the response will return a next page token that you can specify as the page
        /// token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetInstances</code> request. If your results
        /// are paginated, the response will return a next page token that you can specify as the page
        /// token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInstanceSnapshot`.
    ///
    /// <p>Returns information about a specific instance snapshot.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInstanceSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_instance_snapshot_input::Builder,
    }
    impl<C, M, R> GetInstanceSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInstanceSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInstanceSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInstanceSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInstanceSnapshotInputOperationOutputAlias,
                crate::output::GetInstanceSnapshotOutput,
                crate::error::GetInstanceSnapshotError,
                crate::input::GetInstanceSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the snapshot for which you are requesting information.</p>
        pub fn instance_snapshot_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_snapshot_name(inp);
            self
        }
        /// <p>The name of the snapshot for which you are requesting information.</p>
        pub fn set_instance_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_snapshot_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInstanceSnapshots`.
    ///
    /// <p>Returns all instance snapshots for the user's account.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInstanceSnapshots<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_instance_snapshots_input::Builder,
    }
    impl<C, M, R> GetInstanceSnapshots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInstanceSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInstanceSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInstanceSnapshotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInstanceSnapshotsInputOperationOutputAlias,
                crate::output::GetInstanceSnapshotsOutput,
                crate::error::GetInstanceSnapshotsError,
                crate::input::GetInstanceSnapshotsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetInstanceSnapshots</code> request. If your
        /// results are paginated, the response will return a next page token that you can specify as the
        /// page token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetInstanceSnapshots</code> request. If your
        /// results are paginated, the response will return a next page token that you can specify as the
        /// page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInstanceState`.
    ///
    /// <p>Returns the state of a specific instance. Works on one instance at a time.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInstanceState<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_instance_state_input::Builder,
    }
    impl<C, M, R> GetInstanceState<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInstanceState`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInstanceStateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInstanceStateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInstanceStateInputOperationOutputAlias,
                crate::output::GetInstanceStateOutput,
                crate::error::GetInstanceStateError,
                crate::input::GetInstanceStateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the instance to get state information about.</p>
        pub fn instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_name(inp);
            self
        }
        /// <p>The name of the instance to get state information about.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetKeyPair`.
    ///
    /// <p>Returns information about a specific key pair.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetKeyPair<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_key_pair_input::Builder,
    }
    impl<C, M, R> GetKeyPair<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetKeyPair`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetKeyPairOutput,
            aws_smithy_http::result::SdkError<crate::error::GetKeyPairError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetKeyPairInputOperationOutputAlias,
                crate::output::GetKeyPairOutput,
                crate::error::GetKeyPairError,
                crate::input::GetKeyPairInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the key pair for which you are requesting information.</p>
        pub fn key_pair_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_pair_name(inp);
            self
        }
        /// <p>The name of the key pair for which you are requesting information.</p>
        pub fn set_key_pair_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_key_pair_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetKeyPairs`.
    ///
    /// <p>Returns information about all key pairs in the user's account.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetKeyPairs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_key_pairs_input::Builder,
    }
    impl<C, M, R> GetKeyPairs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetKeyPairs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetKeyPairsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetKeyPairsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetKeyPairsInputOperationOutputAlias,
                crate::output::GetKeyPairsOutput,
                crate::error::GetKeyPairsError,
                crate::input::GetKeyPairsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetKeyPairs</code> request. If your results
        /// are paginated, the response will return a next page token that you can specify as the page
        /// token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetKeyPairs</code> request. If your results
        /// are paginated, the response will return a next page token that you can specify as the page
        /// token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLoadBalancer`.
    ///
    /// <p>Returns information about the specified Lightsail load balancer.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLoadBalancer<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_load_balancer_input::Builder,
    }
    impl<C, M, R> GetLoadBalancer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLoadBalancer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLoadBalancerOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLoadBalancerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLoadBalancerInputOperationOutputAlias,
                crate::output::GetLoadBalancerOutput,
                crate::error::GetLoadBalancerError,
                crate::input::GetLoadBalancerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(inp);
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLoadBalancerMetricData`.
    ///
    /// <p>Returns information about health metrics for your Lightsail load balancer.</p>
    /// <p>Metrics report the utilization of your resources, and the error counts generated by them.
    /// Monitor and collect metric data regularly to maintain the reliability, availability, and
    /// performance of your resources.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLoadBalancerMetricData<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_load_balancer_metric_data_input::Builder,
    }
    impl<C, M, R> GetLoadBalancerMetricData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLoadBalancerMetricData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLoadBalancerMetricDataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLoadBalancerMetricDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLoadBalancerMetricDataInputOperationOutputAlias,
                crate::output::GetLoadBalancerMetricDataOutput,
                crate::error::GetLoadBalancerMetricDataError,
                crate::input::GetLoadBalancerMetricDataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(inp);
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// <p>The metric for which you want to return information.</p>
        /// <p>Valid load balancer metric names are listed below, along with the most useful
        /// <code>statistics</code> to include in your request, and the published <code>unit</code>
        /// value.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ClientTLSNegotiationErrorCount</code>
        /// </b> - The
        /// number of TLS connections initiated by the client that did not establish a session with
        /// the load balancer due to a TLS error generated by the load balancer. Possible causes
        /// include a mismatch of ciphers or protocols.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>HealthyHostCount</code>
        /// </b> - The number of target
        /// instances that are considered healthy.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic are <code>Average</code>,
        /// <code>Minimum</code>, and <code>Maximum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>HTTPCode_Instance_2XX_Count</code>
        /// </b> - The number
        /// of HTTP 2XX response codes generated by the target instances. This does not include any
        /// response codes generated by the load balancer.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that
        /// <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return
        /// <code>1</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>HTTPCode_Instance_3XX_Count</code>
        /// </b> - The number
        /// of HTTP 3XX response codes generated by the target instances. This does not include any
        /// response codes generated by the load balancer.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that
        /// <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return
        /// <code>1</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>HTTPCode_Instance_4XX_Count</code>
        /// </b> - The number
        /// of HTTP 4XX response codes generated by the target instances. This does not include any
        /// response codes generated by the load balancer.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that
        /// <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return
        /// <code>1</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>HTTPCode_Instance_5XX_Count</code>
        /// </b> - The number
        /// of HTTP 5XX response codes generated by the target instances. This does not include any
        /// response codes generated by the load balancer.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that
        /// <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return
        /// <code>1</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>HTTPCode_LB_4XX_Count</code>
        /// </b> - The number of
        /// HTTP 4XX client error codes that originated from the load balancer. Client errors are
        /// generated when requests are malformed or incomplete. These requests were not received by
        /// the target instance. This count does not include response codes generated by the target
        /// instances.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that
        /// <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return
        /// <code>1</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>HTTPCode_LB_5XX_Count</code>
        /// </b> - The number of
        /// HTTP 5XX server error codes that originated from the load balancer. This does not include
        /// any response codes generated by the target instance. This metric is reported if there are
        /// no healthy instances attached to the load balancer, or if the request rate exceeds the
        /// capacity of the instances (spillover) or the load balancer.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that
        /// <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return
        /// <code>1</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>InstanceResponseTime</code>
        /// </b> - The time elapsed,
        /// in seconds, after the request leaves the load balancer until a response from the target
        /// instance is received.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Seconds</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>RejectedConnectionCount</code>
        /// </b> - The number of
        /// connections that were rejected because the load balancer had reached its maximum number of
        /// connections.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>RequestCount</code>
        /// </b> - The number of requests
        /// processed over IPv4. This count includes only the requests with a response generated by a
        /// target instance of the load balancer.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that
        /// <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return
        /// <code>1</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>UnhealthyHostCount</code>
        /// </b> - The number of
        /// target instances that are considered unhealthy.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic are <code>Average</code>,
        /// <code>Minimum</code>, and <code>Maximum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// </ul>
        pub fn metric_name(mut self, inp: crate::model::LoadBalancerMetricName) -> Self {
            self.inner = self.inner.metric_name(inp);
            self
        }
        /// <p>The metric for which you want to return information.</p>
        /// <p>Valid load balancer metric names are listed below, along with the most useful
        /// <code>statistics</code> to include in your request, and the published <code>unit</code>
        /// value.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ClientTLSNegotiationErrorCount</code>
        /// </b> - The
        /// number of TLS connections initiated by the client that did not establish a session with
        /// the load balancer due to a TLS error generated by the load balancer. Possible causes
        /// include a mismatch of ciphers or protocols.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>HealthyHostCount</code>
        /// </b> - The number of target
        /// instances that are considered healthy.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic are <code>Average</code>,
        /// <code>Minimum</code>, and <code>Maximum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>HTTPCode_Instance_2XX_Count</code>
        /// </b> - The number
        /// of HTTP 2XX response codes generated by the target instances. This does not include any
        /// response codes generated by the load balancer.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that
        /// <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return
        /// <code>1</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>HTTPCode_Instance_3XX_Count</code>
        /// </b> - The number
        /// of HTTP 3XX response codes generated by the target instances. This does not include any
        /// response codes generated by the load balancer.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that
        /// <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return
        /// <code>1</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>HTTPCode_Instance_4XX_Count</code>
        /// </b> - The number
        /// of HTTP 4XX response codes generated by the target instances. This does not include any
        /// response codes generated by the load balancer.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that
        /// <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return
        /// <code>1</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>HTTPCode_Instance_5XX_Count</code>
        /// </b> - The number
        /// of HTTP 5XX response codes generated by the target instances. This does not include any
        /// response codes generated by the load balancer.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that
        /// <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return
        /// <code>1</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>HTTPCode_LB_4XX_Count</code>
        /// </b> - The number of
        /// HTTP 4XX client error codes that originated from the load balancer. Client errors are
        /// generated when requests are malformed or incomplete. These requests were not received by
        /// the target instance. This count does not include response codes generated by the target
        /// instances.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that
        /// <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return
        /// <code>1</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>HTTPCode_LB_5XX_Count</code>
        /// </b> - The number of
        /// HTTP 5XX server error codes that originated from the load balancer. This does not include
        /// any response codes generated by the target instance. This metric is reported if there are
        /// no healthy instances attached to the load balancer, or if the request rate exceeds the
        /// capacity of the instances (spillover) or the load balancer.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that
        /// <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return
        /// <code>1</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>InstanceResponseTime</code>
        /// </b> - The time elapsed,
        /// in seconds, after the request leaves the load balancer until a response from the target
        /// instance is received.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Seconds</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>RejectedConnectionCount</code>
        /// </b> - The number of
        /// connections that were rejected because the load balancer had reached its maximum number of
        /// connections.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>RequestCount</code>
        /// </b> - The number of requests
        /// processed over IPv4. This count includes only the requests with a response generated by a
        /// target instance of the load balancer.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that
        /// <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return
        /// <code>1</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>UnhealthyHostCount</code>
        /// </b> - The number of
        /// target instances that are considered unhealthy.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic are <code>Average</code>,
        /// <code>Minimum</code>, and <code>Maximum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_metric_name(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerMetricName>,
        ) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
        /// <p>The granularity, in seconds, of the returned data points.</p>
        pub fn period(mut self, inp: i32) -> Self {
            self.inner = self.inner.period(inp);
            self
        }
        /// <p>The granularity, in seconds, of the returned data points.</p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_period(input);
            self
        }
        /// <p>The start time of the period.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The start time of the period.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end time of the period.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The end time of the period.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The unit for the metric data request. Valid units depend on the metric data being
        /// requested. For the valid units with each available metric, see the <code>metricName</code>
        /// parameter.</p>
        pub fn unit(mut self, inp: crate::model::MetricUnit) -> Self {
            self.inner = self.inner.unit(inp);
            self
        }
        /// <p>The unit for the metric data request. Valid units depend on the metric data being
        /// requested. For the valid units with each available metric, see the <code>metricName</code>
        /// parameter.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::MetricUnit>) -> Self {
            self.inner = self.inner.set_unit(input);
            self
        }
        /// Appends an item to `statistics`.
        ///
        /// To override the contents of this collection use [`set_statistics`](Self::set_statistics).
        ///
        /// <p>The statistic for the metric.</p>
        /// <p>The following statistics are available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Minimum</code> - The lowest value observed during the specified period. Use this
        /// value to determine low volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Maximum</code> - The highest value observed during the specified period. Use
        /// this value to determine high volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Sum</code> - All values submitted for the matching metric added together. You
        /// can use this statistic to determine the total volume of a metric.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Average</code> - The value of Sum / SampleCount during the specified period. By
        /// comparing this statistic with the Minimum and Maximum values, you can determine the full
        /// scope of a metric and how close the average use is to the Minimum and Maximum values. This
        /// comparison helps you to know when to increase or decrease your resources.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SampleCount</code> - The count, or number, of data points used for the
        /// statistical calculation.</p>
        /// </li>
        /// </ul>
        pub fn statistics(mut self, inp: impl Into<crate::model::MetricStatistic>) -> Self {
            self.inner = self.inner.statistics(inp);
            self
        }
        /// <p>The statistic for the metric.</p>
        /// <p>The following statistics are available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Minimum</code> - The lowest value observed during the specified period. Use this
        /// value to determine low volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Maximum</code> - The highest value observed during the specified period. Use
        /// this value to determine high volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Sum</code> - All values submitted for the matching metric added together. You
        /// can use this statistic to determine the total volume of a metric.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Average</code> - The value of Sum / SampleCount during the specified period. By
        /// comparing this statistic with the Minimum and Maximum values, you can determine the full
        /// scope of a metric and how close the average use is to the Minimum and Maximum values. This
        /// comparison helps you to know when to increase or decrease your resources.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SampleCount</code> - The count, or number, of data points used for the
        /// statistical calculation.</p>
        /// </li>
        /// </ul>
        pub fn set_statistics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricStatistic>>,
        ) -> Self {
            self.inner = self.inner.set_statistics(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLoadBalancers`.
    ///
    /// <p>Returns information about all load balancers in an account.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLoadBalancers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_load_balancers_input::Builder,
    }
    impl<C, M, R> GetLoadBalancers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLoadBalancers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLoadBalancersOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLoadBalancersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLoadBalancersInputOperationOutputAlias,
                crate::output::GetLoadBalancersOutput,
                crate::error::GetLoadBalancersError,
                crate::input::GetLoadBalancersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetLoadBalancers</code> request. If your
        /// results are paginated, the response will return a next page token that you can specify as the
        /// page token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetLoadBalancers</code> request. If your
        /// results are paginated, the response will return a next page token that you can specify as the
        /// page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLoadBalancerTlsCertificates`.
    ///
    /// <p>Returns information about the TLS certificates that are associated with the specified
    /// Lightsail load balancer.</p>
    /// <p>TLS is just an updated, more secure version of Secure Socket Layer (SSL).</p>
    /// <p>You can have a maximum of 2 certificates associated with a Lightsail load balancer. One
    /// is active and the other is inactive.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLoadBalancerTlsCertificates<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_load_balancer_tls_certificates_input::Builder,
    }
    impl<C, M, R> GetLoadBalancerTlsCertificates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLoadBalancerTlsCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLoadBalancerTlsCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLoadBalancerTlsCertificatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLoadBalancerTlsCertificatesInputOperationOutputAlias,
                crate::output::GetLoadBalancerTlsCertificatesOutput,
                crate::error::GetLoadBalancerTlsCertificatesError,
                crate::input::GetLoadBalancerTlsCertificatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer you associated with your SSL/TLS certificate.</p>
        pub fn load_balancer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(inp);
            self
        }
        /// <p>The name of the load balancer you associated with your SSL/TLS certificate.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOperation`.
    ///
    /// <p>Returns information about a specific operation. Operations include events such as when you
    /// create an instance, allocate a static IP, attach a static IP, and so on.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetOperation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_operation_input::Builder,
    }
    impl<C, M, R> GetOperation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetOperation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOperationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOperationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetOperationInputOperationOutputAlias,
                crate::output::GetOperationOutput,
                crate::error::GetOperationError,
                crate::input::GetOperationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A GUID used to identify the operation.</p>
        pub fn operation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.operation_id(inp);
            self
        }
        /// <p>A GUID used to identify the operation.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_operation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOperations`.
    ///
    /// <p>Returns information about all operations.</p>
    /// <p>Results are returned from oldest to newest, up to a maximum of 200. Results can be paged
    /// by making each subsequent call to <code>GetOperations</code> use the maximum (last)
    /// <code>statusChangedAt</code> value from the previous request.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetOperations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_operations_input::Builder,
    }
    impl<C, M, R> GetOperations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetOperations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOperationsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOperationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetOperationsInputOperationOutputAlias,
                crate::output::GetOperationsOutput,
                crate::error::GetOperationsError,
                crate::input::GetOperationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetOperations</code> request. If your
        /// results are paginated, the response will return a next page token that you can specify as the
        /// page token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetOperations</code> request. If your
        /// results are paginated, the response will return a next page token that you can specify as the
        /// page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetOperationsForResource`.
    ///
    /// <p>Gets operations for a specific resource (e.g., an instance or a static IP).</p>
    #[derive(std::fmt::Debug)]
    pub struct GetOperationsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_operations_for_resource_input::Builder,
    }
    impl<C, M, R> GetOperationsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetOperationsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetOperationsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetOperationsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetOperationsForResourceInputOperationOutputAlias,
                crate::output::GetOperationsForResourceOutput,
                crate::error::GetOperationsForResourceError,
                crate::input::GetOperationsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource for which you are requesting information.</p>
        pub fn resource_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(inp);
            self
        }
        /// <p>The name of the resource for which you are requesting information.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetOperationsForResource</code> request. If
        /// your results are paginated, the response will return a next page token that you can specify as
        /// the page token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetOperationsForResource</code> request. If
        /// your results are paginated, the response will return a next page token that you can specify as
        /// the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRegions`.
    ///
    /// <p>Returns a list of all valid regions for Amazon Lightsail. Use the <code>include
    /// availability zones</code> parameter to also return the Availability Zones in a
    /// region.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRegions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_regions_input::Builder,
    }
    impl<C, M, R> GetRegions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRegions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRegionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRegionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRegionsInputOperationOutputAlias,
                crate::output::GetRegionsOutput,
                crate::error::GetRegionsError,
                crate::input::GetRegionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A Boolean value indicating whether to also include Availability Zones in your get regions
        /// request. Availability Zones are indicated with a letter: e.g., <code>us-east-2a</code>.</p>
        pub fn include_availability_zones(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_availability_zones(inp);
            self
        }
        /// <p>A Boolean value indicating whether to also include Availability Zones in your get regions
        /// request. Availability Zones are indicated with a letter: e.g., <code>us-east-2a</code>.</p>
        pub fn set_include_availability_zones(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_availability_zones(input);
            self
        }
        /// <p>A Boolean value indicating whether to also include Availability Zones for databases in
        /// your get regions request. Availability Zones are indicated with a letter (e.g.,
        /// <code>us-east-2a</code>).</p>
        pub fn include_relational_database_availability_zones(mut self, inp: bool) -> Self {
            self.inner = self
                .inner
                .include_relational_database_availability_zones(inp);
            self
        }
        /// <p>A Boolean value indicating whether to also include Availability Zones for databases in
        /// your get regions request. Availability Zones are indicated with a letter (e.g.,
        /// <code>us-east-2a</code>).</p>
        pub fn set_include_relational_database_availability_zones(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self
                .inner
                .set_include_relational_database_availability_zones(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRelationalDatabase`.
    ///
    /// <p>Returns information about a specific database in Amazon Lightsail.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRelationalDatabase<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_relational_database_input::Builder,
    }
    impl<C, M, R> GetRelationalDatabase<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRelationalDatabase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRelationalDatabaseOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRelationalDatabaseInputOperationOutputAlias,
                crate::output::GetRelationalDatabaseOutput,
                crate::error::GetRelationalDatabaseError,
                crate::input::GetRelationalDatabaseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the database that you are looking up.</p>
        pub fn relational_database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.relational_database_name(inp);
            self
        }
        /// <p>The name of the database that you are looking up.</p>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRelationalDatabaseBlueprints`.
    ///
    /// <p>Returns a list of available database blueprints in Amazon Lightsail. A blueprint describes
    /// the major engine version of a database.</p>
    /// <p>You can use a blueprint ID to create a new database that runs a specific database
    /// engine.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRelationalDatabaseBlueprints<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_relational_database_blueprints_input::Builder,
    }
    impl<C, M, R> GetRelationalDatabaseBlueprints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRelationalDatabaseBlueprints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRelationalDatabaseBlueprintsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseBlueprintsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRelationalDatabaseBlueprintsInputOperationOutputAlias,
                crate::output::GetRelationalDatabaseBlueprintsOutput,
                crate::error::GetRelationalDatabaseBlueprintsError,
                crate::input::GetRelationalDatabaseBlueprintsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetRelationalDatabaseBlueprints</code>
        /// request. If your results are paginated, the response will return a next page token that you
        /// can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetRelationalDatabaseBlueprints</code>
        /// request. If your results are paginated, the response will return a next page token that you
        /// can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRelationalDatabaseBundles`.
    ///
    /// <p>Returns the list of bundles that are available in Amazon Lightsail. A bundle describes the
    /// performance specifications for a database.</p>
    /// <p>You can use a bundle ID to create a new database with explicit performance
    /// specifications.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRelationalDatabaseBundles<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_relational_database_bundles_input::Builder,
    }
    impl<C, M, R> GetRelationalDatabaseBundles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRelationalDatabaseBundles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRelationalDatabaseBundlesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseBundlesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRelationalDatabaseBundlesInputOperationOutputAlias,
                crate::output::GetRelationalDatabaseBundlesOutput,
                crate::error::GetRelationalDatabaseBundlesError,
                crate::input::GetRelationalDatabaseBundlesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetRelationalDatabaseBundles</code> request.
        /// If your results are paginated, the response will return a next page token that you can specify
        /// as the page token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetRelationalDatabaseBundles</code> request.
        /// If your results are paginated, the response will return a next page token that you can specify
        /// as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRelationalDatabaseEvents`.
    ///
    /// <p>Returns a list of events for a specific database in Amazon Lightsail.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRelationalDatabaseEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_relational_database_events_input::Builder,
    }
    impl<C, M, R> GetRelationalDatabaseEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRelationalDatabaseEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRelationalDatabaseEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRelationalDatabaseEventsInputOperationOutputAlias,
                crate::output::GetRelationalDatabaseEventsOutput,
                crate::error::GetRelationalDatabaseEventsError,
                crate::input::GetRelationalDatabaseEventsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the database from which to get events.</p>
        pub fn relational_database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.relational_database_name(inp);
            self
        }
        /// <p>The name of the database from which to get events.</p>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_name(input);
            self
        }
        /// <p>The number of minutes in the past from which to retrieve events. For example, to get all
        /// events from the past 2 hours, enter 120.</p>
        /// <p>Default: <code>60</code>
        /// </p>
        /// <p>The minimum is 1 and the maximum is 14 days (20160 minutes).</p>
        pub fn duration_in_minutes(mut self, inp: i32) -> Self {
            self.inner = self.inner.duration_in_minutes(inp);
            self
        }
        /// <p>The number of minutes in the past from which to retrieve events. For example, to get all
        /// events from the past 2 hours, enter 120.</p>
        /// <p>Default: <code>60</code>
        /// </p>
        /// <p>The minimum is 1 and the maximum is 14 days (20160 minutes).</p>
        pub fn set_duration_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration_in_minutes(input);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetRelationalDatabaseEvents</code> request.
        /// If your results are paginated, the response will return a next page token that you can specify
        /// as the page token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetRelationalDatabaseEvents</code> request.
        /// If your results are paginated, the response will return a next page token that you can specify
        /// as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRelationalDatabaseLogEvents`.
    ///
    /// <p>Returns a list of log events for a database in Amazon Lightsail.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRelationalDatabaseLogEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_relational_database_log_events_input::Builder,
    }
    impl<C, M, R> GetRelationalDatabaseLogEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRelationalDatabaseLogEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRelationalDatabaseLogEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseLogEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRelationalDatabaseLogEventsInputOperationOutputAlias,
                crate::output::GetRelationalDatabaseLogEventsOutput,
                crate::error::GetRelationalDatabaseLogEventsError,
                crate::input::GetRelationalDatabaseLogEventsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of your database for which to get log events.</p>
        pub fn relational_database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.relational_database_name(inp);
            self
        }
        /// <p>The name of your database for which to get log events.</p>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_name(input);
            self
        }
        /// <p>The name of the log stream.</p>
        /// <p>Use the <code>get relational database log streams</code> operation to get a list of
        /// available log streams.</p>
        pub fn log_stream_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.log_stream_name(inp);
            self
        }
        /// <p>The name of the log stream.</p>
        /// <p>Use the <code>get relational database log streams</code> operation to get a list of
        /// available log streams.</p>
        pub fn set_log_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_log_stream_name(input);
            self
        }
        /// <p>The start of the time interval from which to get log events.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Specified in the Unix time format.</p>
        /// <p>For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you
        /// input <code>1538424000</code> as the start time.</p>
        /// </li>
        /// </ul>
        pub fn start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The start of the time interval from which to get log events.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Specified in the Unix time format.</p>
        /// <p>For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you
        /// input <code>1538424000</code> as the start time.</p>
        /// </li>
        /// </ul>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time interval from which to get log events.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Specified in the Unix time format.</p>
        /// <p>For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you
        /// input <code>1538424000</code> as the end time.</p>
        ///
        /// </li>
        /// </ul>
        pub fn end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The end of the time interval from which to get log events.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Specified in the Unix time format.</p>
        /// <p>For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you
        /// input <code>1538424000</code> as the end time.</p>
        ///
        /// </li>
        /// </ul>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>Parameter to specify if the log should start from head or tail. If <code>true</code> is
        /// specified, the log event starts from the head of the log. If <code>false</code> is specified,
        /// the log event starts from the tail of the log.</p>
        /// <note>
        /// <p>For PostgreSQL, the default value of <code>false</code> is the only option
        /// available.</p>
        /// </note>
        pub fn start_from_head(mut self, inp: bool) -> Self {
            self.inner = self.inner.start_from_head(inp);
            self
        }
        /// <p>Parameter to specify if the log should start from head or tail. If <code>true</code> is
        /// specified, the log event starts from the head of the log. If <code>false</code> is specified,
        /// the log event starts from the tail of the log.</p>
        /// <note>
        /// <p>For PostgreSQL, the default value of <code>false</code> is the only option
        /// available.</p>
        /// </note>
        pub fn set_start_from_head(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_start_from_head(input);
            self
        }
        /// <p>The token to advance to the next or previous page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetRelationalDatabaseLogEvents</code>
        /// request. If your results are paginated, the response will return a next forward token and/or
        /// next backward token that you can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next or previous page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetRelationalDatabaseLogEvents</code>
        /// request. If your results are paginated, the response will return a next forward token and/or
        /// next backward token that you can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRelationalDatabaseLogStreams`.
    ///
    /// <p>Returns a list of available log streams for a specific database in Amazon Lightsail.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRelationalDatabaseLogStreams<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_relational_database_log_streams_input::Builder,
    }
    impl<C, M, R> GetRelationalDatabaseLogStreams<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRelationalDatabaseLogStreams`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRelationalDatabaseLogStreamsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseLogStreamsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRelationalDatabaseLogStreamsInputOperationOutputAlias,
                crate::output::GetRelationalDatabaseLogStreamsOutput,
                crate::error::GetRelationalDatabaseLogStreamsError,
                crate::input::GetRelationalDatabaseLogStreamsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of your database for which to get log streams.</p>
        pub fn relational_database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.relational_database_name(inp);
            self
        }
        /// <p>The name of your database for which to get log streams.</p>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRelationalDatabaseMasterUserPassword`.
    ///
    /// <p>Returns the current, previous, or pending versions of the master user password for a
    /// Lightsail database.</p>
    /// <p>The <code>GetRelationalDatabaseMasterUserPassword</code> operation supports tag-based
    /// access control via resource tags applied to the resource identified by
    /// relationalDatabaseName.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRelationalDatabaseMasterUserPassword<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_relational_database_master_user_password_input::Builder,
    }
    impl<C, M, R> GetRelationalDatabaseMasterUserPassword<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRelationalDatabaseMasterUserPassword`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRelationalDatabaseMasterUserPasswordOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetRelationalDatabaseMasterUserPasswordError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRelationalDatabaseMasterUserPasswordInputOperationOutputAlias,
                crate::output::GetRelationalDatabaseMasterUserPasswordOutput,
                crate::error::GetRelationalDatabaseMasterUserPasswordError,
                crate::input::GetRelationalDatabaseMasterUserPasswordInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of your database for which to get the master user password.</p>
        pub fn relational_database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.relational_database_name(inp);
            self
        }
        /// <p>The name of your database for which to get the master user password.</p>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_name(input);
            self
        }
        /// <p>The password version to return.</p>
        /// <p>Specifying <code>CURRENT</code> or <code>PREVIOUS</code> returns the current or previous
        /// passwords respectively. Specifying <code>PENDING</code> returns the newest version of the
        /// password that will rotate to <code>CURRENT</code>. After the <code>PENDING</code> password
        /// rotates to <code>CURRENT</code>, the <code>PENDING</code> password is no longer
        /// available.</p>
        /// <p>Default: <code>CURRENT</code>
        /// </p>
        pub fn password_version(
            mut self,
            inp: crate::model::RelationalDatabasePasswordVersion,
        ) -> Self {
            self.inner = self.inner.password_version(inp);
            self
        }
        /// <p>The password version to return.</p>
        /// <p>Specifying <code>CURRENT</code> or <code>PREVIOUS</code> returns the current or previous
        /// passwords respectively. Specifying <code>PENDING</code> returns the newest version of the
        /// password that will rotate to <code>CURRENT</code>. After the <code>PENDING</code> password
        /// rotates to <code>CURRENT</code>, the <code>PENDING</code> password is no longer
        /// available.</p>
        /// <p>Default: <code>CURRENT</code>
        /// </p>
        pub fn set_password_version(
            mut self,
            input: std::option::Option<crate::model::RelationalDatabasePasswordVersion>,
        ) -> Self {
            self.inner = self.inner.set_password_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRelationalDatabaseMetricData`.
    ///
    /// <p>Returns the data points of the specified metric for a database in Amazon Lightsail.</p>
    /// <p>Metrics report the utilization of your resources, and the error counts generated by them.
    /// Monitor and collect metric data regularly to maintain the reliability, availability, and
    /// performance of your resources.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRelationalDatabaseMetricData<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_relational_database_metric_data_input::Builder,
    }
    impl<C, M, R> GetRelationalDatabaseMetricData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRelationalDatabaseMetricData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRelationalDatabaseMetricDataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseMetricDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRelationalDatabaseMetricDataInputOperationOutputAlias,
                crate::output::GetRelationalDatabaseMetricDataOutput,
                crate::error::GetRelationalDatabaseMetricDataError,
                crate::input::GetRelationalDatabaseMetricDataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of your database from which to get metric data.</p>
        pub fn relational_database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.relational_database_name(inp);
            self
        }
        /// <p>The name of your database from which to get metric data.</p>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_name(input);
            self
        }
        /// <p>The metric for which you want to return information.</p>
        /// <p>Valid relational database metric names are listed below, along with the most useful
        /// <code>statistics</code> to include in your request, and the published <code>unit</code>
        /// value. All relational database metric data is available in 1-minute (60 seconds)
        /// granularity.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>CPUUtilization</code>
        /// </b> - The percentage of CPU
        /// utilization currently in use on the database.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and
        /// <code>Average</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Percent</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DatabaseConnections</code>
        /// </b> - The number of
        /// database connections in use.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and
        /// <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DiskQueueDepth</code>
        /// </b> - The number of
        /// outstanding IOs (read/write requests) that are waiting to access the disk.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>FreeStorageSpace</code>
        /// </b> - The amount of
        /// available storage space.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Bytes</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkReceiveThroughput</code>
        /// </b> - The incoming
        /// (Receive) network traffic on the database, including both customer database traffic and
        /// AWS traffic used for monitoring and replication.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Bytes/Second</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkTransmitThroughput</code>
        /// </b> - The outgoing
        /// (Transmit) network traffic on the database, including both customer database traffic and
        /// AWS traffic used for monitoring and replication.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Bytes/Second</code>.</p>
        /// </li>
        /// </ul>
        pub fn metric_name(mut self, inp: crate::model::RelationalDatabaseMetricName) -> Self {
            self.inner = self.inner.metric_name(inp);
            self
        }
        /// <p>The metric for which you want to return information.</p>
        /// <p>Valid relational database metric names are listed below, along with the most useful
        /// <code>statistics</code> to include in your request, and the published <code>unit</code>
        /// value. All relational database metric data is available in 1-minute (60 seconds)
        /// granularity.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>CPUUtilization</code>
        /// </b> - The percentage of CPU
        /// utilization currently in use on the database.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and
        /// <code>Average</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Percent</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DatabaseConnections</code>
        /// </b> - The number of
        /// database connections in use.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and
        /// <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DiskQueueDepth</code>
        /// </b> - The number of
        /// outstanding IOs (read/write requests) that are waiting to access the disk.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Count</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>FreeStorageSpace</code>
        /// </b> - The amount of
        /// available storage space.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Bytes</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkReceiveThroughput</code>
        /// </b> - The incoming
        /// (Receive) network traffic on the database, including both customer database traffic and
        /// AWS traffic used for monitoring and replication.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Bytes/Second</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NetworkTransmitThroughput</code>
        /// </b> - The outgoing
        /// (Transmit) network traffic on the database, including both customer database traffic and
        /// AWS traffic used for monitoring and replication.</p>
        /// <p>
        /// <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p>
        /// <p>
        /// <code>Unit</code>: The published unit is <code>Bytes/Second</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_metric_name(
            mut self,
            input: std::option::Option<crate::model::RelationalDatabaseMetricName>,
        ) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
        /// <p>The granularity, in seconds, of the returned data points.</p>
        /// <p>All relational database metric data is available in 1-minute (60 seconds)
        /// granularity.</p>
        pub fn period(mut self, inp: i32) -> Self {
            self.inner = self.inner.period(inp);
            self
        }
        /// <p>The granularity, in seconds, of the returned data points.</p>
        /// <p>All relational database metric data is available in 1-minute (60 seconds)
        /// granularity.</p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_period(input);
            self
        }
        /// <p>The start of the time interval from which to get metric data.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Specified in the Unix time format.</p>
        /// <p>For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you
        /// input <code>1538424000</code> as the start time.</p>
        ///
        /// </li>
        /// </ul>
        pub fn start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The start of the time interval from which to get metric data.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Specified in the Unix time format.</p>
        /// <p>For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you
        /// input <code>1538424000</code> as the start time.</p>
        ///
        /// </li>
        /// </ul>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time interval from which to get metric data.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Specified in the Unix time format.</p>
        /// <p>For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you
        /// input <code>1538424000</code> as the end time.</p>
        ///
        /// </li>
        /// </ul>
        pub fn end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The end of the time interval from which to get metric data.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Specified in the Unix time format.</p>
        /// <p>For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you
        /// input <code>1538424000</code> as the end time.</p>
        ///
        /// </li>
        /// </ul>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The unit for the metric data request. Valid units depend on the metric data being
        /// requested. For the valid units with each available metric, see the <code>metricName</code>
        /// parameter.</p>
        pub fn unit(mut self, inp: crate::model::MetricUnit) -> Self {
            self.inner = self.inner.unit(inp);
            self
        }
        /// <p>The unit for the metric data request. Valid units depend on the metric data being
        /// requested. For the valid units with each available metric, see the <code>metricName</code>
        /// parameter.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::MetricUnit>) -> Self {
            self.inner = self.inner.set_unit(input);
            self
        }
        /// Appends an item to `statistics`.
        ///
        /// To override the contents of this collection use [`set_statistics`](Self::set_statistics).
        ///
        /// <p>The statistic for the metric.</p>
        /// <p>The following statistics are available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Minimum</code> - The lowest value observed during the specified period. Use this
        /// value to determine low volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Maximum</code> - The highest value observed during the specified period. Use
        /// this value to determine high volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Sum</code> - All values submitted for the matching metric added together. You
        /// can use this statistic to determine the total volume of a metric.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Average</code> - The value of Sum / SampleCount during the specified period. By
        /// comparing this statistic with the Minimum and Maximum values, you can determine the full
        /// scope of a metric and how close the average use is to the Minimum and Maximum values. This
        /// comparison helps you to know when to increase or decrease your resources.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SampleCount</code> - The count, or number, of data points used for the
        /// statistical calculation.</p>
        /// </li>
        /// </ul>
        pub fn statistics(mut self, inp: impl Into<crate::model::MetricStatistic>) -> Self {
            self.inner = self.inner.statistics(inp);
            self
        }
        /// <p>The statistic for the metric.</p>
        /// <p>The following statistics are available:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Minimum</code> - The lowest value observed during the specified period. Use this
        /// value to determine low volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Maximum</code> - The highest value observed during the specified period. Use
        /// this value to determine high volumes of activity for your application.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Sum</code> - All values submitted for the matching metric added together. You
        /// can use this statistic to determine the total volume of a metric.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Average</code> - The value of Sum / SampleCount during the specified period. By
        /// comparing this statistic with the Minimum and Maximum values, you can determine the full
        /// scope of a metric and how close the average use is to the Minimum and Maximum values. This
        /// comparison helps you to know when to increase or decrease your resources.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SampleCount</code> - The count, or number, of data points used for the
        /// statistical calculation.</p>
        /// </li>
        /// </ul>
        pub fn set_statistics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricStatistic>>,
        ) -> Self {
            self.inner = self.inner.set_statistics(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRelationalDatabaseParameters`.
    ///
    /// <p>Returns all of the runtime parameters offered by the underlying database software, or
    /// engine, for a specific database in Amazon Lightsail.</p>
    /// <p>In addition to the parameter names and values, this operation returns other information
    /// about each parameter. This information includes whether changes require a reboot, whether the
    /// parameter is modifiable, the allowed values, and the data types.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRelationalDatabaseParameters<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_relational_database_parameters_input::Builder,
    }
    impl<C, M, R> GetRelationalDatabaseParameters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRelationalDatabaseParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRelationalDatabaseParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseParametersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRelationalDatabaseParametersInputOperationOutputAlias,
                crate::output::GetRelationalDatabaseParametersOutput,
                crate::error::GetRelationalDatabaseParametersError,
                crate::input::GetRelationalDatabaseParametersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of your database for which to get parameters.</p>
        pub fn relational_database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.relational_database_name(inp);
            self
        }
        /// <p>The name of your database for which to get parameters.</p>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_name(input);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetRelationalDatabaseParameters</code>
        /// request. If your results are paginated, the response will return a next page token that you
        /// can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetRelationalDatabaseParameters</code>
        /// request. If your results are paginated, the response will return a next page token that you
        /// can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRelationalDatabases`.
    ///
    /// <p>Returns information about all of your databases in Amazon Lightsail.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRelationalDatabases<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_relational_databases_input::Builder,
    }
    impl<C, M, R> GetRelationalDatabases<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRelationalDatabases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRelationalDatabasesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabasesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRelationalDatabasesInputOperationOutputAlias,
                crate::output::GetRelationalDatabasesOutput,
                crate::error::GetRelationalDatabasesError,
                crate::input::GetRelationalDatabasesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetRelationalDatabases</code> request. If
        /// your results are paginated, the response will return a next page token that you can specify as
        /// the page token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetRelationalDatabases</code> request. If
        /// your results are paginated, the response will return a next page token that you can specify as
        /// the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRelationalDatabaseSnapshot`.
    ///
    /// <p>Returns information about a specific database snapshot in Amazon Lightsail.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRelationalDatabaseSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_relational_database_snapshot_input::Builder,
    }
    impl<C, M, R> GetRelationalDatabaseSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRelationalDatabaseSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRelationalDatabaseSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRelationalDatabaseSnapshotInputOperationOutputAlias,
                crate::output::GetRelationalDatabaseSnapshotOutput,
                crate::error::GetRelationalDatabaseSnapshotError,
                crate::input::GetRelationalDatabaseSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the database snapshot for which to get information.</p>
        pub fn relational_database_snapshot_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.relational_database_snapshot_name(inp);
            self
        }
        /// <p>The name of the database snapshot for which to get information.</p>
        pub fn set_relational_database_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_snapshot_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRelationalDatabaseSnapshots`.
    ///
    /// <p>Returns information about all of your database snapshots in Amazon Lightsail.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetRelationalDatabaseSnapshots<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_relational_database_snapshots_input::Builder,
    }
    impl<C, M, R> GetRelationalDatabaseSnapshots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRelationalDatabaseSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRelationalDatabaseSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseSnapshotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRelationalDatabaseSnapshotsInputOperationOutputAlias,
                crate::output::GetRelationalDatabaseSnapshotsOutput,
                crate::error::GetRelationalDatabaseSnapshotsError,
                crate::input::GetRelationalDatabaseSnapshotsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetRelationalDatabaseSnapshots</code>
        /// request. If your results are paginated, the response will return a next page token that you
        /// can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetRelationalDatabaseSnapshots</code>
        /// request. If your results are paginated, the response will return a next page token that you
        /// can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStaticIp`.
    ///
    /// <p>Returns information about an Amazon Lightsail static IP.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetStaticIp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_static_ip_input::Builder,
    }
    impl<C, M, R> GetStaticIp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStaticIp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStaticIpOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStaticIpError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStaticIpInputOperationOutputAlias,
                crate::output::GetStaticIpOutput,
                crate::error::GetStaticIpError,
                crate::input::GetStaticIpInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the static IP in Lightsail.</p>
        pub fn static_ip_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.static_ip_name(inp);
            self
        }
        /// <p>The name of the static IP in Lightsail.</p>
        pub fn set_static_ip_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_static_ip_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetStaticIps`.
    ///
    /// <p>Returns information about all static IPs in the user's account.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetStaticIps<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_static_ips_input::Builder,
    }
    impl<C, M, R> GetStaticIps<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetStaticIps`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetStaticIpsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetStaticIpsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetStaticIpsInputOperationOutputAlias,
                crate::output::GetStaticIpsOutput,
                crate::error::GetStaticIpsError,
                crate::input::GetStaticIpsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetStaticIps</code> request. If your results
        /// are paginated, the response will return a next page token that you can specify as the page
        /// token in a subsequent request.</p>
        pub fn page_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.page_token(inp);
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetStaticIps</code> request. If your results
        /// are paginated, the response will return a next page token that you can specify as the page
        /// token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportKeyPair`.
    ///
    /// <p>Imports a public SSH key from a specific key pair.</p>
    #[derive(std::fmt::Debug)]
    pub struct ImportKeyPair<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_key_pair_input::Builder,
    }
    impl<C, M, R> ImportKeyPair<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportKeyPair`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportKeyPairOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportKeyPairError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportKeyPairInputOperationOutputAlias,
                crate::output::ImportKeyPairOutput,
                crate::error::ImportKeyPairError,
                crate::input::ImportKeyPairInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the key pair for which you want to import the public key.</p>
        pub fn key_pair_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_pair_name(inp);
            self
        }
        /// <p>The name of the key pair for which you want to import the public key.</p>
        pub fn set_key_pair_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_key_pair_name(input);
            self
        }
        /// <p>A base64-encoded public key of the <code>ssh-rsa</code> type.</p>
        pub fn public_key_base64(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.public_key_base64(inp);
            self
        }
        /// <p>A base64-encoded public key of the <code>ssh-rsa</code> type.</p>
        pub fn set_public_key_base64(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_public_key_base64(input);
            self
        }
    }
    /// Fluent builder constructing a request to `IsVpcPeered`.
    ///
    /// <p>Returns a Boolean value indicating whether your Lightsail VPC is peered.</p>
    #[derive(std::fmt::Debug)]
    pub struct IsVpcPeered<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::is_vpc_peered_input::Builder,
    }
    impl<C, M, R> IsVpcPeered<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `IsVpcPeered`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::IsVpcPeeredOutput,
            aws_smithy_http::result::SdkError<crate::error::IsVpcPeeredError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::IsVpcPeeredInputOperationOutputAlias,
                crate::output::IsVpcPeeredOutput,
                crate::error::IsVpcPeeredError,
                crate::input::IsVpcPeeredInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `OpenInstancePublicPorts`.
    ///
    /// <p>Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses
    /// allowed to connect to the instance through the ports, and the protocol.</p>
    /// <p>The <code>OpenInstancePublicPorts</code> action supports tag-based access control via
    /// resource tags applied to the resource identified by <code>instanceName</code>. For more
    /// information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct OpenInstancePublicPorts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::open_instance_public_ports_input::Builder,
    }
    impl<C, M, R> OpenInstancePublicPorts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `OpenInstancePublicPorts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::OpenInstancePublicPortsOutput,
            aws_smithy_http::result::SdkError<crate::error::OpenInstancePublicPortsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::OpenInstancePublicPortsInputOperationOutputAlias,
                crate::output::OpenInstancePublicPortsOutput,
                crate::error::OpenInstancePublicPortsError,
                crate::input::OpenInstancePublicPortsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An object to describe the ports to open for the specified instance.</p>
        pub fn port_info(mut self, inp: crate::model::PortInfo) -> Self {
            self.inner = self.inner.port_info(inp);
            self
        }
        /// <p>An object to describe the ports to open for the specified instance.</p>
        pub fn set_port_info(mut self, input: std::option::Option<crate::model::PortInfo>) -> Self {
            self.inner = self.inner.set_port_info(input);
            self
        }
        /// <p>The name of the instance for which to open ports.</p>
        pub fn instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_name(inp);
            self
        }
        /// <p>The name of the instance for which to open ports.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PeerVpc`.
    ///
    /// <p>Peers the Lightsail VPC with the user's default VPC.</p>
    #[derive(std::fmt::Debug)]
    pub struct PeerVpc<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::peer_vpc_input::Builder,
    }
    impl<C, M, R> PeerVpc<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PeerVpc`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PeerVpcOutput,
            aws_smithy_http::result::SdkError<crate::error::PeerVpcError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PeerVpcInputOperationOutputAlias,
                crate::output::PeerVpcOutput,
                crate::error::PeerVpcError,
                crate::input::PeerVpcInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `PutAlarm`.
    ///
    /// <p>Creates or updates an alarm, and associates it with the specified metric.</p>
    /// <p>An alarm is used to monitor a single metric for one of your resources. When a metric
    /// condition is met, the alarm can notify you by email, SMS text message, and a banner displayed
    /// on the Amazon Lightsail console. For more information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms">Alarms
    /// in Amazon Lightsail</a>.</p>
    /// <p>When this action creates an alarm, the alarm state is immediately set to
    /// <code>INSUFFICIENT_DATA</code>. The alarm is then evaluated and its state is set
    /// appropriately. Any actions associated with the new state are then executed.</p>
    /// <p>When you update an existing alarm, its state is left unchanged, but the update completely
    /// overwrites the previous configuration of the alarm. The alarm is then evaluated with the
    /// updated configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutAlarm<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_alarm_input::Builder,
    }
    impl<C, M, R> PutAlarm<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutAlarm`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutAlarmOutput,
            aws_smithy_http::result::SdkError<crate::error::PutAlarmError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutAlarmInputOperationOutputAlias,
                crate::output::PutAlarmOutput,
                crate::error::PutAlarmError,
                crate::input::PutAlarmInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the alarm. Specify the name of an existing alarm to update, and overwrite the
        /// previous configuration of the alarm.</p>
        pub fn alarm_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alarm_name(inp);
            self
        }
        /// <p>The name for the alarm. Specify the name of an existing alarm to update, and overwrite the
        /// previous configuration of the alarm.</p>
        pub fn set_alarm_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alarm_name(input);
            self
        }
        /// <p>The name of the metric to associate with the alarm.</p>
        /// <p>You can configure up to two alarms per metric.</p>
        /// <p>The following metrics are available for each resource type:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Instances</b>: <code>BurstCapacityPercentage</code>,
        /// <code>BurstCapacityTime</code>, <code>CPUUtilization</code>, <code>NetworkIn</code>,
        /// <code>NetworkOut</code>, <code>StatusCheckFailed</code>,
        /// <code>StatusCheckFailed_Instance</code>, and
        /// <code>StatusCheckFailed_System</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Load balancers</b>:
        /// <code>ClientTLSNegotiationErrorCount</code>, <code>HealthyHostCount</code>,
        /// <code>UnhealthyHostCount</code>, <code>HTTPCode_LB_4XX_Count</code>,
        /// <code>HTTPCode_LB_5XX_Count</code>, <code>HTTPCode_Instance_2XX_Count</code>,
        /// <code>HTTPCode_Instance_3XX_Count</code>, <code>HTTPCode_Instance_4XX_Count</code>,
        /// <code>HTTPCode_Instance_5XX_Count</code>, <code>InstanceResponseTime</code>,
        /// <code>RejectedConnectionCount</code>, and <code>RequestCount</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Relational databases</b>: <code>CPUUtilization</code>,
        /// <code>DatabaseConnections</code>, <code>DiskQueueDepth</code>,
        /// <code>FreeStorageSpace</code>, <code>NetworkReceiveThroughput</code>, and
        /// <code>NetworkTransmitThroughput</code>.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about these metrics, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-resource-health-metrics#available-metrics">Metrics available in Lightsail</a>.</p>
        pub fn metric_name(mut self, inp: crate::model::MetricName) -> Self {
            self.inner = self.inner.metric_name(inp);
            self
        }
        /// <p>The name of the metric to associate with the alarm.</p>
        /// <p>You can configure up to two alarms per metric.</p>
        /// <p>The following metrics are available for each resource type:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Instances</b>: <code>BurstCapacityPercentage</code>,
        /// <code>BurstCapacityTime</code>, <code>CPUUtilization</code>, <code>NetworkIn</code>,
        /// <code>NetworkOut</code>, <code>StatusCheckFailed</code>,
        /// <code>StatusCheckFailed_Instance</code>, and
        /// <code>StatusCheckFailed_System</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Load balancers</b>:
        /// <code>ClientTLSNegotiationErrorCount</code>, <code>HealthyHostCount</code>,
        /// <code>UnhealthyHostCount</code>, <code>HTTPCode_LB_4XX_Count</code>,
        /// <code>HTTPCode_LB_5XX_Count</code>, <code>HTTPCode_Instance_2XX_Count</code>,
        /// <code>HTTPCode_Instance_3XX_Count</code>, <code>HTTPCode_Instance_4XX_Count</code>,
        /// <code>HTTPCode_Instance_5XX_Count</code>, <code>InstanceResponseTime</code>,
        /// <code>RejectedConnectionCount</code>, and <code>RequestCount</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>Relational databases</b>: <code>CPUUtilization</code>,
        /// <code>DatabaseConnections</code>, <code>DiskQueueDepth</code>,
        /// <code>FreeStorageSpace</code>, <code>NetworkReceiveThroughput</code>, and
        /// <code>NetworkTransmitThroughput</code>.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about these metrics, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-resource-health-metrics#available-metrics">Metrics available in Lightsail</a>.</p>
        pub fn set_metric_name(
            mut self,
            input: std::option::Option<crate::model::MetricName>,
        ) -> Self {
            self.inner = self.inner.set_metric_name(input);
            self
        }
        /// <p>The name of the Lightsail resource that will be monitored.</p>
        /// <p>Instances, load balancers, and relational databases are the only Lightsail resources
        /// that can currently be monitored by alarms.</p>
        pub fn monitored_resource_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.monitored_resource_name(inp);
            self
        }
        /// <p>The name of the Lightsail resource that will be monitored.</p>
        /// <p>Instances, load balancers, and relational databases are the only Lightsail resources
        /// that can currently be monitored by alarms.</p>
        pub fn set_monitored_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_monitored_resource_name(input);
            self
        }
        /// <p>The arithmetic operation to use when comparing the specified statistic to the threshold.
        /// The specified statistic value is used as the first operand.</p>
        pub fn comparison_operator(mut self, inp: crate::model::ComparisonOperator) -> Self {
            self.inner = self.inner.comparison_operator(inp);
            self
        }
        /// <p>The arithmetic operation to use when comparing the specified statistic to the threshold.
        /// The specified statistic value is used as the first operand.</p>
        pub fn set_comparison_operator(
            mut self,
            input: std::option::Option<crate::model::ComparisonOperator>,
        ) -> Self {
            self.inner = self.inner.set_comparison_operator(input);
            self
        }
        /// <p>The value against which the specified statistic is compared.</p>
        pub fn threshold(mut self, inp: f64) -> Self {
            self.inner = self.inner.threshold(inp);
            self
        }
        /// <p>The value against which the specified statistic is compared.</p>
        pub fn set_threshold(mut self, input: std::option::Option<f64>) -> Self {
            self.inner = self.inner.set_threshold(input);
            self
        }
        /// <p>The number of most recent periods over which data is compared to the specified threshold.
        /// If you are setting an "M out of N" alarm, this value (<code>evaluationPeriods</code>) is the
        /// N.</p>
        /// <p>If you are setting an alarm that requires that a number of consecutive data points be
        /// breaching to trigger the alarm, this value specifies the rolling period of time in which data
        /// points are evaluated.</p>
        /// <p>Each evaluation period is five minutes long. For example, specify an evaluation period of
        /// 24 to evaluate a metric over a rolling period of two hours.</p>
        /// <p>You can specify a minimum valuation period of 1 (5 minutes), and a maximum evaluation
        /// period of 288 (24 hours).</p>
        pub fn evaluation_periods(mut self, inp: i32) -> Self {
            self.inner = self.inner.evaluation_periods(inp);
            self
        }
        /// <p>The number of most recent periods over which data is compared to the specified threshold.
        /// If you are setting an "M out of N" alarm, this value (<code>evaluationPeriods</code>) is the
        /// N.</p>
        /// <p>If you are setting an alarm that requires that a number of consecutive data points be
        /// breaching to trigger the alarm, this value specifies the rolling period of time in which data
        /// points are evaluated.</p>
        /// <p>Each evaluation period is five minutes long. For example, specify an evaluation period of
        /// 24 to evaluate a metric over a rolling period of two hours.</p>
        /// <p>You can specify a minimum valuation period of 1 (5 minutes), and a maximum evaluation
        /// period of 288 (24 hours).</p>
        pub fn set_evaluation_periods(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_evaluation_periods(input);
            self
        }
        /// <p>The number of data points that must be not within the specified threshold to trigger the
        /// alarm. If you are setting an "M out of N" alarm, this value (<code>datapointsToAlarm</code>)
        /// is the M.</p>
        pub fn datapoints_to_alarm(mut self, inp: i32) -> Self {
            self.inner = self.inner.datapoints_to_alarm(inp);
            self
        }
        /// <p>The number of data points that must be not within the specified threshold to trigger the
        /// alarm. If you are setting an "M out of N" alarm, this value (<code>datapointsToAlarm</code>)
        /// is the M.</p>
        pub fn set_datapoints_to_alarm(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_datapoints_to_alarm(input);
            self
        }
        /// <p>Sets how this alarm will handle missing data points.</p>
        /// <p>An alarm can treat missing data in the following ways:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>breaching</code> - Assume the missing data is not within the threshold. Missing
        /// data counts towards the number of times the metric is not within the threshold.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>notBreaching</code> - Assume the missing data is within the threshold. Missing
        /// data does not count towards the number of times the metric is not within the
        /// threshold.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ignore</code> - Ignore the missing data. Maintains the current alarm
        /// state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>missing</code> - Missing data is treated as missing.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>treatMissingData</code> is not specified, the default behavior of
        /// <code>missing</code> is used.</p>
        pub fn treat_missing_data(mut self, inp: crate::model::TreatMissingData) -> Self {
            self.inner = self.inner.treat_missing_data(inp);
            self
        }
        /// <p>Sets how this alarm will handle missing data points.</p>
        /// <p>An alarm can treat missing data in the following ways:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>breaching</code> - Assume the missing data is not within the threshold. Missing
        /// data counts towards the number of times the metric is not within the threshold.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>notBreaching</code> - Assume the missing data is within the threshold. Missing
        /// data does not count towards the number of times the metric is not within the
        /// threshold.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ignore</code> - Ignore the missing data. Maintains the current alarm
        /// state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>missing</code> - Missing data is treated as missing.</p>
        /// </li>
        /// </ul>
        /// <p>If <code>treatMissingData</code> is not specified, the default behavior of
        /// <code>missing</code> is used.</p>
        pub fn set_treat_missing_data(
            mut self,
            input: std::option::Option<crate::model::TreatMissingData>,
        ) -> Self {
            self.inner = self.inner.set_treat_missing_data(input);
            self
        }
        /// Appends an item to `contactProtocols`.
        ///
        /// To override the contents of this collection use [`set_contact_protocols`](Self::set_contact_protocols).
        ///
        /// <p>The contact protocols to use for the alarm, such as <code>Email</code>, <code>SMS</code>
        /// (text messaging), or both.</p>
        /// <p>A notification is sent via the specified contact protocol if notifications are enabled for
        /// the alarm, and when the alarm is triggered.</p>
        /// <p>A notification is not sent if a contact protocol is not specified, if the specified
        /// contact protocol is not configured in the AWS Region, or if notifications are not enabled
        /// for the alarm using the <code>notificationEnabled</code> paramater.</p>
        /// <p>Use the <code>CreateContactMethod</code> action to configure a contact protocol in an
        /// AWS Region.</p>
        pub fn contact_protocols(mut self, inp: impl Into<crate::model::ContactProtocol>) -> Self {
            self.inner = self.inner.contact_protocols(inp);
            self
        }
        /// <p>The contact protocols to use for the alarm, such as <code>Email</code>, <code>SMS</code>
        /// (text messaging), or both.</p>
        /// <p>A notification is sent via the specified contact protocol if notifications are enabled for
        /// the alarm, and when the alarm is triggered.</p>
        /// <p>A notification is not sent if a contact protocol is not specified, if the specified
        /// contact protocol is not configured in the AWS Region, or if notifications are not enabled
        /// for the alarm using the <code>notificationEnabled</code> paramater.</p>
        /// <p>Use the <code>CreateContactMethod</code> action to configure a contact protocol in an
        /// AWS Region.</p>
        pub fn set_contact_protocols(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContactProtocol>>,
        ) -> Self {
            self.inner = self.inner.set_contact_protocols(input);
            self
        }
        /// Appends an item to `notificationTriggers`.
        ///
        /// To override the contents of this collection use [`set_notification_triggers`](Self::set_notification_triggers).
        ///
        /// <p>The alarm states that trigger a notification.</p>
        /// <p>An alarm has the following possible states:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALARM</code> - The metric is outside of the defined threshold.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not
        /// available, or not enough data is available for the metric to determine the alarm
        /// state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OK</code> - The metric is within the defined threshold.</p>
        /// </li>
        /// </ul>
        /// <p>When you specify a notification trigger, the <code>ALARM</code> state must be specified.
        /// The <code>INSUFFICIENT_DATA</code> and <code>OK</code> states can be specified in addition to
        /// the <code>ALARM</code> state.</p>
        /// <ul>
        /// <li>
        /// <p>If you specify <code>OK</code> as an alarm trigger, a notification is sent when the
        /// alarm switches from an <code>ALARM</code> or <code>INSUFFICIENT_DATA</code> alarm state to
        /// an <code>OK</code> state. This can be thought of as an <i>all clear</i>
        /// alarm notification.</p>
        /// </li>
        /// <li>
        /// <p>If you specify <code>INSUFFICIENT_DATA</code> as the alarm trigger, a notification is
        /// sent when the alarm switches from an <code>OK</code> or <code>ALARM</code> alarm state to
        /// an <code>INSUFFICIENT_DATA</code> state.</p>
        /// </li>
        /// </ul>
        /// <p>The notification trigger defaults to <code>ALARM</code> if you don't specify this
        /// parameter.</p>
        pub fn notification_triggers(mut self, inp: impl Into<crate::model::AlarmState>) -> Self {
            self.inner = self.inner.notification_triggers(inp);
            self
        }
        /// <p>The alarm states that trigger a notification.</p>
        /// <p>An alarm has the following possible states:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALARM</code> - The metric is outside of the defined threshold.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not
        /// available, or not enough data is available for the metric to determine the alarm
        /// state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OK</code> - The metric is within the defined threshold.</p>
        /// </li>
        /// </ul>
        /// <p>When you specify a notification trigger, the <code>ALARM</code> state must be specified.
        /// The <code>INSUFFICIENT_DATA</code> and <code>OK</code> states can be specified in addition to
        /// the <code>ALARM</code> state.</p>
        /// <ul>
        /// <li>
        /// <p>If you specify <code>OK</code> as an alarm trigger, a notification is sent when the
        /// alarm switches from an <code>ALARM</code> or <code>INSUFFICIENT_DATA</code> alarm state to
        /// an <code>OK</code> state. This can be thought of as an <i>all clear</i>
        /// alarm notification.</p>
        /// </li>
        /// <li>
        /// <p>If you specify <code>INSUFFICIENT_DATA</code> as the alarm trigger, a notification is
        /// sent when the alarm switches from an <code>OK</code> or <code>ALARM</code> alarm state to
        /// an <code>INSUFFICIENT_DATA</code> state.</p>
        /// </li>
        /// </ul>
        /// <p>The notification trigger defaults to <code>ALARM</code> if you don't specify this
        /// parameter.</p>
        pub fn set_notification_triggers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AlarmState>>,
        ) -> Self {
            self.inner = self.inner.set_notification_triggers(input);
            self
        }
        /// <p>Indicates whether the alarm is enabled.</p>
        /// <p>Notifications are enabled by default if you don't specify this parameter.</p>
        pub fn notification_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.notification_enabled(inp);
            self
        }
        /// <p>Indicates whether the alarm is enabled.</p>
        /// <p>Notifications are enabled by default if you don't specify this parameter.</p>
        pub fn set_notification_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_notification_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutInstancePublicPorts`.
    ///
    /// <p>Opens ports for a specific Amazon Lightsail instance, and specifies the IP addresses
    /// allowed to connect to the instance through the ports, and the protocol. This action also
    /// closes all currently open ports that are not included in the request. Include all of the ports
    /// and the protocols you want to open in your <code>PutInstancePublicPorts</code>request. Or use
    /// the <code>OpenInstancePublicPorts</code> action to open ports without closing currently open
    /// ports.</p>
    /// <p>The <code>PutInstancePublicPorts</code> action supports tag-based access control via
    /// resource tags applied to the resource identified by <code>instanceName</code>. For more
    /// information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutInstancePublicPorts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_instance_public_ports_input::Builder,
    }
    impl<C, M, R> PutInstancePublicPorts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutInstancePublicPorts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutInstancePublicPortsOutput,
            aws_smithy_http::result::SdkError<crate::error::PutInstancePublicPortsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutInstancePublicPortsInputOperationOutputAlias,
                crate::output::PutInstancePublicPortsOutput,
                crate::error::PutInstancePublicPortsError,
                crate::input::PutInstancePublicPortsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `portInfos`.
        ///
        /// To override the contents of this collection use [`set_port_infos`](Self::set_port_infos).
        ///
        /// <p>An array of objects to describe the ports to open for the specified instance.</p>
        pub fn port_infos(mut self, inp: impl Into<crate::model::PortInfo>) -> Self {
            self.inner = self.inner.port_infos(inp);
            self
        }
        /// <p>An array of objects to describe the ports to open for the specified instance.</p>
        pub fn set_port_infos(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PortInfo>>,
        ) -> Self {
            self.inner = self.inner.set_port_infos(input);
            self
        }
        /// <p>The name of the instance for which to open ports.</p>
        pub fn instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_name(inp);
            self
        }
        /// <p>The name of the instance for which to open ports.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RebootInstance`.
    ///
    /// <p>Restarts a specific instance.</p>
    /// <p>The <code>reboot instance</code> operation supports tag-based access control via resource
    /// tags applied to the resource identified by <code>instance name</code>. For more information,
    /// see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RebootInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reboot_instance_input::Builder,
    }
    impl<C, M, R> RebootInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RebootInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RebootInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::RebootInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RebootInstanceInputOperationOutputAlias,
                crate::output::RebootInstanceOutput,
                crate::error::RebootInstanceError,
                crate::input::RebootInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the instance to reboot.</p>
        pub fn instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_name(inp);
            self
        }
        /// <p>The name of the instance to reboot.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RebootRelationalDatabase`.
    ///
    /// <p>Restarts a specific database in Amazon Lightsail.</p>
    /// <p>The <code>reboot relational database</code> operation supports tag-based access control
    /// via resource tags applied to the resource identified by relationalDatabaseName. For more
    /// information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RebootRelationalDatabase<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reboot_relational_database_input::Builder,
    }
    impl<C, M, R> RebootRelationalDatabase<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RebootRelationalDatabase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RebootRelationalDatabaseOutput,
            aws_smithy_http::result::SdkError<crate::error::RebootRelationalDatabaseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RebootRelationalDatabaseInputOperationOutputAlias,
                crate::output::RebootRelationalDatabaseOutput,
                crate::error::RebootRelationalDatabaseError,
                crate::input::RebootRelationalDatabaseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of your database to reboot.</p>
        pub fn relational_database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.relational_database_name(inp);
            self
        }
        /// <p>The name of your database to reboot.</p>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RegisterContainerImage`.
    ///
    /// <p>Registers a container image to your Amazon Lightsail container service.</p>
    ///
    /// <note>
    /// <p>This action is not required if you install and use the Lightsail Control
    /// (lightsailctl) plugin to push container images to your Lightsail container service. For
    /// more information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-pushing-container-images">Pushing and managing container images on your Amazon Lightsail container services</a>
    /// in the <i>Amazon Lightsail Developer Guide</i>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct RegisterContainerImage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::register_container_image_input::Builder,
    }
    impl<C, M, R> RegisterContainerImage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RegisterContainerImage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RegisterContainerImageOutput,
            aws_smithy_http::result::SdkError<crate::error::RegisterContainerImageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RegisterContainerImageInputOperationOutputAlias,
                crate::output::RegisterContainerImageOutput,
                crate::error::RegisterContainerImageError,
                crate::input::RegisterContainerImageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container service for which to register a container image.</p>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>The name of the container service for which to register a container image.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
        /// <p>The label for the container image when it's registered to the container service.</p>
        ///
        /// <p>Use a descriptive label that you can use to track the different versions of your
        /// registered container images.</p>
        ///
        /// <p>Use the <code>GetContainerImages</code> action to return the container images registered
        /// to a Lightsail container service. The label is the <code><imagelabel></code> portion
        /// of the following image name example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>:container-service-1.<imagelabel>.1</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>If the name of your container service is <code>mycontainerservice</code>, and the label
        /// that you specify is <code>mystaticwebsite</code>, then the name of the registered container
        /// image will be <code>:mycontainerservice.mystaticwebsite.1</code>.</p>
        ///
        /// <p>The number at the end of these image name examples represents the version of the
        /// registered container image. If you push and register another container image to the same
        /// Lightsail container service, with the same label, then the version number for the new
        /// registered container image will be <code>2</code>. If you push and register another container
        /// image, the version number will be <code>3</code>, and so on.</p>
        pub fn label(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.label(inp);
            self
        }
        /// <p>The label for the container image when it's registered to the container service.</p>
        ///
        /// <p>Use a descriptive label that you can use to track the different versions of your
        /// registered container images.</p>
        ///
        /// <p>Use the <code>GetContainerImages</code> action to return the container images registered
        /// to a Lightsail container service. The label is the <code><imagelabel></code> portion
        /// of the following image name example:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>:container-service-1.<imagelabel>.1</code>
        /// </p>
        /// </li>
        /// </ul>
        ///
        /// <p>If the name of your container service is <code>mycontainerservice</code>, and the label
        /// that you specify is <code>mystaticwebsite</code>, then the name of the registered container
        /// image will be <code>:mycontainerservice.mystaticwebsite.1</code>.</p>
        ///
        /// <p>The number at the end of these image name examples represents the version of the
        /// registered container image. If you push and register another container image to the same
        /// Lightsail container service, with the same label, then the version number for the new
        /// registered container image will be <code>2</code>. If you push and register another container
        /// image, the version number will be <code>3</code>, and so on.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_label(input);
            self
        }
        /// <p>The digest of the container image to be registered.</p>
        pub fn digest(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.digest(inp);
            self
        }
        /// <p>The digest of the container image to be registered.</p>
        pub fn set_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_digest(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ReleaseStaticIp`.
    ///
    /// <p>Deletes a specific static IP from your account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ReleaseStaticIp<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::release_static_ip_input::Builder,
    }
    impl<C, M, R> ReleaseStaticIp<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ReleaseStaticIp`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ReleaseStaticIpOutput,
            aws_smithy_http::result::SdkError<crate::error::ReleaseStaticIpError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ReleaseStaticIpInputOperationOutputAlias,
                crate::output::ReleaseStaticIpOutput,
                crate::error::ReleaseStaticIpError,
                crate::input::ReleaseStaticIpInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the static IP to delete.</p>
        pub fn static_ip_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.static_ip_name(inp);
            self
        }
        /// <p>The name of the static IP to delete.</p>
        pub fn set_static_ip_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_static_ip_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetDistributionCache`.
    ///
    /// <p>Deletes currently cached content from your Amazon Lightsail content delivery network (CDN)
    /// distribution.</p>
    /// <p>After resetting the cache, the next time a content request is made, your distribution
    /// pulls, serves, and caches it from the origin.</p>
    #[derive(std::fmt::Debug)]
    pub struct ResetDistributionCache<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reset_distribution_cache_input::Builder,
    }
    impl<C, M, R> ResetDistributionCache<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResetDistributionCache`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetDistributionCacheOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetDistributionCacheError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResetDistributionCacheInputOperationOutputAlias,
                crate::output::ResetDistributionCacheOutput,
                crate::error::ResetDistributionCacheError,
                crate::input::ResetDistributionCacheInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the distribution for which to reset cache.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you
        /// can specify.</p>
        pub fn distribution_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_name(inp);
            self
        }
        /// <p>The name of the distribution for which to reset cache.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you
        /// can specify.</p>
        pub fn set_distribution_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendContactMethodVerification`.
    ///
    /// <p>Sends a verification request to an email contact method to ensure it's owned by the
    /// requester. SMS contact methods don't need to be verified.</p>
    /// <p>A contact method is used to send you notifications about your Amazon Lightsail resources.
    /// You can add one email address and one mobile phone number contact method in each AWS Region.
    /// However, SMS text messaging is not supported in some AWS Regions, and SMS text messages
    /// cannot be sent to some countries/regions. For more information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in Amazon Lightsail</a>.</p>
    /// <p>A verification request is sent to the contact method when you initially create it. Use
    /// this action to send another verification request if a previous verification request was
    /// deleted, or has expired.</p>
    /// <important>
    /// <p>Notifications are not sent to an email contact method until after it is verified, and
    /// confirmed as valid.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct SendContactMethodVerification<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_contact_method_verification_input::Builder,
    }
    impl<C, M, R> SendContactMethodVerification<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendContactMethodVerification`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendContactMethodVerificationOutput,
            aws_smithy_http::result::SdkError<crate::error::SendContactMethodVerificationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendContactMethodVerificationInputOperationOutputAlias,
                crate::output::SendContactMethodVerificationOutput,
                crate::error::SendContactMethodVerificationError,
                crate::input::SendContactMethodVerificationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The protocol to verify, such as <code>Email</code> or <code>SMS</code> (text
        /// messaging).</p>
        pub fn protocol(mut self, inp: crate::model::ContactMethodVerificationProtocol) -> Self {
            self.inner = self.inner.protocol(inp);
            self
        }
        /// <p>The protocol to verify, such as <code>Email</code> or <code>SMS</code> (text
        /// messaging).</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::ContactMethodVerificationProtocol>,
        ) -> Self {
            self.inner = self.inner.set_protocol(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetIpAddressType`.
    ///
    /// <p>Sets the IP address type for an Amazon Lightsail resource.</p>
    ///
    /// <p>Use this action to enable dual-stack for a resource, which enables IPv4 and IPv6 for the
    /// specified resource. Alternately, you can use this action to disable dual-stack, and enable
    /// IPv4 only.</p>
    #[derive(std::fmt::Debug)]
    pub struct SetIpAddressType<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_ip_address_type_input::Builder,
    }
    impl<C, M, R> SetIpAddressType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetIpAddressType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetIpAddressTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::SetIpAddressTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetIpAddressTypeInputOperationOutputAlias,
                crate::output::SetIpAddressTypeOutput,
                crate::error::SetIpAddressTypeError,
                crate::input::SetIpAddressTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The resource type.</p>
        /// <p>The possible values are <code>Distribution</code>, <code>Instance</code>, and
        /// <code>LoadBalancer</code>.</p>
        /// <note>
        /// <p>Distribution-related APIs are available only in the N. Virginia (<code>us-east-1</code>)
        /// AWS Region. Set your AWS Region configuration to <code>us-east-1</code> to create, view,
        /// or edit distributions.</p>
        /// </note>
        pub fn resource_type(mut self, inp: crate::model::ResourceType) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>The resource type.</p>
        /// <p>The possible values are <code>Distribution</code>, <code>Instance</code>, and
        /// <code>LoadBalancer</code>.</p>
        /// <note>
        /// <p>Distribution-related APIs are available only in the N. Virginia (<code>us-east-1</code>)
        /// AWS Region. Set your AWS Region configuration to <code>us-east-1</code> to create, view,
        /// or edit distributions.</p>
        /// </note>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The name of the resource for which to set the IP address type.</p>
        pub fn resource_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(inp);
            self
        }
        /// <p>The name of the resource for which to set the IP address type.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// <p>The IP address type to set for the specified resource.</p>
        ///
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for
        /// IPv4 and IPv6.</p>
        pub fn ip_address_type(mut self, inp: crate::model::IpAddressType) -> Self {
            self.inner = self.inner.ip_address_type(inp);
            self
        }
        /// <p>The IP address type to set for the specified resource.</p>
        ///
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for
        /// IPv4 and IPv6.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.inner = self.inner.set_ip_address_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SetResourceAccessForBucket`.
    ///
    /// <p>Sets the Amazon Lightsail resources that can access the specified Lightsail
    /// bucket.</p>
    ///
    /// <p>Lightsail buckets currently support setting access for Lightsail instances in the same
    /// AWS Region.</p>
    #[derive(std::fmt::Debug)]
    pub struct SetResourceAccessForBucket<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::set_resource_access_for_bucket_input::Builder,
    }
    impl<C, M, R> SetResourceAccessForBucket<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SetResourceAccessForBucket`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SetResourceAccessForBucketOutput,
            aws_smithy_http::result::SdkError<crate::error::SetResourceAccessForBucketError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SetResourceAccessForBucketInputOperationOutputAlias,
                crate::output::SetResourceAccessForBucketOutput,
                crate::error::SetResourceAccessForBucketError,
                crate::input::SetResourceAccessForBucketInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Lightsail instance for which to set bucket access. The instance must be
        /// in a running or stopped state.</p>
        pub fn resource_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(inp);
            self
        }
        /// <p>The name of the Lightsail instance for which to set bucket access. The instance must be
        /// in a running or stopped state.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// <p>The name of the bucket for which to set access to another Lightsail resource.</p>
        pub fn bucket_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket_name(inp);
            self
        }
        /// <p>The name of the bucket for which to set access to another Lightsail resource.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket_name(input);
            self
        }
        /// <p>The access setting.</p>
        ///
        /// <p>The following access settings are available:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>allow</code> - Allows access to the bucket and its objects.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deny</code> - Denies access to the bucket and its objects. Use this setting to
        /// remove access for a resource previously set to <code>allow</code>.</p>
        /// </li>
        /// </ul>
        pub fn access(mut self, inp: crate::model::ResourceBucketAccess) -> Self {
            self.inner = self.inner.access(inp);
            self
        }
        /// <p>The access setting.</p>
        ///
        /// <p>The following access settings are available:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>allow</code> - Allows access to the bucket and its objects.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>deny</code> - Denies access to the bucket and its objects. Use this setting to
        /// remove access for a resource previously set to <code>allow</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_access(
            mut self,
            input: std::option::Option<crate::model::ResourceBucketAccess>,
        ) -> Self {
            self.inner = self.inner.set_access(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartInstance`.
    ///
    /// <p>Starts a specific Amazon Lightsail instance from a stopped state. To restart an instance,
    /// use the <code>reboot instance</code> operation.</p>
    /// <note>
    /// <p>When you start a stopped instance, Lightsail assigns a new public IP address to the
    /// instance. To use the same IP address after stopping and starting an instance, create a
    /// static IP address and attach it to the instance. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/lightsail-create-static-ip">Amazon Lightsail Developer Guide</a>.</p>
    /// </note>
    /// <p>The <code>start instance</code> operation supports tag-based access control via resource
    /// tags applied to the resource identified by <code>instance name</code>. For more information,
    /// see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_instance_input::Builder,
    }
    impl<C, M, R> StartInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::StartInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartInstanceInputOperationOutputAlias,
                crate::output::StartInstanceOutput,
                crate::error::StartInstanceError,
                crate::input::StartInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the instance (a virtual private server) to start.</p>
        pub fn instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_name(inp);
            self
        }
        /// <p>The name of the instance (a virtual private server) to start.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartRelationalDatabase`.
    ///
    /// <p>Starts a specific database from a stopped state in Amazon Lightsail. To restart a database,
    /// use the <code>reboot relational database</code> operation.</p>
    /// <p>The <code>start relational database</code> operation supports tag-based access control via
    /// resource tags applied to the resource identified by relationalDatabaseName. For more
    /// information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartRelationalDatabase<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_relational_database_input::Builder,
    }
    impl<C, M, R> StartRelationalDatabase<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartRelationalDatabase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartRelationalDatabaseOutput,
            aws_smithy_http::result::SdkError<crate::error::StartRelationalDatabaseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartRelationalDatabaseInputOperationOutputAlias,
                crate::output::StartRelationalDatabaseOutput,
                crate::error::StartRelationalDatabaseError,
                crate::input::StartRelationalDatabaseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of your database to start.</p>
        pub fn relational_database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.relational_database_name(inp);
            self
        }
        /// <p>The name of your database to start.</p>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopInstance`.
    ///
    /// <p>Stops a specific Amazon Lightsail instance that is currently running.</p>
    /// <note>
    /// <p>When you start a stopped instance, Lightsail assigns a new public IP address to the
    /// instance. To use the same IP address after stopping and starting an instance, create a
    /// static IP address and attach it to the instance. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/lightsail-create-static-ip">Amazon Lightsail Developer Guide</a>.</p>
    /// </note>
    /// <p>The <code>stop instance</code> operation supports tag-based access control via resource
    /// tags applied to the resource identified by <code>instance name</code>. For more information,
    /// see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_instance_input::Builder,
    }
    impl<C, M, R> StopInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::StopInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopInstanceInputOperationOutputAlias,
                crate::output::StopInstanceOutput,
                crate::error::StopInstanceError,
                crate::input::StopInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the instance (a virtual private server) to stop.</p>
        pub fn instance_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_name(inp);
            self
        }
        /// <p>The name of the instance (a virtual private server) to stop.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_name(input);
            self
        }
        /// <p>When set to <code>True</code>, forces a Lightsail instance that is stuck in a
        /// <code>stopping</code> state to stop.</p>
        /// <important>
        /// <p>Only use the <code>force</code> parameter if your instance is stuck in the
        /// <code>stopping</code> state. In any other state, your instance should stop normally
        /// without adding this parameter to your API request.</p>
        /// </important>
        pub fn force(mut self, inp: bool) -> Self {
            self.inner = self.inner.force(inp);
            self
        }
        /// <p>When set to <code>True</code>, forces a Lightsail instance that is stuck in a
        /// <code>stopping</code> state to stop.</p>
        /// <important>
        /// <p>Only use the <code>force</code> parameter if your instance is stuck in the
        /// <code>stopping</code> state. In any other state, your instance should stop normally
        /// without adding this parameter to your API request.</p>
        /// </important>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopRelationalDatabase`.
    ///
    /// <p>Stops a specific database that is currently running in Amazon Lightsail.</p>
    /// <p>The <code>stop relational database</code> operation supports tag-based access control via
    /// resource tags applied to the resource identified by relationalDatabaseName. For more
    /// information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopRelationalDatabase<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_relational_database_input::Builder,
    }
    impl<C, M, R> StopRelationalDatabase<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopRelationalDatabase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopRelationalDatabaseOutput,
            aws_smithy_http::result::SdkError<crate::error::StopRelationalDatabaseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopRelationalDatabaseInputOperationOutputAlias,
                crate::output::StopRelationalDatabaseOutput,
                crate::error::StopRelationalDatabaseError,
                crate::input::StopRelationalDatabaseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of your database to stop.</p>
        pub fn relational_database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.relational_database_name(inp);
            self
        }
        /// <p>The name of your database to stop.</p>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_name(input);
            self
        }
        /// <p>The name of your new database snapshot to be created before stopping your database.</p>
        pub fn relational_database_snapshot_name(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.relational_database_snapshot_name(inp);
            self
        }
        /// <p>The name of your new database snapshot to be created before stopping your database.</p>
        pub fn set_relational_database_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_snapshot_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds one or more tags to the specified Amazon Lightsail resource. Each resource can have a
    /// maximum of 50 tags. Each tag consists of a key and an optional value. Tag keys must be unique
    /// per resource. For more information about tags, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
    /// <p>The <code>tag resource</code> operation supports tag-based access control via request tags
    /// and resource tags applied to the resource identified by <code>resource name</code>. For more
    /// information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource to which you are adding tags.</p>
        pub fn resource_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(inp);
            self
        }
        /// <p>The name of the resource to which you are adding tags.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which you want to add a tag.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource to which you want to add a tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag key and optional value.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tag key and optional value.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestAlarm`.
    ///
    /// <p>Tests an alarm by displaying a banner on the Amazon Lightsail console. If a notification
    /// trigger is configured for the specified alarm, the test also sends a notification to the
    /// notification protocol (<code>Email</code> and/or <code>SMS</code>) configured for the
    /// alarm.</p>
    /// <p>An alarm is used to monitor a single metric for one of your resources. When a metric
    /// condition is met, the alarm can notify you by email, SMS text message, and a banner displayed
    /// on the Amazon Lightsail console. For more information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms">Alarms
    /// in Amazon Lightsail</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct TestAlarm<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::test_alarm_input::Builder,
    }
    impl<C, M, R> TestAlarm<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TestAlarm`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestAlarmOutput,
            aws_smithy_http::result::SdkError<crate::error::TestAlarmError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TestAlarmInputOperationOutputAlias,
                crate::output::TestAlarmOutput,
                crate::error::TestAlarmError,
                crate::input::TestAlarmInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the alarm to test.</p>
        pub fn alarm_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.alarm_name(inp);
            self
        }
        /// <p>The name of the alarm to test.</p>
        pub fn set_alarm_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_alarm_name(input);
            self
        }
        /// <p>The alarm state to test.</p>
        /// <p>An alarm has the following possible states that can be tested:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALARM</code> - The metric is outside of the defined threshold.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not
        /// available, or not enough data is available for the metric to determine the alarm
        /// state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OK</code> - The metric is within the defined threshold.</p>
        /// </li>
        /// </ul>
        pub fn state(mut self, inp: crate::model::AlarmState) -> Self {
            self.inner = self.inner.state(inp);
            self
        }
        /// <p>The alarm state to test.</p>
        /// <p>An alarm has the following possible states that can be tested:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ALARM</code> - The metric is outside of the defined threshold.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not
        /// available, or not enough data is available for the metric to determine the alarm
        /// state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>OK</code> - The metric is within the defined threshold.</p>
        /// </li>
        /// </ul>
        pub fn set_state(mut self, input: std::option::Option<crate::model::AlarmState>) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UnpeerVpc`.
    ///
    /// <p>Unpeers the Lightsail VPC from the user's default VPC.</p>
    #[derive(std::fmt::Debug)]
    pub struct UnpeerVpc<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::unpeer_vpc_input::Builder,
    }
    impl<C, M, R> UnpeerVpc<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UnpeerVpc`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UnpeerVpcOutput,
            aws_smithy_http::result::SdkError<crate::error::UnpeerVpcError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UnpeerVpcInputOperationOutputAlias,
                crate::output::UnpeerVpcOutput,
                crate::error::UnpeerVpcError,
                crate::input::UnpeerVpcInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Deletes the specified set of tag keys and their values from the specified Amazon Lightsail
    /// resource.</p>
    /// <p>The <code>untag resource</code> operation supports tag-based access control via request
    /// tags and resource tags applied to the resource identified by <code>resource name</code>. For
    /// more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the resource from which you are removing a tag.</p>
        pub fn resource_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(inp);
            self
        }
        /// <p>The name of the resource from which you are removing a tag.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which you want to remove a tag.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource from which you want to remove a tag.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys to delete from the specified resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag keys to delete from the specified resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBucket`.
    ///
    /// <p>Updates an existing Amazon Lightsail bucket.</p>
    ///
    /// <p>Use this action to update the configuration of an existing bucket, such as versioning,
    /// public accessibility, and the AWS accounts that can access the bucket.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateBucket<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_bucket_input::Builder,
    }
    impl<C, M, R> UpdateBucket<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBucket`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBucketOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBucketError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBucketInputOperationOutputAlias,
                crate::output::UpdateBucketOutput,
                crate::error::UpdateBucketError,
                crate::input::UpdateBucketInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket to update.</p>
        pub fn bucket_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket_name(inp);
            self
        }
        /// <p>The name of the bucket to update.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket_name(input);
            self
        }
        /// <p>An object that sets the public accessibility of objects in the specified bucket.</p>
        pub fn access_rules(mut self, inp: crate::model::AccessRules) -> Self {
            self.inner = self.inner.access_rules(inp);
            self
        }
        /// <p>An object that sets the public accessibility of objects in the specified bucket.</p>
        pub fn set_access_rules(
            mut self,
            input: std::option::Option<crate::model::AccessRules>,
        ) -> Self {
            self.inner = self.inner.set_access_rules(input);
            self
        }
        /// <p>Specifies whether to enable or suspend versioning of objects in the bucket.</p>
        ///
        /// <p>The following options can be specified:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Enabled</code> - Enables versioning of objects in the specified bucket.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Suspended</code> - Suspends versioning of objects in the specified bucket.
        /// Existing object versions are retained.</p>
        /// </li>
        /// </ul>
        pub fn versioning(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.versioning(inp);
            self
        }
        /// <p>Specifies whether to enable or suspend versioning of objects in the bucket.</p>
        ///
        /// <p>The following options can be specified:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Enabled</code> - Enables versioning of objects in the specified bucket.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Suspended</code> - Suspends versioning of objects in the specified bucket.
        /// Existing object versions are retained.</p>
        /// </li>
        /// </ul>
        pub fn set_versioning(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_versioning(input);
            self
        }
        /// Appends an item to `readonlyAccessAccounts`.
        ///
        /// To override the contents of this collection use [`set_readonly_access_accounts`](Self::set_readonly_access_accounts).
        ///
        /// <p>An array of strings to specify the AWS account IDs that can access the bucket.</p>
        ///
        /// <p>You can give a maximum of 10 AWS accounts access to a bucket.</p>
        pub fn readonly_access_accounts(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.readonly_access_accounts(inp);
            self
        }
        /// <p>An array of strings to specify the AWS account IDs that can access the bucket.</p>
        ///
        /// <p>You can give a maximum of 10 AWS accounts access to a bucket.</p>
        pub fn set_readonly_access_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_readonly_access_accounts(input);
            self
        }
        /// <p>An object that describes the access log configuration for the bucket.</p>
        pub fn access_log_config(mut self, inp: crate::model::BucketAccessLogConfig) -> Self {
            self.inner = self.inner.access_log_config(inp);
            self
        }
        /// <p>An object that describes the access log configuration for the bucket.</p>
        pub fn set_access_log_config(
            mut self,
            input: std::option::Option<crate::model::BucketAccessLogConfig>,
        ) -> Self {
            self.inner = self.inner.set_access_log_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBucketBundle`.
    ///
    /// <p>Updates the bundle, or storage plan, of an existing Amazon Lightsail bucket.</p>
    ///
    /// <p>A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a
    /// bucket. You can update a bucket's bundle only one time within a monthly AWS billing cycle. To
    /// determine if you can update a bucket's bundle, use the <a>GetBuckets</a> action.
    /// The <code>ableToUpdateBundle</code> parameter in the response will indicate whether you can
    /// currently update a bucket's bundle.</p>
    ///
    /// <p>Update a bucket's bundle if it's consistently going over its storage space or data
    /// transfer quota, or if a bucket's usage is consistently in the lower range of its storage space
    /// or data transfer quota. Due to the unpredictable usage fluctuations that a bucket might
    /// experience, we strongly recommend that you update a bucket's bundle only as a long-term
    /// strategy, instead of as a short-term, monthly cost-cutting measure. Choose a bucket bundle
    /// that will provide the bucket with ample storage space and data transfer for a long time to
    /// come.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateBucketBundle<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_bucket_bundle_input::Builder,
    }
    impl<C, M, R> UpdateBucketBundle<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBucketBundle`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBucketBundleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBucketBundleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBucketBundleInputOperationOutputAlias,
                crate::output::UpdateBucketBundleOutput,
                crate::error::UpdateBucketBundleError,
                crate::input::UpdateBucketBundleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the bucket for which to update the bundle.</p>
        pub fn bucket_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket_name(inp);
            self
        }
        /// <p>The name of the bucket for which to update the bundle.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket_name(input);
            self
        }
        /// <p>The ID of the new bundle to apply to the bucket.</p>
        ///
        /// <p>Use the <a>GetBucketBundles</a> action to get a list of bundle IDs that you can
        /// specify.</p>
        pub fn bundle_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bundle_id(inp);
            self
        }
        /// <p>The ID of the new bundle to apply to the bucket.</p>
        ///
        /// <p>Use the <a>GetBucketBundles</a> action to get a list of bundle IDs that you can
        /// specify.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bundle_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContainerService`.
    ///
    /// <p>Updates the configuration of your Amazon Lightsail container service, such as its power,
    /// scale, and public domain names.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateContainerService<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_container_service_input::Builder,
    }
    impl<C, M, R> UpdateContainerService<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContainerService`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContainerServiceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContainerServiceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContainerServiceInputOperationOutputAlias,
                crate::output::UpdateContainerServiceOutput,
                crate::error::UpdateContainerServiceError,
                crate::input::UpdateContainerServiceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the container service to update.</p>
        pub fn service_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_name(inp);
            self
        }
        /// <p>The name of the container service to update.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service_name(input);
            self
        }
        /// <p>The power for the container service.</p>
        ///
        /// <p>The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the
        /// container service. The <code>power</code> and <code>scale</code> of a container service makes
        /// up its configured capacity. To determine the monthly price of your container service, multiply
        /// the base price of the <code>power</code> with the <code>scale</code> (the number of nodes) of
        /// the service.</p>
        ///
        /// <p>Use the <code>GetContainerServicePowers</code> action to view the specifications of each
        /// power option.</p>
        pub fn power(mut self, inp: crate::model::ContainerServicePowerName) -> Self {
            self.inner = self.inner.power(inp);
            self
        }
        /// <p>The power for the container service.</p>
        ///
        /// <p>The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the
        /// container service. The <code>power</code> and <code>scale</code> of a container service makes
        /// up its configured capacity. To determine the monthly price of your container service, multiply
        /// the base price of the <code>power</code> with the <code>scale</code> (the number of nodes) of
        /// the service.</p>
        ///
        /// <p>Use the <code>GetContainerServicePowers</code> action to view the specifications of each
        /// power option.</p>
        pub fn set_power(
            mut self,
            input: std::option::Option<crate::model::ContainerServicePowerName>,
        ) -> Self {
            self.inner = self.inner.set_power(input);
            self
        }
        /// <p>The scale for the container service.</p>
        ///
        /// <p>The scale specifies the allocated compute nodes of the container service. The
        /// <code>power</code> and <code>scale</code> of a container service makes up its configured
        /// capacity. To determine the monthly price of your container service, multiply the base price of
        /// the <code>power</code> with the <code>scale</code> (the number of nodes) of the
        /// service.</p>
        pub fn scale(mut self, inp: i32) -> Self {
            self.inner = self.inner.scale(inp);
            self
        }
        /// <p>The scale for the container service.</p>
        ///
        /// <p>The scale specifies the allocated compute nodes of the container service. The
        /// <code>power</code> and <code>scale</code> of a container service makes up its configured
        /// capacity. To determine the monthly price of your container service, multiply the base price of
        /// the <code>power</code> with the <code>scale</code> (the number of nodes) of the
        /// service.</p>
        pub fn set_scale(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_scale(input);
            self
        }
        /// <p>A Boolean value to indicate whether the container service is disabled.</p>
        pub fn is_disabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.is_disabled(inp);
            self
        }
        /// <p>A Boolean value to indicate whether the container service is disabled.</p>
        pub fn set_is_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_disabled(input);
            self
        }
        /// Adds a key-value pair to `publicDomainNames`.
        ///
        /// To override the contents of this collection use [`set_public_domain_names`](Self::set_public_domain_names).
        ///
        /// <p>The public domain names to use with the container service, such as
        /// <code>example.com</code> and <code>www.example.com</code>.</p>
        ///
        /// <p>You can specify up to four public domain names for a container service. The domain names
        /// that you specify are used when you create a deployment with a container configured as the
        /// public endpoint of your container service.</p>
        ///
        /// <p>If you don't specify public domain names, then you can use the default domain of the
        /// container service.</p>
        ///
        /// <important>
        /// <p>You must create and validate an SSL/TLS certificate before you can use public domain
        /// names with your container service. Use the <code>CreateCertificate</code> action to create a
        /// certificate for the public domain names you want to use with your container service.</p>
        /// </important>
        ///
        /// <p>You can specify public domain names using a string to array map as shown in the example
        /// later on this page.</p>
        pub fn public_domain_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.public_domain_names(k, v);
            self
        }
        /// <p>The public domain names to use with the container service, such as
        /// <code>example.com</code> and <code>www.example.com</code>.</p>
        ///
        /// <p>You can specify up to four public domain names for a container service. The domain names
        /// that you specify are used when you create a deployment with a container configured as the
        /// public endpoint of your container service.</p>
        ///
        /// <p>If you don't specify public domain names, then you can use the default domain of the
        /// container service.</p>
        ///
        /// <important>
        /// <p>You must create and validate an SSL/TLS certificate before you can use public domain
        /// names with your container service. Use the <code>CreateCertificate</code> action to create a
        /// certificate for the public domain names you want to use with your container service.</p>
        /// </important>
        ///
        /// <p>You can specify public domain names using a string to array map as shown in the example
        /// later on this page.</p>
        pub fn set_public_domain_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.inner = self.inner.set_public_domain_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDistribution`.
    ///
    /// <p>Updates an existing Amazon Lightsail content delivery network (CDN) distribution.</p>
    /// <p>Use this action to update the configuration of your existing distribution.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDistribution<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_distribution_input::Builder,
    }
    impl<C, M, R> UpdateDistribution<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDistribution`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDistributionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDistributionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDistributionInputOperationOutputAlias,
                crate::output::UpdateDistributionOutput,
                crate::error::UpdateDistributionError,
                crate::input::UpdateDistributionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the distribution to update.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you
        /// can specify.</p>
        pub fn distribution_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_name(inp);
            self
        }
        /// <p>The name of the distribution to update.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you
        /// can specify.</p>
        pub fn set_distribution_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_name(input);
            self
        }
        /// <p>An object that describes the origin resource for the distribution, such as a Lightsail
        /// instance or load balancer.</p>
        /// <p>The distribution pulls, caches, and serves content from the origin.</p>
        pub fn origin(mut self, inp: crate::model::InputOrigin) -> Self {
            self.inner = self.inner.origin(inp);
            self
        }
        /// <p>An object that describes the origin resource for the distribution, such as a Lightsail
        /// instance or load balancer.</p>
        /// <p>The distribution pulls, caches, and serves content from the origin.</p>
        pub fn set_origin(mut self, input: std::option::Option<crate::model::InputOrigin>) -> Self {
            self.inner = self.inner.set_origin(input);
            self
        }
        /// <p>An object that describes the default cache behavior for the distribution.</p>
        pub fn default_cache_behavior(mut self, inp: crate::model::CacheBehavior) -> Self {
            self.inner = self.inner.default_cache_behavior(inp);
            self
        }
        /// <p>An object that describes the default cache behavior for the distribution.</p>
        pub fn set_default_cache_behavior(
            mut self,
            input: std::option::Option<crate::model::CacheBehavior>,
        ) -> Self {
            self.inner = self.inner.set_default_cache_behavior(input);
            self
        }
        /// <p>An object that describes the cache behavior settings for the distribution.</p>
        /// <note>
        /// <p>The <code>cacheBehaviorSettings</code> specified in your
        /// <code>UpdateDistributionRequest</code> will replace your distribution's existing
        /// settings.</p>
        /// </note>
        pub fn cache_behavior_settings(mut self, inp: crate::model::CacheSettings) -> Self {
            self.inner = self.inner.cache_behavior_settings(inp);
            self
        }
        /// <p>An object that describes the cache behavior settings for the distribution.</p>
        /// <note>
        /// <p>The <code>cacheBehaviorSettings</code> specified in your
        /// <code>UpdateDistributionRequest</code> will replace your distribution's existing
        /// settings.</p>
        /// </note>
        pub fn set_cache_behavior_settings(
            mut self,
            input: std::option::Option<crate::model::CacheSettings>,
        ) -> Self {
            self.inner = self.inner.set_cache_behavior_settings(input);
            self
        }
        /// Appends an item to `cacheBehaviors`.
        ///
        /// To override the contents of this collection use [`set_cache_behaviors`](Self::set_cache_behaviors).
        ///
        /// <p>An array of objects that describe the per-path cache behavior for the distribution.</p>
        pub fn cache_behaviors(
            mut self,
            inp: impl Into<crate::model::CacheBehaviorPerPath>,
        ) -> Self {
            self.inner = self.inner.cache_behaviors(inp);
            self
        }
        /// <p>An array of objects that describe the per-path cache behavior for the distribution.</p>
        pub fn set_cache_behaviors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CacheBehaviorPerPath>>,
        ) -> Self {
            self.inner = self.inner.set_cache_behaviors(input);
            self
        }
        /// <p>Indicates whether to enable the distribution.</p>
        pub fn is_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.is_enabled(inp);
            self
        }
        /// <p>Indicates whether to enable the distribution.</p>
        pub fn set_is_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDistributionBundle`.
    ///
    /// <p>Updates the bundle of your Amazon Lightsail content delivery network (CDN)
    /// distribution.</p>
    /// <p>A distribution bundle specifies the monthly network transfer quota and monthly cost of
    /// your dsitribution.</p>
    /// <p>Update your distribution's bundle if your distribution is going over its monthly network
    /// transfer quota and is incurring an overage fee.</p>
    /// <p>You can update your distribution's bundle only one time within your monthly AWS billing
    /// cycle. To determine if you can update your distribution's bundle, use the
    /// <code>GetDistributions</code> action. The <code>ableToUpdateBundle</code> parameter in the
    /// result will indicate whether you can currently update your distribution's bundle.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDistributionBundle<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_distribution_bundle_input::Builder,
    }
    impl<C, M, R> UpdateDistributionBundle<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDistributionBundle`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDistributionBundleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDistributionBundleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDistributionBundleInputOperationOutputAlias,
                crate::output::UpdateDistributionBundleOutput,
                crate::error::UpdateDistributionBundleError,
                crate::input::UpdateDistributionBundleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the distribution for which to update the bundle.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you
        /// can specify.</p>
        pub fn distribution_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.distribution_name(inp);
            self
        }
        /// <p>The name of the distribution for which to update the bundle.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you
        /// can specify.</p>
        pub fn set_distribution_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_distribution_name(input);
            self
        }
        /// <p>The bundle ID of the new bundle to apply to your distribution.</p>
        /// <p>Use the <code>GetDistributionBundles</code> action to get a list of distribution bundle
        /// IDs that you can specify.</p>
        pub fn bundle_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bundle_id(inp);
            self
        }
        /// <p>The bundle ID of the new bundle to apply to your distribution.</p>
        /// <p>Use the <code>GetDistributionBundles</code> action to get a list of distribution bundle
        /// IDs that you can specify.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bundle_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDomainEntry`.
    ///
    /// <p>Updates a domain recordset after it is created.</p>
    /// <p>The <code>update domain entry</code> operation supports tag-based access control via
    /// resource tags applied to the resource identified by <code>domain name</code>. For more
    /// information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDomainEntry<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_domain_entry_input::Builder,
    }
    impl<C, M, R> UpdateDomainEntry<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDomainEntry`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDomainEntryOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDomainEntryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDomainEntryInputOperationOutputAlias,
                crate::output::UpdateDomainEntryOutput,
                crate::error::UpdateDomainEntryError,
                crate::input::UpdateDomainEntryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the domain recordset to update.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The name of the domain recordset to update.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>An array of key-value pairs containing information about the domain entry.</p>
        pub fn domain_entry(mut self, inp: crate::model::DomainEntry) -> Self {
            self.inner = self.inner.domain_entry(inp);
            self
        }
        /// <p>An array of key-value pairs containing information about the domain entry.</p>
        pub fn set_domain_entry(
            mut self,
            input: std::option::Option<crate::model::DomainEntry>,
        ) -> Self {
            self.inner = self.inner.set_domain_entry(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLoadBalancerAttribute`.
    ///
    /// <p>Updates the specified attribute for a load balancer. You can only update one attribute at
    /// a time.</p>
    /// <p>The <code>update load balancer attribute</code> operation supports tag-based access
    /// control via resource tags applied to the resource identified by <code>load balancer
    /// name</code>. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateLoadBalancerAttribute<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_load_balancer_attribute_input::Builder,
    }
    impl<C, M, R> UpdateLoadBalancerAttribute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLoadBalancerAttribute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLoadBalancerAttributeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLoadBalancerAttributeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLoadBalancerAttributeInputOperationOutputAlias,
                crate::output::UpdateLoadBalancerAttributeOutput,
                crate::error::UpdateLoadBalancerAttributeError,
                crate::input::UpdateLoadBalancerAttributeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the load balancer that you want to modify (e.g.,
        /// <code>my-load-balancer</code>.</p>
        pub fn load_balancer_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.load_balancer_name(inp);
            self
        }
        /// <p>The name of the load balancer that you want to modify (e.g.,
        /// <code>my-load-balancer</code>.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_load_balancer_name(input);
            self
        }
        /// <p>The name of the attribute you want to update. Valid values are below.</p>
        pub fn attribute_name(mut self, inp: crate::model::LoadBalancerAttributeName) -> Self {
            self.inner = self.inner.attribute_name(inp);
            self
        }
        /// <p>The name of the attribute you want to update. Valid values are below.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerAttributeName>,
        ) -> Self {
            self.inner = self.inner.set_attribute_name(input);
            self
        }
        /// <p>The value that you want to specify for the attribute name.</p>
        pub fn attribute_value(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_value(inp);
            self
        }
        /// <p>The value that you want to specify for the attribute name.</p>
        pub fn set_attribute_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attribute_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRelationalDatabase`.
    ///
    /// <p>Allows the update of one or more attributes of a database in Amazon Lightsail.</p>
    /// <p>Updates are applied immediately, or in cases where the updates could result in an outage,
    /// are applied during the database's predefined maintenance window.</p>
    /// <p>The <code>update relational database</code> operation supports tag-based access control
    /// via resource tags applied to the resource identified by relationalDatabaseName. For more
    /// information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRelationalDatabase<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_relational_database_input::Builder,
    }
    impl<C, M, R> UpdateRelationalDatabase<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRelationalDatabase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRelationalDatabaseOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRelationalDatabaseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRelationalDatabaseInputOperationOutputAlias,
                crate::output::UpdateRelationalDatabaseOutput,
                crate::error::UpdateRelationalDatabaseError,
                crate::input::UpdateRelationalDatabaseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of your Lightsail database resource to update.</p>
        pub fn relational_database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.relational_database_name(inp);
            self
        }
        /// <p>The name of your Lightsail database resource to update.</p>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_name(input);
            self
        }
        /// <p>The password for the master user. The password can include any printable ASCII character
        /// except "/", """, or "@".</p>
        /// <p>My<b>SQL</b>
        /// </p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        /// <p>
        /// <b>PostgreSQL</b>
        /// </p>
        /// <p>Constraints: Must contain from 8 to 128 characters.</p>
        pub fn master_user_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_user_password(inp);
            self
        }
        /// <p>The password for the master user. The password can include any printable ASCII character
        /// except "/", """, or "@".</p>
        /// <p>My<b>SQL</b>
        /// </p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        /// <p>
        /// <b>PostgreSQL</b>
        /// </p>
        /// <p>Constraints: Must contain from 8 to 128 characters.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_user_password(input);
            self
        }
        /// <p>When <code>true</code>, the master user password is changed to a new strong password
        /// generated by Lightsail.</p>
        /// <p>Use the <code>get relational database master user password</code> operation to get the new
        /// password.</p>
        pub fn rotate_master_user_password(mut self, inp: bool) -> Self {
            self.inner = self.inner.rotate_master_user_password(inp);
            self
        }
        /// <p>When <code>true</code>, the master user password is changed to a new strong password
        /// generated by Lightsail.</p>
        /// <p>Use the <code>get relational database master user password</code> operation to get the new
        /// password.</p>
        pub fn set_rotate_master_user_password(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_rotate_master_user_password(input);
            self
        }
        /// <p>The daily time range during which automated backups are created for your database if
        /// automated backups are enabled.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the <code>hh24:mi-hh24:mi</code> format.</p>
        /// <p>Example: <code>16:00-16:30</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn preferred_backup_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_backup_window(inp);
            self
        }
        /// <p>The daily time range during which automated backups are created for your database if
        /// automated backups are enabled.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the <code>hh24:mi-hh24:mi</code> format.</p>
        /// <p>Example: <code>16:00-16:30</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Must not conflict with the preferred maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// </ul>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_backup_window(input);
            self
        }
        /// <p>The weekly time range during which system maintenance can occur on your database.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// AWS Region, occurring on a random day of the week.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.</p>
        /// </li>
        /// <li>
        /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Example: <code>Tue:17:00-Tue:17:30</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn preferred_maintenance_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_maintenance_window(inp);
            self
        }
        /// <p>The weekly time range during which system maintenance can occur on your database.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each
        /// AWS Region, occurring on a random day of the week.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.</p>
        /// </li>
        /// <li>
        /// <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// </li>
        /// <li>
        /// <p>Must be at least 30 minutes.</p>
        /// </li>
        /// <li>
        /// <p>Specified in Coordinated Universal Time (UTC).</p>
        /// </li>
        /// <li>
        /// <p>Example: <code>Tue:17:00-Tue:17:30</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>When <code>true</code>, enables automated backup retention for your database.</p>
        /// <p>Updates are applied during the next maintenance window because this can result in an
        /// outage.</p>
        pub fn enable_backup_retention(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_backup_retention(inp);
            self
        }
        /// <p>When <code>true</code>, enables automated backup retention for your database.</p>
        /// <p>Updates are applied during the next maintenance window because this can result in an
        /// outage.</p>
        pub fn set_enable_backup_retention(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_backup_retention(input);
            self
        }
        /// <p>When <code>true</code>, disables automated backup retention for your database.</p>
        /// <p>Disabling backup retention deletes all automated database backups. Before disabling this,
        /// you may want to create a snapshot of your database using the <code>create relational database
        /// snapshot</code> operation.</p>
        /// <p>Updates are applied during the next maintenance window because this can result in an
        /// outage.</p>
        pub fn disable_backup_retention(mut self, inp: bool) -> Self {
            self.inner = self.inner.disable_backup_retention(inp);
            self
        }
        /// <p>When <code>true</code>, disables automated backup retention for your database.</p>
        /// <p>Disabling backup retention deletes all automated database backups. Before disabling this,
        /// you may want to create a snapshot of your database using the <code>create relational database
        /// snapshot</code> operation.</p>
        /// <p>Updates are applied during the next maintenance window because this can result in an
        /// outage.</p>
        pub fn set_disable_backup_retention(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disable_backup_retention(input);
            self
        }
        /// <p>Specifies the accessibility options for your database. A value of <code>true</code>
        /// specifies a database that is available to resources outside of your Lightsail account. A
        /// value of <code>false</code> specifies a database that is available only to your Lightsail
        /// resources in the same region as your database.</p>
        pub fn publicly_accessible(mut self, inp: bool) -> Self {
            self.inner = self.inner.publicly_accessible(inp);
            self
        }
        /// <p>Specifies the accessibility options for your database. A value of <code>true</code>
        /// specifies a database that is available to resources outside of your Lightsail account. A
        /// value of <code>false</code> specifies a database that is available only to your Lightsail
        /// resources in the same region as your database.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publicly_accessible(input);
            self
        }
        /// <p>When <code>true</code>, applies changes immediately. When <code>false</code>, applies
        /// changes during the preferred maintenance window. Some changes may cause an outage.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn apply_immediately(mut self, inp: bool) -> Self {
            self.inner = self.inner.apply_immediately(inp);
            self
        }
        /// <p>When <code>true</code>, applies changes immediately. When <code>false</code>, applies
        /// changes during the preferred maintenance window. Some changes may cause an outage.</p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_apply_immediately(input);
            self
        }
        /// <p>Indicates the certificate that needs to be associated with the database.</p>
        pub fn ca_certificate_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ca_certificate_identifier(inp);
            self
        }
        /// <p>Indicates the certificate that needs to be associated with the database.</p>
        pub fn set_ca_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ca_certificate_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRelationalDatabaseParameters`.
    ///
    /// <p>Allows the update of one or more parameters of a database in Amazon Lightsail.</p>
    /// <p>Parameter updates don't cause outages; therefore, their application is not subject to the
    /// preferred maintenance window. However, there are two ways in which parameter updates are
    /// applied: <code>dynamic</code> or <code>pending-reboot</code>. Parameters marked with a
    /// <code>dynamic</code> apply type are applied immediately. Parameters marked with a
    /// <code>pending-reboot</code> apply type are applied only after the database is rebooted using
    /// the <code>reboot relational database</code> operation.</p>
    /// <p>The <code>update relational database parameters</code> operation supports tag-based access
    /// control via resource tags applied to the resource identified by relationalDatabaseName. For
    /// more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-controlling-access-using-tags">Amazon Lightsail Developer Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRelationalDatabaseParameters<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_relational_database_parameters_input::Builder,
    }
    impl<C, M, R> UpdateRelationalDatabaseParameters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRelationalDatabaseParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRelationalDatabaseParametersOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateRelationalDatabaseParametersError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRelationalDatabaseParametersInputOperationOutputAlias,
                crate::output::UpdateRelationalDatabaseParametersOutput,
                crate::error::UpdateRelationalDatabaseParametersError,
                crate::input::UpdateRelationalDatabaseParametersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of your database for which to update parameters.</p>
        pub fn relational_database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.relational_database_name(inp);
            self
        }
        /// <p>The name of your database for which to update parameters.</p>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_relational_database_name(input);
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The database parameters to update.</p>
        pub fn parameters(
            mut self,
            inp: impl Into<crate::model::RelationalDatabaseParameter>,
        ) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>The database parameters to update.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RelationalDatabaseParameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
