// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_allocate_static_ip_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AllocateStaticIpOutput, crate::error::AllocateStaticIpError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AllocateStaticIpError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AllocateStaticIpError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::AllocateStaticIpError {
            meta: generic,
            kind: crate::error::AllocateStaticIpErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AllocateStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::AllocateStaticIpError {
            meta: generic,
            kind: crate::error::AllocateStaticIpErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AllocateStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::AllocateStaticIpError {
            meta: generic,
            kind: crate::error::AllocateStaticIpErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AllocateStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::AllocateStaticIpError {
            meta: generic,
            kind: crate::error::AllocateStaticIpErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AllocateStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::AllocateStaticIpError {
            meta: generic,
            kind: crate::error::AllocateStaticIpErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AllocateStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::AllocateStaticIpError {
                meta: generic,
                kind: crate::error::AllocateStaticIpErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AllocateStaticIpError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::AllocateStaticIpError {
            meta: generic,
            kind: crate::error::AllocateStaticIpErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AllocateStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AllocateStaticIpError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_allocate_static_ip_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AllocateStaticIpOutput, crate::error::AllocateStaticIpError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::allocate_static_ip_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_allocate_static_ip(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AllocateStaticIpError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_certificate_to_distribution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AttachCertificateToDistributionOutput,
    crate::error::AttachCertificateToDistributionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AttachCertificateToDistributionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AttachCertificateToDistributionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::AttachCertificateToDistributionError {
            meta: generic,
            kind: crate::error::AttachCertificateToDistributionErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachCertificateToDistributionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::AttachCertificateToDistributionError {
            meta: generic,
            kind: crate::error::AttachCertificateToDistributionErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachCertificateToDistributionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::AttachCertificateToDistributionError {
            meta: generic,
            kind: crate::error::AttachCertificateToDistributionErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachCertificateToDistributionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::AttachCertificateToDistributionError {
            meta: generic,
            kind: crate::error::AttachCertificateToDistributionErrorKind::OperationFailureException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::operation_failure_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachCertificateToDistributionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ServiceException" => {
            crate::error::AttachCertificateToDistributionError {
                meta: generic,
                kind: crate::error::AttachCertificateToDistributionErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachCertificateToDistributionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::AttachCertificateToDistributionError {
            meta: generic,
            kind: crate::error::AttachCertificateToDistributionErrorKind::UnauthenticatedException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unauthenticated_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachCertificateToDistributionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::AttachCertificateToDistributionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_certificate_to_distribution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AttachCertificateToDistributionOutput,
    crate::error::AttachCertificateToDistributionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::attach_certificate_to_distribution_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_attach_certificate_to_distribution(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::AttachCertificateToDistributionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_disk_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AttachDiskOutput, crate::error::AttachDiskError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AttachDiskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AttachDiskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::AttachDiskError {
            meta: generic,
            kind: crate::error::AttachDiskErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::AttachDiskError {
            meta: generic,
            kind: crate::error::AttachDiskErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::AttachDiskError {
            meta: generic,
            kind: crate::error::AttachDiskErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::AttachDiskError {
            meta: generic,
            kind: crate::error::AttachDiskErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::AttachDiskError {
            meta: generic,
            kind: crate::error::AttachDiskErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::AttachDiskError {
                meta: generic,
                kind: crate::error::AttachDiskErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachDiskError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::AttachDiskError {
            meta: generic,
            kind: crate::error::AttachDiskErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AttachDiskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_disk_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AttachDiskOutput, crate::error::AttachDiskError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::attach_disk_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_attach_disk(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AttachDiskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_instances_to_load_balancer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AttachInstancesToLoadBalancerOutput,
    crate::error::AttachInstancesToLoadBalancerError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AttachInstancesToLoadBalancerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AttachInstancesToLoadBalancerError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::AttachInstancesToLoadBalancerError { meta: generic, kind: crate::error::AttachInstancesToLoadBalancerErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachInstancesToLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountSetupInProgressException" => crate::error::AttachInstancesToLoadBalancerError { meta: generic, kind: crate::error::AttachInstancesToLoadBalancerErrorKind::AccountSetupInProgressException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachInstancesToLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::AttachInstancesToLoadBalancerError { meta: generic, kind: crate::error::AttachInstancesToLoadBalancerErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachInstancesToLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotFoundException" => crate::error::AttachInstancesToLoadBalancerError { meta: generic, kind: crate::error::AttachInstancesToLoadBalancerErrorKind::NotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachInstancesToLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationFailureException" => crate::error::AttachInstancesToLoadBalancerError { meta: generic, kind: crate::error::AttachInstancesToLoadBalancerErrorKind::OperationFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachInstancesToLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::AttachInstancesToLoadBalancerError { meta: generic, kind: crate::error::AttachInstancesToLoadBalancerErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachInstancesToLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthenticatedException" => crate::error::AttachInstancesToLoadBalancerError { meta: generic, kind: crate::error::AttachInstancesToLoadBalancerErrorKind::UnauthenticatedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachInstancesToLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::AttachInstancesToLoadBalancerError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_instances_to_load_balancer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AttachInstancesToLoadBalancerOutput,
    crate::error::AttachInstancesToLoadBalancerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::attach_instances_to_load_balancer_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_attach_instances_to_load_balancer(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::AttachInstancesToLoadBalancerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_load_balancer_tls_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AttachLoadBalancerTlsCertificateOutput,
    crate::error::AttachLoadBalancerTlsCertificateError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AttachLoadBalancerTlsCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AttachLoadBalancerTlsCertificateError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::AttachLoadBalancerTlsCertificateError { meta: generic, kind: crate::error::AttachLoadBalancerTlsCertificateErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachLoadBalancerTlsCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountSetupInProgressException" => crate::error::AttachLoadBalancerTlsCertificateError { meta: generic, kind: crate::error::AttachLoadBalancerTlsCertificateErrorKind::AccountSetupInProgressException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachLoadBalancerTlsCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::AttachLoadBalancerTlsCertificateError { meta: generic, kind: crate::error::AttachLoadBalancerTlsCertificateErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachLoadBalancerTlsCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotFoundException" => crate::error::AttachLoadBalancerTlsCertificateError { meta: generic, kind: crate::error::AttachLoadBalancerTlsCertificateErrorKind::NotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachLoadBalancerTlsCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationFailureException" => crate::error::AttachLoadBalancerTlsCertificateError { meta: generic, kind: crate::error::AttachLoadBalancerTlsCertificateErrorKind::OperationFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachLoadBalancerTlsCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::AttachLoadBalancerTlsCertificateError { meta: generic, kind: crate::error::AttachLoadBalancerTlsCertificateErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachLoadBalancerTlsCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthenticatedException" => crate::error::AttachLoadBalancerTlsCertificateError { meta: generic, kind: crate::error::AttachLoadBalancerTlsCertificateErrorKind::UnauthenticatedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachLoadBalancerTlsCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::AttachLoadBalancerTlsCertificateError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_load_balancer_tls_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AttachLoadBalancerTlsCertificateOutput,
    crate::error::AttachLoadBalancerTlsCertificateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::attach_load_balancer_tls_certificate_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_attach_load_balancer_tls_certificate(response.body().as_ref(), output).map_err(crate::error::AttachLoadBalancerTlsCertificateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_static_ip_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AttachStaticIpOutput, crate::error::AttachStaticIpError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AttachStaticIpError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AttachStaticIpError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::AttachStaticIpError {
            meta: generic,
            kind: crate::error::AttachStaticIpErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::AttachStaticIpError {
            meta: generic,
            kind: crate::error::AttachStaticIpErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::AttachStaticIpError {
            meta: generic,
            kind: crate::error::AttachStaticIpErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::AttachStaticIpError {
            meta: generic,
            kind: crate::error::AttachStaticIpErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::AttachStaticIpError {
            meta: generic,
            kind: crate::error::AttachStaticIpErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::AttachStaticIpError {
                meta: generic,
                kind: crate::error::AttachStaticIpErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachStaticIpError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::AttachStaticIpError {
            meta: generic,
            kind: crate::error::AttachStaticIpErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AttachStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AttachStaticIpError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_attach_static_ip_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AttachStaticIpOutput, crate::error::AttachStaticIpError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::attach_static_ip_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_attach_static_ip(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AttachStaticIpError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_close_instance_public_ports_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CloseInstancePublicPortsOutput,
    crate::error::CloseInstancePublicPortsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CloseInstancePublicPortsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CloseInstancePublicPortsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CloseInstancePublicPortsError {
            meta: generic,
            kind: crate::error::CloseInstancePublicPortsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CloseInstancePublicPortsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::CloseInstancePublicPortsError {
            meta: generic,
            kind: crate::error::CloseInstancePublicPortsErrorKind::AccountSetupInProgressException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::account_setup_in_progress_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CloseInstancePublicPortsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidInputException" => crate::error::CloseInstancePublicPortsError {
            meta: generic,
            kind: crate::error::CloseInstancePublicPortsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CloseInstancePublicPortsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CloseInstancePublicPortsError {
            meta: generic,
            kind: crate::error::CloseInstancePublicPortsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CloseInstancePublicPortsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::CloseInstancePublicPortsError {
            meta: generic,
            kind: crate::error::CloseInstancePublicPortsErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CloseInstancePublicPortsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CloseInstancePublicPortsError {
                meta: generic,
                kind: crate::error::CloseInstancePublicPortsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CloseInstancePublicPortsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::CloseInstancePublicPortsError {
            meta: generic,
            kind: crate::error::CloseInstancePublicPortsErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CloseInstancePublicPortsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CloseInstancePublicPortsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_close_instance_public_ports_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CloseInstancePublicPortsOutput,
    crate::error::CloseInstancePublicPortsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::close_instance_public_ports_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_close_instance_public_ports(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CloseInstancePublicPortsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CopySnapshotOutput, crate::error::CopySnapshotError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CopySnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CopySnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CopySnapshotError {
            meta: generic,
            kind: crate::error::CopySnapshotErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CopySnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::CopySnapshotError {
            meta: generic,
            kind: crate::error::CopySnapshotErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CopySnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CopySnapshotError {
            meta: generic,
            kind: crate::error::CopySnapshotErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CopySnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CopySnapshotError {
            meta: generic,
            kind: crate::error::CopySnapshotErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CopySnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::CopySnapshotError {
            meta: generic,
            kind: crate::error::CopySnapshotErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CopySnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CopySnapshotError {
                meta: generic,
                kind: crate::error::CopySnapshotErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CopySnapshotError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::CopySnapshotError {
            meta: generic,
            kind: crate::error::CopySnapshotErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CopySnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CopySnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CopySnapshotOutput, crate::error::CopySnapshotError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::copy_snapshot_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_copy_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CopySnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_bucket_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateBucketOutput, crate::error::CreateBucketError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateBucketError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateBucketError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateBucketError {
            meta: generic,
            kind: crate::error::CreateBucketErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBucketError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateBucketError {
            meta: generic,
            kind: crate::error::CreateBucketErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBucketError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateBucketError {
                meta: generic,
                kind: crate::error::CreateBucketErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBucketError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::CreateBucketError {
            meta: generic,
            kind: crate::error::CreateBucketErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBucketError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateBucketError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_bucket_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateBucketOutput, crate::error::CreateBucketError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_bucket_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_bucket(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateBucketError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_bucket_access_key_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateBucketAccessKeyOutput,
    crate::error::CreateBucketAccessKeyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateBucketAccessKeyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateBucketAccessKeyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateBucketAccessKeyError {
            meta: generic,
            kind: crate::error::CreateBucketAccessKeyErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBucketAccessKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateBucketAccessKeyError {
            meta: generic,
            kind: crate::error::CreateBucketAccessKeyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBucketAccessKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CreateBucketAccessKeyError {
            meta: generic,
            kind: crate::error::CreateBucketAccessKeyErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBucketAccessKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateBucketAccessKeyError {
                meta: generic,
                kind: crate::error::CreateBucketAccessKeyErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBucketAccessKeyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::CreateBucketAccessKeyError {
            meta: generic,
            kind: crate::error::CreateBucketAccessKeyErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBucketAccessKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateBucketAccessKeyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_bucket_access_key_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateBucketAccessKeyOutput,
    crate::error::CreateBucketAccessKeyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_bucket_access_key_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_bucket_access_key(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateBucketAccessKeyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateCertificateOutput, crate::error::CreateCertificateError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateCertificateError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateCertificateError {
            meta: generic,
            kind: crate::error::CreateCertificateErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateCertificateError {
            meta: generic,
            kind: crate::error::CreateCertificateErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CreateCertificateError {
            meta: generic,
            kind: crate::error::CreateCertificateErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateCertificateError {
                meta: generic,
                kind: crate::error::CreateCertificateErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCertificateError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::CreateCertificateError {
            meta: generic,
            kind: crate::error::CreateCertificateErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateCertificateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateCertificateOutput, crate::error::CreateCertificateError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_certificate_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_certificate(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateCertificateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cloud_formation_stack_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCloudFormationStackOutput,
    crate::error::CreateCloudFormationStackError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateCloudFormationStackError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateCloudFormationStackError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateCloudFormationStackError {
            meta: generic,
            kind: crate::error::CreateCloudFormationStackErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCloudFormationStackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::CreateCloudFormationStackError {
            meta: generic,
            kind: crate::error::CreateCloudFormationStackErrorKind::AccountSetupInProgressException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::account_setup_in_progress_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCloudFormationStackError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidInputException" => crate::error::CreateCloudFormationStackError {
            meta: generic,
            kind: crate::error::CreateCloudFormationStackErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCloudFormationStackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CreateCloudFormationStackError {
            meta: generic,
            kind: crate::error::CreateCloudFormationStackErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCloudFormationStackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::CreateCloudFormationStackError {
            meta: generic,
            kind: crate::error::CreateCloudFormationStackErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCloudFormationStackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateCloudFormationStackError {
                meta: generic,
                kind: crate::error::CreateCloudFormationStackErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCloudFormationStackError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::CreateCloudFormationStackError {
            meta: generic,
            kind: crate::error::CreateCloudFormationStackErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCloudFormationStackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateCloudFormationStackError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cloud_formation_stack_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCloudFormationStackOutput,
    crate::error::CreateCloudFormationStackError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_cloud_formation_stack_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_cloud_formation_stack(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateCloudFormationStackError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_contact_method_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateContactMethodOutput,
    crate::error::CreateContactMethodError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateContactMethodError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateContactMethodError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateContactMethodError {
            meta: generic,
            kind: crate::error::CreateContactMethodErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContactMethodError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateContactMethodError {
            meta: generic,
            kind: crate::error::CreateContactMethodErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContactMethodError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CreateContactMethodError {
            meta: generic,
            kind: crate::error::CreateContactMethodErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContactMethodError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::CreateContactMethodError {
            meta: generic,
            kind: crate::error::CreateContactMethodErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContactMethodError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateContactMethodError {
                meta: generic,
                kind: crate::error::CreateContactMethodErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContactMethodError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::CreateContactMethodError {
            meta: generic,
            kind: crate::error::CreateContactMethodErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContactMethodError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateContactMethodError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_contact_method_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateContactMethodOutput,
    crate::error::CreateContactMethodError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_contact_method_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_contact_method(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateContactMethodError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_container_service_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateContainerServiceOutput,
    crate::error::CreateContainerServiceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateContainerServiceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateContainerServiceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateContainerServiceError {
            meta: generic,
            kind: crate::error::CreateContainerServiceErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContainerServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateContainerServiceError {
            meta: generic,
            kind: crate::error::CreateContainerServiceErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContainerServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CreateContainerServiceError {
            meta: generic,
            kind: crate::error::CreateContainerServiceErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContainerServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateContainerServiceError {
                meta: generic,
                kind: crate::error::CreateContainerServiceErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContainerServiceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::CreateContainerServiceError {
            meta: generic,
            kind: crate::error::CreateContainerServiceErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContainerServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateContainerServiceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_container_service_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateContainerServiceOutput,
    crate::error::CreateContainerServiceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_container_service_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_container_service(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateContainerServiceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_container_service_deployment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateContainerServiceDeploymentOutput,
    crate::error::CreateContainerServiceDeploymentError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateContainerServiceDeploymentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateContainerServiceDeploymentError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateContainerServiceDeploymentError {
            meta: generic,
            kind: crate::error::CreateContainerServiceDeploymentErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContainerServiceDeploymentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateContainerServiceDeploymentError {
            meta: generic,
            kind: crate::error::CreateContainerServiceDeploymentErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContainerServiceDeploymentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CreateContainerServiceDeploymentError {
            meta: generic,
            kind: crate::error::CreateContainerServiceDeploymentErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContainerServiceDeploymentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateContainerServiceDeploymentError {
                meta: generic,
                kind: crate::error::CreateContainerServiceDeploymentErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContainerServiceDeploymentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::CreateContainerServiceDeploymentError {
            meta: generic,
            kind: crate::error::CreateContainerServiceDeploymentErrorKind::UnauthenticatedException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unauthenticated_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContainerServiceDeploymentError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::CreateContainerServiceDeploymentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_container_service_deployment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateContainerServiceDeploymentOutput,
    crate::error::CreateContainerServiceDeploymentError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_container_service_deployment_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_create_container_service_deployment(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::CreateContainerServiceDeploymentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_container_service_registry_login_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateContainerServiceRegistryLoginOutput,
    crate::error::CreateContainerServiceRegistryLoginError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateContainerServiceRegistryLoginError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateContainerServiceRegistryLoginError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateContainerServiceRegistryLoginError {
            meta: generic,
            kind: crate::error::CreateContainerServiceRegistryLoginErrorKind::AccessDeniedException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::access_denied_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContainerServiceRegistryLoginError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidInputException" => crate::error::CreateContainerServiceRegistryLoginError {
            meta: generic,
            kind: crate::error::CreateContainerServiceRegistryLoginErrorKind::InvalidInputException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_input_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContainerServiceRegistryLoginError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NotFoundException" => crate::error::CreateContainerServiceRegistryLoginError {
            meta: generic,
            kind: crate::error::CreateContainerServiceRegistryLoginErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContainerServiceRegistryLoginError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateContainerServiceRegistryLoginError {
                meta: generic,
                kind: crate::error::CreateContainerServiceRegistryLoginErrorKind::ServiceException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output = crate::error::service_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContainerServiceRegistryLoginError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
            }
        }
        "UnauthenticatedException" => crate::error::CreateContainerServiceRegistryLoginError {
            meta: generic,
            kind:
                crate::error::CreateContainerServiceRegistryLoginErrorKind::UnauthenticatedException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::unauthenticated_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateContainerServiceRegistryLoginError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::CreateContainerServiceRegistryLoginError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_container_service_registry_login_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateContainerServiceRegistryLoginOutput,
    crate::error::CreateContainerServiceRegistryLoginError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_container_service_registry_login_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_container_service_registry_login(response.body().as_ref(), output).map_err(crate::error::CreateContainerServiceRegistryLoginError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_disk_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDiskOutput, crate::error::CreateDiskError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDiskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateDiskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateDiskError {
            meta: generic,
            kind: crate::error::CreateDiskErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::CreateDiskError {
            meta: generic,
            kind: crate::error::CreateDiskErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateDiskError {
            meta: generic,
            kind: crate::error::CreateDiskErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CreateDiskError {
            meta: generic,
            kind: crate::error::CreateDiskErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::CreateDiskError {
            meta: generic,
            kind: crate::error::CreateDiskErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateDiskError {
                meta: generic,
                kind: crate::error::CreateDiskErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDiskError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::CreateDiskError {
            meta: generic,
            kind: crate::error::CreateDiskErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDiskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_disk_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDiskOutput, crate::error::CreateDiskError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_disk_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_disk(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDiskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_disk_from_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDiskFromSnapshotOutput,
    crate::error::CreateDiskFromSnapshotError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDiskFromSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateDiskFromSnapshotError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateDiskFromSnapshotError {
            meta: generic,
            kind: crate::error::CreateDiskFromSnapshotErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDiskFromSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::CreateDiskFromSnapshotError {
            meta: generic,
            kind: crate::error::CreateDiskFromSnapshotErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDiskFromSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateDiskFromSnapshotError {
            meta: generic,
            kind: crate::error::CreateDiskFromSnapshotErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDiskFromSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CreateDiskFromSnapshotError {
            meta: generic,
            kind: crate::error::CreateDiskFromSnapshotErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDiskFromSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::CreateDiskFromSnapshotError {
            meta: generic,
            kind: crate::error::CreateDiskFromSnapshotErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDiskFromSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateDiskFromSnapshotError {
                meta: generic,
                kind: crate::error::CreateDiskFromSnapshotErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDiskFromSnapshotError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::CreateDiskFromSnapshotError {
            meta: generic,
            kind: crate::error::CreateDiskFromSnapshotErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDiskFromSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDiskFromSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_disk_from_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDiskFromSnapshotOutput,
    crate::error::CreateDiskFromSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_disk_from_snapshot_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_disk_from_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDiskFromSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_disk_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDiskSnapshotOutput,
    crate::error::CreateDiskSnapshotError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDiskSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateDiskSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateDiskSnapshotError {
            meta: generic,
            kind: crate::error::CreateDiskSnapshotErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDiskSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::CreateDiskSnapshotError {
            meta: generic,
            kind: crate::error::CreateDiskSnapshotErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDiskSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateDiskSnapshotError {
            meta: generic,
            kind: crate::error::CreateDiskSnapshotErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDiskSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CreateDiskSnapshotError {
            meta: generic,
            kind: crate::error::CreateDiskSnapshotErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDiskSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::CreateDiskSnapshotError {
            meta: generic,
            kind: crate::error::CreateDiskSnapshotErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDiskSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateDiskSnapshotError {
                meta: generic,
                kind: crate::error::CreateDiskSnapshotErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDiskSnapshotError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::CreateDiskSnapshotError {
            meta: generic,
            kind: crate::error::CreateDiskSnapshotErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDiskSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDiskSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_disk_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDiskSnapshotOutput,
    crate::error::CreateDiskSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_disk_snapshot_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_disk_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDiskSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_distribution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDistributionOutput,
    crate::error::CreateDistributionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDistributionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateDistributionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateDistributionError {
            meta: generic,
            kind: crate::error::CreateDistributionErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateDistributionError {
            meta: generic,
            kind: crate::error::CreateDistributionErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CreateDistributionError {
            meta: generic,
            kind: crate::error::CreateDistributionErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::CreateDistributionError {
            meta: generic,
            kind: crate::error::CreateDistributionErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateDistributionError {
                meta: generic,
                kind: crate::error::CreateDistributionErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::CreateDistributionError {
            meta: generic,
            kind: crate::error::CreateDistributionErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDistributionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDistributionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_distribution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDistributionOutput,
    crate::error::CreateDistributionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_distribution_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_distribution(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDistributionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_domain_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDomainOutput, crate::error::CreateDomainError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDomainError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateDomainError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateDomainError {
            meta: generic,
            kind: crate::error::CreateDomainErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::CreateDomainError {
            meta: generic,
            kind: crate::error::CreateDomainErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateDomainError {
            meta: generic,
            kind: crate::error::CreateDomainErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CreateDomainError {
            meta: generic,
            kind: crate::error::CreateDomainErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::CreateDomainError {
            meta: generic,
            kind: crate::error::CreateDomainErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateDomainError {
                meta: generic,
                kind: crate::error::CreateDomainErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::CreateDomainError {
            meta: generic,
            kind: crate::error::CreateDomainErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDomainError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_domain_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDomainOutput, crate::error::CreateDomainError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_domain_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_domain(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDomainError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_domain_entry_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDomainEntryOutput, crate::error::CreateDomainEntryError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDomainEntryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateDomainEntryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateDomainEntryError {
            meta: generic,
            kind: crate::error::CreateDomainEntryErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainEntryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::CreateDomainEntryError {
            meta: generic,
            kind: crate::error::CreateDomainEntryErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainEntryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateDomainEntryError {
            meta: generic,
            kind: crate::error::CreateDomainEntryErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainEntryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CreateDomainEntryError {
            meta: generic,
            kind: crate::error::CreateDomainEntryErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainEntryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::CreateDomainEntryError {
            meta: generic,
            kind: crate::error::CreateDomainEntryErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainEntryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateDomainEntryError {
                meta: generic,
                kind: crate::error::CreateDomainEntryErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainEntryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::CreateDomainEntryError {
            meta: generic,
            kind: crate::error::CreateDomainEntryErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDomainEntryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDomainEntryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_domain_entry_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDomainEntryOutput, crate::error::CreateDomainEntryError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_domain_entry_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_domain_entry(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDomainEntryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_instances_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateInstancesOutput, crate::error::CreateInstancesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateInstancesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateInstancesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateInstancesError {
            meta: generic,
            kind: crate::error::CreateInstancesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::CreateInstancesError {
            meta: generic,
            kind: crate::error::CreateInstancesErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateInstancesError {
            meta: generic,
            kind: crate::error::CreateInstancesErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CreateInstancesError {
            meta: generic,
            kind: crate::error::CreateInstancesErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::CreateInstancesError {
            meta: generic,
            kind: crate::error::CreateInstancesErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateInstancesError {
                meta: generic,
                kind: crate::error::CreateInstancesErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateInstancesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::CreateInstancesError {
            meta: generic,
            kind: crate::error::CreateInstancesErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateInstancesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_instances_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateInstancesOutput, crate::error::CreateInstancesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_instances_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_instances(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateInstancesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_instances_from_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateInstancesFromSnapshotOutput,
    crate::error::CreateInstancesFromSnapshotError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateInstancesFromSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateInstancesFromSnapshotError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateInstancesFromSnapshotError {
            meta: generic,
            kind: crate::error::CreateInstancesFromSnapshotErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateInstancesFromSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::CreateInstancesFromSnapshotError {
            meta: generic,
            kind:
                crate::error::CreateInstancesFromSnapshotErrorKind::AccountSetupInProgressException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::account_setup_in_progress_exception::Builder::default(
                                );
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateInstancesFromSnapshotError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidInputException" => crate::error::CreateInstancesFromSnapshotError {
            meta: generic,
            kind: crate::error::CreateInstancesFromSnapshotErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateInstancesFromSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CreateInstancesFromSnapshotError {
            meta: generic,
            kind: crate::error::CreateInstancesFromSnapshotErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateInstancesFromSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::CreateInstancesFromSnapshotError {
            meta: generic,
            kind: crate::error::CreateInstancesFromSnapshotErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateInstancesFromSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateInstancesFromSnapshotError {
                meta: generic,
                kind: crate::error::CreateInstancesFromSnapshotErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateInstancesFromSnapshotError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::CreateInstancesFromSnapshotError {
            meta: generic,
            kind: crate::error::CreateInstancesFromSnapshotErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateInstancesFromSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateInstancesFromSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_instances_from_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateInstancesFromSnapshotOutput,
    crate::error::CreateInstancesFromSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_instances_from_snapshot_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_instances_from_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateInstancesFromSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_instance_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateInstanceSnapshotOutput,
    crate::error::CreateInstanceSnapshotError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateInstanceSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateInstanceSnapshotError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateInstanceSnapshotError {
            meta: generic,
            kind: crate::error::CreateInstanceSnapshotErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateInstanceSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::CreateInstanceSnapshotError {
            meta: generic,
            kind: crate::error::CreateInstanceSnapshotErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateInstanceSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateInstanceSnapshotError {
            meta: generic,
            kind: crate::error::CreateInstanceSnapshotErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateInstanceSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CreateInstanceSnapshotError {
            meta: generic,
            kind: crate::error::CreateInstanceSnapshotErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateInstanceSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::CreateInstanceSnapshotError {
            meta: generic,
            kind: crate::error::CreateInstanceSnapshotErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateInstanceSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateInstanceSnapshotError {
                meta: generic,
                kind: crate::error::CreateInstanceSnapshotErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateInstanceSnapshotError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::CreateInstanceSnapshotError {
            meta: generic,
            kind: crate::error::CreateInstanceSnapshotErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateInstanceSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateInstanceSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_instance_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateInstanceSnapshotOutput,
    crate::error::CreateInstanceSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_instance_snapshot_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_instance_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateInstanceSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_key_pair_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateKeyPairOutput, crate::error::CreateKeyPairError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateKeyPairError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateKeyPairError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateKeyPairError {
            meta: generic,
            kind: crate::error::CreateKeyPairErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::CreateKeyPairError {
            meta: generic,
            kind: crate::error::CreateKeyPairErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateKeyPairError {
            meta: generic,
            kind: crate::error::CreateKeyPairErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CreateKeyPairError {
            meta: generic,
            kind: crate::error::CreateKeyPairErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::CreateKeyPairError {
            meta: generic,
            kind: crate::error::CreateKeyPairErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateKeyPairError {
                meta: generic,
                kind: crate::error::CreateKeyPairErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateKeyPairError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::CreateKeyPairError {
            meta: generic,
            kind: crate::error::CreateKeyPairErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateKeyPairError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_key_pair_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateKeyPairOutput, crate::error::CreateKeyPairError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_key_pair_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_key_pair(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateKeyPairError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_load_balancer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLoadBalancerOutput,
    crate::error::CreateLoadBalancerError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateLoadBalancerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateLoadBalancerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateLoadBalancerError {
                meta: generic,
                kind: crate::error::CreateLoadBalancerErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::CreateLoadBalancerError {
            meta: generic,
            kind: crate::error::CreateLoadBalancerErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateLoadBalancerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_load_balancer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLoadBalancerOutput,
    crate::error::CreateLoadBalancerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_load_balancer_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_load_balancer(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateLoadBalancerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_load_balancer_tls_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLoadBalancerTlsCertificateOutput,
    crate::error::CreateLoadBalancerTlsCertificateError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateLoadBalancerTlsCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateLoadBalancerTlsCertificateError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateLoadBalancerTlsCertificateError { meta: generic, kind: crate::error::CreateLoadBalancerTlsCertificateErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerTlsCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountSetupInProgressException" => crate::error::CreateLoadBalancerTlsCertificateError { meta: generic, kind: crate::error::CreateLoadBalancerTlsCertificateErrorKind::AccountSetupInProgressException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerTlsCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::CreateLoadBalancerTlsCertificateError { meta: generic, kind: crate::error::CreateLoadBalancerTlsCertificateErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerTlsCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotFoundException" => crate::error::CreateLoadBalancerTlsCertificateError { meta: generic, kind: crate::error::CreateLoadBalancerTlsCertificateErrorKind::NotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerTlsCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationFailureException" => crate::error::CreateLoadBalancerTlsCertificateError { meta: generic, kind: crate::error::CreateLoadBalancerTlsCertificateErrorKind::OperationFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerTlsCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::CreateLoadBalancerTlsCertificateError { meta: generic, kind: crate::error::CreateLoadBalancerTlsCertificateErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerTlsCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthenticatedException" => crate::error::CreateLoadBalancerTlsCertificateError { meta: generic, kind: crate::error::CreateLoadBalancerTlsCertificateErrorKind::UnauthenticatedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerTlsCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateLoadBalancerTlsCertificateError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_load_balancer_tls_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateLoadBalancerTlsCertificateOutput,
    crate::error::CreateLoadBalancerTlsCertificateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_load_balancer_tls_certificate_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_load_balancer_tls_certificate(response.body().as_ref(), output).map_err(crate::error::CreateLoadBalancerTlsCertificateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_relational_database_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateRelationalDatabaseOutput,
    crate::error::CreateRelationalDatabaseError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateRelationalDatabaseError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateRelationalDatabaseError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateRelationalDatabaseError {
            meta: generic,
            kind: crate::error::CreateRelationalDatabaseErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::CreateRelationalDatabaseError {
            meta: generic,
            kind: crate::error::CreateRelationalDatabaseErrorKind::AccountSetupInProgressException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::account_setup_in_progress_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRelationalDatabaseError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidInputException" => crate::error::CreateRelationalDatabaseError {
            meta: generic,
            kind: crate::error::CreateRelationalDatabaseErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::CreateRelationalDatabaseError {
            meta: generic,
            kind: crate::error::CreateRelationalDatabaseErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::CreateRelationalDatabaseError {
            meta: generic,
            kind: crate::error::CreateRelationalDatabaseErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::CreateRelationalDatabaseError {
                meta: generic,
                kind: crate::error::CreateRelationalDatabaseErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRelationalDatabaseError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::CreateRelationalDatabaseError {
            meta: generic,
            kind: crate::error::CreateRelationalDatabaseErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateRelationalDatabaseError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_relational_database_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateRelationalDatabaseOutput,
    crate::error::CreateRelationalDatabaseError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_relational_database_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_relational_database(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateRelationalDatabaseError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_relational_database_from_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateRelationalDatabaseFromSnapshotOutput,
    crate::error::CreateRelationalDatabaseFromSnapshotError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateRelationalDatabaseFromSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateRelationalDatabaseFromSnapshotError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateRelationalDatabaseFromSnapshotError { meta: generic, kind: crate::error::CreateRelationalDatabaseFromSnapshotErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRelationalDatabaseFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountSetupInProgressException" => crate::error::CreateRelationalDatabaseFromSnapshotError { meta: generic, kind: crate::error::CreateRelationalDatabaseFromSnapshotErrorKind::AccountSetupInProgressException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRelationalDatabaseFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::CreateRelationalDatabaseFromSnapshotError { meta: generic, kind: crate::error::CreateRelationalDatabaseFromSnapshotErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRelationalDatabaseFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotFoundException" => crate::error::CreateRelationalDatabaseFromSnapshotError { meta: generic, kind: crate::error::CreateRelationalDatabaseFromSnapshotErrorKind::NotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRelationalDatabaseFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationFailureException" => crate::error::CreateRelationalDatabaseFromSnapshotError { meta: generic, kind: crate::error::CreateRelationalDatabaseFromSnapshotErrorKind::OperationFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRelationalDatabaseFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::CreateRelationalDatabaseFromSnapshotError { meta: generic, kind: crate::error::CreateRelationalDatabaseFromSnapshotErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRelationalDatabaseFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthenticatedException" => crate::error::CreateRelationalDatabaseFromSnapshotError { meta: generic, kind: crate::error::CreateRelationalDatabaseFromSnapshotErrorKind::UnauthenticatedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRelationalDatabaseFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateRelationalDatabaseFromSnapshotError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_relational_database_from_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateRelationalDatabaseFromSnapshotOutput,
    crate::error::CreateRelationalDatabaseFromSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_relational_database_from_snapshot_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_relational_database_from_snapshot(response.body().as_ref(), output).map_err(crate::error::CreateRelationalDatabaseFromSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_relational_database_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateRelationalDatabaseSnapshotOutput,
    crate::error::CreateRelationalDatabaseSnapshotError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateRelationalDatabaseSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateRelationalDatabaseSnapshotError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateRelationalDatabaseSnapshotError { meta: generic, kind: crate::error::CreateRelationalDatabaseSnapshotErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRelationalDatabaseSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountSetupInProgressException" => crate::error::CreateRelationalDatabaseSnapshotError { meta: generic, kind: crate::error::CreateRelationalDatabaseSnapshotErrorKind::AccountSetupInProgressException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRelationalDatabaseSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::CreateRelationalDatabaseSnapshotError { meta: generic, kind: crate::error::CreateRelationalDatabaseSnapshotErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRelationalDatabaseSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotFoundException" => crate::error::CreateRelationalDatabaseSnapshotError { meta: generic, kind: crate::error::CreateRelationalDatabaseSnapshotErrorKind::NotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRelationalDatabaseSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationFailureException" => crate::error::CreateRelationalDatabaseSnapshotError { meta: generic, kind: crate::error::CreateRelationalDatabaseSnapshotErrorKind::OperationFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRelationalDatabaseSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::CreateRelationalDatabaseSnapshotError { meta: generic, kind: crate::error::CreateRelationalDatabaseSnapshotErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRelationalDatabaseSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthenticatedException" => crate::error::CreateRelationalDatabaseSnapshotError { meta: generic, kind: crate::error::CreateRelationalDatabaseSnapshotErrorKind::UnauthenticatedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRelationalDatabaseSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateRelationalDatabaseSnapshotError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_relational_database_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateRelationalDatabaseSnapshotOutput,
    crate::error::CreateRelationalDatabaseSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_relational_database_snapshot_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_create_relational_database_snapshot(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::CreateRelationalDatabaseSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_alarm_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAlarmOutput, crate::error::DeleteAlarmError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAlarmError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteAlarmError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteAlarmError {
            meta: generic,
            kind: crate::error::DeleteAlarmErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAlarmError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteAlarmError {
            meta: generic,
            kind: crate::error::DeleteAlarmErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAlarmError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteAlarmError {
            meta: generic,
            kind: crate::error::DeleteAlarmErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAlarmError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::DeleteAlarmError {
            meta: generic,
            kind: crate::error::DeleteAlarmErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAlarmError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteAlarmError {
                meta: generic,
                kind: crate::error::DeleteAlarmErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAlarmError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DeleteAlarmError {
            meta: generic,
            kind: crate::error::DeleteAlarmErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAlarmError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteAlarmError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_alarm_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteAlarmOutput, crate::error::DeleteAlarmError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_alarm_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_alarm(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteAlarmError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_auto_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAutoSnapshotOutput,
    crate::error::DeleteAutoSnapshotError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAutoSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteAutoSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteAutoSnapshotError {
            meta: generic,
            kind: crate::error::DeleteAutoSnapshotErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAutoSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteAutoSnapshotError {
            meta: generic,
            kind: crate::error::DeleteAutoSnapshotErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAutoSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteAutoSnapshotError {
            meta: generic,
            kind: crate::error::DeleteAutoSnapshotErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAutoSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::DeleteAutoSnapshotError {
            meta: generic,
            kind: crate::error::DeleteAutoSnapshotErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAutoSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteAutoSnapshotError {
                meta: generic,
                kind: crate::error::DeleteAutoSnapshotErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAutoSnapshotError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DeleteAutoSnapshotError {
            meta: generic,
            kind: crate::error::DeleteAutoSnapshotErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAutoSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteAutoSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_auto_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAutoSnapshotOutput,
    crate::error::DeleteAutoSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_auto_snapshot_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_auto_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteAutoSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteBucketOutput, crate::error::DeleteBucketError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBucketError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteBucketError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteBucketError {
            meta: generic,
            kind: crate::error::DeleteBucketErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBucketError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteBucketError {
            meta: generic,
            kind: crate::error::DeleteBucketErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBucketError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteBucketError {
            meta: generic,
            kind: crate::error::DeleteBucketErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBucketError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteBucketError {
                meta: generic,
                kind: crate::error::DeleteBucketErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBucketError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DeleteBucketError {
            meta: generic,
            kind: crate::error::DeleteBucketErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBucketError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteBucketError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteBucketOutput, crate::error::DeleteBucketError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_bucket_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_bucket(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteBucketError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_access_key_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketAccessKeyOutput,
    crate::error::DeleteBucketAccessKeyError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBucketAccessKeyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteBucketAccessKeyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteBucketAccessKeyError {
            meta: generic,
            kind: crate::error::DeleteBucketAccessKeyErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBucketAccessKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteBucketAccessKeyError {
            meta: generic,
            kind: crate::error::DeleteBucketAccessKeyErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBucketAccessKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteBucketAccessKeyError {
            meta: generic,
            kind: crate::error::DeleteBucketAccessKeyErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBucketAccessKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteBucketAccessKeyError {
                meta: generic,
                kind: crate::error::DeleteBucketAccessKeyErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBucketAccessKeyError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DeleteBucketAccessKeyError {
            meta: generic,
            kind: crate::error::DeleteBucketAccessKeyErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBucketAccessKeyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteBucketAccessKeyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_bucket_access_key_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBucketAccessKeyOutput,
    crate::error::DeleteBucketAccessKeyError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_bucket_access_key_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_bucket_access_key(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteBucketAccessKeyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteCertificateOutput, crate::error::DeleteCertificateError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteCertificateError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteCertificateError {
            meta: generic,
            kind: crate::error::DeleteCertificateErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteCertificateError {
            meta: generic,
            kind: crate::error::DeleteCertificateErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteCertificateError {
            meta: generic,
            kind: crate::error::DeleteCertificateErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteCertificateError {
                meta: generic,
                kind: crate::error::DeleteCertificateErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCertificateError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DeleteCertificateError {
            meta: generic,
            kind: crate::error::DeleteCertificateErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCertificateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteCertificateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteCertificateOutput, crate::error::DeleteCertificateError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_certificate_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_certificate(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteCertificateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_contact_method_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteContactMethodOutput,
    crate::error::DeleteContactMethodError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteContactMethodError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteContactMethodError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteContactMethodError {
            meta: generic,
            kind: crate::error::DeleteContactMethodErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteContactMethodError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteContactMethodError {
            meta: generic,
            kind: crate::error::DeleteContactMethodErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteContactMethodError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteContactMethodError {
            meta: generic,
            kind: crate::error::DeleteContactMethodErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteContactMethodError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::DeleteContactMethodError {
            meta: generic,
            kind: crate::error::DeleteContactMethodErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteContactMethodError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteContactMethodError {
                meta: generic,
                kind: crate::error::DeleteContactMethodErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteContactMethodError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DeleteContactMethodError {
            meta: generic,
            kind: crate::error::DeleteContactMethodErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteContactMethodError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteContactMethodError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_contact_method_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteContactMethodOutput,
    crate::error::DeleteContactMethodError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_contact_method_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_contact_method(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteContactMethodError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_container_image_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteContainerImageOutput,
    crate::error::DeleteContainerImageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteContainerImageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteContainerImageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteContainerImageError {
            meta: generic,
            kind: crate::error::DeleteContainerImageErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteContainerImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteContainerImageError {
            meta: generic,
            kind: crate::error::DeleteContainerImageErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteContainerImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteContainerImageError {
            meta: generic,
            kind: crate::error::DeleteContainerImageErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteContainerImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteContainerImageError {
                meta: generic,
                kind: crate::error::DeleteContainerImageErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteContainerImageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DeleteContainerImageError {
            meta: generic,
            kind: crate::error::DeleteContainerImageErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteContainerImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteContainerImageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_container_image_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteContainerImageOutput,
    crate::error::DeleteContainerImageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_container_image_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_container_service_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteContainerServiceOutput,
    crate::error::DeleteContainerServiceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteContainerServiceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteContainerServiceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteContainerServiceError {
            meta: generic,
            kind: crate::error::DeleteContainerServiceErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteContainerServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteContainerServiceError {
            meta: generic,
            kind: crate::error::DeleteContainerServiceErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteContainerServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteContainerServiceError {
            meta: generic,
            kind: crate::error::DeleteContainerServiceErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteContainerServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteContainerServiceError {
                meta: generic,
                kind: crate::error::DeleteContainerServiceErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteContainerServiceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DeleteContainerServiceError {
            meta: generic,
            kind: crate::error::DeleteContainerServiceErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteContainerServiceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteContainerServiceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_container_service_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteContainerServiceOutput,
    crate::error::DeleteContainerServiceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_container_service_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_disk_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDiskOutput, crate::error::DeleteDiskError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDiskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDiskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteDiskError {
            meta: generic,
            kind: crate::error::DeleteDiskErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::DeleteDiskError {
            meta: generic,
            kind: crate::error::DeleteDiskErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteDiskError {
            meta: generic,
            kind: crate::error::DeleteDiskErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteDiskError {
            meta: generic,
            kind: crate::error::DeleteDiskErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::DeleteDiskError {
            meta: generic,
            kind: crate::error::DeleteDiskErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteDiskError {
                meta: generic,
                kind: crate::error::DeleteDiskErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDiskError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DeleteDiskError {
            meta: generic,
            kind: crate::error::DeleteDiskErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteDiskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_disk_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDiskOutput, crate::error::DeleteDiskError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_disk_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_disk(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteDiskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_disk_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDiskSnapshotOutput,
    crate::error::DeleteDiskSnapshotError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDiskSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDiskSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteDiskSnapshotError {
            meta: generic,
            kind: crate::error::DeleteDiskSnapshotErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDiskSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::DeleteDiskSnapshotError {
            meta: generic,
            kind: crate::error::DeleteDiskSnapshotErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDiskSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteDiskSnapshotError {
            meta: generic,
            kind: crate::error::DeleteDiskSnapshotErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDiskSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteDiskSnapshotError {
            meta: generic,
            kind: crate::error::DeleteDiskSnapshotErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDiskSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::DeleteDiskSnapshotError {
            meta: generic,
            kind: crate::error::DeleteDiskSnapshotErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDiskSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteDiskSnapshotError {
                meta: generic,
                kind: crate::error::DeleteDiskSnapshotErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDiskSnapshotError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DeleteDiskSnapshotError {
            meta: generic,
            kind: crate::error::DeleteDiskSnapshotErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDiskSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteDiskSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_disk_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDiskSnapshotOutput,
    crate::error::DeleteDiskSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_disk_snapshot_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_disk_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteDiskSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_distribution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDistributionOutput,
    crate::error::DeleteDistributionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDistributionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDistributionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteDistributionError {
            meta: generic,
            kind: crate::error::DeleteDistributionErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDistributionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteDistributionError {
            meta: generic,
            kind: crate::error::DeleteDistributionErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDistributionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteDistributionError {
            meta: generic,
            kind: crate::error::DeleteDistributionErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDistributionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::DeleteDistributionError {
            meta: generic,
            kind: crate::error::DeleteDistributionErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDistributionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteDistributionError {
                meta: generic,
                kind: crate::error::DeleteDistributionErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDistributionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DeleteDistributionError {
            meta: generic,
            kind: crate::error::DeleteDistributionErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDistributionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteDistributionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_distribution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDistributionOutput,
    crate::error::DeleteDistributionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_distribution_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_distribution(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteDistributionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_domain_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDomainOutput, crate::error::DeleteDomainError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDomainError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDomainError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteDomainError {
            meta: generic,
            kind: crate::error::DeleteDomainErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::DeleteDomainError {
            meta: generic,
            kind: crate::error::DeleteDomainErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteDomainError {
            meta: generic,
            kind: crate::error::DeleteDomainErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteDomainError {
            meta: generic,
            kind: crate::error::DeleteDomainErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::DeleteDomainError {
            meta: generic,
            kind: crate::error::DeleteDomainErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteDomainError {
                meta: generic,
                kind: crate::error::DeleteDomainErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDomainError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DeleteDomainError {
            meta: generic,
            kind: crate::error::DeleteDomainErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteDomainError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_domain_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDomainOutput, crate::error::DeleteDomainError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_domain_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_domain(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteDomainError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_domain_entry_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDomainEntryOutput, crate::error::DeleteDomainEntryError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDomainEntryError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDomainEntryError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteDomainEntryError {
            meta: generic,
            kind: crate::error::DeleteDomainEntryErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDomainEntryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::DeleteDomainEntryError {
            meta: generic,
            kind: crate::error::DeleteDomainEntryErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDomainEntryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteDomainEntryError {
            meta: generic,
            kind: crate::error::DeleteDomainEntryErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDomainEntryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteDomainEntryError {
            meta: generic,
            kind: crate::error::DeleteDomainEntryErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDomainEntryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::DeleteDomainEntryError {
            meta: generic,
            kind: crate::error::DeleteDomainEntryErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDomainEntryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteDomainEntryError {
                meta: generic,
                kind: crate::error::DeleteDomainEntryErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDomainEntryError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DeleteDomainEntryError {
            meta: generic,
            kind: crate::error::DeleteDomainEntryErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDomainEntryError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteDomainEntryError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_domain_entry_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDomainEntryOutput, crate::error::DeleteDomainEntryError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_domain_entry_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_domain_entry(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteDomainEntryError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteInstanceOutput, crate::error::DeleteInstanceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteInstanceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteInstanceError {
            meta: generic,
            kind: crate::error::DeleteInstanceErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::DeleteInstanceError {
            meta: generic,
            kind: crate::error::DeleteInstanceErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteInstanceError {
            meta: generic,
            kind: crate::error::DeleteInstanceErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteInstanceError {
            meta: generic,
            kind: crate::error::DeleteInstanceErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::DeleteInstanceError {
            meta: generic,
            kind: crate::error::DeleteInstanceErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteInstanceError {
                meta: generic,
                kind: crate::error::DeleteInstanceErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteInstanceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DeleteInstanceError {
            meta: generic,
            kind: crate::error::DeleteInstanceErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteInstanceOutput, crate::error::DeleteInstanceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_instance_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_instance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteInstanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_instance_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteInstanceSnapshotOutput,
    crate::error::DeleteInstanceSnapshotError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteInstanceSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteInstanceSnapshotError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteInstanceSnapshotError {
            meta: generic,
            kind: crate::error::DeleteInstanceSnapshotErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteInstanceSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::DeleteInstanceSnapshotError {
            meta: generic,
            kind: crate::error::DeleteInstanceSnapshotErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteInstanceSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteInstanceSnapshotError {
            meta: generic,
            kind: crate::error::DeleteInstanceSnapshotErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteInstanceSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteInstanceSnapshotError {
            meta: generic,
            kind: crate::error::DeleteInstanceSnapshotErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteInstanceSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::DeleteInstanceSnapshotError {
            meta: generic,
            kind: crate::error::DeleteInstanceSnapshotErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteInstanceSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteInstanceSnapshotError {
                meta: generic,
                kind: crate::error::DeleteInstanceSnapshotErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteInstanceSnapshotError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DeleteInstanceSnapshotError {
            meta: generic,
            kind: crate::error::DeleteInstanceSnapshotErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteInstanceSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteInstanceSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_instance_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteInstanceSnapshotOutput,
    crate::error::DeleteInstanceSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_instance_snapshot_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_instance_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteInstanceSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_key_pair_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteKeyPairOutput, crate::error::DeleteKeyPairError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteKeyPairError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteKeyPairError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteKeyPairError {
            meta: generic,
            kind: crate::error::DeleteKeyPairErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::DeleteKeyPairError {
            meta: generic,
            kind: crate::error::DeleteKeyPairErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteKeyPairError {
            meta: generic,
            kind: crate::error::DeleteKeyPairErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteKeyPairError {
            meta: generic,
            kind: crate::error::DeleteKeyPairErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::DeleteKeyPairError {
            meta: generic,
            kind: crate::error::DeleteKeyPairErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteKeyPairError {
                meta: generic,
                kind: crate::error::DeleteKeyPairErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteKeyPairError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DeleteKeyPairError {
            meta: generic,
            kind: crate::error::DeleteKeyPairErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteKeyPairError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_key_pair_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteKeyPairOutput, crate::error::DeleteKeyPairError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_key_pair_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_key_pair(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteKeyPairError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_known_host_keys_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteKnownHostKeysOutput,
    crate::error::DeleteKnownHostKeysError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteKnownHostKeysError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteKnownHostKeysError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteKnownHostKeysError {
            meta: generic,
            kind: crate::error::DeleteKnownHostKeysErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteKnownHostKeysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::DeleteKnownHostKeysError {
            meta: generic,
            kind: crate::error::DeleteKnownHostKeysErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteKnownHostKeysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteKnownHostKeysError {
            meta: generic,
            kind: crate::error::DeleteKnownHostKeysErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteKnownHostKeysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteKnownHostKeysError {
            meta: generic,
            kind: crate::error::DeleteKnownHostKeysErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteKnownHostKeysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::DeleteKnownHostKeysError {
            meta: generic,
            kind: crate::error::DeleteKnownHostKeysErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteKnownHostKeysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteKnownHostKeysError {
                meta: generic,
                kind: crate::error::DeleteKnownHostKeysErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteKnownHostKeysError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DeleteKnownHostKeysError {
            meta: generic,
            kind: crate::error::DeleteKnownHostKeysErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteKnownHostKeysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteKnownHostKeysError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_known_host_keys_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteKnownHostKeysOutput,
    crate::error::DeleteKnownHostKeysError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_known_host_keys_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_known_host_keys(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteKnownHostKeysError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_load_balancer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLoadBalancerOutput,
    crate::error::DeleteLoadBalancerError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteLoadBalancerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteLoadBalancerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteLoadBalancerError {
            meta: generic,
            kind: crate::error::DeleteLoadBalancerErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::DeleteLoadBalancerError {
            meta: generic,
            kind: crate::error::DeleteLoadBalancerErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteLoadBalancerError {
            meta: generic,
            kind: crate::error::DeleteLoadBalancerErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteLoadBalancerError {
            meta: generic,
            kind: crate::error::DeleteLoadBalancerErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::DeleteLoadBalancerError {
            meta: generic,
            kind: crate::error::DeleteLoadBalancerErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteLoadBalancerError {
                meta: generic,
                kind: crate::error::DeleteLoadBalancerErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoadBalancerError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DeleteLoadBalancerError {
            meta: generic,
            kind: crate::error::DeleteLoadBalancerErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteLoadBalancerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_load_balancer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLoadBalancerOutput,
    crate::error::DeleteLoadBalancerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_load_balancer_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_load_balancer(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteLoadBalancerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_load_balancer_tls_certificate_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLoadBalancerTlsCertificateOutput,
    crate::error::DeleteLoadBalancerTlsCertificateError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteLoadBalancerTlsCertificateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteLoadBalancerTlsCertificateError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteLoadBalancerTlsCertificateError { meta: generic, kind: crate::error::DeleteLoadBalancerTlsCertificateErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoadBalancerTlsCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountSetupInProgressException" => crate::error::DeleteLoadBalancerTlsCertificateError { meta: generic, kind: crate::error::DeleteLoadBalancerTlsCertificateErrorKind::AccountSetupInProgressException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoadBalancerTlsCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::DeleteLoadBalancerTlsCertificateError { meta: generic, kind: crate::error::DeleteLoadBalancerTlsCertificateErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoadBalancerTlsCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotFoundException" => crate::error::DeleteLoadBalancerTlsCertificateError { meta: generic, kind: crate::error::DeleteLoadBalancerTlsCertificateErrorKind::NotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoadBalancerTlsCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationFailureException" => crate::error::DeleteLoadBalancerTlsCertificateError { meta: generic, kind: crate::error::DeleteLoadBalancerTlsCertificateErrorKind::OperationFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoadBalancerTlsCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::DeleteLoadBalancerTlsCertificateError { meta: generic, kind: crate::error::DeleteLoadBalancerTlsCertificateErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoadBalancerTlsCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthenticatedException" => crate::error::DeleteLoadBalancerTlsCertificateError { meta: generic, kind: crate::error::DeleteLoadBalancerTlsCertificateErrorKind::UnauthenticatedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteLoadBalancerTlsCertificateError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteLoadBalancerTlsCertificateError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_load_balancer_tls_certificate_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteLoadBalancerTlsCertificateOutput,
    crate::error::DeleteLoadBalancerTlsCertificateError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_load_balancer_tls_certificate_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_load_balancer_tls_certificate(response.body().as_ref(), output).map_err(crate::error::DeleteLoadBalancerTlsCertificateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_relational_database_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRelationalDatabaseOutput,
    crate::error::DeleteRelationalDatabaseError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRelationalDatabaseError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteRelationalDatabaseError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteRelationalDatabaseError {
            meta: generic,
            kind: crate::error::DeleteRelationalDatabaseErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::DeleteRelationalDatabaseError {
            meta: generic,
            kind: crate::error::DeleteRelationalDatabaseErrorKind::AccountSetupInProgressException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::account_setup_in_progress_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRelationalDatabaseError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidInputException" => crate::error::DeleteRelationalDatabaseError {
            meta: generic,
            kind: crate::error::DeleteRelationalDatabaseErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DeleteRelationalDatabaseError {
            meta: generic,
            kind: crate::error::DeleteRelationalDatabaseErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::DeleteRelationalDatabaseError {
            meta: generic,
            kind: crate::error::DeleteRelationalDatabaseErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DeleteRelationalDatabaseError {
                meta: generic,
                kind: crate::error::DeleteRelationalDatabaseErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRelationalDatabaseError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DeleteRelationalDatabaseError {
            meta: generic,
            kind: crate::error::DeleteRelationalDatabaseErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteRelationalDatabaseError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_relational_database_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRelationalDatabaseOutput,
    crate::error::DeleteRelationalDatabaseError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_relational_database_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_relational_database(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteRelationalDatabaseError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_relational_database_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRelationalDatabaseSnapshotOutput,
    crate::error::DeleteRelationalDatabaseSnapshotError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRelationalDatabaseSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteRelationalDatabaseSnapshotError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DeleteRelationalDatabaseSnapshotError { meta: generic, kind: crate::error::DeleteRelationalDatabaseSnapshotErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRelationalDatabaseSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountSetupInProgressException" => crate::error::DeleteRelationalDatabaseSnapshotError { meta: generic, kind: crate::error::DeleteRelationalDatabaseSnapshotErrorKind::AccountSetupInProgressException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRelationalDatabaseSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::DeleteRelationalDatabaseSnapshotError { meta: generic, kind: crate::error::DeleteRelationalDatabaseSnapshotErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRelationalDatabaseSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotFoundException" => crate::error::DeleteRelationalDatabaseSnapshotError { meta: generic, kind: crate::error::DeleteRelationalDatabaseSnapshotErrorKind::NotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRelationalDatabaseSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationFailureException" => crate::error::DeleteRelationalDatabaseSnapshotError { meta: generic, kind: crate::error::DeleteRelationalDatabaseSnapshotErrorKind::OperationFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRelationalDatabaseSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::DeleteRelationalDatabaseSnapshotError { meta: generic, kind: crate::error::DeleteRelationalDatabaseSnapshotErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRelationalDatabaseSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthenticatedException" => crate::error::DeleteRelationalDatabaseSnapshotError { meta: generic, kind: crate::error::DeleteRelationalDatabaseSnapshotErrorKind::UnauthenticatedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRelationalDatabaseSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteRelationalDatabaseSnapshotError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_relational_database_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRelationalDatabaseSnapshotOutput,
    crate::error::DeleteRelationalDatabaseSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_relational_database_snapshot_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_delete_relational_database_snapshot(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DeleteRelationalDatabaseSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_certificate_from_distribution_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DetachCertificateFromDistributionOutput,
    crate::error::DetachCertificateFromDistributionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DetachCertificateFromDistributionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DetachCertificateFromDistributionError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DetachCertificateFromDistributionError {
            meta: generic,
            kind: crate::error::DetachCertificateFromDistributionErrorKind::AccessDeniedException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::access_denied_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachCertificateFromDistributionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidInputException" => crate::error::DetachCertificateFromDistributionError {
            meta: generic,
            kind: crate::error::DetachCertificateFromDistributionErrorKind::InvalidInputException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::invalid_input_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachCertificateFromDistributionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "NotFoundException" => crate::error::DetachCertificateFromDistributionError {
            meta: generic,
            kind: crate::error::DetachCertificateFromDistributionErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachCertificateFromDistributionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::DetachCertificateFromDistributionError {
            meta: generic,
            kind:
                crate::error::DetachCertificateFromDistributionErrorKind::OperationFailureException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::operation_failure_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachCertificateFromDistributionError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "ServiceException" => {
            crate::error::DetachCertificateFromDistributionError {
                meta: generic,
                kind: crate::error::DetachCertificateFromDistributionErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachCertificateFromDistributionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DetachCertificateFromDistributionError {
            meta: generic,
            kind:
                crate::error::DetachCertificateFromDistributionErrorKind::UnauthenticatedException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::unauthenticated_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachCertificateFromDistributionError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DetachCertificateFromDistributionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_certificate_from_distribution_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DetachCertificateFromDistributionOutput,
    crate::error::DetachCertificateFromDistributionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::detach_certificate_from_distribution_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_detach_certificate_from_distribution(response.body().as_ref(), output).map_err(crate::error::DetachCertificateFromDistributionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_disk_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetachDiskOutput, crate::error::DetachDiskError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DetachDiskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DetachDiskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DetachDiskError {
            meta: generic,
            kind: crate::error::DetachDiskErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::DetachDiskError {
            meta: generic,
            kind: crate::error::DetachDiskErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DetachDiskError {
            meta: generic,
            kind: crate::error::DetachDiskErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DetachDiskError {
            meta: generic,
            kind: crate::error::DetachDiskErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::DetachDiskError {
            meta: generic,
            kind: crate::error::DetachDiskErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DetachDiskError {
                meta: generic,
                kind: crate::error::DetachDiskErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachDiskError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DetachDiskError {
            meta: generic,
            kind: crate::error::DetachDiskErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DetachDiskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_disk_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetachDiskOutput, crate::error::DetachDiskError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::detach_disk_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_detach_disk(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DetachDiskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_instances_from_load_balancer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DetachInstancesFromLoadBalancerOutput,
    crate::error::DetachInstancesFromLoadBalancerError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DetachInstancesFromLoadBalancerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DetachInstancesFromLoadBalancerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DetachInstancesFromLoadBalancerError { meta: generic, kind: crate::error::DetachInstancesFromLoadBalancerErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachInstancesFromLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountSetupInProgressException" => crate::error::DetachInstancesFromLoadBalancerError { meta: generic, kind: crate::error::DetachInstancesFromLoadBalancerErrorKind::AccountSetupInProgressException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachInstancesFromLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::DetachInstancesFromLoadBalancerError { meta: generic, kind: crate::error::DetachInstancesFromLoadBalancerErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachInstancesFromLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotFoundException" => crate::error::DetachInstancesFromLoadBalancerError { meta: generic, kind: crate::error::DetachInstancesFromLoadBalancerErrorKind::NotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachInstancesFromLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationFailureException" => crate::error::DetachInstancesFromLoadBalancerError { meta: generic, kind: crate::error::DetachInstancesFromLoadBalancerErrorKind::OperationFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachInstancesFromLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::DetachInstancesFromLoadBalancerError { meta: generic, kind: crate::error::DetachInstancesFromLoadBalancerErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachInstancesFromLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthenticatedException" => crate::error::DetachInstancesFromLoadBalancerError { meta: generic, kind: crate::error::DetachInstancesFromLoadBalancerErrorKind::UnauthenticatedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachInstancesFromLoadBalancerError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DetachInstancesFromLoadBalancerError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_instances_from_load_balancer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DetachInstancesFromLoadBalancerOutput,
    crate::error::DetachInstancesFromLoadBalancerError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::detach_instances_from_load_balancer_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_detach_instances_from_load_balancer(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DetachInstancesFromLoadBalancerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_static_ip_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetachStaticIpOutput, crate::error::DetachStaticIpError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DetachStaticIpError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DetachStaticIpError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DetachStaticIpError {
            meta: generic,
            kind: crate::error::DetachStaticIpErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::DetachStaticIpError {
            meta: generic,
            kind: crate::error::DetachStaticIpErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DetachStaticIpError {
            meta: generic,
            kind: crate::error::DetachStaticIpErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DetachStaticIpError {
            meta: generic,
            kind: crate::error::DetachStaticIpErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::DetachStaticIpError {
            meta: generic,
            kind: crate::error::DetachStaticIpErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DetachStaticIpError {
                meta: generic,
                kind: crate::error::DetachStaticIpErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachStaticIpError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DetachStaticIpError {
            meta: generic,
            kind: crate::error::DetachStaticIpErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DetachStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DetachStaticIpError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_detach_static_ip_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DetachStaticIpOutput, crate::error::DetachStaticIpError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::detach_static_ip_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_detach_static_ip(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DetachStaticIpError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_add_on_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DisableAddOnOutput, crate::error::DisableAddOnError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisableAddOnError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DisableAddOnError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DisableAddOnError {
            meta: generic,
            kind: crate::error::DisableAddOnErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableAddOnError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DisableAddOnError {
            meta: generic,
            kind: crate::error::DisableAddOnErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableAddOnError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DisableAddOnError {
            meta: generic,
            kind: crate::error::DisableAddOnErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableAddOnError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::DisableAddOnError {
            meta: generic,
            kind: crate::error::DisableAddOnErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableAddOnError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DisableAddOnError {
                meta: generic,
                kind: crate::error::DisableAddOnErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableAddOnError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DisableAddOnError {
            meta: generic,
            kind: crate::error::DisableAddOnErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisableAddOnError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisableAddOnError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disable_add_on_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DisableAddOnOutput, crate::error::DisableAddOnError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disable_add_on_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_disable_add_on(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DisableAddOnError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_download_default_key_pair_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DownloadDefaultKeyPairOutput,
    crate::error::DownloadDefaultKeyPairError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DownloadDefaultKeyPairError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DownloadDefaultKeyPairError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DownloadDefaultKeyPairError {
            meta: generic,
            kind: crate::error::DownloadDefaultKeyPairErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DownloadDefaultKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::DownloadDefaultKeyPairError {
            meta: generic,
            kind: crate::error::DownloadDefaultKeyPairErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DownloadDefaultKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DownloadDefaultKeyPairError {
            meta: generic,
            kind: crate::error::DownloadDefaultKeyPairErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DownloadDefaultKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::DownloadDefaultKeyPairError {
            meta: generic,
            kind: crate::error::DownloadDefaultKeyPairErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DownloadDefaultKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::DownloadDefaultKeyPairError {
            meta: generic,
            kind: crate::error::DownloadDefaultKeyPairErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DownloadDefaultKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::DownloadDefaultKeyPairError {
                meta: generic,
                kind: crate::error::DownloadDefaultKeyPairErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DownloadDefaultKeyPairError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::DownloadDefaultKeyPairError {
            meta: generic,
            kind: crate::error::DownloadDefaultKeyPairErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DownloadDefaultKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DownloadDefaultKeyPairError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_download_default_key_pair_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DownloadDefaultKeyPairOutput,
    crate::error::DownloadDefaultKeyPairError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::download_default_key_pair_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_download_default_key_pair(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DownloadDefaultKeyPairError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_add_on_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EnableAddOnOutput, crate::error::EnableAddOnError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::EnableAddOnError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::EnableAddOnError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::EnableAddOnError {
            meta: generic,
            kind: crate::error::EnableAddOnErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAddOnError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::EnableAddOnError {
            meta: generic,
            kind: crate::error::EnableAddOnErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAddOnError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::EnableAddOnError {
            meta: generic,
            kind: crate::error::EnableAddOnErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAddOnError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::EnableAddOnError {
            meta: generic,
            kind: crate::error::EnableAddOnErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAddOnError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::EnableAddOnError {
                meta: generic,
                kind: crate::error::EnableAddOnErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAddOnError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::EnableAddOnError {
            meta: generic,
            kind: crate::error::EnableAddOnErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::EnableAddOnError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::EnableAddOnError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_enable_add_on_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::EnableAddOnOutput, crate::error::EnableAddOnError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::enable_add_on_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_enable_add_on(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::EnableAddOnError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_export_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ExportSnapshotOutput, crate::error::ExportSnapshotError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ExportSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ExportSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ExportSnapshotError {
            meta: generic,
            kind: crate::error::ExportSnapshotErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExportSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::ExportSnapshotError {
            meta: generic,
            kind: crate::error::ExportSnapshotErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExportSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::ExportSnapshotError {
            meta: generic,
            kind: crate::error::ExportSnapshotErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExportSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::ExportSnapshotError {
            meta: generic,
            kind: crate::error::ExportSnapshotErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExportSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::ExportSnapshotError {
            meta: generic,
            kind: crate::error::ExportSnapshotErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExportSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ExportSnapshotError {
                meta: generic,
                kind: crate::error::ExportSnapshotErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExportSnapshotError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::ExportSnapshotError {
            meta: generic,
            kind: crate::error::ExportSnapshotErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ExportSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ExportSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_export_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ExportSnapshotOutput, crate::error::ExportSnapshotError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::export_snapshot_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_export_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ExportSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_active_names_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetActiveNamesOutput, crate::error::GetActiveNamesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetActiveNamesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetActiveNamesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetActiveNamesError {
            meta: generic,
            kind: crate::error::GetActiveNamesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetActiveNamesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetActiveNamesError {
            meta: generic,
            kind: crate::error::GetActiveNamesErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetActiveNamesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetActiveNamesError {
            meta: generic,
            kind: crate::error::GetActiveNamesErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetActiveNamesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetActiveNamesError {
            meta: generic,
            kind: crate::error::GetActiveNamesErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetActiveNamesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetActiveNamesError {
            meta: generic,
            kind: crate::error::GetActiveNamesErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetActiveNamesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetActiveNamesError {
                meta: generic,
                kind: crate::error::GetActiveNamesErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetActiveNamesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetActiveNamesError {
            meta: generic,
            kind: crate::error::GetActiveNamesErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetActiveNamesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetActiveNamesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_active_names_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetActiveNamesOutput, crate::error::GetActiveNamesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_active_names_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_active_names(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetActiveNamesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_alarms_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAlarmsOutput, crate::error::GetAlarmsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAlarmsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetAlarmsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetAlarmsError {
            meta: generic,
            kind: crate::error::GetAlarmsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAlarmsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetAlarmsError {
            meta: generic,
            kind: crate::error::GetAlarmsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAlarmsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetAlarmsError {
            meta: generic,
            kind: crate::error::GetAlarmsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAlarmsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetAlarmsError {
            meta: generic,
            kind: crate::error::GetAlarmsErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAlarmsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetAlarmsError {
                meta: generic,
                kind: crate::error::GetAlarmsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAlarmsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetAlarmsError {
            meta: generic,
            kind: crate::error::GetAlarmsErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAlarmsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetAlarmsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_alarms_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAlarmsOutput, crate::error::GetAlarmsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_alarms_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_alarms(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAlarmsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_auto_snapshots_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAutoSnapshotsOutput, crate::error::GetAutoSnapshotsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAutoSnapshotsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetAutoSnapshotsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetAutoSnapshotsError {
            meta: generic,
            kind: crate::error::GetAutoSnapshotsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAutoSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetAutoSnapshotsError {
            meta: generic,
            kind: crate::error::GetAutoSnapshotsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAutoSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetAutoSnapshotsError {
            meta: generic,
            kind: crate::error::GetAutoSnapshotsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAutoSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetAutoSnapshotsError {
            meta: generic,
            kind: crate::error::GetAutoSnapshotsErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAutoSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetAutoSnapshotsError {
                meta: generic,
                kind: crate::error::GetAutoSnapshotsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAutoSnapshotsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetAutoSnapshotsError {
            meta: generic,
            kind: crate::error::GetAutoSnapshotsErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAutoSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetAutoSnapshotsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_auto_snapshots_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAutoSnapshotsOutput, crate::error::GetAutoSnapshotsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_auto_snapshots_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_auto_snapshots(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAutoSnapshotsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_blueprints_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBlueprintsOutput, crate::error::GetBlueprintsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBlueprintsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetBlueprintsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetBlueprintsError {
            meta: generic,
            kind: crate::error::GetBlueprintsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBlueprintsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetBlueprintsError {
            meta: generic,
            kind: crate::error::GetBlueprintsErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBlueprintsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetBlueprintsError {
            meta: generic,
            kind: crate::error::GetBlueprintsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBlueprintsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetBlueprintsError {
            meta: generic,
            kind: crate::error::GetBlueprintsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBlueprintsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetBlueprintsError {
            meta: generic,
            kind: crate::error::GetBlueprintsErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBlueprintsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetBlueprintsError {
                meta: generic,
                kind: crate::error::GetBlueprintsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBlueprintsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetBlueprintsError {
            meta: generic,
            kind: crate::error::GetBlueprintsErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBlueprintsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetBlueprintsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_blueprints_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBlueprintsOutput, crate::error::GetBlueprintsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_blueprints_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_blueprints(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetBlueprintsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_access_keys_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketAccessKeysOutput,
    crate::error::GetBucketAccessKeysError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketAccessKeysError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetBucketAccessKeysError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetBucketAccessKeysError {
            meta: generic,
            kind: crate::error::GetBucketAccessKeysErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBucketAccessKeysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetBucketAccessKeysError {
            meta: generic,
            kind: crate::error::GetBucketAccessKeysErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBucketAccessKeysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetBucketAccessKeysError {
            meta: generic,
            kind: crate::error::GetBucketAccessKeysErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBucketAccessKeysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetBucketAccessKeysError {
                meta: generic,
                kind: crate::error::GetBucketAccessKeysErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBucketAccessKeysError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetBucketAccessKeysError {
            meta: generic,
            kind: crate::error::GetBucketAccessKeysErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBucketAccessKeysError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetBucketAccessKeysError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_access_keys_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketAccessKeysOutput,
    crate::error::GetBucketAccessKeysError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_bucket_access_keys_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_bucket_access_keys(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetBucketAccessKeysError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_bundles_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketBundlesOutput, crate::error::GetBucketBundlesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketBundlesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetBucketBundlesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetBucketBundlesError {
            meta: generic,
            kind: crate::error::GetBucketBundlesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBucketBundlesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetBucketBundlesError {
            meta: generic,
            kind: crate::error::GetBucketBundlesErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBucketBundlesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetBucketBundlesError {
                meta: generic,
                kind: crate::error::GetBucketBundlesErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBucketBundlesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetBucketBundlesError {
            meta: generic,
            kind: crate::error::GetBucketBundlesErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBucketBundlesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetBucketBundlesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_bundles_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketBundlesOutput, crate::error::GetBucketBundlesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_bucket_bundles_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_bucket_bundles(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetBucketBundlesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_metric_data_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketMetricDataOutput,
    crate::error::GetBucketMetricDataError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketMetricDataError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetBucketMetricDataError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetBucketMetricDataError {
            meta: generic,
            kind: crate::error::GetBucketMetricDataErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBucketMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetBucketMetricDataError {
            meta: generic,
            kind: crate::error::GetBucketMetricDataErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBucketMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetBucketMetricDataError {
            meta: generic,
            kind: crate::error::GetBucketMetricDataErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBucketMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetBucketMetricDataError {
                meta: generic,
                kind: crate::error::GetBucketMetricDataErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBucketMetricDataError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetBucketMetricDataError {
            meta: generic,
            kind: crate::error::GetBucketMetricDataErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBucketMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetBucketMetricDataError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bucket_metric_data_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBucketMetricDataOutput,
    crate::error::GetBucketMetricDataError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_bucket_metric_data_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_bucket_metric_data(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetBucketMetricDataError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_buckets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketsOutput, crate::error::GetBucketsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBucketsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetBucketsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetBucketsError {
            meta: generic,
            kind: crate::error::GetBucketsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBucketsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetBucketsError {
            meta: generic,
            kind: crate::error::GetBucketsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBucketsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetBucketsError {
            meta: generic,
            kind: crate::error::GetBucketsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBucketsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetBucketsError {
                meta: generic,
                kind: crate::error::GetBucketsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBucketsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetBucketsError {
            meta: generic,
            kind: crate::error::GetBucketsErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBucketsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetBucketsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_buckets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBucketsOutput, crate::error::GetBucketsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_buckets_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_buckets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetBucketsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bundles_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBundlesOutput, crate::error::GetBundlesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBundlesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetBundlesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetBundlesError {
            meta: generic,
            kind: crate::error::GetBundlesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBundlesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetBundlesError {
            meta: generic,
            kind: crate::error::GetBundlesErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBundlesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetBundlesError {
            meta: generic,
            kind: crate::error::GetBundlesErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBundlesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetBundlesError {
            meta: generic,
            kind: crate::error::GetBundlesErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBundlesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetBundlesError {
            meta: generic,
            kind: crate::error::GetBundlesErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBundlesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetBundlesError {
                meta: generic,
                kind: crate::error::GetBundlesErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBundlesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetBundlesError {
            meta: generic,
            kind: crate::error::GetBundlesErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBundlesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetBundlesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_bundles_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetBundlesOutput, crate::error::GetBundlesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_bundles_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_bundles(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetBundlesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_certificates_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetCertificatesOutput, crate::error::GetCertificatesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetCertificatesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetCertificatesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetCertificatesError {
            meta: generic,
            kind: crate::error::GetCertificatesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCertificatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetCertificatesError {
            meta: generic,
            kind: crate::error::GetCertificatesErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCertificatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetCertificatesError {
            meta: generic,
            kind: crate::error::GetCertificatesErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCertificatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetCertificatesError {
                meta: generic,
                kind: crate::error::GetCertificatesErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCertificatesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetCertificatesError {
            meta: generic,
            kind: crate::error::GetCertificatesErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCertificatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetCertificatesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_certificates_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetCertificatesOutput, crate::error::GetCertificatesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_certificates_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_certificates(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetCertificatesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_cloud_formation_stack_records_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetCloudFormationStackRecordsOutput,
    crate::error::GetCloudFormationStackRecordsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetCloudFormationStackRecordsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetCloudFormationStackRecordsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetCloudFormationStackRecordsError { meta: generic, kind: crate::error::GetCloudFormationStackRecordsErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCloudFormationStackRecordsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountSetupInProgressException" => crate::error::GetCloudFormationStackRecordsError { meta: generic, kind: crate::error::GetCloudFormationStackRecordsErrorKind::AccountSetupInProgressException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCloudFormationStackRecordsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::GetCloudFormationStackRecordsError { meta: generic, kind: crate::error::GetCloudFormationStackRecordsErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCloudFormationStackRecordsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotFoundException" => crate::error::GetCloudFormationStackRecordsError { meta: generic, kind: crate::error::GetCloudFormationStackRecordsErrorKind::NotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCloudFormationStackRecordsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationFailureException" => crate::error::GetCloudFormationStackRecordsError { meta: generic, kind: crate::error::GetCloudFormationStackRecordsErrorKind::OperationFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCloudFormationStackRecordsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::GetCloudFormationStackRecordsError { meta: generic, kind: crate::error::GetCloudFormationStackRecordsErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCloudFormationStackRecordsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthenticatedException" => crate::error::GetCloudFormationStackRecordsError { meta: generic, kind: crate::error::GetCloudFormationStackRecordsErrorKind::UnauthenticatedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCloudFormationStackRecordsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetCloudFormationStackRecordsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_cloud_formation_stack_records_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetCloudFormationStackRecordsOutput,
    crate::error::GetCloudFormationStackRecordsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_cloud_formation_stack_records_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_cloud_formation_stack_records(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetCloudFormationStackRecordsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_contact_methods_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetContactMethodsOutput, crate::error::GetContactMethodsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetContactMethodsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetContactMethodsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetContactMethodsError {
            meta: generic,
            kind: crate::error::GetContactMethodsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContactMethodsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetContactMethodsError {
            meta: generic,
            kind: crate::error::GetContactMethodsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContactMethodsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetContactMethodsError {
            meta: generic,
            kind: crate::error::GetContactMethodsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContactMethodsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetContactMethodsError {
            meta: generic,
            kind: crate::error::GetContactMethodsErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContactMethodsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetContactMethodsError {
                meta: generic,
                kind: crate::error::GetContactMethodsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContactMethodsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetContactMethodsError {
            meta: generic,
            kind: crate::error::GetContactMethodsErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContactMethodsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetContactMethodsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_contact_methods_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetContactMethodsOutput, crate::error::GetContactMethodsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_contact_methods_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_contact_methods(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetContactMethodsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_container_api_metadata_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetContainerApiMetadataOutput,
    crate::error::GetContainerAPIMetadataError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetContainerAPIMetadataError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetContainerAPIMetadataError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetContainerAPIMetadataError {
            meta: generic,
            kind: crate::error::GetContainerAPIMetadataErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerAPIMetadataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetContainerAPIMetadataError {
                meta: generic,
                kind: crate::error::GetContainerAPIMetadataErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerAPIMetadataError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetContainerAPIMetadataError {
            meta: generic,
            kind: crate::error::GetContainerAPIMetadataErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerAPIMetadataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetContainerAPIMetadataError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_container_api_metadata_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetContainerApiMetadataOutput,
    crate::error::GetContainerAPIMetadataError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_container_api_metadata_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_container_api_metadata(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetContainerAPIMetadataError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_container_images_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetContainerImagesOutput,
    crate::error::GetContainerImagesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetContainerImagesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetContainerImagesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetContainerImagesError {
            meta: generic,
            kind: crate::error::GetContainerImagesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerImagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetContainerImagesError {
            meta: generic,
            kind: crate::error::GetContainerImagesErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerImagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetContainerImagesError {
            meta: generic,
            kind: crate::error::GetContainerImagesErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerImagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetContainerImagesError {
                meta: generic,
                kind: crate::error::GetContainerImagesErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerImagesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetContainerImagesError {
            meta: generic,
            kind: crate::error::GetContainerImagesErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerImagesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetContainerImagesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_container_images_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetContainerImagesOutput,
    crate::error::GetContainerImagesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_container_images_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_container_images(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetContainerImagesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_container_log_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetContainerLogOutput, crate::error::GetContainerLogError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetContainerLogError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetContainerLogError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetContainerLogError {
            meta: generic,
            kind: crate::error::GetContainerLogErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerLogError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetContainerLogError {
            meta: generic,
            kind: crate::error::GetContainerLogErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerLogError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetContainerLogError {
            meta: generic,
            kind: crate::error::GetContainerLogErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerLogError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetContainerLogError {
                meta: generic,
                kind: crate::error::GetContainerLogErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerLogError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetContainerLogError {
            meta: generic,
            kind: crate::error::GetContainerLogErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerLogError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetContainerLogError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_container_log_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetContainerLogOutput, crate::error::GetContainerLogError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_container_log_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_container_log(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetContainerLogError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_container_service_deployments_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetContainerServiceDeploymentsOutput,
    crate::error::GetContainerServiceDeploymentsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetContainerServiceDeploymentsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetContainerServiceDeploymentsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetContainerServiceDeploymentsError {
            meta: generic,
            kind: crate::error::GetContainerServiceDeploymentsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerServiceDeploymentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetContainerServiceDeploymentsError {
            meta: generic,
            kind: crate::error::GetContainerServiceDeploymentsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerServiceDeploymentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetContainerServiceDeploymentsError {
            meta: generic,
            kind: crate::error::GetContainerServiceDeploymentsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerServiceDeploymentsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetContainerServiceDeploymentsError {
                meta: generic,
                kind: crate::error::GetContainerServiceDeploymentsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerServiceDeploymentsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetContainerServiceDeploymentsError {
            meta: generic,
            kind: crate::error::GetContainerServiceDeploymentsErrorKind::UnauthenticatedException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unauthenticated_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerServiceDeploymentsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::GetContainerServiceDeploymentsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_container_service_deployments_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetContainerServiceDeploymentsOutput,
    crate::error::GetContainerServiceDeploymentsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_container_service_deployments_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_container_service_deployments(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetContainerServiceDeploymentsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_container_service_metric_data_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetContainerServiceMetricDataOutput,
    crate::error::GetContainerServiceMetricDataError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetContainerServiceMetricDataError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetContainerServiceMetricDataError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetContainerServiceMetricDataError {
            meta: generic,
            kind: crate::error::GetContainerServiceMetricDataErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerServiceMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetContainerServiceMetricDataError {
            meta: generic,
            kind: crate::error::GetContainerServiceMetricDataErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerServiceMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetContainerServiceMetricDataError {
            meta: generic,
            kind: crate::error::GetContainerServiceMetricDataErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerServiceMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetContainerServiceMetricDataError {
                meta: generic,
                kind: crate::error::GetContainerServiceMetricDataErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerServiceMetricDataError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetContainerServiceMetricDataError {
            meta: generic,
            kind: crate::error::GetContainerServiceMetricDataErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerServiceMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetContainerServiceMetricDataError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_container_service_metric_data_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetContainerServiceMetricDataOutput,
    crate::error::GetContainerServiceMetricDataError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_container_service_metric_data_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_container_service_metric_data(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetContainerServiceMetricDataError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_container_service_powers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetContainerServicePowersOutput,
    crate::error::GetContainerServicePowersError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetContainerServicePowersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetContainerServicePowersError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetContainerServicePowersError {
            meta: generic,
            kind: crate::error::GetContainerServicePowersErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerServicePowersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetContainerServicePowersError {
            meta: generic,
            kind: crate::error::GetContainerServicePowersErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerServicePowersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetContainerServicePowersError {
            meta: generic,
            kind: crate::error::GetContainerServicePowersErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerServicePowersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetContainerServicePowersError {
                meta: generic,
                kind: crate::error::GetContainerServicePowersErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerServicePowersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetContainerServicePowersError {
            meta: generic,
            kind: crate::error::GetContainerServicePowersErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerServicePowersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetContainerServicePowersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_container_service_powers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetContainerServicePowersOutput,
    crate::error::GetContainerServicePowersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_container_service_powers_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_container_service_powers(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetContainerServicePowersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_container_services_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetContainerServicesOutput,
    crate::error::GetContainerServicesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetContainerServicesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetContainerServicesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetContainerServicesError {
            meta: generic,
            kind: crate::error::GetContainerServicesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerServicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetContainerServicesError {
            meta: generic,
            kind: crate::error::GetContainerServicesErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerServicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetContainerServicesError {
            meta: generic,
            kind: crate::error::GetContainerServicesErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerServicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetContainerServicesError {
                meta: generic,
                kind: crate::error::GetContainerServicesErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerServicesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetContainerServicesError {
            meta: generic,
            kind: crate::error::GetContainerServicesErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetContainerServicesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetContainerServicesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_container_services_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetContainerServicesOutput,
    crate::error::GetContainerServicesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_container_services_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_container_services(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetContainerServicesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_disk_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDiskOutput, crate::error::GetDiskError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDiskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetDiskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetDiskError {
            meta: generic,
            kind: crate::error::GetDiskErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetDiskError {
            meta: generic,
            kind: crate::error::GetDiskErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetDiskError {
            meta: generic,
            kind: crate::error::GetDiskErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetDiskError {
            meta: generic,
            kind: crate::error::GetDiskErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetDiskError {
            meta: generic,
            kind: crate::error::GetDiskErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetDiskError {
                meta: generic,
                kind: crate::error::GetDiskErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiskError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetDiskError {
            meta: generic,
            kind: crate::error::GetDiskErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetDiskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_disk_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDiskOutput, crate::error::GetDiskError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_disk_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_disk(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetDiskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_disks_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDisksOutput, crate::error::GetDisksError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDisksError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetDisksError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetDisksError {
            meta: generic,
            kind: crate::error::GetDisksErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDisksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetDisksError {
            meta: generic,
            kind: crate::error::GetDisksErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDisksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetDisksError {
            meta: generic,
            kind: crate::error::GetDisksErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDisksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetDisksError {
            meta: generic,
            kind: crate::error::GetDisksErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDisksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetDisksError {
            meta: generic,
            kind: crate::error::GetDisksErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDisksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetDisksError {
                meta: generic,
                kind: crate::error::GetDisksErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDisksError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetDisksError {
            meta: generic,
            kind: crate::error::GetDisksErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDisksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetDisksError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_disks_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDisksOutput, crate::error::GetDisksError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_disks_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_disks(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetDisksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_disk_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDiskSnapshotOutput, crate::error::GetDiskSnapshotError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDiskSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetDiskSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetDiskSnapshotError {
            meta: generic,
            kind: crate::error::GetDiskSnapshotErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiskSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetDiskSnapshotError {
            meta: generic,
            kind: crate::error::GetDiskSnapshotErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiskSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetDiskSnapshotError {
            meta: generic,
            kind: crate::error::GetDiskSnapshotErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiskSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetDiskSnapshotError {
            meta: generic,
            kind: crate::error::GetDiskSnapshotErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiskSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetDiskSnapshotError {
            meta: generic,
            kind: crate::error::GetDiskSnapshotErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiskSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetDiskSnapshotError {
                meta: generic,
                kind: crate::error::GetDiskSnapshotErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiskSnapshotError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetDiskSnapshotError {
            meta: generic,
            kind: crate::error::GetDiskSnapshotErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiskSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetDiskSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_disk_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDiskSnapshotOutput, crate::error::GetDiskSnapshotError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_disk_snapshot_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_disk_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetDiskSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_disk_snapshots_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDiskSnapshotsOutput, crate::error::GetDiskSnapshotsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDiskSnapshotsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetDiskSnapshotsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetDiskSnapshotsError {
            meta: generic,
            kind: crate::error::GetDiskSnapshotsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiskSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetDiskSnapshotsError {
            meta: generic,
            kind: crate::error::GetDiskSnapshotsErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiskSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetDiskSnapshotsError {
            meta: generic,
            kind: crate::error::GetDiskSnapshotsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiskSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetDiskSnapshotsError {
            meta: generic,
            kind: crate::error::GetDiskSnapshotsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiskSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetDiskSnapshotsError {
            meta: generic,
            kind: crate::error::GetDiskSnapshotsErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiskSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetDiskSnapshotsError {
                meta: generic,
                kind: crate::error::GetDiskSnapshotsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiskSnapshotsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetDiskSnapshotsError {
            meta: generic,
            kind: crate::error::GetDiskSnapshotsErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDiskSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetDiskSnapshotsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_disk_snapshots_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDiskSnapshotsOutput, crate::error::GetDiskSnapshotsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_disk_snapshots_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_disk_snapshots(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetDiskSnapshotsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_distribution_bundles_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetDistributionBundlesOutput,
    crate::error::GetDistributionBundlesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDistributionBundlesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetDistributionBundlesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetDistributionBundlesError {
            meta: generic,
            kind: crate::error::GetDistributionBundlesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionBundlesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetDistributionBundlesError {
            meta: generic,
            kind: crate::error::GetDistributionBundlesErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionBundlesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetDistributionBundlesError {
            meta: generic,
            kind: crate::error::GetDistributionBundlesErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionBundlesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetDistributionBundlesError {
            meta: generic,
            kind: crate::error::GetDistributionBundlesErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionBundlesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetDistributionBundlesError {
                meta: generic,
                kind: crate::error::GetDistributionBundlesErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionBundlesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetDistributionBundlesError {
            meta: generic,
            kind: crate::error::GetDistributionBundlesErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionBundlesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetDistributionBundlesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_distribution_bundles_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetDistributionBundlesOutput,
    crate::error::GetDistributionBundlesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_distribution_bundles_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_distribution_bundles(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetDistributionBundlesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_distribution_latest_cache_reset_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetDistributionLatestCacheResetOutput,
    crate::error::GetDistributionLatestCacheResetError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDistributionLatestCacheResetError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetDistributionLatestCacheResetError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetDistributionLatestCacheResetError {
            meta: generic,
            kind: crate::error::GetDistributionLatestCacheResetErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionLatestCacheResetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetDistributionLatestCacheResetError {
            meta: generic,
            kind: crate::error::GetDistributionLatestCacheResetErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionLatestCacheResetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetDistributionLatestCacheResetError {
            meta: generic,
            kind: crate::error::GetDistributionLatestCacheResetErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionLatestCacheResetError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetDistributionLatestCacheResetError {
            meta: generic,
            kind: crate::error::GetDistributionLatestCacheResetErrorKind::OperationFailureException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::operation_failure_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionLatestCacheResetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ServiceException" => {
            crate::error::GetDistributionLatestCacheResetError {
                meta: generic,
                kind: crate::error::GetDistributionLatestCacheResetErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionLatestCacheResetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetDistributionLatestCacheResetError {
            meta: generic,
            kind: crate::error::GetDistributionLatestCacheResetErrorKind::UnauthenticatedException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::unauthenticated_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionLatestCacheResetError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::GetDistributionLatestCacheResetError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_distribution_latest_cache_reset_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetDistributionLatestCacheResetOutput,
    crate::error::GetDistributionLatestCacheResetError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_distribution_latest_cache_reset_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_distribution_latest_cache_reset(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetDistributionLatestCacheResetError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_distribution_metric_data_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetDistributionMetricDataOutput,
    crate::error::GetDistributionMetricDataError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDistributionMetricDataError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetDistributionMetricDataError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetDistributionMetricDataError {
            meta: generic,
            kind: crate::error::GetDistributionMetricDataErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetDistributionMetricDataError {
            meta: generic,
            kind: crate::error::GetDistributionMetricDataErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetDistributionMetricDataError {
            meta: generic,
            kind: crate::error::GetDistributionMetricDataErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetDistributionMetricDataError {
            meta: generic,
            kind: crate::error::GetDistributionMetricDataErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetDistributionMetricDataError {
                meta: generic,
                kind: crate::error::GetDistributionMetricDataErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionMetricDataError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetDistributionMetricDataError {
            meta: generic,
            kind: crate::error::GetDistributionMetricDataErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetDistributionMetricDataError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_distribution_metric_data_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetDistributionMetricDataOutput,
    crate::error::GetDistributionMetricDataError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_distribution_metric_data_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_distribution_metric_data(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetDistributionMetricDataError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_distributions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDistributionsOutput, crate::error::GetDistributionsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDistributionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetDistributionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetDistributionsError {
            meta: generic,
            kind: crate::error::GetDistributionsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetDistributionsError {
            meta: generic,
            kind: crate::error::GetDistributionsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetDistributionsError {
            meta: generic,
            kind: crate::error::GetDistributionsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetDistributionsError {
            meta: generic,
            kind: crate::error::GetDistributionsErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetDistributionsError {
                meta: generic,
                kind: crate::error::GetDistributionsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetDistributionsError {
            meta: generic,
            kind: crate::error::GetDistributionsErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDistributionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetDistributionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_distributions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDistributionsOutput, crate::error::GetDistributionsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_distributions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_distributions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetDistributionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_domain_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDomainOutput, crate::error::GetDomainError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDomainError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetDomainError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetDomainError {
            meta: generic,
            kind: crate::error::GetDomainErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetDomainError {
            meta: generic,
            kind: crate::error::GetDomainErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetDomainError {
            meta: generic,
            kind: crate::error::GetDomainErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetDomainError {
            meta: generic,
            kind: crate::error::GetDomainErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetDomainError {
            meta: generic,
            kind: crate::error::GetDomainErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetDomainError {
                meta: generic,
                kind: crate::error::GetDomainErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDomainError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetDomainError {
            meta: generic,
            kind: crate::error::GetDomainErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDomainError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetDomainError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_domain_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDomainOutput, crate::error::GetDomainError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_domain_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_domain(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetDomainError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_domains_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDomainsOutput, crate::error::GetDomainsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDomainsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetDomainsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetDomainsError {
            meta: generic,
            kind: crate::error::GetDomainsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDomainsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetDomainsError {
            meta: generic,
            kind: crate::error::GetDomainsErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDomainsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetDomainsError {
            meta: generic,
            kind: crate::error::GetDomainsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDomainsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetDomainsError {
            meta: generic,
            kind: crate::error::GetDomainsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDomainsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetDomainsError {
            meta: generic,
            kind: crate::error::GetDomainsErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDomainsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetDomainsError {
                meta: generic,
                kind: crate::error::GetDomainsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDomainsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetDomainsError {
            meta: generic,
            kind: crate::error::GetDomainsErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDomainsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetDomainsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_domains_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDomainsOutput, crate::error::GetDomainsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_domains_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_domains(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetDomainsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_export_snapshot_records_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetExportSnapshotRecordsOutput,
    crate::error::GetExportSnapshotRecordsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetExportSnapshotRecordsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetExportSnapshotRecordsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetExportSnapshotRecordsError {
            meta: generic,
            kind: crate::error::GetExportSnapshotRecordsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetExportSnapshotRecordsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetExportSnapshotRecordsError {
            meta: generic,
            kind: crate::error::GetExportSnapshotRecordsErrorKind::AccountSetupInProgressException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::account_setup_in_progress_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetExportSnapshotRecordsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidInputException" => crate::error::GetExportSnapshotRecordsError {
            meta: generic,
            kind: crate::error::GetExportSnapshotRecordsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetExportSnapshotRecordsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetExportSnapshotRecordsError {
            meta: generic,
            kind: crate::error::GetExportSnapshotRecordsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetExportSnapshotRecordsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetExportSnapshotRecordsError {
            meta: generic,
            kind: crate::error::GetExportSnapshotRecordsErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetExportSnapshotRecordsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetExportSnapshotRecordsError {
                meta: generic,
                kind: crate::error::GetExportSnapshotRecordsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetExportSnapshotRecordsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetExportSnapshotRecordsError {
            meta: generic,
            kind: crate::error::GetExportSnapshotRecordsErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetExportSnapshotRecordsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetExportSnapshotRecordsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_export_snapshot_records_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetExportSnapshotRecordsOutput,
    crate::error::GetExportSnapshotRecordsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_export_snapshot_records_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_export_snapshot_records(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetExportSnapshotRecordsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetInstanceOutput, crate::error::GetInstanceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetInstanceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetInstanceError {
            meta: generic,
            kind: crate::error::GetInstanceErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetInstanceError {
            meta: generic,
            kind: crate::error::GetInstanceErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetInstanceError {
            meta: generic,
            kind: crate::error::GetInstanceErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetInstanceError {
            meta: generic,
            kind: crate::error::GetInstanceErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetInstanceError {
            meta: generic,
            kind: crate::error::GetInstanceErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetInstanceError {
                meta: generic,
                kind: crate::error::GetInstanceErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetInstanceError {
            meta: generic,
            kind: crate::error::GetInstanceErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetInstanceOutput, crate::error::GetInstanceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_instance_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_instance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetInstanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_instance_access_details_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetInstanceAccessDetailsOutput,
    crate::error::GetInstanceAccessDetailsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetInstanceAccessDetailsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetInstanceAccessDetailsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetInstanceAccessDetailsError {
            meta: generic,
            kind: crate::error::GetInstanceAccessDetailsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceAccessDetailsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetInstanceAccessDetailsError {
            meta: generic,
            kind: crate::error::GetInstanceAccessDetailsErrorKind::AccountSetupInProgressException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::account_setup_in_progress_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceAccessDetailsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidInputException" => crate::error::GetInstanceAccessDetailsError {
            meta: generic,
            kind: crate::error::GetInstanceAccessDetailsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceAccessDetailsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetInstanceAccessDetailsError {
            meta: generic,
            kind: crate::error::GetInstanceAccessDetailsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceAccessDetailsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetInstanceAccessDetailsError {
            meta: generic,
            kind: crate::error::GetInstanceAccessDetailsErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceAccessDetailsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetInstanceAccessDetailsError {
                meta: generic,
                kind: crate::error::GetInstanceAccessDetailsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceAccessDetailsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetInstanceAccessDetailsError {
            meta: generic,
            kind: crate::error::GetInstanceAccessDetailsErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceAccessDetailsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetInstanceAccessDetailsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_instance_access_details_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetInstanceAccessDetailsOutput,
    crate::error::GetInstanceAccessDetailsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_instance_access_details_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_instance_access_details(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetInstanceAccessDetailsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_instance_metric_data_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetInstanceMetricDataOutput,
    crate::error::GetInstanceMetricDataError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetInstanceMetricDataError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetInstanceMetricDataError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetInstanceMetricDataError {
            meta: generic,
            kind: crate::error::GetInstanceMetricDataErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetInstanceMetricDataError {
            meta: generic,
            kind: crate::error::GetInstanceMetricDataErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetInstanceMetricDataError {
            meta: generic,
            kind: crate::error::GetInstanceMetricDataErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetInstanceMetricDataError {
            meta: generic,
            kind: crate::error::GetInstanceMetricDataErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetInstanceMetricDataError {
            meta: generic,
            kind: crate::error::GetInstanceMetricDataErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetInstanceMetricDataError {
                meta: generic,
                kind: crate::error::GetInstanceMetricDataErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceMetricDataError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetInstanceMetricDataError {
            meta: generic,
            kind: crate::error::GetInstanceMetricDataErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetInstanceMetricDataError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_instance_metric_data_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetInstanceMetricDataOutput,
    crate::error::GetInstanceMetricDataError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_instance_metric_data_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_instance_metric_data(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetInstanceMetricDataError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_instance_port_states_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetInstancePortStatesOutput,
    crate::error::GetInstancePortStatesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetInstancePortStatesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetInstancePortStatesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetInstancePortStatesError {
            meta: generic,
            kind: crate::error::GetInstancePortStatesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstancePortStatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetInstancePortStatesError {
            meta: generic,
            kind: crate::error::GetInstancePortStatesErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstancePortStatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetInstancePortStatesError {
            meta: generic,
            kind: crate::error::GetInstancePortStatesErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstancePortStatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetInstancePortStatesError {
            meta: generic,
            kind: crate::error::GetInstancePortStatesErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstancePortStatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetInstancePortStatesError {
            meta: generic,
            kind: crate::error::GetInstancePortStatesErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstancePortStatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetInstancePortStatesError {
                meta: generic,
                kind: crate::error::GetInstancePortStatesErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstancePortStatesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetInstancePortStatesError {
            meta: generic,
            kind: crate::error::GetInstancePortStatesErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstancePortStatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetInstancePortStatesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_instance_port_states_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetInstancePortStatesOutput,
    crate::error::GetInstancePortStatesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_instance_port_states_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_instance_port_states(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetInstancePortStatesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_instances_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetInstancesOutput, crate::error::GetInstancesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetInstancesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetInstancesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetInstancesError {
            meta: generic,
            kind: crate::error::GetInstancesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetInstancesError {
            meta: generic,
            kind: crate::error::GetInstancesErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetInstancesError {
            meta: generic,
            kind: crate::error::GetInstancesErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetInstancesError {
            meta: generic,
            kind: crate::error::GetInstancesErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetInstancesError {
            meta: generic,
            kind: crate::error::GetInstancesErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetInstancesError {
                meta: generic,
                kind: crate::error::GetInstancesErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstancesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetInstancesError {
            meta: generic,
            kind: crate::error::GetInstancesErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetInstancesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_instances_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetInstancesOutput, crate::error::GetInstancesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_instances_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_instances(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetInstancesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_instance_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetInstanceSnapshotOutput,
    crate::error::GetInstanceSnapshotError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetInstanceSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetInstanceSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetInstanceSnapshotError {
            meta: generic,
            kind: crate::error::GetInstanceSnapshotErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetInstanceSnapshotError {
            meta: generic,
            kind: crate::error::GetInstanceSnapshotErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetInstanceSnapshotError {
            meta: generic,
            kind: crate::error::GetInstanceSnapshotErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetInstanceSnapshotError {
            meta: generic,
            kind: crate::error::GetInstanceSnapshotErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetInstanceSnapshotError {
            meta: generic,
            kind: crate::error::GetInstanceSnapshotErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetInstanceSnapshotError {
                meta: generic,
                kind: crate::error::GetInstanceSnapshotErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceSnapshotError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetInstanceSnapshotError {
            meta: generic,
            kind: crate::error::GetInstanceSnapshotErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetInstanceSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_instance_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetInstanceSnapshotOutput,
    crate::error::GetInstanceSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_instance_snapshot_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_instance_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetInstanceSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_instance_snapshots_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetInstanceSnapshotsOutput,
    crate::error::GetInstanceSnapshotsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetInstanceSnapshotsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetInstanceSnapshotsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetInstanceSnapshotsError {
            meta: generic,
            kind: crate::error::GetInstanceSnapshotsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetInstanceSnapshotsError {
            meta: generic,
            kind: crate::error::GetInstanceSnapshotsErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetInstanceSnapshotsError {
            meta: generic,
            kind: crate::error::GetInstanceSnapshotsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetInstanceSnapshotsError {
            meta: generic,
            kind: crate::error::GetInstanceSnapshotsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetInstanceSnapshotsError {
            meta: generic,
            kind: crate::error::GetInstanceSnapshotsErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetInstanceSnapshotsError {
                meta: generic,
                kind: crate::error::GetInstanceSnapshotsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceSnapshotsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetInstanceSnapshotsError {
            meta: generic,
            kind: crate::error::GetInstanceSnapshotsErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetInstanceSnapshotsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_instance_snapshots_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetInstanceSnapshotsOutput,
    crate::error::GetInstanceSnapshotsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_instance_snapshots_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_instance_snapshots(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetInstanceSnapshotsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_instance_state_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetInstanceStateOutput, crate::error::GetInstanceStateError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetInstanceStateError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetInstanceStateError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetInstanceStateError {
            meta: generic,
            kind: crate::error::GetInstanceStateErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceStateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetInstanceStateError {
            meta: generic,
            kind: crate::error::GetInstanceStateErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceStateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetInstanceStateError {
            meta: generic,
            kind: crate::error::GetInstanceStateErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceStateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetInstanceStateError {
            meta: generic,
            kind: crate::error::GetInstanceStateErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceStateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetInstanceStateError {
            meta: generic,
            kind: crate::error::GetInstanceStateErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceStateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetInstanceStateError {
                meta: generic,
                kind: crate::error::GetInstanceStateErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceStateError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetInstanceStateError {
            meta: generic,
            kind: crate::error::GetInstanceStateErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetInstanceStateError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetInstanceStateError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_instance_state_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetInstanceStateOutput, crate::error::GetInstanceStateError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_instance_state_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_instance_state(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetInstanceStateError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_key_pair_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetKeyPairOutput, crate::error::GetKeyPairError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetKeyPairError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetKeyPairError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetKeyPairError {
            meta: generic,
            kind: crate::error::GetKeyPairErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetKeyPairError {
            meta: generic,
            kind: crate::error::GetKeyPairErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetKeyPairError {
            meta: generic,
            kind: crate::error::GetKeyPairErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetKeyPairError {
            meta: generic,
            kind: crate::error::GetKeyPairErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetKeyPairError {
            meta: generic,
            kind: crate::error::GetKeyPairErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetKeyPairError {
                meta: generic,
                kind: crate::error::GetKeyPairErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyPairError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetKeyPairError {
            meta: generic,
            kind: crate::error::GetKeyPairErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetKeyPairError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_key_pair_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetKeyPairOutput, crate::error::GetKeyPairError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_key_pair_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_key_pair(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetKeyPairError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_key_pairs_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetKeyPairsOutput, crate::error::GetKeyPairsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetKeyPairsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetKeyPairsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetKeyPairsError {
            meta: generic,
            kind: crate::error::GetKeyPairsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyPairsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetKeyPairsError {
            meta: generic,
            kind: crate::error::GetKeyPairsErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyPairsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetKeyPairsError {
            meta: generic,
            kind: crate::error::GetKeyPairsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyPairsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetKeyPairsError {
            meta: generic,
            kind: crate::error::GetKeyPairsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyPairsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetKeyPairsError {
            meta: generic,
            kind: crate::error::GetKeyPairsErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyPairsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetKeyPairsError {
                meta: generic,
                kind: crate::error::GetKeyPairsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyPairsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetKeyPairsError {
            meta: generic,
            kind: crate::error::GetKeyPairsErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetKeyPairsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetKeyPairsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_key_pairs_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetKeyPairsOutput, crate::error::GetKeyPairsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_key_pairs_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_key_pairs(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetKeyPairsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_load_balancer_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetLoadBalancerOutput, crate::error::GetLoadBalancerError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetLoadBalancerError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetLoadBalancerError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetLoadBalancerError {
            meta: generic,
            kind: crate::error::GetLoadBalancerErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetLoadBalancerError {
            meta: generic,
            kind: crate::error::GetLoadBalancerErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetLoadBalancerError {
            meta: generic,
            kind: crate::error::GetLoadBalancerErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetLoadBalancerError {
            meta: generic,
            kind: crate::error::GetLoadBalancerErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetLoadBalancerError {
            meta: generic,
            kind: crate::error::GetLoadBalancerErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetLoadBalancerError {
                meta: generic,
                kind: crate::error::GetLoadBalancerErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancerError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetLoadBalancerError {
            meta: generic,
            kind: crate::error::GetLoadBalancerErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancerError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetLoadBalancerError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_load_balancer_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetLoadBalancerOutput, crate::error::GetLoadBalancerError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_load_balancer_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_load_balancer(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetLoadBalancerError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_load_balancer_metric_data_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetLoadBalancerMetricDataOutput,
    crate::error::GetLoadBalancerMetricDataError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetLoadBalancerMetricDataError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetLoadBalancerMetricDataError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetLoadBalancerMetricDataError {
            meta: generic,
            kind: crate::error::GetLoadBalancerMetricDataErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancerMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetLoadBalancerMetricDataError {
            meta: generic,
            kind: crate::error::GetLoadBalancerMetricDataErrorKind::AccountSetupInProgressException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::account_setup_in_progress_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancerMetricDataError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidInputException" => crate::error::GetLoadBalancerMetricDataError {
            meta: generic,
            kind: crate::error::GetLoadBalancerMetricDataErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancerMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetLoadBalancerMetricDataError {
            meta: generic,
            kind: crate::error::GetLoadBalancerMetricDataErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancerMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetLoadBalancerMetricDataError {
            meta: generic,
            kind: crate::error::GetLoadBalancerMetricDataErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancerMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetLoadBalancerMetricDataError {
                meta: generic,
                kind: crate::error::GetLoadBalancerMetricDataErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancerMetricDataError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetLoadBalancerMetricDataError {
            meta: generic,
            kind: crate::error::GetLoadBalancerMetricDataErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancerMetricDataError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetLoadBalancerMetricDataError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_load_balancer_metric_data_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetLoadBalancerMetricDataOutput,
    crate::error::GetLoadBalancerMetricDataError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_load_balancer_metric_data_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_load_balancer_metric_data(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetLoadBalancerMetricDataError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_load_balancers_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetLoadBalancersOutput, crate::error::GetLoadBalancersError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetLoadBalancersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetLoadBalancersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetLoadBalancersError {
            meta: generic,
            kind: crate::error::GetLoadBalancersErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetLoadBalancersError {
            meta: generic,
            kind: crate::error::GetLoadBalancersErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetLoadBalancersError {
            meta: generic,
            kind: crate::error::GetLoadBalancersErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetLoadBalancersError {
            meta: generic,
            kind: crate::error::GetLoadBalancersErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetLoadBalancersError {
            meta: generic,
            kind: crate::error::GetLoadBalancersErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetLoadBalancersError {
                meta: generic,
                kind: crate::error::GetLoadBalancersErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetLoadBalancersError {
            meta: generic,
            kind: crate::error::GetLoadBalancersErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetLoadBalancersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_load_balancers_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetLoadBalancersOutput, crate::error::GetLoadBalancersError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_load_balancers_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_load_balancers(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetLoadBalancersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_load_balancer_tls_certificates_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetLoadBalancerTlsCertificatesOutput,
    crate::error::GetLoadBalancerTlsCertificatesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetLoadBalancerTlsCertificatesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetLoadBalancerTlsCertificatesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetLoadBalancerTlsCertificatesError { meta: generic, kind: crate::error::GetLoadBalancerTlsCertificatesErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancerTlsCertificatesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountSetupInProgressException" => crate::error::GetLoadBalancerTlsCertificatesError { meta: generic, kind: crate::error::GetLoadBalancerTlsCertificatesErrorKind::AccountSetupInProgressException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancerTlsCertificatesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::GetLoadBalancerTlsCertificatesError { meta: generic, kind: crate::error::GetLoadBalancerTlsCertificatesErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancerTlsCertificatesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotFoundException" => crate::error::GetLoadBalancerTlsCertificatesError { meta: generic, kind: crate::error::GetLoadBalancerTlsCertificatesErrorKind::NotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancerTlsCertificatesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationFailureException" => crate::error::GetLoadBalancerTlsCertificatesError { meta: generic, kind: crate::error::GetLoadBalancerTlsCertificatesErrorKind::OperationFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancerTlsCertificatesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::GetLoadBalancerTlsCertificatesError { meta: generic, kind: crate::error::GetLoadBalancerTlsCertificatesErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancerTlsCertificatesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthenticatedException" => crate::error::GetLoadBalancerTlsCertificatesError { meta: generic, kind: crate::error::GetLoadBalancerTlsCertificatesErrorKind::UnauthenticatedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetLoadBalancerTlsCertificatesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetLoadBalancerTlsCertificatesError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_load_balancer_tls_certificates_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetLoadBalancerTlsCertificatesOutput,
    crate::error::GetLoadBalancerTlsCertificatesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_load_balancer_tls_certificates_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_load_balancer_tls_certificates(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetLoadBalancerTlsCertificatesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_operation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetOperationOutput, crate::error::GetOperationError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetOperationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetOperationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetOperationError {
            meta: generic,
            kind: crate::error::GetOperationErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetOperationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetOperationError {
            meta: generic,
            kind: crate::error::GetOperationErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetOperationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetOperationError {
            meta: generic,
            kind: crate::error::GetOperationErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetOperationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetOperationError {
            meta: generic,
            kind: crate::error::GetOperationErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetOperationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetOperationError {
            meta: generic,
            kind: crate::error::GetOperationErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetOperationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetOperationError {
                meta: generic,
                kind: crate::error::GetOperationErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetOperationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetOperationError {
            meta: generic,
            kind: crate::error::GetOperationErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetOperationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetOperationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_operation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetOperationOutput, crate::error::GetOperationError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_operation_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_operation(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetOperationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_operations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetOperationsOutput, crate::error::GetOperationsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetOperationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetOperationsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetOperationsError {
            meta: generic,
            kind: crate::error::GetOperationsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetOperationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetOperationsError {
            meta: generic,
            kind: crate::error::GetOperationsErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetOperationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetOperationsError {
            meta: generic,
            kind: crate::error::GetOperationsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetOperationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetOperationsError {
            meta: generic,
            kind: crate::error::GetOperationsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetOperationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetOperationsError {
            meta: generic,
            kind: crate::error::GetOperationsErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetOperationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetOperationsError {
                meta: generic,
                kind: crate::error::GetOperationsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetOperationsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetOperationsError {
            meta: generic,
            kind: crate::error::GetOperationsErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetOperationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetOperationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_operations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetOperationsOutput, crate::error::GetOperationsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_operations_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_operations(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetOperationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_operations_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetOperationsForResourceOutput,
    crate::error::GetOperationsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetOperationsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetOperationsForResourceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetOperationsForResourceError {
            meta: generic,
            kind: crate::error::GetOperationsForResourceErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetOperationsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetOperationsForResourceError {
            meta: generic,
            kind: crate::error::GetOperationsForResourceErrorKind::AccountSetupInProgressException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::account_setup_in_progress_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetOperationsForResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidInputException" => crate::error::GetOperationsForResourceError {
            meta: generic,
            kind: crate::error::GetOperationsForResourceErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetOperationsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetOperationsForResourceError {
            meta: generic,
            kind: crate::error::GetOperationsForResourceErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetOperationsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetOperationsForResourceError {
            meta: generic,
            kind: crate::error::GetOperationsForResourceErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetOperationsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetOperationsForResourceError {
                meta: generic,
                kind: crate::error::GetOperationsForResourceErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetOperationsForResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetOperationsForResourceError {
            meta: generic,
            kind: crate::error::GetOperationsForResourceErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetOperationsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetOperationsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_operations_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetOperationsForResourceOutput,
    crate::error::GetOperationsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_operations_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_operations_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetOperationsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_regions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRegionsOutput, crate::error::GetRegionsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRegionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRegionsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetRegionsError {
            meta: generic,
            kind: crate::error::GetRegionsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetRegionsError {
            meta: generic,
            kind: crate::error::GetRegionsErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetRegionsError {
            meta: generic,
            kind: crate::error::GetRegionsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetRegionsError {
            meta: generic,
            kind: crate::error::GetRegionsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetRegionsError {
            meta: generic,
            kind: crate::error::GetRegionsErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetRegionsError {
                meta: generic,
                kind: crate::error::GetRegionsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetRegionsError {
            meta: generic,
            kind: crate::error::GetRegionsErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRegionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRegionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_regions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetRegionsOutput, crate::error::GetRegionsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_regions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_regions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRegionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_database_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabaseOutput,
    crate::error::GetRelationalDatabaseError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRelationalDatabaseError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRelationalDatabaseError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetRelationalDatabaseError {
            meta: generic,
            kind: crate::error::GetRelationalDatabaseErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetRelationalDatabaseError {
            meta: generic,
            kind: crate::error::GetRelationalDatabaseErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetRelationalDatabaseError {
            meta: generic,
            kind: crate::error::GetRelationalDatabaseErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetRelationalDatabaseError {
            meta: generic,
            kind: crate::error::GetRelationalDatabaseErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetRelationalDatabaseError {
            meta: generic,
            kind: crate::error::GetRelationalDatabaseErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetRelationalDatabaseError {
                meta: generic,
                kind: crate::error::GetRelationalDatabaseErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetRelationalDatabaseError {
            meta: generic,
            kind: crate::error::GetRelationalDatabaseErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRelationalDatabaseError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_database_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabaseOutput,
    crate::error::GetRelationalDatabaseError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_relational_database_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_relational_database(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRelationalDatabaseError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_database_blueprints_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabaseBlueprintsOutput,
    crate::error::GetRelationalDatabaseBlueprintsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRelationalDatabaseBlueprintsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRelationalDatabaseBlueprintsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetRelationalDatabaseBlueprintsError { meta: generic, kind: crate::error::GetRelationalDatabaseBlueprintsErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseBlueprintsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountSetupInProgressException" => crate::error::GetRelationalDatabaseBlueprintsError { meta: generic, kind: crate::error::GetRelationalDatabaseBlueprintsErrorKind::AccountSetupInProgressException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseBlueprintsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::GetRelationalDatabaseBlueprintsError { meta: generic, kind: crate::error::GetRelationalDatabaseBlueprintsErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseBlueprintsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotFoundException" => crate::error::GetRelationalDatabaseBlueprintsError { meta: generic, kind: crate::error::GetRelationalDatabaseBlueprintsErrorKind::NotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseBlueprintsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationFailureException" => crate::error::GetRelationalDatabaseBlueprintsError { meta: generic, kind: crate::error::GetRelationalDatabaseBlueprintsErrorKind::OperationFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseBlueprintsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::GetRelationalDatabaseBlueprintsError { meta: generic, kind: crate::error::GetRelationalDatabaseBlueprintsErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseBlueprintsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthenticatedException" => crate::error::GetRelationalDatabaseBlueprintsError { meta: generic, kind: crate::error::GetRelationalDatabaseBlueprintsErrorKind::UnauthenticatedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseBlueprintsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetRelationalDatabaseBlueprintsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_database_blueprints_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabaseBlueprintsOutput,
    crate::error::GetRelationalDatabaseBlueprintsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_relational_database_blueprints_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_relational_database_blueprints(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetRelationalDatabaseBlueprintsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_database_bundles_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabaseBundlesOutput,
    crate::error::GetRelationalDatabaseBundlesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRelationalDatabaseBundlesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetRelationalDatabaseBundlesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetRelationalDatabaseBundlesError {
            meta: generic,
            kind: crate::error::GetRelationalDatabaseBundlesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseBundlesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetRelationalDatabaseBundlesError {
            meta: generic,
            kind:
                crate::error::GetRelationalDatabaseBundlesErrorKind::AccountSetupInProgressException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::account_setup_in_progress_exception::Builder::default(
                                );
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseBundlesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidInputException" => crate::error::GetRelationalDatabaseBundlesError {
            meta: generic,
            kind: crate::error::GetRelationalDatabaseBundlesErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseBundlesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetRelationalDatabaseBundlesError {
            meta: generic,
            kind: crate::error::GetRelationalDatabaseBundlesErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseBundlesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetRelationalDatabaseBundlesError {
            meta: generic,
            kind: crate::error::GetRelationalDatabaseBundlesErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseBundlesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetRelationalDatabaseBundlesError {
                meta: generic,
                kind: crate::error::GetRelationalDatabaseBundlesErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseBundlesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetRelationalDatabaseBundlesError {
            meta: generic,
            kind: crate::error::GetRelationalDatabaseBundlesErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseBundlesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRelationalDatabaseBundlesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_database_bundles_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabaseBundlesOutput,
    crate::error::GetRelationalDatabaseBundlesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_relational_database_bundles_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_relational_database_bundles(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetRelationalDatabaseBundlesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_database_events_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabaseEventsOutput,
    crate::error::GetRelationalDatabaseEventsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRelationalDatabaseEventsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetRelationalDatabaseEventsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetRelationalDatabaseEventsError {
            meta: generic,
            kind: crate::error::GetRelationalDatabaseEventsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseEventsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetRelationalDatabaseEventsError {
            meta: generic,
            kind:
                crate::error::GetRelationalDatabaseEventsErrorKind::AccountSetupInProgressException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::account_setup_in_progress_exception::Builder::default(
                                );
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseEventsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidInputException" => crate::error::GetRelationalDatabaseEventsError {
            meta: generic,
            kind: crate::error::GetRelationalDatabaseEventsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseEventsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetRelationalDatabaseEventsError {
            meta: generic,
            kind: crate::error::GetRelationalDatabaseEventsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseEventsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetRelationalDatabaseEventsError {
            meta: generic,
            kind: crate::error::GetRelationalDatabaseEventsErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseEventsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetRelationalDatabaseEventsError {
                meta: generic,
                kind: crate::error::GetRelationalDatabaseEventsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseEventsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetRelationalDatabaseEventsError {
            meta: generic,
            kind: crate::error::GetRelationalDatabaseEventsErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseEventsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRelationalDatabaseEventsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_database_events_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabaseEventsOutput,
    crate::error::GetRelationalDatabaseEventsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_relational_database_events_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_relational_database_events(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRelationalDatabaseEventsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_database_log_events_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabaseLogEventsOutput,
    crate::error::GetRelationalDatabaseLogEventsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRelationalDatabaseLogEventsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRelationalDatabaseLogEventsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetRelationalDatabaseLogEventsError { meta: generic, kind: crate::error::GetRelationalDatabaseLogEventsErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseLogEventsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountSetupInProgressException" => crate::error::GetRelationalDatabaseLogEventsError { meta: generic, kind: crate::error::GetRelationalDatabaseLogEventsErrorKind::AccountSetupInProgressException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseLogEventsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::GetRelationalDatabaseLogEventsError { meta: generic, kind: crate::error::GetRelationalDatabaseLogEventsErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseLogEventsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotFoundException" => crate::error::GetRelationalDatabaseLogEventsError { meta: generic, kind: crate::error::GetRelationalDatabaseLogEventsErrorKind::NotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseLogEventsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationFailureException" => crate::error::GetRelationalDatabaseLogEventsError { meta: generic, kind: crate::error::GetRelationalDatabaseLogEventsErrorKind::OperationFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseLogEventsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::GetRelationalDatabaseLogEventsError { meta: generic, kind: crate::error::GetRelationalDatabaseLogEventsErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseLogEventsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthenticatedException" => crate::error::GetRelationalDatabaseLogEventsError { meta: generic, kind: crate::error::GetRelationalDatabaseLogEventsErrorKind::UnauthenticatedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseLogEventsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetRelationalDatabaseLogEventsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_database_log_events_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabaseLogEventsOutput,
    crate::error::GetRelationalDatabaseLogEventsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_relational_database_log_events_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_relational_database_log_events(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetRelationalDatabaseLogEventsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_database_log_streams_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabaseLogStreamsOutput,
    crate::error::GetRelationalDatabaseLogStreamsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRelationalDatabaseLogStreamsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRelationalDatabaseLogStreamsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetRelationalDatabaseLogStreamsError { meta: generic, kind: crate::error::GetRelationalDatabaseLogStreamsErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseLogStreamsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountSetupInProgressException" => crate::error::GetRelationalDatabaseLogStreamsError { meta: generic, kind: crate::error::GetRelationalDatabaseLogStreamsErrorKind::AccountSetupInProgressException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseLogStreamsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::GetRelationalDatabaseLogStreamsError { meta: generic, kind: crate::error::GetRelationalDatabaseLogStreamsErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseLogStreamsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotFoundException" => crate::error::GetRelationalDatabaseLogStreamsError { meta: generic, kind: crate::error::GetRelationalDatabaseLogStreamsErrorKind::NotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseLogStreamsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationFailureException" => crate::error::GetRelationalDatabaseLogStreamsError { meta: generic, kind: crate::error::GetRelationalDatabaseLogStreamsErrorKind::OperationFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseLogStreamsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::GetRelationalDatabaseLogStreamsError { meta: generic, kind: crate::error::GetRelationalDatabaseLogStreamsErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseLogStreamsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthenticatedException" => crate::error::GetRelationalDatabaseLogStreamsError { meta: generic, kind: crate::error::GetRelationalDatabaseLogStreamsErrorKind::UnauthenticatedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseLogStreamsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetRelationalDatabaseLogStreamsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_database_log_streams_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabaseLogStreamsOutput,
    crate::error::GetRelationalDatabaseLogStreamsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_relational_database_log_streams_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_relational_database_log_streams(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetRelationalDatabaseLogStreamsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_database_master_user_password_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabaseMasterUserPasswordOutput,
    crate::error::GetRelationalDatabaseMasterUserPasswordError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRelationalDatabaseMasterUserPasswordError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::GetRelationalDatabaseMasterUserPasswordError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetRelationalDatabaseMasterUserPasswordError { meta: generic, kind: crate::error::GetRelationalDatabaseMasterUserPasswordErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseMasterUserPasswordError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountSetupInProgressException" => crate::error::GetRelationalDatabaseMasterUserPasswordError { meta: generic, kind: crate::error::GetRelationalDatabaseMasterUserPasswordErrorKind::AccountSetupInProgressException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseMasterUserPasswordError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::GetRelationalDatabaseMasterUserPasswordError { meta: generic, kind: crate::error::GetRelationalDatabaseMasterUserPasswordErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseMasterUserPasswordError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotFoundException" => crate::error::GetRelationalDatabaseMasterUserPasswordError { meta: generic, kind: crate::error::GetRelationalDatabaseMasterUserPasswordErrorKind::NotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseMasterUserPasswordError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationFailureException" => crate::error::GetRelationalDatabaseMasterUserPasswordError { meta: generic, kind: crate::error::GetRelationalDatabaseMasterUserPasswordErrorKind::OperationFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseMasterUserPasswordError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::GetRelationalDatabaseMasterUserPasswordError { meta: generic, kind: crate::error::GetRelationalDatabaseMasterUserPasswordErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseMasterUserPasswordError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthenticatedException" => crate::error::GetRelationalDatabaseMasterUserPasswordError { meta: generic, kind: crate::error::GetRelationalDatabaseMasterUserPasswordErrorKind::UnauthenticatedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseMasterUserPasswordError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetRelationalDatabaseMasterUserPasswordError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_database_master_user_password_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabaseMasterUserPasswordOutput,
    crate::error::GetRelationalDatabaseMasterUserPasswordError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_relational_database_master_user_password_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_relational_database_master_user_password(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseMasterUserPasswordError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_database_metric_data_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabaseMetricDataOutput,
    crate::error::GetRelationalDatabaseMetricDataError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRelationalDatabaseMetricDataError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRelationalDatabaseMetricDataError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetRelationalDatabaseMetricDataError { meta: generic, kind: crate::error::GetRelationalDatabaseMetricDataErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseMetricDataError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountSetupInProgressException" => crate::error::GetRelationalDatabaseMetricDataError { meta: generic, kind: crate::error::GetRelationalDatabaseMetricDataErrorKind::AccountSetupInProgressException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseMetricDataError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::GetRelationalDatabaseMetricDataError { meta: generic, kind: crate::error::GetRelationalDatabaseMetricDataErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseMetricDataError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotFoundException" => crate::error::GetRelationalDatabaseMetricDataError { meta: generic, kind: crate::error::GetRelationalDatabaseMetricDataErrorKind::NotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseMetricDataError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationFailureException" => crate::error::GetRelationalDatabaseMetricDataError { meta: generic, kind: crate::error::GetRelationalDatabaseMetricDataErrorKind::OperationFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseMetricDataError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::GetRelationalDatabaseMetricDataError { meta: generic, kind: crate::error::GetRelationalDatabaseMetricDataErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseMetricDataError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthenticatedException" => crate::error::GetRelationalDatabaseMetricDataError { meta: generic, kind: crate::error::GetRelationalDatabaseMetricDataErrorKind::UnauthenticatedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseMetricDataError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetRelationalDatabaseMetricDataError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_database_metric_data_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabaseMetricDataOutput,
    crate::error::GetRelationalDatabaseMetricDataError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_relational_database_metric_data_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_relational_database_metric_data(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetRelationalDatabaseMetricDataError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_database_parameters_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabaseParametersOutput,
    crate::error::GetRelationalDatabaseParametersError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRelationalDatabaseParametersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRelationalDatabaseParametersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetRelationalDatabaseParametersError { meta: generic, kind: crate::error::GetRelationalDatabaseParametersErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseParametersError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountSetupInProgressException" => crate::error::GetRelationalDatabaseParametersError { meta: generic, kind: crate::error::GetRelationalDatabaseParametersErrorKind::AccountSetupInProgressException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseParametersError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::GetRelationalDatabaseParametersError { meta: generic, kind: crate::error::GetRelationalDatabaseParametersErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseParametersError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotFoundException" => crate::error::GetRelationalDatabaseParametersError { meta: generic, kind: crate::error::GetRelationalDatabaseParametersErrorKind::NotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseParametersError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationFailureException" => crate::error::GetRelationalDatabaseParametersError { meta: generic, kind: crate::error::GetRelationalDatabaseParametersErrorKind::OperationFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseParametersError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::GetRelationalDatabaseParametersError { meta: generic, kind: crate::error::GetRelationalDatabaseParametersErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseParametersError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthenticatedException" => crate::error::GetRelationalDatabaseParametersError { meta: generic, kind: crate::error::GetRelationalDatabaseParametersErrorKind::UnauthenticatedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseParametersError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetRelationalDatabaseParametersError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_database_parameters_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabaseParametersOutput,
    crate::error::GetRelationalDatabaseParametersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_relational_database_parameters_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_relational_database_parameters(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetRelationalDatabaseParametersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_databases_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabasesOutput,
    crate::error::GetRelationalDatabasesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRelationalDatabasesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetRelationalDatabasesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetRelationalDatabasesError {
            meta: generic,
            kind: crate::error::GetRelationalDatabasesErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetRelationalDatabasesError {
            meta: generic,
            kind: crate::error::GetRelationalDatabasesErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetRelationalDatabasesError {
            meta: generic,
            kind: crate::error::GetRelationalDatabasesErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetRelationalDatabasesError {
            meta: generic,
            kind: crate::error::GetRelationalDatabasesErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetRelationalDatabasesError {
            meta: generic,
            kind: crate::error::GetRelationalDatabasesErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetRelationalDatabasesError {
                meta: generic,
                kind: crate::error::GetRelationalDatabasesErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabasesError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetRelationalDatabasesError {
            meta: generic,
            kind: crate::error::GetRelationalDatabasesErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabasesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRelationalDatabasesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_databases_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabasesOutput,
    crate::error::GetRelationalDatabasesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_relational_databases_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_relational_databases(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRelationalDatabasesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_database_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabaseSnapshotOutput,
    crate::error::GetRelationalDatabaseSnapshotError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRelationalDatabaseSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetRelationalDatabaseSnapshotError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetRelationalDatabaseSnapshotError { meta: generic, kind: crate::error::GetRelationalDatabaseSnapshotErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountSetupInProgressException" => crate::error::GetRelationalDatabaseSnapshotError { meta: generic, kind: crate::error::GetRelationalDatabaseSnapshotErrorKind::AccountSetupInProgressException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::GetRelationalDatabaseSnapshotError { meta: generic, kind: crate::error::GetRelationalDatabaseSnapshotErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotFoundException" => crate::error::GetRelationalDatabaseSnapshotError { meta: generic, kind: crate::error::GetRelationalDatabaseSnapshotErrorKind::NotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationFailureException" => crate::error::GetRelationalDatabaseSnapshotError { meta: generic, kind: crate::error::GetRelationalDatabaseSnapshotErrorKind::OperationFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::GetRelationalDatabaseSnapshotError { meta: generic, kind: crate::error::GetRelationalDatabaseSnapshotErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthenticatedException" => crate::error::GetRelationalDatabaseSnapshotError { meta: generic, kind: crate::error::GetRelationalDatabaseSnapshotErrorKind::UnauthenticatedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetRelationalDatabaseSnapshotError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_database_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabaseSnapshotOutput,
    crate::error::GetRelationalDatabaseSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_relational_database_snapshot_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_relational_database_snapshot(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetRelationalDatabaseSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_database_snapshots_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabaseSnapshotsOutput,
    crate::error::GetRelationalDatabaseSnapshotsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRelationalDatabaseSnapshotsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetRelationalDatabaseSnapshotsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetRelationalDatabaseSnapshotsError { meta: generic, kind: crate::error::GetRelationalDatabaseSnapshotsErrorKind::AccessDeniedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseSnapshotsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AccountSetupInProgressException" => crate::error::GetRelationalDatabaseSnapshotsError { meta: generic, kind: crate::error::GetRelationalDatabaseSnapshotsErrorKind::AccountSetupInProgressException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseSnapshotsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::GetRelationalDatabaseSnapshotsError { meta: generic, kind: crate::error::GetRelationalDatabaseSnapshotsErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseSnapshotsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "NotFoundException" => crate::error::GetRelationalDatabaseSnapshotsError { meta: generic, kind: crate::error::GetRelationalDatabaseSnapshotsErrorKind::NotFoundException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseSnapshotsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OperationFailureException" => crate::error::GetRelationalDatabaseSnapshotsError { meta: generic, kind: crate::error::GetRelationalDatabaseSnapshotsErrorKind::OperationFailureException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseSnapshotsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ServiceException" => crate::error::GetRelationalDatabaseSnapshotsError { meta: generic, kind: crate::error::GetRelationalDatabaseSnapshotsErrorKind::ServiceException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::service_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseSnapshotsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "UnauthenticatedException" => crate::error::GetRelationalDatabaseSnapshotsError { meta: generic, kind: crate::error::GetRelationalDatabaseSnapshotsErrorKind::UnauthenticatedException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRelationalDatabaseSnapshotsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetRelationalDatabaseSnapshotsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_relational_database_snapshots_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRelationalDatabaseSnapshotsOutput,
    crate::error::GetRelationalDatabaseSnapshotsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_relational_database_snapshots_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_relational_database_snapshots(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetRelationalDatabaseSnapshotsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_static_ip_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetStaticIpOutput, crate::error::GetStaticIpError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetStaticIpError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetStaticIpError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetStaticIpError {
            meta: generic,
            kind: crate::error::GetStaticIpErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetStaticIpError {
            meta: generic,
            kind: crate::error::GetStaticIpErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetStaticIpError {
            meta: generic,
            kind: crate::error::GetStaticIpErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetStaticIpError {
            meta: generic,
            kind: crate::error::GetStaticIpErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetStaticIpError {
            meta: generic,
            kind: crate::error::GetStaticIpErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetStaticIpError {
                meta: generic,
                kind: crate::error::GetStaticIpErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetStaticIpError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetStaticIpError {
            meta: generic,
            kind: crate::error::GetStaticIpErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetStaticIpError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_static_ip_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetStaticIpOutput, crate::error::GetStaticIpError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_static_ip_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_static_ip(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetStaticIpError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_static_ips_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetStaticIpsOutput, crate::error::GetStaticIpsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetStaticIpsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetStaticIpsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetStaticIpsError {
            meta: generic,
            kind: crate::error::GetStaticIpsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetStaticIpsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::GetStaticIpsError {
            meta: generic,
            kind: crate::error::GetStaticIpsErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetStaticIpsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetStaticIpsError {
            meta: generic,
            kind: crate::error::GetStaticIpsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetStaticIpsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::GetStaticIpsError {
            meta: generic,
            kind: crate::error::GetStaticIpsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetStaticIpsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::GetStaticIpsError {
            meta: generic,
            kind: crate::error::GetStaticIpsErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetStaticIpsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::GetStaticIpsError {
                meta: generic,
                kind: crate::error::GetStaticIpsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetStaticIpsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::GetStaticIpsError {
            meta: generic,
            kind: crate::error::GetStaticIpsErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetStaticIpsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetStaticIpsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_static_ips_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetStaticIpsOutput, crate::error::GetStaticIpsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_static_ips_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_static_ips(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetStaticIpsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_import_key_pair_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ImportKeyPairOutput, crate::error::ImportKeyPairError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ImportKeyPairError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ImportKeyPairError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ImportKeyPairError {
            meta: generic,
            kind: crate::error::ImportKeyPairErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::ImportKeyPairError {
            meta: generic,
            kind: crate::error::ImportKeyPairErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::ImportKeyPairError {
            meta: generic,
            kind: crate::error::ImportKeyPairErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::ImportKeyPairError {
            meta: generic,
            kind: crate::error::ImportKeyPairErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::ImportKeyPairError {
            meta: generic,
            kind: crate::error::ImportKeyPairErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ImportKeyPairError {
                meta: generic,
                kind: crate::error::ImportKeyPairErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportKeyPairError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::ImportKeyPairError {
            meta: generic,
            kind: crate::error::ImportKeyPairErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ImportKeyPairError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ImportKeyPairError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_import_key_pair_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ImportKeyPairOutput, crate::error::ImportKeyPairError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::import_key_pair_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_import_key_pair(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ImportKeyPairError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_is_vpc_peered_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::IsVpcPeeredOutput, crate::error::IsVpcPeeredError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::IsVpcPeeredError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::IsVpcPeeredError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::IsVpcPeeredError {
            meta: generic,
            kind: crate::error::IsVpcPeeredErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::IsVpcPeeredError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::IsVpcPeeredError {
            meta: generic,
            kind: crate::error::IsVpcPeeredErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::IsVpcPeeredError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::IsVpcPeeredError {
            meta: generic,
            kind: crate::error::IsVpcPeeredErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::IsVpcPeeredError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::IsVpcPeeredError {
            meta: generic,
            kind: crate::error::IsVpcPeeredErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::IsVpcPeeredError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::IsVpcPeeredError {
            meta: generic,
            kind: crate::error::IsVpcPeeredErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::IsVpcPeeredError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::IsVpcPeeredError {
                meta: generic,
                kind: crate::error::IsVpcPeeredErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::IsVpcPeeredError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::IsVpcPeeredError {
            meta: generic,
            kind: crate::error::IsVpcPeeredErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::IsVpcPeeredError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::IsVpcPeeredError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_is_vpc_peered_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::IsVpcPeeredOutput, crate::error::IsVpcPeeredError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::is_vpc_peered_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_is_vpc_peered(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::IsVpcPeeredError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_open_instance_public_ports_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::OpenInstancePublicPortsOutput,
    crate::error::OpenInstancePublicPortsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::OpenInstancePublicPortsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::OpenInstancePublicPortsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::OpenInstancePublicPortsError {
            meta: generic,
            kind: crate::error::OpenInstancePublicPortsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::OpenInstancePublicPortsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::OpenInstancePublicPortsError {
            meta: generic,
            kind: crate::error::OpenInstancePublicPortsErrorKind::AccountSetupInProgressException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::account_setup_in_progress_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::OpenInstancePublicPortsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidInputException" => crate::error::OpenInstancePublicPortsError {
            meta: generic,
            kind: crate::error::OpenInstancePublicPortsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::OpenInstancePublicPortsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::OpenInstancePublicPortsError {
            meta: generic,
            kind: crate::error::OpenInstancePublicPortsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::OpenInstancePublicPortsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::OpenInstancePublicPortsError {
            meta: generic,
            kind: crate::error::OpenInstancePublicPortsErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::OpenInstancePublicPortsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::OpenInstancePublicPortsError {
                meta: generic,
                kind: crate::error::OpenInstancePublicPortsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::OpenInstancePublicPortsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::OpenInstancePublicPortsError {
            meta: generic,
            kind: crate::error::OpenInstancePublicPortsErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::OpenInstancePublicPortsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::OpenInstancePublicPortsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_open_instance_public_ports_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::OpenInstancePublicPortsOutput,
    crate::error::OpenInstancePublicPortsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::open_instance_public_ports_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_open_instance_public_ports(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::OpenInstancePublicPortsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_peer_vpc_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PeerVpcOutput, crate::error::PeerVpcError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PeerVpcError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PeerVpcError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::PeerVpcError {
            meta: generic,
            kind: crate::error::PeerVpcErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PeerVpcError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::PeerVpcError {
            meta: generic,
            kind: crate::error::PeerVpcErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PeerVpcError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::PeerVpcError {
            meta: generic,
            kind: crate::error::PeerVpcErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PeerVpcError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::PeerVpcError {
            meta: generic,
            kind: crate::error::PeerVpcErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PeerVpcError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::PeerVpcError {
            meta: generic,
            kind: crate::error::PeerVpcErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PeerVpcError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::PeerVpcError {
                meta: generic,
                kind: crate::error::PeerVpcErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PeerVpcError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::PeerVpcError {
            meta: generic,
            kind: crate::error::PeerVpcErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PeerVpcError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PeerVpcError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_peer_vpc_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PeerVpcOutput, crate::error::PeerVpcError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::peer_vpc_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_peer_vpc(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PeerVpcError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_alarm_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutAlarmOutput, crate::error::PutAlarmError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutAlarmError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PutAlarmError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::PutAlarmError {
            meta: generic,
            kind: crate::error::PutAlarmErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAlarmError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::PutAlarmError {
            meta: generic,
            kind: crate::error::PutAlarmErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAlarmError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::PutAlarmError {
            meta: generic,
            kind: crate::error::PutAlarmErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAlarmError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::PutAlarmError {
            meta: generic,
            kind: crate::error::PutAlarmErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAlarmError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::PutAlarmError {
                meta: generic,
                kind: crate::error::PutAlarmErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAlarmError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::PutAlarmError {
            meta: generic,
            kind: crate::error::PutAlarmErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutAlarmError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutAlarmError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_alarm_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PutAlarmOutput, crate::error::PutAlarmError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_alarm_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_alarm(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutAlarmError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_instance_public_ports_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutInstancePublicPortsOutput,
    crate::error::PutInstancePublicPortsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PutInstancePublicPortsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PutInstancePublicPortsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::PutInstancePublicPortsError {
            meta: generic,
            kind: crate::error::PutInstancePublicPortsErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutInstancePublicPortsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::PutInstancePublicPortsError {
            meta: generic,
            kind: crate::error::PutInstancePublicPortsErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutInstancePublicPortsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::PutInstancePublicPortsError {
            meta: generic,
            kind: crate::error::PutInstancePublicPortsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutInstancePublicPortsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::PutInstancePublicPortsError {
            meta: generic,
            kind: crate::error::PutInstancePublicPortsErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutInstancePublicPortsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::PutInstancePublicPortsError {
            meta: generic,
            kind: crate::error::PutInstancePublicPortsErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutInstancePublicPortsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::PutInstancePublicPortsError {
                meta: generic,
                kind: crate::error::PutInstancePublicPortsErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutInstancePublicPortsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::PutInstancePublicPortsError {
            meta: generic,
            kind: crate::error::PutInstancePublicPortsErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PutInstancePublicPortsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PutInstancePublicPortsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_put_instance_public_ports_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PutInstancePublicPortsOutput,
    crate::error::PutInstancePublicPortsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::put_instance_public_ports_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_put_instance_public_ports(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PutInstancePublicPortsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reboot_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RebootInstanceOutput, crate::error::RebootInstanceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RebootInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RebootInstanceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::RebootInstanceError {
            meta: generic,
            kind: crate::error::RebootInstanceErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RebootInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::RebootInstanceError {
            meta: generic,
            kind: crate::error::RebootInstanceErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RebootInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::RebootInstanceError {
            meta: generic,
            kind: crate::error::RebootInstanceErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RebootInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::RebootInstanceError {
            meta: generic,
            kind: crate::error::RebootInstanceErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RebootInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::RebootInstanceError {
            meta: generic,
            kind: crate::error::RebootInstanceErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RebootInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::RebootInstanceError {
                meta: generic,
                kind: crate::error::RebootInstanceErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RebootInstanceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::RebootInstanceError {
            meta: generic,
            kind: crate::error::RebootInstanceErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RebootInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RebootInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reboot_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RebootInstanceOutput, crate::error::RebootInstanceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reboot_instance_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_reboot_instance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RebootInstanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reboot_relational_database_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RebootRelationalDatabaseOutput,
    crate::error::RebootRelationalDatabaseError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RebootRelationalDatabaseError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RebootRelationalDatabaseError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::RebootRelationalDatabaseError {
            meta: generic,
            kind: crate::error::RebootRelationalDatabaseErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RebootRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::RebootRelationalDatabaseError {
            meta: generic,
            kind: crate::error::RebootRelationalDatabaseErrorKind::AccountSetupInProgressException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::account_setup_in_progress_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RebootRelationalDatabaseError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidInputException" => crate::error::RebootRelationalDatabaseError {
            meta: generic,
            kind: crate::error::RebootRelationalDatabaseErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RebootRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::RebootRelationalDatabaseError {
            meta: generic,
            kind: crate::error::RebootRelationalDatabaseErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RebootRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::RebootRelationalDatabaseError {
            meta: generic,
            kind: crate::error::RebootRelationalDatabaseErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RebootRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::RebootRelationalDatabaseError {
                meta: generic,
                kind: crate::error::RebootRelationalDatabaseErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RebootRelationalDatabaseError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::RebootRelationalDatabaseError {
            meta: generic,
            kind: crate::error::RebootRelationalDatabaseErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RebootRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RebootRelationalDatabaseError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reboot_relational_database_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RebootRelationalDatabaseOutput,
    crate::error::RebootRelationalDatabaseError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reboot_relational_database_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_reboot_relational_database(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RebootRelationalDatabaseError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_container_image_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RegisterContainerImageOutput,
    crate::error::RegisterContainerImageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::RegisterContainerImageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RegisterContainerImageError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::RegisterContainerImageError {
            meta: generic,
            kind: crate::error::RegisterContainerImageErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterContainerImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::RegisterContainerImageError {
            meta: generic,
            kind: crate::error::RegisterContainerImageErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterContainerImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::RegisterContainerImageError {
            meta: generic,
            kind: crate::error::RegisterContainerImageErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterContainerImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::RegisterContainerImageError {
                meta: generic,
                kind: crate::error::RegisterContainerImageErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterContainerImageError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::RegisterContainerImageError {
            meta: generic,
            kind: crate::error::RegisterContainerImageErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::RegisterContainerImageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RegisterContainerImageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_container_image_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RegisterContainerImageOutput,
    crate::error::RegisterContainerImageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::register_container_image_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_register_container_image(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RegisterContainerImageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_release_static_ip_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ReleaseStaticIpOutput, crate::error::ReleaseStaticIpError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ReleaseStaticIpError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ReleaseStaticIpError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ReleaseStaticIpError {
            meta: generic,
            kind: crate::error::ReleaseStaticIpErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReleaseStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::ReleaseStaticIpError {
            meta: generic,
            kind: crate::error::ReleaseStaticIpErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReleaseStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::ReleaseStaticIpError {
            meta: generic,
            kind: crate::error::ReleaseStaticIpErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReleaseStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::ReleaseStaticIpError {
            meta: generic,
            kind: crate::error::ReleaseStaticIpErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReleaseStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::ReleaseStaticIpError {
            meta: generic,
            kind: crate::error::ReleaseStaticIpErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReleaseStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ReleaseStaticIpError {
                meta: generic,
                kind: crate::error::ReleaseStaticIpErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReleaseStaticIpError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::ReleaseStaticIpError {
            meta: generic,
            kind: crate::error::ReleaseStaticIpErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ReleaseStaticIpError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ReleaseStaticIpError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_release_static_ip_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ReleaseStaticIpOutput, crate::error::ReleaseStaticIpError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::release_static_ip_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_release_static_ip(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ReleaseStaticIpError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reset_distribution_cache_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ResetDistributionCacheOutput,
    crate::error::ResetDistributionCacheError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ResetDistributionCacheError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ResetDistributionCacheError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::ResetDistributionCacheError {
            meta: generic,
            kind: crate::error::ResetDistributionCacheErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResetDistributionCacheError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::ResetDistributionCacheError {
            meta: generic,
            kind: crate::error::ResetDistributionCacheErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResetDistributionCacheError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::ResetDistributionCacheError {
            meta: generic,
            kind: crate::error::ResetDistributionCacheErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResetDistributionCacheError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::ResetDistributionCacheError {
            meta: generic,
            kind: crate::error::ResetDistributionCacheErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResetDistributionCacheError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::ResetDistributionCacheError {
                meta: generic,
                kind: crate::error::ResetDistributionCacheErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResetDistributionCacheError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::ResetDistributionCacheError {
            meta: generic,
            kind: crate::error::ResetDistributionCacheErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ResetDistributionCacheError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ResetDistributionCacheError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reset_distribution_cache_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ResetDistributionCacheOutput,
    crate::error::ResetDistributionCacheError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reset_distribution_cache_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_reset_distribution_cache(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ResetDistributionCacheError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_contact_method_verification_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SendContactMethodVerificationOutput,
    crate::error::SendContactMethodVerificationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SendContactMethodVerificationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::SendContactMethodVerificationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::SendContactMethodVerificationError {
            meta: generic,
            kind: crate::error::SendContactMethodVerificationErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendContactMethodVerificationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::SendContactMethodVerificationError {
            meta: generic,
            kind: crate::error::SendContactMethodVerificationErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendContactMethodVerificationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::SendContactMethodVerificationError {
            meta: generic,
            kind: crate::error::SendContactMethodVerificationErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendContactMethodVerificationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::SendContactMethodVerificationError {
            meta: generic,
            kind: crate::error::SendContactMethodVerificationErrorKind::OperationFailureException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::operation_failure_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendContactMethodVerificationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ServiceException" => {
            crate::error::SendContactMethodVerificationError {
                meta: generic,
                kind: crate::error::SendContactMethodVerificationErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendContactMethodVerificationError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::SendContactMethodVerificationError {
            meta: generic,
            kind: crate::error::SendContactMethodVerificationErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendContactMethodVerificationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SendContactMethodVerificationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_contact_method_verification_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SendContactMethodVerificationOutput,
    crate::error::SendContactMethodVerificationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::send_contact_method_verification_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_send_contact_method_verification(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::SendContactMethodVerificationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_ip_address_type_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetIpAddressTypeOutput, crate::error::SetIpAddressTypeError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetIpAddressTypeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SetIpAddressTypeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::SetIpAddressTypeError {
            meta: generic,
            kind: crate::error::SetIpAddressTypeErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetIpAddressTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::SetIpAddressTypeError {
            meta: generic,
            kind: crate::error::SetIpAddressTypeErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetIpAddressTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::SetIpAddressTypeError {
            meta: generic,
            kind: crate::error::SetIpAddressTypeErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetIpAddressTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::SetIpAddressTypeError {
            meta: generic,
            kind: crate::error::SetIpAddressTypeErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetIpAddressTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::SetIpAddressTypeError {
            meta: generic,
            kind: crate::error::SetIpAddressTypeErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetIpAddressTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::SetIpAddressTypeError {
                meta: generic,
                kind: crate::error::SetIpAddressTypeErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetIpAddressTypeError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::SetIpAddressTypeError {
            meta: generic,
            kind: crate::error::SetIpAddressTypeErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetIpAddressTypeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetIpAddressTypeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_ip_address_type_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SetIpAddressTypeOutput, crate::error::SetIpAddressTypeError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_ip_address_type_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_set_ip_address_type(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SetIpAddressTypeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_resource_access_for_bucket_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetResourceAccessForBucketOutput,
    crate::error::SetResourceAccessForBucketError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SetResourceAccessForBucketError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::SetResourceAccessForBucketError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::SetResourceAccessForBucketError {
            meta: generic,
            kind: crate::error::SetResourceAccessForBucketErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetResourceAccessForBucketError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::SetResourceAccessForBucketError {
            meta: generic,
            kind: crate::error::SetResourceAccessForBucketErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetResourceAccessForBucketError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::SetResourceAccessForBucketError {
            meta: generic,
            kind: crate::error::SetResourceAccessForBucketErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetResourceAccessForBucketError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::SetResourceAccessForBucketError {
                meta: generic,
                kind: crate::error::SetResourceAccessForBucketErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetResourceAccessForBucketError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::SetResourceAccessForBucketError {
            meta: generic,
            kind: crate::error::SetResourceAccessForBucketErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SetResourceAccessForBucketError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SetResourceAccessForBucketError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_set_resource_access_for_bucket_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::SetResourceAccessForBucketOutput,
    crate::error::SetResourceAccessForBucketError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::set_resource_access_for_bucket_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_set_resource_access_for_bucket(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SetResourceAccessForBucketError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartInstanceOutput, crate::error::StartInstanceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartInstanceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::StartInstanceError {
            meta: generic,
            kind: crate::error::StartInstanceErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::StartInstanceError {
            meta: generic,
            kind: crate::error::StartInstanceErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::StartInstanceError {
            meta: generic,
            kind: crate::error::StartInstanceErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::StartInstanceError {
            meta: generic,
            kind: crate::error::StartInstanceErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::StartInstanceError {
            meta: generic,
            kind: crate::error::StartInstanceErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::StartInstanceError {
                meta: generic,
                kind: crate::error::StartInstanceErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartInstanceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::StartInstanceError {
            meta: generic,
            kind: crate::error::StartInstanceErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartInstanceOutput, crate::error::StartInstanceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_instance_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_instance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartInstanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_relational_database_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartRelationalDatabaseOutput,
    crate::error::StartRelationalDatabaseError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartRelationalDatabaseError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StartRelationalDatabaseError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::StartRelationalDatabaseError {
            meta: generic,
            kind: crate::error::StartRelationalDatabaseErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::StartRelationalDatabaseError {
            meta: generic,
            kind: crate::error::StartRelationalDatabaseErrorKind::AccountSetupInProgressException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::account_setup_in_progress_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartRelationalDatabaseError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidInputException" => crate::error::StartRelationalDatabaseError {
            meta: generic,
            kind: crate::error::StartRelationalDatabaseErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::StartRelationalDatabaseError {
            meta: generic,
            kind: crate::error::StartRelationalDatabaseErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::StartRelationalDatabaseError {
            meta: generic,
            kind: crate::error::StartRelationalDatabaseErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::StartRelationalDatabaseError {
                meta: generic,
                kind: crate::error::StartRelationalDatabaseErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartRelationalDatabaseError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::StartRelationalDatabaseError {
            meta: generic,
            kind: crate::error::StartRelationalDatabaseErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartRelationalDatabaseError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_relational_database_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartRelationalDatabaseOutput,
    crate::error::StartRelationalDatabaseError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_relational_database_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_relational_database(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartRelationalDatabaseError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopInstanceOutput, crate::error::StopInstanceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopInstanceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::StopInstanceError {
            meta: generic,
            kind: crate::error::StopInstanceErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::StopInstanceError {
            meta: generic,
            kind: crate::error::StopInstanceErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::StopInstanceError {
            meta: generic,
            kind: crate::error::StopInstanceErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::StopInstanceError {
            meta: generic,
            kind: crate::error::StopInstanceErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::StopInstanceError {
            meta: generic,
            kind: crate::error::StopInstanceErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::StopInstanceError {
                meta: generic,
                kind: crate::error::StopInstanceErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopInstanceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::StopInstanceError {
            meta: generic,
            kind: crate::error::StopInstanceErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StopInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopInstanceOutput, crate::error::StopInstanceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_instance_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_stop_instance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StopInstanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_relational_database_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopRelationalDatabaseOutput,
    crate::error::StopRelationalDatabaseError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopRelationalDatabaseError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::StopRelationalDatabaseError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::StopRelationalDatabaseError {
            meta: generic,
            kind: crate::error::StopRelationalDatabaseErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::StopRelationalDatabaseError {
            meta: generic,
            kind: crate::error::StopRelationalDatabaseErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::StopRelationalDatabaseError {
            meta: generic,
            kind: crate::error::StopRelationalDatabaseErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::StopRelationalDatabaseError {
            meta: generic,
            kind: crate::error::StopRelationalDatabaseErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::StopRelationalDatabaseError {
            meta: generic,
            kind: crate::error::StopRelationalDatabaseErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::StopRelationalDatabaseError {
                meta: generic,
                kind: crate::error::StopRelationalDatabaseErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopRelationalDatabaseError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::StopRelationalDatabaseError {
            meta: generic,
            kind: crate::error::StopRelationalDatabaseErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StopRelationalDatabaseError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StopRelationalDatabaseError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_relational_database_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopRelationalDatabaseOutput,
    crate::error::StopRelationalDatabaseError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_relational_database_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_stop_relational_database(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StopRelationalDatabaseError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "AccountSetupInProgressException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::AccountSetupInProgressException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::account_setup_in_progress_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_account_setup_in_progress_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OperationFailureException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::OperationFailureException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::operation_failure_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_operation_failure_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceException" => {
            crate::error::TagResourceError {
                meta: generic,
                kind: crate::error::TagResourceErrorKind::ServiceException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::service_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_service_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "UnauthenticatedException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::UnauthenticatedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unauthenticated_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unauthenticated_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_tag_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::TagResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_test_alarm_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TestAlarmOutput, crate::error::TestAlarmError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TestAlarmError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TestAlarmError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::TestAlarmError {
            meta: generic,
            kind: crate::error::TestAlarmErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TestAlarmError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::TestAlarmError {
            meta: generic,
            kind: crate::error::TestAlarmErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TestAlarmError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "NotFoundException" => crate::error::TestAlarmError {
            meta: generic,
            kind: crate::error::TestAlarmErrorKind::NotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::T