// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules of an input field.</p> <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia (<code>us-east-1</code>) Amazon Web Services Region. Please set your Amazon Web Services Region configuration to <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AccessDeniedException(inner) => inner.fmt(f),
            Error::AccountSetupInProgressException(inner) => inner.fmt(f),
            Error::InvalidInputException(inner) => inner.fmt(f),
            Error::NotFoundException(inner) => inner.fmt(f),
            Error::OperationFailureException(inner) => inner.fmt(f),
            Error::ServiceException(inner) => inner.fmt(f),
            Error::UnauthenticatedException(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AllocateStaticIpError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AllocateStaticIpError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AllocateStaticIpErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::AllocateStaticIpErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::AllocateStaticIpErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::AllocateStaticIpErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::AllocateStaticIpErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::AllocateStaticIpErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::AllocateStaticIpErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::AllocateStaticIpErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::AttachCertificateToDistributionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::AttachCertificateToDistributionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AttachCertificateToDistributionErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::AttachCertificateToDistributionErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::AttachCertificateToDistributionErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::AttachCertificateToDistributionErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::AttachCertificateToDistributionErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::AttachCertificateToDistributionErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::AttachCertificateToDistributionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AttachDiskError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::AttachDiskError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AttachDiskErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::AttachDiskErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::AttachDiskErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::AttachDiskErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::AttachDiskErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::AttachDiskErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::AttachDiskErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::AttachDiskErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AttachInstancesToLoadBalancerError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AttachInstancesToLoadBalancerError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AttachInstancesToLoadBalancerErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::AttachInstancesToLoadBalancerErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::AttachInstancesToLoadBalancerErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::AttachInstancesToLoadBalancerErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::AttachInstancesToLoadBalancerErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::AttachInstancesToLoadBalancerErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::AttachInstancesToLoadBalancerErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::AttachInstancesToLoadBalancerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::AttachLoadBalancerTlsCertificateError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::AttachLoadBalancerTlsCertificateError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AttachLoadBalancerTlsCertificateErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::AttachLoadBalancerTlsCertificateErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::AttachLoadBalancerTlsCertificateErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::AttachLoadBalancerTlsCertificateErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::AttachLoadBalancerTlsCertificateErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::AttachLoadBalancerTlsCertificateErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::AttachLoadBalancerTlsCertificateErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::AttachLoadBalancerTlsCertificateErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AttachStaticIpError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::AttachStaticIpError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AttachStaticIpErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::AttachStaticIpErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::AttachStaticIpErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::AttachStaticIpErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::AttachStaticIpErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::AttachStaticIpErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::AttachStaticIpErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::AttachStaticIpErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CloseInstancePublicPortsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CloseInstancePublicPortsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CloseInstancePublicPortsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CloseInstancePublicPortsErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::CloseInstancePublicPortsErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::CloseInstancePublicPortsErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::CloseInstancePublicPortsErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::CloseInstancePublicPortsErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::CloseInstancePublicPortsErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::CloseInstancePublicPortsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CopySnapshotError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CopySnapshotError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CopySnapshotErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CopySnapshotErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::CopySnapshotErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CopySnapshotErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::CopySnapshotErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::CopySnapshotErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CopySnapshotErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::CopySnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateBucketError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateBucketError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateBucketErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateBucketErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateBucketErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateBucketErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::CreateBucketErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateBucketAccessKeyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateBucketAccessKeyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateBucketAccessKeyErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateBucketAccessKeyErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateBucketAccessKeyErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::CreateBucketAccessKeyErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateBucketAccessKeyErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::CreateBucketAccessKeyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateCertificateError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateCertificateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateCertificateErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateCertificateErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateCertificateErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::CreateCertificateErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateCertificateErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::CreateCertificateErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateCloudFormationStackError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateCloudFormationStackError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateCloudFormationStackErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateCloudFormationStackErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::CreateCloudFormationStackErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::CreateCloudFormationStackErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::CreateCloudFormationStackErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::CreateCloudFormationStackErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::CreateCloudFormationStackErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::CreateCloudFormationStackErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateContactMethodError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateContactMethodError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateContactMethodErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateContactMethodErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateContactMethodErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::CreateContactMethodErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::CreateContactMethodErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateContactMethodErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::CreateContactMethodErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateContainerServiceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateContainerServiceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateContainerServiceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateContainerServiceErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateContainerServiceErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::CreateContainerServiceErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateContainerServiceErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::CreateContainerServiceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::CreateContainerServiceDeploymentError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CreateContainerServiceDeploymentError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateContainerServiceDeploymentErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateContainerServiceDeploymentErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::CreateContainerServiceDeploymentErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::CreateContainerServiceDeploymentErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::CreateContainerServiceDeploymentErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::CreateContainerServiceDeploymentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::CreateContainerServiceRegistryLoginError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CreateContainerServiceRegistryLoginError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateContainerServiceRegistryLoginErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateContainerServiceRegistryLoginErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::CreateContainerServiceRegistryLoginErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::CreateContainerServiceRegistryLoginErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::CreateContainerServiceRegistryLoginErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::CreateContainerServiceRegistryLoginErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDiskError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateDiskError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDiskErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateDiskErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::CreateDiskErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateDiskErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::CreateDiskErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::CreateDiskErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateDiskErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::CreateDiskErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDiskFromSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDiskFromSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDiskFromSnapshotErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateDiskFromSnapshotErrorKind::AccountSetupInProgressException(
                    inner,
                ) => Error::AccountSetupInProgressException(inner),
                crate::error::CreateDiskFromSnapshotErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateDiskFromSnapshotErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::CreateDiskFromSnapshotErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::CreateDiskFromSnapshotErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateDiskFromSnapshotErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::CreateDiskFromSnapshotErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDiskSnapshotError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDiskSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDiskSnapshotErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateDiskSnapshotErrorKind::AccountSetupInProgressException(
                    inner,
                ) => Error::AccountSetupInProgressException(inner),
                crate::error::CreateDiskSnapshotErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateDiskSnapshotErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::CreateDiskSnapshotErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::CreateDiskSnapshotErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateDiskSnapshotErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::CreateDiskSnapshotErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDistributionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDistributionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDistributionErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateDistributionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateDistributionErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::CreateDistributionErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::CreateDistributionErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateDistributionErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::CreateDistributionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDomainError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateDomainError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDomainErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateDomainErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::CreateDomainErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateDomainErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::CreateDomainErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::CreateDomainErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateDomainErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::CreateDomainErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDomainEntryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDomainEntryError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDomainEntryErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateDomainEntryErrorKind::AccountSetupInProgressException(
                    inner,
                ) => Error::AccountSetupInProgressException(inner),
                crate::error::CreateDomainEntryErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateDomainEntryErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::CreateDomainEntryErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::CreateDomainEntryErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateDomainEntryErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::CreateDomainEntryErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateInstancesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateInstancesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateInstancesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateInstancesErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::CreateInstancesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateInstancesErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::CreateInstancesErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::CreateInstancesErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateInstancesErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::CreateInstancesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateInstancesFromSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateInstancesFromSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateInstancesFromSnapshotErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateInstancesFromSnapshotErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::CreateInstancesFromSnapshotErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::CreateInstancesFromSnapshotErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::CreateInstancesFromSnapshotErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::CreateInstancesFromSnapshotErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::CreateInstancesFromSnapshotErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::CreateInstancesFromSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateInstanceSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateInstanceSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateInstanceSnapshotErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateInstanceSnapshotErrorKind::AccountSetupInProgressException(
                    inner,
                ) => Error::AccountSetupInProgressException(inner),
                crate::error::CreateInstanceSnapshotErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateInstanceSnapshotErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::CreateInstanceSnapshotErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::CreateInstanceSnapshotErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateInstanceSnapshotErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::CreateInstanceSnapshotErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateKeyPairError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateKeyPairError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateKeyPairErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateKeyPairErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::CreateKeyPairErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateKeyPairErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::CreateKeyPairErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::CreateKeyPairErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateKeyPairErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::CreateKeyPairErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateLoadBalancerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateLoadBalancerError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateLoadBalancerErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::CreateLoadBalancerErrorKind::AccountSetupInProgressException(
                    inner,
                ) => Error::AccountSetupInProgressException(inner),
                crate::error::CreateLoadBalancerErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::CreateLoadBalancerErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::CreateLoadBalancerErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::CreateLoadBalancerErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::CreateLoadBalancerErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::CreateLoadBalancerErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::CreateLoadBalancerTlsCertificateError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CreateLoadBalancerTlsCertificateError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateLoadBalancerTlsCertificateErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateLoadBalancerTlsCertificateErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::CreateLoadBalancerTlsCertificateErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::CreateLoadBalancerTlsCertificateErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::CreateLoadBalancerTlsCertificateErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::CreateLoadBalancerTlsCertificateErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::CreateLoadBalancerTlsCertificateErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::CreateLoadBalancerTlsCertificateErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateRelationalDatabaseError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateRelationalDatabaseError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateRelationalDatabaseErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateRelationalDatabaseErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::CreateRelationalDatabaseErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::CreateRelationalDatabaseErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::CreateRelationalDatabaseErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::CreateRelationalDatabaseErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::CreateRelationalDatabaseErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::CreateRelationalDatabaseErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::CreateRelationalDatabaseFromSnapshotError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CreateRelationalDatabaseFromSnapshotError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateRelationalDatabaseFromSnapshotErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateRelationalDatabaseFromSnapshotErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::CreateRelationalDatabaseFromSnapshotErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::CreateRelationalDatabaseFromSnapshotErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::CreateRelationalDatabaseFromSnapshotErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::CreateRelationalDatabaseFromSnapshotErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::CreateRelationalDatabaseFromSnapshotErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::CreateRelationalDatabaseFromSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::CreateRelationalDatabaseSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CreateRelationalDatabaseSnapshotError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateRelationalDatabaseSnapshotErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::CreateRelationalDatabaseSnapshotErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::CreateRelationalDatabaseSnapshotErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::CreateRelationalDatabaseSnapshotErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::CreateRelationalDatabaseSnapshotErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::CreateRelationalDatabaseSnapshotErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::CreateRelationalDatabaseSnapshotErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::CreateRelationalDatabaseSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteAlarmError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteAlarmError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteAlarmErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteAlarmErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteAlarmErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DeleteAlarmErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::DeleteAlarmErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteAlarmErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::DeleteAlarmErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteAutoSnapshotError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteAutoSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteAutoSnapshotErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteAutoSnapshotErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteAutoSnapshotErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DeleteAutoSnapshotErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::DeleteAutoSnapshotErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteAutoSnapshotErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::DeleteAutoSnapshotErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteBucketError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteBucketError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteBucketErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteBucketErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteBucketErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DeleteBucketErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteBucketErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::DeleteBucketErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteBucketAccessKeyError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteBucketAccessKeyError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteBucketAccessKeyErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteBucketAccessKeyErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteBucketAccessKeyErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DeleteBucketAccessKeyErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteBucketAccessKeyErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::DeleteBucketAccessKeyErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteCertificateError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteCertificateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteCertificateErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteCertificateErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteCertificateErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DeleteCertificateErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteCertificateErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::DeleteCertificateErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteContactMethodError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteContactMethodError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteContactMethodErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteContactMethodErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteContactMethodErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DeleteContactMethodErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::DeleteContactMethodErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteContactMethodErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::DeleteContactMethodErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteContainerImageError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteContainerImageError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteContainerImageErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteContainerImageErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteContainerImageErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DeleteContainerImageErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteContainerImageErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::DeleteContainerImageErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteContainerServiceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteContainerServiceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteContainerServiceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteContainerServiceErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteContainerServiceErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DeleteContainerServiceErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteContainerServiceErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::DeleteContainerServiceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDiskError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteDiskError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDiskErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteDiskErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::DeleteDiskErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteDiskErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DeleteDiskErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::DeleteDiskErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteDiskErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::DeleteDiskErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDiskSnapshotError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDiskSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDiskSnapshotErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteDiskSnapshotErrorKind::AccountSetupInProgressException(
                    inner,
                ) => Error::AccountSetupInProgressException(inner),
                crate::error::DeleteDiskSnapshotErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteDiskSnapshotErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DeleteDiskSnapshotErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::DeleteDiskSnapshotErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteDiskSnapshotErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::DeleteDiskSnapshotErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDistributionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDistributionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDistributionErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteDistributionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteDistributionErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DeleteDistributionErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::DeleteDistributionErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteDistributionErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::DeleteDistributionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDomainError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteDomainError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDomainErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteDomainErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::DeleteDomainErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteDomainErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DeleteDomainErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::DeleteDomainErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteDomainErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::DeleteDomainErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDomainEntryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDomainEntryError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDomainEntryErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteDomainEntryErrorKind::AccountSetupInProgressException(
                    inner,
                ) => Error::AccountSetupInProgressException(inner),
                crate::error::DeleteDomainEntryErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteDomainEntryErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DeleteDomainEntryErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::DeleteDomainEntryErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteDomainEntryErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::DeleteDomainEntryErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteInstanceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteInstanceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteInstanceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteInstanceErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::DeleteInstanceErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteInstanceErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DeleteInstanceErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::DeleteInstanceErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteInstanceErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::DeleteInstanceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteInstanceSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteInstanceSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteInstanceSnapshotErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteInstanceSnapshotErrorKind::AccountSetupInProgressException(
                    inner,
                ) => Error::AccountSetupInProgressException(inner),
                crate::error::DeleteInstanceSnapshotErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteInstanceSnapshotErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DeleteInstanceSnapshotErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::DeleteInstanceSnapshotErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteInstanceSnapshotErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::DeleteInstanceSnapshotErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteKeyPairError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteKeyPairError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteKeyPairErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteKeyPairErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::DeleteKeyPairErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteKeyPairErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DeleteKeyPairErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::DeleteKeyPairErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteKeyPairErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::DeleteKeyPairErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteKnownHostKeysError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteKnownHostKeysError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteKnownHostKeysErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteKnownHostKeysErrorKind::AccountSetupInProgressException(
                    inner,
                ) => Error::AccountSetupInProgressException(inner),
                crate::error::DeleteKnownHostKeysErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteKnownHostKeysErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DeleteKnownHostKeysErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::DeleteKnownHostKeysErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteKnownHostKeysErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::DeleteKnownHostKeysErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteLoadBalancerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteLoadBalancerError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteLoadBalancerErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DeleteLoadBalancerErrorKind::AccountSetupInProgressException(
                    inner,
                ) => Error::AccountSetupInProgressException(inner),
                crate::error::DeleteLoadBalancerErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DeleteLoadBalancerErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DeleteLoadBalancerErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::DeleteLoadBalancerErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DeleteLoadBalancerErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::DeleteLoadBalancerErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DeleteLoadBalancerTlsCertificateError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteLoadBalancerTlsCertificateError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteLoadBalancerTlsCertificateErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DeleteLoadBalancerTlsCertificateErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::DeleteLoadBalancerTlsCertificateErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::DeleteLoadBalancerTlsCertificateErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::DeleteLoadBalancerTlsCertificateErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::DeleteLoadBalancerTlsCertificateErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::DeleteLoadBalancerTlsCertificateErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::DeleteLoadBalancerTlsCertificateErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteRelationalDatabaseError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteRelationalDatabaseError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteRelationalDatabaseErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DeleteRelationalDatabaseErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::DeleteRelationalDatabaseErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::DeleteRelationalDatabaseErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::DeleteRelationalDatabaseErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::DeleteRelationalDatabaseErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::DeleteRelationalDatabaseErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::DeleteRelationalDatabaseErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DeleteRelationalDatabaseSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteRelationalDatabaseSnapshotError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteRelationalDatabaseSnapshotErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DeleteRelationalDatabaseSnapshotErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::DeleteRelationalDatabaseSnapshotErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::DeleteRelationalDatabaseSnapshotErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::DeleteRelationalDatabaseSnapshotErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::DeleteRelationalDatabaseSnapshotErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::DeleteRelationalDatabaseSnapshotErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::DeleteRelationalDatabaseSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DetachCertificateFromDistributionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DetachCertificateFromDistributionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DetachCertificateFromDistributionErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DetachCertificateFromDistributionErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::DetachCertificateFromDistributionErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::DetachCertificateFromDistributionErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::DetachCertificateFromDistributionErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::DetachCertificateFromDistributionErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::DetachCertificateFromDistributionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DetachDiskError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DetachDiskError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DetachDiskErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DetachDiskErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::DetachDiskErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DetachDiskErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DetachDiskErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::DetachDiskErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DetachDiskErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::DetachDiskErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DetachInstancesFromLoadBalancerError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DetachInstancesFromLoadBalancerError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DetachInstancesFromLoadBalancerErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::DetachInstancesFromLoadBalancerErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::DetachInstancesFromLoadBalancerErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::DetachInstancesFromLoadBalancerErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::DetachInstancesFromLoadBalancerErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::DetachInstancesFromLoadBalancerErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::DetachInstancesFromLoadBalancerErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::DetachInstancesFromLoadBalancerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DetachStaticIpError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DetachStaticIpError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DetachStaticIpErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DetachStaticIpErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::DetachStaticIpErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DetachStaticIpErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DetachStaticIpErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::DetachStaticIpErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DetachStaticIpErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::DetachStaticIpErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DisableAddOnError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DisableAddOnError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DisableAddOnErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DisableAddOnErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DisableAddOnErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DisableAddOnErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::DisableAddOnErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DisableAddOnErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::DisableAddOnErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DownloadDefaultKeyPairError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DownloadDefaultKeyPairError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DownloadDefaultKeyPairErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::DownloadDefaultKeyPairErrorKind::AccountSetupInProgressException(
                    inner,
                ) => Error::AccountSetupInProgressException(inner),
                crate::error::DownloadDefaultKeyPairErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::DownloadDefaultKeyPairErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::DownloadDefaultKeyPairErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::DownloadDefaultKeyPairErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::DownloadDefaultKeyPairErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::DownloadDefaultKeyPairErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::EnableAddOnError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::EnableAddOnError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::EnableAddOnErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::EnableAddOnErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::EnableAddOnErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::EnableAddOnErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::EnableAddOnErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::EnableAddOnErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::EnableAddOnErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ExportSnapshotError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ExportSnapshotError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ExportSnapshotErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ExportSnapshotErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::ExportSnapshotErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ExportSnapshotErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::ExportSnapshotErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::ExportSnapshotErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::ExportSnapshotErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::ExportSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetActiveNamesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetActiveNamesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetActiveNamesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetActiveNamesErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::GetActiveNamesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetActiveNamesErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetActiveNamesErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetActiveNamesErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetActiveNamesErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetActiveNamesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetAlarmsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetAlarmsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetAlarmsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetAlarmsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetAlarmsErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetAlarmsErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetAlarmsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetAlarmsErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetAlarmsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetAutoSnapshotsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetAutoSnapshotsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetAutoSnapshotsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetAutoSnapshotsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetAutoSnapshotsErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetAutoSnapshotsErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetAutoSnapshotsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetAutoSnapshotsErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetAutoSnapshotsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetBlueprintsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetBlueprintsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetBlueprintsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetBlueprintsErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::GetBlueprintsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetBlueprintsErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetBlueprintsErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetBlueprintsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetBlueprintsErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetBlueprintsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetBucketAccessKeysError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetBucketAccessKeysError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetBucketAccessKeysErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetBucketAccessKeysErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetBucketAccessKeysErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetBucketAccessKeysErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetBucketAccessKeysErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetBucketAccessKeysErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetBucketBundlesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetBucketBundlesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetBucketBundlesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetBucketBundlesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetBucketBundlesErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetBucketBundlesErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetBucketBundlesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetBucketMetricDataError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetBucketMetricDataError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetBucketMetricDataErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetBucketMetricDataErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetBucketMetricDataErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetBucketMetricDataErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetBucketMetricDataErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetBucketMetricDataErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetBucketsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetBucketsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetBucketsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetBucketsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetBucketsErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetBucketsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetBucketsErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetBucketsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetBundlesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetBundlesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetBundlesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetBundlesErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::GetBundlesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetBundlesErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetBundlesErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetBundlesErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetBundlesErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetBundlesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetCertificatesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetCertificatesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetCertificatesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetCertificatesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetCertificatesErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetCertificatesErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetCertificatesErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetCertificatesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetCloudFormationStackRecordsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetCloudFormationStackRecordsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetCloudFormationStackRecordsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetCloudFormationStackRecordsErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::GetCloudFormationStackRecordsErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::GetCloudFormationStackRecordsErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::GetCloudFormationStackRecordsErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::GetCloudFormationStackRecordsErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::GetCloudFormationStackRecordsErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::GetCloudFormationStackRecordsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetContactMethodsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetContactMethodsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetContactMethodsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetContactMethodsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetContactMethodsErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetContactMethodsErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetContactMethodsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetContactMethodsErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetContactMethodsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetContainerAPIMetadataError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetContainerAPIMetadataError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetContainerAPIMetadataErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetContainerAPIMetadataErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetContainerAPIMetadataErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetContainerAPIMetadataErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetContainerImagesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetContainerImagesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetContainerImagesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetContainerImagesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetContainerImagesErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetContainerImagesErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetContainerImagesErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetContainerImagesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetContainerLogError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetContainerLogError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetContainerLogErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetContainerLogErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetContainerLogErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetContainerLogErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetContainerLogErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetContainerLogErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetContainerServiceDeploymentsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetContainerServiceDeploymentsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetContainerServiceDeploymentsErrorKind::AccessDeniedException(
                    inner,
                ) => Error::AccessDeniedException(inner),
                crate::error::GetContainerServiceDeploymentsErrorKind::InvalidInputException(
                    inner,
                ) => Error::InvalidInputException(inner),
                crate::error::GetContainerServiceDeploymentsErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetContainerServiceDeploymentsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetContainerServiceDeploymentsErrorKind::UnauthenticatedException(
                    inner,
                ) => Error::UnauthenticatedException(inner),
                crate::error::GetContainerServiceDeploymentsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetContainerServiceMetricDataError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetContainerServiceMetricDataError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetContainerServiceMetricDataErrorKind::AccessDeniedException(
                    inner,
                ) => Error::AccessDeniedException(inner),
                crate::error::GetContainerServiceMetricDataErrorKind::InvalidInputException(
                    inner,
                ) => Error::InvalidInputException(inner),
                crate::error::GetContainerServiceMetricDataErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetContainerServiceMetricDataErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetContainerServiceMetricDataErrorKind::UnauthenticatedException(
                    inner,
                ) => Error::UnauthenticatedException(inner),
                crate::error::GetContainerServiceMetricDataErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetContainerServicePowersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetContainerServicePowersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetContainerServicePowersErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetContainerServicePowersErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetContainerServicePowersErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetContainerServicePowersErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetContainerServicePowersErrorKind::UnauthenticatedException(
                    inner,
                ) => Error::UnauthenticatedException(inner),
                crate::error::GetContainerServicePowersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetContainerServicesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetContainerServicesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetContainerServicesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetContainerServicesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetContainerServicesErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetContainerServicesErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetContainerServicesErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetContainerServicesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDiskError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetDiskError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDiskErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetDiskErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::GetDiskErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetDiskErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetDiskErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetDiskErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetDiskErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetDiskErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDisksError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetDisksError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDisksErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetDisksErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::GetDisksErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetDisksErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetDisksErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetDisksErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetDisksErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetDisksErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDiskSnapshotError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetDiskSnapshotError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDiskSnapshotErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetDiskSnapshotErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::GetDiskSnapshotErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetDiskSnapshotErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetDiskSnapshotErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetDiskSnapshotErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetDiskSnapshotErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetDiskSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDiskSnapshotsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetDiskSnapshotsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDiskSnapshotsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetDiskSnapshotsErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::GetDiskSnapshotsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetDiskSnapshotsErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetDiskSnapshotsErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetDiskSnapshotsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetDiskSnapshotsErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetDiskSnapshotsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDistributionBundlesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetDistributionBundlesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDistributionBundlesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetDistributionBundlesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetDistributionBundlesErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetDistributionBundlesErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetDistributionBundlesErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetDistributionBundlesErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetDistributionBundlesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetDistributionLatestCacheResetError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetDistributionLatestCacheResetError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetDistributionLatestCacheResetErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetDistributionLatestCacheResetErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::GetDistributionLatestCacheResetErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::GetDistributionLatestCacheResetErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::GetDistributionLatestCacheResetErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::GetDistributionLatestCacheResetErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::GetDistributionLatestCacheResetErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDistributionMetricDataError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetDistributionMetricDataError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDistributionMetricDataErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetDistributionMetricDataErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetDistributionMetricDataErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetDistributionMetricDataErrorKind::OperationFailureException(
                    inner,
                ) => Error::OperationFailureException(inner),
                crate::error::GetDistributionMetricDataErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetDistributionMetricDataErrorKind::UnauthenticatedException(
                    inner,
                ) => Error::UnauthenticatedException(inner),
                crate::error::GetDistributionMetricDataErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDistributionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetDistributionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDistributionsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetDistributionsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetDistributionsErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetDistributionsErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetDistributionsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetDistributionsErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetDistributionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDomainError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetDomainError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDomainErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetDomainErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::GetDomainErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetDomainErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetDomainErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetDomainErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetDomainErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetDomainErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetDomainsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetDomainsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetDomainsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetDomainsErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::GetDomainsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetDomainsErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetDomainsErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetDomainsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetDomainsErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetDomainsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetExportSnapshotRecordsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetExportSnapshotRecordsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetExportSnapshotRecordsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetExportSnapshotRecordsErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::GetExportSnapshotRecordsErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::GetExportSnapshotRecordsErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::GetExportSnapshotRecordsErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::GetExportSnapshotRecordsErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::GetExportSnapshotRecordsErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::GetExportSnapshotRecordsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetInstanceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetInstanceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetInstanceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetInstanceErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::GetInstanceErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetInstanceErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetInstanceErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetInstanceErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetInstanceErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetInstanceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetInstanceAccessDetailsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetInstanceAccessDetailsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetInstanceAccessDetailsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetInstanceAccessDetailsErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::GetInstanceAccessDetailsErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::GetInstanceAccessDetailsErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::GetInstanceAccessDetailsErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::GetInstanceAccessDetailsErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::GetInstanceAccessDetailsErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::GetInstanceAccessDetailsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetInstanceMetricDataError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetInstanceMetricDataError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetInstanceMetricDataErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetInstanceMetricDataErrorKind::AccountSetupInProgressException(
                    inner,
                ) => Error::AccountSetupInProgressException(inner),
                crate::error::GetInstanceMetricDataErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetInstanceMetricDataErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetInstanceMetricDataErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetInstanceMetricDataErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetInstanceMetricDataErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetInstanceMetricDataErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetInstancePortStatesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetInstancePortStatesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetInstancePortStatesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetInstancePortStatesErrorKind::AccountSetupInProgressException(
                    inner,
                ) => Error::AccountSetupInProgressException(inner),
                crate::error::GetInstancePortStatesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetInstancePortStatesErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetInstancePortStatesErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetInstancePortStatesErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetInstancePortStatesErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetInstancePortStatesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetInstancesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetInstancesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetInstancesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetInstancesErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::GetInstancesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetInstancesErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetInstancesErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetInstancesErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetInstancesErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetInstancesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetInstanceSnapshotError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetInstanceSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetInstanceSnapshotErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetInstanceSnapshotErrorKind::AccountSetupInProgressException(
                    inner,
                ) => Error::AccountSetupInProgressException(inner),
                crate::error::GetInstanceSnapshotErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetInstanceSnapshotErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetInstanceSnapshotErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetInstanceSnapshotErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetInstanceSnapshotErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetInstanceSnapshotErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetInstanceSnapshotsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetInstanceSnapshotsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetInstanceSnapshotsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetInstanceSnapshotsErrorKind::AccountSetupInProgressException(
                    inner,
                ) => Error::AccountSetupInProgressException(inner),
                crate::error::GetInstanceSnapshotsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetInstanceSnapshotsErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetInstanceSnapshotsErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetInstanceSnapshotsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetInstanceSnapshotsErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetInstanceSnapshotsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetInstanceStateError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetInstanceStateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetInstanceStateErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetInstanceStateErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::GetInstanceStateErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetInstanceStateErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetInstanceStateErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetInstanceStateErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetInstanceStateErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetInstanceStateErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetKeyPairError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetKeyPairError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetKeyPairErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetKeyPairErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::GetKeyPairErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetKeyPairErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetKeyPairErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetKeyPairErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetKeyPairErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetKeyPairErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetKeyPairsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetKeyPairsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetKeyPairsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetKeyPairsErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::GetKeyPairsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetKeyPairsErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetKeyPairsErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetKeyPairsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetKeyPairsErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetKeyPairsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetLoadBalancerError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetLoadBalancerError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetLoadBalancerErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetLoadBalancerErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::GetLoadBalancerErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetLoadBalancerErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetLoadBalancerErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetLoadBalancerErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetLoadBalancerErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetLoadBalancerErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetLoadBalancerMetricDataError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetLoadBalancerMetricDataError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetLoadBalancerMetricDataErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetLoadBalancerMetricDataErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::GetLoadBalancerMetricDataErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::GetLoadBalancerMetricDataErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::GetLoadBalancerMetricDataErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::GetLoadBalancerMetricDataErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::GetLoadBalancerMetricDataErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::GetLoadBalancerMetricDataErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetLoadBalancersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetLoadBalancersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetLoadBalancersErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetLoadBalancersErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::GetLoadBalancersErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetLoadBalancersErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetLoadBalancersErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetLoadBalancersErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetLoadBalancersErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetLoadBalancersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetLoadBalancerTlsCertificatesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetLoadBalancerTlsCertificatesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetLoadBalancerTlsCertificatesErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetLoadBalancerTlsCertificatesErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::GetLoadBalancerTlsCertificatesErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::GetLoadBalancerTlsCertificatesErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::GetLoadBalancerTlsCertificatesErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::GetLoadBalancerTlsCertificatesErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::GetLoadBalancerTlsCertificatesErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::GetLoadBalancerTlsCertificatesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetLoadBalancerTlsPoliciesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetLoadBalancerTlsPoliciesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetLoadBalancerTlsPoliciesErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetLoadBalancerTlsPoliciesErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::GetLoadBalancerTlsPoliciesErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::GetLoadBalancerTlsPoliciesErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::GetLoadBalancerTlsPoliciesErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::GetLoadBalancerTlsPoliciesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetOperationError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetOperationError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetOperationErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetOperationErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::GetOperationErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetOperationErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetOperationErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetOperationErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetOperationErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetOperationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetOperationsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetOperationsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetOperationsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetOperationsErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::GetOperationsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetOperationsErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetOperationsErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetOperationsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetOperationsErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetOperationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetOperationsForResourceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetOperationsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetOperationsForResourceErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetOperationsForResourceErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::GetOperationsForResourceErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::GetOperationsForResourceErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::GetOperationsForResourceErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::GetOperationsForResourceErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::GetOperationsForResourceErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::GetOperationsForResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetRegionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetRegionsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetRegionsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetRegionsErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::GetRegionsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetRegionsErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetRegionsErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetRegionsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetRegionsErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetRegionsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetRelationalDatabaseErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetRelationalDatabaseErrorKind::AccountSetupInProgressException(
                    inner,
                ) => Error::AccountSetupInProgressException(inner),
                crate::error::GetRelationalDatabaseErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetRelationalDatabaseErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetRelationalDatabaseErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetRelationalDatabaseErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetRelationalDatabaseErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetRelationalDatabaseErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseBlueprintsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetRelationalDatabaseBlueprintsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetRelationalDatabaseBlueprintsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetRelationalDatabaseBlueprintsErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::GetRelationalDatabaseBlueprintsErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::GetRelationalDatabaseBlueprintsErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::GetRelationalDatabaseBlueprintsErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::GetRelationalDatabaseBlueprintsErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::GetRelationalDatabaseBlueprintsErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::GetRelationalDatabaseBlueprintsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseBundlesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseBundlesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetRelationalDatabaseBundlesErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetRelationalDatabaseBundlesErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::GetRelationalDatabaseBundlesErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::GetRelationalDatabaseBundlesErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::GetRelationalDatabaseBundlesErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::GetRelationalDatabaseBundlesErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::GetRelationalDatabaseBundlesErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::GetRelationalDatabaseBundlesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseEventsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseEventsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetRelationalDatabaseEventsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetRelationalDatabaseEventsErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::GetRelationalDatabaseEventsErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::GetRelationalDatabaseEventsErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::GetRelationalDatabaseEventsErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::GetRelationalDatabaseEventsErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::GetRelationalDatabaseEventsErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::GetRelationalDatabaseEventsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseLogEventsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetRelationalDatabaseLogEventsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetRelationalDatabaseLogEventsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetRelationalDatabaseLogEventsErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::GetRelationalDatabaseLogEventsErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::GetRelationalDatabaseLogEventsErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::GetRelationalDatabaseLogEventsErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::GetRelationalDatabaseLogEventsErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::GetRelationalDatabaseLogEventsErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::GetRelationalDatabaseLogEventsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseLogStreamsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetRelationalDatabaseLogStreamsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetRelationalDatabaseLogStreamsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetRelationalDatabaseLogStreamsErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::GetRelationalDatabaseLogStreamsErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::GetRelationalDatabaseLogStreamsErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::GetRelationalDatabaseLogStreamsErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::GetRelationalDatabaseLogStreamsErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::GetRelationalDatabaseLogStreamsErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::GetRelationalDatabaseLogStreamsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::GetRelationalDatabaseMasterUserPasswordError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetRelationalDatabaseMasterUserPasswordError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetRelationalDatabaseMasterUserPasswordErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetRelationalDatabaseMasterUserPasswordErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::GetRelationalDatabaseMasterUserPasswordErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::GetRelationalDatabaseMasterUserPasswordErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::GetRelationalDatabaseMasterUserPasswordErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::GetRelationalDatabaseMasterUserPasswordErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::GetRelationalDatabaseMasterUserPasswordErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::GetRelationalDatabaseMasterUserPasswordErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseMetricDataError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetRelationalDatabaseMetricDataError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetRelationalDatabaseMetricDataErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetRelationalDatabaseMetricDataErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::GetRelationalDatabaseMetricDataErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::GetRelationalDatabaseMetricDataErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::GetRelationalDatabaseMetricDataErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::GetRelationalDatabaseMetricDataErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::GetRelationalDatabaseMetricDataErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::GetRelationalDatabaseMetricDataErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseParametersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetRelationalDatabaseParametersError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetRelationalDatabaseParametersErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetRelationalDatabaseParametersErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::GetRelationalDatabaseParametersErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::GetRelationalDatabaseParametersErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::GetRelationalDatabaseParametersErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::GetRelationalDatabaseParametersErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::GetRelationalDatabaseParametersErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::GetRelationalDatabaseParametersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabasesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabasesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetRelationalDatabasesErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetRelationalDatabasesErrorKind::AccountSetupInProgressException(
                    inner,
                ) => Error::AccountSetupInProgressException(inner),
                crate::error::GetRelationalDatabasesErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetRelationalDatabasesErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetRelationalDatabasesErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetRelationalDatabasesErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetRelationalDatabasesErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetRelationalDatabasesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetRelationalDatabaseSnapshotErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetRelationalDatabaseSnapshotErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::GetRelationalDatabaseSnapshotErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::GetRelationalDatabaseSnapshotErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::GetRelationalDatabaseSnapshotErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::GetRelationalDatabaseSnapshotErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::GetRelationalDatabaseSnapshotErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::GetRelationalDatabaseSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::GetRelationalDatabaseSnapshotsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::GetRelationalDatabaseSnapshotsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::GetRelationalDatabaseSnapshotsErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::GetRelationalDatabaseSnapshotsErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::GetRelationalDatabaseSnapshotsErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::GetRelationalDatabaseSnapshotsErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::GetRelationalDatabaseSnapshotsErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::GetRelationalDatabaseSnapshotsErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::GetRelationalDatabaseSnapshotsErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::GetRelationalDatabaseSnapshotsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetStaticIpError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetStaticIpError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetStaticIpErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetStaticIpErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::GetStaticIpErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetStaticIpErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetStaticIpErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetStaticIpErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetStaticIpErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetStaticIpErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::GetStaticIpsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::GetStaticIpsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::GetStaticIpsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::GetStaticIpsErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::GetStaticIpsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::GetStaticIpsErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::GetStaticIpsErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::GetStaticIpsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::GetStaticIpsErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::GetStaticIpsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ImportKeyPairError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ImportKeyPairError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ImportKeyPairErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ImportKeyPairErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::ImportKeyPairErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ImportKeyPairErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::ImportKeyPairErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::ImportKeyPairErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::ImportKeyPairErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::ImportKeyPairErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::IsVpcPeeredError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::IsVpcPeeredError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::IsVpcPeeredErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::IsVpcPeeredErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::IsVpcPeeredErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::IsVpcPeeredErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::IsVpcPeeredErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::IsVpcPeeredErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::IsVpcPeeredErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::IsVpcPeeredErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::OpenInstancePublicPortsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::OpenInstancePublicPortsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::OpenInstancePublicPortsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::OpenInstancePublicPortsErrorKind::AccountSetupInProgressException(
                    inner,
                ) => Error::AccountSetupInProgressException(inner),
                crate::error::OpenInstancePublicPortsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::OpenInstancePublicPortsErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::OpenInstancePublicPortsErrorKind::OperationFailureException(
                    inner,
                ) => Error::OperationFailureException(inner),
                crate::error::OpenInstancePublicPortsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::OpenInstancePublicPortsErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::OpenInstancePublicPortsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PeerVpcError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PeerVpcError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PeerVpcErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::PeerVpcErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::PeerVpcErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::PeerVpcErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::PeerVpcErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::PeerVpcErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::PeerVpcErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::PeerVpcErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutAlarmError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::PutAlarmError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutAlarmErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::PutAlarmErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::PutAlarmErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::PutAlarmErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::PutAlarmErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::PutAlarmErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::PutAlarmErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PutInstancePublicPortsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PutInstancePublicPortsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PutInstancePublicPortsErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::PutInstancePublicPortsErrorKind::AccountSetupInProgressException(
                    inner,
                ) => Error::AccountSetupInProgressException(inner),
                crate::error::PutInstancePublicPortsErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::PutInstancePublicPortsErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::PutInstancePublicPortsErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::PutInstancePublicPortsErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::PutInstancePublicPortsErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::PutInstancePublicPortsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RebootInstanceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::RebootInstanceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RebootInstanceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::RebootInstanceErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::RebootInstanceErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::RebootInstanceErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::RebootInstanceErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::RebootInstanceErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::RebootInstanceErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::RebootInstanceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RebootRelationalDatabaseError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RebootRelationalDatabaseError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RebootRelationalDatabaseErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::RebootRelationalDatabaseErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::RebootRelationalDatabaseErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::RebootRelationalDatabaseErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::RebootRelationalDatabaseErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::RebootRelationalDatabaseErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::RebootRelationalDatabaseErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::RebootRelationalDatabaseErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RegisterContainerImageError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RegisterContainerImageError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RegisterContainerImageErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::RegisterContainerImageErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::RegisterContainerImageErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::RegisterContainerImageErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::RegisterContainerImageErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::RegisterContainerImageErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ReleaseStaticIpError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ReleaseStaticIpError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ReleaseStaticIpErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ReleaseStaticIpErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::ReleaseStaticIpErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ReleaseStaticIpErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::ReleaseStaticIpErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::ReleaseStaticIpErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::ReleaseStaticIpErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::ReleaseStaticIpErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ResetDistributionCacheError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ResetDistributionCacheError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ResetDistributionCacheErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::ResetDistributionCacheErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::ResetDistributionCacheErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::ResetDistributionCacheErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::ResetDistributionCacheErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::ResetDistributionCacheErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::ResetDistributionCacheErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SendContactMethodVerificationError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SendContactMethodVerificationError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SendContactMethodVerificationErrorKind::AccessDeniedException(
                    inner,
                ) => Error::AccessDeniedException(inner),
                crate::error::SendContactMethodVerificationErrorKind::InvalidInputException(
                    inner,
                ) => Error::InvalidInputException(inner),
                crate::error::SendContactMethodVerificationErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::SendContactMethodVerificationErrorKind::OperationFailureException(
                    inner,
                ) => Error::OperationFailureException(inner),
                crate::error::SendContactMethodVerificationErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::SendContactMethodVerificationErrorKind::UnauthenticatedException(
                    inner,
                ) => Error::UnauthenticatedException(inner),
                crate::error::SendContactMethodVerificationErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SetIpAddressTypeError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SetIpAddressTypeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SetIpAddressTypeErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::SetIpAddressTypeErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::SetIpAddressTypeErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::SetIpAddressTypeErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::SetIpAddressTypeErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::SetIpAddressTypeErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::SetIpAddressTypeErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::SetIpAddressTypeErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::SetResourceAccessForBucketError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::SetResourceAccessForBucketError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::SetResourceAccessForBucketErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::SetResourceAccessForBucketErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::SetResourceAccessForBucketErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::SetResourceAccessForBucketErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::SetResourceAccessForBucketErrorKind::UnauthenticatedException(
                    inner,
                ) => Error::UnauthenticatedException(inner),
                crate::error::SetResourceAccessForBucketErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartInstanceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StartInstanceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartInstanceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::StartInstanceErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::StartInstanceErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::StartInstanceErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::StartInstanceErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::StartInstanceErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::StartInstanceErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::StartInstanceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartRelationalDatabaseError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartRelationalDatabaseError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartRelationalDatabaseErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::StartRelationalDatabaseErrorKind::AccountSetupInProgressException(
                    inner,
                ) => Error::AccountSetupInProgressException(inner),
                crate::error::StartRelationalDatabaseErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::StartRelationalDatabaseErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::StartRelationalDatabaseErrorKind::OperationFailureException(
                    inner,
                ) => Error::OperationFailureException(inner),
                crate::error::StartRelationalDatabaseErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::StartRelationalDatabaseErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::StartRelationalDatabaseErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopInstanceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StopInstanceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopInstanceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::StopInstanceErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::StopInstanceErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::StopInstanceErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::StopInstanceErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::StopInstanceErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::StopInstanceErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::StopInstanceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopRelationalDatabaseError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StopRelationalDatabaseError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopRelationalDatabaseErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::StopRelationalDatabaseErrorKind::AccountSetupInProgressException(
                    inner,
                ) => Error::AccountSetupInProgressException(inner),
                crate::error::StopRelationalDatabaseErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::StopRelationalDatabaseErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::StopRelationalDatabaseErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::StopRelationalDatabaseErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::StopRelationalDatabaseErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::StopRelationalDatabaseErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TagResourceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::TagResourceErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::TagResourceErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::TagResourceErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::TagResourceErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::TagResourceErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::TagResourceErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::TagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TestAlarmError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TestAlarmError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TestAlarmErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::TestAlarmErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::TestAlarmErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::TestAlarmErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::TestAlarmErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::TestAlarmErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::TestAlarmErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UnpeerVpcError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UnpeerVpcError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UnpeerVpcErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UnpeerVpcErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::UnpeerVpcErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UnpeerVpcErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::UnpeerVpcErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::UnpeerVpcErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::UnpeerVpcErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::UnpeerVpcErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UntagResourceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UntagResourceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UntagResourceErrorKind::AccountSetupInProgressException(inner) => {
                    Error::AccountSetupInProgressException(inner)
                }
                crate::error::UntagResourceErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UntagResourceErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::UntagResourceErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::UntagResourceErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::UntagResourceErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::UntagResourceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateBucketError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::UpdateBucketError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateBucketErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateBucketErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateBucketErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::UpdateBucketErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::UpdateBucketErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::UpdateBucketErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateBucketBundleError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateBucketBundleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateBucketBundleErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateBucketBundleErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateBucketBundleErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::UpdateBucketBundleErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::UpdateBucketBundleErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::UpdateBucketBundleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateContainerServiceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateContainerServiceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateContainerServiceErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateContainerServiceErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateContainerServiceErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::UpdateContainerServiceErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::UpdateContainerServiceErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::UpdateContainerServiceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateDistributionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateDistributionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateDistributionErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateDistributionErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateDistributionErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::UpdateDistributionErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::UpdateDistributionErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::UpdateDistributionErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::UpdateDistributionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateDistributionBundleError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateDistributionBundleError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateDistributionBundleErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateDistributionBundleErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateDistributionBundleErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::UpdateDistributionBundleErrorKind::OperationFailureException(
                    inner,
                ) => Error::OperationFailureException(inner),
                crate::error::UpdateDistributionBundleErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::UpdateDistributionBundleErrorKind::UnauthenticatedException(
                    inner,
                ) => Error::UnauthenticatedException(inner),
                crate::error::UpdateDistributionBundleErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateDomainEntryError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateDomainEntryError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::UpdateDomainEntryErrorKind::AccessDeniedException(inner) => {
                    Error::AccessDeniedException(inner)
                }
                crate::error::UpdateDomainEntryErrorKind::AccountSetupInProgressException(
                    inner,
                ) => Error::AccountSetupInProgressException(inner),
                crate::error::UpdateDomainEntryErrorKind::InvalidInputException(inner) => {
                    Error::InvalidInputException(inner)
                }
                crate::error::UpdateDomainEntryErrorKind::NotFoundException(inner) => {
                    Error::NotFoundException(inner)
                }
                crate::error::UpdateDomainEntryErrorKind::OperationFailureException(inner) => {
                    Error::OperationFailureException(inner)
                }
                crate::error::UpdateDomainEntryErrorKind::ServiceException(inner) => {
                    Error::ServiceException(inner)
                }
                crate::error::UpdateDomainEntryErrorKind::UnauthenticatedException(inner) => {
                    Error::UnauthenticatedException(inner)
                }
                crate::error::UpdateDomainEntryErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateLoadBalancerAttributeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateLoadBalancerAttributeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateLoadBalancerAttributeErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::UpdateLoadBalancerAttributeErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::UpdateLoadBalancerAttributeErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::UpdateLoadBalancerAttributeErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::UpdateLoadBalancerAttributeErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::UpdateLoadBalancerAttributeErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::UpdateLoadBalancerAttributeErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::UpdateLoadBalancerAttributeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::UpdateRelationalDatabaseError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::UpdateRelationalDatabaseError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateRelationalDatabaseErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::UpdateRelationalDatabaseErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::UpdateRelationalDatabaseErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::UpdateRelationalDatabaseErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::UpdateRelationalDatabaseErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::UpdateRelationalDatabaseErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::UpdateRelationalDatabaseErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::UpdateRelationalDatabaseErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::UpdateRelationalDatabaseParametersError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::UpdateRelationalDatabaseParametersError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::UpdateRelationalDatabaseParametersErrorKind::AccessDeniedException(inner) => Error::AccessDeniedException(inner),
                crate::error::UpdateRelationalDatabaseParametersErrorKind::AccountSetupInProgressException(inner) => Error::AccountSetupInProgressException(inner),
                crate::error::UpdateRelationalDatabaseParametersErrorKind::InvalidInputException(inner) => Error::InvalidInputException(inner),
                crate::error::UpdateRelationalDatabaseParametersErrorKind::NotFoundException(inner) => Error::NotFoundException(inner),
                crate::error::UpdateRelationalDatabaseParametersErrorKind::OperationFailureException(inner) => Error::OperationFailureException(inner),
                crate::error::UpdateRelationalDatabaseParametersErrorKind::ServiceException(inner) => Error::ServiceException(inner),
                crate::error::UpdateRelationalDatabaseParametersErrorKind::UnauthenticatedException(inner) => Error::UnauthenticatedException(inner),
                crate::error::UpdateRelationalDatabaseParametersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
