// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AllocateStaticIpInput`](crate::input::AllocateStaticIpInput)
pub mod allocate_static_ip_input {
    /// A builder for [`AllocateStaticIpInput`](crate::input::AllocateStaticIpInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) static_ip_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the static IP address.</p>
        pub fn static_ip_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.static_ip_name = Some(input.into());
            self
        }
        /// <p>The name of the static IP address.</p>
        pub fn set_static_ip_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.static_ip_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AllocateStaticIpInput`](crate::input::AllocateStaticIpInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AllocateStaticIpInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AllocateStaticIpInput {
                static_ip_name: self.static_ip_name,
            })
        }
    }
}
#[doc(hidden)]
pub type AllocateStaticIpInputOperationOutputAlias = crate::operation::AllocateStaticIp;
#[doc(hidden)]
pub type AllocateStaticIpInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AllocateStaticIpInput {
    /// Consumes the builder and constructs an Operation<[`AllocateStaticIp`](crate::operation::AllocateStaticIp)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AllocateStaticIp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AllocateStaticIpInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AllocateStaticIpInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.AllocateStaticIp",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_allocate_static_ip(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AllocateStaticIp::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AllocateStaticIp",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AllocateStaticIpInput`](crate::input::AllocateStaticIpInput)
    pub fn builder() -> crate::input::allocate_static_ip_input::Builder {
        crate::input::allocate_static_ip_input::Builder::default()
    }
}

/// See [`AttachCertificateToDistributionInput`](crate::input::AttachCertificateToDistributionInput)
pub mod attach_certificate_to_distribution_input {
    /// A builder for [`AttachCertificateToDistributionInput`](crate::input::AttachCertificateToDistributionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_name: std::option::Option<std::string::String>,
        pub(crate) certificate_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the distribution that the certificate will be attached to.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you can specify.</p>
        pub fn distribution_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.distribution_name = Some(input.into());
            self
        }
        /// <p>The name of the distribution that the certificate will be attached to.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you can specify.</p>
        pub fn set_distribution_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_name = input;
            self
        }
        /// <p>The name of the certificate to attach to a distribution.</p>
        /// <p>Only certificates with a status of <code>ISSUED</code> can be attached to a distribution.</p>
        /// <p>Use the <code>GetCertificates</code> action to get a list of certificate names that you can specify.</p> <note>
        /// <p>This is the name of the certificate resource type and is used only to reference the certificate in other API actions. It can be different than the domain name of the certificate. For example, your certificate name might be <code>WordPress-Blog-Certificate</code> and the domain name of the certificate might be <code>example.com</code>.</p>
        /// </note>
        pub fn certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_name = Some(input.into());
            self
        }
        /// <p>The name of the certificate to attach to a distribution.</p>
        /// <p>Only certificates with a status of <code>ISSUED</code> can be attached to a distribution.</p>
        /// <p>Use the <code>GetCertificates</code> action to get a list of certificate names that you can specify.</p> <note>
        /// <p>This is the name of the certificate resource type and is used only to reference the certificate in other API actions. It can be different than the domain name of the certificate. For example, your certificate name might be <code>WordPress-Blog-Certificate</code> and the domain name of the certificate might be <code>example.com</code>.</p>
        /// </note>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachCertificateToDistributionInput`](crate::input::AttachCertificateToDistributionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachCertificateToDistributionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachCertificateToDistributionInput {
                distribution_name: self.distribution_name,
                certificate_name: self.certificate_name,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachCertificateToDistributionInputOperationOutputAlias =
    crate::operation::AttachCertificateToDistribution;
#[doc(hidden)]
pub type AttachCertificateToDistributionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AttachCertificateToDistributionInput {
    /// Consumes the builder and constructs an Operation<[`AttachCertificateToDistribution`](crate::operation::AttachCertificateToDistribution)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachCertificateToDistribution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AttachCertificateToDistributionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AttachCertificateToDistributionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.AttachCertificateToDistribution",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_attach_certificate_to_distribution(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachCertificateToDistribution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachCertificateToDistribution",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AttachCertificateToDistributionInput`](crate::input::AttachCertificateToDistributionInput)
    pub fn builder() -> crate::input::attach_certificate_to_distribution_input::Builder {
        crate::input::attach_certificate_to_distribution_input::Builder::default()
    }
}

/// See [`AttachDiskInput`](crate::input::AttachDiskInput)
pub mod attach_disk_input {
    /// A builder for [`AttachDiskInput`](crate::input::AttachDiskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) disk_name: std::option::Option<std::string::String>,
        pub(crate) instance_name: std::option::Option<std::string::String>,
        pub(crate) disk_path: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique Lightsail disk name (e.g., <code>my-disk</code>).</p>
        pub fn disk_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.disk_name = Some(input.into());
            self
        }
        /// <p>The unique Lightsail disk name (e.g., <code>my-disk</code>).</p>
        pub fn set_disk_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.disk_name = input;
            self
        }
        /// <p>The name of the Lightsail instance where you want to utilize the storage disk.</p>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_name = Some(input.into());
            self
        }
        /// <p>The name of the Lightsail instance where you want to utilize the storage disk.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_name = input;
            self
        }
        /// <p>The disk path to expose to the instance (e.g., <code>/dev/xvdf</code>).</p>
        pub fn disk_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.disk_path = Some(input.into());
            self
        }
        /// <p>The disk path to expose to the instance (e.g., <code>/dev/xvdf</code>).</p>
        pub fn set_disk_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.disk_path = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachDiskInput`](crate::input::AttachDiskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachDiskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachDiskInput {
                disk_name: self.disk_name,
                instance_name: self.instance_name,
                disk_path: self.disk_path,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachDiskInputOperationOutputAlias = crate::operation::AttachDisk;
#[doc(hidden)]
pub type AttachDiskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AttachDiskInput {
    /// Consumes the builder and constructs an Operation<[`AttachDisk`](crate::operation::AttachDisk)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachDisk,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AttachDiskInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AttachDiskInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.AttachDisk",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_attach_disk(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachDisk::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachDisk",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AttachDiskInput`](crate::input::AttachDiskInput)
    pub fn builder() -> crate::input::attach_disk_input::Builder {
        crate::input::attach_disk_input::Builder::default()
    }
}

/// See [`AttachInstancesToLoadBalancerInput`](crate::input::AttachInstancesToLoadBalancerInput)
pub mod attach_instances_to_load_balancer_input {
    /// A builder for [`AttachInstancesToLoadBalancerInput`](crate::input::AttachInstancesToLoadBalancerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) instance_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// Appends an item to `instance_names`.
        ///
        /// To override the contents of this collection use [`set_instance_names`](Self::set_instance_names).
        ///
        /// <p>An array of strings representing the instance name(s) you want to attach to your load balancer.</p>
        /// <p>An instance must be <code>running</code> before you can attach it to your load balancer.</p>
        /// <p>There are no additional limits on the number of instances you can attach to your load balancer, aside from the limit of Lightsail instances you can create in your account (20).</p>
        pub fn instance_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_names.unwrap_or_default();
            v.push(input.into());
            self.instance_names = Some(v);
            self
        }
        /// <p>An array of strings representing the instance name(s) you want to attach to your load balancer.</p>
        /// <p>An instance must be <code>running</code> before you can attach it to your load balancer.</p>
        /// <p>There are no additional limits on the number of instances you can attach to your load balancer, aside from the limit of Lightsail instances you can create in your account (20).</p>
        pub fn set_instance_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_names = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachInstancesToLoadBalancerInput`](crate::input::AttachInstancesToLoadBalancerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachInstancesToLoadBalancerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachInstancesToLoadBalancerInput {
                load_balancer_name: self.load_balancer_name,
                instance_names: self.instance_names,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachInstancesToLoadBalancerInputOperationOutputAlias =
    crate::operation::AttachInstancesToLoadBalancer;
#[doc(hidden)]
pub type AttachInstancesToLoadBalancerInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AttachInstancesToLoadBalancerInput {
    /// Consumes the builder and constructs an Operation<[`AttachInstancesToLoadBalancer`](crate::operation::AttachInstancesToLoadBalancer)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachInstancesToLoadBalancer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AttachInstancesToLoadBalancerInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AttachInstancesToLoadBalancerInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.AttachInstancesToLoadBalancer",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_attach_instances_to_load_balancer(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachInstancesToLoadBalancer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachInstancesToLoadBalancer",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AttachInstancesToLoadBalancerInput`](crate::input::AttachInstancesToLoadBalancerInput)
    pub fn builder() -> crate::input::attach_instances_to_load_balancer_input::Builder {
        crate::input::attach_instances_to_load_balancer_input::Builder::default()
    }
}

/// See [`AttachLoadBalancerTlsCertificateInput`](crate::input::AttachLoadBalancerTlsCertificateInput)
pub mod attach_load_balancer_tls_certificate_input {
    /// A builder for [`AttachLoadBalancerTlsCertificateInput`](crate::input::AttachLoadBalancerTlsCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) certificate_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the load balancer to which you want to associate the SSL/TLS certificate.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer to which you want to associate the SSL/TLS certificate.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// <p>The name of your SSL/TLS certificate.</p>
        pub fn certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_name = Some(input.into());
            self
        }
        /// <p>The name of your SSL/TLS certificate.</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachLoadBalancerTlsCertificateInput`](crate::input::AttachLoadBalancerTlsCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachLoadBalancerTlsCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachLoadBalancerTlsCertificateInput {
                load_balancer_name: self.load_balancer_name,
                certificate_name: self.certificate_name,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachLoadBalancerTlsCertificateInputOperationOutputAlias =
    crate::operation::AttachLoadBalancerTlsCertificate;
#[doc(hidden)]
pub type AttachLoadBalancerTlsCertificateInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AttachLoadBalancerTlsCertificateInput {
    /// Consumes the builder and constructs an Operation<[`AttachLoadBalancerTlsCertificate`](crate::operation::AttachLoadBalancerTlsCertificate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachLoadBalancerTlsCertificate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AttachLoadBalancerTlsCertificateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AttachLoadBalancerTlsCertificateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.AttachLoadBalancerTlsCertificate",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_attach_load_balancer_tls_certificate(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachLoadBalancerTlsCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachLoadBalancerTlsCertificate",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AttachLoadBalancerTlsCertificateInput`](crate::input::AttachLoadBalancerTlsCertificateInput)
    pub fn builder() -> crate::input::attach_load_balancer_tls_certificate_input::Builder {
        crate::input::attach_load_balancer_tls_certificate_input::Builder::default()
    }
}

/// See [`AttachStaticIpInput`](crate::input::AttachStaticIpInput)
pub mod attach_static_ip_input {
    /// A builder for [`AttachStaticIpInput`](crate::input::AttachStaticIpInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) static_ip_name: std::option::Option<std::string::String>,
        pub(crate) instance_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the static IP.</p>
        pub fn static_ip_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.static_ip_name = Some(input.into());
            self
        }
        /// <p>The name of the static IP.</p>
        pub fn set_static_ip_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.static_ip_name = input;
            self
        }
        /// <p>The instance name to which you want to attach the static IP address.</p>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_name = Some(input.into());
            self
        }
        /// <p>The instance name to which you want to attach the static IP address.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachStaticIpInput`](crate::input::AttachStaticIpInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AttachStaticIpInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AttachStaticIpInput {
                static_ip_name: self.static_ip_name,
                instance_name: self.instance_name,
            })
        }
    }
}
#[doc(hidden)]
pub type AttachStaticIpInputOperationOutputAlias = crate::operation::AttachStaticIp;
#[doc(hidden)]
pub type AttachStaticIpInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AttachStaticIpInput {
    /// Consumes the builder and constructs an Operation<[`AttachStaticIp`](crate::operation::AttachStaticIp)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AttachStaticIp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AttachStaticIpInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AttachStaticIpInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.AttachStaticIp",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_attach_static_ip(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AttachStaticIp::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AttachStaticIp",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AttachStaticIpInput`](crate::input::AttachStaticIpInput)
    pub fn builder() -> crate::input::attach_static_ip_input::Builder {
        crate::input::attach_static_ip_input::Builder::default()
    }
}

/// See [`CloseInstancePublicPortsInput`](crate::input::CloseInstancePublicPortsInput)
pub mod close_instance_public_ports_input {
    /// A builder for [`CloseInstancePublicPortsInput`](crate::input::CloseInstancePublicPortsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) port_info: std::option::Option<crate::model::PortInfo>,
        pub(crate) instance_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An object to describe the ports to close for the specified instance.</p>
        pub fn port_info(mut self, input: crate::model::PortInfo) -> Self {
            self.port_info = Some(input);
            self
        }
        /// <p>An object to describe the ports to close for the specified instance.</p>
        pub fn set_port_info(mut self, input: std::option::Option<crate::model::PortInfo>) -> Self {
            self.port_info = input;
            self
        }
        /// <p>The name of the instance for which to close ports.</p>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_name = Some(input.into());
            self
        }
        /// <p>The name of the instance for which to close ports.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CloseInstancePublicPortsInput`](crate::input::CloseInstancePublicPortsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CloseInstancePublicPortsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CloseInstancePublicPortsInput {
                port_info: self.port_info,
                instance_name: self.instance_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CloseInstancePublicPortsInputOperationOutputAlias =
    crate::operation::CloseInstancePublicPorts;
#[doc(hidden)]
pub type CloseInstancePublicPortsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CloseInstancePublicPortsInput {
    /// Consumes the builder and constructs an Operation<[`CloseInstancePublicPorts`](crate::operation::CloseInstancePublicPorts)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CloseInstancePublicPorts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CloseInstancePublicPortsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CloseInstancePublicPortsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CloseInstancePublicPorts",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_close_instance_public_ports(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CloseInstancePublicPorts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CloseInstancePublicPorts",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CloseInstancePublicPortsInput`](crate::input::CloseInstancePublicPortsInput)
    pub fn builder() -> crate::input::close_instance_public_ports_input::Builder {
        crate::input::close_instance_public_ports_input::Builder::default()
    }
}

/// See [`CopySnapshotInput`](crate::input::CopySnapshotInput)
pub mod copy_snapshot_input {
    /// A builder for [`CopySnapshotInput`](crate::input::CopySnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_snapshot_name: std::option::Option<std::string::String>,
        pub(crate) source_resource_name: std::option::Option<std::string::String>,
        pub(crate) restore_date: std::option::Option<std::string::String>,
        pub(crate) use_latest_restorable_auto_snapshot: std::option::Option<bool>,
        pub(crate) target_snapshot_name: std::option::Option<std::string::String>,
        pub(crate) source_region: std::option::Option<crate::model::RegionName>,
    }
    impl Builder {
        /// <p>The name of the source manual snapshot to copy.</p>
        /// <p>Constraint:</p>
        /// <ul>
        /// <li> <p>Define this parameter only when copying a manual snapshot as another manual snapshot.</p> </li>
        /// </ul>
        pub fn source_snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_snapshot_name = Some(input.into());
            self
        }
        /// <p>The name of the source manual snapshot to copy.</p>
        /// <p>Constraint:</p>
        /// <ul>
        /// <li> <p>Define this parameter only when copying a manual snapshot as another manual snapshot.</p> </li>
        /// </ul>
        pub fn set_source_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_snapshot_name = input;
            self
        }
        /// <p>The name of the source instance or disk from which the source automatic snapshot was created.</p>
        /// <p>Constraint:</p>
        /// <ul>
        /// <li> <p>Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p> </li>
        /// </ul>
        pub fn source_resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_resource_name = Some(input.into());
            self
        }
        /// <p>The name of the source instance or disk from which the source automatic snapshot was created.</p>
        /// <p>Constraint:</p>
        /// <ul>
        /// <li> <p>Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p> </li>
        /// </ul>
        pub fn set_source_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_resource_name = input;
            self
        }
        /// <p>The date of the source automatic snapshot to copy. Use the <code>get auto snapshots</code> operation to identify the dates of the available automatic snapshots.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be specified in <code>YYYY-MM-DD</code> format.</p> </li>
        /// <li> <p>This parameter cannot be defined together with the <code>use latest restorable auto snapshot</code> parameter. The <code>restore date</code> and <code>use latest restorable auto snapshot</code> parameters are mutually exclusive.</p> </li>
        /// <li> <p>Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p> </li>
        /// </ul>
        pub fn restore_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.restore_date = Some(input.into());
            self
        }
        /// <p>The date of the source automatic snapshot to copy. Use the <code>get auto snapshots</code> operation to identify the dates of the available automatic snapshots.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be specified in <code>YYYY-MM-DD</code> format.</p> </li>
        /// <li> <p>This parameter cannot be defined together with the <code>use latest restorable auto snapshot</code> parameter. The <code>restore date</code> and <code>use latest restorable auto snapshot</code> parameters are mutually exclusive.</p> </li>
        /// <li> <p>Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p> </li>
        /// </ul>
        pub fn set_restore_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.restore_date = input;
            self
        }
        /// <p>A Boolean value to indicate whether to use the latest available automatic snapshot of the specified source instance or disk.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>This parameter cannot be defined together with the <code>restore date</code> parameter. The <code>use latest restorable auto snapshot</code> and <code>restore date</code> parameters are mutually exclusive.</p> </li>
        /// <li> <p>Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p> </li>
        /// </ul>
        pub fn use_latest_restorable_auto_snapshot(mut self, input: bool) -> Self {
            self.use_latest_restorable_auto_snapshot = Some(input);
            self
        }
        /// <p>A Boolean value to indicate whether to use the latest available automatic snapshot of the specified source instance or disk.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>This parameter cannot be defined together with the <code>restore date</code> parameter. The <code>use latest restorable auto snapshot</code> and <code>restore date</code> parameters are mutually exclusive.</p> </li>
        /// <li> <p>Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p> </li>
        /// </ul>
        pub fn set_use_latest_restorable_auto_snapshot(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_latest_restorable_auto_snapshot = input;
            self
        }
        /// <p>The name of the new manual snapshot to be created as a copy.</p>
        pub fn target_snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_snapshot_name = Some(input.into());
            self
        }
        /// <p>The name of the new manual snapshot to be created as a copy.</p>
        pub fn set_target_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_snapshot_name = input;
            self
        }
        /// <p>The AWS Region where the source manual or automatic snapshot is located.</p>
        pub fn source_region(mut self, input: crate::model::RegionName) -> Self {
            self.source_region = Some(input);
            self
        }
        /// <p>The AWS Region where the source manual or automatic snapshot is located.</p>
        pub fn set_source_region(
            mut self,
            input: std::option::Option<crate::model::RegionName>,
        ) -> Self {
            self.source_region = input;
            self
        }
        /// Consumes the builder and constructs a [`CopySnapshotInput`](crate::input::CopySnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CopySnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CopySnapshotInput {
                source_snapshot_name: self.source_snapshot_name,
                source_resource_name: self.source_resource_name,
                restore_date: self.restore_date,
                use_latest_restorable_auto_snapshot: self.use_latest_restorable_auto_snapshot,
                target_snapshot_name: self.target_snapshot_name,
                source_region: self.source_region,
            })
        }
    }
}
#[doc(hidden)]
pub type CopySnapshotInputOperationOutputAlias = crate::operation::CopySnapshot;
#[doc(hidden)]
pub type CopySnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CopySnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CopySnapshot`](crate::operation::CopySnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopySnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CopySnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CopySnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CopySnapshot",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_copy_snapshot(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CopySnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CopySnapshot",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CopySnapshotInput`](crate::input::CopySnapshotInput)
    pub fn builder() -> crate::input::copy_snapshot_input::Builder {
        crate::input::copy_snapshot_input::Builder::default()
    }
}

/// See [`CreateBucketInput`](crate::input::CreateBucketInput)
pub mod create_bucket_input {
    /// A builder for [`CreateBucketInput`](crate::input::CreateBucketInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) bundle_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) enable_object_versioning: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name for the bucket.</p>
        /// <p>For more information about bucket names, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/bucket-naming-rules-in-amazon-lightsail">Bucket naming rules in Amazon Lightsail</a> in the <i>Amazon Lightsail Developer Guide</i>.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name for the bucket.</p>
        /// <p>For more information about bucket names, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/bucket-naming-rules-in-amazon-lightsail">Bucket naming rules in Amazon Lightsail</a> in the <i>Amazon Lightsail Developer Guide</i>.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The ID of the bundle to use for the bucket.</p>
        /// <p>A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a bucket.</p>
        /// <p>Use the <a href="https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBucketBundles.html">GetBucketBundles</a> action to get a list of bundle IDs that you can specify.</p>
        /// <p>Use the <a href="https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_UpdateBucketBundle.html">UpdateBucketBundle</a> action to change the bundle after the bucket is created.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_id = Some(input.into());
            self
        }
        /// <p>The ID of the bundle to use for the bucket.</p>
        /// <p>A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a bucket.</p>
        /// <p>Use the <a href="https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBucketBundles.html">GetBucketBundles</a> action to get a list of bundle IDs that you can specify.</p>
        /// <p>Use the <a href="https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_UpdateBucketBundle.html">UpdateBucketBundle</a> action to change the bundle after the bucket is created.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the bucket during creation.</p>
        /// <p>Use the <a href="https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_TagResource.html">TagResource</a> action to tag the bucket after it's created.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values to add to the bucket during creation.</p>
        /// <p>Use the <a href="https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_TagResource.html">TagResource</a> action to tag the bucket after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A Boolean value that indicates whether to enable versioning of objects in the bucket.</p>
        /// <p>For more information about versioning, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-managing-bucket-object-versioning">Enabling and suspending object versioning in a bucket in Amazon Lightsail</a> in the <i>Amazon Lightsail Developer Guide</i>.</p>
        pub fn enable_object_versioning(mut self, input: bool) -> Self {
            self.enable_object_versioning = Some(input);
            self
        }
        /// <p>A Boolean value that indicates whether to enable versioning of objects in the bucket.</p>
        /// <p>For more information about versioning, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-managing-bucket-object-versioning">Enabling and suspending object versioning in a bucket in Amazon Lightsail</a> in the <i>Amazon Lightsail Developer Guide</i>.</p>
        pub fn set_enable_object_versioning(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_object_versioning = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBucketInput`](crate::input::CreateBucketInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBucketInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBucketInput {
                bucket_name: self.bucket_name,
                bundle_id: self.bundle_id,
                tags: self.tags,
                enable_object_versioning: self.enable_object_versioning,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBucketInputOperationOutputAlias = crate::operation::CreateBucket;
#[doc(hidden)]
pub type CreateBucketInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateBucketInput {
    /// Consumes the builder and constructs an Operation<[`CreateBucket`](crate::operation::CreateBucket)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBucket,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateBucketInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateBucketInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CreateBucket",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_bucket(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBucket::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBucket",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateBucketInput`](crate::input::CreateBucketInput)
    pub fn builder() -> crate::input::create_bucket_input::Builder {
        crate::input::create_bucket_input::Builder::default()
    }
}

/// See [`CreateBucketAccessKeyInput`](crate::input::CreateBucketAccessKeyInput)
pub mod create_bucket_access_key_input {
    /// A builder for [`CreateBucketAccessKeyInput`](crate::input::CreateBucketAccessKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket that the new access key will belong to, and grant access to.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the bucket that the new access key will belong to, and grant access to.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBucketAccessKeyInput`](crate::input::CreateBucketAccessKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBucketAccessKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBucketAccessKeyInput {
                bucket_name: self.bucket_name,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBucketAccessKeyInputOperationOutputAlias = crate::operation::CreateBucketAccessKey;
#[doc(hidden)]
pub type CreateBucketAccessKeyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateBucketAccessKeyInput {
    /// Consumes the builder and constructs an Operation<[`CreateBucketAccessKey`](crate::operation::CreateBucketAccessKey)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBucketAccessKey,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateBucketAccessKeyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateBucketAccessKeyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CreateBucketAccessKey",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_bucket_access_key(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBucketAccessKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBucketAccessKey",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateBucketAccessKeyInput`](crate::input::CreateBucketAccessKeyInput)
    pub fn builder() -> crate::input::create_bucket_access_key_input::Builder {
        crate::input::create_bucket_access_key_input::Builder::default()
    }
}

/// See [`CreateCertificateInput`](crate::input::CreateCertificateInput)
pub mod create_certificate_input {
    /// A builder for [`CreateCertificateInput`](crate::input::CreateCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_name: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) subject_alternative_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name for the certificate.</p>
        pub fn certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_name = Some(input.into());
            self
        }
        /// <p>The name for the certificate.</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_name = input;
            self
        }
        /// <p>The domain name (e.g., <code>example.com</code>) for the certificate.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name (e.g., <code>example.com</code>) for the certificate.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Appends an item to `subject_alternative_names`.
        ///
        /// To override the contents of this collection use [`set_subject_alternative_names`](Self::set_subject_alternative_names).
        ///
        /// <p>An array of strings that specify the alternate domains (e.g., <code>example2.com</code>) and subdomains (e.g., <code>blog.example.com</code>) for the certificate.</p>
        /// <p>You can specify a maximum of nine alternate domains (in addition to the primary domain name).</p>
        /// <p>Wildcard domain entries (e.g., <code>*.example.com</code>) are not supported.</p>
        pub fn subject_alternative_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subject_alternative_names.unwrap_or_default();
            v.push(input.into());
            self.subject_alternative_names = Some(v);
            self
        }
        /// <p>An array of strings that specify the alternate domains (e.g., <code>example2.com</code>) and subdomains (e.g., <code>blog.example.com</code>) for the certificate.</p>
        /// <p>You can specify a maximum of nine alternate domains (in addition to the primary domain name).</p>
        /// <p>Wildcard domain entries (e.g., <code>*.example.com</code>) are not supported.</p>
        pub fn set_subject_alternative_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subject_alternative_names = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the certificate during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values to add to the certificate during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCertificateInput`](crate::input::CreateCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCertificateInput {
                certificate_name: self.certificate_name,
                domain_name: self.domain_name,
                subject_alternative_names: self.subject_alternative_names,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCertificateInputOperationOutputAlias = crate::operation::CreateCertificate;
#[doc(hidden)]
pub type CreateCertificateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateCertificateInput {
    /// Consumes the builder and constructs an Operation<[`CreateCertificate`](crate::operation::CreateCertificate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCertificate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateCertificateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateCertificateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CreateCertificate",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_certificate(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCertificate",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateCertificateInput`](crate::input::CreateCertificateInput)
    pub fn builder() -> crate::input::create_certificate_input::Builder {
        crate::input::create_certificate_input::Builder::default()
    }
}

/// See [`CreateCloudFormationStackInput`](crate::input::CreateCloudFormationStackInput)
pub mod create_cloud_formation_stack_input {
    /// A builder for [`CreateCloudFormationStackInput`](crate::input::CreateCloudFormationStackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instances: std::option::Option<std::vec::Vec<crate::model::InstanceEntry>>,
    }
    impl Builder {
        /// Appends an item to `instances`.
        ///
        /// To override the contents of this collection use [`set_instances`](Self::set_instances).
        ///
        /// <p>An array of parameters that will be used to create the new Amazon EC2 instance. You can only pass one instance entry at a time in this array. You will get an invalid parameter error if you pass more than one instance entry in this array.</p>
        pub fn instances(mut self, input: crate::model::InstanceEntry) -> Self {
            let mut v = self.instances.unwrap_or_default();
            v.push(input);
            self.instances = Some(v);
            self
        }
        /// <p>An array of parameters that will be used to create the new Amazon EC2 instance. You can only pass one instance entry at a time in this array. You will get an invalid parameter error if you pass more than one instance entry in this array.</p>
        pub fn set_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceEntry>>,
        ) -> Self {
            self.instances = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCloudFormationStackInput`](crate::input::CreateCloudFormationStackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCloudFormationStackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCloudFormationStackInput {
                instances: self.instances,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCloudFormationStackInputOperationOutputAlias =
    crate::operation::CreateCloudFormationStack;
#[doc(hidden)]
pub type CreateCloudFormationStackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateCloudFormationStackInput {
    /// Consumes the builder and constructs an Operation<[`CreateCloudFormationStack`](crate::operation::CreateCloudFormationStack)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCloudFormationStack,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateCloudFormationStackInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateCloudFormationStackInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CreateCloudFormationStack",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_cloud_formation_stack(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCloudFormationStack::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCloudFormationStack",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateCloudFormationStackInput`](crate::input::CreateCloudFormationStackInput)
    pub fn builder() -> crate::input::create_cloud_formation_stack_input::Builder {
        crate::input::create_cloud_formation_stack_input::Builder::default()
    }
}

/// See [`CreateContactMethodInput`](crate::input::CreateContactMethodInput)
pub mod create_contact_method_input {
    /// A builder for [`CreateContactMethodInput`](crate::input::CreateContactMethodInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) protocol: std::option::Option<crate::model::ContactProtocol>,
        pub(crate) contact_endpoint: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The protocol of the contact method, such as <code>Email</code> or <code>SMS</code> (text messaging).</p>
        /// <p>The <code>SMS</code> protocol is supported only in the following AWS Regions.</p>
        /// <ul>
        /// <li> <p>US East (N. Virginia) (<code>us-east-1</code>)</p> </li>
        /// <li> <p>US West (Oregon) (<code>us-west-2</code>)</p> </li>
        /// <li> <p>Europe (Ireland) (<code>eu-west-1</code>)</p> </li>
        /// <li> <p>Asia Pacific (Tokyo) (<code>ap-northeast-1</code>)</p> </li>
        /// <li> <p>Asia Pacific (Singapore) (<code>ap-southeast-1</code>)</p> </li>
        /// <li> <p>Asia Pacific (Sydney) (<code>ap-southeast-2</code>)</p> </li>
        /// </ul>
        /// <p>For a list of countries/regions where SMS text messages can be sent, and the latest AWS Regions where SMS text messaging is supported, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-supported-regions-countries.html">Supported Regions and Countries</a> in the <i>Amazon SNS Developer Guide</i>.</p>
        /// <p>For more information about notifications in Amazon Lightsail, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in Amazon Lightsail</a>.</p>
        pub fn protocol(mut self, input: crate::model::ContactProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol of the contact method, such as <code>Email</code> or <code>SMS</code> (text messaging).</p>
        /// <p>The <code>SMS</code> protocol is supported only in the following AWS Regions.</p>
        /// <ul>
        /// <li> <p>US East (N. Virginia) (<code>us-east-1</code>)</p> </li>
        /// <li> <p>US West (Oregon) (<code>us-west-2</code>)</p> </li>
        /// <li> <p>Europe (Ireland) (<code>eu-west-1</code>)</p> </li>
        /// <li> <p>Asia Pacific (Tokyo) (<code>ap-northeast-1</code>)</p> </li>
        /// <li> <p>Asia Pacific (Singapore) (<code>ap-southeast-1</code>)</p> </li>
        /// <li> <p>Asia Pacific (Sydney) (<code>ap-southeast-2</code>)</p> </li>
        /// </ul>
        /// <p>For a list of countries/regions where SMS text messages can be sent, and the latest AWS Regions where SMS text messaging is supported, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-supported-regions-countries.html">Supported Regions and Countries</a> in the <i>Amazon SNS Developer Guide</i>.</p>
        /// <p>For more information about notifications in Amazon Lightsail, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in Amazon Lightsail</a>.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::ContactProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// <p>The destination of the contact method, such as an email address or a mobile phone number.</p>
        /// <p>Use the E.164 format when specifying a mobile phone number. E.164 is a standard for the phone number structure used for international telecommunication. Phone numbers that follow this format can have a maximum of 15 digits, and they are prefixed with the plus character (+) and the country code. For example, a U.S. phone number in E.164 format would be specified as +1XXX5550100. For more information, see <a href="https://en.wikipedia.org/wiki/E.164">E.164</a> on <i>Wikipedia</i>.</p>
        pub fn contact_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_endpoint = Some(input.into());
            self
        }
        /// <p>The destination of the contact method, such as an email address or a mobile phone number.</p>
        /// <p>Use the E.164 format when specifying a mobile phone number. E.164 is a standard for the phone number structure used for international telecommunication. Phone numbers that follow this format can have a maximum of 15 digits, and they are prefixed with the plus character (+) and the country code. For example, a U.S. phone number in E.164 format would be specified as +1XXX5550100. For more information, see <a href="https://en.wikipedia.org/wiki/E.164">E.164</a> on <i>Wikipedia</i>.</p>
        pub fn set_contact_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateContactMethodInput`](crate::input::CreateContactMethodInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateContactMethodInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateContactMethodInput {
                protocol: self.protocol,
                contact_endpoint: self.contact_endpoint,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateContactMethodInputOperationOutputAlias = crate::operation::CreateContactMethod;
#[doc(hidden)]
pub type CreateContactMethodInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateContactMethodInput {
    /// Consumes the builder and constructs an Operation<[`CreateContactMethod`](crate::operation::CreateContactMethod)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateContactMethod,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateContactMethodInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateContactMethodInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CreateContactMethod",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_contact_method(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateContactMethod::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateContactMethod",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateContactMethodInput`](crate::input::CreateContactMethodInput)
    pub fn builder() -> crate::input::create_contact_method_input::Builder {
        crate::input::create_contact_method_input::Builder::default()
    }
}

/// See [`CreateContainerServiceInput`](crate::input::CreateContainerServiceInput)
pub mod create_container_service_input {
    /// A builder for [`CreateContainerServiceInput`](crate::input::CreateContainerServiceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) power: std::option::Option<crate::model::ContainerServicePowerName>,
        pub(crate) scale: std::option::Option<i32>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) public_domain_names: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) deployment: std::option::Option<crate::model::ContainerServiceDeploymentRequest>,
    }
    impl Builder {
        /// <p>The name for the container service.</p>
        /// <p>The name that you specify for your container service will make up part of its default domain. The default domain of a container service is typically <code>https://
        /// <servicename>
        /// .
        /// <randomguid>
        /// .
        /// <awsregion>
        /// .cs.amazonlightsail.com
        /// </awsregion>
        /// </randomguid>
        /// </servicename></code>. If the name of your container service is <code>container-service-1</code>, and it's located in the US East (Ohio) AWS region (<code>us-east-2</code>), then the domain for your container service will be like the following example: <code>https://container-service-1.ur4EXAMPLE2uq.us-east-2.cs.amazonlightsail.com</code> </p>
        /// <p>The following are the requirements for container service names:</p>
        /// <ul>
        /// <li> <p>Must be unique within each AWS Region in your Lightsail account.</p> </li>
        /// <li> <p>Must contain 1 to 63 characters.</p> </li>
        /// <li> <p>Must contain only alphanumeric characters and hyphens.</p> </li>
        /// <li> <p>A hyphen (-) can separate words but cannot be at the start or end of the name.</p> </li>
        /// </ul>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name for the container service.</p>
        /// <p>The name that you specify for your container service will make up part of its default domain. The default domain of a container service is typically <code>https://
        /// <servicename>
        /// .
        /// <randomguid>
        /// .
        /// <awsregion>
        /// .cs.amazonlightsail.com
        /// </awsregion>
        /// </randomguid>
        /// </servicename></code>. If the name of your container service is <code>container-service-1</code>, and it's located in the US East (Ohio) AWS region (<code>us-east-2</code>), then the domain for your container service will be like the following example: <code>https://container-service-1.ur4EXAMPLE2uq.us-east-2.cs.amazonlightsail.com</code> </p>
        /// <p>The following are the requirements for container service names:</p>
        /// <ul>
        /// <li> <p>Must be unique within each AWS Region in your Lightsail account.</p> </li>
        /// <li> <p>Must contain 1 to 63 characters.</p> </li>
        /// <li> <p>Must contain only alphanumeric characters and hyphens.</p> </li>
        /// <li> <p>A hyphen (-) can separate words but cannot be at the start or end of the name.</p> </li>
        /// </ul>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>The power specification for the container service.</p>
        /// <p>The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container service. The <code>power</code> and <code>scale</code> of a container service makes up its configured capacity. To determine the monthly price of your container service, multiply the base price of the <code>power</code> with the <code>scale</code> (the number of nodes) of the service.</p>
        /// <p>Use the <code>GetContainerServicePowers</code> action to get a list of power options that you can specify using this parameter, and their base monthly cost.</p>
        pub fn power(mut self, input: crate::model::ContainerServicePowerName) -> Self {
            self.power = Some(input);
            self
        }
        /// <p>The power specification for the container service.</p>
        /// <p>The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container service. The <code>power</code> and <code>scale</code> of a container service makes up its configured capacity. To determine the monthly price of your container service, multiply the base price of the <code>power</code> with the <code>scale</code> (the number of nodes) of the service.</p>
        /// <p>Use the <code>GetContainerServicePowers</code> action to get a list of power options that you can specify using this parameter, and their base monthly cost.</p>
        pub fn set_power(
            mut self,
            input: std::option::Option<crate::model::ContainerServicePowerName>,
        ) -> Self {
            self.power = input;
            self
        }
        /// <p>The scale specification for the container service.</p>
        /// <p>The scale specifies the allocated compute nodes of the container service. The <code>power</code> and <code>scale</code> of a container service makes up its configured capacity. To determine the monthly price of your container service, multiply the base price of the <code>power</code> with the <code>scale</code> (the number of nodes) of the service.</p>
        pub fn scale(mut self, input: i32) -> Self {
            self.scale = Some(input);
            self
        }
        /// <p>The scale specification for the container service.</p>
        /// <p>The scale specifies the allocated compute nodes of the container service. The <code>power</code> and <code>scale</code> of a container service makes up its configured capacity. To determine the monthly price of your container service, multiply the base price of the <code>power</code> with the <code>scale</code> (the number of nodes) of the service.</p>
        pub fn set_scale(mut self, input: std::option::Option<i32>) -> Self {
            self.scale = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the container service during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        /// <p>For more information about tags in Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values to add to the container service during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        /// <p>For more information about tags in Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Adds a key-value pair to `public_domain_names`.
        ///
        /// To override the contents of this collection use [`set_public_domain_names`](Self::set_public_domain_names).
        ///
        /// <p>The public domain names to use with the container service, such as <code>example.com</code> and <code>www.example.com</code>.</p>
        /// <p>You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container configured as the public endpoint of your container service.</p>
        /// <p>If you don't specify public domain names, then you can use the default domain of the container service.</p> <important>
        /// <p>You must create and validate an SSL/TLS certificate before you can use public domain names with your container service. Use the <code>CreateCertificate</code> action to create a certificate for the public domain names you want to use with your container service.</p>
        /// </important>
        /// <p>You can specify public domain names using a string to array map as shown in the example later on this page.</p>
        pub fn public_domain_names(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<std::string::String>,
        ) -> Self {
            let mut hash_map = self.public_domain_names.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.public_domain_names = Some(hash_map);
            self
        }
        /// <p>The public domain names to use with the container service, such as <code>example.com</code> and <code>www.example.com</code>.</p>
        /// <p>You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container configured as the public endpoint of your container service.</p>
        /// <p>If you don't specify public domain names, then you can use the default domain of the container service.</p> <important>
        /// <p>You must create and validate an SSL/TLS certificate before you can use public domain names with your container service. Use the <code>CreateCertificate</code> action to create a certificate for the public domain names you want to use with your container service.</p>
        /// </important>
        /// <p>You can specify public domain names using a string to array map as shown in the example later on this page.</p>
        pub fn set_public_domain_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.public_domain_names = input;
            self
        }
        /// <p>An object that describes a deployment for the container service.</p>
        /// <p>A deployment specifies the containers that will be launched on the container service and their settings, such as the ports to open, the environment variables to apply, and the launch command to run. It also specifies the container that will serve as the public endpoint of the deployment and its settings, such as the HTTP or HTTPS port to use, and the health check configuration.</p>
        pub fn deployment(
            mut self,
            input: crate::model::ContainerServiceDeploymentRequest,
        ) -> Self {
            self.deployment = Some(input);
            self
        }
        /// <p>An object that describes a deployment for the container service.</p>
        /// <p>A deployment specifies the containers that will be launched on the container service and their settings, such as the ports to open, the environment variables to apply, and the launch command to run. It also specifies the container that will serve as the public endpoint of the deployment and its settings, such as the HTTP or HTTPS port to use, and the health check configuration.</p>
        pub fn set_deployment(
            mut self,
            input: std::option::Option<crate::model::ContainerServiceDeploymentRequest>,
        ) -> Self {
            self.deployment = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateContainerServiceInput`](crate::input::CreateContainerServiceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateContainerServiceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateContainerServiceInput {
                service_name: self.service_name,
                power: self.power,
                scale: self.scale,
                tags: self.tags,
                public_domain_names: self.public_domain_names,
                deployment: self.deployment,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateContainerServiceInputOperationOutputAlias = crate::operation::CreateContainerService;
#[doc(hidden)]
pub type CreateContainerServiceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateContainerServiceInput {
    /// Consumes the builder and constructs an Operation<[`CreateContainerService`](crate::operation::CreateContainerService)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateContainerService,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateContainerServiceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateContainerServiceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CreateContainerService",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_container_service(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateContainerService::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateContainerService",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateContainerServiceInput`](crate::input::CreateContainerServiceInput)
    pub fn builder() -> crate::input::create_container_service_input::Builder {
        crate::input::create_container_service_input::Builder::default()
    }
}

/// See [`CreateContainerServiceDeploymentInput`](crate::input::CreateContainerServiceDeploymentInput)
pub mod create_container_service_deployment_input {
    /// A builder for [`CreateContainerServiceDeploymentInput`](crate::input::CreateContainerServiceDeploymentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) containers: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Container>,
        >,
        pub(crate) public_endpoint: std::option::Option<crate::model::EndpointRequest>,
    }
    impl Builder {
        /// <p>The name of the container service for which to create the deployment.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the container service for which to create the deployment.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// Adds a key-value pair to `containers`.
        ///
        /// To override the contents of this collection use [`set_containers`](Self::set_containers).
        ///
        /// <p>An object that describes the settings of the containers that will be launched on the container service.</p>
        pub fn containers(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::Container,
        ) -> Self {
            let mut hash_map = self.containers.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.containers = Some(hash_map);
            self
        }
        /// <p>An object that describes the settings of the containers that will be launched on the container service.</p>
        pub fn set_containers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Container>,
            >,
        ) -> Self {
            self.containers = input;
            self
        }
        /// <p>An object that describes the settings of the public endpoint for the container service.</p>
        pub fn public_endpoint(mut self, input: crate::model::EndpointRequest) -> Self {
            self.public_endpoint = Some(input);
            self
        }
        /// <p>An object that describes the settings of the public endpoint for the container service.</p>
        pub fn set_public_endpoint(
            mut self,
            input: std::option::Option<crate::model::EndpointRequest>,
        ) -> Self {
            self.public_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateContainerServiceDeploymentInput`](crate::input::CreateContainerServiceDeploymentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateContainerServiceDeploymentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateContainerServiceDeploymentInput {
                service_name: self.service_name,
                containers: self.containers,
                public_endpoint: self.public_endpoint,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateContainerServiceDeploymentInputOperationOutputAlias =
    crate::operation::CreateContainerServiceDeployment;
#[doc(hidden)]
pub type CreateContainerServiceDeploymentInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateContainerServiceDeploymentInput {
    /// Consumes the builder and constructs an Operation<[`CreateContainerServiceDeployment`](crate::operation::CreateContainerServiceDeployment)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateContainerServiceDeployment,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateContainerServiceDeploymentInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateContainerServiceDeploymentInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CreateContainerServiceDeployment",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_container_service_deployment(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateContainerServiceDeployment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateContainerServiceDeployment",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateContainerServiceDeploymentInput`](crate::input::CreateContainerServiceDeploymentInput)
    pub fn builder() -> crate::input::create_container_service_deployment_input::Builder {
        crate::input::create_container_service_deployment_input::Builder::default()
    }
}

/// See [`CreateContainerServiceRegistryLoginInput`](crate::input::CreateContainerServiceRegistryLoginInput)
pub mod create_container_service_registry_login_input {
    /// A builder for [`CreateContainerServiceRegistryLoginInput`](crate::input::CreateContainerServiceRegistryLoginInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateContainerServiceRegistryLoginInput`](crate::input::CreateContainerServiceRegistryLoginInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateContainerServiceRegistryLoginInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateContainerServiceRegistryLoginInput {})
        }
    }
}
#[doc(hidden)]
pub type CreateContainerServiceRegistryLoginInputOperationOutputAlias =
    crate::operation::CreateContainerServiceRegistryLogin;
#[doc(hidden)]
pub type CreateContainerServiceRegistryLoginInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateContainerServiceRegistryLoginInput {
    /// Consumes the builder and constructs an Operation<[`CreateContainerServiceRegistryLogin`](crate::operation::CreateContainerServiceRegistryLogin)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateContainerServiceRegistryLogin,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateContainerServiceRegistryLoginInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateContainerServiceRegistryLoginInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CreateContainerServiceRegistryLogin",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_container_service_registry_login(&self)?
        );
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateContainerServiceRegistryLogin::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateContainerServiceRegistryLogin",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateContainerServiceRegistryLoginInput`](crate::input::CreateContainerServiceRegistryLoginInput)
    pub fn builder() -> crate::input::create_container_service_registry_login_input::Builder {
        crate::input::create_container_service_registry_login_input::Builder::default()
    }
}

/// See [`CreateDiskInput`](crate::input::CreateDiskInput)
pub mod create_disk_input {
    /// A builder for [`CreateDiskInput`](crate::input::CreateDiskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) disk_name: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) size_in_gb: std::option::Option<i32>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) add_ons: std::option::Option<std::vec::Vec<crate::model::AddOnRequest>>,
    }
    impl Builder {
        /// <p>The unique Lightsail disk name (e.g., <code>my-disk</code>).</p>
        pub fn disk_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.disk_name = Some(input.into());
            self
        }
        /// <p>The unique Lightsail disk name (e.g., <code>my-disk</code>).</p>
        pub fn set_disk_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.disk_name = input;
            self
        }
        /// <p>The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>). Use the same Availability Zone as the Lightsail instance to which you want to attach the disk.</p>
        /// <p>Use the <code>get regions</code> operation to list the Availability Zones where Lightsail is currently available.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>). Use the same Availability Zone as the Lightsail instance to which you want to attach the disk.</p>
        /// <p>Use the <code>get regions</code> operation to list the Availability Zones where Lightsail is currently available.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The size of the disk in GB (e.g., <code>32</code>).</p>
        pub fn size_in_gb(mut self, input: i32) -> Self {
            self.size_in_gb = Some(input);
            self
        }
        /// <p>The size of the disk in GB (e.g., <code>32</code>).</p>
        pub fn set_size_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.size_in_gb = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `add_ons`.
        ///
        /// To override the contents of this collection use [`set_add_ons`](Self::set_add_ons).
        ///
        /// <p>An array of objects that represent the add-ons to enable for the new disk.</p>
        pub fn add_ons(mut self, input: crate::model::AddOnRequest) -> Self {
            let mut v = self.add_ons.unwrap_or_default();
            v.push(input);
            self.add_ons = Some(v);
            self
        }
        /// <p>An array of objects that represent the add-ons to enable for the new disk.</p>
        pub fn set_add_ons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddOnRequest>>,
        ) -> Self {
            self.add_ons = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDiskInput`](crate::input::CreateDiskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDiskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDiskInput {
                disk_name: self.disk_name,
                availability_zone: self.availability_zone,
                size_in_gb: self.size_in_gb,
                tags: self.tags,
                add_ons: self.add_ons,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDiskInputOperationOutputAlias = crate::operation::CreateDisk;
#[doc(hidden)]
pub type CreateDiskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDiskInput {
    /// Consumes the builder and constructs an Operation<[`CreateDisk`](crate::operation::CreateDisk)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDisk,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDiskInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDiskInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CreateDisk",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_disk(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDisk::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDisk",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDiskInput`](crate::input::CreateDiskInput)
    pub fn builder() -> crate::input::create_disk_input::Builder {
        crate::input::create_disk_input::Builder::default()
    }
}

/// See [`CreateDiskFromSnapshotInput`](crate::input::CreateDiskFromSnapshotInput)
pub mod create_disk_from_snapshot_input {
    /// A builder for [`CreateDiskFromSnapshotInput`](crate::input::CreateDiskFromSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) disk_name: std::option::Option<std::string::String>,
        pub(crate) disk_snapshot_name: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) size_in_gb: std::option::Option<i32>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) add_ons: std::option::Option<std::vec::Vec<crate::model::AddOnRequest>>,
        pub(crate) source_disk_name: std::option::Option<std::string::String>,
        pub(crate) restore_date: std::option::Option<std::string::String>,
        pub(crate) use_latest_restorable_auto_snapshot: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The unique Lightsail disk name (e.g., <code>my-disk</code>).</p>
        pub fn disk_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.disk_name = Some(input.into());
            self
        }
        /// <p>The unique Lightsail disk name (e.g., <code>my-disk</code>).</p>
        pub fn set_disk_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.disk_name = input;
            self
        }
        /// <p>The name of the disk snapshot (e.g., <code>my-snapshot</code>) from which to create the new storage disk.</p>
        /// <p>Constraint:</p>
        /// <ul>
        /// <li> <p>This parameter cannot be defined together with the <code>source disk name</code> parameter. The <code>disk snapshot name</code> and <code>source disk name</code> parameters are mutually exclusive.</p> </li>
        /// </ul>
        pub fn disk_snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.disk_snapshot_name = Some(input.into());
            self
        }
        /// <p>The name of the disk snapshot (e.g., <code>my-snapshot</code>) from which to create the new storage disk.</p>
        /// <p>Constraint:</p>
        /// <ul>
        /// <li> <p>This parameter cannot be defined together with the <code>source disk name</code> parameter. The <code>disk snapshot name</code> and <code>source disk name</code> parameters are mutually exclusive.</p> </li>
        /// </ul>
        pub fn set_disk_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.disk_snapshot_name = input;
            self
        }
        /// <p>The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>). Choose the same Availability Zone as the Lightsail instance where you want to create the disk.</p>
        /// <p>Use the GetRegions operation to list the Availability Zones where Lightsail is currently available.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>). Choose the same Availability Zone as the Lightsail instance where you want to create the disk.</p>
        /// <p>Use the GetRegions operation to list the Availability Zones where Lightsail is currently available.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The size of the disk in GB (e.g., <code>32</code>).</p>
        pub fn size_in_gb(mut self, input: i32) -> Self {
            self.size_in_gb = Some(input);
            self
        }
        /// <p>The size of the disk in GB (e.g., <code>32</code>).</p>
        pub fn set_size_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.size_in_gb = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `add_ons`.
        ///
        /// To override the contents of this collection use [`set_add_ons`](Self::set_add_ons).
        ///
        /// <p>An array of objects that represent the add-ons to enable for the new disk.</p>
        pub fn add_ons(mut self, input: crate::model::AddOnRequest) -> Self {
            let mut v = self.add_ons.unwrap_or_default();
            v.push(input);
            self.add_ons = Some(v);
            self
        }
        /// <p>An array of objects that represent the add-ons to enable for the new disk.</p>
        pub fn set_add_ons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddOnRequest>>,
        ) -> Self {
            self.add_ons = input;
            self
        }
        /// <p>The name of the source disk from which the source automatic snapshot was created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>This parameter cannot be defined together with the <code>disk snapshot name</code> parameter. The <code>source disk name</code> and <code>disk snapshot name</code> parameters are mutually exclusive.</p> </li>
        /// <li> <p>Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p> </li>
        /// </ul>
        pub fn source_disk_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_disk_name = Some(input.into());
            self
        }
        /// <p>The name of the source disk from which the source automatic snapshot was created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>This parameter cannot be defined together with the <code>disk snapshot name</code> parameter. The <code>source disk name</code> and <code>disk snapshot name</code> parameters are mutually exclusive.</p> </li>
        /// <li> <p>Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p> </li>
        /// </ul>
        pub fn set_source_disk_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_disk_name = input;
            self
        }
        /// <p>The date of the automatic snapshot to use for the new disk. Use the <code>get auto snapshots</code> operation to identify the dates of the available automatic snapshots.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be specified in <code>YYYY-MM-DD</code> format.</p> </li>
        /// <li> <p>This parameter cannot be defined together with the <code>use latest restorable auto snapshot</code> parameter. The <code>restore date</code> and <code>use latest restorable auto snapshot</code> parameters are mutually exclusive.</p> </li>
        /// <li> <p>Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p> </li>
        /// </ul>
        pub fn restore_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.restore_date = Some(input.into());
            self
        }
        /// <p>The date of the automatic snapshot to use for the new disk. Use the <code>get auto snapshots</code> operation to identify the dates of the available automatic snapshots.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be specified in <code>YYYY-MM-DD</code> format.</p> </li>
        /// <li> <p>This parameter cannot be defined together with the <code>use latest restorable auto snapshot</code> parameter. The <code>restore date</code> and <code>use latest restorable auto snapshot</code> parameters are mutually exclusive.</p> </li>
        /// <li> <p>Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p> </li>
        /// </ul>
        pub fn set_restore_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.restore_date = input;
            self
        }
        /// <p>A Boolean value to indicate whether to use the latest available automatic snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>This parameter cannot be defined together with the <code>restore date</code> parameter. The <code>use latest restorable auto snapshot</code> and <code>restore date</code> parameters are mutually exclusive.</p> </li>
        /// <li> <p>Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p> </li>
        /// </ul>
        pub fn use_latest_restorable_auto_snapshot(mut self, input: bool) -> Self {
            self.use_latest_restorable_auto_snapshot = Some(input);
            self
        }
        /// <p>A Boolean value to indicate whether to use the latest available automatic snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>This parameter cannot be defined together with the <code>restore date</code> parameter. The <code>use latest restorable auto snapshot</code> and <code>restore date</code> parameters are mutually exclusive.</p> </li>
        /// <li> <p>Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p> </li>
        /// </ul>
        pub fn set_use_latest_restorable_auto_snapshot(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_latest_restorable_auto_snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDiskFromSnapshotInput`](crate::input::CreateDiskFromSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDiskFromSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDiskFromSnapshotInput {
                disk_name: self.disk_name,
                disk_snapshot_name: self.disk_snapshot_name,
                availability_zone: self.availability_zone,
                size_in_gb: self.size_in_gb,
                tags: self.tags,
                add_ons: self.add_ons,
                source_disk_name: self.source_disk_name,
                restore_date: self.restore_date,
                use_latest_restorable_auto_snapshot: self.use_latest_restorable_auto_snapshot,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDiskFromSnapshotInputOperationOutputAlias = crate::operation::CreateDiskFromSnapshot;
#[doc(hidden)]
pub type CreateDiskFromSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDiskFromSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CreateDiskFromSnapshot`](crate::operation::CreateDiskFromSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDiskFromSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDiskFromSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDiskFromSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CreateDiskFromSnapshot",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_disk_from_snapshot(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDiskFromSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDiskFromSnapshot",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDiskFromSnapshotInput`](crate::input::CreateDiskFromSnapshotInput)
    pub fn builder() -> crate::input::create_disk_from_snapshot_input::Builder {
        crate::input::create_disk_from_snapshot_input::Builder::default()
    }
}

/// See [`CreateDiskSnapshotInput`](crate::input::CreateDiskSnapshotInput)
pub mod create_disk_snapshot_input {
    /// A builder for [`CreateDiskSnapshotInput`](crate::input::CreateDiskSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) disk_name: std::option::Option<std::string::String>,
        pub(crate) disk_snapshot_name: std::option::Option<std::string::String>,
        pub(crate) instance_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The unique name of the source disk (e.g., <code>Disk-Virginia-1</code>).</p> <note>
        /// <p>This parameter cannot be defined together with the <code>instance name</code> parameter. The <code>disk name</code> and <code>instance name</code> parameters are mutually exclusive.</p>
        /// </note>
        pub fn disk_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.disk_name = Some(input.into());
            self
        }
        /// <p>The unique name of the source disk (e.g., <code>Disk-Virginia-1</code>).</p> <note>
        /// <p>This parameter cannot be defined together with the <code>instance name</code> parameter. The <code>disk name</code> and <code>instance name</code> parameters are mutually exclusive.</p>
        /// </note>
        pub fn set_disk_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.disk_name = input;
            self
        }
        /// <p>The name of the destination disk snapshot (e.g., <code>my-disk-snapshot</code>) based on the source disk.</p>
        pub fn disk_snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.disk_snapshot_name = Some(input.into());
            self
        }
        /// <p>The name of the destination disk snapshot (e.g., <code>my-disk-snapshot</code>) based on the source disk.</p>
        pub fn set_disk_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.disk_snapshot_name = input;
            self
        }
        /// <p>The unique name of the source instance (e.g., <code>Amazon_Linux-512MB-Virginia-1</code>). When this is defined, a snapshot of the instance's system volume is created.</p> <note>
        /// <p>This parameter cannot be defined together with the <code>disk name</code> parameter. The <code>instance name</code> and <code>disk name</code> parameters are mutually exclusive.</p>
        /// </note>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_name = Some(input.into());
            self
        }
        /// <p>The unique name of the source instance (e.g., <code>Amazon_Linux-512MB-Virginia-1</code>). When this is defined, a snapshot of the instance's system volume is created.</p> <note>
        /// <p>This parameter cannot be defined together with the <code>disk name</code> parameter. The <code>instance name</code> and <code>disk name</code> parameters are mutually exclusive.</p>
        /// </note>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDiskSnapshotInput`](crate::input::CreateDiskSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDiskSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDiskSnapshotInput {
                disk_name: self.disk_name,
                disk_snapshot_name: self.disk_snapshot_name,
                instance_name: self.instance_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDiskSnapshotInputOperationOutputAlias = crate::operation::CreateDiskSnapshot;
#[doc(hidden)]
pub type CreateDiskSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDiskSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CreateDiskSnapshot`](crate::operation::CreateDiskSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDiskSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDiskSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDiskSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CreateDiskSnapshot",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_disk_snapshot(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDiskSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDiskSnapshot",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDiskSnapshotInput`](crate::input::CreateDiskSnapshotInput)
    pub fn builder() -> crate::input::create_disk_snapshot_input::Builder {
        crate::input::create_disk_snapshot_input::Builder::default()
    }
}

/// See [`CreateDistributionInput`](crate::input::CreateDistributionInput)
pub mod create_distribution_input {
    /// A builder for [`CreateDistributionInput`](crate::input::CreateDistributionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_name: std::option::Option<std::string::String>,
        pub(crate) origin: std::option::Option<crate::model::InputOrigin>,
        pub(crate) default_cache_behavior: std::option::Option<crate::model::CacheBehavior>,
        pub(crate) cache_behavior_settings: std::option::Option<crate::model::CacheSettings>,
        pub(crate) cache_behaviors:
            std::option::Option<std::vec::Vec<crate::model::CacheBehaviorPerPath>>,
        pub(crate) bundle_id: std::option::Option<std::string::String>,
        pub(crate) ip_address_type: std::option::Option<crate::model::IpAddressType>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name for the distribution.</p>
        pub fn distribution_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.distribution_name = Some(input.into());
            self
        }
        /// <p>The name for the distribution.</p>
        pub fn set_distribution_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_name = input;
            self
        }
        /// <p>An object that describes the origin resource for the distribution, such as a Lightsail instance, bucket, or load balancer.</p>
        /// <p>The distribution pulls, caches, and serves content from the origin.</p>
        pub fn origin(mut self, input: crate::model::InputOrigin) -> Self {
            self.origin = Some(input);
            self
        }
        /// <p>An object that describes the origin resource for the distribution, such as a Lightsail instance, bucket, or load balancer.</p>
        /// <p>The distribution pulls, caches, and serves content from the origin.</p>
        pub fn set_origin(mut self, input: std::option::Option<crate::model::InputOrigin>) -> Self {
            self.origin = input;
            self
        }
        /// <p>An object that describes the default cache behavior for the distribution.</p>
        pub fn default_cache_behavior(mut self, input: crate::model::CacheBehavior) -> Self {
            self.default_cache_behavior = Some(input);
            self
        }
        /// <p>An object that describes the default cache behavior for the distribution.</p>
        pub fn set_default_cache_behavior(
            mut self,
            input: std::option::Option<crate::model::CacheBehavior>,
        ) -> Self {
            self.default_cache_behavior = input;
            self
        }
        /// <p>An object that describes the cache behavior settings for the distribution.</p>
        pub fn cache_behavior_settings(mut self, input: crate::model::CacheSettings) -> Self {
            self.cache_behavior_settings = Some(input);
            self
        }
        /// <p>An object that describes the cache behavior settings for the distribution.</p>
        pub fn set_cache_behavior_settings(
            mut self,
            input: std::option::Option<crate::model::CacheSettings>,
        ) -> Self {
            self.cache_behavior_settings = input;
            self
        }
        /// Appends an item to `cache_behaviors`.
        ///
        /// To override the contents of this collection use [`set_cache_behaviors`](Self::set_cache_behaviors).
        ///
        /// <p>An array of objects that describe the per-path cache behavior for the distribution.</p>
        pub fn cache_behaviors(mut self, input: crate::model::CacheBehaviorPerPath) -> Self {
            let mut v = self.cache_behaviors.unwrap_or_default();
            v.push(input);
            self.cache_behaviors = Some(v);
            self
        }
        /// <p>An array of objects that describe the per-path cache behavior for the distribution.</p>
        pub fn set_cache_behaviors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CacheBehaviorPerPath>>,
        ) -> Self {
            self.cache_behaviors = input;
            self
        }
        /// <p>The bundle ID to use for the distribution.</p>
        /// <p>A distribution bundle describes the specifications of your distribution, such as the monthly cost and monthly network transfer quota.</p>
        /// <p>Use the <code>GetDistributionBundles</code> action to get a list of distribution bundle IDs that you can specify.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_id = Some(input.into());
            self
        }
        /// <p>The bundle ID to use for the distribution.</p>
        /// <p>A distribution bundle describes the specifications of your distribution, such as the monthly cost and monthly network transfer quota.</p>
        /// <p>Use the <code>GetDistributionBundles</code> action to get a list of distribution bundle IDs that you can specify.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_id = input;
            self
        }
        /// <p>The IP address type for the distribution.</p>
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.</p>
        /// <p>The default value is <code>dualstack</code>.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.ip_address_type = Some(input);
            self
        }
        /// <p>The IP address type for the distribution.</p>
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.</p>
        /// <p>The default value is <code>dualstack</code>.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.ip_address_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the distribution during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values to add to the distribution during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDistributionInput`](crate::input::CreateDistributionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDistributionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDistributionInput {
                distribution_name: self.distribution_name,
                origin: self.origin,
                default_cache_behavior: self.default_cache_behavior,
                cache_behavior_settings: self.cache_behavior_settings,
                cache_behaviors: self.cache_behaviors,
                bundle_id: self.bundle_id,
                ip_address_type: self.ip_address_type,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDistributionInputOperationOutputAlias = crate::operation::CreateDistribution;
#[doc(hidden)]
pub type CreateDistributionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDistributionInput {
    /// Consumes the builder and constructs an Operation<[`CreateDistribution`](crate::operation::CreateDistribution)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDistribution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDistributionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDistributionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CreateDistribution",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_distribution(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDistribution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDistribution",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDistributionInput`](crate::input::CreateDistributionInput)
    pub fn builder() -> crate::input::create_distribution_input::Builder {
        crate::input::create_distribution_input::Builder::default()
    }
}

/// See [`CreateDomainInput`](crate::input::CreateDomainInput)
pub mod create_domain_input {
    /// A builder for [`CreateDomainInput`](crate::input::CreateDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The domain name to manage (e.g., <code>example.com</code>).</p> <note>
        /// <p>You cannot register a new domain name using Lightsail. You must register a domain name using Amazon Route 53 or another domain name registrar. If you have already registered your domain, you can enter its name in this parameter to manage the DNS records for that domain using Lightsail.</p>
        /// </note>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name to manage (e.g., <code>example.com</code>).</p> <note>
        /// <p>You cannot register a new domain name using Lightsail. You must register a domain name using Amazon Route 53 or another domain name registrar. If you have already registered your domain, you can enter its name in this parameter to manage the DNS records for that domain using Lightsail.</p>
        /// </note>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDomainInput`](crate::input::CreateDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDomainInput {
                domain_name: self.domain_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDomainInputOperationOutputAlias = crate::operation::CreateDomain;
#[doc(hidden)]
pub type CreateDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDomainInput {
    /// Consumes the builder and constructs an Operation<[`CreateDomain`](crate::operation::CreateDomain)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDomainInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDomainInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CreateDomain",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_domain(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDomain",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDomainInput`](crate::input::CreateDomainInput)
    pub fn builder() -> crate::input::create_domain_input::Builder {
        crate::input::create_domain_input::Builder::default()
    }
}

/// See [`CreateDomainEntryInput`](crate::input::CreateDomainEntryInput)
pub mod create_domain_entry_input {
    /// A builder for [`CreateDomainEntryInput`](crate::input::CreateDomainEntryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) domain_entry: std::option::Option<crate::model::DomainEntry>,
    }
    impl Builder {
        /// <p>The domain name (e.g., <code>example.com</code>) for which you want to create the domain entry.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name (e.g., <code>example.com</code>) for which you want to create the domain entry.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>An array of key-value pairs containing information about the domain entry request.</p>
        pub fn domain_entry(mut self, input: crate::model::DomainEntry) -> Self {
            self.domain_entry = Some(input);
            self
        }
        /// <p>An array of key-value pairs containing information about the domain entry request.</p>
        pub fn set_domain_entry(
            mut self,
            input: std::option::Option<crate::model::DomainEntry>,
        ) -> Self {
            self.domain_entry = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDomainEntryInput`](crate::input::CreateDomainEntryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDomainEntryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDomainEntryInput {
                domain_name: self.domain_name,
                domain_entry: self.domain_entry,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDomainEntryInputOperationOutputAlias = crate::operation::CreateDomainEntry;
#[doc(hidden)]
pub type CreateDomainEntryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDomainEntryInput {
    /// Consumes the builder and constructs an Operation<[`CreateDomainEntry`](crate::operation::CreateDomainEntry)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDomainEntry,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDomainEntryInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDomainEntryInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CreateDomainEntry",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_domain_entry(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDomainEntry::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDomainEntry",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDomainEntryInput`](crate::input::CreateDomainEntryInput)
    pub fn builder() -> crate::input::create_domain_entry_input::Builder {
        crate::input::create_domain_entry_input::Builder::default()
    }
}

/// See [`CreateInstancesInput`](crate::input::CreateInstancesInput)
pub mod create_instances_input {
    /// A builder for [`CreateInstancesInput`](crate::input::CreateInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) custom_image_name: std::option::Option<std::string::String>,
        pub(crate) blueprint_id: std::option::Option<std::string::String>,
        pub(crate) bundle_id: std::option::Option<std::string::String>,
        pub(crate) user_data: std::option::Option<std::string::String>,
        pub(crate) key_pair_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) add_ons: std::option::Option<std::vec::Vec<crate::model::AddOnRequest>>,
        pub(crate) ip_address_type: std::option::Option<crate::model::IpAddressType>,
    }
    impl Builder {
        /// Appends an item to `instance_names`.
        ///
        /// To override the contents of this collection use [`set_instance_names`](Self::set_instance_names).
        ///
        /// <p>The names to use for your new Lightsail instances. Separate multiple values using quotation marks and commas, for example: <code>["MyFirstInstance","MySecondInstance"]</code> </p>
        pub fn instance_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_names.unwrap_or_default();
            v.push(input.into());
            self.instance_names = Some(v);
            self
        }
        /// <p>The names to use for your new Lightsail instances. Separate multiple values using quotation marks and commas, for example: <code>["MyFirstInstance","MySecondInstance"]</code> </p>
        pub fn set_instance_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_names = input;
            self
        }
        /// <p>The Availability Zone in which to create your instance. Use the following format: <code>us-east-2a</code> (case sensitive). You can get a list of Availability Zones by using the <a href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get regions</a> operation. Be sure to add the <code>include Availability Zones</code> parameter to your request.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone in which to create your instance. Use the following format: <code>us-east-2a</code> (case sensitive). You can get a list of Availability Zones by using the <a href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get regions</a> operation. Be sure to add the <code>include Availability Zones</code> parameter to your request.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>(Deprecated) The name for your custom image.</p> <note>
        /// <p>In releases prior to June 12, 2017, this parameter was ignored by the API. It is now deprecated.</p>
        /// </note>
        pub fn custom_image_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_image_name = Some(input.into());
            self
        }
        /// <p>(Deprecated) The name for your custom image.</p> <note>
        /// <p>In releases prior to June 12, 2017, this parameter was ignored by the API. It is now deprecated.</p>
        /// </note>
        pub fn set_custom_image_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_image_name = input;
            self
        }
        /// <p>The ID for a virtual private server image (e.g., <code>app_wordpress_4_4</code> or <code>app_lamp_7_0</code>). Use the <code>get blueprints</code> operation to return a list of available images (or <i>blueprints</i>).</p> <note>
        /// <p>Use active blueprints when creating new instances. Inactive blueprints are listed to support customers with existing instances and are not necessarily available to create new instances. Blueprints are marked inactive when they become outdated due to operating system updates or new application releases.</p>
        /// </note>
        pub fn blueprint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.blueprint_id = Some(input.into());
            self
        }
        /// <p>The ID for a virtual private server image (e.g., <code>app_wordpress_4_4</code> or <code>app_lamp_7_0</code>). Use the <code>get blueprints</code> operation to return a list of available images (or <i>blueprints</i>).</p> <note>
        /// <p>Use active blueprints when creating new instances. Inactive blueprints are listed to support customers with existing instances and are not necessarily available to create new instances. Blueprints are marked inactive when they become outdated due to operating system updates or new application releases.</p>
        /// </note>
        pub fn set_blueprint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.blueprint_id = input;
            self
        }
        /// <p>The bundle of specification information for your virtual private server (or <i>instance</i>), including the pricing plan (e.g., <code>micro_1_0</code>).</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_id = Some(input.into());
            self
        }
        /// <p>The bundle of specification information for your virtual private server (or <i>instance</i>), including the pricing plan (e.g., <code>micro_1_0</code>).</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_id = input;
            self
        }
        /// <p>A launch script you can create that configures a server with additional user data. For example, you might want to run <code>apt-get -y update</code>.</p> <note>
        /// <p>Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses <code>pkg</code>. For a complete list, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/compare-options-choose-lightsail-instance-image">Amazon Lightsail Developer Guide</a>.</p>
        /// </note>
        pub fn user_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_data = Some(input.into());
            self
        }
        /// <p>A launch script you can create that configures a server with additional user data. For example, you might want to run <code>apt-get -y update</code>.</p> <note>
        /// <p>Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses <code>pkg</code>. For a complete list, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/compare-options-choose-lightsail-instance-image">Amazon Lightsail Developer Guide</a>.</p>
        /// </note>
        pub fn set_user_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_data = input;
            self
        }
        /// <p>The name of your key pair.</p>
        pub fn key_pair_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_pair_name = Some(input.into());
            self
        }
        /// <p>The name of your key pair.</p>
        pub fn set_key_pair_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.key_pair_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `add_ons`.
        ///
        /// To override the contents of this collection use [`set_add_ons`](Self::set_add_ons).
        ///
        /// <p>An array of objects representing the add-ons to enable for the new instance.</p>
        pub fn add_ons(mut self, input: crate::model::AddOnRequest) -> Self {
            let mut v = self.add_ons.unwrap_or_default();
            v.push(input);
            self.add_ons = Some(v);
            self
        }
        /// <p>An array of objects representing the add-ons to enable for the new instance.</p>
        pub fn set_add_ons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddOnRequest>>,
        ) -> Self {
            self.add_ons = input;
            self
        }
        /// <p>The IP address type for the instance.</p>
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.</p>
        /// <p>The default value is <code>dualstack</code>.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.ip_address_type = Some(input);
            self
        }
        /// <p>The IP address type for the instance.</p>
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.</p>
        /// <p>The default value is <code>dualstack</code>.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.ip_address_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInstancesInput`](crate::input::CreateInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateInstancesInput {
                instance_names: self.instance_names,
                availability_zone: self.availability_zone,
                custom_image_name: self.custom_image_name,
                blueprint_id: self.blueprint_id,
                bundle_id: self.bundle_id,
                user_data: self.user_data,
                key_pair_name: self.key_pair_name,
                tags: self.tags,
                add_ons: self.add_ons,
                ip_address_type: self.ip_address_type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateInstancesInputOperationOutputAlias = crate::operation::CreateInstances;
#[doc(hidden)]
pub type CreateInstancesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateInstancesInput {
    /// Consumes the builder and constructs an Operation<[`CreateInstances`](crate::operation::CreateInstances)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateInstancesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateInstancesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CreateInstances",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_instances(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateInstances",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateInstancesInput`](crate::input::CreateInstancesInput)
    pub fn builder() -> crate::input::create_instances_input::Builder {
        crate::input::create_instances_input::Builder::default()
    }
}

/// See [`CreateInstancesFromSnapshotInput`](crate::input::CreateInstancesFromSnapshotInput)
pub mod create_instances_from_snapshot_input {
    /// A builder for [`CreateInstancesFromSnapshotInput`](crate::input::CreateInstancesFromSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) attached_disk_mapping: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<crate::model::DiskMap>>,
        >,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) instance_snapshot_name: std::option::Option<std::string::String>,
        pub(crate) bundle_id: std::option::Option<std::string::String>,
        pub(crate) user_data: std::option::Option<std::string::String>,
        pub(crate) key_pair_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) add_ons: std::option::Option<std::vec::Vec<crate::model::AddOnRequest>>,
        pub(crate) ip_address_type: std::option::Option<crate::model::IpAddressType>,
        pub(crate) source_instance_name: std::option::Option<std::string::String>,
        pub(crate) restore_date: std::option::Option<std::string::String>,
        pub(crate) use_latest_restorable_auto_snapshot: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `instance_names`.
        ///
        /// To override the contents of this collection use [`set_instance_names`](Self::set_instance_names).
        ///
        /// <p>The names for your new instances.</p>
        pub fn instance_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_names.unwrap_or_default();
            v.push(input.into());
            self.instance_names = Some(v);
            self
        }
        /// <p>The names for your new instances.</p>
        pub fn set_instance_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_names = input;
            self
        }
        /// Adds a key-value pair to `attached_disk_mapping`.
        ///
        /// To override the contents of this collection use [`set_attached_disk_mapping`](Self::set_attached_disk_mapping).
        ///
        /// <p>An object containing information about one or more disk mappings.</p>
        pub fn attached_disk_mapping(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<crate::model::DiskMap>,
        ) -> Self {
            let mut hash_map = self.attached_disk_mapping.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.attached_disk_mapping = Some(hash_map);
            self
        }
        /// <p>An object containing information about one or more disk mappings.</p>
        pub fn set_attached_disk_mapping(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::vec::Vec<crate::model::DiskMap>,
                >,
            >,
        ) -> Self {
            self.attached_disk_mapping = input;
            self
        }
        /// <p>The Availability Zone where you want to create your instances. Use the following formatting: <code>us-east-2a</code> (case sensitive). You can get a list of Availability Zones by using the <a href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get regions</a> operation. Be sure to add the <code>include Availability Zones</code> parameter to your request.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone where you want to create your instances. Use the following formatting: <code>us-east-2a</code> (case sensitive). You can get a list of Availability Zones by using the <a href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get regions</a> operation. Be sure to add the <code>include Availability Zones</code> parameter to your request.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The name of the instance snapshot on which you are basing your new instances. Use the get instance snapshots operation to return information about your existing snapshots.</p>
        /// <p>Constraint:</p>
        /// <ul>
        /// <li> <p>This parameter cannot be defined together with the <code>source instance name</code> parameter. The <code>instance snapshot name</code> and <code>source instance name</code> parameters are mutually exclusive.</p> </li>
        /// </ul>
        pub fn instance_snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_snapshot_name = Some(input.into());
            self
        }
        /// <p>The name of the instance snapshot on which you are basing your new instances. Use the get instance snapshots operation to return information about your existing snapshots.</p>
        /// <p>Constraint:</p>
        /// <ul>
        /// <li> <p>This parameter cannot be defined together with the <code>source instance name</code> parameter. The <code>instance snapshot name</code> and <code>source instance name</code> parameters are mutually exclusive.</p> </li>
        /// </ul>
        pub fn set_instance_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_snapshot_name = input;
            self
        }
        /// <p>The bundle of specification information for your virtual private server (or <i>instance</i>), including the pricing plan (e.g., <code>micro_1_0</code>).</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_id = Some(input.into());
            self
        }
        /// <p>The bundle of specification information for your virtual private server (or <i>instance</i>), including the pricing plan (e.g., <code>micro_1_0</code>).</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_id = input;
            self
        }
        /// <p>You can create a launch script that configures a server with additional user data. For example, <code>apt-get -y update</code>.</p> <note>
        /// <p>Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses <code>pkg</code>. For a complete list, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/compare-options-choose-lightsail-instance-image">Amazon Lightsail Developer Guide</a>.</p>
        /// </note>
        pub fn user_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_data = Some(input.into());
            self
        }
        /// <p>You can create a launch script that configures a server with additional user data. For example, <code>apt-get -y update</code>.</p> <note>
        /// <p>Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses <code>pkg</code>. For a complete list, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/compare-options-choose-lightsail-instance-image">Amazon Lightsail Developer Guide</a>.</p>
        /// </note>
        pub fn set_user_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_data = input;
            self
        }
        /// <p>The name for your key pair.</p>
        pub fn key_pair_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_pair_name = Some(input.into());
            self
        }
        /// <p>The name for your key pair.</p>
        pub fn set_key_pair_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.key_pair_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `add_ons`.
        ///
        /// To override the contents of this collection use [`set_add_ons`](Self::set_add_ons).
        ///
        /// <p>An array of objects representing the add-ons to enable for the new instance.</p>
        pub fn add_ons(mut self, input: crate::model::AddOnRequest) -> Self {
            let mut v = self.add_ons.unwrap_or_default();
            v.push(input);
            self.add_ons = Some(v);
            self
        }
        /// <p>An array of objects representing the add-ons to enable for the new instance.</p>
        pub fn set_add_ons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddOnRequest>>,
        ) -> Self {
            self.add_ons = input;
            self
        }
        /// <p>The IP address type for the instance.</p>
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.</p>
        /// <p>The default value is <code>dualstack</code>.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.ip_address_type = Some(input);
            self
        }
        /// <p>The IP address type for the instance.</p>
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.</p>
        /// <p>The default value is <code>dualstack</code>.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.ip_address_type = input;
            self
        }
        /// <p>The name of the source instance from which the source automatic snapshot was created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>This parameter cannot be defined together with the <code>instance snapshot name</code> parameter. The <code>source instance name</code> and <code>instance snapshot name</code> parameters are mutually exclusive.</p> </li>
        /// <li> <p>Define this parameter only when creating a new instance from an automatic snapshot. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p> </li>
        /// </ul>
        pub fn source_instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_instance_name = Some(input.into());
            self
        }
        /// <p>The name of the source instance from which the source automatic snapshot was created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>This parameter cannot be defined together with the <code>instance snapshot name</code> parameter. The <code>source instance name</code> and <code>instance snapshot name</code> parameters are mutually exclusive.</p> </li>
        /// <li> <p>Define this parameter only when creating a new instance from an automatic snapshot. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p> </li>
        /// </ul>
        pub fn set_source_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_instance_name = input;
            self
        }
        /// <p>The date of the automatic snapshot to use for the new instance. Use the <code>get auto snapshots</code> operation to identify the dates of the available automatic snapshots.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be specified in <code>YYYY-MM-DD</code> format.</p> </li>
        /// <li> <p>This parameter cannot be defined together with the <code>use latest restorable auto snapshot</code> parameter. The <code>restore date</code> and <code>use latest restorable auto snapshot</code> parameters are mutually exclusive.</p> </li>
        /// <li> <p>Define this parameter only when creating a new instance from an automatic snapshot. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p> </li>
        /// </ul>
        pub fn restore_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.restore_date = Some(input.into());
            self
        }
        /// <p>The date of the automatic snapshot to use for the new instance. Use the <code>get auto snapshots</code> operation to identify the dates of the available automatic snapshots.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be specified in <code>YYYY-MM-DD</code> format.</p> </li>
        /// <li> <p>This parameter cannot be defined together with the <code>use latest restorable auto snapshot</code> parameter. The <code>restore date</code> and <code>use latest restorable auto snapshot</code> parameters are mutually exclusive.</p> </li>
        /// <li> <p>Define this parameter only when creating a new instance from an automatic snapshot. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p> </li>
        /// </ul>
        pub fn set_restore_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.restore_date = input;
            self
        }
        /// <p>A Boolean value to indicate whether to use the latest available automatic snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>This parameter cannot be defined together with the <code>restore date</code> parameter. The <code>use latest restorable auto snapshot</code> and <code>restore date</code> parameters are mutually exclusive.</p> </li>
        /// <li> <p>Define this parameter only when creating a new instance from an automatic snapshot. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p> </li>
        /// </ul>
        pub fn use_latest_restorable_auto_snapshot(mut self, input: bool) -> Self {
            self.use_latest_restorable_auto_snapshot = Some(input);
            self
        }
        /// <p>A Boolean value to indicate whether to use the latest available automatic snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>This parameter cannot be defined together with the <code>restore date</code> parameter. The <code>use latest restorable auto snapshot</code> and <code>restore date</code> parameters are mutually exclusive.</p> </li>
        /// <li> <p>Define this parameter only when creating a new instance from an automatic snapshot. For more information, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">Amazon Lightsail Developer Guide</a>.</p> </li>
        /// </ul>
        pub fn set_use_latest_restorable_auto_snapshot(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_latest_restorable_auto_snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInstancesFromSnapshotInput`](crate::input::CreateInstancesFromSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateInstancesFromSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateInstancesFromSnapshotInput {
                instance_names: self.instance_names,
                attached_disk_mapping: self.attached_disk_mapping,
                availability_zone: self.availability_zone,
                instance_snapshot_name: self.instance_snapshot_name,
                bundle_id: self.bundle_id,
                user_data: self.user_data,
                key_pair_name: self.key_pair_name,
                tags: self.tags,
                add_ons: self.add_ons,
                ip_address_type: self.ip_address_type,
                source_instance_name: self.source_instance_name,
                restore_date: self.restore_date,
                use_latest_restorable_auto_snapshot: self.use_latest_restorable_auto_snapshot,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateInstancesFromSnapshotInputOperationOutputAlias =
    crate::operation::CreateInstancesFromSnapshot;
#[doc(hidden)]
pub type CreateInstancesFromSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateInstancesFromSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CreateInstancesFromSnapshot`](crate::operation::CreateInstancesFromSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateInstancesFromSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateInstancesFromSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateInstancesFromSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CreateInstancesFromSnapshot",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_instances_from_snapshot(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateInstancesFromSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateInstancesFromSnapshot",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateInstancesFromSnapshotInput`](crate::input::CreateInstancesFromSnapshotInput)
    pub fn builder() -> crate::input::create_instances_from_snapshot_input::Builder {
        crate::input::create_instances_from_snapshot_input::Builder::default()
    }
}

/// See [`CreateInstanceSnapshotInput`](crate::input::CreateInstanceSnapshotInput)
pub mod create_instance_snapshot_input {
    /// A builder for [`CreateInstanceSnapshotInput`](crate::input::CreateInstanceSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_snapshot_name: std::option::Option<std::string::String>,
        pub(crate) instance_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name for your new snapshot.</p>
        pub fn instance_snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_snapshot_name = Some(input.into());
            self
        }
        /// <p>The name for your new snapshot.</p>
        pub fn set_instance_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_snapshot_name = input;
            self
        }
        /// <p>The Lightsail instance on which to base your snapshot.</p>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_name = Some(input.into());
            self
        }
        /// <p>The Lightsail instance on which to base your snapshot.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInstanceSnapshotInput`](crate::input::CreateInstanceSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateInstanceSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateInstanceSnapshotInput {
                instance_snapshot_name: self.instance_snapshot_name,
                instance_name: self.instance_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateInstanceSnapshotInputOperationOutputAlias = crate::operation::CreateInstanceSnapshot;
#[doc(hidden)]
pub type CreateInstanceSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateInstanceSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CreateInstanceSnapshot`](crate::operation::CreateInstanceSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateInstanceSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateInstanceSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateInstanceSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CreateInstanceSnapshot",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_instance_snapshot(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateInstanceSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateInstanceSnapshot",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateInstanceSnapshotInput`](crate::input::CreateInstanceSnapshotInput)
    pub fn builder() -> crate::input::create_instance_snapshot_input::Builder {
        crate::input::create_instance_snapshot_input::Builder::default()
    }
}

/// See [`CreateKeyPairInput`](crate::input::CreateKeyPairInput)
pub mod create_key_pair_input {
    /// A builder for [`CreateKeyPairInput`](crate::input::CreateKeyPairInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_pair_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name for your new key pair.</p>
        pub fn key_pair_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_pair_name = Some(input.into());
            self
        }
        /// <p>The name for your new key pair.</p>
        pub fn set_key_pair_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.key_pair_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateKeyPairInput`](crate::input::CreateKeyPairInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateKeyPairInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateKeyPairInput {
                key_pair_name: self.key_pair_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateKeyPairInputOperationOutputAlias = crate::operation::CreateKeyPair;
#[doc(hidden)]
pub type CreateKeyPairInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateKeyPairInput {
    /// Consumes the builder and constructs an Operation<[`CreateKeyPair`](crate::operation::CreateKeyPair)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateKeyPair,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateKeyPairInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateKeyPairInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CreateKeyPair",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_key_pair(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateKeyPair::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateKeyPair",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateKeyPairInput`](crate::input::CreateKeyPairInput)
    pub fn builder() -> crate::input::create_key_pair_input::Builder {
        crate::input::create_key_pair_input::Builder::default()
    }
}

/// See [`CreateLoadBalancerInput`](crate::input::CreateLoadBalancerInput)
pub mod create_load_balancer_input {
    /// A builder for [`CreateLoadBalancerInput`](crate::input::CreateLoadBalancerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) instance_port: std::option::Option<i32>,
        pub(crate) health_check_path: std::option::Option<std::string::String>,
        pub(crate) certificate_name: std::option::Option<std::string::String>,
        pub(crate) certificate_domain_name: std::option::Option<std::string::String>,
        pub(crate) certificate_alternative_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) ip_address_type: std::option::Option<crate::model::IpAddressType>,
    }
    impl Builder {
        /// <p>The name of your load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of your load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// <p>The instance port where you're creating your load balancer.</p>
        pub fn instance_port(mut self, input: i32) -> Self {
            self.instance_port = Some(input);
            self
        }
        /// <p>The instance port where you're creating your load balancer.</p>
        pub fn set_instance_port(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_port = input;
            self
        }
        /// <p>The path you provided to perform the load balancer health check. If you didn't specify a health check path, Lightsail uses the root path of your website (e.g., <code>"/"</code>).</p>
        /// <p>You may want to specify a custom health check path other than the root of your application if your home page loads slowly or has a lot of media or scripting on it.</p>
        pub fn health_check_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_check_path = Some(input.into());
            self
        }
        /// <p>The path you provided to perform the load balancer health check. If you didn't specify a health check path, Lightsail uses the root path of your website (e.g., <code>"/"</code>).</p>
        /// <p>You may want to specify a custom health check path other than the root of your application if your home page loads slowly or has a lot of media or scripting on it.</p>
        pub fn set_health_check_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_check_path = input;
            self
        }
        /// <p>The name of the SSL/TLS certificate.</p>
        /// <p>If you specify <code>certificateName</code>, then <code>certificateDomainName</code> is required (and vice-versa).</p>
        pub fn certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_name = Some(input.into());
            self
        }
        /// <p>The name of the SSL/TLS certificate.</p>
        /// <p>If you specify <code>certificateName</code>, then <code>certificateDomainName</code> is required (and vice-versa).</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_name = input;
            self
        }
        /// <p>The domain name with which your certificate is associated (e.g., <code>example.com</code>).</p>
        /// <p>If you specify <code>certificateDomainName</code>, then <code>certificateName</code> is required (and vice-versa).</p>
        pub fn certificate_domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_domain_name = Some(input.into());
            self
        }
        /// <p>The domain name with which your certificate is associated (e.g., <code>example.com</code>).</p>
        /// <p>If you specify <code>certificateDomainName</code>, then <code>certificateName</code> is required (and vice-versa).</p>
        pub fn set_certificate_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_domain_name = input;
            self
        }
        /// Appends an item to `certificate_alternative_names`.
        ///
        /// To override the contents of this collection use [`set_certificate_alternative_names`](Self::set_certificate_alternative_names).
        ///
        /// <p>The optional alternative domains and subdomains to use with your SSL/TLS certificate (e.g., <code>www.example.com</code>, <code>example.com</code>, <code>m.example.com</code>, <code>blog.example.com</code>).</p>
        pub fn certificate_alternative_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.certificate_alternative_names.unwrap_or_default();
            v.push(input.into());
            self.certificate_alternative_names = Some(v);
            self
        }
        /// <p>The optional alternative domains and subdomains to use with your SSL/TLS certificate (e.g., <code>www.example.com</code>, <code>example.com</code>, <code>m.example.com</code>, <code>blog.example.com</code>).</p>
        pub fn set_certificate_alternative_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.certificate_alternative_names = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The IP address type for the load balancer.</p>
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.</p>
        /// <p>The default value is <code>dualstack</code>.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.ip_address_type = Some(input);
            self
        }
        /// <p>The IP address type for the load balancer.</p>
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.</p>
        /// <p>The default value is <code>dualstack</code>.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.ip_address_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLoadBalancerInput`](crate::input::CreateLoadBalancerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLoadBalancerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLoadBalancerInput {
                load_balancer_name: self.load_balancer_name,
                instance_port: self.instance_port.unwrap_or_default(),
                health_check_path: self.health_check_path,
                certificate_name: self.certificate_name,
                certificate_domain_name: self.certificate_domain_name,
                certificate_alternative_names: self.certificate_alternative_names,
                tags: self.tags,
                ip_address_type: self.ip_address_type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLoadBalancerInputOperationOutputAlias = crate::operation::CreateLoadBalancer;
#[doc(hidden)]
pub type CreateLoadBalancerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateLoadBalancerInput {
    /// Consumes the builder and constructs an Operation<[`CreateLoadBalancer`](crate::operation::CreateLoadBalancer)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLoadBalancer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateLoadBalancerInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateLoadBalancerInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CreateLoadBalancer",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_load_balancer(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLoadBalancer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLoadBalancer",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateLoadBalancerInput`](crate::input::CreateLoadBalancerInput)
    pub fn builder() -> crate::input::create_load_balancer_input::Builder {
        crate::input::create_load_balancer_input::Builder::default()
    }
}

/// See [`CreateLoadBalancerTlsCertificateInput`](crate::input::CreateLoadBalancerTlsCertificateInput)
pub mod create_load_balancer_tls_certificate_input {
    /// A builder for [`CreateLoadBalancerTlsCertificateInput`](crate::input::CreateLoadBalancerTlsCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) certificate_name: std::option::Option<std::string::String>,
        pub(crate) certificate_domain_name: std::option::Option<std::string::String>,
        pub(crate) certificate_alternative_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The load balancer name where you want to create the SSL/TLS certificate.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The load balancer name where you want to create the SSL/TLS certificate.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// <p>The SSL/TLS certificate name.</p>
        /// <p>You can have up to 10 certificates in your account at one time. Each Lightsail load balancer can have up to 2 certificates associated with it at one time. There is also an overall limit to the number of certificates that can be issue in a 365-day period. For more information, see <a href="http://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html">Limits</a>.</p>
        pub fn certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_name = Some(input.into());
            self
        }
        /// <p>The SSL/TLS certificate name.</p>
        /// <p>You can have up to 10 certificates in your account at one time. Each Lightsail load balancer can have up to 2 certificates associated with it at one time. There is also an overall limit to the number of certificates that can be issue in a 365-day period. For more information, see <a href="http://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html">Limits</a>.</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_name = input;
            self
        }
        /// <p>The domain name (e.g., <code>example.com</code>) for your SSL/TLS certificate.</p>
        pub fn certificate_domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_domain_name = Some(input.into());
            self
        }
        /// <p>The domain name (e.g., <code>example.com</code>) for your SSL/TLS certificate.</p>
        pub fn set_certificate_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_domain_name = input;
            self
        }
        /// Appends an item to `certificate_alternative_names`.
        ///
        /// To override the contents of this collection use [`set_certificate_alternative_names`](Self::set_certificate_alternative_names).
        ///
        /// <p>An array of strings listing alternative domains and subdomains for your SSL/TLS certificate. Lightsail will de-dupe the names for you. You can have a maximum of 9 alternative names (in addition to the 1 primary domain). We do not support wildcards (e.g., <code>*.example.com</code>).</p>
        pub fn certificate_alternative_names(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.certificate_alternative_names.unwrap_or_default();
            v.push(input.into());
            self.certificate_alternative_names = Some(v);
            self
        }
        /// <p>An array of strings listing alternative domains and subdomains for your SSL/TLS certificate. Lightsail will de-dupe the names for you. You can have a maximum of 9 alternative names (in addition to the 1 primary domain). We do not support wildcards (e.g., <code>*.example.com</code>).</p>
        pub fn set_certificate_alternative_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.certificate_alternative_names = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLoadBalancerTlsCertificateInput`](crate::input::CreateLoadBalancerTlsCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLoadBalancerTlsCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLoadBalancerTlsCertificateInput {
                load_balancer_name: self.load_balancer_name,
                certificate_name: self.certificate_name,
                certificate_domain_name: self.certificate_domain_name,
                certificate_alternative_names: self.certificate_alternative_names,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLoadBalancerTlsCertificateInputOperationOutputAlias =
    crate::operation::CreateLoadBalancerTlsCertificate;
#[doc(hidden)]
pub type CreateLoadBalancerTlsCertificateInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateLoadBalancerTlsCertificateInput {
    /// Consumes the builder and constructs an Operation<[`CreateLoadBalancerTlsCertificate`](crate::operation::CreateLoadBalancerTlsCertificate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLoadBalancerTlsCertificate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateLoadBalancerTlsCertificateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateLoadBalancerTlsCertificateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CreateLoadBalancerTlsCertificate",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_load_balancer_tls_certificate(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLoadBalancerTlsCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLoadBalancerTlsCertificate",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateLoadBalancerTlsCertificateInput`](crate::input::CreateLoadBalancerTlsCertificateInput)
    pub fn builder() -> crate::input::create_load_balancer_tls_certificate_input::Builder {
        crate::input::create_load_balancer_tls_certificate_input::Builder::default()
    }
}

/// See [`CreateRelationalDatabaseInput`](crate::input::CreateRelationalDatabaseInput)
pub mod create_relational_database_input {
    /// A builder for [`CreateRelationalDatabaseInput`](crate::input::CreateRelationalDatabaseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) relational_database_name: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) relational_database_blueprint_id: std::option::Option<std::string::String>,
        pub(crate) relational_database_bundle_id: std::option::Option<std::string::String>,
        pub(crate) master_database_name: std::option::Option<std::string::String>,
        pub(crate) master_username: std::option::Option<std::string::String>,
        pub(crate) master_user_password: std::option::Option<std::string::String>,
        pub(crate) preferred_backup_window: std::option::Option<std::string::String>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) publicly_accessible: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name to use for your new Lightsail database resource.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 2 to 255 alphanumeric characters, or hyphens.</p> </li>
        /// <li> <p>The first and last character must be a letter or number.</p> </li>
        /// </ul>
        pub fn relational_database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.relational_database_name = Some(input.into());
            self
        }
        /// <p>The name to use for your new Lightsail database resource.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 2 to 255 alphanumeric characters, or hyphens.</p> </li>
        /// <li> <p>The first and last character must be a letter or number.</p> </li>
        /// </ul>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relational_database_name = input;
            self
        }
        /// <p>The Availability Zone in which to create your new database. Use the <code>us-east-2a</code> case-sensitive format.</p>
        /// <p>You can get a list of Availability Zones by using the <code>get regions</code> operation. Be sure to add the <code>include relational database Availability Zones</code> parameter to your request.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone in which to create your new database. Use the <code>us-east-2a</code> case-sensitive format.</p>
        /// <p>You can get a list of Availability Zones by using the <code>get regions</code> operation. Be sure to add the <code>include relational database Availability Zones</code> parameter to your request.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The blueprint ID for your new database. A blueprint describes the major engine version of a database.</p>
        /// <p>You can get a list of database blueprints IDs by using the <code>get relational database blueprints</code> operation.</p>
        pub fn relational_database_blueprint_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.relational_database_blueprint_id = Some(input.into());
            self
        }
        /// <p>The blueprint ID for your new database. A blueprint describes the major engine version of a database.</p>
        /// <p>You can get a list of database blueprints IDs by using the <code>get relational database blueprints</code> operation.</p>
        pub fn set_relational_database_blueprint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relational_database_blueprint_id = input;
            self
        }
        /// <p>The bundle ID for your new database. A bundle describes the performance specifications for your database.</p>
        /// <p>You can get a list of database bundle IDs by using the <code>get relational database bundles</code> operation.</p>
        pub fn relational_database_bundle_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.relational_database_bundle_id = Some(input.into());
            self
        }
        /// <p>The bundle ID for your new database. A bundle describes the performance specifications for your database.</p>
        /// <p>You can get a list of database bundle IDs by using the <code>get relational database bundles</code> operation.</p>
        pub fn set_relational_database_bundle_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relational_database_bundle_id = input;
            self
        }
        /// <p>The meaning of this parameter differs according to the database engine you use.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>The name of the database to create when the Lightsail database resource is created. If this parameter isn't specified, no database is created in the database resource.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1 to 64 letters or numbers.</p> </li>
        /// <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0- 9).</p> </li>
        /// <li> <p>Can't be a word reserved by the specified database engine.</p> <p>For more information about reserved words in MySQL, see the Keywords and Reserved Words articles for <a href="https://dev.mysql.com/doc/refman/5.6/en/keywords.html">MySQL 5.6</a>, <a href="https://dev.mysql.com/doc/refman/5.7/en/keywords.html">MySQL 5.7</a>, and <a href="https://dev.mysql.com/doc/refman/8.0/en/keywords.html">MySQL 8.0</a>.</p> </li>
        /// </ul>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>The name of the database to create when the Lightsail database resource is created. If this parameter isn't specified, a database named <code>postgres</code> is created in the database resource.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1 to 63 letters or numbers.</p> </li>
        /// <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0- 9).</p> </li>
        /// <li> <p>Can't be a word reserved by the specified database engine.</p> <p>For more information about reserved words in PostgreSQL, see the SQL Key Words articles for <a href="https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html">PostgreSQL 9.6</a>, <a href="https://www.postgresql.org/docs/10/sql-keywords-appendix.html">PostgreSQL 10</a>, <a href="https://www.postgresql.org/docs/11/sql-keywords-appendix.html">PostgreSQL 11</a>, and <a href="https://www.postgresql.org/docs/12/sql-keywords-appendix.html">PostgreSQL 12</a>.</p> </li>
        /// </ul>
        pub fn master_database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_database_name = Some(input.into());
            self
        }
        /// <p>The meaning of this parameter differs according to the database engine you use.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>The name of the database to create when the Lightsail database resource is created. If this parameter isn't specified, no database is created in the database resource.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1 to 64 letters or numbers.</p> </li>
        /// <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0- 9).</p> </li>
        /// <li> <p>Can't be a word reserved by the specified database engine.</p> <p>For more information about reserved words in MySQL, see the Keywords and Reserved Words articles for <a href="https://dev.mysql.com/doc/refman/5.6/en/keywords.html">MySQL 5.6</a>, <a href="https://dev.mysql.com/doc/refman/5.7/en/keywords.html">MySQL 5.7</a>, and <a href="https://dev.mysql.com/doc/refman/8.0/en/keywords.html">MySQL 8.0</a>.</p> </li>
        /// </ul>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>The name of the database to create when the Lightsail database resource is created. If this parameter isn't specified, a database named <code>postgres</code> is created in the database resource.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1 to 63 letters or numbers.</p> </li>
        /// <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0- 9).</p> </li>
        /// <li> <p>Can't be a word reserved by the specified database engine.</p> <p>For more information about reserved words in PostgreSQL, see the SQL Key Words articles for <a href="https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html">PostgreSQL 9.6</a>, <a href="https://www.postgresql.org/docs/10/sql-keywords-appendix.html">PostgreSQL 10</a>, <a href="https://www.postgresql.org/docs/11/sql-keywords-appendix.html">PostgreSQL 11</a>, and <a href="https://www.postgresql.org/docs/12/sql-keywords-appendix.html">PostgreSQL 12</a>.</p> </li>
        /// </ul>
        pub fn set_master_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_database_name = input;
            self
        }
        /// <p>The name for the master user.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Required for MySQL.</p> </li>
        /// <li> <p>Must be 1 to 16 letters or numbers. Can contain underscores.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't be a reserved word for the chosen database engine.</p> <p>For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved Words articles for <a href="https://dev.mysql.com/doc/refman/5.6/en/keywords.html">MySQL 5.6</a>, <a href="https://dev.mysql.com/doc/refman/5.7/en/keywords.html">MySQL 5.7</a>, or <a href="https://dev.mysql.com/doc/refman/8.0/en/keywords.html">MySQL 8.0</a>.</p> </li>
        /// </ul>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Required for PostgreSQL.</p> </li>
        /// <li> <p>Must be 1 to 63 letters or numbers. Can contain underscores.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't be a reserved word for the chosen database engine.</p> <p>For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved Words articles for <a href="https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html">PostgreSQL 9.6</a>, <a href="https://www.postgresql.org/docs/10/sql-keywords-appendix.html">PostgreSQL 10</a>, <a href="https://www.postgresql.org/docs/11/sql-keywords-appendix.html">PostgreSQL 11</a>, and <a href="https://www.postgresql.org/docs/12/sql-keywords-appendix.html">PostgreSQL 12</a>.</p> </li>
        /// </ul>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_username = Some(input.into());
            self
        }
        /// <p>The name for the master user.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Required for MySQL.</p> </li>
        /// <li> <p>Must be 1 to 16 letters or numbers. Can contain underscores.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't be a reserved word for the chosen database engine.</p> <p>For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved Words articles for <a href="https://dev.mysql.com/doc/refman/5.6/en/keywords.html">MySQL 5.6</a>, <a href="https://dev.mysql.com/doc/refman/5.7/en/keywords.html">MySQL 5.7</a>, or <a href="https://dev.mysql.com/doc/refman/8.0/en/keywords.html">MySQL 8.0</a>.</p> </li>
        /// </ul>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Required for PostgreSQL.</p> </li>
        /// <li> <p>Must be 1 to 63 letters or numbers. Can contain underscores.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't be a reserved word for the chosen database engine.</p> <p>For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords and Reserved Words articles for <a href="https://www.postgresql.org/docs/9.6/sql-keywords-appendix.html">PostgreSQL 9.6</a>, <a href="https://www.postgresql.org/docs/10/sql-keywords-appendix.html">PostgreSQL 10</a>, <a href="https://www.postgresql.org/docs/11/sql-keywords-appendix.html">PostgreSQL 11</a>, and <a href="https://www.postgresql.org/docs/12/sql-keywords-appendix.html">PostgreSQL 12</a>.</p> </li>
        /// </ul>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_username = input;
            self
        }
        /// <p>The password for the master user. The password can include any printable ASCII character except "/", """, or "@". It cannot contain spaces.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>Constraints: Must contain from 8 to 128 characters.</p>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_user_password = Some(input.into());
            self
        }
        /// <p>The password for the master user. The password can include any printable ASCII character except "/", """, or "@". It cannot contain spaces.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>Constraints: Must contain from 8 to 128 characters.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_user_password = input;
            self
        }
        /// <p>The daily time range during which automated backups are created for your new database if automated backups are enabled.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region. For more information about the preferred backup window time blocks for each region, see the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Working With Backups</a> guide in the Amazon Relational Database Service (Amazon RDS) documentation.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be in the <code>hh24:mi-hh24:mi</code> format.</p> <p>Example: <code>16:00-16:30</code> </p> </li>
        /// <li> <p>Specified in Coordinated Universal Time (UTC).</p> </li>
        /// <li> <p>Must not conflict with the preferred maintenance window.</p> </li>
        /// <li> <p>Must be at least 30 minutes.</p> </li>
        /// </ul>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_backup_window = Some(input.into());
            self
        }
        /// <p>The daily time range during which automated backups are created for your new database if automated backups are enabled.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region. For more information about the preferred backup window time blocks for each region, see the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Working With Backups</a> guide in the Amazon Relational Database Service (Amazon RDS) documentation.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be in the <code>hh24:mi-hh24:mi</code> format.</p> <p>Example: <code>16:00-16:30</code> </p> </li>
        /// <li> <p>Specified in Coordinated Universal Time (UTC).</p> </li>
        /// <li> <p>Must not conflict with the preferred maintenance window.</p> </li>
        /// <li> <p>Must be at least 30 minutes.</p> </li>
        /// </ul>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_backup_window = input;
            self
        }
        /// <p>The weekly time range during which system maintenance can occur on your new database.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.</p> </li>
        /// <li> <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p> </li>
        /// <li> <p>Must be at least 30 minutes.</p> </li>
        /// <li> <p>Specified in Coordinated Universal Time (UTC).</p> </li>
        /// <li> <p>Example: <code>Tue:17:00-Tue:17:30</code> </p> </li>
        /// </ul>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>The weekly time range during which system maintenance can occur on your new database.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.</p> </li>
        /// <li> <p>Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p> </li>
        /// <li> <p>Must be at least 30 minutes.</p> </li>
        /// <li> <p>Specified in Coordinated Universal Time (UTC).</p> </li>
        /// <li> <p>Example: <code>Tue:17:00-Tue:17:30</code> </p> </li>
        /// </ul>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>Specifies the accessibility options for your new database. A value of <code>true</code> specifies a database that is available to resources outside of your Lightsail account. A value of <code>false</code> specifies a database that is available only to your Lightsail resources in the same region as your database.</p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.publicly_accessible = Some(input);
            self
        }
        /// <p>Specifies the accessibility options for your new database. A value of <code>true</code> specifies a database that is available to resources outside of your Lightsail account. A value of <code>false</code> specifies a database that is available only to your Lightsail resources in the same region as your database.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.publicly_accessible = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRelationalDatabaseInput`](crate::input::CreateRelationalDatabaseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRelationalDatabaseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRelationalDatabaseInput {
                relational_database_name: self.relational_database_name,
                availability_zone: self.availability_zone,
                relational_database_blueprint_id: self.relational_database_blueprint_id,
                relational_database_bundle_id: self.relational_database_bundle_id,
                master_database_name: self.master_database_name,
                master_username: self.master_username,
                master_user_password: self.master_user_password,
                preferred_backup_window: self.preferred_backup_window,
                preferred_maintenance_window: self.preferred_maintenance_window,
                publicly_accessible: self.publicly_accessible,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRelationalDatabaseInputOperationOutputAlias =
    crate::operation::CreateRelationalDatabase;
#[doc(hidden)]
pub type CreateRelationalDatabaseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateRelationalDatabaseInput {
    /// Consumes the builder and constructs an Operation<[`CreateRelationalDatabase`](crate::operation::CreateRelationalDatabase)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRelationalDatabase,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateRelationalDatabaseInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateRelationalDatabaseInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CreateRelationalDatabase",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_relational_database(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRelationalDatabase::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRelationalDatabase",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateRelationalDatabaseInput`](crate::input::CreateRelationalDatabaseInput)
    pub fn builder() -> crate::input::create_relational_database_input::Builder {
        crate::input::create_relational_database_input::Builder::default()
    }
}

/// See [`CreateRelationalDatabaseFromSnapshotInput`](crate::input::CreateRelationalDatabaseFromSnapshotInput)
pub mod create_relational_database_from_snapshot_input {
    /// A builder for [`CreateRelationalDatabaseFromSnapshotInput`](crate::input::CreateRelationalDatabaseFromSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) relational_database_name: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) publicly_accessible: std::option::Option<bool>,
        pub(crate) relational_database_snapshot_name: std::option::Option<std::string::String>,
        pub(crate) relational_database_bundle_id: std::option::Option<std::string::String>,
        pub(crate) source_relational_database_name: std::option::Option<std::string::String>,
        pub(crate) restore_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) use_latest_restorable_time: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name to use for your new Lightsail database resource.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 2 to 255 alphanumeric characters, or hyphens.</p> </li>
        /// <li> <p>The first and last character must be a letter or number.</p> </li>
        /// </ul>
        pub fn relational_database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.relational_database_name = Some(input.into());
            self
        }
        /// <p>The name to use for your new Lightsail database resource.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 2 to 255 alphanumeric characters, or hyphens.</p> </li>
        /// <li> <p>The first and last character must be a letter or number.</p> </li>
        /// </ul>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relational_database_name = input;
            self
        }
        /// <p>The Availability Zone in which to create your new database. Use the <code>us-east-2a</code> case-sensitive format.</p>
        /// <p>You can get a list of Availability Zones by using the <code>get regions</code> operation. Be sure to add the <code>include relational database Availability Zones</code> parameter to your request.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone in which to create your new database. Use the <code>us-east-2a</code> case-sensitive format.</p>
        /// <p>You can get a list of Availability Zones by using the <code>get regions</code> operation. Be sure to add the <code>include relational database Availability Zones</code> parameter to your request.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>Specifies the accessibility options for your new database. A value of <code>true</code> specifies a database that is available to resources outside of your Lightsail account. A value of <code>false</code> specifies a database that is available only to your Lightsail resources in the same region as your database.</p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.publicly_accessible = Some(input);
            self
        }
        /// <p>Specifies the accessibility options for your new database. A value of <code>true</code> specifies a database that is available to resources outside of your Lightsail account. A value of <code>false</code> specifies a database that is available only to your Lightsail resources in the same region as your database.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.publicly_accessible = input;
            self
        }
        /// <p>The name of the database snapshot from which to create your new database.</p>
        pub fn relational_database_snapshot_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.relational_database_snapshot_name = Some(input.into());
            self
        }
        /// <p>The name of the database snapshot from which to create your new database.</p>
        pub fn set_relational_database_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relational_database_snapshot_name = input;
            self
        }
        /// <p>The bundle ID for your new database. A bundle describes the performance specifications for your database.</p>
        /// <p>You can get a list of database bundle IDs by using the <code>get relational database bundles</code> operation.</p>
        /// <p>When creating a new database from a snapshot, you cannot choose a bundle that is smaller than the bundle of the source database.</p>
        pub fn relational_database_bundle_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.relational_database_bundle_id = Some(input.into());
            self
        }
        /// <p>The bundle ID for your new database. A bundle describes the performance specifications for your database.</p>
        /// <p>You can get a list of database bundle IDs by using the <code>get relational database bundles</code> operation.</p>
        /// <p>When creating a new database from a snapshot, you cannot choose a bundle that is smaller than the bundle of the source database.</p>
        pub fn set_relational_database_bundle_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relational_database_bundle_id = input;
            self
        }
        /// <p>The name of the source database.</p>
        pub fn source_relational_database_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_relational_database_name = Some(input.into());
            self
        }
        /// <p>The name of the source database.</p>
        pub fn set_source_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_relational_database_name = input;
            self
        }
        /// <p>The date and time to restore your database from.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be before the latest restorable time for the database.</p> </li>
        /// <li> <p>Cannot be specified if the <code>use latest restorable time</code> parameter is <code>true</code>.</p> </li>
        /// <li> <p>Specified in Coordinated Universal Time (UTC).</p> </li>
        /// <li> <p>Specified in the Unix time format.</p> <p>For example, if you wish to use a restore time of October 1, 2018, at 8 PM UTC, then you input <code>1538424000</code> as the restore time.</p> </li>
        /// </ul>
        pub fn restore_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.restore_time = Some(input);
            self
        }
        /// <p>The date and time to restore your database from.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be before the latest restorable time for the database.</p> </li>
        /// <li> <p>Cannot be specified if the <code>use latest restorable time</code> parameter is <code>true</code>.</p> </li>
        /// <li> <p>Specified in Coordinated Universal Time (UTC).</p> </li>
        /// <li> <p>Specified in the Unix time format.</p> <p>For example, if you wish to use a restore time of October 1, 2018, at 8 PM UTC, then you input <code>1538424000</code> as the restore time.</p> </li>
        /// </ul>
        pub fn set_restore_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.restore_time = input;
            self
        }
        /// <p>Specifies whether your database is restored from the latest backup time. A value of <code>true</code> restores from the latest backup time. </p>
        /// <p>Default: <code>false</code> </p>
        /// <p>Constraints: Cannot be specified if the <code>restore time</code> parameter is provided.</p>
        pub fn use_latest_restorable_time(mut self, input: bool) -> Self {
            self.use_latest_restorable_time = Some(input);
            self
        }
        /// <p>Specifies whether your database is restored from the latest backup time. A value of <code>true</code> restores from the latest backup time. </p>
        /// <p>Default: <code>false</code> </p>
        /// <p>Constraints: Cannot be specified if the <code>restore time</code> parameter is provided.</p>
        pub fn set_use_latest_restorable_time(mut self, input: std::option::Option<bool>) -> Self {
            self.use_latest_restorable_time = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRelationalDatabaseFromSnapshotInput`](crate::input::CreateRelationalDatabaseFromSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRelationalDatabaseFromSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRelationalDatabaseFromSnapshotInput {
                relational_database_name: self.relational_database_name,
                availability_zone: self.availability_zone,
                publicly_accessible: self.publicly_accessible,
                relational_database_snapshot_name: self.relational_database_snapshot_name,
                relational_database_bundle_id: self.relational_database_bundle_id,
                source_relational_database_name: self.source_relational_database_name,
                restore_time: self.restore_time,
                use_latest_restorable_time: self.use_latest_restorable_time,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRelationalDatabaseFromSnapshotInputOperationOutputAlias =
    crate::operation::CreateRelationalDatabaseFromSnapshot;
#[doc(hidden)]
pub type CreateRelationalDatabaseFromSnapshotInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateRelationalDatabaseFromSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CreateRelationalDatabaseFromSnapshot`](crate::operation::CreateRelationalDatabaseFromSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRelationalDatabaseFromSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateRelationalDatabaseFromSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateRelationalDatabaseFromSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CreateRelationalDatabaseFromSnapshot",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_relational_database_from_snapshot(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRelationalDatabaseFromSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRelationalDatabaseFromSnapshot",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateRelationalDatabaseFromSnapshotInput`](crate::input::CreateRelationalDatabaseFromSnapshotInput)
    pub fn builder() -> crate::input::create_relational_database_from_snapshot_input::Builder {
        crate::input::create_relational_database_from_snapshot_input::Builder::default()
    }
}

/// See [`CreateRelationalDatabaseSnapshotInput`](crate::input::CreateRelationalDatabaseSnapshotInput)
pub mod create_relational_database_snapshot_input {
    /// A builder for [`CreateRelationalDatabaseSnapshotInput`](crate::input::CreateRelationalDatabaseSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) relational_database_name: std::option::Option<std::string::String>,
        pub(crate) relational_database_snapshot_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the database on which to base your new snapshot.</p>
        pub fn relational_database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.relational_database_name = Some(input.into());
            self
        }
        /// <p>The name of the database on which to base your new snapshot.</p>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relational_database_name = input;
            self
        }
        /// <p>The name for your new database snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 2 to 255 alphanumeric characters, or hyphens.</p> </li>
        /// <li> <p>The first and last character must be a letter or number.</p> </li>
        /// </ul>
        pub fn relational_database_snapshot_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.relational_database_snapshot_name = Some(input.into());
            self
        }
        /// <p>The name for your new database snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 2 to 255 alphanumeric characters, or hyphens.</p> </li>
        /// <li> <p>The first and last character must be a letter or number.</p> </li>
        /// </ul>
        pub fn set_relational_database_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relational_database_snapshot_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values to add to the resource during create.</p>
        /// <p>Use the <code>TagResource</code> action to tag a resource after it's created.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRelationalDatabaseSnapshotInput`](crate::input::CreateRelationalDatabaseSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRelationalDatabaseSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRelationalDatabaseSnapshotInput {
                relational_database_name: self.relational_database_name,
                relational_database_snapshot_name: self.relational_database_snapshot_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRelationalDatabaseSnapshotInputOperationOutputAlias =
    crate::operation::CreateRelationalDatabaseSnapshot;
#[doc(hidden)]
pub type CreateRelationalDatabaseSnapshotInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateRelationalDatabaseSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CreateRelationalDatabaseSnapshot`](crate::operation::CreateRelationalDatabaseSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRelationalDatabaseSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateRelationalDatabaseSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateRelationalDatabaseSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.CreateRelationalDatabaseSnapshot",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_relational_database_snapshot(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRelationalDatabaseSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRelationalDatabaseSnapshot",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateRelationalDatabaseSnapshotInput`](crate::input::CreateRelationalDatabaseSnapshotInput)
    pub fn builder() -> crate::input::create_relational_database_snapshot_input::Builder {
        crate::input::create_relational_database_snapshot_input::Builder::default()
    }
}

/// See [`DeleteAlarmInput`](crate::input::DeleteAlarmInput)
pub mod delete_alarm_input {
    /// A builder for [`DeleteAlarmInput`](crate::input::DeleteAlarmInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarm_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the alarm to delete.</p>
        pub fn alarm_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_name = Some(input.into());
            self
        }
        /// <p>The name of the alarm to delete.</p>
        pub fn set_alarm_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alarm_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAlarmInput`](crate::input::DeleteAlarmInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAlarmInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAlarmInput {
                alarm_name: self.alarm_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAlarmInputOperationOutputAlias = crate::operation::DeleteAlarm;
#[doc(hidden)]
pub type DeleteAlarmInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAlarmInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAlarm`](crate::operation::DeleteAlarm)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAlarm,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteAlarmInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteAlarmInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DeleteAlarm",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_alarm(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAlarm::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAlarm",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteAlarmInput`](crate::input::DeleteAlarmInput)
    pub fn builder() -> crate::input::delete_alarm_input::Builder {
        crate::input::delete_alarm_input::Builder::default()
    }
}

/// See [`DeleteAutoSnapshotInput`](crate::input::DeleteAutoSnapshotInput)
pub mod delete_auto_snapshot_input {
    /// A builder for [`DeleteAutoSnapshotInput`](crate::input::DeleteAutoSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) date: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the source instance or disk from which to delete the automatic snapshot.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of the source instance or disk from which to delete the automatic snapshot.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// <p>The date of the automatic snapshot to delete in <code>YYYY-MM-DD</code> format. Use the <code>get auto snapshots</code> operation to get the available automatic snapshots for a resource.</p>
        pub fn date(mut self, input: impl Into<std::string::String>) -> Self {
            self.date = Some(input.into());
            self
        }
        /// <p>The date of the automatic snapshot to delete in <code>YYYY-MM-DD</code> format. Use the <code>get auto snapshots</code> operation to get the available automatic snapshots for a resource.</p>
        pub fn set_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAutoSnapshotInput`](crate::input::DeleteAutoSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAutoSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAutoSnapshotInput {
                resource_name: self.resource_name,
                date: self.date,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAutoSnapshotInputOperationOutputAlias = crate::operation::DeleteAutoSnapshot;
#[doc(hidden)]
pub type DeleteAutoSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAutoSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAutoSnapshot`](crate::operation::DeleteAutoSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAutoSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteAutoSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteAutoSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DeleteAutoSnapshot",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_auto_snapshot(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAutoSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAutoSnapshot",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteAutoSnapshotInput`](crate::input::DeleteAutoSnapshotInput)
    pub fn builder() -> crate::input::delete_auto_snapshot_input::Builder {
        crate::input::delete_auto_snapshot_input::Builder::default()
    }
}

/// See [`DeleteBucketInput`](crate::input::DeleteBucketInput)
pub mod delete_bucket_input {
    /// A builder for [`DeleteBucketInput`](crate::input::DeleteBucketInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) force_delete: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the bucket to delete.</p>
        /// <p>Use the <a href="https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBuckets.html">GetBuckets</a> action to get a list of bucket names that you can specify.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the bucket to delete.</p>
        /// <p>Use the <a href="https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBuckets.html">GetBuckets</a> action to get a list of bucket names that you can specify.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>A Boolean value that indicates whether to force delete the bucket.</p>
        /// <p>You must force delete the bucket if it has one of the following conditions:</p>
        /// <ul>
        /// <li> <p>The bucket is the origin of a distribution.</p> </li>
        /// <li> <p>The bucket has instances that were granted access to it using the <a href="https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_SetResourceAccessForBucket.html">SetResourceAccessForBucket</a> action.</p> </li>
        /// <li> <p>The bucket has objects.</p> </li>
        /// <li> <p>The bucket has access keys.</p> </li>
        /// </ul> <important>
        /// <p>Force deleting a bucket might impact other resources that rely on the bucket, such as instances, distributions, or software that use the issued access keys.</p>
        /// </important>
        pub fn force_delete(mut self, input: bool) -> Self {
            self.force_delete = Some(input);
            self
        }
        /// <p>A Boolean value that indicates whether to force delete the bucket.</p>
        /// <p>You must force delete the bucket if it has one of the following conditions:</p>
        /// <ul>
        /// <li> <p>The bucket is the origin of a distribution.</p> </li>
        /// <li> <p>The bucket has instances that were granted access to it using the <a href="https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_SetResourceAccessForBucket.html">SetResourceAccessForBucket</a> action.</p> </li>
        /// <li> <p>The bucket has objects.</p> </li>
        /// <li> <p>The bucket has access keys.</p> </li>
        /// </ul> <important>
        /// <p>Force deleting a bucket might impact other resources that rely on the bucket, such as instances, distributions, or software that use the issued access keys.</p>
        /// </important>
        pub fn set_force_delete(mut self, input: std::option::Option<bool>) -> Self {
            self.force_delete = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketInput`](crate::input::DeleteBucketInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketInput {
                bucket_name: self.bucket_name,
                force_delete: self.force_delete,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketInputOperationOutputAlias = crate::operation::DeleteBucket;
#[doc(hidden)]
pub type DeleteBucketInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucket`](crate::operation::DeleteBucket)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucket,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBucketInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBucketInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DeleteBucket",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_bucket(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucket::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucket",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketInput`](crate::input::DeleteBucketInput)
    pub fn builder() -> crate::input::delete_bucket_input::Builder {
        crate::input::delete_bucket_input::Builder::default()
    }
}

/// See [`DeleteBucketAccessKeyInput`](crate::input::DeleteBucketAccessKeyInput)
pub mod delete_bucket_access_key_input {
    /// A builder for [`DeleteBucketAccessKeyInput`](crate::input::DeleteBucketAccessKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) access_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket that the access key belongs to.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the bucket that the access key belongs to.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The ID of the access key to delete.</p>
        /// <p>Use the <a href="https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBucketAccessKeys.html">GetBucketAccessKeys</a> action to get a list of access key IDs that you can specify.</p>
        pub fn access_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the access key to delete.</p>
        /// <p>Use the <a href="https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBucketAccessKeys.html">GetBucketAccessKeys</a> action to get a list of access key IDs that you can specify.</p>
        pub fn set_access_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBucketAccessKeyInput`](crate::input::DeleteBucketAccessKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBucketAccessKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBucketAccessKeyInput {
                bucket_name: self.bucket_name,
                access_key_id: self.access_key_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBucketAccessKeyInputOperationOutputAlias = crate::operation::DeleteBucketAccessKey;
#[doc(hidden)]
pub type DeleteBucketAccessKeyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteBucketAccessKeyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBucketAccessKey`](crate::operation::DeleteBucketAccessKey)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBucketAccessKey,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteBucketAccessKeyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteBucketAccessKeyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DeleteBucketAccessKey",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_bucket_access_key(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBucketAccessKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBucketAccessKey",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteBucketAccessKeyInput`](crate::input::DeleteBucketAccessKeyInput)
    pub fn builder() -> crate::input::delete_bucket_access_key_input::Builder {
        crate::input::delete_bucket_access_key_input::Builder::default()
    }
}

/// See [`DeleteCertificateInput`](crate::input::DeleteCertificateInput)
pub mod delete_certificate_input {
    /// A builder for [`DeleteCertificateInput`](crate::input::DeleteCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the certificate to delete.</p>
        /// <p>Use the <code>GetCertificates</code> action to get a list of certificate names that you can specify.</p>
        pub fn certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_name = Some(input.into());
            self
        }
        /// <p>The name of the certificate to delete.</p>
        /// <p>Use the <code>GetCertificates</code> action to get a list of certificate names that you can specify.</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCertificateInput`](crate::input::DeleteCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCertificateInput {
                certificate_name: self.certificate_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCertificateInputOperationOutputAlias = crate::operation::DeleteCertificate;
#[doc(hidden)]
pub type DeleteCertificateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteCertificateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCertificate`](crate::operation::DeleteCertificate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCertificate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteCertificateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteCertificateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DeleteCertificate",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_certificate(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCertificate",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteCertificateInput`](crate::input::DeleteCertificateInput)
    pub fn builder() -> crate::input::delete_certificate_input::Builder {
        crate::input::delete_certificate_input::Builder::default()
    }
}

/// See [`DeleteContactMethodInput`](crate::input::DeleteContactMethodInput)
pub mod delete_contact_method_input {
    /// A builder for [`DeleteContactMethodInput`](crate::input::DeleteContactMethodInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) protocol: std::option::Option<crate::model::ContactProtocol>,
    }
    impl Builder {
        /// <p>The protocol that will be deleted, such as <code>Email</code> or <code>SMS</code> (text messaging).</p> <note>
        /// <p>To delete an <code>Email</code> and an <code>SMS</code> contact method if you added both, you must run separate <code>DeleteContactMethod</code> actions to delete each protocol.</p>
        /// </note>
        pub fn protocol(mut self, input: crate::model::ContactProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol that will be deleted, such as <code>Email</code> or <code>SMS</code> (text messaging).</p> <note>
        /// <p>To delete an <code>Email</code> and an <code>SMS</code> contact method if you added both, you must run separate <code>DeleteContactMethod</code> actions to delete each protocol.</p>
        /// </note>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::ContactProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteContactMethodInput`](crate::input::DeleteContactMethodInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteContactMethodInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteContactMethodInput {
                protocol: self.protocol,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteContactMethodInputOperationOutputAlias = crate::operation::DeleteContactMethod;
#[doc(hidden)]
pub type DeleteContactMethodInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteContactMethodInput {
    /// Consumes the builder and constructs an Operation<[`DeleteContactMethod`](crate::operation::DeleteContactMethod)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteContactMethod,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteContactMethodInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteContactMethodInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DeleteContactMethod",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_contact_method(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteContactMethod::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteContactMethod",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteContactMethodInput`](crate::input::DeleteContactMethodInput)
    pub fn builder() -> crate::input::delete_contact_method_input::Builder {
        crate::input::delete_contact_method_input::Builder::default()
    }
}

/// See [`DeleteContainerImageInput`](crate::input::DeleteContainerImageInput)
pub mod delete_container_image_input {
    /// A builder for [`DeleteContainerImageInput`](crate::input::DeleteContainerImageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) image: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the container service for which to delete a registered container image.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the container service for which to delete a registered container image.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>The name of the container image to delete from the container service.</p>
        /// <p>Use the <code>GetContainerImages</code> action to get the name of the container images that are registered to a container service.</p> <note>
        /// <p>Container images sourced from your Lightsail container service, that are registered and stored on your service, start with a colon (<code>:</code>). For example, <code>:container-service-1.mystaticwebsite.1</code>. Container images sourced from a public registry like Docker Hub don't start with a colon. For example, <code>nginx:latest</code> or <code>nginx</code>.</p>
        /// </note>
        pub fn image(mut self, input: impl Into<std::string::String>) -> Self {
            self.image = Some(input.into());
            self
        }
        /// <p>The name of the container image to delete from the container service.</p>
        /// <p>Use the <code>GetContainerImages</code> action to get the name of the container images that are registered to a container service.</p> <note>
        /// <p>Container images sourced from your Lightsail container service, that are registered and stored on your service, start with a colon (<code>:</code>). For example, <code>:container-service-1.mystaticwebsite.1</code>. Container images sourced from a public registry like Docker Hub don't start with a colon. For example, <code>nginx:latest</code> or <code>nginx</code>.</p>
        /// </note>
        pub fn set_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteContainerImageInput`](crate::input::DeleteContainerImageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteContainerImageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteContainerImageInput {
                service_name: self.service_name,
                image: self.image,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteContainerImageInputOperationOutputAlias = crate::operation::DeleteContainerImage;
#[doc(hidden)]
pub type DeleteContainerImageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteContainerImageInput {
    /// Consumes the builder and constructs an Operation<[`DeleteContainerImage`](crate::operation::DeleteContainerImage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteContainerImage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteContainerImageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteContainerImageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DeleteContainerImage",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_container_image(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteContainerImage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteContainerImage",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteContainerImageInput`](crate::input::DeleteContainerImageInput)
    pub fn builder() -> crate::input::delete_container_image_input::Builder {
        crate::input::delete_container_image_input::Builder::default()
    }
}

/// See [`DeleteContainerServiceInput`](crate::input::DeleteContainerServiceInput)
pub mod delete_container_service_input {
    /// A builder for [`DeleteContainerServiceInput`](crate::input::DeleteContainerServiceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the container service to delete.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the container service to delete.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteContainerServiceInput`](crate::input::DeleteContainerServiceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteContainerServiceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteContainerServiceInput {
                service_name: self.service_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteContainerServiceInputOperationOutputAlias = crate::operation::DeleteContainerService;
#[doc(hidden)]
pub type DeleteContainerServiceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteContainerServiceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteContainerService`](crate::operation::DeleteContainerService)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteContainerService,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteContainerServiceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteContainerServiceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DeleteContainerService",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_container_service(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteContainerService::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteContainerService",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteContainerServiceInput`](crate::input::DeleteContainerServiceInput)
    pub fn builder() -> crate::input::delete_container_service_input::Builder {
        crate::input::delete_container_service_input::Builder::default()
    }
}

/// See [`DeleteDiskInput`](crate::input::DeleteDiskInput)
pub mod delete_disk_input {
    /// A builder for [`DeleteDiskInput`](crate::input::DeleteDiskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) disk_name: std::option::Option<std::string::String>,
        pub(crate) force_delete_add_ons: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The unique name of the disk you want to delete (e.g., <code>my-disk</code>).</p>
        pub fn disk_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.disk_name = Some(input.into());
            self
        }
        /// <p>The unique name of the disk you want to delete (e.g., <code>my-disk</code>).</p>
        pub fn set_disk_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.disk_name = input;
            self
        }
        /// <p>A Boolean value to indicate whether to delete the enabled add-ons for the disk.</p>
        pub fn force_delete_add_ons(mut self, input: bool) -> Self {
            self.force_delete_add_ons = Some(input);
            self
        }
        /// <p>A Boolean value to indicate whether to delete the enabled add-ons for the disk.</p>
        pub fn set_force_delete_add_ons(mut self, input: std::option::Option<bool>) -> Self {
            self.force_delete_add_ons = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDiskInput`](crate::input::DeleteDiskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDiskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDiskInput {
                disk_name: self.disk_name,
                force_delete_add_ons: self.force_delete_add_ons,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDiskInputOperationOutputAlias = crate::operation::DeleteDisk;
#[doc(hidden)]
pub type DeleteDiskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDiskInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDisk`](crate::operation::DeleteDisk)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDisk,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDiskInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDiskInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DeleteDisk",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_disk(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDisk::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDisk",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDiskInput`](crate::input::DeleteDiskInput)
    pub fn builder() -> crate::input::delete_disk_input::Builder {
        crate::input::delete_disk_input::Builder::default()
    }
}

/// See [`DeleteDiskSnapshotInput`](crate::input::DeleteDiskSnapshotInput)
pub mod delete_disk_snapshot_input {
    /// A builder for [`DeleteDiskSnapshotInput`](crate::input::DeleteDiskSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) disk_snapshot_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the disk snapshot you want to delete (e.g., <code>my-disk-snapshot</code>).</p>
        pub fn disk_snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.disk_snapshot_name = Some(input.into());
            self
        }
        /// <p>The name of the disk snapshot you want to delete (e.g., <code>my-disk-snapshot</code>).</p>
        pub fn set_disk_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.disk_snapshot_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDiskSnapshotInput`](crate::input::DeleteDiskSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDiskSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDiskSnapshotInput {
                disk_snapshot_name: self.disk_snapshot_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDiskSnapshotInputOperationOutputAlias = crate::operation::DeleteDiskSnapshot;
#[doc(hidden)]
pub type DeleteDiskSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDiskSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDiskSnapshot`](crate::operation::DeleteDiskSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDiskSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDiskSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDiskSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DeleteDiskSnapshot",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_disk_snapshot(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDiskSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDiskSnapshot",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDiskSnapshotInput`](crate::input::DeleteDiskSnapshotInput)
    pub fn builder() -> crate::input::delete_disk_snapshot_input::Builder {
        crate::input::delete_disk_snapshot_input::Builder::default()
    }
}

/// See [`DeleteDistributionInput`](crate::input::DeleteDistributionInput)
pub mod delete_distribution_input {
    /// A builder for [`DeleteDistributionInput`](crate::input::DeleteDistributionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the distribution to delete.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you can specify.</p>
        pub fn distribution_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.distribution_name = Some(input.into());
            self
        }
        /// <p>The name of the distribution to delete.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you can specify.</p>
        pub fn set_distribution_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDistributionInput`](crate::input::DeleteDistributionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDistributionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDistributionInput {
                distribution_name: self.distribution_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDistributionInputOperationOutputAlias = crate::operation::DeleteDistribution;
#[doc(hidden)]
pub type DeleteDistributionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDistributionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDistribution`](crate::operation::DeleteDistribution)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDistribution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDistributionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDistributionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DeleteDistribution",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_distribution(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDistribution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDistribution",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDistributionInput`](crate::input::DeleteDistributionInput)
    pub fn builder() -> crate::input::delete_distribution_input::Builder {
        crate::input::delete_distribution_input::Builder::default()
    }
}

/// See [`DeleteDomainInput`](crate::input::DeleteDomainInput)
pub mod delete_domain_input {
    /// A builder for [`DeleteDomainInput`](crate::input::DeleteDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The specific domain name to delete.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The specific domain name to delete.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDomainInput`](crate::input::DeleteDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDomainInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDomainInputOperationOutputAlias = crate::operation::DeleteDomain;
#[doc(hidden)]
pub type DeleteDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDomainInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDomain`](crate::operation::DeleteDomain)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDomainInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDomainInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DeleteDomain",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_domain(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDomain",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDomainInput`](crate::input::DeleteDomainInput)
    pub fn builder() -> crate::input::delete_domain_input::Builder {
        crate::input::delete_domain_input::Builder::default()
    }
}

/// See [`DeleteDomainEntryInput`](crate::input::DeleteDomainEntryInput)
pub mod delete_domain_entry_input {
    /// A builder for [`DeleteDomainEntryInput`](crate::input::DeleteDomainEntryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) domain_entry: std::option::Option<crate::model::DomainEntry>,
    }
    impl Builder {
        /// <p>The name of the domain entry to delete.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain entry to delete.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>An array of key-value pairs containing information about your domain entries.</p>
        pub fn domain_entry(mut self, input: crate::model::DomainEntry) -> Self {
            self.domain_entry = Some(input);
            self
        }
        /// <p>An array of key-value pairs containing information about your domain entries.</p>
        pub fn set_domain_entry(
            mut self,
            input: std::option::Option<crate::model::DomainEntry>,
        ) -> Self {
            self.domain_entry = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDomainEntryInput`](crate::input::DeleteDomainEntryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDomainEntryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDomainEntryInput {
                domain_name: self.domain_name,
                domain_entry: self.domain_entry,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDomainEntryInputOperationOutputAlias = crate::operation::DeleteDomainEntry;
#[doc(hidden)]
pub type DeleteDomainEntryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDomainEntryInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDomainEntry`](crate::operation::DeleteDomainEntry)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDomainEntry,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDomainEntryInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDomainEntryInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DeleteDomainEntry",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_domain_entry(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDomainEntry::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDomainEntry",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDomainEntryInput`](crate::input::DeleteDomainEntryInput)
    pub fn builder() -> crate::input::delete_domain_entry_input::Builder {
        crate::input::delete_domain_entry_input::Builder::default()
    }
}

/// See [`DeleteInstanceInput`](crate::input::DeleteInstanceInput)
pub mod delete_instance_input {
    /// A builder for [`DeleteInstanceInput`](crate::input::DeleteInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_name: std::option::Option<std::string::String>,
        pub(crate) force_delete_add_ons: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the instance to delete.</p>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_name = Some(input.into());
            self
        }
        /// <p>The name of the instance to delete.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_name = input;
            self
        }
        /// <p>A Boolean value to indicate whether to delete the enabled add-ons for the disk.</p>
        pub fn force_delete_add_ons(mut self, input: bool) -> Self {
            self.force_delete_add_ons = Some(input);
            self
        }
        /// <p>A Boolean value to indicate whether to delete the enabled add-ons for the disk.</p>
        pub fn set_force_delete_add_ons(mut self, input: std::option::Option<bool>) -> Self {
            self.force_delete_add_ons = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInstanceInput`](crate::input::DeleteInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteInstanceInput {
                instance_name: self.instance_name,
                force_delete_add_ons: self.force_delete_add_ons,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteInstanceInputOperationOutputAlias = crate::operation::DeleteInstance;
#[doc(hidden)]
pub type DeleteInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteInstanceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteInstance`](crate::operation::DeleteInstance)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteInstanceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteInstanceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DeleteInstance",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_instance(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteInstance",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteInstanceInput`](crate::input::DeleteInstanceInput)
    pub fn builder() -> crate::input::delete_instance_input::Builder {
        crate::input::delete_instance_input::Builder::default()
    }
}

/// See [`DeleteInstanceSnapshotInput`](crate::input::DeleteInstanceSnapshotInput)
pub mod delete_instance_snapshot_input {
    /// A builder for [`DeleteInstanceSnapshotInput`](crate::input::DeleteInstanceSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_snapshot_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the snapshot to delete.</p>
        pub fn instance_snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_snapshot_name = Some(input.into());
            self
        }
        /// <p>The name of the snapshot to delete.</p>
        pub fn set_instance_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_snapshot_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInstanceSnapshotInput`](crate::input::DeleteInstanceSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteInstanceSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteInstanceSnapshotInput {
                instance_snapshot_name: self.instance_snapshot_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteInstanceSnapshotInputOperationOutputAlias = crate::operation::DeleteInstanceSnapshot;
#[doc(hidden)]
pub type DeleteInstanceSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteInstanceSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`DeleteInstanceSnapshot`](crate::operation::DeleteInstanceSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteInstanceSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteInstanceSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteInstanceSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DeleteInstanceSnapshot",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_instance_snapshot(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteInstanceSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteInstanceSnapshot",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteInstanceSnapshotInput`](crate::input::DeleteInstanceSnapshotInput)
    pub fn builder() -> crate::input::delete_instance_snapshot_input::Builder {
        crate::input::delete_instance_snapshot_input::Builder::default()
    }
}

/// See [`DeleteKeyPairInput`](crate::input::DeleteKeyPairInput)
pub mod delete_key_pair_input {
    /// A builder for [`DeleteKeyPairInput`](crate::input::DeleteKeyPairInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_pair_name: std::option::Option<std::string::String>,
        pub(crate) expected_fingerprint: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the key pair to delete.</p>
        pub fn key_pair_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_pair_name = Some(input.into());
            self
        }
        /// <p>The name of the key pair to delete.</p>
        pub fn set_key_pair_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.key_pair_name = input;
            self
        }
        /// <p>The RSA fingerprint of the Lightsail default key pair to delete.</p> <note>
        /// <p>The <code>expectedFingerprint</code> parameter is required only when specifying to delete a Lightsail default key pair.</p>
        /// </note>
        pub fn expected_fingerprint(mut self, input: impl Into<std::string::String>) -> Self {
            self.expected_fingerprint = Some(input.into());
            self
        }
        /// <p>The RSA fingerprint of the Lightsail default key pair to delete.</p> <note>
        /// <p>The <code>expectedFingerprint</code> parameter is required only when specifying to delete a Lightsail default key pair.</p>
        /// </note>
        pub fn set_expected_fingerprint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_fingerprint = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteKeyPairInput`](crate::input::DeleteKeyPairInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteKeyPairInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteKeyPairInput {
                key_pair_name: self.key_pair_name,
                expected_fingerprint: self.expected_fingerprint,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteKeyPairInputOperationOutputAlias = crate::operation::DeleteKeyPair;
#[doc(hidden)]
pub type DeleteKeyPairInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteKeyPairInput {
    /// Consumes the builder and constructs an Operation<[`DeleteKeyPair`](crate::operation::DeleteKeyPair)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteKeyPair,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteKeyPairInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteKeyPairInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DeleteKeyPair",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_key_pair(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteKeyPair::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteKeyPair",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteKeyPairInput`](crate::input::DeleteKeyPairInput)
    pub fn builder() -> crate::input::delete_key_pair_input::Builder {
        crate::input::delete_key_pair_input::Builder::default()
    }
}

/// See [`DeleteKnownHostKeysInput`](crate::input::DeleteKnownHostKeysInput)
pub mod delete_known_host_keys_input {
    /// A builder for [`DeleteKnownHostKeysInput`](crate::input::DeleteKnownHostKeysInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the instance for which you want to reset the host key or certificate.</p>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_name = Some(input.into());
            self
        }
        /// <p>The name of the instance for which you want to reset the host key or certificate.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteKnownHostKeysInput`](crate::input::DeleteKnownHostKeysInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteKnownHostKeysInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteKnownHostKeysInput {
                instance_name: self.instance_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteKnownHostKeysInputOperationOutputAlias = crate::operation::DeleteKnownHostKeys;
#[doc(hidden)]
pub type DeleteKnownHostKeysInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteKnownHostKeysInput {
    /// Consumes the builder and constructs an Operation<[`DeleteKnownHostKeys`](crate::operation::DeleteKnownHostKeys)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteKnownHostKeys,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteKnownHostKeysInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteKnownHostKeysInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DeleteKnownHostKeys",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_known_host_keys(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteKnownHostKeys::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteKnownHostKeys",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteKnownHostKeysInput`](crate::input::DeleteKnownHostKeysInput)
    pub fn builder() -> crate::input::delete_known_host_keys_input::Builder {
        crate::input::delete_known_host_keys_input::Builder::default()
    }
}

/// See [`DeleteLoadBalancerInput`](crate::input::DeleteLoadBalancerInput)
pub mod delete_load_balancer_input {
    /// A builder for [`DeleteLoadBalancerInput`](crate::input::DeleteLoadBalancerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the load balancer you want to delete.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer you want to delete.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLoadBalancerInput`](crate::input::DeleteLoadBalancerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLoadBalancerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLoadBalancerInput {
                load_balancer_name: self.load_balancer_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLoadBalancerInputOperationOutputAlias = crate::operation::DeleteLoadBalancer;
#[doc(hidden)]
pub type DeleteLoadBalancerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteLoadBalancerInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLoadBalancer`](crate::operation::DeleteLoadBalancer)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLoadBalancer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteLoadBalancerInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteLoadBalancerInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DeleteLoadBalancer",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_load_balancer(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLoadBalancer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLoadBalancer",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteLoadBalancerInput`](crate::input::DeleteLoadBalancerInput)
    pub fn builder() -> crate::input::delete_load_balancer_input::Builder {
        crate::input::delete_load_balancer_input::Builder::default()
    }
}

/// See [`DeleteLoadBalancerTlsCertificateInput`](crate::input::DeleteLoadBalancerTlsCertificateInput)
pub mod delete_load_balancer_tls_certificate_input {
    /// A builder for [`DeleteLoadBalancerTlsCertificateInput`](crate::input::DeleteLoadBalancerTlsCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) certificate_name: std::option::Option<std::string::String>,
        pub(crate) force: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The load balancer name.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The load balancer name.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// <p>The SSL/TLS certificate name.</p>
        pub fn certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_name = Some(input.into());
            self
        }
        /// <p>The SSL/TLS certificate name.</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_name = input;
            self
        }
        /// <p>When <code>true</code>, forces the deletion of an SSL/TLS certificate.</p>
        /// <p>There can be two certificates associated with a Lightsail load balancer: the primary and the backup. The <code>force</code> parameter is required when the primary SSL/TLS certificate is in use by an instance attached to the load balancer.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.force = Some(input);
            self
        }
        /// <p>When <code>true</code>, forces the deletion of an SSL/TLS certificate.</p>
        /// <p>There can be two certificates associated with a Lightsail load balancer: the primary and the backup. The <code>force</code> parameter is required when the primary SSL/TLS certificate is in use by an instance attached to the load balancer.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.force = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLoadBalancerTlsCertificateInput`](crate::input::DeleteLoadBalancerTlsCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLoadBalancerTlsCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLoadBalancerTlsCertificateInput {
                load_balancer_name: self.load_balancer_name,
                certificate_name: self.certificate_name,
                force: self.force,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLoadBalancerTlsCertificateInputOperationOutputAlias =
    crate::operation::DeleteLoadBalancerTlsCertificate;
#[doc(hidden)]
pub type DeleteLoadBalancerTlsCertificateInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteLoadBalancerTlsCertificateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLoadBalancerTlsCertificate`](crate::operation::DeleteLoadBalancerTlsCertificate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLoadBalancerTlsCertificate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteLoadBalancerTlsCertificateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteLoadBalancerTlsCertificateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DeleteLoadBalancerTlsCertificate",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_load_balancer_tls_certificate(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLoadBalancerTlsCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLoadBalancerTlsCertificate",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteLoadBalancerTlsCertificateInput`](crate::input::DeleteLoadBalancerTlsCertificateInput)
    pub fn builder() -> crate::input::delete_load_balancer_tls_certificate_input::Builder {
        crate::input::delete_load_balancer_tls_certificate_input::Builder::default()
    }
}

/// See [`DeleteRelationalDatabaseInput`](crate::input::DeleteRelationalDatabaseInput)
pub mod delete_relational_database_input {
    /// A builder for [`DeleteRelationalDatabaseInput`](crate::input::DeleteRelationalDatabaseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) relational_database_name: std::option::Option<std::string::String>,
        pub(crate) skip_final_snapshot: std::option::Option<bool>,
        pub(crate) final_relational_database_snapshot_name:
            std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the database that you are deleting.</p>
        pub fn relational_database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.relational_database_name = Some(input.into());
            self
        }
        /// <p>The name of the database that you are deleting.</p>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relational_database_name = input;
            self
        }
        /// <p>Determines whether a final database snapshot is created before your database is deleted. If <code>true</code> is specified, no database snapshot is created. If <code>false</code> is specified, a database snapshot is created before your database is deleted.</p>
        /// <p>You must specify the <code>final relational database snapshot name</code> parameter if the <code>skip final snapshot</code> parameter is <code>false</code>.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn skip_final_snapshot(mut self, input: bool) -> Self {
            self.skip_final_snapshot = Some(input);
            self
        }
        /// <p>Determines whether a final database snapshot is created before your database is deleted. If <code>true</code> is specified, no database snapshot is created. If <code>false</code> is specified, a database snapshot is created before your database is deleted.</p>
        /// <p>You must specify the <code>final relational database snapshot name</code> parameter if the <code>skip final snapshot</code> parameter is <code>false</code>.</p>
        /// <p>Default: <code>false</code> </p>
        pub fn set_skip_final_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.skip_final_snapshot = input;
            self
        }
        /// <p>The name of the database snapshot created if <code>skip final snapshot</code> is <code>false</code>, which is the default value for that parameter.</p> <note>
        /// <p>Specifying this parameter and also specifying the <code>skip final snapshot</code> parameter to <code>true</code> results in an error.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 2 to 255 alphanumeric characters, or hyphens.</p> </li>
        /// <li> <p>The first and last character must be a letter or number.</p> </li>
        /// </ul>
        pub fn final_relational_database_snapshot_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.final_relational_database_snapshot_name = Some(input.into());
            self
        }
        /// <p>The name of the database snapshot created if <code>skip final snapshot</code> is <code>false</code>, which is the default value for that parameter.</p> <note>
        /// <p>Specifying this parameter and also specifying the <code>skip final snapshot</code> parameter to <code>true</code> results in an error.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 2 to 255 alphanumeric characters, or hyphens.</p> </li>
        /// <li> <p>The first and last character must be a letter or number.</p> </li>
        /// </ul>
        pub fn set_final_relational_database_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.final_relational_database_snapshot_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRelationalDatabaseInput`](crate::input::DeleteRelationalDatabaseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRelationalDatabaseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRelationalDatabaseInput {
                relational_database_name: self.relational_database_name,
                skip_final_snapshot: self.skip_final_snapshot,
                final_relational_database_snapshot_name: self
                    .final_relational_database_snapshot_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRelationalDatabaseInputOperationOutputAlias =
    crate::operation::DeleteRelationalDatabase;
#[doc(hidden)]
pub type DeleteRelationalDatabaseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRelationalDatabaseInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRelationalDatabase`](crate::operation::DeleteRelationalDatabase)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRelationalDatabase,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteRelationalDatabaseInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteRelationalDatabaseInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DeleteRelationalDatabase",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_relational_database(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRelationalDatabase::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRelationalDatabase",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteRelationalDatabaseInput`](crate::input::DeleteRelationalDatabaseInput)
    pub fn builder() -> crate::input::delete_relational_database_input::Builder {
        crate::input::delete_relational_database_input::Builder::default()
    }
}

/// See [`DeleteRelationalDatabaseSnapshotInput`](crate::input::DeleteRelationalDatabaseSnapshotInput)
pub mod delete_relational_database_snapshot_input {
    /// A builder for [`DeleteRelationalDatabaseSnapshotInput`](crate::input::DeleteRelationalDatabaseSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) relational_database_snapshot_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the database snapshot that you are deleting.</p>
        pub fn relational_database_snapshot_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.relational_database_snapshot_name = Some(input.into());
            self
        }
        /// <p>The name of the database snapshot that you are deleting.</p>
        pub fn set_relational_database_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relational_database_snapshot_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRelationalDatabaseSnapshotInput`](crate::input::DeleteRelationalDatabaseSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRelationalDatabaseSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRelationalDatabaseSnapshotInput {
                relational_database_snapshot_name: self.relational_database_snapshot_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRelationalDatabaseSnapshotInputOperationOutputAlias =
    crate::operation::DeleteRelationalDatabaseSnapshot;
#[doc(hidden)]
pub type DeleteRelationalDatabaseSnapshotInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteRelationalDatabaseSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRelationalDatabaseSnapshot`](crate::operation::DeleteRelationalDatabaseSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRelationalDatabaseSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteRelationalDatabaseSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteRelationalDatabaseSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DeleteRelationalDatabaseSnapshot",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_relational_database_snapshot(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRelationalDatabaseSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRelationalDatabaseSnapshot",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteRelationalDatabaseSnapshotInput`](crate::input::DeleteRelationalDatabaseSnapshotInput)
    pub fn builder() -> crate::input::delete_relational_database_snapshot_input::Builder {
        crate::input::delete_relational_database_snapshot_input::Builder::default()
    }
}

/// See [`DetachCertificateFromDistributionInput`](crate::input::DetachCertificateFromDistributionInput)
pub mod detach_certificate_from_distribution_input {
    /// A builder for [`DetachCertificateFromDistributionInput`](crate::input::DetachCertificateFromDistributionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the distribution from which to detach the certificate.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you can specify.</p>
        pub fn distribution_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.distribution_name = Some(input.into());
            self
        }
        /// <p>The name of the distribution from which to detach the certificate.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you can specify.</p>
        pub fn set_distribution_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachCertificateFromDistributionInput`](crate::input::DetachCertificateFromDistributionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetachCertificateFromDistributionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetachCertificateFromDistributionInput {
                distribution_name: self.distribution_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DetachCertificateFromDistributionInputOperationOutputAlias =
    crate::operation::DetachCertificateFromDistribution;
#[doc(hidden)]
pub type DetachCertificateFromDistributionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DetachCertificateFromDistributionInput {
    /// Consumes the builder and constructs an Operation<[`DetachCertificateFromDistribution`](crate::operation::DetachCertificateFromDistribution)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetachCertificateFromDistribution,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DetachCertificateFromDistributionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DetachCertificateFromDistributionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DetachCertificateFromDistribution",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_detach_certificate_from_distribution(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetachCertificateFromDistribution::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetachCertificateFromDistribution",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DetachCertificateFromDistributionInput`](crate::input::DetachCertificateFromDistributionInput)
    pub fn builder() -> crate::input::detach_certificate_from_distribution_input::Builder {
        crate::input::detach_certificate_from_distribution_input::Builder::default()
    }
}

/// See [`DetachDiskInput`](crate::input::DetachDiskInput)
pub mod detach_disk_input {
    /// A builder for [`DetachDiskInput`](crate::input::DetachDiskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) disk_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of the disk you want to detach from your instance (e.g., <code>my-disk</code>).</p>
        pub fn disk_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.disk_name = Some(input.into());
            self
        }
        /// <p>The unique name of the disk you want to detach from your instance (e.g., <code>my-disk</code>).</p>
        pub fn set_disk_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.disk_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachDiskInput`](crate::input::DetachDiskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetachDiskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetachDiskInput {
                disk_name: self.disk_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DetachDiskInputOperationOutputAlias = crate::operation::DetachDisk;
#[doc(hidden)]
pub type DetachDiskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DetachDiskInput {
    /// Consumes the builder and constructs an Operation<[`DetachDisk`](crate::operation::DetachDisk)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetachDisk,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DetachDiskInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DetachDiskInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DetachDisk",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_detach_disk(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetachDisk::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetachDisk",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DetachDiskInput`](crate::input::DetachDiskInput)
    pub fn builder() -> crate::input::detach_disk_input::Builder {
        crate::input::detach_disk_input::Builder::default()
    }
}

/// See [`DetachInstancesFromLoadBalancerInput`](crate::input::DetachInstancesFromLoadBalancerInput)
pub mod detach_instances_from_load_balancer_input {
    /// A builder for [`DetachInstancesFromLoadBalancerInput`](crate::input::DetachInstancesFromLoadBalancerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) instance_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the Lightsail load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the Lightsail load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// Appends an item to `instance_names`.
        ///
        /// To override the contents of this collection use [`set_instance_names`](Self::set_instance_names).
        ///
        /// <p>An array of strings containing the names of the instances you want to detach from the load balancer.</p>
        pub fn instance_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.instance_names.unwrap_or_default();
            v.push(input.into());
            self.instance_names = Some(v);
            self
        }
        /// <p>An array of strings containing the names of the instances you want to detach from the load balancer.</p>
        pub fn set_instance_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.instance_names = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachInstancesFromLoadBalancerInput`](crate::input::DetachInstancesFromLoadBalancerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetachInstancesFromLoadBalancerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetachInstancesFromLoadBalancerInput {
                load_balancer_name: self.load_balancer_name,
                instance_names: self.instance_names,
            })
        }
    }
}
#[doc(hidden)]
pub type DetachInstancesFromLoadBalancerInputOperationOutputAlias =
    crate::operation::DetachInstancesFromLoadBalancer;
#[doc(hidden)]
pub type DetachInstancesFromLoadBalancerInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DetachInstancesFromLoadBalancerInput {
    /// Consumes the builder and constructs an Operation<[`DetachInstancesFromLoadBalancer`](crate::operation::DetachInstancesFromLoadBalancer)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetachInstancesFromLoadBalancer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DetachInstancesFromLoadBalancerInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DetachInstancesFromLoadBalancerInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DetachInstancesFromLoadBalancer",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_detach_instances_from_load_balancer(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetachInstancesFromLoadBalancer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetachInstancesFromLoadBalancer",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DetachInstancesFromLoadBalancerInput`](crate::input::DetachInstancesFromLoadBalancerInput)
    pub fn builder() -> crate::input::detach_instances_from_load_balancer_input::Builder {
        crate::input::detach_instances_from_load_balancer_input::Builder::default()
    }
}

/// See [`DetachStaticIpInput`](crate::input::DetachStaticIpInput)
pub mod detach_static_ip_input {
    /// A builder for [`DetachStaticIpInput`](crate::input::DetachStaticIpInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) static_ip_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the static IP to detach from the instance.</p>
        pub fn static_ip_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.static_ip_name = Some(input.into());
            self
        }
        /// <p>The name of the static IP to detach from the instance.</p>
        pub fn set_static_ip_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.static_ip_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DetachStaticIpInput`](crate::input::DetachStaticIpInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetachStaticIpInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetachStaticIpInput {
                static_ip_name: self.static_ip_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DetachStaticIpInputOperationOutputAlias = crate::operation::DetachStaticIp;
#[doc(hidden)]
pub type DetachStaticIpInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DetachStaticIpInput {
    /// Consumes the builder and constructs an Operation<[`DetachStaticIp`](crate::operation::DetachStaticIp)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetachStaticIp,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DetachStaticIpInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DetachStaticIpInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DetachStaticIp",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_detach_static_ip(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetachStaticIp::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetachStaticIp",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DetachStaticIpInput`](crate::input::DetachStaticIpInput)
    pub fn builder() -> crate::input::detach_static_ip_input::Builder {
        crate::input::detach_static_ip_input::Builder::default()
    }
}

/// See [`DisableAddOnInput`](crate::input::DisableAddOnInput)
pub mod disable_add_on_input {
    /// A builder for [`DisableAddOnInput`](crate::input::DisableAddOnInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) add_on_type: std::option::Option<crate::model::AddOnType>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The add-on type to disable.</p>
        pub fn add_on_type(mut self, input: crate::model::AddOnType) -> Self {
            self.add_on_type = Some(input);
            self
        }
        /// <p>The add-on type to disable.</p>
        pub fn set_add_on_type(
            mut self,
            input: std::option::Option<crate::model::AddOnType>,
        ) -> Self {
            self.add_on_type = input;
            self
        }
        /// <p>The name of the source resource for which to disable the add-on.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of the source resource for which to disable the add-on.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableAddOnInput`](crate::input::DisableAddOnInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableAddOnInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableAddOnInput {
                add_on_type: self.add_on_type,
                resource_name: self.resource_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableAddOnInputOperationOutputAlias = crate::operation::DisableAddOn;
#[doc(hidden)]
pub type DisableAddOnInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisableAddOnInput {
    /// Consumes the builder and constructs an Operation<[`DisableAddOn`](crate::operation::DisableAddOn)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableAddOn,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DisableAddOnInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DisableAddOnInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DisableAddOn",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_disable_add_on(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableAddOn::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableAddOn",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DisableAddOnInput`](crate::input::DisableAddOnInput)
    pub fn builder() -> crate::input::disable_add_on_input::Builder {
        crate::input::disable_add_on_input::Builder::default()
    }
}

/// See [`DownloadDefaultKeyPairInput`](crate::input::DownloadDefaultKeyPairInput)
pub mod download_default_key_pair_input {
    /// A builder for [`DownloadDefaultKeyPairInput`](crate::input::DownloadDefaultKeyPairInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DownloadDefaultKeyPairInput`](crate::input::DownloadDefaultKeyPairInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DownloadDefaultKeyPairInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DownloadDefaultKeyPairInput {})
        }
    }
}
#[doc(hidden)]
pub type DownloadDefaultKeyPairInputOperationOutputAlias = crate::operation::DownloadDefaultKeyPair;
#[doc(hidden)]
pub type DownloadDefaultKeyPairInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DownloadDefaultKeyPairInput {
    /// Consumes the builder and constructs an Operation<[`DownloadDefaultKeyPair`](crate::operation::DownloadDefaultKeyPair)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DownloadDefaultKeyPair,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DownloadDefaultKeyPairInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DownloadDefaultKeyPairInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.DownloadDefaultKeyPair",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_download_default_key_pair(
                &self,
            )?,
        );
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DownloadDefaultKeyPair::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DownloadDefaultKeyPair",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DownloadDefaultKeyPairInput`](crate::input::DownloadDefaultKeyPairInput)
    pub fn builder() -> crate::input::download_default_key_pair_input::Builder {
        crate::input::download_default_key_pair_input::Builder::default()
    }
}

/// See [`EnableAddOnInput`](crate::input::EnableAddOnInput)
pub mod enable_add_on_input {
    /// A builder for [`EnableAddOnInput`](crate::input::EnableAddOnInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) add_on_request: std::option::Option<crate::model::AddOnRequest>,
    }
    impl Builder {
        /// <p>The name of the source resource for which to enable or modify the add-on.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of the source resource for which to enable or modify the add-on.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// <p>An array of strings representing the add-on to enable or modify.</p>
        pub fn add_on_request(mut self, input: crate::model::AddOnRequest) -> Self {
            self.add_on_request = Some(input);
            self
        }
        /// <p>An array of strings representing the add-on to enable or modify.</p>
        pub fn set_add_on_request(
            mut self,
            input: std::option::Option<crate::model::AddOnRequest>,
        ) -> Self {
            self.add_on_request = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableAddOnInput`](crate::input::EnableAddOnInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableAddOnInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableAddOnInput {
                resource_name: self.resource_name,
                add_on_request: self.add_on_request,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableAddOnInputOperationOutputAlias = crate::operation::EnableAddOn;
#[doc(hidden)]
pub type EnableAddOnInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl EnableAddOnInput {
    /// Consumes the builder and constructs an Operation<[`EnableAddOn`](crate::operation::EnableAddOn)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableAddOn,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::EnableAddOnInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::EnableAddOnInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.EnableAddOn",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_enable_add_on(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableAddOn::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableAddOn",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`EnableAddOnInput`](crate::input::EnableAddOnInput)
    pub fn builder() -> crate::input::enable_add_on_input::Builder {
        crate::input::enable_add_on_input::Builder::default()
    }
}

/// See [`ExportSnapshotInput`](crate::input::ExportSnapshotInput)
pub mod export_snapshot_input {
    /// A builder for [`ExportSnapshotInput`](crate::input::ExportSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_snapshot_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the instance or disk snapshot to be exported to Amazon EC2.</p>
        pub fn source_snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_snapshot_name = Some(input.into());
            self
        }
        /// <p>The name of the instance or disk snapshot to be exported to Amazon EC2.</p>
        pub fn set_source_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_snapshot_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportSnapshotInput`](crate::input::ExportSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExportSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExportSnapshotInput {
                source_snapshot_name: self.source_snapshot_name,
            })
        }
    }
}
#[doc(hidden)]
pub type ExportSnapshotInputOperationOutputAlias = crate::operation::ExportSnapshot;
#[doc(hidden)]
pub type ExportSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ExportSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`ExportSnapshot`](crate::operation::ExportSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExportSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ExportSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ExportSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.ExportSnapshot",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_export_snapshot(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExportSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExportSnapshot",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ExportSnapshotInput`](crate::input::ExportSnapshotInput)
    pub fn builder() -> crate::input::export_snapshot_input::Builder {
        crate::input::export_snapshot_input::Builder::default()
    }
}

/// See [`GetActiveNamesInput`](crate::input::GetActiveNamesInput)
pub mod get_active_names_input {
    /// A builder for [`GetActiveNamesInput`](crate::input::GetActiveNamesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetActiveNames</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetActiveNames</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetActiveNamesInput`](crate::input::GetActiveNamesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetActiveNamesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetActiveNamesInput {
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetActiveNamesInputOperationOutputAlias = crate::operation::GetActiveNames;
#[doc(hidden)]
pub type GetActiveNamesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetActiveNamesInput {
    /// Consumes the builder and constructs an Operation<[`GetActiveNames`](crate::operation::GetActiveNames)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetActiveNames,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetActiveNamesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetActiveNamesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetActiveNames",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_active_names(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetActiveNames::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetActiveNames",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetActiveNamesInput`](crate::input::GetActiveNamesInput)
    pub fn builder() -> crate::input::get_active_names_input::Builder {
        crate::input::get_active_names_input::Builder::default()
    }
}

/// See [`GetAlarmsInput`](crate::input::GetAlarmsInput)
pub mod get_alarms_input {
    /// A builder for [`GetAlarmsInput`](crate::input::GetAlarmsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) alarm_name: std::option::Option<std::string::String>,
        pub(crate) page_token: std::option::Option<std::string::String>,
        pub(crate) monitored_resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the alarm.</p>
        /// <p>Specify an alarm name to return information about a specific alarm.</p>
        pub fn alarm_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.alarm_name = Some(input.into());
            self
        }
        /// <p>The name of the alarm.</p>
        /// <p>Specify an alarm name to return information about a specific alarm.</p>
        pub fn set_alarm_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.alarm_name = input;
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetAlarms</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetAlarms</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// <p>The name of the Lightsail resource being monitored by the alarm.</p>
        /// <p>Specify a monitored resource name to return information about all alarms for a specific resource.</p>
        pub fn monitored_resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitored_resource_name = Some(input.into());
            self
        }
        /// <p>The name of the Lightsail resource being monitored by the alarm.</p>
        /// <p>Specify a monitored resource name to return information about all alarms for a specific resource.</p>
        pub fn set_monitored_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monitored_resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAlarmsInput`](crate::input::GetAlarmsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetAlarmsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetAlarmsInput {
                alarm_name: self.alarm_name,
                page_token: self.page_token,
                monitored_resource_name: self.monitored_resource_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAlarmsInputOperationOutputAlias = crate::operation::GetAlarms;
#[doc(hidden)]
pub type GetAlarmsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAlarmsInput {
    /// Consumes the builder and constructs an Operation<[`GetAlarms`](crate::operation::GetAlarms)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAlarms,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetAlarmsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetAlarmsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetAlarms",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_alarms(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetAlarms::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetAlarms",
                    "lightsail",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetAlarmsInput`](crate::input::GetAlarmsInput)
    pub fn builder() -> crate::input::get_alarms_input::Builder {
        crate::input::get_alarms_input::Builder::default()
    }
}

/// See [`GetAutoSnapshotsInput`](crate::input::GetAutoSnapshotsInput)
pub mod get_auto_snapshots_input {
    /// A builder for [`GetAutoSnapshotsInput`](crate::input::GetAutoSnapshotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the source instance or disk from which to get automatic snapshot information.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of the source instance or disk from which to get automatic snapshot information.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAutoSnapshotsInput`](crate::input::GetAutoSnapshotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAutoSnapshotsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAutoSnapshotsInput {
                resource_name: self.resource_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAutoSnapshotsInputOperationOutputAlias = crate::operation::GetAutoSnapshots;
#[doc(hidden)]
pub type GetAutoSnapshotsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAutoSnapshotsInput {
    /// Consumes the builder and constructs an Operation<[`GetAutoSnapshots`](crate::operation::GetAutoSnapshots)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAutoSnapshots,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetAutoSnapshotsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetAutoSnapshotsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetAutoSnapshots",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_auto_snapshots(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAutoSnapshots::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAutoSnapshots",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetAutoSnapshotsInput`](crate::input::GetAutoSnapshotsInput)
    pub fn builder() -> crate::input::get_auto_snapshots_input::Builder {
        crate::input::get_auto_snapshots_input::Builder::default()
    }
}

/// See [`GetBlueprintsInput`](crate::input::GetBlueprintsInput)
pub mod get_blueprints_input {
    /// A builder for [`GetBlueprintsInput`](crate::input::GetBlueprintsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) include_inactive: std::option::Option<bool>,
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A Boolean value indicating whether to include inactive results in your request.</p>
        pub fn include_inactive(mut self, input: bool) -> Self {
            self.include_inactive = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether to include inactive results in your request.</p>
        pub fn set_include_inactive(mut self, input: std::option::Option<bool>) -> Self {
            self.include_inactive = input;
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetBlueprints</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetBlueprints</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBlueprintsInput`](crate::input::GetBlueprintsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBlueprintsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBlueprintsInput {
                include_inactive: self.include_inactive,
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBlueprintsInputOperationOutputAlias = crate::operation::GetBlueprints;
#[doc(hidden)]
pub type GetBlueprintsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBlueprintsInput {
    /// Consumes the builder and constructs an Operation<[`GetBlueprints`](crate::operation::GetBlueprints)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBlueprints,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBlueprintsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBlueprintsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetBlueprints",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_blueprints(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBlueprints::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBlueprints",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBlueprintsInput`](crate::input::GetBlueprintsInput)
    pub fn builder() -> crate::input::get_blueprints_input::Builder {
        crate::input::get_blueprints_input::Builder::default()
    }
}

/// See [`GetBucketAccessKeysInput`](crate::input::GetBucketAccessKeysInput)
pub mod get_bucket_access_keys_input {
    /// A builder for [`GetBucketAccessKeysInput`](crate::input::GetBucketAccessKeysInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket for which to return access keys.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which to return access keys.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketAccessKeysInput`](crate::input::GetBucketAccessKeysInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketAccessKeysInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketAccessKeysInput {
                bucket_name: self.bucket_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketAccessKeysInputOperationOutputAlias = crate::operation::GetBucketAccessKeys;
#[doc(hidden)]
pub type GetBucketAccessKeysInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketAccessKeysInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketAccessKeys`](crate::operation::GetBucketAccessKeys)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketAccessKeys,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketAccessKeysInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketAccessKeysInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetBucketAccessKeys",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_bucket_access_keys(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketAccessKeys::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketAccessKeys",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketAccessKeysInput`](crate::input::GetBucketAccessKeysInput)
    pub fn builder() -> crate::input::get_bucket_access_keys_input::Builder {
        crate::input::get_bucket_access_keys_input::Builder::default()
    }
}

/// See [`GetBucketBundlesInput`](crate::input::GetBucketBundlesInput)
pub mod get_bucket_bundles_input {
    /// A builder for [`GetBucketBundlesInput`](crate::input::GetBucketBundlesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) include_inactive: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A Boolean value that indicates whether to include inactive (unavailable) bundles in the response.</p>
        pub fn include_inactive(mut self, input: bool) -> Self {
            self.include_inactive = Some(input);
            self
        }
        /// <p>A Boolean value that indicates whether to include inactive (unavailable) bundles in the response.</p>
        pub fn set_include_inactive(mut self, input: std::option::Option<bool>) -> Self {
            self.include_inactive = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketBundlesInput`](crate::input::GetBucketBundlesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketBundlesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketBundlesInput {
                include_inactive: self.include_inactive,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketBundlesInputOperationOutputAlias = crate::operation::GetBucketBundles;
#[doc(hidden)]
pub type GetBucketBundlesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketBundlesInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketBundles`](crate::operation::GetBucketBundles)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketBundles,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketBundlesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketBundlesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetBucketBundles",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_bucket_bundles(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketBundles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketBundles",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketBundlesInput`](crate::input::GetBucketBundlesInput)
    pub fn builder() -> crate::input::get_bucket_bundles_input::Builder {
        crate::input::get_bucket_bundles_input::Builder::default()
    }
}

/// See [`GetBucketMetricDataInput`](crate::input::GetBucketMetricDataInput)
pub mod get_bucket_metric_data_input {
    /// A builder for [`GetBucketMetricDataInput`](crate::input::GetBucketMetricDataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) metric_name: std::option::Option<crate::model::BucketMetricName>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) period: std::option::Option<i32>,
        pub(crate) statistics: std::option::Option<std::vec::Vec<crate::model::MetricStatistic>>,
        pub(crate) unit: std::option::Option<crate::model::MetricUnit>,
    }
    impl Builder {
        /// <p>The name of the bucket for which to get metric data.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which to get metric data.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The metric for which you want to return information.</p>
        /// <p>Valid bucket metric names are listed below, along with the most useful statistics to include in your request, and the published unit value.</p> <note>
        /// <p>These bucket metrics are reported once per day.</p>
        /// </note>
        /// <ul>
        /// <li> <p> <b> <code>BucketSizeBytes</code> </b> - The amount of data in bytes stored in a bucket. This value is calculated by summing the size of all objects in the bucket (including object versions), including the size of all parts for all incomplete multipart uploads to the bucket.</p> <p>Statistics: The most useful statistic is <code>Maximum</code>.</p> <p>Unit: The published unit is <code>Bytes</code>.</p> </li>
        /// <li> <p> <b> <code>NumberOfObjects</code> </b> - The total number of objects stored in a bucket. This value is calculated by counting all objects in the bucket (including object versions) and the total number of parts for all incomplete multipart uploads to the bucket.</p> <p>Statistics: The most useful statistic is <code>Average</code>.</p> <p>Unit: The published unit is <code>Count</code>.</p> </li>
        /// </ul>
        pub fn metric_name(mut self, input: crate::model::BucketMetricName) -> Self {
            self.metric_name = Some(input);
            self
        }
        /// <p>The metric for which you want to return information.</p>
        /// <p>Valid bucket metric names are listed below, along with the most useful statistics to include in your request, and the published unit value.</p> <note>
        /// <p>These bucket metrics are reported once per day.</p>
        /// </note>
        /// <ul>
        /// <li> <p> <b> <code>BucketSizeBytes</code> </b> - The amount of data in bytes stored in a bucket. This value is calculated by summing the size of all objects in the bucket (including object versions), including the size of all parts for all incomplete multipart uploads to the bucket.</p> <p>Statistics: The most useful statistic is <code>Maximum</code>.</p> <p>Unit: The published unit is <code>Bytes</code>.</p> </li>
        /// <li> <p> <b> <code>NumberOfObjects</code> </b> - The total number of objects stored in a bucket. This value is calculated by counting all objects in the bucket (including object versions) and the total number of parts for all incomplete multipart uploads to the bucket.</p> <p>Statistics: The most useful statistic is <code>Average</code>.</p> <p>Unit: The published unit is <code>Count</code>.</p> </li>
        /// </ul>
        pub fn set_metric_name(
            mut self,
            input: std::option::Option<crate::model::BucketMetricName>,
        ) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The timestamp indicating the earliest data to be returned.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The timestamp indicating the earliest data to be returned.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The timestamp indicating the latest data to be returned.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The timestamp indicating the latest data to be returned.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The granularity, in seconds, of the returned data points.</p> <note>
        /// <p>Bucket storage metrics are reported once per day. Therefore, you should specify a period of 86400 seconds, which is the number of seconds in a day.</p>
        /// </note>
        pub fn period(mut self, input: i32) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>The granularity, in seconds, of the returned data points.</p> <note>
        /// <p>Bucket storage metrics are reported once per day. Therefore, you should specify a period of 86400 seconds, which is the number of seconds in a day.</p>
        /// </note>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.period = input;
            self
        }
        /// Appends an item to `statistics`.
        ///
        /// To override the contents of this collection use [`set_statistics`](Self::set_statistics).
        ///
        /// <p>The statistic for the metric.</p>
        /// <p>The following statistics are available:</p>
        /// <ul>
        /// <li> <p> <code>Minimum</code> - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Maximum</code> - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Sum</code> - The sum of all values submitted for the matching metric. You can use this statistic to determine the total volume of a metric.</p> </li>
        /// <li> <p> <code>Average</code> - The value of <code>Sum</code> / <code>SampleCount</code> during the specified period. By comparing this statistic with the <code>Minimum</code> and <code>Maximum</code> values, you can determine the full scope of a metric and how close the average use is to the <code>Minimum</code> and <code>Maximum</code> values. This comparison helps you to know when to increase or decrease your resources.</p> </li>
        /// <li> <p> <code>SampleCount</code> - The count, or number, of data points used for the statistical calculation.</p> </li>
        /// </ul>
        pub fn statistics(mut self, input: crate::model::MetricStatistic) -> Self {
            let mut v = self.statistics.unwrap_or_default();
            v.push(input);
            self.statistics = Some(v);
            self
        }
        /// <p>The statistic for the metric.</p>
        /// <p>The following statistics are available:</p>
        /// <ul>
        /// <li> <p> <code>Minimum</code> - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Maximum</code> - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Sum</code> - The sum of all values submitted for the matching metric. You can use this statistic to determine the total volume of a metric.</p> </li>
        /// <li> <p> <code>Average</code> - The value of <code>Sum</code> / <code>SampleCount</code> during the specified period. By comparing this statistic with the <code>Minimum</code> and <code>Maximum</code> values, you can determine the full scope of a metric and how close the average use is to the <code>Minimum</code> and <code>Maximum</code> values. This comparison helps you to know when to increase or decrease your resources.</p> </li>
        /// <li> <p> <code>SampleCount</code> - The count, or number, of data points used for the statistical calculation.</p> </li>
        /// </ul>
        pub fn set_statistics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricStatistic>>,
        ) -> Self {
            self.statistics = input;
            self
        }
        /// <p>The unit for the metric data request.</p>
        /// <p>Valid units depend on the metric data being requested. For the valid units with each available metric, see the <code>metricName</code> parameter.</p>
        pub fn unit(mut self, input: crate::model::MetricUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>The unit for the metric data request.</p>
        /// <p>Valid units depend on the metric data being requested. For the valid units with each available metric, see the <code>metricName</code> parameter.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::MetricUnit>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketMetricDataInput`](crate::input::GetBucketMetricDataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketMetricDataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketMetricDataInput {
                bucket_name: self.bucket_name,
                metric_name: self.metric_name,
                start_time: self.start_time,
                end_time: self.end_time,
                period: self.period.unwrap_or_default(),
                statistics: self.statistics,
                unit: self.unit,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketMetricDataInputOperationOutputAlias = crate::operation::GetBucketMetricData;
#[doc(hidden)]
pub type GetBucketMetricDataInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketMetricDataInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketMetricData`](crate::operation::GetBucketMetricData)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketMetricData,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketMetricDataInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketMetricDataInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetBucketMetricData",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_bucket_metric_data(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketMetricData::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketMetricData",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketMetricDataInput`](crate::input::GetBucketMetricDataInput)
    pub fn builder() -> crate::input::get_bucket_metric_data_input::Builder {
        crate::input::get_bucket_metric_data_input::Builder::default()
    }
}

/// See [`GetBucketsInput`](crate::input::GetBucketsInput)
pub mod get_buckets_input {
    /// A builder for [`GetBucketsInput`](crate::input::GetBucketsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) page_token: std::option::Option<std::string::String>,
        pub(crate) include_connected_resources: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the bucket for which to return information.</p>
        /// <p>When omitted, the response includes all of your buckets in the AWS Region where the request is made.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the bucket for which to return information.</p>
        /// <p>When omitted, the response includes all of your buckets in the AWS Region where the request is made.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetBuckets</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetBuckets</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// <p>A Boolean value that indicates whether to include Lightsail instances that were given access to the bucket using the <a href="https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_SetResourceAccessForBucket.html">SetResourceAccessForBucket</a> action.</p>
        pub fn include_connected_resources(mut self, input: bool) -> Self {
            self.include_connected_resources = Some(input);
            self
        }
        /// <p>A Boolean value that indicates whether to include Lightsail instances that were given access to the bucket using the <a href="https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_SetResourceAccessForBucket.html">SetResourceAccessForBucket</a> action.</p>
        pub fn set_include_connected_resources(mut self, input: std::option::Option<bool>) -> Self {
            self.include_connected_resources = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketsInput`](crate::input::GetBucketsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketsInput {
                bucket_name: self.bucket_name,
                page_token: self.page_token,
                include_connected_resources: self.include_connected_resources,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketsInputOperationOutputAlias = crate::operation::GetBuckets;
#[doc(hidden)]
pub type GetBucketsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBucketsInput {
    /// Consumes the builder and constructs an Operation<[`GetBuckets`](crate::operation::GetBuckets)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBuckets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBucketsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBucketsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetBuckets",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_buckets(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBuckets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBuckets",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBucketsInput`](crate::input::GetBucketsInput)
    pub fn builder() -> crate::input::get_buckets_input::Builder {
        crate::input::get_buckets_input::Builder::default()
    }
}

/// See [`GetBundlesInput`](crate::input::GetBundlesInput)
pub mod get_bundles_input {
    /// A builder for [`GetBundlesInput`](crate::input::GetBundlesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) include_inactive: std::option::Option<bool>,
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A Boolean value that indicates whether to include inactive bundle results in your request.</p>
        pub fn include_inactive(mut self, input: bool) -> Self {
            self.include_inactive = Some(input);
            self
        }
        /// <p>A Boolean value that indicates whether to include inactive bundle results in your request.</p>
        pub fn set_include_inactive(mut self, input: std::option::Option<bool>) -> Self {
            self.include_inactive = input;
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetBundles</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetBundles</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBundlesInput`](crate::input::GetBundlesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBundlesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBundlesInput {
                include_inactive: self.include_inactive,
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBundlesInputOperationOutputAlias = crate::operation::GetBundles;
#[doc(hidden)]
pub type GetBundlesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetBundlesInput {
    /// Consumes the builder and constructs an Operation<[`GetBundles`](crate::operation::GetBundles)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBundles,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetBundlesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetBundlesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetBundles",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_bundles(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBundles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBundles",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetBundlesInput`](crate::input::GetBundlesInput)
    pub fn builder() -> crate::input::get_bundles_input::Builder {
        crate::input::get_bundles_input::Builder::default()
    }
}

/// See [`GetCertificatesInput`](crate::input::GetCertificatesInput)
pub mod get_certificates_input {
    /// A builder for [`GetCertificatesInput`](crate::input::GetCertificatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_statuses:
            std::option::Option<std::vec::Vec<crate::model::CertificateStatus>>,
        pub(crate) include_certificate_details: std::option::Option<bool>,
        pub(crate) certificate_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `certificate_statuses`.
        ///
        /// To override the contents of this collection use [`set_certificate_statuses`](Self::set_certificate_statuses).
        ///
        /// <p>The status of the certificates for which to return information.</p>
        /// <p>For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code> status.</p>
        /// <p>When omitted, the response includes all of your certificates in the AWS Region where the request is made, regardless of their current status.</p>
        pub fn certificate_statuses(mut self, input: crate::model::CertificateStatus) -> Self {
            let mut v = self.certificate_statuses.unwrap_or_default();
            v.push(input);
            self.certificate_statuses = Some(v);
            self
        }
        /// <p>The status of the certificates for which to return information.</p>
        /// <p>For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code> status.</p>
        /// <p>When omitted, the response includes all of your certificates in the AWS Region where the request is made, regardless of their current status.</p>
        pub fn set_certificate_statuses(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CertificateStatus>>,
        ) -> Self {
            self.certificate_statuses = input;
            self
        }
        /// <p>Indicates whether to include detailed information about the certificates in the response.</p>
        /// <p>When omitted, the response includes only the certificate names, Amazon Resource Names (ARNs), domain names, and tags.</p>
        pub fn include_certificate_details(mut self, input: bool) -> Self {
            self.include_certificate_details = Some(input);
            self
        }
        /// <p>Indicates whether to include detailed information about the certificates in the response.</p>
        /// <p>When omitted, the response includes only the certificate names, Amazon Resource Names (ARNs), domain names, and tags.</p>
        pub fn set_include_certificate_details(mut self, input: std::option::Option<bool>) -> Self {
            self.include_certificate_details = input;
            self
        }
        /// <p>The name for the certificate for which to return information.</p>
        /// <p>When omitted, the response includes all of your certificates in the AWS Region where the request is made.</p>
        pub fn certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_name = Some(input.into());
            self
        }
        /// <p>The name for the certificate for which to return information.</p>
        /// <p>When omitted, the response includes all of your certificates in the AWS Region where the request is made.</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCertificatesInput`](crate::input::GetCertificatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCertificatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCertificatesInput {
                certificate_statuses: self.certificate_statuses,
                include_certificate_details: self.include_certificate_details.unwrap_or_default(),
                certificate_name: self.certificate_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCertificatesInputOperationOutputAlias = crate::operation::GetCertificates;
#[doc(hidden)]
pub type GetCertificatesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCertificatesInput {
    /// Consumes the builder and constructs an Operation<[`GetCertificates`](crate::operation::GetCertificates)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCertificates,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetCertificatesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetCertificatesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetCertificates",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_certificates(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCertificates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCertificates",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetCertificatesInput`](crate::input::GetCertificatesInput)
    pub fn builder() -> crate::input::get_certificates_input::Builder {
        crate::input::get_certificates_input::Builder::default()
    }
}

/// See [`GetCloudFormationStackRecordsInput`](crate::input::GetCloudFormationStackRecordsInput)
pub mod get_cloud_formation_stack_records_input {
    /// A builder for [`GetCloudFormationStackRecordsInput`](crate::input::GetCloudFormationStackRecordsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetClouFormationStackRecords</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetClouFormationStackRecords</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCloudFormationStackRecordsInput`](crate::input::GetCloudFormationStackRecordsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCloudFormationStackRecordsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCloudFormationStackRecordsInput {
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCloudFormationStackRecordsInputOperationOutputAlias =
    crate::operation::GetCloudFormationStackRecords;
#[doc(hidden)]
pub type GetCloudFormationStackRecordsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetCloudFormationStackRecordsInput {
    /// Consumes the builder and constructs an Operation<[`GetCloudFormationStackRecords`](crate::operation::GetCloudFormationStackRecords)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCloudFormationStackRecords,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetCloudFormationStackRecordsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetCloudFormationStackRecordsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetCloudFormationStackRecords",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_cloud_formation_stack_records(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCloudFormationStackRecords::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCloudFormationStackRecords",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetCloudFormationStackRecordsInput`](crate::input::GetCloudFormationStackRecordsInput)
    pub fn builder() -> crate::input::get_cloud_formation_stack_records_input::Builder {
        crate::input::get_cloud_formation_stack_records_input::Builder::default()
    }
}

/// See [`GetContactMethodsInput`](crate::input::GetContactMethodsInput)
pub mod get_contact_methods_input {
    /// A builder for [`GetContactMethodsInput`](crate::input::GetContactMethodsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) protocols: std::option::Option<std::vec::Vec<crate::model::ContactProtocol>>,
    }
    impl Builder {
        /// Appends an item to `protocols`.
        ///
        /// To override the contents of this collection use [`set_protocols`](Self::set_protocols).
        ///
        /// <p>The protocols used to send notifications, such as <code>Email</code>, or <code>SMS</code> (text messaging).</p>
        /// <p>Specify a protocol in your request to return information about a specific contact method protocol.</p>
        pub fn protocols(mut self, input: crate::model::ContactProtocol) -> Self {
            let mut v = self.protocols.unwrap_or_default();
            v.push(input);
            self.protocols = Some(v);
            self
        }
        /// <p>The protocols used to send notifications, such as <code>Email</code>, or <code>SMS</code> (text messaging).</p>
        /// <p>Specify a protocol in your request to return information about a specific contact method protocol.</p>
        pub fn set_protocols(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContactProtocol>>,
        ) -> Self {
            self.protocols = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContactMethodsInput`](crate::input::GetContactMethodsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetContactMethodsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetContactMethodsInput {
                protocols: self.protocols,
            })
        }
    }
}
#[doc(hidden)]
pub type GetContactMethodsInputOperationOutputAlias = crate::operation::GetContactMethods;
#[doc(hidden)]
pub type GetContactMethodsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetContactMethodsInput {
    /// Consumes the builder and constructs an Operation<[`GetContactMethods`](crate::operation::GetContactMethods)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetContactMethods,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetContactMethodsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetContactMethodsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetContactMethods",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_contact_methods(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetContactMethods::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetContactMethods",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetContactMethodsInput`](crate::input::GetContactMethodsInput)
    pub fn builder() -> crate::input::get_contact_methods_input::Builder {
        crate::input::get_contact_methods_input::Builder::default()
    }
}

/// See [`GetContainerApiMetadataInput`](crate::input::GetContainerApiMetadataInput)
pub mod get_container_api_metadata_input {
    /// A builder for [`GetContainerApiMetadataInput`](crate::input::GetContainerApiMetadataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetContainerApiMetadataInput`](crate::input::GetContainerApiMetadataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetContainerApiMetadataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetContainerApiMetadataInput {})
        }
    }
}
#[doc(hidden)]
pub type GetContainerApiMetadataInputOperationOutputAlias =
    crate::operation::GetContainerAPIMetadata;
#[doc(hidden)]
pub type GetContainerApiMetadataInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetContainerApiMetadataInput {
    /// Consumes the builder and constructs an Operation<[`GetContainerAPIMetadata`](crate::operation::GetContainerAPIMetadata)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetContainerAPIMetadata,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetContainerApiMetadataInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetContainerApiMetadataInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetContainerAPIMetadata",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_container_api_metadata(
                &self,
            )?,
        );
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetContainerAPIMetadata::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetContainerAPIMetadata",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetContainerApiMetadataInput`](crate::input::GetContainerApiMetadataInput)
    pub fn builder() -> crate::input::get_container_api_metadata_input::Builder {
        crate::input::get_container_api_metadata_input::Builder::default()
    }
}

/// See [`GetContainerImagesInput`](crate::input::GetContainerImagesInput)
pub mod get_container_images_input {
    /// A builder for [`GetContainerImagesInput`](crate::input::GetContainerImagesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the container service for which to return registered container images.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the container service for which to return registered container images.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContainerImagesInput`](crate::input::GetContainerImagesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetContainerImagesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetContainerImagesInput {
                service_name: self.service_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetContainerImagesInputOperationOutputAlias = crate::operation::GetContainerImages;
#[doc(hidden)]
pub type GetContainerImagesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetContainerImagesInput {
    /// Consumes the builder and constructs an Operation<[`GetContainerImages`](crate::operation::GetContainerImages)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetContainerImages,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetContainerImagesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetContainerImagesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetContainerImages",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_container_images(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetContainerImages::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetContainerImages",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetContainerImagesInput`](crate::input::GetContainerImagesInput)
    pub fn builder() -> crate::input::get_container_images_input::Builder {
        crate::input::get_container_images_input::Builder::default()
    }
}

/// See [`GetContainerLogInput`](crate::input::GetContainerLogInput)
pub mod get_container_log_input {
    /// A builder for [`GetContainerLogInput`](crate::input::GetContainerLogInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) container_name: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) filter_pattern: std::option::Option<std::string::String>,
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the container service for which to get a container log.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the container service for which to get a container log.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>The name of the container that is either running or previously ran on the container service for which to return a log.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_name = Some(input.into());
            self
        }
        /// <p>The name of the container that is either running or previously ran on the container service for which to return a log.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_name = input;
            self
        }
        /// <p>The start of the time interval for which to get log data.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Specified in Coordinated Universal Time (UTC).</p> </li>
        /// <li> <p>Specified in the Unix time format.</p> <p>For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, specify <code>1538424000</code> as the start time.</p> </li>
        /// </ul>
        /// <p>You can convert a human-friendly time to Unix time format using a converter like <a href="https://www.epochconverter.com/">Epoch converter</a>.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start of the time interval for which to get log data.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Specified in Coordinated Universal Time (UTC).</p> </li>
        /// <li> <p>Specified in the Unix time format.</p> <p>For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, specify <code>1538424000</code> as the start time.</p> </li>
        /// </ul>
        /// <p>You can convert a human-friendly time to Unix time format using a converter like <a href="https://www.epochconverter.com/">Epoch converter</a>.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end of the time interval for which to get log data.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Specified in Coordinated Universal Time (UTC).</p> </li>
        /// <li> <p>Specified in the Unix time format.</p> <p>For example, if you wish to use an end time of October 1, 2018, at 9 PM UTC, specify <code>1538427600</code> as the end time.</p> </li>
        /// </ul>
        /// <p>You can convert a human-friendly time to Unix time format using a converter like <a href="https://www.epochconverter.com/">Epoch converter</a>.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end of the time interval for which to get log data.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Specified in Coordinated Universal Time (UTC).</p> </li>
        /// <li> <p>Specified in the Unix time format.</p> <p>For example, if you wish to use an end time of October 1, 2018, at 9 PM UTC, specify <code>1538427600</code> as the end time.</p> </li>
        /// </ul>
        /// <p>You can convert a human-friendly time to Unix time format using a converter like <a href="https://www.epochconverter.com/">Epoch converter</a>.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The pattern to use to filter the returned log events to a specific term.</p>
        /// <p>The following are a few examples of filter patterns that you can specify:</p>
        /// <ul>
        /// <li> <p>To return all log events, specify a filter pattern of <code>""</code>.</p> </li>
        /// <li> <p>To exclude log events that contain the <code>ERROR</code> term, and return all other log events, specify a filter pattern of <code>"-ERROR"</code>.</p> </li>
        /// <li> <p>To return log events that contain the <code>ERROR</code> term, specify a filter pattern of <code>"ERROR"</code>.</p> </li>
        /// <li> <p>To return log events that contain both the <code>ERROR</code> and <code>Exception</code> terms, specify a filter pattern of <code>"ERROR Exception"</code>.</p> </li>
        /// <li> <p>To return log events that contain the <code>ERROR</code> <i>or</i> the <code>Exception</code> term, specify a filter pattern of <code>"?ERROR ?Exception"</code>.</p> </li>
        /// </ul>
        pub fn filter_pattern(mut self, input: impl Into<std::string::String>) -> Self {
            self.filter_pattern = Some(input.into());
            self
        }
        /// <p>The pattern to use to filter the returned log events to a specific term.</p>
        /// <p>The following are a few examples of filter patterns that you can specify:</p>
        /// <ul>
        /// <li> <p>To return all log events, specify a filter pattern of <code>""</code>.</p> </li>
        /// <li> <p>To exclude log events that contain the <code>ERROR</code> term, and return all other log events, specify a filter pattern of <code>"-ERROR"</code>.</p> </li>
        /// <li> <p>To return log events that contain the <code>ERROR</code> term, specify a filter pattern of <code>"ERROR"</code>.</p> </li>
        /// <li> <p>To return log events that contain both the <code>ERROR</code> and <code>Exception</code> terms, specify a filter pattern of <code>"ERROR Exception"</code>.</p> </li>
        /// <li> <p>To return log events that contain the <code>ERROR</code> <i>or</i> the <code>Exception</code> term, specify a filter pattern of <code>"?ERROR ?Exception"</code>.</p> </li>
        /// </ul>
        pub fn set_filter_pattern(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.filter_pattern = input;
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetContainerLog</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetContainerLog</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContainerLogInput`](crate::input::GetContainerLogInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetContainerLogInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetContainerLogInput {
                service_name: self.service_name,
                container_name: self.container_name,
                start_time: self.start_time,
                end_time: self.end_time,
                filter_pattern: self.filter_pattern,
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetContainerLogInputOperationOutputAlias = crate::operation::GetContainerLog;
#[doc(hidden)]
pub type GetContainerLogInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetContainerLogInput {
    /// Consumes the builder and constructs an Operation<[`GetContainerLog`](crate::operation::GetContainerLog)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetContainerLog,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetContainerLogInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetContainerLogInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_1) = &_input.start_time {
                    query.push_kv(
                        "startTime",
                        &aws_smithy_http::query::fmt_timestamp(
                            inner_1,
                            aws_smithy_types::date_time::Format::DateTime,
                        )?,
                    );
                }
                if let Some(inner_2) = &_input.end_time {
                    query.push_kv(
                        "endTime",
                        &aws_smithy_http::query::fmt_timestamp(
                            inner_2,
                            aws_smithy_types::date_time::Format::DateTime,
                        )?,
                    );
                }
                if let Some(inner_3) = &_input.filter_pattern {
                    query.push_kv(
                        "filterPattern",
                        &aws_smithy_http::query::fmt_string(&inner_3),
                    );
                }
                if let Some(inner_4) = &_input.page_token {
                    query.push_kv("pageToken", &aws_smithy_http::query::fmt_string(&inner_4));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetContainerLogInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetContainerLog",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_container_log(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetContainerLog::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetContainerLog",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetContainerLogInput`](crate::input::GetContainerLogInput)
    pub fn builder() -> crate::input::get_container_log_input::Builder {
        crate::input::get_container_log_input::Builder::default()
    }
}

/// See [`GetContainerServiceDeploymentsInput`](crate::input::GetContainerServiceDeploymentsInput)
pub mod get_container_service_deployments_input {
    /// A builder for [`GetContainerServiceDeploymentsInput`](crate::input::GetContainerServiceDeploymentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the container service for which to return deployments.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the container service for which to return deployments.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContainerServiceDeploymentsInput`](crate::input::GetContainerServiceDeploymentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetContainerServiceDeploymentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetContainerServiceDeploymentsInput {
                service_name: self.service_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetContainerServiceDeploymentsInputOperationOutputAlias =
    crate::operation::GetContainerServiceDeployments;
#[doc(hidden)]
pub type GetContainerServiceDeploymentsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetContainerServiceDeploymentsInput {
    /// Consumes the builder and constructs an Operation<[`GetContainerServiceDeployments`](crate::operation::GetContainerServiceDeployments)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetContainerServiceDeployments,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetContainerServiceDeploymentsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetContainerServiceDeploymentsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetContainerServiceDeployments",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_container_service_deployments(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetContainerServiceDeployments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetContainerServiceDeployments",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetContainerServiceDeploymentsInput`](crate::input::GetContainerServiceDeploymentsInput)
    pub fn builder() -> crate::input::get_container_service_deployments_input::Builder {
        crate::input::get_container_service_deployments_input::Builder::default()
    }
}

/// See [`GetContainerServiceMetricDataInput`](crate::input::GetContainerServiceMetricDataInput)
pub mod get_container_service_metric_data_input {
    /// A builder for [`GetContainerServiceMetricDataInput`](crate::input::GetContainerServiceMetricDataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) metric_name: std::option::Option<crate::model::ContainerServiceMetricName>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) period: std::option::Option<i32>,
        pub(crate) statistics: std::option::Option<std::vec::Vec<crate::model::MetricStatistic>>,
    }
    impl Builder {
        /// <p>The name of the container service for which to get metric data.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the container service for which to get metric data.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// <p>The metric for which you want to return information.</p>
        /// <p>Valid container service metric names are listed below, along with the most useful statistics to include in your request, and the published unit value.</p>
        /// <ul>
        /// <li> <p> <code>CPUUtilization</code> - The average percentage of compute units that are currently in use across all nodes of the container service. This metric identifies the processing power required to run containers on each node of the container service.</p> <p>Statistics: The most useful statistics are <code>Maximum</code> and <code>Average</code>.</p> <p>Unit: The published unit is <code>Percent</code>.</p> </li>
        /// <li> <p> <code>MemoryUtilization</code> - The average percentage of available memory that is currently in use across all nodes of the container service. This metric identifies the memory required to run containers on each node of the container service.</p> <p>Statistics: The most useful statistics are <code>Maximum</code> and <code>Average</code>.</p> <p>Unit: The published unit is <code>Percent</code>.</p> </li>
        /// </ul>
        pub fn metric_name(mut self, input: crate::model::ContainerServiceMetricName) -> Self {
            self.metric_name = Some(input);
            self
        }
        /// <p>The metric for which you want to return information.</p>
        /// <p>Valid container service metric names are listed below, along with the most useful statistics to include in your request, and the published unit value.</p>
        /// <ul>
        /// <li> <p> <code>CPUUtilization</code> - The average percentage of compute units that are currently in use across all nodes of the container service. This metric identifies the processing power required to run containers on each node of the container service.</p> <p>Statistics: The most useful statistics are <code>Maximum</code> and <code>Average</code>.</p> <p>Unit: The published unit is <code>Percent</code>.</p> </li>
        /// <li> <p> <code>MemoryUtilization</code> - The average percentage of available memory that is currently in use across all nodes of the container service. This metric identifies the memory required to run containers on each node of the container service.</p> <p>Statistics: The most useful statistics are <code>Maximum</code> and <code>Average</code>.</p> <p>Unit: The published unit is <code>Percent</code>.</p> </li>
        /// </ul>
        pub fn set_metric_name(
            mut self,
            input: std::option::Option<crate::model::ContainerServiceMetricName>,
        ) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The start time of the time period.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time of the time period.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time of the time period.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time of the time period.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The granularity, in seconds, of the returned data points.</p>
        /// <p>All container service metric data is available in 5-minute (300 seconds) granularity.</p>
        pub fn period(mut self, input: i32) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>The granularity, in seconds, of the returned data points.</p>
        /// <p>All container service metric data is available in 5-minute (300 seconds) granularity.</p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.period = input;
            self
        }
        /// Appends an item to `statistics`.
        ///
        /// To override the contents of this collection use [`set_statistics`](Self::set_statistics).
        ///
        /// <p>The statistic for the metric.</p>
        /// <p>The following statistics are available:</p>
        /// <ul>
        /// <li> <p> <code>Minimum</code> - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Maximum</code> - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Sum</code> - All values submitted for the matching metric added together. You can use this statistic to determine the total volume of a metric.</p> </li>
        /// <li> <p> <code>Average</code> - The value of <code>Sum</code> / <code>SampleCount</code> during the specified period. By comparing this statistic with the <code>Minimum</code> and <code>Maximum</code> values, you can determine the full scope of a metric and how close the average use is to the <code>Minimum</code> and <code>Maximum</code> values. This comparison helps you to know when to increase or decrease your resources.</p> </li>
        /// <li> <p> <code>SampleCount</code> - The count, or number, of data points used for the statistical calculation.</p> </li>
        /// </ul>
        pub fn statistics(mut self, input: crate::model::MetricStatistic) -> Self {
            let mut v = self.statistics.unwrap_or_default();
            v.push(input);
            self.statistics = Some(v);
            self
        }
        /// <p>The statistic for the metric.</p>
        /// <p>The following statistics are available:</p>
        /// <ul>
        /// <li> <p> <code>Minimum</code> - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Maximum</code> - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Sum</code> - All values submitted for the matching metric added together. You can use this statistic to determine the total volume of a metric.</p> </li>
        /// <li> <p> <code>Average</code> - The value of <code>Sum</code> / <code>SampleCount</code> during the specified period. By comparing this statistic with the <code>Minimum</code> and <code>Maximum</code> values, you can determine the full scope of a metric and how close the average use is to the <code>Minimum</code> and <code>Maximum</code> values. This comparison helps you to know when to increase or decrease your resources.</p> </li>
        /// <li> <p> <code>SampleCount</code> - The count, or number, of data points used for the statistical calculation.</p> </li>
        /// </ul>
        pub fn set_statistics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricStatistic>>,
        ) -> Self {
            self.statistics = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContainerServiceMetricDataInput`](crate::input::GetContainerServiceMetricDataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetContainerServiceMetricDataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetContainerServiceMetricDataInput {
                service_name: self.service_name,
                metric_name: self.metric_name,
                start_time: self.start_time,
                end_time: self.end_time,
                period: self.period.unwrap_or_default(),
                statistics: self.statistics,
            })
        }
    }
}
#[doc(hidden)]
pub type GetContainerServiceMetricDataInputOperationOutputAlias =
    crate::operation::GetContainerServiceMetricData;
#[doc(hidden)]
pub type GetContainerServiceMetricDataInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetContainerServiceMetricDataInput {
    /// Consumes the builder and constructs an Operation<[`GetContainerServiceMetricData`](crate::operation::GetContainerServiceMetricData)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetContainerServiceMetricData,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetContainerServiceMetricDataInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetContainerServiceMetricDataInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_5) = &_input.metric_name {
                    query.push_kv("metricName", &aws_smithy_http::query::fmt_string(&inner_5));
                }
                if let Some(inner_6) = &_input.start_time {
                    query.push_kv(
                        "startTime",
                        &aws_smithy_http::query::fmt_timestamp(
                            inner_6,
                            aws_smithy_types::date_time::Format::DateTime,
                        )?,
                    );
                }
                if let Some(inner_7) = &_input.end_time {
                    query.push_kv(
                        "endTime",
                        &aws_smithy_http::query::fmt_timestamp(
                            inner_7,
                            aws_smithy_types::date_time::Format::DateTime,
                        )?,
                    );
                }
                if _input.period != 0 {
                    query.push_kv(
                        "period",
                        aws_smithy_types::primitive::Encoder::from(_input.period).encode(),
                    );
                }
                if let Some(inner_8) = &_input.statistics {
                    for inner_9 in inner_8 {
                        query.push_kv("statistics", &aws_smithy_http::query::fmt_string(&inner_9));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetContainerServiceMetricDataInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetContainerServiceMetricData",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_container_service_metric_data(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetContainerServiceMetricData::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetContainerServiceMetricData",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetContainerServiceMetricDataInput`](crate::input::GetContainerServiceMetricDataInput)
    pub fn builder() -> crate::input::get_container_service_metric_data_input::Builder {
        crate::input::get_container_service_metric_data_input::Builder::default()
    }
}

/// See [`GetContainerServicePowersInput`](crate::input::GetContainerServicePowersInput)
pub mod get_container_service_powers_input {
    /// A builder for [`GetContainerServicePowersInput`](crate::input::GetContainerServicePowersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetContainerServicePowersInput`](crate::input::GetContainerServicePowersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetContainerServicePowersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetContainerServicePowersInput {})
        }
    }
}
#[doc(hidden)]
pub type GetContainerServicePowersInputOperationOutputAlias =
    crate::operation::GetContainerServicePowers;
#[doc(hidden)]
pub type GetContainerServicePowersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetContainerServicePowersInput {
    /// Consumes the builder and constructs an Operation<[`GetContainerServicePowers`](crate::operation::GetContainerServicePowers)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetContainerServicePowers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetContainerServicePowersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetContainerServicePowersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetContainerServicePowers",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_container_service_powers(
                &self,
            )?,
        );
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetContainerServicePowers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetContainerServicePowers",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetContainerServicePowersInput`](crate::input::GetContainerServicePowersInput)
    pub fn builder() -> crate::input::get_container_service_powers_input::Builder {
        crate::input::get_container_service_powers_input::Builder::default()
    }
}

/// See [`GetContainerServicesInput`](crate::input::GetContainerServicesInput)
pub mod get_container_services_input {
    /// A builder for [`GetContainerServicesInput`](crate::input::GetContainerServicesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the container service for which to return information.</p>
        /// <p>When omitted, the response includes all of your container services in the AWS Region where the request is made.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the container service for which to return information.</p>
        /// <p>When omitted, the response includes all of your container services in the AWS Region where the request is made.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContainerServicesInput`](crate::input::GetContainerServicesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetContainerServicesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetContainerServicesInput {
                service_name: self.service_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetContainerServicesInputOperationOutputAlias = crate::operation::GetContainerServices;
#[doc(hidden)]
pub type GetContainerServicesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetContainerServicesInput {
    /// Consumes the builder and constructs an Operation<[`GetContainerServices`](crate::operation::GetContainerServices)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetContainerServices,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetContainerServicesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetContainerServicesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_10) = &_input.service_name {
                    query.push_kv(
                        "serviceName",
                        &aws_smithy_http::query::fmt_string(&inner_10),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetContainerServicesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetContainerServices",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_container_services(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetContainerServices::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetContainerServices",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetContainerServicesInput`](crate::input::GetContainerServicesInput)
    pub fn builder() -> crate::input::get_container_services_input::Builder {
        crate::input::get_container_services_input::Builder::default()
    }
}

/// See [`GetDiskInput`](crate::input::GetDiskInput)
pub mod get_disk_input {
    /// A builder for [`GetDiskInput`](crate::input::GetDiskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) disk_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the disk (e.g., <code>my-disk</code>).</p>
        pub fn disk_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.disk_name = Some(input.into());
            self
        }
        /// <p>The name of the disk (e.g., <code>my-disk</code>).</p>
        pub fn set_disk_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.disk_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDiskInput`](crate::input::GetDiskInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetDiskInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetDiskInput {
                disk_name: self.disk_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDiskInputOperationOutputAlias = crate::operation::GetDisk;
#[doc(hidden)]
pub type GetDiskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDiskInput {
    /// Consumes the builder and constructs an Operation<[`GetDisk`](crate::operation::GetDisk)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDisk,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDiskInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDiskInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetDisk",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_disk(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetDisk::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetDisk",
                    "lightsail",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDiskInput`](crate::input::GetDiskInput)
    pub fn builder() -> crate::input::get_disk_input::Builder {
        crate::input::get_disk_input::Builder::default()
    }
}

/// See [`GetDisksInput`](crate::input::GetDisksInput)
pub mod get_disks_input {
    /// A builder for [`GetDisksInput`](crate::input::GetDisksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetDisks</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetDisks</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDisksInput`](crate::input::GetDisksInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetDisksInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetDisksInput {
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDisksInputOperationOutputAlias = crate::operation::GetDisks;
#[doc(hidden)]
pub type GetDisksInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDisksInput {
    /// Consumes the builder and constructs an Operation<[`GetDisks`](crate::operation::GetDisks)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDisks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDisksInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDisksInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetDisks",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_disks(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetDisks::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetDisks",
                    "lightsail",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDisksInput`](crate::input::GetDisksInput)
    pub fn builder() -> crate::input::get_disks_input::Builder {
        crate::input::get_disks_input::Builder::default()
    }
}

/// See [`GetDiskSnapshotInput`](crate::input::GetDiskSnapshotInput)
pub mod get_disk_snapshot_input {
    /// A builder for [`GetDiskSnapshotInput`](crate::input::GetDiskSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) disk_snapshot_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the disk snapshot (e.g., <code>my-disk-snapshot</code>).</p>
        pub fn disk_snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.disk_snapshot_name = Some(input.into());
            self
        }
        /// <p>The name of the disk snapshot (e.g., <code>my-disk-snapshot</code>).</p>
        pub fn set_disk_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.disk_snapshot_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDiskSnapshotInput`](crate::input::GetDiskSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDiskSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDiskSnapshotInput {
                disk_snapshot_name: self.disk_snapshot_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDiskSnapshotInputOperationOutputAlias = crate::operation::GetDiskSnapshot;
#[doc(hidden)]
pub type GetDiskSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDiskSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`GetDiskSnapshot`](crate::operation::GetDiskSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDiskSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDiskSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDiskSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetDiskSnapshot",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_disk_snapshot(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDiskSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDiskSnapshot",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDiskSnapshotInput`](crate::input::GetDiskSnapshotInput)
    pub fn builder() -> crate::input::get_disk_snapshot_input::Builder {
        crate::input::get_disk_snapshot_input::Builder::default()
    }
}

/// See [`GetDiskSnapshotsInput`](crate::input::GetDiskSnapshotsInput)
pub mod get_disk_snapshots_input {
    /// A builder for [`GetDiskSnapshotsInput`](crate::input::GetDiskSnapshotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetDiskSnapshots</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetDiskSnapshots</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDiskSnapshotsInput`](crate::input::GetDiskSnapshotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDiskSnapshotsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDiskSnapshotsInput {
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDiskSnapshotsInputOperationOutputAlias = crate::operation::GetDiskSnapshots;
#[doc(hidden)]
pub type GetDiskSnapshotsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDiskSnapshotsInput {
    /// Consumes the builder and constructs an Operation<[`GetDiskSnapshots`](crate::operation::GetDiskSnapshots)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDiskSnapshots,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDiskSnapshotsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDiskSnapshotsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetDiskSnapshots",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_disk_snapshots(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDiskSnapshots::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDiskSnapshots",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDiskSnapshotsInput`](crate::input::GetDiskSnapshotsInput)
    pub fn builder() -> crate::input::get_disk_snapshots_input::Builder {
        crate::input::get_disk_snapshots_input::Builder::default()
    }
}

/// See [`GetDistributionBundlesInput`](crate::input::GetDistributionBundlesInput)
pub mod get_distribution_bundles_input {
    /// A builder for [`GetDistributionBundlesInput`](crate::input::GetDistributionBundlesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetDistributionBundlesInput`](crate::input::GetDistributionBundlesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDistributionBundlesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDistributionBundlesInput {})
        }
    }
}
#[doc(hidden)]
pub type GetDistributionBundlesInputOperationOutputAlias = crate::operation::GetDistributionBundles;
#[doc(hidden)]
pub type GetDistributionBundlesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDistributionBundlesInput {
    /// Consumes the builder and constructs an Operation<[`GetDistributionBundles`](crate::operation::GetDistributionBundles)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDistributionBundles,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDistributionBundlesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDistributionBundlesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetDistributionBundles",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_distribution_bundles(
                &self,
            )?,
        );
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDistributionBundles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDistributionBundles",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDistributionBundlesInput`](crate::input::GetDistributionBundlesInput)
    pub fn builder() -> crate::input::get_distribution_bundles_input::Builder {
        crate::input::get_distribution_bundles_input::Builder::default()
    }
}

/// See [`GetDistributionLatestCacheResetInput`](crate::input::GetDistributionLatestCacheResetInput)
pub mod get_distribution_latest_cache_reset_input {
    /// A builder for [`GetDistributionLatestCacheResetInput`](crate::input::GetDistributionLatestCacheResetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the distribution for which to return the timestamp of the last cache reset.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you can specify.</p>
        /// <p>When omitted, the response includes the latest cache reset timestamp of all your distributions.</p>
        pub fn distribution_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.distribution_name = Some(input.into());
            self
        }
        /// <p>The name of the distribution for which to return the timestamp of the last cache reset.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you can specify.</p>
        /// <p>When omitted, the response includes the latest cache reset timestamp of all your distributions.</p>
        pub fn set_distribution_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDistributionLatestCacheResetInput`](crate::input::GetDistributionLatestCacheResetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDistributionLatestCacheResetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDistributionLatestCacheResetInput {
                distribution_name: self.distribution_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDistributionLatestCacheResetInputOperationOutputAlias =
    crate::operation::GetDistributionLatestCacheReset;
#[doc(hidden)]
pub type GetDistributionLatestCacheResetInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetDistributionLatestCacheResetInput {
    /// Consumes the builder and constructs an Operation<[`GetDistributionLatestCacheReset`](crate::operation::GetDistributionLatestCacheReset)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDistributionLatestCacheReset,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDistributionLatestCacheResetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDistributionLatestCacheResetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetDistributionLatestCacheReset",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_distribution_latest_cache_reset(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDistributionLatestCacheReset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDistributionLatestCacheReset",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDistributionLatestCacheResetInput`](crate::input::GetDistributionLatestCacheResetInput)
    pub fn builder() -> crate::input::get_distribution_latest_cache_reset_input::Builder {
        crate::input::get_distribution_latest_cache_reset_input::Builder::default()
    }
}

/// See [`GetDistributionMetricDataInput`](crate::input::GetDistributionMetricDataInput)
pub mod get_distribution_metric_data_input {
    /// A builder for [`GetDistributionMetricDataInput`](crate::input::GetDistributionMetricDataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_name: std::option::Option<std::string::String>,
        pub(crate) metric_name: std::option::Option<crate::model::DistributionMetricName>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) period: std::option::Option<i32>,
        pub(crate) unit: std::option::Option<crate::model::MetricUnit>,
        pub(crate) statistics: std::option::Option<std::vec::Vec<crate::model::MetricStatistic>>,
    }
    impl Builder {
        /// <p>The name of the distribution for which to get metric data.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you can specify.</p>
        pub fn distribution_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.distribution_name = Some(input.into());
            self
        }
        /// <p>The name of the distribution for which to get metric data.</p>
        /// <p>Use the <code>GetDistributions</code> action to get a list of distribution names that you can specify.</p>
        pub fn set_distribution_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_name = input;
            self
        }
        /// <p>The metric for which you want to return information.</p>
        /// <p>Valid distribution metric names are listed below, along with the most useful <code>statistics</code> to include in your request, and the published <code>unit</code> value.</p>
        /// <ul>
        /// <li> <p> <b> <code>Requests</code> </b> - The total number of viewer requests received by your Lightsail distribution, for all HTTP methods, and for both HTTP and HTTPS requests.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>None</code>.</p> </li>
        /// <li> <p> <b> <code>BytesDownloaded</code> </b> - The number of bytes downloaded by viewers for GET, HEAD, and OPTIONS requests.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>None</code>.</p> </li>
        /// <li> <p> <b> <code>BytesUploaded </code> </b> - The number of bytes uploaded to your origin by your Lightsail distribution, using POST and PUT requests.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>None</code>.</p> </li>
        /// <li> <p> <b> <code>TotalErrorRate</code> </b> - The percentage of all viewer requests for which the response's HTTP status code was 4xx or 5xx.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p> <p> <code>Unit</code>: The published unit is <code>Percent</code>.</p> </li>
        /// <li> <p> <b> <code>4xxErrorRate</code> </b> - The percentage of all viewer requests for which the response's HTTP status cod was 4xx. In these cases, the client or client viewer may have made an error. For example, a status code of 404 (Not Found) means that the client requested an object that could not be found.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p> <p> <code>Unit</code>: The published unit is <code>Percent</code>.</p> </li>
        /// <li> <p> <b> <code>5xxErrorRate</code> </b> - The percentage of all viewer requests for which the response's HTTP status code was 5xx. In these cases, the origin server did not satisfy the requests. For example, a status code of 503 (Service Unavailable) means that the origin server is currently unavailable.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p> <p> <code>Unit</code>: The published unit is <code>Percent</code>.</p> </li>
        /// </ul>
        pub fn metric_name(mut self, input: crate::model::DistributionMetricName) -> Self {
            self.metric_name = Some(input);
            self
        }
        /// <p>The metric for which you want to return information.</p>
        /// <p>Valid distribution metric names are listed below, along with the most useful <code>statistics</code> to include in your request, and the published <code>unit</code> value.</p>
        /// <ul>
        /// <li> <p> <b> <code>Requests</code> </b> - The total number of viewer requests received by your Lightsail distribution, for all HTTP methods, and for both HTTP and HTTPS requests.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>None</code>.</p> </li>
        /// <li> <p> <b> <code>BytesDownloaded</code> </b> - The number of bytes downloaded by viewers for GET, HEAD, and OPTIONS requests.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>None</code>.</p> </li>
        /// <li> <p> <b> <code>BytesUploaded </code> </b> - The number of bytes uploaded to your origin by your Lightsail distribution, using POST and PUT requests.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>None</code>.</p> </li>
        /// <li> <p> <b> <code>TotalErrorRate</code> </b> - The percentage of all viewer requests for which the response's HTTP status code was 4xx or 5xx.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p> <p> <code>Unit</code>: The published unit is <code>Percent</code>.</p> </li>
        /// <li> <p> <b> <code>4xxErrorRate</code> </b> - The percentage of all viewer requests for which the response's HTTP status cod was 4xx. In these cases, the client or client viewer may have made an error. For example, a status code of 404 (Not Found) means that the client requested an object that could not be found.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p> <p> <code>Unit</code>: The published unit is <code>Percent</code>.</p> </li>
        /// <li> <p> <b> <code>5xxErrorRate</code> </b> - The percentage of all viewer requests for which the response's HTTP status code was 5xx. In these cases, the origin server did not satisfy the requests. For example, a status code of 503 (Service Unavailable) means that the origin server is currently unavailable.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p> <p> <code>Unit</code>: The published unit is <code>Percent</code>.</p> </li>
        /// </ul>
        pub fn set_metric_name(
            mut self,
            input: std::option::Option<crate::model::DistributionMetricName>,
        ) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The start of the time interval for which to get metric data.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Specified in Coordinated Universal Time (UTC).</p> </li>
        /// <li> <p>Specified in the Unix time format.</p> <p>For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, specify <code>1538424000</code> as the start time.</p> </li>
        /// </ul>
        /// <p>You can convert a human-friendly time to Unix time format using a converter like <a href="https://www.epochconverter.com/">Epoch converter</a>.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start of the time interval for which to get metric data.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Specified in Coordinated Universal Time (UTC).</p> </li>
        /// <li> <p>Specified in the Unix time format.</p> <p>For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, specify <code>1538424000</code> as the start time.</p> </li>
        /// </ul>
        /// <p>You can convert a human-friendly time to Unix time format using a converter like <a href="https://www.epochconverter.com/">Epoch converter</a>.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end of the time interval for which to get metric data.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Specified in Coordinated Universal Time (UTC).</p> </li>
        /// <li> <p>Specified in the Unix time format.</p> <p>For example, if you wish to use an end time of October 1, 2018, at 9 PM UTC, specify <code>1538427600</code> as the end time.</p> </li>
        /// </ul>
        /// <p>You can convert a human-friendly time to Unix time format using a converter like <a href="https://www.epochconverter.com/">Epoch converter</a>.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end of the time interval for which to get metric data.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Specified in Coordinated Universal Time (UTC).</p> </li>
        /// <li> <p>Specified in the Unix time format.</p> <p>For example, if you wish to use an end time of October 1, 2018, at 9 PM UTC, specify <code>1538427600</code> as the end time.</p> </li>
        /// </ul>
        /// <p>You can convert a human-friendly time to Unix time format using a converter like <a href="https://www.epochconverter.com/">Epoch converter</a>.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The granularity, in seconds, for the metric data points that will be returned.</p>
        pub fn period(mut self, input: i32) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>The granularity, in seconds, for the metric data points that will be returned.</p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.period = input;
            self
        }
        /// <p>The unit for the metric data request.</p>
        /// <p>Valid units depend on the metric data being requested. For the valid units with each available metric, see the <code>metricName</code> parameter.</p>
        pub fn unit(mut self, input: crate::model::MetricUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>The unit for the metric data request.</p>
        /// <p>Valid units depend on the metric data being requested. For the valid units with each available metric, see the <code>metricName</code> parameter.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::MetricUnit>) -> Self {
            self.unit = input;
            self
        }
        /// Appends an item to `statistics`.
        ///
        /// To override the contents of this collection use [`set_statistics`](Self::set_statistics).
        ///
        /// <p>The statistic for the metric.</p>
        /// <p>The following statistics are available:</p>
        /// <ul>
        /// <li> <p> <code>Minimum</code> - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Maximum</code> - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Sum</code> - All values submitted for the matching metric added together. You can use this statistic to determine the total volume of a metric.</p> </li>
        /// <li> <p> <code>Average</code> - The value of Sum / SampleCount during the specified period. By comparing this statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your resources.</p> </li>
        /// <li> <p> <code>SampleCount</code> - The count, or number, of data points used for the statistical calculation.</p> </li>
        /// </ul>
        pub fn statistics(mut self, input: crate::model::MetricStatistic) -> Self {
            let mut v = self.statistics.unwrap_or_default();
            v.push(input);
            self.statistics = Some(v);
            self
        }
        /// <p>The statistic for the metric.</p>
        /// <p>The following statistics are available:</p>
        /// <ul>
        /// <li> <p> <code>Minimum</code> - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Maximum</code> - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Sum</code> - All values submitted for the matching metric added together. You can use this statistic to determine the total volume of a metric.</p> </li>
        /// <li> <p> <code>Average</code> - The value of Sum / SampleCount during the specified period. By comparing this statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your resources.</p> </li>
        /// <li> <p> <code>SampleCount</code> - The count, or number, of data points used for the statistical calculation.</p> </li>
        /// </ul>
        pub fn set_statistics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricStatistic>>,
        ) -> Self {
            self.statistics = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDistributionMetricDataInput`](crate::input::GetDistributionMetricDataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDistributionMetricDataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDistributionMetricDataInput {
                distribution_name: self.distribution_name,
                metric_name: self.metric_name,
                start_time: self.start_time,
                end_time: self.end_time,
                period: self.period.unwrap_or_default(),
                unit: self.unit,
                statistics: self.statistics,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDistributionMetricDataInputOperationOutputAlias =
    crate::operation::GetDistributionMetricData;
#[doc(hidden)]
pub type GetDistributionMetricDataInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDistributionMetricDataInput {
    /// Consumes the builder and constructs an Operation<[`GetDistributionMetricData`](crate::operation::GetDistributionMetricData)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDistributionMetricData,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDistributionMetricDataInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDistributionMetricDataInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetDistributionMetricData",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_distribution_metric_data(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDistributionMetricData::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDistributionMetricData",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDistributionMetricDataInput`](crate::input::GetDistributionMetricDataInput)
    pub fn builder() -> crate::input::get_distribution_metric_data_input::Builder {
        crate::input::get_distribution_metric_data_input::Builder::default()
    }
}

/// See [`GetDistributionsInput`](crate::input::GetDistributionsInput)
pub mod get_distributions_input {
    /// A builder for [`GetDistributionsInput`](crate::input::GetDistributionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) distribution_name: std::option::Option<std::string::String>,
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the distribution for which to return information.</p>
        /// <p>When omitted, the response includes all of your distributions in the AWS Region where the request is made.</p>
        pub fn distribution_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.distribution_name = Some(input.into());
            self
        }
        /// <p>The name of the distribution for which to return information.</p>
        /// <p>When omitted, the response includes all of your distributions in the AWS Region where the request is made.</p>
        pub fn set_distribution_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.distribution_name = input;
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetDistributions</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetDistributions</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDistributionsInput`](crate::input::GetDistributionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDistributionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDistributionsInput {
                distribution_name: self.distribution_name,
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDistributionsInputOperationOutputAlias = crate::operation::GetDistributions;
#[doc(hidden)]
pub type GetDistributionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDistributionsInput {
    /// Consumes the builder and constructs an Operation<[`GetDistributions`](crate::operation::GetDistributions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDistributions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDistributionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDistributionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetDistributions",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_distributions(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDistributions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDistributions",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDistributionsInput`](crate::input::GetDistributionsInput)
    pub fn builder() -> crate::input::get_distributions_input::Builder {
        crate::input::get_distributions_input::Builder::default()
    }
}

/// See [`GetDomainInput`](crate::input::GetDomainInput)
pub mod get_domain_input {
    /// A builder for [`GetDomainInput`](crate::input::GetDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The domain name for which your want to return information about.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name for which your want to return information about.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDomainInput`](crate::input::GetDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetDomainInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetDomainInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDomainInputOperationOutputAlias = crate::operation::GetDomain;
#[doc(hidden)]
pub type GetDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDomainInput {
    /// Consumes the builder and constructs an Operation<[`GetDomain`](crate::operation::GetDomain)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDomainInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDomainInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetDomain",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_domain(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetDomain::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetDomain",
                    "lightsail",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDomainInput`](crate::input::GetDomainInput)
    pub fn builder() -> crate::input::get_domain_input::Builder {
        crate::input::get_domain_input::Builder::default()
    }
}

/// See [`GetDomainsInput`](crate::input::GetDomainsInput)
pub mod get_domains_input {
    /// A builder for [`GetDomainsInput`](crate::input::GetDomainsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetDomains</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetDomains</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDomainsInput`](crate::input::GetDomainsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDomainsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDomainsInput {
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDomainsInputOperationOutputAlias = crate::operation::GetDomains;
#[doc(hidden)]
pub type GetDomainsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDomainsInput {
    /// Consumes the builder and constructs an Operation<[`GetDomains`](crate::operation::GetDomains)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDomains,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDomainsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDomainsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetDomains",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_domains(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDomains::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDomains",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDomainsInput`](crate::input::GetDomainsInput)
    pub fn builder() -> crate::input::get_domains_input::Builder {
        crate::input::get_domains_input::Builder::default()
    }
}

/// See [`GetExportSnapshotRecordsInput`](crate::input::GetExportSnapshotRecordsInput)
pub mod get_export_snapshot_records_input {
    /// A builder for [`GetExportSnapshotRecordsInput`](crate::input::GetExportSnapshotRecordsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetExportSnapshotRecords</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetExportSnapshotRecords</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetExportSnapshotRecordsInput`](crate::input::GetExportSnapshotRecordsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetExportSnapshotRecordsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetExportSnapshotRecordsInput {
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetExportSnapshotRecordsInputOperationOutputAlias =
    crate::operation::GetExportSnapshotRecords;
#[doc(hidden)]
pub type GetExportSnapshotRecordsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetExportSnapshotRecordsInput {
    /// Consumes the builder and constructs an Operation<[`GetExportSnapshotRecords`](crate::operation::GetExportSnapshotRecords)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetExportSnapshotRecords,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetExportSnapshotRecordsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetExportSnapshotRecordsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetExportSnapshotRecords",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_export_snapshot_records(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetExportSnapshotRecords::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetExportSnapshotRecords",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetExportSnapshotRecordsInput`](crate::input::GetExportSnapshotRecordsInput)
    pub fn builder() -> crate::input::get_export_snapshot_records_input::Builder {
        crate::input::get_export_snapshot_records_input::Builder::default()
    }
}

/// See [`GetInstanceInput`](crate::input::GetInstanceInput)
pub mod get_instance_input {
    /// A builder for [`GetInstanceInput`](crate::input::GetInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the instance.</p>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_name = Some(input.into());
            self
        }
        /// <p>The name of the instance.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInstanceInput`](crate::input::GetInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInstanceInput {
                instance_name: self.instance_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInstanceInputOperationOutputAlias = crate::operation::GetInstance;
#[doc(hidden)]
pub type GetInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetInstanceInput {
    /// Consumes the builder and constructs an Operation<[`GetInstance`](crate::operation::GetInstance)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetInstanceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetInstanceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetInstance",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_instance(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInstance",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetInstanceInput`](crate::input::GetInstanceInput)
    pub fn builder() -> crate::input::get_instance_input::Builder {
        crate::input::get_instance_input::Builder::default()
    }
}

/// See [`GetInstanceAccessDetailsInput`](crate::input::GetInstanceAccessDetailsInput)
pub mod get_instance_access_details_input {
    /// A builder for [`GetInstanceAccessDetailsInput`](crate::input::GetInstanceAccessDetailsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_name: std::option::Option<std::string::String>,
        pub(crate) protocol: std::option::Option<crate::model::InstanceAccessProtocol>,
    }
    impl Builder {
        /// <p>The name of the instance to access.</p>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_name = Some(input.into());
            self
        }
        /// <p>The name of the instance to access.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_name = input;
            self
        }
        /// <p>The protocol to use to connect to your instance. Defaults to <code>ssh</code>.</p>
        pub fn protocol(mut self, input: crate::model::InstanceAccessProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol to use to connect to your instance. Defaults to <code>ssh</code>.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::InstanceAccessProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInstanceAccessDetailsInput`](crate::input::GetInstanceAccessDetailsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInstanceAccessDetailsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInstanceAccessDetailsInput {
                instance_name: self.instance_name,
                protocol: self.protocol,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInstanceAccessDetailsInputOperationOutputAlias =
    crate::operation::GetInstanceAccessDetails;
#[doc(hidden)]
pub type GetInstanceAccessDetailsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetInstanceAccessDetailsInput {
    /// Consumes the builder and constructs an Operation<[`GetInstanceAccessDetails`](crate::operation::GetInstanceAccessDetails)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInstanceAccessDetails,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetInstanceAccessDetailsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetInstanceAccessDetailsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetInstanceAccessDetails",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_instance_access_details(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInstanceAccessDetails::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInstanceAccessDetails",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetInstanceAccessDetailsInput`](crate::input::GetInstanceAccessDetailsInput)
    pub fn builder() -> crate::input::get_instance_access_details_input::Builder {
        crate::input::get_instance_access_details_input::Builder::default()
    }
}

/// See [`GetInstanceMetricDataInput`](crate::input::GetInstanceMetricDataInput)
pub mod get_instance_metric_data_input {
    /// A builder for [`GetInstanceMetricDataInput`](crate::input::GetInstanceMetricDataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_name: std::option::Option<std::string::String>,
        pub(crate) metric_name: std::option::Option<crate::model::InstanceMetricName>,
        pub(crate) period: std::option::Option<i32>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) unit: std::option::Option<crate::model::MetricUnit>,
        pub(crate) statistics: std::option::Option<std::vec::Vec<crate::model::MetricStatistic>>,
    }
    impl Builder {
        /// <p>The name of the instance for which you want to get metrics data.</p>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_name = Some(input.into());
            self
        }
        /// <p>The name of the instance for which you want to get metrics data.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_name = input;
            self
        }
        /// <p>The metric for which you want to return information.</p>
        /// <p>Valid instance metric names are listed below, along with the most useful <code>statistics</code> to include in your request, and the published <code>unit</code> value.</p>
        /// <ul>
        /// <li> <p> <b> <code>BurstCapacityPercentage</code> </b> - The percentage of CPU performance available for your instance to burst above its baseline. Your instance continuously accrues and consumes burst capacity. Burst capacity stops accruing when your instance's <code>BurstCapacityPercentage</code> reaches 100%. For more information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-viewing-instance-burst-capacity">Viewing instance burst capacity in Amazon Lightsail</a>.</p> <p> <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Average</code>.</p> <p> <code>Unit</code>: The published unit is <code>Percent</code>.</p> </li>
        /// <li> <p> <b> <code>BurstCapacityTime</code> </b> - The available amount of time for your instance to burst at 100% CPU utilization. Your instance continuously accrues and consumes burst capacity. Burst capacity time stops accruing when your instance's <code>BurstCapacityPercentage</code> metric reaches 100%.</p> <p>Burst capacity time is consumed at the full rate only when your instance operates at 100% CPU utilization. For example, if your instance operates at 50% CPU utilization in the burstable zone for a 5-minute period, then it consumes CPU burst capacity minutes at a 50% rate in that period. Your instance consumed 2 minutes and 30 seconds of CPU burst capacity minutes in the 5-minute period. For more information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-viewing-instance-burst-capacity">Viewing instance burst capacity in Amazon Lightsail</a>.</p> <p> <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Average</code>.</p> <p> <code>Unit</code>: The published unit is <code>Seconds</code>.</p> </li>
        /// <li> <p> <b> <code>CPUUtilization</code> </b> - The percentage of allocated compute units that are currently in use on the instance. This metric identifies the processing power to run the applications on the instance. Tools in your operating system can show a lower percentage than Lightsail when the instance is not allocated a full processor core.</p> <p> <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Average</code>.</p> <p> <code>Unit</code>: The published unit is <code>Percent</code>.</p> </li>
        /// <li> <p> <b> <code>NetworkIn</code> </b> - The number of bytes received on all network interfaces by the instance. This metric identifies the volume of incoming network traffic to the instance. The number reported is the number of bytes received during the period. Because this metric is reported in 5-minute intervals, divide the reported number by 300 to find Bytes/second.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Bytes</code>.</p> </li>
        /// <li> <p> <b> <code>NetworkOut</code> </b> - The number of bytes sent out on all network interfaces by the instance. This metric identifies the volume of outgoing network traffic from the instance. The number reported is the number of bytes sent during the period. Because this metric is reported in 5-minute intervals, divide the reported number by 300 to find Bytes/second.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Bytes</code>.</p> </li>
        /// <li> <p> <b> <code>StatusCheckFailed</code> </b> - Reports whether the instance passed or failed both the instance status check and the system status check. This metric can be either 0 (passed) or 1 (failed). This metric data is available in 1-minute (60 seconds) granularity.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>StatusCheckFailed_Instance</code> </b> - Reports whether the instance passed or failed the instance status check. This metric can be either 0 (passed) or 1 (failed). This metric data is available in 1-minute (60 seconds) granularity.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>StatusCheckFailed_System</code> </b> - Reports whether the instance passed or failed the system status check. This metric can be either 0 (passed) or 1 (failed). This metric data is available in 1-minute (60 seconds) granularity.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// </ul>
        pub fn metric_name(mut self, input: crate::model::InstanceMetricName) -> Self {
            self.metric_name = Some(input);
            self
        }
        /// <p>The metric for which you want to return information.</p>
        /// <p>Valid instance metric names are listed below, along with the most useful <code>statistics</code> to include in your request, and the published <code>unit</code> value.</p>
        /// <ul>
        /// <li> <p> <b> <code>BurstCapacityPercentage</code> </b> - The percentage of CPU performance available for your instance to burst above its baseline. Your instance continuously accrues and consumes burst capacity. Burst capacity stops accruing when your instance's <code>BurstCapacityPercentage</code> reaches 100%. For more information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-viewing-instance-burst-capacity">Viewing instance burst capacity in Amazon Lightsail</a>.</p> <p> <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Average</code>.</p> <p> <code>Unit</code>: The published unit is <code>Percent</code>.</p> </li>
        /// <li> <p> <b> <code>BurstCapacityTime</code> </b> - The available amount of time for your instance to burst at 100% CPU utilization. Your instance continuously accrues and consumes burst capacity. Burst capacity time stops accruing when your instance's <code>BurstCapacityPercentage</code> metric reaches 100%.</p> <p>Burst capacity time is consumed at the full rate only when your instance operates at 100% CPU utilization. For example, if your instance operates at 50% CPU utilization in the burstable zone for a 5-minute period, then it consumes CPU burst capacity minutes at a 50% rate in that period. Your instance consumed 2 minutes and 30 seconds of CPU burst capacity minutes in the 5-minute period. For more information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-viewing-instance-burst-capacity">Viewing instance burst capacity in Amazon Lightsail</a>.</p> <p> <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Average</code>.</p> <p> <code>Unit</code>: The published unit is <code>Seconds</code>.</p> </li>
        /// <li> <p> <b> <code>CPUUtilization</code> </b> - The percentage of allocated compute units that are currently in use on the instance. This metric identifies the processing power to run the applications on the instance. Tools in your operating system can show a lower percentage than Lightsail when the instance is not allocated a full processor core.</p> <p> <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Average</code>.</p> <p> <code>Unit</code>: The published unit is <code>Percent</code>.</p> </li>
        /// <li> <p> <b> <code>NetworkIn</code> </b> - The number of bytes received on all network interfaces by the instance. This metric identifies the volume of incoming network traffic to the instance. The number reported is the number of bytes received during the period. Because this metric is reported in 5-minute intervals, divide the reported number by 300 to find Bytes/second.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Bytes</code>.</p> </li>
        /// <li> <p> <b> <code>NetworkOut</code> </b> - The number of bytes sent out on all network interfaces by the instance. This metric identifies the volume of outgoing network traffic from the instance. The number reported is the number of bytes sent during the period. Because this metric is reported in 5-minute intervals, divide the reported number by 300 to find Bytes/second.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Bytes</code>.</p> </li>
        /// <li> <p> <b> <code>StatusCheckFailed</code> </b> - Reports whether the instance passed or failed both the instance status check and the system status check. This metric can be either 0 (passed) or 1 (failed). This metric data is available in 1-minute (60 seconds) granularity.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>StatusCheckFailed_Instance</code> </b> - Reports whether the instance passed or failed the instance status check. This metric can be either 0 (passed) or 1 (failed). This metric data is available in 1-minute (60 seconds) granularity.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>StatusCheckFailed_System</code> </b> - Reports whether the instance passed or failed the system status check. This metric can be either 0 (passed) or 1 (failed). This metric data is available in 1-minute (60 seconds) granularity.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// </ul>
        pub fn set_metric_name(
            mut self,
            input: std::option::Option<crate::model::InstanceMetricName>,
        ) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The granularity, in seconds, of the returned data points.</p>
        /// <p>The <code>StatusCheckFailed</code>, <code>StatusCheckFailed_Instance</code>, and <code>StatusCheckFailed_System</code> instance metric data is available in 1-minute (60 seconds) granularity. All other instance metric data is available in 5-minute (300 seconds) granularity.</p>
        pub fn period(mut self, input: i32) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>The granularity, in seconds, of the returned data points.</p>
        /// <p>The <code>StatusCheckFailed</code>, <code>StatusCheckFailed_Instance</code>, and <code>StatusCheckFailed_System</code> instance metric data is available in 1-minute (60 seconds) granularity. All other instance metric data is available in 5-minute (300 seconds) granularity.</p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.period = input;
            self
        }
        /// <p>The start time of the time period.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time of the time period.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time of the time period.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time of the time period.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The unit for the metric data request. Valid units depend on the metric data being requested. For the valid units to specify with each available metric, see the <code>metricName</code> parameter.</p>
        pub fn unit(mut self, input: crate::model::MetricUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>The unit for the metric data request. Valid units depend on the metric data being requested. For the valid units to specify with each available metric, see the <code>metricName</code> parameter.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::MetricUnit>) -> Self {
            self.unit = input;
            self
        }
        /// Appends an item to `statistics`.
        ///
        /// To override the contents of this collection use [`set_statistics`](Self::set_statistics).
        ///
        /// <p>The statistic for the metric.</p>
        /// <p>The following statistics are available:</p>
        /// <ul>
        /// <li> <p> <code>Minimum</code> - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Maximum</code> - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Sum</code> - All values submitted for the matching metric added together. You can use this statistic to determine the total volume of a metric.</p> </li>
        /// <li> <p> <code>Average</code> - The value of Sum / SampleCount during the specified period. By comparing this statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your resources.</p> </li>
        /// <li> <p> <code>SampleCount</code> - The count, or number, of data points used for the statistical calculation.</p> </li>
        /// </ul>
        pub fn statistics(mut self, input: crate::model::MetricStatistic) -> Self {
            let mut v = self.statistics.unwrap_or_default();
            v.push(input);
            self.statistics = Some(v);
            self
        }
        /// <p>The statistic for the metric.</p>
        /// <p>The following statistics are available:</p>
        /// <ul>
        /// <li> <p> <code>Minimum</code> - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Maximum</code> - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Sum</code> - All values submitted for the matching metric added together. You can use this statistic to determine the total volume of a metric.</p> </li>
        /// <li> <p> <code>Average</code> - The value of Sum / SampleCount during the specified period. By comparing this statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your resources.</p> </li>
        /// <li> <p> <code>SampleCount</code> - The count, or number, of data points used for the statistical calculation.</p> </li>
        /// </ul>
        pub fn set_statistics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricStatistic>>,
        ) -> Self {
            self.statistics = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInstanceMetricDataInput`](crate::input::GetInstanceMetricDataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInstanceMetricDataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInstanceMetricDataInput {
                instance_name: self.instance_name,
                metric_name: self.metric_name,
                period: self.period.unwrap_or_default(),
                start_time: self.start_time,
                end_time: self.end_time,
                unit: self.unit,
                statistics: self.statistics,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInstanceMetricDataInputOperationOutputAlias = crate::operation::GetInstanceMetricData;
#[doc(hidden)]
pub type GetInstanceMetricDataInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetInstanceMetricDataInput {
    /// Consumes the builder and constructs an Operation<[`GetInstanceMetricData`](crate::operation::GetInstanceMetricData)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInstanceMetricData,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetInstanceMetricDataInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetInstanceMetricDataInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetInstanceMetricData",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_instance_metric_data(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInstanceMetricData::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInstanceMetricData",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetInstanceMetricDataInput`](crate::input::GetInstanceMetricDataInput)
    pub fn builder() -> crate::input::get_instance_metric_data_input::Builder {
        crate::input::get_instance_metric_data_input::Builder::default()
    }
}

/// See [`GetInstancePortStatesInput`](crate::input::GetInstancePortStatesInput)
pub mod get_instance_port_states_input {
    /// A builder for [`GetInstancePortStatesInput`](crate::input::GetInstancePortStatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the instance for which to return firewall port states.</p>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_name = Some(input.into());
            self
        }
        /// <p>The name of the instance for which to return firewall port states.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInstancePortStatesInput`](crate::input::GetInstancePortStatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInstancePortStatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInstancePortStatesInput {
                instance_name: self.instance_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInstancePortStatesInputOperationOutputAlias = crate::operation::GetInstancePortStates;
#[doc(hidden)]
pub type GetInstancePortStatesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetInstancePortStatesInput {
    /// Consumes the builder and constructs an Operation<[`GetInstancePortStates`](crate::operation::GetInstancePortStates)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInstancePortStates,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetInstancePortStatesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetInstancePortStatesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetInstancePortStates",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_instance_port_states(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInstancePortStates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInstancePortStates",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetInstancePortStatesInput`](crate::input::GetInstancePortStatesInput)
    pub fn builder() -> crate::input::get_instance_port_states_input::Builder {
        crate::input::get_instance_port_states_input::Builder::default()
    }
}

/// See [`GetInstancesInput`](crate::input::GetInstancesInput)
pub mod get_instances_input {
    /// A builder for [`GetInstancesInput`](crate::input::GetInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetInstances</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetInstances</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInstancesInput`](crate::input::GetInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInstancesInput {
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInstancesInputOperationOutputAlias = crate::operation::GetInstances;
#[doc(hidden)]
pub type GetInstancesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetInstancesInput {
    /// Consumes the builder and constructs an Operation<[`GetInstances`](crate::operation::GetInstances)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetInstancesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetInstancesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetInstances",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_instances(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInstances",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetInstancesInput`](crate::input::GetInstancesInput)
    pub fn builder() -> crate::input::get_instances_input::Builder {
        crate::input::get_instances_input::Builder::default()
    }
}

/// See [`GetInstanceSnapshotInput`](crate::input::GetInstanceSnapshotInput)
pub mod get_instance_snapshot_input {
    /// A builder for [`GetInstanceSnapshotInput`](crate::input::GetInstanceSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_snapshot_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the snapshot for which you are requesting information.</p>
        pub fn instance_snapshot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_snapshot_name = Some(input.into());
            self
        }
        /// <p>The name of the snapshot for which you are requesting information.</p>
        pub fn set_instance_snapshot_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_snapshot_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInstanceSnapshotInput`](crate::input::GetInstanceSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInstanceSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInstanceSnapshotInput {
                instance_snapshot_name: self.instance_snapshot_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInstanceSnapshotInputOperationOutputAlias = crate::operation::GetInstanceSnapshot;
#[doc(hidden)]
pub type GetInstanceSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetInstanceSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`GetInstanceSnapshot`](crate::operation::GetInstanceSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInstanceSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetInstanceSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetInstanceSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetInstanceSnapshot",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_instance_snapshot(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInstanceSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInstanceSnapshot",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetInstanceSnapshotInput`](crate::input::GetInstanceSnapshotInput)
    pub fn builder() -> crate::input::get_instance_snapshot_input::Builder {
        crate::input::get_instance_snapshot_input::Builder::default()
    }
}

/// See [`GetInstanceSnapshotsInput`](crate::input::GetInstanceSnapshotsInput)
pub mod get_instance_snapshots_input {
    /// A builder for [`GetInstanceSnapshotsInput`](crate::input::GetInstanceSnapshotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetInstanceSnapshots</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetInstanceSnapshots</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInstanceSnapshotsInput`](crate::input::GetInstanceSnapshotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInstanceSnapshotsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInstanceSnapshotsInput {
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInstanceSnapshotsInputOperationOutputAlias = crate::operation::GetInstanceSnapshots;
#[doc(hidden)]
pub type GetInstanceSnapshotsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetInstanceSnapshotsInput {
    /// Consumes the builder and constructs an Operation<[`GetInstanceSnapshots`](crate::operation::GetInstanceSnapshots)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInstanceSnapshots,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetInstanceSnapshotsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetInstanceSnapshotsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetInstanceSnapshots",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_instance_snapshots(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInstanceSnapshots::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInstanceSnapshots",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetInstanceSnapshotsInput`](crate::input::GetInstanceSnapshotsInput)
    pub fn builder() -> crate::input::get_instance_snapshots_input::Builder {
        crate::input::get_instance_snapshots_input::Builder::default()
    }
}

/// See [`GetInstanceStateInput`](crate::input::GetInstanceStateInput)
pub mod get_instance_state_input {
    /// A builder for [`GetInstanceStateInput`](crate::input::GetInstanceStateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the instance to get state information about.</p>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_name = Some(input.into());
            self
        }
        /// <p>The name of the instance to get state information about.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetInstanceStateInput`](crate::input::GetInstanceStateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInstanceStateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInstanceStateInput {
                instance_name: self.instance_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetInstanceStateInputOperationOutputAlias = crate::operation::GetInstanceState;
#[doc(hidden)]
pub type GetInstanceStateInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetInstanceStateInput {
    /// Consumes the builder and constructs an Operation<[`GetInstanceState`](crate::operation::GetInstanceState)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInstanceState,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetInstanceStateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetInstanceStateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetInstanceState",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_instance_state(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInstanceState::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInstanceState",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetInstanceStateInput`](crate::input::GetInstanceStateInput)
    pub fn builder() -> crate::input::get_instance_state_input::Builder {
        crate::input::get_instance_state_input::Builder::default()
    }
}

/// See [`GetKeyPairInput`](crate::input::GetKeyPairInput)
pub mod get_key_pair_input {
    /// A builder for [`GetKeyPairInput`](crate::input::GetKeyPairInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_pair_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the key pair for which you are requesting information.</p>
        pub fn key_pair_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_pair_name = Some(input.into());
            self
        }
        /// <p>The name of the key pair for which you are requesting information.</p>
        pub fn set_key_pair_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.key_pair_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetKeyPairInput`](crate::input::GetKeyPairInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetKeyPairInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetKeyPairInput {
                key_pair_name: self.key_pair_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetKeyPairInputOperationOutputAlias = crate::operation::GetKeyPair;
#[doc(hidden)]
pub type GetKeyPairInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetKeyPairInput {
    /// Consumes the builder and constructs an Operation<[`GetKeyPair`](crate::operation::GetKeyPair)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetKeyPair,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetKeyPairInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetKeyPairInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetKeyPair",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_key_pair(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetKeyPair::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetKeyPair",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetKeyPairInput`](crate::input::GetKeyPairInput)
    pub fn builder() -> crate::input::get_key_pair_input::Builder {
        crate::input::get_key_pair_input::Builder::default()
    }
}

/// See [`GetKeyPairsInput`](crate::input::GetKeyPairsInput)
pub mod get_key_pairs_input {
    /// A builder for [`GetKeyPairsInput`](crate::input::GetKeyPairsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) page_token: std::option::Option<std::string::String>,
        pub(crate) include_default_key_pair: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetKeyPairs</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetKeyPairs</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// <p>A Boolean value that indicates whether to include the default key pair in the response of your request.</p>
        pub fn include_default_key_pair(mut self, input: bool) -> Self {
            self.include_default_key_pair = Some(input);
            self
        }
        /// <p>A Boolean value that indicates whether to include the default key pair in the response of your request.</p>
        pub fn set_include_default_key_pair(mut self, input: std::option::Option<bool>) -> Self {
            self.include_default_key_pair = input;
            self
        }
        /// Consumes the builder and constructs a [`GetKeyPairsInput`](crate::input::GetKeyPairsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetKeyPairsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetKeyPairsInput {
                page_token: self.page_token,
                include_default_key_pair: self.include_default_key_pair,
            })
        }
    }
}
#[doc(hidden)]
pub type GetKeyPairsInputOperationOutputAlias = crate::operation::GetKeyPairs;
#[doc(hidden)]
pub type GetKeyPairsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetKeyPairsInput {
    /// Consumes the builder and constructs an Operation<[`GetKeyPairs`](crate::operation::GetKeyPairs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetKeyPairs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetKeyPairsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetKeyPairsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetKeyPairs",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_key_pairs(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetKeyPairs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetKeyPairs",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetKeyPairsInput`](crate::input::GetKeyPairsInput)
    pub fn builder() -> crate::input::get_key_pairs_input::Builder {
        crate::input::get_key_pairs_input::Builder::default()
    }
}

/// See [`GetLoadBalancerInput`](crate::input::GetLoadBalancerInput)
pub mod get_load_balancer_input {
    /// A builder for [`GetLoadBalancerInput`](crate::input::GetLoadBalancerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLoadBalancerInput`](crate::input::GetLoadBalancerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLoadBalancerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLoadBalancerInput {
                load_balancer_name: self.load_balancer_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLoadBalancerInputOperationOutputAlias = crate::operation::GetLoadBalancer;
#[doc(hidden)]
pub type GetLoadBalancerInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetLoadBalancerInput {
    /// Consumes the builder and constructs an Operation<[`GetLoadBalancer`](crate::operation::GetLoadBalancer)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLoadBalancer,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetLoadBalancerInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetLoadBalancerInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetLoadBalancer",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_load_balancer(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLoadBalancer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLoadBalancer",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetLoadBalancerInput`](crate::input::GetLoadBalancerInput)
    pub fn builder() -> crate::input::get_load_balancer_input::Builder {
        crate::input::get_load_balancer_input::Builder::default()
    }
}

/// See [`GetLoadBalancerMetricDataInput`](crate::input::GetLoadBalancerMetricDataInput)
pub mod get_load_balancer_metric_data_input {
    /// A builder for [`GetLoadBalancerMetricDataInput`](crate::input::GetLoadBalancerMetricDataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) metric_name: std::option::Option<crate::model::LoadBalancerMetricName>,
        pub(crate) period: std::option::Option<i32>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) unit: std::option::Option<crate::model::MetricUnit>,
        pub(crate) statistics: std::option::Option<std::vec::Vec<crate::model::MetricStatistic>>,
    }
    impl Builder {
        /// <p>The name of the load balancer.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// <p>The metric for which you want to return information.</p>
        /// <p>Valid load balancer metric names are listed below, along with the most useful <code>statistics</code> to include in your request, and the published <code>unit</code> value.</p>
        /// <ul>
        /// <li> <p> <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the client that did not establish a session with the load balancer due to a TLS error generated by the load balancer. Possible causes include a mismatch of ciphers or protocols.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.</p> <p> <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and <code>Maximum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP 2XX response codes generated by the target instances. This does not include any response codes generated by the load balancer.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP 3XX response codes generated by the target instances. This does not include any response codes generated by the load balancer.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP 4XX response codes generated by the target instances. This does not include any response codes generated by the load balancer.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP 5XX response codes generated by the target instances. This does not include any response codes generated by the load balancer.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originated from the load balancer. Client errors are generated when requests are malformed or incomplete. These requests were not received by the target instance. This count does not include response codes generated by the target instances.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originated from the load balancer. This does not include any response codes generated by the target instance. This metric is reported if there are no healthy instances attached to the load balancer, or if the request rate exceeds the capacity of the instances (spillover) or the load balancer.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves the load balancer until a response from the target instance is received.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p> <p> <code>Unit</code>: The published unit is <code>Seconds</code>.</p> </li>
        /// <li> <p> <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because the load balancer had reached its maximum number of connections.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes only the requests with a response generated by a target instance of the load balancer.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered unhealthy.</p> <p> <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and <code>Maximum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// </ul>
        pub fn metric_name(mut self, input: crate::model::LoadBalancerMetricName) -> Self {
            self.metric_name = Some(input);
            self
        }
        /// <p>The metric for which you want to return information.</p>
        /// <p>Valid load balancer metric names are listed below, along with the most useful <code>statistics</code> to include in your request, and the published <code>unit</code> value.</p>
        /// <ul>
        /// <li> <p> <b> <code>ClientTLSNegotiationErrorCount</code> </b> - The number of TLS connections initiated by the client that did not establish a session with the load balancer due to a TLS error generated by the load balancer. Possible causes include a mismatch of ciphers or protocols.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>HealthyHostCount</code> </b> - The number of target instances that are considered healthy.</p> <p> <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and <code>Maximum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>HTTPCode_Instance_2XX_Count</code> </b> - The number of HTTP 2XX response codes generated by the target instances. This does not include any response codes generated by the load balancer.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>HTTPCode_Instance_3XX_Count</code> </b> - The number of HTTP 3XX response codes generated by the target instances. This does not include any response codes generated by the load balancer.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>HTTPCode_Instance_4XX_Count</code> </b> - The number of HTTP 4XX response codes generated by the target instances. This does not include any response codes generated by the load balancer.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>HTTPCode_Instance_5XX_Count</code> </b> - The number of HTTP 5XX response codes generated by the target instances. This does not include any response codes generated by the load balancer.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>HTTPCode_LB_4XX_Count</code> </b> - The number of HTTP 4XX client error codes that originated from the load balancer. Client errors are generated when requests are malformed or incomplete. These requests were not received by the target instance. This count does not include response codes generated by the target instances.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>HTTPCode_LB_5XX_Count</code> </b> - The number of HTTP 5XX server error codes that originated from the load balancer. This does not include any response codes generated by the target instance. This metric is reported if there are no healthy instances attached to the load balancer, or if the request rate exceeds the capacity of the instances (spillover) or the load balancer.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>InstanceResponseTime</code> </b> - The time elapsed, in seconds, after the request leaves the load balancer until a response from the target instance is received.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p> <p> <code>Unit</code>: The published unit is <code>Seconds</code>.</p> </li>
        /// <li> <p> <b> <code>RejectedConnectionCount</code> </b> - The number of connections that were rejected because the load balancer had reached its maximum number of connections.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>RequestCount</code> </b> - The number of requests processed over IPv4. This count includes only the requests with a response generated by a target instance of the load balancer.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>. Note that <code>Minimum</code>, <code>Maximum</code>, and <code>Average</code> all return <code>1</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>UnhealthyHostCount</code> </b> - The number of target instances that are considered unhealthy.</p> <p> <code>Statistics</code>: The most useful statistic are <code>Average</code>, <code>Minimum</code>, and <code>Maximum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// </ul>
        pub fn set_metric_name(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerMetricName>,
        ) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The granularity, in seconds, of the returned data points.</p>
        pub fn period(mut self, input: i32) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>The granularity, in seconds, of the returned data points.</p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.period = input;
            self
        }
        /// <p>The start time of the period.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time of the period.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time of the period.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time of the period.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The unit for the metric data request. Valid units depend on the metric data being requested. For the valid units with each available metric, see the <code>metricName</code> parameter.</p>
        pub fn unit(mut self, input: crate::model::MetricUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>The unit for the metric data request. Valid units depend on the metric data being requested. For the valid units with each available metric, see the <code>metricName</code> parameter.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::MetricUnit>) -> Self {
            self.unit = input;
            self
        }
        /// Appends an item to `statistics`.
        ///
        /// To override the contents of this collection use [`set_statistics`](Self::set_statistics).
        ///
        /// <p>The statistic for the metric.</p>
        /// <p>The following statistics are available:</p>
        /// <ul>
        /// <li> <p> <code>Minimum</code> - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Maximum</code> - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Sum</code> - All values submitted for the matching metric added together. You can use this statistic to determine the total volume of a metric.</p> </li>
        /// <li> <p> <code>Average</code> - The value of Sum / SampleCount during the specified period. By comparing this statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your resources.</p> </li>
        /// <li> <p> <code>SampleCount</code> - The count, or number, of data points used for the statistical calculation.</p> </li>
        /// </ul>
        pub fn statistics(mut self, input: crate::model::MetricStatistic) -> Self {
            let mut v = self.statistics.unwrap_or_default();
            v.push(input);
            self.statistics = Some(v);
            self
        }
        /// <p>The statistic for the metric.</p>
        /// <p>The following statistics are available:</p>
        /// <ul>
        /// <li> <p> <code>Minimum</code> - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Maximum</code> - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Sum</code> - All values submitted for the matching metric added together. You can use this statistic to determine the total volume of a metric.</p> </li>
        /// <li> <p> <code>Average</code> - The value of Sum / SampleCount during the specified period. By comparing this statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your resources.</p> </li>
        /// <li> <p> <code>SampleCount</code> - The count, or number, of data points used for the statistical calculation.</p> </li>
        /// </ul>
        pub fn set_statistics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MetricStatistic>>,
        ) -> Self {
            self.statistics = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLoadBalancerMetricDataInput`](crate::input::GetLoadBalancerMetricDataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLoadBalancerMetricDataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLoadBalancerMetricDataInput {
                load_balancer_name: self.load_balancer_name,
                metric_name: self.metric_name,
                period: self.period.unwrap_or_default(),
                start_time: self.start_time,
                end_time: self.end_time,
                unit: self.unit,
                statistics: self.statistics,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLoadBalancerMetricDataInputOperationOutputAlias =
    crate::operation::GetLoadBalancerMetricData;
#[doc(hidden)]
pub type GetLoadBalancerMetricDataInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetLoadBalancerMetricDataInput {
    /// Consumes the builder and constructs an Operation<[`GetLoadBalancerMetricData`](crate::operation::GetLoadBalancerMetricData)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLoadBalancerMetricData,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetLoadBalancerMetricDataInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetLoadBalancerMetricDataInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetLoadBalancerMetricData",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_load_balancer_metric_data(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLoadBalancerMetricData::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLoadBalancerMetricData",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetLoadBalancerMetricDataInput`](crate::input::GetLoadBalancerMetricDataInput)
    pub fn builder() -> crate::input::get_load_balancer_metric_data_input::Builder {
        crate::input::get_load_balancer_metric_data_input::Builder::default()
    }
}

/// See [`GetLoadBalancersInput`](crate::input::GetLoadBalancersInput)
pub mod get_load_balancers_input {
    /// A builder for [`GetLoadBalancersInput`](crate::input::GetLoadBalancersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetLoadBalancers</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetLoadBalancers</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLoadBalancersInput`](crate::input::GetLoadBalancersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLoadBalancersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLoadBalancersInput {
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLoadBalancersInputOperationOutputAlias = crate::operation::GetLoadBalancers;
#[doc(hidden)]
pub type GetLoadBalancersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetLoadBalancersInput {
    /// Consumes the builder and constructs an Operation<[`GetLoadBalancers`](crate::operation::GetLoadBalancers)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLoadBalancers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetLoadBalancersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetLoadBalancersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetLoadBalancers",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_load_balancers(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLoadBalancers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLoadBalancers",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetLoadBalancersInput`](crate::input::GetLoadBalancersInput)
    pub fn builder() -> crate::input::get_load_balancers_input::Builder {
        crate::input::get_load_balancers_input::Builder::default()
    }
}

/// See [`GetLoadBalancerTlsCertificatesInput`](crate::input::GetLoadBalancerTlsCertificatesInput)
pub mod get_load_balancer_tls_certificates_input {
    /// A builder for [`GetLoadBalancerTlsCertificatesInput`](crate::input::GetLoadBalancerTlsCertificatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the load balancer you associated with your SSL/TLS certificate.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer you associated with your SSL/TLS certificate.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLoadBalancerTlsCertificatesInput`](crate::input::GetLoadBalancerTlsCertificatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLoadBalancerTlsCertificatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLoadBalancerTlsCertificatesInput {
                load_balancer_name: self.load_balancer_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLoadBalancerTlsCertificatesInputOperationOutputAlias =
    crate::operation::GetLoadBalancerTlsCertificates;
#[doc(hidden)]
pub type GetLoadBalancerTlsCertificatesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetLoadBalancerTlsCertificatesInput {
    /// Consumes the builder and constructs an Operation<[`GetLoadBalancerTlsCertificates`](crate::operation::GetLoadBalancerTlsCertificates)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLoadBalancerTlsCertificates,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetLoadBalancerTlsCertificatesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetLoadBalancerTlsCertificatesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetLoadBalancerTlsCertificates",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_load_balancer_tls_certificates(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLoadBalancerTlsCertificates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLoadBalancerTlsCertificates",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetLoadBalancerTlsCertificatesInput`](crate::input::GetLoadBalancerTlsCertificatesInput)
    pub fn builder() -> crate::input::get_load_balancer_tls_certificates_input::Builder {
        crate::input::get_load_balancer_tls_certificates_input::Builder::default()
    }
}

/// See [`GetOperationInput`](crate::input::GetOperationInput)
pub mod get_operation_input {
    /// A builder for [`GetOperationInput`](crate::input::GetOperationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A GUID used to identify the operation.</p>
        pub fn operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_id = Some(input.into());
            self
        }
        /// <p>A GUID used to identify the operation.</p>
        pub fn set_operation_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOperationInput`](crate::input::GetOperationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOperationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOperationInput {
                operation_id: self.operation_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetOperationInputOperationOutputAlias = crate::operation::GetOperation;
#[doc(hidden)]
pub type GetOperationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetOperationInput {
    /// Consumes the builder and constructs an Operation<[`GetOperation`](crate::operation::GetOperation)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOperation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetOperationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetOperationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetOperation",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_operation(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOperation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOperation",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetOperationInput`](crate::input::GetOperationInput)
    pub fn builder() -> crate::input::get_operation_input::Builder {
        crate::input::get_operation_input::Builder::default()
    }
}

/// See [`GetOperationsInput`](crate::input::GetOperationsInput)
pub mod get_operations_input {
    /// A builder for [`GetOperationsInput`](crate::input::GetOperationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetOperations</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetOperations</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOperationsInput`](crate::input::GetOperationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOperationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOperationsInput {
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetOperationsInputOperationOutputAlias = crate::operation::GetOperations;
#[doc(hidden)]
pub type GetOperationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetOperationsInput {
    /// Consumes the builder and constructs an Operation<[`GetOperations`](crate::operation::GetOperations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOperations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetOperationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetOperationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetOperations",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_operations(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOperations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOperations",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetOperationsInput`](crate::input::GetOperationsInput)
    pub fn builder() -> crate::input::get_operations_input::Builder {
        crate::input::get_operations_input::Builder::default()
    }
}

/// See [`GetOperationsForResourceInput`](crate::input::GetOperationsForResourceInput)
pub mod get_operations_for_resource_input {
    /// A builder for [`GetOperationsForResourceInput`](crate::input::GetOperationsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the resource for which you are requesting information.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The name of the resource for which you are requesting information.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetOperationsForResource</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetOperationsForResource</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetOperationsForResourceInput`](crate::input::GetOperationsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetOperationsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetOperationsForResourceInput {
                resource_name: self.resource_name,
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetOperationsForResourceInputOperationOutputAlias =
    crate::operation::GetOperationsForResource;
#[doc(hidden)]
pub type GetOperationsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetOperationsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`GetOperationsForResource`](crate::operation::GetOperationsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetOperationsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetOperationsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetOperationsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetOperationsForResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_operations_for_resource(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetOperationsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetOperationsForResource",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetOperationsForResourceInput`](crate::input::GetOperationsForResourceInput)
    pub fn builder() -> crate::input::get_operations_for_resource_input::Builder {
        crate::input::get_operations_for_resource_input::Builder::default()
    }
}

/// See [`GetRegionsInput`](crate::input::GetRegionsInput)
pub mod get_regions_input {
    /// A builder for [`GetRegionsInput`](crate::input::GetRegionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) include_availability_zones: std::option::Option<bool>,
        pub(crate) include_relational_database_availability_zones: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A Boolean value indicating whether to also include Availability Zones in your get regions request. Availability Zones are indicated with a letter: e.g., <code>us-east-2a</code>.</p>
        pub fn include_availability_zones(mut self, input: bool) -> Self {
            self.include_availability_zones = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether to also include Availability Zones in your get regions request. Availability Zones are indicated with a letter: e.g., <code>us-east-2a</code>.</p>
        pub fn set_include_availability_zones(mut self, input: std::option::Option<bool>) -> Self {
            self.include_availability_zones = input;
            self
        }
        /// <p>A Boolean value indicating whether to also include Availability Zones for databases in your get regions request. Availability Zones are indicated with a letter (e.g., <code>us-east-2a</code>).</p>
        pub fn include_relational_database_availability_zones(mut self, input: bool) -> Self {
            self.include_relational_database_availability_zones = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether to also include Availability Zones for databases in your get regions request. Availability Zones are indicated with a letter (e.g., <code>us-east-2a</code>).</p>
        pub fn set_include_relational_database_availability_zones(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.include_relational_database_availability_zones = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRegionsInput`](crate::input::GetRegionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRegionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRegionsInput {
                include_availability_zones: self.include_availability_zones,
                include_relational_database_availability_zones: self
                    .include_relational_database_availability_zones,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRegionsInputOperationOutputAlias = crate::operation::GetRegions;
#[doc(hidden)]
pub type GetRegionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetRegionsInput {
    /// Consumes the builder and constructs an Operation<[`GetRegions`](crate::operation::GetRegions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRegions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetRegionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetRegionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetRegions",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_regions(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRegions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRegions",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetRegionsInput`](crate::input::GetRegionsInput)
    pub fn builder() -> crate::input::get_regions_input::Builder {
        crate::input::get_regions_input::Builder::default()
    }
}

/// See [`GetRelationalDatabaseInput`](crate::input::GetRelationalDatabaseInput)
pub mod get_relational_database_input {
    /// A builder for [`GetRelationalDatabaseInput`](crate::input::GetRelationalDatabaseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) relational_database_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the database that you are looking up.</p>
        pub fn relational_database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.relational_database_name = Some(input.into());
            self
        }
        /// <p>The name of the database that you are looking up.</p>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relational_database_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRelationalDatabaseInput`](crate::input::GetRelationalDatabaseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRelationalDatabaseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRelationalDatabaseInput {
                relational_database_name: self.relational_database_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRelationalDatabaseInputOperationOutputAlias = crate::operation::GetRelationalDatabase;
#[doc(hidden)]
pub type GetRelationalDatabaseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetRelationalDatabaseInput {
    /// Consumes the builder and constructs an Operation<[`GetRelationalDatabase`](crate::operation::GetRelationalDatabase)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRelationalDatabase,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetRelationalDatabaseInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetRelationalDatabaseInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetRelationalDatabase",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_relational_database(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRelationalDatabase::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRelationalDatabase",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetRelationalDatabaseInput`](crate::input::GetRelationalDatabaseInput)
    pub fn builder() -> crate::input::get_relational_database_input::Builder {
        crate::input::get_relational_database_input::Builder::default()
    }
}

/// See [`GetRelationalDatabaseBlueprintsInput`](crate::input::GetRelationalDatabaseBlueprintsInput)
pub mod get_relational_database_blueprints_input {
    /// A builder for [`GetRelationalDatabaseBlueprintsInput`](crate::input::GetRelationalDatabaseBlueprintsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetRelationalDatabaseBlueprints</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetRelationalDatabaseBlueprints</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRelationalDatabaseBlueprintsInput`](crate::input::GetRelationalDatabaseBlueprintsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRelationalDatabaseBlueprintsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRelationalDatabaseBlueprintsInput {
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRelationalDatabaseBlueprintsInputOperationOutputAlias =
    crate::operation::GetRelationalDatabaseBlueprints;
#[doc(hidden)]
pub type GetRelationalDatabaseBlueprintsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetRelationalDatabaseBlueprintsInput {
    /// Consumes the builder and constructs an Operation<[`GetRelationalDatabaseBlueprints`](crate::operation::GetRelationalDatabaseBlueprints)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRelationalDatabaseBlueprints,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetRelationalDatabaseBlueprintsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetRelationalDatabaseBlueprintsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetRelationalDatabaseBlueprints",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_relational_database_blueprints(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRelationalDatabaseBlueprints::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRelationalDatabaseBlueprints",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetRelationalDatabaseBlueprintsInput`](crate::input::GetRelationalDatabaseBlueprintsInput)
    pub fn builder() -> crate::input::get_relational_database_blueprints_input::Builder {
        crate::input::get_relational_database_blueprints_input::Builder::default()
    }
}

/// See [`GetRelationalDatabaseBundlesInput`](crate::input::GetRelationalDatabaseBundlesInput)
pub mod get_relational_database_bundles_input {
    /// A builder for [`GetRelationalDatabaseBundlesInput`](crate::input::GetRelationalDatabaseBundlesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetRelationalDatabaseBundles</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetRelationalDatabaseBundles</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRelationalDatabaseBundlesInput`](crate::input::GetRelationalDatabaseBundlesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRelationalDatabaseBundlesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRelationalDatabaseBundlesInput {
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRelationalDatabaseBundlesInputOperationOutputAlias =
    crate::operation::GetRelationalDatabaseBundles;
#[doc(hidden)]
pub type GetRelationalDatabaseBundlesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetRelationalDatabaseBundlesInput {
    /// Consumes the builder and constructs an Operation<[`GetRelationalDatabaseBundles`](crate::operation::GetRelationalDatabaseBundles)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRelationalDatabaseBundles,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetRelationalDatabaseBundlesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetRelationalDatabaseBundlesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetRelationalDatabaseBundles",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_relational_database_bundles(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRelationalDatabaseBundles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRelationalDatabaseBundles",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetRelationalDatabaseBundlesInput`](crate::input::GetRelationalDatabaseBundlesInput)
    pub fn builder() -> crate::input::get_relational_database_bundles_input::Builder {
        crate::input::get_relational_database_bundles_input::Builder::default()
    }
}

/// See [`GetRelationalDatabaseEventsInput`](crate::input::GetRelationalDatabaseEventsInput)
pub mod get_relational_database_events_input {
    /// A builder for [`GetRelationalDatabaseEventsInput`](crate::input::GetRelationalDatabaseEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) relational_database_name: std::option::Option<std::string::String>,
        pub(crate) duration_in_minutes: std::option::Option<i32>,
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the database from which to get events.</p>
        pub fn relational_database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.relational_database_name = Some(input.into());
            self
        }
        /// <p>The name of the database from which to get events.</p>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relational_database_name = input;
            self
        }
        /// <p>The number of minutes in the past from which to retrieve events. For example, to get all events from the past 2 hours, enter 120.</p>
        /// <p>Default: <code>60</code> </p>
        /// <p>The minimum is 1 and the maximum is 14 days (20160 minutes).</p>
        pub fn duration_in_minutes(mut self, input: i32) -> Self {
            self.duration_in_minutes = Some(input);
            self
        }
        /// <p>The number of minutes in the past from which to retrieve events. For example, to get all events from the past 2 hours, enter 120.</p>
        /// <p>Default: <code>60</code> </p>
        /// <p>The minimum is 1 and the maximum is 14 days (20160 minutes).</p>
        pub fn set_duration_in_minutes(mut self, input: std::option::Option<i32>) -> Self {
            self.duration_in_minutes = input;
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetRelationalDatabaseEvents</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetRelationalDatabaseEvents</code> request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRelationalDatabaseEventsInput`](crate::input::GetRelationalDatabaseEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRelationalDatabaseEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRelationalDatabaseEventsInput {
                relational_database_name: self.relational_database_name,
                duration_in_minutes: self.duration_in_minutes,
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRelationalDatabaseEventsInputOperationOutputAlias =
    crate::operation::GetRelationalDatabaseEvents;
#[doc(hidden)]
pub type GetRelationalDatabaseEventsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetRelationalDatabaseEventsInput {
    /// Consumes the builder and constructs an Operation<[`GetRelationalDatabaseEvents`](crate::operation::GetRelationalDatabaseEvents)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRelationalDatabaseEvents,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetRelationalDatabaseEventsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetRelationalDatabaseEventsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetRelationalDatabaseEvents",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_relational_database_events(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRelationalDatabaseEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRelationalDatabaseEvents",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetRelationalDatabaseEventsInput`](crate::input::GetRelationalDatabaseEventsInput)
    pub fn builder() -> crate::input::get_relational_database_events_input::Builder {
        crate::input::get_relational_database_events_input::Builder::default()
    }
}

/// See [`GetRelationalDatabaseLogEventsInput`](crate::input::GetRelationalDatabaseLogEventsInput)
pub mod get_relational_database_log_events_input {
    /// A builder for [`GetRelationalDatabaseLogEventsInput`](crate::input::GetRelationalDatabaseLogEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) relational_database_name: std::option::Option<std::string::String>,
        pub(crate) log_stream_name: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) start_from_head: std::option::Option<bool>,
        pub(crate) page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of your database for which to get log events.</p>
        pub fn relational_database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.relational_database_name = Some(input.into());
            self
        }
        /// <p>The name of your database for which to get log events.</p>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relational_database_name = input;
            self
        }
        /// <p>The name of the log stream.</p>
        /// <p>Use the <code>get relational database log streams</code> operation to get a list of available log streams.</p>
        pub fn log_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_stream_name = Some(input.into());
            self
        }
        /// <p>The name of the log stream.</p>
        /// <p>Use the <code>get relational database log streams</code> operation to get a list of available log streams.</p>
        pub fn set_log_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_stream_name = input;
            self
        }
        /// <p>The start of the time interval from which to get log events.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Specified in Coordinated Universal Time (UTC).</p> </li>
        /// <li> <p>Specified in the Unix time format.</p> <p>For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you input <code>1538424000</code> as the start time.</p> </li>
        /// </ul>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start of the time interval from which to get log events.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Specified in Coordinated Universal Time (UTC).</p> </li>
        /// <li> <p>Specified in the Unix time format.</p> <p>For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you input <code>1538424000</code> as the start time.</p> </li>
        /// </ul>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end of the time interval from which to get log events.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Specified in Coordinated Universal Time (UTC).</p> </li>
        /// <li> <p>Specified in the Unix time format.</p> <p>For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you input <code>1538424000</code> as the end time.</p> </li>
        /// </ul>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end of the time interval from which to get log events.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Specified in Coordinated Universal Time (UTC).</p> </li>
        /// <li> <p>Specified in the Unix time format.</p> <p>For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you input <code>1538424000</code> as the end time.</p> </li>
        /// </ul>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>Parameter to specify if the log should start from head or tail. If <code>true</code> is specified, the log event starts from the head of the log. If <code>false</code> is specified, the log event starts from the tail of the log.</p> <note>
        /// <p>For PostgreSQL, the default value of <code>false</code> is the only option available.</p>
        /// </note>
        pub fn start_from_head(mut self, input: bool) -> Self {
            self.start_from_head = Some(input);
            self
        }
        /// <p>Parameter to specify if the log should start from head or tail. If <code>true</code> is specified, the log event starts from the head of the log. If <code>false</code> is specified, the log event starts from the tail of the log.</p> <note>
        /// <p>For PostgreSQL, the default value of <code>false</code> is the only option available.</p>
        /// </note>
        pub fn set_start_from_head(mut self, input: std::option::Option<bool>) -> Self {
            self.start_from_head = input;
            self
        }
        /// <p>The token to advance to the next or previous page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetRelationalDatabaseLogEvents</code> request. If your results are paginated, the response will return a next forward token and/or next backward token that you can specify as the page token in a subsequent request.</p>
        pub fn page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_token = Some(input.into());
            self
        }
        /// <p>The token to advance to the next or previous page of results from your request.</p>
        /// <p>To get a page token, perform an initial <code>GetRelationalDatabaseLogEvents</code> request. If your results are paginated, the response will return a next forward token and/or next backward token that you can specify as the page token in a subsequent request.</p>
        pub fn set_page_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRelationalDatabaseLogEventsInput`](crate::input::GetRelationalDatabaseLogEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRelationalDatabaseLogEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRelationalDatabaseLogEventsInput {
                relational_database_name: self.relational_database_name,
                log_stream_name: self.log_stream_name,
                start_time: self.start_time,
                end_time: self.end_time,
                start_from_head: self.start_from_head,
                page_token: self.page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRelationalDatabaseLogEventsInputOperationOutputAlias =
    crate::operation::GetRelationalDatabaseLogEvents;
#[doc(hidden)]
pub type GetRelationalDatabaseLogEventsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetRelationalDatabaseLogEventsInput {
    /// Consumes the builder and constructs an Operation<[`GetRelationalDatabaseLogEvents`](crate::operation::GetRelationalDatabaseLogEvents)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRelationalDatabaseLogEvents,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetRelationalDatabaseLogEventsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetRelationalDatabaseLogEventsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetRelationalDatabaseLogEvents",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_relational_database_log_events(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRelationalDatabaseLogEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRelationalDatabaseLogEvents",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetRelationalDatabaseLogEventsInput`](crate::input::GetRelationalDatabaseLogEventsInput)
    pub fn builder() -> crate::input::get_relational_database_log_events_input::Builder {
        crate::input::get_relational_database_log_events_input::Builder::default()
    }
}

/// See [`GetRelationalDatabaseLogStreamsInput`](crate::input::GetRelationalDatabaseLogStreamsInput)
pub mod get_relational_database_log_streams_input {
    /// A builder for [`GetRelationalDatabaseLogStreamsInput`](crate::input::GetRelationalDatabaseLogStreamsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) relational_database_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of your database for which to get log streams.</p>
        pub fn relational_database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.relational_database_name = Some(input.into());
            self
        }
        /// <p>The name of your database for which to get log streams.</p>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relational_database_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRelationalDatabaseLogStreamsInput`](crate::input::GetRelationalDatabaseLogStreamsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRelationalDatabaseLogStreamsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRelationalDatabaseLogStreamsInput {
                relational_database_name: self.relational_database_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRelationalDatabaseLogStreamsInputOperationOutputAlias =
    crate::operation::GetRelationalDatabaseLogStreams;
#[doc(hidden)]
pub type GetRelationalDatabaseLogStreamsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetRelationalDatabaseLogStreamsInput {
    /// Consumes the builder and constructs an Operation<[`GetRelationalDatabaseLogStreams`](crate::operation::GetRelationalDatabaseLogStreams)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRelationalDatabaseLogStreams,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetRelationalDatabaseLogStreamsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetRelationalDatabaseLogStreamsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetRelationalDatabaseLogStreams",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_relational_database_log_streams(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRelationalDatabaseLogStreams::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRelationalDatabaseLogStreams",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetRelationalDatabaseLogStreamsInput`](crate::input::GetRelationalDatabaseLogStreamsInput)
    pub fn builder() -> crate::input::get_relational_database_log_streams_input::Builder {
        crate::input::get_relational_database_log_streams_input::Builder::default()
    }
}

/// See [`GetRelationalDatabaseMasterUserPasswordInput`](crate::input::GetRelationalDatabaseMasterUserPasswordInput)
pub mod get_relational_database_master_user_password_input {
    /// A builder for [`GetRelationalDatabaseMasterUserPasswordInput`](crate::input::GetRelationalDatabaseMasterUserPasswordInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) relational_database_name: std::option::Option<std::string::String>,
        pub(crate) password_version:
            std::option::Option<crate::model::RelationalDatabasePasswordVersion>,
    }
    impl Builder {
        /// <p>The name of your database for which to get the master user password.</p>
        pub fn relational_database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.relational_database_name = Some(input.into());
            self
        }
        /// <p>The name of your database for which to get the master user password.</p>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relational_database_name = input;
            self
        }
        /// <p>The password version to return.</p>
        /// <p>Specifying <code>CURRENT</code> or <code>PREVIOUS</code> returns the current or previous passwords respectively. Specifying <code>PENDING</code> returns the newest version of the password that will rotate to <code>CURRENT</code>. After the <code>PENDING</code> password rotates to <code>CURRENT</code>, the <code>PENDING</code> password is no longer available.</p>
        /// <p>Default: <code>CURRENT</code> </p>
        pub fn password_version(
            mut self,
            input: crate::model::RelationalDatabasePasswordVersion,
        ) -> Self {
            self.password_version = Some(input);
            self
        }
        /// <p>The password version to return.</p>
        /// <p>Specifying <code>CURRENT</code> or <code>PREVIOUS</code> returns the current or previous passwords respectively. Specifying <code>PENDING</code> returns the newest version of the password that will rotate to <code>CURRENT</code>. After the <code>PENDING</code> password rotates to <code>CURRENT</code>, the <code>PENDING</code> password is no longer available.</p>
        /// <p>Default: <code>CURRENT</code> </p>
        pub fn set_password_version(
            mut self,
            input: std::option::Option<crate::model::RelationalDatabasePasswordVersion>,
        ) -> Self {
            self.password_version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRelationalDatabaseMasterUserPasswordInput`](crate::input::GetRelationalDatabaseMasterUserPasswordInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRelationalDatabaseMasterUserPasswordInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRelationalDatabaseMasterUserPasswordInput {
                relational_database_name: self.relational_database_name,
                password_version: self.password_version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRelationalDatabaseMasterUserPasswordInputOperationOutputAlias =
    crate::operation::GetRelationalDatabaseMasterUserPassword;
#[doc(hidden)]
pub type GetRelationalDatabaseMasterUserPasswordInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetRelationalDatabaseMasterUserPasswordInput {
    /// Consumes the builder and constructs an Operation<[`GetRelationalDatabaseMasterUserPassword`](crate::operation::GetRelationalDatabaseMasterUserPassword)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRelationalDatabaseMasterUserPassword,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetRelationalDatabaseMasterUserPasswordInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetRelationalDatabaseMasterUserPasswordInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "Lightsail_20161128.GetRelationalDatabaseMasterUserPassword",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_relational_database_master_user_password(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRelationalDatabaseMasterUserPassword::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRelationalDatabaseMasterUserPassword",
            "lightsail",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetRelationalDatabaseMasterUserPasswordInput`](crate::input::GetRelationalDatabaseMasterUserPasswordInput)
    pub fn builder() -> crate::input::get_relational_database_master_user_password_input::Builder {
        crate::input::get_relational_database_master_user_password_input::Builder::default()
    }
}

/// See [`GetRelationalDatabaseMetricDataInput`](crate::input::GetRelationalDatabaseMetricDataInput)
pub mod get_relational_database_metric_data_input {
    /// A builder for [`GetRelationalDatabaseMetricDataInput`](crate::input::GetRelationalDatabaseMetricDataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) relational_database_name: std::option::Option<std::string::String>,
        pub(crate) metric_name: std::option::Option<crate::model::RelationalDatabaseMetricName>,
        pub(crate) period: std::option::Option<i32>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) unit: std::option::Option<crate::model::MetricUnit>,
        pub(crate) statistics: std::option::Option<std::vec::Vec<crate::model::MetricStatistic>>,
    }
    impl Builder {
        /// <p>The name of your database from which to get metric data.</p>
        pub fn relational_database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.relational_database_name = Some(input.into());
            self
        }
        /// <p>The name of your database from which to get metric data.</p>
        pub fn set_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relational_database_name = input;
            self
        }
        /// <p>The metric for which you want to return information.</p>
        /// <p>Valid relational database metric names are listed below, along with the most useful <code>statistics</code> to include in your request, and the published <code>unit</code> value. All relational database metric data is available in 1-minute (60 seconds) granularity.</p>
        /// <ul>
        /// <li> <p> <b> <code>CPUUtilization</code> </b> - The percentage of CPU utilization currently in use on the database.</p> <p> <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Average</code>.</p> <p> <code>Unit</code>: The published unit is <code>Percent</code>.</p> </li>
        /// <li> <p> <b> <code>DatabaseConnections</code> </b> - The number of database connections in use.</p> <p> <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>DiskQueueDepth</code> </b> - The number of outstanding IOs (read/write requests) that are waiting to access the disk.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>FreeStorageSpace</code> </b> - The amount of available storage space.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Bytes</code>.</p> </li>
        /// <li> <p> <b> <code>NetworkReceiveThroughput</code> </b> - The incoming (Receive) network traffic on the database, including both customer database traffic and AWS traffic used for monitoring and replication.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p> <p> <code>Unit</code>: The published unit is <code>Bytes/Second</code>.</p> </li>
        /// <li> <p> <b> <code>NetworkTransmitThroughput</code> </b> - The outgoing (Transmit) network traffic on the database, including both customer database traffic and AWS traffic used for monitoring and replication.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p> <p> <code>Unit</code>: The published unit is <code>Bytes/Second</code>.</p> </li>
        /// </ul>
        pub fn metric_name(mut self, input: crate::model::RelationalDatabaseMetricName) -> Self {
            self.metric_name = Some(input);
            self
        }
        /// <p>The metric for which you want to return information.</p>
        /// <p>Valid relational database metric names are listed below, along with the most useful <code>statistics</code> to include in your request, and the published <code>unit</code> value. All relational database metric data is available in 1-minute (60 seconds) granularity.</p>
        /// <ul>
        /// <li> <p> <b> <code>CPUUtilization</code> </b> - The percentage of CPU utilization currently in use on the database.</p> <p> <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Average</code>.</p> <p> <code>Unit</code>: The published unit is <code>Percent</code>.</p> </li>
        /// <li> <p> <b> <code>DatabaseConnections</code> </b> - The number of database connections in use.</p> <p> <code>Statistics</code>: The most useful statistics are <code>Maximum</code> and <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>DiskQueueDepth</code> </b> - The number of outstanding IOs (read/write requests) that are waiting to access the disk.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Count</code>.</p> </li>
        /// <li> <p> <b> <code>FreeStorageSpace</code> </b> - The amount of available storage space.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Sum</code>.</p> <p> <code>Unit</code>: The published unit is <code>Bytes</code>.</p> </li>
        /// <li> <p> <b> <code>NetworkReceiveThroughput</code> </b> - The incoming (Receive) network traffic on the database, including both customer database traffic and AWS traffic used for monitoring and replication.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p> <p> <code>Unit</code>: The published unit is <code>Bytes/Second</code>.</p> </li>
        /// <li> <p> <b> <code>NetworkTransmitThroughput</code> </b> - The outgoing (Transmit) network traffic on the database, including both customer database traffic and AWS traffic used for monitoring and replication.</p> <p> <code>Statistics</code>: The most useful statistic is <code>Average</code>.</p> <p> <code>Unit</code>: The published unit is <code>Bytes/Second</code>.</p> </li>
        /// </ul>
        pub fn set_metric_name(
            mut self,
            input: std::option::Option<crate::model::RelationalDatabaseMetricName>,
        ) -> Self {
            self.metric_name = input;
            self
        }
        /// <p>The granularity, in seconds, of the returned data points.</p>
        /// <p>All relational database metric data is available in 1-minute (60 seconds) granularity.</p>
        pub fn period(mut self, input: i32) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>The granularity, in seconds, of the returned data points.</p>
        /// <p>All relational database metric data is available in 1-minute (60 seconds) granularity.</p>
        pub fn set_period(mut self, input: std::option::Option<i32>) -> Self {
            self.period = input;
            self
        }
        /// <p>The start of the time interval from which to get metric data.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Specified in Coordinated Universal Time (UTC).</p> </li>
        /// <li> <p>Specified in the Unix time format.</p> <p>For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you input <code>1538424000</code> as the start time.</p> </li>
        /// </ul>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start of the time interval from which to get metric data.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Specified in Coordinated Universal Time (UTC).</p> </li>
        /// <li> <p>Specified in the Unix time format.</p> <p>For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you input <code>1538424000</code> as the start time.</p> </li>
        /// </ul>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end of the time interval from which to get metric data.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Specified in Coordinated Universal Time (UTC).</p> </li>
        /// <li> <p>Specified in the Unix time format.</p> <p>For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you input <code>1538424000</code> as the end time.</p> </li>
        /// </ul>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end of the time interval from which to get metric data.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Specified in Coordinated Universal Time (UTC).</p> </li>
        /// <li> <p>Specified in the Unix time format.</p> <p>For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you input <code>1538424000</code> as the end time.</p> </li>
        /// </ul>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The unit for the metric data request. Valid units depend on the metric data being requested. For the valid units with each available metric, see the <code>metricName</code> parameter.</p>
        pub fn unit(mut self, input: crate::model::MetricUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>The unit for the metric data request. Valid units depend on the metric data being requested. For the valid units with each available metric, see the <code>metricName</code> parameter.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::MetricUnit>) -> Self {
            self.unit = input;
            self
        }
        /// Appends an item to `statistics`.
        ///
        /// To override the contents of this collection use [`set_statistics`](Self::set_statistics).
        ///
        /// <p>The statistic for the metric.</p>
        /// <p>The following statistics are available:</p>
        /// <ul>
        /// <li> <p> <code>Minimum</code> - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Maximum</code> - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Sum</code> - All values submitted for the matching metric added together. You can use this statistic to determine the total volume of a metric.</p> </li>
        /// <li> <p> <code>Average</code> - The value of Sum / SampleCount during the specified period. By comparing this statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your resources.</p> </li>
        /// <li> <p> <code>SampleCount</code> - The count, or number, of data points used for the statistical calculation.</p> </li>
        /// </ul>
        pub fn statistics(mut self, input: crate::model::MetricStatistic) -> Self {
            let mut v = self.statistics.unwrap_or_default();
            v.push(input);
            self.statistics = Some(v);
            self
        }
        /// <p>The statistic for the metric.</p>
        /// <p>The following statistics are available:</p>
        /// <ul>
        /// <li> <p> <code>Minimum</code> - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Maximum</code> - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.</p> </li>
        /// <li> <p> <code>Sum</code> - All values submitted for the matching metric added t