// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AllocateStaticIp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`allocate_static_ip`](crate::client::Client::allocate_static_ip).
///
/// See [`crate::client::fluent_builders::AllocateStaticIp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AllocateStaticIp {
    _private: (),
}
impl AllocateStaticIp {
    /// Creates a new builder-style object to manufacture [`AllocateStaticIpInput`](crate::input::AllocateStaticIpInput)
    pub fn builder() -> crate::input::allocate_static_ip_input::Builder {
        crate::input::allocate_static_ip_input::Builder::default()
    }
    /// Creates a new `AllocateStaticIp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AllocateStaticIp {
    type Output = std::result::Result<
        crate::output::AllocateStaticIpOutput,
        crate::error::AllocateStaticIpError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_allocate_static_ip_error(response)
        } else {
            crate::operation_deser::parse_allocate_static_ip_response(response)
        }
    }
}

/// Operation shape for `AttachCertificateToDistribution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_certificate_to_distribution`](crate::client::Client::attach_certificate_to_distribution).
///
/// See [`crate::client::fluent_builders::AttachCertificateToDistribution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachCertificateToDistribution {
    _private: (),
}
impl AttachCertificateToDistribution {
    /// Creates a new builder-style object to manufacture [`AttachCertificateToDistributionInput`](crate::input::AttachCertificateToDistributionInput)
    pub fn builder() -> crate::input::attach_certificate_to_distribution_input::Builder {
        crate::input::attach_certificate_to_distribution_input::Builder::default()
    }
    /// Creates a new `AttachCertificateToDistribution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachCertificateToDistribution {
    type Output = std::result::Result<
        crate::output::AttachCertificateToDistributionOutput,
        crate::error::AttachCertificateToDistributionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_certificate_to_distribution_error(response)
        } else {
            crate::operation_deser::parse_attach_certificate_to_distribution_response(response)
        }
    }
}

/// Operation shape for `AttachDisk`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_disk`](crate::client::Client::attach_disk).
///
/// See [`crate::client::fluent_builders::AttachDisk`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachDisk {
    _private: (),
}
impl AttachDisk {
    /// Creates a new builder-style object to manufacture [`AttachDiskInput`](crate::input::AttachDiskInput)
    pub fn builder() -> crate::input::attach_disk_input::Builder {
        crate::input::attach_disk_input::Builder::default()
    }
    /// Creates a new `AttachDisk` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachDisk {
    type Output =
        std::result::Result<crate::output::AttachDiskOutput, crate::error::AttachDiskError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_disk_error(response)
        } else {
            crate::operation_deser::parse_attach_disk_response(response)
        }
    }
}

/// Operation shape for `AttachInstancesToLoadBalancer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_instances_to_load_balancer`](crate::client::Client::attach_instances_to_load_balancer).
///
/// See [`crate::client::fluent_builders::AttachInstancesToLoadBalancer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachInstancesToLoadBalancer {
    _private: (),
}
impl AttachInstancesToLoadBalancer {
    /// Creates a new builder-style object to manufacture [`AttachInstancesToLoadBalancerInput`](crate::input::AttachInstancesToLoadBalancerInput)
    pub fn builder() -> crate::input::attach_instances_to_load_balancer_input::Builder {
        crate::input::attach_instances_to_load_balancer_input::Builder::default()
    }
    /// Creates a new `AttachInstancesToLoadBalancer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachInstancesToLoadBalancer {
    type Output = std::result::Result<
        crate::output::AttachInstancesToLoadBalancerOutput,
        crate::error::AttachInstancesToLoadBalancerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_instances_to_load_balancer_error(response)
        } else {
            crate::operation_deser::parse_attach_instances_to_load_balancer_response(response)
        }
    }
}

/// Operation shape for `AttachLoadBalancerTlsCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_load_balancer_tls_certificate`](crate::client::Client::attach_load_balancer_tls_certificate).
///
/// See [`crate::client::fluent_builders::AttachLoadBalancerTlsCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachLoadBalancerTlsCertificate {
    _private: (),
}
impl AttachLoadBalancerTlsCertificate {
    /// Creates a new builder-style object to manufacture [`AttachLoadBalancerTlsCertificateInput`](crate::input::AttachLoadBalancerTlsCertificateInput)
    pub fn builder() -> crate::input::attach_load_balancer_tls_certificate_input::Builder {
        crate::input::attach_load_balancer_tls_certificate_input::Builder::default()
    }
    /// Creates a new `AttachLoadBalancerTlsCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachLoadBalancerTlsCertificate {
    type Output = std::result::Result<
        crate::output::AttachLoadBalancerTlsCertificateOutput,
        crate::error::AttachLoadBalancerTlsCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_load_balancer_tls_certificate_error(response)
        } else {
            crate::operation_deser::parse_attach_load_balancer_tls_certificate_response(response)
        }
    }
}

/// Operation shape for `AttachStaticIp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`attach_static_ip`](crate::client::Client::attach_static_ip).
///
/// See [`crate::client::fluent_builders::AttachStaticIp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AttachStaticIp {
    _private: (),
}
impl AttachStaticIp {
    /// Creates a new builder-style object to manufacture [`AttachStaticIpInput`](crate::input::AttachStaticIpInput)
    pub fn builder() -> crate::input::attach_static_ip_input::Builder {
        crate::input::attach_static_ip_input::Builder::default()
    }
    /// Creates a new `AttachStaticIp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AttachStaticIp {
    type Output =
        std::result::Result<crate::output::AttachStaticIpOutput, crate::error::AttachStaticIpError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_attach_static_ip_error(response)
        } else {
            crate::operation_deser::parse_attach_static_ip_response(response)
        }
    }
}

/// Operation shape for `CloseInstancePublicPorts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`close_instance_public_ports`](crate::client::Client::close_instance_public_ports).
///
/// See [`crate::client::fluent_builders::CloseInstancePublicPorts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CloseInstancePublicPorts {
    _private: (),
}
impl CloseInstancePublicPorts {
    /// Creates a new builder-style object to manufacture [`CloseInstancePublicPortsInput`](crate::input::CloseInstancePublicPortsInput)
    pub fn builder() -> crate::input::close_instance_public_ports_input::Builder {
        crate::input::close_instance_public_ports_input::Builder::default()
    }
    /// Creates a new `CloseInstancePublicPorts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CloseInstancePublicPorts {
    type Output = std::result::Result<
        crate::output::CloseInstancePublicPortsOutput,
        crate::error::CloseInstancePublicPortsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_close_instance_public_ports_error(response)
        } else {
            crate::operation_deser::parse_close_instance_public_ports_response(response)
        }
    }
}

/// Operation shape for `CopySnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`copy_snapshot`](crate::client::Client::copy_snapshot).
///
/// See [`crate::client::fluent_builders::CopySnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CopySnapshot {
    _private: (),
}
impl CopySnapshot {
    /// Creates a new builder-style object to manufacture [`CopySnapshotInput`](crate::input::CopySnapshotInput)
    pub fn builder() -> crate::input::copy_snapshot_input::Builder {
        crate::input::copy_snapshot_input::Builder::default()
    }
    /// Creates a new `CopySnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CopySnapshot {
    type Output =
        std::result::Result<crate::output::CopySnapshotOutput, crate::error::CopySnapshotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_copy_snapshot_error(response)
        } else {
            crate::operation_deser::parse_copy_snapshot_response(response)
        }
    }
}

/// Operation shape for `CreateBucket`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_bucket`](crate::client::Client::create_bucket).
///
/// See [`crate::client::fluent_builders::CreateBucket`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBucket {
    _private: (),
}
impl CreateBucket {
    /// Creates a new builder-style object to manufacture [`CreateBucketInput`](crate::input::CreateBucketInput)
    pub fn builder() -> crate::input::create_bucket_input::Builder {
        crate::input::create_bucket_input::Builder::default()
    }
    /// Creates a new `CreateBucket` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBucket {
    type Output =
        std::result::Result<crate::output::CreateBucketOutput, crate::error::CreateBucketError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_bucket_error(response)
        } else {
            crate::operation_deser::parse_create_bucket_response(response)
        }
    }
}

/// Operation shape for `CreateBucketAccessKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_bucket_access_key`](crate::client::Client::create_bucket_access_key).
///
/// See [`crate::client::fluent_builders::CreateBucketAccessKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateBucketAccessKey {
    _private: (),
}
impl CreateBucketAccessKey {
    /// Creates a new builder-style object to manufacture [`CreateBucketAccessKeyInput`](crate::input::CreateBucketAccessKeyInput)
    pub fn builder() -> crate::input::create_bucket_access_key_input::Builder {
        crate::input::create_bucket_access_key_input::Builder::default()
    }
    /// Creates a new `CreateBucketAccessKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateBucketAccessKey {
    type Output = std::result::Result<
        crate::output::CreateBucketAccessKeyOutput,
        crate::error::CreateBucketAccessKeyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_bucket_access_key_error(response)
        } else {
            crate::operation_deser::parse_create_bucket_access_key_response(response)
        }
    }
}

/// Operation shape for `CreateCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_certificate`](crate::client::Client::create_certificate).
///
/// See [`crate::client::fluent_builders::CreateCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCertificate {
    _private: (),
}
impl CreateCertificate {
    /// Creates a new builder-style object to manufacture [`CreateCertificateInput`](crate::input::CreateCertificateInput)
    pub fn builder() -> crate::input::create_certificate_input::Builder {
        crate::input::create_certificate_input::Builder::default()
    }
    /// Creates a new `CreateCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCertificate {
    type Output = std::result::Result<
        crate::output::CreateCertificateOutput,
        crate::error::CreateCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_certificate_error(response)
        } else {
            crate::operation_deser::parse_create_certificate_response(response)
        }
    }
}

/// Operation shape for `CreateCloudFormationStack`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_cloud_formation_stack`](crate::client::Client::create_cloud_formation_stack).
///
/// See [`crate::client::fluent_builders::CreateCloudFormationStack`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCloudFormationStack {
    _private: (),
}
impl CreateCloudFormationStack {
    /// Creates a new builder-style object to manufacture [`CreateCloudFormationStackInput`](crate::input::CreateCloudFormationStackInput)
    pub fn builder() -> crate::input::create_cloud_formation_stack_input::Builder {
        crate::input::create_cloud_formation_stack_input::Builder::default()
    }
    /// Creates a new `CreateCloudFormationStack` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCloudFormationStack {
    type Output = std::result::Result<
        crate::output::CreateCloudFormationStackOutput,
        crate::error::CreateCloudFormationStackError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_cloud_formation_stack_error(response)
        } else {
            crate::operation_deser::parse_create_cloud_formation_stack_response(response)
        }
    }
}

/// Operation shape for `CreateContactMethod`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_contact_method`](crate::client::Client::create_contact_method).
///
/// See [`crate::client::fluent_builders::CreateContactMethod`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateContactMethod {
    _private: (),
}
impl CreateContactMethod {
    /// Creates a new builder-style object to manufacture [`CreateContactMethodInput`](crate::input::CreateContactMethodInput)
    pub fn builder() -> crate::input::create_contact_method_input::Builder {
        crate::input::create_contact_method_input::Builder::default()
    }
    /// Creates a new `CreateContactMethod` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateContactMethod {
    type Output = std::result::Result<
        crate::output::CreateContactMethodOutput,
        crate::error::CreateContactMethodError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_contact_method_error(response)
        } else {
            crate::operation_deser::parse_create_contact_method_response(response)
        }
    }
}

/// Operation shape for `CreateContainerService`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_container_service`](crate::client::Client::create_container_service).
///
/// See [`crate::client::fluent_builders::CreateContainerService`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateContainerService {
    _private: (),
}
impl CreateContainerService {
    /// Creates a new builder-style object to manufacture [`CreateContainerServiceInput`](crate::input::CreateContainerServiceInput)
    pub fn builder() -> crate::input::create_container_service_input::Builder {
        crate::input::create_container_service_input::Builder::default()
    }
    /// Creates a new `CreateContainerService` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateContainerService {
    type Output = std::result::Result<
        crate::output::CreateContainerServiceOutput,
        crate::error::CreateContainerServiceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_container_service_error(response)
        } else {
            crate::operation_deser::parse_create_container_service_response(response)
        }
    }
}

/// Operation shape for `CreateContainerServiceDeployment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_container_service_deployment`](crate::client::Client::create_container_service_deployment).
///
/// See [`crate::client::fluent_builders::CreateContainerServiceDeployment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateContainerServiceDeployment {
    _private: (),
}
impl CreateContainerServiceDeployment {
    /// Creates a new builder-style object to manufacture [`CreateContainerServiceDeploymentInput`](crate::input::CreateContainerServiceDeploymentInput)
    pub fn builder() -> crate::input::create_container_service_deployment_input::Builder {
        crate::input::create_container_service_deployment_input::Builder::default()
    }
    /// Creates a new `CreateContainerServiceDeployment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateContainerServiceDeployment {
    type Output = std::result::Result<
        crate::output::CreateContainerServiceDeploymentOutput,
        crate::error::CreateContainerServiceDeploymentError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_container_service_deployment_error(response)
        } else {
            crate::operation_deser::parse_create_container_service_deployment_response(response)
        }
    }
}

/// Operation shape for `CreateContainerServiceRegistryLogin`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_container_service_registry_login`](crate::client::Client::create_container_service_registry_login).
///
/// See [`crate::client::fluent_builders::CreateContainerServiceRegistryLogin`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateContainerServiceRegistryLogin {
    _private: (),
}
impl CreateContainerServiceRegistryLogin {
    /// Creates a new builder-style object to manufacture [`CreateContainerServiceRegistryLoginInput`](crate::input::CreateContainerServiceRegistryLoginInput)
    pub fn builder() -> crate::input::create_container_service_registry_login_input::Builder {
        crate::input::create_container_service_registry_login_input::Builder::default()
    }
    /// Creates a new `CreateContainerServiceRegistryLogin` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateContainerServiceRegistryLogin {
    type Output = std::result::Result<
        crate::output::CreateContainerServiceRegistryLoginOutput,
        crate::error::CreateContainerServiceRegistryLoginError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_container_service_registry_login_error(response)
        } else {
            crate::operation_deser::parse_create_container_service_registry_login_response(response)
        }
    }
}

/// Operation shape for `CreateDisk`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_disk`](crate::client::Client::create_disk).
///
/// See [`crate::client::fluent_builders::CreateDisk`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDisk {
    _private: (),
}
impl CreateDisk {
    /// Creates a new builder-style object to manufacture [`CreateDiskInput`](crate::input::CreateDiskInput)
    pub fn builder() -> crate::input::create_disk_input::Builder {
        crate::input::create_disk_input::Builder::default()
    }
    /// Creates a new `CreateDisk` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDisk {
    type Output =
        std::result::Result<crate::output::CreateDiskOutput, crate::error::CreateDiskError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_disk_error(response)
        } else {
            crate::operation_deser::parse_create_disk_response(response)
        }
    }
}

/// Operation shape for `CreateDiskFromSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_disk_from_snapshot`](crate::client::Client::create_disk_from_snapshot).
///
/// See [`crate::client::fluent_builders::CreateDiskFromSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDiskFromSnapshot {
    _private: (),
}
impl CreateDiskFromSnapshot {
    /// Creates a new builder-style object to manufacture [`CreateDiskFromSnapshotInput`](crate::input::CreateDiskFromSnapshotInput)
    pub fn builder() -> crate::input::create_disk_from_snapshot_input::Builder {
        crate::input::create_disk_from_snapshot_input::Builder::default()
    }
    /// Creates a new `CreateDiskFromSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDiskFromSnapshot {
    type Output = std::result::Result<
        crate::output::CreateDiskFromSnapshotOutput,
        crate::error::CreateDiskFromSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_disk_from_snapshot_error(response)
        } else {
            crate::operation_deser::parse_create_disk_from_snapshot_response(response)
        }
    }
}

/// Operation shape for `CreateDiskSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_disk_snapshot`](crate::client::Client::create_disk_snapshot).
///
/// See [`crate::client::fluent_builders::CreateDiskSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDiskSnapshot {
    _private: (),
}
impl CreateDiskSnapshot {
    /// Creates a new builder-style object to manufacture [`CreateDiskSnapshotInput`](crate::input::CreateDiskSnapshotInput)
    pub fn builder() -> crate::input::create_disk_snapshot_input::Builder {
        crate::input::create_disk_snapshot_input::Builder::default()
    }
    /// Creates a new `CreateDiskSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDiskSnapshot {
    type Output = std::result::Result<
        crate::output::CreateDiskSnapshotOutput,
        crate::error::CreateDiskSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_disk_snapshot_error(response)
        } else {
            crate::operation_deser::parse_create_disk_snapshot_response(response)
        }
    }
}

/// Operation shape for `CreateDistribution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_distribution`](crate::client::Client::create_distribution).
///
/// See [`crate::client::fluent_builders::CreateDistribution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDistribution {
    _private: (),
}
impl CreateDistribution {
    /// Creates a new builder-style object to manufacture [`CreateDistributionInput`](crate::input::CreateDistributionInput)
    pub fn builder() -> crate::input::create_distribution_input::Builder {
        crate::input::create_distribution_input::Builder::default()
    }
    /// Creates a new `CreateDistribution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDistribution {
    type Output = std::result::Result<
        crate::output::CreateDistributionOutput,
        crate::error::CreateDistributionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_distribution_error(response)
        } else {
            crate::operation_deser::parse_create_distribution_response(response)
        }
    }
}

/// Operation shape for `CreateDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_domain`](crate::client::Client::create_domain).
///
/// See [`crate::client::fluent_builders::CreateDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDomain {
    _private: (),
}
impl CreateDomain {
    /// Creates a new builder-style object to manufacture [`CreateDomainInput`](crate::input::CreateDomainInput)
    pub fn builder() -> crate::input::create_domain_input::Builder {
        crate::input::create_domain_input::Builder::default()
    }
    /// Creates a new `CreateDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDomain {
    type Output =
        std::result::Result<crate::output::CreateDomainOutput, crate::error::CreateDomainError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_domain_error(response)
        } else {
            crate::operation_deser::parse_create_domain_response(response)
        }
    }
}

/// Operation shape for `CreateDomainEntry`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_domain_entry`](crate::client::Client::create_domain_entry).
///
/// See [`crate::client::fluent_builders::CreateDomainEntry`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDomainEntry {
    _private: (),
}
impl CreateDomainEntry {
    /// Creates a new builder-style object to manufacture [`CreateDomainEntryInput`](crate::input::CreateDomainEntryInput)
    pub fn builder() -> crate::input::create_domain_entry_input::Builder {
        crate::input::create_domain_entry_input::Builder::default()
    }
    /// Creates a new `CreateDomainEntry` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDomainEntry {
    type Output = std::result::Result<
        crate::output::CreateDomainEntryOutput,
        crate::error::CreateDomainEntryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_domain_entry_error(response)
        } else {
            crate::operation_deser::parse_create_domain_entry_response(response)
        }
    }
}

/// Operation shape for `CreateInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_instances`](crate::client::Client::create_instances).
///
/// See [`crate::client::fluent_builders::CreateInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateInstances {
    _private: (),
}
impl CreateInstances {
    /// Creates a new builder-style object to manufacture [`CreateInstancesInput`](crate::input::CreateInstancesInput)
    pub fn builder() -> crate::input::create_instances_input::Builder {
        crate::input::create_instances_input::Builder::default()
    }
    /// Creates a new `CreateInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateInstances {
    type Output = std::result::Result<
        crate::output::CreateInstancesOutput,
        crate::error::CreateInstancesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_instances_error(response)
        } else {
            crate::operation_deser::parse_create_instances_response(response)
        }
    }
}

/// Operation shape for `CreateInstancesFromSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_instances_from_snapshot`](crate::client::Client::create_instances_from_snapshot).
///
/// See [`crate::client::fluent_builders::CreateInstancesFromSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateInstancesFromSnapshot {
    _private: (),
}
impl CreateInstancesFromSnapshot {
    /// Creates a new builder-style object to manufacture [`CreateInstancesFromSnapshotInput`](crate::input::CreateInstancesFromSnapshotInput)
    pub fn builder() -> crate::input::create_instances_from_snapshot_input::Builder {
        crate::input::create_instances_from_snapshot_input::Builder::default()
    }
    /// Creates a new `CreateInstancesFromSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateInstancesFromSnapshot {
    type Output = std::result::Result<
        crate::output::CreateInstancesFromSnapshotOutput,
        crate::error::CreateInstancesFromSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_instances_from_snapshot_error(response)
        } else {
            crate::operation_deser::parse_create_instances_from_snapshot_response(response)
        }
    }
}

/// Operation shape for `CreateInstanceSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_instance_snapshot`](crate::client::Client::create_instance_snapshot).
///
/// See [`crate::client::fluent_builders::CreateInstanceSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateInstanceSnapshot {
    _private: (),
}
impl CreateInstanceSnapshot {
    /// Creates a new builder-style object to manufacture [`CreateInstanceSnapshotInput`](crate::input::CreateInstanceSnapshotInput)
    pub fn builder() -> crate::input::create_instance_snapshot_input::Builder {
        crate::input::create_instance_snapshot_input::Builder::default()
    }
    /// Creates a new `CreateInstanceSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateInstanceSnapshot {
    type Output = std::result::Result<
        crate::output::CreateInstanceSnapshotOutput,
        crate::error::CreateInstanceSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_instance_snapshot_error(response)
        } else {
            crate::operation_deser::parse_create_instance_snapshot_response(response)
        }
    }
}

/// Operation shape for `CreateKeyPair`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_key_pair`](crate::client::Client::create_key_pair).
///
/// See [`crate::client::fluent_builders::CreateKeyPair`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateKeyPair {
    _private: (),
}
impl CreateKeyPair {
    /// Creates a new builder-style object to manufacture [`CreateKeyPairInput`](crate::input::CreateKeyPairInput)
    pub fn builder() -> crate::input::create_key_pair_input::Builder {
        crate::input::create_key_pair_input::Builder::default()
    }
    /// Creates a new `CreateKeyPair` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateKeyPair {
    type Output =
        std::result::Result<crate::output::CreateKeyPairOutput, crate::error::CreateKeyPairError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_key_pair_error(response)
        } else {
            crate::operation_deser::parse_create_key_pair_response(response)
        }
    }
}

/// Operation shape for `CreateLoadBalancer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_load_balancer`](crate::client::Client::create_load_balancer).
///
/// See [`crate::client::fluent_builders::CreateLoadBalancer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLoadBalancer {
    _private: (),
}
impl CreateLoadBalancer {
    /// Creates a new builder-style object to manufacture [`CreateLoadBalancerInput`](crate::input::CreateLoadBalancerInput)
    pub fn builder() -> crate::input::create_load_balancer_input::Builder {
        crate::input::create_load_balancer_input::Builder::default()
    }
    /// Creates a new `CreateLoadBalancer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLoadBalancer {
    type Output = std::result::Result<
        crate::output::CreateLoadBalancerOutput,
        crate::error::CreateLoadBalancerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_load_balancer_error(response)
        } else {
            crate::operation_deser::parse_create_load_balancer_response(response)
        }
    }
}

/// Operation shape for `CreateLoadBalancerTlsCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_load_balancer_tls_certificate`](crate::client::Client::create_load_balancer_tls_certificate).
///
/// See [`crate::client::fluent_builders::CreateLoadBalancerTlsCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLoadBalancerTlsCertificate {
    _private: (),
}
impl CreateLoadBalancerTlsCertificate {
    /// Creates a new builder-style object to manufacture [`CreateLoadBalancerTlsCertificateInput`](crate::input::CreateLoadBalancerTlsCertificateInput)
    pub fn builder() -> crate::input::create_load_balancer_tls_certificate_input::Builder {
        crate::input::create_load_balancer_tls_certificate_input::Builder::default()
    }
    /// Creates a new `CreateLoadBalancerTlsCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLoadBalancerTlsCertificate {
    type Output = std::result::Result<
        crate::output::CreateLoadBalancerTlsCertificateOutput,
        crate::error::CreateLoadBalancerTlsCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_load_balancer_tls_certificate_error(response)
        } else {
            crate::operation_deser::parse_create_load_balancer_tls_certificate_response(response)
        }
    }
}

/// Operation shape for `CreateRelationalDatabase`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_relational_database`](crate::client::Client::create_relational_database).
///
/// See [`crate::client::fluent_builders::CreateRelationalDatabase`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRelationalDatabase {
    _private: (),
}
impl CreateRelationalDatabase {
    /// Creates a new builder-style object to manufacture [`CreateRelationalDatabaseInput`](crate::input::CreateRelationalDatabaseInput)
    pub fn builder() -> crate::input::create_relational_database_input::Builder {
        crate::input::create_relational_database_input::Builder::default()
    }
    /// Creates a new `CreateRelationalDatabase` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRelationalDatabase {
    type Output = std::result::Result<
        crate::output::CreateRelationalDatabaseOutput,
        crate::error::CreateRelationalDatabaseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_relational_database_error(response)
        } else {
            crate::operation_deser::parse_create_relational_database_response(response)
        }
    }
}

/// Operation shape for `CreateRelationalDatabaseFromSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_relational_database_from_snapshot`](crate::client::Client::create_relational_database_from_snapshot).
///
/// See [`crate::client::fluent_builders::CreateRelationalDatabaseFromSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRelationalDatabaseFromSnapshot {
    _private: (),
}
impl CreateRelationalDatabaseFromSnapshot {
    /// Creates a new builder-style object to manufacture [`CreateRelationalDatabaseFromSnapshotInput`](crate::input::CreateRelationalDatabaseFromSnapshotInput)
    pub fn builder() -> crate::input::create_relational_database_from_snapshot_input::Builder {
        crate::input::create_relational_database_from_snapshot_input::Builder::default()
    }
    /// Creates a new `CreateRelationalDatabaseFromSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRelationalDatabaseFromSnapshot {
    type Output = std::result::Result<
        crate::output::CreateRelationalDatabaseFromSnapshotOutput,
        crate::error::CreateRelationalDatabaseFromSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_relational_database_from_snapshot_error(response)
        } else {
            crate::operation_deser::parse_create_relational_database_from_snapshot_response(
                response,
            )
        }
    }
}

/// Operation shape for `CreateRelationalDatabaseSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_relational_database_snapshot`](crate::client::Client::create_relational_database_snapshot).
///
/// See [`crate::client::fluent_builders::CreateRelationalDatabaseSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateRelationalDatabaseSnapshot {
    _private: (),
}
impl CreateRelationalDatabaseSnapshot {
    /// Creates a new builder-style object to manufacture [`CreateRelationalDatabaseSnapshotInput`](crate::input::CreateRelationalDatabaseSnapshotInput)
    pub fn builder() -> crate::input::create_relational_database_snapshot_input::Builder {
        crate::input::create_relational_database_snapshot_input::Builder::default()
    }
    /// Creates a new `CreateRelationalDatabaseSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateRelationalDatabaseSnapshot {
    type Output = std::result::Result<
        crate::output::CreateRelationalDatabaseSnapshotOutput,
        crate::error::CreateRelationalDatabaseSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_relational_database_snapshot_error(response)
        } else {
            crate::operation_deser::parse_create_relational_database_snapshot_response(response)
        }
    }
}

/// Operation shape for `DeleteAlarm`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_alarm`](crate::client::Client::delete_alarm).
///
/// See [`crate::client::fluent_builders::DeleteAlarm`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAlarm {
    _private: (),
}
impl DeleteAlarm {
    /// Creates a new builder-style object to manufacture [`DeleteAlarmInput`](crate::input::DeleteAlarmInput)
    pub fn builder() -> crate::input::delete_alarm_input::Builder {
        crate::input::delete_alarm_input::Builder::default()
    }
    /// Creates a new `DeleteAlarm` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAlarm {
    type Output =
        std::result::Result<crate::output::DeleteAlarmOutput, crate::error::DeleteAlarmError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_alarm_error(response)
        } else {
            crate::operation_deser::parse_delete_alarm_response(response)
        }
    }
}

/// Operation shape for `DeleteAutoSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_auto_snapshot`](crate::client::Client::delete_auto_snapshot).
///
/// See [`crate::client::fluent_builders::DeleteAutoSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAutoSnapshot {
    _private: (),
}
impl DeleteAutoSnapshot {
    /// Creates a new builder-style object to manufacture [`DeleteAutoSnapshotInput`](crate::input::DeleteAutoSnapshotInput)
    pub fn builder() -> crate::input::delete_auto_snapshot_input::Builder {
        crate::input::delete_auto_snapshot_input::Builder::default()
    }
    /// Creates a new `DeleteAutoSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAutoSnapshot {
    type Output = std::result::Result<
        crate::output::DeleteAutoSnapshotOutput,
        crate::error::DeleteAutoSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_auto_snapshot_error(response)
        } else {
            crate::operation_deser::parse_delete_auto_snapshot_response(response)
        }
    }
}

/// Operation shape for `DeleteBucket`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bucket`](crate::client::Client::delete_bucket).
///
/// See [`crate::client::fluent_builders::DeleteBucket`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBucket {
    _private: (),
}
impl DeleteBucket {
    /// Creates a new builder-style object to manufacture [`DeleteBucketInput`](crate::input::DeleteBucketInput)
    pub fn builder() -> crate::input::delete_bucket_input::Builder {
        crate::input::delete_bucket_input::Builder::default()
    }
    /// Creates a new `DeleteBucket` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBucket {
    type Output =
        std::result::Result<crate::output::DeleteBucketOutput, crate::error::DeleteBucketError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_bucket_error(response)
        } else {
            crate::operation_deser::parse_delete_bucket_response(response)
        }
    }
}

/// Operation shape for `DeleteBucketAccessKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_bucket_access_key`](crate::client::Client::delete_bucket_access_key).
///
/// See [`crate::client::fluent_builders::DeleteBucketAccessKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteBucketAccessKey {
    _private: (),
}
impl DeleteBucketAccessKey {
    /// Creates a new builder-style object to manufacture [`DeleteBucketAccessKeyInput`](crate::input::DeleteBucketAccessKeyInput)
    pub fn builder() -> crate::input::delete_bucket_access_key_input::Builder {
        crate::input::delete_bucket_access_key_input::Builder::default()
    }
    /// Creates a new `DeleteBucketAccessKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteBucketAccessKey {
    type Output = std::result::Result<
        crate::output::DeleteBucketAccessKeyOutput,
        crate::error::DeleteBucketAccessKeyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_bucket_access_key_error(response)
        } else {
            crate::operation_deser::parse_delete_bucket_access_key_response(response)
        }
    }
}

/// Operation shape for `DeleteCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_certificate`](crate::client::Client::delete_certificate).
///
/// See [`crate::client::fluent_builders::DeleteCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCertificate {
    _private: (),
}
impl DeleteCertificate {
    /// Creates a new builder-style object to manufacture [`DeleteCertificateInput`](crate::input::DeleteCertificateInput)
    pub fn builder() -> crate::input::delete_certificate_input::Builder {
        crate::input::delete_certificate_input::Builder::default()
    }
    /// Creates a new `DeleteCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCertificate {
    type Output = std::result::Result<
        crate::output::DeleteCertificateOutput,
        crate::error::DeleteCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_certificate_error(response)
        } else {
            crate::operation_deser::parse_delete_certificate_response(response)
        }
    }
}

/// Operation shape for `DeleteContactMethod`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_contact_method`](crate::client::Client::delete_contact_method).
///
/// See [`crate::client::fluent_builders::DeleteContactMethod`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteContactMethod {
    _private: (),
}
impl DeleteContactMethod {
    /// Creates a new builder-style object to manufacture [`DeleteContactMethodInput`](crate::input::DeleteContactMethodInput)
    pub fn builder() -> crate::input::delete_contact_method_input::Builder {
        crate::input::delete_contact_method_input::Builder::default()
    }
    /// Creates a new `DeleteContactMethod` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteContactMethod {
    type Output = std::result::Result<
        crate::output::DeleteContactMethodOutput,
        crate::error::DeleteContactMethodError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_contact_method_error(response)
        } else {
            crate::operation_deser::parse_delete_contact_method_response(response)
        }
    }
}

/// Operation shape for `DeleteContainerImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_container_image`](crate::client::Client::delete_container_image).
///
/// See [`crate::client::fluent_builders::DeleteContainerImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteContainerImage {
    _private: (),
}
impl DeleteContainerImage {
    /// Creates a new builder-style object to manufacture [`DeleteContainerImageInput`](crate::input::DeleteContainerImageInput)
    pub fn builder() -> crate::input::delete_container_image_input::Builder {
        crate::input::delete_container_image_input::Builder::default()
    }
    /// Creates a new `DeleteContainerImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteContainerImage {
    type Output = std::result::Result<
        crate::output::DeleteContainerImageOutput,
        crate::error::DeleteContainerImageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_container_image_error(response)
        } else {
            crate::operation_deser::parse_delete_container_image_response(response)
        }
    }
}

/// Operation shape for `DeleteContainerService`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_container_service`](crate::client::Client::delete_container_service).
///
/// See [`crate::client::fluent_builders::DeleteContainerService`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteContainerService {
    _private: (),
}
impl DeleteContainerService {
    /// Creates a new builder-style object to manufacture [`DeleteContainerServiceInput`](crate::input::DeleteContainerServiceInput)
    pub fn builder() -> crate::input::delete_container_service_input::Builder {
        crate::input::delete_container_service_input::Builder::default()
    }
    /// Creates a new `DeleteContainerService` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteContainerService {
    type Output = std::result::Result<
        crate::output::DeleteContainerServiceOutput,
        crate::error::DeleteContainerServiceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_container_service_error(response)
        } else {
            crate::operation_deser::parse_delete_container_service_response(response)
        }
    }
}

/// Operation shape for `DeleteDisk`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_disk`](crate::client::Client::delete_disk).
///
/// See [`crate::client::fluent_builders::DeleteDisk`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDisk {
    _private: (),
}
impl DeleteDisk {
    /// Creates a new builder-style object to manufacture [`DeleteDiskInput`](crate::input::DeleteDiskInput)
    pub fn builder() -> crate::input::delete_disk_input::Builder {
        crate::input::delete_disk_input::Builder::default()
    }
    /// Creates a new `DeleteDisk` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDisk {
    type Output =
        std::result::Result<crate::output::DeleteDiskOutput, crate::error::DeleteDiskError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_disk_error(response)
        } else {
            crate::operation_deser::parse_delete_disk_response(response)
        }
    }
}

/// Operation shape for `DeleteDiskSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_disk_snapshot`](crate::client::Client::delete_disk_snapshot).
///
/// See [`crate::client::fluent_builders::DeleteDiskSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDiskSnapshot {
    _private: (),
}
impl DeleteDiskSnapshot {
    /// Creates a new builder-style object to manufacture [`DeleteDiskSnapshotInput`](crate::input::DeleteDiskSnapshotInput)
    pub fn builder() -> crate::input::delete_disk_snapshot_input::Builder {
        crate::input::delete_disk_snapshot_input::Builder::default()
    }
    /// Creates a new `DeleteDiskSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDiskSnapshot {
    type Output = std::result::Result<
        crate::output::DeleteDiskSnapshotOutput,
        crate::error::DeleteDiskSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_disk_snapshot_error(response)
        } else {
            crate::operation_deser::parse_delete_disk_snapshot_response(response)
        }
    }
}

/// Operation shape for `DeleteDistribution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_distribution`](crate::client::Client::delete_distribution).
///
/// See [`crate::client::fluent_builders::DeleteDistribution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDistribution {
    _private: (),
}
impl DeleteDistribution {
    /// Creates a new builder-style object to manufacture [`DeleteDistributionInput`](crate::input::DeleteDistributionInput)
    pub fn builder() -> crate::input::delete_distribution_input::Builder {
        crate::input::delete_distribution_input::Builder::default()
    }
    /// Creates a new `DeleteDistribution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDistribution {
    type Output = std::result::Result<
        crate::output::DeleteDistributionOutput,
        crate::error::DeleteDistributionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_distribution_error(response)
        } else {
            crate::operation_deser::parse_delete_distribution_response(response)
        }
    }
}

/// Operation shape for `DeleteDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_domain`](crate::client::Client::delete_domain).
///
/// See [`crate::client::fluent_builders::DeleteDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDomain {
    _private: (),
}
impl DeleteDomain {
    /// Creates a new builder-style object to manufacture [`DeleteDomainInput`](crate::input::DeleteDomainInput)
    pub fn builder() -> crate::input::delete_domain_input::Builder {
        crate::input::delete_domain_input::Builder::default()
    }
    /// Creates a new `DeleteDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDomain {
    type Output =
        std::result::Result<crate::output::DeleteDomainOutput, crate::error::DeleteDomainError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_domain_error(response)
        } else {
            crate::operation_deser::parse_delete_domain_response(response)
        }
    }
}

/// Operation shape for `DeleteDomainEntry`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_domain_entry`](crate::client::Client::delete_domain_entry).
///
/// See [`crate::client::fluent_builders::DeleteDomainEntry`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDomainEntry {
    _private: (),
}
impl DeleteDomainEntry {
    /// Creates a new builder-style object to manufacture [`DeleteDomainEntryInput`](crate::input::DeleteDomainEntryInput)
    pub fn builder() -> crate::input::delete_domain_entry_input::Builder {
        crate::input::delete_domain_entry_input::Builder::default()
    }
    /// Creates a new `DeleteDomainEntry` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDomainEntry {
    type Output = std::result::Result<
        crate::output::DeleteDomainEntryOutput,
        crate::error::DeleteDomainEntryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_domain_entry_error(response)
        } else {
            crate::operation_deser::parse_delete_domain_entry_response(response)
        }
    }
}

/// Operation shape for `DeleteInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_instance`](crate::client::Client::delete_instance).
///
/// See [`crate::client::fluent_builders::DeleteInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteInstance {
    _private: (),
}
impl DeleteInstance {
    /// Creates a new builder-style object to manufacture [`DeleteInstanceInput`](crate::input::DeleteInstanceInput)
    pub fn builder() -> crate::input::delete_instance_input::Builder {
        crate::input::delete_instance_input::Builder::default()
    }
    /// Creates a new `DeleteInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteInstance {
    type Output =
        std::result::Result<crate::output::DeleteInstanceOutput, crate::error::DeleteInstanceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_instance_error(response)
        } else {
            crate::operation_deser::parse_delete_instance_response(response)
        }
    }
}

/// Operation shape for `DeleteInstanceSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_instance_snapshot`](crate::client::Client::delete_instance_snapshot).
///
/// See [`crate::client::fluent_builders::DeleteInstanceSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteInstanceSnapshot {
    _private: (),
}
impl DeleteInstanceSnapshot {
    /// Creates a new builder-style object to manufacture [`DeleteInstanceSnapshotInput`](crate::input::DeleteInstanceSnapshotInput)
    pub fn builder() -> crate::input::delete_instance_snapshot_input::Builder {
        crate::input::delete_instance_snapshot_input::Builder::default()
    }
    /// Creates a new `DeleteInstanceSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteInstanceSnapshot {
    type Output = std::result::Result<
        crate::output::DeleteInstanceSnapshotOutput,
        crate::error::DeleteInstanceSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_instance_snapshot_error(response)
        } else {
            crate::operation_deser::parse_delete_instance_snapshot_response(response)
        }
    }
}

/// Operation shape for `DeleteKeyPair`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_key_pair`](crate::client::Client::delete_key_pair).
///
/// See [`crate::client::fluent_builders::DeleteKeyPair`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteKeyPair {
    _private: (),
}
impl DeleteKeyPair {
    /// Creates a new builder-style object to manufacture [`DeleteKeyPairInput`](crate::input::DeleteKeyPairInput)
    pub fn builder() -> crate::input::delete_key_pair_input::Builder {
        crate::input::delete_key_pair_input::Builder::default()
    }
    /// Creates a new `DeleteKeyPair` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteKeyPair {
    type Output =
        std::result::Result<crate::output::DeleteKeyPairOutput, crate::error::DeleteKeyPairError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_key_pair_error(response)
        } else {
            crate::operation_deser::parse_delete_key_pair_response(response)
        }
    }
}

/// Operation shape for `DeleteKnownHostKeys`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_known_host_keys`](crate::client::Client::delete_known_host_keys).
///
/// See [`crate::client::fluent_builders::DeleteKnownHostKeys`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteKnownHostKeys {
    _private: (),
}
impl DeleteKnownHostKeys {
    /// Creates a new builder-style object to manufacture [`DeleteKnownHostKeysInput`](crate::input::DeleteKnownHostKeysInput)
    pub fn builder() -> crate::input::delete_known_host_keys_input::Builder {
        crate::input::delete_known_host_keys_input::Builder::default()
    }
    /// Creates a new `DeleteKnownHostKeys` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteKnownHostKeys {
    type Output = std::result::Result<
        crate::output::DeleteKnownHostKeysOutput,
        crate::error::DeleteKnownHostKeysError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_known_host_keys_error(response)
        } else {
            crate::operation_deser::parse_delete_known_host_keys_response(response)
        }
    }
}

/// Operation shape for `DeleteLoadBalancer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_load_balancer`](crate::client::Client::delete_load_balancer).
///
/// See [`crate::client::fluent_builders::DeleteLoadBalancer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLoadBalancer {
    _private: (),
}
impl DeleteLoadBalancer {
    /// Creates a new builder-style object to manufacture [`DeleteLoadBalancerInput`](crate::input::DeleteLoadBalancerInput)
    pub fn builder() -> crate::input::delete_load_balancer_input::Builder {
        crate::input::delete_load_balancer_input::Builder::default()
    }
    /// Creates a new `DeleteLoadBalancer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLoadBalancer {
    type Output = std::result::Result<
        crate::output::DeleteLoadBalancerOutput,
        crate::error::DeleteLoadBalancerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_load_balancer_error(response)
        } else {
            crate::operation_deser::parse_delete_load_balancer_response(response)
        }
    }
}

/// Operation shape for `DeleteLoadBalancerTlsCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_load_balancer_tls_certificate`](crate::client::Client::delete_load_balancer_tls_certificate).
///
/// See [`crate::client::fluent_builders::DeleteLoadBalancerTlsCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLoadBalancerTlsCertificate {
    _private: (),
}
impl DeleteLoadBalancerTlsCertificate {
    /// Creates a new builder-style object to manufacture [`DeleteLoadBalancerTlsCertificateInput`](crate::input::DeleteLoadBalancerTlsCertificateInput)
    pub fn builder() -> crate::input::delete_load_balancer_tls_certificate_input::Builder {
        crate::input::delete_load_balancer_tls_certificate_input::Builder::default()
    }
    /// Creates a new `DeleteLoadBalancerTlsCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLoadBalancerTlsCertificate {
    type Output = std::result::Result<
        crate::output::DeleteLoadBalancerTlsCertificateOutput,
        crate::error::DeleteLoadBalancerTlsCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_load_balancer_tls_certificate_error(response)
        } else {
            crate::operation_deser::parse_delete_load_balancer_tls_certificate_response(response)
        }
    }
}

/// Operation shape for `DeleteRelationalDatabase`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_relational_database`](crate::client::Client::delete_relational_database).
///
/// See [`crate::client::fluent_builders::DeleteRelationalDatabase`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRelationalDatabase {
    _private: (),
}
impl DeleteRelationalDatabase {
    /// Creates a new builder-style object to manufacture [`DeleteRelationalDatabaseInput`](crate::input::DeleteRelationalDatabaseInput)
    pub fn builder() -> crate::input::delete_relational_database_input::Builder {
        crate::input::delete_relational_database_input::Builder::default()
    }
    /// Creates a new `DeleteRelationalDatabase` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRelationalDatabase {
    type Output = std::result::Result<
        crate::output::DeleteRelationalDatabaseOutput,
        crate::error::DeleteRelationalDatabaseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_relational_database_error(response)
        } else {
            crate::operation_deser::parse_delete_relational_database_response(response)
        }
    }
}

/// Operation shape for `DeleteRelationalDatabaseSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_relational_database_snapshot`](crate::client::Client::delete_relational_database_snapshot).
///
/// See [`crate::client::fluent_builders::DeleteRelationalDatabaseSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteRelationalDatabaseSnapshot {
    _private: (),
}
impl DeleteRelationalDatabaseSnapshot {
    /// Creates a new builder-style object to manufacture [`DeleteRelationalDatabaseSnapshotInput`](crate::input::DeleteRelationalDatabaseSnapshotInput)
    pub fn builder() -> crate::input::delete_relational_database_snapshot_input::Builder {
        crate::input::delete_relational_database_snapshot_input::Builder::default()
    }
    /// Creates a new `DeleteRelationalDatabaseSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteRelationalDatabaseSnapshot {
    type Output = std::result::Result<
        crate::output::DeleteRelationalDatabaseSnapshotOutput,
        crate::error::DeleteRelationalDatabaseSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_relational_database_snapshot_error(response)
        } else {
            crate::operation_deser::parse_delete_relational_database_snapshot_response(response)
        }
    }
}

/// Operation shape for `DetachCertificateFromDistribution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_certificate_from_distribution`](crate::client::Client::detach_certificate_from_distribution).
///
/// See [`crate::client::fluent_builders::DetachCertificateFromDistribution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachCertificateFromDistribution {
    _private: (),
}
impl DetachCertificateFromDistribution {
    /// Creates a new builder-style object to manufacture [`DetachCertificateFromDistributionInput`](crate::input::DetachCertificateFromDistributionInput)
    pub fn builder() -> crate::input::detach_certificate_from_distribution_input::Builder {
        crate::input::detach_certificate_from_distribution_input::Builder::default()
    }
    /// Creates a new `DetachCertificateFromDistribution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachCertificateFromDistribution {
    type Output = std::result::Result<
        crate::output::DetachCertificateFromDistributionOutput,
        crate::error::DetachCertificateFromDistributionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_certificate_from_distribution_error(response)
        } else {
            crate::operation_deser::parse_detach_certificate_from_distribution_response(response)
        }
    }
}

/// Operation shape for `DetachDisk`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_disk`](crate::client::Client::detach_disk).
///
/// See [`crate::client::fluent_builders::DetachDisk`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachDisk {
    _private: (),
}
impl DetachDisk {
    /// Creates a new builder-style object to manufacture [`DetachDiskInput`](crate::input::DetachDiskInput)
    pub fn builder() -> crate::input::detach_disk_input::Builder {
        crate::input::detach_disk_input::Builder::default()
    }
    /// Creates a new `DetachDisk` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachDisk {
    type Output =
        std::result::Result<crate::output::DetachDiskOutput, crate::error::DetachDiskError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_disk_error(response)
        } else {
            crate::operation_deser::parse_detach_disk_response(response)
        }
    }
}

/// Operation shape for `DetachInstancesFromLoadBalancer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_instances_from_load_balancer`](crate::client::Client::detach_instances_from_load_balancer).
///
/// See [`crate::client::fluent_builders::DetachInstancesFromLoadBalancer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachInstancesFromLoadBalancer {
    _private: (),
}
impl DetachInstancesFromLoadBalancer {
    /// Creates a new builder-style object to manufacture [`DetachInstancesFromLoadBalancerInput`](crate::input::DetachInstancesFromLoadBalancerInput)
    pub fn builder() -> crate::input::detach_instances_from_load_balancer_input::Builder {
        crate::input::detach_instances_from_load_balancer_input::Builder::default()
    }
    /// Creates a new `DetachInstancesFromLoadBalancer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachInstancesFromLoadBalancer {
    type Output = std::result::Result<
        crate::output::DetachInstancesFromLoadBalancerOutput,
        crate::error::DetachInstancesFromLoadBalancerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_instances_from_load_balancer_error(response)
        } else {
            crate::operation_deser::parse_detach_instances_from_load_balancer_response(response)
        }
    }
}

/// Operation shape for `DetachStaticIp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detach_static_ip`](crate::client::Client::detach_static_ip).
///
/// See [`crate::client::fluent_builders::DetachStaticIp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetachStaticIp {
    _private: (),
}
impl DetachStaticIp {
    /// Creates a new builder-style object to manufacture [`DetachStaticIpInput`](crate::input::DetachStaticIpInput)
    pub fn builder() -> crate::input::detach_static_ip_input::Builder {
        crate::input::detach_static_ip_input::Builder::default()
    }
    /// Creates a new `DetachStaticIp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetachStaticIp {
    type Output =
        std::result::Result<crate::output::DetachStaticIpOutput, crate::error::DetachStaticIpError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detach_static_ip_error(response)
        } else {
            crate::operation_deser::parse_detach_static_ip_response(response)
        }
    }
}

/// Operation shape for `DisableAddOn`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_add_on`](crate::client::Client::disable_add_on).
///
/// See [`crate::client::fluent_builders::DisableAddOn`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableAddOn {
    _private: (),
}
impl DisableAddOn {
    /// Creates a new builder-style object to manufacture [`DisableAddOnInput`](crate::input::DisableAddOnInput)
    pub fn builder() -> crate::input::disable_add_on_input::Builder {
        crate::input::disable_add_on_input::Builder::default()
    }
    /// Creates a new `DisableAddOn` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableAddOn {
    type Output =
        std::result::Result<crate::output::DisableAddOnOutput, crate::error::DisableAddOnError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_add_on_error(response)
        } else {
            crate::operation_deser::parse_disable_add_on_response(response)
        }
    }
}

/// Operation shape for `DownloadDefaultKeyPair`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`download_default_key_pair`](crate::client::Client::download_default_key_pair).
///
/// See [`crate::client::fluent_builders::DownloadDefaultKeyPair`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DownloadDefaultKeyPair {
    _private: (),
}
impl DownloadDefaultKeyPair {
    /// Creates a new builder-style object to manufacture [`DownloadDefaultKeyPairInput`](crate::input::DownloadDefaultKeyPairInput)
    pub fn builder() -> crate::input::download_default_key_pair_input::Builder {
        crate::input::download_default_key_pair_input::Builder::default()
    }
    /// Creates a new `DownloadDefaultKeyPair` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DownloadDefaultKeyPair {
    type Output = std::result::Result<
        crate::output::DownloadDefaultKeyPairOutput,
        crate::error::DownloadDefaultKeyPairError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_download_default_key_pair_error(response)
        } else {
            crate::operation_deser::parse_download_default_key_pair_response(response)
        }
    }
}

/// Operation shape for `EnableAddOn`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_add_on`](crate::client::Client::enable_add_on).
///
/// See [`crate::client::fluent_builders::EnableAddOn`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableAddOn {
    _private: (),
}
impl EnableAddOn {
    /// Creates a new builder-style object to manufacture [`EnableAddOnInput`](crate::input::EnableAddOnInput)
    pub fn builder() -> crate::input::enable_add_on_input::Builder {
        crate::input::enable_add_on_input::Builder::default()
    }
    /// Creates a new `EnableAddOn` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableAddOn {
    type Output =
        std::result::Result<crate::output::EnableAddOnOutput, crate::error::EnableAddOnError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_add_on_error(response)
        } else {
            crate::operation_deser::parse_enable_add_on_response(response)
        }
    }
}

/// Operation shape for `ExportSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`export_snapshot`](crate::client::Client::export_snapshot).
///
/// See [`crate::client::fluent_builders::ExportSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExportSnapshot {
    _private: (),
}
impl ExportSnapshot {
    /// Creates a new builder-style object to manufacture [`ExportSnapshotInput`](crate::input::ExportSnapshotInput)
    pub fn builder() -> crate::input::export_snapshot_input::Builder {
        crate::input::export_snapshot_input::Builder::default()
    }
    /// Creates a new `ExportSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExportSnapshot {
    type Output =
        std::result::Result<crate::output::ExportSnapshotOutput, crate::error::ExportSnapshotError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_export_snapshot_error(response)
        } else {
            crate::operation_deser::parse_export_snapshot_response(response)
        }
    }
}

/// Operation shape for `GetActiveNames`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_active_names`](crate::client::Client::get_active_names).
///
/// See [`crate::client::fluent_builders::GetActiveNames`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetActiveNames {
    _private: (),
}
impl GetActiveNames {
    /// Creates a new builder-style object to manufacture [`GetActiveNamesInput`](crate::input::GetActiveNamesInput)
    pub fn builder() -> crate::input::get_active_names_input::Builder {
        crate::input::get_active_names_input::Builder::default()
    }
    /// Creates a new `GetActiveNames` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetActiveNames {
    type Output =
        std::result::Result<crate::output::GetActiveNamesOutput, crate::error::GetActiveNamesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_active_names_error(response)
        } else {
            crate::operation_deser::parse_get_active_names_response(response)
        }
    }
}

/// Operation shape for `GetAlarms`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_alarms`](crate::client::Client::get_alarms).
///
/// See [`crate::client::fluent_builders::GetAlarms`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAlarms {
    _private: (),
}
impl GetAlarms {
    /// Creates a new builder-style object to manufacture [`GetAlarmsInput`](crate::input::GetAlarmsInput)
    pub fn builder() -> crate::input::get_alarms_input::Builder {
        crate::input::get_alarms_input::Builder::default()
    }
    /// Creates a new `GetAlarms` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAlarms {
    type Output = std::result::Result<crate::output::GetAlarmsOutput, crate::error::GetAlarmsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_alarms_error(response)
        } else {
            crate::operation_deser::parse_get_alarms_response(response)
        }
    }
}

/// Operation shape for `GetAutoSnapshots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_auto_snapshots`](crate::client::Client::get_auto_snapshots).
///
/// See [`crate::client::fluent_builders::GetAutoSnapshots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAutoSnapshots {
    _private: (),
}
impl GetAutoSnapshots {
    /// Creates a new builder-style object to manufacture [`GetAutoSnapshotsInput`](crate::input::GetAutoSnapshotsInput)
    pub fn builder() -> crate::input::get_auto_snapshots_input::Builder {
        crate::input::get_auto_snapshots_input::Builder::default()
    }
    /// Creates a new `GetAutoSnapshots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAutoSnapshots {
    type Output = std::result::Result<
        crate::output::GetAutoSnapshotsOutput,
        crate::error::GetAutoSnapshotsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_auto_snapshots_error(response)
        } else {
            crate::operation_deser::parse_get_auto_snapshots_response(response)
        }
    }
}

/// Operation shape for `GetBlueprints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_blueprints`](crate::client::Client::get_blueprints).
///
/// See [`crate::client::fluent_builders::GetBlueprints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBlueprints {
    _private: (),
}
impl GetBlueprints {
    /// Creates a new builder-style object to manufacture [`GetBlueprintsInput`](crate::input::GetBlueprintsInput)
    pub fn builder() -> crate::input::get_blueprints_input::Builder {
        crate::input::get_blueprints_input::Builder::default()
    }
    /// Creates a new `GetBlueprints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBlueprints {
    type Output =
        std::result::Result<crate::output::GetBlueprintsOutput, crate::error::GetBlueprintsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_blueprints_error(response)
        } else {
            crate::operation_deser::parse_get_blueprints_response(response)
        }
    }
}

/// Operation shape for `GetBucketAccessKeys`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_access_keys`](crate::client::Client::get_bucket_access_keys).
///
/// See [`crate::client::fluent_builders::GetBucketAccessKeys`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketAccessKeys {
    _private: (),
}
impl GetBucketAccessKeys {
    /// Creates a new builder-style object to manufacture [`GetBucketAccessKeysInput`](crate::input::GetBucketAccessKeysInput)
    pub fn builder() -> crate::input::get_bucket_access_keys_input::Builder {
        crate::input::get_bucket_access_keys_input::Builder::default()
    }
    /// Creates a new `GetBucketAccessKeys` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketAccessKeys {
    type Output = std::result::Result<
        crate::output::GetBucketAccessKeysOutput,
        crate::error::GetBucketAccessKeysError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_access_keys_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_access_keys_response(response)
        }
    }
}

/// Operation shape for `GetBucketBundles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_bundles`](crate::client::Client::get_bucket_bundles).
///
/// See [`crate::client::fluent_builders::GetBucketBundles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketBundles {
    _private: (),
}
impl GetBucketBundles {
    /// Creates a new builder-style object to manufacture [`GetBucketBundlesInput`](crate::input::GetBucketBundlesInput)
    pub fn builder() -> crate::input::get_bucket_bundles_input::Builder {
        crate::input::get_bucket_bundles_input::Builder::default()
    }
    /// Creates a new `GetBucketBundles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketBundles {
    type Output = std::result::Result<
        crate::output::GetBucketBundlesOutput,
        crate::error::GetBucketBundlesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_bundles_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_bundles_response(response)
        }
    }
}

/// Operation shape for `GetBucketMetricData`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_metric_data`](crate::client::Client::get_bucket_metric_data).
///
/// See [`crate::client::fluent_builders::GetBucketMetricData`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketMetricData {
    _private: (),
}
impl GetBucketMetricData {
    /// Creates a new builder-style object to manufacture [`GetBucketMetricDataInput`](crate::input::GetBucketMetricDataInput)
    pub fn builder() -> crate::input::get_bucket_metric_data_input::Builder {
        crate::input::get_bucket_metric_data_input::Builder::default()
    }
    /// Creates a new `GetBucketMetricData` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketMetricData {
    type Output = std::result::Result<
        crate::output::GetBucketMetricDataOutput,
        crate::error::GetBucketMetricDataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_metric_data_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_metric_data_response(response)
        }
    }
}

/// Operation shape for `GetBuckets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_buckets`](crate::client::Client::get_buckets).
///
/// See [`crate::client::fluent_builders::GetBuckets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBuckets {
    _private: (),
}
impl GetBuckets {
    /// Creates a new builder-style object to manufacture [`GetBucketsInput`](crate::input::GetBucketsInput)
    pub fn builder() -> crate::input::get_buckets_input::Builder {
        crate::input::get_buckets_input::Builder::default()
    }
    /// Creates a new `GetBuckets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBuckets {
    type Output =
        std::result::Result<crate::output::GetBucketsOutput, crate::error::GetBucketsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_buckets_error(response)
        } else {
            crate::operation_deser::parse_get_buckets_response(response)
        }
    }
}

/// Operation shape for `GetBundles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bundles`](crate::client::Client::get_bundles).
///
/// See [`crate::client::fluent_builders::GetBundles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBundles {
    _private: (),
}
impl GetBundles {
    /// Creates a new builder-style object to manufacture [`GetBundlesInput`](crate::input::GetBundlesInput)
    pub fn builder() -> crate::input::get_bundles_input::Builder {
        crate::input::get_bundles_input::Builder::default()
    }
    /// Creates a new `GetBundles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBundles {
    type Output =
        std::result::Result<crate::output::GetBundlesOutput, crate::error::GetBundlesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bundles_error(response)
        } else {
            crate::operation_deser::parse_get_bundles_response(response)
        }
    }
}

/// Operation shape for `GetCertificates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_certificates`](crate::client::Client::get_certificates).
///
/// See [`crate::client::fluent_builders::GetCertificates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCertificates {
    _private: (),
}
impl GetCertificates {
    /// Creates a new builder-style object to manufacture [`GetCertificatesInput`](crate::input::GetCertificatesInput)
    pub fn builder() -> crate::input::get_certificates_input::Builder {
        crate::input::get_certificates_input::Builder::default()
    }
    /// Creates a new `GetCertificates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCertificates {
    type Output = std::result::Result<
        crate::output::GetCertificatesOutput,
        crate::error::GetCertificatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_certificates_error(response)
        } else {
            crate::operation_deser::parse_get_certificates_response(response)
        }
    }
}

/// Operation shape for `GetCloudFormationStackRecords`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_cloud_formation_stack_records`](crate::client::Client::get_cloud_formation_stack_records).
///
/// See [`crate::client::fluent_builders::GetCloudFormationStackRecords`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCloudFormationStackRecords {
    _private: (),
}
impl GetCloudFormationStackRecords {
    /// Creates a new builder-style object to manufacture [`GetCloudFormationStackRecordsInput`](crate::input::GetCloudFormationStackRecordsInput)
    pub fn builder() -> crate::input::get_cloud_formation_stack_records_input::Builder {
        crate::input::get_cloud_formation_stack_records_input::Builder::default()
    }
    /// Creates a new `GetCloudFormationStackRecords` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCloudFormationStackRecords {
    type Output = std::result::Result<
        crate::output::GetCloudFormationStackRecordsOutput,
        crate::error::GetCloudFormationStackRecordsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_cloud_formation_stack_records_error(response)
        } else {
            crate::operation_deser::parse_get_cloud_formation_stack_records_response(response)
        }
    }
}

/// Operation shape for `GetContactMethods`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_contact_methods`](crate::client::Client::get_contact_methods).
///
/// See [`crate::client::fluent_builders::GetContactMethods`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetContactMethods {
    _private: (),
}
impl GetContactMethods {
    /// Creates a new builder-style object to manufacture [`GetContactMethodsInput`](crate::input::GetContactMethodsInput)
    pub fn builder() -> crate::input::get_contact_methods_input::Builder {
        crate::input::get_contact_methods_input::Builder::default()
    }
    /// Creates a new `GetContactMethods` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetContactMethods {
    type Output = std::result::Result<
        crate::output::GetContactMethodsOutput,
        crate::error::GetContactMethodsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_contact_methods_error(response)
        } else {
            crate::operation_deser::parse_get_contact_methods_response(response)
        }
    }
}

/// Operation shape for `GetContainerAPIMetadata`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_container_api_metadata`](crate::client::Client::get_container_api_metadata).
///
/// See [`crate::client::fluent_builders::GetContainerAPIMetadata`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetContainerAPIMetadata {
    _private: (),
}
impl GetContainerAPIMetadata {
    /// Creates a new builder-style object to manufacture [`GetContainerApiMetadataInput`](crate::input::GetContainerApiMetadataInput)
    pub fn builder() -> crate::input::get_container_api_metadata_input::Builder {
        crate::input::get_container_api_metadata_input::Builder::default()
    }
    /// Creates a new `GetContainerAPIMetadata` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetContainerAPIMetadata {
    type Output = std::result::Result<
        crate::output::GetContainerApiMetadataOutput,
        crate::error::GetContainerAPIMetadataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_container_api_metadata_error(response)
        } else {
            crate::operation_deser::parse_get_container_api_metadata_response(response)
        }
    }
}

/// Operation shape for `GetContainerImages`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_container_images`](crate::client::Client::get_container_images).
///
/// See [`crate::client::fluent_builders::GetContainerImages`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetContainerImages {
    _private: (),
}
impl GetContainerImages {
    /// Creates a new builder-style object to manufacture [`GetContainerImagesInput`](crate::input::GetContainerImagesInput)
    pub fn builder() -> crate::input::get_container_images_input::Builder {
        crate::input::get_container_images_input::Builder::default()
    }
    /// Creates a new `GetContainerImages` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetContainerImages {
    type Output = std::result::Result<
        crate::output::GetContainerImagesOutput,
        crate::error::GetContainerImagesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_container_images_error(response)
        } else {
            crate::operation_deser::parse_get_container_images_response(response)
        }
    }
}

/// Operation shape for `GetContainerLog`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_container_log`](crate::client::Client::get_container_log).
///
/// See [`crate::client::fluent_builders::GetContainerLog`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetContainerLog {
    _private: (),
}
impl GetContainerLog {
    /// Creates a new builder-style object to manufacture [`GetContainerLogInput`](crate::input::GetContainerLogInput)
    pub fn builder() -> crate::input::get_container_log_input::Builder {
        crate::input::get_container_log_input::Builder::default()
    }
    /// Creates a new `GetContainerLog` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetContainerLog {
    type Output = std::result::Result<
        crate::output::GetContainerLogOutput,
        crate::error::GetContainerLogError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_container_log_error(response)
        } else {
            crate::operation_deser::parse_get_container_log_response(response)
        }
    }
}

/// Operation shape for `GetContainerServiceDeployments`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_container_service_deployments`](crate::client::Client::get_container_service_deployments).
///
/// See [`crate::client::fluent_builders::GetContainerServiceDeployments`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetContainerServiceDeployments {
    _private: (),
}
impl GetContainerServiceDeployments {
    /// Creates a new builder-style object to manufacture [`GetContainerServiceDeploymentsInput`](crate::input::GetContainerServiceDeploymentsInput)
    pub fn builder() -> crate::input::get_container_service_deployments_input::Builder {
        crate::input::get_container_service_deployments_input::Builder::default()
    }
    /// Creates a new `GetContainerServiceDeployments` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetContainerServiceDeployments {
    type Output = std::result::Result<
        crate::output::GetContainerServiceDeploymentsOutput,
        crate::error::GetContainerServiceDeploymentsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_container_service_deployments_error(response)
        } else {
            crate::operation_deser::parse_get_container_service_deployments_response(response)
        }
    }
}

/// Operation shape for `GetContainerServiceMetricData`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_container_service_metric_data`](crate::client::Client::get_container_service_metric_data).
///
/// See [`crate::client::fluent_builders::GetContainerServiceMetricData`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetContainerServiceMetricData {
    _private: (),
}
impl GetContainerServiceMetricData {
    /// Creates a new builder-style object to manufacture [`GetContainerServiceMetricDataInput`](crate::input::GetContainerServiceMetricDataInput)
    pub fn builder() -> crate::input::get_container_service_metric_data_input::Builder {
        crate::input::get_container_service_metric_data_input::Builder::default()
    }
    /// Creates a new `GetContainerServiceMetricData` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetContainerServiceMetricData {
    type Output = std::result::Result<
        crate::output::GetContainerServiceMetricDataOutput,
        crate::error::GetContainerServiceMetricDataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_container_service_metric_data_error(response)
        } else {
            crate::operation_deser::parse_get_container_service_metric_data_response(response)
        }
    }
}

/// Operation shape for `GetContainerServicePowers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_container_service_powers`](crate::client::Client::get_container_service_powers).
///
/// See [`crate::client::fluent_builders::GetContainerServicePowers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetContainerServicePowers {
    _private: (),
}
impl GetContainerServicePowers {
    /// Creates a new builder-style object to manufacture [`GetContainerServicePowersInput`](crate::input::GetContainerServicePowersInput)
    pub fn builder() -> crate::input::get_container_service_powers_input::Builder {
        crate::input::get_container_service_powers_input::Builder::default()
    }
    /// Creates a new `GetContainerServicePowers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetContainerServicePowers {
    type Output = std::result::Result<
        crate::output::GetContainerServicePowersOutput,
        crate::error::GetContainerServicePowersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_container_service_powers_error(response)
        } else {
            crate::operation_deser::parse_get_container_service_powers_response(response)
        }
    }
}

/// Operation shape for `GetContainerServices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_container_services`](crate::client::Client::get_container_services).
///
/// See [`crate::client::fluent_builders::GetContainerServices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetContainerServices {
    _private: (),
}
impl GetContainerServices {
    /// Creates a new builder-style object to manufacture [`GetContainerServicesInput`](crate::input::GetContainerServicesInput)
    pub fn builder() -> crate::input::get_container_services_input::Builder {
        crate::input::get_container_services_input::Builder::default()
    }
    /// Creates a new `GetContainerServices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetContainerServices {
    type Output = std::result::Result<
        crate::output::GetContainerServicesOutput,
        crate::error::GetContainerServicesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_container_services_error(response)
        } else {
            crate::operation_deser::parse_get_container_services_response(response)
        }
    }
}

/// Operation shape for `GetDisk`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_disk`](crate::client::Client::get_disk).
///
/// See [`crate::client::fluent_builders::GetDisk`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDisk {
    _private: (),
}
impl GetDisk {
    /// Creates a new builder-style object to manufacture [`GetDiskInput`](crate::input::GetDiskInput)
    pub fn builder() -> crate::input::get_disk_input::Builder {
        crate::input::get_disk_input::Builder::default()
    }
    /// Creates a new `GetDisk` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDisk {
    type Output = std::result::Result<crate::output::GetDiskOutput, crate::error::GetDiskError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_disk_error(response)
        } else {
            crate::operation_deser::parse_get_disk_response(response)
        }
    }
}

/// Operation shape for `GetDisks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_disks`](crate::client::Client::get_disks).
///
/// See [`crate::client::fluent_builders::GetDisks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDisks {
    _private: (),
}
impl GetDisks {
    /// Creates a new builder-style object to manufacture [`GetDisksInput`](crate::input::GetDisksInput)
    pub fn builder() -> crate::input::get_disks_input::Builder {
        crate::input::get_disks_input::Builder::default()
    }
    /// Creates a new `GetDisks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDisks {
    type Output = std::result::Result<crate::output::GetDisksOutput, crate::error::GetDisksError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_disks_error(response)
        } else {
            crate::operation_deser::parse_get_disks_response(response)
        }
    }
}

/// Operation shape for `GetDiskSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_disk_snapshot`](crate::client::Client::get_disk_snapshot).
///
/// See [`crate::client::fluent_builders::GetDiskSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDiskSnapshot {
    _private: (),
}
impl GetDiskSnapshot {
    /// Creates a new builder-style object to manufacture [`GetDiskSnapshotInput`](crate::input::GetDiskSnapshotInput)
    pub fn builder() -> crate::input::get_disk_snapshot_input::Builder {
        crate::input::get_disk_snapshot_input::Builder::default()
    }
    /// Creates a new `GetDiskSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDiskSnapshot {
    type Output = std::result::Result<
        crate::output::GetDiskSnapshotOutput,
        crate::error::GetDiskSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_disk_snapshot_error(response)
        } else {
            crate::operation_deser::parse_get_disk_snapshot_response(response)
        }
    }
}

/// Operation shape for `GetDiskSnapshots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_disk_snapshots`](crate::client::Client::get_disk_snapshots).
///
/// See [`crate::client::fluent_builders::GetDiskSnapshots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDiskSnapshots {
    _private: (),
}
impl GetDiskSnapshots {
    /// Creates a new builder-style object to manufacture [`GetDiskSnapshotsInput`](crate::input::GetDiskSnapshotsInput)
    pub fn builder() -> crate::input::get_disk_snapshots_input::Builder {
        crate::input::get_disk_snapshots_input::Builder::default()
    }
    /// Creates a new `GetDiskSnapshots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDiskSnapshots {
    type Output = std::result::Result<
        crate::output::GetDiskSnapshotsOutput,
        crate::error::GetDiskSnapshotsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_disk_snapshots_error(response)
        } else {
            crate::operation_deser::parse_get_disk_snapshots_response(response)
        }
    }
}

/// Operation shape for `GetDistributionBundles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_distribution_bundles`](crate::client::Client::get_distribution_bundles).
///
/// See [`crate::client::fluent_builders::GetDistributionBundles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDistributionBundles {
    _private: (),
}
impl GetDistributionBundles {
    /// Creates a new builder-style object to manufacture [`GetDistributionBundlesInput`](crate::input::GetDistributionBundlesInput)
    pub fn builder() -> crate::input::get_distribution_bundles_input::Builder {
        crate::input::get_distribution_bundles_input::Builder::default()
    }
    /// Creates a new `GetDistributionBundles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDistributionBundles {
    type Output = std::result::Result<
        crate::output::GetDistributionBundlesOutput,
        crate::error::GetDistributionBundlesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_distribution_bundles_error(response)
        } else {
            crate::operation_deser::parse_get_distribution_bundles_response(response)
        }
    }
}

/// Operation shape for `GetDistributionLatestCacheReset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_distribution_latest_cache_reset`](crate::client::Client::get_distribution_latest_cache_reset).
///
/// See [`crate::client::fluent_builders::GetDistributionLatestCacheReset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDistributionLatestCacheReset {
    _private: (),
}
impl GetDistributionLatestCacheReset {
    /// Creates a new builder-style object to manufacture [`GetDistributionLatestCacheResetInput`](crate::input::GetDistributionLatestCacheResetInput)
    pub fn builder() -> crate::input::get_distribution_latest_cache_reset_input::Builder {
        crate::input::get_distribution_latest_cache_reset_input::Builder::default()
    }
    /// Creates a new `GetDistributionLatestCacheReset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDistributionLatestCacheReset {
    type Output = std::result::Result<
        crate::output::GetDistributionLatestCacheResetOutput,
        crate::error::GetDistributionLatestCacheResetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_distribution_latest_cache_reset_error(response)
        } else {
            crate::operation_deser::parse_get_distribution_latest_cache_reset_response(response)
        }
    }
}

/// Operation shape for `GetDistributionMetricData`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_distribution_metric_data`](crate::client::Client::get_distribution_metric_data).
///
/// See [`crate::client::fluent_builders::GetDistributionMetricData`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDistributionMetricData {
    _private: (),
}
impl GetDistributionMetricData {
    /// Creates a new builder-style object to manufacture [`GetDistributionMetricDataInput`](crate::input::GetDistributionMetricDataInput)
    pub fn builder() -> crate::input::get_distribution_metric_data_input::Builder {
        crate::input::get_distribution_metric_data_input::Builder::default()
    }
    /// Creates a new `GetDistributionMetricData` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDistributionMetricData {
    type Output = std::result::Result<
        crate::output::GetDistributionMetricDataOutput,
        crate::error::GetDistributionMetricDataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_distribution_metric_data_error(response)
        } else {
            crate::operation_deser::parse_get_distribution_metric_data_response(response)
        }
    }
}

/// Operation shape for `GetDistributions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_distributions`](crate::client::Client::get_distributions).
///
/// See [`crate::client::fluent_builders::GetDistributions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDistributions {
    _private: (),
}
impl GetDistributions {
    /// Creates a new builder-style object to manufacture [`GetDistributionsInput`](crate::input::GetDistributionsInput)
    pub fn builder() -> crate::input::get_distributions_input::Builder {
        crate::input::get_distributions_input::Builder::default()
    }
    /// Creates a new `GetDistributions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDistributions {
    type Output = std::result::Result<
        crate::output::GetDistributionsOutput,
        crate::error::GetDistributionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_distributions_error(response)
        } else {
            crate::operation_deser::parse_get_distributions_response(response)
        }
    }
}

/// Operation shape for `GetDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_domain`](crate::client::Client::get_domain).
///
/// See [`crate::client::fluent_builders::GetDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDomain {
    _private: (),
}
impl GetDomain {
    /// Creates a new builder-style object to manufacture [`GetDomainInput`](crate::input::GetDomainInput)
    pub fn builder() -> crate::input::get_domain_input::Builder {
        crate::input::get_domain_input::Builder::default()
    }
    /// Creates a new `GetDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDomain {
    type Output = std::result::Result<crate::output::GetDomainOutput, crate::error::GetDomainError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_domain_error(response)
        } else {
            crate::operation_deser::parse_get_domain_response(response)
        }
    }
}

/// Operation shape for `GetDomains`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_domains`](crate::client::Client::get_domains).
///
/// See [`crate::client::fluent_builders::GetDomains`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDomains {
    _private: (),
}
impl GetDomains {
    /// Creates a new builder-style object to manufacture [`GetDomainsInput`](crate::input::GetDomainsInput)
    pub fn builder() -> crate::input::get_domains_input::Builder {
        crate::input::get_domains_input::Builder::default()
    }
    /// Creates a new `GetDomains` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDomains {
    type Output =
        std::result::Result<crate::output::GetDomainsOutput, crate::error::GetDomainsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_domains_error(response)
        } else {
            crate::operation_deser::parse_get_domains_response(response)
        }
    }
}

/// Operation shape for `GetExportSnapshotRecords`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_export_snapshot_records`](crate::client::Client::get_export_snapshot_records).
///
/// See [`crate::client::fluent_builders::GetExportSnapshotRecords`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetExportSnapshotRecords {
    _private: (),
}
impl GetExportSnapshotRecords {
    /// Creates a new builder-style object to manufacture [`GetExportSnapshotRecordsInput`](crate::input::GetExportSnapshotRecordsInput)
    pub fn builder() -> crate::input::get_export_snapshot_records_input::Builder {
        crate::input::get_export_snapshot_records_input::Builder::default()
    }
    /// Creates a new `GetExportSnapshotRecords` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetExportSnapshotRecords {
    type Output = std::result::Result<
        crate::output::GetExportSnapshotRecordsOutput,
        crate::error::GetExportSnapshotRecordsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_export_snapshot_records_error(response)
        } else {
            crate::operation_deser::parse_get_export_snapshot_records_response(response)
        }
    }
}

/// Operation shape for `GetInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_instance`](crate::client::Client::get_instance).
///
/// See [`crate::client::fluent_builders::GetInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInstance {
    _private: (),
}
impl GetInstance {
    /// Creates a new builder-style object to manufacture [`GetInstanceInput`](crate::input::GetInstanceInput)
    pub fn builder() -> crate::input::get_instance_input::Builder {
        crate::input::get_instance_input::Builder::default()
    }
    /// Creates a new `GetInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInstance {
    type Output =
        std::result::Result<crate::output::GetInstanceOutput, crate::error::GetInstanceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_instance_error(response)
        } else {
            crate::operation_deser::parse_get_instance_response(response)
        }
    }
}

/// Operation shape for `GetInstanceAccessDetails`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_instance_access_details`](crate::client::Client::get_instance_access_details).
///
/// See [`crate::client::fluent_builders::GetInstanceAccessDetails`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInstanceAccessDetails {
    _private: (),
}
impl GetInstanceAccessDetails {
    /// Creates a new builder-style object to manufacture [`GetInstanceAccessDetailsInput`](crate::input::GetInstanceAccessDetailsInput)
    pub fn builder() -> crate::input::get_instance_access_details_input::Builder {
        crate::input::get_instance_access_details_input::Builder::default()
    }
    /// Creates a new `GetInstanceAccessDetails` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInstanceAccessDetails {
    type Output = std::result::Result<
        crate::output::GetInstanceAccessDetailsOutput,
        crate::error::GetInstanceAccessDetailsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_instance_access_details_error(response)
        } else {
            crate::operation_deser::parse_get_instance_access_details_response(response)
        }
    }
}

/// Operation shape for `GetInstanceMetricData`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_instance_metric_data`](crate::client::Client::get_instance_metric_data).
///
/// See [`crate::client::fluent_builders::GetInstanceMetricData`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInstanceMetricData {
    _private: (),
}
impl GetInstanceMetricData {
    /// Creates a new builder-style object to manufacture [`GetInstanceMetricDataInput`](crate::input::GetInstanceMetricDataInput)
    pub fn builder() -> crate::input::get_instance_metric_data_input::Builder {
        crate::input::get_instance_metric_data_input::Builder::default()
    }
    /// Creates a new `GetInstanceMetricData` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInstanceMetricData {
    type Output = std::result::Result<
        crate::output::GetInstanceMetricDataOutput,
        crate::error::GetInstanceMetricDataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_instance_metric_data_error(response)
        } else {
            crate::operation_deser::parse_get_instance_metric_data_response(response)
        }
    }
}

/// Operation shape for `GetInstancePortStates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_instance_port_states`](crate::client::Client::get_instance_port_states).
///
/// See [`crate::client::fluent_builders::GetInstancePortStates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInstancePortStates {
    _private: (),
}
impl GetInstancePortStates {
    /// Creates a new builder-style object to manufacture [`GetInstancePortStatesInput`](crate::input::GetInstancePortStatesInput)
    pub fn builder() -> crate::input::get_instance_port_states_input::Builder {
        crate::input::get_instance_port_states_input::Builder::default()
    }
    /// Creates a new `GetInstancePortStates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInstancePortStates {
    type Output = std::result::Result<
        crate::output::GetInstancePortStatesOutput,
        crate::error::GetInstancePortStatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_instance_port_states_error(response)
        } else {
            crate::operation_deser::parse_get_instance_port_states_response(response)
        }
    }
}

/// Operation shape for `GetInstances`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_instances`](crate::client::Client::get_instances).
///
/// See [`crate::client::fluent_builders::GetInstances`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInstances {
    _private: (),
}
impl GetInstances {
    /// Creates a new builder-style object to manufacture [`GetInstancesInput`](crate::input::GetInstancesInput)
    pub fn builder() -> crate::input::get_instances_input::Builder {
        crate::input::get_instances_input::Builder::default()
    }
    /// Creates a new `GetInstances` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInstances {
    type Output =
        std::result::Result<crate::output::GetInstancesOutput, crate::error::GetInstancesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_instances_error(response)
        } else {
            crate::operation_deser::parse_get_instances_response(response)
        }
    }
}

/// Operation shape for `GetInstanceSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_instance_snapshot`](crate::client::Client::get_instance_snapshot).
///
/// See [`crate::client::fluent_builders::GetInstanceSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInstanceSnapshot {
    _private: (),
}
impl GetInstanceSnapshot {
    /// Creates a new builder-style object to manufacture [`GetInstanceSnapshotInput`](crate::input::GetInstanceSnapshotInput)
    pub fn builder() -> crate::input::get_instance_snapshot_input::Builder {
        crate::input::get_instance_snapshot_input::Builder::default()
    }
    /// Creates a new `GetInstanceSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInstanceSnapshot {
    type Output = std::result::Result<
        crate::output::GetInstanceSnapshotOutput,
        crate::error::GetInstanceSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_instance_snapshot_error(response)
        } else {
            crate::operation_deser::parse_get_instance_snapshot_response(response)
        }
    }
}

/// Operation shape for `GetInstanceSnapshots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_instance_snapshots`](crate::client::Client::get_instance_snapshots).
///
/// See [`crate::client::fluent_builders::GetInstanceSnapshots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInstanceSnapshots {
    _private: (),
}
impl GetInstanceSnapshots {
    /// Creates a new builder-style object to manufacture [`GetInstanceSnapshotsInput`](crate::input::GetInstanceSnapshotsInput)
    pub fn builder() -> crate::input::get_instance_snapshots_input::Builder {
        crate::input::get_instance_snapshots_input::Builder::default()
    }
    /// Creates a new `GetInstanceSnapshots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInstanceSnapshots {
    type Output = std::result::Result<
        crate::output::GetInstanceSnapshotsOutput,
        crate::error::GetInstanceSnapshotsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_instance_snapshots_error(response)
        } else {
            crate::operation_deser::parse_get_instance_snapshots_response(response)
        }
    }
}

/// Operation shape for `GetInstanceState`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_instance_state`](crate::client::Client::get_instance_state).
///
/// See [`crate::client::fluent_builders::GetInstanceState`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInstanceState {
    _private: (),
}
impl GetInstanceState {
    /// Creates a new builder-style object to manufacture [`GetInstanceStateInput`](crate::input::GetInstanceStateInput)
    pub fn builder() -> crate::input::get_instance_state_input::Builder {
        crate::input::get_instance_state_input::Builder::default()
    }
    /// Creates a new `GetInstanceState` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInstanceState {
    type Output = std::result::Result<
        crate::output::GetInstanceStateOutput,
        crate::error::GetInstanceStateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_instance_state_error(response)
        } else {
            crate::operation_deser::parse_get_instance_state_response(response)
        }
    }
}

/// Operation shape for `GetKeyPair`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_key_pair`](crate::client::Client::get_key_pair).
///
/// See [`crate::client::fluent_builders::GetKeyPair`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetKeyPair {
    _private: (),
}
impl GetKeyPair {
    /// Creates a new builder-style object to manufacture [`GetKeyPairInput`](crate::input::GetKeyPairInput)
    pub fn builder() -> crate::input::get_key_pair_input::Builder {
        crate::input::get_key_pair_input::Builder::default()
    }
    /// Creates a new `GetKeyPair` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetKeyPair {
    type Output =
        std::result::Result<crate::output::GetKeyPairOutput, crate::error::GetKeyPairError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_key_pair_error(response)
        } else {
            crate::operation_deser::parse_get_key_pair_response(response)
        }
    }
}

/// Operation shape for `GetKeyPairs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_key_pairs`](crate::client::Client::get_key_pairs).
///
/// See [`crate::client::fluent_builders::GetKeyPairs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetKeyPairs {
    _private: (),
}
impl GetKeyPairs {
    /// Creates a new builder-style object to manufacture [`GetKeyPairsInput`](crate::input::GetKeyPairsInput)
    pub fn builder() -> crate::input::get_key_pairs_input::Builder {
        crate::input::get_key_pairs_input::Builder::default()
    }
    /// Creates a new `GetKeyPairs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetKeyPairs {
    type Output =
        std::result::Result<crate::output::GetKeyPairsOutput, crate::error::GetKeyPairsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_key_pairs_error(response)
        } else {
            crate::operation_deser::parse_get_key_pairs_response(response)
        }
    }
}

/// Operation shape for `GetLoadBalancer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_load_balancer`](crate::client::Client::get_load_balancer).
///
/// See [`crate::client::fluent_builders::GetLoadBalancer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLoadBalancer {
    _private: (),
}
impl GetLoadBalancer {
    /// Creates a new builder-style object to manufacture [`GetLoadBalancerInput`](crate::input::GetLoadBalancerInput)
    pub fn builder() -> crate::input::get_load_balancer_input::Builder {
        crate::input::get_load_balancer_input::Builder::default()
    }
    /// Creates a new `GetLoadBalancer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLoadBalancer {
    type Output = std::result::Result<
        crate::output::GetLoadBalancerOutput,
        crate::error::GetLoadBalancerError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_load_balancer_error(response)
        } else {
            crate::operation_deser::parse_get_load_balancer_response(response)
        }
    }
}

/// Operation shape for `GetLoadBalancerMetricData`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_load_balancer_metric_data`](crate::client::Client::get_load_balancer_metric_data).
///
/// See [`crate::client::fluent_builders::GetLoadBalancerMetricData`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLoadBalancerMetricData {
    _private: (),
}
impl GetLoadBalancerMetricData {
    /// Creates a new builder-style object to manufacture [`GetLoadBalancerMetricDataInput`](crate::input::GetLoadBalancerMetricDataInput)
    pub fn builder() -> crate::input::get_load_balancer_metric_data_input::Builder {
        crate::input::get_load_balancer_metric_data_input::Builder::default()
    }
    /// Creates a new `GetLoadBalancerMetricData` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLoadBalancerMetricData {
    type Output = std::result::Result<
        crate::output::GetLoadBalancerMetricDataOutput,
        crate::error::GetLoadBalancerMetricDataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_load_balancer_metric_data_error(response)
        } else {
            crate::operation_deser::parse_get_load_balancer_metric_data_response(response)
        }
    }
}

/// Operation shape for `GetLoadBalancers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_load_balancers`](crate::client::Client::get_load_balancers).
///
/// See [`crate::client::fluent_builders::GetLoadBalancers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLoadBalancers {
    _private: (),
}
impl GetLoadBalancers {
    /// Creates a new builder-style object to manufacture [`GetLoadBalancersInput`](crate::input::GetLoadBalancersInput)
    pub fn builder() -> crate::input::get_load_balancers_input::Builder {
        crate::input::get_load_balancers_input::Builder::default()
    }
    /// Creates a new `GetLoadBalancers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLoadBalancers {
    type Output = std::result::Result<
        crate::output::GetLoadBalancersOutput,
        crate::error::GetLoadBalancersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_load_balancers_error(response)
        } else {
            crate::operation_deser::parse_get_load_balancers_response(response)
        }
    }
}

/// Operation shape for `GetLoadBalancerTlsCertificates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_load_balancer_tls_certificates`](crate::client::Client::get_load_balancer_tls_certificates).
///
/// See [`crate::client::fluent_builders::GetLoadBalancerTlsCertificates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLoadBalancerTlsCertificates {
    _private: (),
}
impl GetLoadBalancerTlsCertificates {
    /// Creates a new builder-style object to manufacture [`GetLoadBalancerTlsCertificatesInput`](crate::input::GetLoadBalancerTlsCertificatesInput)
    pub fn builder() -> crate::input::get_load_balancer_tls_certificates_input::Builder {
        crate::input::get_load_balancer_tls_certificates_input::Builder::default()
    }
    /// Creates a new `GetLoadBalancerTlsCertificates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLoadBalancerTlsCertificates {
    type Output = std::result::Result<
        crate::output::GetLoadBalancerTlsCertificatesOutput,
        crate::error::GetLoadBalancerTlsCertificatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_load_balancer_tls_certificates_error(response)
        } else {
            crate::operation_deser::parse_get_load_balancer_tls_certificates_response(response)
        }
    }
}

/// Operation shape for `GetOperation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_operation`](crate::client::Client::get_operation).
///
/// See [`crate::client::fluent_builders::GetOperation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetOperation {
    _private: (),
}
impl GetOperation {
    /// Creates a new builder-style object to manufacture [`GetOperationInput`](crate::input::GetOperationInput)
    pub fn builder() -> crate::input::get_operation_input::Builder {
        crate::input::get_operation_input::Builder::default()
    }
    /// Creates a new `GetOperation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetOperation {
    type Output =
        std::result::Result<crate::output::GetOperationOutput, crate::error::GetOperationError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_operation_error(response)
        } else {
            crate::operation_deser::parse_get_operation_response(response)
        }
    }
}

/// Operation shape for `GetOperations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_operations`](crate::client::Client::get_operations).
///
/// See [`crate::client::fluent_builders::GetOperations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetOperations {
    _private: (),
}
impl GetOperations {
    /// Creates a new builder-style object to manufacture [`GetOperationsInput`](crate::input::GetOperationsInput)
    pub fn builder() -> crate::input::get_operations_input::Builder {
        crate::input::get_operations_input::Builder::default()
    }
    /// Creates a new `GetOperations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetOperations {
    type Output =
        std::result::Result<crate::output::GetOperationsOutput, crate::error::GetOperationsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_operations_error(response)
        } else {
            crate::operation_deser::parse_get_operations_response(response)
        }
    }
}

/// Operation shape for `GetOperationsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_operations_for_resource`](crate::client::Client::get_operations_for_resource).
///
/// See [`crate::client::fluent_builders::GetOperationsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetOperationsForResource {
    _private: (),
}
impl GetOperationsForResource {
    /// Creates a new builder-style object to manufacture [`GetOperationsForResourceInput`](crate::input::GetOperationsForResourceInput)
    pub fn builder() -> crate::input::get_operations_for_resource_input::Builder {
        crate::input::get_operations_for_resource_input::Builder::default()
    }
    /// Creates a new `GetOperationsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetOperationsForResource {
    type Output = std::result::Result<
        crate::output::GetOperationsForResourceOutput,
        crate::error::GetOperationsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_operations_for_resource_error(response)
        } else {
            crate::operation_deser::parse_get_operations_for_resource_response(response)
        }
    }
}

/// Operation shape for `GetRegions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_regions`](crate::client::Client::get_regions).
///
/// See [`crate::client::fluent_builders::GetRegions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRegions {
    _private: (),
}
impl GetRegions {
    /// Creates a new builder-style object to manufacture [`GetRegionsInput`](crate::input::GetRegionsInput)
    pub fn builder() -> crate::input::get_regions_input::Builder {
        crate::input::get_regions_input::Builder::default()
    }
    /// Creates a new `GetRegions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRegions {
    type Output =
        std::result::Result<crate::output::GetRegionsOutput, crate::error::GetRegionsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_regions_error(response)
        } else {
            crate::operation_deser::parse_get_regions_response(response)
        }
    }
}

/// Operation shape for `GetRelationalDatabase`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_relational_database`](crate::client::Client::get_relational_database).
///
/// See [`crate::client::fluent_builders::GetRelationalDatabase`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRelationalDatabase {
    _private: (),
}
impl GetRelationalDatabase {
    /// Creates a new builder-style object to manufacture [`GetRelationalDatabaseInput`](crate::input::GetRelationalDatabaseInput)
    pub fn builder() -> crate::input::get_relational_database_input::Builder {
        crate::input::get_relational_database_input::Builder::default()
    }
    /// Creates a new `GetRelationalDatabase` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRelationalDatabase {
    type Output = std::result::Result<
        crate::output::GetRelationalDatabaseOutput,
        crate::error::GetRelationalDatabaseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_relational_database_error(response)
        } else {
            crate::operation_deser::parse_get_relational_database_response(response)
        }
    }
}

/// Operation shape for `GetRelationalDatabaseBlueprints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_relational_database_blueprints`](crate::client::Client::get_relational_database_blueprints).
///
/// See [`crate::client::fluent_builders::GetRelationalDatabaseBlueprints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRelationalDatabaseBlueprints {
    _private: (),
}
impl GetRelationalDatabaseBlueprints {
    /// Creates a new builder-style object to manufacture [`GetRelationalDatabaseBlueprintsInput`](crate::input::GetRelationalDatabaseBlueprintsInput)
    pub fn builder() -> crate::input::get_relational_database_blueprints_input::Builder {
        crate::input::get_relational_database_blueprints_input::Builder::default()
    }
    /// Creates a new `GetRelationalDatabaseBlueprints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRelationalDatabaseBlueprints {
    type Output = std::result::Result<
        crate::output::GetRelationalDatabaseBlueprintsOutput,
        crate::error::GetRelationalDatabaseBlueprintsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_relational_database_blueprints_error(response)
        } else {
            crate::operation_deser::parse_get_relational_database_blueprints_response(response)
        }
    }
}

/// Operation shape for `GetRelationalDatabaseBundles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_relational_database_bundles`](crate::client::Client::get_relational_database_bundles).
///
/// See [`crate::client::fluent_builders::GetRelationalDatabaseBundles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRelationalDatabaseBundles {
    _private: (),
}
impl GetRelationalDatabaseBundles {
    /// Creates a new builder-style object to manufacture [`GetRelationalDatabaseBundlesInput`](crate::input::GetRelationalDatabaseBundlesInput)
    pub fn builder() -> crate::input::get_relational_database_bundles_input::Builder {
        crate::input::get_relational_database_bundles_input::Builder::default()
    }
    /// Creates a new `GetRelationalDatabaseBundles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRelationalDatabaseBundles {
    type Output = std::result::Result<
        crate::output::GetRelationalDatabaseBundlesOutput,
        crate::error::GetRelationalDatabaseBundlesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_relational_database_bundles_error(response)
        } else {
            crate::operation_deser::parse_get_relational_database_bundles_response(response)
        }
    }
}

/// Operation shape for `GetRelationalDatabaseEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_relational_database_events`](crate::client::Client::get_relational_database_events).
///
/// See [`crate::client::fluent_builders::GetRelationalDatabaseEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRelationalDatabaseEvents {
    _private: (),
}
impl GetRelationalDatabaseEvents {
    /// Creates a new builder-style object to manufacture [`GetRelationalDatabaseEventsInput`](crate::input::GetRelationalDatabaseEventsInput)
    pub fn builder() -> crate::input::get_relational_database_events_input::Builder {
        crate::input::get_relational_database_events_input::Builder::default()
    }
    /// Creates a new `GetRelationalDatabaseEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRelationalDatabaseEvents {
    type Output = std::result::Result<
        crate::output::GetRelationalDatabaseEventsOutput,
        crate::error::GetRelationalDatabaseEventsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_relational_database_events_error(response)
        } else {
            crate::operation_deser::parse_get_relational_database_events_response(response)
        }
    }
}

/// Operation shape for `GetRelationalDatabaseLogEvents`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_relational_database_log_events`](crate::client::Client::get_relational_database_log_events).
///
/// See [`crate::client::fluent_builders::GetRelationalDatabaseLogEvents`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRelationalDatabaseLogEvents {
    _private: (),
}
impl GetRelationalDatabaseLogEvents {
    /// Creates a new builder-style object to manufacture [`GetRelationalDatabaseLogEventsInput`](crate::input::GetRelationalDatabaseLogEventsInput)
    pub fn builder() -> crate::input::get_relational_database_log_events_input::Builder {
        crate::input::get_relational_database_log_events_input::Builder::default()
    }
    /// Creates a new `GetRelationalDatabaseLogEvents` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRelationalDatabaseLogEvents {
    type Output = std::result::Result<
        crate::output::GetRelationalDatabaseLogEventsOutput,
        crate::error::GetRelationalDatabaseLogEventsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_relational_database_log_events_error(response)
        } else {
            crate::operation_deser::parse_get_relational_database_log_events_response(response)
        }
    }
}

/// Operation shape for `GetRelationalDatabaseLogStreams`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_relational_database_log_streams`](crate::client::Client::get_relational_database_log_streams).
///
/// See [`crate::client::fluent_builders::GetRelationalDatabaseLogStreams`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRelationalDatabaseLogStreams {
    _private: (),
}
impl GetRelationalDatabaseLogStreams {
    /// Creates a new builder-style object to manufacture [`GetRelationalDatabaseLogStreamsInput`](crate::input::GetRelationalDatabaseLogStreamsInput)
    pub fn builder() -> crate::input::get_relational_database_log_streams_input::Builder {
        crate::input::get_relational_database_log_streams_input::Builder::default()
    }
    /// Creates a new `GetRelationalDatabaseLogStreams` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRelationalDatabaseLogStreams {
    type Output = std::result::Result<
        crate::output::GetRelationalDatabaseLogStreamsOutput,
        crate::error::GetRelationalDatabaseLogStreamsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_relational_database_log_streams_error(response)
        } else {
            crate::operation_deser::parse_get_relational_database_log_streams_response(response)
        }
    }
}

/// Operation shape for `GetRelationalDatabaseMasterUserPassword`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_relational_database_master_user_password`](crate::client::Client::get_relational_database_master_user_password).
///
/// See [`crate::client::fluent_builders::GetRelationalDatabaseMasterUserPassword`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRelationalDatabaseMasterUserPassword {
    _private: (),
}
impl GetRelationalDatabaseMasterUserPassword {
    /// Creates a new builder-style object to manufacture [`GetRelationalDatabaseMasterUserPasswordInput`](crate::input::GetRelationalDatabaseMasterUserPasswordInput)
    pub fn builder() -> crate::input::get_relational_database_master_user_password_input::Builder {
        crate::input::get_relational_database_master_user_password_input::Builder::default()
    }
    /// Creates a new `GetRelationalDatabaseMasterUserPassword` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRelationalDatabaseMasterUserPassword {
    type Output = std::result::Result<
        crate::output::GetRelationalDatabaseMasterUserPasswordOutput,
        crate::error::GetRelationalDatabaseMasterUserPasswordError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_relational_database_master_user_password_error(
                response,
            )
        } else {
            crate::operation_deser::parse_get_relational_database_master_user_password_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetRelationalDatabaseMetricData`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_relational_database_metric_data`](crate::client::Client::get_relational_database_metric_data).
///
/// See [`crate::client::fluent_builders::GetRelationalDatabaseMetricData`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRelationalDatabaseMetricData {
    _private: (),
}
impl GetRelationalDatabaseMetricData {
    /// Creates a new builder-style object to manufacture [`GetRelationalDatabaseMetricDataInput`](crate::input::GetRelationalDatabaseMetricDataInput)
    pub fn builder() -> crate::input::get_relational_database_metric_data_input::Builder {
        crate::input::get_relational_database_metric_data_input::Builder::default()
    }
    /// Creates a new `GetRelationalDatabaseMetricData` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRelationalDatabaseMetricData {
    type Output = std::result::Result<
        crate::output::GetRelationalDatabaseMetricDataOutput,
        crate::error::GetRelationalDatabaseMetricDataError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_relational_database_metric_data_error(response)
        } else {
            crate::operation_deser::parse_get_relational_database_metric_data_response(response)
        }
    }
}

/// Operation shape for `GetRelationalDatabaseParameters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_relational_database_parameters`](crate::client::Client::get_relational_database_parameters).
///
/// See [`crate::client::fluent_builders::GetRelationalDatabaseParameters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRelationalDatabaseParameters {
    _private: (),
}
impl GetRelationalDatabaseParameters {
    /// Creates a new builder-style object to manufacture [`GetRelationalDatabaseParametersInput`](crate::input::GetRelationalDatabaseParametersInput)
    pub fn builder() -> crate::input::get_relational_database_parameters_input::Builder {
        crate::input::get_relational_database_parameters_input::Builder::default()
    }
    /// Creates a new `GetRelationalDatabaseParameters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRelationalDatabaseParameters {
    type Output = std::result::Result<
        crate::output::GetRelationalDatabaseParametersOutput,
        crate::error::GetRelationalDatabaseParametersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_relational_database_parameters_error(response)
        } else {
            crate::operation_deser::parse_get_relational_database_parameters_response(response)
        }
    }
}

/// Operation shape for `GetRelationalDatabases`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_relational_databases`](crate::client::Client::get_relational_databases).
///
/// See [`crate::client::fluent_builders::GetRelationalDatabases`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRelationalDatabases {
    _private: (),
}
impl GetRelationalDatabases {
    /// Creates a new builder-style object to manufacture [`GetRelationalDatabasesInput`](crate::input::GetRelationalDatabasesInput)
    pub fn builder() -> crate::input::get_relational_databases_input::Builder {
        crate::input::get_relational_databases_input::Builder::default()
    }
    /// Creates a new `GetRelationalDatabases` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRelationalDatabases {
    type Output = std::result::Result<
        crate::output::GetRelationalDatabasesOutput,
        crate::error::GetRelationalDatabasesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_relational_databases_error(response)
        } else {
            crate::operation_deser::parse_get_relational_databases_response(response)
        }
    }
}

/// Operation shape for `GetRelationalDatabaseSnapshot`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_relational_database_snapshot`](crate::client::Client::get_relational_database_snapshot).
///
/// See [`crate::client::fluent_builders::GetRelationalDatabaseSnapshot`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRelationalDatabaseSnapshot {
    _private: (),
}
impl GetRelationalDatabaseSnapshot {
    /// Creates a new builder-style object to manufacture [`GetRelationalDatabaseSnapshotInput`](crate::input::GetRelationalDatabaseSnapshotInput)
    pub fn builder() -> crate::input::get_relational_database_snapshot_input::Builder {
        crate::input::get_relational_database_snapshot_input::Builder::default()
    }
    /// Creates a new `GetRelationalDatabaseSnapshot` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRelationalDatabaseSnapshot {
    type Output = std::result::Result<
        crate::output::GetRelationalDatabaseSnapshotOutput,
        crate::error::GetRelationalDatabaseSnapshotError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_relational_database_snapshot_error(response)
        } else {
            crate::operation_deser::parse_get_relational_database_snapshot_response(response)
        }
    }
}

/// Operation shape for `GetRelationalDatabaseSnapshots`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_relational_database_snapshots`](crate::client::Client::get_relational_database_snapshots).
///
/// See [`crate::client::fluent_builders::GetRelationalDatabaseSnapshots`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRelationalDatabaseSnapshots {
    _private: (),
}
impl GetRelationalDatabaseSnapshots {
    /// Creates a new builder-style object to manufacture [`GetRelationalDatabaseSnapshotsInput`](crate::input::GetRelationalDatabaseSnapshotsInput)
    pub fn builder() -> crate::input::get_relational_database_snapshots_input::Builder {
        crate::input::get_relational_database_snapshots_input::Builder::default()
    }
    /// Creates a new `GetRelationalDatabaseSnapshots` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRelationalDatabaseSnapshots {
    type Output = std::result::Result<
        crate::output::GetRelationalDatabaseSnapshotsOutput,
        crate::error::GetRelationalDatabaseSnapshotsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_relational_database_snapshots_error(response)
        } else {
            crate::operation_deser::parse_get_relational_database_snapshots_response(response)
        }
    }
}

/// Operation shape for `GetStaticIp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_static_ip`](crate::client::Client::get_static_ip).
///
/// See [`crate::client::fluent_builders::GetStaticIp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetStaticIp {
    _private: (),
}
impl GetStaticIp {
    /// Creates a new builder-style object to manufacture [`GetStaticIpInput`](crate::input::GetStaticIpInput)
    pub fn builder() -> crate::input::get_static_ip_input::Builder {
        crate::input::get_static_ip_input::Builder::default()
    }
    /// Creates a new `GetStaticIp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetStaticIp {
    type Output =
        std::result::Result<crate::output::GetStaticIpOutput, crate::error::GetStaticIpError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_static_ip_error(response)
        } else {
            crate::operation_deser::parse_get_static_ip_response(response)
        }
    }
}

/// Operation shape for `GetStaticIps`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_static_ips`](crate::client::Client::get_static_ips).
///
/// See [`crate::client::fluent_builders::GetStaticIps`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetStaticIps {
    _private: (),
}
impl GetStaticIps {
    /// Creates a new builder-style object to manufacture [`GetStaticIpsInput`](crate::input::GetStaticIpsInput)
    pub fn builder() -> crate::input::get_static_ips_input::Builder {
        crate::input::get_static_ips_input::Builder::default()
    }
    /// Creates a new `GetStaticIps` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetStaticIps {
    type Output =
        std::result::Result<crate::output::GetStaticIpsOutput, crate::error::GetStaticIpsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_static_ips_error(response)
        } else {
            crate::operation_deser::parse_get_static_ips_response(response)
        }
    }
}

/// Operation shape for `ImportKeyPair`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`import_key_pair`](crate::client::Client::import_key_pair).
///
/// See [`crate::client::fluent_builders::ImportKeyPair`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ImportKeyPair {
    _private: (),
}
impl ImportKeyPair {
    /// Creates a new builder-style object to manufacture [`ImportKeyPairInput`](crate::input::ImportKeyPairInput)
    pub fn builder() -> crate::input::import_key_pair_input::Builder {
        crate::input::import_key_pair_input::Builder::default()
    }
    /// Creates a new `ImportKeyPair` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ImportKeyPair {
    type Output =
        std::result::Result<crate::output::ImportKeyPairOutput, crate::error::ImportKeyPairError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_import_key_pair_error(response)
        } else {
            crate::operation_deser::parse_import_key_pair_response(response)
        }
    }
}

/// Operation shape for `IsVpcPeered`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`is_vpc_peered`](crate::client::Client::is_vpc_peered).
///
/// See [`crate::client::fluent_builders::IsVpcPeered`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct IsVpcPeered {
    _private: (),
}
impl IsVpcPeered {
    /// Creates a new builder-style object to manufacture [`IsVpcPeeredInput`](crate::input::IsVpcPeeredInput)
    pub fn builder() -> crate::input::is_vpc_peered_input::Builder {
        crate::input::is_vpc_peered_input::Builder::default()
    }
    /// Creates a new `IsVpcPeered` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for IsVpcPeered {
    type Output =
        std::result::Result<crate::output::IsVpcPeeredOutput, crate::error::IsVpcPeeredError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_is_vpc_peered_error(response)
        } else {
            crate::operation_deser::parse_is_vpc_peered_response(response)
        }
    }
}

/// Operation shape for `OpenInstancePublicPorts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`open_instance_public_ports`](crate::client::Client::open_instance_public_ports).
///
/// See [`crate::client::fluent_builders::OpenInstancePublicPorts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct OpenInstancePublicPorts {
    _private: (),
}
impl OpenInstancePublicPorts {
    /// Creates a new builder-style object to manufacture [`OpenInstancePublicPortsInput`](crate::input::OpenInstancePublicPortsInput)
    pub fn builder() -> crate::input::open_instance_public_ports_input::Builder {
        crate::input::open_instance_public_ports_input::Builder::default()
    }
    /// Creates a new `OpenInstancePublicPorts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for OpenInstancePublicPorts {
    type Output = std::result::Result<
        crate::output::OpenInstancePublicPortsOutput,
        crate::error::OpenInstancePublicPortsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_open_instance_public_ports_error(response)
        } else {
            crate::operation_deser::parse_open_instance_public_ports_response(response)
        }
    }
}

/// Operation shape for `PeerVpc`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`peer_vpc`](crate::client::Client::peer_vpc).
///
/// See [`crate::client::fluent_builders::PeerVpc`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PeerVpc {
    _private: (),
}
impl PeerVpc {
    /// Creates a new builder-style object to manufacture [`PeerVpcInput`](crate::input::PeerVpcInput)
    pub fn builder() -> crate::input::peer_vpc_input::Builder {
        crate::input::peer_vpc_input::Builder::default()
    }
    /// Creates a new `PeerVpc` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PeerVpc {
    type Output = std::result::Result<crate::output::PeerVpcOutput, crate::error::PeerVpcError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_peer_vpc_error(response)
        } else {
            crate::operation_deser::parse_peer_vpc_response(response)
        }
    }
}

/// Operation shape for `PutAlarm`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_alarm`](crate::client::Client::put_alarm).
///
/// See [`crate::client::fluent_builders::PutAlarm`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutAlarm {
    _private: (),
}
impl PutAlarm {
    /// Creates a new builder-style object to manufacture [`PutAlarmInput`](crate::input::PutAlarmInput)
    pub fn builder() -> crate::input::put_alarm_input::Builder {
        crate::input::put_alarm_input::Builder::default()
    }
    /// Creates a new `PutAlarm` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutAlarm {
    type Output = std::result::Result<crate::output::PutAlarmOutput, crate::error::PutAlarmError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_alarm_error(response)
        } else {
            crate::operation_deser::parse_put_alarm_response(response)
        }
    }
}

/// Operation shape for `PutInstancePublicPorts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_instance_public_ports`](crate::client::Client::put_instance_public_ports).
///
/// See [`crate::client::fluent_builders::PutInstancePublicPorts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutInstancePublicPorts {
    _private: (),
}
impl PutInstancePublicPorts {
    /// Creates a new builder-style object to manufacture [`PutInstancePublicPortsInput`](crate::input::PutInstancePublicPortsInput)
    pub fn builder() -> crate::input::put_instance_public_ports_input::Builder {
        crate::input::put_instance_public_ports_input::Builder::default()
    }
    /// Creates a new `PutInstancePublicPorts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutInstancePublicPorts {
    type Output = std::result::Result<
        crate::output::PutInstancePublicPortsOutput,
        crate::error::PutInstancePublicPortsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_instance_public_ports_error(response)
        } else {
            crate::operation_deser::parse_put_instance_public_ports_response(response)
        }
    }
}

/// Operation shape for `RebootInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reboot_instance`](crate::client::Client::reboot_instance).
///
/// See [`crate::client::fluent_builders::RebootInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RebootInstance {
    _private: (),
}
impl RebootInstance {
    /// Creates a new builder-style object to manufacture [`RebootInstanceInput`](crate::input::RebootInstanceInput)
    pub fn builder() -> crate::input::reboot_instance_input::Builder {
        crate::input::reboot_instance_input::Builder::default()
    }
    /// Creates a new `RebootInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RebootInstance {
    type Output =
        std::result::Result<crate::output::RebootInstanceOutput, crate::error::RebootInstanceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reboot_instance_error(response)
        } else {
            crate::operation_deser::parse_reboot_instance_response(response)
        }
    }
}

/// Operation shape for `RebootRelationalDatabase`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reboot_relational_database`](crate::client::Client::reboot_relational_database).
///
/// See [`crate::client::fluent_builders::RebootRelationalDatabase`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RebootRelationalDatabase {
    _private: (),
}
impl RebootRelationalDatabase {
    /// Creates a new builder-style object to manufacture [`RebootRelationalDatabaseInput`](crate::input::RebootRelationalDatabaseInput)
    pub fn builder() -> crate::input::reboot_relational_database_input::Builder {
        crate::input::reboot_relational_database_input::Builder::default()
    }
    /// Creates a new `RebootRelationalDatabase` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RebootRelationalDatabase {
    type Output = std::result::Result<
        crate::output::RebootRelationalDatabaseOutput,
        crate::error::RebootRelationalDatabaseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reboot_relational_database_error(response)
        } else {
            crate::operation_deser::parse_reboot_relational_database_response(response)
        }
    }
}

/// Operation shape for `RegisterContainerImage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`register_container_image`](crate::client::Client::register_container_image).
///
/// See [`crate::client::fluent_builders::RegisterContainerImage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RegisterContainerImage {
    _private: (),
}
impl RegisterContainerImage {
    /// Creates a new builder-style object to manufacture [`RegisterContainerImageInput`](crate::input::RegisterContainerImageInput)
    pub fn builder() -> crate::input::register_container_image_input::Builder {
        crate::input::register_container_image_input::Builder::default()
    }
    /// Creates a new `RegisterContainerImage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RegisterContainerImage {
    type Output = std::result::Result<
        crate::output::RegisterContainerImageOutput,
        crate::error::RegisterContainerImageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_register_container_image_error(response)
        } else {
            crate::operation_deser::parse_register_container_image_response(response)
        }
    }
}

/// Operation shape for `ReleaseStaticIp`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`release_static_ip`](crate::client::Client::release_static_ip).
///
/// See [`crate::client::fluent_builders::ReleaseStaticIp`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ReleaseStaticIp {
    _private: (),
}
impl ReleaseStaticIp {
    /// Creates a new builder-style object to manufacture [`ReleaseStaticIpInput`](crate::input::ReleaseStaticIpInput)
    pub fn builder() -> crate::input::release_static_ip_input::Builder {
        crate::input::release_static_ip_input::Builder::default()
    }
    /// Creates a new `ReleaseStaticIp` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ReleaseStaticIp {
    type Output = std::result::Result<
        crate::output::ReleaseStaticIpOutput,
        crate::error::ReleaseStaticIpError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_release_static_ip_error(response)
        } else {
            crate::operation_deser::parse_release_static_ip_response(response)
        }
    }
}

/// Operation shape for `ResetDistributionCache`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reset_distribution_cache`](crate::client::Client::reset_distribution_cache).
///
/// See [`crate::client::fluent_builders::ResetDistributionCache`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ResetDistributionCache {
    _private: (),
}
impl ResetDistributionCache {
    /// Creates a new builder-style object to manufacture [`ResetDistributionCacheInput`](crate::input::ResetDistributionCacheInput)
    pub fn builder() -> crate::input::reset_distribution_cache_input::Builder {
        crate::input::reset_distribution_cache_input::Builder::default()
    }
    /// Creates a new `ResetDistributionCache` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ResetDistributionCache {
    type Output = std::result::Result<
        crate::output::ResetDistributionCacheOutput,
        crate::error::ResetDistributionCacheError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reset_distribution_cache_error(response)
        } else {
            crate::operation_deser::parse_reset_distribution_cache_response(response)
        }
    }
}

/// Operation shape for `SendContactMethodVerification`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_contact_method_verification`](crate::client::Client::send_contact_method_verification).
///
/// See [`crate::client::fluent_builders::SendContactMethodVerification`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendContactMethodVerification {
    _private: (),
}
impl SendContactMethodVerification {
    /// Creates a new builder-style object to manufacture [`SendContactMethodVerificationInput`](crate::input::SendContactMethodVerificationInput)
    pub fn builder() -> crate::input::send_contact_method_verification_input::Builder {
        crate::input::send_contact_method_verification_input::Builder::default()
    }
    /// Creates a new `SendContactMethodVerification` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendContactMethodVerification {
    type Output = std::result::Result<
        crate::output::SendContactMethodVerificationOutput,
        crate::error::SendContactMethodVerificationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_contact_method_verification_error(response)
        } else {
            crate::operation_deser::parse_send_contact_method_verification_response(response)
        }
    }
}

/// Operation shape for `SetIpAddressType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_ip_address_type`](crate::client::Client::set_ip_address_type).
///
/// See [`crate::client::fluent_builders::SetIpAddressType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetIpAddressType {
    _private: (),
}
impl SetIpAddressType {
    /// Creates a new builder-style object to manufacture [`SetIpAddressTypeInput`](crate::input::SetIpAddressTypeInput)
    pub fn builder() -> crate::input::set_ip_address_type_input::Builder {
        crate::input::set_ip_address_type_input::Builder::default()
    }
    /// Creates a new `SetIpAddressType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetIpAddressType {
    type Output = std::result::Result<
        crate::output::SetIpAddressTypeOutput,
        crate::error::SetIpAddressTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_ip_address_type_error(response)
        } else {
            crate::operation_deser::parse_set_ip_address_type_response(response)
        }
    }
}

/// Operation shape for `SetResourceAccessForBucket`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`set_resource_access_for_bucket`](crate::client::Client::set_resource_access_for_bucket).
///
/// See [`crate::client::fluent_builders::SetResourceAccessForBucket`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SetResourceAccessForBucket {
    _private: (),
}
impl SetResourceAccessForBucket {
    /// Creates a new builder-style object to manufacture [`SetResourceAccessForBucketInput`](crate::input::SetResourceAccessForBucketInput)
    pub fn builder() -> crate::input::set_resource_access_for_bucket_input::Builder {
        crate::input::set_resource_access_for_bucket_input::Builder::default()
    }
    /// Creates a new `SetResourceAccessForBucket` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SetResourceAccessForBucket {
    type Output = std::result::Result<
        crate::output::SetResourceAccessForBucketOutput,
        crate::error::SetResourceAccessForBucketError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_set_resource_access_for_bucket_error(response)
        } else {
            crate::operation_deser::parse_set_resource_access_for_bucket_response(response)
        }
    }
}

/// Operation shape for `StartInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_instance`](crate::client::Client::start_instance).
///
/// See [`crate::client::fluent_builders::StartInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartInstance {
    _private: (),
}
impl StartInstance {
    /// Creates a new builder-style object to manufacture [`StartInstanceInput`](crate::input::StartInstanceInput)
    pub fn builder() -> crate::input::start_instance_input::Builder {
        crate::input::start_instance_input::Builder::default()
    }
    /// Creates a new `StartInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartInstance {
    type Output =
        std::result::Result<crate::output::StartInstanceOutput, crate::error::StartInstanceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_instance_error(response)
        } else {
            crate::operation_deser::parse_start_instance_response(response)
        }
    }
}

/// Operation shape for `StartRelationalDatabase`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_relational_database`](crate::client::Client::start_relational_database).
///
/// See [`crate::client::fluent_builders::StartRelationalDatabase`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartRelationalDatabase {
    _private: (),
}
impl StartRelationalDatabase {
    /// Creates a new builder-style object to manufacture [`StartRelationalDatabaseInput`](crate::input::StartRelationalDatabaseInput)
    pub fn builder() -> crate::input::start_relational_database_input::Builder {
        crate::input::start_relational_database_input::Builder::default()
    }
    /// Creates a new `StartRelationalDatabase` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartRelationalDatabase {
    type Output = std::result::Result<
        crate::output::StartRelationalDatabaseOutput,
        crate::error::StartRelationalDatabaseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_relational_database_error(response)
        } else {
            crate::operation_deser::parse_start_relational_database_response(response)
        }
    }
}

/// Operation shape for `StopInstance`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_instance`](crate::client::Client::stop_instance).
///
/// See [`crate::client::fluent_builders::StopInstance`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopInstance {
    _private: (),
}
impl StopInstance {
    /// Creates a new builder-style object to manufacture [`StopInstanceInput`](crate::input::StopInstanceInput)
    pub fn builder() -> crate::input::stop_instance_input::Builder {
        crate::input::stop_instance_input::Builder::default()
    }
    /// Creates a new `StopInstance` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopInstance {
    type Output =
        std::result::Result<crate::output::StopInstanceOutput, crate::error::StopInstanceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_instance_error(response)
        } else {
            crate::operation_deser::parse_stop_instance_response(response)
        }
    }
}

/// Operation shape for `StopRelationalDatabase`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_relational_database`](crate::client::Client::stop_relational_database).
///
/// See [`crate::client::fluent_builders::StopRelationalDatabase`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopRelationalDatabase {
    _private: (),
}
impl StopRelationalDatabase {
    /// Creates a new builder-style object to manufacture [`StopRelationalDatabaseInput`](crate::input::StopRelationalDatabaseInput)
    pub fn builder() -> crate::input::stop_relational_database_input::Builder {
        crate::input::stop_relational_database_input::Builder::default()
    }
    /// Creates a new `StopRelationalDatabase` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopRelationalDatabase {
    type Output = std::result::Result<
        crate::output::StopRelationalDatabaseOutput,
        crate::error::StopRelationalDatabaseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_relational_database_error(response)
        } else {
            crate::operation_deser::parse_stop_relational_database_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `TestAlarm`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`test_alarm`](crate::client::Client::test_alarm).
///
/// See [`crate::client::fluent_builders::TestAlarm`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TestAlarm {
    _private: (),
}
impl TestAlarm {
    /// Creates a new builder-style object to manufacture [`TestAlarmInput`](crate::input::TestAlarmInput)
    pub fn builder() -> crate::input::test_alarm_input::Builder {
        crate::input::test_alarm_input::Builder::default()
    }
    /// Creates a new `TestAlarm` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TestAlarm {
    type Output = std::result::Result<crate::output::TestAlarmOutput, crate::error::TestAlarmError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_test_alarm_error(response)
        } else {
            crate::operation_deser::parse_test_alarm_response(response)
        }
    }
}

/// Operation shape for `UnpeerVpc`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`unpeer_vpc`](crate::client::Client::unpeer_vpc).
///
/// See [`crate::client::fluent_builders::UnpeerVpc`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UnpeerVpc {
    _private: (),
}
impl UnpeerVpc {
    /// Creates a new builder-style object to manufacture [`UnpeerVpcInput`](crate::input::UnpeerVpcInput)
    pub fn builder() -> crate::input::unpeer_vpc_input::Builder {
        crate::input::unpeer_vpc_input::Builder::default()
    }
    /// Creates a new `UnpeerVpc` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UnpeerVpc {
    type Output = std::result::Result<crate::output::UnpeerVpcOutput, crate::error::UnpeerVpcError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_unpeer_vpc_error(response)
        } else {
            crate::operation_deser::parse_unpeer_vpc_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateBucket`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_bucket`](crate::client::Client::update_bucket).
///
/// See [`crate::client::fluent_builders::UpdateBucket`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBucket {
    _private: (),
}
impl UpdateBucket {
    /// Creates a new builder-style object to manufacture [`UpdateBucketInput`](crate::input::UpdateBucketInput)
    pub fn builder() -> crate::input::update_bucket_input::Builder {
        crate::input::update_bucket_input::Builder::default()
    }
    /// Creates a new `UpdateBucket` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBucket {
    type Output =
        std::result::Result<crate::output::UpdateBucketOutput, crate::error::UpdateBucketError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_bucket_error(response)
        } else {
            crate::operation_deser::parse_update_bucket_response(response)
        }
    }
}

/// Operation shape for `UpdateBucketBundle`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_bucket_bundle`](crate::client::Client::update_bucket_bundle).
///
/// See [`crate::client::fluent_builders::UpdateBucketBundle`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateBucketBundle {
    _private: (),
}
impl UpdateBucketBundle {
    /// Creates a new builder-style object to manufacture [`UpdateBucketBundleInput`](crate::input::UpdateBucketBundleInput)
    pub fn builder() -> crate::input::update_bucket_bundle_input::Builder {
        crate::input::update_bucket_bundle_input::Builder::default()
    }
    /// Creates a new `UpdateBucketBundle` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateBucketBundle {
    type Output = std::result::Result<
        crate::output::UpdateBucketBundleOutput,
        crate::error::UpdateBucketBundleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_bucket_bundle_error(response)
        } else {
            crate::operation_deser::parse_update_bucket_bundle_response(response)
        }
    }
}

/// Operation shape for `UpdateContainerService`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_container_service`](crate::client::Client::update_container_service).
///
/// See [`crate::client::fluent_builders::UpdateContainerService`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateContainerService {
    _private: (),
}
impl UpdateContainerService {
    /// Creates a new builder-style object to manufacture [`UpdateContainerServiceInput`](crate::input::UpdateContainerServiceInput)
    pub fn builder() -> crate::input::update_container_service_input::Builder {
        crate::input::update_container_service_input::Builder::default()
    }
    /// Creates a new `UpdateContainerService` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateContainerService {
    type Output = std::result::Result<
        crate::output::UpdateContainerServiceOutput,
        crate::error::UpdateContainerServiceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_container_service_error(response)
        } else {
            crate::operation_deser::parse_update_container_service_response(response)
        }
    }
}

/// Operation shape for `UpdateDistribution`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_distribution`](crate::client::Client::update_distribution).
///
/// See [`crate::client::fluent_builders::UpdateDistribution`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDistribution {
    _private: (),
}
impl UpdateDistribution {
    /// Creates a new builder-style object to manufacture [`UpdateDistributionInput`](crate::input::UpdateDistributionInput)
    pub fn builder() -> crate::input::update_distribution_input::Builder {
        crate::input::update_distribution_input::Builder::default()
    }
    /// Creates a new `UpdateDistribution` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDistribution {
    type Output = std::result::Result<
        crate::output::UpdateDistributionOutput,
        crate::error::UpdateDistributionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_distribution_error(response)
        } else {
            crate::operation_deser::parse_update_distribution_response(response)
        }
    }
}

/// Operation shape for `UpdateDistributionBundle`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_distribution_bundle`](crate::client::Client::update_distribution_bundle).
///
/// See [`crate::client::fluent_builders::UpdateDistributionBundle`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDistributionBundle {
    _private: (),
}
impl UpdateDistributionBundle {
    /// Creates a new builder-style object to manufacture [`UpdateDistributionBundleInput`](crate::input::UpdateDistributionBundleInput)
    pub fn builder() -> crate::input::update_distribution_bundle_input::Builder {
        crate::input::update_distribution_bundle_input::Builder::default()
    }
    /// Creates a new `UpdateDistributionBundle` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDistributionBundle {
    type Output = std::result::Result<
        crate::output::UpdateDistributionBundleOutput,
        crate::error::UpdateDistributionBundleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_distribution_bundle_error(response)
        } else {
            crate::operation_deser::parse_update_distribution_bundle_response(response)
        }
    }
}

/// Operation shape for `UpdateDomainEntry`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_domain_entry`](crate::client::Client::update_domain_entry).
///
/// See [`crate::client::fluent_builders::UpdateDomainEntry`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDomainEntry {
    _private: (),
}
impl UpdateDomainEntry {
    /// Creates a new builder-style object to manufacture [`UpdateDomainEntryInput`](crate::input::UpdateDomainEntryInput)
    pub fn builder() -> crate::input::update_domain_entry_input::Builder {
        crate::input::update_domain_entry_input::Builder::default()
    }
    /// Creates a new `UpdateDomainEntry` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDomainEntry {
    type Output = std::result::Result<
        crate::output::UpdateDomainEntryOutput,
        crate::error::UpdateDomainEntryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_domain_entry_error(response)
        } else {
            crate::operation_deser::parse_update_domain_entry_response(response)
        }
    }
}

/// Operation shape for `UpdateLoadBalancerAttribute`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_load_balancer_attribute`](crate::client::Client::update_load_balancer_attribute).
///
/// See [`crate::client::fluent_builders::UpdateLoadBalancerAttribute`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateLoadBalancerAttribute {
    _private: (),
}
impl UpdateLoadBalancerAttribute {
    /// Creates a new builder-style object to manufacture [`UpdateLoadBalancerAttributeInput`](crate::input::UpdateLoadBalancerAttributeInput)
    pub fn builder() -> crate::input::update_load_balancer_attribute_input::Builder {
        crate::input::update_load_balancer_attribute_input::Builder::default()
    }
    /// Creates a new `UpdateLoadBalancerAttribute` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateLoadBalancerAttribute {
    type Output = std::result::Result<
        crate::output::UpdateLoadBalancerAttributeOutput,
        crate::error::UpdateLoadBalancerAttributeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_load_balancer_attribute_error(response)
        } else {
            crate::operation_deser::parse_update_load_balancer_attribute_response(response)
        }
    }
}

/// Operation shape for `UpdateRelationalDatabase`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_relational_database`](crate::client::Client::update_relational_database).
///
/// See [`crate::client::fluent_builders::UpdateRelationalDatabase`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRelationalDatabase {
    _private: (),
}
impl UpdateRelationalDatabase {
    /// Creates a new builder-style object to manufacture [`UpdateRelationalDatabaseInput`](crate::input::UpdateRelationalDatabaseInput)
    pub fn builder() -> crate::input::update_relational_database_input::Builder {
        crate::input::update_relational_database_input::Builder::default()
    }
    /// Creates a new `UpdateRelationalDatabase` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRelationalDatabase {
    type Output = std::result::Result<
        crate::output::UpdateRelationalDatabaseOutput,
        crate::error::UpdateRelationalDatabaseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_relational_database_error(response)
        } else {
            crate::operation_deser::parse_update_relational_database_response(response)
        }
    }
}

/// Operation shape for `UpdateRelationalDatabaseParameters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_relational_database_parameters`](crate::client::Client::update_relational_database_parameters).
///
/// See [`crate::client::fluent_builders::UpdateRelationalDatabaseParameters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateRelationalDatabaseParameters {
    _private: (),
}
impl UpdateRelationalDatabaseParameters {
    /// Creates a new builder-style object to manufacture [`UpdateRelationalDatabaseParametersInput`](crate::input::UpdateRelationalDatabaseParametersInput)
    pub fn builder() -> crate::input::update_relational_database_parameters_input::Builder {
        crate::input::update_relational_database_parameters_input::Builder::default()
    }
    /// Creates a new `UpdateRelationalDatabaseParameters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateRelationalDatabaseParameters {
    type Output = std::result::Result<
        crate::output::UpdateRelationalDatabaseParametersOutput,
        crate::error::UpdateRelationalDatabaseParametersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_relational_database_parameters_error(response)
        } else {
            crate::operation_deser::parse_update_relational_database_parameters_response(response)
        }
    }
}
