// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Describes the API operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Operation {
    /// <p>The ID of the operation.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The resource name.</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>The resource type. </p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The timestamp when the operation was initialized (e.g.,
    /// <code>1479816991.349</code>).</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The AWS Region and Availability Zone.</p>
    pub location: std::option::Option<crate::model::ResourceLocation>,
    /// <p>A Boolean value indicating whether the operation is terminal.</p>
    pub is_terminal: std::option::Option<bool>,
    /// <p>Details about the operation (e.g., <code>Debian-1GB-Ohio-1</code>).</p>
    pub operation_details: std::option::Option<std::string::String>,
    /// <p>The type of operation. </p>
    pub operation_type: std::option::Option<crate::model::OperationType>,
    /// <p>The status of the operation. </p>
    pub status: std::option::Option<crate::model::OperationStatus>,
    /// <p>The timestamp when the status was changed (e.g., <code>1479816991.349</code>).</p>
    pub status_changed_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The error code.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error details.</p>
    pub error_details: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Operation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Operation");
        formatter.field("id", &self.id);
        formatter.field("resource_name", &self.resource_name);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("created_at", &self.created_at);
        formatter.field("location", &self.location);
        formatter.field("is_terminal", &self.is_terminal);
        formatter.field("operation_details", &self.operation_details);
        formatter.field("operation_type", &self.operation_type);
        formatter.field("status", &self.status);
        formatter.field("status_changed_at", &self.status_changed_at);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_details", &self.error_details);
        formatter.finish()
    }
}
/// See [`Operation`](crate::model::Operation)
pub mod operation {
    /// A builder for [`Operation`](crate::model::Operation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) location: std::option::Option<crate::model::ResourceLocation>,
        pub(crate) is_terminal: std::option::Option<bool>,
        pub(crate) operation_details: std::option::Option<std::string::String>,
        pub(crate) operation_type: std::option::Option<crate::model::OperationType>,
        pub(crate) status: std::option::Option<crate::model::OperationStatus>,
        pub(crate) status_changed_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_details: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the operation.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the operation.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The resource name.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The resource name.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// <p>The resource type. </p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The resource type. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The timestamp when the operation was initialized (e.g.,
        /// <code>1479816991.349</code>).</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when the operation was initialized (e.g.,
        /// <code>1479816991.349</code>).</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The AWS Region and Availability Zone.</p>
        pub fn location(mut self, input: crate::model::ResourceLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The AWS Region and Availability Zone.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::ResourceLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>A Boolean value indicating whether the operation is terminal.</p>
        pub fn is_terminal(mut self, input: bool) -> Self {
            self.is_terminal = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether the operation is terminal.</p>
        pub fn set_is_terminal(mut self, input: std::option::Option<bool>) -> Self {
            self.is_terminal = input;
            self
        }
        /// <p>Details about the operation (e.g., <code>Debian-1GB-Ohio-1</code>).</p>
        pub fn operation_details(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_details = Some(input.into());
            self
        }
        /// <p>Details about the operation (e.g., <code>Debian-1GB-Ohio-1</code>).</p>
        pub fn set_operation_details(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operation_details = input;
            self
        }
        /// <p>The type of operation. </p>
        pub fn operation_type(mut self, input: crate::model::OperationType) -> Self {
            self.operation_type = Some(input);
            self
        }
        /// <p>The type of operation. </p>
        pub fn set_operation_type(
            mut self,
            input: std::option::Option<crate::model::OperationType>,
        ) -> Self {
            self.operation_type = input;
            self
        }
        /// <p>The status of the operation. </p>
        pub fn status(mut self, input: crate::model::OperationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the operation. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::OperationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The timestamp when the status was changed (e.g., <code>1479816991.349</code>).</p>
        pub fn status_changed_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.status_changed_at = Some(input);
            self
        }
        /// <p>The timestamp when the status was changed (e.g., <code>1479816991.349</code>).</p>
        pub fn set_status_changed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.status_changed_at = input;
            self
        }
        /// <p>The error code.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error details.</p>
        pub fn error_details(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_details = Some(input.into());
            self
        }
        /// <p>The error details.</p>
        pub fn set_error_details(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_details = input;
            self
        }
        /// Consumes the builder and constructs a [`Operation`](crate::model::Operation)
        pub fn build(self) -> crate::model::Operation {
            crate::model::Operation {
                id: self.id,
                resource_name: self.resource_name,
                resource_type: self.resource_type,
                created_at: self.created_at,
                location: self.location,
                is_terminal: self.is_terminal,
                operation_details: self.operation_details,
                operation_type: self.operation_type,
                status: self.status,
                status_changed_at: self.status_changed_at,
                error_code: self.error_code,
                error_details: self.error_details,
            }
        }
    }
}
impl Operation {
    /// Creates a new builder-style object to manufacture [`Operation`](crate::model::Operation)
    pub fn builder() -> crate::model::operation::Builder {
        crate::model::operation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OperationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    NotStarted,
    #[allow(missing_docs)] // documentation missing in model
    Started,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OperationStatus {
    fn from(s: &str) -> Self {
        match s {
            "Completed" => OperationStatus::Completed,
            "Failed" => OperationStatus::Failed,
            "NotStarted" => OperationStatus::NotStarted,
            "Started" => OperationStatus::Started,
            "Succeeded" => OperationStatus::Succeeded,
            other => OperationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OperationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OperationStatus::from(s))
    }
}
impl OperationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OperationStatus::Completed => "Completed",
            OperationStatus::Failed => "Failed",
            OperationStatus::NotStarted => "NotStarted",
            OperationStatus::Started => "Started",
            OperationStatus::Succeeded => "Succeeded",
            OperationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Completed", "Failed", "NotStarted", "Started", "Succeeded"]
    }
}
impl AsRef<str> for OperationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OperationType {
    #[allow(missing_docs)] // documentation missing in model
    AllocateStaticIp,
    #[allow(missing_docs)] // documentation missing in model
    AttachCertificateToDistribution,
    #[allow(missing_docs)] // documentation missing in model
    AttachDisk,
    #[allow(missing_docs)] // documentation missing in model
    AttachInstancesToLoadBalancer,
    #[allow(missing_docs)] // documentation missing in model
    AttachLoadBalancerTlsCertificate,
    #[allow(missing_docs)] // documentation missing in model
    AttachStaticIp,
    #[allow(missing_docs)] // documentation missing in model
    CloseInstancePublicPorts,
    #[allow(missing_docs)] // documentation missing in model
    CreateBucket,
    #[allow(missing_docs)] // documentation missing in model
    CreateBucketAccessKey,
    #[allow(missing_docs)] // documentation missing in model
    CreateCertificate,
    #[allow(missing_docs)] // documentation missing in model
    CreateContactMethod,
    #[allow(missing_docs)] // documentation missing in model
    CreateContainerService,
    #[allow(missing_docs)] // documentation missing in model
    CreateContainerServiceDeployment,
    #[allow(missing_docs)] // documentation missing in model
    CreateContainerServiceRegistryLogin,
    #[allow(missing_docs)] // documentation missing in model
    CreateDisk,
    #[allow(missing_docs)] // documentation missing in model
    CreateDiskFromSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    CreateDiskSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    CreateDistribution,
    #[allow(missing_docs)] // documentation missing in model
    CreateDomain,
    #[allow(missing_docs)] // documentation missing in model
    CreateInstance,
    #[allow(missing_docs)] // documentation missing in model
    CreateInstanceSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    CreateInstancesFromSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    CreateLoadBalancer,
    #[allow(missing_docs)] // documentation missing in model
    CreateLoadBalancerTlsCertificate,
    #[allow(missing_docs)] // documentation missing in model
    CreateRelationalDatabase,
    #[allow(missing_docs)] // documentation missing in model
    CreateRelationalDatabaseFromSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    CreateRelationalDatabaseSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    DeleteAlarm,
    #[allow(missing_docs)] // documentation missing in model
    DeleteBucket,
    #[allow(missing_docs)] // documentation missing in model
    DeleteBucketAccessKey,
    #[allow(missing_docs)] // documentation missing in model
    DeleteCertificate,
    #[allow(missing_docs)] // documentation missing in model
    DeleteContactMethod,
    #[allow(missing_docs)] // documentation missing in model
    DeleteContainerImage,
    #[allow(missing_docs)] // documentation missing in model
    DeleteContainerService,
    #[allow(missing_docs)] // documentation missing in model
    DeleteDisk,
    #[allow(missing_docs)] // documentation missing in model
    DeleteDiskSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    DeleteDistribution,
    #[allow(missing_docs)] // documentation missing in model
    DeleteDomain,
    #[allow(missing_docs)] // documentation missing in model
    DeleteDomainEntry,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInstance,
    #[allow(missing_docs)] // documentation missing in model
    DeleteInstanceSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    DeleteKnownHostKeys,
    #[allow(missing_docs)] // documentation missing in model
    DeleteLoadBalancer,
    #[allow(missing_docs)] // documentation missing in model
    DeleteLoadBalancerTlsCertificate,
    #[allow(missing_docs)] // documentation missing in model
    DeleteRelationalDatabase,
    #[allow(missing_docs)] // documentation missing in model
    DeleteRelationalDatabaseSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    DetachCertificateFromDistribution,
    #[allow(missing_docs)] // documentation missing in model
    DetachDisk,
    #[allow(missing_docs)] // documentation missing in model
    DetachInstancesFromLoadBalancer,
    #[allow(missing_docs)] // documentation missing in model
    DetachStaticIp,
    #[allow(missing_docs)] // documentation missing in model
    DisableAddOn,
    #[allow(missing_docs)] // documentation missing in model
    EnableAddOn,
    #[allow(missing_docs)] // documentation missing in model
    GetAlarms,
    #[allow(missing_docs)] // documentation missing in model
    GetContactMethods,
    #[allow(missing_docs)] // documentation missing in model
    OpenInstancePublicPorts,
    #[allow(missing_docs)] // documentation missing in model
    PutAlarm,
    #[allow(missing_docs)] // documentation missing in model
    PutInstancePublicPorts,
    #[allow(missing_docs)] // documentation missing in model
    RebootInstance,
    #[allow(missing_docs)] // documentation missing in model
    RebootRelationalDatabase,
    #[allow(missing_docs)] // documentation missing in model
    RegisterContainerImage,
    #[allow(missing_docs)] // documentation missing in model
    ReleaseStaticIp,
    #[allow(missing_docs)] // documentation missing in model
    ResetDistributionCache,
    #[allow(missing_docs)] // documentation missing in model
    SendContactMethodVerification,
    #[allow(missing_docs)] // documentation missing in model
    SetIpAddressType,
    #[allow(missing_docs)] // documentation missing in model
    SetResourceAccessForBucket,
    #[allow(missing_docs)] // documentation missing in model
    StartInstance,
    #[allow(missing_docs)] // documentation missing in model
    StartRelationalDatabase,
    #[allow(missing_docs)] // documentation missing in model
    StopInstance,
    #[allow(missing_docs)] // documentation missing in model
    StopRelationalDatabase,
    #[allow(missing_docs)] // documentation missing in model
    TestAlarm,
    #[allow(missing_docs)] // documentation missing in model
    UpdateBucket,
    #[allow(missing_docs)] // documentation missing in model
    UpdateBucketBundle,
    #[allow(missing_docs)] // documentation missing in model
    UpdateContainerService,
    #[allow(missing_docs)] // documentation missing in model
    UpdateDistribution,
    #[allow(missing_docs)] // documentation missing in model
    UpdateDistributionBundle,
    #[allow(missing_docs)] // documentation missing in model
    UpdateDomainEntry,
    #[allow(missing_docs)] // documentation missing in model
    UpdateLoadBalancerAttribute,
    #[allow(missing_docs)] // documentation missing in model
    UpdateRelationalDatabase,
    #[allow(missing_docs)] // documentation missing in model
    UpdateRelationalDatabaseParameters,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OperationType {
    fn from(s: &str) -> Self {
        match s {
            "AllocateStaticIp" => OperationType::AllocateStaticIp,
            "AttachCertificateToDistribution" => OperationType::AttachCertificateToDistribution,
            "AttachDisk" => OperationType::AttachDisk,
            "AttachInstancesToLoadBalancer" => OperationType::AttachInstancesToLoadBalancer,
            "AttachLoadBalancerTlsCertificate" => OperationType::AttachLoadBalancerTlsCertificate,
            "AttachStaticIp" => OperationType::AttachStaticIp,
            "CloseInstancePublicPorts" => OperationType::CloseInstancePublicPorts,
            "CreateBucket" => OperationType::CreateBucket,
            "CreateBucketAccessKey" => OperationType::CreateBucketAccessKey,
            "CreateCertificate" => OperationType::CreateCertificate,
            "CreateContactMethod" => OperationType::CreateContactMethod,
            "CreateContainerService" => OperationType::CreateContainerService,
            "CreateContainerServiceDeployment" => OperationType::CreateContainerServiceDeployment,
            "CreateContainerServiceRegistryLogin" => {
                OperationType::CreateContainerServiceRegistryLogin
            }
            "CreateDisk" => OperationType::CreateDisk,
            "CreateDiskFromSnapshot" => OperationType::CreateDiskFromSnapshot,
            "CreateDiskSnapshot" => OperationType::CreateDiskSnapshot,
            "CreateDistribution" => OperationType::CreateDistribution,
            "CreateDomain" => OperationType::CreateDomain,
            "CreateInstance" => OperationType::CreateInstance,
            "CreateInstanceSnapshot" => OperationType::CreateInstanceSnapshot,
            "CreateInstancesFromSnapshot" => OperationType::CreateInstancesFromSnapshot,
            "CreateLoadBalancer" => OperationType::CreateLoadBalancer,
            "CreateLoadBalancerTlsCertificate" => OperationType::CreateLoadBalancerTlsCertificate,
            "CreateRelationalDatabase" => OperationType::CreateRelationalDatabase,
            "CreateRelationalDatabaseFromSnapshot" => {
                OperationType::CreateRelationalDatabaseFromSnapshot
            }
            "CreateRelationalDatabaseSnapshot" => OperationType::CreateRelationalDatabaseSnapshot,
            "DeleteAlarm" => OperationType::DeleteAlarm,
            "DeleteBucket" => OperationType::DeleteBucket,
            "DeleteBucketAccessKey" => OperationType::DeleteBucketAccessKey,
            "DeleteCertificate" => OperationType::DeleteCertificate,
            "DeleteContactMethod" => OperationType::DeleteContactMethod,
            "DeleteContainerImage" => OperationType::DeleteContainerImage,
            "DeleteContainerService" => OperationType::DeleteContainerService,
            "DeleteDisk" => OperationType::DeleteDisk,
            "DeleteDiskSnapshot" => OperationType::DeleteDiskSnapshot,
            "DeleteDistribution" => OperationType::DeleteDistribution,
            "DeleteDomain" => OperationType::DeleteDomain,
            "DeleteDomainEntry" => OperationType::DeleteDomainEntry,
            "DeleteInstance" => OperationType::DeleteInstance,
            "DeleteInstanceSnapshot" => OperationType::DeleteInstanceSnapshot,
            "DeleteKnownHostKeys" => OperationType::DeleteKnownHostKeys,
            "DeleteLoadBalancer" => OperationType::DeleteLoadBalancer,
            "DeleteLoadBalancerTlsCertificate" => OperationType::DeleteLoadBalancerTlsCertificate,
            "DeleteRelationalDatabase" => OperationType::DeleteRelationalDatabase,
            "DeleteRelationalDatabaseSnapshot" => OperationType::DeleteRelationalDatabaseSnapshot,
            "DetachCertificateFromDistribution" => OperationType::DetachCertificateFromDistribution,
            "DetachDisk" => OperationType::DetachDisk,
            "DetachInstancesFromLoadBalancer" => OperationType::DetachInstancesFromLoadBalancer,
            "DetachStaticIp" => OperationType::DetachStaticIp,
            "DisableAddOn" => OperationType::DisableAddOn,
            "EnableAddOn" => OperationType::EnableAddOn,
            "GetAlarms" => OperationType::GetAlarms,
            "GetContactMethods" => OperationType::GetContactMethods,
            "OpenInstancePublicPorts" => OperationType::OpenInstancePublicPorts,
            "PutAlarm" => OperationType::PutAlarm,
            "PutInstancePublicPorts" => OperationType::PutInstancePublicPorts,
            "RebootInstance" => OperationType::RebootInstance,
            "RebootRelationalDatabase" => OperationType::RebootRelationalDatabase,
            "RegisterContainerImage" => OperationType::RegisterContainerImage,
            "ReleaseStaticIp" => OperationType::ReleaseStaticIp,
            "ResetDistributionCache" => OperationType::ResetDistributionCache,
            "SendContactMethodVerification" => OperationType::SendContactMethodVerification,
            "SetIpAddressType" => OperationType::SetIpAddressType,
            "SetResourceAccessForBucket" => OperationType::SetResourceAccessForBucket,
            "StartInstance" => OperationType::StartInstance,
            "StartRelationalDatabase" => OperationType::StartRelationalDatabase,
            "StopInstance" => OperationType::StopInstance,
            "StopRelationalDatabase" => OperationType::StopRelationalDatabase,
            "TestAlarm" => OperationType::TestAlarm,
            "UpdateBucket" => OperationType::UpdateBucket,
            "UpdateBucketBundle" => OperationType::UpdateBucketBundle,
            "UpdateContainerService" => OperationType::UpdateContainerService,
            "UpdateDistribution" => OperationType::UpdateDistribution,
            "UpdateDistributionBundle" => OperationType::UpdateDistributionBundle,
            "UpdateDomainEntry" => OperationType::UpdateDomainEntry,
            "UpdateLoadBalancerAttribute" => OperationType::UpdateLoadBalancerAttribute,
            "UpdateRelationalDatabase" => OperationType::UpdateRelationalDatabase,
            "UpdateRelationalDatabaseParameters" => {
                OperationType::UpdateRelationalDatabaseParameters
            }
            other => OperationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OperationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OperationType::from(s))
    }
}
impl OperationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OperationType::AllocateStaticIp => "AllocateStaticIp",
            OperationType::AttachCertificateToDistribution => "AttachCertificateToDistribution",
            OperationType::AttachDisk => "AttachDisk",
            OperationType::AttachInstancesToLoadBalancer => "AttachInstancesToLoadBalancer",
            OperationType::AttachLoadBalancerTlsCertificate => "AttachLoadBalancerTlsCertificate",
            OperationType::AttachStaticIp => "AttachStaticIp",
            OperationType::CloseInstancePublicPorts => "CloseInstancePublicPorts",
            OperationType::CreateBucket => "CreateBucket",
            OperationType::CreateBucketAccessKey => "CreateBucketAccessKey",
            OperationType::CreateCertificate => "CreateCertificate",
            OperationType::CreateContactMethod => "CreateContactMethod",
            OperationType::CreateContainerService => "CreateContainerService",
            OperationType::CreateContainerServiceDeployment => "CreateContainerServiceDeployment",
            OperationType::CreateContainerServiceRegistryLogin => {
                "CreateContainerServiceRegistryLogin"
            }
            OperationType::CreateDisk => "CreateDisk",
            OperationType::CreateDiskFromSnapshot => "CreateDiskFromSnapshot",
            OperationType::CreateDiskSnapshot => "CreateDiskSnapshot",
            OperationType::CreateDistribution => "CreateDistribution",
            OperationType::CreateDomain => "CreateDomain",
            OperationType::CreateInstance => "CreateInstance",
            OperationType::CreateInstanceSnapshot => "CreateInstanceSnapshot",
            OperationType::CreateInstancesFromSnapshot => "CreateInstancesFromSnapshot",
            OperationType::CreateLoadBalancer => "CreateLoadBalancer",
            OperationType::CreateLoadBalancerTlsCertificate => "CreateLoadBalancerTlsCertificate",
            OperationType::CreateRelationalDatabase => "CreateRelationalDatabase",
            OperationType::CreateRelationalDatabaseFromSnapshot => {
                "CreateRelationalDatabaseFromSnapshot"
            }
            OperationType::CreateRelationalDatabaseSnapshot => "CreateRelationalDatabaseSnapshot",
            OperationType::DeleteAlarm => "DeleteAlarm",
            OperationType::DeleteBucket => "DeleteBucket",
            OperationType::DeleteBucketAccessKey => "DeleteBucketAccessKey",
            OperationType::DeleteCertificate => "DeleteCertificate",
            OperationType::DeleteContactMethod => "DeleteContactMethod",
            OperationType::DeleteContainerImage => "DeleteContainerImage",
            OperationType::DeleteContainerService => "DeleteContainerService",
            OperationType::DeleteDisk => "DeleteDisk",
            OperationType::DeleteDiskSnapshot => "DeleteDiskSnapshot",
            OperationType::DeleteDistribution => "DeleteDistribution",
            OperationType::DeleteDomain => "DeleteDomain",
            OperationType::DeleteDomainEntry => "DeleteDomainEntry",
            OperationType::DeleteInstance => "DeleteInstance",
            OperationType::DeleteInstanceSnapshot => "DeleteInstanceSnapshot",
            OperationType::DeleteKnownHostKeys => "DeleteKnownHostKeys",
            OperationType::DeleteLoadBalancer => "DeleteLoadBalancer",
            OperationType::DeleteLoadBalancerTlsCertificate => "DeleteLoadBalancerTlsCertificate",
            OperationType::DeleteRelationalDatabase => "DeleteRelationalDatabase",
            OperationType::DeleteRelationalDatabaseSnapshot => "DeleteRelationalDatabaseSnapshot",
            OperationType::DetachCertificateFromDistribution => "DetachCertificateFromDistribution",
            OperationType::DetachDisk => "DetachDisk",
            OperationType::DetachInstancesFromLoadBalancer => "DetachInstancesFromLoadBalancer",
            OperationType::DetachStaticIp => "DetachStaticIp",
            OperationType::DisableAddOn => "DisableAddOn",
            OperationType::EnableAddOn => "EnableAddOn",
            OperationType::GetAlarms => "GetAlarms",
            OperationType::GetContactMethods => "GetContactMethods",
            OperationType::OpenInstancePublicPorts => "OpenInstancePublicPorts",
            OperationType::PutAlarm => "PutAlarm",
            OperationType::PutInstancePublicPorts => "PutInstancePublicPorts",
            OperationType::RebootInstance => "RebootInstance",
            OperationType::RebootRelationalDatabase => "RebootRelationalDatabase",
            OperationType::RegisterContainerImage => "RegisterContainerImage",
            OperationType::ReleaseStaticIp => "ReleaseStaticIp",
            OperationType::ResetDistributionCache => "ResetDistributionCache",
            OperationType::SendContactMethodVerification => "SendContactMethodVerification",
            OperationType::SetIpAddressType => "SetIpAddressType",
            OperationType::SetResourceAccessForBucket => "SetResourceAccessForBucket",
            OperationType::StartInstance => "StartInstance",
            OperationType::StartRelationalDatabase => "StartRelationalDatabase",
            OperationType::StopInstance => "StopInstance",
            OperationType::StopRelationalDatabase => "StopRelationalDatabase",
            OperationType::TestAlarm => "TestAlarm",
            OperationType::UpdateBucket => "UpdateBucket",
            OperationType::UpdateBucketBundle => "UpdateBucketBundle",
            OperationType::UpdateContainerService => "UpdateContainerService",
            OperationType::UpdateDistribution => "UpdateDistribution",
            OperationType::UpdateDistributionBundle => "UpdateDistributionBundle",
            OperationType::UpdateDomainEntry => "UpdateDomainEntry",
            OperationType::UpdateLoadBalancerAttribute => "UpdateLoadBalancerAttribute",
            OperationType::UpdateRelationalDatabase => "UpdateRelationalDatabase",
            OperationType::UpdateRelationalDatabaseParameters => {
                "UpdateRelationalDatabaseParameters"
            }
            OperationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AllocateStaticIp",
            "AttachCertificateToDistribution",
            "AttachDisk",
            "AttachInstancesToLoadBalancer",
            "AttachLoadBalancerTlsCertificate",
            "AttachStaticIp",
            "CloseInstancePublicPorts",
            "CreateBucket",
            "CreateBucketAccessKey",
            "CreateCertificate",
            "CreateContactMethod",
            "CreateContainerService",
            "CreateContainerServiceDeployment",
            "CreateContainerServiceRegistryLogin",
            "CreateDisk",
            "CreateDiskFromSnapshot",
            "CreateDiskSnapshot",
            "CreateDistribution",
            "CreateDomain",
            "CreateInstance",
            "CreateInstanceSnapshot",
            "CreateInstancesFromSnapshot",
            "CreateLoadBalancer",
            "CreateLoadBalancerTlsCertificate",
            "CreateRelationalDatabase",
            "CreateRelationalDatabaseFromSnapshot",
            "CreateRelationalDatabaseSnapshot",
            "DeleteAlarm",
            "DeleteBucket",
            "DeleteBucketAccessKey",
            "DeleteCertificate",
            "DeleteContactMethod",
            "DeleteContainerImage",
            "DeleteContainerService",
            "DeleteDisk",
            "DeleteDiskSnapshot",
            "DeleteDistribution",
            "DeleteDomain",
            "DeleteDomainEntry",
            "DeleteInstance",
            "DeleteInstanceSnapshot",
            "DeleteKnownHostKeys",
            "DeleteLoadBalancer",
            "DeleteLoadBalancerTlsCertificate",
            "DeleteRelationalDatabase",
            "DeleteRelationalDatabaseSnapshot",
            "DetachCertificateFromDistribution",
            "DetachDisk",
            "DetachInstancesFromLoadBalancer",
            "DetachStaticIp",
            "DisableAddOn",
            "EnableAddOn",
            "GetAlarms",
            "GetContactMethods",
            "OpenInstancePublicPorts",
            "PutAlarm",
            "PutInstancePublicPorts",
            "RebootInstance",
            "RebootRelationalDatabase",
            "RegisterContainerImage",
            "ReleaseStaticIp",
            "ResetDistributionCache",
            "SendContactMethodVerification",
            "SetIpAddressType",
            "SetResourceAccessForBucket",
            "StartInstance",
            "StartRelationalDatabase",
            "StopInstance",
            "StopRelationalDatabase",
            "TestAlarm",
            "UpdateBucket",
            "UpdateBucketBundle",
            "UpdateContainerService",
            "UpdateDistribution",
            "UpdateDistributionBundle",
            "UpdateDomainEntry",
            "UpdateLoadBalancerAttribute",
            "UpdateRelationalDatabase",
            "UpdateRelationalDatabaseParameters",
        ]
    }
}
impl AsRef<str> for OperationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the resource location.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceLocation {
    /// <p>The Availability Zone. Follows the format <code>us-east-2a</code> (case-sensitive).</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The AWS Region name.</p>
    pub region_name: std::option::Option<crate::model::RegionName>,
}
impl std::fmt::Debug for ResourceLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceLocation");
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("region_name", &self.region_name);
        formatter.finish()
    }
}
/// See [`ResourceLocation`](crate::model::ResourceLocation)
pub mod resource_location {
    /// A builder for [`ResourceLocation`](crate::model::ResourceLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) region_name: std::option::Option<crate::model::RegionName>,
    }
    impl Builder {
        /// <p>The Availability Zone. Follows the format <code>us-east-2a</code> (case-sensitive).</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone. Follows the format <code>us-east-2a</code> (case-sensitive).</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The AWS Region name.</p>
        pub fn region_name(mut self, input: crate::model::RegionName) -> Self {
            self.region_name = Some(input);
            self
        }
        /// <p>The AWS Region name.</p>
        pub fn set_region_name(
            mut self,
            input: std::option::Option<crate::model::RegionName>,
        ) -> Self {
            self.region_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceLocation`](crate::model::ResourceLocation)
        pub fn build(self) -> crate::model::ResourceLocation {
            crate::model::ResourceLocation {
                availability_zone: self.availability_zone,
                region_name: self.region_name,
            }
        }
    }
}
impl ResourceLocation {
    /// Creates a new builder-style object to manufacture [`ResourceLocation`](crate::model::ResourceLocation)
    pub fn builder() -> crate::model::resource_location::Builder {
        crate::model::resource_location::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RegionName {
    #[allow(missing_docs)] // documentation missing in model
    ApNortheast1,
    #[allow(missing_docs)] // documentation missing in model
    ApNortheast2,
    #[allow(missing_docs)] // documentation missing in model
    ApSouth1,
    #[allow(missing_docs)] // documentation missing in model
    ApSoutheast1,
    #[allow(missing_docs)] // documentation missing in model
    ApSoutheast2,
    #[allow(missing_docs)] // documentation missing in model
    CaCentral1,
    #[allow(missing_docs)] // documentation missing in model
    EuCentral1,
    #[allow(missing_docs)] // documentation missing in model
    EuNorth1,
    #[allow(missing_docs)] // documentation missing in model
    EuWest1,
    #[allow(missing_docs)] // documentation missing in model
    EuWest2,
    #[allow(missing_docs)] // documentation missing in model
    EuWest3,
    #[allow(missing_docs)] // documentation missing in model
    UsEast1,
    #[allow(missing_docs)] // documentation missing in model
    UsEast2,
    #[allow(missing_docs)] // documentation missing in model
    UsWest1,
    #[allow(missing_docs)] // documentation missing in model
    UsWest2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RegionName {
    fn from(s: &str) -> Self {
        match s {
            "ap-northeast-1" => RegionName::ApNortheast1,
            "ap-northeast-2" => RegionName::ApNortheast2,
            "ap-south-1" => RegionName::ApSouth1,
            "ap-southeast-1" => RegionName::ApSoutheast1,
            "ap-southeast-2" => RegionName::ApSoutheast2,
            "ca-central-1" => RegionName::CaCentral1,
            "eu-central-1" => RegionName::EuCentral1,
            "eu-north-1" => RegionName::EuNorth1,
            "eu-west-1" => RegionName::EuWest1,
            "eu-west-2" => RegionName::EuWest2,
            "eu-west-3" => RegionName::EuWest3,
            "us-east-1" => RegionName::UsEast1,
            "us-east-2" => RegionName::UsEast2,
            "us-west-1" => RegionName::UsWest1,
            "us-west-2" => RegionName::UsWest2,
            other => RegionName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RegionName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RegionName::from(s))
    }
}
impl RegionName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RegionName::ApNortheast1 => "ap-northeast-1",
            RegionName::ApNortheast2 => "ap-northeast-2",
            RegionName::ApSouth1 => "ap-south-1",
            RegionName::ApSoutheast1 => "ap-southeast-1",
            RegionName::ApSoutheast2 => "ap-southeast-2",
            RegionName::CaCentral1 => "ca-central-1",
            RegionName::EuCentral1 => "eu-central-1",
            RegionName::EuNorth1 => "eu-north-1",
            RegionName::EuWest1 => "eu-west-1",
            RegionName::EuWest2 => "eu-west-2",
            RegionName::EuWest3 => "eu-west-3",
            RegionName::UsEast1 => "us-east-1",
            RegionName::UsEast2 => "us-east-2",
            RegionName::UsWest1 => "us-west-1",
            RegionName::UsWest2 => "us-west-2",
            RegionName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
        ]
    }
}
impl AsRef<str> for RegionName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Alarm,
    #[allow(missing_docs)] // documentation missing in model
    Bucket,
    #[allow(missing_docs)] // documentation missing in model
    Certificate,
    #[allow(missing_docs)] // documentation missing in model
    CloudFormationStackRecord,
    #[allow(missing_docs)] // documentation missing in model
    ContactMethod,
    #[allow(missing_docs)] // documentation missing in model
    ContainerService,
    #[allow(missing_docs)] // documentation missing in model
    Disk,
    #[allow(missing_docs)] // documentation missing in model
    DiskSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    Distribution,
    #[allow(missing_docs)] // documentation missing in model
    Domain,
    #[allow(missing_docs)] // documentation missing in model
    ExportSnapshotRecord,
    #[allow(missing_docs)] // documentation missing in model
    Instance,
    #[allow(missing_docs)] // documentation missing in model
    InstanceSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    KeyPair,
    #[allow(missing_docs)] // documentation missing in model
    LoadBalancer,
    #[allow(missing_docs)] // documentation missing in model
    LoadBalancerTlsCertificate,
    #[allow(missing_docs)] // documentation missing in model
    PeeredVpc,
    #[allow(missing_docs)] // documentation missing in model
    RelationalDatabase,
    #[allow(missing_docs)] // documentation missing in model
    RelationalDatabaseSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    StaticIp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "Alarm" => ResourceType::Alarm,
            "Bucket" => ResourceType::Bucket,
            "Certificate" => ResourceType::Certificate,
            "CloudFormationStackRecord" => ResourceType::CloudFormationStackRecord,
            "ContactMethod" => ResourceType::ContactMethod,
            "ContainerService" => ResourceType::ContainerService,
            "Disk" => ResourceType::Disk,
            "DiskSnapshot" => ResourceType::DiskSnapshot,
            "Distribution" => ResourceType::Distribution,
            "Domain" => ResourceType::Domain,
            "ExportSnapshotRecord" => ResourceType::ExportSnapshotRecord,
            "Instance" => ResourceType::Instance,
            "InstanceSnapshot" => ResourceType::InstanceSnapshot,
            "KeyPair" => ResourceType::KeyPair,
            "LoadBalancer" => ResourceType::LoadBalancer,
            "LoadBalancerTlsCertificate" => ResourceType::LoadBalancerTlsCertificate,
            "PeeredVpc" => ResourceType::PeeredVpc,
            "RelationalDatabase" => ResourceType::RelationalDatabase,
            "RelationalDatabaseSnapshot" => ResourceType::RelationalDatabaseSnapshot,
            "StaticIp" => ResourceType::StaticIp,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::Alarm => "Alarm",
            ResourceType::Bucket => "Bucket",
            ResourceType::Certificate => "Certificate",
            ResourceType::CloudFormationStackRecord => "CloudFormationStackRecord",
            ResourceType::ContactMethod => "ContactMethod",
            ResourceType::ContainerService => "ContainerService",
            ResourceType::Disk => "Disk",
            ResourceType::DiskSnapshot => "DiskSnapshot",
            ResourceType::Distribution => "Distribution",
            ResourceType::Domain => "Domain",
            ResourceType::ExportSnapshotRecord => "ExportSnapshotRecord",
            ResourceType::Instance => "Instance",
            ResourceType::InstanceSnapshot => "InstanceSnapshot",
            ResourceType::KeyPair => "KeyPair",
            ResourceType::LoadBalancer => "LoadBalancer",
            ResourceType::LoadBalancerTlsCertificate => "LoadBalancerTlsCertificate",
            ResourceType::PeeredVpc => "PeeredVpc",
            ResourceType::RelationalDatabase => "RelationalDatabase",
            ResourceType::RelationalDatabaseSnapshot => "RelationalDatabaseSnapshot",
            ResourceType::StaticIp => "StaticIp",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Alarm",
            "Bucket",
            "Certificate",
            "CloudFormationStackRecord",
            "ContactMethod",
            "ContainerService",
            "Disk",
            "DiskSnapshot",
            "Distribution",
            "Domain",
            "ExportSnapshotRecord",
            "Instance",
            "InstanceSnapshot",
            "KeyPair",
            "LoadBalancer",
            "LoadBalancerTlsCertificate",
            "PeeredVpc",
            "RelationalDatabase",
            "RelationalDatabaseSnapshot",
            "StaticIp",
        ]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the parameters of a database.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RelationalDatabaseParameter {
    /// <p>Specifies the valid range of values for the parameter.</p>
    pub allowed_values: std::option::Option<std::string::String>,
    /// <p>Indicates when parameter updates are applied.</p>
    /// <p>Can be <code>immediate</code> or <code>pending-reboot</code>.</p>
    pub apply_method: std::option::Option<std::string::String>,
    /// <p>Specifies the engine-specific parameter type.</p>
    pub apply_type: std::option::Option<std::string::String>,
    /// <p>Specifies the valid data type for the parameter.</p>
    pub data_type: std::option::Option<std::string::String>,
    /// <p>Provides a description of the parameter.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A Boolean value indicating whether the parameter can be modified.</p>
    pub is_modifiable: std::option::Option<bool>,
    /// <p>Specifies the name of the parameter.</p>
    pub parameter_name: std::option::Option<std::string::String>,
    /// <p>Specifies the value of the parameter.</p>
    pub parameter_value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RelationalDatabaseParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RelationalDatabaseParameter");
        formatter.field("allowed_values", &self.allowed_values);
        formatter.field("apply_method", &self.apply_method);
        formatter.field("apply_type", &self.apply_type);
        formatter.field("data_type", &self.data_type);
        formatter.field("description", &self.description);
        formatter.field("is_modifiable", &self.is_modifiable);
        formatter.field("parameter_name", &self.parameter_name);
        formatter.field("parameter_value", &self.parameter_value);
        formatter.finish()
    }
}
/// See [`RelationalDatabaseParameter`](crate::model::RelationalDatabaseParameter)
pub mod relational_database_parameter {
    /// A builder for [`RelationalDatabaseParameter`](crate::model::RelationalDatabaseParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allowed_values: std::option::Option<std::string::String>,
        pub(crate) apply_method: std::option::Option<std::string::String>,
        pub(crate) apply_type: std::option::Option<std::string::String>,
        pub(crate) data_type: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) is_modifiable: std::option::Option<bool>,
        pub(crate) parameter_name: std::option::Option<std::string::String>,
        pub(crate) parameter_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the valid range of values for the parameter.</p>
        pub fn allowed_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.allowed_values = Some(input.into());
            self
        }
        /// <p>Specifies the valid range of values for the parameter.</p>
        pub fn set_allowed_values(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allowed_values = input;
            self
        }
        /// <p>Indicates when parameter updates are applied.</p>
        /// <p>Can be <code>immediate</code> or <code>pending-reboot</code>.</p>
        pub fn apply_method(mut self, input: impl Into<std::string::String>) -> Self {
            self.apply_method = Some(input.into());
            self
        }
        /// <p>Indicates when parameter updates are applied.</p>
        /// <p>Can be <code>immediate</code> or <code>pending-reboot</code>.</p>
        pub fn set_apply_method(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.apply_method = input;
            self
        }
        /// <p>Specifies the engine-specific parameter type.</p>
        pub fn apply_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.apply_type = Some(input.into());
            self
        }
        /// <p>Specifies the engine-specific parameter type.</p>
        pub fn set_apply_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.apply_type = input;
            self
        }
        /// <p>Specifies the valid data type for the parameter.</p>
        pub fn data_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type = Some(input.into());
            self
        }
        /// <p>Specifies the valid data type for the parameter.</p>
        pub fn set_data_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_type = input;
            self
        }
        /// <p>Provides a description of the parameter.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Provides a description of the parameter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A Boolean value indicating whether the parameter can be modified.</p>
        pub fn is_modifiable(mut self, input: bool) -> Self {
            self.is_modifiable = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether the parameter can be modified.</p>
        pub fn set_is_modifiable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_modifiable = input;
            self
        }
        /// <p>Specifies the name of the parameter.</p>
        pub fn parameter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the parameter.</p>
        pub fn set_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_name = input;
            self
        }
        /// <p>Specifies the value of the parameter.</p>
        pub fn parameter_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_value = Some(input.into());
            self
        }
        /// <p>Specifies the value of the parameter.</p>
        pub fn set_parameter_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_value = input;
            self
        }
        /// Consumes the builder and constructs a [`RelationalDatabaseParameter`](crate::model::RelationalDatabaseParameter)
        pub fn build(self) -> crate::model::RelationalDatabaseParameter {
            crate::model::RelationalDatabaseParameter {
                allowed_values: self.allowed_values,
                apply_method: self.apply_method,
                apply_type: self.apply_type,
                data_type: self.data_type,
                description: self.description,
                is_modifiable: self.is_modifiable,
                parameter_name: self.parameter_name,
                parameter_value: self.parameter_value,
            }
        }
    }
}
impl RelationalDatabaseParameter {
    /// Creates a new builder-style object to manufacture [`RelationalDatabaseParameter`](crate::model::RelationalDatabaseParameter)
    pub fn builder() -> crate::model::relational_database_parameter::Builder {
        crate::model::relational_database_parameter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LoadBalancerAttributeName {
    #[allow(missing_docs)] // documentation missing in model
    HealthCheckPath,
    #[allow(missing_docs)] // documentation missing in model
    SessionStickinessEnabled,
    #[allow(missing_docs)] // documentation missing in model
    SessionStickinessLbCookieDurationSeconds,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LoadBalancerAttributeName {
    fn from(s: &str) -> Self {
        match s {
            "HealthCheckPath" => LoadBalancerAttributeName::HealthCheckPath,
            "SessionStickinessEnabled" => LoadBalancerAttributeName::SessionStickinessEnabled,
            "SessionStickiness_LB_CookieDurationSeconds" => {
                LoadBalancerAttributeName::SessionStickinessLbCookieDurationSeconds
            }
            other => LoadBalancerAttributeName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LoadBalancerAttributeName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LoadBalancerAttributeName::from(s))
    }
}
impl LoadBalancerAttributeName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LoadBalancerAttributeName::HealthCheckPath => "HealthCheckPath",
            LoadBalancerAttributeName::SessionStickinessEnabled => "SessionStickinessEnabled",
            LoadBalancerAttributeName::SessionStickinessLbCookieDurationSeconds => {
                "SessionStickiness_LB_CookieDurationSeconds"
            }
            LoadBalancerAttributeName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "HealthCheckPath",
            "SessionStickinessEnabled",
            "SessionStickiness_LB_CookieDurationSeconds",
        ]
    }
}
impl AsRef<str> for LoadBalancerAttributeName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a domain recordset entry.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainEntry {
    /// <p>The ID of the domain recordset entry.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the domain.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The target IP address (e.g., <code>192.0.2.0</code>), or AWS name server (e.g.,
    /// <code>ns-111.awsdns-22.com.</code>).</p>
    /// <p>For Lightsail load balancers, the value looks like
    /// <code>ab1234c56789c6b86aba6fb203d443bc-123456789.us-east-2.elb.amazonaws.com</code>. For
    /// Lightsail distributions, the value looks like <code>exampled1182ne.cloudfront.net</code>.
    /// For Lightsail container services, the value looks like
    /// <code>container-service-1.example23scljs.us-west-2.cs.amazonlightsail.com</code>. Be sure to
    /// also set <code>isAlias</code> to <code>true</code> when setting up an A record for a
    /// Lightsail load balancer, distribution, or container service.</p>
    pub target: std::option::Option<std::string::String>,
    /// <p>When <code>true</code>, specifies whether the domain entry is an alias used by the
    /// Lightsail load balancer. You can include an alias (A type) record in your request, which
    /// points to a load balancer DNS name and routes traffic to your load balancer.</p>
    pub is_alias: std::option::Option<bool>,
    /// <p>The type of domain entry, such as address for IPv4 (A), address for IPv6 (AAAA), canonical
    /// name (CNAME), mail exchanger (MX), name server (NS), start of authority (SOA), service locator
    /// (SRV), or text (TXT).</p>
    /// <p>The following domain entry types can be used:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>A</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AAAA</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CNAME</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MX</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NS</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SOA</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SRV</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TXT</code>
    /// </p>
    /// </li>
    /// </ul>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>(Deprecated) The options for the domain entry.</p>
    /// <note>
    /// <p>In releases prior to November 29, 2017, this parameter was not included in the API
    /// response. It is now deprecated.</p>
    /// </note>
    pub options:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for DomainEntry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainEntry");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("target", &self.target);
        formatter.field("is_alias", &self.is_alias);
        formatter.field("r#type", &self.r#type);
        formatter.field("options", &self.options);
        formatter.finish()
    }
}
/// See [`DomainEntry`](crate::model::DomainEntry)
pub mod domain_entry {
    /// A builder for [`DomainEntry`](crate::model::DomainEntry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
        pub(crate) is_alias: std::option::Option<bool>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) options: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ID of the domain recordset entry.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the domain recordset entry.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the domain.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the domain.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The target IP address (e.g., <code>192.0.2.0</code>), or AWS name server (e.g.,
        /// <code>ns-111.awsdns-22.com.</code>).</p>
        /// <p>For Lightsail load balancers, the value looks like
        /// <code>ab1234c56789c6b86aba6fb203d443bc-123456789.us-east-2.elb.amazonaws.com</code>. For
        /// Lightsail distributions, the value looks like <code>exampled1182ne.cloudfront.net</code>.
        /// For Lightsail container services, the value looks like
        /// <code>container-service-1.example23scljs.us-west-2.cs.amazonlightsail.com</code>. Be sure to
        /// also set <code>isAlias</code> to <code>true</code> when setting up an A record for a
        /// Lightsail load balancer, distribution, or container service.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The target IP address (e.g., <code>192.0.2.0</code>), or AWS name server (e.g.,
        /// <code>ns-111.awsdns-22.com.</code>).</p>
        /// <p>For Lightsail load balancers, the value looks like
        /// <code>ab1234c56789c6b86aba6fb203d443bc-123456789.us-east-2.elb.amazonaws.com</code>. For
        /// Lightsail distributions, the value looks like <code>exampled1182ne.cloudfront.net</code>.
        /// For Lightsail container services, the value looks like
        /// <code>container-service-1.example23scljs.us-west-2.cs.amazonlightsail.com</code>. Be sure to
        /// also set <code>isAlias</code> to <code>true</code> when setting up an A record for a
        /// Lightsail load balancer, distribution, or container service.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// <p>When <code>true</code>, specifies whether the domain entry is an alias used by the
        /// Lightsail load balancer. You can include an alias (A type) record in your request, which
        /// points to a load balancer DNS name and routes traffic to your load balancer.</p>
        pub fn is_alias(mut self, input: bool) -> Self {
            self.is_alias = Some(input);
            self
        }
        /// <p>When <code>true</code>, specifies whether the domain entry is an alias used by the
        /// Lightsail load balancer. You can include an alias (A type) record in your request, which
        /// points to a load balancer DNS name and routes traffic to your load balancer.</p>
        pub fn set_is_alias(mut self, input: std::option::Option<bool>) -> Self {
            self.is_alias = input;
            self
        }
        /// <p>The type of domain entry, such as address for IPv4 (A), address for IPv6 (AAAA), canonical
        /// name (CNAME), mail exchanger (MX), name server (NS), start of authority (SOA), service locator
        /// (SRV), or text (TXT).</p>
        /// <p>The following domain entry types can be used:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>A</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AAAA</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CNAME</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MX</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SOA</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SRV</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TXT</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of domain entry, such as address for IPv4 (A), address for IPv6 (AAAA), canonical
        /// name (CNAME), mail exchanger (MX), name server (NS), start of authority (SOA), service locator
        /// (SRV), or text (TXT).</p>
        /// <p>The following domain entry types can be used:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>A</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AAAA</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CNAME</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MX</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NS</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SOA</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>SRV</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TXT</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Adds a key-value pair to `options`.
        ///
        /// To override the contents of this collection use [`set_options`](Self::set_options).
        ///
        /// <p>(Deprecated) The options for the domain entry.</p>
        /// <note>
        /// <p>In releases prior to November 29, 2017, this parameter was not included in the API
        /// response. It is now deprecated.</p>
        /// </note>
        pub fn options(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.options.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.options = Some(hash_map);
            self
        }
        /// <p>(Deprecated) The options for the domain entry.</p>
        /// <note>
        /// <p>In releases prior to November 29, 2017, this parameter was not included in the API
        /// response. It is now deprecated.</p>
        /// </note>
        pub fn set_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.options = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainEntry`](crate::model::DomainEntry)
        pub fn build(self) -> crate::model::DomainEntry {
            crate::model::DomainEntry {
                id: self.id,
                name: self.name,
                target: self.target,
                is_alias: self.is_alias,
                r#type: self.r#type,
                options: self.options,
            }
        }
    }
}
impl DomainEntry {
    /// Creates a new builder-style object to manufacture [`DomainEntry`](crate::model::DomainEntry)
    pub fn builder() -> crate::model::domain_entry::Builder {
        crate::model::domain_entry::Builder::default()
    }
}

/// <p>Describes the per-path cache behavior of an Amazon Lightsail content delivery network (CDN)
/// distribution.</p>
/// <p>A per-path cache behavior is used to override, or add an exception to, the default cache
/// behavior of a distribution. For example, if the <code>cacheBehavior</code> is set to
/// <code>cache</code>, then a per-path cache behavior can be used to specify a directory, file,
/// or file type that your distribution will cache. Alternately, if the distribution's
/// <code>cacheBehavior</code> is <code>dont-cache</code>, then a per-path cache behavior can be
/// used to specify a directory, file, or file type that your distribution will not cache.</p>
/// <p>if the cacheBehavior's behavior is set to 'cache', then</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CacheBehaviorPerPath {
    /// <p>The path to a directory or file to cached, or not cache. Use an asterisk symbol to specify
    /// wildcard directories (<code>path/to/assets/*</code>), and file types (<code>*.html, *jpg,
    /// *js</code>). Directories and file paths are case-sensitive.</p>
    /// <p>Examples:</p>
    /// <ul>
    /// <li>
    /// <p>Specify the following to cache all files in the document root of an Apache web server
    /// running on a Lightsail instance.</p>
    /// <p>
    /// <code>var/www/html/</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Specify the following file to cache only the index page in the document root of an
    /// Apache web server.</p>
    /// <p>
    /// <code>var/www/html/index.html</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Specify the following to cache only the .html files in the document root of an Apache
    /// web server.</p>
    /// <p>
    /// <code>var/www/html/*.html</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Specify the following to cache only the .jpg, .png, and .gif files in the images
    /// sub-directory of the document root of an Apache web server.</p>
    /// <p>
    /// <code>var/www/html/images/*.jpg</code>
    /// </p>
    /// <p>
    /// <code>var/www/html/images/*.png</code>
    /// </p>
    /// <p>
    /// <code>var/www/html/images/*.gif</code>
    /// </p>
    /// <p>Specify the following to cache all files in the images sub-directory of the document
    /// root of an Apache web server.</p>
    /// <p>
    /// <code>var/www/html/images/</code>
    /// </p>
    /// </li>
    /// </ul>
    pub path: std::option::Option<std::string::String>,
    /// <p>The cache behavior for the specified path.</p>
    /// <p>You can specify one of the following per-path cache behaviors:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>cache</code>
    /// </b> - This behavior caches the
    /// specified path. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>dont-cache</code>
    /// </b> - This behavior doesn't cache
    /// the specified path. </p>
    /// </li>
    /// </ul>
    pub behavior: std::option::Option<crate::model::BehaviorEnum>,
}
impl std::fmt::Debug for CacheBehaviorPerPath {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CacheBehaviorPerPath");
        formatter.field("path", &self.path);
        formatter.field("behavior", &self.behavior);
        formatter.finish()
    }
}
/// See [`CacheBehaviorPerPath`](crate::model::CacheBehaviorPerPath)
pub mod cache_behavior_per_path {
    /// A builder for [`CacheBehaviorPerPath`](crate::model::CacheBehaviorPerPath)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) behavior: std::option::Option<crate::model::BehaviorEnum>,
    }
    impl Builder {
        /// <p>The path to a directory or file to cached, or not cache. Use an asterisk symbol to specify
        /// wildcard directories (<code>path/to/assets/*</code>), and file types (<code>*.html, *jpg,
        /// *js</code>). Directories and file paths are case-sensitive.</p>
        /// <p>Examples:</p>
        /// <ul>
        /// <li>
        /// <p>Specify the following to cache all files in the document root of an Apache web server
        /// running on a Lightsail instance.</p>
        /// <p>
        /// <code>var/www/html/</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Specify the following file to cache only the index page in the document root of an
        /// Apache web server.</p>
        /// <p>
        /// <code>var/www/html/index.html</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Specify the following to cache only the .html files in the document root of an Apache
        /// web server.</p>
        /// <p>
        /// <code>var/www/html/*.html</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Specify the following to cache only the .jpg, .png, and .gif files in the images
        /// sub-directory of the document root of an Apache web server.</p>
        /// <p>
        /// <code>var/www/html/images/*.jpg</code>
        /// </p>
        /// <p>
        /// <code>var/www/html/images/*.png</code>
        /// </p>
        /// <p>
        /// <code>var/www/html/images/*.gif</code>
        /// </p>
        /// <p>Specify the following to cache all files in the images sub-directory of the document
        /// root of an Apache web server.</p>
        /// <p>
        /// <code>var/www/html/images/</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path to a directory or file to cached, or not cache. Use an asterisk symbol to specify
        /// wildcard directories (<code>path/to/assets/*</code>), and file types (<code>*.html, *jpg,
        /// *js</code>). Directories and file paths are case-sensitive.</p>
        /// <p>Examples:</p>
        /// <ul>
        /// <li>
        /// <p>Specify the following to cache all files in the document root of an Apache web server
        /// running on a Lightsail instance.</p>
        /// <p>
        /// <code>var/www/html/</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Specify the following file to cache only the index page in the document root of an
        /// Apache web server.</p>
        /// <p>
        /// <code>var/www/html/index.html</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Specify the following to cache only the .html files in the document root of an Apache
        /// web server.</p>
        /// <p>
        /// <code>var/www/html/*.html</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Specify the following to cache only the .jpg, .png, and .gif files in the images
        /// sub-directory of the document root of an Apache web server.</p>
        /// <p>
        /// <code>var/www/html/images/*.jpg</code>
        /// </p>
        /// <p>
        /// <code>var/www/html/images/*.png</code>
        /// </p>
        /// <p>
        /// <code>var/www/html/images/*.gif</code>
        /// </p>
        /// <p>Specify the following to cache all files in the images sub-directory of the document
        /// root of an Apache web server.</p>
        /// <p>
        /// <code>var/www/html/images/</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The cache behavior for the specified path.</p>
        /// <p>You can specify one of the following per-path cache behaviors:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>cache</code>
        /// </b> - This behavior caches the
        /// specified path. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>dont-cache</code>
        /// </b> - This behavior doesn't cache
        /// the specified path. </p>
        /// </li>
        /// </ul>
        pub fn behavior(mut self, input: crate::model::BehaviorEnum) -> Self {
            self.behavior = Some(input);
            self
        }
        /// <p>The cache behavior for the specified path.</p>
        /// <p>You can specify one of the following per-path cache behaviors:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>cache</code>
        /// </b> - This behavior caches the
        /// specified path. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>dont-cache</code>
        /// </b> - This behavior doesn't cache
        /// the specified path. </p>
        /// </li>
        /// </ul>
        pub fn set_behavior(
            mut self,
            input: std::option::Option<crate::model::BehaviorEnum>,
        ) -> Self {
            self.behavior = input;
            self
        }
        /// Consumes the builder and constructs a [`CacheBehaviorPerPath`](crate::model::CacheBehaviorPerPath)
        pub fn build(self) -> crate::model::CacheBehaviorPerPath {
            crate::model::CacheBehaviorPerPath {
                path: self.path,
                behavior: self.behavior,
            }
        }
    }
}
impl CacheBehaviorPerPath {
    /// Creates a new builder-style object to manufacture [`CacheBehaviorPerPath`](crate::model::CacheBehaviorPerPath)
    pub fn builder() -> crate::model::cache_behavior_per_path::Builder {
        crate::model::cache_behavior_per_path::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BehaviorEnum {
    #[allow(missing_docs)] // documentation missing in model
    CacheSetting,
    #[allow(missing_docs)] // documentation missing in model
    DontCacheSetting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BehaviorEnum {
    fn from(s: &str) -> Self {
        match s {
            "cache" => BehaviorEnum::CacheSetting,
            "dont-cache" => BehaviorEnum::DontCacheSetting,
            other => BehaviorEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BehaviorEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BehaviorEnum::from(s))
    }
}
impl BehaviorEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BehaviorEnum::CacheSetting => "cache",
            BehaviorEnum::DontCacheSetting => "dont-cache",
            BehaviorEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["cache", "dont-cache"]
    }
}
impl AsRef<str> for BehaviorEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the cache settings of an Amazon Lightsail content delivery network (CDN)
/// distribution.</p>
/// <p>These settings apply only to your distribution's <code>cacheBehaviors</code> (including
/// the <code>defaultCacheBehavior</code>) that have a <code>behavior</code> of
/// <code>cache</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CacheSettings {
    /// <p>The default amount of time that objects stay in the distribution's cache before the
    /// distribution forwards another request to the origin to determine whether the content has been
    /// updated.</p>
    /// <note>
    /// <p>The value specified applies only when the origin does not add HTTP headers such as
    /// <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and
    /// <code>Expires</code> to objects.</p>
    /// </note>
    pub default_ttl: std::option::Option<i64>,
    /// <p>The minimum amount of time that objects stay in the distribution's cache before the
    /// distribution forwards another request to the origin to determine whether the object has been
    /// updated.</p>
    /// <p>A value of <code>0</code> must be specified for <code>minimumTTL</code> if the
    /// distribution is configured to forward all headers to the origin.</p>
    pub minimum_ttl: std::option::Option<i64>,
    /// <p>The maximum amount of time that objects stay in the distribution's cache before the
    /// distribution forwards another request to the origin to determine whether the object has been
    /// updated.</p>
    /// <p>The value specified applies only when the origin adds HTTP headers such as
    /// <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and
    /// <code>Expires</code> to objects.</p>
    pub maximum_ttl: std::option::Option<i64>,
    /// <p>The HTTP methods that are processed and forwarded to the distribution's origin.</p>
    /// <p>You can specify the following options:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>GET,HEAD</code> - The distribution forwards the <code>GET</code> and
    /// <code>HEAD</code> methods.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GET,HEAD,OPTIONS</code> - The distribution forwards the <code>GET</code>,
    /// <code>HEAD</code>, and <code>OPTIONS</code> methods.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GET,HEAD,OPTIONS,PUT,PATCH,POST,DELETE</code> - The distribution forwards the
    /// <code>GET</code>, <code>HEAD</code>, <code>OPTIONS</code>, <code>PUT</code>,
    /// <code>PATCH</code>, <code>POST</code>, and <code>DELETE</code> methods.</p>
    /// </li>
    /// </ul>
    /// <p>If you specify the third option, you might need to restrict access to your distribution's
    /// origin so users can't perform operations that you don't want them to. For example, you might
    /// not want users to have permission to delete objects from your origin.</p>
    pub allowed_http_methods: std::option::Option<std::string::String>,
    /// <p>The HTTP method responses that are cached by your distribution.</p>
    /// <p>You can specify the following options:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>GET,HEAD</code> - The distribution caches responses to the <code>GET</code> and
    /// <code>HEAD</code> methods.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>GET,HEAD,OPTIONS</code> - The distribution caches responses to the
    /// <code>GET</code>, <code>HEAD</code>, and <code>OPTIONS</code> methods.</p>
    /// </li>
    /// </ul>
    pub cached_http_methods: std::option::Option<std::string::String>,
    /// <p>An object that describes the cookies that are forwarded to the origin. Your content is
    /// cached based on the cookies that are forwarded.</p>
    pub forwarded_cookies: std::option::Option<crate::model::CookieObject>,
    /// <p>An object that describes the headers that are forwarded to the origin. Your content is
    /// cached based on the headers that are forwarded.</p>
    pub forwarded_headers: std::option::Option<crate::model::HeaderObject>,
    /// <p>An object that describes the query strings that are forwarded to the origin. Your content
    /// is cached based on the query strings that are forwarded.</p>
    pub forwarded_query_strings: std::option::Option<crate::model::QueryStringObject>,
}
impl std::fmt::Debug for CacheSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CacheSettings");
        formatter.field("default_ttl", &self.default_ttl);
        formatter.field("minimum_ttl", &self.minimum_ttl);
        formatter.field("maximum_ttl", &self.maximum_ttl);
        formatter.field("allowed_http_methods", &self.allowed_http_methods);
        formatter.field("cached_http_methods", &self.cached_http_methods);
        formatter.field("forwarded_cookies", &self.forwarded_cookies);
        formatter.field("forwarded_headers", &self.forwarded_headers);
        formatter.field("forwarded_query_strings", &self.forwarded_query_strings);
        formatter.finish()
    }
}
/// See [`CacheSettings`](crate::model::CacheSettings)
pub mod cache_settings {
    /// A builder for [`CacheSettings`](crate::model::CacheSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_ttl: std::option::Option<i64>,
        pub(crate) minimum_ttl: std::option::Option<i64>,
        pub(crate) maximum_ttl: std::option::Option<i64>,
        pub(crate) allowed_http_methods: std::option::Option<std::string::String>,
        pub(crate) cached_http_methods: std::option::Option<std::string::String>,
        pub(crate) forwarded_cookies: std::option::Option<crate::model::CookieObject>,
        pub(crate) forwarded_headers: std::option::Option<crate::model::HeaderObject>,
        pub(crate) forwarded_query_strings: std::option::Option<crate::model::QueryStringObject>,
    }
    impl Builder {
        /// <p>The default amount of time that objects stay in the distribution's cache before the
        /// distribution forwards another request to the origin to determine whether the content has been
        /// updated.</p>
        /// <note>
        /// <p>The value specified applies only when the origin does not add HTTP headers such as
        /// <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and
        /// <code>Expires</code> to objects.</p>
        /// </note>
        pub fn default_ttl(mut self, input: i64) -> Self {
            self.default_ttl = Some(input);
            self
        }
        /// <p>The default amount of time that objects stay in the distribution's cache before the
        /// distribution forwards another request to the origin to determine whether the content has been
        /// updated.</p>
        /// <note>
        /// <p>The value specified applies only when the origin does not add HTTP headers such as
        /// <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and
        /// <code>Expires</code> to objects.</p>
        /// </note>
        pub fn set_default_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.default_ttl = input;
            self
        }
        /// <p>The minimum amount of time that objects stay in the distribution's cache before the
        /// distribution forwards another request to the origin to determine whether the object has been
        /// updated.</p>
        /// <p>A value of <code>0</code> must be specified for <code>minimumTTL</code> if the
        /// distribution is configured to forward all headers to the origin.</p>
        pub fn minimum_ttl(mut self, input: i64) -> Self {
            self.minimum_ttl = Some(input);
            self
        }
        /// <p>The minimum amount of time that objects stay in the distribution's cache before the
        /// distribution forwards another request to the origin to determine whether the object has been
        /// updated.</p>
        /// <p>A value of <code>0</code> must be specified for <code>minimumTTL</code> if the
        /// distribution is configured to forward all headers to the origin.</p>
        pub fn set_minimum_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.minimum_ttl = input;
            self
        }
        /// <p>The maximum amount of time that objects stay in the distribution's cache before the
        /// distribution forwards another request to the origin to determine whether the object has been
        /// updated.</p>
        /// <p>The value specified applies only when the origin adds HTTP headers such as
        /// <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and
        /// <code>Expires</code> to objects.</p>
        pub fn maximum_ttl(mut self, input: i64) -> Self {
            self.maximum_ttl = Some(input);
            self
        }
        /// <p>The maximum amount of time that objects stay in the distribution's cache before the
        /// distribution forwards another request to the origin to determine whether the object has been
        /// updated.</p>
        /// <p>The value specified applies only when the origin adds HTTP headers such as
        /// <code>Cache-Control max-age</code>, <code>Cache-Control s-maxage</code>, and
        /// <code>Expires</code> to objects.</p>
        pub fn set_maximum_ttl(mut self, input: std::option::Option<i64>) -> Self {
            self.maximum_ttl = input;
            self
        }
        /// <p>The HTTP methods that are processed and forwarded to the distribution's origin.</p>
        /// <p>You can specify the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>GET,HEAD</code> - The distribution forwards the <code>GET</code> and
        /// <code>HEAD</code> methods.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GET,HEAD,OPTIONS</code> - The distribution forwards the <code>GET</code>,
        /// <code>HEAD</code>, and <code>OPTIONS</code> methods.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GET,HEAD,OPTIONS,PUT,PATCH,POST,DELETE</code> - The distribution forwards the
        /// <code>GET</code>, <code>HEAD</code>, <code>OPTIONS</code>, <code>PUT</code>,
        /// <code>PATCH</code>, <code>POST</code>, and <code>DELETE</code> methods.</p>
        /// </li>
        /// </ul>
        /// <p>If you specify the third option, you might need to restrict access to your distribution's
        /// origin so users can't perform operations that you don't want them to. For example, you might
        /// not want users to have permission to delete objects from your origin.</p>
        pub fn allowed_http_methods(mut self, input: impl Into<std::string::String>) -> Self {
            self.allowed_http_methods = Some(input.into());
            self
        }
        /// <p>The HTTP methods that are processed and forwarded to the distribution's origin.</p>
        /// <p>You can specify the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>GET,HEAD</code> - The distribution forwards the <code>GET</code> and
        /// <code>HEAD</code> methods.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GET,HEAD,OPTIONS</code> - The distribution forwards the <code>GET</code>,
        /// <code>HEAD</code>, and <code>OPTIONS</code> methods.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GET,HEAD,OPTIONS,PUT,PATCH,POST,DELETE</code> - The distribution forwards the
        /// <code>GET</code>, <code>HEAD</code>, <code>OPTIONS</code>, <code>PUT</code>,
        /// <code>PATCH</code>, <code>POST</code>, and <code>DELETE</code> methods.</p>
        /// </li>
        /// </ul>
        /// <p>If you specify the third option, you might need to restrict access to your distribution's
        /// origin so users can't perform operations that you don't want them to. For example, you might
        /// not want users to have permission to delete objects from your origin.</p>
        pub fn set_allowed_http_methods(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allowed_http_methods = input;
            self
        }
        /// <p>The HTTP method responses that are cached by your distribution.</p>
        /// <p>You can specify the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>GET,HEAD</code> - The distribution caches responses to the <code>GET</code> and
        /// <code>HEAD</code> methods.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GET,HEAD,OPTIONS</code> - The distribution caches responses to the
        /// <code>GET</code>, <code>HEAD</code>, and <code>OPTIONS</code> methods.</p>
        /// </li>
        /// </ul>
        pub fn cached_http_methods(mut self, input: impl Into<std::string::String>) -> Self {
            self.cached_http_methods = Some(input.into());
            self
        }
        /// <p>The HTTP method responses that are cached by your distribution.</p>
        /// <p>You can specify the following options:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>GET,HEAD</code> - The distribution caches responses to the <code>GET</code> and
        /// <code>HEAD</code> methods.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GET,HEAD,OPTIONS</code> - The distribution caches responses to the
        /// <code>GET</code>, <code>HEAD</code>, and <code>OPTIONS</code> methods.</p>
        /// </li>
        /// </ul>
        pub fn set_cached_http_methods(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cached_http_methods = input;
            self
        }
        /// <p>An object that describes the cookies that are forwarded to the origin. Your content is
        /// cached based on the cookies that are forwarded.</p>
        pub fn forwarded_cookies(mut self, input: crate::model::CookieObject) -> Self {
            self.forwarded_cookies = Some(input);
            self
        }
        /// <p>An object that describes the cookies that are forwarded to the origin. Your content is
        /// cached based on the cookies that are forwarded.</p>
        pub fn set_forwarded_cookies(
            mut self,
            input: std::option::Option<crate::model::CookieObject>,
        ) -> Self {
            self.forwarded_cookies = input;
            self
        }
        /// <p>An object that describes the headers that are forwarded to the origin. Your content is
        /// cached based on the headers that are forwarded.</p>
        pub fn forwarded_headers(mut self, input: crate::model::HeaderObject) -> Self {
            self.forwarded_headers = Some(input);
            self
        }
        /// <p>An object that describes the headers that are forwarded to the origin. Your content is
        /// cached based on the headers that are forwarded.</p>
        pub fn set_forwarded_headers(
            mut self,
            input: std::option::Option<crate::model::HeaderObject>,
        ) -> Self {
            self.forwarded_headers = input;
            self
        }
        /// <p>An object that describes the query strings that are forwarded to the origin. Your content
        /// is cached based on the query strings that are forwarded.</p>
        pub fn forwarded_query_strings(mut self, input: crate::model::QueryStringObject) -> Self {
            self.forwarded_query_strings = Some(input);
            self
        }
        /// <p>An object that describes the query strings that are forwarded to the origin. Your content
        /// is cached based on the query strings that are forwarded.</p>
        pub fn set_forwarded_query_strings(
            mut self,
            input: std::option::Option<crate::model::QueryStringObject>,
        ) -> Self {
            self.forwarded_query_strings = input;
            self
        }
        /// Consumes the builder and constructs a [`CacheSettings`](crate::model::CacheSettings)
        pub fn build(self) -> crate::model::CacheSettings {
            crate::model::CacheSettings {
                default_ttl: self.default_ttl,
                minimum_ttl: self.minimum_ttl,
                maximum_ttl: self.maximum_ttl,
                allowed_http_methods: self.allowed_http_methods,
                cached_http_methods: self.cached_http_methods,
                forwarded_cookies: self.forwarded_cookies,
                forwarded_headers: self.forwarded_headers,
                forwarded_query_strings: self.forwarded_query_strings,
            }
        }
    }
}
impl CacheSettings {
    /// Creates a new builder-style object to manufacture [`CacheSettings`](crate::model::CacheSettings)
    pub fn builder() -> crate::model::cache_settings::Builder {
        crate::model::cache_settings::Builder::default()
    }
}

/// <p>Describes the query string parameters that an Amazon Lightsail content delivery network
/// (CDN) distribution to bases caching on.</p>
/// <p>For the query strings that you specify, your distribution caches separate versions of the
/// specified content based on the query string values in viewer
/// requests.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct QueryStringObject {
    /// <p>Indicates whether the distribution forwards and caches based on query strings.</p>
    pub option: std::option::Option<bool>,
    /// <p>The specific query strings that the distribution forwards to the origin.</p>
    /// <p>Your distribution will cache content based on the specified query strings.</p>
    /// <p>If the <code>option</code> parameter is true, then your distribution forwards all query
    /// strings, regardless of what you specify using the <code>queryStringsAllowList</code>
    /// parameter.</p>
    pub query_strings_allow_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for QueryStringObject {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("QueryStringObject");
        formatter.field("option", &self.option);
        formatter.field("query_strings_allow_list", &self.query_strings_allow_list);
        formatter.finish()
    }
}
/// See [`QueryStringObject`](crate::model::QueryStringObject)
pub mod query_string_object {
    /// A builder for [`QueryStringObject`](crate::model::QueryStringObject)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) option: std::option::Option<bool>,
        pub(crate) query_strings_allow_list:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Indicates whether the distribution forwards and caches based on query strings.</p>
        pub fn option(mut self, input: bool) -> Self {
            self.option = Some(input);
            self
        }
        /// <p>Indicates whether the distribution forwards and caches based on query strings.</p>
        pub fn set_option(mut self, input: std::option::Option<bool>) -> Self {
            self.option = input;
            self
        }
        /// Appends an item to `query_strings_allow_list`.
        ///
        /// To override the contents of this collection use [`set_query_strings_allow_list`](Self::set_query_strings_allow_list).
        ///
        /// <p>The specific query strings that the distribution forwards to the origin.</p>
        /// <p>Your distribution will cache content based on the specified query strings.</p>
        /// <p>If the <code>option</code> parameter is true, then your distribution forwards all query
        /// strings, regardless of what you specify using the <code>queryStringsAllowList</code>
        /// parameter.</p>
        pub fn query_strings_allow_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.query_strings_allow_list.unwrap_or_default();
            v.push(input.into());
            self.query_strings_allow_list = Some(v);
            self
        }
        /// <p>The specific query strings that the distribution forwards to the origin.</p>
        /// <p>Your distribution will cache content based on the specified query strings.</p>
        /// <p>If the <code>option</code> parameter is true, then your distribution forwards all query
        /// strings, regardless of what you specify using the <code>queryStringsAllowList</code>
        /// parameter.</p>
        pub fn set_query_strings_allow_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.query_strings_allow_list = input;
            self
        }
        /// Consumes the builder and constructs a [`QueryStringObject`](crate::model::QueryStringObject)
        pub fn build(self) -> crate::model::QueryStringObject {
            crate::model::QueryStringObject {
                option: self.option,
                query_strings_allow_list: self.query_strings_allow_list,
            }
        }
    }
}
impl QueryStringObject {
    /// Creates a new builder-style object to manufacture [`QueryStringObject`](crate::model::QueryStringObject)
    pub fn builder() -> crate::model::query_string_object::Builder {
        crate::model::query_string_object::Builder::default()
    }
}

/// <p>Describes the request headers that a Lightsail distribution bases caching on.</p>
/// <p>For the headers that you specify, your distribution caches separate versions of the
/// specified content based on the header values in viewer requests. For example, suppose viewer
/// requests for <code>logo.jpg</code> contain a custom <code>product</code> header that has a
/// value of either <code>acme</code> or <code>apex</code>, and you configure your distribution to
/// cache your content based on values in the <code>product</code> header. Your distribution
/// forwards the <code>product</code> header to the origin and caches the response from the origin
/// once for each header value.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HeaderObject {
    /// <p>The headers that you want your distribution to forward to your origin and base caching
    /// on.</p>
    /// <p>You can configure your distribution to do one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>all</code>
    /// </b> - Forward all headers to your
    /// origin.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>none</code>
    /// </b> - Forward only the default
    /// headers.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>allow-list</code>
    /// </b> - Forward only the headers
    /// you specify using the <code>headersAllowList</code> parameter.</p>
    /// </li>
    /// </ul>
    pub option: std::option::Option<crate::model::ForwardValues>,
    /// <p>The specific headers to forward to your distribution's origin.</p>
    pub headers_allow_list: std::option::Option<std::vec::Vec<crate::model::HeaderEnum>>,
}
impl std::fmt::Debug for HeaderObject {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HeaderObject");
        formatter.field("option", &self.option);
        formatter.field("headers_allow_list", &self.headers_allow_list);
        formatter.finish()
    }
}
/// See [`HeaderObject`](crate::model::HeaderObject)
pub mod header_object {
    /// A builder for [`HeaderObject`](crate::model::HeaderObject)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) option: std::option::Option<crate::model::ForwardValues>,
        pub(crate) headers_allow_list: std::option::Option<std::vec::Vec<crate::model::HeaderEnum>>,
    }
    impl Builder {
        /// <p>The headers that you want your distribution to forward to your origin and base caching
        /// on.</p>
        /// <p>You can configure your distribution to do one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>all</code>
        /// </b> - Forward all headers to your
        /// origin.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>none</code>
        /// </b> - Forward only the default
        /// headers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>allow-list</code>
        /// </b> - Forward only the headers
        /// you specify using the <code>headersAllowList</code> parameter.</p>
        /// </li>
        /// </ul>
        pub fn option(mut self, input: crate::model::ForwardValues) -> Self {
            self.option = Some(input);
            self
        }
        /// <p>The headers that you want your distribution to forward to your origin and base caching
        /// on.</p>
        /// <p>You can configure your distribution to do one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>all</code>
        /// </b> - Forward all headers to your
        /// origin.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>none</code>
        /// </b> - Forward only the default
        /// headers.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>allow-list</code>
        /// </b> - Forward only the headers
        /// you specify using the <code>headersAllowList</code> parameter.</p>
        /// </li>
        /// </ul>
        pub fn set_option(
            mut self,
            input: std::option::Option<crate::model::ForwardValues>,
        ) -> Self {
            self.option = input;
            self
        }
        /// Appends an item to `headers_allow_list`.
        ///
        /// To override the contents of this collection use [`set_headers_allow_list`](Self::set_headers_allow_list).
        ///
        /// <p>The specific headers to forward to your distribution's origin.</p>
        pub fn headers_allow_list(mut self, input: impl Into<crate::model::HeaderEnum>) -> Self {
            let mut v = self.headers_allow_list.unwrap_or_default();
            v.push(input.into());
            self.headers_allow_list = Some(v);
            self
        }
        /// <p>The specific headers to forward to your distribution's origin.</p>
        pub fn set_headers_allow_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HeaderEnum>>,
        ) -> Self {
            self.headers_allow_list = input;
            self
        }
        /// Consumes the builder and constructs a [`HeaderObject`](crate::model::HeaderObject)
        pub fn build(self) -> crate::model::HeaderObject {
            crate::model::HeaderObject {
                option: self.option,
                headers_allow_list: self.headers_allow_list,
            }
        }
    }
}
impl HeaderObject {
    /// Creates a new builder-style object to manufacture [`HeaderObject`](crate::model::HeaderObject)
    pub fn builder() -> crate::model::header_object::Builder {
        crate::model::header_object::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HeaderEnum {
    #[allow(missing_docs)] // documentation missing in model
    Accept,
    #[allow(missing_docs)] // documentation missing in model
    AcceptCharset,
    #[allow(missing_docs)] // documentation missing in model
    AcceptDatetime,
    #[allow(missing_docs)] // documentation missing in model
    AcceptEncoding,
    #[allow(missing_docs)] // documentation missing in model
    AcceptLanguage,
    #[allow(missing_docs)] // documentation missing in model
    Authorization,
    #[allow(missing_docs)] // documentation missing in model
    CloudFrontForwardedProto,
    #[allow(missing_docs)] // documentation missing in model
    CloudFrontIsDesktopViewer,
    #[allow(missing_docs)] // documentation missing in model
    CloudFrontIsMobileViewer,
    #[allow(missing_docs)] // documentation missing in model
    CloudFrontIsSmartTvViewer,
    #[allow(missing_docs)] // documentation missing in model
    CloudFrontIsTabletViewer,
    #[allow(missing_docs)] // documentation missing in model
    CloudFrontViewerCountry,
    #[allow(missing_docs)] // documentation missing in model
    Host,
    #[allow(missing_docs)] // documentation missing in model
    Origin,
    #[allow(missing_docs)] // documentation missing in model
    Referer,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HeaderEnum {
    fn from(s: &str) -> Self {
        match s {
            "Accept" => HeaderEnum::Accept,
            "Accept-Charset" => HeaderEnum::AcceptCharset,
            "Accept-Datetime" => HeaderEnum::AcceptDatetime,
            "Accept-Encoding" => HeaderEnum::AcceptEncoding,
            "Accept-Language" => HeaderEnum::AcceptLanguage,
            "Authorization" => HeaderEnum::Authorization,
            "CloudFront-Forwarded-Proto" => HeaderEnum::CloudFrontForwardedProto,
            "CloudFront-Is-Desktop-Viewer" => HeaderEnum::CloudFrontIsDesktopViewer,
            "CloudFront-Is-Mobile-Viewer" => HeaderEnum::CloudFrontIsMobileViewer,
            "CloudFront-Is-SmartTV-Viewer" => HeaderEnum::CloudFrontIsSmartTvViewer,
            "CloudFront-Is-Tablet-Viewer" => HeaderEnum::CloudFrontIsTabletViewer,
            "CloudFront-Viewer-Country" => HeaderEnum::CloudFrontViewerCountry,
            "Host" => HeaderEnum::Host,
            "Origin" => HeaderEnum::Origin,
            "Referer" => HeaderEnum::Referer,
            other => HeaderEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HeaderEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HeaderEnum::from(s))
    }
}
impl HeaderEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HeaderEnum::Accept => "Accept",
            HeaderEnum::AcceptCharset => "Accept-Charset",
            HeaderEnum::AcceptDatetime => "Accept-Datetime",
            HeaderEnum::AcceptEncoding => "Accept-Encoding",
            HeaderEnum::AcceptLanguage => "Accept-Language",
            HeaderEnum::Authorization => "Authorization",
            HeaderEnum::CloudFrontForwardedProto => "CloudFront-Forwarded-Proto",
            HeaderEnum::CloudFrontIsDesktopViewer => "CloudFront-Is-Desktop-Viewer",
            HeaderEnum::CloudFrontIsMobileViewer => "CloudFront-Is-Mobile-Viewer",
            HeaderEnum::CloudFrontIsSmartTvViewer => "CloudFront-Is-SmartTV-Viewer",
            HeaderEnum::CloudFrontIsTabletViewer => "CloudFront-Is-Tablet-Viewer",
            HeaderEnum::CloudFrontViewerCountry => "CloudFront-Viewer-Country",
            HeaderEnum::Host => "Host",
            HeaderEnum::Origin => "Origin",
            HeaderEnum::Referer => "Referer",
            HeaderEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Accept",
            "Accept-Charset",
            "Accept-Datetime",
            "Accept-Encoding",
            "Accept-Language",
            "Authorization",
            "CloudFront-Forwarded-Proto",
            "CloudFront-Is-Desktop-Viewer",
            "CloudFront-Is-Mobile-Viewer",
            "CloudFront-Is-SmartTV-Viewer",
            "CloudFront-Is-Tablet-Viewer",
            "CloudFront-Viewer-Country",
            "Host",
            "Origin",
            "Referer",
        ]
    }
}
impl AsRef<str> for HeaderEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ForwardValues {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    AllowList,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ForwardValues {
    fn from(s: &str) -> Self {
        match s {
            "all" => ForwardValues::All,
            "allow-list" => ForwardValues::AllowList,
            "none" => ForwardValues::None,
            other => ForwardValues::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ForwardValues {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ForwardValues::from(s))
    }
}
impl ForwardValues {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ForwardValues::All => "all",
            ForwardValues::AllowList => "allow-list",
            ForwardValues::None => "none",
            ForwardValues::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["all", "allow-list", "none"]
    }
}
impl AsRef<str> for ForwardValues {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes whether an Amazon Lightsail content delivery network (CDN) distribution forwards
/// cookies to the origin and, if so, which ones.</p>
/// <p>For the cookies that you specify, your distribution caches separate versions of the
/// specified content based on the cookie values in viewer
/// requests.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CookieObject {
    /// <p>Specifies which cookies to forward to the distribution's origin for a cache behavior:
    /// <code>all</code>, <code>none</code>, or <code>allow-list</code> to forward only the cookies
    /// specified in the <code>cookiesAllowList</code> parameter.</p>
    pub option: std::option::Option<crate::model::ForwardValues>,
    /// <p>The specific cookies to forward to your distribution's origin.</p>
    pub cookies_allow_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for CookieObject {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CookieObject");
        formatter.field("option", &self.option);
        formatter.field("cookies_allow_list", &self.cookies_allow_list);
        formatter.finish()
    }
}
/// See [`CookieObject`](crate::model::CookieObject)
pub mod cookie_object {
    /// A builder for [`CookieObject`](crate::model::CookieObject)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) option: std::option::Option<crate::model::ForwardValues>,
        pub(crate) cookies_allow_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Specifies which cookies to forward to the distribution's origin for a cache behavior:
        /// <code>all</code>, <code>none</code>, or <code>allow-list</code> to forward only the cookies
        /// specified in the <code>cookiesAllowList</code> parameter.</p>
        pub fn option(mut self, input: crate::model::ForwardValues) -> Self {
            self.option = Some(input);
            self
        }
        /// <p>Specifies which cookies to forward to the distribution's origin for a cache behavior:
        /// <code>all</code>, <code>none</code>, or <code>allow-list</code> to forward only the cookies
        /// specified in the <code>cookiesAllowList</code> parameter.</p>
        pub fn set_option(
            mut self,
            input: std::option::Option<crate::model::ForwardValues>,
        ) -> Self {
            self.option = input;
            self
        }
        /// Appends an item to `cookies_allow_list`.
        ///
        /// To override the contents of this collection use [`set_cookies_allow_list`](Self::set_cookies_allow_list).
        ///
        /// <p>The specific cookies to forward to your distribution's origin.</p>
        pub fn cookies_allow_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cookies_allow_list.unwrap_or_default();
            v.push(input.into());
            self.cookies_allow_list = Some(v);
            self
        }
        /// <p>The specific cookies to forward to your distribution's origin.</p>
        pub fn set_cookies_allow_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cookies_allow_list = input;
            self
        }
        /// Consumes the builder and constructs a [`CookieObject`](crate::model::CookieObject)
        pub fn build(self) -> crate::model::CookieObject {
            crate::model::CookieObject {
                option: self.option,
                cookies_allow_list: self.cookies_allow_list,
            }
        }
    }
}
impl CookieObject {
    /// Creates a new builder-style object to manufacture [`CookieObject`](crate::model::CookieObject)
    pub fn builder() -> crate::model::cookie_object::Builder {
        crate::model::cookie_object::Builder::default()
    }
}

/// <p>Describes the default cache behavior of an Amazon Lightsail content delivery network (CDN)
/// distribution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CacheBehavior {
    /// <p>The cache behavior of the distribution.</p>
    /// <p>The following cache behaviors can be specified:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>cache</code>
    /// </b> - This option is best for static
    /// sites. When specified, your distribution caches and serves your entire website as static
    /// content. This behavior is ideal for websites with static content that doesn't change
    /// depending on who views it, or for websites that don't use cookies, headers, or query
    /// strings to personalize content.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>dont-cache</code>
    /// </b> - This option is best for
    /// sites that serve a mix of static and dynamic content. When specified, your distribution
    /// caches and serve only the content that is specified in the distribution's
    /// <code>CacheBehaviorPerPath</code> parameter. This behavior is ideal for websites or web
    /// applications that use cookies, headers, and query strings to personalize content for
    /// individual users.</p>
    /// </li>
    /// </ul>
    pub behavior: std::option::Option<crate::model::BehaviorEnum>,
}
impl std::fmt::Debug for CacheBehavior {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CacheBehavior");
        formatter.field("behavior", &self.behavior);
        formatter.finish()
    }
}
/// See [`CacheBehavior`](crate::model::CacheBehavior)
pub mod cache_behavior {
    /// A builder for [`CacheBehavior`](crate::model::CacheBehavior)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) behavior: std::option::Option<crate::model::BehaviorEnum>,
    }
    impl Builder {
        /// <p>The cache behavior of the distribution.</p>
        /// <p>The following cache behaviors can be specified:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>cache</code>
        /// </b> - This option is best for static
        /// sites. When specified, your distribution caches and serves your entire website as static
        /// content. This behavior is ideal for websites with static content that doesn't change
        /// depending on who views it, or for websites that don't use cookies, headers, or query
        /// strings to personalize content.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>dont-cache</code>
        /// </b> - This option is best for
        /// sites that serve a mix of static and dynamic content. When specified, your distribution
        /// caches and serve only the content that is specified in the distribution's
        /// <code>CacheBehaviorPerPath</code> parameter. This behavior is ideal for websites or web
        /// applications that use cookies, headers, and query strings to personalize content for
        /// individual users.</p>
        /// </li>
        /// </ul>
        pub fn behavior(mut self, input: crate::model::BehaviorEnum) -> Self {
            self.behavior = Some(input);
            self
        }
        /// <p>The cache behavior of the distribution.</p>
        /// <p>The following cache behaviors can be specified:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>cache</code>
        /// </b> - This option is best for static
        /// sites. When specified, your distribution caches and serves your entire website as static
        /// content. This behavior is ideal for websites with static content that doesn't change
        /// depending on who views it, or for websites that don't use cookies, headers, or query
        /// strings to personalize content.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>dont-cache</code>
        /// </b> - This option is best for
        /// sites that serve a mix of static and dynamic content. When specified, your distribution
        /// caches and serve only the content that is specified in the distribution's
        /// <code>CacheBehaviorPerPath</code> parameter. This behavior is ideal for websites or web
        /// applications that use cookies, headers, and query strings to personalize content for
        /// individual users.</p>
        /// </li>
        /// </ul>
        pub fn set_behavior(
            mut self,
            input: std::option::Option<crate::model::BehaviorEnum>,
        ) -> Self {
            self.behavior = input;
            self
        }
        /// Consumes the builder and constructs a [`CacheBehavior`](crate::model::CacheBehavior)
        pub fn build(self) -> crate::model::CacheBehavior {
            crate::model::CacheBehavior {
                behavior: self.behavior,
            }
        }
    }
}
impl CacheBehavior {
    /// Creates a new builder-style object to manufacture [`CacheBehavior`](crate::model::CacheBehavior)
    pub fn builder() -> crate::model::cache_behavior::Builder {
        crate::model::cache_behavior::Builder::default()
    }
}

/// <p>Describes the origin resource of an Amazon Lightsail content delivery network (CDN)
/// distribution.</p>
/// <p>An origin can be a Lightsail instance or load balancer. A distribution pulls content
/// from an origin, caches it, and serves it to viewers via a worldwide network of edge
/// servers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputOrigin {
    /// <p>The name of the origin resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The AWS Region name of the origin resource.</p>
    pub region_name: std::option::Option<crate::model::RegionName>,
    /// <p>The protocol that your Amazon Lightsail distribution uses when establishing a connection
    /// with your origin to pull content.</p>
    pub protocol_policy: std::option::Option<crate::model::OriginProtocolPolicyEnum>,
}
impl std::fmt::Debug for InputOrigin {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputOrigin");
        formatter.field("name", &self.name);
        formatter.field("region_name", &self.region_name);
        formatter.field("protocol_policy", &self.protocol_policy);
        formatter.finish()
    }
}
/// See [`InputOrigin`](crate::model::InputOrigin)
pub mod input_origin {
    /// A builder for [`InputOrigin`](crate::model::InputOrigin)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) region_name: std::option::Option<crate::model::RegionName>,
        pub(crate) protocol_policy: std::option::Option<crate::model::OriginProtocolPolicyEnum>,
    }
    impl Builder {
        /// <p>The name of the origin resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the origin resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The AWS Region name of the origin resource.</p>
        pub fn region_name(mut self, input: crate::model::RegionName) -> Self {
            self.region_name = Some(input);
            self
        }
        /// <p>The AWS Region name of the origin resource.</p>
        pub fn set_region_name(
            mut self,
            input: std::option::Option<crate::model::RegionName>,
        ) -> Self {
            self.region_name = input;
            self
        }
        /// <p>The protocol that your Amazon Lightsail distribution uses when establishing a connection
        /// with your origin to pull content.</p>
        pub fn protocol_policy(mut self, input: crate::model::OriginProtocolPolicyEnum) -> Self {
            self.protocol_policy = Some(input);
            self
        }
        /// <p>The protocol that your Amazon Lightsail distribution uses when establishing a connection
        /// with your origin to pull content.</p>
        pub fn set_protocol_policy(
            mut self,
            input: std::option::Option<crate::model::OriginProtocolPolicyEnum>,
        ) -> Self {
            self.protocol_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`InputOrigin`](crate::model::InputOrigin)
        pub fn build(self) -> crate::model::InputOrigin {
            crate::model::InputOrigin {
                name: self.name,
                region_name: self.region_name,
                protocol_policy: self.protocol_policy,
            }
        }
    }
}
impl InputOrigin {
    /// Creates a new builder-style object to manufacture [`InputOrigin`](crate::model::InputOrigin)
    pub fn builder() -> crate::model::input_origin::Builder {
        crate::model::input_origin::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OriginProtocolPolicyEnum {
    #[allow(missing_docs)] // documentation missing in model
    HttpOnly,
    #[allow(missing_docs)] // documentation missing in model
    HttpsOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OriginProtocolPolicyEnum {
    fn from(s: &str) -> Self {
        match s {
            "http-only" => OriginProtocolPolicyEnum::HttpOnly,
            "https-only" => OriginProtocolPolicyEnum::HttpsOnly,
            other => OriginProtocolPolicyEnum::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OriginProtocolPolicyEnum {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OriginProtocolPolicyEnum::from(s))
    }
}
impl OriginProtocolPolicyEnum {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OriginProtocolPolicyEnum::HttpOnly => "http-only",
            OriginProtocolPolicyEnum::HttpsOnly => "https-only",
            OriginProtocolPolicyEnum::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["http-only", "https-only"]
    }
}
impl AsRef<str> for OriginProtocolPolicyEnum {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an Amazon Lightsail container service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContainerService {
    /// <p>The name of the container service.</p>
    pub container_service_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the container service.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The timestamp when the container service was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>An object that describes the location of the container service, such as the AWS Region
    /// and Availability Zone.</p>
    pub location: std::option::Option<crate::model::ResourceLocation>,
    /// <p>The Lightsail resource type of the container service (i.e.,
    /// <code>ContainerService</code>).</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The tag keys and optional values for the resource. For more information about tags in
    /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The power specification of the container service.</p>
    ///
    /// <p>The power specifies the amount of RAM, the number of vCPUs, and the base price of the
    /// container service.</p>
    pub power: std::option::Option<crate::model::ContainerServicePowerName>,
    /// <p>The ID of the power of the container service.</p>
    pub power_id: std::option::Option<std::string::String>,
    /// <p>The current state of the container service.</p>
    /// <p>The following container service states are possible:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - The container service is being created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>READY</code> - The container service is running but it does not have an active
    /// container deployment.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DEPLOYING</code> - The container service is launching a container
    /// deployment.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RUNNING</code> - The container service is running and it has an active container
    /// deployment.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATING</code> - The container service capacity or its custom domains are being
    /// updated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code> - The container service is being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DISABLED</code> - The container service is disabled, and its active deployment
    /// and containers, if any, are shut down.</p>
    /// </li>
    /// </ul>
    pub state: std::option::Option<crate::model::ContainerServiceState>,
    /// <p>An object that describes the current state of the container service.</p>
    /// <note>
    /// <p>The state detail is populated only when a container service is in a
    /// <code>PENDING</code>, <code>DEPLOYING</code>, or <code>UPDATING</code> state.</p>
    /// </note>
    pub state_detail: std::option::Option<crate::model::ContainerServiceStateDetail>,
    /// <p>The scale specification of the container service.</p>
    ///
    /// <p>The scale specifies the allocated compute nodes of the container service.</p>
    pub scale: std::option::Option<i32>,
    /// <p>An object that describes the current container deployment of the container service.</p>
    pub current_deployment: std::option::Option<crate::model::ContainerServiceDeployment>,
    /// <p>An object that describes the next deployment of the container service.</p>
    ///
    /// <p>This value is <code>null</code> when there is no deployment in a <code>pending</code>
    /// state.</p>
    pub next_deployment: std::option::Option<crate::model::ContainerServiceDeployment>,
    /// <p>A Boolean value indicating whether the container service is disabled.</p>
    pub is_disabled: std::option::Option<bool>,
    /// <p>The principal ARN of the container service.</p>
    ///
    /// <p>The principal ARN can be used to create a trust relationship between your standard AWS
    /// account and your Lightsail container service. This allows you to give your service
    /// permission to access resources in your standard AWS account.</p>
    pub principal_arn: std::option::Option<std::string::String>,
    /// <p>The private domain name of the container service.</p>
    ///
    /// <p>The private domain name is accessible only by other resources within the default virtual
    /// private cloud (VPC) of your Lightsail account.</p>
    pub private_domain_name: std::option::Option<std::string::String>,
    /// <p>The public domain name of the container service, such as <code>example.com</code> and
    /// <code>www.example.com</code>.</p>
    ///
    /// <p>You can specify up to four public domain names for a container service. The domain names
    /// that you specify are used when you create a deployment with a container configured as the
    /// public endpoint of your container service.</p>
    ///
    /// <p>If you don't specify public domain names, then you can use the default domain of the
    /// container service.</p>
    ///
    /// <important>
    /// <p>You must create and validate an SSL/TLS certificate before you can use public domain
    /// names with your container service. Use the <code>CreateCertificate</code> action to create a
    /// certificate for the public domain names you want to use with your container service.</p>
    /// </important>
    ///
    /// <p>See <code>CreateContainerService</code> or <code>UpdateContainerService</code> for
    /// information about how to specify public domain names for your Lightsail container
    /// service.</p>
    pub public_domain_names: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
    >,
    /// <p>The publicly accessible URL of the container service.</p>
    ///
    /// <p>If no public endpoint is specified in the <code>currentDeployment</code>, this URL returns
    /// a 404 response.</p>
    pub url: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ContainerService {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContainerService");
        formatter.field("container_service_name", &self.container_service_name);
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("location", &self.location);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("tags", &self.tags);
        formatter.field("power", &self.power);
        formatter.field("power_id", &self.power_id);
        formatter.field("state", &self.state);
        formatter.field("state_detail", &self.state_detail);
        formatter.field("scale", &self.scale);
        formatter.field("current_deployment", &self.current_deployment);
        formatter.field("next_deployment", &self.next_deployment);
        formatter.field("is_disabled", &self.is_disabled);
        formatter.field("principal_arn", &self.principal_arn);
        formatter.field("private_domain_name", &self.private_domain_name);
        formatter.field("public_domain_names", &self.public_domain_names);
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`ContainerService`](crate::model::ContainerService)
pub mod container_service {
    /// A builder for [`ContainerService`](crate::model::ContainerService)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_service_name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) location: std::option::Option<crate::model::ResourceLocation>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) power: std::option::Option<crate::model::ContainerServicePowerName>,
        pub(crate) power_id: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ContainerServiceState>,
        pub(crate) state_detail: std::option::Option<crate::model::ContainerServiceStateDetail>,
        pub(crate) scale: std::option::Option<i32>,
        pub(crate) current_deployment:
            std::option::Option<crate::model::ContainerServiceDeployment>,
        pub(crate) next_deployment: std::option::Option<crate::model::ContainerServiceDeployment>,
        pub(crate) is_disabled: std::option::Option<bool>,
        pub(crate) principal_arn: std::option::Option<std::string::String>,
        pub(crate) private_domain_name: std::option::Option<std::string::String>,
        pub(crate) public_domain_names: std::option::Option<
            std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
        >,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the container service.</p>
        pub fn container_service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_service_name = Some(input.into());
            self
        }
        /// <p>The name of the container service.</p>
        pub fn set_container_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_service_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container service.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the container service.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The timestamp when the container service was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when the container service was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>An object that describes the location of the container service, such as the AWS Region
        /// and Availability Zone.</p>
        pub fn location(mut self, input: crate::model::ResourceLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>An object that describes the location of the container service, such as the AWS Region
        /// and Availability Zone.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::ResourceLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>The Lightsail resource type of the container service (i.e.,
        /// <code>ContainerService</code>).</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The Lightsail resource type of the container service (i.e.,
        /// <code>ContainerService</code>).</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The power specification of the container service.</p>
        ///
        /// <p>The power specifies the amount of RAM, the number of vCPUs, and the base price of the
        /// container service.</p>
        pub fn power(mut self, input: crate::model::ContainerServicePowerName) -> Self {
            self.power = Some(input);
            self
        }
        /// <p>The power specification of the container service.</p>
        ///
        /// <p>The power specifies the amount of RAM, the number of vCPUs, and the base price of the
        /// container service.</p>
        pub fn set_power(
            mut self,
            input: std::option::Option<crate::model::ContainerServicePowerName>,
        ) -> Self {
            self.power = input;
            self
        }
        /// <p>The ID of the power of the container service.</p>
        pub fn power_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.power_id = Some(input.into());
            self
        }
        /// <p>The ID of the power of the container service.</p>
        pub fn set_power_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.power_id = input;
            self
        }
        /// <p>The current state of the container service.</p>
        /// <p>The following container service states are possible:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - The container service is being created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>READY</code> - The container service is running but it does not have an active
        /// container deployment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DEPLOYING</code> - The container service is launching a container
        /// deployment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RUNNING</code> - The container service is running and it has an active container
        /// deployment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATING</code> - The container service capacity or its custom domains are being
        /// updated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code> - The container service is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLED</code> - The container service is disabled, and its active deployment
        /// and containers, if any, are shut down.</p>
        /// </li>
        /// </ul>
        pub fn state(mut self, input: crate::model::ContainerServiceState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the container service.</p>
        /// <p>The following container service states are possible:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - The container service is being created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>READY</code> - The container service is running but it does not have an active
        /// container deployment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DEPLOYING</code> - The container service is launching a container
        /// deployment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RUNNING</code> - The container service is running and it has an active container
        /// deployment.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATING</code> - The container service capacity or its custom domains are being
        /// updated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code> - The container service is being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DISABLED</code> - The container service is disabled, and its active deployment
        /// and containers, if any, are shut down.</p>
        /// </li>
        /// </ul>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ContainerServiceState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>An object that describes the current state of the container service.</p>
        /// <note>
        /// <p>The state detail is populated only when a container service is in a
        /// <code>PENDING</code>, <code>DEPLOYING</code>, or <code>UPDATING</code> state.</p>
        /// </note>
        pub fn state_detail(mut self, input: crate::model::ContainerServiceStateDetail) -> Self {
            self.state_detail = Some(input);
            self
        }
        /// <p>An object that describes the current state of the container service.</p>
        /// <note>
        /// <p>The state detail is populated only when a container service is in a
        /// <code>PENDING</code>, <code>DEPLOYING</code>, or <code>UPDATING</code> state.</p>
        /// </note>
        pub fn set_state_detail(
            mut self,
            input: std::option::Option<crate::model::ContainerServiceStateDetail>,
        ) -> Self {
            self.state_detail = input;
            self
        }
        /// <p>The scale specification of the container service.</p>
        ///
        /// <p>The scale specifies the allocated compute nodes of the container service.</p>
        pub fn scale(mut self, input: i32) -> Self {
            self.scale = Some(input);
            self
        }
        /// <p>The scale specification of the container service.</p>
        ///
        /// <p>The scale specifies the allocated compute nodes of the container service.</p>
        pub fn set_scale(mut self, input: std::option::Option<i32>) -> Self {
            self.scale = input;
            self
        }
        /// <p>An object that describes the current container deployment of the container service.</p>
        pub fn current_deployment(
            mut self,
            input: crate::model::ContainerServiceDeployment,
        ) -> Self {
            self.current_deployment = Some(input);
            self
        }
        /// <p>An object that describes the current container deployment of the container service.</p>
        pub fn set_current_deployment(
            mut self,
            input: std::option::Option<crate::model::ContainerServiceDeployment>,
        ) -> Self {
            self.current_deployment = input;
            self
        }
        /// <p>An object that describes the next deployment of the container service.</p>
        ///
        /// <p>This value is <code>null</code> when there is no deployment in a <code>pending</code>
        /// state.</p>
        pub fn next_deployment(mut self, input: crate::model::ContainerServiceDeployment) -> Self {
            self.next_deployment = Some(input);
            self
        }
        /// <p>An object that describes the next deployment of the container service.</p>
        ///
        /// <p>This value is <code>null</code> when there is no deployment in a <code>pending</code>
        /// state.</p>
        pub fn set_next_deployment(
            mut self,
            input: std::option::Option<crate::model::ContainerServiceDeployment>,
        ) -> Self {
            self.next_deployment = input;
            self
        }
        /// <p>A Boolean value indicating whether the container service is disabled.</p>
        pub fn is_disabled(mut self, input: bool) -> Self {
            self.is_disabled = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether the container service is disabled.</p>
        pub fn set_is_disabled(mut self, input: std::option::Option<bool>) -> Self {
            self.is_disabled = input;
            self
        }
        /// <p>The principal ARN of the container service.</p>
        ///
        /// <p>The principal ARN can be used to create a trust relationship between your standard AWS
        /// account and your Lightsail container service. This allows you to give your service
        /// permission to access resources in your standard AWS account.</p>
        pub fn principal_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_arn = Some(input.into());
            self
        }
        /// <p>The principal ARN of the container service.</p>
        ///
        /// <p>The principal ARN can be used to create a trust relationship between your standard AWS
        /// account and your Lightsail container service. This allows you to give your service
        /// permission to access resources in your standard AWS account.</p>
        pub fn set_principal_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.principal_arn = input;
            self
        }
        /// <p>The private domain name of the container service.</p>
        ///
        /// <p>The private domain name is accessible only by other resources within the default virtual
        /// private cloud (VPC) of your Lightsail account.</p>
        pub fn private_domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_domain_name = Some(input.into());
            self
        }
        /// <p>The private domain name of the container service.</p>
        ///
        /// <p>The private domain name is accessible only by other resources within the default virtual
        /// private cloud (VPC) of your Lightsail account.</p>
        pub fn set_private_domain_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_domain_name = input;
            self
        }
        /// Adds a key-value pair to `public_domain_names`.
        ///
        /// To override the contents of this collection use [`set_public_domain_names`](Self::set_public_domain_names).
        ///
        /// <p>The public domain name of the container service, such as <code>example.com</code> and
        /// <code>www.example.com</code>.</p>
        ///
        /// <p>You can specify up to four public domain names for a container service. The domain names
        /// that you specify are used when you create a deployment with a container configured as the
        /// public endpoint of your container service.</p>
        ///
        /// <p>If you don't specify public domain names, then you can use the default domain of the
        /// container service.</p>
        ///
        /// <important>
        /// <p>You must create and validate an SSL/TLS certificate before you can use public domain
        /// names with your container service. Use the <code>CreateCertificate</code> action to create a
        /// certificate for the public domain names you want to use with your container service.</p>
        /// </important>
        ///
        /// <p>See <code>CreateContainerService</code> or <code>UpdateContainerService</code> for
        /// information about how to specify public domain names for your Lightsail container
        /// service.</p>
        pub fn public_domain_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<std::string::String>>,
        ) -> Self {
            let mut hash_map = self.public_domain_names.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.public_domain_names = Some(hash_map);
            self
        }
        /// <p>The public domain name of the container service, such as <code>example.com</code> and
        /// <code>www.example.com</code>.</p>
        ///
        /// <p>You can specify up to four public domain names for a container service. The domain names
        /// that you specify are used when you create a deployment with a container configured as the
        /// public endpoint of your container service.</p>
        ///
        /// <p>If you don't specify public domain names, then you can use the default domain of the
        /// container service.</p>
        ///
        /// <important>
        /// <p>You must create and validate an SSL/TLS certificate before you can use public domain
        /// names with your container service. Use the <code>CreateCertificate</code> action to create a
        /// certificate for the public domain names you want to use with your container service.</p>
        /// </important>
        ///
        /// <p>See <code>CreateContainerService</code> or <code>UpdateContainerService</code> for
        /// information about how to specify public domain names for your Lightsail container
        /// service.</p>
        pub fn set_public_domain_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::vec::Vec<std::string::String>>,
            >,
        ) -> Self {
            self.public_domain_names = input;
            self
        }
        /// <p>The publicly accessible URL of the container service.</p>
        ///
        /// <p>If no public endpoint is specified in the <code>currentDeployment</code>, this URL returns
        /// a 404 response.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The publicly accessible URL of the container service.</p>
        ///
        /// <p>If no public endpoint is specified in the <code>currentDeployment</code>, this URL returns
        /// a 404 response.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`ContainerService`](crate::model::ContainerService)
        pub fn build(self) -> crate::model::ContainerService {
            crate::model::ContainerService {
                container_service_name: self.container_service_name,
                arn: self.arn,
                created_at: self.created_at,
                location: self.location,
                resource_type: self.resource_type,
                tags: self.tags,
                power: self.power,
                power_id: self.power_id,
                state: self.state,
                state_detail: self.state_detail,
                scale: self.scale,
                current_deployment: self.current_deployment,
                next_deployment: self.next_deployment,
                is_disabled: self.is_disabled,
                principal_arn: self.principal_arn,
                private_domain_name: self.private_domain_name,
                public_domain_names: self.public_domain_names,
                url: self.url,
            }
        }
    }
}
impl ContainerService {
    /// Creates a new builder-style object to manufacture [`ContainerService`](crate::model::ContainerService)
    pub fn builder() -> crate::model::container_service::Builder {
        crate::model::container_service::Builder::default()
    }
}

/// <p>Describes a container deployment configuration of an Amazon Lightsail container
/// service.</p>
///
/// <p>A deployment specifies the settings, such as the ports and launch command, of containers
/// that are deployed to your container service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContainerServiceDeployment {
    /// <p>The version number of the deployment.</p>
    pub version: std::option::Option<i32>,
    /// <p>The state of the deployment.</p>
    ///
    /// <p>A deployment can be in one of the following states:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Activating</code> - The deployment is being created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Active</code> - The deployment was successfully created, and it's currently
    /// running on the container service. The container service can have only one deployment in an
    /// active state at a time.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Inactive</code> - The deployment was previously successfully created, but it is
    /// not currently running on the container service.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Failed</code> - The deployment failed. Use the <code>GetContainerLog</code>
    /// action to view the log events for the containers in the deployment to try to determine the
    /// reason for the failure.</p>
    /// </li>
    /// </ul>
    pub state: std::option::Option<crate::model::ContainerServiceDeploymentState>,
    /// <p>An object that describes the configuration for the containers of the deployment.</p>
    pub containers: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::Container>,
    >,
    /// <p>An object that describes the endpoint of the deployment.</p>
    pub public_endpoint: std::option::Option<crate::model::ContainerServiceEndpoint>,
    /// <p>The timestamp when the deployment was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for ContainerServiceDeployment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContainerServiceDeployment");
        formatter.field("version", &self.version);
        formatter.field("state", &self.state);
        formatter.field("containers", &self.containers);
        formatter.field("public_endpoint", &self.public_endpoint);
        formatter.field("created_at", &self.created_at);
        formatter.finish()
    }
}
/// See [`ContainerServiceDeployment`](crate::model::ContainerServiceDeployment)
pub mod container_service_deployment {
    /// A builder for [`ContainerServiceDeployment`](crate::model::ContainerServiceDeployment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version: std::option::Option<i32>,
        pub(crate) state: std::option::Option<crate::model::ContainerServiceDeploymentState>,
        pub(crate) containers: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Container>,
        >,
        pub(crate) public_endpoint: std::option::Option<crate::model::ContainerServiceEndpoint>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The version number of the deployment.</p>
        pub fn version(mut self, input: i32) -> Self {
            self.version = Some(input);
            self
        }
        /// <p>The version number of the deployment.</p>
        pub fn set_version(mut self, input: std::option::Option<i32>) -> Self {
            self.version = input;
            self
        }
        /// <p>The state of the deployment.</p>
        ///
        /// <p>A deployment can be in one of the following states:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Activating</code> - The deployment is being created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Active</code> - The deployment was successfully created, and it's currently
        /// running on the container service. The container service can have only one deployment in an
        /// active state at a time.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Inactive</code> - The deployment was previously successfully created, but it is
        /// not currently running on the container service.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code> - The deployment failed. Use the <code>GetContainerLog</code>
        /// action to view the log events for the containers in the deployment to try to determine the
        /// reason for the failure.</p>
        /// </li>
        /// </ul>
        pub fn state(mut self, input: crate::model::ContainerServiceDeploymentState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the deployment.</p>
        ///
        /// <p>A deployment can be in one of the following states:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Activating</code> - The deployment is being created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Active</code> - The deployment was successfully created, and it's currently
        /// running on the container service. The container service can have only one deployment in an
        /// active state at a time.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Inactive</code> - The deployment was previously successfully created, but it is
        /// not currently running on the container service.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Failed</code> - The deployment failed. Use the <code>GetContainerLog</code>
        /// action to view the log events for the containers in the deployment to try to determine the
        /// reason for the failure.</p>
        /// </li>
        /// </ul>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ContainerServiceDeploymentState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `containers`.
        ///
        /// To override the contents of this collection use [`set_containers`](Self::set_containers).
        ///
        /// <p>An object that describes the configuration for the containers of the deployment.</p>
        pub fn containers(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Container>,
        ) -> Self {
            let mut hash_map = self.containers.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.containers = Some(hash_map);
            self
        }
        /// <p>An object that describes the configuration for the containers of the deployment.</p>
        pub fn set_containers(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Container>,
            >,
        ) -> Self {
            self.containers = input;
            self
        }
        /// <p>An object that describes the endpoint of the deployment.</p>
        pub fn public_endpoint(mut self, input: crate::model::ContainerServiceEndpoint) -> Self {
            self.public_endpoint = Some(input);
            self
        }
        /// <p>An object that describes the endpoint of the deployment.</p>
        pub fn set_public_endpoint(
            mut self,
            input: std::option::Option<crate::model::ContainerServiceEndpoint>,
        ) -> Self {
            self.public_endpoint = input;
            self
        }
        /// <p>The timestamp when the deployment was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when the deployment was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Consumes the builder and constructs a [`ContainerServiceDeployment`](crate::model::ContainerServiceDeployment)
        pub fn build(self) -> crate::model::ContainerServiceDeployment {
            crate::model::ContainerServiceDeployment {
                version: self.version,
                state: self.state,
                containers: self.containers,
                public_endpoint: self.public_endpoint,
                created_at: self.created_at,
            }
        }
    }
}
impl ContainerServiceDeployment {
    /// Creates a new builder-style object to manufacture [`ContainerServiceDeployment`](crate::model::ContainerServiceDeployment)
    pub fn builder() -> crate::model::container_service_deployment::Builder {
        crate::model::container_service_deployment::Builder::default()
    }
}

/// <p>Describes the public endpoint configuration of a deployment of an Amazon Lightsail
/// container service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContainerServiceEndpoint {
    /// <p>The name of the container entry of the deployment that the endpoint configuration applies
    /// to.</p>
    pub container_name: std::option::Option<std::string::String>,
    /// <p>The port of the specified container to which traffic is forwarded to.</p>
    pub container_port: std::option::Option<i32>,
    /// <p>An object that describes the health check configuration of the container.</p>
    pub health_check: std::option::Option<crate::model::ContainerServiceHealthCheckConfig>,
}
impl std::fmt::Debug for ContainerServiceEndpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContainerServiceEndpoint");
        formatter.field("container_name", &self.container_name);
        formatter.field("container_port", &self.container_port);
        formatter.field("health_check", &self.health_check);
        formatter.finish()
    }
}
/// See [`ContainerServiceEndpoint`](crate::model::ContainerServiceEndpoint)
pub mod container_service_endpoint {
    /// A builder for [`ContainerServiceEndpoint`](crate::model::ContainerServiceEndpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_name: std::option::Option<std::string::String>,
        pub(crate) container_port: std::option::Option<i32>,
        pub(crate) health_check:
            std::option::Option<crate::model::ContainerServiceHealthCheckConfig>,
    }
    impl Builder {
        /// <p>The name of the container entry of the deployment that the endpoint configuration applies
        /// to.</p>
        pub fn container_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.container_name = Some(input.into());
            self
        }
        /// <p>The name of the container entry of the deployment that the endpoint configuration applies
        /// to.</p>
        pub fn set_container_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.container_name = input;
            self
        }
        /// <p>The port of the specified container to which traffic is forwarded to.</p>
        pub fn container_port(mut self, input: i32) -> Self {
            self.container_port = Some(input);
            self
        }
        /// <p>The port of the specified container to which traffic is forwarded to.</p>
        pub fn set_container_port(mut self, input: std::option::Option<i32>) -> Self {
            self.container_port = input;
            self
        }
        /// <p>An object that describes the health check configuration of the container.</p>
        pub fn health_check(
            mut self,
            input: crate::model::ContainerServiceHealthCheckConfig,
        ) -> Self {
            self.health_check = Some(input);
            self
        }
        /// <p>An object that describes the health check configuration of the container.</p>
        pub fn set_health_check(
            mut self,
            input: std::option::Option<crate::model::ContainerServiceHealthCheckConfig>,
        ) -> Self {
            self.health_check = input;
            self
        }
        /// Consumes the builder and constructs a [`ContainerServiceEndpoint`](crate::model::ContainerServiceEndpoint)
        pub fn build(self) -> crate::model::ContainerServiceEndpoint {
            crate::model::ContainerServiceEndpoint {
                container_name: self.container_name,
                container_port: self.container_port,
                health_check: self.health_check,
            }
        }
    }
}
impl ContainerServiceEndpoint {
    /// Creates a new builder-style object to manufacture [`ContainerServiceEndpoint`](crate::model::ContainerServiceEndpoint)
    pub fn builder() -> crate::model::container_service_endpoint::Builder {
        crate::model::container_service_endpoint::Builder::default()
    }
}

/// <p>Describes the health check configuration of an Amazon Lightsail container service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContainerServiceHealthCheckConfig {
    /// <p>The number of consecutive health checks successes required before moving the container to
    /// the <code>Healthy</code> state. The default value is <code>2</code>.</p>
    pub healthy_threshold: std::option::Option<i32>,
    /// <p>The number of consecutive health check failures required before moving the container to
    /// the <code>Unhealthy</code> state. The default value is <code>2</code>.</p>
    pub unhealthy_threshold: std::option::Option<i32>,
    /// <p>The amount of time, in seconds, during which no response means a failed health check. You
    /// can specify between 2 and 60 seconds. The default value is <code>2</code>.</p>
    pub timeout_seconds: std::option::Option<i32>,
    /// <p>The approximate interval, in seconds, between health checks of an individual container.
    /// You can specify between 5 and 300 seconds. The default value is <code>5</code>.</p>
    pub interval_seconds: std::option::Option<i32>,
    /// <p>The path on the container on which to perform the health check. The default value is
    /// <code>/</code>.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The HTTP codes to use when checking for a successful response from a container. You can
    /// specify values between <code>200</code> and <code>499</code>. You can specify multiple values
    /// (for example, <code>200,202</code>) or a range of values (for example,
    /// <code>200-299</code>).</p>
    pub success_codes: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ContainerServiceHealthCheckConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContainerServiceHealthCheckConfig");
        formatter.field("healthy_threshold", &self.healthy_threshold);
        formatter.field("unhealthy_threshold", &self.unhealthy_threshold);
        formatter.field("timeout_seconds", &self.timeout_seconds);
        formatter.field("interval_seconds", &self.interval_seconds);
        formatter.field("path", &self.path);
        formatter.field("success_codes", &self.success_codes);
        formatter.finish()
    }
}
/// See [`ContainerServiceHealthCheckConfig`](crate::model::ContainerServiceHealthCheckConfig)
pub mod container_service_health_check_config {
    /// A builder for [`ContainerServiceHealthCheckConfig`](crate::model::ContainerServiceHealthCheckConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) healthy_threshold: std::option::Option<i32>,
        pub(crate) unhealthy_threshold: std::option::Option<i32>,
        pub(crate) timeout_seconds: std::option::Option<i32>,
        pub(crate) interval_seconds: std::option::Option<i32>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) success_codes: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of consecutive health checks successes required before moving the container to
        /// the <code>Healthy</code> state. The default value is <code>2</code>.</p>
        pub fn healthy_threshold(mut self, input: i32) -> Self {
            self.healthy_threshold = Some(input);
            self
        }
        /// <p>The number of consecutive health checks successes required before moving the container to
        /// the <code>Healthy</code> state. The default value is <code>2</code>.</p>
        pub fn set_healthy_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.healthy_threshold = input;
            self
        }
        /// <p>The number of consecutive health check failures required before moving the container to
        /// the <code>Unhealthy</code> state. The default value is <code>2</code>.</p>
        pub fn unhealthy_threshold(mut self, input: i32) -> Self {
            self.unhealthy_threshold = Some(input);
            self
        }
        /// <p>The number of consecutive health check failures required before moving the container to
        /// the <code>Unhealthy</code> state. The default value is <code>2</code>.</p>
        pub fn set_unhealthy_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.unhealthy_threshold = input;
            self
        }
        /// <p>The amount of time, in seconds, during which no response means a failed health check. You
        /// can specify between 2 and 60 seconds. The default value is <code>2</code>.</p>
        pub fn timeout_seconds(mut self, input: i32) -> Self {
            self.timeout_seconds = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, during which no response means a failed health check. You
        /// can specify between 2 and 60 seconds. The default value is <code>2</code>.</p>
        pub fn set_timeout_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.timeout_seconds = input;
            self
        }
        /// <p>The approximate interval, in seconds, between health checks of an individual container.
        /// You can specify between 5 and 300 seconds. The default value is <code>5</code>.</p>
        pub fn interval_seconds(mut self, input: i32) -> Self {
            self.interval_seconds = Some(input);
            self
        }
        /// <p>The approximate interval, in seconds, between health checks of an individual container.
        /// You can specify between 5 and 300 seconds. The default value is <code>5</code>.</p>
        pub fn set_interval_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.interval_seconds = input;
            self
        }
        /// <p>The path on the container on which to perform the health check. The default value is
        /// <code>/</code>.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path on the container on which to perform the health check. The default value is
        /// <code>/</code>.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The HTTP codes to use when checking for a successful response from a container. You can
        /// specify values between <code>200</code> and <code>499</code>. You can specify multiple values
        /// (for example, <code>200,202</code>) or a range of values (for example,
        /// <code>200-299</code>).</p>
        pub fn success_codes(mut self, input: impl Into<std::string::String>) -> Self {
            self.success_codes = Some(input.into());
            self
        }
        /// <p>The HTTP codes to use when checking for a successful response from a container. You can
        /// specify values between <code>200</code> and <code>499</code>. You can specify multiple values
        /// (for example, <code>200,202</code>) or a range of values (for example,
        /// <code>200-299</code>).</p>
        pub fn set_success_codes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.success_codes = input;
            self
        }
        /// Consumes the builder and constructs a [`ContainerServiceHealthCheckConfig`](crate::model::ContainerServiceHealthCheckConfig)
        pub fn build(self) -> crate::model::ContainerServiceHealthCheckConfig {
            crate::model::ContainerServiceHealthCheckConfig {
                healthy_threshold: self.healthy_threshold,
                unhealthy_threshold: self.unhealthy_threshold,
                timeout_seconds: self.timeout_seconds,
                interval_seconds: self.interval_seconds,
                path: self.path,
                success_codes: self.success_codes,
            }
        }
    }
}
impl ContainerServiceHealthCheckConfig {
    /// Creates a new builder-style object to manufacture [`ContainerServiceHealthCheckConfig`](crate::model::ContainerServiceHealthCheckConfig)
    pub fn builder() -> crate::model::container_service_health_check_config::Builder {
        crate::model::container_service_health_check_config::Builder::default()
    }
}

/// <p>Describes the settings of a container that will be launched, or that is launched, to an
/// Amazon Lightsail container service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Container {
    /// <p>The name of the image used for the container.</p>
    ///
    /// <p>Container images sourced from your Lightsail container service, that are registered and
    /// stored on your service, start with a colon (<code>:</code>). For example, if your container
    /// service name is <code>container-service-1</code>, the container image label is
    /// <code>mystaticsite</code>, and you want to use the third (<code>3</code>) version of the
    /// registered container image, then you should specify
    /// <code>:container-service-1.mystaticsite.3</code>. To use the latest version of a container
    /// image, specify <code>latest</code> instead of a version number (for example,
    /// <code>:container-service-1.mystaticsite.latest</code>). Lightsail will automatically use
    /// the highest numbered version of the registered container image.</p>
    ///
    /// <p>Container images sourced from a public registry like Docker Hub don't start with a colon.
    /// For example, <code>nginx:latest</code> or <code>nginx</code>.</p>
    pub image: std::option::Option<std::string::String>,
    /// <p>The launch command for the container.</p>
    pub command: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The environment variables of the container.</p>
    pub environment:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The open firewall ports of the container.</p>
    pub ports: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ContainerServiceProtocol>,
    >,
}
impl std::fmt::Debug for Container {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Container");
        formatter.field("image", &self.image);
        formatter.field("command", &self.command);
        formatter.field("environment", &self.environment);
        formatter.field("ports", &self.ports);
        formatter.finish()
    }
}
/// See [`Container`](crate::model::Container)
pub mod container {
    /// A builder for [`Container`](crate::model::Container)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image: std::option::Option<std::string::String>,
        pub(crate) command: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) environment: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) ports: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ContainerServiceProtocol>,
        >,
    }
    impl Builder {
        /// <p>The name of the image used for the container.</p>
        ///
        /// <p>Container images sourced from your Lightsail container service, that are registered and
        /// stored on your service, start with a colon (<code>:</code>). For example, if your container
        /// service name is <code>container-service-1</code>, the container image label is
        /// <code>mystaticsite</code>, and you want to use the third (<code>3</code>) version of the
        /// registered container image, then you should specify
        /// <code>:container-service-1.mystaticsite.3</code>. To use the latest version of a container
        /// image, specify <code>latest</code> instead of a version number (for example,
        /// <code>:container-service-1.mystaticsite.latest</code>). Lightsail will automatically use
        /// the highest numbered version of the registered container image.</p>
        ///
        /// <p>Container images sourced from a public registry like Docker Hub don't start with a colon.
        /// For example, <code>nginx:latest</code> or <code>nginx</code>.</p>
        pub fn image(mut self, input: impl Into<std::string::String>) -> Self {
            self.image = Some(input.into());
            self
        }
        /// <p>The name of the image used for the container.</p>
        ///
        /// <p>Container images sourced from your Lightsail container service, that are registered and
        /// stored on your service, start with a colon (<code>:</code>). For example, if your container
        /// service name is <code>container-service-1</code>, the container image label is
        /// <code>mystaticsite</code>, and you want to use the third (<code>3</code>) version of the
        /// registered container image, then you should specify
        /// <code>:container-service-1.mystaticsite.3</code>. To use the latest version of a container
        /// image, specify <code>latest</code> instead of a version number (for example,
        /// <code>:container-service-1.mystaticsite.latest</code>). Lightsail will automatically use
        /// the highest numbered version of the registered container image.</p>
        ///
        /// <p>Container images sourced from a public registry like Docker Hub don't start with a colon.
        /// For example, <code>nginx:latest</code> or <code>nginx</code>.</p>
        pub fn set_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image = input;
            self
        }
        /// Appends an item to `command`.
        ///
        /// To override the contents of this collection use [`set_command`](Self::set_command).
        ///
        /// <p>The launch command for the container.</p>
        pub fn command(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.command.unwrap_or_default();
            v.push(input.into());
            self.command = Some(v);
            self
        }
        /// <p>The launch command for the container.</p>
        pub fn set_command(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.command = input;
            self
        }
        /// Adds a key-value pair to `environment`.
        ///
        /// To override the contents of this collection use [`set_environment`](Self::set_environment).
        ///
        /// <p>The environment variables of the container.</p>
        pub fn environment(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.environment.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.environment = Some(hash_map);
            self
        }
        /// <p>The environment variables of the container.</p>
        pub fn set_environment(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.environment = input;
            self
        }
        /// Adds a key-value pair to `ports`.
        ///
        /// To override the contents of this collection use [`set_ports`](Self::set_ports).
        ///
        /// <p>The open firewall ports of the container.</p>
        pub fn ports(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ContainerServiceProtocol>,
        ) -> Self {
            let mut hash_map = self.ports.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.ports = Some(hash_map);
            self
        }
        /// <p>The open firewall ports of the container.</p>
        pub fn set_ports(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::ContainerServiceProtocol,
                >,
            >,
        ) -> Self {
            self.ports = input;
            self
        }
        /// Consumes the builder and constructs a [`Container`](crate::model::Container)
        pub fn build(self) -> crate::model::Container {
            crate::model::Container {
                image: self.image,
                command: self.command,
                environment: self.environment,
                ports: self.ports,
            }
        }
    }
}
impl Container {
    /// Creates a new builder-style object to manufacture [`Container`](crate::model::Container)
    pub fn builder() -> crate::model::container::Builder {
        crate::model::container::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContainerServiceProtocol {
    #[allow(missing_docs)] // documentation missing in model
    Http,
    #[allow(missing_docs)] // documentation missing in model
    Https,
    #[allow(missing_docs)] // documentation missing in model
    Tcp,
    #[allow(missing_docs)] // documentation missing in model
    Udp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContainerServiceProtocol {
    fn from(s: &str) -> Self {
        match s {
            "HTTP" => ContainerServiceProtocol::Http,
            "HTTPS" => ContainerServiceProtocol::Https,
            "TCP" => ContainerServiceProtocol::Tcp,
            "UDP" => ContainerServiceProtocol::Udp,
            other => ContainerServiceProtocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContainerServiceProtocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContainerServiceProtocol::from(s))
    }
}
impl ContainerServiceProtocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContainerServiceProtocol::Http => "HTTP",
            ContainerServiceProtocol::Https => "HTTPS",
            ContainerServiceProtocol::Tcp => "TCP",
            ContainerServiceProtocol::Udp => "UDP",
            ContainerServiceProtocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HTTP", "HTTPS", "TCP", "UDP"]
    }
}
impl AsRef<str> for ContainerServiceProtocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContainerServiceDeploymentState {
    #[allow(missing_docs)] // documentation missing in model
    Activating,
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContainerServiceDeploymentState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVATING" => ContainerServiceDeploymentState::Activating,
            "ACTIVE" => ContainerServiceDeploymentState::Active,
            "FAILED" => ContainerServiceDeploymentState::Failed,
            "INACTIVE" => ContainerServiceDeploymentState::Inactive,
            other => ContainerServiceDeploymentState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContainerServiceDeploymentState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContainerServiceDeploymentState::from(s))
    }
}
impl ContainerServiceDeploymentState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContainerServiceDeploymentState::Activating => "ACTIVATING",
            ContainerServiceDeploymentState::Active => "ACTIVE",
            ContainerServiceDeploymentState::Failed => "FAILED",
            ContainerServiceDeploymentState::Inactive => "INACTIVE",
            ContainerServiceDeploymentState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVATING", "ACTIVE", "FAILED", "INACTIVE"]
    }
}
impl AsRef<str> for ContainerServiceDeploymentState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the current state of a container service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContainerServiceStateDetail {
    /// <p>The state code of the container service.</p>
    /// <p>The following state codes are possible:</p>
    /// <ul>
    /// <li>
    /// <p>The following state codes are possible if your container service is in a
    /// <code>DEPLOYING</code> or <code>UPDATING</code> state:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATING_SYSTEM_RESOURCES</code> - The system resources for your container
    /// service are being created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATING_NETWORK_INFRASTRUCTURE</code> - The network infrastructure for your
    /// container service are being created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PROVISIONING_CERTIFICATE</code> - The SSL/TLS certificate for your container
    /// service is being created.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PROVISIONING_SERVICE</code> - Your container service is being
    /// provisioned.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATING_DEPLOYMENT</code> - Your deployment is being created on your
    /// container service.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EVALUATING_HEALTH_CHECK</code> - The health of your deployment is being
    /// evaluated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTIVATING_DEPLOYMENT</code> - Your deployment is being activated.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>The following state codes are possible if your container service is in a
    /// <code>PENDING</code> state:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CERTIFICATE_LIMIT_EXCEEDED</code> - The SSL/TLS certificate required for
    /// your container service exceeds the maximum number of certificates allowed for your
    /// account.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UNKNOWN_ERROR</code> - An error was experienced when your container service
    /// was being created.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// </ul>
    pub code: std::option::Option<crate::model::ContainerServiceStateDetailCode>,
    /// <p>A message that provides more information for the state code.</p>
    /// <note>
    /// <p>The state detail is populated only when a container service is in a
    /// <code>PENDING</code>, <code>DEPLOYING</code>, or <code>UPDATING</code> state.</p>
    /// </note>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ContainerServiceStateDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContainerServiceStateDetail");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ContainerServiceStateDetail`](crate::model::ContainerServiceStateDetail)
pub mod container_service_state_detail {
    /// A builder for [`ContainerServiceStateDetail`](crate::model::ContainerServiceStateDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::ContainerServiceStateDetailCode>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The state code of the container service.</p>
        /// <p>The following state codes are possible:</p>
        /// <ul>
        /// <li>
        /// <p>The following state codes are possible if your container service is in a
        /// <code>DEPLOYING</code> or <code>UPDATING</code> state:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING_SYSTEM_RESOURCES</code> - The system resources for your container
        /// service are being created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATING_NETWORK_INFRASTRUCTURE</code> - The network infrastructure for your
        /// container service are being created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PROVISIONING_CERTIFICATE</code> - The SSL/TLS certificate for your container
        /// service is being created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PROVISIONING_SERVICE</code> - Your container service is being
        /// provisioned.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATING_DEPLOYMENT</code> - Your deployment is being created on your
        /// container service.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EVALUATING_HEALTH_CHECK</code> - The health of your deployment is being
        /// evaluated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVATING_DEPLOYMENT</code> - Your deployment is being activated.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>The following state codes are possible if your container service is in a
        /// <code>PENDING</code> state:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CERTIFICATE_LIMIT_EXCEEDED</code> - The SSL/TLS certificate required for
        /// your container service exceeds the maximum number of certificates allowed for your
        /// account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UNKNOWN_ERROR</code> - An error was experienced when your container service
        /// was being created.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn code(mut self, input: crate::model::ContainerServiceStateDetailCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The state code of the container service.</p>
        /// <p>The following state codes are possible:</p>
        /// <ul>
        /// <li>
        /// <p>The following state codes are possible if your container service is in a
        /// <code>DEPLOYING</code> or <code>UPDATING</code> state:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING_SYSTEM_RESOURCES</code> - The system resources for your container
        /// service are being created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATING_NETWORK_INFRASTRUCTURE</code> - The network infrastructure for your
        /// container service are being created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PROVISIONING_CERTIFICATE</code> - The SSL/TLS certificate for your container
        /// service is being created.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PROVISIONING_SERVICE</code> - Your container service is being
        /// provisioned.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATING_DEPLOYMENT</code> - Your deployment is being created on your
        /// container service.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EVALUATING_HEALTH_CHECK</code> - The health of your deployment is being
        /// evaluated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTIVATING_DEPLOYMENT</code> - Your deployment is being activated.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>The following state codes are possible if your container service is in a
        /// <code>PENDING</code> state:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CERTIFICATE_LIMIT_EXCEEDED</code> - The SSL/TLS certificate required for
        /// your container service exceeds the maximum number of certificates allowed for your
        /// account.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UNKNOWN_ERROR</code> - An error was experienced when your container service
        /// was being created.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::ContainerServiceStateDetailCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// <p>A message that provides more information for the state code.</p>
        /// <note>
        /// <p>The state detail is populated only when a container service is in a
        /// <code>PENDING</code>, <code>DEPLOYING</code>, or <code>UPDATING</code> state.</p>
        /// </note>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that provides more information for the state code.</p>
        /// <note>
        /// <p>The state detail is populated only when a container service is in a
        /// <code>PENDING</code>, <code>DEPLOYING</code>, or <code>UPDATING</code> state.</p>
        /// </note>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ContainerServiceStateDetail`](crate::model::ContainerServiceStateDetail)
        pub fn build(self) -> crate::model::ContainerServiceStateDetail {
            crate::model::ContainerServiceStateDetail {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl ContainerServiceStateDetail {
    /// Creates a new builder-style object to manufacture [`ContainerServiceStateDetail`](crate::model::ContainerServiceStateDetail)
    pub fn builder() -> crate::model::container_service_state_detail::Builder {
        crate::model::container_service_state_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContainerServiceStateDetailCode {
    #[allow(missing_docs)] // documentation missing in model
    ActivatingDeployment,
    #[allow(missing_docs)] // documentation missing in model
    CertificateLimitExceeded,
    #[allow(missing_docs)] // documentation missing in model
    CreatingDeployment,
    #[allow(missing_docs)] // documentation missing in model
    CreatingNetworkInfrastructure,
    #[allow(missing_docs)] // documentation missing in model
    CreatingSystemResources,
    #[allow(missing_docs)] // documentation missing in model
    EvaluatingHealthCheck,
    #[allow(missing_docs)] // documentation missing in model
    ProvisioningCertificate,
    #[allow(missing_docs)] // documentation missing in model
    ProvisioningService,
    #[allow(missing_docs)] // documentation missing in model
    UnknownError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContainerServiceStateDetailCode {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVATING_DEPLOYMENT" => ContainerServiceStateDetailCode::ActivatingDeployment,
            "CERTIFICATE_LIMIT_EXCEEDED" => {
                ContainerServiceStateDetailCode::CertificateLimitExceeded
            }
            "CREATING_DEPLOYMENT" => ContainerServiceStateDetailCode::CreatingDeployment,
            "CREATING_NETWORK_INFRASTRUCTURE" => {
                ContainerServiceStateDetailCode::CreatingNetworkInfrastructure
            }
            "CREATING_SYSTEM_RESOURCES" => ContainerServiceStateDetailCode::CreatingSystemResources,
            "EVALUATING_HEALTH_CHECK" => ContainerServiceStateDetailCode::EvaluatingHealthCheck,
            "PROVISIONING_CERTIFICATE" => ContainerServiceStateDetailCode::ProvisioningCertificate,
            "PROVISIONING_SERVICE" => ContainerServiceStateDetailCode::ProvisioningService,
            "UNKNOWN_ERROR" => ContainerServiceStateDetailCode::UnknownError,
            other => ContainerServiceStateDetailCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContainerServiceStateDetailCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContainerServiceStateDetailCode::from(s))
    }
}
impl ContainerServiceStateDetailCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContainerServiceStateDetailCode::ActivatingDeployment => "ACTIVATING_DEPLOYMENT",
            ContainerServiceStateDetailCode::CertificateLimitExceeded => {
                "CERTIFICATE_LIMIT_EXCEEDED"
            }
            ContainerServiceStateDetailCode::CreatingDeployment => "CREATING_DEPLOYMENT",
            ContainerServiceStateDetailCode::CreatingNetworkInfrastructure => {
                "CREATING_NETWORK_INFRASTRUCTURE"
            }
            ContainerServiceStateDetailCode::CreatingSystemResources => "CREATING_SYSTEM_RESOURCES",
            ContainerServiceStateDetailCode::EvaluatingHealthCheck => "EVALUATING_HEALTH_CHECK",
            ContainerServiceStateDetailCode::ProvisioningCertificate => "PROVISIONING_CERTIFICATE",
            ContainerServiceStateDetailCode::ProvisioningService => "PROVISIONING_SERVICE",
            ContainerServiceStateDetailCode::UnknownError => "UNKNOWN_ERROR",
            ContainerServiceStateDetailCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVATING_DEPLOYMENT",
            "CERTIFICATE_LIMIT_EXCEEDED",
            "CREATING_DEPLOYMENT",
            "CREATING_NETWORK_INFRASTRUCTURE",
            "CREATING_SYSTEM_RESOURCES",
            "EVALUATING_HEALTH_CHECK",
            "PROVISIONING_CERTIFICATE",
            "PROVISIONING_SERVICE",
            "UNKNOWN_ERROR",
        ]
    }
}
impl AsRef<str> for ContainerServiceStateDetailCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContainerServiceState {
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Deploying,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Ready,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContainerServiceState {
    fn from(s: &str) -> Self {
        match s {
            "DELETING" => ContainerServiceState::Deleting,
            "DEPLOYING" => ContainerServiceState::Deploying,
            "DISABLED" => ContainerServiceState::Disabled,
            "PENDING" => ContainerServiceState::Pending,
            "READY" => ContainerServiceState::Ready,
            "RUNNING" => ContainerServiceState::Running,
            "UPDATING" => ContainerServiceState::Updating,
            other => ContainerServiceState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContainerServiceState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContainerServiceState::from(s))
    }
}
impl ContainerServiceState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContainerServiceState::Deleting => "DELETING",
            ContainerServiceState::Deploying => "DEPLOYING",
            ContainerServiceState::Disabled => "DISABLED",
            ContainerServiceState::Pending => "PENDING",
            ContainerServiceState::Ready => "READY",
            ContainerServiceState::Running => "RUNNING",
            ContainerServiceState::Updating => "UPDATING",
            ContainerServiceState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DELETING",
            "DEPLOYING",
            "DISABLED",
            "PENDING",
            "READY",
            "RUNNING",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for ContainerServiceState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContainerServicePowerName {
    #[allow(missing_docs)] // documentation missing in model
    Large,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    #[allow(missing_docs)] // documentation missing in model
    Micro,
    #[allow(missing_docs)] // documentation missing in model
    Nano,
    #[allow(missing_docs)] // documentation missing in model
    Small,
    #[allow(missing_docs)] // documentation missing in model
    Xlarge,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContainerServicePowerName {
    fn from(s: &str) -> Self {
        match s {
            "large" => ContainerServicePowerName::Large,
            "medium" => ContainerServicePowerName::Medium,
            "micro" => ContainerServicePowerName::Micro,
            "nano" => ContainerServicePowerName::Nano,
            "small" => ContainerServicePowerName::Small,
            "xlarge" => ContainerServicePowerName::Xlarge,
            other => ContainerServicePowerName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContainerServicePowerName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContainerServicePowerName::from(s))
    }
}
impl ContainerServicePowerName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContainerServicePowerName::Large => "large",
            ContainerServicePowerName::Medium => "medium",
            ContainerServicePowerName::Micro => "micro",
            ContainerServicePowerName::Nano => "nano",
            ContainerServicePowerName::Small => "small",
            ContainerServicePowerName::Xlarge => "xlarge",
            ContainerServicePowerName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["large", "medium", "micro", "nano", "small", "xlarge"]
    }
}
impl AsRef<str> for ContainerServicePowerName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a tag key and optional value assigned to an Amazon Lightsail resource.</p>
/// <p>For more information about tags in Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key of the tag.</p>
    /// <p>Constraints: Tag keys accept a maximum of 128 letters, numbers, spaces in UTF-8, or the
    /// following characters: + - = . _ : / @</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of the tag.</p>
    /// <p>Constraints: Tag values accept a maximum of 256 letters, numbers, spaces in UTF-8, or the
    /// following characters: + - = . _ : / @</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key of the tag.</p>
        /// <p>Constraints: Tag keys accept a maximum of 128 letters, numbers, spaces in UTF-8, or the
        /// following characters: + - = . _ : / @</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key of the tag.</p>
        /// <p>Constraints: Tag keys accept a maximum of 128 letters, numbers, spaces in UTF-8, or the
        /// following characters: + - = . _ : / @</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of the tag.</p>
        /// <p>Constraints: Tag values accept a maximum of 256 letters, numbers, spaces in UTF-8, or the
        /// following characters: + - = . _ : / @</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of the tag.</p>
        /// <p>Constraints: Tag values accept a maximum of 256 letters, numbers, spaces in UTF-8, or the
        /// following characters: + - = . _ : / @</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Describes an Amazon Lightsail bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Bucket {
    /// <p>The Lightsail resource type of the bucket (for example, <code>Bucket</code>).</p>
    pub resource_type: std::option::Option<std::string::String>,
    /// <p>An object that describes the access rules of the bucket.</p>
    pub access_rules: std::option::Option<crate::model::AccessRules>,
    /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The ID of the bundle currently applied to the bucket.</p>
    ///
    /// <p>A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a
    /// bucket.</p>
    ///
    /// <p>Use the <a>UpdateBucketBundle</a> action to change the bundle of a
    /// bucket.</p>
    pub bundle_id: std::option::Option<std::string::String>,
    /// <p>The timestamp when the distribution was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The URL of the bucket.</p>
    pub url: std::option::Option<std::string::String>,
    /// <p>Describes the resource location.</p>
    pub location: std::option::Option<crate::model::ResourceLocation>,
    /// <p>The name of the bucket.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The support code for a bucket. Include this code in your email to support when you have
    /// questions about a Lightsail bucket. This code enables our support team to look up your
    /// Lightsail information more easily.</p>
    pub support_code: std::option::Option<std::string::String>,
    /// <p>The tag keys and optional values for the bucket. For more information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Tags in
    /// Amazon Lightsail</a> in the <i>Amazon Lightsail Developer Guide</i>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Indicates whether object versioning is enabled for the bucket.</p>
    ///
    /// <p>The following options can be configured:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Enabled</code> - Object versioning is enabled.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Suspended</code> - Object versioning was previously enabled but is currently
    /// suspended. Existing object versions are retained.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>NeverEnabled</code> - Object versioning has never been enabled.</p>
    /// </li>
    /// </ul>
    pub object_versioning: std::option::Option<std::string::String>,
    /// <p>Indicates whether the bundle that is currently applied to a bucket can be changed to
    /// another bundle.</p>
    ///
    /// <p>You can update a bucket's bundle only one time within a monthly AWS billing
    /// cycle.</p>
    ///
    /// <p>Use the <a>UpdateBucketBundle</a> action to change a bucket's bundle.</p>
    pub able_to_update_bundle: std::option::Option<bool>,
    /// <p>An array of strings that specify the AWS account IDs that have read-only access to the
    /// bucket.</p>
    pub readonly_access_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of objects that describe Lightsail instances that have access to the
    /// bucket.</p>
    ///
    /// <p>Use the <a>SetResourceAccessForBucket</a> action to update the instances that
    /// have access to a bucket.</p>
    pub resources_receiving_access:
        std::option::Option<std::vec::Vec<crate::model::ResourceReceivingAccess>>,
    /// <p>An object that describes the state of the bucket.</p>
    pub state: std::option::Option<crate::model::BucketState>,
    /// <p>An object that describes the access log configuration for the bucket.</p>
    pub access_log_config: std::option::Option<crate::model::BucketAccessLogConfig>,
}
impl std::fmt::Debug for Bucket {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Bucket");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("access_rules", &self.access_rules);
        formatter.field("arn", &self.arn);
        formatter.field("bundle_id", &self.bundle_id);
        formatter.field("created_at", &self.created_at);
        formatter.field("url", &self.url);
        formatter.field("location", &self.location);
        formatter.field("name", &self.name);
        formatter.field("support_code", &self.support_code);
        formatter.field("tags", &self.tags);
        formatter.field("object_versioning", &self.object_versioning);
        formatter.field("able_to_update_bundle", &self.able_to_update_bundle);
        formatter.field("readonly_access_accounts", &self.readonly_access_accounts);
        formatter.field(
            "resources_receiving_access",
            &self.resources_receiving_access,
        );
        formatter.field("state", &self.state);
        formatter.field("access_log_config", &self.access_log_config);
        formatter.finish()
    }
}
/// See [`Bucket`](crate::model::Bucket)
pub mod bucket {
    /// A builder for [`Bucket`](crate::model::Bucket)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<std::string::String>,
        pub(crate) access_rules: std::option::Option<crate::model::AccessRules>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) bundle_id: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) location: std::option::Option<crate::model::ResourceLocation>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) support_code: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) object_versioning: std::option::Option<std::string::String>,
        pub(crate) able_to_update_bundle: std::option::Option<bool>,
        pub(crate) readonly_access_accounts:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resources_receiving_access:
            std::option::Option<std::vec::Vec<crate::model::ResourceReceivingAccess>>,
        pub(crate) state: std::option::Option<crate::model::BucketState>,
        pub(crate) access_log_config: std::option::Option<crate::model::BucketAccessLogConfig>,
    }
    impl Builder {
        /// <p>The Lightsail resource type of the bucket (for example, <code>Bucket</code>).</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The Lightsail resource type of the bucket (for example, <code>Bucket</code>).</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>An object that describes the access rules of the bucket.</p>
        pub fn access_rules(mut self, input: crate::model::AccessRules) -> Self {
            self.access_rules = Some(input);
            self
        }
        /// <p>An object that describes the access rules of the bucket.</p>
        pub fn set_access_rules(
            mut self,
            input: std::option::Option<crate::model::AccessRules>,
        ) -> Self {
            self.access_rules = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The ID of the bundle currently applied to the bucket.</p>
        ///
        /// <p>A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a
        /// bucket.</p>
        ///
        /// <p>Use the <a>UpdateBucketBundle</a> action to change the bundle of a
        /// bucket.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_id = Some(input.into());
            self
        }
        /// <p>The ID of the bundle currently applied to the bucket.</p>
        ///
        /// <p>A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a
        /// bucket.</p>
        ///
        /// <p>Use the <a>UpdateBucketBundle</a> action to change the bundle of a
        /// bucket.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_id = input;
            self
        }
        /// <p>The timestamp when the distribution was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when the distribution was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The URL of the bucket.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>The URL of the bucket.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// <p>Describes the resource location.</p>
        pub fn location(mut self, input: crate::model::ResourceLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>Describes the resource location.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::ResourceLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>The name of the bucket.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the bucket.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The support code for a bucket. Include this code in your email to support when you have
        /// questions about a Lightsail bucket. This code enables our support team to look up your
        /// Lightsail information more easily.</p>
        pub fn support_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_code = Some(input.into());
            self
        }
        /// <p>The support code for a bucket. Include this code in your email to support when you have
        /// questions about a Lightsail bucket. This code enables our support team to look up your
        /// Lightsail information more easily.</p>
        pub fn set_support_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.support_code = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values for the bucket. For more information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Tags in
        /// Amazon Lightsail</a> in the <i>Amazon Lightsail Developer Guide</i>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values for the bucket. For more information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Tags in
        /// Amazon Lightsail</a> in the <i>Amazon Lightsail Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Indicates whether object versioning is enabled for the bucket.</p>
        ///
        /// <p>The following options can be configured:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Enabled</code> - Object versioning is enabled.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Suspended</code> - Object versioning was previously enabled but is currently
        /// suspended. Existing object versions are retained.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NeverEnabled</code> - Object versioning has never been enabled.</p>
        /// </li>
        /// </ul>
        pub fn object_versioning(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_versioning = Some(input.into());
            self
        }
        /// <p>Indicates whether object versioning is enabled for the bucket.</p>
        ///
        /// <p>The following options can be configured:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Enabled</code> - Object versioning is enabled.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Suspended</code> - Object versioning was previously enabled but is currently
        /// suspended. Existing object versions are retained.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>NeverEnabled</code> - Object versioning has never been enabled.</p>
        /// </li>
        /// </ul>
        pub fn set_object_versioning(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_versioning = input;
            self
        }
        /// <p>Indicates whether the bundle that is currently applied to a bucket can be changed to
        /// another bundle.</p>
        ///
        /// <p>You can update a bucket's bundle only one time within a monthly AWS billing
        /// cycle.</p>
        ///
        /// <p>Use the <a>UpdateBucketBundle</a> action to change a bucket's bundle.</p>
        pub fn able_to_update_bundle(mut self, input: bool) -> Self {
            self.able_to_update_bundle = Some(input);
            self
        }
        /// <p>Indicates whether the bundle that is currently applied to a bucket can be changed to
        /// another bundle.</p>
        ///
        /// <p>You can update a bucket's bundle only one time within a monthly AWS billing
        /// cycle.</p>
        ///
        /// <p>Use the <a>UpdateBucketBundle</a> action to change a bucket's bundle.</p>
        pub fn set_able_to_update_bundle(mut self, input: std::option::Option<bool>) -> Self {
            self.able_to_update_bundle = input;
            self
        }
        /// Appends an item to `readonly_access_accounts`.
        ///
        /// To override the contents of this collection use [`set_readonly_access_accounts`](Self::set_readonly_access_accounts).
        ///
        /// <p>An array of strings that specify the AWS account IDs that have read-only access to the
        /// bucket.</p>
        pub fn readonly_access_accounts(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.readonly_access_accounts.unwrap_or_default();
            v.push(input.into());
            self.readonly_access_accounts = Some(v);
            self
        }
        /// <p>An array of strings that specify the AWS account IDs that have read-only access to the
        /// bucket.</p>
        pub fn set_readonly_access_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.readonly_access_accounts = input;
            self
        }
        /// Appends an item to `resources_receiving_access`.
        ///
        /// To override the contents of this collection use [`set_resources_receiving_access`](Self::set_resources_receiving_access).
        ///
        /// <p>An array of objects that describe Lightsail instances that have access to the
        /// bucket.</p>
        ///
        /// <p>Use the <a>SetResourceAccessForBucket</a> action to update the instances that
        /// have access to a bucket.</p>
        pub fn resources_receiving_access(
            mut self,
            input: impl Into<crate::model::ResourceReceivingAccess>,
        ) -> Self {
            let mut v = self.resources_receiving_access.unwrap_or_default();
            v.push(input.into());
            self.resources_receiving_access = Some(v);
            self
        }
        /// <p>An array of objects that describe Lightsail instances that have access to the
        /// bucket.</p>
        ///
        /// <p>Use the <a>SetResourceAccessForBucket</a> action to update the instances that
        /// have access to a bucket.</p>
        pub fn set_resources_receiving_access(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResourceReceivingAccess>>,
        ) -> Self {
            self.resources_receiving_access = input;
            self
        }
        /// <p>An object that describes the state of the bucket.</p>
        pub fn state(mut self, input: crate::model::BucketState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>An object that describes the state of the bucket.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::BucketState>) -> Self {
            self.state = input;
            self
        }
        /// <p>An object that describes the access log configuration for the bucket.</p>
        pub fn access_log_config(mut self, input: crate::model::BucketAccessLogConfig) -> Self {
            self.access_log_config = Some(input);
            self
        }
        /// <p>An object that describes the access log configuration for the bucket.</p>
        pub fn set_access_log_config(
            mut self,
            input: std::option::Option<crate::model::BucketAccessLogConfig>,
        ) -> Self {
            self.access_log_config = input;
            self
        }
        /// Consumes the builder and constructs a [`Bucket`](crate::model::Bucket)
        pub fn build(self) -> crate::model::Bucket {
            crate::model::Bucket {
                resource_type: self.resource_type,
                access_rules: self.access_rules,
                arn: self.arn,
                bundle_id: self.bundle_id,
                created_at: self.created_at,
                url: self.url,
                location: self.location,
                name: self.name,
                support_code: self.support_code,
                tags: self.tags,
                object_versioning: self.object_versioning,
                able_to_update_bundle: self.able_to_update_bundle,
                readonly_access_accounts: self.readonly_access_accounts,
                resources_receiving_access: self.resources_receiving_access,
                state: self.state,
                access_log_config: self.access_log_config,
            }
        }
    }
}
impl Bucket {
    /// Creates a new builder-style object to manufacture [`Bucket`](crate::model::Bucket)
    pub fn builder() -> crate::model::bucket::Builder {
        crate::model::bucket::Builder::default()
    }
}

/// <p>Describes the access log configuration for a bucket in the Amazon Lightsail object storage
/// service.</p>
/// <p>For more information about bucket access logs, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-bucket-access-logs">Logging bucket requests using access logging in Amazon Lightsail</a> in the
/// <i>Amazon Lightsail Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BucketAccessLogConfig {
    /// <p>A Boolean value that indicates whether bucket access logging is enabled for the
    /// bucket.</p>
    pub enabled: std::option::Option<bool>,
    /// <p>The name of the bucket where the access is saved. The destination can be a Lightsail
    /// bucket in the same account, and in the same AWS Region as the source bucket.</p>
    /// <note>
    /// <p>This parameter is required when enabling the access log for a bucket, and should be
    /// omitted when disabling the access log.</p>
    /// </note>
    pub destination: std::option::Option<std::string::String>,
    /// <p>The optional object prefix for the bucket access log.</p>
    /// <p>The prefix is an optional addition to the object key that organizes your access log files
    /// in the destination bucket. For example, if you specify a <code>logs/</code> prefix, then each
    /// log object will begin with the <code>logs/</code> prefix in its key (for example,
    /// <code>logs/2021-11-01-21-32-16-E568B2907131C0C0</code>).</p>
    /// <note>
    /// <p>This parameter can be optionally specified when enabling the access log for a bucket,
    /// and should be omitted when disabling the access log.</p>
    /// </note>
    pub prefix: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BucketAccessLogConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BucketAccessLogConfig");
        formatter.field("enabled", &self.enabled);
        formatter.field("destination", &self.destination);
        formatter.field("prefix", &self.prefix);
        formatter.finish()
    }
}
/// See [`BucketAccessLogConfig`](crate::model::BucketAccessLogConfig)
pub mod bucket_access_log_config {
    /// A builder for [`BucketAccessLogConfig`](crate::model::BucketAccessLogConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) destination: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A Boolean value that indicates whether bucket access logging is enabled for the
        /// bucket.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>A Boolean value that indicates whether bucket access logging is enabled for the
        /// bucket.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The name of the bucket where the access is saved. The destination can be a Lightsail
        /// bucket in the same account, and in the same AWS Region as the source bucket.</p>
        /// <note>
        /// <p>This parameter is required when enabling the access log for a bucket, and should be
        /// omitted when disabling the access log.</p>
        /// </note>
        pub fn destination(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination = Some(input.into());
            self
        }
        /// <p>The name of the bucket where the access is saved. The destination can be a Lightsail
        /// bucket in the same account, and in the same AWS Region as the source bucket.</p>
        /// <note>
        /// <p>This parameter is required when enabling the access log for a bucket, and should be
        /// omitted when disabling the access log.</p>
        /// </note>
        pub fn set_destination(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.destination = input;
            self
        }
        /// <p>The optional object prefix for the bucket access log.</p>
        /// <p>The prefix is an optional addition to the object key that organizes your access log files
        /// in the destination bucket. For example, if you specify a <code>logs/</code> prefix, then each
        /// log object will begin with the <code>logs/</code> prefix in its key (for example,
        /// <code>logs/2021-11-01-21-32-16-E568B2907131C0C0</code>).</p>
        /// <note>
        /// <p>This parameter can be optionally specified when enabling the access log for a bucket,
        /// and should be omitted when disabling the access log.</p>
        /// </note>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The optional object prefix for the bucket access log.</p>
        /// <p>The prefix is an optional addition to the object key that organizes your access log files
        /// in the destination bucket. For example, if you specify a <code>logs/</code> prefix, then each
        /// log object will begin with the <code>logs/</code> prefix in its key (for example,
        /// <code>logs/2021-11-01-21-32-16-E568B2907131C0C0</code>).</p>
        /// <note>
        /// <p>This parameter can be optionally specified when enabling the access log for a bucket,
        /// and should be omitted when disabling the access log.</p>
        /// </note>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`BucketAccessLogConfig`](crate::model::BucketAccessLogConfig)
        pub fn build(self) -> crate::model::BucketAccessLogConfig {
            crate::model::BucketAccessLogConfig {
                enabled: self.enabled,
                destination: self.destination,
                prefix: self.prefix,
            }
        }
    }
}
impl BucketAccessLogConfig {
    /// Creates a new builder-style object to manufacture [`BucketAccessLogConfig`](crate::model::BucketAccessLogConfig)
    pub fn builder() -> crate::model::bucket_access_log_config::Builder {
        crate::model::bucket_access_log_config::Builder::default()
    }
}

/// <p>Describes the state of an Amazon Lightsail bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BucketState {
    /// <p>The state code of the bucket.</p>
    ///
    /// <p>The following codes are possible:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>OK</code> - The bucket is in a running state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Unknown</code> - Creation of the bucket might have timed-out. You might want to
    /// delete the bucket and create a new one.</p>
    /// </li>
    /// </ul>
    pub code: std::option::Option<std::string::String>,
    /// <p>A message that describes the state of the bucket.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BucketState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BucketState");
        formatter.field("code", &self.code);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`BucketState`](crate::model::BucketState)
pub mod bucket_state {
    /// A builder for [`BucketState`](crate::model::BucketState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The state code of the bucket.</p>
        ///
        /// <p>The following codes are possible:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>OK</code> - The bucket is in a running state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unknown</code> - Creation of the bucket might have timed-out. You might want to
        /// delete the bucket and create a new one.</p>
        /// </li>
        /// </ul>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The state code of the bucket.</p>
        ///
        /// <p>The following codes are possible:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>OK</code> - The bucket is in a running state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Unknown</code> - Creation of the bucket might have timed-out. You might want to
        /// delete the bucket and create a new one.</p>
        /// </li>
        /// </ul>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>A message that describes the state of the bucket.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that describes the state of the bucket.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BucketState`](crate::model::BucketState)
        pub fn build(self) -> crate::model::BucketState {
            crate::model::BucketState {
                code: self.code,
                message: self.message,
            }
        }
    }
}
impl BucketState {
    /// Creates a new builder-style object to manufacture [`BucketState`](crate::model::BucketState)
    pub fn builder() -> crate::model::bucket_state::Builder {
        crate::model::bucket_state::Builder::default()
    }
}

/// <p>Describes an Amazon Lightsail instance that has access to a Lightsail bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceReceivingAccess {
    /// <p>The name of the Lightsail instance.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Lightsail resource type (for example, <code>Instance</code>).</p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceReceivingAccess {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceReceivingAccess");
        formatter.field("name", &self.name);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
/// See [`ResourceReceivingAccess`](crate::model::ResourceReceivingAccess)
pub mod resource_receiving_access {
    /// A builder for [`ResourceReceivingAccess`](crate::model::ResourceReceivingAccess)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Lightsail instance.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Lightsail instance.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Lightsail resource type (for example, <code>Instance</code>).</p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The Lightsail resource type (for example, <code>Instance</code>).</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceReceivingAccess`](crate::model::ResourceReceivingAccess)
        pub fn build(self) -> crate::model::ResourceReceivingAccess {
            crate::model::ResourceReceivingAccess {
                name: self.name,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceReceivingAccess {
    /// Creates a new builder-style object to manufacture [`ResourceReceivingAccess`](crate::model::ResourceReceivingAccess)
    pub fn builder() -> crate::model::resource_receiving_access::Builder {
        crate::model::resource_receiving_access::Builder::default()
    }
}

/// <p>Describes the anonymous access permissions for an Amazon Lightsail bucket and its
/// objects.</p>
/// <p>For more information about bucket access permissions, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-understanding-bucket-permissions">Understanding bucket permissions in Amazon Lightsail</a> in the </p>
/// <p>
/// <i>Amazon Lightsail Developer Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessRules {
    /// <p>Specifies the anonymous access to all objects in a bucket.</p>
    ///
    /// <p>The following options can be specified:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>public</code> - Sets all objects in the bucket to public (read-only), making
    /// them readable by anyone in the world.</p>
    ///
    ///
    /// <p>If the <code>getObject</code> value is set to <code>public</code>, then all objects in
    /// the bucket default to public regardless of the <code>allowPublicOverrides</code>
    /// value.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>private</code> - Sets all objects in the bucket to private, making them readable
    /// only by you or anyone you give access to.</p>
    ///
    ///
    /// <p>If the <code>getObject</code> value is set to <code>private</code>, and the
    /// <code>allowPublicOverrides</code> value is set to <code>true</code>, then all objects in
    /// the bucket default to private unless they are configured with a <code>public-read</code>
    /// ACL. Individual objects with a <code>public-read</code> ACL are readable by anyone in the
    /// world.</p>
    /// </li>
    /// </ul>
    pub get_object: std::option::Option<crate::model::AccessType>,
    /// <p>A Boolean value that indicates whether the access control list (ACL) permissions that are
    /// applied to individual objects override the <code>getObject</code> option that is currently
    /// specified.</p>
    ///
    /// <p>When this is true, you can use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectAcl.html">PutObjectAcl</a> Amazon S3 API action to set
    /// individual objects to public (read-only) using the <code>public-read</code> ACL, or to private
    /// using the <code>private</code> ACL.</p>
    pub allow_public_overrides: std::option::Option<bool>,
}
impl std::fmt::Debug for AccessRules {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessRules");
        formatter.field("get_object", &self.get_object);
        formatter.field("allow_public_overrides", &self.allow_public_overrides);
        formatter.finish()
    }
}
/// See [`AccessRules`](crate::model::AccessRules)
pub mod access_rules {
    /// A builder for [`AccessRules`](crate::model::AccessRules)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) get_object: std::option::Option<crate::model::AccessType>,
        pub(crate) allow_public_overrides: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies the anonymous access to all objects in a bucket.</p>
        ///
        /// <p>The following options can be specified:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>public</code> - Sets all objects in the bucket to public (read-only), making
        /// them readable by anyone in the world.</p>
        ///
        ///
        /// <p>If the <code>getObject</code> value is set to <code>public</code>, then all objects in
        /// the bucket default to public regardless of the <code>allowPublicOverrides</code>
        /// value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>private</code> - Sets all objects in the bucket to private, making them readable
        /// only by you or anyone you give access to.</p>
        ///
        ///
        /// <p>If the <code>getObject</code> value is set to <code>private</code>, and the
        /// <code>allowPublicOverrides</code> value is set to <code>true</code>, then all objects in
        /// the bucket default to private unless they are configured with a <code>public-read</code>
        /// ACL. Individual objects with a <code>public-read</code> ACL are readable by anyone in the
        /// world.</p>
        /// </li>
        /// </ul>
        pub fn get_object(mut self, input: crate::model::AccessType) -> Self {
            self.get_object = Some(input);
            self
        }
        /// <p>Specifies the anonymous access to all objects in a bucket.</p>
        ///
        /// <p>The following options can be specified:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>public</code> - Sets all objects in the bucket to public (read-only), making
        /// them readable by anyone in the world.</p>
        ///
        ///
        /// <p>If the <code>getObject</code> value is set to <code>public</code>, then all objects in
        /// the bucket default to public regardless of the <code>allowPublicOverrides</code>
        /// value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>private</code> - Sets all objects in the bucket to private, making them readable
        /// only by you or anyone you give access to.</p>
        ///
        ///
        /// <p>If the <code>getObject</code> value is set to <code>private</code>, and the
        /// <code>allowPublicOverrides</code> value is set to <code>true</code>, then all objects in
        /// the bucket default to private unless they are configured with a <code>public-read</code>
        /// ACL. Individual objects with a <code>public-read</code> ACL are readable by anyone in the
        /// world.</p>
        /// </li>
        /// </ul>
        pub fn set_get_object(
            mut self,
            input: std::option::Option<crate::model::AccessType>,
        ) -> Self {
            self.get_object = input;
            self
        }
        /// <p>A Boolean value that indicates whether the access control list (ACL) permissions that are
        /// applied to individual objects override the <code>getObject</code> option that is currently
        /// specified.</p>
        ///
        /// <p>When this is true, you can use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectAcl.html">PutObjectAcl</a> Amazon S3 API action to set
        /// individual objects to public (read-only) using the <code>public-read</code> ACL, or to private
        /// using the <code>private</code> ACL.</p>
        pub fn allow_public_overrides(mut self, input: bool) -> Self {
            self.allow_public_overrides = Some(input);
            self
        }
        /// <p>A Boolean value that indicates whether the access control list (ACL) permissions that are
        /// applied to individual objects override the <code>getObject</code> option that is currently
        /// specified.</p>
        ///
        /// <p>When this is true, you can use the <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectAcl.html">PutObjectAcl</a> Amazon S3 API action to set
        /// individual objects to public (read-only) using the <code>public-read</code> ACL, or to private
        /// using the <code>private</code> ACL.</p>
        pub fn set_allow_public_overrides(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_public_overrides = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessRules`](crate::model::AccessRules)
        pub fn build(self) -> crate::model::AccessRules {
            crate::model::AccessRules {
                get_object: self.get_object,
                allow_public_overrides: self.allow_public_overrides,
            }
        }
    }
}
impl AccessRules {
    /// Creates a new builder-style object to manufacture [`AccessRules`](crate::model::AccessRules)
    pub fn builder() -> crate::model::access_rules::Builder {
        crate::model::access_rules::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccessType {
    #[allow(missing_docs)] // documentation missing in model
    Private,
    #[allow(missing_docs)] // documentation missing in model
    Public,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccessType {
    fn from(s: &str) -> Self {
        match s {
            "private" => AccessType::Private,
            "public" => AccessType::Public,
            other => AccessType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccessType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccessType::from(s))
    }
}
impl AccessType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccessType::Private => "private",
            AccessType::Public => "public",
            AccessType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["private", "public"]
    }
}
impl AsRef<str> for AccessType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AlarmState {
    #[allow(missing_docs)] // documentation missing in model
    Alarm,
    #[allow(missing_docs)] // documentation missing in model
    InsufficientData,
    #[allow(missing_docs)] // documentation missing in model
    Ok,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AlarmState {
    fn from(s: &str) -> Self {
        match s {
            "ALARM" => AlarmState::Alarm,
            "INSUFFICIENT_DATA" => AlarmState::InsufficientData,
            "OK" => AlarmState::Ok,
            other => AlarmState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AlarmState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AlarmState::from(s))
    }
}
impl AlarmState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AlarmState::Alarm => "ALARM",
            AlarmState::InsufficientData => "INSUFFICIENT_DATA",
            AlarmState::Ok => "OK",
            AlarmState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALARM", "INSUFFICIENT_DATA", "OK"]
    }
}
impl AsRef<str> for AlarmState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceBucketAccess {
    #[allow(missing_docs)] // documentation missing in model
    Allow,
    #[allow(missing_docs)] // documentation missing in model
    Deny,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceBucketAccess {
    fn from(s: &str) -> Self {
        match s {
            "allow" => ResourceBucketAccess::Allow,
            "deny" => ResourceBucketAccess::Deny,
            other => ResourceBucketAccess::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceBucketAccess {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceBucketAccess::from(s))
    }
}
impl ResourceBucketAccess {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceBucketAccess::Allow => "allow",
            ResourceBucketAccess::Deny => "deny",
            ResourceBucketAccess::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["allow", "deny"]
    }
}
impl AsRef<str> for ResourceBucketAccess {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IpAddressType {
    #[allow(missing_docs)] // documentation missing in model
    Dualstack,
    #[allow(missing_docs)] // documentation missing in model
    Ipv4,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IpAddressType {
    fn from(s: &str) -> Self {
        match s {
            "dualstack" => IpAddressType::Dualstack,
            "ipv4" => IpAddressType::Ipv4,
            other => IpAddressType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IpAddressType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IpAddressType::from(s))
    }
}
impl IpAddressType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IpAddressType::Dualstack => "dualstack",
            IpAddressType::Ipv4 => "ipv4",
            IpAddressType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["dualstack", "ipv4"]
    }
}
impl AsRef<str> for IpAddressType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContactMethodVerificationProtocol {
    #[allow(missing_docs)] // documentation missing in model
    Email,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContactMethodVerificationProtocol {
    fn from(s: &str) -> Self {
        match s {
            "Email" => ContactMethodVerificationProtocol::Email,
            other => ContactMethodVerificationProtocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContactMethodVerificationProtocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContactMethodVerificationProtocol::from(s))
    }
}
impl ContactMethodVerificationProtocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContactMethodVerificationProtocol::Email => "Email",
            ContactMethodVerificationProtocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Email"]
    }
}
impl AsRef<str> for ContactMethodVerificationProtocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a container image that is registered to an Amazon Lightsail container
/// service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContainerImage {
    /// <p>The name of the container image.</p>
    pub image: std::option::Option<std::string::String>,
    /// <p>The digest of the container image.</p>
    pub digest: std::option::Option<std::string::String>,
    /// <p>The timestamp when the container image was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for ContainerImage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContainerImage");
        formatter.field("image", &self.image);
        formatter.field("digest", &self.digest);
        formatter.field("created_at", &self.created_at);
        formatter.finish()
    }
}
/// See [`ContainerImage`](crate::model::ContainerImage)
pub mod container_image {
    /// A builder for [`ContainerImage`](crate::model::ContainerImage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) image: std::option::Option<std::string::String>,
        pub(crate) digest: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The name of the container image.</p>
        pub fn image(mut self, input: impl Into<std::string::String>) -> Self {
            self.image = Some(input.into());
            self
        }
        /// <p>The name of the container image.</p>
        pub fn set_image(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.image = input;
            self
        }
        /// <p>The digest of the container image.</p>
        pub fn digest(mut self, input: impl Into<std::string::String>) -> Self {
            self.digest = Some(input.into());
            self
        }
        /// <p>The digest of the container image.</p>
        pub fn set_digest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.digest = input;
            self
        }
        /// <p>The timestamp when the container image was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when the container image was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// Consumes the builder and constructs a [`ContainerImage`](crate::model::ContainerImage)
        pub fn build(self) -> crate::model::ContainerImage {
            crate::model::ContainerImage {
                image: self.image,
                digest: self.digest,
                created_at: self.created_at,
            }
        }
    }
}
impl ContainerImage {
    /// Creates a new builder-style object to manufacture [`ContainerImage`](crate::model::ContainerImage)
    pub fn builder() -> crate::model::container_image::Builder {
        crate::model::container_image::Builder::default()
    }
}

/// <p>Describes ports to open on an instance, the IP addresses allowed to connect to the
/// instance through the ports, and the protocol.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PortInfo {
    /// <p>The first port in a range of open ports on an instance.</p>
    /// <p>Allowed ports:</p>
    /// <ul>
    /// <li>
    /// <p>TCP and UDP - <code>0</code> to <code>65535</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>ICMP - The ICMP type for IPv4 addresses. For example, specify <code>8</code> as the
    /// <code>fromPort</code> (ICMP type), and <code>-1</code> as the <code>toPort</code> (ICMP
    /// code), to enable ICMP Ping. For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages">Control Messages</a> on <i>Wikipedia</i>.</p>
    /// </li>
    /// <li>
    /// <p>ICMPv6 - The ICMP type for IPv6 addresses. For example, specify <code>128</code> as
    /// the <code>fromPort</code> (ICMPv6 type), and <code>0</code> as <code>toPort</code> (ICMPv6
    /// code). For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6">Internet
    /// Control Message Protocol for IPv6</a>.</p>
    /// </li>
    /// </ul>
    pub from_port: i32,
    /// <p>The last port in a range of open ports on an instance.</p>
    /// <p>Allowed ports:</p>
    /// <ul>
    /// <li>
    /// <p>TCP and UDP - <code>0</code> to <code>65535</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>ICMP - The ICMP code for IPv4 addresses. For example, specify <code>8</code> as the
    /// <code>fromPort</code> (ICMP type), and <code>-1</code> as the <code>toPort</code> (ICMP
    /// code), to enable ICMP Ping. For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages">Control Messages</a> on <i>Wikipedia</i>.</p>
    /// </li>
    /// <li>
    /// <p>ICMPv6 - The ICMP code for IPv6 addresses. For example, specify <code>128</code> as
    /// the <code>fromPort</code> (ICMPv6 type), and <code>0</code> as <code>toPort</code> (ICMPv6
    /// code). For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6">Internet
    /// Control Message Protocol for IPv6</a>.</p>
    /// </li>
    /// </ul>
    pub to_port: i32,
    /// <p>The IP protocol name.</p>
    /// <p>The name can be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and
    /// error-checked delivery of streamed data between applications running on hosts
    /// communicating by an IP network. If you have an application that doesn't require reliable
    /// data stream service, use UDP instead.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>all</code> - All transport layer protocol types. For more general information,
    /// see <a href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on
    /// <i>Wikipedia</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send
    /// messages (or datagrams) to other hosts on an Internet Protocol (IP) network. Prior
    /// communications are not required to set up transmission channels or data paths.
    /// Applications that don't require reliable data stream service can use UDP, which provides a
    /// connectionless datagram service that emphasizes reduced latency over reliability. If you
    /// do require reliable data stream service, use TCP instead.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>icmp</code> - Internet Control Message Protocol (ICMP) is used to send error
    /// messages and operational information indicating success or failure when communicating with
    /// an instance. For example, an error is indicated when an instance could not be reached.
    /// When you specify <code>icmp</code> as the <code>protocol</code>, you must specify the ICMP
    /// type using the <code>fromPort</code> parameter, and ICMP code using the
    /// <code>toPort</code> parameter.</p>
    /// </li>
    /// </ul>
    pub protocol: std::option::Option<crate::model::NetworkProtocol>,
    /// <p>The IPv4 address, or range of IPv4 addresses (in CIDR notation) that are allowed to
    /// connect to an instance through the ports, and the protocol.</p>
    /// <note>
    /// <p>The <code>ipv6Cidrs</code> parameter lists the IPv6 addresses that are allowed to
    /// connect to an instance.</p>
    /// </note>
    /// <p>Examples:</p>
    /// <ul>
    /// <li>
    /// <p>To allow the IP address <code>192.0.2.44</code>, specify <code>192.0.2.44</code> or
    /// <code>192.0.2.44/32</code>. </p>
    /// </li>
    /// <li>
    /// <p>To allow the IP addresses <code>192.0.2.0</code> to <code>192.0.2.255</code>, specify
    /// <code>192.0.2.0/24</code>.</p>
    /// </li>
    /// </ul>
    /// <p>For more information about CIDR block notation, see <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation">Classless
    /// Inter-Domain Routing</a> on <i>Wikipedia</i>.</p>
    pub cidrs: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IPv6 address, or range of IPv6 addresses (in CIDR notation) that are allowed to
    /// connect to an instance through the ports, and the protocol. Only devices with an IPv6 address
    /// can connect to an instance through IPv6; otherwise, IPv4 should be used.</p>
    /// <note>
    /// <p>The <code>cidrs</code> parameter lists the IPv4 addresses that are allowed to connect to
    /// an instance.</p>
    /// </note>
    /// <p>For more information about CIDR block notation, see <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation">Classless
    /// Inter-Domain Routing</a> on <i>Wikipedia</i>.</p>
    pub ipv6_cidrs: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An alias that defines access for a preconfigured range of IP addresses.</p>
    /// <p>The only alias currently supported is <code>lightsail-connect</code>, which allows IP
    /// addresses of the browser-based RDP/SSH client in the Lightsail console to connect to your
    /// instance.</p>
    pub cidr_list_aliases: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for PortInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PortInfo");
        formatter.field("from_port", &self.from_port);
        formatter.field("to_port", &self.to_port);
        formatter.field("protocol", &self.protocol);
        formatter.field("cidrs", &self.cidrs);
        formatter.field("ipv6_cidrs", &self.ipv6_cidrs);
        formatter.field("cidr_list_aliases", &self.cidr_list_aliases);
        formatter.finish()
    }
}
/// See [`PortInfo`](crate::model::PortInfo)
pub mod port_info {
    /// A builder for [`PortInfo`](crate::model::PortInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_port: std::option::Option<i32>,
        pub(crate) to_port: std::option::Option<i32>,
        pub(crate) protocol: std::option::Option<crate::model::NetworkProtocol>,
        pub(crate) cidrs: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ipv6_cidrs: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cidr_list_aliases: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The first port in a range of open ports on an instance.</p>
        /// <p>Allowed ports:</p>
        /// <ul>
        /// <li>
        /// <p>TCP and UDP - <code>0</code> to <code>65535</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>ICMP - The ICMP type for IPv4 addresses. For example, specify <code>8</code> as the
        /// <code>fromPort</code> (ICMP type), and <code>-1</code> as the <code>toPort</code> (ICMP
        /// code), to enable ICMP Ping. For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages">Control Messages</a> on <i>Wikipedia</i>.</p>
        /// </li>
        /// <li>
        /// <p>ICMPv6 - The ICMP type for IPv6 addresses. For example, specify <code>128</code> as
        /// the <code>fromPort</code> (ICMPv6 type), and <code>0</code> as <code>toPort</code> (ICMPv6
        /// code). For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6">Internet
        /// Control Message Protocol for IPv6</a>.</p>
        /// </li>
        /// </ul>
        pub fn from_port(mut self, input: i32) -> Self {
            self.from_port = Some(input);
            self
        }
        /// <p>The first port in a range of open ports on an instance.</p>
        /// <p>Allowed ports:</p>
        /// <ul>
        /// <li>
        /// <p>TCP and UDP - <code>0</code> to <code>65535</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>ICMP - The ICMP type for IPv4 addresses. For example, specify <code>8</code> as the
        /// <code>fromPort</code> (ICMP type), and <code>-1</code> as the <code>toPort</code> (ICMP
        /// code), to enable ICMP Ping. For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages">Control Messages</a> on <i>Wikipedia</i>.</p>
        /// </li>
        /// <li>
        /// <p>ICMPv6 - The ICMP type for IPv6 addresses. For example, specify <code>128</code> as
        /// the <code>fromPort</code> (ICMPv6 type), and <code>0</code> as <code>toPort</code> (ICMPv6
        /// code). For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6">Internet
        /// Control Message Protocol for IPv6</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_from_port(mut self, input: std::option::Option<i32>) -> Self {
            self.from_port = input;
            self
        }
        /// <p>The last port in a range of open ports on an instance.</p>
        /// <p>Allowed ports:</p>
        /// <ul>
        /// <li>
        /// <p>TCP and UDP - <code>0</code> to <code>65535</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>ICMP - The ICMP code for IPv4 addresses. For example, specify <code>8</code> as the
        /// <code>fromPort</code> (ICMP type), and <code>-1</code> as the <code>toPort</code> (ICMP
        /// code), to enable ICMP Ping. For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages">Control Messages</a> on <i>Wikipedia</i>.</p>
        /// </li>
        /// <li>
        /// <p>ICMPv6 - The ICMP code for IPv6 addresses. For example, specify <code>128</code> as
        /// the <code>fromPort</code> (ICMPv6 type), and <code>0</code> as <code>toPort</code> (ICMPv6
        /// code). For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6">Internet
        /// Control Message Protocol for IPv6</a>.</p>
        /// </li>
        /// </ul>
        pub fn to_port(mut self, input: i32) -> Self {
            self.to_port = Some(input);
            self
        }
        /// <p>The last port in a range of open ports on an instance.</p>
        /// <p>Allowed ports:</p>
        /// <ul>
        /// <li>
        /// <p>TCP and UDP - <code>0</code> to <code>65535</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>ICMP - The ICMP code for IPv4 addresses. For example, specify <code>8</code> as the
        /// <code>fromPort</code> (ICMP type), and <code>-1</code> as the <code>toPort</code> (ICMP
        /// code), to enable ICMP Ping. For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages">Control Messages</a> on <i>Wikipedia</i>.</p>
        /// </li>
        /// <li>
        /// <p>ICMPv6 - The ICMP code for IPv6 addresses. For example, specify <code>128</code> as
        /// the <code>fromPort</code> (ICMPv6 type), and <code>0</code> as <code>toPort</code> (ICMPv6
        /// code). For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6">Internet
        /// Control Message Protocol for IPv6</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_to_port(mut self, input: std::option::Option<i32>) -> Self {
            self.to_port = input;
            self
        }
        /// <p>The IP protocol name.</p>
        /// <p>The name can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and
        /// error-checked delivery of streamed data between applications running on hosts
        /// communicating by an IP network. If you have an application that doesn't require reliable
        /// data stream service, use UDP instead.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>all</code> - All transport layer protocol types. For more general information,
        /// see <a href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on
        /// <i>Wikipedia</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send
        /// messages (or datagrams) to other hosts on an Internet Protocol (IP) network. Prior
        /// communications are not required to set up transmission channels or data paths.
        /// Applications that don't require reliable data stream service can use UDP, which provides a
        /// connectionless datagram service that emphasizes reduced latency over reliability. If you
        /// do require reliable data stream service, use TCP instead.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>icmp</code> - Internet Control Message Protocol (ICMP) is used to send error
        /// messages and operational information indicating success or failure when communicating with
        /// an instance. For example, an error is indicated when an instance could not be reached.
        /// When you specify <code>icmp</code> as the <code>protocol</code>, you must specify the ICMP
        /// type using the <code>fromPort</code> parameter, and ICMP code using the
        /// <code>toPort</code> parameter.</p>
        /// </li>
        /// </ul>
        pub fn protocol(mut self, input: crate::model::NetworkProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The IP protocol name.</p>
        /// <p>The name can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and
        /// error-checked delivery of streamed data between applications running on hosts
        /// communicating by an IP network. If you have an application that doesn't require reliable
        /// data stream service, use UDP instead.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>all</code> - All transport layer protocol types. For more general information,
        /// see <a href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on
        /// <i>Wikipedia</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send
        /// messages (or datagrams) to other hosts on an Internet Protocol (IP) network. Prior
        /// communications are not required to set up transmission channels or data paths.
        /// Applications that don't require reliable data stream service can use UDP, which provides a
        /// connectionless datagram service that emphasizes reduced latency over reliability. If you
        /// do require reliable data stream service, use TCP instead.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>icmp</code> - Internet Control Message Protocol (ICMP) is used to send error
        /// messages and operational information indicating success or failure when communicating with
        /// an instance. For example, an error is indicated when an instance could not be reached.
        /// When you specify <code>icmp</code> as the <code>protocol</code>, you must specify the ICMP
        /// type using the <code>fromPort</code> parameter, and ICMP code using the
        /// <code>toPort</code> parameter.</p>
        /// </li>
        /// </ul>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::NetworkProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// Appends an item to `cidrs`.
        ///
        /// To override the contents of this collection use [`set_cidrs`](Self::set_cidrs).
        ///
        /// <p>The IPv4 address, or range of IPv4 addresses (in CIDR notation) that are allowed to
        /// connect to an instance through the ports, and the protocol.</p>
        /// <note>
        /// <p>The <code>ipv6Cidrs</code> parameter lists the IPv6 addresses that are allowed to
        /// connect to an instance.</p>
        /// </note>
        /// <p>Examples:</p>
        /// <ul>
        /// <li>
        /// <p>To allow the IP address <code>192.0.2.44</code>, specify <code>192.0.2.44</code> or
        /// <code>192.0.2.44/32</code>. </p>
        /// </li>
        /// <li>
        /// <p>To allow the IP addresses <code>192.0.2.0</code> to <code>192.0.2.255</code>, specify
        /// <code>192.0.2.0/24</code>.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about CIDR block notation, see <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation">Classless
        /// Inter-Domain Routing</a> on <i>Wikipedia</i>.</p>
        pub fn cidrs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cidrs.unwrap_or_default();
            v.push(input.into());
            self.cidrs = Some(v);
            self
        }
        /// <p>The IPv4 address, or range of IPv4 addresses (in CIDR notation) that are allowed to
        /// connect to an instance through the ports, and the protocol.</p>
        /// <note>
        /// <p>The <code>ipv6Cidrs</code> parameter lists the IPv6 addresses that are allowed to
        /// connect to an instance.</p>
        /// </note>
        /// <p>Examples:</p>
        /// <ul>
        /// <li>
        /// <p>To allow the IP address <code>192.0.2.44</code>, specify <code>192.0.2.44</code> or
        /// <code>192.0.2.44/32</code>. </p>
        /// </li>
        /// <li>
        /// <p>To allow the IP addresses <code>192.0.2.0</code> to <code>192.0.2.255</code>, specify
        /// <code>192.0.2.0/24</code>.</p>
        /// </li>
        /// </ul>
        /// <p>For more information about CIDR block notation, see <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation">Classless
        /// Inter-Domain Routing</a> on <i>Wikipedia</i>.</p>
        pub fn set_cidrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cidrs = input;
            self
        }
        /// Appends an item to `ipv6_cidrs`.
        ///
        /// To override the contents of this collection use [`set_ipv6_cidrs`](Self::set_ipv6_cidrs).
        ///
        /// <p>The IPv6 address, or range of IPv6 addresses (in CIDR notation) that are allowed to
        /// connect to an instance through the ports, and the protocol. Only devices with an IPv6 address
        /// can connect to an instance through IPv6; otherwise, IPv4 should be used.</p>
        /// <note>
        /// <p>The <code>cidrs</code> parameter lists the IPv4 addresses that are allowed to connect to
        /// an instance.</p>
        /// </note>
        /// <p>For more information about CIDR block notation, see <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation">Classless
        /// Inter-Domain Routing</a> on <i>Wikipedia</i>.</p>
        pub fn ipv6_cidrs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ipv6_cidrs.unwrap_or_default();
            v.push(input.into());
            self.ipv6_cidrs = Some(v);
            self
        }
        /// <p>The IPv6 address, or range of IPv6 addresses (in CIDR notation) that are allowed to
        /// connect to an instance through the ports, and the protocol. Only devices with an IPv6 address
        /// can connect to an instance through IPv6; otherwise, IPv4 should be used.</p>
        /// <note>
        /// <p>The <code>cidrs</code> parameter lists the IPv4 addresses that are allowed to connect to
        /// an instance.</p>
        /// </note>
        /// <p>For more information about CIDR block notation, see <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation">Classless
        /// Inter-Domain Routing</a> on <i>Wikipedia</i>.</p>
        pub fn set_ipv6_cidrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ipv6_cidrs = input;
            self
        }
        /// Appends an item to `cidr_list_aliases`.
        ///
        /// To override the contents of this collection use [`set_cidr_list_aliases`](Self::set_cidr_list_aliases).
        ///
        /// <p>An alias that defines access for a preconfigured range of IP addresses.</p>
        /// <p>The only alias currently supported is <code>lightsail-connect</code>, which allows IP
        /// addresses of the browser-based RDP/SSH client in the Lightsail console to connect to your
        /// instance.</p>
        pub fn cidr_list_aliases(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cidr_list_aliases.unwrap_or_default();
            v.push(input.into());
            self.cidr_list_aliases = Some(v);
            self
        }
        /// <p>An alias that defines access for a preconfigured range of IP addresses.</p>
        /// <p>The only alias currently supported is <code>lightsail-connect</code>, which allows IP
        /// addresses of the browser-based RDP/SSH client in the Lightsail console to connect to your
        /// instance.</p>
        pub fn set_cidr_list_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cidr_list_aliases = input;
            self
        }
        /// Consumes the builder and constructs a [`PortInfo`](crate::model::PortInfo)
        pub fn build(self) -> crate::model::PortInfo {
            crate::model::PortInfo {
                from_port: self.from_port.unwrap_or_default(),
                to_port: self.to_port.unwrap_or_default(),
                protocol: self.protocol,
                cidrs: self.cidrs,
                ipv6_cidrs: self.ipv6_cidrs,
                cidr_list_aliases: self.cidr_list_aliases,
            }
        }
    }
}
impl PortInfo {
    /// Creates a new builder-style object to manufacture [`PortInfo`](crate::model::PortInfo)
    pub fn builder() -> crate::model::port_info::Builder {
        crate::model::port_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NetworkProtocol {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Icmp,
    #[allow(missing_docs)] // documentation missing in model
    Tcp,
    #[allow(missing_docs)] // documentation missing in model
    Udp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NetworkProtocol {
    fn from(s: &str) -> Self {
        match s {
            "all" => NetworkProtocol::All,
            "icmp" => NetworkProtocol::Icmp,
            "tcp" => NetworkProtocol::Tcp,
            "udp" => NetworkProtocol::Udp,
            other => NetworkProtocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NetworkProtocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NetworkProtocol::from(s))
    }
}
impl NetworkProtocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NetworkProtocol::All => "all",
            NetworkProtocol::Icmp => "icmp",
            NetworkProtocol::Tcp => "tcp",
            NetworkProtocol::Udp => "udp",
            NetworkProtocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["all", "icmp", "tcp", "udp"]
    }
}
impl AsRef<str> for NetworkProtocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContactProtocol {
    #[allow(missing_docs)] // documentation missing in model
    Email,
    #[allow(missing_docs)] // documentation missing in model
    Sms,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContactProtocol {
    fn from(s: &str) -> Self {
        match s {
            "Email" => ContactProtocol::Email,
            "SMS" => ContactProtocol::Sms,
            other => ContactProtocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContactProtocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContactProtocol::from(s))
    }
}
impl ContactProtocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContactProtocol::Email => "Email",
            ContactProtocol::Sms => "SMS",
            ContactProtocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Email", "SMS"]
    }
}
impl AsRef<str> for ContactProtocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TreatMissingData {
    #[allow(missing_docs)] // documentation missing in model
    Breaching,
    #[allow(missing_docs)] // documentation missing in model
    Ignore,
    #[allow(missing_docs)] // documentation missing in model
    Missing,
    #[allow(missing_docs)] // documentation missing in model
    NotBreaching,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TreatMissingData {
    fn from(s: &str) -> Self {
        match s {
            "breaching" => TreatMissingData::Breaching,
            "ignore" => TreatMissingData::Ignore,
            "missing" => TreatMissingData::Missing,
            "notBreaching" => TreatMissingData::NotBreaching,
            other => TreatMissingData::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TreatMissingData {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TreatMissingData::from(s))
    }
}
impl TreatMissingData {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TreatMissingData::Breaching => "breaching",
            TreatMissingData::Ignore => "ignore",
            TreatMissingData::Missing => "missing",
            TreatMissingData::NotBreaching => "notBreaching",
            TreatMissingData::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["breaching", "ignore", "missing", "notBreaching"]
    }
}
impl AsRef<str> for TreatMissingData {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ComparisonOperator {
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanOrEqualToThreshold,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanThreshold,
    #[allow(missing_docs)] // documentation missing in model
    LessThanOrEqualToThreshold,
    #[allow(missing_docs)] // documentation missing in model
    LessThanThreshold,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ComparisonOperator {
    fn from(s: &str) -> Self {
        match s {
            "GreaterThanOrEqualToThreshold" => ComparisonOperator::GreaterThanOrEqualToThreshold,
            "GreaterThanThreshold" => ComparisonOperator::GreaterThanThreshold,
            "LessThanOrEqualToThreshold" => ComparisonOperator::LessThanOrEqualToThreshold,
            "LessThanThreshold" => ComparisonOperator::LessThanThreshold,
            other => ComparisonOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ComparisonOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ComparisonOperator::from(s))
    }
}
impl ComparisonOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ComparisonOperator::GreaterThanOrEqualToThreshold => "GreaterThanOrEqualToThreshold",
            ComparisonOperator::GreaterThanThreshold => "GreaterThanThreshold",
            ComparisonOperator::LessThanOrEqualToThreshold => "LessThanOrEqualToThreshold",
            ComparisonOperator::LessThanThreshold => "LessThanThreshold",
            ComparisonOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "GreaterThanOrEqualToThreshold",
            "GreaterThanThreshold",
            "LessThanOrEqualToThreshold",
            "LessThanThreshold",
        ]
    }
}
impl AsRef<str> for ComparisonOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MetricName {
    #[allow(missing_docs)] // documentation missing in model
    BurstCapacityPercentage,
    #[allow(missing_docs)] // documentation missing in model
    BurstCapacityTime,
    #[allow(missing_docs)] // documentation missing in model
    CpuUtilization,
    #[allow(missing_docs)] // documentation missing in model
    ClientTlsNegotiationErrorCount,
    #[allow(missing_docs)] // documentation missing in model
    DatabaseConnections,
    #[allow(missing_docs)] // documentation missing in model
    DiskQueueDepth,
    #[allow(missing_docs)] // documentation missing in model
    FreeStorageSpace,
    #[allow(missing_docs)] // documentation missing in model
    HttpCodeInstance2XxCount,
    #[allow(missing_docs)] // documentation missing in model
    HttpCodeInstance3XxCount,
    #[allow(missing_docs)] // documentation missing in model
    HttpCodeInstance4XxCount,
    #[allow(missing_docs)] // documentation missing in model
    HttpCodeInstance5XxCount,
    #[allow(missing_docs)] // documentation missing in model
    HttpCodeLb4XxCount,
    #[allow(missing_docs)] // documentation missing in model
    HttpCodeLb5XxCount,
    #[allow(missing_docs)] // documentation missing in model
    HealthyHostCount,
    #[allow(missing_docs)] // documentation missing in model
    InstanceResponseTime,
    #[allow(missing_docs)] // documentation missing in model
    NetworkIn,
    #[allow(missing_docs)] // documentation missing in model
    NetworkOut,
    #[allow(missing_docs)] // documentation missing in model
    NetworkReceiveThroughput,
    #[allow(missing_docs)] // documentation missing in model
    NetworkTransmitThroughput,
    #[allow(missing_docs)] // documentation missing in model
    RejectedConnectionCount,
    #[allow(missing_docs)] // documentation missing in model
    RequestCount,
    #[allow(missing_docs)] // documentation missing in model
    StatusCheckFailed,
    #[allow(missing_docs)] // documentation missing in model
    StatusCheckFailedInstance,
    #[allow(missing_docs)] // documentation missing in model
    StatusCheckFailedSystem,
    #[allow(missing_docs)] // documentation missing in model
    UnhealthyHostCount,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MetricName {
    fn from(s: &str) -> Self {
        match s {
            "BurstCapacityPercentage" => MetricName::BurstCapacityPercentage,
            "BurstCapacityTime" => MetricName::BurstCapacityTime,
            "CPUUtilization" => MetricName::CpuUtilization,
            "ClientTLSNegotiationErrorCount" => MetricName::ClientTlsNegotiationErrorCount,
            "DatabaseConnections" => MetricName::DatabaseConnections,
            "DiskQueueDepth" => MetricName::DiskQueueDepth,
            "FreeStorageSpace" => MetricName::FreeStorageSpace,
            "HTTPCode_Instance_2XX_Count" => MetricName::HttpCodeInstance2XxCount,
            "HTTPCode_Instance_3XX_Count" => MetricName::HttpCodeInstance3XxCount,
            "HTTPCode_Instance_4XX_Count" => MetricName::HttpCodeInstance4XxCount,
            "HTTPCode_Instance_5XX_Count" => MetricName::HttpCodeInstance5XxCount,
            "HTTPCode_LB_4XX_Count" => MetricName::HttpCodeLb4XxCount,
            "HTTPCode_LB_5XX_Count" => MetricName::HttpCodeLb5XxCount,
            "HealthyHostCount" => MetricName::HealthyHostCount,
            "InstanceResponseTime" => MetricName::InstanceResponseTime,
            "NetworkIn" => MetricName::NetworkIn,
            "NetworkOut" => MetricName::NetworkOut,
            "NetworkReceiveThroughput" => MetricName::NetworkReceiveThroughput,
            "NetworkTransmitThroughput" => MetricName::NetworkTransmitThroughput,
            "RejectedConnectionCount" => MetricName::RejectedConnectionCount,
            "RequestCount" => MetricName::RequestCount,
            "StatusCheckFailed" => MetricName::StatusCheckFailed,
            "StatusCheckFailed_Instance" => MetricName::StatusCheckFailedInstance,
            "StatusCheckFailed_System" => MetricName::StatusCheckFailedSystem,
            "UnhealthyHostCount" => MetricName::UnhealthyHostCount,
            other => MetricName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MetricName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MetricName::from(s))
    }
}
impl MetricName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MetricName::BurstCapacityPercentage => "BurstCapacityPercentage",
            MetricName::BurstCapacityTime => "BurstCapacityTime",
            MetricName::CpuUtilization => "CPUUtilization",
            MetricName::ClientTlsNegotiationErrorCount => "ClientTLSNegotiationErrorCount",
            MetricName::DatabaseConnections => "DatabaseConnections",
            MetricName::DiskQueueDepth => "DiskQueueDepth",
            MetricName::FreeStorageSpace => "FreeStorageSpace",
            MetricName::HttpCodeInstance2XxCount => "HTTPCode_Instance_2XX_Count",
            MetricName::HttpCodeInstance3XxCount => "HTTPCode_Instance_3XX_Count",
            MetricName::HttpCodeInstance4XxCount => "HTTPCode_Instance_4XX_Count",
            MetricName::HttpCodeInstance5XxCount => "HTTPCode_Instance_5XX_Count",
            MetricName::HttpCodeLb4XxCount => "HTTPCode_LB_4XX_Count",
            MetricName::HttpCodeLb5XxCount => "HTTPCode_LB_5XX_Count",
            MetricName::HealthyHostCount => "HealthyHostCount",
            MetricName::InstanceResponseTime => "InstanceResponseTime",
            MetricName::NetworkIn => "NetworkIn",
            MetricName::NetworkOut => "NetworkOut",
            MetricName::NetworkReceiveThroughput => "NetworkReceiveThroughput",
            MetricName::NetworkTransmitThroughput => "NetworkTransmitThroughput",
            MetricName::RejectedConnectionCount => "RejectedConnectionCount",
            MetricName::RequestCount => "RequestCount",
            MetricName::StatusCheckFailed => "StatusCheckFailed",
            MetricName::StatusCheckFailedInstance => "StatusCheckFailed_Instance",
            MetricName::StatusCheckFailedSystem => "StatusCheckFailed_System",
            MetricName::UnhealthyHostCount => "UnhealthyHostCount",
            MetricName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BurstCapacityPercentage",
            "BurstCapacityTime",
            "CPUUtilization",
            "ClientTLSNegotiationErrorCount",
            "DatabaseConnections",
            "DiskQueueDepth",
            "FreeStorageSpace",
            "HTTPCode_Instance_2XX_Count",
            "HTTPCode_Instance_3XX_Count",
            "HTTPCode_Instance_4XX_Count",
            "HTTPCode_Instance_5XX_Count",
            "HTTPCode_LB_4XX_Count",
            "HTTPCode_LB_5XX_Count",
            "HealthyHostCount",
            "InstanceResponseTime",
            "NetworkIn",
            "NetworkOut",
            "NetworkReceiveThroughput",
            "NetworkTransmitThroughput",
            "RejectedConnectionCount",
            "RequestCount",
            "StatusCheckFailed",
            "StatusCheckFailed_Instance",
            "StatusCheckFailed_System",
            "UnhealthyHostCount",
        ]
    }
}
impl AsRef<str> for MetricName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a static IP.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StaticIp {
    /// <p>The name of the static IP (e.g., <code>StaticIP-Ohio-EXAMPLE</code>).</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the static IP (e.g.,
    /// <code>arn:aws:lightsail:us-east-2:123456789101:StaticIp/9cbb4a9e-f8e3-4dfe-b57e-12345EXAMPLE</code>).</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The support code. Include this code in your email to support when you have questions about
    /// an instance or another resource in Lightsail. This code enables our support team to look up
    /// your Lightsail information more easily.</p>
    pub support_code: std::option::Option<std::string::String>,
    /// <p>The timestamp when the static IP was created (e.g., <code>1479735304.222</code>).</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The region and Availability Zone where the static IP was created.</p>
    pub location: std::option::Option<crate::model::ResourceLocation>,
    /// <p>The resource type (usually <code>StaticIp</code>).</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The static IP address.</p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>The instance where the static IP is attached (e.g.,
    /// <code>Amazon_Linux-1GB-Ohio-1</code>).</p>
    pub attached_to: std::option::Option<std::string::String>,
    /// <p>A Boolean value indicating whether the static IP is attached.</p>
    pub is_attached: std::option::Option<bool>,
}
impl std::fmt::Debug for StaticIp {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StaticIp");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("support_code", &self.support_code);
        formatter.field("created_at", &self.created_at);
        formatter.field("location", &self.location);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("ip_address", &self.ip_address);
        formatter.field("attached_to", &self.attached_to);
        formatter.field("is_attached", &self.is_attached);
        formatter.finish()
    }
}
/// See [`StaticIp`](crate::model::StaticIp)
pub mod static_ip {
    /// A builder for [`StaticIp`](crate::model::StaticIp)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) support_code: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) location: std::option::Option<crate::model::ResourceLocation>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) attached_to: std::option::Option<std::string::String>,
        pub(crate) is_attached: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the static IP (e.g., <code>StaticIP-Ohio-EXAMPLE</code>).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the static IP (e.g., <code>StaticIP-Ohio-EXAMPLE</code>).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the static IP (e.g.,
        /// <code>arn:aws:lightsail:us-east-2:123456789101:StaticIp/9cbb4a9e-f8e3-4dfe-b57e-12345EXAMPLE</code>).</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the static IP (e.g.,
        /// <code>arn:aws:lightsail:us-east-2:123456789101:StaticIp/9cbb4a9e-f8e3-4dfe-b57e-12345EXAMPLE</code>).</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// an instance or another resource in Lightsail. This code enables our support team to look up
        /// your Lightsail information more easily.</p>
        pub fn support_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_code = Some(input.into());
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// an instance or another resource in Lightsail. This code enables our support team to look up
        /// your Lightsail information more easily.</p>
        pub fn set_support_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.support_code = input;
            self
        }
        /// <p>The timestamp when the static IP was created (e.g., <code>1479735304.222</code>).</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when the static IP was created (e.g., <code>1479735304.222</code>).</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The region and Availability Zone where the static IP was created.</p>
        pub fn location(mut self, input: crate::model::ResourceLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The region and Availability Zone where the static IP was created.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::ResourceLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>The resource type (usually <code>StaticIp</code>).</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The resource type (usually <code>StaticIp</code>).</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The static IP address.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>The static IP address.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>The instance where the static IP is attached (e.g.,
        /// <code>Amazon_Linux-1GB-Ohio-1</code>).</p>
        pub fn attached_to(mut self, input: impl Into<std::string::String>) -> Self {
            self.attached_to = Some(input.into());
            self
        }
        /// <p>The instance where the static IP is attached (e.g.,
        /// <code>Amazon_Linux-1GB-Ohio-1</code>).</p>
        pub fn set_attached_to(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.attached_to = input;
            self
        }
        /// <p>A Boolean value indicating whether the static IP is attached.</p>
        pub fn is_attached(mut self, input: bool) -> Self {
            self.is_attached = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether the static IP is attached.</p>
        pub fn set_is_attached(mut self, input: std::option::Option<bool>) -> Self {
            self.is_attached = input;
            self
        }
        /// Consumes the builder and constructs a [`StaticIp`](crate::model::StaticIp)
        pub fn build(self) -> crate::model::StaticIp {
            crate::model::StaticIp {
                name: self.name,
                arn: self.arn,
                support_code: self.support_code,
                created_at: self.created_at,
                location: self.location,
                resource_type: self.resource_type,
                ip_address: self.ip_address,
                attached_to: self.attached_to,
                is_attached: self.is_attached,
            }
        }
    }
}
impl StaticIp {
    /// Creates a new builder-style object to manufacture [`StaticIp`](crate::model::StaticIp)
    pub fn builder() -> crate::model::static_ip::Builder {
        crate::model::static_ip::Builder::default()
    }
}

/// <p>Describes a database snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RelationalDatabaseSnapshot {
    /// <p>The name of the database snapshot.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the database snapshot.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The support code for the database snapshot. Include this code in your email to support
    /// when you have questions about a database snapshot in Lightsail. This code enables our
    /// support team to look up your Lightsail information more easily.</p>
    pub support_code: std::option::Option<std::string::String>,
    /// <p>The timestamp when the database snapshot was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Region name and Availability Zone where the database snapshot is located.</p>
    pub location: std::option::Option<crate::model::ResourceLocation>,
    /// <p>The Lightsail resource type.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The tag keys and optional values for the resource. For more information about tags in
    /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The software of the database snapshot (for example, <code>MySQL</code>)</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The database engine version for the database snapshot (for example,
    /// <code>5.7.23</code>).</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The size of the disk in GB (for example, <code>32</code>) for the database
    /// snapshot.</p>
    pub size_in_gb: std::option::Option<i32>,
    /// <p>The state of the database snapshot.</p>
    pub state: std::option::Option<std::string::String>,
    /// <p>The name of the source database from which the database snapshot was created.</p>
    pub from_relational_database_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the database from which the database snapshot was
    /// created.</p>
    pub from_relational_database_arn: std::option::Option<std::string::String>,
    /// <p>The bundle ID of the database from which the database snapshot was created.</p>
    pub from_relational_database_bundle_id: std::option::Option<std::string::String>,
    /// <p>The blueprint ID of the database from which the database snapshot was created. A blueprint
    /// describes the major engine version of a database.</p>
    pub from_relational_database_blueprint_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RelationalDatabaseSnapshot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RelationalDatabaseSnapshot");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("support_code", &self.support_code);
        formatter.field("created_at", &self.created_at);
        formatter.field("location", &self.location);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("tags", &self.tags);
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("size_in_gb", &self.size_in_gb);
        formatter.field("state", &self.state);
        formatter.field(
            "from_relational_database_name",
            &self.from_relational_database_name,
        );
        formatter.field(
            "from_relational_database_arn",
            &self.from_relational_database_arn,
        );
        formatter.field(
            "from_relational_database_bundle_id",
            &self.from_relational_database_bundle_id,
        );
        formatter.field(
            "from_relational_database_blueprint_id",
            &self.from_relational_database_blueprint_id,
        );
        formatter.finish()
    }
}
/// See [`RelationalDatabaseSnapshot`](crate::model::RelationalDatabaseSnapshot)
pub mod relational_database_snapshot {
    /// A builder for [`RelationalDatabaseSnapshot`](crate::model::RelationalDatabaseSnapshot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) support_code: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) location: std::option::Option<crate::model::ResourceLocation>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) size_in_gb: std::option::Option<i32>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) from_relational_database_name: std::option::Option<std::string::String>,
        pub(crate) from_relational_database_arn: std::option::Option<std::string::String>,
        pub(crate) from_relational_database_bundle_id: std::option::Option<std::string::String>,
        pub(crate) from_relational_database_blueprint_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the database snapshot.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the database snapshot.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the database snapshot.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the database snapshot.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The support code for the database snapshot. Include this code in your email to support
        /// when you have questions about a database snapshot in Lightsail. This code enables our
        /// support team to look up your Lightsail information more easily.</p>
        pub fn support_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_code = Some(input.into());
            self
        }
        /// <p>The support code for the database snapshot. Include this code in your email to support
        /// when you have questions about a database snapshot in Lightsail. This code enables our
        /// support team to look up your Lightsail information more easily.</p>
        pub fn set_support_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.support_code = input;
            self
        }
        /// <p>The timestamp when the database snapshot was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when the database snapshot was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The Region name and Availability Zone where the database snapshot is located.</p>
        pub fn location(mut self, input: crate::model::ResourceLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The Region name and Availability Zone where the database snapshot is located.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::ResourceLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>The Lightsail resource type.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The Lightsail resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The software of the database snapshot (for example, <code>MySQL</code>)</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The software of the database snapshot (for example, <code>MySQL</code>)</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The database engine version for the database snapshot (for example,
        /// <code>5.7.23</code>).</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The database engine version for the database snapshot (for example,
        /// <code>5.7.23</code>).</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The size of the disk in GB (for example, <code>32</code>) for the database
        /// snapshot.</p>
        pub fn size_in_gb(mut self, input: i32) -> Self {
            self.size_in_gb = Some(input);
            self
        }
        /// <p>The size of the disk in GB (for example, <code>32</code>) for the database
        /// snapshot.</p>
        pub fn set_size_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.size_in_gb = input;
            self
        }
        /// <p>The state of the database snapshot.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The state of the database snapshot.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// <p>The name of the source database from which the database snapshot was created.</p>
        pub fn from_relational_database_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.from_relational_database_name = Some(input.into());
            self
        }
        /// <p>The name of the source database from which the database snapshot was created.</p>
        pub fn set_from_relational_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_relational_database_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the database from which the database snapshot was
        /// created.</p>
        pub fn from_relational_database_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.from_relational_database_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the database from which the database snapshot was
        /// created.</p>
        pub fn set_from_relational_database_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_relational_database_arn = input;
            self
        }
        /// <p>The bundle ID of the database from which the database snapshot was created.</p>
        pub fn from_relational_database_bundle_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.from_relational_database_bundle_id = Some(input.into());
            self
        }
        /// <p>The bundle ID of the database from which the database snapshot was created.</p>
        pub fn set_from_relational_database_bundle_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_relational_database_bundle_id = input;
            self
        }
        /// <p>The blueprint ID of the database from which the database snapshot was created. A blueprint
        /// describes the major engine version of a database.</p>
        pub fn from_relational_database_blueprint_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.from_relational_database_blueprint_id = Some(input.into());
            self
        }
        /// <p>The blueprint ID of the database from which the database snapshot was created. A blueprint
        /// describes the major engine version of a database.</p>
        pub fn set_from_relational_database_blueprint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_relational_database_blueprint_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RelationalDatabaseSnapshot`](crate::model::RelationalDatabaseSnapshot)
        pub fn build(self) -> crate::model::RelationalDatabaseSnapshot {
            crate::model::RelationalDatabaseSnapshot {
                name: self.name,
                arn: self.arn,
                support_code: self.support_code,
                created_at: self.created_at,
                location: self.location,
                resource_type: self.resource_type,
                tags: self.tags,
                engine: self.engine,
                engine_version: self.engine_version,
                size_in_gb: self.size_in_gb,
                state: self.state,
                from_relational_database_name: self.from_relational_database_name,
                from_relational_database_arn: self.from_relational_database_arn,
                from_relational_database_bundle_id: self.from_relational_database_bundle_id,
                from_relational_database_blueprint_id: self.from_relational_database_blueprint_id,
            }
        }
    }
}
impl RelationalDatabaseSnapshot {
    /// Creates a new builder-style object to manufacture [`RelationalDatabaseSnapshot`](crate::model::RelationalDatabaseSnapshot)
    pub fn builder() -> crate::model::relational_database_snapshot::Builder {
        crate::model::relational_database_snapshot::Builder::default()
    }
}

/// <p>Describes a database.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RelationalDatabase {
    /// <p>The unique name of the database resource in Lightsail.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the database.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The support code for the database. Include this code in your email to support when you
    /// have questions about a database in Lightsail. This code enables our support team to look up
    /// your Lightsail information more easily.</p>
    pub support_code: std::option::Option<std::string::String>,
    /// <p>The timestamp when the database was created. Formatted in Unix time.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Region name and Availability Zone where the database is located.</p>
    pub location: std::option::Option<crate::model::ResourceLocation>,
    /// <p>The Lightsail resource type for the database (for example,
    /// <code>RelationalDatabase</code>).</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The tag keys and optional values for the resource. For more information about tags in
    /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The blueprint ID for the database. A blueprint describes the major engine version of a
    /// database.</p>
    pub relational_database_blueprint_id: std::option::Option<std::string::String>,
    /// <p>The bundle ID for the database. A bundle describes the performance specifications for your
    /// database.</p>
    pub relational_database_bundle_id: std::option::Option<std::string::String>,
    /// <p>The name of the master database created when the Lightsail database resource is
    /// created.</p>
    pub master_database_name: std::option::Option<std::string::String>,
    /// <p>Describes the hardware of the database.</p>
    pub hardware: std::option::Option<crate::model::RelationalDatabaseHardware>,
    /// <p>Describes the current state of the database.</p>
    pub state: std::option::Option<std::string::String>,
    /// <p>Describes the secondary Availability Zone of a high availability database.</p>
    /// <p>The secondary database is used for failover support of a high availability
    /// database.</p>
    pub secondary_availability_zone: std::option::Option<std::string::String>,
    /// <p>A Boolean value indicating whether automated backup retention is enabled for the
    /// database.</p>
    pub backup_retention_enabled: std::option::Option<bool>,
    /// <p>Describes pending database value modifications.</p>
    pub pending_modified_values:
        std::option::Option<crate::model::PendingModifiedRelationalDatabaseValues>,
    /// <p>The database software (for example, <code>MySQL</code>).</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The database engine version (for example, <code>5.7.23</code>).</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The latest point in time to which the database can be restored. Formatted in Unix
    /// time.</p>
    pub latest_restorable_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The master user name of the database.</p>
    pub master_username: std::option::Option<std::string::String>,
    /// <p>The status of parameter updates for the database.</p>
    pub parameter_apply_status: std::option::Option<std::string::String>,
    /// <p>The daily time range during which automated backups are created for the database (for
    /// example, <code>16:00-16:30</code>).</p>
    pub preferred_backup_window: std::option::Option<std::string::String>,
    /// <p>The weekly time range during which system maintenance can occur on the database.</p>
    /// <p>In the format <code>ddd:hh24:mi-ddd:hh24:mi</code>. For example,
    /// <code>Tue:17:00-Tue:17:30</code>.</p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>A Boolean value indicating whether the database is publicly accessible.</p>
    pub publicly_accessible: std::option::Option<bool>,
    /// <p>The master endpoint for the database.</p>
    pub master_endpoint: std::option::Option<crate::model::RelationalDatabaseEndpoint>,
    /// <p>Describes the pending maintenance actions for the database.</p>
    pub pending_maintenance_actions:
        std::option::Option<std::vec::Vec<crate::model::PendingMaintenanceAction>>,
    /// <p>The certificate associated with the database.</p>
    pub ca_certificate_identifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RelationalDatabase {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RelationalDatabase");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("support_code", &self.support_code);
        formatter.field("created_at", &self.created_at);
        formatter.field("location", &self.location);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("tags", &self.tags);
        formatter.field(
            "relational_database_blueprint_id",
            &self.relational_database_blueprint_id,
        );
        formatter.field(
            "relational_database_bundle_id",
            &self.relational_database_bundle_id,
        );
        formatter.field("master_database_name", &self.master_database_name);
        formatter.field("hardware", &self.hardware);
        formatter.field("state", &self.state);
        formatter.field(
            "secondary_availability_zone",
            &self.secondary_availability_zone,
        );
        formatter.field("backup_retention_enabled", &self.backup_retention_enabled);
        formatter.field("pending_modified_values", &self.pending_modified_values);
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("latest_restorable_time", &self.latest_restorable_time);
        formatter.field("master_username", &self.master_username);
        formatter.field("parameter_apply_status", &self.parameter_apply_status);
        formatter.field("preferred_backup_window", &self.preferred_backup_window);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field("publicly_accessible", &self.publicly_accessible);
        formatter.field("master_endpoint", &self.master_endpoint);
        formatter.field(
            "pending_maintenance_actions",
            &self.pending_maintenance_actions,
        );
        formatter.field("ca_certificate_identifier", &self.ca_certificate_identifier);
        formatter.finish()
    }
}
/// See [`RelationalDatabase`](crate::model::RelationalDatabase)
pub mod relational_database {
    /// A builder for [`RelationalDatabase`](crate::model::RelationalDatabase)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) support_code: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) location: std::option::Option<crate::model::ResourceLocation>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) relational_database_blueprint_id: std::option::Option<std::string::String>,
        pub(crate) relational_database_bundle_id: std::option::Option<std::string::String>,
        pub(crate) master_database_name: std::option::Option<std::string::String>,
        pub(crate) hardware: std::option::Option<crate::model::RelationalDatabaseHardware>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) secondary_availability_zone: std::option::Option<std::string::String>,
        pub(crate) backup_retention_enabled: std::option::Option<bool>,
        pub(crate) pending_modified_values:
            std::option::Option<crate::model::PendingModifiedRelationalDatabaseValues>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) latest_restorable_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) master_username: std::option::Option<std::string::String>,
        pub(crate) parameter_apply_status: std::option::Option<std::string::String>,
        pub(crate) preferred_backup_window: std::option::Option<std::string::String>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) publicly_accessible: std::option::Option<bool>,
        pub(crate) master_endpoint: std::option::Option<crate::model::RelationalDatabaseEndpoint>,
        pub(crate) pending_maintenance_actions:
            std::option::Option<std::vec::Vec<crate::model::PendingMaintenanceAction>>,
        pub(crate) ca_certificate_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of the database resource in Lightsail.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique name of the database resource in Lightsail.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the database.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the database.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The support code for the database. Include this code in your email to support when you
        /// have questions about a database in Lightsail. This code enables our support team to look up
        /// your Lightsail information more easily.</p>
        pub fn support_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_code = Some(input.into());
            self
        }
        /// <p>The support code for the database. Include this code in your email to support when you
        /// have questions about a database in Lightsail. This code enables our support team to look up
        /// your Lightsail information more easily.</p>
        pub fn set_support_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.support_code = input;
            self
        }
        /// <p>The timestamp when the database was created. Formatted in Unix time.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when the database was created. Formatted in Unix time.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The Region name and Availability Zone where the database is located.</p>
        pub fn location(mut self, input: crate::model::ResourceLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The Region name and Availability Zone where the database is located.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::ResourceLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>The Lightsail resource type for the database (for example,
        /// <code>RelationalDatabase</code>).</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The Lightsail resource type for the database (for example,
        /// <code>RelationalDatabase</code>).</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The blueprint ID for the database. A blueprint describes the major engine version of a
        /// database.</p>
        pub fn relational_database_blueprint_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.relational_database_blueprint_id = Some(input.into());
            self
        }
        /// <p>The blueprint ID for the database. A blueprint describes the major engine version of a
        /// database.</p>
        pub fn set_relational_database_blueprint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relational_database_blueprint_id = input;
            self
        }
        /// <p>The bundle ID for the database. A bundle describes the performance specifications for your
        /// database.</p>
        pub fn relational_database_bundle_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.relational_database_bundle_id = Some(input.into());
            self
        }
        /// <p>The bundle ID for the database. A bundle describes the performance specifications for your
        /// database.</p>
        pub fn set_relational_database_bundle_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.relational_database_bundle_id = input;
            self
        }
        /// <p>The name of the master database created when the Lightsail database resource is
        /// created.</p>
        pub fn master_database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_database_name = Some(input.into());
            self
        }
        /// <p>The name of the master database created when the Lightsail database resource is
        /// created.</p>
        pub fn set_master_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_database_name = input;
            self
        }
        /// <p>Describes the hardware of the database.</p>
        pub fn hardware(mut self, input: crate::model::RelationalDatabaseHardware) -> Self {
            self.hardware = Some(input);
            self
        }
        /// <p>Describes the hardware of the database.</p>
        pub fn set_hardware(
            mut self,
            input: std::option::Option<crate::model::RelationalDatabaseHardware>,
        ) -> Self {
            self.hardware = input;
            self
        }
        /// <p>Describes the current state of the database.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>Describes the current state of the database.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// <p>Describes the secondary Availability Zone of a high availability database.</p>
        /// <p>The secondary database is used for failover support of a high availability
        /// database.</p>
        pub fn secondary_availability_zone(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.secondary_availability_zone = Some(input.into());
            self
        }
        /// <p>Describes the secondary Availability Zone of a high availability database.</p>
        /// <p>The secondary database is used for failover support of a high availability
        /// database.</p>
        pub fn set_secondary_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secondary_availability_zone = input;
            self
        }
        /// <p>A Boolean value indicating whether automated backup retention is enabled for the
        /// database.</p>
        pub fn backup_retention_enabled(mut self, input: bool) -> Self {
            self.backup_retention_enabled = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether automated backup retention is enabled for the
        /// database.</p>
        pub fn set_backup_retention_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.backup_retention_enabled = input;
            self
        }
        /// <p>Describes pending database value modifications.</p>
        pub fn pending_modified_values(
            mut self,
            input: crate::model::PendingModifiedRelationalDatabaseValues,
        ) -> Self {
            self.pending_modified_values = Some(input);
            self
        }
        /// <p>Describes pending database value modifications.</p>
        pub fn set_pending_modified_values(
            mut self,
            input: std::option::Option<crate::model::PendingModifiedRelationalDatabaseValues>,
        ) -> Self {
            self.pending_modified_values = input;
            self
        }
        /// <p>The database software (for example, <code>MySQL</code>).</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The database software (for example, <code>MySQL</code>).</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The database engine version (for example, <code>5.7.23</code>).</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The database engine version (for example, <code>5.7.23</code>).</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The latest point in time to which the database can be restored. Formatted in Unix
        /// time.</p>
        pub fn latest_restorable_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.latest_restorable_time = Some(input);
            self
        }
        /// <p>The latest point in time to which the database can be restored. Formatted in Unix
        /// time.</p>
        pub fn set_latest_restorable_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.latest_restorable_time = input;
            self
        }
        /// <p>The master user name of the database.</p>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_username = Some(input.into());
            self
        }
        /// <p>The master user name of the database.</p>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_username = input;
            self
        }
        /// <p>The status of parameter updates for the database.</p>
        pub fn parameter_apply_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_apply_status = Some(input.into());
            self
        }
        /// <p>The status of parameter updates for the database.</p>
        pub fn set_parameter_apply_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_apply_status = input;
            self
        }
        /// <p>The daily time range during which automated backups are created for the database (for
        /// example, <code>16:00-16:30</code>).</p>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_backup_window = Some(input.into());
            self
        }
        /// <p>The daily time range during which automated backups are created for the database (for
        /// example, <code>16:00-16:30</code>).</p>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_backup_window = input;
            self
        }
        /// <p>The weekly time range during which system maintenance can occur on the database.</p>
        /// <p>In the format <code>ddd:hh24:mi-ddd:hh24:mi</code>. For example,
        /// <code>Tue:17:00-Tue:17:30</code>.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>The weekly time range during which system maintenance can occur on the database.</p>
        /// <p>In the format <code>ddd:hh24:mi-ddd:hh24:mi</code>. For example,
        /// <code>Tue:17:00-Tue:17:30</code>.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>A Boolean value indicating whether the database is publicly accessible.</p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.publicly_accessible = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether the database is publicly accessible.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.publicly_accessible = input;
            self
        }
        /// <p>The master endpoint for the database.</p>
        pub fn master_endpoint(mut self, input: crate::model::RelationalDatabaseEndpoint) -> Self {
            self.master_endpoint = Some(input);
            self
        }
        /// <p>The master endpoint for the database.</p>
        pub fn set_master_endpoint(
            mut self,
            input: std::option::Option<crate::model::RelationalDatabaseEndpoint>,
        ) -> Self {
            self.master_endpoint = input;
            self
        }
        /// Appends an item to `pending_maintenance_actions`.
        ///
        /// To override the contents of this collection use [`set_pending_maintenance_actions`](Self::set_pending_maintenance_actions).
        ///
        /// <p>Describes the pending maintenance actions for the database.</p>
        pub fn pending_maintenance_actions(
            mut self,
            input: impl Into<crate::model::PendingMaintenanceAction>,
        ) -> Self {
            let mut v = self.pending_maintenance_actions.unwrap_or_default();
            v.push(input.into());
            self.pending_maintenance_actions = Some(v);
            self
        }
        /// <p>Describes the pending maintenance actions for the database.</p>
        pub fn set_pending_maintenance_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PendingMaintenanceAction>>,
        ) -> Self {
            self.pending_maintenance_actions = input;
            self
        }
        /// <p>The certificate associated with the database.</p>
        pub fn ca_certificate_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.ca_certificate_identifier = Some(input.into());
            self
        }
        /// <p>The certificate associated with the database.</p>
        pub fn set_ca_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ca_certificate_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`RelationalDatabase`](crate::model::RelationalDatabase)
        pub fn build(self) -> crate::model::RelationalDatabase {
            crate::model::RelationalDatabase {
                name: self.name,
                arn: self.arn,
                support_code: self.support_code,
                created_at: self.created_at,
                location: self.location,
                resource_type: self.resource_type,
                tags: self.tags,
                relational_database_blueprint_id: self.relational_database_blueprint_id,
                relational_database_bundle_id: self.relational_database_bundle_id,
                master_database_name: self.master_database_name,
                hardware: self.hardware,
                state: self.state,
                secondary_availability_zone: self.secondary_availability_zone,
                backup_retention_enabled: self.backup_retention_enabled,
                pending_modified_values: self.pending_modified_values,
                engine: self.engine,
                engine_version: self.engine_version,
                latest_restorable_time: self.latest_restorable_time,
                master_username: self.master_username,
                parameter_apply_status: self.parameter_apply_status,
                preferred_backup_window: self.preferred_backup_window,
                preferred_maintenance_window: self.preferred_maintenance_window,
                publicly_accessible: self.publicly_accessible,
                master_endpoint: self.master_endpoint,
                pending_maintenance_actions: self.pending_maintenance_actions,
                ca_certificate_identifier: self.ca_certificate_identifier,
            }
        }
    }
}
impl RelationalDatabase {
    /// Creates a new builder-style object to manufacture [`RelationalDatabase`](crate::model::RelationalDatabase)
    pub fn builder() -> crate::model::relational_database::Builder {
        crate::model::relational_database::Builder::default()
    }
}

/// <p>Describes a pending database maintenance action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PendingMaintenanceAction {
    /// <p>The type of pending database maintenance action.</p>
    pub action: std::option::Option<std::string::String>,
    /// <p>Additional detail about the pending database maintenance action.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The effective date of the pending database maintenance action.</p>
    pub current_apply_date: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for PendingMaintenanceAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PendingMaintenanceAction");
        formatter.field("action", &self.action);
        formatter.field("description", &self.description);
        formatter.field("current_apply_date", &self.current_apply_date);
        formatter.finish()
    }
}
/// See [`PendingMaintenanceAction`](crate::model::PendingMaintenanceAction)
pub mod pending_maintenance_action {
    /// A builder for [`PendingMaintenanceAction`](crate::model::PendingMaintenanceAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) current_apply_date: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The type of pending database maintenance action.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.action = Some(input.into());
            self
        }
        /// <p>The type of pending database maintenance action.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action = input;
            self
        }
        /// <p>Additional detail about the pending database maintenance action.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Additional detail about the pending database maintenance action.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The effective date of the pending database maintenance action.</p>
        pub fn current_apply_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.current_apply_date = Some(input);
            self
        }
        /// <p>The effective date of the pending database maintenance action.</p>
        pub fn set_current_apply_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.current_apply_date = input;
            self
        }
        /// Consumes the builder and constructs a [`PendingMaintenanceAction`](crate::model::PendingMaintenanceAction)
        pub fn build(self) -> crate::model::PendingMaintenanceAction {
            crate::model::PendingMaintenanceAction {
                action: self.action,
                description: self.description,
                current_apply_date: self.current_apply_date,
            }
        }
    }
}
impl PendingMaintenanceAction {
    /// Creates a new builder-style object to manufacture [`PendingMaintenanceAction`](crate::model::PendingMaintenanceAction)
    pub fn builder() -> crate::model::pending_maintenance_action::Builder {
        crate::model::pending_maintenance_action::Builder::default()
    }
}

/// <p>Describes an endpoint for a database.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RelationalDatabaseEndpoint {
    /// <p>Specifies the port that the database is listening on.</p>
    pub port: std::option::Option<i32>,
    /// <p>Specifies the DNS address of the database.</p>
    pub address: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RelationalDatabaseEndpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RelationalDatabaseEndpoint");
        formatter.field("port", &self.port);
        formatter.field("address", &self.address);
        formatter.finish()
    }
}
/// See [`RelationalDatabaseEndpoint`](crate::model::RelationalDatabaseEndpoint)
pub mod relational_database_endpoint {
    /// A builder for [`RelationalDatabaseEndpoint`](crate::model::RelationalDatabaseEndpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) port: std::option::Option<i32>,
        pub(crate) address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the port that the database is listening on.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Specifies the port that the database is listening on.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Specifies the DNS address of the database.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>Specifies the DNS address of the database.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// Consumes the builder and constructs a [`RelationalDatabaseEndpoint`](crate::model::RelationalDatabaseEndpoint)
        pub fn build(self) -> crate::model::RelationalDatabaseEndpoint {
            crate::model::RelationalDatabaseEndpoint {
                port: self.port,
                address: self.address,
            }
        }
    }
}
impl RelationalDatabaseEndpoint {
    /// Creates a new builder-style object to manufacture [`RelationalDatabaseEndpoint`](crate::model::RelationalDatabaseEndpoint)
    pub fn builder() -> crate::model::relational_database_endpoint::Builder {
        crate::model::relational_database_endpoint::Builder::default()
    }
}

/// <p>Describes a pending database value modification.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PendingModifiedRelationalDatabaseValues {
    /// <p>The password for the master user of the database.</p>
    pub master_user_password: std::option::Option<std::string::String>,
    /// <p>The database engine version.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>A Boolean value indicating whether automated backup retention is enabled.</p>
    pub backup_retention_enabled: std::option::Option<bool>,
}
impl std::fmt::Debug for PendingModifiedRelationalDatabaseValues {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PendingModifiedRelationalDatabaseValues");
        formatter.field("master_user_password", &self.master_user_password);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("backup_retention_enabled", &self.backup_retention_enabled);
        formatter.finish()
    }
}
/// See [`PendingModifiedRelationalDatabaseValues`](crate::model::PendingModifiedRelationalDatabaseValues)
pub mod pending_modified_relational_database_values {
    /// A builder for [`PendingModifiedRelationalDatabaseValues`](crate::model::PendingModifiedRelationalDatabaseValues)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) master_user_password: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) backup_retention_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The password for the master user of the database.</p>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_user_password = Some(input.into());
            self
        }
        /// <p>The password for the master user of the database.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_user_password = input;
            self
        }
        /// <p>The database engine version.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The database engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>A Boolean value indicating whether automated backup retention is enabled.</p>
        pub fn backup_retention_enabled(mut self, input: bool) -> Self {
            self.backup_retention_enabled = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether automated backup retention is enabled.</p>
        pub fn set_backup_retention_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.backup_retention_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`PendingModifiedRelationalDatabaseValues`](crate::model::PendingModifiedRelationalDatabaseValues)
        pub fn build(self) -> crate::model::PendingModifiedRelationalDatabaseValues {
            crate::model::PendingModifiedRelationalDatabaseValues {
                master_user_password: self.master_user_password,
                engine_version: self.engine_version,
                backup_retention_enabled: self.backup_retention_enabled,
            }
        }
    }
}
impl PendingModifiedRelationalDatabaseValues {
    /// Creates a new builder-style object to manufacture [`PendingModifiedRelationalDatabaseValues`](crate::model::PendingModifiedRelationalDatabaseValues)
    pub fn builder() -> crate::model::pending_modified_relational_database_values::Builder {
        crate::model::pending_modified_relational_database_values::Builder::default()
    }
}

/// <p>Describes the hardware of a database.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RelationalDatabaseHardware {
    /// <p>The number of vCPUs for the database.</p>
    pub cpu_count: std::option::Option<i32>,
    /// <p>The size of the disk for the database.</p>
    pub disk_size_in_gb: std::option::Option<i32>,
    /// <p>The amount of RAM in GB for the database.</p>
    pub ram_size_in_gb: std::option::Option<f32>,
}
impl std::fmt::Debug for RelationalDatabaseHardware {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RelationalDatabaseHardware");
        formatter.field("cpu_count", &self.cpu_count);
        formatter.field("disk_size_in_gb", &self.disk_size_in_gb);
        formatter.field("ram_size_in_gb", &self.ram_size_in_gb);
        formatter.finish()
    }
}
/// See [`RelationalDatabaseHardware`](crate::model::RelationalDatabaseHardware)
pub mod relational_database_hardware {
    /// A builder for [`RelationalDatabaseHardware`](crate::model::RelationalDatabaseHardware)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cpu_count: std::option::Option<i32>,
        pub(crate) disk_size_in_gb: std::option::Option<i32>,
        pub(crate) ram_size_in_gb: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>The number of vCPUs for the database.</p>
        pub fn cpu_count(mut self, input: i32) -> Self {
            self.cpu_count = Some(input);
            self
        }
        /// <p>The number of vCPUs for the database.</p>
        pub fn set_cpu_count(mut self, input: std::option::Option<i32>) -> Self {
            self.cpu_count = input;
            self
        }
        /// <p>The size of the disk for the database.</p>
        pub fn disk_size_in_gb(mut self, input: i32) -> Self {
            self.disk_size_in_gb = Some(input);
            self
        }
        /// <p>The size of the disk for the database.</p>
        pub fn set_disk_size_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.disk_size_in_gb = input;
            self
        }
        /// <p>The amount of RAM in GB for the database.</p>
        pub fn ram_size_in_gb(mut self, input: f32) -> Self {
            self.ram_size_in_gb = Some(input);
            self
        }
        /// <p>The amount of RAM in GB for the database.</p>
        pub fn set_ram_size_in_gb(mut self, input: std::option::Option<f32>) -> Self {
            self.ram_size_in_gb = input;
            self
        }
        /// Consumes the builder and constructs a [`RelationalDatabaseHardware`](crate::model::RelationalDatabaseHardware)
        pub fn build(self) -> crate::model::RelationalDatabaseHardware {
            crate::model::RelationalDatabaseHardware {
                cpu_count: self.cpu_count,
                disk_size_in_gb: self.disk_size_in_gb,
                ram_size_in_gb: self.ram_size_in_gb,
            }
        }
    }
}
impl RelationalDatabaseHardware {
    /// Creates a new builder-style object to manufacture [`RelationalDatabaseHardware`](crate::model::RelationalDatabaseHardware)
    pub fn builder() -> crate::model::relational_database_hardware::Builder {
        crate::model::relational_database_hardware::Builder::default()
    }
}

/// <p>Describes the metric data point.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricDatapoint {
    /// <p>The average.</p>
    pub average: std::option::Option<f64>,
    /// <p>The maximum.</p>
    pub maximum: std::option::Option<f64>,
    /// <p>The minimum.</p>
    pub minimum: std::option::Option<f64>,
    /// <p>The sample count.</p>
    pub sample_count: std::option::Option<f64>,
    /// <p>The sum.</p>
    pub sum: std::option::Option<f64>,
    /// <p>The timestamp (e.g., <code>1479816991.349</code>).</p>
    pub timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The unit. </p>
    pub unit: std::option::Option<crate::model::MetricUnit>,
}
impl std::fmt::Debug for MetricDatapoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricDatapoint");
        formatter.field("average", &self.average);
        formatter.field("maximum", &self.maximum);
        formatter.field("minimum", &self.minimum);
        formatter.field("sample_count", &self.sample_count);
        formatter.field("sum", &self.sum);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`MetricDatapoint`](crate::model::MetricDatapoint)
pub mod metric_datapoint {
    /// A builder for [`MetricDatapoint`](crate::model::MetricDatapoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) average: std::option::Option<f64>,
        pub(crate) maximum: std::option::Option<f64>,
        pub(crate) minimum: std::option::Option<f64>,
        pub(crate) sample_count: std::option::Option<f64>,
        pub(crate) sum: std::option::Option<f64>,
        pub(crate) timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) unit: std::option::Option<crate::model::MetricUnit>,
    }
    impl Builder {
        /// <p>The average.</p>
        pub fn average(mut self, input: f64) -> Self {
            self.average = Some(input);
            self
        }
        /// <p>The average.</p>
        pub fn set_average(mut self, input: std::option::Option<f64>) -> Self {
            self.average = input;
            self
        }
        /// <p>The maximum.</p>
        pub fn maximum(mut self, input: f64) -> Self {
            self.maximum = Some(input);
            self
        }
        /// <p>The maximum.</p>
        pub fn set_maximum(mut self, input: std::option::Option<f64>) -> Self {
            self.maximum = input;
            self
        }
        /// <p>The minimum.</p>
        pub fn minimum(mut self, input: f64) -> Self {
            self.minimum = Some(input);
            self
        }
        /// <p>The minimum.</p>
        pub fn set_minimum(mut self, input: std::option::Option<f64>) -> Self {
            self.minimum = input;
            self
        }
        /// <p>The sample count.</p>
        pub fn sample_count(mut self, input: f64) -> Self {
            self.sample_count = Some(input);
            self
        }
        /// <p>The sample count.</p>
        pub fn set_sample_count(mut self, input: std::option::Option<f64>) -> Self {
            self.sample_count = input;
            self
        }
        /// <p>The sum.</p>
        pub fn sum(mut self, input: f64) -> Self {
            self.sum = Some(input);
            self
        }
        /// <p>The sum.</p>
        pub fn set_sum(mut self, input: std::option::Option<f64>) -> Self {
            self.sum = input;
            self
        }
        /// <p>The timestamp (e.g., <code>1479816991.349</code>).</p>
        pub fn timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>The timestamp (e.g., <code>1479816991.349</code>).</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>The unit. </p>
        pub fn unit(mut self, input: crate::model::MetricUnit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>The unit. </p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::MetricUnit>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricDatapoint`](crate::model::MetricDatapoint)
        pub fn build(self) -> crate::model::MetricDatapoint {
            crate::model::MetricDatapoint {
                average: self.average,
                maximum: self.maximum,
                minimum: self.minimum,
                sample_count: self.sample_count,
                sum: self.sum,
                timestamp: self.timestamp,
                unit: self.unit,
            }
        }
    }
}
impl MetricDatapoint {
    /// Creates a new builder-style object to manufacture [`MetricDatapoint`](crate::model::MetricDatapoint)
    pub fn builder() -> crate::model::metric_datapoint::Builder {
        crate::model::metric_datapoint::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MetricUnit {
    #[allow(missing_docs)] // documentation missing in model
    Bits,
    #[allow(missing_docs)] // documentation missing in model
    BitsSecond,
    #[allow(missing_docs)] // documentation missing in model
    Bytes,
    #[allow(missing_docs)] // documentation missing in model
    BytesSecond,
    #[allow(missing_docs)] // documentation missing in model
    Count,
    #[allow(missing_docs)] // documentation missing in model
    CountSecond,
    #[allow(missing_docs)] // documentation missing in model
    Gigabits,
    #[allow(missing_docs)] // documentation missing in model
    GigabitsSecond,
    #[allow(missing_docs)] // documentation missing in model
    Gigabytes,
    #[allow(missing_docs)] // documentation missing in model
    GigabytesSecond,
    #[allow(missing_docs)] // documentation missing in model
    Kilobits,
    #[allow(missing_docs)] // documentation missing in model
    KilobitsSecond,
    #[allow(missing_docs)] // documentation missing in model
    Kilobytes,
    #[allow(missing_docs)] // documentation missing in model
    KilobytesSecond,
    #[allow(missing_docs)] // documentation missing in model
    Megabits,
    #[allow(missing_docs)] // documentation missing in model
    MegabitsSecond,
    #[allow(missing_docs)] // documentation missing in model
    Megabytes,
    #[allow(missing_docs)] // documentation missing in model
    MegabytesSecond,
    #[allow(missing_docs)] // documentation missing in model
    Microseconds,
    #[allow(missing_docs)] // documentation missing in model
    Milliseconds,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Percent,
    #[allow(missing_docs)] // documentation missing in model
    Seconds,
    #[allow(missing_docs)] // documentation missing in model
    Terabits,
    #[allow(missing_docs)] // documentation missing in model
    TerabitsSecond,
    #[allow(missing_docs)] // documentation missing in model
    Terabytes,
    #[allow(missing_docs)] // documentation missing in model
    TerabytesSecond,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MetricUnit {
    fn from(s: &str) -> Self {
        match s {
            "Bits" => MetricUnit::Bits,
            "Bits/Second" => MetricUnit::BitsSecond,
            "Bytes" => MetricUnit::Bytes,
            "Bytes/Second" => MetricUnit::BytesSecond,
            "Count" => MetricUnit::Count,
            "Count/Second" => MetricUnit::CountSecond,
            "Gigabits" => MetricUnit::Gigabits,
            "Gigabits/Second" => MetricUnit::GigabitsSecond,
            "Gigabytes" => MetricUnit::Gigabytes,
            "Gigabytes/Second" => MetricUnit::GigabytesSecond,
            "Kilobits" => MetricUnit::Kilobits,
            "Kilobits/Second" => MetricUnit::KilobitsSecond,
            "Kilobytes" => MetricUnit::Kilobytes,
            "Kilobytes/Second" => MetricUnit::KilobytesSecond,
            "Megabits" => MetricUnit::Megabits,
            "Megabits/Second" => MetricUnit::MegabitsSecond,
            "Megabytes" => MetricUnit::Megabytes,
            "Megabytes/Second" => MetricUnit::MegabytesSecond,
            "Microseconds" => MetricUnit::Microseconds,
            "Milliseconds" => MetricUnit::Milliseconds,
            "None" => MetricUnit::None,
            "Percent" => MetricUnit::Percent,
            "Seconds" => MetricUnit::Seconds,
            "Terabits" => MetricUnit::Terabits,
            "Terabits/Second" => MetricUnit::TerabitsSecond,
            "Terabytes" => MetricUnit::Terabytes,
            "Terabytes/Second" => MetricUnit::TerabytesSecond,
            other => MetricUnit::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MetricUnit {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MetricUnit::from(s))
    }
}
impl MetricUnit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MetricUnit::Bits => "Bits",
            MetricUnit::BitsSecond => "Bits/Second",
            MetricUnit::Bytes => "Bytes",
            MetricUnit::BytesSecond => "Bytes/Second",
            MetricUnit::Count => "Count",
            MetricUnit::CountSecond => "Count/Second",
            MetricUnit::Gigabits => "Gigabits",
            MetricUnit::GigabitsSecond => "Gigabits/Second",
            MetricUnit::Gigabytes => "Gigabytes",
            MetricUnit::GigabytesSecond => "Gigabytes/Second",
            MetricUnit::Kilobits => "Kilobits",
            MetricUnit::KilobitsSecond => "Kilobits/Second",
            MetricUnit::Kilobytes => "Kilobytes",
            MetricUnit::KilobytesSecond => "Kilobytes/Second",
            MetricUnit::Megabits => "Megabits",
            MetricUnit::MegabitsSecond => "Megabits/Second",
            MetricUnit::Megabytes => "Megabytes",
            MetricUnit::MegabytesSecond => "Megabytes/Second",
            MetricUnit::Microseconds => "Microseconds",
            MetricUnit::Milliseconds => "Milliseconds",
            MetricUnit::None => "None",
            MetricUnit::Percent => "Percent",
            MetricUnit::Seconds => "Seconds",
            MetricUnit::Terabits => "Terabits",
            MetricUnit::TerabitsSecond => "Terabits/Second",
            MetricUnit::Terabytes => "Terabytes",
            MetricUnit::TerabytesSecond => "Terabytes/Second",
            MetricUnit::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Bits",
            "Bits/Second",
            "Bytes",
            "Bytes/Second",
            "Count",
            "Count/Second",
            "Gigabits",
            "Gigabits/Second",
            "Gigabytes",
            "Gigabytes/Second",
            "Kilobits",
            "Kilobits/Second",
            "Kilobytes",
            "Kilobytes/Second",
            "Megabits",
            "Megabits/Second",
            "Megabytes",
            "Megabytes/Second",
            "Microseconds",
            "Milliseconds",
            "None",
            "Percent",
            "Seconds",
            "Terabits",
            "Terabits/Second",
            "Terabytes",
            "Terabytes/Second",
        ]
    }
}
impl AsRef<str> for MetricUnit {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RelationalDatabaseMetricName {
    #[allow(missing_docs)] // documentation missing in model
    CpuUtilization,
    #[allow(missing_docs)] // documentation missing in model
    DatabaseConnections,
    #[allow(missing_docs)] // documentation missing in model
    DiskQueueDepth,
    #[allow(missing_docs)] // documentation missing in model
    FreeStorageSpace,
    #[allow(missing_docs)] // documentation missing in model
    NetworkReceiveThroughput,
    #[allow(missing_docs)] // documentation missing in model
    NetworkTransmitThroughput,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RelationalDatabaseMetricName {
    fn from(s: &str) -> Self {
        match s {
            "CPUUtilization" => RelationalDatabaseMetricName::CpuUtilization,
            "DatabaseConnections" => RelationalDatabaseMetricName::DatabaseConnections,
            "DiskQueueDepth" => RelationalDatabaseMetricName::DiskQueueDepth,
            "FreeStorageSpace" => RelationalDatabaseMetricName::FreeStorageSpace,
            "NetworkReceiveThroughput" => RelationalDatabaseMetricName::NetworkReceiveThroughput,
            "NetworkTransmitThroughput" => RelationalDatabaseMetricName::NetworkTransmitThroughput,
            other => RelationalDatabaseMetricName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RelationalDatabaseMetricName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RelationalDatabaseMetricName::from(s))
    }
}
impl RelationalDatabaseMetricName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RelationalDatabaseMetricName::CpuUtilization => "CPUUtilization",
            RelationalDatabaseMetricName::DatabaseConnections => "DatabaseConnections",
            RelationalDatabaseMetricName::DiskQueueDepth => "DiskQueueDepth",
            RelationalDatabaseMetricName::FreeStorageSpace => "FreeStorageSpace",
            RelationalDatabaseMetricName::NetworkReceiveThroughput => "NetworkReceiveThroughput",
            RelationalDatabaseMetricName::NetworkTransmitThroughput => "NetworkTransmitThroughput",
            RelationalDatabaseMetricName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CPUUtilization",
            "DatabaseConnections",
            "DiskQueueDepth",
            "FreeStorageSpace",
            "NetworkReceiveThroughput",
            "NetworkTransmitThroughput",
        ]
    }
}
impl AsRef<str> for RelationalDatabaseMetricName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MetricStatistic {
    #[allow(missing_docs)] // documentation missing in model
    Average,
    #[allow(missing_docs)] // documentation missing in model
    Maximum,
    #[allow(missing_docs)] // documentation missing in model
    Minimum,
    #[allow(missing_docs)] // documentation missing in model
    SampleCount,
    #[allow(missing_docs)] // documentation missing in model
    Sum,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MetricStatistic {
    fn from(s: &str) -> Self {
        match s {
            "Average" => MetricStatistic::Average,
            "Maximum" => MetricStatistic::Maximum,
            "Minimum" => MetricStatistic::Minimum,
            "SampleCount" => MetricStatistic::SampleCount,
            "Sum" => MetricStatistic::Sum,
            other => MetricStatistic::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MetricStatistic {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MetricStatistic::from(s))
    }
}
impl MetricStatistic {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MetricStatistic::Average => "Average",
            MetricStatistic::Maximum => "Maximum",
            MetricStatistic::Minimum => "Minimum",
            MetricStatistic::SampleCount => "SampleCount",
            MetricStatistic::Sum => "Sum",
            MetricStatistic::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Average", "Maximum", "Minimum", "SampleCount", "Sum"]
    }
}
impl AsRef<str> for MetricStatistic {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RelationalDatabasePasswordVersion {
    #[allow(missing_docs)] // documentation missing in model
    Current,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Previous,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RelationalDatabasePasswordVersion {
    fn from(s: &str) -> Self {
        match s {
            "CURRENT" => RelationalDatabasePasswordVersion::Current,
            "PENDING" => RelationalDatabasePasswordVersion::Pending,
            "PREVIOUS" => RelationalDatabasePasswordVersion::Previous,
            other => RelationalDatabasePasswordVersion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RelationalDatabasePasswordVersion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RelationalDatabasePasswordVersion::from(s))
    }
}
impl RelationalDatabasePasswordVersion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RelationalDatabasePasswordVersion::Current => "CURRENT",
            RelationalDatabasePasswordVersion::Pending => "PENDING",
            RelationalDatabasePasswordVersion::Previous => "PREVIOUS",
            RelationalDatabasePasswordVersion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CURRENT", "PENDING", "PREVIOUS"]
    }
}
impl AsRef<str> for RelationalDatabasePasswordVersion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a database log event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogEvent {
    /// <p>The timestamp when the database log event was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The message of the database log event.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LogEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogEvent");
        formatter.field("created_at", &self.created_at);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`LogEvent`](crate::model::LogEvent)
pub mod log_event {
    /// A builder for [`LogEvent`](crate::model::LogEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The timestamp when the database log event was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when the database log event was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The message of the database log event.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message of the database log event.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LogEvent`](crate::model::LogEvent)
        pub fn build(self) -> crate::model::LogEvent {
            crate::model::LogEvent {
                created_at: self.created_at,
                message: self.message,
            }
        }
    }
}
impl LogEvent {
    /// Creates a new builder-style object to manufacture [`LogEvent`](crate::model::LogEvent)
    pub fn builder() -> crate::model::log_event::Builder {
        crate::model::log_event::Builder::default()
    }
}

/// <p>Describes an event for a database.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RelationalDatabaseEvent {
    /// <p>The database that the database event relates to.</p>
    pub resource: std::option::Option<std::string::String>,
    /// <p>The timestamp when the database event was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The message of the database event.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The category that the database event belongs to.</p>
    pub event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for RelationalDatabaseEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RelationalDatabaseEvent");
        formatter.field("resource", &self.resource);
        formatter.field("created_at", &self.created_at);
        formatter.field("message", &self.message);
        formatter.field("event_categories", &self.event_categories);
        formatter.finish()
    }
}
/// See [`RelationalDatabaseEvent`](crate::model::RelationalDatabaseEvent)
pub mod relational_database_event {
    /// A builder for [`RelationalDatabaseEvent`](crate::model::RelationalDatabaseEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The database that the database event relates to.</p>
        pub fn resource(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource = Some(input.into());
            self
        }
        /// <p>The database that the database event relates to.</p>
        pub fn set_resource(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource = input;
            self
        }
        /// <p>The timestamp when the database event was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when the database event was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The message of the database event.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message of the database event.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Appends an item to `event_categories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>The category that the database event belongs to.</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories.unwrap_or_default();
            v.push(input.into());
            self.event_categories = Some(v);
            self
        }
        /// <p>The category that the database event belongs to.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories = input;
            self
        }
        /// Consumes the builder and constructs a [`RelationalDatabaseEvent`](crate::model::RelationalDatabaseEvent)
        pub fn build(self) -> crate::model::RelationalDatabaseEvent {
            crate::model::RelationalDatabaseEvent {
                resource: self.resource,
                created_at: self.created_at,
                message: self.message,
                event_categories: self.event_categories,
            }
        }
    }
}
impl RelationalDatabaseEvent {
    /// Creates a new builder-style object to manufacture [`RelationalDatabaseEvent`](crate::model::RelationalDatabaseEvent)
    pub fn builder() -> crate::model::relational_database_event::Builder {
        crate::model::relational_database_event::Builder::default()
    }
}

/// <p>Describes a database bundle. A bundle describes the performance specifications of the
/// database.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RelationalDatabaseBundle {
    /// <p>The ID for the database bundle.</p>
    pub bundle_id: std::option::Option<std::string::String>,
    /// <p>The name for the database bundle.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The cost of the database bundle in US currency.</p>
    pub price: std::option::Option<f32>,
    /// <p>The amount of RAM in GB (for example, <code>2.0</code>) for the database bundle.</p>
    pub ram_size_in_gb: std::option::Option<f32>,
    /// <p>The size of the disk for the database bundle.</p>
    pub disk_size_in_gb: std::option::Option<i32>,
    /// <p>The data transfer rate per month in GB for the database bundle.</p>
    pub transfer_per_month_in_gb: std::option::Option<i32>,
    /// <p>The number of virtual CPUs (vCPUs) for the database bundle.</p>
    pub cpu_count: std::option::Option<i32>,
    /// <p>A Boolean value indicating whether the database bundle is encrypted.</p>
    pub is_encrypted: std::option::Option<bool>,
    /// <p>A Boolean value indicating whether the database bundle is active.</p>
    pub is_active: std::option::Option<bool>,
}
impl std::fmt::Debug for RelationalDatabaseBundle {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RelationalDatabaseBundle");
        formatter.field("bundle_id", &self.bundle_id);
        formatter.field("name", &self.name);
        formatter.field("price", &self.price);
        formatter.field("ram_size_in_gb", &self.ram_size_in_gb);
        formatter.field("disk_size_in_gb", &self.disk_size_in_gb);
        formatter.field("transfer_per_month_in_gb", &self.transfer_per_month_in_gb);
        formatter.field("cpu_count", &self.cpu_count);
        formatter.field("is_encrypted", &self.is_encrypted);
        formatter.field("is_active", &self.is_active);
        formatter.finish()
    }
}
/// See [`RelationalDatabaseBundle`](crate::model::RelationalDatabaseBundle)
pub mod relational_database_bundle {
    /// A builder for [`RelationalDatabaseBundle`](crate::model::RelationalDatabaseBundle)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bundle_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) price: std::option::Option<f32>,
        pub(crate) ram_size_in_gb: std::option::Option<f32>,
        pub(crate) disk_size_in_gb: std::option::Option<i32>,
        pub(crate) transfer_per_month_in_gb: std::option::Option<i32>,
        pub(crate) cpu_count: std::option::Option<i32>,
        pub(crate) is_encrypted: std::option::Option<bool>,
        pub(crate) is_active: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID for the database bundle.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_id = Some(input.into());
            self
        }
        /// <p>The ID for the database bundle.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_id = input;
            self
        }
        /// <p>The name for the database bundle.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the database bundle.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The cost of the database bundle in US currency.</p>
        pub fn price(mut self, input: f32) -> Self {
            self.price = Some(input);
            self
        }
        /// <p>The cost of the database bundle in US currency.</p>
        pub fn set_price(mut self, input: std::option::Option<f32>) -> Self {
            self.price = input;
            self
        }
        /// <p>The amount of RAM in GB (for example, <code>2.0</code>) for the database bundle.</p>
        pub fn ram_size_in_gb(mut self, input: f32) -> Self {
            self.ram_size_in_gb = Some(input);
            self
        }
        /// <p>The amount of RAM in GB (for example, <code>2.0</code>) for the database bundle.</p>
        pub fn set_ram_size_in_gb(mut self, input: std::option::Option<f32>) -> Self {
            self.ram_size_in_gb = input;
            self
        }
        /// <p>The size of the disk for the database bundle.</p>
        pub fn disk_size_in_gb(mut self, input: i32) -> Self {
            self.disk_size_in_gb = Some(input);
            self
        }
        /// <p>The size of the disk for the database bundle.</p>
        pub fn set_disk_size_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.disk_size_in_gb = input;
            self
        }
        /// <p>The data transfer rate per month in GB for the database bundle.</p>
        pub fn transfer_per_month_in_gb(mut self, input: i32) -> Self {
            self.transfer_per_month_in_gb = Some(input);
            self
        }
        /// <p>The data transfer rate per month in GB for the database bundle.</p>
        pub fn set_transfer_per_month_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.transfer_per_month_in_gb = input;
            self
        }
        /// <p>The number of virtual CPUs (vCPUs) for the database bundle.</p>
        pub fn cpu_count(mut self, input: i32) -> Self {
            self.cpu_count = Some(input);
            self
        }
        /// <p>The number of virtual CPUs (vCPUs) for the database bundle.</p>
        pub fn set_cpu_count(mut self, input: std::option::Option<i32>) -> Self {
            self.cpu_count = input;
            self
        }
        /// <p>A Boolean value indicating whether the database bundle is encrypted.</p>
        pub fn is_encrypted(mut self, input: bool) -> Self {
            self.is_encrypted = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether the database bundle is encrypted.</p>
        pub fn set_is_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.is_encrypted = input;
            self
        }
        /// <p>A Boolean value indicating whether the database bundle is active.</p>
        pub fn is_active(mut self, input: bool) -> Self {
            self.is_active = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether the database bundle is active.</p>
        pub fn set_is_active(mut self, input: std::option::Option<bool>) -> Self {
            self.is_active = input;
            self
        }
        /// Consumes the builder and constructs a [`RelationalDatabaseBundle`](crate::model::RelationalDatabaseBundle)
        pub fn build(self) -> crate::model::RelationalDatabaseBundle {
            crate::model::RelationalDatabaseBundle {
                bundle_id: self.bundle_id,
                name: self.name,
                price: self.price,
                ram_size_in_gb: self.ram_size_in_gb,
                disk_size_in_gb: self.disk_size_in_gb,
                transfer_per_month_in_gb: self.transfer_per_month_in_gb,
                cpu_count: self.cpu_count,
                is_encrypted: self.is_encrypted,
                is_active: self.is_active,
            }
        }
    }
}
impl RelationalDatabaseBundle {
    /// Creates a new builder-style object to manufacture [`RelationalDatabaseBundle`](crate::model::RelationalDatabaseBundle)
    pub fn builder() -> crate::model::relational_database_bundle::Builder {
        crate::model::relational_database_bundle::Builder::default()
    }
}

/// <p>Describes a database image, or blueprint. A blueprint describes the major engine version
/// of a database.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RelationalDatabaseBlueprint {
    /// <p>The ID for the database blueprint.</p>
    pub blueprint_id: std::option::Option<std::string::String>,
    /// <p>The database software of the database blueprint (for example, <code>MySQL</code>).</p>
    pub engine: std::option::Option<crate::model::RelationalDatabaseEngine>,
    /// <p>The database engine version for the database blueprint (for example,
    /// <code>5.7.23</code>).</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The description of the database engine for the database blueprint.</p>
    pub engine_description: std::option::Option<std::string::String>,
    /// <p>The description of the database engine version for the database blueprint.</p>
    pub engine_version_description: std::option::Option<std::string::String>,
    /// <p>A Boolean value indicating whether the engine version is the default for the database
    /// blueprint.</p>
    pub is_engine_default: std::option::Option<bool>,
}
impl std::fmt::Debug for RelationalDatabaseBlueprint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RelationalDatabaseBlueprint");
        formatter.field("blueprint_id", &self.blueprint_id);
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("engine_description", &self.engine_description);
        formatter.field(
            "engine_version_description",
            &self.engine_version_description,
        );
        formatter.field("is_engine_default", &self.is_engine_default);
        formatter.finish()
    }
}
/// See [`RelationalDatabaseBlueprint`](crate::model::RelationalDatabaseBlueprint)
pub mod relational_database_blueprint {
    /// A builder for [`RelationalDatabaseBlueprint`](crate::model::RelationalDatabaseBlueprint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) blueprint_id: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<crate::model::RelationalDatabaseEngine>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) engine_description: std::option::Option<std::string::String>,
        pub(crate) engine_version_description: std::option::Option<std::string::String>,
        pub(crate) is_engine_default: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID for the database blueprint.</p>
        pub fn blueprint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.blueprint_id = Some(input.into());
            self
        }
        /// <p>The ID for the database blueprint.</p>
        pub fn set_blueprint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.blueprint_id = input;
            self
        }
        /// <p>The database software of the database blueprint (for example, <code>MySQL</code>).</p>
        pub fn engine(mut self, input: crate::model::RelationalDatabaseEngine) -> Self {
            self.engine = Some(input);
            self
        }
        /// <p>The database software of the database blueprint (for example, <code>MySQL</code>).</p>
        pub fn set_engine(
            mut self,
            input: std::option::Option<crate::model::RelationalDatabaseEngine>,
        ) -> Self {
            self.engine = input;
            self
        }
        /// <p>The database engine version for the database blueprint (for example,
        /// <code>5.7.23</code>).</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The database engine version for the database blueprint (for example,
        /// <code>5.7.23</code>).</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The description of the database engine for the database blueprint.</p>
        pub fn engine_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_description = Some(input.into());
            self
        }
        /// <p>The description of the database engine for the database blueprint.</p>
        pub fn set_engine_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_description = input;
            self
        }
        /// <p>The description of the database engine version for the database blueprint.</p>
        pub fn engine_version_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version_description = Some(input.into());
            self
        }
        /// <p>The description of the database engine version for the database blueprint.</p>
        pub fn set_engine_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version_description = input;
            self
        }
        /// <p>A Boolean value indicating whether the engine version is the default for the database
        /// blueprint.</p>
        pub fn is_engine_default(mut self, input: bool) -> Self {
            self.is_engine_default = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether the engine version is the default for the database
        /// blueprint.</p>
        pub fn set_is_engine_default(mut self, input: std::option::Option<bool>) -> Self {
            self.is_engine_default = input;
            self
        }
        /// Consumes the builder and constructs a [`RelationalDatabaseBlueprint`](crate::model::RelationalDatabaseBlueprint)
        pub fn build(self) -> crate::model::RelationalDatabaseBlueprint {
            crate::model::RelationalDatabaseBlueprint {
                blueprint_id: self.blueprint_id,
                engine: self.engine,
                engine_version: self.engine_version,
                engine_description: self.engine_description,
                engine_version_description: self.engine_version_description,
                is_engine_default: self.is_engine_default,
            }
        }
    }
}
impl RelationalDatabaseBlueprint {
    /// Creates a new builder-style object to manufacture [`RelationalDatabaseBlueprint`](crate::model::RelationalDatabaseBlueprint)
    pub fn builder() -> crate::model::relational_database_blueprint::Builder {
        crate::model::relational_database_blueprint::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RelationalDatabaseEngine {
    #[allow(missing_docs)] // documentation missing in model
    Mysql,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RelationalDatabaseEngine {
    fn from(s: &str) -> Self {
        match s {
            "mysql" => RelationalDatabaseEngine::Mysql,
            other => RelationalDatabaseEngine::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RelationalDatabaseEngine {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RelationalDatabaseEngine::from(s))
    }
}
impl RelationalDatabaseEngine {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RelationalDatabaseEngine::Mysql => "mysql",
            RelationalDatabaseEngine::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["mysql"]
    }
}
impl AsRef<str> for RelationalDatabaseEngine {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the AWS Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Region {
    /// <p>The continent code (e.g., <code>NA</code>, meaning North America).</p>
    pub continent_code: std::option::Option<std::string::String>,
    /// <p>The description of the AWS Region (e.g., <code>This region is recommended to serve users
    /// in the eastern United States and eastern Canada</code>).</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The display name (e.g., <code>Ohio</code>).</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The region name (e.g., <code>us-east-2</code>).</p>
    pub name: std::option::Option<crate::model::RegionName>,
    /// <p>The Availability Zones. Follows the format <code>us-east-2a</code>
    /// (case-sensitive).</p>
    pub availability_zones: std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
    /// <p>The Availability Zones for databases. Follows the format <code>us-east-2a</code>
    /// (case-sensitive).</p>
    pub relational_database_availability_zones:
        std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
}
impl std::fmt::Debug for Region {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Region");
        formatter.field("continent_code", &self.continent_code);
        formatter.field("description", &self.description);
        formatter.field("display_name", &self.display_name);
        formatter.field("name", &self.name);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field(
            "relational_database_availability_zones",
            &self.relational_database_availability_zones,
        );
        formatter.finish()
    }
}
/// See [`Region`](crate::model::Region)
pub mod region {
    /// A builder for [`Region`](crate::model::Region)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) continent_code: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<crate::model::RegionName>,
        pub(crate) availability_zones:
            std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
        pub(crate) relational_database_availability_zones:
            std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
    }
    impl Builder {
        /// <p>The continent code (e.g., <code>NA</code>, meaning North America).</p>
        pub fn continent_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.continent_code = Some(input.into());
            self
        }
        /// <p>The continent code (e.g., <code>NA</code>, meaning North America).</p>
        pub fn set_continent_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.continent_code = input;
            self
        }
        /// <p>The description of the AWS Region (e.g., <code>This region is recommended to serve users
        /// in the eastern United States and eastern Canada</code>).</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the AWS Region (e.g., <code>This region is recommended to serve users
        /// in the eastern United States and eastern Canada</code>).</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The display name (e.g., <code>Ohio</code>).</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The display name (e.g., <code>Ohio</code>).</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The region name (e.g., <code>us-east-2</code>).</p>
        pub fn name(mut self, input: crate::model::RegionName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The region name (e.g., <code>us-east-2</code>).</p>
        pub fn set_name(mut self, input: std::option::Option<crate::model::RegionName>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>The Availability Zones. Follows the format <code>us-east-2a</code>
        /// (case-sensitive).</p>
        pub fn availability_zones(
            mut self,
            input: impl Into<crate::model::AvailabilityZone>,
        ) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>The Availability Zones. Follows the format <code>us-east-2a</code>
        /// (case-sensitive).</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Appends an item to `relational_database_availability_zones`.
        ///
        /// To override the contents of this collection use [`set_relational_database_availability_zones`](Self::set_relational_database_availability_zones).
        ///
        /// <p>The Availability Zones for databases. Follows the format <code>us-east-2a</code>
        /// (case-sensitive).</p>
        pub fn relational_database_availability_zones(
            mut self,
            input: impl Into<crate::model::AvailabilityZone>,
        ) -> Self {
            let mut v = self
                .relational_database_availability_zones
                .unwrap_or_default();
            v.push(input.into());
            self.relational_database_availability_zones = Some(v);
            self
        }
        /// <p>The Availability Zones for databases. Follows the format <code>us-east-2a</code>
        /// (case-sensitive).</p>
        pub fn set_relational_database_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
        ) -> Self {
            self.relational_database_availability_zones = input;
            self
        }
        /// Consumes the builder and constructs a [`Region`](crate::model::Region)
        pub fn build(self) -> crate::model::Region {
            crate::model::Region {
                continent_code: self.continent_code,
                description: self.description,
                display_name: self.display_name,
                name: self.name,
                availability_zones: self.availability_zones,
                relational_database_availability_zones: self.relational_database_availability_zones,
            }
        }
    }
}
impl Region {
    /// Creates a new builder-style object to manufacture [`Region`](crate::model::Region)
    pub fn builder() -> crate::model::region::Builder {
        crate::model::region::Builder::default()
    }
}

/// <p>Describes an Availability Zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AvailabilityZone {
    /// <p>The name of the Availability Zone. The format is <code>us-east-2a</code>
    /// (case-sensitive).</p>
    pub zone_name: std::option::Option<std::string::String>,
    /// <p>The state of the Availability Zone.</p>
    pub state: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AvailabilityZone {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AvailabilityZone");
        formatter.field("zone_name", &self.zone_name);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`AvailabilityZone`](crate::model::AvailabilityZone)
pub mod availability_zone {
    /// A builder for [`AvailabilityZone`](crate::model::AvailabilityZone)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) zone_name: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Availability Zone. The format is <code>us-east-2a</code>
        /// (case-sensitive).</p>
        pub fn zone_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.zone_name = Some(input.into());
            self
        }
        /// <p>The name of the Availability Zone. The format is <code>us-east-2a</code>
        /// (case-sensitive).</p>
        pub fn set_zone_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.zone_name = input;
            self
        }
        /// <p>The state of the Availability Zone.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The state of the Availability Zone.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`AvailabilityZone`](crate::model::AvailabilityZone)
        pub fn build(self) -> crate::model::AvailabilityZone {
            crate::model::AvailabilityZone {
                zone_name: self.zone_name,
                state: self.state,
            }
        }
    }
}
impl AvailabilityZone {
    /// Creates a new builder-style object to manufacture [`AvailabilityZone`](crate::model::AvailabilityZone)
    pub fn builder() -> crate::model::availability_zone::Builder {
        crate::model::availability_zone::Builder::default()
    }
}

/// <p>Describes a load balancer SSL/TLS certificate.</p>
/// <p>TLS is just an updated, more secure version of Secure Socket Layer (SSL).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoadBalancerTlsCertificate {
    /// <p>The name of the SSL/TLS certificate (e.g., <code>my-certificate</code>).</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the SSL/TLS certificate.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The support code. Include this code in your email to support when you have questions about
    /// your Lightsail load balancer or SSL/TLS certificate. This code enables our support team to
    /// look up your Lightsail information more easily.</p>
    pub support_code: std::option::Option<std::string::String>,
    /// <p>The time when you created your SSL/TLS certificate.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The AWS Region and Availability Zone where you created your certificate.</p>
    pub location: std::option::Option<crate::model::ResourceLocation>,
    /// <p>The resource type (e.g., <code>LoadBalancerTlsCertificate</code>).</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Instance</code>
    /// </b> - A Lightsail instance (a
    /// virtual private server)</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>StaticIp</code>
    /// </b> - A static IP address</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>KeyPair</code>
    /// </b> - The key pair used to connect
    /// to a Lightsail instance</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>InstanceSnapshot</code>
    /// </b> - A Lightsail
    /// instance snapshot</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Domain</code>
    /// </b> - A DNS zone</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>PeeredVpc</code>
    /// </b> - A peered VPC</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>LoadBalancer</code>
    /// </b> - A Lightsail load
    /// balancer</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>LoadBalancerTlsCertificate</code>
    /// </b> - An SSL/TLS
    /// certificate associated with a Lightsail load balancer</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Disk</code>
    /// </b> - A Lightsail block storage
    /// disk</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>DiskSnapshot</code>
    /// </b> - A block storage disk
    /// snapshot</p>
    /// </li>
    /// </ul>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The tag keys and optional values for the resource. For more information about tags in
    /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The load balancer name where your SSL/TLS certificate is attached.</p>
    pub load_balancer_name: std::option::Option<std::string::String>,
    /// <p>When <code>true</code>, the SSL/TLS certificate is attached to the Lightsail load
    /// balancer.</p>
    pub is_attached: std::option::Option<bool>,
    /// <p>The validation status of the SSL/TLS certificate. Valid values are below.</p>
    pub status: std::option::Option<crate::model::LoadBalancerTlsCertificateStatus>,
    /// <p>The domain name for your SSL/TLS certificate.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>An array of LoadBalancerTlsCertificateDomainValidationRecord objects describing the
    /// records.</p>
    pub domain_validation_records: std::option::Option<
        std::vec::Vec<crate::model::LoadBalancerTlsCertificateDomainValidationRecord>,
    >,
    /// <p>The validation failure reason, if any, of the certificate.</p>
    ///
    /// <p>The following failure reasons are possible:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NO_AVAILABLE_CONTACTS</code>
    /// </b> - This failure
    /// applies to email validation, which is not available for Lightsail certificates.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>ADDITIONAL_VERIFICATION_REQUIRED</code>
    /// </b> -
    /// Lightsail requires additional information to process this certificate request. This can
    /// happen as a fraud-protection measure, such as when the domain ranks within the Alexa top
    /// 1000 websites. To provide the required information, use the <a href="https://console.aws.amazon.com/support/home">AWS Support Center</a> to contact
    /// AWS Support.</p>
    /// <note>
    /// <p>You cannot request a certificate for Amazon-owned domain names such as those ending
    /// in amazonaws.com, cloudfront.net, or elasticbeanstalk.com.</p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>DOMAIN_NOT_ALLOWED</code>
    /// </b> - One or more of the
    /// domain names in the certificate request was reported as an unsafe domain by <a href="https://www.virustotal.com/gui/home/url">VirusTotal</a>. To correct the
    /// problem, search for your domain name on the <a href="https://www.virustotal.com/gui/home/url">VirusTotal</a> website. If your domain
    /// is reported as suspicious, see <a href="https://developers.google.com/web/fundamentals/security/hacked">Google Help for
    /// Hacked Websites</a> to learn what you can do.</p>
    /// <p>If you believe that the result is a false positive, notify the organization that is
    /// reporting the domain. VirusTotal is an aggregate of several antivirus and URL scanners and
    /// cannot remove your domain from a block list itself. After you correct the problem and the
    /// VirusTotal registry has been updated, request a new certificate.</p>
    /// <p>If you see this error and your domain is not included in the VirusTotal list, visit
    /// the <a href="https://console.aws.amazon.com/support/home">AWS Support Center</a>
    /// and create a case.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>INVALID_PUBLIC_DOMAIN</code>
    /// </b> - One or more of
    /// the domain names in the certificate request is not valid. Typically, this is because a
    /// domain name in the request is not a valid top-level domain. Try to request a certificate
    /// again, correcting any spelling errors or typos that were in the failed request, and ensure
    /// that all domain names in the request are for valid top-level domains. For example, you
    /// cannot request a certificate for <code>example.invalidpublicdomain</code> because
    /// <code>invalidpublicdomain</code> is not a valid top-level domain.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>OTHER</code>
    /// </b> - Typically, this failure occurs
    /// when there is a typographical error in one or more of the domain names in the certificate
    /// request. Try to request a certificate again, correcting any spelling errors or typos that
    /// were in the failed request. </p>
    /// </li>
    /// </ul>
    pub failure_reason: std::option::Option<crate::model::LoadBalancerTlsCertificateFailureReason>,
    /// <p>The time when the SSL/TLS certificate was issued.</p>
    pub issued_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The issuer of the certificate.</p>
    pub issuer: std::option::Option<std::string::String>,
    /// <p>The algorithm used to generate the key pair (the public and private key).</p>
    pub key_algorithm: std::option::Option<std::string::String>,
    /// <p>The timestamp when the SSL/TLS certificate expires.</p>
    pub not_after: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp when the SSL/TLS certificate is first valid.</p>
    pub not_before: std::option::Option<aws_smithy_types::Instant>,
    /// <p>An object that describes the status of the certificate renewal managed by
    /// Lightsail.</p>
    pub renewal_summary:
        std::option::Option<crate::model::LoadBalancerTlsCertificateRenewalSummary>,
    /// <p>The reason the certificate was revoked. This value is present only when the certificate
    /// status is <code>REVOKED</code>.</p>
    pub revocation_reason:
        std::option::Option<crate::model::LoadBalancerTlsCertificateRevocationReason>,
    /// <p>The timestamp when the certificate was revoked. This value is present only when the
    /// certificate status is <code>REVOKED</code>.</p>
    pub revoked_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The serial number of the certificate.</p>
    pub serial: std::option::Option<std::string::String>,
    /// <p>The algorithm that was used to sign the certificate.</p>
    pub signature_algorithm: std::option::Option<std::string::String>,
    /// <p>The name of the entity that is associated with the public key contained in the
    /// certificate.</p>
    pub subject: std::option::Option<std::string::String>,
    /// <p>An array of strings that specify the alternate domains (e.g., <code>example2.com</code>)
    /// and subdomains (e.g., <code>blog.example.com</code>) for the certificate.</p>
    pub subject_alternative_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for LoadBalancerTlsCertificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoadBalancerTlsCertificate");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("support_code", &self.support_code);
        formatter.field("created_at", &self.created_at);
        formatter.field("location", &self.location);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("tags", &self.tags);
        formatter.field("load_balancer_name", &self.load_balancer_name);
        formatter.field("is_attached", &self.is_attached);
        formatter.field("status", &self.status);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("domain_validation_records", &self.domain_validation_records);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.field("issued_at", &self.issued_at);
        formatter.field("issuer", &self.issuer);
        formatter.field("key_algorithm", &self.key_algorithm);
        formatter.field("not_after", &self.not_after);
        formatter.field("not_before", &self.not_before);
        formatter.field("renewal_summary", &self.renewal_summary);
        formatter.field("revocation_reason", &self.revocation_reason);
        formatter.field("revoked_at", &self.revoked_at);
        formatter.field("serial", &self.serial);
        formatter.field("signature_algorithm", &self.signature_algorithm);
        formatter.field("subject", &self.subject);
        formatter.field("subject_alternative_names", &self.subject_alternative_names);
        formatter.finish()
    }
}
/// See [`LoadBalancerTlsCertificate`](crate::model::LoadBalancerTlsCertificate)
pub mod load_balancer_tls_certificate {
    /// A builder for [`LoadBalancerTlsCertificate`](crate::model::LoadBalancerTlsCertificate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) support_code: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) location: std::option::Option<crate::model::ResourceLocation>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) load_balancer_name: std::option::Option<std::string::String>,
        pub(crate) is_attached: std::option::Option<bool>,
        pub(crate) status: std::option::Option<crate::model::LoadBalancerTlsCertificateStatus>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) domain_validation_records: std::option::Option<
            std::vec::Vec<crate::model::LoadBalancerTlsCertificateDomainValidationRecord>,
        >,
        pub(crate) failure_reason:
            std::option::Option<crate::model::LoadBalancerTlsCertificateFailureReason>,
        pub(crate) issued_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) issuer: std::option::Option<std::string::String>,
        pub(crate) key_algorithm: std::option::Option<std::string::String>,
        pub(crate) not_after: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) not_before: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) renewal_summary:
            std::option::Option<crate::model::LoadBalancerTlsCertificateRenewalSummary>,
        pub(crate) revocation_reason:
            std::option::Option<crate::model::LoadBalancerTlsCertificateRevocationReason>,
        pub(crate) revoked_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) serial: std::option::Option<std::string::String>,
        pub(crate) signature_algorithm: std::option::Option<std::string::String>,
        pub(crate) subject: std::option::Option<std::string::String>,
        pub(crate) subject_alternative_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the SSL/TLS certificate (e.g., <code>my-certificate</code>).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the SSL/TLS certificate (e.g., <code>my-certificate</code>).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SSL/TLS certificate.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SSL/TLS certificate.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// your Lightsail load balancer or SSL/TLS certificate. This code enables our support team to
        /// look up your Lightsail information more easily.</p>
        pub fn support_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_code = Some(input.into());
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// your Lightsail load balancer or SSL/TLS certificate. This code enables our support team to
        /// look up your Lightsail information more easily.</p>
        pub fn set_support_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.support_code = input;
            self
        }
        /// <p>The time when you created your SSL/TLS certificate.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when you created your SSL/TLS certificate.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The AWS Region and Availability Zone where you created your certificate.</p>
        pub fn location(mut self, input: crate::model::ResourceLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The AWS Region and Availability Zone where you created your certificate.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::ResourceLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>The resource type (e.g., <code>LoadBalancerTlsCertificate</code>).</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Instance</code>
        /// </b> - A Lightsail instance (a
        /// virtual private server)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>StaticIp</code>
        /// </b> - A static IP address</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>KeyPair</code>
        /// </b> - The key pair used to connect
        /// to a Lightsail instance</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>InstanceSnapshot</code>
        /// </b> - A Lightsail
        /// instance snapshot</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Domain</code>
        /// </b> - A DNS zone</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PeeredVpc</code>
        /// </b> - A peered VPC</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>LoadBalancer</code>
        /// </b> - A Lightsail load
        /// balancer</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>LoadBalancerTlsCertificate</code>
        /// </b> - An SSL/TLS
        /// certificate associated with a Lightsail load balancer</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Disk</code>
        /// </b> - A Lightsail block storage
        /// disk</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DiskSnapshot</code>
        /// </b> - A block storage disk
        /// snapshot</p>
        /// </li>
        /// </ul>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The resource type (e.g., <code>LoadBalancerTlsCertificate</code>).</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Instance</code>
        /// </b> - A Lightsail instance (a
        /// virtual private server)</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>StaticIp</code>
        /// </b> - A static IP address</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>KeyPair</code>
        /// </b> - The key pair used to connect
        /// to a Lightsail instance</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>InstanceSnapshot</code>
        /// </b> - A Lightsail
        /// instance snapshot</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Domain</code>
        /// </b> - A DNS zone</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PeeredVpc</code>
        /// </b> - A peered VPC</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>LoadBalancer</code>
        /// </b> - A Lightsail load
        /// balancer</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>LoadBalancerTlsCertificate</code>
        /// </b> - An SSL/TLS
        /// certificate associated with a Lightsail load balancer</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Disk</code>
        /// </b> - A Lightsail block storage
        /// disk</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DiskSnapshot</code>
        /// </b> - A block storage disk
        /// snapshot</p>
        /// </li>
        /// </ul>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The load balancer name where your SSL/TLS certificate is attached.</p>
        pub fn load_balancer_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.load_balancer_name = Some(input.into());
            self
        }
        /// <p>The load balancer name where your SSL/TLS certificate is attached.</p>
        pub fn set_load_balancer_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.load_balancer_name = input;
            self
        }
        /// <p>When <code>true</code>, the SSL/TLS certificate is attached to the Lightsail load
        /// balancer.</p>
        pub fn is_attached(mut self, input: bool) -> Self {
            self.is_attached = Some(input);
            self
        }
        /// <p>When <code>true</code>, the SSL/TLS certificate is attached to the Lightsail load
        /// balancer.</p>
        pub fn set_is_attached(mut self, input: std::option::Option<bool>) -> Self {
            self.is_attached = input;
            self
        }
        /// <p>The validation status of the SSL/TLS certificate. Valid values are below.</p>
        pub fn status(mut self, input: crate::model::LoadBalancerTlsCertificateStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The validation status of the SSL/TLS certificate. Valid values are below.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerTlsCertificateStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The domain name for your SSL/TLS certificate.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name for your SSL/TLS certificate.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Appends an item to `domain_validation_records`.
        ///
        /// To override the contents of this collection use [`set_domain_validation_records`](Self::set_domain_validation_records).
        ///
        /// <p>An array of LoadBalancerTlsCertificateDomainValidationRecord objects describing the
        /// records.</p>
        pub fn domain_validation_records(
            mut self,
            input: impl Into<crate::model::LoadBalancerTlsCertificateDomainValidationRecord>,
        ) -> Self {
            let mut v = self.domain_validation_records.unwrap_or_default();
            v.push(input.into());
            self.domain_validation_records = Some(v);
            self
        }
        /// <p>An array of LoadBalancerTlsCertificateDomainValidationRecord objects describing the
        /// records.</p>
        pub fn set_domain_validation_records(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::LoadBalancerTlsCertificateDomainValidationRecord>,
            >,
        ) -> Self {
            self.domain_validation_records = input;
            self
        }
        /// <p>The validation failure reason, if any, of the certificate.</p>
        ///
        /// <p>The following failure reasons are possible:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NO_AVAILABLE_CONTACTS</code>
        /// </b> - This failure
        /// applies to email validation, which is not available for Lightsail certificates.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ADDITIONAL_VERIFICATION_REQUIRED</code>
        /// </b> -
        /// Lightsail requires additional information to process this certificate request. This can
        /// happen as a fraud-protection measure, such as when the domain ranks within the Alexa top
        /// 1000 websites. To provide the required information, use the <a href="https://console.aws.amazon.com/support/home">AWS Support Center</a> to contact
        /// AWS Support.</p>
        /// <note>
        /// <p>You cannot request a certificate for Amazon-owned domain names such as those ending
        /// in amazonaws.com, cloudfront.net, or elasticbeanstalk.com.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DOMAIN_NOT_ALLOWED</code>
        /// </b> - One or more of the
        /// domain names in the certificate request was reported as an unsafe domain by <a href="https://www.virustotal.com/gui/home/url">VirusTotal</a>. To correct the
        /// problem, search for your domain name on the <a href="https://www.virustotal.com/gui/home/url">VirusTotal</a> website. If your domain
        /// is reported as suspicious, see <a href="https://developers.google.com/web/fundamentals/security/hacked">Google Help for
        /// Hacked Websites</a> to learn what you can do.</p>
        /// <p>If you believe that the result is a false positive, notify the organization that is
        /// reporting the domain. VirusTotal is an aggregate of several antivirus and URL scanners and
        /// cannot remove your domain from a block list itself. After you correct the problem and the
        /// VirusTotal registry has been updated, request a new certificate.</p>
        /// <p>If you see this error and your domain is not included in the VirusTotal list, visit
        /// the <a href="https://console.aws.amazon.com/support/home">AWS Support Center</a>
        /// and create a case.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>INVALID_PUBLIC_DOMAIN</code>
        /// </b> - One or more of
        /// the domain names in the certificate request is not valid. Typically, this is because a
        /// domain name in the request is not a valid top-level domain. Try to request a certificate
        /// again, correcting any spelling errors or typos that were in the failed request, and ensure
        /// that all domain names in the request are for valid top-level domains. For example, you
        /// cannot request a certificate for <code>example.invalidpublicdomain</code> because
        /// <code>invalidpublicdomain</code> is not a valid top-level domain.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>OTHER</code>
        /// </b> - Typically, this failure occurs
        /// when there is a typographical error in one or more of the domain names in the certificate
        /// request. Try to request a certificate again, correcting any spelling errors or typos that
        /// were in the failed request. </p>
        /// </li>
        /// </ul>
        pub fn failure_reason(
            mut self,
            input: crate::model::LoadBalancerTlsCertificateFailureReason,
        ) -> Self {
            self.failure_reason = Some(input);
            self
        }
        /// <p>The validation failure reason, if any, of the certificate.</p>
        ///
        /// <p>The following failure reasons are possible:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NO_AVAILABLE_CONTACTS</code>
        /// </b> - This failure
        /// applies to email validation, which is not available for Lightsail certificates.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ADDITIONAL_VERIFICATION_REQUIRED</code>
        /// </b> -
        /// Lightsail requires additional information to process this certificate request. This can
        /// happen as a fraud-protection measure, such as when the domain ranks within the Alexa top
        /// 1000 websites. To provide the required information, use the <a href="https://console.aws.amazon.com/support/home">AWS Support Center</a> to contact
        /// AWS Support.</p>
        /// <note>
        /// <p>You cannot request a certificate for Amazon-owned domain names such as those ending
        /// in amazonaws.com, cloudfront.net, or elasticbeanstalk.com.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DOMAIN_NOT_ALLOWED</code>
        /// </b> - One or more of the
        /// domain names in the certificate request was reported as an unsafe domain by <a href="https://www.virustotal.com/gui/home/url">VirusTotal</a>. To correct the
        /// problem, search for your domain name on the <a href="https://www.virustotal.com/gui/home/url">VirusTotal</a> website. If your domain
        /// is reported as suspicious, see <a href="https://developers.google.com/web/fundamentals/security/hacked">Google Help for
        /// Hacked Websites</a> to learn what you can do.</p>
        /// <p>If you believe that the result is a false positive, notify the organization that is
        /// reporting the domain. VirusTotal is an aggregate of several antivirus and URL scanners and
        /// cannot remove your domain from a block list itself. After you correct the problem and the
        /// VirusTotal registry has been updated, request a new certificate.</p>
        /// <p>If you see this error and your domain is not included in the VirusTotal list, visit
        /// the <a href="https://console.aws.amazon.com/support/home">AWS Support Center</a>
        /// and create a case.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>INVALID_PUBLIC_DOMAIN</code>
        /// </b> - One or more of
        /// the domain names in the certificate request is not valid. Typically, this is because a
        /// domain name in the request is not a valid top-level domain. Try to request a certificate
        /// again, correcting any spelling errors or typos that were in the failed request, and ensure
        /// that all domain names in the request are for valid top-level domains. For example, you
        /// cannot request a certificate for <code>example.invalidpublicdomain</code> because
        /// <code>invalidpublicdomain</code> is not a valid top-level domain.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>OTHER</code>
        /// </b> - Typically, this failure occurs
        /// when there is a typographical error in one or more of the domain names in the certificate
        /// request. Try to request a certificate again, correcting any spelling errors or typos that
        /// were in the failed request. </p>
        /// </li>
        /// </ul>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerTlsCertificateFailureReason>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// <p>The time when the SSL/TLS certificate was issued.</p>
        pub fn issued_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.issued_at = Some(input);
            self
        }
        /// <p>The time when the SSL/TLS certificate was issued.</p>
        pub fn set_issued_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.issued_at = input;
            self
        }
        /// <p>The issuer of the certificate.</p>
        pub fn issuer(mut self, input: impl Into<std::string::String>) -> Self {
            self.issuer = Some(input.into());
            self
        }
        /// <p>The issuer of the certificate.</p>
        pub fn set_issuer(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.issuer = input;
            self
        }
        /// <p>The algorithm used to generate the key pair (the public and private key).</p>
        pub fn key_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_algorithm = Some(input.into());
            self
        }
        /// <p>The algorithm used to generate the key pair (the public and private key).</p>
        pub fn set_key_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.key_algorithm = input;
            self
        }
        /// <p>The timestamp when the SSL/TLS certificate expires.</p>
        pub fn not_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.not_after = Some(input);
            self
        }
        /// <p>The timestamp when the SSL/TLS certificate expires.</p>
        pub fn set_not_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.not_after = input;
            self
        }
        /// <p>The timestamp when the SSL/TLS certificate is first valid.</p>
        pub fn not_before(mut self, input: aws_smithy_types::Instant) -> Self {
            self.not_before = Some(input);
            self
        }
        /// <p>The timestamp when the SSL/TLS certificate is first valid.</p>
        pub fn set_not_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.not_before = input;
            self
        }
        /// <p>An object that describes the status of the certificate renewal managed by
        /// Lightsail.</p>
        pub fn renewal_summary(
            mut self,
            input: crate::model::LoadBalancerTlsCertificateRenewalSummary,
        ) -> Self {
            self.renewal_summary = Some(input);
            self
        }
        /// <p>An object that describes the status of the certificate renewal managed by
        /// Lightsail.</p>
        pub fn set_renewal_summary(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerTlsCertificateRenewalSummary>,
        ) -> Self {
            self.renewal_summary = input;
            self
        }
        /// <p>The reason the certificate was revoked. This value is present only when the certificate
        /// status is <code>REVOKED</code>.</p>
        pub fn revocation_reason(
            mut self,
            input: crate::model::LoadBalancerTlsCertificateRevocationReason,
        ) -> Self {
            self.revocation_reason = Some(input);
            self
        }
        /// <p>The reason the certificate was revoked. This value is present only when the certificate
        /// status is <code>REVOKED</code>.</p>
        pub fn set_revocation_reason(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerTlsCertificateRevocationReason>,
        ) -> Self {
            self.revocation_reason = input;
            self
        }
        /// <p>The timestamp when the certificate was revoked. This value is present only when the
        /// certificate status is <code>REVOKED</code>.</p>
        pub fn revoked_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.revoked_at = Some(input);
            self
        }
        /// <p>The timestamp when the certificate was revoked. This value is present only when the
        /// certificate status is <code>REVOKED</code>.</p>
        pub fn set_revoked_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.revoked_at = input;
            self
        }
        /// <p>The serial number of the certificate.</p>
        pub fn serial(mut self, input: impl Into<std::string::String>) -> Self {
            self.serial = Some(input.into());
            self
        }
        /// <p>The serial number of the certificate.</p>
        pub fn set_serial(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.serial = input;
            self
        }
        /// <p>The algorithm that was used to sign the certificate.</p>
        pub fn signature_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.signature_algorithm = Some(input.into());
            self
        }
        /// <p>The algorithm that was used to sign the certificate.</p>
        pub fn set_signature_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signature_algorithm = input;
            self
        }
        /// <p>The name of the entity that is associated with the public key contained in the
        /// certificate.</p>
        pub fn subject(mut self, input: impl Into<std::string::String>) -> Self {
            self.subject = Some(input.into());
            self
        }
        /// <p>The name of the entity that is associated with the public key contained in the
        /// certificate.</p>
        pub fn set_subject(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subject = input;
            self
        }
        /// Appends an item to `subject_alternative_names`.
        ///
        /// To override the contents of this collection use [`set_subject_alternative_names`](Self::set_subject_alternative_names).
        ///
        /// <p>An array of strings that specify the alternate domains (e.g., <code>example2.com</code>)
        /// and subdomains (e.g., <code>blog.example.com</code>) for the certificate.</p>
        pub fn subject_alternative_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subject_alternative_names.unwrap_or_default();
            v.push(input.into());
            self.subject_alternative_names = Some(v);
            self
        }
        /// <p>An array of strings that specify the alternate domains (e.g., <code>example2.com</code>)
        /// and subdomains (e.g., <code>blog.example.com</code>) for the certificate.</p>
        pub fn set_subject_alternative_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subject_alternative_names = input;
            self
        }
        /// Consumes the builder and constructs a [`LoadBalancerTlsCertificate`](crate::model::LoadBalancerTlsCertificate)
        pub fn build(self) -> crate::model::LoadBalancerTlsCertificate {
            crate::model::LoadBalancerTlsCertificate {
                name: self.name,
                arn: self.arn,
                support_code: self.support_code,
                created_at: self.created_at,
                location: self.location,
                resource_type: self.resource_type,
                tags: self.tags,
                load_balancer_name: self.load_balancer_name,
                is_attached: self.is_attached,
                status: self.status,
                domain_name: self.domain_name,
                domain_validation_records: self.domain_validation_records,
                failure_reason: self.failure_reason,
                issued_at: self.issued_at,
                issuer: self.issuer,
                key_algorithm: self.key_algorithm,
                not_after: self.not_after,
                not_before: self.not_before,
                renewal_summary: self.renewal_summary,
                revocation_reason: self.revocation_reason,
                revoked_at: self.revoked_at,
                serial: self.serial,
                signature_algorithm: self.signature_algorithm,
                subject: self.subject,
                subject_alternative_names: self.subject_alternative_names,
            }
        }
    }
}
impl LoadBalancerTlsCertificate {
    /// Creates a new builder-style object to manufacture [`LoadBalancerTlsCertificate`](crate::model::LoadBalancerTlsCertificate)
    pub fn builder() -> crate::model::load_balancer_tls_certificate::Builder {
        crate::model::load_balancer_tls_certificate::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LoadBalancerTlsCertificateRevocationReason {
    #[allow(missing_docs)] // documentation missing in model
    AffiliationChanged,
    #[allow(missing_docs)] // documentation missing in model
    AaCompromise,
    #[allow(missing_docs)] // documentation missing in model
    CaCompromise,
    #[allow(missing_docs)] // documentation missing in model
    CertificateHold,
    #[allow(missing_docs)] // documentation missing in model
    CessationOfOperation,
    #[allow(missing_docs)] // documentation missing in model
    KeyCompromise,
    #[allow(missing_docs)] // documentation missing in model
    PrivilegeWithdrawn,
    #[allow(missing_docs)] // documentation missing in model
    RemoveFromCrl,
    #[allow(missing_docs)] // documentation missing in model
    Superceded,
    #[allow(missing_docs)] // documentation missing in model
    Unspecified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LoadBalancerTlsCertificateRevocationReason {
    fn from(s: &str) -> Self {
        match s {
            "AFFILIATION_CHANGED" => LoadBalancerTlsCertificateRevocationReason::AffiliationChanged,
            "A_A_COMPROMISE" => LoadBalancerTlsCertificateRevocationReason::AaCompromise,
            "CA_COMPROMISE" => LoadBalancerTlsCertificateRevocationReason::CaCompromise,
            "CERTIFICATE_HOLD" => LoadBalancerTlsCertificateRevocationReason::CertificateHold,
            "CESSATION_OF_OPERATION" => {
                LoadBalancerTlsCertificateRevocationReason::CessationOfOperation
            }
            "KEY_COMPROMISE" => LoadBalancerTlsCertificateRevocationReason::KeyCompromise,
            "PRIVILEGE_WITHDRAWN" => LoadBalancerTlsCertificateRevocationReason::PrivilegeWithdrawn,
            "REMOVE_FROM_CRL" => LoadBalancerTlsCertificateRevocationReason::RemoveFromCrl,
            "SUPERCEDED" => LoadBalancerTlsCertificateRevocationReason::Superceded,
            "UNSPECIFIED" => LoadBalancerTlsCertificateRevocationReason::Unspecified,
            other => LoadBalancerTlsCertificateRevocationReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LoadBalancerTlsCertificateRevocationReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LoadBalancerTlsCertificateRevocationReason::from(s))
    }
}
impl LoadBalancerTlsCertificateRevocationReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LoadBalancerTlsCertificateRevocationReason::AffiliationChanged => "AFFILIATION_CHANGED",
            LoadBalancerTlsCertificateRevocationReason::AaCompromise => "A_A_COMPROMISE",
            LoadBalancerTlsCertificateRevocationReason::CaCompromise => "CA_COMPROMISE",
            LoadBalancerTlsCertificateRevocationReason::CertificateHold => "CERTIFICATE_HOLD",
            LoadBalancerTlsCertificateRevocationReason::CessationOfOperation => {
                "CESSATION_OF_OPERATION"
            }
            LoadBalancerTlsCertificateRevocationReason::KeyCompromise => "KEY_COMPROMISE",
            LoadBalancerTlsCertificateRevocationReason::PrivilegeWithdrawn => "PRIVILEGE_WITHDRAWN",
            LoadBalancerTlsCertificateRevocationReason::RemoveFromCrl => "REMOVE_FROM_CRL",
            LoadBalancerTlsCertificateRevocationReason::Superceded => "SUPERCEDED",
            LoadBalancerTlsCertificateRevocationReason::Unspecified => "UNSPECIFIED",
            LoadBalancerTlsCertificateRevocationReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AFFILIATION_CHANGED",
            "A_A_COMPROMISE",
            "CA_COMPROMISE",
            "CERTIFICATE_HOLD",
            "CESSATION_OF_OPERATION",
            "KEY_COMPROMISE",
            "PRIVILEGE_WITHDRAWN",
            "REMOVE_FROM_CRL",
            "SUPERCEDED",
            "UNSPECIFIED",
        ]
    }
}
impl AsRef<str> for LoadBalancerTlsCertificateRevocationReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the status of Lightsail's managed renewal for the
/// certificate.</p>
/// <p>The renewal status of the certificate.</p>
/// <p>The following renewal status are possible:</p>
/// <ul>
/// <li>
/// <p>
/// <b>
/// <code>PendingAutoRenewal</code>
/// </b> - Lightsail is
/// attempting to automatically validate the domain names in the certificate. No further
/// action is required. </p>
/// </li>
/// <li>
/// <p>
/// <b>
/// <code>PendingValidation</code>
/// </b> - Lightsail couldn't
/// automatically validate one or more domain names in the certificate. You must take action
/// to validate these domain names or the certificate won't be renewed. If you used DNS
/// validation, check to make sure your certificate's domain validation records exist in your
/// domain's DNS, and that your certificate remains in use.</p>
/// </li>
/// <li>
/// <p>
/// <b>
/// <code>Success</code>
/// </b> - All domain names in the
/// certificate are validated, and Lightsail renewed the certificate. No further action is
/// required. </p>
/// </li>
/// <li>
/// <p>
/// <b>
/// <code>Failed</code>
/// </b> - One or more domain names were
/// not validated before the certificate expired, and Lightsail did not renew the
/// certificate. You can request a new certificate using the <code>CreateCertificate</code>
/// action.</p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoadBalancerTlsCertificateRenewalSummary {
    /// <p>The renewal status of the certificate.</p>
    /// <p>The following renewal status are possible:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>PendingAutoRenewal</code>
    /// </b> - Lightsail is
    /// attempting to automatically validate the domain names of the certificate. No further
    /// action is required. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>PendingValidation</code>
    /// </b> - Lightsail couldn't
    /// automatically validate one or more domain names of the certificate. You must take action
    /// to validate these domain names or the certificate won't be renewed. Check to make sure
    /// your certificate's domain validation records exist in your domain's DNS, and that your
    /// certificate remains in use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Success</code>
    /// </b> - All domain names in the
    /// certificate are validated, and Lightsail renewed the certificate. No further action is
    /// required. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Failed</code>
    /// </b> - One or more domain names were
    /// not validated before the certificate expired, and Lightsail did not renew the
    /// certificate. You can request a new certificate using the <code>CreateCertificate</code>
    /// action.</p>
    /// </li>
    /// </ul>
    pub renewal_status: std::option::Option<crate::model::LoadBalancerTlsCertificateRenewalStatus>,
    /// <p>Contains information about the validation of each domain name in the certificate, as it
    /// pertains to Lightsail's managed renewal. This is different from the initial validation that
    /// occurs as a result of the RequestCertificate request.</p>
    pub domain_validation_options: std::option::Option<
        std::vec::Vec<crate::model::LoadBalancerTlsCertificateDomainValidationOption>,
    >,
}
impl std::fmt::Debug for LoadBalancerTlsCertificateRenewalSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoadBalancerTlsCertificateRenewalSummary");
        formatter.field("renewal_status", &self.renewal_status);
        formatter.field("domain_validation_options", &self.domain_validation_options);
        formatter.finish()
    }
}
/// See [`LoadBalancerTlsCertificateRenewalSummary`](crate::model::LoadBalancerTlsCertificateRenewalSummary)
pub mod load_balancer_tls_certificate_renewal_summary {
    /// A builder for [`LoadBalancerTlsCertificateRenewalSummary`](crate::model::LoadBalancerTlsCertificateRenewalSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) renewal_status:
            std::option::Option<crate::model::LoadBalancerTlsCertificateRenewalStatus>,
        pub(crate) domain_validation_options: std::option::Option<
            std::vec::Vec<crate::model::LoadBalancerTlsCertificateDomainValidationOption>,
        >,
    }
    impl Builder {
        /// <p>The renewal status of the certificate.</p>
        /// <p>The following renewal status are possible:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PendingAutoRenewal</code>
        /// </b> - Lightsail is
        /// attempting to automatically validate the domain names of the certificate. No further
        /// action is required. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PendingValidation</code>
        /// </b> - Lightsail couldn't
        /// automatically validate one or more domain names of the certificate. You must take action
        /// to validate these domain names or the certificate won't be renewed. Check to make sure
        /// your certificate's domain validation records exist in your domain's DNS, and that your
        /// certificate remains in use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Success</code>
        /// </b> - All domain names in the
        /// certificate are validated, and Lightsail renewed the certificate. No further action is
        /// required. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Failed</code>
        /// </b> - One or more domain names were
        /// not validated before the certificate expired, and Lightsail did not renew the
        /// certificate. You can request a new certificate using the <code>CreateCertificate</code>
        /// action.</p>
        /// </li>
        /// </ul>
        pub fn renewal_status(
            mut self,
            input: crate::model::LoadBalancerTlsCertificateRenewalStatus,
        ) -> Self {
            self.renewal_status = Some(input);
            self
        }
        /// <p>The renewal status of the certificate.</p>
        /// <p>The following renewal status are possible:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PendingAutoRenewal</code>
        /// </b> - Lightsail is
        /// attempting to automatically validate the domain names of the certificate. No further
        /// action is required. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PendingValidation</code>
        /// </b> - Lightsail couldn't
        /// automatically validate one or more domain names of the certificate. You must take action
        /// to validate these domain names or the certificate won't be renewed. Check to make sure
        /// your certificate's domain validation records exist in your domain's DNS, and that your
        /// certificate remains in use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Success</code>
        /// </b> - All domain names in the
        /// certificate are validated, and Lightsail renewed the certificate. No further action is
        /// required. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Failed</code>
        /// </b> - One or more domain names were
        /// not validated before the certificate expired, and Lightsail did not renew the
        /// certificate. You can request a new certificate using the <code>CreateCertificate</code>
        /// action.</p>
        /// </li>
        /// </ul>
        pub fn set_renewal_status(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerTlsCertificateRenewalStatus>,
        ) -> Self {
            self.renewal_status = input;
            self
        }
        /// Appends an item to `domain_validation_options`.
        ///
        /// To override the contents of this collection use [`set_domain_validation_options`](Self::set_domain_validation_options).
        ///
        /// <p>Contains information about the validation of each domain name in the certificate, as it
        /// pertains to Lightsail's managed renewal. This is different from the initial validation that
        /// occurs as a result of the RequestCertificate request.</p>
        pub fn domain_validation_options(
            mut self,
            input: impl Into<crate::model::LoadBalancerTlsCertificateDomainValidationOption>,
        ) -> Self {
            let mut v = self.domain_validation_options.unwrap_or_default();
            v.push(input.into());
            self.domain_validation_options = Some(v);
            self
        }
        /// <p>Contains information about the validation of each domain name in the certificate, as it
        /// pertains to Lightsail's managed renewal. This is different from the initial validation that
        /// occurs as a result of the RequestCertificate request.</p>
        pub fn set_domain_validation_options(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::LoadBalancerTlsCertificateDomainValidationOption>,
            >,
        ) -> Self {
            self.domain_validation_options = input;
            self
        }
        /// Consumes the builder and constructs a [`LoadBalancerTlsCertificateRenewalSummary`](crate::model::LoadBalancerTlsCertificateRenewalSummary)
        pub fn build(self) -> crate::model::LoadBalancerTlsCertificateRenewalSummary {
            crate::model::LoadBalancerTlsCertificateRenewalSummary {
                renewal_status: self.renewal_status,
                domain_validation_options: self.domain_validation_options,
            }
        }
    }
}
impl LoadBalancerTlsCertificateRenewalSummary {
    /// Creates a new builder-style object to manufacture [`LoadBalancerTlsCertificateRenewalSummary`](crate::model::LoadBalancerTlsCertificateRenewalSummary)
    pub fn builder() -> crate::model::load_balancer_tls_certificate_renewal_summary::Builder {
        crate::model::load_balancer_tls_certificate_renewal_summary::Builder::default()
    }
}

/// <p>Contains information about the domain names on an SSL/TLS certificate that you will use to
/// validate domain ownership.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoadBalancerTlsCertificateDomainValidationOption {
    /// <p>The fully qualified domain name in the certificate request.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The status of the domain validation. Valid values are listed below.</p>
    pub validation_status:
        std::option::Option<crate::model::LoadBalancerTlsCertificateDomainStatus>,
}
impl std::fmt::Debug for LoadBalancerTlsCertificateDomainValidationOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoadBalancerTlsCertificateDomainValidationOption");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("validation_status", &self.validation_status);
        formatter.finish()
    }
}
/// See [`LoadBalancerTlsCertificateDomainValidationOption`](crate::model::LoadBalancerTlsCertificateDomainValidationOption)
pub mod load_balancer_tls_certificate_domain_validation_option {
    /// A builder for [`LoadBalancerTlsCertificateDomainValidationOption`](crate::model::LoadBalancerTlsCertificateDomainValidationOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) validation_status:
            std::option::Option<crate::model::LoadBalancerTlsCertificateDomainStatus>,
    }
    impl Builder {
        /// <p>The fully qualified domain name in the certificate request.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The fully qualified domain name in the certificate request.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The status of the domain validation. Valid values are listed below.</p>
        pub fn validation_status(
            mut self,
            input: crate::model::LoadBalancerTlsCertificateDomainStatus,
        ) -> Self {
            self.validation_status = Some(input);
            self
        }
        /// <p>The status of the domain validation. Valid values are listed below.</p>
        pub fn set_validation_status(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerTlsCertificateDomainStatus>,
        ) -> Self {
            self.validation_status = input;
            self
        }
        /// Consumes the builder and constructs a [`LoadBalancerTlsCertificateDomainValidationOption`](crate::model::LoadBalancerTlsCertificateDomainValidationOption)
        pub fn build(self) -> crate::model::LoadBalancerTlsCertificateDomainValidationOption {
            crate::model::LoadBalancerTlsCertificateDomainValidationOption {
                domain_name: self.domain_name,
                validation_status: self.validation_status,
            }
        }
    }
}
impl LoadBalancerTlsCertificateDomainValidationOption {
    /// Creates a new builder-style object to manufacture [`LoadBalancerTlsCertificateDomainValidationOption`](crate::model::LoadBalancerTlsCertificateDomainValidationOption)
    pub fn builder() -> crate::model::load_balancer_tls_certificate_domain_validation_option::Builder
    {
        crate::model::load_balancer_tls_certificate_domain_validation_option::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LoadBalancerTlsCertificateDomainStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    PendingValidation,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LoadBalancerTlsCertificateDomainStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => LoadBalancerTlsCertificateDomainStatus::Failed,
            "PENDING_VALIDATION" => LoadBalancerTlsCertificateDomainStatus::PendingValidation,
            "SUCCESS" => LoadBalancerTlsCertificateDomainStatus::Success,
            other => LoadBalancerTlsCertificateDomainStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LoadBalancerTlsCertificateDomainStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LoadBalancerTlsCertificateDomainStatus::from(s))
    }
}
impl LoadBalancerTlsCertificateDomainStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LoadBalancerTlsCertificateDomainStatus::Failed => "FAILED",
            LoadBalancerTlsCertificateDomainStatus::PendingValidation => "PENDING_VALIDATION",
            LoadBalancerTlsCertificateDomainStatus::Success => "SUCCESS",
            LoadBalancerTlsCertificateDomainStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILED", "PENDING_VALIDATION", "SUCCESS"]
    }
}
impl AsRef<str> for LoadBalancerTlsCertificateDomainStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LoadBalancerTlsCertificateRenewalStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    PendingAutoRenewal,
    #[allow(missing_docs)] // documentation missing in model
    PendingValidation,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LoadBalancerTlsCertificateRenewalStatus {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => LoadBalancerTlsCertificateRenewalStatus::Failed,
            "PENDING_AUTO_RENEWAL" => LoadBalancerTlsCertificateRenewalStatus::PendingAutoRenewal,
            "PENDING_VALIDATION" => LoadBalancerTlsCertificateRenewalStatus::PendingValidation,
            "SUCCESS" => LoadBalancerTlsCertificateRenewalStatus::Success,
            other => LoadBalancerTlsCertificateRenewalStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LoadBalancerTlsCertificateRenewalStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LoadBalancerTlsCertificateRenewalStatus::from(s))
    }
}
impl LoadBalancerTlsCertificateRenewalStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LoadBalancerTlsCertificateRenewalStatus::Failed => "FAILED",
            LoadBalancerTlsCertificateRenewalStatus::PendingAutoRenewal => "PENDING_AUTO_RENEWAL",
            LoadBalancerTlsCertificateRenewalStatus::PendingValidation => "PENDING_VALIDATION",
            LoadBalancerTlsCertificateRenewalStatus::Success => "SUCCESS",
            LoadBalancerTlsCertificateRenewalStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FAILED",
            "PENDING_AUTO_RENEWAL",
            "PENDING_VALIDATION",
            "SUCCESS",
        ]
    }
}
impl AsRef<str> for LoadBalancerTlsCertificateRenewalStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LoadBalancerTlsCertificateFailureReason {
    #[allow(missing_docs)] // documentation missing in model
    AdditionalVerificationRequired,
    #[allow(missing_docs)] // documentation missing in model
    DomainNotAllowed,
    #[allow(missing_docs)] // documentation missing in model
    InvalidPublicDomain,
    #[allow(missing_docs)] // documentation missing in model
    NoAvailableContacts,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LoadBalancerTlsCertificateFailureReason {
    fn from(s: &str) -> Self {
        match s {
            "ADDITIONAL_VERIFICATION_REQUIRED" => {
                LoadBalancerTlsCertificateFailureReason::AdditionalVerificationRequired
            }
            "DOMAIN_NOT_ALLOWED" => LoadBalancerTlsCertificateFailureReason::DomainNotAllowed,
            "INVALID_PUBLIC_DOMAIN" => LoadBalancerTlsCertificateFailureReason::InvalidPublicDomain,
            "NO_AVAILABLE_CONTACTS" => LoadBalancerTlsCertificateFailureReason::NoAvailableContacts,
            "OTHER" => LoadBalancerTlsCertificateFailureReason::Other,
            other => LoadBalancerTlsCertificateFailureReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LoadBalancerTlsCertificateFailureReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LoadBalancerTlsCertificateFailureReason::from(s))
    }
}
impl LoadBalancerTlsCertificateFailureReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LoadBalancerTlsCertificateFailureReason::AdditionalVerificationRequired => {
                "ADDITIONAL_VERIFICATION_REQUIRED"
            }
            LoadBalancerTlsCertificateFailureReason::DomainNotAllowed => "DOMAIN_NOT_ALLOWED",
            LoadBalancerTlsCertificateFailureReason::InvalidPublicDomain => "INVALID_PUBLIC_DOMAIN",
            LoadBalancerTlsCertificateFailureReason::NoAvailableContacts => "NO_AVAILABLE_CONTACTS",
            LoadBalancerTlsCertificateFailureReason::Other => "OTHER",
            LoadBalancerTlsCertificateFailureReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDITIONAL_VERIFICATION_REQUIRED",
            "DOMAIN_NOT_ALLOWED",
            "INVALID_PUBLIC_DOMAIN",
            "NO_AVAILABLE_CONTACTS",
            "OTHER",
        ]
    }
}
impl AsRef<str> for LoadBalancerTlsCertificateFailureReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the validation record of each domain name in the SSL/TLS certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoadBalancerTlsCertificateDomainValidationRecord {
    /// <p>A fully qualified domain name in the certificate. For example,
    /// <code>example.com</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of validation record. For example, <code>CNAME</code> for domain
    /// validation.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The value for that type.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The validation status. Valid values are listed below.</p>
    pub validation_status:
        std::option::Option<crate::model::LoadBalancerTlsCertificateDomainStatus>,
    /// <p>The domain name against which your SSL/TLS certificate was validated.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LoadBalancerTlsCertificateDomainValidationRecord {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoadBalancerTlsCertificateDomainValidationRecord");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("value", &self.value);
        formatter.field("validation_status", &self.validation_status);
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}
/// See [`LoadBalancerTlsCertificateDomainValidationRecord`](crate::model::LoadBalancerTlsCertificateDomainValidationRecord)
pub mod load_balancer_tls_certificate_domain_validation_record {
    /// A builder for [`LoadBalancerTlsCertificateDomainValidationRecord`](crate::model::LoadBalancerTlsCertificateDomainValidationRecord)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) validation_status:
            std::option::Option<crate::model::LoadBalancerTlsCertificateDomainStatus>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A fully qualified domain name in the certificate. For example,
        /// <code>example.com</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A fully qualified domain name in the certificate. For example,
        /// <code>example.com</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of validation record. For example, <code>CNAME</code> for domain
        /// validation.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of validation record. For example, <code>CNAME</code> for domain
        /// validation.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The value for that type.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value for that type.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The validation status. Valid values are listed below.</p>
        pub fn validation_status(
            mut self,
            input: crate::model::LoadBalancerTlsCertificateDomainStatus,
        ) -> Self {
            self.validation_status = Some(input);
            self
        }
        /// <p>The validation status. Valid values are listed below.</p>
        pub fn set_validation_status(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerTlsCertificateDomainStatus>,
        ) -> Self {
            self.validation_status = input;
            self
        }
        /// <p>The domain name against which your SSL/TLS certificate was validated.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name against which your SSL/TLS certificate was validated.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`LoadBalancerTlsCertificateDomainValidationRecord`](crate::model::LoadBalancerTlsCertificateDomainValidationRecord)
        pub fn build(self) -> crate::model::LoadBalancerTlsCertificateDomainValidationRecord {
            crate::model::LoadBalancerTlsCertificateDomainValidationRecord {
                name: self.name,
                r#type: self.r#type,
                value: self.value,
                validation_status: self.validation_status,
                domain_name: self.domain_name,
            }
        }
    }
}
impl LoadBalancerTlsCertificateDomainValidationRecord {
    /// Creates a new builder-style object to manufacture [`LoadBalancerTlsCertificateDomainValidationRecord`](crate::model::LoadBalancerTlsCertificateDomainValidationRecord)
    pub fn builder() -> crate::model::load_balancer_tls_certificate_domain_validation_record::Builder
    {
        crate::model::load_balancer_tls_certificate_domain_validation_record::Builder::default()
    }
}

/// _Note: `LoadBalancerTlsCertificateStatus::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LoadBalancerTlsCertificateStatus {
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    #[allow(missing_docs)] // documentation missing in model
    Issued,
    #[allow(missing_docs)] // documentation missing in model
    PendingValidation,
    #[allow(missing_docs)] // documentation missing in model
    Revoked,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    #[allow(missing_docs)] // documentation missing in model
    ValidationTimedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LoadBalancerTlsCertificateStatus {
    fn from(s: &str) -> Self {
        match s {
            "EXPIRED" => LoadBalancerTlsCertificateStatus::Expired,
            "FAILED" => LoadBalancerTlsCertificateStatus::Failed,
            "INACTIVE" => LoadBalancerTlsCertificateStatus::Inactive,
            "ISSUED" => LoadBalancerTlsCertificateStatus::Issued,
            "PENDING_VALIDATION" => LoadBalancerTlsCertificateStatus::PendingValidation,
            "REVOKED" => LoadBalancerTlsCertificateStatus::Revoked,
            "UNKNOWN" => LoadBalancerTlsCertificateStatus::UnknownValue,
            "VALIDATION_TIMED_OUT" => LoadBalancerTlsCertificateStatus::ValidationTimedOut,
            other => LoadBalancerTlsCertificateStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LoadBalancerTlsCertificateStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LoadBalancerTlsCertificateStatus::from(s))
    }
}
impl LoadBalancerTlsCertificateStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LoadBalancerTlsCertificateStatus::Expired => "EXPIRED",
            LoadBalancerTlsCertificateStatus::Failed => "FAILED",
            LoadBalancerTlsCertificateStatus::Inactive => "INACTIVE",
            LoadBalancerTlsCertificateStatus::Issued => "ISSUED",
            LoadBalancerTlsCertificateStatus::PendingValidation => "PENDING_VALIDATION",
            LoadBalancerTlsCertificateStatus::Revoked => "REVOKED",
            LoadBalancerTlsCertificateStatus::UnknownValue => "UNKNOWN",
            LoadBalancerTlsCertificateStatus::ValidationTimedOut => "VALIDATION_TIMED_OUT",
            LoadBalancerTlsCertificateStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EXPIRED",
            "FAILED",
            "INACTIVE",
            "ISSUED",
            "PENDING_VALIDATION",
            "REVOKED",
            "UNKNOWN",
            "VALIDATION_TIMED_OUT",
        ]
    }
}
impl AsRef<str> for LoadBalancerTlsCertificateStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a load balancer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoadBalancer {
    /// <p>The name of the load balancer (e.g., <code>my-load-balancer</code>).</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The support code. Include this code in your email to support when you have questions about
    /// your Lightsail load balancer. This code enables our support team to look up your Lightsail
    /// information more easily.</p>
    pub support_code: std::option::Option<std::string::String>,
    /// <p>The date when your load balancer was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The AWS Region where your load balancer was created (e.g., <code>us-east-2a</code>).
    /// Lightsail automatically creates your load balancer across Availability Zones.</p>
    pub location: std::option::Option<crate::model::ResourceLocation>,
    /// <p>The resource type (e.g., <code>LoadBalancer</code>.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The tag keys and optional values for the resource. For more information about tags in
    /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The DNS name of your Lightsail load balancer.</p>
    pub dns_name: std::option::Option<std::string::String>,
    /// <p>The status of your load balancer. Valid values are below.</p>
    pub state: std::option::Option<crate::model::LoadBalancerState>,
    /// <p>The protocol you have enabled for your load balancer. Valid values are below.</p>
    /// <p>You can't just have <code>HTTP_HTTPS</code>, but you can have just
    /// <code>HTTP</code>.</p>
    pub protocol: std::option::Option<crate::model::LoadBalancerProtocol>,
    /// <p>An array of public port settings for your load balancer. For HTTP, use port 80. For HTTPS,
    /// use port 443.</p>
    pub public_ports: std::option::Option<std::vec::Vec<i32>>,
    /// <p>The path you specified to perform your health checks. If no path is specified, the load
    /// balancer tries to make a request to the default (root) page.</p>
    pub health_check_path: std::option::Option<std::string::String>,
    /// <p>The port where the load balancer will direct traffic to your Lightsail instances. For
    /// HTTP traffic, it's port 80. For HTTPS traffic, it's port 443.</p>
    pub instance_port: std::option::Option<i32>,
    /// <p>An array of InstanceHealthSummary objects describing the health of the load
    /// balancer.</p>
    pub instance_health_summary:
        std::option::Option<std::vec::Vec<crate::model::InstanceHealthSummary>>,
    /// <p>An array of LoadBalancerTlsCertificateSummary objects that provide additional information
    /// about the SSL/TLS certificates. For example, if <code>true</code>, the certificate is attached
    /// to the load balancer.</p>
    pub tls_certificate_summaries:
        std::option::Option<std::vec::Vec<crate::model::LoadBalancerTlsCertificateSummary>>,
    /// <p>A string to string map of the configuration options for your load balancer. Valid values
    /// are listed below.</p>
    pub configuration_options: std::option::Option<
        std::collections::HashMap<crate::model::LoadBalancerAttributeName, std::string::String>,
    >,
    /// <p>The IP address type of the load balancer.</p>
    ///
    /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for
    /// IPv4 and IPv6.</p>
    pub ip_address_type: std::option::Option<crate::model::IpAddressType>,
}
impl std::fmt::Debug for LoadBalancer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoadBalancer");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("support_code", &self.support_code);
        formatter.field("created_at", &self.created_at);
        formatter.field("location", &self.location);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("tags", &self.tags);
        formatter.field("dns_name", &self.dns_name);
        formatter.field("state", &self.state);
        formatter.field("protocol", &self.protocol);
        formatter.field("public_ports", &self.public_ports);
        formatter.field("health_check_path", &self.health_check_path);
        formatter.field("instance_port", &self.instance_port);
        formatter.field("instance_health_summary", &self.instance_health_summary);
        formatter.field("tls_certificate_summaries", &self.tls_certificate_summaries);
        formatter.field("configuration_options", &self.configuration_options);
        formatter.field("ip_address_type", &self.ip_address_type);
        formatter.finish()
    }
}
/// See [`LoadBalancer`](crate::model::LoadBalancer)
pub mod load_balancer {
    /// A builder for [`LoadBalancer`](crate::model::LoadBalancer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) support_code: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) location: std::option::Option<crate::model::ResourceLocation>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) dns_name: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::LoadBalancerState>,
        pub(crate) protocol: std::option::Option<crate::model::LoadBalancerProtocol>,
        pub(crate) public_ports: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) health_check_path: std::option::Option<std::string::String>,
        pub(crate) instance_port: std::option::Option<i32>,
        pub(crate) instance_health_summary:
            std::option::Option<std::vec::Vec<crate::model::InstanceHealthSummary>>,
        pub(crate) tls_certificate_summaries:
            std::option::Option<std::vec::Vec<crate::model::LoadBalancerTlsCertificateSummary>>,
        pub(crate) configuration_options: std::option::Option<
            std::collections::HashMap<crate::model::LoadBalancerAttributeName, std::string::String>,
        >,
        pub(crate) ip_address_type: std::option::Option<crate::model::IpAddressType>,
    }
    impl Builder {
        /// <p>The name of the load balancer (e.g., <code>my-load-balancer</code>).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the load balancer (e.g., <code>my-load-balancer</code>).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the load balancer.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// your Lightsail load balancer. This code enables our support team to look up your Lightsail
        /// information more easily.</p>
        pub fn support_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_code = Some(input.into());
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// your Lightsail load balancer. This code enables our support team to look up your Lightsail
        /// information more easily.</p>
        pub fn set_support_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.support_code = input;
            self
        }
        /// <p>The date when your load balancer was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date when your load balancer was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The AWS Region where your load balancer was created (e.g., <code>us-east-2a</code>).
        /// Lightsail automatically creates your load balancer across Availability Zones.</p>
        pub fn location(mut self, input: crate::model::ResourceLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The AWS Region where your load balancer was created (e.g., <code>us-east-2a</code>).
        /// Lightsail automatically creates your load balancer across Availability Zones.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::ResourceLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>The resource type (e.g., <code>LoadBalancer</code>.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The resource type (e.g., <code>LoadBalancer</code>.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The DNS name of your Lightsail load balancer.</p>
        pub fn dns_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_name = Some(input.into());
            self
        }
        /// <p>The DNS name of your Lightsail load balancer.</p>
        pub fn set_dns_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dns_name = input;
            self
        }
        /// <p>The status of your load balancer. Valid values are below.</p>
        pub fn state(mut self, input: crate::model::LoadBalancerState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The status of your load balancer. Valid values are below.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The protocol you have enabled for your load balancer. Valid values are below.</p>
        /// <p>You can't just have <code>HTTP_HTTPS</code>, but you can have just
        /// <code>HTTP</code>.</p>
        pub fn protocol(mut self, input: crate::model::LoadBalancerProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol you have enabled for your load balancer. Valid values are below.</p>
        /// <p>You can't just have <code>HTTP_HTTPS</code>, but you can have just
        /// <code>HTTP</code>.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::LoadBalancerProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// Appends an item to `public_ports`.
        ///
        /// To override the contents of this collection use [`set_public_ports`](Self::set_public_ports).
        ///
        /// <p>An array of public port settings for your load balancer. For HTTP, use port 80. For HTTPS,
        /// use port 443.</p>
        pub fn public_ports(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.public_ports.unwrap_or_default();
            v.push(input.into());
            self.public_ports = Some(v);
            self
        }
        /// <p>An array of public port settings for your load balancer. For HTTP, use port 80. For HTTPS,
        /// use port 443.</p>
        pub fn set_public_ports(mut self, input: std::option::Option<std::vec::Vec<i32>>) -> Self {
            self.public_ports = input;
            self
        }
        /// <p>The path you specified to perform your health checks. If no path is specified, the load
        /// balancer tries to make a request to the default (root) page.</p>
        pub fn health_check_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.health_check_path = Some(input.into());
            self
        }
        /// <p>The path you specified to perform your health checks. If no path is specified, the load
        /// balancer tries to make a request to the default (root) page.</p>
        pub fn set_health_check_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.health_check_path = input;
            self
        }
        /// <p>The port where the load balancer will direct traffic to your Lightsail instances. For
        /// HTTP traffic, it's port 80. For HTTPS traffic, it's port 443.</p>
        pub fn instance_port(mut self, input: i32) -> Self {
            self.instance_port = Some(input);
            self
        }
        /// <p>The port where the load balancer will direct traffic to your Lightsail instances. For
        /// HTTP traffic, it's port 80. For HTTPS traffic, it's port 443.</p>
        pub fn set_instance_port(mut self, input: std::option::Option<i32>) -> Self {
            self.instance_port = input;
            self
        }
        /// Appends an item to `instance_health_summary`.
        ///
        /// To override the contents of this collection use [`set_instance_health_summary`](Self::set_instance_health_summary).
        ///
        /// <p>An array of InstanceHealthSummary objects describing the health of the load
        /// balancer.</p>
        pub fn instance_health_summary(
            mut self,
            input: impl Into<crate::model::InstanceHealthSummary>,
        ) -> Self {
            let mut v = self.instance_health_summary.unwrap_or_default();
            v.push(input.into());
            self.instance_health_summary = Some(v);
            self
        }
        /// <p>An array of InstanceHealthSummary objects describing the health of the load
        /// balancer.</p>
        pub fn set_instance_health_summary(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstanceHealthSummary>>,
        ) -> Self {
            self.instance_health_summary = input;
            self
        }
        /// Appends an item to `tls_certificate_summaries`.
        ///
        /// To override the contents of this collection use [`set_tls_certificate_summaries`](Self::set_tls_certificate_summaries).
        ///
        /// <p>An array of LoadBalancerTlsCertificateSummary objects that provide additional information
        /// about the SSL/TLS certificates. For example, if <code>true</code>, the certificate is attached
        /// to the load balancer.</p>
        pub fn tls_certificate_summaries(
            mut self,
            input: impl Into<crate::model::LoadBalancerTlsCertificateSummary>,
        ) -> Self {
            let mut v = self.tls_certificate_summaries.unwrap_or_default();
            v.push(input.into());
            self.tls_certificate_summaries = Some(v);
            self
        }
        /// <p>An array of LoadBalancerTlsCertificateSummary objects that provide additional information
        /// about the SSL/TLS certificates. For example, if <code>true</code>, the certificate is attached
        /// to the load balancer.</p>
        pub fn set_tls_certificate_summaries(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::LoadBalancerTlsCertificateSummary>,
            >,
        ) -> Self {
            self.tls_certificate_summaries = input;
            self
        }
        /// Adds a key-value pair to `configuration_options`.
        ///
        /// To override the contents of this collection use [`set_configuration_options`](Self::set_configuration_options).
        ///
        /// <p>A string to string map of the configuration options for your load balancer. Valid values
        /// are listed below.</p>
        pub fn configuration_options(
            mut self,
            k: impl Into<crate::model::LoadBalancerAttributeName>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.configuration_options.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.configuration_options = Some(hash_map);
            self
        }
        /// <p>A string to string map of the configuration options for your load balancer. Valid values
        /// are listed below.</p>
        pub fn set_configuration_options(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::LoadBalancerAttributeName,
                    std::string::String,
                >,
            >,
        ) -> Self {
            self.configuration_options = input;
            self
        }
        /// <p>The IP address type of the load balancer.</p>
        ///
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for
        /// IPv4 and IPv6.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.ip_address_type = Some(input);
            self
        }
        /// <p>The IP address type of the load balancer.</p>
        ///
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for
        /// IPv4 and IPv6.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.ip_address_type = input;
            self
        }
        /// Consumes the builder and constructs a [`LoadBalancer`](crate::model::LoadBalancer)
        pub fn build(self) -> crate::model::LoadBalancer {
            crate::model::LoadBalancer {
                name: self.name,
                arn: self.arn,
                support_code: self.support_code,
                created_at: self.created_at,
                location: self.location,
                resource_type: self.resource_type,
                tags: self.tags,
                dns_name: self.dns_name,
                state: self.state,
                protocol: self.protocol,
                public_ports: self.public_ports,
                health_check_path: self.health_check_path,
                instance_port: self.instance_port,
                instance_health_summary: self.instance_health_summary,
                tls_certificate_summaries: self.tls_certificate_summaries,
                configuration_options: self.configuration_options,
                ip_address_type: self.ip_address_type,
            }
        }
    }
}
impl LoadBalancer {
    /// Creates a new builder-style object to manufacture [`LoadBalancer`](crate::model::LoadBalancer)
    pub fn builder() -> crate::model::load_balancer::Builder {
        crate::model::load_balancer::Builder::default()
    }
}

/// <p>Provides a summary of SSL/TLS certificate metadata.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LoadBalancerTlsCertificateSummary {
    /// <p>The name of the SSL/TLS certificate.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>When <code>true</code>, the SSL/TLS certificate is attached to the Lightsail load
    /// balancer.</p>
    pub is_attached: std::option::Option<bool>,
}
impl std::fmt::Debug for LoadBalancerTlsCertificateSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LoadBalancerTlsCertificateSummary");
        formatter.field("name", &self.name);
        formatter.field("is_attached", &self.is_attached);
        formatter.finish()
    }
}
/// See [`LoadBalancerTlsCertificateSummary`](crate::model::LoadBalancerTlsCertificateSummary)
pub mod load_balancer_tls_certificate_summary {
    /// A builder for [`LoadBalancerTlsCertificateSummary`](crate::model::LoadBalancerTlsCertificateSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) is_attached: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the SSL/TLS certificate.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the SSL/TLS certificate.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>When <code>true</code>, the SSL/TLS certificate is attached to the Lightsail load
        /// balancer.</p>
        pub fn is_attached(mut self, input: bool) -> Self {
            self.is_attached = Some(input);
            self
        }
        /// <p>When <code>true</code>, the SSL/TLS certificate is attached to the Lightsail load
        /// balancer.</p>
        pub fn set_is_attached(mut self, input: std::option::Option<bool>) -> Self {
            self.is_attached = input;
            self
        }
        /// Consumes the builder and constructs a [`LoadBalancerTlsCertificateSummary`](crate::model::LoadBalancerTlsCertificateSummary)
        pub fn build(self) -> crate::model::LoadBalancerTlsCertificateSummary {
            crate::model::LoadBalancerTlsCertificateSummary {
                name: self.name,
                is_attached: self.is_attached,
            }
        }
    }
}
impl LoadBalancerTlsCertificateSummary {
    /// Creates a new builder-style object to manufacture [`LoadBalancerTlsCertificateSummary`](crate::model::LoadBalancerTlsCertificateSummary)
    pub fn builder() -> crate::model::load_balancer_tls_certificate_summary::Builder {
        crate::model::load_balancer_tls_certificate_summary::Builder::default()
    }
}

/// <p>Describes information about the health of the instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceHealthSummary {
    /// <p>The name of the Lightsail instance for which you are requesting health check
    /// data.</p>
    pub instance_name: std::option::Option<std::string::String>,
    /// <p>Describes the overall instance health. Valid values are below.</p>
    pub instance_health: std::option::Option<crate::model::InstanceHealthState>,
    /// <p>More information about the instance health. If the <code>instanceHealth</code> is
    /// <code>healthy</code>, then an <code>instanceHealthReason</code> value is not
    /// provided.</p>
    /// <p>If <b>
    /// <code>instanceHealth</code>
    /// </b> is <code>initial</code>,
    /// the <b>
    /// <code>instanceHealthReason</code>
    /// </b> value can be one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Lb.RegistrationInProgress</code>
    /// </b> - The target
    /// instance is in the process of being registered with the load balancer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Lb.InitialHealthChecking</code>
    /// </b> - The
    /// Lightsail load balancer is still sending the target instance the minimum number of
    /// health checks required to determine its health status.</p>
    /// </li>
    /// </ul>
    /// <p>If <b>
    /// <code>instanceHealth</code>
    /// </b> is <code>unhealthy</code>,
    /// the <b>
    /// <code>instanceHealthReason</code>
    /// </b> value can be one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Instance.ResponseCodeMismatch</code>
    /// </b> - The
    /// health checks did not return an expected HTTP code.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Instance.Timeout</code>
    /// </b> - The health check
    /// requests timed out.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Instance.FailedHealthChecks</code>
    /// </b> - The health
    /// checks failed because the connection to the target instance timed out, the target instance
    /// response was malformed, or the target instance failed the health check for an unknown
    /// reason.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Lb.InternalError</code>
    /// </b> - The health checks
    /// failed due to an internal error.</p>
    /// </li>
    /// </ul>
    /// <p>If <b>
    /// <code>instanceHealth</code>
    /// </b> is <code>unused</code>,
    /// the <b>
    /// <code>instanceHealthReason</code>
    /// </b> value can be one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Instance.NotRegistered</code>
    /// </b> - The target
    /// instance is not registered with the target group.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Instance.NotInUse</code>
    /// </b> - The target group is
    /// not used by any load balancer, or the target instance is in an Availability Zone that is
    /// not enabled for its load balancer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Instance.IpUnusable</code>
    /// </b> - The target IP
    /// address is reserved for use by a Lightsail load balancer.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Instance.InvalidState</code>
    /// </b> - The target is in
    /// the stopped or terminated state.</p>
    /// </li>
    /// </ul>
    /// <p>If <b>
    /// <code>instanceHealth</code>
    /// </b> is <code>draining</code>,
    /// the <b>
    /// <code>instanceHealthReason</code>
    /// </b> value can be one of the
    /// following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Instance.DeregistrationInProgress</code>
    /// </b> - The
    /// target instance is in the process of being deregistered and the deregistration delay
    /// period has not expired.</p>
    /// </li>
    /// </ul>
    pub instance_health_reason: std::option::Option<crate::model::InstanceHealthReason>,
}
impl std::fmt::Debug for InstanceHealthSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceHealthSummary");
        formatter.field("instance_name", &self.instance_name);
        formatter.field("instance_health", &self.instance_health);
        formatter.field("instance_health_reason", &self.instance_health_reason);
        formatter.finish()
    }
}
/// See [`InstanceHealthSummary`](crate::model::InstanceHealthSummary)
pub mod instance_health_summary {
    /// A builder for [`InstanceHealthSummary`](crate::model::InstanceHealthSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_name: std::option::Option<std::string::String>,
        pub(crate) instance_health: std::option::Option<crate::model::InstanceHealthState>,
        pub(crate) instance_health_reason: std::option::Option<crate::model::InstanceHealthReason>,
    }
    impl Builder {
        /// <p>The name of the Lightsail instance for which you are requesting health check
        /// data.</p>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_name = Some(input.into());
            self
        }
        /// <p>The name of the Lightsail instance for which you are requesting health check
        /// data.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_name = input;
            self
        }
        /// <p>Describes the overall instance health. Valid values are below.</p>
        pub fn instance_health(mut self, input: crate::model::InstanceHealthState) -> Self {
            self.instance_health = Some(input);
            self
        }
        /// <p>Describes the overall instance health. Valid values are below.</p>
        pub fn set_instance_health(
            mut self,
            input: std::option::Option<crate::model::InstanceHealthState>,
        ) -> Self {
            self.instance_health = input;
            self
        }
        /// <p>More information about the instance health. If the <code>instanceHealth</code> is
        /// <code>healthy</code>, then an <code>instanceHealthReason</code> value is not
        /// provided.</p>
        /// <p>If <b>
        /// <code>instanceHealth</code>
        /// </b> is <code>initial</code>,
        /// the <b>
        /// <code>instanceHealthReason</code>
        /// </b> value can be one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Lb.RegistrationInProgress</code>
        /// </b> - The target
        /// instance is in the process of being registered with the load balancer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Lb.InitialHealthChecking</code>
        /// </b> - The
        /// Lightsail load balancer is still sending the target instance the minimum number of
        /// health checks required to determine its health status.</p>
        /// </li>
        /// </ul>
        /// <p>If <b>
        /// <code>instanceHealth</code>
        /// </b> is <code>unhealthy</code>,
        /// the <b>
        /// <code>instanceHealthReason</code>
        /// </b> value can be one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Instance.ResponseCodeMismatch</code>
        /// </b> - The
        /// health checks did not return an expected HTTP code.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Instance.Timeout</code>
        /// </b> - The health check
        /// requests timed out.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Instance.FailedHealthChecks</code>
        /// </b> - The health
        /// checks failed because the connection to the target instance timed out, the target instance
        /// response was malformed, or the target instance failed the health check for an unknown
        /// reason.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Lb.InternalError</code>
        /// </b> - The health checks
        /// failed due to an internal error.</p>
        /// </li>
        /// </ul>
        /// <p>If <b>
        /// <code>instanceHealth</code>
        /// </b> is <code>unused</code>,
        /// the <b>
        /// <code>instanceHealthReason</code>
        /// </b> value can be one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Instance.NotRegistered</code>
        /// </b> - The target
        /// instance is not registered with the target group.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Instance.NotInUse</code>
        /// </b> - The target group is
        /// not used by any load balancer, or the target instance is in an Availability Zone that is
        /// not enabled for its load balancer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Instance.IpUnusable</code>
        /// </b> - The target IP
        /// address is reserved for use by a Lightsail load balancer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Instance.InvalidState</code>
        /// </b> - The target is in
        /// the stopped or terminated state.</p>
        /// </li>
        /// </ul>
        /// <p>If <b>
        /// <code>instanceHealth</code>
        /// </b> is <code>draining</code>,
        /// the <b>
        /// <code>instanceHealthReason</code>
        /// </b> value can be one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Instance.DeregistrationInProgress</code>
        /// </b> - The
        /// target instance is in the process of being deregistered and the deregistration delay
        /// period has not expired.</p>
        /// </li>
        /// </ul>
        pub fn instance_health_reason(mut self, input: crate::model::InstanceHealthReason) -> Self {
            self.instance_health_reason = Some(input);
            self
        }
        /// <p>More information about the instance health. If the <code>instanceHealth</code> is
        /// <code>healthy</code>, then an <code>instanceHealthReason</code> value is not
        /// provided.</p>
        /// <p>If <b>
        /// <code>instanceHealth</code>
        /// </b> is <code>initial</code>,
        /// the <b>
        /// <code>instanceHealthReason</code>
        /// </b> value can be one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Lb.RegistrationInProgress</code>
        /// </b> - The target
        /// instance is in the process of being registered with the load balancer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Lb.InitialHealthChecking</code>
        /// </b> - The
        /// Lightsail load balancer is still sending the target instance the minimum number of
        /// health checks required to determine its health status.</p>
        /// </li>
        /// </ul>
        /// <p>If <b>
        /// <code>instanceHealth</code>
        /// </b> is <code>unhealthy</code>,
        /// the <b>
        /// <code>instanceHealthReason</code>
        /// </b> value can be one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Instance.ResponseCodeMismatch</code>
        /// </b> - The
        /// health checks did not return an expected HTTP code.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Instance.Timeout</code>
        /// </b> - The health check
        /// requests timed out.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Instance.FailedHealthChecks</code>
        /// </b> - The health
        /// checks failed because the connection to the target instance timed out, the target instance
        /// response was malformed, or the target instance failed the health check for an unknown
        /// reason.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Lb.InternalError</code>
        /// </b> - The health checks
        /// failed due to an internal error.</p>
        /// </li>
        /// </ul>
        /// <p>If <b>
        /// <code>instanceHealth</code>
        /// </b> is <code>unused</code>,
        /// the <b>
        /// <code>instanceHealthReason</code>
        /// </b> value can be one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Instance.NotRegistered</code>
        /// </b> - The target
        /// instance is not registered with the target group.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Instance.NotInUse</code>
        /// </b> - The target group is
        /// not used by any load balancer, or the target instance is in an Availability Zone that is
        /// not enabled for its load balancer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Instance.IpUnusable</code>
        /// </b> - The target IP
        /// address is reserved for use by a Lightsail load balancer.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Instance.InvalidState</code>
        /// </b> - The target is in
        /// the stopped or terminated state.</p>
        /// </li>
        /// </ul>
        /// <p>If <b>
        /// <code>instanceHealth</code>
        /// </b> is <code>draining</code>,
        /// the <b>
        /// <code>instanceHealthReason</code>
        /// </b> value can be one of the
        /// following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Instance.DeregistrationInProgress</code>
        /// </b> - The
        /// target instance is in the process of being deregistered and the deregistration delay
        /// period has not expired.</p>
        /// </li>
        /// </ul>
        pub fn set_instance_health_reason(
            mut self,
            input: std::option::Option<crate::model::InstanceHealthReason>,
        ) -> Self {
            self.instance_health_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceHealthSummary`](crate::model::InstanceHealthSummary)
        pub fn build(self) -> crate::model::InstanceHealthSummary {
            crate::model::InstanceHealthSummary {
                instance_name: self.instance_name,
                instance_health: self.instance_health,
                instance_health_reason: self.instance_health_reason,
            }
        }
    }
}
impl InstanceHealthSummary {
    /// Creates a new builder-style object to manufacture [`InstanceHealthSummary`](crate::model::InstanceHealthSummary)
    pub fn builder() -> crate::model::instance_health_summary::Builder {
        crate::model::instance_health_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceHealthReason {
    #[allow(missing_docs)] // documentation missing in model
    InstanceDeregistrationInProgress,
    #[allow(missing_docs)] // documentation missing in model
    InstanceFailedHealthChecks,
    #[allow(missing_docs)] // documentation missing in model
    InstanceInvalidState,
    #[allow(missing_docs)] // documentation missing in model
    InstanceIpUnusable,
    #[allow(missing_docs)] // documentation missing in model
    InstanceNotInUse,
    #[allow(missing_docs)] // documentation missing in model
    InstanceNotRegistered,
    #[allow(missing_docs)] // documentation missing in model
    InstanceResponseCodeMismatch,
    #[allow(missing_docs)] // documentation missing in model
    InstanceTimeout,
    #[allow(missing_docs)] // documentation missing in model
    LbInitialHealthChecking,
    #[allow(missing_docs)] // documentation missing in model
    LbInternalError,
    #[allow(missing_docs)] // documentation missing in model
    LbRegistrationInProgress,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceHealthReason {
    fn from(s: &str) -> Self {
        match s {
            "Instance.DeregistrationInProgress" => {
                InstanceHealthReason::InstanceDeregistrationInProgress
            }
            "Instance.FailedHealthChecks" => InstanceHealthReason::InstanceFailedHealthChecks,
            "Instance.InvalidState" => InstanceHealthReason::InstanceInvalidState,
            "Instance.IpUnusable" => InstanceHealthReason::InstanceIpUnusable,
            "Instance.NotInUse" => InstanceHealthReason::InstanceNotInUse,
            "Instance.NotRegistered" => InstanceHealthReason::InstanceNotRegistered,
            "Instance.ResponseCodeMismatch" => InstanceHealthReason::InstanceResponseCodeMismatch,
            "Instance.Timeout" => InstanceHealthReason::InstanceTimeout,
            "Lb.InitialHealthChecking" => InstanceHealthReason::LbInitialHealthChecking,
            "Lb.InternalError" => InstanceHealthReason::LbInternalError,
            "Lb.RegistrationInProgress" => InstanceHealthReason::LbRegistrationInProgress,
            other => InstanceHealthReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceHealthReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceHealthReason::from(s))
    }
}
impl InstanceHealthReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceHealthReason::InstanceDeregistrationInProgress => {
                "Instance.DeregistrationInProgress"
            }
            InstanceHealthReason::InstanceFailedHealthChecks => "Instance.FailedHealthChecks",
            InstanceHealthReason::InstanceInvalidState => "Instance.InvalidState",
            InstanceHealthReason::InstanceIpUnusable => "Instance.IpUnusable",
            InstanceHealthReason::InstanceNotInUse => "Instance.NotInUse",
            InstanceHealthReason::InstanceNotRegistered => "Instance.NotRegistered",
            InstanceHealthReason::InstanceResponseCodeMismatch => "Instance.ResponseCodeMismatch",
            InstanceHealthReason::InstanceTimeout => "Instance.Timeout",
            InstanceHealthReason::LbInitialHealthChecking => "Lb.InitialHealthChecking",
            InstanceHealthReason::LbInternalError => "Lb.InternalError",
            InstanceHealthReason::LbRegistrationInProgress => "Lb.RegistrationInProgress",
            InstanceHealthReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Instance.DeregistrationInProgress",
            "Instance.FailedHealthChecks",
            "Instance.InvalidState",
            "Instance.IpUnusable",
            "Instance.NotInUse",
            "Instance.NotRegistered",
            "Instance.ResponseCodeMismatch",
            "Instance.Timeout",
            "Lb.InitialHealthChecking",
            "Lb.InternalError",
            "Lb.RegistrationInProgress",
        ]
    }
}
impl AsRef<str> for InstanceHealthReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceHealthState {
    #[allow(missing_docs)] // documentation missing in model
    Draining,
    #[allow(missing_docs)] // documentation missing in model
    Healthy,
    #[allow(missing_docs)] // documentation missing in model
    Initial,
    #[allow(missing_docs)] // documentation missing in model
    Unavailable,
    #[allow(missing_docs)] // documentation missing in model
    Unhealthy,
    #[allow(missing_docs)] // documentation missing in model
    Unused,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceHealthState {
    fn from(s: &str) -> Self {
        match s {
            "draining" => InstanceHealthState::Draining,
            "healthy" => InstanceHealthState::Healthy,
            "initial" => InstanceHealthState::Initial,
            "unavailable" => InstanceHealthState::Unavailable,
            "unhealthy" => InstanceHealthState::Unhealthy,
            "unused" => InstanceHealthState::Unused,
            other => InstanceHealthState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceHealthState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceHealthState::from(s))
    }
}
impl InstanceHealthState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceHealthState::Draining => "draining",
            InstanceHealthState::Healthy => "healthy",
            InstanceHealthState::Initial => "initial",
            InstanceHealthState::Unavailable => "unavailable",
            InstanceHealthState::Unhealthy => "unhealthy",
            InstanceHealthState::Unused => "unused",
            InstanceHealthState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "draining",
            "healthy",
            "initial",
            "unavailable",
            "unhealthy",
            "unused",
        ]
    }
}
impl AsRef<str> for InstanceHealthState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LoadBalancerProtocol {
    #[allow(missing_docs)] // documentation missing in model
    Http,
    #[allow(missing_docs)] // documentation missing in model
    HttpHttps,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LoadBalancerProtocol {
    fn from(s: &str) -> Self {
        match s {
            "HTTP" => LoadBalancerProtocol::Http,
            "HTTP_HTTPS" => LoadBalancerProtocol::HttpHttps,
            other => LoadBalancerProtocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LoadBalancerProtocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LoadBalancerProtocol::from(s))
    }
}
impl LoadBalancerProtocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LoadBalancerProtocol::Http => "HTTP",
            LoadBalancerProtocol::HttpHttps => "HTTP_HTTPS",
            LoadBalancerProtocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HTTP", "HTTP_HTTPS"]
    }
}
impl AsRef<str> for LoadBalancerProtocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// _Note: `LoadBalancerState::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LoadBalancerState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    ActiveImpaired,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Provisioning,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LoadBalancerState {
    fn from(s: &str) -> Self {
        match s {
            "active" => LoadBalancerState::Active,
            "active_impaired" => LoadBalancerState::ActiveImpaired,
            "failed" => LoadBalancerState::Failed,
            "provisioning" => LoadBalancerState::Provisioning,
            "unknown" => LoadBalancerState::UnknownValue,
            other => LoadBalancerState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LoadBalancerState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LoadBalancerState::from(s))
    }
}
impl LoadBalancerState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LoadBalancerState::Active => "active",
            LoadBalancerState::ActiveImpaired => "active_impaired",
            LoadBalancerState::Failed => "failed",
            LoadBalancerState::Provisioning => "provisioning",
            LoadBalancerState::UnknownValue => "unknown",
            LoadBalancerState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "active",
            "active_impaired",
            "failed",
            "provisioning",
            "unknown",
        ]
    }
}
impl AsRef<str> for LoadBalancerState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LoadBalancerMetricName {
    #[allow(missing_docs)] // documentation missing in model
    ClientTlsNegotiationErrorCount,
    #[allow(missing_docs)] // documentation missing in model
    HttpCodeInstance2XxCount,
    #[allow(missing_docs)] // documentation missing in model
    HttpCodeInstance3XxCount,
    #[allow(missing_docs)] // documentation missing in model
    HttpCodeInstance4XxCount,
    #[allow(missing_docs)] // documentation missing in model
    HttpCodeInstance5XxCount,
    #[allow(missing_docs)] // documentation missing in model
    HttpCodeLb4XxCount,
    #[allow(missing_docs)] // documentation missing in model
    HttpCodeLb5XxCount,
    #[allow(missing_docs)] // documentation missing in model
    HealthyHostCount,
    #[allow(missing_docs)] // documentation missing in model
    InstanceResponseTime,
    #[allow(missing_docs)] // documentation missing in model
    RejectedConnectionCount,
    #[allow(missing_docs)] // documentation missing in model
    RequestCount,
    #[allow(missing_docs)] // documentation missing in model
    UnhealthyHostCount,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LoadBalancerMetricName {
    fn from(s: &str) -> Self {
        match s {
            "ClientTLSNegotiationErrorCount" => {
                LoadBalancerMetricName::ClientTlsNegotiationErrorCount
            }
            "HTTPCode_Instance_2XX_Count" => LoadBalancerMetricName::HttpCodeInstance2XxCount,
            "HTTPCode_Instance_3XX_Count" => LoadBalancerMetricName::HttpCodeInstance3XxCount,
            "HTTPCode_Instance_4XX_Count" => LoadBalancerMetricName::HttpCodeInstance4XxCount,
            "HTTPCode_Instance_5XX_Count" => LoadBalancerMetricName::HttpCodeInstance5XxCount,
            "HTTPCode_LB_4XX_Count" => LoadBalancerMetricName::HttpCodeLb4XxCount,
            "HTTPCode_LB_5XX_Count" => LoadBalancerMetricName::HttpCodeLb5XxCount,
            "HealthyHostCount" => LoadBalancerMetricName::HealthyHostCount,
            "InstanceResponseTime" => LoadBalancerMetricName::InstanceResponseTime,
            "RejectedConnectionCount" => LoadBalancerMetricName::RejectedConnectionCount,
            "RequestCount" => LoadBalancerMetricName::RequestCount,
            "UnhealthyHostCount" => LoadBalancerMetricName::UnhealthyHostCount,
            other => LoadBalancerMetricName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LoadBalancerMetricName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LoadBalancerMetricName::from(s))
    }
}
impl LoadBalancerMetricName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LoadBalancerMetricName::ClientTlsNegotiationErrorCount => {
                "ClientTLSNegotiationErrorCount"
            }
            LoadBalancerMetricName::HttpCodeInstance2XxCount => "HTTPCode_Instance_2XX_Count",
            LoadBalancerMetricName::HttpCodeInstance3XxCount => "HTTPCode_Instance_3XX_Count",
            LoadBalancerMetricName::HttpCodeInstance4XxCount => "HTTPCode_Instance_4XX_Count",
            LoadBalancerMetricName::HttpCodeInstance5XxCount => "HTTPCode_Instance_5XX_Count",
            LoadBalancerMetricName::HttpCodeLb4XxCount => "HTTPCode_LB_4XX_Count",
            LoadBalancerMetricName::HttpCodeLb5XxCount => "HTTPCode_LB_5XX_Count",
            LoadBalancerMetricName::HealthyHostCount => "HealthyHostCount",
            LoadBalancerMetricName::InstanceResponseTime => "InstanceResponseTime",
            LoadBalancerMetricName::RejectedConnectionCount => "RejectedConnectionCount",
            LoadBalancerMetricName::RequestCount => "RequestCount",
            LoadBalancerMetricName::UnhealthyHostCount => "UnhealthyHostCount",
            LoadBalancerMetricName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ClientTLSNegotiationErrorCount",
            "HTTPCode_Instance_2XX_Count",
            "HTTPCode_Instance_3XX_Count",
            "HTTPCode_Instance_4XX_Count",
            "HTTPCode_Instance_5XX_Count",
            "HTTPCode_LB_4XX_Count",
            "HTTPCode_LB_5XX_Count",
            "HealthyHostCount",
            "InstanceResponseTime",
            "RejectedConnectionCount",
            "RequestCount",
            "UnhealthyHostCount",
        ]
    }
}
impl AsRef<str> for LoadBalancerMetricName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an SSH key pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeyPair {
    /// <p>The friendly name of the SSH key pair.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the key pair (e.g.,
    /// <code>arn:aws:lightsail:us-east-2:123456789101:KeyPair/05859e3d-331d-48ba-9034-12345EXAMPLE</code>).</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The support code. Include this code in your email to support when you have questions about
    /// an instance or another resource in Lightsail. This code enables our support team to look up
    /// your Lightsail information more easily.</p>
    pub support_code: std::option::Option<std::string::String>,
    /// <p>The timestamp when the key pair was created (e.g., <code>1479816991.349</code>).</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The region name and Availability Zone where the key pair was created.</p>
    pub location: std::option::Option<crate::model::ResourceLocation>,
    /// <p>The resource type (usually <code>KeyPair</code>).</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The tag keys and optional values for the resource. For more information about tags in
    /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The RSA fingerprint of the key pair.</p>
    pub fingerprint: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KeyPair {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeyPair");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("support_code", &self.support_code);
        formatter.field("created_at", &self.created_at);
        formatter.field("location", &self.location);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("tags", &self.tags);
        formatter.field("fingerprint", &self.fingerprint);
        formatter.finish()
    }
}
/// See [`KeyPair`](crate::model::KeyPair)
pub mod key_pair {
    /// A builder for [`KeyPair`](crate::model::KeyPair)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) support_code: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) location: std::option::Option<crate::model::ResourceLocation>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) fingerprint: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The friendly name of the SSH key pair.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the SSH key pair.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the key pair (e.g.,
        /// <code>arn:aws:lightsail:us-east-2:123456789101:KeyPair/05859e3d-331d-48ba-9034-12345EXAMPLE</code>).</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the key pair (e.g.,
        /// <code>arn:aws:lightsail:us-east-2:123456789101:KeyPair/05859e3d-331d-48ba-9034-12345EXAMPLE</code>).</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// an instance or another resource in Lightsail. This code enables our support team to look up
        /// your Lightsail information more easily.</p>
        pub fn support_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_code = Some(input.into());
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// an instance or another resource in Lightsail. This code enables our support team to look up
        /// your Lightsail information more easily.</p>
        pub fn set_support_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.support_code = input;
            self
        }
        /// <p>The timestamp when the key pair was created (e.g., <code>1479816991.349</code>).</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when the key pair was created (e.g., <code>1479816991.349</code>).</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The region name and Availability Zone where the key pair was created.</p>
        pub fn location(mut self, input: crate::model::ResourceLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The region name and Availability Zone where the key pair was created.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::ResourceLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>The resource type (usually <code>KeyPair</code>).</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The resource type (usually <code>KeyPair</code>).</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The RSA fingerprint of the key pair.</p>
        pub fn fingerprint(mut self, input: impl Into<std::string::String>) -> Self {
            self.fingerprint = Some(input.into());
            self
        }
        /// <p>The RSA fingerprint of the key pair.</p>
        pub fn set_fingerprint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fingerprint = input;
            self
        }
        /// Consumes the builder and constructs a [`KeyPair`](crate::model::KeyPair)
        pub fn build(self) -> crate::model::KeyPair {
            crate::model::KeyPair {
                name: self.name,
                arn: self.arn,
                support_code: self.support_code,
                created_at: self.created_at,
                location: self.location,
                resource_type: self.resource_type,
                tags: self.tags,
                fingerprint: self.fingerprint,
            }
        }
    }
}
impl KeyPair {
    /// Creates a new builder-style object to manufacture [`KeyPair`](crate::model::KeyPair)
    pub fn builder() -> crate::model::key_pair::Builder {
        crate::model::key_pair::Builder::default()
    }
}

/// <p>Describes the virtual private server (or <i>instance</i>) status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceState {
    /// <p>The status code for the instance.</p>
    pub code: std::option::Option<i32>,
    /// <p>The state of the instance (e.g., <code>running</code> or <code>pending</code>).</p>
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InstanceState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceState");
        formatter.field("code", &self.code);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`InstanceState`](crate::model::InstanceState)
pub mod instance_state {
    /// A builder for [`InstanceState`](crate::model::InstanceState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<i32>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status code for the instance.</p>
        pub fn code(mut self, input: i32) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>The status code for the instance.</p>
        pub fn set_code(mut self, input: std::option::Option<i32>) -> Self {
            self.code = input;
            self
        }
        /// <p>The state of the instance (e.g., <code>running</code> or <code>pending</code>).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The state of the instance (e.g., <code>running</code> or <code>pending</code>).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceState`](crate::model::InstanceState)
        pub fn build(self) -> crate::model::InstanceState {
            crate::model::InstanceState {
                code: self.code,
                name: self.name,
            }
        }
    }
}
impl InstanceState {
    /// Creates a new builder-style object to manufacture [`InstanceState`](crate::model::InstanceState)
    pub fn builder() -> crate::model::instance_state::Builder {
        crate::model::instance_state::Builder::default()
    }
}

/// <p>Describes an instance snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceSnapshot {
    /// <p>The name of the snapshot.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the snapshot (e.g.,
    /// <code>arn:aws:lightsail:us-east-2:123456789101:InstanceSnapshot/d23b5706-3322-4d83-81e5-12345EXAMPLE</code>).</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The support code. Include this code in your email to support when you have questions about
    /// an instance or another resource in Lightsail. This code enables our support team to look up
    /// your Lightsail information more easily.</p>
    pub support_code: std::option::Option<std::string::String>,
    /// <p>The timestamp when the snapshot was created (e.g., <code>1479907467.024</code>).</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The region name and Availability Zone where you created the snapshot.</p>
    pub location: std::option::Option<crate::model::ResourceLocation>,
    /// <p>The type of resource (usually <code>InstanceSnapshot</code>).</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The tag keys and optional values for the resource. For more information about tags in
    /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The state the snapshot is in.</p>
    pub state: std::option::Option<crate::model::InstanceSnapshotState>,
    /// <p>The progress of the snapshot.</p>
    /// <note>
    /// <p>This is populated only for disk snapshots, and is <code>null</code> for instance
    /// snapshots.</p>
    /// </note>
    pub progress: std::option::Option<std::string::String>,
    /// <p>An array of disk objects containing information about all block storage disks.</p>
    pub from_attached_disks: std::option::Option<std::vec::Vec<crate::model::Disk>>,
    /// <p>The instance from which the snapshot was created.</p>
    pub from_instance_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the instance from which the snapshot was created (e.g.,
    /// <code>arn:aws:lightsail:us-east-2:123456789101:Instance/64b8404c-ccb1-430b-8daf-12345EXAMPLE</code>).</p>
    pub from_instance_arn: std::option::Option<std::string::String>,
    /// <p>The blueprint ID from which you created the snapshot (e.g., <code>os_debian_8_3</code>). A
    /// blueprint is a virtual private server (or <i>instance</i>) image used to create
    /// instances quickly.</p>
    pub from_blueprint_id: std::option::Option<std::string::String>,
    /// <p>The bundle ID from which you created the snapshot (e.g., <code>micro_1_0</code>).</p>
    pub from_bundle_id: std::option::Option<std::string::String>,
    /// <p>A Boolean value indicating whether the snapshot was created from an automatic
    /// snapshot.</p>
    pub is_from_auto_snapshot: std::option::Option<bool>,
    /// <p>The size in GB of the SSD.</p>
    pub size_in_gb: std::option::Option<i32>,
}
impl std::fmt::Debug for InstanceSnapshot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceSnapshot");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("support_code", &self.support_code);
        formatter.field("created_at", &self.created_at);
        formatter.field("location", &self.location);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("tags", &self.tags);
        formatter.field("state", &self.state);
        formatter.field("progress", &self.progress);
        formatter.field("from_attached_disks", &self.from_attached_disks);
        formatter.field("from_instance_name", &self.from_instance_name);
        formatter.field("from_instance_arn", &self.from_instance_arn);
        formatter.field("from_blueprint_id", &self.from_blueprint_id);
        formatter.field("from_bundle_id", &self.from_bundle_id);
        formatter.field("is_from_auto_snapshot", &self.is_from_auto_snapshot);
        formatter.field("size_in_gb", &self.size_in_gb);
        formatter.finish()
    }
}
/// See [`InstanceSnapshot`](crate::model::InstanceSnapshot)
pub mod instance_snapshot {
    /// A builder for [`InstanceSnapshot`](crate::model::InstanceSnapshot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) support_code: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) location: std::option::Option<crate::model::ResourceLocation>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) state: std::option::Option<crate::model::InstanceSnapshotState>,
        pub(crate) progress: std::option::Option<std::string::String>,
        pub(crate) from_attached_disks: std::option::Option<std::vec::Vec<crate::model::Disk>>,
        pub(crate) from_instance_name: std::option::Option<std::string::String>,
        pub(crate) from_instance_arn: std::option::Option<std::string::String>,
        pub(crate) from_blueprint_id: std::option::Option<std::string::String>,
        pub(crate) from_bundle_id: std::option::Option<std::string::String>,
        pub(crate) is_from_auto_snapshot: std::option::Option<bool>,
        pub(crate) size_in_gb: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the snapshot.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the snapshot.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the snapshot (e.g.,
        /// <code>arn:aws:lightsail:us-east-2:123456789101:InstanceSnapshot/d23b5706-3322-4d83-81e5-12345EXAMPLE</code>).</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the snapshot (e.g.,
        /// <code>arn:aws:lightsail:us-east-2:123456789101:InstanceSnapshot/d23b5706-3322-4d83-81e5-12345EXAMPLE</code>).</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// an instance or another resource in Lightsail. This code enables our support team to look up
        /// your Lightsail information more easily.</p>
        pub fn support_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_code = Some(input.into());
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// an instance or another resource in Lightsail. This code enables our support team to look up
        /// your Lightsail information more easily.</p>
        pub fn set_support_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.support_code = input;
            self
        }
        /// <p>The timestamp when the snapshot was created (e.g., <code>1479907467.024</code>).</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when the snapshot was created (e.g., <code>1479907467.024</code>).</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The region name and Availability Zone where you created the snapshot.</p>
        pub fn location(mut self, input: crate::model::ResourceLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The region name and Availability Zone where you created the snapshot.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::ResourceLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>The type of resource (usually <code>InstanceSnapshot</code>).</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resource (usually <code>InstanceSnapshot</code>).</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The state the snapshot is in.</p>
        pub fn state(mut self, input: crate::model::InstanceSnapshotState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state the snapshot is in.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::InstanceSnapshotState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The progress of the snapshot.</p>
        /// <note>
        /// <p>This is populated only for disk snapshots, and is <code>null</code> for instance
        /// snapshots.</p>
        /// </note>
        pub fn progress(mut self, input: impl Into<std::string::String>) -> Self {
            self.progress = Some(input.into());
            self
        }
        /// <p>The progress of the snapshot.</p>
        /// <note>
        /// <p>This is populated only for disk snapshots, and is <code>null</code> for instance
        /// snapshots.</p>
        /// </note>
        pub fn set_progress(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.progress = input;
            self
        }
        /// Appends an item to `from_attached_disks`.
        ///
        /// To override the contents of this collection use [`set_from_attached_disks`](Self::set_from_attached_disks).
        ///
        /// <p>An array of disk objects containing information about all block storage disks.</p>
        pub fn from_attached_disks(mut self, input: impl Into<crate::model::Disk>) -> Self {
            let mut v = self.from_attached_disks.unwrap_or_default();
            v.push(input.into());
            self.from_attached_disks = Some(v);
            self
        }
        /// <p>An array of disk objects containing information about all block storage disks.</p>
        pub fn set_from_attached_disks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Disk>>,
        ) -> Self {
            self.from_attached_disks = input;
            self
        }
        /// <p>The instance from which the snapshot was created.</p>
        pub fn from_instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_instance_name = Some(input.into());
            self
        }
        /// <p>The instance from which the snapshot was created.</p>
        pub fn set_from_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_instance_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the instance from which the snapshot was created (e.g.,
        /// <code>arn:aws:lightsail:us-east-2:123456789101:Instance/64b8404c-ccb1-430b-8daf-12345EXAMPLE</code>).</p>
        pub fn from_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the instance from which the snapshot was created (e.g.,
        /// <code>arn:aws:lightsail:us-east-2:123456789101:Instance/64b8404c-ccb1-430b-8daf-12345EXAMPLE</code>).</p>
        pub fn set_from_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_instance_arn = input;
            self
        }
        /// <p>The blueprint ID from which you created the snapshot (e.g., <code>os_debian_8_3</code>). A
        /// blueprint is a virtual private server (or <i>instance</i>) image used to create
        /// instances quickly.</p>
        pub fn from_blueprint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_blueprint_id = Some(input.into());
            self
        }
        /// <p>The blueprint ID from which you created the snapshot (e.g., <code>os_debian_8_3</code>). A
        /// blueprint is a virtual private server (or <i>instance</i>) image used to create
        /// instances quickly.</p>
        pub fn set_from_blueprint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_blueprint_id = input;
            self
        }
        /// <p>The bundle ID from which you created the snapshot (e.g., <code>micro_1_0</code>).</p>
        pub fn from_bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_bundle_id = Some(input.into());
            self
        }
        /// <p>The bundle ID from which you created the snapshot (e.g., <code>micro_1_0</code>).</p>
        pub fn set_from_bundle_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_bundle_id = input;
            self
        }
        /// <p>A Boolean value indicating whether the snapshot was created from an automatic
        /// snapshot.</p>
        pub fn is_from_auto_snapshot(mut self, input: bool) -> Self {
            self.is_from_auto_snapshot = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether the snapshot was created from an automatic
        /// snapshot.</p>
        pub fn set_is_from_auto_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.is_from_auto_snapshot = input;
            self
        }
        /// <p>The size in GB of the SSD.</p>
        pub fn size_in_gb(mut self, input: i32) -> Self {
            self.size_in_gb = Some(input);
            self
        }
        /// <p>The size in GB of the SSD.</p>
        pub fn set_size_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.size_in_gb = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceSnapshot`](crate::model::InstanceSnapshot)
        pub fn build(self) -> crate::model::InstanceSnapshot {
            crate::model::InstanceSnapshot {
                name: self.name,
                arn: self.arn,
                support_code: self.support_code,
                created_at: self.created_at,
                location: self.location,
                resource_type: self.resource_type,
                tags: self.tags,
                state: self.state,
                progress: self.progress,
                from_attached_disks: self.from_attached_disks,
                from_instance_name: self.from_instance_name,
                from_instance_arn: self.from_instance_arn,
                from_blueprint_id: self.from_blueprint_id,
                from_bundle_id: self.from_bundle_id,
                is_from_auto_snapshot: self.is_from_auto_snapshot,
                size_in_gb: self.size_in_gb,
            }
        }
    }
}
impl InstanceSnapshot {
    /// Creates a new builder-style object to manufacture [`InstanceSnapshot`](crate::model::InstanceSnapshot)
    pub fn builder() -> crate::model::instance_snapshot::Builder {
        crate::model::instance_snapshot::Builder::default()
    }
}

/// <p>Describes a block storage disk.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Disk {
    /// <p>The unique name of the disk.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the disk.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The support code. Include this code in your email to support when you have questions about
    /// an instance or another resource in Lightsail. This code enables our support team to look up
    /// your Lightsail information more easily.</p>
    pub support_code: std::option::Option<std::string::String>,
    /// <p>The date when the disk was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The AWS Region and Availability Zone where the disk is located.</p>
    pub location: std::option::Option<crate::model::ResourceLocation>,
    /// <p>The Lightsail resource type (e.g., <code>Disk</code>).</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The tag keys and optional values for the resource. For more information about tags in
    /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>An array of objects representing the add-ons enabled on the disk.</p>
    pub add_ons: std::option::Option<std::vec::Vec<crate::model::AddOn>>,
    /// <p>The size of the disk in GB.</p>
    pub size_in_gb: std::option::Option<i32>,
    /// <p>A Boolean value indicating whether this disk is a system disk (has an operating system
    /// loaded on it).</p>
    pub is_system_disk: std::option::Option<bool>,
    /// <p>The input/output operations per second (IOPS) of the disk.</p>
    pub iops: std::option::Option<i32>,
    /// <p>The disk path.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>Describes the status of the disk.</p>
    pub state: std::option::Option<crate::model::DiskState>,
    /// <p>The resources to which the disk is attached.</p>
    pub attached_to: std::option::Option<std::string::String>,
    /// <p>A Boolean value indicating whether the disk is attached.</p>
    pub is_attached: std::option::Option<bool>,
    /// <p>(Deprecated) The attachment state of the disk.</p>
    /// <note>
    /// <p>In releases prior to November 14, 2017, this parameter returned <code>attached</code>
    /// for system disks in the API response. It is now deprecated, but still included in the
    /// response. Use <code>isAttached</code> instead.</p>
    /// </note>
    pub attachment_state: std::option::Option<std::string::String>,
    /// <p>(Deprecated) The number of GB in use by the disk.</p>
    /// <note>
    /// <p>In releases prior to November 14, 2017, this parameter was not included in the API
    /// response. It is now deprecated.</p>
    /// </note>
    pub gb_in_use: std::option::Option<i32>,
}
impl std::fmt::Debug for Disk {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Disk");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("support_code", &self.support_code);
        formatter.field("created_at", &self.created_at);
        formatter.field("location", &self.location);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("tags", &self.tags);
        formatter.field("add_ons", &self.add_ons);
        formatter.field("size_in_gb", &self.size_in_gb);
        formatter.field("is_system_disk", &self.is_system_disk);
        formatter.field("iops", &self.iops);
        formatter.field("path", &self.path);
        formatter.field("state", &self.state);
        formatter.field("attached_to", &self.attached_to);
        formatter.field("is_attached", &self.is_attached);
        formatter.field("attachment_state", &self.attachment_state);
        formatter.field("gb_in_use", &self.gb_in_use);
        formatter.finish()
    }
}
/// See [`Disk`](crate::model::Disk)
pub mod disk {
    /// A builder for [`Disk`](crate::model::Disk)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) support_code: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) location: std::option::Option<crate::model::ResourceLocation>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) add_ons: std::option::Option<std::vec::Vec<crate::model::AddOn>>,
        pub(crate) size_in_gb: std::option::Option<i32>,
        pub(crate) is_system_disk: std::option::Option<bool>,
        pub(crate) iops: std::option::Option<i32>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::DiskState>,
        pub(crate) attached_to: std::option::Option<std::string::String>,
        pub(crate) is_attached: std::option::Option<bool>,
        pub(crate) attachment_state: std::option::Option<std::string::String>,
        pub(crate) gb_in_use: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique name of the disk.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique name of the disk.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the disk.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the disk.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// an instance or another resource in Lightsail. This code enables our support team to look up
        /// your Lightsail information more easily.</p>
        pub fn support_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_code = Some(input.into());
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// an instance or another resource in Lightsail. This code enables our support team to look up
        /// your Lightsail information more easily.</p>
        pub fn set_support_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.support_code = input;
            self
        }
        /// <p>The date when the disk was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date when the disk was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The AWS Region and Availability Zone where the disk is located.</p>
        pub fn location(mut self, input: crate::model::ResourceLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The AWS Region and Availability Zone where the disk is located.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::ResourceLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>The Lightsail resource type (e.g., <code>Disk</code>).</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The Lightsail resource type (e.g., <code>Disk</code>).</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `add_ons`.
        ///
        /// To override the contents of this collection use [`set_add_ons`](Self::set_add_ons).
        ///
        /// <p>An array of objects representing the add-ons enabled on the disk.</p>
        pub fn add_ons(mut self, input: impl Into<crate::model::AddOn>) -> Self {
            let mut v = self.add_ons.unwrap_or_default();
            v.push(input.into());
            self.add_ons = Some(v);
            self
        }
        /// <p>An array of objects representing the add-ons enabled on the disk.</p>
        pub fn set_add_ons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddOn>>,
        ) -> Self {
            self.add_ons = input;
            self
        }
        /// <p>The size of the disk in GB.</p>
        pub fn size_in_gb(mut self, input: i32) -> Self {
            self.size_in_gb = Some(input);
            self
        }
        /// <p>The size of the disk in GB.</p>
        pub fn set_size_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.size_in_gb = input;
            self
        }
        /// <p>A Boolean value indicating whether this disk is a system disk (has an operating system
        /// loaded on it).</p>
        pub fn is_system_disk(mut self, input: bool) -> Self {
            self.is_system_disk = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether this disk is a system disk (has an operating system
        /// loaded on it).</p>
        pub fn set_is_system_disk(mut self, input: std::option::Option<bool>) -> Self {
            self.is_system_disk = input;
            self
        }
        /// <p>The input/output operations per second (IOPS) of the disk.</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>The input/output operations per second (IOPS) of the disk.</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// <p>The disk path.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The disk path.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>Describes the status of the disk.</p>
        pub fn state(mut self, input: crate::model::DiskState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>Describes the status of the disk.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::DiskState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The resources to which the disk is attached.</p>
        pub fn attached_to(mut self, input: impl Into<std::string::String>) -> Self {
            self.attached_to = Some(input.into());
            self
        }
        /// <p>The resources to which the disk is attached.</p>
        pub fn set_attached_to(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.attached_to = input;
            self
        }
        /// <p>A Boolean value indicating whether the disk is attached.</p>
        pub fn is_attached(mut self, input: bool) -> Self {
            self.is_attached = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether the disk is attached.</p>
        pub fn set_is_attached(mut self, input: std::option::Option<bool>) -> Self {
            self.is_attached = input;
            self
        }
        /// <p>(Deprecated) The attachment state of the disk.</p>
        /// <note>
        /// <p>In releases prior to November 14, 2017, this parameter returned <code>attached</code>
        /// for system disks in the API response. It is now deprecated, but still included in the
        /// response. Use <code>isAttached</code> instead.</p>
        /// </note>
        pub fn attachment_state(mut self, input: impl Into<std::string::String>) -> Self {
            self.attachment_state = Some(input.into());
            self
        }
        /// <p>(Deprecated) The attachment state of the disk.</p>
        /// <note>
        /// <p>In releases prior to November 14, 2017, this parameter returned <code>attached</code>
        /// for system disks in the API response. It is now deprecated, but still included in the
        /// response. Use <code>isAttached</code> instead.</p>
        /// </note>
        pub fn set_attachment_state(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attachment_state = input;
            self
        }
        /// <p>(Deprecated) The number of GB in use by the disk.</p>
        /// <note>
        /// <p>In releases prior to November 14, 2017, this parameter was not included in the API
        /// response. It is now deprecated.</p>
        /// </note>
        pub fn gb_in_use(mut self, input: i32) -> Self {
            self.gb_in_use = Some(input);
            self
        }
        /// <p>(Deprecated) The number of GB in use by the disk.</p>
        /// <note>
        /// <p>In releases prior to November 14, 2017, this parameter was not included in the API
        /// response. It is now deprecated.</p>
        /// </note>
        pub fn set_gb_in_use(mut self, input: std::option::Option<i32>) -> Self {
            self.gb_in_use = input;
            self
        }
        /// Consumes the builder and constructs a [`Disk`](crate::model::Disk)
        pub fn build(self) -> crate::model::Disk {
            crate::model::Disk {
                name: self.name,
                arn: self.arn,
                support_code: self.support_code,
                created_at: self.created_at,
                location: self.location,
                resource_type: self.resource_type,
                tags: self.tags,
                add_ons: self.add_ons,
                size_in_gb: self.size_in_gb,
                is_system_disk: self.is_system_disk,
                iops: self.iops,
                path: self.path,
                state: self.state,
                attached_to: self.attached_to,
                is_attached: self.is_attached,
                attachment_state: self.attachment_state,
                gb_in_use: self.gb_in_use,
            }
        }
    }
}
impl Disk {
    /// Creates a new builder-style object to manufacture [`Disk`](crate::model::Disk)
    pub fn builder() -> crate::model::disk::Builder {
        crate::model::disk::Builder::default()
    }
}

/// _Note: `DiskState::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DiskState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    InUse,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DiskState {
    fn from(s: &str) -> Self {
        match s {
            "available" => DiskState::Available,
            "error" => DiskState::Error,
            "in-use" => DiskState::InUse,
            "pending" => DiskState::Pending,
            "unknown" => DiskState::UnknownValue,
            other => DiskState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DiskState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DiskState::from(s))
    }
}
impl DiskState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DiskState::Available => "available",
            DiskState::Error => "error",
            DiskState::InUse => "in-use",
            DiskState::Pending => "pending",
            DiskState::UnknownValue => "unknown",
            DiskState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["available", "error", "in-use", "pending", "unknown"]
    }
}
impl AsRef<str> for DiskState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an add-on that is enabled for an Amazon Lightsail resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddOn {
    /// <p>The name of the add-on.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the add-on.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The daily time when an automatic snapshot is created.</p>
    /// <p>The time shown is in <code>HH:00</code> format, and in Coordinated Universal Time
    /// (UTC).</p>
    /// <p>The snapshot is automatically created between the time shown and up to 45 minutes
    /// after.</p>
    pub snapshot_time_of_day: std::option::Option<std::string::String>,
    /// <p>The next daily time an automatic snapshot will be created.</p>
    /// <p>The time shown is in <code>HH:00</code> format, and in Coordinated Universal Time
    /// (UTC).</p>
    /// <p>The snapshot is automatically created between the time shown and up to 45 minutes
    /// after.</p>
    pub next_snapshot_time_of_day: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AddOn {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddOn");
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("snapshot_time_of_day", &self.snapshot_time_of_day);
        formatter.field("next_snapshot_time_of_day", &self.next_snapshot_time_of_day);
        formatter.finish()
    }
}
/// See [`AddOn`](crate::model::AddOn)
pub mod add_on {
    /// A builder for [`AddOn`](crate::model::AddOn)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) snapshot_time_of_day: std::option::Option<std::string::String>,
        pub(crate) next_snapshot_time_of_day: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the add-on.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the add-on.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the add-on.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the add-on.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The daily time when an automatic snapshot is created.</p>
        /// <p>The time shown is in <code>HH:00</code> format, and in Coordinated Universal Time
        /// (UTC).</p>
        /// <p>The snapshot is automatically created between the time shown and up to 45 minutes
        /// after.</p>
        pub fn snapshot_time_of_day(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_time_of_day = Some(input.into());
            self
        }
        /// <p>The daily time when an automatic snapshot is created.</p>
        /// <p>The time shown is in <code>HH:00</code> format, and in Coordinated Universal Time
        /// (UTC).</p>
        /// <p>The snapshot is automatically created between the time shown and up to 45 minutes
        /// after.</p>
        pub fn set_snapshot_time_of_day(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_time_of_day = input;
            self
        }
        /// <p>The next daily time an automatic snapshot will be created.</p>
        /// <p>The time shown is in <code>HH:00</code> format, and in Coordinated Universal Time
        /// (UTC).</p>
        /// <p>The snapshot is automatically created between the time shown and up to 45 minutes
        /// after.</p>
        pub fn next_snapshot_time_of_day(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_snapshot_time_of_day = Some(input.into());
            self
        }
        /// <p>The next daily time an automatic snapshot will be created.</p>
        /// <p>The time shown is in <code>HH:00</code> format, and in Coordinated Universal Time
        /// (UTC).</p>
        /// <p>The snapshot is automatically created between the time shown and up to 45 minutes
        /// after.</p>
        pub fn set_next_snapshot_time_of_day(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_snapshot_time_of_day = input;
            self
        }
        /// Consumes the builder and constructs a [`AddOn`](crate::model::AddOn)
        pub fn build(self) -> crate::model::AddOn {
            crate::model::AddOn {
                name: self.name,
                status: self.status,
                snapshot_time_of_day: self.snapshot_time_of_day,
                next_snapshot_time_of_day: self.next_snapshot_time_of_day,
            }
        }
    }
}
impl AddOn {
    /// Creates a new builder-style object to manufacture [`AddOn`](crate::model::AddOn)
    pub fn builder() -> crate::model::add_on::Builder {
        crate::model::add_on::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceSnapshotState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceSnapshotState {
    fn from(s: &str) -> Self {
        match s {
            "available" => InstanceSnapshotState::Available,
            "error" => InstanceSnapshotState::Error,
            "pending" => InstanceSnapshotState::Pending,
            other => InstanceSnapshotState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceSnapshotState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceSnapshotState::from(s))
    }
}
impl InstanceSnapshotState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceSnapshotState::Available => "available",
            InstanceSnapshotState::Error => "error",
            InstanceSnapshotState::Pending => "pending",
            InstanceSnapshotState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["available", "error", "pending"]
    }
}
impl AsRef<str> for InstanceSnapshotState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an instance (a virtual private server).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Instance {
    /// <p>The name the user gave the instance (e.g., <code>Amazon_Linux-1GB-Ohio-1</code>).</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the instance (e.g.,
    /// <code>arn:aws:lightsail:us-east-2:123456789101:Instance/244ad76f-8aad-4741-809f-12345EXAMPLE</code>).</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The support code. Include this code in your email to support when you have questions about
    /// an instance or another resource in Lightsail. This code enables our support team to look up
    /// your Lightsail information more easily.</p>
    pub support_code: std::option::Option<std::string::String>,
    /// <p>The timestamp when the instance was created (e.g., <code>1479734909.17</code>) in Unix
    /// time format.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The region name and Availability Zone where the instance is located.</p>
    pub location: std::option::Option<crate::model::ResourceLocation>,
    /// <p>The type of resource (usually <code>Instance</code>).</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The tag keys and optional values for the resource. For more information about tags in
    /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The blueprint ID (e.g., <code>os_amlinux_2016_03</code>).</p>
    pub blueprint_id: std::option::Option<std::string::String>,
    /// <p>The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).</p>
    pub blueprint_name: std::option::Option<std::string::String>,
    /// <p>The bundle for the instance (e.g., <code>micro_1_0</code>).</p>
    pub bundle_id: std::option::Option<std::string::String>,
    /// <p>An array of objects representing the add-ons enabled on the instance.</p>
    pub add_ons: std::option::Option<std::vec::Vec<crate::model::AddOn>>,
    /// <p>A Boolean value indicating whether this instance has a static IP assigned to it.</p>
    pub is_static_ip: std::option::Option<bool>,
    /// <p>The private IP address of the instance.</p>
    pub private_ip_address: std::option::Option<std::string::String>,
    /// <p>The public IP address of the instance.</p>
    pub public_ip_address: std::option::Option<std::string::String>,
    /// <p>The IPv6 addresses of the instance.</p>
    pub ipv6_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IP address type of the instance.</p>
    ///
    /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for
    /// IPv4 and IPv6.</p>
    pub ip_address_type: std::option::Option<crate::model::IpAddressType>,
    /// <p>The size of the vCPU and the amount of RAM for the instance.</p>
    pub hardware: std::option::Option<crate::model::InstanceHardware>,
    /// <p>Information about the public ports and monthly data transfer rates for the
    /// instance.</p>
    pub networking: std::option::Option<crate::model::InstanceNetworking>,
    /// <p>The status code and the state (e.g., <code>running</code>) for the instance.</p>
    pub state: std::option::Option<crate::model::InstanceState>,
    /// <p>The user name for connecting to the instance (e.g., <code>ec2-user</code>).</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>The name of the SSH key being used to connect to the instance (e.g.,
    /// <code>LightsailDefaultKeyPair</code>).</p>
    pub ssh_key_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Instance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Instance");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("support_code", &self.support_code);
        formatter.field("created_at", &self.created_at);
        formatter.field("location", &self.location);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("tags", &self.tags);
        formatter.field("blueprint_id", &self.blueprint_id);
        formatter.field("blueprint_name", &self.blueprint_name);
        formatter.field("bundle_id", &self.bundle_id);
        formatter.field("add_ons", &self.add_ons);
        formatter.field("is_static_ip", &self.is_static_ip);
        formatter.field("private_ip_address", &self.private_ip_address);
        formatter.field("public_ip_address", &self.public_ip_address);
        formatter.field("ipv6_addresses", &self.ipv6_addresses);
        formatter.field("ip_address_type", &self.ip_address_type);
        formatter.field("hardware", &self.hardware);
        formatter.field("networking", &self.networking);
        formatter.field("state", &self.state);
        formatter.field("username", &self.username);
        formatter.field("ssh_key_name", &self.ssh_key_name);
        formatter.finish()
    }
}
/// See [`Instance`](crate::model::Instance)
pub mod instance {
    /// A builder for [`Instance`](crate::model::Instance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) support_code: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) location: std::option::Option<crate::model::ResourceLocation>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) blueprint_id: std::option::Option<std::string::String>,
        pub(crate) blueprint_name: std::option::Option<std::string::String>,
        pub(crate) bundle_id: std::option::Option<std::string::String>,
        pub(crate) add_ons: std::option::Option<std::vec::Vec<crate::model::AddOn>>,
        pub(crate) is_static_ip: std::option::Option<bool>,
        pub(crate) private_ip_address: std::option::Option<std::string::String>,
        pub(crate) public_ip_address: std::option::Option<std::string::String>,
        pub(crate) ipv6_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ip_address_type: std::option::Option<crate::model::IpAddressType>,
        pub(crate) hardware: std::option::Option<crate::model::InstanceHardware>,
        pub(crate) networking: std::option::Option<crate::model::InstanceNetworking>,
        pub(crate) state: std::option::Option<crate::model::InstanceState>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) ssh_key_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name the user gave the instance (e.g., <code>Amazon_Linux-1GB-Ohio-1</code>).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name the user gave the instance (e.g., <code>Amazon_Linux-1GB-Ohio-1</code>).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the instance (e.g.,
        /// <code>arn:aws:lightsail:us-east-2:123456789101:Instance/244ad76f-8aad-4741-809f-12345EXAMPLE</code>).</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the instance (e.g.,
        /// <code>arn:aws:lightsail:us-east-2:123456789101:Instance/244ad76f-8aad-4741-809f-12345EXAMPLE</code>).</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// an instance or another resource in Lightsail. This code enables our support team to look up
        /// your Lightsail information more easily.</p>
        pub fn support_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_code = Some(input.into());
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// an instance or another resource in Lightsail. This code enables our support team to look up
        /// your Lightsail information more easily.</p>
        pub fn set_support_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.support_code = input;
            self
        }
        /// <p>The timestamp when the instance was created (e.g., <code>1479734909.17</code>) in Unix
        /// time format.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when the instance was created (e.g., <code>1479734909.17</code>) in Unix
        /// time format.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The region name and Availability Zone where the instance is located.</p>
        pub fn location(mut self, input: crate::model::ResourceLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The region name and Availability Zone where the instance is located.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::ResourceLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>The type of resource (usually <code>Instance</code>).</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resource (usually <code>Instance</code>).</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The blueprint ID (e.g., <code>os_amlinux_2016_03</code>).</p>
        pub fn blueprint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.blueprint_id = Some(input.into());
            self
        }
        /// <p>The blueprint ID (e.g., <code>os_amlinux_2016_03</code>).</p>
        pub fn set_blueprint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.blueprint_id = input;
            self
        }
        /// <p>The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).</p>
        pub fn blueprint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.blueprint_name = Some(input.into());
            self
        }
        /// <p>The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).</p>
        pub fn set_blueprint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.blueprint_name = input;
            self
        }
        /// <p>The bundle for the instance (e.g., <code>micro_1_0</code>).</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_id = Some(input.into());
            self
        }
        /// <p>The bundle for the instance (e.g., <code>micro_1_0</code>).</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_id = input;
            self
        }
        /// Appends an item to `add_ons`.
        ///
        /// To override the contents of this collection use [`set_add_ons`](Self::set_add_ons).
        ///
        /// <p>An array of objects representing the add-ons enabled on the instance.</p>
        pub fn add_ons(mut self, input: impl Into<crate::model::AddOn>) -> Self {
            let mut v = self.add_ons.unwrap_or_default();
            v.push(input.into());
            self.add_ons = Some(v);
            self
        }
        /// <p>An array of objects representing the add-ons enabled on the instance.</p>
        pub fn set_add_ons(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddOn>>,
        ) -> Self {
            self.add_ons = input;
            self
        }
        /// <p>A Boolean value indicating whether this instance has a static IP assigned to it.</p>
        pub fn is_static_ip(mut self, input: bool) -> Self {
            self.is_static_ip = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether this instance has a static IP assigned to it.</p>
        pub fn set_is_static_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.is_static_ip = input;
            self
        }
        /// <p>The private IP address of the instance.</p>
        pub fn private_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_ip_address = Some(input.into());
            self
        }
        /// <p>The private IP address of the instance.</p>
        pub fn set_private_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_ip_address = input;
            self
        }
        /// <p>The public IP address of the instance.</p>
        pub fn public_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_ip_address = Some(input.into());
            self
        }
        /// <p>The public IP address of the instance.</p>
        pub fn set_public_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_ip_address = input;
            self
        }
        /// Appends an item to `ipv6_addresses`.
        ///
        /// To override the contents of this collection use [`set_ipv6_addresses`](Self::set_ipv6_addresses).
        ///
        /// <p>The IPv6 addresses of the instance.</p>
        pub fn ipv6_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ipv6_addresses.unwrap_or_default();
            v.push(input.into());
            self.ipv6_addresses = Some(v);
            self
        }
        /// <p>The IPv6 addresses of the instance.</p>
        pub fn set_ipv6_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ipv6_addresses = input;
            self
        }
        /// <p>The IP address type of the instance.</p>
        ///
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for
        /// IPv4 and IPv6.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.ip_address_type = Some(input);
            self
        }
        /// <p>The IP address type of the instance.</p>
        ///
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for
        /// IPv4 and IPv6.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.ip_address_type = input;
            self
        }
        /// <p>The size of the vCPU and the amount of RAM for the instance.</p>
        pub fn hardware(mut self, input: crate::model::InstanceHardware) -> Self {
            self.hardware = Some(input);
            self
        }
        /// <p>The size of the vCPU and the amount of RAM for the instance.</p>
        pub fn set_hardware(
            mut self,
            input: std::option::Option<crate::model::InstanceHardware>,
        ) -> Self {
            self.hardware = input;
            self
        }
        /// <p>Information about the public ports and monthly data transfer rates for the
        /// instance.</p>
        pub fn networking(mut self, input: crate::model::InstanceNetworking) -> Self {
            self.networking = Some(input);
            self
        }
        /// <p>Information about the public ports and monthly data transfer rates for the
        /// instance.</p>
        pub fn set_networking(
            mut self,
            input: std::option::Option<crate::model::InstanceNetworking>,
        ) -> Self {
            self.networking = input;
            self
        }
        /// <p>The status code and the state (e.g., <code>running</code>) for the instance.</p>
        pub fn state(mut self, input: crate::model::InstanceState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The status code and the state (e.g., <code>running</code>) for the instance.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::InstanceState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The user name for connecting to the instance (e.g., <code>ec2-user</code>).</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name for connecting to the instance (e.g., <code>ec2-user</code>).</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The name of the SSH key being used to connect to the instance (e.g.,
        /// <code>LightsailDefaultKeyPair</code>).</p>
        pub fn ssh_key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssh_key_name = Some(input.into());
            self
        }
        /// <p>The name of the SSH key being used to connect to the instance (e.g.,
        /// <code>LightsailDefaultKeyPair</code>).</p>
        pub fn set_ssh_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ssh_key_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Instance`](crate::model::Instance)
        pub fn build(self) -> crate::model::Instance {
            crate::model::Instance {
                name: self.name,
                arn: self.arn,
                support_code: self.support_code,
                created_at: self.created_at,
                location: self.location,
                resource_type: self.resource_type,
                tags: self.tags,
                blueprint_id: self.blueprint_id,
                blueprint_name: self.blueprint_name,
                bundle_id: self.bundle_id,
                add_ons: self.add_ons,
                is_static_ip: self.is_static_ip,
                private_ip_address: self.private_ip_address,
                public_ip_address: self.public_ip_address,
                ipv6_addresses: self.ipv6_addresses,
                ip_address_type: self.ip_address_type,
                hardware: self.hardware,
                networking: self.networking,
                state: self.state,
                username: self.username,
                ssh_key_name: self.ssh_key_name,
            }
        }
    }
}
impl Instance {
    /// Creates a new builder-style object to manufacture [`Instance`](crate::model::Instance)
    pub fn builder() -> crate::model::instance::Builder {
        crate::model::instance::Builder::default()
    }
}

/// <p>Describes monthly data transfer rates and port information for an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceNetworking {
    /// <p>The amount of data in GB allocated for monthly data transfers.</p>
    pub monthly_transfer: std::option::Option<crate::model::MonthlyTransfer>,
    /// <p>An array of key-value pairs containing information about the ports on the instance.</p>
    pub ports: std::option::Option<std::vec::Vec<crate::model::InstancePortInfo>>,
}
impl std::fmt::Debug for InstanceNetworking {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceNetworking");
        formatter.field("monthly_transfer", &self.monthly_transfer);
        formatter.field("ports", &self.ports);
        formatter.finish()
    }
}
/// See [`InstanceNetworking`](crate::model::InstanceNetworking)
pub mod instance_networking {
    /// A builder for [`InstanceNetworking`](crate::model::InstanceNetworking)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monthly_transfer: std::option::Option<crate::model::MonthlyTransfer>,
        pub(crate) ports: std::option::Option<std::vec::Vec<crate::model::InstancePortInfo>>,
    }
    impl Builder {
        /// <p>The amount of data in GB allocated for monthly data transfers.</p>
        pub fn monthly_transfer(mut self, input: crate::model::MonthlyTransfer) -> Self {
            self.monthly_transfer = Some(input);
            self
        }
        /// <p>The amount of data in GB allocated for monthly data transfers.</p>
        pub fn set_monthly_transfer(
            mut self,
            input: std::option::Option<crate::model::MonthlyTransfer>,
        ) -> Self {
            self.monthly_transfer = input;
            self
        }
        /// Appends an item to `ports`.
        ///
        /// To override the contents of this collection use [`set_ports`](Self::set_ports).
        ///
        /// <p>An array of key-value pairs containing information about the ports on the instance.</p>
        pub fn ports(mut self, input: impl Into<crate::model::InstancePortInfo>) -> Self {
            let mut v = self.ports.unwrap_or_default();
            v.push(input.into());
            self.ports = Some(v);
            self
        }
        /// <p>An array of key-value pairs containing information about the ports on the instance.</p>
        pub fn set_ports(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstancePortInfo>>,
        ) -> Self {
            self.ports = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceNetworking`](crate::model::InstanceNetworking)
        pub fn build(self) -> crate::model::InstanceNetworking {
            crate::model::InstanceNetworking {
                monthly_transfer: self.monthly_transfer,
                ports: self.ports,
            }
        }
    }
}
impl InstanceNetworking {
    /// Creates a new builder-style object to manufacture [`InstanceNetworking`](crate::model::InstanceNetworking)
    pub fn builder() -> crate::model::instance_networking::Builder {
        crate::model::instance_networking::Builder::default()
    }
}

/// <p>Describes information about ports for an Amazon Lightsail instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstancePortInfo {
    /// <p>The first port in a range of open ports on an instance.</p>
    /// <p>Allowed ports:</p>
    /// <ul>
    /// <li>
    /// <p>TCP and UDP - <code>0</code> to <code>65535</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>ICMP - The ICMP type for IPv4 addresses. For example, specify <code>8</code> as the
    /// <code>fromPort</code> (ICMP type), and <code>-1</code> as the <code>toPort</code> (ICMP
    /// code), to enable ICMP Ping. For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages">Control Messages</a> on <i>Wikipedia</i>.</p>
    /// </li>
    /// <li>
    /// <p>ICMPv6 - The ICMP type for IPv6 addresses. For example, specify <code>128</code> as
    /// the <code>fromPort</code> (ICMPv6 type), and <code>0</code> as <code>toPort</code> (ICMPv6
    /// code). For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6">Internet
    /// Control Message Protocol for IPv6</a>.</p>
    /// </li>
    /// </ul>
    pub from_port: i32,
    /// <p>The last port in a range of open ports on an instance.</p>
    /// <p>Allowed ports:</p>
    /// <ul>
    /// <li>
    /// <p>TCP and UDP - <code>0</code> to <code>65535</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>ICMP - The ICMP code for IPv4 addresses. For example, specify <code>8</code> as the
    /// <code>fromPort</code> (ICMP type), and <code>-1</code> as the <code>toPort</code> (ICMP
    /// code), to enable ICMP Ping. For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages">Control Messages</a> on <i>Wikipedia</i>.</p>
    /// </li>
    /// <li>
    /// <p>ICMPv6 - The ICMP code for IPv6 addresses. For example, specify <code>128</code> as
    /// the <code>fromPort</code> (ICMPv6 type), and <code>0</code> as <code>toPort</code> (ICMPv6
    /// code). For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6">Internet
    /// Control Message Protocol for IPv6</a>.</p>
    /// </li>
    /// </ul>
    pub to_port: i32,
    /// <p>The IP protocol name.</p>
    /// <p>The name can be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and
    /// error-checked delivery of streamed data between applications running on hosts
    /// communicating by an IP network. If you have an application that doesn't require reliable
    /// data stream service, use UDP instead.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>all</code> - All transport layer protocol types. For more general information,
    /// see <a href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on
    /// <i>Wikipedia</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send
    /// messages (or datagrams) to other hosts on an Internet Protocol (IP) network. Prior
    /// communications are not required to set up transmission channels or data paths.
    /// Applications that don't require reliable data stream service can use UDP, which provides a
    /// connectionless datagram service that emphasizes reduced latency over reliability. If you
    /// do require reliable data stream service, use TCP instead.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>icmp</code> - Internet Control Message Protocol (ICMP) is used to send error
    /// messages and operational information indicating success or failure when communicating with
    /// an instance. For example, an error is indicated when an instance could not be reached.
    /// When you specify <code>icmp</code> as the <code>protocol</code>, you must specify the ICMP
    /// type using the <code>fromPort</code> parameter, and ICMP code using the
    /// <code>toPort</code> parameter.</p>
    /// </li>
    /// </ul>
    pub protocol: std::option::Option<crate::model::NetworkProtocol>,
    /// <p>The location from which access is allowed. For example, <code>Anywhere (0.0.0.0/0)</code>,
    /// or <code>Custom</code> if a specific IP address or range of IP addresses is allowed.</p>
    pub access_from: std::option::Option<std::string::String>,
    /// <p>The type of access (<code>Public</code> or <code>Private</code>).</p>
    pub access_type: std::option::Option<crate::model::PortAccessType>,
    /// <p>The common name of the port information.</p>
    pub common_name: std::option::Option<std::string::String>,
    /// <p>The access direction (<code>inbound</code> or <code>outbound</code>).</p>
    /// <note>
    /// <p>Lightsail currently supports only <code>inbound</code> access direction.</p>
    /// </note>
    pub access_direction: std::option::Option<crate::model::AccessDirection>,
    /// <p>The IPv4 address, or range of IPv4 addresses (in CIDR notation) that are allowed to
    /// connect to an instance through the ports, and the protocol.</p>
    /// <note>
    /// <p>The <code>ipv6Cidrs</code> parameter lists the IPv6 addresses that are allowed to
    /// connect to an instance.</p>
    /// </note>
    /// <p>For more information about CIDR block notation, see <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation">Classless
    /// Inter-Domain Routing</a> on <i>Wikipedia</i>.</p>
    pub cidrs: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IPv6 address, or range of IPv6 addresses (in CIDR notation) that are allowed to
    /// connect to an instance through the ports, and the protocol. Only devices with an IPv6 address
    /// can connect to an instance through IPv6; otherwise, IPv4 should be used.</p>
    /// <note>
    /// <p>The <code>cidrs</code> parameter lists the IPv4 addresses that are allowed to connect to
    /// an instance.</p>
    /// </note>
    /// <p>For more information about CIDR block notation, see <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation">Classless
    /// Inter-Domain Routing</a> on <i>Wikipedia</i>.</p>
    pub ipv6_cidrs: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An alias that defines access for a preconfigured range of IP addresses.</p>
    /// <p>The only alias currently supported is <code>lightsail-connect</code>, which allows IP
    /// addresses of the browser-based RDP/SSH client in the Lightsail console to connect to your
    /// instance.</p>
    pub cidr_list_aliases: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for InstancePortInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstancePortInfo");
        formatter.field("from_port", &self.from_port);
        formatter.field("to_port", &self.to_port);
        formatter.field("protocol", &self.protocol);
        formatter.field("access_from", &self.access_from);
        formatter.field("access_type", &self.access_type);
        formatter.field("common_name", &self.common_name);
        formatter.field("access_direction", &self.access_direction);
        formatter.field("cidrs", &self.cidrs);
        formatter.field("ipv6_cidrs", &self.ipv6_cidrs);
        formatter.field("cidr_list_aliases", &self.cidr_list_aliases);
        formatter.finish()
    }
}
/// See [`InstancePortInfo`](crate::model::InstancePortInfo)
pub mod instance_port_info {
    /// A builder for [`InstancePortInfo`](crate::model::InstancePortInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_port: std::option::Option<i32>,
        pub(crate) to_port: std::option::Option<i32>,
        pub(crate) protocol: std::option::Option<crate::model::NetworkProtocol>,
        pub(crate) access_from: std::option::Option<std::string::String>,
        pub(crate) access_type: std::option::Option<crate::model::PortAccessType>,
        pub(crate) common_name: std::option::Option<std::string::String>,
        pub(crate) access_direction: std::option::Option<crate::model::AccessDirection>,
        pub(crate) cidrs: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ipv6_cidrs: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cidr_list_aliases: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The first port in a range of open ports on an instance.</p>
        /// <p>Allowed ports:</p>
        /// <ul>
        /// <li>
        /// <p>TCP and UDP - <code>0</code> to <code>65535</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>ICMP - The ICMP type for IPv4 addresses. For example, specify <code>8</code> as the
        /// <code>fromPort</code> (ICMP type), and <code>-1</code> as the <code>toPort</code> (ICMP
        /// code), to enable ICMP Ping. For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages">Control Messages</a> on <i>Wikipedia</i>.</p>
        /// </li>
        /// <li>
        /// <p>ICMPv6 - The ICMP type for IPv6 addresses. For example, specify <code>128</code> as
        /// the <code>fromPort</code> (ICMPv6 type), and <code>0</code> as <code>toPort</code> (ICMPv6
        /// code). For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6">Internet
        /// Control Message Protocol for IPv6</a>.</p>
        /// </li>
        /// </ul>
        pub fn from_port(mut self, input: i32) -> Self {
            self.from_port = Some(input);
            self
        }
        /// <p>The first port in a range of open ports on an instance.</p>
        /// <p>Allowed ports:</p>
        /// <ul>
        /// <li>
        /// <p>TCP and UDP - <code>0</code> to <code>65535</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>ICMP - The ICMP type for IPv4 addresses. For example, specify <code>8</code> as the
        /// <code>fromPort</code> (ICMP type), and <code>-1</code> as the <code>toPort</code> (ICMP
        /// code), to enable ICMP Ping. For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages">Control Messages</a> on <i>Wikipedia</i>.</p>
        /// </li>
        /// <li>
        /// <p>ICMPv6 - The ICMP type for IPv6 addresses. For example, specify <code>128</code> as
        /// the <code>fromPort</code> (ICMPv6 type), and <code>0</code> as <code>toPort</code> (ICMPv6
        /// code). For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6">Internet
        /// Control Message Protocol for IPv6</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_from_port(mut self, input: std::option::Option<i32>) -> Self {
            self.from_port = input;
            self
        }
        /// <p>The last port in a range of open ports on an instance.</p>
        /// <p>Allowed ports:</p>
        /// <ul>
        /// <li>
        /// <p>TCP and UDP - <code>0</code> to <code>65535</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>ICMP - The ICMP code for IPv4 addresses. For example, specify <code>8</code> as the
        /// <code>fromPort</code> (ICMP type), and <code>-1</code> as the <code>toPort</code> (ICMP
        /// code), to enable ICMP Ping. For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages">Control Messages</a> on <i>Wikipedia</i>.</p>
        /// </li>
        /// <li>
        /// <p>ICMPv6 - The ICMP code for IPv6 addresses. For example, specify <code>128</code> as
        /// the <code>fromPort</code> (ICMPv6 type), and <code>0</code> as <code>toPort</code> (ICMPv6
        /// code). For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6">Internet
        /// Control Message Protocol for IPv6</a>.</p>
        /// </li>
        /// </ul>
        pub fn to_port(mut self, input: i32) -> Self {
            self.to_port = Some(input);
            self
        }
        /// <p>The last port in a range of open ports on an instance.</p>
        /// <p>Allowed ports:</p>
        /// <ul>
        /// <li>
        /// <p>TCP and UDP - <code>0</code> to <code>65535</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>ICMP - The ICMP code for IPv4 addresses. For example, specify <code>8</code> as the
        /// <code>fromPort</code> (ICMP type), and <code>-1</code> as the <code>toPort</code> (ICMP
        /// code), to enable ICMP Ping. For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages">Control Messages</a> on <i>Wikipedia</i>.</p>
        /// </li>
        /// <li>
        /// <p>ICMPv6 - The ICMP code for IPv6 addresses. For example, specify <code>128</code> as
        /// the <code>fromPort</code> (ICMPv6 type), and <code>0</code> as <code>toPort</code> (ICMPv6
        /// code). For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6">Internet
        /// Control Message Protocol for IPv6</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_to_port(mut self, input: std::option::Option<i32>) -> Self {
            self.to_port = input;
            self
        }
        /// <p>The IP protocol name.</p>
        /// <p>The name can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and
        /// error-checked delivery of streamed data between applications running on hosts
        /// communicating by an IP network. If you have an application that doesn't require reliable
        /// data stream service, use UDP instead.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>all</code> - All transport layer protocol types. For more general information,
        /// see <a href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on
        /// <i>Wikipedia</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send
        /// messages (or datagrams) to other hosts on an Internet Protocol (IP) network. Prior
        /// communications are not required to set up transmission channels or data paths.
        /// Applications that don't require reliable data stream service can use UDP, which provides a
        /// connectionless datagram service that emphasizes reduced latency over reliability. If you
        /// do require reliable data stream service, use TCP instead.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>icmp</code> - Internet Control Message Protocol (ICMP) is used to send error
        /// messages and operational information indicating success or failure when communicating with
        /// an instance. For example, an error is indicated when an instance could not be reached.
        /// When you specify <code>icmp</code> as the <code>protocol</code>, you must specify the ICMP
        /// type using the <code>fromPort</code> parameter, and ICMP code using the
        /// <code>toPort</code> parameter.</p>
        /// </li>
        /// </ul>
        pub fn protocol(mut self, input: crate::model::NetworkProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The IP protocol name.</p>
        /// <p>The name can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and
        /// error-checked delivery of streamed data between applications running on hosts
        /// communicating by an IP network. If you have an application that doesn't require reliable
        /// data stream service, use UDP instead.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>all</code> - All transport layer protocol types. For more general information,
        /// see <a href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on
        /// <i>Wikipedia</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send
        /// messages (or datagrams) to other hosts on an Internet Protocol (IP) network. Prior
        /// communications are not required to set up transmission channels or data paths.
        /// Applications that don't require reliable data stream service can use UDP, which provides a
        /// connectionless datagram service that emphasizes reduced latency over reliability. If you
        /// do require reliable data stream service, use TCP instead.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>icmp</code> - Internet Control Message Protocol (ICMP) is used to send error
        /// messages and operational information indicating success or failure when communicating with
        /// an instance. For example, an error is indicated when an instance could not be reached.
        /// When you specify <code>icmp</code> as the <code>protocol</code>, you must specify the ICMP
        /// type using the <code>fromPort</code> parameter, and ICMP code using the
        /// <code>toPort</code> parameter.</p>
        /// </li>
        /// </ul>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::NetworkProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// <p>The location from which access is allowed. For example, <code>Anywhere (0.0.0.0/0)</code>,
        /// or <code>Custom</code> if a specific IP address or range of IP addresses is allowed.</p>
        pub fn access_from(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_from = Some(input.into());
            self
        }
        /// <p>The location from which access is allowed. For example, <code>Anywhere (0.0.0.0/0)</code>,
        /// or <code>Custom</code> if a specific IP address or range of IP addresses is allowed.</p>
        pub fn set_access_from(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.access_from = input;
            self
        }
        /// <p>The type of access (<code>Public</code> or <code>Private</code>).</p>
        pub fn access_type(mut self, input: crate::model::PortAccessType) -> Self {
            self.access_type = Some(input);
            self
        }
        /// <p>The type of access (<code>Public</code> or <code>Private</code>).</p>
        pub fn set_access_type(
            mut self,
            input: std::option::Option<crate::model::PortAccessType>,
        ) -> Self {
            self.access_type = input;
            self
        }
        /// <p>The common name of the port information.</p>
        pub fn common_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.common_name = Some(input.into());
            self
        }
        /// <p>The common name of the port information.</p>
        pub fn set_common_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.common_name = input;
            self
        }
        /// <p>The access direction (<code>inbound</code> or <code>outbound</code>).</p>
        /// <note>
        /// <p>Lightsail currently supports only <code>inbound</code> access direction.</p>
        /// </note>
        pub fn access_direction(mut self, input: crate::model::AccessDirection) -> Self {
            self.access_direction = Some(input);
            self
        }
        /// <p>The access direction (<code>inbound</code> or <code>outbound</code>).</p>
        /// <note>
        /// <p>Lightsail currently supports only <code>inbound</code> access direction.</p>
        /// </note>
        pub fn set_access_direction(
            mut self,
            input: std::option::Option<crate::model::AccessDirection>,
        ) -> Self {
            self.access_direction = input;
            self
        }
        /// Appends an item to `cidrs`.
        ///
        /// To override the contents of this collection use [`set_cidrs`](Self::set_cidrs).
        ///
        /// <p>The IPv4 address, or range of IPv4 addresses (in CIDR notation) that are allowed to
        /// connect to an instance through the ports, and the protocol.</p>
        /// <note>
        /// <p>The <code>ipv6Cidrs</code> parameter lists the IPv6 addresses that are allowed to
        /// connect to an instance.</p>
        /// </note>
        /// <p>For more information about CIDR block notation, see <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation">Classless
        /// Inter-Domain Routing</a> on <i>Wikipedia</i>.</p>
        pub fn cidrs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cidrs.unwrap_or_default();
            v.push(input.into());
            self.cidrs = Some(v);
            self
        }
        /// <p>The IPv4 address, or range of IPv4 addresses (in CIDR notation) that are allowed to
        /// connect to an instance through the ports, and the protocol.</p>
        /// <note>
        /// <p>The <code>ipv6Cidrs</code> parameter lists the IPv6 addresses that are allowed to
        /// connect to an instance.</p>
        /// </note>
        /// <p>For more information about CIDR block notation, see <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation">Classless
        /// Inter-Domain Routing</a> on <i>Wikipedia</i>.</p>
        pub fn set_cidrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cidrs = input;
            self
        }
        /// Appends an item to `ipv6_cidrs`.
        ///
        /// To override the contents of this collection use [`set_ipv6_cidrs`](Self::set_ipv6_cidrs).
        ///
        /// <p>The IPv6 address, or range of IPv6 addresses (in CIDR notation) that are allowed to
        /// connect to an instance through the ports, and the protocol. Only devices with an IPv6 address
        /// can connect to an instance through IPv6; otherwise, IPv4 should be used.</p>
        /// <note>
        /// <p>The <code>cidrs</code> parameter lists the IPv4 addresses that are allowed to connect to
        /// an instance.</p>
        /// </note>
        /// <p>For more information about CIDR block notation, see <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation">Classless
        /// Inter-Domain Routing</a> on <i>Wikipedia</i>.</p>
        pub fn ipv6_cidrs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ipv6_cidrs.unwrap_or_default();
            v.push(input.into());
            self.ipv6_cidrs = Some(v);
            self
        }
        /// <p>The IPv6 address, or range of IPv6 addresses (in CIDR notation) that are allowed to
        /// connect to an instance through the ports, and the protocol. Only devices with an IPv6 address
        /// can connect to an instance through IPv6; otherwise, IPv4 should be used.</p>
        /// <note>
        /// <p>The <code>cidrs</code> parameter lists the IPv4 addresses that are allowed to connect to
        /// an instance.</p>
        /// </note>
        /// <p>For more information about CIDR block notation, see <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation">Classless
        /// Inter-Domain Routing</a> on <i>Wikipedia</i>.</p>
        pub fn set_ipv6_cidrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ipv6_cidrs = input;
            self
        }
        /// Appends an item to `cidr_list_aliases`.
        ///
        /// To override the contents of this collection use [`set_cidr_list_aliases`](Self::set_cidr_list_aliases).
        ///
        /// <p>An alias that defines access for a preconfigured range of IP addresses.</p>
        /// <p>The only alias currently supported is <code>lightsail-connect</code>, which allows IP
        /// addresses of the browser-based RDP/SSH client in the Lightsail console to connect to your
        /// instance.</p>
        pub fn cidr_list_aliases(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cidr_list_aliases.unwrap_or_default();
            v.push(input.into());
            self.cidr_list_aliases = Some(v);
            self
        }
        /// <p>An alias that defines access for a preconfigured range of IP addresses.</p>
        /// <p>The only alias currently supported is <code>lightsail-connect</code>, which allows IP
        /// addresses of the browser-based RDP/SSH client in the Lightsail console to connect to your
        /// instance.</p>
        pub fn set_cidr_list_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cidr_list_aliases = input;
            self
        }
        /// Consumes the builder and constructs a [`InstancePortInfo`](crate::model::InstancePortInfo)
        pub fn build(self) -> crate::model::InstancePortInfo {
            crate::model::InstancePortInfo {
                from_port: self.from_port.unwrap_or_default(),
                to_port: self.to_port.unwrap_or_default(),
                protocol: self.protocol,
                access_from: self.access_from,
                access_type: self.access_type,
                common_name: self.common_name,
                access_direction: self.access_direction,
                cidrs: self.cidrs,
                ipv6_cidrs: self.ipv6_cidrs,
                cidr_list_aliases: self.cidr_list_aliases,
            }
        }
    }
}
impl InstancePortInfo {
    /// Creates a new builder-style object to manufacture [`InstancePortInfo`](crate::model::InstancePortInfo)
    pub fn builder() -> crate::model::instance_port_info::Builder {
        crate::model::instance_port_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccessDirection {
    #[allow(missing_docs)] // documentation missing in model
    Inbound,
    #[allow(missing_docs)] // documentation missing in model
    Outbound,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccessDirection {
    fn from(s: &str) -> Self {
        match s {
            "inbound" => AccessDirection::Inbound,
            "outbound" => AccessDirection::Outbound,
            other => AccessDirection::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccessDirection {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccessDirection::from(s))
    }
}
impl AccessDirection {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccessDirection::Inbound => "inbound",
            AccessDirection::Outbound => "outbound",
            AccessDirection::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["inbound", "outbound"]
    }
}
impl AsRef<str> for AccessDirection {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PortAccessType {
    #[allow(missing_docs)] // documentation missing in model
    Private,
    #[allow(missing_docs)] // documentation missing in model
    Public,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PortAccessType {
    fn from(s: &str) -> Self {
        match s {
            "Private" => PortAccessType::Private,
            "Public" => PortAccessType::Public,
            other => PortAccessType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PortAccessType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PortAccessType::from(s))
    }
}
impl PortAccessType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PortAccessType::Private => "Private",
            PortAccessType::Public => "Public",
            PortAccessType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Private", "Public"]
    }
}
impl AsRef<str> for PortAccessType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the monthly data transfer in and out of your virtual private server (or
/// <i>instance</i>).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MonthlyTransfer {
    /// <p>The amount allocated per month (in GB).</p>
    pub gb_per_month_allocated: std::option::Option<i32>,
}
impl std::fmt::Debug for MonthlyTransfer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MonthlyTransfer");
        formatter.field("gb_per_month_allocated", &self.gb_per_month_allocated);
        formatter.finish()
    }
}
/// See [`MonthlyTransfer`](crate::model::MonthlyTransfer)
pub mod monthly_transfer {
    /// A builder for [`MonthlyTransfer`](crate::model::MonthlyTransfer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) gb_per_month_allocated: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The amount allocated per month (in GB).</p>
        pub fn gb_per_month_allocated(mut self, input: i32) -> Self {
            self.gb_per_month_allocated = Some(input);
            self
        }
        /// <p>The amount allocated per month (in GB).</p>
        pub fn set_gb_per_month_allocated(mut self, input: std::option::Option<i32>) -> Self {
            self.gb_per_month_allocated = input;
            self
        }
        /// Consumes the builder and constructs a [`MonthlyTransfer`](crate::model::MonthlyTransfer)
        pub fn build(self) -> crate::model::MonthlyTransfer {
            crate::model::MonthlyTransfer {
                gb_per_month_allocated: self.gb_per_month_allocated,
            }
        }
    }
}
impl MonthlyTransfer {
    /// Creates a new builder-style object to manufacture [`MonthlyTransfer`](crate::model::MonthlyTransfer)
    pub fn builder() -> crate::model::monthly_transfer::Builder {
        crate::model::monthly_transfer::Builder::default()
    }
}

/// <p>Describes the hardware for the instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceHardware {
    /// <p>The number of vCPUs the instance has.</p>
    pub cpu_count: std::option::Option<i32>,
    /// <p>The disks attached to the instance.</p>
    pub disks: std::option::Option<std::vec::Vec<crate::model::Disk>>,
    /// <p>The amount of RAM in GB on the instance (e.g., <code>1.0</code>).</p>
    pub ram_size_in_gb: std::option::Option<f32>,
}
impl std::fmt::Debug for InstanceHardware {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceHardware");
        formatter.field("cpu_count", &self.cpu_count);
        formatter.field("disks", &self.disks);
        formatter.field("ram_size_in_gb", &self.ram_size_in_gb);
        formatter.finish()
    }
}
/// See [`InstanceHardware`](crate::model::InstanceHardware)
pub mod instance_hardware {
    /// A builder for [`InstanceHardware`](crate::model::InstanceHardware)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cpu_count: std::option::Option<i32>,
        pub(crate) disks: std::option::Option<std::vec::Vec<crate::model::Disk>>,
        pub(crate) ram_size_in_gb: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>The number of vCPUs the instance has.</p>
        pub fn cpu_count(mut self, input: i32) -> Self {
            self.cpu_count = Some(input);
            self
        }
        /// <p>The number of vCPUs the instance has.</p>
        pub fn set_cpu_count(mut self, input: std::option::Option<i32>) -> Self {
            self.cpu_count = input;
            self
        }
        /// Appends an item to `disks`.
        ///
        /// To override the contents of this collection use [`set_disks`](Self::set_disks).
        ///
        /// <p>The disks attached to the instance.</p>
        pub fn disks(mut self, input: impl Into<crate::model::Disk>) -> Self {
            let mut v = self.disks.unwrap_or_default();
            v.push(input.into());
            self.disks = Some(v);
            self
        }
        /// <p>The disks attached to the instance.</p>
        pub fn set_disks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Disk>>,
        ) -> Self {
            self.disks = input;
            self
        }
        /// <p>The amount of RAM in GB on the instance (e.g., <code>1.0</code>).</p>
        pub fn ram_size_in_gb(mut self, input: f32) -> Self {
            self.ram_size_in_gb = Some(input);
            self
        }
        /// <p>The amount of RAM in GB on the instance (e.g., <code>1.0</code>).</p>
        pub fn set_ram_size_in_gb(mut self, input: std::option::Option<f32>) -> Self {
            self.ram_size_in_gb = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceHardware`](crate::model::InstanceHardware)
        pub fn build(self) -> crate::model::InstanceHardware {
            crate::model::InstanceHardware {
                cpu_count: self.cpu_count,
                disks: self.disks,
                ram_size_in_gb: self.ram_size_in_gb,
            }
        }
    }
}
impl InstanceHardware {
    /// Creates a new builder-style object to manufacture [`InstanceHardware`](crate::model::InstanceHardware)
    pub fn builder() -> crate::model::instance_hardware::Builder {
        crate::model::instance_hardware::Builder::default()
    }
}

/// <p>Describes open ports on an instance, the IP addresses allowed to connect to the instance
/// through the ports, and the protocol.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstancePortState {
    /// <p>The first port in a range of open ports on an instance.</p>
    /// <p>Allowed ports:</p>
    /// <ul>
    /// <li>
    /// <p>TCP and UDP - <code>0</code> to <code>65535</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>ICMP - The ICMP type for IPv4 addresses. For example, specify <code>8</code> as the
    /// <code>fromPort</code> (ICMP type), and <code>-1</code> as the <code>toPort</code> (ICMP
    /// code), to enable ICMP Ping. For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages">Control Messages</a> on <i>Wikipedia</i>.</p>
    /// </li>
    /// <li>
    /// <p>ICMPv6 - The ICMP type for IPv6 addresses. For example, specify <code>128</code> as
    /// the <code>fromPort</code> (ICMPv6 type), and <code>0</code> as <code>toPort</code> (ICMPv6
    /// code). For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6">Internet
    /// Control Message Protocol for IPv6</a>.</p>
    /// </li>
    /// </ul>
    pub from_port: i32,
    /// <p>The last port in a range of open ports on an instance.</p>
    /// <p>Allowed ports:</p>
    /// <ul>
    /// <li>
    /// <p>TCP and UDP - <code>0</code> to <code>65535</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>ICMP - The ICMP code for IPv4 addresses. For example, specify <code>8</code> as the
    /// <code>fromPort</code> (ICMP type), and <code>-1</code> as the <code>toPort</code> (ICMP
    /// code), to enable ICMP Ping. For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages">Control Messages</a> on <i>Wikipedia</i>.</p>
    /// </li>
    /// <li>
    /// <p>ICMPv6 - The ICMP code for IPv6 addresses. For example, specify <code>128</code> as
    /// the <code>fromPort</code> (ICMPv6 type), and <code>0</code> as <code>toPort</code> (ICMPv6
    /// code). For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6">Internet
    /// Control Message Protocol for IPv6</a>.</p>
    /// </li>
    /// </ul>
    pub to_port: i32,
    /// <p>The IP protocol name.</p>
    /// <p>The name can be one of the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and
    /// error-checked delivery of streamed data between applications running on hosts
    /// communicating by an IP network. If you have an application that doesn't require reliable
    /// data stream service, use UDP instead.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>all</code> - All transport layer protocol types. For more general information,
    /// see <a href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on
    /// <i>Wikipedia</i>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send
    /// messages (or datagrams) to other hosts on an Internet Protocol (IP) network. Prior
    /// communications are not required to set up transmission channels or data paths.
    /// Applications that don't require reliable data stream service can use UDP, which provides a
    /// connectionless datagram service that emphasizes reduced latency over reliability. If you
    /// do require reliable data stream service, use TCP instead.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>icmp</code> - Internet Control Message Protocol (ICMP) is used to send error
    /// messages and operational information indicating success or failure when communicating with
    /// an instance. For example, an error is indicated when an instance could not be reached.
    /// When you specify <code>icmp</code> as the <code>protocol</code>, you must specify the ICMP
    /// type using the <code>fromPort</code> parameter, and ICMP code using the
    /// <code>toPort</code> parameter.</p>
    /// </li>
    /// </ul>
    pub protocol: std::option::Option<crate::model::NetworkProtocol>,
    /// <p>Specifies whether the instance port is <code>open</code> or <code>closed</code>.</p>
    /// <note>
    /// <p>The port state for Lightsail instances is always <code>open</code>.</p>
    /// </note>
    pub state: std::option::Option<crate::model::PortState>,
    /// <p>The IPv4 address, or range of IPv4 addresses (in CIDR notation) that are allowed to
    /// connect to an instance through the ports, and the protocol.</p>
    /// <note>
    /// <p>The <code>ipv6Cidrs</code> parameter lists the IPv6 addresses that are allowed to
    /// connect to an instance.</p>
    /// </note>
    /// <p>For more information about CIDR block notation, see <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation">Classless
    /// Inter-Domain Routing</a> on <i>Wikipedia</i>.</p>
    pub cidrs: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The IPv6 address, or range of IPv6 addresses (in CIDR notation) that are allowed to
    /// connect to an instance through the ports, and the protocol. Only devices with an IPv6 address
    /// can connect to an instance through IPv6; otherwise, IPv4 should be used.</p>
    /// <note>
    /// <p>The <code>cidrs</code> parameter lists the IPv4 addresses that are allowed to connect to
    /// an instance.</p>
    /// </note>
    /// <p>For more information about CIDR block notation, see <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation">Classless
    /// Inter-Domain Routing</a> on <i>Wikipedia</i>.</p>
    pub ipv6_cidrs: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An alias that defines access for a preconfigured range of IP addresses.</p>
    /// <p>The only alias currently supported is <code>lightsail-connect</code>, which allows IP
    /// addresses of the browser-based RDP/SSH client in the Lightsail console to connect to your
    /// instance.</p>
    pub cidr_list_aliases: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for InstancePortState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstancePortState");
        formatter.field("from_port", &self.from_port);
        formatter.field("to_port", &self.to_port);
        formatter.field("protocol", &self.protocol);
        formatter.field("state", &self.state);
        formatter.field("cidrs", &self.cidrs);
        formatter.field("ipv6_cidrs", &self.ipv6_cidrs);
        formatter.field("cidr_list_aliases", &self.cidr_list_aliases);
        formatter.finish()
    }
}
/// See [`InstancePortState`](crate::model::InstancePortState)
pub mod instance_port_state {
    /// A builder for [`InstancePortState`](crate::model::InstancePortState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_port: std::option::Option<i32>,
        pub(crate) to_port: std::option::Option<i32>,
        pub(crate) protocol: std::option::Option<crate::model::NetworkProtocol>,
        pub(crate) state: std::option::Option<crate::model::PortState>,
        pub(crate) cidrs: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) ipv6_cidrs: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cidr_list_aliases: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The first port in a range of open ports on an instance.</p>
        /// <p>Allowed ports:</p>
        /// <ul>
        /// <li>
        /// <p>TCP and UDP - <code>0</code> to <code>65535</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>ICMP - The ICMP type for IPv4 addresses. For example, specify <code>8</code> as the
        /// <code>fromPort</code> (ICMP type), and <code>-1</code> as the <code>toPort</code> (ICMP
        /// code), to enable ICMP Ping. For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages">Control Messages</a> on <i>Wikipedia</i>.</p>
        /// </li>
        /// <li>
        /// <p>ICMPv6 - The ICMP type for IPv6 addresses. For example, specify <code>128</code> as
        /// the <code>fromPort</code> (ICMPv6 type), and <code>0</code> as <code>toPort</code> (ICMPv6
        /// code). For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6">Internet
        /// Control Message Protocol for IPv6</a>.</p>
        /// </li>
        /// </ul>
        pub fn from_port(mut self, input: i32) -> Self {
            self.from_port = Some(input);
            self
        }
        /// <p>The first port in a range of open ports on an instance.</p>
        /// <p>Allowed ports:</p>
        /// <ul>
        /// <li>
        /// <p>TCP and UDP - <code>0</code> to <code>65535</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>ICMP - The ICMP type for IPv4 addresses. For example, specify <code>8</code> as the
        /// <code>fromPort</code> (ICMP type), and <code>-1</code> as the <code>toPort</code> (ICMP
        /// code), to enable ICMP Ping. For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages">Control Messages</a> on <i>Wikipedia</i>.</p>
        /// </li>
        /// <li>
        /// <p>ICMPv6 - The ICMP type for IPv6 addresses. For example, specify <code>128</code> as
        /// the <code>fromPort</code> (ICMPv6 type), and <code>0</code> as <code>toPort</code> (ICMPv6
        /// code). For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6">Internet
        /// Control Message Protocol for IPv6</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_from_port(mut self, input: std::option::Option<i32>) -> Self {
            self.from_port = input;
            self
        }
        /// <p>The last port in a range of open ports on an instance.</p>
        /// <p>Allowed ports:</p>
        /// <ul>
        /// <li>
        /// <p>TCP and UDP - <code>0</code> to <code>65535</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>ICMP - The ICMP code for IPv4 addresses. For example, specify <code>8</code> as the
        /// <code>fromPort</code> (ICMP type), and <code>-1</code> as the <code>toPort</code> (ICMP
        /// code), to enable ICMP Ping. For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages">Control Messages</a> on <i>Wikipedia</i>.</p>
        /// </li>
        /// <li>
        /// <p>ICMPv6 - The ICMP code for IPv6 addresses. For example, specify <code>128</code> as
        /// the <code>fromPort</code> (ICMPv6 type), and <code>0</code> as <code>toPort</code> (ICMPv6
        /// code). For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6">Internet
        /// Control Message Protocol for IPv6</a>.</p>
        /// </li>
        /// </ul>
        pub fn to_port(mut self, input: i32) -> Self {
            self.to_port = Some(input);
            self
        }
        /// <p>The last port in a range of open ports on an instance.</p>
        /// <p>Allowed ports:</p>
        /// <ul>
        /// <li>
        /// <p>TCP and UDP - <code>0</code> to <code>65535</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>ICMP - The ICMP code for IPv4 addresses. For example, specify <code>8</code> as the
        /// <code>fromPort</code> (ICMP type), and <code>-1</code> as the <code>toPort</code> (ICMP
        /// code), to enable ICMP Ping. For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages">Control Messages</a> on <i>Wikipedia</i>.</p>
        /// </li>
        /// <li>
        /// <p>ICMPv6 - The ICMP code for IPv6 addresses. For example, specify <code>128</code> as
        /// the <code>fromPort</code> (ICMPv6 type), and <code>0</code> as <code>toPort</code> (ICMPv6
        /// code). For more information, see <a href="https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6">Internet
        /// Control Message Protocol for IPv6</a>.</p>
        /// </li>
        /// </ul>
        pub fn set_to_port(mut self, input: std::option::Option<i32>) -> Self {
            self.to_port = input;
            self
        }
        /// <p>The IP protocol name.</p>
        /// <p>The name can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and
        /// error-checked delivery of streamed data between applications running on hosts
        /// communicating by an IP network. If you have an application that doesn't require reliable
        /// data stream service, use UDP instead.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>all</code> - All transport layer protocol types. For more general information,
        /// see <a href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on
        /// <i>Wikipedia</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send
        /// messages (or datagrams) to other hosts on an Internet Protocol (IP) network. Prior
        /// communications are not required to set up transmission channels or data paths.
        /// Applications that don't require reliable data stream service can use UDP, which provides a
        /// connectionless datagram service that emphasizes reduced latency over reliability. If you
        /// do require reliable data stream service, use TCP instead.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>icmp</code> - Internet Control Message Protocol (ICMP) is used to send error
        /// messages and operational information indicating success or failure when communicating with
        /// an instance. For example, an error is indicated when an instance could not be reached.
        /// When you specify <code>icmp</code> as the <code>protocol</code>, you must specify the ICMP
        /// type using the <code>fromPort</code> parameter, and ICMP code using the
        /// <code>toPort</code> parameter.</p>
        /// </li>
        /// </ul>
        pub fn protocol(mut self, input: crate::model::NetworkProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The IP protocol name.</p>
        /// <p>The name can be one of the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and
        /// error-checked delivery of streamed data between applications running on hosts
        /// communicating by an IP network. If you have an application that doesn't require reliable
        /// data stream service, use UDP instead.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>all</code> - All transport layer protocol types. For more general information,
        /// see <a href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on
        /// <i>Wikipedia</i>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send
        /// messages (or datagrams) to other hosts on an Internet Protocol (IP) network. Prior
        /// communications are not required to set up transmission channels or data paths.
        /// Applications that don't require reliable data stream service can use UDP, which provides a
        /// connectionless datagram service that emphasizes reduced latency over reliability. If you
        /// do require reliable data stream service, use TCP instead.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>icmp</code> - Internet Control Message Protocol (ICMP) is used to send error
        /// messages and operational information indicating success or failure when communicating with
        /// an instance. For example, an error is indicated when an instance could not be reached.
        /// When you specify <code>icmp</code> as the <code>protocol</code>, you must specify the ICMP
        /// type using the <code>fromPort</code> parameter, and ICMP code using the
        /// <code>toPort</code> parameter.</p>
        /// </li>
        /// </ul>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::NetworkProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// <p>Specifies whether the instance port is <code>open</code> or <code>closed</code>.</p>
        /// <note>
        /// <p>The port state for Lightsail instances is always <code>open</code>.</p>
        /// </note>
        pub fn state(mut self, input: crate::model::PortState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>Specifies whether the instance port is <code>open</code> or <code>closed</code>.</p>
        /// <note>
        /// <p>The port state for Lightsail instances is always <code>open</code>.</p>
        /// </note>
        pub fn set_state(mut self, input: std::option::Option<crate::model::PortState>) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `cidrs`.
        ///
        /// To override the contents of this collection use [`set_cidrs`](Self::set_cidrs).
        ///
        /// <p>The IPv4 address, or range of IPv4 addresses (in CIDR notation) that are allowed to
        /// connect to an instance through the ports, and the protocol.</p>
        /// <note>
        /// <p>The <code>ipv6Cidrs</code> parameter lists the IPv6 addresses that are allowed to
        /// connect to an instance.</p>
        /// </note>
        /// <p>For more information about CIDR block notation, see <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation">Classless
        /// Inter-Domain Routing</a> on <i>Wikipedia</i>.</p>
        pub fn cidrs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cidrs.unwrap_or_default();
            v.push(input.into());
            self.cidrs = Some(v);
            self
        }
        /// <p>The IPv4 address, or range of IPv4 addresses (in CIDR notation) that are allowed to
        /// connect to an instance through the ports, and the protocol.</p>
        /// <note>
        /// <p>The <code>ipv6Cidrs</code> parameter lists the IPv6 addresses that are allowed to
        /// connect to an instance.</p>
        /// </note>
        /// <p>For more information about CIDR block notation, see <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation">Classless
        /// Inter-Domain Routing</a> on <i>Wikipedia</i>.</p>
        pub fn set_cidrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cidrs = input;
            self
        }
        /// Appends an item to `ipv6_cidrs`.
        ///
        /// To override the contents of this collection use [`set_ipv6_cidrs`](Self::set_ipv6_cidrs).
        ///
        /// <p>The IPv6 address, or range of IPv6 addresses (in CIDR notation) that are allowed to
        /// connect to an instance through the ports, and the protocol. Only devices with an IPv6 address
        /// can connect to an instance through IPv6; otherwise, IPv4 should be used.</p>
        /// <note>
        /// <p>The <code>cidrs</code> parameter lists the IPv4 addresses that are allowed to connect to
        /// an instance.</p>
        /// </note>
        /// <p>For more information about CIDR block notation, see <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation">Classless
        /// Inter-Domain Routing</a> on <i>Wikipedia</i>.</p>
        pub fn ipv6_cidrs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ipv6_cidrs.unwrap_or_default();
            v.push(input.into());
            self.ipv6_cidrs = Some(v);
            self
        }
        /// <p>The IPv6 address, or range of IPv6 addresses (in CIDR notation) that are allowed to
        /// connect to an instance through the ports, and the protocol. Only devices with an IPv6 address
        /// can connect to an instance through IPv6; otherwise, IPv4 should be used.</p>
        /// <note>
        /// <p>The <code>cidrs</code> parameter lists the IPv4 addresses that are allowed to connect to
        /// an instance.</p>
        /// </note>
        /// <p>For more information about CIDR block notation, see <a href="https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation">Classless
        /// Inter-Domain Routing</a> on <i>Wikipedia</i>.</p>
        pub fn set_ipv6_cidrs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ipv6_cidrs = input;
            self
        }
        /// Appends an item to `cidr_list_aliases`.
        ///
        /// To override the contents of this collection use [`set_cidr_list_aliases`](Self::set_cidr_list_aliases).
        ///
        /// <p>An alias that defines access for a preconfigured range of IP addresses.</p>
        /// <p>The only alias currently supported is <code>lightsail-connect</code>, which allows IP
        /// addresses of the browser-based RDP/SSH client in the Lightsail console to connect to your
        /// instance.</p>
        pub fn cidr_list_aliases(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cidr_list_aliases.unwrap_or_default();
            v.push(input.into());
            self.cidr_list_aliases = Some(v);
            self
        }
        /// <p>An alias that defines access for a preconfigured range of IP addresses.</p>
        /// <p>The only alias currently supported is <code>lightsail-connect</code>, which allows IP
        /// addresses of the browser-based RDP/SSH client in the Lightsail console to connect to your
        /// instance.</p>
        pub fn set_cidr_list_aliases(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cidr_list_aliases = input;
            self
        }
        /// Consumes the builder and constructs a [`InstancePortState`](crate::model::InstancePortState)
        pub fn build(self) -> crate::model::InstancePortState {
            crate::model::InstancePortState {
                from_port: self.from_port.unwrap_or_default(),
                to_port: self.to_port.unwrap_or_default(),
                protocol: self.protocol,
                state: self.state,
                cidrs: self.cidrs,
                ipv6_cidrs: self.ipv6_cidrs,
                cidr_list_aliases: self.cidr_list_aliases,
            }
        }
    }
}
impl InstancePortState {
    /// Creates a new builder-style object to manufacture [`InstancePortState`](crate::model::InstancePortState)
    pub fn builder() -> crate::model::instance_port_state::Builder {
        crate::model::instance_port_state::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PortState {
    #[allow(missing_docs)] // documentation missing in model
    Closed,
    #[allow(missing_docs)] // documentation missing in model
    Open,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PortState {
    fn from(s: &str) -> Self {
        match s {
            "closed" => PortState::Closed,
            "open" => PortState::Open,
            other => PortState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PortState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PortState::from(s))
    }
}
impl PortState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PortState::Closed => "closed",
            PortState::Open => "open",
            PortState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["closed", "open"]
    }
}
impl AsRef<str> for PortState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceMetricName {
    #[allow(missing_docs)] // documentation missing in model
    BurstCapacityPercentage,
    #[allow(missing_docs)] // documentation missing in model
    BurstCapacityTime,
    #[allow(missing_docs)] // documentation missing in model
    CpuUtilization,
    #[allow(missing_docs)] // documentation missing in model
    NetworkIn,
    #[allow(missing_docs)] // documentation missing in model
    NetworkOut,
    #[allow(missing_docs)] // documentation missing in model
    StatusCheckFailed,
    #[allow(missing_docs)] // documentation missing in model
    StatusCheckFailedInstance,
    #[allow(missing_docs)] // documentation missing in model
    StatusCheckFailedSystem,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceMetricName {
    fn from(s: &str) -> Self {
        match s {
            "BurstCapacityPercentage" => InstanceMetricName::BurstCapacityPercentage,
            "BurstCapacityTime" => InstanceMetricName::BurstCapacityTime,
            "CPUUtilization" => InstanceMetricName::CpuUtilization,
            "NetworkIn" => InstanceMetricName::NetworkIn,
            "NetworkOut" => InstanceMetricName::NetworkOut,
            "StatusCheckFailed" => InstanceMetricName::StatusCheckFailed,
            "StatusCheckFailed_Instance" => InstanceMetricName::StatusCheckFailedInstance,
            "StatusCheckFailed_System" => InstanceMetricName::StatusCheckFailedSystem,
            other => InstanceMetricName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceMetricName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceMetricName::from(s))
    }
}
impl InstanceMetricName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceMetricName::BurstCapacityPercentage => "BurstCapacityPercentage",
            InstanceMetricName::BurstCapacityTime => "BurstCapacityTime",
            InstanceMetricName::CpuUtilization => "CPUUtilization",
            InstanceMetricName::NetworkIn => "NetworkIn",
            InstanceMetricName::NetworkOut => "NetworkOut",
            InstanceMetricName::StatusCheckFailed => "StatusCheckFailed",
            InstanceMetricName::StatusCheckFailedInstance => "StatusCheckFailed_Instance",
            InstanceMetricName::StatusCheckFailedSystem => "StatusCheckFailed_System",
            InstanceMetricName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BurstCapacityPercentage",
            "BurstCapacityTime",
            "CPUUtilization",
            "NetworkIn",
            "NetworkOut",
            "StatusCheckFailed",
            "StatusCheckFailed_Instance",
            "StatusCheckFailed_System",
        ]
    }
}
impl AsRef<str> for InstanceMetricName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The parameters for gaining temporary access to one of your Amazon Lightsail
/// instances.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceAccessDetails {
    /// <p>For SSH access, the public key to use when accessing your instance For OpenSSH clients
    /// (e.g., command line SSH), you should save this value to <code>tempkey-cert.pub</code>.</p>
    pub cert_key: std::option::Option<std::string::String>,
    /// <p>For SSH access, the date on which the temporary keys expire.</p>
    pub expires_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The public IP address of the Amazon Lightsail instance.</p>
    pub ip_address: std::option::Option<std::string::String>,
    /// <p>For RDP access, the password for your Amazon Lightsail instance. Password will be an empty
    /// string if the password for your new instance is not ready yet. When you create an instance, it
    /// can take up to 15 minutes for the instance to be ready.</p>
    /// <note>
    /// <p>If you create an instance using any key pair other than the default
    /// (<code>LightsailDefaultKeyPair</code>), <code>password</code> will always be an empty
    /// string.</p>
    /// <p>If you change the Administrator password on the instance, Lightsail will continue to
    /// return the original password value. When accessing the instance using RDP, you need to
    /// manually enter the Administrator password after changing it from the default.</p>
    /// </note>
    pub password: std::option::Option<std::string::String>,
    /// <p>For a Windows Server-based instance, an object with the data you can use to retrieve your
    /// password. This is only needed if <code>password</code> is empty and the instance is not new
    /// (and therefore the password is not ready yet). When you create an instance, it can take up to
    /// 15 minutes for the instance to be ready.</p>
    pub password_data: std::option::Option<crate::model::PasswordData>,
    /// <p>For SSH access, the temporary private key. For OpenSSH clients (e.g., command line SSH),
    /// you should save this value to <code>tempkey</code>).</p>
    pub private_key: std::option::Option<std::string::String>,
    /// <p>The protocol for these Amazon Lightsail instance access details.</p>
    pub protocol: std::option::Option<crate::model::InstanceAccessProtocol>,
    /// <p>The name of this Amazon Lightsail instance.</p>
    pub instance_name: std::option::Option<std::string::String>,
    /// <p>The user name to use when logging in to the Amazon Lightsail instance.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>Describes the public SSH host keys or the RDP certificate.</p>
    pub host_keys: std::option::Option<std::vec::Vec<crate::model::HostKeyAttributes>>,
}
impl std::fmt::Debug for InstanceAccessDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceAccessDetails");
        formatter.field("cert_key", &self.cert_key);
        formatter.field("expires_at", &self.expires_at);
        formatter.field("ip_address", &self.ip_address);
        formatter.field("password", &self.password);
        formatter.field("password_data", &self.password_data);
        formatter.field("private_key", &self.private_key);
        formatter.field("protocol", &self.protocol);
        formatter.field("instance_name", &self.instance_name);
        formatter.field("username", &self.username);
        formatter.field("host_keys", &self.host_keys);
        formatter.finish()
    }
}
/// See [`InstanceAccessDetails`](crate::model::InstanceAccessDetails)
pub mod instance_access_details {
    /// A builder for [`InstanceAccessDetails`](crate::model::InstanceAccessDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cert_key: std::option::Option<std::string::String>,
        pub(crate) expires_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) password_data: std::option::Option<crate::model::PasswordData>,
        pub(crate) private_key: std::option::Option<std::string::String>,
        pub(crate) protocol: std::option::Option<crate::model::InstanceAccessProtocol>,
        pub(crate) instance_name: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) host_keys: std::option::Option<std::vec::Vec<crate::model::HostKeyAttributes>>,
    }
    impl Builder {
        /// <p>For SSH access, the public key to use when accessing your instance For OpenSSH clients
        /// (e.g., command line SSH), you should save this value to <code>tempkey-cert.pub</code>.</p>
        pub fn cert_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.cert_key = Some(input.into());
            self
        }
        /// <p>For SSH access, the public key to use when accessing your instance For OpenSSH clients
        /// (e.g., command line SSH), you should save this value to <code>tempkey-cert.pub</code>.</p>
        pub fn set_cert_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cert_key = input;
            self
        }
        /// <p>For SSH access, the date on which the temporary keys expire.</p>
        pub fn expires_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.expires_at = Some(input);
            self
        }
        /// <p>For SSH access, the date on which the temporary keys expire.</p>
        pub fn set_expires_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.expires_at = input;
            self
        }
        /// <p>The public IP address of the Amazon Lightsail instance.</p>
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// <p>The public IP address of the Amazon Lightsail instance.</p>
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// <p>For RDP access, the password for your Amazon Lightsail instance. Password will be an empty
        /// string if the password for your new instance is not ready yet. When you create an instance, it
        /// can take up to 15 minutes for the instance to be ready.</p>
        /// <note>
        /// <p>If you create an instance using any key pair other than the default
        /// (<code>LightsailDefaultKeyPair</code>), <code>password</code> will always be an empty
        /// string.</p>
        /// <p>If you change the Administrator password on the instance, Lightsail will continue to
        /// return the original password value. When accessing the instance using RDP, you need to
        /// manually enter the Administrator password after changing it from the default.</p>
        /// </note>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>For RDP access, the password for your Amazon Lightsail instance. Password will be an empty
        /// string if the password for your new instance is not ready yet. When you create an instance, it
        /// can take up to 15 minutes for the instance to be ready.</p>
        /// <note>
        /// <p>If you create an instance using any key pair other than the default
        /// (<code>LightsailDefaultKeyPair</code>), <code>password</code> will always be an empty
        /// string.</p>
        /// <p>If you change the Administrator password on the instance, Lightsail will continue to
        /// return the original password value. When accessing the instance using RDP, you need to
        /// manually enter the Administrator password after changing it from the default.</p>
        /// </note>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>For a Windows Server-based instance, an object with the data you can use to retrieve your
        /// password. This is only needed if <code>password</code> is empty and the instance is not new
        /// (and therefore the password is not ready yet). When you create an instance, it can take up to
        /// 15 minutes for the instance to be ready.</p>
        pub fn password_data(mut self, input: crate::model::PasswordData) -> Self {
            self.password_data = Some(input);
            self
        }
        /// <p>For a Windows Server-based instance, an object with the data you can use to retrieve your
        /// password. This is only needed if <code>password</code> is empty and the instance is not new
        /// (and therefore the password is not ready yet). When you create an instance, it can take up to
        /// 15 minutes for the instance to be ready.</p>
        pub fn set_password_data(
            mut self,
            input: std::option::Option<crate::model::PasswordData>,
        ) -> Self {
            self.password_data = input;
            self
        }
        /// <p>For SSH access, the temporary private key. For OpenSSH clients (e.g., command line SSH),
        /// you should save this value to <code>tempkey</code>).</p>
        pub fn private_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_key = Some(input.into());
            self
        }
        /// <p>For SSH access, the temporary private key. For OpenSSH clients (e.g., command line SSH),
        /// you should save this value to <code>tempkey</code>).</p>
        pub fn set_private_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.private_key = input;
            self
        }
        /// <p>The protocol for these Amazon Lightsail instance access details.</p>
        pub fn protocol(mut self, input: crate::model::InstanceAccessProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol for these Amazon Lightsail instance access details.</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::InstanceAccessProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// <p>The name of this Amazon Lightsail instance.</p>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_name = Some(input.into());
            self
        }
        /// <p>The name of this Amazon Lightsail instance.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_name = input;
            self
        }
        /// <p>The user name to use when logging in to the Amazon Lightsail instance.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name to use when logging in to the Amazon Lightsail instance.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Appends an item to `host_keys`.
        ///
        /// To override the contents of this collection use [`set_host_keys`](Self::set_host_keys).
        ///
        /// <p>Describes the public SSH host keys or the RDP certificate.</p>
        pub fn host_keys(mut self, input: impl Into<crate::model::HostKeyAttributes>) -> Self {
            let mut v = self.host_keys.unwrap_or_default();
            v.push(input.into());
            self.host_keys = Some(v);
            self
        }
        /// <p>Describes the public SSH host keys or the RDP certificate.</p>
        pub fn set_host_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HostKeyAttributes>>,
        ) -> Self {
            self.host_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceAccessDetails`](crate::model::InstanceAccessDetails)
        pub fn build(self) -> crate::model::InstanceAccessDetails {
            crate::model::InstanceAccessDetails {
                cert_key: self.cert_key,
                expires_at: self.expires_at,
                ip_address: self.ip_address,
                password: self.password,
                password_data: self.password_data,
                private_key: self.private_key,
                protocol: self.protocol,
                instance_name: self.instance_name,
                username: self.username,
                host_keys: self.host_keys,
            }
        }
    }
}
impl InstanceAccessDetails {
    /// Creates a new builder-style object to manufacture [`InstanceAccessDetails`](crate::model::InstanceAccessDetails)
    pub fn builder() -> crate::model::instance_access_details::Builder {
        crate::model::instance_access_details::Builder::default()
    }
}

/// <p>Describes the public SSH host keys or the RDP certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HostKeyAttributes {
    /// <p>The SSH host key algorithm or the RDP certificate format.</p>
    /// <p>For SSH host keys, the algorithm may be <code>ssh-rsa</code>,
    /// <code>ecdsa-sha2-nistp256</code>, <code>ssh-ed25519</code>, etc. For RDP certificates, the
    /// algorithm is always <code>x509-cert</code>.</p>
    pub algorithm: std::option::Option<std::string::String>,
    /// <p>The public SSH host key or the RDP certificate.</p>
    pub public_key: std::option::Option<std::string::String>,
    /// <p>The time that the SSH host key or RDP certificate was recorded by Lightsail.</p>
    pub witnessed_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The SHA-1 fingerprint of the returned SSH host key or RDP certificate.</p>
    /// <ul>
    /// <li>
    /// <p>Example of an SHA-1 SSH fingerprint:</p>
    /// <p>
    /// <code>SHA1:1CHH6FaAaXjtFOsR/t83vf91SR0</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Example of an SHA-1 RDP fingerprint:</p>
    /// <p>
    /// <code>af:34:51:fe:09:f0:e0:da:b8:4e:56:ca:60:c2:10:ff:38:06:db:45</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fingerprint_sha1: std::option::Option<std::string::String>,
    /// <p>The SHA-256 fingerprint of the returned SSH host key or RDP certificate.</p>
    /// <ul>
    /// <li>
    /// <p>Example of an SHA-256 SSH fingerprint:</p>
    /// <p>
    /// <code>SHA256:KTsMnRBh1IhD17HpdfsbzeGA4jOijm5tyXsMjKVbB8o</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>Example of an SHA-256 RDP fingerprint:</p>
    /// <p>
    /// <code>03:9b:36:9f:4b:de:4e:61:70:fc:7c:c9:78:e7:d2:1a:1c:25:a8:0c:91:f6:7c:e4:d6:a0:85:c8:b4:53:99:68</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fingerprint_sha256: std::option::Option<std::string::String>,
    /// <p>The returned RDP certificate is valid after this point in time.</p>
    /// <p>This value is listed only for RDP certificates.</p>
    pub not_valid_before: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The returned RDP certificate is not valid after this point in time.</p>
    /// <p>This value is listed only for RDP certificates.</p>
    pub not_valid_after: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for HostKeyAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HostKeyAttributes");
        formatter.field("algorithm", &self.algorithm);
        formatter.field("public_key", &self.public_key);
        formatter.field("witnessed_at", &self.witnessed_at);
        formatter.field("fingerprint_sha1", &self.fingerprint_sha1);
        formatter.field("fingerprint_sha256", &self.fingerprint_sha256);
        formatter.field("not_valid_before", &self.not_valid_before);
        formatter.field("not_valid_after", &self.not_valid_after);
        formatter.finish()
    }
}
/// See [`HostKeyAttributes`](crate::model::HostKeyAttributes)
pub mod host_key_attributes {
    /// A builder for [`HostKeyAttributes`](crate::model::HostKeyAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) algorithm: std::option::Option<std::string::String>,
        pub(crate) public_key: std::option::Option<std::string::String>,
        pub(crate) witnessed_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) fingerprint_sha1: std::option::Option<std::string::String>,
        pub(crate) fingerprint_sha256: std::option::Option<std::string::String>,
        pub(crate) not_valid_before: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) not_valid_after: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The SSH host key algorithm or the RDP certificate format.</p>
        /// <p>For SSH host keys, the algorithm may be <code>ssh-rsa</code>,
        /// <code>ecdsa-sha2-nistp256</code>, <code>ssh-ed25519</code>, etc. For RDP certificates, the
        /// algorithm is always <code>x509-cert</code>.</p>
        pub fn algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.algorithm = Some(input.into());
            self
        }
        /// <p>The SSH host key algorithm or the RDP certificate format.</p>
        /// <p>For SSH host keys, the algorithm may be <code>ssh-rsa</code>,
        /// <code>ecdsa-sha2-nistp256</code>, <code>ssh-ed25519</code>, etc. For RDP certificates, the
        /// algorithm is always <code>x509-cert</code>.</p>
        pub fn set_algorithm(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.algorithm = input;
            self
        }
        /// <p>The public SSH host key or the RDP certificate.</p>
        pub fn public_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_key = Some(input.into());
            self
        }
        /// <p>The public SSH host key or the RDP certificate.</p>
        pub fn set_public_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.public_key = input;
            self
        }
        /// <p>The time that the SSH host key or RDP certificate was recorded by Lightsail.</p>
        pub fn witnessed_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.witnessed_at = Some(input);
            self
        }
        /// <p>The time that the SSH host key or RDP certificate was recorded by Lightsail.</p>
        pub fn set_witnessed_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.witnessed_at = input;
            self
        }
        /// <p>The SHA-1 fingerprint of the returned SSH host key or RDP certificate.</p>
        /// <ul>
        /// <li>
        /// <p>Example of an SHA-1 SSH fingerprint:</p>
        /// <p>
        /// <code>SHA1:1CHH6FaAaXjtFOsR/t83vf91SR0</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Example of an SHA-1 RDP fingerprint:</p>
        /// <p>
        /// <code>af:34:51:fe:09:f0:e0:da:b8:4e:56:ca:60:c2:10:ff:38:06:db:45</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn fingerprint_sha1(mut self, input: impl Into<std::string::String>) -> Self {
            self.fingerprint_sha1 = Some(input.into());
            self
        }
        /// <p>The SHA-1 fingerprint of the returned SSH host key or RDP certificate.</p>
        /// <ul>
        /// <li>
        /// <p>Example of an SHA-1 SSH fingerprint:</p>
        /// <p>
        /// <code>SHA1:1CHH6FaAaXjtFOsR/t83vf91SR0</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Example of an SHA-1 RDP fingerprint:</p>
        /// <p>
        /// <code>af:34:51:fe:09:f0:e0:da:b8:4e:56:ca:60:c2:10:ff:38:06:db:45</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_fingerprint_sha1(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.fingerprint_sha1 = input;
            self
        }
        /// <p>The SHA-256 fingerprint of the returned SSH host key or RDP certificate.</p>
        /// <ul>
        /// <li>
        /// <p>Example of an SHA-256 SSH fingerprint:</p>
        /// <p>
        /// <code>SHA256:KTsMnRBh1IhD17HpdfsbzeGA4jOijm5tyXsMjKVbB8o</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Example of an SHA-256 RDP fingerprint:</p>
        /// <p>
        /// <code>03:9b:36:9f:4b:de:4e:61:70:fc:7c:c9:78:e7:d2:1a:1c:25:a8:0c:91:f6:7c:e4:d6:a0:85:c8:b4:53:99:68</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn fingerprint_sha256(mut self, input: impl Into<std::string::String>) -> Self {
            self.fingerprint_sha256 = Some(input.into());
            self
        }
        /// <p>The SHA-256 fingerprint of the returned SSH host key or RDP certificate.</p>
        /// <ul>
        /// <li>
        /// <p>Example of an SHA-256 SSH fingerprint:</p>
        /// <p>
        /// <code>SHA256:KTsMnRBh1IhD17HpdfsbzeGA4jOijm5tyXsMjKVbB8o</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>Example of an SHA-256 RDP fingerprint:</p>
        /// <p>
        /// <code>03:9b:36:9f:4b:de:4e:61:70:fc:7c:c9:78:e7:d2:1a:1c:25:a8:0c:91:f6:7c:e4:d6:a0:85:c8:b4:53:99:68</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_fingerprint_sha256(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.fingerprint_sha256 = input;
            self
        }
        /// <p>The returned RDP certificate is valid after this point in time.</p>
        /// <p>This value is listed only for RDP certificates.</p>
        pub fn not_valid_before(mut self, input: aws_smithy_types::Instant) -> Self {
            self.not_valid_before = Some(input);
            self
        }
        /// <p>The returned RDP certificate is valid after this point in time.</p>
        /// <p>This value is listed only for RDP certificates.</p>
        pub fn set_not_valid_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.not_valid_before = input;
            self
        }
        /// <p>The returned RDP certificate is not valid after this point in time.</p>
        /// <p>This value is listed only for RDP certificates.</p>
        pub fn not_valid_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.not_valid_after = Some(input);
            self
        }
        /// <p>The returned RDP certificate is not valid after this point in time.</p>
        /// <p>This value is listed only for RDP certificates.</p>
        pub fn set_not_valid_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.not_valid_after = input;
            self
        }
        /// Consumes the builder and constructs a [`HostKeyAttributes`](crate::model::HostKeyAttributes)
        pub fn build(self) -> crate::model::HostKeyAttributes {
            crate::model::HostKeyAttributes {
                algorithm: self.algorithm,
                public_key: self.public_key,
                witnessed_at: self.witnessed_at,
                fingerprint_sha1: self.fingerprint_sha1,
                fingerprint_sha256: self.fingerprint_sha256,
                not_valid_before: self.not_valid_before,
                not_valid_after: self.not_valid_after,
            }
        }
    }
}
impl HostKeyAttributes {
    /// Creates a new builder-style object to manufacture [`HostKeyAttributes`](crate::model::HostKeyAttributes)
    pub fn builder() -> crate::model::host_key_attributes::Builder {
        crate::model::host_key_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstanceAccessProtocol {
    #[allow(missing_docs)] // documentation missing in model
    Rdp,
    #[allow(missing_docs)] // documentation missing in model
    Ssh,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstanceAccessProtocol {
    fn from(s: &str) -> Self {
        match s {
            "rdp" => InstanceAccessProtocol::Rdp,
            "ssh" => InstanceAccessProtocol::Ssh,
            other => InstanceAccessProtocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstanceAccessProtocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstanceAccessProtocol::from(s))
    }
}
impl InstanceAccessProtocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstanceAccessProtocol::Rdp => "rdp",
            InstanceAccessProtocol::Ssh => "ssh",
            InstanceAccessProtocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["rdp", "ssh"]
    }
}
impl AsRef<str> for InstanceAccessProtocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The password data for the Windows Server-based instance, including the ciphertext and the
/// key pair name.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PasswordData {
    /// <p>The encrypted password. Ciphertext will be an empty string if access to your new instance
    /// is not ready yet. When you create an instance, it can take up to 15 minutes for the instance
    /// to be ready.</p>
    /// <note>
    /// <p>If you use the default key pair (<code>LightsailDefaultKeyPair</code>), the decrypted
    /// password will be available in the password field.</p>
    /// <p>If you are using a custom key pair, you need to use your own means of decryption.</p>
    /// <p>If you change the Administrator password on the instance, Lightsail will continue to
    /// return the original ciphertext value. When accessing the instance using RDP, you need to
    /// manually enter the Administrator password after changing it from the default.</p>
    /// </note>
    pub ciphertext: std::option::Option<std::string::String>,
    /// <p>The name of the key pair that you used when creating your instance. If no key pair name
    /// was specified when creating the instance, Lightsail uses the default key pair
    /// (<code>LightsailDefaultKeyPair</code>).</p>
    /// <p>If you are using a custom key pair, you need to use your own means of decrypting your
    /// password using the <code>ciphertext</code>. Lightsail creates the ciphertext by encrypting
    /// your password with the public key part of this key pair.</p>
    pub key_pair_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PasswordData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PasswordData");
        formatter.field("ciphertext", &self.ciphertext);
        formatter.field("key_pair_name", &self.key_pair_name);
        formatter.finish()
    }
}
/// See [`PasswordData`](crate::model::PasswordData)
pub mod password_data {
    /// A builder for [`PasswordData`](crate::model::PasswordData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ciphertext: std::option::Option<std::string::String>,
        pub(crate) key_pair_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The encrypted password. Ciphertext will be an empty string if access to your new instance
        /// is not ready yet. When you create an instance, it can take up to 15 minutes for the instance
        /// to be ready.</p>
        /// <note>
        /// <p>If you use the default key pair (<code>LightsailDefaultKeyPair</code>), the decrypted
        /// password will be available in the password field.</p>
        /// <p>If you are using a custom key pair, you need to use your own means of decryption.</p>
        /// <p>If you change the Administrator password on the instance, Lightsail will continue to
        /// return the original ciphertext value. When accessing the instance using RDP, you need to
        /// manually enter the Administrator password after changing it from the default.</p>
        /// </note>
        pub fn ciphertext(mut self, input: impl Into<std::string::String>) -> Self {
            self.ciphertext = Some(input.into());
            self
        }
        /// <p>The encrypted password. Ciphertext will be an empty string if access to your new instance
        /// is not ready yet. When you create an instance, it can take up to 15 minutes for the instance
        /// to be ready.</p>
        /// <note>
        /// <p>If you use the default key pair (<code>LightsailDefaultKeyPair</code>), the decrypted
        /// password will be available in the password field.</p>
        /// <p>If you are using a custom key pair, you need to use your own means of decryption.</p>
        /// <p>If you change the Administrator password on the instance, Lightsail will continue to
        /// return the original ciphertext value. When accessing the instance using RDP, you need to
        /// manually enter the Administrator password after changing it from the default.</p>
        /// </note>
        pub fn set_ciphertext(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ciphertext = input;
            self
        }
        /// <p>The name of the key pair that you used when creating your instance. If no key pair name
        /// was specified when creating the instance, Lightsail uses the default key pair
        /// (<code>LightsailDefaultKeyPair</code>).</p>
        /// <p>If you are using a custom key pair, you need to use your own means of decrypting your
        /// password using the <code>ciphertext</code>. Lightsail creates the ciphertext by encrypting
        /// your password with the public key part of this key pair.</p>
        pub fn key_pair_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_pair_name = Some(input.into());
            self
        }
        /// <p>The name of the key pair that you used when creating your instance. If no key pair name
        /// was specified when creating the instance, Lightsail uses the default key pair
        /// (<code>LightsailDefaultKeyPair</code>).</p>
        /// <p>If you are using a custom key pair, you need to use your own means of decrypting your
        /// password using the <code>ciphertext</code>. Lightsail creates the ciphertext by encrypting
        /// your password with the public key part of this key pair.</p>
        pub fn set_key_pair_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.key_pair_name = input;
            self
        }
        /// Consumes the builder and constructs a [`PasswordData`](crate::model::PasswordData)
        pub fn build(self) -> crate::model::PasswordData {
            crate::model::PasswordData {
                ciphertext: self.ciphertext,
                key_pair_name: self.key_pair_name,
            }
        }
    }
}
impl PasswordData {
    /// Creates a new builder-style object to manufacture [`PasswordData`](crate::model::PasswordData)
    pub fn builder() -> crate::model::password_data::Builder {
        crate::model::password_data::Builder::default()
    }
}

/// <p>Describes an export snapshot record.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportSnapshotRecord {
    /// <p>The export snapshot record name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the export snapshot record.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date when the export snapshot record was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The AWS Region and Availability Zone where the export snapshot record is located.</p>
    pub location: std::option::Option<crate::model::ResourceLocation>,
    /// <p>The Lightsail resource type (e.g., <code>ExportSnapshotRecord</code>).</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The state of the export snapshot record.</p>
    pub state: std::option::Option<crate::model::RecordState>,
    /// <p>A list of objects describing the source of the export snapshot record.</p>
    pub source_info: std::option::Option<crate::model::ExportSnapshotRecordSourceInfo>,
    /// <p>A list of objects describing the destination of the export snapshot record.</p>
    pub destination_info: std::option::Option<crate::model::DestinationInfo>,
}
impl std::fmt::Debug for ExportSnapshotRecord {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportSnapshotRecord");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("location", &self.location);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("state", &self.state);
        formatter.field("source_info", &self.source_info);
        formatter.field("destination_info", &self.destination_info);
        formatter.finish()
    }
}
/// See [`ExportSnapshotRecord`](crate::model::ExportSnapshotRecord)
pub mod export_snapshot_record {
    /// A builder for [`ExportSnapshotRecord`](crate::model::ExportSnapshotRecord)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) location: std::option::Option<crate::model::ResourceLocation>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) state: std::option::Option<crate::model::RecordState>,
        pub(crate) source_info: std::option::Option<crate::model::ExportSnapshotRecordSourceInfo>,
        pub(crate) destination_info: std::option::Option<crate::model::DestinationInfo>,
    }
    impl Builder {
        /// <p>The export snapshot record name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The export snapshot record name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the export snapshot record.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the export snapshot record.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date when the export snapshot record was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date when the export snapshot record was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The AWS Region and Availability Zone where the export snapshot record is located.</p>
        pub fn location(mut self, input: crate::model::ResourceLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The AWS Region and Availability Zone where the export snapshot record is located.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::ResourceLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>The Lightsail resource type (e.g., <code>ExportSnapshotRecord</code>).</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The Lightsail resource type (e.g., <code>ExportSnapshotRecord</code>).</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The state of the export snapshot record.</p>
        pub fn state(mut self, input: crate::model::RecordState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the export snapshot record.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::RecordState>) -> Self {
            self.state = input;
            self
        }
        /// <p>A list of objects describing the source of the export snapshot record.</p>
        pub fn source_info(mut self, input: crate::model::ExportSnapshotRecordSourceInfo) -> Self {
            self.source_info = Some(input);
            self
        }
        /// <p>A list of objects describing the source of the export snapshot record.</p>
        pub fn set_source_info(
            mut self,
            input: std::option::Option<crate::model::ExportSnapshotRecordSourceInfo>,
        ) -> Self {
            self.source_info = input;
            self
        }
        /// <p>A list of objects describing the destination of the export snapshot record.</p>
        pub fn destination_info(mut self, input: crate::model::DestinationInfo) -> Self {
            self.destination_info = Some(input);
            self
        }
        /// <p>A list of objects describing the destination of the export snapshot record.</p>
        pub fn set_destination_info(
            mut self,
            input: std::option::Option<crate::model::DestinationInfo>,
        ) -> Self {
            self.destination_info = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportSnapshotRecord`](crate::model::ExportSnapshotRecord)
        pub fn build(self) -> crate::model::ExportSnapshotRecord {
            crate::model::ExportSnapshotRecord {
                name: self.name,
                arn: self.arn,
                created_at: self.created_at,
                location: self.location,
                resource_type: self.resource_type,
                state: self.state,
                source_info: self.source_info,
                destination_info: self.destination_info,
            }
        }
    }
}
impl ExportSnapshotRecord {
    /// Creates a new builder-style object to manufacture [`ExportSnapshotRecord`](crate::model::ExportSnapshotRecord)
    pub fn builder() -> crate::model::export_snapshot_record::Builder {
        crate::model::export_snapshot_record::Builder::default()
    }
}

/// <p>Describes the destination of a record.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DestinationInfo {
    /// <p>The ID of the resource created at the destination.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The destination service of the record.</p>
    pub service: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DestinationInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DestinationInfo");
        formatter.field("id", &self.id);
        formatter.field("service", &self.service);
        formatter.finish()
    }
}
/// See [`DestinationInfo`](crate::model::DestinationInfo)
pub mod destination_info {
    /// A builder for [`DestinationInfo`](crate::model::DestinationInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) service: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the resource created at the destination.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the resource created at the destination.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The destination service of the record.</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.service = Some(input.into());
            self
        }
        /// <p>The destination service of the record.</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service = input;
            self
        }
        /// Consumes the builder and constructs a [`DestinationInfo`](crate::model::DestinationInfo)
        pub fn build(self) -> crate::model::DestinationInfo {
            crate::model::DestinationInfo {
                id: self.id,
                service: self.service,
            }
        }
    }
}
impl DestinationInfo {
    /// Creates a new builder-style object to manufacture [`DestinationInfo`](crate::model::DestinationInfo)
    pub fn builder() -> crate::model::destination_info::Builder {
        crate::model::destination_info::Builder::default()
    }
}

/// <p>Describes the source of an export snapshot record.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportSnapshotRecordSourceInfo {
    /// <p>The Lightsail resource type (e.g., <code>InstanceSnapshot</code> or
    /// <code>DiskSnapshot</code>).</p>
    pub resource_type: std::option::Option<crate::model::ExportSnapshotRecordSourceType>,
    /// <p>The date when the source instance or disk snapshot was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The name of the source instance or disk snapshot.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the source instance or disk snapshot.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the snapshot's source instance or disk.</p>
    pub from_resource_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the snapshot's source instance or disk.</p>
    pub from_resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of objects describing an instance snapshot.</p>
    pub instance_snapshot_info: std::option::Option<crate::model::InstanceSnapshotInfo>,
    /// <p>A list of objects describing a disk snapshot.</p>
    pub disk_snapshot_info: std::option::Option<crate::model::DiskSnapshotInfo>,
}
impl std::fmt::Debug for ExportSnapshotRecordSourceInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportSnapshotRecordSourceInfo");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("created_at", &self.created_at);
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("from_resource_name", &self.from_resource_name);
        formatter.field("from_resource_arn", &self.from_resource_arn);
        formatter.field("instance_snapshot_info", &self.instance_snapshot_info);
        formatter.field("disk_snapshot_info", &self.disk_snapshot_info);
        formatter.finish()
    }
}
/// See [`ExportSnapshotRecordSourceInfo`](crate::model::ExportSnapshotRecordSourceInfo)
pub mod export_snapshot_record_source_info {
    /// A builder for [`ExportSnapshotRecordSourceInfo`](crate::model::ExportSnapshotRecordSourceInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type: std::option::Option<crate::model::ExportSnapshotRecordSourceType>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) from_resource_name: std::option::Option<std::string::String>,
        pub(crate) from_resource_arn: std::option::Option<std::string::String>,
        pub(crate) instance_snapshot_info: std::option::Option<crate::model::InstanceSnapshotInfo>,
        pub(crate) disk_snapshot_info: std::option::Option<crate::model::DiskSnapshotInfo>,
    }
    impl Builder {
        /// <p>The Lightsail resource type (e.g., <code>InstanceSnapshot</code> or
        /// <code>DiskSnapshot</code>).</p>
        pub fn resource_type(
            mut self,
            input: crate::model::ExportSnapshotRecordSourceType,
        ) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The Lightsail resource type (e.g., <code>InstanceSnapshot</code> or
        /// <code>DiskSnapshot</code>).</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ExportSnapshotRecordSourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The date when the source instance or disk snapshot was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date when the source instance or disk snapshot was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The name of the source instance or disk snapshot.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the source instance or disk snapshot.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source instance or disk snapshot.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source instance or disk snapshot.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the snapshot's source instance or disk.</p>
        pub fn from_resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_resource_name = Some(input.into());
            self
        }
        /// <p>The name of the snapshot's source instance or disk.</p>
        pub fn set_from_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_resource_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the snapshot's source instance or disk.</p>
        pub fn from_resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the snapshot's source instance or disk.</p>
        pub fn set_from_resource_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_resource_arn = input;
            self
        }
        /// <p>A list of objects describing an instance snapshot.</p>
        pub fn instance_snapshot_info(mut self, input: crate::model::InstanceSnapshotInfo) -> Self {
            self.instance_snapshot_info = Some(input);
            self
        }
        /// <p>A list of objects describing an instance snapshot.</p>
        pub fn set_instance_snapshot_info(
            mut self,
            input: std::option::Option<crate::model::InstanceSnapshotInfo>,
        ) -> Self {
            self.instance_snapshot_info = input;
            self
        }
        /// <p>A list of objects describing a disk snapshot.</p>
        pub fn disk_snapshot_info(mut self, input: crate::model::DiskSnapshotInfo) -> Self {
            self.disk_snapshot_info = Some(input);
            self
        }
        /// <p>A list of objects describing a disk snapshot.</p>
        pub fn set_disk_snapshot_info(
            mut self,
            input: std::option::Option<crate::model::DiskSnapshotInfo>,
        ) -> Self {
            self.disk_snapshot_info = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportSnapshotRecordSourceInfo`](crate::model::ExportSnapshotRecordSourceInfo)
        pub fn build(self) -> crate::model::ExportSnapshotRecordSourceInfo {
            crate::model::ExportSnapshotRecordSourceInfo {
                resource_type: self.resource_type,
                created_at: self.created_at,
                name: self.name,
                arn: self.arn,
                from_resource_name: self.from_resource_name,
                from_resource_arn: self.from_resource_arn,
                instance_snapshot_info: self.instance_snapshot_info,
                disk_snapshot_info: self.disk_snapshot_info,
            }
        }
    }
}
impl ExportSnapshotRecordSourceInfo {
    /// Creates a new builder-style object to manufacture [`ExportSnapshotRecordSourceInfo`](crate::model::ExportSnapshotRecordSourceInfo)
    pub fn builder() -> crate::model::export_snapshot_record_source_info::Builder {
        crate::model::export_snapshot_record_source_info::Builder::default()
    }
}

/// <p>Describes a disk snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DiskSnapshotInfo {
    /// <p>The size of the disk in GB (e.g., <code>32</code>).</p>
    pub size_in_gb: std::option::Option<i32>,
}
impl std::fmt::Debug for DiskSnapshotInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DiskSnapshotInfo");
        formatter.field("size_in_gb", &self.size_in_gb);
        formatter.finish()
    }
}
/// See [`DiskSnapshotInfo`](crate::model::DiskSnapshotInfo)
pub mod disk_snapshot_info {
    /// A builder for [`DiskSnapshotInfo`](crate::model::DiskSnapshotInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) size_in_gb: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The size of the disk in GB (e.g., <code>32</code>).</p>
        pub fn size_in_gb(mut self, input: i32) -> Self {
            self.size_in_gb = Some(input);
            self
        }
        /// <p>The size of the disk in GB (e.g., <code>32</code>).</p>
        pub fn set_size_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.size_in_gb = input;
            self
        }
        /// Consumes the builder and constructs a [`DiskSnapshotInfo`](crate::model::DiskSnapshotInfo)
        pub fn build(self) -> crate::model::DiskSnapshotInfo {
            crate::model::DiskSnapshotInfo {
                size_in_gb: self.size_in_gb,
            }
        }
    }
}
impl DiskSnapshotInfo {
    /// Creates a new builder-style object to manufacture [`DiskSnapshotInfo`](crate::model::DiskSnapshotInfo)
    pub fn builder() -> crate::model::disk_snapshot_info::Builder {
        crate::model::disk_snapshot_info::Builder::default()
    }
}

/// <p>Describes an instance snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceSnapshotInfo {
    /// <p>The bundle ID from which the source instance was created (e.g.,
    /// <code>micro_1_0</code>).</p>
    pub from_bundle_id: std::option::Option<std::string::String>,
    /// <p>The blueprint ID from which the source instance (e.g., <code>os_debian_8_3</code>).</p>
    pub from_blueprint_id: std::option::Option<std::string::String>,
    /// <p>A list of objects describing the disks that were attached to the source instance.</p>
    pub from_disk_info: std::option::Option<std::vec::Vec<crate::model::DiskInfo>>,
}
impl std::fmt::Debug for InstanceSnapshotInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceSnapshotInfo");
        formatter.field("from_bundle_id", &self.from_bundle_id);
        formatter.field("from_blueprint_id", &self.from_blueprint_id);
        formatter.field("from_disk_info", &self.from_disk_info);
        formatter.finish()
    }
}
/// See [`InstanceSnapshotInfo`](crate::model::InstanceSnapshotInfo)
pub mod instance_snapshot_info {
    /// A builder for [`InstanceSnapshotInfo`](crate::model::InstanceSnapshotInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from_bundle_id: std::option::Option<std::string::String>,
        pub(crate) from_blueprint_id: std::option::Option<std::string::String>,
        pub(crate) from_disk_info: std::option::Option<std::vec::Vec<crate::model::DiskInfo>>,
    }
    impl Builder {
        /// <p>The bundle ID from which the source instance was created (e.g.,
        /// <code>micro_1_0</code>).</p>
        pub fn from_bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_bundle_id = Some(input.into());
            self
        }
        /// <p>The bundle ID from which the source instance was created (e.g.,
        /// <code>micro_1_0</code>).</p>
        pub fn set_from_bundle_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_bundle_id = input;
            self
        }
        /// <p>The blueprint ID from which the source instance (e.g., <code>os_debian_8_3</code>).</p>
        pub fn from_blueprint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_blueprint_id = Some(input.into());
            self
        }
        /// <p>The blueprint ID from which the source instance (e.g., <code>os_debian_8_3</code>).</p>
        pub fn set_from_blueprint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_blueprint_id = input;
            self
        }
        /// Appends an item to `from_disk_info`.
        ///
        /// To override the contents of this collection use [`set_from_disk_info`](Self::set_from_disk_info).
        ///
        /// <p>A list of objects describing the disks that were attached to the source instance.</p>
        pub fn from_disk_info(mut self, input: impl Into<crate::model::DiskInfo>) -> Self {
            let mut v = self.from_disk_info.unwrap_or_default();
            v.push(input.into());
            self.from_disk_info = Some(v);
            self
        }
        /// <p>A list of objects describing the disks that were attached to the source instance.</p>
        pub fn set_from_disk_info(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DiskInfo>>,
        ) -> Self {
            self.from_disk_info = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceSnapshotInfo`](crate::model::InstanceSnapshotInfo)
        pub fn build(self) -> crate::model::InstanceSnapshotInfo {
            crate::model::InstanceSnapshotInfo {
                from_bundle_id: self.from_bundle_id,
                from_blueprint_id: self.from_blueprint_id,
                from_disk_info: self.from_disk_info,
            }
        }
    }
}
impl InstanceSnapshotInfo {
    /// Creates a new builder-style object to manufacture [`InstanceSnapshotInfo`](crate::model::InstanceSnapshotInfo)
    pub fn builder() -> crate::model::instance_snapshot_info::Builder {
        crate::model::instance_snapshot_info::Builder::default()
    }
}

/// <p>Describes a disk.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DiskInfo {
    /// <p>The disk name.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The disk path.</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The size of the disk in GB (e.g., <code>32</code>).</p>
    pub size_in_gb: std::option::Option<i32>,
    /// <p>A Boolean value indicating whether this disk is a system disk (has an operating system
    /// loaded on it).</p>
    pub is_system_disk: std::option::Option<bool>,
}
impl std::fmt::Debug for DiskInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DiskInfo");
        formatter.field("name", &self.name);
        formatter.field("path", &self.path);
        formatter.field("size_in_gb", &self.size_in_gb);
        formatter.field("is_system_disk", &self.is_system_disk);
        formatter.finish()
    }
}
/// See [`DiskInfo`](crate::model::DiskInfo)
pub mod disk_info {
    /// A builder for [`DiskInfo`](crate::model::DiskInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) size_in_gb: std::option::Option<i32>,
        pub(crate) is_system_disk: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The disk name.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The disk name.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The disk path.</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The disk path.</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The size of the disk in GB (e.g., <code>32</code>).</p>
        pub fn size_in_gb(mut self, input: i32) -> Self {
            self.size_in_gb = Some(input);
            self
        }
        /// <p>The size of the disk in GB (e.g., <code>32</code>).</p>
        pub fn set_size_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.size_in_gb = input;
            self
        }
        /// <p>A Boolean value indicating whether this disk is a system disk (has an operating system
        /// loaded on it).</p>
        pub fn is_system_disk(mut self, input: bool) -> Self {
            self.is_system_disk = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether this disk is a system disk (has an operating system
        /// loaded on it).</p>
        pub fn set_is_system_disk(mut self, input: std::option::Option<bool>) -> Self {
            self.is_system_disk = input;
            self
        }
        /// Consumes the builder and constructs a [`DiskInfo`](crate::model::DiskInfo)
        pub fn build(self) -> crate::model::DiskInfo {
            crate::model::DiskInfo {
                name: self.name,
                path: self.path,
                size_in_gb: self.size_in_gb,
                is_system_disk: self.is_system_disk,
            }
        }
    }
}
impl DiskInfo {
    /// Creates a new builder-style object to manufacture [`DiskInfo`](crate::model::DiskInfo)
    pub fn builder() -> crate::model::disk_info::Builder {
        crate::model::disk_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ExportSnapshotRecordSourceType {
    #[allow(missing_docs)] // documentation missing in model
    DiskSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    InstanceSnapshot,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ExportSnapshotRecordSourceType {
    fn from(s: &str) -> Self {
        match s {
            "DiskSnapshot" => ExportSnapshotRecordSourceType::DiskSnapshot,
            "InstanceSnapshot" => ExportSnapshotRecordSourceType::InstanceSnapshot,
            other => ExportSnapshotRecordSourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ExportSnapshotRecordSourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ExportSnapshotRecordSourceType::from(s))
    }
}
impl ExportSnapshotRecordSourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ExportSnapshotRecordSourceType::DiskSnapshot => "DiskSnapshot",
            ExportSnapshotRecordSourceType::InstanceSnapshot => "InstanceSnapshot",
            ExportSnapshotRecordSourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DiskSnapshot", "InstanceSnapshot"]
    }
}
impl AsRef<str> for ExportSnapshotRecordSourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecordState {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Started,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecordState {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => RecordState::Failed,
            "Started" => RecordState::Started,
            "Succeeded" => RecordState::Succeeded,
            other => RecordState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecordState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecordState::from(s))
    }
}
impl RecordState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecordState::Failed => "Failed",
            RecordState::Started => "Started",
            RecordState::Succeeded => "Succeeded",
            RecordState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Failed", "Started", "Succeeded"]
    }
}
impl AsRef<str> for RecordState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a domain where you are storing recordsets.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Domain {
    /// <p>The name of the domain.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the domain recordset (e.g.,
    /// <code>arn:aws:lightsail:global:123456789101:Domain/824cede0-abc7-4f84-8dbc-12345EXAMPLE</code>).</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The support code. Include this code in your email to support when you have questions about
    /// an instance or another resource in Lightsail. This code enables our support team to look up
    /// your Lightsail information more easily.</p>
    pub support_code: std::option::Option<std::string::String>,
    /// <p>The date when the domain recordset was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The AWS Region and Availability Zones where the domain recordset was created.</p>
    pub location: std::option::Option<crate::model::ResourceLocation>,
    /// <p>The resource type. </p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The tag keys and optional values for the resource. For more information about tags in
    /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>An array of key-value pairs containing information about the domain entries.</p>
    pub domain_entries: std::option::Option<std::vec::Vec<crate::model::DomainEntry>>,
}
impl std::fmt::Debug for Domain {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Domain");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("support_code", &self.support_code);
        formatter.field("created_at", &self.created_at);
        formatter.field("location", &self.location);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("tags", &self.tags);
        formatter.field("domain_entries", &self.domain_entries);
        formatter.finish()
    }
}
/// See [`Domain`](crate::model::Domain)
pub mod domain {
    /// A builder for [`Domain`](crate::model::Domain)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) support_code: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) location: std::option::Option<crate::model::ResourceLocation>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) domain_entries: std::option::Option<std::vec::Vec<crate::model::DomainEntry>>,
    }
    impl Builder {
        /// <p>The name of the domain.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the domain.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the domain recordset (e.g.,
        /// <code>arn:aws:lightsail:global:123456789101:Domain/824cede0-abc7-4f84-8dbc-12345EXAMPLE</code>).</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the domain recordset (e.g.,
        /// <code>arn:aws:lightsail:global:123456789101:Domain/824cede0-abc7-4f84-8dbc-12345EXAMPLE</code>).</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// an instance or another resource in Lightsail. This code enables our support team to look up
        /// your Lightsail information more easily.</p>
        pub fn support_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_code = Some(input.into());
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// an instance or another resource in Lightsail. This code enables our support team to look up
        /// your Lightsail information more easily.</p>
        pub fn set_support_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.support_code = input;
            self
        }
        /// <p>The date when the domain recordset was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date when the domain recordset was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The AWS Region and Availability Zones where the domain recordset was created.</p>
        pub fn location(mut self, input: crate::model::ResourceLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The AWS Region and Availability Zones where the domain recordset was created.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::ResourceLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>The resource type. </p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The resource type. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `domain_entries`.
        ///
        /// To override the contents of this collection use [`set_domain_entries`](Self::set_domain_entries).
        ///
        /// <p>An array of key-value pairs containing information about the domain entries.</p>
        pub fn domain_entries(mut self, input: impl Into<crate::model::DomainEntry>) -> Self {
            let mut v = self.domain_entries.unwrap_or_default();
            v.push(input.into());
            self.domain_entries = Some(v);
            self
        }
        /// <p>An array of key-value pairs containing information about the domain entries.</p>
        pub fn set_domain_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainEntry>>,
        ) -> Self {
            self.domain_entries = input;
            self
        }
        /// Consumes the builder and constructs a [`Domain`](crate::model::Domain)
        pub fn build(self) -> crate::model::Domain {
            crate::model::Domain {
                name: self.name,
                arn: self.arn,
                support_code: self.support_code,
                created_at: self.created_at,
                location: self.location,
                resource_type: self.resource_type,
                tags: self.tags,
                domain_entries: self.domain_entries,
            }
        }
    }
}
impl Domain {
    /// Creates a new builder-style object to manufacture [`Domain`](crate::model::Domain)
    pub fn builder() -> crate::model::domain::Builder {
        crate::model::domain::Builder::default()
    }
}

/// <p>Describes an Amazon Lightsail content delivery network (CDN) distribution.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LightsailDistribution {
    /// <p>The name of the distribution.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the distribution.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The support code. Include this code in your email to support when you have questions about
    /// your Lightsail distribution. This code enables our support team to look up your Lightsail
    /// information more easily.</p>
    pub support_code: std::option::Option<std::string::String>,
    /// <p>The timestamp when the distribution was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>An object that describes the location of the distribution, such as the AWS Region and
    /// Availability Zone.</p>
    /// <note>
    /// <p>Lightsail distributions are global resources that can reference an origin in any AWS
    /// Region, and distribute its content globally. However, all distributions are located in the
    /// <code>us-east-1</code> Region.</p>
    /// </note>
    pub location: std::option::Option<crate::model::ResourceLocation>,
    /// <p>The Lightsail resource type (e.g., <code>Distribution</code>).</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The alternate domain names of the distribution.</p>
    pub alternative_domain_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The status of the distribution.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>Indicates whether the distribution is enabled.</p>
    pub is_enabled: std::option::Option<bool>,
    /// <p>The domain name of the distribution.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The ID of the bundle currently applied to the distribution.</p>
    pub bundle_id: std::option::Option<std::string::String>,
    /// <p>The name of the SSL/TLS certificate attached to the distribution, if any.</p>
    pub certificate_name: std::option::Option<std::string::String>,
    /// <p>An object that describes the origin resource of the distribution, such as a Lightsail
    /// instance or load balancer.</p>
    /// <p>The distribution pulls, caches, and serves content from the origin.</p>
    pub origin: std::option::Option<crate::model::Origin>,
    /// <p>The public DNS of the origin.</p>
    pub origin_public_dns: std::option::Option<std::string::String>,
    /// <p>An object that describes the default cache behavior of the distribution.</p>
    pub default_cache_behavior: std::option::Option<crate::model::CacheBehavior>,
    /// <p>An object that describes the cache behavior settings of the distribution.</p>
    pub cache_behavior_settings: std::option::Option<crate::model::CacheSettings>,
    /// <p>An array of objects that describe the per-path cache behavior of the distribution.</p>
    pub cache_behaviors: std::option::Option<std::vec::Vec<crate::model::CacheBehaviorPerPath>>,
    /// <p>Indicates whether the bundle that is currently applied to your distribution, specified
    /// using the <code>distributionName</code> parameter, can be changed to another bundle.</p>
    /// <p>Use the <code>UpdateDistributionBundle</code> action to change your distribution's
    /// bundle.</p>
    pub able_to_update_bundle: std::option::Option<bool>,
    /// <p>The IP address type of the distribution.</p>
    ///
    /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for
    /// IPv4 and IPv6.</p>
    pub ip_address_type: std::option::Option<crate::model::IpAddressType>,
    /// <p>The tag keys and optional values for the resource. For more information about tags in
    /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for LightsailDistribution {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LightsailDistribution");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("support_code", &self.support_code);
        formatter.field("created_at", &self.created_at);
        formatter.field("location", &self.location);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("alternative_domain_names", &self.alternative_domain_names);
        formatter.field("status", &self.status);
        formatter.field("is_enabled", &self.is_enabled);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("bundle_id", &self.bundle_id);
        formatter.field("certificate_name", &self.certificate_name);
        formatter.field("origin", &self.origin);
        formatter.field("origin_public_dns", &self.origin_public_dns);
        formatter.field("default_cache_behavior", &self.default_cache_behavior);
        formatter.field("cache_behavior_settings", &self.cache_behavior_settings);
        formatter.field("cache_behaviors", &self.cache_behaviors);
        formatter.field("able_to_update_bundle", &self.able_to_update_bundle);
        formatter.field("ip_address_type", &self.ip_address_type);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`LightsailDistribution`](crate::model::LightsailDistribution)
pub mod lightsail_distribution {
    /// A builder for [`LightsailDistribution`](crate::model::LightsailDistribution)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) support_code: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) location: std::option::Option<crate::model::ResourceLocation>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) alternative_domain_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) is_enabled: std::option::Option<bool>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) bundle_id: std::option::Option<std::string::String>,
        pub(crate) certificate_name: std::option::Option<std::string::String>,
        pub(crate) origin: std::option::Option<crate::model::Origin>,
        pub(crate) origin_public_dns: std::option::Option<std::string::String>,
        pub(crate) default_cache_behavior: std::option::Option<crate::model::CacheBehavior>,
        pub(crate) cache_behavior_settings: std::option::Option<crate::model::CacheSettings>,
        pub(crate) cache_behaviors:
            std::option::Option<std::vec::Vec<crate::model::CacheBehaviorPerPath>>,
        pub(crate) able_to_update_bundle: std::option::Option<bool>,
        pub(crate) ip_address_type: std::option::Option<crate::model::IpAddressType>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the distribution.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the distribution.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the distribution.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// your Lightsail distribution. This code enables our support team to look up your Lightsail
        /// information more easily.</p>
        pub fn support_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_code = Some(input.into());
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// your Lightsail distribution. This code enables our support team to look up your Lightsail
        /// information more easily.</p>
        pub fn set_support_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.support_code = input;
            self
        }
        /// <p>The timestamp when the distribution was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when the distribution was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>An object that describes the location of the distribution, such as the AWS Region and
        /// Availability Zone.</p>
        /// <note>
        /// <p>Lightsail distributions are global resources that can reference an origin in any AWS
        /// Region, and distribute its content globally. However, all distributions are located in the
        /// <code>us-east-1</code> Region.</p>
        /// </note>
        pub fn location(mut self, input: crate::model::ResourceLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>An object that describes the location of the distribution, such as the AWS Region and
        /// Availability Zone.</p>
        /// <note>
        /// <p>Lightsail distributions are global resources that can reference an origin in any AWS
        /// Region, and distribute its content globally. However, all distributions are located in the
        /// <code>us-east-1</code> Region.</p>
        /// </note>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::ResourceLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>The Lightsail resource type (e.g., <code>Distribution</code>).</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The Lightsail resource type (e.g., <code>Distribution</code>).</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `alternative_domain_names`.
        ///
        /// To override the contents of this collection use [`set_alternative_domain_names`](Self::set_alternative_domain_names).
        ///
        /// <p>The alternate domain names of the distribution.</p>
        pub fn alternative_domain_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.alternative_domain_names.unwrap_or_default();
            v.push(input.into());
            self.alternative_domain_names = Some(v);
            self
        }
        /// <p>The alternate domain names of the distribution.</p>
        pub fn set_alternative_domain_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.alternative_domain_names = input;
            self
        }
        /// <p>The status of the distribution.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the distribution.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Indicates whether the distribution is enabled.</p>
        pub fn is_enabled(mut self, input: bool) -> Self {
            self.is_enabled = Some(input);
            self
        }
        /// <p>Indicates whether the distribution is enabled.</p>
        pub fn set_is_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.is_enabled = input;
            self
        }
        /// <p>The domain name of the distribution.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name of the distribution.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The ID of the bundle currently applied to the distribution.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_id = Some(input.into());
            self
        }
        /// <p>The ID of the bundle currently applied to the distribution.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_id = input;
            self
        }
        /// <p>The name of the SSL/TLS certificate attached to the distribution, if any.</p>
        pub fn certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_name = Some(input.into());
            self
        }
        /// <p>The name of the SSL/TLS certificate attached to the distribution, if any.</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_name = input;
            self
        }
        /// <p>An object that describes the origin resource of the distribution, such as a Lightsail
        /// instance or load balancer.</p>
        /// <p>The distribution pulls, caches, and serves content from the origin.</p>
        pub fn origin(mut self, input: crate::model::Origin) -> Self {
            self.origin = Some(input);
            self
        }
        /// <p>An object that describes the origin resource of the distribution, such as a Lightsail
        /// instance or load balancer.</p>
        /// <p>The distribution pulls, caches, and serves content from the origin.</p>
        pub fn set_origin(mut self, input: std::option::Option<crate::model::Origin>) -> Self {
            self.origin = input;
            self
        }
        /// <p>The public DNS of the origin.</p>
        pub fn origin_public_dns(mut self, input: impl Into<std::string::String>) -> Self {
            self.origin_public_dns = Some(input.into());
            self
        }
        /// <p>The public DNS of the origin.</p>
        pub fn set_origin_public_dns(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.origin_public_dns = input;
            self
        }
        /// <p>An object that describes the default cache behavior of the distribution.</p>
        pub fn default_cache_behavior(mut self, input: crate::model::CacheBehavior) -> Self {
            self.default_cache_behavior = Some(input);
            self
        }
        /// <p>An object that describes the default cache behavior of the distribution.</p>
        pub fn set_default_cache_behavior(
            mut self,
            input: std::option::Option<crate::model::CacheBehavior>,
        ) -> Self {
            self.default_cache_behavior = input;
            self
        }
        /// <p>An object that describes the cache behavior settings of the distribution.</p>
        pub fn cache_behavior_settings(mut self, input: crate::model::CacheSettings) -> Self {
            self.cache_behavior_settings = Some(input);
            self
        }
        /// <p>An object that describes the cache behavior settings of the distribution.</p>
        pub fn set_cache_behavior_settings(
            mut self,
            input: std::option::Option<crate::model::CacheSettings>,
        ) -> Self {
            self.cache_behavior_settings = input;
            self
        }
        /// Appends an item to `cache_behaviors`.
        ///
        /// To override the contents of this collection use [`set_cache_behaviors`](Self::set_cache_behaviors).
        ///
        /// <p>An array of objects that describe the per-path cache behavior of the distribution.</p>
        pub fn cache_behaviors(
            mut self,
            input: impl Into<crate::model::CacheBehaviorPerPath>,
        ) -> Self {
            let mut v = self.cache_behaviors.unwrap_or_default();
            v.push(input.into());
            self.cache_behaviors = Some(v);
            self
        }
        /// <p>An array of objects that describe the per-path cache behavior of the distribution.</p>
        pub fn set_cache_behaviors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CacheBehaviorPerPath>>,
        ) -> Self {
            self.cache_behaviors = input;
            self
        }
        /// <p>Indicates whether the bundle that is currently applied to your distribution, specified
        /// using the <code>distributionName</code> parameter, can be changed to another bundle.</p>
        /// <p>Use the <code>UpdateDistributionBundle</code> action to change your distribution's
        /// bundle.</p>
        pub fn able_to_update_bundle(mut self, input: bool) -> Self {
            self.able_to_update_bundle = Some(input);
            self
        }
        /// <p>Indicates whether the bundle that is currently applied to your distribution, specified
        /// using the <code>distributionName</code> parameter, can be changed to another bundle.</p>
        /// <p>Use the <code>UpdateDistributionBundle</code> action to change your distribution's
        /// bundle.</p>
        pub fn set_able_to_update_bundle(mut self, input: std::option::Option<bool>) -> Self {
            self.able_to_update_bundle = input;
            self
        }
        /// <p>The IP address type of the distribution.</p>
        ///
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for
        /// IPv4 and IPv6.</p>
        pub fn ip_address_type(mut self, input: crate::model::IpAddressType) -> Self {
            self.ip_address_type = Some(input);
            self
        }
        /// <p>The IP address type of the distribution.</p>
        ///
        /// <p>The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for
        /// IPv4 and IPv6.</p>
        pub fn set_ip_address_type(
            mut self,
            input: std::option::Option<crate::model::IpAddressType>,
        ) -> Self {
            self.ip_address_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`LightsailDistribution`](crate::model::LightsailDistribution)
        pub fn build(self) -> crate::model::LightsailDistribution {
            crate::model::LightsailDistribution {
                name: self.name,
                arn: self.arn,
                support_code: self.support_code,
                created_at: self.created_at,
                location: self.location,
                resource_type: self.resource_type,
                alternative_domain_names: self.alternative_domain_names,
                status: self.status,
                is_enabled: self.is_enabled,
                domain_name: self.domain_name,
                bundle_id: self.bundle_id,
                certificate_name: self.certificate_name,
                origin: self.origin,
                origin_public_dns: self.origin_public_dns,
                default_cache_behavior: self.default_cache_behavior,
                cache_behavior_settings: self.cache_behavior_settings,
                cache_behaviors: self.cache_behaviors,
                able_to_update_bundle: self.able_to_update_bundle,
                ip_address_type: self.ip_address_type,
                tags: self.tags,
            }
        }
    }
}
impl LightsailDistribution {
    /// Creates a new builder-style object to manufacture [`LightsailDistribution`](crate::model::LightsailDistribution)
    pub fn builder() -> crate::model::lightsail_distribution::Builder {
        crate::model::lightsail_distribution::Builder::default()
    }
}

/// <p>Describes the origin resource of an Amazon Lightsail content delivery network (CDN)
/// distribution.</p>
/// <p>An origin can be a Lightsail instance or load balancer. A distribution pulls content
/// from an origin, caches it, and serves it to viewers via a worldwide network of edge
/// servers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Origin {
    /// <p>The name of the origin resource.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The resource type of the origin resource (e.g., <i>Instance</i>).</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The AWS Region name of the origin resource.</p>
    pub region_name: std::option::Option<crate::model::RegionName>,
    /// <p>The protocol that your Amazon Lightsail distribution uses when establishing a connection
    /// with your origin to pull content.</p>
    pub protocol_policy: std::option::Option<crate::model::OriginProtocolPolicyEnum>,
}
impl std::fmt::Debug for Origin {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Origin");
        formatter.field("name", &self.name);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("region_name", &self.region_name);
        formatter.field("protocol_policy", &self.protocol_policy);
        formatter.finish()
    }
}
/// See [`Origin`](crate::model::Origin)
pub mod origin {
    /// A builder for [`Origin`](crate::model::Origin)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) region_name: std::option::Option<crate::model::RegionName>,
        pub(crate) protocol_policy: std::option::Option<crate::model::OriginProtocolPolicyEnum>,
    }
    impl Builder {
        /// <p>The name of the origin resource.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the origin resource.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The resource type of the origin resource (e.g., <i>Instance</i>).</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The resource type of the origin resource (e.g., <i>Instance</i>).</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The AWS Region name of the origin resource.</p>
        pub fn region_name(mut self, input: crate::model::RegionName) -> Self {
            self.region_name = Some(input);
            self
        }
        /// <p>The AWS Region name of the origin resource.</p>
        pub fn set_region_name(
            mut self,
            input: std::option::Option<crate::model::RegionName>,
        ) -> Self {
            self.region_name = input;
            self
        }
        /// <p>The protocol that your Amazon Lightsail distribution uses when establishing a connection
        /// with your origin to pull content.</p>
        pub fn protocol_policy(mut self, input: crate::model::OriginProtocolPolicyEnum) -> Self {
            self.protocol_policy = Some(input);
            self
        }
        /// <p>The protocol that your Amazon Lightsail distribution uses when establishing a connection
        /// with your origin to pull content.</p>
        pub fn set_protocol_policy(
            mut self,
            input: std::option::Option<crate::model::OriginProtocolPolicyEnum>,
        ) -> Self {
            self.protocol_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`Origin`](crate::model::Origin)
        pub fn build(self) -> crate::model::Origin {
            crate::model::Origin {
                name: self.name,
                resource_type: self.resource_type,
                region_name: self.region_name,
                protocol_policy: self.protocol_policy,
            }
        }
    }
}
impl Origin {
    /// Creates a new builder-style object to manufacture [`Origin`](crate::model::Origin)
    pub fn builder() -> crate::model::origin::Builder {
        crate::model::origin::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DistributionMetricName {
    #[allow(missing_docs)] // documentation missing in model
    BytesDownloaded,
    #[allow(missing_docs)] // documentation missing in model
    BytesUploaded,
    #[allow(missing_docs)] // documentation missing in model
    Http4xxErrorRate,
    #[allow(missing_docs)] // documentation missing in model
    Http5xxErrorRate,
    #[allow(missing_docs)] // documentation missing in model
    Requests,
    #[allow(missing_docs)] // documentation missing in model
    TotalErrorRate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DistributionMetricName {
    fn from(s: &str) -> Self {
        match s {
            "BytesDownloaded" => DistributionMetricName::BytesDownloaded,
            "BytesUploaded" => DistributionMetricName::BytesUploaded,
            "Http4xxErrorRate" => DistributionMetricName::Http4xxErrorRate,
            "Http5xxErrorRate" => DistributionMetricName::Http5xxErrorRate,
            "Requests" => DistributionMetricName::Requests,
            "TotalErrorRate" => DistributionMetricName::TotalErrorRate,
            other => DistributionMetricName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DistributionMetricName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DistributionMetricName::from(s))
    }
}
impl DistributionMetricName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DistributionMetricName::BytesDownloaded => "BytesDownloaded",
            DistributionMetricName::BytesUploaded => "BytesUploaded",
            DistributionMetricName::Http4xxErrorRate => "Http4xxErrorRate",
            DistributionMetricName::Http5xxErrorRate => "Http5xxErrorRate",
            DistributionMetricName::Requests => "Requests",
            DistributionMetricName::TotalErrorRate => "TotalErrorRate",
            DistributionMetricName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BytesDownloaded",
            "BytesUploaded",
            "Http4xxErrorRate",
            "Http5xxErrorRate",
            "Requests",
            "TotalErrorRate",
        ]
    }
}
impl AsRef<str> for DistributionMetricName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the specifications of a distribution bundle.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DistributionBundle {
    /// <p>The ID of the bundle.</p>
    pub bundle_id: std::option::Option<std::string::String>,
    /// <p>The name of the distribution bundle.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The monthly price, in US dollars, of the bundle.</p>
    pub price: std::option::Option<f32>,
    /// <p>The monthly network transfer quota of the bundle.</p>
    pub transfer_per_month_in_gb: std::option::Option<i32>,
    /// <p>Indicates whether the bundle is active, and can be specified for a new or existing
    /// distribution.</p>
    pub is_active: std::option::Option<bool>,
}
impl std::fmt::Debug for DistributionBundle {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DistributionBundle");
        formatter.field("bundle_id", &self.bundle_id);
        formatter.field("name", &self.name);
        formatter.field("price", &self.price);
        formatter.field("transfer_per_month_in_gb", &self.transfer_per_month_in_gb);
        formatter.field("is_active", &self.is_active);
        formatter.finish()
    }
}
/// See [`DistributionBundle`](crate::model::DistributionBundle)
pub mod distribution_bundle {
    /// A builder for [`DistributionBundle`](crate::model::DistributionBundle)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bundle_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) price: std::option::Option<f32>,
        pub(crate) transfer_per_month_in_gb: std::option::Option<i32>,
        pub(crate) is_active: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the bundle.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_id = Some(input.into());
            self
        }
        /// <p>The ID of the bundle.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_id = input;
            self
        }
        /// <p>The name of the distribution bundle.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the distribution bundle.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The monthly price, in US dollars, of the bundle.</p>
        pub fn price(mut self, input: f32) -> Self {
            self.price = Some(input);
            self
        }
        /// <p>The monthly price, in US dollars, of the bundle.</p>
        pub fn set_price(mut self, input: std::option::Option<f32>) -> Self {
            self.price = input;
            self
        }
        /// <p>The monthly network transfer quota of the bundle.</p>
        pub fn transfer_per_month_in_gb(mut self, input: i32) -> Self {
            self.transfer_per_month_in_gb = Some(input);
            self
        }
        /// <p>The monthly network transfer quota of the bundle.</p>
        pub fn set_transfer_per_month_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.transfer_per_month_in_gb = input;
            self
        }
        /// <p>Indicates whether the bundle is active, and can be specified for a new or existing
        /// distribution.</p>
        pub fn is_active(mut self, input: bool) -> Self {
            self.is_active = Some(input);
            self
        }
        /// <p>Indicates whether the bundle is active, and can be specified for a new or existing
        /// distribution.</p>
        pub fn set_is_active(mut self, input: std::option::Option<bool>) -> Self {
            self.is_active = input;
            self
        }
        /// Consumes the builder and constructs a [`DistributionBundle`](crate::model::DistributionBundle)
        pub fn build(self) -> crate::model::DistributionBundle {
            crate::model::DistributionBundle {
                bundle_id: self.bundle_id,
                name: self.name,
                price: self.price,
                transfer_per_month_in_gb: self.transfer_per_month_in_gb,
                is_active: self.is_active,
            }
        }
    }
}
impl DistributionBundle {
    /// Creates a new builder-style object to manufacture [`DistributionBundle`](crate::model::DistributionBundle)
    pub fn builder() -> crate::model::distribution_bundle::Builder {
        crate::model::distribution_bundle::Builder::default()
    }
}

/// <p>Describes a block storage disk snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DiskSnapshot {
    /// <p>The name of the disk snapshot (e.g., <code>my-disk-snapshot</code>).</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the disk snapshot.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The support code. Include this code in your email to support when you have questions about
    /// an instance or another resource in Lightsail. This code enables our support team to look up
    /// your Lightsail information more easily.</p>
    pub support_code: std::option::Option<std::string::String>,
    /// <p>The date when the disk snapshot was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The AWS Region and Availability Zone where the disk snapshot was created.</p>
    pub location: std::option::Option<crate::model::ResourceLocation>,
    /// <p>The Lightsail resource type (e.g., <code>DiskSnapshot</code>).</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The tag keys and optional values for the resource. For more information about tags in
    /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The size of the disk in GB.</p>
    pub size_in_gb: std::option::Option<i32>,
    /// <p>The status of the disk snapshot operation.</p>
    pub state: std::option::Option<crate::model::DiskSnapshotState>,
    /// <p>The progress of the snapshot.</p>
    pub progress: std::option::Option<std::string::String>,
    /// <p>The unique name of the source disk from which the disk snapshot was created.</p>
    pub from_disk_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the source disk from which the disk snapshot was
    /// created.</p>
    pub from_disk_arn: std::option::Option<std::string::String>,
    /// <p>The unique name of the source instance from which the disk (system volume) snapshot was
    /// created.</p>
    pub from_instance_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the source instance from which the disk (system volume)
    /// snapshot was created.</p>
    pub from_instance_arn: std::option::Option<std::string::String>,
    /// <p>A Boolean value indicating whether the snapshot was created from an automatic
    /// snapshot.</p>
    pub is_from_auto_snapshot: std::option::Option<bool>,
}
impl std::fmt::Debug for DiskSnapshot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DiskSnapshot");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("support_code", &self.support_code);
        formatter.field("created_at", &self.created_at);
        formatter.field("location", &self.location);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("tags", &self.tags);
        formatter.field("size_in_gb", &self.size_in_gb);
        formatter.field("state", &self.state);
        formatter.field("progress", &self.progress);
        formatter.field("from_disk_name", &self.from_disk_name);
        formatter.field("from_disk_arn", &self.from_disk_arn);
        formatter.field("from_instance_name", &self.from_instance_name);
        formatter.field("from_instance_arn", &self.from_instance_arn);
        formatter.field("is_from_auto_snapshot", &self.is_from_auto_snapshot);
        formatter.finish()
    }
}
/// See [`DiskSnapshot`](crate::model::DiskSnapshot)
pub mod disk_snapshot {
    /// A builder for [`DiskSnapshot`](crate::model::DiskSnapshot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) support_code: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) location: std::option::Option<crate::model::ResourceLocation>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) size_in_gb: std::option::Option<i32>,
        pub(crate) state: std::option::Option<crate::model::DiskSnapshotState>,
        pub(crate) progress: std::option::Option<std::string::String>,
        pub(crate) from_disk_name: std::option::Option<std::string::String>,
        pub(crate) from_disk_arn: std::option::Option<std::string::String>,
        pub(crate) from_instance_name: std::option::Option<std::string::String>,
        pub(crate) from_instance_arn: std::option::Option<std::string::String>,
        pub(crate) is_from_auto_snapshot: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the disk snapshot (e.g., <code>my-disk-snapshot</code>).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the disk snapshot (e.g., <code>my-disk-snapshot</code>).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the disk snapshot.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the disk snapshot.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// an instance or another resource in Lightsail. This code enables our support team to look up
        /// your Lightsail information more easily.</p>
        pub fn support_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_code = Some(input.into());
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// an instance or another resource in Lightsail. This code enables our support team to look up
        /// your Lightsail information more easily.</p>
        pub fn set_support_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.support_code = input;
            self
        }
        /// <p>The date when the disk snapshot was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date when the disk snapshot was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The AWS Region and Availability Zone where the disk snapshot was created.</p>
        pub fn location(mut self, input: crate::model::ResourceLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>The AWS Region and Availability Zone where the disk snapshot was created.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::ResourceLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>The Lightsail resource type (e.g., <code>DiskSnapshot</code>).</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The Lightsail resource type (e.g., <code>DiskSnapshot</code>).</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The size of the disk in GB.</p>
        pub fn size_in_gb(mut self, input: i32) -> Self {
            self.size_in_gb = Some(input);
            self
        }
        /// <p>The size of the disk in GB.</p>
        pub fn set_size_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.size_in_gb = input;
            self
        }
        /// <p>The status of the disk snapshot operation.</p>
        pub fn state(mut self, input: crate::model::DiskSnapshotState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The status of the disk snapshot operation.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::DiskSnapshotState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The progress of the snapshot.</p>
        pub fn progress(mut self, input: impl Into<std::string::String>) -> Self {
            self.progress = Some(input.into());
            self
        }
        /// <p>The progress of the snapshot.</p>
        pub fn set_progress(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.progress = input;
            self
        }
        /// <p>The unique name of the source disk from which the disk snapshot was created.</p>
        pub fn from_disk_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_disk_name = Some(input.into());
            self
        }
        /// <p>The unique name of the source disk from which the disk snapshot was created.</p>
        pub fn set_from_disk_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_disk_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source disk from which the disk snapshot was
        /// created.</p>
        pub fn from_disk_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_disk_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source disk from which the disk snapshot was
        /// created.</p>
        pub fn set_from_disk_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_disk_arn = input;
            self
        }
        /// <p>The unique name of the source instance from which the disk (system volume) snapshot was
        /// created.</p>
        pub fn from_instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_instance_name = Some(input.into());
            self
        }
        /// <p>The unique name of the source instance from which the disk (system volume) snapshot was
        /// created.</p>
        pub fn set_from_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_instance_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source instance from which the disk (system volume)
        /// snapshot was created.</p>
        pub fn from_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source instance from which the disk (system volume)
        /// snapshot was created.</p>
        pub fn set_from_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_instance_arn = input;
            self
        }
        /// <p>A Boolean value indicating whether the snapshot was created from an automatic
        /// snapshot.</p>
        pub fn is_from_auto_snapshot(mut self, input: bool) -> Self {
            self.is_from_auto_snapshot = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether the snapshot was created from an automatic
        /// snapshot.</p>
        pub fn set_is_from_auto_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.is_from_auto_snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`DiskSnapshot`](crate::model::DiskSnapshot)
        pub fn build(self) -> crate::model::DiskSnapshot {
            crate::model::DiskSnapshot {
                name: self.name,
                arn: self.arn,
                support_code: self.support_code,
                created_at: self.created_at,
                location: self.location,
                resource_type: self.resource_type,
                tags: self.tags,
                size_in_gb: self.size_in_gb,
                state: self.state,
                progress: self.progress,
                from_disk_name: self.from_disk_name,
                from_disk_arn: self.from_disk_arn,
                from_instance_name: self.from_instance_name,
                from_instance_arn: self.from_instance_arn,
                is_from_auto_snapshot: self.is_from_auto_snapshot,
            }
        }
    }
}
impl DiskSnapshot {
    /// Creates a new builder-style object to manufacture [`DiskSnapshot`](crate::model::DiskSnapshot)
    pub fn builder() -> crate::model::disk_snapshot::Builder {
        crate::model::disk_snapshot::Builder::default()
    }
}

/// _Note: `DiskSnapshotState::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DiskSnapshotState {
    #[allow(missing_docs)] // documentation missing in model
    Completed,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DiskSnapshotState {
    fn from(s: &str) -> Self {
        match s {
            "completed" => DiskSnapshotState::Completed,
            "error" => DiskSnapshotState::Error,
            "pending" => DiskSnapshotState::Pending,
            "unknown" => DiskSnapshotState::UnknownValue,
            other => DiskSnapshotState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DiskSnapshotState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DiskSnapshotState::from(s))
    }
}
impl DiskSnapshotState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DiskSnapshotState::Completed => "completed",
            DiskSnapshotState::Error => "error",
            DiskSnapshotState::Pending => "pending",
            DiskSnapshotState::UnknownValue => "unknown",
            DiskSnapshotState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["completed", "error", "pending", "unknown"]
    }
}
impl AsRef<str> for DiskSnapshotState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the powers that can be specified for an Amazon Lightsail container
/// service.</p>
///
/// <p>The power specifies the amount of RAM, the number of vCPUs, and the base price of the
/// container service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContainerServicePower {
    /// <p>The ID of the power (e.g., <code>nano-1</code>).</p>
    pub power_id: std::option::Option<std::string::String>,
    /// <p>The monthly price of the power in USD.</p>
    pub price: std::option::Option<f32>,
    /// <p>The number of vCPUs included in the power.</p>
    pub cpu_count: std::option::Option<f32>,
    /// <p>The amount of RAM (in GB) of the power.</p>
    pub ram_size_in_gb: std::option::Option<f32>,
    /// <p>The friendly name of the power (e.g., <code>nano</code>).</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A Boolean value indicating whether the power is active and can be specified for container
    /// services.</p>
    pub is_active: std::option::Option<bool>,
}
impl std::fmt::Debug for ContainerServicePower {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContainerServicePower");
        formatter.field("power_id", &self.power_id);
        formatter.field("price", &self.price);
        formatter.field("cpu_count", &self.cpu_count);
        formatter.field("ram_size_in_gb", &self.ram_size_in_gb);
        formatter.field("name", &self.name);
        formatter.field("is_active", &self.is_active);
        formatter.finish()
    }
}
/// See [`ContainerServicePower`](crate::model::ContainerServicePower)
pub mod container_service_power {
    /// A builder for [`ContainerServicePower`](crate::model::ContainerServicePower)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) power_id: std::option::Option<std::string::String>,
        pub(crate) price: std::option::Option<f32>,
        pub(crate) cpu_count: std::option::Option<f32>,
        pub(crate) ram_size_in_gb: std::option::Option<f32>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) is_active: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the power (e.g., <code>nano-1</code>).</p>
        pub fn power_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.power_id = Some(input.into());
            self
        }
        /// <p>The ID of the power (e.g., <code>nano-1</code>).</p>
        pub fn set_power_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.power_id = input;
            self
        }
        /// <p>The monthly price of the power in USD.</p>
        pub fn price(mut self, input: f32) -> Self {
            self.price = Some(input);
            self
        }
        /// <p>The monthly price of the power in USD.</p>
        pub fn set_price(mut self, input: std::option::Option<f32>) -> Self {
            self.price = input;
            self
        }
        /// <p>The number of vCPUs included in the power.</p>
        pub fn cpu_count(mut self, input: f32) -> Self {
            self.cpu_count = Some(input);
            self
        }
        /// <p>The number of vCPUs included in the power.</p>
        pub fn set_cpu_count(mut self, input: std::option::Option<f32>) -> Self {
            self.cpu_count = input;
            self
        }
        /// <p>The amount of RAM (in GB) of the power.</p>
        pub fn ram_size_in_gb(mut self, input: f32) -> Self {
            self.ram_size_in_gb = Some(input);
            self
        }
        /// <p>The amount of RAM (in GB) of the power.</p>
        pub fn set_ram_size_in_gb(mut self, input: std::option::Option<f32>) -> Self {
            self.ram_size_in_gb = input;
            self
        }
        /// <p>The friendly name of the power (e.g., <code>nano</code>).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the power (e.g., <code>nano</code>).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A Boolean value indicating whether the power is active and can be specified for container
        /// services.</p>
        pub fn is_active(mut self, input: bool) -> Self {
            self.is_active = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether the power is active and can be specified for container
        /// services.</p>
        pub fn set_is_active(mut self, input: std::option::Option<bool>) -> Self {
            self.is_active = input;
            self
        }
        /// Consumes the builder and constructs a [`ContainerServicePower`](crate::model::ContainerServicePower)
        pub fn build(self) -> crate::model::ContainerServicePower {
            crate::model::ContainerServicePower {
                power_id: self.power_id,
                price: self.price,
                cpu_count: self.cpu_count,
                ram_size_in_gb: self.ram_size_in_gb,
                name: self.name,
                is_active: self.is_active,
            }
        }
    }
}
impl ContainerServicePower {
    /// Creates a new builder-style object to manufacture [`ContainerServicePower`](crate::model::ContainerServicePower)
    pub fn builder() -> crate::model::container_service_power::Builder {
        crate::model::container_service_power::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContainerServiceMetricName {
    #[allow(missing_docs)] // documentation missing in model
    CpuUtilization,
    #[allow(missing_docs)] // documentation missing in model
    MemoryUtilization,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContainerServiceMetricName {
    fn from(s: &str) -> Self {
        match s {
            "CPUUtilization" => ContainerServiceMetricName::CpuUtilization,
            "MemoryUtilization" => ContainerServiceMetricName::MemoryUtilization,
            other => ContainerServiceMetricName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContainerServiceMetricName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContainerServiceMetricName::from(s))
    }
}
impl ContainerServiceMetricName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContainerServiceMetricName::CpuUtilization => "CPUUtilization",
            ContainerServiceMetricName::MemoryUtilization => "MemoryUtilization",
            ContainerServiceMetricName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CPUUtilization", "MemoryUtilization"]
    }
}
impl AsRef<str> for ContainerServiceMetricName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the log events of a container of an Amazon Lightsail container service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContainerServiceLogEvent {
    /// <p>The timestamp when the container service log event was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The message of the container service log event.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ContainerServiceLogEvent {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContainerServiceLogEvent");
        formatter.field("created_at", &self.created_at);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`ContainerServiceLogEvent`](crate::model::ContainerServiceLogEvent)
pub mod container_service_log_event {
    /// A builder for [`ContainerServiceLogEvent`](crate::model::ContainerServiceLogEvent)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The timestamp when the container service log event was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when the container service log event was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The message of the container service log event.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message of the container service log event.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ContainerServiceLogEvent`](crate::model::ContainerServiceLogEvent)
        pub fn build(self) -> crate::model::ContainerServiceLogEvent {
            crate::model::ContainerServiceLogEvent {
                created_at: self.created_at,
                message: self.message,
            }
        }
    }
}
impl ContainerServiceLogEvent {
    /// Creates a new builder-style object to manufacture [`ContainerServiceLogEvent`](crate::model::ContainerServiceLogEvent)
    pub fn builder() -> crate::model::container_service_log_event::Builder {
        crate::model::container_service_log_event::Builder::default()
    }
}

/// <p>Describes a contact method.</p>
/// <p>A contact method is a way to send you notifications. For more information, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in Amazon Lightsail</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContactMethod {
    /// <p>The destination of the contact method, such as an email address or a mobile phone
    /// number.</p>
    pub contact_endpoint: std::option::Option<std::string::String>,
    /// <p>The current status of the contact method.</p>
    /// <p>A contact method has the following possible status:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PendingVerification</code> - The contact method has not yet been verified, and
    /// the verification has not yet expired.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Valid</code> - The contact method has been verified.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>InValid</code> - An attempt was made to verify the contact method, but the
    /// verification has expired.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::ContactMethodStatus>,
    /// <p>The protocol of the contact method, such as email or SMS (text messaging).</p>
    pub protocol: std::option::Option<crate::model::ContactProtocol>,
    /// <p>The name of the contact method.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the contact method.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The timestamp when the contact method was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Describes the resource location.</p>
    pub location: std::option::Option<crate::model::ResourceLocation>,
    /// <p>The Lightsail resource type (e.g., <code>ContactMethod</code>).</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The support code. Include this code in your email to support when you have questions about
    /// your Lightsail contact method. This code enables our support team to look up your
    /// Lightsail information more easily.</p>
    pub support_code: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ContactMethod {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContactMethod");
        formatter.field("contact_endpoint", &self.contact_endpoint);
        formatter.field("status", &self.status);
        formatter.field("protocol", &self.protocol);
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("location", &self.location);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("support_code", &self.support_code);
        formatter.finish()
    }
}
/// See [`ContactMethod`](crate::model::ContactMethod)
pub mod contact_method {
    /// A builder for [`ContactMethod`](crate::model::ContactMethod)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_endpoint: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ContactMethodStatus>,
        pub(crate) protocol: std::option::Option<crate::model::ContactProtocol>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) location: std::option::Option<crate::model::ResourceLocation>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) support_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The destination of the contact method, such as an email address or a mobile phone
        /// number.</p>
        pub fn contact_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_endpoint = Some(input.into());
            self
        }
        /// <p>The destination of the contact method, such as an email address or a mobile phone
        /// number.</p>
        pub fn set_contact_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_endpoint = input;
            self
        }
        /// <p>The current status of the contact method.</p>
        /// <p>A contact method has the following possible status:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PendingVerification</code> - The contact method has not yet been verified, and
        /// the verification has not yet expired.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Valid</code> - The contact method has been verified.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InValid</code> - An attempt was made to verify the contact method, but the
        /// verification has expired.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::ContactMethodStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the contact method.</p>
        /// <p>A contact method has the following possible status:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PendingVerification</code> - The contact method has not yet been verified, and
        /// the verification has not yet expired.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Valid</code> - The contact method has been verified.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InValid</code> - An attempt was made to verify the contact method, but the
        /// verification has expired.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ContactMethodStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The protocol of the contact method, such as email or SMS (text messaging).</p>
        pub fn protocol(mut self, input: crate::model::ContactProtocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// <p>The protocol of the contact method, such as email or SMS (text messaging).</p>
        pub fn set_protocol(
            mut self,
            input: std::option::Option<crate::model::ContactProtocol>,
        ) -> Self {
            self.protocol = input;
            self
        }
        /// <p>The name of the contact method.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the contact method.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact method.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the contact method.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The timestamp when the contact method was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when the contact method was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>Describes the resource location.</p>
        pub fn location(mut self, input: crate::model::ResourceLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>Describes the resource location.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::ResourceLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>The Lightsail resource type (e.g., <code>ContactMethod</code>).</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The Lightsail resource type (e.g., <code>ContactMethod</code>).</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// your Lightsail contact method. This code enables our support team to look up your
        /// Lightsail information more easily.</p>
        pub fn support_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_code = Some(input.into());
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// your Lightsail contact method. This code enables our support team to look up your
        /// Lightsail information more easily.</p>
        pub fn set_support_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.support_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ContactMethod`](crate::model::ContactMethod)
        pub fn build(self) -> crate::model::ContactMethod {
            crate::model::ContactMethod {
                contact_endpoint: self.contact_endpoint,
                status: self.status,
                protocol: self.protocol,
                name: self.name,
                arn: self.arn,
                created_at: self.created_at,
                location: self.location,
                resource_type: self.resource_type,
                support_code: self.support_code,
            }
        }
    }
}
impl ContactMethod {
    /// Creates a new builder-style object to manufacture [`ContactMethod`](crate::model::ContactMethod)
    pub fn builder() -> crate::model::contact_method::Builder {
        crate::model::contact_method::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ContactMethodStatus {
    #[allow(missing_docs)] // documentation missing in model
    Invalid,
    #[allow(missing_docs)] // documentation missing in model
    PendingVerification,
    #[allow(missing_docs)] // documentation missing in model
    Valid,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ContactMethodStatus {
    fn from(s: &str) -> Self {
        match s {
            "Invalid" => ContactMethodStatus::Invalid,
            "PendingVerification" => ContactMethodStatus::PendingVerification,
            "Valid" => ContactMethodStatus::Valid,
            other => ContactMethodStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ContactMethodStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ContactMethodStatus::from(s))
    }
}
impl ContactMethodStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ContactMethodStatus::Invalid => "Invalid",
            ContactMethodStatus::PendingVerification => "PendingVerification",
            ContactMethodStatus::Valid => "Valid",
            ContactMethodStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Invalid", "PendingVerification", "Valid"]
    }
}
impl AsRef<str> for ContactMethodStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a CloudFormation stack record created as a result of the <code>create cloud
/// formation stack</code> action.</p>
/// <p>A CloudFormation stack record provides information about the AWS CloudFormation stack used to
/// create a new Amazon Elastic Compute Cloud instance from an exported Lightsail instance snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudFormationStackRecord {
    /// <p>The name of the CloudFormation stack record. It starts with
    /// <code>CloudFormationStackRecord</code> followed by a GUID.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the CloudFormation stack record.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date when the CloudFormation stack record was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A list of objects describing the Availability Zone and AWS Region of the CloudFormation
    /// stack record.</p>
    pub location: std::option::Option<crate::model::ResourceLocation>,
    /// <p>The Lightsail resource type (e.g., <code>CloudFormationStackRecord</code>).</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The current state of the CloudFormation stack record.</p>
    pub state: std::option::Option<crate::model::RecordState>,
    /// <p>A list of objects describing the source of the CloudFormation stack record.</p>
    pub source_info:
        std::option::Option<std::vec::Vec<crate::model::CloudFormationStackRecordSourceInfo>>,
    /// <p>A list of objects describing the destination service, which is AWS CloudFormation, and the Amazon
    /// Resource Name (ARN) of the AWS CloudFormation stack.</p>
    pub destination_info: std::option::Option<crate::model::DestinationInfo>,
}
impl std::fmt::Debug for CloudFormationStackRecord {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudFormationStackRecord");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("location", &self.location);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("state", &self.state);
        formatter.field("source_info", &self.source_info);
        formatter.field("destination_info", &self.destination_info);
        formatter.finish()
    }
}
/// See [`CloudFormationStackRecord`](crate::model::CloudFormationStackRecord)
pub mod cloud_formation_stack_record {
    /// A builder for [`CloudFormationStackRecord`](crate::model::CloudFormationStackRecord)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) location: std::option::Option<crate::model::ResourceLocation>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) state: std::option::Option<crate::model::RecordState>,
        pub(crate) source_info:
            std::option::Option<std::vec::Vec<crate::model::CloudFormationStackRecordSourceInfo>>,
        pub(crate) destination_info: std::option::Option<crate::model::DestinationInfo>,
    }
    impl Builder {
        /// <p>The name of the CloudFormation stack record. It starts with
        /// <code>CloudFormationStackRecord</code> followed by a GUID.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the CloudFormation stack record. It starts with
        /// <code>CloudFormationStackRecord</code> followed by a GUID.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CloudFormation stack record.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the CloudFormation stack record.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date when the CloudFormation stack record was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date when the CloudFormation stack record was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>A list of objects describing the Availability Zone and AWS Region of the CloudFormation
        /// stack record.</p>
        pub fn location(mut self, input: crate::model::ResourceLocation) -> Self {
            self.location = Some(input);
            self
        }
        /// <p>A list of objects describing the Availability Zone and AWS Region of the CloudFormation
        /// stack record.</p>
        pub fn set_location(
            mut self,
            input: std::option::Option<crate::model::ResourceLocation>,
        ) -> Self {
            self.location = input;
            self
        }
        /// <p>The Lightsail resource type (e.g., <code>CloudFormationStackRecord</code>).</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The Lightsail resource type (e.g., <code>CloudFormationStackRecord</code>).</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The current state of the CloudFormation stack record.</p>
        pub fn state(mut self, input: crate::model::RecordState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the CloudFormation stack record.</p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::RecordState>) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `source_info`.
        ///
        /// To override the contents of this collection use [`set_source_info`](Self::set_source_info).
        ///
        /// <p>A list of objects describing the source of the CloudFormation stack record.</p>
        pub fn source_info(
            mut self,
            input: impl Into<crate::model::CloudFormationStackRecordSourceInfo>,
        ) -> Self {
            let mut v = self.source_info.unwrap_or_default();
            v.push(input.into());
            self.source_info = Some(v);
            self
        }
        /// <p>A list of objects describing the source of the CloudFormation stack record.</p>
        pub fn set_source_info(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CloudFormationStackRecordSourceInfo>,
            >,
        ) -> Self {
            self.source_info = input;
            self
        }
        /// <p>A list of objects describing the destination service, which is AWS CloudFormation, and the Amazon
        /// Resource Name (ARN) of the AWS CloudFormation stack.</p>
        pub fn destination_info(mut self, input: crate::model::DestinationInfo) -> Self {
            self.destination_info = Some(input);
            self
        }
        /// <p>A list of objects describing the destination service, which is AWS CloudFormation, and the Amazon
        /// Resource Name (ARN) of the AWS CloudFormation stack.</p>
        pub fn set_destination_info(
            mut self,
            input: std::option::Option<crate::model::DestinationInfo>,
        ) -> Self {
            self.destination_info = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudFormationStackRecord`](crate::model::CloudFormationStackRecord)
        pub fn build(self) -> crate::model::CloudFormationStackRecord {
            crate::model::CloudFormationStackRecord {
                name: self.name,
                arn: self.arn,
                created_at: self.created_at,
                location: self.location,
                resource_type: self.resource_type,
                state: self.state,
                source_info: self.source_info,
                destination_info: self.destination_info,
            }
        }
    }
}
impl CloudFormationStackRecord {
    /// Creates a new builder-style object to manufacture [`CloudFormationStackRecord`](crate::model::CloudFormationStackRecord)
    pub fn builder() -> crate::model::cloud_formation_stack_record::Builder {
        crate::model::cloud_formation_stack_record::Builder::default()
    }
}

/// <p>Describes the source of a CloudFormation stack record (i.e., the export snapshot
/// record).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudFormationStackRecordSourceInfo {
    /// <p>The Lightsail resource type (e.g., <code>ExportSnapshotRecord</code>).</p>
    pub resource_type: std::option::Option<crate::model::CloudFormationStackRecordSourceType>,
    /// <p>The name of the record.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the export snapshot record.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CloudFormationStackRecordSourceInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudFormationStackRecordSourceInfo");
        formatter.field("resource_type", &self.resource_type);
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`CloudFormationStackRecordSourceInfo`](crate::model::CloudFormationStackRecordSourceInfo)
pub mod cloud_formation_stack_record_source_info {
    /// A builder for [`CloudFormationStackRecordSourceInfo`](crate::model::CloudFormationStackRecordSourceInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_type:
            std::option::Option<crate::model::CloudFormationStackRecordSourceType>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Lightsail resource type (e.g., <code>ExportSnapshotRecord</code>).</p>
        pub fn resource_type(
            mut self,
            input: crate::model::CloudFormationStackRecordSourceType,
        ) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The Lightsail resource type (e.g., <code>ExportSnapshotRecord</code>).</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::CloudFormationStackRecordSourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The name of the record.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the record.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the export snapshot record.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the export snapshot record.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudFormationStackRecordSourceInfo`](crate::model::CloudFormationStackRecordSourceInfo)
        pub fn build(self) -> crate::model::CloudFormationStackRecordSourceInfo {
            crate::model::CloudFormationStackRecordSourceInfo {
                resource_type: self.resource_type,
                name: self.name,
                arn: self.arn,
            }
        }
    }
}
impl CloudFormationStackRecordSourceInfo {
    /// Creates a new builder-style object to manufacture [`CloudFormationStackRecordSourceInfo`](crate::model::CloudFormationStackRecordSourceInfo)
    pub fn builder() -> crate::model::cloud_formation_stack_record_source_info::Builder {
        crate::model::cloud_formation_stack_record_source_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CloudFormationStackRecordSourceType {
    #[allow(missing_docs)] // documentation missing in model
    ExportSnapshotRecord,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CloudFormationStackRecordSourceType {
    fn from(s: &str) -> Self {
        match s {
            "ExportSnapshotRecord" => CloudFormationStackRecordSourceType::ExportSnapshotRecord,
            other => CloudFormationStackRecordSourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CloudFormationStackRecordSourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CloudFormationStackRecordSourceType::from(s))
    }
}
impl CloudFormationStackRecordSourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CloudFormationStackRecordSourceType::ExportSnapshotRecord => "ExportSnapshotRecord",
            CloudFormationStackRecordSourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ExportSnapshotRecord"]
    }
}
impl AsRef<str> for CloudFormationStackRecordSourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an Amazon Lightsail SSL/TLS certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CertificateSummary {
    /// <p>The Amazon Resource Name (ARN) of the certificate.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>The name of the certificate.</p>
    pub certificate_name: std::option::Option<std::string::String>,
    /// <p>The domain name of the certificate.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>An object that describes a certificate in detail.</p>
    pub certificate_detail: std::option::Option<crate::model::Certificate>,
    /// <p>The tag keys and optional values for the resource. For more information about tags in
    /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CertificateSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CertificateSummary");
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("certificate_name", &self.certificate_name);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("certificate_detail", &self.certificate_detail);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CertificateSummary`](crate::model::CertificateSummary)
pub mod certificate_summary {
    /// A builder for [`CertificateSummary`](crate::model::CertificateSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_name: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) certificate_detail: std::option::Option<crate::model::Certificate>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the certificate.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the certificate.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The name of the certificate.</p>
        pub fn certificate_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_name = Some(input.into());
            self
        }
        /// <p>The name of the certificate.</p>
        pub fn set_certificate_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_name = input;
            self
        }
        /// <p>The domain name of the certificate.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name of the certificate.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>An object that describes a certificate in detail.</p>
        pub fn certificate_detail(mut self, input: crate::model::Certificate) -> Self {
            self.certificate_detail = Some(input);
            self
        }
        /// <p>An object that describes a certificate in detail.</p>
        pub fn set_certificate_detail(
            mut self,
            input: std::option::Option<crate::model::Certificate>,
        ) -> Self {
            self.certificate_detail = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CertificateSummary`](crate::model::CertificateSummary)
        pub fn build(self) -> crate::model::CertificateSummary {
            crate::model::CertificateSummary {
                certificate_arn: self.certificate_arn,
                certificate_name: self.certificate_name,
                domain_name: self.domain_name,
                certificate_detail: self.certificate_detail,
                tags: self.tags,
            }
        }
    }
}
impl CertificateSummary {
    /// Creates a new builder-style object to manufacture [`CertificateSummary`](crate::model::CertificateSummary)
    pub fn builder() -> crate::model::certificate_summary::Builder {
        crate::model::certificate_summary::Builder::default()
    }
}

/// <p>Describes the full details of an Amazon Lightsail SSL/TLS certificate.</p>
/// <note>
/// <p>To get a summary of a certificate, use the <code>GetCertificates</code> action and ommit
/// <code>includeCertificateDetails</code> from your request. The response will include only
/// the certificate Amazon Resource Name (ARN), certificate name, domain name, and tags.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Certificate {
    /// <p>The Amazon Resource Name (ARN) of the certificate.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The name of the certificate (e.g., <code>my-certificate</code>).</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The domain name of the certificate.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The validation status of the certificate.</p>
    pub status: std::option::Option<crate::model::CertificateStatus>,
    /// <p>The serial number of the certificate.</p>
    pub serial_number: std::option::Option<std::string::String>,
    /// <p>An array of strings that specify the alternate domains (e.g., <code>example2.com</code>)
    /// and subdomains (e.g., <code>blog.example.com</code>) of the certificate.</p>
    pub subject_alternative_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array of objects that describe the domain validation records of the certificate.</p>
    pub domain_validation_records:
        std::option::Option<std::vec::Vec<crate::model::DomainValidationRecord>>,
    /// <p>The validation failure reason, if any, of the certificate.</p>
    /// <p>The following failure reasons are possible:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>NO_AVAILABLE_CONTACTS</code>
    /// </b> - This failure
    /// applies to email validation, which is not available for Lightsail certificates.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>ADDITIONAL_VERIFICATION_REQUIRED</code>
    /// </b> -
    /// Lightsail requires additional information to process this certificate request. This can
    /// happen as a fraud-protection measure, such as when the domain ranks within the Alexa top
    /// 1000 websites. To provide the required information, use the <a href="https://console.aws.amazon.com/support/home">AWS Support Center</a> to contact
    /// AWS Support.</p>
    /// <note>
    /// <p>You cannot request a certificate for Amazon-owned domain names such as those ending
    /// in amazonaws.com, cloudfront.net, or elasticbeanstalk.com.</p>
    /// </note>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>DOMAIN_NOT_ALLOWED</code>
    /// </b> - One or more of the
    /// domain names in the certificate request was reported as an unsafe domain by <a href="https://www.virustotal.com/gui/home/url">VirusTotal</a>. To correct the
    /// problem, search for your domain name on the <a href="https://www.virustotal.com/gui/home/url">VirusTotal</a> website. If your domain
    /// is reported as suspicious, see <a href="https://developers.google.com/web/fundamentals/security/hacked">Google Help for
    /// Hacked Websites</a> to learn what you can do.</p>
    /// <p>If you believe that the result is a false positive, notify the organization that is
    /// reporting the domain. VirusTotal is an aggregate of several antivirus and URL scanners and
    /// cannot remove your domain from a block list itself. After you correct the problem and the
    /// VirusTotal registry has been updated, request a new certificate.</p>
    /// <p>If you see this error and your domain is not included in the VirusTotal list, visit
    /// the <a href="https://console.aws.amazon.com/support/home">AWS Support Center</a>
    /// and create a case.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>INVALID_PUBLIC_DOMAIN</code>
    /// </b> - One or more of
    /// the domain names in the certificate request is not valid. Typically, this is because a
    /// domain name in the request is not a valid top-level domain. Try to request a certificate
    /// again, correcting any spelling errors or typos that were in the failed request, and ensure
    /// that all domain names in the request are for valid top-level domains. For example, you
    /// cannot request a certificate for <code>example.invalidpublicdomain</code> because
    /// <code>invalidpublicdomain</code> is not a valid top-level domain.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>OTHER</code>
    /// </b> - Typically, this failure occurs
    /// when there is a typographical error in one or more of the domain names in the certificate
    /// request. Try to request a certificate again, correcting any spelling errors or typos that
    /// were in the failed request. </p>
    /// </li>
    /// </ul>
    pub request_failure_reason: std::option::Option<std::string::String>,
    /// <p>The number of Lightsail resources that the certificate is attached to.</p>
    pub in_use_resource_count: i32,
    /// <p>The algorithm used to generate the key pair (the public and private key) of the
    /// certificate.</p>
    pub key_algorithm: std::option::Option<std::string::String>,
    /// <p>The timestamp when the certificate was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp when the certificate was issued.</p>
    pub issued_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The certificate authority that issued the certificate.</p>
    pub issuer_ca: std::option::Option<std::string::String>,
    /// <p>The timestamp when the certificate is first valid.</p>
    pub not_before: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp when the certificate expires.</p>
    pub not_after: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The renewal eligibility of the certificate.</p>
    pub eligible_to_renew: std::option::Option<std::string::String>,
    /// <p>An object that describes the status of the certificate renewal managed by
    /// Lightsail.</p>
    pub renewal_summary: std::option::Option<crate::model::RenewalSummary>,
    /// <p>The timestamp when the certificate was revoked. This value is present only when the
    /// certificate status is <code>REVOKED</code>.</p>
    pub revoked_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The reason the certificate was revoked. This value is present only when the certificate
    /// status is <code>REVOKED</code>.</p>
    pub revocation_reason: std::option::Option<std::string::String>,
    /// <p>The tag keys and optional values for the resource. For more information about tags in
    /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The support code. Include this code in your email to support when you have questions about
    /// your Lightsail certificate. This code enables our support team to look up your Lightsail
    /// information more easily.</p>
    pub support_code: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Certificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Certificate");
        formatter.field("arn", &self.arn);
        formatter.field("name", &self.name);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("status", &self.status);
        formatter.field("serial_number", &self.serial_number);
        formatter.field("subject_alternative_names", &self.subject_alternative_names);
        formatter.field("domain_validation_records", &self.domain_validation_records);
        formatter.field("request_failure_reason", &self.request_failure_reason);
        formatter.field("in_use_resource_count", &self.in_use_resource_count);
        formatter.field("key_algorithm", &self.key_algorithm);
        formatter.field("created_at", &self.created_at);
        formatter.field("issued_at", &self.issued_at);
        formatter.field("issuer_ca", &self.issuer_ca);
        formatter.field("not_before", &self.not_before);
        formatter.field("not_after", &self.not_after);
        formatter.field("eligible_to_renew", &self.eligible_to_renew);
        formatter.field("renewal_summary", &self.renewal_summary);
        formatter.field("revoked_at", &self.revoked_at);
        formatter.field("revocation_reason", &self.revocation_reason);
        formatter.field("tags", &self.tags);
        formatter.field("support_code", &self.support_code);
        formatter.finish()
    }
}
/// See [`Certificate`](crate::model::Certificate)
pub mod certificate {
    /// A builder for [`Certificate`](crate::model::Certificate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::CertificateStatus>,
        pub(crate) serial_number: std::option::Option<std::string::String>,
        pub(crate) subject_alternative_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) domain_validation_records:
            std::option::Option<std::vec::Vec<crate::model::DomainValidationRecord>>,
        pub(crate) request_failure_reason: std::option::Option<std::string::String>,
        pub(crate) in_use_resource_count: std::option::Option<i32>,
        pub(crate) key_algorithm: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) issued_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) issuer_ca: std::option::Option<std::string::String>,
        pub(crate) not_before: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) not_after: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) eligible_to_renew: std::option::Option<std::string::String>,
        pub(crate) renewal_summary: std::option::Option<crate::model::RenewalSummary>,
        pub(crate) revoked_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) revocation_reason: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) support_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the certificate.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the certificate.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The name of the certificate (e.g., <code>my-certificate</code>).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the certificate (e.g., <code>my-certificate</code>).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The domain name of the certificate.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name of the certificate.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The validation status of the certificate.</p>
        pub fn status(mut self, input: crate::model::CertificateStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The validation status of the certificate.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CertificateStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The serial number of the certificate.</p>
        pub fn serial_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.serial_number = Some(input.into());
            self
        }
        /// <p>The serial number of the certificate.</p>
        pub fn set_serial_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.serial_number = input;
            self
        }
        /// Appends an item to `subject_alternative_names`.
        ///
        /// To override the contents of this collection use [`set_subject_alternative_names`](Self::set_subject_alternative_names).
        ///
        /// <p>An array of strings that specify the alternate domains (e.g., <code>example2.com</code>)
        /// and subdomains (e.g., <code>blog.example.com</code>) of the certificate.</p>
        pub fn subject_alternative_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subject_alternative_names.unwrap_or_default();
            v.push(input.into());
            self.subject_alternative_names = Some(v);
            self
        }
        /// <p>An array of strings that specify the alternate domains (e.g., <code>example2.com</code>)
        /// and subdomains (e.g., <code>blog.example.com</code>) of the certificate.</p>
        pub fn set_subject_alternative_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subject_alternative_names = input;
            self
        }
        /// Appends an item to `domain_validation_records`.
        ///
        /// To override the contents of this collection use [`set_domain_validation_records`](Self::set_domain_validation_records).
        ///
        /// <p>An array of objects that describe the domain validation records of the certificate.</p>
        pub fn domain_validation_records(
            mut self,
            input: impl Into<crate::model::DomainValidationRecord>,
        ) -> Self {
            let mut v = self.domain_validation_records.unwrap_or_default();
            v.push(input.into());
            self.domain_validation_records = Some(v);
            self
        }
        /// <p>An array of objects that describe the domain validation records of the certificate.</p>
        pub fn set_domain_validation_records(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainValidationRecord>>,
        ) -> Self {
            self.domain_validation_records = input;
            self
        }
        /// <p>The validation failure reason, if any, of the certificate.</p>
        /// <p>The following failure reasons are possible:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NO_AVAILABLE_CONTACTS</code>
        /// </b> - This failure
        /// applies to email validation, which is not available for Lightsail certificates.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ADDITIONAL_VERIFICATION_REQUIRED</code>
        /// </b> -
        /// Lightsail requires additional information to process this certificate request. This can
        /// happen as a fraud-protection measure, such as when the domain ranks within the Alexa top
        /// 1000 websites. To provide the required information, use the <a href="https://console.aws.amazon.com/support/home">AWS Support Center</a> to contact
        /// AWS Support.</p>
        /// <note>
        /// <p>You cannot request a certificate for Amazon-owned domain names such as those ending
        /// in amazonaws.com, cloudfront.net, or elasticbeanstalk.com.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DOMAIN_NOT_ALLOWED</code>
        /// </b> - One or more of the
        /// domain names in the certificate request was reported as an unsafe domain by <a href="https://www.virustotal.com/gui/home/url">VirusTotal</a>. To correct the
        /// problem, search for your domain name on the <a href="https://www.virustotal.com/gui/home/url">VirusTotal</a> website. If your domain
        /// is reported as suspicious, see <a href="https://developers.google.com/web/fundamentals/security/hacked">Google Help for
        /// Hacked Websites</a> to learn what you can do.</p>
        /// <p>If you believe that the result is a false positive, notify the organization that is
        /// reporting the domain. VirusTotal is an aggregate of several antivirus and URL scanners and
        /// cannot remove your domain from a block list itself. After you correct the problem and the
        /// VirusTotal registry has been updated, request a new certificate.</p>
        /// <p>If you see this error and your domain is not included in the VirusTotal list, visit
        /// the <a href="https://console.aws.amazon.com/support/home">AWS Support Center</a>
        /// and create a case.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>INVALID_PUBLIC_DOMAIN</code>
        /// </b> - One or more of
        /// the domain names in the certificate request is not valid. Typically, this is because a
        /// domain name in the request is not a valid top-level domain. Try to request a certificate
        /// again, correcting any spelling errors or typos that were in the failed request, and ensure
        /// that all domain names in the request are for valid top-level domains. For example, you
        /// cannot request a certificate for <code>example.invalidpublicdomain</code> because
        /// <code>invalidpublicdomain</code> is not a valid top-level domain.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>OTHER</code>
        /// </b> - Typically, this failure occurs
        /// when there is a typographical error in one or more of the domain names in the certificate
        /// request. Try to request a certificate again, correcting any spelling errors or typos that
        /// were in the failed request. </p>
        /// </li>
        /// </ul>
        pub fn request_failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.request_failure_reason = Some(input.into());
            self
        }
        /// <p>The validation failure reason, if any, of the certificate.</p>
        /// <p>The following failure reasons are possible:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>NO_AVAILABLE_CONTACTS</code>
        /// </b> - This failure
        /// applies to email validation, which is not available for Lightsail certificates.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>ADDITIONAL_VERIFICATION_REQUIRED</code>
        /// </b> -
        /// Lightsail requires additional information to process this certificate request. This can
        /// happen as a fraud-protection measure, such as when the domain ranks within the Alexa top
        /// 1000 websites. To provide the required information, use the <a href="https://console.aws.amazon.com/support/home">AWS Support Center</a> to contact
        /// AWS Support.</p>
        /// <note>
        /// <p>You cannot request a certificate for Amazon-owned domain names such as those ending
        /// in amazonaws.com, cloudfront.net, or elasticbeanstalk.com.</p>
        /// </note>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>DOMAIN_NOT_ALLOWED</code>
        /// </b> - One or more of the
        /// domain names in the certificate request was reported as an unsafe domain by <a href="https://www.virustotal.com/gui/home/url">VirusTotal</a>. To correct the
        /// problem, search for your domain name on the <a href="https://www.virustotal.com/gui/home/url">VirusTotal</a> website. If your domain
        /// is reported as suspicious, see <a href="https://developers.google.com/web/fundamentals/security/hacked">Google Help for
        /// Hacked Websites</a> to learn what you can do.</p>
        /// <p>If you believe that the result is a false positive, notify the organization that is
        /// reporting the domain. VirusTotal is an aggregate of several antivirus and URL scanners and
        /// cannot remove your domain from a block list itself. After you correct the problem and the
        /// VirusTotal registry has been updated, request a new certificate.</p>
        /// <p>If you see this error and your domain is not included in the VirusTotal list, visit
        /// the <a href="https://console.aws.amazon.com/support/home">AWS Support Center</a>
        /// and create a case.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>INVALID_PUBLIC_DOMAIN</code>
        /// </b> - One or more of
        /// the domain names in the certificate request is not valid. Typically, this is because a
        /// domain name in the request is not a valid top-level domain. Try to request a certificate
        /// again, correcting any spelling errors or typos that were in the failed request, and ensure
        /// that all domain names in the request are for valid top-level domains. For example, you
        /// cannot request a certificate for <code>example.invalidpublicdomain</code> because
        /// <code>invalidpublicdomain</code> is not a valid top-level domain.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>OTHER</code>
        /// </b> - Typically, this failure occurs
        /// when there is a typographical error in one or more of the domain names in the certificate
        /// request. Try to request a certificate again, correcting any spelling errors or typos that
        /// were in the failed request. </p>
        /// </li>
        /// </ul>
        pub fn set_request_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.request_failure_reason = input;
            self
        }
        /// <p>The number of Lightsail resources that the certificate is attached to.</p>
        pub fn in_use_resource_count(mut self, input: i32) -> Self {
            self.in_use_resource_count = Some(input);
            self
        }
        /// <p>The number of Lightsail resources that the certificate is attached to.</p>
        pub fn set_in_use_resource_count(mut self, input: std::option::Option<i32>) -> Self {
            self.in_use_resource_count = input;
            self
        }
        /// <p>The algorithm used to generate the key pair (the public and private key) of the
        /// certificate.</p>
        pub fn key_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_algorithm = Some(input.into());
            self
        }
        /// <p>The algorithm used to generate the key pair (the public and private key) of the
        /// certificate.</p>
        pub fn set_key_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.key_algorithm = input;
            self
        }
        /// <p>The timestamp when the certificate was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when the certificate was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The timestamp when the certificate was issued.</p>
        pub fn issued_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.issued_at = Some(input);
            self
        }
        /// <p>The timestamp when the certificate was issued.</p>
        pub fn set_issued_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.issued_at = input;
            self
        }
        /// <p>The certificate authority that issued the certificate.</p>
        pub fn issuer_ca(mut self, input: impl Into<std::string::String>) -> Self {
            self.issuer_ca = Some(input.into());
            self
        }
        /// <p>The certificate authority that issued the certificate.</p>
        pub fn set_issuer_ca(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.issuer_ca = input;
            self
        }
        /// <p>The timestamp when the certificate is first valid.</p>
        pub fn not_before(mut self, input: aws_smithy_types::Instant) -> Self {
            self.not_before = Some(input);
            self
        }
        /// <p>The timestamp when the certificate is first valid.</p>
        pub fn set_not_before(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.not_before = input;
            self
        }
        /// <p>The timestamp when the certificate expires.</p>
        pub fn not_after(mut self, input: aws_smithy_types::Instant) -> Self {
            self.not_after = Some(input);
            self
        }
        /// <p>The timestamp when the certificate expires.</p>
        pub fn set_not_after(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.not_after = input;
            self
        }
        /// <p>The renewal eligibility of the certificate.</p>
        pub fn eligible_to_renew(mut self, input: impl Into<std::string::String>) -> Self {
            self.eligible_to_renew = Some(input.into());
            self
        }
        /// <p>The renewal eligibility of the certificate.</p>
        pub fn set_eligible_to_renew(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.eligible_to_renew = input;
            self
        }
        /// <p>An object that describes the status of the certificate renewal managed by
        /// Lightsail.</p>
        pub fn renewal_summary(mut self, input: crate::model::RenewalSummary) -> Self {
            self.renewal_summary = Some(input);
            self
        }
        /// <p>An object that describes the status of the certificate renewal managed by
        /// Lightsail.</p>
        pub fn set_renewal_summary(
            mut self,
            input: std::option::Option<crate::model::RenewalSummary>,
        ) -> Self {
            self.renewal_summary = input;
            self
        }
        /// <p>The timestamp when the certificate was revoked. This value is present only when the
        /// certificate status is <code>REVOKED</code>.</p>
        pub fn revoked_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.revoked_at = Some(input);
            self
        }
        /// <p>The timestamp when the certificate was revoked. This value is present only when the
        /// certificate status is <code>REVOKED</code>.</p>
        pub fn set_revoked_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.revoked_at = input;
            self
        }
        /// <p>The reason the certificate was revoked. This value is present only when the certificate
        /// status is <code>REVOKED</code>.</p>
        pub fn revocation_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.revocation_reason = Some(input.into());
            self
        }
        /// <p>The reason the certificate was revoked. This value is present only when the certificate
        /// status is <code>REVOKED</code>.</p>
        pub fn set_revocation_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.revocation_reason = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tag keys and optional values for the resource. For more information about tags in
        /// Lightsail, see the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer Guide</a>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// your Lightsail certificate. This code enables our support team to look up your Lightsail
        /// information more easily.</p>
        pub fn support_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.support_code = Some(input.into());
            self
        }
        /// <p>The support code. Include this code in your email to support when you have questions about
        /// your Lightsail certificate. This code enables our support team to look up your Lightsail
        /// information more easily.</p>
        pub fn set_support_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.support_code = input;
            self
        }
        /// Consumes the builder and constructs a [`Certificate`](crate::model::Certificate)
        pub fn build(self) -> crate::model::Certificate {
            crate::model::Certificate {
                arn: self.arn,
                name: self.name,
                domain_name: self.domain_name,
                status: self.status,
                serial_number: self.serial_number,
                subject_alternative_names: self.subject_alternative_names,
                domain_validation_records: self.domain_validation_records,
                request_failure_reason: self.request_failure_reason,
                in_use_resource_count: self.in_use_resource_count.unwrap_or_default(),
                key_algorithm: self.key_algorithm,
                created_at: self.created_at,
                issued_at: self.issued_at,
                issuer_ca: self.issuer_ca,
                not_before: self.not_before,
                not_after: self.not_after,
                eligible_to_renew: self.eligible_to_renew,
                renewal_summary: self.renewal_summary,
                revoked_at: self.revoked_at,
                revocation_reason: self.revocation_reason,
                tags: self.tags,
                support_code: self.support_code,
            }
        }
    }
}
impl Certificate {
    /// Creates a new builder-style object to manufacture [`Certificate`](crate::model::Certificate)
    pub fn builder() -> crate::model::certificate::Builder {
        crate::model::certificate::Builder::default()
    }
}

/// <p>Describes the status of a SSL/TLS certificate renewal managed by Amazon Lightsail.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RenewalSummary {
    /// <p>An array of objects that describe the domain validation records of the certificate.</p>
    pub domain_validation_records:
        std::option::Option<std::vec::Vec<crate::model::DomainValidationRecord>>,
    /// <p>The renewal status of the certificate.</p>
    /// <p>The following renewal status are possible:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>
    /// <code>PendingAutoRenewal</code>
    /// </b> - Lightsail is
    /// attempting to automatically validate the domain names of the certificate. No further
    /// action is required. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>PendingValidation</code>
    /// </b> - Lightsail couldn't
    /// automatically validate one or more domain names of the certificate. You must take action
    /// to validate these domain names or the certificate won't be renewed. Check to make sure
    /// your certificate's domain validation records exist in your domain's DNS, and that your
    /// certificate remains in use.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Success</code>
    /// </b> - All domain names in the
    /// certificate are validated, and Lightsail renewed the certificate. No further action is
    /// required. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>
    /// <code>Failed</code>
    /// </b> - One or more domain names were
    /// not validated before the certificate expired, and Lightsail did not renew the
    /// certificate. You can request a new certificate using the <code>CreateCertificate</code>
    /// action.</p>
    /// </li>
    /// </ul>
    pub renewal_status: std::option::Option<crate::model::RenewalStatus>,
    /// <p>The reason for the renewal status of the certificate.</p>
    pub renewal_status_reason: std::option::Option<std::string::String>,
    /// <p>The timestamp when the certificate was last updated.</p>
    pub updated_at: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for RenewalSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RenewalSummary");
        formatter.field("domain_validation_records", &self.domain_validation_records);
        formatter.field("renewal_status", &self.renewal_status);
        formatter.field("renewal_status_reason", &self.renewal_status_reason);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`RenewalSummary`](crate::model::RenewalSummary)
pub mod renewal_summary {
    /// A builder for [`RenewalSummary`](crate::model::RenewalSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_validation_records:
            std::option::Option<std::vec::Vec<crate::model::DomainValidationRecord>>,
        pub(crate) renewal_status: std::option::Option<crate::model::RenewalStatus>,
        pub(crate) renewal_status_reason: std::option::Option<std::string::String>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// Appends an item to `domain_validation_records`.
        ///
        /// To override the contents of this collection use [`set_domain_validation_records`](Self::set_domain_validation_records).
        ///
        /// <p>An array of objects that describe the domain validation records of the certificate.</p>
        pub fn domain_validation_records(
            mut self,
            input: impl Into<crate::model::DomainValidationRecord>,
        ) -> Self {
            let mut v = self.domain_validation_records.unwrap_or_default();
            v.push(input.into());
            self.domain_validation_records = Some(v);
            self
        }
        /// <p>An array of objects that describe the domain validation records of the certificate.</p>
        pub fn set_domain_validation_records(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainValidationRecord>>,
        ) -> Self {
            self.domain_validation_records = input;
            self
        }
        /// <p>The renewal status of the certificate.</p>
        /// <p>The following renewal status are possible:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PendingAutoRenewal</code>
        /// </b> - Lightsail is
        /// attempting to automatically validate the domain names of the certificate. No further
        /// action is required. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PendingValidation</code>
        /// </b> - Lightsail couldn't
        /// automatically validate one or more domain names of the certificate. You must take action
        /// to validate these domain names or the certificate won't be renewed. Check to make sure
        /// your certificate's domain validation records exist in your domain's DNS, and that your
        /// certificate remains in use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Success</code>
        /// </b> - All domain names in the
        /// certificate are validated, and Lightsail renewed the certificate. No further action is
        /// required. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Failed</code>
        /// </b> - One or more domain names were
        /// not validated before the certificate expired, and Lightsail did not renew the
        /// certificate. You can request a new certificate using the <code>CreateCertificate</code>
        /// action.</p>
        /// </li>
        /// </ul>
        pub fn renewal_status(mut self, input: crate::model::RenewalStatus) -> Self {
            self.renewal_status = Some(input);
            self
        }
        /// <p>The renewal status of the certificate.</p>
        /// <p>The following renewal status are possible:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PendingAutoRenewal</code>
        /// </b> - Lightsail is
        /// attempting to automatically validate the domain names of the certificate. No further
        /// action is required. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>PendingValidation</code>
        /// </b> - Lightsail couldn't
        /// automatically validate one or more domain names of the certificate. You must take action
        /// to validate these domain names or the certificate won't be renewed. Check to make sure
        /// your certificate's domain validation records exist in your domain's DNS, and that your
        /// certificate remains in use.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Success</code>
        /// </b> - All domain names in the
        /// certificate are validated, and Lightsail renewed the certificate. No further action is
        /// required. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>
        /// <code>Failed</code>
        /// </b> - One or more domain names were
        /// not validated before the certificate expired, and Lightsail did not renew the
        /// certificate. You can request a new certificate using the <code>CreateCertificate</code>
        /// action.</p>
        /// </li>
        /// </ul>
        pub fn set_renewal_status(
            mut self,
            input: std::option::Option<crate::model::RenewalStatus>,
        ) -> Self {
            self.renewal_status = input;
            self
        }
        /// <p>The reason for the renewal status of the certificate.</p>
        pub fn renewal_status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.renewal_status_reason = Some(input.into());
            self
        }
        /// <p>The reason for the renewal status of the certificate.</p>
        pub fn set_renewal_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.renewal_status_reason = input;
            self
        }
        /// <p>The timestamp when the certificate was last updated.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The timestamp when the certificate was last updated.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`RenewalSummary`](crate::model::RenewalSummary)
        pub fn build(self) -> crate::model::RenewalSummary {
            crate::model::RenewalSummary {
                domain_validation_records: self.domain_validation_records,
                renewal_status: self.renewal_status,
                renewal_status_reason: self.renewal_status_reason,
                updated_at: self.updated_at,
            }
        }
    }
}
impl RenewalSummary {
    /// Creates a new builder-style object to manufacture [`RenewalSummary`](crate::model::RenewalSummary)
    pub fn builder() -> crate::model::renewal_summary::Builder {
        crate::model::renewal_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RenewalStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    PendingAutoRenewal,
    #[allow(missing_docs)] // documentation missing in model
    PendingValidation,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RenewalStatus {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => RenewalStatus::Failed,
            "PendingAutoRenewal" => RenewalStatus::PendingAutoRenewal,
            "PendingValidation" => RenewalStatus::PendingValidation,
            "Success" => RenewalStatus::Success,
            other => RenewalStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RenewalStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RenewalStatus::from(s))
    }
}
impl RenewalStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RenewalStatus::Failed => "Failed",
            RenewalStatus::PendingAutoRenewal => "PendingAutoRenewal",
            RenewalStatus::PendingValidation => "PendingValidation",
            RenewalStatus::Success => "Success",
            RenewalStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Failed",
            "PendingAutoRenewal",
            "PendingValidation",
            "Success",
        ]
    }
}
impl AsRef<str> for RenewalStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the domain validation records of an Amazon Lightsail SSL/TLS certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainValidationRecord {
    /// <p>The domain name of the certificate validation record. For example,
    /// <code>example.com</code> or <code>www.example.com</code>.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>An object that describes the DNS records to add to your domain's DNS to validate it for
    /// the certificate.</p>
    pub resource_record: std::option::Option<crate::model::ResourceRecord>,
}
impl std::fmt::Debug for DomainValidationRecord {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainValidationRecord");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("resource_record", &self.resource_record);
        formatter.finish()
    }
}
/// See [`DomainValidationRecord`](crate::model::DomainValidationRecord)
pub mod domain_validation_record {
    /// A builder for [`DomainValidationRecord`](crate::model::DomainValidationRecord)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) resource_record: std::option::Option<crate::model::ResourceRecord>,
    }
    impl Builder {
        /// <p>The domain name of the certificate validation record. For example,
        /// <code>example.com</code> or <code>www.example.com</code>.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The domain name of the certificate validation record. For example,
        /// <code>example.com</code> or <code>www.example.com</code>.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>An object that describes the DNS records to add to your domain's DNS to validate it for
        /// the certificate.</p>
        pub fn resource_record(mut self, input: crate::model::ResourceRecord) -> Self {
            self.resource_record = Some(input);
            self
        }
        /// <p>An object that describes the DNS records to add to your domain's DNS to validate it for
        /// the certificate.</p>
        pub fn set_resource_record(
            mut self,
            input: std::option::Option<crate::model::ResourceRecord>,
        ) -> Self {
            self.resource_record = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainValidationRecord`](crate::model::DomainValidationRecord)
        pub fn build(self) -> crate::model::DomainValidationRecord {
            crate::model::DomainValidationRecord {
                domain_name: self.domain_name,
                resource_record: self.resource_record,
            }
        }
    }
}
impl DomainValidationRecord {
    /// Creates a new builder-style object to manufacture [`DomainValidationRecord`](crate::model::DomainValidationRecord)
    pub fn builder() -> crate::model::domain_validation_record::Builder {
        crate::model::domain_validation_record::Builder::default()
    }
}

/// <p>Describes the domain name system (DNS) records to add to your domain's DNS to validate it
/// for an Amazon Lightsail certificate.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceRecord {
    /// <p>The name of the record.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The DNS record type.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The value for the DNS record.</p>
    pub value: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceRecord {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceRecord");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ResourceRecord`](crate::model::ResourceRecord)
pub mod resource_record {
    /// A builder for [`ResourceRecord`](crate::model::ResourceRecord)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the record.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the record.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The DNS record type.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The DNS record type.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The value for the DNS record.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value for the DNS record.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceRecord`](crate::model::ResourceRecord)
        pub fn build(self) -> crate::model::ResourceRecord {
            crate::model::ResourceRecord {
                name: self.name,
                r#type: self.r#type,
                value: self.value,
            }
        }
    }
}
impl ResourceRecord {
    /// Creates a new builder-style object to manufacture [`ResourceRecord`](crate::model::ResourceRecord)
    pub fn builder() -> crate::model::resource_record::Builder {
        crate::model::resource_record::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CertificateStatus {
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    #[allow(missing_docs)] // documentation missing in model
    Issued,
    #[allow(missing_docs)] // documentation missing in model
    PendingValidation,
    #[allow(missing_docs)] // documentation missing in model
    Revoked,
    #[allow(missing_docs)] // documentation missing in model
    ValidationTimedOut,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CertificateStatus {
    fn from(s: &str) -> Self {
        match s {
            "EXPIRED" => CertificateStatus::Expired,
            "FAILED" => CertificateStatus::Failed,
            "INACTIVE" => CertificateStatus::Inactive,
            "ISSUED" => CertificateStatus::Issued,
            "PENDING_VALIDATION" => CertificateStatus::PendingValidation,
            "REVOKED" => CertificateStatus::Revoked,
            "VALIDATION_TIMED_OUT" => CertificateStatus::ValidationTimedOut,
            other => CertificateStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CertificateStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CertificateStatus::from(s))
    }
}
impl CertificateStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CertificateStatus::Expired => "EXPIRED",
            CertificateStatus::Failed => "FAILED",
            CertificateStatus::Inactive => "INACTIVE",
            CertificateStatus::Issued => "ISSUED",
            CertificateStatus::PendingValidation => "PENDING_VALIDATION",
            CertificateStatus::Revoked => "REVOKED",
            CertificateStatus::ValidationTimedOut => "VALIDATION_TIMED_OUT",
            CertificateStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EXPIRED",
            "FAILED",
            "INACTIVE",
            "ISSUED",
            "PENDING_VALIDATION",
            "REVOKED",
            "VALIDATION_TIMED_OUT",
        ]
    }
}
impl AsRef<str> for CertificateStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a bundle, which is a set of specs describing your virtual private server (or
/// <i>instance</i>).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Bundle {
    /// <p>The price in US dollars (e.g., <code>5.0</code>) of the bundle.</p>
    pub price: std::option::Option<f32>,
    /// <p>The number of vCPUs included in the bundle (e.g., <code>2</code>).</p>
    pub cpu_count: std::option::Option<i32>,
    /// <p>The size of the SSD (e.g., <code>30</code>).</p>
    pub disk_size_in_gb: std::option::Option<i32>,
    /// <p>The bundle ID (e.g., <code>micro_1_0</code>).</p>
    pub bundle_id: std::option::Option<std::string::String>,
    /// <p>The Amazon EC2 instance type (e.g., <code>t2.micro</code>).</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>A Boolean value indicating whether the bundle is active.</p>
    pub is_active: std::option::Option<bool>,
    /// <p>A friendly name for the bundle (e.g., <code>Micro</code>).</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A numeric value that represents the power of the bundle (e.g., <code>500</code>). You can
    /// use the bundle's power value in conjunction with a blueprint's minimum power value to
    /// determine whether the blueprint will run on the bundle. For example, you need a bundle with a
    /// power value of 500 or more to create an instance that uses a blueprint with a minimum power
    /// value of 500.</p>
    pub power: std::option::Option<i32>,
    /// <p>The amount of RAM in GB (e.g., <code>2.0</code>).</p>
    pub ram_size_in_gb: std::option::Option<f32>,
    /// <p>The data transfer rate per month in GB (e.g., <code>2000</code>).</p>
    pub transfer_per_month_in_gb: std::option::Option<i32>,
    /// <p>The operating system platform (Linux/Unix-based or Windows Server-based) that the bundle
    /// supports. You can only launch a <code>WINDOWS</code> bundle on a blueprint that supports the
    /// <code>WINDOWS</code> platform. <code>LINUX_UNIX</code> blueprints require a
    /// <code>LINUX_UNIX</code> bundle.</p>
    pub supported_platforms: std::option::Option<std::vec::Vec<crate::model::InstancePlatform>>,
}
impl std::fmt::Debug for Bundle {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Bundle");
        formatter.field("price", &self.price);
        formatter.field("cpu_count", &self.cpu_count);
        formatter.field("disk_size_in_gb", &self.disk_size_in_gb);
        formatter.field("bundle_id", &self.bundle_id);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("is_active", &self.is_active);
        formatter.field("name", &self.name);
        formatter.field("power", &self.power);
        formatter.field("ram_size_in_gb", &self.ram_size_in_gb);
        formatter.field("transfer_per_month_in_gb", &self.transfer_per_month_in_gb);
        formatter.field("supported_platforms", &self.supported_platforms);
        formatter.finish()
    }
}
/// See [`Bundle`](crate::model::Bundle)
pub mod bundle {
    /// A builder for [`Bundle`](crate::model::Bundle)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) price: std::option::Option<f32>,
        pub(crate) cpu_count: std::option::Option<i32>,
        pub(crate) disk_size_in_gb: std::option::Option<i32>,
        pub(crate) bundle_id: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) is_active: std::option::Option<bool>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) power: std::option::Option<i32>,
        pub(crate) ram_size_in_gb: std::option::Option<f32>,
        pub(crate) transfer_per_month_in_gb: std::option::Option<i32>,
        pub(crate) supported_platforms:
            std::option::Option<std::vec::Vec<crate::model::InstancePlatform>>,
    }
    impl Builder {
        /// <p>The price in US dollars (e.g., <code>5.0</code>) of the bundle.</p>
        pub fn price(mut self, input: f32) -> Self {
            self.price = Some(input);
            self
        }
        /// <p>The price in US dollars (e.g., <code>5.0</code>) of the bundle.</p>
        pub fn set_price(mut self, input: std::option::Option<f32>) -> Self {
            self.price = input;
            self
        }
        /// <p>The number of vCPUs included in the bundle (e.g., <code>2</code>).</p>
        pub fn cpu_count(mut self, input: i32) -> Self {
            self.cpu_count = Some(input);
            self
        }
        /// <p>The number of vCPUs included in the bundle (e.g., <code>2</code>).</p>
        pub fn set_cpu_count(mut self, input: std::option::Option<i32>) -> Self {
            self.cpu_count = input;
            self
        }
        /// <p>The size of the SSD (e.g., <code>30</code>).</p>
        pub fn disk_size_in_gb(mut self, input: i32) -> Self {
            self.disk_size_in_gb = Some(input);
            self
        }
        /// <p>The size of the SSD (e.g., <code>30</code>).</p>
        pub fn set_disk_size_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.disk_size_in_gb = input;
            self
        }
        /// <p>The bundle ID (e.g., <code>micro_1_0</code>).</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_id = Some(input.into());
            self
        }
        /// <p>The bundle ID (e.g., <code>micro_1_0</code>).</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_id = input;
            self
        }
        /// <p>The Amazon EC2 instance type (e.g., <code>t2.micro</code>).</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The Amazon EC2 instance type (e.g., <code>t2.micro</code>).</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>A Boolean value indicating whether the bundle is active.</p>
        pub fn is_active(mut self, input: bool) -> Self {
            self.is_active = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether the bundle is active.</p>
        pub fn set_is_active(mut self, input: std::option::Option<bool>) -> Self {
            self.is_active = input;
            self
        }
        /// <p>A friendly name for the bundle (e.g., <code>Micro</code>).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A friendly name for the bundle (e.g., <code>Micro</code>).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>A numeric value that represents the power of the bundle (e.g., <code>500</code>). You can
        /// use the bundle's power value in conjunction with a blueprint's minimum power value to
        /// determine whether the blueprint will run on the bundle. For example, you need a bundle with a
        /// power value of 500 or more to create an instance that uses a blueprint with a minimum power
        /// value of 500.</p>
        pub fn power(mut self, input: i32) -> Self {
            self.power = Some(input);
            self
        }
        /// <p>A numeric value that represents the power of the bundle (e.g., <code>500</code>). You can
        /// use the bundle's power value in conjunction with a blueprint's minimum power value to
        /// determine whether the blueprint will run on the bundle. For example, you need a bundle with a
        /// power value of 500 or more to create an instance that uses a blueprint with a minimum power
        /// value of 500.</p>
        pub fn set_power(mut self, input: std::option::Option<i32>) -> Self {
            self.power = input;
            self
        }
        /// <p>The amount of RAM in GB (e.g., <code>2.0</code>).</p>
        pub fn ram_size_in_gb(mut self, input: f32) -> Self {
            self.ram_size_in_gb = Some(input);
            self
        }
        /// <p>The amount of RAM in GB (e.g., <code>2.0</code>).</p>
        pub fn set_ram_size_in_gb(mut self, input: std::option::Option<f32>) -> Self {
            self.ram_size_in_gb = input;
            self
        }
        /// <p>The data transfer rate per month in GB (e.g., <code>2000</code>).</p>
        pub fn transfer_per_month_in_gb(mut self, input: i32) -> Self {
            self.transfer_per_month_in_gb = Some(input);
            self
        }
        /// <p>The data transfer rate per month in GB (e.g., <code>2000</code>).</p>
        pub fn set_transfer_per_month_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.transfer_per_month_in_gb = input;
            self
        }
        /// Appends an item to `supported_platforms`.
        ///
        /// To override the contents of this collection use [`set_supported_platforms`](Self::set_supported_platforms).
        ///
        /// <p>The operating system platform (Linux/Unix-based or Windows Server-based) that the bundle
        /// supports. You can only launch a <code>WINDOWS</code> bundle on a blueprint that supports the
        /// <code>WINDOWS</code> platform. <code>LINUX_UNIX</code> blueprints require a
        /// <code>LINUX_UNIX</code> bundle.</p>
        pub fn supported_platforms(
            mut self,
            input: impl Into<crate::model::InstancePlatform>,
        ) -> Self {
            let mut v = self.supported_platforms.unwrap_or_default();
            v.push(input.into());
            self.supported_platforms = Some(v);
            self
        }
        /// <p>The operating system platform (Linux/Unix-based or Windows Server-based) that the bundle
        /// supports. You can only launch a <code>WINDOWS</code> bundle on a blueprint that supports the
        /// <code>WINDOWS</code> platform. <code>LINUX_UNIX</code> blueprints require a
        /// <code>LINUX_UNIX</code> bundle.</p>
        pub fn set_supported_platforms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstancePlatform>>,
        ) -> Self {
            self.supported_platforms = input;
            self
        }
        /// Consumes the builder and constructs a [`Bundle`](crate::model::Bundle)
        pub fn build(self) -> crate::model::Bundle {
            crate::model::Bundle {
                price: self.price,
                cpu_count: self.cpu_count,
                disk_size_in_gb: self.disk_size_in_gb,
                bundle_id: self.bundle_id,
                instance_type: self.instance_type,
                is_active: self.is_active,
                name: self.name,
                power: self.power,
                ram_size_in_gb: self.ram_size_in_gb,
                transfer_per_month_in_gb: self.transfer_per_month_in_gb,
                supported_platforms: self.supported_platforms,
            }
        }
    }
}
impl Bundle {
    /// Creates a new builder-style object to manufacture [`Bundle`](crate::model::Bundle)
    pub fn builder() -> crate::model::bundle::Builder {
        crate::model::bundle::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InstancePlatform {
    #[allow(missing_docs)] // documentation missing in model
    LinuxUnix,
    #[allow(missing_docs)] // documentation missing in model
    Windows,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InstancePlatform {
    fn from(s: &str) -> Self {
        match s {
            "LINUX_UNIX" => InstancePlatform::LinuxUnix,
            "WINDOWS" => InstancePlatform::Windows,
            other => InstancePlatform::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InstancePlatform {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InstancePlatform::from(s))
    }
}
impl InstancePlatform {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InstancePlatform::LinuxUnix => "LINUX_UNIX",
            InstancePlatform::Windows => "WINDOWS",
            InstancePlatform::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LINUX_UNIX", "WINDOWS"]
    }
}
impl AsRef<str> for InstancePlatform {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BucketMetricName {
    #[allow(missing_docs)] // documentation missing in model
    BucketSizeBytes,
    #[allow(missing_docs)] // documentation missing in model
    NumberOfObjects,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BucketMetricName {
    fn from(s: &str) -> Self {
        match s {
            "BucketSizeBytes" => BucketMetricName::BucketSizeBytes,
            "NumberOfObjects" => BucketMetricName::NumberOfObjects,
            other => BucketMetricName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BucketMetricName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BucketMetricName::from(s))
    }
}
impl BucketMetricName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BucketMetricName::BucketSizeBytes => "BucketSizeBytes",
            BucketMetricName::NumberOfObjects => "NumberOfObjects",
            BucketMetricName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BucketSizeBytes", "NumberOfObjects"]
    }
}
impl AsRef<str> for BucketMetricName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes the specifications of a bundle that can be applied to an Amazon Lightsail
/// bucket.</p>
///
/// <p>A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a
/// bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BucketBundle {
    /// <p>The ID of the bundle.</p>
    pub bundle_id: std::option::Option<std::string::String>,
    /// <p>The name of the bundle.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The monthly price of the bundle, in US dollars.</p>
    pub price: std::option::Option<f32>,
    /// <p>The storage size of the bundle, in GB.</p>
    pub storage_per_month_in_gb: std::option::Option<i32>,
    /// <p>The monthly network transfer quota of the bundle.</p>
    pub transfer_per_month_in_gb: std::option::Option<i32>,
    /// <p>Indicates whether the bundle is active. Use for a new or existing bucket.</p>
    pub is_active: std::option::Option<bool>,
}
impl std::fmt::Debug for BucketBundle {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BucketBundle");
        formatter.field("bundle_id", &self.bundle_id);
        formatter.field("name", &self.name);
        formatter.field("price", &self.price);
        formatter.field("storage_per_month_in_gb", &self.storage_per_month_in_gb);
        formatter.field("transfer_per_month_in_gb", &self.transfer_per_month_in_gb);
        formatter.field("is_active", &self.is_active);
        formatter.finish()
    }
}
/// See [`BucketBundle`](crate::model::BucketBundle)
pub mod bucket_bundle {
    /// A builder for [`BucketBundle`](crate::model::BucketBundle)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bundle_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) price: std::option::Option<f32>,
        pub(crate) storage_per_month_in_gb: std::option::Option<i32>,
        pub(crate) transfer_per_month_in_gb: std::option::Option<i32>,
        pub(crate) is_active: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the bundle.</p>
        pub fn bundle_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.bundle_id = Some(input.into());
            self
        }
        /// <p>The ID of the bundle.</p>
        pub fn set_bundle_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bundle_id = input;
            self
        }
        /// <p>The name of the bundle.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the bundle.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The monthly price of the bundle, in US dollars.</p>
        pub fn price(mut self, input: f32) -> Self {
            self.price = Some(input);
            self
        }
        /// <p>The monthly price of the bundle, in US dollars.</p>
        pub fn set_price(mut self, input: std::option::Option<f32>) -> Self {
            self.price = input;
            self
        }
        /// <p>The storage size of the bundle, in GB.</p>
        pub fn storage_per_month_in_gb(mut self, input: i32) -> Self {
            self.storage_per_month_in_gb = Some(input);
            self
        }
        /// <p>The storage size of the bundle, in GB.</p>
        pub fn set_storage_per_month_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.storage_per_month_in_gb = input;
            self
        }
        /// <p>The monthly network transfer quota of the bundle.</p>
        pub fn transfer_per_month_in_gb(mut self, input: i32) -> Self {
            self.transfer_per_month_in_gb = Some(input);
            self
        }
        /// <p>The monthly network transfer quota of the bundle.</p>
        pub fn set_transfer_per_month_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.transfer_per_month_in_gb = input;
            self
        }
        /// <p>Indicates whether the bundle is active. Use for a new or existing bucket.</p>
        pub fn is_active(mut self, input: bool) -> Self {
            self.is_active = Some(input);
            self
        }
        /// <p>Indicates whether the bundle is active. Use for a new or existing bucket.</p>
        pub fn set_is_active(mut self, input: std::option::Option<bool>) -> Self {
            self.is_active = input;
            self
        }
        /// Consumes the builder and constructs a [`BucketBundle`](crate::model::BucketBundle)
        pub fn build(self) -> crate::model::BucketBundle {
            crate::model::BucketBundle {
                bundle_id: self.bundle_id,
                name: self.name,
                price: self.price,
                storage_per_month_in_gb: self.storage_per_month_in_gb,
                transfer_per_month_in_gb: self.transfer_per_month_in_gb,
                is_active: self.is_active,
            }
        }
    }
}
impl BucketBundle {
    /// Creates a new builder-style object to manufacture [`BucketBundle`](crate::model::BucketBundle)
    pub fn builder() -> crate::model::bucket_bundle::Builder {
        crate::model::bucket_bundle::Builder::default()
    }
}

/// <p>Describes an access key for an Amazon Lightsail bucket.</p>
///
/// <p>Access keys grant full programmatic access to the specified bucket and its objects. You
/// can have a maximum of two access keys per bucket. Use the <a>CreateBucketAccessKey</a> action to create an access key for a specific bucket. For
/// more information about access keys, see <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-bucket-access-keys">Creating access keys for a bucket in Amazon Lightsail</a> in the
/// <i>Amazon Lightsail Developer Guide</i>.</p>
///
/// <important>
/// <p>The <code>secretAccessKey</code> value is returned only in response to the
/// <code>CreateBucketAccessKey</code> action. You can get a secret access key only when you
/// first create an access key; you cannot get the secret access key later. If you lose the
/// secret access key, you must create a new access key.</p>
/// </important>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessKey {
    /// <p>The ID of the access key.</p>
    pub access_key_id: std::option::Option<std::string::String>,
    /// <p>The secret access key used to sign requests.</p>
    ///
    /// <p>You should store the secret access key in a safe location. We recommend that you delete
    /// the access key if the secret access key is compromised.</p>
    pub secret_access_key: std::option::Option<std::string::String>,
    /// <p>The status of the access key.</p>
    ///
    /// <p>A status of <code>Active</code> means that the key is valid, while <code>Inactive</code>
    /// means it is not.</p>
    pub status: std::option::Option<crate::model::StatusType>,
    /// <p>The timestamp when the access key was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>An object that describes the last time the access key was used.</p>
    ///
    /// <note>
    /// <p>This object does not include data in the response of a <a>CreateBucketAccessKey</a> action. If the access key has not been used, the
    /// <code>region</code> and <code>serviceName</code> values are <code>N/A</code>, and the
    /// <code>lastUsedDate</code> value is null.</p>
    /// </note>
    pub last_used: std::option::Option<crate::model::AccessKeyLastUsed>,
}
impl std::fmt::Debug for AccessKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessKey");
        formatter.field("access_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field("secret_access_key", &self.secret_access_key);
        formatter.field("status", &self.status);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_used", &self.last_used);
        formatter.finish()
    }
}
/// See [`AccessKey`](crate::model::AccessKey)
pub mod access_key {
    /// A builder for [`AccessKey`](crate::model::AccessKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_key_id: std::option::Option<std::string::String>,
        pub(crate) secret_access_key: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::StatusType>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_used: std::option::Option<crate::model::AccessKeyLastUsed>,
    }
    impl Builder {
        /// <p>The ID of the access key.</p>
        pub fn access_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_key_id = Some(input.into());
            self
        }
        /// <p>The ID of the access key.</p>
        pub fn set_access_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_key_id = input;
            self
        }
        /// <p>The secret access key used to sign requests.</p>
        ///
        /// <p>You should store the secret access key in a safe location. We recommend that you delete
        /// the access key if the secret access key is compromised.</p>
        pub fn secret_access_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_access_key = Some(input.into());
            self
        }
        /// <p>The secret access key used to sign requests.</p>
        ///
        /// <p>You should store the secret access key in a safe location. We recommend that you delete
        /// the access key if the secret access key is compromised.</p>
        pub fn set_secret_access_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secret_access_key = input;
            self
        }
        /// <p>The status of the access key.</p>
        ///
        /// <p>A status of <code>Active</code> means that the key is valid, while <code>Inactive</code>
        /// means it is not.</p>
        pub fn status(mut self, input: crate::model::StatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the access key.</p>
        ///
        /// <p>A status of <code>Active</code> means that the key is valid, while <code>Inactive</code>
        /// means it is not.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::StatusType>) -> Self {
            self.status = input;
            self
        }
        /// <p>The timestamp when the access key was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when the access key was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>An object that describes the last time the access key was used.</p>
        ///
        /// <note>
        /// <p>This object does not include data in the response of a <a>CreateBucketAccessKey</a> action. If the access key has not been used, the
        /// <code>region</code> and <code>serviceName</code> values are <code>N/A</code>, and the
        /// <code>lastUsedDate</code> value is null.</p>
        /// </note>
        pub fn last_used(mut self, input: crate::model::AccessKeyLastUsed) -> Self {
            self.last_used = Some(input);
            self
        }
        /// <p>An object that describes the last time the access key was used.</p>
        ///
        /// <note>
        /// <p>This object does not include data in the response of a <a>CreateBucketAccessKey</a> action. If the access key has not been used, the
        /// <code>region</code> and <code>serviceName</code> values are <code>N/A</code>, and the
        /// <code>lastUsedDate</code> value is null.</p>
        /// </note>
        pub fn set_last_used(
            mut self,
            input: std::option::Option<crate::model::AccessKeyLastUsed>,
        ) -> Self {
            self.last_used = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessKey`](crate::model::AccessKey)
        pub fn build(self) -> crate::model::AccessKey {
            crate::model::AccessKey {
                access_key_id: self.access_key_id,
                secret_access_key: self.secret_access_key,
                status: self.status,
                created_at: self.created_at,
                last_used: self.last_used,
            }
        }
    }
}
impl AccessKey {
    /// Creates a new builder-style object to manufacture [`AccessKey`](crate::model::AccessKey)
    pub fn builder() -> crate::model::access_key::Builder {
        crate::model::access_key::Builder::default()
    }
}

/// <p>Describes the last time an access key was used.</p>
///
/// <note>
/// <p>This object does not include data in the response of a <a>CreateBucketAccessKey</a> action.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessKeyLastUsed {
    /// <p>The date and time when the access key was most recently used.</p>
    /// <p>This value is null if the access key has not been used.</p>
    pub last_used_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The AWS Region where this access key was most recently used.</p>
    /// <p>This value is <code>N/A</code> if the access key has not been used.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The name of the AWS service with which this access key was most recently used.</p>
    /// <p>This value is <code>N/A</code> if the access key has not been used.</p>
    pub service_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessKeyLastUsed {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessKeyLastUsed");
        formatter.field("last_used_date", &self.last_used_date);
        formatter.field("region", &self.region);
        formatter.field("service_name", &self.service_name);
        formatter.finish()
    }
}
/// See [`AccessKeyLastUsed`](crate::model::AccessKeyLastUsed)
pub mod access_key_last_used {
    /// A builder for [`AccessKeyLastUsed`](crate::model::AccessKeyLastUsed)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) last_used_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The date and time when the access key was most recently used.</p>
        /// <p>This value is null if the access key has not been used.</p>
        pub fn last_used_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_used_date = Some(input);
            self
        }
        /// <p>The date and time when the access key was most recently used.</p>
        /// <p>This value is null if the access key has not been used.</p>
        pub fn set_last_used_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_used_date = input;
            self
        }
        /// <p>The AWS Region where this access key was most recently used.</p>
        /// <p>This value is <code>N/A</code> if the access key has not been used.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The AWS Region where this access key was most recently used.</p>
        /// <p>This value is <code>N/A</code> if the access key has not been used.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The name of the AWS service with which this access key was most recently used.</p>
        /// <p>This value is <code>N/A</code> if the access key has not been used.</p>
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// <p>The name of the AWS service with which this access key was most recently used.</p>
        /// <p>This value is <code>N/A</code> if the access key has not been used.</p>
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessKeyLastUsed`](crate::model::AccessKeyLastUsed)
        pub fn build(self) -> crate::model::AccessKeyLastUsed {
            crate::model::AccessKeyLastUsed {
                last_used_date: self.last_used_date,
                region: self.region,
                service_name: self.service_name,
            }
        }
    }
}
impl AccessKeyLastUsed {
    /// Creates a new builder-style object to manufacture [`AccessKeyLastUsed`](crate::model::AccessKeyLastUsed)
    pub fn builder() -> crate::model::access_key_last_used::Builder {
        crate::model::access_key_last_used::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StatusType {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StatusType {
    fn from(s: &str) -> Self {
        match s {
            "Active" => StatusType::Active,
            "Inactive" => StatusType::Inactive,
            other => StatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StatusType::from(s))
    }
}
impl StatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StatusType::Active => "Active",
            StatusType::Inactive => "Inactive",
            StatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Active", "Inactive"]
    }
}
impl AsRef<str> for StatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a blueprint (a virtual private server image).</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Blueprint {
    /// <p>The ID for the virtual private server image (e.g., <code>app_wordpress_4_4</code> or
    /// <code>app_lamp_7_0</code>).</p>
    pub blueprint_id: std::option::Option<std::string::String>,
    /// <p>The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The group name of the blueprint (e.g., <code>amazon-linux</code>).</p>
    pub group: std::option::Option<std::string::String>,
    /// <p>The type of the blueprint (e.g., <code>os</code> or <code>app</code>).</p>
    pub r#type: std::option::Option<crate::model::BlueprintType>,
    /// <p>The description of the blueprint.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A Boolean value indicating whether the blueprint is active. Inactive blueprints are listed
    /// to support customers with existing instances but are not necessarily available for launch of
    /// new instances. Blueprints are marked inactive when they become outdated due to operating
    /// system updates or new application releases.</p>
    pub is_active: std::option::Option<bool>,
    /// <p>The minimum bundle power required to run this blueprint. For example, you need a bundle
    /// with a power value of 500 or more to create an instance that uses a blueprint with a minimum
    /// power value of 500. <code>0</code> indicates that the blueprint runs on all instance sizes.
    /// </p>
    pub min_power: std::option::Option<i32>,
    /// <p>The version number of the operating system, application, or stack (e.g.,
    /// <code>2016.03.0</code>).</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>The version code.</p>
    pub version_code: std::option::Option<std::string::String>,
    /// <p>The product URL to learn more about the image or blueprint.</p>
    pub product_url: std::option::Option<std::string::String>,
    /// <p>The end-user license agreement URL for the image or blueprint.</p>
    pub license_url: std::option::Option<std::string::String>,
    /// <p>The operating system platform (either Linux/Unix-based or Windows Server-based) of the
    /// blueprint.</p>
    pub platform: std::option::Option<crate::model::InstancePlatform>,
}
impl std::fmt::Debug for Blueprint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Blueprint");
        formatter.field("blueprint_id", &self.blueprint_id);
        formatter.field("name", &self.name);
        formatter.field("group", &self.group);
        formatter.field("r#type", &self.r#type);
        formatter.field("description", &self.description);
        formatter.field("is_active", &self.is_active);
        formatter.field("min_power", &self.min_power);
        formatter.field("version", &self.version);
        formatter.field("version_code", &self.version_code);
        formatter.field("product_url", &self.product_url);
        formatter.field("license_url", &self.license_url);
        formatter.field("platform", &self.platform);
        formatter.finish()
    }
}
/// See [`Blueprint`](crate::model::Blueprint)
pub mod blueprint {
    /// A builder for [`Blueprint`](crate::model::Blueprint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) blueprint_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) group: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::BlueprintType>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) is_active: std::option::Option<bool>,
        pub(crate) min_power: std::option::Option<i32>,
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) version_code: std::option::Option<std::string::String>,
        pub(crate) product_url: std::option::Option<std::string::String>,
        pub(crate) license_url: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<crate::model::InstancePlatform>,
    }
    impl Builder {
        /// <p>The ID for the virtual private server image (e.g., <code>app_wordpress_4_4</code> or
        /// <code>app_lamp_7_0</code>).</p>
        pub fn blueprint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.blueprint_id = Some(input.into());
            self
        }
        /// <p>The ID for the virtual private server image (e.g., <code>app_wordpress_4_4</code> or
        /// <code>app_lamp_7_0</code>).</p>
        pub fn set_blueprint_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.blueprint_id = input;
            self
        }
        /// <p>The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The group name of the blueprint (e.g., <code>amazon-linux</code>).</p>
        pub fn group(mut self, input: impl Into<std::string::String>) -> Self {
            self.group = Some(input.into());
            self
        }
        /// <p>The group name of the blueprint (e.g., <code>amazon-linux</code>).</p>
        pub fn set_group(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group = input;
            self
        }
        /// <p>The type of the blueprint (e.g., <code>os</code> or <code>app</code>).</p>
        pub fn r#type(mut self, input: crate::model::BlueprintType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the blueprint (e.g., <code>os</code> or <code>app</code>).</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::BlueprintType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The description of the blueprint.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the blueprint.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A Boolean value indicating whether the blueprint is active. Inactive blueprints are listed
        /// to support customers with existing instances but are not necessarily available for launch of
        /// new instances. Blueprints are marked inactive when they become outdated due to operating
        /// system updates or new application releases.</p>
        pub fn is_active(mut self, input: bool) -> Self {
            self.is_active = Some(input);
            self
        }
        /// <p>A Boolean value indicating whether the blueprint is active. Inactive blueprints are listed
        /// to support customers with existing instances but are not necessarily available for launch of
        /// new instances. Blueprints are marked inactive when they become outdated due to operating
        /// system updates or new application releases.</p>
        pub fn set_is_active(mut self, input: std::option::Option<bool>) -> Self {
            self.is_active = input;
            self
        }
        /// <p>The minimum bundle power required to run this blueprint. For example, you need a bundle
        /// with a power value of 500 or more to create an instance that uses a blueprint with a minimum
        /// power value of 500. <code>0</code> indicates that the blueprint runs on all instance sizes.
        /// </p>
        pub fn min_power(mut self, input: i32) -> Self {
            self.min_power = Some(input);
            self
        }
        /// <p>The minimum bundle power required to run this blueprint. For example, you need a bundle
        /// with a power value of 500 or more to create an instance that uses a blueprint with a minimum
        /// power value of 500. <code>0</code> indicates that the blueprint runs on all instance sizes.
        /// </p>
        pub fn set_min_power(mut self, input: std::option::Option<i32>) -> Self {
            self.min_power = input;
            self
        }
        /// <p>The version number of the operating system, application, or stack (e.g.,
        /// <code>2016.03.0</code>).</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version number of the operating system, application, or stack (e.g.,
        /// <code>2016.03.0</code>).</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>The version code.</p>
        pub fn version_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_code = Some(input.into());
            self
        }
        /// <p>The version code.</p>
        pub fn set_version_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_code = input;
            self
        }
        /// <p>The product URL to learn more about the image or blueprint.</p>
        pub fn product_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_url = Some(input.into());
            self
        }
        /// <p>The product URL to learn more about the image or blueprint.</p>
        pub fn set_product_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_url = input;
            self
        }
        /// <p>The end-user license agreement URL for the image or blueprint.</p>
        pub fn license_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_url = Some(input.into());
            self
        }
        /// <p>The end-user license agreement URL for the image or blueprint.</p>
        pub fn set_license_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_url = input;
            self
        }
        /// <p>The operating system platform (either Linux/Unix-based or Windows Server-based) of the
        /// blueprint.</p>
        pub fn platform(mut self, input: crate::model::InstancePlatform) -> Self {
            self.platform = Some(input);
            self
        }
        /// <p>The operating system platform (either Linux/Unix-based or Windows Server-based) of the
        /// blueprint.</p>
        pub fn set_platform(
            mut self,
            input: std::option::Option<crate::model::InstancePlatform>,
        ) -> Self {
            self.platform = input;
            self
        }
        /// Consumes the builder and constructs a [`Blueprint`](crate::model::Blueprint)
        pub fn build(self) -> crate::model::Blueprint {
            crate::model::Blueprint {
                blueprint_id: self.blueprint_id,
                name: self.name,
                group: self.group,
                r#type: self.r#type,
                description: self.description,
                is_active: self.is_active,
                min_power: self.min_power,
                version: self.version,
                version_code: self.version_code,
                product_url: self.product_url,
                license_url: self.license_url,
                platform: self.platform,
            }
        }
    }
}
impl Blueprint {
    /// Creates a new builder-style object to manufacture [`Blueprint`](crate::model::Blueprint)
    pub fn builder() -> crate::model::blueprint::Builder {
        crate::model::blueprint::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BlueprintType {
    #[allow(missing_docs)] // documentation missing in model
    App,
    #[allow(missing_docs)] // documentation missing in model
    Os,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BlueprintType {
    fn from(s: &str) -> Self {
        match s {
            "app" => BlueprintType::App,
            "os" => BlueprintType::Os,
            other => BlueprintType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BlueprintType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BlueprintType::from(s))
    }
}
impl BlueprintType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BlueprintType::App => "app",
            BlueprintType::Os => "os",
            BlueprintType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["app", "os"]
    }
}
impl AsRef<str> for BlueprintType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an automatic snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutoSnapshotDetails {
    /// <p>The date of the automatic snapshot in <code>YYYY-MM-DD</code> format.</p>
    pub date: std::option::Option<std::string::String>,
    /// <p>The timestamp when the automatic snapshot was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The status of the automatic snapshot.</p>
    pub status: std::option::Option<crate::model::AutoSnapshotStatus>,
    /// <p>An array of objects that describe the block storage disks attached to the instance when
    /// the automatic snapshot was created.</p>
    pub from_attached_disks: std::option::Option<std::vec::Vec<crate::model::AttachedDisk>>,
}
impl std::fmt::Debug for AutoSnapshotDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutoSnapshotDetails");
        formatter.field("date", &self.date);
        formatter.field("created_at", &self.created_at);
        formatter.field("status", &self.status);
        formatter.field("from_attached_disks", &self.from_attached_disks);
        formatter.finish()
    }
}
/// See [`AutoSnapshotDetails`](crate::model::AutoSnapshotDetails)
pub mod auto_snapshot_details {
    /// A builder for [`AutoSnapshotDetails`](crate::model::AutoSnapshotDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) date: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::AutoSnapshotStatus>,
        pub(crate) from_attached_disks:
            std::option::Option<std::vec::Vec<crate::model::AttachedDisk>>,
    }
    impl Builder {
        /// <p>The date of the automatic snapshot in <code>YYYY-MM-DD</code> format.</p>
        pub fn date(mut self, input: impl Into<std::string::String>) -> Self {
            self.date = Some(input.into());
            self
        }
        /// <p>The date of the automatic snapshot in <code>YYYY-MM-DD</code> format.</p>
        pub fn set_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date = input;
            self
        }
        /// <p>The timestamp when the automatic snapshot was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp when the automatic snapshot was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The status of the automatic snapshot.</p>
        pub fn status(mut self, input: crate::model::AutoSnapshotStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the automatic snapshot.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AutoSnapshotStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `from_attached_disks`.
        ///
        /// To override the contents of this collection use [`set_from_attached_disks`](Self::set_from_attached_disks).
        ///
        /// <p>An array of objects that describe the block storage disks attached to the instance when
        /// the automatic snapshot was created.</p>
        pub fn from_attached_disks(mut self, input: impl Into<crate::model::AttachedDisk>) -> Self {
            let mut v = self.from_attached_disks.unwrap_or_default();
            v.push(input.into());
            self.from_attached_disks = Some(v);
            self
        }
        /// <p>An array of objects that describe the block storage disks attached to the instance when
        /// the automatic snapshot was created.</p>
        pub fn set_from_attached_disks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttachedDisk>>,
        ) -> Self {
            self.from_attached_disks = input;
            self
        }
        /// Consumes the builder and constructs a [`AutoSnapshotDetails`](crate::model::AutoSnapshotDetails)
        pub fn build(self) -> crate::model::AutoSnapshotDetails {
            crate::model::AutoSnapshotDetails {
                date: self.date,
                created_at: self.created_at,
                status: self.status,
                from_attached_disks: self.from_attached_disks,
            }
        }
    }
}
impl AutoSnapshotDetails {
    /// Creates a new builder-style object to manufacture [`AutoSnapshotDetails`](crate::model::AutoSnapshotDetails)
    pub fn builder() -> crate::model::auto_snapshot_details::Builder {
        crate::model::auto_snapshot_details::Builder::default()
    }
}

/// <p>Describes a block storage disk that is attached to an instance, and is included in an
/// automatic snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttachedDisk {
    /// <p>The path of the disk (e.g., <code>/dev/xvdf</code>).</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>The size of the disk in GB.</p>
    pub size_in_gb: std::option::Option<i32>,
}
impl std::fmt::Debug for AttachedDisk {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttachedDisk");
        formatter.field("path", &self.path);
        formatter.field("size_in_gb", &self.size_in_gb);
        formatter.finish()
    }
}
/// See [`AttachedDisk`](crate::model::AttachedDisk)
pub mod attached_disk {
    /// A builder for [`AttachedDisk`](crate::model::AttachedDisk)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) size_in_gb: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The path of the disk (e.g., <code>/dev/xvdf</code>).</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path of the disk (e.g., <code>/dev/xvdf</code>).</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>The size of the disk in GB.</p>
        pub fn size_in_gb(mut self, input: i32) -> Self {
            self.size_in_gb = Some(input);
            self
        }
        /// <p>The size of the disk in GB.</p>
        pub fn set_size_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.size_in_gb = input;
            self
        }
        /// Consumes the builder and constructs a [`AttachedDisk`](crate::model::AttachedDisk)
        pub fn build(self) -> crate::model::AttachedDisk {
            crate::model::AttachedDisk {
                path: self.path,
                size_in_gb: self.size_in_gb,
            }
        }
    }
}
impl AttachedDisk {
    /// Creates a new builder-style object to manufacture [`AttachedDisk`](crate::model::AttachedDisk)
    pub fn builder() -> crate::model::attached_disk::Builder {
        crate::model::attached_disk::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AutoSnapshotStatus {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    NotFound,
    #[allow(missing_docs)] // documentation missing in model
    Success,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AutoSnapshotStatus {
    fn from(s: &str) -> Self {
        match s {
            "Failed" => AutoSnapshotStatus::Failed,
            "InProgress" => AutoSnapshotStatus::InProgress,
            "NotFound" => AutoSnapshotStatus::NotFound,
            "Success" => AutoSnapshotStatus::Success,
            other => AutoSnapshotStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AutoSnapshotStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AutoSnapshotStatus::from(s))
    }
}
impl AutoSnapshotStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AutoSnapshotStatus::Failed => "Failed",
            AutoSnapshotStatus::InProgress => "InProgress",
            AutoSnapshotStatus::NotFound => "NotFound",
            AutoSnapshotStatus::Success => "Success",
            AutoSnapshotStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Failed", "InProgress", "NotFound", "Success"]
    }
}
impl AsRef<str> for AutoSnapshotStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes an alarm.</p>
/// <p>An alarm is a way to monitor your Lightsail resource metrics. For more information, see
/// <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms">Alarms in Amazon Lightsail</a>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Alarm {
    /// <p>The name of the alarm.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the alarm.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The timestamp when the alarm was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>An object that lists information about the location of the alarm.</p>
    pub location: std::option::Option<crate::model::ResourceLocation>,
    /// <p>The Lightsail resource type (e.g., <code>Alarm</code>).</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The support code. Include this code in your email to support when you have questions about
    /// your Lightsail alarm. This code enables our support team to look up your Lightsail
    /// information more easily.</p>
    pub support_code: std::option::Option<std::string::String>,
    /// <p>An object that lists information about the resource monitored by the alarm.</p>
    pub monitored_resource_info: std::option::Option<crate::model::MonitoredResourceInfo>,
    /// <p>The arithmetic operation used when comparing the specified statistic and threshold.</p>
    pub comparison_operator: std::option::Option<crate::model::ComparisonOperator>,
    /// <p>The number of periods over which data is compared to the specified threshold.</p>
    pub evaluation_periods: std::option::Option<i32>,
    /// <p>The period, in seconds, over which the statistic is applied.</p>
    pub period: i32,
    /// <p>The value against which the specified statistic is compared.</p>
    pub threshold: std::option::Option<f64>,
    /// <p>The number of data points that must not within the specified threshold to trigger the
    /// alarm.</p>
    pub datapoints_to_alarm: std::option::Option<i32>,
    /// <p>Specifies how the alarm handles missing data points.</p>
    /// <p>An alarm can treat missing data in the following ways:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>breaching</code> - Assume the missing data is not within the threshold. Missing
    /// data counts towards the number of times the metric is not within the threshold.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>notBreaching</code> - Assume the missing data is within the threshold. Missing
    /// data does not count towards the number of times the metric is not within the
    /// threshold.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ignore</code> - Ignore the missing data. Maintains the current alarm
    /// state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>missing</code> - Missing data is treated as missing.</p>
    /// </li>
    /// </ul>
    pub treat_missing_data: std::option::Option<crate::model::TreatMissingData>,
    /// <p>The statistic for the metric associated with the alarm.</p>
    /// <p>The following statistics are available:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Minimum</code> - The lowest value observed during the specified period. Use this
    /// value to determine low volumes of activity for your application.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Maximum</code> - The highest value observed during the specified period. Use
    /// this value to determine high volumes of activity for your application.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Sum</code> - All values submitted for the matching metric added together. You
    /// can use this statistic to determine the total volume of a metric.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Average</code> - The value of Sum / SampleCount during the specified period. By
    /// comparing this statistic with the Minimum and Maximum values, you can determine the full
    /// scope of a metric and how close the average use is to the Minimum and Maximum values. This
    /// comparison helps you to know when to increase or decrease your resources.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>SampleCount</code> - The count, or number, of data points used for the
    /// statistical calculation.</p>
    /// </li>
    /// </ul>
    pub statistic: std::option::Option<crate::model::MetricStatistic>,
    /// <p>The name of the metric associated with the alarm.</p>
    pub metric_name: std::option::Option<crate::model::MetricName>,
    /// <p>The current state of the alarm.</p>
    /// <p>An alarm has the following possible states:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ALARM</code> - The metric is outside of the defined threshold.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INSUFFICIENT_DATA</code> - The alarm has just started, the metric is not
    /// available, or not enough data is available for the metric to determine the alarm
    /// state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>OK</code> - The metric is within the defined threshold.</p>
    /// </li>
    /// </ul>
    pub state: std::option::Option<crate::model::AlarmState>,
    /// <p>The unit of the metric associated with the alarm.</p>
    pub unit: std::option::Option<crate::model::MetricUnit>,
    /// <p>The contact protocols for the alarm, such as <code>Email</code>, <code>SMS</code> (text
    /// messaging), or both.</p>
    pub contact_protocols: std::option::Option<std::vec::Vec<crate::model::ContactProtocol>>,
    /// <p>The alarm states that trigger a notification.</p>
    pub notification_triggers: std::option::Option<std::vec::Vec<crate::model::AlarmState>>,
    /// <p>Indicates whether the alarm is enabled.</p>
    pub notification_enabled: std::option::Option<bool>,
}
impl std::fmt::Debug for Alarm {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Alarm");
        formatter.field("name", &self.name);
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("location", &self.location);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("support_code", &self.support_code);
        formatter.field("monitored_resource_info", &self.monitored_resource_info);
        formatter.field("comparison_operator", &self.comparison_operator);
        formatter.field("evaluation_periods", &self.evaluation_periods);
        formatter.field("period", &self.period);
        formatter.field("threshold", &self.threshold);
        formatter.field("datapoints_to_alarm", &self.datapoints_to_alarm);
        formatter.field("treat_missing_data", &self.treat_missing_dat