// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AllocateStaticIp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AllocateStaticIpError {
    /// Kind of error that occurred.
    pub kind: AllocateStaticIpErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AllocateStaticIp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AllocateStaticIpErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AllocateStaticIpError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AllocateStaticIpErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AllocateStaticIpErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            AllocateStaticIpErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            AllocateStaticIpErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            AllocateStaticIpErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            AllocateStaticIpErrorKind::ServiceException(_inner) => _inner.fmt(f),
            AllocateStaticIpErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            AllocateStaticIpErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AllocateStaticIpError {
    fn code(&self) -> Option<&str> {
        AllocateStaticIpError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AllocateStaticIpError {
    /// Creates a new `AllocateStaticIpError`.
    pub fn new(kind: AllocateStaticIpErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AllocateStaticIpError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AllocateStaticIpErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AllocateStaticIpError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AllocateStaticIpErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AllocateStaticIpErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllocateStaticIpErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AllocateStaticIpErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllocateStaticIpErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `AllocateStaticIpErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllocateStaticIpErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `AllocateStaticIpErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, AllocateStaticIpErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `AllocateStaticIpErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllocateStaticIpErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `AllocateStaticIpErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, AllocateStaticIpErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `AllocateStaticIpErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            AllocateStaticIpErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for AllocateStaticIpError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AllocateStaticIpErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AllocateStaticIpErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            AllocateStaticIpErrorKind::InvalidInputException(_inner) => Some(_inner),
            AllocateStaticIpErrorKind::NotFoundException(_inner) => Some(_inner),
            AllocateStaticIpErrorKind::OperationFailureException(_inner) => Some(_inner),
            AllocateStaticIpErrorKind::ServiceException(_inner) => Some(_inner),
            AllocateStaticIpErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            AllocateStaticIpErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AttachCertificateToDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AttachCertificateToDistributionError {
    /// Kind of error that occurred.
    pub kind: AttachCertificateToDistributionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AttachCertificateToDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AttachCertificateToDistributionErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AttachCertificateToDistributionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AttachCertificateToDistributionErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            AttachCertificateToDistributionErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            AttachCertificateToDistributionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            AttachCertificateToDistributionErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            AttachCertificateToDistributionErrorKind::ServiceException(_inner) => _inner.fmt(f),
            AttachCertificateToDistributionErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            AttachCertificateToDistributionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AttachCertificateToDistributionError {
    fn code(&self) -> Option<&str> {
        AttachCertificateToDistributionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AttachCertificateToDistributionError {
    /// Creates a new `AttachCertificateToDistributionError`.
    pub fn new(
        kind: AttachCertificateToDistributionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AttachCertificateToDistributionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AttachCertificateToDistributionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AttachCertificateToDistributionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AttachCertificateToDistributionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AttachCertificateToDistributionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachCertificateToDistributionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachCertificateToDistributionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachCertificateToDistributionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachCertificateToDistributionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachCertificateToDistributionErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachCertificateToDistributionErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachCertificateToDistributionErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachCertificateToDistributionErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachCertificateToDistributionErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachCertificateToDistributionErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachCertificateToDistributionErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for AttachCertificateToDistributionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AttachCertificateToDistributionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AttachCertificateToDistributionErrorKind::InvalidInputException(_inner) => Some(_inner),
            AttachCertificateToDistributionErrorKind::NotFoundException(_inner) => Some(_inner),
            AttachCertificateToDistributionErrorKind::OperationFailureException(_inner) => {
                Some(_inner)
            }
            AttachCertificateToDistributionErrorKind::ServiceException(_inner) => Some(_inner),
            AttachCertificateToDistributionErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            AttachCertificateToDistributionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AttachDisk` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AttachDiskError {
    /// Kind of error that occurred.
    pub kind: AttachDiskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AttachDisk` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AttachDiskErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AttachDiskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AttachDiskErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AttachDiskErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            AttachDiskErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            AttachDiskErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            AttachDiskErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            AttachDiskErrorKind::ServiceException(_inner) => _inner.fmt(f),
            AttachDiskErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            AttachDiskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AttachDiskError {
    fn code(&self) -> Option<&str> {
        AttachDiskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AttachDiskError {
    /// Creates a new `AttachDiskError`.
    pub fn new(kind: AttachDiskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AttachDiskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AttachDiskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AttachDiskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AttachDiskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AttachDiskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, AttachDiskErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `AttachDiskErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachDiskErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachDiskErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, AttachDiskErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `AttachDiskErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, AttachDiskErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `AttachDiskErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachDiskErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachDiskErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, AttachDiskErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `AttachDiskErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(&self.kind, AttachDiskErrorKind::UnauthenticatedException(_))
    }
}
impl std::error::Error for AttachDiskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AttachDiskErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AttachDiskErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            AttachDiskErrorKind::InvalidInputException(_inner) => Some(_inner),
            AttachDiskErrorKind::NotFoundException(_inner) => Some(_inner),
            AttachDiskErrorKind::OperationFailureException(_inner) => Some(_inner),
            AttachDiskErrorKind::ServiceException(_inner) => Some(_inner),
            AttachDiskErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            AttachDiskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AttachInstancesToLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AttachInstancesToLoadBalancerError {
    /// Kind of error that occurred.
    pub kind: AttachInstancesToLoadBalancerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AttachInstancesToLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AttachInstancesToLoadBalancerErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AttachInstancesToLoadBalancerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AttachInstancesToLoadBalancerErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AttachInstancesToLoadBalancerErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            AttachInstancesToLoadBalancerErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            AttachInstancesToLoadBalancerErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            AttachInstancesToLoadBalancerErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            AttachInstancesToLoadBalancerErrorKind::ServiceException(_inner) => _inner.fmt(f),
            AttachInstancesToLoadBalancerErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            AttachInstancesToLoadBalancerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AttachInstancesToLoadBalancerError {
    fn code(&self) -> Option<&str> {
        AttachInstancesToLoadBalancerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AttachInstancesToLoadBalancerError {
    /// Creates a new `AttachInstancesToLoadBalancerError`.
    pub fn new(
        kind: AttachInstancesToLoadBalancerErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AttachInstancesToLoadBalancerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AttachInstancesToLoadBalancerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AttachInstancesToLoadBalancerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AttachInstancesToLoadBalancerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AttachInstancesToLoadBalancerErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachInstancesToLoadBalancerErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachInstancesToLoadBalancerErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachInstancesToLoadBalancerErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachInstancesToLoadBalancerErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachInstancesToLoadBalancerErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachInstancesToLoadBalancerErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachInstancesToLoadBalancerErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachInstancesToLoadBalancerErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachInstancesToLoadBalancerErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachInstancesToLoadBalancerErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachInstancesToLoadBalancerErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachInstancesToLoadBalancerErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachInstancesToLoadBalancerErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for AttachInstancesToLoadBalancerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AttachInstancesToLoadBalancerErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AttachInstancesToLoadBalancerErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            AttachInstancesToLoadBalancerErrorKind::InvalidInputException(_inner) => Some(_inner),
            AttachInstancesToLoadBalancerErrorKind::NotFoundException(_inner) => Some(_inner),
            AttachInstancesToLoadBalancerErrorKind::OperationFailureException(_inner) => {
                Some(_inner)
            }
            AttachInstancesToLoadBalancerErrorKind::ServiceException(_inner) => Some(_inner),
            AttachInstancesToLoadBalancerErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            AttachInstancesToLoadBalancerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AttachLoadBalancerTlsCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AttachLoadBalancerTlsCertificateError {
    /// Kind of error that occurred.
    pub kind: AttachLoadBalancerTlsCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AttachLoadBalancerTlsCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AttachLoadBalancerTlsCertificateErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AttachLoadBalancerTlsCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AttachLoadBalancerTlsCertificateErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            AttachLoadBalancerTlsCertificateErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            AttachLoadBalancerTlsCertificateErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            AttachLoadBalancerTlsCertificateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            AttachLoadBalancerTlsCertificateErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            AttachLoadBalancerTlsCertificateErrorKind::ServiceException(_inner) => _inner.fmt(f),
            AttachLoadBalancerTlsCertificateErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            AttachLoadBalancerTlsCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AttachLoadBalancerTlsCertificateError {
    fn code(&self) -> Option<&str> {
        AttachLoadBalancerTlsCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AttachLoadBalancerTlsCertificateError {
    /// Creates a new `AttachLoadBalancerTlsCertificateError`.
    pub fn new(
        kind: AttachLoadBalancerTlsCertificateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AttachLoadBalancerTlsCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AttachLoadBalancerTlsCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AttachLoadBalancerTlsCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AttachLoadBalancerTlsCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AttachLoadBalancerTlsCertificateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachLoadBalancerTlsCertificateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachLoadBalancerTlsCertificateErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachLoadBalancerTlsCertificateErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachLoadBalancerTlsCertificateErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachLoadBalancerTlsCertificateErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachLoadBalancerTlsCertificateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachLoadBalancerTlsCertificateErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachLoadBalancerTlsCertificateErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachLoadBalancerTlsCertificateErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachLoadBalancerTlsCertificateErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachLoadBalancerTlsCertificateErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachLoadBalancerTlsCertificateErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachLoadBalancerTlsCertificateErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for AttachLoadBalancerTlsCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AttachLoadBalancerTlsCertificateErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            AttachLoadBalancerTlsCertificateErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            AttachLoadBalancerTlsCertificateErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            AttachLoadBalancerTlsCertificateErrorKind::NotFoundException(_inner) => Some(_inner),
            AttachLoadBalancerTlsCertificateErrorKind::OperationFailureException(_inner) => {
                Some(_inner)
            }
            AttachLoadBalancerTlsCertificateErrorKind::ServiceException(_inner) => Some(_inner),
            AttachLoadBalancerTlsCertificateErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            AttachLoadBalancerTlsCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AttachStaticIp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AttachStaticIpError {
    /// Kind of error that occurred.
    pub kind: AttachStaticIpErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AttachStaticIp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AttachStaticIpErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AttachStaticIpError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AttachStaticIpErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AttachStaticIpErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            AttachStaticIpErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            AttachStaticIpErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            AttachStaticIpErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            AttachStaticIpErrorKind::ServiceException(_inner) => _inner.fmt(f),
            AttachStaticIpErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            AttachStaticIpErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AttachStaticIpError {
    fn code(&self) -> Option<&str> {
        AttachStaticIpError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AttachStaticIpError {
    /// Creates a new `AttachStaticIpError`.
    pub fn new(kind: AttachStaticIpErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AttachStaticIpError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AttachStaticIpErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AttachStaticIpError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AttachStaticIpErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AttachStaticIpErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachStaticIpErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachStaticIpErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachStaticIpErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachStaticIpErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachStaticIpErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachStaticIpErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, AttachStaticIpErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `AttachStaticIpErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachStaticIpErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `AttachStaticIpErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, AttachStaticIpErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `AttachStaticIpErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            AttachStaticIpErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for AttachStaticIpError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AttachStaticIpErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AttachStaticIpErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            AttachStaticIpErrorKind::InvalidInputException(_inner) => Some(_inner),
            AttachStaticIpErrorKind::NotFoundException(_inner) => Some(_inner),
            AttachStaticIpErrorKind::OperationFailureException(_inner) => Some(_inner),
            AttachStaticIpErrorKind::ServiceException(_inner) => Some(_inner),
            AttachStaticIpErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            AttachStaticIpErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CloseInstancePublicPorts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CloseInstancePublicPortsError {
    /// Kind of error that occurred.
    pub kind: CloseInstancePublicPortsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CloseInstancePublicPorts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CloseInstancePublicPortsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CloseInstancePublicPortsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CloseInstancePublicPortsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CloseInstancePublicPortsErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            CloseInstancePublicPortsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CloseInstancePublicPortsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CloseInstancePublicPortsErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            CloseInstancePublicPortsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CloseInstancePublicPortsErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            CloseInstancePublicPortsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CloseInstancePublicPortsError {
    fn code(&self) -> Option<&str> {
        CloseInstancePublicPortsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CloseInstancePublicPortsError {
    /// Creates a new `CloseInstancePublicPortsError`.
    pub fn new(kind: CloseInstancePublicPortsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CloseInstancePublicPortsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CloseInstancePublicPortsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CloseInstancePublicPortsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CloseInstancePublicPortsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CloseInstancePublicPortsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CloseInstancePublicPortsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CloseInstancePublicPortsErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            CloseInstancePublicPortsErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `CloseInstancePublicPortsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CloseInstancePublicPortsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CloseInstancePublicPortsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CloseInstancePublicPortsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CloseInstancePublicPortsErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CloseInstancePublicPortsErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CloseInstancePublicPortsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CloseInstancePublicPortsErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CloseInstancePublicPortsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CloseInstancePublicPortsErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CloseInstancePublicPortsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CloseInstancePublicPortsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CloseInstancePublicPortsErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            CloseInstancePublicPortsErrorKind::InvalidInputException(_inner) => Some(_inner),
            CloseInstancePublicPortsErrorKind::NotFoundException(_inner) => Some(_inner),
            CloseInstancePublicPortsErrorKind::OperationFailureException(_inner) => Some(_inner),
            CloseInstancePublicPortsErrorKind::ServiceException(_inner) => Some(_inner),
            CloseInstancePublicPortsErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            CloseInstancePublicPortsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CopySnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CopySnapshotError {
    /// Kind of error that occurred.
    pub kind: CopySnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CopySnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CopySnapshotErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CopySnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CopySnapshotErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CopySnapshotErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            CopySnapshotErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CopySnapshotErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CopySnapshotErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            CopySnapshotErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CopySnapshotErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            CopySnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CopySnapshotError {
    fn code(&self) -> Option<&str> {
        CopySnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CopySnapshotError {
    /// Creates a new `CopySnapshotError`.
    pub fn new(kind: CopySnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CopySnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CopySnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CopySnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CopySnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CopySnapshotErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CopySnapshotErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CopySnapshotErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopySnapshotErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `CopySnapshotErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CopySnapshotErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `CopySnapshotErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CopySnapshotErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CopySnapshotErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopySnapshotErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CopySnapshotErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CopySnapshotErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `CopySnapshotErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CopySnapshotErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CopySnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CopySnapshotErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CopySnapshotErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            CopySnapshotErrorKind::InvalidInputException(_inner) => Some(_inner),
            CopySnapshotErrorKind::NotFoundException(_inner) => Some(_inner),
            CopySnapshotErrorKind::OperationFailureException(_inner) => Some(_inner),
            CopySnapshotErrorKind::ServiceException(_inner) => Some(_inner),
            CopySnapshotErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            CopySnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBucket` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBucketError {
    /// Kind of error that occurred.
    pub kind: CreateBucketErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBucket` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBucketErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBucketError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBucketErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateBucketErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateBucketErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateBucketErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            CreateBucketErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBucketError {
    fn code(&self) -> Option<&str> {
        CreateBucketError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBucketError {
    /// Creates a new `CreateBucketError`.
    pub fn new(kind: CreateBucketErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBucketError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBucketErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBucketError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBucketErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBucketErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateBucketErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateBucketErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CreateBucketErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `CreateBucketErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CreateBucketErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `CreateBucketErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBucketErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CreateBucketError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBucketErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateBucketErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateBucketErrorKind::ServiceException(_inner) => Some(_inner),
            CreateBucketErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            CreateBucketErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBucketAccessKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBucketAccessKeyError {
    /// Kind of error that occurred.
    pub kind: CreateBucketAccessKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBucketAccessKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBucketAccessKeyErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBucketAccessKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBucketAccessKeyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateBucketAccessKeyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateBucketAccessKeyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateBucketAccessKeyErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateBucketAccessKeyErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            CreateBucketAccessKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBucketAccessKeyError {
    fn code(&self) -> Option<&str> {
        CreateBucketAccessKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBucketAccessKeyError {
    /// Creates a new `CreateBucketAccessKeyError`.
    pub fn new(kind: CreateBucketAccessKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBucketAccessKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBucketAccessKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBucketAccessKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBucketAccessKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBucketAccessKeyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBucketAccessKeyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBucketAccessKeyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBucketAccessKeyErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBucketAccessKeyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBucketAccessKeyErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBucketAccessKeyErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBucketAccessKeyErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBucketAccessKeyErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBucketAccessKeyErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CreateBucketAccessKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBucketAccessKeyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateBucketAccessKeyErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateBucketAccessKeyErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateBucketAccessKeyErrorKind::ServiceException(_inner) => Some(_inner),
            CreateBucketAccessKeyErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            CreateBucketAccessKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCertificateError {
    /// Kind of error that occurred.
    pub kind: CreateCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCertificateErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCertificateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateCertificateErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateCertificateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateCertificateErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateCertificateErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            CreateCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCertificateError {
    fn code(&self) -> Option<&str> {
        CreateCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCertificateError {
    /// Creates a new `CreateCertificateError`.
    pub fn new(kind: CreateCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCertificateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCertificateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCertificateErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCertificateErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCertificateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateCertificateErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateCertificateErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CreateCertificateErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `CreateCertificateErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCertificateErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CreateCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCertificateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateCertificateErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateCertificateErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateCertificateErrorKind::ServiceException(_inner) => Some(_inner),
            CreateCertificateErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            CreateCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCloudFormationStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCloudFormationStackError {
    /// Kind of error that occurred.
    pub kind: CreateCloudFormationStackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCloudFormationStack` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCloudFormationStackErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCloudFormationStackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCloudFormationStackErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateCloudFormationStackErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            CreateCloudFormationStackErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateCloudFormationStackErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateCloudFormationStackErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            CreateCloudFormationStackErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateCloudFormationStackErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            CreateCloudFormationStackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCloudFormationStackError {
    fn code(&self) -> Option<&str> {
        CreateCloudFormationStackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCloudFormationStackError {
    /// Creates a new `CreateCloudFormationStackError`.
    pub fn new(kind: CreateCloudFormationStackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCloudFormationStackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCloudFormationStackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCloudFormationStackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCloudFormationStackErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCloudFormationStackErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCloudFormationStackErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCloudFormationStackErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCloudFormationStackErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCloudFormationStackErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCloudFormationStackErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCloudFormationStackErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCloudFormationStackErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCloudFormationStackErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCloudFormationStackErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCloudFormationStackErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCloudFormationStackErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCloudFormationStackErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCloudFormationStackErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CreateCloudFormationStackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCloudFormationStackErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateCloudFormationStackErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            CreateCloudFormationStackErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateCloudFormationStackErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateCloudFormationStackErrorKind::OperationFailureException(_inner) => Some(_inner),
            CreateCloudFormationStackErrorKind::ServiceException(_inner) => Some(_inner),
            CreateCloudFormationStackErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            CreateCloudFormationStackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateContactMethod` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateContactMethodError {
    /// Kind of error that occurred.
    pub kind: CreateContactMethodErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateContactMethod` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateContactMethodErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateContactMethodError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateContactMethodErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateContactMethodErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateContactMethodErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateContactMethodErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            CreateContactMethodErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateContactMethodErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            CreateContactMethodErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateContactMethodError {
    fn code(&self) -> Option<&str> {
        CreateContactMethodError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateContactMethodError {
    /// Creates a new `CreateContactMethodError`.
    pub fn new(kind: CreateContactMethodErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateContactMethodError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateContactMethodErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateContactMethodError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateContactMethodErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateContactMethodErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactMethodErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContactMethodErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactMethodErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContactMethodErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactMethodErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContactMethodErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactMethodErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContactMethodErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactMethodErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContactMethodErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactMethodErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CreateContactMethodError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateContactMethodErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateContactMethodErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateContactMethodErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateContactMethodErrorKind::OperationFailureException(_inner) => Some(_inner),
            CreateContactMethodErrorKind::ServiceException(_inner) => Some(_inner),
            CreateContactMethodErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            CreateContactMethodErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateContainerService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateContainerServiceError {
    /// Kind of error that occurred.
    pub kind: CreateContainerServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateContainerService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateContainerServiceErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateContainerServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateContainerServiceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateContainerServiceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateContainerServiceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateContainerServiceErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateContainerServiceErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            CreateContainerServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateContainerServiceError {
    fn code(&self) -> Option<&str> {
        CreateContainerServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateContainerServiceError {
    /// Creates a new `CreateContainerServiceError`.
    pub fn new(kind: CreateContainerServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateContainerServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateContainerServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateContainerServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateContainerServiceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateContainerServiceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContainerServiceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContainerServiceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContainerServiceErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContainerServiceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContainerServiceErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContainerServiceErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContainerServiceErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContainerServiceErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContainerServiceErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CreateContainerServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateContainerServiceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateContainerServiceErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateContainerServiceErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateContainerServiceErrorKind::ServiceException(_inner) => Some(_inner),
            CreateContainerServiceErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            CreateContainerServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateContainerServiceDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateContainerServiceDeploymentError {
    /// Kind of error that occurred.
    pub kind: CreateContainerServiceDeploymentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateContainerServiceDeployment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateContainerServiceDeploymentErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateContainerServiceDeploymentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateContainerServiceDeploymentErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            CreateContainerServiceDeploymentErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            CreateContainerServiceDeploymentErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateContainerServiceDeploymentErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateContainerServiceDeploymentErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            CreateContainerServiceDeploymentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateContainerServiceDeploymentError {
    fn code(&self) -> Option<&str> {
        CreateContainerServiceDeploymentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateContainerServiceDeploymentError {
    /// Creates a new `CreateContainerServiceDeploymentError`.
    pub fn new(
        kind: CreateContainerServiceDeploymentErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateContainerServiceDeploymentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateContainerServiceDeploymentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateContainerServiceDeploymentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateContainerServiceDeploymentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateContainerServiceDeploymentErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContainerServiceDeploymentErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContainerServiceDeploymentErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContainerServiceDeploymentErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContainerServiceDeploymentErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContainerServiceDeploymentErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContainerServiceDeploymentErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContainerServiceDeploymentErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContainerServiceDeploymentErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContainerServiceDeploymentErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CreateContainerServiceDeploymentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateContainerServiceDeploymentErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            CreateContainerServiceDeploymentErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            CreateContainerServiceDeploymentErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateContainerServiceDeploymentErrorKind::ServiceException(_inner) => Some(_inner),
            CreateContainerServiceDeploymentErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            CreateContainerServiceDeploymentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateContainerServiceRegistryLogin` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateContainerServiceRegistryLoginError {
    /// Kind of error that occurred.
    pub kind: CreateContainerServiceRegistryLoginErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateContainerServiceRegistryLogin` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateContainerServiceRegistryLoginErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateContainerServiceRegistryLoginError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateContainerServiceRegistryLoginErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            CreateContainerServiceRegistryLoginErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            CreateContainerServiceRegistryLoginErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateContainerServiceRegistryLoginErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateContainerServiceRegistryLoginErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            CreateContainerServiceRegistryLoginErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateContainerServiceRegistryLoginError {
    fn code(&self) -> Option<&str> {
        CreateContainerServiceRegistryLoginError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateContainerServiceRegistryLoginError {
    /// Creates a new `CreateContainerServiceRegistryLoginError`.
    pub fn new(
        kind: CreateContainerServiceRegistryLoginErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateContainerServiceRegistryLoginError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateContainerServiceRegistryLoginErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateContainerServiceRegistryLoginError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateContainerServiceRegistryLoginErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateContainerServiceRegistryLoginErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContainerServiceRegistryLoginErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContainerServiceRegistryLoginErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContainerServiceRegistryLoginErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContainerServiceRegistryLoginErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContainerServiceRegistryLoginErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContainerServiceRegistryLoginErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContainerServiceRegistryLoginErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContainerServiceRegistryLoginErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContainerServiceRegistryLoginErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CreateContainerServiceRegistryLoginError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateContainerServiceRegistryLoginErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            CreateContainerServiceRegistryLoginErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            CreateContainerServiceRegistryLoginErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateContainerServiceRegistryLoginErrorKind::ServiceException(_inner) => Some(_inner),
            CreateContainerServiceRegistryLoginErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            CreateContainerServiceRegistryLoginErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreateDisk` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDiskError {
    /// Kind of error that occurred.
    pub kind: CreateDiskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDisk` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDiskErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDiskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDiskErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDiskErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            CreateDiskErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateDiskErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateDiskErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            CreateDiskErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateDiskErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            CreateDiskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDiskError {
    fn code(&self) -> Option<&str> {
        CreateDiskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDiskError {
    /// Creates a new `CreateDiskError`.
    pub fn new(kind: CreateDiskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDiskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDiskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDiskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDiskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDiskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateDiskErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateDiskErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDiskErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDiskErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CreateDiskErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `CreateDiskErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateDiskErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateDiskErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDiskErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDiskErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CreateDiskErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `CreateDiskErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(&self.kind, CreateDiskErrorKind::UnauthenticatedException(_))
    }
}
impl std::error::Error for CreateDiskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDiskErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDiskErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            CreateDiskErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateDiskErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateDiskErrorKind::OperationFailureException(_inner) => Some(_inner),
            CreateDiskErrorKind::ServiceException(_inner) => Some(_inner),
            CreateDiskErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            CreateDiskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDiskFromSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDiskFromSnapshotError {
    /// Kind of error that occurred.
    pub kind: CreateDiskFromSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDiskFromSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDiskFromSnapshotErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDiskFromSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDiskFromSnapshotErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDiskFromSnapshotErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            CreateDiskFromSnapshotErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateDiskFromSnapshotErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateDiskFromSnapshotErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            CreateDiskFromSnapshotErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateDiskFromSnapshotErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            CreateDiskFromSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDiskFromSnapshotError {
    fn code(&self) -> Option<&str> {
        CreateDiskFromSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDiskFromSnapshotError {
    /// Creates a new `CreateDiskFromSnapshotError`.
    pub fn new(kind: CreateDiskFromSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDiskFromSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDiskFromSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDiskFromSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDiskFromSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDiskFromSnapshotErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDiskFromSnapshotErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDiskFromSnapshotErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDiskFromSnapshotErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDiskFromSnapshotErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDiskFromSnapshotErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDiskFromSnapshotErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDiskFromSnapshotErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDiskFromSnapshotErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDiskFromSnapshotErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDiskFromSnapshotErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDiskFromSnapshotErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDiskFromSnapshotErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDiskFromSnapshotErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CreateDiskFromSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDiskFromSnapshotErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDiskFromSnapshotErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            CreateDiskFromSnapshotErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateDiskFromSnapshotErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateDiskFromSnapshotErrorKind::OperationFailureException(_inner) => Some(_inner),
            CreateDiskFromSnapshotErrorKind::ServiceException(_inner) => Some(_inner),
            CreateDiskFromSnapshotErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            CreateDiskFromSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDiskSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDiskSnapshotError {
    /// Kind of error that occurred.
    pub kind: CreateDiskSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDiskSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDiskSnapshotErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDiskSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDiskSnapshotErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDiskSnapshotErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            CreateDiskSnapshotErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateDiskSnapshotErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateDiskSnapshotErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            CreateDiskSnapshotErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateDiskSnapshotErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            CreateDiskSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDiskSnapshotError {
    fn code(&self) -> Option<&str> {
        CreateDiskSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDiskSnapshotError {
    /// Creates a new `CreateDiskSnapshotError`.
    pub fn new(kind: CreateDiskSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDiskSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDiskSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDiskSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDiskSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDiskSnapshotErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDiskSnapshotErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDiskSnapshotErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDiskSnapshotErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDiskSnapshotErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDiskSnapshotErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDiskSnapshotErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDiskSnapshotErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDiskSnapshotErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDiskSnapshotErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDiskSnapshotErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CreateDiskSnapshotErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `CreateDiskSnapshotErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDiskSnapshotErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CreateDiskSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDiskSnapshotErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDiskSnapshotErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            CreateDiskSnapshotErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateDiskSnapshotErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateDiskSnapshotErrorKind::OperationFailureException(_inner) => Some(_inner),
            CreateDiskSnapshotErrorKind::ServiceException(_inner) => Some(_inner),
            CreateDiskSnapshotErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            CreateDiskSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDistributionError {
    /// Kind of error that occurred.
    pub kind: CreateDistributionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDistributionErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDistributionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDistributionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDistributionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateDistributionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateDistributionErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            CreateDistributionErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateDistributionErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            CreateDistributionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDistributionError {
    fn code(&self) -> Option<&str> {
        CreateDistributionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDistributionError {
    /// Creates a new `CreateDistributionError`.
    pub fn new(kind: CreateDistributionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDistributionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDistributionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDistributionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDistributionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CreateDistributionErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `CreateDistributionErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDistributionErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CreateDistributionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDistributionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDistributionErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateDistributionErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateDistributionErrorKind::OperationFailureException(_inner) => Some(_inner),
            CreateDistributionErrorKind::ServiceException(_inner) => Some(_inner),
            CreateDistributionErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            CreateDistributionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDomainError {
    /// Kind of error that occurred.
    pub kind: CreateDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDomainErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDomainErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDomainError {
    fn code(&self) -> Option<&str> {
        CreateDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDomainError {
    /// Creates a new `CreateDomainError`.
    pub fn new(kind: CreateDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDomainErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateDomainErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `CreateDomainErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateDomainErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `CreateDomainErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CreateDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDomainErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDomainErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            CreateDomainErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateDomainErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateDomainErrorKind::OperationFailureException(_inner) => Some(_inner),
            CreateDomainErrorKind::ServiceException(_inner) => Some(_inner),
            CreateDomainErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            CreateDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDomainEntry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDomainEntryError {
    /// Kind of error that occurred.
    pub kind: CreateDomainEntryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDomainEntry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDomainEntryErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDomainEntryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDomainEntryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDomainEntryErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            CreateDomainEntryErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateDomainEntryErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateDomainEntryErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            CreateDomainEntryErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateDomainEntryErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            CreateDomainEntryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDomainEntryError {
    fn code(&self) -> Option<&str> {
        CreateDomainEntryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDomainEntryError {
    /// Creates a new `CreateDomainEntryError`.
    pub fn new(kind: CreateDomainEntryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDomainEntryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDomainEntryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDomainEntryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDomainEntryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDomainEntryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainEntryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainEntryErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainEntryErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainEntryErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainEntryErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainEntryErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainEntryErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateDomainEntryErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainEntryErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDomainEntryErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainEntryErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `CreateDomainEntryErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainEntryErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CreateDomainEntryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDomainEntryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDomainEntryErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            CreateDomainEntryErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateDomainEntryErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateDomainEntryErrorKind::OperationFailureException(_inner) => Some(_inner),
            CreateDomainEntryErrorKind::ServiceException(_inner) => Some(_inner),
            CreateDomainEntryErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            CreateDomainEntryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateInstancesError {
    /// Kind of error that occurred.
    pub kind: CreateInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateInstancesErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateInstancesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateInstancesErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            CreateInstancesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateInstancesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateInstancesErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            CreateInstancesErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateInstancesErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            CreateInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateInstancesError {
    fn code(&self) -> Option<&str> {
        CreateInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateInstancesError {
    /// Creates a new `CreateInstancesError`.
    pub fn new(kind: CreateInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateInstancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateInstancesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstancesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstancesErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstancesErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstancesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstancesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstancesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateInstancesErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateInstancesErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstancesErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstancesErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CreateInstancesErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `CreateInstancesErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstancesErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CreateInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateInstancesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateInstancesErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            CreateInstancesErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateInstancesErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateInstancesErrorKind::OperationFailureException(_inner) => Some(_inner),
            CreateInstancesErrorKind::ServiceException(_inner) => Some(_inner),
            CreateInstancesErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            CreateInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateInstancesFromSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateInstancesFromSnapshotError {
    /// Kind of error that occurred.
    pub kind: CreateInstancesFromSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateInstancesFromSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateInstancesFromSnapshotErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateInstancesFromSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateInstancesFromSnapshotErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateInstancesFromSnapshotErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            CreateInstancesFromSnapshotErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateInstancesFromSnapshotErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateInstancesFromSnapshotErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            CreateInstancesFromSnapshotErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateInstancesFromSnapshotErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            CreateInstancesFromSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateInstancesFromSnapshotError {
    fn code(&self) -> Option<&str> {
        CreateInstancesFromSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateInstancesFromSnapshotError {
    /// Creates a new `CreateInstancesFromSnapshotError`.
    pub fn new(kind: CreateInstancesFromSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateInstancesFromSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateInstancesFromSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateInstancesFromSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateInstancesFromSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateInstancesFromSnapshotErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstancesFromSnapshotErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstancesFromSnapshotErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstancesFromSnapshotErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstancesFromSnapshotErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstancesFromSnapshotErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstancesFromSnapshotErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstancesFromSnapshotErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstancesFromSnapshotErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstancesFromSnapshotErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstancesFromSnapshotErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstancesFromSnapshotErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstancesFromSnapshotErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstancesFromSnapshotErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CreateInstancesFromSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateInstancesFromSnapshotErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateInstancesFromSnapshotErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            CreateInstancesFromSnapshotErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateInstancesFromSnapshotErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateInstancesFromSnapshotErrorKind::OperationFailureException(_inner) => Some(_inner),
            CreateInstancesFromSnapshotErrorKind::ServiceException(_inner) => Some(_inner),
            CreateInstancesFromSnapshotErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            CreateInstancesFromSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateInstanceSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateInstanceSnapshotError {
    /// Kind of error that occurred.
    pub kind: CreateInstanceSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateInstanceSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateInstanceSnapshotErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateInstanceSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateInstanceSnapshotErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateInstanceSnapshotErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            CreateInstanceSnapshotErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateInstanceSnapshotErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateInstanceSnapshotErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            CreateInstanceSnapshotErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateInstanceSnapshotErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            CreateInstanceSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateInstanceSnapshotError {
    fn code(&self) -> Option<&str> {
        CreateInstanceSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateInstanceSnapshotError {
    /// Creates a new `CreateInstanceSnapshotError`.
    pub fn new(kind: CreateInstanceSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateInstanceSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateInstanceSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateInstanceSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateInstanceSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateInstanceSnapshotErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceSnapshotErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstanceSnapshotErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceSnapshotErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstanceSnapshotErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceSnapshotErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstanceSnapshotErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceSnapshotErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstanceSnapshotErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceSnapshotErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstanceSnapshotErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceSnapshotErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstanceSnapshotErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceSnapshotErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CreateInstanceSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateInstanceSnapshotErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateInstanceSnapshotErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            CreateInstanceSnapshotErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateInstanceSnapshotErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateInstanceSnapshotErrorKind::OperationFailureException(_inner) => Some(_inner),
            CreateInstanceSnapshotErrorKind::ServiceException(_inner) => Some(_inner),
            CreateInstanceSnapshotErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            CreateInstanceSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateKeyPair` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateKeyPairError {
    /// Kind of error that occurred.
    pub kind: CreateKeyPairErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateKeyPair` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateKeyPairErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateKeyPairError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateKeyPairErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateKeyPairErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            CreateKeyPairErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateKeyPairErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateKeyPairErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            CreateKeyPairErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateKeyPairErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            CreateKeyPairErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateKeyPairError {
    fn code(&self) -> Option<&str> {
        CreateKeyPairError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateKeyPairError {
    /// Creates a new `CreateKeyPairError`.
    pub fn new(kind: CreateKeyPairErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateKeyPairError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateKeyPairErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateKeyPairError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateKeyPairErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateKeyPairErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateKeyPairErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateKeyPairErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateKeyPairErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateKeyPairErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CreateKeyPairErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `CreateKeyPairErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateKeyPairErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateKeyPairErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateKeyPairErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateKeyPairErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CreateKeyPairErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `CreateKeyPairErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateKeyPairErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CreateKeyPairError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateKeyPairErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateKeyPairErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            CreateKeyPairErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateKeyPairErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateKeyPairErrorKind::OperationFailureException(_inner) => Some(_inner),
            CreateKeyPairErrorKind::ServiceException(_inner) => Some(_inner),
            CreateKeyPairErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            CreateKeyPairErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLoadBalancerError {
    /// Kind of error that occurred.
    pub kind: CreateLoadBalancerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLoadBalancerErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLoadBalancerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLoadBalancerErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            CreateLoadBalancerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLoadBalancerError {
    fn code(&self) -> Option<&str> {
        CreateLoadBalancerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLoadBalancerError {
    /// Creates a new `CreateLoadBalancerError`.
    pub fn new(kind: CreateLoadBalancerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLoadBalancerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLoadBalancerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLoadBalancerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLoadBalancerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, CreateLoadBalancerErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CreateLoadBalancerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLoadBalancerErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::OperationFailureException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::ServiceException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            CreateLoadBalancerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLoadBalancerTlsCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLoadBalancerTlsCertificateError {
    /// Kind of error that occurred.
    pub kind: CreateLoadBalancerTlsCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLoadBalancerTlsCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLoadBalancerTlsCertificateErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLoadBalancerTlsCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLoadBalancerTlsCertificateErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            CreateLoadBalancerTlsCertificateErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            CreateLoadBalancerTlsCertificateErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            CreateLoadBalancerTlsCertificateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateLoadBalancerTlsCertificateErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            CreateLoadBalancerTlsCertificateErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateLoadBalancerTlsCertificateErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            CreateLoadBalancerTlsCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLoadBalancerTlsCertificateError {
    fn code(&self) -> Option<&str> {
        CreateLoadBalancerTlsCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLoadBalancerTlsCertificateError {
    /// Creates a new `CreateLoadBalancerTlsCertificateError`.
    pub fn new(
        kind: CreateLoadBalancerTlsCertificateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLoadBalancerTlsCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLoadBalancerTlsCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLoadBalancerTlsCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLoadBalancerTlsCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerTlsCertificateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerTlsCertificateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerTlsCertificateErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerTlsCertificateErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerTlsCertificateErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerTlsCertificateErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerTlsCertificateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerTlsCertificateErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerTlsCertificateErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerTlsCertificateErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerTlsCertificateErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerTlsCertificateErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLoadBalancerTlsCertificateErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLoadBalancerTlsCertificateErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CreateLoadBalancerTlsCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLoadBalancerTlsCertificateErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            CreateLoadBalancerTlsCertificateErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            CreateLoadBalancerTlsCertificateErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            CreateLoadBalancerTlsCertificateErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateLoadBalancerTlsCertificateErrorKind::OperationFailureException(_inner) => {
                Some(_inner)
            }
            CreateLoadBalancerTlsCertificateErrorKind::ServiceException(_inner) => Some(_inner),
            CreateLoadBalancerTlsCertificateErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            CreateLoadBalancerTlsCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRelationalDatabase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRelationalDatabaseError {
    /// Kind of error that occurred.
    pub kind: CreateRelationalDatabaseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRelationalDatabase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRelationalDatabaseErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRelationalDatabaseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRelationalDatabaseErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateRelationalDatabaseErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            CreateRelationalDatabaseErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateRelationalDatabaseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateRelationalDatabaseErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            CreateRelationalDatabaseErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateRelationalDatabaseErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            CreateRelationalDatabaseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRelationalDatabaseError {
    fn code(&self) -> Option<&str> {
        CreateRelationalDatabaseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRelationalDatabaseError {
    /// Creates a new `CreateRelationalDatabaseError`.
    pub fn new(kind: CreateRelationalDatabaseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRelationalDatabaseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRelationalDatabaseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRelationalDatabaseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRelationalDatabaseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRelationalDatabaseErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRelationalDatabaseErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRelationalDatabaseErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRelationalDatabaseErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRelationalDatabaseErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRelationalDatabaseErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRelationalDatabaseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRelationalDatabaseErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRelationalDatabaseErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRelationalDatabaseErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRelationalDatabaseErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRelationalDatabaseErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRelationalDatabaseErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRelationalDatabaseErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CreateRelationalDatabaseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRelationalDatabaseErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateRelationalDatabaseErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            CreateRelationalDatabaseErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateRelationalDatabaseErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateRelationalDatabaseErrorKind::OperationFailureException(_inner) => Some(_inner),
            CreateRelationalDatabaseErrorKind::ServiceException(_inner) => Some(_inner),
            CreateRelationalDatabaseErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            CreateRelationalDatabaseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRelationalDatabaseFromSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRelationalDatabaseFromSnapshotError {
    /// Kind of error that occurred.
    pub kind: CreateRelationalDatabaseFromSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRelationalDatabaseFromSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRelationalDatabaseFromSnapshotErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRelationalDatabaseFromSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRelationalDatabaseFromSnapshotErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            CreateRelationalDatabaseFromSnapshotErrorKind::AccountSetupInProgressException(
                _inner,
            ) => _inner.fmt(f),
            CreateRelationalDatabaseFromSnapshotErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            CreateRelationalDatabaseFromSnapshotErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateRelationalDatabaseFromSnapshotErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            CreateRelationalDatabaseFromSnapshotErrorKind::ServiceException(_inner) => {
                _inner.fmt(f)
            }
            CreateRelationalDatabaseFromSnapshotErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            CreateRelationalDatabaseFromSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRelationalDatabaseFromSnapshotError {
    fn code(&self) -> Option<&str> {
        CreateRelationalDatabaseFromSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRelationalDatabaseFromSnapshotError {
    /// Creates a new `CreateRelationalDatabaseFromSnapshotError`.
    pub fn new(
        kind: CreateRelationalDatabaseFromSnapshotErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRelationalDatabaseFromSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRelationalDatabaseFromSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRelationalDatabaseFromSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRelationalDatabaseFromSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRelationalDatabaseFromSnapshotErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRelationalDatabaseFromSnapshotErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRelationalDatabaseFromSnapshotErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRelationalDatabaseFromSnapshotErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRelationalDatabaseFromSnapshotErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRelationalDatabaseFromSnapshotErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRelationalDatabaseFromSnapshotErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRelationalDatabaseFromSnapshotErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRelationalDatabaseFromSnapshotErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRelationalDatabaseFromSnapshotErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRelationalDatabaseFromSnapshotErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRelationalDatabaseFromSnapshotErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRelationalDatabaseFromSnapshotErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRelationalDatabaseFromSnapshotErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CreateRelationalDatabaseFromSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRelationalDatabaseFromSnapshotErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            CreateRelationalDatabaseFromSnapshotErrorKind::AccountSetupInProgressException(
                _inner,
            ) => Some(_inner),
            CreateRelationalDatabaseFromSnapshotErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            CreateRelationalDatabaseFromSnapshotErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            CreateRelationalDatabaseFromSnapshotErrorKind::OperationFailureException(_inner) => {
                Some(_inner)
            }
            CreateRelationalDatabaseFromSnapshotErrorKind::ServiceException(_inner) => Some(_inner),
            CreateRelationalDatabaseFromSnapshotErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            CreateRelationalDatabaseFromSnapshotErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreateRelationalDatabaseSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRelationalDatabaseSnapshotError {
    /// Kind of error that occurred.
    pub kind: CreateRelationalDatabaseSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRelationalDatabaseSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRelationalDatabaseSnapshotErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRelationalDatabaseSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRelationalDatabaseSnapshotErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            CreateRelationalDatabaseSnapshotErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            CreateRelationalDatabaseSnapshotErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            CreateRelationalDatabaseSnapshotErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateRelationalDatabaseSnapshotErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            CreateRelationalDatabaseSnapshotErrorKind::ServiceException(_inner) => _inner.fmt(f),
            CreateRelationalDatabaseSnapshotErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            CreateRelationalDatabaseSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRelationalDatabaseSnapshotError {
    fn code(&self) -> Option<&str> {
        CreateRelationalDatabaseSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRelationalDatabaseSnapshotError {
    /// Creates a new `CreateRelationalDatabaseSnapshotError`.
    pub fn new(
        kind: CreateRelationalDatabaseSnapshotErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRelationalDatabaseSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRelationalDatabaseSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRelationalDatabaseSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRelationalDatabaseSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRelationalDatabaseSnapshotErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRelationalDatabaseSnapshotErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRelationalDatabaseSnapshotErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRelationalDatabaseSnapshotErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRelationalDatabaseSnapshotErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRelationalDatabaseSnapshotErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRelationalDatabaseSnapshotErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRelationalDatabaseSnapshotErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRelationalDatabaseSnapshotErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRelationalDatabaseSnapshotErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRelationalDatabaseSnapshotErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRelationalDatabaseSnapshotErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRelationalDatabaseSnapshotErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRelationalDatabaseSnapshotErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for CreateRelationalDatabaseSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRelationalDatabaseSnapshotErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            CreateRelationalDatabaseSnapshotErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            CreateRelationalDatabaseSnapshotErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            CreateRelationalDatabaseSnapshotErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateRelationalDatabaseSnapshotErrorKind::OperationFailureException(_inner) => {
                Some(_inner)
            }
            CreateRelationalDatabaseSnapshotErrorKind::ServiceException(_inner) => Some(_inner),
            CreateRelationalDatabaseSnapshotErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            CreateRelationalDatabaseSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAlarm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAlarmError {
    /// Kind of error that occurred.
    pub kind: DeleteAlarmErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAlarm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAlarmErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAlarmError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAlarmErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteAlarmErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteAlarmErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteAlarmErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            DeleteAlarmErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteAlarmErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            DeleteAlarmErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAlarmError {
    fn code(&self) -> Option<&str> {
        DeleteAlarmError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAlarmError {
    /// Creates a new `DeleteAlarmError`.
    pub fn new(kind: DeleteAlarmErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAlarmError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAlarmErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAlarmError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAlarmErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAlarmErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteAlarmErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteAlarmErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DeleteAlarmErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `DeleteAlarmErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteAlarmErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteAlarmErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAlarmErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAlarmErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DeleteAlarmErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DeleteAlarmErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAlarmErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DeleteAlarmError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAlarmErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteAlarmErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteAlarmErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteAlarmErrorKind::OperationFailureException(_inner) => Some(_inner),
            DeleteAlarmErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteAlarmErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            DeleteAlarmErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAutoSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAutoSnapshotError {
    /// Kind of error that occurred.
    pub kind: DeleteAutoSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAutoSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAutoSnapshotErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAutoSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAutoSnapshotErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteAutoSnapshotErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteAutoSnapshotErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteAutoSnapshotErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            DeleteAutoSnapshotErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteAutoSnapshotErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            DeleteAutoSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAutoSnapshotError {
    fn code(&self) -> Option<&str> {
        DeleteAutoSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAutoSnapshotError {
    /// Creates a new `DeleteAutoSnapshotError`.
    pub fn new(kind: DeleteAutoSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAutoSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAutoSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAutoSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAutoSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAutoSnapshotErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAutoSnapshotErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAutoSnapshotErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAutoSnapshotErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAutoSnapshotErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAutoSnapshotErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAutoSnapshotErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAutoSnapshotErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAutoSnapshotErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DeleteAutoSnapshotErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DeleteAutoSnapshotErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAutoSnapshotErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DeleteAutoSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAutoSnapshotErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteAutoSnapshotErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteAutoSnapshotErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteAutoSnapshotErrorKind::OperationFailureException(_inner) => Some(_inner),
            DeleteAutoSnapshotErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteAutoSnapshotErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            DeleteAutoSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBucket` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBucketError {
    /// Kind of error that occurred.
    pub kind: DeleteBucketErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBucket` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBucketErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBucketError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBucketErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteBucketErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteBucketErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteBucketErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteBucketErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            DeleteBucketErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBucketError {
    fn code(&self) -> Option<&str> {
        DeleteBucketError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBucketError {
    /// Creates a new `DeleteBucketError`.
    pub fn new(kind: DeleteBucketErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBucketError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBucketErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBucketError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBucketErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBucketErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteBucketErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteBucketErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DeleteBucketErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `DeleteBucketErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteBucketErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteBucketErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DeleteBucketErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DeleteBucketErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBucketErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DeleteBucketError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBucketErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteBucketErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteBucketErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteBucketErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteBucketErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            DeleteBucketErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBucketAccessKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBucketAccessKeyError {
    /// Kind of error that occurred.
    pub kind: DeleteBucketAccessKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBucketAccessKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBucketAccessKeyErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBucketAccessKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBucketAccessKeyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteBucketAccessKeyErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteBucketAccessKeyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteBucketAccessKeyErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteBucketAccessKeyErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            DeleteBucketAccessKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBucketAccessKeyError {
    fn code(&self) -> Option<&str> {
        DeleteBucketAccessKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBucketAccessKeyError {
    /// Creates a new `DeleteBucketAccessKeyError`.
    pub fn new(kind: DeleteBucketAccessKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBucketAccessKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBucketAccessKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBucketAccessKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBucketAccessKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBucketAccessKeyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBucketAccessKeyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBucketAccessKeyErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBucketAccessKeyErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBucketAccessKeyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBucketAccessKeyErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBucketAccessKeyErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBucketAccessKeyErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBucketAccessKeyErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBucketAccessKeyErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DeleteBucketAccessKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBucketAccessKeyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteBucketAccessKeyErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteBucketAccessKeyErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteBucketAccessKeyErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteBucketAccessKeyErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            DeleteBucketAccessKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCertificateError {
    /// Kind of error that occurred.
    pub kind: DeleteCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCertificateErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCertificateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteCertificateErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteCertificateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteCertificateErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteCertificateErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            DeleteCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCertificateError {
    fn code(&self) -> Option<&str> {
        DeleteCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCertificateError {
    /// Creates a new `DeleteCertificateError`.
    pub fn new(kind: DeleteCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCertificateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCertificateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCertificateErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCertificateErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCertificateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteCertificateErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteCertificateErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DeleteCertificateErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DeleteCertificateErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCertificateErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DeleteCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCertificateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteCertificateErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteCertificateErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteCertificateErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteCertificateErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            DeleteCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteContactMethod` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteContactMethodError {
    /// Kind of error that occurred.
    pub kind: DeleteContactMethodErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteContactMethod` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteContactMethodErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteContactMethodError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteContactMethodErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteContactMethodErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteContactMethodErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteContactMethodErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            DeleteContactMethodErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteContactMethodErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            DeleteContactMethodErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteContactMethodError {
    fn code(&self) -> Option<&str> {
        DeleteContactMethodError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteContactMethodError {
    /// Creates a new `DeleteContactMethodError`.
    pub fn new(kind: DeleteContactMethodErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteContactMethodError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteContactMethodErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteContactMethodError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteContactMethodErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteContactMethodErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContactMethodErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteContactMethodErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContactMethodErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteContactMethodErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContactMethodErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteContactMethodErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContactMethodErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteContactMethodErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContactMethodErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteContactMethodErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContactMethodErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DeleteContactMethodError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteContactMethodErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteContactMethodErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteContactMethodErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteContactMethodErrorKind::OperationFailureException(_inner) => Some(_inner),
            DeleteContactMethodErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteContactMethodErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            DeleteContactMethodErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteContainerImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteContainerImageError {
    /// Kind of error that occurred.
    pub kind: DeleteContainerImageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteContainerImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteContainerImageErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteContainerImageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteContainerImageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteContainerImageErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteContainerImageErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteContainerImageErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteContainerImageErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            DeleteContainerImageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteContainerImageError {
    fn code(&self) -> Option<&str> {
        DeleteContainerImageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteContainerImageError {
    /// Creates a new `DeleteContainerImageError`.
    pub fn new(kind: DeleteContainerImageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteContainerImageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteContainerImageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteContainerImageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteContainerImageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteContainerImageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContainerImageErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteContainerImageErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContainerImageErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteContainerImageErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContainerImageErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteContainerImageErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContainerImageErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteContainerImageErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContainerImageErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DeleteContainerImageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteContainerImageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteContainerImageErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteContainerImageErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteContainerImageErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteContainerImageErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            DeleteContainerImageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteContainerService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteContainerServiceError {
    /// Kind of error that occurred.
    pub kind: DeleteContainerServiceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteContainerService` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteContainerServiceErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteContainerServiceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteContainerServiceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteContainerServiceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteContainerServiceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteContainerServiceErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteContainerServiceErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            DeleteContainerServiceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteContainerServiceError {
    fn code(&self) -> Option<&str> {
        DeleteContainerServiceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteContainerServiceError {
    /// Creates a new `DeleteContainerServiceError`.
    pub fn new(kind: DeleteContainerServiceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteContainerServiceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteContainerServiceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteContainerServiceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteContainerServiceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteContainerServiceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContainerServiceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteContainerServiceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContainerServiceErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteContainerServiceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContainerServiceErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteContainerServiceErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContainerServiceErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteContainerServiceErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteContainerServiceErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DeleteContainerServiceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteContainerServiceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteContainerServiceErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteContainerServiceErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteContainerServiceErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteContainerServiceErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            DeleteContainerServiceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDisk` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDiskError {
    /// Kind of error that occurred.
    pub kind: DeleteDiskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDisk` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDiskErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDiskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDiskErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDiskErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            DeleteDiskErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteDiskErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteDiskErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            DeleteDiskErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteDiskErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            DeleteDiskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDiskError {
    fn code(&self) -> Option<&str> {
        DeleteDiskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDiskError {
    /// Creates a new `DeleteDiskError`.
    pub fn new(kind: DeleteDiskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDiskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDiskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDiskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDiskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDiskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteDiskErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteDiskErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDiskErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDiskErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DeleteDiskErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `DeleteDiskErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteDiskErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteDiskErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDiskErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDiskErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DeleteDiskErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DeleteDiskErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(&self.kind, DeleteDiskErrorKind::UnauthenticatedException(_))
    }
}
impl std::error::Error for DeleteDiskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDiskErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDiskErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            DeleteDiskErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteDiskErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteDiskErrorKind::OperationFailureException(_inner) => Some(_inner),
            DeleteDiskErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteDiskErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            DeleteDiskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDiskSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDiskSnapshotError {
    /// Kind of error that occurred.
    pub kind: DeleteDiskSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDiskSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDiskSnapshotErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDiskSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDiskSnapshotErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDiskSnapshotErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            DeleteDiskSnapshotErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteDiskSnapshotErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteDiskSnapshotErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            DeleteDiskSnapshotErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteDiskSnapshotErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            DeleteDiskSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDiskSnapshotError {
    fn code(&self) -> Option<&str> {
        DeleteDiskSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDiskSnapshotError {
    /// Creates a new `DeleteDiskSnapshotError`.
    pub fn new(kind: DeleteDiskSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDiskSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDiskSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDiskSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDiskSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDiskSnapshotErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDiskSnapshotErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDiskSnapshotErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDiskSnapshotErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDiskSnapshotErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDiskSnapshotErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDiskSnapshotErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDiskSnapshotErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDiskSnapshotErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDiskSnapshotErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDiskSnapshotErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DeleteDiskSnapshotErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DeleteDiskSnapshotErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDiskSnapshotErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DeleteDiskSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDiskSnapshotErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDiskSnapshotErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            DeleteDiskSnapshotErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteDiskSnapshotErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteDiskSnapshotErrorKind::OperationFailureException(_inner) => Some(_inner),
            DeleteDiskSnapshotErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteDiskSnapshotErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            DeleteDiskSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDistributionError {
    /// Kind of error that occurred.
    pub kind: DeleteDistributionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDistributionErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDistributionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDistributionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDistributionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteDistributionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteDistributionErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            DeleteDistributionErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteDistributionErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            DeleteDistributionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDistributionError {
    fn code(&self) -> Option<&str> {
        DeleteDistributionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDistributionError {
    /// Creates a new `DeleteDistributionError`.
    pub fn new(kind: DeleteDistributionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDistributionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDistributionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDistributionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDistributionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDistributionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDistributionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDistributionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDistributionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDistributionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDistributionErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDistributionErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDistributionErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDistributionErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DeleteDistributionErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DeleteDistributionErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDistributionErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DeleteDistributionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDistributionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDistributionErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteDistributionErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteDistributionErrorKind::OperationFailureException(_inner) => Some(_inner),
            DeleteDistributionErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteDistributionErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            DeleteDistributionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDomainError {
    /// Kind of error that occurred.
    pub kind: DeleteDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDomainErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDomainErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDomainError {
    fn code(&self) -> Option<&str> {
        DeleteDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDomainError {
    /// Creates a new `DeleteDomainError`.
    pub fn new(kind: DeleteDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDomainErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteDomainErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDomainErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `DeleteDomainErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteDomainErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDomainErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DeleteDomainErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DeleteDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDomainErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDomainErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            DeleteDomainErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteDomainErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteDomainErrorKind::OperationFailureException(_inner) => Some(_inner),
            DeleteDomainErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteDomainErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            DeleteDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDomainEntry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDomainEntryError {
    /// Kind of error that occurred.
    pub kind: DeleteDomainEntryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDomainEntry` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDomainEntryErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDomainEntryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDomainEntryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDomainEntryErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            DeleteDomainEntryErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteDomainEntryErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteDomainEntryErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            DeleteDomainEntryErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteDomainEntryErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            DeleteDomainEntryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDomainEntryError {
    fn code(&self) -> Option<&str> {
        DeleteDomainEntryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDomainEntryError {
    /// Creates a new `DeleteDomainEntryError`.
    pub fn new(kind: DeleteDomainEntryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDomainEntryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDomainEntryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDomainEntryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDomainEntryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDomainEntryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainEntryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDomainEntryErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainEntryErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDomainEntryErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainEntryErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDomainEntryErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainEntryErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteDomainEntryErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainEntryErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDomainEntryErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainEntryErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DeleteDomainEntryErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainEntryErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DeleteDomainEntryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDomainEntryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDomainEntryErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            DeleteDomainEntryErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteDomainEntryErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteDomainEntryErrorKind::OperationFailureException(_inner) => Some(_inner),
            DeleteDomainEntryErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteDomainEntryErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            DeleteDomainEntryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteInstanceError {
    /// Kind of error that occurred.
    pub kind: DeleteInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteInstanceErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteInstanceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteInstanceErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            DeleteInstanceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteInstanceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteInstanceErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            DeleteInstanceErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteInstanceErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            DeleteInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteInstanceError {
    fn code(&self) -> Option<&str> {
        DeleteInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteInstanceError {
    /// Creates a new `DeleteInstanceError`.
    pub fn new(kind: DeleteInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteInstanceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInstanceErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInstanceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInstanceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteInstanceErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteInstanceErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInstanceErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DeleteInstanceErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DeleteInstanceErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DeleteInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteInstanceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteInstanceErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            DeleteInstanceErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteInstanceErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteInstanceErrorKind::OperationFailureException(_inner) => Some(_inner),
            DeleteInstanceErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteInstanceErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            DeleteInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteInstanceSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteInstanceSnapshotError {
    /// Kind of error that occurred.
    pub kind: DeleteInstanceSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteInstanceSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteInstanceSnapshotErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteInstanceSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteInstanceSnapshotErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteInstanceSnapshotErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            DeleteInstanceSnapshotErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteInstanceSnapshotErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteInstanceSnapshotErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            DeleteInstanceSnapshotErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteInstanceSnapshotErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            DeleteInstanceSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteInstanceSnapshotError {
    fn code(&self) -> Option<&str> {
        DeleteInstanceSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteInstanceSnapshotError {
    /// Creates a new `DeleteInstanceSnapshotError`.
    pub fn new(kind: DeleteInstanceSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteInstanceSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteInstanceSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteInstanceSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteInstanceSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteInstanceSnapshotErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceSnapshotErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInstanceSnapshotErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceSnapshotErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInstanceSnapshotErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceSnapshotErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInstanceSnapshotErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceSnapshotErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInstanceSnapshotErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceSnapshotErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInstanceSnapshotErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceSnapshotErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInstanceSnapshotErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceSnapshotErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DeleteInstanceSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteInstanceSnapshotErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteInstanceSnapshotErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            DeleteInstanceSnapshotErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteInstanceSnapshotErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteInstanceSnapshotErrorKind::OperationFailureException(_inner) => Some(_inner),
            DeleteInstanceSnapshotErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteInstanceSnapshotErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            DeleteInstanceSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteKeyPair` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteKeyPairError {
    /// Kind of error that occurred.
    pub kind: DeleteKeyPairErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteKeyPair` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteKeyPairErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteKeyPairError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteKeyPairErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteKeyPairErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            DeleteKeyPairErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteKeyPairErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteKeyPairErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            DeleteKeyPairErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteKeyPairErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            DeleteKeyPairErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteKeyPairError {
    fn code(&self) -> Option<&str> {
        DeleteKeyPairError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteKeyPairError {
    /// Creates a new `DeleteKeyPairError`.
    pub fn new(kind: DeleteKeyPairErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteKeyPairError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteKeyPairErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteKeyPairError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteKeyPairErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteKeyPairErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteKeyPairErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteKeyPairErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteKeyPairErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteKeyPairErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DeleteKeyPairErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `DeleteKeyPairErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteKeyPairErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteKeyPairErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteKeyPairErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteKeyPairErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DeleteKeyPairErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DeleteKeyPairErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteKeyPairErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DeleteKeyPairError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteKeyPairErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteKeyPairErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            DeleteKeyPairErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteKeyPairErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteKeyPairErrorKind::OperationFailureException(_inner) => Some(_inner),
            DeleteKeyPairErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteKeyPairErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            DeleteKeyPairErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteKnownHostKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteKnownHostKeysError {
    /// Kind of error that occurred.
    pub kind: DeleteKnownHostKeysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteKnownHostKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteKnownHostKeysErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteKnownHostKeysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteKnownHostKeysErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteKnownHostKeysErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            DeleteKnownHostKeysErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteKnownHostKeysErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteKnownHostKeysErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            DeleteKnownHostKeysErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteKnownHostKeysErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            DeleteKnownHostKeysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteKnownHostKeysError {
    fn code(&self) -> Option<&str> {
        DeleteKnownHostKeysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteKnownHostKeysError {
    /// Creates a new `DeleteKnownHostKeysError`.
    pub fn new(kind: DeleteKnownHostKeysErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteKnownHostKeysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteKnownHostKeysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteKnownHostKeysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteKnownHostKeysErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteKnownHostKeysErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteKnownHostKeysErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteKnownHostKeysErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteKnownHostKeysErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteKnownHostKeysErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteKnownHostKeysErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteKnownHostKeysErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteKnownHostKeysErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteKnownHostKeysErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteKnownHostKeysErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteKnownHostKeysErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteKnownHostKeysErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteKnownHostKeysErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteKnownHostKeysErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DeleteKnownHostKeysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteKnownHostKeysErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteKnownHostKeysErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            DeleteKnownHostKeysErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteKnownHostKeysErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteKnownHostKeysErrorKind::OperationFailureException(_inner) => Some(_inner),
            DeleteKnownHostKeysErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteKnownHostKeysErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            DeleteKnownHostKeysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLoadBalancerError {
    /// Kind of error that occurred.
    pub kind: DeleteLoadBalancerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLoadBalancerErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLoadBalancerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLoadBalancerErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteLoadBalancerErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            DeleteLoadBalancerErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteLoadBalancerErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteLoadBalancerErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            DeleteLoadBalancerErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteLoadBalancerErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            DeleteLoadBalancerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLoadBalancerError {
    fn code(&self) -> Option<&str> {
        DeleteLoadBalancerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLoadBalancerError {
    /// Creates a new `DeleteLoadBalancerError`.
    pub fn new(kind: DeleteLoadBalancerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLoadBalancerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLoadBalancerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLoadBalancerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLoadBalancerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteLoadBalancerErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoadBalancerErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLoadBalancerErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoadBalancerErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLoadBalancerErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoadBalancerErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLoadBalancerErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoadBalancerErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLoadBalancerErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoadBalancerErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLoadBalancerErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DeleteLoadBalancerErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DeleteLoadBalancerErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoadBalancerErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DeleteLoadBalancerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLoadBalancerErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteLoadBalancerErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            DeleteLoadBalancerErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteLoadBalancerErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteLoadBalancerErrorKind::OperationFailureException(_inner) => Some(_inner),
            DeleteLoadBalancerErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteLoadBalancerErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            DeleteLoadBalancerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLoadBalancerTlsCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLoadBalancerTlsCertificateError {
    /// Kind of error that occurred.
    pub kind: DeleteLoadBalancerTlsCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLoadBalancerTlsCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLoadBalancerTlsCertificateErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLoadBalancerTlsCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLoadBalancerTlsCertificateErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLoadBalancerTlsCertificateErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLoadBalancerTlsCertificateErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLoadBalancerTlsCertificateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteLoadBalancerTlsCertificateErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLoadBalancerTlsCertificateErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteLoadBalancerTlsCertificateErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLoadBalancerTlsCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLoadBalancerTlsCertificateError {
    fn code(&self) -> Option<&str> {
        DeleteLoadBalancerTlsCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLoadBalancerTlsCertificateError {
    /// Creates a new `DeleteLoadBalancerTlsCertificateError`.
    pub fn new(
        kind: DeleteLoadBalancerTlsCertificateErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLoadBalancerTlsCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLoadBalancerTlsCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLoadBalancerTlsCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLoadBalancerTlsCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteLoadBalancerTlsCertificateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoadBalancerTlsCertificateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLoadBalancerTlsCertificateErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoadBalancerTlsCertificateErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLoadBalancerTlsCertificateErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoadBalancerTlsCertificateErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLoadBalancerTlsCertificateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoadBalancerTlsCertificateErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLoadBalancerTlsCertificateErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoadBalancerTlsCertificateErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLoadBalancerTlsCertificateErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoadBalancerTlsCertificateErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLoadBalancerTlsCertificateErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLoadBalancerTlsCertificateErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DeleteLoadBalancerTlsCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLoadBalancerTlsCertificateErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DeleteLoadBalancerTlsCertificateErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            DeleteLoadBalancerTlsCertificateErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            DeleteLoadBalancerTlsCertificateErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteLoadBalancerTlsCertificateErrorKind::OperationFailureException(_inner) => {
                Some(_inner)
            }
            DeleteLoadBalancerTlsCertificateErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteLoadBalancerTlsCertificateErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            DeleteLoadBalancerTlsCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRelationalDatabase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRelationalDatabaseError {
    /// Kind of error that occurred.
    pub kind: DeleteRelationalDatabaseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRelationalDatabase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRelationalDatabaseErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRelationalDatabaseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRelationalDatabaseErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteRelationalDatabaseErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRelationalDatabaseErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteRelationalDatabaseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteRelationalDatabaseErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            DeleteRelationalDatabaseErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteRelationalDatabaseErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            DeleteRelationalDatabaseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRelationalDatabaseError {
    fn code(&self) -> Option<&str> {
        DeleteRelationalDatabaseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRelationalDatabaseError {
    /// Creates a new `DeleteRelationalDatabaseError`.
    pub fn new(kind: DeleteRelationalDatabaseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRelationalDatabaseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRelationalDatabaseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRelationalDatabaseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRelationalDatabaseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRelationalDatabaseErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRelationalDatabaseErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRelationalDatabaseErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRelationalDatabaseErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRelationalDatabaseErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRelationalDatabaseErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRelationalDatabaseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRelationalDatabaseErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRelationalDatabaseErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRelationalDatabaseErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRelationalDatabaseErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRelationalDatabaseErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRelationalDatabaseErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRelationalDatabaseErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DeleteRelationalDatabaseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRelationalDatabaseErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteRelationalDatabaseErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            DeleteRelationalDatabaseErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteRelationalDatabaseErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteRelationalDatabaseErrorKind::OperationFailureException(_inner) => Some(_inner),
            DeleteRelationalDatabaseErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteRelationalDatabaseErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            DeleteRelationalDatabaseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRelationalDatabaseSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRelationalDatabaseSnapshotError {
    /// Kind of error that occurred.
    pub kind: DeleteRelationalDatabaseSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRelationalDatabaseSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRelationalDatabaseSnapshotErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRelationalDatabaseSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRelationalDatabaseSnapshotErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRelationalDatabaseSnapshotErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRelationalDatabaseSnapshotErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRelationalDatabaseSnapshotErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteRelationalDatabaseSnapshotErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRelationalDatabaseSnapshotErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DeleteRelationalDatabaseSnapshotErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteRelationalDatabaseSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRelationalDatabaseSnapshotError {
    fn code(&self) -> Option<&str> {
        DeleteRelationalDatabaseSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRelationalDatabaseSnapshotError {
    /// Creates a new `DeleteRelationalDatabaseSnapshotError`.
    pub fn new(
        kind: DeleteRelationalDatabaseSnapshotErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRelationalDatabaseSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRelationalDatabaseSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRelationalDatabaseSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRelationalDatabaseSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRelationalDatabaseSnapshotErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRelationalDatabaseSnapshotErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRelationalDatabaseSnapshotErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRelationalDatabaseSnapshotErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRelationalDatabaseSnapshotErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRelationalDatabaseSnapshotErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRelationalDatabaseSnapshotErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRelationalDatabaseSnapshotErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRelationalDatabaseSnapshotErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRelationalDatabaseSnapshotErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRelationalDatabaseSnapshotErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRelationalDatabaseSnapshotErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRelationalDatabaseSnapshotErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRelationalDatabaseSnapshotErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DeleteRelationalDatabaseSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRelationalDatabaseSnapshotErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DeleteRelationalDatabaseSnapshotErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            DeleteRelationalDatabaseSnapshotErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            DeleteRelationalDatabaseSnapshotErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteRelationalDatabaseSnapshotErrorKind::OperationFailureException(_inner) => {
                Some(_inner)
            }
            DeleteRelationalDatabaseSnapshotErrorKind::ServiceException(_inner) => Some(_inner),
            DeleteRelationalDatabaseSnapshotErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            DeleteRelationalDatabaseSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetachCertificateFromDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetachCertificateFromDistributionError {
    /// Kind of error that occurred.
    pub kind: DetachCertificateFromDistributionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetachCertificateFromDistribution` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetachCertificateFromDistributionErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetachCertificateFromDistributionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetachCertificateFromDistributionErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DetachCertificateFromDistributionErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            DetachCertificateFromDistributionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DetachCertificateFromDistributionErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            DetachCertificateFromDistributionErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DetachCertificateFromDistributionErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            DetachCertificateFromDistributionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetachCertificateFromDistributionError {
    fn code(&self) -> Option<&str> {
        DetachCertificateFromDistributionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetachCertificateFromDistributionError {
    /// Creates a new `DetachCertificateFromDistributionError`.
    pub fn new(
        kind: DetachCertificateFromDistributionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetachCertificateFromDistributionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetachCertificateFromDistributionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetachCertificateFromDistributionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetachCertificateFromDistributionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetachCertificateFromDistributionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachCertificateFromDistributionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachCertificateFromDistributionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachCertificateFromDistributionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachCertificateFromDistributionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachCertificateFromDistributionErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachCertificateFromDistributionErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachCertificateFromDistributionErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachCertificateFromDistributionErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachCertificateFromDistributionErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachCertificateFromDistributionErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachCertificateFromDistributionErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DetachCertificateFromDistributionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetachCertificateFromDistributionErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DetachCertificateFromDistributionErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            DetachCertificateFromDistributionErrorKind::NotFoundException(_inner) => Some(_inner),
            DetachCertificateFromDistributionErrorKind::OperationFailureException(_inner) => {
                Some(_inner)
            }
            DetachCertificateFromDistributionErrorKind::ServiceException(_inner) => Some(_inner),
            DetachCertificateFromDistributionErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            DetachCertificateFromDistributionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetachDisk` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetachDiskError {
    /// Kind of error that occurred.
    pub kind: DetachDiskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetachDisk` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetachDiskErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetachDiskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetachDiskErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DetachDiskErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            DetachDiskErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DetachDiskErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DetachDiskErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            DetachDiskErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DetachDiskErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            DetachDiskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetachDiskError {
    fn code(&self) -> Option<&str> {
        DetachDiskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetachDiskError {
    /// Creates a new `DetachDiskError`.
    pub fn new(kind: DetachDiskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetachDiskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetachDiskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetachDiskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetachDiskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetachDiskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DetachDiskErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DetachDiskErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachDiskErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachDiskErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DetachDiskErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `DetachDiskErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DetachDiskErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DetachDiskErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachDiskErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachDiskErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DetachDiskErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DetachDiskErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(&self.kind, DetachDiskErrorKind::UnauthenticatedException(_))
    }
}
impl std::error::Error for DetachDiskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetachDiskErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DetachDiskErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            DetachDiskErrorKind::InvalidInputException(_inner) => Some(_inner),
            DetachDiskErrorKind::NotFoundException(_inner) => Some(_inner),
            DetachDiskErrorKind::OperationFailureException(_inner) => Some(_inner),
            DetachDiskErrorKind::ServiceException(_inner) => Some(_inner),
            DetachDiskErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            DetachDiskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetachInstancesFromLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetachInstancesFromLoadBalancerError {
    /// Kind of error that occurred.
    pub kind: DetachInstancesFromLoadBalancerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetachInstancesFromLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetachInstancesFromLoadBalancerErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetachInstancesFromLoadBalancerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetachInstancesFromLoadBalancerErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DetachInstancesFromLoadBalancerErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            DetachInstancesFromLoadBalancerErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            DetachInstancesFromLoadBalancerErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DetachInstancesFromLoadBalancerErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            DetachInstancesFromLoadBalancerErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DetachInstancesFromLoadBalancerErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            DetachInstancesFromLoadBalancerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetachInstancesFromLoadBalancerError {
    fn code(&self) -> Option<&str> {
        DetachInstancesFromLoadBalancerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetachInstancesFromLoadBalancerError {
    /// Creates a new `DetachInstancesFromLoadBalancerError`.
    pub fn new(
        kind: DetachInstancesFromLoadBalancerErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetachInstancesFromLoadBalancerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetachInstancesFromLoadBalancerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetachInstancesFromLoadBalancerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetachInstancesFromLoadBalancerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetachInstancesFromLoadBalancerErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachInstancesFromLoadBalancerErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachInstancesFromLoadBalancerErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachInstancesFromLoadBalancerErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachInstancesFromLoadBalancerErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachInstancesFromLoadBalancerErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachInstancesFromLoadBalancerErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachInstancesFromLoadBalancerErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachInstancesFromLoadBalancerErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachInstancesFromLoadBalancerErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachInstancesFromLoadBalancerErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachInstancesFromLoadBalancerErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachInstancesFromLoadBalancerErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachInstancesFromLoadBalancerErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DetachInstancesFromLoadBalancerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetachInstancesFromLoadBalancerErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DetachInstancesFromLoadBalancerErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            DetachInstancesFromLoadBalancerErrorKind::InvalidInputException(_inner) => Some(_inner),
            DetachInstancesFromLoadBalancerErrorKind::NotFoundException(_inner) => Some(_inner),
            DetachInstancesFromLoadBalancerErrorKind::OperationFailureException(_inner) => {
                Some(_inner)
            }
            DetachInstancesFromLoadBalancerErrorKind::ServiceException(_inner) => Some(_inner),
            DetachInstancesFromLoadBalancerErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            DetachInstancesFromLoadBalancerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetachStaticIp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetachStaticIpError {
    /// Kind of error that occurred.
    pub kind: DetachStaticIpErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetachStaticIp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetachStaticIpErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetachStaticIpError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetachStaticIpErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DetachStaticIpErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            DetachStaticIpErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DetachStaticIpErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DetachStaticIpErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            DetachStaticIpErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DetachStaticIpErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            DetachStaticIpErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetachStaticIpError {
    fn code(&self) -> Option<&str> {
        DetachStaticIpError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetachStaticIpError {
    /// Creates a new `DetachStaticIpError`.
    pub fn new(kind: DetachStaticIpErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetachStaticIpError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetachStaticIpErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetachStaticIpError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetachStaticIpErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DetachStaticIpErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachStaticIpErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachStaticIpErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachStaticIpErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachStaticIpErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachStaticIpErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachStaticIpErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DetachStaticIpErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DetachStaticIpErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachStaticIpErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DetachStaticIpErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DetachStaticIpErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DetachStaticIpErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetachStaticIpErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DetachStaticIpError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetachStaticIpErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DetachStaticIpErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            DetachStaticIpErrorKind::InvalidInputException(_inner) => Some(_inner),
            DetachStaticIpErrorKind::NotFoundException(_inner) => Some(_inner),
            DetachStaticIpErrorKind::OperationFailureException(_inner) => Some(_inner),
            DetachStaticIpErrorKind::ServiceException(_inner) => Some(_inner),
            DetachStaticIpErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            DetachStaticIpErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableAddOn` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableAddOnError {
    /// Kind of error that occurred.
    pub kind: DisableAddOnErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableAddOn` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableAddOnErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableAddOnError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableAddOnErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisableAddOnErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DisableAddOnErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DisableAddOnErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            DisableAddOnErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DisableAddOnErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            DisableAddOnErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableAddOnError {
    fn code(&self) -> Option<&str> {
        DisableAddOnError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableAddOnError {
    /// Creates a new `DisableAddOnError`.
    pub fn new(kind: DisableAddOnErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableAddOnError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableAddOnErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableAddOnError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableAddOnErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableAddOnErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DisableAddOnErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DisableAddOnErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DisableAddOnErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `DisableAddOnErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DisableAddOnErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DisableAddOnErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableAddOnErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableAddOnErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, DisableAddOnErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `DisableAddOnErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableAddOnErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DisableAddOnError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableAddOnErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisableAddOnErrorKind::InvalidInputException(_inner) => Some(_inner),
            DisableAddOnErrorKind::NotFoundException(_inner) => Some(_inner),
            DisableAddOnErrorKind::OperationFailureException(_inner) => Some(_inner),
            DisableAddOnErrorKind::ServiceException(_inner) => Some(_inner),
            DisableAddOnErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            DisableAddOnErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DownloadDefaultKeyPair` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DownloadDefaultKeyPairError {
    /// Kind of error that occurred.
    pub kind: DownloadDefaultKeyPairErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DownloadDefaultKeyPair` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DownloadDefaultKeyPairErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DownloadDefaultKeyPairError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DownloadDefaultKeyPairErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DownloadDefaultKeyPairErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            DownloadDefaultKeyPairErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DownloadDefaultKeyPairErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DownloadDefaultKeyPairErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            DownloadDefaultKeyPairErrorKind::ServiceException(_inner) => _inner.fmt(f),
            DownloadDefaultKeyPairErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            DownloadDefaultKeyPairErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DownloadDefaultKeyPairError {
    fn code(&self) -> Option<&str> {
        DownloadDefaultKeyPairError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DownloadDefaultKeyPairError {
    /// Creates a new `DownloadDefaultKeyPairError`.
    pub fn new(kind: DownloadDefaultKeyPairErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DownloadDefaultKeyPairError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DownloadDefaultKeyPairErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DownloadDefaultKeyPairError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DownloadDefaultKeyPairErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DownloadDefaultKeyPairErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DownloadDefaultKeyPairErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DownloadDefaultKeyPairErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            DownloadDefaultKeyPairErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `DownloadDefaultKeyPairErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DownloadDefaultKeyPairErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DownloadDefaultKeyPairErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DownloadDefaultKeyPairErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DownloadDefaultKeyPairErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            DownloadDefaultKeyPairErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `DownloadDefaultKeyPairErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DownloadDefaultKeyPairErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DownloadDefaultKeyPairErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            DownloadDefaultKeyPairErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for DownloadDefaultKeyPairError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DownloadDefaultKeyPairErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DownloadDefaultKeyPairErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            DownloadDefaultKeyPairErrorKind::InvalidInputException(_inner) => Some(_inner),
            DownloadDefaultKeyPairErrorKind::NotFoundException(_inner) => Some(_inner),
            DownloadDefaultKeyPairErrorKind::OperationFailureException(_inner) => Some(_inner),
            DownloadDefaultKeyPairErrorKind::ServiceException(_inner) => Some(_inner),
            DownloadDefaultKeyPairErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            DownloadDefaultKeyPairErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableAddOn` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableAddOnError {
    /// Kind of error that occurred.
    pub kind: EnableAddOnErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableAddOn` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableAddOnErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableAddOnError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableAddOnErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            EnableAddOnErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            EnableAddOnErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            EnableAddOnErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            EnableAddOnErrorKind::ServiceException(_inner) => _inner.fmt(f),
            EnableAddOnErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            EnableAddOnErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableAddOnError {
    fn code(&self) -> Option<&str> {
        EnableAddOnError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableAddOnError {
    /// Creates a new `EnableAddOnError`.
    pub fn new(kind: EnableAddOnErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableAddOnError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableAddOnErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableAddOnError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableAddOnErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableAddOnErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, EnableAddOnErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `EnableAddOnErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, EnableAddOnErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `EnableAddOnErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, EnableAddOnErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `EnableAddOnErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableAddOnErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableAddOnErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, EnableAddOnErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `EnableAddOnErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableAddOnErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for EnableAddOnError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableAddOnErrorKind::AccessDeniedException(_inner) => Some(_inner),
            EnableAddOnErrorKind::InvalidInputException(_inner) => Some(_inner),
            EnableAddOnErrorKind::NotFoundException(_inner) => Some(_inner),
            EnableAddOnErrorKind::OperationFailureException(_inner) => Some(_inner),
            EnableAddOnErrorKind::ServiceException(_inner) => Some(_inner),
            EnableAddOnErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            EnableAddOnErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExportSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExportSnapshotError {
    /// Kind of error that occurred.
    pub kind: ExportSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExportSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExportSnapshotErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExportSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExportSnapshotErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ExportSnapshotErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            ExportSnapshotErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ExportSnapshotErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ExportSnapshotErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            ExportSnapshotErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ExportSnapshotErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            ExportSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExportSnapshotError {
    fn code(&self) -> Option<&str> {
        ExportSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExportSnapshotError {
    /// Creates a new `ExportSnapshotError`.
    pub fn new(kind: ExportSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExportSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExportSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExportSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExportSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ExportSnapshotErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportSnapshotErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ExportSnapshotErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportSnapshotErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `ExportSnapshotErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportSnapshotErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ExportSnapshotErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ExportSnapshotErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ExportSnapshotErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportSnapshotErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ExportSnapshotErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, ExportSnapshotErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `ExportSnapshotErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExportSnapshotErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for ExportSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExportSnapshotErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ExportSnapshotErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            ExportSnapshotErrorKind::InvalidInputException(_inner) => Some(_inner),
            ExportSnapshotErrorKind::NotFoundException(_inner) => Some(_inner),
            ExportSnapshotErrorKind::OperationFailureException(_inner) => Some(_inner),
            ExportSnapshotErrorKind::ServiceException(_inner) => Some(_inner),
            ExportSnapshotErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            ExportSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetActiveNames` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetActiveNamesError {
    /// Kind of error that occurred.
    pub kind: GetActiveNamesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetActiveNames` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetActiveNamesErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetActiveNamesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetActiveNamesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetActiveNamesErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            GetActiveNamesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetActiveNamesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetActiveNamesErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetActiveNamesErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetActiveNamesErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetActiveNamesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetActiveNamesError {
    fn code(&self) -> Option<&str> {
        GetActiveNamesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetActiveNamesError {
    /// Creates a new `GetActiveNamesError`.
    pub fn new(kind: GetActiveNamesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetActiveNamesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetActiveNamesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetActiveNamesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetActiveNamesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetActiveNamesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetActiveNamesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetActiveNamesErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetActiveNamesErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetActiveNamesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetActiveNamesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetActiveNamesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetActiveNamesErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetActiveNamesErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetActiveNamesErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetActiveNamesErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetActiveNamesErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetActiveNamesErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetActiveNamesErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetActiveNamesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetActiveNamesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetActiveNamesErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetActiveNamesErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetActiveNamesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetActiveNamesErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetActiveNamesErrorKind::ServiceException(_inner) => Some(_inner),
            GetActiveNamesErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetActiveNamesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAlarms` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAlarmsError {
    /// Kind of error that occurred.
    pub kind: GetAlarmsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAlarms` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAlarmsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAlarmsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAlarmsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetAlarmsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetAlarmsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetAlarmsErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetAlarmsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetAlarmsErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetAlarmsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAlarmsError {
    fn code(&self) -> Option<&str> {
        GetAlarmsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAlarmsError {
    /// Creates a new `GetAlarmsError`.
    pub fn new(kind: GetAlarmsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAlarmsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAlarmsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAlarmsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAlarmsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAlarmsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetAlarmsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetAlarmsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetAlarmsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetAlarmsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetAlarmsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetAlarmsErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(&self.kind, GetAlarmsErrorKind::OperationFailureException(_))
    }
    /// Returns `true` if the error kind is `GetAlarmsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetAlarmsErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetAlarmsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(&self.kind, GetAlarmsErrorKind::UnauthenticatedException(_))
    }
}
impl std::error::Error for GetAlarmsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAlarmsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetAlarmsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetAlarmsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetAlarmsErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetAlarmsErrorKind::ServiceException(_inner) => Some(_inner),
            GetAlarmsErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetAlarmsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAutoSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAutoSnapshotsError {
    /// Kind of error that occurred.
    pub kind: GetAutoSnapshotsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAutoSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAutoSnapshotsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAutoSnapshotsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAutoSnapshotsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetAutoSnapshotsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetAutoSnapshotsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetAutoSnapshotsErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetAutoSnapshotsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetAutoSnapshotsErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetAutoSnapshotsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAutoSnapshotsError {
    fn code(&self) -> Option<&str> {
        GetAutoSnapshotsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAutoSnapshotsError {
    /// Creates a new `GetAutoSnapshotsError`.
    pub fn new(kind: GetAutoSnapshotsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAutoSnapshotsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAutoSnapshotsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAutoSnapshotsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAutoSnapshotsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAutoSnapshotsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAutoSnapshotsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAutoSnapshotsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAutoSnapshotsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAutoSnapshotsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetAutoSnapshotsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetAutoSnapshotsErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAutoSnapshotsErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAutoSnapshotsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetAutoSnapshotsErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetAutoSnapshotsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAutoSnapshotsErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetAutoSnapshotsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAutoSnapshotsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetAutoSnapshotsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetAutoSnapshotsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetAutoSnapshotsErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetAutoSnapshotsErrorKind::ServiceException(_inner) => Some(_inner),
            GetAutoSnapshotsErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetAutoSnapshotsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBlueprints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBlueprintsError {
    /// Kind of error that occurred.
    pub kind: GetBlueprintsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBlueprints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBlueprintsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBlueprintsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBlueprintsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetBlueprintsErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            GetBlueprintsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetBlueprintsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetBlueprintsErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetBlueprintsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetBlueprintsErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetBlueprintsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBlueprintsError {
    fn code(&self) -> Option<&str> {
        GetBlueprintsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBlueprintsError {
    /// Creates a new `GetBlueprintsError`.
    pub fn new(kind: GetBlueprintsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBlueprintsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBlueprintsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBlueprintsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBlueprintsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBlueprintsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetBlueprintsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetBlueprintsErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlueprintsErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBlueprintsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetBlueprintsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetBlueprintsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetBlueprintsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetBlueprintsErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlueprintsErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBlueprintsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetBlueprintsErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetBlueprintsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBlueprintsErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetBlueprintsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBlueprintsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetBlueprintsErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetBlueprintsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetBlueprintsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetBlueprintsErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetBlueprintsErrorKind::ServiceException(_inner) => Some(_inner),
            GetBlueprintsErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetBlueprintsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBucketAccessKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBucketAccessKeysError {
    /// Kind of error that occurred.
    pub kind: GetBucketAccessKeysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBucketAccessKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBucketAccessKeysErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBucketAccessKeysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBucketAccessKeysErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetBucketAccessKeysErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetBucketAccessKeysErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetBucketAccessKeysErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetBucketAccessKeysErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetBucketAccessKeysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBucketAccessKeysError {
    fn code(&self) -> Option<&str> {
        GetBucketAccessKeysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBucketAccessKeysError {
    /// Creates a new `GetBucketAccessKeysError`.
    pub fn new(kind: GetBucketAccessKeysErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBucketAccessKeysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBucketAccessKeysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBucketAccessKeysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBucketAccessKeysErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBucketAccessKeysErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketAccessKeysErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketAccessKeysErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketAccessKeysErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketAccessKeysErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketAccessKeysErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketAccessKeysErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketAccessKeysErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketAccessKeysErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketAccessKeysErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetBucketAccessKeysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBucketAccessKeysErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetBucketAccessKeysErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetBucketAccessKeysErrorKind::NotFoundException(_inner) => Some(_inner),
            GetBucketAccessKeysErrorKind::ServiceException(_inner) => Some(_inner),
            GetBucketAccessKeysErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetBucketAccessKeysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBucketBundles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBucketBundlesError {
    /// Kind of error that occurred.
    pub kind: GetBucketBundlesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBucketBundles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBucketBundlesErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBucketBundlesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBucketBundlesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetBucketBundlesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetBucketBundlesErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetBucketBundlesErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetBucketBundlesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBucketBundlesError {
    fn code(&self) -> Option<&str> {
        GetBucketBundlesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBucketBundlesError {
    /// Creates a new `GetBucketBundlesError`.
    pub fn new(kind: GetBucketBundlesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBucketBundlesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBucketBundlesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBucketBundlesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBucketBundlesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBucketBundlesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketBundlesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketBundlesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketBundlesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketBundlesErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetBucketBundlesErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetBucketBundlesErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketBundlesErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetBucketBundlesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBucketBundlesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetBucketBundlesErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetBucketBundlesErrorKind::ServiceException(_inner) => Some(_inner),
            GetBucketBundlesErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetBucketBundlesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBucketMetricData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBucketMetricDataError {
    /// Kind of error that occurred.
    pub kind: GetBucketMetricDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBucketMetricData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBucketMetricDataErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBucketMetricDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBucketMetricDataErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetBucketMetricDataErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetBucketMetricDataErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetBucketMetricDataErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetBucketMetricDataErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetBucketMetricDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBucketMetricDataError {
    fn code(&self) -> Option<&str> {
        GetBucketMetricDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBucketMetricDataError {
    /// Creates a new `GetBucketMetricDataError`.
    pub fn new(kind: GetBucketMetricDataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBucketMetricDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBucketMetricDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBucketMetricDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBucketMetricDataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBucketMetricDataErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketMetricDataErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketMetricDataErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketMetricDataErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketMetricDataErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketMetricDataErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketMetricDataErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketMetricDataErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketMetricDataErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketMetricDataErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetBucketMetricDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBucketMetricDataErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetBucketMetricDataErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetBucketMetricDataErrorKind::NotFoundException(_inner) => Some(_inner),
            GetBucketMetricDataErrorKind::ServiceException(_inner) => Some(_inner),
            GetBucketMetricDataErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetBucketMetricDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBuckets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBucketsError {
    /// Kind of error that occurred.
    pub kind: GetBucketsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBuckets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBucketsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBucketsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBucketsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetBucketsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetBucketsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetBucketsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetBucketsErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetBucketsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBucketsError {
    fn code(&self) -> Option<&str> {
        GetBucketsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBucketsError {
    /// Creates a new `GetBucketsError`.
    pub fn new(kind: GetBucketsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBucketsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBucketsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBucketsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBucketsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBucketsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetBucketsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetBucketsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetBucketsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetBucketsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetBucketsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetBucketsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetBucketsErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetBucketsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(&self.kind, GetBucketsErrorKind::UnauthenticatedException(_))
    }
}
impl std::error::Error for GetBucketsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBucketsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetBucketsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetBucketsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetBucketsErrorKind::ServiceException(_inner) => Some(_inner),
            GetBucketsErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetBucketsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBundles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBundlesError {
    /// Kind of error that occurred.
    pub kind: GetBundlesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBundles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBundlesErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBundlesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBundlesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetBundlesErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            GetBundlesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetBundlesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetBundlesErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetBundlesErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetBundlesErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetBundlesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBundlesError {
    fn code(&self) -> Option<&str> {
        GetBundlesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBundlesError {
    /// Creates a new `GetBundlesError`.
    pub fn new(kind: GetBundlesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBundlesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBundlesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBundlesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBundlesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBundlesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetBundlesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetBundlesErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBundlesErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBundlesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetBundlesErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetBundlesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetBundlesErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetBundlesErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBundlesErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBundlesErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetBundlesErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetBundlesErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(&self.kind, GetBundlesErrorKind::UnauthenticatedException(_))
    }
}
impl std::error::Error for GetBundlesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBundlesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetBundlesErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetBundlesErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetBundlesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetBundlesErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetBundlesErrorKind::ServiceException(_inner) => Some(_inner),
            GetBundlesErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetBundlesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCertificatesError {
    /// Kind of error that occurred.
    pub kind: GetCertificatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCertificatesErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCertificatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCertificatesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetCertificatesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetCertificatesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetCertificatesErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetCertificatesErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetCertificatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCertificatesError {
    fn code(&self) -> Option<&str> {
        GetCertificatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCertificatesError {
    /// Creates a new `GetCertificatesError`.
    pub fn new(kind: GetCertificatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCertificatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCertificatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCertificatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCertificatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCertificatesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCertificatesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCertificatesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCertificatesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCertificatesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetCertificatesErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetCertificatesErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetCertificatesErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetCertificatesErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCertificatesErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetCertificatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCertificatesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetCertificatesErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetCertificatesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetCertificatesErrorKind::ServiceException(_inner) => Some(_inner),
            GetCertificatesErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetCertificatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCloudFormationStackRecords` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCloudFormationStackRecordsError {
    /// Kind of error that occurred.
    pub kind: GetCloudFormationStackRecordsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCloudFormationStackRecords` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCloudFormationStackRecordsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCloudFormationStackRecordsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCloudFormationStackRecordsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetCloudFormationStackRecordsErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            GetCloudFormationStackRecordsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetCloudFormationStackRecordsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetCloudFormationStackRecordsErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetCloudFormationStackRecordsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetCloudFormationStackRecordsErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            GetCloudFormationStackRecordsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCloudFormationStackRecordsError {
    fn code(&self) -> Option<&str> {
        GetCloudFormationStackRecordsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCloudFormationStackRecordsError {
    /// Creates a new `GetCloudFormationStackRecordsError`.
    pub fn new(
        kind: GetCloudFormationStackRecordsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCloudFormationStackRecordsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCloudFormationStackRecordsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCloudFormationStackRecordsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCloudFormationStackRecordsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCloudFormationStackRecordsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCloudFormationStackRecordsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCloudFormationStackRecordsErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCloudFormationStackRecordsErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCloudFormationStackRecordsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCloudFormationStackRecordsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCloudFormationStackRecordsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCloudFormationStackRecordsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCloudFormationStackRecordsErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCloudFormationStackRecordsErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCloudFormationStackRecordsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCloudFormationStackRecordsErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCloudFormationStackRecordsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCloudFormationStackRecordsErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetCloudFormationStackRecordsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCloudFormationStackRecordsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetCloudFormationStackRecordsErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            GetCloudFormationStackRecordsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetCloudFormationStackRecordsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetCloudFormationStackRecordsErrorKind::OperationFailureException(_inner) => {
                Some(_inner)
            }
            GetCloudFormationStackRecordsErrorKind::ServiceException(_inner) => Some(_inner),
            GetCloudFormationStackRecordsErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            GetCloudFormationStackRecordsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetContactMethods` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetContactMethodsError {
    /// Kind of error that occurred.
    pub kind: GetContactMethodsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetContactMethods` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetContactMethodsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetContactMethodsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetContactMethodsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetContactMethodsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetContactMethodsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetContactMethodsErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetContactMethodsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetContactMethodsErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetContactMethodsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetContactMethodsError {
    fn code(&self) -> Option<&str> {
        GetContactMethodsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetContactMethodsError {
    /// Creates a new `GetContactMethodsError`.
    pub fn new(kind: GetContactMethodsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetContactMethodsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetContactMethodsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetContactMethodsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetContactMethodsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetContactMethodsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContactMethodsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContactMethodsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContactMethodsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContactMethodsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetContactMethodsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetContactMethodsErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContactMethodsErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContactMethodsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetContactMethodsErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetContactMethodsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContactMethodsErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetContactMethodsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetContactMethodsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetContactMethodsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetContactMethodsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetContactMethodsErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetContactMethodsErrorKind::ServiceException(_inner) => Some(_inner),
            GetContactMethodsErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetContactMethodsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetContainerAPIMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetContainerAPIMetadataError {
    /// Kind of error that occurred.
    pub kind: GetContainerAPIMetadataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetContainerAPIMetadata` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetContainerAPIMetadataErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetContainerAPIMetadataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetContainerAPIMetadataErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetContainerAPIMetadataErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetContainerAPIMetadataErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetContainerAPIMetadataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetContainerAPIMetadataError {
    fn code(&self) -> Option<&str> {
        GetContainerAPIMetadataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetContainerAPIMetadataError {
    /// Creates a new `GetContainerAPIMetadataError`.
    pub fn new(kind: GetContainerAPIMetadataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetContainerAPIMetadataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetContainerAPIMetadataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetContainerAPIMetadataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetContainerAPIMetadataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetContainerAPIMetadataErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerAPIMetadataErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContainerAPIMetadataErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerAPIMetadataErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContainerAPIMetadataErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerAPIMetadataErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetContainerAPIMetadataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetContainerAPIMetadataErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetContainerAPIMetadataErrorKind::ServiceException(_inner) => Some(_inner),
            GetContainerAPIMetadataErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetContainerAPIMetadataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetContainerImages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetContainerImagesError {
    /// Kind of error that occurred.
    pub kind: GetContainerImagesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetContainerImages` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetContainerImagesErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetContainerImagesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetContainerImagesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetContainerImagesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetContainerImagesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetContainerImagesErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetContainerImagesErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetContainerImagesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetContainerImagesError {
    fn code(&self) -> Option<&str> {
        GetContainerImagesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetContainerImagesError {
    /// Creates a new `GetContainerImagesError`.
    pub fn new(kind: GetContainerImagesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetContainerImagesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetContainerImagesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetContainerImagesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetContainerImagesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetContainerImagesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerImagesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContainerImagesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerImagesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContainerImagesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerImagesErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContainerImagesErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetContainerImagesErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetContainerImagesErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerImagesErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetContainerImagesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetContainerImagesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetContainerImagesErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetContainerImagesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetContainerImagesErrorKind::ServiceException(_inner) => Some(_inner),
            GetContainerImagesErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetContainerImagesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetContainerLog` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetContainerLogError {
    /// Kind of error that occurred.
    pub kind: GetContainerLogErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetContainerLog` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetContainerLogErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetContainerLogError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetContainerLogErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetContainerLogErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetContainerLogErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetContainerLogErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetContainerLogErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetContainerLogErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetContainerLogError {
    fn code(&self) -> Option<&str> {
        GetContainerLogError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetContainerLogError {
    /// Creates a new `GetContainerLogError`.
    pub fn new(kind: GetContainerLogErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetContainerLogError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetContainerLogErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetContainerLogError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetContainerLogErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetContainerLogErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerLogErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContainerLogErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerLogErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContainerLogErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetContainerLogErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetContainerLogErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetContainerLogErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetContainerLogErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerLogErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetContainerLogError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetContainerLogErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetContainerLogErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetContainerLogErrorKind::NotFoundException(_inner) => Some(_inner),
            GetContainerLogErrorKind::ServiceException(_inner) => Some(_inner),
            GetContainerLogErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetContainerLogErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetContainerServiceDeployments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetContainerServiceDeploymentsError {
    /// Kind of error that occurred.
    pub kind: GetContainerServiceDeploymentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetContainerServiceDeployments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetContainerServiceDeploymentsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetContainerServiceDeploymentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetContainerServiceDeploymentsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetContainerServiceDeploymentsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetContainerServiceDeploymentsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetContainerServiceDeploymentsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetContainerServiceDeploymentsErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            GetContainerServiceDeploymentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetContainerServiceDeploymentsError {
    fn code(&self) -> Option<&str> {
        GetContainerServiceDeploymentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetContainerServiceDeploymentsError {
    /// Creates a new `GetContainerServiceDeploymentsError`.
    pub fn new(
        kind: GetContainerServiceDeploymentsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetContainerServiceDeploymentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetContainerServiceDeploymentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetContainerServiceDeploymentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetContainerServiceDeploymentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetContainerServiceDeploymentsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerServiceDeploymentsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContainerServiceDeploymentsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerServiceDeploymentsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContainerServiceDeploymentsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerServiceDeploymentsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContainerServiceDeploymentsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerServiceDeploymentsErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContainerServiceDeploymentsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerServiceDeploymentsErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetContainerServiceDeploymentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetContainerServiceDeploymentsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetContainerServiceDeploymentsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetContainerServiceDeploymentsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetContainerServiceDeploymentsErrorKind::ServiceException(_inner) => Some(_inner),
            GetContainerServiceDeploymentsErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            GetContainerServiceDeploymentsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetContainerServiceMetricData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetContainerServiceMetricDataError {
    /// Kind of error that occurred.
    pub kind: GetContainerServiceMetricDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetContainerServiceMetricData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetContainerServiceMetricDataErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetContainerServiceMetricDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetContainerServiceMetricDataErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetContainerServiceMetricDataErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetContainerServiceMetricDataErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetContainerServiceMetricDataErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetContainerServiceMetricDataErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            GetContainerServiceMetricDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetContainerServiceMetricDataError {
    fn code(&self) -> Option<&str> {
        GetContainerServiceMetricDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetContainerServiceMetricDataError {
    /// Creates a new `GetContainerServiceMetricDataError`.
    pub fn new(
        kind: GetContainerServiceMetricDataErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetContainerServiceMetricDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetContainerServiceMetricDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetContainerServiceMetricDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetContainerServiceMetricDataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetContainerServiceMetricDataErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerServiceMetricDataErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContainerServiceMetricDataErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerServiceMetricDataErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContainerServiceMetricDataErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerServiceMetricDataErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContainerServiceMetricDataErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerServiceMetricDataErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContainerServiceMetricDataErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerServiceMetricDataErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetContainerServiceMetricDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetContainerServiceMetricDataErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetContainerServiceMetricDataErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetContainerServiceMetricDataErrorKind::NotFoundException(_inner) => Some(_inner),
            GetContainerServiceMetricDataErrorKind::ServiceException(_inner) => Some(_inner),
            GetContainerServiceMetricDataErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            GetContainerServiceMetricDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetContainerServicePowers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetContainerServicePowersError {
    /// Kind of error that occurred.
    pub kind: GetContainerServicePowersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetContainerServicePowers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetContainerServicePowersErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetContainerServicePowersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetContainerServicePowersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetContainerServicePowersErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetContainerServicePowersErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetContainerServicePowersErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetContainerServicePowersErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetContainerServicePowersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetContainerServicePowersError {
    fn code(&self) -> Option<&str> {
        GetContainerServicePowersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetContainerServicePowersError {
    /// Creates a new `GetContainerServicePowersError`.
    pub fn new(kind: GetContainerServicePowersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetContainerServicePowersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetContainerServicePowersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetContainerServicePowersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetContainerServicePowersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetContainerServicePowersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerServicePowersErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContainerServicePowersErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerServicePowersErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContainerServicePowersErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerServicePowersErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContainerServicePowersErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerServicePowersErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContainerServicePowersErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerServicePowersErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetContainerServicePowersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetContainerServicePowersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetContainerServicePowersErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetContainerServicePowersErrorKind::NotFoundException(_inner) => Some(_inner),
            GetContainerServicePowersErrorKind::ServiceException(_inner) => Some(_inner),
            GetContainerServicePowersErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetContainerServicePowersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetContainerServices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetContainerServicesError {
    /// Kind of error that occurred.
    pub kind: GetContainerServicesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetContainerServices` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetContainerServicesErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetContainerServicesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetContainerServicesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetContainerServicesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetContainerServicesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetContainerServicesErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetContainerServicesErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetContainerServicesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetContainerServicesError {
    fn code(&self) -> Option<&str> {
        GetContainerServicesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetContainerServicesError {
    /// Creates a new `GetContainerServicesError`.
    pub fn new(kind: GetContainerServicesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetContainerServicesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetContainerServicesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetContainerServicesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetContainerServicesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetContainerServicesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerServicesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContainerServicesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerServicesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContainerServicesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerServicesErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContainerServicesErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerServicesErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContainerServicesErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContainerServicesErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetContainerServicesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetContainerServicesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetContainerServicesErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetContainerServicesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetContainerServicesErrorKind::ServiceException(_inner) => Some(_inner),
            GetContainerServicesErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetContainerServicesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDisk` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDiskError {
    /// Kind of error that occurred.
    pub kind: GetDiskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDisk` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDiskErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDiskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDiskErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDiskErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            GetDiskErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetDiskErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDiskErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetDiskErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetDiskErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetDiskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDiskError {
    fn code(&self) -> Option<&str> {
        GetDiskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDiskError {
    /// Creates a new `GetDiskError`.
    pub fn new(kind: GetDiskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDiskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDiskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDiskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDiskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDiskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetDiskErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetDiskErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDiskErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDiskErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetDiskErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetDiskErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDiskErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetDiskErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(&self.kind, GetDiskErrorKind::OperationFailureException(_))
    }
    /// Returns `true` if the error kind is `GetDiskErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetDiskErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetDiskErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(&self.kind, GetDiskErrorKind::UnauthenticatedException(_))
    }
}
impl std::error::Error for GetDiskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDiskErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDiskErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetDiskErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetDiskErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDiskErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetDiskErrorKind::ServiceException(_inner) => Some(_inner),
            GetDiskErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetDiskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDisks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDisksError {
    /// Kind of error that occurred.
    pub kind: GetDisksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDisks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDisksErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDisksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDisksErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDisksErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            GetDisksErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetDisksErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDisksErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetDisksErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetDisksErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetDisksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDisksError {
    fn code(&self) -> Option<&str> {
        GetDisksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDisksError {
    /// Creates a new `GetDisksError`.
    pub fn new(kind: GetDisksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDisksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDisksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDisksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDisksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDisksErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetDisksErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetDisksErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDisksErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDisksErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetDisksErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetDisksErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDisksErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetDisksErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(&self.kind, GetDisksErrorKind::OperationFailureException(_))
    }
    /// Returns `true` if the error kind is `GetDisksErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetDisksErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetDisksErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(&self.kind, GetDisksErrorKind::UnauthenticatedException(_))
    }
}
impl std::error::Error for GetDisksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDisksErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDisksErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetDisksErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetDisksErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDisksErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetDisksErrorKind::ServiceException(_inner) => Some(_inner),
            GetDisksErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetDisksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDiskSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDiskSnapshotError {
    /// Kind of error that occurred.
    pub kind: GetDiskSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDiskSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDiskSnapshotErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDiskSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDiskSnapshotErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDiskSnapshotErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            GetDiskSnapshotErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetDiskSnapshotErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDiskSnapshotErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetDiskSnapshotErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetDiskSnapshotErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetDiskSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDiskSnapshotError {
    fn code(&self) -> Option<&str> {
        GetDiskSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDiskSnapshotError {
    /// Creates a new `GetDiskSnapshotError`.
    pub fn new(kind: GetDiskSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDiskSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDiskSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDiskSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDiskSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDiskSnapshotErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDiskSnapshotErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDiskSnapshotErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDiskSnapshotErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDiskSnapshotErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDiskSnapshotErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDiskSnapshotErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDiskSnapshotErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetDiskSnapshotErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDiskSnapshotErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDiskSnapshotErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetDiskSnapshotErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetDiskSnapshotErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDiskSnapshotErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetDiskSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDiskSnapshotErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDiskSnapshotErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetDiskSnapshotErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetDiskSnapshotErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDiskSnapshotErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetDiskSnapshotErrorKind::ServiceException(_inner) => Some(_inner),
            GetDiskSnapshotErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetDiskSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDiskSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDiskSnapshotsError {
    /// Kind of error that occurred.
    pub kind: GetDiskSnapshotsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDiskSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDiskSnapshotsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDiskSnapshotsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDiskSnapshotsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDiskSnapshotsErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            GetDiskSnapshotsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetDiskSnapshotsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDiskSnapshotsErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetDiskSnapshotsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetDiskSnapshotsErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetDiskSnapshotsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDiskSnapshotsError {
    fn code(&self) -> Option<&str> {
        GetDiskSnapshotsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDiskSnapshotsError {
    /// Creates a new `GetDiskSnapshotsError`.
    pub fn new(kind: GetDiskSnapshotsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDiskSnapshotsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDiskSnapshotsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDiskSnapshotsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDiskSnapshotsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDiskSnapshotsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDiskSnapshotsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDiskSnapshotsErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDiskSnapshotsErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDiskSnapshotsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDiskSnapshotsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDiskSnapshotsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDiskSnapshotsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetDiskSnapshotsErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDiskSnapshotsErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDiskSnapshotsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetDiskSnapshotsErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetDiskSnapshotsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDiskSnapshotsErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetDiskSnapshotsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDiskSnapshotsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDiskSnapshotsErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetDiskSnapshotsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetDiskSnapshotsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDiskSnapshotsErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetDiskSnapshotsErrorKind::ServiceException(_inner) => Some(_inner),
            GetDiskSnapshotsErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetDiskSnapshotsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDistributionBundles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDistributionBundlesError {
    /// Kind of error that occurred.
    pub kind: GetDistributionBundlesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDistributionBundles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDistributionBundlesErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDistributionBundlesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDistributionBundlesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDistributionBundlesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetDistributionBundlesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDistributionBundlesErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetDistributionBundlesErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetDistributionBundlesErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetDistributionBundlesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDistributionBundlesError {
    fn code(&self) -> Option<&str> {
        GetDistributionBundlesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDistributionBundlesError {
    /// Creates a new `GetDistributionBundlesError`.
    pub fn new(kind: GetDistributionBundlesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDistributionBundlesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDistributionBundlesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDistributionBundlesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDistributionBundlesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDistributionBundlesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDistributionBundlesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDistributionBundlesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDistributionBundlesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDistributionBundlesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDistributionBundlesErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDistributionBundlesErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDistributionBundlesErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDistributionBundlesErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDistributionBundlesErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDistributionBundlesErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDistributionBundlesErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetDistributionBundlesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDistributionBundlesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDistributionBundlesErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetDistributionBundlesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDistributionBundlesErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetDistributionBundlesErrorKind::ServiceException(_inner) => Some(_inner),
            GetDistributionBundlesErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetDistributionBundlesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDistributionLatestCacheReset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDistributionLatestCacheResetError {
    /// Kind of error that occurred.
    pub kind: GetDistributionLatestCacheResetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDistributionLatestCacheReset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDistributionLatestCacheResetErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDistributionLatestCacheResetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDistributionLatestCacheResetErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetDistributionLatestCacheResetErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            GetDistributionLatestCacheResetErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDistributionLatestCacheResetErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetDistributionLatestCacheResetErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetDistributionLatestCacheResetErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            GetDistributionLatestCacheResetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDistributionLatestCacheResetError {
    fn code(&self) -> Option<&str> {
        GetDistributionLatestCacheResetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDistributionLatestCacheResetError {
    /// Creates a new `GetDistributionLatestCacheResetError`.
    pub fn new(
        kind: GetDistributionLatestCacheResetErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDistributionLatestCacheResetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDistributionLatestCacheResetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDistributionLatestCacheResetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDistributionLatestCacheResetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDistributionLatestCacheResetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDistributionLatestCacheResetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDistributionLatestCacheResetErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDistributionLatestCacheResetErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDistributionLatestCacheResetErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDistributionLatestCacheResetErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDistributionLatestCacheResetErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDistributionLatestCacheResetErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDistributionLatestCacheResetErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDistributionLatestCacheResetErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDistributionLatestCacheResetErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDistributionLatestCacheResetErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetDistributionLatestCacheResetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDistributionLatestCacheResetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDistributionLatestCacheResetErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetDistributionLatestCacheResetErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDistributionLatestCacheResetErrorKind::OperationFailureException(_inner) => {
                Some(_inner)
            }
            GetDistributionLatestCacheResetErrorKind::ServiceException(_inner) => Some(_inner),
            GetDistributionLatestCacheResetErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            GetDistributionLatestCacheResetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDistributionMetricData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDistributionMetricDataError {
    /// Kind of error that occurred.
    pub kind: GetDistributionMetricDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDistributionMetricData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDistributionMetricDataErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDistributionMetricDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDistributionMetricDataErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDistributionMetricDataErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetDistributionMetricDataErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDistributionMetricDataErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetDistributionMetricDataErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetDistributionMetricDataErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetDistributionMetricDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDistributionMetricDataError {
    fn code(&self) -> Option<&str> {
        GetDistributionMetricDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDistributionMetricDataError {
    /// Creates a new `GetDistributionMetricDataError`.
    pub fn new(kind: GetDistributionMetricDataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDistributionMetricDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDistributionMetricDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDistributionMetricDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDistributionMetricDataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDistributionMetricDataErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDistributionMetricDataErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDistributionMetricDataErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDistributionMetricDataErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDistributionMetricDataErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDistributionMetricDataErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDistributionMetricDataErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDistributionMetricDataErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDistributionMetricDataErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDistributionMetricDataErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDistributionMetricDataErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDistributionMetricDataErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetDistributionMetricDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDistributionMetricDataErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDistributionMetricDataErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetDistributionMetricDataErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDistributionMetricDataErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetDistributionMetricDataErrorKind::ServiceException(_inner) => Some(_inner),
            GetDistributionMetricDataErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetDistributionMetricDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDistributions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDistributionsError {
    /// Kind of error that occurred.
    pub kind: GetDistributionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDistributions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDistributionsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDistributionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDistributionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDistributionsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetDistributionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDistributionsErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetDistributionsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetDistributionsErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetDistributionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDistributionsError {
    fn code(&self) -> Option<&str> {
        GetDistributionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDistributionsError {
    /// Creates a new `GetDistributionsError`.
    pub fn new(kind: GetDistributionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDistributionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDistributionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDistributionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDistributionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDistributionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDistributionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDistributionsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDistributionsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDistributionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDistributionsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetDistributionsErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDistributionsErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDistributionsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetDistributionsErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetDistributionsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDistributionsErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetDistributionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDistributionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDistributionsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetDistributionsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDistributionsErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetDistributionsErrorKind::ServiceException(_inner) => Some(_inner),
            GetDistributionsErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetDistributionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDomainError {
    /// Kind of error that occurred.
    pub kind: GetDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDomainErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDomainErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDomainErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            GetDomainErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetDomainErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDomainErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetDomainErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetDomainErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDomainError {
    fn code(&self) -> Option<&str> {
        GetDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDomainError {
    /// Creates a new `GetDomainError`.
    pub fn new(kind: GetDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDomainErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetDomainErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetDomainErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDomainErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDomainErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetDomainErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetDomainErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDomainErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetDomainErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(&self.kind, GetDomainErrorKind::OperationFailureException(_))
    }
    /// Returns `true` if the error kind is `GetDomainErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetDomainErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetDomainErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(&self.kind, GetDomainErrorKind::UnauthenticatedException(_))
    }
}
impl std::error::Error for GetDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDomainErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDomainErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetDomainErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetDomainErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDomainErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetDomainErrorKind::ServiceException(_inner) => Some(_inner),
            GetDomainErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDomainsError {
    /// Kind of error that occurred.
    pub kind: GetDomainsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDomainsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDomainsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDomainsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDomainsErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            GetDomainsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetDomainsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetDomainsErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetDomainsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetDomainsErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetDomainsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDomainsError {
    fn code(&self) -> Option<&str> {
        GetDomainsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDomainsError {
    /// Creates a new `GetDomainsError`.
    pub fn new(kind: GetDomainsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDomainsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDomainsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDomainsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDomainsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDomainsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetDomainsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetDomainsErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDomainsErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDomainsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetDomainsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetDomainsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDomainsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetDomainsErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDomainsErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDomainsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetDomainsErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetDomainsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(&self.kind, GetDomainsErrorKind::UnauthenticatedException(_))
    }
}
impl std::error::Error for GetDomainsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDomainsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDomainsErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetDomainsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetDomainsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetDomainsErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetDomainsErrorKind::ServiceException(_inner) => Some(_inner),
            GetDomainsErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetDomainsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetExportSnapshotRecords` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetExportSnapshotRecordsError {
    /// Kind of error that occurred.
    pub kind: GetExportSnapshotRecordsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetExportSnapshotRecords` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetExportSnapshotRecordsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetExportSnapshotRecordsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetExportSnapshotRecordsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetExportSnapshotRecordsErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            GetExportSnapshotRecordsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetExportSnapshotRecordsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetExportSnapshotRecordsErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetExportSnapshotRecordsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetExportSnapshotRecordsErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetExportSnapshotRecordsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetExportSnapshotRecordsError {
    fn code(&self) -> Option<&str> {
        GetExportSnapshotRecordsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetExportSnapshotRecordsError {
    /// Creates a new `GetExportSnapshotRecordsError`.
    pub fn new(kind: GetExportSnapshotRecordsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetExportSnapshotRecordsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetExportSnapshotRecordsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetExportSnapshotRecordsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetExportSnapshotRecordsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetExportSnapshotRecordsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExportSnapshotRecordsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExportSnapshotRecordsErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExportSnapshotRecordsErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExportSnapshotRecordsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExportSnapshotRecordsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExportSnapshotRecordsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExportSnapshotRecordsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExportSnapshotRecordsErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExportSnapshotRecordsErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExportSnapshotRecordsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExportSnapshotRecordsErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetExportSnapshotRecordsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetExportSnapshotRecordsErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetExportSnapshotRecordsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetExportSnapshotRecordsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetExportSnapshotRecordsErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            GetExportSnapshotRecordsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetExportSnapshotRecordsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetExportSnapshotRecordsErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetExportSnapshotRecordsErrorKind::ServiceException(_inner) => Some(_inner),
            GetExportSnapshotRecordsErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetExportSnapshotRecordsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInstanceError {
    /// Kind of error that occurred.
    pub kind: GetInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInstanceErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInstanceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetInstanceErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            GetInstanceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetInstanceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetInstanceErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetInstanceErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetInstanceErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInstanceError {
    fn code(&self) -> Option<&str> {
        GetInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInstanceError {
    /// Creates a new `GetInstanceError`.
    pub fn new(kind: GetInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInstanceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetInstanceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetInstanceErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetInstanceErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetInstanceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetInstanceErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetInstanceErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetInstanceErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetInstanceErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInstanceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetInstanceErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetInstanceErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetInstanceErrorKind::NotFoundException(_inner) => Some(_inner),
            GetInstanceErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetInstanceErrorKind::ServiceException(_inner) => Some(_inner),
            GetInstanceErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInstanceAccessDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInstanceAccessDetailsError {
    /// Kind of error that occurred.
    pub kind: GetInstanceAccessDetailsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInstanceAccessDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInstanceAccessDetailsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInstanceAccessDetailsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInstanceAccessDetailsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetInstanceAccessDetailsErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            GetInstanceAccessDetailsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetInstanceAccessDetailsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetInstanceAccessDetailsErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetInstanceAccessDetailsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetInstanceAccessDetailsErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetInstanceAccessDetailsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInstanceAccessDetailsError {
    fn code(&self) -> Option<&str> {
        GetInstanceAccessDetailsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInstanceAccessDetailsError {
    /// Creates a new `GetInstanceAccessDetailsError`.
    pub fn new(kind: GetInstanceAccessDetailsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInstanceAccessDetailsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInstanceAccessDetailsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInstanceAccessDetailsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInstanceAccessDetailsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInstanceAccessDetailsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceAccessDetailsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceAccessDetailsErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceAccessDetailsErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceAccessDetailsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceAccessDetailsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceAccessDetailsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceAccessDetailsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceAccessDetailsErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceAccessDetailsErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceAccessDetailsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceAccessDetailsErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceAccessDetailsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceAccessDetailsErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetInstanceAccessDetailsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInstanceAccessDetailsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetInstanceAccessDetailsErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            GetInstanceAccessDetailsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetInstanceAccessDetailsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetInstanceAccessDetailsErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetInstanceAccessDetailsErrorKind::ServiceException(_inner) => Some(_inner),
            GetInstanceAccessDetailsErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetInstanceAccessDetailsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInstanceMetricData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInstanceMetricDataError {
    /// Kind of error that occurred.
    pub kind: GetInstanceMetricDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInstanceMetricData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInstanceMetricDataErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInstanceMetricDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInstanceMetricDataErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetInstanceMetricDataErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            GetInstanceMetricDataErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetInstanceMetricDataErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetInstanceMetricDataErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetInstanceMetricDataErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetInstanceMetricDataErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetInstanceMetricDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInstanceMetricDataError {
    fn code(&self) -> Option<&str> {
        GetInstanceMetricDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInstanceMetricDataError {
    /// Creates a new `GetInstanceMetricDataError`.
    pub fn new(kind: GetInstanceMetricDataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInstanceMetricDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInstanceMetricDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInstanceMetricDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInstanceMetricDataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInstanceMetricDataErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceMetricDataErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceMetricDataErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceMetricDataErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceMetricDataErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceMetricDataErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceMetricDataErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceMetricDataErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceMetricDataErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceMetricDataErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceMetricDataErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceMetricDataErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceMetricDataErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceMetricDataErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetInstanceMetricDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInstanceMetricDataErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetInstanceMetricDataErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetInstanceMetricDataErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetInstanceMetricDataErrorKind::NotFoundException(_inner) => Some(_inner),
            GetInstanceMetricDataErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetInstanceMetricDataErrorKind::ServiceException(_inner) => Some(_inner),
            GetInstanceMetricDataErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetInstanceMetricDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInstancePortStates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInstancePortStatesError {
    /// Kind of error that occurred.
    pub kind: GetInstancePortStatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInstancePortStates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInstancePortStatesErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInstancePortStatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInstancePortStatesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetInstancePortStatesErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            GetInstancePortStatesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetInstancePortStatesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetInstancePortStatesErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetInstancePortStatesErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetInstancePortStatesErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetInstancePortStatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInstancePortStatesError {
    fn code(&self) -> Option<&str> {
        GetInstancePortStatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInstancePortStatesError {
    /// Creates a new `GetInstancePortStatesError`.
    pub fn new(kind: GetInstancePortStatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInstancePortStatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInstancePortStatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInstancePortStatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInstancePortStatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInstancePortStatesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstancePortStatesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstancePortStatesErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstancePortStatesErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstancePortStatesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstancePortStatesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstancePortStatesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstancePortStatesErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstancePortStatesErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstancePortStatesErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstancePortStatesErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstancePortStatesErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstancePortStatesErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstancePortStatesErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetInstancePortStatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInstancePortStatesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetInstancePortStatesErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetInstancePortStatesErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetInstancePortStatesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetInstancePortStatesErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetInstancePortStatesErrorKind::ServiceException(_inner) => Some(_inner),
            GetInstancePortStatesErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetInstancePortStatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInstancesError {
    /// Kind of error that occurred.
    pub kind: GetInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInstancesErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInstancesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetInstancesErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            GetInstancesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetInstancesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetInstancesErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetInstancesErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetInstancesErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInstancesError {
    fn code(&self) -> Option<&str> {
        GetInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInstancesError {
    /// Creates a new `GetInstancesError`.
    pub fn new(kind: GetInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInstancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInstancesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetInstancesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetInstancesErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstancesErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstancesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetInstancesErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetInstancesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetInstancesErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetInstancesErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstancesErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstancesErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetInstancesErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetInstancesErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstancesErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInstancesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetInstancesErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetInstancesErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetInstancesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetInstancesErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetInstancesErrorKind::ServiceException(_inner) => Some(_inner),
            GetInstancesErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInstanceSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInstanceSnapshotError {
    /// Kind of error that occurred.
    pub kind: GetInstanceSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInstanceSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInstanceSnapshotErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInstanceSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInstanceSnapshotErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetInstanceSnapshotErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            GetInstanceSnapshotErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetInstanceSnapshotErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetInstanceSnapshotErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetInstanceSnapshotErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetInstanceSnapshotErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetInstanceSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInstanceSnapshotError {
    fn code(&self) -> Option<&str> {
        GetInstanceSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInstanceSnapshotError {
    /// Creates a new `GetInstanceSnapshotError`.
    pub fn new(kind: GetInstanceSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInstanceSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInstanceSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInstanceSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInstanceSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInstanceSnapshotErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceSnapshotErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceSnapshotErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceSnapshotErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceSnapshotErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceSnapshotErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceSnapshotErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceSnapshotErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceSnapshotErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceSnapshotErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceSnapshotErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceSnapshotErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceSnapshotErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceSnapshotErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetInstanceSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInstanceSnapshotErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetInstanceSnapshotErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetInstanceSnapshotErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetInstanceSnapshotErrorKind::NotFoundException(_inner) => Some(_inner),
            GetInstanceSnapshotErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetInstanceSnapshotErrorKind::ServiceException(_inner) => Some(_inner),
            GetInstanceSnapshotErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetInstanceSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInstanceSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInstanceSnapshotsError {
    /// Kind of error that occurred.
    pub kind: GetInstanceSnapshotsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInstanceSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInstanceSnapshotsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInstanceSnapshotsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInstanceSnapshotsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetInstanceSnapshotsErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            GetInstanceSnapshotsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetInstanceSnapshotsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetInstanceSnapshotsErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetInstanceSnapshotsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetInstanceSnapshotsErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetInstanceSnapshotsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInstanceSnapshotsError {
    fn code(&self) -> Option<&str> {
        GetInstanceSnapshotsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInstanceSnapshotsError {
    /// Creates a new `GetInstanceSnapshotsError`.
    pub fn new(kind: GetInstanceSnapshotsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInstanceSnapshotsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInstanceSnapshotsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInstanceSnapshotsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInstanceSnapshotsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInstanceSnapshotsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceSnapshotsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceSnapshotsErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceSnapshotsErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceSnapshotsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceSnapshotsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceSnapshotsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceSnapshotsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceSnapshotsErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceSnapshotsErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceSnapshotsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceSnapshotsErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceSnapshotsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceSnapshotsErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetInstanceSnapshotsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInstanceSnapshotsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetInstanceSnapshotsErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetInstanceSnapshotsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetInstanceSnapshotsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetInstanceSnapshotsErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetInstanceSnapshotsErrorKind::ServiceException(_inner) => Some(_inner),
            GetInstanceSnapshotsErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetInstanceSnapshotsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInstanceState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInstanceStateError {
    /// Kind of error that occurred.
    pub kind: GetInstanceStateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInstanceState` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInstanceStateErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInstanceStateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInstanceStateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetInstanceStateErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            GetInstanceStateErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetInstanceStateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetInstanceStateErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetInstanceStateErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetInstanceStateErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetInstanceStateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInstanceStateError {
    fn code(&self) -> Option<&str> {
        GetInstanceStateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInstanceStateError {
    /// Creates a new `GetInstanceStateError`.
    pub fn new(kind: GetInstanceStateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInstanceStateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInstanceStateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInstanceStateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInstanceStateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInstanceStateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceStateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceStateErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceStateErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceStateErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceStateErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceStateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetInstanceStateErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetInstanceStateErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceStateErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInstanceStateErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetInstanceStateErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetInstanceStateErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInstanceStateErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetInstanceStateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInstanceStateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetInstanceStateErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetInstanceStateErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetInstanceStateErrorKind::NotFoundException(_inner) => Some(_inner),
            GetInstanceStateErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetInstanceStateErrorKind::ServiceException(_inner) => Some(_inner),
            GetInstanceStateErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetInstanceStateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetKeyPair` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetKeyPairError {
    /// Kind of error that occurred.
    pub kind: GetKeyPairErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetKeyPair` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetKeyPairErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetKeyPairError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetKeyPairErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetKeyPairErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            GetKeyPairErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetKeyPairErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetKeyPairErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetKeyPairErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetKeyPairErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetKeyPairErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetKeyPairError {
    fn code(&self) -> Option<&str> {
        GetKeyPairError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetKeyPairError {
    /// Creates a new `GetKeyPairError`.
    pub fn new(kind: GetKeyPairErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetKeyPairError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetKeyPairErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetKeyPairError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetKeyPairErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetKeyPairErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetKeyPairErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetKeyPairErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetKeyPairErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetKeyPairErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetKeyPairErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetKeyPairErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetKeyPairErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetKeyPairErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetKeyPairErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetKeyPairErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetKeyPairErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetKeyPairErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(&self.kind, GetKeyPairErrorKind::UnauthenticatedException(_))
    }
}
impl std::error::Error for GetKeyPairError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetKeyPairErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetKeyPairErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetKeyPairErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetKeyPairErrorKind::NotFoundException(_inner) => Some(_inner),
            GetKeyPairErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetKeyPairErrorKind::ServiceException(_inner) => Some(_inner),
            GetKeyPairErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetKeyPairErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetKeyPairs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetKeyPairsError {
    /// Kind of error that occurred.
    pub kind: GetKeyPairsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetKeyPairs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetKeyPairsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetKeyPairsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetKeyPairsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetKeyPairsErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            GetKeyPairsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetKeyPairsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetKeyPairsErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetKeyPairsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetKeyPairsErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetKeyPairsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetKeyPairsError {
    fn code(&self) -> Option<&str> {
        GetKeyPairsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetKeyPairsError {
    /// Creates a new `GetKeyPairsError`.
    pub fn new(kind: GetKeyPairsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetKeyPairsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetKeyPairsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetKeyPairsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetKeyPairsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetKeyPairsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetKeyPairsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetKeyPairsErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetKeyPairsErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetKeyPairsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetKeyPairsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetKeyPairsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetKeyPairsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetKeyPairsErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetKeyPairsErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetKeyPairsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetKeyPairsErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetKeyPairsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetKeyPairsErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetKeyPairsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetKeyPairsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetKeyPairsErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetKeyPairsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetKeyPairsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetKeyPairsErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetKeyPairsErrorKind::ServiceException(_inner) => Some(_inner),
            GetKeyPairsErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetKeyPairsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLoadBalancerError {
    /// Kind of error that occurred.
    pub kind: GetLoadBalancerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLoadBalancer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLoadBalancerErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLoadBalancerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLoadBalancerErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetLoadBalancerErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            GetLoadBalancerErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetLoadBalancerErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetLoadBalancerErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetLoadBalancerErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetLoadBalancerErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetLoadBalancerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLoadBalancerError {
    fn code(&self) -> Option<&str> {
        GetLoadBalancerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLoadBalancerError {
    /// Creates a new `GetLoadBalancerError`.
    pub fn new(kind: GetLoadBalancerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLoadBalancerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLoadBalancerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLoadBalancerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLoadBalancerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLoadBalancerErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancerErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoadBalancerErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancerErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoadBalancerErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancerErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoadBalancerErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetLoadBalancerErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetLoadBalancerErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancerErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoadBalancerErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetLoadBalancerErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetLoadBalancerErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancerErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetLoadBalancerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLoadBalancerErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetLoadBalancerErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetLoadBalancerErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetLoadBalancerErrorKind::NotFoundException(_inner) => Some(_inner),
            GetLoadBalancerErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetLoadBalancerErrorKind::ServiceException(_inner) => Some(_inner),
            GetLoadBalancerErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetLoadBalancerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLoadBalancerMetricData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLoadBalancerMetricDataError {
    /// Kind of error that occurred.
    pub kind: GetLoadBalancerMetricDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLoadBalancerMetricData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLoadBalancerMetricDataErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLoadBalancerMetricDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLoadBalancerMetricDataErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetLoadBalancerMetricDataErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            GetLoadBalancerMetricDataErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetLoadBalancerMetricDataErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetLoadBalancerMetricDataErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetLoadBalancerMetricDataErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetLoadBalancerMetricDataErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetLoadBalancerMetricDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLoadBalancerMetricDataError {
    fn code(&self) -> Option<&str> {
        GetLoadBalancerMetricDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLoadBalancerMetricDataError {
    /// Creates a new `GetLoadBalancerMetricDataError`.
    pub fn new(kind: GetLoadBalancerMetricDataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLoadBalancerMetricDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLoadBalancerMetricDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLoadBalancerMetricDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLoadBalancerMetricDataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLoadBalancerMetricDataErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancerMetricDataErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoadBalancerMetricDataErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancerMetricDataErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoadBalancerMetricDataErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancerMetricDataErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoadBalancerMetricDataErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancerMetricDataErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoadBalancerMetricDataErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancerMetricDataErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoadBalancerMetricDataErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancerMetricDataErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoadBalancerMetricDataErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancerMetricDataErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetLoadBalancerMetricDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLoadBalancerMetricDataErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetLoadBalancerMetricDataErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            GetLoadBalancerMetricDataErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetLoadBalancerMetricDataErrorKind::NotFoundException(_inner) => Some(_inner),
            GetLoadBalancerMetricDataErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetLoadBalancerMetricDataErrorKind::ServiceException(_inner) => Some(_inner),
            GetLoadBalancerMetricDataErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetLoadBalancerMetricDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLoadBalancers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLoadBalancersError {
    /// Kind of error that occurred.
    pub kind: GetLoadBalancersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLoadBalancers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLoadBalancersErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLoadBalancersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLoadBalancersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetLoadBalancersErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            GetLoadBalancersErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetLoadBalancersErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetLoadBalancersErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetLoadBalancersErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetLoadBalancersErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetLoadBalancersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLoadBalancersError {
    fn code(&self) -> Option<&str> {
        GetLoadBalancersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLoadBalancersError {
    /// Creates a new `GetLoadBalancersError`.
    pub fn new(kind: GetLoadBalancersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLoadBalancersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLoadBalancersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLoadBalancersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLoadBalancersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLoadBalancersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancersErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoadBalancersErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancersErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoadBalancersErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancersErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoadBalancersErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetLoadBalancersErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetLoadBalancersErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancersErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoadBalancersErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetLoadBalancersErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetLoadBalancersErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancersErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetLoadBalancersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLoadBalancersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetLoadBalancersErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetLoadBalancersErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetLoadBalancersErrorKind::NotFoundException(_inner) => Some(_inner),
            GetLoadBalancersErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetLoadBalancersErrorKind::ServiceException(_inner) => Some(_inner),
            GetLoadBalancersErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetLoadBalancersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLoadBalancerTlsCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLoadBalancerTlsCertificatesError {
    /// Kind of error that occurred.
    pub kind: GetLoadBalancerTlsCertificatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLoadBalancerTlsCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLoadBalancerTlsCertificatesErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLoadBalancerTlsCertificatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLoadBalancerTlsCertificatesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetLoadBalancerTlsCertificatesErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            GetLoadBalancerTlsCertificatesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetLoadBalancerTlsCertificatesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetLoadBalancerTlsCertificatesErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetLoadBalancerTlsCertificatesErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetLoadBalancerTlsCertificatesErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            GetLoadBalancerTlsCertificatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLoadBalancerTlsCertificatesError {
    fn code(&self) -> Option<&str> {
        GetLoadBalancerTlsCertificatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLoadBalancerTlsCertificatesError {
    /// Creates a new `GetLoadBalancerTlsCertificatesError`.
    pub fn new(
        kind: GetLoadBalancerTlsCertificatesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLoadBalancerTlsCertificatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLoadBalancerTlsCertificatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLoadBalancerTlsCertificatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLoadBalancerTlsCertificatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLoadBalancerTlsCertificatesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancerTlsCertificatesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoadBalancerTlsCertificatesErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancerTlsCertificatesErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoadBalancerTlsCertificatesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancerTlsCertificatesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoadBalancerTlsCertificatesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancerTlsCertificatesErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoadBalancerTlsCertificatesErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancerTlsCertificatesErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoadBalancerTlsCertificatesErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancerTlsCertificatesErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLoadBalancerTlsCertificatesErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLoadBalancerTlsCertificatesErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetLoadBalancerTlsCertificatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLoadBalancerTlsCertificatesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetLoadBalancerTlsCertificatesErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            GetLoadBalancerTlsCertificatesErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetLoadBalancerTlsCertificatesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetLoadBalancerTlsCertificatesErrorKind::OperationFailureException(_inner) => {
                Some(_inner)
            }
            GetLoadBalancerTlsCertificatesErrorKind::ServiceException(_inner) => Some(_inner),
            GetLoadBalancerTlsCertificatesErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            GetLoadBalancerTlsCertificatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetOperationError {
    /// Kind of error that occurred.
    pub kind: GetOperationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetOperationErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetOperationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetOperationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetOperationErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            GetOperationErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetOperationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetOperationErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetOperationErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetOperationErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetOperationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetOperationError {
    fn code(&self) -> Option<&str> {
        GetOperationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetOperationError {
    /// Creates a new `GetOperationError`.
    pub fn new(kind: GetOperationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetOperationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetOperationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetOperationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetOperationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetOperationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetOperationErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetOperationErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOperationErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOperationErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetOperationErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetOperationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetOperationErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetOperationErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOperationErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOperationErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetOperationErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetOperationErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOperationErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetOperationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetOperationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetOperationErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetOperationErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetOperationErrorKind::NotFoundException(_inner) => Some(_inner),
            GetOperationErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetOperationErrorKind::ServiceException(_inner) => Some(_inner),
            GetOperationErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetOperationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetOperations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetOperationsError {
    /// Kind of error that occurred.
    pub kind: GetOperationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetOperations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetOperationsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetOperationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetOperationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetOperationsErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            GetOperationsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetOperationsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetOperationsErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetOperationsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetOperationsErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetOperationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetOperationsError {
    fn code(&self) -> Option<&str> {
        GetOperationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetOperationsError {
    /// Creates a new `GetOperationsError`.
    pub fn new(kind: GetOperationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetOperationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetOperationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetOperationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetOperationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetOperationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetOperationsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetOperationsErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOperationsErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOperationsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetOperationsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetOperationsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetOperationsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetOperationsErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOperationsErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOperationsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetOperationsErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetOperationsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOperationsErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetOperationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetOperationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetOperationsErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetOperationsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetOperationsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetOperationsErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetOperationsErrorKind::ServiceException(_inner) => Some(_inner),
            GetOperationsErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetOperationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetOperationsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetOperationsForResourceError {
    /// Kind of error that occurred.
    pub kind: GetOperationsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetOperationsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetOperationsForResourceErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetOperationsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetOperationsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetOperationsForResourceErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            GetOperationsForResourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetOperationsForResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetOperationsForResourceErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetOperationsForResourceErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetOperationsForResourceErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetOperationsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetOperationsForResourceError {
    fn code(&self) -> Option<&str> {
        GetOperationsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetOperationsForResourceError {
    /// Creates a new `GetOperationsForResourceError`.
    pub fn new(kind: GetOperationsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetOperationsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetOperationsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetOperationsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetOperationsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetOperationsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOperationsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOperationsForResourceErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOperationsForResourceErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOperationsForResourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOperationsForResourceErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOperationsForResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOperationsForResourceErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOperationsForResourceErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOperationsForResourceErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOperationsForResourceErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOperationsForResourceErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetOperationsForResourceErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetOperationsForResourceErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetOperationsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetOperationsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetOperationsForResourceErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            GetOperationsForResourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetOperationsForResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            GetOperationsForResourceErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetOperationsForResourceErrorKind::ServiceException(_inner) => Some(_inner),
            GetOperationsForResourceErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetOperationsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRegions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRegionsError {
    /// Kind of error that occurred.
    pub kind: GetRegionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRegions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRegionsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRegionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRegionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetRegionsErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            GetRegionsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetRegionsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRegionsErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetRegionsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetRegionsErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetRegionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRegionsError {
    fn code(&self) -> Option<&str> {
        GetRegionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRegionsError {
    /// Creates a new `GetRegionsError`.
    pub fn new(kind: GetRegionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRegionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRegionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRegionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRegionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRegionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetRegionsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetRegionsErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegionsErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRegionsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetRegionsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetRegionsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetRegionsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetRegionsErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRegionsErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRegionsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetRegionsErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetRegionsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(&self.kind, GetRegionsErrorKind::UnauthenticatedException(_))
    }
}
impl std::error::Error for GetRegionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRegionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRegionsErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetRegionsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetRegionsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRegionsErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetRegionsErrorKind::ServiceException(_inner) => Some(_inner),
            GetRegionsErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetRegionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRelationalDatabase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRelationalDatabaseError {
    /// Kind of error that occurred.
    pub kind: GetRelationalDatabaseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRelationalDatabase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRelationalDatabaseErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRelationalDatabaseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRelationalDatabaseErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRelationalDatabaseError {
    fn code(&self) -> Option<&str> {
        GetRelationalDatabaseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRelationalDatabaseError {
    /// Creates a new `GetRelationalDatabaseError`.
    pub fn new(kind: GetRelationalDatabaseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRelationalDatabaseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRelationalDatabaseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRelationalDatabaseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRelationalDatabaseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetRelationalDatabaseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRelationalDatabaseErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRelationalDatabaseErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetRelationalDatabaseErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetRelationalDatabaseErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRelationalDatabaseErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetRelationalDatabaseErrorKind::ServiceException(_inner) => Some(_inner),
            GetRelationalDatabaseErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetRelationalDatabaseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRelationalDatabaseBlueprints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRelationalDatabaseBlueprintsError {
    /// Kind of error that occurred.
    pub kind: GetRelationalDatabaseBlueprintsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRelationalDatabaseBlueprints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRelationalDatabaseBlueprintsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRelationalDatabaseBlueprintsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRelationalDatabaseBlueprintsErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseBlueprintsErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseBlueprintsErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseBlueprintsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseBlueprintsErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseBlueprintsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseBlueprintsErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseBlueprintsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRelationalDatabaseBlueprintsError {
    fn code(&self) -> Option<&str> {
        GetRelationalDatabaseBlueprintsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRelationalDatabaseBlueprintsError {
    /// Creates a new `GetRelationalDatabaseBlueprintsError`.
    pub fn new(
        kind: GetRelationalDatabaseBlueprintsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRelationalDatabaseBlueprintsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRelationalDatabaseBlueprintsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRelationalDatabaseBlueprintsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRelationalDatabaseBlueprintsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseBlueprintsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseBlueprintsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseBlueprintsErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseBlueprintsErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseBlueprintsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseBlueprintsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseBlueprintsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseBlueprintsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseBlueprintsErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseBlueprintsErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseBlueprintsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseBlueprintsErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseBlueprintsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseBlueprintsErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetRelationalDatabaseBlueprintsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRelationalDatabaseBlueprintsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRelationalDatabaseBlueprintsErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseBlueprintsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetRelationalDatabaseBlueprintsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRelationalDatabaseBlueprintsErrorKind::OperationFailureException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseBlueprintsErrorKind::ServiceException(_inner) => Some(_inner),
            GetRelationalDatabaseBlueprintsErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseBlueprintsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRelationalDatabaseBundles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRelationalDatabaseBundlesError {
    /// Kind of error that occurred.
    pub kind: GetRelationalDatabaseBundlesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRelationalDatabaseBundles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRelationalDatabaseBundlesErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRelationalDatabaseBundlesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRelationalDatabaseBundlesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseBundlesErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseBundlesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseBundlesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseBundlesErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseBundlesErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseBundlesErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseBundlesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRelationalDatabaseBundlesError {
    fn code(&self) -> Option<&str> {
        GetRelationalDatabaseBundlesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRelationalDatabaseBundlesError {
    /// Creates a new `GetRelationalDatabaseBundlesError`.
    pub fn new(kind: GetRelationalDatabaseBundlesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRelationalDatabaseBundlesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRelationalDatabaseBundlesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRelationalDatabaseBundlesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRelationalDatabaseBundlesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseBundlesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseBundlesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseBundlesErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseBundlesErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseBundlesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseBundlesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseBundlesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseBundlesErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseBundlesErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseBundlesErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseBundlesErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseBundlesErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseBundlesErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseBundlesErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetRelationalDatabaseBundlesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRelationalDatabaseBundlesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRelationalDatabaseBundlesErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseBundlesErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetRelationalDatabaseBundlesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRelationalDatabaseBundlesErrorKind::OperationFailureException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseBundlesErrorKind::ServiceException(_inner) => Some(_inner),
            GetRelationalDatabaseBundlesErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetRelationalDatabaseBundlesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRelationalDatabaseEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRelationalDatabaseEventsError {
    /// Kind of error that occurred.
    pub kind: GetRelationalDatabaseEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRelationalDatabaseEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRelationalDatabaseEventsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRelationalDatabaseEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRelationalDatabaseEventsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseEventsErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseEventsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseEventsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseEventsErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseEventsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseEventsErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRelationalDatabaseEventsError {
    fn code(&self) -> Option<&str> {
        GetRelationalDatabaseEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRelationalDatabaseEventsError {
    /// Creates a new `GetRelationalDatabaseEventsError`.
    pub fn new(kind: GetRelationalDatabaseEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRelationalDatabaseEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRelationalDatabaseEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRelationalDatabaseEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRelationalDatabaseEventsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseEventsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseEventsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseEventsErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseEventsErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseEventsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseEventsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseEventsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseEventsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseEventsErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseEventsErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseEventsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseEventsErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseEventsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseEventsErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetRelationalDatabaseEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRelationalDatabaseEventsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRelationalDatabaseEventsErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseEventsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetRelationalDatabaseEventsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRelationalDatabaseEventsErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetRelationalDatabaseEventsErrorKind::ServiceException(_inner) => Some(_inner),
            GetRelationalDatabaseEventsErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetRelationalDatabaseEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRelationalDatabaseLogEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRelationalDatabaseLogEventsError {
    /// Kind of error that occurred.
    pub kind: GetRelationalDatabaseLogEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRelationalDatabaseLogEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRelationalDatabaseLogEventsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRelationalDatabaseLogEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRelationalDatabaseLogEventsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseLogEventsErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseLogEventsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseLogEventsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseLogEventsErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseLogEventsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseLogEventsErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseLogEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRelationalDatabaseLogEventsError {
    fn code(&self) -> Option<&str> {
        GetRelationalDatabaseLogEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRelationalDatabaseLogEventsError {
    /// Creates a new `GetRelationalDatabaseLogEventsError`.
    pub fn new(
        kind: GetRelationalDatabaseLogEventsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRelationalDatabaseLogEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRelationalDatabaseLogEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRelationalDatabaseLogEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRelationalDatabaseLogEventsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseLogEventsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseLogEventsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseLogEventsErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseLogEventsErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseLogEventsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseLogEventsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseLogEventsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseLogEventsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseLogEventsErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseLogEventsErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseLogEventsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseLogEventsErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseLogEventsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseLogEventsErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetRelationalDatabaseLogEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRelationalDatabaseLogEventsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRelationalDatabaseLogEventsErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseLogEventsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetRelationalDatabaseLogEventsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRelationalDatabaseLogEventsErrorKind::OperationFailureException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseLogEventsErrorKind::ServiceException(_inner) => Some(_inner),
            GetRelationalDatabaseLogEventsErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseLogEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRelationalDatabaseLogStreams` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRelationalDatabaseLogStreamsError {
    /// Kind of error that occurred.
    pub kind: GetRelationalDatabaseLogStreamsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRelationalDatabaseLogStreams` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRelationalDatabaseLogStreamsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRelationalDatabaseLogStreamsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRelationalDatabaseLogStreamsErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseLogStreamsErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseLogStreamsErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseLogStreamsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseLogStreamsErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseLogStreamsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseLogStreamsErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseLogStreamsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRelationalDatabaseLogStreamsError {
    fn code(&self) -> Option<&str> {
        GetRelationalDatabaseLogStreamsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRelationalDatabaseLogStreamsError {
    /// Creates a new `GetRelationalDatabaseLogStreamsError`.
    pub fn new(
        kind: GetRelationalDatabaseLogStreamsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRelationalDatabaseLogStreamsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRelationalDatabaseLogStreamsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRelationalDatabaseLogStreamsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRelationalDatabaseLogStreamsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseLogStreamsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseLogStreamsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseLogStreamsErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseLogStreamsErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseLogStreamsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseLogStreamsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseLogStreamsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseLogStreamsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseLogStreamsErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseLogStreamsErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseLogStreamsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseLogStreamsErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseLogStreamsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseLogStreamsErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetRelationalDatabaseLogStreamsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRelationalDatabaseLogStreamsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRelationalDatabaseLogStreamsErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseLogStreamsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetRelationalDatabaseLogStreamsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRelationalDatabaseLogStreamsErrorKind::OperationFailureException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseLogStreamsErrorKind::ServiceException(_inner) => Some(_inner),
            GetRelationalDatabaseLogStreamsErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseLogStreamsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRelationalDatabaseMasterUserPassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRelationalDatabaseMasterUserPasswordError {
    /// Kind of error that occurred.
    pub kind: GetRelationalDatabaseMasterUserPasswordErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRelationalDatabaseMasterUserPassword` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRelationalDatabaseMasterUserPasswordErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRelationalDatabaseMasterUserPasswordError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRelationalDatabaseMasterUserPasswordErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseMasterUserPasswordErrorKind::AccountSetupInProgressException(
                _inner,
            ) => _inner.fmt(f),
            GetRelationalDatabaseMasterUserPasswordErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseMasterUserPasswordErrorKind::NotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseMasterUserPasswordErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseMasterUserPasswordErrorKind::ServiceException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseMasterUserPasswordErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseMasterUserPasswordErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRelationalDatabaseMasterUserPasswordError {
    fn code(&self) -> Option<&str> {
        GetRelationalDatabaseMasterUserPasswordError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRelationalDatabaseMasterUserPasswordError {
    /// Creates a new `GetRelationalDatabaseMasterUserPasswordError`.
    pub fn new(
        kind: GetRelationalDatabaseMasterUserPasswordErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRelationalDatabaseMasterUserPasswordError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRelationalDatabaseMasterUserPasswordErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRelationalDatabaseMasterUserPasswordError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRelationalDatabaseMasterUserPasswordErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseMasterUserPasswordErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseMasterUserPasswordErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseMasterUserPasswordErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseMasterUserPasswordErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseMasterUserPasswordErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseMasterUserPasswordErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseMasterUserPasswordErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseMasterUserPasswordErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseMasterUserPasswordErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseMasterUserPasswordErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseMasterUserPasswordErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseMasterUserPasswordErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseMasterUserPasswordErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseMasterUserPasswordErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetRelationalDatabaseMasterUserPasswordError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRelationalDatabaseMasterUserPasswordErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseMasterUserPasswordErrorKind::AccountSetupInProgressException(
                _inner,
            ) => Some(_inner),
            GetRelationalDatabaseMasterUserPasswordErrorKind::InvalidInputException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseMasterUserPasswordErrorKind::NotFoundException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseMasterUserPasswordErrorKind::OperationFailureException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseMasterUserPasswordErrorKind::ServiceException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseMasterUserPasswordErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseMasterUserPasswordErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetRelationalDatabaseMetricData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRelationalDatabaseMetricDataError {
    /// Kind of error that occurred.
    pub kind: GetRelationalDatabaseMetricDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRelationalDatabaseMetricData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRelationalDatabaseMetricDataErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRelationalDatabaseMetricDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRelationalDatabaseMetricDataErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseMetricDataErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseMetricDataErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseMetricDataErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseMetricDataErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseMetricDataErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseMetricDataErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseMetricDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRelationalDatabaseMetricDataError {
    fn code(&self) -> Option<&str> {
        GetRelationalDatabaseMetricDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRelationalDatabaseMetricDataError {
    /// Creates a new `GetRelationalDatabaseMetricDataError`.
    pub fn new(
        kind: GetRelationalDatabaseMetricDataErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRelationalDatabaseMetricDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRelationalDatabaseMetricDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRelationalDatabaseMetricDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRelationalDatabaseMetricDataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseMetricDataErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseMetricDataErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseMetricDataErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseMetricDataErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseMetricDataErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseMetricDataErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseMetricDataErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseMetricDataErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseMetricDataErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseMetricDataErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseMetricDataErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseMetricDataErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseMetricDataErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseMetricDataErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetRelationalDatabaseMetricDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRelationalDatabaseMetricDataErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRelationalDatabaseMetricDataErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseMetricDataErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetRelationalDatabaseMetricDataErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRelationalDatabaseMetricDataErrorKind::OperationFailureException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseMetricDataErrorKind::ServiceException(_inner) => Some(_inner),
            GetRelationalDatabaseMetricDataErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseMetricDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRelationalDatabaseParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRelationalDatabaseParametersError {
    /// Kind of error that occurred.
    pub kind: GetRelationalDatabaseParametersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRelationalDatabaseParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRelationalDatabaseParametersErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRelationalDatabaseParametersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRelationalDatabaseParametersErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseParametersErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseParametersErrorKind::InvalidInputException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseParametersErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseParametersErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseParametersErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseParametersErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseParametersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRelationalDatabaseParametersError {
    fn code(&self) -> Option<&str> {
        GetRelationalDatabaseParametersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRelationalDatabaseParametersError {
    /// Creates a new `GetRelationalDatabaseParametersError`.
    pub fn new(
        kind: GetRelationalDatabaseParametersErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRelationalDatabaseParametersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRelationalDatabaseParametersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRelationalDatabaseParametersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRelationalDatabaseParametersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseParametersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseParametersErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseParametersErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseParametersErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseParametersErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseParametersErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseParametersErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseParametersErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseParametersErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseParametersErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseParametersErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseParametersErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseParametersErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseParametersErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetRelationalDatabaseParametersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRelationalDatabaseParametersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRelationalDatabaseParametersErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseParametersErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetRelationalDatabaseParametersErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRelationalDatabaseParametersErrorKind::OperationFailureException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseParametersErrorKind::ServiceException(_inner) => Some(_inner),
            GetRelationalDatabaseParametersErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseParametersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRelationalDatabases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRelationalDatabasesError {
    /// Kind of error that occurred.
    pub kind: GetRelationalDatabasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRelationalDatabases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRelationalDatabasesErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRelationalDatabasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRelationalDatabasesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetRelationalDatabasesErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabasesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetRelationalDatabasesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRelationalDatabasesErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetRelationalDatabasesErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetRelationalDatabasesErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetRelationalDatabasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRelationalDatabasesError {
    fn code(&self) -> Option<&str> {
        GetRelationalDatabasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRelationalDatabasesError {
    /// Creates a new `GetRelationalDatabasesError`.
    pub fn new(kind: GetRelationalDatabasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRelationalDatabasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRelationalDatabasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRelationalDatabasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRelationalDatabasesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRelationalDatabasesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabasesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabasesErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabasesErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabasesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabasesErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabasesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabasesErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabasesErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabasesErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabasesErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabasesErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabasesErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabasesErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetRelationalDatabasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRelationalDatabasesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRelationalDatabasesErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabasesErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetRelationalDatabasesErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRelationalDatabasesErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetRelationalDatabasesErrorKind::ServiceException(_inner) => Some(_inner),
            GetRelationalDatabasesErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetRelationalDatabasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRelationalDatabaseSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRelationalDatabaseSnapshotError {
    /// Kind of error that occurred.
    pub kind: GetRelationalDatabaseSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRelationalDatabaseSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRelationalDatabaseSnapshotErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRelationalDatabaseSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRelationalDatabaseSnapshotErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseSnapshotErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseSnapshotErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseSnapshotErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseSnapshotErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseSnapshotErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseSnapshotErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRelationalDatabaseSnapshotError {
    fn code(&self) -> Option<&str> {
        GetRelationalDatabaseSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRelationalDatabaseSnapshotError {
    /// Creates a new `GetRelationalDatabaseSnapshotError`.
    pub fn new(
        kind: GetRelationalDatabaseSnapshotErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRelationalDatabaseSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRelationalDatabaseSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRelationalDatabaseSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRelationalDatabaseSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseSnapshotErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseSnapshotErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseSnapshotErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseSnapshotErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseSnapshotErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseSnapshotErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseSnapshotErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseSnapshotErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseSnapshotErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseSnapshotErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseSnapshotErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseSnapshotErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseSnapshotErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseSnapshotErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetRelationalDatabaseSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRelationalDatabaseSnapshotErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRelationalDatabaseSnapshotErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseSnapshotErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetRelationalDatabaseSnapshotErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRelationalDatabaseSnapshotErrorKind::OperationFailureException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseSnapshotErrorKind::ServiceException(_inner) => Some(_inner),
            GetRelationalDatabaseSnapshotErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRelationalDatabaseSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRelationalDatabaseSnapshotsError {
    /// Kind of error that occurred.
    pub kind: GetRelationalDatabaseSnapshotsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRelationalDatabaseSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRelationalDatabaseSnapshotsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRelationalDatabaseSnapshotsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRelationalDatabaseSnapshotsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseSnapshotsErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseSnapshotsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseSnapshotsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseSnapshotsErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseSnapshotsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetRelationalDatabaseSnapshotsErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            GetRelationalDatabaseSnapshotsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRelationalDatabaseSnapshotsError {
    fn code(&self) -> Option<&str> {
        GetRelationalDatabaseSnapshotsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRelationalDatabaseSnapshotsError {
    /// Creates a new `GetRelationalDatabaseSnapshotsError`.
    pub fn new(
        kind: GetRelationalDatabaseSnapshotsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRelationalDatabaseSnapshotsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRelationalDatabaseSnapshotsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRelationalDatabaseSnapshotsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRelationalDatabaseSnapshotsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseSnapshotsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseSnapshotsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseSnapshotsErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseSnapshotsErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseSnapshotsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseSnapshotsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseSnapshotsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseSnapshotsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseSnapshotsErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseSnapshotsErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseSnapshotsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseSnapshotsErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRelationalDatabaseSnapshotsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRelationalDatabaseSnapshotsErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetRelationalDatabaseSnapshotsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRelationalDatabaseSnapshotsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetRelationalDatabaseSnapshotsErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseSnapshotsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetRelationalDatabaseSnapshotsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetRelationalDatabaseSnapshotsErrorKind::OperationFailureException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseSnapshotsErrorKind::ServiceException(_inner) => Some(_inner),
            GetRelationalDatabaseSnapshotsErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            GetRelationalDatabaseSnapshotsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetStaticIp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetStaticIpError {
    /// Kind of error that occurred.
    pub kind: GetStaticIpErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetStaticIp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetStaticIpErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetStaticIpError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetStaticIpErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetStaticIpErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            GetStaticIpErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetStaticIpErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetStaticIpErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetStaticIpErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetStaticIpErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetStaticIpErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetStaticIpError {
    fn code(&self) -> Option<&str> {
        GetStaticIpError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetStaticIpError {
    /// Creates a new `GetStaticIpError`.
    pub fn new(kind: GetStaticIpErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetStaticIpError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetStaticIpErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetStaticIpError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetStaticIpErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetStaticIpErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetStaticIpErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetStaticIpErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStaticIpErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetStaticIpErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetStaticIpErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetStaticIpErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetStaticIpErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetStaticIpErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStaticIpErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetStaticIpErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetStaticIpErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetStaticIpErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStaticIpErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetStaticIpError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetStaticIpErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetStaticIpErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetStaticIpErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetStaticIpErrorKind::NotFoundException(_inner) => Some(_inner),
            GetStaticIpErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetStaticIpErrorKind::ServiceException(_inner) => Some(_inner),
            GetStaticIpErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetStaticIpErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetStaticIps` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetStaticIpsError {
    /// Kind of error that occurred.
    pub kind: GetStaticIpsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetStaticIps` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetStaticIpsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetStaticIpsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetStaticIpsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetStaticIpsErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            GetStaticIpsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetStaticIpsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetStaticIpsErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            GetStaticIpsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            GetStaticIpsErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            GetStaticIpsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetStaticIpsError {
    fn code(&self) -> Option<&str> {
        GetStaticIpsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetStaticIpsError {
    /// Creates a new `GetStaticIpsError`.
    pub fn new(kind: GetStaticIpsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetStaticIpsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetStaticIpsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetStaticIpsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetStaticIpsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetStaticIpsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetStaticIpsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetStaticIpsErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStaticIpsErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `GetStaticIpsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetStaticIpsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetStaticIpsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetStaticIpsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetStaticIpsErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStaticIpsErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `GetStaticIpsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, GetStaticIpsErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `GetStaticIpsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetStaticIpsErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for GetStaticIpsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetStaticIpsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetStaticIpsErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            GetStaticIpsErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetStaticIpsErrorKind::NotFoundException(_inner) => Some(_inner),
            GetStaticIpsErrorKind::OperationFailureException(_inner) => Some(_inner),
            GetStaticIpsErrorKind::ServiceException(_inner) => Some(_inner),
            GetStaticIpsErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            GetStaticIpsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportKeyPair` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportKeyPairError {
    /// Kind of error that occurred.
    pub kind: ImportKeyPairErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportKeyPair` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportKeyPairErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportKeyPairError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportKeyPairErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ImportKeyPairErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            ImportKeyPairErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ImportKeyPairErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ImportKeyPairErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            ImportKeyPairErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ImportKeyPairErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            ImportKeyPairErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportKeyPairError {
    fn code(&self) -> Option<&str> {
        ImportKeyPairError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportKeyPairError {
    /// Creates a new `ImportKeyPairError`.
    pub fn new(kind: ImportKeyPairErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportKeyPairError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportKeyPairErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportKeyPairError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportKeyPairErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ImportKeyPairErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ImportKeyPairErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ImportKeyPairErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportKeyPairErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportKeyPairErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, ImportKeyPairErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `ImportKeyPairErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ImportKeyPairErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ImportKeyPairErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportKeyPairErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ImportKeyPairErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, ImportKeyPairErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `ImportKeyPairErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            ImportKeyPairErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for ImportKeyPairError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportKeyPairErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ImportKeyPairErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            ImportKeyPairErrorKind::InvalidInputException(_inner) => Some(_inner),
            ImportKeyPairErrorKind::NotFoundException(_inner) => Some(_inner),
            ImportKeyPairErrorKind::OperationFailureException(_inner) => Some(_inner),
            ImportKeyPairErrorKind::ServiceException(_inner) => Some(_inner),
            ImportKeyPairErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            ImportKeyPairErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `IsVpcPeered` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct IsVpcPeeredError {
    /// Kind of error that occurred.
    pub kind: IsVpcPeeredErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `IsVpcPeered` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum IsVpcPeeredErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for IsVpcPeeredError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            IsVpcPeeredErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            IsVpcPeeredErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            IsVpcPeeredErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            IsVpcPeeredErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            IsVpcPeeredErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            IsVpcPeeredErrorKind::ServiceException(_inner) => _inner.fmt(f),
            IsVpcPeeredErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            IsVpcPeeredErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for IsVpcPeeredError {
    fn code(&self) -> Option<&str> {
        IsVpcPeeredError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl IsVpcPeeredError {
    /// Creates a new `IsVpcPeeredError`.
    pub fn new(kind: IsVpcPeeredErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `IsVpcPeeredError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: IsVpcPeeredErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `IsVpcPeeredError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: IsVpcPeeredErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `IsVpcPeeredErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, IsVpcPeeredErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `IsVpcPeeredErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            IsVpcPeeredErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `IsVpcPeeredErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, IsVpcPeeredErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `IsVpcPeeredErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, IsVpcPeeredErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `IsVpcPeeredErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            IsVpcPeeredErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `IsVpcPeeredErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, IsVpcPeeredErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `IsVpcPeeredErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            IsVpcPeeredErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for IsVpcPeeredError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            IsVpcPeeredErrorKind::AccessDeniedException(_inner) => Some(_inner),
            IsVpcPeeredErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            IsVpcPeeredErrorKind::InvalidInputException(_inner) => Some(_inner),
            IsVpcPeeredErrorKind::NotFoundException(_inner) => Some(_inner),
            IsVpcPeeredErrorKind::OperationFailureException(_inner) => Some(_inner),
            IsVpcPeeredErrorKind::ServiceException(_inner) => Some(_inner),
            IsVpcPeeredErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            IsVpcPeeredErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `OpenInstancePublicPorts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct OpenInstancePublicPortsError {
    /// Kind of error that occurred.
    pub kind: OpenInstancePublicPortsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `OpenInstancePublicPorts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum OpenInstancePublicPortsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for OpenInstancePublicPortsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            OpenInstancePublicPortsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            OpenInstancePublicPortsErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            OpenInstancePublicPortsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            OpenInstancePublicPortsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            OpenInstancePublicPortsErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            OpenInstancePublicPortsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            OpenInstancePublicPortsErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            OpenInstancePublicPortsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for OpenInstancePublicPortsError {
    fn code(&self) -> Option<&str> {
        OpenInstancePublicPortsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl OpenInstancePublicPortsError {
    /// Creates a new `OpenInstancePublicPortsError`.
    pub fn new(kind: OpenInstancePublicPortsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `OpenInstancePublicPortsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: OpenInstancePublicPortsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `OpenInstancePublicPortsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: OpenInstancePublicPortsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `OpenInstancePublicPortsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            OpenInstancePublicPortsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `OpenInstancePublicPortsErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            OpenInstancePublicPortsErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `OpenInstancePublicPortsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            OpenInstancePublicPortsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `OpenInstancePublicPortsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            OpenInstancePublicPortsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `OpenInstancePublicPortsErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            OpenInstancePublicPortsErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `OpenInstancePublicPortsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            OpenInstancePublicPortsErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `OpenInstancePublicPortsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            OpenInstancePublicPortsErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for OpenInstancePublicPortsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            OpenInstancePublicPortsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            OpenInstancePublicPortsErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            OpenInstancePublicPortsErrorKind::InvalidInputException(_inner) => Some(_inner),
            OpenInstancePublicPortsErrorKind::NotFoundException(_inner) => Some(_inner),
            OpenInstancePublicPortsErrorKind::OperationFailureException(_inner) => Some(_inner),
            OpenInstancePublicPortsErrorKind::ServiceException(_inner) => Some(_inner),
            OpenInstancePublicPortsErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            OpenInstancePublicPortsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PeerVpc` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PeerVpcError {
    /// Kind of error that occurred.
    pub kind: PeerVpcErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PeerVpc` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PeerVpcErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PeerVpcError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PeerVpcErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PeerVpcErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            PeerVpcErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            PeerVpcErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PeerVpcErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            PeerVpcErrorKind::ServiceException(_inner) => _inner.fmt(f),
            PeerVpcErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            PeerVpcErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PeerVpcError {
    fn code(&self) -> Option<&str> {
        PeerVpcError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PeerVpcError {
    /// Creates a new `PeerVpcError`.
    pub fn new(kind: PeerVpcErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PeerVpcError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PeerVpcErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PeerVpcError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PeerVpcErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PeerVpcErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, PeerVpcErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `PeerVpcErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            PeerVpcErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `PeerVpcErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, PeerVpcErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `PeerVpcErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, PeerVpcErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `PeerVpcErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(&self.kind, PeerVpcErrorKind::OperationFailureException(_))
    }
    /// Returns `true` if the error kind is `PeerVpcErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, PeerVpcErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `PeerVpcErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(&self.kind, PeerVpcErrorKind::UnauthenticatedException(_))
    }
}
impl std::error::Error for PeerVpcError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PeerVpcErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PeerVpcErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            PeerVpcErrorKind::InvalidInputException(_inner) => Some(_inner),
            PeerVpcErrorKind::NotFoundException(_inner) => Some(_inner),
            PeerVpcErrorKind::OperationFailureException(_inner) => Some(_inner),
            PeerVpcErrorKind::ServiceException(_inner) => Some(_inner),
            PeerVpcErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            PeerVpcErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutAlarm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutAlarmError {
    /// Kind of error that occurred.
    pub kind: PutAlarmErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutAlarm` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutAlarmErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutAlarmError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutAlarmErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutAlarmErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            PutAlarmErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutAlarmErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            PutAlarmErrorKind::ServiceException(_inner) => _inner.fmt(f),
            PutAlarmErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            PutAlarmErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutAlarmError {
    fn code(&self) -> Option<&str> {
        PutAlarmError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutAlarmError {
    /// Creates a new `PutAlarmError`.
    pub fn new(kind: PutAlarmErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutAlarmError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutAlarmErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutAlarmError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutAlarmErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutAlarmErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, PutAlarmErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `PutAlarmErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, PutAlarmErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `PutAlarmErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutAlarmErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `PutAlarmErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(&self.kind, PutAlarmErrorKind::OperationFailureException(_))
    }
    /// Returns `true` if the error kind is `PutAlarmErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, PutAlarmErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `PutAlarmErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(&self.kind, PutAlarmErrorKind::UnauthenticatedException(_))
    }
}
impl std::error::Error for PutAlarmError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutAlarmErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutAlarmErrorKind::InvalidInputException(_inner) => Some(_inner),
            PutAlarmErrorKind::NotFoundException(_inner) => Some(_inner),
            PutAlarmErrorKind::OperationFailureException(_inner) => Some(_inner),
            PutAlarmErrorKind::ServiceException(_inner) => Some(_inner),
            PutAlarmErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            PutAlarmErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutInstancePublicPorts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutInstancePublicPortsError {
    /// Kind of error that occurred.
    pub kind: PutInstancePublicPortsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutInstancePublicPorts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutInstancePublicPortsErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutInstancePublicPortsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutInstancePublicPortsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutInstancePublicPortsErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            PutInstancePublicPortsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            PutInstancePublicPortsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutInstancePublicPortsErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            PutInstancePublicPortsErrorKind::ServiceException(_inner) => _inner.fmt(f),
            PutInstancePublicPortsErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            PutInstancePublicPortsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutInstancePublicPortsError {
    fn code(&self) -> Option<&str> {
        PutInstancePublicPortsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutInstancePublicPortsError {
    /// Creates a new `PutInstancePublicPortsError`.
    pub fn new(kind: PutInstancePublicPortsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutInstancePublicPortsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutInstancePublicPortsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutInstancePublicPortsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutInstancePublicPortsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutInstancePublicPortsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInstancePublicPortsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInstancePublicPortsErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInstancePublicPortsErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInstancePublicPortsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInstancePublicPortsErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInstancePublicPortsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInstancePublicPortsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInstancePublicPortsErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInstancePublicPortsErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInstancePublicPortsErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInstancePublicPortsErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `PutInstancePublicPortsErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutInstancePublicPortsErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for PutInstancePublicPortsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutInstancePublicPortsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutInstancePublicPortsErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            PutInstancePublicPortsErrorKind::InvalidInputException(_inner) => Some(_inner),
            PutInstancePublicPortsErrorKind::NotFoundException(_inner) => Some(_inner),
            PutInstancePublicPortsErrorKind::OperationFailureException(_inner) => Some(_inner),
            PutInstancePublicPortsErrorKind::ServiceException(_inner) => Some(_inner),
            PutInstancePublicPortsErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            PutInstancePublicPortsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RebootInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RebootInstanceError {
    /// Kind of error that occurred.
    pub kind: RebootInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RebootInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RebootInstanceErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RebootInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RebootInstanceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RebootInstanceErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            RebootInstanceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            RebootInstanceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            RebootInstanceErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            RebootInstanceErrorKind::ServiceException(_inner) => _inner.fmt(f),
            RebootInstanceErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            RebootInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RebootInstanceError {
    fn code(&self) -> Option<&str> {
        RebootInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RebootInstanceError {
    /// Creates a new `RebootInstanceError`.
    pub fn new(kind: RebootInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RebootInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RebootInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RebootInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RebootInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RebootInstanceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RebootInstanceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RebootInstanceErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            RebootInstanceErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `RebootInstanceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            RebootInstanceErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `RebootInstanceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, RebootInstanceErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `RebootInstanceErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            RebootInstanceErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `RebootInstanceErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, RebootInstanceErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `RebootInstanceErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            RebootInstanceErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for RebootInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RebootInstanceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RebootInstanceErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            RebootInstanceErrorKind::InvalidInputException(_inner) => Some(_inner),
            RebootInstanceErrorKind::NotFoundException(_inner) => Some(_inner),
            RebootInstanceErrorKind::OperationFailureException(_inner) => Some(_inner),
            RebootInstanceErrorKind::ServiceException(_inner) => Some(_inner),
            RebootInstanceErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            RebootInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RebootRelationalDatabase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RebootRelationalDatabaseError {
    /// Kind of error that occurred.
    pub kind: RebootRelationalDatabaseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RebootRelationalDatabase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RebootRelationalDatabaseErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RebootRelationalDatabaseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RebootRelationalDatabaseErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RebootRelationalDatabaseErrorKind::AccountSetupInProgressException(_inner) => {
                _inner.fmt(f)
            }
            RebootRelationalDatabaseErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            RebootRelationalDatabaseErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            RebootRelationalDatabaseErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            RebootRelationalDatabaseErrorKind::ServiceException(_inner) => _inner.fmt(f),
            RebootRelationalDatabaseErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            RebootRelationalDatabaseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RebootRelationalDatabaseError {
    fn code(&self) -> Option<&str> {
        RebootRelationalDatabaseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RebootRelationalDatabaseError {
    /// Creates a new `RebootRelationalDatabaseError`.
    pub fn new(kind: RebootRelationalDatabaseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RebootRelationalDatabaseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RebootRelationalDatabaseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RebootRelationalDatabaseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RebootRelationalDatabaseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RebootRelationalDatabaseErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RebootRelationalDatabaseErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RebootRelationalDatabaseErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            RebootRelationalDatabaseErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `RebootRelationalDatabaseErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            RebootRelationalDatabaseErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `RebootRelationalDatabaseErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RebootRelationalDatabaseErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RebootRelationalDatabaseErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            RebootRelationalDatabaseErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `RebootRelationalDatabaseErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            RebootRelationalDatabaseErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `RebootRelationalDatabaseErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            RebootRelationalDatabaseErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for RebootRelationalDatabaseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RebootRelationalDatabaseErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RebootRelationalDatabaseErrorKind::AccountSetupInProgressException(_inner) => {
                Some(_inner)
            }
            RebootRelationalDatabaseErrorKind::InvalidInputException(_inner) => Some(_inner),
            RebootRelationalDatabaseErrorKind::NotFoundException(_inner) => Some(_inner),
            RebootRelationalDatabaseErrorKind::OperationFailureException(_inner) => Some(_inner),
            RebootRelationalDatabaseErrorKind::ServiceException(_inner) => Some(_inner),
            RebootRelationalDatabaseErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            RebootRelationalDatabaseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterContainerImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterContainerImageError {
    /// Kind of error that occurred.
    pub kind: RegisterContainerImageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterContainerImage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterContainerImageErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterContainerImageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterContainerImageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RegisterContainerImageErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            RegisterContainerImageErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            RegisterContainerImageErrorKind::ServiceException(_inner) => _inner.fmt(f),
            RegisterContainerImageErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            RegisterContainerImageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterContainerImageError {
    fn code(&self) -> Option<&str> {
        RegisterContainerImageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterContainerImageError {
    /// Creates a new `RegisterContainerImageError`.
    pub fn new(kind: RegisterContainerImageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterContainerImageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterContainerImageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterContainerImageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterContainerImageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterContainerImageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterContainerImageErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterContainerImageErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterContainerImageErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterContainerImageErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterContainerImageErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterContainerImageErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterContainerImageErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterContainerImageErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            RegisterContainerImageErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for RegisterContainerImageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterContainerImageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RegisterContainerImageErrorKind::InvalidInputException(_inner) => Some(_inner),
            RegisterContainerImageErrorKind::NotFoundException(_inner) => Some(_inner),
            RegisterContainerImageErrorKind::ServiceException(_inner) => Some(_inner),
            RegisterContainerImageErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            RegisterContainerImageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ReleaseStaticIp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ReleaseStaticIpError {
    /// Kind of error that occurred.
    pub kind: ReleaseStaticIpErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ReleaseStaticIp` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ReleaseStaticIpErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ReleaseStaticIpError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ReleaseStaticIpErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ReleaseStaticIpErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            ReleaseStaticIpErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ReleaseStaticIpErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ReleaseStaticIpErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            ReleaseStaticIpErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ReleaseStaticIpErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            ReleaseStaticIpErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ReleaseStaticIpError {
    fn code(&self) -> Option<&str> {
        ReleaseStaticIpError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ReleaseStaticIpError {
    /// Creates a new `ReleaseStaticIpError`.
    pub fn new(kind: ReleaseStaticIpErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ReleaseStaticIpError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ReleaseStaticIpErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ReleaseStaticIpError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ReleaseStaticIpErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ReleaseStaticIpErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReleaseStaticIpErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ReleaseStaticIpErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReleaseStaticIpErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `ReleaseStaticIpErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReleaseStaticIpErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ReleaseStaticIpErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ReleaseStaticIpErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ReleaseStaticIpErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReleaseStaticIpErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ReleaseStaticIpErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, ReleaseStaticIpErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `ReleaseStaticIpErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            ReleaseStaticIpErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for ReleaseStaticIpError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ReleaseStaticIpErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ReleaseStaticIpErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            ReleaseStaticIpErrorKind::InvalidInputException(_inner) => Some(_inner),
            ReleaseStaticIpErrorKind::NotFoundException(_inner) => Some(_inner),
            ReleaseStaticIpErrorKind::OperationFailureException(_inner) => Some(_inner),
            ReleaseStaticIpErrorKind::ServiceException(_inner) => Some(_inner),
            ReleaseStaticIpErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            ReleaseStaticIpErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResetDistributionCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResetDistributionCacheError {
    /// Kind of error that occurred.
    pub kind: ResetDistributionCacheErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResetDistributionCache` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResetDistributionCacheErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResetDistributionCacheError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResetDistributionCacheErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ResetDistributionCacheErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            ResetDistributionCacheErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ResetDistributionCacheErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            ResetDistributionCacheErrorKind::ServiceException(_inner) => _inner.fmt(f),
            ResetDistributionCacheErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            ResetDistributionCacheErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResetDistributionCacheError {
    fn code(&self) -> Option<&str> {
        ResetDistributionCacheError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResetDistributionCacheError {
    /// Creates a new `ResetDistributionCacheError`.
    pub fn new(kind: ResetDistributionCacheErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResetDistributionCacheError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResetDistributionCacheErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResetDistributionCacheError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResetDistributionCacheErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResetDistributionCacheErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetDistributionCacheErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetDistributionCacheErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetDistributionCacheErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetDistributionCacheErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetDistributionCacheErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetDistributionCacheErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetDistributionCacheErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetDistributionCacheErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetDistributionCacheErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ResetDistributionCacheErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResetDistributionCacheErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for ResetDistributionCacheError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResetDistributionCacheErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ResetDistributionCacheErrorKind::InvalidInputException(_inner) => Some(_inner),
            ResetDistributionCacheErrorKind::NotFoundException(_inner) => Some(_inner),
            ResetDistributionCacheErrorKind::OperationFailureException(_inner) => Some(_inner),
            ResetDistributionCacheErrorKind::ServiceException(_inner) => Some(_inner),
            ResetDistributionCacheErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            ResetDistributionCacheErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SendContactMethodVerification` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SendContactMethodVerificationError {
    /// Kind of error that occurred.
    pub kind: SendContactMethodVerificationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SendContactMethodVerification` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SendContactMethodVerificationErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SendContactMethodVerificationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SendContactMethodVerificationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            SendContactMethodVerificationErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            SendContactMethodVerificationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            SendContactMethodVerificationErrorKind::OperationFailureException(_inner) => {
                _inner.fmt(f)
            }
            SendContactMethodVerificationErrorKind::ServiceException(_inner) => _inner.fmt(f),
            SendContactMethodVerificationErrorKind::UnauthenticatedException(_inner) => {
                _inner.fmt(f)
            }
            SendContactMethodVerificationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SendContactMethodVerificationError {
    fn code(&self) -> Option<&str> {
        SendContactMethodVerificationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SendContactMethodVerificationError {
    /// Creates a new `SendContactMethodVerificationError`.
    pub fn new(
        kind: SendContactMethodVerificationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SendContactMethodVerificationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SendContactMethodVerificationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SendContactMethodVerificationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SendContactMethodVerificationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SendContactMethodVerificationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendContactMethodVerificationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `SendContactMethodVerificationErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendContactMethodVerificationErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `SendContactMethodVerificationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendContactMethodVerificationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SendContactMethodVerificationErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendContactMethodVerificationErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `SendContactMethodVerificationErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendContactMethodVerificationErrorKind::ServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `SendContactMethodVerificationErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            SendContactMethodVerificationErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for SendContactMethodVerificationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SendContactMethodVerificationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            SendContactMethodVerificationErrorKind::InvalidInputException(_inner) => Some(_inner),
            SendContactMethodVerificationErrorKind::NotFoundException(_inner) => Some(_inner),
            SendContactMethodVerificationErrorKind::OperationFailureException(_inner) => {
                Some(_inner)
            }
            SendContactMethodVerificationErrorKind::ServiceException(_inner) => Some(_inner),
            SendContactMethodVerificationErrorKind::UnauthenticatedException(_inner) => {
                Some(_inner)
            }
            SendContactMethodVerificationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetIpAddressType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetIpAddressTypeError {
    /// Kind of error that occurred.
    pub kind: SetIpAddressTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SetIpAddressType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SetIpAddressTypeErrorKind {
    /// <p>Lightsail throws this exception when the user cannot be authenticated or uses invalid
    /// credentials to access a resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Lightsail throws this exception when an account is still in the setup in progress
    /// state.</p>
    AccountSetupInProgressException(crate::error::AccountSetupInProgressException),
    /// <p>Lightsail throws this exception when user input does not conform to the validation rules
    /// of an input field.</p>
    /// <note>
    /// <p>Domain and distribution APIs are only available in the N. Virginia
    /// (<code>us-east-1</code>) AWS Region. Please set your AWS Region configuration to
    /// <code>us-east-1</code> to create, view, or edit these resources.</p>
    /// </note>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>Lightsail throws this exception when it cannot find a resource.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>Lightsail throws this exception when an operation fails to execute.</p>
    OperationFailureException(crate::error::OperationFailureException),
    /// <p>A general service exception.</p>
    ServiceException(crate::error::ServiceException),
    /// <p>Lightsail throws this exception when the user has not been authenticated.</p>
    UnauthenticatedException(crate::error::UnauthenticatedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SetIpAddressTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SetIpAddressTypeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            SetIpAddressTypeErrorKind::AccountSetupInProgressException(_inner) => _inner.fmt(f),
            SetIpAddressTypeErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            SetIpAddressTypeErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            SetIpAddressTypeErrorKind::OperationFailureException(_inner) => _inner.fmt(f),
            SetIpAddressTypeErrorKind::ServiceException(_inner) => _inner.fmt(f),
            SetIpAddressTypeErrorKind::UnauthenticatedException(_inner) => _inner.fmt(f),
            SetIpAddressTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SetIpAddressTypeError {
    fn code(&self) -> Option<&str> {
        SetIpAddressTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SetIpAddressTypeError {
    /// Creates a new `SetIpAddressTypeError`.
    pub fn new(kind: SetIpAddressTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SetIpAddressTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SetIpAddressTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SetIpAddressTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SetIpAddressTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SetIpAddressTypeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetIpAddressTypeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `SetIpAddressTypeErrorKind::AccountSetupInProgressException`.
    pub fn is_account_setup_in_progress_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetIpAddressTypeErrorKind::AccountSetupInProgressException(_)
        )
    }
    /// Returns `true` if the error kind is `SetIpAddressTypeErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetIpAddressTypeErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `SetIpAddressTypeErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, SetIpAddressTypeErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `SetIpAddressTypeErrorKind::OperationFailureException`.
    pub fn is_operation_failure_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetIpAddressTypeErrorKind::OperationFailureException(_)
        )
    }
    /// Returns `true` if the error kind is `SetIpAddressTypeErrorKind::ServiceException`.
    pub fn is_service_exception(&self) -> bool {
        matches!(&self.kind, SetIpAddressTypeErrorKind::ServiceException(_))
    }
    /// Returns `true` if the error kind is `SetIpAddressTypeErrorKind::UnauthenticatedException`.
    pub fn is_unauthenticated_exception(&self) -> bool {
        matches!(
            &self.kind,
            SetIpAddressTypeErrorKind::UnauthenticatedException(_)
        )
    }
}
impl std::error::Error for SetIpAddressTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SetIpAddressTypeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            SetIpAddressTypeErrorKind::AccountSetupInProgressException(_inner) => Some(_inner),
            SetIpAddressTypeErrorKind::InvalidInputException(_inner) => Some(_inner),
            SetIpAddressTypeErrorKind::NotFoundException(_inner) => Some(_inner),
            SetIpAddressTypeErrorKind::OperationFailureException(_inner) => Some(_inner),
            SetIpAddressTypeErrorKind::ServiceException(_inner) => Some(_inner),
            SetIpAddressTypeErrorKind::UnauthenticatedException(_inner) => Some(_inner),
            SetIpAddressTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SetResourceAccessForBucket` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SetResourceAccessForBucketError {
    /// Kind of error that occurred.
    pub