// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AcceptGrantInput`](crate::input::AcceptGrantInput)
pub mod accept_grant_input {
    /// A builder for [`AcceptGrantInput`](crate::input::AcceptGrantInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) grant_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn grant_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn set_grant_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptGrantInput`](crate::input::AcceptGrantInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptGrantInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcceptGrantInput {
                grant_arn: self.grant_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AcceptGrantInputOperationOutputAlias = crate::operation::AcceptGrant;
#[doc(hidden)]
pub type AcceptGrantInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AcceptGrantInput {
    /// Consumes the builder and constructs an Operation<[`AcceptGrant`](crate::operation::AcceptGrant)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptGrant,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AcceptGrantInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AcceptGrantInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.AcceptGrant",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_accept_grant(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptGrant::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptGrant",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AcceptGrantInput`](crate::input::AcceptGrantInput)
    pub fn builder() -> crate::input::accept_grant_input::Builder {
        crate::input::accept_grant_input::Builder::default()
    }
}

/// See [`CheckInLicenseInput`](crate::input::CheckInLicenseInput)
pub mod check_in_license_input {
    /// A builder for [`CheckInLicenseInput`](crate::input::CheckInLicenseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_consumption_token: std::option::Option<std::string::String>,
        pub(crate) beneficiary: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>License consumption token.</p>
        pub fn license_consumption_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_consumption_token = Some(input.into());
            self
        }
        /// <p>License consumption token.</p>
        pub fn set_license_consumption_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_consumption_token = input;
            self
        }
        /// <p>License beneficiary.</p>
        pub fn beneficiary(mut self, input: impl Into<std::string::String>) -> Self {
            self.beneficiary = Some(input.into());
            self
        }
        /// <p>License beneficiary.</p>
        pub fn set_beneficiary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.beneficiary = input;
            self
        }
        /// Consumes the builder and constructs a [`CheckInLicenseInput`](crate::input::CheckInLicenseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CheckInLicenseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CheckInLicenseInput {
                license_consumption_token: self.license_consumption_token,
                beneficiary: self.beneficiary,
            })
        }
    }
}
#[doc(hidden)]
pub type CheckInLicenseInputOperationOutputAlias = crate::operation::CheckInLicense;
#[doc(hidden)]
pub type CheckInLicenseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CheckInLicenseInput {
    /// Consumes the builder and constructs an Operation<[`CheckInLicense`](crate::operation::CheckInLicense)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CheckInLicense,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CheckInLicenseInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CheckInLicenseInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.CheckInLicense",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_check_in_license(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CheckInLicense::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CheckInLicense",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CheckInLicenseInput`](crate::input::CheckInLicenseInput)
    pub fn builder() -> crate::input::check_in_license_input::Builder {
        crate::input::check_in_license_input::Builder::default()
    }
}

/// See [`CheckoutBorrowLicenseInput`](crate::input::CheckoutBorrowLicenseInput)
pub mod checkout_borrow_license_input {
    /// A builder for [`CheckoutBorrowLicenseInput`](crate::input::CheckoutBorrowLicenseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_arn: std::option::Option<std::string::String>,
        pub(crate) entitlements: std::option::Option<std::vec::Vec<crate::model::EntitlementData>>,
        pub(crate) digital_signature_method:
            std::option::Option<crate::model::DigitalSignatureMethod>,
        pub(crate) node_id: std::option::Option<std::string::String>,
        pub(crate) checkout_metadata: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the license. The license must use the borrow consumption configuration.</p>
        pub fn license_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license. The license must use the borrow consumption configuration.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_arn = input;
            self
        }
        /// Appends an item to `entitlements`.
        ///
        /// To override the contents of this collection use [`set_entitlements`](Self::set_entitlements).
        ///
        /// <p>License entitlements. Partial checkouts are not supported.</p>
        pub fn entitlements(mut self, input: crate::model::EntitlementData) -> Self {
            let mut v = self.entitlements.unwrap_or_default();
            v.push(input);
            self.entitlements = Some(v);
            self
        }
        /// <p>License entitlements. Partial checkouts are not supported.</p>
        pub fn set_entitlements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntitlementData>>,
        ) -> Self {
            self.entitlements = input;
            self
        }
        /// <p>Digital signature method. The possible value is JSON Web Signature (JWS) algorithm PS384. For more information, see <a href="https://tools.ietf.org/html/rfc7518#section-3.5">RFC 7518 Digital Signature with RSASSA-PSS</a>.</p>
        pub fn digital_signature_method(
            mut self,
            input: crate::model::DigitalSignatureMethod,
        ) -> Self {
            self.digital_signature_method = Some(input);
            self
        }
        /// <p>Digital signature method. The possible value is JSON Web Signature (JWS) algorithm PS384. For more information, see <a href="https://tools.ietf.org/html/rfc7518#section-3.5">RFC 7518 Digital Signature with RSASSA-PSS</a>.</p>
        pub fn set_digital_signature_method(
            mut self,
            input: std::option::Option<crate::model::DigitalSignatureMethod>,
        ) -> Self {
            self.digital_signature_method = input;
            self
        }
        /// <p>Node ID.</p>
        pub fn node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_id = Some(input.into());
            self
        }
        /// <p>Node ID.</p>
        pub fn set_node_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_id = input;
            self
        }
        /// Appends an item to `checkout_metadata`.
        ///
        /// To override the contents of this collection use [`set_checkout_metadata`](Self::set_checkout_metadata).
        ///
        /// <p>Information about constraints.</p>
        pub fn checkout_metadata(mut self, input: crate::model::Metadata) -> Self {
            let mut v = self.checkout_metadata.unwrap_or_default();
            v.push(input);
            self.checkout_metadata = Some(v);
            self
        }
        /// <p>Information about constraints.</p>
        pub fn set_checkout_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
        ) -> Self {
            self.checkout_metadata = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CheckoutBorrowLicenseInput`](crate::input::CheckoutBorrowLicenseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CheckoutBorrowLicenseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CheckoutBorrowLicenseInput {
                license_arn: self.license_arn,
                entitlements: self.entitlements,
                digital_signature_method: self.digital_signature_method,
                node_id: self.node_id,
                checkout_metadata: self.checkout_metadata,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CheckoutBorrowLicenseInputOperationOutputAlias = crate::operation::CheckoutBorrowLicense;
#[doc(hidden)]
pub type CheckoutBorrowLicenseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CheckoutBorrowLicenseInput {
    /// Consumes the builder and constructs an Operation<[`CheckoutBorrowLicense`](crate::operation::CheckoutBorrowLicense)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CheckoutBorrowLicense,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CheckoutBorrowLicenseInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CheckoutBorrowLicenseInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.CheckoutBorrowLicense",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_checkout_borrow_license(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CheckoutBorrowLicense::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CheckoutBorrowLicense",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CheckoutBorrowLicenseInput`](crate::input::CheckoutBorrowLicenseInput)
    pub fn builder() -> crate::input::checkout_borrow_license_input::Builder {
        crate::input::checkout_borrow_license_input::Builder::default()
    }
}

/// See [`CheckoutLicenseInput`](crate::input::CheckoutLicenseInput)
pub mod checkout_license_input {
    /// A builder for [`CheckoutLicenseInput`](crate::input::CheckoutLicenseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_sku: std::option::Option<std::string::String>,
        pub(crate) checkout_type: std::option::Option<crate::model::CheckoutType>,
        pub(crate) key_fingerprint: std::option::Option<std::string::String>,
        pub(crate) entitlements: std::option::Option<std::vec::Vec<crate::model::EntitlementData>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) beneficiary: std::option::Option<std::string::String>,
        pub(crate) node_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Product SKU.</p>
        pub fn product_sku(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_sku = Some(input.into());
            self
        }
        /// <p>Product SKU.</p>
        pub fn set_product_sku(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_sku = input;
            self
        }
        /// <p>Checkout type.</p>
        pub fn checkout_type(mut self, input: crate::model::CheckoutType) -> Self {
            self.checkout_type = Some(input);
            self
        }
        /// <p>Checkout type.</p>
        pub fn set_checkout_type(
            mut self,
            input: std::option::Option<crate::model::CheckoutType>,
        ) -> Self {
            self.checkout_type = input;
            self
        }
        /// <p>Key fingerprint identifying the license.</p>
        pub fn key_fingerprint(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_fingerprint = Some(input.into());
            self
        }
        /// <p>Key fingerprint identifying the license.</p>
        pub fn set_key_fingerprint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.key_fingerprint = input;
            self
        }
        /// Appends an item to `entitlements`.
        ///
        /// To override the contents of this collection use [`set_entitlements`](Self::set_entitlements).
        ///
        /// <p>License entitlements.</p>
        pub fn entitlements(mut self, input: crate::model::EntitlementData) -> Self {
            let mut v = self.entitlements.unwrap_or_default();
            v.push(input);
            self.entitlements = Some(v);
            self
        }
        /// <p>License entitlements.</p>
        pub fn set_entitlements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntitlementData>>,
        ) -> Self {
            self.entitlements = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>License beneficiary.</p>
        pub fn beneficiary(mut self, input: impl Into<std::string::String>) -> Self {
            self.beneficiary = Some(input.into());
            self
        }
        /// <p>License beneficiary.</p>
        pub fn set_beneficiary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.beneficiary = input;
            self
        }
        /// <p>Node ID.</p>
        pub fn node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_id = Some(input.into());
            self
        }
        /// <p>Node ID.</p>
        pub fn set_node_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CheckoutLicenseInput`](crate::input::CheckoutLicenseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CheckoutLicenseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CheckoutLicenseInput {
                product_sku: self.product_sku,
                checkout_type: self.checkout_type,
                key_fingerprint: self.key_fingerprint,
                entitlements: self.entitlements,
                client_token: self.client_token,
                beneficiary: self.beneficiary,
                node_id: self.node_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CheckoutLicenseInputOperationOutputAlias = crate::operation::CheckoutLicense;
#[doc(hidden)]
pub type CheckoutLicenseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CheckoutLicenseInput {
    /// Consumes the builder and constructs an Operation<[`CheckoutLicense`](crate::operation::CheckoutLicense)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CheckoutLicense,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CheckoutLicenseInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CheckoutLicenseInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.CheckoutLicense",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_checkout_license(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CheckoutLicense::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CheckoutLicense",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CheckoutLicenseInput`](crate::input::CheckoutLicenseInput)
    pub fn builder() -> crate::input::checkout_license_input::Builder {
        crate::input::checkout_license_input::Builder::default()
    }
}

/// See [`CreateGrantInput`](crate::input::CreateGrantInput)
pub mod create_grant_input {
    /// A builder for [`CreateGrantInput`](crate::input::CreateGrantInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) grant_name: std::option::Option<std::string::String>,
        pub(crate) license_arn: std::option::Option<std::string::String>,
        pub(crate) principals: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) home_region: std::option::Option<std::string::String>,
        pub(crate) allowed_operations:
            std::option::Option<std::vec::Vec<crate::model::AllowedOperation>>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Grant name.</p>
        pub fn grant_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_name = Some(input.into());
            self
        }
        /// <p>Grant name.</p>
        pub fn set_grant_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_name = input;
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn license_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_arn = input;
            self
        }
        /// Appends an item to `principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>The grant principals.</p>
        pub fn principals(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.principals.unwrap_or_default();
            v.push(input.into());
            self.principals = Some(v);
            self
        }
        /// <p>The grant principals.</p>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.principals = input;
            self
        }
        /// <p>Home Region of the grant.</p>
        pub fn home_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_region = Some(input.into());
            self
        }
        /// <p>Home Region of the grant.</p>
        pub fn set_home_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.home_region = input;
            self
        }
        /// Appends an item to `allowed_operations`.
        ///
        /// To override the contents of this collection use [`set_allowed_operations`](Self::set_allowed_operations).
        ///
        /// <p>Allowed operations for the grant.</p>
        pub fn allowed_operations(mut self, input: crate::model::AllowedOperation) -> Self {
            let mut v = self.allowed_operations.unwrap_or_default();
            v.push(input);
            self.allowed_operations = Some(v);
            self
        }
        /// <p>Allowed operations for the grant.</p>
        pub fn set_allowed_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AllowedOperation>>,
        ) -> Self {
            self.allowed_operations = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGrantInput`](crate::input::CreateGrantInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGrantInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGrantInput {
                client_token: self.client_token,
                grant_name: self.grant_name,
                license_arn: self.license_arn,
                principals: self.principals,
                home_region: self.home_region,
                allowed_operations: self.allowed_operations,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGrantInputOperationOutputAlias = crate::operation::CreateGrant;
#[doc(hidden)]
pub type CreateGrantInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateGrantInput {
    /// Consumes the builder and constructs an Operation<[`CreateGrant`](crate::operation::CreateGrant)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGrant,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateGrantInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateGrantInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.CreateGrant",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_grant(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGrant::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGrant",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateGrantInput`](crate::input::CreateGrantInput)
    pub fn builder() -> crate::input::create_grant_input::Builder {
        crate::input::create_grant_input::Builder::default()
    }
}

/// See [`CreateGrantVersionInput`](crate::input::CreateGrantVersionInput)
pub mod create_grant_version_input {
    /// A builder for [`CreateGrantVersionInput`](crate::input::CreateGrantVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) grant_arn: std::option::Option<std::string::String>,
        pub(crate) grant_name: std::option::Option<std::string::String>,
        pub(crate) allowed_operations:
            std::option::Option<std::vec::Vec<crate::model::AllowedOperation>>,
        pub(crate) status: std::option::Option<crate::model::GrantStatus>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) source_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn grant_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn set_grant_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_arn = input;
            self
        }
        /// <p>Grant name.</p>
        pub fn grant_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_name = Some(input.into());
            self
        }
        /// <p>Grant name.</p>
        pub fn set_grant_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_name = input;
            self
        }
        /// Appends an item to `allowed_operations`.
        ///
        /// To override the contents of this collection use [`set_allowed_operations`](Self::set_allowed_operations).
        ///
        /// <p>Allowed operations for the grant.</p>
        pub fn allowed_operations(mut self, input: crate::model::AllowedOperation) -> Self {
            let mut v = self.allowed_operations.unwrap_or_default();
            v.push(input);
            self.allowed_operations = Some(v);
            self
        }
        /// <p>Allowed operations for the grant.</p>
        pub fn set_allowed_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AllowedOperation>>,
        ) -> Self {
            self.allowed_operations = input;
            self
        }
        /// <p>Grant status.</p>
        pub fn status(mut self, input: crate::model::GrantStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Grant status.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::GrantStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>Grant status reason.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>Grant status reason.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p>Current version of the grant.</p>
        pub fn source_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_version = Some(input.into());
            self
        }
        /// <p>Current version of the grant.</p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_version = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGrantVersionInput`](crate::input::CreateGrantVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGrantVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGrantVersionInput {
                client_token: self.client_token,
                grant_arn: self.grant_arn,
                grant_name: self.grant_name,
                allowed_operations: self.allowed_operations,
                status: self.status,
                status_reason: self.status_reason,
                source_version: self.source_version,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGrantVersionInputOperationOutputAlias = crate::operation::CreateGrantVersion;
#[doc(hidden)]
pub type CreateGrantVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateGrantVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateGrantVersion`](crate::operation::CreateGrantVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGrantVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateGrantVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateGrantVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.CreateGrantVersion",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_grant_version(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGrantVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGrantVersion",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateGrantVersionInput`](crate::input::CreateGrantVersionInput)
    pub fn builder() -> crate::input::create_grant_version_input::Builder {
        crate::input::create_grant_version_input::Builder::default()
    }
}

/// See [`CreateLicenseInput`](crate::input::CreateLicenseInput)
pub mod create_license_input {
    /// A builder for [`CreateLicenseInput`](crate::input::CreateLicenseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_name: std::option::Option<std::string::String>,
        pub(crate) product_name: std::option::Option<std::string::String>,
        pub(crate) product_sku: std::option::Option<std::string::String>,
        pub(crate) issuer: std::option::Option<crate::model::Issuer>,
        pub(crate) home_region: std::option::Option<std::string::String>,
        pub(crate) validity: std::option::Option<crate::model::DatetimeRange>,
        pub(crate) entitlements: std::option::Option<std::vec::Vec<crate::model::Entitlement>>,
        pub(crate) beneficiary: std::option::Option<std::string::String>,
        pub(crate) consumption_configuration:
            std::option::Option<crate::model::ConsumptionConfiguration>,
        pub(crate) license_metadata: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>License name.</p>
        pub fn license_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_name = Some(input.into());
            self
        }
        /// <p>License name.</p>
        pub fn set_license_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_name = input;
            self
        }
        /// <p>Product name.</p>
        pub fn product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_name = Some(input.into());
            self
        }
        /// <p>Product name.</p>
        pub fn set_product_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_name = input;
            self
        }
        /// <p>Product SKU.</p>
        pub fn product_sku(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_sku = Some(input.into());
            self
        }
        /// <p>Product SKU.</p>
        pub fn set_product_sku(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_sku = input;
            self
        }
        /// <p>License issuer.</p>
        pub fn issuer(mut self, input: crate::model::Issuer) -> Self {
            self.issuer = Some(input);
            self
        }
        /// <p>License issuer.</p>
        pub fn set_issuer(mut self, input: std::option::Option<crate::model::Issuer>) -> Self {
            self.issuer = input;
            self
        }
        /// <p>Home Region for the license.</p>
        pub fn home_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_region = Some(input.into());
            self
        }
        /// <p>Home Region for the license.</p>
        pub fn set_home_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.home_region = input;
            self
        }
        /// <p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>
        pub fn validity(mut self, input: crate::model::DatetimeRange) -> Self {
            self.validity = Some(input);
            self
        }
        /// <p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>
        pub fn set_validity(
            mut self,
            input: std::option::Option<crate::model::DatetimeRange>,
        ) -> Self {
            self.validity = input;
            self
        }
        /// Appends an item to `entitlements`.
        ///
        /// To override the contents of this collection use [`set_entitlements`](Self::set_entitlements).
        ///
        /// <p>License entitlements.</p>
        pub fn entitlements(mut self, input: crate::model::Entitlement) -> Self {
            let mut v = self.entitlements.unwrap_or_default();
            v.push(input);
            self.entitlements = Some(v);
            self
        }
        /// <p>License entitlements.</p>
        pub fn set_entitlements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Entitlement>>,
        ) -> Self {
            self.entitlements = input;
            self
        }
        /// <p>License beneficiary.</p>
        pub fn beneficiary(mut self, input: impl Into<std::string::String>) -> Self {
            self.beneficiary = Some(input.into());
            self
        }
        /// <p>License beneficiary.</p>
        pub fn set_beneficiary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.beneficiary = input;
            self
        }
        /// <p>Configuration for consumption of the license. Choose a provisional configuration for workloads running with continuous connectivity. Choose a borrow configuration for workloads with offline usage.</p>
        pub fn consumption_configuration(
            mut self,
            input: crate::model::ConsumptionConfiguration,
        ) -> Self {
            self.consumption_configuration = Some(input);
            self
        }
        /// <p>Configuration for consumption of the license. Choose a provisional configuration for workloads running with continuous connectivity. Choose a borrow configuration for workloads with offline usage.</p>
        pub fn set_consumption_configuration(
            mut self,
            input: std::option::Option<crate::model::ConsumptionConfiguration>,
        ) -> Self {
            self.consumption_configuration = input;
            self
        }
        /// Appends an item to `license_metadata`.
        ///
        /// To override the contents of this collection use [`set_license_metadata`](Self::set_license_metadata).
        ///
        /// <p>Information about the license.</p>
        pub fn license_metadata(mut self, input: crate::model::Metadata) -> Self {
            let mut v = self.license_metadata.unwrap_or_default();
            v.push(input);
            self.license_metadata = Some(v);
            self
        }
        /// <p>Information about the license.</p>
        pub fn set_license_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
        ) -> Self {
            self.license_metadata = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLicenseInput`](crate::input::CreateLicenseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLicenseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLicenseInput {
                license_name: self.license_name,
                product_name: self.product_name,
                product_sku: self.product_sku,
                issuer: self.issuer,
                home_region: self.home_region,
                validity: self.validity,
                entitlements: self.entitlements,
                beneficiary: self.beneficiary,
                consumption_configuration: self.consumption_configuration,
                license_metadata: self.license_metadata,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLicenseInputOperationOutputAlias = crate::operation::CreateLicense;
#[doc(hidden)]
pub type CreateLicenseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateLicenseInput {
    /// Consumes the builder and constructs an Operation<[`CreateLicense`](crate::operation::CreateLicense)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLicense,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateLicenseInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateLicenseInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.CreateLicense",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_license(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLicense::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLicense",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateLicenseInput`](crate::input::CreateLicenseInput)
    pub fn builder() -> crate::input::create_license_input::Builder {
        crate::input::create_license_input::Builder::default()
    }
}

/// See [`CreateLicenseConfigurationInput`](crate::input::CreateLicenseConfigurationInput)
pub mod create_license_configuration_input {
    /// A builder for [`CreateLicenseConfigurationInput`](crate::input::CreateLicenseConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) license_counting_type: std::option::Option<crate::model::LicenseCountingType>,
        pub(crate) license_count: std::option::Option<i64>,
        pub(crate) license_count_hard_limit: std::option::Option<bool>,
        pub(crate) license_rules: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) disassociate_when_not_found: std::option::Option<bool>,
        pub(crate) product_information_list:
            std::option::Option<std::vec::Vec<crate::model::ProductInformation>>,
    }
    impl Builder {
        /// <p>Name of the license configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>Name of the license configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Description of the license configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Description of the license configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Dimension used to track the license inventory.</p>
        pub fn license_counting_type(mut self, input: crate::model::LicenseCountingType) -> Self {
            self.license_counting_type = Some(input);
            self
        }
        /// <p>Dimension used to track the license inventory.</p>
        pub fn set_license_counting_type(
            mut self,
            input: std::option::Option<crate::model::LicenseCountingType>,
        ) -> Self {
            self.license_counting_type = input;
            self
        }
        /// <p>Number of licenses managed by the license configuration.</p>
        pub fn license_count(mut self, input: i64) -> Self {
            self.license_count = Some(input);
            self
        }
        /// <p>Number of licenses managed by the license configuration.</p>
        pub fn set_license_count(mut self, input: std::option::Option<i64>) -> Self {
            self.license_count = input;
            self
        }
        /// <p>Indicates whether hard or soft license enforcement is used. Exceeding a hard limit blocks the launch of new instances.</p>
        pub fn license_count_hard_limit(mut self, input: bool) -> Self {
            self.license_count_hard_limit = Some(input);
            self
        }
        /// <p>Indicates whether hard or soft license enforcement is used. Exceeding a hard limit blocks the launch of new instances.</p>
        pub fn set_license_count_hard_limit(mut self, input: std::option::Option<bool>) -> Self {
            self.license_count_hard_limit = input;
            self
        }
        /// Appends an item to `license_rules`.
        ///
        /// To override the contents of this collection use [`set_license_rules`](Self::set_license_rules).
        ///
        /// <p>License rules. The syntax is #name=value (for example, #allowedTenancy=EC2-DedicatedHost). The available rules vary by dimension, as follows.</p>
        /// <ul>
        /// <li> <p> <code>Cores</code> dimension: <code>allowedTenancy</code> | <code>licenseAffinityToHost</code> | <code>maximumCores</code> | <code>minimumCores</code> </p> </li>
        /// <li> <p> <code>Instances</code> dimension: <code>allowedTenancy</code> | <code>maximumCores</code> | <code>minimumCores</code> | <code>maximumSockets</code> | <code>minimumSockets</code> | <code>maximumVcpus</code> | <code>minimumVcpus</code> </p> </li>
        /// <li> <p> <code>Sockets</code> dimension: <code>allowedTenancy</code> | <code>licenseAffinityToHost</code> | <code>maximumSockets</code> | <code>minimumSockets</code> </p> </li>
        /// <li> <p> <code>vCPUs</code> dimension: <code>allowedTenancy</code> | <code>honorVcpuOptimization</code> | <code>maximumVcpus</code> | <code>minimumVcpus</code> </p> </li>
        /// </ul>
        /// <p>The unit for <code>licenseAffinityToHost</code> is days and the range is 1 to 180. The possible values for <code>allowedTenancy</code> are <code>EC2-Default</code>, <code>EC2-DedicatedHost</code>, and <code>EC2-DedicatedInstance</code>. The possible values for <code>honorVcpuOptimization</code> are <code>True</code> and <code>False</code>.</p>
        pub fn license_rules(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.license_rules.unwrap_or_default();
            v.push(input.into());
            self.license_rules = Some(v);
            self
        }
        /// <p>License rules. The syntax is #name=value (for example, #allowedTenancy=EC2-DedicatedHost). The available rules vary by dimension, as follows.</p>
        /// <ul>
        /// <li> <p> <code>Cores</code> dimension: <code>allowedTenancy</code> | <code>licenseAffinityToHost</code> | <code>maximumCores</code> | <code>minimumCores</code> </p> </li>
        /// <li> <p> <code>Instances</code> dimension: <code>allowedTenancy</code> | <code>maximumCores</code> | <code>minimumCores</code> | <code>maximumSockets</code> | <code>minimumSockets</code> | <code>maximumVcpus</code> | <code>minimumVcpus</code> </p> </li>
        /// <li> <p> <code>Sockets</code> dimension: <code>allowedTenancy</code> | <code>licenseAffinityToHost</code> | <code>maximumSockets</code> | <code>minimumSockets</code> </p> </li>
        /// <li> <p> <code>vCPUs</code> dimension: <code>allowedTenancy</code> | <code>honorVcpuOptimization</code> | <code>maximumVcpus</code> | <code>minimumVcpus</code> </p> </li>
        /// </ul>
        /// <p>The unit for <code>licenseAffinityToHost</code> is days and the range is 1 to 180. The possible values for <code>allowedTenancy</code> are <code>EC2-Default</code>, <code>EC2-DedicatedHost</code>, and <code>EC2-DedicatedInstance</code>. The possible values for <code>honorVcpuOptimization</code> are <code>True</code> and <code>False</code>.</p>
        pub fn set_license_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.license_rules = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to add to the license configuration.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Tags to add to the license configuration.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>When true, disassociates a resource when software is uninstalled.</p>
        pub fn disassociate_when_not_found(mut self, input: bool) -> Self {
            self.disassociate_when_not_found = Some(input);
            self
        }
        /// <p>When true, disassociates a resource when software is uninstalled.</p>
        pub fn set_disassociate_when_not_found(mut self, input: std::option::Option<bool>) -> Self {
            self.disassociate_when_not_found = input;
            self
        }
        /// Appends an item to `product_information_list`.
        ///
        /// To override the contents of this collection use [`set_product_information_list`](Self::set_product_information_list).
        ///
        /// <p>Product information.</p>
        pub fn product_information_list(mut self, input: crate::model::ProductInformation) -> Self {
            let mut v = self.product_information_list.unwrap_or_default();
            v.push(input);
            self.product_information_list = Some(v);
            self
        }
        /// <p>Product information.</p>
        pub fn set_product_information_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProductInformation>>,
        ) -> Self {
            self.product_information_list = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLicenseConfigurationInput`](crate::input::CreateLicenseConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLicenseConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLicenseConfigurationInput {
                name: self.name,
                description: self.description,
                license_counting_type: self.license_counting_type,
                license_count: self.license_count,
                license_count_hard_limit: self.license_count_hard_limit,
                license_rules: self.license_rules,
                tags: self.tags,
                disassociate_when_not_found: self.disassociate_when_not_found,
                product_information_list: self.product_information_list,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLicenseConfigurationInputOperationOutputAlias =
    crate::operation::CreateLicenseConfiguration;
#[doc(hidden)]
pub type CreateLicenseConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateLicenseConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`CreateLicenseConfiguration`](crate::operation::CreateLicenseConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLicenseConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateLicenseConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateLicenseConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.CreateLicenseConfiguration",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_license_configuration(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLicenseConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLicenseConfiguration",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateLicenseConfigurationInput`](crate::input::CreateLicenseConfigurationInput)
    pub fn builder() -> crate::input::create_license_configuration_input::Builder {
        crate::input::create_license_configuration_input::Builder::default()
    }
}

/// See [`CreateLicenseConversionTaskForResourceInput`](crate::input::CreateLicenseConversionTaskForResourceInput)
pub mod create_license_conversion_task_for_resource_input {
    /// A builder for [`CreateLicenseConversionTaskForResourceInput`](crate::input::CreateLicenseConversionTaskForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) source_license_context:
            std::option::Option<crate::model::LicenseConversionContext>,
        pub(crate) destination_license_context:
            std::option::Option<crate::model::LicenseConversionContext>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the resource you are converting the license type for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the resource you are converting the license type for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>Information that identifies the license type you are converting from. For the structure of the source license, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli">Convert a license type using the AWS CLI</a> in the <i>License Manager User Guide</i>.</p>
        pub fn source_license_context(
            mut self,
            input: crate::model::LicenseConversionContext,
        ) -> Self {
            self.source_license_context = Some(input);
            self
        }
        /// <p>Information that identifies the license type you are converting from. For the structure of the source license, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli">Convert a license type using the AWS CLI</a> in the <i>License Manager User Guide</i>.</p>
        pub fn set_source_license_context(
            mut self,
            input: std::option::Option<crate::model::LicenseConversionContext>,
        ) -> Self {
            self.source_license_context = input;
            self
        }
        /// <p>Information that identifies the license type you are converting to. For the structure of the destination license, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli">Convert a license type using the AWS CLI</a> in the <i>License Manager User Guide</i>.</p>
        pub fn destination_license_context(
            mut self,
            input: crate::model::LicenseConversionContext,
        ) -> Self {
            self.destination_license_context = Some(input);
            self
        }
        /// <p>Information that identifies the license type you are converting to. For the structure of the destination license, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli">Convert a license type using the AWS CLI</a> in the <i>License Manager User Guide</i>.</p>
        pub fn set_destination_license_context(
            mut self,
            input: std::option::Option<crate::model::LicenseConversionContext>,
        ) -> Self {
            self.destination_license_context = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLicenseConversionTaskForResourceInput`](crate::input::CreateLicenseConversionTaskForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLicenseConversionTaskForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLicenseConversionTaskForResourceInput {
                resource_arn: self.resource_arn,
                source_license_context: self.source_license_context,
                destination_license_context: self.destination_license_context,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLicenseConversionTaskForResourceInputOperationOutputAlias =
    crate::operation::CreateLicenseConversionTaskForResource;
#[doc(hidden)]
pub type CreateLicenseConversionTaskForResourceInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateLicenseConversionTaskForResourceInput {
    /// Consumes the builder and constructs an Operation<[`CreateLicenseConversionTaskForResource`](crate::operation::CreateLicenseConversionTaskForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLicenseConversionTaskForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateLicenseConversionTaskForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateLicenseConversionTaskForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.CreateLicenseConversionTaskForResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_license_conversion_task_for_resource(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLicenseConversionTaskForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLicenseConversionTaskForResource",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateLicenseConversionTaskForResourceInput`](crate::input::CreateLicenseConversionTaskForResourceInput)
    pub fn builder() -> crate::input::create_license_conversion_task_for_resource_input::Builder {
        crate::input::create_license_conversion_task_for_resource_input::Builder::default()
    }
}

/// See [`CreateLicenseManagerReportGeneratorInput`](crate::input::CreateLicenseManagerReportGeneratorInput)
pub mod create_license_manager_report_generator_input {
    /// A builder for [`CreateLicenseManagerReportGeneratorInput`](crate::input::CreateLicenseManagerReportGeneratorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) report_generator_name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::vec::Vec<crate::model::ReportType>>,
        pub(crate) report_context: std::option::Option<crate::model::ReportContext>,
        pub(crate) report_frequency: std::option::Option<crate::model::ReportFrequency>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Name of the report generator.</p>
        pub fn report_generator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_generator_name = Some(input.into());
            self
        }
        /// <p>Name of the report generator.</p>
        pub fn set_report_generator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_generator_name = input;
            self
        }
        /// Appends an item to `r#type`.
        ///
        /// To override the contents of this collection use [`set_type`](Self::set_type).
        ///
        /// <p>Type of reports to generate. The following report types an be generated:</p>
        /// <ul>
        /// <li> <p>License configuration report - Reports the number and details of consumed licenses for a license configuration.</p> </li>
        /// <li> <p>Resource report - Reports the tracked licenses and resource consumption for a license configuration.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ReportType) -> Self {
            let mut v = self.r#type.unwrap_or_default();
            v.push(input);
            self.r#type = Some(v);
            self
        }
        /// <p>Type of reports to generate. The following report types an be generated:</p>
        /// <ul>
        /// <li> <p>License configuration report - Reports the number and details of consumed licenses for a license configuration.</p> </li>
        /// <li> <p>Resource report - Reports the tracked licenses and resource consumption for a license configuration.</p> </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReportType>>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Defines the type of license configuration the report generator tracks.</p>
        pub fn report_context(mut self, input: crate::model::ReportContext) -> Self {
            self.report_context = Some(input);
            self
        }
        /// <p>Defines the type of license configuration the report generator tracks.</p>
        pub fn set_report_context(
            mut self,
            input: std::option::Option<crate::model::ReportContext>,
        ) -> Self {
            self.report_context = input;
            self
        }
        /// <p>Frequency by which reports are generated. Reports can be generated daily, monthly, or weekly.</p>
        pub fn report_frequency(mut self, input: crate::model::ReportFrequency) -> Self {
            self.report_frequency = Some(input);
            self
        }
        /// <p>Frequency by which reports are generated. Reports can be generated daily, monthly, or weekly.</p>
        pub fn set_report_frequency(
            mut self,
            input: std::option::Option<crate::model::ReportFrequency>,
        ) -> Self {
            self.report_frequency = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Description of the report generator.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Description of the report generator.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to add to the report generator.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Tags to add to the report generator.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLicenseManagerReportGeneratorInput`](crate::input::CreateLicenseManagerReportGeneratorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLicenseManagerReportGeneratorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLicenseManagerReportGeneratorInput {
                report_generator_name: self.report_generator_name,
                r#type: self.r#type,
                report_context: self.report_context,
                report_frequency: self.report_frequency,
                client_token: self.client_token,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLicenseManagerReportGeneratorInputOperationOutputAlias =
    crate::operation::CreateLicenseManagerReportGenerator;
#[doc(hidden)]
pub type CreateLicenseManagerReportGeneratorInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateLicenseManagerReportGeneratorInput {
    /// Consumes the builder and constructs an Operation<[`CreateLicenseManagerReportGenerator`](crate::operation::CreateLicenseManagerReportGenerator)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLicenseManagerReportGenerator,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateLicenseManagerReportGeneratorInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateLicenseManagerReportGeneratorInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.CreateLicenseManagerReportGenerator",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_license_manager_report_generator(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLicenseManagerReportGenerator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLicenseManagerReportGenerator",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateLicenseManagerReportGeneratorInput`](crate::input::CreateLicenseManagerReportGeneratorInput)
    pub fn builder() -> crate::input::create_license_manager_report_generator_input::Builder {
        crate::input::create_license_manager_report_generator_input::Builder::default()
    }
}

/// See [`CreateLicenseVersionInput`](crate::input::CreateLicenseVersionInput)
pub mod create_license_version_input {
    /// A builder for [`CreateLicenseVersionInput`](crate::input::CreateLicenseVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_arn: std::option::Option<std::string::String>,
        pub(crate) license_name: std::option::Option<std::string::String>,
        pub(crate) product_name: std::option::Option<std::string::String>,
        pub(crate) issuer: std::option::Option<crate::model::Issuer>,
        pub(crate) home_region: std::option::Option<std::string::String>,
        pub(crate) validity: std::option::Option<crate::model::DatetimeRange>,
        pub(crate) license_metadata: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
        pub(crate) entitlements: std::option::Option<std::vec::Vec<crate::model::Entitlement>>,
        pub(crate) consumption_configuration:
            std::option::Option<crate::model::ConsumptionConfiguration>,
        pub(crate) status: std::option::Option<crate::model::LicenseStatus>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) source_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn license_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_arn = input;
            self
        }
        /// <p>License name.</p>
        pub fn license_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_name = Some(input.into());
            self
        }
        /// <p>License name.</p>
        pub fn set_license_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_name = input;
            self
        }
        /// <p>Product name.</p>
        pub fn product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_name = Some(input.into());
            self
        }
        /// <p>Product name.</p>
        pub fn set_product_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_name = input;
            self
        }
        /// <p>License issuer.</p>
        pub fn issuer(mut self, input: crate::model::Issuer) -> Self {
            self.issuer = Some(input);
            self
        }
        /// <p>License issuer.</p>
        pub fn set_issuer(mut self, input: std::option::Option<crate::model::Issuer>) -> Self {
            self.issuer = input;
            self
        }
        /// <p>Home Region of the license.</p>
        pub fn home_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_region = Some(input.into());
            self
        }
        /// <p>Home Region of the license.</p>
        pub fn set_home_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.home_region = input;
            self
        }
        /// <p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>
        pub fn validity(mut self, input: crate::model::DatetimeRange) -> Self {
            self.validity = Some(input);
            self
        }
        /// <p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>
        pub fn set_validity(
            mut self,
            input: std::option::Option<crate::model::DatetimeRange>,
        ) -> Self {
            self.validity = input;
            self
        }
        /// Appends an item to `license_metadata`.
        ///
        /// To override the contents of this collection use [`set_license_metadata`](Self::set_license_metadata).
        ///
        /// <p>Information about the license.</p>
        pub fn license_metadata(mut self, input: crate::model::Metadata) -> Self {
            let mut v = self.license_metadata.unwrap_or_default();
            v.push(input);
            self.license_metadata = Some(v);
            self
        }
        /// <p>Information about the license.</p>
        pub fn set_license_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
        ) -> Self {
            self.license_metadata = input;
            self
        }
        /// Appends an item to `entitlements`.
        ///
        /// To override the contents of this collection use [`set_entitlements`](Self::set_entitlements).
        ///
        /// <p>License entitlements.</p>
        pub fn entitlements(mut self, input: crate::model::Entitlement) -> Self {
            let mut v = self.entitlements.unwrap_or_default();
            v.push(input);
            self.entitlements = Some(v);
            self
        }
        /// <p>License entitlements.</p>
        pub fn set_entitlements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Entitlement>>,
        ) -> Self {
            self.entitlements = input;
            self
        }
        /// <p>Configuration for consumption of the license. Choose a provisional configuration for workloads running with continuous connectivity. Choose a borrow configuration for workloads with offline usage.</p>
        pub fn consumption_configuration(
            mut self,
            input: crate::model::ConsumptionConfiguration,
        ) -> Self {
            self.consumption_configuration = Some(input);
            self
        }
        /// <p>Configuration for consumption of the license. Choose a provisional configuration for workloads running with continuous connectivity. Choose a borrow configuration for workloads with offline usage.</p>
        pub fn set_consumption_configuration(
            mut self,
            input: std::option::Option<crate::model::ConsumptionConfiguration>,
        ) -> Self {
            self.consumption_configuration = input;
            self
        }
        /// <p>License status.</p>
        pub fn status(mut self, input: crate::model::LicenseStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>License status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::LicenseStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Current version of the license.</p>
        pub fn source_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_version = Some(input.into());
            self
        }
        /// <p>Current version of the license.</p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_version = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateLicenseVersionInput`](crate::input::CreateLicenseVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateLicenseVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateLicenseVersionInput {
                license_arn: self.license_arn,
                license_name: self.license_name,
                product_name: self.product_name,
                issuer: self.issuer,
                home_region: self.home_region,
                validity: self.validity,
                license_metadata: self.license_metadata,
                entitlements: self.entitlements,
                consumption_configuration: self.consumption_configuration,
                status: self.status,
                client_token: self.client_token,
                source_version: self.source_version,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateLicenseVersionInputOperationOutputAlias = crate::operation::CreateLicenseVersion;
#[doc(hidden)]
pub type CreateLicenseVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateLicenseVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateLicenseVersion`](crate::operation::CreateLicenseVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateLicenseVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateLicenseVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateLicenseVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.CreateLicenseVersion",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_license_version(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateLicenseVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateLicenseVersion",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateLicenseVersionInput`](crate::input::CreateLicenseVersionInput)
    pub fn builder() -> crate::input::create_license_version_input::Builder {
        crate::input::create_license_version_input::Builder::default()
    }
}

/// See [`CreateTokenInput`](crate::input::CreateTokenInput)
pub mod create_token_input {
    /// A builder for [`CreateTokenInput`](crate::input::CreateTokenInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_arn: std::option::Option<std::string::String>,
        pub(crate) role_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) expiration_in_days: std::option::Option<i32>,
        pub(crate) token_properties: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the license. The ARN is mapped to the aud claim of the JWT token.</p>
        pub fn license_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license. The ARN is mapped to the aud claim of the JWT token.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_arn = input;
            self
        }
        /// Appends an item to `role_arns`.
        ///
        /// To override the contents of this collection use [`set_role_arns`](Self::set_role_arns).
        ///
        /// <p>Amazon Resource Name (ARN) of the IAM roles to embed in the token. License Manager does not check whether the roles are in use.</p>
        pub fn role_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.role_arns.unwrap_or_default();
            v.push(input.into());
            self.role_arns = Some(v);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the IAM roles to embed in the token. License Manager does not check whether the roles are in use.</p>
        pub fn set_role_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.role_arns = input;
            self
        }
        /// <p>Token expiration, in days, counted from token creation. The default is 365 days.</p>
        pub fn expiration_in_days(mut self, input: i32) -> Self {
            self.expiration_in_days = Some(input);
            self
        }
        /// <p>Token expiration, in days, counted from token creation. The default is 365 days.</p>
        pub fn set_expiration_in_days(mut self, input: std::option::Option<i32>) -> Self {
            self.expiration_in_days = input;
            self
        }
        /// Appends an item to `token_properties`.
        ///
        /// To override the contents of this collection use [`set_token_properties`](Self::set_token_properties).
        ///
        /// <p>Data specified by the caller to be included in the JWT token. The data is mapped to the amr claim of the JWT token.</p>
        pub fn token_properties(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.token_properties.unwrap_or_default();
            v.push(input.into());
            self.token_properties = Some(v);
            self
        }
        /// <p>Data specified by the caller to be included in the JWT token. The data is mapped to the amr claim of the JWT token.</p>
        pub fn set_token_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.token_properties = input;
            self
        }
        /// <p>Idempotency token, valid for 10 minutes.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Idempotency token, valid for 10 minutes.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateTokenInput`](crate::input::CreateTokenInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateTokenInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateTokenInput {
                license_arn: self.license_arn,
                role_arns: self.role_arns,
                expiration_in_days: self.expiration_in_days,
                token_properties: self.token_properties,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateTokenInputOperationOutputAlias = crate::operation::CreateToken;
#[doc(hidden)]
pub type CreateTokenInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateTokenInput {
    /// Consumes the builder and constructs an Operation<[`CreateToken`](crate::operation::CreateToken)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateToken,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateTokenInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateTokenInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.CreateToken",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_token(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateToken::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateToken",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateTokenInput`](crate::input::CreateTokenInput)
    pub fn builder() -> crate::input::create_token_input::Builder {
        crate::input::create_token_input::Builder::default()
    }
}

/// See [`DeleteGrantInput`](crate::input::DeleteGrantInput)
pub mod delete_grant_input {
    /// A builder for [`DeleteGrantInput`](crate::input::DeleteGrantInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) grant_arn: std::option::Option<std::string::String>,
        pub(crate) status_reason: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn grant_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn set_grant_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_arn = input;
            self
        }
        /// <p>The Status reason for the delete request.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_reason = Some(input.into());
            self
        }
        /// <p>The Status reason for the delete request.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_reason = input;
            self
        }
        /// <p>Current version of the grant.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>Current version of the grant.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGrantInput`](crate::input::DeleteGrantInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGrantInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGrantInput {
                grant_arn: self.grant_arn,
                status_reason: self.status_reason,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGrantInputOperationOutputAlias = crate::operation::DeleteGrant;
#[doc(hidden)]
pub type DeleteGrantInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteGrantInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGrant`](crate::operation::DeleteGrant)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGrant,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteGrantInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteGrantInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.DeleteGrant",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_grant(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGrant::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGrant",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteGrantInput`](crate::input::DeleteGrantInput)
    pub fn builder() -> crate::input::delete_grant_input::Builder {
        crate::input::delete_grant_input::Builder::default()
    }
}

/// See [`DeleteLicenseInput`](crate::input::DeleteLicenseInput)
pub mod delete_license_input {
    /// A builder for [`DeleteLicenseInput`](crate::input::DeleteLicenseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_arn: std::option::Option<std::string::String>,
        pub(crate) source_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn license_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_arn = input;
            self
        }
        /// <p>Current version of the license.</p>
        pub fn source_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_version = Some(input.into());
            self
        }
        /// <p>Current version of the license.</p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLicenseInput`](crate::input::DeleteLicenseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLicenseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLicenseInput {
                license_arn: self.license_arn,
                source_version: self.source_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLicenseInputOperationOutputAlias = crate::operation::DeleteLicense;
#[doc(hidden)]
pub type DeleteLicenseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteLicenseInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLicense`](crate::operation::DeleteLicense)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLicense,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteLicenseInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteLicenseInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.DeleteLicense",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_license(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLicense::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLicense",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteLicenseInput`](crate::input::DeleteLicenseInput)
    pub fn builder() -> crate::input::delete_license_input::Builder {
        crate::input::delete_license_input::Builder::default()
    }
}

/// See [`DeleteLicenseConfigurationInput`](crate::input::DeleteLicenseConfigurationInput)
pub mod delete_license_configuration_input {
    /// A builder for [`DeleteLicenseConfigurationInput`](crate::input::DeleteLicenseConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_configuration_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>ID of the license configuration.</p>
        pub fn license_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_configuration_arn = Some(input.into());
            self
        }
        /// <p>ID of the license configuration.</p>
        pub fn set_license_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_configuration_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLicenseConfigurationInput`](crate::input::DeleteLicenseConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLicenseConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLicenseConfigurationInput {
                license_configuration_arn: self.license_configuration_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLicenseConfigurationInputOperationOutputAlias =
    crate::operation::DeleteLicenseConfiguration;
#[doc(hidden)]
pub type DeleteLicenseConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteLicenseConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLicenseConfiguration`](crate::operation::DeleteLicenseConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLicenseConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteLicenseConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteLicenseConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.DeleteLicenseConfiguration",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_license_configuration(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLicenseConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLicenseConfiguration",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteLicenseConfigurationInput`](crate::input::DeleteLicenseConfigurationInput)
    pub fn builder() -> crate::input::delete_license_configuration_input::Builder {
        crate::input::delete_license_configuration_input::Builder::default()
    }
}

/// See [`DeleteLicenseManagerReportGeneratorInput`](crate::input::DeleteLicenseManagerReportGeneratorInput)
pub mod delete_license_manager_report_generator_input {
    /// A builder for [`DeleteLicenseManagerReportGeneratorInput`](crate::input::DeleteLicenseManagerReportGeneratorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_manager_report_generator_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the report generator to be deleted.</p>
        pub fn license_manager_report_generator_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.license_manager_report_generator_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the report generator to be deleted.</p>
        pub fn set_license_manager_report_generator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_manager_report_generator_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteLicenseManagerReportGeneratorInput`](crate::input::DeleteLicenseManagerReportGeneratorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteLicenseManagerReportGeneratorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteLicenseManagerReportGeneratorInput {
                license_manager_report_generator_arn: self.license_manager_report_generator_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteLicenseManagerReportGeneratorInputOperationOutputAlias =
    crate::operation::DeleteLicenseManagerReportGenerator;
#[doc(hidden)]
pub type DeleteLicenseManagerReportGeneratorInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteLicenseManagerReportGeneratorInput {
    /// Consumes the builder and constructs an Operation<[`DeleteLicenseManagerReportGenerator`](crate::operation::DeleteLicenseManagerReportGenerator)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteLicenseManagerReportGenerator,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteLicenseManagerReportGeneratorInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteLicenseManagerReportGeneratorInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.DeleteLicenseManagerReportGenerator",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_license_manager_report_generator(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteLicenseManagerReportGenerator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteLicenseManagerReportGenerator",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteLicenseManagerReportGeneratorInput`](crate::input::DeleteLicenseManagerReportGeneratorInput)
    pub fn builder() -> crate::input::delete_license_manager_report_generator_input::Builder {
        crate::input::delete_license_manager_report_generator_input::Builder::default()
    }
}

/// See [`DeleteTokenInput`](crate::input::DeleteTokenInput)
pub mod delete_token_input {
    /// A builder for [`DeleteTokenInput`](crate::input::DeleteTokenInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) token_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Token ID.</p>
        pub fn token_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.token_id = Some(input.into());
            self
        }
        /// <p>Token ID.</p>
        pub fn set_token_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTokenInput`](crate::input::DeleteTokenInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTokenInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTokenInput {
                token_id: self.token_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTokenInputOperationOutputAlias = crate::operation::DeleteToken;
#[doc(hidden)]
pub type DeleteTokenInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteTokenInput {
    /// Consumes the builder and constructs an Operation<[`DeleteToken`](crate::operation::DeleteToken)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteToken,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteTokenInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteTokenInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.DeleteToken",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_token(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteToken::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteToken",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteTokenInput`](crate::input::DeleteTokenInput)
    pub fn builder() -> crate::input::delete_token_input::Builder {
        crate::input::delete_token_input::Builder::default()
    }
}

/// See [`ExtendLicenseConsumptionInput`](crate::input::ExtendLicenseConsumptionInput)
pub mod extend_license_consumption_input {
    /// A builder for [`ExtendLicenseConsumptionInput`](crate::input::ExtendLicenseConsumptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_consumption_token: std::option::Option<std::string::String>,
        pub(crate) dry_run: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>License consumption token.</p>
        pub fn license_consumption_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_consumption_token = Some(input.into());
            self
        }
        /// <p>License consumption token.</p>
        pub fn set_license_consumption_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_consumption_token = input;
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request. Provides an error response if you do not have the required permissions.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request. Provides an error response if you do not have the required permissions.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Consumes the builder and constructs a [`ExtendLicenseConsumptionInput`](crate::input::ExtendLicenseConsumptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExtendLicenseConsumptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExtendLicenseConsumptionInput {
                license_consumption_token: self.license_consumption_token,
                dry_run: self.dry_run.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ExtendLicenseConsumptionInputOperationOutputAlias =
    crate::operation::ExtendLicenseConsumption;
#[doc(hidden)]
pub type ExtendLicenseConsumptionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ExtendLicenseConsumptionInput {
    /// Consumes the builder and constructs an Operation<[`ExtendLicenseConsumption`](crate::operation::ExtendLicenseConsumption)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExtendLicenseConsumption,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ExtendLicenseConsumptionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ExtendLicenseConsumptionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.ExtendLicenseConsumption",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_extend_license_consumption(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExtendLicenseConsumption::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExtendLicenseConsumption",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ExtendLicenseConsumptionInput`](crate::input::ExtendLicenseConsumptionInput)
    pub fn builder() -> crate::input::extend_license_consumption_input::Builder {
        crate::input::extend_license_consumption_input::Builder::default()
    }
}

/// See [`GetAccessTokenInput`](crate::input::GetAccessTokenInput)
pub mod get_access_token_input {
    /// A builder for [`GetAccessTokenInput`](crate::input::GetAccessTokenInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) token: std::option::Option<std::string::String>,
        pub(crate) token_properties: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Refresh token, encoded as a JWT token.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.token = Some(input.into());
            self
        }
        /// <p>Refresh token, encoded as a JWT token.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.token = input;
            self
        }
        /// Appends an item to `token_properties`.
        ///
        /// To override the contents of this collection use [`set_token_properties`](Self::set_token_properties).
        ///
        /// <p>Token properties to validate against those present in the JWT token.</p>
        pub fn token_properties(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.token_properties.unwrap_or_default();
            v.push(input.into());
            self.token_properties = Some(v);
            self
        }
        /// <p>Token properties to validate against those present in the JWT token.</p>
        pub fn set_token_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.token_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAccessTokenInput`](crate::input::GetAccessTokenInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAccessTokenInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAccessTokenInput {
                token: self.token,
                token_properties: self.token_properties,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAccessTokenInputOperationOutputAlias = crate::operation::GetAccessToken;
#[doc(hidden)]
pub type GetAccessTokenInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAccessTokenInput {
    /// Consumes the builder and constructs an Operation<[`GetAccessToken`](crate::operation::GetAccessToken)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAccessToken,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetAccessTokenInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetAccessTokenInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.GetAccessToken",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_access_token(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAccessToken::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAccessToken",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetAccessTokenInput`](crate::input::GetAccessTokenInput)
    pub fn builder() -> crate::input::get_access_token_input::Builder {
        crate::input::get_access_token_input::Builder::default()
    }
}

/// See [`GetGrantInput`](crate::input::GetGrantInput)
pub mod get_grant_input {
    /// A builder for [`GetGrantInput`](crate::input::GetGrantInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) grant_arn: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn grant_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn set_grant_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_arn = input;
            self
        }
        /// <p>Grant version.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>Grant version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetGrantInput`](crate::input::GetGrantInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetGrantInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetGrantInput {
                grant_arn: self.grant_arn,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetGrantInputOperationOutputAlias = crate::operation::GetGrant;
#[doc(hidden)]
pub type GetGrantInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetGrantInput {
    /// Consumes the builder and constructs an Operation<[`GetGrant`](crate::operation::GetGrant)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetGrant,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetGrantInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetGrantInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.GetGrant",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_grant(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetGrant::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetGrant",
                    "licensemanager",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetGrantInput`](crate::input::GetGrantInput)
    pub fn builder() -> crate::input::get_grant_input::Builder {
        crate::input::get_grant_input::Builder::default()
    }
}

/// See [`GetLicenseInput`](crate::input::GetLicenseInput)
pub mod get_license_input {
    /// A builder for [`GetLicenseInput`](crate::input::GetLicenseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_arn: std::option::Option<std::string::String>,
        pub(crate) version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn license_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_arn = input;
            self
        }
        /// <p>License version.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>License version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLicenseInput`](crate::input::GetLicenseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLicenseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLicenseInput {
                license_arn: self.license_arn,
                version: self.version,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLicenseInputOperationOutputAlias = crate::operation::GetLicense;
#[doc(hidden)]
pub type GetLicenseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetLicenseInput {
    /// Consumes the builder and constructs an Operation<[`GetLicense`](crate::operation::GetLicense)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLicense,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetLicenseInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetLicenseInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.GetLicense",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_license(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLicense::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLicense",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetLicenseInput`](crate::input::GetLicenseInput)
    pub fn builder() -> crate::input::get_license_input::Builder {
        crate::input::get_license_input::Builder::default()
    }
}

/// See [`GetLicenseConfigurationInput`](crate::input::GetLicenseConfigurationInput)
pub mod get_license_configuration_input {
    /// A builder for [`GetLicenseConfigurationInput`](crate::input::GetLicenseConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_configuration_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn license_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_configuration_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn set_license_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_configuration_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLicenseConfigurationInput`](crate::input::GetLicenseConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLicenseConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLicenseConfigurationInput {
                license_configuration_arn: self.license_configuration_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLicenseConfigurationInputOperationOutputAlias =
    crate::operation::GetLicenseConfiguration;
#[doc(hidden)]
pub type GetLicenseConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetLicenseConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetLicenseConfiguration`](crate::operation::GetLicenseConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLicenseConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetLicenseConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetLicenseConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.GetLicenseConfiguration",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_license_configuration(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLicenseConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLicenseConfiguration",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetLicenseConfigurationInput`](crate::input::GetLicenseConfigurationInput)
    pub fn builder() -> crate::input::get_license_configuration_input::Builder {
        crate::input::get_license_configuration_input::Builder::default()
    }
}

/// See [`GetLicenseConversionTaskInput`](crate::input::GetLicenseConversionTaskInput)
pub mod get_license_conversion_task_input {
    /// A builder for [`GetLicenseConversionTaskInput`](crate::input::GetLicenseConversionTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_conversion_task_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>ID of the license type conversion task to retrieve information on.</p>
        pub fn license_conversion_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_conversion_task_id = Some(input.into());
            self
        }
        /// <p>ID of the license type conversion task to retrieve information on.</p>
        pub fn set_license_conversion_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_conversion_task_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLicenseConversionTaskInput`](crate::input::GetLicenseConversionTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLicenseConversionTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLicenseConversionTaskInput {
                license_conversion_task_id: self.license_conversion_task_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLicenseConversionTaskInputOperationOutputAlias =
    crate::operation::GetLicenseConversionTask;
#[doc(hidden)]
pub type GetLicenseConversionTaskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetLicenseConversionTaskInput {
    /// Consumes the builder and constructs an Operation<[`GetLicenseConversionTask`](crate::operation::GetLicenseConversionTask)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLicenseConversionTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetLicenseConversionTaskInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetLicenseConversionTaskInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.GetLicenseConversionTask",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_license_conversion_task(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLicenseConversionTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLicenseConversionTask",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetLicenseConversionTaskInput`](crate::input::GetLicenseConversionTaskInput)
    pub fn builder() -> crate::input::get_license_conversion_task_input::Builder {
        crate::input::get_license_conversion_task_input::Builder::default()
    }
}

/// See [`GetLicenseManagerReportGeneratorInput`](crate::input::GetLicenseManagerReportGeneratorInput)
pub mod get_license_manager_report_generator_input {
    /// A builder for [`GetLicenseManagerReportGeneratorInput`](crate::input::GetLicenseManagerReportGeneratorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_manager_report_generator_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the report generator.</p>
        pub fn license_manager_report_generator_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.license_manager_report_generator_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the report generator.</p>
        pub fn set_license_manager_report_generator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_manager_report_generator_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLicenseManagerReportGeneratorInput`](crate::input::GetLicenseManagerReportGeneratorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLicenseManagerReportGeneratorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLicenseManagerReportGeneratorInput {
                license_manager_report_generator_arn: self.license_manager_report_generator_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLicenseManagerReportGeneratorInputOperationOutputAlias =
    crate::operation::GetLicenseManagerReportGenerator;
#[doc(hidden)]
pub type GetLicenseManagerReportGeneratorInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetLicenseManagerReportGeneratorInput {
    /// Consumes the builder and constructs an Operation<[`GetLicenseManagerReportGenerator`](crate::operation::GetLicenseManagerReportGenerator)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLicenseManagerReportGenerator,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetLicenseManagerReportGeneratorInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetLicenseManagerReportGeneratorInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.GetLicenseManagerReportGenerator",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_license_manager_report_generator(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLicenseManagerReportGenerator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLicenseManagerReportGenerator",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetLicenseManagerReportGeneratorInput`](crate::input::GetLicenseManagerReportGeneratorInput)
    pub fn builder() -> crate::input::get_license_manager_report_generator_input::Builder {
        crate::input::get_license_manager_report_generator_input::Builder::default()
    }
}

/// See [`GetLicenseUsageInput`](crate::input::GetLicenseUsageInput)
pub mod get_license_usage_input {
    /// A builder for [`GetLicenseUsageInput`](crate::input::GetLicenseUsageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn license_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GetLicenseUsageInput`](crate::input::GetLicenseUsageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetLicenseUsageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetLicenseUsageInput {
                license_arn: self.license_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GetLicenseUsageInputOperationOutputAlias = crate::operation::GetLicenseUsage;
#[doc(hidden)]
pub type GetLicenseUsageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetLicenseUsageInput {
    /// Consumes the builder and constructs an Operation<[`GetLicenseUsage`](crate::operation::GetLicenseUsage)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetLicenseUsage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetLicenseUsageInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetLicenseUsageInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.GetLicenseUsage",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_license_usage(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetLicenseUsage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetLicenseUsage",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetLicenseUsageInput`](crate::input::GetLicenseUsageInput)
    pub fn builder() -> crate::input::get_license_usage_input::Builder {
        crate::input::get_license_usage_input::Builder::default()
    }
}

/// See [`GetServiceSettingsInput`](crate::input::GetServiceSettingsInput)
pub mod get_service_settings_input {
    /// A builder for [`GetServiceSettingsInput`](crate::input::GetServiceSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetServiceSettingsInput`](crate::input::GetServiceSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetServiceSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetServiceSettingsInput {})
        }
    }
}
#[doc(hidden)]
pub type GetServiceSettingsInputOperationOutputAlias = crate::operation::GetServiceSettings;
#[doc(hidden)]
pub type GetServiceSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetServiceSettingsInput {
    /// Consumes the builder and constructs an Operation<[`GetServiceSettings`](crate::operation::GetServiceSettings)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetServiceSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetServiceSettingsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetServiceSettingsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.GetServiceSettings",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_service_settings(&self)?,
        );
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetServiceSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetServiceSettings",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetServiceSettingsInput`](crate::input::GetServiceSettingsInput)
    pub fn builder() -> crate::input::get_service_settings_input::Builder {
        crate::input::get_service_settings_input::Builder::default()
    }
}

/// See [`ListAssociationsForLicenseConfigurationInput`](crate::input::ListAssociationsForLicenseConfigurationInput)
pub mod list_associations_for_license_configuration_input {
    /// A builder for [`ListAssociationsForLicenseConfigurationInput`](crate::input::ListAssociationsForLicenseConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of a license configuration.</p>
        pub fn license_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_configuration_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of a license configuration.</p>
        pub fn set_license_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_configuration_arn = input;
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAssociationsForLicenseConfigurationInput`](crate::input::ListAssociationsForLicenseConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAssociationsForLicenseConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAssociationsForLicenseConfigurationInput {
                license_configuration_arn: self.license_configuration_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAssociationsForLicenseConfigurationInputOperationOutputAlias =
    crate::operation::ListAssociationsForLicenseConfiguration;
#[doc(hidden)]
pub type ListAssociationsForLicenseConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListAssociationsForLicenseConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`ListAssociationsForLicenseConfiguration`](crate::operation::ListAssociationsForLicenseConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAssociationsForLicenseConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAssociationsForLicenseConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAssociationsForLicenseConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.ListAssociationsForLicenseConfiguration",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_associations_for_license_configuration(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAssociationsForLicenseConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAssociationsForLicenseConfiguration",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAssociationsForLicenseConfigurationInput`](crate::input::ListAssociationsForLicenseConfigurationInput)
    pub fn builder() -> crate::input::list_associations_for_license_configuration_input::Builder {
        crate::input::list_associations_for_license_configuration_input::Builder::default()
    }
}

/// See [`ListDistributedGrantsInput`](crate::input::ListDistributedGrantsInput)
pub mod list_distributed_grants_input {
    /// A builder for [`ListDistributedGrantsInput`](crate::input::ListDistributedGrantsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) grant_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `grant_arns`.
        ///
        /// To override the contents of this collection use [`set_grant_arns`](Self::set_grant_arns).
        ///
        /// <p>Amazon Resource Names (ARNs) of the grants.</p>
        pub fn grant_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.grant_arns.unwrap_or_default();
            v.push(input.into());
            self.grant_arns = Some(v);
            self
        }
        /// <p>Amazon Resource Names (ARNs) of the grants.</p>
        pub fn set_grant_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.grant_arns = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li> <p> <code>LicenseArn</code> </p> </li>
        /// <li> <p> <code>GrantStatus</code> </p> </li>
        /// <li> <p> <code>GranteePrincipalARN</code> </p> </li>
        /// <li> <p> <code>ProductSKU</code> </p> </li>
        /// <li> <p> <code>LicenseIssuerName</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li> <p> <code>LicenseArn</code> </p> </li>
        /// <li> <p> <code>GrantStatus</code> </p> </li>
        /// <li> <p> <code>GranteePrincipalARN</code> </p> </li>
        /// <li> <p> <code>ProductSKU</code> </p> </li>
        /// <li> <p> <code>LicenseIssuerName</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDistributedGrantsInput`](crate::input::ListDistributedGrantsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDistributedGrantsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDistributedGrantsInput {
                grant_arns: self.grant_arns,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDistributedGrantsInputOperationOutputAlias = crate::operation::ListDistributedGrants;
#[doc(hidden)]
pub type ListDistributedGrantsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDistributedGrantsInput {
    /// Consumes the builder and constructs an Operation<[`ListDistributedGrants`](crate::operation::ListDistributedGrants)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDistributedGrants,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDistributedGrantsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDistributedGrantsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.ListDistributedGrants",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_distributed_grants(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDistributedGrants::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDistributedGrants",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDistributedGrantsInput`](crate::input::ListDistributedGrantsInput)
    pub fn builder() -> crate::input::list_distributed_grants_input::Builder {
        crate::input::list_distributed_grants_input::Builder::default()
    }
}

/// See [`ListFailuresForLicenseConfigurationOperationsInput`](crate::input::ListFailuresForLicenseConfigurationOperationsInput)
pub mod list_failures_for_license_configuration_operations_input {
    /// A builder for [`ListFailuresForLicenseConfigurationOperationsInput`](crate::input::ListFailuresForLicenseConfigurationOperationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name of the license configuration.</p>
        pub fn license_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_configuration_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name of the license configuration.</p>
        pub fn set_license_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_configuration_arn = input;
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFailuresForLicenseConfigurationOperationsInput`](crate::input::ListFailuresForLicenseConfigurationOperationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFailuresForLicenseConfigurationOperationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::ListFailuresForLicenseConfigurationOperationsInput {
                    license_configuration_arn: self.license_configuration_arn,
                    max_results: self.max_results,
                    next_token: self.next_token,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type ListFailuresForLicenseConfigurationOperationsInputOperationOutputAlias =
    crate::operation::ListFailuresForLicenseConfigurationOperations;
#[doc(hidden)]
pub type ListFailuresForLicenseConfigurationOperationsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListFailuresForLicenseConfigurationOperationsInput {
    /// Consumes the builder and constructs an Operation<[`ListFailuresForLicenseConfigurationOperations`](crate::operation::ListFailuresForLicenseConfigurationOperations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFailuresForLicenseConfigurationOperations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListFailuresForLicenseConfigurationOperationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListFailuresForLicenseConfigurationOperationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.ListFailuresForLicenseConfigurationOperations",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_failures_for_license_configuration_operations(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFailuresForLicenseConfigurationOperations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFailuresForLicenseConfigurationOperations",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListFailuresForLicenseConfigurationOperationsInput`](crate::input::ListFailuresForLicenseConfigurationOperationsInput)
    pub fn builder(
    ) -> crate::input::list_failures_for_license_configuration_operations_input::Builder {
        crate::input::list_failures_for_license_configuration_operations_input::Builder::default()
    }
}

/// See [`ListLicenseConfigurationsInput`](crate::input::ListLicenseConfigurationsInput)
pub mod list_license_configurations_input {
    /// A builder for [`ListLicenseConfigurationsInput`](crate::input::ListLicenseConfigurationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_configuration_arns:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// Appends an item to `license_configuration_arns`.
        ///
        /// To override the contents of this collection use [`set_license_configuration_arns`](Self::set_license_configuration_arns).
        ///
        /// <p>Amazon Resource Names (ARN) of the license configurations.</p>
        pub fn license_configuration_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.license_configuration_arns.unwrap_or_default();
            v.push(input.into());
            self.license_configuration_arns = Some(v);
            self
        }
        /// <p>Amazon Resource Names (ARN) of the license configurations.</p>
        pub fn set_license_configuration_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.license_configuration_arns = input;
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters and logical operators are supported:</p>
        /// <ul>
        /// <li> <p> <code>licenseCountingType</code> - The dimension for which licenses are counted. Possible values are <code>vCPU</code> | <code>Instance</code> | <code>Core</code> | <code>Socket</code>. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>enforceLicenseCount</code> - A Boolean value that indicates whether hard license enforcement is used. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>usagelimitExceeded</code> - A Boolean value that indicates whether the available licenses have been exceeded. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Filters to scope the results. The following filters and logical operators are supported:</p>
        /// <ul>
        /// <li> <p> <code>licenseCountingType</code> - The dimension for which licenses are counted. Possible values are <code>vCPU</code> | <code>Instance</code> | <code>Core</code> | <code>Socket</code>. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>enforceLicenseCount</code> - A Boolean value that indicates whether hard license enforcement is used. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>usagelimitExceeded</code> - A Boolean value that indicates whether the available licenses have been exceeded. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLicenseConfigurationsInput`](crate::input::ListLicenseConfigurationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLicenseConfigurationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLicenseConfigurationsInput {
                license_configuration_arns: self.license_configuration_arns,
                max_results: self.max_results,
                next_token: self.next_token,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLicenseConfigurationsInputOperationOutputAlias =
    crate::operation::ListLicenseConfigurations;
#[doc(hidden)]
pub type ListLicenseConfigurationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListLicenseConfigurationsInput {
    /// Consumes the builder and constructs an Operation<[`ListLicenseConfigurations`](crate::operation::ListLicenseConfigurations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLicenseConfigurations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListLicenseConfigurationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListLicenseConfigurationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.ListLicenseConfigurations",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_license_configurations(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLicenseConfigurations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLicenseConfigurations",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListLicenseConfigurationsInput`](crate::input::ListLicenseConfigurationsInput)
    pub fn builder() -> crate::input::list_license_configurations_input::Builder {
        crate::input::list_license_configurations_input::Builder::default()
    }
}

/// See [`ListLicenseConversionTasksInput`](crate::input::ListLicenseConversionTasksInput)
pub mod list_license_conversion_tasks_input {
    /// A builder for [`ListLicenseConversionTasksInput`](crate::input::ListLicenseConversionTasksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p> Filters to scope the results. Valid filters are <code>ResourceArns</code> and <code>Status</code>. </p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p> Filters to scope the results. Valid filters are <code>ResourceArns</code> and <code>Status</code>. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLicenseConversionTasksInput`](crate::input::ListLicenseConversionTasksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLicenseConversionTasksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLicenseConversionTasksInput {
                next_token: self.next_token,
                max_results: self.max_results,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLicenseConversionTasksInputOperationOutputAlias =
    crate::operation::ListLicenseConversionTasks;
#[doc(hidden)]
pub type ListLicenseConversionTasksInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListLicenseConversionTasksInput {
    /// Consumes the builder and constructs an Operation<[`ListLicenseConversionTasks`](crate::operation::ListLicenseConversionTasks)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLicenseConversionTasks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListLicenseConversionTasksInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListLicenseConversionTasksInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.ListLicenseConversionTasks",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_license_conversion_tasks(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLicenseConversionTasks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLicenseConversionTasks",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListLicenseConversionTasksInput`](crate::input::ListLicenseConversionTasksInput)
    pub fn builder() -> crate::input::list_license_conversion_tasks_input::Builder {
        crate::input::list_license_conversion_tasks_input::Builder::default()
    }
}

/// See [`ListLicenseManagerReportGeneratorsInput`](crate::input::ListLicenseManagerReportGeneratorsInput)
pub mod list_license_manager_report_generators_input {
    /// A builder for [`ListLicenseManagerReportGeneratorsInput`](crate::input::ListLicenseManagerReportGeneratorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters are supported: </p>
        /// <ul>
        /// <li> <p> <code>LicenseConfigurationArn</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Filters to scope the results. The following filters are supported: </p>
        /// <ul>
        /// <li> <p> <code>LicenseConfigurationArn</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLicenseManagerReportGeneratorsInput`](crate::input::ListLicenseManagerReportGeneratorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLicenseManagerReportGeneratorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLicenseManagerReportGeneratorsInput {
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLicenseManagerReportGeneratorsInputOperationOutputAlias =
    crate::operation::ListLicenseManagerReportGenerators;
#[doc(hidden)]
pub type ListLicenseManagerReportGeneratorsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListLicenseManagerReportGeneratorsInput {
    /// Consumes the builder and constructs an Operation<[`ListLicenseManagerReportGenerators`](crate::operation::ListLicenseManagerReportGenerators)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLicenseManagerReportGenerators,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListLicenseManagerReportGeneratorsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListLicenseManagerReportGeneratorsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.ListLicenseManagerReportGenerators",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_license_manager_report_generators(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLicenseManagerReportGenerators::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLicenseManagerReportGenerators",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListLicenseManagerReportGeneratorsInput`](crate::input::ListLicenseManagerReportGeneratorsInput)
    pub fn builder() -> crate::input::list_license_manager_report_generators_input::Builder {
        crate::input::list_license_manager_report_generators_input::Builder::default()
    }
}

/// See [`ListLicensesInput`](crate::input::ListLicensesInput)
pub mod list_licenses_input {
    /// A builder for [`ListLicensesInput`](crate::input::ListLicensesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `license_arns`.
        ///
        /// To override the contents of this collection use [`set_license_arns`](Self::set_license_arns).
        ///
        /// <p>Amazon Resource Names (ARNs) of the licenses.</p>
        pub fn license_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.license_arns.unwrap_or_default();
            v.push(input.into());
            self.license_arns = Some(v);
            self
        }
        /// <p>Amazon Resource Names (ARNs) of the licenses.</p>
        pub fn set_license_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.license_arns = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li> <p> <code>Beneficiary</code> </p> </li>
        /// <li> <p> <code>ProductSKU</code> </p> </li>
        /// <li> <p> <code>Fingerprint</code> </p> </li>
        /// <li> <p> <code>Status</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li> <p> <code>Beneficiary</code> </p> </li>
        /// <li> <p> <code>ProductSKU</code> </p> </li>
        /// <li> <p> <code>Fingerprint</code> </p> </li>
        /// <li> <p> <code>Status</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLicensesInput`](crate::input::ListLicensesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLicensesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLicensesInput {
                license_arns: self.license_arns,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLicensesInputOperationOutputAlias = crate::operation::ListLicenses;
#[doc(hidden)]
pub type ListLicensesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListLicensesInput {
    /// Consumes the builder and constructs an Operation<[`ListLicenses`](crate::operation::ListLicenses)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLicenses,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListLicensesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListLicensesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.ListLicenses",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_licenses(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLicenses::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLicenses",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListLicensesInput`](crate::input::ListLicensesInput)
    pub fn builder() -> crate::input::list_licenses_input::Builder {
        crate::input::list_licenses_input::Builder::default()
    }
}

/// See [`ListLicenseSpecificationsForResourceInput`](crate::input::ListLicenseSpecificationsForResourceInput)
pub mod list_license_specifications_for_resource_input {
    /// A builder for [`ListLicenseSpecificationsForResourceInput`](crate::input::ListLicenseSpecificationsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of a resource that has an associated license configuration.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of a resource that has an associated license configuration.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLicenseSpecificationsForResourceInput`](crate::input::ListLicenseSpecificationsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLicenseSpecificationsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLicenseSpecificationsForResourceInput {
                resource_arn: self.resource_arn,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLicenseSpecificationsForResourceInputOperationOutputAlias =
    crate::operation::ListLicenseSpecificationsForResource;
#[doc(hidden)]
pub type ListLicenseSpecificationsForResourceInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListLicenseSpecificationsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListLicenseSpecificationsForResource`](crate::operation::ListLicenseSpecificationsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLicenseSpecificationsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListLicenseSpecificationsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListLicenseSpecificationsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.ListLicenseSpecificationsForResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_license_specifications_for_resource(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLicenseSpecificationsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLicenseSpecificationsForResource",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListLicenseSpecificationsForResourceInput`](crate::input::ListLicenseSpecificationsForResourceInput)
    pub fn builder() -> crate::input::list_license_specifications_for_resource_input::Builder {
        crate::input::list_license_specifications_for_resource_input::Builder::default()
    }
}

/// See [`ListLicenseVersionsInput`](crate::input::ListLicenseVersionsInput)
pub mod list_license_versions_input {
    /// A builder for [`ListLicenseVersionsInput`](crate::input::ListLicenseVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_arn: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn license_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license_arn = input;
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLicenseVersionsInput`](crate::input::ListLicenseVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLicenseVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLicenseVersionsInput {
                license_arn: self.license_arn,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLicenseVersionsInputOperationOutputAlias = crate::operation::ListLicenseVersions;
#[doc(hidden)]
pub type ListLicenseVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListLicenseVersionsInput {
    /// Consumes the builder and constructs an Operation<[`ListLicenseVersions`](crate::operation::ListLicenseVersions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLicenseVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListLicenseVersionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListLicenseVersionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.ListLicenseVersions",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_license_versions(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLicenseVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLicenseVersions",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListLicenseVersionsInput`](crate::input::ListLicenseVersionsInput)
    pub fn builder() -> crate::input::list_license_versions_input::Builder {
        crate::input::list_license_versions_input::Builder::default()
    }
}

/// See [`ListReceivedGrantsInput`](crate::input::ListReceivedGrantsInput)
pub mod list_received_grants_input {
    /// A builder for [`ListReceivedGrantsInput`](crate::input::ListReceivedGrantsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) grant_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `grant_arns`.
        ///
        /// To override the contents of this collection use [`set_grant_arns`](Self::set_grant_arns).
        ///
        /// <p>Amazon Resource Names (ARNs) of the grants.</p>
        pub fn grant_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.grant_arns.unwrap_or_default();
            v.push(input.into());
            self.grant_arns = Some(v);
            self
        }
        /// <p>Amazon Resource Names (ARNs) of the grants.</p>
        pub fn set_grant_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.grant_arns = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li> <p> <code>ProductSKU</code> </p> </li>
        /// <li> <p> <code>LicenseIssuerName</code> </p> </li>
        /// <li> <p> <code>LicenseArn</code> </p> </li>
        /// <li> <p> <code>GrantStatus</code> </p> </li>
        /// <li> <p> <code>GranterAccountId</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li> <p> <code>ProductSKU</code> </p> </li>
        /// <li> <p> <code>LicenseIssuerName</code> </p> </li>
        /// <li> <p> <code>LicenseArn</code> </p> </li>
        /// <li> <p> <code>GrantStatus</code> </p> </li>
        /// <li> <p> <code>GranterAccountId</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReceivedGrantsInput`](crate::input::ListReceivedGrantsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListReceivedGrantsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListReceivedGrantsInput {
                grant_arns: self.grant_arns,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListReceivedGrantsInputOperationOutputAlias = crate::operation::ListReceivedGrants;
#[doc(hidden)]
pub type ListReceivedGrantsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListReceivedGrantsInput {
    /// Consumes the builder and constructs an Operation<[`ListReceivedGrants`](crate::operation::ListReceivedGrants)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListReceivedGrants,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListReceivedGrantsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListReceivedGrantsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.ListReceivedGrants",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_received_grants(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListReceivedGrants::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListReceivedGrants",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListReceivedGrantsInput`](crate::input::ListReceivedGrantsInput)
    pub fn builder() -> crate::input::list_received_grants_input::Builder {
        crate::input::list_received_grants_input::Builder::default()
    }
}

/// See [`ListReceivedLicensesInput`](crate::input::ListReceivedLicensesInput)
pub mod list_received_licenses_input {
    /// A builder for [`ListReceivedLicensesInput`](crate::input::ListReceivedLicensesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_arns: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `license_arns`.
        ///
        /// To override the contents of this collection use [`set_license_arns`](Self::set_license_arns).
        ///
        /// <p>Amazon Resource Names (ARNs) of the licenses.</p>
        pub fn license_arns(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.license_arns.unwrap_or_default();
            v.push(input.into());
            self.license_arns = Some(v);
            self
        }
        /// <p>Amazon Resource Names (ARNs) of the licenses.</p>
        pub fn set_license_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.license_arns = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li> <p> <code>ProductSKU</code> </p> </li>
        /// <li> <p> <code>Status</code> </p> </li>
        /// <li> <p> <code>Fingerprint</code> </p> </li>
        /// <li> <p> <code>IssuerName</code> </p> </li>
        /// <li> <p> <code>Beneficiary</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li> <p> <code>ProductSKU</code> </p> </li>
        /// <li> <p> <code>Status</code> </p> </li>
        /// <li> <p> <code>Fingerprint</code> </p> </li>
        /// <li> <p> <code>IssuerName</code> </p> </li>
        /// <li> <p> <code>Beneficiary</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReceivedLicensesInput`](crate::input::ListReceivedLicensesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListReceivedLicensesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListReceivedLicensesInput {
                license_arns: self.license_arns,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListReceivedLicensesInputOperationOutputAlias = crate::operation::ListReceivedLicenses;
#[doc(hidden)]
pub type ListReceivedLicensesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListReceivedLicensesInput {
    /// Consumes the builder and constructs an Operation<[`ListReceivedLicenses`](crate::operation::ListReceivedLicenses)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListReceivedLicenses,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListReceivedLicensesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListReceivedLicensesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.ListReceivedLicenses",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_received_licenses(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListReceivedLicenses::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListReceivedLicenses",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListReceivedLicensesInput`](crate::input::ListReceivedLicensesInput)
    pub fn builder() -> crate::input::list_received_licenses_input::Builder {
        crate::input::list_received_licenses_input::Builder::default()
    }
}

/// See [`ListResourceInventoryInput`](crate::input::ListResourceInventoryInput)
pub mod list_resource_inventory_input {
    /// A builder for [`ListResourceInventoryInput`](crate::input::ListResourceInventoryInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::InventoryFilter>>,
    }
    impl Builder {
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters and logical operators are supported:</p>
        /// <ul>
        /// <li> <p> <code>account_id</code> - The ID of the Amazon Web Services account that owns the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>application_name</code> - The name of the application. Logical operators are <code>EQUALS</code> | <code>BEGINS_WITH</code>.</p> </li>
        /// <li> <p> <code>license_included</code> - The type of license included. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>. Possible values are <code>sql-server-enterprise</code> | <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.</p> </li>
        /// <li> <p> <code>platform</code> - The platform of the resource. Logical operators are <code>EQUALS</code> | <code>BEGINS_WITH</code>.</p> </li>
        /// <li> <p> <code>resource_id</code> - The ID of the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>tag:
        /// <key></key></code> - The key/value combination of a tag assigned to the resource. Logical operators are <code>EQUALS</code> (single account) or <code>EQUALS</code> | <code>NOT_EQUALS</code> (cross account).</p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::InventoryFilter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Filters to scope the results. The following filters and logical operators are supported:</p>
        /// <ul>
        /// <li> <p> <code>account_id</code> - The ID of the Amazon Web Services account that owns the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>application_name</code> - The name of the application. Logical operators are <code>EQUALS</code> | <code>BEGINS_WITH</code>.</p> </li>
        /// <li> <p> <code>license_included</code> - The type of license included. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>. Possible values are <code>sql-server-enterprise</code> | <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.</p> </li>
        /// <li> <p> <code>platform</code> - The platform of the resource. Logical operators are <code>EQUALS</code> | <code>BEGINS_WITH</code>.</p> </li>
        /// <li> <p> <code>resource_id</code> - The ID of the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>tag:
        /// <key></key></code> - The key/value combination of a tag assigned to the resource. Logical operators are <code>EQUALS</code> (single account) or <code>EQUALS</code> | <code>NOT_EQUALS</code> (cross account).</p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryFilter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListResourceInventoryInput`](crate::input::ListResourceInventoryInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListResourceInventoryInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListResourceInventoryInput {
                max_results: self.max_results,
                next_token: self.next_token,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListResourceInventoryInputOperationOutputAlias = crate::operation::ListResourceInventory;
#[doc(hidden)]
pub type ListResourceInventoryInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListResourceInventoryInput {
    /// Consumes the builder and constructs an Operation<[`ListResourceInventory`](crate::operation::ListResourceInventory)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListResourceInventory,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListResourceInventoryInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListResourceInventoryInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.ListResourceInventory",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_resource_inventory(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListResourceInventory::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListResourceInventory",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListResourceInventoryInput`](crate::input::ListResourceInventoryInput)
    pub fn builder() -> crate::input::list_resource_inventory_input::Builder {
        crate::input::list_resource_inventory_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.ListTagsForResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListTokensInput`](crate::input::ListTokensInput)
pub mod list_tokens_input {
    /// A builder for [`ListTokensInput`](crate::input::ListTokensInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) token_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `token_ids`.
        ///
        /// To override the contents of this collection use [`set_token_ids`](Self::set_token_ids).
        ///
        /// <p>Token IDs.</p>
        pub fn token_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.token_ids.unwrap_or_default();
            v.push(input.into());
            self.token_ids = Some(v);
            self
        }
        /// <p>Token IDs.</p>
        pub fn set_token_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.token_ids = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filter is supported:</p>
        /// <ul>
        /// <li> <p> <code>LicenseArns</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Filters to scope the results. The following filter is supported:</p>
        /// <ul>
        /// <li> <p> <code>LicenseArns</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTokensInput`](crate::input::ListTokensInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTokensInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTokensInput {
                token_ids: self.token_ids,
                filters: self.filters,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTokensInputOperationOutputAlias = crate::operation::ListTokens;
#[doc(hidden)]
pub type ListTokensInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTokensInput {
    /// Consumes the builder and constructs an Operation<[`ListTokens`](crate::operation::ListTokens)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTokens,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTokensInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTokensInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.ListTokens",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_tokens(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTokens::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTokens",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTokensInput`](crate::input::ListTokensInput)
    pub fn builder() -> crate::input::list_tokens_input::Builder {
        crate::input::list_tokens_input::Builder::default()
    }
}

/// See [`ListUsageForLicenseConfigurationInput`](crate::input::ListUsageForLicenseConfigurationInput)
pub mod list_usage_for_license_configuration_input {
    /// A builder for [`ListUsageForLicenseConfigurationInput`](crate::input::ListUsageForLicenseConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn license_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_configuration_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn set_license_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_configuration_arn = input;
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters and logical operators are supported:</p>
        /// <ul>
        /// <li> <p> <code>resourceArn</code> - The ARN of the license configuration resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>resourceType</code> - The resource type (<code>EC2_INSTANCE</code> | <code>EC2_HOST</code> | <code>EC2_AMI</code> | <code>SYSTEMS_MANAGER_MANAGED_INSTANCE</code>). Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>resourceAccount</code> - The ID of the account that owns the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Filters to scope the results. The following filters and logical operators are supported:</p>
        /// <ul>
        /// <li> <p> <code>resourceArn</code> - The ARN of the license configuration resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>resourceType</code> - The resource type (<code>EC2_INSTANCE</code> | <code>EC2_HOST</code> | <code>EC2_AMI</code> | <code>SYSTEMS_MANAGER_MANAGED_INSTANCE</code>). Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>resourceAccount</code> - The ID of the account that owns the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUsageForLicenseConfigurationInput`](crate::input::ListUsageForLicenseConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListUsageForLicenseConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListUsageForLicenseConfigurationInput {
                license_configuration_arn: self.license_configuration_arn,
                max_results: self.max_results,
                next_token: self.next_token,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type ListUsageForLicenseConfigurationInputOperationOutputAlias =
    crate::operation::ListUsageForLicenseConfiguration;
#[doc(hidden)]
pub type ListUsageForLicenseConfigurationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListUsageForLicenseConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`ListUsageForLicenseConfiguration`](crate::operation::ListUsageForLicenseConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListUsageForLicenseConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListUsageForLicenseConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListUsageForLicenseConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.ListUsageForLicenseConfiguration",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_usage_for_license_configuration(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListUsageForLicenseConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListUsageForLicenseConfiguration",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListUsageForLicenseConfigurationInput`](crate::input::ListUsageForLicenseConfigurationInput)
    pub fn builder() -> crate::input::list_usage_for_license_configuration_input::Builder {
        crate::input::list_usage_for_license_configuration_input::Builder::default()
    }
}

/// See [`RejectGrantInput`](crate::input::RejectGrantInput)
pub mod reject_grant_input {
    /// A builder for [`RejectGrantInput`](crate::input::RejectGrantInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) grant_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn grant_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.grant_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn set_grant_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grant_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RejectGrantInput`](crate::input::RejectGrantInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RejectGrantInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RejectGrantInput {
                grant_arn: self.grant_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type RejectGrantInputOperationOutputAlias = crate::operation::RejectGrant;
#[doc(hidden)]
pub type RejectGrantInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RejectGrantInput {
    /// Consumes the builder and constructs an Operation<[`RejectGrant`](crate::operation::RejectGrant)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RejectGrant,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RejectGrantInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RejectGrantInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.RejectGrant",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_reject_grant(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RejectGrant::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RejectGrant",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RejectGrantInput`](crate::input::RejectGrantInput)
    pub fn builder() -> crate::input::reject_grant_input::Builder {
        crate::input::reject_grant_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.TagResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Keys identifying the tags to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>Keys identifying the tags to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.UntagResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_untag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateLicenseConfigurationInput`](crate::input::UpdateLicenseConfigurationInput)
pub mod update_license_configuration_input {
    /// A builder for [`UpdateLicenseConfigurationInput`](crate::input::UpdateLicenseConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_configuration_arn: std::option::Option<std::string::String>,
        pub(crate) license_configuration_status:
            std::option::Option<crate::model::LicenseConfigurationStatus>,
        pub(crate) license_rules: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) license_count: std::option::Option<i64>,
        pub(crate) license_count_hard_limit: std::option::Option<bool>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) product_information_list:
            std::option::Option<std::vec::Vec<crate::model::ProductInformation>>,
        pub(crate) disassociate_when_not_found: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn license_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_configuration_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn set_license_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_configuration_arn = input;
            self
        }
        /// <p>New status of the license configuration.</p>
        pub fn license_configuration_status(
            mut self,
            input: crate::model::LicenseConfigurationStatus,
        ) -> Self {
            self.license_configuration_status = Some(input);
            self
        }
        /// <p>New status of the license configuration.</p>
        pub fn set_license_configuration_status(
            mut self,
            input: std::option::Option<crate::model::LicenseConfigurationStatus>,
        ) -> Self {
            self.license_configuration_status = input;
            self
        }
        /// Appends an item to `license_rules`.
        ///
        /// To override the contents of this collection use [`set_license_rules`](Self::set_license_rules).
        ///
        /// <p>New license rule. The only rule that you can add after you create a license configuration is licenseAffinityToHost.</p>
        pub fn license_rules(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.license_rules.unwrap_or_default();
            v.push(input.into());
            self.license_rules = Some(v);
            self
        }
        /// <p>New license rule. The only rule that you can add after you create a license configuration is licenseAffinityToHost.</p>
        pub fn set_license_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.license_rules = input;
            self
        }
        /// <p>New number of licenses managed by the license configuration.</p>
        pub fn license_count(mut self, input: i64) -> Self {
            self.license_count = Some(input);
            self
        }
        /// <p>New number of licenses managed by the license configuration.</p>
        pub fn set_license_count(mut self, input: std::option::Option<i64>) -> Self {
            self.license_count = input;
            self
        }
        /// <p>New hard limit of the number of available licenses.</p>
        pub fn license_count_hard_limit(mut self, input: bool) -> Self {
            self.license_count_hard_limit = Some(input);
            self
        }
        /// <p>New hard limit of the number of available licenses.</p>
        pub fn set_license_count_hard_limit(mut self, input: std::option::Option<bool>) -> Self {
            self.license_count_hard_limit = input;
            self
        }
        /// <p>New name of the license configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>New name of the license configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>New description of the license configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>New description of the license configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `product_information_list`.
        ///
        /// To override the contents of this collection use [`set_product_information_list`](Self::set_product_information_list).
        ///
        /// <p>New product information.</p>
        pub fn product_information_list(mut self, input: crate::model::ProductInformation) -> Self {
            let mut v = self.product_information_list.unwrap_or_default();
            v.push(input);
            self.product_information_list = Some(v);
            self
        }
        /// <p>New product information.</p>
        pub fn set_product_information_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProductInformation>>,
        ) -> Self {
            self.product_information_list = input;
            self
        }
        /// <p>When true, disassociates a resource when software is uninstalled.</p>
        pub fn disassociate_when_not_found(mut self, input: bool) -> Self {
            self.disassociate_when_not_found = Some(input);
            self
        }
        /// <p>When true, disassociates a resource when software is uninstalled.</p>
        pub fn set_disassociate_when_not_found(mut self, input: std::option::Option<bool>) -> Self {
            self.disassociate_when_not_found = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLicenseConfigurationInput`](crate::input::UpdateLicenseConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateLicenseConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateLicenseConfigurationInput {
                license_configuration_arn: self.license_configuration_arn,
                license_configuration_status: self.license_configuration_status,
                license_rules: self.license_rules,
                license_count: self.license_count,
                license_count_hard_limit: self.license_count_hard_limit,
                name: self.name,
                description: self.description,
                product_information_list: self.product_information_list,
                disassociate_when_not_found: self.disassociate_when_not_found,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateLicenseConfigurationInputOperationOutputAlias =
    crate::operation::UpdateLicenseConfiguration;
#[doc(hidden)]
pub type UpdateLicenseConfigurationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateLicenseConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateLicenseConfiguration`](crate::operation::UpdateLicenseConfiguration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateLicenseConfiguration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateLicenseConfigurationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateLicenseConfigurationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.UpdateLicenseConfiguration",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_license_configuration(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateLicenseConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateLicenseConfiguration",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateLicenseConfigurationInput`](crate::input::UpdateLicenseConfigurationInput)
    pub fn builder() -> crate::input::update_license_configuration_input::Builder {
        crate::input::update_license_configuration_input::Builder::default()
    }
}

/// See [`UpdateLicenseManagerReportGeneratorInput`](crate::input::UpdateLicenseManagerReportGeneratorInput)
pub mod update_license_manager_report_generator_input {
    /// A builder for [`UpdateLicenseManagerReportGeneratorInput`](crate::input::UpdateLicenseManagerReportGeneratorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license_manager_report_generator_arn: std::option::Option<std::string::String>,
        pub(crate) report_generator_name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::vec::Vec<crate::model::ReportType>>,
        pub(crate) report_context: std::option::Option<crate::model::ReportContext>,
        pub(crate) report_frequency: std::option::Option<crate::model::ReportFrequency>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the report generator to update.</p>
        pub fn license_manager_report_generator_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.license_manager_report_generator_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the report generator to update.</p>
        pub fn set_license_manager_report_generator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_manager_report_generator_arn = input;
            self
        }
        /// <p>Name of the report generator.</p>
        pub fn report_generator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.report_generator_name = Some(input.into());
            self
        }
        /// <p>Name of the report generator.</p>
        pub fn set_report_generator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.report_generator_name = input;
            self
        }
        /// Appends an item to `r#type`.
        ///
        /// To override the contents of this collection use [`set_type`](Self::set_type).
        ///
        /// <p>Type of reports to generate. The following report types are supported:</p>
        /// <ul>
        /// <li> <p>License configuration report - Reports the number and details of consumed licenses for a license configuration.</p> </li>
        /// <li> <p>Resource report - Reports the tracked licenses and resource consumption for a license configuration.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ReportType) -> Self {
            let mut v = self.r#type.unwrap_or_default();
            v.push(input);
            self.r#type = Some(v);
            self
        }
        /// <p>Type of reports to generate. The following report types are supported:</p>
        /// <ul>
        /// <li> <p>License configuration report - Reports the number and details of consumed licenses for a license configuration.</p> </li>
        /// <li> <p>Resource report - Reports the tracked licenses and resource consumption for a license configuration.</p> </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReportType>>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The report context.</p>
        pub fn report_context(mut self, input: crate::model::ReportContext) -> Self {
            self.report_context = Some(input);
            self
        }
        /// <p>The report context.</p>
        pub fn set_report_context(
            mut self,
            input: std::option::Option<crate::model::ReportContext>,
        ) -> Self {
            self.report_context = input;
            self
        }
        /// <p>Frequency by which reports are generated.</p>
        pub fn report_frequency(mut self, input: crate::model::ReportFrequency) -> Self {
            self.report_frequency = Some(input);
            self
        }
        /// <p>Frequency by which reports are generated.</p>
        pub fn set_report_frequency(
            mut self,
            input: std::option::Option<crate::model::ReportFrequency>,
        ) -> Self {
            self.report_frequency = input;
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Description of the report generator.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Description of the report generator.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLicenseManagerReportGeneratorInput`](crate::input::UpdateLicenseManagerReportGeneratorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateLicenseManagerReportGeneratorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateLicenseManagerReportGeneratorInput {
                license_manager_report_generator_arn: self.license_manager_report_generator_arn,
                report_generator_name: self.report_generator_name,
                r#type: self.r#type,
                report_context: self.report_context,
                report_frequency: self.report_frequency,
                client_token: self.client_token,
                description: self.description,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateLicenseManagerReportGeneratorInputOperationOutputAlias =
    crate::operation::UpdateLicenseManagerReportGenerator;
#[doc(hidden)]
pub type UpdateLicenseManagerReportGeneratorInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateLicenseManagerReportGeneratorInput {
    /// Consumes the builder and constructs an Operation<[`UpdateLicenseManagerReportGenerator`](crate::operation::UpdateLicenseManagerReportGenerator)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateLicenseManagerReportGenerator,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateLicenseManagerReportGeneratorInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateLicenseManagerReportGeneratorInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.UpdateLicenseManagerReportGenerator",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_license_manager_report_generator(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateLicenseManagerReportGenerator::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateLicenseManagerReportGenerator",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateLicenseManagerReportGeneratorInput`](crate::input::UpdateLicenseManagerReportGeneratorInput)
    pub fn builder() -> crate::input::update_license_manager_report_generator_input::Builder {
        crate::input::update_license_manager_report_generator_input::Builder::default()
    }
}

/// See [`UpdateLicenseSpecificationsForResourceInput`](crate::input::UpdateLicenseSpecificationsForResourceInput)
pub mod update_license_specifications_for_resource_input {
    /// A builder for [`UpdateLicenseSpecificationsForResourceInput`](crate::input::UpdateLicenseSpecificationsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) add_license_specifications:
            std::option::Option<std::vec::Vec<crate::model::LicenseSpecification>>,
        pub(crate) remove_license_specifications:
            std::option::Option<std::vec::Vec<crate::model::LicenseSpecification>>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the Amazon Web Services resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon Web Services resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `add_license_specifications`.
        ///
        /// To override the contents of this collection use [`set_add_license_specifications`](Self::set_add_license_specifications).
        ///
        /// <p>ARNs of the license configurations to add.</p>
        pub fn add_license_specifications(
            mut self,
            input: crate::model::LicenseSpecification,
        ) -> Self {
            let mut v = self.add_license_specifications.unwrap_or_default();
            v.push(input);
            self.add_license_specifications = Some(v);
            self
        }
        /// <p>ARNs of the license configurations to add.</p>
        pub fn set_add_license_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LicenseSpecification>>,
        ) -> Self {
            self.add_license_specifications = input;
            self
        }
        /// Appends an item to `remove_license_specifications`.
        ///
        /// To override the contents of this collection use [`set_remove_license_specifications`](Self::set_remove_license_specifications).
        ///
        /// <p>ARNs of the license configurations to remove.</p>
        pub fn remove_license_specifications(
            mut self,
            input: crate::model::LicenseSpecification,
        ) -> Self {
            let mut v = self.remove_license_specifications.unwrap_or_default();
            v.push(input);
            self.remove_license_specifications = Some(v);
            self
        }
        /// <p>ARNs of the license configurations to remove.</p>
        pub fn set_remove_license_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LicenseSpecification>>,
        ) -> Self {
            self.remove_license_specifications = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateLicenseSpecificationsForResourceInput`](crate::input::UpdateLicenseSpecificationsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateLicenseSpecificationsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateLicenseSpecificationsForResourceInput {
                resource_arn: self.resource_arn,
                add_license_specifications: self.add_license_specifications,
                remove_license_specifications: self.remove_license_specifications,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateLicenseSpecificationsForResourceInputOperationOutputAlias =
    crate::operation::UpdateLicenseSpecificationsForResource;
#[doc(hidden)]
pub type UpdateLicenseSpecificationsForResourceInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateLicenseSpecificationsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`UpdateLicenseSpecificationsForResource`](crate::operation::UpdateLicenseSpecificationsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateLicenseSpecificationsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateLicenseSpecificationsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateLicenseSpecificationsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.UpdateLicenseSpecificationsForResource",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_license_specifications_for_resource(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateLicenseSpecificationsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateLicenseSpecificationsForResource",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateLicenseSpecificationsForResourceInput`](crate::input::UpdateLicenseSpecificationsForResourceInput)
    pub fn builder() -> crate::input::update_license_specifications_for_resource_input::Builder {
        crate::input::update_license_specifications_for_resource_input::Builder::default()
    }
}

/// See [`UpdateServiceSettingsInput`](crate::input::UpdateServiceSettingsInput)
pub mod update_service_settings_input {
    /// A builder for [`UpdateServiceSettingsInput`](crate::input::UpdateServiceSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket_arn: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) organization_configuration:
            std::option::Option<crate::model::OrganizationConfiguration>,
        pub(crate) enable_cross_accounts_discovery: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the Amazon S3 bucket where the License Manager information is stored.</p>
        pub fn s3_bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon S3 bucket where the License Manager information is stored.</p>
        pub fn set_s3_bucket_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_arn = input;
            self
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon SNS topic used for License Manager alerts.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon SNS topic used for License Manager alerts.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>Enables integration with Organizations for cross-account discovery.</p>
        pub fn organization_configuration(
            mut self,
            input: crate::model::OrganizationConfiguration,
        ) -> Self {
            self.organization_configuration = Some(input);
            self
        }
        /// <p>Enables integration with Organizations for cross-account discovery.</p>
        pub fn set_organization_configuration(
            mut self,
            input: std::option::Option<crate::model::OrganizationConfiguration>,
        ) -> Self {
            self.organization_configuration = input;
            self
        }
        /// <p>Activates cross-account discovery.</p>
        pub fn enable_cross_accounts_discovery(mut self, input: bool) -> Self {
            self.enable_cross_accounts_discovery = Some(input);
            self
        }
        /// <p>Activates cross-account discovery.</p>
        pub fn set_enable_cross_accounts_discovery(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_cross_accounts_discovery = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateServiceSettingsInput`](crate::input::UpdateServiceSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateServiceSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateServiceSettingsInput {
                s3_bucket_arn: self.s3_bucket_arn,
                sns_topic_arn: self.sns_topic_arn,
                organization_configuration: self.organization_configuration,
                enable_cross_accounts_discovery: self.enable_cross_accounts_discovery,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateServiceSettingsInputOperationOutputAlias = crate::operation::UpdateServiceSettings;
#[doc(hidden)]
pub type UpdateServiceSettingsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateServiceSettingsInput {
    /// Consumes the builder and constructs an Operation<[`UpdateServiceSettings`](crate::operation::UpdateServiceSettings)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateServiceSettings,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateServiceSettingsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateServiceSettingsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSLicenseManager.UpdateServiceSettings",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_service_settings(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateServiceSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateServiceSettings",
            "licensemanager",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateServiceSettingsInput`](crate::input::UpdateServiceSettingsInput)
    pub fn builder() -> crate::input::update_service_settings_input::Builder {
        crate::input::update_service_settings_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateServiceSettingsInput {
    /// <p>Amazon Resource Name (ARN) of the Amazon S3 bucket where the License Manager information is stored.</p>
    pub s3_bucket_arn: std::option::Option<std::string::String>,
    /// <p>Amazon Resource Name (ARN) of the Amazon SNS topic used for License Manager alerts.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>Enables integration with Organizations for cross-account discovery.</p>
    pub organization_configuration: std::option::Option<crate::model::OrganizationConfiguration>,
    /// <p>Activates cross-account discovery.</p>
    pub enable_cross_accounts_discovery: std::option::Option<bool>,
}
impl UpdateServiceSettingsInput {
    /// <p>Amazon Resource Name (ARN) of the Amazon S3 bucket where the License Manager information is stored.</p>
    pub fn s3_bucket_arn(&self) -> std::option::Option<&str> {
        self.s3_bucket_arn.as_deref()
    }
    /// <p>Amazon Resource Name (ARN) of the Amazon SNS topic used for License Manager alerts.</p>
    pub fn sns_topic_arn(&self) -> std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>Enables integration with Organizations for cross-account discovery.</p>
    pub fn organization_configuration(
        &self,
    ) -> std::option::Option<&crate::model::OrganizationConfiguration> {
        self.organization_configuration.as_ref()
    }
    /// <p>Activates cross-account discovery.</p>
    pub fn enable_cross_accounts_discovery(&self) -> std::option::Option<bool> {
        self.enable_cross_accounts_discovery
    }
}
impl std::fmt::Debug for UpdateServiceSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateServiceSettingsInput");
        formatter.field("s3_bucket_arn", &self.s3_bucket_arn);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field(
            "organization_configuration",
            &self.organization_configuration,
        );
        formatter.field(
            "enable_cross_accounts_discovery",
            &self.enable_cross_accounts_discovery,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLicenseSpecificationsForResourceInput {
    /// <p>Amazon Resource Name (ARN) of the Amazon Web Services resource.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>ARNs of the license configurations to add.</p>
    pub add_license_specifications:
        std::option::Option<std::vec::Vec<crate::model::LicenseSpecification>>,
    /// <p>ARNs of the license configurations to remove.</p>
    pub remove_license_specifications:
        std::option::Option<std::vec::Vec<crate::model::LicenseSpecification>>,
}
impl UpdateLicenseSpecificationsForResourceInput {
    /// <p>Amazon Resource Name (ARN) of the Amazon Web Services resource.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>ARNs of the license configurations to add.</p>
    pub fn add_license_specifications(
        &self,
    ) -> std::option::Option<&[crate::model::LicenseSpecification]> {
        self.add_license_specifications.as_deref()
    }
    /// <p>ARNs of the license configurations to remove.</p>
    pub fn remove_license_specifications(
        &self,
    ) -> std::option::Option<&[crate::model::LicenseSpecification]> {
        self.remove_license_specifications.as_deref()
    }
}
impl std::fmt::Debug for UpdateLicenseSpecificationsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLicenseSpecificationsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field(
            "add_license_specifications",
            &self.add_license_specifications,
        );
        formatter.field(
            "remove_license_specifications",
            &self.remove_license_specifications,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLicenseManagerReportGeneratorInput {
    /// <p>Amazon Resource Name (ARN) of the report generator to update.</p>
    pub license_manager_report_generator_arn: std::option::Option<std::string::String>,
    /// <p>Name of the report generator.</p>
    pub report_generator_name: std::option::Option<std::string::String>,
    /// <p>Type of reports to generate. The following report types are supported:</p>
    /// <ul>
    /// <li> <p>License configuration report - Reports the number and details of consumed licenses for a license configuration.</p> </li>
    /// <li> <p>Resource report - Reports the tracked licenses and resource consumption for a license configuration.</p> </li>
    /// </ul>
    pub r#type: std::option::Option<std::vec::Vec<crate::model::ReportType>>,
    /// <p>The report context.</p>
    pub report_context: std::option::Option<crate::model::ReportContext>,
    /// <p>Frequency by which reports are generated.</p>
    pub report_frequency: std::option::Option<crate::model::ReportFrequency>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>Description of the report generator.</p>
    pub description: std::option::Option<std::string::String>,
}
impl UpdateLicenseManagerReportGeneratorInput {
    /// <p>Amazon Resource Name (ARN) of the report generator to update.</p>
    pub fn license_manager_report_generator_arn(&self) -> std::option::Option<&str> {
        self.license_manager_report_generator_arn.as_deref()
    }
    /// <p>Name of the report generator.</p>
    pub fn report_generator_name(&self) -> std::option::Option<&str> {
        self.report_generator_name.as_deref()
    }
    /// <p>Type of reports to generate. The following report types are supported:</p>
    /// <ul>
    /// <li> <p>License configuration report - Reports the number and details of consumed licenses for a license configuration.</p> </li>
    /// <li> <p>Resource report - Reports the tracked licenses and resource consumption for a license configuration.</p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&[crate::model::ReportType]> {
        self.r#type.as_deref()
    }
    /// <p>The report context.</p>
    pub fn report_context(&self) -> std::option::Option<&crate::model::ReportContext> {
        self.report_context.as_ref()
    }
    /// <p>Frequency by which reports are generated.</p>
    pub fn report_frequency(&self) -> std::option::Option<&crate::model::ReportFrequency> {
        self.report_frequency.as_ref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>Description of the report generator.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for UpdateLicenseManagerReportGeneratorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLicenseManagerReportGeneratorInput");
        formatter.field(
            "license_manager_report_generator_arn",
            &self.license_manager_report_generator_arn,
        );
        formatter.field("report_generator_name", &self.report_generator_name);
        formatter.field("r#type", &self.r#type);
        formatter.field("report_context", &self.report_context);
        formatter.field("report_frequency", &self.report_frequency);
        formatter.field("client_token", &self.client_token);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateLicenseConfigurationInput {
    /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
    pub license_configuration_arn: std::option::Option<std::string::String>,
    /// <p>New status of the license configuration.</p>
    pub license_configuration_status: std::option::Option<crate::model::LicenseConfigurationStatus>,
    /// <p>New license rule. The only rule that you can add after you create a license configuration is licenseAffinityToHost.</p>
    pub license_rules: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>New number of licenses managed by the license configuration.</p>
    pub license_count: std::option::Option<i64>,
    /// <p>New hard limit of the number of available licenses.</p>
    pub license_count_hard_limit: std::option::Option<bool>,
    /// <p>New name of the license configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>New description of the license configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>New product information.</p>
    pub product_information_list:
        std::option::Option<std::vec::Vec<crate::model::ProductInformation>>,
    /// <p>When true, disassociates a resource when software is uninstalled.</p>
    pub disassociate_when_not_found: std::option::Option<bool>,
}
impl UpdateLicenseConfigurationInput {
    /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
    pub fn license_configuration_arn(&self) -> std::option::Option<&str> {
        self.license_configuration_arn.as_deref()
    }
    /// <p>New status of the license configuration.</p>
    pub fn license_configuration_status(
        &self,
    ) -> std::option::Option<&crate::model::LicenseConfigurationStatus> {
        self.license_configuration_status.as_ref()
    }
    /// <p>New license rule. The only rule that you can add after you create a license configuration is licenseAffinityToHost.</p>
    pub fn license_rules(&self) -> std::option::Option<&[std::string::String]> {
        self.license_rules.as_deref()
    }
    /// <p>New number of licenses managed by the license configuration.</p>
    pub fn license_count(&self) -> std::option::Option<i64> {
        self.license_count
    }
    /// <p>New hard limit of the number of available licenses.</p>
    pub fn license_count_hard_limit(&self) -> std::option::Option<bool> {
        self.license_count_hard_limit
    }
    /// <p>New name of the license configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>New description of the license configuration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>New product information.</p>
    pub fn product_information_list(
        &self,
    ) -> std::option::Option<&[crate::model::ProductInformation]> {
        self.product_information_list.as_deref()
    }
    /// <p>When true, disassociates a resource when software is uninstalled.</p>
    pub fn disassociate_when_not_found(&self) -> std::option::Option<bool> {
        self.disassociate_when_not_found
    }
}
impl std::fmt::Debug for UpdateLicenseConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateLicenseConfigurationInput");
        formatter.field("license_configuration_arn", &self.license_configuration_arn);
        formatter.field(
            "license_configuration_status",
            &self.license_configuration_status,
        );
        formatter.field("license_rules", &self.license_rules);
        formatter.field("license_count", &self.license_count);
        formatter.field("license_count_hard_limit", &self.license_count_hard_limit);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("product_information_list", &self.product_information_list);
        formatter.field(
            "disassociate_when_not_found",
            &self.disassociate_when_not_found,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Keys identifying the tags to remove.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Keys identifying the tags to remove.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>One or more tags.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>One or more tags.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectGrantInput {
    /// <p>Amazon Resource Name (ARN) of the grant.</p>
    pub grant_arn: std::option::Option<std::string::String>,
}
impl RejectGrantInput {
    /// <p>Amazon Resource Name (ARN) of the grant.</p>
    pub fn grant_arn(&self) -> std::option::Option<&str> {
        self.grant_arn.as_deref()
    }
}
impl std::fmt::Debug for RejectGrantInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectGrantInput");
        formatter.field("grant_arn", &self.grant_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListUsageForLicenseConfigurationInput {
    /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
    pub license_configuration_arn: std::option::Option<std::string::String>,
    /// <p>Maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Filters to scope the results. The following filters and logical operators are supported:</p>
    /// <ul>
    /// <li> <p> <code>resourceArn</code> - The ARN of the license configuration resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
    /// <li> <p> <code>resourceType</code> - The resource type (<code>EC2_INSTANCE</code> | <code>EC2_HOST</code> | <code>EC2_AMI</code> | <code>SYSTEMS_MANAGER_MANAGED_INSTANCE</code>). Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
    /// <li> <p> <code>resourceAccount</code> - The ID of the account that owns the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl ListUsageForLicenseConfigurationInput {
    /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
    pub fn license_configuration_arn(&self) -> std::option::Option<&str> {
        self.license_configuration_arn.as_deref()
    }
    /// <p>Maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Filters to scope the results. The following filters and logical operators are supported:</p>
    /// <ul>
    /// <li> <p> <code>resourceArn</code> - The ARN of the license configuration resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
    /// <li> <p> <code>resourceType</code> - The resource type (<code>EC2_INSTANCE</code> | <code>EC2_HOST</code> | <code>EC2_AMI</code> | <code>SYSTEMS_MANAGER_MANAGED_INSTANCE</code>). Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
    /// <li> <p> <code>resourceAccount</code> - The ID of the account that owns the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
    /// </ul>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for ListUsageForLicenseConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListUsageForLicenseConfigurationInput");
        formatter.field("license_configuration_arn", &self.license_configuration_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTokensInput {
    /// <p>Token IDs.</p>
    pub token_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Filters to scope the results. The following filter is supported:</p>
    /// <ul>
    /// <li> <p> <code>LicenseArns</code> </p> </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>Token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListTokensInput {
    /// <p>Token IDs.</p>
    pub fn token_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.token_ids.as_deref()
    }
    /// <p>Filters to scope the results. The following filter is supported:</p>
    /// <ul>
    /// <li> <p> <code>LicenseArns</code> </p> </li>
    /// </ul>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>Token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListTokensInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTokensInput");
        formatter.field("token_ids", &self.token_ids);
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListResourceInventoryInput {
    /// <p>Maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Filters to scope the results. The following filters and logical operators are supported:</p>
    /// <ul>
    /// <li> <p> <code>account_id</code> - The ID of the Amazon Web Services account that owns the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
    /// <li> <p> <code>application_name</code> - The name of the application. Logical operators are <code>EQUALS</code> | <code>BEGINS_WITH</code>.</p> </li>
    /// <li> <p> <code>license_included</code> - The type of license included. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>. Possible values are <code>sql-server-enterprise</code> | <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.</p> </li>
    /// <li> <p> <code>platform</code> - The platform of the resource. Logical operators are <code>EQUALS</code> | <code>BEGINS_WITH</code>.</p> </li>
    /// <li> <p> <code>resource_id</code> - The ID of the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
    /// <li> <p> <code>tag:
    /// <key></key></code> - The key/value combination of a tag assigned to the resource. Logical operators are <code>EQUALS</code> (single account) or <code>EQUALS</code> | <code>NOT_EQUALS</code> (cross account).</p> </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::InventoryFilter>>,
}
impl ListResourceInventoryInput {
    /// <p>Maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Filters to scope the results. The following filters and logical operators are supported:</p>
    /// <ul>
    /// <li> <p> <code>account_id</code> - The ID of the Amazon Web Services account that owns the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
    /// <li> <p> <code>application_name</code> - The name of the application. Logical operators are <code>EQUALS</code> | <code>BEGINS_WITH</code>.</p> </li>
    /// <li> <p> <code>license_included</code> - The type of license included. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>. Possible values are <code>sql-server-enterprise</code> | <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.</p> </li>
    /// <li> <p> <code>platform</code> - The platform of the resource. Logical operators are <code>EQUALS</code> | <code>BEGINS_WITH</code>.</p> </li>
    /// <li> <p> <code>resource_id</code> - The ID of the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
    /// <li> <p> <code>tag:
    /// <key></key></code> - The key/value combination of a tag assigned to the resource. Logical operators are <code>EQUALS</code> (single account) or <code>EQUALS</code> | <code>NOT_EQUALS</code> (cross account).</p> </li>
    /// </ul>
    pub fn filters(&self) -> std::option::Option<&[crate::model::InventoryFilter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for ListResourceInventoryInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListResourceInventoryInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReceivedLicensesInput {
    /// <p>Amazon Resource Names (ARNs) of the licenses.</p>
    pub license_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Filters to scope the results. The following filters are supported:</p>
    /// <ul>
    /// <li> <p> <code>ProductSKU</code> </p> </li>
    /// <li> <p> <code>Status</code> </p> </li>
    /// <li> <p> <code>Fingerprint</code> </p> </li>
    /// <li> <p> <code>IssuerName</code> </p> </li>
    /// <li> <p> <code>Beneficiary</code> </p> </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>Token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListReceivedLicensesInput {
    /// <p>Amazon Resource Names (ARNs) of the licenses.</p>
    pub fn license_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.license_arns.as_deref()
    }
    /// <p>Filters to scope the results. The following filters are supported:</p>
    /// <ul>
    /// <li> <p> <code>ProductSKU</code> </p> </li>
    /// <li> <p> <code>Status</code> </p> </li>
    /// <li> <p> <code>Fingerprint</code> </p> </li>
    /// <li> <p> <code>IssuerName</code> </p> </li>
    /// <li> <p> <code>Beneficiary</code> </p> </li>
    /// </ul>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>Token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListReceivedLicensesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReceivedLicensesInput");
        formatter.field("license_arns", &self.license_arns);
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReceivedGrantsInput {
    /// <p>Amazon Resource Names (ARNs) of the grants.</p>
    pub grant_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Filters to scope the results. The following filters are supported:</p>
    /// <ul>
    /// <li> <p> <code>ProductSKU</code> </p> </li>
    /// <li> <p> <code>LicenseIssuerName</code> </p> </li>
    /// <li> <p> <code>LicenseArn</code> </p> </li>
    /// <li> <p> <code>GrantStatus</code> </p> </li>
    /// <li> <p> <code>GranterAccountId</code> </p> </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>Token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListReceivedGrantsInput {
    /// <p>Amazon Resource Names (ARNs) of the grants.</p>
    pub fn grant_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.grant_arns.as_deref()
    }
    /// <p>Filters to scope the results. The following filters are supported:</p>
    /// <ul>
    /// <li> <p> <code>ProductSKU</code> </p> </li>
    /// <li> <p> <code>LicenseIssuerName</code> </p> </li>
    /// <li> <p> <code>LicenseArn</code> </p> </li>
    /// <li> <p> <code>GrantStatus</code> </p> </li>
    /// <li> <p> <code>GranterAccountId</code> </p> </li>
    /// </ul>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>Token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListReceivedGrantsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReceivedGrantsInput");
        formatter.field("grant_arns", &self.grant_arns);
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLicenseVersionsInput {
    /// <p>Amazon Resource Name (ARN) of the license.</p>
    pub license_arn: std::option::Option<std::string::String>,
    /// <p>Token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListLicenseVersionsInput {
    /// <p>Amazon Resource Name (ARN) of the license.</p>
    pub fn license_arn(&self) -> std::option::Option<&str> {
        self.license_arn.as_deref()
    }
    /// <p>Token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListLicenseVersionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLicenseVersionsInput");
        formatter.field("license_arn", &self.license_arn);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLicenseSpecificationsForResourceInput {
    /// <p>Amazon Resource Name (ARN) of a resource that has an associated license configuration.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListLicenseSpecificationsForResourceInput {
    /// <p>Amazon Resource Name (ARN) of a resource that has an associated license configuration.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListLicenseSpecificationsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLicenseSpecificationsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLicensesInput {
    /// <p>Amazon Resource Names (ARNs) of the licenses.</p>
    pub license_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Filters to scope the results. The following filters are supported:</p>
    /// <ul>
    /// <li> <p> <code>Beneficiary</code> </p> </li>
    /// <li> <p> <code>ProductSKU</code> </p> </li>
    /// <li> <p> <code>Fingerprint</code> </p> </li>
    /// <li> <p> <code>Status</code> </p> </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>Token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListLicensesInput {
    /// <p>Amazon Resource Names (ARNs) of the licenses.</p>
    pub fn license_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.license_arns.as_deref()
    }
    /// <p>Filters to scope the results. The following filters are supported:</p>
    /// <ul>
    /// <li> <p> <code>Beneficiary</code> </p> </li>
    /// <li> <p> <code>ProductSKU</code> </p> </li>
    /// <li> <p> <code>Fingerprint</code> </p> </li>
    /// <li> <p> <code>Status</code> </p> </li>
    /// </ul>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>Token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListLicensesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLicensesInput");
        formatter.field("license_arns", &self.license_arns);
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLicenseManagerReportGeneratorsInput {
    /// <p>Filters to scope the results. The following filters are supported: </p>
    /// <ul>
    /// <li> <p> <code>LicenseConfigurationArn</code> </p> </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>Token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListLicenseManagerReportGeneratorsInput {
    /// <p>Filters to scope the results. The following filters are supported: </p>
    /// <ul>
    /// <li> <p> <code>LicenseConfigurationArn</code> </p> </li>
    /// </ul>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>Token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListLicenseManagerReportGeneratorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLicenseManagerReportGeneratorsInput");
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLicenseConversionTasksInput {
    /// <p>Token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
    /// <p> Filters to scope the results. Valid filters are <code>ResourceArns</code> and <code>Status</code>. </p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl ListLicenseConversionTasksInput {
    /// <p>Token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p> Filters to scope the results. Valid filters are <code>ResourceArns</code> and <code>Status</code>. </p>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for ListLicenseConversionTasksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLicenseConversionTasksInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListLicenseConfigurationsInput {
    /// <p>Amazon Resource Names (ARN) of the license configurations.</p>
    pub license_configuration_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Filters to scope the results. The following filters and logical operators are supported:</p>
    /// <ul>
    /// <li> <p> <code>licenseCountingType</code> - The dimension for which licenses are counted. Possible values are <code>vCPU</code> | <code>Instance</code> | <code>Core</code> | <code>Socket</code>. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
    /// <li> <p> <code>enforceLicenseCount</code> - A Boolean value that indicates whether hard license enforcement is used. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
    /// <li> <p> <code>usagelimitExceeded</code> - A Boolean value that indicates whether the available licenses have been exceeded. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl ListLicenseConfigurationsInput {
    /// <p>Amazon Resource Names (ARN) of the license configurations.</p>
    pub fn license_configuration_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.license_configuration_arns.as_deref()
    }
    /// <p>Maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Filters to scope the results. The following filters and logical operators are supported:</p>
    /// <ul>
    /// <li> <p> <code>licenseCountingType</code> - The dimension for which licenses are counted. Possible values are <code>vCPU</code> | <code>Instance</code> | <code>Core</code> | <code>Socket</code>. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
    /// <li> <p> <code>enforceLicenseCount</code> - A Boolean value that indicates whether hard license enforcement is used. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
    /// <li> <p> <code>usagelimitExceeded</code> - A Boolean value that indicates whether the available licenses have been exceeded. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
    /// </ul>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
}
impl std::fmt::Debug for ListLicenseConfigurationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListLicenseConfigurationsInput");
        formatter.field(
            "license_configuration_arns",
            &self.license_configuration_arns,
        );
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFailuresForLicenseConfigurationOperationsInput {
    /// <p>Amazon Resource Name of the license configuration.</p>
    pub license_configuration_arn: std::option::Option<std::string::String>,
    /// <p>Maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFailuresForLicenseConfigurationOperationsInput {
    /// <p>Amazon Resource Name of the license configuration.</p>
    pub fn license_configuration_arn(&self) -> std::option::Option<&str> {
        self.license_configuration_arn.as_deref()
    }
    /// <p>Maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFailuresForLicenseConfigurationOperationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFailuresForLicenseConfigurationOperationsInput");
        formatter.field("license_configuration_arn", &self.license_configuration_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDistributedGrantsInput {
    /// <p>Amazon Resource Names (ARNs) of the grants.</p>
    pub grant_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Filters to scope the results. The following filters are supported:</p>
    /// <ul>
    /// <li> <p> <code>LicenseArn</code> </p> </li>
    /// <li> <p> <code>GrantStatus</code> </p> </li>
    /// <li> <p> <code>GranteePrincipalARN</code> </p> </li>
    /// <li> <p> <code>ProductSKU</code> </p> </li>
    /// <li> <p> <code>LicenseIssuerName</code> </p> </li>
    /// </ul>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>Token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListDistributedGrantsInput {
    /// <p>Amazon Resource Names (ARNs) of the grants.</p>
    pub fn grant_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.grant_arns.as_deref()
    }
    /// <p>Filters to scope the results. The following filters are supported:</p>
    /// <ul>
    /// <li> <p> <code>LicenseArn</code> </p> </li>
    /// <li> <p> <code>GrantStatus</code> </p> </li>
    /// <li> <p> <code>GranteePrincipalARN</code> </p> </li>
    /// <li> <p> <code>ProductSKU</code> </p> </li>
    /// <li> <p> <code>LicenseIssuerName</code> </p> </li>
    /// </ul>
    pub fn filters(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filters.as_deref()
    }
    /// <p>Token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListDistributedGrantsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDistributedGrantsInput");
        formatter.field("grant_arns", &self.grant_arns);
        formatter.field("filters", &self.filters);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAssociationsForLicenseConfigurationInput {
    /// <p>Amazon Resource Name (ARN) of a license configuration.</p>
    pub license_configuration_arn: std::option::Option<std::string::String>,
    /// <p>Maximum number of results to return in a single call.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAssociationsForLicenseConfigurationInput {
    /// <p>Amazon Resource Name (ARN) of a license configuration.</p>
    pub fn license_configuration_arn(&self) -> std::option::Option<&str> {
        self.license_configuration_arn.as_deref()
    }
    /// <p>Maximum number of results to return in a single call.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAssociationsForLicenseConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAssociationsForLicenseConfigurationInput");
        formatter.field("license_configuration_arn", &self.license_configuration_arn);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetServiceSettingsInput {}
impl std::fmt::Debug for GetServiceSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetServiceSettingsInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLicenseUsageInput {
    /// <p>Amazon Resource Name (ARN) of the license.</p>
    pub license_arn: std::option::Option<std::string::String>,
}
impl GetLicenseUsageInput {
    /// <p>Amazon Resource Name (ARN) of the license.</p>
    pub fn license_arn(&self) -> std::option::Option<&str> {
        self.license_arn.as_deref()
    }
}
impl std::fmt::Debug for GetLicenseUsageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLicenseUsageInput");
        formatter.field("license_arn", &self.license_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLicenseManagerReportGeneratorInput {
    /// <p>Amazon Resource Name (ARN) of the report generator.</p>
    pub license_manager_report_generator_arn: std::option::Option<std::string::String>,
}
impl GetLicenseManagerReportGeneratorInput {
    /// <p>Amazon Resource Name (ARN) of the report generator.</p>
    pub fn license_manager_report_generator_arn(&self) -> std::option::Option<&str> {
        self.license_manager_report_generator_arn.as_deref()
    }
}
impl std::fmt::Debug for GetLicenseManagerReportGeneratorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLicenseManagerReportGeneratorInput");
        formatter.field(
            "license_manager_report_generator_arn",
            &self.license_manager_report_generator_arn,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLicenseConversionTaskInput {
    /// <p>ID of the license type conversion task to retrieve information on.</p>
    pub license_conversion_task_id: std::option::Option<std::string::String>,
}
impl GetLicenseConversionTaskInput {
    /// <p>ID of the license type conversion task to retrieve information on.</p>
    pub fn license_conversion_task_id(&self) -> std::option::Option<&str> {
        self.license_conversion_task_id.as_deref()
    }
}
impl std::fmt::Debug for GetLicenseConversionTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLicenseConversionTaskInput");
        formatter.field(
            "license_conversion_task_id",
            &self.license_conversion_task_id,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLicenseConfigurationInput {
    /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
    pub license_configuration_arn: std::option::Option<std::string::String>,
}
impl GetLicenseConfigurationInput {
    /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
    pub fn license_configuration_arn(&self) -> std::option::Option<&str> {
        self.license_configuration_arn.as_deref()
    }
}
impl std::fmt::Debug for GetLicenseConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLicenseConfigurationInput");
        formatter.field("license_configuration_arn", &self.license_configuration_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetLicenseInput {
    /// <p>Amazon Resource Name (ARN) of the license.</p>
    pub license_arn: std::option::Option<std::string::String>,
    /// <p>License version.</p>
    pub version: std::option::Option<std::string::String>,
}
impl GetLicenseInput {
    /// <p>Amazon Resource Name (ARN) of the license.</p>
    pub fn license_arn(&self) -> std::option::Option<&str> {
        self.license_arn.as_deref()
    }
    /// <p>License version.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for GetLicenseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetLicenseInput");
        formatter.field("license_arn", &self.license_arn);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetGrantInput {
    /// <p>Amazon Resource Name (ARN) of the grant.</p>
    pub grant_arn: std::option::Option<std::string::String>,
    /// <p>Grant version.</p>
    pub version: std::option::Option<std::string::String>,
}
impl GetGrantInput {
    /// <p>Amazon Resource Name (ARN) of the grant.</p>
    pub fn grant_arn(&self) -> std::option::Option<&str> {
        self.grant_arn.as_deref()
    }
    /// <p>Grant version.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for GetGrantInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetGrantInput");
        formatter.field("grant_arn", &self.grant_arn);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAccessTokenInput {
    /// <p>Refresh token, encoded as a JWT token.</p>
    pub token: std::option::Option<std::string::String>,
    /// <p>Token properties to validate against those present in the JWT token.</p>
    pub token_properties: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl GetAccessTokenInput {
    /// <p>Refresh token, encoded as a JWT token.</p>
    pub fn token(&self) -> std::option::Option<&str> {
        self.token.as_deref()
    }
    /// <p>Token properties to validate against those present in the JWT token.</p>
    pub fn token_properties(&self) -> std::option::Option<&[std::string::String]> {
        self.token_properties.as_deref()
    }
}
impl std::fmt::Debug for GetAccessTokenInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAccessTokenInput");
        formatter.field("token", &self.token);
        formatter.field("token_properties", &self.token_properties);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExtendLicenseConsumptionInput {
    /// <p>License consumption token.</p>
    pub license_consumption_token: std::option::Option<std::string::String>,
    /// <p>Checks whether you have the required permissions for the action, without actually making the request. Provides an error response if you do not have the required permissions.</p>
    pub dry_run: bool,
}
impl ExtendLicenseConsumptionInput {
    /// <p>License consumption token.</p>
    pub fn license_consumption_token(&self) -> std::option::Option<&str> {
        self.license_consumption_token.as_deref()
    }
    /// <p>Checks whether you have the required permissions for the action, without actually making the request. Provides an error response if you do not have the required permissions.</p>
    pub fn dry_run(&self) -> bool {
        self.dry_run
    }
}
impl std::fmt::Debug for ExtendLicenseConsumptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExtendLicenseConsumptionInput");
        formatter.field("license_consumption_token", &self.license_consumption_token);
        formatter.field("dry_run", &self.dry_run);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTokenInput {
    /// <p>Token ID.</p>
    pub token_id: std::option::Option<std::string::String>,
}
impl DeleteTokenInput {
    /// <p>Token ID.</p>
    pub fn token_id(&self) -> std::option::Option<&str> {
        self.token_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteTokenInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTokenInput");
        formatter.field("token_id", &self.token_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLicenseManagerReportGeneratorInput {
    /// <p>Amazon Resource Name (ARN) of the report generator to be deleted.</p>
    pub license_manager_report_generator_arn: std::option::Option<std::string::String>,
}
impl DeleteLicenseManagerReportGeneratorInput {
    /// <p>Amazon Resource Name (ARN) of the report generator to be deleted.</p>
    pub fn license_manager_report_generator_arn(&self) -> std::option::Option<&str> {
        self.license_manager_report_generator_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteLicenseManagerReportGeneratorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLicenseManagerReportGeneratorInput");
        formatter.field(
            "license_manager_report_generator_arn",
            &self.license_manager_report_generator_arn,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLicenseConfigurationInput {
    /// <p>ID of the license configuration.</p>
    pub license_configuration_arn: std::option::Option<std::string::String>,
}
impl DeleteLicenseConfigurationInput {
    /// <p>ID of the license configuration.</p>
    pub fn license_configuration_arn(&self) -> std::option::Option<&str> {
        self.license_configuration_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteLicenseConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLicenseConfigurationInput");
        formatter.field("license_configuration_arn", &self.license_configuration_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteLicenseInput {
    /// <p>Amazon Resource Name (ARN) of the license.</p>
    pub license_arn: std::option::Option<std::string::String>,
    /// <p>Current version of the license.</p>
    pub source_version: std::option::Option<std::string::String>,
}
impl DeleteLicenseInput {
    /// <p>Amazon Resource Name (ARN) of the license.</p>
    pub fn license_arn(&self) -> std::option::Option<&str> {
        self.license_arn.as_deref()
    }
    /// <p>Current version of the license.</p>
    pub fn source_version(&self) -> std::option::Option<&str> {
        self.source_version.as_deref()
    }
}
impl std::fmt::Debug for DeleteLicenseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteLicenseInput");
        formatter.field("license_arn", &self.license_arn);
        formatter.field("source_version", &self.source_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGrantInput {
    /// <p>Amazon Resource Name (ARN) of the grant.</p>
    pub grant_arn: std::option::Option<std::string::String>,
    /// <p>The Status reason for the delete request.</p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>Current version of the grant.</p>
    pub version: std::option::Option<std::string::String>,
}
impl DeleteGrantInput {
    /// <p>Amazon Resource Name (ARN) of the grant.</p>
    pub fn grant_arn(&self) -> std::option::Option<&str> {
        self.grant_arn.as_deref()
    }
    /// <p>The Status reason for the delete request.</p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
    /// <p>Current version of the grant.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
}
impl std::fmt::Debug for DeleteGrantInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGrantInput");
        formatter.field("grant_arn", &self.grant_arn);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("version", &self.version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTokenInput {
    /// <p>Amazon Resource Name (ARN) of the license. The ARN is mapped to the aud claim of the JWT token.</p>
    pub license_arn: std::option::Option<std::string::String>,
    /// <p>Amazon Resource Name (ARN) of the IAM roles to embed in the token. License Manager does not check whether the roles are in use.</p>
    pub role_arns: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Token expiration, in days, counted from token creation. The default is 365 days.</p>
    pub expiration_in_days: std::option::Option<i32>,
    /// <p>Data specified by the caller to be included in the JWT token. The data is mapped to the amr claim of the JWT token.</p>
    pub token_properties: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Idempotency token, valid for 10 minutes.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateTokenInput {
    /// <p>Amazon Resource Name (ARN) of the license. The ARN is mapped to the aud claim of the JWT token.</p>
    pub fn license_arn(&self) -> std::option::Option<&str> {
        self.license_arn.as_deref()
    }
    /// <p>Amazon Resource Name (ARN) of the IAM roles to embed in the token. License Manager does not check whether the roles are in use.</p>
    pub fn role_arns(&self) -> std::option::Option<&[std::string::String]> {
        self.role_arns.as_deref()
    }
    /// <p>Token expiration, in days, counted from token creation. The default is 365 days.</p>
    pub fn expiration_in_days(&self) -> std::option::Option<i32> {
        self.expiration_in_days
    }
    /// <p>Data specified by the caller to be included in the JWT token. The data is mapped to the amr claim of the JWT token.</p>
    pub fn token_properties(&self) -> std::option::Option<&[std::string::String]> {
        self.token_properties.as_deref()
    }
    /// <p>Idempotency token, valid for 10 minutes.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateTokenInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTokenInput");
        formatter.field("license_arn", &self.license_arn);
        formatter.field("role_arns", &self.role_arns);
        formatter.field("expiration_in_days", &self.expiration_in_days);
        formatter.field("token_properties", &self.token_properties);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLicenseVersionInput {
    /// <p>Amazon Resource Name (ARN) of the license.</p>
    pub license_arn: std::option::Option<std::string::String>,
    /// <p>License name.</p>
    pub license_name: std::option::Option<std::string::String>,
    /// <p>Product name.</p>
    pub product_name: std::option::Option<std::string::String>,
    /// <p>License issuer.</p>
    pub issuer: std::option::Option<crate::model::Issuer>,
    /// <p>Home Region of the license.</p>
    pub home_region: std::option::Option<std::string::String>,
    /// <p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>
    pub validity: std::option::Option<crate::model::DatetimeRange>,
    /// <p>Information about the license.</p>
    pub license_metadata: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
    /// <p>License entitlements.</p>
    pub entitlements: std::option::Option<std::vec::Vec<crate::model::Entitlement>>,
    /// <p>Configuration for consumption of the license. Choose a provisional configuration for workloads running with continuous connectivity. Choose a borrow configuration for workloads with offline usage.</p>
    pub consumption_configuration: std::option::Option<crate::model::ConsumptionConfiguration>,
    /// <p>License status.</p>
    pub status: std::option::Option<crate::model::LicenseStatus>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>Current version of the license.</p>
    pub source_version: std::option::Option<std::string::String>,
}
impl CreateLicenseVersionInput {
    /// <p>Amazon Resource Name (ARN) of the license.</p>
    pub fn license_arn(&self) -> std::option::Option<&str> {
        self.license_arn.as_deref()
    }
    /// <p>License name.</p>
    pub fn license_name(&self) -> std::option::Option<&str> {
        self.license_name.as_deref()
    }
    /// <p>Product name.</p>
    pub fn product_name(&self) -> std::option::Option<&str> {
        self.product_name.as_deref()
    }
    /// <p>License issuer.</p>
    pub fn issuer(&self) -> std::option::Option<&crate::model::Issuer> {
        self.issuer.as_ref()
    }
    /// <p>Home Region of the license.</p>
    pub fn home_region(&self) -> std::option::Option<&str> {
        self.home_region.as_deref()
    }
    /// <p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>
    pub fn validity(&self) -> std::option::Option<&crate::model::DatetimeRange> {
        self.validity.as_ref()
    }
    /// <p>Information about the license.</p>
    pub fn license_metadata(&self) -> std::option::Option<&[crate::model::Metadata]> {
        self.license_metadata.as_deref()
    }
    /// <p>License entitlements.</p>
    pub fn entitlements(&self) -> std::option::Option<&[crate::model::Entitlement]> {
        self.entitlements.as_deref()
    }
    /// <p>Configuration for consumption of the license. Choose a provisional configuration for workloads running with continuous connectivity. Choose a borrow configuration for workloads with offline usage.</p>
    pub fn consumption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ConsumptionConfiguration> {
        self.consumption_configuration.as_ref()
    }
    /// <p>License status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::LicenseStatus> {
        self.status.as_ref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>Current version of the license.</p>
    pub fn source_version(&self) -> std::option::Option<&str> {
        self.source_version.as_deref()
    }
}
impl std::fmt::Debug for CreateLicenseVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLicenseVersionInput");
        formatter.field("license_arn", &self.license_arn);
        formatter.field("license_name", &self.license_name);
        formatter.field("product_name", &self.product_name);
        formatter.field("issuer", &self.issuer);
        formatter.field("home_region", &self.home_region);
        formatter.field("validity", &self.validity);
        formatter.field("license_metadata", &self.license_metadata);
        formatter.field("entitlements", &self.entitlements);
        formatter.field("consumption_configuration", &self.consumption_configuration);
        formatter.field("status", &self.status);
        formatter.field("client_token", &self.client_token);
        formatter.field("source_version", &self.source_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLicenseManagerReportGeneratorInput {
    /// <p>Name of the report generator.</p>
    pub report_generator_name: std::option::Option<std::string::String>,
    /// <p>Type of reports to generate. The following report types an be generated:</p>
    /// <ul>
    /// <li> <p>License configuration report - Reports the number and details of consumed licenses for a license configuration.</p> </li>
    /// <li> <p>Resource report - Reports the tracked licenses and resource consumption for a license configuration.</p> </li>
    /// </ul>
    pub r#type: std::option::Option<std::vec::Vec<crate::model::ReportType>>,
    /// <p>Defines the type of license configuration the report generator tracks.</p>
    pub report_context: std::option::Option<crate::model::ReportContext>,
    /// <p>Frequency by which reports are generated. Reports can be generated daily, monthly, or weekly.</p>
    pub report_frequency: std::option::Option<crate::model::ReportFrequency>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>Description of the report generator.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Tags to add to the report generator.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateLicenseManagerReportGeneratorInput {
    /// <p>Name of the report generator.</p>
    pub fn report_generator_name(&self) -> std::option::Option<&str> {
        self.report_generator_name.as_deref()
    }
    /// <p>Type of reports to generate. The following report types an be generated:</p>
    /// <ul>
    /// <li> <p>License configuration report - Reports the number and details of consumed licenses for a license configuration.</p> </li>
    /// <li> <p>Resource report - Reports the tracked licenses and resource consumption for a license configuration.</p> </li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&[crate::model::ReportType]> {
        self.r#type.as_deref()
    }
    /// <p>Defines the type of license configuration the report generator tracks.</p>
    pub fn report_context(&self) -> std::option::Option<&crate::model::ReportContext> {
        self.report_context.as_ref()
    }
    /// <p>Frequency by which reports are generated. Reports can be generated daily, monthly, or weekly.</p>
    pub fn report_frequency(&self) -> std::option::Option<&crate::model::ReportFrequency> {
        self.report_frequency.as_ref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>Description of the report generator.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Tags to add to the report generator.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateLicenseManagerReportGeneratorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLicenseManagerReportGeneratorInput");
        formatter.field("report_generator_name", &self.report_generator_name);
        formatter.field("r#type", &self.r#type);
        formatter.field("report_context", &self.report_context);
        formatter.field("report_frequency", &self.report_frequency);
        formatter.field("client_token", &self.client_token);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLicenseConversionTaskForResourceInput {
    /// <p>Amazon Resource Name (ARN) of the resource you are converting the license type for.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>Information that identifies the license type you are converting from. For the structure of the source license, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli">Convert a license type using the AWS CLI</a> in the <i>License Manager User Guide</i>.</p>
    pub source_license_context: std::option::Option<crate::model::LicenseConversionContext>,
    /// <p>Information that identifies the license type you are converting to. For the structure of the destination license, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli">Convert a license type using the AWS CLI</a> in the <i>License Manager User Guide</i>.</p>
    pub destination_license_context: std::option::Option<crate::model::LicenseConversionContext>,
}
impl CreateLicenseConversionTaskForResourceInput {
    /// <p>Amazon Resource Name (ARN) of the resource you are converting the license type for.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>Information that identifies the license type you are converting from. For the structure of the source license, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli">Convert a license type using the AWS CLI</a> in the <i>License Manager User Guide</i>.</p>
    pub fn source_license_context(
        &self,
    ) -> std::option::Option<&crate::model::LicenseConversionContext> {
        self.source_license_context.as_ref()
    }
    /// <p>Information that identifies the license type you are converting to. For the structure of the destination license, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli">Convert a license type using the AWS CLI</a> in the <i>License Manager User Guide</i>.</p>
    pub fn destination_license_context(
        &self,
    ) -> std::option::Option<&crate::model::LicenseConversionContext> {
        self.destination_license_context.as_ref()
    }
}
impl std::fmt::Debug for CreateLicenseConversionTaskForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLicenseConversionTaskForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("source_license_context", &self.source_license_context);
        formatter.field(
            "destination_license_context",
            &self.destination_license_context,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLicenseConfigurationInput {
    /// <p>Name of the license configuration.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Description of the license configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Dimension used to track the license inventory.</p>
    pub license_counting_type: std::option::Option<crate::model::LicenseCountingType>,
    /// <p>Number of licenses managed by the license configuration.</p>
    pub license_count: std::option::Option<i64>,
    /// <p>Indicates whether hard or soft license enforcement is used. Exceeding a hard limit blocks the launch of new instances.</p>
    pub license_count_hard_limit: std::option::Option<bool>,
    /// <p>License rules. The syntax is #name=value (for example, #allowedTenancy=EC2-DedicatedHost). The available rules vary by dimension, as follows.</p>
    /// <ul>
    /// <li> <p> <code>Cores</code> dimension: <code>allowedTenancy</code> | <code>licenseAffinityToHost</code> | <code>maximumCores</code> | <code>minimumCores</code> </p> </li>
    /// <li> <p> <code>Instances</code> dimension: <code>allowedTenancy</code> | <code>maximumCores</code> | <code>minimumCores</code> | <code>maximumSockets</code> | <code>minimumSockets</code> | <code>maximumVcpus</code> | <code>minimumVcpus</code> </p> </li>
    /// <li> <p> <code>Sockets</code> dimension: <code>allowedTenancy</code> | <code>licenseAffinityToHost</code> | <code>maximumSockets</code> | <code>minimumSockets</code> </p> </li>
    /// <li> <p> <code>vCPUs</code> dimension: <code>allowedTenancy</code> | <code>honorVcpuOptimization</code> | <code>maximumVcpus</code> | <code>minimumVcpus</code> </p> </li>
    /// </ul>
    /// <p>The unit for <code>licenseAffinityToHost</code> is days and the range is 1 to 180. The possible values for <code>allowedTenancy</code> are <code>EC2-Default</code>, <code>EC2-DedicatedHost</code>, and <code>EC2-DedicatedInstance</code>. The possible values for <code>honorVcpuOptimization</code> are <code>True</code> and <code>False</code>.</p>
    pub license_rules: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Tags to add to the license configuration.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>When true, disassociates a resource when software is uninstalled.</p>
    pub disassociate_when_not_found: std::option::Option<bool>,
    /// <p>Product information.</p>
    pub product_information_list:
        std::option::Option<std::vec::Vec<crate::model::ProductInformation>>,
}
impl CreateLicenseConfigurationInput {
    /// <p>Name of the license configuration.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Description of the license configuration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Dimension used to track the license inventory.</p>
    pub fn license_counting_type(&self) -> std::option::Option<&crate::model::LicenseCountingType> {
        self.license_counting_type.as_ref()
    }
    /// <p>Number of licenses managed by the license configuration.</p>
    pub fn license_count(&self) -> std::option::Option<i64> {
        self.license_count
    }
    /// <p>Indicates whether hard or soft license enforcement is used. Exceeding a hard limit blocks the launch of new instances.</p>
    pub fn license_count_hard_limit(&self) -> std::option::Option<bool> {
        self.license_count_hard_limit
    }
    /// <p>License rules. The syntax is #name=value (for example, #allowedTenancy=EC2-DedicatedHost). The available rules vary by dimension, as follows.</p>
    /// <ul>
    /// <li> <p> <code>Cores</code> dimension: <code>allowedTenancy</code> | <code>licenseAffinityToHost</code> | <code>maximumCores</code> | <code>minimumCores</code> </p> </li>
    /// <li> <p> <code>Instances</code> dimension: <code>allowedTenancy</code> | <code>maximumCores</code> | <code>minimumCores</code> | <code>maximumSockets</code> | <code>minimumSockets</code> | <code>maximumVcpus</code> | <code>minimumVcpus</code> </p> </li>
    /// <li> <p> <code>Sockets</code> dimension: <code>allowedTenancy</code> | <code>licenseAffinityToHost</code> | <code>maximumSockets</code> | <code>minimumSockets</code> </p> </li>
    /// <li> <p> <code>vCPUs</code> dimension: <code>allowedTenancy</code> | <code>honorVcpuOptimization</code> | <code>maximumVcpus</code> | <code>minimumVcpus</code> </p> </li>
    /// </ul>
    /// <p>The unit for <code>licenseAffinityToHost</code> is days and the range is 1 to 180. The possible values for <code>allowedTenancy</code> are <code>EC2-Default</code>, <code>EC2-DedicatedHost</code>, and <code>EC2-DedicatedInstance</code>. The possible values for <code>honorVcpuOptimization</code> are <code>True</code> and <code>False</code>.</p>
    pub fn license_rules(&self) -> std::option::Option<&[std::string::String]> {
        self.license_rules.as_deref()
    }
    /// <p>Tags to add to the license configuration.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>When true, disassociates a resource when software is uninstalled.</p>
    pub fn disassociate_when_not_found(&self) -> std::option::Option<bool> {
        self.disassociate_when_not_found
    }
    /// <p>Product information.</p>
    pub fn product_information_list(
        &self,
    ) -> std::option::Option<&[crate::model::ProductInformation]> {
        self.product_information_list.as_deref()
    }
}
impl std::fmt::Debug for CreateLicenseConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLicenseConfigurationInput");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("license_counting_type", &self.license_counting_type);
        formatter.field("license_count", &self.license_count);
        formatter.field("license_count_hard_limit", &self.license_count_hard_limit);
        formatter.field("license_rules", &self.license_rules);
        formatter.field("tags", &self.tags);
        formatter.field(
            "disassociate_when_not_found",
            &self.disassociate_when_not_found,
        );
        formatter.field("product_information_list", &self.product_information_list);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateLicenseInput {
    /// <p>License name.</p>
    pub license_name: std::option::Option<std::string::String>,
    /// <p>Product name.</p>
    pub product_name: std::option::Option<std::string::String>,
    /// <p>Product SKU.</p>
    pub product_sku: std::option::Option<std::string::String>,
    /// <p>License issuer.</p>
    pub issuer: std::option::Option<crate::model::Issuer>,
    /// <p>Home Region for the license.</p>
    pub home_region: std::option::Option<std::string::String>,
    /// <p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>
    pub validity: std::option::Option<crate::model::DatetimeRange>,
    /// <p>License entitlements.</p>
    pub entitlements: std::option::Option<std::vec::Vec<crate::model::Entitlement>>,
    /// <p>License beneficiary.</p>
    pub beneficiary: std::option::Option<std::string::String>,
    /// <p>Configuration for consumption of the license. Choose a provisional configuration for workloads running with continuous connectivity. Choose a borrow configuration for workloads with offline usage.</p>
    pub consumption_configuration: std::option::Option<crate::model::ConsumptionConfiguration>,
    /// <p>Information about the license.</p>
    pub license_metadata: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateLicenseInput {
    /// <p>License name.</p>
    pub fn license_name(&self) -> std::option::Option<&str> {
        self.license_name.as_deref()
    }
    /// <p>Product name.</p>
    pub fn product_name(&self) -> std::option::Option<&str> {
        self.product_name.as_deref()
    }
    /// <p>Product SKU.</p>
    pub fn product_sku(&self) -> std::option::Option<&str> {
        self.product_sku.as_deref()
    }
    /// <p>License issuer.</p>
    pub fn issuer(&self) -> std::option::Option<&crate::model::Issuer> {
        self.issuer.as_ref()
    }
    /// <p>Home Region for the license.</p>
    pub fn home_region(&self) -> std::option::Option<&str> {
        self.home_region.as_deref()
    }
    /// <p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>
    pub fn validity(&self) -> std::option::Option<&crate::model::DatetimeRange> {
        self.validity.as_ref()
    }
    /// <p>License entitlements.</p>
    pub fn entitlements(&self) -> std::option::Option<&[crate::model::Entitlement]> {
        self.entitlements.as_deref()
    }
    /// <p>License beneficiary.</p>
    pub fn beneficiary(&self) -> std::option::Option<&str> {
        self.beneficiary.as_deref()
    }
    /// <p>Configuration for consumption of the license. Choose a provisional configuration for workloads running with continuous connectivity. Choose a borrow configuration for workloads with offline usage.</p>
    pub fn consumption_configuration(
        &self,
    ) -> std::option::Option<&crate::model::ConsumptionConfiguration> {
        self.consumption_configuration.as_ref()
    }
    /// <p>Information about the license.</p>
    pub fn license_metadata(&self) -> std::option::Option<&[crate::model::Metadata]> {
        self.license_metadata.as_deref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateLicenseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateLicenseInput");
        formatter.field("license_name", &self.license_name);
        formatter.field("product_name", &self.product_name);
        formatter.field("product_sku", &self.product_sku);
        formatter.field("issuer", &self.issuer);
        formatter.field("home_region", &self.home_region);
        formatter.field("validity", &self.validity);
        formatter.field("entitlements", &self.entitlements);
        formatter.field("beneficiary", &self.beneficiary);
        formatter.field("consumption_configuration", &self.consumption_configuration);
        formatter.field("license_metadata", &self.license_metadata);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGrantVersionInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>Amazon Resource Name (ARN) of the grant.</p>
    pub grant_arn: std::option::Option<std::string::String>,
    /// <p>Grant name.</p>
    pub grant_name: std::option::Option<std::string::String>,
    /// <p>Allowed operations for the grant.</p>
    pub allowed_operations: std::option::Option<std::vec::Vec<crate::model::AllowedOperation>>,
    /// <p>Grant status.</p>
    pub status: std::option::Option<crate::model::GrantStatus>,
    /// <p>Grant status reason.</p>
    pub status_reason: std::option::Option<std::string::String>,
    /// <p>Current version of the grant.</p>
    pub source_version: std::option::Option<std::string::String>,
}
impl CreateGrantVersionInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>Amazon Resource Name (ARN) of the grant.</p>
    pub fn grant_arn(&self) -> std::option::Option<&str> {
        self.grant_arn.as_deref()
    }
    /// <p>Grant name.</p>
    pub fn grant_name(&self) -> std::option::Option<&str> {
        self.grant_name.as_deref()
    }
    /// <p>Allowed operations for the grant.</p>
    pub fn allowed_operations(&self) -> std::option::Option<&[crate::model::AllowedOperation]> {
        self.allowed_operations.as_deref()
    }
    /// <p>Grant status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::GrantStatus> {
        self.status.as_ref()
    }
    /// <p>Grant status reason.</p>
    pub fn status_reason(&self) -> std::option::Option<&str> {
        self.status_reason.as_deref()
    }
    /// <p>Current version of the grant.</p>
    pub fn source_version(&self) -> std::option::Option<&str> {
        self.source_version.as_deref()
    }
}
impl std::fmt::Debug for CreateGrantVersionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGrantVersionInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("grant_arn", &self.grant_arn);
        formatter.field("grant_name", &self.grant_name);
        formatter.field("allowed_operations", &self.allowed_operations);
        formatter.field("status", &self.status);
        formatter.field("status_reason", &self.status_reason);
        formatter.field("source_version", &self.source_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGrantInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>Grant name.</p>
    pub grant_name: std::option::Option<std::string::String>,
    /// <p>Amazon Resource Name (ARN) of the license.</p>
    pub license_arn: std::option::Option<std::string::String>,
    /// <p>The grant principals.</p>
    pub principals: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Home Region of the grant.</p>
    pub home_region: std::option::Option<std::string::String>,
    /// <p>Allowed operations for the grant.</p>
    pub allowed_operations: std::option::Option<std::vec::Vec<crate::model::AllowedOperation>>,
}
impl CreateGrantInput {
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>Grant name.</p>
    pub fn grant_name(&self) -> std::option::Option<&str> {
        self.grant_name.as_deref()
    }
    /// <p>Amazon Resource Name (ARN) of the license.</p>
    pub fn license_arn(&self) -> std::option::Option<&str> {
        self.license_arn.as_deref()
    }
    /// <p>The grant principals.</p>
    pub fn principals(&self) -> std::option::Option<&[std::string::String]> {
        self.principals.as_deref()
    }
    /// <p>Home Region of the grant.</p>
    pub fn home_region(&self) -> std::option::Option<&str> {
        self.home_region.as_deref()
    }
    /// <p>Allowed operations for the grant.</p>
    pub fn allowed_operations(&self) -> std::option::Option<&[crate::model::AllowedOperation]> {
        self.allowed_operations.as_deref()
    }
}
impl std::fmt::Debug for CreateGrantInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGrantInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("grant_name", &self.grant_name);
        formatter.field("license_arn", &self.license_arn);
        formatter.field("principals", &self.principals);
        formatter.field("home_region", &self.home_region);
        formatter.field("allowed_operations", &self.allowed_operations);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CheckoutLicenseInput {
    /// <p>Product SKU.</p>
    pub product_sku: std::option::Option<std::string::String>,
    /// <p>Checkout type.</p>
    pub checkout_type: std::option::Option<crate::model::CheckoutType>,
    /// <p>Key fingerprint identifying the license.</p>
    pub key_fingerprint: std::option::Option<std::string::String>,
    /// <p>License entitlements.</p>
    pub entitlements: std::option::Option<std::vec::Vec<crate::model::EntitlementData>>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>License beneficiary.</p>
    pub beneficiary: std::option::Option<std::string::String>,
    /// <p>Node ID.</p>
    pub node_id: std::option::Option<std::string::String>,
}
impl CheckoutLicenseInput {
    /// <p>Product SKU.</p>
    pub fn product_sku(&self) -> std::option::Option<&str> {
        self.product_sku.as_deref()
    }
    /// <p>Checkout type.</p>
    pub fn checkout_type(&self) -> std::option::Option<&crate::model::CheckoutType> {
        self.checkout_type.as_ref()
    }
    /// <p>Key fingerprint identifying the license.</p>
    pub fn key_fingerprint(&self) -> std::option::Option<&str> {
        self.key_fingerprint.as_deref()
    }
    /// <p>License entitlements.</p>
    pub fn entitlements(&self) -> std::option::Option<&[crate::model::EntitlementData]> {
        self.entitlements.as_deref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>License beneficiary.</p>
    pub fn beneficiary(&self) -> std::option::Option<&str> {
        self.beneficiary.as_deref()
    }
    /// <p>Node ID.</p>
    pub fn node_id(&self) -> std::option::Option<&str> {
        self.node_id.as_deref()
    }
}
impl std::fmt::Debug for CheckoutLicenseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CheckoutLicenseInput");
        formatter.field("product_sku", &self.product_sku);
        formatter.field("checkout_type", &self.checkout_type);
        formatter.field("key_fingerprint", &self.key_fingerprint);
        formatter.field("entitlements", &self.entitlements);
        formatter.field("client_token", &self.client_token);
        formatter.field("beneficiary", &self.beneficiary);
        formatter.field("node_id", &self.node_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CheckoutBorrowLicenseInput {
    /// <p>Amazon Resource Name (ARN) of the license. The license must use the borrow consumption configuration.</p>
    pub license_arn: std::option::Option<std::string::String>,
    /// <p>License entitlements. Partial checkouts are not supported.</p>
    pub entitlements: std::option::Option<std::vec::Vec<crate::model::EntitlementData>>,
    /// <p>Digital signature method. The possible value is JSON Web Signature (JWS) algorithm PS384. For more information, see <a href="https://tools.ietf.org/html/rfc7518#section-3.5">RFC 7518 Digital Signature with RSASSA-PSS</a>.</p>
    pub digital_signature_method: std::option::Option<crate::model::DigitalSignatureMethod>,
    /// <p>Node ID.</p>
    pub node_id: std::option::Option<std::string::String>,
    /// <p>Information about constraints.</p>
    pub checkout_metadata: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CheckoutBorrowLicenseInput {
    /// <p>Amazon Resource Name (ARN) of the license. The license must use the borrow consumption configuration.</p>
    pub fn license_arn(&self) -> std::option::Option<&str> {
        self.license_arn.as_deref()
    }
    /// <p>License entitlements. Partial checkouts are not supported.</p>
    pub fn entitlements(&self) -> std::option::Option<&[crate::model::EntitlementData]> {
        self.entitlements.as_deref()
    }
    /// <p>Digital signature method. The possible value is JSON Web Signature (JWS) algorithm PS384. For more information, see <a href="https://tools.ietf.org/html/rfc7518#section-3.5">RFC 7518 Digital Signature with RSASSA-PSS</a>.</p>
    pub fn digital_signature_method(
        &self,
    ) -> std::option::Option<&crate::model::DigitalSignatureMethod> {
        self.digital_signature_method.as_ref()
    }
    /// <p>Node ID.</p>
    pub fn node_id(&self) -> std::option::Option<&str> {
        self.node_id.as_deref()
    }
    /// <p>Information about constraints.</p>
    pub fn checkout_metadata(&self) -> std::option::Option<&[crate::model::Metadata]> {
        self.checkout_metadata.as_deref()
    }
    /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CheckoutBorrowLicenseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CheckoutBorrowLicenseInput");
        formatter.field("license_arn", &self.license_arn);
        formatter.field("entitlements", &self.entitlements);
        formatter.field("digital_signature_method", &self.digital_signature_method);
        formatter.field("node_id", &self.node_id);
        formatter.field("checkout_metadata", &self.checkout_metadata);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CheckInLicenseInput {
    /// <p>License consumption token.</p>
    pub license_consumption_token: std::option::Option<std::string::String>,
    /// <p>License beneficiary.</p>
    pub beneficiary: std::option::Option<std::string::String>,
}
impl CheckInLicenseInput {
    /// <p>License consumption token.</p>
    pub fn license_consumption_token(&self) -> std::option::Option<&str> {
        self.license_consumption_token.as_deref()
    }
    /// <p>License beneficiary.</p>
    pub fn beneficiary(&self) -> std::option::Option<&str> {
        self.beneficiary.as_deref()
    }
}
impl std::fmt::Debug for CheckInLicenseInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CheckInLicenseInput");
        formatter.field("license_consumption_token", &self.license_consumption_token);
        formatter.field("beneficiary", &self.beneficiary);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptGrantInput {
    /// <p>Amazon Resource Name (ARN) of the grant.</p>
    pub grant_arn: std::option::Option<std::string::String>,
}
impl AcceptGrantInput {
    /// <p>Amazon Resource Name (ARN) of the grant.</p>
    pub fn grant_arn(&self) -> std::option::Option<&str> {
        self.grant_arn.as_deref()
    }
}
impl std::fmt::Debug for AcceptGrantInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptGrantInput");
        formatter.field("grant_arn", &self.grant_arn);
        formatter.finish()
    }
}
