// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS License Manager
///
/// Client for invoking operations on AWS License Manager. Each operation on AWS License Manager is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_licensemanager::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_licensemanager::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_licensemanager::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`AcceptGrant`](crate::client::fluent_builders::AcceptGrant) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`grant_arn(impl Into<String>)`](crate::client::fluent_builders::AcceptGrant::grant_arn) / [`set_grant_arn(Option<String>)`](crate::client::fluent_builders::AcceptGrant::set_grant_arn): <p>Amazon Resource Name (ARN) of the grant.</p>
    /// - On success, responds with [`AcceptGrantOutput`](crate::output::AcceptGrantOutput) with field(s):
    ///   - [`grant_arn(Option<String>)`](crate::output::AcceptGrantOutput::grant_arn): <p>Grant ARN.</p>
    ///   - [`status(Option<GrantStatus>)`](crate::output::AcceptGrantOutput::status): <p>Grant status.</p>
    ///   - [`version(Option<String>)`](crate::output::AcceptGrantOutput::version): <p>Grant version.</p>
    /// - On failure, responds with [`SdkError<AcceptGrantError>`](crate::error::AcceptGrantError)
    pub fn accept_grant(&self) -> fluent_builders::AcceptGrant<C, M, R> {
        fluent_builders::AcceptGrant::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CheckInLicense`](crate::client::fluent_builders::CheckInLicense) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`license_consumption_token(impl Into<String>)`](crate::client::fluent_builders::CheckInLicense::license_consumption_token) / [`set_license_consumption_token(Option<String>)`](crate::client::fluent_builders::CheckInLicense::set_license_consumption_token): <p>License consumption token.</p>
    ///   - [`beneficiary(impl Into<String>)`](crate::client::fluent_builders::CheckInLicense::beneficiary) / [`set_beneficiary(Option<String>)`](crate::client::fluent_builders::CheckInLicense::set_beneficiary): <p>License beneficiary.</p>
    /// - On success, responds with [`CheckInLicenseOutput`](crate::output::CheckInLicenseOutput)

    /// - On failure, responds with [`SdkError<CheckInLicenseError>`](crate::error::CheckInLicenseError)
    pub fn check_in_license(&self) -> fluent_builders::CheckInLicense<C, M, R> {
        fluent_builders::CheckInLicense::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CheckoutBorrowLicense`](crate::client::fluent_builders::CheckoutBorrowLicense) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`license_arn(impl Into<String>)`](crate::client::fluent_builders::CheckoutBorrowLicense::license_arn) / [`set_license_arn(Option<String>)`](crate::client::fluent_builders::CheckoutBorrowLicense::set_license_arn): <p>Amazon Resource Name (ARN) of the license. The license must use the borrow consumption configuration.</p>
    ///   - [`entitlements(Vec<EntitlementData>)`](crate::client::fluent_builders::CheckoutBorrowLicense::entitlements) / [`set_entitlements(Option<Vec<EntitlementData>>)`](crate::client::fluent_builders::CheckoutBorrowLicense::set_entitlements): <p>License entitlements. Partial checkouts are not supported.</p>
    ///   - [`digital_signature_method(DigitalSignatureMethod)`](crate::client::fluent_builders::CheckoutBorrowLicense::digital_signature_method) / [`set_digital_signature_method(Option<DigitalSignatureMethod>)`](crate::client::fluent_builders::CheckoutBorrowLicense::set_digital_signature_method): <p>Digital signature method. The possible value is JSON Web Signature (JWS) algorithm PS384. For more information, see <a href="https://tools.ietf.org/html/rfc7518#section-3.5">RFC 7518 Digital Signature with RSASSA-PSS</a>.</p>
    ///   - [`node_id(impl Into<String>)`](crate::client::fluent_builders::CheckoutBorrowLicense::node_id) / [`set_node_id(Option<String>)`](crate::client::fluent_builders::CheckoutBorrowLicense::set_node_id): <p>Node ID.</p>
    ///   - [`checkout_metadata(Vec<Metadata>)`](crate::client::fluent_builders::CheckoutBorrowLicense::checkout_metadata) / [`set_checkout_metadata(Option<Vec<Metadata>>)`](crate::client::fluent_builders::CheckoutBorrowLicense::set_checkout_metadata): <p>Information about constraints.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CheckoutBorrowLicense::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CheckoutBorrowLicense::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    /// - On success, responds with [`CheckoutBorrowLicenseOutput`](crate::output::CheckoutBorrowLicenseOutput) with field(s):
    ///   - [`license_arn(Option<String>)`](crate::output::CheckoutBorrowLicenseOutput::license_arn): <p>Amazon Resource Name (ARN) of the license.</p>
    ///   - [`license_consumption_token(Option<String>)`](crate::output::CheckoutBorrowLicenseOutput::license_consumption_token): <p>License consumption token.</p>
    ///   - [`entitlements_allowed(Option<Vec<EntitlementData>>)`](crate::output::CheckoutBorrowLicenseOutput::entitlements_allowed): <p>Allowed license entitlements.</p>
    ///   - [`node_id(Option<String>)`](crate::output::CheckoutBorrowLicenseOutput::node_id): <p>Node ID.</p>
    ///   - [`signed_token(Option<String>)`](crate::output::CheckoutBorrowLicenseOutput::signed_token): <p>Signed token.</p>
    ///   - [`issued_at(Option<String>)`](crate::output::CheckoutBorrowLicenseOutput::issued_at): <p>Date and time at which the license checkout is issued.</p>
    ///   - [`expiration(Option<String>)`](crate::output::CheckoutBorrowLicenseOutput::expiration): <p>Date and time at which the license checkout expires.</p>
    ///   - [`checkout_metadata(Option<Vec<Metadata>>)`](crate::output::CheckoutBorrowLicenseOutput::checkout_metadata): <p>Information about constraints.</p>
    /// - On failure, responds with [`SdkError<CheckoutBorrowLicenseError>`](crate::error::CheckoutBorrowLicenseError)
    pub fn checkout_borrow_license(&self) -> fluent_builders::CheckoutBorrowLicense<C, M, R> {
        fluent_builders::CheckoutBorrowLicense::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CheckoutLicense`](crate::client::fluent_builders::CheckoutLicense) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`product_sku(impl Into<String>)`](crate::client::fluent_builders::CheckoutLicense::product_sku) / [`set_product_sku(Option<String>)`](crate::client::fluent_builders::CheckoutLicense::set_product_sku): <p>Product SKU.</p>
    ///   - [`checkout_type(CheckoutType)`](crate::client::fluent_builders::CheckoutLicense::checkout_type) / [`set_checkout_type(Option<CheckoutType>)`](crate::client::fluent_builders::CheckoutLicense::set_checkout_type): <p>Checkout type.</p>
    ///   - [`key_fingerprint(impl Into<String>)`](crate::client::fluent_builders::CheckoutLicense::key_fingerprint) / [`set_key_fingerprint(Option<String>)`](crate::client::fluent_builders::CheckoutLicense::set_key_fingerprint): <p>Key fingerprint identifying the license.</p>
    ///   - [`entitlements(Vec<EntitlementData>)`](crate::client::fluent_builders::CheckoutLicense::entitlements) / [`set_entitlements(Option<Vec<EntitlementData>>)`](crate::client::fluent_builders::CheckoutLicense::set_entitlements): <p>License entitlements.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CheckoutLicense::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CheckoutLicense::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    ///   - [`beneficiary(impl Into<String>)`](crate::client::fluent_builders::CheckoutLicense::beneficiary) / [`set_beneficiary(Option<String>)`](crate::client::fluent_builders::CheckoutLicense::set_beneficiary): <p>License beneficiary.</p>
    ///   - [`node_id(impl Into<String>)`](crate::client::fluent_builders::CheckoutLicense::node_id) / [`set_node_id(Option<String>)`](crate::client::fluent_builders::CheckoutLicense::set_node_id): <p>Node ID.</p>
    /// - On success, responds with [`CheckoutLicenseOutput`](crate::output::CheckoutLicenseOutput) with field(s):
    ///   - [`checkout_type(Option<CheckoutType>)`](crate::output::CheckoutLicenseOutput::checkout_type): <p>Checkout type.</p>
    ///   - [`license_consumption_token(Option<String>)`](crate::output::CheckoutLicenseOutput::license_consumption_token): <p>License consumption token.</p>
    ///   - [`entitlements_allowed(Option<Vec<EntitlementData>>)`](crate::output::CheckoutLicenseOutput::entitlements_allowed): <p>Allowed license entitlements.</p>
    ///   - [`signed_token(Option<String>)`](crate::output::CheckoutLicenseOutput::signed_token): <p>Signed token.</p>
    ///   - [`node_id(Option<String>)`](crate::output::CheckoutLicenseOutput::node_id): <p>Node ID.</p>
    ///   - [`issued_at(Option<String>)`](crate::output::CheckoutLicenseOutput::issued_at): <p>Date and time at which the license checkout is issued.</p>
    ///   - [`expiration(Option<String>)`](crate::output::CheckoutLicenseOutput::expiration): <p>Date and time at which the license checkout expires.</p>
    ///   - [`license_arn(Option<String>)`](crate::output::CheckoutLicenseOutput::license_arn): <p>Amazon Resource Name (ARN) of the checkout license.</p>
    /// - On failure, responds with [`SdkError<CheckoutLicenseError>`](crate::error::CheckoutLicenseError)
    pub fn checkout_license(&self) -> fluent_builders::CheckoutLicense<C, M, R> {
        fluent_builders::CheckoutLicense::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateGrant`](crate::client::fluent_builders::CreateGrant) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateGrant::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateGrant::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    ///   - [`grant_name(impl Into<String>)`](crate::client::fluent_builders::CreateGrant::grant_name) / [`set_grant_name(Option<String>)`](crate::client::fluent_builders::CreateGrant::set_grant_name): <p>Grant name.</p>
    ///   - [`license_arn(impl Into<String>)`](crate::client::fluent_builders::CreateGrant::license_arn) / [`set_license_arn(Option<String>)`](crate::client::fluent_builders::CreateGrant::set_license_arn): <p>Amazon Resource Name (ARN) of the license.</p>
    ///   - [`principals(Vec<String>)`](crate::client::fluent_builders::CreateGrant::principals) / [`set_principals(Option<Vec<String>>)`](crate::client::fluent_builders::CreateGrant::set_principals): <p>The grant principals.</p>
    ///   - [`home_region(impl Into<String>)`](crate::client::fluent_builders::CreateGrant::home_region) / [`set_home_region(Option<String>)`](crate::client::fluent_builders::CreateGrant::set_home_region): <p>Home Region of the grant.</p>
    ///   - [`allowed_operations(Vec<AllowedOperation>)`](crate::client::fluent_builders::CreateGrant::allowed_operations) / [`set_allowed_operations(Option<Vec<AllowedOperation>>)`](crate::client::fluent_builders::CreateGrant::set_allowed_operations): <p>Allowed operations for the grant.</p>
    /// - On success, responds with [`CreateGrantOutput`](crate::output::CreateGrantOutput) with field(s):
    ///   - [`grant_arn(Option<String>)`](crate::output::CreateGrantOutput::grant_arn): <p>Grant ARN.</p>
    ///   - [`status(Option<GrantStatus>)`](crate::output::CreateGrantOutput::status): <p>Grant status.</p>
    ///   - [`version(Option<String>)`](crate::output::CreateGrantOutput::version): <p>Grant version.</p>
    /// - On failure, responds with [`SdkError<CreateGrantError>`](crate::error::CreateGrantError)
    pub fn create_grant(&self) -> fluent_builders::CreateGrant<C, M, R> {
        fluent_builders::CreateGrant::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateGrantVersion`](crate::client::fluent_builders::CreateGrantVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateGrantVersion::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateGrantVersion::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    ///   - [`grant_arn(impl Into<String>)`](crate::client::fluent_builders::CreateGrantVersion::grant_arn) / [`set_grant_arn(Option<String>)`](crate::client::fluent_builders::CreateGrantVersion::set_grant_arn): <p>Amazon Resource Name (ARN) of the grant.</p>
    ///   - [`grant_name(impl Into<String>)`](crate::client::fluent_builders::CreateGrantVersion::grant_name) / [`set_grant_name(Option<String>)`](crate::client::fluent_builders::CreateGrantVersion::set_grant_name): <p>Grant name.</p>
    ///   - [`allowed_operations(Vec<AllowedOperation>)`](crate::client::fluent_builders::CreateGrantVersion::allowed_operations) / [`set_allowed_operations(Option<Vec<AllowedOperation>>)`](crate::client::fluent_builders::CreateGrantVersion::set_allowed_operations): <p>Allowed operations for the grant.</p>
    ///   - [`status(GrantStatus)`](crate::client::fluent_builders::CreateGrantVersion::status) / [`set_status(Option<GrantStatus>)`](crate::client::fluent_builders::CreateGrantVersion::set_status): <p>Grant status.</p>
    ///   - [`status_reason(impl Into<String>)`](crate::client::fluent_builders::CreateGrantVersion::status_reason) / [`set_status_reason(Option<String>)`](crate::client::fluent_builders::CreateGrantVersion::set_status_reason): <p>Grant status reason.</p>
    ///   - [`source_version(impl Into<String>)`](crate::client::fluent_builders::CreateGrantVersion::source_version) / [`set_source_version(Option<String>)`](crate::client::fluent_builders::CreateGrantVersion::set_source_version): <p>Current version of the grant.</p>
    /// - On success, responds with [`CreateGrantVersionOutput`](crate::output::CreateGrantVersionOutput) with field(s):
    ///   - [`grant_arn(Option<String>)`](crate::output::CreateGrantVersionOutput::grant_arn): <p>Grant ARN.</p>
    ///   - [`status(Option<GrantStatus>)`](crate::output::CreateGrantVersionOutput::status): <p>Grant status.</p>
    ///   - [`version(Option<String>)`](crate::output::CreateGrantVersionOutput::version): <p>New version of the grant.</p>
    /// - On failure, responds with [`SdkError<CreateGrantVersionError>`](crate::error::CreateGrantVersionError)
    pub fn create_grant_version(&self) -> fluent_builders::CreateGrantVersion<C, M, R> {
        fluent_builders::CreateGrantVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLicense`](crate::client::fluent_builders::CreateLicense) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`license_name(impl Into<String>)`](crate::client::fluent_builders::CreateLicense::license_name) / [`set_license_name(Option<String>)`](crate::client::fluent_builders::CreateLicense::set_license_name): <p>License name.</p>
    ///   - [`product_name(impl Into<String>)`](crate::client::fluent_builders::CreateLicense::product_name) / [`set_product_name(Option<String>)`](crate::client::fluent_builders::CreateLicense::set_product_name): <p>Product name.</p>
    ///   - [`product_sku(impl Into<String>)`](crate::client::fluent_builders::CreateLicense::product_sku) / [`set_product_sku(Option<String>)`](crate::client::fluent_builders::CreateLicense::set_product_sku): <p>Product SKU.</p>
    ///   - [`issuer(Issuer)`](crate::client::fluent_builders::CreateLicense::issuer) / [`set_issuer(Option<Issuer>)`](crate::client::fluent_builders::CreateLicense::set_issuer): <p>License issuer.</p>
    ///   - [`home_region(impl Into<String>)`](crate::client::fluent_builders::CreateLicense::home_region) / [`set_home_region(Option<String>)`](crate::client::fluent_builders::CreateLicense::set_home_region): <p>Home Region for the license.</p>
    ///   - [`validity(DatetimeRange)`](crate::client::fluent_builders::CreateLicense::validity) / [`set_validity(Option<DatetimeRange>)`](crate::client::fluent_builders::CreateLicense::set_validity): <p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>
    ///   - [`entitlements(Vec<Entitlement>)`](crate::client::fluent_builders::CreateLicense::entitlements) / [`set_entitlements(Option<Vec<Entitlement>>)`](crate::client::fluent_builders::CreateLicense::set_entitlements): <p>License entitlements.</p>
    ///   - [`beneficiary(impl Into<String>)`](crate::client::fluent_builders::CreateLicense::beneficiary) / [`set_beneficiary(Option<String>)`](crate::client::fluent_builders::CreateLicense::set_beneficiary): <p>License beneficiary.</p>
    ///   - [`consumption_configuration(ConsumptionConfiguration)`](crate::client::fluent_builders::CreateLicense::consumption_configuration) / [`set_consumption_configuration(Option<ConsumptionConfiguration>)`](crate::client::fluent_builders::CreateLicense::set_consumption_configuration): <p>Configuration for consumption of the license. Choose a provisional configuration for workloads running with continuous connectivity. Choose a borrow configuration for workloads with offline usage.</p>
    ///   - [`license_metadata(Vec<Metadata>)`](crate::client::fluent_builders::CreateLicense::license_metadata) / [`set_license_metadata(Option<Vec<Metadata>>)`](crate::client::fluent_builders::CreateLicense::set_license_metadata): <p>Information about the license.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateLicense::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateLicense::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    /// - On success, responds with [`CreateLicenseOutput`](crate::output::CreateLicenseOutput) with field(s):
    ///   - [`license_arn(Option<String>)`](crate::output::CreateLicenseOutput::license_arn): <p>Amazon Resource Name (ARN) of the license.</p>
    ///   - [`status(Option<LicenseStatus>)`](crate::output::CreateLicenseOutput::status): <p>License status.</p>
    ///   - [`version(Option<String>)`](crate::output::CreateLicenseOutput::version): <p>License version.</p>
    /// - On failure, responds with [`SdkError<CreateLicenseError>`](crate::error::CreateLicenseError)
    pub fn create_license(&self) -> fluent_builders::CreateLicense<C, M, R> {
        fluent_builders::CreateLicense::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLicenseConfiguration`](crate::client::fluent_builders::CreateLicenseConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateLicenseConfiguration::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateLicenseConfiguration::set_name): <p>Name of the license configuration.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateLicenseConfiguration::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateLicenseConfiguration::set_description): <p>Description of the license configuration.</p>
    ///   - [`license_counting_type(LicenseCountingType)`](crate::client::fluent_builders::CreateLicenseConfiguration::license_counting_type) / [`set_license_counting_type(Option<LicenseCountingType>)`](crate::client::fluent_builders::CreateLicenseConfiguration::set_license_counting_type): <p>Dimension used to track the license inventory.</p>
    ///   - [`license_count(i64)`](crate::client::fluent_builders::CreateLicenseConfiguration::license_count) / [`set_license_count(Option<i64>)`](crate::client::fluent_builders::CreateLicenseConfiguration::set_license_count): <p>Number of licenses managed by the license configuration.</p>
    ///   - [`license_count_hard_limit(bool)`](crate::client::fluent_builders::CreateLicenseConfiguration::license_count_hard_limit) / [`set_license_count_hard_limit(Option<bool>)`](crate::client::fluent_builders::CreateLicenseConfiguration::set_license_count_hard_limit): <p>Indicates whether hard or soft license enforcement is used. Exceeding a hard limit blocks the launch of new instances.</p>
    ///   - [`license_rules(Vec<String>)`](crate::client::fluent_builders::CreateLicenseConfiguration::license_rules) / [`set_license_rules(Option<Vec<String>>)`](crate::client::fluent_builders::CreateLicenseConfiguration::set_license_rules): <p>License rules. The syntax is #name=value (for example, #allowedTenancy=EC2-DedicatedHost). The available rules vary by dimension, as follows.</p>  <ul>   <li> <p> <code>Cores</code> dimension: <code>allowedTenancy</code> | <code>licenseAffinityToHost</code> | <code>maximumCores</code> | <code>minimumCores</code> </p> </li>   <li> <p> <code>Instances</code> dimension: <code>allowedTenancy</code> | <code>maximumCores</code> | <code>minimumCores</code> | <code>maximumSockets</code> | <code>minimumSockets</code> | <code>maximumVcpus</code> | <code>minimumVcpus</code> </p> </li>   <li> <p> <code>Sockets</code> dimension: <code>allowedTenancy</code> | <code>licenseAffinityToHost</code> | <code>maximumSockets</code> | <code>minimumSockets</code> </p> </li>   <li> <p> <code>vCPUs</code> dimension: <code>allowedTenancy</code> | <code>honorVcpuOptimization</code> | <code>maximumVcpus</code> | <code>minimumVcpus</code> </p> </li>  </ul>  <p>The unit for <code>licenseAffinityToHost</code> is days and the range is 1 to 180. The possible values for <code>allowedTenancy</code> are <code>EC2-Default</code>, <code>EC2-DedicatedHost</code>, and <code>EC2-DedicatedInstance</code>. The possible values for <code>honorVcpuOptimization</code> are <code>True</code> and <code>False</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateLicenseConfiguration::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateLicenseConfiguration::set_tags): <p>Tags to add to the license configuration.</p>
    ///   - [`disassociate_when_not_found(bool)`](crate::client::fluent_builders::CreateLicenseConfiguration::disassociate_when_not_found) / [`set_disassociate_when_not_found(Option<bool>)`](crate::client::fluent_builders::CreateLicenseConfiguration::set_disassociate_when_not_found): <p>When true, disassociates a resource when software is uninstalled.</p>
    ///   - [`product_information_list(Vec<ProductInformation>)`](crate::client::fluent_builders::CreateLicenseConfiguration::product_information_list) / [`set_product_information_list(Option<Vec<ProductInformation>>)`](crate::client::fluent_builders::CreateLicenseConfiguration::set_product_information_list): <p>Product information.</p>
    /// - On success, responds with [`CreateLicenseConfigurationOutput`](crate::output::CreateLicenseConfigurationOutput) with field(s):
    ///   - [`license_configuration_arn(Option<String>)`](crate::output::CreateLicenseConfigurationOutput::license_configuration_arn): <p>Amazon Resource Name (ARN) of the license configuration.</p>
    /// - On failure, responds with [`SdkError<CreateLicenseConfigurationError>`](crate::error::CreateLicenseConfigurationError)
    pub fn create_license_configuration(
        &self,
    ) -> fluent_builders::CreateLicenseConfiguration<C, M, R> {
        fluent_builders::CreateLicenseConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLicenseConversionTaskForResource`](crate::client::fluent_builders::CreateLicenseConversionTaskForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::CreateLicenseConversionTaskForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::CreateLicenseConversionTaskForResource::set_resource_arn): <p>Amazon Resource Name (ARN) of the resource you are converting the license type for.</p>
    ///   - [`source_license_context(LicenseConversionContext)`](crate::client::fluent_builders::CreateLicenseConversionTaskForResource::source_license_context) / [`set_source_license_context(Option<LicenseConversionContext>)`](crate::client::fluent_builders::CreateLicenseConversionTaskForResource::set_source_license_context): <p>Information that identifies the license type you are converting from. For the structure of the source license, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli">Convert a license type using the AWS CLI</a> in the <i>License Manager User Guide</i>.</p>
    ///   - [`destination_license_context(LicenseConversionContext)`](crate::client::fluent_builders::CreateLicenseConversionTaskForResource::destination_license_context) / [`set_destination_license_context(Option<LicenseConversionContext>)`](crate::client::fluent_builders::CreateLicenseConversionTaskForResource::set_destination_license_context): <p>Information that identifies the license type you are converting to. For the structure of the destination license, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli">Convert a license type using the AWS CLI</a> in the <i>License Manager User Guide</i>.</p>
    /// - On success, responds with [`CreateLicenseConversionTaskForResourceOutput`](crate::output::CreateLicenseConversionTaskForResourceOutput) with field(s):
    ///   - [`license_conversion_task_id(Option<String>)`](crate::output::CreateLicenseConversionTaskForResourceOutput::license_conversion_task_id): <p>The ID of the created license type conversion task.</p>
    /// - On failure, responds with [`SdkError<CreateLicenseConversionTaskForResourceError>`](crate::error::CreateLicenseConversionTaskForResourceError)
    pub fn create_license_conversion_task_for_resource(
        &self,
    ) -> fluent_builders::CreateLicenseConversionTaskForResource<C, M, R> {
        fluent_builders::CreateLicenseConversionTaskForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLicenseManagerReportGenerator`](crate::client::fluent_builders::CreateLicenseManagerReportGenerator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`report_generator_name(impl Into<String>)`](crate::client::fluent_builders::CreateLicenseManagerReportGenerator::report_generator_name) / [`set_report_generator_name(Option<String>)`](crate::client::fluent_builders::CreateLicenseManagerReportGenerator::set_report_generator_name): <p>Name of the report generator.</p>
    ///   - [`r#type(Vec<ReportType>)`](crate::client::fluent_builders::CreateLicenseManagerReportGenerator::r#type) / [`set_type(Option<Vec<ReportType>>)`](crate::client::fluent_builders::CreateLicenseManagerReportGenerator::set_type): <p>Type of reports to generate. The following report types an be generated:</p>  <ul>   <li> <p>License configuration report - Reports the number and details of consumed licenses for a license configuration.</p> </li>   <li> <p>Resource report - Reports the tracked licenses and resource consumption for a license configuration.</p> </li>  </ul>
    ///   - [`report_context(ReportContext)`](crate::client::fluent_builders::CreateLicenseManagerReportGenerator::report_context) / [`set_report_context(Option<ReportContext>)`](crate::client::fluent_builders::CreateLicenseManagerReportGenerator::set_report_context): <p>Defines the type of license configuration the report generator tracks.</p>
    ///   - [`report_frequency(ReportFrequency)`](crate::client::fluent_builders::CreateLicenseManagerReportGenerator::report_frequency) / [`set_report_frequency(Option<ReportFrequency>)`](crate::client::fluent_builders::CreateLicenseManagerReportGenerator::set_report_frequency): <p>Frequency by which reports are generated. Reports can be generated daily, monthly, or weekly.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateLicenseManagerReportGenerator::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateLicenseManagerReportGenerator::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateLicenseManagerReportGenerator::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateLicenseManagerReportGenerator::set_description): <p>Description of the report generator.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateLicenseManagerReportGenerator::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateLicenseManagerReportGenerator::set_tags): <p>Tags to add to the report generator.</p>
    /// - On success, responds with [`CreateLicenseManagerReportGeneratorOutput`](crate::output::CreateLicenseManagerReportGeneratorOutput) with field(s):
    ///   - [`license_manager_report_generator_arn(Option<String>)`](crate::output::CreateLicenseManagerReportGeneratorOutput::license_manager_report_generator_arn): <p>The Amazon Resource Name (ARN) of the new report generator.</p>
    /// - On failure, responds with [`SdkError<CreateLicenseManagerReportGeneratorError>`](crate::error::CreateLicenseManagerReportGeneratorError)
    pub fn create_license_manager_report_generator(
        &self,
    ) -> fluent_builders::CreateLicenseManagerReportGenerator<C, M, R> {
        fluent_builders::CreateLicenseManagerReportGenerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateLicenseVersion`](crate::client::fluent_builders::CreateLicenseVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`license_arn(impl Into<String>)`](crate::client::fluent_builders::CreateLicenseVersion::license_arn) / [`set_license_arn(Option<String>)`](crate::client::fluent_builders::CreateLicenseVersion::set_license_arn): <p>Amazon Resource Name (ARN) of the license.</p>
    ///   - [`license_name(impl Into<String>)`](crate::client::fluent_builders::CreateLicenseVersion::license_name) / [`set_license_name(Option<String>)`](crate::client::fluent_builders::CreateLicenseVersion::set_license_name): <p>License name.</p>
    ///   - [`product_name(impl Into<String>)`](crate::client::fluent_builders::CreateLicenseVersion::product_name) / [`set_product_name(Option<String>)`](crate::client::fluent_builders::CreateLicenseVersion::set_product_name): <p>Product name.</p>
    ///   - [`issuer(Issuer)`](crate::client::fluent_builders::CreateLicenseVersion::issuer) / [`set_issuer(Option<Issuer>)`](crate::client::fluent_builders::CreateLicenseVersion::set_issuer): <p>License issuer.</p>
    ///   - [`home_region(impl Into<String>)`](crate::client::fluent_builders::CreateLicenseVersion::home_region) / [`set_home_region(Option<String>)`](crate::client::fluent_builders::CreateLicenseVersion::set_home_region): <p>Home Region of the license.</p>
    ///   - [`validity(DatetimeRange)`](crate::client::fluent_builders::CreateLicenseVersion::validity) / [`set_validity(Option<DatetimeRange>)`](crate::client::fluent_builders::CreateLicenseVersion::set_validity): <p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>
    ///   - [`license_metadata(Vec<Metadata>)`](crate::client::fluent_builders::CreateLicenseVersion::license_metadata) / [`set_license_metadata(Option<Vec<Metadata>>)`](crate::client::fluent_builders::CreateLicenseVersion::set_license_metadata): <p>Information about the license.</p>
    ///   - [`entitlements(Vec<Entitlement>)`](crate::client::fluent_builders::CreateLicenseVersion::entitlements) / [`set_entitlements(Option<Vec<Entitlement>>)`](crate::client::fluent_builders::CreateLicenseVersion::set_entitlements): <p>License entitlements.</p>
    ///   - [`consumption_configuration(ConsumptionConfiguration)`](crate::client::fluent_builders::CreateLicenseVersion::consumption_configuration) / [`set_consumption_configuration(Option<ConsumptionConfiguration>)`](crate::client::fluent_builders::CreateLicenseVersion::set_consumption_configuration): <p>Configuration for consumption of the license. Choose a provisional configuration for workloads running with continuous connectivity. Choose a borrow configuration for workloads with offline usage.</p>
    ///   - [`status(LicenseStatus)`](crate::client::fluent_builders::CreateLicenseVersion::status) / [`set_status(Option<LicenseStatus>)`](crate::client::fluent_builders::CreateLicenseVersion::set_status): <p>License status.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateLicenseVersion::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateLicenseVersion::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    ///   - [`source_version(impl Into<String>)`](crate::client::fluent_builders::CreateLicenseVersion::source_version) / [`set_source_version(Option<String>)`](crate::client::fluent_builders::CreateLicenseVersion::set_source_version): <p>Current version of the license.</p>
    /// - On success, responds with [`CreateLicenseVersionOutput`](crate::output::CreateLicenseVersionOutput) with field(s):
    ///   - [`license_arn(Option<String>)`](crate::output::CreateLicenseVersionOutput::license_arn): <p>License ARN.</p>
    ///   - [`version(Option<String>)`](crate::output::CreateLicenseVersionOutput::version): <p>New version of the license.</p>
    ///   - [`status(Option<LicenseStatus>)`](crate::output::CreateLicenseVersionOutput::status): <p>License status.</p>
    /// - On failure, responds with [`SdkError<CreateLicenseVersionError>`](crate::error::CreateLicenseVersionError)
    pub fn create_license_version(&self) -> fluent_builders::CreateLicenseVersion<C, M, R> {
        fluent_builders::CreateLicenseVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateToken`](crate::client::fluent_builders::CreateToken) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`license_arn(impl Into<String>)`](crate::client::fluent_builders::CreateToken::license_arn) / [`set_license_arn(Option<String>)`](crate::client::fluent_builders::CreateToken::set_license_arn): <p>Amazon Resource Name (ARN) of the license. The ARN is mapped to the aud claim of the JWT token.</p>
    ///   - [`role_arns(Vec<String>)`](crate::client::fluent_builders::CreateToken::role_arns) / [`set_role_arns(Option<Vec<String>>)`](crate::client::fluent_builders::CreateToken::set_role_arns): <p>Amazon Resource Name (ARN) of the IAM roles to embed in the token. License Manager does not check whether the roles are in use.</p>
    ///   - [`expiration_in_days(i32)`](crate::client::fluent_builders::CreateToken::expiration_in_days) / [`set_expiration_in_days(Option<i32>)`](crate::client::fluent_builders::CreateToken::set_expiration_in_days): <p>Token expiration, in days, counted from token creation. The default is 365 days.</p>
    ///   - [`token_properties(Vec<String>)`](crate::client::fluent_builders::CreateToken::token_properties) / [`set_token_properties(Option<Vec<String>>)`](crate::client::fluent_builders::CreateToken::set_token_properties): <p>Data specified by the caller to be included in the JWT token. The data is mapped to the amr claim of the JWT token.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateToken::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateToken::set_client_token): <p>Idempotency token, valid for 10 minutes.</p>
    /// - On success, responds with [`CreateTokenOutput`](crate::output::CreateTokenOutput) with field(s):
    ///   - [`token_id(Option<String>)`](crate::output::CreateTokenOutput::token_id): <p>Token ID.</p>
    ///   - [`token_type(Option<TokenType>)`](crate::output::CreateTokenOutput::token_type): <p>Token type.</p>
    ///   - [`token(Option<String>)`](crate::output::CreateTokenOutput::token): <p>Refresh token, encoded as a JWT token.</p>
    /// - On failure, responds with [`SdkError<CreateTokenError>`](crate::error::CreateTokenError)
    pub fn create_token(&self) -> fluent_builders::CreateToken<C, M, R> {
        fluent_builders::CreateToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteGrant`](crate::client::fluent_builders::DeleteGrant) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`grant_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteGrant::grant_arn) / [`set_grant_arn(Option<String>)`](crate::client::fluent_builders::DeleteGrant::set_grant_arn): <p>Amazon Resource Name (ARN) of the grant.</p>
    ///   - [`status_reason(impl Into<String>)`](crate::client::fluent_builders::DeleteGrant::status_reason) / [`set_status_reason(Option<String>)`](crate::client::fluent_builders::DeleteGrant::set_status_reason): <p>The Status reason for the delete request.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::DeleteGrant::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::DeleteGrant::set_version): <p>Current version of the grant.</p>
    /// - On success, responds with [`DeleteGrantOutput`](crate::output::DeleteGrantOutput) with field(s):
    ///   - [`grant_arn(Option<String>)`](crate::output::DeleteGrantOutput::grant_arn): <p>Grant ARN.</p>
    ///   - [`status(Option<GrantStatus>)`](crate::output::DeleteGrantOutput::status): <p>Grant status.</p>
    ///   - [`version(Option<String>)`](crate::output::DeleteGrantOutput::version): <p>Grant version.</p>
    /// - On failure, responds with [`SdkError<DeleteGrantError>`](crate::error::DeleteGrantError)
    pub fn delete_grant(&self) -> fluent_builders::DeleteGrant<C, M, R> {
        fluent_builders::DeleteGrant::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLicense`](crate::client::fluent_builders::DeleteLicense) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`license_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteLicense::license_arn) / [`set_license_arn(Option<String>)`](crate::client::fluent_builders::DeleteLicense::set_license_arn): <p>Amazon Resource Name (ARN) of the license.</p>
    ///   - [`source_version(impl Into<String>)`](crate::client::fluent_builders::DeleteLicense::source_version) / [`set_source_version(Option<String>)`](crate::client::fluent_builders::DeleteLicense::set_source_version): <p>Current version of the license.</p>
    /// - On success, responds with [`DeleteLicenseOutput`](crate::output::DeleteLicenseOutput) with field(s):
    ///   - [`status(Option<LicenseDeletionStatus>)`](crate::output::DeleteLicenseOutput::status): <p>License status.</p>
    ///   - [`deletion_date(Option<String>)`](crate::output::DeleteLicenseOutput::deletion_date): <p>Date when the license is deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteLicenseError>`](crate::error::DeleteLicenseError)
    pub fn delete_license(&self) -> fluent_builders::DeleteLicense<C, M, R> {
        fluent_builders::DeleteLicense::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLicenseConfiguration`](crate::client::fluent_builders::DeleteLicenseConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`license_configuration_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteLicenseConfiguration::license_configuration_arn) / [`set_license_configuration_arn(Option<String>)`](crate::client::fluent_builders::DeleteLicenseConfiguration::set_license_configuration_arn): <p>ID of the license configuration.</p>
    /// - On success, responds with [`DeleteLicenseConfigurationOutput`](crate::output::DeleteLicenseConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeleteLicenseConfigurationError>`](crate::error::DeleteLicenseConfigurationError)
    pub fn delete_license_configuration(
        &self,
    ) -> fluent_builders::DeleteLicenseConfiguration<C, M, R> {
        fluent_builders::DeleteLicenseConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteLicenseManagerReportGenerator`](crate::client::fluent_builders::DeleteLicenseManagerReportGenerator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`license_manager_report_generator_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteLicenseManagerReportGenerator::license_manager_report_generator_arn) / [`set_license_manager_report_generator_arn(Option<String>)`](crate::client::fluent_builders::DeleteLicenseManagerReportGenerator::set_license_manager_report_generator_arn): <p>Amazon Resource Name (ARN) of the report generator to be deleted.</p>
    /// - On success, responds with [`DeleteLicenseManagerReportGeneratorOutput`](crate::output::DeleteLicenseManagerReportGeneratorOutput)

    /// - On failure, responds with [`SdkError<DeleteLicenseManagerReportGeneratorError>`](crate::error::DeleteLicenseManagerReportGeneratorError)
    pub fn delete_license_manager_report_generator(
        &self,
    ) -> fluent_builders::DeleteLicenseManagerReportGenerator<C, M, R> {
        fluent_builders::DeleteLicenseManagerReportGenerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteToken`](crate::client::fluent_builders::DeleteToken) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`token_id(impl Into<String>)`](crate::client::fluent_builders::DeleteToken::token_id) / [`set_token_id(Option<String>)`](crate::client::fluent_builders::DeleteToken::set_token_id): <p>Token ID.</p>
    /// - On success, responds with [`DeleteTokenOutput`](crate::output::DeleteTokenOutput)

    /// - On failure, responds with [`SdkError<DeleteTokenError>`](crate::error::DeleteTokenError)
    pub fn delete_token(&self) -> fluent_builders::DeleteToken<C, M, R> {
        fluent_builders::DeleteToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ExtendLicenseConsumption`](crate::client::fluent_builders::ExtendLicenseConsumption) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`license_consumption_token(impl Into<String>)`](crate::client::fluent_builders::ExtendLicenseConsumption::license_consumption_token) / [`set_license_consumption_token(Option<String>)`](crate::client::fluent_builders::ExtendLicenseConsumption::set_license_consumption_token): <p>License consumption token.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::ExtendLicenseConsumption::dry_run) / [`set_dry_run(bool)`](crate::client::fluent_builders::ExtendLicenseConsumption::set_dry_run): <p>Checks whether you have the required permissions for the action, without actually making the request. Provides an error response if you do not have the required permissions.</p>
    /// - On success, responds with [`ExtendLicenseConsumptionOutput`](crate::output::ExtendLicenseConsumptionOutput) with field(s):
    ///   - [`license_consumption_token(Option<String>)`](crate::output::ExtendLicenseConsumptionOutput::license_consumption_token): <p>License consumption token.</p>
    ///   - [`expiration(Option<String>)`](crate::output::ExtendLicenseConsumptionOutput::expiration): <p>Date and time at which the license consumption expires.</p>
    /// - On failure, responds with [`SdkError<ExtendLicenseConsumptionError>`](crate::error::ExtendLicenseConsumptionError)
    pub fn extend_license_consumption(&self) -> fluent_builders::ExtendLicenseConsumption<C, M, R> {
        fluent_builders::ExtendLicenseConsumption::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAccessToken`](crate::client::fluent_builders::GetAccessToken) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`token(impl Into<String>)`](crate::client::fluent_builders::GetAccessToken::token) / [`set_token(Option<String>)`](crate::client::fluent_builders::GetAccessToken::set_token): <p>Refresh token, encoded as a JWT token.</p>
    ///   - [`token_properties(Vec<String>)`](crate::client::fluent_builders::GetAccessToken::token_properties) / [`set_token_properties(Option<Vec<String>>)`](crate::client::fluent_builders::GetAccessToken::set_token_properties): <p>Token properties to validate against those present in the JWT token.</p>
    /// - On success, responds with [`GetAccessTokenOutput`](crate::output::GetAccessTokenOutput) with field(s):
    ///   - [`access_token(Option<String>)`](crate::output::GetAccessTokenOutput::access_token): <p>Temporary access token.</p>
    /// - On failure, responds with [`SdkError<GetAccessTokenError>`](crate::error::GetAccessTokenError)
    pub fn get_access_token(&self) -> fluent_builders::GetAccessToken<C, M, R> {
        fluent_builders::GetAccessToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetGrant`](crate::client::fluent_builders::GetGrant) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`grant_arn(impl Into<String>)`](crate::client::fluent_builders::GetGrant::grant_arn) / [`set_grant_arn(Option<String>)`](crate::client::fluent_builders::GetGrant::set_grant_arn): <p>Amazon Resource Name (ARN) of the grant.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::GetGrant::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::GetGrant::set_version): <p>Grant version.</p>
    /// - On success, responds with [`GetGrantOutput`](crate::output::GetGrantOutput) with field(s):
    ///   - [`grant(Option<Grant>)`](crate::output::GetGrantOutput::grant): <p>Grant details.</p>
    /// - On failure, responds with [`SdkError<GetGrantError>`](crate::error::GetGrantError)
    pub fn get_grant(&self) -> fluent_builders::GetGrant<C, M, R> {
        fluent_builders::GetGrant::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLicense`](crate::client::fluent_builders::GetLicense) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`license_arn(impl Into<String>)`](crate::client::fluent_builders::GetLicense::license_arn) / [`set_license_arn(Option<String>)`](crate::client::fluent_builders::GetLicense::set_license_arn): <p>Amazon Resource Name (ARN) of the license.</p>
    ///   - [`version(impl Into<String>)`](crate::client::fluent_builders::GetLicense::version) / [`set_version(Option<String>)`](crate::client::fluent_builders::GetLicense::set_version): <p>License version.</p>
    /// - On success, responds with [`GetLicenseOutput`](crate::output::GetLicenseOutput) with field(s):
    ///   - [`license(Option<License>)`](crate::output::GetLicenseOutput::license): <p>License details.</p>
    /// - On failure, responds with [`SdkError<GetLicenseError>`](crate::error::GetLicenseError)
    pub fn get_license(&self) -> fluent_builders::GetLicense<C, M, R> {
        fluent_builders::GetLicense::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLicenseConfiguration`](crate::client::fluent_builders::GetLicenseConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`license_configuration_arn(impl Into<String>)`](crate::client::fluent_builders::GetLicenseConfiguration::license_configuration_arn) / [`set_license_configuration_arn(Option<String>)`](crate::client::fluent_builders::GetLicenseConfiguration::set_license_configuration_arn): <p>Amazon Resource Name (ARN) of the license configuration.</p>
    /// - On success, responds with [`GetLicenseConfigurationOutput`](crate::output::GetLicenseConfigurationOutput) with field(s):
    ///   - [`license_configuration_id(Option<String>)`](crate::output::GetLicenseConfigurationOutput::license_configuration_id): <p>Unique ID for the license configuration.</p>
    ///   - [`license_configuration_arn(Option<String>)`](crate::output::GetLicenseConfigurationOutput::license_configuration_arn): <p>Amazon Resource Name (ARN) of the license configuration.</p>
    ///   - [`name(Option<String>)`](crate::output::GetLicenseConfigurationOutput::name): <p>Name of the license configuration.</p>
    ///   - [`description(Option<String>)`](crate::output::GetLicenseConfigurationOutput::description): <p>Description of the license configuration.</p>
    ///   - [`license_counting_type(Option<LicenseCountingType>)`](crate::output::GetLicenseConfigurationOutput::license_counting_type): <p>Dimension for which the licenses are counted.</p>
    ///   - [`license_rules(Option<Vec<String>>)`](crate::output::GetLicenseConfigurationOutput::license_rules): <p>License rules.</p>
    ///   - [`license_count(Option<i64>)`](crate::output::GetLicenseConfigurationOutput::license_count): <p>Number of available licenses.</p>
    ///   - [`license_count_hard_limit(Option<bool>)`](crate::output::GetLicenseConfigurationOutput::license_count_hard_limit): <p>Sets the number of available licenses as a hard limit.</p>
    ///   - [`consumed_licenses(Option<i64>)`](crate::output::GetLicenseConfigurationOutput::consumed_licenses): <p>Number of licenses assigned to resources.</p>
    ///   - [`status(Option<String>)`](crate::output::GetLicenseConfigurationOutput::status): <p>License configuration status.</p>
    ///   - [`owner_account_id(Option<String>)`](crate::output::GetLicenseConfigurationOutput::owner_account_id): <p>Account ID of the owner of the license configuration.</p>
    ///   - [`consumed_license_summary_list(Option<Vec<ConsumedLicenseSummary>>)`](crate::output::GetLicenseConfigurationOutput::consumed_license_summary_list): <p>Summaries of the licenses consumed by resources.</p>
    ///   - [`managed_resource_summary_list(Option<Vec<ManagedResourceSummary>>)`](crate::output::GetLicenseConfigurationOutput::managed_resource_summary_list): <p>Summaries of the managed resources.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::GetLicenseConfigurationOutput::tags): <p>Tags for the license configuration.</p>
    ///   - [`product_information_list(Option<Vec<ProductInformation>>)`](crate::output::GetLicenseConfigurationOutput::product_information_list): <p>Product information.</p>
    ///   - [`automated_discovery_information(Option<AutomatedDiscoveryInformation>)`](crate::output::GetLicenseConfigurationOutput::automated_discovery_information): <p>Automated discovery information.</p>
    ///   - [`disassociate_when_not_found(Option<bool>)`](crate::output::GetLicenseConfigurationOutput::disassociate_when_not_found): <p>When true, disassociates a resource when software is uninstalled.</p>
    /// - On failure, responds with [`SdkError<GetLicenseConfigurationError>`](crate::error::GetLicenseConfigurationError)
    pub fn get_license_configuration(&self) -> fluent_builders::GetLicenseConfiguration<C, M, R> {
        fluent_builders::GetLicenseConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLicenseConversionTask`](crate::client::fluent_builders::GetLicenseConversionTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`license_conversion_task_id(impl Into<String>)`](crate::client::fluent_builders::GetLicenseConversionTask::license_conversion_task_id) / [`set_license_conversion_task_id(Option<String>)`](crate::client::fluent_builders::GetLicenseConversionTask::set_license_conversion_task_id): <p>ID of the license type conversion task to retrieve information on.</p>
    /// - On success, responds with [`GetLicenseConversionTaskOutput`](crate::output::GetLicenseConversionTaskOutput) with field(s):
    ///   - [`license_conversion_task_id(Option<String>)`](crate::output::GetLicenseConversionTaskOutput::license_conversion_task_id): <p>ID of the license type conversion task.</p>
    ///   - [`resource_arn(Option<String>)`](crate::output::GetLicenseConversionTaskOutput::resource_arn): <p>Amazon Resource Names (ARN) of the resources the license conversion task is associated with.</p>
    ///   - [`source_license_context(Option<LicenseConversionContext>)`](crate::output::GetLicenseConversionTaskOutput::source_license_context): <p>Information about the license type converted from.</p>
    ///   - [`destination_license_context(Option<LicenseConversionContext>)`](crate::output::GetLicenseConversionTaskOutput::destination_license_context): <p>Information about the license type converted to.</p>
    ///   - [`status_message(Option<String>)`](crate::output::GetLicenseConversionTaskOutput::status_message): <p>The status message for the conversion task.</p>
    ///   - [`status(Option<LicenseConversionTaskStatus>)`](crate::output::GetLicenseConversionTaskOutput::status): <p>Status of the license type conversion task.</p>
    ///   - [`start_time(Option<DateTime>)`](crate::output::GetLicenseConversionTaskOutput::start_time): <p>Time at which the license type conversion task was started .</p>
    ///   - [`license_conversion_time(Option<DateTime>)`](crate::output::GetLicenseConversionTaskOutput::license_conversion_time): <p>Amount of time to complete the license type conversion.</p>
    ///   - [`end_time(Option<DateTime>)`](crate::output::GetLicenseConversionTaskOutput::end_time): <p>Time at which the license type conversion task was completed.</p>
    /// - On failure, responds with [`SdkError<GetLicenseConversionTaskError>`](crate::error::GetLicenseConversionTaskError)
    pub fn get_license_conversion_task(
        &self,
    ) -> fluent_builders::GetLicenseConversionTask<C, M, R> {
        fluent_builders::GetLicenseConversionTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLicenseManagerReportGenerator`](crate::client::fluent_builders::GetLicenseManagerReportGenerator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`license_manager_report_generator_arn(impl Into<String>)`](crate::client::fluent_builders::GetLicenseManagerReportGenerator::license_manager_report_generator_arn) / [`set_license_manager_report_generator_arn(Option<String>)`](crate::client::fluent_builders::GetLicenseManagerReportGenerator::set_license_manager_report_generator_arn): <p>Amazon Resource Name (ARN) of the report generator.</p>
    /// - On success, responds with [`GetLicenseManagerReportGeneratorOutput`](crate::output::GetLicenseManagerReportGeneratorOutput) with field(s):
    ///   - [`report_generator(Option<ReportGenerator>)`](crate::output::GetLicenseManagerReportGeneratorOutput::report_generator): <p>A report generator that creates periodic reports about your license configurations.</p>
    /// - On failure, responds with [`SdkError<GetLicenseManagerReportGeneratorError>`](crate::error::GetLicenseManagerReportGeneratorError)
    pub fn get_license_manager_report_generator(
        &self,
    ) -> fluent_builders::GetLicenseManagerReportGenerator<C, M, R> {
        fluent_builders::GetLicenseManagerReportGenerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetLicenseUsage`](crate::client::fluent_builders::GetLicenseUsage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`license_arn(impl Into<String>)`](crate::client::fluent_builders::GetLicenseUsage::license_arn) / [`set_license_arn(Option<String>)`](crate::client::fluent_builders::GetLicenseUsage::set_license_arn): <p>Amazon Resource Name (ARN) of the license.</p>
    /// - On success, responds with [`GetLicenseUsageOutput`](crate::output::GetLicenseUsageOutput) with field(s):
    ///   - [`license_usage(Option<LicenseUsage>)`](crate::output::GetLicenseUsageOutput::license_usage): <p>License usage details.</p>
    /// - On failure, responds with [`SdkError<GetLicenseUsageError>`](crate::error::GetLicenseUsageError)
    pub fn get_license_usage(&self) -> fluent_builders::GetLicenseUsage<C, M, R> {
        fluent_builders::GetLicenseUsage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetServiceSettings`](crate::client::fluent_builders::GetServiceSettings) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetServiceSettings::send) it.

    /// - On success, responds with [`GetServiceSettingsOutput`](crate::output::GetServiceSettingsOutput) with field(s):
    ///   - [`s3_bucket_arn(Option<String>)`](crate::output::GetServiceSettingsOutput::s3_bucket_arn): <p>Regional S3 bucket path for storing reports, license trail event data, discovery data, and so on.</p>
    ///   - [`sns_topic_arn(Option<String>)`](crate::output::GetServiceSettingsOutput::sns_topic_arn): <p>SNS topic configured to receive notifications from License Manager.</p>
    ///   - [`organization_configuration(Option<OrganizationConfiguration>)`](crate::output::GetServiceSettingsOutput::organization_configuration): <p>Indicates whether Organizations is integrated with License Manager for cross-account discovery.</p>
    ///   - [`enable_cross_accounts_discovery(Option<bool>)`](crate::output::GetServiceSettingsOutput::enable_cross_accounts_discovery): <p>Indicates whether cross-account discovery is enabled.</p>
    ///   - [`license_manager_resource_share_arn(Option<String>)`](crate::output::GetServiceSettingsOutput::license_manager_resource_share_arn): <p>Amazon Resource Name (ARN) of the resource share. The License Manager management account provides member accounts with access to this share.</p>
    /// - On failure, responds with [`SdkError<GetServiceSettingsError>`](crate::error::GetServiceSettingsError)
    pub fn get_service_settings(&self) -> fluent_builders::GetServiceSettings<C, M, R> {
        fluent_builders::GetServiceSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAssociationsForLicenseConfiguration`](crate::client::fluent_builders::ListAssociationsForLicenseConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`license_configuration_arn(impl Into<String>)`](crate::client::fluent_builders::ListAssociationsForLicenseConfiguration::license_configuration_arn) / [`set_license_configuration_arn(Option<String>)`](crate::client::fluent_builders::ListAssociationsForLicenseConfiguration::set_license_configuration_arn): <p>Amazon Resource Name (ARN) of a license configuration.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAssociationsForLicenseConfiguration::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAssociationsForLicenseConfiguration::set_max_results): <p>Maximum number of results to return in a single call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAssociationsForLicenseConfiguration::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAssociationsForLicenseConfiguration::set_next_token): <p>Token for the next set of results.</p>
    /// - On success, responds with [`ListAssociationsForLicenseConfigurationOutput`](crate::output::ListAssociationsForLicenseConfigurationOutput) with field(s):
    ///   - [`license_configuration_associations(Option<Vec<LicenseConfigurationAssociation>>)`](crate::output::ListAssociationsForLicenseConfigurationOutput::license_configuration_associations): <p>Information about the associations for the license configuration.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAssociationsForLicenseConfigurationOutput::next_token): <p>Token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListAssociationsForLicenseConfigurationError>`](crate::error::ListAssociationsForLicenseConfigurationError)
    pub fn list_associations_for_license_configuration(
        &self,
    ) -> fluent_builders::ListAssociationsForLicenseConfiguration<C, M, R> {
        fluent_builders::ListAssociationsForLicenseConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDistributedGrants`](crate::client::fluent_builders::ListDistributedGrants) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`grant_arns(Vec<String>)`](crate::client::fluent_builders::ListDistributedGrants::grant_arns) / [`set_grant_arns(Option<Vec<String>>)`](crate::client::fluent_builders::ListDistributedGrants::set_grant_arns): <p>Amazon Resource Names (ARNs) of the grants.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListDistributedGrants::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListDistributedGrants::set_filters): <p>Filters to scope the results. The following filters are supported:</p>  <ul>   <li> <p> <code>LicenseArn</code> </p> </li>   <li> <p> <code>GrantStatus</code> </p> </li>   <li> <p> <code>GranteePrincipalARN</code> </p> </li>   <li> <p> <code>ProductSKU</code> </p> </li>   <li> <p> <code>LicenseIssuerName</code> </p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDistributedGrants::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDistributedGrants::set_next_token): <p>Token for the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDistributedGrants::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDistributedGrants::set_max_results): <p>Maximum number of results to return in a single call.</p>
    /// - On success, responds with [`ListDistributedGrantsOutput`](crate::output::ListDistributedGrantsOutput) with field(s):
    ///   - [`grants(Option<Vec<Grant>>)`](crate::output::ListDistributedGrantsOutput::grants): <p>Distributed grant details.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDistributedGrantsOutput::next_token): <p>Token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListDistributedGrantsError>`](crate::error::ListDistributedGrantsError)
    pub fn list_distributed_grants(&self) -> fluent_builders::ListDistributedGrants<C, M, R> {
        fluent_builders::ListDistributedGrants::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFailuresForLicenseConfigurationOperations`](crate::client::fluent_builders::ListFailuresForLicenseConfigurationOperations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`license_configuration_arn(impl Into<String>)`](crate::client::fluent_builders::ListFailuresForLicenseConfigurationOperations::license_configuration_arn) / [`set_license_configuration_arn(Option<String>)`](crate::client::fluent_builders::ListFailuresForLicenseConfigurationOperations::set_license_configuration_arn): <p>Amazon Resource Name of the license configuration.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFailuresForLicenseConfigurationOperations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListFailuresForLicenseConfigurationOperations::set_max_results): <p>Maximum number of results to return in a single call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFailuresForLicenseConfigurationOperations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFailuresForLicenseConfigurationOperations::set_next_token): <p>Token for the next set of results.</p>
    /// - On success, responds with [`ListFailuresForLicenseConfigurationOperationsOutput`](crate::output::ListFailuresForLicenseConfigurationOperationsOutput) with field(s):
    ///   - [`license_operation_failure_list(Option<Vec<LicenseOperationFailure>>)`](crate::output::ListFailuresForLicenseConfigurationOperationsOutput::license_operation_failure_list): <p>License configuration operations that failed.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFailuresForLicenseConfigurationOperationsOutput::next_token): <p>Token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListFailuresForLicenseConfigurationOperationsError>`](crate::error::ListFailuresForLicenseConfigurationOperationsError)
    pub fn list_failures_for_license_configuration_operations(
        &self,
    ) -> fluent_builders::ListFailuresForLicenseConfigurationOperations<C, M, R> {
        fluent_builders::ListFailuresForLicenseConfigurationOperations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLicenseConfigurations`](crate::client::fluent_builders::ListLicenseConfigurations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`license_configuration_arns(Vec<String>)`](crate::client::fluent_builders::ListLicenseConfigurations::license_configuration_arns) / [`set_license_configuration_arns(Option<Vec<String>>)`](crate::client::fluent_builders::ListLicenseConfigurations::set_license_configuration_arns): <p>Amazon Resource Names (ARN) of the license configurations.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListLicenseConfigurations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListLicenseConfigurations::set_max_results): <p>Maximum number of results to return in a single call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLicenseConfigurations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLicenseConfigurations::set_next_token): <p>Token for the next set of results.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListLicenseConfigurations::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListLicenseConfigurations::set_filters): <p>Filters to scope the results. The following filters and logical operators are supported:</p>  <ul>   <li> <p> <code>licenseCountingType</code> - The dimension for which licenses are counted. Possible values are <code>vCPU</code> | <code>Instance</code> | <code>Core</code> | <code>Socket</code>. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>   <li> <p> <code>enforceLicenseCount</code> - A Boolean value that indicates whether hard license enforcement is used. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>   <li> <p> <code>usagelimitExceeded</code> - A Boolean value that indicates whether the available licenses have been exceeded. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>  </ul>
    /// - On success, responds with [`ListLicenseConfigurationsOutput`](crate::output::ListLicenseConfigurationsOutput) with field(s):
    ///   - [`license_configurations(Option<Vec<LicenseConfiguration>>)`](crate::output::ListLicenseConfigurationsOutput::license_configurations): <p>Information about the license configurations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLicenseConfigurationsOutput::next_token): <p>Token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListLicenseConfigurationsError>`](crate::error::ListLicenseConfigurationsError)
    pub fn list_license_configurations(
        &self,
    ) -> fluent_builders::ListLicenseConfigurations<C, M, R> {
        fluent_builders::ListLicenseConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLicenseConversionTasks`](crate::client::fluent_builders::ListLicenseConversionTasks) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLicenseConversionTasks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLicenseConversionTasks::set_next_token): <p>Token for the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListLicenseConversionTasks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListLicenseConversionTasks::set_max_results): <p>Maximum number of results to return in a single call.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListLicenseConversionTasks::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListLicenseConversionTasks::set_filters): <p> Filters to scope the results. Valid filters are <code>ResourceArns</code> and <code>Status</code>. </p>
    /// - On success, responds with [`ListLicenseConversionTasksOutput`](crate::output::ListLicenseConversionTasksOutput) with field(s):
    ///   - [`license_conversion_tasks(Option<Vec<LicenseConversionTask>>)`](crate::output::ListLicenseConversionTasksOutput::license_conversion_tasks): <p>Information about the license configuration tasks for your account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLicenseConversionTasksOutput::next_token): <p>Token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListLicenseConversionTasksError>`](crate::error::ListLicenseConversionTasksError)
    pub fn list_license_conversion_tasks(
        &self,
    ) -> fluent_builders::ListLicenseConversionTasks<C, M, R> {
        fluent_builders::ListLicenseConversionTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLicenseManagerReportGenerators`](crate::client::fluent_builders::ListLicenseManagerReportGenerators) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListLicenseManagerReportGenerators::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListLicenseManagerReportGenerators::set_filters): <p>Filters to scope the results. The following filters are supported: </p>  <ul>   <li> <p> <code>LicenseConfigurationArn</code> </p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLicenseManagerReportGenerators::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLicenseManagerReportGenerators::set_next_token): <p>Token for the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListLicenseManagerReportGenerators::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListLicenseManagerReportGenerators::set_max_results): <p>Maximum number of results to return in a single call.</p>
    /// - On success, responds with [`ListLicenseManagerReportGeneratorsOutput`](crate::output::ListLicenseManagerReportGeneratorsOutput) with field(s):
    ///   - [`report_generators(Option<Vec<ReportGenerator>>)`](crate::output::ListLicenseManagerReportGeneratorsOutput::report_generators): <p>A report generator that creates periodic reports about your license configurations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLicenseManagerReportGeneratorsOutput::next_token): <p>Token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListLicenseManagerReportGeneratorsError>`](crate::error::ListLicenseManagerReportGeneratorsError)
    pub fn list_license_manager_report_generators(
        &self,
    ) -> fluent_builders::ListLicenseManagerReportGenerators<C, M, R> {
        fluent_builders::ListLicenseManagerReportGenerators::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLicenses`](crate::client::fluent_builders::ListLicenses) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`license_arns(Vec<String>)`](crate::client::fluent_builders::ListLicenses::license_arns) / [`set_license_arns(Option<Vec<String>>)`](crate::client::fluent_builders::ListLicenses::set_license_arns): <p>Amazon Resource Names (ARNs) of the licenses.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListLicenses::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListLicenses::set_filters): <p>Filters to scope the results. The following filters are supported:</p>  <ul>   <li> <p> <code>Beneficiary</code> </p> </li>   <li> <p> <code>ProductSKU</code> </p> </li>   <li> <p> <code>Fingerprint</code> </p> </li>   <li> <p> <code>Status</code> </p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLicenses::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLicenses::set_next_token): <p>Token for the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListLicenses::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListLicenses::set_max_results): <p>Maximum number of results to return in a single call.</p>
    /// - On success, responds with [`ListLicensesOutput`](crate::output::ListLicensesOutput) with field(s):
    ///   - [`licenses(Option<Vec<License>>)`](crate::output::ListLicensesOutput::licenses): <p>License details.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLicensesOutput::next_token): <p>Token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListLicensesError>`](crate::error::ListLicensesError)
    pub fn list_licenses(&self) -> fluent_builders::ListLicenses<C, M, R> {
        fluent_builders::ListLicenses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLicenseSpecificationsForResource`](crate::client::fluent_builders::ListLicenseSpecificationsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListLicenseSpecificationsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListLicenseSpecificationsForResource::set_resource_arn): <p>Amazon Resource Name (ARN) of a resource that has an associated license configuration.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListLicenseSpecificationsForResource::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListLicenseSpecificationsForResource::set_max_results): <p>Maximum number of results to return in a single call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLicenseSpecificationsForResource::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLicenseSpecificationsForResource::set_next_token): <p>Token for the next set of results.</p>
    /// - On success, responds with [`ListLicenseSpecificationsForResourceOutput`](crate::output::ListLicenseSpecificationsForResourceOutput) with field(s):
    ///   - [`license_specifications(Option<Vec<LicenseSpecification>>)`](crate::output::ListLicenseSpecificationsForResourceOutput::license_specifications): <p>License configurations associated with a resource.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLicenseSpecificationsForResourceOutput::next_token): <p>Token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListLicenseSpecificationsForResourceError>`](crate::error::ListLicenseSpecificationsForResourceError)
    pub fn list_license_specifications_for_resource(
        &self,
    ) -> fluent_builders::ListLicenseSpecificationsForResource<C, M, R> {
        fluent_builders::ListLicenseSpecificationsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLicenseVersions`](crate::client::fluent_builders::ListLicenseVersions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`license_arn(impl Into<String>)`](crate::client::fluent_builders::ListLicenseVersions::license_arn) / [`set_license_arn(Option<String>)`](crate::client::fluent_builders::ListLicenseVersions::set_license_arn): <p>Amazon Resource Name (ARN) of the license.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLicenseVersions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLicenseVersions::set_next_token): <p>Token for the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListLicenseVersions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListLicenseVersions::set_max_results): <p>Maximum number of results to return in a single call.</p>
    /// - On success, responds with [`ListLicenseVersionsOutput`](crate::output::ListLicenseVersionsOutput) with field(s):
    ///   - [`licenses(Option<Vec<License>>)`](crate::output::ListLicenseVersionsOutput::licenses): <p>License details.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLicenseVersionsOutput::next_token): <p>Token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListLicenseVersionsError>`](crate::error::ListLicenseVersionsError)
    pub fn list_license_versions(&self) -> fluent_builders::ListLicenseVersions<C, M, R> {
        fluent_builders::ListLicenseVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListReceivedGrants`](crate::client::fluent_builders::ListReceivedGrants) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`grant_arns(Vec<String>)`](crate::client::fluent_builders::ListReceivedGrants::grant_arns) / [`set_grant_arns(Option<Vec<String>>)`](crate::client::fluent_builders::ListReceivedGrants::set_grant_arns): <p>Amazon Resource Names (ARNs) of the grants.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListReceivedGrants::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListReceivedGrants::set_filters): <p>Filters to scope the results. The following filters are supported:</p>  <ul>   <li> <p> <code>ProductSKU</code> </p> </li>   <li> <p> <code>LicenseIssuerName</code> </p> </li>   <li> <p> <code>LicenseArn</code> </p> </li>   <li> <p> <code>GrantStatus</code> </p> </li>   <li> <p> <code>GranterAccountId</code> </p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListReceivedGrants::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListReceivedGrants::set_next_token): <p>Token for the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListReceivedGrants::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListReceivedGrants::set_max_results): <p>Maximum number of results to return in a single call.</p>
    /// - On success, responds with [`ListReceivedGrantsOutput`](crate::output::ListReceivedGrantsOutput) with field(s):
    ///   - [`grants(Option<Vec<Grant>>)`](crate::output::ListReceivedGrantsOutput::grants): <p>Received grant details.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListReceivedGrantsOutput::next_token): <p>Token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListReceivedGrantsError>`](crate::error::ListReceivedGrantsError)
    pub fn list_received_grants(&self) -> fluent_builders::ListReceivedGrants<C, M, R> {
        fluent_builders::ListReceivedGrants::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListReceivedLicenses`](crate::client::fluent_builders::ListReceivedLicenses) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`license_arns(Vec<String>)`](crate::client::fluent_builders::ListReceivedLicenses::license_arns) / [`set_license_arns(Option<Vec<String>>)`](crate::client::fluent_builders::ListReceivedLicenses::set_license_arns): <p>Amazon Resource Names (ARNs) of the licenses.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListReceivedLicenses::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListReceivedLicenses::set_filters): <p>Filters to scope the results. The following filters are supported:</p>  <ul>   <li> <p> <code>ProductSKU</code> </p> </li>   <li> <p> <code>Status</code> </p> </li>   <li> <p> <code>Fingerprint</code> </p> </li>   <li> <p> <code>IssuerName</code> </p> </li>   <li> <p> <code>Beneficiary</code> </p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListReceivedLicenses::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListReceivedLicenses::set_next_token): <p>Token for the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListReceivedLicenses::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListReceivedLicenses::set_max_results): <p>Maximum number of results to return in a single call.</p>
    /// - On success, responds with [`ListReceivedLicensesOutput`](crate::output::ListReceivedLicensesOutput) with field(s):
    ///   - [`licenses(Option<Vec<GrantedLicense>>)`](crate::output::ListReceivedLicensesOutput::licenses): <p>Received license details.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListReceivedLicensesOutput::next_token): <p>Token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListReceivedLicensesError>`](crate::error::ListReceivedLicensesError)
    pub fn list_received_licenses(&self) -> fluent_builders::ListReceivedLicenses<C, M, R> {
        fluent_builders::ListReceivedLicenses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListResourceInventory`](crate::client::fluent_builders::ListResourceInventory) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListResourceInventory::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListResourceInventory::set_max_results): <p>Maximum number of results to return in a single call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListResourceInventory::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListResourceInventory::set_next_token): <p>Token for the next set of results.</p>
    ///   - [`filters(Vec<InventoryFilter>)`](crate::client::fluent_builders::ListResourceInventory::filters) / [`set_filters(Option<Vec<InventoryFilter>>)`](crate::client::fluent_builders::ListResourceInventory::set_filters): <p>Filters to scope the results. The following filters and logical operators are supported:</p>  <ul>   <li> <p> <code>account_id</code> - The ID of the Amazon Web Services account that owns the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>   <li> <p> <code>application_name</code> - The name of the application. Logical operators are <code>EQUALS</code> | <code>BEGINS_WITH</code>.</p> </li>   <li> <p> <code>license_included</code> - The type of license included. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>. Possible values are <code>sql-server-enterprise</code> | <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.</p> </li>   <li> <p> <code>platform</code> - The platform of the resource. Logical operators are <code>EQUALS</code> | <code>BEGINS_WITH</code>.</p> </li>   <li> <p> <code>resource_id</code> - The ID of the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>   <li> <p> <code>tag:     <key></key></code> - The key/value combination of a tag assigned to the resource. Logical operators are <code>EQUALS</code> (single account) or <code>EQUALS</code> | <code>NOT_EQUALS</code> (cross account).</p> </li>  </ul>
    /// - On success, responds with [`ListResourceInventoryOutput`](crate::output::ListResourceInventoryOutput) with field(s):
    ///   - [`resource_inventory_list(Option<Vec<ResourceInventory>>)`](crate::output::ListResourceInventoryOutput::resource_inventory_list): <p>Information about the resources.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListResourceInventoryOutput::next_token): <p>Token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListResourceInventoryError>`](crate::error::ListResourceInventoryError)
    pub fn list_resource_inventory(&self) -> fluent_builders::ListResourceInventory<C, M, R> {
        fluent_builders::ListResourceInventory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>Amazon Resource Name (ARN) of the license configuration.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>Information about the tags.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTokens`](crate::client::fluent_builders::ListTokens) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`token_ids(Vec<String>)`](crate::client::fluent_builders::ListTokens::token_ids) / [`set_token_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ListTokens::set_token_ids): <p>Token IDs.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListTokens::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListTokens::set_filters): <p>Filters to scope the results. The following filter is supported:</p>  <ul>   <li> <p> <code>LicenseArns</code> </p> </li>  </ul>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListTokens::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListTokens::set_next_token): <p>Token for the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListTokens::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListTokens::set_max_results): <p>Maximum number of results to return in a single call.</p>
    /// - On success, responds with [`ListTokensOutput`](crate::output::ListTokensOutput) with field(s):
    ///   - [`tokens(Option<Vec<TokenData>>)`](crate::output::ListTokensOutput::tokens): <p>Received token details.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListTokensOutput::next_token): <p>Token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListTokensError>`](crate::error::ListTokensError)
    pub fn list_tokens(&self) -> fluent_builders::ListTokens<C, M, R> {
        fluent_builders::ListTokens::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListUsageForLicenseConfiguration`](crate::client::fluent_builders::ListUsageForLicenseConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`license_configuration_arn(impl Into<String>)`](crate::client::fluent_builders::ListUsageForLicenseConfiguration::license_configuration_arn) / [`set_license_configuration_arn(Option<String>)`](crate::client::fluent_builders::ListUsageForLicenseConfiguration::set_license_configuration_arn): <p>Amazon Resource Name (ARN) of the license configuration.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListUsageForLicenseConfiguration::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListUsageForLicenseConfiguration::set_max_results): <p>Maximum number of results to return in a single call.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListUsageForLicenseConfiguration::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListUsageForLicenseConfiguration::set_next_token): <p>Token for the next set of results.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListUsageForLicenseConfiguration::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListUsageForLicenseConfiguration::set_filters): <p>Filters to scope the results. The following filters and logical operators are supported:</p>  <ul>   <li> <p> <code>resourceArn</code> - The ARN of the license configuration resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>   <li> <p> <code>resourceType</code> - The resource type (<code>EC2_INSTANCE</code> | <code>EC2_HOST</code> | <code>EC2_AMI</code> | <code>SYSTEMS_MANAGER_MANAGED_INSTANCE</code>). Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>   <li> <p> <code>resourceAccount</code> - The ID of the account that owns the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>  </ul>
    /// - On success, responds with [`ListUsageForLicenseConfigurationOutput`](crate::output::ListUsageForLicenseConfigurationOutput) with field(s):
    ///   - [`license_configuration_usage_list(Option<Vec<LicenseConfigurationUsage>>)`](crate::output::ListUsageForLicenseConfigurationOutput::license_configuration_usage_list): <p>Information about the license configurations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListUsageForLicenseConfigurationOutput::next_token): <p>Token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListUsageForLicenseConfigurationError>`](crate::error::ListUsageForLicenseConfigurationError)
    pub fn list_usage_for_license_configuration(
        &self,
    ) -> fluent_builders::ListUsageForLicenseConfiguration<C, M, R> {
        fluent_builders::ListUsageForLicenseConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RejectGrant`](crate::client::fluent_builders::RejectGrant) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`grant_arn(impl Into<String>)`](crate::client::fluent_builders::RejectGrant::grant_arn) / [`set_grant_arn(Option<String>)`](crate::client::fluent_builders::RejectGrant::set_grant_arn): <p>Amazon Resource Name (ARN) of the grant.</p>
    /// - On success, responds with [`RejectGrantOutput`](crate::output::RejectGrantOutput) with field(s):
    ///   - [`grant_arn(Option<String>)`](crate::output::RejectGrantOutput::grant_arn): <p>Grant ARN.</p>
    ///   - [`status(Option<GrantStatus>)`](crate::output::RejectGrantOutput::status): <p>Grant status.</p>
    ///   - [`version(Option<String>)`](crate::output::RejectGrantOutput::version): <p>Grant version.</p>
    /// - On failure, responds with [`SdkError<RejectGrantError>`](crate::error::RejectGrantError)
    pub fn reject_grant(&self) -> fluent_builders::RejectGrant<C, M, R> {
        fluent_builders::RejectGrant::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>Amazon Resource Name (ARN) of the license configuration.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>One or more tags.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>Amazon Resource Name (ARN) of the license configuration.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>Keys identifying the tags to remove.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateLicenseConfiguration`](crate::client::fluent_builders::UpdateLicenseConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`license_configuration_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateLicenseConfiguration::license_configuration_arn) / [`set_license_configuration_arn(Option<String>)`](crate::client::fluent_builders::UpdateLicenseConfiguration::set_license_configuration_arn): <p>Amazon Resource Name (ARN) of the license configuration.</p>
    ///   - [`license_configuration_status(LicenseConfigurationStatus)`](crate::client::fluent_builders::UpdateLicenseConfiguration::license_configuration_status) / [`set_license_configuration_status(Option<LicenseConfigurationStatus>)`](crate::client::fluent_builders::UpdateLicenseConfiguration::set_license_configuration_status): <p>New status of the license configuration.</p>
    ///   - [`license_rules(Vec<String>)`](crate::client::fluent_builders::UpdateLicenseConfiguration::license_rules) / [`set_license_rules(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateLicenseConfiguration::set_license_rules): <p>New license rule. The only rule that you can add after you create a license configuration is licenseAffinityToHost.</p>
    ///   - [`license_count(i64)`](crate::client::fluent_builders::UpdateLicenseConfiguration::license_count) / [`set_license_count(Option<i64>)`](crate::client::fluent_builders::UpdateLicenseConfiguration::set_license_count): <p>New number of licenses managed by the license configuration.</p>
    ///   - [`license_count_hard_limit(bool)`](crate::client::fluent_builders::UpdateLicenseConfiguration::license_count_hard_limit) / [`set_license_count_hard_limit(Option<bool>)`](crate::client::fluent_builders::UpdateLicenseConfiguration::set_license_count_hard_limit): <p>New hard limit of the number of available licenses.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateLicenseConfiguration::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateLicenseConfiguration::set_name): <p>New name of the license configuration.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateLicenseConfiguration::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateLicenseConfiguration::set_description): <p>New description of the license configuration.</p>
    ///   - [`product_information_list(Vec<ProductInformation>)`](crate::client::fluent_builders::UpdateLicenseConfiguration::product_information_list) / [`set_product_information_list(Option<Vec<ProductInformation>>)`](crate::client::fluent_builders::UpdateLicenseConfiguration::set_product_information_list): <p>New product information.</p>
    ///   - [`disassociate_when_not_found(bool)`](crate::client::fluent_builders::UpdateLicenseConfiguration::disassociate_when_not_found) / [`set_disassociate_when_not_found(Option<bool>)`](crate::client::fluent_builders::UpdateLicenseConfiguration::set_disassociate_when_not_found): <p>When true, disassociates a resource when software is uninstalled.</p>
    /// - On success, responds with [`UpdateLicenseConfigurationOutput`](crate::output::UpdateLicenseConfigurationOutput)

    /// - On failure, responds with [`SdkError<UpdateLicenseConfigurationError>`](crate::error::UpdateLicenseConfigurationError)
    pub fn update_license_configuration(
        &self,
    ) -> fluent_builders::UpdateLicenseConfiguration<C, M, R> {
        fluent_builders::UpdateLicenseConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateLicenseManagerReportGenerator`](crate::client::fluent_builders::UpdateLicenseManagerReportGenerator) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`license_manager_report_generator_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateLicenseManagerReportGenerator::license_manager_report_generator_arn) / [`set_license_manager_report_generator_arn(Option<String>)`](crate::client::fluent_builders::UpdateLicenseManagerReportGenerator::set_license_manager_report_generator_arn): <p>Amazon Resource Name (ARN) of the report generator to update.</p>
    ///   - [`report_generator_name(impl Into<String>)`](crate::client::fluent_builders::UpdateLicenseManagerReportGenerator::report_generator_name) / [`set_report_generator_name(Option<String>)`](crate::client::fluent_builders::UpdateLicenseManagerReportGenerator::set_report_generator_name): <p>Name of the report generator.</p>
    ///   - [`r#type(Vec<ReportType>)`](crate::client::fluent_builders::UpdateLicenseManagerReportGenerator::r#type) / [`set_type(Option<Vec<ReportType>>)`](crate::client::fluent_builders::UpdateLicenseManagerReportGenerator::set_type): <p>Type of reports to generate. The following report types are supported:</p>  <ul>   <li> <p>License configuration report - Reports the number and details of consumed licenses for a license configuration.</p> </li>   <li> <p>Resource report - Reports the tracked licenses and resource consumption for a license configuration.</p> </li>  </ul>
    ///   - [`report_context(ReportContext)`](crate::client::fluent_builders::UpdateLicenseManagerReportGenerator::report_context) / [`set_report_context(Option<ReportContext>)`](crate::client::fluent_builders::UpdateLicenseManagerReportGenerator::set_report_context): <p>The report context.</p>
    ///   - [`report_frequency(ReportFrequency)`](crate::client::fluent_builders::UpdateLicenseManagerReportGenerator::report_frequency) / [`set_report_frequency(Option<ReportFrequency>)`](crate::client::fluent_builders::UpdateLicenseManagerReportGenerator::set_report_frequency): <p>Frequency by which reports are generated.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateLicenseManagerReportGenerator::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateLicenseManagerReportGenerator::set_client_token): <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateLicenseManagerReportGenerator::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateLicenseManagerReportGenerator::set_description): <p>Description of the report generator.</p>
    /// - On success, responds with [`UpdateLicenseManagerReportGeneratorOutput`](crate::output::UpdateLicenseManagerReportGeneratorOutput)

    /// - On failure, responds with [`SdkError<UpdateLicenseManagerReportGeneratorError>`](crate::error::UpdateLicenseManagerReportGeneratorError)
    pub fn update_license_manager_report_generator(
        &self,
    ) -> fluent_builders::UpdateLicenseManagerReportGenerator<C, M, R> {
        fluent_builders::UpdateLicenseManagerReportGenerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateLicenseSpecificationsForResource`](crate::client::fluent_builders::UpdateLicenseSpecificationsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateLicenseSpecificationsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UpdateLicenseSpecificationsForResource::set_resource_arn): <p>Amazon Resource Name (ARN) of the Amazon Web Services resource.</p>
    ///   - [`add_license_specifications(Vec<LicenseSpecification>)`](crate::client::fluent_builders::UpdateLicenseSpecificationsForResource::add_license_specifications) / [`set_add_license_specifications(Option<Vec<LicenseSpecification>>)`](crate::client::fluent_builders::UpdateLicenseSpecificationsForResource::set_add_license_specifications): <p>ARNs of the license configurations to add.</p>
    ///   - [`remove_license_specifications(Vec<LicenseSpecification>)`](crate::client::fluent_builders::UpdateLicenseSpecificationsForResource::remove_license_specifications) / [`set_remove_license_specifications(Option<Vec<LicenseSpecification>>)`](crate::client::fluent_builders::UpdateLicenseSpecificationsForResource::set_remove_license_specifications): <p>ARNs of the license configurations to remove.</p>
    /// - On success, responds with [`UpdateLicenseSpecificationsForResourceOutput`](crate::output::UpdateLicenseSpecificationsForResourceOutput)

    /// - On failure, responds with [`SdkError<UpdateLicenseSpecificationsForResourceError>`](crate::error::UpdateLicenseSpecificationsForResourceError)
    pub fn update_license_specifications_for_resource(
        &self,
    ) -> fluent_builders::UpdateLicenseSpecificationsForResource<C, M, R> {
        fluent_builders::UpdateLicenseSpecificationsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateServiceSettings`](crate::client::fluent_builders::UpdateServiceSettings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`s3_bucket_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateServiceSettings::s3_bucket_arn) / [`set_s3_bucket_arn(Option<String>)`](crate::client::fluent_builders::UpdateServiceSettings::set_s3_bucket_arn): <p>Amazon Resource Name (ARN) of the Amazon S3 bucket where the License Manager information is stored.</p>
    ///   - [`sns_topic_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateServiceSettings::sns_topic_arn) / [`set_sns_topic_arn(Option<String>)`](crate::client::fluent_builders::UpdateServiceSettings::set_sns_topic_arn): <p>Amazon Resource Name (ARN) of the Amazon SNS topic used for License Manager alerts.</p>
    ///   - [`organization_configuration(OrganizationConfiguration)`](crate::client::fluent_builders::UpdateServiceSettings::organization_configuration) / [`set_organization_configuration(Option<OrganizationConfiguration>)`](crate::client::fluent_builders::UpdateServiceSettings::set_organization_configuration): <p>Enables integration with Organizations for cross-account discovery.</p>
    ///   - [`enable_cross_accounts_discovery(bool)`](crate::client::fluent_builders::UpdateServiceSettings::enable_cross_accounts_discovery) / [`set_enable_cross_accounts_discovery(Option<bool>)`](crate::client::fluent_builders::UpdateServiceSettings::set_enable_cross_accounts_discovery): <p>Activates cross-account discovery.</p>
    /// - On success, responds with [`UpdateServiceSettingsOutput`](crate::output::UpdateServiceSettingsOutput)

    /// - On failure, responds with [`SdkError<UpdateServiceSettingsError>`](crate::error::UpdateServiceSettingsError)
    pub fn update_service_settings(&self) -> fluent_builders::UpdateServiceSettings<C, M, R> {
        fluent_builders::UpdateServiceSettings::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptGrant`.
    ///
    /// <p>Accepts the specified grant.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptGrant<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_grant_input::Builder,
    }
    impl<C, M, R> AcceptGrant<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptGrant`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptGrantOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptGrantError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptGrantInputOperationOutputAlias,
                crate::output::AcceptGrantOutput,
                crate::error::AcceptGrantError,
                crate::input::AcceptGrantInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn grant_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn set_grant_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CheckInLicense`.
    ///
    /// <p>Checks in the specified license. Check in a license when it is no longer in use.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CheckInLicense<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::check_in_license_input::Builder,
    }
    impl<C, M, R> CheckInLicense<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CheckInLicense`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CheckInLicenseOutput,
            aws_smithy_http::result::SdkError<crate::error::CheckInLicenseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CheckInLicenseInputOperationOutputAlias,
                crate::output::CheckInLicenseOutput,
                crate::error::CheckInLicenseError,
                crate::input::CheckInLicenseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>License consumption token.</p>
        pub fn license_consumption_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_consumption_token(input.into());
            self
        }
        /// <p>License consumption token.</p>
        pub fn set_license_consumption_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_consumption_token(input);
            self
        }
        /// <p>License beneficiary.</p>
        pub fn beneficiary(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.beneficiary(input.into());
            self
        }
        /// <p>License beneficiary.</p>
        pub fn set_beneficiary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_beneficiary(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CheckoutBorrowLicense`.
    ///
    /// <p>Checks out the specified license for offline use.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CheckoutBorrowLicense<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::checkout_borrow_license_input::Builder,
    }
    impl<C, M, R> CheckoutBorrowLicense<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CheckoutBorrowLicense`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CheckoutBorrowLicenseOutput,
            aws_smithy_http::result::SdkError<crate::error::CheckoutBorrowLicenseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CheckoutBorrowLicenseInputOperationOutputAlias,
                crate::output::CheckoutBorrowLicenseOutput,
                crate::error::CheckoutBorrowLicenseError,
                crate::input::CheckoutBorrowLicenseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license. The license must use the borrow consumption configuration.</p>
        pub fn license_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license. The license must use the borrow consumption configuration.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_arn(input);
            self
        }
        /// Appends an item to `Entitlements`.
        ///
        /// To override the contents of this collection use [`set_entitlements`](Self::set_entitlements).
        ///
        /// <p>License entitlements. Partial checkouts are not supported.</p>
        pub fn entitlements(mut self, input: crate::model::EntitlementData) -> Self {
            self.inner = self.inner.entitlements(input);
            self
        }
        /// <p>License entitlements. Partial checkouts are not supported.</p>
        pub fn set_entitlements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntitlementData>>,
        ) -> Self {
            self.inner = self.inner.set_entitlements(input);
            self
        }
        /// <p>Digital signature method. The possible value is JSON Web Signature (JWS) algorithm PS384. For more information, see <a href="https://tools.ietf.org/html/rfc7518#section-3.5">RFC 7518 Digital Signature with RSASSA-PSS</a>.</p>
        pub fn digital_signature_method(
            mut self,
            input: crate::model::DigitalSignatureMethod,
        ) -> Self {
            self.inner = self.inner.digital_signature_method(input);
            self
        }
        /// <p>Digital signature method. The possible value is JSON Web Signature (JWS) algorithm PS384. For more information, see <a href="https://tools.ietf.org/html/rfc7518#section-3.5">RFC 7518 Digital Signature with RSASSA-PSS</a>.</p>
        pub fn set_digital_signature_method(
            mut self,
            input: std::option::Option<crate::model::DigitalSignatureMethod>,
        ) -> Self {
            self.inner = self.inner.set_digital_signature_method(input);
            self
        }
        /// <p>Node ID.</p>
        pub fn node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_id(input.into());
            self
        }
        /// <p>Node ID.</p>
        pub fn set_node_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_id(input);
            self
        }
        /// Appends an item to `CheckoutMetadata`.
        ///
        /// To override the contents of this collection use [`set_checkout_metadata`](Self::set_checkout_metadata).
        ///
        /// <p>Information about constraints.</p>
        pub fn checkout_metadata(mut self, input: crate::model::Metadata) -> Self {
            self.inner = self.inner.checkout_metadata(input);
            self
        }
        /// <p>Information about constraints.</p>
        pub fn set_checkout_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
        ) -> Self {
            self.inner = self.inner.set_checkout_metadata(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CheckoutLicense`.
    ///
    /// <p>Checks out the specified license.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CheckoutLicense<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::checkout_license_input::Builder,
    }
    impl<C, M, R> CheckoutLicense<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CheckoutLicense`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CheckoutLicenseOutput,
            aws_smithy_http::result::SdkError<crate::error::CheckoutLicenseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CheckoutLicenseInputOperationOutputAlias,
                crate::output::CheckoutLicenseOutput,
                crate::error::CheckoutLicenseError,
                crate::input::CheckoutLicenseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Product SKU.</p>
        pub fn product_sku(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_sku(input.into());
            self
        }
        /// <p>Product SKU.</p>
        pub fn set_product_sku(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_sku(input);
            self
        }
        /// <p>Checkout type.</p>
        pub fn checkout_type(mut self, input: crate::model::CheckoutType) -> Self {
            self.inner = self.inner.checkout_type(input);
            self
        }
        /// <p>Checkout type.</p>
        pub fn set_checkout_type(
            mut self,
            input: std::option::Option<crate::model::CheckoutType>,
        ) -> Self {
            self.inner = self.inner.set_checkout_type(input);
            self
        }
        /// <p>Key fingerprint identifying the license.</p>
        pub fn key_fingerprint(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_fingerprint(input.into());
            self
        }
        /// <p>Key fingerprint identifying the license.</p>
        pub fn set_key_fingerprint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_key_fingerprint(input);
            self
        }
        /// Appends an item to `Entitlements`.
        ///
        /// To override the contents of this collection use [`set_entitlements`](Self::set_entitlements).
        ///
        /// <p>License entitlements.</p>
        pub fn entitlements(mut self, input: crate::model::EntitlementData) -> Self {
            self.inner = self.inner.entitlements(input);
            self
        }
        /// <p>License entitlements.</p>
        pub fn set_entitlements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntitlementData>>,
        ) -> Self {
            self.inner = self.inner.set_entitlements(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>License beneficiary.</p>
        pub fn beneficiary(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.beneficiary(input.into());
            self
        }
        /// <p>License beneficiary.</p>
        pub fn set_beneficiary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_beneficiary(input);
            self
        }
        /// <p>Node ID.</p>
        pub fn node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_id(input.into());
            self
        }
        /// <p>Node ID.</p>
        pub fn set_node_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGrant`.
    ///
    /// <p>Creates a grant for the specified license. A grant shares the use of license entitlements with specific Amazon Web Services accounts.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateGrant<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_grant_input::Builder,
    }
    impl<C, M, R> CreateGrant<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGrant`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGrantOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGrantError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGrantInputOperationOutputAlias,
                crate::output::CreateGrantOutput,
                crate::error::CreateGrantError,
                crate::input::CreateGrantInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Grant name.</p>
        pub fn grant_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_name(input.into());
            self
        }
        /// <p>Grant name.</p>
        pub fn set_grant_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_name(input);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn license_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_arn(input);
            self
        }
        /// Appends an item to `Principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>The grant principals.</p>
        pub fn principals(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principals(input.into());
            self
        }
        /// <p>The grant principals.</p>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_principals(input);
            self
        }
        /// <p>Home Region of the grant.</p>
        pub fn home_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.home_region(input.into());
            self
        }
        /// <p>Home Region of the grant.</p>
        pub fn set_home_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_home_region(input);
            self
        }
        /// Appends an item to `AllowedOperations`.
        ///
        /// To override the contents of this collection use [`set_allowed_operations`](Self::set_allowed_operations).
        ///
        /// <p>Allowed operations for the grant.</p>
        pub fn allowed_operations(mut self, input: crate::model::AllowedOperation) -> Self {
            self.inner = self.inner.allowed_operations(input);
            self
        }
        /// <p>Allowed operations for the grant.</p>
        pub fn set_allowed_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AllowedOperation>>,
        ) -> Self {
            self.inner = self.inner.set_allowed_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGrantVersion`.
    ///
    /// <p>Creates a new version of the specified grant.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateGrantVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_grant_version_input::Builder,
    }
    impl<C, M, R> CreateGrantVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGrantVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGrantVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGrantVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGrantVersionInputOperationOutputAlias,
                crate::output::CreateGrantVersionOutput,
                crate::error::CreateGrantVersionError,
                crate::input::CreateGrantVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn grant_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn set_grant_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_arn(input);
            self
        }
        /// <p>Grant name.</p>
        pub fn grant_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_name(input.into());
            self
        }
        /// <p>Grant name.</p>
        pub fn set_grant_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_name(input);
            self
        }
        /// Appends an item to `AllowedOperations`.
        ///
        /// To override the contents of this collection use [`set_allowed_operations`](Self::set_allowed_operations).
        ///
        /// <p>Allowed operations for the grant.</p>
        pub fn allowed_operations(mut self, input: crate::model::AllowedOperation) -> Self {
            self.inner = self.inner.allowed_operations(input);
            self
        }
        /// <p>Allowed operations for the grant.</p>
        pub fn set_allowed_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AllowedOperation>>,
        ) -> Self {
            self.inner = self.inner.set_allowed_operations(input);
            self
        }
        /// <p>Grant status.</p>
        pub fn status(mut self, input: crate::model::GrantStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>Grant status.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::GrantStatus>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>Grant status reason.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_reason(input.into());
            self
        }
        /// <p>Grant status reason.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_status_reason(input);
            self
        }
        /// <p>Current version of the grant.</p>
        pub fn source_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_version(input.into());
            self
        }
        /// <p>Current version of the grant.</p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLicense`.
    ///
    /// <p>Creates a license.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLicense<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_license_input::Builder,
    }
    impl<C, M, R> CreateLicense<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLicense`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLicenseOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLicenseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLicenseInputOperationOutputAlias,
                crate::output::CreateLicenseOutput,
                crate::error::CreateLicenseError,
                crate::input::CreateLicenseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>License name.</p>
        pub fn license_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_name(input.into());
            self
        }
        /// <p>License name.</p>
        pub fn set_license_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_name(input);
            self
        }
        /// <p>Product name.</p>
        pub fn product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_name(input.into());
            self
        }
        /// <p>Product name.</p>
        pub fn set_product_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_name(input);
            self
        }
        /// <p>Product SKU.</p>
        pub fn product_sku(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_sku(input.into());
            self
        }
        /// <p>Product SKU.</p>
        pub fn set_product_sku(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_sku(input);
            self
        }
        /// <p>License issuer.</p>
        pub fn issuer(mut self, input: crate::model::Issuer) -> Self {
            self.inner = self.inner.issuer(input);
            self
        }
        /// <p>License issuer.</p>
        pub fn set_issuer(mut self, input: std::option::Option<crate::model::Issuer>) -> Self {
            self.inner = self.inner.set_issuer(input);
            self
        }
        /// <p>Home Region for the license.</p>
        pub fn home_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.home_region(input.into());
            self
        }
        /// <p>Home Region for the license.</p>
        pub fn set_home_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_home_region(input);
            self
        }
        /// <p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>
        pub fn validity(mut self, input: crate::model::DatetimeRange) -> Self {
            self.inner = self.inner.validity(input);
            self
        }
        /// <p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>
        pub fn set_validity(
            mut self,
            input: std::option::Option<crate::model::DatetimeRange>,
        ) -> Self {
            self.inner = self.inner.set_validity(input);
            self
        }
        /// Appends an item to `Entitlements`.
        ///
        /// To override the contents of this collection use [`set_entitlements`](Self::set_entitlements).
        ///
        /// <p>License entitlements.</p>
        pub fn entitlements(mut self, input: crate::model::Entitlement) -> Self {
            self.inner = self.inner.entitlements(input);
            self
        }
        /// <p>License entitlements.</p>
        pub fn set_entitlements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Entitlement>>,
        ) -> Self {
            self.inner = self.inner.set_entitlements(input);
            self
        }
        /// <p>License beneficiary.</p>
        pub fn beneficiary(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.beneficiary(input.into());
            self
        }
        /// <p>License beneficiary.</p>
        pub fn set_beneficiary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_beneficiary(input);
            self
        }
        /// <p>Configuration for consumption of the license. Choose a provisional configuration for workloads running with continuous connectivity. Choose a borrow configuration for workloads with offline usage.</p>
        pub fn consumption_configuration(
            mut self,
            input: crate::model::ConsumptionConfiguration,
        ) -> Self {
            self.inner = self.inner.consumption_configuration(input);
            self
        }
        /// <p>Configuration for consumption of the license. Choose a provisional configuration for workloads running with continuous connectivity. Choose a borrow configuration for workloads with offline usage.</p>
        pub fn set_consumption_configuration(
            mut self,
            input: std::option::Option<crate::model::ConsumptionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_consumption_configuration(input);
            self
        }
        /// Appends an item to `LicenseMetadata`.
        ///
        /// To override the contents of this collection use [`set_license_metadata`](Self::set_license_metadata).
        ///
        /// <p>Information about the license.</p>
        pub fn license_metadata(mut self, input: crate::model::Metadata) -> Self {
            self.inner = self.inner.license_metadata(input);
            self
        }
        /// <p>Information about the license.</p>
        pub fn set_license_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
        ) -> Self {
            self.inner = self.inner.set_license_metadata(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLicenseConfiguration`.
    ///
    /// <p>Creates a license configuration.</p>
    /// <p>A license configuration is an abstraction of a customer license agreement that can be consumed and enforced by License Manager. Components include specifications for the license type (licensing by instance, socket, CPU, or vCPU), allowed tenancy (shared tenancy, Dedicated Instance, Dedicated Host, or all of these), license affinity to host (how long a license must be associated with a host), and the number of licenses purchased and used.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLicenseConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_license_configuration_input::Builder,
    }
    impl<C, M, R> CreateLicenseConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLicenseConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLicenseConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLicenseConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLicenseConfigurationInputOperationOutputAlias,
                crate::output::CreateLicenseConfigurationOutput,
                crate::error::CreateLicenseConfigurationError,
                crate::input::CreateLicenseConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the license configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>Name of the license configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Description of the license configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>Description of the license configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Dimension used to track the license inventory.</p>
        pub fn license_counting_type(mut self, input: crate::model::LicenseCountingType) -> Self {
            self.inner = self.inner.license_counting_type(input);
            self
        }
        /// <p>Dimension used to track the license inventory.</p>
        pub fn set_license_counting_type(
            mut self,
            input: std::option::Option<crate::model::LicenseCountingType>,
        ) -> Self {
            self.inner = self.inner.set_license_counting_type(input);
            self
        }
        /// <p>Number of licenses managed by the license configuration.</p>
        pub fn license_count(mut self, input: i64) -> Self {
            self.inner = self.inner.license_count(input);
            self
        }
        /// <p>Number of licenses managed by the license configuration.</p>
        pub fn set_license_count(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_license_count(input);
            self
        }
        /// <p>Indicates whether hard or soft license enforcement is used. Exceeding a hard limit blocks the launch of new instances.</p>
        pub fn license_count_hard_limit(mut self, input: bool) -> Self {
            self.inner = self.inner.license_count_hard_limit(input);
            self
        }
        /// <p>Indicates whether hard or soft license enforcement is used. Exceeding a hard limit blocks the launch of new instances.</p>
        pub fn set_license_count_hard_limit(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_license_count_hard_limit(input);
            self
        }
        /// Appends an item to `LicenseRules`.
        ///
        /// To override the contents of this collection use [`set_license_rules`](Self::set_license_rules).
        ///
        /// <p>License rules. The syntax is #name=value (for example, #allowedTenancy=EC2-DedicatedHost). The available rules vary by dimension, as follows.</p>
        /// <ul>
        /// <li> <p> <code>Cores</code> dimension: <code>allowedTenancy</code> | <code>licenseAffinityToHost</code> | <code>maximumCores</code> | <code>minimumCores</code> </p> </li>
        /// <li> <p> <code>Instances</code> dimension: <code>allowedTenancy</code> | <code>maximumCores</code> | <code>minimumCores</code> | <code>maximumSockets</code> | <code>minimumSockets</code> | <code>maximumVcpus</code> | <code>minimumVcpus</code> </p> </li>
        /// <li> <p> <code>Sockets</code> dimension: <code>allowedTenancy</code> | <code>licenseAffinityToHost</code> | <code>maximumSockets</code> | <code>minimumSockets</code> </p> </li>
        /// <li> <p> <code>vCPUs</code> dimension: <code>allowedTenancy</code> | <code>honorVcpuOptimization</code> | <code>maximumVcpus</code> | <code>minimumVcpus</code> </p> </li>
        /// </ul>
        /// <p>The unit for <code>licenseAffinityToHost</code> is days and the range is 1 to 180. The possible values for <code>allowedTenancy</code> are <code>EC2-Default</code>, <code>EC2-DedicatedHost</code>, and <code>EC2-DedicatedInstance</code>. The possible values for <code>honorVcpuOptimization</code> are <code>True</code> and <code>False</code>.</p>
        pub fn license_rules(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_rules(input.into());
            self
        }
        /// <p>License rules. The syntax is #name=value (for example, #allowedTenancy=EC2-DedicatedHost). The available rules vary by dimension, as follows.</p>
        /// <ul>
        /// <li> <p> <code>Cores</code> dimension: <code>allowedTenancy</code> | <code>licenseAffinityToHost</code> | <code>maximumCores</code> | <code>minimumCores</code> </p> </li>
        /// <li> <p> <code>Instances</code> dimension: <code>allowedTenancy</code> | <code>maximumCores</code> | <code>minimumCores</code> | <code>maximumSockets</code> | <code>minimumSockets</code> | <code>maximumVcpus</code> | <code>minimumVcpus</code> </p> </li>
        /// <li> <p> <code>Sockets</code> dimension: <code>allowedTenancy</code> | <code>licenseAffinityToHost</code> | <code>maximumSockets</code> | <code>minimumSockets</code> </p> </li>
        /// <li> <p> <code>vCPUs</code> dimension: <code>allowedTenancy</code> | <code>honorVcpuOptimization</code> | <code>maximumVcpus</code> | <code>minimumVcpus</code> </p> </li>
        /// </ul>
        /// <p>The unit for <code>licenseAffinityToHost</code> is days and the range is 1 to 180. The possible values for <code>allowedTenancy</code> are <code>EC2-Default</code>, <code>EC2-DedicatedHost</code>, and <code>EC2-DedicatedInstance</code>. The possible values for <code>honorVcpuOptimization</code> are <code>True</code> and <code>False</code>.</p>
        pub fn set_license_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_license_rules(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to add to the license configuration.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags to add to the license configuration.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>When true, disassociates a resource when software is uninstalled.</p>
        pub fn disassociate_when_not_found(mut self, input: bool) -> Self {
            self.inner = self.inner.disassociate_when_not_found(input);
            self
        }
        /// <p>When true, disassociates a resource when software is uninstalled.</p>
        pub fn set_disassociate_when_not_found(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disassociate_when_not_found(input);
            self
        }
        /// Appends an item to `ProductInformationList`.
        ///
        /// To override the contents of this collection use [`set_product_information_list`](Self::set_product_information_list).
        ///
        /// <p>Product information.</p>
        pub fn product_information_list(mut self, input: crate::model::ProductInformation) -> Self {
            self.inner = self.inner.product_information_list(input);
            self
        }
        /// <p>Product information.</p>
        pub fn set_product_information_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProductInformation>>,
        ) -> Self {
            self.inner = self.inner.set_product_information_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLicenseConversionTaskForResource`.
    ///
    /// <p>Creates a new license conversion task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLicenseConversionTaskForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_license_conversion_task_for_resource_input::Builder,
    }
    impl<C, M, R> CreateLicenseConversionTaskForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLicenseConversionTaskForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLicenseConversionTaskForResourceOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateLicenseConversionTaskForResourceError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLicenseConversionTaskForResourceInputOperationOutputAlias,
                crate::output::CreateLicenseConversionTaskForResourceOutput,
                crate::error::CreateLicenseConversionTaskForResourceError,
                crate::input::CreateLicenseConversionTaskForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the resource you are converting the license type for.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the resource you are converting the license type for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>Information that identifies the license type you are converting from. For the structure of the source license, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli">Convert a license type using the AWS CLI</a> in the <i>License Manager User Guide</i>.</p>
        pub fn source_license_context(
            mut self,
            input: crate::model::LicenseConversionContext,
        ) -> Self {
            self.inner = self.inner.source_license_context(input);
            self
        }
        /// <p>Information that identifies the license type you are converting from. For the structure of the source license, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli">Convert a license type using the AWS CLI</a> in the <i>License Manager User Guide</i>.</p>
        pub fn set_source_license_context(
            mut self,
            input: std::option::Option<crate::model::LicenseConversionContext>,
        ) -> Self {
            self.inner = self.inner.set_source_license_context(input);
            self
        }
        /// <p>Information that identifies the license type you are converting to. For the structure of the destination license, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli">Convert a license type using the AWS CLI</a> in the <i>License Manager User Guide</i>.</p>
        pub fn destination_license_context(
            mut self,
            input: crate::model::LicenseConversionContext,
        ) -> Self {
            self.inner = self.inner.destination_license_context(input);
            self
        }
        /// <p>Information that identifies the license type you are converting to. For the structure of the destination license, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli">Convert a license type using the AWS CLI</a> in the <i>License Manager User Guide</i>.</p>
        pub fn set_destination_license_context(
            mut self,
            input: std::option::Option<crate::model::LicenseConversionContext>,
        ) -> Self {
            self.inner = self.inner.set_destination_license_context(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLicenseManagerReportGenerator`.
    ///
    /// <p>Creates a report generator.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLicenseManagerReportGenerator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_license_manager_report_generator_input::Builder,
    }
    impl<C, M, R> CreateLicenseManagerReportGenerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLicenseManagerReportGenerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLicenseManagerReportGeneratorOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateLicenseManagerReportGeneratorError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLicenseManagerReportGeneratorInputOperationOutputAlias,
                crate::output::CreateLicenseManagerReportGeneratorOutput,
                crate::error::CreateLicenseManagerReportGeneratorError,
                crate::input::CreateLicenseManagerReportGeneratorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the report generator.</p>
        pub fn report_generator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_generator_name(input.into());
            self
        }
        /// <p>Name of the report generator.</p>
        pub fn set_report_generator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_report_generator_name(input);
            self
        }
        /// Appends an item to `Type`.
        ///
        /// To override the contents of this collection use [`set_type`](Self::set_type).
        ///
        /// <p>Type of reports to generate. The following report types an be generated:</p>
        /// <ul>
        /// <li> <p>License configuration report - Reports the number and details of consumed licenses for a license configuration.</p> </li>
        /// <li> <p>Resource report - Reports the tracked licenses and resource consumption for a license configuration.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ReportType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>Type of reports to generate. The following report types an be generated:</p>
        /// <ul>
        /// <li> <p>License configuration report - Reports the number and details of consumed licenses for a license configuration.</p> </li>
        /// <li> <p>Resource report - Reports the tracked licenses and resource consumption for a license configuration.</p> </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReportType>>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>Defines the type of license configuration the report generator tracks.</p>
        pub fn report_context(mut self, input: crate::model::ReportContext) -> Self {
            self.inner = self.inner.report_context(input);
            self
        }
        /// <p>Defines the type of license configuration the report generator tracks.</p>
        pub fn set_report_context(
            mut self,
            input: std::option::Option<crate::model::ReportContext>,
        ) -> Self {
            self.inner = self.inner.set_report_context(input);
            self
        }
        /// <p>Frequency by which reports are generated. Reports can be generated daily, monthly, or weekly.</p>
        pub fn report_frequency(mut self, input: crate::model::ReportFrequency) -> Self {
            self.inner = self.inner.report_frequency(input);
            self
        }
        /// <p>Frequency by which reports are generated. Reports can be generated daily, monthly, or weekly.</p>
        pub fn set_report_frequency(
            mut self,
            input: std::option::Option<crate::model::ReportFrequency>,
        ) -> Self {
            self.inner = self.inner.set_report_frequency(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Description of the report generator.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>Description of the report generator.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to add to the report generator.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags to add to the report generator.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLicenseVersion`.
    ///
    /// <p>Creates a new version of the specified license.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateLicenseVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_license_version_input::Builder,
    }
    impl<C, M, R> CreateLicenseVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLicenseVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLicenseVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLicenseVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLicenseVersionInputOperationOutputAlias,
                crate::output::CreateLicenseVersionOutput,
                crate::error::CreateLicenseVersionError,
                crate::input::CreateLicenseVersionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn license_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_arn(input);
            self
        }
        /// <p>License name.</p>
        pub fn license_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_name(input.into());
            self
        }
        /// <p>License name.</p>
        pub fn set_license_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_name(input);
            self
        }
        /// <p>Product name.</p>
        pub fn product_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_name(input.into());
            self
        }
        /// <p>Product name.</p>
        pub fn set_product_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_name(input);
            self
        }
        /// <p>License issuer.</p>
        pub fn issuer(mut self, input: crate::model::Issuer) -> Self {
            self.inner = self.inner.issuer(input);
            self
        }
        /// <p>License issuer.</p>
        pub fn set_issuer(mut self, input: std::option::Option<crate::model::Issuer>) -> Self {
            self.inner = self.inner.set_issuer(input);
            self
        }
        /// <p>Home Region of the license.</p>
        pub fn home_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.home_region(input.into());
            self
        }
        /// <p>Home Region of the license.</p>
        pub fn set_home_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_home_region(input);
            self
        }
        /// <p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>
        pub fn validity(mut self, input: crate::model::DatetimeRange) -> Self {
            self.inner = self.inner.validity(input);
            self
        }
        /// <p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>
        pub fn set_validity(
            mut self,
            input: std::option::Option<crate::model::DatetimeRange>,
        ) -> Self {
            self.inner = self.inner.set_validity(input);
            self
        }
        /// Appends an item to `LicenseMetadata`.
        ///
        /// To override the contents of this collection use [`set_license_metadata`](Self::set_license_metadata).
        ///
        /// <p>Information about the license.</p>
        pub fn license_metadata(mut self, input: crate::model::Metadata) -> Self {
            self.inner = self.inner.license_metadata(input);
            self
        }
        /// <p>Information about the license.</p>
        pub fn set_license_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
        ) -> Self {
            self.inner = self.inner.set_license_metadata(input);
            self
        }
        /// Appends an item to `Entitlements`.
        ///
        /// To override the contents of this collection use [`set_entitlements`](Self::set_entitlements).
        ///
        /// <p>License entitlements.</p>
        pub fn entitlements(mut self, input: crate::model::Entitlement) -> Self {
            self.inner = self.inner.entitlements(input);
            self
        }
        /// <p>License entitlements.</p>
        pub fn set_entitlements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Entitlement>>,
        ) -> Self {
            self.inner = self.inner.set_entitlements(input);
            self
        }
        /// <p>Configuration for consumption of the license. Choose a provisional configuration for workloads running with continuous connectivity. Choose a borrow configuration for workloads with offline usage.</p>
        pub fn consumption_configuration(
            mut self,
            input: crate::model::ConsumptionConfiguration,
        ) -> Self {
            self.inner = self.inner.consumption_configuration(input);
            self
        }
        /// <p>Configuration for consumption of the license. Choose a provisional configuration for workloads running with continuous connectivity. Choose a borrow configuration for workloads with offline usage.</p>
        pub fn set_consumption_configuration(
            mut self,
            input: std::option::Option<crate::model::ConsumptionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_consumption_configuration(input);
            self
        }
        /// <p>License status.</p>
        pub fn status(mut self, input: crate::model::LicenseStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>License status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::LicenseStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Current version of the license.</p>
        pub fn source_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_version(input.into());
            self
        }
        /// <p>Current version of the license.</p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateToken`.
    ///
    /// <p>Creates a long-lived token.</p>
    /// <p>A refresh token is a JWT token used to get an access token. With an access token, you can call AssumeRoleWithWebIdentity to get role credentials that you can use to call License Manager to manage the specified license.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateToken<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_token_input::Builder,
    }
    impl<C, M, R> CreateToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTokenInputOperationOutputAlias,
                crate::output::CreateTokenOutput,
                crate::error::CreateTokenError,
                crate::input::CreateTokenInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license. The ARN is mapped to the aud claim of the JWT token.</p>
        pub fn license_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license. The ARN is mapped to the aud claim of the JWT token.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_arn(input);
            self
        }
        /// Appends an item to `RoleArns`.
        ///
        /// To override the contents of this collection use [`set_role_arns`](Self::set_role_arns).
        ///
        /// <p>Amazon Resource Name (ARN) of the IAM roles to embed in the token. License Manager does not check whether the roles are in use.</p>
        pub fn role_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arns(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the IAM roles to embed in the token. License Manager does not check whether the roles are in use.</p>
        pub fn set_role_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_role_arns(input);
            self
        }
        /// <p>Token expiration, in days, counted from token creation. The default is 365 days.</p>
        pub fn expiration_in_days(mut self, input: i32) -> Self {
            self.inner = self.inner.expiration_in_days(input);
            self
        }
        /// <p>Token expiration, in days, counted from token creation. The default is 365 days.</p>
        pub fn set_expiration_in_days(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_expiration_in_days(input);
            self
        }
        /// Appends an item to `TokenProperties`.
        ///
        /// To override the contents of this collection use [`set_token_properties`](Self::set_token_properties).
        ///
        /// <p>Data specified by the caller to be included in the JWT token. The data is mapped to the amr claim of the JWT token.</p>
        pub fn token_properties(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token_properties(input.into());
            self
        }
        /// <p>Data specified by the caller to be included in the JWT token. The data is mapped to the amr claim of the JWT token.</p>
        pub fn set_token_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_token_properties(input);
            self
        }
        /// <p>Idempotency token, valid for 10 minutes.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Idempotency token, valid for 10 minutes.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGrant`.
    ///
    /// <p>Deletes the specified grant.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteGrant<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_grant_input::Builder,
    }
    impl<C, M, R> DeleteGrant<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGrant`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGrantOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGrantError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGrantInputOperationOutputAlias,
                crate::output::DeleteGrantOutput,
                crate::error::DeleteGrantError,
                crate::input::DeleteGrantInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn grant_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn set_grant_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_arn(input);
            self
        }
        /// <p>The Status reason for the delete request.</p>
        pub fn status_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_reason(input.into());
            self
        }
        /// <p>The Status reason for the delete request.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_status_reason(input);
            self
        }
        /// <p>Current version of the grant.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>Current version of the grant.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLicense`.
    ///
    /// <p>Deletes the specified license.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLicense<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_license_input::Builder,
    }
    impl<C, M, R> DeleteLicense<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLicense`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLicenseOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLicenseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLicenseInputOperationOutputAlias,
                crate::output::DeleteLicenseOutput,
                crate::error::DeleteLicenseError,
                crate::input::DeleteLicenseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn license_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_arn(input);
            self
        }
        /// <p>Current version of the license.</p>
        pub fn source_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_version(input.into());
            self
        }
        /// <p>Current version of the license.</p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLicenseConfiguration`.
    ///
    /// <p>Deletes the specified license configuration.</p>
    /// <p>You cannot delete a license configuration that is in use.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLicenseConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_license_configuration_input::Builder,
    }
    impl<C, M, R> DeleteLicenseConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLicenseConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLicenseConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLicenseConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLicenseConfigurationInputOperationOutputAlias,
                crate::output::DeleteLicenseConfigurationOutput,
                crate::error::DeleteLicenseConfigurationError,
                crate::input::DeleteLicenseConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ID of the license configuration.</p>
        pub fn license_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_configuration_arn(input.into());
            self
        }
        /// <p>ID of the license configuration.</p>
        pub fn set_license_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_configuration_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLicenseManagerReportGenerator`.
    ///
    /// <p>Deletes the specified report generator.</p>
    /// <p>This action deletes the report generator, which stops it from generating future reports. The action cannot be reversed. It has no effect on the previous reports from this generator.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteLicenseManagerReportGenerator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_license_manager_report_generator_input::Builder,
    }
    impl<C, M, R> DeleteLicenseManagerReportGenerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLicenseManagerReportGenerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLicenseManagerReportGeneratorOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteLicenseManagerReportGeneratorError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLicenseManagerReportGeneratorInputOperationOutputAlias,
                crate::output::DeleteLicenseManagerReportGeneratorOutput,
                crate::error::DeleteLicenseManagerReportGeneratorError,
                crate::input::DeleteLicenseManagerReportGeneratorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the report generator to be deleted.</p>
        pub fn license_manager_report_generator_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .license_manager_report_generator_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the report generator to be deleted.</p>
        pub fn set_license_manager_report_generator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_manager_report_generator_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteToken`.
    ///
    /// <p>Deletes the specified token. Must be called in the license home Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteToken<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_token_input::Builder,
    }
    impl<C, M, R> DeleteToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTokenInputOperationOutputAlias,
                crate::output::DeleteTokenOutput,
                crate::error::DeleteTokenError,
                crate::input::DeleteTokenInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Token ID.</p>
        pub fn token_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token_id(input.into());
            self
        }
        /// <p>Token ID.</p>
        pub fn set_token_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExtendLicenseConsumption`.
    ///
    /// <p>Extends the expiration date for license consumption.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExtendLicenseConsumption<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::extend_license_consumption_input::Builder,
    }
    impl<C, M, R> ExtendLicenseConsumption<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExtendLicenseConsumption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExtendLicenseConsumptionOutput,
            aws_smithy_http::result::SdkError<crate::error::ExtendLicenseConsumptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExtendLicenseConsumptionInputOperationOutputAlias,
                crate::output::ExtendLicenseConsumptionOutput,
                crate::error::ExtendLicenseConsumptionError,
                crate::input::ExtendLicenseConsumptionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>License consumption token.</p>
        pub fn license_consumption_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_consumption_token(input.into());
            self
        }
        /// <p>License consumption token.</p>
        pub fn set_license_consumption_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_consumption_token(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request. Provides an error response if you do not have the required permissions.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request. Provides an error response if you do not have the required permissions.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccessToken`.
    ///
    /// <p>Gets a temporary access token to use with AssumeRoleWithWebIdentity. Access tokens are valid for one hour.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAccessToken<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_access_token_input::Builder,
    }
    impl<C, M, R> GetAccessToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccessToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccessTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccessTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccessTokenInputOperationOutputAlias,
                crate::output::GetAccessTokenOutput,
                crate::error::GetAccessTokenError,
                crate::input::GetAccessTokenInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Refresh token, encoded as a JWT token.</p>
        pub fn token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(input.into());
            self
        }
        /// <p>Refresh token, encoded as a JWT token.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
        /// Appends an item to `TokenProperties`.
        ///
        /// To override the contents of this collection use [`set_token_properties`](Self::set_token_properties).
        ///
        /// <p>Token properties to validate against those present in the JWT token.</p>
        pub fn token_properties(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token_properties(input.into());
            self
        }
        /// <p>Token properties to validate against those present in the JWT token.</p>
        pub fn set_token_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_token_properties(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGrant`.
    ///
    /// <p>Gets detailed information about the specified grant.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetGrant<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_grant_input::Builder,
    }
    impl<C, M, R> GetGrant<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGrant`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGrantOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGrantError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGrantInputOperationOutputAlias,
                crate::output::GetGrantOutput,
                crate::error::GetGrantError,
                crate::input::GetGrantInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn grant_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn set_grant_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_arn(input);
            self
        }
        /// <p>Grant version.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>Grant version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLicense`.
    ///
    /// <p>Gets detailed information about the specified license.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLicense<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_license_input::Builder,
    }
    impl<C, M, R> GetLicense<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLicense`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLicenseOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLicenseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLicenseInputOperationOutputAlias,
                crate::output::GetLicenseOutput,
                crate::error::GetLicenseError,
                crate::input::GetLicenseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn license_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_arn(input);
            self
        }
        /// <p>License version.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(input.into());
            self
        }
        /// <p>License version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLicenseConfiguration`.
    ///
    /// <p>Gets detailed information about the specified license configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLicenseConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_license_configuration_input::Builder,
    }
    impl<C, M, R> GetLicenseConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLicenseConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLicenseConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLicenseConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLicenseConfigurationInputOperationOutputAlias,
                crate::output::GetLicenseConfigurationOutput,
                crate::error::GetLicenseConfigurationError,
                crate::input::GetLicenseConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn license_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_configuration_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn set_license_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_configuration_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLicenseConversionTask`.
    ///
    /// <p>Gets information about the specified license type conversion task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLicenseConversionTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_license_conversion_task_input::Builder,
    }
    impl<C, M, R> GetLicenseConversionTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLicenseConversionTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLicenseConversionTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLicenseConversionTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLicenseConversionTaskInputOperationOutputAlias,
                crate::output::GetLicenseConversionTaskOutput,
                crate::error::GetLicenseConversionTaskError,
                crate::input::GetLicenseConversionTaskInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ID of the license type conversion task to retrieve information on.</p>
        pub fn license_conversion_task_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_conversion_task_id(input.into());
            self
        }
        /// <p>ID of the license type conversion task to retrieve information on.</p>
        pub fn set_license_conversion_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_conversion_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLicenseManagerReportGenerator`.
    ///
    /// <p>Gets information about the specified report generator.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLicenseManagerReportGenerator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_license_manager_report_generator_input::Builder,
    }
    impl<C, M, R> GetLicenseManagerReportGenerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLicenseManagerReportGenerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLicenseManagerReportGeneratorOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLicenseManagerReportGeneratorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLicenseManagerReportGeneratorInputOperationOutputAlias,
                crate::output::GetLicenseManagerReportGeneratorOutput,
                crate::error::GetLicenseManagerReportGeneratorError,
                crate::input::GetLicenseManagerReportGeneratorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the report generator.</p>
        pub fn license_manager_report_generator_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .license_manager_report_generator_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the report generator.</p>
        pub fn set_license_manager_report_generator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_manager_report_generator_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLicenseUsage`.
    ///
    /// <p>Gets detailed information about the usage of the specified license.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetLicenseUsage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_license_usage_input::Builder,
    }
    impl<C, M, R> GetLicenseUsage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLicenseUsage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLicenseUsageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLicenseUsageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLicenseUsageInputOperationOutputAlias,
                crate::output::GetLicenseUsageOutput,
                crate::error::GetLicenseUsageError,
                crate::input::GetLicenseUsageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn license_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServiceSettings`.
    ///
    /// <p>Gets the License Manager settings for the current Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetServiceSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_service_settings_input::Builder,
    }
    impl<C, M, R> GetServiceSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetServiceSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServiceSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServiceSettingsInputOperationOutputAlias,
                crate::output::GetServiceSettingsOutput,
                crate::error::GetServiceSettingsError,
                crate::input::GetServiceSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListAssociationsForLicenseConfiguration`.
    ///
    /// <p>Lists the resource associations for the specified license configuration.</p>
    /// <p>Resource associations need not consume licenses from a license configuration. For example, an AMI or a stopped instance might not consume a license (depending on the license rules).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAssociationsForLicenseConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_associations_for_license_configuration_input::Builder,
    }
    impl<C, M, R> ListAssociationsForLicenseConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssociationsForLicenseConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssociationsForLicenseConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListAssociationsForLicenseConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssociationsForLicenseConfigurationInputOperationOutputAlias,
                crate::output::ListAssociationsForLicenseConfigurationOutput,
                crate::error::ListAssociationsForLicenseConfigurationError,
                crate::input::ListAssociationsForLicenseConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of a license configuration.</p>
        pub fn license_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_configuration_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of a license configuration.</p>
        pub fn set_license_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_configuration_arn(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDistributedGrants`.
    ///
    /// <p>Lists the grants distributed for the specified license.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDistributedGrants<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_distributed_grants_input::Builder,
    }
    impl<C, M, R> ListDistributedGrants<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDistributedGrants`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDistributedGrantsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDistributedGrantsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDistributedGrantsInputOperationOutputAlias,
                crate::output::ListDistributedGrantsOutput,
                crate::error::ListDistributedGrantsError,
                crate::input::ListDistributedGrantsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `GrantArns`.
        ///
        /// To override the contents of this collection use [`set_grant_arns`](Self::set_grant_arns).
        ///
        /// <p>Amazon Resource Names (ARNs) of the grants.</p>
        pub fn grant_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_arns(input.into());
            self
        }
        /// <p>Amazon Resource Names (ARNs) of the grants.</p>
        pub fn set_grant_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_grant_arns(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li> <p> <code>LicenseArn</code> </p> </li>
        /// <li> <p> <code>GrantStatus</code> </p> </li>
        /// <li> <p> <code>GranteePrincipalARN</code> </p> </li>
        /// <li> <p> <code>ProductSKU</code> </p> </li>
        /// <li> <p> <code>LicenseIssuerName</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li> <p> <code>LicenseArn</code> </p> </li>
        /// <li> <p> <code>GrantStatus</code> </p> </li>
        /// <li> <p> <code>GranteePrincipalARN</code> </p> </li>
        /// <li> <p> <code>ProductSKU</code> </p> </li>
        /// <li> <p> <code>LicenseIssuerName</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFailuresForLicenseConfigurationOperations`.
    ///
    /// <p>Lists the license configuration operations that failed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFailuresForLicenseConfigurationOperations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_failures_for_license_configuration_operations_input::Builder,
    }
    impl<C, M, R> ListFailuresForLicenseConfigurationOperations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFailuresForLicenseConfigurationOperations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::ListFailuresForLicenseConfigurationOperationsOutput, aws_smithy_http::result::SdkError<crate::error::ListFailuresForLicenseConfigurationOperationsError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::ListFailuresForLicenseConfigurationOperationsInputOperationOutputAlias,
                                    crate::output::ListFailuresForLicenseConfigurationOperationsOutput,
                                    crate::error::ListFailuresForLicenseConfigurationOperationsError,
                                    crate::input::ListFailuresForLicenseConfigurationOperationsInputOperationRetryAlias>,
                                {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name of the license configuration.</p>
        pub fn license_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_configuration_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name of the license configuration.</p>
        pub fn set_license_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_configuration_arn(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLicenseConfigurations`.
    ///
    /// <p>Lists the license configurations for your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLicenseConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_license_configurations_input::Builder,
    }
    impl<C, M, R> ListLicenseConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLicenseConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLicenseConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLicenseConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLicenseConfigurationsInputOperationOutputAlias,
                crate::output::ListLicenseConfigurationsOutput,
                crate::error::ListLicenseConfigurationsError,
                crate::input::ListLicenseConfigurationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `LicenseConfigurationArns`.
        ///
        /// To override the contents of this collection use [`set_license_configuration_arns`](Self::set_license_configuration_arns).
        ///
        /// <p>Amazon Resource Names (ARN) of the license configurations.</p>
        pub fn license_configuration_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_configuration_arns(input.into());
            self
        }
        /// <p>Amazon Resource Names (ARN) of the license configurations.</p>
        pub fn set_license_configuration_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_license_configuration_arns(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters and logical operators are supported:</p>
        /// <ul>
        /// <li> <p> <code>licenseCountingType</code> - The dimension for which licenses are counted. Possible values are <code>vCPU</code> | <code>Instance</code> | <code>Core</code> | <code>Socket</code>. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>enforceLicenseCount</code> - A Boolean value that indicates whether hard license enforcement is used. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>usagelimitExceeded</code> - A Boolean value that indicates whether the available licenses have been exceeded. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters to scope the results. The following filters and logical operators are supported:</p>
        /// <ul>
        /// <li> <p> <code>licenseCountingType</code> - The dimension for which licenses are counted. Possible values are <code>vCPU</code> | <code>Instance</code> | <code>Core</code> | <code>Socket</code>. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>enforceLicenseCount</code> - A Boolean value that indicates whether hard license enforcement is used. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>usagelimitExceeded</code> - A Boolean value that indicates whether the available licenses have been exceeded. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLicenseConversionTasks`.
    ///
    /// <p>Lists the license type conversion tasks for your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLicenseConversionTasks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_license_conversion_tasks_input::Builder,
    }
    impl<C, M, R> ListLicenseConversionTasks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLicenseConversionTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLicenseConversionTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLicenseConversionTasksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLicenseConversionTasksInputOperationOutputAlias,
                crate::output::ListLicenseConversionTasksOutput,
                crate::error::ListLicenseConversionTasksError,
                crate::input::ListLicenseConversionTasksInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p> Filters to scope the results. Valid filters are <code>ResourceArns</code> and <code>Status</code>. </p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p> Filters to scope the results. Valid filters are <code>ResourceArns</code> and <code>Status</code>. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLicenseManagerReportGenerators`.
    ///
    /// <p>Lists the report generators for your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLicenseManagerReportGenerators<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_license_manager_report_generators_input::Builder,
    }
    impl<C, M, R> ListLicenseManagerReportGenerators<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLicenseManagerReportGenerators`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLicenseManagerReportGeneratorsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListLicenseManagerReportGeneratorsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLicenseManagerReportGeneratorsInputOperationOutputAlias,
                crate::output::ListLicenseManagerReportGeneratorsOutput,
                crate::error::ListLicenseManagerReportGeneratorsError,
                crate::input::ListLicenseManagerReportGeneratorsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters are supported: </p>
        /// <ul>
        /// <li> <p> <code>LicenseConfigurationArn</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters to scope the results. The following filters are supported: </p>
        /// <ul>
        /// <li> <p> <code>LicenseConfigurationArn</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLicenses`.
    ///
    /// <p>Lists the licenses for your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLicenses<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_licenses_input::Builder,
    }
    impl<C, M, R> ListLicenses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLicenses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLicensesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLicensesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLicensesInputOperationOutputAlias,
                crate::output::ListLicensesOutput,
                crate::error::ListLicensesError,
                crate::input::ListLicensesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `LicenseArns`.
        ///
        /// To override the contents of this collection use [`set_license_arns`](Self::set_license_arns).
        ///
        /// <p>Amazon Resource Names (ARNs) of the licenses.</p>
        pub fn license_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_arns(input.into());
            self
        }
        /// <p>Amazon Resource Names (ARNs) of the licenses.</p>
        pub fn set_license_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_license_arns(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li> <p> <code>Beneficiary</code> </p> </li>
        /// <li> <p> <code>ProductSKU</code> </p> </li>
        /// <li> <p> <code>Fingerprint</code> </p> </li>
        /// <li> <p> <code>Status</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li> <p> <code>Beneficiary</code> </p> </li>
        /// <li> <p> <code>ProductSKU</code> </p> </li>
        /// <li> <p> <code>Fingerprint</code> </p> </li>
        /// <li> <p> <code>Status</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLicenseSpecificationsForResource`.
    ///
    /// <p>Describes the license configurations for the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLicenseSpecificationsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_license_specifications_for_resource_input::Builder,
    }
    impl<C, M, R> ListLicenseSpecificationsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLicenseSpecificationsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLicenseSpecificationsForResourceOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListLicenseSpecificationsForResourceError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLicenseSpecificationsForResourceInputOperationOutputAlias,
                crate::output::ListLicenseSpecificationsForResourceOutput,
                crate::error::ListLicenseSpecificationsForResourceError,
                crate::input::ListLicenseSpecificationsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of a resource that has an associated license configuration.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of a resource that has an associated license configuration.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLicenseVersions`.
    ///
    /// <p>Lists all versions of the specified license.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLicenseVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_license_versions_input::Builder,
    }
    impl<C, M, R> ListLicenseVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLicenseVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLicenseVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLicenseVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLicenseVersionsInputOperationOutputAlias,
                crate::output::ListLicenseVersionsOutput,
                crate::error::ListLicenseVersionsError,
                crate::input::ListLicenseVersionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn license_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_arn(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReceivedGrants`.
    ///
    /// <p>Lists grants that are received but not accepted.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListReceivedGrants<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_received_grants_input::Builder,
    }
    impl<C, M, R> ListReceivedGrants<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListReceivedGrants`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReceivedGrantsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReceivedGrantsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListReceivedGrantsInputOperationOutputAlias,
                crate::output::ListReceivedGrantsOutput,
                crate::error::ListReceivedGrantsError,
                crate::input::ListReceivedGrantsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `GrantArns`.
        ///
        /// To override the contents of this collection use [`set_grant_arns`](Self::set_grant_arns).
        ///
        /// <p>Amazon Resource Names (ARNs) of the grants.</p>
        pub fn grant_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_arns(input.into());
            self
        }
        /// <p>Amazon Resource Names (ARNs) of the grants.</p>
        pub fn set_grant_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_grant_arns(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li> <p> <code>ProductSKU</code> </p> </li>
        /// <li> <p> <code>LicenseIssuerName</code> </p> </li>
        /// <li> <p> <code>LicenseArn</code> </p> </li>
        /// <li> <p> <code>GrantStatus</code> </p> </li>
        /// <li> <p> <code>GranterAccountId</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li> <p> <code>ProductSKU</code> </p> </li>
        /// <li> <p> <code>LicenseIssuerName</code> </p> </li>
        /// <li> <p> <code>LicenseArn</code> </p> </li>
        /// <li> <p> <code>GrantStatus</code> </p> </li>
        /// <li> <p> <code>GranterAccountId</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReceivedLicenses`.
    ///
    /// <p>Lists received licenses.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListReceivedLicenses<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_received_licenses_input::Builder,
    }
    impl<C, M, R> ListReceivedLicenses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListReceivedLicenses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReceivedLicensesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReceivedLicensesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListReceivedLicensesInputOperationOutputAlias,
                crate::output::ListReceivedLicensesOutput,
                crate::error::ListReceivedLicensesError,
                crate::input::ListReceivedLicensesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `LicenseArns`.
        ///
        /// To override the contents of this collection use [`set_license_arns`](Self::set_license_arns).
        ///
        /// <p>Amazon Resource Names (ARNs) of the licenses.</p>
        pub fn license_arns(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_arns(input.into());
            self
        }
        /// <p>Amazon Resource Names (ARNs) of the licenses.</p>
        pub fn set_license_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_license_arns(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li> <p> <code>ProductSKU</code> </p> </li>
        /// <li> <p> <code>Status</code> </p> </li>
        /// <li> <p> <code>Fingerprint</code> </p> </li>
        /// <li> <p> <code>IssuerName</code> </p> </li>
        /// <li> <p> <code>Beneficiary</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li> <p> <code>ProductSKU</code> </p> </li>
        /// <li> <p> <code>Status</code> </p> </li>
        /// <li> <p> <code>Fingerprint</code> </p> </li>
        /// <li> <p> <code>IssuerName</code> </p> </li>
        /// <li> <p> <code>Beneficiary</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourceInventory`.
    ///
    /// <p>Lists resources managed using Systems Manager inventory.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListResourceInventory<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resource_inventory_input::Builder,
    }
    impl<C, M, R> ListResourceInventory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResourceInventory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourceInventoryOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourceInventoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResourceInventoryInputOperationOutputAlias,
                crate::output::ListResourceInventoryOutput,
                crate::error::ListResourceInventoryError,
                crate::input::ListResourceInventoryInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters and logical operators are supported:</p>
        /// <ul>
        /// <li> <p> <code>account_id</code> - The ID of the Amazon Web Services account that owns the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>application_name</code> - The name of the application. Logical operators are <code>EQUALS</code> | <code>BEGINS_WITH</code>.</p> </li>
        /// <li> <p> <code>license_included</code> - The type of license included. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>. Possible values are <code>sql-server-enterprise</code> | <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.</p> </li>
        /// <li> <p> <code>platform</code> - The platform of the resource. Logical operators are <code>EQUALS</code> | <code>BEGINS_WITH</code>.</p> </li>
        /// <li> <p> <code>resource_id</code> - The ID of the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>tag:
        /// <key></key></code> - The key/value combination of a tag assigned to the resource. Logical operators are <code>EQUALS</code> (single account) or <code>EQUALS</code> | <code>NOT_EQUALS</code> (cross account).</p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::InventoryFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters to scope the results. The following filters and logical operators are supported:</p>
        /// <ul>
        /// <li> <p> <code>account_id</code> - The ID of the Amazon Web Services account that owns the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>application_name</code> - The name of the application. Logical operators are <code>EQUALS</code> | <code>BEGINS_WITH</code>.</p> </li>
        /// <li> <p> <code>license_included</code> - The type of license included. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>. Possible values are <code>sql-server-enterprise</code> | <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.</p> </li>
        /// <li> <p> <code>platform</code> - The platform of the resource. Logical operators are <code>EQUALS</code> | <code>BEGINS_WITH</code>.</p> </li>
        /// <li> <p> <code>resource_id</code> - The ID of the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>tag:
        /// <key></key></code> - The key/value combination of a tag assigned to the resource. Logical operators are <code>EQUALS</code> (single account) or <code>EQUALS</code> | <code>NOT_EQUALS</code> (cross account).</p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags for the specified license configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTokens`.
    ///
    /// <p>Lists your tokens.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTokens<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tokens_input::Builder,
    }
    impl<C, M, R> ListTokens<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTokens`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTokensOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTokensError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTokensInputOperationOutputAlias,
                crate::output::ListTokensOutput,
                crate::error::ListTokensError,
                crate::input::ListTokensInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TokenIds`.
        ///
        /// To override the contents of this collection use [`set_token_ids`](Self::set_token_ids).
        ///
        /// <p>Token IDs.</p>
        pub fn token_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token_ids(input.into());
            self
        }
        /// <p>Token IDs.</p>
        pub fn set_token_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_token_ids(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filter is supported:</p>
        /// <ul>
        /// <li> <p> <code>LicenseArns</code> </p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters to scope the results. The following filter is supported:</p>
        /// <ul>
        /// <li> <p> <code>LicenseArns</code> </p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUsageForLicenseConfiguration`.
    ///
    /// <p>Lists all license usage records for a license configuration, displaying license consumption details by resource at a selected point in time. Use this action to audit the current license consumption for any license inventory and configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListUsageForLicenseConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_usage_for_license_configuration_input::Builder,
    }
    impl<C, M, R> ListUsageForLicenseConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUsageForLicenseConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUsageForLicenseConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUsageForLicenseConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUsageForLicenseConfigurationInputOperationOutputAlias,
                crate::output::ListUsageForLicenseConfigurationOutput,
                crate::error::ListUsageForLicenseConfigurationError,
                crate::input::ListUsageForLicenseConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn license_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_configuration_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn set_license_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_configuration_arn(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters and logical operators are supported:</p>
        /// <ul>
        /// <li> <p> <code>resourceArn</code> - The ARN of the license configuration resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>resourceType</code> - The resource type (<code>EC2_INSTANCE</code> | <code>EC2_HOST</code> | <code>EC2_AMI</code> | <code>SYSTEMS_MANAGER_MANAGED_INSTANCE</code>). Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>resourceAccount</code> - The ID of the account that owns the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>Filters to scope the results. The following filters and logical operators are supported:</p>
        /// <ul>
        /// <li> <p> <code>resourceArn</code> - The ARN of the license configuration resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>resourceType</code> - The resource type (<code>EC2_INSTANCE</code> | <code>EC2_HOST</code> | <code>EC2_AMI</code> | <code>SYSTEMS_MANAGER_MANAGED_INSTANCE</code>). Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// <li> <p> <code>resourceAccount</code> - The ID of the account that owns the resource. Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectGrant`.
    ///
    /// <p>Rejects the specified grant.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RejectGrant<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reject_grant_input::Builder,
    }
    impl<C, M, R> RejectGrant<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RejectGrant`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectGrantOutput,
            aws_smithy_http::result::SdkError<crate::error::RejectGrantError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RejectGrantInputOperationOutputAlias,
                crate::output::RejectGrantOutput,
                crate::error::RejectGrantError,
                crate::input::RejectGrantInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn grant_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn set_grant_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds the specified tags to the specified license configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the specified tags from the specified license configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Keys identifying the tags to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>Keys identifying the tags to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLicenseConfiguration`.
    ///
    /// <p>Modifies the attributes of an existing license configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLicenseConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_license_configuration_input::Builder,
    }
    impl<C, M, R> UpdateLicenseConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLicenseConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLicenseConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLicenseConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLicenseConfigurationInputOperationOutputAlias,
                crate::output::UpdateLicenseConfigurationOutput,
                crate::error::UpdateLicenseConfigurationError,
                crate::input::UpdateLicenseConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn license_configuration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_configuration_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn set_license_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_configuration_arn(input);
            self
        }
        /// <p>New status of the license configuration.</p>
        pub fn license_configuration_status(
            mut self,
            input: crate::model::LicenseConfigurationStatus,
        ) -> Self {
            self.inner = self.inner.license_configuration_status(input);
            self
        }
        /// <p>New status of the license configuration.</p>
        pub fn set_license_configuration_status(
            mut self,
            input: std::option::Option<crate::model::LicenseConfigurationStatus>,
        ) -> Self {
            self.inner = self.inner.set_license_configuration_status(input);
            self
        }
        /// Appends an item to `LicenseRules`.
        ///
        /// To override the contents of this collection use [`set_license_rules`](Self::set_license_rules).
        ///
        /// <p>New license rule. The only rule that you can add after you create a license configuration is licenseAffinityToHost.</p>
        pub fn license_rules(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_rules(input.into());
            self
        }
        /// <p>New license rule. The only rule that you can add after you create a license configuration is licenseAffinityToHost.</p>
        pub fn set_license_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_license_rules(input);
            self
        }
        /// <p>New number of licenses managed by the license configuration.</p>
        pub fn license_count(mut self, input: i64) -> Self {
            self.inner = self.inner.license_count(input);
            self
        }
        /// <p>New number of licenses managed by the license configuration.</p>
        pub fn set_license_count(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_license_count(input);
            self
        }
        /// <p>New hard limit of the number of available licenses.</p>
        pub fn license_count_hard_limit(mut self, input: bool) -> Self {
            self.inner = self.inner.license_count_hard_limit(input);
            self
        }
        /// <p>New hard limit of the number of available licenses.</p>
        pub fn set_license_count_hard_limit(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_license_count_hard_limit(input);
            self
        }
        /// <p>New name of the license configuration.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>New name of the license configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>New description of the license configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>New description of the license configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `ProductInformationList`.
        ///
        /// To override the contents of this collection use [`set_product_information_list`](Self::set_product_information_list).
        ///
        /// <p>New product information.</p>
        pub fn product_information_list(mut self, input: crate::model::ProductInformation) -> Self {
            self.inner = self.inner.product_information_list(input);
            self
        }
        /// <p>New product information.</p>
        pub fn set_product_information_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProductInformation>>,
        ) -> Self {
            self.inner = self.inner.set_product_information_list(input);
            self
        }
        /// <p>When true, disassociates a resource when software is uninstalled.</p>
        pub fn disassociate_when_not_found(mut self, input: bool) -> Self {
            self.inner = self.inner.disassociate_when_not_found(input);
            self
        }
        /// <p>When true, disassociates a resource when software is uninstalled.</p>
        pub fn set_disassociate_when_not_found(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disassociate_when_not_found(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLicenseManagerReportGenerator`.
    ///
    /// <p>Updates a report generator.</p>
    /// <p>After you make changes to a report generator, it starts generating new reports within 60 minutes of being updated.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLicenseManagerReportGenerator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_license_manager_report_generator_input::Builder,
    }
    impl<C, M, R> UpdateLicenseManagerReportGenerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLicenseManagerReportGenerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLicenseManagerReportGeneratorOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateLicenseManagerReportGeneratorError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLicenseManagerReportGeneratorInputOperationOutputAlias,
                crate::output::UpdateLicenseManagerReportGeneratorOutput,
                crate::error::UpdateLicenseManagerReportGeneratorError,
                crate::input::UpdateLicenseManagerReportGeneratorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the report generator to update.</p>
        pub fn license_manager_report_generator_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .license_manager_report_generator_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the report generator to update.</p>
        pub fn set_license_manager_report_generator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_manager_report_generator_arn(input);
            self
        }
        /// <p>Name of the report generator.</p>
        pub fn report_generator_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_generator_name(input.into());
            self
        }
        /// <p>Name of the report generator.</p>
        pub fn set_report_generator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_report_generator_name(input);
            self
        }
        /// Appends an item to `Type`.
        ///
        /// To override the contents of this collection use [`set_type`](Self::set_type).
        ///
        /// <p>Type of reports to generate. The following report types are supported:</p>
        /// <ul>
        /// <li> <p>License configuration report - Reports the number and details of consumed licenses for a license configuration.</p> </li>
        /// <li> <p>Resource report - Reports the tracked licenses and resource consumption for a license configuration.</p> </li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::ReportType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>Type of reports to generate. The following report types are supported:</p>
        /// <ul>
        /// <li> <p>License configuration report - Reports the number and details of consumed licenses for a license configuration.</p> </li>
        /// <li> <p>Resource report - Reports the tracked licenses and resource consumption for a license configuration.</p> </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReportType>>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The report context.</p>
        pub fn report_context(mut self, input: crate::model::ReportContext) -> Self {
            self.inner = self.inner.report_context(input);
            self
        }
        /// <p>The report context.</p>
        pub fn set_report_context(
            mut self,
            input: std::option::Option<crate::model::ReportContext>,
        ) -> Self {
            self.inner = self.inner.set_report_context(input);
            self
        }
        /// <p>Frequency by which reports are generated.</p>
        pub fn report_frequency(mut self, input: crate::model::ReportFrequency) -> Self {
            self.inner = self.inner.report_frequency(input);
            self
        }
        /// <p>Frequency by which reports are generated.</p>
        pub fn set_report_frequency(
            mut self,
            input: std::option::Option<crate::model::ReportFrequency>,
        ) -> Self {
            self.inner = self.inner.set_report_frequency(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Description of the report generator.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>Description of the report generator.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLicenseSpecificationsForResource`.
    ///
    /// <p>Adds or removes the specified license configurations for the specified Amazon Web Services resource.</p>
    /// <p>You can update the license specifications of AMIs, instances, and hosts. You cannot update the license specifications for launch templates and CloudFormation templates, as they send license configurations to the operation that creates the resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateLicenseSpecificationsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_license_specifications_for_resource_input::Builder,
    }
    impl<C, M, R> UpdateLicenseSpecificationsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLicenseSpecificationsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLicenseSpecificationsForResourceOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateLicenseSpecificationsForResourceError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLicenseSpecificationsForResourceInputOperationOutputAlias,
                crate::output::UpdateLicenseSpecificationsForResourceOutput,
                crate::error::UpdateLicenseSpecificationsForResourceError,
                crate::input::UpdateLicenseSpecificationsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon Web Services resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon Web Services resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `AddLicenseSpecifications`.
        ///
        /// To override the contents of this collection use [`set_add_license_specifications`](Self::set_add_license_specifications).
        ///
        /// <p>ARNs of the license configurations to add.</p>
        pub fn add_license_specifications(
            mut self,
            input: crate::model::LicenseSpecification,
        ) -> Self {
            self.inner = self.inner.add_license_specifications(input);
            self
        }
        /// <p>ARNs of the license configurations to add.</p>
        pub fn set_add_license_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LicenseSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_add_license_specifications(input);
            self
        }
        /// Appends an item to `RemoveLicenseSpecifications`.
        ///
        /// To override the contents of this collection use [`set_remove_license_specifications`](Self::set_remove_license_specifications).
        ///
        /// <p>ARNs of the license configurations to remove.</p>
        pub fn remove_license_specifications(
            mut self,
            input: crate::model::LicenseSpecification,
        ) -> Self {
            self.inner = self.inner.remove_license_specifications(input);
            self
        }
        /// <p>ARNs of the license configurations to remove.</p>
        pub fn set_remove_license_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LicenseSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_remove_license_specifications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateServiceSettings`.
    ///
    /// <p>Updates License Manager settings for the current Region.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateServiceSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_service_settings_input::Builder,
    }
    impl<C, M, R> UpdateServiceSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateServiceSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateServiceSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateServiceSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateServiceSettingsInputOperationOutputAlias,
                crate::output::UpdateServiceSettingsOutput,
                crate::error::UpdateServiceSettingsError,
                crate::input::UpdateServiceSettingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon S3 bucket where the License Manager information is stored.</p>
        pub fn s3_bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon S3 bucket where the License Manager information is stored.</p>
        pub fn set_s3_bucket_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_bucket_arn(input);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon SNS topic used for License Manager alerts.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon SNS topic used for License Manager alerts.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p>Enables integration with Organizations for cross-account discovery.</p>
        pub fn organization_configuration(
            mut self,
            input: crate::model::OrganizationConfiguration,
        ) -> Self {
            self.inner = self.inner.organization_configuration(input);
            self
        }
        /// <p>Enables integration with Organizations for cross-account discovery.</p>
        pub fn set_organization_configuration(
            mut self,
            input: std::option::Option<crate::model::OrganizationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_organization_configuration(input);
            self
        }
        /// <p>Activates cross-account discovery.</p>
        pub fn enable_cross_accounts_discovery(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_cross_accounts_discovery(input);
            self
        }
        /// <p>Activates cross-account discovery.</p>
        pub fn set_enable_cross_accounts_discovery(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_cross_accounts_discovery(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
