// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AcceptGrant` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AcceptGrantError {
    /// Kind of error that occurred.
    pub kind: AcceptGrantErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AcceptGrant` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AcceptGrantErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AcceptGrantError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AcceptGrantErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AcceptGrantErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            AcceptGrantErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            AcceptGrantErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            AcceptGrantErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            AcceptGrantErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            AcceptGrantErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AcceptGrantErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AcceptGrantError {
    fn code(&self) -> Option<&str> {
        AcceptGrantError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AcceptGrantError {
    /// Creates a new `AcceptGrantError`.
    pub fn new(kind: AcceptGrantErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AcceptGrantError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AcceptGrantErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AcceptGrantError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AcceptGrantErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AcceptGrantErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, AcceptGrantErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `AcceptGrantErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(&self.kind, AcceptGrantErrorKind::AuthorizationException(_))
    }
    /// Returns `true` if the error kind is `AcceptGrantErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptGrantErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptGrantErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptGrantErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptGrantErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptGrantErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptGrantErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(&self.kind, AcceptGrantErrorKind::ServerInternalException(_))
    }
    /// Returns `true` if the error kind is `AcceptGrantErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, AcceptGrantErrorKind::ValidationException(_))
    }
}
impl std::error::Error for AcceptGrantError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AcceptGrantErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AcceptGrantErrorKind::AuthorizationException(_inner) => Some(_inner),
            AcceptGrantErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            AcceptGrantErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            AcceptGrantErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            AcceptGrantErrorKind::ServerInternalException(_inner) => Some(_inner),
            AcceptGrantErrorKind::ValidationException(_inner) => Some(_inner),
            AcceptGrantErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CheckInLicense` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CheckInLicenseError {
    /// Kind of error that occurred.
    pub kind: CheckInLicenseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CheckInLicense` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CheckInLicenseErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>There was a conflict processing the request. Try your request again.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CheckInLicenseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CheckInLicenseErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CheckInLicenseErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            CheckInLicenseErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CheckInLicenseErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CheckInLicenseErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            CheckInLicenseErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CheckInLicenseErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            CheckInLicenseErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CheckInLicenseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CheckInLicenseError {
    fn code(&self) -> Option<&str> {
        CheckInLicenseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CheckInLicenseError {
    /// Creates a new `CheckInLicenseError`.
    pub fn new(kind: CheckInLicenseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CheckInLicenseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CheckInLicenseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CheckInLicenseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CheckInLicenseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CheckInLicenseErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckInLicenseErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckInLicenseErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckInLicenseErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckInLicenseErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CheckInLicenseErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CheckInLicenseErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckInLicenseErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckInLicenseErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckInLicenseErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckInLicenseErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckInLicenseErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckInLicenseErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckInLicenseErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckInLicenseErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CheckInLicenseErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CheckInLicenseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CheckInLicenseErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CheckInLicenseErrorKind::AuthorizationException(_inner) => Some(_inner),
            CheckInLicenseErrorKind::ConflictException(_inner) => Some(_inner),
            CheckInLicenseErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CheckInLicenseErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            CheckInLicenseErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CheckInLicenseErrorKind::ServerInternalException(_inner) => Some(_inner),
            CheckInLicenseErrorKind::ValidationException(_inner) => Some(_inner),
            CheckInLicenseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CheckoutBorrowLicense` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CheckoutBorrowLicenseError {
    /// Kind of error that occurred.
    pub kind: CheckoutBorrowLicenseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CheckoutBorrowLicense` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CheckoutBorrowLicenseErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>The entitlement is not allowed.</p>
    EntitlementNotAllowedException(crate::error::EntitlementNotAllowedException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>There are no entitlements found for this license, or the entitlement maximum count is reached.</p>
    NoEntitlementsAllowedException(crate::error::NoEntitlementsAllowedException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>This is not the correct Region for the resource. Try again.</p>
    RedirectException(crate::error::RedirectException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The digital signature method is unsupported. Try your request again.</p>
    UnsupportedDigitalSignatureMethodException(
        crate::error::UnsupportedDigitalSignatureMethodException,
    ),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CheckoutBorrowLicenseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CheckoutBorrowLicenseErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CheckoutBorrowLicenseErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            CheckoutBorrowLicenseErrorKind::EntitlementNotAllowedException(_inner) => _inner.fmt(f),
            CheckoutBorrowLicenseErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CheckoutBorrowLicenseErrorKind::NoEntitlementsAllowedException(_inner) => _inner.fmt(f),
            CheckoutBorrowLicenseErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            CheckoutBorrowLicenseErrorKind::RedirectException(_inner) => _inner.fmt(f),
            CheckoutBorrowLicenseErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CheckoutBorrowLicenseErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            CheckoutBorrowLicenseErrorKind::UnsupportedDigitalSignatureMethodException(_inner) => {
                _inner.fmt(f)
            }
            CheckoutBorrowLicenseErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CheckoutBorrowLicenseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CheckoutBorrowLicenseError {
    fn code(&self) -> Option<&str> {
        CheckoutBorrowLicenseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CheckoutBorrowLicenseError {
    /// Creates a new `CheckoutBorrowLicenseError`.
    pub fn new(kind: CheckoutBorrowLicenseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CheckoutBorrowLicenseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CheckoutBorrowLicenseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CheckoutBorrowLicenseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CheckoutBorrowLicenseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CheckoutBorrowLicenseErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckoutBorrowLicenseErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckoutBorrowLicenseErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckoutBorrowLicenseErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckoutBorrowLicenseErrorKind::EntitlementNotAllowedException`.
    pub fn is_entitlement_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckoutBorrowLicenseErrorKind::EntitlementNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckoutBorrowLicenseErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckoutBorrowLicenseErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckoutBorrowLicenseErrorKind::NoEntitlementsAllowedException`.
    pub fn is_no_entitlements_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckoutBorrowLicenseErrorKind::NoEntitlementsAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckoutBorrowLicenseErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckoutBorrowLicenseErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckoutBorrowLicenseErrorKind::RedirectException`.
    pub fn is_redirect_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckoutBorrowLicenseErrorKind::RedirectException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckoutBorrowLicenseErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckoutBorrowLicenseErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckoutBorrowLicenseErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckoutBorrowLicenseErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckoutBorrowLicenseErrorKind::UnsupportedDigitalSignatureMethodException`.
    pub fn is_unsupported_digital_signature_method_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckoutBorrowLicenseErrorKind::UnsupportedDigitalSignatureMethodException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckoutBorrowLicenseErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckoutBorrowLicenseErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CheckoutBorrowLicenseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CheckoutBorrowLicenseErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CheckoutBorrowLicenseErrorKind::AuthorizationException(_inner) => Some(_inner),
            CheckoutBorrowLicenseErrorKind::EntitlementNotAllowedException(_inner) => Some(_inner),
            CheckoutBorrowLicenseErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CheckoutBorrowLicenseErrorKind::NoEntitlementsAllowedException(_inner) => Some(_inner),
            CheckoutBorrowLicenseErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            CheckoutBorrowLicenseErrorKind::RedirectException(_inner) => Some(_inner),
            CheckoutBorrowLicenseErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CheckoutBorrowLicenseErrorKind::ServerInternalException(_inner) => Some(_inner),
            CheckoutBorrowLicenseErrorKind::UnsupportedDigitalSignatureMethodException(_inner) => {
                Some(_inner)
            }
            CheckoutBorrowLicenseErrorKind::ValidationException(_inner) => Some(_inner),
            CheckoutBorrowLicenseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CheckoutLicense` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CheckoutLicenseError {
    /// Kind of error that occurred.
    pub kind: CheckoutLicenseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CheckoutLicense` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CheckoutLicenseErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>There are no entitlements found for this license, or the entitlement maximum count is reached.</p>
    NoEntitlementsAllowedException(crate::error::NoEntitlementsAllowedException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>This is not the correct Region for the resource. Try again.</p>
    RedirectException(crate::error::RedirectException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The digital signature method is unsupported. Try your request again.</p>
    UnsupportedDigitalSignatureMethodException(
        crate::error::UnsupportedDigitalSignatureMethodException,
    ),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CheckoutLicenseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CheckoutLicenseErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CheckoutLicenseErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            CheckoutLicenseErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CheckoutLicenseErrorKind::NoEntitlementsAllowedException(_inner) => _inner.fmt(f),
            CheckoutLicenseErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            CheckoutLicenseErrorKind::RedirectException(_inner) => _inner.fmt(f),
            CheckoutLicenseErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CheckoutLicenseErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            CheckoutLicenseErrorKind::UnsupportedDigitalSignatureMethodException(_inner) => {
                _inner.fmt(f)
            }
            CheckoutLicenseErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CheckoutLicenseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CheckoutLicenseError {
    fn code(&self) -> Option<&str> {
        CheckoutLicenseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CheckoutLicenseError {
    /// Creates a new `CheckoutLicenseError`.
    pub fn new(kind: CheckoutLicenseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CheckoutLicenseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CheckoutLicenseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CheckoutLicenseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CheckoutLicenseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CheckoutLicenseErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckoutLicenseErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckoutLicenseErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckoutLicenseErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckoutLicenseErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckoutLicenseErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckoutLicenseErrorKind::NoEntitlementsAllowedException`.
    pub fn is_no_entitlements_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckoutLicenseErrorKind::NoEntitlementsAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckoutLicenseErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckoutLicenseErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckoutLicenseErrorKind::RedirectException`.
    pub fn is_redirect_exception(&self) -> bool {
        matches!(&self.kind, CheckoutLicenseErrorKind::RedirectException(_))
    }
    /// Returns `true` if the error kind is `CheckoutLicenseErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckoutLicenseErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckoutLicenseErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckoutLicenseErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckoutLicenseErrorKind::UnsupportedDigitalSignatureMethodException`.
    pub fn is_unsupported_digital_signature_method_exception(&self) -> bool {
        matches!(
            &self.kind,
            CheckoutLicenseErrorKind::UnsupportedDigitalSignatureMethodException(_)
        )
    }
    /// Returns `true` if the error kind is `CheckoutLicenseErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CheckoutLicenseErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CheckoutLicenseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CheckoutLicenseErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CheckoutLicenseErrorKind::AuthorizationException(_inner) => Some(_inner),
            CheckoutLicenseErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CheckoutLicenseErrorKind::NoEntitlementsAllowedException(_inner) => Some(_inner),
            CheckoutLicenseErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            CheckoutLicenseErrorKind::RedirectException(_inner) => Some(_inner),
            CheckoutLicenseErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CheckoutLicenseErrorKind::ServerInternalException(_inner) => Some(_inner),
            CheckoutLicenseErrorKind::UnsupportedDigitalSignatureMethodException(_inner) => {
                Some(_inner)
            }
            CheckoutLicenseErrorKind::ValidationException(_inner) => Some(_inner),
            CheckoutLicenseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateGrant` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateGrantError {
    /// Kind of error that occurred.
    pub kind: CreateGrantErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateGrant` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateGrantErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateGrantError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateGrantErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateGrantErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            CreateGrantErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateGrantErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            CreateGrantErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateGrantErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            CreateGrantErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateGrantErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateGrantError {
    fn code(&self) -> Option<&str> {
        CreateGrantError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateGrantError {
    /// Creates a new `CreateGrantError`.
    pub fn new(kind: CreateGrantErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateGrantError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateGrantErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateGrantError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateGrantErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateGrantErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateGrantErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateGrantErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(&self.kind, CreateGrantErrorKind::AuthorizationException(_))
    }
    /// Returns `true` if the error kind is `CreateGrantErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGrantErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGrantErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGrantErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGrantErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGrantErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGrantErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(&self.kind, CreateGrantErrorKind::ServerInternalException(_))
    }
    /// Returns `true` if the error kind is `CreateGrantErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateGrantErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateGrantError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateGrantErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateGrantErrorKind::AuthorizationException(_inner) => Some(_inner),
            CreateGrantErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateGrantErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            CreateGrantErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateGrantErrorKind::ServerInternalException(_inner) => Some(_inner),
            CreateGrantErrorKind::ValidationException(_inner) => Some(_inner),
            CreateGrantErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateGrantVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateGrantVersionError {
    /// Kind of error that occurred.
    pub kind: CreateGrantVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateGrantVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateGrantVersionErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateGrantVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateGrantVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateGrantVersionErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            CreateGrantVersionErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateGrantVersionErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            CreateGrantVersionErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateGrantVersionErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            CreateGrantVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateGrantVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateGrantVersionError {
    fn code(&self) -> Option<&str> {
        CreateGrantVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateGrantVersionError {
    /// Creates a new `CreateGrantVersionError`.
    pub fn new(kind: CreateGrantVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateGrantVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateGrantVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateGrantVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateGrantVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateGrantVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGrantVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGrantVersionErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGrantVersionErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGrantVersionErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGrantVersionErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGrantVersionErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGrantVersionErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGrantVersionErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGrantVersionErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGrantVersionErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGrantVersionErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGrantVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateGrantVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateGrantVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateGrantVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateGrantVersionErrorKind::AuthorizationException(_inner) => Some(_inner),
            CreateGrantVersionErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateGrantVersionErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            CreateGrantVersionErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateGrantVersionErrorKind::ServerInternalException(_inner) => Some(_inner),
            CreateGrantVersionErrorKind::ValidationException(_inner) => Some(_inner),
            CreateGrantVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLicense` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLicenseError {
    /// Kind of error that occurred.
    pub kind: CreateLicenseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLicense` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLicenseErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>This is not the correct Region for the resource. Try again.</p>
    RedirectException(crate::error::RedirectException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLicenseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLicenseErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateLicenseErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            CreateLicenseErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            CreateLicenseErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            CreateLicenseErrorKind::RedirectException(_inner) => _inner.fmt(f),
            CreateLicenseErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            CreateLicenseErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateLicenseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLicenseError {
    fn code(&self) -> Option<&str> {
        CreateLicenseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLicenseError {
    /// Creates a new `CreateLicenseError`.
    pub fn new(kind: CreateLicenseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLicenseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLicenseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLicenseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLicenseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLicenseErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateLicenseErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateLicenseErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseErrorKind::RedirectException`.
    pub fn is_redirect_exception(&self) -> bool {
        matches!(&self.kind, CreateLicenseErrorKind::RedirectException(_))
    }
    /// Returns `true` if the error kind is `CreateLicenseErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateLicenseErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateLicenseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLicenseErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateLicenseErrorKind::AuthorizationException(_inner) => Some(_inner),
            CreateLicenseErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            CreateLicenseErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            CreateLicenseErrorKind::RedirectException(_inner) => Some(_inner),
            CreateLicenseErrorKind::ServerInternalException(_inner) => Some(_inner),
            CreateLicenseErrorKind::ValidationException(_inner) => Some(_inner),
            CreateLicenseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLicenseConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLicenseConfigurationError {
    /// Kind of error that occurred.
    pub kind: CreateLicenseConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLicenseConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLicenseConfigurationErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLicenseConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLicenseConfigurationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateLicenseConfigurationErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            CreateLicenseConfigurationErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            CreateLicenseConfigurationErrorKind::RateLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateLicenseConfigurationErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateLicenseConfigurationErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            CreateLicenseConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLicenseConfigurationError {
    fn code(&self) -> Option<&str> {
        CreateLicenseConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLicenseConfigurationError {
    /// Creates a new `CreateLicenseConfigurationError`.
    pub fn new(kind: CreateLicenseConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLicenseConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLicenseConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLicenseConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLicenseConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLicenseConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseConfigurationErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseConfigurationErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseConfigurationErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseConfigurationErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseConfigurationErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseConfigurationErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseConfigurationErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseConfigurationErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseConfigurationErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseConfigurationErrorKind::ServerInternalException(_)
        )
    }
}
impl std::error::Error for CreateLicenseConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLicenseConfigurationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateLicenseConfigurationErrorKind::AuthorizationException(_inner) => Some(_inner),
            CreateLicenseConfigurationErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            CreateLicenseConfigurationErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            CreateLicenseConfigurationErrorKind::ResourceLimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateLicenseConfigurationErrorKind::ServerInternalException(_inner) => Some(_inner),
            CreateLicenseConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateLicenseConversionTaskForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLicenseConversionTaskForResourceError {
    /// Kind of error that occurred.
    pub kind: CreateLicenseConversionTaskForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLicenseConversionTaskForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLicenseConversionTaskForResourceErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLicenseConversionTaskForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLicenseConversionTaskForResourceErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            CreateLicenseConversionTaskForResourceErrorKind::AuthorizationException(_inner) => {
                _inner.fmt(f)
            }
            CreateLicenseConversionTaskForResourceErrorKind::InvalidParameterValueException(
                _inner,
            ) => _inner.fmt(f),
            CreateLicenseConversionTaskForResourceErrorKind::RateLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateLicenseConversionTaskForResourceErrorKind::ServerInternalException(_inner) => {
                _inner.fmt(f)
            }
            CreateLicenseConversionTaskForResourceErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            CreateLicenseConversionTaskForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLicenseConversionTaskForResourceError {
    fn code(&self) -> Option<&str> {
        CreateLicenseConversionTaskForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLicenseConversionTaskForResourceError {
    /// Creates a new `CreateLicenseConversionTaskForResourceError`.
    pub fn new(
        kind: CreateLicenseConversionTaskForResourceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLicenseConversionTaskForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLicenseConversionTaskForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLicenseConversionTaskForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLicenseConversionTaskForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLicenseConversionTaskForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseConversionTaskForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseConversionTaskForResourceErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseConversionTaskForResourceErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseConversionTaskForResourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseConversionTaskForResourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseConversionTaskForResourceErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseConversionTaskForResourceErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseConversionTaskForResourceErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseConversionTaskForResourceErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseConversionTaskForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseConversionTaskForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateLicenseConversionTaskForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLicenseConversionTaskForResourceErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            CreateLicenseConversionTaskForResourceErrorKind::AuthorizationException(_inner) => {
                Some(_inner)
            }
            CreateLicenseConversionTaskForResourceErrorKind::InvalidParameterValueException(
                _inner,
            ) => Some(_inner),
            CreateLicenseConversionTaskForResourceErrorKind::RateLimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateLicenseConversionTaskForResourceErrorKind::ServerInternalException(_inner) => {
                Some(_inner)
            }
            CreateLicenseConversionTaskForResourceErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            CreateLicenseConversionTaskForResourceErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreateLicenseManagerReportGenerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLicenseManagerReportGeneratorError {
    /// Kind of error that occurred.
    pub kind: CreateLicenseManagerReportGeneratorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLicenseManagerReportGenerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLicenseManagerReportGeneratorErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLicenseManagerReportGeneratorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLicenseManagerReportGeneratorErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            CreateLicenseManagerReportGeneratorErrorKind::AuthorizationException(_inner) => {
                _inner.fmt(f)
            }
            CreateLicenseManagerReportGeneratorErrorKind::InvalidParameterValueException(
                _inner,
            ) => _inner.fmt(f),
            CreateLicenseManagerReportGeneratorErrorKind::RateLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateLicenseManagerReportGeneratorErrorKind::ResourceLimitExceededException(
                _inner,
            ) => _inner.fmt(f),
            CreateLicenseManagerReportGeneratorErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateLicenseManagerReportGeneratorErrorKind::ServerInternalException(_inner) => {
                _inner.fmt(f)
            }
            CreateLicenseManagerReportGeneratorErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            CreateLicenseManagerReportGeneratorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLicenseManagerReportGeneratorError {
    fn code(&self) -> Option<&str> {
        CreateLicenseManagerReportGeneratorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLicenseManagerReportGeneratorError {
    /// Creates a new `CreateLicenseManagerReportGeneratorError`.
    pub fn new(
        kind: CreateLicenseManagerReportGeneratorErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLicenseManagerReportGeneratorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLicenseManagerReportGeneratorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLicenseManagerReportGeneratorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLicenseManagerReportGeneratorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLicenseManagerReportGeneratorErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseManagerReportGeneratorErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseManagerReportGeneratorErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseManagerReportGeneratorErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseManagerReportGeneratorErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseManagerReportGeneratorErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseManagerReportGeneratorErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseManagerReportGeneratorErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseManagerReportGeneratorErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseManagerReportGeneratorErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseManagerReportGeneratorErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseManagerReportGeneratorErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseManagerReportGeneratorErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseManagerReportGeneratorErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseManagerReportGeneratorErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseManagerReportGeneratorErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateLicenseManagerReportGeneratorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLicenseManagerReportGeneratorErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            CreateLicenseManagerReportGeneratorErrorKind::AuthorizationException(_inner) => {
                Some(_inner)
            }
            CreateLicenseManagerReportGeneratorErrorKind::InvalidParameterValueException(
                _inner,
            ) => Some(_inner),
            CreateLicenseManagerReportGeneratorErrorKind::RateLimitExceededException(_inner) => {
                Some(_inner)
            }
            CreateLicenseManagerReportGeneratorErrorKind::ResourceLimitExceededException(
                _inner,
            ) => Some(_inner),
            CreateLicenseManagerReportGeneratorErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateLicenseManagerReportGeneratorErrorKind::ServerInternalException(_inner) => {
                Some(_inner)
            }
            CreateLicenseManagerReportGeneratorErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            CreateLicenseManagerReportGeneratorErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `CreateLicenseVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateLicenseVersionError {
    /// Kind of error that occurred.
    pub kind: CreateLicenseVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateLicenseVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateLicenseVersionErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>There was a conflict processing the request. Try your request again.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>This is not the correct Region for the resource. Try again.</p>
    RedirectException(crate::error::RedirectException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateLicenseVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateLicenseVersionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateLicenseVersionErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            CreateLicenseVersionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateLicenseVersionErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            CreateLicenseVersionErrorKind::RedirectException(_inner) => _inner.fmt(f),
            CreateLicenseVersionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateLicenseVersionErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            CreateLicenseVersionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateLicenseVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateLicenseVersionError {
    fn code(&self) -> Option<&str> {
        CreateLicenseVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateLicenseVersionError {
    /// Creates a new `CreateLicenseVersionError`.
    pub fn new(kind: CreateLicenseVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateLicenseVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateLicenseVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateLicenseVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateLicenseVersionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateLicenseVersionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseVersionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseVersionErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseVersionErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseVersionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseVersionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseVersionErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseVersionErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseVersionErrorKind::RedirectException`.
    pub fn is_redirect_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseVersionErrorKind::RedirectException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseVersionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseVersionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseVersionErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseVersionErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateLicenseVersionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateLicenseVersionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateLicenseVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateLicenseVersionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateLicenseVersionErrorKind::AuthorizationException(_inner) => Some(_inner),
            CreateLicenseVersionErrorKind::ConflictException(_inner) => Some(_inner),
            CreateLicenseVersionErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            CreateLicenseVersionErrorKind::RedirectException(_inner) => Some(_inner),
            CreateLicenseVersionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateLicenseVersionErrorKind::ServerInternalException(_inner) => Some(_inner),
            CreateLicenseVersionErrorKind::ValidationException(_inner) => Some(_inner),
            CreateLicenseVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTokenError {
    /// Kind of error that occurred.
    pub kind: CreateTokenErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTokenErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>This is not the correct Region for the resource. Try again.</p>
    RedirectException(crate::error::RedirectException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTokenError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTokenErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateTokenErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            CreateTokenErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            CreateTokenErrorKind::RedirectException(_inner) => _inner.fmt(f),
            CreateTokenErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateTokenErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateTokenErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            CreateTokenErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateTokenErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTokenError {
    fn code(&self) -> Option<&str> {
        CreateTokenError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTokenError {
    /// Creates a new `CreateTokenError`.
    pub fn new(kind: CreateTokenErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTokenError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTokenErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTokenError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTokenErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTokenErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateTokenErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateTokenErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(&self.kind, CreateTokenErrorKind::AuthorizationException(_))
    }
    /// Returns `true` if the error kind is `CreateTokenErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTokenErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTokenErrorKind::RedirectException`.
    pub fn is_redirect_exception(&self) -> bool {
        matches!(&self.kind, CreateTokenErrorKind::RedirectException(_))
    }
    /// Returns `true` if the error kind is `CreateTokenErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTokenErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTokenErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateTokenErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateTokenErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(&self.kind, CreateTokenErrorKind::ServerInternalException(_))
    }
    /// Returns `true` if the error kind is `CreateTokenErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateTokenErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateTokenError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTokenErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateTokenErrorKind::AuthorizationException(_inner) => Some(_inner),
            CreateTokenErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            CreateTokenErrorKind::RedirectException(_inner) => Some(_inner),
            CreateTokenErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateTokenErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateTokenErrorKind::ServerInternalException(_inner) => Some(_inner),
            CreateTokenErrorKind::ValidationException(_inner) => Some(_inner),
            CreateTokenErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteGrant` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteGrantError {
    /// Kind of error that occurred.
    pub kind: DeleteGrantErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteGrant` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteGrantErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteGrantError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteGrantErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteGrantErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            DeleteGrantErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteGrantErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            DeleteGrantErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            DeleteGrantErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            DeleteGrantErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteGrantErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteGrantError {
    fn code(&self) -> Option<&str> {
        DeleteGrantError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteGrantError {
    /// Creates a new `DeleteGrantError`.
    pub fn new(kind: DeleteGrantErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteGrantError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteGrantErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteGrantError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteGrantErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteGrantErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteGrantErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteGrantErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(&self.kind, DeleteGrantErrorKind::AuthorizationException(_))
    }
    /// Returns `true` if the error kind is `DeleteGrantErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGrantErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGrantErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGrantErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGrantErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGrantErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGrantErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(&self.kind, DeleteGrantErrorKind::ServerInternalException(_))
    }
    /// Returns `true` if the error kind is `DeleteGrantErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteGrantErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteGrantError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteGrantErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteGrantErrorKind::AuthorizationException(_inner) => Some(_inner),
            DeleteGrantErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteGrantErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            DeleteGrantErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            DeleteGrantErrorKind::ServerInternalException(_inner) => Some(_inner),
            DeleteGrantErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteGrantErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLicense` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLicenseError {
    /// Kind of error that occurred.
    pub kind: DeleteLicenseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLicense` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLicenseErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>There was a conflict processing the request. Try your request again.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>This is not the correct Region for the resource. Try again.</p>
    RedirectException(crate::error::RedirectException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLicenseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLicenseErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteLicenseErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            DeleteLicenseErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteLicenseErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            DeleteLicenseErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            DeleteLicenseErrorKind::RedirectException(_inner) => _inner.fmt(f),
            DeleteLicenseErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            DeleteLicenseErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteLicenseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLicenseError {
    fn code(&self) -> Option<&str> {
        DeleteLicenseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLicenseError {
    /// Creates a new `DeleteLicenseError`.
    pub fn new(kind: DeleteLicenseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLicenseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLicenseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLicenseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLicenseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteLicenseErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteLicenseErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteLicenseErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLicenseErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLicenseErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteLicenseErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteLicenseErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLicenseErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLicenseErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLicenseErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLicenseErrorKind::RedirectException`.
    pub fn is_redirect_exception(&self) -> bool {
        matches!(&self.kind, DeleteLicenseErrorKind::RedirectException(_))
    }
    /// Returns `true` if the error kind is `DeleteLicenseErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLicenseErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLicenseErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteLicenseErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteLicenseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLicenseErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteLicenseErrorKind::AuthorizationException(_inner) => Some(_inner),
            DeleteLicenseErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteLicenseErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            DeleteLicenseErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            DeleteLicenseErrorKind::RedirectException(_inner) => Some(_inner),
            DeleteLicenseErrorKind::ServerInternalException(_inner) => Some(_inner),
            DeleteLicenseErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteLicenseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLicenseConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLicenseConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteLicenseConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLicenseConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLicenseConfigurationErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLicenseConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLicenseConfigurationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteLicenseConfigurationErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            DeleteLicenseConfigurationErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLicenseConfigurationErrorKind::RateLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLicenseConfigurationErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            DeleteLicenseConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLicenseConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteLicenseConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLicenseConfigurationError {
    /// Creates a new `DeleteLicenseConfigurationError`.
    pub fn new(kind: DeleteLicenseConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLicenseConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLicenseConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLicenseConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLicenseConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteLicenseConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLicenseConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLicenseConfigurationErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLicenseConfigurationErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLicenseConfigurationErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLicenseConfigurationErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLicenseConfigurationErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLicenseConfigurationErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLicenseConfigurationErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLicenseConfigurationErrorKind::ServerInternalException(_)
        )
    }
}
impl std::error::Error for DeleteLicenseConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLicenseConfigurationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteLicenseConfigurationErrorKind::AuthorizationException(_inner) => Some(_inner),
            DeleteLicenseConfigurationErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            DeleteLicenseConfigurationErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            DeleteLicenseConfigurationErrorKind::ServerInternalException(_inner) => Some(_inner),
            DeleteLicenseConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteLicenseManagerReportGenerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteLicenseManagerReportGeneratorError {
    /// Kind of error that occurred.
    pub kind: DeleteLicenseManagerReportGeneratorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteLicenseManagerReportGenerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteLicenseManagerReportGeneratorErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteLicenseManagerReportGeneratorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteLicenseManagerReportGeneratorErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLicenseManagerReportGeneratorErrorKind::AuthorizationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLicenseManagerReportGeneratorErrorKind::InvalidParameterValueException(
                _inner,
            ) => _inner.fmt(f),
            DeleteLicenseManagerReportGeneratorErrorKind::RateLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLicenseManagerReportGeneratorErrorKind::ResourceLimitExceededException(
                _inner,
            ) => _inner.fmt(f),
            DeleteLicenseManagerReportGeneratorErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLicenseManagerReportGeneratorErrorKind::ServerInternalException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLicenseManagerReportGeneratorErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DeleteLicenseManagerReportGeneratorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteLicenseManagerReportGeneratorError {
    fn code(&self) -> Option<&str> {
        DeleteLicenseManagerReportGeneratorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteLicenseManagerReportGeneratorError {
    /// Creates a new `DeleteLicenseManagerReportGeneratorError`.
    pub fn new(
        kind: DeleteLicenseManagerReportGeneratorErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteLicenseManagerReportGeneratorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteLicenseManagerReportGeneratorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteLicenseManagerReportGeneratorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteLicenseManagerReportGeneratorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteLicenseManagerReportGeneratorErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLicenseManagerReportGeneratorErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLicenseManagerReportGeneratorErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLicenseManagerReportGeneratorErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLicenseManagerReportGeneratorErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLicenseManagerReportGeneratorErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLicenseManagerReportGeneratorErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLicenseManagerReportGeneratorErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLicenseManagerReportGeneratorErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLicenseManagerReportGeneratorErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLicenseManagerReportGeneratorErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLicenseManagerReportGeneratorErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLicenseManagerReportGeneratorErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLicenseManagerReportGeneratorErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteLicenseManagerReportGeneratorErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteLicenseManagerReportGeneratorErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteLicenseManagerReportGeneratorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteLicenseManagerReportGeneratorErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DeleteLicenseManagerReportGeneratorErrorKind::AuthorizationException(_inner) => {
                Some(_inner)
            }
            DeleteLicenseManagerReportGeneratorErrorKind::InvalidParameterValueException(
                _inner,
            ) => Some(_inner),
            DeleteLicenseManagerReportGeneratorErrorKind::RateLimitExceededException(_inner) => {
                Some(_inner)
            }
            DeleteLicenseManagerReportGeneratorErrorKind::ResourceLimitExceededException(
                _inner,
            ) => Some(_inner),
            DeleteLicenseManagerReportGeneratorErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteLicenseManagerReportGeneratorErrorKind::ServerInternalException(_inner) => {
                Some(_inner)
            }
            DeleteLicenseManagerReportGeneratorErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DeleteLicenseManagerReportGeneratorErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTokenError {
    /// Kind of error that occurred.
    pub kind: DeleteTokenErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTokenErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>This is not the correct Region for the resource. Try again.</p>
    RedirectException(crate::error::RedirectException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTokenError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTokenErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteTokenErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            DeleteTokenErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            DeleteTokenErrorKind::RedirectException(_inner) => _inner.fmt(f),
            DeleteTokenErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteTokenErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            DeleteTokenErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteTokenErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTokenError {
    fn code(&self) -> Option<&str> {
        DeleteTokenError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTokenError {
    /// Creates a new `DeleteTokenError`.
    pub fn new(kind: DeleteTokenErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTokenError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTokenErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTokenError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTokenErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTokenErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteTokenErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteTokenErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(&self.kind, DeleteTokenErrorKind::AuthorizationException(_))
    }
    /// Returns `true` if the error kind is `DeleteTokenErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTokenErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTokenErrorKind::RedirectException`.
    pub fn is_redirect_exception(&self) -> bool {
        matches!(&self.kind, DeleteTokenErrorKind::RedirectException(_))
    }
    /// Returns `true` if the error kind is `DeleteTokenErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTokenErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteTokenErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(&self.kind, DeleteTokenErrorKind::ServerInternalException(_))
    }
    /// Returns `true` if the error kind is `DeleteTokenErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteTokenErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteTokenError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTokenErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteTokenErrorKind::AuthorizationException(_inner) => Some(_inner),
            DeleteTokenErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            DeleteTokenErrorKind::RedirectException(_inner) => Some(_inner),
            DeleteTokenErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteTokenErrorKind::ServerInternalException(_inner) => Some(_inner),
            DeleteTokenErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteTokenErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExtendLicenseConsumption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExtendLicenseConsumptionError {
    /// Kind of error that occurred.
    pub kind: ExtendLicenseConsumptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExtendLicenseConsumption` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExtendLicenseConsumptionErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExtendLicenseConsumptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExtendLicenseConsumptionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ExtendLicenseConsumptionErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            ExtendLicenseConsumptionErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ExtendLicenseConsumptionErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            ExtendLicenseConsumptionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ExtendLicenseConsumptionErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            ExtendLicenseConsumptionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ExtendLicenseConsumptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExtendLicenseConsumptionError {
    fn code(&self) -> Option<&str> {
        ExtendLicenseConsumptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExtendLicenseConsumptionError {
    /// Creates a new `ExtendLicenseConsumptionError`.
    pub fn new(kind: ExtendLicenseConsumptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExtendLicenseConsumptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExtendLicenseConsumptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExtendLicenseConsumptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExtendLicenseConsumptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ExtendLicenseConsumptionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExtendLicenseConsumptionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ExtendLicenseConsumptionErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExtendLicenseConsumptionErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `ExtendLicenseConsumptionErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExtendLicenseConsumptionErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ExtendLicenseConsumptionErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExtendLicenseConsumptionErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ExtendLicenseConsumptionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExtendLicenseConsumptionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ExtendLicenseConsumptionErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExtendLicenseConsumptionErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ExtendLicenseConsumptionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExtendLicenseConsumptionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ExtendLicenseConsumptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExtendLicenseConsumptionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ExtendLicenseConsumptionErrorKind::AuthorizationException(_inner) => Some(_inner),
            ExtendLicenseConsumptionErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            ExtendLicenseConsumptionErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            ExtendLicenseConsumptionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ExtendLicenseConsumptionErrorKind::ServerInternalException(_inner) => Some(_inner),
            ExtendLicenseConsumptionErrorKind::ValidationException(_inner) => Some(_inner),
            ExtendLicenseConsumptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAccessToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAccessTokenError {
    /// Kind of error that occurred.
    pub kind: GetAccessTokenErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAccessToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAccessTokenErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAccessTokenError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAccessTokenErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetAccessTokenErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            GetAccessTokenErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            GetAccessTokenErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            GetAccessTokenErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetAccessTokenErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAccessTokenError {
    fn code(&self) -> Option<&str> {
        GetAccessTokenError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAccessTokenError {
    /// Creates a new `GetAccessTokenError`.
    pub fn new(kind: GetAccessTokenErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAccessTokenError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAccessTokenErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAccessTokenError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAccessTokenErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAccessTokenErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccessTokenErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAccessTokenErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccessTokenErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAccessTokenErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccessTokenErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAccessTokenErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAccessTokenErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAccessTokenErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetAccessTokenErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetAccessTokenError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAccessTokenErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetAccessTokenErrorKind::AuthorizationException(_inner) => Some(_inner),
            GetAccessTokenErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            GetAccessTokenErrorKind::ServerInternalException(_inner) => Some(_inner),
            GetAccessTokenErrorKind::ValidationException(_inner) => Some(_inner),
            GetAccessTokenErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetGrant` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetGrantError {
    /// Kind of error that occurred.
    pub kind: GetGrantErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetGrant` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetGrantErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetGrantError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetGrantErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetGrantErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            GetGrantErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetGrantErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            GetGrantErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            GetGrantErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            GetGrantErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetGrantErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetGrantError {
    fn code(&self) -> Option<&str> {
        GetGrantError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetGrantError {
    /// Creates a new `GetGrantError`.
    pub fn new(kind: GetGrantErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetGrantError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetGrantErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetGrantError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetGrantErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetGrantErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetGrantErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetGrantErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(&self.kind, GetGrantErrorKind::AuthorizationException(_))
    }
    /// Returns `true` if the error kind is `GetGrantErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGrantErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGrantErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetGrantErrorKind::RateLimitExceededException(_))
    }
    /// Returns `true` if the error kind is `GetGrantErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetGrantErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetGrantErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(&self.kind, GetGrantErrorKind::ServerInternalException(_))
    }
    /// Returns `true` if the error kind is `GetGrantErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetGrantErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetGrantError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetGrantErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetGrantErrorKind::AuthorizationException(_inner) => Some(_inner),
            GetGrantErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetGrantErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            GetGrantErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            GetGrantErrorKind::ServerInternalException(_inner) => Some(_inner),
            GetGrantErrorKind::ValidationException(_inner) => Some(_inner),
            GetGrantErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLicense` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLicenseError {
    /// Kind of error that occurred.
    pub kind: GetLicenseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLicense` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLicenseErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLicenseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLicenseErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetLicenseErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            GetLicenseErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetLicenseErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            GetLicenseErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            GetLicenseErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetLicenseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLicenseError {
    fn code(&self) -> Option<&str> {
        GetLicenseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLicenseError {
    /// Creates a new `GetLicenseError`.
    pub fn new(kind: GetLicenseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLicenseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLicenseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLicenseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLicenseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLicenseErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetLicenseErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetLicenseErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(&self.kind, GetLicenseErrorKind::AuthorizationException(_))
    }
    /// Returns `true` if the error kind is `GetLicenseErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLicenseErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLicenseErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(&self.kind, GetLicenseErrorKind::ServerInternalException(_))
    }
    /// Returns `true` if the error kind is `GetLicenseErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetLicenseErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetLicenseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLicenseErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetLicenseErrorKind::AuthorizationException(_inner) => Some(_inner),
            GetLicenseErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetLicenseErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            GetLicenseErrorKind::ServerInternalException(_inner) => Some(_inner),
            GetLicenseErrorKind::ValidationException(_inner) => Some(_inner),
            GetLicenseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLicenseConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLicenseConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetLicenseConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLicenseConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLicenseConfigurationErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLicenseConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLicenseConfigurationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetLicenseConfigurationErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            GetLicenseConfigurationErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            GetLicenseConfigurationErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            GetLicenseConfigurationErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            GetLicenseConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLicenseConfigurationError {
    fn code(&self) -> Option<&str> {
        GetLicenseConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLicenseConfigurationError {
    /// Creates a new `GetLicenseConfigurationError`.
    pub fn new(kind: GetLicenseConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLicenseConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLicenseConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLicenseConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLicenseConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLicenseConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLicenseConfigurationErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseConfigurationErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLicenseConfigurationErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseConfigurationErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLicenseConfigurationErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseConfigurationErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLicenseConfigurationErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseConfigurationErrorKind::ServerInternalException(_)
        )
    }
}
impl std::error::Error for GetLicenseConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLicenseConfigurationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetLicenseConfigurationErrorKind::AuthorizationException(_inner) => Some(_inner),
            GetLicenseConfigurationErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            GetLicenseConfigurationErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            GetLicenseConfigurationErrorKind::ServerInternalException(_inner) => Some(_inner),
            GetLicenseConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLicenseConversionTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLicenseConversionTaskError {
    /// Kind of error that occurred.
    pub kind: GetLicenseConversionTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLicenseConversionTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLicenseConversionTaskErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLicenseConversionTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLicenseConversionTaskErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetLicenseConversionTaskErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            GetLicenseConversionTaskErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            GetLicenseConversionTaskErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            GetLicenseConversionTaskErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            GetLicenseConversionTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLicenseConversionTaskError {
    fn code(&self) -> Option<&str> {
        GetLicenseConversionTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLicenseConversionTaskError {
    /// Creates a new `GetLicenseConversionTaskError`.
    pub fn new(kind: GetLicenseConversionTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLicenseConversionTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLicenseConversionTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLicenseConversionTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLicenseConversionTaskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLicenseConversionTaskErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseConversionTaskErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLicenseConversionTaskErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseConversionTaskErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLicenseConversionTaskErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseConversionTaskErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLicenseConversionTaskErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseConversionTaskErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLicenseConversionTaskErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseConversionTaskErrorKind::ServerInternalException(_)
        )
    }
}
impl std::error::Error for GetLicenseConversionTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLicenseConversionTaskErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetLicenseConversionTaskErrorKind::AuthorizationException(_inner) => Some(_inner),
            GetLicenseConversionTaskErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            GetLicenseConversionTaskErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            GetLicenseConversionTaskErrorKind::ServerInternalException(_inner) => Some(_inner),
            GetLicenseConversionTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLicenseManagerReportGenerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLicenseManagerReportGeneratorError {
    /// Kind of error that occurred.
    pub kind: GetLicenseManagerReportGeneratorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLicenseManagerReportGenerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLicenseManagerReportGeneratorErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLicenseManagerReportGeneratorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLicenseManagerReportGeneratorErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetLicenseManagerReportGeneratorErrorKind::AuthorizationException(_inner) => {
                _inner.fmt(f)
            }
            GetLicenseManagerReportGeneratorErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            GetLicenseManagerReportGeneratorErrorKind::RateLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            GetLicenseManagerReportGeneratorErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            GetLicenseManagerReportGeneratorErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetLicenseManagerReportGeneratorErrorKind::ServerInternalException(_inner) => {
                _inner.fmt(f)
            }
            GetLicenseManagerReportGeneratorErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetLicenseManagerReportGeneratorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLicenseManagerReportGeneratorError {
    fn code(&self) -> Option<&str> {
        GetLicenseManagerReportGeneratorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLicenseManagerReportGeneratorError {
    /// Creates a new `GetLicenseManagerReportGeneratorError`.
    pub fn new(
        kind: GetLicenseManagerReportGeneratorErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLicenseManagerReportGeneratorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLicenseManagerReportGeneratorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLicenseManagerReportGeneratorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLicenseManagerReportGeneratorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLicenseManagerReportGeneratorErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseManagerReportGeneratorErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLicenseManagerReportGeneratorErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseManagerReportGeneratorErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLicenseManagerReportGeneratorErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseManagerReportGeneratorErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLicenseManagerReportGeneratorErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseManagerReportGeneratorErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLicenseManagerReportGeneratorErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseManagerReportGeneratorErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLicenseManagerReportGeneratorErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseManagerReportGeneratorErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLicenseManagerReportGeneratorErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseManagerReportGeneratorErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLicenseManagerReportGeneratorErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseManagerReportGeneratorErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetLicenseManagerReportGeneratorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLicenseManagerReportGeneratorErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            GetLicenseManagerReportGeneratorErrorKind::AuthorizationException(_inner) => {
                Some(_inner)
            }
            GetLicenseManagerReportGeneratorErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            GetLicenseManagerReportGeneratorErrorKind::RateLimitExceededException(_inner) => {
                Some(_inner)
            }
            GetLicenseManagerReportGeneratorErrorKind::ResourceLimitExceededException(_inner) => {
                Some(_inner)
            }
            GetLicenseManagerReportGeneratorErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetLicenseManagerReportGeneratorErrorKind::ServerInternalException(_inner) => {
                Some(_inner)
            }
            GetLicenseManagerReportGeneratorErrorKind::ValidationException(_inner) => Some(_inner),
            GetLicenseManagerReportGeneratorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetLicenseUsage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetLicenseUsageError {
    /// Kind of error that occurred.
    pub kind: GetLicenseUsageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetLicenseUsage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetLicenseUsageErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetLicenseUsageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetLicenseUsageErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetLicenseUsageErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            GetLicenseUsageErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            GetLicenseUsageErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            GetLicenseUsageErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            GetLicenseUsageErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetLicenseUsageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetLicenseUsageError {
    fn code(&self) -> Option<&str> {
        GetLicenseUsageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetLicenseUsageError {
    /// Creates a new `GetLicenseUsageError`.
    pub fn new(kind: GetLicenseUsageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetLicenseUsageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetLicenseUsageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetLicenseUsageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetLicenseUsageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetLicenseUsageErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseUsageErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLicenseUsageErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseUsageErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLicenseUsageErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseUsageErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLicenseUsageErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseUsageErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLicenseUsageErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetLicenseUsageErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `GetLicenseUsageErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetLicenseUsageErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetLicenseUsageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetLicenseUsageErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetLicenseUsageErrorKind::AuthorizationException(_inner) => Some(_inner),
            GetLicenseUsageErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            GetLicenseUsageErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            GetLicenseUsageErrorKind::ServerInternalException(_inner) => Some(_inner),
            GetLicenseUsageErrorKind::ValidationException(_inner) => Some(_inner),
            GetLicenseUsageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetServiceSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetServiceSettingsError {
    /// Kind of error that occurred.
    pub kind: GetServiceSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetServiceSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetServiceSettingsErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetServiceSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetServiceSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetServiceSettingsErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            GetServiceSettingsErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            GetServiceSettingsErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            GetServiceSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetServiceSettingsError {
    fn code(&self) -> Option<&str> {
        GetServiceSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetServiceSettingsError {
    /// Creates a new `GetServiceSettingsError`.
    pub fn new(kind: GetServiceSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetServiceSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetServiceSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetServiceSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetServiceSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetServiceSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceSettingsErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceSettingsErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceSettingsErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceSettingsErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetServiceSettingsErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetServiceSettingsErrorKind::ServerInternalException(_)
        )
    }
}
impl std::error::Error for GetServiceSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetServiceSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetServiceSettingsErrorKind::AuthorizationException(_inner) => Some(_inner),
            GetServiceSettingsErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            GetServiceSettingsErrorKind::ServerInternalException(_inner) => Some(_inner),
            GetServiceSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAssociationsForLicenseConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAssociationsForLicenseConfigurationError {
    /// Kind of error that occurred.
    pub kind: ListAssociationsForLicenseConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAssociationsForLicenseConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAssociationsForLicenseConfigurationErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>The request uses too many filters or too many filter values.</p>
    FilterLimitExceededException(crate::error::FilterLimitExceededException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAssociationsForLicenseConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAssociationsForLicenseConfigurationErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListAssociationsForLicenseConfigurationErrorKind::AuthorizationException(_inner) => {
                _inner.fmt(f)
            }
            ListAssociationsForLicenseConfigurationErrorKind::FilterLimitExceededException(
                _inner,
            ) => _inner.fmt(f),
            ListAssociationsForLicenseConfigurationErrorKind::InvalidParameterValueException(
                _inner,
            ) => _inner.fmt(f),
            ListAssociationsForLicenseConfigurationErrorKind::RateLimitExceededException(
                _inner,
            ) => _inner.fmt(f),
            ListAssociationsForLicenseConfigurationErrorKind::ServerInternalException(_inner) => {
                _inner.fmt(f)
            }
            ListAssociationsForLicenseConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAssociationsForLicenseConfigurationError {
    fn code(&self) -> Option<&str> {
        ListAssociationsForLicenseConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAssociationsForLicenseConfigurationError {
    /// Creates a new `ListAssociationsForLicenseConfigurationError`.
    pub fn new(
        kind: ListAssociationsForLicenseConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAssociationsForLicenseConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAssociationsForLicenseConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAssociationsForLicenseConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAssociationsForLicenseConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAssociationsForLicenseConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssociationsForLicenseConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssociationsForLicenseConfigurationErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssociationsForLicenseConfigurationErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssociationsForLicenseConfigurationErrorKind::FilterLimitExceededException`.
    pub fn is_filter_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssociationsForLicenseConfigurationErrorKind::FilterLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssociationsForLicenseConfigurationErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssociationsForLicenseConfigurationErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssociationsForLicenseConfigurationErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssociationsForLicenseConfigurationErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAssociationsForLicenseConfigurationErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAssociationsForLicenseConfigurationErrorKind::ServerInternalException(_)
        )
    }
}
impl std::error::Error for ListAssociationsForLicenseConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAssociationsForLicenseConfigurationErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListAssociationsForLicenseConfigurationErrorKind::AuthorizationException(_inner) => {
                Some(_inner)
            }
            ListAssociationsForLicenseConfigurationErrorKind::FilterLimitExceededException(
                _inner,
            ) => Some(_inner),
            ListAssociationsForLicenseConfigurationErrorKind::InvalidParameterValueException(
                _inner,
            ) => Some(_inner),
            ListAssociationsForLicenseConfigurationErrorKind::RateLimitExceededException(
                _inner,
            ) => Some(_inner),
            ListAssociationsForLicenseConfigurationErrorKind::ServerInternalException(_inner) => {
                Some(_inner)
            }
            ListAssociationsForLicenseConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListDistributedGrants` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDistributedGrantsError {
    /// Kind of error that occurred.
    pub kind: ListDistributedGrantsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDistributedGrants` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDistributedGrantsErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDistributedGrantsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDistributedGrantsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListDistributedGrantsErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            ListDistributedGrantsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListDistributedGrantsErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            ListDistributedGrantsErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            ListDistributedGrantsErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            ListDistributedGrantsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDistributedGrantsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDistributedGrantsError {
    fn code(&self) -> Option<&str> {
        ListDistributedGrantsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDistributedGrantsError {
    /// Creates a new `ListDistributedGrantsError`.
    pub fn new(kind: ListDistributedGrantsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDistributedGrantsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDistributedGrantsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDistributedGrantsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDistributedGrantsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListDistributedGrantsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDistributedGrantsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDistributedGrantsErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDistributedGrantsErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDistributedGrantsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDistributedGrantsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDistributedGrantsErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDistributedGrantsErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDistributedGrantsErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDistributedGrantsErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDistributedGrantsErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDistributedGrantsErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListDistributedGrantsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDistributedGrantsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListDistributedGrantsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDistributedGrantsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDistributedGrantsErrorKind::AuthorizationException(_inner) => Some(_inner),
            ListDistributedGrantsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListDistributedGrantsErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            ListDistributedGrantsErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            ListDistributedGrantsErrorKind::ServerInternalException(_inner) => Some(_inner),
            ListDistributedGrantsErrorKind::ValidationException(_inner) => Some(_inner),
            ListDistributedGrantsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFailuresForLicenseConfigurationOperations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFailuresForLicenseConfigurationOperationsError {
    /// Kind of error that occurred.
    pub kind: ListFailuresForLicenseConfigurationOperationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFailuresForLicenseConfigurationOperations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFailuresForLicenseConfigurationOperationsErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFailuresForLicenseConfigurationOperationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFailuresForLicenseConfigurationOperationsErrorKind::AccessDeniedException(_inner) =>
            _inner.fmt(f)
            ,
            ListFailuresForLicenseConfigurationOperationsErrorKind::AuthorizationException(_inner) =>
            _inner.fmt(f)
            ,
            ListFailuresForLicenseConfigurationOperationsErrorKind::InvalidParameterValueException(_inner) =>
            _inner.fmt(f)
            ,
            ListFailuresForLicenseConfigurationOperationsErrorKind::RateLimitExceededException(_inner) =>
            _inner.fmt(f)
            ,
            ListFailuresForLicenseConfigurationOperationsErrorKind::ServerInternalException(_inner) =>
            _inner.fmt(f)
            ,
            ListFailuresForLicenseConfigurationOperationsErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for ListFailuresForLicenseConfigurationOperationsError
{
    fn code(&self) -> Option<&str> {
        ListFailuresForLicenseConfigurationOperationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFailuresForLicenseConfigurationOperationsError {
    /// Creates a new `ListFailuresForLicenseConfigurationOperationsError`.
    pub fn new(
        kind: ListFailuresForLicenseConfigurationOperationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFailuresForLicenseConfigurationOperationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFailuresForLicenseConfigurationOperationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFailuresForLicenseConfigurationOperationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFailuresForLicenseConfigurationOperationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFailuresForLicenseConfigurationOperationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFailuresForLicenseConfigurationOperationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFailuresForLicenseConfigurationOperationsErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFailuresForLicenseConfigurationOperationsErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFailuresForLicenseConfigurationOperationsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFailuresForLicenseConfigurationOperationsErrorKind::InvalidParameterValueException(
                _
            )
        )
    }
    /// Returns `true` if the error kind is `ListFailuresForLicenseConfigurationOperationsErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFailuresForLicenseConfigurationOperationsErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFailuresForLicenseConfigurationOperationsErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFailuresForLicenseConfigurationOperationsErrorKind::ServerInternalException(_)
        )
    }
}
impl std::error::Error for ListFailuresForLicenseConfigurationOperationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFailuresForLicenseConfigurationOperationsErrorKind::AccessDeniedException(_inner) =>
            Some(_inner)
            ,
            ListFailuresForLicenseConfigurationOperationsErrorKind::AuthorizationException(_inner) =>
            Some(_inner)
            ,
            ListFailuresForLicenseConfigurationOperationsErrorKind::InvalidParameterValueException(_inner) =>
            Some(_inner)
            ,
            ListFailuresForLicenseConfigurationOperationsErrorKind::RateLimitExceededException(_inner) =>
            Some(_inner)
            ,
            ListFailuresForLicenseConfigurationOperationsErrorKind::ServerInternalException(_inner) =>
            Some(_inner)
            ,
            ListFailuresForLicenseConfigurationOperationsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListLicenseConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLicenseConfigurationsError {
    /// Kind of error that occurred.
    pub kind: ListLicenseConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLicenseConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLicenseConfigurationsErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>The request uses too many filters or too many filter values.</p>
    FilterLimitExceededException(crate::error::FilterLimitExceededException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLicenseConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLicenseConfigurationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListLicenseConfigurationsErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            ListLicenseConfigurationsErrorKind::FilterLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            ListLicenseConfigurationsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListLicenseConfigurationsErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            ListLicenseConfigurationsErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            ListLicenseConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLicenseConfigurationsError {
    fn code(&self) -> Option<&str> {
        ListLicenseConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLicenseConfigurationsError {
    /// Creates a new `ListLicenseConfigurationsError`.
    pub fn new(kind: ListLicenseConfigurationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLicenseConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLicenseConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLicenseConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLicenseConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListLicenseConfigurationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseConfigurationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseConfigurationsErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseConfigurationsErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseConfigurationsErrorKind::FilterLimitExceededException`.
    pub fn is_filter_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseConfigurationsErrorKind::FilterLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseConfigurationsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseConfigurationsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseConfigurationsErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseConfigurationsErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseConfigurationsErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseConfigurationsErrorKind::ServerInternalException(_)
        )
    }
}
impl std::error::Error for ListLicenseConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLicenseConfigurationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListLicenseConfigurationsErrorKind::AuthorizationException(_inner) => Some(_inner),
            ListLicenseConfigurationsErrorKind::FilterLimitExceededException(_inner) => {
                Some(_inner)
            }
            ListLicenseConfigurationsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            ListLicenseConfigurationsErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            ListLicenseConfigurationsErrorKind::ServerInternalException(_inner) => Some(_inner),
            ListLicenseConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLicenseConversionTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLicenseConversionTasksError {
    /// Kind of error that occurred.
    pub kind: ListLicenseConversionTasksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLicenseConversionTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLicenseConversionTasksErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLicenseConversionTasksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLicenseConversionTasksErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListLicenseConversionTasksErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            ListLicenseConversionTasksErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListLicenseConversionTasksErrorKind::RateLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            ListLicenseConversionTasksErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            ListLicenseConversionTasksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLicenseConversionTasksError {
    fn code(&self) -> Option<&str> {
        ListLicenseConversionTasksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLicenseConversionTasksError {
    /// Creates a new `ListLicenseConversionTasksError`.
    pub fn new(kind: ListLicenseConversionTasksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLicenseConversionTasksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLicenseConversionTasksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLicenseConversionTasksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLicenseConversionTasksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListLicenseConversionTasksErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseConversionTasksErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseConversionTasksErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseConversionTasksErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseConversionTasksErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseConversionTasksErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseConversionTasksErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseConversionTasksErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseConversionTasksErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseConversionTasksErrorKind::ServerInternalException(_)
        )
    }
}
impl std::error::Error for ListLicenseConversionTasksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLicenseConversionTasksErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListLicenseConversionTasksErrorKind::AuthorizationException(_inner) => Some(_inner),
            ListLicenseConversionTasksErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            ListLicenseConversionTasksErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            ListLicenseConversionTasksErrorKind::ServerInternalException(_inner) => Some(_inner),
            ListLicenseConversionTasksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLicenseManagerReportGenerators` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLicenseManagerReportGeneratorsError {
    /// Kind of error that occurred.
    pub kind: ListLicenseManagerReportGeneratorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLicenseManagerReportGenerators` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLicenseManagerReportGeneratorsErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLicenseManagerReportGeneratorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLicenseManagerReportGeneratorsErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListLicenseManagerReportGeneratorsErrorKind::AuthorizationException(_inner) => {
                _inner.fmt(f)
            }
            ListLicenseManagerReportGeneratorsErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListLicenseManagerReportGeneratorsErrorKind::RateLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            ListLicenseManagerReportGeneratorsErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            ListLicenseManagerReportGeneratorsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListLicenseManagerReportGeneratorsErrorKind::ServerInternalException(_inner) => {
                _inner.fmt(f)
            }
            ListLicenseManagerReportGeneratorsErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            ListLicenseManagerReportGeneratorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLicenseManagerReportGeneratorsError {
    fn code(&self) -> Option<&str> {
        ListLicenseManagerReportGeneratorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLicenseManagerReportGeneratorsError {
    /// Creates a new `ListLicenseManagerReportGeneratorsError`.
    pub fn new(
        kind: ListLicenseManagerReportGeneratorsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLicenseManagerReportGeneratorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLicenseManagerReportGeneratorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLicenseManagerReportGeneratorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLicenseManagerReportGeneratorsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListLicenseManagerReportGeneratorsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseManagerReportGeneratorsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseManagerReportGeneratorsErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseManagerReportGeneratorsErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseManagerReportGeneratorsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseManagerReportGeneratorsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseManagerReportGeneratorsErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseManagerReportGeneratorsErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseManagerReportGeneratorsErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseManagerReportGeneratorsErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseManagerReportGeneratorsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseManagerReportGeneratorsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseManagerReportGeneratorsErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseManagerReportGeneratorsErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseManagerReportGeneratorsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseManagerReportGeneratorsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListLicenseManagerReportGeneratorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLicenseManagerReportGeneratorsErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListLicenseManagerReportGeneratorsErrorKind::AuthorizationException(_inner) => {
                Some(_inner)
            }
            ListLicenseManagerReportGeneratorsErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            ListLicenseManagerReportGeneratorsErrorKind::RateLimitExceededException(_inner) => {
                Some(_inner)
            }
            ListLicenseManagerReportGeneratorsErrorKind::ResourceLimitExceededException(_inner) => {
                Some(_inner)
            }
            ListLicenseManagerReportGeneratorsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListLicenseManagerReportGeneratorsErrorKind::ServerInternalException(_inner) => {
                Some(_inner)
            }
            ListLicenseManagerReportGeneratorsErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            ListLicenseManagerReportGeneratorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLicenses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLicensesError {
    /// Kind of error that occurred.
    pub kind: ListLicensesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLicenses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLicensesErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLicensesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLicensesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListLicensesErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            ListLicensesErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListLicensesErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            ListLicensesErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            ListLicensesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListLicensesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLicensesError {
    fn code(&self) -> Option<&str> {
        ListLicensesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLicensesError {
    /// Creates a new `ListLicensesError`.
    pub fn new(kind: ListLicensesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLicensesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLicensesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLicensesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLicensesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListLicensesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListLicensesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListLicensesErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(&self.kind, ListLicensesErrorKind::AuthorizationException(_))
    }
    /// Returns `true` if the error kind is `ListLicensesErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicensesErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicensesErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicensesErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicensesErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicensesErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicensesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListLicensesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListLicensesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLicensesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListLicensesErrorKind::AuthorizationException(_inner) => Some(_inner),
            ListLicensesErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListLicensesErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            ListLicensesErrorKind::ServerInternalException(_inner) => Some(_inner),
            ListLicensesErrorKind::ValidationException(_inner) => Some(_inner),
            ListLicensesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLicenseSpecificationsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLicenseSpecificationsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListLicenseSpecificationsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLicenseSpecificationsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLicenseSpecificationsForResourceErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLicenseSpecificationsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLicenseSpecificationsForResourceErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListLicenseSpecificationsForResourceErrorKind::AuthorizationException(_inner) => {
                _inner.fmt(f)
            }
            ListLicenseSpecificationsForResourceErrorKind::InvalidParameterValueException(
                _inner,
            ) => _inner.fmt(f),
            ListLicenseSpecificationsForResourceErrorKind::RateLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            ListLicenseSpecificationsForResourceErrorKind::ServerInternalException(_inner) => {
                _inner.fmt(f)
            }
            ListLicenseSpecificationsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLicenseSpecificationsForResourceError {
    fn code(&self) -> Option<&str> {
        ListLicenseSpecificationsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLicenseSpecificationsForResourceError {
    /// Creates a new `ListLicenseSpecificationsForResourceError`.
    pub fn new(
        kind: ListLicenseSpecificationsForResourceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLicenseSpecificationsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLicenseSpecificationsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLicenseSpecificationsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLicenseSpecificationsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListLicenseSpecificationsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseSpecificationsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseSpecificationsForResourceErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseSpecificationsForResourceErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseSpecificationsForResourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseSpecificationsForResourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseSpecificationsForResourceErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseSpecificationsForResourceErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseSpecificationsForResourceErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseSpecificationsForResourceErrorKind::ServerInternalException(_)
        )
    }
}
impl std::error::Error for ListLicenseSpecificationsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLicenseSpecificationsForResourceErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListLicenseSpecificationsForResourceErrorKind::AuthorizationException(_inner) => {
                Some(_inner)
            }
            ListLicenseSpecificationsForResourceErrorKind::InvalidParameterValueException(
                _inner,
            ) => Some(_inner),
            ListLicenseSpecificationsForResourceErrorKind::RateLimitExceededException(_inner) => {
                Some(_inner)
            }
            ListLicenseSpecificationsForResourceErrorKind::ServerInternalException(_inner) => {
                Some(_inner)
            }
            ListLicenseSpecificationsForResourceErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `ListLicenseVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLicenseVersionsError {
    /// Kind of error that occurred.
    pub kind: ListLicenseVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLicenseVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLicenseVersionsErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLicenseVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLicenseVersionsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListLicenseVersionsErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            ListLicenseVersionsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListLicenseVersionsErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            ListLicenseVersionsErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            ListLicenseVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLicenseVersionsError {
    fn code(&self) -> Option<&str> {
        ListLicenseVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLicenseVersionsError {
    /// Creates a new `ListLicenseVersionsError`.
    pub fn new(kind: ListLicenseVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLicenseVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLicenseVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLicenseVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLicenseVersionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListLicenseVersionsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseVersionsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseVersionsErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseVersionsErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseVersionsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseVersionsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseVersionsErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseVersionsErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLicenseVersionsErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLicenseVersionsErrorKind::ServerInternalException(_)
        )
    }
}
impl std::error::Error for ListLicenseVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLicenseVersionsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListLicenseVersionsErrorKind::AuthorizationException(_inner) => Some(_inner),
            ListLicenseVersionsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListLicenseVersionsErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            ListLicenseVersionsErrorKind::ServerInternalException(_inner) => Some(_inner),
            ListLicenseVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListReceivedGrants` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListReceivedGrantsError {
    /// Kind of error that occurred.
    pub kind: ListReceivedGrantsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListReceivedGrants` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListReceivedGrantsErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListReceivedGrantsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListReceivedGrantsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListReceivedGrantsErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            ListReceivedGrantsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListReceivedGrantsErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            ListReceivedGrantsErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            ListReceivedGrantsErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            ListReceivedGrantsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListReceivedGrantsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListReceivedGrantsError {
    fn code(&self) -> Option<&str> {
        ListReceivedGrantsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListReceivedGrantsError {
    /// Creates a new `ListReceivedGrantsError`.
    pub fn new(kind: ListReceivedGrantsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListReceivedGrantsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListReceivedGrantsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListReceivedGrantsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListReceivedGrantsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListReceivedGrantsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReceivedGrantsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReceivedGrantsErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReceivedGrantsErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReceivedGrantsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReceivedGrantsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReceivedGrantsErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReceivedGrantsErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReceivedGrantsErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReceivedGrantsErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReceivedGrantsErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReceivedGrantsErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReceivedGrantsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReceivedGrantsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListReceivedGrantsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListReceivedGrantsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListReceivedGrantsErrorKind::AuthorizationException(_inner) => Some(_inner),
            ListReceivedGrantsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListReceivedGrantsErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            ListReceivedGrantsErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            ListReceivedGrantsErrorKind::ServerInternalException(_inner) => Some(_inner),
            ListReceivedGrantsErrorKind::ValidationException(_inner) => Some(_inner),
            ListReceivedGrantsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListReceivedLicenses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListReceivedLicensesError {
    /// Kind of error that occurred.
    pub kind: ListReceivedLicensesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListReceivedLicenses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListReceivedLicensesErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListReceivedLicensesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListReceivedLicensesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListReceivedLicensesErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            ListReceivedLicensesErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListReceivedLicensesErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            ListReceivedLicensesErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            ListReceivedLicensesErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            ListReceivedLicensesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListReceivedLicensesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListReceivedLicensesError {
    fn code(&self) -> Option<&str> {
        ListReceivedLicensesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListReceivedLicensesError {
    /// Creates a new `ListReceivedLicensesError`.
    pub fn new(kind: ListReceivedLicensesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListReceivedLicensesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListReceivedLicensesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListReceivedLicensesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListReceivedLicensesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListReceivedLicensesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReceivedLicensesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReceivedLicensesErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReceivedLicensesErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReceivedLicensesErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReceivedLicensesErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReceivedLicensesErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReceivedLicensesErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReceivedLicensesErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReceivedLicensesErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReceivedLicensesErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReceivedLicensesErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReceivedLicensesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReceivedLicensesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListReceivedLicensesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListReceivedLicensesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListReceivedLicensesErrorKind::AuthorizationException(_inner) => Some(_inner),
            ListReceivedLicensesErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListReceivedLicensesErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            ListReceivedLicensesErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            ListReceivedLicensesErrorKind::ServerInternalException(_inner) => Some(_inner),
            ListReceivedLicensesErrorKind::ValidationException(_inner) => Some(_inner),
            ListReceivedLicensesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListResourceInventory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListResourceInventoryError {
    /// Kind of error that occurred.
    pub kind: ListResourceInventoryErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListResourceInventory` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListResourceInventoryErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>A dependency required to run the API is missing.</p>
    FailedDependencyException(crate::error::FailedDependencyException),
    /// <p>The request uses too many filters or too many filter values.</p>
    FilterLimitExceededException(crate::error::FilterLimitExceededException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListResourceInventoryError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListResourceInventoryErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListResourceInventoryErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            ListResourceInventoryErrorKind::FailedDependencyException(_inner) => _inner.fmt(f),
            ListResourceInventoryErrorKind::FilterLimitExceededException(_inner) => _inner.fmt(f),
            ListResourceInventoryErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListResourceInventoryErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            ListResourceInventoryErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            ListResourceInventoryErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListResourceInventoryError {
    fn code(&self) -> Option<&str> {
        ListResourceInventoryError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListResourceInventoryError {
    /// Creates a new `ListResourceInventoryError`.
    pub fn new(kind: ListResourceInventoryErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListResourceInventoryError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListResourceInventoryErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListResourceInventoryError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListResourceInventoryErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListResourceInventoryErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceInventoryErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceInventoryErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceInventoryErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceInventoryErrorKind::FailedDependencyException`.
    pub fn is_failed_dependency_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceInventoryErrorKind::FailedDependencyException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceInventoryErrorKind::FilterLimitExceededException`.
    pub fn is_filter_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceInventoryErrorKind::FilterLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceInventoryErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceInventoryErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceInventoryErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceInventoryErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListResourceInventoryErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListResourceInventoryErrorKind::ServerInternalException(_)
        )
    }
}
impl std::error::Error for ListResourceInventoryError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListResourceInventoryErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListResourceInventoryErrorKind::AuthorizationException(_inner) => Some(_inner),
            ListResourceInventoryErrorKind::FailedDependencyException(_inner) => Some(_inner),
            ListResourceInventoryErrorKind::FilterLimitExceededException(_inner) => Some(_inner),
            ListResourceInventoryErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListResourceInventoryErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            ListResourceInventoryErrorKind::ServerInternalException(_inner) => Some(_inner),
            ListResourceInventoryErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ServerInternalException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::AuthorizationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ServerInternalException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTokens` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTokensError {
    /// Kind of error that occurred.
    pub kind: ListTokensErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTokens` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTokensErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTokensError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTokensErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTokensErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            ListTokensErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            ListTokensErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            ListTokensErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTokensErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTokensError {
    fn code(&self) -> Option<&str> {
        ListTokensError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTokensError {
    /// Creates a new `ListTokensError`.
    pub fn new(kind: ListTokensErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTokensError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTokensErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTokensError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTokensErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTokensErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListTokensErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListTokensErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(&self.kind, ListTokensErrorKind::AuthorizationException(_))
    }
    /// Returns `true` if the error kind is `ListTokensErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTokensErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTokensErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(&self.kind, ListTokensErrorKind::ServerInternalException(_))
    }
    /// Returns `true` if the error kind is `ListTokensErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListTokensErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListTokensError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTokensErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTokensErrorKind::AuthorizationException(_inner) => Some(_inner),
            ListTokensErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            ListTokensErrorKind::ServerInternalException(_inner) => Some(_inner),
            ListTokensErrorKind::ValidationException(_inner) => Some(_inner),
            ListTokensErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUsageForLicenseConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUsageForLicenseConfigurationError {
    /// Kind of error that occurred.
    pub kind: ListUsageForLicenseConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUsageForLicenseConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUsageForLicenseConfigurationErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>The request uses too many filters or too many filter values.</p>
    FilterLimitExceededException(crate::error::FilterLimitExceededException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUsageForLicenseConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUsageForLicenseConfigurationErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            ListUsageForLicenseConfigurationErrorKind::AuthorizationException(_inner) => {
                _inner.fmt(f)
            }
            ListUsageForLicenseConfigurationErrorKind::FilterLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            ListUsageForLicenseConfigurationErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            ListUsageForLicenseConfigurationErrorKind::RateLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            ListUsageForLicenseConfigurationErrorKind::ServerInternalException(_inner) => {
                _inner.fmt(f)
            }
            ListUsageForLicenseConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUsageForLicenseConfigurationError {
    fn code(&self) -> Option<&str> {
        ListUsageForLicenseConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUsageForLicenseConfigurationError {
    /// Creates a new `ListUsageForLicenseConfigurationError`.
    pub fn new(
        kind: ListUsageForLicenseConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUsageForLicenseConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUsageForLicenseConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUsageForLicenseConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUsageForLicenseConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListUsageForLicenseConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUsageForLicenseConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUsageForLicenseConfigurationErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUsageForLicenseConfigurationErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUsageForLicenseConfigurationErrorKind::FilterLimitExceededException`.
    pub fn is_filter_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUsageForLicenseConfigurationErrorKind::FilterLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUsageForLicenseConfigurationErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUsageForLicenseConfigurationErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUsageForLicenseConfigurationErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUsageForLicenseConfigurationErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUsageForLicenseConfigurationErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUsageForLicenseConfigurationErrorKind::ServerInternalException(_)
        )
    }
}
impl std::error::Error for ListUsageForLicenseConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUsageForLicenseConfigurationErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            ListUsageForLicenseConfigurationErrorKind::AuthorizationException(_inner) => {
                Some(_inner)
            }
            ListUsageForLicenseConfigurationErrorKind::FilterLimitExceededException(_inner) => {
                Some(_inner)
            }
            ListUsageForLicenseConfigurationErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            ListUsageForLicenseConfigurationErrorKind::RateLimitExceededException(_inner) => {
                Some(_inner)
            }
            ListUsageForLicenseConfigurationErrorKind::ServerInternalException(_inner) => {
                Some(_inner)
            }
            ListUsageForLicenseConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RejectGrant` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RejectGrantError {
    /// Kind of error that occurred.
    pub kind: RejectGrantErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RejectGrant` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RejectGrantErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RejectGrantError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RejectGrantErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RejectGrantErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            RejectGrantErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            RejectGrantErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            RejectGrantErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            RejectGrantErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            RejectGrantErrorKind::ValidationException(_inner) => _inner.fmt(f),
            RejectGrantErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RejectGrantError {
    fn code(&self) -> Option<&str> {
        RejectGrantError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RejectGrantError {
    /// Creates a new `RejectGrantError`.
    pub fn new(kind: RejectGrantErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RejectGrantError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RejectGrantErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RejectGrantError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RejectGrantErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RejectGrantErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, RejectGrantErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `RejectGrantErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(&self.kind, RejectGrantErrorKind::AuthorizationException(_))
    }
    /// Returns `true` if the error kind is `RejectGrantErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectGrantErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectGrantErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectGrantErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectGrantErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectGrantErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectGrantErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(&self.kind, RejectGrantErrorKind::ServerInternalException(_))
    }
    /// Returns `true` if the error kind is `RejectGrantErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, RejectGrantErrorKind::ValidationException(_))
    }
}
impl std::error::Error for RejectGrantError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RejectGrantErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RejectGrantErrorKind::AuthorizationException(_inner) => Some(_inner),
            RejectGrantErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            RejectGrantErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            RejectGrantErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            RejectGrantErrorKind::ServerInternalException(_inner) => Some(_inner),
            RejectGrantErrorKind::ValidationException(_inner) => Some(_inner),
            RejectGrantErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AuthorizationException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ServerInternalException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::AuthorizationException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            TagResourceErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::ServerInternalException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ServerInternalException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::AuthorizationException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UntagResourceErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            UntagResourceErrorKind::ServerInternalException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateLicenseConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateLicenseConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateLicenseConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateLicenseConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateLicenseConfigurationErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateLicenseConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateLicenseConfigurationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateLicenseConfigurationErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            UpdateLicenseConfigurationErrorKind::InvalidParameterValueException(_inner) => {
                _inner.fmt(f)
            }
            UpdateLicenseConfigurationErrorKind::RateLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            UpdateLicenseConfigurationErrorKind::ResourceLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            UpdateLicenseConfigurationErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            UpdateLicenseConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateLicenseConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateLicenseConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateLicenseConfigurationError {
    /// Creates a new `UpdateLicenseConfigurationError`.
    pub fn new(kind: UpdateLicenseConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateLicenseConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateLicenseConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateLicenseConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateLicenseConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateLicenseConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLicenseConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLicenseConfigurationErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLicenseConfigurationErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLicenseConfigurationErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLicenseConfigurationErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLicenseConfigurationErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLicenseConfigurationErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLicenseConfigurationErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLicenseConfigurationErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLicenseConfigurationErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLicenseConfigurationErrorKind::ServerInternalException(_)
        )
    }
}
impl std::error::Error for UpdateLicenseConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateLicenseConfigurationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateLicenseConfigurationErrorKind::AuthorizationException(_inner) => Some(_inner),
            UpdateLicenseConfigurationErrorKind::InvalidParameterValueException(_inner) => {
                Some(_inner)
            }
            UpdateLicenseConfigurationErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            UpdateLicenseConfigurationErrorKind::ResourceLimitExceededException(_inner) => {
                Some(_inner)
            }
            UpdateLicenseConfigurationErrorKind::ServerInternalException(_inner) => Some(_inner),
            UpdateLicenseConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateLicenseManagerReportGenerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateLicenseManagerReportGeneratorError {
    /// Kind of error that occurred.
    pub kind: UpdateLicenseManagerReportGeneratorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateLicenseManagerReportGenerator` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateLicenseManagerReportGeneratorErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>Your resource limits have been exceeded.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The resource cannot be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// <p>The provided input is not valid. Try your request again.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateLicenseManagerReportGeneratorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateLicenseManagerReportGeneratorErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateLicenseManagerReportGeneratorErrorKind::AuthorizationException(_inner) => {
                _inner.fmt(f)
            }
            UpdateLicenseManagerReportGeneratorErrorKind::InvalidParameterValueException(
                _inner,
            ) => _inner.fmt(f),
            UpdateLicenseManagerReportGeneratorErrorKind::RateLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            UpdateLicenseManagerReportGeneratorErrorKind::ResourceLimitExceededException(
                _inner,
            ) => _inner.fmt(f),
            UpdateLicenseManagerReportGeneratorErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateLicenseManagerReportGeneratorErrorKind::ServerInternalException(_inner) => {
                _inner.fmt(f)
            }
            UpdateLicenseManagerReportGeneratorErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            UpdateLicenseManagerReportGeneratorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateLicenseManagerReportGeneratorError {
    fn code(&self) -> Option<&str> {
        UpdateLicenseManagerReportGeneratorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateLicenseManagerReportGeneratorError {
    /// Creates a new `UpdateLicenseManagerReportGeneratorError`.
    pub fn new(
        kind: UpdateLicenseManagerReportGeneratorErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateLicenseManagerReportGeneratorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateLicenseManagerReportGeneratorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateLicenseManagerReportGeneratorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateLicenseManagerReportGeneratorErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateLicenseManagerReportGeneratorErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLicenseManagerReportGeneratorErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLicenseManagerReportGeneratorErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLicenseManagerReportGeneratorErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLicenseManagerReportGeneratorErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLicenseManagerReportGeneratorErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLicenseManagerReportGeneratorErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLicenseManagerReportGeneratorErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLicenseManagerReportGeneratorErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLicenseManagerReportGeneratorErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLicenseManagerReportGeneratorErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLicenseManagerReportGeneratorErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLicenseManagerReportGeneratorErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLicenseManagerReportGeneratorErrorKind::ServerInternalException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLicenseManagerReportGeneratorErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLicenseManagerReportGeneratorErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateLicenseManagerReportGeneratorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateLicenseManagerReportGeneratorErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            UpdateLicenseManagerReportGeneratorErrorKind::AuthorizationException(_inner) => {
                Some(_inner)
            }
            UpdateLicenseManagerReportGeneratorErrorKind::InvalidParameterValueException(
                _inner,
            ) => Some(_inner),
            UpdateLicenseManagerReportGeneratorErrorKind::RateLimitExceededException(_inner) => {
                Some(_inner)
            }
            UpdateLicenseManagerReportGeneratorErrorKind::ResourceLimitExceededException(
                _inner,
            ) => Some(_inner),
            UpdateLicenseManagerReportGeneratorErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateLicenseManagerReportGeneratorErrorKind::ServerInternalException(_inner) => {
                Some(_inner)
            }
            UpdateLicenseManagerReportGeneratorErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            UpdateLicenseManagerReportGeneratorErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateLicenseSpecificationsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateLicenseSpecificationsForResourceError {
    /// Kind of error that occurred.
    pub kind: UpdateLicenseSpecificationsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateLicenseSpecificationsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateLicenseSpecificationsForResourceErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>License Manager cannot allocate a license to a resource because of its state. </p>
    /// <p>For example, you cannot allocate a license to an instance in the process of shutting
    /// down.</p>
    InvalidResourceStateException(crate::error::InvalidResourceStateException),
    /// <p>You do not have enough licenses available to support a new resource launch.</p>
    LicenseUsageException(crate::error::LicenseUsageException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateLicenseSpecificationsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateLicenseSpecificationsForResourceErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateLicenseSpecificationsForResourceErrorKind::AuthorizationException(_inner) => {
                _inner.fmt(f)
            }
            UpdateLicenseSpecificationsForResourceErrorKind::InvalidParameterValueException(
                _inner,
            ) => _inner.fmt(f),
            UpdateLicenseSpecificationsForResourceErrorKind::InvalidResourceStateException(
                _inner,
            ) => _inner.fmt(f),
            UpdateLicenseSpecificationsForResourceErrorKind::LicenseUsageException(_inner) => {
                _inner.fmt(f)
            }
            UpdateLicenseSpecificationsForResourceErrorKind::RateLimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            UpdateLicenseSpecificationsForResourceErrorKind::ServerInternalException(_inner) => {
                _inner.fmt(f)
            }
            UpdateLicenseSpecificationsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateLicenseSpecificationsForResourceError {
    fn code(&self) -> Option<&str> {
        UpdateLicenseSpecificationsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateLicenseSpecificationsForResourceError {
    /// Creates a new `UpdateLicenseSpecificationsForResourceError`.
    pub fn new(
        kind: UpdateLicenseSpecificationsForResourceErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateLicenseSpecificationsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateLicenseSpecificationsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateLicenseSpecificationsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateLicenseSpecificationsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateLicenseSpecificationsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLicenseSpecificationsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLicenseSpecificationsForResourceErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLicenseSpecificationsForResourceErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLicenseSpecificationsForResourceErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLicenseSpecificationsForResourceErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLicenseSpecificationsForResourceErrorKind::InvalidResourceStateException`.
    pub fn is_invalid_resource_state_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLicenseSpecificationsForResourceErrorKind::InvalidResourceStateException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLicenseSpecificationsForResourceErrorKind::LicenseUsageException`.
    pub fn is_license_usage_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLicenseSpecificationsForResourceErrorKind::LicenseUsageException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLicenseSpecificationsForResourceErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLicenseSpecificationsForResourceErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateLicenseSpecificationsForResourceErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateLicenseSpecificationsForResourceErrorKind::ServerInternalException(_)
        )
    }
}
impl std::error::Error for UpdateLicenseSpecificationsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateLicenseSpecificationsForResourceErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            UpdateLicenseSpecificationsForResourceErrorKind::AuthorizationException(_inner) => {
                Some(_inner)
            }
            UpdateLicenseSpecificationsForResourceErrorKind::InvalidParameterValueException(
                _inner,
            ) => Some(_inner),
            UpdateLicenseSpecificationsForResourceErrorKind::InvalidResourceStateException(
                _inner,
            ) => Some(_inner),
            UpdateLicenseSpecificationsForResourceErrorKind::LicenseUsageException(_inner) => {
                Some(_inner)
            }
            UpdateLicenseSpecificationsForResourceErrorKind::RateLimitExceededException(_inner) => {
                Some(_inner)
            }
            UpdateLicenseSpecificationsForResourceErrorKind::ServerInternalException(_inner) => {
                Some(_inner)
            }
            UpdateLicenseSpecificationsForResourceErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateServiceSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateServiceSettingsError {
    /// Kind of error that occurred.
    pub kind: UpdateServiceSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateServiceSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateServiceSettingsErrorKind {
    /// <p>Access to resource denied.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
    /// policy associated with this account.</p>
    AuthorizationException(crate::error::AuthorizationException),
    /// <p>One or more parameter values are not valid.</p>
    InvalidParameterValueException(crate::error::InvalidParameterValueException),
    /// <p>Too many requests have been submitted. Try again after a brief wait.</p>
    RateLimitExceededException(crate::error::RateLimitExceededException),
    /// <p>The server experienced an internal error. Try again.</p>
    ServerInternalException(crate::error::ServerInternalException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateServiceSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateServiceSettingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateServiceSettingsErrorKind::AuthorizationException(_inner) => _inner.fmt(f),
            UpdateServiceSettingsErrorKind::InvalidParameterValueException(_inner) => _inner.fmt(f),
            UpdateServiceSettingsErrorKind::RateLimitExceededException(_inner) => _inner.fmt(f),
            UpdateServiceSettingsErrorKind::ServerInternalException(_inner) => _inner.fmt(f),
            UpdateServiceSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateServiceSettingsError {
    fn code(&self) -> Option<&str> {
        UpdateServiceSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateServiceSettingsError {
    /// Creates a new `UpdateServiceSettingsError`.
    pub fn new(kind: UpdateServiceSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateServiceSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateServiceSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateServiceSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateServiceSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateServiceSettingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceSettingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceSettingsErrorKind::AuthorizationException`.
    pub fn is_authorization_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceSettingsErrorKind::AuthorizationException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceSettingsErrorKind::InvalidParameterValueException`.
    pub fn is_invalid_parameter_value_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceSettingsErrorKind::InvalidParameterValueException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceSettingsErrorKind::RateLimitExceededException`.
    pub fn is_rate_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceSettingsErrorKind::RateLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateServiceSettingsErrorKind::ServerInternalException`.
    pub fn is_server_internal_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateServiceSettingsErrorKind::ServerInternalException(_)
        )
    }
}
impl std::error::Error for UpdateServiceSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateServiceSettingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateServiceSettingsErrorKind::AuthorizationException(_inner) => Some(_inner),
            UpdateServiceSettingsErrorKind::InvalidParameterValueException(_inner) => Some(_inner),
            UpdateServiceSettingsErrorKind::RateLimitExceededException(_inner) => Some(_inner),
            UpdateServiceSettingsErrorKind::ServerInternalException(_inner) => Some(_inner),
            UpdateServiceSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The server experienced an internal error. Try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerInternalException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServerInternalException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerInternalException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServerInternalException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServerInternalException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServerInternalException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServerInternalException {}
/// See [`ServerInternalException`](crate::error::ServerInternalException)
pub mod server_internal_exception {
    /// A builder for [`ServerInternalException`](crate::error::ServerInternalException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerInternalException`](crate::error::ServerInternalException)
        pub fn build(self) -> crate::error::ServerInternalException {
            crate::error::ServerInternalException {
                message: self.message,
            }
        }
    }
}
impl ServerInternalException {
    /// Creates a new builder-style object to manufacture [`ServerInternalException`](crate::error::ServerInternalException)
    pub fn builder() -> crate::error::server_internal_exception::Builder {
        crate::error::server_internal_exception::Builder::default()
    }
}

/// <p>Too many requests have been submitted. Try again after a brief wait.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RateLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RateLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RateLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RateLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RateLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RateLimitExceededException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for RateLimitExceededException {}
/// See [`RateLimitExceededException`](crate::error::RateLimitExceededException)
pub mod rate_limit_exceeded_exception {
    /// A builder for [`RateLimitExceededException`](crate::error::RateLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RateLimitExceededException`](crate::error::RateLimitExceededException)
        pub fn build(self) -> crate::error::RateLimitExceededException {
            crate::error::RateLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl RateLimitExceededException {
    /// Creates a new builder-style object to manufacture [`RateLimitExceededException`](crate::error::RateLimitExceededException)
    pub fn builder() -> crate::error::rate_limit_exceeded_exception::Builder {
        crate::error::rate_limit_exceeded_exception::Builder::default()
    }
}

/// <p>One or more parameter values are not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterValueException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterValueException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterValueException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterValueException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterValueException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterValueException {}
/// See [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
pub mod invalid_parameter_value_exception {
    /// A builder for [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
        pub fn build(self) -> crate::error::InvalidParameterValueException {
            crate::error::InvalidParameterValueException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterValueException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterValueException`](crate::error::InvalidParameterValueException)
    pub fn builder() -> crate::error::invalid_parameter_value_exception::Builder {
        crate::error::invalid_parameter_value_exception::Builder::default()
    }
}

/// <p>The Amazon Web Services user account does not have permission to perform the action. Check the IAM
/// policy associated with this account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthorizationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AuthorizationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthorizationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AuthorizationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AuthorizationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AuthorizationException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for AuthorizationException {}
/// See [`AuthorizationException`](crate::error::AuthorizationException)
pub mod authorization_exception {
    /// A builder for [`AuthorizationException`](crate::error::AuthorizationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizationException`](crate::error::AuthorizationException)
        pub fn build(self) -> crate::error::AuthorizationException {
            crate::error::AuthorizationException {
                message: self.message,
            }
        }
    }
}
impl AuthorizationException {
    /// Creates a new builder-style object to manufacture [`AuthorizationException`](crate::error::AuthorizationException)
    pub fn builder() -> crate::error::authorization_exception::Builder {
        crate::error::authorization_exception::Builder::default()
    }
}

/// <p>Access to resource denied.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>You do not have enough licenses available to support a new resource launch.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LicenseUsageException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LicenseUsageException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LicenseUsageException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LicenseUsageException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LicenseUsageException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LicenseUsageException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for LicenseUsageException {}
/// See [`LicenseUsageException`](crate::error::LicenseUsageException)
pub mod license_usage_exception {
    /// A builder for [`LicenseUsageException`](crate::error::LicenseUsageException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LicenseUsageException`](crate::error::LicenseUsageException)
        pub fn build(self) -> crate::error::LicenseUsageException {
            crate::error::LicenseUsageException {
                message: self.message,
            }
        }
    }
}
impl LicenseUsageException {
    /// Creates a new builder-style object to manufacture [`LicenseUsageException`](crate::error::LicenseUsageException)
    pub fn builder() -> crate::error::license_usage_exception::Builder {
        crate::error::license_usage_exception::Builder::default()
    }
}

/// <p>License Manager cannot allocate a license to a resource because of its state. </p>
/// <p>For example, you cannot allocate a license to an instance in the process of shutting
/// down.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidResourceStateException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidResourceStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidResourceStateException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidResourceStateException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidResourceStateException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidResourceStateException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidResourceStateException {}
/// See [`InvalidResourceStateException`](crate::error::InvalidResourceStateException)
pub mod invalid_resource_state_exception {
    /// A builder for [`InvalidResourceStateException`](crate::error::InvalidResourceStateException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidResourceStateException`](crate::error::InvalidResourceStateException)
        pub fn build(self) -> crate::error::InvalidResourceStateException {
            crate::error::InvalidResourceStateException {
                message: self.message,
            }
        }
    }
}
impl InvalidResourceStateException {
    /// Creates a new builder-style object to manufacture [`InvalidResourceStateException`](crate::error::InvalidResourceStateException)
    pub fn builder() -> crate::error::invalid_resource_state_exception::Builder {
        crate::error::invalid_resource_state_exception::Builder::default()
    }
}

/// <p>The provided input is not valid. Try your request again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>The resource cannot be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>Your resource limits have been exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceLimitExceededException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceLimitExceededException {}
/// See [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
pub mod resource_limit_exceeded_exception {
    /// A builder for [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
        pub fn build(self) -> crate::error::ResourceLimitExceededException {
            crate::error::ResourceLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl ResourceLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
    pub fn builder() -> crate::error::resource_limit_exceeded_exception::Builder {
        crate::error::resource_limit_exceeded_exception::Builder::default()
    }
}

/// <p>The request uses too many filters or too many filter values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FilterLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FilterLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FilterLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl FilterLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FilterLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FilterLimitExceededException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for FilterLimitExceededException {}
/// See [`FilterLimitExceededException`](crate::error::FilterLimitExceededException)
pub mod filter_limit_exceeded_exception {
    /// A builder for [`FilterLimitExceededException`](crate::error::FilterLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`FilterLimitExceededException`](crate::error::FilterLimitExceededException)
        pub fn build(self) -> crate::error::FilterLimitExceededException {
            crate::error::FilterLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl FilterLimitExceededException {
    /// Creates a new builder-style object to manufacture [`FilterLimitExceededException`](crate::error::FilterLimitExceededException)
    pub fn builder() -> crate::error::filter_limit_exceeded_exception::Builder {
        crate::error::filter_limit_exceeded_exception::Builder::default()
    }
}

/// <p>A dependency required to run the API is missing.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailedDependencyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub error_code: std::option::Option<std::string::String>,
}
impl FailedDependencyException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
}
impl std::fmt::Debug for FailedDependencyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailedDependencyException");
        formatter.field("message", &self.message);
        formatter.field("error_code", &self.error_code);
        formatter.finish()
    }
}
impl FailedDependencyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for FailedDependencyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "FailedDependencyException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for FailedDependencyException {}
/// See [`FailedDependencyException`](crate::error::FailedDependencyException)
pub mod failed_dependency_exception {
    /// A builder for [`FailedDependencyException`](crate::error::FailedDependencyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// Consumes the builder and constructs a [`FailedDependencyException`](crate::error::FailedDependencyException)
        pub fn build(self) -> crate::error::FailedDependencyException {
            crate::error::FailedDependencyException {
                message: self.message,
                error_code: self.error_code,
            }
        }
    }
}
impl FailedDependencyException {
    /// Creates a new builder-style object to manufacture [`FailedDependencyException`](crate::error::FailedDependencyException)
    pub fn builder() -> crate::error::failed_dependency_exception::Builder {
        crate::error::failed_dependency_exception::Builder::default()
    }
}

/// <p>This is not the correct Region for the resource. Try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RedirectException {
    #[allow(missing_docs)] // documentation missing in model
    pub location: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl RedirectException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn location(&self) -> std::option::Option<&str> {
        self.location.as_deref()
    }
}
impl std::fmt::Debug for RedirectException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RedirectException");
        formatter.field("location", &self.location);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RedirectException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RedirectException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RedirectException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for RedirectException {}
/// See [`RedirectException`](crate::error::RedirectException)
pub mod redirect_exception {
    /// A builder for [`RedirectException`](crate::error::RedirectException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) location: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn location(mut self, input: impl Into<std::string::String>) -> Self {
            self.location = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_location(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.location = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RedirectException`](crate::error::RedirectException)
        pub fn build(self) -> crate::error::RedirectException {
            crate::error::RedirectException {
                location: self.location,
                message: self.message,
            }
        }
    }
}
impl RedirectException {
    /// Creates a new builder-style object to manufacture [`RedirectException`](crate::error::RedirectException)
    pub fn builder() -> crate::error::redirect_exception::Builder {
        crate::error::redirect_exception::Builder::default()
    }
}

/// <p>There was a conflict processing the request. Try your request again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>The digital signature method is unsupported. Try your request again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedDigitalSignatureMethodException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedDigitalSignatureMethodException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedDigitalSignatureMethodException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedDigitalSignatureMethodException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedDigitalSignatureMethodException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedDigitalSignatureMethodException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedDigitalSignatureMethodException {}
/// See [`UnsupportedDigitalSignatureMethodException`](crate::error::UnsupportedDigitalSignatureMethodException)
pub mod unsupported_digital_signature_method_exception {
    /// A builder for [`UnsupportedDigitalSignatureMethodException`](crate::error::UnsupportedDigitalSignatureMethodException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedDigitalSignatureMethodException`](crate::error::UnsupportedDigitalSignatureMethodException)
        pub fn build(self) -> crate::error::UnsupportedDigitalSignatureMethodException {
            crate::error::UnsupportedDigitalSignatureMethodException {
                message: self.message,
            }
        }
    }
}
impl UnsupportedDigitalSignatureMethodException {
    /// Creates a new builder-style object to manufacture [`UnsupportedDigitalSignatureMethodException`](crate::error::UnsupportedDigitalSignatureMethodException)
    pub fn builder() -> crate::error::unsupported_digital_signature_method_exception::Builder {
        crate::error::unsupported_digital_signature_method_exception::Builder::default()
    }
}

/// <p>There are no entitlements found for this license, or the entitlement maximum count is reached.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoEntitlementsAllowedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NoEntitlementsAllowedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoEntitlementsAllowedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NoEntitlementsAllowedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NoEntitlementsAllowedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NoEntitlementsAllowedException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for NoEntitlementsAllowedException {}
/// See [`NoEntitlementsAllowedException`](crate::error::NoEntitlementsAllowedException)
pub mod no_entitlements_allowed_exception {
    /// A builder for [`NoEntitlementsAllowedException`](crate::error::NoEntitlementsAllowedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NoEntitlementsAllowedException`](crate::error::NoEntitlementsAllowedException)
        pub fn build(self) -> crate::error::NoEntitlementsAllowedException {
            crate::error::NoEntitlementsAllowedException {
                message: self.message,
            }
        }
    }
}
impl NoEntitlementsAllowedException {
    /// Creates a new builder-style object to manufacture [`NoEntitlementsAllowedException`](crate::error::NoEntitlementsAllowedException)
    pub fn builder() -> crate::error::no_entitlements_allowed_exception::Builder {
        crate::error::no_entitlements_allowed_exception::Builder::default()
    }
}

/// <p>The entitlement is not allowed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntitlementNotAllowedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EntitlementNotAllowedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntitlementNotAllowedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EntitlementNotAllowedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EntitlementNotAllowedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EntitlementNotAllowedException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for EntitlementNotAllowedException {}
/// See [`EntitlementNotAllowedException`](crate::error::EntitlementNotAllowedException)
pub mod entitlement_not_allowed_exception {
    /// A builder for [`EntitlementNotAllowedException`](crate::error::EntitlementNotAllowedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EntitlementNotAllowedException`](crate::error::EntitlementNotAllowedException)
        pub fn build(self) -> crate::error::EntitlementNotAllowedException {
            crate::error::EntitlementNotAllowedException {
                message: self.message,
            }
        }
    }
}
impl EntitlementNotAllowedException {
    /// Creates a new builder-style object to manufacture [`EntitlementNotAllowedException`](crate::error::EntitlementNotAllowedException)
    pub fn builder() -> crate::error::entitlement_not_allowed_exception::Builder {
        crate::error::entitlement_not_allowed_exception::Builder::default()
    }
}
