// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS License Manager
///
/// Client for invoking operations on AWS License Manager. Each operation on AWS License Manager is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_licensemanager::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_licensemanager::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_licensemanager::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AcceptGrant` operation.
    ///
    /// See [`AcceptGrant`](crate::client::fluent_builders::AcceptGrant) for more information about the
    /// operation and its arguments.
    pub fn accept_grant(&self) -> fluent_builders::AcceptGrant<C, M, R> {
        fluent_builders::AcceptGrant::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CheckInLicense` operation.
    ///
    /// See [`CheckInLicense`](crate::client::fluent_builders::CheckInLicense) for more information about the
    /// operation and its arguments.
    pub fn check_in_license(&self) -> fluent_builders::CheckInLicense<C, M, R> {
        fluent_builders::CheckInLicense::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CheckoutBorrowLicense` operation.
    ///
    /// See [`CheckoutBorrowLicense`](crate::client::fluent_builders::CheckoutBorrowLicense) for more information about the
    /// operation and its arguments.
    pub fn checkout_borrow_license(&self) -> fluent_builders::CheckoutBorrowLicense<C, M, R> {
        fluent_builders::CheckoutBorrowLicense::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CheckoutLicense` operation.
    ///
    /// See [`CheckoutLicense`](crate::client::fluent_builders::CheckoutLicense) for more information about the
    /// operation and its arguments.
    pub fn checkout_license(&self) -> fluent_builders::CheckoutLicense<C, M, R> {
        fluent_builders::CheckoutLicense::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateGrant` operation.
    ///
    /// See [`CreateGrant`](crate::client::fluent_builders::CreateGrant) for more information about the
    /// operation and its arguments.
    pub fn create_grant(&self) -> fluent_builders::CreateGrant<C, M, R> {
        fluent_builders::CreateGrant::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateGrantVersion` operation.
    ///
    /// See [`CreateGrantVersion`](crate::client::fluent_builders::CreateGrantVersion) for more information about the
    /// operation and its arguments.
    pub fn create_grant_version(&self) -> fluent_builders::CreateGrantVersion<C, M, R> {
        fluent_builders::CreateGrantVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLicense` operation.
    ///
    /// See [`CreateLicense`](crate::client::fluent_builders::CreateLicense) for more information about the
    /// operation and its arguments.
    pub fn create_license(&self) -> fluent_builders::CreateLicense<C, M, R> {
        fluent_builders::CreateLicense::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLicenseConfiguration` operation.
    ///
    /// See [`CreateLicenseConfiguration`](crate::client::fluent_builders::CreateLicenseConfiguration) for more information about the
    /// operation and its arguments.
    pub fn create_license_configuration(
        &self,
    ) -> fluent_builders::CreateLicenseConfiguration<C, M, R> {
        fluent_builders::CreateLicenseConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLicenseConversionTaskForResource` operation.
    ///
    /// See [`CreateLicenseConversionTaskForResource`](crate::client::fluent_builders::CreateLicenseConversionTaskForResource) for more information about the
    /// operation and its arguments.
    pub fn create_license_conversion_task_for_resource(
        &self,
    ) -> fluent_builders::CreateLicenseConversionTaskForResource<C, M, R> {
        fluent_builders::CreateLicenseConversionTaskForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLicenseManagerReportGenerator` operation.
    ///
    /// See [`CreateLicenseManagerReportGenerator`](crate::client::fluent_builders::CreateLicenseManagerReportGenerator) for more information about the
    /// operation and its arguments.
    pub fn create_license_manager_report_generator(
        &self,
    ) -> fluent_builders::CreateLicenseManagerReportGenerator<C, M, R> {
        fluent_builders::CreateLicenseManagerReportGenerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateLicenseVersion` operation.
    ///
    /// See [`CreateLicenseVersion`](crate::client::fluent_builders::CreateLicenseVersion) for more information about the
    /// operation and its arguments.
    pub fn create_license_version(&self) -> fluent_builders::CreateLicenseVersion<C, M, R> {
        fluent_builders::CreateLicenseVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateToken` operation.
    ///
    /// See [`CreateToken`](crate::client::fluent_builders::CreateToken) for more information about the
    /// operation and its arguments.
    pub fn create_token(&self) -> fluent_builders::CreateToken<C, M, R> {
        fluent_builders::CreateToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteGrant` operation.
    ///
    /// See [`DeleteGrant`](crate::client::fluent_builders::DeleteGrant) for more information about the
    /// operation and its arguments.
    pub fn delete_grant(&self) -> fluent_builders::DeleteGrant<C, M, R> {
        fluent_builders::DeleteGrant::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLicense` operation.
    ///
    /// See [`DeleteLicense`](crate::client::fluent_builders::DeleteLicense) for more information about the
    /// operation and its arguments.
    pub fn delete_license(&self) -> fluent_builders::DeleteLicense<C, M, R> {
        fluent_builders::DeleteLicense::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLicenseConfiguration` operation.
    ///
    /// See [`DeleteLicenseConfiguration`](crate::client::fluent_builders::DeleteLicenseConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_license_configuration(
        &self,
    ) -> fluent_builders::DeleteLicenseConfiguration<C, M, R> {
        fluent_builders::DeleteLicenseConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteLicenseManagerReportGenerator` operation.
    ///
    /// See [`DeleteLicenseManagerReportGenerator`](crate::client::fluent_builders::DeleteLicenseManagerReportGenerator) for more information about the
    /// operation and its arguments.
    pub fn delete_license_manager_report_generator(
        &self,
    ) -> fluent_builders::DeleteLicenseManagerReportGenerator<C, M, R> {
        fluent_builders::DeleteLicenseManagerReportGenerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteToken` operation.
    ///
    /// See [`DeleteToken`](crate::client::fluent_builders::DeleteToken) for more information about the
    /// operation and its arguments.
    pub fn delete_token(&self) -> fluent_builders::DeleteToken<C, M, R> {
        fluent_builders::DeleteToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExtendLicenseConsumption` operation.
    ///
    /// See [`ExtendLicenseConsumption`](crate::client::fluent_builders::ExtendLicenseConsumption) for more information about the
    /// operation and its arguments.
    pub fn extend_license_consumption(&self) -> fluent_builders::ExtendLicenseConsumption<C, M, R> {
        fluent_builders::ExtendLicenseConsumption::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAccessToken` operation.
    ///
    /// See [`GetAccessToken`](crate::client::fluent_builders::GetAccessToken) for more information about the
    /// operation and its arguments.
    pub fn get_access_token(&self) -> fluent_builders::GetAccessToken<C, M, R> {
        fluent_builders::GetAccessToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetGrant` operation.
    ///
    /// See [`GetGrant`](crate::client::fluent_builders::GetGrant) for more information about the
    /// operation and its arguments.
    pub fn get_grant(&self) -> fluent_builders::GetGrant<C, M, R> {
        fluent_builders::GetGrant::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLicense` operation.
    ///
    /// See [`GetLicense`](crate::client::fluent_builders::GetLicense) for more information about the
    /// operation and its arguments.
    pub fn get_license(&self) -> fluent_builders::GetLicense<C, M, R> {
        fluent_builders::GetLicense::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLicenseConfiguration` operation.
    ///
    /// See [`GetLicenseConfiguration`](crate::client::fluent_builders::GetLicenseConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_license_configuration(&self) -> fluent_builders::GetLicenseConfiguration<C, M, R> {
        fluent_builders::GetLicenseConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLicenseConversionTask` operation.
    ///
    /// See [`GetLicenseConversionTask`](crate::client::fluent_builders::GetLicenseConversionTask) for more information about the
    /// operation and its arguments.
    pub fn get_license_conversion_task(
        &self,
    ) -> fluent_builders::GetLicenseConversionTask<C, M, R> {
        fluent_builders::GetLicenseConversionTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLicenseManagerReportGenerator` operation.
    ///
    /// See [`GetLicenseManagerReportGenerator`](crate::client::fluent_builders::GetLicenseManagerReportGenerator) for more information about the
    /// operation and its arguments.
    pub fn get_license_manager_report_generator(
        &self,
    ) -> fluent_builders::GetLicenseManagerReportGenerator<C, M, R> {
        fluent_builders::GetLicenseManagerReportGenerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetLicenseUsage` operation.
    ///
    /// See [`GetLicenseUsage`](crate::client::fluent_builders::GetLicenseUsage) for more information about the
    /// operation and its arguments.
    pub fn get_license_usage(&self) -> fluent_builders::GetLicenseUsage<C, M, R> {
        fluent_builders::GetLicenseUsage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetServiceSettings` operation.
    ///
    /// See [`GetServiceSettings`](crate::client::fluent_builders::GetServiceSettings) for more information about the
    /// operation and its arguments.
    pub fn get_service_settings(&self) -> fluent_builders::GetServiceSettings<C, M, R> {
        fluent_builders::GetServiceSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAssociationsForLicenseConfiguration` operation.
    ///
    /// See [`ListAssociationsForLicenseConfiguration`](crate::client::fluent_builders::ListAssociationsForLicenseConfiguration) for more information about the
    /// operation and its arguments.
    pub fn list_associations_for_license_configuration(
        &self,
    ) -> fluent_builders::ListAssociationsForLicenseConfiguration<C, M, R> {
        fluent_builders::ListAssociationsForLicenseConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDistributedGrants` operation.
    ///
    /// See [`ListDistributedGrants`](crate::client::fluent_builders::ListDistributedGrants) for more information about the
    /// operation and its arguments.
    pub fn list_distributed_grants(&self) -> fluent_builders::ListDistributedGrants<C, M, R> {
        fluent_builders::ListDistributedGrants::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFailuresForLicenseConfigurationOperations` operation.
    ///
    /// See [`ListFailuresForLicenseConfigurationOperations`](crate::client::fluent_builders::ListFailuresForLicenseConfigurationOperations) for more information about the
    /// operation and its arguments.
    pub fn list_failures_for_license_configuration_operations(
        &self,
    ) -> fluent_builders::ListFailuresForLicenseConfigurationOperations<C, M, R> {
        fluent_builders::ListFailuresForLicenseConfigurationOperations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLicenseConfigurations` operation.
    ///
    /// See [`ListLicenseConfigurations`](crate::client::fluent_builders::ListLicenseConfigurations) for more information about the
    /// operation and its arguments.
    pub fn list_license_configurations(
        &self,
    ) -> fluent_builders::ListLicenseConfigurations<C, M, R> {
        fluent_builders::ListLicenseConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLicenseConversionTasks` operation.
    ///
    /// See [`ListLicenseConversionTasks`](crate::client::fluent_builders::ListLicenseConversionTasks) for more information about the
    /// operation and its arguments.
    pub fn list_license_conversion_tasks(
        &self,
    ) -> fluent_builders::ListLicenseConversionTasks<C, M, R> {
        fluent_builders::ListLicenseConversionTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLicenseManagerReportGenerators` operation.
    ///
    /// See [`ListLicenseManagerReportGenerators`](crate::client::fluent_builders::ListLicenseManagerReportGenerators) for more information about the
    /// operation and its arguments.
    pub fn list_license_manager_report_generators(
        &self,
    ) -> fluent_builders::ListLicenseManagerReportGenerators<C, M, R> {
        fluent_builders::ListLicenseManagerReportGenerators::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLicenses` operation.
    ///
    /// See [`ListLicenses`](crate::client::fluent_builders::ListLicenses) for more information about the
    /// operation and its arguments.
    pub fn list_licenses(&self) -> fluent_builders::ListLicenses<C, M, R> {
        fluent_builders::ListLicenses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLicenseSpecificationsForResource` operation.
    ///
    /// See [`ListLicenseSpecificationsForResource`](crate::client::fluent_builders::ListLicenseSpecificationsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_license_specifications_for_resource(
        &self,
    ) -> fluent_builders::ListLicenseSpecificationsForResource<C, M, R> {
        fluent_builders::ListLicenseSpecificationsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLicenseVersions` operation.
    ///
    /// See [`ListLicenseVersions`](crate::client::fluent_builders::ListLicenseVersions) for more information about the
    /// operation and its arguments.
    pub fn list_license_versions(&self) -> fluent_builders::ListLicenseVersions<C, M, R> {
        fluent_builders::ListLicenseVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListReceivedGrants` operation.
    ///
    /// See [`ListReceivedGrants`](crate::client::fluent_builders::ListReceivedGrants) for more information about the
    /// operation and its arguments.
    pub fn list_received_grants(&self) -> fluent_builders::ListReceivedGrants<C, M, R> {
        fluent_builders::ListReceivedGrants::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListReceivedLicenses` operation.
    ///
    /// See [`ListReceivedLicenses`](crate::client::fluent_builders::ListReceivedLicenses) for more information about the
    /// operation and its arguments.
    pub fn list_received_licenses(&self) -> fluent_builders::ListReceivedLicenses<C, M, R> {
        fluent_builders::ListReceivedLicenses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListResourceInventory` operation.
    ///
    /// See [`ListResourceInventory`](crate::client::fluent_builders::ListResourceInventory) for more information about the
    /// operation and its arguments.
    pub fn list_resource_inventory(&self) -> fluent_builders::ListResourceInventory<C, M, R> {
        fluent_builders::ListResourceInventory::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTokens` operation.
    ///
    /// See [`ListTokens`](crate::client::fluent_builders::ListTokens) for more information about the
    /// operation and its arguments.
    pub fn list_tokens(&self) -> fluent_builders::ListTokens<C, M, R> {
        fluent_builders::ListTokens::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListUsageForLicenseConfiguration` operation.
    ///
    /// See [`ListUsageForLicenseConfiguration`](crate::client::fluent_builders::ListUsageForLicenseConfiguration) for more information about the
    /// operation and its arguments.
    pub fn list_usage_for_license_configuration(
        &self,
    ) -> fluent_builders::ListUsageForLicenseConfiguration<C, M, R> {
        fluent_builders::ListUsageForLicenseConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RejectGrant` operation.
    ///
    /// See [`RejectGrant`](crate::client::fluent_builders::RejectGrant) for more information about the
    /// operation and its arguments.
    pub fn reject_grant(&self) -> fluent_builders::RejectGrant<C, M, R> {
        fluent_builders::RejectGrant::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLicenseConfiguration` operation.
    ///
    /// See [`UpdateLicenseConfiguration`](crate::client::fluent_builders::UpdateLicenseConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_license_configuration(
        &self,
    ) -> fluent_builders::UpdateLicenseConfiguration<C, M, R> {
        fluent_builders::UpdateLicenseConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLicenseManagerReportGenerator` operation.
    ///
    /// See [`UpdateLicenseManagerReportGenerator`](crate::client::fluent_builders::UpdateLicenseManagerReportGenerator) for more information about the
    /// operation and its arguments.
    pub fn update_license_manager_report_generator(
        &self,
    ) -> fluent_builders::UpdateLicenseManagerReportGenerator<C, M, R> {
        fluent_builders::UpdateLicenseManagerReportGenerator::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateLicenseSpecificationsForResource` operation.
    ///
    /// See [`UpdateLicenseSpecificationsForResource`](crate::client::fluent_builders::UpdateLicenseSpecificationsForResource) for more information about the
    /// operation and its arguments.
    pub fn update_license_specifications_for_resource(
        &self,
    ) -> fluent_builders::UpdateLicenseSpecificationsForResource<C, M, R> {
        fluent_builders::UpdateLicenseSpecificationsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateServiceSettings` operation.
    ///
    /// See [`UpdateServiceSettings`](crate::client::fluent_builders::UpdateServiceSettings) for more information about the
    /// operation and its arguments.
    pub fn update_service_settings(&self) -> fluent_builders::UpdateServiceSettings<C, M, R> {
        fluent_builders::UpdateServiceSettings::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptGrant`.
    ///
    /// <p>Accepts the specified grant.</p>
    #[derive(std::fmt::Debug)]
    pub struct AcceptGrant<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_grant_input::Builder,
    }
    impl<C, M, R> AcceptGrant<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptGrant`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptGrantOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptGrantError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptGrantInputOperationOutputAlias,
                crate::output::AcceptGrantOutput,
                crate::error::AcceptGrantError,
                crate::input::AcceptGrantInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn grant_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn set_grant_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CheckInLicense`.
    ///
    /// <p>Checks in the specified license. Check in a license when it is no longer in use.</p>
    #[derive(std::fmt::Debug)]
    pub struct CheckInLicense<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::check_in_license_input::Builder,
    }
    impl<C, M, R> CheckInLicense<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CheckInLicense`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CheckInLicenseOutput,
            aws_smithy_http::result::SdkError<crate::error::CheckInLicenseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CheckInLicenseInputOperationOutputAlias,
                crate::output::CheckInLicenseOutput,
                crate::error::CheckInLicenseError,
                crate::input::CheckInLicenseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>License consumption token.</p>
        pub fn license_consumption_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_consumption_token(inp);
            self
        }
        /// <p>License consumption token.</p>
        pub fn set_license_consumption_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_consumption_token(input);
            self
        }
        /// <p>License beneficiary.</p>
        pub fn beneficiary(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.beneficiary(inp);
            self
        }
        /// <p>License beneficiary.</p>
        pub fn set_beneficiary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_beneficiary(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CheckoutBorrowLicense`.
    ///
    /// <p>Checks out the specified license for offline use.</p>
    #[derive(std::fmt::Debug)]
    pub struct CheckoutBorrowLicense<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::checkout_borrow_license_input::Builder,
    }
    impl<C, M, R> CheckoutBorrowLicense<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CheckoutBorrowLicense`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CheckoutBorrowLicenseOutput,
            aws_smithy_http::result::SdkError<crate::error::CheckoutBorrowLicenseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CheckoutBorrowLicenseInputOperationOutputAlias,
                crate::output::CheckoutBorrowLicenseOutput,
                crate::error::CheckoutBorrowLicenseError,
                crate::input::CheckoutBorrowLicenseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license. The license must use the borrow consumption configuration.</p>
        pub fn license_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license. The license must use the borrow consumption configuration.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_arn(input);
            self
        }
        /// Appends an item to `Entitlements`.
        ///
        /// To override the contents of this collection use [`set_entitlements`](Self::set_entitlements).
        ///
        /// <p>License entitlements. Partial checkouts are not supported.</p>
        pub fn entitlements(mut self, inp: impl Into<crate::model::EntitlementData>) -> Self {
            self.inner = self.inner.entitlements(inp);
            self
        }
        /// <p>License entitlements. Partial checkouts are not supported.</p>
        pub fn set_entitlements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntitlementData>>,
        ) -> Self {
            self.inner = self.inner.set_entitlements(input);
            self
        }
        /// <p>Digital signature method. The possible value is JSON Web Signature (JWS) algorithm PS384.
        /// For more information, see <a href="https://tools.ietf.org/html/rfc7518#section-3.5">RFC 7518 Digital Signature with RSASSA-PSS</a>.</p>
        pub fn digital_signature_method(
            mut self,
            inp: crate::model::DigitalSignatureMethod,
        ) -> Self {
            self.inner = self.inner.digital_signature_method(inp);
            self
        }
        /// <p>Digital signature method. The possible value is JSON Web Signature (JWS) algorithm PS384.
        /// For more information, see <a href="https://tools.ietf.org/html/rfc7518#section-3.5">RFC 7518 Digital Signature with RSASSA-PSS</a>.</p>
        pub fn set_digital_signature_method(
            mut self,
            input: std::option::Option<crate::model::DigitalSignatureMethod>,
        ) -> Self {
            self.inner = self.inner.set_digital_signature_method(input);
            self
        }
        /// <p>Node ID.</p>
        pub fn node_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_id(inp);
            self
        }
        /// <p>Node ID.</p>
        pub fn set_node_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_id(input);
            self
        }
        /// Appends an item to `CheckoutMetadata`.
        ///
        /// To override the contents of this collection use [`set_checkout_metadata`](Self::set_checkout_metadata).
        ///
        /// <p>Information about constraints.</p>
        pub fn checkout_metadata(mut self, inp: impl Into<crate::model::Metadata>) -> Self {
            self.inner = self.inner.checkout_metadata(inp);
            self
        }
        /// <p>Information about constraints.</p>
        pub fn set_checkout_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
        ) -> Self {
            self.inner = self.inner.set_checkout_metadata(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CheckoutLicense`.
    ///
    /// <p>Checks out the specified license.</p>
    #[derive(std::fmt::Debug)]
    pub struct CheckoutLicense<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::checkout_license_input::Builder,
    }
    impl<C, M, R> CheckoutLicense<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CheckoutLicense`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CheckoutLicenseOutput,
            aws_smithy_http::result::SdkError<crate::error::CheckoutLicenseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CheckoutLicenseInputOperationOutputAlias,
                crate::output::CheckoutLicenseOutput,
                crate::error::CheckoutLicenseError,
                crate::input::CheckoutLicenseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Product SKU.</p>
        pub fn product_sku(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_sku(inp);
            self
        }
        /// <p>Product SKU.</p>
        pub fn set_product_sku(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_sku(input);
            self
        }
        /// <p>Checkout type.</p>
        pub fn checkout_type(mut self, inp: crate::model::CheckoutType) -> Self {
            self.inner = self.inner.checkout_type(inp);
            self
        }
        /// <p>Checkout type.</p>
        pub fn set_checkout_type(
            mut self,
            input: std::option::Option<crate::model::CheckoutType>,
        ) -> Self {
            self.inner = self.inner.set_checkout_type(input);
            self
        }
        /// <p>Key fingerprint identifying the license.</p>
        pub fn key_fingerprint(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_fingerprint(inp);
            self
        }
        /// <p>Key fingerprint identifying the license.</p>
        pub fn set_key_fingerprint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_key_fingerprint(input);
            self
        }
        /// Appends an item to `Entitlements`.
        ///
        /// To override the contents of this collection use [`set_entitlements`](Self::set_entitlements).
        ///
        /// <p>License entitlements.</p>
        pub fn entitlements(mut self, inp: impl Into<crate::model::EntitlementData>) -> Self {
            self.inner = self.inner.entitlements(inp);
            self
        }
        /// <p>License entitlements.</p>
        pub fn set_entitlements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EntitlementData>>,
        ) -> Self {
            self.inner = self.inner.set_entitlements(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>License beneficiary.</p>
        pub fn beneficiary(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.beneficiary(inp);
            self
        }
        /// <p>License beneficiary.</p>
        pub fn set_beneficiary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_beneficiary(input);
            self
        }
        /// <p>Node ID.</p>
        pub fn node_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_id(inp);
            self
        }
        /// <p>Node ID.</p>
        pub fn set_node_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGrant`.
    ///
    /// <p>Creates a grant for the specified license. A grant shares the use of license entitlements with specific Amazon Web Services accounts.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateGrant<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_grant_input::Builder,
    }
    impl<C, M, R> CreateGrant<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGrant`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGrantOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGrantError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGrantInputOperationOutputAlias,
                crate::output::CreateGrantOutput,
                crate::error::CreateGrantError,
                crate::input::CreateGrantInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Grant name.</p>
        pub fn grant_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_name(inp);
            self
        }
        /// <p>Grant name.</p>
        pub fn set_grant_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_name(input);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn license_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_arn(input);
            self
        }
        /// Appends an item to `Principals`.
        ///
        /// To override the contents of this collection use [`set_principals`](Self::set_principals).
        ///
        /// <p>The grant principals.</p>
        pub fn principals(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.principals(inp);
            self
        }
        /// <p>The grant principals.</p>
        pub fn set_principals(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_principals(input);
            self
        }
        /// <p>Home Region of the grant.</p>
        pub fn home_region(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.home_region(inp);
            self
        }
        /// <p>Home Region of the grant.</p>
        pub fn set_home_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_home_region(input);
            self
        }
        /// Appends an item to `AllowedOperations`.
        ///
        /// To override the contents of this collection use [`set_allowed_operations`](Self::set_allowed_operations).
        ///
        /// <p>Allowed operations for the grant.</p>
        pub fn allowed_operations(
            mut self,
            inp: impl Into<crate::model::AllowedOperation>,
        ) -> Self {
            self.inner = self.inner.allowed_operations(inp);
            self
        }
        /// <p>Allowed operations for the grant.</p>
        pub fn set_allowed_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AllowedOperation>>,
        ) -> Self {
            self.inner = self.inner.set_allowed_operations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateGrantVersion`.
    ///
    /// <p>Creates a new version of the specified grant.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateGrantVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_grant_version_input::Builder,
    }
    impl<C, M, R> CreateGrantVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateGrantVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateGrantVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateGrantVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateGrantVersionInputOperationOutputAlias,
                crate::output::CreateGrantVersionOutput,
                crate::error::CreateGrantVersionError,
                crate::input::CreateGrantVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn grant_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn set_grant_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_arn(input);
            self
        }
        /// <p>Grant name.</p>
        pub fn grant_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_name(inp);
            self
        }
        /// <p>Grant name.</p>
        pub fn set_grant_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_name(input);
            self
        }
        /// Appends an item to `AllowedOperations`.
        ///
        /// To override the contents of this collection use [`set_allowed_operations`](Self::set_allowed_operations).
        ///
        /// <p>Allowed operations for the grant.</p>
        pub fn allowed_operations(
            mut self,
            inp: impl Into<crate::model::AllowedOperation>,
        ) -> Self {
            self.inner = self.inner.allowed_operations(inp);
            self
        }
        /// <p>Allowed operations for the grant.</p>
        pub fn set_allowed_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AllowedOperation>>,
        ) -> Self {
            self.inner = self.inner.set_allowed_operations(input);
            self
        }
        /// <p>Grant status.</p>
        pub fn status(mut self, inp: crate::model::GrantStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>Grant status.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::GrantStatus>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>Grant status reason.</p>
        pub fn status_reason(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_reason(inp);
            self
        }
        /// <p>Grant status reason.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_status_reason(input);
            self
        }
        /// <p>Current version of the grant.</p>
        pub fn source_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_version(inp);
            self
        }
        /// <p>Current version of the grant.</p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLicense`.
    ///
    /// <p>Creates a license.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateLicense<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_license_input::Builder,
    }
    impl<C, M, R> CreateLicense<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLicense`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLicenseOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLicenseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLicenseInputOperationOutputAlias,
                crate::output::CreateLicenseOutput,
                crate::error::CreateLicenseError,
                crate::input::CreateLicenseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>License name.</p>
        pub fn license_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_name(inp);
            self
        }
        /// <p>License name.</p>
        pub fn set_license_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_name(input);
            self
        }
        /// <p>Product name.</p>
        pub fn product_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_name(inp);
            self
        }
        /// <p>Product name.</p>
        pub fn set_product_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_name(input);
            self
        }
        /// <p>Product SKU.</p>
        pub fn product_sku(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_sku(inp);
            self
        }
        /// <p>Product SKU.</p>
        pub fn set_product_sku(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_sku(input);
            self
        }
        /// <p>License issuer.</p>
        pub fn issuer(mut self, inp: crate::model::Issuer) -> Self {
            self.inner = self.inner.issuer(inp);
            self
        }
        /// <p>License issuer.</p>
        pub fn set_issuer(mut self, input: std::option::Option<crate::model::Issuer>) -> Self {
            self.inner = self.inner.set_issuer(input);
            self
        }
        /// <p>Home Region for the license.</p>
        pub fn home_region(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.home_region(inp);
            self
        }
        /// <p>Home Region for the license.</p>
        pub fn set_home_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_home_region(input);
            self
        }
        /// <p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>
        pub fn validity(mut self, inp: crate::model::DatetimeRange) -> Self {
            self.inner = self.inner.validity(inp);
            self
        }
        /// <p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>
        pub fn set_validity(
            mut self,
            input: std::option::Option<crate::model::DatetimeRange>,
        ) -> Self {
            self.inner = self.inner.set_validity(input);
            self
        }
        /// Appends an item to `Entitlements`.
        ///
        /// To override the contents of this collection use [`set_entitlements`](Self::set_entitlements).
        ///
        /// <p>License entitlements.</p>
        pub fn entitlements(mut self, inp: impl Into<crate::model::Entitlement>) -> Self {
            self.inner = self.inner.entitlements(inp);
            self
        }
        /// <p>License entitlements.</p>
        pub fn set_entitlements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Entitlement>>,
        ) -> Self {
            self.inner = self.inner.set_entitlements(input);
            self
        }
        /// <p>License beneficiary.</p>
        pub fn beneficiary(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.beneficiary(inp);
            self
        }
        /// <p>License beneficiary.</p>
        pub fn set_beneficiary(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_beneficiary(input);
            self
        }
        /// <p>Configuration for consumption of the license. Choose a provisional configuration for workloads
        /// running with continuous connectivity. Choose a borrow configuration for workloads with offline
        /// usage.</p>
        pub fn consumption_configuration(
            mut self,
            inp: crate::model::ConsumptionConfiguration,
        ) -> Self {
            self.inner = self.inner.consumption_configuration(inp);
            self
        }
        /// <p>Configuration for consumption of the license. Choose a provisional configuration for workloads
        /// running with continuous connectivity. Choose a borrow configuration for workloads with offline
        /// usage.</p>
        pub fn set_consumption_configuration(
            mut self,
            input: std::option::Option<crate::model::ConsumptionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_consumption_configuration(input);
            self
        }
        /// Appends an item to `LicenseMetadata`.
        ///
        /// To override the contents of this collection use [`set_license_metadata`](Self::set_license_metadata).
        ///
        /// <p>Information about the license.</p>
        pub fn license_metadata(mut self, inp: impl Into<crate::model::Metadata>) -> Self {
            self.inner = self.inner.license_metadata(inp);
            self
        }
        /// <p>Information about the license.</p>
        pub fn set_license_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
        ) -> Self {
            self.inner = self.inner.set_license_metadata(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLicenseConfiguration`.
    ///
    /// <p>Creates a license configuration.</p>
    /// <p>A license configuration is an abstraction of a customer license agreement that can be
    /// consumed and enforced by License Manager. Components include specifications for the license
    /// type (licensing by instance, socket, CPU, or vCPU), allowed tenancy (shared tenancy,
    /// Dedicated Instance, Dedicated Host, or all of these), license affinity  to host (how long a
    /// license must be associated with a host), and the number of licenses purchased and used.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateLicenseConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_license_configuration_input::Builder,
    }
    impl<C, M, R> CreateLicenseConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLicenseConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLicenseConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLicenseConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLicenseConfigurationInputOperationOutputAlias,
                crate::output::CreateLicenseConfigurationOutput,
                crate::error::CreateLicenseConfigurationError,
                crate::input::CreateLicenseConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the license configuration.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>Name of the license configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Description of the license configuration.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Description of the license configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Dimension used to track the license inventory.</p>
        pub fn license_counting_type(mut self, inp: crate::model::LicenseCountingType) -> Self {
            self.inner = self.inner.license_counting_type(inp);
            self
        }
        /// <p>Dimension used to track the license inventory.</p>
        pub fn set_license_counting_type(
            mut self,
            input: std::option::Option<crate::model::LicenseCountingType>,
        ) -> Self {
            self.inner = self.inner.set_license_counting_type(input);
            self
        }
        /// <p>Number of licenses managed by the license configuration.</p>
        pub fn license_count(mut self, inp: i64) -> Self {
            self.inner = self.inner.license_count(inp);
            self
        }
        /// <p>Number of licenses managed by the license configuration.</p>
        pub fn set_license_count(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_license_count(input);
            self
        }
        /// <p>Indicates whether hard or soft license enforcement is used. Exceeding a hard limit
        /// blocks the launch of new instances.</p>
        pub fn license_count_hard_limit(mut self, inp: bool) -> Self {
            self.inner = self.inner.license_count_hard_limit(inp);
            self
        }
        /// <p>Indicates whether hard or soft license enforcement is used. Exceeding a hard limit
        /// blocks the launch of new instances.</p>
        pub fn set_license_count_hard_limit(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_license_count_hard_limit(input);
            self
        }
        /// Appends an item to `LicenseRules`.
        ///
        /// To override the contents of this collection use [`set_license_rules`](Self::set_license_rules).
        ///
        /// <p>License rules. The syntax is #name=value (for example, #allowedTenancy=EC2-DedicatedHost). The available rules
        /// vary by dimension, as follows.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Cores</code> dimension: <code>allowedTenancy</code> |
        /// <code>licenseAffinityToHost</code> |
        /// <code>maximumCores</code> | <code>minimumCores</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Instances</code> dimension: <code>allowedTenancy</code> |
        /// <code>maximumCores</code> | <code>minimumCores</code> |
        /// <code>maximumSockets</code> | <code>minimumSockets</code> |
        /// <code>maximumVcpus</code> | <code>minimumVcpus</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Sockets</code> dimension: <code>allowedTenancy</code> |
        /// <code>licenseAffinityToHost</code> |
        /// <code>maximumSockets</code> | <code>minimumSockets</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>vCPUs</code> dimension: <code>allowedTenancy</code> |
        /// <code>honorVcpuOptimization</code> |
        /// <code>maximumVcpus</code> | <code>minimumVcpus</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The unit for <code>licenseAffinityToHost</code> is days and the range is 1 to 180. The possible
        /// values for <code>allowedTenancy</code> are <code>EC2-Default</code>, <code>EC2-DedicatedHost</code>, and
        /// <code>EC2-DedicatedInstance</code>. The possible values for <code>honorVcpuOptimization</code> are
        /// <code>True</code> and <code>False</code>.</p>
        pub fn license_rules(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_rules(inp);
            self
        }
        /// <p>License rules. The syntax is #name=value (for example, #allowedTenancy=EC2-DedicatedHost). The available rules
        /// vary by dimension, as follows.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Cores</code> dimension: <code>allowedTenancy</code> |
        /// <code>licenseAffinityToHost</code> |
        /// <code>maximumCores</code> | <code>minimumCores</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Instances</code> dimension: <code>allowedTenancy</code> |
        /// <code>maximumCores</code> | <code>minimumCores</code> |
        /// <code>maximumSockets</code> | <code>minimumSockets</code> |
        /// <code>maximumVcpus</code> | <code>minimumVcpus</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Sockets</code> dimension: <code>allowedTenancy</code> |
        /// <code>licenseAffinityToHost</code> |
        /// <code>maximumSockets</code> | <code>minimumSockets</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>vCPUs</code> dimension: <code>allowedTenancy</code> |
        /// <code>honorVcpuOptimization</code> |
        /// <code>maximumVcpus</code> | <code>minimumVcpus</code>
        /// </p>
        /// </li>
        /// </ul>
        /// <p>The unit for <code>licenseAffinityToHost</code> is days and the range is 1 to 180. The possible
        /// values for <code>allowedTenancy</code> are <code>EC2-Default</code>, <code>EC2-DedicatedHost</code>, and
        /// <code>EC2-DedicatedInstance</code>. The possible values for <code>honorVcpuOptimization</code> are
        /// <code>True</code> and <code>False</code>.</p>
        pub fn set_license_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_license_rules(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to add to the license configuration.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags to add to the license configuration.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>When true, disassociates a resource when software is uninstalled.</p>
        pub fn disassociate_when_not_found(mut self, inp: bool) -> Self {
            self.inner = self.inner.disassociate_when_not_found(inp);
            self
        }
        /// <p>When true, disassociates a resource when software is uninstalled.</p>
        pub fn set_disassociate_when_not_found(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disassociate_when_not_found(input);
            self
        }
        /// Appends an item to `ProductInformationList`.
        ///
        /// To override the contents of this collection use [`set_product_information_list`](Self::set_product_information_list).
        ///
        /// <p>Product information.</p>
        pub fn product_information_list(
            mut self,
            inp: impl Into<crate::model::ProductInformation>,
        ) -> Self {
            self.inner = self.inner.product_information_list(inp);
            self
        }
        /// <p>Product information.</p>
        pub fn set_product_information_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProductInformation>>,
        ) -> Self {
            self.inner = self.inner.set_product_information_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLicenseConversionTaskForResource`.
    ///
    /// <p>Creates a new license conversion task.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateLicenseConversionTaskForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_license_conversion_task_for_resource_input::Builder,
    }
    impl<C, M, R> CreateLicenseConversionTaskForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLicenseConversionTaskForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLicenseConversionTaskForResourceOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateLicenseConversionTaskForResourceError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLicenseConversionTaskForResourceInputOperationOutputAlias,
                crate::output::CreateLicenseConversionTaskForResourceOutput,
                crate::error::CreateLicenseConversionTaskForResourceError,
                crate::input::CreateLicenseConversionTaskForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the resource you are converting the license type for.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the resource you are converting the license type for.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>Information that identifies the license type you are converting from.
        /// For the structure of the source license, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli">Convert a license type using the AWS CLI</a> in the <i>License Manager User Guide</i>.</p>
        pub fn source_license_context(
            mut self,
            inp: crate::model::LicenseConversionContext,
        ) -> Self {
            self.inner = self.inner.source_license_context(inp);
            self
        }
        /// <p>Information that identifies the license type you are converting from.
        /// For the structure of the source license, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli">Convert a license type using the AWS CLI</a> in the <i>License Manager User Guide</i>.</p>
        pub fn set_source_license_context(
            mut self,
            input: std::option::Option<crate::model::LicenseConversionContext>,
        ) -> Self {
            self.inner = self.inner.set_source_license_context(input);
            self
        }
        /// <p>Information that identifies the license type you are converting to. For the structure of the destination license, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli">Convert a license type using the AWS CLI</a> in the <i>License Manager User Guide</i>.</p>
        pub fn destination_license_context(
            mut self,
            inp: crate::model::LicenseConversionContext,
        ) -> Self {
            self.inner = self.inner.destination_license_context(inp);
            self
        }
        /// <p>Information that identifies the license type you are converting to. For the structure of the destination license, see <a href="https://docs.aws.amazon.com/license-manager/latest/userguide/conversion-procedures.html#conversion-cli">Convert a license type using the AWS CLI</a> in the <i>License Manager User Guide</i>.</p>
        pub fn set_destination_license_context(
            mut self,
            input: std::option::Option<crate::model::LicenseConversionContext>,
        ) -> Self {
            self.inner = self.inner.set_destination_license_context(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLicenseManagerReportGenerator`.
    ///
    /// <p>Creates a report generator.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateLicenseManagerReportGenerator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_license_manager_report_generator_input::Builder,
    }
    impl<C, M, R> CreateLicenseManagerReportGenerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLicenseManagerReportGenerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLicenseManagerReportGeneratorOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CreateLicenseManagerReportGeneratorError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLicenseManagerReportGeneratorInputOperationOutputAlias,
                crate::output::CreateLicenseManagerReportGeneratorOutput,
                crate::error::CreateLicenseManagerReportGeneratorError,
                crate::input::CreateLicenseManagerReportGeneratorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Name of the report generator.</p>
        pub fn report_generator_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_generator_name(inp);
            self
        }
        /// <p>Name of the report generator.</p>
        pub fn set_report_generator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_report_generator_name(input);
            self
        }
        /// Appends an item to `Type`.
        ///
        /// To override the contents of this collection use [`set_type`](Self::set_type).
        ///
        /// <p>Type of reports to generate. The following report types an be generated:</p>
        /// <ul>
        /// <li>
        /// <p>License configuration report - Reports the number and details of consumed licenses for a license configuration.</p>
        /// </li>
        /// <li>
        /// <p>Resource report - Reports the tracked licenses and resource consumption for a license configuration.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, inp: impl Into<crate::model::ReportType>) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>Type of reports to generate. The following report types an be generated:</p>
        /// <ul>
        /// <li>
        /// <p>License configuration report - Reports the number and details of consumed licenses for a license configuration.</p>
        /// </li>
        /// <li>
        /// <p>Resource report - Reports the tracked licenses and resource consumption for a license configuration.</p>
        /// </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReportType>>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>Defines the type of license configuration the report generator tracks.</p>
        pub fn report_context(mut self, inp: crate::model::ReportContext) -> Self {
            self.inner = self.inner.report_context(inp);
            self
        }
        /// <p>Defines the type of license configuration the report generator tracks.</p>
        pub fn set_report_context(
            mut self,
            input: std::option::Option<crate::model::ReportContext>,
        ) -> Self {
            self.inner = self.inner.set_report_context(input);
            self
        }
        /// <p>Frequency by which reports are generated.  Reports can be generated daily, monthly, or weekly.</p>
        pub fn report_frequency(mut self, inp: crate::model::ReportFrequency) -> Self {
            self.inner = self.inner.report_frequency(inp);
            self
        }
        /// <p>Frequency by which reports are generated.  Reports can be generated daily, monthly, or weekly.</p>
        pub fn set_report_frequency(
            mut self,
            input: std::option::Option<crate::model::ReportFrequency>,
        ) -> Self {
            self.inner = self.inner.set_report_frequency(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Description of the report generator.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Description of the report generator.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to add to the report generator.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>Tags to add to the report generator.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateLicenseVersion`.
    ///
    /// <p>Creates a new version of the specified license.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateLicenseVersion<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_license_version_input::Builder,
    }
    impl<C, M, R> CreateLicenseVersion<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateLicenseVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateLicenseVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateLicenseVersionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateLicenseVersionInputOperationOutputAlias,
                crate::output::CreateLicenseVersionOutput,
                crate::error::CreateLicenseVersionError,
                crate::input::CreateLicenseVersionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn license_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_arn(input);
            self
        }
        /// <p>License name.</p>
        pub fn license_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_name(inp);
            self
        }
        /// <p>License name.</p>
        pub fn set_license_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_name(input);
            self
        }
        /// <p>Product name.</p>
        pub fn product_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.product_name(inp);
            self
        }
        /// <p>Product name.</p>
        pub fn set_product_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_product_name(input);
            self
        }
        /// <p>License issuer.</p>
        pub fn issuer(mut self, inp: crate::model::Issuer) -> Self {
            self.inner = self.inner.issuer(inp);
            self
        }
        /// <p>License issuer.</p>
        pub fn set_issuer(mut self, input: std::option::Option<crate::model::Issuer>) -> Self {
            self.inner = self.inner.set_issuer(input);
            self
        }
        /// <p>Home Region of the license.</p>
        pub fn home_region(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.home_region(inp);
            self
        }
        /// <p>Home Region of the license.</p>
        pub fn set_home_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_home_region(input);
            self
        }
        /// <p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>
        pub fn validity(mut self, inp: crate::model::DatetimeRange) -> Self {
            self.inner = self.inner.validity(inp);
            self
        }
        /// <p>Date and time range during which the license is valid, in ISO8601-UTC format.</p>
        pub fn set_validity(
            mut self,
            input: std::option::Option<crate::model::DatetimeRange>,
        ) -> Self {
            self.inner = self.inner.set_validity(input);
            self
        }
        /// Appends an item to `LicenseMetadata`.
        ///
        /// To override the contents of this collection use [`set_license_metadata`](Self::set_license_metadata).
        ///
        /// <p>Information about the license.</p>
        pub fn license_metadata(mut self, inp: impl Into<crate::model::Metadata>) -> Self {
            self.inner = self.inner.license_metadata(inp);
            self
        }
        /// <p>Information about the license.</p>
        pub fn set_license_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Metadata>>,
        ) -> Self {
            self.inner = self.inner.set_license_metadata(input);
            self
        }
        /// Appends an item to `Entitlements`.
        ///
        /// To override the contents of this collection use [`set_entitlements`](Self::set_entitlements).
        ///
        /// <p>License entitlements.</p>
        pub fn entitlements(mut self, inp: impl Into<crate::model::Entitlement>) -> Self {
            self.inner = self.inner.entitlements(inp);
            self
        }
        /// <p>License entitlements.</p>
        pub fn set_entitlements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Entitlement>>,
        ) -> Self {
            self.inner = self.inner.set_entitlements(input);
            self
        }
        /// <p>Configuration for consumption of the license. Choose a provisional configuration for workloads
        /// running with continuous connectivity. Choose a borrow configuration for workloads with offline
        /// usage.</p>
        pub fn consumption_configuration(
            mut self,
            inp: crate::model::ConsumptionConfiguration,
        ) -> Self {
            self.inner = self.inner.consumption_configuration(inp);
            self
        }
        /// <p>Configuration for consumption of the license. Choose a provisional configuration for workloads
        /// running with continuous connectivity. Choose a borrow configuration for workloads with offline
        /// usage.</p>
        pub fn set_consumption_configuration(
            mut self,
            input: std::option::Option<crate::model::ConsumptionConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_consumption_configuration(input);
            self
        }
        /// <p>License status.</p>
        pub fn status(mut self, inp: crate::model::LicenseStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>License status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::LicenseStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Current version of the license.</p>
        pub fn source_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_version(inp);
            self
        }
        /// <p>Current version of the license.</p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateToken`.
    ///
    /// <p>Creates a long-lived token.</p>
    /// <p>A refresh token is a JWT token used to get an access token. With an access token,
    /// you can call AssumeRoleWithWebIdentity to get role credentials that you can use to
    /// call License Manager to manage the specified license.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateToken<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_token_input::Builder,
    }
    impl<C, M, R> CreateToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTokenInputOperationOutputAlias,
                crate::output::CreateTokenOutput,
                crate::error::CreateTokenError,
                crate::input::CreateTokenInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license. The ARN is mapped to the aud claim of the
        /// JWT token.</p>
        pub fn license_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license. The ARN is mapped to the aud claim of the
        /// JWT token.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_arn(input);
            self
        }
        /// Appends an item to `RoleArns`.
        ///
        /// To override the contents of this collection use [`set_role_arns`](Self::set_role_arns).
        ///
        /// <p>Amazon Resource Name (ARN) of the IAM roles to embed in the token.
        /// License Manager does not check whether the roles are in use.</p>
        pub fn role_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arns(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the IAM roles to embed in the token.
        /// License Manager does not check whether the roles are in use.</p>
        pub fn set_role_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_role_arns(input);
            self
        }
        /// <p>Token expiration, in days, counted from token creation. The default is 365 days.</p>
        pub fn expiration_in_days(mut self, inp: i32) -> Self {
            self.inner = self.inner.expiration_in_days(inp);
            self
        }
        /// <p>Token expiration, in days, counted from token creation. The default is 365 days.</p>
        pub fn set_expiration_in_days(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_expiration_in_days(input);
            self
        }
        /// Appends an item to `TokenProperties`.
        ///
        /// To override the contents of this collection use [`set_token_properties`](Self::set_token_properties).
        ///
        /// <p>Data specified by the caller to be included in the JWT token. The data is mapped
        /// to the amr claim of the JWT token.</p>
        pub fn token_properties(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token_properties(inp);
            self
        }
        /// <p>Data specified by the caller to be included in the JWT token. The data is mapped
        /// to the amr claim of the JWT token.</p>
        pub fn set_token_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_token_properties(input);
            self
        }
        /// <p>Idempotency token, valid for 10 minutes.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Idempotency token, valid for 10 minutes.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteGrant`.
    ///
    /// <p>Deletes the specified grant.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteGrant<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_grant_input::Builder,
    }
    impl<C, M, R> DeleteGrant<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteGrant`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteGrantOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteGrantError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteGrantInputOperationOutputAlias,
                crate::output::DeleteGrantOutput,
                crate::error::DeleteGrantError,
                crate::input::DeleteGrantInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn grant_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn set_grant_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_arn(input);
            self
        }
        /// <p>The Status reason for the delete request.</p>
        pub fn status_reason(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_reason(inp);
            self
        }
        /// <p>The Status reason for the delete request.</p>
        pub fn set_status_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_status_reason(input);
            self
        }
        /// <p>Current version of the grant.</p>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>Current version of the grant.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLicense`.
    ///
    /// <p>Deletes the specified license.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteLicense<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_license_input::Builder,
    }
    impl<C, M, R> DeleteLicense<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLicense`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLicenseOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLicenseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLicenseInputOperationOutputAlias,
                crate::output::DeleteLicenseOutput,
                crate::error::DeleteLicenseError,
                crate::input::DeleteLicenseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn license_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_arn(input);
            self
        }
        /// <p>Current version of the license.</p>
        pub fn source_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_version(inp);
            self
        }
        /// <p>Current version of the license.</p>
        pub fn set_source_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLicenseConfiguration`.
    ///
    /// <p>Deletes the specified license configuration.</p>
    /// <p>You cannot delete a license configuration that is in use.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteLicenseConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_license_configuration_input::Builder,
    }
    impl<C, M, R> DeleteLicenseConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLicenseConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLicenseConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteLicenseConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLicenseConfigurationInputOperationOutputAlias,
                crate::output::DeleteLicenseConfigurationOutput,
                crate::error::DeleteLicenseConfigurationError,
                crate::input::DeleteLicenseConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ID of the license configuration.</p>
        pub fn license_configuration_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_configuration_arn(inp);
            self
        }
        /// <p>ID of the license configuration.</p>
        pub fn set_license_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_configuration_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteLicenseManagerReportGenerator`.
    ///
    /// <p>Deletes the specified report generator.</p>
    /// <p>This action deletes the report generator, which stops it from generating future reports.
    /// The action cannot be reversed. It has no effect on the previous reports from this generator.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteLicenseManagerReportGenerator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_license_manager_report_generator_input::Builder,
    }
    impl<C, M, R> DeleteLicenseManagerReportGenerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteLicenseManagerReportGenerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteLicenseManagerReportGeneratorOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteLicenseManagerReportGeneratorError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteLicenseManagerReportGeneratorInputOperationOutputAlias,
                crate::output::DeleteLicenseManagerReportGeneratorOutput,
                crate::error::DeleteLicenseManagerReportGeneratorError,
                crate::input::DeleteLicenseManagerReportGeneratorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the report generator to be deleted.</p>
        pub fn license_manager_report_generator_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.license_manager_report_generator_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the report generator to be deleted.</p>
        pub fn set_license_manager_report_generator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_manager_report_generator_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteToken`.
    ///
    /// <p>Deletes the specified token. Must be called in the license home Region.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteToken<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_token_input::Builder,
    }
    impl<C, M, R> DeleteToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTokenInputOperationOutputAlias,
                crate::output::DeleteTokenOutput,
                crate::error::DeleteTokenError,
                crate::input::DeleteTokenInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Token ID.</p>
        pub fn token_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token_id(inp);
            self
        }
        /// <p>Token ID.</p>
        pub fn set_token_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExtendLicenseConsumption`.
    ///
    /// <p>Extends the expiration date for license consumption.</p>
    #[derive(std::fmt::Debug)]
    pub struct ExtendLicenseConsumption<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::extend_license_consumption_input::Builder,
    }
    impl<C, M, R> ExtendLicenseConsumption<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExtendLicenseConsumption`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExtendLicenseConsumptionOutput,
            aws_smithy_http::result::SdkError<crate::error::ExtendLicenseConsumptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExtendLicenseConsumptionInputOperationOutputAlias,
                crate::output::ExtendLicenseConsumptionOutput,
                crate::error::ExtendLicenseConsumptionError,
                crate::input::ExtendLicenseConsumptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>License consumption token.</p>
        pub fn license_consumption_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_consumption_token(inp);
            self
        }
        /// <p>License consumption token.</p>
        pub fn set_license_consumption_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_consumption_token(input);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request. Provides an error response if you do not have the required permissions.</p>
        pub fn dry_run(mut self, inp: bool) -> Self {
            self.inner = self.inner.dry_run(inp);
            self
        }
        /// <p>Checks whether you have the required permissions for the action, without actually making the request. Provides an error response if you do not have the required permissions.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAccessToken`.
    ///
    /// <p>Gets a temporary access token to use with AssumeRoleWithWebIdentity. Access tokens
    /// are valid for one hour.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAccessToken<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_access_token_input::Builder,
    }
    impl<C, M, R> GetAccessToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAccessToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAccessTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAccessTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAccessTokenInputOperationOutputAlias,
                crate::output::GetAccessTokenOutput,
                crate::error::GetAccessTokenError,
                crate::input::GetAccessTokenInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Refresh token, encoded as a JWT token.</p>
        pub fn token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token(inp);
            self
        }
        /// <p>Refresh token, encoded as a JWT token.</p>
        pub fn set_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_token(input);
            self
        }
        /// Appends an item to `TokenProperties`.
        ///
        /// To override the contents of this collection use [`set_token_properties`](Self::set_token_properties).
        ///
        /// <p>Token properties to validate against those present in the JWT token.</p>
        pub fn token_properties(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token_properties(inp);
            self
        }
        /// <p>Token properties to validate against those present in the JWT token.</p>
        pub fn set_token_properties(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_token_properties(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetGrant`.
    ///
    /// <p>Gets detailed information about the specified grant.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetGrant<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_grant_input::Builder,
    }
    impl<C, M, R> GetGrant<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetGrant`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetGrantOutput,
            aws_smithy_http::result::SdkError<crate::error::GetGrantError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetGrantInputOperationOutputAlias,
                crate::output::GetGrantOutput,
                crate::error::GetGrantError,
                crate::input::GetGrantInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn grant_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn set_grant_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_arn(input);
            self
        }
        /// <p>Grant version.</p>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>Grant version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLicense`.
    ///
    /// <p>Gets detailed information about the specified license.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLicense<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_license_input::Builder,
    }
    impl<C, M, R> GetLicense<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLicense`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLicenseOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLicenseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLicenseInputOperationOutputAlias,
                crate::output::GetLicenseOutput,
                crate::error::GetLicenseError,
                crate::input::GetLicenseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn license_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_arn(input);
            self
        }
        /// <p>License version.</p>
        pub fn version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.version(inp);
            self
        }
        /// <p>License version.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLicenseConfiguration`.
    ///
    /// <p>Gets detailed information about the specified license configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLicenseConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_license_configuration_input::Builder,
    }
    impl<C, M, R> GetLicenseConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLicenseConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLicenseConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLicenseConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLicenseConfigurationInputOperationOutputAlias,
                crate::output::GetLicenseConfigurationOutput,
                crate::error::GetLicenseConfigurationError,
                crate::input::GetLicenseConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn license_configuration_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_configuration_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn set_license_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_configuration_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLicenseConversionTask`.
    ///
    /// <p>Gets information about the specified license type conversion task.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLicenseConversionTask<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_license_conversion_task_input::Builder,
    }
    impl<C, M, R> GetLicenseConversionTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLicenseConversionTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLicenseConversionTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLicenseConversionTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLicenseConversionTaskInputOperationOutputAlias,
                crate::output::GetLicenseConversionTaskOutput,
                crate::error::GetLicenseConversionTaskError,
                crate::input::GetLicenseConversionTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>ID of the license type conversion task to retrieve information on.</p>
        pub fn license_conversion_task_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_conversion_task_id(inp);
            self
        }
        /// <p>ID of the license type conversion task to retrieve information on.</p>
        pub fn set_license_conversion_task_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_conversion_task_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLicenseManagerReportGenerator`.
    ///
    /// <p>Gets information about the specified report generator.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLicenseManagerReportGenerator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_license_manager_report_generator_input::Builder,
    }
    impl<C, M, R> GetLicenseManagerReportGenerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLicenseManagerReportGenerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLicenseManagerReportGeneratorOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLicenseManagerReportGeneratorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLicenseManagerReportGeneratorInputOperationOutputAlias,
                crate::output::GetLicenseManagerReportGeneratorOutput,
                crate::error::GetLicenseManagerReportGeneratorError,
                crate::input::GetLicenseManagerReportGeneratorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the report generator.</p>
        pub fn license_manager_report_generator_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.license_manager_report_generator_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the report generator.</p>
        pub fn set_license_manager_report_generator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_manager_report_generator_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetLicenseUsage`.
    ///
    /// <p>Gets detailed information about the usage of the specified license.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetLicenseUsage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_license_usage_input::Builder,
    }
    impl<C, M, R> GetLicenseUsage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetLicenseUsage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetLicenseUsageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetLicenseUsageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetLicenseUsageInputOperationOutputAlias,
                crate::output::GetLicenseUsageOutput,
                crate::error::GetLicenseUsageError,
                crate::input::GetLicenseUsageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn license_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetServiceSettings`.
    ///
    /// <p>Gets the License Manager settings for the current Region.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetServiceSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_service_settings_input::Builder,
    }
    impl<C, M, R> GetServiceSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetServiceSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetServiceSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetServiceSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetServiceSettingsInputOperationOutputAlias,
                crate::output::GetServiceSettingsOutput,
                crate::error::GetServiceSettingsError,
                crate::input::GetServiceSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `ListAssociationsForLicenseConfiguration`.
    ///
    /// <p>Lists the resource associations for the specified license configuration.</p>
    /// <p>Resource associations need not consume licenses from a license configuration.
    /// For example, an AMI or a stopped instance might not consume a license (depending on
    /// the license rules).</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAssociationsForLicenseConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_associations_for_license_configuration_input::Builder,
    }
    impl<C, M, R> ListAssociationsForLicenseConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAssociationsForLicenseConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAssociationsForLicenseConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListAssociationsForLicenseConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAssociationsForLicenseConfigurationInputOperationOutputAlias,
                crate::output::ListAssociationsForLicenseConfigurationOutput,
                crate::error::ListAssociationsForLicenseConfigurationError,
                crate::input::ListAssociationsForLicenseConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of a license configuration.</p>
        pub fn license_configuration_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_configuration_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of a license configuration.</p>
        pub fn set_license_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_configuration_arn(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDistributedGrants`.
    ///
    /// <p>Lists the grants distributed for the specified license.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDistributedGrants<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_distributed_grants_input::Builder,
    }
    impl<C, M, R> ListDistributedGrants<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDistributedGrants`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDistributedGrantsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDistributedGrantsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDistributedGrantsInputOperationOutputAlias,
                crate::output::ListDistributedGrantsOutput,
                crate::error::ListDistributedGrantsError,
                crate::input::ListDistributedGrantsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `GrantArns`.
        ///
        /// To override the contents of this collection use [`set_grant_arns`](Self::set_grant_arns).
        ///
        /// <p>Amazon Resource Names (ARNs) of the grants.</p>
        pub fn grant_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_arns(inp);
            self
        }
        /// <p>Amazon Resource Names (ARNs) of the grants.</p>
        pub fn set_grant_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_grant_arns(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LicenseArn</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GrantStatus</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GranteePrincipalARN</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ProductSKU</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LicenseIssuerName</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LicenseArn</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GrantStatus</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GranteePrincipalARN</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ProductSKU</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LicenseIssuerName</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFailuresForLicenseConfigurationOperations`.
    ///
    /// <p>Lists the license configuration operations that failed.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListFailuresForLicenseConfigurationOperations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_failures_for_license_configuration_operations_input::Builder,
    }
    impl<C, M, R> ListFailuresForLicenseConfigurationOperations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFailuresForLicenseConfigurationOperations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
                                pub async fn send(self) -> std::result::Result<crate::output::ListFailuresForLicenseConfigurationOperationsOutput, aws_smithy_http::result::SdkError<crate::error::ListFailuresForLicenseConfigurationOperationsError>>
                                where
                                    R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<crate::input::ListFailuresForLicenseConfigurationOperationsInputOperationOutputAlias,
                                    crate::output::ListFailuresForLicenseConfigurationOperationsOutput,
                                    crate::error::ListFailuresForLicenseConfigurationOperationsError,
                                    crate::input::ListFailuresForLicenseConfigurationOperationsInputOperationRetryAlias>,
                                {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name of the license configuration.</p>
        pub fn license_configuration_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_configuration_arn(inp);
            self
        }
        /// <p>Amazon Resource Name of the license configuration.</p>
        pub fn set_license_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_configuration_arn(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLicenseConfigurations`.
    ///
    /// <p>Lists the license configurations for your account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLicenseConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_license_configurations_input::Builder,
    }
    impl<C, M, R> ListLicenseConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLicenseConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLicenseConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLicenseConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLicenseConfigurationsInputOperationOutputAlias,
                crate::output::ListLicenseConfigurationsOutput,
                crate::error::ListLicenseConfigurationsError,
                crate::input::ListLicenseConfigurationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `LicenseConfigurationArns`.
        ///
        /// To override the contents of this collection use [`set_license_configuration_arns`](Self::set_license_configuration_arns).
        ///
        /// <p>Amazon Resource Names (ARN) of the license configurations.</p>
        pub fn license_configuration_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_configuration_arns(inp);
            self
        }
        /// <p>Amazon Resource Names (ARN) of the license configurations.</p>
        pub fn set_license_configuration_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_license_configuration_arns(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters and logical operators
        /// are supported:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>licenseCountingType</code> - The dimension for which licenses are counted.
        /// Possible values are <code>vCPU</code> | <code>Instance</code> | <code>Core</code> | <code>Socket</code>.
        /// Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>enforceLicenseCount</code> - A Boolean value that indicates whether hard license enforcement is used.
        /// Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>usagelimitExceeded</code> - A Boolean value that indicates whether the available licenses have been exceeded.
        /// Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters to scope the results. The following filters and logical operators
        /// are supported:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>licenseCountingType</code> - The dimension for which licenses are counted.
        /// Possible values are <code>vCPU</code> | <code>Instance</code> | <code>Core</code> | <code>Socket</code>.
        /// Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>enforceLicenseCount</code> - A Boolean value that indicates whether hard license enforcement is used.
        /// Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>usagelimitExceeded</code> - A Boolean value that indicates whether the available licenses have been exceeded.
        /// Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLicenseConversionTasks`.
    ///
    /// <p>Lists the license type conversion tasks for your account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLicenseConversionTasks<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_license_conversion_tasks_input::Builder,
    }
    impl<C, M, R> ListLicenseConversionTasks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLicenseConversionTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLicenseConversionTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLicenseConversionTasksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLicenseConversionTasksInputOperationOutputAlias,
                crate::output::ListLicenseConversionTasksOutput,
                crate::error::ListLicenseConversionTasksError,
                crate::input::ListLicenseConversionTasksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>
        /// Filters to scope the results. Valid filters are <code>ResourceArns</code> and <code>Status</code>.
        /// </p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>
        /// Filters to scope the results. Valid filters are <code>ResourceArns</code> and <code>Status</code>.
        /// </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLicenseManagerReportGenerators`.
    ///
    /// <p>Lists the report generators for your account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLicenseManagerReportGenerators<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_license_manager_report_generators_input::Builder,
    }
    impl<C, M, R> ListLicenseManagerReportGenerators<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLicenseManagerReportGenerators`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLicenseManagerReportGeneratorsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListLicenseManagerReportGeneratorsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLicenseManagerReportGeneratorsInputOperationOutputAlias,
                crate::output::ListLicenseManagerReportGeneratorsOutput,
                crate::error::ListLicenseManagerReportGeneratorsError,
                crate::input::ListLicenseManagerReportGeneratorsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters are supported: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LicenseConfigurationArn</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters to scope the results. The following filters are supported: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LicenseConfigurationArn</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLicenses`.
    ///
    /// <p>Lists the licenses for your account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLicenses<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_licenses_input::Builder,
    }
    impl<C, M, R> ListLicenses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLicenses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLicensesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLicensesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLicensesInputOperationOutputAlias,
                crate::output::ListLicensesOutput,
                crate::error::ListLicensesError,
                crate::input::ListLicensesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `LicenseArns`.
        ///
        /// To override the contents of this collection use [`set_license_arns`](Self::set_license_arns).
        ///
        /// <p>Amazon Resource Names (ARNs) of the licenses.</p>
        pub fn license_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_arns(inp);
            self
        }
        /// <p>Amazon Resource Names (ARNs) of the licenses.</p>
        pub fn set_license_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_license_arns(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Beneficiary</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ProductSKU</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Fingerprint</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Beneficiary</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ProductSKU</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Fingerprint</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLicenseSpecificationsForResource`.
    ///
    /// <p>Describes the license configurations for the specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLicenseSpecificationsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_license_specifications_for_resource_input::Builder,
    }
    impl<C, M, R> ListLicenseSpecificationsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLicenseSpecificationsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLicenseSpecificationsForResourceOutput,
            aws_smithy_http::result::SdkError<
                crate::error::ListLicenseSpecificationsForResourceError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLicenseSpecificationsForResourceInputOperationOutputAlias,
                crate::output::ListLicenseSpecificationsForResourceOutput,
                crate::error::ListLicenseSpecificationsForResourceError,
                crate::input::ListLicenseSpecificationsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of a resource that has an associated license configuration.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of a resource that has an associated license configuration.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLicenseVersions`.
    ///
    /// <p>Lists all versions of the specified license.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLicenseVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_license_versions_input::Builder,
    }
    impl<C, M, R> ListLicenseVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLicenseVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLicenseVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLicenseVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLicenseVersionsInputOperationOutputAlias,
                crate::output::ListLicenseVersionsOutput,
                crate::error::ListLicenseVersionsError,
                crate::input::ListLicenseVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn license_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license.</p>
        pub fn set_license_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_license_arn(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReceivedGrants`.
    ///
    /// <p>Lists grants that are received but not accepted.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListReceivedGrants<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_received_grants_input::Builder,
    }
    impl<C, M, R> ListReceivedGrants<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListReceivedGrants`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReceivedGrantsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReceivedGrantsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListReceivedGrantsInputOperationOutputAlias,
                crate::output::ListReceivedGrantsOutput,
                crate::error::ListReceivedGrantsError,
                crate::input::ListReceivedGrantsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `GrantArns`.
        ///
        /// To override the contents of this collection use [`set_grant_arns`](Self::set_grant_arns).
        ///
        /// <p>Amazon Resource Names (ARNs) of the grants.</p>
        pub fn grant_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_arns(inp);
            self
        }
        /// <p>Amazon Resource Names (ARNs) of the grants.</p>
        pub fn set_grant_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_grant_arns(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ProductSKU</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LicenseIssuerName</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LicenseArn</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GrantStatus</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GranterAccountId</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ProductSKU</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LicenseIssuerName</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>LicenseArn</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GrantStatus</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>GranterAccountId</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReceivedLicenses`.
    ///
    /// <p>Lists received licenses.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListReceivedLicenses<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_received_licenses_input::Builder,
    }
    impl<C, M, R> ListReceivedLicenses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListReceivedLicenses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReceivedLicensesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReceivedLicensesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListReceivedLicensesInputOperationOutputAlias,
                crate::output::ListReceivedLicensesOutput,
                crate::error::ListReceivedLicensesError,
                crate::input::ListReceivedLicensesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `LicenseArns`.
        ///
        /// To override the contents of this collection use [`set_license_arns`](Self::set_license_arns).
        ///
        /// <p>Amazon Resource Names (ARNs) of the licenses.</p>
        pub fn license_arns(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_arns(inp);
            self
        }
        /// <p>Amazon Resource Names (ARNs) of the licenses.</p>
        pub fn set_license_arns(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_license_arns(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ProductSKU</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Fingerprint</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IssuerName</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Beneficiary</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters to scope the results. The following filters are supported:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ProductSKU</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Fingerprint</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IssuerName</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Beneficiary</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListResourceInventory`.
    ///
    /// <p>Lists resources managed using Systems Manager inventory.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListResourceInventory<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_resource_inventory_input::Builder,
    }
    impl<C, M, R> ListResourceInventory<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListResourceInventory`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListResourceInventoryOutput,
            aws_smithy_http::result::SdkError<crate::error::ListResourceInventoryError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListResourceInventoryInputOperationOutputAlias,
                crate::output::ListResourceInventoryOutput,
                crate::error::ListResourceInventoryError,
                crate::input::ListResourceInventoryInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters and logical operators
        /// are supported:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>account_id</code> - The ID of the Amazon Web Services account that owns the resource.
        /// Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>application_name</code> - The name of the application.
        /// Logical operators are <code>EQUALS</code> | <code>BEGINS_WITH</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>license_included</code> - The type of license included.
        /// Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
        /// Possible values are <code>sql-server-enterprise</code> |
        /// <code>sql-server-standard</code> |
        /// <code>sql-server-web</code> |  
        /// <code>windows-server-datacenter</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>platform</code> - The platform of the resource.
        /// Logical operators are <code>EQUALS</code> | <code>BEGINS_WITH</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>resource_id</code> - The ID of the resource.
        /// Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>tag:<key></code> - The key/value combination of a tag assigned
        /// to the resource. Logical operators are <code>EQUALS</code> (single account) or
        /// <code>EQUALS</code> | <code>NOT_EQUALS</code> (cross account).</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::InventoryFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters to scope the results. The following filters and logical operators
        /// are supported:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>account_id</code> - The ID of the Amazon Web Services account that owns the resource.
        /// Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>application_name</code> - The name of the application.
        /// Logical operators are <code>EQUALS</code> | <code>BEGINS_WITH</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>license_included</code> - The type of license included.
        /// Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
        /// Possible values are <code>sql-server-enterprise</code> |
        /// <code>sql-server-standard</code> |
        /// <code>sql-server-web</code> |  
        /// <code>windows-server-datacenter</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>platform</code> - The platform of the resource.
        /// Logical operators are <code>EQUALS</code> | <code>BEGINS_WITH</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>resource_id</code> - The ID of the resource.
        /// Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>tag:<key></code> - The key/value combination of a tag assigned
        /// to the resource. Logical operators are <code>EQUALS</code> (single account) or
        /// <code>EQUALS</code> | <code>NOT_EQUALS</code> (cross account).</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InventoryFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags for the specified license configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTokens`.
    ///
    /// <p>Lists your tokens.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTokens<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tokens_input::Builder,
    }
    impl<C, M, R> ListTokens<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTokens`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTokensOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTokensError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTokensInputOperationOutputAlias,
                crate::output::ListTokensOutput,
                crate::error::ListTokensError,
                crate::input::ListTokensInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TokenIds`.
        ///
        /// To override the contents of this collection use [`set_token_ids`](Self::set_token_ids).
        ///
        /// <p>Token IDs.</p>
        pub fn token_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.token_ids(inp);
            self
        }
        /// <p>Token IDs.</p>
        pub fn set_token_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_token_ids(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filter is supported:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LicenseArns</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters to scope the results. The following filter is supported:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>LicenseArns</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUsageForLicenseConfiguration`.
    ///
    /// <p>Lists all license usage records for a license configuration, displaying license
    /// consumption details by resource at a selected point in time. Use this action to audit the
    /// current license consumption for any license inventory and configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListUsageForLicenseConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_usage_for_license_configuration_input::Builder,
    }
    impl<C, M, R> ListUsageForLicenseConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUsageForLicenseConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUsageForLicenseConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUsageForLicenseConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUsageForLicenseConfigurationInputOperationOutputAlias,
                crate::output::ListUsageForLicenseConfigurationOutput,
                crate::error::ListUsageForLicenseConfigurationError,
                crate::input::ListUsageForLicenseConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn license_configuration_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_configuration_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn set_license_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_configuration_arn(input);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Maximum number of results to return in a single call.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters to scope the results. The following filters and logical operators
        /// are supported:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>resourceArn</code> - The ARN of the license configuration resource.
        /// Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>resourceType</code> - The resource type (<code>EC2_INSTANCE</code> | <code>EC2_HOST</code> | <code>EC2_AMI</code> | <code>SYSTEMS_MANAGER_MANAGED_INSTANCE</code>).
        /// Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>resourceAccount</code> - The ID of the account that owns the resource.
        /// Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p>
        /// </li>
        /// </ul>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters to scope the results. The following filters and logical operators
        /// are supported:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>resourceArn</code> - The ARN of the license configuration resource.
        /// Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>resourceType</code> - The resource type (<code>EC2_INSTANCE</code> | <code>EC2_HOST</code> | <code>EC2_AMI</code> | <code>SYSTEMS_MANAGER_MANAGED_INSTANCE</code>).
        /// Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>resourceAccount</code> - The ID of the account that owns the resource.
        /// Logical operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectGrant`.
    ///
    /// <p>Rejects the specified grant.</p>
    #[derive(std::fmt::Debug)]
    pub struct RejectGrant<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reject_grant_input::Builder,
    }
    impl<C, M, R> RejectGrant<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RejectGrant`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectGrantOutput,
            aws_smithy_http::result::SdkError<crate::error::RejectGrantError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RejectGrantInputOperationOutputAlias,
                crate::output::RejectGrantOutput,
                crate::error::RejectGrantError,
                crate::input::RejectGrantInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn grant_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.grant_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the grant.</p>
        pub fn set_grant_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_grant_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds the specified tags to the specified license configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the specified tags from the specified license configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>Keys identifying the tags to remove.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>Keys identifying the tags to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLicenseConfiguration`.
    ///
    /// <p>Modifies the attributes of an existing license configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateLicenseConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_license_configuration_input::Builder,
    }
    impl<C, M, R> UpdateLicenseConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLicenseConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLicenseConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateLicenseConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLicenseConfigurationInputOperationOutputAlias,
                crate::output::UpdateLicenseConfigurationOutput,
                crate::error::UpdateLicenseConfigurationError,
                crate::input::UpdateLicenseConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn license_configuration_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_configuration_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the license configuration.</p>
        pub fn set_license_configuration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_configuration_arn(input);
            self
        }
        /// <p>New status of the license configuration.</p>
        pub fn license_configuration_status(
            mut self,
            inp: crate::model::LicenseConfigurationStatus,
        ) -> Self {
            self.inner = self.inner.license_configuration_status(inp);
            self
        }
        /// <p>New status of the license configuration.</p>
        pub fn set_license_configuration_status(
            mut self,
            input: std::option::Option<crate::model::LicenseConfigurationStatus>,
        ) -> Self {
            self.inner = self.inner.set_license_configuration_status(input);
            self
        }
        /// Appends an item to `LicenseRules`.
        ///
        /// To override the contents of this collection use [`set_license_rules`](Self::set_license_rules).
        ///
        /// <p>New license rule. The only rule that you can add after you create a license
        /// configuration is licenseAffinityToHost.</p>
        pub fn license_rules(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.license_rules(inp);
            self
        }
        /// <p>New license rule. The only rule that you can add after you create a license
        /// configuration is licenseAffinityToHost.</p>
        pub fn set_license_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_license_rules(input);
            self
        }
        /// <p>New number of licenses managed by the license configuration.</p>
        pub fn license_count(mut self, inp: i64) -> Self {
            self.inner = self.inner.license_count(inp);
            self
        }
        /// <p>New number of licenses managed by the license configuration.</p>
        pub fn set_license_count(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_license_count(input);
            self
        }
        /// <p>New hard limit of the number of available licenses.</p>
        pub fn license_count_hard_limit(mut self, inp: bool) -> Self {
            self.inner = self.inner.license_count_hard_limit(inp);
            self
        }
        /// <p>New hard limit of the number of available licenses.</p>
        pub fn set_license_count_hard_limit(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_license_count_hard_limit(input);
            self
        }
        /// <p>New name of the license configuration.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>New name of the license configuration.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>New description of the license configuration.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>New description of the license configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `ProductInformationList`.
        ///
        /// To override the contents of this collection use [`set_product_information_list`](Self::set_product_information_list).
        ///
        /// <p>New product information.</p>
        pub fn product_information_list(
            mut self,
            inp: impl Into<crate::model::ProductInformation>,
        ) -> Self {
            self.inner = self.inner.product_information_list(inp);
            self
        }
        /// <p>New product information.</p>
        pub fn set_product_information_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProductInformation>>,
        ) -> Self {
            self.inner = self.inner.set_product_information_list(input);
            self
        }
        /// <p>When true, disassociates a resource when software is uninstalled.</p>
        pub fn disassociate_when_not_found(mut self, inp: bool) -> Self {
            self.inner = self.inner.disassociate_when_not_found(inp);
            self
        }
        /// <p>When true, disassociates a resource when software is uninstalled.</p>
        pub fn set_disassociate_when_not_found(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disassociate_when_not_found(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLicenseManagerReportGenerator`.
    ///
    /// <p>Updates a report generator.</p>
    /// <p>After you make changes to a report generator, it starts generating new reports within 60 minutes of being updated.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateLicenseManagerReportGenerator<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_license_manager_report_generator_input::Builder,
    }
    impl<C, M, R> UpdateLicenseManagerReportGenerator<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLicenseManagerReportGenerator`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLicenseManagerReportGeneratorOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateLicenseManagerReportGeneratorError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLicenseManagerReportGeneratorInputOperationOutputAlias,
                crate::output::UpdateLicenseManagerReportGeneratorOutput,
                crate::error::UpdateLicenseManagerReportGeneratorError,
                crate::input::UpdateLicenseManagerReportGeneratorInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the report generator to update.</p>
        pub fn license_manager_report_generator_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.license_manager_report_generator_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the report generator to update.</p>
        pub fn set_license_manager_report_generator_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_license_manager_report_generator_arn(input);
            self
        }
        /// <p>Name of the report generator.</p>
        pub fn report_generator_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.report_generator_name(inp);
            self
        }
        /// <p>Name of the report generator.</p>
        pub fn set_report_generator_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_report_generator_name(input);
            self
        }
        /// Appends an item to `Type`.
        ///
        /// To override the contents of this collection use [`set_type`](Self::set_type).
        ///
        /// <p>Type of reports to generate. The following report types are supported:</p>
        /// <ul>
        /// <li>
        /// <p>License configuration report - Reports the number and details of consumed licenses for a license configuration.</p>
        /// </li>
        /// <li>
        /// <p>Resource report - Reports the tracked licenses and resource consumption for a license configuration.</p>
        /// </li>
        /// </ul>
        pub fn r#type(mut self, inp: impl Into<crate::model::ReportType>) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>Type of reports to generate. The following report types are supported:</p>
        /// <ul>
        /// <li>
        /// <p>License configuration report - Reports the number and details of consumed licenses for a license configuration.</p>
        /// </li>
        /// <li>
        /// <p>Resource report - Reports the tracked licenses and resource consumption for a license configuration.</p>
        /// </li>
        /// </ul>
        pub fn set_type(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReportType>>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The report context.</p>
        pub fn report_context(mut self, inp: crate::model::ReportContext) -> Self {
            self.inner = self.inner.report_context(inp);
            self
        }
        /// <p>The report context.</p>
        pub fn set_report_context(
            mut self,
            input: std::option::Option<crate::model::ReportContext>,
        ) -> Self {
            self.inner = self.inner.set_report_context(input);
            self
        }
        /// <p>Frequency by which reports are generated.</p>
        pub fn report_frequency(mut self, inp: crate::model::ReportFrequency) -> Self {
            self.inner = self.inner.report_frequency(inp);
            self
        }
        /// <p>Frequency by which reports are generated.</p>
        pub fn set_report_frequency(
            mut self,
            input: std::option::Option<crate::model::ReportFrequency>,
        ) -> Self {
            self.inner = self.inner.set_report_frequency(input);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Description of the report generator.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Description of the report generator.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateLicenseSpecificationsForResource`.
    ///
    /// <p>Adds or removes the specified license configurations for the specified Amazon Web Services resource.</p>
    /// <p>You can update the license specifications of AMIs, instances, and hosts.
    /// You cannot update the license specifications for launch templates and CloudFormation templates,
    /// as they send license configurations to the operation that creates the resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateLicenseSpecificationsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_license_specifications_for_resource_input::Builder,
    }
    impl<C, M, R> UpdateLicenseSpecificationsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateLicenseSpecificationsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateLicenseSpecificationsForResourceOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateLicenseSpecificationsForResourceError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateLicenseSpecificationsForResourceInputOperationOutputAlias,
                crate::output::UpdateLicenseSpecificationsForResourceOutput,
                crate::error::UpdateLicenseSpecificationsForResourceError,
                crate::input::UpdateLicenseSpecificationsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon Web Services resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon Web Services resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `AddLicenseSpecifications`.
        ///
        /// To override the contents of this collection use [`set_add_license_specifications`](Self::set_add_license_specifications).
        ///
        /// <p>ARNs of the license configurations to add.</p>
        pub fn add_license_specifications(
            mut self,
            inp: impl Into<crate::model::LicenseSpecification>,
        ) -> Self {
            self.inner = self.inner.add_license_specifications(inp);
            self
        }
        /// <p>ARNs of the license configurations to add.</p>
        pub fn set_add_license_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LicenseSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_add_license_specifications(input);
            self
        }
        /// Appends an item to `RemoveLicenseSpecifications`.
        ///
        /// To override the contents of this collection use [`set_remove_license_specifications`](Self::set_remove_license_specifications).
        ///
        /// <p>ARNs of the license configurations to remove.</p>
        pub fn remove_license_specifications(
            mut self,
            inp: impl Into<crate::model::LicenseSpecification>,
        ) -> Self {
            self.inner = self.inner.remove_license_specifications(inp);
            self
        }
        /// <p>ARNs of the license configurations to remove.</p>
        pub fn set_remove_license_specifications(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::LicenseSpecification>>,
        ) -> Self {
            self.inner = self.inner.set_remove_license_specifications(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateServiceSettings`.
    ///
    /// <p>Updates License Manager settings for the current Region.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateServiceSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_service_settings_input::Builder,
    }
    impl<C, M, R> UpdateServiceSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateServiceSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateServiceSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateServiceSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateServiceSettingsInputOperationOutputAlias,
                crate::output::UpdateServiceSettingsOutput,
                crate::error::UpdateServiceSettingsError,
                crate::input::UpdateServiceSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon S3 bucket where the License Manager information is stored.</p>
        pub fn s3_bucket_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_bucket_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon S3 bucket where the License Manager information is stored.</p>
        pub fn set_s3_bucket_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_bucket_arn(input);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon SNS topic used for License Manager alerts.</p>
        pub fn sns_topic_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the Amazon SNS topic used for License Manager alerts.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p>Enables integration with Organizations for cross-account discovery.</p>
        pub fn organization_configuration(
            mut self,
            inp: crate::model::OrganizationConfiguration,
        ) -> Self {
            self.inner = self.inner.organization_configuration(inp);
            self
        }
        /// <p>Enables integration with Organizations for cross-account discovery.</p>
        pub fn set_organization_configuration(
            mut self,
            input: std::option::Option<crate::model::OrganizationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_organization_configuration(input);
            self
        }
        /// <p>Activates cross-account discovery.</p>
        pub fn enable_cross_accounts_discovery(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_cross_accounts_discovery(inp);
            self
        }
        /// <p>Activates cross-account discovery.</p>
        pub fn set_enable_cross_accounts_discovery(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_cross_accounts_discovery(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
