// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AcceptGrant`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_grant`](crate::client::Client::accept_grant).
///
/// See [`crate::client::fluent_builders::AcceptGrant`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptGrant {
    _private: (),
}
impl AcceptGrant {
    /// Creates a new builder-style object to manufacture [`AcceptGrantInput`](crate::input::AcceptGrantInput)
    pub fn builder() -> crate::input::accept_grant_input::Builder {
        crate::input::accept_grant_input::Builder::default()
    }
    /// Creates a new `AcceptGrant` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptGrant {
    type Output =
        std::result::Result<crate::output::AcceptGrantOutput, crate::error::AcceptGrantError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_grant_error(response)
        } else {
            crate::operation_deser::parse_accept_grant_response(response)
        }
    }
}

/// Operation shape for `CheckInLicense`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`check_in_license`](crate::client::Client::check_in_license).
///
/// See [`crate::client::fluent_builders::CheckInLicense`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CheckInLicense {
    _private: (),
}
impl CheckInLicense {
    /// Creates a new builder-style object to manufacture [`CheckInLicenseInput`](crate::input::CheckInLicenseInput)
    pub fn builder() -> crate::input::check_in_license_input::Builder {
        crate::input::check_in_license_input::Builder::default()
    }
    /// Creates a new `CheckInLicense` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CheckInLicense {
    type Output =
        std::result::Result<crate::output::CheckInLicenseOutput, crate::error::CheckInLicenseError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_check_in_license_error(response)
        } else {
            crate::operation_deser::parse_check_in_license_response(response)
        }
    }
}

/// Operation shape for `CheckoutBorrowLicense`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`checkout_borrow_license`](crate::client::Client::checkout_borrow_license).
///
/// See [`crate::client::fluent_builders::CheckoutBorrowLicense`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CheckoutBorrowLicense {
    _private: (),
}
impl CheckoutBorrowLicense {
    /// Creates a new builder-style object to manufacture [`CheckoutBorrowLicenseInput`](crate::input::CheckoutBorrowLicenseInput)
    pub fn builder() -> crate::input::checkout_borrow_license_input::Builder {
        crate::input::checkout_borrow_license_input::Builder::default()
    }
    /// Creates a new `CheckoutBorrowLicense` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CheckoutBorrowLicense {
    type Output = std::result::Result<
        crate::output::CheckoutBorrowLicenseOutput,
        crate::error::CheckoutBorrowLicenseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_checkout_borrow_license_error(response)
        } else {
            crate::operation_deser::parse_checkout_borrow_license_response(response)
        }
    }
}

/// Operation shape for `CheckoutLicense`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`checkout_license`](crate::client::Client::checkout_license).
///
/// See [`crate::client::fluent_builders::CheckoutLicense`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CheckoutLicense {
    _private: (),
}
impl CheckoutLicense {
    /// Creates a new builder-style object to manufacture [`CheckoutLicenseInput`](crate::input::CheckoutLicenseInput)
    pub fn builder() -> crate::input::checkout_license_input::Builder {
        crate::input::checkout_license_input::Builder::default()
    }
    /// Creates a new `CheckoutLicense` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CheckoutLicense {
    type Output = std::result::Result<
        crate::output::CheckoutLicenseOutput,
        crate::error::CheckoutLicenseError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_checkout_license_error(response)
        } else {
            crate::operation_deser::parse_checkout_license_response(response)
        }
    }
}

/// Operation shape for `CreateGrant`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_grant`](crate::client::Client::create_grant).
///
/// See [`crate::client::fluent_builders::CreateGrant`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGrant {
    _private: (),
}
impl CreateGrant {
    /// Creates a new builder-style object to manufacture [`CreateGrantInput`](crate::input::CreateGrantInput)
    pub fn builder() -> crate::input::create_grant_input::Builder {
        crate::input::create_grant_input::Builder::default()
    }
    /// Creates a new `CreateGrant` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGrant {
    type Output =
        std::result::Result<crate::output::CreateGrantOutput, crate::error::CreateGrantError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_grant_error(response)
        } else {
            crate::operation_deser::parse_create_grant_response(response)
        }
    }
}

/// Operation shape for `CreateGrantVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_grant_version`](crate::client::Client::create_grant_version).
///
/// See [`crate::client::fluent_builders::CreateGrantVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateGrantVersion {
    _private: (),
}
impl CreateGrantVersion {
    /// Creates a new builder-style object to manufacture [`CreateGrantVersionInput`](crate::input::CreateGrantVersionInput)
    pub fn builder() -> crate::input::create_grant_version_input::Builder {
        crate::input::create_grant_version_input::Builder::default()
    }
    /// Creates a new `CreateGrantVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateGrantVersion {
    type Output = std::result::Result<
        crate::output::CreateGrantVersionOutput,
        crate::error::CreateGrantVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_grant_version_error(response)
        } else {
            crate::operation_deser::parse_create_grant_version_response(response)
        }
    }
}

/// Operation shape for `CreateLicense`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_license`](crate::client::Client::create_license).
///
/// See [`crate::client::fluent_builders::CreateLicense`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLicense {
    _private: (),
}
impl CreateLicense {
    /// Creates a new builder-style object to manufacture [`CreateLicenseInput`](crate::input::CreateLicenseInput)
    pub fn builder() -> crate::input::create_license_input::Builder {
        crate::input::create_license_input::Builder::default()
    }
    /// Creates a new `CreateLicense` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLicense {
    type Output =
        std::result::Result<crate::output::CreateLicenseOutput, crate::error::CreateLicenseError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_license_error(response)
        } else {
            crate::operation_deser::parse_create_license_response(response)
        }
    }
}

/// Operation shape for `CreateLicenseConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_license_configuration`](crate::client::Client::create_license_configuration).
///
/// See [`crate::client::fluent_builders::CreateLicenseConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLicenseConfiguration {
    _private: (),
}
impl CreateLicenseConfiguration {
    /// Creates a new builder-style object to manufacture [`CreateLicenseConfigurationInput`](crate::input::CreateLicenseConfigurationInput)
    pub fn builder() -> crate::input::create_license_configuration_input::Builder {
        crate::input::create_license_configuration_input::Builder::default()
    }
    /// Creates a new `CreateLicenseConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLicenseConfiguration {
    type Output = std::result::Result<
        crate::output::CreateLicenseConfigurationOutput,
        crate::error::CreateLicenseConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_license_configuration_error(response)
        } else {
            crate::operation_deser::parse_create_license_configuration_response(response)
        }
    }
}

/// Operation shape for `CreateLicenseConversionTaskForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_license_conversion_task_for_resource`](crate::client::Client::create_license_conversion_task_for_resource).
///
/// See [`crate::client::fluent_builders::CreateLicenseConversionTaskForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLicenseConversionTaskForResource {
    _private: (),
}
impl CreateLicenseConversionTaskForResource {
    /// Creates a new builder-style object to manufacture [`CreateLicenseConversionTaskForResourceInput`](crate::input::CreateLicenseConversionTaskForResourceInput)
    pub fn builder() -> crate::input::create_license_conversion_task_for_resource_input::Builder {
        crate::input::create_license_conversion_task_for_resource_input::Builder::default()
    }
    /// Creates a new `CreateLicenseConversionTaskForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLicenseConversionTaskForResource {
    type Output = std::result::Result<
        crate::output::CreateLicenseConversionTaskForResourceOutput,
        crate::error::CreateLicenseConversionTaskForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_license_conversion_task_for_resource_error(
                response,
            )
        } else {
            crate::operation_deser::parse_create_license_conversion_task_for_resource_response(
                response,
            )
        }
    }
}

/// Operation shape for `CreateLicenseManagerReportGenerator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_license_manager_report_generator`](crate::client::Client::create_license_manager_report_generator).
///
/// See [`crate::client::fluent_builders::CreateLicenseManagerReportGenerator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLicenseManagerReportGenerator {
    _private: (),
}
impl CreateLicenseManagerReportGenerator {
    /// Creates a new builder-style object to manufacture [`CreateLicenseManagerReportGeneratorInput`](crate::input::CreateLicenseManagerReportGeneratorInput)
    pub fn builder() -> crate::input::create_license_manager_report_generator_input::Builder {
        crate::input::create_license_manager_report_generator_input::Builder::default()
    }
    /// Creates a new `CreateLicenseManagerReportGenerator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLicenseManagerReportGenerator {
    type Output = std::result::Result<
        crate::output::CreateLicenseManagerReportGeneratorOutput,
        crate::error::CreateLicenseManagerReportGeneratorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_license_manager_report_generator_error(response)
        } else {
            crate::operation_deser::parse_create_license_manager_report_generator_response(response)
        }
    }
}

/// Operation shape for `CreateLicenseVersion`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_license_version`](crate::client::Client::create_license_version).
///
/// See [`crate::client::fluent_builders::CreateLicenseVersion`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateLicenseVersion {
    _private: (),
}
impl CreateLicenseVersion {
    /// Creates a new builder-style object to manufacture [`CreateLicenseVersionInput`](crate::input::CreateLicenseVersionInput)
    pub fn builder() -> crate::input::create_license_version_input::Builder {
        crate::input::create_license_version_input::Builder::default()
    }
    /// Creates a new `CreateLicenseVersion` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateLicenseVersion {
    type Output = std::result::Result<
        crate::output::CreateLicenseVersionOutput,
        crate::error::CreateLicenseVersionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_license_version_error(response)
        } else {
            crate::operation_deser::parse_create_license_version_response(response)
        }
    }
}

/// Operation shape for `CreateToken`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_token`](crate::client::Client::create_token).
///
/// See [`crate::client::fluent_builders::CreateToken`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateToken {
    _private: (),
}
impl CreateToken {
    /// Creates a new builder-style object to manufacture [`CreateTokenInput`](crate::input::CreateTokenInput)
    pub fn builder() -> crate::input::create_token_input::Builder {
        crate::input::create_token_input::Builder::default()
    }
    /// Creates a new `CreateToken` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateToken {
    type Output =
        std::result::Result<crate::output::CreateTokenOutput, crate::error::CreateTokenError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_token_error(response)
        } else {
            crate::operation_deser::parse_create_token_response(response)
        }
    }
}

/// Operation shape for `DeleteGrant`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_grant`](crate::client::Client::delete_grant).
///
/// See [`crate::client::fluent_builders::DeleteGrant`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteGrant {
    _private: (),
}
impl DeleteGrant {
    /// Creates a new builder-style object to manufacture [`DeleteGrantInput`](crate::input::DeleteGrantInput)
    pub fn builder() -> crate::input::delete_grant_input::Builder {
        crate::input::delete_grant_input::Builder::default()
    }
    /// Creates a new `DeleteGrant` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteGrant {
    type Output =
        std::result::Result<crate::output::DeleteGrantOutput, crate::error::DeleteGrantError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_grant_error(response)
        } else {
            crate::operation_deser::parse_delete_grant_response(response)
        }
    }
}

/// Operation shape for `DeleteLicense`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_license`](crate::client::Client::delete_license).
///
/// See [`crate::client::fluent_builders::DeleteLicense`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLicense {
    _private: (),
}
impl DeleteLicense {
    /// Creates a new builder-style object to manufacture [`DeleteLicenseInput`](crate::input::DeleteLicenseInput)
    pub fn builder() -> crate::input::delete_license_input::Builder {
        crate::input::delete_license_input::Builder::default()
    }
    /// Creates a new `DeleteLicense` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLicense {
    type Output =
        std::result::Result<crate::output::DeleteLicenseOutput, crate::error::DeleteLicenseError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_license_error(response)
        } else {
            crate::operation_deser::parse_delete_license_response(response)
        }
    }
}

/// Operation shape for `DeleteLicenseConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_license_configuration`](crate::client::Client::delete_license_configuration).
///
/// See [`crate::client::fluent_builders::DeleteLicenseConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLicenseConfiguration {
    _private: (),
}
impl DeleteLicenseConfiguration {
    /// Creates a new builder-style object to manufacture [`DeleteLicenseConfigurationInput`](crate::input::DeleteLicenseConfigurationInput)
    pub fn builder() -> crate::input::delete_license_configuration_input::Builder {
        crate::input::delete_license_configuration_input::Builder::default()
    }
    /// Creates a new `DeleteLicenseConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLicenseConfiguration {
    type Output = std::result::Result<
        crate::output::DeleteLicenseConfigurationOutput,
        crate::error::DeleteLicenseConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_license_configuration_error(response)
        } else {
            crate::operation_deser::parse_delete_license_configuration_response(response)
        }
    }
}

/// Operation shape for `DeleteLicenseManagerReportGenerator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_license_manager_report_generator`](crate::client::Client::delete_license_manager_report_generator).
///
/// See [`crate::client::fluent_builders::DeleteLicenseManagerReportGenerator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteLicenseManagerReportGenerator {
    _private: (),
}
impl DeleteLicenseManagerReportGenerator {
    /// Creates a new builder-style object to manufacture [`DeleteLicenseManagerReportGeneratorInput`](crate::input::DeleteLicenseManagerReportGeneratorInput)
    pub fn builder() -> crate::input::delete_license_manager_report_generator_input::Builder {
        crate::input::delete_license_manager_report_generator_input::Builder::default()
    }
    /// Creates a new `DeleteLicenseManagerReportGenerator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteLicenseManagerReportGenerator {
    type Output = std::result::Result<
        crate::output::DeleteLicenseManagerReportGeneratorOutput,
        crate::error::DeleteLicenseManagerReportGeneratorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_license_manager_report_generator_error(response)
        } else {
            crate::operation_deser::parse_delete_license_manager_report_generator_response(response)
        }
    }
}

/// Operation shape for `DeleteToken`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_token`](crate::client::Client::delete_token).
///
/// See [`crate::client::fluent_builders::DeleteToken`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteToken {
    _private: (),
}
impl DeleteToken {
    /// Creates a new builder-style object to manufacture [`DeleteTokenInput`](crate::input::DeleteTokenInput)
    pub fn builder() -> crate::input::delete_token_input::Builder {
        crate::input::delete_token_input::Builder::default()
    }
    /// Creates a new `DeleteToken` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteToken {
    type Output =
        std::result::Result<crate::output::DeleteTokenOutput, crate::error::DeleteTokenError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_token_error(response)
        } else {
            crate::operation_deser::parse_delete_token_response(response)
        }
    }
}

/// Operation shape for `ExtendLicenseConsumption`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`extend_license_consumption`](crate::client::Client::extend_license_consumption).
///
/// See [`crate::client::fluent_builders::ExtendLicenseConsumption`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ExtendLicenseConsumption {
    _private: (),
}
impl ExtendLicenseConsumption {
    /// Creates a new builder-style object to manufacture [`ExtendLicenseConsumptionInput`](crate::input::ExtendLicenseConsumptionInput)
    pub fn builder() -> crate::input::extend_license_consumption_input::Builder {
        crate::input::extend_license_consumption_input::Builder::default()
    }
    /// Creates a new `ExtendLicenseConsumption` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ExtendLicenseConsumption {
    type Output = std::result::Result<
        crate::output::ExtendLicenseConsumptionOutput,
        crate::error::ExtendLicenseConsumptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_extend_license_consumption_error(response)
        } else {
            crate::operation_deser::parse_extend_license_consumption_response(response)
        }
    }
}

/// Operation shape for `GetAccessToken`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_access_token`](crate::client::Client::get_access_token).
///
/// See [`crate::client::fluent_builders::GetAccessToken`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAccessToken {
    _private: (),
}
impl GetAccessToken {
    /// Creates a new builder-style object to manufacture [`GetAccessTokenInput`](crate::input::GetAccessTokenInput)
    pub fn builder() -> crate::input::get_access_token_input::Builder {
        crate::input::get_access_token_input::Builder::default()
    }
    /// Creates a new `GetAccessToken` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAccessToken {
    type Output =
        std::result::Result<crate::output::GetAccessTokenOutput, crate::error::GetAccessTokenError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_access_token_error(response)
        } else {
            crate::operation_deser::parse_get_access_token_response(response)
        }
    }
}

/// Operation shape for `GetGrant`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_grant`](crate::client::Client::get_grant).
///
/// See [`crate::client::fluent_builders::GetGrant`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetGrant {
    _private: (),
}
impl GetGrant {
    /// Creates a new builder-style object to manufacture [`GetGrantInput`](crate::input::GetGrantInput)
    pub fn builder() -> crate::input::get_grant_input::Builder {
        crate::input::get_grant_input::Builder::default()
    }
    /// Creates a new `GetGrant` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetGrant {
    type Output = std::result::Result<crate::output::GetGrantOutput, crate::error::GetGrantError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_grant_error(response)
        } else {
            crate::operation_deser::parse_get_grant_response(response)
        }
    }
}

/// Operation shape for `GetLicense`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_license`](crate::client::Client::get_license).
///
/// See [`crate::client::fluent_builders::GetLicense`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLicense {
    _private: (),
}
impl GetLicense {
    /// Creates a new builder-style object to manufacture [`GetLicenseInput`](crate::input::GetLicenseInput)
    pub fn builder() -> crate::input::get_license_input::Builder {
        crate::input::get_license_input::Builder::default()
    }
    /// Creates a new `GetLicense` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLicense {
    type Output =
        std::result::Result<crate::output::GetLicenseOutput, crate::error::GetLicenseError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_license_error(response)
        } else {
            crate::operation_deser::parse_get_license_response(response)
        }
    }
}

/// Operation shape for `GetLicenseConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_license_configuration`](crate::client::Client::get_license_configuration).
///
/// See [`crate::client::fluent_builders::GetLicenseConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLicenseConfiguration {
    _private: (),
}
impl GetLicenseConfiguration {
    /// Creates a new builder-style object to manufacture [`GetLicenseConfigurationInput`](crate::input::GetLicenseConfigurationInput)
    pub fn builder() -> crate::input::get_license_configuration_input::Builder {
        crate::input::get_license_configuration_input::Builder::default()
    }
    /// Creates a new `GetLicenseConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLicenseConfiguration {
    type Output = std::result::Result<
        crate::output::GetLicenseConfigurationOutput,
        crate::error::GetLicenseConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_license_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_license_configuration_response(response)
        }
    }
}

/// Operation shape for `GetLicenseConversionTask`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_license_conversion_task`](crate::client::Client::get_license_conversion_task).
///
/// See [`crate::client::fluent_builders::GetLicenseConversionTask`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLicenseConversionTask {
    _private: (),
}
impl GetLicenseConversionTask {
    /// Creates a new builder-style object to manufacture [`GetLicenseConversionTaskInput`](crate::input::GetLicenseConversionTaskInput)
    pub fn builder() -> crate::input::get_license_conversion_task_input::Builder {
        crate::input::get_license_conversion_task_input::Builder::default()
    }
    /// Creates a new `GetLicenseConversionTask` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLicenseConversionTask {
    type Output = std::result::Result<
        crate::output::GetLicenseConversionTaskOutput,
        crate::error::GetLicenseConversionTaskError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_license_conversion_task_error(response)
        } else {
            crate::operation_deser::parse_get_license_conversion_task_response(response)
        }
    }
}

/// Operation shape for `GetLicenseManagerReportGenerator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_license_manager_report_generator`](crate::client::Client::get_license_manager_report_generator).
///
/// See [`crate::client::fluent_builders::GetLicenseManagerReportGenerator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLicenseManagerReportGenerator {
    _private: (),
}
impl GetLicenseManagerReportGenerator {
    /// Creates a new builder-style object to manufacture [`GetLicenseManagerReportGeneratorInput`](crate::input::GetLicenseManagerReportGeneratorInput)
    pub fn builder() -> crate::input::get_license_manager_report_generator_input::Builder {
        crate::input::get_license_manager_report_generator_input::Builder::default()
    }
    /// Creates a new `GetLicenseManagerReportGenerator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLicenseManagerReportGenerator {
    type Output = std::result::Result<
        crate::output::GetLicenseManagerReportGeneratorOutput,
        crate::error::GetLicenseManagerReportGeneratorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_license_manager_report_generator_error(response)
        } else {
            crate::operation_deser::parse_get_license_manager_report_generator_response(response)
        }
    }
}

/// Operation shape for `GetLicenseUsage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_license_usage`](crate::client::Client::get_license_usage).
///
/// See [`crate::client::fluent_builders::GetLicenseUsage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetLicenseUsage {
    _private: (),
}
impl GetLicenseUsage {
    /// Creates a new builder-style object to manufacture [`GetLicenseUsageInput`](crate::input::GetLicenseUsageInput)
    pub fn builder() -> crate::input::get_license_usage_input::Builder {
        crate::input::get_license_usage_input::Builder::default()
    }
    /// Creates a new `GetLicenseUsage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetLicenseUsage {
    type Output = std::result::Result<
        crate::output::GetLicenseUsageOutput,
        crate::error::GetLicenseUsageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_license_usage_error(response)
        } else {
            crate::operation_deser::parse_get_license_usage_response(response)
        }
    }
}

/// Operation shape for `GetServiceSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_service_settings`](crate::client::Client::get_service_settings).
///
/// See [`crate::client::fluent_builders::GetServiceSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetServiceSettings {
    _private: (),
}
impl GetServiceSettings {
    /// Creates a new builder-style object to manufacture [`GetServiceSettingsInput`](crate::input::GetServiceSettingsInput)
    pub fn builder() -> crate::input::get_service_settings_input::Builder {
        crate::input::get_service_settings_input::Builder::default()
    }
    /// Creates a new `GetServiceSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetServiceSettings {
    type Output = std::result::Result<
        crate::output::GetServiceSettingsOutput,
        crate::error::GetServiceSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_service_settings_error(response)
        } else {
            crate::operation_deser::parse_get_service_settings_response(response)
        }
    }
}

/// Operation shape for `ListAssociationsForLicenseConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_associations_for_license_configuration`](crate::client::Client::list_associations_for_license_configuration).
///
/// See [`crate::client::fluent_builders::ListAssociationsForLicenseConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAssociationsForLicenseConfiguration {
    _private: (),
}
impl ListAssociationsForLicenseConfiguration {
    /// Creates a new builder-style object to manufacture [`ListAssociationsForLicenseConfigurationInput`](crate::input::ListAssociationsForLicenseConfigurationInput)
    pub fn builder() -> crate::input::list_associations_for_license_configuration_input::Builder {
        crate::input::list_associations_for_license_configuration_input::Builder::default()
    }
    /// Creates a new `ListAssociationsForLicenseConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAssociationsForLicenseConfiguration {
    type Output = std::result::Result<
        crate::output::ListAssociationsForLicenseConfigurationOutput,
        crate::error::ListAssociationsForLicenseConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_associations_for_license_configuration_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_associations_for_license_configuration_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListDistributedGrants`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_distributed_grants`](crate::client::Client::list_distributed_grants).
///
/// See [`crate::client::fluent_builders::ListDistributedGrants`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDistributedGrants {
    _private: (),
}
impl ListDistributedGrants {
    /// Creates a new builder-style object to manufacture [`ListDistributedGrantsInput`](crate::input::ListDistributedGrantsInput)
    pub fn builder() -> crate::input::list_distributed_grants_input::Builder {
        crate::input::list_distributed_grants_input::Builder::default()
    }
    /// Creates a new `ListDistributedGrants` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDistributedGrants {
    type Output = std::result::Result<
        crate::output::ListDistributedGrantsOutput,
        crate::error::ListDistributedGrantsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_distributed_grants_error(response)
        } else {
            crate::operation_deser::parse_list_distributed_grants_response(response)
        }
    }
}

/// Operation shape for `ListFailuresForLicenseConfigurationOperations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_failures_for_license_configuration_operations`](crate::client::Client::list_failures_for_license_configuration_operations).
///
/// See [`crate::client::fluent_builders::ListFailuresForLicenseConfigurationOperations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFailuresForLicenseConfigurationOperations {
    _private: (),
}
impl ListFailuresForLicenseConfigurationOperations {
    /// Creates a new builder-style object to manufacture [`ListFailuresForLicenseConfigurationOperationsInput`](crate::input::ListFailuresForLicenseConfigurationOperationsInput)
    pub fn builder(
    ) -> crate::input::list_failures_for_license_configuration_operations_input::Builder {
        crate::input::list_failures_for_license_configuration_operations_input::Builder::default()
    }
    /// Creates a new `ListFailuresForLicenseConfigurationOperations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse
    for ListFailuresForLicenseConfigurationOperations
{
    type Output = std::result::Result<
        crate::output::ListFailuresForLicenseConfigurationOperationsOutput,
        crate::error::ListFailuresForLicenseConfigurationOperationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_failures_for_license_configuration_operations_error(
                response,
            )
        } else {
            crate::operation_deser::parse_list_failures_for_license_configuration_operations_response(response)
        }
    }
}

/// Operation shape for `ListLicenseConfigurations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_license_configurations`](crate::client::Client::list_license_configurations).
///
/// See [`crate::client::fluent_builders::ListLicenseConfigurations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLicenseConfigurations {
    _private: (),
}
impl ListLicenseConfigurations {
    /// Creates a new builder-style object to manufacture [`ListLicenseConfigurationsInput`](crate::input::ListLicenseConfigurationsInput)
    pub fn builder() -> crate::input::list_license_configurations_input::Builder {
        crate::input::list_license_configurations_input::Builder::default()
    }
    /// Creates a new `ListLicenseConfigurations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLicenseConfigurations {
    type Output = std::result::Result<
        crate::output::ListLicenseConfigurationsOutput,
        crate::error::ListLicenseConfigurationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_license_configurations_error(response)
        } else {
            crate::operation_deser::parse_list_license_configurations_response(response)
        }
    }
}

/// Operation shape for `ListLicenseConversionTasks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_license_conversion_tasks`](crate::client::Client::list_license_conversion_tasks).
///
/// See [`crate::client::fluent_builders::ListLicenseConversionTasks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLicenseConversionTasks {
    _private: (),
}
impl ListLicenseConversionTasks {
    /// Creates a new builder-style object to manufacture [`ListLicenseConversionTasksInput`](crate::input::ListLicenseConversionTasksInput)
    pub fn builder() -> crate::input::list_license_conversion_tasks_input::Builder {
        crate::input::list_license_conversion_tasks_input::Builder::default()
    }
    /// Creates a new `ListLicenseConversionTasks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLicenseConversionTasks {
    type Output = std::result::Result<
        crate::output::ListLicenseConversionTasksOutput,
        crate::error::ListLicenseConversionTasksError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_license_conversion_tasks_error(response)
        } else {
            crate::operation_deser::parse_list_license_conversion_tasks_response(response)
        }
    }
}

/// Operation shape for `ListLicenseManagerReportGenerators`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_license_manager_report_generators`](crate::client::Client::list_license_manager_report_generators).
///
/// See [`crate::client::fluent_builders::ListLicenseManagerReportGenerators`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLicenseManagerReportGenerators {
    _private: (),
}
impl ListLicenseManagerReportGenerators {
    /// Creates a new builder-style object to manufacture [`ListLicenseManagerReportGeneratorsInput`](crate::input::ListLicenseManagerReportGeneratorsInput)
    pub fn builder() -> crate::input::list_license_manager_report_generators_input::Builder {
        crate::input::list_license_manager_report_generators_input::Builder::default()
    }
    /// Creates a new `ListLicenseManagerReportGenerators` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLicenseManagerReportGenerators {
    type Output = std::result::Result<
        crate::output::ListLicenseManagerReportGeneratorsOutput,
        crate::error::ListLicenseManagerReportGeneratorsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_license_manager_report_generators_error(response)
        } else {
            crate::operation_deser::parse_list_license_manager_report_generators_response(response)
        }
    }
}

/// Operation shape for `ListLicenses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_licenses`](crate::client::Client::list_licenses).
///
/// See [`crate::client::fluent_builders::ListLicenses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLicenses {
    _private: (),
}
impl ListLicenses {
    /// Creates a new builder-style object to manufacture [`ListLicensesInput`](crate::input::ListLicensesInput)
    pub fn builder() -> crate::input::list_licenses_input::Builder {
        crate::input::list_licenses_input::Builder::default()
    }
    /// Creates a new `ListLicenses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLicenses {
    type Output =
        std::result::Result<crate::output::ListLicensesOutput, crate::error::ListLicensesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_licenses_error(response)
        } else {
            crate::operation_deser::parse_list_licenses_response(response)
        }
    }
}

/// Operation shape for `ListLicenseSpecificationsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_license_specifications_for_resource`](crate::client::Client::list_license_specifications_for_resource).
///
/// See [`crate::client::fluent_builders::ListLicenseSpecificationsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLicenseSpecificationsForResource {
    _private: (),
}
impl ListLicenseSpecificationsForResource {
    /// Creates a new builder-style object to manufacture [`ListLicenseSpecificationsForResourceInput`](crate::input::ListLicenseSpecificationsForResourceInput)
    pub fn builder() -> crate::input::list_license_specifications_for_resource_input::Builder {
        crate::input::list_license_specifications_for_resource_input::Builder::default()
    }
    /// Creates a new `ListLicenseSpecificationsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLicenseSpecificationsForResource {
    type Output = std::result::Result<
        crate::output::ListLicenseSpecificationsForResourceOutput,
        crate::error::ListLicenseSpecificationsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_license_specifications_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_license_specifications_for_resource_response(
                response,
            )
        }
    }
}

/// Operation shape for `ListLicenseVersions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_license_versions`](crate::client::Client::list_license_versions).
///
/// See [`crate::client::fluent_builders::ListLicenseVersions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListLicenseVersions {
    _private: (),
}
impl ListLicenseVersions {
    /// Creates a new builder-style object to manufacture [`ListLicenseVersionsInput`](crate::input::ListLicenseVersionsInput)
    pub fn builder() -> crate::input::list_license_versions_input::Builder {
        crate::input::list_license_versions_input::Builder::default()
    }
    /// Creates a new `ListLicenseVersions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListLicenseVersions {
    type Output = std::result::Result<
        crate::output::ListLicenseVersionsOutput,
        crate::error::ListLicenseVersionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_license_versions_error(response)
        } else {
            crate::operation_deser::parse_list_license_versions_response(response)
        }
    }
}

/// Operation shape for `ListReceivedGrants`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_received_grants`](crate::client::Client::list_received_grants).
///
/// See [`crate::client::fluent_builders::ListReceivedGrants`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListReceivedGrants {
    _private: (),
}
impl ListReceivedGrants {
    /// Creates a new builder-style object to manufacture [`ListReceivedGrantsInput`](crate::input::ListReceivedGrantsInput)
    pub fn builder() -> crate::input::list_received_grants_input::Builder {
        crate::input::list_received_grants_input::Builder::default()
    }
    /// Creates a new `ListReceivedGrants` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListReceivedGrants {
    type Output = std::result::Result<
        crate::output::ListReceivedGrantsOutput,
        crate::error::ListReceivedGrantsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_received_grants_error(response)
        } else {
            crate::operation_deser::parse_list_received_grants_response(response)
        }
    }
}

/// Operation shape for `ListReceivedLicenses`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_received_licenses`](crate::client::Client::list_received_licenses).
///
/// See [`crate::client::fluent_builders::ListReceivedLicenses`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListReceivedLicenses {
    _private: (),
}
impl ListReceivedLicenses {
    /// Creates a new builder-style object to manufacture [`ListReceivedLicensesInput`](crate::input::ListReceivedLicensesInput)
    pub fn builder() -> crate::input::list_received_licenses_input::Builder {
        crate::input::list_received_licenses_input::Builder::default()
    }
    /// Creates a new `ListReceivedLicenses` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListReceivedLicenses {
    type Output = std::result::Result<
        crate::output::ListReceivedLicensesOutput,
        crate::error::ListReceivedLicensesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_received_licenses_error(response)
        } else {
            crate::operation_deser::parse_list_received_licenses_response(response)
        }
    }
}

/// Operation shape for `ListResourceInventory`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_resource_inventory`](crate::client::Client::list_resource_inventory).
///
/// See [`crate::client::fluent_builders::ListResourceInventory`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListResourceInventory {
    _private: (),
}
impl ListResourceInventory {
    /// Creates a new builder-style object to manufacture [`ListResourceInventoryInput`](crate::input::ListResourceInventoryInput)
    pub fn builder() -> crate::input::list_resource_inventory_input::Builder {
        crate::input::list_resource_inventory_input::Builder::default()
    }
    /// Creates a new `ListResourceInventory` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListResourceInventory {
    type Output = std::result::Result<
        crate::output::ListResourceInventoryOutput,
        crate::error::ListResourceInventoryError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_resource_inventory_error(response)
        } else {
            crate::operation_deser::parse_list_resource_inventory_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ListTokens`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tokens`](crate::client::Client::list_tokens).
///
/// See [`crate::client::fluent_builders::ListTokens`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTokens {
    _private: (),
}
impl ListTokens {
    /// Creates a new builder-style object to manufacture [`ListTokensInput`](crate::input::ListTokensInput)
    pub fn builder() -> crate::input::list_tokens_input::Builder {
        crate::input::list_tokens_input::Builder::default()
    }
    /// Creates a new `ListTokens` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTokens {
    type Output =
        std::result::Result<crate::output::ListTokensOutput, crate::error::ListTokensError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tokens_error(response)
        } else {
            crate::operation_deser::parse_list_tokens_response(response)
        }
    }
}

/// Operation shape for `ListUsageForLicenseConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_usage_for_license_configuration`](crate::client::Client::list_usage_for_license_configuration).
///
/// See [`crate::client::fluent_builders::ListUsageForLicenseConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListUsageForLicenseConfiguration {
    _private: (),
}
impl ListUsageForLicenseConfiguration {
    /// Creates a new builder-style object to manufacture [`ListUsageForLicenseConfigurationInput`](crate::input::ListUsageForLicenseConfigurationInput)
    pub fn builder() -> crate::input::list_usage_for_license_configuration_input::Builder {
        crate::input::list_usage_for_license_configuration_input::Builder::default()
    }
    /// Creates a new `ListUsageForLicenseConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListUsageForLicenseConfiguration {
    type Output = std::result::Result<
        crate::output::ListUsageForLicenseConfigurationOutput,
        crate::error::ListUsageForLicenseConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_usage_for_license_configuration_error(response)
        } else {
            crate::operation_deser::parse_list_usage_for_license_configuration_response(response)
        }
    }
}

/// Operation shape for `RejectGrant`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reject_grant`](crate::client::Client::reject_grant).
///
/// See [`crate::client::fluent_builders::RejectGrant`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RejectGrant {
    _private: (),
}
impl RejectGrant {
    /// Creates a new builder-style object to manufacture [`RejectGrantInput`](crate::input::RejectGrantInput)
    pub fn builder() -> crate::input::reject_grant_input::Builder {
        crate::input::reject_grant_input::Builder::default()
    }
    /// Creates a new `RejectGrant` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RejectGrant {
    type Output =
        std::result::Result<crate::output::RejectGrantOutput, crate::error::RejectGrantError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reject_grant_error(response)
        } else {
            crate::operation_deser::parse_reject_grant_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateLicenseConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_license_configuration`](crate::client::Client::update_license_configuration).
///
/// See [`crate::client::fluent_builders::UpdateLicenseConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateLicenseConfiguration {
    _private: (),
}
impl UpdateLicenseConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateLicenseConfigurationInput`](crate::input::UpdateLicenseConfigurationInput)
    pub fn builder() -> crate::input::update_license_configuration_input::Builder {
        crate::input::update_license_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateLicenseConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateLicenseConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateLicenseConfigurationOutput,
        crate::error::UpdateLicenseConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_license_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_license_configuration_response(response)
        }
    }
}

/// Operation shape for `UpdateLicenseManagerReportGenerator`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_license_manager_report_generator`](crate::client::Client::update_license_manager_report_generator).
///
/// See [`crate::client::fluent_builders::UpdateLicenseManagerReportGenerator`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateLicenseManagerReportGenerator {
    _private: (),
}
impl UpdateLicenseManagerReportGenerator {
    /// Creates a new builder-style object to manufacture [`UpdateLicenseManagerReportGeneratorInput`](crate::input::UpdateLicenseManagerReportGeneratorInput)
    pub fn builder() -> crate::input::update_license_manager_report_generator_input::Builder {
        crate::input::update_license_manager_report_generator_input::Builder::default()
    }
    /// Creates a new `UpdateLicenseManagerReportGenerator` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateLicenseManagerReportGenerator {
    type Output = std::result::Result<
        crate::output::UpdateLicenseManagerReportGeneratorOutput,
        crate::error::UpdateLicenseManagerReportGeneratorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_license_manager_report_generator_error(response)
        } else {
            crate::operation_deser::parse_update_license_manager_report_generator_response(response)
        }
    }
}

/// Operation shape for `UpdateLicenseSpecificationsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_license_specifications_for_resource`](crate::client::Client::update_license_specifications_for_resource).
///
/// See [`crate::client::fluent_builders::UpdateLicenseSpecificationsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateLicenseSpecificationsForResource {
    _private: (),
}
impl UpdateLicenseSpecificationsForResource {
    /// Creates a new builder-style object to manufacture [`UpdateLicenseSpecificationsForResourceInput`](crate::input::UpdateLicenseSpecificationsForResourceInput)
    pub fn builder() -> crate::input::update_license_specifications_for_resource_input::Builder {
        crate::input::update_license_specifications_for_resource_input::Builder::default()
    }
    /// Creates a new `UpdateLicenseSpecificationsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateLicenseSpecificationsForResource {
    type Output = std::result::Result<
        crate::output::UpdateLicenseSpecificationsForResourceOutput,
        crate::error::UpdateLicenseSpecificationsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_license_specifications_for_resource_error(response)
        } else {
            crate::operation_deser::parse_update_license_specifications_for_resource_response(
                response,
            )
        }
    }
}

/// Operation shape for `UpdateServiceSettings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_service_settings`](crate::client::Client::update_service_settings).
///
/// See [`crate::client::fluent_builders::UpdateServiceSettings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateServiceSettings {
    _private: (),
}
impl UpdateServiceSettings {
    /// Creates a new builder-style object to manufacture [`UpdateServiceSettingsInput`](crate::input::UpdateServiceSettingsInput)
    pub fn builder() -> crate::input::update_service_settings_input::Builder {
        crate::input::update_service_settings_input::Builder::default()
    }
    /// Creates a new `UpdateServiceSettings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateServiceSettings {
    type Output = std::result::Result<
        crate::output::UpdateServiceSettingsOutput,
        crate::error::UpdateServiceSettingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_service_settings_error(response)
        } else {
            crate::operation_deser::parse_update_service_settings_response(response)
        }
    }
}
